// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e20106){var e = e20106;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__20107_SHARP_){
var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__20107_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__20107_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__20107_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20108_SHARP_){
return cljs.core.conj.call(null,p1__20108_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20109_SHARP_){
return cljs.core.conj.call(null,p1__20109_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4251__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4253__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20114 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__20114,(0),null);
var _ = cljs.core.nth.call(null,vec__20114,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20110_SHARP_){
return cljs.core.conj.call(null,p1__20110_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4251__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4251__auto__;
}
})())){
var vec__20117 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__20117,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__20117,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4253__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20111_SHARP_){
return cljs.core.conj.call(null,p1__20111_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20112_SHARP_){
return cljs.core.conj.call(null,p1__20112_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20113_SHARP_){
return cljs.core.conj.call(null,p1__20113_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__20120_SHARP_){
return cljs.core.nth.call(null,array,p1__20120_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4253__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (add_amount > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fuel;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4251__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5751__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20123,optional_QMARK_,fuel,max_fuel){
var map__20124 = p__20123;
var map__20124__$1 = cljs.core.__destructure_map.call(null,map__20124);
var res = map__20124__$1;
var vars = cljs.core.get.call(null,map__20124__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20190){
var state_val_20191 = (state_20190[(1)]);
if((state_val_20191 === (7))){
var inst_20179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20180 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_20181 = cljs.core.conj.call(null,inst_20180,clause);
var inst_20182 = [null,inst_20181];
var inst_20183 = (new cljs.core.PersistentVector(null,2,(5),inst_20179,inst_20182,null));
var state_20190__$1 = state_20190;
var statearr_20192_20220 = state_20190__$1;
(statearr_20192_20220[(2)] = inst_20183);

(statearr_20192_20220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (1))){
var state_20190__$1 = state_20190;
var statearr_20193_20221 = state_20190__$1;
(statearr_20193_20221[(2)] = null);

(statearr_20193_20221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (4))){
var inst_20125 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20194_20222 = state_20190__$1;
(statearr_20194_20222[(2)] = inst_20125);

(statearr_20194_20222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (15))){
var inst_20168 = (state_20190[(2)]);
var inst_20169 = fluree.db.util.async.throw_err.call(null,inst_20168);
var inst_20170 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20169);
var inst_20171 = cljs.core.count.call(null,inst_20170);
var inst_20172 = fluree.db.query.analytical.add_fuel.call(null,inst_20171,fuel,max_fuel);
var inst_20173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20174 = [inst_20169,r];
var inst_20175 = (new cljs.core.PersistentVector(null,2,(5),inst_20173,inst_20174,null));
var state_20190__$1 = (function (){var statearr_20195 = state_20190;
(statearr_20195[(7)] = inst_20172);

return statearr_20195;
})();
var statearr_20196_20223 = state_20190__$1;
(statearr_20196_20223[(2)] = inst_20175);

(statearr_20196_20223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (13))){
var inst_20134 = (state_20190[(8)]);
var inst_20147 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20148 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_20147);
var inst_20149 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20134);
var inst_20150 = cljs.core.apply.call(null,cljs.core.concat,inst_20149);
var inst_20151 = cljs.core.set.call(null,inst_20150);
var inst_20152 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_20148);
var inst_20153 = cljs.core.apply.call(null,cljs.core.concat,inst_20152);
var inst_20154 = cljs.core.into.call(null,inst_20151,inst_20153);
var inst_20155 = (function (){var all_wd = inst_20134;
var optional = inst_20148;
var all_wd_vars = inst_20151;
var all_vars = inst_20154;
return (function (p1__20121_SHARP_){
return all_vars.call(null,p1__20121_SHARP_);
});
})();
var inst_20156 = cljs.core.keys.call(null,vars);
var inst_20157 = cljs.core.map.call(null,inst_20155,inst_20156);
var inst_20158 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_20157);
var inst_20159 = cljs.core.set.call(null,inst_20158);
var inst_20160 = (function (){var all_wd = inst_20134;
var optional = inst_20148;
var all_wd_vars = inst_20151;
var all_vars = inst_20154;
var intersecting_vars = inst_20159;
return (function (p1__20122_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__20122_SHARP_);
});
})();
var inst_20161 = cljs.core.map.call(null,inst_20160,inst_20134);
var inst_20162 = cljs.core.apply.call(null,cljs.core.concat,inst_20161);
var inst_20163 = fluree.db.query.analytical.select_from_tuples.call(null,inst_20162,res);
var inst_20164 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_20134,inst_20159,vars);
var inst_20165 = cljs.core.remove.call(null,inst_20159,inst_20154);
var inst_20166 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_20164,inst_20162,inst_20163,inst_20165,inst_20148);
var state_20190__$1 = state_20190;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20190__$1,(15),inst_20166);
} else {
if((state_val_20191 === (6))){
var inst_20135 = (state_20190[(9)]);
var inst_20133 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20134 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_20133);
var inst_20135__$1 = optional_QMARK_;
var state_20190__$1 = (function (){var statearr_20197 = state_20190;
(statearr_20197[(8)] = inst_20134);

(statearr_20197[(9)] = inst_20135__$1);

return statearr_20197;
})();
if(cljs.core.truth_(inst_20135__$1)){
var statearr_20198_20224 = state_20190__$1;
(statearr_20198_20224[(1)] = (9));

} else {
var statearr_20199_20225 = state_20190__$1;
(statearr_20199_20225[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (3))){
var inst_20188 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20190__$1,inst_20188);
} else {
if((state_val_20191 === (12))){
var inst_20143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20144 = [null,r];
var inst_20145 = (new cljs.core.PersistentVector(null,2,(5),inst_20143,inst_20144,null));
var state_20190__$1 = state_20190;
var statearr_20200_20226 = state_20190__$1;
(statearr_20200_20226[(2)] = inst_20145);

(statearr_20200_20226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (2))){
var _ = (function (){var statearr_20201 = state_20190;
(statearr_20201[(4)] = cljs.core.cons.call(null,(5),(state_20190[(4)])));

return statearr_20201;
})();
var inst_20131 = (r == null);
var state_20190__$1 = state_20190;
if(cljs.core.truth_(inst_20131)){
var statearr_20202_20227 = state_20190__$1;
(statearr_20202_20227[(1)] = (6));

} else {
var statearr_20203_20228 = state_20190__$1;
(statearr_20203_20228[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (11))){
var inst_20141 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
if(cljs.core.truth_(inst_20141)){
var statearr_20205_20229 = state_20190__$1;
(statearr_20205_20229[(1)] = (12));

} else {
var statearr_20206_20230 = state_20190__$1;
(statearr_20206_20230[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (9))){
var inst_20134 = (state_20190[(8)]);
var inst_20137 = cljs.core.empty_QMARK_.call(null,inst_20134);
var inst_20138 = (!(inst_20137));
var state_20190__$1 = state_20190;
var statearr_20207_20231 = state_20190__$1;
(statearr_20207_20231[(2)] = inst_20138);

(statearr_20207_20231[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (5))){
var _ = (function (){var statearr_20208 = state_20190;
(statearr_20208[(4)] = cljs.core.rest.call(null,(state_20190[(4)])));

return statearr_20208;
})();
var state_20190__$1 = state_20190;
var ex20204 = (state_20190__$1[(2)]);
var statearr_20209_20232 = state_20190__$1;
(statearr_20209_20232[(5)] = ex20204);


if((ex20204 instanceof Error)){
var statearr_20210_20233 = state_20190__$1;
(statearr_20210_20233[(1)] = (4));

(statearr_20210_20233[(5)] = null);

} else {
throw ex20204;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (14))){
var inst_20177 = (state_20190[(2)]);
var state_20190__$1 = state_20190;
var statearr_20211_20234 = state_20190__$1;
(statearr_20211_20234[(2)] = inst_20177);

(statearr_20211_20234[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (10))){
var inst_20135 = (state_20190[(9)]);
var state_20190__$1 = state_20190;
var statearr_20212_20235 = state_20190__$1;
(statearr_20212_20235[(2)] = inst_20135);

(statearr_20212_20235[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20191 === (8))){
var inst_20185 = (state_20190[(2)]);
var _ = (function (){var statearr_20213 = state_20190;
(statearr_20213[(4)] = cljs.core.rest.call(null,(state_20190[(4)])));

return statearr_20213;
})();
var state_20190__$1 = state_20190;
var statearr_20214_20236 = state_20190__$1;
(statearr_20214_20236[(2)] = inst_20185);

(statearr_20214_20236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20215 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20215[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__);

(statearr_20215[(1)] = (1));

return statearr_20215;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20190){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20190);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20216){var ex__2749__auto__ = e20216;
var statearr_20217_20237 = state_20190;
(statearr_20217_20237[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20190[(4)]))){
var statearr_20218_20238 = state_20190;
(statearr_20218_20238[(1)] = cljs.core.first.call(null,(state_20190[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20239 = state_20190;
state_20190 = G__20239;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__ = function(state_20190){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20219 = f__2769__auto__.call(null);
(statearr_20219[(6)] = c__2768__auto__);

return statearr_20219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20241 = arguments.length;
switch (G__20241) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20335){
var state_val_20336 = (state_20335[(1)]);
if((state_val_20336 === (7))){
var inst_20248 = (state_20335[(7)]);
var inst_20258 = clojure.string.starts_with_QMARK_.call(null,inst_20248,"$fdb");
var state_20335__$1 = state_20335;
if(inst_20258){
var statearr_20337_20386 = state_20335__$1;
(statearr_20337_20386[(1)] = (9));

} else {
var statearr_20338_20387 = state_20335__$1;
(statearr_20338_20387[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (20))){
var state_20335__$1 = state_20335;
var statearr_20339_20388 = state_20335__$1;
(statearr_20339_20388[(2)] = null);

(statearr_20339_20388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (27))){
var inst_20298 = (state_20335[(8)]);
var state_20335__$1 = state_20335;
var statearr_20340_20389 = state_20335__$1;
(statearr_20340_20389[(2)] = inst_20298);

(statearr_20340_20389[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (1))){
var state_20335__$1 = state_20335;
var statearr_20341_20390 = state_20335__$1;
(statearr_20341_20390[(2)] = null);

(statearr_20341_20390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (24))){
var inst_20321 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
var statearr_20342_20391 = state_20335__$1;
(statearr_20342_20391[(2)] = inst_20321);

(statearr_20342_20391[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (4))){
var inst_20242 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
var statearr_20343_20392 = state_20335__$1;
(statearr_20343_20392[(2)] = inst_20242);

(statearr_20343_20392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (15))){
var inst_20265 = (state_20335[(9)]);
var inst_20271 = (state_20335[(2)]);
var inst_20272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20273 = cljs.core.PersistentVector.EMPTY;
var inst_20274 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20275 = cljs.core.into.call(null,inst_20273,inst_20274);
var inst_20276 = [inst_20265,inst_20275];
var inst_20277 = (new cljs.core.PersistentVector(null,2,(5),inst_20272,inst_20276,null));
var state_20335__$1 = (function (){var statearr_20344 = state_20335;
(statearr_20344[(10)] = inst_20271);

return statearr_20344;
})();
var statearr_20345_20393 = state_20335__$1;
(statearr_20345_20393[(2)] = inst_20277);

(statearr_20345_20393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (21))){
var inst_20324 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
var statearr_20346_20394 = state_20335__$1;
(statearr_20346_20394[(2)] = inst_20324);

(statearr_20346_20394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (13))){
var inst_20265 = (state_20335[(9)]);
var inst_20268 = (function(){throw inst_20265})();
var state_20335__$1 = state_20335;
var statearr_20347_20395 = state_20335__$1;
(statearr_20347_20395[(2)] = inst_20268);

(statearr_20347_20395[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (22))){
var inst_20287 = (state_20335[(11)]);
var inst_20289 = (state_20335[(12)]);
var inst_20291 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20287);
var inst_20292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20293 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20289];
var inst_20294 = (new cljs.core.PersistentVector(null,2,(5),inst_20292,inst_20293,null));
var inst_20295 = cljs.core.get_in.call(null,opts,inst_20294);
var state_20335__$1 = (function (){var statearr_20348 = state_20335;
(statearr_20348[(13)] = inst_20291);

return statearr_20348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20335__$1,(25),inst_20295);
} else {
if((state_val_20336 === (29))){
var inst_20302 = (state_20335[(2)]);
var inst_20303 = fluree.db.util.async.throw_err.call(null,inst_20302);
var state_20335__$1 = state_20335;
var statearr_20349_20396 = state_20335__$1;
(statearr_20349_20396[(2)] = inst_20303);

(statearr_20349_20396[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (6))){
var inst_20251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20252 = cljs.core.PersistentVector.EMPTY;
var inst_20253 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20254 = cljs.core.into.call(null,inst_20252,inst_20253);
var inst_20255 = [db,inst_20254];
var inst_20256 = (new cljs.core.PersistentVector(null,2,(5),inst_20251,inst_20255,null));
var state_20335__$1 = state_20335;
var statearr_20350_20397 = state_20335__$1;
(statearr_20350_20397[(2)] = inst_20256);

(statearr_20350_20397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (28))){
var inst_20306 = (state_20335[(2)]);
var inst_20307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20308 = cljs.core.PersistentVector.EMPTY;
var inst_20309 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_20310 = cljs.core.into.call(null,inst_20308,inst_20309);
var inst_20311 = [inst_20306,inst_20310];
var inst_20312 = (new cljs.core.PersistentVector(null,2,(5),inst_20307,inst_20311,null));
var state_20335__$1 = state_20335;
var statearr_20351_20398 = state_20335__$1;
(statearr_20351_20398[(2)] = inst_20312);

(statearr_20351_20398[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (25))){
var inst_20291 = (state_20335[(13)]);
var inst_20297 = (state_20335[(2)]);
var inst_20298 = fluree.db.util.async.throw_err.call(null,inst_20297);
var state_20335__$1 = (function (){var statearr_20352 = state_20335;
(statearr_20352[(8)] = inst_20298);

return statearr_20352;
})();
if(cljs.core.truth_(inst_20291)){
var statearr_20353_20399 = state_20335__$1;
(statearr_20353_20399[(1)] = (26));

} else {
var statearr_20354_20400 = state_20335__$1;
(statearr_20354_20400[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (17))){
var state_20335__$1 = state_20335;
var statearr_20355_20401 = state_20335__$1;
(statearr_20355_20401[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (3))){
var inst_20333 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20335__$1,inst_20333);
} else {
if((state_val_20336 === (12))){
var inst_20265 = (state_20335[(9)]);
var inst_20264 = (state_20335[(2)]);
var inst_20265__$1 = fluree.db.util.async.throw_err.call(null,inst_20264);
var inst_20266 = fluree.db.util.core.exception_QMARK_.call(null,inst_20265__$1);
var state_20335__$1 = (function (){var statearr_20357 = state_20335;
(statearr_20357[(9)] = inst_20265__$1);

return statearr_20357;
})();
if(inst_20266){
var statearr_20358_20402 = state_20335__$1;
(statearr_20358_20402[(1)] = (13));

} else {
var statearr_20359_20403 = state_20335__$1;
(statearr_20359_20403[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (2))){
var inst_20248 = (state_20335[(7)]);
var _ = (function (){var statearr_20360 = state_20335;
(statearr_20360[(4)] = cljs.core.cons.call(null,(5),(state_20335[(4)])));

return statearr_20360;
})();
var inst_20248__$1 = cljs.core.first.call(null,clause);
var inst_20249 = cljs.core._EQ_.call(null,"$fdb",inst_20248__$1);
var state_20335__$1 = (function (){var statearr_20361 = state_20335;
(statearr_20361[(7)] = inst_20248__$1);

return statearr_20361;
})();
if(inst_20249){
var statearr_20362_20404 = state_20335__$1;
(statearr_20362_20404[(1)] = (6));

} else {
var statearr_20363_20405 = state_20335__$1;
(statearr_20363_20405[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (23))){
var inst_20248 = (state_20335[(7)]);
var inst_20314 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20248)," is not supported in Fluree"].join('');
var inst_20315 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20316 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20317 = cljs.core.PersistentHashMap.fromArrays(inst_20315,inst_20316);
var inst_20318 = cljs.core.ex_info.call(null,inst_20314,inst_20317);
var inst_20319 = (function(){throw inst_20318})();
var state_20335__$1 = state_20335;
var statearr_20364_20406 = state_20335__$1;
(statearr_20364_20406[(2)] = inst_20319);

(statearr_20364_20406[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (19))){
var inst_20248 = (state_20335[(7)]);
var inst_20289 = (state_20335[(12)]);
var inst_20286 = fluree.db.query.analytical.isolate_source_name.call(null,inst_20248);
var inst_20287 = fluree.db.query.analytical.isolate_source_block.call(null,inst_20248);
var inst_20288 = cljs.core.keyword.call(null,inst_20286);
var inst_20289__$1 = cljs.core.get.call(null,prefixes,inst_20288);
var state_20335__$1 = (function (){var statearr_20365 = state_20335;
(statearr_20365[(11)] = inst_20287);

(statearr_20365[(12)] = inst_20289__$1);

return statearr_20365;
})();
if(cljs.core.truth_(inst_20289__$1)){
var statearr_20366_20407 = state_20335__$1;
(statearr_20366_20407[(1)] = (22));

} else {
var statearr_20367_20408 = state_20335__$1;
(statearr_20367_20408[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (11))){
var inst_20328 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
var statearr_20369_20409 = state_20335__$1;
(statearr_20369_20409[(2)] = inst_20328);

(statearr_20369_20409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (9))){
var inst_20248 = (state_20335[(7)]);
var inst_20260 = cljs.core.subs.call(null,inst_20248,(4));
var inst_20261 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_20260);
var inst_20262 = fluree.db.time_travel.as_of_block.call(null,db,inst_20261);
var state_20335__$1 = state_20335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20335__$1,(12),inst_20262);
} else {
if((state_val_20336 === (5))){
var _ = (function (){var statearr_20370 = state_20335;
(statearr_20370[(4)] = cljs.core.rest.call(null,(state_20335[(4)])));

return statearr_20370;
})();
var state_20335__$1 = state_20335;
var ex20368 = (state_20335__$1[(2)]);
var statearr_20371_20410 = state_20335__$1;
(statearr_20371_20410[(5)] = ex20368);


if((ex20368 instanceof Error)){
var statearr_20372_20411 = state_20335__$1;
(statearr_20372_20411[(1)] = (4));

(statearr_20372_20411[(5)] = null);

} else {
throw ex20368;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (14))){
var state_20335__$1 = state_20335;
var statearr_20373_20412 = state_20335__$1;
(statearr_20373_20412[(2)] = null);

(statearr_20373_20412[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (26))){
var inst_20291 = (state_20335[(13)]);
var inst_20298 = (state_20335[(8)]);
var inst_20300 = fluree.db.time_travel.as_of_block.call(null,inst_20298,inst_20291);
var state_20335__$1 = state_20335;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20335__$1,(29),inst_20300);
} else {
if((state_val_20336 === (16))){
var inst_20281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20282 = ["$wd",clause];
var inst_20283 = (new cljs.core.PersistentVector(null,2,(5),inst_20281,inst_20282,null));
var state_20335__$1 = state_20335;
var statearr_20374_20413 = state_20335__$1;
(statearr_20374_20413[(2)] = inst_20283);

(statearr_20374_20413[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (10))){
var inst_20248 = (state_20335[(7)]);
var inst_20279 = cljs.core._EQ_.call(null,"$wd",inst_20248);
var state_20335__$1 = state_20335;
if(inst_20279){
var statearr_20375_20414 = state_20335__$1;
(statearr_20375_20414[(1)] = (16));

} else {
var statearr_20376_20415 = state_20335__$1;
(statearr_20376_20415[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (18))){
var inst_20326 = (state_20335[(2)]);
var state_20335__$1 = state_20335;
var statearr_20377_20416 = state_20335__$1;
(statearr_20377_20416[(2)] = inst_20326);

(statearr_20377_20416[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20336 === (8))){
var inst_20330 = (state_20335[(2)]);
var _ = (function (){var statearr_20378 = state_20335;
(statearr_20378[(4)] = cljs.core.rest.call(null,(state_20335[(4)])));

return statearr_20378;
})();
var state_20335__$1 = state_20335;
var statearr_20379_20417 = state_20335__$1;
(statearr_20379_20417[(2)] = inst_20330);

(statearr_20379_20417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_20380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20380[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_20380[(1)] = (1));

return statearr_20380;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_20335){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20335);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20381){var ex__2749__auto__ = e20381;
var statearr_20382_20418 = state_20335;
(statearr_20382_20418[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20335[(4)]))){
var statearr_20383_20419 = state_20335;
(statearr_20383_20419[(1)] = cljs.core.first.call(null,(state_20335[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20420 = state_20335;
state_20335 = G__20420;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_20335){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_20335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20384 = f__2769__auto__.call(null);
(statearr_20384[(6)] = c__2768__auto__);

return statearr_20384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__20421){
var vec__20422 = p__20421;
var sub = cljs.core.nth.call(null,vec__20422,(0),null);
var obj = cljs.core.nth.call(null,vec__20422,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__20425_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__20425_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__20429 = subjects;
var vec__20430 = G__20429;
var seq__20431 = cljs.core.seq.call(null,vec__20430);
var first__20432 = cljs.core.first.call(null,seq__20431);
var seq__20431__$1 = cljs.core.next.call(null,seq__20431);
var subject = first__20432;
var r = seq__20431__$1;
var acc = expanded_map;
var G__20429__$1 = G__20429;
var acc__$1 = acc;
while(true){
var vec__20436 = G__20429__$1;
var seq__20437 = cljs.core.seq.call(null,vec__20436);
var first__20438 = cljs.core.first.call(null,seq__20437);
var seq__20437__$1 = cljs.core.next.call(null,seq__20437);
var subject__$1 = first__20438;
var r__$1 = seq__20437__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20439 = r__$1;
var G__20440 = acc__$2;
G__20429__$1 = G__20439;
acc__$1 = G__20440;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__20429__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4253__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20429__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20429__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20429__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__20429__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20429__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20436,seq__20437,first__20438,seq__20437__$1,subject__$1,r__$1,acc__$2,G__20429,vec__20430,seq__20431,first__20432,seq__20431__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20441 = r__$1;
var G__20442 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20429__$1 = G__20441;
acc__$1 = G__20442;
continue;
} else {
var G__20443 = subjects;
var G__20444 = acc_STAR_;
G__20429__$1 = G__20443;
acc__$1 = G__20444;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__20445_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20445_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20536){
var state_val_20537 = (state_20536[(1)]);
if((state_val_20537 === (7))){
var state_20536__$1 = state_20536;
var statearr_20538_20584 = state_20536__$1;
(statearr_20538_20584[(2)] = (100));

(statearr_20538_20584[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (20))){
var inst_20485 = (state_20536[(7)]);
var state_20536__$1 = state_20536;
var statearr_20539_20585 = state_20536__$1;
(statearr_20539_20585[(2)] = inst_20485);

(statearr_20539_20585[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (1))){
var state_20536__$1 = state_20536;
var statearr_20540_20586 = state_20536__$1;
(statearr_20540_20586[(2)] = null);

(statearr_20540_20586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (24))){
var inst_20523 = (state_20536[(8)]);
var inst_20522 = (state_20536[(9)]);
var inst_20524 = (state_20536[(10)]);
var inst_20457 = (state_20536[(11)]);
var inst_20527 = (function (){var max_depth = inst_20457;
var recur_map__$1 = inst_20523;
var subjects = inst_20522;
var tuples = inst_20524;
return (function (p1__20446_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__20446_SHARP_)],null));
});
})();
var inst_20528 = cljs.core.map.call(null,inst_20527,inst_20524);
var inst_20529 = cljs.core.distinct.call(null,inst_20528);
var state_20536__$1 = state_20536;
var statearr_20541_20587 = state_20536__$1;
(statearr_20541_20587[(2)] = inst_20529);

(statearr_20541_20587[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (4))){
var inst_20447 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20542_20588 = state_20536__$1;
(statearr_20542_20588[(2)] = inst_20447);

(statearr_20542_20588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (15))){
var inst_20470 = (state_20536[(12)]);
var inst_20481 = cljs.core.PersistentVector.EMPTY;
var inst_20482 = cljs.core.seq.call(null,inst_20470);
var inst_20483 = cljs.core.first.call(null,inst_20482);
var inst_20484 = cljs.core.next.call(null,inst_20482);
var inst_20485 = inst_20481;
var inst_20486 = inst_20470;
var state_20536__$1 = (function (){var statearr_20543 = state_20536;
(statearr_20543[(7)] = inst_20485);

(statearr_20543[(13)] = inst_20483);

(statearr_20543[(14)] = inst_20484);

(statearr_20543[(15)] = inst_20486);

return statearr_20543;
})();
var statearr_20544_20589 = state_20536__$1;
(statearr_20544_20589[(2)] = null);

(statearr_20544_20589[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (21))){
var inst_20506 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20545_20590 = state_20536__$1;
(statearr_20545_20590[(2)] = inst_20506);

(statearr_20545_20590[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (13))){
var inst_20519 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20546_20591 = state_20536__$1;
(statearr_20546_20591[(2)] = inst_20519);

(statearr_20546_20591[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (22))){
var inst_20485 = (state_20536[(7)]);
var inst_20493 = (state_20536[(16)]);
var inst_20500 = (state_20536[(2)]);
var inst_20501 = fluree.db.util.async.throw_err.call(null,inst_20500);
var inst_20502 = cljs.core.concat.call(null,inst_20485,inst_20501);
var inst_20485__$1 = inst_20502;
var inst_20486 = inst_20493;
var state_20536__$1 = (function (){var statearr_20547 = state_20536;
(statearr_20547[(7)] = inst_20485__$1);

(statearr_20547[(15)] = inst_20486);

return statearr_20547;
})();
var statearr_20548_20592 = state_20536__$1;
(statearr_20548_20592[(2)] = null);

(statearr_20548_20592[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (6))){
var inst_20453 = (state_20536[(17)]);
var state_20536__$1 = state_20536;
var statearr_20549_20593 = state_20536__$1;
(statearr_20549_20593[(2)] = inst_20453);

(statearr_20549_20593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (25))){
var inst_20531 = (state_20536[(2)]);
var _ = (function (){var statearr_20550 = state_20536;
(statearr_20550[(4)] = cljs.core.rest.call(null,(state_20536[(4)])));

return statearr_20550;
})();
var state_20536__$1 = state_20536;
var statearr_20551_20594 = state_20536__$1;
(statearr_20551_20594[(2)] = inst_20531);

(statearr_20551_20594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (17))){
var inst_20492 = (state_20536[(18)]);
var inst_20486 = (state_20536[(15)]);
var inst_20491 = cljs.core.seq.call(null,inst_20486);
var inst_20492__$1 = cljs.core.first.call(null,inst_20491);
var inst_20493 = cljs.core.next.call(null,inst_20491);
var state_20536__$1 = (function (){var statearr_20552 = state_20536;
(statearr_20552[(18)] = inst_20492__$1);

(statearr_20552[(16)] = inst_20493);

return statearr_20552;
})();
if(cljs.core.truth_(inst_20492__$1)){
var statearr_20553_20595 = state_20536__$1;
(statearr_20553_20595[(1)] = (19));

} else {
var statearr_20554_20596 = state_20536__$1;
(statearr_20554_20596[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (3))){
var inst_20534 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20536__$1,inst_20534);
} else {
if((state_val_20537 === (12))){
var inst_20459 = (state_20536[(19)]);
var inst_20470 = (state_20536[(12)]);
var inst_20465 = cljs.core.vals.call(null,inst_20459);
var inst_20466 = cljs.core.flatten.call(null,inst_20465);
var inst_20467 = cljs.core.set.call(null,inst_20466);
var inst_20468 = cljs.core.keys.call(null,inst_20459);
var inst_20469 = cljs.core.set.call(null,inst_20468);
var inst_20470__$1 = clojure.set.difference.call(null,inst_20467,inst_20469);
var inst_20471 = cljs.core.empty_QMARK_.call(null,inst_20470__$1);
var state_20536__$1 = (function (){var statearr_20555 = state_20536;
(statearr_20555[(12)] = inst_20470__$1);

return statearr_20555;
})();
if(inst_20471){
var statearr_20556_20597 = state_20536__$1;
(statearr_20556_20597[(1)] = (14));

} else {
var statearr_20557_20598 = state_20536__$1;
(statearr_20557_20598[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (2))){
var inst_20453 = (state_20536[(17)]);
var _ = (function (){var statearr_20558 = state_20536;
(statearr_20558[(4)] = cljs.core.cons.call(null,(5),(state_20536[(4)])));

return statearr_20558;
})();
var inst_20453__$1 = depth;
var state_20536__$1 = (function (){var statearr_20559 = state_20536;
(statearr_20559[(17)] = inst_20453__$1);

return statearr_20559;
})();
if(cljs.core.truth_(inst_20453__$1)){
var statearr_20560_20599 = state_20536__$1;
(statearr_20560_20599[(1)] = (6));

} else {
var statearr_20561_20600 = state_20536__$1;
(statearr_20561_20600[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (23))){
var inst_20524 = (state_20536[(10)]);
var state_20536__$1 = state_20536;
var statearr_20562_20601 = state_20536__$1;
(statearr_20562_20601[(2)] = inst_20524);

(statearr_20562_20601[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (19))){
var inst_20492 = (state_20536[(18)]);
var inst_20495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20496 = [inst_20492,predicate];
var inst_20497 = (new cljs.core.PersistentVector(null,2,(5),inst_20495,inst_20496,null));
var inst_20498 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20497);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20536__$1,(22),inst_20498);
} else {
if((state_val_20537 === (11))){
var inst_20459 = (state_20536[(19)]);
var state_20536__$1 = state_20536;
var statearr_20564_20602 = state_20536__$1;
(statearr_20564_20602[(2)] = inst_20459);

(statearr_20564_20602[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (9))){
var inst_20460 = (state_20536[(20)]);
var inst_20457 = (state_20536[(11)]);
var inst_20462 = (inst_20460 >= inst_20457);
var state_20536__$1 = state_20536;
if(cljs.core.truth_(inst_20462)){
var statearr_20565_20603 = state_20536__$1;
(statearr_20565_20603[(1)] = (11));

} else {
var statearr_20566_20604 = state_20536__$1;
(statearr_20566_20604[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (5))){
var _ = (function (){var statearr_20567 = state_20536;
(statearr_20567[(4)] = cljs.core.rest.call(null,(state_20536[(4)])));

return statearr_20567;
})();
var state_20536__$1 = state_20536;
var ex20563 = (state_20536__$1[(2)]);
var statearr_20568_20605 = state_20536__$1;
(statearr_20568_20605[(5)] = ex20563);


if((ex20563 instanceof Error)){
var statearr_20569_20606 = state_20536__$1;
(statearr_20569_20606[(1)] = (4));

(statearr_20569_20606[(5)] = null);

} else {
throw ex20563;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (14))){
var inst_20459 = (state_20536[(19)]);
var state_20536__$1 = state_20536;
var statearr_20570_20607 = state_20536__$1;
(statearr_20570_20607[(2)] = inst_20459);

(statearr_20570_20607[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (16))){
var inst_20517 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
var statearr_20571_20608 = state_20536__$1;
(statearr_20571_20608[(2)] = inst_20517);

(statearr_20571_20608[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (10))){
var inst_20523 = (state_20536[(8)]);
var inst_20522 = (state_20536[(9)]);
var inst_20521 = (state_20536[(2)]);
var inst_20522__$1 = cljs.core.keys.call(null,inst_20521);
var inst_20523__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_20522__$1,inst_20521);
var inst_20524 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_20522__$1,inst_20523__$1);
var state_20536__$1 = (function (){var statearr_20572 = state_20536;
(statearr_20572[(8)] = inst_20523__$1);

(statearr_20572[(9)] = inst_20522__$1);

(statearr_20572[(10)] = inst_20524);

return statearr_20572;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20573_20609 = state_20536__$1;
(statearr_20573_20609[(1)] = (23));

} else {
var statearr_20574_20610 = state_20536__$1;
(statearr_20574_20610[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (18))){
var inst_20459 = (state_20536[(19)]);
var inst_20460 = (state_20536[(20)]);
var inst_20508 = (state_20536[(2)]);
var inst_20509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20510 = [(0),(2)];
var inst_20511 = (new cljs.core.PersistentVector(null,2,(5),inst_20509,inst_20510,null));
var inst_20512 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_20511,inst_20508);
var inst_20513 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20459,inst_20512);
var inst_20514 = (inst_20460 + (1));
var inst_20459__$1 = inst_20513;
var inst_20460__$1 = inst_20514;
var state_20536__$1 = (function (){var statearr_20575 = state_20536;
(statearr_20575[(19)] = inst_20459__$1);

(statearr_20575[(20)] = inst_20460__$1);

return statearr_20575;
})();
var statearr_20576_20611 = state_20536__$1;
(statearr_20576_20611[(2)] = null);

(statearr_20576_20611[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (8))){
var inst_20457 = (state_20536[(2)]);
var inst_20458 = recur_map;
var inst_20459 = inst_20458;
var inst_20460 = (1);
var state_20536__$1 = (function (){var statearr_20577 = state_20536;
(statearr_20577[(19)] = inst_20459);

(statearr_20577[(20)] = inst_20460);

(statearr_20577[(11)] = inst_20457);

return statearr_20577;
})();
var statearr_20578_20612 = state_20536__$1;
(statearr_20578_20612[(2)] = null);

(statearr_20578_20612[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_20579 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20579[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__);

(statearr_20579[(1)] = (1));

return statearr_20579;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1 = (function (state_20536){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20580){var ex__2749__auto__ = e20580;
var statearr_20581_20613 = state_20536;
(statearr_20581_20613[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20536[(4)]))){
var statearr_20582_20614 = state_20536;
(statearr_20582_20614[(1)] = cljs.core.first.call(null,(state_20536[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20615 = state_20536;
state_20536 = G__20615;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__ = function(state_20536){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1.call(this,state_20536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20583 = f__2769__auto__.call(null);
(statearr_20583[(6)] = c__2768__auto__);

return statearr_20583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20616,clause,fuel,max_fuel){
var map__20617 = p__20616;
var map__20617__$1 = cljs.core.__destructure_map.call(null,map__20617);
var res = map__20617__$1;
var headers = cljs.core.get.call(null,map__20617__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__20617__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__20617__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20728){
var state_val_20729 = (state_20728[(1)]);
if((state_val_20729 === (7))){
var inst_20634 = (state_20728[(7)]);
var state_20728__$1 = state_20728;
var statearr_20730_20783 = state_20728__$1;
(statearr_20730_20783[(2)] = inst_20634);

(statearr_20730_20783[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (20))){
var inst_20662 = (state_20728[(8)]);
var inst_20693 = typeof inst_20662 === 'number';
var state_20728__$1 = state_20728;
if(cljs.core.truth_(inst_20693)){
var statearr_20731_20784 = state_20728__$1;
(statearr_20731_20784[(1)] = (22));

} else {
var statearr_20732_20785 = state_20728__$1;
(statearr_20732_20785[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (27))){
var inst_20708 = (state_20728[(2)]);
var state_20728__$1 = state_20728;
var statearr_20733_20786 = state_20728__$1;
(statearr_20733_20786[(2)] = inst_20708);

(statearr_20733_20786[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (1))){
var state_20728__$1 = state_20728;
var statearr_20734_20787 = state_20728__$1;
(statearr_20734_20787[(2)] = null);

(statearr_20734_20787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (24))){
var inst_20710 = (state_20728[(2)]);
var state_20728__$1 = state_20728;
var statearr_20735_20788 = state_20728__$1;
(statearr_20735_20788[(2)] = inst_20710);

(statearr_20735_20788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (4))){
var inst_20618 = (state_20728[(2)]);
var state_20728__$1 = state_20728;
var statearr_20736_20789 = state_20728__$1;
(statearr_20736_20789[(2)] = inst_20618);

(statearr_20736_20789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (15))){
var inst_20676 = (state_20728[(2)]);
var inst_20677 = cljs.core.nth.call(null,clause,(2));
var inst_20678 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20677);
var state_20728__$1 = (function (){var statearr_20737 = state_20728;
(statearr_20737[(9)] = inst_20676);

return statearr_20737;
})();
if(cljs.core.truth_(inst_20678)){
var statearr_20738_20790 = state_20728__$1;
(statearr_20738_20790[(1)] = (16));

} else {
var statearr_20739_20791 = state_20728__$1;
(statearr_20739_20791[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (21))){
var inst_20665 = (state_20728[(10)]);
var inst_20635 = (state_20728[(11)]);
var inst_20664 = (state_20728[(12)]);
var inst_20712 = (state_20728[(2)]);
var inst_20713 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_20665,inst_20712,inst_20635,inst_20664);
var state_20728__$1 = state_20728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20728__$1,(28),inst_20713);
} else {
if((state_val_20729 === (13))){
var inst_20644 = (state_20728[(13)]);
var inst_20668 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20644)].join('');
var inst_20669 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20670 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20671 = cljs.core.PersistentHashMap.fromArrays(inst_20669,inst_20670);
var inst_20672 = cljs.core.ex_info.call(null,inst_20668,inst_20671);
var inst_20673 = (function(){throw inst_20672})();
var state_20728__$1 = state_20728;
var statearr_20740_20792 = state_20728__$1;
(statearr_20740_20792[(2)] = inst_20673);

(statearr_20740_20792[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (22))){
var inst_20660 = (state_20728[(14)]);
var inst_20662 = (state_20728[(8)]);
var inst_20695 = cljs.core.PersistentHashMap.EMPTY;
var inst_20696 = cljs.core.flatten.call(null,inst_20660);
var inst_20697 = cljs.core.assoc.call(null,inst_20695,inst_20662,inst_20696);
var state_20728__$1 = state_20728;
var statearr_20741_20793 = state_20728__$1;
(statearr_20741_20793[(2)] = inst_20697);

(statearr_20741_20793[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (6))){
var inst_20646 = (state_20728[(15)]);
var state_20728__$1 = state_20728;
var statearr_20742_20794 = state_20728__$1;
(statearr_20742_20794[(2)] = inst_20646);

(statearr_20742_20794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (28))){
var inst_20715 = (state_20728[(2)]);
var inst_20716 = fluree.db.util.async.throw_err.call(null,inst_20715);
var state_20728__$1 = state_20728;
var statearr_20743_20795 = state_20728__$1;
(statearr_20743_20795[(2)] = inst_20716);

(statearr_20743_20795[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (25))){
var inst_20660 = (state_20728[(14)]);
var inst_20656 = (state_20728[(16)]);
var inst_20701 = cljs.core.PersistentHashMap.EMPTY;
var inst_20702 = cljs.core.first.call(null,inst_20656);
var inst_20703 = cljs.core.first.call(null,inst_20702);
var inst_20704 = cljs.core.flatten.call(null,inst_20660);
var inst_20705 = cljs.core.assoc.call(null,inst_20701,inst_20703,inst_20704);
var state_20728__$1 = state_20728;
var statearr_20744_20796 = state_20728__$1;
(statearr_20744_20796[(2)] = inst_20705);

(statearr_20744_20796[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (17))){
var inst_20644 = (state_20728[(13)]);
var inst_20681 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20644)].join('');
var inst_20682 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20683 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20684 = cljs.core.PersistentHashMap.fromArrays(inst_20682,inst_20683);
var inst_20685 = cljs.core.ex_info.call(null,inst_20681,inst_20684);
var inst_20686 = (function(){throw inst_20685})();
var state_20728__$1 = state_20728;
var statearr_20745_20797 = state_20728__$1;
(statearr_20745_20797[(2)] = inst_20686);

(statearr_20745_20797[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (3))){
var inst_20726 = (state_20728[(2)]);
var state_20728__$1 = state_20728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20728__$1,inst_20726);
} else {
if((state_val_20729 === (12))){
var inst_20631 = (state_20728[(17)]);
var inst_20719 = (state_20728[(2)]);
var inst_20720 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20721 = cljs.core.keys.call(null,inst_20631);
var inst_20722 = [inst_20721,vars,inst_20719];
var inst_20723 = cljs.core.PersistentHashMap.fromArrays(inst_20720,inst_20722);
var _ = (function (){var statearr_20746 = state_20728;
(statearr_20746[(4)] = cljs.core.rest.call(null,(state_20728[(4)])));

return statearr_20746;
})();
var state_20728__$1 = state_20728;
var statearr_20747_20798 = state_20728__$1;
(statearr_20747_20798[(2)] = inst_20723);

(statearr_20747_20798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (2))){
var inst_20631 = (state_20728[(17)]);
var inst_20635 = (state_20728[(11)]);
var inst_20634 = (state_20728[(7)]);
var inst_20646 = (state_20728[(15)]);
var _ = (function (){var statearr_20748 = state_20728;
(statearr_20748[(4)] = cljs.core.cons.call(null,(5),(state_20728[(4)])));

return statearr_20748;
})();
var inst_20628 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_20629 = cljs.core.__destructure_map.call(null,inst_20628);
var inst_20630 = cljs.core.get.call(null,inst_20629,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20631__$1 = cljs.core.get.call(null,inst_20629,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20632 = cljs.core.get.call(null,inst_20629,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20633 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_20634__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20632);
var inst_20635__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20632);
var inst_20637 = (function (){var map__20624 = inst_20629;
var search = inst_20630;
var rel = inst_20631__$1;
var opts = inst_20632;
var common_keys = inst_20633;
var object_fn = inst_20634__$1;
var recur_depth = inst_20635__$1;
return (function (p__20636,common_key){
var vec__20749 = p__20636;
var acc = cljs.core.nth.call(null,vec__20749,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__20749,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20752 = cljs.core._EQ_;
var expr__20753 = idx_of;
if(cljs.core.truth_(pred__20752.call(null,(0),expr__20753))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__20752.call(null,(1),expr__20753))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__20752.call(null,(2),expr__20753))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20753)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4251__auto__ = (!(single_v_QMARK_));
if(and__4251__auto__){
var and__4251__auto____$1 = object_fn;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20639 = cljs.core.PersistentHashMap.EMPTY;
var inst_20640 = [inst_20639,inst_20630];
var inst_20641 = (new cljs.core.PersistentVector(null,2,(5),inst_20638,inst_20640,null));
var inst_20642 = cljs.core.reduce.call(null,inst_20637,inst_20641,inst_20633);
var inst_20643 = cljs.core.nth.call(null,inst_20642,(0),null);
var inst_20644 = cljs.core.nth.call(null,inst_20642,(1),null);
var inst_20645 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20646__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20643);
var state_20728__$1 = (function (){var statearr_20755 = state_20728;
(statearr_20755[(18)] = inst_20645);

(statearr_20755[(17)] = inst_20631__$1);

(statearr_20755[(11)] = inst_20635__$1);

(statearr_20755[(7)] = inst_20634__$1);

(statearr_20755[(15)] = inst_20646__$1);

(statearr_20755[(13)] = inst_20644);

return statearr_20755;
})();
if(cljs.core.truth_(inst_20646__$1)){
var statearr_20756_20799 = state_20728__$1;
(statearr_20756_20799[(1)] = (6));

} else {
var statearr_20757_20800 = state_20728__$1;
(statearr_20757_20800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (23))){
var inst_20662 = (state_20728[(8)]);
var inst_20699 = cljs.core.coll_QMARK_.call(null,inst_20662);
var state_20728__$1 = state_20728;
if(inst_20699){
var statearr_20758_20801 = state_20728__$1;
(statearr_20758_20801[(1)] = (25));

} else {
var statearr_20759_20802 = state_20728__$1;
(statearr_20759_20802[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (19))){
var inst_20660 = (state_20728[(14)]);
var inst_20690 = cljs.core.PersistentHashMap.EMPTY;
var inst_20691 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_20690,inst_20660);
var state_20728__$1 = state_20728;
var statearr_20760_20803 = state_20728__$1;
(statearr_20760_20803[(2)] = inst_20691);

(statearr_20760_20803[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (11))){
var inst_20660 = (state_20728[(14)]);
var state_20728__$1 = state_20728;
var statearr_20762_20804 = state_20728__$1;
(statearr_20762_20804[(2)] = inst_20660);

(statearr_20762_20804[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (9))){
var inst_20631 = (state_20728[(17)]);
var inst_20635 = (state_20728[(11)]);
var inst_20656 = (state_20728[(16)]);
var inst_20655 = (state_20728[(2)]);
var inst_20656__$1 = fluree.db.util.async.throw_err.call(null,inst_20655);
var inst_20657 = cljs.core.count.call(null,inst_20656__$1);
var inst_20658 = fluree.db.query.analytical.add_fuel.call(null,inst_20657,fuel,max_fuel);
var inst_20659 = cljs.core.vals.call(null,inst_20631);
var inst_20660 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_20659,inst_20656__$1);
var state_20728__$1 = (function (){var statearr_20763 = state_20728;
(statearr_20763[(14)] = inst_20660);

(statearr_20763[(16)] = inst_20656__$1);

(statearr_20763[(19)] = inst_20658);

return statearr_20763;
})();
if(cljs.core.truth_(inst_20635)){
var statearr_20764_20805 = state_20728__$1;
(statearr_20764_20805[(1)] = (10));

} else {
var statearr_20765_20806 = state_20728__$1;
(statearr_20765_20806[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (5))){
var _ = (function (){var statearr_20766 = state_20728;
(statearr_20766[(4)] = cljs.core.rest.call(null,(state_20728[(4)])));

return statearr_20766;
})();
var state_20728__$1 = state_20728;
var ex20761 = (state_20728__$1[(2)]);
var statearr_20767_20807 = state_20728__$1;
(statearr_20767_20807[(5)] = ex20761);


if((ex20761 instanceof Error)){
var statearr_20768_20808 = state_20728__$1;
(statearr_20768_20808[(1)] = (4));

(statearr_20768_20808[(5)] = null);

} else {
throw ex20761;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (14))){
var state_20728__$1 = state_20728;
var statearr_20769_20809 = state_20728__$1;
(statearr_20769_20809[(2)] = null);

(statearr_20769_20809[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (26))){
var state_20728__$1 = state_20728;
var statearr_20770_20810 = state_20728__$1;
(statearr_20770_20810[(2)] = null);

(statearr_20770_20810[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (16))){
var state_20728__$1 = state_20728;
var statearr_20771_20811 = state_20728__$1;
(statearr_20771_20811[(2)] = null);

(statearr_20771_20811[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (10))){
var inst_20665 = (state_20728[(10)]);
var inst_20644 = (state_20728[(13)]);
var inst_20662 = cljs.core.first.call(null,inst_20644);
var inst_20663 = cljs.core.first.call(null,clause);
var inst_20664 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20663);
var inst_20665__$1 = cljs.core.nth.call(null,inst_20644,(1));
var inst_20666 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20665__$1);
var state_20728__$1 = (function (){var statearr_20772 = state_20728;
(statearr_20772[(10)] = inst_20665__$1);

(statearr_20772[(8)] = inst_20662);

(statearr_20772[(12)] = inst_20664);

return statearr_20772;
})();
if(cljs.core.truth_(inst_20666)){
var statearr_20773_20812 = state_20728__$1;
(statearr_20773_20812[(1)] = (13));

} else {
var statearr_20774_20813 = state_20728__$1;
(statearr_20774_20813[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (18))){
var inst_20664 = (state_20728[(12)]);
var inst_20688 = (state_20728[(2)]);
var state_20728__$1 = (function (){var statearr_20775 = state_20728;
(statearr_20775[(20)] = inst_20688);

return statearr_20775;
})();
if(cljs.core.truth_(inst_20664)){
var statearr_20776_20814 = state_20728__$1;
(statearr_20776_20814[(1)] = (19));

} else {
var statearr_20777_20815 = state_20728__$1;
(statearr_20777_20815[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20729 === (8))){
var inst_20645 = (state_20728[(18)]);
var inst_20644 = (state_20728[(13)]);
var inst_20650 = (state_20728[(2)]);
var inst_20651 = [inst_20650];
var inst_20652 = cljs.core.PersistentHashMap.fromArrays(inst_20645,inst_20651);
var inst_20653 = fluree.db.query.range.search.call(null,db,inst_20644,inst_20652);
var state_20728__$1 = state_20728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20728__$1,(9),inst_20653);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20778[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_20778[(1)] = (1));

return statearr_20778;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20728){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20779){var ex__2749__auto__ = e20779;
var statearr_20780_20816 = state_20728;
(statearr_20780_20816[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20728[(4)]))){
var statearr_20781_20817 = state_20728;
(statearr_20781_20817[(1)] = cljs.core.first.call(null,(state_20728[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20818 = state_20728;
state_20728 = G__20818;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__ = function(state_20728){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20782 = f__2769__auto__.call(null);
(statearr_20782[(6)] = c__2768__auto__);

return statearr_20782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20819,res,clause){
var map__20820 = p__20819;
var map__20820__$1 = cljs.core.__destructure_map.call(null,map__20820);
var db = map__20820__$1;
var conn = cljs.core.get.call(null,map__20820__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__20820__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__20820__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_20929){
var state_val_20930 = (state_20929[(1)]);
if((state_val_20930 === (7))){
var inst_20829 = (state_20929[(7)]);
var state_20929__$1 = state_20929;
var statearr_20931_20972 = state_20929__$1;
(statearr_20931_20972[(2)] = inst_20829);

(statearr_20931_20972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (20))){
var state_20929__$1 = state_20929;
var statearr_20932_20973 = state_20929__$1;
(statearr_20932_20973[(2)] = null);

(statearr_20932_20973[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (1))){
var state_20929__$1 = state_20929;
var statearr_20933_20974 = state_20929__$1;
(statearr_20933_20974[(2)] = null);

(statearr_20933_20974[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (24))){
var inst_20831 = (state_20929[(8)]);
var inst_20902 = (state_20929[(2)]);
var inst_20903 = fluree.db.flake.sid__GT_cid.call(null,inst_20902);
var inst_20904 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20903);
var inst_20905 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20907 = [inst_20831];
var inst_20908 = (new cljs.core.PersistentVector(null,1,(5),inst_20906,inst_20907,null));
var inst_20909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20911 = [inst_20904];
var inst_20912 = (new cljs.core.PersistentVector(null,1,(5),inst_20910,inst_20911,null));
var inst_20913 = [inst_20912];
var inst_20914 = (new cljs.core.PersistentVector(null,1,(5),inst_20909,inst_20913,null));
var inst_20915 = cljs.core.PersistentHashMap.EMPTY;
var inst_20916 = [inst_20908,inst_20914,inst_20915];
var inst_20917 = cljs.core.PersistentHashMap.fromArrays(inst_20905,inst_20916);
var state_20929__$1 = state_20929;
var statearr_20934_20975 = state_20929__$1;
(statearr_20934_20975[(2)] = inst_20917);

(statearr_20934_20975[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (4))){
var inst_20822 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
var statearr_20935_20976 = state_20929__$1;
(statearr_20935_20976[(2)] = inst_20822);

(statearr_20935_20976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (15))){
var inst_20829 = (state_20929[(7)]);
var inst_20831 = (state_20929[(8)]);
var inst_20850 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20851 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20853 = [inst_20829];
var inst_20854 = (new cljs.core.PersistentVector(null,1,(5),inst_20852,inst_20853,null));
var inst_20855 = (function (){var subject_var = inst_20829;
var object_var = inst_20831;
var min_sid = inst_20850;
var max_sid = (0);
return (function (p1__20821_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__20821_SHARP_);
});
})();
var inst_20856 = cljs.core.range.call(null,inst_20850,(0));
var inst_20857 = cljs.core.map.call(null,inst_20855,inst_20856);
var inst_20858 = cljs.core.PersistentHashMap.EMPTY;
var inst_20859 = [inst_20854,inst_20857,inst_20858];
var inst_20860 = cljs.core.PersistentHashMap.fromArrays(inst_20851,inst_20859);
var state_20929__$1 = state_20929;
var statearr_20936_20977 = state_20929__$1;
(statearr_20936_20977[(2)] = inst_20860);

(statearr_20936_20977[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (21))){
var inst_20920 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
var statearr_20937_20978 = state_20929__$1;
(statearr_20937_20978[(2)] = inst_20920);

(statearr_20937_20978[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (13))){
var inst_20831 = (state_20929[(8)]);
var state_20929__$1 = state_20929;
if(cljs.core.truth_(inst_20831)){
var statearr_20938_20979 = state_20929__$1;
(statearr_20938_20979[(1)] = (19));

} else {
var statearr_20939_20980 = state_20929__$1;
(statearr_20939_20980[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (22))){
var inst_20893 = (state_20929[(9)]);
var state_20929__$1 = state_20929;
var statearr_20940_20981 = state_20929__$1;
(statearr_20940_20981[(2)] = inst_20893);

(statearr_20940_20981[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (6))){
var inst_20831 = (state_20929[(8)]);
var state_20929__$1 = state_20929;
var statearr_20941_20982 = state_20929__$1;
(statearr_20941_20982[(2)] = inst_20831);

(statearr_20941_20982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (25))){
var inst_20899 = (state_20929[(2)]);
var inst_20900 = fluree.db.util.async.throw_err.call(null,inst_20899);
var state_20929__$1 = state_20929;
var statearr_20942_20983 = state_20929__$1;
(statearr_20942_20983[(2)] = inst_20900);

(statearr_20942_20983[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (17))){
var inst_20890 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
var statearr_20943_20984 = state_20929__$1;
(statearr_20943_20984[(2)] = inst_20890);

(statearr_20943_20984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (3))){
var inst_20927 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20929__$1,inst_20927);
} else {
if((state_val_20930 === (12))){
var inst_20844 = ["_tx",null,"_block",null];
var inst_20845 = (new cljs.core.PersistentArrayMap(null,2,inst_20844,null));
var inst_20846 = (new cljs.core.PersistentHashSet(null,inst_20845,null));
var inst_20847 = cljs.core.last.call(null,clause);
var inst_20848 = inst_20846.call(null,inst_20847);
var state_20929__$1 = state_20929;
if(cljs.core.truth_(inst_20848)){
var statearr_20944_20985 = state_20929__$1;
(statearr_20944_20985[(1)] = (15));

} else {
var statearr_20945_20986 = state_20929__$1;
(statearr_20945_20986[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (2))){
var inst_20829 = (state_20929[(7)]);
var _ = (function (){var statearr_20946 = state_20929;
(statearr_20946[(4)] = cljs.core.cons.call(null,(5),(state_20929[(4)])));

return statearr_20946;
})();
var inst_20828 = cljs.core.first.call(null,clause);
var inst_20829__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20828);
var inst_20830 = cljs.core.last.call(null,clause);
var inst_20831 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_20830);
var state_20929__$1 = (function (){var statearr_20947 = state_20929;
(statearr_20947[(7)] = inst_20829__$1);

(statearr_20947[(8)] = inst_20831);

return statearr_20947;
})();
if(cljs.core.truth_(inst_20829__$1)){
var statearr_20948_20987 = state_20929__$1;
(statearr_20948_20987[(1)] = (6));

} else {
var statearr_20949_20988 = state_20929__$1;
(statearr_20949_20988[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (23))){
var inst_20893 = (state_20929[(9)]);
var inst_20897 = fluree.db.dbproto._subid.call(null,db,inst_20893);
var state_20929__$1 = state_20929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20929__$1,(25),inst_20897);
} else {
if((state_val_20930 === (19))){
var inst_20893 = (state_20929[(9)]);
var inst_20893__$1 = cljs.core.first.call(null,clause);
var inst_20894 = typeof inst_20893__$1 === 'number';
var state_20929__$1 = (function (){var statearr_20950 = state_20929;
(statearr_20950[(9)] = inst_20893__$1);

return statearr_20950;
})();
if(cljs.core.truth_(inst_20894)){
var statearr_20951_20989 = state_20929__$1;
(statearr_20951_20989[(1)] = (22));

} else {
var statearr_20952_20990 = state_20929__$1;
(statearr_20952_20990[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (11))){
var inst_20924 = (state_20929[(2)]);
var _ = (function (){var statearr_20954 = state_20929;
(statearr_20954[(4)] = cljs.core.rest.call(null,(state_20929[(4)])));

return statearr_20954;
})();
var state_20929__$1 = state_20929;
var statearr_20955_20991 = state_20929__$1;
(statearr_20955_20991[(2)] = inst_20924);

(statearr_20955_20991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (9))){
var inst_20837 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20838 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20839 = cljs.core.PersistentHashMap.fromArrays(inst_20837,inst_20838);
var inst_20840 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_20839);
var inst_20841 = (function(){throw inst_20840})();
var state_20929__$1 = state_20929;
var statearr_20956_20992 = state_20929__$1;
(statearr_20956_20992[(2)] = inst_20841);

(statearr_20956_20992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (5))){
var _ = (function (){var statearr_20957 = state_20929;
(statearr_20957[(4)] = cljs.core.rest.call(null,(state_20929[(4)])));

return statearr_20957;
})();
var state_20929__$1 = state_20929;
var ex20953 = (state_20929__$1[(2)]);
var statearr_20958_20993 = state_20929__$1;
(statearr_20958_20993[(5)] = ex20953);


if((ex20953 instanceof Error)){
var statearr_20959_20994 = state_20929__$1;
(statearr_20959_20994[(1)] = (4));

(statearr_20959_20994[(5)] = null);

} else {
throw ex20953;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (14))){
var inst_20922 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
var statearr_20960_20995 = state_20929__$1;
(statearr_20960_20995[(2)] = inst_20922);

(statearr_20960_20995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (16))){
var inst_20866 = (state_20929[(10)]);
var inst_20863 = (state_20929[(11)]);
var inst_20865 = (state_20929[(12)]);
var inst_20862 = cljs.core.last.call(null,clause);
var inst_20863__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20862);
var inst_20864 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20865__$1 = cljs.core.get.call(null,inst_20864,inst_20863__$1);
var inst_20866__$1 = fluree.db.flake.min_subject_id.call(null,inst_20863__$1);
var inst_20867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20868 = [inst_20865__$1];
var inst_20869 = (new cljs.core.PersistentVector(null,1,(5),inst_20867,inst_20868,null));
var inst_20870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20871 = [inst_20866__$1];
var inst_20872 = (new cljs.core.PersistentVector(null,1,(5),inst_20870,inst_20871,null));
var inst_20873 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20869,cljs.core._LT__EQ_,inst_20872);
var state_20929__$1 = (function (){var statearr_20961 = state_20929;
(statearr_20961[(10)] = inst_20866__$1);

(statearr_20961[(11)] = inst_20863__$1);

(statearr_20961[(12)] = inst_20865__$1);

return statearr_20961;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20929__$1,(18),inst_20873);
} else {
if((state_val_20930 === (10))){
var inst_20829 = (state_20929[(7)]);
var state_20929__$1 = state_20929;
if(cljs.core.truth_(inst_20829)){
var statearr_20962_20996 = state_20929__$1;
(statearr_20962_20996[(1)] = (12));

} else {
var statearr_20963_20997 = state_20929__$1;
(statearr_20963_20997[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (18))){
var inst_20829 = (state_20929[(7)]);
var inst_20831 = (state_20929[(8)]);
var inst_20866 = (state_20929[(10)]);
var inst_20863 = (state_20929[(11)]);
var inst_20865 = (state_20929[(12)]);
var inst_20875 = (state_20929[(2)]);
var inst_20876 = fluree.db.util.async.throw_err.call(null,inst_20875);
var inst_20877 = (function (){var subject_var = inst_20829;
var object_var = inst_20831;
var partition = inst_20863;
var max_sid = inst_20865;
var min_sid = inst_20866;
var flakes = inst_20876;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20878 = cljs.core.map.call(null,inst_20877);
var inst_20879 = cljs.core.distinct.call(null);
var inst_20880 = cljs.core.comp.call(null,inst_20878,inst_20879);
var inst_20881 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20883 = [inst_20829];
var inst_20884 = (new cljs.core.PersistentVector(null,1,(5),inst_20882,inst_20883,null));
var inst_20885 = cljs.core.sequence.call(null,inst_20880,inst_20876);
var inst_20886 = cljs.core.PersistentHashMap.EMPTY;
var inst_20887 = [inst_20884,inst_20885,inst_20886];
var inst_20888 = cljs.core.PersistentHashMap.fromArrays(inst_20881,inst_20887);
var state_20929__$1 = state_20929;
var statearr_20964_20998 = state_20929__$1;
(statearr_20964_20998[(2)] = inst_20888);

(statearr_20964_20998[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20930 === (8))){
var inst_20835 = (state_20929[(2)]);
var state_20929__$1 = state_20929;
if(cljs.core.truth_(inst_20835)){
var statearr_20965_20999 = state_20929__$1;
(statearr_20965_20999[(1)] = (9));

} else {
var statearr_20966_21000 = state_20929__$1;
(statearr_20966_21000[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20967 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20967[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__);

(statearr_20967[(1)] = (1));

return statearr_20967;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1 = (function (state_20929){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_20929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20968){var ex__2749__auto__ = e20968;
var statearr_20969_21001 = state_20929;
(statearr_20969_21001[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_20929[(4)]))){
var statearr_20970_21002 = state_20929;
(statearr_20970_21002[(1)] = cljs.core.first.call(null,(state_20929[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21003 = state_20929;
state_20929 = G__21003;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__ = function(state_20929){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1.call(this,state_20929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20971 = f__2769__auto__.call(null);
(statearr_20971[(6)] = c__2768__auto__);

return statearr_20971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__21009 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__21009 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__21009;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4652__auto__ = (function fluree$db$query$analytical$variance_$_iter__21010(s__21011){
return (new cljs.core.LazySeq(null,(function (){
var s__21011__$1 = s__21011;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__21011__$1);
if(temp__5753__auto__){
var s__21011__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__21011__$2)){
var c__4650__auto__ = cljs.core.chunk_first.call(null,s__21011__$2);
var size__4651__auto__ = cljs.core.count.call(null,c__4650__auto__);
var b__21013 = cljs.core.chunk_buffer.call(null,size__4651__auto__);
if((function (){var i__21012 = (0);
while(true){
if((i__21012 < size__4651__auto__)){
var x = cljs.core._nth.call(null,c__4650__auto__,i__21012);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__21013,(delta * delta));

var G__21014 = (i__21012 + (1));
i__21012 = G__21014;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21013),fluree$db$query$analytical$variance_$_iter__21010.call(null,cljs.core.chunk_rest.call(null,s__21011__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__21013),null);
}
} else {
var x = cljs.core.first.call(null,s__21011__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__21010.call(null,cljs.core.rest.call(null,s__21011__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4652__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4336__auto__ = n;
var y__4337__auto__ = (- n);
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
}),(function() {
var G__21015 = null;
var G__21015__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21015__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21015 = function(n,coll){
switch(arguments.length){
case 1:
return G__21015__1.call(this,n);
case 2:
return G__21015__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21015.cljs$core$IFn$_invoke$arity$1 = G__21015__1;
G__21015.cljs$core$IFn$_invoke$arity$2 = G__21015__2;
return G__21015;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21016 = null;
var G__21016__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__21016__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21016 = function(n,coll){
switch(arguments.length){
case 1:
return G__21016__1.call(this,n);
case 2:
return G__21016__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21016.cljs$core$IFn$_invoke$arity$1 = G__21016__1;
G__21016.cljs$core$IFn$_invoke$arity$2 = G__21016__2;
return G__21016;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21017 = null;
var G__21017__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__21017__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__21017 = function(n,coll){
switch(arguments.length){
case 1:
return G__21017__1.call(this,n);
case 2:
return G__21017__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21017.cljs$core$IFn$_invoke$arity$1 = G__21017__1;
G__21017.cljs$core$IFn$_invoke$arity$2 = G__21017__2;
return G__21017;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4251__auto__ = typeof x === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4251__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__21018 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__21018,(0),null);
var arg = cljs.core.nth.call(null,vec__21018,(1),null);
var var$ = cljs.core.nth.call(null,vec__21018,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21021 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__21021,(0),null);
var variable = cljs.core.nth.call(null,vec__21021,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__21024 = agg;
var map__21024__$1 = cljs.core.__destructure_map.call(null,map__21024);
var variable = cljs.core.get.call(null,map__21024__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__21024__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__21024__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__21026 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__21026,(0),null);
var agg_result = cljs.core.nth.call(null,vec__21026,(1),null);
var map__21029 = res__$1;
var map__21029__$1 = cljs.core.__destructure_map.call(null,map__21029);
var headers = cljs.core.get.call(null,map__21029__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__21029__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21025_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__21025_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__21030_SHARP_){
return cljs.core.nth.call(null,tuple,p1__21030_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__21031_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21031_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.call(null,(function (p1__21032_SHARP_,p2__21033_SHARP_){
return cljs.core.conj.call(null,p1__21032_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__21033_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__21034_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__21034_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__21037,row,b_tuple){
var vec__21038 = p__21037;
var acc = cljs.core.nth.call(null,vec__21038,(0),null);
var b_rows = cljs.core.nth.call(null,vec__21038,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__21035_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21035_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4253__auto__ = acc;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__21036_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__21036_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__21041_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21041_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21042_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21042_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21044_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21044_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21043_SHARP_){
return cljs.core.range.call(null,(0),p1__21043_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__21045_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21045_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__21046_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21046_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__21047_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21047_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__21049_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__21049_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__21048_SHARP_){
return cljs.core.range.call(null,(0),p1__21048_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__21050_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21050_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__21052 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__21052,(0),null);
var _ = cljs.core.nth.call(null,vec__21052,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__21051_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__21051_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__21057 = (function (){var or__4253__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__21057,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__21057,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__21055_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__21055_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__21056_SHARP_){
return cljs.core.nth.call(null,clause,p1__21056_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21060,filters,optional_QMARK_){
var map__21061 = p__21060;
var map__21061__$1 = cljs.core.__destructure_map.call(null,map__21061);
var tuple_map = map__21061__$1;
var headers = cljs.core.get.call(null,map__21061__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21061__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__21061__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21062 = clause;
var k = cljs.core.nth.call(null,vec__21062,(0),null);
var v = cljs.core.nth.call(null,vec__21062,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21065 = res;
var map__21065__$1 = cljs.core.__destructure_map.call(null,map__21065);
var headers = cljs.core.get.call(null,map__21065__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__21065__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5751__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21121){
var state_val_21122 = (state_21121[(1)]);
if((state_val_21122 === (7))){
var inst_21095 = (state_21121[(7)]);
var inst_21093 = (state_21121[(2)]);
var inst_21094 = fluree.db.util.async.throw_err.call(null,inst_21093);
var inst_21095__$1 = cljs.core.nth.call(null,inst_21094,(0),null);
var inst_21096 = cljs.core.nth.call(null,inst_21094,(1),null);
var inst_21097 = (inst_21095__$1 == null);
var state_21121__$1 = (function (){var statearr_21123 = state_21121;
(statearr_21123[(7)] = inst_21095__$1);

(statearr_21123[(8)] = inst_21096);

return statearr_21123;
})();
if(cljs.core.truth_(inst_21097)){
var statearr_21124_21153 = state_21121__$1;
(statearr_21124_21153[(1)] = (8));

} else {
var statearr_21125_21154 = state_21121__$1;
(statearr_21125_21154[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (1))){
var inst_21073 = optional_clauses;
var inst_21074 = cljs.core.seq.call(null,inst_21073);
var inst_21075 = cljs.core.first.call(null,inst_21074);
var inst_21076 = cljs.core.next.call(null,inst_21074);
var inst_21077 = where_tuples;
var inst_21078 = inst_21073;
var inst_21079 = inst_21077;
var state_21121__$1 = (function (){var statearr_21126 = state_21121;
(statearr_21126[(9)] = inst_21079);

(statearr_21126[(10)] = inst_21078);

(statearr_21126[(11)] = inst_21076);

(statearr_21126[(12)] = inst_21075);

return statearr_21126;
})();
var statearr_21127_21155 = state_21121__$1;
(statearr_21127_21155[(2)] = null);

(statearr_21127_21155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (4))){
var inst_21085 = (state_21121[(13)]);
var inst_21079 = (state_21121[(9)]);
var inst_21086 = (state_21121[(14)]);
var inst_21091 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21079,inst_21085,inst_21086,true,fuel,max_fuel,opts);
var state_21121__$1 = state_21121;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21121__$1,(7),inst_21091);
} else {
if((state_val_21122 === (15))){
var state_21121__$1 = state_21121;
var statearr_21128_21156 = state_21121__$1;
(statearr_21128_21156[(2)] = null);

(statearr_21128_21156[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (13))){
var inst_21112 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21129_21157 = state_21121__$1;
(statearr_21129_21157[(2)] = inst_21112);

(statearr_21129_21157[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (6))){
var inst_21117 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21130_21158 = state_21121__$1;
(statearr_21130_21158[(2)] = inst_21117);

(statearr_21130_21158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (3))){
var inst_21119 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21121__$1,inst_21119);
} else {
if((state_val_21122 === (12))){
var state_21121__$1 = state_21121;
var statearr_21131_21159 = state_21121__$1;
(statearr_21131_21159[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (2))){
var inst_21085 = (state_21121[(13)]);
var inst_21078 = (state_21121[(10)]);
var inst_21084 = cljs.core.seq.call(null,inst_21078);
var inst_21085__$1 = cljs.core.first.call(null,inst_21084);
var inst_21086 = cljs.core.next.call(null,inst_21084);
var state_21121__$1 = (function (){var statearr_21133 = state_21121;
(statearr_21133[(13)] = inst_21085__$1);

(statearr_21133[(14)] = inst_21086);

return statearr_21133;
})();
if(cljs.core.truth_(inst_21085__$1)){
var statearr_21134_21160 = state_21121__$1;
(statearr_21134_21160[(1)] = (4));

} else {
var statearr_21135_21161 = state_21121__$1;
(statearr_21135_21161[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (11))){
var inst_21095 = (state_21121[(7)]);
var inst_21096 = (state_21121[(8)]);
var inst_21078 = inst_21096;
var inst_21079 = inst_21095;
var state_21121__$1 = (function (){var statearr_21136 = state_21121;
(statearr_21136[(9)] = inst_21079);

(statearr_21136[(10)] = inst_21078);

return statearr_21136;
})();
var statearr_21137_21162 = state_21121__$1;
(statearr_21137_21162[(2)] = null);

(statearr_21137_21162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (9))){
var inst_21085 = (state_21121[(13)]);
var inst_21101 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21085);
var state_21121__$1 = state_21121;
if(cljs.core.truth_(inst_21101)){
var statearr_21138_21163 = state_21121__$1;
(statearr_21138_21163[(1)] = (11));

} else {
var statearr_21139_21164 = state_21121__$1;
(statearr_21139_21164[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (5))){
var inst_21079 = (state_21121[(9)]);
var state_21121__$1 = state_21121;
var statearr_21140_21165 = state_21121__$1;
(statearr_21140_21165[(2)] = inst_21079);

(statearr_21140_21165[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (14))){
var inst_21079 = (state_21121[(9)]);
var inst_21095 = (state_21121[(7)]);
var inst_21096 = (state_21121[(8)]);
var inst_21106 = fluree.db.query.analytical.left_outer_join.call(null,inst_21079,inst_21095);
var inst_21078 = inst_21096;
var inst_21079__$1 = inst_21106;
var state_21121__$1 = (function (){var statearr_21141 = state_21121;
(statearr_21141[(9)] = inst_21079__$1);

(statearr_21141[(10)] = inst_21078);

return statearr_21141;
})();
var statearr_21142_21166 = state_21121__$1;
(statearr_21142_21166[(2)] = null);

(statearr_21142_21166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (16))){
var inst_21110 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21144_21167 = state_21121__$1;
(statearr_21144_21167[(2)] = inst_21110);

(statearr_21144_21167[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (10))){
var inst_21114 = (state_21121[(2)]);
var state_21121__$1 = state_21121;
var statearr_21145_21168 = state_21121__$1;
(statearr_21145_21168[(2)] = inst_21114);

(statearr_21145_21168[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21122 === (8))){
var inst_21079 = (state_21121[(9)]);
var inst_21096 = (state_21121[(8)]);
var tmp21143 = inst_21079;
var inst_21078 = inst_21096;
var inst_21079__$1 = tmp21143;
var state_21121__$1 = (function (){var statearr_21146 = state_21121;
(statearr_21146[(9)] = inst_21079__$1);

(statearr_21146[(10)] = inst_21078);

return statearr_21146;
})();
var statearr_21147_21169 = state_21121__$1;
(statearr_21147_21169[(2)] = null);

(statearr_21147_21169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0 = (function (){
var statearr_21148 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21148[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__);

(statearr_21148[(1)] = (1));

return statearr_21148;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1 = (function (state_21121){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21121);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21149){var ex__2749__auto__ = e21149;
var statearr_21150_21170 = state_21121;
(statearr_21150_21170[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21121[(4)]))){
var statearr_21151_21171 = state_21121;
(statearr_21151_21171[(1)] = cljs.core.first.call(null,(state_21121[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21172 = state_21121;
state_21121 = G__21172;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__ = function(state_21121){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1.call(this,state_21121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21152 = f__2769__auto__.call(null);
(statearr_21152[(6)] = c__2768__auto__);

return statearr_21152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__21174){
var vec__21175 = p__21174;
var var_name = cljs.core.nth.call(null,vec__21175,(0),null);
var var_val = cljs.core.nth.call(null,vec__21175,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__21173_SHARP_){
return cljs.core.conj.call(null,p1__21173_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21179,p__21180,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21181 = p__21179;
var map__21181__$1 = cljs.core.__destructure_map.call(null,map__21181);
var q_map = map__21181__$1;
var prefixes = cljs.core.get.call(null,map__21181__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21182 = p__21180;
var map__21182__$1 = cljs.core.__destructure_map.call(null,map__21182);
var res = map__21182__$1;
var vars = cljs.core.get.call(null,map__21182__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21419){
var state_val_21420 = (state_21419[(1)]);
if((state_val_21420 === (65))){
var inst_21369 = (state_21419[(7)]);
var inst_21368 = (state_21419[(8)]);
var inst_21380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21381 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_21368,res,inst_21369);
var inst_21382 = [inst_21381,r];
var inst_21383 = (new cljs.core.PersistentVector(null,2,(5),inst_21380,inst_21382,null));
var state_21419__$1 = state_21419;
var statearr_21421_21526 = state_21419__$1;
(statearr_21421_21526[(2)] = inst_21383);

(statearr_21421_21526[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (70))){
var inst_21395 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21422_21527 = state_21419__$1;
(statearr_21422_21527[(2)] = inst_21395);

(statearr_21422_21527[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (62))){
var inst_21369 = (state_21419[(7)]);
var inst_21377 = cljs.core.second.call(null,inst_21369);
var inst_21378 = clojure.string.starts_with_QMARK_.call(null,inst_21377,"fullText:");
var state_21419__$1 = state_21419;
if(inst_21378){
var statearr_21423_21528 = state_21419__$1;
(statearr_21423_21528[(1)] = (65));

} else {
var statearr_21424_21529 = state_21419__$1;
(statearr_21424_21529[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (7))){
var inst_21288 = (state_21419[(9)]);
var inst_21287 = cljs.core.count.call(null,clause);
var inst_21288__$1 = cljs.core._EQ_.call(null,(3),inst_21287);
var state_21419__$1 = (function (){var statearr_21425 = state_21419;
(statearr_21425[(9)] = inst_21288__$1);

return statearr_21425;
})();
if(inst_21288__$1){
var statearr_21426_21530 = state_21419__$1;
(statearr_21426_21530[(1)] = (31));

} else {
var statearr_21427_21531 = state_21419__$1;
(statearr_21427_21531[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (59))){
var inst_21402 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21428_21532 = state_21419__$1;
(statearr_21428_21532[(2)] = inst_21402);

(statearr_21428_21532[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (20))){
var inst_21251 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21429_21533 = state_21419__$1;
(statearr_21429_21533[(2)] = inst_21251);

(statearr_21429_21533[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (58))){
var state_21419__$1 = state_21419;
var statearr_21430_21534 = state_21419__$1;
(statearr_21430_21534[(2)] = null);

(statearr_21430_21534[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (60))){
var inst_21368 = (state_21419[(8)]);
var inst_21366 = (state_21419[(2)]);
var inst_21367 = fluree.db.util.async.throw_err.call(null,inst_21366);
var inst_21368__$1 = cljs.core.nth.call(null,inst_21367,(0),null);
var inst_21369 = cljs.core.nth.call(null,inst_21367,(1),null);
var inst_21370 = cljs.core._EQ_.call(null,"$wd",inst_21368__$1);
var state_21419__$1 = (function (){var statearr_21431 = state_21419;
(statearr_21431[(7)] = inst_21369);

(statearr_21431[(8)] = inst_21368__$1);

return statearr_21431;
})();
if(inst_21370){
var statearr_21432_21535 = state_21419__$1;
(statearr_21432_21535[(1)] = (61));

} else {
var statearr_21433_21536 = state_21419__$1;
(statearr_21433_21536[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (27))){
var inst_21281 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21434_21537 = state_21419__$1;
(statearr_21434_21537[(2)] = inst_21281);

(statearr_21434_21537[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (1))){
var state_21419__$1 = state_21419;
var statearr_21435_21538 = state_21419__$1;
(statearr_21435_21538[(2)] = null);

(statearr_21435_21538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (69))){
var state_21419__$1 = state_21419;
var statearr_21436_21539 = state_21419__$1;
(statearr_21436_21539[(2)] = null);

(statearr_21436_21539[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (24))){
var inst_21245 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21437_21540 = state_21419__$1;
(statearr_21437_21540[(2)] = inst_21245);

(statearr_21437_21540[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (55))){
var inst_21351 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21352 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21353 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21354 = cljs.core.PersistentHashMap.fromArrays(inst_21352,inst_21353);
var inst_21355 = cljs.core.ex_info.call(null,inst_21351,inst_21354);
var inst_21356 = (function(){throw inst_21355})();
var state_21419__$1 = state_21419;
var statearr_21438_21541 = state_21419__$1;
(statearr_21438_21541[(2)] = inst_21356);

(statearr_21438_21541[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (39))){
var inst_21308 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
if(cljs.core.truth_(inst_21308)){
var statearr_21439_21542 = state_21419__$1;
(statearr_21439_21542[(1)] = (40));

} else {
var statearr_21440_21543 = state_21419__$1;
(statearr_21440_21543[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (46))){
var inst_21408 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21441_21544 = state_21419__$1;
(statearr_21441_21544[(2)] = inst_21408);

(statearr_21441_21544[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (4))){
var inst_21183 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21442_21545 = state_21419__$1;
(statearr_21442_21545[(2)] = inst_21183);

(statearr_21442_21545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (54))){
var inst_21344 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21345 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21346 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21347 = cljs.core.PersistentHashMap.fromArrays(inst_21345,inst_21346);
var inst_21348 = cljs.core.ex_info.call(null,inst_21344,inst_21347);
var inst_21349 = (function(){throw inst_21348})();
var state_21419__$1 = state_21419;
var statearr_21443_21546 = state_21419__$1;
(statearr_21443_21546[(2)] = inst_21349);

(statearr_21443_21546[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (15))){
var inst_21283 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21444_21547 = state_21419__$1;
(statearr_21444_21547[(2)] = inst_21283);

(statearr_21444_21547[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (48))){
var inst_21332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21333 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_21334 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21333);
var inst_21335 = [inst_21334,r];
var inst_21336 = (new cljs.core.PersistentVector(null,2,(5),inst_21332,inst_21335,null));
var state_21419__$1 = state_21419;
var statearr_21445_21548 = state_21419__$1;
(statearr_21445_21548[(2)] = inst_21336);

(statearr_21445_21548[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (50))){
var inst_21406 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21446_21549 = state_21419__$1;
(statearr_21446_21549[(2)] = inst_21406);

(statearr_21446_21549[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (21))){
var inst_21196 = (state_21419[(10)]);
var inst_21229 = (state_21419[(11)]);
var inst_21217 = (state_21419[(12)]);
var inst_21221 = (state_21419[(13)]);
var inst_21228 = (state_21419[(14)]);
var inst_21222 = (state_21419[(15)]);
var inst_21192 = (state_21419[(16)]);
var inst_21220 = (state_21419[(17)]);
var inst_21219 = (state_21419[(18)]);
var inst_21233 = (state_21419[(2)]);
var inst_21234 = fluree.db.util.async.throw_err.call(null,inst_21233);
var inst_21235 = (function (){var new_res = inst_21234;
var rest = inst_21229;
var vec__21224 = inst_21221;
var tuples = inst_21222;
var seq__21215 = inst_21220;
var first__21216 = inst_21219;
var expr__21194 = inst_21192;
var seq__21225 = inst_21229;
var vec__21214 = inst_21217;
var pred__21193 = inst_21196;
var G__21213 = inst_21221;
var segment_type = inst_21192;
var first__21226 = inst_21228;
var clause_group = inst_21228;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21236 = cljs.core.keys.call(null,vars);
var inst_21237 = cljs.core.reduce.call(null,inst_21235,inst_21234,inst_21236);
var inst_21238 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_21237);
var state_21419__$1 = (function (){var statearr_21447 = state_21419;
(statearr_21447[(19)] = inst_21238);

return statearr_21447;
})();
if(cljs.core.truth_(inst_21222)){
var statearr_21448_21550 = state_21419__$1;
(statearr_21448_21550[(1)] = (22));

} else {
var statearr_21449_21551 = state_21419__$1;
(statearr_21449_21551[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (31))){
var inst_21290 = cljs.core.second.call(null,clause);
var inst_21291 = clojure.string.starts_with_QMARK_.call(null,inst_21290,"fullText:");
var state_21419__$1 = state_21419;
var statearr_21450_21552 = state_21419__$1;
(statearr_21450_21552[(2)] = inst_21291);

(statearr_21450_21552[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (32))){
var inst_21288 = (state_21419[(9)]);
var state_21419__$1 = state_21419;
var statearr_21451_21553 = state_21419__$1;
(statearr_21451_21553[(2)] = inst_21288);

(statearr_21451_21553[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (40))){
var inst_21310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21311 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_21419__$1 = (function (){var statearr_21452 = state_21419;
(statearr_21452[(20)] = inst_21310);

return statearr_21452;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(43),inst_21311);
} else {
if((state_val_21420 === (56))){
var inst_21358 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21453_21554 = state_21419__$1;
(statearr_21453_21554[(2)] = inst_21358);

(statearr_21453_21554[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (33))){
var inst_21294 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
if(cljs.core.truth_(inst_21294)){
var statearr_21454_21555 = state_21419__$1;
(statearr_21454_21555[(1)] = (34));

} else {
var statearr_21455_21556 = state_21419__$1;
(statearr_21455_21556[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (13))){
var inst_21217 = (state_21419[(12)]);
var inst_21217__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21218 = cljs.core.seq.call(null,inst_21217__$1);
var inst_21219 = cljs.core.first.call(null,inst_21218);
var inst_21220 = cljs.core.next.call(null,inst_21218);
var inst_21221 = inst_21217__$1;
var inst_21222 = null;
var state_21419__$1 = (function (){var statearr_21456 = state_21419;
(statearr_21456[(12)] = inst_21217__$1);

(statearr_21456[(13)] = inst_21221);

(statearr_21456[(15)] = inst_21222);

(statearr_21456[(17)] = inst_21220);

(statearr_21456[(18)] = inst_21219);

return statearr_21456;
})();
var statearr_21457_21557 = state_21419__$1;
(statearr_21457_21557[(2)] = null);

(statearr_21457_21557[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (22))){
var inst_21238 = (state_21419[(19)]);
var inst_21229 = (state_21419[(11)]);
var inst_21222 = (state_21419[(15)]);
var inst_21240 = fluree.db.query.union.results.call(null,inst_21222,inst_21238);
var inst_21221 = inst_21229;
var inst_21222__$1 = inst_21240;
var state_21419__$1 = (function (){var statearr_21458 = state_21419;
(statearr_21458[(13)] = inst_21221);

(statearr_21458[(15)] = inst_21222__$1);

return statearr_21458;
})();
var statearr_21459_21558 = state_21419__$1;
(statearr_21459_21558[(2)] = null);

(statearr_21459_21558[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (36))){
var inst_21412 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21460_21559 = state_21419__$1;
(statearr_21460_21559[(2)] = inst_21412);

(statearr_21460_21559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (41))){
var inst_21318 = cljs.core.count.call(null,clause);
var inst_21319 = cljs.core._EQ_.call(null,(3),inst_21318);
var state_21419__$1 = state_21419;
if(inst_21319){
var statearr_21461_21560 = state_21419__$1;
(statearr_21461_21560[(1)] = (44));

} else {
var statearr_21462_21561 = state_21419__$1;
(statearr_21462_21561[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (43))){
var inst_21310 = (state_21419[(20)]);
var inst_21313 = (state_21419[(2)]);
var inst_21314 = fluree.db.util.async.throw_err.call(null,inst_21313);
var inst_21315 = [inst_21314,r];
var inst_21316 = (new cljs.core.PersistentVector(null,2,(5),inst_21310,inst_21315,null));
var state_21419__$1 = state_21419;
var statearr_21463_21562 = state_21419__$1;
(statearr_21463_21562[(2)] = inst_21316);

(statearr_21463_21562[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (61))){
var inst_21369 = (state_21419[(7)]);
var inst_21372 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_21369,r,res,optional_QMARK_,fuel,max_fuel);
var state_21419__$1 = state_21419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(64),inst_21372);
} else {
if((state_val_21420 === (29))){
var inst_21192 = (state_21419[(16)]);
var inst_21275 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21192)].join('');
var inst_21276 = (new Error(inst_21275));
var inst_21277 = (function(){throw inst_21276})();
var state_21419__$1 = state_21419;
var statearr_21464_21563 = state_21419__$1;
(statearr_21464_21563[(2)] = inst_21277);

(statearr_21464_21563[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (44))){
var inst_21321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21322 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_21419__$1 = (function (){var statearr_21465 = state_21419;
(statearr_21465[(21)] = inst_21321);

return statearr_21465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(47),inst_21322);
} else {
if((state_val_21420 === (6))){
var inst_21196 = (state_21419[(10)]);
var inst_21192 = (state_21419[(16)]);
var inst_21191 = cljs.core.keys.call(null,clause);
var inst_21192__$1 = cljs.core.first.call(null,inst_21191);
var inst_21196__$1 = cljs.core._EQ_;
var inst_21197 = inst_21196__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_21192__$1);
var state_21419__$1 = (function (){var statearr_21466 = state_21419;
(statearr_21466[(10)] = inst_21196__$1);

(statearr_21466[(16)] = inst_21192__$1);

return statearr_21466;
})();
if(cljs.core.truth_(inst_21197)){
var statearr_21467_21564 = state_21419__$1;
(statearr_21467_21564[(1)] = (9));

} else {
var statearr_21468_21565 = state_21419__$1;
(statearr_21468_21565[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (28))){
var inst_21269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21270 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21271 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_21270,optional_QMARK_);
var inst_21272 = [inst_21271,r];
var inst_21273 = (new cljs.core.PersistentVector(null,2,(5),inst_21269,inst_21272,null));
var state_21419__$1 = state_21419;
var statearr_21469_21566 = state_21419__$1;
(statearr_21469_21566[(2)] = inst_21273);

(statearr_21469_21566[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (64))){
var inst_21374 = (state_21419[(2)]);
var inst_21375 = fluree.db.util.async.throw_err.call(null,inst_21374);
var state_21419__$1 = state_21419;
var statearr_21470_21567 = state_21419__$1;
(statearr_21470_21567[(2)] = inst_21375);

(statearr_21470_21567[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (51))){
var inst_21341 = cljs.core.first.call(null,clause);
var inst_21342 = cljs.core.sequential_QMARK_.call(null,inst_21341);
var state_21419__$1 = state_21419;
if(inst_21342){
var statearr_21471_21568 = state_21419__$1;
(statearr_21471_21568[(1)] = (54));

} else {
var statearr_21472_21569 = state_21419__$1;
(statearr_21472_21569[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (25))){
var inst_21196 = (state_21419[(10)]);
var inst_21192 = (state_21419[(16)]);
var inst_21257 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21258 = (function (){var segment_type = inst_21192;
var pred__21193 = inst_21196;
var expr__21194 = inst_21192;
var bindings = inst_21257;
return (function (p1__21178_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__21178_SHARP_);
});
})();
var inst_21259 = cljs.core.map.call(null,inst_21258,inst_21257);
var inst_21260 = cljs.core.PersistentHashMap.EMPTY;
var inst_21261 = cljs.core.into.call(null,inst_21260,inst_21259);
var inst_21262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21263 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21261);
var inst_21264 = [inst_21263,r];
var inst_21265 = (new cljs.core.PersistentVector(null,2,(5),inst_21262,inst_21264,null));
var state_21419__$1 = state_21419;
var statearr_21473_21570 = state_21419__$1;
(statearr_21473_21570[(2)] = inst_21265);

(statearr_21473_21570[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (34))){
var inst_21296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21297 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_21298 = [inst_21297,r];
var inst_21299 = (new cljs.core.PersistentVector(null,2,(5),inst_21296,inst_21298,null));
var state_21419__$1 = state_21419;
var statearr_21474_21571 = state_21419__$1;
(statearr_21474_21571[(2)] = inst_21299);

(statearr_21474_21571[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (17))){
var inst_21253 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21475_21572 = state_21419__$1;
(statearr_21475_21572[(2)] = inst_21253);

(statearr_21475_21572[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (3))){
var inst_21417 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21419__$1,inst_21417);
} else {
if((state_val_21420 === (12))){
var inst_21199 = (state_21419[(22)]);
var inst_21203 = (state_21419[(2)]);
var inst_21204 = fluree.db.util.async.throw_err.call(null,inst_21203);
var inst_21205 = [inst_21204,r];
var inst_21206 = (new cljs.core.PersistentVector(null,2,(5),inst_21199,inst_21205,null));
var state_21419__$1 = state_21419;
var statearr_21476_21573 = state_21419__$1;
(statearr_21476_21573[(2)] = inst_21206);

(statearr_21476_21573[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (2))){
var _ = (function (){var statearr_21477 = state_21419;
(statearr_21477[(4)] = cljs.core.cons.call(null,(5),(state_21419[(4)])));

return statearr_21477;
})();
var inst_21189 = cljs.core.map_QMARK_.call(null,clause);
var state_21419__$1 = state_21419;
if(inst_21189){
var statearr_21478_21574 = state_21419__$1;
(statearr_21478_21574[(1)] = (6));

} else {
var statearr_21479_21575 = state_21419__$1;
(statearr_21479_21575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (66))){
var state_21419__$1 = state_21419;
var statearr_21480_21576 = state_21419__$1;
(statearr_21480_21576[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (23))){
var inst_21238 = (state_21419[(19)]);
var inst_21229 = (state_21419[(11)]);
var inst_21221 = inst_21229;
var inst_21222 = inst_21238;
var state_21419__$1 = (function (){var statearr_21482 = state_21419;
(statearr_21482[(13)] = inst_21221);

(statearr_21482[(15)] = inst_21222);

return statearr_21482;
})();
var statearr_21483_21577 = state_21419__$1;
(statearr_21483_21577[(2)] = null);

(statearr_21483_21577[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (47))){
var inst_21321 = (state_21419[(21)]);
var inst_21324 = (state_21419[(2)]);
var inst_21325 = fluree.db.util.async.throw_err.call(null,inst_21324);
var inst_21326 = [inst_21325,r];
var inst_21327 = (new cljs.core.PersistentVector(null,2,(5),inst_21321,inst_21326,null));
var state_21419__$1 = state_21419;
var statearr_21484_21578 = state_21419__$1;
(statearr_21484_21578[(2)] = inst_21327);

(statearr_21484_21578[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (35))){
var inst_21302 = (state_21419[(23)]);
var inst_21301 = cljs.core.count.call(null,clause);
var inst_21302__$1 = cljs.core._EQ_.call(null,(3),inst_21301);
var state_21419__$1 = (function (){var statearr_21485 = state_21419;
(statearr_21485[(23)] = inst_21302__$1);

return statearr_21485;
})();
if(inst_21302__$1){
var statearr_21486_21579 = state_21419__$1;
(statearr_21486_21579[(1)] = (37));

} else {
var statearr_21487_21580 = state_21419__$1;
(statearr_21487_21580[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (19))){
var inst_21222 = (state_21419[(15)]);
var inst_21247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21248 = [inst_21222,r];
var inst_21249 = (new cljs.core.PersistentVector(null,2,(5),inst_21247,inst_21248,null));
var state_21419__$1 = state_21419;
var statearr_21488_21581 = state_21419__$1;
(statearr_21488_21581[(2)] = inst_21249);

(statearr_21488_21581[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (57))){
var inst_21364 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_21419__$1 = state_21419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(60),inst_21364);
} else {
if((state_val_21420 === (68))){
var inst_21369 = (state_21419[(7)]);
var inst_21368 = (state_21419[(8)]);
var inst_21386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21387 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_21368,res,inst_21369,fuel,max_fuel);
var state_21419__$1 = (function (){var statearr_21489 = state_21419;
(statearr_21489[(24)] = inst_21386);

return statearr_21489;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(71),inst_21387);
} else {
if((state_val_21420 === (11))){
var inst_21285 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21491_21582 = state_21419__$1;
(statearr_21491_21582[(2)] = inst_21285);

(statearr_21491_21582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (9))){
var inst_21199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21200 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21201 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21200,res,fuel,max_fuel,opts);
var state_21419__$1 = (function (){var statearr_21492 = state_21419;
(statearr_21492[(22)] = inst_21199);

return statearr_21492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(12),inst_21201);
} else {
if((state_val_21420 === (5))){
var _ = (function (){var statearr_21493 = state_21419;
(statearr_21493[(4)] = cljs.core.rest.call(null,(state_21419[(4)])));

return statearr_21493;
})();
var state_21419__$1 = state_21419;
var ex21490 = (state_21419__$1[(2)]);
var statearr_21494_21583 = state_21419__$1;
(statearr_21494_21583[(5)] = ex21490);


if((ex21490 instanceof Error)){
var statearr_21495_21584 = state_21419__$1;
(statearr_21495_21584[(1)] = (4));

(statearr_21495_21584[(5)] = null);

} else {
throw ex21490;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (14))){
var inst_21196 = (state_21419[(10)]);
var inst_21192 = (state_21419[(16)]);
var inst_21255 = inst_21196.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_21192);
var state_21419__$1 = state_21419;
if(cljs.core.truth_(inst_21255)){
var statearr_21496_21585 = state_21419__$1;
(statearr_21496_21585[(1)] = (25));

} else {
var statearr_21497_21586 = state_21419__$1;
(statearr_21497_21586[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (45))){
var inst_21329 = cljs.core.count.call(null,clause);
var inst_21330 = cljs.core._EQ_.call(null,(2),inst_21329);
var state_21419__$1 = state_21419;
if(inst_21330){
var statearr_21498_21587 = state_21419__$1;
(statearr_21498_21587[(1)] = (48));

} else {
var statearr_21499_21588 = state_21419__$1;
(statearr_21499_21588[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (53))){
var inst_21404 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21500_21589 = state_21419__$1;
(statearr_21500_21589[(2)] = inst_21404);

(statearr_21500_21589[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (26))){
var inst_21196 = (state_21419[(10)]);
var inst_21192 = (state_21419[(16)]);
var inst_21267 = inst_21196.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_21192);
var state_21419__$1 = state_21419;
if(cljs.core.truth_(inst_21267)){
var statearr_21501_21590 = state_21419__$1;
(statearr_21501_21590[(1)] = (28));

} else {
var statearr_21502_21591 = state_21419__$1;
(statearr_21502_21591[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (16))){
var inst_21221 = (state_21419[(13)]);
var inst_21228 = (state_21419[(14)]);
var inst_21227 = cljs.core.seq.call(null,inst_21221);
var inst_21228__$1 = cljs.core.first.call(null,inst_21227);
var inst_21229 = cljs.core.next.call(null,inst_21227);
var state_21419__$1 = (function (){var statearr_21503 = state_21419;
(statearr_21503[(11)] = inst_21229);

(statearr_21503[(14)] = inst_21228__$1);

return statearr_21503;
})();
if(cljs.core.truth_(inst_21228__$1)){
var statearr_21504_21592 = state_21419__$1;
(statearr_21504_21592[(1)] = (18));

} else {
var statearr_21505_21593 = state_21419__$1;
(statearr_21505_21593[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (38))){
var inst_21302 = (state_21419[(23)]);
var state_21419__$1 = state_21419;
var statearr_21506_21594 = state_21419__$1;
(statearr_21506_21594[(2)] = inst_21302);

(statearr_21506_21594[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (30))){
var inst_21279 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21507_21595 = state_21419__$1;
(statearr_21507_21595[(2)] = inst_21279);

(statearr_21507_21595[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (10))){
var inst_21196 = (state_21419[(10)]);
var inst_21192 = (state_21419[(16)]);
var inst_21208 = inst_21196.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_21192);
var state_21419__$1 = state_21419;
if(cljs.core.truth_(inst_21208)){
var statearr_21508_21596 = state_21419__$1;
(statearr_21508_21596[(1)] = (13));

} else {
var statearr_21509_21597 = state_21419__$1;
(statearr_21509_21597[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (18))){
var inst_21228 = (state_21419[(14)]);
var inst_21231 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21228,q_map,vars,fuel,max_fuel,opts);
var state_21419__$1 = state_21419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21419__$1,(21),inst_21231);
} else {
if((state_val_21420 === (52))){
var state_21419__$1 = state_21419;
var statearr_21510_21598 = state_21419__$1;
(statearr_21510_21598[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (67))){
var inst_21397 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21512_21599 = state_21419__$1;
(statearr_21512_21599[(2)] = inst_21397);

(statearr_21512_21599[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (71))){
var inst_21386 = (state_21419[(24)]);
var inst_21389 = (state_21419[(2)]);
var inst_21390 = fluree.db.util.async.throw_err.call(null,inst_21389);
var inst_21391 = [inst_21390,r];
var inst_21392 = (new cljs.core.PersistentVector(null,2,(5),inst_21386,inst_21391,null));
var state_21419__$1 = state_21419;
var statearr_21513_21600 = state_21419__$1;
(statearr_21513_21600[(2)] = inst_21392);

(statearr_21513_21600[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (42))){
var inst_21410 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21514_21601 = state_21419__$1;
(statearr_21514_21601[(2)] = inst_21410);

(statearr_21514_21601[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (37))){
var inst_21304 = cljs.core.second.call(null,clause);
var inst_21305 = cljs.core._EQ_.call(null,inst_21304,"rdf:type");
var state_21419__$1 = state_21419;
var statearr_21515_21602 = state_21419__$1;
(statearr_21515_21602[(2)] = inst_21305);

(statearr_21515_21602[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (63))){
var inst_21399 = (state_21419[(2)]);
var state_21419__$1 = state_21419;
var statearr_21516_21603 = state_21419__$1;
(statearr_21516_21603[(2)] = inst_21399);

(statearr_21516_21603[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (8))){
var inst_21414 = (state_21419[(2)]);
var _ = (function (){var statearr_21517 = state_21419;
(statearr_21517[(4)] = cljs.core.rest.call(null,(state_21419[(4)])));

return statearr_21517;
})();
var state_21419__$1 = state_21419;
var statearr_21518_21604 = state_21419__$1;
(statearr_21518_21604[(2)] = inst_21414);

(statearr_21518_21604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21420 === (49))){
var inst_21338 = cljs.core.count.call(null,clause);
var inst_21339 = cljs.core._EQ_.call(null,(1),inst_21338);
var state_21419__$1 = state_21419;
if(inst_21339){
var statearr_21519_21605 = state_21419__$1;
(statearr_21519_21605[(1)] = (51));

} else {
var statearr_21520_21606 = state_21419__$1;
(statearr_21520_21606[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_21521 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21521[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__);

(statearr_21521[(1)] = (1));

return statearr_21521;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1 = (function (state_21419){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21522){var ex__2749__auto__ = e21522;
var statearr_21523_21607 = state_21419;
(statearr_21523_21607[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21419[(4)]))){
var statearr_21524_21608 = state_21419;
(statearr_21524_21608[(1)] = cljs.core.first.call(null,(state_21419[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21609 = state_21419;
state_21419 = G__21609;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__ = function(state_21419){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1.call(this,state_21419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21525 = f__2769__auto__.call(null);
(statearr_21525[(6)] = c__2768__auto__);

return statearr_21525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21611 = arguments.length;
switch (G__21611) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21691){
var state_val_21692 = (state_21691[(1)]);
if((state_val_21692 === (7))){
var inst_21686 = (state_21691[(2)]);
var _ = (function (){var statearr_21693 = state_21691;
(statearr_21693[(4)] = cljs.core.rest.call(null,(state_21691[(4)])));

return statearr_21693;
})();
var state_21691__$1 = state_21691;
var statearr_21694_21742 = state_21691__$1;
(statearr_21694_21742[(2)] = inst_21686);

(statearr_21694_21742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (20))){
var inst_21651 = (state_21691[(7)]);
var inst_21663 = (state_21691[(2)]);
var inst_21633 = inst_21651;
var inst_21634 = inst_21663;
var state_21691__$1 = (function (){var statearr_21695 = state_21691;
(statearr_21695[(8)] = inst_21634);

(statearr_21695[(9)] = inst_21633);

return statearr_21695;
})();
var statearr_21696_21743 = state_21691__$1;
(statearr_21696_21743[(2)] = null);

(statearr_21696_21743[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (1))){
var state_21691__$1 = state_21691;
var statearr_21697_21744 = state_21691__$1;
(statearr_21697_21744[(2)] = null);

(statearr_21697_21744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (24))){
var inst_21634 = (state_21691[(8)]);
var inst_21650 = (state_21691[(10)]);
var inst_21651 = (state_21691[(7)]);
var inst_21671 = fluree.db.query.analytical.inner_join.call(null,inst_21634,inst_21650);
var inst_21633 = inst_21651;
var inst_21634__$1 = inst_21671;
var state_21691__$1 = (function (){var statearr_21698 = state_21691;
(statearr_21698[(8)] = inst_21634__$1);

(statearr_21698[(9)] = inst_21633);

return statearr_21698;
})();
var statearr_21699_21745 = state_21691__$1;
(statearr_21699_21745[(2)] = null);

(statearr_21699_21745[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (4))){
var inst_21612 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21701_21746 = state_21691__$1;
(statearr_21701_21746[(2)] = inst_21612);

(statearr_21701_21746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (15))){
var inst_21650 = (state_21691[(10)]);
var state_21691__$1 = state_21691;
if(cljs.core.truth_(inst_21650)){
var statearr_21702_21747 = state_21691__$1;
(statearr_21702_21747[(1)] = (18));

} else {
var statearr_21703_21748 = state_21691__$1;
(statearr_21703_21748[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (21))){
var inst_21634 = (state_21691[(8)]);
var inst_21651 = (state_21691[(7)]);
var tmp21700 = inst_21634;
var inst_21633 = inst_21651;
var inst_21634__$1 = tmp21700;
var state_21691__$1 = (function (){var statearr_21704 = state_21691;
(statearr_21704[(8)] = inst_21634__$1);

(statearr_21704[(9)] = inst_21633);

return statearr_21704;
})();
var statearr_21705_21749 = state_21691__$1;
(statearr_21705_21749[(2)] = null);

(statearr_21705_21749[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (13))){
var inst_21634 = (state_21691[(8)]);
var inst_21657 = cljs.core.dissoc.call(null,inst_21634,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21658 = cljs.core.empty_QMARK_.call(null,inst_21657);
var state_21691__$1 = state_21691;
if(inst_21658){
var statearr_21706_21750 = state_21691__$1;
(statearr_21706_21750[(1)] = (15));

} else {
var statearr_21707_21751 = state_21691__$1;
(statearr_21707_21751[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (22))){
var state_21691__$1 = state_21691;
var statearr_21708_21752 = state_21691__$1;
(statearr_21708_21752[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (6))){
var inst_21640 = (state_21691[(11)]);
var inst_21633 = (state_21691[(9)]);
var inst_21639 = cljs.core.seq.call(null,inst_21633);
var inst_21640__$1 = cljs.core.first.call(null,inst_21639);
var inst_21641 = cljs.core.next.call(null,inst_21639);
var state_21691__$1 = (function (){var statearr_21710 = state_21691;
(statearr_21710[(11)] = inst_21640__$1);

(statearr_21710[(12)] = inst_21641);

return statearr_21710;
})();
if(cljs.core.truth_(inst_21640__$1)){
var statearr_21711_21753 = state_21691__$1;
(statearr_21711_21753[(1)] = (8));

} else {
var statearr_21712_21754 = state_21691__$1;
(statearr_21712_21754[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (25))){
var state_21691__$1 = state_21691;
var statearr_21713_21755 = state_21691__$1;
(statearr_21713_21755[(2)] = null);

(statearr_21713_21755[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (17))){
var inst_21679 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21714_21756 = state_21691__$1;
(statearr_21714_21756[(2)] = inst_21679);

(statearr_21714_21756[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (3))){
var inst_21689 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21691__$1,inst_21689);
} else {
if((state_val_21692 === (12))){
var inst_21650 = (state_21691[(10)]);
var inst_21651 = (state_21691[(7)]);
var inst_21633 = inst_21651;
var inst_21634 = inst_21650;
var state_21691__$1 = (function (){var statearr_21715 = state_21691;
(statearr_21715[(8)] = inst_21634);

(statearr_21715[(9)] = inst_21633);

return statearr_21715;
})();
var statearr_21716_21757 = state_21691__$1;
(statearr_21716_21757[(2)] = null);

(statearr_21716_21757[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (2))){
var _ = (function (){var statearr_21717 = state_21691;
(statearr_21717[(4)] = cljs.core.cons.call(null,(5),(state_21691[(4)])));

return statearr_21717;
})();
var inst_21625 = where;
var inst_21626 = cljs.core.seq.call(null,inst_21625);
var inst_21627 = cljs.core.first.call(null,inst_21626);
var inst_21628 = cljs.core.next.call(null,inst_21626);
var inst_21629 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21630 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_21631 = [inst_21630];
var inst_21632 = cljs.core.PersistentHashMap.fromArrays(inst_21629,inst_21631);
var inst_21633 = inst_21625;
var inst_21634 = inst_21632;
var state_21691__$1 = (function (){var statearr_21718 = state_21691;
(statearr_21718[(13)] = inst_21627);

(statearr_21718[(14)] = inst_21628);

(statearr_21718[(8)] = inst_21634);

(statearr_21718[(9)] = inst_21633);

return statearr_21718;
})();
var statearr_21719_21758 = state_21691__$1;
(statearr_21719_21758[(2)] = null);

(statearr_21719_21758[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (23))){
var inst_21677 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21720_21759 = state_21691__$1;
(statearr_21720_21759[(2)] = inst_21677);

(statearr_21720_21759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (19))){
var inst_21634 = (state_21691[(8)]);
var state_21691__$1 = state_21691;
var statearr_21721_21760 = state_21691__$1;
(statearr_21721_21760[(2)] = inst_21634);

(statearr_21721_21760[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (11))){
var inst_21640 = (state_21691[(11)]);
var inst_21648 = (state_21691[(2)]);
var inst_21649 = fluree.db.util.async.throw_err.call(null,inst_21648);
var inst_21650 = cljs.core.nth.call(null,inst_21649,(0),null);
var inst_21651 = cljs.core.nth.call(null,inst_21649,(1),null);
var inst_21652 = cljs.core.count.call(null,inst_21640);
var inst_21653 = cljs.core._EQ_.call(null,(2),inst_21652);
var state_21691__$1 = (function (){var statearr_21723 = state_21691;
(statearr_21723[(10)] = inst_21650);

(statearr_21723[(7)] = inst_21651);

return statearr_21723;
})();
if(inst_21653){
var statearr_21724_21761 = state_21691__$1;
(statearr_21724_21761[(1)] = (12));

} else {
var statearr_21725_21762 = state_21691__$1;
(statearr_21725_21762[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (9))){
var inst_21634 = (state_21691[(8)]);
var state_21691__$1 = state_21691;
var statearr_21726_21763 = state_21691__$1;
(statearr_21726_21763[(2)] = inst_21634);

(statearr_21726_21763[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (5))){
var _ = (function (){var statearr_21727 = state_21691;
(statearr_21727[(4)] = cljs.core.rest.call(null,(state_21691[(4)])));

return statearr_21727;
})();
var state_21691__$1 = state_21691;
var ex21722 = (state_21691__$1[(2)]);
var statearr_21728_21764 = state_21691__$1;
(statearr_21728_21764[(5)] = ex21722);


if((ex21722 instanceof Error)){
var statearr_21729_21765 = state_21691__$1;
(statearr_21729_21765[(1)] = (4));

(statearr_21729_21765[(5)] = null);

} else {
throw ex21722;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (14))){
var inst_21681 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21730_21766 = state_21691__$1;
(statearr_21730_21766[(2)] = inst_21681);

(statearr_21730_21766[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (26))){
var inst_21675 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21731_21767 = state_21691__$1;
(statearr_21731_21767[(2)] = inst_21675);

(statearr_21731_21767[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (16))){
var inst_21650 = (state_21691[(10)]);
var inst_21666 = (inst_21650 == null);
var state_21691__$1 = state_21691;
if(cljs.core.truth_(inst_21666)){
var statearr_21732_21768 = state_21691__$1;
(statearr_21732_21768[(1)] = (21));

} else {
var statearr_21733_21769 = state_21691__$1;
(statearr_21733_21769[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (10))){
var inst_21684 = (state_21691[(2)]);
var state_21691__$1 = state_21691;
var statearr_21734_21770 = state_21691__$1;
(statearr_21734_21770[(2)] = inst_21684);

(statearr_21734_21770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (18))){
var inst_21650 = (state_21691[(10)]);
var state_21691__$1 = state_21691;
var statearr_21735_21771 = state_21691__$1;
(statearr_21735_21771[(2)] = inst_21650);

(statearr_21735_21771[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21692 === (8))){
var inst_21640 = (state_21691[(11)]);
var inst_21634 = (state_21691[(8)]);
var inst_21641 = (state_21691[(12)]);
var inst_21646 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21634,inst_21640,inst_21641,false,fuel,max_fuel,opts);
var state_21691__$1 = state_21691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21691__$1,(11),inst_21646);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2746__auto__ = null;
var fluree$db$query$analytical$state_machine__2746__auto____0 = (function (){
var statearr_21736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21736[(0)] = fluree$db$query$analytical$state_machine__2746__auto__);

(statearr_21736[(1)] = (1));

return statearr_21736;
});
var fluree$db$query$analytical$state_machine__2746__auto____1 = (function (state_21691){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21737){var ex__2749__auto__ = e21737;
var statearr_21738_21772 = state_21691;
(statearr_21738_21772[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21691[(4)]))){
var statearr_21739_21773 = state_21691;
(statearr_21739_21773[(1)] = cljs.core.first.call(null,(state_21691[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21774 = state_21691;
state_21691 = G__21774;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2746__auto__ = function(state_21691){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2746__auto____1.call(this,state_21691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2746__auto____0;
fluree$db$query$analytical$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2746__auto____1;
return fluree$db$query$analytical$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21740 = f__2769__auto__.call(null);
(statearr_21740[(6)] = c__2768__auto__);

return statearr_21740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21809){
var state_val_21810 = (state_21809[(1)]);
if((state_val_21810 === (7))){
var inst_21786 = (state_21809[(7)]);
var inst_21791 = (state_21809[(8)]);
var inst_21793 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_21786,inst_21791,fuel,max_fuel,opts);
var state_21809__$1 = state_21809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21809__$1,(10),inst_21793);
} else {
if((state_val_21810 === (1))){
var state_21809__$1 = state_21809;
var statearr_21811_21836 = state_21809__$1;
(statearr_21811_21836[(2)] = null);

(statearr_21811_21836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (4))){
var inst_21775 = (state_21809[(2)]);
var state_21809__$1 = state_21809;
var statearr_21812_21837 = state_21809__$1;
(statearr_21812_21837[(2)] = inst_21775);

(statearr_21812_21837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (13))){
var inst_21804 = (state_21809[(2)]);
var _ = (function (){var statearr_21813 = state_21809;
(statearr_21813[(4)] = cljs.core.rest.call(null,(state_21809[(4)])));

return statearr_21813;
})();
var state_21809__$1 = state_21809;
var statearr_21814_21838 = state_21809__$1;
(statearr_21814_21838[(2)] = inst_21804);

(statearr_21814_21838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (6))){
var inst_21786 = (state_21809[(7)]);
var inst_21790 = (state_21809[(2)]);
var inst_21791 = fluree.db.util.async.throw_err.call(null,inst_21790);
var state_21809__$1 = (function (){var statearr_21815 = state_21809;
(statearr_21815[(8)] = inst_21791);

return statearr_21815;
})();
if(cljs.core.truth_(inst_21786)){
var statearr_21816_21839 = state_21809__$1;
(statearr_21816_21839[(1)] = (7));

} else {
var statearr_21817_21840 = state_21809__$1;
(statearr_21817_21840[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (3))){
var inst_21807 = (state_21809[(2)]);
var state_21809__$1 = state_21809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21809__$1,inst_21807);
} else {
if((state_val_21810 === (12))){
var inst_21799 = (state_21809[(9)]);
var state_21809__$1 = state_21809;
var statearr_21818_21841 = state_21809__$1;
(statearr_21818_21841[(2)] = inst_21799);

(statearr_21818_21841[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (2))){
var _ = (function (){var statearr_21819 = state_21809;
(statearr_21819[(4)] = cljs.core.cons.call(null,(5),(state_21809[(4)])));

return statearr_21819;
})();
var inst_21782 = q_map;
var inst_21783 = cljs.core.__destructure_map.call(null,inst_21782);
var inst_21784 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21785 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21786 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21787 = cljs.core.get.call(null,inst_21783,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21788 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21785,q_map,inst_21784,fuel,max_fuel,opts);
var state_21809__$1 = (function (){var statearr_21820 = state_21809;
(statearr_21820[(10)] = inst_21787);

(statearr_21820[(7)] = inst_21786);

return statearr_21820;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21809__$1,(6),inst_21788);
} else {
if((state_val_21810 === (11))){
var inst_21799 = (state_21809[(9)]);
var inst_21787 = (state_21809[(10)]);
var inst_21801 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_21799,inst_21787,null);
var state_21809__$1 = state_21809;
var statearr_21822_21842 = state_21809__$1;
(statearr_21822_21842[(2)] = inst_21801);

(statearr_21822_21842[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (9))){
var inst_21787 = (state_21809[(10)]);
var inst_21799 = (state_21809[(2)]);
var state_21809__$1 = (function (){var statearr_21823 = state_21809;
(statearr_21823[(9)] = inst_21799);

return statearr_21823;
})();
if(cljs.core.truth_(inst_21787)){
var statearr_21824_21843 = state_21809__$1;
(statearr_21824_21843[(1)] = (11));

} else {
var statearr_21825_21844 = state_21809__$1;
(statearr_21825_21844[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (5))){
var _ = (function (){var statearr_21826 = state_21809;
(statearr_21826[(4)] = cljs.core.rest.call(null,(state_21809[(4)])));

return statearr_21826;
})();
var state_21809__$1 = state_21809;
var ex21821 = (state_21809__$1[(2)]);
var statearr_21827_21845 = state_21809__$1;
(statearr_21827_21845[(5)] = ex21821);


if((ex21821 instanceof Error)){
var statearr_21828_21846 = state_21809__$1;
(statearr_21828_21846[(1)] = (4));

(statearr_21828_21846[(5)] = null);

} else {
throw ex21821;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (10))){
var inst_21795 = (state_21809[(2)]);
var inst_21796 = fluree.db.util.async.throw_err.call(null,inst_21795);
var state_21809__$1 = state_21809;
var statearr_21829_21847 = state_21809__$1;
(statearr_21829_21847[(2)] = inst_21796);

(statearr_21829_21847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21810 === (8))){
var inst_21791 = (state_21809[(8)]);
var state_21809__$1 = state_21809;
var statearr_21830_21848 = state_21809__$1;
(statearr_21830_21848[(2)] = inst_21791);

(statearr_21830_21848[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2746__auto____0 = (function (){
var statearr_21831 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21831[(0)] = fluree$db$query$analytical$q_$_state_machine__2746__auto__);

(statearr_21831[(1)] = (1));

return statearr_21831;
});
var fluree$db$query$analytical$q_$_state_machine__2746__auto____1 = (function (state_21809){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e21832){var ex__2749__auto__ = e21832;
var statearr_21833_21849 = state_21809;
(statearr_21833_21849[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21809[(4)]))){
var statearr_21834_21850 = state_21809;
(statearr_21834_21850[(1)] = cljs.core.first.call(null,(state_21809[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21851 = state_21809;
state_21809 = G__21851;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2746__auto__ = function(state_21809){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2746__auto____1.call(this,state_21809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2746__auto____0;
fluree$db$query$analytical$q_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2746__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_21835 = f__2769__auto__.call(null);
(statearr_21835[(6)] = c__2768__auto__);

return statearr_21835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
