// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18730 = arguments.length;
switch (G__18730) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18733 = arguments.length;
switch (G__18733) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___18786 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18764){
var state_val_18765 = (state_18764[(1)]);
if((state_val_18765 === (1))){
var state_18764__$1 = state_18764;
var statearr_18766_18787 = state_18764__$1;
(statearr_18766_18787[(2)] = null);

(statearr_18766_18787[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (2))){
var _ = (function (){var statearr_18767 = state_18764;
(statearr_18767[(4)] = cljs.core.cons.call(null,(5),(state_18764[(4)])));

return statearr_18767;
})();
var inst_18741 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_18764__$1 = state_18764;
if(cljs.core.truth_(inst_18741)){
var statearr_18768_18788 = state_18764__$1;
(statearr_18768_18788[(1)] = (6));

} else {
var statearr_18769_18789 = state_18764__$1;
(statearr_18769_18789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (3))){
var inst_18762 = (state_18764[(2)]);
var state_18764__$1 = state_18764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18764__$1,inst_18762);
} else {
if((state_val_18765 === (4))){
var inst_18734 = (state_18764[(2)]);
var inst_18735 = cljs.core.async.put_BANG_.call(null,pc,inst_18734);
var state_18764__$1 = state_18764;
var statearr_18771_18790 = state_18764__$1;
(statearr_18771_18790[(2)] = inst_18735);

(statearr_18771_18790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (5))){
var _ = (function (){var statearr_18772 = state_18764;
(statearr_18772[(4)] = cljs.core.rest.call(null,(state_18764[(4)])));

return statearr_18772;
})();
var state_18764__$1 = state_18764;
var ex18770 = (state_18764__$1[(2)]);
var statearr_18773_18791 = state_18764__$1;
(statearr_18773_18791[(5)] = ex18770);


var statearr_18774_18792 = state_18764__$1;
(statearr_18774_18792[(1)] = (4));

(statearr_18774_18792[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (6))){
var inst_18743 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18744 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18745 = cljs.core.PersistentHashMap.fromArrays(inst_18743,inst_18744);
var inst_18746 = cljs.core.ex_info.call(null,"Connection was closed.",inst_18745);
var inst_18747 = (function(){throw inst_18746})();
var state_18764__$1 = state_18764;
var statearr_18775_18793 = state_18764__$1;
(statearr_18775_18793[(2)] = inst_18747);

(statearr_18775_18793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (7))){
var inst_18749 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18751 = [operation,data,pc,opts];
var inst_18752 = (new cljs.core.PersistentVector(null,4,(5),inst_18750,inst_18751,null));
var inst_18753 = cljs.core.async.put_BANG_.call(null,inst_18749,inst_18752);
var inst_18754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18755 = [operation,data,pc,opts];
var inst_18756 = (new cljs.core.PersistentVector(null,4,(5),inst_18754,inst_18755,null));
var inst_18757 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18756);
var state_18764__$1 = (function (){var statearr_18776 = state_18764;
(statearr_18776[(7)] = inst_18753);

return statearr_18776;
})();
var statearr_18777_18794 = state_18764__$1;
(statearr_18777_18794[(2)] = inst_18757);

(statearr_18777_18794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18765 === (8))){
var inst_18759 = (state_18764[(2)]);
var _ = (function (){var statearr_18778 = state_18764;
(statearr_18778[(4)] = cljs.core.rest.call(null,(state_18764[(4)])));

return statearr_18778;
})();
var state_18764__$1 = state_18764;
var statearr_18779_18795 = state_18764__$1;
(statearr_18779_18795[(2)] = inst_18759);

(statearr_18779_18795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_18780 = [null,null,null,null,null,null,null,null];
(statearr_18780[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_18780[(1)] = (1));

return statearr_18780;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_18764){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18781){var ex__2749__auto__ = e18781;
var statearr_18782_18796 = state_18764;
(statearr_18782_18796[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18764[(4)]))){
var statearr_18783_18797 = state_18764;
(statearr_18783_18797[(1)] = cljs.core.first.call(null,(state_18764[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18798 = state_18764;
state_18764 = G__18798;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_18764){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_18764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18784 = f__2769__auto__.call(null);
(statearr_18784[(6)] = c__2768__auto___18786);

return statearr_18784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18800 = arguments.length;
switch (G__18800) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18801){
var map__18802 = p__18801;
var map__18802__$1 = cljs.core.__destructure_map.call(null,map__18802);
var opts = map__18802__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__18802__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18803 = session;
var map__18803__$1 = cljs.core.__destructure_map.call(null,map__18803);
var dbid = cljs.core.get.call(null,map__18803__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__18803__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__18803__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___18830 = arguments.length;
var i__4865__auto___18831 = (0);
while(true){
if((i__4865__auto___18831 < len__4864__auto___18830)){
args__4870__auto__.push((arguments[i__4865__auto___18831]));

var G__18832 = (i__4865__auto___18831 + (1));
i__4865__auto___18831 = G__18832;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18807){
var vec__18808 = p__18807;
var map__18811 = cljs.core.nth.call(null,vec__18808,(0),null);
var map__18811__$1 = cljs.core.__destructure_map.call(null,map__18811);
var toBlock = cljs.core.get.call(null,map__18811__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__18811__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18808;
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_18823){
var state_val_18824 = (state_18823[(1)]);
if((state_val_18824 === (1))){
var inst_18813 = session;
var inst_18814 = cljs.core.__destructure_map.call(null,inst_18813);
var inst_18815 = cljs.core.get.call(null,inst_18814,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18816 = cljs.core.get.call(null,inst_18814,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18817 = cljs.core.get.call(null,inst_18814,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18818 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18819 = [inst_18815,inst_18816,toBlock,toTime];
var inst_18820 = cljs.core.PersistentHashMap.fromArrays(inst_18818,inst_18819);
var inst_18821 = fluree.db.operations.send_operation.call(null,inst_18817,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18820);
var state_18823__$1 = state_18823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18823__$1,inst_18821);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2746__auto__ = null;
var fluree$db$operations$state_machine__2746__auto____0 = (function (){
var statearr_18825 = [null,null,null,null,null,null,null];
(statearr_18825[(0)] = fluree$db$operations$state_machine__2746__auto__);

(statearr_18825[(1)] = (1));

return statearr_18825;
});
var fluree$db$operations$state_machine__2746__auto____1 = (function (state_18823){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_18823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e18826){var ex__2749__auto__ = e18826;
var statearr_18827_18833 = state_18823;
(statearr_18827_18833[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_18823[(4)]))){
var statearr_18828_18834 = state_18823;
(statearr_18828_18834[(1)] = cljs.core.first.call(null,(state_18823[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18835 = state_18823;
state_18823 = G__18835;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2746__auto__ = function(state_18823){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2746__auto____1.call(this,state_18823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2746__auto____0;
fluree$db$operations$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2746__auto____1;
return fluree$db$operations$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_18829 = f__2769__auto__.call(null);
(statearr_18829[(6)] = c__2768__auto__);

return statearr_18829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18805){
var G__18806 = cljs.core.first.call(null,seq18805);
var seq18805__$1 = cljs.core.next.call(null,seq18805);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18806,seq18805__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18836 = session;
var map__18836__$1 = cljs.core.__destructure_map.call(null,map__18836);
var network = cljs.core.get.call(null,map__18836__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__18836__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__18836__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18838 = arguments.length;
switch (G__18838) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18839 = opts;
var map__18839__$1 = cljs.core.__destructure_map.call(null,map__18839);
var auth = cljs.core.get.call(null,map__18839__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__18839__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
