// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26457 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__26457,(0),null);
var network = cljs.core.nth.call(null,vec__26457,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__26457,(2),null);
if(cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__26460){
var map__26461 = p__26460;
var map__26461__$1 = cljs.core.__destructure_map.call(null,map__26461);
var opts = map__26461__$1;
var reindex_QMARK_ = cljs.core.get.call(null,map__26461__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26521){
var state_val_26522 = (state_26521[(1)]);
if((state_val_26522 === (7))){
var inst_26492 = cljs.core.not.call(null,reindex_QMARK_);
var state_26521__$1 = state_26521;
var statearr_26523_26547 = state_26521__$1;
(statearr_26523_26547[(2)] = inst_26492);

(statearr_26523_26547[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (1))){
var state_26521__$1 = state_26521;
var statearr_26524_26548 = state_26521__$1;
(statearr_26524_26548[(2)] = null);

(statearr_26524_26548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (4))){
var inst_26462 = (state_26521[(2)]);
var state_26521__$1 = state_26521;
var statearr_26525_26549 = state_26521__$1;
(statearr_26525_26549[(2)] = inst_26462);

(statearr_26525_26549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (6))){
var inst_26490 = (state_26521[(7)]);
var inst_26482 = (state_26521[(8)]);
var inst_26476 = (state_26521[(9)]);
var inst_26475 = (state_26521[(2)]);
var inst_26476__$1 = fluree.db.util.async.throw_err.call(null,inst_26475);
var inst_26477 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26478 = cljs.core.__destructure_map.call(null,inst_26477);
var inst_26479 = cljs.core.get.call(null,inst_26478,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26480 = cljs.core.get.call(null,inst_26478,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26481 = fluree.db.flake.size_bytes.call(null,inst_26476__$1);
var inst_26482__$1 = (inst_26480 + inst_26481);
var inst_26483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26484 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26485 = (new cljs.core.PersistentVector(null,2,(5),inst_26483,inst_26484,null));
var inst_26486 = cljs.core.get_in.call(null,db,inst_26485);
var inst_26487 = cljs.core.__destructure_map.call(null,inst_26486);
var inst_26488 = cljs.core.get.call(null,inst_26487,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26489 = cljs.core.get.call(null,inst_26487,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26490__$1 = (inst_26482__$1 > inst_26489);
var state_26521__$1 = (function (){var statearr_26526 = state_26521;
(statearr_26526[(10)] = inst_26479);

(statearr_26526[(7)] = inst_26490__$1);

(statearr_26526[(8)] = inst_26482__$1);

(statearr_26526[(11)] = inst_26488);

(statearr_26526[(9)] = inst_26476__$1);

return statearr_26526;
})();
if(cljs.core.truth_(inst_26490__$1)){
var statearr_26527_26550 = state_26521__$1;
(statearr_26527_26550[(1)] = (7));

} else {
var statearr_26528_26551 = state_26521__$1;
(statearr_26528_26551[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (3))){
var inst_26519 = (state_26521[(2)]);
var state_26521__$1 = state_26521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26521__$1,inst_26519);
} else {
if((state_val_26522 === (12))){
var inst_26479 = (state_26521[(10)]);
var inst_26482 = (state_26521[(8)]);
var inst_26476 = (state_26521[(9)]);
var inst_26505 = (state_26521[(2)]);
var inst_26506 = cljs.core.into.call(null,inst_26479,inst_26476);
var inst_26507 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26508 = cljs.core.swap_BANG_.call(null,inst_26507,cljs.core.empty);
var inst_26509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26510 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26511 = (new cljs.core.PersistentVector(null,2,(5),inst_26509,inst_26510,null));
var inst_26512 = cljs.core.assoc_in.call(null,db,inst_26511,inst_26506);
var inst_26513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26514 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26515 = (new cljs.core.PersistentVector(null,2,(5),inst_26513,inst_26514,null));
var inst_26516 = cljs.core.assoc_in.call(null,inst_26512,inst_26515,inst_26482);
var _ = (function (){var statearr_26529 = state_26521;
(statearr_26529[(4)] = cljs.core.rest.call(null,(state_26521[(4)])));

return statearr_26529;
})();
var state_26521__$1 = (function (){var statearr_26530 = state_26521;
(statearr_26530[(12)] = inst_26505);

(statearr_26530[(13)] = inst_26508);

return statearr_26530;
})();
var statearr_26531_26552 = state_26521__$1;
(statearr_26531_26552[(2)] = inst_26516);

(statearr_26531_26552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (2))){
var _ = (function (){var statearr_26532 = state_26521;
(statearr_26532[(4)] = cljs.core.cons.call(null,(5),(state_26521[(4)])));

return statearr_26532;
})();
var inst_26470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26471 = [pred_id];
var inst_26472 = (new cljs.core.PersistentVector(null,1,(5),inst_26470,inst_26471,null));
var inst_26473 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26472);
var state_26521__$1 = state_26521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26521__$1,(6),inst_26473);
} else {
if((state_val_26522 === (11))){
var state_26521__$1 = state_26521;
var statearr_26534_26553 = state_26521__$1;
(statearr_26534_26553[(2)] = null);

(statearr_26534_26553[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (9))){
var inst_26495 = (state_26521[(2)]);
var state_26521__$1 = state_26521;
if(cljs.core.truth_(inst_26495)){
var statearr_26535_26554 = state_26521__$1;
(statearr_26535_26554[(1)] = (10));

} else {
var statearr_26536_26555 = state_26521__$1;
(statearr_26536_26555[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (5))){
var _ = (function (){var statearr_26537 = state_26521;
(statearr_26537[(4)] = cljs.core.rest.call(null,(state_26521[(4)])));

return statearr_26537;
})();
var state_26521__$1 = state_26521;
var ex26533 = (state_26521__$1[(2)]);
var statearr_26538_26556 = state_26521__$1;
(statearr_26538_26556[(5)] = ex26533);


if((ex26533 instanceof Error)){
var statearr_26539_26557 = state_26521__$1;
(statearr_26539_26557[(1)] = (4));

(statearr_26539_26557[(5)] = null);

} else {
throw ex26533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (10))){
var inst_26497 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26498 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26499 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26500 = cljs.core.PersistentHashMap.fromArrays(inst_26498,inst_26499);
var inst_26501 = cljs.core.ex_info.call(null,inst_26497,inst_26500);
var inst_26502 = (function(){throw inst_26501})();
var state_26521__$1 = state_26521;
var statearr_26540_26558 = state_26521__$1;
(statearr_26540_26558[(2)] = inst_26502);

(statearr_26540_26558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26522 === (8))){
var inst_26490 = (state_26521[(7)]);
var state_26521__$1 = state_26521;
var statearr_26541_26559 = state_26521__$1;
(statearr_26541_26559[(2)] = inst_26490);

(statearr_26541_26559[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0 = (function (){
var statearr_26542 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26542[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__);

(statearr_26542[(1)] = (1));

return statearr_26542;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1 = (function (state_26521){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26543){var ex__2749__auto__ = e26543;
var statearr_26544_26560 = state_26521;
(statearr_26544_26560[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26521[(4)]))){
var statearr_26545_26561 = state_26521;
(statearr_26545_26561[(1)] = cljs.core.first.call(null,(state_26521[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26562 = state_26521;
state_26521 = G__26562;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__ = function(state_26521){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1.call(this,state_26521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26546 = f__2769__auto__.call(null);
(statearr_26546[(6)] = c__2768__auto__);

return statearr_26546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__26567 = arguments.length;
switch (G__26567) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.call(null,db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26763){
var state_val_26764 = (state_26763[(1)]);
if((state_val_26764 === (7))){
var state_26763__$1 = state_26763;
var statearr_26765_26832 = state_26763__$1;
(statearr_26765_26832[(2)] = null);

(statearr_26765_26832[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (20))){
var inst_26606 = (state_26763[(7)]);
var inst_26686 = (state_26763[(8)]);
var inst_26605 = (state_26763[(9)]);
var inst_26685 = (state_26763[(10)]);
var inst_26656 = (state_26763[(11)]);
var inst_26687 = (state_26763[(12)]);
var inst_26689 = (state_26763[(13)]);
var inst_26688 = (state_26763[(14)]);
var inst_26699 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26701 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26702 = (new cljs.core.PersistentVector(null,2,(5),inst_26700,inst_26701,null));
var inst_26703 = cljs.core.get_in.call(null,inst_26656,inst_26702);
var inst_26704 = (inst_26605 + inst_26703);
var inst_26705 = [inst_26685,inst_26686,inst_26687,inst_26688,inst_26704];
var inst_26706 = cljs.core.PersistentHashMap.fromArrays(inst_26699,inst_26705);
var inst_26707 = cljs.core.assoc.call(null,inst_26656,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26689,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26706);
var state_26763__$1 = (function (){var statearr_26766 = state_26763;
(statearr_26766[(15)] = inst_26707);

return statearr_26766;
})();
if(cljs.core.truth_(inst_26606)){
var statearr_26767_26833 = state_26763__$1;
(statearr_26767_26833[(1)] = (23));

} else {
var statearr_26768_26834 = state_26763__$1;
(statearr_26768_26834[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (27))){
var inst_26707 = (state_26763[(15)]);
var state_26763__$1 = state_26763;
var statearr_26769_26835 = state_26763__$1;
(statearr_26769_26835[(2)] = inst_26707);

(statearr_26769_26835[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (1))){
var state_26763__$1 = state_26763;
var statearr_26770_26836 = state_26763__$1;
(statearr_26770_26836[(2)] = null);

(statearr_26770_26836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (24))){
var inst_26707 = (state_26763[(15)]);
var inst_26710 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26707);
var inst_26711 = (inst_26710 == null);
var state_26763__$1 = state_26763;
var statearr_26771_26837 = state_26763__$1;
(statearr_26771_26837[(2)] = inst_26711);

(statearr_26771_26837[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (39))){
var inst_26737 = (state_26763[(16)]);
var inst_26738 = (state_26763[(17)]);
var inst_26696 = (state_26763[(18)]);
var inst_26739 = (state_26763[(19)]);
var inst_26746 = (state_26763[(20)]);
var inst_26753 = (state_26763[(2)]);
var inst_26684 = inst_26696;
var inst_26685 = inst_26738;
var inst_26686 = inst_26739;
var inst_26687 = inst_26746;
var inst_26688 = inst_26753;
var inst_26689 = inst_26737;
var state_26763__$1 = (function (){var statearr_26772 = state_26763;
(statearr_26772[(8)] = inst_26686);

(statearr_26772[(21)] = inst_26684);

(statearr_26772[(10)] = inst_26685);

(statearr_26772[(12)] = inst_26687);

(statearr_26772[(13)] = inst_26689);

(statearr_26772[(14)] = inst_26688);

return statearr_26772;
})();
var statearr_26773_26838 = state_26763__$1;
(statearr_26773_26838[(2)] = null);

(statearr_26773_26838[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (4))){
var inst_26568 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
var statearr_26774_26839 = state_26763__$1;
(statearr_26774_26839[(2)] = inst_26568);

(statearr_26774_26839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (15))){
var inst_26628 = (state_26763[(22)]);
var state_26763__$1 = state_26763;
var statearr_26775_26840 = state_26763__$1;
(statearr_26775_26840[(2)] = inst_26628);

(statearr_26775_26840[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (21))){
var inst_26606 = (state_26763[(7)]);
var inst_26596 = (state_26763[(23)]);
var inst_26607 = (state_26763[(24)]);
var inst_26686 = (state_26763[(8)]);
var inst_26592 = (state_26763[(25)]);
var inst_26684 = (state_26763[(21)]);
var inst_26590 = (state_26763[(26)]);
var inst_26600 = (state_26763[(27)]);
var inst_26665 = (state_26763[(28)]);
var inst_26609 = (state_26763[(29)]);
var inst_26695 = (state_26763[(30)]);
var inst_26605 = (state_26763[(9)]);
var inst_26685 = (state_26763[(10)]);
var inst_26604 = (state_26763[(31)]);
var inst_26696 = (state_26763[(18)]);
var inst_26575 = (state_26763[(32)]);
var inst_26656 = (state_26763[(11)]);
var inst_26666 = (state_26763[(33)]);
var inst_26687 = (state_26763[(12)]);
var inst_26615 = (state_26763[(34)]);
var inst_26689 = (state_26763[(13)]);
var inst_26688 = (state_26763[(14)]);
var inst_26734 = inst_26695.s;
var inst_26735 = fluree.db.flake.sid__GT_cid.call(null,inst_26734);
var inst_26736 = (function (){var flakes_bytes = inst_26605;
var t = inst_26575;
var seq__26662 = inst_26666;
var seq__26692 = inst_26696;
var first__26693 = inst_26695;
var spot = inst_26685;
var add_flakes = inst_26592;
var root_setting_change_QMARK_ = inst_26607;
var ref_QMARK__map = inst_26604;
var r = inst_26696;
var psot = inst_26686;
var G__26660 = inst_26684;
var add_pred_to_idx_QMARK_ = inst_26615;
var _ = inst_26590;
var vec__26661 = inst_26592;
var cid = inst_26735;
var ecount = inst_26689;
var pred_ecount = inst_26609;
var vec__26691 = inst_26684;
var first__26663 = inst_26665;
var db_STAR_ = inst_26656;
var schema_change_QMARK_ = inst_26606;
var add_preds = inst_26596;
var opst = inst_26688;
var idx_QMARK__map = inst_26600;
var post = inst_26687;
var f = inst_26695;
return (function (p1__26565_SHARP_){
if(cljs.core.truth_(p1__26565_SHARP_)){
var x__4336__auto__ = p1__26565_SHARP_;
var y__4337__auto__ = f.s;
return ((x__4336__auto__ > y__4337__auto__) ? x__4336__auto__ : y__4337__auto__);
} else {
return f.s;
}
});
})();
var inst_26737 = cljs.core.update.call(null,inst_26689,inst_26735,inst_26736);
var inst_26738 = cljs.core.conj.call(null,inst_26685,inst_26695);
var inst_26739 = cljs.core.conj.call(null,inst_26686,inst_26695);
var inst_26740 = inst_26695.p;
var inst_26741 = cljs.core.get.call(null,inst_26600,inst_26740);
var state_26763__$1 = (function (){var statearr_26776 = state_26763;
(statearr_26776[(16)] = inst_26737);

(statearr_26776[(17)] = inst_26738);

(statearr_26776[(19)] = inst_26739);

return statearr_26776;
})();
if(cljs.core.truth_(inst_26741)){
var statearr_26777_26841 = state_26763__$1;
(statearr_26777_26841[(1)] = (34));

} else {
var statearr_26778_26842 = state_26763__$1;
(statearr_26778_26842[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (31))){
var inst_26722 = (state_26763[(35)]);
var state_26763__$1 = state_26763;
var statearr_26779_26843 = state_26763__$1;
(statearr_26779_26843[(2)] = inst_26722);

(statearr_26779_26843[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (32))){
var inst_26732 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
var statearr_26780_26844 = state_26763__$1;
(statearr_26780_26844[(2)] = inst_26732);

(statearr_26780_26844[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (33))){
var inst_26722 = (state_26763[(35)]);
var inst_26727 = (state_26763[(2)]);
var inst_26728 = fluree.db.util.async.throw_err.call(null,inst_26727);
var inst_26729 = cljs.core.assoc.call(null,inst_26722,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26728);
var state_26763__$1 = state_26763;
var statearr_26781_26845 = state_26763__$1;
(statearr_26781_26845[(2)] = inst_26729);

(statearr_26781_26845[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (13))){
var inst_26592 = (state_26763[(25)]);
var inst_26605 = (state_26763[(9)]);
var inst_26575 = (state_26763[(32)]);
var inst_26656 = (state_26763[(11)]);
var inst_26646 = (state_26763[(2)]);
var inst_26647 = cljs.core.assoc.call(null,inst_26646,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26575);
var inst_26648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26649 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26650 = (new cljs.core.PersistentVector(null,2,(5),inst_26648,inst_26649,null));
var inst_26651 = cljs.core.update_in.call(null,inst_26647,inst_26650,cljs.core._PLUS_,inst_26605);
var inst_26652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26653 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26654 = (new cljs.core.PersistentVector(null,2,(5),inst_26652,inst_26653,null));
var inst_26655 = cljs.core.count.call(null,inst_26592);
var inst_26656__$1 = cljs.core.update_in.call(null,inst_26651,inst_26654,cljs.core._PLUS_,inst_26655);
var inst_26664 = cljs.core.seq.call(null,inst_26592);
var inst_26665 = cljs.core.first.call(null,inst_26664);
var inst_26666 = cljs.core.next.call(null,inst_26664);
var inst_26667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26668 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26669 = (new cljs.core.PersistentVector(null,2,(5),inst_26667,inst_26668,null));
var inst_26670 = cljs.core.get_in.call(null,inst_26656__$1,inst_26669);
var inst_26671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26672 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26673 = (new cljs.core.PersistentVector(null,2,(5),inst_26671,inst_26672,null));
var inst_26674 = cljs.core.get_in.call(null,inst_26656__$1,inst_26673);
var inst_26675 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26676 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26677 = (new cljs.core.PersistentVector(null,2,(5),inst_26675,inst_26676,null));
var inst_26678 = cljs.core.get_in.call(null,inst_26656__$1,inst_26677);
var inst_26679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26680 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26681 = (new cljs.core.PersistentVector(null,2,(5),inst_26679,inst_26680,null));
var inst_26682 = cljs.core.get_in.call(null,inst_26656__$1,inst_26681);
var inst_26683 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26684 = inst_26592;
var inst_26685 = inst_26670;
var inst_26686 = inst_26674;
var inst_26687 = inst_26678;
var inst_26688 = inst_26682;
var inst_26689 = inst_26683;
var state_26763__$1 = (function (){var statearr_26782 = state_26763;
(statearr_26782[(8)] = inst_26686);

(statearr_26782[(21)] = inst_26684);

(statearr_26782[(28)] = inst_26665);

(statearr_26782[(10)] = inst_26685);

(statearr_26782[(11)] = inst_26656__$1);

(statearr_26782[(33)] = inst_26666);

(statearr_26782[(12)] = inst_26687);

(statearr_26782[(13)] = inst_26689);

(statearr_26782[(14)] = inst_26688);

return statearr_26782;
})();
var statearr_26783_26846 = state_26763__$1;
(statearr_26783_26846[(2)] = null);

(statearr_26783_26846[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (22))){
var inst_26756 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
var statearr_26784_26847 = state_26763__$1;
(statearr_26784_26847[(2)] = inst_26756);

(statearr_26784_26847[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (36))){
var inst_26695 = (state_26763[(30)]);
var inst_26604 = (state_26763[(31)]);
var inst_26746 = (state_26763[(2)]);
var inst_26747 = inst_26695.p;
var inst_26748 = cljs.core.get.call(null,inst_26604,inst_26747);
var state_26763__$1 = (function (){var statearr_26785 = state_26763;
(statearr_26785[(20)] = inst_26746);

return statearr_26785;
})();
if(cljs.core.truth_(inst_26748)){
var statearr_26786_26848 = state_26763__$1;
(statearr_26786_26848[(1)] = (37));

} else {
var statearr_26787_26849 = state_26763__$1;
(statearr_26787_26849[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (29))){
var inst_26707 = (state_26763[(15)]);
var inst_26717 = (state_26763[(2)]);
var inst_26718 = fluree.db.util.async.throw_err.call(null,inst_26717);
var inst_26719 = cljs.core.assoc.call(null,inst_26707,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26718);
var state_26763__$1 = state_26763;
var statearr_26788_26850 = state_26763__$1;
(statearr_26788_26850[(2)] = inst_26719);

(statearr_26788_26850[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (6))){
var inst_26575 = (state_26763[(32)]);
var inst_26580 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26581 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26582 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26580)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26581)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26575),"."].join('');
var inst_26583 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26584 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26585 = cljs.core.PersistentHashMap.fromArrays(inst_26583,inst_26584);
var inst_26586 = cljs.core.ex_info.call(null,inst_26582,inst_26585);
var inst_26587 = (function(){throw inst_26586})();
var state_26763__$1 = state_26763;
var statearr_26789_26851 = state_26763__$1;
(statearr_26789_26851[(2)] = inst_26587);

(statearr_26789_26851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (28))){
var inst_26607 = (state_26763[(24)]);
var inst_26722 = (state_26763[(2)]);
var state_26763__$1 = (function (){var statearr_26790 = state_26763;
(statearr_26790[(35)] = inst_26722);

return statearr_26790;
})();
if(cljs.core.truth_(inst_26607)){
var statearr_26791_26852 = state_26763__$1;
(statearr_26791_26852[(1)] = (30));

} else {
var statearr_26792_26853 = state_26763__$1;
(statearr_26792_26853[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (25))){
var inst_26713 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
if(cljs.core.truth_(inst_26713)){
var statearr_26793_26854 = state_26763__$1;
(statearr_26793_26854[(1)] = (26));

} else {
var statearr_26794_26855 = state_26763__$1;
(statearr_26794_26855[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (34))){
var inst_26695 = (state_26763[(30)]);
var inst_26687 = (state_26763[(12)]);
var inst_26743 = cljs.core.conj.call(null,inst_26687,inst_26695);
var state_26763__$1 = state_26763;
var statearr_26795_26856 = state_26763__$1;
(statearr_26795_26856[(2)] = inst_26743);

(statearr_26795_26856[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (17))){
var inst_26635 = (state_26763[(36)]);
var inst_26639 = (state_26763[(2)]);
var inst_26640 = fluree.db.util.async.throw_err.call(null,inst_26639);
var inst_26627 = inst_26635;
var inst_26628 = inst_26640;
var state_26763__$1 = (function (){var statearr_26796 = state_26763;
(statearr_26796[(22)] = inst_26628);

(statearr_26796[(37)] = inst_26627);

return statearr_26796;
})();
var statearr_26797_26857 = state_26763__$1;
(statearr_26797_26857[(2)] = null);

(statearr_26797_26857[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (3))){
var inst_26761 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26763__$1,inst_26761);
} else {
if((state_val_26764 === (12))){
var inst_26634 = (state_26763[(38)]);
var inst_26627 = (state_26763[(37)]);
var inst_26633 = cljs.core.seq.call(null,inst_26627);
var inst_26634__$1 = cljs.core.first.call(null,inst_26633);
var inst_26635 = cljs.core.next.call(null,inst_26633);
var state_26763__$1 = (function (){var statearr_26798 = state_26763;
(statearr_26798[(36)] = inst_26635);

(statearr_26798[(38)] = inst_26634__$1);

return statearr_26798;
})();
if(cljs.core.truth_(inst_26634__$1)){
var statearr_26799_26858 = state_26763__$1;
(statearr_26799_26858[(1)] = (14));

} else {
var statearr_26800_26859 = state_26763__$1;
(statearr_26800_26859[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (2))){
var inst_26575 = (state_26763[(32)]);
var _ = (function (){var statearr_26801 = state_26763;
(statearr_26801[(4)] = cljs.core.cons.call(null,(5),(state_26763[(4)])));

return statearr_26801;
})();
var inst_26574 = cljs.core.first.call(null,flakes);
var inst_26575__$1 = inst_26574.t;
var inst_26576 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26577 = (inst_26576 - (1));
var inst_26578 = cljs.core.not_EQ_.call(null,inst_26575__$1,inst_26577);
var state_26763__$1 = (function (){var statearr_26802 = state_26763;
(statearr_26802[(32)] = inst_26575__$1);

return statearr_26802;
})();
if(inst_26578){
var statearr_26803_26860 = state_26763__$1;
(statearr_26803_26860[(1)] = (6));

} else {
var statearr_26804_26861 = state_26763__$1;
(statearr_26804_26861[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (23))){
var inst_26606 = (state_26763[(7)]);
var state_26763__$1 = state_26763;
var statearr_26805_26862 = state_26763__$1;
(statearr_26805_26862[(2)] = inst_26606);

(statearr_26805_26862[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (35))){
var inst_26687 = (state_26763[(12)]);
var state_26763__$1 = state_26763;
var statearr_26806_26863 = state_26763__$1;
(statearr_26806_26863[(2)] = inst_26687);

(statearr_26806_26863[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (19))){
var inst_26758 = (state_26763[(2)]);
var _ = (function (){var statearr_26807 = state_26763;
(statearr_26807[(4)] = cljs.core.rest.call(null,(state_26763[(4)])));

return statearr_26807;
})();
var state_26763__$1 = state_26763;
var statearr_26808_26864 = state_26763__$1;
(statearr_26808_26864[(2)] = inst_26758);

(statearr_26808_26864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (11))){
var inst_26615 = (state_26763[(34)]);
var inst_26615__$1 = (state_26763[(2)]);
var inst_26623 = cljs.core.seq.call(null,inst_26615__$1);
var inst_26624 = cljs.core.first.call(null,inst_26623);
var inst_26625 = cljs.core.next.call(null,inst_26623);
var inst_26626 = db;
var inst_26627 = inst_26615__$1;
var inst_26628 = inst_26626;
var state_26763__$1 = (function (){var statearr_26810 = state_26763;
(statearr_26810[(22)] = inst_26628);

(statearr_26810[(39)] = inst_26624);

(statearr_26810[(34)] = inst_26615__$1);

(statearr_26810[(40)] = inst_26625);

(statearr_26810[(37)] = inst_26627);

return statearr_26810;
})();
var statearr_26811_26865 = state_26763__$1;
(statearr_26811_26865[(2)] = null);

(statearr_26811_26865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (9))){
var inst_26592 = (state_26763[(25)]);
var inst_26609 = (state_26763[(29)]);
var inst_26611 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26592,inst_26609);
var state_26763__$1 = state_26763;
var statearr_26812_26866 = state_26763__$1;
(statearr_26812_26866[(2)] = inst_26611);

(statearr_26812_26866[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (5))){
var _ = (function (){var statearr_26813 = state_26763;
(statearr_26813[(4)] = cljs.core.rest.call(null,(state_26763[(4)])));

return statearr_26813;
})();
var state_26763__$1 = state_26763;
var ex26809 = (state_26763__$1[(2)]);
var statearr_26814_26867 = state_26763__$1;
(statearr_26814_26867[(5)] = ex26809);


if((ex26809 instanceof Error)){
var statearr_26815_26868 = state_26763__$1;
(statearr_26815_26868[(1)] = (4));

(statearr_26815_26868[(5)] = null);

} else {
throw ex26809;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (14))){
var inst_26628 = (state_26763[(22)]);
var inst_26634 = (state_26763[(38)]);
var inst_26637 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26628,inst_26634,opts);
var state_26763__$1 = state_26763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26763__$1,(17),inst_26637);
} else {
if((state_val_26764 === (26))){
var inst_26707 = (state_26763[(15)]);
var inst_26715 = fluree.db.query.schema.schema_map.call(null,inst_26707);
var state_26763__$1 = state_26763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26763__$1,(29),inst_26715);
} else {
if((state_val_26764 === (16))){
var inst_26644 = (state_26763[(2)]);
var state_26763__$1 = state_26763;
var statearr_26816_26869 = state_26763__$1;
(statearr_26816_26869[(2)] = inst_26644);

(statearr_26816_26869[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (38))){
var inst_26688 = (state_26763[(14)]);
var state_26763__$1 = state_26763;
var statearr_26817_26870 = state_26763__$1;
(statearr_26817_26870[(2)] = inst_26688);

(statearr_26817_26870[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (30))){
var inst_26722 = (state_26763[(35)]);
var inst_26725 = fluree.db.query.schema.setting_map.call(null,inst_26722);
var state_26763__$1 = state_26763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26763__$1,(33),inst_26725);
} else {
if((state_val_26764 === (10))){
var inst_26613 = cljs.core.PersistentVector.EMPTY;
var state_26763__$1 = state_26763;
var statearr_26818_26871 = state_26763__$1;
(statearr_26818_26871[(2)] = inst_26613);

(statearr_26818_26871[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (18))){
var inst_26684 = (state_26763[(21)]);
var inst_26695 = (state_26763[(30)]);
var inst_26694 = cljs.core.seq.call(null,inst_26684);
var inst_26695__$1 = cljs.core.first.call(null,inst_26694);
var inst_26696 = cljs.core.next.call(null,inst_26694);
var inst_26697 = cljs.core.not.call(null,inst_26695__$1);
var state_26763__$1 = (function (){var statearr_26819 = state_26763;
(statearr_26819[(30)] = inst_26695__$1);

(statearr_26819[(18)] = inst_26696);

return statearr_26819;
})();
if(inst_26697){
var statearr_26820_26872 = state_26763__$1;
(statearr_26820_26872[(1)] = (20));

} else {
var statearr_26821_26873 = state_26763__$1;
(statearr_26821_26873[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (37))){
var inst_26695 = (state_26763[(30)]);
var inst_26688 = (state_26763[(14)]);
var inst_26750 = cljs.core.conj.call(null,inst_26688,inst_26695);
var state_26763__$1 = state_26763;
var statearr_26822_26874 = state_26763__$1;
(statearr_26822_26874[(2)] = inst_26750);

(statearr_26822_26874[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26764 === (8))){
var inst_26606 = (state_26763[(7)]);
var inst_26596 = (state_26763[(23)]);
var inst_26592 = (state_26763[(25)]);
var inst_26590 = (state_26763[(26)]);
var inst_26600 = (state_26763[(27)]);
var inst_26575 = (state_26763[(32)]);
var inst_26590__$1 = (state_26763[(2)]);
var inst_26591 = (function (){var t = inst_26575;
var _ = inst_26590__$1;
return (function (p1__26563_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26563_SHARP_.p));
});
})();
var inst_26592__$1 = cljs.core.filter.call(null,inst_26591,flakes);
var inst_26593 = cljs.core.PersistentHashSet.EMPTY;
var inst_26594 = (function (){var t = inst_26575;
var _ = inst_26590__$1;
var add_flakes = inst_26592__$1;
return (function (p1__26564_SHARP_){
return p1__26564_SHARP_.p;
});
})();
var inst_26595 = cljs.core.map.call(null,inst_26594,inst_26592__$1);
var inst_26596__$1 = cljs.core.into.call(null,inst_26593,inst_26595);
var inst_26597 = cljs.core.PersistentHashMap.EMPTY;
var inst_26598 = (function (){var t = inst_26575;
var _ = inst_26590__$1;
var add_flakes = inst_26592__$1;
var add_preds = inst_26596__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26599 = cljs.core.map.call(null,inst_26598,inst_26596__$1);
var inst_26600__$1 = cljs.core.into.call(null,inst_26597,inst_26599);
var inst_26601 = cljs.core.PersistentHashMap.EMPTY;
var inst_26602 = (function (){var t = inst_26575;
var _ = inst_26590__$1;
var add_flakes = inst_26592__$1;
var add_preds = inst_26596__$1;
var idx_QMARK__map = inst_26600__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26603 = cljs.core.map.call(null,inst_26602,inst_26596__$1);
var inst_26604 = cljs.core.into.call(null,inst_26601,inst_26603);
var inst_26605 = fluree.db.flake.size_bytes.call(null,inst_26592__$1);
var inst_26606__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26592__$1);
var inst_26607 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26592__$1);
var inst_26608 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26609 = cljs.core.get.call(null,inst_26608,(0));
var state_26763__$1 = (function (){var statearr_26823 = state_26763;
(statearr_26823[(7)] = inst_26606__$1);

(statearr_26823[(23)] = inst_26596__$1);

(statearr_26823[(24)] = inst_26607);

(statearr_26823[(25)] = inst_26592__$1);

(statearr_26823[(26)] = inst_26590__$1);

(statearr_26823[(27)] = inst_26600__$1);

(statearr_26823[(29)] = inst_26609);

(statearr_26823[(9)] = inst_26605);

(statearr_26823[(31)] = inst_26604);

return statearr_26823;
})();
if(cljs.core.truth_(inst_26606__$1)){
var statearr_26824_26875 = state_26763__$1;
(statearr_26824_26875[(1)] = (9));

} else {
var statearr_26825_26876 = state_26763__$1;
(statearr_26825_26876[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_26826 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26826[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_26826[(1)] = (1));

return statearr_26826;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26763){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26827){var ex__2749__auto__ = e26827;
var statearr_26828_26877 = state_26763;
(statearr_26828_26877[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26763[(4)]))){
var statearr_26829_26878 = state_26763;
(statearr_26829_26878[(1)] = cljs.core.first.call(null,(state_26763[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26879 = state_26763;
state_26763 = G__26879;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26763){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26830 = f__2769__auto__.call(null);
(statearr_26830[(6)] = c__2768__auto__);

return statearr_26830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26881 = arguments.length;
switch (G__26881) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.call(null,db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2768__auto___27028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26977){
var state_val_26978 = (state_26977[(1)]);
if((state_val_26978 === (7))){
var state_26977__$1 = state_26977;
var statearr_26979_27029 = state_26977__$1;
(statearr_26979_27029[(2)] = null);

(statearr_26979_27029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (20))){
var inst_26925 = (state_26977[(7)]);
var inst_26926 = (state_26977[(8)]);
var inst_26927 = (state_26977[(9)]);
var inst_26946 = (inst_26925 + (1));
var inst_26947 = cljs.core.assoc.call(null,inst_26927,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26946);
var inst_26948 = fluree.db.graphdb.with_t.call(null,inst_26947,inst_26926,opts);
var state_26977__$1 = state_26977;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26977__$1,(23),inst_26948);
} else {
if((state_val_26978 === (1))){
var state_26977__$1 = state_26977;
var statearr_26980_27030 = state_26977__$1;
(statearr_26980_27030[(2)] = null);

(statearr_26980_27030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (24))){
var inst_26951 = (state_26977[(10)]);
var inst_26954 = cljs.core.assoc.call(null,inst_26951,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26977__$1 = state_26977;
var statearr_26981_27031 = state_26977__$1;
(statearr_26981_27031[(2)] = inst_26954);

(statearr_26981_27031[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (4))){
var inst_26882 = (state_26977[(2)]);
var inst_26883 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26882);
var state_26977__$1 = state_26977;
var statearr_26982_27032 = state_26977__$1;
(statearr_26982_27032[(2)] = inst_26883);

(statearr_26982_27032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (15))){
var inst_26933 = (state_26977[(11)]);
var state_26977__$1 = state_26977;
var statearr_26983_27033 = state_26977__$1;
(statearr_26983_27033[(2)] = inst_26933);

(statearr_26983_27033[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (21))){
var state_26977__$1 = state_26977;
var statearr_26984_27034 = state_26977__$1;
(statearr_26984_27034[(2)] = null);

(statearr_26984_27034[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (13))){
var inst_26969 = (state_26977[(2)]);
var inst_26970 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26969);
var state_26977__$1 = state_26977;
var statearr_26985_27035 = state_26977__$1;
(statearr_26985_27035[(2)] = inst_26970);

(statearr_26985_27035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (22))){
var inst_26965 = (state_26977[(2)]);
var state_26977__$1 = state_26977;
var statearr_26986_27036 = state_26977__$1;
(statearr_26986_27036[(2)] = inst_26965);

(statearr_26986_27036[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (6))){
var inst_26893 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26894 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26895 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26893)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26894)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26897 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26898 = cljs.core.PersistentHashMap.fromArrays(inst_26896,inst_26897);
var inst_26899 = cljs.core.ex_info.call(null,inst_26895,inst_26898);
var inst_26900 = (function(){throw inst_26899})();
var state_26977__$1 = state_26977;
var statearr_26989_27037 = state_26977__$1;
(statearr_26989_27037[(2)] = inst_26900);

(statearr_26989_27037[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (25))){
var inst_26934 = (state_26977[(12)]);
var inst_26933 = (state_26977[(11)]);
var inst_26951 = (state_26977[(10)]);
var inst_26956 = inst_26933.t;
var inst_26957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26958 = [inst_26933];
var inst_26959 = (new cljs.core.PersistentVector(null,1,(5),inst_26957,inst_26958,null));
var inst_26924 = inst_26934;
var inst_26925 = inst_26956;
var inst_26926 = inst_26959;
var inst_26927 = inst_26951;
var state_26977__$1 = (function (){var statearr_26990 = state_26977;
(statearr_26990[(7)] = inst_26925);

(statearr_26990[(8)] = inst_26926);

(statearr_26990[(9)] = inst_26927);

(statearr_26990[(13)] = inst_26924);

return statearr_26990;
})();
var statearr_26991_27038 = state_26977__$1;
(statearr_26991_27038[(2)] = null);

(statearr_26991_27038[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (17))){
var inst_26925 = (state_26977[(7)]);
var inst_26926 = (state_26977[(8)]);
var inst_26934 = (state_26977[(12)]);
var inst_26933 = (state_26977[(11)]);
var inst_26927 = (state_26977[(9)]);
var inst_26942 = cljs.core.conj.call(null,inst_26926,inst_26933);
var tmp26987 = inst_26925;
var tmp26988 = inst_26927;
var inst_26924 = inst_26934;
var inst_26925__$1 = tmp26987;
var inst_26926__$1 = inst_26942;
var inst_26927__$1 = tmp26988;
var state_26977__$1 = (function (){var statearr_26992 = state_26977;
(statearr_26992[(7)] = inst_26925__$1);

(statearr_26992[(8)] = inst_26926__$1);

(statearr_26992[(9)] = inst_26927__$1);

(statearr_26992[(13)] = inst_26924);

return statearr_26992;
})();
var statearr_26993_27039 = state_26977__$1;
(statearr_26993_27039[(2)] = null);

(statearr_26993_27039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (3))){
var inst_26975 = (state_26977[(2)]);
var state_26977__$1 = state_26977;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26977__$1,inst_26975);
} else {
if((state_val_26978 === (12))){
var inst_26933 = (state_26977[(11)]);
var inst_26924 = (state_26977[(13)]);
var inst_26932 = cljs.core.seq.call(null,inst_26924);
var inst_26933__$1 = cljs.core.first.call(null,inst_26932);
var inst_26934 = cljs.core.next.call(null,inst_26932);
var state_26977__$1 = (function (){var statearr_26994 = state_26977;
(statearr_26994[(12)] = inst_26934);

(statearr_26994[(11)] = inst_26933__$1);

return statearr_26994;
})();
if(cljs.core.truth_(inst_26933__$1)){
var statearr_26995_27040 = state_26977__$1;
(statearr_26995_27040[(1)] = (14));

} else {
var statearr_26996_27041 = state_26977__$1;
(statearr_26996_27041[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (2))){
var _ = (function (){var statearr_26997 = state_26977;
(statearr_26997[(4)] = cljs.core.cons.call(null,(5),(state_26977[(4)])));

return statearr_26997;
})();
var inst_26889 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26890 = (inst_26889 + (1));
var inst_26891 = cljs.core.not_EQ_.call(null,block,inst_26890);
var state_26977__$1 = state_26977;
if(inst_26891){
var statearr_26998_27042 = state_26977__$1;
(statearr_26998_27042[(1)] = (6));

} else {
var statearr_26999_27043 = state_26977__$1;
(statearr_26999_27043[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (23))){
var inst_26933 = (state_26977[(11)]);
var inst_26950 = (state_26977[(2)]);
var inst_26951 = fluree.db.util.async.throw_err.call(null,inst_26950);
var inst_26952 = (inst_26933 == null);
var state_26977__$1 = (function (){var statearr_27000 = state_26977;
(statearr_27000[(10)] = inst_26951);

return statearr_27000;
})();
if(cljs.core.truth_(inst_26952)){
var statearr_27001_27044 = state_26977__$1;
(statearr_27001_27044[(1)] = (24));

} else {
var statearr_27002_27045 = state_26977__$1;
(statearr_27002_27045[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (19))){
var inst_26967 = (state_26977[(2)]);
var state_26977__$1 = state_26977;
var statearr_27003_27046 = state_26977__$1;
(statearr_27003_27046[(2)] = inst_26967);

(statearr_27003_27046[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (11))){
var inst_26972 = (state_26977[(2)]);
var _ = (function (){var statearr_27005 = state_26977;
(statearr_27005[(4)] = cljs.core.rest.call(null,(state_26977[(4)])));

return statearr_27005;
})();
var state_26977__$1 = state_26977;
var statearr_27006_27047 = state_26977__$1;
(statearr_27006_27047[(2)] = inst_26972);

(statearr_27006_27047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (9))){
var inst_26906 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26907 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26906);
var state_26977__$1 = state_26977;
var statearr_27007_27048 = state_26977__$1;
(statearr_27007_27048[(2)] = inst_26907);

(statearr_27007_27048[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (5))){
var _ = (function (){var statearr_27008 = state_26977;
(statearr_27008[(4)] = cljs.core.rest.call(null,(state_26977[(4)])));

return statearr_27008;
})();
var state_26977__$1 = state_26977;
var ex27004 = (state_26977__$1[(2)]);
var statearr_27009_27049 = state_26977__$1;
(statearr_27009_27049[(5)] = ex27004);


var statearr_27010_27050 = state_26977__$1;
(statearr_27010_27050[(1)] = (4));

(statearr_27010_27050[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (14))){
var inst_26925 = (state_26977[(7)]);
var inst_26933 = (state_26977[(11)]);
var inst_26936 = inst_26933.t;
var inst_26937 = cljs.core._EQ_.call(null,inst_26925,inst_26936);
var state_26977__$1 = state_26977;
var statearr_27011_27051 = state_26977__$1;
(statearr_27011_27051[(2)] = inst_26937);

(statearr_27011_27051[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (26))){
var inst_26962 = (state_26977[(2)]);
var state_26977__$1 = state_26977;
var statearr_27012_27052 = state_26977__$1;
(statearr_27012_27052[(2)] = inst_26962);

(statearr_27012_27052[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (16))){
var inst_26940 = (state_26977[(2)]);
var state_26977__$1 = state_26977;
if(cljs.core.truth_(inst_26940)){
var statearr_27013_27053 = state_26977__$1;
(statearr_27013_27053[(1)] = (17));

} else {
var statearr_27014_27054 = state_26977__$1;
(statearr_27014_27054[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (10))){
var inst_26909 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26910 = cljs.core.first.call(null,inst_26909);
var inst_26918 = cljs.core.seq.call(null,inst_26909);
var inst_26919 = cljs.core.first.call(null,inst_26918);
var inst_26920 = cljs.core.next.call(null,inst_26918);
var inst_26921 = inst_26910.t;
var inst_26922 = cljs.core.PersistentVector.EMPTY;
var inst_26923 = db;
var inst_26924 = inst_26909;
var inst_26925 = inst_26921;
var inst_26926 = inst_26922;
var inst_26927 = inst_26923;
var state_26977__$1 = (function (){var statearr_27015 = state_26977;
(statearr_27015[(7)] = inst_26925);

(statearr_27015[(8)] = inst_26926);

(statearr_27015[(14)] = inst_26920);

(statearr_27015[(9)] = inst_26927);

(statearr_27015[(15)] = inst_26919);

(statearr_27015[(13)] = inst_26924);

return statearr_27015;
})();
var statearr_27016_27055 = state_26977__$1;
(statearr_27016_27055[(2)] = null);

(statearr_27016_27055[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (18))){
var state_26977__$1 = state_26977;
var statearr_27017_27056 = state_26977__$1;
(statearr_27017_27056[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26978 === (8))){
var inst_26903 = (state_26977[(2)]);
var inst_26904 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26977__$1 = (function (){var statearr_27019 = state_26977;
(statearr_27019[(16)] = inst_26903);

return statearr_27019;
})();
if(inst_26904){
var statearr_27020_27057 = state_26977__$1;
(statearr_27020_27057[(1)] = (9));

} else {
var statearr_27021_27058 = state_26977__$1;
(statearr_27021_27058[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27022[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27022[(1)] = (1));

return statearr_27022;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_26977){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26977);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27023){var ex__2749__auto__ = e27023;
var statearr_27024_27059 = state_26977;
(statearr_27024_27059[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26977[(4)]))){
var statearr_27025_27060 = state_26977;
(statearr_27025_27060[(1)] = cljs.core.first.call(null,(state_26977[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27061 = state_26977;
state_26977 = G__27061;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_26977){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_26977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27026 = f__2769__auto__.call(null);
(statearr_27026[(6)] = c__2768__auto___27028);

return statearr_27026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27117){
var state_val_27118 = (state_27117[(1)]);
if((state_val_27118 === (7))){
var state_27117__$1 = state_27117;
var statearr_27119_27146 = state_27117__$1;
(statearr_27119_27146[(2)] = tt_id);

(statearr_27119_27146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (1))){
var state_27117__$1 = state_27117;
var statearr_27120_27147 = state_27117__$1;
(statearr_27120_27147[(2)] = null);

(statearr_27120_27147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (4))){
var inst_27062 = (state_27117[(2)]);
var state_27117__$1 = state_27117;
var statearr_27121_27148 = state_27117__$1;
(statearr_27121_27148[(2)] = inst_27062);

(statearr_27121_27148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (13))){
var inst_27110 = (state_27117[(2)]);
var state_27117__$1 = state_27117;
var statearr_27122_27149 = state_27117__$1;
(statearr_27122_27149[(2)] = inst_27110);

(statearr_27122_27149[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (6))){
var inst_27070 = fluree.db.util.core.random_uuid.call(null);
var state_27117__$1 = state_27117;
var statearr_27123_27150 = state_27117__$1;
(statearr_27123_27150[(2)] = inst_27070);

(statearr_27123_27150[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (3))){
var inst_27115 = (state_27117[(2)]);
var state_27117__$1 = state_27117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27117__$1,inst_27115);
} else {
if((state_val_27118 === (12))){
var inst_27093 = (state_27117[(7)]);
var state_27117__$1 = state_27117;
var statearr_27124_27151 = state_27117__$1;
(statearr_27124_27151[(2)] = inst_27093);

(statearr_27124_27151[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (2))){
var _ = (function (){var statearr_27125 = state_27117;
(statearr_27125[(4)] = cljs.core.cons.call(null,(5),(state_27117[(4)])));

return statearr_27125;
})();
var inst_27068 = (tt_id == null);
var state_27117__$1 = state_27117;
if(cljs.core.truth_(inst_27068)){
var statearr_27126_27152 = state_27117__$1;
(statearr_27126_27152[(1)] = (6));

} else {
var statearr_27127_27153 = state_27117__$1;
(statearr_27127_27153[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (11))){
var inst_27100 = (state_27117[(8)]);
var inst_27093 = (state_27117[(7)]);
var inst_27103 = fluree.db.graphdb.with_t.call(null,inst_27093,inst_27100);
var state_27117__$1 = state_27117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27117__$1,(14),inst_27103);
} else {
if((state_val_27118 === (9))){
var inst_27094 = (state_27117[(9)]);
var inst_27100 = (state_27117[(8)]);
var inst_27099 = cljs.core.seq.call(null,inst_27094);
var inst_27100__$1 = cljs.core.first.call(null,inst_27099);
var inst_27101 = cljs.core.next.call(null,inst_27099);
var state_27117__$1 = (function (){var statearr_27129 = state_27117;
(statearr_27129[(8)] = inst_27100__$1);

(statearr_27129[(10)] = inst_27101);

return statearr_27129;
})();
if(cljs.core.truth_(inst_27100__$1)){
var statearr_27130_27154 = state_27117__$1;
(statearr_27130_27154[(1)] = (11));

} else {
var statearr_27131_27155 = state_27117__$1;
(statearr_27131_27155[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (5))){
var _ = (function (){var statearr_27132 = state_27117;
(statearr_27132[(4)] = cljs.core.rest.call(null,(state_27117[(4)])));

return statearr_27132;
})();
var state_27117__$1 = state_27117;
var ex27128 = (state_27117__$1[(2)]);
var statearr_27133_27156 = state_27117__$1;
(statearr_27133_27156[(5)] = ex27128);


if((ex27128 instanceof Error)){
var statearr_27134_27157 = state_27117__$1;
(statearr_27134_27157[(1)] = (4));

(statearr_27134_27157[(5)] = null);

} else {
throw ex27128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (14))){
var inst_27101 = (state_27117[(10)]);
var inst_27105 = (state_27117[(2)]);
var inst_27106 = fluree.db.util.async.throw_err.call(null,inst_27105);
var inst_27093 = inst_27106;
var inst_27094 = inst_27101;
var state_27117__$1 = (function (){var statearr_27135 = state_27117;
(statearr_27135[(9)] = inst_27094);

(statearr_27135[(7)] = inst_27093);

return statearr_27135;
})();
var statearr_27136_27158 = state_27117__$1;
(statearr_27136_27158[(2)] = null);

(statearr_27136_27158[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (10))){
var inst_27112 = (state_27117[(2)]);
var _ = (function (){var statearr_27137 = state_27117;
(statearr_27137[(4)] = cljs.core.rest.call(null,(state_27117[(4)])));

return statearr_27137;
})();
var state_27117__$1 = state_27117;
var statearr_27138_27159 = state_27117__$1;
(statearr_27138_27159[(2)] = inst_27112);

(statearr_27138_27159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27118 === (8))){
var inst_27073 = (state_27117[(2)]);
var inst_27074 = (function (){var tt_id_SINGLEQUOTE_ = inst_27073;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_27075 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_27073);
var inst_27076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27077 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_27078 = (new cljs.core.PersistentVector(null,4,(5),inst_27076,inst_27077,null));
var inst_27079 = cljs.core.reduce.call(null,inst_27074,inst_27075,inst_27078);
var inst_27080 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_27081 = cljs.core.reverse.call(null,inst_27080);
var inst_27082 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_27081);
var inst_27090 = cljs.core.seq.call(null,inst_27082);
var inst_27091 = cljs.core.first.call(null,inst_27090);
var inst_27092 = cljs.core.next.call(null,inst_27090);
var inst_27093 = inst_27079;
var inst_27094 = inst_27082;
var state_27117__$1 = (function (){var statearr_27139 = state_27117;
(statearr_27139[(9)] = inst_27094);

(statearr_27139[(11)] = inst_27092);

(statearr_27139[(12)] = inst_27091);

(statearr_27139[(7)] = inst_27093);

return statearr_27139;
})();
var statearr_27140_27160 = state_27117__$1;
(statearr_27140_27160[(2)] = null);

(statearr_27140_27160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0 = (function (){
var statearr_27141 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27141[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__);

(statearr_27141[(1)] = (1));

return statearr_27141;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1 = (function (state_27117){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27142){var ex__2749__auto__ = e27142;
var statearr_27143_27161 = state_27117;
(statearr_27143_27161[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27117[(4)]))){
var statearr_27144_27162 = state_27117;
(statearr_27144_27162[(1)] = cljs.core.first.call(null,(state_27117[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27163 = state_27117;
state_27117 = G__27163;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__ = function(state_27117){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1.call(this,state_27117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27145 = f__2769__auto__.call(null);
(statearr_27145[(6)] = c__2768__auto__);

return statearr_27145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2768__auto___27350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27281){
var state_val_27282 = (state_27281[(1)]);
if((state_val_27282 === (7))){
var inst_27191 = (state_27281[(7)]);
var inst_27191__$1 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_27281__$1 = (function (){var statearr_27283 = state_27281;
(statearr_27283[(7)] = inst_27191__$1);

return statearr_27283;
})();
if(inst_27191__$1){
var statearr_27284_27351 = state_27281__$1;
(statearr_27284_27351[(1)] = (13));

} else {
var statearr_27285_27352 = state_27281__$1;
(statearr_27285_27352[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (20))){
var state_27281__$1 = state_27281;
var statearr_27286_27353 = state_27281__$1;
(statearr_27286_27353[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (27))){
var inst_27227 = (state_27281[(8)]);
var inst_27231 = inst_27227.s;
var state_27281__$1 = state_27281;
var statearr_27288_27354 = state_27281__$1;
(statearr_27288_27354[(2)] = inst_27231);

(statearr_27288_27354[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (1))){
var state_27281__$1 = state_27281;
var statearr_27289_27355 = state_27281__$1;
(statearr_27289_27355[(2)] = null);

(statearr_27289_27355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (24))){
var inst_27221 = (state_27281[(9)]);
var inst_27225 = cljs.core.first.call(null,inst_27221);
var state_27281__$1 = state_27281;
var statearr_27290_27356 = state_27281__$1;
(statearr_27290_27356[(2)] = inst_27225);

(statearr_27290_27356[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (39))){
var state_27281__$1 = state_27281;
var statearr_27291_27357 = state_27281__$1;
(statearr_27291_27357[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (4))){
var inst_27164 = (state_27281[(2)]);
var inst_27165 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27166 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27167 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27168 = cljs.core.PersistentHashMap.fromArrays(inst_27166,inst_27167);
var inst_27169 = cljs.core.ex_info.call(null,inst_27165,inst_27168,inst_27164);
var inst_27170 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27169);
var state_27281__$1 = state_27281;
var statearr_27293_27358 = state_27281__$1;
(statearr_27293_27358[(2)] = inst_27170);

(statearr_27293_27358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (15))){
var inst_27198 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
if(cljs.core.truth_(inst_27198)){
var statearr_27294_27359 = state_27281__$1;
(statearr_27294_27359[(1)] = (16));

} else {
var statearr_27295_27360 = state_27281__$1;
(statearr_27295_27360[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (21))){
var inst_27247 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27296_27361 = state_27281__$1;
(statearr_27296_27361[(2)] = inst_27247);

(statearr_27296_27361[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (31))){
var inst_27245 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27297_27362 = state_27281__$1;
(statearr_27297_27362[(2)] = inst_27245);

(statearr_27297_27362[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (32))){
var inst_27251 = (state_27281[(10)]);
var inst_27253 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27251);
var state_27281__$1 = state_27281;
var statearr_27298_27363 = state_27281__$1;
(statearr_27298_27363[(2)] = inst_27253);

(statearr_27298_27363[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (40))){
var inst_27274 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27299_27364 = state_27281__$1;
(statearr_27299_27364[(2)] = inst_27274);

(statearr_27299_27364[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (33))){
var inst_27255 = (state_27281[(11)]);
var inst_27251 = (state_27281[(10)]);
var inst_27255__$1 = (inst_27251 == null);
var state_27281__$1 = (function (){var statearr_27300 = state_27281;
(statearr_27300[(11)] = inst_27255__$1);

return statearr_27300;
})();
if(cljs.core.truth_(inst_27255__$1)){
var statearr_27301_27365 = state_27281__$1;
(statearr_27301_27365[(1)] = (35));

} else {
var statearr_27302_27366 = state_27281__$1;
(statearr_27302_27366[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (13))){
var inst_27193 = cljs.core.first.call(null,ident);
var inst_27194 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27193);
var inst_27195 = (inst_27194 == null);
var state_27281__$1 = state_27281;
var statearr_27303_27367 = state_27281__$1;
(statearr_27303_27367[(2)] = inst_27195);

(statearr_27303_27367[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (22))){
var inst_27221 = (state_27281[(9)]);
var inst_27220 = (state_27281[(2)]);
var inst_27221__$1 = fluree.db.util.async.throw_err.call(null,inst_27220);
var inst_27222 = (inst_27221__$1 == null);
var state_27281__$1 = (function (){var statearr_27304 = state_27281;
(statearr_27304[(9)] = inst_27221__$1);

return statearr_27304;
})();
if(cljs.core.truth_(inst_27222)){
var statearr_27305_27368 = state_27281__$1;
(statearr_27305_27368[(1)] = (23));

} else {
var statearr_27306_27369 = state_27281__$1;
(statearr_27306_27369[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (36))){
var inst_27255 = (state_27281[(11)]);
var state_27281__$1 = state_27281;
var statearr_27307_27370 = state_27281__$1;
(statearr_27307_27370[(2)] = inst_27255);

(statearr_27307_27370[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (41))){
var inst_27269 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_27281__$1 = state_27281;
var statearr_27308_27371 = state_27281__$1;
(statearr_27308_27371[(2)] = inst_27269);

(statearr_27308_27371[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (43))){
var inst_27272 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27309_27372 = state_27281__$1;
(statearr_27309_27372[(2)] = inst_27272);

(statearr_27309_27372[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (29))){
var inst_27236 = cljs.core.pr_str.call(null,ident);
var inst_27237 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27236].join('');
var inst_27238 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27239 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27240 = cljs.core.PersistentHashMap.fromArrays(inst_27238,inst_27239);
var inst_27241 = cljs.core.ex_info.call(null,inst_27237,inst_27240);
var inst_27242 = (function(){throw inst_27241})();
var state_27281__$1 = state_27281;
var statearr_27310_27373 = state_27281__$1;
(statearr_27310_27373[(2)] = inst_27242);

(statearr_27310_27373[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (6))){
var inst_27178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27179 = [ident];
var inst_27180 = (new cljs.core.PersistentVector(null,1,(5),inst_27178,inst_27179,null));
var inst_27181 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27180);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27281__$1,(9),inst_27181);
} else {
if((state_val_27282 === (28))){
var inst_27233 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27311_27374 = state_27281__$1;
(statearr_27311_27374[(2)] = inst_27233);

(statearr_27311_27374[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (25))){
var inst_27227 = (state_27281[(8)]);
var inst_27227__$1 = (state_27281[(2)]);
var inst_27228 = (inst_27227__$1 == null);
var state_27281__$1 = (function (){var statearr_27312 = state_27281;
(statearr_27312[(8)] = inst_27227__$1);

return statearr_27312;
})();
if(cljs.core.truth_(inst_27228)){
var statearr_27313_27375 = state_27281__$1;
(statearr_27313_27375[(1)] = (26));

} else {
var statearr_27314_27376 = state_27281__$1;
(statearr_27314_27376[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (34))){
var inst_27276 = (state_27281[(2)]);
var _ = (function (){var statearr_27315 = state_27281;
(statearr_27315[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27315;
})();
var state_27281__$1 = state_27281;
var statearr_27316_27377 = state_27281__$1;
(statearr_27316_27377[(2)] = inst_27276);

(statearr_27316_27377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (17))){
var inst_27209 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_27281__$1 = state_27281;
if(inst_27209){
var statearr_27317_27378 = state_27281__$1;
(statearr_27317_27378[(1)] = (19));

} else {
var statearr_27318_27379 = state_27281__$1;
(statearr_27318_27379[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (3))){
var inst_27279 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27281__$1,inst_27279);
} else {
if((state_val_27282 === (12))){
var inst_27189 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27319_27380 = state_27281__$1;
(statearr_27319_27380[(2)] = inst_27189);

(statearr_27319_27380[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (2))){
var _ = (function (){var statearr_27320 = state_27281;
(statearr_27320[(4)] = cljs.core.cons.call(null,(5),(state_27281[(4)])));

return statearr_27320;
})();
var inst_27176 = typeof ident === 'number';
var state_27281__$1 = state_27281;
if(cljs.core.truth_(inst_27176)){
var statearr_27321_27381 = state_27281__$1;
(statearr_27321_27381[(1)] = (6));

} else {
var statearr_27322_27382 = state_27281__$1;
(statearr_27322_27382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (23))){
var state_27281__$1 = state_27281;
var statearr_27323_27383 = state_27281__$1;
(statearr_27323_27383[(2)] = null);

(statearr_27323_27383[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (35))){
var state_27281__$1 = state_27281;
var statearr_27324_27384 = state_27281__$1;
(statearr_27324_27384[(2)] = strict_QMARK_);

(statearr_27324_27384[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (19))){
var inst_27212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27213 = cljs.core.first.call(null,ident);
var inst_27214 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27213);
var inst_27215 = cljs.core.second.call(null,ident);
var inst_27216 = [inst_27214,inst_27215];
var inst_27217 = (new cljs.core.PersistentVector(null,2,(5),inst_27212,inst_27216,null));
var inst_27218 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27217);
var state_27281__$1 = state_27281;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27281__$1,(22),inst_27218);
} else {
if((state_val_27282 === (11))){
var state_27281__$1 = state_27281;
var statearr_27326_27385 = state_27281__$1;
(statearr_27326_27385[(2)] = null);

(statearr_27326_27385[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (9))){
var inst_27183 = (state_27281[(2)]);
var inst_27184 = fluree.db.util.async.throw_err.call(null,inst_27183);
var inst_27185 = cljs.core.not_empty.call(null,inst_27184);
var state_27281__$1 = state_27281;
if(cljs.core.truth_(inst_27185)){
var statearr_27327_27386 = state_27281__$1;
(statearr_27327_27386[(1)] = (10));

} else {
var statearr_27328_27387 = state_27281__$1;
(statearr_27328_27387[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (5))){
var _ = (function (){var statearr_27329 = state_27281;
(statearr_27329[(4)] = cljs.core.rest.call(null,(state_27281[(4)])));

return statearr_27329;
})();
var state_27281__$1 = state_27281;
var ex27325 = (state_27281__$1[(2)]);
var statearr_27330_27388 = state_27281__$1;
(statearr_27330_27388[(5)] = ex27325);


var statearr_27331_27389 = state_27281__$1;
(statearr_27331_27389[(1)] = (4));

(statearr_27331_27389[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (14))){
var inst_27191 = (state_27281[(7)]);
var state_27281__$1 = state_27281;
var statearr_27332_27390 = state_27281__$1;
(statearr_27332_27390[(2)] = inst_27191);

(statearr_27332_27390[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (26))){
var state_27281__$1 = state_27281;
var statearr_27333_27391 = state_27281__$1;
(statearr_27333_27391[(2)] = null);

(statearr_27333_27391[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (16))){
var inst_27200 = cljs.core.first.call(null,ident);
var inst_27201 = cljs.core.pr_str.call(null,inst_27200);
var inst_27202 = ["Subject ID lookup failed. The predicate ",inst_27201," does not exist."].join('');
var inst_27203 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27204 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27205 = cljs.core.PersistentHashMap.fromArrays(inst_27203,inst_27204);
var inst_27206 = cljs.core.ex_info.call(null,inst_27202,inst_27205);
var inst_27207 = (function(){throw inst_27206})();
var state_27281__$1 = state_27281;
var statearr_27334_27392 = state_27281__$1;
(statearr_27334_27392[(2)] = inst_27207);

(statearr_27334_27392[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (38))){
var inst_27261 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27263 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27264 = cljs.core.PersistentHashMap.fromArrays(inst_27262,inst_27263);
var inst_27265 = cljs.core.ex_info.call(null,inst_27261,inst_27264);
var inst_27266 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27265);
var state_27281__$1 = state_27281;
var statearr_27335_27393 = state_27281__$1;
(statearr_27335_27393[(2)] = inst_27266);

(statearr_27335_27393[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (30))){
var state_27281__$1 = state_27281;
var statearr_27336_27394 = state_27281__$1;
(statearr_27336_27394[(2)] = null);

(statearr_27336_27394[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (10))){
var state_27281__$1 = state_27281;
var statearr_27337_27395 = state_27281__$1;
(statearr_27337_27395[(2)] = ident);

(statearr_27337_27395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (18))){
var inst_27249 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
var statearr_27338_27396 = state_27281__$1;
(statearr_27338_27396[(2)] = inst_27249);

(statearr_27338_27396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (42))){
var state_27281__$1 = state_27281;
var statearr_27339_27397 = state_27281__$1;
(statearr_27339_27397[(2)] = null);

(statearr_27339_27397[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (37))){
var inst_27259 = (state_27281[(2)]);
var state_27281__$1 = state_27281;
if(cljs.core.truth_(inst_27259)){
var statearr_27340_27398 = state_27281__$1;
(statearr_27340_27398[(1)] = (38));

} else {
var statearr_27341_27399 = state_27281__$1;
(statearr_27341_27399[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27282 === (8))){
var inst_27251 = (state_27281[(10)]);
var inst_27251__$1 = (state_27281[(2)]);
var state_27281__$1 = (function (){var statearr_27342 = state_27281;
(statearr_27342[(10)] = inst_27251__$1);

return statearr_27342;
})();
if(cljs.core.truth_(inst_27251__$1)){
var statearr_27343_27400 = state_27281__$1;
(statearr_27343_27400[(1)] = (32));

} else {
var statearr_27344_27401 = state_27281__$1;
(statearr_27344_27401[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_27345 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27345[(0)] = fluree$db$graphdb$subid_$_state_machine__2746__auto__);

(statearr_27345[(1)] = (1));

return statearr_27345;
});
var fluree$db$graphdb$subid_$_state_machine__2746__auto____1 = (function (state_27281){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27281);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27346){var ex__2749__auto__ = e27346;
var statearr_27347_27402 = state_27281;
(statearr_27347_27402[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27281[(4)]))){
var statearr_27348_27403 = state_27281;
(statearr_27348_27403[(1)] = cljs.core.first.call(null,(state_27281[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27404 = state_27281;
state_27281 = G__27404;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2746__auto__ = function(state_27281){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2746__auto____1.call(this,state_27281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2746__auto____0;
fluree$db$graphdb$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2746__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27349 = f__2769__auto__.call(null);
(statearr_27349[(6)] = c__2768__auto___27350);

return statearr_27349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__27405){
var map__27406 = p__27405;
var map__27406__$1 = cljs.core.__destructure_map.call(null,map__27406);
var current_db_fn = cljs.core.get.call(null,map__27406__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.call(null,map__27406__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27422){
var state_val_27423 = (state_27422[(1)]);
if((state_val_27423 === (1))){
var state_27422__$1 = state_27422;
var statearr_27424_27438 = state_27422__$1;
(statearr_27424_27438[(2)] = null);

(statearr_27424_27438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27423 === (2))){
var _ = (function (){var statearr_27425 = state_27422;
(statearr_27425[(4)] = cljs.core.cons.call(null,(5),(state_27422[(4)])));

return statearr_27425;
})();
var inst_27413 = current_db_fn.call(null);
var state_27422__$1 = state_27422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27422__$1,(6),inst_27413);
} else {
if((state_val_27423 === (3))){
var inst_27420 = (state_27422[(2)]);
var state_27422__$1 = state_27422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27422__$1,inst_27420);
} else {
if((state_val_27423 === (4))){
var inst_27407 = (state_27422[(2)]);
var state_27422__$1 = state_27422;
var statearr_27427_27439 = state_27422__$1;
(statearr_27427_27439[(2)] = inst_27407);

(statearr_27427_27439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27423 === (5))){
var _ = (function (){var statearr_27428 = state_27422;
(statearr_27428[(4)] = cljs.core.rest.call(null,(state_27422[(4)])));

return statearr_27428;
})();
var state_27422__$1 = state_27422;
var ex27426 = (state_27422__$1[(2)]);
var statearr_27429_27440 = state_27422__$1;
(statearr_27429_27440[(5)] = ex27426);


if((ex27426 instanceof Error)){
var statearr_27430_27441 = state_27422__$1;
(statearr_27430_27441[(1)] = (4));

(statearr_27430_27441[(5)] = null);

} else {
throw ex27426;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27423 === (6))){
var inst_27415 = (state_27422[(2)]);
var inst_27416 = fluree.db.util.async.throw_err.call(null,inst_27415);
var inst_27417 = cljs.core.assoc.call(null,inst_27416,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_27431 = state_27422;
(statearr_27431[(4)] = cljs.core.rest.call(null,(state_27422[(4)])));

return statearr_27431;
})();
var state_27422__$1 = state_27422;
var statearr_27432_27442 = state_27422__$1;
(statearr_27432_27442[(2)] = inst_27417);

(statearr_27432_27442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0 = (function (){
var statearr_27433 = [null,null,null,null,null,null,null];
(statearr_27433[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__);

(statearr_27433[(1)] = (1));

return statearr_27433;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1 = (function (state_27422){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27434){var ex__2749__auto__ = e27434;
var statearr_27435_27443 = state_27422;
(statearr_27435_27443[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27422[(4)]))){
var statearr_27436_27444 = state_27422;
(statearr_27436_27444[(1)] = cljs.core.first.call(null,(state_27422[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27445 = state_27422;
state_27422 = G__27445;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__ = function(state_27422){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1.call(this,state_27422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27437 = f__2769__auto__.call(null);
(statearr_27437[(6)] = c__2768__auto__);

return statearr_27437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.call(null,this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__27446,property,collection){
var map__27447 = p__27446;
var map__27447__$1 = cljs.core.__destructure_map.call(null,map__27447);
var schema = cljs.core.get.call(null,map__27447__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__27448,property,predicate){
var map__27449 = p__27448;
var map__27449__$1 = cljs.core.__destructure_map.call(null,map__27449);
var this$ = map__27449__$1;
var schema = cljs.core.get.call(null,map__27449__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__27450 = cljs.core.get_in.call(null,schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop.call(null,this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__27450);
} else {
return G__27450;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__27452 = arguments.length;
switch (G__27452) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27484){
var state_val_27485 = (state_27484[(1)]);
if((state_val_27485 === (7))){
var state_27484__$1 = state_27484;
var statearr_27486_27580 = state_27484__$1;
(statearr_27486_27580[(2)] = null);

(statearr_27486_27580[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (1))){
var state_27484__$1 = state_27484;
var statearr_27487_27581 = state_27484__$1;
(statearr_27487_27581[(2)] = null);

(statearr_27487_27581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (4))){
var inst_27453 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
var statearr_27488_27582 = state_27484__$1;
(statearr_27488_27582[(2)] = inst_27453);

(statearr_27488_27582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (6))){
var inst_27467 = (state_27484[(7)]);
var inst_27466 = (state_27484[(2)]);
var inst_27467__$1 = fluree.db.util.async.throw_err.call(null,inst_27466);
var inst_27468 = (inst_27467__$1 == null);
var state_27484__$1 = (function (){var statearr_27489 = state_27484;
(statearr_27489[(7)] = inst_27467__$1);

return statearr_27489;
})();
if(cljs.core.truth_(inst_27468)){
var statearr_27490_27583 = state_27484__$1;
(statearr_27490_27583[(1)] = (7));

} else {
var statearr_27491_27584 = state_27484__$1;
(statearr_27491_27584[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (3))){
var inst_27482 = (state_27484[(2)]);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27484__$1,inst_27482);
} else {
if((state_val_27485 === (12))){
var inst_27479 = (state_27484[(2)]);
var _ = (function (){var statearr_27492 = state_27484;
(statearr_27492[(4)] = cljs.core.rest.call(null,(state_27484[(4)])));

return statearr_27492;
})();
var state_27484__$1 = state_27484;
var statearr_27493_27585 = state_27484__$1;
(statearr_27493_27585[(2)] = inst_27479);

(statearr_27493_27585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (2))){
var _ = (function (){var statearr_27494 = state_27484;
(statearr_27494[(4)] = cljs.core.cons.call(null,(5),(state_27484[(4)])));

return statearr_27494;
})();
var inst_27460 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_27461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27462 = [tag_id,(30)];
var inst_27463 = (new cljs.core.PersistentVector(null,2,(5),inst_27461,inst_27462,null));
var inst_27464 = fluree.db.query.range.index_range.call(null,inst_27460,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27463);
var state_27484__$1 = state_27484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27484__$1,(6),inst_27464);
} else {
if((state_val_27485 === (11))){
var inst_27473 = (state_27484[(8)]);
var inst_27477 = inst_27473.o;
var state_27484__$1 = state_27484;
var statearr_27496_27586 = state_27484__$1;
(statearr_27496_27586[(2)] = inst_27477);

(statearr_27496_27586[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (9))){
var inst_27473 = (state_27484[(8)]);
var inst_27473__$1 = (state_27484[(2)]);
var inst_27474 = (inst_27473__$1 == null);
var state_27484__$1 = (function (){var statearr_27497 = state_27484;
(statearr_27497[(8)] = inst_27473__$1);

return statearr_27497;
})();
if(cljs.core.truth_(inst_27474)){
var statearr_27498_27587 = state_27484__$1;
(statearr_27498_27587[(1)] = (10));

} else {
var statearr_27499_27588 = state_27484__$1;
(statearr_27499_27588[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (5))){
var _ = (function (){var statearr_27500 = state_27484;
(statearr_27500[(4)] = cljs.core.rest.call(null,(state_27484[(4)])));

return statearr_27500;
})();
var state_27484__$1 = state_27484;
var ex27495 = (state_27484__$1[(2)]);
var statearr_27501_27589 = state_27484__$1;
(statearr_27501_27589[(5)] = ex27495);


if((ex27495 instanceof Error)){
var statearr_27502_27590 = state_27484__$1;
(statearr_27502_27590[(1)] = (4));

(statearr_27502_27590[(5)] = null);

} else {
throw ex27495;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (10))){
var state_27484__$1 = state_27484;
var statearr_27503_27591 = state_27484__$1;
(statearr_27503_27591[(2)] = null);

(statearr_27503_27591[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27485 === (8))){
var inst_27467 = (state_27484[(7)]);
var inst_27471 = cljs.core.first.call(null,inst_27467);
var state_27484__$1 = state_27484;
var statearr_27504_27592 = state_27484__$1;
(statearr_27504_27592[(2)] = inst_27471);

(statearr_27504_27592[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27505 = [null,null,null,null,null,null,null,null,null];
(statearr_27505[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27505[(1)] = (1));

return statearr_27505;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27484){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27506){var ex__2749__auto__ = e27506;
var statearr_27507_27593 = state_27484;
(statearr_27507_27593[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27484[(4)]))){
var statearr_27508_27594 = state_27484;
(statearr_27508_27594[(1)] = cljs.core.first.call(null,(state_27484[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27595 = state_27484;
state_27484 = G__27595;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27484){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27509 = f__2769__auto__.call(null);
(statearr_27509[(6)] = c__2768__auto__);

return statearr_27509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27545){
var state_val_27546 = (state_27545[(1)]);
if((state_val_27546 === (7))){
var inst_27519 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27545__$1 = state_27545;
var statearr_27547_27596 = state_27545__$1;
(statearr_27547_27596[(2)] = inst_27519);

(statearr_27547_27596[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (1))){
var state_27545__$1 = state_27545;
var statearr_27548_27597 = state_27545__$1;
(statearr_27548_27597[(2)] = null);

(statearr_27548_27597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (4))){
var inst_27510 = (state_27545[(2)]);
var state_27545__$1 = state_27545;
var statearr_27549_27598 = state_27545__$1;
(statearr_27549_27598[(2)] = inst_27510);

(statearr_27549_27598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (15))){
var inst_27540 = (state_27545[(2)]);
var _ = (function (){var statearr_27550 = state_27545;
(statearr_27550[(4)] = cljs.core.rest.call(null,(state_27545[(4)])));

return statearr_27550;
})();
var state_27545__$1 = state_27545;
var statearr_27551_27599 = state_27545__$1;
(statearr_27551_27599[(2)] = inst_27540);

(statearr_27551_27599[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (13))){
var inst_27525 = (state_27545[(7)]);
var inst_27531 = clojure.string.includes_QMARK_.call(null,inst_27525,":");
var state_27545__$1 = state_27545;
if(inst_27531){
var statearr_27552_27600 = state_27545__$1;
(statearr_27552_27600[(1)] = (16));

} else {
var statearr_27553_27601 = state_27545__$1;
(statearr_27553_27601[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (6))){
var state_27545__$1 = state_27545;
var statearr_27554_27602 = state_27545__$1;
(statearr_27554_27602[(2)] = pred);

(statearr_27554_27602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (17))){
var inst_27525 = (state_27545[(7)]);
var state_27545__$1 = state_27545;
var statearr_27555_27603 = state_27545__$1;
(statearr_27555_27603[(2)] = inst_27525);

(statearr_27555_27603[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (3))){
var inst_27543 = (state_27545[(2)]);
var state_27545__$1 = state_27545;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27545__$1,inst_27543);
} else {
if((state_val_27546 === (12))){
var inst_27529 = (state_27545[(2)]);
var state_27545__$1 = state_27545;
if(cljs.core.truth_(inst_27529)){
var statearr_27556_27604 = state_27545__$1;
(statearr_27556_27604[(1)] = (13));

} else {
var statearr_27557_27605 = state_27545__$1;
(statearr_27557_27605[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (2))){
var _ = (function (){var statearr_27558 = state_27545;
(statearr_27558[(4)] = cljs.core.cons.call(null,(5),(state_27545[(4)])));

return statearr_27558;
})();
var inst_27516 = typeof pred === 'string';
var state_27545__$1 = state_27545;
if(cljs.core.truth_(inst_27516)){
var statearr_27559_27606 = state_27545__$1;
(statearr_27559_27606[(1)] = (6));

} else {
var statearr_27560_27607 = state_27545__$1;
(statearr_27560_27607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (11))){
var inst_27521 = (state_27545[(8)]);
var state_27545__$1 = state_27545;
var statearr_27562_27608 = state_27545__$1;
(statearr_27562_27608[(2)] = inst_27521);

(statearr_27562_27608[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (9))){
var inst_27521 = (state_27545[(8)]);
var inst_27524 = (state_27545[(2)]);
var inst_27525 = fluree.db.util.async.throw_err.call(null,inst_27524);
var state_27545__$1 = (function (){var statearr_27563 = state_27545;
(statearr_27563[(7)] = inst_27525);

return statearr_27563;
})();
if(cljs.core.truth_(inst_27521)){
var statearr_27564_27609 = state_27545__$1;
(statearr_27564_27609[(1)] = (10));

} else {
var statearr_27565_27610 = state_27545__$1;
(statearr_27565_27610[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (5))){
var _ = (function (){var statearr_27566 = state_27545;
(statearr_27566[(4)] = cljs.core.rest.call(null,(state_27545[(4)])));

return statearr_27566;
})();
var state_27545__$1 = state_27545;
var ex27561 = (state_27545__$1[(2)]);
var statearr_27567_27611 = state_27545__$1;
(statearr_27567_27611[(5)] = ex27561);


if((ex27561 instanceof Error)){
var statearr_27568_27612 = state_27545__$1;
(statearr_27568_27612[(1)] = (4));

(statearr_27568_27612[(5)] = null);

} else {
throw ex27561;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (14))){
var state_27545__$1 = state_27545;
var statearr_27569_27613 = state_27545__$1;
(statearr_27569_27613[(2)] = null);

(statearr_27569_27613[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (16))){
var inst_27525 = (state_27545[(7)]);
var inst_27533 = clojure.string.split.call(null,inst_27525,/:/);
var inst_27534 = cljs.core.second.call(null,inst_27533);
var state_27545__$1 = state_27545;
var statearr_27570_27614 = state_27545__$1;
(statearr_27570_27614[(2)] = inst_27534);

(statearr_27570_27614[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (10))){
var inst_27525 = (state_27545[(7)]);
var state_27545__$1 = state_27545;
var statearr_27571_27615 = state_27545__$1;
(statearr_27571_27615[(2)] = inst_27525);

(statearr_27571_27615[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (18))){
var inst_27537 = (state_27545[(2)]);
var state_27545__$1 = state_27545;
var statearr_27572_27616 = state_27545__$1;
(statearr_27572_27616[(2)] = inst_27537);

(statearr_27572_27616[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27546 === (8))){
var inst_27521 = (state_27545[(2)]);
var inst_27522 = fluree.db.dbproto._tag.call(null,this$,tag_id);
var state_27545__$1 = (function (){var statearr_27573 = state_27545;
(statearr_27573[(8)] = inst_27521);

return statearr_27573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27545__$1,(9),inst_27522);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27574 = [null,null,null,null,null,null,null,null,null];
(statearr_27574[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27574[(1)] = (1));

return statearr_27574;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27545){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27545);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27575){var ex__2749__auto__ = e27575;
var statearr_27576_27617 = state_27545;
(statearr_27576_27617[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27545[(4)]))){
var statearr_27577_27618 = state_27545;
(statearr_27577_27618[(1)] = cljs.core.first.call(null,(state_27545[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27619 = state_27545;
state_27545 = G__27619;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27545){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27578 = f__2769__auto__.call(null);
(statearr_27578[(6)] = c__2768__auto__);

return statearr_27578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27621 = arguments.length;
switch (G__27621) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27654){
var state_val_27655 = (state_27654[(1)]);
if((state_val_27655 === (7))){
var state_27654__$1 = state_27654;
var statearr_27656_27744 = state_27654__$1;
(statearr_27656_27744[(2)] = null);

(statearr_27656_27744[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (1))){
var state_27654__$1 = state_27654;
var statearr_27657_27745 = state_27654__$1;
(statearr_27657_27745[(2)] = null);

(statearr_27657_27745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (4))){
var inst_27622 = (state_27654[(2)]);
var state_27654__$1 = state_27654;
var statearr_27658_27746 = state_27654__$1;
(statearr_27658_27746[(2)] = inst_27622);

(statearr_27658_27746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (6))){
var inst_27637 = (state_27654[(7)]);
var inst_27636 = (state_27654[(2)]);
var inst_27637__$1 = fluree.db.util.async.throw_err.call(null,inst_27636);
var inst_27638 = (inst_27637__$1 == null);
var state_27654__$1 = (function (){var statearr_27659 = state_27654;
(statearr_27659[(7)] = inst_27637__$1);

return statearr_27659;
})();
if(cljs.core.truth_(inst_27638)){
var statearr_27660_27747 = state_27654__$1;
(statearr_27660_27747[(1)] = (7));

} else {
var statearr_27661_27748 = state_27654__$1;
(statearr_27661_27748[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (3))){
var inst_27652 = (state_27654[(2)]);
var state_27654__$1 = state_27654;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27654__$1,inst_27652);
} else {
if((state_val_27655 === (12))){
var inst_27649 = (state_27654[(2)]);
var _ = (function (){var statearr_27662 = state_27654;
(statearr_27662[(4)] = cljs.core.rest.call(null,(state_27654[(4)])));

return statearr_27662;
})();
var state_27654__$1 = state_27654;
var statearr_27663_27749 = state_27654__$1;
(statearr_27663_27749[(2)] = inst_27649);

(statearr_27663_27749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (2))){
var _ = (function (){var statearr_27664 = state_27654;
(statearr_27664[(4)] = cljs.core.cons.call(null,(5),(state_27654[(4)])));

return statearr_27664;
})();
var inst_27628 = (30);
var inst_27630 = fluree.db.dbproto._rootdb.call(null,this$);
var inst_27631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27632 = [inst_27628,tag_name];
var inst_27633 = (new cljs.core.PersistentVector(null,2,(5),inst_27631,inst_27632,null));
var inst_27634 = fluree.db.query.range.index_range.call(null,inst_27630,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27633);
var state_27654__$1 = state_27654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27654__$1,(6),inst_27634);
} else {
if((state_val_27655 === (11))){
var inst_27643 = (state_27654[(8)]);
var inst_27647 = inst_27643.s;
var state_27654__$1 = state_27654;
var statearr_27666_27750 = state_27654__$1;
(statearr_27666_27750[(2)] = inst_27647);

(statearr_27666_27750[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (9))){
var inst_27643 = (state_27654[(8)]);
var inst_27643__$1 = (state_27654[(2)]);
var inst_27644 = (inst_27643__$1 == null);
var state_27654__$1 = (function (){var statearr_27667 = state_27654;
(statearr_27667[(8)] = inst_27643__$1);

return statearr_27667;
})();
if(cljs.core.truth_(inst_27644)){
var statearr_27668_27751 = state_27654__$1;
(statearr_27668_27751[(1)] = (10));

} else {
var statearr_27669_27752 = state_27654__$1;
(statearr_27669_27752[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (5))){
var _ = (function (){var statearr_27670 = state_27654;
(statearr_27670[(4)] = cljs.core.rest.call(null,(state_27654[(4)])));

return statearr_27670;
})();
var state_27654__$1 = state_27654;
var ex27665 = (state_27654__$1[(2)]);
var statearr_27671_27753 = state_27654__$1;
(statearr_27671_27753[(5)] = ex27665);


if((ex27665 instanceof Error)){
var statearr_27672_27754 = state_27654__$1;
(statearr_27672_27754[(1)] = (4));

(statearr_27672_27754[(5)] = null);

} else {
throw ex27665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (10))){
var state_27654__$1 = state_27654;
var statearr_27673_27755 = state_27654__$1;
(statearr_27673_27755[(2)] = null);

(statearr_27673_27755[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27655 === (8))){
var inst_27637 = (state_27654[(7)]);
var inst_27641 = cljs.core.first.call(null,inst_27637);
var state_27654__$1 = state_27654;
var statearr_27674_27756 = state_27654__$1;
(statearr_27674_27756[(2)] = inst_27641);

(statearr_27674_27756[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27675 = [null,null,null,null,null,null,null,null,null];
(statearr_27675[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27675[(1)] = (1));

return statearr_27675;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27654){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27676){var ex__2749__auto__ = e27676;
var statearr_27677_27757 = state_27654;
(statearr_27677_27757[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27654[(4)]))){
var statearr_27678_27758 = state_27654;
(statearr_27678_27758[(1)] = cljs.core.first.call(null,(state_27654[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27759 = state_27654;
state_27654 = G__27759;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27654){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27679 = f__2769__auto__.call(null);
(statearr_27679[(6)] = c__2768__auto__);

return statearr_27679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27714){
var state_val_27715 = (state_27714[(1)]);
if((state_val_27715 === (7))){
var inst_27693 = typeof pred === 'string';
var state_27714__$1 = state_27714;
if(cljs.core.truth_(inst_27693)){
var statearr_27716_27760 = state_27714__$1;
(statearr_27716_27760[(1)] = (10));

} else {
var statearr_27717_27761 = state_27714__$1;
(statearr_27717_27761[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (1))){
var state_27714__$1 = state_27714;
var statearr_27718_27762 = state_27714__$1;
(statearr_27718_27762[(2)] = null);

(statearr_27718_27762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (4))){
var inst_27680 = (state_27714[(2)]);
var state_27714__$1 = state_27714;
var statearr_27719_27763 = state_27714__$1;
(statearr_27719_27763[(2)] = inst_27680);

(statearr_27719_27763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (15))){
var inst_27707 = (state_27714[(2)]);
var state_27714__$1 = state_27714;
var statearr_27720_27764 = state_27714__$1;
(statearr_27720_27764[(2)] = inst_27707);

(statearr_27720_27764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (13))){
var inst_27698 = (state_27714[(7)]);
var inst_27700 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27698),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27701 = fluree.db.dbproto._tag_id.call(null,this$,inst_27700);
var state_27714__$1 = state_27714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27714__$1,(16),inst_27701);
} else {
if((state_val_27715 === (6))){
var inst_27688 = fluree.db.dbproto._tag_id.call(null,this$,tag_name);
var state_27714__$1 = state_27714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27714__$1,(9),inst_27688);
} else {
if((state_val_27715 === (3))){
var inst_27712 = (state_27714[(2)]);
var state_27714__$1 = state_27714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27714__$1,inst_27712);
} else {
if((state_val_27715 === (12))){
var inst_27698 = (state_27714[(7)]);
var inst_27698__$1 = (state_27714[(2)]);
var state_27714__$1 = (function (){var statearr_27721 = state_27714;
(statearr_27721[(7)] = inst_27698__$1);

return statearr_27721;
})();
if(cljs.core.truth_(inst_27698__$1)){
var statearr_27722_27765 = state_27714__$1;
(statearr_27722_27765[(1)] = (13));

} else {
var statearr_27723_27766 = state_27714__$1;
(statearr_27723_27766[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (2))){
var _ = (function (){var statearr_27724 = state_27714;
(statearr_27724[(4)] = cljs.core.cons.call(null,(5),(state_27714[(4)])));

return statearr_27724;
})();
var inst_27686 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27714__$1 = state_27714;
if(inst_27686){
var statearr_27725_27767 = state_27714__$1;
(statearr_27725_27767[(1)] = (6));

} else {
var statearr_27726_27768 = state_27714__$1;
(statearr_27726_27768[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (11))){
var inst_27696 = fluree.db.dbproto._p_prop.call(null,this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27714__$1 = state_27714;
var statearr_27728_27769 = state_27714__$1;
(statearr_27728_27769[(2)] = inst_27696);

(statearr_27728_27769[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (9))){
var inst_27690 = (state_27714[(2)]);
var inst_27691 = fluree.db.util.async.throw_err.call(null,inst_27690);
var state_27714__$1 = state_27714;
var statearr_27729_27770 = state_27714__$1;
(statearr_27729_27770[(2)] = inst_27691);

(statearr_27729_27770[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (5))){
var _ = (function (){var statearr_27730 = state_27714;
(statearr_27730[(4)] = cljs.core.rest.call(null,(state_27714[(4)])));

return statearr_27730;
})();
var state_27714__$1 = state_27714;
var ex27727 = (state_27714__$1[(2)]);
var statearr_27731_27771 = state_27714__$1;
(statearr_27731_27771[(5)] = ex27727);


if((ex27727 instanceof Error)){
var statearr_27732_27772 = state_27714__$1;
(statearr_27732_27772[(1)] = (4));

(statearr_27732_27772[(5)] = null);

} else {
throw ex27727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (14))){
var state_27714__$1 = state_27714;
var statearr_27733_27773 = state_27714__$1;
(statearr_27733_27773[(2)] = null);

(statearr_27733_27773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (16))){
var inst_27703 = (state_27714[(2)]);
var inst_27704 = fluree.db.util.async.throw_err.call(null,inst_27703);
var state_27714__$1 = state_27714;
var statearr_27734_27774 = state_27714__$1;
(statearr_27734_27774[(2)] = inst_27704);

(statearr_27734_27774[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (10))){
var state_27714__$1 = state_27714;
var statearr_27735_27775 = state_27714__$1;
(statearr_27735_27775[(2)] = pred);

(statearr_27735_27775[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27715 === (8))){
var inst_27709 = (state_27714[(2)]);
var _ = (function (){var statearr_27736 = state_27714;
(statearr_27736[(4)] = cljs.core.rest.call(null,(state_27714[(4)])));

return statearr_27736;
})();
var state_27714__$1 = state_27714;
var statearr_27737_27776 = state_27714__$1;
(statearr_27737_27776[(2)] = inst_27709);

(statearr_27737_27776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2746__auto__ = null;
var fluree$db$graphdb$state_machine__2746__auto____0 = (function (){
var statearr_27738 = [null,null,null,null,null,null,null,null];
(statearr_27738[(0)] = fluree$db$graphdb$state_machine__2746__auto__);

(statearr_27738[(1)] = (1));

return statearr_27738;
});
var fluree$db$graphdb$state_machine__2746__auto____1 = (function (state_27714){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27739){var ex__2749__auto__ = e27739;
var statearr_27740_27777 = state_27714;
(statearr_27740_27777[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27714[(4)]))){
var statearr_27741_27778 = state_27714;
(statearr_27741_27778[(1)] = cljs.core.first.call(null,(state_27714[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27779 = state_27714;
state_27714 = G__27779;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2746__auto__ = function(state_27714){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2746__auto____1.call(this,state_27714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2746__auto____0;
fluree$db$graphdb$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2746__auto____1;
return fluree$db$graphdb$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27742 = f__2769__auto__.call(null);
(statearr_27742[(6)] = c__2768__auto__);

return statearr_27742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k27781,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__27785 = k27781;
var G__27785__$1 = (((G__27785 instanceof cljs.core.Keyword))?G__27785.fqn:null);
switch (G__27785__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27781,else__4505__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__27786){
var vec__27787 = p__27786;
var k__4526__auto__ = cljs.core.nth.call(null,vec__27787,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__27787,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27780){
var self__ = this;
var G__27780__$1 = this;
return (new cljs.core.RecordIter((0),G__27780__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27782,other27783){
var self__ = this;
var this27782__$1 = this;
return (((!((other27783 == null)))) && ((((this27782__$1.constructor === other27783.constructor)) && (((cljs.core._EQ_.call(null,this27782__$1.conn,other27783.conn)) && (((cljs.core._EQ_.call(null,this27782__$1.network,other27783.network)) && (((cljs.core._EQ_.call(null,this27782__$1.dbid,other27783.dbid)) && (((cljs.core._EQ_.call(null,this27782__$1.block,other27783.block)) && (((cljs.core._EQ_.call(null,this27782__$1.t,other27783.t)) && (((cljs.core._EQ_.call(null,this27782__$1.tt_id,other27783.tt_id)) && (((cljs.core._EQ_.call(null,this27782__$1.stats,other27783.stats)) && (((cljs.core._EQ_.call(null,this27782__$1.spot,other27783.spot)) && (((cljs.core._EQ_.call(null,this27782__$1.psot,other27783.psot)) && (((cljs.core._EQ_.call(null,this27782__$1.post,other27783.post)) && (((cljs.core._EQ_.call(null,this27782__$1.opst,other27783.opst)) && (((cljs.core._EQ_.call(null,this27782__$1.schema,other27783.schema)) && (((cljs.core._EQ_.call(null,this27782__$1.settings,other27783.settings)) && (((cljs.core._EQ_.call(null,this27782__$1.index_configs,other27783.index_configs)) && (((cljs.core._EQ_.call(null,this27782__$1.schema_cache,other27783.schema_cache)) && (((cljs.core._EQ_.call(null,this27782__$1.novelty,other27783.novelty)) && (((cljs.core._EQ_.call(null,this27782__$1.permissions,other27783.permissions)) && (((cljs.core._EQ_.call(null,this27782__$1.fork,other27783.fork)) && (((cljs.core._EQ_.call(null,this27782__$1.fork_block,other27783.fork_block)) && (((cljs.core._EQ_.call(null,this27782__$1.current_db_fn,other27783.current_db_fn)) && (cljs.core._EQ_.call(null,this27782__$1.__extmap,other27783.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k27781){
var self__ = this;
var this__4509__auto____$1 = this;
var G__27790 = k27781;
var G__27790__$1 = (((G__27790 instanceof cljs.core.Keyword))?G__27790.fqn:null);
switch (G__27790__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27781);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__27780){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__27791 = cljs.core.keyword_identical_QMARK_;
var expr__27792 = k__4511__auto__;
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27792))){
return (new fluree.db.graphdb.GraphDb(G__27780,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27780,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27780,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27780,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27780,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27780,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27780,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27780,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27780,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27780,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27780,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27780,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27780,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27780,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27780,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27780,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27780,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27780,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27780,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27791.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27792))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27780,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__27780),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__27780){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27780,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop.call(null,this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop.call(null,this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db.call(null,this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.call(null,this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.call(null,this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27784){
var extmap__4542__auto__ = (function (){var G__27794 = cljs.core.dissoc.call(null,G__27784,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27784)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27794);
} else {
return G__27794;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27784),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27784),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
