// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28527 = arguments.length;
var i__4865__auto___28528 = (0);
while(true){
if((i__4865__auto___28528 < len__4864__auto___28527)){
args__4870__auto__.push((arguments[i__4865__auto___28528]));

var G__28529 = (i__4865__auto___28528 + (1));
i__4865__auto___28528 = G__28529;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28524){
var G__28525 = cljs.core.first.call(null,seq28524);
var seq28524__$1 = cljs.core.next.call(null,seq28524);
var G__28526 = cljs.core.first.call(null,seq28524__$1);
var seq28524__$2 = cljs.core.next.call(null,seq28524__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28525,G__28526,seq28524__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28530){var e = e28530;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28531){var e = e28531;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28532){var e = e28532;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28533){var e = e28533;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28534){var e = e28534;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28537 = arguments.length;
var i__4865__auto___28538 = (0);
while(true){
if((i__4865__auto___28538 < len__4864__auto___28537)){
args__4870__auto__.push((arguments[i__4865__auto___28538]));

var G__28539 = (i__4865__auto___28538 + (1));
i__4865__auto___28538 = G__28539;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28536){var e = e28536;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28535){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28535));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28542 = arguments.length;
var i__4865__auto___28543 = (0);
while(true){
if((i__4865__auto___28543 < len__4864__auto___28542)){
args__4870__auto__.push((arguments[i__4865__auto___28543]));

var G__28544 = (i__4865__auto___28543 + (1));
i__4865__auto___28543 = G__28544;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28541){var e = e28541;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28540){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28540));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28545){var e = e28545;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28548 = arguments.length;
var i__4865__auto___28549 = (0);
while(true){
if((i__4865__auto___28549 < len__4864__auto___28548)){
args__4870__auto__.push((arguments[i__4865__auto___28549]));

var G__28550 = (i__4865__auto___28549 + (1));
i__4865__auto___28549 = G__28550;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28547){var e = e28547;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28546){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28546));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28553 = arguments.length;
var i__4865__auto___28554 = (0);
while(true){
if((i__4865__auto___28554 < len__4864__auto___28553)){
args__4870__auto__.push((arguments[i__4865__auto___28554]));

var G__28555 = (i__4865__auto___28554 + (1));
i__4865__auto___28554 = G__28555;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e28552){var e = e28552;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28551){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28551));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28556){var e = e28556;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28557){var e = e28557;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28560 = arguments.length;
var i__4865__auto___28561 = (0);
while(true){
if((i__4865__auto___28561 < len__4864__auto___28560)){
args__4870__auto__.push((arguments[i__4865__auto___28561]));

var G__28562 = (i__4865__auto___28561 + (1));
i__4865__auto___28561 = G__28562;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28559){var e = e28559;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28558){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28558));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28565 = arguments.length;
var i__4865__auto___28566 = (0);
while(true){
if((i__4865__auto___28566 < len__4864__auto___28565)){
args__4870__auto__.push((arguments[i__4865__auto___28566]));

var G__28567 = (i__4865__auto___28566 + (1));
i__4865__auto___28566 = G__28567;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28564){var e = e28564;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28563){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28563));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28570 = arguments.length;
var i__4865__auto___28571 = (0);
while(true){
if((i__4865__auto___28571 < len__4864__auto___28570)){
args__4870__auto__.push((arguments[i__4865__auto___28571]));

var G__28572 = (i__4865__auto___28571 + (1));
i__4865__auto___28571 = G__28572;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28569){var e = e28569;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28568){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28568));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28575 = arguments.length;
var i__4865__auto___28576 = (0);
while(true){
if((i__4865__auto___28576 < len__4864__auto___28575)){
args__4870__auto__.push((arguments[i__4865__auto___28576]));

var G__28577 = (i__4865__auto___28576 + (1));
i__4865__auto___28576 = G__28577;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28574){var e = e28574;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28573){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28573));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28580 = arguments.length;
var i__4865__auto___28581 = (0);
while(true){
if((i__4865__auto___28581 < len__4864__auto___28580)){
args__4870__auto__.push((arguments[i__4865__auto___28581]));

var G__28582 = (i__4865__auto___28581 + (1));
i__4865__auto___28581 = G__28582;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28579){var e = e28579;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28578){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28578));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28585 = arguments.length;
var i__4865__auto___28586 = (0);
while(true){
if((i__4865__auto___28586 < len__4864__auto___28585)){
args__4870__auto__.push((arguments[i__4865__auto___28586]));

var G__28587 = (i__4865__auto___28586 + (1));
i__4865__auto___28586 = G__28587;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28584){var e = e28584;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28583){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28583));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28590 = arguments.length;
var i__4865__auto___28591 = (0);
while(true){
if((i__4865__auto___28591 < len__4864__auto___28590)){
args__4870__auto__.push((arguments[i__4865__auto___28591]));

var G__28592 = (i__4865__auto___28591 + (1));
i__4865__auto___28591 = G__28592;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28589){var e = e28589;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28588){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28588));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28594 = arguments.length;
switch (G__28594) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28622){
var state_val_28623 = (state_28622[(1)]);
if((state_val_28623 === (7))){
var inst_28607 = (state_28622[(7)]);
var inst_28610 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28607,"query",query_map);
var state_28622__$1 = state_28622;
var statearr_28624_28710 = state_28622__$1;
(statearr_28624_28710[(2)] = inst_28610);

(statearr_28624_28710[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (1))){
var state_28622__$1 = state_28622;
var statearr_28625_28711 = state_28622__$1;
(statearr_28625_28711[(2)] = null);

(statearr_28625_28711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (4))){
var inst_28595 = (state_28622[(2)]);
var state_28622__$1 = state_28622;
var statearr_28626_28712 = state_28622__$1;
(statearr_28626_28712[(2)] = inst_28595);

(statearr_28626_28712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (6))){
var inst_28607 = (state_28622[(7)]);
var inst_28607__$1 = (state_28622[(2)]);
var inst_28608 = fluree.db.util.core.exception_QMARK_.call(null,inst_28607__$1);
var state_28622__$1 = (function (){var statearr_28627 = state_28622;
(statearr_28627[(7)] = inst_28607__$1);

return statearr_28627;
})();
if(inst_28608){
var statearr_28628_28713 = state_28622__$1;
(statearr_28628_28713[(1)] = (7));

} else {
var statearr_28629_28714 = state_28622__$1;
(statearr_28629_28714[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (3))){
var inst_28620 = (state_28622[(2)]);
var state_28622__$1 = state_28622;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28622__$1,inst_28620);
} else {
if((state_val_28623 === (2))){
var inst_28601 = (state_28622[(8)]);
var _ = (function (){var statearr_28631 = state_28622;
(statearr_28631[(4)] = cljs.core.cons.call(null,(5),(state_28622[(4)])));

return statearr_28631;
})();
var inst_28601__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28602 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28603 = cljs.core.assoc.call(null,inst_28602,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28601__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28604 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28603);
var inst_28605 = fluree.db.query.fql.query.call(null,db,inst_28604);
var state_28622__$1 = (function (){var statearr_28632 = state_28622;
(statearr_28632[(8)] = inst_28601__$1);

return statearr_28632;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28622__$1,(6),inst_28605);
} else {
if((state_val_28623 === (9))){
var inst_28617 = (state_28622[(2)]);
var _ = (function (){var statearr_28633 = state_28622;
(statearr_28633[(4)] = cljs.core.rest.call(null,(state_28622[(4)])));

return statearr_28633;
})();
var state_28622__$1 = state_28622;
var statearr_28634_28715 = state_28622__$1;
(statearr_28634_28715[(2)] = inst_28617);

(statearr_28634_28715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (5))){
var _ = (function (){var statearr_28635 = state_28622;
(statearr_28635[(4)] = cljs.core.rest.call(null,(state_28622[(4)])));

return statearr_28635;
})();
var state_28622__$1 = state_28622;
var ex28630 = (state_28622__$1[(2)]);
var statearr_28636_28716 = state_28622__$1;
(statearr_28636_28716[(5)] = ex28630);


if((ex28630 instanceof Error)){
var statearr_28637_28717 = state_28622__$1;
(statearr_28637_28717[(1)] = (4));

(statearr_28637_28717[(5)] = null);

} else {
throw ex28630;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28623 === (8))){
var inst_28607 = (state_28622[(7)]);
var inst_28601 = (state_28622[(8)]);
var inst_28612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28613 = cljs.core.deref.call(null,inst_28601);
var inst_28614 = [inst_28607,inst_28613];
var inst_28615 = (new cljs.core.PersistentVector(null,2,(5),inst_28612,inst_28614,null));
var state_28622__$1 = state_28622;
var statearr_28638_28718 = state_28622__$1;
(statearr_28638_28718[(2)] = inst_28615);

(statearr_28638_28718[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28639 = [null,null,null,null,null,null,null,null,null];
(statearr_28639[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28639[(1)] = (1));

return statearr_28639;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28622){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28622);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28640){var ex__2749__auto__ = e28640;
var statearr_28641_28719 = state_28622;
(statearr_28641_28719[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28622[(4)]))){
var statearr_28642_28720 = state_28622;
(statearr_28642_28720[(1)] = cljs.core.first.call(null,(state_28622[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28721 = state_28622;
state_28622 = G__28721;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28622){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28643 = f__2769__auto__.call(null);
(statearr_28643[(6)] = c__2768__auto__);

return statearr_28643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28688){
var state_val_28689 = (state_28688[(1)]);
if((state_val_28689 === (7))){
var inst_28674 = (state_28688[(2)]);
var inst_28675 = fluree.db.query.fql.query.call(null,db,inst_28674);
var state_28688__$1 = state_28688;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28688__$1,(8),inst_28675);
} else {
if((state_val_28689 === (1))){
var inst_28644 = typeof select === 'string';
var state_28688__$1 = state_28688;
if(cljs.core.truth_(inst_28644)){
var statearr_28690_28722 = state_28688__$1;
(statearr_28690_28722[(1)] = (2));

} else {
var statearr_28691_28723 = state_28688__$1;
(statearr_28691_28723[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (4))){
var inst_28650 = (state_28688[(7)]);
var inst_28657 = (state_28688[(8)]);
var inst_28649 = (state_28688[(2)]);
var inst_28650__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28651 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28652 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28653 = [inst_28650__$1,(100000)];
var inst_28654 = cljs.core.PersistentHashMap.fromArrays(inst_28652,inst_28653);
var inst_28655 = [inst_28649,from,where,block,limit,inst_28654];
var inst_28656 = cljs.core.PersistentHashMap.fromArrays(inst_28651,inst_28655);
var inst_28657__$1 = fluree.db.util.core.without_nils.call(null,inst_28656);
var inst_28658 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28657__$1);
var inst_28659 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28657__$1);
var inst_28660 = cljs.core.first.call(null,inst_28659);
var inst_28661 = fluree.db.dbfunctions.internal.str.call(null,inst_28660);
var inst_28662 = cljs.core._EQ_.call(null,"[",inst_28661);
var inst_28663 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28657__$1);
var inst_28664 = cljs.core.last.call(null,inst_28663);
var inst_28665 = fluree.db.dbfunctions.internal.str.call(null,inst_28664);
var inst_28666 = cljs.core._EQ_.call(null,"]",inst_28665);
var inst_28667 = fluree.db.dbfunctions.internal.and.call(null,inst_28658,inst_28662,inst_28666);
var state_28688__$1 = (function (){var statearr_28692 = state_28688;
(statearr_28692[(7)] = inst_28650__$1);

(statearr_28692[(8)] = inst_28657__$1);

return statearr_28692;
})();
if(cljs.core.truth_(inst_28667)){
var statearr_28693_28724 = state_28688__$1;
(statearr_28693_28724[(1)] = (5));

} else {
var statearr_28694_28725 = state_28688__$1;
(statearr_28694_28725[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (6))){
var inst_28657 = (state_28688[(8)]);
var state_28688__$1 = state_28688;
var statearr_28695_28726 = state_28688__$1;
(statearr_28695_28726[(2)] = inst_28657);

(statearr_28695_28726[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (3))){
var state_28688__$1 = state_28688;
var statearr_28696_28727 = state_28688__$1;
(statearr_28696_28727[(2)] = select);

(statearr_28696_28727[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (2))){
var inst_28646 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28688__$1 = state_28688;
var statearr_28697_28728 = state_28688__$1;
(statearr_28697_28728[(2)] = inst_28646);

(statearr_28697_28728[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (11))){
var inst_28686 = (state_28688[(2)]);
var state_28688__$1 = state_28688;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28688__$1,inst_28686);
} else {
if((state_val_28689 === (9))){
var inst_28677 = (state_28688[(9)]);
var state_28688__$1 = state_28688;
var statearr_28698_28729 = state_28688__$1;
(statearr_28698_28729[(2)] = inst_28677);

(statearr_28698_28729[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (5))){
var inst_28657 = (state_28688[(8)]);
var inst_28669 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28657);
var inst_28670 = cljs.reader.read_string.call(null,inst_28669);
var inst_28671 = cljs.core.assoc.call(null,inst_28657,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28670);
var state_28688__$1 = state_28688;
var statearr_28699_28730 = state_28688__$1;
(statearr_28699_28730[(2)] = inst_28671);

(statearr_28699_28730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (10))){
var inst_28677 = (state_28688[(9)]);
var inst_28650 = (state_28688[(7)]);
var inst_28681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28682 = cljs.core.deref.call(null,inst_28650);
var inst_28683 = [inst_28677,inst_28682];
var inst_28684 = (new cljs.core.PersistentVector(null,2,(5),inst_28681,inst_28683,null));
var state_28688__$1 = state_28688;
var statearr_28700_28731 = state_28688__$1;
(statearr_28700_28731[(2)] = inst_28684);

(statearr_28700_28731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28689 === (8))){
var inst_28677 = (state_28688[(9)]);
var inst_28677__$1 = (state_28688[(2)]);
var inst_28678 = fluree.db.util.core.exception_QMARK_.call(null,inst_28677__$1);
var state_28688__$1 = (function (){var statearr_28701 = state_28688;
(statearr_28701[(9)] = inst_28677__$1);

return statearr_28701;
})();
if(inst_28678){
var statearr_28702_28732 = state_28688__$1;
(statearr_28702_28732[(1)] = (9));

} else {
var statearr_28703_28733 = state_28688__$1;
(statearr_28703_28733[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28704 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28704[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28704[(1)] = (1));

return statearr_28704;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28688){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28688);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28705){var ex__2749__auto__ = e28705;
var statearr_28706_28734 = state_28688;
(statearr_28706_28734[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28688[(4)]))){
var statearr_28707_28735 = state_28688;
(statearr_28707_28735[(1)] = cljs.core.first.call(null,(state_28688[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28736 = state_28688;
state_28688 = G__28736;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28688){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28688);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28708 = f__2769__auto__.call(null);
(statearr_28708[(6)] = c__2768__auto__);

return statearr_28708;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28740 = path;
var vec__28741 = G__28740;
var seq__28742 = cljs.core.seq.call(null,vec__28741);
var first__28743 = cljs.core.first.call(null,seq__28742);
var seq__28742__$1 = cljs.core.next.call(null,seq__28742);
var var$ = first__28743;
var r = seq__28742__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28740__$1 = G__28740;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28747 = G__28740__$1;
var seq__28748 = cljs.core.seq.call(null,vec__28747);
var first__28749 = cljs.core.first.call(null,seq__28748);
var seq__28748__$1 = cljs.core.next.call(null,seq__28748);
var var$__$1 = first__28749;
var r__$1 = seq__28748__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28750 = r__$1;
var G__28751 = n__$2;
var G__28752 = next_clauses;
G__28740__$1 = G__28750;
n__$1 = G__28751;
where_clauses__$1 = G__28752;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28753 = r__$1;
var G__28754 = next_n;
var G__28755 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28740__$1 = G__28753;
n__$1 = G__28754;
where_clauses__$1 = G__28755;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28792){
var state_val_28793 = (state_28792[(1)]);
if((state_val_28793 === (7))){
var inst_28765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28766 = [path];
var inst_28767 = (new cljs.core.PersistentVector(null,1,(5),inst_28765,inst_28766,null));
var state_28792__$1 = state_28792;
var statearr_28794_28822 = state_28792__$1;
(statearr_28794_28822[(2)] = inst_28767);

(statearr_28794_28822[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (1))){
var state_28792__$1 = state_28792;
var statearr_28795_28823 = state_28792__$1;
(statearr_28795_28823[(2)] = null);

(statearr_28795_28823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (4))){
var inst_28756 = (state_28792[(2)]);
var state_28792__$1 = state_28792;
var statearr_28796_28824 = state_28792__$1;
(statearr_28796_28824[(2)] = inst_28756);

(statearr_28796_28824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (13))){
var inst_28783 = (state_28792[(2)]);
var inst_28784 = fluree.db.util.async.throw_err.call(null,inst_28783);
var _ = (function (){var statearr_28797 = state_28792;
(statearr_28797[(4)] = cljs.core.rest.call(null,(state_28792[(4)])));

return statearr_28797;
})();
var state_28792__$1 = state_28792;
var statearr_28798_28825 = state_28792__$1;
(statearr_28798_28825[(2)] = inst_28784);

(statearr_28798_28825[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (6))){
var state_28792__$1 = state_28792;
var statearr_28800_28826 = state_28792__$1;
(statearr_28800_28826[(2)] = path);

(statearr_28800_28826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (3))){
var inst_28790 = (state_28792[(2)]);
var state_28792__$1 = state_28792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28792__$1,inst_28790);
} else {
if((state_val_28793 === (12))){
var _ = (function (){var statearr_28801 = state_28792;
(statearr_28801[(4)] = cljs.core.rest.call(null,(state_28792[(4)])));

return statearr_28801;
})();
var state_28792__$1 = state_28792;
var ex28799 = (state_28792__$1[(2)]);
var statearr_28802_28827 = state_28792__$1;
(statearr_28802_28827[(5)] = ex28799);


var statearr_28803_28828 = state_28792__$1;
(statearr_28803_28828[(1)] = (11));

(statearr_28803_28828[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (2))){
var _ = (function (){var statearr_28804 = state_28792;
(statearr_28804[(4)] = cljs.core.cons.call(null,(5),(state_28792[(4)])));

return statearr_28804;
})();
var inst_28762 = cljs.core.vector_QMARK_.call(null,path);
var state_28792__$1 = state_28792;
if(inst_28762){
var statearr_28805_28829 = state_28792__$1;
(statearr_28805_28829[(1)] = (6));

} else {
var statearr_28806_28830 = state_28792__$1;
(statearr_28806_28830[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (11))){
var inst_28769 = (state_28792[(7)]);
var inst_28774 = (state_28792[(2)]);
var inst_28775 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28774,"relationship?",startSubject,inst_28769,endSubject);
var state_28792__$1 = state_28792;
var statearr_28808_28831 = state_28792__$1;
(statearr_28808_28831[(2)] = inst_28775);

(statearr_28808_28831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (9))){
var inst_28773 = (state_28792[(8)]);
var _ = (function (){var statearr_28809 = state_28792;
(statearr_28809[(4)] = cljs.core.cons.call(null,(12),(state_28792[(4)])));

return statearr_28809;
})();
var inst_28781 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28773);
var state_28792__$1 = state_28792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28792__$1,(13),inst_28781);
} else {
if((state_val_28793 === (5))){
var _ = (function (){var statearr_28810 = state_28792;
(statearr_28810[(4)] = cljs.core.rest.call(null,(state_28792[(4)])));

return statearr_28810;
})();
var state_28792__$1 = state_28792;
var ex28807 = (state_28792__$1[(2)]);
var statearr_28811_28832 = state_28792__$1;
(statearr_28811_28832[(5)] = ex28807);


if((ex28807 instanceof Error)){
var statearr_28812_28833 = state_28792__$1;
(statearr_28812_28833[(1)] = (4));

(statearr_28812_28833[(5)] = null);

} else {
throw ex28807;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (10))){
var inst_28787 = (state_28792[(2)]);
var _ = (function (){var statearr_28813 = state_28792;
(statearr_28813[(4)] = cljs.core.rest.call(null,(state_28792[(4)])));

return statearr_28813;
})();
var state_28792__$1 = state_28792;
var statearr_28814_28834 = state_28792__$1;
(statearr_28814_28834[(2)] = inst_28787);

(statearr_28814_28834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28793 === (8))){
var inst_28769 = (state_28792[(7)]);
var inst_28769__$1 = (state_28792[(2)]);
var inst_28770 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28769__$1,endSubject);
var inst_28771 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28772 = ["?var1",inst_28770];
var inst_28773 = cljs.core.PersistentHashMap.fromArrays(inst_28771,inst_28772);
var state_28792__$1 = (function (){var statearr_28815 = state_28792;
(statearr_28815[(8)] = inst_28773);

(statearr_28815[(7)] = inst_28769__$1);

return statearr_28815;
})();
var statearr_28816_28835 = state_28792__$1;
(statearr_28816_28835[(2)] = null);

(statearr_28816_28835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_28817 = [null,null,null,null,null,null,null,null,null];
(statearr_28817[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_28817[(1)] = (1));

return statearr_28817;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_28792){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28818){var ex__2749__auto__ = e28818;
var statearr_28819_28836 = state_28792;
(statearr_28819_28836[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28792[(4)]))){
var statearr_28820_28837 = state_28792;
(statearr_28820_28837[(1)] = cljs.core.first.call(null,(state_28792[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28838 = state_28792;
state_28792 = G__28838;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_28792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_28792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28821 = f__2769__auto__.call(null);
(statearr_28821[(6)] = c__2768__auto__);

return statearr_28821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28839){var e = e28839;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28840){var e = e28840;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28841){var e = e28841;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28842){var e = e28842;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28845 = arguments.length;
var i__4865__auto___28846 = (0);
while(true){
if((i__4865__auto___28846 < len__4864__auto___28845)){
args__4870__auto__.push((arguments[i__4865__auto___28846]));

var G__28847 = (i__4865__auto___28846 + (1));
i__4865__auto___28846 = G__28847;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28844){var e = e28844;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28843){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28843));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28850 = arguments.length;
var i__4865__auto___28851 = (0);
while(true){
if((i__4865__auto___28851 < len__4864__auto___28850)){
args__4870__auto__.push((arguments[i__4865__auto___28851]));

var G__28852 = (i__4865__auto___28851 + (1));
i__4865__auto___28851 = G__28852;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28849){var e = e28849;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28848){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28848));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28855 = arguments.length;
var i__4865__auto___28856 = (0);
while(true){
if((i__4865__auto___28856 < len__4864__auto___28855)){
args__4870__auto__.push((arguments[i__4865__auto___28856]));

var G__28857 = (i__4865__auto___28856 + (1));
i__4865__auto___28856 = G__28857;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28854){var e = e28854;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28853){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28853));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28860 = arguments.length;
var i__4865__auto___28861 = (0);
while(true){
if((i__4865__auto___28861 < len__4864__auto___28860)){
args__4870__auto__.push((arguments[i__4865__auto___28861]));

var G__28862 = (i__4865__auto___28861 + (1));
i__4865__auto___28861 = G__28862;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28859){var e = e28859;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28858){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28858));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28863){var e = e28863;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28864){var e = e28864;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28865){var e = e28865;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28866){var e = e28866;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28867){var e = e28867;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28873 = path;
var vec__28874 = G__28873;
var seq__28875 = cljs.core.seq.call(null,vec__28874);
var first__28876 = cljs.core.first.call(null,seq__28875);
var seq__28875__$1 = cljs.core.next.call(null,seq__28875);
var pred = first__28876;
var r = seq__28875__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28873__$1 = G__28873;
var subjects__$1 = subjects;
while(true){
var vec__28880 = G__28873__$1;
var seq__28881 = cljs.core.seq.call(null,vec__28880);
var first__28882 = cljs.core.first.call(null,seq__28881);
var seq__28881__$1 = cljs.core.next.call(null,seq__28881);
var pred__$1 = first__28882;
var r__$1 = seq__28881__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28873__$1,subjects__$1,vec__28880,seq__28881,first__28882,seq__28881__$1,pred__$1,r__$1,subjects__$2,G__28873,vec__28874,seq__28875,first__28876,seq__28875__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28873__$1,subjects__$1,vec__28880,seq__28881,first__28882,seq__28881__$1,pred__$1,r__$1,subjects__$2,G__28873,vec__28874,seq__28875,first__28876,seq__28875__$1,pred,r,subjects){
return (function (p1__28868_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28868_SHARP_,pred__$1);
});})(G__28873__$1,subjects__$1,vec__28880,seq__28881,first__28882,seq__28881__$1,pred__$1,r__$1,subjects__$2,G__28873,vec__28874,seq__28875,first__28876,seq__28875__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28873__$1,subjects__$1,vec__28880,seq__28881,first__28882,seq__28881__$1,pred__$1,r__$1,subjects__$2,G__28873,vec__28874,seq__28875,first__28876,seq__28875__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__28883 = r__$1;
var G__28884 = next_subjects;
G__28873__$1 = G__28883;
subjects__$1 = G__28884;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28869){var e = e28869;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28885){var e = e28885;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e28886){var e = e28886;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28889 = arguments.length;
var i__4865__auto___28890 = (0);
while(true){
if((i__4865__auto___28890 < len__4864__auto___28889)){
args__4870__auto__.push((arguments[i__4865__auto___28890]));

var G__28891 = (i__4865__auto___28890 + (1));
i__4865__auto___28890 = G__28891;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28888){var e = e28888;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28887){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28887));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28892){var e = e28892;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28895 = arguments.length;
var i__4865__auto___28896 = (0);
while(true){
if((i__4865__auto___28896 < len__4864__auto___28895)){
args__4870__auto__.push((arguments[i__4865__auto___28896]));

var G__28897 = (i__4865__auto___28896 + (1));
i__4865__auto___28896 = G__28897;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28894){var e = e28894;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28893){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28893));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28898){var e = e28898;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28955){
var state_val_28956 = (state_28955[(1)]);
if((state_val_28956 === (7))){
var inst_28901 = (state_28955[(2)]);
var state_28955__$1 = state_28955;
var statearr_28957_28991 = state_28955__$1;
(statearr_28957_28991[(2)] = inst_28901);

(statearr_28957_28991[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (1))){
var state_28955__$1 = state_28955;
var statearr_28958_28992 = state_28955__$1;
(statearr_28958_28992[(2)] = null);

(statearr_28958_28992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (4))){
var inst_28900 = (state_28955[(2)]);
var state_28955__$1 = (function (){var statearr_28959 = state_28955;
(statearr_28959[(7)] = inst_28900);

return statearr_28959;
})();
var statearr_28960_28993 = state_28955__$1;
(statearr_28960_28993[(2)] = null);

(statearr_28960_28993[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (15))){
var inst_28938 = (state_28955[(8)]);
var inst_28923 = (state_28955[(9)]);
var inst_28925 = (state_28955[(10)]);
var inst_28935 = (state_28955[(11)]);
var inst_28926 = (state_28955[(12)]);
var inst_28936 = (state_28955[(13)]);
var inst_28942 = (function (){var db = inst_28923;
var prevT = inst_28925;
var db_SINGLEQUOTE_ = inst_28926;
var prev_vals = inst_28935;
var fuel = inst_28936;
var G__28937 = inst_28938;
return (function (p1__28899_SHARP_){
var f = p1__28899_SHARP_;
return f.o;
});
})();
var inst_28943 = inst_28942.call(null,inst_28938);
var state_28955__$1 = state_28955;
var statearr_28961_28994 = state_28955__$1;
(statearr_28961_28994[(2)] = inst_28943);

(statearr_28961_28994[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (13))){
var inst_28938 = (state_28955[(8)]);
var inst_28935 = (state_28955[(11)]);
var inst_28934 = (state_28955[(2)]);
var inst_28935__$1 = fluree.db.util.async.throw_err.call(null,inst_28934);
var inst_28936 = fluree.db.dbfunctions.internal.count.call(null,inst_28935__$1);
var inst_28938__$1 = cljs.core.first.call(null,inst_28935__$1);
var inst_28939 = (inst_28938__$1 == null);
var state_28955__$1 = (function (){var statearr_28962 = state_28955;
(statearr_28962[(8)] = inst_28938__$1);

(statearr_28962[(11)] = inst_28935__$1);

(statearr_28962[(13)] = inst_28936);

return statearr_28962;
})();
if(cljs.core.truth_(inst_28939)){
var statearr_28963_28995 = state_28955__$1;
(statearr_28963_28995[(1)] = (14));

} else {
var statearr_28964_28996 = state_28955__$1;
(statearr_28964_28996[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (6))){
var inst_28910 = (state_28955[(2)]);
var state_28955__$1 = state_28955;
var statearr_28965_28997 = state_28955__$1;
(statearr_28965_28997[(2)] = inst_28910);

(statearr_28965_28997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (3))){
var inst_28953 = (state_28955[(2)]);
var state_28955__$1 = state_28955;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28955__$1,inst_28953);
} else {
if((state_val_28956 === (12))){
var inst_28950 = (state_28955[(2)]);
var _ = (function (){var statearr_28966 = state_28955;
(statearr_28966[(4)] = cljs.core.rest.call(null,(state_28955[(4)])));

return statearr_28966;
})();
var state_28955__$1 = state_28955;
var statearr_28967_28998 = state_28955__$1;
(statearr_28967_28998[(2)] = inst_28950);

(statearr_28967_28998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (2))){
var _ = (function (){var statearr_28969 = state_28955;
(statearr_28969[(4)] = cljs.core.cons.call(null,(9),(state_28955[(4)])));

return statearr_28969;
})();
var inst_28916 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28917 = typeof inst_28916 === 'string';
var state_28955__$1 = state_28955;
if(cljs.core.truth_(inst_28917)){
var statearr_28970_28999 = state_28955__$1;
(statearr_28970_28999[(1)] = (10));

} else {
var statearr_28971_29000 = state_28955__$1;
(statearr_28971_29000[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (11))){
var inst_28923 = (state_28955[(9)]);
var inst_28925 = (state_28955[(10)]);
var inst_28926 = (state_28955[(12)]);
var inst_28923__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28924 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28923__$1);
var inst_28925__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_28924);
var inst_28926__$1 = cljs.core.assoc.call(null,inst_28923__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28925__$1);
var inst_28927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28928 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28929 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28930 = [inst_28928,inst_28929];
var inst_28931 = (new cljs.core.PersistentVector(null,2,(5),inst_28927,inst_28930,null));
var inst_28932 = fluree.db.dbproto._search.call(null,inst_28926__$1,inst_28931);
var state_28955__$1 = (function (){var statearr_28972 = state_28955;
(statearr_28972[(9)] = inst_28923__$1);

(statearr_28972[(10)] = inst_28925__$1);

(statearr_28972[(12)] = inst_28926__$1);

return statearr_28972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28955__$1,(13),inst_28932);
} else {
if((state_val_28956 === (9))){
var _ = (function (){var statearr_28973 = state_28955;
(statearr_28973[(4)] = cljs.core.rest.call(null,(state_28955[(4)])));

return statearr_28973;
})();
var state_28955__$1 = state_28955;
var ex28968 = (state_28955__$1[(2)]);
var statearr_28974_29001 = state_28955__$1;
(statearr_28974_29001[(5)] = ex28968);


var statearr_28975_29002 = state_28955__$1;
(statearr_28975_29002[(1)] = (4));

(statearr_28975_29002[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (5))){
var inst_28900 = (state_28955[(7)]);
var _ = (function (){var statearr_28976 = state_28955;
(statearr_28976[(4)] = cljs.core.cons.call(null,(8),(state_28955[(4)])));

return statearr_28976;
})();
var inst_28907 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28900,"?pO","Context Object");
var ___$1 = (function (){var statearr_28977 = state_28955;
(statearr_28977[(4)] = cljs.core.rest.call(null,(state_28955[(4)])));

return statearr_28977;
})();
var state_28955__$1 = state_28955;
var statearr_28978_29003 = state_28955__$1;
(statearr_28978_29003[(2)] = inst_28907);

(statearr_28978_29003[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (14))){
var state_28955__$1 = state_28955;
var statearr_28979_29004 = state_28955__$1;
(statearr_28979_29004[(2)] = null);

(statearr_28979_29004[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (16))){
var inst_28936 = (state_28955[(13)]);
var inst_28945 = (state_28955[(2)]);
var inst_28946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28947 = [inst_28945,inst_28936];
var inst_28948 = (new cljs.core.PersistentVector(null,2,(5),inst_28946,inst_28947,null));
var state_28955__$1 = state_28955;
var statearr_28981_29005 = state_28955__$1;
(statearr_28981_29005[(2)] = inst_28948);

(statearr_28981_29005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (10))){
var inst_28919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28920 = [null,(0)];
var inst_28921 = (new cljs.core.PersistentVector(null,2,(5),inst_28919,inst_28920,null));
var state_28955__$1 = state_28955;
var statearr_28982_29006 = state_28955__$1;
(statearr_28982_29006[(2)] = inst_28921);

(statearr_28982_29006[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28956 === (8))){
var _ = (function (){var statearr_28983 = state_28955;
(statearr_28983[(4)] = cljs.core.rest.call(null,(state_28955[(4)])));

return statearr_28983;
})();
var state_28955__$1 = state_28955;
var ex28980 = (state_28955__$1[(2)]);
var statearr_28984_29007 = state_28955__$1;
(statearr_28984_29007[(5)] = ex28980);


var statearr_28985_29008 = state_28955__$1;
(statearr_28985_29008[(1)] = (7));

(statearr_28985_29008[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_28986 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28986[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_28986[(1)] = (1));

return statearr_28986;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_28955){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28955);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28987){var ex__2749__auto__ = e28987;
var statearr_28988_29009 = state_28955;
(statearr_28988_29009[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28955[(4)]))){
var statearr_28989_29010 = state_28955;
(statearr_28989_29010[(1)] = cljs.core.first.call(null,(state_28955[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29011 = state_28955;
state_28955 = G__29011;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_28955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_28955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28990 = f__2769__auto__.call(null);
(statearr_28990[(6)] = c__2768__auto__);

return statearr_28990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29063){
var state_val_29064 = (state_29063[(1)]);
if((state_val_29064 === (7))){
var inst_29013 = (state_29063[(2)]);
var state_29063__$1 = state_29063;
var statearr_29065_29094 = state_29063__$1;
(statearr_29065_29094[(2)] = inst_29013);

(statearr_29065_29094[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (1))){
var state_29063__$1 = state_29063;
var statearr_29066_29095 = state_29063__$1;
(statearr_29066_29095[(2)] = null);

(statearr_29066_29095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (4))){
var inst_29012 = (state_29063[(2)]);
var state_29063__$1 = (function (){var statearr_29067 = state_29063;
(statearr_29067[(7)] = inst_29012);

return statearr_29067;
})();
var statearr_29068_29096 = state_29063__$1;
(statearr_29068_29096[(2)] = null);

(statearr_29068_29096[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (13))){
var inst_29058 = (state_29063[(2)]);
var _ = (function (){var statearr_29069 = state_29063;
(statearr_29069[(4)] = cljs.core.rest.call(null,(state_29063[(4)])));

return statearr_29069;
})();
var state_29063__$1 = state_29063;
var statearr_29070_29097 = state_29063__$1;
(statearr_29070_29097[(2)] = inst_29058);

(statearr_29070_29097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (6))){
var inst_29022 = (state_29063[(2)]);
var state_29063__$1 = state_29063;
var statearr_29071_29098 = state_29063__$1;
(statearr_29071_29098[(2)] = inst_29022);

(statearr_29071_29098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (3))){
var inst_29061 = (state_29063[(2)]);
var state_29063__$1 = state_29063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29063__$1,inst_29061);
} else {
if((state_val_29064 === (12))){
var inst_29045 = (state_29063[(8)]);
var inst_29054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29055 = [null,inst_29045];
var inst_29056 = (new cljs.core.PersistentVector(null,2,(5),inst_29054,inst_29055,null));
var state_29063__$1 = state_29063;
var statearr_29072_29099 = state_29063__$1;
(statearr_29072_29099[(2)] = inst_29056);

(statearr_29072_29099[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (2))){
var _ = (function (){var statearr_29074 = state_29063;
(statearr_29074[(4)] = cljs.core.cons.call(null,(9),(state_29063[(4)])));

return statearr_29074;
})();
var inst_29031 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29034 = [null,pred_name,"?o"];
var inst_29035 = (new cljs.core.PersistentVector(null,3,(5),inst_29033,inst_29034,null));
var inst_29036 = [inst_29035];
var inst_29037 = (new cljs.core.PersistentVector(null,1,(5),inst_29032,inst_29036,null));
var inst_29038 = ["?o",inst_29037,opts];
var inst_29039 = cljs.core.PersistentHashMap.fromArrays(inst_29031,inst_29038);
var inst_29040 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29039);
var state_29063__$1 = state_29063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29063__$1,(10),inst_29040);
} else {
if((state_val_29064 === (11))){
var inst_29045 = (state_29063[(8)]);
var inst_29044 = (state_29063[(9)]);
var inst_29049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29050 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_29044);
var inst_29051 = [inst_29050,inst_29045];
var inst_29052 = (new cljs.core.PersistentVector(null,2,(5),inst_29049,inst_29051,null));
var state_29063__$1 = state_29063;
var statearr_29075_29100 = state_29063__$1;
(statearr_29075_29100[(2)] = inst_29052);

(statearr_29075_29100[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (9))){
var _ = (function (){var statearr_29076 = state_29063;
(statearr_29076[(4)] = cljs.core.rest.call(null,(state_29063[(4)])));

return statearr_29076;
})();
var state_29063__$1 = state_29063;
var ex29073 = (state_29063__$1[(2)]);
var statearr_29077_29101 = state_29063__$1;
(statearr_29077_29101[(5)] = ex29073);


var statearr_29078_29102 = state_29063__$1;
(statearr_29078_29102[(1)] = (4));

(statearr_29078_29102[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (5))){
var inst_29012 = (state_29063[(7)]);
var _ = (function (){var statearr_29080 = state_29063;
(statearr_29080[(4)] = cljs.core.cons.call(null,(8),(state_29063[(4)])));

return statearr_29080;
})();
var inst_29019 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29012,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_29081 = state_29063;
(statearr_29081[(4)] = cljs.core.rest.call(null,(state_29063[(4)])));

return statearr_29081;
})();
var state_29063__$1 = state_29063;
var statearr_29082_29103 = state_29063__$1;
(statearr_29082_29103[(2)] = inst_29019);

(statearr_29082_29103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (10))){
var inst_29044 = (state_29063[(9)]);
var inst_29042 = (state_29063[(2)]);
var inst_29043 = fluree.db.util.async.throw_err.call(null,inst_29042);
var inst_29044__$1 = cljs.core.nth.call(null,inst_29043,(0),null);
var inst_29045 = cljs.core.nth.call(null,inst_29043,(1),null);
var inst_29046 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_29044__$1);
var inst_29047 = cljs.core.not.call(null,inst_29046);
var state_29063__$1 = (function (){var statearr_29083 = state_29063;
(statearr_29083[(8)] = inst_29045);

(statearr_29083[(9)] = inst_29044__$1);

return statearr_29083;
})();
if(inst_29047){
var statearr_29084_29104 = state_29063__$1;
(statearr_29084_29104[(1)] = (11));

} else {
var statearr_29085_29105 = state_29063__$1;
(statearr_29085_29105[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29064 === (8))){
var _ = (function (){var statearr_29086 = state_29063;
(statearr_29086[(4)] = cljs.core.rest.call(null,(state_29063[(4)])));

return statearr_29086;
})();
var state_29063__$1 = state_29063;
var ex29079 = (state_29063__$1[(2)]);
var statearr_29087_29106 = state_29063__$1;
(statearr_29087_29106[(5)] = ex29079);


var statearr_29088_29107 = state_29063__$1;
(statearr_29088_29107[(1)] = (7));

(statearr_29088_29107[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_29089 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29089[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_29089[(1)] = (1));

return statearr_29089;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_29063){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29090){var ex__2749__auto__ = e29090;
var statearr_29091_29108 = state_29063;
(statearr_29091_29108[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29063[(4)]))){
var statearr_29092_29109 = state_29063;
(statearr_29092_29109[(1)] = cljs.core.first.call(null,(state_29063[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29110 = state_29063;
state_29063 = G__29110;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_29063){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_29063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29093 = f__2769__auto__.call(null);
(statearr_29093[(6)] = c__2768__auto__);

return statearr_29093;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e29111){var e = e29111;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29113 = arguments.length;
switch (G__29113) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29183){
var state_val_29184 = (state_29183[(1)]);
if((state_val_29184 === (7))){
var inst_29115 = (state_29183[(2)]);
var state_29183__$1 = state_29183;
var statearr_29185_29229 = state_29183__$1;
(statearr_29185_29229[(2)] = inst_29115);

(statearr_29185_29229[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (20))){
var inst_29159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29160 = ["*"];
var inst_29161 = (new cljs.core.PersistentVector(null,1,(5),inst_29159,inst_29160,null));
var state_29183__$1 = state_29183;
var statearr_29186_29230 = state_29183__$1;
(statearr_29186_29230[(2)] = inst_29161);

(statearr_29186_29230[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (1))){
var state_29183__$1 = state_29183;
var statearr_29187_29231 = state_29183__$1;
(statearr_29187_29231[(2)] = null);

(statearr_29187_29231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (4))){
var inst_29114 = (state_29183[(2)]);
var state_29183__$1 = (function (){var statearr_29188 = state_29183;
(statearr_29188[(7)] = inst_29114);

return statearr_29188;
})();
var statearr_29189_29232 = state_29183__$1;
(statearr_29189_29232[(2)] = null);

(statearr_29189_29232[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (15))){
var inst_29178 = (state_29183[(2)]);
var _ = (function (){var statearr_29190 = state_29183;
(statearr_29190[(4)] = cljs.core.rest.call(null,(state_29183[(4)])));

return statearr_29190;
})();
var state_29183__$1 = state_29183;
var statearr_29191_29233 = state_29183__$1;
(statearr_29191_29233[(2)] = inst_29178);

(statearr_29191_29233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (21))){
var inst_29142 = (state_29183[(8)]);
var inst_29149 = (state_29183[(9)]);
var inst_29163 = (state_29183[(2)]);
var inst_29164 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29165 = cljs.core.PersistentHashMap.EMPTY;
var inst_29166 = [inst_29163,inst_29149,inst_29165];
var inst_29167 = cljs.core.PersistentHashMap.fromArrays(inst_29164,inst_29166);
var inst_29168 = fluree.db.dbfunctions.internal.query.call(null,inst_29142,inst_29167);
var state_29183__$1 = state_29183;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29183__$1,(22),inst_29168);
} else {
if((state_val_29184 === (13))){
var inst_29137 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29183__$1 = state_29183;
var statearr_29192_29234 = state_29183__$1;
(statearr_29192_29234[(2)] = inst_29137);

(statearr_29192_29234[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (22))){
var inst_29170 = (state_29183[(2)]);
var inst_29171 = fluree.db.util.async.throw_err.call(null,inst_29170);
var inst_29172 = cljs.core.nth.call(null,inst_29171,(0),null);
var inst_29173 = cljs.core.nth.call(null,inst_29171,(1),null);
var inst_29174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29175 = [inst_29172,inst_29173];
var inst_29176 = (new cljs.core.PersistentVector(null,2,(5),inst_29174,inst_29175,null));
var state_29183__$1 = state_29183;
var statearr_29193_29235 = state_29183__$1;
(statearr_29193_29235[(2)] = inst_29176);

(statearr_29193_29235[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (6))){
var inst_29124 = (state_29183[(2)]);
var state_29183__$1 = state_29183;
var statearr_29194_29236 = state_29183__$1;
(statearr_29194_29236[(2)] = inst_29124);

(statearr_29194_29236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (17))){
var inst_29146 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29147 = fluree.db.dbfunctions.internal.get.call(null,inst_29146,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29183__$1 = state_29183;
var statearr_29195_29237 = state_29183__$1;
(statearr_29195_29237[(2)] = inst_29147);

(statearr_29195_29237[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (3))){
var inst_29181 = (state_29183[(2)]);
var state_29183__$1 = state_29183;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29183__$1,inst_29181);
} else {
if((state_val_29184 === (12))){
var inst_29135 = (state_29183[(2)]);
var state_29183__$1 = state_29183;
if(cljs.core.truth_(inst_29135)){
var statearr_29196_29238 = state_29183__$1;
(statearr_29196_29238[(1)] = (13));

} else {
var statearr_29197_29239 = state_29183__$1;
(statearr_29197_29239[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (2))){
var inst_29130 = (state_29183[(10)]);
var _ = (function (){var statearr_29198 = state_29183;
(statearr_29198[(4)] = cljs.core.cons.call(null,(9),(state_29183[(4)])));

return statearr_29198;
})();
var inst_29130__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29183__$1 = (function (){var statearr_29199 = state_29183;
(statearr_29199[(10)] = inst_29130__$1);

return statearr_29199;
})();
if(cljs.core.truth_(inst_29130__$1)){
var statearr_29200_29240 = state_29183__$1;
(statearr_29200_29240[(1)] = (10));

} else {
var statearr_29201_29241 = state_29183__$1;
(statearr_29201_29241[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (19))){
var inst_29151 = cljs.core.PersistentVector.EMPTY;
var inst_29152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29153 = ["*"];
var inst_29154 = (new cljs.core.PersistentVector(null,1,(5),inst_29152,inst_29153,null));
var inst_29155 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29156 = cljs.core.concat.call(null,inst_29154,inst_29155);
var inst_29157 = cljs.core.into.call(null,inst_29151,inst_29156);
var state_29183__$1 = state_29183;
var statearr_29203_29242 = state_29183__$1;
(statearr_29203_29242[(2)] = inst_29157);

(statearr_29203_29242[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (11))){
var inst_29130 = (state_29183[(10)]);
var state_29183__$1 = state_29183;
var statearr_29204_29243 = state_29183__$1;
(statearr_29204_29243[(2)] = inst_29130);

(statearr_29204_29243[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (9))){
var _ = (function (){var statearr_29205 = state_29183;
(statearr_29205[(4)] = cljs.core.rest.call(null,(state_29183[(4)])));

return statearr_29205;
})();
var state_29183__$1 = state_29183;
var ex29202 = (state_29183__$1[(2)]);
var statearr_29206_29244 = state_29183__$1;
(statearr_29206_29244[(5)] = ex29202);


var statearr_29207_29245 = state_29183__$1;
(statearr_29207_29245[(1)] = (4));

(statearr_29207_29245[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (5))){
var inst_29114 = (state_29183[(7)]);
var _ = (function (){var statearr_29208 = state_29183;
(statearr_29208[(4)] = cljs.core.cons.call(null,(8),(state_29183[(4)])));

return statearr_29208;
})();
var inst_29121 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29114,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_29209 = state_29183;
(statearr_29209[(4)] = cljs.core.rest.call(null,(state_29183[(4)])));

return statearr_29209;
})();
var state_29183__$1 = state_29183;
var statearr_29210_29246 = state_29183__$1;
(statearr_29210_29246[(2)] = inst_29121);

(statearr_29210_29246[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (14))){
var inst_29143 = (state_29183[(11)]);
var inst_29142 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29143__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29183__$1 = (function (){var statearr_29211 = state_29183;
(statearr_29211[(8)] = inst_29142);

(statearr_29211[(11)] = inst_29143__$1);

return statearr_29211;
})();
if(cljs.core.truth_(inst_29143__$1)){
var statearr_29212_29247 = state_29183__$1;
(statearr_29212_29247[(1)] = (16));

} else {
var statearr_29213_29248 = state_29183__$1;
(statearr_29213_29248[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (16))){
var inst_29143 = (state_29183[(11)]);
var state_29183__$1 = state_29183;
var statearr_29214_29249 = state_29183__$1;
(statearr_29214_29249[(2)] = inst_29143);

(statearr_29214_29249[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (10))){
var inst_29132 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_29183__$1 = state_29183;
var statearr_29216_29250 = state_29183__$1;
(statearr_29216_29250[(2)] = inst_29132);

(statearr_29216_29250[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (18))){
var inst_29149 = (state_29183[(2)]);
var state_29183__$1 = (function (){var statearr_29217 = state_29183;
(statearr_29217[(9)] = inst_29149);

return statearr_29217;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29218_29251 = state_29183__$1;
(statearr_29218_29251[(1)] = (19));

} else {
var statearr_29219_29252 = state_29183__$1;
(statearr_29219_29252[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29184 === (8))){
var _ = (function (){var statearr_29220 = state_29183;
(statearr_29220[(4)] = cljs.core.rest.call(null,(state_29183[(4)])));

return statearr_29220;
})();
var state_29183__$1 = state_29183;
var ex29215 = (state_29183__$1[(2)]);
var statearr_29221_29253 = state_29183__$1;
(statearr_29221_29253[(5)] = ex29215);


var statearr_29222_29254 = state_29183__$1;
(statearr_29222_29254[(1)] = (7));

(statearr_29222_29254[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_29223 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29223[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_29223[(1)] = (1));

return statearr_29223;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_29183){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29183);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29224){var ex__2749__auto__ = e29224;
var statearr_29225_29255 = state_29183;
(statearr_29225_29255[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29183[(4)]))){
var statearr_29226_29256 = state_29183;
(statearr_29226_29256[(1)] = cljs.core.first.call(null,(state_29183[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29257 = state_29183;
state_29183 = G__29257;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_29183){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_29183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29227 = f__2769__auto__.call(null);
(statearr_29227[(6)] = c__2768__auto__);

return statearr_29227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29259 = arguments.length;
switch (G__29259) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29303){
var state_val_29304 = (state_29303[(1)]);
if((state_val_29304 === (7))){
var inst_29281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29282 = ["*"];
var inst_29283 = (new cljs.core.PersistentVector(null,1,(5),inst_29281,inst_29282,null));
var state_29303__$1 = state_29303;
var statearr_29305_29325 = state_29303__$1;
(statearr_29305_29325[(2)] = inst_29283);

(statearr_29305_29325[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (1))){
var state_29303__$1 = state_29303;
var statearr_29306_29326 = state_29303__$1;
(statearr_29306_29326[(2)] = null);

(statearr_29306_29326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (4))){
var inst_29260 = (state_29303[(2)]);
var inst_29261 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29260,"?p","Context Object",additional_params);
var state_29303__$1 = state_29303;
var statearr_29307_29327 = state_29303__$1;
(statearr_29307_29327[(2)] = inst_29261);

(statearr_29307_29327[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (6))){
var inst_29273 = cljs.core.PersistentVector.EMPTY;
var inst_29274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29275 = ["*"];
var inst_29276 = (new cljs.core.PersistentVector(null,1,(5),inst_29274,inst_29275,null));
var inst_29277 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29278 = cljs.core.concat.call(null,inst_29276,inst_29277);
var inst_29279 = cljs.core.into.call(null,inst_29273,inst_29278);
var state_29303__$1 = state_29303;
var statearr_29308_29328 = state_29303__$1;
(statearr_29308_29328[(2)] = inst_29279);

(statearr_29308_29328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (3))){
var inst_29301 = (state_29303[(2)]);
var state_29303__$1 = state_29303;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29303__$1,inst_29301);
} else {
if((state_val_29304 === (2))){
var _ = (function (){var statearr_29310 = state_29303;
(statearr_29310[(4)] = cljs.core.cons.call(null,(5),(state_29303[(4)])));

return statearr_29310;
})();
var inst_29270 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29271 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29303__$1 = (function (){var statearr_29311 = state_29303;
(statearr_29311[(7)] = inst_29271);

(statearr_29311[(8)] = inst_29270);

return statearr_29311;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29312_29329 = state_29303__$1;
(statearr_29312_29329[(1)] = (6));

} else {
var statearr_29313_29330 = state_29303__$1;
(statearr_29313_29330[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (9))){
var inst_29292 = (state_29303[(2)]);
var inst_29293 = fluree.db.util.async.throw_err.call(null,inst_29292);
var inst_29294 = cljs.core.nth.call(null,inst_29293,(0),null);
var inst_29295 = cljs.core.nth.call(null,inst_29293,(1),null);
var inst_29296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29297 = [inst_29294,inst_29295];
var inst_29298 = (new cljs.core.PersistentVector(null,2,(5),inst_29296,inst_29297,null));
var _ = (function (){var statearr_29314 = state_29303;
(statearr_29314[(4)] = cljs.core.rest.call(null,(state_29303[(4)])));

return statearr_29314;
})();
var state_29303__$1 = state_29303;
var statearr_29315_29331 = state_29303__$1;
(statearr_29315_29331[(2)] = inst_29298);

(statearr_29315_29331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (5))){
var _ = (function (){var statearr_29316 = state_29303;
(statearr_29316[(4)] = cljs.core.rest.call(null,(state_29303[(4)])));

return statearr_29316;
})();
var state_29303__$1 = state_29303;
var ex29309 = (state_29303__$1[(2)]);
var statearr_29317_29332 = state_29303__$1;
(statearr_29317_29332[(5)] = ex29309);


var statearr_29318_29333 = state_29303__$1;
(statearr_29318_29333[(1)] = (4));

(statearr_29318_29333[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29304 === (8))){
var inst_29271 = (state_29303[(7)]);
var inst_29270 = (state_29303[(8)]);
var inst_29285 = (state_29303[(2)]);
var inst_29286 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29287 = cljs.core.PersistentHashMap.EMPTY;
var inst_29288 = [inst_29285,inst_29271,inst_29287];
var inst_29289 = cljs.core.PersistentHashMap.fromArrays(inst_29286,inst_29288);
var inst_29290 = fluree.db.dbfunctions.internal.query.call(null,inst_29270,inst_29289);
var state_29303__$1 = state_29303;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29303__$1,(9),inst_29290);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_29319 = [null,null,null,null,null,null,null,null,null];
(statearr_29319[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_29319[(1)] = (1));

return statearr_29319;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_29303){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29303);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29320){var ex__2749__auto__ = e29320;
var statearr_29321_29334 = state_29303;
(statearr_29321_29334[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29303[(4)]))){
var statearr_29322_29335 = state_29303;
(statearr_29322_29335[(1)] = cljs.core.first.call(null,(state_29303[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29336 = state_29303;
state_29303 = G__29336;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_29303){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_29303);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29323 = f__2769__auto__.call(null);
(statearr_29323[(6)] = c__2768__auto__);

return statearr_29323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29380){
var state_val_29381 = (state_29380[(1)]);
if((state_val_29381 === (1))){
var state_29380__$1 = state_29380;
var statearr_29382_29396 = state_29380__$1;
(statearr_29382_29396[(2)] = null);

(statearr_29382_29396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29381 === (2))){
var _ = (function (){var statearr_29383 = state_29380;
(statearr_29383[(4)] = cljs.core.cons.call(null,(5),(state_29380[(4)])));

return statearr_29383;
})();
var inst_29347 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29349 = ["_user/_auth"];
var inst_29350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29351 = ["*"];
var inst_29352 = (new cljs.core.PersistentVector(null,1,(5),inst_29350,inst_29351,null));
var inst_29353 = [inst_29352];
var inst_29354 = cljs.core.PersistentHashMap.fromArrays(inst_29349,inst_29353);
var inst_29355 = [inst_29354];
var inst_29356 = (new cljs.core.PersistentVector(null,1,(5),inst_29348,inst_29355,null));
var inst_29357 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29358 = cljs.core.PersistentHashMap.EMPTY;
var inst_29359 = [inst_29356,inst_29357,inst_29358];
var inst_29360 = cljs.core.PersistentHashMap.fromArrays(inst_29347,inst_29359);
var inst_29361 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29362 = fluree.db.dbfunctions.internal.query.call(null,inst_29361,inst_29360);
var state_29380__$1 = state_29380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29380__$1,(6),inst_29362);
} else {
if((state_val_29381 === (3))){
var inst_29378 = (state_29380[(2)]);
var state_29380__$1 = state_29380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29380__$1,inst_29378);
} else {
if((state_val_29381 === (4))){
var inst_29337 = (state_29380[(2)]);
var inst_29338 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29337,"?user_id-from-auth","Context Object");
var state_29380__$1 = state_29380;
var statearr_29385_29397 = state_29380__$1;
(statearr_29385_29397[(2)] = inst_29338);

(statearr_29385_29397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29381 === (5))){
var _ = (function (){var statearr_29386 = state_29380;
(statearr_29386[(4)] = cljs.core.rest.call(null,(state_29380[(4)])));

return statearr_29386;
})();
var state_29380__$1 = state_29380;
var ex29384 = (state_29380__$1[(2)]);
var statearr_29387_29398 = state_29380__$1;
(statearr_29387_29398[(5)] = ex29384);


var statearr_29388_29399 = state_29380__$1;
(statearr_29388_29399[(1)] = (4));

(statearr_29388_29399[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29381 === (6))){
var inst_29364 = (state_29380[(2)]);
var inst_29365 = fluree.db.util.async.throw_err.call(null,inst_29364);
var inst_29366 = cljs.core.nth.call(null,inst_29365,(0),null);
var inst_29367 = cljs.core.nth.call(null,inst_29365,(1),null);
var inst_29368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29369 = ["_user/_auth","_id"];
var inst_29370 = (new cljs.core.PersistentVector(null,2,(5),inst_29368,inst_29369,null));
var inst_29371 = fluree.db.dbfunctions.internal.get_in.call(null,inst_29366,inst_29370);
var inst_29372 = cljs.core.first.call(null,inst_29371);
var inst_29373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29374 = [inst_29372,inst_29367];
var inst_29375 = (new cljs.core.PersistentVector(null,2,(5),inst_29373,inst_29374,null));
var _ = (function (){var statearr_29389 = state_29380;
(statearr_29389[(4)] = cljs.core.rest.call(null,(state_29380[(4)])));

return statearr_29389;
})();
var state_29380__$1 = state_29380;
var statearr_29390_29400 = state_29380__$1;
(statearr_29390_29400[(2)] = inst_29375);

(statearr_29390_29400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_29391 = [null,null,null,null,null,null,null];
(statearr_29391[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_29391[(1)] = (1));

return statearr_29391;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_29380){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29392){var ex__2749__auto__ = e29392;
var statearr_29393_29401 = state_29380;
(statearr_29393_29401[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29380[(4)]))){
var statearr_29394_29402 = state_29380;
(statearr_29394_29402[(1)] = cljs.core.first.call(null,(state_29380[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29403 = state_29380;
state_29380 = G__29403;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_29380){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_29380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29395 = f__2769__auto__.call(null);
(statearr_29395[(6)] = c__2768__auto__);

return statearr_29395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29420){
var state_val_29421 = (state_29420[(1)]);
if((state_val_29421 === (1))){
var state_29420__$1 = state_29420;
var statearr_29422_29436 = state_29420__$1;
(statearr_29422_29436[(2)] = null);

(statearr_29422_29436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29421 === (2))){
var _ = (function (){var statearr_29423 = state_29420;
(statearr_29423[(4)] = cljs.core.cons.call(null,(5),(state_29420[(4)])));

return statearr_29423;
})();
var inst_29410 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29411 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29412 = fluree.db.dbproto._subid.call(null,inst_29411,inst_29410);
var state_29420__$1 = state_29420;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29420__$1,(6),inst_29412);
} else {
if((state_val_29421 === (3))){
var inst_29418 = (state_29420[(2)]);
var state_29420__$1 = state_29420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29420__$1,inst_29418);
} else {
if((state_val_29421 === (4))){
var inst_29404 = (state_29420[(2)]);
var state_29420__$1 = state_29420;
var statearr_29425_29437 = state_29420__$1;
(statearr_29425_29437[(2)] = inst_29404);

(statearr_29425_29437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29421 === (5))){
var _ = (function (){var statearr_29426 = state_29420;
(statearr_29426[(4)] = cljs.core.rest.call(null,(state_29420[(4)])));

return statearr_29426;
})();
var state_29420__$1 = state_29420;
var ex29424 = (state_29420__$1[(2)]);
var statearr_29427_29438 = state_29420__$1;
(statearr_29427_29438[(5)] = ex29424);


if((ex29424 instanceof Error)){
var statearr_29428_29439 = state_29420__$1;
(statearr_29428_29439[(1)] = (4));

(statearr_29428_29439[(5)] = null);

} else {
throw ex29424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29421 === (6))){
var inst_29414 = (state_29420[(2)]);
var inst_29415 = fluree.db.util.async.throw_err.call(null,inst_29414);
var _ = (function (){var statearr_29429 = state_29420;
(statearr_29429[(4)] = cljs.core.rest.call(null,(state_29420[(4)])));

return statearr_29429;
})();
var state_29420__$1 = state_29420;
var statearr_29430_29440 = state_29420__$1;
(statearr_29430_29440[(2)] = inst_29415);

(statearr_29430_29440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_29431 = [null,null,null,null,null,null,null];
(statearr_29431[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_29431[(1)] = (1));

return statearr_29431;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_29420){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29432){var ex__2749__auto__ = e29432;
var statearr_29433_29441 = state_29420;
(statearr_29433_29441[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29420[(4)]))){
var statearr_29434_29442 = state_29420;
(statearr_29434_29442[(1)] = cljs.core.first.call(null,(state_29420[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29443 = state_29420;
state_29420 = G__29443;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_29420){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_29420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29435 = f__2769__auto__.call(null);
(statearr_29435[(6)] = c__2768__auto__);

return statearr_29435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29444_SHARP_){
return p1__29444_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29445_SHARP_){
return p1__29445_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29446){var e = e29446;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29447_SHARP_){
return p1__29447_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29448_SHARP_){
return p1__29448_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29449){var e = e29449;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29450){var e = e29450;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29530){
var state_val_29531 = (state_29530[(1)]);
if((state_val_29531 === (7))){
var inst_29469 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29470 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29471 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29472 = cljs.core.PersistentHashMap.fromArrays(inst_29470,inst_29471);
var inst_29473 = cljs.core.ex_info.call(null,inst_29469,inst_29472);
var inst_29474 = (function(){throw inst_29473})();
var state_29530__$1 = state_29530;
var statearr_29532_29567 = state_29530__$1;
(statearr_29532_29567[(2)] = inst_29474);

(statearr_29532_29567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (1))){
var state_29530__$1 = state_29530;
var statearr_29533_29568 = state_29530__$1;
(statearr_29533_29568[(2)] = null);

(statearr_29533_29568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (4))){
var inst_29451 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
var statearr_29534_29569 = state_29530__$1;
(statearr_29534_29569[(2)] = inst_29451);

(statearr_29534_29569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (15))){
var inst_29514 = (state_29530[(7)]);
var inst_29510 = (state_29530[(2)]);
var inst_29511 = fluree.db.util.async.throw_err.call(null,inst_29510);
var inst_29512 = cljs.core.nth.call(null,inst_29511,(0),null);
var inst_29513 = cljs.core.nth.call(null,inst_29511,(1),null);
var inst_29514__$1 = cljs.core.first.call(null,inst_29512);
var inst_29515 = cljs.core._EQ_.call(null,inst_29514__$1,compare_val);
var state_29530__$1 = (function (){var statearr_29535 = state_29530;
(statearr_29535[(8)] = inst_29513);

(statearr_29535[(7)] = inst_29514__$1);

return statearr_29535;
})();
if(inst_29515){
var statearr_29536_29570 = state_29530__$1;
(statearr_29536_29570[(1)] = (16));

} else {
var statearr_29537_29571 = state_29530__$1;
(statearr_29537_29571[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (13))){
var state_29530__$1 = state_29530;
var statearr_29538_29572 = state_29530__$1;
(statearr_29538_29572[(2)] = null);

(statearr_29538_29572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (6))){
var state_29530__$1 = state_29530;
var statearr_29539_29573 = state_29530__$1;
(statearr_29539_29573[(2)] = null);

(statearr_29539_29573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (17))){
var inst_29514 = (state_29530[(7)]);
var inst_29518 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29514)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29519 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29520 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29521 = cljs.core.PersistentHashMap.fromArrays(inst_29519,inst_29520);
var inst_29522 = cljs.core.ex_info.call(null,inst_29518,inst_29521);
var inst_29523 = (function(){throw inst_29522})();
var state_29530__$1 = state_29530;
var statearr_29540_29574 = state_29530__$1;
(statearr_29540_29574[(2)] = inst_29523);

(statearr_29540_29574[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (3))){
var inst_29528 = (state_29530[(2)]);
var state_29530__$1 = state_29530;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29530__$1,inst_29528);
} else {
if((state_val_29531 === (12))){
var inst_29466 = (state_29530[(9)]);
var inst_29489 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29466);
var inst_29490 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29491 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29492 = cljs.core.PersistentHashMap.fromArrays(inst_29490,inst_29491);
var inst_29493 = cljs.core.ex_info.call(null,inst_29489,inst_29492);
var inst_29494 = (function(){throw inst_29493})();
var state_29530__$1 = state_29530;
var statearr_29541_29575 = state_29530__$1;
(statearr_29541_29575[(2)] = inst_29494);

(statearr_29541_29575[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (2))){
var inst_29465 = (state_29530[(10)]);
var inst_29463 = (state_29530[(11)]);
var inst_29464 = (state_29530[(12)]);
var _ = (function (){var statearr_29542 = state_29530;
(statearr_29542[(4)] = cljs.core.cons.call(null,(5),(state_29530[(4)])));

return statearr_29542;
})();
var inst_29461 = _QMARK_ctx;
var inst_29462 = cljs.core.__destructure_map.call(null,inst_29461);
var inst_29463__$1 = cljs.core.get.call(null,inst_29462,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29464__$1 = cljs.core.get.call(null,inst_29462,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29465__$1 = cljs.core.get.call(null,inst_29462,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29466 = fluree.db.dbproto._p_prop.call(null,inst_29465__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29464__$1);
var state_29530__$1 = (function (){var statearr_29543 = state_29530;
(statearr_29543[(10)] = inst_29465__$1);

(statearr_29543[(11)] = inst_29463__$1);

(statearr_29543[(12)] = inst_29464__$1);

(statearr_29543[(9)] = inst_29466);

return statearr_29543;
})();
if(cljs.core.truth_(inst_29463__$1)){
var statearr_29544_29576 = state_29530__$1;
(statearr_29544_29576[(1)] = (6));

} else {
var statearr_29545_29577 = state_29530__$1;
(statearr_29545_29577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (11))){
var inst_29465 = (state_29530[(10)]);
var inst_29464 = (state_29530[(12)]);
var inst_29486 = (state_29530[(2)]);
var inst_29487 = fluree.db.dbproto._p_prop.call(null,inst_29465,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29464);
var state_29530__$1 = (function (){var statearr_29547 = state_29530;
(statearr_29547[(13)] = inst_29486);

return statearr_29547;
})();
if(cljs.core.truth_(inst_29487)){
var statearr_29548_29578 = state_29530__$1;
(statearr_29548_29578[(1)] = (12));

} else {
var statearr_29549_29579 = state_29530__$1;
(statearr_29549_29579[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (9))){
var state_29530__$1 = state_29530;
var statearr_29550_29580 = state_29530__$1;
(statearr_29550_29580[(2)] = null);

(statearr_29550_29580[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (5))){
var _ = (function (){var statearr_29551 = state_29530;
(statearr_29551[(4)] = cljs.core.rest.call(null,(state_29530[(4)])));

return statearr_29551;
})();
var state_29530__$1 = state_29530;
var ex29546 = (state_29530__$1[(2)]);
var statearr_29552_29581 = state_29530__$1;
(statearr_29552_29581[(5)] = ex29546);


if((ex29546 instanceof Error)){
var statearr_29553_29582 = state_29530__$1;
(statearr_29553_29582[(1)] = (4));

(statearr_29553_29582[(5)] = null);

} else {
throw ex29546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (14))){
var inst_29465 = (state_29530[(10)]);
var inst_29463 = (state_29530[(11)]);
var inst_29466 = (state_29530[(9)]);
var inst_29497 = (state_29530[(2)]);
var inst_29498 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29501 = [inst_29463,inst_29466,"?current-val"];
var inst_29502 = (new cljs.core.PersistentVector(null,3,(5),inst_29500,inst_29501,null));
var inst_29503 = [inst_29502];
var inst_29504 = (new cljs.core.PersistentVector(null,1,(5),inst_29499,inst_29503,null));
var inst_29505 = cljs.core.PersistentHashMap.EMPTY;
var inst_29506 = ["?current-val",inst_29504,inst_29505];
var inst_29507 = cljs.core.PersistentHashMap.fromArrays(inst_29498,inst_29506);
var inst_29508 = fluree.db.dbfunctions.internal.query.call(null,inst_29465,inst_29507);
var state_29530__$1 = (function (){var statearr_29554 = state_29530;
(statearr_29554[(14)] = inst_29497);

return statearr_29554;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29530__$1,(15),inst_29508);
} else {
if((state_val_29531 === (16))){
var state_29530__$1 = state_29530;
var statearr_29555_29583 = state_29530__$1;
(statearr_29555_29583[(2)] = new_val);

(statearr_29555_29583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (10))){
var inst_29479 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29480 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29481 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29482 = cljs.core.PersistentHashMap.fromArrays(inst_29480,inst_29481);
var inst_29483 = cljs.core.ex_info.call(null,inst_29479,inst_29482);
var inst_29484 = (function(){throw inst_29483})();
var state_29530__$1 = state_29530;
var statearr_29556_29584 = state_29530__$1;
(statearr_29556_29584[(2)] = inst_29484);

(statearr_29556_29584[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (18))){
var inst_29525 = (state_29530[(2)]);
var _ = (function (){var statearr_29557 = state_29530;
(statearr_29557[(4)] = cljs.core.rest.call(null,(state_29530[(4)])));

return statearr_29557;
})();
var state_29530__$1 = state_29530;
var statearr_29558_29585 = state_29530__$1;
(statearr_29558_29585[(2)] = inst_29525);

(statearr_29558_29585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29531 === (8))){
var inst_29466 = (state_29530[(9)]);
var inst_29476 = (state_29530[(2)]);
var state_29530__$1 = (function (){var statearr_29559 = state_29530;
(statearr_29559[(15)] = inst_29476);

return statearr_29559;
})();
if(cljs.core.truth_(inst_29466)){
var statearr_29560_29586 = state_29530__$1;
(statearr_29560_29586[(1)] = (9));

} else {
var statearr_29561_29587 = state_29530__$1;
(statearr_29561_29587[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_29562 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29562[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_29562[(1)] = (1));

return statearr_29562;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_29530){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29530);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29563){var ex__2749__auto__ = e29563;
var statearr_29564_29588 = state_29530;
(statearr_29564_29588[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29530[(4)]))){
var statearr_29565_29589 = state_29530;
(statearr_29565_29589[(1)] = cljs.core.first.call(null,(state_29530[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29590 = state_29530;
state_29530 = G__29590;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_29530){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_29530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29566 = f__2769__auto__.call(null);
(statearr_29566[(6)] = c__2768__auto__);

return statearr_29566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
