// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__62222 = arguments.length;
switch (G__62222) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62264){
var state_val_62265 = (state_62264[(1)]);
if((state_val_62265 === (7))){
var inst_62234 = typeof user === 'string';
var state_62264__$1 = state_62264;
if(cljs.core.truth_(inst_62234)){
var statearr_62266_62295 = state_62264__$1;
(statearr_62266_62295[(1)] = (9));

} else {
var statearr_62267_62296 = state_62264__$1;
(statearr_62267_62296[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (1))){
var state_62264__$1 = state_62264;
var statearr_62268_62297 = state_62264__$1;
(statearr_62268_62297[(2)] = null);

(statearr_62268_62297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (4))){
var inst_62223 = (state_62264[(2)]);
var inst_62224 = fluree.db.util.log.error.call(null,inst_62223);
var inst_62225 = reject.call(null,inst_62223);
var state_62264__$1 = (function (){var statearr_62269 = state_62264;
(statearr_62269[(7)] = inst_62224);

return statearr_62269;
})();
var statearr_62270_62298 = state_62264__$1;
(statearr_62270_62298[(2)] = inst_62225);

(statearr_62270_62298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (15))){
var inst_62253 = (state_62264[(2)]);
var inst_62254 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_62253);
var inst_62255 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62256 = cljs.core.constantly.call(null,inst_62254);
var inst_62257 = cljs.core.swap_BANG_.call(null,inst_62255,inst_62256);
var inst_62258 = fluree.db.connection.add_token.call(null,conn,inst_62254);
var inst_62259 = resolve.call(null,inst_62253);
var _ = (function (){var statearr_62271 = state_62264;
(statearr_62271[(4)] = cljs.core.rest.call(null,(state_62264[(4)])));

return statearr_62271;
})();
var state_62264__$1 = (function (){var statearr_62272 = state_62264;
(statearr_62272[(8)] = inst_62258);

(statearr_62272[(9)] = inst_62257);

return statearr_62272;
})();
var statearr_62273_62299 = state_62264__$1;
(statearr_62273_62299[(2)] = inst_62259);

(statearr_62273_62299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (13))){
var state_62264__$1 = state_62264;
var statearr_62274_62300 = state_62264__$1;
(statearr_62274_62300[(2)] = null);

(statearr_62274_62300[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (6))){
var state_62264__$1 = state_62264;
var statearr_62275_62301 = state_62264__$1;
(statearr_62275_62301[(2)] = user);

(statearr_62275_62301[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (3))){
var inst_62262 = (state_62264[(2)]);
var state_62264__$1 = state_62264;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62264__$1,inst_62262);
} else {
if((state_val_62265 === (12))){
var state_62264__$1 = state_62264;
var statearr_62276_62302 = state_62264__$1;
(statearr_62276_62302[(2)] = user);

(statearr_62276_62302[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (2))){
var _ = (function (){var statearr_62277 = state_62264;
(statearr_62277[(4)] = cljs.core.cons.call(null,(5),(state_62264[(4)])));

return statearr_62277;
})();
var inst_62231 = typeof user === 'number';
var state_62264__$1 = state_62264;
if(cljs.core.truth_(inst_62231)){
var statearr_62278_62303 = state_62264__$1;
(statearr_62278_62303[(1)] = (6));

} else {
var statearr_62279_62304 = state_62264__$1;
(statearr_62279_62304[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (11))){
var inst_62245 = (state_62264[(2)]);
var state_62264__$1 = state_62264;
var statearr_62281_62305 = state_62264__$1;
(statearr_62281_62305[(2)] = inst_62245);

(statearr_62281_62305[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (9))){
var inst_62236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62237 = ["_user/username",user];
var inst_62238 = (new cljs.core.PersistentVector(null,2,(5),inst_62236,inst_62237,null));
var state_62264__$1 = state_62264;
var statearr_62282_62306 = state_62264__$1;
(statearr_62282_62306[(2)] = inst_62238);

(statearr_62282_62306[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (5))){
var _ = (function (){var statearr_62283 = state_62264;
(statearr_62283[(4)] = cljs.core.rest.call(null,(state_62264[(4)])));

return statearr_62283;
})();
var state_62264__$1 = state_62264;
var ex62280 = (state_62264__$1[(2)]);
var statearr_62284_62307 = state_62264__$1;
(statearr_62284_62307[(5)] = ex62280);


var statearr_62285_62308 = state_62264__$1;
(statearr_62285_62308[(1)] = (4));

(statearr_62285_62308[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (14))){
var inst_62243 = (state_62264[(2)]);
var state_62264__$1 = state_62264;
var statearr_62286_62309 = state_62264__$1;
(statearr_62286_62309[(2)] = inst_62243);

(statearr_62286_62309[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (10))){
var state_62264__$1 = state_62264;
var statearr_62287_62310 = state_62264__$1;
(statearr_62287_62310[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62265 === (8))){
var inst_62247 = (state_62264[(2)]);
var inst_62248 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_62249 = [account,inst_62247,password,expireSeconds,syncTo];
var inst_62250 = cljs.core.PersistentHashMap.fromArrays(inst_62248,inst_62249);
var inst_62251 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_62250);
var state_62264__$1 = state_62264;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62264__$1,(15),inst_62251);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_62289 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62289[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_62289[(1)] = (1));

return statearr_62289;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_62264){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62264);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62290){var ex__2749__auto__ = e62290;
var statearr_62291_62311 = state_62264;
(statearr_62291_62311[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62264[(4)]))){
var statearr_62292_62312 = state_62264;
(statearr_62292_62312[(1)] = cljs.core.first.call(null,(state_62264[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62313 = state_62264;
state_62264 = G__62313;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_62264){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_62264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62293 = f__2769__auto__.call(null);
(statearr_62293[(6)] = c__2768__auto__);

return statearr_62293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__62315 = arguments.length;
switch (G__62315) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62324){
var state_val_62325 = (state_62324[(1)]);
if((state_val_62325 === (1))){
var inst_62316 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62318 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_62319 = (new cljs.core.PersistentVector(null,4,(5),inst_62317,inst_62318,null));
var inst_62320 = cljs.core.async.put_BANG_.call(null,inst_62316,inst_62319);
var inst_62321 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__62326 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__62327 = null;
var count__62328 = (0);
var i__62329 = (0);
while(true){
if((i__62329 < count__62328)){
var k = cljs.core._nth.call(null,chunk__62327,i__62329);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__62337 = seq__62326;
var G__62338 = chunk__62327;
var G__62339 = count__62328;
var G__62340 = (i__62329 + (1));
seq__62326 = G__62337;
chunk__62327 = G__62338;
count__62328 = G__62339;
i__62329 = G__62340;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__62326);
if(temp__5753__auto__){
var seq__62326__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62326__$1)){
var c__4679__auto__ = cljs.core.chunk_first.call(null,seq__62326__$1);
var G__62341 = cljs.core.chunk_rest.call(null,seq__62326__$1);
var G__62342 = c__4679__auto__;
var G__62343 = cljs.core.count.call(null,c__4679__auto__);
var G__62344 = (0);
seq__62326 = G__62341;
chunk__62327 = G__62342;
count__62328 = G__62343;
i__62329 = G__62344;
continue;
} else {
var k = cljs.core.first.call(null,seq__62326__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__62345 = cljs.core.next.call(null,seq__62326__$1);
var G__62346 = null;
var G__62347 = (0);
var G__62348 = (0);
seq__62326 = G__62345;
chunk__62327 = G__62346;
count__62328 = G__62347;
i__62329 = G__62348;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_62322 = cljs.core.async.take_BANG_.call(null,pc,inst_62321);
var state_62324__$1 = (function (){var statearr_62330 = state_62324;
(statearr_62330[(7)] = inst_62320);

return statearr_62330;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62324__$1,inst_62322);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_62331 = [null,null,null,null,null,null,null,null];
(statearr_62331[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_62331[(1)] = (1));

return statearr_62331;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_62324){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62332){var ex__2749__auto__ = e62332;
var statearr_62333_62349 = state_62324;
(statearr_62333_62349[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62324[(4)]))){
var statearr_62334_62350 = state_62324;
(statearr_62334_62350[(1)] = cljs.core.first.call(null,(state_62324[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62351 = state_62324;
state_62324 = G__62351;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_62324){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_62324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62335 = f__2769__auto__.call(null);
(statearr_62335[(6)] = c__2768__auto__);

return statearr_62335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__62353 = arguments.length;
switch (G__62353) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62387){
var state_val_62388 = (state_62387[(1)]);
if((state_val_62388 === (1))){
var state_62387__$1 = state_62387;
var statearr_62389_62410 = state_62387__$1;
(statearr_62389_62410[(2)] = null);

(statearr_62389_62410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62388 === (2))){
var _ = (function (){var statearr_62390 = state_62387;
(statearr_62390[(4)] = cljs.core.cons.call(null,(5),(state_62387[(4)])));

return statearr_62390;
})();
var inst_62362 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_62363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62364 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_62365 = (new cljs.core.PersistentVector(null,1,(5),inst_62363,inst_62364,null));
var inst_62366 = cljs.core.PersistentHashMap.EMPTY;
var inst_62367 = cljs.core.atom.call(null,inst_62366);
var inst_62368 = cljs.core.assoc_in.call(null,inst_62362,inst_62365,inst_62367);
var inst_62369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62370 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62371 = (new cljs.core.PersistentVector(null,1,(5),inst_62369,inst_62370,null));
var inst_62372 = cljs.core.PersistentHashMap.EMPTY;
var inst_62373 = cljs.core.atom.call(null,inst_62372);
var inst_62374 = cljs.core.assoc_in.call(null,inst_62368,inst_62371,inst_62373);
var inst_62375 = cljs.core.async.promise_chan.call(null);
var inst_62376 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_62374);
var inst_62377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62378 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_62375,null];
var inst_62379 = (new cljs.core.PersistentVector(null,4,(5),inst_62377,inst_62378,null));
var inst_62380 = cljs.core.async.put_BANG_.call(null,inst_62376,inst_62379);
var inst_62381 = (function (){var conn = inst_62374;
var pc = inst_62375;
return (function (x){
if((x == null)){
} else {
var seq__62391_62411 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__62392_62412 = null;
var count__62393_62413 = (0);
var i__62394_62414 = (0);
while(true){
if((i__62394_62414 < count__62393_62413)){
var k_62415 = cljs.core._nth.call(null,chunk__62392_62412,i__62394_62414);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62415], null),cljs.core.get.call(null,x,k_62415,null));


var G__62416 = seq__62391_62411;
var G__62417 = chunk__62392_62412;
var G__62418 = count__62393_62413;
var G__62419 = (i__62394_62414 + (1));
seq__62391_62411 = G__62416;
chunk__62392_62412 = G__62417;
count__62393_62413 = G__62418;
i__62394_62414 = G__62419;
continue;
} else {
var temp__5753__auto___62420 = cljs.core.seq.call(null,seq__62391_62411);
if(temp__5753__auto___62420){
var seq__62391_62421__$1 = temp__5753__auto___62420;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__62391_62421__$1)){
var c__4679__auto___62422 = cljs.core.chunk_first.call(null,seq__62391_62421__$1);
var G__62423 = cljs.core.chunk_rest.call(null,seq__62391_62421__$1);
var G__62424 = c__4679__auto___62422;
var G__62425 = cljs.core.count.call(null,c__4679__auto___62422);
var G__62426 = (0);
seq__62391_62411 = G__62423;
chunk__62392_62412 = G__62424;
count__62393_62413 = G__62425;
i__62394_62414 = G__62426;
continue;
} else {
var k_62427 = cljs.core.first.call(null,seq__62391_62421__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_62427], null),cljs.core.get.call(null,x,k_62427,null));


var G__62428 = cljs.core.next.call(null,seq__62391_62421__$1);
var G__62429 = null;
var G__62430 = (0);
var G__62431 = (0);
seq__62391_62411 = G__62428;
chunk__62392_62412 = G__62429;
count__62393_62413 = G__62430;
i__62394_62414 = G__62431;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_62382 = cljs.core.async.take_BANG_.call(null,inst_62375,inst_62381);
var ___$1 = (function (){var statearr_62395 = state_62387;
(statearr_62395[(4)] = cljs.core.rest.call(null,(state_62387[(4)])));

return statearr_62395;
})();
var state_62387__$1 = (function (){var statearr_62396 = state_62387;
(statearr_62396[(7)] = inst_62380);

return statearr_62396;
})();
var statearr_62397_62432 = state_62387__$1;
(statearr_62397_62432[(2)] = inst_62382);

(statearr_62397_62432[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62388 === (3))){
var inst_62385 = (state_62387[(2)]);
var state_62387__$1 = state_62387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62387__$1,inst_62385);
} else {
if((state_val_62388 === (4))){
var inst_62354 = (state_62387[(2)]);
var inst_62355 = fluree.db.util.log.error.call(null,inst_62354);
var inst_62356 = reject.call(null,inst_62354);
var state_62387__$1 = (function (){var statearr_62399 = state_62387;
(statearr_62399[(8)] = inst_62355);

return statearr_62399;
})();
var statearr_62400_62433 = state_62387__$1;
(statearr_62400_62433[(2)] = inst_62356);

(statearr_62400_62433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62388 === (5))){
var _ = (function (){var statearr_62401 = state_62387;
(statearr_62401[(4)] = cljs.core.rest.call(null,(state_62387[(4)])));

return statearr_62401;
})();
var state_62387__$1 = state_62387;
var ex62398 = (state_62387__$1[(2)]);
var statearr_62402_62434 = state_62387__$1;
(statearr_62402_62434[(5)] = ex62398);


var statearr_62403_62435 = state_62387__$1;
(statearr_62403_62435[(1)] = (4));

(statearr_62403_62435[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_62404 = [null,null,null,null,null,null,null,null,null];
(statearr_62404[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_62404[(1)] = (1));

return statearr_62404;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_62387){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62405){var ex__2749__auto__ = e62405;
var statearr_62406_62436 = state_62387;
(statearr_62406_62436[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62387[(4)]))){
var statearr_62407_62437 = state_62387;
(statearr_62407_62437[(1)] = cljs.core.first.call(null,(state_62387[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62438 = state_62387;
state_62387 = G__62438;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_62387){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_62387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62408 = f__2769__auto__.call(null);
(statearr_62408[(6)] = c__2768__auto__);

return statearr_62408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__62440 = arguments.length;
switch (G__62440) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__62442 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__62442,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__62442,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__62445 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__62445,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__62445,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62498){
var state_val_62499 = (state_62498[(1)]);
if((state_val_62499 === (7))){
var inst_62459 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62460 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62461 = cljs.core.PersistentHashMap.fromArrays(inst_62459,inst_62460);
var inst_62462 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62461);
var inst_62463 = (function(){throw inst_62462})();
var state_62498__$1 = state_62498;
var statearr_62500_62529 = state_62498__$1;
(statearr_62500_62529[(2)] = inst_62463);

(statearr_62500_62529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (1))){
var state_62498__$1 = state_62498;
var statearr_62501_62530 = state_62498__$1;
(statearr_62501_62530[(2)] = null);

(statearr_62501_62530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (4))){
var inst_62448 = (state_62498[(2)]);
var inst_62449 = cljs.core.clj__GT_js.call(null,inst_62448);
var inst_62450 = reject.call(null,inst_62449);
var state_62498__$1 = state_62498;
var statearr_62502_62531 = state_62498__$1;
(statearr_62502_62531[(2)] = inst_62450);

(statearr_62502_62531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (13))){
var inst_62477 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62478 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62479 = cljs.core.PersistentHashMap.fromArrays(inst_62477,inst_62478);
var inst_62480 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_62479);
var inst_62481 = (function(){throw inst_62480})();
var state_62498__$1 = state_62498;
var statearr_62503_62532 = state_62498__$1;
(statearr_62503_62532[(2)] = inst_62481);

(statearr_62503_62532[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (6))){
var state_62498__$1 = state_62498;
var statearr_62504_62533 = state_62498__$1;
(statearr_62504_62533[(2)] = null);

(statearr_62504_62533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (3))){
var inst_62496 = (state_62498[(2)]);
var state_62498__$1 = state_62498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62498__$1,inst_62496);
} else {
if((state_val_62499 === (12))){
var state_62498__$1 = state_62498;
var statearr_62505_62534 = state_62498__$1;
(statearr_62505_62534[(2)] = null);

(statearr_62505_62534[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (2))){
var _ = (function (){var statearr_62506 = state_62498;
(statearr_62506[(4)] = cljs.core.cons.call(null,(5),(state_62498[(4)])));

return statearr_62506;
})();
var inst_62456 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62498__$1 = state_62498;
if(cljs.core.truth_(inst_62456)){
var statearr_62507_62535 = state_62498__$1;
(statearr_62507_62535[(1)] = (6));

} else {
var statearr_62508_62536 = state_62498__$1;
(statearr_62508_62536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (11))){
var inst_62474 = (state_62498[(2)]);
var state_62498__$1 = (function (){var statearr_62510 = state_62498;
(statearr_62510[(7)] = inst_62474);

return statearr_62510;
})();
if(cljs.core.truth_(password)){
var statearr_62511_62537 = state_62498__$1;
(statearr_62511_62537[(1)] = (12));

} else {
var statearr_62512_62538 = state_62498__$1;
(statearr_62512_62538[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (9))){
var state_62498__$1 = state_62498;
var statearr_62513_62539 = state_62498__$1;
(statearr_62513_62539[(2)] = null);

(statearr_62513_62539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (5))){
var _ = (function (){var statearr_62514 = state_62498;
(statearr_62514[(4)] = cljs.core.rest.call(null,(state_62498[(4)])));

return statearr_62514;
})();
var state_62498__$1 = state_62498;
var ex62509 = (state_62498__$1[(2)]);
var statearr_62515_62540 = state_62498__$1;
(statearr_62515_62540[(5)] = ex62509);


var statearr_62516_62541 = state_62498__$1;
(statearr_62516_62541[(1)] = (4));

(statearr_62516_62541[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (14))){
var inst_62483 = (state_62498[(2)]);
var inst_62484 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_62485 = fluree.db.util.core.without_nils.call(null,inst_62484);
var inst_62486 = cljs.core.async.promise_chan.call(null);
var inst_62487 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62488 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62489 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_62485,inst_62486,null];
var inst_62490 = (new cljs.core.PersistentVector(null,4,(5),inst_62488,inst_62489,null));
var inst_62491 = cljs.core.async.put_BANG_.call(null,inst_62487,inst_62490);
var inst_62492 = (function (){var _ = inst_62483;
var data = inst_62485;
var pc = inst_62486;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_62493 = cljs.core.async.take_BANG_.call(null,inst_62486,inst_62492);
var _ = (function (){var statearr_62517 = state_62498;
(statearr_62517[(4)] = cljs.core.rest.call(null,(state_62498[(4)])));

return statearr_62517;
})();
var state_62498__$1 = (function (){var statearr_62518 = state_62498;
(statearr_62518[(8)] = inst_62491);

return statearr_62518;
})();
var statearr_62519_62542 = state_62498__$1;
(statearr_62519_62542[(2)] = inst_62493);

(statearr_62519_62542[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (10))){
var inst_62468 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62469 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62470 = cljs.core.PersistentHashMap.fromArrays(inst_62468,inst_62469);
var inst_62471 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_62470);
var inst_62472 = (function(){throw inst_62471})();
var state_62498__$1 = state_62498;
var statearr_62520_62543 = state_62498__$1;
(statearr_62520_62543[(2)] = inst_62472);

(statearr_62520_62543[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62499 === (8))){
var inst_62465 = (state_62498[(2)]);
var state_62498__$1 = (function (){var statearr_62521 = state_62498;
(statearr_62521[(9)] = inst_62465);

return statearr_62521;
})();
if(cljs.core.truth_(ledger)){
var statearr_62522_62544 = state_62498__$1;
(statearr_62522_62544[(1)] = (9));

} else {
var statearr_62523_62545 = state_62498__$1;
(statearr_62523_62545[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0 = (function (){
var statearr_62524 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62524[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2746__auto__);

(statearr_62524[(1)] = (1));

return statearr_62524;
});
var fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1 = (function (state_62498){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62525){var ex__2749__auto__ = e62525;
var statearr_62526_62546 = state_62498;
(statearr_62526_62546[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62498[(4)]))){
var statearr_62527_62547 = state_62498;
(statearr_62527_62547[(1)] = cljs.core.first.call(null,(state_62498[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62548 = state_62498;
state_62498 = G__62548;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__ = function(state_62498){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1.call(this,state_62498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2746__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62528 = f__2769__auto__.call(null);
(statearr_62528[(6)] = c__2768__auto__);

return statearr_62528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__62550 = arguments.length;
switch (G__62550) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62617){
var state_val_62618 = (state_62617[(1)]);
if((state_val_62618 === (7))){
var inst_62562 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62563 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62564 = cljs.core.PersistentHashMap.fromArrays(inst_62562,inst_62563);
var inst_62565 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62564);
var inst_62566 = (function(){throw inst_62565})();
var state_62617__$1 = state_62617;
var statearr_62619_62658 = state_62617__$1;
(statearr_62619_62658[(2)] = inst_62566);

(statearr_62619_62658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (20))){
var inst_62600 = (state_62617[(2)]);
var inst_62601 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62602 = [ledger,password,user,auth,expire];
var inst_62603 = cljs.core.PersistentHashMap.fromArrays(inst_62601,inst_62602);
var inst_62604 = fluree.db.util.core.without_nils.call(null,inst_62603);
var inst_62605 = cljs.core.async.promise_chan.call(null);
var inst_62606 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62608 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_62604,inst_62605,null];
var inst_62609 = (new cljs.core.PersistentVector(null,4,(5),inst_62607,inst_62608,null));
var inst_62610 = cljs.core.async.put_BANG_.call(null,inst_62606,inst_62609);
var inst_62611 = (function (){var _ = inst_62600;
var data = inst_62604;
var pc = inst_62605;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_62612 = cljs.core.async.take_BANG_.call(null,inst_62605,inst_62611);
var _ = (function (){var statearr_62620 = state_62617;
(statearr_62620[(4)] = cljs.core.rest.call(null,(state_62617[(4)])));

return statearr_62620;
})();
var state_62617__$1 = (function (){var statearr_62621 = state_62617;
(statearr_62621[(7)] = inst_62610);

return statearr_62621;
})();
var statearr_62622_62659 = state_62617__$1;
(statearr_62622_62659[(2)] = inst_62612);

(statearr_62622_62659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (1))){
var state_62617__$1 = state_62617;
var statearr_62623_62660 = state_62617__$1;
(statearr_62623_62660[(2)] = null);

(statearr_62623_62660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (4))){
var inst_62551 = (state_62617[(2)]);
var inst_62552 = cljs.core.clj__GT_js.call(null,inst_62551);
var inst_62553 = reject.call(null,inst_62552);
var state_62617__$1 = state_62617;
var statearr_62624_62661 = state_62617__$1;
(statearr_62624_62661[(2)] = inst_62553);

(statearr_62624_62661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (15))){
var inst_62587 = (state_62617[(8)]);
var state_62617__$1 = state_62617;
var statearr_62625_62662 = state_62617__$1;
(statearr_62625_62662[(2)] = inst_62587);

(statearr_62625_62662[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (13))){
var inst_62580 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62581 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62582 = cljs.core.PersistentHashMap.fromArrays(inst_62580,inst_62581);
var inst_62583 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_62582);
var inst_62584 = (function(){throw inst_62583})();
var state_62617__$1 = state_62617;
var statearr_62626_62663 = state_62617__$1;
(statearr_62626_62663[(2)] = inst_62584);

(statearr_62626_62663[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (6))){
var state_62617__$1 = state_62617;
var statearr_62627_62664 = state_62617__$1;
(statearr_62627_62664[(2)] = null);

(statearr_62627_62664[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (17))){
var inst_62591 = (state_62617[(2)]);
var state_62617__$1 = state_62617;
if(cljs.core.truth_(inst_62591)){
var statearr_62628_62665 = state_62617__$1;
(statearr_62628_62665[(1)] = (18));

} else {
var statearr_62629_62666 = state_62617__$1;
(statearr_62629_62666[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (3))){
var inst_62615 = (state_62617[(2)]);
var state_62617__$1 = state_62617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62617__$1,inst_62615);
} else {
if((state_val_62618 === (12))){
var state_62617__$1 = state_62617;
var statearr_62630_62667 = state_62617__$1;
(statearr_62630_62667[(2)] = null);

(statearr_62630_62667[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (2))){
var _ = (function (){var statearr_62631 = state_62617;
(statearr_62631[(4)] = cljs.core.cons.call(null,(5),(state_62617[(4)])));

return statearr_62631;
})();
var inst_62559 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62617__$1 = state_62617;
if(cljs.core.truth_(inst_62559)){
var statearr_62632_62668 = state_62617__$1;
(statearr_62632_62668[(1)] = (6));

} else {
var statearr_62633_62669 = state_62617__$1;
(statearr_62633_62669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (19))){
var inst_62594 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62595 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62596 = cljs.core.PersistentHashMap.fromArrays(inst_62594,inst_62595);
var inst_62597 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_62596);
var inst_62598 = (function(){throw inst_62597})();
var state_62617__$1 = state_62617;
var statearr_62634_62670 = state_62617__$1;
(statearr_62634_62670[(2)] = inst_62598);

(statearr_62634_62670[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (11))){
var inst_62577 = (state_62617[(2)]);
var state_62617__$1 = (function (){var statearr_62636 = state_62617;
(statearr_62636[(9)] = inst_62577);

return statearr_62636;
})();
if(cljs.core.truth_(password)){
var statearr_62637_62671 = state_62617__$1;
(statearr_62637_62671[(1)] = (12));

} else {
var statearr_62638_62672 = state_62617__$1;
(statearr_62638_62672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (9))){
var state_62617__$1 = state_62617;
var statearr_62639_62673 = state_62617__$1;
(statearr_62639_62673[(2)] = null);

(statearr_62639_62673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (5))){
var _ = (function (){var statearr_62640 = state_62617;
(statearr_62640[(4)] = cljs.core.rest.call(null,(state_62617[(4)])));

return statearr_62640;
})();
var state_62617__$1 = state_62617;
var ex62635 = (state_62617__$1[(2)]);
var statearr_62641_62674 = state_62617__$1;
(statearr_62641_62674[(5)] = ex62635);


var statearr_62642_62675 = state_62617__$1;
(statearr_62642_62675[(1)] = (4));

(statearr_62642_62675[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (14))){
var inst_62587 = (state_62617[(8)]);
var inst_62586 = (state_62617[(2)]);
var inst_62587__$1 = user;
var state_62617__$1 = (function (){var statearr_62643 = state_62617;
(statearr_62643[(8)] = inst_62587__$1);

(statearr_62643[(10)] = inst_62586);

return statearr_62643;
})();
if(cljs.core.truth_(inst_62587__$1)){
var statearr_62644_62676 = state_62617__$1;
(statearr_62644_62676[(1)] = (15));

} else {
var statearr_62645_62677 = state_62617__$1;
(statearr_62645_62677[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (16))){
var state_62617__$1 = state_62617;
var statearr_62646_62678 = state_62617__$1;
(statearr_62646_62678[(2)] = auth);

(statearr_62646_62678[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (10))){
var inst_62571 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62572 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_62573 = cljs.core.PersistentHashMap.fromArrays(inst_62571,inst_62572);
var inst_62574 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_62573);
var inst_62575 = (function(){throw inst_62574})();
var state_62617__$1 = state_62617;
var statearr_62647_62679 = state_62617__$1;
(statearr_62647_62679[(2)] = inst_62575);

(statearr_62647_62679[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (18))){
var state_62617__$1 = state_62617;
var statearr_62648_62680 = state_62617__$1;
(statearr_62648_62680[(2)] = null);

(statearr_62648_62680[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62618 === (8))){
var inst_62568 = (state_62617[(2)]);
var state_62617__$1 = (function (){var statearr_62649 = state_62617;
(statearr_62649[(11)] = inst_62568);

return statearr_62649;
})();
if(cljs.core.truth_(ledger)){
var statearr_62650_62681 = state_62617__$1;
(statearr_62650_62681[(1)] = (9));

} else {
var statearr_62651_62682 = state_62617__$1;
(statearr_62651_62682[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_62652 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62652[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_62652[(1)] = (1));

return statearr_62652;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_62617){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62653){var ex__2749__auto__ = e62653;
var statearr_62654_62683 = state_62617;
(statearr_62654_62683[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62617[(4)]))){
var statearr_62655_62684 = state_62617;
(statearr_62655_62684[(1)] = cljs.core.first.call(null,(state_62617[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62685 = state_62617;
state_62617 = G__62685;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_62617){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_62617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62656 = f__2769__auto__.call(null);
(statearr_62656[(6)] = c__2768__auto__);

return statearr_62656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__62687 = arguments.length;
switch (G__62687) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62722){
var state_val_62723 = (state_62722[(1)]);
if((state_val_62723 === (1))){
var state_62722__$1 = state_62722;
var statearr_62724_62744 = state_62722__$1;
(statearr_62724_62744[(2)] = null);

(statearr_62724_62744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (2))){
var _ = (function (){var statearr_62725 = state_62722;
(statearr_62725[(4)] = cljs.core.cons.call(null,(5),(state_62722[(4)])));

return statearr_62725;
})();
var inst_62696 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_62722__$1 = state_62722;
if(cljs.core.truth_(inst_62696)){
var statearr_62726_62745 = state_62722__$1;
(statearr_62726_62745[(1)] = (6));

} else {
var statearr_62727_62746 = state_62722__$1;
(statearr_62727_62746[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (3))){
var inst_62720 = (state_62722[(2)]);
var state_62722__$1 = state_62722;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62722__$1,inst_62720);
} else {
if((state_val_62723 === (4))){
var inst_62688 = (state_62722[(2)]);
var inst_62689 = cljs.core.clj__GT_js.call(null,inst_62688);
var inst_62690 = reject.call(null,inst_62689);
var state_62722__$1 = state_62722;
var statearr_62729_62747 = state_62722__$1;
(statearr_62729_62747[(2)] = inst_62690);

(statearr_62729_62747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (5))){
var _ = (function (){var statearr_62730 = state_62722;
(statearr_62730[(4)] = cljs.core.rest.call(null,(state_62722[(4)])));

return statearr_62730;
})();
var state_62722__$1 = state_62722;
var ex62728 = (state_62722__$1[(2)]);
var statearr_62731_62748 = state_62722__$1;
(statearr_62731_62748[(5)] = ex62728);


var statearr_62732_62749 = state_62722__$1;
(statearr_62732_62749[(1)] = (4));

(statearr_62732_62749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (6))){
var state_62722__$1 = state_62722;
var statearr_62733_62750 = state_62722__$1;
(statearr_62733_62750[(2)] = null);

(statearr_62733_62750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (7))){
var inst_62699 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62700 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_62701 = cljs.core.PersistentHashMap.fromArrays(inst_62699,inst_62700);
var inst_62702 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_62701);
var inst_62703 = (function(){throw inst_62702})();
var state_62722__$1 = state_62722;
var statearr_62734_62751 = state_62722__$1;
(statearr_62734_62751[(2)] = inst_62703);

(statearr_62734_62751[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62723 === (8))){
var inst_62705 = (state_62722[(2)]);
var inst_62706 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_62707 = [jwt,expire];
var inst_62708 = cljs.core.PersistentHashMap.fromArrays(inst_62706,inst_62707);
var inst_62709 = fluree.db.util.core.without_nils.call(null,inst_62708);
var inst_62710 = cljs.core.async.promise_chan.call(null);
var inst_62711 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62713 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_62709,inst_62710,null];
var inst_62714 = (new cljs.core.PersistentVector(null,4,(5),inst_62712,inst_62713,null));
var inst_62715 = cljs.core.async.put_BANG_.call(null,inst_62711,inst_62714);
var inst_62716 = (function (){var _ = inst_62705;
var data = inst_62709;
var pc = inst_62710;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_62717 = cljs.core.async.take_BANG_.call(null,inst_62710,inst_62716);
var _ = (function (){var statearr_62735 = state_62722;
(statearr_62735[(4)] = cljs.core.rest.call(null,(state_62722[(4)])));

return statearr_62735;
})();
var state_62722__$1 = (function (){var statearr_62736 = state_62722;
(statearr_62736[(7)] = inst_62715);

return statearr_62736;
})();
var statearr_62737_62752 = state_62722__$1;
(statearr_62737_62752[(2)] = inst_62717);

(statearr_62737_62752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2746__auto__ = null;
var fluree$db$connection_js$state_machine__2746__auto____0 = (function (){
var statearr_62738 = [null,null,null,null,null,null,null,null];
(statearr_62738[(0)] = fluree$db$connection_js$state_machine__2746__auto__);

(statearr_62738[(1)] = (1));

return statearr_62738;
});
var fluree$db$connection_js$state_machine__2746__auto____1 = (function (state_62722){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62722);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62739){var ex__2749__auto__ = e62739;
var statearr_62740_62753 = state_62722;
(statearr_62740_62753[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62722[(4)]))){
var statearr_62741_62754 = state_62722;
(statearr_62741_62754[(1)] = cljs.core.first.call(null,(state_62722[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62755 = state_62722;
state_62722 = G__62755;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2746__auto__ = function(state_62722){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2746__auto____1.call(this,state_62722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2746__auto____0;
fluree$db$connection_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2746__auto____1;
return fluree$db$connection_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62742 = f__2769__auto__.call(null);
(statearr_62742[(6)] = c__2768__auto__);

return statearr_62742;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

