// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61206_61375 = cljs.core.seq.call(null,servers);
var chunk__61207_61376 = null;
var count__61208_61377 = (0);
var i__61209_61378 = (0);
while(true){
if((i__61209_61378 < count__61208_61377)){
var server_61379 = cljs.core._nth.call(null,chunk__61207_61376,i__61209_61378);
var healthcheck_uri_61380 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61379),"/fdb/health"].join('');
var resp_chan_61381 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_61380,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___61382 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379){
return (function (state_61270){
var state_val_61271 = (state_61270[(1)]);
if((state_val_61271 === (1))){
var state_61270__$1 = state_61270;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61270__$1,(2),resp_chan_61381);
} else {
if((state_val_61271 === (2))){
var inst_61259 = (state_61270[(7)]);
var inst_61259__$1 = (state_61270[(2)]);
var inst_61260 = fluree.db.util.core.exception_QMARK_.call(null,inst_61259__$1);
var state_61270__$1 = (function (){var statearr_61272 = state_61270;
(statearr_61272[(7)] = inst_61259__$1);

return statearr_61272;
})();
if(inst_61260){
var statearr_61273_61383 = state_61270__$1;
(statearr_61273_61383[(1)] = (3));

} else {
var statearr_61274_61384 = state_61270__$1;
(statearr_61274_61384[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (3))){
var inst_61259 = (state_61270[(7)]);
var inst_61262 = cljs.core.ex_message.call(null,inst_61259);
var inst_61263 = cljs.core.ex_data.call(null,inst_61259);
var inst_61264 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_61262,inst_61263);
var state_61270__$1 = state_61270;
var statearr_61275_61385 = state_61270__$1;
(statearr_61275_61385[(2)] = inst_61264);

(statearr_61275_61385[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (4))){
var inst_61266 = cljs.core.async.put_BANG_.call(null,promise_chan,server_61379);
var state_61270__$1 = state_61270;
var statearr_61276_61386 = state_61270__$1;
(statearr_61276_61386[(2)] = inst_61266);

(statearr_61276_61386[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (5))){
var inst_61268 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61270__$1,inst_61268);
} else {
return null;
}
}
}
}
}
});})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379))
;
return ((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,switch__2745__auto__,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_61277 = [null,null,null,null,null,null,null,null];
(statearr_61277[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_61277[(1)] = (1));

return statearr_61277;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_61270){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61270);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61278){var ex__2749__auto__ = e61278;
var statearr_61279_61387 = state_61270;
(statearr_61279_61387[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61270[(4)]))){
var statearr_61280_61388 = state_61270;
(statearr_61280_61388[(1)] = cljs.core.first.call(null,(state_61270[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61389 = state_61270;
state_61270 = G__61389;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_61270){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_61270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,switch__2745__auto__,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379))
})();
var state__2770__auto__ = (function (){var statearr_61281 = f__2769__auto__.call(null);
(statearr_61281[(6)] = c__2768__auto___61382);

return statearr_61281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61382,healthcheck_uri_61380,resp_chan_61381,server_61379))
);



var G__61390 = seq__61206_61375;
var G__61391 = chunk__61207_61376;
var G__61392 = count__61208_61377;
var G__61393 = (i__61209_61378 + (1));
seq__61206_61375 = G__61390;
chunk__61207_61376 = G__61391;
count__61208_61377 = G__61392;
i__61209_61378 = G__61393;
continue;
} else {
var temp__5753__auto___61394 = cljs.core.seq.call(null,seq__61206_61375);
if(temp__5753__auto___61394){
var seq__61206_61395__$1 = temp__5753__auto___61394;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61206_61395__$1)){
var c__4679__auto___61396 = cljs.core.chunk_first.call(null,seq__61206_61395__$1);
var G__61397 = cljs.core.chunk_rest.call(null,seq__61206_61395__$1);
var G__61398 = c__4679__auto___61396;
var G__61399 = cljs.core.count.call(null,c__4679__auto___61396);
var G__61400 = (0);
seq__61206_61375 = G__61397;
chunk__61207_61376 = G__61398;
count__61208_61377 = G__61399;
i__61209_61378 = G__61400;
continue;
} else {
var server_61401 = cljs.core.first.call(null,seq__61206_61395__$1);
var healthcheck_uri_61402 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61401),"/fdb/health"].join('');
var resp_chan_61403 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_61402,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___61404 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394){
return (function (state_61294){
var state_val_61295 = (state_61294[(1)]);
if((state_val_61295 === (1))){
var state_61294__$1 = state_61294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61294__$1,(2),resp_chan_61403);
} else {
if((state_val_61295 === (2))){
var inst_61283 = (state_61294[(7)]);
var inst_61283__$1 = (state_61294[(2)]);
var inst_61284 = fluree.db.util.core.exception_QMARK_.call(null,inst_61283__$1);
var state_61294__$1 = (function (){var statearr_61296 = state_61294;
(statearr_61296[(7)] = inst_61283__$1);

return statearr_61296;
})();
if(inst_61284){
var statearr_61297_61405 = state_61294__$1;
(statearr_61297_61405[(1)] = (3));

} else {
var statearr_61298_61406 = state_61294__$1;
(statearr_61298_61406[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61295 === (3))){
var inst_61283 = (state_61294[(7)]);
var inst_61286 = cljs.core.ex_message.call(null,inst_61283);
var inst_61287 = cljs.core.ex_data.call(null,inst_61283);
var inst_61288 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_61286,inst_61287);
var state_61294__$1 = state_61294;
var statearr_61299_61407 = state_61294__$1;
(statearr_61299_61407[(2)] = inst_61288);

(statearr_61299_61407[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61295 === (4))){
var inst_61290 = cljs.core.async.put_BANG_.call(null,promise_chan,server_61401);
var state_61294__$1 = state_61294;
var statearr_61300_61408 = state_61294__$1;
(statearr_61300_61408[(2)] = inst_61290);

(statearr_61300_61408[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61295 === (5))){
var inst_61292 = (state_61294[(2)]);
var state_61294__$1 = state_61294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61294__$1,inst_61292);
} else {
return null;
}
}
}
}
}
});})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394))
;
return ((function (seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,switch__2745__auto__,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_61301 = [null,null,null,null,null,null,null,null];
(statearr_61301[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_61301[(1)] = (1));

return statearr_61301;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_61294){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61302){var ex__2749__auto__ = e61302;
var statearr_61303_61409 = state_61294;
(statearr_61303_61409[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61294[(4)]))){
var statearr_61304_61410 = state_61294;
(statearr_61304_61410[(1)] = cljs.core.first.call(null,(state_61294[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61411 = state_61294;
state_61294 = G__61411;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_61294){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_61294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,switch__2745__auto__,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394))
})();
var state__2770__auto__ = (function (){var statearr_61305 = f__2769__auto__.call(null);
(statearr_61305[(6)] = c__2768__auto___61404);

return statearr_61305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__61206_61375,chunk__61207_61376,count__61208_61377,i__61209_61378,c__2768__auto___61404,healthcheck_uri_61402,resp_chan_61403,server_61401,seq__61206_61395__$1,temp__5753__auto___61394))
);



var G__61412 = cljs.core.next.call(null,seq__61206_61395__$1);
var G__61413 = null;
var G__61414 = (0);
var G__61415 = (0);
seq__61206_61375 = G__61412;
chunk__61207_61376 = G__61413;
count__61208_61377 = G__61414;
i__61209_61378 = G__61415;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61349){
var state_val_61350 = (state_61349[(1)]);
if((state_val_61350 === (7))){
var inst_61321 = (state_61349[(7)]);
var inst_61328 = cljs.core._EQ_.call(null,inst_61321,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61349__$1 = state_61349;
if(inst_61328){
var statearr_61351_61416 = state_61349__$1;
(statearr_61351_61416[(1)] = (9));

} else {
var statearr_61352_61417 = state_61349__$1;
(statearr_61352_61417[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (1))){
var inst_61314 = (state_61349[(8)]);
var inst_61313 = (state_61349[(9)]);
var inst_61313__$1 = promise_chan;
var inst_61314__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_61315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61316 = [inst_61313__$1,inst_61314__$1];
var inst_61317 = (new cljs.core.PersistentVector(null,2,(5),inst_61315,inst_61316,null));
var state_61349__$1 = (function (){var statearr_61353 = state_61349;
(statearr_61353[(8)] = inst_61314__$1);

(statearr_61353[(9)] = inst_61313__$1);

return statearr_61353;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61349__$1,(2),inst_61317);
} else {
if((state_val_61350 === (4))){
var inst_61314 = (state_61349[(8)]);
var inst_61321 = (state_61349[(7)]);
var inst_61325 = cljs.core._EQ_.call(null,inst_61321,inst_61314);
var state_61349__$1 = state_61349;
if(inst_61325){
var statearr_61354_61418 = state_61349__$1;
(statearr_61354_61418[(1)] = (6));

} else {
var statearr_61355_61419 = state_61349__$1;
(statearr_61355_61419[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (13))){
var state_61349__$1 = state_61349;
var statearr_61356_61420 = state_61349__$1;
(statearr_61356_61420[(2)] = null);

(statearr_61356_61420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (6))){
var state_61349__$1 = state_61349;
var statearr_61357_61421 = state_61349__$1;
(statearr_61357_61421[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61357_61421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (3))){
var state_61349__$1 = state_61349;
var statearr_61358_61422 = state_61349__$1;
(statearr_61358_61422[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61358_61422[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (12))){
var inst_61339 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_61340 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61341 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61342 = cljs.core.PersistentHashMap.fromArrays(inst_61340,inst_61341);
var inst_61343 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_61342);
var inst_61344 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_61343);
var state_61349__$1 = (function (){var statearr_61359 = state_61349;
(statearr_61359[(10)] = inst_61339);

return statearr_61359;
})();
var statearr_61360_61423 = state_61349__$1;
(statearr_61360_61423[(2)] = inst_61344);

(statearr_61360_61423[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (2))){
var inst_61321 = (state_61349[(7)]);
var inst_61313 = (state_61349[(9)]);
var inst_61319 = (state_61349[(2)]);
var inst_61320 = cljs.core.nth.call(null,inst_61319,(0),null);
var inst_61321__$1 = cljs.core.nth.call(null,inst_61319,(1),null);
var inst_61322 = cljs.core._EQ_.call(null,inst_61321__$1,inst_61313);
var state_61349__$1 = (function (){var statearr_61361 = state_61349;
(statearr_61361[(7)] = inst_61321__$1);

(statearr_61361[(11)] = inst_61320);

return statearr_61361;
})();
if(inst_61322){
var statearr_61362_61424 = state_61349__$1;
(statearr_61362_61424[(1)] = (3));

} else {
var statearr_61363_61425 = state_61349__$1;
(statearr_61363_61425[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (11))){
var inst_61332 = (state_61349[(2)]);
var state_61349__$1 = state_61349;
var statearr_61364_61426 = state_61349__$1;
(statearr_61364_61426[(2)] = inst_61332);

(statearr_61364_61426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (9))){
var inst_61320 = (state_61349[(11)]);
var state_61349__$1 = state_61349;
var statearr_61365_61427 = state_61349__$1;
(statearr_61365_61427[(2)] = inst_61320);

(statearr_61365_61427[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (5))){
var inst_61336 = (state_61349[(2)]);
var inst_61337 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61336);
var state_61349__$1 = state_61349;
if(inst_61337){
var statearr_61366_61428 = state_61349__$1;
(statearr_61366_61428[(1)] = (12));

} else {
var statearr_61367_61429 = state_61349__$1;
(statearr_61367_61429[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (14))){
var inst_61347 = (state_61349[(2)]);
var state_61349__$1 = state_61349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61349__$1,inst_61347);
} else {
if((state_val_61350 === (10))){
var state_61349__$1 = state_61349;
var statearr_61368_61430 = state_61349__$1;
(statearr_61368_61430[(2)] = null);

(statearr_61368_61430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61350 === (8))){
var inst_61334 = (state_61349[(2)]);
var state_61349__$1 = state_61349;
var statearr_61369_61431 = state_61349__$1;
(statearr_61369_61431[(2)] = inst_61334);

(statearr_61369_61431[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_61370 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61370[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_61370[(1)] = (1));

return statearr_61370;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_61349){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61371){var ex__2749__auto__ = e61371;
var statearr_61372_61432 = state_61349;
(statearr_61372_61432[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61349[(4)]))){
var statearr_61373_61433 = state_61349;
(statearr_61373_61433[(1)] = cljs.core.first.call(null,(state_61349[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61434 = state_61349;
state_61349 = G__61434;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_61349){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_61349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61374 = f__2769__auto__.call(null);
(statearr_61374[(6)] = c__2768__auto__);

return statearr_61374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61478){
var state_val_61479 = (state_61478[(1)]);
if((state_val_61479 === (7))){
var state_61478__$1 = state_61478;
var statearr_61480_61506 = state_61478__$1;
(statearr_61480_61506[(2)] = null);

(statearr_61480_61506[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (1))){
var state_61478__$1 = state_61478;
var statearr_61481_61507 = state_61478__$1;
(statearr_61481_61507[(2)] = null);

(statearr_61481_61507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (4))){
var inst_61435 = (state_61478[(2)]);
var state_61478__$1 = state_61478;
var statearr_61482_61508 = state_61478__$1;
(statearr_61482_61508[(2)] = inst_61435);

(statearr_61482_61508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (6))){
var inst_61457 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_61478__$1 = state_61478;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61478__$1,(9),inst_61457);
} else {
if((state_val_61479 === (3))){
var inst_61476 = (state_61478[(2)]);
var state_61478__$1 = state_61478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61478__$1,inst_61476);
} else {
if((state_val_61479 === (12))){
var inst_61470 = (state_61478[(2)]);
var state_61478__$1 = state_61478;
var statearr_61483_61509 = state_61478__$1;
(statearr_61483_61509[(2)] = inst_61470);

(statearr_61483_61509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (2))){
var inst_61451 = (state_61478[(7)]);
var inst_61441 = (state_61478[(8)]);
var inst_61446 = (state_61478[(9)]);
var _ = (function (){var statearr_61484 = state_61478;
(statearr_61484[(4)] = cljs.core.cons.call(null,(5),(state_61478[(4)])));

return statearr_61484;
})();
var inst_61441__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_61442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61443 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61444 = (new cljs.core.PersistentVector(null,2,(5),inst_61442,inst_61443,null));
var inst_61445 = (function (){var lock_id = inst_61441__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_61446__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61444,inst_61445);
var inst_61447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61448 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61449 = (new cljs.core.PersistentVector(null,3,(5),inst_61447,inst_61448,null));
var inst_61450 = cljs.core.get_in.call(null,inst_61446__$1,inst_61449);
var inst_61451__$1 = cljs.core._EQ_.call(null,inst_61441__$1,inst_61450);
var inst_61452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61453 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61454 = (new cljs.core.PersistentVector(null,3,(5),inst_61452,inst_61453,null));
var inst_61455 = cljs.core.get_in.call(null,inst_61446__$1,inst_61454);
var state_61478__$1 = (function (){var statearr_61485 = state_61478;
(statearr_61485[(7)] = inst_61451__$1);

(statearr_61485[(8)] = inst_61441__$1);

(statearr_61485[(9)] = inst_61446__$1);

(statearr_61485[(10)] = inst_61455);

return statearr_61485;
})();
if(inst_61451__$1){
var statearr_61486_61510 = state_61478__$1;
(statearr_61486_61510[(1)] = (6));

} else {
var statearr_61487_61511 = state_61478__$1;
(statearr_61487_61511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (11))){
var inst_61462 = (state_61478[(11)]);
var inst_61461 = (state_61478[(12)]);
var inst_61455 = (state_61478[(10)]);
var inst_61468 = fluree.db.util.xhttp.try_socket.call(null,inst_61461,sub_chan,pub_chan,inst_61455,(60000),inst_61462);
var state_61478__$1 = state_61478;
var statearr_61489_61512 = state_61478__$1;
(statearr_61489_61512[(2)] = inst_61468);

(statearr_61489_61512[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (9))){
var inst_61451 = (state_61478[(7)]);
var inst_61459 = (state_61478[(13)]);
var inst_61441 = (state_61478[(8)]);
var inst_61446 = (state_61478[(9)]);
var inst_61461 = (state_61478[(12)]);
var inst_61455 = (state_61478[(10)]);
var inst_61459__$1 = (state_61478[(2)]);
var inst_61460 = clojure.string.replace.call(null,inst_61459__$1,"http","ws");
var inst_61461__$1 = [inst_61460,"/fdb/ws"].join('');
var inst_61462 = (function (){var lock_id = inst_61441;
var state = inst_61446;
var have_lock_QMARK_ = inst_61451;
var resp_chan = inst_61455;
var healthy_server = inst_61459__$1;
var ws_url = inst_61461__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_61463 = fluree.db.util.core.exception_QMARK_.call(null,inst_61459__$1);
var state_61478__$1 = (function (){var statearr_61490 = state_61478;
(statearr_61490[(11)] = inst_61462);

(statearr_61490[(13)] = inst_61459__$1);

(statearr_61490[(12)] = inst_61461__$1);

return statearr_61490;
})();
if(inst_61463){
var statearr_61491_61513 = state_61478__$1;
(statearr_61491_61513[(1)] = (10));

} else {
var statearr_61492_61514 = state_61478__$1;
(statearr_61492_61514[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (5))){
var _ = (function (){var statearr_61493 = state_61478;
(statearr_61493[(4)] = cljs.core.rest.call(null,(state_61478[(4)])));

return statearr_61493;
})();
var state_61478__$1 = state_61478;
var ex61488 = (state_61478__$1[(2)]);
var statearr_61494_61515 = state_61478__$1;
(statearr_61494_61515[(5)] = ex61488);


if((ex61488 instanceof Error)){
var statearr_61495_61516 = state_61478__$1;
(statearr_61495_61516[(1)] = (4));

(statearr_61495_61516[(5)] = null);

} else {
throw ex61488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (10))){
var inst_61459 = (state_61478[(13)]);
var inst_61455 = (state_61478[(10)]);
var inst_61465 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_61466 = cljs.core.async.put_BANG_.call(null,inst_61455,inst_61459);
var state_61478__$1 = (function (){var statearr_61496 = state_61478;
(statearr_61496[(14)] = inst_61465);

return statearr_61496;
})();
var statearr_61497_61517 = state_61478__$1;
(statearr_61497_61517[(2)] = inst_61466);

(statearr_61497_61517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61479 === (8))){
var inst_61455 = (state_61478[(10)]);
var inst_61473 = (state_61478[(2)]);
var _ = (function (){var statearr_61498 = state_61478;
(statearr_61498[(4)] = cljs.core.rest.call(null,(state_61478[(4)])));

return statearr_61498;
})();
var state_61478__$1 = (function (){var statearr_61499 = state_61478;
(statearr_61499[(15)] = inst_61473);

return statearr_61499;
})();
var statearr_61500_61518 = state_61478__$1;
(statearr_61500_61518[(2)] = inst_61455);

(statearr_61500_61518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_61501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61501[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_61501[(1)] = (1));

return statearr_61501;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_61478){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61502){var ex__2749__auto__ = e61502;
var statearr_61503_61519 = state_61478;
(statearr_61503_61519[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61478[(4)]))){
var statearr_61504_61520 = state_61478;
(statearr_61504_61520[(1)] = cljs.core.first.call(null,(state_61478[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61521 = state_61478;
state_61478 = G__61521;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_61478){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_61478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61505 = f__2769__auto__.call(null);
(statearr_61505[(6)] = c__2768__auto__);

return statearr_61505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k61523,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__61527 = k61523;
var G__61527__$1 = (((G__61527 instanceof cljs.core.Keyword))?G__61527.fqn:null);
switch (G__61527__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k61523,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__61528){
var vec__61529 = p__61528;
var k__4526__auto__ = cljs.core.nth.call(null,vec__61529,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__61529,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61522){
var self__ = this;
var G__61522__$1 = this;
return (new cljs.core.RecordIter((0),G__61522__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61524,other61525){
var self__ = this;
var this61524__$1 = this;
return (((!((other61525 == null)))) && ((((this61524__$1.constructor === other61525.constructor)) && (((cljs.core._EQ_.call(null,this61524__$1.id,other61525.id)) && (((cljs.core._EQ_.call(null,this61524__$1.servers,other61525.servers)) && (((cljs.core._EQ_.call(null,this61524__$1.state,other61525.state)) && (((cljs.core._EQ_.call(null,this61524__$1.req_chan,other61525.req_chan)) && (((cljs.core._EQ_.call(null,this61524__$1.sub_chan,other61525.sub_chan)) && (((cljs.core._EQ_.call(null,this61524__$1.pub_chan,other61525.pub_chan)) && (((cljs.core._EQ_.call(null,this61524__$1.group,other61525.group)) && (((cljs.core._EQ_.call(null,this61524__$1.storage_read,other61525.storage_read)) && (((cljs.core._EQ_.call(null,this61524__$1.storage_write,other61525.storage_write)) && (((cljs.core._EQ_.call(null,this61524__$1.object_cache,other61525.object_cache)) && (((cljs.core._EQ_.call(null,this61524__$1.parallelism,other61525.parallelism)) && (((cljs.core._EQ_.call(null,this61524__$1.serializer,other61525.serializer)) && (((cljs.core._EQ_.call(null,this61524__$1.default_network,other61525.default_network)) && (((cljs.core._EQ_.call(null,this61524__$1.transactor_QMARK_,other61525.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this61524__$1.publish,other61525.publish)) && (((cljs.core._EQ_.call(null,this61524__$1.transact_handler,other61525.transact_handler)) && (((cljs.core._EQ_.call(null,this61524__$1.tx_private_key,other61525.tx_private_key)) && (((cljs.core._EQ_.call(null,this61524__$1.tx_key_id,other61525.tx_key_id)) && (((cljs.core._EQ_.call(null,this61524__$1.meta,other61525.meta)) && (((cljs.core._EQ_.call(null,this61524__$1.add_listener,other61525.add_listener)) && (((cljs.core._EQ_.call(null,this61524__$1.remove_listener,other61525.remove_listener)) && (((cljs.core._EQ_.call(null,this61524__$1.close,other61525.close)) && (cljs.core._EQ_.call(null,this61524__$1.__extmap,other61525.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k61523){
var self__ = this;
var this__4509__auto____$1 = this;
var G__61532 = k61523;
var G__61532__$1 = (((G__61532 instanceof cljs.core.Keyword))?G__61532.fqn:null);
switch (G__61532__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k61523);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__61522){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__61533 = cljs.core.keyword_identical_QMARK_;
var expr__61534 = k__4511__auto__;
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__61534))){
return (new fluree.db.connection.Connection(G__61522,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,G__61522,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61522,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61522,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61522,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61522,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61522,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61522,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61522,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61522,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61522,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61522,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61522,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61522,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61522,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61522,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61522,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61522,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61522,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61522,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61522,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61533.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__61534))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61522,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__61522),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__61522){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61522,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61526){
var extmap__4542__auto__ = (function (){var G__61536 = cljs.core.dissoc.call(null,G__61526,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__61526)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__61536);
} else {
return G__61536;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61526),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61526),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__61542 = servers_STAR_;
var vec__61543 = G__61542;
var seq__61544 = cljs.core.seq.call(null,vec__61543);
var first__61545 = cljs.core.first.call(null,seq__61544);
var seq__61544__$1 = cljs.core.next.call(null,seq__61544);
var server = first__61545;
var r = seq__61544__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61542__$1 = G__61542;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61549 = G__61542__$1;
var seq__61550 = cljs.core.seq.call(null,vec__61549);
var first__61551 = cljs.core.first.call(null,seq__61550);
var seq__61550__$1 = cljs.core.next.call(null,seq__61550);
var server__$1 = first__61551;
var r__$1 = seq__61550__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__61552 = r__$1;
var G__61553 = is_https_QMARK_;
var G__61554 = result_STAR_;
G__61542__$1 = G__61552;
https_QMARK___$1 = G__61553;
result__$1 = G__61554;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61555 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61555 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__61555);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61584){
var state_val_61585 = (state_61584[(1)]);
if((state_val_61585 === (7))){
var inst_61570 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61571 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61572 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61573 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61574 = fluree.db.connection.establish_socket.call(null,inst_61570,inst_61571,inst_61572,inst_61573);
var state_61584__$1 = state_61584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61584__$1,(9),inst_61574);
} else {
if((state_val_61585 === (1))){
var state_61584__$1 = state_61584;
var statearr_61586_61605 = state_61584__$1;
(statearr_61586_61605[(2)] = null);

(statearr_61586_61605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (4))){
var inst_61556 = (state_61584[(2)]);
var state_61584__$1 = state_61584;
var statearr_61587_61606 = state_61584__$1;
(statearr_61587_61606[(2)] = inst_61556);

(statearr_61587_61606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (6))){
var inst_61567 = (state_61584[(7)]);
var state_61584__$1 = state_61584;
var statearr_61588_61607 = state_61584__$1;
(statearr_61588_61607[(2)] = inst_61567);

(statearr_61588_61607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (3))){
var inst_61582 = (state_61584[(2)]);
var state_61584__$1 = state_61584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61584__$1,inst_61582);
} else {
if((state_val_61585 === (2))){
var inst_61567 = (state_61584[(7)]);
var _ = (function (){var statearr_61590 = state_61584;
(statearr_61590[(4)] = cljs.core.cons.call(null,(5),(state_61584[(4)])));

return statearr_61590;
})();
var inst_61562 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_61563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61564 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61565 = [inst_61564,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61566 = (new cljs.core.PersistentVector(null,3,(5),inst_61563,inst_61565,null));
var inst_61567__$1 = cljs.core.get_in.call(null,inst_61562,inst_61566);
var state_61584__$1 = (function (){var statearr_61591 = state_61584;
(statearr_61591[(7)] = inst_61567__$1);

return statearr_61591;
})();
if(cljs.core.truth_(inst_61567__$1)){
var statearr_61592_61608 = state_61584__$1;
(statearr_61592_61608[(1)] = (6));

} else {
var statearr_61593_61609 = state_61584__$1;
(statearr_61593_61609[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (9))){
var inst_61576 = (state_61584[(2)]);
var inst_61577 = fluree.db.util.async.throw_err.call(null,inst_61576);
var state_61584__$1 = state_61584;
var statearr_61594_61610 = state_61584__$1;
(statearr_61594_61610[(2)] = inst_61577);

(statearr_61594_61610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (5))){
var _ = (function (){var statearr_61595 = state_61584;
(statearr_61595[(4)] = cljs.core.rest.call(null,(state_61584[(4)])));

return statearr_61595;
})();
var state_61584__$1 = state_61584;
var ex61589 = (state_61584__$1[(2)]);
var statearr_61596_61611 = state_61584__$1;
(statearr_61596_61611[(5)] = ex61589);


if((ex61589 instanceof Error)){
var statearr_61597_61612 = state_61584__$1;
(statearr_61597_61612[(1)] = (4));

(statearr_61597_61612[(5)] = null);

} else {
throw ex61589;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61585 === (8))){
var inst_61579 = (state_61584[(2)]);
var _ = (function (){var statearr_61598 = state_61584;
(statearr_61598[(4)] = cljs.core.rest.call(null,(state_61584[(4)])));

return statearr_61598;
})();
var state_61584__$1 = state_61584;
var statearr_61599_61613 = state_61584__$1;
(statearr_61599_61613[(2)] = inst_61579);

(statearr_61599_61613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_61600 = [null,null,null,null,null,null,null,null];
(statearr_61600[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_61600[(1)] = (1));

return statearr_61600;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_61584){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61601){var ex__2749__auto__ = e61601;
var statearr_61602_61614 = state_61584;
(statearr_61602_61614[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61584[(4)]))){
var statearr_61603_61615 = state_61584;
(statearr_61603_61615[(1)] = cljs.core.first.call(null,(state_61584[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61616 = state_61584;
state_61584 = G__61616;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_61584){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_61584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61604 = f__2769__auto__.call(null);
(statearr_61604[(6)] = c__2768__auto__);

return statearr_61604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e61617){var e = e61617;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61744){
var state_val_61745 = (state_61744[(1)]);
if((state_val_61745 === (7))){
var inst_61740 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
var statearr_61747_61817 = state_61744__$1;
(statearr_61747_61817[(2)] = inst_61740);

(statearr_61747_61817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (20))){
var _ = (function (){var statearr_61748 = state_61744;
(statearr_61748[(4)] = cljs.core.rest.call(null,(state_61744[(4)])));

return statearr_61748;
})();
var state_61744__$1 = state_61744;
var ex61746 = (state_61744__$1[(2)]);
var statearr_61749_61818 = state_61744__$1;
(statearr_61749_61818[(5)] = ex61746);


var statearr_61750_61819 = state_61744__$1;
(statearr_61750_61819[(1)] = (10));

(statearr_61750_61819[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (27))){
var inst_61732 = (state_61744[(2)]);
var _ = (function (){var statearr_61751 = state_61744;
(statearr_61751[(4)] = cljs.core.rest.call(null,(state_61744[(4)])));

return statearr_61751;
})();
var state_61744__$1 = state_61744;
var statearr_61752_61820 = state_61744__$1;
(statearr_61752_61820[(2)] = inst_61732);

(statearr_61752_61820[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (1))){
var inst_61619 = (0);
var state_61744__$1 = (function (){var statearr_61753 = state_61744;
(statearr_61753[(7)] = inst_61619);

return statearr_61753;
})();
var statearr_61754_61821 = state_61744__$1;
(statearr_61754_61821[(2)] = null);

(statearr_61754_61821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (24))){
var inst_61710 = (state_61744[(8)]);
var inst_61710__$1 = (state_61744[(2)]);
var inst_61711 = inst_61710__$1 === true;
var state_61744__$1 = (function (){var statearr_61755 = state_61744;
(statearr_61755[(8)] = inst_61710__$1);

return statearr_61755;
})();
if(cljs.core.truth_(inst_61711)){
var statearr_61756_61822 = state_61744__$1;
(statearr_61756_61822[(1)] = (25));

} else {
var statearr_61757_61823 = state_61744__$1;
(statearr_61757_61823[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (4))){
var inst_61622 = (state_61744[(9)]);
var inst_61622__$1 = (state_61744[(2)]);
var state_61744__$1 = (function (){var statearr_61758 = state_61744;
(statearr_61758[(9)] = inst_61622__$1);

return statearr_61758;
})();
if(cljs.core.truth_(inst_61622__$1)){
var statearr_61759_61824 = state_61744__$1;
(statearr_61759_61824[(1)] = (5));

} else {
var statearr_61760_61825 = state_61744__$1;
(statearr_61760_61825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (15))){
var inst_61635 = (state_61744[(10)]);
var state_61744__$1 = state_61744;
var statearr_61761_61826 = state_61744__$1;
(statearr_61761_61826[(2)] = inst_61635);

(statearr_61761_61826[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (21))){
var inst_61661 = (state_61744[(11)]);
var inst_61666 = (state_61744[(12)]);
var inst_61658 = (state_61744[(13)]);
var inst_61659 = (state_61744[(14)]);
var inst_61663 = (state_61744[(15)]);
var inst_61660 = (state_61744[(16)]);
var inst_61667 = (state_61744[(17)]);
var inst_61622 = (state_61744[(9)]);
var inst_61662 = (state_61744[(18)]);
var inst_61619 = (state_61744[(7)]);
var inst_61669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61670 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61666];
var inst_61671 = (new cljs.core.PersistentVector(null,2,(5),inst_61669,inst_61670,null));
var inst_61672 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_61671,inst_61661);
var inst_61699 = cljs.core.async.chan.call(null,(1));
var inst_61700 = (function (){var resp_chan = inst_61661;
var timeout = inst_61667;
var i = inst_61619;
var map__61657 = inst_61663;
var data = inst_61660;
var _ = inst_61658;
var req_id = inst_61666;
var operation = inst_61659;
var msg = inst_61622;
var vec__61654 = inst_61622;
var c__2768__auto____$1 = inst_61699;
var opts = inst_61662;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61697){
var state_val_61698 = (state_61697[(1)]);
if((state_val_61698 === (1))){
var inst_61676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61677 = cljs.core.async.timeout.call(null,timeout);
var inst_61678 = [resp_chan,inst_61677];
var inst_61679 = (new cljs.core.PersistentVector(null,2,(5),inst_61676,inst_61678,null));
var state_61697__$1 = state_61697;
return cljs.core.async.ioc_alts_BANG_.call(null,state_61697__$1,(2),inst_61679);
} else {
if((state_val_61698 === (2))){
var inst_61682 = (state_61697[(7)]);
var inst_61681 = (state_61697[(2)]);
var inst_61682__$1 = cljs.core.nth.call(null,inst_61681,(0),null);
var inst_61683 = cljs.core.nth.call(null,inst_61681,(1),null);
var inst_61684 = (function (){var vec__61673 = inst_61681;
var resp = inst_61682__$1;
var c = inst_61683;
return (function (p1__61618_SHARP_){
return cljs.core.dissoc.call(null,p1__61618_SHARP_,req_id);
});
})();
var inst_61685 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61684);
var inst_61686 = cljs.core._EQ_.call(null,inst_61683,resp_chan);
var state_61697__$1 = (function (){var statearr_61762 = state_61697;
(statearr_61762[(7)] = inst_61682__$1);

(statearr_61762[(8)] = inst_61685);

return statearr_61762;
})();
if(inst_61686){
var statearr_61763_61827 = state_61697__$1;
(statearr_61763_61827[(1)] = (3));

} else {
var statearr_61764_61828 = state_61697__$1;
(statearr_61764_61828[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61698 === (3))){
var inst_61682 = (state_61697[(7)]);
var state_61697__$1 = state_61697;
var statearr_61765_61829 = state_61697__$1;
(statearr_61765_61829[(2)] = inst_61682);

(statearr_61765_61829[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61698 === (4))){
var inst_61689 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_61690 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61691 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_61692 = cljs.core.PersistentHashMap.fromArrays(inst_61690,inst_61691);
var inst_61693 = cljs.core.ex_info.call(null,inst_61689,inst_61692);
var state_61697__$1 = state_61697;
var statearr_61766_61830 = state_61697__$1;
(statearr_61766_61830[(2)] = inst_61693);

(statearr_61766_61830[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61698 === (5))){
var inst_61695 = (state_61697[(2)]);
var state_61697__$1 = state_61697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61697__$1,inst_61695);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_61767 = [null,null,null,null,null,null,null,null,null];
(statearr_61767[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_61767[(1)] = (1));

return statearr_61767;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_61697){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61768){var ex__2749__auto__ = e61768;
var statearr_61769_61831 = state_61697;
(statearr_61769_61831[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61697[(4)]))){
var statearr_61770_61832 = state_61697;
(statearr_61770_61832[(1)] = cljs.core.first.call(null,(state_61697[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61833 = state_61697;
state_61697 = G__61833;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_61697){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_61697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61771 = f__2769__auto__.call(null);
(statearr_61771[(6)] = c__2768__auto____$1);

return statearr_61771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_61701 = cljs.core.async.impl.dispatch.run.call(null,inst_61700);
var state_61744__$1 = (function (){var statearr_61772 = state_61744;
(statearr_61772[(19)] = inst_61672);

(statearr_61772[(20)] = inst_61701);

return statearr_61772;
})();
var statearr_61773_61834 = state_61744__$1;
(statearr_61773_61834[(2)] = inst_61699);

(statearr_61773_61834[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (31))){
var inst_61720 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_61744__$1 = state_61744;
var statearr_61774_61835 = state_61744__$1;
(statearr_61774_61835[(2)] = inst_61720);

(statearr_61774_61835[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (32))){
var state_61744__$1 = state_61744;
var statearr_61775_61836 = state_61744__$1;
(statearr_61775_61836[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (33))){
var inst_61728 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
var statearr_61777_61837 = state_61744__$1;
(statearr_61777_61837[(2)] = inst_61728);

(statearr_61777_61837[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (13))){
var inst_61635 = (state_61744[(10)]);
var inst_61632 = (state_61744[(2)]);
var inst_61633 = cljs.core.nth.call(null,inst_61632,(0),null);
var inst_61634 = cljs.core.nth.call(null,inst_61632,(1),null);
var inst_61635__$1 = cljs.core.nth.call(null,inst_61632,(2),null);
var state_61744__$1 = (function (){var statearr_61778 = state_61744;
(statearr_61778[(21)] = inst_61633);

(statearr_61778[(22)] = inst_61634);

(statearr_61778[(10)] = inst_61635__$1);

return statearr_61778;
})();
if(cljs.core.truth_(inst_61635__$1)){
var statearr_61779_61838 = state_61744__$1;
(statearr_61779_61838[(1)] = (14));

} else {
var statearr_61780_61839 = state_61744__$1;
(statearr_61780_61839[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (22))){
var state_61744__$1 = state_61744;
var statearr_61781_61840 = state_61744__$1;
(statearr_61781_61840[(2)] = null);

(statearr_61781_61840[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (36))){
var inst_61726 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
var statearr_61782_61841 = state_61744__$1;
(statearr_61782_61841[(2)] = inst_61726);

(statearr_61782_61841[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (29))){
var inst_61710 = (state_61744[(8)]);
var inst_61718 = (inst_61710 == null);
var state_61744__$1 = state_61744;
if(cljs.core.truth_(inst_61718)){
var statearr_61783_61842 = state_61744__$1;
(statearr_61783_61842[(1)] = (31));

} else {
var statearr_61784_61843 = state_61744__$1;
(statearr_61784_61843[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (6))){
var state_61744__$1 = state_61744;
var statearr_61785_61844 = state_61744__$1;
(statearr_61785_61844[(2)] = null);

(statearr_61785_61844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (28))){
var inst_61710 = (state_61744[(8)]);
var inst_61716 = fluree.db.util.log.error.call(null,inst_61710,"Error processing message in producer.");
var state_61744__$1 = state_61744;
var statearr_61786_61845 = state_61744__$1;
(statearr_61786_61845[(2)] = inst_61716);

(statearr_61786_61845[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (25))){
var state_61744__$1 = state_61744;
var statearr_61787_61846 = state_61744__$1;
(statearr_61787_61846[(2)] = null);

(statearr_61787_61846[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (34))){
var inst_61710 = (state_61744[(8)]);
var inst_61723 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_61710);
var state_61744__$1 = state_61744;
var statearr_61788_61847 = state_61744__$1;
(statearr_61788_61847[(2)] = inst_61723);

(statearr_61788_61847[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (17))){
var inst_61624 = (state_61744[(23)]);
var inst_61635 = (state_61744[(10)]);
var inst_61642 = cljs.core.async.put_BANG_.call(null,inst_61635,inst_61624);
var state_61744__$1 = state_61744;
var statearr_61789_61848 = state_61744__$1;
(statearr_61789_61848[(2)] = inst_61642);

(statearr_61789_61848[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (3))){
var inst_61742 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61744__$1,inst_61742);
} else {
if((state_val_61745 === (12))){
var state_61744__$1 = state_61744;
var statearr_61790_61849 = state_61744__$1;
(statearr_61790_61849[(2)] = null);

(statearr_61790_61849[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (2))){
var state_61744__$1 = state_61744;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61744__$1,(4),req_chan);
} else {
if((state_val_61745 === (23))){
var inst_61666 = (state_61744[(12)]);
var inst_61659 = (state_61744[(14)]);
var inst_61660 = (state_61744[(16)]);
var inst_61704 = (state_61744[(2)]);
var inst_61705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61706 = [inst_61659,inst_61666,inst_61660];
var inst_61707 = (new cljs.core.PersistentVector(null,3,(5),inst_61705,inst_61706,null));
var inst_61708 = publish_fn.call(null,conn,inst_61707);
var state_61744__$1 = (function (){var statearr_61791 = state_61744;
(statearr_61791[(24)] = inst_61704);

return statearr_61791;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61744__$1,(24),inst_61708);
} else {
if((state_val_61745 === (35))){
var state_61744__$1 = state_61744;
var statearr_61792_61850 = state_61744__$1;
(statearr_61792_61850[(2)] = null);

(statearr_61792_61850[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (19))){
var inst_61648 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
var statearr_61793_61851 = state_61744__$1;
(statearr_61793_61851[(2)] = inst_61648);

(statearr_61793_61851[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (11))){
var inst_61622 = (state_61744[(9)]);
var state_61744__$1 = state_61744;
var statearr_61794_61852 = state_61744__$1;
(statearr_61794_61852[(2)] = inst_61622);

(statearr_61794_61852[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (9))){
var inst_61619 = (state_61744[(7)]);
var inst_61735 = (state_61744[(2)]);
var inst_61736 = (inst_61619 + (1));
var inst_61619__$1 = inst_61736;
var state_61744__$1 = (function (){var statearr_61795 = state_61744;
(statearr_61795[(25)] = inst_61735);

(statearr_61795[(7)] = inst_61619__$1);

return statearr_61795;
})();
var statearr_61796_61853 = state_61744__$1;
(statearr_61796_61853[(2)] = null);

(statearr_61796_61853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (5))){
var state_61744__$1 = state_61744;
var statearr_61797_61854 = state_61744__$1;
(statearr_61797_61854[(2)] = null);

(statearr_61797_61854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (14))){
var inst_61635 = (state_61744[(10)]);
var inst_61637 = fluree.db.util.async.channel_QMARK_.call(null,inst_61635);
var state_61744__$1 = state_61744;
var statearr_61798_61855 = state_61744__$1;
(statearr_61798_61855[(2)] = inst_61637);

(statearr_61798_61855[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (26))){
var inst_61710 = (state_61744[(8)]);
var inst_61714 = fluree.db.util.core.exception_QMARK_.call(null,inst_61710);
var state_61744__$1 = state_61744;
if(inst_61714){
var statearr_61799_61856 = state_61744__$1;
(statearr_61799_61856[(1)] = (28));

} else {
var statearr_61800_61857 = state_61744__$1;
(statearr_61800_61857[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (16))){
var inst_61640 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
if(cljs.core.truth_(inst_61640)){
var statearr_61801_61858 = state_61744__$1;
(statearr_61801_61858[(1)] = (17));

} else {
var statearr_61802_61859 = state_61744__$1;
(statearr_61802_61859[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (30))){
var inst_61730 = (state_61744[(2)]);
var state_61744__$1 = state_61744;
var statearr_61803_61860 = state_61744__$1;
(statearr_61803_61860[(2)] = inst_61730);

(statearr_61803_61860[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (10))){
var inst_61622 = (state_61744[(9)]);
var inst_61624 = (state_61744[(2)]);
var inst_61628 = cljs.core.sequential_QMARK_.call(null,inst_61622);
var state_61744__$1 = (function (){var statearr_61804 = state_61744;
(statearr_61804[(23)] = inst_61624);

return statearr_61804;
})();
if(inst_61628){
var statearr_61805_61861 = state_61744__$1;
(statearr_61805_61861[(1)] = (11));

} else {
var statearr_61806_61862 = state_61744__$1;
(statearr_61806_61862[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (18))){
var inst_61624 = (state_61744[(23)]);
var inst_61622 = (state_61744[(9)]);
var inst_61644 = cljs.core.pr_str.call(null,inst_61622);
var inst_61645 = ["Error processing ledger request, no valid return channel: ",inst_61644].join('');
var inst_61646 = fluree.db.util.log.error.call(null,inst_61624,inst_61645);
var state_61744__$1 = state_61744;
var statearr_61807_61863 = state_61744__$1;
(statearr_61807_61863[(2)] = inst_61646);

(statearr_61807_61863[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61745 === (8))){
var inst_61661 = (state_61744[(11)]);
var inst_61663 = (state_61744[(15)]);
var inst_61622 = (state_61744[(9)]);
var inst_61662 = (state_61744[(18)]);
var _ = (function (){var statearr_61808 = state_61744;
(statearr_61808[(4)] = cljs.core.cons.call(null,(20),(state_61744[(4)])));

return statearr_61808;
})();
var inst_61658 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_61622);
var inst_61659 = cljs.core.nth.call(null,inst_61622,(0),null);
var inst_61660 = cljs.core.nth.call(null,inst_61622,(1),null);
var inst_61661__$1 = cljs.core.nth.call(null,inst_61622,(2),null);
var inst_61662__$1 = cljs.core.nth.call(null,inst_61622,(3),null);
var inst_61663__$1 = cljs.core.__destructure_map.call(null,inst_61662__$1);
var inst_61664 = fluree.db.util.core.random_uuid.call(null);
var inst_61665 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_61664);
var inst_61666 = cljs.core.get.call(null,inst_61663__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_61665);
var inst_61667 = cljs.core.get.call(null,inst_61663__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_61744__$1 = (function (){var statearr_61809 = state_61744;
(statearr_61809[(11)] = inst_61661__$1);

(statearr_61809[(12)] = inst_61666);

(statearr_61809[(13)] = inst_61658);

(statearr_61809[(14)] = inst_61659);

(statearr_61809[(15)] = inst_61663__$1);

(statearr_61809[(16)] = inst_61660);

(statearr_61809[(17)] = inst_61667);

(statearr_61809[(18)] = inst_61662__$1);

return statearr_61809;
})();
if(cljs.core.truth_(inst_61661__$1)){
var statearr_61810_61864 = state_61744__$1;
(statearr_61810_61864[(1)] = (21));

} else {
var statearr_61811_61865 = state_61744__$1;
(statearr_61811_61865[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_61812 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61812[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_61812[(1)] = (1));

return statearr_61812;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_61744){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61744);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e61813){var ex__2749__auto__ = e61813;
var statearr_61814_61866 = state_61744;
(statearr_61814_61866[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61744[(4)]))){
var statearr_61815_61867 = state_61744;
(statearr_61815_61867[(1)] = cljs.core.first.call(null,(state_61744[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61868 = state_61744;
state_61744 = G__61868;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_61744){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_61744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_61816 = f__2769__auto__.call(null);
(statearr_61816[(6)] = c__2768__auto__);

return statearr_61816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__61869 = conn;
var map__61869__$1 = cljs.core.__destructure_map.call(null,map__61869);
var sub_chan = cljs.core.get.call(null,map__61869__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_61954){
var state_val_61955 = (state_61954[(1)]);
if((state_val_61955 === (7))){
var inst_61950 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61956_62007 = state_61954__$1;
(statearr_61956_62007[(2)] = inst_61950);

(statearr_61956_62007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (20))){
var inst_61888 = (state_61954[(7)]);
var inst_61902 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_61903 = [inst_61888];
var inst_61904 = cljs.core.PersistentHashMap.fromArrays(inst_61902,inst_61903);
var inst_61905 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_61904);
var state_61954__$1 = state_61954;
var statearr_61957_62008 = state_61954__$1;
(statearr_61957_62008[(2)] = inst_61905);

(statearr_61957_62008[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (27))){
var state_61954__$1 = state_61954;
var statearr_61958_62009 = state_61954__$1;
(statearr_61958_62009[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (1))){
var inst_61870 = (0);
var state_61954__$1 = (function (){var statearr_61960 = state_61954;
(statearr_61960[(8)] = inst_61870);

return statearr_61960;
})();
var statearr_61961_62010 = state_61954__$1;
(statearr_61961_62010[(2)] = null);

(statearr_61961_62010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (24))){
var inst_61881 = (state_61954[(9)]);
var inst_61930 = fluree.db.util.core.exception_QMARK_.call(null,inst_61881);
var state_61954__$1 = state_61954;
if(inst_61930){
var statearr_61962_62011 = state_61954__$1;
(statearr_61962_62011[(1)] = (26));

} else {
var statearr_61963_62012 = state_61954__$1;
(statearr_61963_62012[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (4))){
var inst_61875 = (state_61954[(10)]);
var inst_61880 = (state_61954[(2)]);
var inst_61881 = cljs.core.nth.call(null,inst_61880,(0),null);
var inst_61882 = cljs.core.nth.call(null,inst_61880,(1),null);
var inst_61883 = cljs.core._EQ_.call(null,inst_61882,inst_61875);
var state_61954__$1 = (function (){var statearr_61964 = state_61954;
(statearr_61964[(9)] = inst_61881);

return statearr_61964;
})();
if(inst_61883){
var statearr_61965_62013 = state_61954__$1;
(statearr_61965_62013[(1)] = (5));

} else {
var statearr_61966_62014 = state_61954__$1;
(statearr_61966_62014[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (15))){
var inst_61888 = (state_61954[(7)]);
var inst_61897 = typeof inst_61888 === 'string';
var state_61954__$1 = state_61954;
if(cljs.core.truth_(inst_61897)){
var statearr_61967_62015 = state_61954__$1;
(statearr_61967_62015[(1)] = (17));

} else {
var statearr_61968_62016 = state_61954__$1;
(statearr_61968_62016[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (21))){
var state_61954__$1 = state_61954;
var statearr_61969_62017 = state_61954__$1;
(statearr_61969_62017[(2)] = null);

(statearr_61969_62017[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (31))){
var inst_61944 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61970_62018 = state_61954__$1;
(statearr_61970_62018[(2)] = inst_61944);

(statearr_61970_62018[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (13))){
var inst_61914 = (state_61954[(2)]);
var inst_61915 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61916 = fluree.db.connection.close_websocket.call(null,inst_61915);
var inst_61917 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61918 = fluree.db.session.close_all_sessions.call(null,inst_61917);
var state_61954__$1 = (function (){var statearr_61971 = state_61954;
(statearr_61971[(11)] = inst_61914);

(statearr_61971[(12)] = inst_61916);

return statearr_61971;
})();
var statearr_61972_62019 = state_61954__$1;
(statearr_61972_62019[(2)] = inst_61918);

(statearr_61972_62019[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (22))){
var inst_61908 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61973_62020 = state_61954__$1;
(statearr_61973_62020[(2)] = inst_61908);

(statearr_61973_62020[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (29))){
var inst_61881 = (state_61954[(9)]);
var inst_61936 = fluree.db.util.json.parse.call(null,inst_61881);
var inst_61937 = cljs.core.pr_str.call(null,inst_61936);
var inst_61938 = fluree.db.util.log.trace.call(null,"Received message:",inst_61937);
var inst_61939 = fluree.db.util.json.parse.call(null,inst_61881);
var inst_61940 = fluree.db.conn_events.process_events.call(null,conn,inst_61939);
var inst_61870 = (0);
var state_61954__$1 = (function (){var statearr_61974 = state_61954;
(statearr_61974[(13)] = inst_61940);

(statearr_61974[(8)] = inst_61870);

(statearr_61974[(14)] = inst_61938);

return statearr_61974;
})();
var statearr_61975_62021 = state_61954__$1;
(statearr_61975_62021[(2)] = null);

(statearr_61975_62021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (6))){
var inst_61881 = (state_61954[(9)]);
var inst_61926 = (inst_61881 == null);
var state_61954__$1 = state_61954;
if(cljs.core.truth_(inst_61926)){
var statearr_61976_62022 = state_61954__$1;
(statearr_61976_62022[(1)] = (23));

} else {
var statearr_61977_62023 = state_61954__$1;
(statearr_61977_62023[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (28))){
var inst_61946 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61978_62024 = state_61954__$1;
(statearr_61978_62024[(2)] = inst_61946);

(statearr_61978_62024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (25))){
var inst_61948 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61979_62025 = state_61954__$1;
(statearr_61979_62025[(2)] = inst_61948);

(statearr_61979_62025[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (17))){
var inst_61888 = (state_61954[(7)]);
var inst_61899 = cljs.core.eval.call(null,inst_61888);
var state_61954__$1 = state_61954;
var statearr_61980_62026 = state_61954__$1;
(statearr_61980_62026[(2)] = inst_61899);

(statearr_61980_62026[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (3))){
var inst_61952 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61954__$1,inst_61952);
} else {
if((state_val_61955 === (12))){
var inst_61888 = (state_61954[(7)]);
var inst_61893 = cljs.core.fn_QMARK_.call(null,inst_61888);
var state_61954__$1 = state_61954;
if(inst_61893){
var statearr_61981_62027 = state_61954__$1;
(statearr_61981_62027[(1)] = (14));

} else {
var statearr_61982_62028 = state_61954__$1;
(statearr_61982_62028[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (2))){
var inst_61875 = (state_61954[(10)]);
var inst_61875__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_61876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61877 = [sub_chan,inst_61875__$1];
var inst_61878 = (new cljs.core.PersistentVector(null,2,(5),inst_61876,inst_61877,null));
var state_61954__$1 = (function (){var statearr_61983 = state_61954;
(statearr_61983[(10)] = inst_61875__$1);

return statearr_61983;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61954__$1,(4),inst_61878);
} else {
if((state_val_61955 === (23))){
var inst_61928 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_61954__$1 = state_61954;
var statearr_61984_62029 = state_61954__$1;
(statearr_61984_62029[(2)] = inst_61928);

(statearr_61984_62029[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (19))){
var inst_61910 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61985_62030 = state_61954__$1;
(statearr_61985_62030[(2)] = inst_61910);

(statearr_61985_62030[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (11))){
var inst_61891 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_61954__$1 = state_61954;
var statearr_61986_62031 = state_61954__$1;
(statearr_61986_62031[(2)] = inst_61891);

(statearr_61986_62031[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (9))){
var inst_61870 = (state_61954[(8)]);
var inst_61920 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_61921 = (inst_61870 + (1));
var inst_61870__$1 = inst_61921;
var state_61954__$1 = (function (){var statearr_61987 = state_61954;
(statearr_61987[(8)] = inst_61870__$1);

(statearr_61987[(15)] = inst_61920);

return statearr_61987;
})();
var statearr_61988_62032 = state_61954__$1;
(statearr_61988_62032[(2)] = null);

(statearr_61988_62032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (5))){
var inst_61870 = (state_61954[(8)]);
var inst_61885 = cljs.core._EQ_.call(null,(2),inst_61870);
var state_61954__$1 = state_61954;
if(inst_61885){
var statearr_61989_62033 = state_61954__$1;
(statearr_61989_62033[(1)] = (8));

} else {
var statearr_61990_62034 = state_61954__$1;
(statearr_61990_62034[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (14))){
var inst_61888 = (state_61954[(7)]);
var inst_61895 = inst_61888.call(null);
var state_61954__$1 = state_61954;
var statearr_61991_62035 = state_61954__$1;
(statearr_61991_62035[(2)] = inst_61895);

(statearr_61991_62035[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (26))){
var inst_61881 = (state_61954[(9)]);
var inst_61932 = fluree.db.util.log.error.call(null,inst_61881);
var inst_61870 = (0);
var state_61954__$1 = (function (){var statearr_61992 = state_61954;
(statearr_61992[(8)] = inst_61870);

(statearr_61992[(16)] = inst_61932);

return statearr_61992;
})();
var statearr_61993_62036 = state_61954__$1;
(statearr_61993_62036[(2)] = null);

(statearr_61993_62036[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (16))){
var inst_61912 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61994_62037 = state_61954__$1;
(statearr_61994_62037[(2)] = inst_61912);

(statearr_61994_62037[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (30))){
var state_61954__$1 = state_61954;
var statearr_61995_62038 = state_61954__$1;
(statearr_61995_62038[(2)] = null);

(statearr_61995_62038[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (10))){
var inst_61924 = (state_61954[(2)]);
var state_61954__$1 = state_61954;
var statearr_61996_62039 = state_61954__$1;
(statearr_61996_62039[(2)] = inst_61924);

(statearr_61996_62039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (18))){
var state_61954__$1 = state_61954;
var statearr_61997_62040 = state_61954__$1;
(statearr_61997_62040[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61955 === (8))){
var inst_61888 = (state_61954[(7)]);
var inst_61887 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_61888__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61889 = (inst_61888__$1 == null);
var state_61954__$1 = (function (){var statearr_61999 = state_61954;
(statearr_61999[(17)] = inst_61887);

(statearr_61999[(7)] = inst_61888__$1);

return statearr_61999;
})();
if(cljs.core.truth_(inst_61889)){
var statearr_62000_62041 = state_61954__$1;
(statearr_62000_62041[(1)] = (11));

} else {
var statearr_62001_62042 = state_61954__$1;
(statearr_62001_62042[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_62002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62002[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_62002[(1)] = (1));

return statearr_62002;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_61954){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_61954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62003){var ex__2749__auto__ = e62003;
var statearr_62004_62043 = state_61954;
(statearr_62004_62043[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_61954[(4)]))){
var statearr_62005_62044 = state_61954;
(statearr_62005_62044[(1)] = cljs.core.first.call(null,(state_61954[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62045 = state_61954;
state_61954 = G__62045;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_61954){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_61954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62006 = f__2769__auto__.call(null);
(statearr_62006[(6)] = c__2768__auto__);

return statearr_62006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62047 = arguments.length;
switch (G__62047) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62048 = opts;
var map__62048__$1 = cljs.core.__destructure_map.call(null,map__62048);
var private$ = cljs.core.get.call(null,map__62048__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__62048__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62100){
var state_val_62101 = (state_62100[(1)]);
if((state_val_62101 === (7))){
var inst_62058 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62060 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62061 = (new cljs.core.PersistentVector(null,2,(5),inst_62059,inst_62060,null));
var inst_62062 = cljs.core.get_in.call(null,inst_62058,inst_62061);
var state_62100__$1 = state_62100;
var statearr_62102_62133 = state_62100__$1;
(statearr_62102_62133[(2)] = inst_62062);

(statearr_62102_62133[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (1))){
var state_62100__$1 = state_62100;
var statearr_62103_62134 = state_62100__$1;
(statearr_62103_62134[(2)] = null);

(statearr_62103_62134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (4))){
var inst_62049 = (state_62100[(2)]);
var state_62100__$1 = state_62100;
var statearr_62104_62135 = state_62100__$1;
(statearr_62104_62135[(2)] = inst_62049);

(statearr_62104_62135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (15))){
var inst_62069 = (state_62100[(7)]);
var inst_62088 = (state_62100[(2)]);
var inst_62089 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62090 = [(5000),inst_62088,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62091 = cljs.core.PersistentHashMap.fromArrays(inst_62089,inst_62090);
var inst_62092 = fluree.db.util.xhttp.get.call(null,inst_62069,inst_62091);
var state_62100__$1 = state_62100;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62100__$1,(16),inst_62092);
} else {
if((state_val_62101 === (13))){
var inst_62069 = (state_62100[(7)]);
var inst_62079 = (state_62100[(8)]);
var inst_62081 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62082 = [inst_62079];
var inst_62083 = cljs.core.PersistentHashMap.fromArrays(inst_62081,inst_62082);
var inst_62084 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_62069,inst_62083,private$);
var inst_62085 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62084);
var state_62100__$1 = state_62100;
var statearr_62105_62136 = state_62100__$1;
(statearr_62105_62136[(2)] = inst_62085);

(statearr_62105_62136[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (6))){
var inst_62055 = (state_62100[(9)]);
var state_62100__$1 = state_62100;
var statearr_62106_62137 = state_62100__$1;
(statearr_62106_62137[(2)] = inst_62055);

(statearr_62106_62137[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (3))){
var inst_62098 = (state_62100[(2)]);
var state_62100__$1 = state_62100;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62100__$1,inst_62098);
} else {
if((state_val_62101 === (12))){
var inst_62079 = (state_62100[(2)]);
var state_62100__$1 = (function (){var statearr_62107 = state_62100;
(statearr_62107[(8)] = inst_62079);

return statearr_62107;
})();
if(cljs.core.truth_(private$)){
var statearr_62108_62138 = state_62100__$1;
(statearr_62108_62138[(1)] = (13));

} else {
var statearr_62109_62139 = state_62100__$1;
(statearr_62109_62139[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (2))){
var inst_62055 = (state_62100[(9)]);
var _ = (function (){var statearr_62110 = state_62100;
(statearr_62110[(4)] = cljs.core.cons.call(null,(5),(state_62100[(4)])));

return statearr_62110;
})();
var inst_62055__$1 = jwt;
var state_62100__$1 = (function (){var statearr_62111 = state_62100;
(statearr_62111[(9)] = inst_62055__$1);

return statearr_62111;
})();
if(cljs.core.truth_(inst_62055__$1)){
var statearr_62112_62140 = state_62100__$1;
(statearr_62112_62140[(1)] = (6));

} else {
var statearr_62113_62141 = state_62100__$1;
(statearr_62113_62141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (11))){
var inst_62073 = (state_62100[(10)]);
var state_62100__$1 = state_62100;
var statearr_62115_62142 = state_62100__$1;
(statearr_62115_62142[(2)] = inst_62073);

(statearr_62115_62142[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (9))){
var inst_62065 = (state_62100[(11)]);
var inst_62064 = (state_62100[(12)]);
var inst_62068 = (state_62100[(2)]);
var inst_62069 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62068),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62065)].join('');
var inst_62071 = ["Accept"];
var inst_62072 = ["application/json"];
var inst_62073 = cljs.core.PersistentHashMap.fromArrays(inst_62071,inst_62072);
var state_62100__$1 = (function (){var statearr_62116 = state_62100;
(statearr_62116[(7)] = inst_62069);

(statearr_62116[(10)] = inst_62073);

return statearr_62116;
})();
if(cljs.core.truth_(inst_62064)){
var statearr_62117_62143 = state_62100__$1;
(statearr_62117_62143[(1)] = (10));

} else {
var statearr_62118_62144 = state_62100__$1;
(statearr_62118_62144[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (5))){
var _ = (function (){var statearr_62119 = state_62100;
(statearr_62119[(4)] = cljs.core.rest.call(null,(state_62100[(4)])));

return statearr_62119;
})();
var state_62100__$1 = state_62100;
var ex62114 = (state_62100__$1[(2)]);
var statearr_62120_62145 = state_62100__$1;
(statearr_62120_62145[(5)] = ex62114);


if((ex62114 instanceof Error)){
var statearr_62121_62146 = state_62100__$1;
(statearr_62121_62146[(1)] = (4));

(statearr_62121_62146[(5)] = null);

} else {
throw ex62114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (14))){
var inst_62079 = (state_62100[(8)]);
var state_62100__$1 = state_62100;
var statearr_62122_62147 = state_62100__$1;
(statearr_62122_62147[(2)] = inst_62079);

(statearr_62122_62147[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (16))){
var inst_62094 = (state_62100[(2)]);
var inst_62095 = fluree.db.util.async.throw_err.call(null,inst_62094);
var _ = (function (){var statearr_62123 = state_62100;
(statearr_62123[(4)] = cljs.core.rest.call(null,(state_62100[(4)])));

return statearr_62123;
})();
var state_62100__$1 = state_62100;
var statearr_62124_62148 = state_62100__$1;
(statearr_62124_62148[(2)] = inst_62095);

(statearr_62124_62148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (10))){
var inst_62064 = (state_62100[(12)]);
var inst_62073 = (state_62100[(10)]);
var inst_62075 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62064)].join('');
var inst_62076 = cljs.core.assoc.call(null,inst_62073,"Authorization",inst_62075);
var state_62100__$1 = state_62100;
var statearr_62125_62149 = state_62100__$1;
(statearr_62125_62149[(2)] = inst_62076);

(statearr_62125_62149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62101 === (8))){
var inst_62064 = (state_62100[(2)]);
var inst_62065 = clojure.string.replace.call(null,k,"_","/");
var inst_62066 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_62100__$1 = (function (){var statearr_62126 = state_62100;
(statearr_62126[(11)] = inst_62065);

(statearr_62126[(12)] = inst_62064);

return statearr_62126;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62100__$1,(9),inst_62066);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_62127 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62127[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_62127[(1)] = (1));

return statearr_62127;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_62100){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62100);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62128){var ex__2749__auto__ = e62128;
var statearr_62129_62150 = state_62100;
(statearr_62129_62150[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62100[(4)]))){
var statearr_62130_62151 = state_62100;
(statearr_62130_62151[(1)] = cljs.core.first.call(null,(state_62100[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62152 = state_62100;
state_62100 = G__62152;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_62100){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_62100);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62131 = f__2769__auto__.call(null);
(statearr_62131[(6)] = c__2768__auto__);

return statearr_62131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62153_SHARP_){
if(cljs.core.truth_(p1__62153_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62154_SHARP_){
var or__4253__auto__ = p1__62154_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e62155){var e = e62155;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62156 = opts;
var map__62156__$1 = cljs.core.__destructure_map.call(null,map__62156);
var sub_chan = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__62156__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62197 = arguments.length;
var i__4865__auto___62198 = (0);
while(true){
if((i__4865__auto___62198 < len__4864__auto___62197)){
args__4870__auto__.push((arguments[i__4865__auto___62198]));

var G__62199 = (i__4865__auto___62198 + (1));
i__4865__auto___62198 = G__62199;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62159){
var vec__62160 = p__62159;
var opts = cljs.core.nth.call(null,vec__62160,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___62200 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62180){
var state_val_62181 = (state_62180[(1)]);
if((state_val_62181 === (1))){
var inst_62163 = fluree.db.connection.get_socket.call(null,conn);
var state_62180__$1 = state_62180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62180__$1,(2),inst_62163);
} else {
if((state_val_62181 === (2))){
var inst_62166 = (state_62180[(7)]);
var inst_62165 = (state_62180[(8)]);
var inst_62165__$1 = (state_62180[(2)]);
var inst_62166__$1 = (inst_62165__$1 == null);
var state_62180__$1 = (function (){var statearr_62182 = state_62180;
(statearr_62182[(7)] = inst_62166__$1);

(statearr_62182[(8)] = inst_62165__$1);

return statearr_62182;
})();
if(cljs.core.truth_(inst_62166__$1)){
var statearr_62183_62201 = state_62180__$1;
(statearr_62183_62201[(1)] = (3));

} else {
var statearr_62184_62202 = state_62180__$1;
(statearr_62184_62202[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (3))){
var inst_62166 = (state_62180[(7)]);
var state_62180__$1 = state_62180;
var statearr_62185_62203 = state_62180__$1;
(statearr_62185_62203[(2)] = inst_62166);

(statearr_62185_62203[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (4))){
var inst_62165 = (state_62180[(8)]);
var inst_62169 = fluree.db.util.core.exception_QMARK_.call(null,inst_62165);
var state_62180__$1 = state_62180;
var statearr_62186_62204 = state_62180__$1;
(statearr_62186_62204[(2)] = inst_62169);

(statearr_62186_62204[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (5))){
var inst_62171 = (state_62180[(2)]);
var state_62180__$1 = state_62180;
if(cljs.core.truth_(inst_62171)){
var statearr_62187_62205 = state_62180__$1;
(statearr_62187_62205[(1)] = (6));

} else {
var statearr_62188_62206 = state_62180__$1;
(statearr_62188_62206[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (6))){
var inst_62165 = (state_62180[(8)]);
var inst_62173 = fluree.db.util.log.error.call(null,inst_62165,"Cannot establish connection to a healthy server, disconnecting.");
var inst_62174 = cljs.core.async.close_BANG_.call(null,conn);
var state_62180__$1 = (function (){var statearr_62189 = state_62180;
(statearr_62189[(9)] = inst_62173);

return statearr_62189;
})();
var statearr_62190_62207 = state_62180__$1;
(statearr_62190_62207[(2)] = inst_62174);

(statearr_62190_62207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (7))){
var inst_62176 = fluree.db.connection.msg_consumer.call(null,conn);
var state_62180__$1 = state_62180;
var statearr_62191_62208 = state_62180__$1;
(statearr_62191_62208[(2)] = inst_62176);

(statearr_62191_62208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62181 === (8))){
var inst_62178 = (state_62180[(2)]);
var state_62180__$1 = state_62180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62180__$1,inst_62178);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_62192 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62192[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_62192[(1)] = (1));

return statearr_62192;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_62180){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62193){var ex__2749__auto__ = e62193;
var statearr_62194_62209 = state_62180;
(statearr_62194_62209[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62180[(4)]))){
var statearr_62195_62210 = state_62180;
(statearr_62195_62210[(1)] = cljs.core.first.call(null,(state_62180[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62211 = state_62180;
state_62180 = G__62211;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_62180){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_62180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62196 = f__2769__auto__.call(null);
(statearr_62196[(6)] = c__2768__auto___62200);

return statearr_62196;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62157){
var G__62158 = cljs.core.first.call(null,seq62157);
var seq62157__$1 = cljs.core.next.call(null,seq62157);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62158,seq62157__$1);
}));

