// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62829 = arguments.length;
var i__4865__auto___62830 = (0);
while(true){
if((i__4865__auto___62830 < len__4864__auto___62829)){
args__4870__auto__.push((arguments[i__4865__auto___62830]));

var G__62831 = (i__4865__auto___62830 + (1));
i__4865__auto___62830 = G__62831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__62761){
var vec__62762 = p__62761;
var opts = cljs.core.nth.call(null,vec__62762,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___62832 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62806){
var state_val_62807 = (state_62806[(1)]);
if((state_val_62807 === (7))){
var inst_62792 = (state_62806[(7)]);
var inst_62783 = (state_62806[(8)]);
var inst_62794 = fluree.db.time_travel.as_of_block.call(null,inst_62792,inst_62783);
var state_62806__$1 = state_62806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62806__$1,(10),inst_62794);
} else {
if((state_val_62807 === (1))){
var state_62806__$1 = state_62806;
var statearr_62808_62833 = state_62806__$1;
(statearr_62808_62833[(2)] = null);

(statearr_62808_62833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (4))){
var inst_62765 = (state_62806[(2)]);
var inst_62766 = fluree.db.util.log.error.call(null,inst_62765);
var inst_62767 = cljs.core.async.put_BANG_.call(null,pc,inst_62765);
var inst_62768 = cljs.core.async.close_BANG_.call(null,pc);
var state_62806__$1 = (function (){var statearr_62809 = state_62806;
(statearr_62809[(9)] = inst_62767);

(statearr_62809[(10)] = inst_62766);

return statearr_62809;
})();
var statearr_62810_62834 = state_62806__$1;
(statearr_62810_62834[(2)] = inst_62768);

(statearr_62810_62834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (6))){
var inst_62787 = (state_62806[(11)]);
var inst_62783 = (state_62806[(8)]);
var inst_62786 = (state_62806[(12)]);
var inst_62790 = (state_62806[(2)]);
var inst_62791 = fluree.db.util.async.throw_err.call(null,inst_62790);
var inst_62792 = cljs.core.assoc.call(null,inst_62791,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_62786,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_62787);
var state_62806__$1 = (function (){var statearr_62811 = state_62806;
(statearr_62811[(7)] = inst_62792);

return statearr_62811;
})();
if(cljs.core.truth_(inst_62783)){
var statearr_62812_62835 = state_62806__$1;
(statearr_62812_62835[(1)] = (7));

} else {
var statearr_62813_62836 = state_62806__$1;
(statearr_62813_62836[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (3))){
var inst_62804 = (state_62806[(2)]);
var state_62806__$1 = state_62806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62806__$1,inst_62804);
} else {
if((state_val_62807 === (2))){
var _ = (function (){var statearr_62815 = state_62806;
(statearr_62815[(4)] = cljs.core.cons.call(null,(5),(state_62806[(4)])));

return statearr_62815;
})();
var inst_62778 = opts;
var inst_62779 = cljs.core.__destructure_map.call(null,inst_62778);
var inst_62780 = cljs.core.get.call(null,inst_62779,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_62781 = cljs.core.get.call(null,inst_62779,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_62782 = cljs.core.get.call(null,inst_62779,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_62783 = cljs.core.get.call(null,inst_62779,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62784 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_62785 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_62786 = cljs.core.nth.call(null,inst_62785,(0),null);
var inst_62787 = cljs.core.nth.call(null,inst_62785,(1),null);
var inst_62788 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_62806__$1 = (function (){var statearr_62816 = state_62806;
(statearr_62816[(11)] = inst_62787);

(statearr_62816[(13)] = inst_62784);

(statearr_62816[(14)] = inst_62782);

(statearr_62816[(8)] = inst_62783);

(statearr_62816[(15)] = inst_62781);

(statearr_62816[(16)] = inst_62780);

(statearr_62816[(12)] = inst_62786);

return statearr_62816;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62806__$1,(6),inst_62788);
} else {
if((state_val_62807 === (9))){
var inst_62800 = (state_62806[(2)]);
var inst_62801 = cljs.core.async.put_BANG_.call(null,pc,inst_62800);
var _ = (function (){var statearr_62817 = state_62806;
(statearr_62817[(4)] = cljs.core.rest.call(null,(state_62806[(4)])));

return statearr_62817;
})();
var state_62806__$1 = state_62806;
var statearr_62818_62837 = state_62806__$1;
(statearr_62818_62837[(2)] = inst_62801);

(statearr_62818_62837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (5))){
var _ = (function (){var statearr_62819 = state_62806;
(statearr_62819[(4)] = cljs.core.rest.call(null,(state_62806[(4)])));

return statearr_62819;
})();
var state_62806__$1 = state_62806;
var ex62814 = (state_62806__$1[(2)]);
var statearr_62820_62838 = state_62806__$1;
(statearr_62820_62838[(5)] = ex62814);


var statearr_62821_62839 = state_62806__$1;
(statearr_62821_62839[(1)] = (4));

(statearr_62821_62839[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (10))){
var inst_62796 = (state_62806[(2)]);
var inst_62797 = fluree.db.util.async.throw_err.call(null,inst_62796);
var state_62806__$1 = state_62806;
var statearr_62822_62840 = state_62806__$1;
(statearr_62822_62840[(2)] = inst_62797);

(statearr_62822_62840[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62807 === (8))){
var inst_62792 = (state_62806[(7)]);
var state_62806__$1 = state_62806;
var statearr_62823_62841 = state_62806__$1;
(statearr_62823_62841[(2)] = inst_62792);

(statearr_62823_62841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_62824 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62824[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_62824[(1)] = (1));

return statearr_62824;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_62806){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e62825){var ex__2749__auto__ = e62825;
var statearr_62826_62842 = state_62806;
(statearr_62826_62842[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62806[(4)]))){
var statearr_62827_62843 = state_62806;
(statearr_62827_62843[(1)] = cljs.core.first.call(null,(state_62806[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62844 = state_62806;
state_62806 = G__62844;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_62806){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_62806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_62828 = f__2769__auto__.call(null);
(statearr_62828[(6)] = c__2768__auto___62832);

return statearr_62828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq62758){
var G__62759 = cljs.core.first.call(null,seq62758);
var seq62758__$1 = cljs.core.next.call(null,seq62758);
var G__62760 = cljs.core.first.call(null,seq62758__$1);
var seq62758__$2 = cljs.core.next.call(null,seq62758__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62759,G__62760,seq62758__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_.call(null,val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__62846 = arguments.length;
switch (G__62846) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_62972){
var state_val_62973 = (state_62972[(1)]);
if((state_val_62973 === (7))){
var inst_62872 = (state_62972[(7)]);
var inst_62862 = (state_62972[(8)]);
var inst_62874 = fluree.db.time_travel.as_of_block.call(null,inst_62872,inst_62862);
var state_62972__$1 = state_62972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62972__$1,(10),inst_62874);
} else {
if((state_val_62973 === (20))){
var inst_62866 = (state_62972[(9)]);
var state_62972__$1 = state_62972;
var statearr_62974_63054 = state_62972__$1;
(statearr_62974_63054[(2)] = inst_62866);

(statearr_62974_63054[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (27))){
var inst_62860 = (state_62972[(10)]);
var state_62972__$1 = state_62972;
var statearr_62975_63055 = state_62972__$1;
(statearr_62975_63055[(2)] = inst_62860);

(statearr_62975_63055[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (1))){
var state_62972__$1 = state_62972;
var statearr_62976_63056 = state_62972__$1;
(statearr_62976_63056[(2)] = null);

(statearr_62976_63056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (24))){
var inst_62869 = (state_62972[(11)]);
var state_62972__$1 = state_62972;
if(cljs.core.truth_(inst_62869)){
var statearr_62977_63057 = state_62972__$1;
(statearr_62977_63057[(1)] = (26));

} else {
var statearr_62978_63058 = state_62972__$1;
(statearr_62978_63058[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (39))){
var inst_62934 = (state_62972[(12)]);
var inst_62937 = cljs.core.ex_data.call(null,inst_62934);
var inst_62938 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62939 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62937);
var inst_62940 = cljs.core.ex_message.call(null,inst_62934);
var inst_62941 = [inst_62939,inst_62940,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62942 = cljs.core.PersistentHashMap.fromArrays(inst_62938,inst_62941);
var state_62972__$1 = state_62972;
var statearr_62979_63059 = state_62972__$1;
(statearr_62979_63059[(2)] = inst_62942);

(statearr_62979_63059[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (46))){
var inst_62934 = (state_62972[(12)]);
var state_62972__$1 = state_62972;
var statearr_62980_63060 = state_62972__$1;
(statearr_62980_63060[(2)] = inst_62934);

(statearr_62980_63060[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (4))){
var inst_62847 = (state_62972[(2)]);
var inst_62848 = fluree.db.util.log.error.call(null,inst_62847);
var inst_62849 = cljs.core.ex_data.call(null,inst_62847);
var inst_62850 = cljs.core.ex_message.call(null,inst_62847);
var inst_62851 = cljs.core.assoc.call(null,inst_62849,new cljs.core.Keyword(null,"message","message",-406056002),inst_62850);
var state_62972__$1 = (function (){var statearr_62981 = state_62972;
(statearr_62981[(13)] = inst_62848);

return statearr_62981;
})();
var statearr_62982_63061 = state_62972__$1;
(statearr_62982_63061[(2)] = inst_62851);

(statearr_62982_63061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (15))){
var state_62972__$1 = state_62972;
var statearr_62983_63062 = state_62972__$1;
(statearr_62983_63062[(2)] = (1000000));

(statearr_62983_63062[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (48))){
var inst_62934 = (state_62972[(12)]);
var state_62972__$1 = state_62972;
var statearr_62984_63063 = state_62972__$1;
(statearr_62984_63063[(2)] = inst_62934);

(statearr_62984_63063[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (50))){
var inst_62961 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_62985_63064 = state_62972__$1;
(statearr_62985_63064[(2)] = inst_62961);

(statearr_62985_63064[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (21))){
var inst_62865 = (state_62972[(14)]);
var state_62972__$1 = state_62972;
if(cljs.core.truth_(inst_62865)){
var statearr_62986_63065 = state_62972__$1;
(statearr_62986_63065[(1)] = (23));

} else {
var statearr_62987_63066 = state_62972__$1;
(statearr_62987_63066[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (31))){
var inst_62923 = (state_62972[(2)]);
var inst_62924 = cljs.core.not.call(null,inst_62923);
var state_62972__$1 = state_62972;
if(inst_62924){
var statearr_62988_63067 = state_62972__$1;
(statearr_62988_63067[(1)] = (35));

} else {
var statearr_62989_63068 = state_62972__$1;
(statearr_62989_63068[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (32))){
var inst_62867 = (state_62972[(15)]);
var state_62972__$1 = state_62972;
var statearr_62990_63069 = state_62972__$1;
(statearr_62990_63069[(2)] = inst_62867);

(statearr_62990_63069[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (40))){
var inst_62897 = (state_62972[(16)]);
var state_62972__$1 = state_62972;
if(cljs.core.truth_(inst_62897)){
var statearr_62991_63070 = state_62972__$1;
(statearr_62991_63070[(1)] = (42));

} else {
var statearr_62992_63071 = state_62972__$1;
(statearr_62992_63071[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (33))){
var inst_62863 = (state_62972[(17)]);
var state_62972__$1 = state_62972;
var statearr_62993_63072 = state_62972__$1;
(statearr_62993_63072[(2)] = inst_62863);

(statearr_62993_63072[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (13))){
var inst_62892 = (state_62972[(18)]);
var inst_62868 = (state_62972[(19)]);
var inst_62890 = (state_62972[(2)]);
var inst_62891 = cljs.core.volatile_BANG_.call(null,(0));
var inst_62892__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62868);
var state_62972__$1 = (function (){var statearr_62994 = state_62972;
(statearr_62994[(20)] = inst_62891);

(statearr_62994[(21)] = inst_62890);

(statearr_62994[(18)] = inst_62892__$1);

return statearr_62994;
})();
if(cljs.core.truth_(inst_62892__$1)){
var statearr_62995_63073 = state_62972__$1;
(statearr_62995_63073[(1)] = (14));

} else {
var statearr_62996_63074 = state_62972__$1;
(statearr_62996_63074[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (22))){
var inst_62913 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_62997_63075 = state_62972__$1;
(statearr_62997_63075[(2)] = inst_62913);

(statearr_62997_63075[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (36))){
var inst_62880 = (state_62972[(22)]);
var inst_62899 = (state_62972[(23)]);
var inst_62930 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_62899);
var inst_62931 = fluree.db.query.fql.query.call(null,inst_62880,inst_62930);
var state_62972__$1 = state_62972;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62972__$1,(38),inst_62931);
} else {
if((state_val_62973 === (41))){
var inst_62965 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_62998_63076 = state_62972__$1;
(statearr_62998_63076[(2)] = inst_62965);

(statearr_62998_63076[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (43))){
var state_62972__$1 = state_62972;
var statearr_62999_63077 = state_62972__$1;
(statearr_62999_63077[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (29))){
var inst_62867 = (state_62972[(15)]);
var state_62972__$1 = state_62972;
if(cljs.core.truth_(inst_62867)){
var statearr_63001_63078 = state_62972__$1;
(statearr_63001_63078[(1)] = (32));

} else {
var statearr_63002_63079 = state_62972__$1;
(statearr_63002_63079[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (44))){
var inst_62963 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_63003_63080 = state_62972__$1;
(statearr_63003_63080[(2)] = inst_62963);

(statearr_63003_63080[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (6))){
var inst_62862 = (state_62972[(8)]);
var inst_62871 = (state_62972[(2)]);
var inst_62872 = fluree.db.util.async.throw_err.call(null,inst_62871);
var state_62972__$1 = (function (){var statearr_63004 = state_62972;
(statearr_63004[(7)] = inst_62872);

return statearr_63004;
})();
if(cljs.core.truth_(inst_62862)){
var statearr_63005_63081 = state_62972__$1;
(statearr_63005_63081[(1)] = (7));

} else {
var statearr_63006_63082 = state_62972__$1;
(statearr_63006_63082[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (28))){
var inst_62909 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_63007_63083 = state_62972__$1;
(statearr_63007_63083[(2)] = inst_62909);

(statearr_63007_63083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (25))){
var inst_62911 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_63008_63084 = state_62972__$1;
(statearr_63008_63084[(2)] = inst_62911);

(statearr_63008_63084[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (34))){
var inst_62920 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
var statearr_63009_63085 = state_62972__$1;
(statearr_63009_63085[(2)] = inst_62920);

(statearr_63009_63085[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (17))){
var inst_62861 = (state_62972[(24)]);
var state_62972__$1 = state_62972;
var statearr_63010_63086 = state_62972__$1;
(statearr_63010_63086[(2)] = inst_62861);

(statearr_63010_63086[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (3))){
var inst_62970 = (state_62972[(2)]);
var state_62972__$1 = state_62972;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62972__$1,inst_62970);
} else {
if((state_val_62973 === (12))){
var inst_62888 = cljs.core.PersistentHashMap.EMPTY;
var state_62972__$1 = state_62972;
var statearr_63011_63087 = state_62972__$1;
(statearr_63011_63087[(2)] = inst_62888);

(statearr_63011_63087[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (2))){
var _ = (function (){var statearr_63012 = state_62972;
(statearr_63012[(4)] = cljs.core.cons.call(null,(5),(state_62972[(4)])));

return statearr_63012;
})();
var inst_62858 = query_map;
var inst_62859 = cljs.core.__destructure_map.call(null,inst_62858);
var inst_62860 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_62861 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_62862 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62863 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_62864 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_62865 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_62866 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_62867 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_62868 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_62869 = cljs.core.get.call(null,inst_62859,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_62972__$1 = (function (){var statearr_63013 = state_62972;
(statearr_63013[(17)] = inst_62863);

(statearr_63013[(9)] = inst_62866);

(statearr_63013[(15)] = inst_62867);

(statearr_63013[(10)] = inst_62860);

(statearr_63013[(14)] = inst_62865);

(statearr_63013[(25)] = inst_62864);

(statearr_63013[(11)] = inst_62869);

(statearr_63013[(8)] = inst_62862);

(statearr_63013[(19)] = inst_62868);

(statearr_63013[(24)] = inst_62861);

return statearr_63013;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62972__$1,(6),sources);
} else {
if((state_val_62973 === (23))){
var inst_62865 = (state_62972[(14)]);
var state_62972__$1 = state_62972;
var statearr_63014_63088 = state_62972__$1;
(statearr_63014_63088[(2)] = inst_62865);

(statearr_63014_63088[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (47))){
var inst_62880 = (state_62972[(22)]);
var inst_62891 = (state_62972[(20)]);
var inst_62945 = (state_62972[(26)]);
var inst_62898 = (state_62972[(27)]);
var inst_62951 = (state_62972[(2)]);
var inst_62952 = cljs.core.deref.call(null,inst_62891);
var inst_62953 = fluree.db.util.core.response_time_formatted.call(null,inst_62898);
var inst_62954 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_62880);
var inst_62955 = [(200),inst_62951,inst_62952,inst_62953,inst_62954];
var inst_62956 = cljs.core.PersistentHashMap.fromArrays(inst_62945,inst_62955);
var state_62972__$1 = state_62972;
var statearr_63015_63089 = state_62972__$1;
(statearr_63015_63089[(2)] = inst_62956);

(statearr_63015_63089[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (35))){
var inst_62926 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62927 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62928 = cljs.core.PersistentHashMap.fromArrays(inst_62926,inst_62927);
var state_62972__$1 = state_62972;
var statearr_63016_63090 = state_62972__$1;
(statearr_63016_63090[(2)] = inst_62928);

(statearr_63016_63090[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (19))){
var inst_62915 = (state_62972[(28)]);
var inst_62915__$1 = (state_62972[(2)]);
var state_62972__$1 = (function (){var statearr_63017 = state_62972;
(statearr_63017[(28)] = inst_62915__$1);

return statearr_63017;
})();
if(cljs.core.truth_(inst_62915__$1)){
var statearr_63018_63091 = state_62972__$1;
(statearr_63018_63091[(1)] = (29));

} else {
var statearr_63019_63092 = state_62972__$1;
(statearr_63019_63092[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (11))){
var inst_62880 = (state_62972[(22)]);
var inst_62881 = (state_62972[(29)]);
var inst_62864 = (state_62972[(25)]);
var inst_62883 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_62880);
var inst_62884 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_62881);
var inst_62885 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_62880);
var inst_62886 = fluree.db.api_js.get_sources.call(null,inst_62881,inst_62883,inst_62884,inst_62885,inst_62864,db_fn);
var state_62972__$1 = state_62972;
var statearr_63021_63093 = state_62972__$1;
(statearr_63021_63093[(2)] = inst_62886);

(statearr_63021_63093[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (9))){
var inst_62880 = (state_62972[(22)]);
var inst_62864 = (state_62972[(25)]);
var inst_62880__$1 = (state_62972[(2)]);
var inst_62881 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_62880__$1);
var state_62972__$1 = (function (){var statearr_63022 = state_62972;
(statearr_63022[(22)] = inst_62880__$1);

(statearr_63022[(29)] = inst_62881);

return statearr_63022;
})();
if(cljs.core.truth_(inst_62864)){
var statearr_63023_63094 = state_62972__$1;
(statearr_63023_63094[(1)] = (11));

} else {
var statearr_63024_63095 = state_62972__$1;
(statearr_63024_63095[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (5))){
var _ = (function (){var statearr_63025 = state_62972;
(statearr_63025[(4)] = cljs.core.rest.call(null,(state_62972[(4)])));

return statearr_63025;
})();
var state_62972__$1 = state_62972;
var ex63020 = (state_62972__$1[(2)]);
var statearr_63026_63096 = state_62972__$1;
(statearr_63026_63096[(5)] = ex63020);


var statearr_63027_63097 = state_62972__$1;
(statearr_63027_63097[(1)] = (4));

(statearr_63027_63097[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (14))){
var inst_62892 = (state_62972[(18)]);
var state_62972__$1 = state_62972;
var statearr_63028_63098 = state_62972__$1;
(statearr_63028_63098[(2)] = inst_62892);

(statearr_63028_63098[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (45))){
var inst_62934 = (state_62972[(12)]);
var inst_62948 = cljs.core.doall.call(null,inst_62934);
var state_62972__$1 = state_62972;
var statearr_63029_63099 = state_62972__$1;
(statearr_63029_63099[(2)] = inst_62948);

(statearr_63029_63099[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (26))){
var inst_62869 = (state_62972[(11)]);
var state_62972__$1 = state_62972;
var statearr_63030_63100 = state_62972__$1;
(statearr_63030_63100[(2)] = inst_62869);

(statearr_63030_63100[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (16))){
var inst_62891 = (state_62972[(20)]);
var inst_62890 = (state_62972[(21)]);
var inst_62868 = (state_62972[(19)]);
var inst_62861 = (state_62972[(24)]);
var inst_62896 = (state_62972[(2)]);
var inst_62897 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_62868);
var inst_62898 = fluree.db.util.core.current_time_millis.call(null);
var inst_62899 = cljs.core.assoc.call(null,inst_62868,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_62890,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_62896,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_62891);
var state_62972__$1 = (function (){var statearr_63031 = state_62972;
(statearr_63031[(16)] = inst_62897);

(statearr_63031[(27)] = inst_62898);

(statearr_63031[(23)] = inst_62899);

return statearr_63031;
})();
if(cljs.core.truth_(inst_62861)){
var statearr_63032_63101 = state_62972__$1;
(statearr_63032_63101[(1)] = (17));

} else {
var statearr_63033_63102 = state_62972__$1;
(statearr_63033_63102[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (38))){
var inst_62934 = (state_62972[(12)]);
var inst_62933 = (state_62972[(2)]);
var inst_62934__$1 = fluree.db.util.async.throw_err.call(null,inst_62933);
var inst_62935 = (inst_62934__$1 instanceof cljs.core.ExceptionInfo);
var state_62972__$1 = (function (){var statearr_63034 = state_62972;
(statearr_63034[(12)] = inst_62934__$1);

return statearr_63034;
})();
if(cljs.core.truth_(inst_62935)){
var statearr_63035_63103 = state_62972__$1;
(statearr_63035_63103[(1)] = (39));

} else {
var statearr_63036_63104 = state_62972__$1;
(statearr_63036_63104[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (30))){
var inst_62915 = (state_62972[(28)]);
var state_62972__$1 = state_62972;
var statearr_63037_63105 = state_62972__$1;
(statearr_63037_63105[(2)] = inst_62915);

(statearr_63037_63105[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (10))){
var inst_62876 = (state_62972[(2)]);
var inst_62877 = fluree.db.util.async.throw_err.call(null,inst_62876);
var state_62972__$1 = state_62972;
var statearr_63038_63106 = state_62972__$1;
(statearr_63038_63106[(2)] = inst_62877);

(statearr_63038_63106[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (18))){
var inst_62866 = (state_62972[(9)]);
var state_62972__$1 = state_62972;
if(cljs.core.truth_(inst_62866)){
var statearr_63039_63107 = state_62972__$1;
(statearr_63039_63107[(1)] = (20));

} else {
var statearr_63040_63108 = state_62972__$1;
(statearr_63040_63108[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (42))){
var inst_62934 = (state_62972[(12)]);
var inst_62945 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_62946 = cljs.core.sequential_QMARK_.call(null,inst_62934);
var state_62972__$1 = (function (){var statearr_63041 = state_62972;
(statearr_63041[(26)] = inst_62945);

return statearr_63041;
})();
if(inst_62946){
var statearr_63042_63109 = state_62972__$1;
(statearr_63042_63109[(1)] = (45));

} else {
var statearr_63043_63110 = state_62972__$1;
(statearr_63043_63110[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (37))){
var inst_62967 = (state_62972[(2)]);
var _ = (function (){var statearr_63044 = state_62972;
(statearr_63044[(4)] = cljs.core.rest.call(null,(state_62972[(4)])));

return statearr_63044;
})();
var state_62972__$1 = state_62972;
var statearr_63045_63111 = state_62972__$1;
(statearr_63045_63111[(2)] = inst_62967);

(statearr_63045_63111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (8))){
var inst_62872 = (state_62972[(7)]);
var state_62972__$1 = state_62972;
var statearr_63046_63112 = state_62972__$1;
(statearr_63046_63112[(2)] = inst_62872);

(statearr_63046_63112[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62973 === (49))){
var state_62972__$1 = state_62972;
var statearr_63047_63113 = state_62972__$1;
(statearr_63047_63113[(2)] = null);

(statearr_63047_63113[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_63048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63048[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_63048[(1)] = (1));

return statearr_63048;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_62972){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_62972);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63049){var ex__2749__auto__ = e63049;
var statearr_63050_63114 = state_62972;
(statearr_63050_63114[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_62972[(4)]))){
var statearr_63051_63115 = state_62972;
(statearr_63051_63115[(1)] = cljs.core.first.call(null,(state_62972[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63116 = state_62972;
state_62972 = G__63116;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_62972){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_62972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63052 = f__2769__auto__.call(null);
(statearr_63052[(6)] = c__2768__auto__);

return statearr_63052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__63117_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__63117_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63139){
var state_val_63140 = (state_63139[(1)]);
if((state_val_63140 === (1))){
var inst_63121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63122 = [resp_chan,timeout_chan];
var inst_63123 = (new cljs.core.PersistentVector(null,2,(5),inst_63121,inst_63122,null));
var state_63139__$1 = state_63139;
return cljs.core.async.ioc_alts_BANG_.call(null,state_63139__$1,(2),inst_63123);
} else {
if((state_val_63140 === (2))){
var inst_63125 = (state_63139[(2)]);
var inst_63126 = cljs.core.nth.call(null,inst_63125,(0),null);
var inst_63127 = cljs.core.nth.call(null,inst_63125,(1),null);
var inst_63128 = cljs.core._EQ_.call(null,timeout_chan,inst_63127);
var state_63139__$1 = (function (){var statearr_63141 = state_63139;
(statearr_63141[(7)] = inst_63126);

return statearr_63141;
})();
if(inst_63128){
var statearr_63142_63152 = state_63139__$1;
(statearr_63142_63152[(1)] = (3));

} else {
var statearr_63143_63153 = state_63139__$1;
(statearr_63143_63153[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63140 === (3))){
var inst_63130 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_63131 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63132 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_63133 = [tid,(408),inst_63132];
var inst_63134 = cljs.core.PersistentHashMap.fromArrays(inst_63131,inst_63133);
var state_63139__$1 = (function (){var statearr_63144 = state_63139;
(statearr_63144[(8)] = inst_63130);

return statearr_63144;
})();
var statearr_63145_63154 = state_63139__$1;
(statearr_63145_63154[(2)] = inst_63134);

(statearr_63145_63154[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63140 === (4))){
var inst_63126 = (state_63139[(7)]);
var state_63139__$1 = state_63139;
var statearr_63146_63155 = state_63139__$1;
(statearr_63146_63155[(2)] = inst_63126);

(statearr_63146_63155[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63140 === (5))){
var inst_63137 = (state_63139[(2)]);
var state_63139__$1 = state_63139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63139__$1,inst_63137);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_63147 = [null,null,null,null,null,null,null,null,null];
(statearr_63147[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_63147[(1)] = (1));

return statearr_63147;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_63139){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63148){var ex__2749__auto__ = e63148;
var statearr_63149_63156 = state_63139;
(statearr_63149_63156[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63139[(4)]))){
var statearr_63150_63157 = state_63139;
(statearr_63150_63157[(1)] = cljs.core.first.call(null,(state_63139[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63158 = state_63139;
state_63139 = G__63158;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_63139){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_63139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63151 = f__2769__auto__.call(null);
(statearr_63151[(6)] = c__2768__auto__);

return statearr_63151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__63160 = arguments.length;
switch (G__63160) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__63161 = opts;
var map__63161__$1 = cljs.core.__destructure_map.call(null,map__63161);
var auth = cljs.core.get.call(null,map__63161__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__63161__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__63161__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__63161__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__63162 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__63162,(0),null);
var authority = cljs.core.nth.call(null,vec__63162,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e63165){var e = e63165;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__63168 = arguments.length;
switch (G__63168) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63234){
var state_val_63235 = (state_63234[(1)]);
if((state_val_63235 === (7))){
var inst_63190 = (state_63234[(7)]);
var inst_63188 = (state_63234[(8)]);
var inst_63185 = (state_63234[(9)]);
var inst_63189 = (state_63234[(10)]);
var inst_63187 = (state_63234[(11)]);
var inst_63203 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63204 = [ledger,txn,inst_63185,inst_63187,inst_63188,inst_63189,inst_63190];
var inst_63205 = cljs.core.PersistentHashMap.fromArrays(inst_63203,inst_63204);
var inst_63206 = fluree.db.util.core.without_nils.call(null,inst_63205);
var inst_63207 = fluree.db.operations.transact_async.call(null,conn,inst_63206);
var state_63234__$1 = state_63234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63234__$1,(13),inst_63207);
} else {
if((state_val_63235 === (20))){
var inst_63225 = (state_63234[(2)]);
var state_63234__$1 = state_63234;
var statearr_63236_63272 = state_63234__$1;
(statearr_63236_63272[(2)] = inst_63225);

(statearr_63236_63272[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (1))){
var state_63234__$1 = state_63234;
var statearr_63237_63273 = state_63234__$1;
(statearr_63237_63273[(2)] = null);

(statearr_63237_63273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (4))){
var inst_63169 = (state_63234[(2)]);
var inst_63170 = fluree.db.util.log.error.call(null,inst_63169);
var inst_63171 = cljs.core.ex_data.call(null,inst_63169);
var inst_63172 = cljs.core.ex_message.call(null,inst_63169);
var inst_63173 = cljs.core.assoc.call(null,inst_63171,new cljs.core.Keyword(null,"message","message",-406056002),inst_63172);
var state_63234__$1 = (function (){var statearr_63238 = state_63234;
(statearr_63238[(12)] = inst_63170);

return statearr_63238;
})();
var statearr_63239_63274 = state_63234__$1;
(statearr_63239_63274[(2)] = inst_63173);

(statearr_63239_63274[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (15))){
var inst_63184 = (state_63234[(13)]);
var inst_63209 = (state_63234[(14)]);
var inst_63212 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_63209,inst_63184);
var state_63234__$1 = state_63234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63234__$1,(17),inst_63212);
} else {
if((state_val_63235 === (13))){
var inst_63183 = (state_63234[(15)]);
var inst_63209 = (state_63234[(2)]);
var state_63234__$1 = (function (){var statearr_63240 = state_63234;
(statearr_63240[(14)] = inst_63209);

return statearr_63240;
})();
if(cljs.core.truth_(inst_63183)){
var statearr_63241_63275 = state_63234__$1;
(statearr_63241_63275[(1)] = (14));

} else {
var statearr_63242_63276 = state_63234__$1;
(statearr_63242_63276[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (6))){
var inst_63183 = (state_63234[(15)]);
var inst_63182 = (state_63234[(16)]);
var inst_63192 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_63182,opts);
var inst_63193 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_63192);
var inst_63194 = fluree.db.operations.command_async.call(null,conn,inst_63192);
var state_63234__$1 = (function (){var statearr_63243 = state_63234;
(statearr_63243[(17)] = inst_63193);

(statearr_63243[(18)] = inst_63194);

return statearr_63243;
})();
if(cljs.core.truth_(inst_63183)){
var statearr_63244_63277 = state_63234__$1;
(statearr_63244_63277[(1)] = (9));

} else {
var statearr_63245_63278 = state_63234__$1;
(statearr_63245_63278[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (17))){
var inst_63214 = (state_63234[(19)]);
var inst_63214__$1 = (state_63234[(2)]);
var inst_63215 = (inst_63214__$1 instanceof cljs.core.ExceptionInfo);
var state_63234__$1 = (function (){var statearr_63246 = state_63234;
(statearr_63246[(19)] = inst_63214__$1);

return statearr_63246;
})();
if(cljs.core.truth_(inst_63215)){
var statearr_63247_63279 = state_63234__$1;
(statearr_63247_63279[(1)] = (18));

} else {
var statearr_63248_63280 = state_63234__$1;
(statearr_63248_63280[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (3))){
var inst_63232 = (state_63234[(2)]);
var state_63234__$1 = state_63234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63234__$1,inst_63232);
} else {
if((state_val_63235 === (12))){
var inst_63199 = (state_63234[(2)]);
var state_63234__$1 = state_63234;
var statearr_63249_63281 = state_63234__$1;
(statearr_63249_63281[(2)] = inst_63199);

(statearr_63249_63281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (2))){
var inst_63182 = (state_63234[(16)]);
var _ = (function (){var statearr_63250 = state_63234;
(statearr_63250[(4)] = cljs.core.cons.call(null,(5),(state_63234[(4)])));

return statearr_63250;
})();
var inst_63180 = opts;
var inst_63181 = cljs.core.__destructure_map.call(null,inst_63180);
var inst_63182__$1 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_63183 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_63184 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_63185 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63186 = fluree.db.util.core.current_time_millis.call(null);
var inst_63187 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_63186);
var inst_63188 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_63189 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_63190 = cljs.core.get.call(null,inst_63181,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_63234__$1 = (function (){var statearr_63251 = state_63234;
(statearr_63251[(7)] = inst_63190);

(statearr_63251[(8)] = inst_63188);

(statearr_63251[(9)] = inst_63185);

(statearr_63251[(10)] = inst_63189);

(statearr_63251[(15)] = inst_63183);

(statearr_63251[(13)] = inst_63184);

(statearr_63251[(16)] = inst_63182__$1);

(statearr_63251[(11)] = inst_63187);

return statearr_63251;
})();
if(cljs.core.truth_(inst_63182__$1)){
var statearr_63252_63282 = state_63234__$1;
(statearr_63252_63282[(1)] = (6));

} else {
var statearr_63253_63283 = state_63234__$1;
(statearr_63253_63283[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (19))){
var inst_63214 = (state_63234[(19)]);
var state_63234__$1 = state_63234;
var statearr_63254_63284 = state_63234__$1;
(statearr_63254_63284[(2)] = inst_63214);

(statearr_63254_63284[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (11))){
var inst_63201 = (state_63234[(2)]);
var state_63234__$1 = state_63234;
var statearr_63256_63285 = state_63234__$1;
(statearr_63256_63285[(2)] = inst_63201);

(statearr_63256_63285[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (9))){
var inst_63194 = (state_63234[(18)]);
var state_63234__$1 = state_63234;
var statearr_63257_63286 = state_63234__$1;
(statearr_63257_63286[(2)] = inst_63194);

(statearr_63257_63286[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (5))){
var _ = (function (){var statearr_63258 = state_63234;
(statearr_63258[(4)] = cljs.core.rest.call(null,(state_63234[(4)])));

return statearr_63258;
})();
var state_63234__$1 = state_63234;
var ex63255 = (state_63234__$1[(2)]);
var statearr_63259_63287 = state_63234__$1;
(statearr_63259_63287[(5)] = ex63255);


var statearr_63260_63288 = state_63234__$1;
(statearr_63260_63288[(1)] = (4));

(statearr_63260_63288[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (14))){
var inst_63209 = (state_63234[(14)]);
var state_63234__$1 = state_63234;
var statearr_63261_63289 = state_63234__$1;
(statearr_63261_63289[(2)] = inst_63209);

(statearr_63261_63289[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (16))){
var inst_63227 = (state_63234[(2)]);
var state_63234__$1 = state_63234;
var statearr_63262_63290 = state_63234__$1;
(statearr_63262_63290[(2)] = inst_63227);

(statearr_63262_63290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (10))){
var inst_63193 = (state_63234[(17)]);
var inst_63184 = (state_63234[(13)]);
var inst_63197 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_63193,inst_63184);
var state_63234__$1 = state_63234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63234__$1,(12),inst_63197);
} else {
if((state_val_63235 === (18))){
var inst_63214 = (state_63234[(19)]);
var inst_63217 = cljs.core.ex_data.call(null,inst_63214);
var inst_63218 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63219 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63217);
var inst_63220 = cljs.core.ex_message.call(null,inst_63214);
var inst_63221 = [inst_63219,inst_63220,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_63222 = cljs.core.PersistentHashMap.fromArrays(inst_63218,inst_63221);
var state_63234__$1 = state_63234;
var statearr_63263_63291 = state_63234__$1;
(statearr_63263_63291[(2)] = inst_63222);

(statearr_63263_63291[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63235 === (8))){
var inst_63229 = (state_63234[(2)]);
var _ = (function (){var statearr_63264 = state_63234;
(statearr_63264[(4)] = cljs.core.rest.call(null,(state_63234[(4)])));

return statearr_63264;
})();
var state_63234__$1 = state_63234;
var statearr_63265_63292 = state_63234__$1;
(statearr_63265_63292[(2)] = inst_63229);

(statearr_63265_63292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_63266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63266[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_63266[(1)] = (1));

return statearr_63266;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_63234){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63267){var ex__2749__auto__ = e63267;
var statearr_63268_63293 = state_63234;
(statearr_63268_63293[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63234[(4)]))){
var statearr_63269_63294 = state_63234;
(statearr_63269_63294[(1)] = cljs.core.first.call(null,(state_63234[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63295 = state_63234;
state_63234 = G__63295;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_63234){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_63234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63270 = f__2769__auto__.call(null);
(statearr_63270[(6)] = c__2768__auto__);

return statearr_63270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63297 = arguments.length;
var i__4865__auto___63298 = (0);
while(true){
if((i__4865__auto___63298 < len__4864__auto___63297)){
args__4870__auto__.push((arguments[i__4865__auto___63298]));

var G__63299 = (i__4865__auto___63298 + (1));
i__4865__auto___63298 = G__63299;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq63296){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq63296));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63330){
var state_val_63331 = (state_63330[(1)]);
if((state_val_63331 === (1))){
var inst_63300 = cljs.core.first.call(null,flakes);
var inst_63301 = cljs.core.rest.call(null,flakes);
var inst_63302 = cljs.core.PersistentVector.EMPTY;
var inst_63303 = inst_63300;
var inst_63304 = inst_63301;
var inst_63305 = inst_63302;
var state_63330__$1 = (function (){var statearr_63332 = state_63330;
(statearr_63332[(7)] = inst_63303);

(statearr_63332[(8)] = inst_63305);

(statearr_63332[(9)] = inst_63304);

return statearr_63332;
})();
var statearr_63333_63346 = state_63330__$1;
(statearr_63333_63346[(2)] = null);

(statearr_63333_63346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63331 === (2))){
var inst_63303 = (state_63330[(7)]);
var inst_63307 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_63308 = cljs.core.PersistentHashMap.EMPTY;
var inst_63309 = [true,inst_63308];
var inst_63310 = cljs.core.PersistentHashMap.fromArrays(inst_63307,inst_63309);
var inst_63311 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_63310,inst_63303);
var state_63330__$1 = state_63330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63330__$1,(4),inst_63311);
} else {
if((state_val_63331 === (3))){
var inst_63328 = (state_63330[(2)]);
var state_63330__$1 = state_63330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63330__$1,inst_63328);
} else {
if((state_val_63331 === (4))){
var inst_63305 = (state_63330[(8)]);
var inst_63304 = (state_63330[(9)]);
var inst_63313 = (state_63330[(2)]);
var inst_63314 = fluree.db.util.async.throw_err.call(null,inst_63313);
var inst_63315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63316 = [inst_63314];
var inst_63317 = (new cljs.core.PersistentVector(null,1,(5),inst_63315,inst_63316,null));
var inst_63318 = cljs.core.concat.call(null,inst_63305,inst_63317);
var inst_63319 = cljs.core.first.call(null,inst_63304);
var state_63330__$1 = (function (){var statearr_63334 = state_63330;
(statearr_63334[(10)] = inst_63318);

return statearr_63334;
})();
if(cljs.core.truth_(inst_63319)){
var statearr_63335_63347 = state_63330__$1;
(statearr_63335_63347[(1)] = (5));

} else {
var statearr_63336_63348 = state_63330__$1;
(statearr_63336_63348[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63331 === (5))){
var inst_63318 = (state_63330[(10)]);
var inst_63304 = (state_63330[(9)]);
var inst_63321 = cljs.core.first.call(null,inst_63304);
var inst_63322 = cljs.core.rest.call(null,inst_63304);
var inst_63303 = inst_63321;
var inst_63304__$1 = inst_63322;
var inst_63305 = inst_63318;
var state_63330__$1 = (function (){var statearr_63337 = state_63330;
(statearr_63337[(7)] = inst_63303);

(statearr_63337[(8)] = inst_63305);

(statearr_63337[(9)] = inst_63304__$1);

return statearr_63337;
})();
var statearr_63338_63349 = state_63330__$1;
(statearr_63338_63349[(2)] = null);

(statearr_63338_63349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63331 === (6))){
var inst_63318 = (state_63330[(10)]);
var state_63330__$1 = state_63330;
var statearr_63339_63350 = state_63330__$1;
(statearr_63339_63350[(2)] = inst_63318);

(statearr_63339_63350[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63331 === (7))){
var inst_63326 = (state_63330[(2)]);
var state_63330__$1 = state_63330;
var statearr_63340_63351 = state_63330__$1;
(statearr_63340_63351[(2)] = inst_63326);

(statearr_63340_63351[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_63341 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63341[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_63341[(1)] = (1));

return statearr_63341;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_63330){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63342){var ex__2749__auto__ = e63342;
var statearr_63343_63352 = state_63330;
(statearr_63343_63352[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63330[(4)]))){
var statearr_63344_63353 = state_63330;
(statearr_63344_63353[(1)] = cljs.core.first.call(null,(state_63330[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63354 = state_63330;
state_63330 = G__63354;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_63330){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_63330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63345 = f__2769__auto__.call(null);
(statearr_63345[(6)] = c__2768__auto__);

return statearr_63345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63422){
var state_val_63423 = (state_63422[(1)]);
if((state_val_63423 === (7))){
var inst_63382 = (state_63422[(2)]);
var inst_63383 = fluree.db.util.async.throw_err.call(null,inst_63382);
var state_63422__$1 = state_63422;
var statearr_63424_63450 = state_63422__$1;
(statearr_63424_63450[(2)] = inst_63383);

(statearr_63424_63450[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (1))){
var inst_63359 = cljs.core.volatile_BANG_.call(null,(0));
var inst_63360 = cljs.core.PersistentHashMap.EMPTY;
var inst_63361 = cljs.core.volatile_BANG_.call(null,inst_63360);
var inst_63362 = cljs.core.first.call(null,resp);
var inst_63363 = cljs.core.rest.call(null,resp);
var inst_63364 = cljs.core.PersistentVector.EMPTY;
var inst_63365 = inst_63359;
var inst_63366 = inst_63361;
var inst_63367 = inst_63362;
var inst_63368 = inst_63363;
var inst_63369 = inst_63364;
var state_63422__$1 = (function (){var statearr_63425 = state_63422;
(statearr_63425[(7)] = inst_63367);

(statearr_63425[(8)] = inst_63369);

(statearr_63425[(9)] = inst_63368);

(statearr_63425[(10)] = inst_63365);

(statearr_63425[(11)] = inst_63366);

return statearr_63425;
})();
var statearr_63426_63451 = state_63422__$1;
(statearr_63426_63451[(2)] = null);

(statearr_63426_63451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (4))){
var inst_63367 = (state_63422[(7)]);
var inst_63369 = (state_63422[(8)]);
var inst_63371 = (state_63422[(12)]);
var inst_63368 = (state_63422[(9)]);
var inst_63365 = (state_63422[(10)]);
var inst_63373 = (state_63422[(13)]);
var inst_63366 = (state_63422[(11)]);
var inst_63377 = (function (){var fuel = inst_63365;
var cache = inst_63366;
var curr_block = inst_63367;
var rest_blocks = inst_63368;
var acc = inst_63369;
var flakes = inst_63371;
var asserted = inst_63373;
return (function (p1__63356_SHARP_){
return p1__63356_SHARP_.s;
});
})();
var inst_63378 = cljs.core.group_by.call(null,inst_63377,inst_63373);
var inst_63379 = cljs.core.vals.call(null,inst_63378);
var inst_63380 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_63366,inst_63365,inst_63379);
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63422__$1,(7),inst_63380);
} else {
if((state_val_63423 === (13))){
var inst_63410 = (state_63422[(14)]);
var state_63422__$1 = state_63422;
var statearr_63427_63452 = state_63422__$1;
(statearr_63427_63452[(2)] = inst_63410);

(statearr_63427_63452[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (6))){
var inst_63388 = (state_63422[(15)]);
var inst_63367 = (state_63422[(7)]);
var inst_63369 = (state_63422[(8)]);
var inst_63371 = (state_63422[(12)]);
var inst_63368 = (state_63422[(9)]);
var inst_63365 = (state_63422[(10)]);
var inst_63373 = (state_63422[(13)]);
var inst_63366 = (state_63422[(11)]);
var inst_63386 = (state_63422[(16)]);
var inst_63386__$1 = (state_63422[(2)]);
var inst_63387 = (function (){var fuel = inst_63365;
var cache = inst_63366;
var curr_block = inst_63367;
var rest_blocks = inst_63368;
var acc = inst_63369;
var flakes = inst_63371;
var asserted = inst_63373;
var asserted_SINGLEQUOTE_ = inst_63386__$1;
return (function (p1__63357_SHARP_){
return p1__63357_SHARP_.op === false;
});
})();
var inst_63388__$1 = cljs.core.filter.call(null,inst_63387,inst_63371);
var inst_63389 = cljs.core.empty_QMARK_.call(null,inst_63388__$1);
var inst_63390 = (!(inst_63389));
var state_63422__$1 = (function (){var statearr_63430 = state_63422;
(statearr_63430[(15)] = inst_63388__$1);

(statearr_63430[(16)] = inst_63386__$1);

return statearr_63430;
})();
if(inst_63390){
var statearr_63431_63453 = state_63422__$1;
(statearr_63431_63453[(1)] = (8));

} else {
var statearr_63432_63454 = state_63422__$1;
(statearr_63432_63454[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (3))){
var inst_63420 = (state_63422[(2)]);
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63422__$1,inst_63420);
} else {
if((state_val_63423 === (12))){
var inst_63410 = (state_63422[(14)]);
var inst_63368 = (state_63422[(9)]);
var inst_63365 = (state_63422[(10)]);
var inst_63366 = (state_63422[(11)]);
var inst_63413 = cljs.core.first.call(null,inst_63368);
var inst_63414 = cljs.core.rest.call(null,inst_63368);
var tmp63428 = inst_63365;
var tmp63429 = inst_63366;
var inst_63365__$1 = tmp63428;
var inst_63366__$1 = tmp63429;
var inst_63367 = inst_63413;
var inst_63368__$1 = inst_63414;
var inst_63369 = inst_63410;
var state_63422__$1 = (function (){var statearr_63433 = state_63422;
(statearr_63433[(7)] = inst_63367);

(statearr_63433[(8)] = inst_63369);

(statearr_63433[(9)] = inst_63368__$1);

(statearr_63433[(10)] = inst_63365__$1);

(statearr_63433[(11)] = inst_63366__$1);

return statearr_63433;
})();
var statearr_63434_63455 = state_63422__$1;
(statearr_63434_63455[(2)] = null);

(statearr_63434_63455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (2))){
var inst_63367 = (state_63422[(7)]);
var inst_63369 = (state_63422[(8)]);
var inst_63371 = (state_63422[(12)]);
var inst_63368 = (state_63422[(9)]);
var inst_63365 = (state_63422[(10)]);
var inst_63373 = (state_63422[(13)]);
var inst_63366 = (state_63422[(11)]);
var inst_63371__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_63367);
var inst_63372 = (function (){var fuel = inst_63365;
var cache = inst_63366;
var curr_block = inst_63367;
var rest_blocks = inst_63368;
var acc = inst_63369;
var flakes = inst_63371__$1;
return (function (p1__63355_SHARP_){
return p1__63355_SHARP_.op;
});
})();
var inst_63373__$1 = cljs.core.filter.call(null,inst_63372,inst_63371__$1);
var inst_63374 = cljs.core.empty_QMARK_.call(null,inst_63373__$1);
var inst_63375 = (!(inst_63374));
var state_63422__$1 = (function (){var statearr_63435 = state_63422;
(statearr_63435[(12)] = inst_63371__$1);

(statearr_63435[(13)] = inst_63373__$1);

return statearr_63435;
})();
if(inst_63375){
var statearr_63436_63456 = state_63422__$1;
(statearr_63436_63456[(1)] = (4));

} else {
var statearr_63437_63457 = state_63422__$1;
(statearr_63437_63457[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (11))){
var inst_63398 = (state_63422[(2)]);
var inst_63399 = fluree.db.util.async.throw_err.call(null,inst_63398);
var state_63422__$1 = state_63422;
var statearr_63438_63458 = state_63422__$1;
(statearr_63438_63458[(2)] = inst_63399);

(statearr_63438_63458[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (9))){
var state_63422__$1 = state_63422;
var statearr_63439_63459 = state_63422__$1;
(statearr_63439_63459[(2)] = null);

(statearr_63439_63459[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (5))){
var state_63422__$1 = state_63422;
var statearr_63440_63460 = state_63422__$1;
(statearr_63440_63460[(2)] = null);

(statearr_63440_63460[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (14))){
var inst_63418 = (state_63422[(2)]);
var state_63422__$1 = state_63422;
var statearr_63441_63461 = state_63422__$1;
(statearr_63441_63461[(2)] = inst_63418);

(statearr_63441_63461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (10))){
var inst_63367 = (state_63422[(7)]);
var inst_63369 = (state_63422[(8)]);
var inst_63368 = (state_63422[(9)]);
var inst_63386 = (state_63422[(16)]);
var inst_63402 = (state_63422[(2)]);
var inst_63403 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_63404 = [inst_63386,inst_63402];
var inst_63405 = cljs.core.PersistentHashMap.fromArrays(inst_63403,inst_63404);
var inst_63406 = cljs.core.assoc.call(null,inst_63367,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_63405);
var inst_63407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63408 = [inst_63406];
var inst_63409 = (new cljs.core.PersistentVector(null,1,(5),inst_63407,inst_63408,null));
var inst_63410 = cljs.core.concat.call(null,inst_63369,inst_63409);
var inst_63411 = cljs.core.first.call(null,inst_63368);
var state_63422__$1 = (function (){var statearr_63442 = state_63422;
(statearr_63442[(14)] = inst_63410);

return statearr_63442;
})();
if(cljs.core.truth_(inst_63411)){
var statearr_63443_63462 = state_63422__$1;
(statearr_63443_63462[(1)] = (12));

} else {
var statearr_63444_63463 = state_63422__$1;
(statearr_63444_63463[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63423 === (8))){
var inst_63388 = (state_63422[(15)]);
var inst_63367 = (state_63422[(7)]);
var inst_63369 = (state_63422[(8)]);
var inst_63371 = (state_63422[(12)]);
var inst_63368 = (state_63422[(9)]);
var inst_63365 = (state_63422[(10)]);
var inst_63373 = (state_63422[(13)]);
var inst_63366 = (state_63422[(11)]);
var inst_63386 = (state_63422[(16)]);
var inst_63392 = (function (){var flakes = inst_63371;
var rest_blocks = inst_63368;
var curr_block = inst_63367;
var asserted_SINGLEQUOTE_ = inst_63386;
var acc = inst_63369;
var fuel = inst_63365;
var cache = inst_63366;
var retracted = inst_63388;
var asserted = inst_63373;
return (function (p1__63358_SHARP_){
return p1__63358_SHARP_.s;
});
})();
var inst_63393 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_63388);
var inst_63394 = cljs.core.group_by.call(null,inst_63392,inst_63393);
var inst_63395 = cljs.core.vals.call(null,inst_63394);
var inst_63396 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_63366,inst_63365,inst_63395);
var state_63422__$1 = state_63422;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63422__$1,(11),inst_63396);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_63445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63445[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_63445[(1)] = (1));

return statearr_63445;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_63422){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63422);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63446){var ex__2749__auto__ = e63446;
var statearr_63447_63464 = state_63422;
(statearr_63447_63464[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63422[(4)]))){
var statearr_63448_63465 = state_63422;
(statearr_63448_63465[(1)] = cljs.core.first.call(null,(state_63422[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63466 = state_63422;
state_63422 = G__63466;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_63422){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_63422);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63449 = f__2769__auto__.call(null);
(statearr_63449[(6)] = c__2768__auto__);

return statearr_63449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63566){
var state_val_63567 = (state_63566[(1)]);
if((state_val_63567 === (7))){
var inst_63531 = (state_63566[(7)]);
var inst_63538 = (state_63566[(8)]);
var inst_63537 = cljs.core.seq.call(null,inst_63531);
var inst_63538__$1 = cljs.core.first.call(null,inst_63537);
var inst_63539 = cljs.core.next.call(null,inst_63537);
var state_63566__$1 = (function (){var statearr_63568 = state_63566;
(statearr_63568[(9)] = inst_63539);

(statearr_63568[(8)] = inst_63538__$1);

return statearr_63568;
})();
if(cljs.core.truth_(inst_63538__$1)){
var statearr_63569_63606 = state_63566__$1;
(statearr_63569_63606[(1)] = (9));

} else {
var statearr_63570_63607 = state_63566__$1;
(statearr_63570_63607[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (1))){
var state_63566__$1 = state_63566;
var statearr_63571_63608 = state_63566__$1;
(statearr_63571_63608[(2)] = null);

(statearr_63571_63608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (4))){
var inst_63468 = (state_63566[(2)]);
var state_63566__$1 = state_63566;
var statearr_63572_63609 = state_63566__$1;
(statearr_63572_63609[(2)] = inst_63468);

(statearr_63572_63609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (6))){
var inst_63517 = (state_63566[(2)]);
var inst_63518 = fluree.db.util.async.throw_err.call(null,inst_63517);
var inst_63526 = resp;
var inst_63527 = cljs.core.seq.call(null,inst_63526);
var inst_63528 = cljs.core.first.call(null,inst_63527);
var inst_63529 = cljs.core.next.call(null,inst_63527);
var inst_63530 = cljs.core.PersistentHashMap.EMPTY;
var inst_63531 = inst_63526;
var inst_63532 = inst_63530;
var state_63566__$1 = (function (){var statearr_63573 = state_63566;
(statearr_63573[(10)] = inst_63528);

(statearr_63573[(11)] = inst_63518);

(statearr_63573[(12)] = inst_63532);

(statearr_63573[(7)] = inst_63531);

(statearr_63573[(13)] = inst_63529);

return statearr_63573;
})();
var statearr_63574_63610 = state_63566__$1;
(statearr_63574_63610[(2)] = null);

(statearr_63574_63610[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (3))){
var inst_63564 = (state_63566[(2)]);
var state_63566__$1 = state_63566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63566__$1,inst_63564);
} else {
if((state_val_63567 === (2))){
var _ = (function (){var statearr_63575 = state_63566;
(statearr_63575[(4)] = cljs.core.cons.call(null,(5),(state_63566[(4)])));

return statearr_63575;
})();
var inst_63474 = (function (){return (function (p1__63467_SHARP_){
return p1__63467_SHARP_.t;
});
})();
var inst_63475 = cljs.core.map.call(null,inst_63474,resp);
var inst_63476 = cljs.core.set.call(null,inst_63475);
var inst_63513 = cljs.core.async.chan.call(null,(1));
var inst_63514 = (function (){var ts = inst_63476;
var c__2768__auto____$1 = inst_63513;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63511){
var state_val_63512 = (state_63511[(1)]);
if((state_val_63512 === (1))){
var inst_63484 = ts;
var inst_63485 = cljs.core.seq.call(null,inst_63484);
var inst_63486 = cljs.core.first.call(null,inst_63485);
var inst_63487 = cljs.core.next.call(null,inst_63485);
var inst_63488 = cljs.core.PersistentHashMap.EMPTY;
var inst_63489 = inst_63484;
var inst_63490 = inst_63488;
var state_63511__$1 = (function (){var statearr_63576 = state_63511;
(statearr_63576[(7)] = inst_63490);

(statearr_63576[(8)] = inst_63487);

(statearr_63576[(9)] = inst_63486);

(statearr_63576[(10)] = inst_63489);

return statearr_63576;
})();
var statearr_63577_63611 = state_63511__$1;
(statearr_63577_63611[(2)] = null);

(statearr_63577_63611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63512 === (2))){
var inst_63496 = (state_63511[(11)]);
var inst_63489 = (state_63511[(10)]);
var inst_63495 = cljs.core.seq.call(null,inst_63489);
var inst_63496__$1 = cljs.core.first.call(null,inst_63495);
var inst_63497 = cljs.core.next.call(null,inst_63495);
var state_63511__$1 = (function (){var statearr_63578 = state_63511;
(statearr_63578[(11)] = inst_63496__$1);

(statearr_63578[(12)] = inst_63497);

return statearr_63578;
})();
if(cljs.core.truth_(inst_63496__$1)){
var statearr_63579_63612 = state_63511__$1;
(statearr_63579_63612[(1)] = (4));

} else {
var statearr_63580_63613 = state_63511__$1;
(statearr_63580_63613[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63512 === (3))){
var inst_63509 = (state_63511[(2)]);
var state_63511__$1 = state_63511;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63511__$1,inst_63509);
} else {
if((state_val_63512 === (4))){
var inst_63496 = (state_63511[(11)]);
var inst_63499 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_63496);
var state_63511__$1 = state_63511;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63511__$1,(7),inst_63499);
} else {
if((state_val_63512 === (5))){
var inst_63490 = (state_63511[(7)]);
var state_63511__$1 = state_63511;
var statearr_63581_63614 = state_63511__$1;
(statearr_63581_63614[(2)] = inst_63490);

(statearr_63581_63614[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63512 === (6))){
var inst_63507 = (state_63511[(2)]);
var state_63511__$1 = state_63511;
var statearr_63582_63615 = state_63511__$1;
(statearr_63582_63615[(2)] = inst_63507);

(statearr_63582_63615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63512 === (7))){
var inst_63490 = (state_63511[(7)]);
var inst_63496 = (state_63511[(11)]);
var inst_63497 = (state_63511[(12)]);
var inst_63501 = (state_63511[(2)]);
var inst_63502 = fluree.db.util.async.throw_err.call(null,inst_63501);
var inst_63503 = cljs.core.assoc.call(null,inst_63490,inst_63496,inst_63502);
var inst_63489 = inst_63497;
var inst_63490__$1 = inst_63503;
var state_63511__$1 = (function (){var statearr_63583 = state_63511;
(statearr_63583[(7)] = inst_63490__$1);

(statearr_63583[(10)] = inst_63489);

return statearr_63583;
})();
var statearr_63584_63616 = state_63511__$1;
(statearr_63584_63616[(2)] = null);

(statearr_63584_63616[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_63585 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63585[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_63585[(1)] = (1));

return statearr_63585;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_63511){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63511);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63586){var ex__2749__auto__ = e63586;
var statearr_63587_63617 = state_63511;
(statearr_63587_63617[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63511[(4)]))){
var statearr_63588_63618 = state_63511;
(statearr_63588_63618[(1)] = cljs.core.first.call(null,(state_63511[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63619 = state_63511;
state_63511 = G__63619;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_63511){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_63511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63589 = f__2769__auto__.call(null);
(statearr_63589[(6)] = c__2768__auto____$1);

return statearr_63589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_63515 = cljs.core.async.impl.dispatch.run.call(null,inst_63514);
var state_63566__$1 = (function (){var statearr_63590 = state_63566;
(statearr_63590[(14)] = inst_63515);

return statearr_63590;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63566__$1,(6),inst_63513);
} else {
if((state_val_63567 === (11))){
var inst_63558 = (state_63566[(2)]);
var state_63566__$1 = state_63566;
var statearr_63592_63620 = state_63566__$1;
(statearr_63592_63620[(2)] = inst_63558);

(statearr_63592_63620[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (9))){
var inst_63518 = (state_63566[(11)]);
var inst_63532 = (state_63566[(12)]);
var inst_63539 = (state_63566[(9)]);
var inst_63538 = (state_63566[(8)]);
var inst_63541 = inst_63538.t;
var inst_63542 = cljs.core.get.call(null,inst_63518,inst_63541);
var inst_63543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63544 = [inst_63542,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63545 = (new cljs.core.PersistentVector(null,2,(5),inst_63543,inst_63544,null));
var inst_63546 = cljs.core.assoc_in.call(null,inst_63532,inst_63545,inst_63542);
var inst_63547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63548 = [inst_63542,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_63549 = (new cljs.core.PersistentVector(null,2,(5),inst_63547,inst_63548,null));
var inst_63550 = cljs.core.update_in.call(null,inst_63546,inst_63549,cljs.core.conj,inst_63538);
var inst_63551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63552 = [inst_63542,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_63553 = (new cljs.core.PersistentVector(null,2,(5),inst_63551,inst_63552,null));
var inst_63554 = cljs.core.update_in.call(null,inst_63550,inst_63553,fluree.db.api_js.min_safe,inst_63541);
var inst_63531 = inst_63539;
var inst_63532__$1 = inst_63554;
var state_63566__$1 = (function (){var statearr_63593 = state_63566;
(statearr_63593[(12)] = inst_63532__$1);

(statearr_63593[(7)] = inst_63531);

return statearr_63593;
})();
var statearr_63594_63621 = state_63566__$1;
(statearr_63594_63621[(2)] = null);

(statearr_63594_63621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (5))){
var _ = (function (){var statearr_63595 = state_63566;
(statearr_63595[(4)] = cljs.core.rest.call(null,(state_63566[(4)])));

return statearr_63595;
})();
var state_63566__$1 = state_63566;
var ex63591 = (state_63566__$1[(2)]);
var statearr_63596_63622 = state_63566__$1;
(statearr_63596_63622[(5)] = ex63591);


if((ex63591 instanceof Error)){
var statearr_63597_63623 = state_63566__$1;
(statearr_63597_63623[(1)] = (4));

(statearr_63597_63623[(5)] = null);

} else {
throw ex63591;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (10))){
var inst_63532 = (state_63566[(12)]);
var state_63566__$1 = state_63566;
var statearr_63598_63624 = state_63566__$1;
(statearr_63598_63624[(2)] = inst_63532);

(statearr_63598_63624[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63567 === (8))){
var inst_63560 = (state_63566[(2)]);
var inst_63561 = cljs.core.vals.call(null,inst_63560);
var _ = (function (){var statearr_63599 = state_63566;
(statearr_63599[(4)] = cljs.core.rest.call(null,(state_63566[(4)])));

return statearr_63599;
})();
var state_63566__$1 = state_63566;
var statearr_63600_63625 = state_63566__$1;
(statearr_63600_63625[(2)] = inst_63561);

(statearr_63600_63625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_63601 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63601[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_63601[(1)] = (1));

return statearr_63601;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_63566){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63602){var ex__2749__auto__ = e63602;
var statearr_63603_63626 = state_63566;
(statearr_63603_63626[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63566[(4)]))){
var statearr_63604_63627 = state_63566;
(statearr_63604_63627[(1)] = cljs.core.first.call(null,(state_63566[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63628 = state_63566;
state_63566 = G__63628;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_63566){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_63566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63605 = f__2769__auto__.call(null);
(statearr_63605[(6)] = c__2768__auto__);

return statearr_63605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63773){
var state_val_63774 = (state_63773[(1)]);
if((state_val_63774 === (7))){
var inst_63653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63654 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63655 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63656 = [inst_63654,inst_63655];
var inst_63657 = (new cljs.core.PersistentVector(null,2,(5),inst_63653,inst_63656,null));
var state_63773__$1 = state_63773;
var statearr_63775_63846 = state_63773__$1;
(statearr_63775_63846[(2)] = inst_63657);

(statearr_63775_63846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (20))){
var inst_63683 = (state_63773[(7)]);
var state_63773__$1 = state_63773;
var statearr_63776_63847 = state_63773__$1;
(statearr_63776_63847[(2)] = inst_63683);

(statearr_63776_63847[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (27))){
var state_63773__$1 = state_63773;
var statearr_63777_63848 = state_63773__$1;
(statearr_63777_63848[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (1))){
var state_63773__$1 = state_63773;
var statearr_63779_63849 = state_63773__$1;
(statearr_63779_63849[(2)] = null);

(statearr_63779_63849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (24))){
var inst_63682 = (state_63773[(8)]);
var state_63773__$1 = state_63773;
if(cljs.core.truth_(inst_63682)){
var statearr_63780_63850 = state_63773__$1;
(statearr_63780_63850[(1)] = (26));

} else {
var statearr_63781_63851 = state_63773__$1;
(statearr_63781_63851[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (39))){
var inst_63729 = (state_63773[(9)]);
var inst_63728 = (state_63773[(10)]);
var inst_63754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63755 = [inst_63728,inst_63729];
var inst_63756 = (new cljs.core.PersistentVector(null,2,(5),inst_63754,inst_63755,null));
var state_63773__$1 = state_63773;
var statearr_63782_63852 = state_63773__$1;
(statearr_63782_63852[(2)] = inst_63756);

(statearr_63782_63852[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (4))){
var inst_63629 = (state_63773[(2)]);
var inst_63630 = fluree.db.util.log.error.call(null,inst_63629);
var inst_63631 = cljs.core.ex_data.call(null,inst_63629);
var inst_63632 = cljs.core.ex_message.call(null,inst_63629);
var inst_63633 = cljs.core.assoc.call(null,inst_63631,new cljs.core.Keyword(null,"message","message",-406056002),inst_63632);
var state_63773__$1 = (function (){var statearr_63783 = state_63773;
(statearr_63783[(11)] = inst_63630);

return statearr_63783;
})();
var statearr_63784_63853 = state_63773__$1;
(statearr_63784_63853[(2)] = inst_63633);

(statearr_63784_63853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (15))){
var inst_63662 = (state_63773[(12)]);
var inst_63667 = (state_63773[(13)]);
var inst_63676 = (state_63773[(2)]);
var inst_63677 = [inst_63667,inst_63676];
var inst_63678 = (new cljs.core.PersistentVector(null,2,(5),inst_63662,inst_63677,null));
var state_63773__$1 = state_63773;
var statearr_63785_63854 = state_63773__$1;
(statearr_63785_63854[(2)] = inst_63678);

(statearr_63785_63854[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (21))){
var inst_63682 = (state_63773[(8)]);
var state_63773__$1 = state_63773;
var statearr_63786_63855 = state_63773__$1;
(statearr_63786_63855[(2)] = inst_63682);

(statearr_63786_63855[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (31))){
var inst_63723 = (state_63773[(2)]);
var state_63773__$1 = state_63773;
var statearr_63787_63856 = state_63773__$1;
(statearr_63787_63856[(2)] = inst_63723);

(statearr_63787_63856[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (32))){
var inst_63729 = (state_63773[(9)]);
var inst_63732 = cljs.core.pos_int_QMARK_.call(null,inst_63729);
var state_63773__$1 = state_63773;
var statearr_63788_63857 = state_63773__$1;
(statearr_63788_63857[(2)] = inst_63732);

(statearr_63788_63857[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (40))){
var inst_63684 = (state_63773[(14)]);
var inst_63760 = (state_63773[(15)]);
var inst_63758 = (state_63773[(2)]);
var inst_63759 = cljs.core.nth.call(null,inst_63758,(0),null);
var inst_63760__$1 = cljs.core.nth.call(null,inst_63758,(1),null);
var inst_63761 = (inst_63760__$1 > inst_63684);
var state_63773__$1 = (function (){var statearr_63789 = state_63773;
(statearr_63789[(16)] = inst_63759);

(statearr_63789[(15)] = inst_63760__$1);

return statearr_63789;
})();
if(cljs.core.truth_(inst_63761)){
var statearr_63790_63858 = state_63773__$1;
(statearr_63790_63858[(1)] = (41));

} else {
var statearr_63791_63859 = state_63773__$1;
(statearr_63791_63859[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (33))){
var inst_63730 = (state_63773[(17)]);
var state_63773__$1 = state_63773;
var statearr_63792_63860 = state_63773__$1;
(statearr_63792_63860[(2)] = inst_63730);

(statearr_63792_63860[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (13))){
var inst_63668 = (state_63773[(18)]);
var inst_63670 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_63668);
var state_63773__$1 = state_63773;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63773__$1,(16),inst_63670);
} else {
if((state_val_63774 === (22))){
var inst_63701 = (state_63773[(2)]);
var state_63773__$1 = state_63773;
if(cljs.core.truth_(inst_63701)){
var statearr_63793_63861 = state_63773__$1;
(statearr_63793_63861[(1)] = (23));

} else {
var statearr_63794_63862 = state_63773__$1;
(statearr_63794_63862[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (36))){
var state_63773__$1 = state_63773;
var statearr_63795_63863 = state_63773__$1;
(statearr_63795_63863[(2)] = null);

(statearr_63795_63863[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (41))){
var inst_63684 = (state_63773[(14)]);
var state_63773__$1 = state_63773;
var statearr_63796_63864 = state_63773__$1;
(statearr_63796_63864[(2)] = inst_63684);

(statearr_63796_63864[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (43))){
var inst_63759 = (state_63773[(16)]);
var inst_63765 = (state_63773[(2)]);
var inst_63766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63767 = [inst_63759,inst_63765];
var inst_63768 = (new cljs.core.PersistentVector(null,2,(5),inst_63766,inst_63767,null));
var _ = (function (){var statearr_63797 = state_63773;
(statearr_63797[(4)] = cljs.core.rest.call(null,(state_63773[(4)])));

return statearr_63797;
})();
var state_63773__$1 = state_63773;
var statearr_63798_63865 = state_63773__$1;
(statearr_63798_63865[(2)] = inst_63768);

(statearr_63798_63865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (29))){
var inst_63659 = (state_63773[(19)]);
var inst_63714 = cljs.core.pr_str.call(null,inst_63659);
var inst_63715 = ["Invalid block range provided: ",inst_63714].join('');
var inst_63716 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63717 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63718 = cljs.core.PersistentHashMap.fromArrays(inst_63716,inst_63717);
var inst_63719 = cljs.core.ex_info.call(null,inst_63715,inst_63718);
var inst_63720 = (function(){throw inst_63719})();
var state_63773__$1 = state_63773;
var statearr_63799_63866 = state_63773__$1;
(statearr_63799_63866[(2)] = inst_63720);

(statearr_63799_63866[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (6))){
var inst_63651 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_63773__$1 = state_63773;
var statearr_63800_63867 = state_63773__$1;
(statearr_63800_63867[(2)] = inst_63651);

(statearr_63800_63867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (28))){
var inst_63725 = (state_63773[(2)]);
var state_63773__$1 = state_63773;
var statearr_63801_63868 = state_63773__$1;
(statearr_63801_63868[(2)] = inst_63725);

(statearr_63801_63868[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (25))){
var inst_63730 = (state_63773[(17)]);
var inst_63728 = (state_63773[(10)]);
var inst_63727 = (state_63773[(2)]);
var inst_63728__$1 = cljs.core.nth.call(null,inst_63727,(0),null);
var inst_63729 = cljs.core.nth.call(null,inst_63727,(1),null);
var inst_63730__$1 = cljs.core.pos_int_QMARK_.call(null,inst_63728__$1);
var state_63773__$1 = (function (){var statearr_63802 = state_63773;
(statearr_63802[(17)] = inst_63730__$1);

(statearr_63802[(9)] = inst_63729);

(statearr_63802[(10)] = inst_63728__$1);

return statearr_63802;
})();
if(inst_63730__$1){
var statearr_63803_63869 = state_63773__$1;
(statearr_63803_63869[(1)] = (32));

} else {
var statearr_63804_63870 = state_63773__$1;
(statearr_63804_63870[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (34))){
var inst_63735 = (state_63773[(2)]);
var inst_63736 = cljs.core.not.call(null,inst_63735);
var state_63773__$1 = state_63773;
if(inst_63736){
var statearr_63805_63871 = state_63773__$1;
(statearr_63805_63871[(1)] = (35));

} else {
var statearr_63806_63872 = state_63773__$1;
(statearr_63806_63872[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (17))){
var inst_63682 = (state_63773[(8)]);
var inst_63684 = (state_63773[(14)]);
var inst_63687 = cljs.core.pr_str.call(null,inst_63682);
var inst_63688 = cljs.core.pr_str.call(null,inst_63684);
var inst_63689 = ["Start block is out of range for this ledger. Start block provided: ",inst_63687,". Database block: ",inst_63688].join('');
var inst_63690 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63691 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63692 = cljs.core.PersistentHashMap.fromArrays(inst_63690,inst_63691);
var inst_63693 = cljs.core.ex_info.call(null,inst_63689,inst_63692);
var inst_63694 = (function(){throw inst_63693})();
var state_63773__$1 = state_63773;
var statearr_63807_63873 = state_63773__$1;
(statearr_63807_63873[(2)] = inst_63694);

(statearr_63807_63873[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (3))){
var inst_63771 = (state_63773[(2)]);
var state_63773__$1 = state_63773;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63773__$1,inst_63771);
} else {
if((state_val_63774 === (12))){
var inst_63659 = (state_63773[(19)]);
var inst_63668 = (state_63773[(18)]);
var inst_63666 = (state_63773[(2)]);
var inst_63667 = fluree.db.util.async.throw_err.call(null,inst_63666);
var inst_63668__$1 = cljs.core.second.call(null,inst_63659);
var state_63773__$1 = (function (){var statearr_63808 = state_63773;
(statearr_63808[(13)] = inst_63667);

(statearr_63808[(18)] = inst_63668__$1);

return statearr_63808;
})();
if(cljs.core.truth_(inst_63668__$1)){
var statearr_63809_63874 = state_63773__$1;
(statearr_63809_63874[(1)] = (13));

} else {
var statearr_63810_63875 = state_63773__$1;
(statearr_63810_63875[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (2))){
var _ = (function (){var statearr_63811 = state_63773;
(statearr_63811[(4)] = cljs.core.cons.call(null,(5),(state_63773[(4)])));

return statearr_63811;
})();
var inst_63648 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_63649 = cljs.core.sequential_QMARK_.call(null,inst_63648);
var state_63773__$1 = state_63773;
if(inst_63649){
var statearr_63812_63876 = state_63773__$1;
(statearr_63812_63876[(1)] = (6));

} else {
var statearr_63813_63877 = state_63773__$1;
(statearr_63813_63877[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (23))){
var inst_63682 = (state_63773[(8)]);
var inst_63683 = (state_63773[(7)]);
var inst_63703 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63704 = [inst_63682,inst_63683];
var inst_63705 = (new cljs.core.PersistentVector(null,2,(5),inst_63703,inst_63704,null));
var state_63773__$1 = state_63773;
var statearr_63814_63878 = state_63773__$1;
(statearr_63814_63878[(2)] = inst_63705);

(statearr_63814_63878[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (35))){
var inst_63659 = (state_63773[(19)]);
var inst_63738 = cljs.core.pr_str.call(null,inst_63659);
var inst_63739 = ["Invalid block range provided: ",inst_63738].join('');
var inst_63740 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63741 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63742 = cljs.core.PersistentHashMap.fromArrays(inst_63740,inst_63741);
var inst_63743 = cljs.core.ex_info.call(null,inst_63739,inst_63742);
var inst_63744 = (function(){throw inst_63743})();
var state_63773__$1 = state_63773;
var statearr_63815_63879 = state_63773__$1;
(statearr_63815_63879[(2)] = inst_63744);

(statearr_63815_63879[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (19))){
var inst_63682 = (state_63773[(8)]);
var inst_63697 = (state_63773[(2)]);
var state_63773__$1 = (function (){var statearr_63816 = state_63773;
(statearr_63816[(20)] = inst_63697);

return statearr_63816;
})();
if(cljs.core.truth_(inst_63682)){
var statearr_63817_63880 = state_63773__$1;
(statearr_63817_63880[(1)] = (20));

} else {
var statearr_63818_63881 = state_63773__$1;
(statearr_63818_63881[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (11))){
var inst_63682 = (state_63773[(8)]);
var inst_63684 = (state_63773[(14)]);
var inst_63681 = (state_63773[(2)]);
var inst_63682__$1 = cljs.core.nth.call(null,inst_63681,(0),null);
var inst_63683 = cljs.core.nth.call(null,inst_63681,(1),null);
var inst_63684__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63685 = (inst_63682__$1 > inst_63684__$1);
var state_63773__$1 = (function (){var statearr_63820 = state_63773;
(statearr_63820[(8)] = inst_63682__$1);

(statearr_63820[(7)] = inst_63683);

(statearr_63820[(14)] = inst_63684__$1);

return statearr_63820;
})();
if(cljs.core.truth_(inst_63685)){
var statearr_63821_63882 = state_63773__$1;
(statearr_63821_63882[(1)] = (17));

} else {
var statearr_63822_63883 = state_63773__$1;
(statearr_63822_63883[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (9))){
var inst_63659 = (state_63773[(19)]);
var inst_63662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63663 = cljs.core.first.call(null,inst_63659);
var inst_63664 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_63663);
var state_63773__$1 = (function (){var statearr_63823 = state_63773;
(statearr_63823[(12)] = inst_63662);

return statearr_63823;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63773__$1,(12),inst_63664);
} else {
if((state_val_63774 === (5))){
var _ = (function (){var statearr_63824 = state_63773;
(statearr_63824[(4)] = cljs.core.rest.call(null,(state_63773[(4)])));

return statearr_63824;
})();
var state_63773__$1 = state_63773;
var ex63819 = (state_63773__$1[(2)]);
var statearr_63825_63884 = state_63773__$1;
(statearr_63825_63884[(5)] = ex63819);


var statearr_63826_63885 = state_63773__$1;
(statearr_63826_63885[(1)] = (4));

(statearr_63826_63885[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (14))){
var state_63773__$1 = state_63773;
var statearr_63827_63886 = state_63773__$1;
(statearr_63827_63886[(2)] = null);

(statearr_63827_63886[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (26))){
var inst_63682 = (state_63773[(8)]);
var inst_63708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63709 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_63710 = [inst_63682,inst_63709];
var inst_63711 = (new cljs.core.PersistentVector(null,2,(5),inst_63708,inst_63710,null));
var state_63773__$1 = state_63773;
var statearr_63828_63887 = state_63773__$1;
(statearr_63828_63887[(2)] = inst_63711);

(statearr_63828_63887[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (16))){
var inst_63672 = (state_63773[(2)]);
var inst_63673 = fluree.db.util.async.throw_err.call(null,inst_63672);
var state_63773__$1 = state_63773;
var statearr_63829_63888 = state_63773__$1;
(statearr_63829_63888[(2)] = inst_63673);

(statearr_63829_63888[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (38))){
var inst_63729 = (state_63773[(9)]);
var inst_63728 = (state_63773[(10)]);
var inst_63750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63751 = [inst_63729,inst_63728];
var inst_63752 = (new cljs.core.PersistentVector(null,2,(5),inst_63750,inst_63751,null));
var state_63773__$1 = state_63773;
var statearr_63830_63889 = state_63773__$1;
(statearr_63830_63889[(2)] = inst_63752);

(statearr_63830_63889[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (30))){
var state_63773__$1 = state_63773;
var statearr_63831_63890 = state_63773__$1;
(statearr_63831_63890[(2)] = null);

(statearr_63831_63890[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (10))){
var inst_63659 = (state_63773[(19)]);
var state_63773__$1 = state_63773;
var statearr_63832_63891 = state_63773__$1;
(statearr_63832_63891[(2)] = inst_63659);

(statearr_63832_63891[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (18))){
var state_63773__$1 = state_63773;
var statearr_63833_63892 = state_63773__$1;
(statearr_63833_63892[(2)] = null);

(statearr_63833_63892[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (42))){
var inst_63760 = (state_63773[(15)]);
var state_63773__$1 = state_63773;
var statearr_63834_63893 = state_63773__$1;
(statearr_63834_63893[(2)] = inst_63760);

(statearr_63834_63893[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (37))){
var inst_63729 = (state_63773[(9)]);
var inst_63728 = (state_63773[(10)]);
var inst_63747 = (state_63773[(2)]);
var inst_63748 = (inst_63729 < inst_63728);
var state_63773__$1 = (function (){var statearr_63835 = state_63773;
(statearr_63835[(21)] = inst_63747);

return statearr_63835;
})();
if(cljs.core.truth_(inst_63748)){
var statearr_63836_63894 = state_63773__$1;
(statearr_63836_63894[(1)] = (38));

} else {
var statearr_63837_63895 = state_63773__$1;
(statearr_63837_63895[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63774 === (8))){
var inst_63659 = (state_63773[(19)]);
var inst_63659__$1 = (state_63773[(2)]);
var inst_63660 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_63659__$1);
var state_63773__$1 = (function (){var statearr_63838 = state_63773;
(statearr_63838[(19)] = inst_63659__$1);

return statearr_63838;
})();
if(cljs.core.truth_(inst_63660)){
var statearr_63839_63896 = state_63773__$1;
(statearr_63839_63896[(1)] = (9));

} else {
var statearr_63840_63897 = state_63773__$1;
(statearr_63840_63897[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_63841 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63841[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_63841[(1)] = (1));

return statearr_63841;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_63773){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63773);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e63842){var ex__2749__auto__ = e63842;
var statearr_63843_63898 = state_63773;
(statearr_63843_63898[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63773[(4)]))){
var statearr_63844_63899 = state_63773;
(statearr_63844_63899[(1)] = cljs.core.first.call(null,(state_63773[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63900 = state_63773;
state_63773 = G__63900;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_63773){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_63773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_63845 = f__2769__auto__.call(null);
(statearr_63845[(6)] = c__2768__auto__);

return statearr_63845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__63902 = arguments.length;
switch (G__63902) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_63993){
var state_val_63994 = (state_63993[(1)]);
if((state_val_63994 === (7))){
var inst_63925 = (state_63993[(7)]);
var inst_63928 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_63925);
var state_63993__$1 = state_63993;
var statearr_63995_64046 = state_63993__$1;
(statearr_63995_64046[(2)] = inst_63928);

(statearr_63995_64046[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (20))){
var inst_63964 = (state_63993[(8)]);
var inst_63967 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_63964);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63993__$1,(23),inst_63967);
} else {
if((state_val_63994 === (27))){
var inst_63973 = (state_63993[(9)]);
var inst_63979 = cljs.core.doall.call(null,inst_63973);
var state_63993__$1 = state_63993;
var statearr_63996_64047 = state_63993__$1;
(statearr_63996_64047[(2)] = inst_63979);

(statearr_63996_64047[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (1))){
var state_63993__$1 = state_63993;
var statearr_63997_64048 = state_63993__$1;
(statearr_63997_64048[(2)] = null);

(statearr_63997_64048[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (24))){
var inst_63973 = (state_63993[(9)]);
var inst_63976 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_63977 = cljs.core.sequential_QMARK_.call(null,inst_63973);
var state_63993__$1 = (function (){var statearr_63998 = state_63993;
(statearr_63998[(10)] = inst_63976);

return statearr_63998;
})();
if(inst_63977){
var statearr_63999_64049 = state_63993__$1;
(statearr_63999_64049[(1)] = (27));

} else {
var statearr_64000_64050 = state_63993__$1;
(statearr_64000_64050[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (4))){
var inst_63903 = (state_63993[(2)]);
var inst_63904 = fluree.db.util.log.error.call(null,inst_63903);
var inst_63905 = cljs.core.ex_data.call(null,inst_63903);
var inst_63906 = cljs.core.ex_message.call(null,inst_63903);
var inst_63907 = cljs.core.assoc.call(null,inst_63905,new cljs.core.Keyword(null,"message","message",-406056002),inst_63906);
var state_63993__$1 = (function (){var statearr_64001 = state_63993;
(statearr_64001[(11)] = inst_63904);

return statearr_64001;
})();
var statearr_64002_64051 = state_63993__$1;
(statearr_64002_64051[(2)] = inst_63907);

(statearr_64002_64051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (15))){
var inst_63925 = (state_63993[(7)]);
var inst_63938 = (state_63993[(2)]);
var inst_63939 = cljs.core.ex_info.call(null,inst_63938,inst_63925);
var inst_63940 = (function(){throw inst_63939})();
var state_63993__$1 = state_63993;
var statearr_64003_64052 = state_63993__$1;
(statearr_64003_64052[(2)] = inst_63940);

(statearr_64003_64052[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (21))){
var inst_63964 = (state_63993[(8)]);
var state_63993__$1 = state_63993;
var statearr_64004_64053 = state_63993__$1;
(statearr_64004_64053[(2)] = inst_63964);

(statearr_64004_64053[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (13))){
var inst_63933 = (state_63993[(12)]);
var state_63993__$1 = state_63993;
var statearr_64005_64054 = state_63993__$1;
(statearr_64005_64054[(2)] = inst_63933);

(statearr_64005_64054[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (22))){
var inst_63973 = (state_63993[(2)]);
var inst_63974 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_63993__$1 = (function (){var statearr_64006 = state_63993;
(statearr_64006[(9)] = inst_63973);

return statearr_64006;
})();
if(cljs.core.truth_(inst_63974)){
var statearr_64007_64055 = state_63993__$1;
(statearr_64007_64055[(1)] = (24));

} else {
var statearr_64008_64056 = state_63993__$1;
(statearr_64008_64056[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (29))){
var inst_63917 = (state_63993[(13)]);
var inst_63976 = (state_63993[(10)]);
var inst_63982 = (state_63993[(2)]);
var inst_63983 = fluree.db.util.core.response_time_formatted.call(null,inst_63917);
var inst_63984 = [(200),inst_63982,(100),inst_63983];
var inst_63985 = cljs.core.PersistentHashMap.fromArrays(inst_63976,inst_63984);
var state_63993__$1 = state_63993;
var statearr_64009_64057 = state_63993__$1;
(statearr_64009_64057[(2)] = inst_63985);

(statearr_64009_64057[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (6))){
var inst_63925 = (state_63993[(7)]);
var inst_63926 = (state_63993[(14)]);
var inst_63924 = (state_63993[(2)]);
var inst_63925__$1 = fluree.db.util.async.throw_err.call(null,inst_63924);
var inst_63926__$1 = cljs.core.map_QMARK_.call(null,inst_63925__$1);
var state_63993__$1 = (function (){var statearr_64010 = state_63993;
(statearr_64010[(7)] = inst_63925__$1);

(statearr_64010[(14)] = inst_63926__$1);

return statearr_64010;
})();
if(inst_63926__$1){
var statearr_64011_64058 = state_63993__$1;
(statearr_64011_64058[(1)] = (7));

} else {
var statearr_64012_64059 = state_63993__$1;
(statearr_64012_64059[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (28))){
var inst_63973 = (state_63993[(9)]);
var state_63993__$1 = state_63993;
var statearr_64013_64060 = state_63993__$1;
(statearr_64013_64060[(2)] = inst_63973);

(statearr_64013_64060[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (25))){
var inst_63973 = (state_63993[(9)]);
var state_63993__$1 = state_63993;
var statearr_64014_64061 = state_63993__$1;
(statearr_64014_64061[(2)] = inst_63973);

(statearr_64014_64061[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (17))){
var inst_63956 = cljs.core.pr_str.call(null,query_map);
var inst_63957 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_63956].join('');
var inst_63958 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63959 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63960 = cljs.core.PersistentHashMap.fromArrays(inst_63958,inst_63959);
var inst_63961 = cljs.core.ex_info.call(null,inst_63957,inst_63960);
var inst_63962 = (function(){throw inst_63961})();
var state_63993__$1 = state_63993;
var statearr_64015_64062 = state_63993__$1;
(statearr_64015_64062[(2)] = inst_63962);

(statearr_64015_64062[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (3))){
var inst_63991 = (state_63993[(2)]);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63993__$1,inst_63991);
} else {
if((state_val_63994 === (12))){
var inst_63925 = (state_63993[(7)]);
var inst_63943 = (state_63993[(2)]);
var inst_63944 = cljs.core.nth.call(null,inst_63925,(0),null);
var inst_63945 = cljs.core.nth.call(null,inst_63925,(1),null);
var inst_63946 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_63947 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_63948 = cljs.core.keys.call(null,inst_63947);
var inst_63949 = cljs.core._EQ_.call(null,inst_63946,inst_63948);
var state_63993__$1 = (function (){var statearr_64016 = state_63993;
(statearr_64016[(15)] = inst_63943);

(statearr_64016[(16)] = inst_63945);

(statearr_64016[(17)] = inst_63944);

return statearr_64016;
})();
if(inst_63949){
var statearr_64017_64063 = state_63993__$1;
(statearr_64017_64063[(1)] = (16));

} else {
var statearr_64018_64064 = state_63993__$1;
(statearr_64018_64064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (2))){
var _ = (function (){var statearr_64019 = state_63993;
(statearr_64019[(4)] = cljs.core.cons.call(null,(5),(state_63993[(4)])));

return statearr_64019;
})();
var inst_63917 = fluree.db.util.core.current_time_millis.call(null);
var inst_63918 = db;
var inst_63919 = cljs.core.__destructure_map.call(null,inst_63918);
var inst_63920 = cljs.core.get.call(null,inst_63919,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_63921 = cljs.core.get.call(null,inst_63919,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_63922 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_63993__$1 = (function (){var statearr_64020 = state_63993;
(statearr_64020[(18)] = inst_63920);

(statearr_64020[(13)] = inst_63917);

(statearr_64020[(19)] = inst_63921);

return statearr_64020;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63993__$1,(6),inst_63922);
} else {
if((state_val_63994 === (23))){
var inst_63969 = (state_63993[(2)]);
var inst_63970 = fluree.db.util.async.throw_err.call(null,inst_63969);
var state_63993__$1 = state_63993;
var statearr_64021_64065 = state_63993__$1;
(statearr_64021_64065[(2)] = inst_63970);

(statearr_64021_64065[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (19))){
var inst_63953 = (state_63993[(2)]);
var inst_63954 = fluree.db.util.async.throw_err.call(null,inst_63953);
var state_63993__$1 = state_63993;
var statearr_64022_64066 = state_63993__$1;
(statearr_64022_64066[(2)] = inst_63954);

(statearr_64022_64066[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (11))){
var state_63993__$1 = state_63993;
var statearr_64024_64067 = state_63993__$1;
(statearr_64024_64067[(2)] = null);

(statearr_64024_64067[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (9))){
var inst_63931 = (state_63993[(2)]);
var state_63993__$1 = state_63993;
if(cljs.core.truth_(inst_63931)){
var statearr_64025_64068 = state_63993__$1;
(statearr_64025_64068[(1)] = (10));

} else {
var statearr_64026_64069 = state_63993__$1;
(statearr_64026_64069[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (5))){
var _ = (function (){var statearr_64027 = state_63993;
(statearr_64027[(4)] = cljs.core.rest.call(null,(state_63993[(4)])));

return statearr_64027;
})();
var state_63993__$1 = state_63993;
var ex64023 = (state_63993__$1[(2)]);
var statearr_64028_64070 = state_63993__$1;
(statearr_64028_64070[(5)] = ex64023);


var statearr_64029_64071 = state_63993__$1;
(statearr_64029_64071[(1)] = (4));

(statearr_64029_64071[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (14))){
var inst_63920 = (state_63993[(18)]);
var inst_63921 = (state_63993[(19)]);
var inst_63936 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63920),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63921)].join('');
var state_63993__$1 = state_63993;
var statearr_64030_64072 = state_63993__$1;
(statearr_64030_64072[(2)] = inst_63936);

(statearr_64030_64072[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (26))){
var inst_63988 = (state_63993[(2)]);
var _ = (function (){var statearr_64031 = state_63993;
(statearr_64031[(4)] = cljs.core.rest.call(null,(state_63993[(4)])));

return statearr_64031;
})();
var state_63993__$1 = state_63993;
var statearr_64032_64073 = state_63993__$1;
(statearr_64032_64073[(2)] = inst_63988);

(statearr_64032_64073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (16))){
var inst_63945 = (state_63993[(16)]);
var inst_63944 = (state_63993[(17)]);
var inst_63951 = fluree.db.query.block.block_range.call(null,db,inst_63944,inst_63945,opts);
var state_63993__$1 = state_63993;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63993__$1,(19),inst_63951);
} else {
if((state_val_63994 === (10))){
var inst_63925 = (state_63993[(7)]);
var inst_63933 = (state_63993[(12)]);
var inst_63933__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_63925);
var state_63993__$1 = (function (){var statearr_64033 = state_63993;
(statearr_64033[(12)] = inst_63933__$1);

return statearr_64033;
})();
if(cljs.core.truth_(inst_63933__$1)){
var statearr_64034_64074 = state_63993__$1;
(statearr_64034_64074[(1)] = (13));

} else {
var statearr_64035_64075 = state_63993__$1;
(statearr_64035_64075[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (18))){
var inst_63964 = (state_63993[(2)]);
var inst_63965 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_63993__$1 = (function (){var statearr_64036 = state_63993;
(statearr_64036[(8)] = inst_63964);

return statearr_64036;
})();
if(cljs.core.truth_(inst_63965)){
var statearr_64037_64076 = state_63993__$1;
(statearr_64037_64076[(1)] = (20));

} else {
var statearr_64038_64077 = state_63993__$1;
(statearr_64038_64077[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63994 === (8))){
var inst_63926 = (state_63993[(14)]);
var state_63993__$1 = state_63993;
var statearr_64039_64078 = state_63993__$1;
(statearr_64039_64078[(2)] = inst_63926);

(statearr_64039_64078[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64040[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64040[(1)] = (1));

return statearr_64040;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_63993){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_63993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64041){var ex__2749__auto__ = e64041;
var statearr_64042_64079 = state_63993;
(statearr_64042_64079[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_63993[(4)]))){
var statearr_64043_64080 = state_63993;
(statearr_64043_64080[(1)] = cljs.core.first.call(null,(state_63993[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64081 = state_63993;
state_63993 = G__64081;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_63993){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_63993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64044 = f__2769__auto__.call(null);
(statearr_64044[(6)] = c__2768__auto__);

return statearr_64044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64083 = arguments.length;
switch (G__64083) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64278){
var state_val_64279 = (state_64278[(1)]);
if((state_val_64279 === (62))){
var inst_64276 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64278__$1,inst_64276);
} else {
if((state_val_64279 === (7))){
var inst_64104 = (state_64278[(7)]);
var inst_64114 = cljs.core.not_EQ_.call(null,(1),inst_64104);
var state_64278__$1 = state_64278;
var statearr_64280_64371 = state_64278__$1;
(statearr_64280_64371[(2)] = inst_64114);

(statearr_64280_64371[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (59))){
var inst_64264 = (state_64278[(2)]);
var inst_64265 = fluree.db.util.async.throw_err.call(null,inst_64264);
var state_64278__$1 = state_64278;
var statearr_64281_64372 = state_64278__$1;
(statearr_64281_64372[(2)] = inst_64265);

(statearr_64281_64372[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (20))){
var inst_64180 = (state_64278[(8)]);
var inst_64172 = (state_64278[(9)]);
var inst_64172__$1 = (state_64278[(2)]);
var inst_64173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64174 = cljs.core.get.call(null,inst_64172__$1,(0));
var inst_64175 = cljs.core.get.call(null,inst_64172__$1,(1));
var inst_64176 = cljs.core.get.call(null,inst_64172__$1,(2));
var inst_64177 = cljs.core.get.call(null,inst_64172__$1,(3));
var inst_64178 = [inst_64174,inst_64175,inst_64176,inst_64177];
var inst_64179 = (new cljs.core.PersistentVector(null,4,(5),inst_64173,inst_64178,null));
var inst_64180__$1 = cljs.core.nth.call(null,inst_64179,(0),null);
var inst_64181 = cljs.core.nth.call(null,inst_64179,(1),null);
var inst_64182 = cljs.core.nth.call(null,inst_64179,(2),null);
var inst_64183 = cljs.core.nth.call(null,inst_64179,(3),null);
var inst_64184 = (inst_64180__$1 == null);
var inst_64185 = cljs.core.not.call(null,inst_64184);
var state_64278__$1 = (function (){var statearr_64282 = state_64278;
(statearr_64282[(10)] = inst_64181);

(statearr_64282[(11)] = inst_64182);

(statearr_64282[(8)] = inst_64180__$1);

(statearr_64282[(12)] = inst_64183);

(statearr_64282[(9)] = inst_64172__$1);

return statearr_64282;
})();
if(inst_64185){
var statearr_64283_64373 = state_64278__$1;
(statearr_64283_64373[(1)] = (30));

} else {
var statearr_64284_64374 = state_64278__$1;
(statearr_64284_64374[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (58))){
var inst_64112 = (state_64278[(13)]);
var inst_64268 = (state_64278[(2)]);
var state_64278__$1 = (function (){var statearr_64285 = state_64278;
(statearr_64285[(14)] = inst_64268);

return statearr_64285;
})();
if(cljs.core.truth_(inst_64112)){
var statearr_64286_64375 = state_64278__$1;
(statearr_64286_64375[(1)] = (60));

} else {
var statearr_64287_64376 = state_64278__$1;
(statearr_64287_64376[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (60))){
var inst_64268 = (state_64278[(14)]);
var inst_64256 = (state_64278[(15)]);
var inst_64270 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64271 = cljs.core.count.call(null,inst_64256);
var inst_64272 = [inst_64268,inst_64271,(200)];
var inst_64273 = cljs.core.PersistentHashMap.fromArrays(inst_64270,inst_64272);
var state_64278__$1 = state_64278;
var statearr_64288_64377 = state_64278__$1;
(statearr_64288_64377[(2)] = inst_64273);

(statearr_64288_64377[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (27))){
var inst_64091 = (state_64278[(16)]);
var inst_64160 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64091)].join('');
var inst_64161 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64162 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64163 = cljs.core.PersistentHashMap.fromArrays(inst_64161,inst_64162);
var inst_64164 = cljs.core.ex_info.call(null,inst_64160,inst_64163);
var inst_64165 = (function(){throw inst_64164})();
var state_64278__$1 = state_64278;
var statearr_64289_64378 = state_64278__$1;
(statearr_64289_64378[(2)] = inst_64165);

(statearr_64289_64378[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (1))){
var inst_64088 = query_map;
var inst_64089 = cljs.core.__destructure_map.call(null,inst_64088);
var inst_64090 = cljs.core.get.call(null,inst_64089,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64091 = cljs.core.get.call(null,inst_64089,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64092 = cljs.core.get.call(null,inst_64089,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_64278__$1 = (function (){var statearr_64290 = state_64278;
(statearr_64290[(17)] = inst_64092);

(statearr_64290[(18)] = inst_64090);

(statearr_64290[(16)] = inst_64091);

return statearr_64290;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(2),sources);
} else {
if((state_val_64279 === (24))){
var inst_64091 = (state_64278[(16)]);
var inst_64149 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64091)].join('');
var inst_64150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64151 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64152 = cljs.core.PersistentHashMap.fromArrays(inst_64150,inst_64151);
var inst_64153 = cljs.core.ex_info.call(null,inst_64149,inst_64152);
var inst_64154 = (function(){throw inst_64153})();
var state_64278__$1 = state_64278;
var statearr_64291_64379 = state_64278__$1;
(statearr_64291_64379[(2)] = inst_64154);

(statearr_64291_64379[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (55))){
var inst_64092 = (state_64278[(17)]);
var inst_64259 = (state_64278[(2)]);
var inst_64260 = fluree.db.util.async.throw_err.call(null,inst_64259);
var state_64278__$1 = (function (){var statearr_64292 = state_64278;
(statearr_64292[(19)] = inst_64260);

return statearr_64292;
})();
if(cljs.core.truth_(inst_64092)){
var statearr_64293_64380 = state_64278__$1;
(statearr_64293_64380[(1)] = (56));

} else {
var statearr_64294_64381 = state_64278__$1;
(statearr_64294_64381[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (39))){
var inst_64181 = (state_64278[(10)]);
var inst_64182 = (state_64278[(11)]);
var inst_64180 = (state_64278[(8)]);
var inst_64183 = (state_64278[(12)]);
var inst_64204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64206 = [inst_64181,inst_64180,inst_64182,inst_64183];
var inst_64207 = (new cljs.core.PersistentVector(null,4,(5),inst_64205,inst_64206,null));
var inst_64208 = [inst_64207,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_64209 = (new cljs.core.PersistentVector(null,2,(5),inst_64204,inst_64208,null));
var state_64278__$1 = state_64278;
var statearr_64295_64382 = state_64278__$1;
(statearr_64295_64382[(2)] = inst_64209);

(statearr_64295_64382[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (46))){
var inst_64214 = (state_64278[(20)]);
var state_64278__$1 = state_64278;
var statearr_64296_64383 = state_64278__$1;
(statearr_64296_64383[(2)] = inst_64214);

(statearr_64296_64383[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (4))){
var state_64278__$1 = state_64278;
var statearr_64297_64384 = state_64278__$1;
(statearr_64297_64384[(2)] = null);

(statearr_64297_64384[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (54))){
var inst_64256 = (state_64278[(15)]);
var inst_64095 = (state_64278[(21)]);
var inst_64255 = (state_64278[(2)]);
var inst_64256__$1 = fluree.db.util.async.throw_err.call(null,inst_64255);
var inst_64257 = fluree.db.api_js.format_history_resp.call(null,inst_64095,inst_64256__$1);
var state_64278__$1 = (function (){var statearr_64298 = state_64278;
(statearr_64298[(15)] = inst_64256__$1);

return statearr_64298;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(55),inst_64257);
} else {
if((state_val_64279 === (15))){
var inst_64095 = (state_64278[(21)]);
var inst_64136 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64095);
var state_64278__$1 = state_64278;
var statearr_64299_64385 = state_64278__$1;
(statearr_64299_64385[(2)] = inst_64136);

(statearr_64299_64385[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (48))){
var inst_64181 = (state_64278[(10)]);
var inst_64182 = (state_64278[(11)]);
var inst_64180 = (state_64278[(8)]);
var inst_64183 = (state_64278[(12)]);
var inst_64225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64227 = [inst_64181,inst_64182,inst_64180,inst_64183];
var inst_64228 = (new cljs.core.PersistentVector(null,4,(5),inst_64226,inst_64227,null));
var inst_64229 = [inst_64228,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_64230 = (new cljs.core.PersistentVector(null,2,(5),inst_64225,inst_64229,null));
var state_64278__$1 = state_64278;
var statearr_64300_64386 = state_64278__$1;
(statearr_64300_64386[(2)] = inst_64230);

(statearr_64300_64386[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (50))){
var inst_64243 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64301_64387 = state_64278__$1;
(statearr_64301_64387[(2)] = inst_64243);

(statearr_64301_64387[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (21))){
var inst_64091 = (state_64278[(16)]);
var inst_64147 = cljs.core.empty_QMARK_.call(null,inst_64091);
var state_64278__$1 = state_64278;
if(inst_64147){
var statearr_64302_64388 = state_64278__$1;
(statearr_64302_64388[(1)] = (24));

} else {
var statearr_64303_64389 = state_64278__$1;
(statearr_64303_64389[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (31))){
var inst_64191 = (state_64278[(22)]);
var inst_64180 = (state_64278[(8)]);
var inst_64191__$1 = (inst_64180 == null);
var state_64278__$1 = (function (){var statearr_64304 = state_64278;
(statearr_64304[(22)] = inst_64191__$1);

return statearr_64304;
})();
if(cljs.core.truth_(inst_64191__$1)){
var statearr_64305_64390 = state_64278__$1;
(statearr_64305_64390[(1)] = (33));

} else {
var statearr_64306_64391 = state_64278__$1;
(statearr_64306_64391[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (32))){
var inst_64128 = (state_64278[(23)]);
var inst_64138 = (state_64278[(24)]);
var inst_64095 = (state_64278[(21)]);
var inst_64247 = (state_64278[(2)]);
var inst_64248 = cljs.core.nth.call(null,inst_64247,(0),null);
var inst_64249 = cljs.core.nth.call(null,inst_64247,(1),null);
var inst_64250 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_64251 = [inst_64128,inst_64138];
var inst_64252 = cljs.core.PersistentHashMap.fromArrays(inst_64250,inst_64251);
var inst_64253 = fluree.db.query.range.time_range.call(null,inst_64095,inst_64249,cljs.core._EQ_,inst_64248,inst_64252);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(54),inst_64253);
} else {
if((state_val_64279 === (40))){
var inst_64180 = (state_64278[(8)]);
var inst_64211 = (state_64278[(25)]);
var inst_64211__$1 = (inst_64180 == null);
var state_64278__$1 = (function (){var statearr_64307 = state_64278;
(statearr_64307[(25)] = inst_64211__$1);

return statearr_64307;
})();
if(cljs.core.truth_(inst_64211__$1)){
var statearr_64308_64392 = state_64278__$1;
(statearr_64308_64392[(1)] = (42));

} else {
var statearr_64309_64393 = state_64278__$1;
(statearr_64309_64393[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (56))){
var inst_64260 = (state_64278[(19)]);
var inst_64095 = (state_64278[(21)]);
var inst_64262 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_64095,inst_64260);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(59),inst_64262);
} else {
if((state_val_64279 === (33))){
var inst_64181 = (state_64278[(10)]);
var inst_64194 = (state_64278[(26)]);
var inst_64193 = (inst_64181 == null);
var inst_64194__$1 = cljs.core.not.call(null,inst_64193);
var state_64278__$1 = (function (){var statearr_64310 = state_64278;
(statearr_64310[(26)] = inst_64194__$1);

return statearr_64310;
})();
if(inst_64194__$1){
var statearr_64311_64394 = state_64278__$1;
(statearr_64311_64394[(1)] = (36));

} else {
var statearr_64312_64395 = state_64278__$1;
(statearr_64312_64395[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (13))){
var inst_64122 = (state_64278[(2)]);
var inst_64123 = fluree.db.util.async.throw_err.call(null,inst_64122);
var inst_64124 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64123);
var inst_64125 = (inst_64124 - (1));
var state_64278__$1 = state_64278;
var statearr_64313_64396 = state_64278__$1;
(statearr_64313_64396[(2)] = inst_64125);

(statearr_64313_64396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (22))){
var state_64278__$1 = state_64278;
var statearr_64314_64397 = state_64278__$1;
(statearr_64314_64397[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (36))){
var inst_64182 = (state_64278[(11)]);
var inst_64196 = (inst_64182 == null);
var state_64278__$1 = state_64278;
var statearr_64316_64398 = state_64278__$1;
(statearr_64316_64398[(2)] = inst_64196);

(statearr_64316_64398[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (41))){
var inst_64245 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64317_64399 = state_64278__$1;
(statearr_64317_64399[(2)] = inst_64245);

(statearr_64317_64399[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (43))){
var inst_64211 = (state_64278[(25)]);
var state_64278__$1 = state_64278;
var statearr_64318_64400 = state_64278__$1;
(statearr_64318_64400[(2)] = inst_64211);

(statearr_64318_64400[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (61))){
var inst_64268 = (state_64278[(14)]);
var state_64278__$1 = state_64278;
var statearr_64319_64401 = state_64278__$1;
(statearr_64319_64401[(2)] = inst_64268);

(statearr_64319_64401[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (29))){
var inst_64168 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64320_64402 = state_64278__$1;
(statearr_64320_64402[(2)] = inst_64168);

(statearr_64320_64402[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (44))){
var inst_64223 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
if(cljs.core.truth_(inst_64223)){
var statearr_64321_64403 = state_64278__$1;
(statearr_64321_64403[(1)] = (48));

} else {
var statearr_64322_64404 = state_64278__$1;
(statearr_64322_64404[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (6))){
var inst_64099 = (state_64278[(2)]);
var inst_64100 = fluree.db.util.async.throw_err.call(null,inst_64099);
var state_64278__$1 = state_64278;
var statearr_64323_64405 = state_64278__$1;
(statearr_64323_64405[(2)] = inst_64100);

(statearr_64323_64405[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (28))){
var state_64278__$1 = state_64278;
var statearr_64324_64406 = state_64278__$1;
(statearr_64324_64406[(2)] = null);

(statearr_64324_64406[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (51))){
var inst_64091 = (state_64278[(16)]);
var inst_64233 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64091)].join('');
var inst_64234 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64235 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64236 = cljs.core.PersistentHashMap.fromArrays(inst_64234,inst_64235);
var inst_64237 = cljs.core.ex_info.call(null,inst_64233,inst_64236);
var inst_64238 = (function(){throw inst_64237})();
var state_64278__$1 = state_64278;
var statearr_64325_64407 = state_64278__$1;
(statearr_64325_64407[(2)] = inst_64238);

(statearr_64325_64407[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (25))){
var inst_64091 = (state_64278[(16)]);
var state_64278__$1 = state_64278;
var statearr_64326_64408 = state_64278__$1;
(statearr_64326_64408[(2)] = inst_64091);

(statearr_64326_64408[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (34))){
var inst_64191 = (state_64278[(22)]);
var state_64278__$1 = state_64278;
var statearr_64327_64409 = state_64278__$1;
(statearr_64327_64409[(2)] = inst_64191);

(statearr_64327_64409[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (17))){
var inst_64132 = (state_64278[(2)]);
var inst_64133 = fluree.db.util.async.throw_err.call(null,inst_64132);
var inst_64134 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64133);
var state_64278__$1 = state_64278;
var statearr_64328_64410 = state_64278__$1;
(statearr_64328_64410[(2)] = inst_64134);

(statearr_64328_64410[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (3))){
var inst_64095 = (state_64278[(21)]);
var inst_64097 = fluree.db.api_js.resolve_block_range.call(null,inst_64095,query_map);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(6),inst_64097);
} else {
if((state_val_64279 === (12))){
var inst_64105 = (state_64278[(27)]);
var inst_64128 = (state_64278[(2)]);
var state_64278__$1 = (function (){var statearr_64329 = state_64278;
(statearr_64329[(23)] = inst_64128);

return statearr_64329;
})();
if(cljs.core.truth_(inst_64105)){
var statearr_64330_64411 = state_64278__$1;
(statearr_64330_64411[(1)] = (14));

} else {
var statearr_64331_64412 = state_64278__$1;
(statearr_64331_64412[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (2))){
var inst_64090 = (state_64278[(18)]);
var inst_64094 = (state_64278[(2)]);
var inst_64095 = fluree.db.util.async.throw_err.call(null,inst_64094);
var state_64278__$1 = (function (){var statearr_64332 = state_64278;
(statearr_64332[(21)] = inst_64095);

return statearr_64332;
})();
if(cljs.core.truth_(inst_64090)){
var statearr_64333_64413 = state_64278__$1;
(statearr_64333_64413[(1)] = (3));

} else {
var statearr_64334_64414 = state_64278__$1;
(statearr_64334_64414[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (23))){
var inst_64170 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64335_64415 = state_64278__$1;
(statearr_64335_64415[(2)] = inst_64170);

(statearr_64335_64415[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (47))){
var inst_64220 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64336_64416 = state_64278__$1;
(statearr_64336_64416[(2)] = inst_64220);

(statearr_64336_64416[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (35))){
var inst_64202 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
if(cljs.core.truth_(inst_64202)){
var statearr_64337_64417 = state_64278__$1;
(statearr_64337_64417[(1)] = (39));

} else {
var statearr_64338_64418 = state_64278__$1;
(statearr_64338_64418[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (19))){
var inst_64091 = (state_64278[(16)]);
var inst_64145 = cljs.core.sequential_QMARK_.call(null,inst_64091);
var state_64278__$1 = state_64278;
if(inst_64145){
var statearr_64339_64419 = state_64278__$1;
(statearr_64339_64419[(1)] = (21));

} else {
var statearr_64340_64420 = state_64278__$1;
(statearr_64340_64420[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (57))){
var inst_64260 = (state_64278[(19)]);
var state_64278__$1 = state_64278;
var statearr_64341_64421 = state_64278__$1;
(statearr_64341_64421[(2)] = inst_64260);

(statearr_64341_64421[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (11))){
var state_64278__$1 = state_64278;
var statearr_64342_64422 = state_64278__$1;
(statearr_64342_64422[(2)] = (-1));

(statearr_64342_64422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (9))){
var inst_64117 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
if(cljs.core.truth_(inst_64117)){
var statearr_64343_64423 = state_64278__$1;
(statearr_64343_64423[(1)] = (10));

} else {
var statearr_64344_64424 = state_64278__$1;
(statearr_64344_64424[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (5))){
var inst_64104 = (state_64278[(7)]);
var inst_64103 = (state_64278[(2)]);
var inst_64104__$1 = cljs.core.nth.call(null,inst_64103,(0),null);
var inst_64105 = cljs.core.nth.call(null,inst_64103,(1),null);
var inst_64112 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64278__$1 = (function (){var statearr_64345 = state_64278;
(statearr_64345[(7)] = inst_64104__$1);

(statearr_64345[(27)] = inst_64105);

(statearr_64345[(13)] = inst_64112);

return statearr_64345;
})();
if(cljs.core.truth_(inst_64104__$1)){
var statearr_64346_64425 = state_64278__$1;
(statearr_64346_64425[(1)] = (7));

} else {
var statearr_64347_64426 = state_64278__$1;
(statearr_64347_64426[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (14))){
var inst_64105 = (state_64278[(27)]);
var inst_64095 = (state_64278[(21)]);
var inst_64130 = fluree.db.time_travel.as_of_block.call(null,inst_64095,inst_64105);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(17),inst_64130);
} else {
if((state_val_64279 === (45))){
var inst_64182 = (state_64278[(11)]);
var inst_64216 = (inst_64182 == null);
var inst_64217 = cljs.core.not.call(null,inst_64216);
var state_64278__$1 = state_64278;
var statearr_64348_64427 = state_64278__$1;
(statearr_64348_64427[(2)] = inst_64217);

(statearr_64348_64427[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (53))){
var inst_64241 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64349_64428 = state_64278__$1;
(statearr_64349_64428[(2)] = inst_64241);

(statearr_64349_64428[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (26))){
var inst_64157 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64350_64429 = state_64278__$1;
(statearr_64350_64429[(2)] = inst_64157);

(statearr_64350_64429[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (16))){
var inst_64091 = (state_64278[(16)]);
var inst_64138 = (state_64278[(2)]);
var inst_64139 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_64091);
var state_64278__$1 = (function (){var statearr_64351 = state_64278;
(statearr_64351[(24)] = inst_64138);

return statearr_64351;
})();
if(inst_64139){
var statearr_64352_64430 = state_64278__$1;
(statearr_64352_64430[(1)] = (18));

} else {
var statearr_64353_64431 = state_64278__$1;
(statearr_64353_64431[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (38))){
var inst_64199 = (state_64278[(2)]);
var state_64278__$1 = state_64278;
var statearr_64354_64432 = state_64278__$1;
(statearr_64354_64432[(2)] = inst_64199);

(statearr_64354_64432[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (30))){
var inst_64172 = (state_64278[(9)]);
var inst_64187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64188 = [inst_64172,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_64189 = (new cljs.core.PersistentVector(null,2,(5),inst_64187,inst_64188,null));
var state_64278__$1 = state_64278;
var statearr_64355_64433 = state_64278__$1;
(statearr_64355_64433[(2)] = inst_64189);

(statearr_64355_64433[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (10))){
var inst_64104 = (state_64278[(7)]);
var inst_64095 = (state_64278[(21)]);
var inst_64119 = (inst_64104 - (1));
var inst_64120 = fluree.db.time_travel.as_of_block.call(null,inst_64095,inst_64119);
var state_64278__$1 = state_64278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64278__$1,(13),inst_64120);
} else {
if((state_val_64279 === (18))){
var inst_64091 = (state_64278[(16)]);
var inst_64141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64142 = [inst_64091];
var inst_64143 = (new cljs.core.PersistentVector(null,1,(5),inst_64141,inst_64142,null));
var state_64278__$1 = state_64278;
var statearr_64356_64434 = state_64278__$1;
(statearr_64356_64434[(2)] = inst_64143);

(statearr_64356_64434[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (52))){
var state_64278__$1 = state_64278;
var statearr_64357_64435 = state_64278__$1;
(statearr_64357_64435[(2)] = null);

(statearr_64357_64435[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (42))){
var inst_64181 = (state_64278[(10)]);
var inst_64214 = (state_64278[(20)]);
var inst_64213 = (inst_64181 == null);
var inst_64214__$1 = cljs.core.not.call(null,inst_64213);
var state_64278__$1 = (function (){var statearr_64358 = state_64278;
(statearr_64358[(20)] = inst_64214__$1);

return statearr_64358;
})();
if(inst_64214__$1){
var statearr_64359_64436 = state_64278__$1;
(statearr_64359_64436[(1)] = (45));

} else {
var statearr_64360_64437 = state_64278__$1;
(statearr_64360_64437[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (37))){
var inst_64194 = (state_64278[(26)]);
var state_64278__$1 = state_64278;
var statearr_64361_64438 = state_64278__$1;
(statearr_64361_64438[(2)] = inst_64194);

(statearr_64361_64438[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (8))){
var inst_64104 = (state_64278[(7)]);
var state_64278__$1 = state_64278;
var statearr_64362_64439 = state_64278__$1;
(statearr_64362_64439[(2)] = inst_64104);

(statearr_64362_64439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64279 === (49))){
var state_64278__$1 = state_64278;
var statearr_64363_64440 = state_64278__$1;
(statearr_64363_64440[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64365 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64365[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64365[(1)] = (1));

return statearr_64365;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64278){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64366){var ex__2749__auto__ = e64366;
var statearr_64367_64441 = state_64278;
(statearr_64367_64441[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64278[(4)]))){
var statearr_64368_64442 = state_64278;
(statearr_64368_64442[(1)] = cljs.core.first.call(null,(state_64278[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64443 = state_64278;
state_64278 = G__64443;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64278){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64369 = f__2769__auto__.call(null);
(statearr_64369[(6)] = c__2768__auto__);

return statearr_64369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__64451 = arguments.length;
switch (G__64451) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__64444_SHARP_){
return cljs.core.dissoc.call(null,p1__64444_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64540){
var state_val_64541 = (state_64540[(1)]);
if((state_val_64541 === (7))){
var inst_64494 = (state_64540[(7)]);
var inst_64491 = (state_64540[(8)]);
var inst_64497 = (state_64540[(9)]);
var inst_64501 = (state_64540[(10)]);
var inst_64507 = (function (){var responses = inst_64491;
var responses_STAR_ = inst_64494;
var statuses = inst_64497;
var fuel = inst_64501;
return (function (p1__64447_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__64447_SHARP_);
});
})();
var inst_64508 = cljs.core.some.call(null,inst_64507,inst_64497);
var state_64540__$1 = state_64540;
if(cljs.core.truth_(inst_64508)){
var statearr_64542_64590 = state_64540__$1;
(statearr_64542_64590[(1)] = (9));

} else {
var statearr_64543_64591 = state_64540__$1;
(statearr_64543_64591[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (20))){
var inst_64535 = (state_64540[(2)]);
var state_64540__$1 = state_64540;
var statearr_64544_64592 = state_64540__$1;
(statearr_64544_64592[(2)] = inst_64535);

(statearr_64544_64592[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (1))){
var inst_64486 = cljs.core.async.chan.call(null,(1));
var inst_64487 = (function (){var c__2768__auto____$1 = inst_64486;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64484){
var state_val_64485 = (state_64484[(1)]);
if((state_val_64485 === (1))){
var inst_64452 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_64453 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_64454 = cljs.core.assoc.call(null,inst_64453,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_64455 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_64456 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_64457 = cljs.core.PersistentHashMap.EMPTY;
var inst_64458 = inst_64452;
var inst_64459 = inst_64454;
var inst_64460 = inst_64455;
var inst_64461 = inst_64456;
var inst_64462 = inst_64457;
var state_64484__$1 = (function (){var statearr_64545 = state_64484;
(statearr_64545[(7)] = inst_64460);

(statearr_64545[(8)] = inst_64461);

(statearr_64545[(9)] = inst_64459);

(statearr_64545[(10)] = inst_64462);

(statearr_64545[(11)] = inst_64458);

return statearr_64545;
})();
var statearr_64546_64593 = state_64484__$1;
(statearr_64546_64593[(2)] = null);

(statearr_64546_64593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (2))){
var inst_64459 = (state_64484[(9)]);
var inst_64464 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_64459);
var inst_64465 = cljs.core.merge.call(null,opts,inst_64464);
var inst_64466 = cljs.core.assoc.call(null,inst_64459,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64465);
var inst_64467 = fluree.db.api_js.query_async.call(null,db,inst_64466,db_fn);
var state_64484__$1 = state_64484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64484__$1,(4),inst_64467);
} else {
if((state_val_64485 === (3))){
var inst_64482 = (state_64484[(2)]);
var state_64484__$1 = state_64484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64484__$1,inst_64482);
} else {
if((state_val_64485 === (4))){
var inst_64460 = (state_64484[(7)]);
var inst_64462 = (state_64484[(10)]);
var inst_64458 = (state_64484[(11)]);
var inst_64469 = (state_64484[(2)]);
var inst_64470 = cljs.core.assoc.call(null,inst_64462,inst_64458,inst_64469);
var inst_64471 = cljs.core.first.call(null,inst_64460);
var state_64484__$1 = (function (){var statearr_64547 = state_64484;
(statearr_64547[(12)] = inst_64470);

return statearr_64547;
})();
if(cljs.core.truth_(inst_64471)){
var statearr_64548_64594 = state_64484__$1;
(statearr_64548_64594[(1)] = (5));

} else {
var statearr_64549_64595 = state_64484__$1;
(statearr_64549_64595[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (5))){
var inst_64470 = (state_64484[(12)]);
var inst_64460 = (state_64484[(7)]);
var inst_64461 = (state_64484[(8)]);
var inst_64473 = cljs.core.first.call(null,inst_64460);
var inst_64474 = cljs.core.first.call(null,inst_64461);
var inst_64475 = cljs.core.rest.call(null,inst_64460);
var inst_64476 = cljs.core.rest.call(null,inst_64461);
var inst_64458 = inst_64473;
var inst_64459 = inst_64474;
var inst_64460__$1 = inst_64475;
var inst_64461__$1 = inst_64476;
var inst_64462 = inst_64470;
var state_64484__$1 = (function (){var statearr_64550 = state_64484;
(statearr_64550[(7)] = inst_64460__$1);

(statearr_64550[(8)] = inst_64461__$1);

(statearr_64550[(9)] = inst_64459);

(statearr_64550[(10)] = inst_64462);

(statearr_64550[(11)] = inst_64458);

return statearr_64550;
})();
var statearr_64551_64596 = state_64484__$1;
(statearr_64551_64596[(2)] = null);

(statearr_64551_64596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (6))){
var inst_64470 = (state_64484[(12)]);
var state_64484__$1 = state_64484;
var statearr_64552_64597 = state_64484__$1;
(statearr_64552_64597[(2)] = inst_64470);

(statearr_64552_64597[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64485 === (7))){
var inst_64480 = (state_64484[(2)]);
var state_64484__$1 = state_64484;
var statearr_64553_64598 = state_64484__$1;
(statearr_64553_64598[(2)] = inst_64480);

(statearr_64553_64598[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64554 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64554[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64554[(1)] = (1));

return statearr_64554;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64484){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64555){var ex__2749__auto__ = e64555;
var statearr_64556_64599 = state_64484;
(statearr_64556_64599[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64484[(4)]))){
var statearr_64557_64600 = state_64484;
(statearr_64557_64600[(1)] = cljs.core.first.call(null,(state_64484[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64601 = state_64484;
state_64484 = G__64601;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64484){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64558 = f__2769__auto__.call(null);
(statearr_64558[(6)] = c__2768__auto____$1);

return statearr_64558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_64488 = cljs.core.async.impl.dispatch.run.call(null,inst_64487);
var state_64540__$1 = (function (){var statearr_64559 = state_64540;
(statearr_64559[(11)] = inst_64488);

return statearr_64559;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64540__$1,(2),inst_64486);
} else {
if((state_val_64541 === (4))){
var inst_64491 = (state_64540[(8)]);
var state_64540__$1 = state_64540;
var statearr_64560_64602 = state_64540__$1;
(statearr_64560_64602[(2)] = inst_64491);

(statearr_64560_64602[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (15))){
var state_64540__$1 = state_64540;
var statearr_64561_64603 = state_64540__$1;
(statearr_64561_64603[(2)] = (400));

(statearr_64561_64603[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (13))){
var state_64540__$1 = state_64540;
var statearr_64562_64604 = state_64540__$1;
(statearr_64562_64604[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (6))){
var inst_64497 = (state_64540[(9)]);
var inst_64505 = cljs.core.first.call(null,inst_64497);
var state_64540__$1 = state_64540;
var statearr_64564_64605 = state_64540__$1;
(statearr_64564_64605[(2)] = inst_64505);

(statearr_64564_64605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (17))){
var inst_64518 = (state_64540[(2)]);
var state_64540__$1 = state_64540;
var statearr_64565_64606 = state_64540__$1;
(statearr_64565_64606[(2)] = inst_64518);

(statearr_64565_64606[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (3))){
var inst_64494 = (state_64540[(7)]);
var inst_64491 = (state_64540[(8)]);
var inst_64497 = (state_64540[(9)]);
var inst_64501 = (state_64540[(10)]);
var inst_64496 = cljs.core.vals.call(null,inst_64491);
var inst_64497__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64496);
var inst_64498 = (function (){var responses = inst_64491;
var responses_STAR_ = inst_64494;
var statuses = inst_64497__$1;
return (function (p1__64445_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__64445_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_64499 = cljs.core.vals.call(null,inst_64491);
var inst_64500 = cljs.core.map.call(null,inst_64498,inst_64499);
var inst_64501__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_64500);
var inst_64502 = (function (){var responses = inst_64491;
var responses_STAR_ = inst_64494;
var statuses = inst_64497__$1;
var fuel = inst_64501__$1;
return (function (p1__64446_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__64446_SHARP_);
});
})();
var inst_64503 = cljs.core.every_QMARK_.call(null,inst_64502,inst_64497__$1);
var state_64540__$1 = (function (){var statearr_64566 = state_64540;
(statearr_64566[(9)] = inst_64497__$1);

(statearr_64566[(10)] = inst_64501__$1);

return statearr_64566;
})();
if(inst_64503){
var statearr_64567_64607 = state_64540__$1;
(statearr_64567_64607[(1)] = (6));

} else {
var statearr_64568_64608 = state_64540__$1;
(statearr_64568_64608[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (12))){
var state_64540__$1 = state_64540;
var statearr_64569_64609 = state_64540__$1;
(statearr_64569_64609[(2)] = (500));

(statearr_64569_64609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (2))){
var inst_64491 = (state_64540[(8)]);
var inst_64490 = (state_64540[(2)]);
var inst_64491__$1 = fluree.db.util.async.throw_err.call(null,inst_64490);
var inst_64492 = (function (){var responses = inst_64491__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_64493 = cljs.core.PersistentHashMap.EMPTY;
var inst_64494 = cljs.core.reduce_kv.call(null,inst_64492,inst_64493,inst_64491__$1);
var state_64540__$1 = (function (){var statearr_64570 = state_64540;
(statearr_64570[(7)] = inst_64494);

(statearr_64570[(8)] = inst_64491__$1);

return statearr_64570;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_64571_64610 = state_64540__$1;
(statearr_64571_64610[(1)] = (3));

} else {
var statearr_64572_64611 = state_64540__$1;
(statearr_64572_64611[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (19))){
var inst_64494 = (state_64540[(7)]);
var inst_64524 = (state_64540[(12)]);
var inst_64501 = (state_64540[(10)]);
var inst_64533 = cljs.core.assoc.call(null,inst_64494,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64524,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64501);
var state_64540__$1 = state_64540;
var statearr_64573_64612 = state_64540__$1;
(statearr_64573_64612[(2)] = inst_64533);

(statearr_64573_64612[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (11))){
var inst_64522 = (state_64540[(2)]);
var state_64540__$1 = state_64540;
var statearr_64574_64613 = state_64540__$1;
(statearr_64574_64613[(2)] = inst_64522);

(statearr_64574_64613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (9))){
var state_64540__$1 = state_64540;
var statearr_64575_64614 = state_64540__$1;
(statearr_64575_64614[(2)] = (207));

(statearr_64575_64614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (5))){
var inst_64538 = (state_64540[(2)]);
var state_64540__$1 = state_64540;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64540__$1,inst_64538);
} else {
if((state_val_64541 === (14))){
var inst_64520 = (state_64540[(2)]);
var state_64540__$1 = state_64540;
var statearr_64576_64615 = state_64540__$1;
(statearr_64576_64615[(2)] = inst_64520);

(statearr_64576_64615[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (16))){
var state_64540__$1 = state_64540;
var statearr_64577_64616 = state_64540__$1;
(statearr_64577_64616[(2)] = null);

(statearr_64577_64616[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (10))){
var inst_64494 = (state_64540[(7)]);
var inst_64491 = (state_64540[(8)]);
var inst_64497 = (state_64540[(9)]);
var inst_64501 = (state_64540[(10)]);
var inst_64511 = (function (){var responses = inst_64491;
var responses_STAR_ = inst_64494;
var statuses = inst_64497;
var fuel = inst_64501;
return (function (p1__64448_SHARP_){
return ((499) < p1__64448_SHARP_);
});
})();
var inst_64512 = cljs.core.some.call(null,inst_64511,inst_64497);
var state_64540__$1 = state_64540;
if(cljs.core.truth_(inst_64512)){
var statearr_64578_64617 = state_64540__$1;
(statearr_64578_64617[(1)] = (12));

} else {
var statearr_64579_64618 = state_64540__$1;
(statearr_64579_64618[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (18))){
var inst_64529 = (state_64540[(13)]);
var inst_64494 = (state_64540[(7)]);
var inst_64524 = (state_64540[(12)]);
var inst_64501 = (state_64540[(10)]);
var inst_64531 = cljs.core.assoc.call(null,inst_64494,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64524,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64501,new cljs.core.Keyword(null,"block","block",664686210),inst_64529);
var state_64540__$1 = state_64540;
var statearr_64580_64619 = state_64540__$1;
(statearr_64580_64619[(2)] = inst_64531);

(statearr_64580_64619[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64541 === (8))){
var inst_64529 = (state_64540[(13)]);
var inst_64494 = (state_64540[(7)]);
var inst_64491 = (state_64540[(8)]);
var inst_64524 = (state_64540[(12)]);
var inst_64497 = (state_64540[(9)]);
var inst_64501 = (state_64540[(10)]);
var inst_64524__$1 = (state_64540[(2)]);
var inst_64525 = (function (){var responses = inst_64491;
var responses_STAR_ = inst_64494;
var statuses = inst_64497;
var fuel = inst_64501;
var status = inst_64524__$1;
return (function (p1__64449_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__64449_SHARP_));
});
})();
var inst_64526 = cljs.core.vals.call(null,inst_64491);
var inst_64527 = cljs.core.filter.call(null,inst_64525,inst_64526);
var inst_64528 = cljs.core.first.call(null,inst_64527);
var inst_64529__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64528);
var state_64540__$1 = (function (){var statearr_64581 = state_64540;
(statearr_64581[(13)] = inst_64529__$1);

(statearr_64581[(12)] = inst_64524__$1);

return statearr_64581;
})();
if(cljs.core.truth_(inst_64529__$1)){
var statearr_64582_64620 = state_64540__$1;
(statearr_64582_64620[(1)] = (18));

} else {
var statearr_64583_64621 = state_64540__$1;
(statearr_64583_64621[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64584 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64584[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64584[(1)] = (1));

return statearr_64584;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64540){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64540);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64585){var ex__2749__auto__ = e64585;
var statearr_64586_64622 = state_64540;
(statearr_64586_64622[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64540[(4)]))){
var statearr_64587_64623 = state_64540;
(statearr_64587_64623[(1)] = cljs.core.first.call(null,(state_64540[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64624 = state_64540;
state_64540 = G__64624;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64540){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64540);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64588 = f__2769__auto__.call(null);
(statearr_64588[(6)] = c__2768__auto__);

return statearr_64588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__64626 = arguments.length;
switch (G__64626) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__64627 = opts;
var map__64627__$1 = cljs.core.__destructure_map.call(null,map__64627);
var auth = cljs.core.get.call(null,map__64627__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__64627__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__64627__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__64627__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__64628 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__64628,(0),null);
var authority = cljs.core.nth.call(null,vec__64628,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e64631){var e = e64631;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__64634 = arguments.length;
switch (G__64634) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_64665){
var state_val_64666 = (state_64665[(1)]);
if((state_val_64666 === (7))){
var state_64665__$1 = state_64665;
var statearr_64667_64688 = state_64665__$1;
(statearr_64667_64688[(2)] = opts);

(statearr_64667_64688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (1))){
var state_64665__$1 = state_64665;
var statearr_64668_64689 = state_64665__$1;
(statearr_64668_64689[(2)] = null);

(statearr_64668_64689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (4))){
var inst_64635 = (state_64665[(2)]);
var inst_64636 = fluree.db.util.log.error.call(null,inst_64635);
var inst_64637 = cljs.core.ex_data.call(null,inst_64635);
var inst_64638 = cljs.core.ex_message.call(null,inst_64635);
var inst_64639 = cljs.core.assoc.call(null,inst_64637,new cljs.core.Keyword(null,"message","message",-406056002),inst_64638);
var state_64665__$1 = (function (){var statearr_64669 = state_64665;
(statearr_64669[(7)] = inst_64636);

return statearr_64669;
})();
var statearr_64670_64690 = state_64665__$1;
(statearr_64670_64690[(2)] = inst_64639);

(statearr_64670_64690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (6))){
var inst_64649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64650 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_64651 = (new cljs.core.PersistentVector(null,1,(5),inst_64649,inst_64650,null));
var inst_64652 = cljs.core.assoc_in.call(null,opts,inst_64651,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64665__$1 = state_64665;
var statearr_64671_64691 = state_64665__$1;
(statearr_64671_64691[(2)] = inst_64652);

(statearr_64671_64691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (3))){
var inst_64663 = (state_64665[(2)]);
var state_64665__$1 = state_64665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64665__$1,inst_64663);
} else {
if((state_val_64666 === (2))){
var _ = (function (){var statearr_64673 = state_64665;
(statearr_64673[(4)] = cljs.core.cons.call(null,(5),(state_64665[(4)])));

return statearr_64673;
})();
var inst_64645 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64646 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_64647 = (inst_64646 == null);
var state_64665__$1 = (function (){var statearr_64674 = state_64665;
(statearr_64674[(8)] = inst_64645);

return statearr_64674;
})();
if(cljs.core.truth_(inst_64647)){
var statearr_64675_64692 = state_64665__$1;
(statearr_64675_64692[(1)] = (6));

} else {
var statearr_64676_64693 = state_64665__$1;
(statearr_64676_64693[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (9))){
var inst_64659 = (state_64665[(2)]);
var inst_64660 = fluree.db.util.async.throw_err.call(null,inst_64659);
var _ = (function (){var statearr_64677 = state_64665;
(statearr_64677[(4)] = cljs.core.rest.call(null,(state_64665[(4)])));

return statearr_64677;
})();
var state_64665__$1 = state_64665;
var statearr_64678_64694 = state_64665__$1;
(statearr_64678_64694[(2)] = inst_64660);

(statearr_64678_64694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (5))){
var _ = (function (){var statearr_64679 = state_64665;
(statearr_64679[(4)] = cljs.core.rest.call(null,(state_64665[(4)])));

return statearr_64679;
})();
var state_64665__$1 = state_64665;
var ex64672 = (state_64665__$1[(2)]);
var statearr_64680_64695 = state_64665__$1;
(statearr_64680_64695[(5)] = ex64672);


var statearr_64681_64696 = state_64665__$1;
(statearr_64681_64696[(1)] = (4));

(statearr_64681_64696[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64666 === (8))){
var inst_64645 = (state_64665[(8)]);
var inst_64655 = (state_64665[(2)]);
var inst_64656 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_64645,inst_64655);
var inst_64657 = fluree.db.operations.command_async.call(null,conn,inst_64656);
var state_64665__$1 = state_64665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_64665__$1,(9),inst_64657);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_64682 = [null,null,null,null,null,null,null,null,null];
(statearr_64682[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_64682[(1)] = (1));

return statearr_64682;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_64665){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_64665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e64683){var ex__2749__auto__ = e64683;
var statearr_64684_64697 = state_64665;
(statearr_64684_64697[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_64665[(4)]))){
var statearr_64685_64698 = state_64665;
(statearr_64685_64698[(1)] = cljs.core.first.call(null,(state_64665[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64699 = state_64665;
state_64665 = G__64699;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_64665){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_64665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_64686 = f__2769__auto__.call(null);
(statearr_64686[(6)] = c__2768__auto__);

return statearr_64686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

