// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18833 = arguments.length;
switch (G__18833) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18836 = arguments.length;
switch (G__18836) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18889 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18867){
var state_val_18868 = (state_18867[(1)]);
if((state_val_18868 === (1))){
var state_18867__$1 = state_18867;
var statearr_18869_18890 = state_18867__$1;
(statearr_18869_18890[(2)] = null);

(statearr_18869_18890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (2))){
var _ = (function (){var statearr_18870 = state_18867;
(statearr_18870[(4)] = cljs.core.cons((5),(state_18867[(4)])));

return statearr_18870;
})();
var inst_18844 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18867__$1 = state_18867;
if(cljs.core.truth_(inst_18844)){
var statearr_18871_18891 = state_18867__$1;
(statearr_18871_18891[(1)] = (6));

} else {
var statearr_18872_18892 = state_18867__$1;
(statearr_18872_18892[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (3))){
var inst_18865 = (state_18867[(2)]);
var state_18867__$1 = state_18867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18867__$1,inst_18865);
} else {
if((state_val_18868 === (4))){
var inst_18837 = (state_18867[(2)]);
var inst_18838 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18837);
var state_18867__$1 = state_18867;
var statearr_18874_18893 = state_18867__$1;
(statearr_18874_18893[(2)] = inst_18838);

(statearr_18874_18893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (5))){
var _ = (function (){var statearr_18875 = state_18867;
(statearr_18875[(4)] = cljs.core.rest((state_18867[(4)])));

return statearr_18875;
})();
var state_18867__$1 = state_18867;
var ex18873 = (state_18867__$1[(2)]);
var statearr_18876_18894 = state_18867__$1;
(statearr_18876_18894[(5)] = ex18873);


var statearr_18877_18895 = state_18867__$1;
(statearr_18877_18895[(1)] = (4));

(statearr_18877_18895[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (6))){
var inst_18846 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18847 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18848 = cljs.core.PersistentHashMap.fromArrays(inst_18846,inst_18847);
var inst_18849 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18848);
var inst_18850 = (function(){throw inst_18849})();
var state_18867__$1 = state_18867;
var statearr_18878_18896 = state_18867__$1;
(statearr_18878_18896[(2)] = inst_18850);

(statearr_18878_18896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (7))){
var inst_18852 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18854 = [operation,data,pc,opts];
var inst_18855 = (new cljs.core.PersistentVector(null,4,(5),inst_18853,inst_18854,null));
var inst_18856 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18852,inst_18855);
var inst_18857 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18858 = [operation,data,pc,opts];
var inst_18859 = (new cljs.core.PersistentVector(null,4,(5),inst_18857,inst_18858,null));
var inst_18860 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_18859], 0));
var state_18867__$1 = (function (){var statearr_18879 = state_18867;
(statearr_18879[(7)] = inst_18856);

return statearr_18879;
})();
var statearr_18880_18897 = state_18867__$1;
(statearr_18880_18897[(2)] = inst_18860);

(statearr_18880_18897[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18868 === (8))){
var inst_18862 = (state_18867[(2)]);
var _ = (function (){var statearr_18881 = state_18867;
(statearr_18881[(4)] = cljs.core.rest((state_18867[(4)])));

return statearr_18881;
})();
var state_18867__$1 = state_18867;
var statearr_18882_18898 = state_18867__$1;
(statearr_18882_18898[(2)] = inst_18862);

(statearr_18882_18898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_18883 = [null,null,null,null,null,null,null,null];
(statearr_18883[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_18883[(1)] = (1));

return statearr_18883;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_18867){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18867);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18884){var ex__2730__auto__ = e18884;
var statearr_18885_18899 = state_18867;
(statearr_18885_18899[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18867[(4)]))){
var statearr_18886_18900 = state_18867;
(statearr_18886_18900[(1)] = cljs.core.first((state_18867[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18901 = state_18867;
state_18867 = G__18901;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_18867){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_18867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18887 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18887[(6)] = c__2749__auto___18889);

return statearr_18887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18903 = arguments.length;
switch (G__18903) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18904){
var map__18905 = p__18904;
var map__18905__$1 = cljs.core.__destructure_map(map__18905);
var opts = map__18905__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18905__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18906 = session;
var map__18906__$1 = cljs.core.__destructure_map(map__18906);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18906__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18906__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18906__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___18933 = arguments.length;
var i__4865__auto___18934 = (0);
while(true){
if((i__4865__auto___18934 < len__4864__auto___18933)){
args__4870__auto__.push((arguments[i__4865__auto___18934]));

var G__18935 = (i__4865__auto___18934 + (1));
i__4865__auto___18934 = G__18935;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18910){
var vec__18911 = p__18910;
var map__18914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18911,(0),null);
var map__18914__$1 = cljs.core.__destructure_map(map__18914);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18914__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18911;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18926){
var state_val_18927 = (state_18926[(1)]);
if((state_val_18927 === (1))){
var inst_18916 = session;
var inst_18917 = cljs.core.__destructure_map(inst_18916);
var inst_18918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18917,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18917,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18917,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18921 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18922 = [inst_18918,inst_18919,toBlock,toTime];
var inst_18923 = cljs.core.PersistentHashMap.fromArrays(inst_18921,inst_18922);
var inst_18924 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18920,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18923);
var state_18926__$1 = state_18926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18926__$1,inst_18924);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_18928 = [null,null,null,null,null,null,null];
(statearr_18928[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_18928[(1)] = (1));

return statearr_18928;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_18926){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18926);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18929){var ex__2730__auto__ = e18929;
var statearr_18930_18936 = state_18926;
(statearr_18930_18936[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18926[(4)]))){
var statearr_18931_18937 = state_18926;
(statearr_18931_18937[(1)] = cljs.core.first((state_18926[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18938 = state_18926;
state_18926 = G__18938;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_18926){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_18926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18932 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18932[(6)] = c__2749__auto__);

return statearr_18932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18908){
var G__18909 = cljs.core.first(seq18908);
var seq18908__$1 = cljs.core.next(seq18908);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18909,seq18908__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18939 = session;
var map__18939__$1 = cljs.core.__destructure_map(map__18939);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18939__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18941 = arguments.length;
switch (G__18941) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18942 = opts;
var map__18942__$1 = cljs.core.__destructure_map(map__18942);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18942__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18942__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
