// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63184 = arguments.length;
var i__4865__auto___63185 = (0);
while(true){
if((i__4865__auto___63185 < len__4864__auto___63184)){
args__4870__auto__.push((arguments[i__4865__auto___63185]));

var G__63186 = (i__4865__auto___63185 + (1));
i__4865__auto___63185 = G__63186;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63116){
var vec__63117 = p__63116;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63117,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___63187 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63161){
var state_val_63162 = (state_63161[(1)]);
if((state_val_63162 === (7))){
var inst_63138 = (state_63161[(7)]);
var inst_63147 = (state_63161[(8)]);
var inst_63149 = fluree.db.time_travel.as_of_block(inst_63147,inst_63138);
var state_63161__$1 = state_63161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63161__$1,(10),inst_63149);
} else {
if((state_val_63162 === (1))){
var state_63161__$1 = state_63161;
var statearr_63163_63188 = state_63161__$1;
(statearr_63163_63188[(2)] = null);

(statearr_63163_63188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (4))){
var inst_63120 = (state_63161[(2)]);
var inst_63121 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63120], 0));
var inst_63122 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63120);
var inst_63123 = cljs.core.async.close_BANG_(pc);
var state_63161__$1 = (function (){var statearr_63164 = state_63161;
(statearr_63164[(9)] = inst_63122);

(statearr_63164[(10)] = inst_63121);

return statearr_63164;
})();
var statearr_63165_63189 = state_63161__$1;
(statearr_63165_63189[(2)] = inst_63123);

(statearr_63165_63189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (6))){
var inst_63138 = (state_63161[(7)]);
var inst_63142 = (state_63161[(11)]);
var inst_63141 = (state_63161[(12)]);
var inst_63145 = (state_63161[(2)]);
var inst_63146 = fluree.db.util.async.throw_err(inst_63145);
var inst_63147 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_63146,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_63141,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_63142], 0));
var state_63161__$1 = (function (){var statearr_63166 = state_63161;
(statearr_63166[(8)] = inst_63147);

return statearr_63166;
})();
if(cljs.core.truth_(inst_63138)){
var statearr_63167_63190 = state_63161__$1;
(statearr_63167_63190[(1)] = (7));

} else {
var statearr_63168_63191 = state_63161__$1;
(statearr_63168_63191[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (3))){
var inst_63159 = (state_63161[(2)]);
var state_63161__$1 = state_63161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63161__$1,inst_63159);
} else {
if((state_val_63162 === (2))){
var _ = (function (){var statearr_63170 = state_63161;
(statearr_63170[(4)] = cljs.core.cons((5),(state_63161[(4)])));

return statearr_63170;
})();
var inst_63133 = opts;
var inst_63134 = cljs.core.__destructure_map(inst_63133);
var inst_63135 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63134,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_63136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63134,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_63137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63134,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63134,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63139 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_63140 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_63141 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63140,(0),null);
var inst_63142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63140,(1),null);
var inst_63143 = fluree.db.session.db(conn,ledger,opts);
var state_63161__$1 = (function (){var statearr_63171 = state_63161;
(statearr_63171[(7)] = inst_63138);

(statearr_63171[(13)] = inst_63137);

(statearr_63171[(14)] = inst_63136);

(statearr_63171[(11)] = inst_63142);

(statearr_63171[(12)] = inst_63141);

(statearr_63171[(15)] = inst_63139);

(statearr_63171[(16)] = inst_63135);

return statearr_63171;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63161__$1,(6),inst_63143);
} else {
if((state_val_63162 === (9))){
var inst_63155 = (state_63161[(2)]);
var inst_63156 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63155);
var _ = (function (){var statearr_63172 = state_63161;
(statearr_63172[(4)] = cljs.core.rest((state_63161[(4)])));

return statearr_63172;
})();
var state_63161__$1 = state_63161;
var statearr_63173_63192 = state_63161__$1;
(statearr_63173_63192[(2)] = inst_63156);

(statearr_63173_63192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (5))){
var _ = (function (){var statearr_63174 = state_63161;
(statearr_63174[(4)] = cljs.core.rest((state_63161[(4)])));

return statearr_63174;
})();
var state_63161__$1 = state_63161;
var ex63169 = (state_63161__$1[(2)]);
var statearr_63175_63193 = state_63161__$1;
(statearr_63175_63193[(5)] = ex63169);


var statearr_63176_63194 = state_63161__$1;
(statearr_63176_63194[(1)] = (4));

(statearr_63176_63194[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (10))){
var inst_63151 = (state_63161[(2)]);
var inst_63152 = fluree.db.util.async.throw_err(inst_63151);
var state_63161__$1 = state_63161;
var statearr_63177_63195 = state_63161__$1;
(statearr_63177_63195[(2)] = inst_63152);

(statearr_63177_63195[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63162 === (8))){
var inst_63147 = (state_63161[(8)]);
var state_63161__$1 = state_63161;
var statearr_63178_63196 = state_63161__$1;
(statearr_63178_63196[(2)] = inst_63147);

(statearr_63178_63196[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_63179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63179[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_63179[(1)] = (1));

return statearr_63179;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_63161){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63161);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63180){var ex__2730__auto__ = e63180;
var statearr_63181_63197 = state_63161;
(statearr_63181_63197[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63161[(4)]))){
var statearr_63182_63198 = state_63161;
(statearr_63182_63198[(1)] = cljs.core.first((state_63161[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63199 = state_63161;
state_63161 = G__63199;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_63161){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_63161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63183 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63183[(6)] = c__2749__auto___63187);

return statearr_63183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63113){
var G__63114 = cljs.core.first(seq63113);
var seq63113__$1 = cljs.core.next(seq63113);
var G__63115 = cljs.core.first(seq63113__$1);
var seq63113__$2 = cljs.core.next(seq63113__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63114,G__63115,seq63113__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__63201 = arguments.length;
switch (G__63201) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63327){
var state_val_63328 = (state_63327[(1)]);
if((state_val_63328 === (7))){
var inst_63217 = (state_63327[(7)]);
var inst_63227 = (state_63327[(8)]);
var inst_63229 = fluree.db.time_travel.as_of_block(inst_63227,inst_63217);
var state_63327__$1 = state_63327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63327__$1,(10),inst_63229);
} else {
if((state_val_63328 === (20))){
var inst_63221 = (state_63327[(9)]);
var state_63327__$1 = state_63327;
var statearr_63329_63409 = state_63327__$1;
(statearr_63329_63409[(2)] = inst_63221);

(statearr_63329_63409[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (27))){
var inst_63215 = (state_63327[(10)]);
var state_63327__$1 = state_63327;
var statearr_63330_63410 = state_63327__$1;
(statearr_63330_63410[(2)] = inst_63215);

(statearr_63330_63410[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (1))){
var state_63327__$1 = state_63327;
var statearr_63331_63411 = state_63327__$1;
(statearr_63331_63411[(2)] = null);

(statearr_63331_63411[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (24))){
var inst_63224 = (state_63327[(11)]);
var state_63327__$1 = state_63327;
if(cljs.core.truth_(inst_63224)){
var statearr_63332_63412 = state_63327__$1;
(statearr_63332_63412[(1)] = (26));

} else {
var statearr_63333_63413 = state_63327__$1;
(statearr_63333_63413[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (39))){
var inst_63289 = (state_63327[(12)]);
var inst_63292 = cljs.core.ex_data(inst_63289);
var inst_63293 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63294 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63292);
var inst_63295 = cljs.core.ex_message(inst_63289);
var inst_63296 = [inst_63294,inst_63295,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63297 = cljs.core.PersistentHashMap.fromArrays(inst_63293,inst_63296);
var state_63327__$1 = state_63327;
var statearr_63334_63414 = state_63327__$1;
(statearr_63334_63414[(2)] = inst_63297);

(statearr_63334_63414[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (46))){
var inst_63289 = (state_63327[(12)]);
var state_63327__$1 = state_63327;
var statearr_63335_63415 = state_63327__$1;
(statearr_63335_63415[(2)] = inst_63289);

(statearr_63335_63415[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (4))){
var inst_63202 = (state_63327[(2)]);
var inst_63203 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63202], 0));
var inst_63204 = cljs.core.ex_data(inst_63202);
var inst_63205 = cljs.core.ex_message(inst_63202);
var inst_63206 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63204,new cljs.core.Keyword(null,"message","message",-406056002),inst_63205);
var state_63327__$1 = (function (){var statearr_63336 = state_63327;
(statearr_63336[(13)] = inst_63203);

return statearr_63336;
})();
var statearr_63337_63416 = state_63327__$1;
(statearr_63337_63416[(2)] = inst_63206);

(statearr_63337_63416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (15))){
var state_63327__$1 = state_63327;
var statearr_63338_63417 = state_63327__$1;
(statearr_63338_63417[(2)] = (1000000));

(statearr_63338_63417[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (48))){
var inst_63289 = (state_63327[(12)]);
var state_63327__$1 = state_63327;
var statearr_63339_63418 = state_63327__$1;
(statearr_63339_63418[(2)] = inst_63289);

(statearr_63339_63418[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (50))){
var inst_63316 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63340_63419 = state_63327__$1;
(statearr_63340_63419[(2)] = inst_63316);

(statearr_63340_63419[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (21))){
var inst_63220 = (state_63327[(14)]);
var state_63327__$1 = state_63327;
if(cljs.core.truth_(inst_63220)){
var statearr_63341_63420 = state_63327__$1;
(statearr_63341_63420[(1)] = (23));

} else {
var statearr_63342_63421 = state_63327__$1;
(statearr_63342_63421[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (31))){
var inst_63278 = (state_63327[(2)]);
var inst_63279 = cljs.core.not(inst_63278);
var state_63327__$1 = state_63327;
if(inst_63279){
var statearr_63343_63422 = state_63327__$1;
(statearr_63343_63422[(1)] = (35));

} else {
var statearr_63344_63423 = state_63327__$1;
(statearr_63344_63423[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (32))){
var inst_63222 = (state_63327[(15)]);
var state_63327__$1 = state_63327;
var statearr_63345_63424 = state_63327__$1;
(statearr_63345_63424[(2)] = inst_63222);

(statearr_63345_63424[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (40))){
var inst_63252 = (state_63327[(16)]);
var state_63327__$1 = state_63327;
if(cljs.core.truth_(inst_63252)){
var statearr_63346_63425 = state_63327__$1;
(statearr_63346_63425[(1)] = (42));

} else {
var statearr_63347_63426 = state_63327__$1;
(statearr_63347_63426[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (33))){
var inst_63218 = (state_63327[(17)]);
var state_63327__$1 = state_63327;
var statearr_63348_63427 = state_63327__$1;
(statearr_63348_63427[(2)] = inst_63218);

(statearr_63348_63427[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (13))){
var inst_63223 = (state_63327[(18)]);
var inst_63247 = (state_63327[(19)]);
var inst_63245 = (state_63327[(2)]);
var inst_63246 = cljs.core.volatile_BANG_((0));
var inst_63247__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_63223);
var state_63327__$1 = (function (){var statearr_63349 = state_63327;
(statearr_63349[(20)] = inst_63246);

(statearr_63349[(21)] = inst_63245);

(statearr_63349[(19)] = inst_63247__$1);

return statearr_63349;
})();
if(cljs.core.truth_(inst_63247__$1)){
var statearr_63350_63428 = state_63327__$1;
(statearr_63350_63428[(1)] = (14));

} else {
var statearr_63351_63429 = state_63327__$1;
(statearr_63351_63429[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (22))){
var inst_63268 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63352_63430 = state_63327__$1;
(statearr_63352_63430[(2)] = inst_63268);

(statearr_63352_63430[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (36))){
var inst_63254 = (state_63327[(22)]);
var inst_63235 = (state_63327[(23)]);
var inst_63285 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_63254);
var inst_63286 = fluree.db.query.fql.query(inst_63235,inst_63285);
var state_63327__$1 = state_63327;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63327__$1,(38),inst_63286);
} else {
if((state_val_63328 === (41))){
var inst_63320 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63353_63431 = state_63327__$1;
(statearr_63353_63431[(2)] = inst_63320);

(statearr_63353_63431[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (43))){
var state_63327__$1 = state_63327;
var statearr_63354_63432 = state_63327__$1;
(statearr_63354_63432[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (29))){
var inst_63222 = (state_63327[(15)]);
var state_63327__$1 = state_63327;
if(cljs.core.truth_(inst_63222)){
var statearr_63356_63433 = state_63327__$1;
(statearr_63356_63433[(1)] = (32));

} else {
var statearr_63357_63434 = state_63327__$1;
(statearr_63357_63434[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (44))){
var inst_63318 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63358_63435 = state_63327__$1;
(statearr_63358_63435[(2)] = inst_63318);

(statearr_63358_63435[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (6))){
var inst_63217 = (state_63327[(7)]);
var inst_63226 = (state_63327[(2)]);
var inst_63227 = fluree.db.util.async.throw_err(inst_63226);
var state_63327__$1 = (function (){var statearr_63359 = state_63327;
(statearr_63359[(8)] = inst_63227);

return statearr_63359;
})();
if(cljs.core.truth_(inst_63217)){
var statearr_63360_63436 = state_63327__$1;
(statearr_63360_63436[(1)] = (7));

} else {
var statearr_63361_63437 = state_63327__$1;
(statearr_63361_63437[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (28))){
var inst_63264 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63362_63438 = state_63327__$1;
(statearr_63362_63438[(2)] = inst_63264);

(statearr_63362_63438[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (25))){
var inst_63266 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63363_63439 = state_63327__$1;
(statearr_63363_63439[(2)] = inst_63266);

(statearr_63363_63439[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (34))){
var inst_63275 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
var statearr_63364_63440 = state_63327__$1;
(statearr_63364_63440[(2)] = inst_63275);

(statearr_63364_63440[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (17))){
var inst_63216 = (state_63327[(24)]);
var state_63327__$1 = state_63327;
var statearr_63365_63441 = state_63327__$1;
(statearr_63365_63441[(2)] = inst_63216);

(statearr_63365_63441[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (3))){
var inst_63325 = (state_63327[(2)]);
var state_63327__$1 = state_63327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63327__$1,inst_63325);
} else {
if((state_val_63328 === (12))){
var inst_63243 = cljs.core.PersistentHashMap.EMPTY;
var state_63327__$1 = state_63327;
var statearr_63366_63442 = state_63327__$1;
(statearr_63366_63442[(2)] = inst_63243);

(statearr_63366_63442[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (2))){
var _ = (function (){var statearr_63367 = state_63327;
(statearr_63367[(4)] = cljs.core.cons((5),(state_63327[(4)])));

return statearr_63367;
})();
var inst_63213 = query_map;
var inst_63214 = cljs.core.__destructure_map(inst_63213);
var inst_63215 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_63216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_63217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_63219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_63220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_63221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_63222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_63223 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_63224 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63214,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_63327__$1 = (function (){var statearr_63368 = state_63327;
(statearr_63368[(17)] = inst_63218);

(statearr_63368[(11)] = inst_63224);

(statearr_63368[(25)] = inst_63219);

(statearr_63368[(14)] = inst_63220);

(statearr_63368[(18)] = inst_63223);

(statearr_63368[(10)] = inst_63215);

(statearr_63368[(15)] = inst_63222);

(statearr_63368[(7)] = inst_63217);

(statearr_63368[(9)] = inst_63221);

(statearr_63368[(24)] = inst_63216);

return statearr_63368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63327__$1,(6),sources);
} else {
if((state_val_63328 === (23))){
var inst_63220 = (state_63327[(14)]);
var state_63327__$1 = state_63327;
var statearr_63369_63443 = state_63327__$1;
(statearr_63369_63443[(2)] = inst_63220);

(statearr_63369_63443[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (47))){
var inst_63246 = (state_63327[(20)]);
var inst_63253 = (state_63327[(26)]);
var inst_63300 = (state_63327[(27)]);
var inst_63235 = (state_63327[(23)]);
var inst_63306 = (state_63327[(2)]);
var inst_63307 = cljs.core.deref(inst_63246);
var inst_63308 = fluree.db.util.core.response_time_formatted(inst_63253);
var inst_63309 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63235);
var inst_63310 = [(200),inst_63306,inst_63307,inst_63308,inst_63309];
var inst_63311 = cljs.core.PersistentHashMap.fromArrays(inst_63300,inst_63310);
var state_63327__$1 = state_63327;
var statearr_63370_63444 = state_63327__$1;
(statearr_63370_63444[(2)] = inst_63311);

(statearr_63370_63444[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (35))){
var inst_63281 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63282 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63283 = cljs.core.PersistentHashMap.fromArrays(inst_63281,inst_63282);
var state_63327__$1 = state_63327;
var statearr_63371_63445 = state_63327__$1;
(statearr_63371_63445[(2)] = inst_63283);

(statearr_63371_63445[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (19))){
var inst_63270 = (state_63327[(28)]);
var inst_63270__$1 = (state_63327[(2)]);
var state_63327__$1 = (function (){var statearr_63372 = state_63327;
(statearr_63372[(28)] = inst_63270__$1);

return statearr_63372;
})();
if(cljs.core.truth_(inst_63270__$1)){
var statearr_63373_63446 = state_63327__$1;
(statearr_63373_63446[(1)] = (29));

} else {
var statearr_63374_63447 = state_63327__$1;
(statearr_63374_63447[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (11))){
var inst_63219 = (state_63327[(25)]);
var inst_63236 = (state_63327[(29)]);
var inst_63235 = (state_63327[(23)]);
var inst_63238 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_63235);
var inst_63239 = fluree.db.connection_js.open_api_QMARK_(inst_63236);
var inst_63240 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_63235);
var inst_63241 = fluree.db.api_js.get_sources(inst_63236,inst_63238,inst_63239,inst_63240,inst_63219,db_fn);
var state_63327__$1 = state_63327;
var statearr_63376_63448 = state_63327__$1;
(statearr_63376_63448[(2)] = inst_63241);

(statearr_63376_63448[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (9))){
var inst_63219 = (state_63327[(25)]);
var inst_63235 = (state_63327[(23)]);
var inst_63235__$1 = (state_63327[(2)]);
var inst_63236 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_63235__$1);
var state_63327__$1 = (function (){var statearr_63377 = state_63327;
(statearr_63377[(29)] = inst_63236);

(statearr_63377[(23)] = inst_63235__$1);

return statearr_63377;
})();
if(cljs.core.truth_(inst_63219)){
var statearr_63378_63449 = state_63327__$1;
(statearr_63378_63449[(1)] = (11));

} else {
var statearr_63379_63450 = state_63327__$1;
(statearr_63379_63450[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (5))){
var _ = (function (){var statearr_63380 = state_63327;
(statearr_63380[(4)] = cljs.core.rest((state_63327[(4)])));

return statearr_63380;
})();
var state_63327__$1 = state_63327;
var ex63375 = (state_63327__$1[(2)]);
var statearr_63381_63451 = state_63327__$1;
(statearr_63381_63451[(5)] = ex63375);


var statearr_63382_63452 = state_63327__$1;
(statearr_63382_63452[(1)] = (4));

(statearr_63382_63452[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (14))){
var inst_63247 = (state_63327[(19)]);
var state_63327__$1 = state_63327;
var statearr_63383_63453 = state_63327__$1;
(statearr_63383_63453[(2)] = inst_63247);

(statearr_63383_63453[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (45))){
var inst_63289 = (state_63327[(12)]);
var inst_63303 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_63289);
var state_63327__$1 = state_63327;
var statearr_63384_63454 = state_63327__$1;
(statearr_63384_63454[(2)] = inst_63303);

(statearr_63384_63454[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (26))){
var inst_63224 = (state_63327[(11)]);
var state_63327__$1 = state_63327;
var statearr_63385_63455 = state_63327__$1;
(statearr_63385_63455[(2)] = inst_63224);

(statearr_63385_63455[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (16))){
var inst_63246 = (state_63327[(20)]);
var inst_63245 = (state_63327[(21)]);
var inst_63223 = (state_63327[(18)]);
var inst_63216 = (state_63327[(24)]);
var inst_63251 = (state_63327[(2)]);
var inst_63252 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_63223);
var inst_63253 = fluree.db.util.core.current_time_millis();
var inst_63254 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_63223,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_63245,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_63251,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_63246], 0));
var state_63327__$1 = (function (){var statearr_63386 = state_63327;
(statearr_63386[(22)] = inst_63254);

(statearr_63386[(26)] = inst_63253);

(statearr_63386[(16)] = inst_63252);

return statearr_63386;
})();
if(cljs.core.truth_(inst_63216)){
var statearr_63387_63456 = state_63327__$1;
(statearr_63387_63456[(1)] = (17));

} else {
var statearr_63388_63457 = state_63327__$1;
(statearr_63388_63457[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (38))){
var inst_63289 = (state_63327[(12)]);
var inst_63288 = (state_63327[(2)]);
var inst_63289__$1 = fluree.db.util.async.throw_err(inst_63288);
var inst_63290 = (inst_63289__$1 instanceof cljs.core.ExceptionInfo);
var state_63327__$1 = (function (){var statearr_63389 = state_63327;
(statearr_63389[(12)] = inst_63289__$1);

return statearr_63389;
})();
if(cljs.core.truth_(inst_63290)){
var statearr_63390_63458 = state_63327__$1;
(statearr_63390_63458[(1)] = (39));

} else {
var statearr_63391_63459 = state_63327__$1;
(statearr_63391_63459[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (30))){
var inst_63270 = (state_63327[(28)]);
var state_63327__$1 = state_63327;
var statearr_63392_63460 = state_63327__$1;
(statearr_63392_63460[(2)] = inst_63270);

(statearr_63392_63460[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (10))){
var inst_63231 = (state_63327[(2)]);
var inst_63232 = fluree.db.util.async.throw_err(inst_63231);
var state_63327__$1 = state_63327;
var statearr_63393_63461 = state_63327__$1;
(statearr_63393_63461[(2)] = inst_63232);

(statearr_63393_63461[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (18))){
var inst_63221 = (state_63327[(9)]);
var state_63327__$1 = state_63327;
if(cljs.core.truth_(inst_63221)){
var statearr_63394_63462 = state_63327__$1;
(statearr_63394_63462[(1)] = (20));

} else {
var statearr_63395_63463 = state_63327__$1;
(statearr_63395_63463[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (42))){
var inst_63289 = (state_63327[(12)]);
var inst_63300 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63301 = cljs.core.sequential_QMARK_(inst_63289);
var state_63327__$1 = (function (){var statearr_63396 = state_63327;
(statearr_63396[(27)] = inst_63300);

return statearr_63396;
})();
if(inst_63301){
var statearr_63397_63464 = state_63327__$1;
(statearr_63397_63464[(1)] = (45));

} else {
var statearr_63398_63465 = state_63327__$1;
(statearr_63398_63465[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (37))){
var inst_63322 = (state_63327[(2)]);
var _ = (function (){var statearr_63399 = state_63327;
(statearr_63399[(4)] = cljs.core.rest((state_63327[(4)])));

return statearr_63399;
})();
var state_63327__$1 = state_63327;
var statearr_63400_63466 = state_63327__$1;
(statearr_63400_63466[(2)] = inst_63322);

(statearr_63400_63466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (8))){
var inst_63227 = (state_63327[(8)]);
var state_63327__$1 = state_63327;
var statearr_63401_63467 = state_63327__$1;
(statearr_63401_63467[(2)] = inst_63227);

(statearr_63401_63467[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63328 === (49))){
var state_63327__$1 = state_63327;
var statearr_63402_63468 = state_63327__$1;
(statearr_63402_63468[(2)] = null);

(statearr_63402_63468[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_63403 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63403[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_63403[(1)] = (1));

return statearr_63403;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_63327){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63327);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63404){var ex__2730__auto__ = e63404;
var statearr_63405_63469 = state_63327;
(statearr_63405_63469[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63327[(4)]))){
var statearr_63406_63470 = state_63327;
(statearr_63406_63470[(1)] = cljs.core.first((state_63327[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63471 = state_63327;
state_63327 = G__63471;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_63327){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_63327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63407 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63407[(6)] = c__2749__auto__);

return statearr_63407;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__63472_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__63472_SHARP_);
}));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63494){
var state_val_63495 = (state_63494[(1)]);
if((state_val_63495 === (1))){
var inst_63476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63477 = [resp_chan,timeout_chan];
var inst_63478 = (new cljs.core.PersistentVector(null,2,(5),inst_63476,inst_63477,null));
var state_63494__$1 = state_63494;
return cljs.core.async.ioc_alts_BANG_(state_63494__$1,(2),inst_63478);
} else {
if((state_val_63495 === (2))){
var inst_63480 = (state_63494[(2)]);
var inst_63481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63480,(0),null);
var inst_63482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63480,(1),null);
var inst_63483 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_63482);
var state_63494__$1 = (function (){var statearr_63496 = state_63494;
(statearr_63496[(7)] = inst_63481);

return statearr_63496;
})();
if(inst_63483){
var statearr_63497_63507 = state_63494__$1;
(statearr_63497_63507[(1)] = (3));

} else {
var statearr_63498_63508 = state_63494__$1;
(statearr_63498_63508[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63495 === (3))){
var inst_63485 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_63486 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63487 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_63488 = [tid,(408),inst_63487];
var inst_63489 = cljs.core.PersistentHashMap.fromArrays(inst_63486,inst_63488);
var state_63494__$1 = (function (){var statearr_63499 = state_63494;
(statearr_63499[(8)] = inst_63485);

return statearr_63499;
})();
var statearr_63500_63509 = state_63494__$1;
(statearr_63500_63509[(2)] = inst_63489);

(statearr_63500_63509[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63495 === (4))){
var inst_63481 = (state_63494[(7)]);
var state_63494__$1 = state_63494;
var statearr_63501_63510 = state_63494__$1;
(statearr_63501_63510[(2)] = inst_63481);

(statearr_63501_63510[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63495 === (5))){
var inst_63492 = (state_63494[(2)]);
var state_63494__$1 = state_63494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63494__$1,inst_63492);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0 = (function (){
var statearr_63502 = [null,null,null,null,null,null,null,null,null];
(statearr_63502[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__);

(statearr_63502[(1)] = (1));

return statearr_63502;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1 = (function (state_63494){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63494);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63503){var ex__2730__auto__ = e63503;
var statearr_63504_63511 = state_63494;
(statearr_63504_63511[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63494[(4)]))){
var statearr_63505_63512 = state_63494;
(statearr_63505_63512[(1)] = cljs.core.first((state_63494[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63513 = state_63494;
state_63494 = G__63513;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__ = function(state_63494){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1.call(this,state_63494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2727__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63506 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63506[(6)] = c__2749__auto__);

return statearr_63506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__63515 = arguments.length;
switch (G__63515) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__63516 = opts;
var map__63516__$1 = cljs.core.__destructure_map(map__63516);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63516__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63516__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63516__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63516__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__63517 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63517,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63517,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e63520){var e = e63520;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__63523 = arguments.length;
switch (G__63523) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63589){
var state_val_63590 = (state_63589[(1)]);
if((state_val_63590 === (7))){
var inst_63543 = (state_63589[(7)]);
var inst_63544 = (state_63589[(8)]);
var inst_63542 = (state_63589[(9)]);
var inst_63545 = (state_63589[(10)]);
var inst_63540 = (state_63589[(11)]);
var inst_63558 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63559 = [ledger,txn,inst_63540,inst_63542,inst_63543,inst_63544,inst_63545];
var inst_63560 = cljs.core.PersistentHashMap.fromArrays(inst_63558,inst_63559);
var inst_63561 = fluree.db.util.core.without_nils(inst_63560);
var inst_63562 = fluree.db.operations.transact_async(conn,inst_63561);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63589__$1,(13),inst_63562);
} else {
if((state_val_63590 === (20))){
var inst_63580 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
var statearr_63591_63627 = state_63589__$1;
(statearr_63591_63627[(2)] = inst_63580);

(statearr_63591_63627[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (1))){
var state_63589__$1 = state_63589;
var statearr_63592_63628 = state_63589__$1;
(statearr_63592_63628[(2)] = null);

(statearr_63592_63628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (4))){
var inst_63524 = (state_63589[(2)]);
var inst_63525 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63524], 0));
var inst_63526 = cljs.core.ex_data(inst_63524);
var inst_63527 = cljs.core.ex_message(inst_63524);
var inst_63528 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63526,new cljs.core.Keyword(null,"message","message",-406056002),inst_63527);
var state_63589__$1 = (function (){var statearr_63593 = state_63589;
(statearr_63593[(12)] = inst_63525);

return statearr_63593;
})();
var statearr_63594_63629 = state_63589__$1;
(statearr_63594_63629[(2)] = inst_63528);

(statearr_63594_63629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (15))){
var inst_63564 = (state_63589[(13)]);
var inst_63539 = (state_63589[(14)]);
var inst_63567 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63564,inst_63539);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63589__$1,(17),inst_63567);
} else {
if((state_val_63590 === (13))){
var inst_63538 = (state_63589[(15)]);
var inst_63564 = (state_63589[(2)]);
var state_63589__$1 = (function (){var statearr_63595 = state_63589;
(statearr_63595[(13)] = inst_63564);

return statearr_63595;
})();
if(cljs.core.truth_(inst_63538)){
var statearr_63596_63630 = state_63589__$1;
(statearr_63596_63630[(1)] = (14));

} else {
var statearr_63597_63631 = state_63589__$1;
(statearr_63597_63631[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (6))){
var inst_63537 = (state_63589[(16)]);
var inst_63538 = (state_63589[(15)]);
var inst_63547 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_63537,opts);
var inst_63548 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_63547);
var inst_63549 = fluree.db.operations.command_async(conn,inst_63547);
var state_63589__$1 = (function (){var statearr_63598 = state_63589;
(statearr_63598[(17)] = inst_63549);

(statearr_63598[(18)] = inst_63548);

return statearr_63598;
})();
if(cljs.core.truth_(inst_63538)){
var statearr_63599_63632 = state_63589__$1;
(statearr_63599_63632[(1)] = (9));

} else {
var statearr_63600_63633 = state_63589__$1;
(statearr_63600_63633[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (17))){
var inst_63569 = (state_63589[(19)]);
var inst_63569__$1 = (state_63589[(2)]);
var inst_63570 = (inst_63569__$1 instanceof cljs.core.ExceptionInfo);
var state_63589__$1 = (function (){var statearr_63601 = state_63589;
(statearr_63601[(19)] = inst_63569__$1);

return statearr_63601;
})();
if(cljs.core.truth_(inst_63570)){
var statearr_63602_63634 = state_63589__$1;
(statearr_63602_63634[(1)] = (18));

} else {
var statearr_63603_63635 = state_63589__$1;
(statearr_63603_63635[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (3))){
var inst_63587 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63589__$1,inst_63587);
} else {
if((state_val_63590 === (12))){
var inst_63554 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
var statearr_63604_63636 = state_63589__$1;
(statearr_63604_63636[(2)] = inst_63554);

(statearr_63604_63636[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (2))){
var inst_63537 = (state_63589[(16)]);
var _ = (function (){var statearr_63605 = state_63589;
(statearr_63605[(4)] = cljs.core.cons((5),(state_63589[(4)])));

return statearr_63605;
})();
var inst_63535 = opts;
var inst_63536 = cljs.core.__destructure_map(inst_63535);
var inst_63537__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_63538 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_63539 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63536,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_63540 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63541 = fluree.db.util.core.current_time_millis();
var inst_63542 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63536,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_63541);
var inst_63543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_63544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_63545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63536,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_63589__$1 = (function (){var statearr_63606 = state_63589;
(statearr_63606[(7)] = inst_63543);

(statearr_63606[(8)] = inst_63544);

(statearr_63606[(9)] = inst_63542);

(statearr_63606[(10)] = inst_63545);

(statearr_63606[(11)] = inst_63540);

(statearr_63606[(14)] = inst_63539);

(statearr_63606[(16)] = inst_63537__$1);

(statearr_63606[(15)] = inst_63538);

return statearr_63606;
})();
if(cljs.core.truth_(inst_63537__$1)){
var statearr_63607_63637 = state_63589__$1;
(statearr_63607_63637[(1)] = (6));

} else {
var statearr_63608_63638 = state_63589__$1;
(statearr_63608_63638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (19))){
var inst_63569 = (state_63589[(19)]);
var state_63589__$1 = state_63589;
var statearr_63609_63639 = state_63589__$1;
(statearr_63609_63639[(2)] = inst_63569);

(statearr_63609_63639[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (11))){
var inst_63556 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
var statearr_63611_63640 = state_63589__$1;
(statearr_63611_63640[(2)] = inst_63556);

(statearr_63611_63640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (9))){
var inst_63549 = (state_63589[(17)]);
var state_63589__$1 = state_63589;
var statearr_63612_63641 = state_63589__$1;
(statearr_63612_63641[(2)] = inst_63549);

(statearr_63612_63641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (5))){
var _ = (function (){var statearr_63613 = state_63589;
(statearr_63613[(4)] = cljs.core.rest((state_63589[(4)])));

return statearr_63613;
})();
var state_63589__$1 = state_63589;
var ex63610 = (state_63589__$1[(2)]);
var statearr_63614_63642 = state_63589__$1;
(statearr_63614_63642[(5)] = ex63610);


var statearr_63615_63643 = state_63589__$1;
(statearr_63615_63643[(1)] = (4));

(statearr_63615_63643[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (14))){
var inst_63564 = (state_63589[(13)]);
var state_63589__$1 = state_63589;
var statearr_63616_63644 = state_63589__$1;
(statearr_63616_63644[(2)] = inst_63564);

(statearr_63616_63644[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (16))){
var inst_63582 = (state_63589[(2)]);
var state_63589__$1 = state_63589;
var statearr_63617_63645 = state_63589__$1;
(statearr_63617_63645[(2)] = inst_63582);

(statearr_63617_63645[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (10))){
var inst_63548 = (state_63589[(18)]);
var inst_63539 = (state_63589[(14)]);
var inst_63552 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63548,inst_63539);
var state_63589__$1 = state_63589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63589__$1,(12),inst_63552);
} else {
if((state_val_63590 === (18))){
var inst_63569 = (state_63589[(19)]);
var inst_63572 = cljs.core.ex_data(inst_63569);
var inst_63573 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63574 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63572);
var inst_63575 = cljs.core.ex_message(inst_63569);
var inst_63576 = [inst_63574,inst_63575,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_63577 = cljs.core.PersistentHashMap.fromArrays(inst_63573,inst_63576);
var state_63589__$1 = state_63589;
var statearr_63618_63646 = state_63589__$1;
(statearr_63618_63646[(2)] = inst_63577);

(statearr_63618_63646[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63590 === (8))){
var inst_63584 = (state_63589[(2)]);
var _ = (function (){var statearr_63619 = state_63589;
(statearr_63619[(4)] = cljs.core.rest((state_63589[(4)])));

return statearr_63619;
})();
var state_63589__$1 = state_63589;
var statearr_63620_63647 = state_63589__$1;
(statearr_63620_63647[(2)] = inst_63584);

(statearr_63620_63647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_63621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63621[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_63621[(1)] = (1));

return statearr_63621;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_63589){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63589);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63622){var ex__2730__auto__ = e63622;
var statearr_63623_63648 = state_63589;
(statearr_63623_63648[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63589[(4)]))){
var statearr_63624_63649 = state_63589;
(statearr_63624_63649[(1)] = cljs.core.first((state_63589[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63650 = state_63589;
state_63589 = G__63650;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_63589){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_63589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63625 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63625[(6)] = c__2749__auto__);

return statearr_63625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63652 = arguments.length;
var i__4865__auto___63653 = (0);
while(true){
if((i__4865__auto___63653 < len__4864__auto___63652)){
args__4870__auto__.push((arguments[i__4865__auto___63653]));

var G__63654 = (i__4865__auto___63653 + (1));
i__4865__auto___63653 = G__63654;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq63651){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq63651));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63685){
var state_val_63686 = (state_63685[(1)]);
if((state_val_63686 === (1))){
var inst_63655 = cljs.core.first(flakes);
var inst_63656 = cljs.core.rest(flakes);
var inst_63657 = cljs.core.PersistentVector.EMPTY;
var inst_63658 = inst_63655;
var inst_63659 = inst_63656;
var inst_63660 = inst_63657;
var state_63685__$1 = (function (){var statearr_63687 = state_63685;
(statearr_63687[(7)] = inst_63659);

(statearr_63687[(8)] = inst_63660);

(statearr_63687[(9)] = inst_63658);

return statearr_63687;
})();
var statearr_63688_63701 = state_63685__$1;
(statearr_63688_63701[(2)] = null);

(statearr_63688_63701[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63686 === (2))){
var inst_63658 = (state_63685[(9)]);
var inst_63662 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_63663 = cljs.core.PersistentHashMap.EMPTY;
var inst_63664 = [true,inst_63663];
var inst_63665 = cljs.core.PersistentHashMap.fromArrays(inst_63662,inst_63664);
var inst_63666 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_63665,inst_63658);
var state_63685__$1 = state_63685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63685__$1,(4),inst_63666);
} else {
if((state_val_63686 === (3))){
var inst_63683 = (state_63685[(2)]);
var state_63685__$1 = state_63685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63685__$1,inst_63683);
} else {
if((state_val_63686 === (4))){
var inst_63659 = (state_63685[(7)]);
var inst_63660 = (state_63685[(8)]);
var inst_63668 = (state_63685[(2)]);
var inst_63669 = fluree.db.util.async.throw_err(inst_63668);
var inst_63670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63671 = [inst_63669];
var inst_63672 = (new cljs.core.PersistentVector(null,1,(5),inst_63670,inst_63671,null));
var inst_63673 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63660,inst_63672);
var inst_63674 = cljs.core.first(inst_63659);
var state_63685__$1 = (function (){var statearr_63689 = state_63685;
(statearr_63689[(10)] = inst_63673);

return statearr_63689;
})();
if(cljs.core.truth_(inst_63674)){
var statearr_63690_63702 = state_63685__$1;
(statearr_63690_63702[(1)] = (5));

} else {
var statearr_63691_63703 = state_63685__$1;
(statearr_63691_63703[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63686 === (5))){
var inst_63659 = (state_63685[(7)]);
var inst_63673 = (state_63685[(10)]);
var inst_63676 = cljs.core.first(inst_63659);
var inst_63677 = cljs.core.rest(inst_63659);
var inst_63658 = inst_63676;
var inst_63659__$1 = inst_63677;
var inst_63660 = inst_63673;
var state_63685__$1 = (function (){var statearr_63692 = state_63685;
(statearr_63692[(7)] = inst_63659__$1);

(statearr_63692[(8)] = inst_63660);

(statearr_63692[(9)] = inst_63658);

return statearr_63692;
})();
var statearr_63693_63704 = state_63685__$1;
(statearr_63693_63704[(2)] = null);

(statearr_63693_63704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63686 === (6))){
var inst_63673 = (state_63685[(10)]);
var state_63685__$1 = state_63685;
var statearr_63694_63705 = state_63685__$1;
(statearr_63694_63705[(2)] = inst_63673);

(statearr_63694_63705[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63686 === (7))){
var inst_63681 = (state_63685[(2)]);
var state_63685__$1 = state_63685;
var statearr_63695_63706 = state_63685__$1;
(statearr_63695_63706[(2)] = inst_63681);

(statearr_63695_63706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_63696 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63696[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__);

(statearr_63696[(1)] = (1));

return statearr_63696;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1 = (function (state_63685){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63685);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63697){var ex__2730__auto__ = e63697;
var statearr_63698_63707 = state_63685;
(statearr_63698_63707[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63685[(4)]))){
var statearr_63699_63708 = state_63685;
(statearr_63699_63708[(1)] = cljs.core.first((state_63685[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63709 = state_63685;
state_63685 = G__63709;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__ = function(state_63685){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1.call(this,state_63685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63700 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63700[(6)] = c__2749__auto__);

return statearr_63700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63777){
var state_val_63778 = (state_63777[(1)]);
if((state_val_63778 === (7))){
var inst_63737 = (state_63777[(2)]);
var inst_63738 = fluree.db.util.async.throw_err(inst_63737);
var state_63777__$1 = state_63777;
var statearr_63779_63805 = state_63777__$1;
(statearr_63779_63805[(2)] = inst_63738);

(statearr_63779_63805[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (1))){
var inst_63714 = cljs.core.volatile_BANG_((0));
var inst_63715 = cljs.core.PersistentHashMap.EMPTY;
var inst_63716 = cljs.core.volatile_BANG_(inst_63715);
var inst_63717 = cljs.core.first(resp);
var inst_63718 = cljs.core.rest(resp);
var inst_63719 = cljs.core.PersistentVector.EMPTY;
var inst_63720 = inst_63714;
var inst_63721 = inst_63716;
var inst_63722 = inst_63717;
var inst_63723 = inst_63718;
var inst_63724 = inst_63719;
var state_63777__$1 = (function (){var statearr_63780 = state_63777;
(statearr_63780[(7)] = inst_63724);

(statearr_63780[(8)] = inst_63722);

(statearr_63780[(9)] = inst_63720);

(statearr_63780[(10)] = inst_63721);

(statearr_63780[(11)] = inst_63723);

return statearr_63780;
})();
var statearr_63781_63806 = state_63777__$1;
(statearr_63781_63806[(2)] = null);

(statearr_63781_63806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (4))){
var inst_63724 = (state_63777[(7)]);
var inst_63722 = (state_63777[(8)]);
var inst_63720 = (state_63777[(9)]);
var inst_63721 = (state_63777[(10)]);
var inst_63726 = (state_63777[(12)]);
var inst_63728 = (state_63777[(13)]);
var inst_63723 = (state_63777[(11)]);
var inst_63732 = (function (){var fuel = inst_63720;
var cache = inst_63721;
var curr_block = inst_63722;
var rest_blocks = inst_63723;
var acc = inst_63724;
var flakes = inst_63726;
var asserted = inst_63728;
return (function (p1__63711_SHARP_){
return p1__63711_SHARP_.s;
});
})();
var inst_63733 = cljs.core.group_by(inst_63732,inst_63728);
var inst_63734 = cljs.core.vals(inst_63733);
var inst_63735 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63721,inst_63720,inst_63734);
var state_63777__$1 = state_63777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63777__$1,(7),inst_63735);
} else {
if((state_val_63778 === (13))){
var inst_63765 = (state_63777[(14)]);
var state_63777__$1 = state_63777;
var statearr_63782_63807 = state_63777__$1;
(statearr_63782_63807[(2)] = inst_63765);

(statearr_63782_63807[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (6))){
var inst_63724 = (state_63777[(7)]);
var inst_63743 = (state_63777[(15)]);
var inst_63722 = (state_63777[(8)]);
var inst_63720 = (state_63777[(9)]);
var inst_63721 = (state_63777[(10)]);
var inst_63726 = (state_63777[(12)]);
var inst_63728 = (state_63777[(13)]);
var inst_63723 = (state_63777[(11)]);
var inst_63741 = (state_63777[(16)]);
var inst_63741__$1 = (state_63777[(2)]);
var inst_63742 = (function (){var fuel = inst_63720;
var cache = inst_63721;
var curr_block = inst_63722;
var rest_blocks = inst_63723;
var acc = inst_63724;
var flakes = inst_63726;
var asserted = inst_63728;
var asserted_SINGLEQUOTE_ = inst_63741__$1;
return (function (p1__63712_SHARP_){
return p1__63712_SHARP_.op === false;
});
})();
var inst_63743__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63742,inst_63726);
var inst_63744 = cljs.core.empty_QMARK_(inst_63743__$1);
var inst_63745 = (!(inst_63744));
var state_63777__$1 = (function (){var statearr_63785 = state_63777;
(statearr_63785[(15)] = inst_63743__$1);

(statearr_63785[(16)] = inst_63741__$1);

return statearr_63785;
})();
if(inst_63745){
var statearr_63786_63808 = state_63777__$1;
(statearr_63786_63808[(1)] = (8));

} else {
var statearr_63787_63809 = state_63777__$1;
(statearr_63787_63809[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (3))){
var inst_63775 = (state_63777[(2)]);
var state_63777__$1 = state_63777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63777__$1,inst_63775);
} else {
if((state_val_63778 === (12))){
var inst_63720 = (state_63777[(9)]);
var inst_63721 = (state_63777[(10)]);
var inst_63765 = (state_63777[(14)]);
var inst_63723 = (state_63777[(11)]);
var inst_63768 = cljs.core.first(inst_63723);
var inst_63769 = cljs.core.rest(inst_63723);
var tmp63783 = inst_63720;
var tmp63784 = inst_63721;
var inst_63720__$1 = tmp63783;
var inst_63721__$1 = tmp63784;
var inst_63722 = inst_63768;
var inst_63723__$1 = inst_63769;
var inst_63724 = inst_63765;
var state_63777__$1 = (function (){var statearr_63788 = state_63777;
(statearr_63788[(7)] = inst_63724);

(statearr_63788[(8)] = inst_63722);

(statearr_63788[(9)] = inst_63720__$1);

(statearr_63788[(10)] = inst_63721__$1);

(statearr_63788[(11)] = inst_63723__$1);

return statearr_63788;
})();
var statearr_63789_63810 = state_63777__$1;
(statearr_63789_63810[(2)] = null);

(statearr_63789_63810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (2))){
var inst_63724 = (state_63777[(7)]);
var inst_63722 = (state_63777[(8)]);
var inst_63720 = (state_63777[(9)]);
var inst_63721 = (state_63777[(10)]);
var inst_63726 = (state_63777[(12)]);
var inst_63728 = (state_63777[(13)]);
var inst_63723 = (state_63777[(11)]);
var inst_63726__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_63722);
var inst_63727 = (function (){var fuel = inst_63720;
var cache = inst_63721;
var curr_block = inst_63722;
var rest_blocks = inst_63723;
var acc = inst_63724;
var flakes = inst_63726__$1;
return (function (p1__63710_SHARP_){
return p1__63710_SHARP_.op;
});
})();
var inst_63728__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63727,inst_63726__$1);
var inst_63729 = cljs.core.empty_QMARK_(inst_63728__$1);
var inst_63730 = (!(inst_63729));
var state_63777__$1 = (function (){var statearr_63790 = state_63777;
(statearr_63790[(12)] = inst_63726__$1);

(statearr_63790[(13)] = inst_63728__$1);

return statearr_63790;
})();
if(inst_63730){
var statearr_63791_63811 = state_63777__$1;
(statearr_63791_63811[(1)] = (4));

} else {
var statearr_63792_63812 = state_63777__$1;
(statearr_63792_63812[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (11))){
var inst_63753 = (state_63777[(2)]);
var inst_63754 = fluree.db.util.async.throw_err(inst_63753);
var state_63777__$1 = state_63777;
var statearr_63793_63813 = state_63777__$1;
(statearr_63793_63813[(2)] = inst_63754);

(statearr_63793_63813[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (9))){
var state_63777__$1 = state_63777;
var statearr_63794_63814 = state_63777__$1;
(statearr_63794_63814[(2)] = null);

(statearr_63794_63814[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (5))){
var state_63777__$1 = state_63777;
var statearr_63795_63815 = state_63777__$1;
(statearr_63795_63815[(2)] = null);

(statearr_63795_63815[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (14))){
var inst_63773 = (state_63777[(2)]);
var state_63777__$1 = state_63777;
var statearr_63796_63816 = state_63777__$1;
(statearr_63796_63816[(2)] = inst_63773);

(statearr_63796_63816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (10))){
var inst_63724 = (state_63777[(7)]);
var inst_63722 = (state_63777[(8)]);
var inst_63723 = (state_63777[(11)]);
var inst_63741 = (state_63777[(16)]);
var inst_63757 = (state_63777[(2)]);
var inst_63758 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_63759 = [inst_63741,inst_63757];
var inst_63760 = cljs.core.PersistentHashMap.fromArrays(inst_63758,inst_63759);
var inst_63761 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63722,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_63760);
var inst_63762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63763 = [inst_63761];
var inst_63764 = (new cljs.core.PersistentVector(null,1,(5),inst_63762,inst_63763,null));
var inst_63765 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63724,inst_63764);
var inst_63766 = cljs.core.first(inst_63723);
var state_63777__$1 = (function (){var statearr_63797 = state_63777;
(statearr_63797[(14)] = inst_63765);

return statearr_63797;
})();
if(cljs.core.truth_(inst_63766)){
var statearr_63798_63817 = state_63777__$1;
(statearr_63798_63817[(1)] = (12));

} else {
var statearr_63799_63818 = state_63777__$1;
(statearr_63799_63818[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63778 === (8))){
var inst_63724 = (state_63777[(7)]);
var inst_63743 = (state_63777[(15)]);
var inst_63722 = (state_63777[(8)]);
var inst_63720 = (state_63777[(9)]);
var inst_63721 = (state_63777[(10)]);
var inst_63726 = (state_63777[(12)]);
var inst_63728 = (state_63777[(13)]);
var inst_63723 = (state_63777[(11)]);
var inst_63741 = (state_63777[(16)]);
var inst_63747 = (function (){var flakes = inst_63726;
var rest_blocks = inst_63723;
var curr_block = inst_63722;
var asserted_SINGLEQUOTE_ = inst_63741;
var acc = inst_63724;
var fuel = inst_63720;
var cache = inst_63721;
var retracted = inst_63743;
var asserted = inst_63728;
return (function (p1__63713_SHARP_){
return p1__63713_SHARP_.s;
});
})();
var inst_63748 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_63743);
var inst_63749 = cljs.core.group_by(inst_63747,inst_63748);
var inst_63750 = cljs.core.vals(inst_63749);
var inst_63751 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63721,inst_63720,inst_63750);
var state_63777__$1 = state_63777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63777__$1,(11),inst_63751);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_63800 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63800[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_63800[(1)] = (1));

return statearr_63800;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_63777){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63777);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63801){var ex__2730__auto__ = e63801;
var statearr_63802_63819 = state_63777;
(statearr_63802_63819[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63777[(4)]))){
var statearr_63803_63820 = state_63777;
(statearr_63803_63820[(1)] = cljs.core.first((state_63777[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63821 = state_63777;
state_63777 = G__63821;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_63777){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_63777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63804 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63804[(6)] = c__2749__auto__);

return statearr_63804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63921){
var state_val_63922 = (state_63921[(1)]);
if((state_val_63922 === (7))){
var inst_63893 = (state_63921[(7)]);
var inst_63886 = (state_63921[(8)]);
var inst_63892 = cljs.core.seq(inst_63886);
var inst_63893__$1 = cljs.core.first(inst_63892);
var inst_63894 = cljs.core.next(inst_63892);
var state_63921__$1 = (function (){var statearr_63923 = state_63921;
(statearr_63923[(9)] = inst_63894);

(statearr_63923[(7)] = inst_63893__$1);

return statearr_63923;
})();
if(cljs.core.truth_(inst_63893__$1)){
var statearr_63924_63961 = state_63921__$1;
(statearr_63924_63961[(1)] = (9));

} else {
var statearr_63925_63962 = state_63921__$1;
(statearr_63925_63962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (1))){
var state_63921__$1 = state_63921;
var statearr_63926_63963 = state_63921__$1;
(statearr_63926_63963[(2)] = null);

(statearr_63926_63963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (4))){
var inst_63823 = (state_63921[(2)]);
var state_63921__$1 = state_63921;
var statearr_63927_63964 = state_63921__$1;
(statearr_63927_63964[(2)] = inst_63823);

(statearr_63927_63964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (6))){
var inst_63872 = (state_63921[(2)]);
var inst_63873 = fluree.db.util.async.throw_err(inst_63872);
var inst_63881 = resp;
var inst_63882 = cljs.core.seq(inst_63881);
var inst_63883 = cljs.core.first(inst_63882);
var inst_63884 = cljs.core.next(inst_63882);
var inst_63885 = cljs.core.PersistentHashMap.EMPTY;
var inst_63886 = inst_63881;
var inst_63887 = inst_63885;
var state_63921__$1 = (function (){var statearr_63928 = state_63921;
(statearr_63928[(10)] = inst_63884);

(statearr_63928[(11)] = inst_63883);

(statearr_63928[(12)] = inst_63873);

(statearr_63928[(8)] = inst_63886);

(statearr_63928[(13)] = inst_63887);

return statearr_63928;
})();
var statearr_63929_63965 = state_63921__$1;
(statearr_63929_63965[(2)] = null);

(statearr_63929_63965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (3))){
var inst_63919 = (state_63921[(2)]);
var state_63921__$1 = state_63921;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63921__$1,inst_63919);
} else {
if((state_val_63922 === (2))){
var _ = (function (){var statearr_63930 = state_63921;
(statearr_63930[(4)] = cljs.core.cons((5),(state_63921[(4)])));

return statearr_63930;
})();
var inst_63829 = (function (){return (function (p1__63822_SHARP_){
return p1__63822_SHARP_.t;
});
})();
var inst_63830 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_63829,resp);
var inst_63831 = cljs.core.set(inst_63830);
var inst_63868 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_63869 = (function (){var ts = inst_63831;
var c__2749__auto____$1 = inst_63868;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_63866){
var state_val_63867 = (state_63866[(1)]);
if((state_val_63867 === (1))){
var inst_63839 = ts;
var inst_63840 = cljs.core.seq(inst_63839);
var inst_63841 = cljs.core.first(inst_63840);
var inst_63842 = cljs.core.next(inst_63840);
var inst_63843 = cljs.core.PersistentHashMap.EMPTY;
var inst_63844 = inst_63839;
var inst_63845 = inst_63843;
var state_63866__$1 = (function (){var statearr_63931 = state_63866;
(statearr_63931[(7)] = inst_63841);

(statearr_63931[(8)] = inst_63845);

(statearr_63931[(9)] = inst_63844);

(statearr_63931[(10)] = inst_63842);

return statearr_63931;
})();
var statearr_63932_63966 = state_63866__$1;
(statearr_63932_63966[(2)] = null);

(statearr_63932_63966[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (2))){
var inst_63851 = (state_63866[(11)]);
var inst_63844 = (state_63866[(9)]);
var inst_63850 = cljs.core.seq(inst_63844);
var inst_63851__$1 = cljs.core.first(inst_63850);
var inst_63852 = cljs.core.next(inst_63850);
var state_63866__$1 = (function (){var statearr_63933 = state_63866;
(statearr_63933[(11)] = inst_63851__$1);

(statearr_63933[(12)] = inst_63852);

return statearr_63933;
})();
if(cljs.core.truth_(inst_63851__$1)){
var statearr_63934_63967 = state_63866__$1;
(statearr_63934_63967[(1)] = (4));

} else {
var statearr_63935_63968 = state_63866__$1;
(statearr_63935_63968[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (3))){
var inst_63864 = (state_63866[(2)]);
var state_63866__$1 = state_63866;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63866__$1,inst_63864);
} else {
if((state_val_63867 === (4))){
var inst_63851 = (state_63866[(11)]);
var inst_63854 = fluree.db.time_travel.non_border_t_to_block(db,inst_63851);
var state_63866__$1 = state_63866;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63866__$1,(7),inst_63854);
} else {
if((state_val_63867 === (5))){
var inst_63845 = (state_63866[(8)]);
var state_63866__$1 = state_63866;
var statearr_63936_63969 = state_63866__$1;
(statearr_63936_63969[(2)] = inst_63845);

(statearr_63936_63969[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (6))){
var inst_63862 = (state_63866[(2)]);
var state_63866__$1 = state_63866;
var statearr_63937_63970 = state_63866__$1;
(statearr_63937_63970[(2)] = inst_63862);

(statearr_63937_63970[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63867 === (7))){
var inst_63851 = (state_63866[(11)]);
var inst_63852 = (state_63866[(12)]);
var inst_63845 = (state_63866[(8)]);
var inst_63856 = (state_63866[(2)]);
var inst_63857 = fluree.db.util.async.throw_err(inst_63856);
var inst_63858 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63845,inst_63851,inst_63857);
var inst_63844 = inst_63852;
var inst_63845__$1 = inst_63858;
var state_63866__$1 = (function (){var statearr_63938 = state_63866;
(statearr_63938[(8)] = inst_63845__$1);

(statearr_63938[(9)] = inst_63844);

return statearr_63938;
})();
var statearr_63939_63971 = state_63866__$1;
(statearr_63939_63971[(2)] = null);

(statearr_63939_63971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_63940 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63940[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_63940[(1)] = (1));

return statearr_63940;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_63866){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63866);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63941){var ex__2730__auto__ = e63941;
var statearr_63942_63972 = state_63866;
(statearr_63942_63972[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63866[(4)]))){
var statearr_63943_63973 = state_63866;
(statearr_63943_63973[(1)] = cljs.core.first((state_63866[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63974 = state_63866;
state_63866 = G__63974;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_63866){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_63866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63944 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63944[(6)] = c__2749__auto____$1);

return statearr_63944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_63870 = cljs.core.async.impl.dispatch.run(inst_63869);
var state_63921__$1 = (function (){var statearr_63945 = state_63921;
(statearr_63945[(14)] = inst_63870);

return statearr_63945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63921__$1,(6),inst_63868);
} else {
if((state_val_63922 === (11))){
var inst_63913 = (state_63921[(2)]);
var state_63921__$1 = state_63921;
var statearr_63947_63975 = state_63921__$1;
(statearr_63947_63975[(2)] = inst_63913);

(statearr_63947_63975[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (9))){
var inst_63894 = (state_63921[(9)]);
var inst_63893 = (state_63921[(7)]);
var inst_63873 = (state_63921[(12)]);
var inst_63887 = (state_63921[(13)]);
var inst_63896 = inst_63893.t;
var inst_63897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63873,inst_63896);
var inst_63898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63899 = [inst_63897,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63900 = (new cljs.core.PersistentVector(null,2,(5),inst_63898,inst_63899,null));
var inst_63901 = cljs.core.assoc_in(inst_63887,inst_63900,inst_63897);
var inst_63902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63903 = [inst_63897,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_63904 = (new cljs.core.PersistentVector(null,2,(5),inst_63902,inst_63903,null));
var inst_63905 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_63901,inst_63904,cljs.core.conj,inst_63893);
var inst_63906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63907 = [inst_63897,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_63908 = (new cljs.core.PersistentVector(null,2,(5),inst_63906,inst_63907,null));
var inst_63909 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_63905,inst_63908,fluree.db.api_js.min_safe,inst_63896);
var inst_63886 = inst_63894;
var inst_63887__$1 = inst_63909;
var state_63921__$1 = (function (){var statearr_63948 = state_63921;
(statearr_63948[(8)] = inst_63886);

(statearr_63948[(13)] = inst_63887__$1);

return statearr_63948;
})();
var statearr_63949_63976 = state_63921__$1;
(statearr_63949_63976[(2)] = null);

(statearr_63949_63976[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (5))){
var _ = (function (){var statearr_63950 = state_63921;
(statearr_63950[(4)] = cljs.core.rest((state_63921[(4)])));

return statearr_63950;
})();
var state_63921__$1 = state_63921;
var ex63946 = (state_63921__$1[(2)]);
var statearr_63951_63977 = state_63921__$1;
(statearr_63951_63977[(5)] = ex63946);


if((ex63946 instanceof Error)){
var statearr_63952_63978 = state_63921__$1;
(statearr_63952_63978[(1)] = (4));

(statearr_63952_63978[(5)] = null);

} else {
throw ex63946;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (10))){
var inst_63887 = (state_63921[(13)]);
var state_63921__$1 = state_63921;
var statearr_63953_63979 = state_63921__$1;
(statearr_63953_63979[(2)] = inst_63887);

(statearr_63953_63979[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63922 === (8))){
var inst_63915 = (state_63921[(2)]);
var inst_63916 = cljs.core.vals(inst_63915);
var _ = (function (){var statearr_63954 = state_63921;
(statearr_63954[(4)] = cljs.core.rest((state_63921[(4)])));

return statearr_63954;
})();
var state_63921__$1 = state_63921;
var statearr_63955_63980 = state_63921__$1;
(statearr_63955_63980[(2)] = inst_63916);

(statearr_63955_63980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_63956 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63956[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__);

(statearr_63956[(1)] = (1));

return statearr_63956;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1 = (function (state_63921){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_63921);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e63957){var ex__2730__auto__ = e63957;
var statearr_63958_63981 = state_63921;
(statearr_63958_63981[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_63921[(4)]))){
var statearr_63959_63982 = state_63921;
(statearr_63959_63982[(1)] = cljs.core.first((state_63921[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63983 = state_63921;
state_63921 = G__63983;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__ = function(state_63921){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1.call(this,state_63921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_63960 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_63960[(6)] = c__2749__auto__);

return statearr_63960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64128){
var state_val_64129 = (state_64128[(1)]);
if((state_val_64129 === (7))){
var inst_64008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64009 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64010 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64011 = [inst_64009,inst_64010];
var inst_64012 = (new cljs.core.PersistentVector(null,2,(5),inst_64008,inst_64011,null));
var state_64128__$1 = state_64128;
var statearr_64130_64201 = state_64128__$1;
(statearr_64130_64201[(2)] = inst_64012);

(statearr_64130_64201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (20))){
var inst_64038 = (state_64128[(7)]);
var state_64128__$1 = state_64128;
var statearr_64131_64202 = state_64128__$1;
(statearr_64131_64202[(2)] = inst_64038);

(statearr_64131_64202[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (27))){
var state_64128__$1 = state_64128;
var statearr_64132_64203 = state_64128__$1;
(statearr_64132_64203[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (1))){
var state_64128__$1 = state_64128;
var statearr_64134_64204 = state_64128__$1;
(statearr_64134_64204[(2)] = null);

(statearr_64134_64204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (24))){
var inst_64037 = (state_64128[(8)]);
var state_64128__$1 = state_64128;
if(cljs.core.truth_(inst_64037)){
var statearr_64135_64205 = state_64128__$1;
(statearr_64135_64205[(1)] = (26));

} else {
var statearr_64136_64206 = state_64128__$1;
(statearr_64136_64206[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (39))){
var inst_64084 = (state_64128[(9)]);
var inst_64083 = (state_64128[(10)]);
var inst_64109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64110 = [inst_64083,inst_64084];
var inst_64111 = (new cljs.core.PersistentVector(null,2,(5),inst_64109,inst_64110,null));
var state_64128__$1 = state_64128;
var statearr_64137_64207 = state_64128__$1;
(statearr_64137_64207[(2)] = inst_64111);

(statearr_64137_64207[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (4))){
var inst_63984 = (state_64128[(2)]);
var inst_63985 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63984], 0));
var inst_63986 = cljs.core.ex_data(inst_63984);
var inst_63987 = cljs.core.ex_message(inst_63984);
var inst_63988 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63986,new cljs.core.Keyword(null,"message","message",-406056002),inst_63987);
var state_64128__$1 = (function (){var statearr_64138 = state_64128;
(statearr_64138[(11)] = inst_63985);

return statearr_64138;
})();
var statearr_64139_64208 = state_64128__$1;
(statearr_64139_64208[(2)] = inst_63988);

(statearr_64139_64208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (15))){
var inst_64017 = (state_64128[(12)]);
var inst_64022 = (state_64128[(13)]);
var inst_64031 = (state_64128[(2)]);
var inst_64032 = [inst_64022,inst_64031];
var inst_64033 = (new cljs.core.PersistentVector(null,2,(5),inst_64017,inst_64032,null));
var state_64128__$1 = state_64128;
var statearr_64140_64209 = state_64128__$1;
(statearr_64140_64209[(2)] = inst_64033);

(statearr_64140_64209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (21))){
var inst_64037 = (state_64128[(8)]);
var state_64128__$1 = state_64128;
var statearr_64141_64210 = state_64128__$1;
(statearr_64141_64210[(2)] = inst_64037);

(statearr_64141_64210[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (31))){
var inst_64078 = (state_64128[(2)]);
var state_64128__$1 = state_64128;
var statearr_64142_64211 = state_64128__$1;
(statearr_64142_64211[(2)] = inst_64078);

(statearr_64142_64211[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (32))){
var inst_64084 = (state_64128[(9)]);
var inst_64087 = cljs.core.pos_int_QMARK_(inst_64084);
var state_64128__$1 = state_64128;
var statearr_64143_64212 = state_64128__$1;
(statearr_64143_64212[(2)] = inst_64087);

(statearr_64143_64212[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (40))){
var inst_64115 = (state_64128[(14)]);
var inst_64039 = (state_64128[(15)]);
var inst_64113 = (state_64128[(2)]);
var inst_64114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64113,(0),null);
var inst_64115__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64113,(1),null);
var inst_64116 = (inst_64115__$1 > inst_64039);
var state_64128__$1 = (function (){var statearr_64144 = state_64128;
(statearr_64144[(16)] = inst_64114);

(statearr_64144[(14)] = inst_64115__$1);

return statearr_64144;
})();
if(cljs.core.truth_(inst_64116)){
var statearr_64145_64213 = state_64128__$1;
(statearr_64145_64213[(1)] = (41));

} else {
var statearr_64146_64214 = state_64128__$1;
(statearr_64146_64214[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (33))){
var inst_64085 = (state_64128[(17)]);
var state_64128__$1 = state_64128;
var statearr_64147_64215 = state_64128__$1;
(statearr_64147_64215[(2)] = inst_64085);

(statearr_64147_64215[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (13))){
var inst_64023 = (state_64128[(18)]);
var inst_64025 = fluree.db.time_travel.block_to_int_format(db,inst_64023);
var state_64128__$1 = state_64128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64128__$1,(16),inst_64025);
} else {
if((state_val_64129 === (22))){
var inst_64056 = (state_64128[(2)]);
var state_64128__$1 = state_64128;
if(cljs.core.truth_(inst_64056)){
var statearr_64148_64216 = state_64128__$1;
(statearr_64148_64216[(1)] = (23));

} else {
var statearr_64149_64217 = state_64128__$1;
(statearr_64149_64217[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (36))){
var state_64128__$1 = state_64128;
var statearr_64150_64218 = state_64128__$1;
(statearr_64150_64218[(2)] = null);

(statearr_64150_64218[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (41))){
var inst_64039 = (state_64128[(15)]);
var state_64128__$1 = state_64128;
var statearr_64151_64219 = state_64128__$1;
(statearr_64151_64219[(2)] = inst_64039);

(statearr_64151_64219[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (43))){
var inst_64114 = (state_64128[(16)]);
var inst_64120 = (state_64128[(2)]);
var inst_64121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64122 = [inst_64114,inst_64120];
var inst_64123 = (new cljs.core.PersistentVector(null,2,(5),inst_64121,inst_64122,null));
var _ = (function (){var statearr_64152 = state_64128;
(statearr_64152[(4)] = cljs.core.rest((state_64128[(4)])));

return statearr_64152;
})();
var state_64128__$1 = state_64128;
var statearr_64153_64220 = state_64128__$1;
(statearr_64153_64220[(2)] = inst_64123);

(statearr_64153_64220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (29))){
var inst_64014 = (state_64128[(19)]);
var inst_64069 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64014], 0));
var inst_64070 = ["Invalid block range provided: ",inst_64069].join('');
var inst_64071 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64072 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64073 = cljs.core.PersistentHashMap.fromArrays(inst_64071,inst_64072);
var inst_64074 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64070,inst_64073);
var inst_64075 = (function(){throw inst_64074})();
var state_64128__$1 = state_64128;
var statearr_64154_64221 = state_64128__$1;
(statearr_64154_64221[(2)] = inst_64075);

(statearr_64154_64221[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (6))){
var inst_64006 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64128__$1 = state_64128;
var statearr_64155_64222 = state_64128__$1;
(statearr_64155_64222[(2)] = inst_64006);

(statearr_64155_64222[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (28))){
var inst_64080 = (state_64128[(2)]);
var state_64128__$1 = state_64128;
var statearr_64156_64223 = state_64128__$1;
(statearr_64156_64223[(2)] = inst_64080);

(statearr_64156_64223[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (25))){
var inst_64085 = (state_64128[(17)]);
var inst_64083 = (state_64128[(10)]);
var inst_64082 = (state_64128[(2)]);
var inst_64083__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64082,(0),null);
var inst_64084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64082,(1),null);
var inst_64085__$1 = cljs.core.pos_int_QMARK_(inst_64083__$1);
var state_64128__$1 = (function (){var statearr_64157 = state_64128;
(statearr_64157[(9)] = inst_64084);

(statearr_64157[(17)] = inst_64085__$1);

(statearr_64157[(10)] = inst_64083__$1);

return statearr_64157;
})();
if(inst_64085__$1){
var statearr_64158_64224 = state_64128__$1;
(statearr_64158_64224[(1)] = (32));

} else {
var statearr_64159_64225 = state_64128__$1;
(statearr_64159_64225[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (34))){
var inst_64090 = (state_64128[(2)]);
var inst_64091 = cljs.core.not(inst_64090);
var state_64128__$1 = state_64128;
if(inst_64091){
var statearr_64160_64226 = state_64128__$1;
(statearr_64160_64226[(1)] = (35));

} else {
var statearr_64161_64227 = state_64128__$1;
(statearr_64161_64227[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (17))){
var inst_64037 = (state_64128[(8)]);
var inst_64039 = (state_64128[(15)]);
var inst_64042 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64037], 0));
var inst_64043 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64039], 0));
var inst_64044 = ["Start block is out of range for this ledger. Start block provided: ",inst_64042,". Database block: ",inst_64043].join('');
var inst_64045 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64046 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64047 = cljs.core.PersistentHashMap.fromArrays(inst_64045,inst_64046);
var inst_64048 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64044,inst_64047);
var inst_64049 = (function(){throw inst_64048})();
var state_64128__$1 = state_64128;
var statearr_64162_64228 = state_64128__$1;
(statearr_64162_64228[(2)] = inst_64049);

(statearr_64162_64228[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (3))){
var inst_64126 = (state_64128[(2)]);
var state_64128__$1 = state_64128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64128__$1,inst_64126);
} else {
if((state_val_64129 === (12))){
var inst_64023 = (state_64128[(18)]);
var inst_64014 = (state_64128[(19)]);
var inst_64021 = (state_64128[(2)]);
var inst_64022 = fluree.db.util.async.throw_err(inst_64021);
var inst_64023__$1 = cljs.core.second(inst_64014);
var state_64128__$1 = (function (){var statearr_64163 = state_64128;
(statearr_64163[(18)] = inst_64023__$1);

(statearr_64163[(13)] = inst_64022);

return statearr_64163;
})();
if(cljs.core.truth_(inst_64023__$1)){
var statearr_64164_64229 = state_64128__$1;
(statearr_64164_64229[(1)] = (13));

} else {
var statearr_64165_64230 = state_64128__$1;
(statearr_64165_64230[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (2))){
var _ = (function (){var statearr_64166 = state_64128;
(statearr_64166[(4)] = cljs.core.cons((5),(state_64128[(4)])));

return statearr_64166;
})();
var inst_64003 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64004 = cljs.core.sequential_QMARK_(inst_64003);
var state_64128__$1 = state_64128;
if(inst_64004){
var statearr_64167_64231 = state_64128__$1;
(statearr_64167_64231[(1)] = (6));

} else {
var statearr_64168_64232 = state_64128__$1;
(statearr_64168_64232[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (23))){
var inst_64037 = (state_64128[(8)]);
var inst_64038 = (state_64128[(7)]);
var inst_64058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64059 = [inst_64037,inst_64038];
var inst_64060 = (new cljs.core.PersistentVector(null,2,(5),inst_64058,inst_64059,null));
var state_64128__$1 = state_64128;
var statearr_64169_64233 = state_64128__$1;
(statearr_64169_64233[(2)] = inst_64060);

(statearr_64169_64233[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (35))){
var inst_64014 = (state_64128[(19)]);
var inst_64093 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64014], 0));
var inst_64094 = ["Invalid block range provided: ",inst_64093].join('');
var inst_64095 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64096 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64097 = cljs.core.PersistentHashMap.fromArrays(inst_64095,inst_64096);
var inst_64098 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64094,inst_64097);
var inst_64099 = (function(){throw inst_64098})();
var state_64128__$1 = state_64128;
var statearr_64170_64234 = state_64128__$1;
(statearr_64170_64234[(2)] = inst_64099);

(statearr_64170_64234[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (19))){
var inst_64037 = (state_64128[(8)]);
var inst_64052 = (state_64128[(2)]);
var state_64128__$1 = (function (){var statearr_64171 = state_64128;
(statearr_64171[(20)] = inst_64052);

return statearr_64171;
})();
if(cljs.core.truth_(inst_64037)){
var statearr_64172_64235 = state_64128__$1;
(statearr_64172_64235[(1)] = (20));

} else {
var statearr_64173_64236 = state_64128__$1;
(statearr_64173_64236[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (11))){
var inst_64037 = (state_64128[(8)]);
var inst_64039 = (state_64128[(15)]);
var inst_64036 = (state_64128[(2)]);
var inst_64037__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64036,(0),null);
var inst_64038 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64036,(1),null);
var inst_64039__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64040 = (inst_64037__$1 > inst_64039__$1);
var state_64128__$1 = (function (){var statearr_64175 = state_64128;
(statearr_64175[(8)] = inst_64037__$1);

(statearr_64175[(7)] = inst_64038);

(statearr_64175[(15)] = inst_64039__$1);

return statearr_64175;
})();
if(cljs.core.truth_(inst_64040)){
var statearr_64176_64237 = state_64128__$1;
(statearr_64176_64237[(1)] = (17));

} else {
var statearr_64177_64238 = state_64128__$1;
(statearr_64177_64238[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (9))){
var inst_64014 = (state_64128[(19)]);
var inst_64017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64018 = cljs.core.first(inst_64014);
var inst_64019 = fluree.db.time_travel.block_to_int_format(db,inst_64018);
var state_64128__$1 = (function (){var statearr_64178 = state_64128;
(statearr_64178[(12)] = inst_64017);

return statearr_64178;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64128__$1,(12),inst_64019);
} else {
if((state_val_64129 === (5))){
var _ = (function (){var statearr_64179 = state_64128;
(statearr_64179[(4)] = cljs.core.rest((state_64128[(4)])));

return statearr_64179;
})();
var state_64128__$1 = state_64128;
var ex64174 = (state_64128__$1[(2)]);
var statearr_64180_64239 = state_64128__$1;
(statearr_64180_64239[(5)] = ex64174);


var statearr_64181_64240 = state_64128__$1;
(statearr_64181_64240[(1)] = (4));

(statearr_64181_64240[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (14))){
var state_64128__$1 = state_64128;
var statearr_64182_64241 = state_64128__$1;
(statearr_64182_64241[(2)] = null);

(statearr_64182_64241[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (26))){
var inst_64037 = (state_64128[(8)]);
var inst_64063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64064 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64065 = [inst_64037,inst_64064];
var inst_64066 = (new cljs.core.PersistentVector(null,2,(5),inst_64063,inst_64065,null));
var state_64128__$1 = state_64128;
var statearr_64183_64242 = state_64128__$1;
(statearr_64183_64242[(2)] = inst_64066);

(statearr_64183_64242[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (16))){
var inst_64027 = (state_64128[(2)]);
var inst_64028 = fluree.db.util.async.throw_err(inst_64027);
var state_64128__$1 = state_64128;
var statearr_64184_64243 = state_64128__$1;
(statearr_64184_64243[(2)] = inst_64028);

(statearr_64184_64243[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (38))){
var inst_64084 = (state_64128[(9)]);
var inst_64083 = (state_64128[(10)]);
var inst_64105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64106 = [inst_64084,inst_64083];
var inst_64107 = (new cljs.core.PersistentVector(null,2,(5),inst_64105,inst_64106,null));
var state_64128__$1 = state_64128;
var statearr_64185_64244 = state_64128__$1;
(statearr_64185_64244[(2)] = inst_64107);

(statearr_64185_64244[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (30))){
var state_64128__$1 = state_64128;
var statearr_64186_64245 = state_64128__$1;
(statearr_64186_64245[(2)] = null);

(statearr_64186_64245[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (10))){
var inst_64014 = (state_64128[(19)]);
var state_64128__$1 = state_64128;
var statearr_64187_64246 = state_64128__$1;
(statearr_64187_64246[(2)] = inst_64014);

(statearr_64187_64246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (18))){
var state_64128__$1 = state_64128;
var statearr_64188_64247 = state_64128__$1;
(statearr_64188_64247[(2)] = null);

(statearr_64188_64247[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (42))){
var inst_64115 = (state_64128[(14)]);
var state_64128__$1 = state_64128;
var statearr_64189_64248 = state_64128__$1;
(statearr_64189_64248[(2)] = inst_64115);

(statearr_64189_64248[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (37))){
var inst_64084 = (state_64128[(9)]);
var inst_64083 = (state_64128[(10)]);
var inst_64102 = (state_64128[(2)]);
var inst_64103 = (inst_64084 < inst_64083);
var state_64128__$1 = (function (){var statearr_64190 = state_64128;
(statearr_64190[(21)] = inst_64102);

return statearr_64190;
})();
if(cljs.core.truth_(inst_64103)){
var statearr_64191_64249 = state_64128__$1;
(statearr_64191_64249[(1)] = (38));

} else {
var statearr_64192_64250 = state_64128__$1;
(statearr_64192_64250[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64129 === (8))){
var inst_64014 = (state_64128[(19)]);
var inst_64014__$1 = (state_64128[(2)]);
var inst_64015 = cljs.core.some(cljs.core.string_QMARK_,inst_64014__$1);
var state_64128__$1 = (function (){var statearr_64193 = state_64128;
(statearr_64193[(19)] = inst_64014__$1);

return statearr_64193;
})();
if(cljs.core.truth_(inst_64015)){
var statearr_64194_64251 = state_64128__$1;
(statearr_64194_64251[(1)] = (9));

} else {
var statearr_64195_64252 = state_64128__$1;
(statearr_64195_64252[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_64196 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64196[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__);

(statearr_64196[(1)] = (1));

return statearr_64196;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_64128){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64128);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64197){var ex__2730__auto__ = e64197;
var statearr_64198_64253 = state_64128;
(statearr_64198_64253[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64128[(4)]))){
var statearr_64199_64254 = state_64128;
(statearr_64199_64254[(1)] = cljs.core.first((state_64128[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64255 = state_64128;
state_64128 = G__64255;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__ = function(state_64128){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_64128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64200 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64200[(6)] = c__2749__auto__);

return statearr_64200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__64257 = arguments.length;
switch (G__64257) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64348){
var state_val_64349 = (state_64348[(1)]);
if((state_val_64349 === (7))){
var inst_64280 = (state_64348[(7)]);
var inst_64283 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_64280);
var state_64348__$1 = state_64348;
var statearr_64350_64401 = state_64348__$1;
(statearr_64350_64401[(2)] = inst_64283);

(statearr_64350_64401[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (20))){
var inst_64319 = (state_64348[(8)]);
var inst_64322 = fluree.db.api_js.format_block_resp_pretty(db,inst_64319);
var state_64348__$1 = state_64348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64348__$1,(23),inst_64322);
} else {
if((state_val_64349 === (27))){
var inst_64328 = (state_64348[(9)]);
var inst_64334 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64328);
var state_64348__$1 = state_64348;
var statearr_64351_64402 = state_64348__$1;
(statearr_64351_64402[(2)] = inst_64334);

(statearr_64351_64402[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (1))){
var state_64348__$1 = state_64348;
var statearr_64352_64403 = state_64348__$1;
(statearr_64352_64403[(2)] = null);

(statearr_64352_64403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (24))){
var inst_64328 = (state_64348[(9)]);
var inst_64331 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_64332 = cljs.core.sequential_QMARK_(inst_64328);
var state_64348__$1 = (function (){var statearr_64353 = state_64348;
(statearr_64353[(10)] = inst_64331);

return statearr_64353;
})();
if(inst_64332){
var statearr_64354_64404 = state_64348__$1;
(statearr_64354_64404[(1)] = (27));

} else {
var statearr_64355_64405 = state_64348__$1;
(statearr_64355_64405[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (4))){
var inst_64258 = (state_64348[(2)]);
var inst_64259 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64258], 0));
var inst_64260 = cljs.core.ex_data(inst_64258);
var inst_64261 = cljs.core.ex_message(inst_64258);
var inst_64262 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64260,new cljs.core.Keyword(null,"message","message",-406056002),inst_64261);
var state_64348__$1 = (function (){var statearr_64356 = state_64348;
(statearr_64356[(11)] = inst_64259);

return statearr_64356;
})();
var statearr_64357_64406 = state_64348__$1;
(statearr_64357_64406[(2)] = inst_64262);

(statearr_64357_64406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (15))){
var inst_64280 = (state_64348[(7)]);
var inst_64293 = (state_64348[(2)]);
var inst_64294 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64293,inst_64280);
var inst_64295 = (function(){throw inst_64294})();
var state_64348__$1 = state_64348;
var statearr_64358_64407 = state_64348__$1;
(statearr_64358_64407[(2)] = inst_64295);

(statearr_64358_64407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (21))){
var inst_64319 = (state_64348[(8)]);
var state_64348__$1 = state_64348;
var statearr_64359_64408 = state_64348__$1;
(statearr_64359_64408[(2)] = inst_64319);

(statearr_64359_64408[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (13))){
var inst_64288 = (state_64348[(12)]);
var state_64348__$1 = state_64348;
var statearr_64360_64409 = state_64348__$1;
(statearr_64360_64409[(2)] = inst_64288);

(statearr_64360_64409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (22))){
var inst_64328 = (state_64348[(2)]);
var inst_64329 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64348__$1 = (function (){var statearr_64361 = state_64348;
(statearr_64361[(9)] = inst_64328);

return statearr_64361;
})();
if(cljs.core.truth_(inst_64329)){
var statearr_64362_64410 = state_64348__$1;
(statearr_64362_64410[(1)] = (24));

} else {
var statearr_64363_64411 = state_64348__$1;
(statearr_64363_64411[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (29))){
var inst_64331 = (state_64348[(10)]);
var inst_64272 = (state_64348[(13)]);
var inst_64337 = (state_64348[(2)]);
var inst_64338 = fluree.db.util.core.response_time_formatted(inst_64272);
var inst_64339 = [(200),inst_64337,(100),inst_64338];
var inst_64340 = cljs.core.PersistentHashMap.fromArrays(inst_64331,inst_64339);
var state_64348__$1 = state_64348;
var statearr_64364_64412 = state_64348__$1;
(statearr_64364_64412[(2)] = inst_64340);

(statearr_64364_64412[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (6))){
var inst_64281 = (state_64348[(14)]);
var inst_64280 = (state_64348[(7)]);
var inst_64279 = (state_64348[(2)]);
var inst_64280__$1 = fluree.db.util.async.throw_err(inst_64279);
var inst_64281__$1 = cljs.core.map_QMARK_(inst_64280__$1);
var state_64348__$1 = (function (){var statearr_64365 = state_64348;
(statearr_64365[(14)] = inst_64281__$1);

(statearr_64365[(7)] = inst_64280__$1);

return statearr_64365;
})();
if(inst_64281__$1){
var statearr_64366_64413 = state_64348__$1;
(statearr_64366_64413[(1)] = (7));

} else {
var statearr_64367_64414 = state_64348__$1;
(statearr_64367_64414[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (28))){
var inst_64328 = (state_64348[(9)]);
var state_64348__$1 = state_64348;
var statearr_64368_64415 = state_64348__$1;
(statearr_64368_64415[(2)] = inst_64328);

(statearr_64368_64415[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (25))){
var inst_64328 = (state_64348[(9)]);
var state_64348__$1 = state_64348;
var statearr_64369_64416 = state_64348__$1;
(statearr_64369_64416[(2)] = inst_64328);

(statearr_64369_64416[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (17))){
var inst_64311 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_64312 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_64311].join('');
var inst_64313 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64314 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64315 = cljs.core.PersistentHashMap.fromArrays(inst_64313,inst_64314);
var inst_64316 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64312,inst_64315);
var inst_64317 = (function(){throw inst_64316})();
var state_64348__$1 = state_64348;
var statearr_64370_64417 = state_64348__$1;
(statearr_64370_64417[(2)] = inst_64317);

(statearr_64370_64417[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (3))){
var inst_64346 = (state_64348[(2)]);
var state_64348__$1 = state_64348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64348__$1,inst_64346);
} else {
if((state_val_64349 === (12))){
var inst_64280 = (state_64348[(7)]);
var inst_64298 = (state_64348[(2)]);
var inst_64299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64280,(0),null);
var inst_64300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64280,(1),null);
var inst_64301 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_64302 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_64303 = cljs.core.keys(inst_64302);
var inst_64304 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64301,inst_64303);
var state_64348__$1 = (function (){var statearr_64371 = state_64348;
(statearr_64371[(15)] = inst_64298);

(statearr_64371[(16)] = inst_64300);

(statearr_64371[(17)] = inst_64299);

return statearr_64371;
})();
if(inst_64304){
var statearr_64372_64418 = state_64348__$1;
(statearr_64372_64418[(1)] = (16));

} else {
var statearr_64373_64419 = state_64348__$1;
(statearr_64373_64419[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (2))){
var _ = (function (){var statearr_64374 = state_64348;
(statearr_64374[(4)] = cljs.core.cons((5),(state_64348[(4)])));

return statearr_64374;
})();
var inst_64272 = fluree.db.util.core.current_time_millis();
var inst_64273 = db;
var inst_64274 = cljs.core.__destructure_map(inst_64273);
var inst_64275 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64274,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_64276 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64274,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_64277 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_64348__$1 = (function (){var statearr_64375 = state_64348;
(statearr_64375[(18)] = inst_64275);

(statearr_64375[(19)] = inst_64276);

(statearr_64375[(13)] = inst_64272);

return statearr_64375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64348__$1,(6),inst_64277);
} else {
if((state_val_64349 === (23))){
var inst_64324 = (state_64348[(2)]);
var inst_64325 = fluree.db.util.async.throw_err(inst_64324);
var state_64348__$1 = state_64348;
var statearr_64376_64420 = state_64348__$1;
(statearr_64376_64420[(2)] = inst_64325);

(statearr_64376_64420[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (19))){
var inst_64308 = (state_64348[(2)]);
var inst_64309 = fluree.db.util.async.throw_err(inst_64308);
var state_64348__$1 = state_64348;
var statearr_64377_64421 = state_64348__$1;
(statearr_64377_64421[(2)] = inst_64309);

(statearr_64377_64421[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (11))){
var state_64348__$1 = state_64348;
var statearr_64379_64422 = state_64348__$1;
(statearr_64379_64422[(2)] = null);

(statearr_64379_64422[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (9))){
var inst_64286 = (state_64348[(2)]);
var state_64348__$1 = state_64348;
if(cljs.core.truth_(inst_64286)){
var statearr_64380_64423 = state_64348__$1;
(statearr_64380_64423[(1)] = (10));

} else {
var statearr_64381_64424 = state_64348__$1;
(statearr_64381_64424[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (5))){
var _ = (function (){var statearr_64382 = state_64348;
(statearr_64382[(4)] = cljs.core.rest((state_64348[(4)])));

return statearr_64382;
})();
var state_64348__$1 = state_64348;
var ex64378 = (state_64348__$1[(2)]);
var statearr_64383_64425 = state_64348__$1;
(statearr_64383_64425[(5)] = ex64378);


var statearr_64384_64426 = state_64348__$1;
(statearr_64384_64426[(1)] = (4));

(statearr_64384_64426[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (14))){
var inst_64275 = (state_64348[(18)]);
var inst_64276 = (state_64348[(19)]);
var inst_64291 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64275),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64276)].join('');
var state_64348__$1 = state_64348;
var statearr_64385_64427 = state_64348__$1;
(statearr_64385_64427[(2)] = inst_64291);

(statearr_64385_64427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (26))){
var inst_64343 = (state_64348[(2)]);
var _ = (function (){var statearr_64386 = state_64348;
(statearr_64386[(4)] = cljs.core.rest((state_64348[(4)])));

return statearr_64386;
})();
var state_64348__$1 = state_64348;
var statearr_64387_64428 = state_64348__$1;
(statearr_64387_64428[(2)] = inst_64343);

(statearr_64387_64428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (16))){
var inst_64300 = (state_64348[(16)]);
var inst_64299 = (state_64348[(17)]);
var inst_64306 = fluree.db.query.block.block_range(db,inst_64299,inst_64300,opts);
var state_64348__$1 = state_64348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64348__$1,(19),inst_64306);
} else {
if((state_val_64349 === (10))){
var inst_64280 = (state_64348[(7)]);
var inst_64288 = (state_64348[(12)]);
var inst_64288__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_64280);
var state_64348__$1 = (function (){var statearr_64388 = state_64348;
(statearr_64388[(12)] = inst_64288__$1);

return statearr_64388;
})();
if(cljs.core.truth_(inst_64288__$1)){
var statearr_64389_64429 = state_64348__$1;
(statearr_64389_64429[(1)] = (13));

} else {
var statearr_64390_64430 = state_64348__$1;
(statearr_64390_64430[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (18))){
var inst_64319 = (state_64348[(2)]);
var inst_64320 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64348__$1 = (function (){var statearr_64391 = state_64348;
(statearr_64391[(8)] = inst_64319);

return statearr_64391;
})();
if(cljs.core.truth_(inst_64320)){
var statearr_64392_64431 = state_64348__$1;
(statearr_64392_64431[(1)] = (20));

} else {
var statearr_64393_64432 = state_64348__$1;
(statearr_64393_64432[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64349 === (8))){
var inst_64281 = (state_64348[(14)]);
var state_64348__$1 = state_64348;
var statearr_64394_64433 = state_64348__$1;
(statearr_64394_64433[(2)] = inst_64281);

(statearr_64394_64433[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64395[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64395[(1)] = (1));

return statearr_64395;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64348){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64348);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64396){var ex__2730__auto__ = e64396;
var statearr_64397_64434 = state_64348;
(statearr_64397_64434[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64348[(4)]))){
var statearr_64398_64435 = state_64348;
(statearr_64398_64435[(1)] = cljs.core.first((state_64348[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64436 = state_64348;
state_64348 = G__64436;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64348){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64399 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64399[(6)] = c__2749__auto__);

return statearr_64399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64438 = arguments.length;
switch (G__64438) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64633){
var state_val_64634 = (state_64633[(1)]);
if((state_val_64634 === (62))){
var inst_64631 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64633__$1,inst_64631);
} else {
if((state_val_64634 === (7))){
var inst_64459 = (state_64633[(7)]);
var inst_64469 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64459);
var state_64633__$1 = state_64633;
var statearr_64635_64726 = state_64633__$1;
(statearr_64635_64726[(2)] = inst_64469);

(statearr_64635_64726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (59))){
var inst_64619 = (state_64633[(2)]);
var inst_64620 = fluree.db.util.async.throw_err(inst_64619);
var state_64633__$1 = state_64633;
var statearr_64636_64727 = state_64633__$1;
(statearr_64636_64727[(2)] = inst_64620);

(statearr_64636_64727[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (20))){
var inst_64527 = (state_64633[(8)]);
var inst_64535 = (state_64633[(9)]);
var inst_64527__$1 = (state_64633[(2)]);
var inst_64528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64527__$1,(0));
var inst_64530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64527__$1,(1));
var inst_64531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64527__$1,(2));
var inst_64532 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64527__$1,(3));
var inst_64533 = [inst_64529,inst_64530,inst_64531,inst_64532];
var inst_64534 = (new cljs.core.PersistentVector(null,4,(5),inst_64528,inst_64533,null));
var inst_64535__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64534,(0),null);
var inst_64536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64534,(1),null);
var inst_64537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64534,(2),null);
var inst_64538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64534,(3),null);
var inst_64539 = (inst_64535__$1 == null);
var inst_64540 = cljs.core.not(inst_64539);
var state_64633__$1 = (function (){var statearr_64637 = state_64633;
(statearr_64637[(8)] = inst_64527__$1);

(statearr_64637[(10)] = inst_64538);

(statearr_64637[(9)] = inst_64535__$1);

(statearr_64637[(11)] = inst_64537);

(statearr_64637[(12)] = inst_64536);

return statearr_64637;
})();
if(inst_64540){
var statearr_64638_64728 = state_64633__$1;
(statearr_64638_64728[(1)] = (30));

} else {
var statearr_64639_64729 = state_64633__$1;
(statearr_64639_64729[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (58))){
var inst_64467 = (state_64633[(13)]);
var inst_64623 = (state_64633[(2)]);
var state_64633__$1 = (function (){var statearr_64640 = state_64633;
(statearr_64640[(14)] = inst_64623);

return statearr_64640;
})();
if(cljs.core.truth_(inst_64467)){
var statearr_64641_64730 = state_64633__$1;
(statearr_64641_64730[(1)] = (60));

} else {
var statearr_64642_64731 = state_64633__$1;
(statearr_64642_64731[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (60))){
var inst_64611 = (state_64633[(15)]);
var inst_64623 = (state_64633[(14)]);
var inst_64625 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64626 = cljs.core.count(inst_64611);
var inst_64627 = [inst_64623,inst_64626,(200)];
var inst_64628 = cljs.core.PersistentHashMap.fromArrays(inst_64625,inst_64627);
var state_64633__$1 = state_64633;
var statearr_64643_64732 = state_64633__$1;
(statearr_64643_64732[(2)] = inst_64628);

(statearr_64643_64732[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (27))){
var inst_64446 = (state_64633[(16)]);
var inst_64515 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64446)].join('');
var inst_64516 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64517 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64518 = cljs.core.PersistentHashMap.fromArrays(inst_64516,inst_64517);
var inst_64519 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64515,inst_64518);
var inst_64520 = (function(){throw inst_64519})();
var state_64633__$1 = state_64633;
var statearr_64644_64733 = state_64633__$1;
(statearr_64644_64733[(2)] = inst_64520);

(statearr_64644_64733[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (1))){
var inst_64443 = query_map;
var inst_64444 = cljs.core.__destructure_map(inst_64443);
var inst_64445 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64444,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64446 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64444,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64444,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_64633__$1 = (function (){var statearr_64645 = state_64633;
(statearr_64645[(16)] = inst_64446);

(statearr_64645[(17)] = inst_64445);

(statearr_64645[(18)] = inst_64447);

return statearr_64645;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(2),sources);
} else {
if((state_val_64634 === (24))){
var inst_64446 = (state_64633[(16)]);
var inst_64504 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64446)].join('');
var inst_64505 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64506 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64507 = cljs.core.PersistentHashMap.fromArrays(inst_64505,inst_64506);
var inst_64508 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64504,inst_64507);
var inst_64509 = (function(){throw inst_64508})();
var state_64633__$1 = state_64633;
var statearr_64646_64734 = state_64633__$1;
(statearr_64646_64734[(2)] = inst_64509);

(statearr_64646_64734[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (55))){
var inst_64447 = (state_64633[(18)]);
var inst_64614 = (state_64633[(2)]);
var inst_64615 = fluree.db.util.async.throw_err(inst_64614);
var state_64633__$1 = (function (){var statearr_64647 = state_64633;
(statearr_64647[(19)] = inst_64615);

return statearr_64647;
})();
if(cljs.core.truth_(inst_64447)){
var statearr_64648_64735 = state_64633__$1;
(statearr_64648_64735[(1)] = (56));

} else {
var statearr_64649_64736 = state_64633__$1;
(statearr_64649_64736[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (39))){
var inst_64538 = (state_64633[(10)]);
var inst_64535 = (state_64633[(9)]);
var inst_64537 = (state_64633[(11)]);
var inst_64536 = (state_64633[(12)]);
var inst_64559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64561 = [inst_64536,inst_64535,inst_64537,inst_64538];
var inst_64562 = (new cljs.core.PersistentVector(null,4,(5),inst_64560,inst_64561,null));
var inst_64563 = [inst_64562,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_64564 = (new cljs.core.PersistentVector(null,2,(5),inst_64559,inst_64563,null));
var state_64633__$1 = state_64633;
var statearr_64650_64737 = state_64633__$1;
(statearr_64650_64737[(2)] = inst_64564);

(statearr_64650_64737[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (46))){
var inst_64569 = (state_64633[(20)]);
var state_64633__$1 = state_64633;
var statearr_64651_64738 = state_64633__$1;
(statearr_64651_64738[(2)] = inst_64569);

(statearr_64651_64738[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (4))){
var state_64633__$1 = state_64633;
var statearr_64652_64739 = state_64633__$1;
(statearr_64652_64739[(2)] = null);

(statearr_64652_64739[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (54))){
var inst_64611 = (state_64633[(15)]);
var inst_64450 = (state_64633[(21)]);
var inst_64610 = (state_64633[(2)]);
var inst_64611__$1 = fluree.db.util.async.throw_err(inst_64610);
var inst_64612 = fluree.db.api_js.format_history_resp(inst_64450,inst_64611__$1);
var state_64633__$1 = (function (){var statearr_64653 = state_64633;
(statearr_64653[(15)] = inst_64611__$1);

return statearr_64653;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(55),inst_64612);
} else {
if((state_val_64634 === (15))){
var inst_64450 = (state_64633[(21)]);
var inst_64491 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64450);
var state_64633__$1 = state_64633;
var statearr_64654_64740 = state_64633__$1;
(statearr_64654_64740[(2)] = inst_64491);

(statearr_64654_64740[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (48))){
var inst_64538 = (state_64633[(10)]);
var inst_64535 = (state_64633[(9)]);
var inst_64537 = (state_64633[(11)]);
var inst_64536 = (state_64633[(12)]);
var inst_64580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64582 = [inst_64536,inst_64537,inst_64535,inst_64538];
var inst_64583 = (new cljs.core.PersistentVector(null,4,(5),inst_64581,inst_64582,null));
var inst_64584 = [inst_64583,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_64585 = (new cljs.core.PersistentVector(null,2,(5),inst_64580,inst_64584,null));
var state_64633__$1 = state_64633;
var statearr_64655_64741 = state_64633__$1;
(statearr_64655_64741[(2)] = inst_64585);

(statearr_64655_64741[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (50))){
var inst_64598 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64656_64742 = state_64633__$1;
(statearr_64656_64742[(2)] = inst_64598);

(statearr_64656_64742[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (21))){
var inst_64446 = (state_64633[(16)]);
var inst_64502 = cljs.core.empty_QMARK_(inst_64446);
var state_64633__$1 = state_64633;
if(inst_64502){
var statearr_64657_64743 = state_64633__$1;
(statearr_64657_64743[(1)] = (24));

} else {
var statearr_64658_64744 = state_64633__$1;
(statearr_64658_64744[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (31))){
var inst_64535 = (state_64633[(9)]);
var inst_64546 = (state_64633[(22)]);
var inst_64546__$1 = (inst_64535 == null);
var state_64633__$1 = (function (){var statearr_64659 = state_64633;
(statearr_64659[(22)] = inst_64546__$1);

return statearr_64659;
})();
if(cljs.core.truth_(inst_64546__$1)){
var statearr_64660_64745 = state_64633__$1;
(statearr_64660_64745[(1)] = (33));

} else {
var statearr_64661_64746 = state_64633__$1;
(statearr_64661_64746[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (32))){
var inst_64493 = (state_64633[(23)]);
var inst_64483 = (state_64633[(24)]);
var inst_64450 = (state_64633[(21)]);
var inst_64602 = (state_64633[(2)]);
var inst_64603 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64602,(0),null);
var inst_64604 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64602,(1),null);
var inst_64605 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_64606 = [inst_64483,inst_64493];
var inst_64607 = cljs.core.PersistentHashMap.fromArrays(inst_64605,inst_64606);
var inst_64608 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_64450,inst_64604,cljs.core._EQ_,inst_64603,inst_64607);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(54),inst_64608);
} else {
if((state_val_64634 === (40))){
var inst_64535 = (state_64633[(9)]);
var inst_64566 = (state_64633[(25)]);
var inst_64566__$1 = (inst_64535 == null);
var state_64633__$1 = (function (){var statearr_64662 = state_64633;
(statearr_64662[(25)] = inst_64566__$1);

return statearr_64662;
})();
if(cljs.core.truth_(inst_64566__$1)){
var statearr_64663_64747 = state_64633__$1;
(statearr_64663_64747[(1)] = (42));

} else {
var statearr_64664_64748 = state_64633__$1;
(statearr_64664_64748[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (56))){
var inst_64615 = (state_64633[(19)]);
var inst_64450 = (state_64633[(21)]);
var inst_64617 = fluree.db.api_js.format_block_resp_pretty(inst_64450,inst_64615);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(59),inst_64617);
} else {
if((state_val_64634 === (33))){
var inst_64549 = (state_64633[(26)]);
var inst_64536 = (state_64633[(12)]);
var inst_64548 = (inst_64536 == null);
var inst_64549__$1 = cljs.core.not(inst_64548);
var state_64633__$1 = (function (){var statearr_64665 = state_64633;
(statearr_64665[(26)] = inst_64549__$1);

return statearr_64665;
})();
if(inst_64549__$1){
var statearr_64666_64749 = state_64633__$1;
(statearr_64666_64749[(1)] = (36));

} else {
var statearr_64667_64750 = state_64633__$1;
(statearr_64667_64750[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (13))){
var inst_64477 = (state_64633[(2)]);
var inst_64478 = fluree.db.util.async.throw_err(inst_64477);
var inst_64479 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64478);
var inst_64480 = (inst_64479 - (1));
var state_64633__$1 = state_64633;
var statearr_64668_64751 = state_64633__$1;
(statearr_64668_64751[(2)] = inst_64480);

(statearr_64668_64751[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (22))){
var state_64633__$1 = state_64633;
var statearr_64669_64752 = state_64633__$1;
(statearr_64669_64752[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (36))){
var inst_64537 = (state_64633[(11)]);
var inst_64551 = (inst_64537 == null);
var state_64633__$1 = state_64633;
var statearr_64671_64753 = state_64633__$1;
(statearr_64671_64753[(2)] = inst_64551);

(statearr_64671_64753[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (41))){
var inst_64600 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64672_64754 = state_64633__$1;
(statearr_64672_64754[(2)] = inst_64600);

(statearr_64672_64754[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (43))){
var inst_64566 = (state_64633[(25)]);
var state_64633__$1 = state_64633;
var statearr_64673_64755 = state_64633__$1;
(statearr_64673_64755[(2)] = inst_64566);

(statearr_64673_64755[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (61))){
var inst_64623 = (state_64633[(14)]);
var state_64633__$1 = state_64633;
var statearr_64674_64756 = state_64633__$1;
(statearr_64674_64756[(2)] = inst_64623);

(statearr_64674_64756[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (29))){
var inst_64523 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64675_64757 = state_64633__$1;
(statearr_64675_64757[(2)] = inst_64523);

(statearr_64675_64757[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (44))){
var inst_64578 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
if(cljs.core.truth_(inst_64578)){
var statearr_64676_64758 = state_64633__$1;
(statearr_64676_64758[(1)] = (48));

} else {
var statearr_64677_64759 = state_64633__$1;
(statearr_64677_64759[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (6))){
var inst_64454 = (state_64633[(2)]);
var inst_64455 = fluree.db.util.async.throw_err(inst_64454);
var state_64633__$1 = state_64633;
var statearr_64678_64760 = state_64633__$1;
(statearr_64678_64760[(2)] = inst_64455);

(statearr_64678_64760[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (28))){
var state_64633__$1 = state_64633;
var statearr_64679_64761 = state_64633__$1;
(statearr_64679_64761[(2)] = null);

(statearr_64679_64761[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (51))){
var inst_64446 = (state_64633[(16)]);
var inst_64588 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64446)].join('');
var inst_64589 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64590 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64591 = cljs.core.PersistentHashMap.fromArrays(inst_64589,inst_64590);
var inst_64592 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64588,inst_64591);
var inst_64593 = (function(){throw inst_64592})();
var state_64633__$1 = state_64633;
var statearr_64680_64762 = state_64633__$1;
(statearr_64680_64762[(2)] = inst_64593);

(statearr_64680_64762[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (25))){
var inst_64446 = (state_64633[(16)]);
var state_64633__$1 = state_64633;
var statearr_64681_64763 = state_64633__$1;
(statearr_64681_64763[(2)] = inst_64446);

(statearr_64681_64763[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (34))){
var inst_64546 = (state_64633[(22)]);
var state_64633__$1 = state_64633;
var statearr_64682_64764 = state_64633__$1;
(statearr_64682_64764[(2)] = inst_64546);

(statearr_64682_64764[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (17))){
var inst_64487 = (state_64633[(2)]);
var inst_64488 = fluree.db.util.async.throw_err(inst_64487);
var inst_64489 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64488);
var state_64633__$1 = state_64633;
var statearr_64683_64765 = state_64633__$1;
(statearr_64683_64765[(2)] = inst_64489);

(statearr_64683_64765[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (3))){
var inst_64450 = (state_64633[(21)]);
var inst_64452 = fluree.db.api_js.resolve_block_range(inst_64450,query_map);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(6),inst_64452);
} else {
if((state_val_64634 === (12))){
var inst_64460 = (state_64633[(27)]);
var inst_64483 = (state_64633[(2)]);
var state_64633__$1 = (function (){var statearr_64684 = state_64633;
(statearr_64684[(24)] = inst_64483);

return statearr_64684;
})();
if(cljs.core.truth_(inst_64460)){
var statearr_64685_64766 = state_64633__$1;
(statearr_64685_64766[(1)] = (14));

} else {
var statearr_64686_64767 = state_64633__$1;
(statearr_64686_64767[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (2))){
var inst_64445 = (state_64633[(17)]);
var inst_64449 = (state_64633[(2)]);
var inst_64450 = fluree.db.util.async.throw_err(inst_64449);
var state_64633__$1 = (function (){var statearr_64687 = state_64633;
(statearr_64687[(21)] = inst_64450);

return statearr_64687;
})();
if(cljs.core.truth_(inst_64445)){
var statearr_64688_64768 = state_64633__$1;
(statearr_64688_64768[(1)] = (3));

} else {
var statearr_64689_64769 = state_64633__$1;
(statearr_64689_64769[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (23))){
var inst_64525 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64690_64770 = state_64633__$1;
(statearr_64690_64770[(2)] = inst_64525);

(statearr_64690_64770[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (47))){
var inst_64575 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64691_64771 = state_64633__$1;
(statearr_64691_64771[(2)] = inst_64575);

(statearr_64691_64771[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (35))){
var inst_64557 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
if(cljs.core.truth_(inst_64557)){
var statearr_64692_64772 = state_64633__$1;
(statearr_64692_64772[(1)] = (39));

} else {
var statearr_64693_64773 = state_64633__$1;
(statearr_64693_64773[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (19))){
var inst_64446 = (state_64633[(16)]);
var inst_64500 = cljs.core.sequential_QMARK_(inst_64446);
var state_64633__$1 = state_64633;
if(inst_64500){
var statearr_64694_64774 = state_64633__$1;
(statearr_64694_64774[(1)] = (21));

} else {
var statearr_64695_64775 = state_64633__$1;
(statearr_64695_64775[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (57))){
var inst_64615 = (state_64633[(19)]);
var state_64633__$1 = state_64633;
var statearr_64696_64776 = state_64633__$1;
(statearr_64696_64776[(2)] = inst_64615);

(statearr_64696_64776[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (11))){
var state_64633__$1 = state_64633;
var statearr_64697_64777 = state_64633__$1;
(statearr_64697_64777[(2)] = (-1));

(statearr_64697_64777[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (9))){
var inst_64472 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
if(cljs.core.truth_(inst_64472)){
var statearr_64698_64778 = state_64633__$1;
(statearr_64698_64778[(1)] = (10));

} else {
var statearr_64699_64779 = state_64633__$1;
(statearr_64699_64779[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (5))){
var inst_64459 = (state_64633[(7)]);
var inst_64458 = (state_64633[(2)]);
var inst_64459__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64458,(0),null);
var inst_64460 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64458,(1),null);
var inst_64467 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64633__$1 = (function (){var statearr_64700 = state_64633;
(statearr_64700[(27)] = inst_64460);

(statearr_64700[(7)] = inst_64459__$1);

(statearr_64700[(13)] = inst_64467);

return statearr_64700;
})();
if(cljs.core.truth_(inst_64459__$1)){
var statearr_64701_64780 = state_64633__$1;
(statearr_64701_64780[(1)] = (7));

} else {
var statearr_64702_64781 = state_64633__$1;
(statearr_64702_64781[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (14))){
var inst_64460 = (state_64633[(27)]);
var inst_64450 = (state_64633[(21)]);
var inst_64485 = fluree.db.time_travel.as_of_block(inst_64450,inst_64460);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(17),inst_64485);
} else {
if((state_val_64634 === (45))){
var inst_64537 = (state_64633[(11)]);
var inst_64571 = (inst_64537 == null);
var inst_64572 = cljs.core.not(inst_64571);
var state_64633__$1 = state_64633;
var statearr_64703_64782 = state_64633__$1;
(statearr_64703_64782[(2)] = inst_64572);

(statearr_64703_64782[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (53))){
var inst_64596 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64704_64783 = state_64633__$1;
(statearr_64704_64783[(2)] = inst_64596);

(statearr_64704_64783[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (26))){
var inst_64512 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64705_64784 = state_64633__$1;
(statearr_64705_64784[(2)] = inst_64512);

(statearr_64705_64784[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (16))){
var inst_64446 = (state_64633[(16)]);
var inst_64493 = (state_64633[(2)]);
var inst_64494 = fluree.db.util.core.subj_ident_QMARK_(inst_64446);
var state_64633__$1 = (function (){var statearr_64706 = state_64633;
(statearr_64706[(23)] = inst_64493);

return statearr_64706;
})();
if(inst_64494){
var statearr_64707_64785 = state_64633__$1;
(statearr_64707_64785[(1)] = (18));

} else {
var statearr_64708_64786 = state_64633__$1;
(statearr_64708_64786[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (38))){
var inst_64554 = (state_64633[(2)]);
var state_64633__$1 = state_64633;
var statearr_64709_64787 = state_64633__$1;
(statearr_64709_64787[(2)] = inst_64554);

(statearr_64709_64787[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (30))){
var inst_64527 = (state_64633[(8)]);
var inst_64542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64543 = [inst_64527,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_64544 = (new cljs.core.PersistentVector(null,2,(5),inst_64542,inst_64543,null));
var state_64633__$1 = state_64633;
var statearr_64710_64788 = state_64633__$1;
(statearr_64710_64788[(2)] = inst_64544);

(statearr_64710_64788[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (10))){
var inst_64459 = (state_64633[(7)]);
var inst_64450 = (state_64633[(21)]);
var inst_64474 = (inst_64459 - (1));
var inst_64475 = fluree.db.time_travel.as_of_block(inst_64450,inst_64474);
var state_64633__$1 = state_64633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64633__$1,(13),inst_64475);
} else {
if((state_val_64634 === (18))){
var inst_64446 = (state_64633[(16)]);
var inst_64496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64497 = [inst_64446];
var inst_64498 = (new cljs.core.PersistentVector(null,1,(5),inst_64496,inst_64497,null));
var state_64633__$1 = state_64633;
var statearr_64711_64789 = state_64633__$1;
(statearr_64711_64789[(2)] = inst_64498);

(statearr_64711_64789[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (52))){
var state_64633__$1 = state_64633;
var statearr_64712_64790 = state_64633__$1;
(statearr_64712_64790[(2)] = null);

(statearr_64712_64790[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (42))){
var inst_64569 = (state_64633[(20)]);
var inst_64536 = (state_64633[(12)]);
var inst_64568 = (inst_64536 == null);
var inst_64569__$1 = cljs.core.not(inst_64568);
var state_64633__$1 = (function (){var statearr_64713 = state_64633;
(statearr_64713[(20)] = inst_64569__$1);

return statearr_64713;
})();
if(inst_64569__$1){
var statearr_64714_64791 = state_64633__$1;
(statearr_64714_64791[(1)] = (45));

} else {
var statearr_64715_64792 = state_64633__$1;
(statearr_64715_64792[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (37))){
var inst_64549 = (state_64633[(26)]);
var state_64633__$1 = state_64633;
var statearr_64716_64793 = state_64633__$1;
(statearr_64716_64793[(2)] = inst_64549);

(statearr_64716_64793[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (8))){
var inst_64459 = (state_64633[(7)]);
var state_64633__$1 = state_64633;
var statearr_64717_64794 = state_64633__$1;
(statearr_64717_64794[(2)] = inst_64459);

(statearr_64717_64794[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64634 === (49))){
var state_64633__$1 = state_64633;
var statearr_64718_64795 = state_64633__$1;
(statearr_64718_64795[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64720[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64720[(1)] = (1));

return statearr_64720;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64633){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64633);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64721){var ex__2730__auto__ = e64721;
var statearr_64722_64796 = state_64633;
(statearr_64722_64796[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64633[(4)]))){
var statearr_64723_64797 = state_64633;
(statearr_64723_64797[(1)] = cljs.core.first((state_64633[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64798 = state_64633;
state_64633 = G__64798;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64633){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64724 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64724[(6)] = c__2749__auto__);

return statearr_64724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__64806 = arguments.length;
switch (G__64806) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64799_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__64799_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64895){
var state_val_64896 = (state_64895[(1)]);
if((state_val_64896 === (7))){
var inst_64849 = (state_64895[(7)]);
var inst_64846 = (state_64895[(8)]);
var inst_64856 = (state_64895[(9)]);
var inst_64852 = (state_64895[(10)]);
var inst_64862 = (function (){var responses = inst_64846;
var responses_STAR_ = inst_64849;
var statuses = inst_64852;
var fuel = inst_64856;
return (function (p1__64802_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__64802_SHARP_);
});
})();
var inst_64863 = cljs.core.some(inst_64862,inst_64852);
var state_64895__$1 = state_64895;
if(cljs.core.truth_(inst_64863)){
var statearr_64897_64945 = state_64895__$1;
(statearr_64897_64945[(1)] = (9));

} else {
var statearr_64898_64946 = state_64895__$1;
(statearr_64898_64946[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (20))){
var inst_64890 = (state_64895[(2)]);
var state_64895__$1 = state_64895;
var statearr_64899_64947 = state_64895__$1;
(statearr_64899_64947[(2)] = inst_64890);

(statearr_64899_64947[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (1))){
var inst_64841 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64842 = (function (){var c__2749__auto____$1 = inst_64841;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_64839){
var state_val_64840 = (state_64839[(1)]);
if((state_val_64840 === (1))){
var inst_64807 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_64808 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_64809 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64808,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_64810 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_64811 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_64812 = cljs.core.PersistentHashMap.EMPTY;
var inst_64813 = inst_64807;
var inst_64814 = inst_64809;
var inst_64815 = inst_64810;
var inst_64816 = inst_64811;
var inst_64817 = inst_64812;
var state_64839__$1 = (function (){var statearr_64900 = state_64839;
(statearr_64900[(7)] = inst_64814);

(statearr_64900[(8)] = inst_64816);

(statearr_64900[(9)] = inst_64815);

(statearr_64900[(10)] = inst_64817);

(statearr_64900[(11)] = inst_64813);

return statearr_64900;
})();
var statearr_64901_64948 = state_64839__$1;
(statearr_64901_64948[(2)] = null);

(statearr_64901_64948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64840 === (2))){
var inst_64814 = (state_64839[(7)]);
var inst_64819 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_64814);
var inst_64820 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_64819], 0));
var inst_64821 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64814,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64820);
var inst_64822 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_64821,db_fn);
var state_64839__$1 = state_64839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64839__$1,(4),inst_64822);
} else {
if((state_val_64840 === (3))){
var inst_64837 = (state_64839[(2)]);
var state_64839__$1 = state_64839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64839__$1,inst_64837);
} else {
if((state_val_64840 === (4))){
var inst_64815 = (state_64839[(9)]);
var inst_64817 = (state_64839[(10)]);
var inst_64813 = (state_64839[(11)]);
var inst_64824 = (state_64839[(2)]);
var inst_64825 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64817,inst_64813,inst_64824);
var inst_64826 = cljs.core.first(inst_64815);
var state_64839__$1 = (function (){var statearr_64902 = state_64839;
(statearr_64902[(12)] = inst_64825);

return statearr_64902;
})();
if(cljs.core.truth_(inst_64826)){
var statearr_64903_64949 = state_64839__$1;
(statearr_64903_64949[(1)] = (5));

} else {
var statearr_64904_64950 = state_64839__$1;
(statearr_64904_64950[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64840 === (5))){
var inst_64825 = (state_64839[(12)]);
var inst_64816 = (state_64839[(8)]);
var inst_64815 = (state_64839[(9)]);
var inst_64828 = cljs.core.first(inst_64815);
var inst_64829 = cljs.core.first(inst_64816);
var inst_64830 = cljs.core.rest(inst_64815);
var inst_64831 = cljs.core.rest(inst_64816);
var inst_64813 = inst_64828;
var inst_64814 = inst_64829;
var inst_64815__$1 = inst_64830;
var inst_64816__$1 = inst_64831;
var inst_64817 = inst_64825;
var state_64839__$1 = (function (){var statearr_64905 = state_64839;
(statearr_64905[(7)] = inst_64814);

(statearr_64905[(8)] = inst_64816__$1);

(statearr_64905[(9)] = inst_64815__$1);

(statearr_64905[(10)] = inst_64817);

(statearr_64905[(11)] = inst_64813);

return statearr_64905;
})();
var statearr_64906_64951 = state_64839__$1;
(statearr_64906_64951[(2)] = null);

(statearr_64906_64951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64840 === (6))){
var inst_64825 = (state_64839[(12)]);
var state_64839__$1 = state_64839;
var statearr_64907_64952 = state_64839__$1;
(statearr_64907_64952[(2)] = inst_64825);

(statearr_64907_64952[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64840 === (7))){
var inst_64835 = (state_64839[(2)]);
var state_64839__$1 = state_64839;
var statearr_64908_64953 = state_64839__$1;
(statearr_64908_64953[(2)] = inst_64835);

(statearr_64908_64953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64909 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64909[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64909[(1)] = (1));

return statearr_64909;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64839){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64839);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64910){var ex__2730__auto__ = e64910;
var statearr_64911_64954 = state_64839;
(statearr_64911_64954[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64839[(4)]))){
var statearr_64912_64955 = state_64839;
(statearr_64912_64955[(1)] = cljs.core.first((state_64839[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64956 = state_64839;
state_64839 = G__64956;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64839){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64913 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64913[(6)] = c__2749__auto____$1);

return statearr_64913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_64843 = cljs.core.async.impl.dispatch.run(inst_64842);
var state_64895__$1 = (function (){var statearr_64914 = state_64895;
(statearr_64914[(11)] = inst_64843);

return statearr_64914;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64895__$1,(2),inst_64841);
} else {
if((state_val_64896 === (4))){
var inst_64846 = (state_64895[(8)]);
var state_64895__$1 = state_64895;
var statearr_64915_64957 = state_64895__$1;
(statearr_64915_64957[(2)] = inst_64846);

(statearr_64915_64957[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (15))){
var state_64895__$1 = state_64895;
var statearr_64916_64958 = state_64895__$1;
(statearr_64916_64958[(2)] = (400));

(statearr_64916_64958[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (13))){
var state_64895__$1 = state_64895;
var statearr_64917_64959 = state_64895__$1;
(statearr_64917_64959[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (6))){
var inst_64852 = (state_64895[(10)]);
var inst_64860 = cljs.core.first(inst_64852);
var state_64895__$1 = state_64895;
var statearr_64919_64960 = state_64895__$1;
(statearr_64919_64960[(2)] = inst_64860);

(statearr_64919_64960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (17))){
var inst_64873 = (state_64895[(2)]);
var state_64895__$1 = state_64895;
var statearr_64920_64961 = state_64895__$1;
(statearr_64920_64961[(2)] = inst_64873);

(statearr_64920_64961[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (3))){
var inst_64849 = (state_64895[(7)]);
var inst_64846 = (state_64895[(8)]);
var inst_64856 = (state_64895[(9)]);
var inst_64852 = (state_64895[(10)]);
var inst_64851 = cljs.core.vals(inst_64846);
var inst_64852__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_64851);
var inst_64853 = (function (){var responses = inst_64846;
var responses_STAR_ = inst_64849;
var statuses = inst_64852__$1;
return (function (p1__64800_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__64800_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_64854 = cljs.core.vals(inst_64846);
var inst_64855 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64853,inst_64854);
var inst_64856__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_64855);
var inst_64857 = (function (){var responses = inst_64846;
var responses_STAR_ = inst_64849;
var statuses = inst_64852__$1;
var fuel = inst_64856__$1;
return (function (p1__64801_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__64801_SHARP_);
});
})();
var inst_64858 = cljs.core.every_QMARK_(inst_64857,inst_64852__$1);
var state_64895__$1 = (function (){var statearr_64921 = state_64895;
(statearr_64921[(9)] = inst_64856__$1);

(statearr_64921[(10)] = inst_64852__$1);

return statearr_64921;
})();
if(inst_64858){
var statearr_64922_64962 = state_64895__$1;
(statearr_64922_64962[(1)] = (6));

} else {
var statearr_64923_64963 = state_64895__$1;
(statearr_64923_64963[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (12))){
var state_64895__$1 = state_64895;
var statearr_64924_64964 = state_64895__$1;
(statearr_64924_64964[(2)] = (500));

(statearr_64924_64964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (2))){
var inst_64846 = (state_64895[(8)]);
var inst_64845 = (state_64895[(2)]);
var inst_64846__$1 = fluree.db.util.async.throw_err(inst_64845);
var inst_64847 = (function (){var responses = inst_64846__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_64848 = cljs.core.PersistentHashMap.EMPTY;
var inst_64849 = cljs.core.reduce_kv(inst_64847,inst_64848,inst_64846__$1);
var state_64895__$1 = (function (){var statearr_64925 = state_64895;
(statearr_64925[(7)] = inst_64849);

(statearr_64925[(8)] = inst_64846__$1);

return statearr_64925;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_64926_64965 = state_64895__$1;
(statearr_64926_64965[(1)] = (3));

} else {
var statearr_64927_64966 = state_64895__$1;
(statearr_64927_64966[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (19))){
var inst_64849 = (state_64895[(7)]);
var inst_64856 = (state_64895[(9)]);
var inst_64879 = (state_64895[(12)]);
var inst_64888 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64849,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64879,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64856], 0));
var state_64895__$1 = state_64895;
var statearr_64928_64967 = state_64895__$1;
(statearr_64928_64967[(2)] = inst_64888);

(statearr_64928_64967[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (11))){
var inst_64877 = (state_64895[(2)]);
var state_64895__$1 = state_64895;
var statearr_64929_64968 = state_64895__$1;
(statearr_64929_64968[(2)] = inst_64877);

(statearr_64929_64968[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (9))){
var state_64895__$1 = state_64895;
var statearr_64930_64969 = state_64895__$1;
(statearr_64930_64969[(2)] = (207));

(statearr_64930_64969[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (5))){
var inst_64893 = (state_64895[(2)]);
var state_64895__$1 = state_64895;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64895__$1,inst_64893);
} else {
if((state_val_64896 === (14))){
var inst_64875 = (state_64895[(2)]);
var state_64895__$1 = state_64895;
var statearr_64931_64970 = state_64895__$1;
(statearr_64931_64970[(2)] = inst_64875);

(statearr_64931_64970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (16))){
var state_64895__$1 = state_64895;
var statearr_64932_64971 = state_64895__$1;
(statearr_64932_64971[(2)] = null);

(statearr_64932_64971[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (10))){
var inst_64849 = (state_64895[(7)]);
var inst_64846 = (state_64895[(8)]);
var inst_64856 = (state_64895[(9)]);
var inst_64852 = (state_64895[(10)]);
var inst_64866 = (function (){var responses = inst_64846;
var responses_STAR_ = inst_64849;
var statuses = inst_64852;
var fuel = inst_64856;
return (function (p1__64803_SHARP_){
return ((499) < p1__64803_SHARP_);
});
})();
var inst_64867 = cljs.core.some(inst_64866,inst_64852);
var state_64895__$1 = state_64895;
if(cljs.core.truth_(inst_64867)){
var statearr_64933_64972 = state_64895__$1;
(statearr_64933_64972[(1)] = (12));

} else {
var statearr_64934_64973 = state_64895__$1;
(statearr_64934_64973[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (18))){
var inst_64884 = (state_64895[(13)]);
var inst_64849 = (state_64895[(7)]);
var inst_64856 = (state_64895[(9)]);
var inst_64879 = (state_64895[(12)]);
var inst_64886 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64849,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64879,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64856,new cljs.core.Keyword(null,"block","block",664686210),inst_64884], 0));
var state_64895__$1 = state_64895;
var statearr_64935_64974 = state_64895__$1;
(statearr_64935_64974[(2)] = inst_64886);

(statearr_64935_64974[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64896 === (8))){
var inst_64884 = (state_64895[(13)]);
var inst_64849 = (state_64895[(7)]);
var inst_64846 = (state_64895[(8)]);
var inst_64856 = (state_64895[(9)]);
var inst_64879 = (state_64895[(12)]);
var inst_64852 = (state_64895[(10)]);
var inst_64879__$1 = (state_64895[(2)]);
var inst_64880 = (function (){var responses = inst_64846;
var responses_STAR_ = inst_64849;
var statuses = inst_64852;
var fuel = inst_64856;
var status = inst_64879__$1;
return (function (p1__64804_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__64804_SHARP_));
});
})();
var inst_64881 = cljs.core.vals(inst_64846);
var inst_64882 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_64880,inst_64881);
var inst_64883 = cljs.core.first(inst_64882);
var inst_64884__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64883);
var state_64895__$1 = (function (){var statearr_64936 = state_64895;
(statearr_64936[(13)] = inst_64884__$1);

(statearr_64936[(12)] = inst_64879__$1);

return statearr_64936;
})();
if(cljs.core.truth_(inst_64884__$1)){
var statearr_64937_64975 = state_64895__$1;
(statearr_64937_64975[(1)] = (18));

} else {
var statearr_64938_64976 = state_64895__$1;
(statearr_64938_64976[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_64939 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64939[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_64939[(1)] = (1));

return statearr_64939;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_64895){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_64895);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e64940){var ex__2730__auto__ = e64940;
var statearr_64941_64977 = state_64895;
(statearr_64941_64977[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_64895[(4)]))){
var statearr_64942_64978 = state_64895;
(statearr_64942_64978[(1)] = cljs.core.first((state_64895[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64979 = state_64895;
state_64895 = G__64979;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_64895){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_64895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_64943 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_64943[(6)] = c__2749__auto__);

return statearr_64943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__64981 = arguments.length;
switch (G__64981) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__64982 = opts;
var map__64982__$1 = cljs.core.__destructure_map(map__64982);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64982__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64982__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64982__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64982__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__64983 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64983,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64983,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e64986){var e = e64986;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__64989 = arguments.length;
switch (G__64989) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65020){
var state_val_65021 = (state_65020[(1)]);
if((state_val_65021 === (7))){
var state_65020__$1 = state_65020;
var statearr_65022_65043 = state_65020__$1;
(statearr_65022_65043[(2)] = opts);

(statearr_65022_65043[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (1))){
var state_65020__$1 = state_65020;
var statearr_65023_65044 = state_65020__$1;
(statearr_65023_65044[(2)] = null);

(statearr_65023_65044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (4))){
var inst_64990 = (state_65020[(2)]);
var inst_64991 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64990], 0));
var inst_64992 = cljs.core.ex_data(inst_64990);
var inst_64993 = cljs.core.ex_message(inst_64990);
var inst_64994 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64992,new cljs.core.Keyword(null,"message","message",-406056002),inst_64993);
var state_65020__$1 = (function (){var statearr_65024 = state_65020;
(statearr_65024[(7)] = inst_64991);

return statearr_65024;
})();
var statearr_65025_65045 = state_65020__$1;
(statearr_65025_65045[(2)] = inst_64994);

(statearr_65025_65045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (6))){
var inst_65004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65005 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65006 = (new cljs.core.PersistentVector(null,1,(5),inst_65004,inst_65005,null));
var inst_65007 = cljs.core.assoc_in(opts,inst_65006,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65020__$1 = state_65020;
var statearr_65026_65046 = state_65020__$1;
(statearr_65026_65046[(2)] = inst_65007);

(statearr_65026_65046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (3))){
var inst_65018 = (state_65020[(2)]);
var state_65020__$1 = state_65020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65020__$1,inst_65018);
} else {
if((state_val_65021 === (2))){
var _ = (function (){var statearr_65028 = state_65020;
(statearr_65028[(4)] = cljs.core.cons((5),(state_65020[(4)])));

return statearr_65028;
})();
var inst_65000 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65001 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65002 = (inst_65001 == null);
var state_65020__$1 = (function (){var statearr_65029 = state_65020;
(statearr_65029[(8)] = inst_65000);

return statearr_65029;
})();
if(cljs.core.truth_(inst_65002)){
var statearr_65030_65047 = state_65020__$1;
(statearr_65030_65047[(1)] = (6));

} else {
var statearr_65031_65048 = state_65020__$1;
(statearr_65031_65048[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (9))){
var inst_65014 = (state_65020[(2)]);
var inst_65015 = fluree.db.util.async.throw_err(inst_65014);
var _ = (function (){var statearr_65032 = state_65020;
(statearr_65032[(4)] = cljs.core.rest((state_65020[(4)])));

return statearr_65032;
})();
var state_65020__$1 = state_65020;
var statearr_65033_65049 = state_65020__$1;
(statearr_65033_65049[(2)] = inst_65015);

(statearr_65033_65049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (5))){
var _ = (function (){var statearr_65034 = state_65020;
(statearr_65034[(4)] = cljs.core.rest((state_65020[(4)])));

return statearr_65034;
})();
var state_65020__$1 = state_65020;
var ex65027 = (state_65020__$1[(2)]);
var statearr_65035_65050 = state_65020__$1;
(statearr_65035_65050[(5)] = ex65027);


var statearr_65036_65051 = state_65020__$1;
(statearr_65036_65051[(1)] = (4));

(statearr_65036_65051[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65021 === (8))){
var inst_65000 = (state_65020[(8)]);
var inst_65010 = (state_65020[(2)]);
var inst_65011 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_65000,inst_65010);
var inst_65012 = fluree.db.operations.command_async(conn,inst_65011);
var state_65020__$1 = state_65020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65020__$1,(9),inst_65012);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2727__auto__ = null;
var fluree$db$api_js$state_machine__2727__auto____0 = (function (){
var statearr_65037 = [null,null,null,null,null,null,null,null,null];
(statearr_65037[(0)] = fluree$db$api_js$state_machine__2727__auto__);

(statearr_65037[(1)] = (1));

return statearr_65037;
});
var fluree$db$api_js$state_machine__2727__auto____1 = (function (state_65020){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65020);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65038){var ex__2730__auto__ = e65038;
var statearr_65039_65052 = state_65020;
(statearr_65039_65052[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65020[(4)]))){
var statearr_65040_65053 = state_65020;
(statearr_65040_65053[(1)] = cljs.core.first((state_65020[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65054 = state_65020;
state_65020 = G__65054;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2727__auto__ = function(state_65020){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2727__auto____1.call(this,state_65020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2727__auto____0;
fluree$db$api_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2727__auto____1;
return fluree$db$api_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65041 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65041[(6)] = c__2749__auto__);

return statearr_65041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

