// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59363 = arguments.length;
switch (G__59363) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___59511 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_59450){
var state_val_59451 = (state_59450[(1)]);
if((state_val_59451 === (7))){
var inst_59381 = (state_59450[(7)]);
var inst_59384 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_59381);
var state_59450__$1 = state_59450;
var statearr_59452_59512 = state_59450__$1;
(statearr_59452_59512[(2)] = inst_59384);

(statearr_59452_59512[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (20))){
var inst_59405 = (state_59450[(8)]);
var inst_59376 = (state_59450[(9)]);
var inst_59409 = fluree.db.auth.roles(inst_59376,inst_59405);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59450__$1,(23),inst_59409);
} else {
if((state_val_59451 === (27))){
var inst_59376 = (state_59450[(9)]);
var inst_59424 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_59425 = fluree.db.time_travel.as_of_block(inst_59376,inst_59424);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59450__$1,(30),inst_59425);
} else {
if((state_val_59451 === (1))){
var state_59450__$1 = state_59450;
var statearr_59453_59513 = state_59450__$1;
(statearr_59453_59513[(2)] = null);

(statearr_59453_59513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (24))){
var inst_59417 = (state_59450[(10)]);
var inst_59376 = (state_59450[(9)]);
var inst_59419 = fluree.db.permissions.permission_map(inst_59376,inst_59417,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_59450__$1 = state_59450;
var statearr_59454_59514 = state_59450__$1;
(statearr_59454_59514[(2)] = inst_59419);

(statearr_59454_59514[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (4))){
var inst_59364 = (state_59450[(2)]);
var inst_59365 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59364);
var inst_59366 = cljs.core.async.close_BANG_(pc);
var state_59450__$1 = (function (){var statearr_59455 = state_59450;
(statearr_59455[(11)] = inst_59365);

return statearr_59455;
})();
var statearr_59456_59515 = state_59450__$1;
(statearr_59456_59515[(2)] = inst_59366);

(statearr_59456_59515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (15))){
var inst_59381 = (state_59450[(7)]);
var inst_59395 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59381)," unknown."].join('');
var inst_59396 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59397 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59398 = cljs.core.PersistentHashMap.fromArrays(inst_59396,inst_59397);
var inst_59399 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59395,inst_59398);
var inst_59400 = (function(){throw inst_59399})();
var state_59450__$1 = state_59450;
var statearr_59457_59516 = state_59450__$1;
(statearr_59457_59516[(2)] = inst_59400);

(statearr_59457_59516[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (21))){
var state_59450__$1 = state_59450;
var statearr_59458_59517 = state_59450__$1;
(statearr_59458_59517[(2)] = null);

(statearr_59458_59517[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (31))){
var inst_59431 = (state_59450[(12)]);
var inst_59381 = (state_59450[(7)]);
var inst_59433 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59431,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59381);
var state_59450__$1 = state_59450;
var statearr_59459_59518 = state_59450__$1;
(statearr_59459_59518[(2)] = inst_59433);

(statearr_59459_59518[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (32))){
var inst_59431 = (state_59450[(12)]);
var state_59450__$1 = state_59450;
var statearr_59460_59519 = state_59450__$1;
(statearr_59460_59519[(2)] = inst_59431);

(statearr_59460_59519[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (33))){
var inst_59417 = (state_59450[(10)]);
var inst_59436 = (state_59450[(2)]);
var state_59450__$1 = (function (){var statearr_59461 = state_59450;
(statearr_59461[(13)] = inst_59436);

return statearr_59461;
})();
if(cljs.core.truth_(inst_59417)){
var statearr_59462_59520 = state_59450__$1;
(statearr_59462_59520[(1)] = (34));

} else {
var statearr_59463_59521 = state_59450__$1;
(statearr_59463_59521[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (13))){
var inst_59392 = (state_59450[(14)]);
var inst_59391 = (state_59450[(2)]);
var inst_59392__$1 = fluree.db.util.async.throw_err(inst_59391);
var state_59450__$1 = (function (){var statearr_59464 = state_59450;
(statearr_59464[(14)] = inst_59392__$1);

return statearr_59464;
})();
if(cljs.core.truth_(inst_59392__$1)){
var statearr_59465_59522 = state_59450__$1;
(statearr_59465_59522[(1)] = (14));

} else {
var statearr_59466_59523 = state_59450__$1;
(statearr_59466_59523[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (22))){
var inst_59415 = (state_59450[(2)]);
var state_59450__$1 = state_59450;
var statearr_59467_59524 = state_59450__$1;
(statearr_59467_59524[(2)] = inst_59415);

(statearr_59467_59524[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (36))){
var inst_59444 = (state_59450[(2)]);
var inst_59445 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_59444);
var _ = (function (){var statearr_59468 = state_59450;
(statearr_59468[(4)] = cljs.core.rest((state_59450[(4)])));

return statearr_59468;
})();
var state_59450__$1 = state_59450;
var statearr_59469_59525 = state_59450__$1;
(statearr_59469_59525[(2)] = inst_59445);

(statearr_59469_59525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (29))){
var inst_59381 = (state_59450[(7)]);
var inst_59431 = (state_59450[(2)]);
var state_59450__$1 = (function (){var statearr_59470 = state_59450;
(statearr_59470[(12)] = inst_59431);

return statearr_59470;
})();
if(cljs.core.truth_(inst_59381)){
var statearr_59471_59526 = state_59450__$1;
(statearr_59471_59526[(1)] = (31));

} else {
var statearr_59472_59527 = state_59450__$1;
(statearr_59472_59527[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (6))){
var inst_59381 = (state_59450[(7)]);
var inst_59375 = (state_59450[(2)]);
var inst_59376 = fluree.db.util.async.throw_err(inst_59375);
var inst_59377 = opts;
var inst_59378 = cljs.core.__destructure_map(inst_59377);
var inst_59379 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59378,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59380 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59378,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59381__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59378,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_59378,new cljs.core.Keyword(null,"block","block",664686210));
var state_59450__$1 = (function (){var statearr_59473 = state_59450;
(statearr_59473[(15)] = inst_59382);

(statearr_59473[(16)] = inst_59380);

(statearr_59473[(9)] = inst_59376);

(statearr_59473[(7)] = inst_59381__$1);

(statearr_59473[(17)] = inst_59379);

return statearr_59473;
})();
if(cljs.core.truth_(inst_59381__$1)){
var statearr_59474_59528 = state_59450__$1;
(statearr_59474_59528[(1)] = (7));

} else {
var statearr_59475_59529 = state_59450__$1;
(statearr_59475_59529[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (28))){
var inst_59376 = (state_59450[(9)]);
var state_59450__$1 = state_59450;
var statearr_59476_59530 = state_59450__$1;
(statearr_59476_59530[(2)] = inst_59376);

(statearr_59476_59530[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (25))){
var state_59450__$1 = state_59450;
var statearr_59477_59531 = state_59450__$1;
(statearr_59477_59531[(2)] = null);

(statearr_59477_59531[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (34))){
var inst_59422 = (state_59450[(18)]);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59450__$1,(37),inst_59422);
} else {
if((state_val_59451 === (17))){
var inst_59379 = (state_59450[(17)]);
var state_59450__$1 = state_59450;
var statearr_59478_59532 = state_59450__$1;
(statearr_59478_59532[(2)] = inst_59379);

(statearr_59478_59532[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (3))){
var inst_59448 = (state_59450[(2)]);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59450__$1,inst_59448);
} else {
if((state_val_59451 === (12))){
var inst_59379 = (state_59450[(17)]);
var inst_59405 = (state_59450[(2)]);
var state_59450__$1 = (function (){var statearr_59479 = state_59450;
(statearr_59479[(8)] = inst_59405);

return statearr_59479;
})();
if(cljs.core.truth_(inst_59379)){
var statearr_59480_59533 = state_59450__$1;
(statearr_59480_59533[(1)] = (17));

} else {
var statearr_59481_59534 = state_59450__$1;
(statearr_59481_59534[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (2))){
var _ = (function (){var statearr_59482 = state_59450;
(statearr_59482[(4)] = cljs.core.cons((5),(state_59450[(4)])));

return statearr_59482;
})();
var inst_59373 = fluree.db.session.db(conn,ledger,null);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59450__$1,(6),inst_59373);
} else {
if((state_val_59451 === (23))){
var inst_59411 = (state_59450[(2)]);
var inst_59412 = fluree.db.util.async.throw_err(inst_59411);
var state_59450__$1 = state_59450;
var statearr_59483_59535 = state_59450__$1;
(statearr_59483_59535[(2)] = inst_59412);

(statearr_59483_59535[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (35))){
var inst_59436 = (state_59450[(13)]);
var state_59450__$1 = state_59450;
var statearr_59484_59536 = state_59450__$1;
(statearr_59484_59536[(2)] = inst_59436);

(statearr_59484_59536[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (19))){
var inst_59417 = (state_59450[(10)]);
var inst_59417__$1 = (state_59450[(2)]);
var state_59450__$1 = (function (){var statearr_59485 = state_59450;
(statearr_59485[(10)] = inst_59417__$1);

return statearr_59485;
})();
if(cljs.core.truth_(inst_59417__$1)){
var statearr_59486_59537 = state_59450__$1;
(statearr_59486_59537[(1)] = (24));

} else {
var statearr_59487_59538 = state_59450__$1;
(statearr_59487_59538[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (11))){
var state_59450__$1 = state_59450;
var statearr_59489_59539 = state_59450__$1;
(statearr_59489_59539[(2)] = null);

(statearr_59489_59539[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (9))){
var inst_59387 = (state_59450[(2)]);
var state_59450__$1 = state_59450;
if(cljs.core.truth_(inst_59387)){
var statearr_59490_59540 = state_59450__$1;
(statearr_59490_59540[(1)] = (10));

} else {
var statearr_59491_59541 = state_59450__$1;
(statearr_59491_59541[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (5))){
var _ = (function (){var statearr_59492 = state_59450;
(statearr_59492[(4)] = cljs.core.rest((state_59450[(4)])));

return statearr_59492;
})();
var state_59450__$1 = state_59450;
var ex59488 = (state_59450__$1[(2)]);
var statearr_59493_59542 = state_59450__$1;
(statearr_59493_59542[(5)] = ex59488);


var statearr_59494_59543 = state_59450__$1;
(statearr_59494_59543[(1)] = (4));

(statearr_59494_59543[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (14))){
var inst_59392 = (state_59450[(14)]);
var state_59450__$1 = state_59450;
var statearr_59495_59544 = state_59450__$1;
(statearr_59495_59544[(2)] = inst_59392);

(statearr_59495_59544[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (26))){
var inst_59382 = (state_59450[(15)]);
var inst_59422 = (state_59450[(2)]);
var state_59450__$1 = (function (){var statearr_59496 = state_59450;
(statearr_59496[(18)] = inst_59422);

return statearr_59496;
})();
if(cljs.core.truth_(inst_59382)){
var statearr_59497_59545 = state_59450__$1;
(statearr_59497_59545[(1)] = (27));

} else {
var statearr_59498_59546 = state_59450__$1;
(statearr_59498_59546[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (16))){
var inst_59402 = (state_59450[(2)]);
var state_59450__$1 = state_59450;
var statearr_59499_59547 = state_59450__$1;
(statearr_59499_59547[(2)] = inst_59402);

(statearr_59499_59547[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (30))){
var inst_59427 = (state_59450[(2)]);
var inst_59428 = fluree.db.util.async.throw_err(inst_59427);
var state_59450__$1 = state_59450;
var statearr_59500_59548 = state_59450__$1;
(statearr_59500_59548[(2)] = inst_59428);

(statearr_59500_59548[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (10))){
var inst_59376 = (state_59450[(9)]);
var inst_59381 = (state_59450[(7)]);
var inst_59389 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_59376,inst_59381);
var state_59450__$1 = state_59450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59450__$1,(13),inst_59389);
} else {
if((state_val_59451 === (18))){
var inst_59405 = (state_59450[(8)]);
var state_59450__$1 = state_59450;
if(cljs.core.truth_(inst_59405)){
var statearr_59501_59549 = state_59450__$1;
(statearr_59501_59549[(1)] = (20));

} else {
var statearr_59502_59550 = state_59450__$1;
(statearr_59502_59550[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (37))){
var inst_59436 = (state_59450[(13)]);
var inst_59439 = (state_59450[(2)]);
var inst_59440 = fluree.db.util.async.throw_err(inst_59439);
var inst_59441 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_59436,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_59440);
var state_59450__$1 = state_59450;
var statearr_59503_59551 = state_59450__$1;
(statearr_59503_59551[(2)] = inst_59441);

(statearr_59503_59551[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59451 === (8))){
var inst_59381 = (state_59450[(7)]);
var state_59450__$1 = state_59450;
var statearr_59504_59552 = state_59450__$1;
(statearr_59504_59552[(2)] = inst_59381);

(statearr_59504_59552[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_59505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59505[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_59505[(1)] = (1));

return statearr_59505;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_59450){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_59450);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e59506){var ex__2730__auto__ = e59506;
var statearr_59507_59553 = state_59450;
(statearr_59507_59553[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_59450[(4)]))){
var statearr_59508_59554 = state_59450;
(statearr_59508_59554[(1)] = cljs.core.first((state_59450[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59555 = state_59450;
state_59450 = G__59555;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_59450){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_59450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_59509 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_59509[(6)] = c__2749__auto___59511);

return statearr_59509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_59696){
var state_val_59697 = (state_59696[(1)]);
if((state_val_59697 === (7))){
var inst_59576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59577 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59578 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59579 = [inst_59577,inst_59578];
var inst_59580 = (new cljs.core.PersistentVector(null,2,(5),inst_59576,inst_59579,null));
var state_59696__$1 = state_59696;
var statearr_59698_59768 = state_59696__$1;
(statearr_59698_59768[(2)] = inst_59580);

(statearr_59698_59768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (20))){
var inst_59606 = (state_59696[(7)]);
var state_59696__$1 = state_59696;
var statearr_59699_59769 = state_59696__$1;
(statearr_59699_59769[(2)] = inst_59606);

(statearr_59699_59769[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (27))){
var state_59696__$1 = state_59696;
var statearr_59700_59770 = state_59696__$1;
(statearr_59700_59770[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (1))){
var state_59696__$1 = state_59696;
var statearr_59702_59771 = state_59696__$1;
(statearr_59702_59771[(2)] = null);

(statearr_59702_59771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (24))){
var inst_59605 = (state_59696[(8)]);
var state_59696__$1 = state_59696;
if(cljs.core.truth_(inst_59605)){
var statearr_59703_59772 = state_59696__$1;
(statearr_59703_59772[(1)] = (26));

} else {
var statearr_59704_59773 = state_59696__$1;
(statearr_59704_59773[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (39))){
var inst_59652 = (state_59696[(9)]);
var inst_59651 = (state_59696[(10)]);
var inst_59677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59678 = [inst_59651,inst_59652];
var inst_59679 = (new cljs.core.PersistentVector(null,2,(5),inst_59677,inst_59678,null));
var state_59696__$1 = state_59696;
var statearr_59705_59774 = state_59696__$1;
(statearr_59705_59774[(2)] = inst_59679);

(statearr_59705_59774[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (4))){
var inst_59556 = (state_59696[(2)]);
var state_59696__$1 = state_59696;
var statearr_59706_59775 = state_59696__$1;
(statearr_59706_59775[(2)] = inst_59556);

(statearr_59706_59775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (15))){
var inst_59585 = (state_59696[(11)]);
var inst_59590 = (state_59696[(12)]);
var inst_59599 = (state_59696[(2)]);
var inst_59600 = [inst_59590,inst_59599];
var inst_59601 = (new cljs.core.PersistentVector(null,2,(5),inst_59585,inst_59600,null));
var state_59696__$1 = state_59696;
var statearr_59707_59776 = state_59696__$1;
(statearr_59707_59776[(2)] = inst_59601);

(statearr_59707_59776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (21))){
var inst_59605 = (state_59696[(8)]);
var state_59696__$1 = state_59696;
var statearr_59708_59777 = state_59696__$1;
(statearr_59708_59777[(2)] = inst_59605);

(statearr_59708_59777[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (31))){
var inst_59646 = (state_59696[(2)]);
var state_59696__$1 = state_59696;
var statearr_59709_59778 = state_59696__$1;
(statearr_59709_59778[(2)] = inst_59646);

(statearr_59709_59778[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (32))){
var inst_59652 = (state_59696[(9)]);
var inst_59655 = cljs.core.pos_int_QMARK_(inst_59652);
var state_59696__$1 = state_59696;
var statearr_59710_59779 = state_59696__$1;
(statearr_59710_59779[(2)] = inst_59655);

(statearr_59710_59779[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (40))){
var inst_59607 = (state_59696[(13)]);
var inst_59683 = (state_59696[(14)]);
var inst_59681 = (state_59696[(2)]);
var inst_59682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59681,(0),null);
var inst_59683__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59681,(1),null);
var inst_59684 = (inst_59683__$1 > inst_59607);
var state_59696__$1 = (function (){var statearr_59711 = state_59696;
(statearr_59711[(15)] = inst_59682);

(statearr_59711[(14)] = inst_59683__$1);

return statearr_59711;
})();
if(cljs.core.truth_(inst_59684)){
var statearr_59712_59780 = state_59696__$1;
(statearr_59712_59780[(1)] = (41));

} else {
var statearr_59713_59781 = state_59696__$1;
(statearr_59713_59781[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (33))){
var inst_59653 = (state_59696[(16)]);
var state_59696__$1 = state_59696;
var statearr_59714_59782 = state_59696__$1;
(statearr_59714_59782[(2)] = inst_59653);

(statearr_59714_59782[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (13))){
var inst_59591 = (state_59696[(17)]);
var inst_59593 = fluree.db.time_travel.block_to_int_format(db,inst_59591);
var state_59696__$1 = state_59696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59696__$1,(16),inst_59593);
} else {
if((state_val_59697 === (22))){
var inst_59624 = (state_59696[(2)]);
var state_59696__$1 = state_59696;
if(cljs.core.truth_(inst_59624)){
var statearr_59715_59783 = state_59696__$1;
(statearr_59715_59783[(1)] = (23));

} else {
var statearr_59716_59784 = state_59696__$1;
(statearr_59716_59784[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (36))){
var state_59696__$1 = state_59696;
var statearr_59717_59785 = state_59696__$1;
(statearr_59717_59785[(2)] = null);

(statearr_59717_59785[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (41))){
var inst_59607 = (state_59696[(13)]);
var state_59696__$1 = state_59696;
var statearr_59718_59786 = state_59696__$1;
(statearr_59718_59786[(2)] = inst_59607);

(statearr_59718_59786[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (43))){
var inst_59682 = (state_59696[(15)]);
var inst_59688 = (state_59696[(2)]);
var inst_59689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59690 = [inst_59682,inst_59688];
var inst_59691 = (new cljs.core.PersistentVector(null,2,(5),inst_59689,inst_59690,null));
var _ = (function (){var statearr_59719 = state_59696;
(statearr_59719[(4)] = cljs.core.rest((state_59696[(4)])));

return statearr_59719;
})();
var state_59696__$1 = state_59696;
var statearr_59720_59787 = state_59696__$1;
(statearr_59720_59787[(2)] = inst_59691);

(statearr_59720_59787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (29))){
var inst_59582 = (state_59696[(18)]);
var inst_59637 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59582], 0));
var inst_59638 = ["Invalid block range provided: ",inst_59637].join('');
var inst_59639 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59640 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59641 = cljs.core.PersistentHashMap.fromArrays(inst_59639,inst_59640);
var inst_59642 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59638,inst_59641);
var inst_59643 = (function(){throw inst_59642})();
var state_59696__$1 = state_59696;
var statearr_59721_59788 = state_59696__$1;
(statearr_59721_59788[(2)] = inst_59643);

(statearr_59721_59788[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (6))){
var inst_59574 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_59696__$1 = state_59696;
var statearr_59722_59789 = state_59696__$1;
(statearr_59722_59789[(2)] = inst_59574);

(statearr_59722_59789[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (28))){
var inst_59648 = (state_59696[(2)]);
var state_59696__$1 = state_59696;
var statearr_59723_59790 = state_59696__$1;
(statearr_59723_59790[(2)] = inst_59648);

(statearr_59723_59790[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (25))){
var inst_59653 = (state_59696[(16)]);
var inst_59651 = (state_59696[(10)]);
var inst_59650 = (state_59696[(2)]);
var inst_59651__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59650,(0),null);
var inst_59652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59650,(1),null);
var inst_59653__$1 = cljs.core.pos_int_QMARK_(inst_59651__$1);
var state_59696__$1 = (function (){var statearr_59724 = state_59696;
(statearr_59724[(16)] = inst_59653__$1);

(statearr_59724[(9)] = inst_59652);

(statearr_59724[(10)] = inst_59651__$1);

return statearr_59724;
})();
if(inst_59653__$1){
var statearr_59725_59791 = state_59696__$1;
(statearr_59725_59791[(1)] = (32));

} else {
var statearr_59726_59792 = state_59696__$1;
(statearr_59726_59792[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (34))){
var inst_59658 = (state_59696[(2)]);
var inst_59659 = cljs.core.not(inst_59658);
var state_59696__$1 = state_59696;
if(inst_59659){
var statearr_59727_59793 = state_59696__$1;
(statearr_59727_59793[(1)] = (35));

} else {
var statearr_59728_59794 = state_59696__$1;
(statearr_59728_59794[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (17))){
var inst_59605 = (state_59696[(8)]);
var inst_59607 = (state_59696[(13)]);
var inst_59610 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59605], 0));
var inst_59611 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59607], 0));
var inst_59612 = ["Start block is out of range for this ledger. Start block provided: ",inst_59610,". Database block: ",inst_59611].join('');
var inst_59613 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59614 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59615 = cljs.core.PersistentHashMap.fromArrays(inst_59613,inst_59614);
var inst_59616 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59612,inst_59615);
var inst_59617 = (function(){throw inst_59616})();
var state_59696__$1 = state_59696;
var statearr_59729_59795 = state_59696__$1;
(statearr_59729_59795[(2)] = inst_59617);

(statearr_59729_59795[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (3))){
var inst_59694 = (state_59696[(2)]);
var state_59696__$1 = state_59696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59696__$1,inst_59694);
} else {
if((state_val_59697 === (12))){
var inst_59582 = (state_59696[(18)]);
var inst_59591 = (state_59696[(17)]);
var inst_59589 = (state_59696[(2)]);
var inst_59590 = fluree.db.util.async.throw_err(inst_59589);
var inst_59591__$1 = cljs.core.second(inst_59582);
var state_59696__$1 = (function (){var statearr_59730 = state_59696;
(statearr_59730[(12)] = inst_59590);

(statearr_59730[(17)] = inst_59591__$1);

return statearr_59730;
})();
if(cljs.core.truth_(inst_59591__$1)){
var statearr_59731_59796 = state_59696__$1;
(statearr_59731_59796[(1)] = (13));

} else {
var statearr_59732_59797 = state_59696__$1;
(statearr_59732_59797[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (2))){
var _ = (function (){var statearr_59733 = state_59696;
(statearr_59733[(4)] = cljs.core.cons((5),(state_59696[(4)])));

return statearr_59733;
})();
var inst_59571 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_59572 = cljs.core.sequential_QMARK_(inst_59571);
var state_59696__$1 = state_59696;
if(inst_59572){
var statearr_59734_59798 = state_59696__$1;
(statearr_59734_59798[(1)] = (6));

} else {
var statearr_59735_59799 = state_59696__$1;
(statearr_59735_59799[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (23))){
var inst_59605 = (state_59696[(8)]);
var inst_59606 = (state_59696[(7)]);
var inst_59626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59627 = [inst_59605,inst_59606];
var inst_59628 = (new cljs.core.PersistentVector(null,2,(5),inst_59626,inst_59627,null));
var state_59696__$1 = state_59696;
var statearr_59736_59800 = state_59696__$1;
(statearr_59736_59800[(2)] = inst_59628);

(statearr_59736_59800[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (35))){
var inst_59582 = (state_59696[(18)]);
var inst_59661 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_59582], 0));
var inst_59662 = ["Invalid block range provided: ",inst_59661].join('');
var inst_59663 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59664 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_59665 = cljs.core.PersistentHashMap.fromArrays(inst_59663,inst_59664);
var inst_59666 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_59662,inst_59665);
var inst_59667 = (function(){throw inst_59666})();
var state_59696__$1 = state_59696;
var statearr_59737_59801 = state_59696__$1;
(statearr_59737_59801[(2)] = inst_59667);

(statearr_59737_59801[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (19))){
var inst_59605 = (state_59696[(8)]);
var inst_59620 = (state_59696[(2)]);
var state_59696__$1 = (function (){var statearr_59738 = state_59696;
(statearr_59738[(19)] = inst_59620);

return statearr_59738;
})();
if(cljs.core.truth_(inst_59605)){
var statearr_59739_59802 = state_59696__$1;
(statearr_59739_59802[(1)] = (20));

} else {
var statearr_59740_59803 = state_59696__$1;
(statearr_59740_59803[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (11))){
var inst_59605 = (state_59696[(8)]);
var inst_59607 = (state_59696[(13)]);
var inst_59604 = (state_59696[(2)]);
var inst_59605__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59604,(0),null);
var inst_59606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59604,(1),null);
var inst_59607__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59608 = (inst_59605__$1 > inst_59607__$1);
var state_59696__$1 = (function (){var statearr_59742 = state_59696;
(statearr_59742[(8)] = inst_59605__$1);

(statearr_59742[(13)] = inst_59607__$1);

(statearr_59742[(7)] = inst_59606);

return statearr_59742;
})();
if(cljs.core.truth_(inst_59608)){
var statearr_59743_59804 = state_59696__$1;
(statearr_59743_59804[(1)] = (17));

} else {
var statearr_59744_59805 = state_59696__$1;
(statearr_59744_59805[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (9))){
var inst_59582 = (state_59696[(18)]);
var inst_59585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59586 = cljs.core.first(inst_59582);
var inst_59587 = fluree.db.time_travel.block_to_int_format(db,inst_59586);
var state_59696__$1 = (function (){var statearr_59745 = state_59696;
(statearr_59745[(11)] = inst_59585);

return statearr_59745;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59696__$1,(12),inst_59587);
} else {
if((state_val_59697 === (5))){
var _ = (function (){var statearr_59746 = state_59696;
(statearr_59746[(4)] = cljs.core.rest((state_59696[(4)])));

return statearr_59746;
})();
var state_59696__$1 = state_59696;
var ex59741 = (state_59696__$1[(2)]);
var statearr_59747_59806 = state_59696__$1;
(statearr_59747_59806[(5)] = ex59741);


if((ex59741 instanceof Error)){
var statearr_59748_59807 = state_59696__$1;
(statearr_59748_59807[(1)] = (4));

(statearr_59748_59807[(5)] = null);

} else {
throw ex59741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (14))){
var state_59696__$1 = state_59696;
var statearr_59749_59808 = state_59696__$1;
(statearr_59749_59808[(2)] = null);

(statearr_59749_59808[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (26))){
var inst_59605 = (state_59696[(8)]);
var inst_59631 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59632 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_59633 = [inst_59605,inst_59632];
var inst_59634 = (new cljs.core.PersistentVector(null,2,(5),inst_59631,inst_59633,null));
var state_59696__$1 = state_59696;
var statearr_59750_59809 = state_59696__$1;
(statearr_59750_59809[(2)] = inst_59634);

(statearr_59750_59809[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (16))){
var inst_59595 = (state_59696[(2)]);
var inst_59596 = fluree.db.util.async.throw_err(inst_59595);
var state_59696__$1 = state_59696;
var statearr_59751_59810 = state_59696__$1;
(statearr_59751_59810[(2)] = inst_59596);

(statearr_59751_59810[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (38))){
var inst_59652 = (state_59696[(9)]);
var inst_59651 = (state_59696[(10)]);
var inst_59673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59674 = [inst_59652,inst_59651];
var inst_59675 = (new cljs.core.PersistentVector(null,2,(5),inst_59673,inst_59674,null));
var state_59696__$1 = state_59696;
var statearr_59752_59811 = state_59696__$1;
(statearr_59752_59811[(2)] = inst_59675);

(statearr_59752_59811[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (30))){
var state_59696__$1 = state_59696;
var statearr_59753_59812 = state_59696__$1;
(statearr_59753_59812[(2)] = null);

(statearr_59753_59812[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (10))){
var inst_59582 = (state_59696[(18)]);
var state_59696__$1 = state_59696;
var statearr_59754_59813 = state_59696__$1;
(statearr_59754_59813[(2)] = inst_59582);

(statearr_59754_59813[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (18))){
var state_59696__$1 = state_59696;
var statearr_59755_59814 = state_59696__$1;
(statearr_59755_59814[(2)] = null);

(statearr_59755_59814[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (42))){
var inst_59683 = (state_59696[(14)]);
var state_59696__$1 = state_59696;
var statearr_59756_59815 = state_59696__$1;
(statearr_59756_59815[(2)] = inst_59683);

(statearr_59756_59815[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (37))){
var inst_59652 = (state_59696[(9)]);
var inst_59651 = (state_59696[(10)]);
var inst_59670 = (state_59696[(2)]);
var inst_59671 = (inst_59652 < inst_59651);
var state_59696__$1 = (function (){var statearr_59757 = state_59696;
(statearr_59757[(20)] = inst_59670);

return statearr_59757;
})();
if(cljs.core.truth_(inst_59671)){
var statearr_59758_59816 = state_59696__$1;
(statearr_59758_59816[(1)] = (38));

} else {
var statearr_59759_59817 = state_59696__$1;
(statearr_59759_59817[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59697 === (8))){
var inst_59582 = (state_59696[(18)]);
var inst_59582__$1 = (state_59696[(2)]);
var inst_59583 = cljs.core.some(cljs.core.string_QMARK_,inst_59582__$1);
var state_59696__$1 = (function (){var statearr_59760 = state_59696;
(statearr_59760[(18)] = inst_59582__$1);

return statearr_59760;
})();
if(cljs.core.truth_(inst_59583)){
var statearr_59761_59818 = state_59696__$1;
(statearr_59761_59818[(1)] = (9));

} else {
var statearr_59762_59819 = state_59696__$1;
(statearr_59762_59819[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_59763 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_59763[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_59763[(1)] = (1));

return statearr_59763;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_59696){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_59696);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e59764){var ex__2730__auto__ = e59764;
var statearr_59765_59820 = state_59696;
(statearr_59765_59820[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_59696[(4)]))){
var statearr_59766_59821 = state_59696;
(statearr_59766_59821[(1)] = cljs.core.first((state_59696[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__59822 = state_59696;
state_59696 = G__59822;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_59696){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_59696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_59767 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_59767[(6)] = c__2749__auto__);

return statearr_59767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_59972){
var state_val_59973 = (state_59972[(1)]);
if((state_val_59973 === (7))){
var inst_59884 = (state_59972[(2)]);
var inst_59885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59884,(0),null);
var inst_59886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_59884,(1),null);
var inst_59894 = cljs.core.vals(inst_59886);
var inst_59895 = cljs.core.seq(inst_59894);
var inst_59896 = cljs.core.first(inst_59895);
var inst_59897 = cljs.core.next(inst_59895);
var inst_59898 = cljs.core.PersistentVector.EMPTY;
var inst_59899 = inst_59894;
var inst_59900 = inst_59898;
var state_59972__$1 = (function (){var statearr_59974 = state_59972;
(statearr_59974[(7)] = inst_59897);

(statearr_59974[(8)] = inst_59896);

(statearr_59974[(9)] = inst_59899);

(statearr_59974[(10)] = inst_59885);

(statearr_59974[(11)] = inst_59900);

return statearr_59974;
})();
var statearr_59975_60028 = state_59972__$1;
(statearr_59975_60028[(2)] = null);

(statearr_59975_60028[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (20))){
var inst_59906 = (state_59972[(12)]);
var inst_59911 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59912 = cljs.core.PersistentHashMap.EMPTY;
var inst_59913 = [true,inst_59912];
var inst_59914 = cljs.core.PersistentHashMap.fromArrays(inst_59911,inst_59913);
var inst_59915 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59914,inst_59906);
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59972__$1,(22),inst_59915);
} else {
if((state_val_59973 === (27))){
var inst_59960 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_59976_60029 = state_59972__$1;
(statearr_59976_60029[(2)] = inst_59960);

(statearr_59976_60029[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (1))){
var state_59972__$1 = state_59972;
var statearr_59977_60030 = state_59972__$1;
(statearr_59977_60030[(2)] = null);

(statearr_59977_60030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (24))){
var inst_59924 = (state_59972[(13)]);
var inst_59962 = (state_59972[(2)]);
var inst_59963 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_59964 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59965 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59966 = [inst_59964,inst_59965,inst_59924,inst_59962];
var inst_59967 = cljs.core.PersistentHashMap.fromArrays(inst_59963,inst_59966);
var _ = (function (){var statearr_59979 = state_59972;
(statearr_59979[(4)] = cljs.core.rest((state_59972[(4)])));

return statearr_59979;
})();
var state_59972__$1 = state_59972;
var statearr_59980_60031 = state_59972__$1;
(statearr_59980_60031[(2)] = inst_59967);

(statearr_59980_60031[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (4))){
var inst_59825 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_59981_60032 = state_59972__$1;
(statearr_59981_60032[(2)] = inst_59825);

(statearr_59981_60032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (15))){
var inst_59856 = (state_59972[(14)]);
var inst_59841 = (state_59972[(15)]);
var inst_59849 = (state_59972[(16)]);
var inst_59847 = (state_59972[(17)]);
var inst_59848 = (state_59972[(18)]);
var inst_59870 = (state_59972[(19)]);
var inst_59863 = (state_59972[(20)]);
var inst_59865 = (state_59972[(21)]);
var inst_59843 = (state_59972[(22)]);
var inst_59855 = (state_59972[(23)]);
var inst_59844 = (state_59972[(24)]);
var inst_59876 = (function (){var subject = inst_59863;
var vec__59851 = inst_59847;
var flake = inst_59855;
var r = inst_59856;
var asserted_subjects = inst_59848;
var flake_SINGLEQUOTE_ = inst_59870;
var retracted_subjects = inst_59849;
var seq__59852 = inst_59856;
var vec__59838 = inst_59841;
var asserted_QMARK_ = inst_59865;
var first__59853 = inst_59855;
var G__59837 = inst_59847;
var seq__59839 = inst_59844;
var first__59840 = inst_59843;
return (function (p1__59824_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59824_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59877 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59849,inst_59863,inst_59876);
var tmp59978 = inst_59848;
var inst_59847__$1 = inst_59856;
var inst_59848__$1 = tmp59978;
var inst_59849__$1 = inst_59877;
var state_59972__$1 = (function (){var statearr_59982 = state_59972;
(statearr_59982[(16)] = inst_59849__$1);

(statearr_59982[(17)] = inst_59847__$1);

(statearr_59982[(18)] = inst_59848__$1);

return statearr_59982;
})();
var statearr_59983_60033 = state_59972__$1;
(statearr_59983_60033[(2)] = null);

(statearr_59983_60033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (21))){
var inst_59922 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_59984_60034 = state_59972__$1;
(statearr_59984_60034[(2)] = inst_59922);

(statearr_59984_60034[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (13))){
var inst_59865 = (state_59972[(21)]);
var inst_59870 = (state_59972[(2)]);
var state_59972__$1 = (function (){var statearr_59985 = state_59972;
(statearr_59985[(19)] = inst_59870);

return statearr_59985;
})();
if(cljs.core.truth_(inst_59865)){
var statearr_59986_60035 = state_59972__$1;
(statearr_59986_60035[(1)] = (14));

} else {
var statearr_59987_60036 = state_59972__$1;
(statearr_59987_60036[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (22))){
var inst_59907 = (state_59972[(25)]);
var inst_59900 = (state_59972[(11)]);
var inst_59917 = (state_59972[(2)]);
var inst_59918 = fluree.db.util.async.throw_err(inst_59917);
var inst_59919 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59900,inst_59918);
var inst_59899 = inst_59907;
var inst_59900__$1 = inst_59919;
var state_59972__$1 = (function (){var statearr_59988 = state_59972;
(statearr_59988[(9)] = inst_59899);

(statearr_59988[(11)] = inst_59900__$1);

return statearr_59988;
})();
var statearr_59989_60037 = state_59972__$1;
(statearr_59989_60037[(2)] = null);

(statearr_59989_60037[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (6))){
var inst_59847 = (state_59972[(17)]);
var inst_59855 = (state_59972[(23)]);
var inst_59854 = cljs.core.seq(inst_59847);
var inst_59855__$1 = cljs.core.first(inst_59854);
var inst_59856 = cljs.core.next(inst_59854);
var inst_59857 = cljs.core.not(inst_59855__$1);
var state_59972__$1 = (function (){var statearr_59990 = state_59972;
(statearr_59990[(14)] = inst_59856);

(statearr_59990[(23)] = inst_59855__$1);

return statearr_59990;
})();
if(inst_59857){
var statearr_59991_60038 = state_59972__$1;
(statearr_59991_60038[(1)] = (8));

} else {
var statearr_59992_60039 = state_59972__$1;
(statearr_59992_60039[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (28))){
var inst_59938 = (state_59972[(26)]);
var inst_59945 = (state_59972[(27)]);
var inst_59955 = (state_59972[(2)]);
var inst_59956 = fluree.db.util.async.throw_err(inst_59955);
var inst_59957 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_59938,inst_59956);
var inst_59937 = inst_59945;
var inst_59938__$1 = inst_59957;
var state_59972__$1 = (function (){var statearr_59993 = state_59972;
(statearr_59993[(26)] = inst_59938__$1);

(statearr_59993[(28)] = inst_59937);

return statearr_59993;
})();
var statearr_59994_60040 = state_59972__$1;
(statearr_59994_60040[(2)] = null);

(statearr_59994_60040[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (25))){
var inst_59938 = (state_59972[(26)]);
var state_59972__$1 = state_59972;
var statearr_59995_60041 = state_59972__$1;
(statearr_59995_60041[(2)] = inst_59938);

(statearr_59995_60041[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (17))){
var inst_59899 = (state_59972[(9)]);
var inst_59906 = (state_59972[(12)]);
var inst_59905 = cljs.core.seq(inst_59899);
var inst_59906__$1 = cljs.core.first(inst_59905);
var inst_59907 = cljs.core.next(inst_59905);
var inst_59908 = cljs.core.not(inst_59906__$1);
var state_59972__$1 = (function (){var statearr_59996 = state_59972;
(statearr_59996[(25)] = inst_59907);

(statearr_59996[(12)] = inst_59906__$1);

return statearr_59996;
})();
if(inst_59908){
var statearr_59997_60042 = state_59972__$1;
(statearr_59997_60042[(1)] = (19));

} else {
var statearr_59998_60043 = state_59972__$1;
(statearr_59998_60043[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (3))){
var inst_59970 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59972__$1,inst_59970);
} else {
if((state_val_59973 === (12))){
var inst_59855 = (state_59972[(23)]);
var inst_59868 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_59855);
var state_59972__$1 = state_59972;
var statearr_59999_60044 = state_59972__$1;
(statearr_59999_60044[(2)] = inst_59868);

(statearr_59999_60044[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (2))){
var inst_59841 = (state_59972[(15)]);
var _ = (function (){var statearr_60000 = state_59972;
(statearr_60000[(4)] = cljs.core.cons((5),(state_59972[(4)])));

return statearr_60000;
})();
var inst_59841__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_59842 = cljs.core.seq(inst_59841__$1);
var inst_59843 = cljs.core.first(inst_59842);
var inst_59844 = cljs.core.next(inst_59842);
var inst_59845 = cljs.core.PersistentHashMap.EMPTY;
var inst_59846 = cljs.core.PersistentHashMap.EMPTY;
var inst_59847 = inst_59841__$1;
var inst_59848 = inst_59845;
var inst_59849 = inst_59846;
var state_59972__$1 = (function (){var statearr_60001 = state_59972;
(statearr_60001[(15)] = inst_59841__$1);

(statearr_60001[(16)] = inst_59849);

(statearr_60001[(17)] = inst_59847);

(statearr_60001[(18)] = inst_59848);

(statearr_60001[(22)] = inst_59843);

(statearr_60001[(24)] = inst_59844);

return statearr_60001;
})();
var statearr_60002_60045 = state_59972__$1;
(statearr_60002_60045[(2)] = null);

(statearr_60002_60045[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (23))){
var inst_59937 = (state_59972[(28)]);
var inst_59944 = (state_59972[(29)]);
var inst_59943 = cljs.core.seq(inst_59937);
var inst_59944__$1 = cljs.core.first(inst_59943);
var inst_59945 = cljs.core.next(inst_59943);
var inst_59946 = cljs.core.not(inst_59944__$1);
var state_59972__$1 = (function (){var statearr_60003 = state_59972;
(statearr_60003[(27)] = inst_59945);

(statearr_60003[(29)] = inst_59944__$1);

return statearr_60003;
})();
if(inst_59946){
var statearr_60004_60046 = state_59972__$1;
(statearr_60004_60046[(1)] = (25));

} else {
var statearr_60005_60047 = state_59972__$1;
(statearr_60005_60047[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (19))){
var inst_59900 = (state_59972[(11)]);
var state_59972__$1 = state_59972;
var statearr_60006_60048 = state_59972__$1;
(statearr_60006_60048[(2)] = inst_59900);

(statearr_60006_60048[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (11))){
var inst_59855 = (state_59972[(23)]);
var state_59972__$1 = state_59972;
var statearr_60008_60049 = state_59972__$1;
(statearr_60008_60049[(2)] = inst_59855);

(statearr_60008_60049[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (9))){
var inst_59865 = (state_59972[(21)]);
var inst_59855 = (state_59972[(23)]);
var inst_59863 = inst_59855.s;
var inst_59864 = inst_59855.op;
var inst_59865__$1 = inst_59864 === true;
var state_59972__$1 = (function (){var statearr_60010 = state_59972;
(statearr_60010[(20)] = inst_59863);

(statearr_60010[(21)] = inst_59865__$1);

return statearr_60010;
})();
if(cljs.core.truth_(inst_59865__$1)){
var statearr_60011_60050 = state_59972__$1;
(statearr_60011_60050[(1)] = (11));

} else {
var statearr_60012_60051 = state_59972__$1;
(statearr_60012_60051[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (5))){
var _ = (function (){var statearr_60013 = state_59972;
(statearr_60013[(4)] = cljs.core.rest((state_59972[(4)])));

return statearr_60013;
})();
var state_59972__$1 = state_59972;
var ex60007 = (state_59972__$1[(2)]);
var statearr_60014_60052 = state_59972__$1;
(statearr_60014_60052[(5)] = ex60007);


if((ex60007 instanceof Error)){
var statearr_60015_60053 = state_59972__$1;
(statearr_60015_60053[(1)] = (4));

(statearr_60015_60053[(5)] = null);

} else {
throw ex60007;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (14))){
var inst_59856 = (state_59972[(14)]);
var inst_59841 = (state_59972[(15)]);
var inst_59849 = (state_59972[(16)]);
var inst_59847 = (state_59972[(17)]);
var inst_59848 = (state_59972[(18)]);
var inst_59870 = (state_59972[(19)]);
var inst_59863 = (state_59972[(20)]);
var inst_59865 = (state_59972[(21)]);
var inst_59843 = (state_59972[(22)]);
var inst_59855 = (state_59972[(23)]);
var inst_59844 = (state_59972[(24)]);
var inst_59872 = (function (){var subject = inst_59863;
var vec__59851 = inst_59847;
var flake = inst_59855;
var r = inst_59856;
var asserted_subjects = inst_59848;
var flake_SINGLEQUOTE_ = inst_59870;
var retracted_subjects = inst_59849;
var seq__59852 = inst_59856;
var vec__59838 = inst_59841;
var asserted_QMARK_ = inst_59865;
var first__59853 = inst_59855;
var G__59837 = inst_59847;
var seq__59839 = inst_59844;
var first__59840 = inst_59843;
return (function (p1__59823_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__59823_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_59873 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_59848,inst_59863,inst_59872);
var tmp60009 = inst_59849;
var inst_59847__$1 = inst_59856;
var inst_59848__$1 = inst_59873;
var inst_59849__$1 = tmp60009;
var state_59972__$1 = (function (){var statearr_60016 = state_59972;
(statearr_60016[(16)] = inst_59849__$1);

(statearr_60016[(17)] = inst_59847__$1);

(statearr_60016[(18)] = inst_59848__$1);

return statearr_60016;
})();
var statearr_60017_60054 = state_59972__$1;
(statearr_60017_60054[(2)] = null);

(statearr_60017_60054[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (26))){
var inst_59944 = (state_59972[(29)]);
var inst_59949 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_59950 = cljs.core.PersistentHashMap.EMPTY;
var inst_59951 = [true,inst_59950];
var inst_59952 = cljs.core.PersistentHashMap.fromArrays(inst_59949,inst_59951);
var inst_59953 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_59952,inst_59944);
var state_59972__$1 = state_59972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59972__$1,(28),inst_59953);
} else {
if((state_val_59973 === (16))){
var inst_59880 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_60018_60055 = state_59972__$1;
(statearr_60018_60055[(2)] = inst_59880);

(statearr_60018_60055[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (10))){
var inst_59882 = (state_59972[(2)]);
var state_59972__$1 = state_59972;
var statearr_60019_60056 = state_59972__$1;
(statearr_60019_60056[(2)] = inst_59882);

(statearr_60019_60056[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (18))){
var inst_59885 = (state_59972[(10)]);
var inst_59924 = (state_59972[(2)]);
var inst_59932 = cljs.core.vals(inst_59885);
var inst_59933 = cljs.core.seq(inst_59932);
var inst_59934 = cljs.core.first(inst_59933);
var inst_59935 = cljs.core.next(inst_59933);
var inst_59936 = cljs.core.PersistentVector.EMPTY;
var inst_59937 = inst_59932;
var inst_59938 = inst_59936;
var state_59972__$1 = (function (){var statearr_60020 = state_59972;
(statearr_60020[(26)] = inst_59938);

(statearr_60020[(30)] = inst_59935);

(statearr_60020[(28)] = inst_59937);

(statearr_60020[(31)] = inst_59934);

(statearr_60020[(13)] = inst_59924);

return statearr_60020;
})();
var statearr_60021_60057 = state_59972__$1;
(statearr_60021_60057[(2)] = null);

(statearr_60021_60057[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_59973 === (8))){
var inst_59849 = (state_59972[(16)]);
var inst_59848 = (state_59972[(18)]);
var inst_59859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_59860 = [inst_59848,inst_59849];
var inst_59861 = (new cljs.core.PersistentVector(null,2,(5),inst_59859,inst_59860,null));
var state_59972__$1 = state_59972;
var statearr_60022_60058 = state_59972__$1;
(statearr_60022_60058[(2)] = inst_59861);

(statearr_60022_60058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_60023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60023[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_60023[(1)] = (1));

return statearr_60023;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_59972){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_59972);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60024){var ex__2730__auto__ = e60024;
var statearr_60025_60059 = state_59972;
(statearr_60025_60059[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_59972[(4)]))){
var statearr_60026_60060 = state_59972;
(statearr_60026_60060[(1)] = cljs.core.first((state_59972[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60061 = state_59972;
state_59972 = G__60061;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_59972){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_59972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60027 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60027[(6)] = c__2749__auto__);

return statearr_60027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60093){
var state_val_60094 = (state_60093[(1)]);
if((state_val_60094 === (1))){
var inst_60062 = cljs.core.volatile_BANG_((0));
var inst_60063 = cljs.core.PersistentHashMap.EMPTY;
var inst_60064 = cljs.core.volatile_BANG_(inst_60063);
var inst_60065 = cljs.core.first(resp);
var inst_60066 = cljs.core.rest(resp);
var inst_60067 = cljs.core.PersistentVector.EMPTY;
var inst_60068 = inst_60062;
var inst_60069 = inst_60064;
var inst_60070 = inst_60065;
var inst_60071 = inst_60066;
var inst_60072 = inst_60067;
var state_60093__$1 = (function (){var statearr_60095 = state_60093;
(statearr_60095[(7)] = inst_60072);

(statearr_60095[(8)] = inst_60069);

(statearr_60095[(9)] = inst_60071);

(statearr_60095[(10)] = inst_60068);

(statearr_60095[(11)] = inst_60070);

return statearr_60095;
})();
var statearr_60096_60111 = state_60093__$1;
(statearr_60096_60111[(2)] = null);

(statearr_60096_60111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60094 === (2))){
var inst_60069 = (state_60093[(8)]);
var inst_60068 = (state_60093[(10)]);
var inst_60070 = (state_60093[(11)]);
var inst_60074 = fluree.db.api.query.format_block_resp_pretty(db,inst_60070,inst_60069,inst_60068);
var state_60093__$1 = state_60093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60093__$1,(4),inst_60074);
} else {
if((state_val_60094 === (3))){
var inst_60091 = (state_60093[(2)]);
var state_60093__$1 = state_60093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60093__$1,inst_60091);
} else {
if((state_val_60094 === (4))){
var inst_60072 = (state_60093[(7)]);
var inst_60071 = (state_60093[(9)]);
var inst_60076 = (state_60093[(2)]);
var inst_60077 = fluree.db.util.async.throw_err(inst_60076);
var inst_60078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60079 = [inst_60077];
var inst_60080 = (new cljs.core.PersistentVector(null,1,(5),inst_60078,inst_60079,null));
var inst_60081 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_60072,inst_60080);
var inst_60082 = cljs.core.first(inst_60071);
var state_60093__$1 = (function (){var statearr_60099 = state_60093;
(statearr_60099[(12)] = inst_60081);

return statearr_60099;
})();
if(cljs.core.truth_(inst_60082)){
var statearr_60100_60112 = state_60093__$1;
(statearr_60100_60112[(1)] = (5));

} else {
var statearr_60101_60113 = state_60093__$1;
(statearr_60101_60113[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60094 === (5))){
var inst_60069 = (state_60093[(8)]);
var inst_60071 = (state_60093[(9)]);
var inst_60081 = (state_60093[(12)]);
var inst_60068 = (state_60093[(10)]);
var inst_60084 = cljs.core.first(inst_60071);
var inst_60085 = cljs.core.rest(inst_60071);
var tmp60097 = inst_60069;
var tmp60098 = inst_60068;
var inst_60068__$1 = tmp60098;
var inst_60069__$1 = tmp60097;
var inst_60070 = inst_60084;
var inst_60071__$1 = inst_60085;
var inst_60072 = inst_60081;
var state_60093__$1 = (function (){var statearr_60102 = state_60093;
(statearr_60102[(7)] = inst_60072);

(statearr_60102[(8)] = inst_60069__$1);

(statearr_60102[(9)] = inst_60071__$1);

(statearr_60102[(10)] = inst_60068__$1);

(statearr_60102[(11)] = inst_60070);

return statearr_60102;
})();
var statearr_60103_60114 = state_60093__$1;
(statearr_60103_60114[(2)] = null);

(statearr_60103_60114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60094 === (6))){
var inst_60081 = (state_60093[(12)]);
var state_60093__$1 = state_60093;
var statearr_60104_60115 = state_60093__$1;
(statearr_60104_60115[(2)] = inst_60081);

(statearr_60104_60115[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60094 === (7))){
var inst_60089 = (state_60093[(2)]);
var state_60093__$1 = state_60093;
var statearr_60105_60116 = state_60093__$1;
(statearr_60105_60116[(2)] = inst_60089);

(statearr_60105_60116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_60106 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60106[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_60106[(1)] = (1));

return statearr_60106;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_60093){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60093);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60107){var ex__2730__auto__ = e60107;
var statearr_60108_60117 = state_60093;
(statearr_60108_60117[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60093[(4)]))){
var statearr_60109_60118 = state_60093;
(statearr_60109_60118[(1)] = cljs.core.first((state_60093[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60119 = state_60093;
state_60093 = G__60119;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_60093){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_60093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60110 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60110[(6)] = c__2749__auto__);

return statearr_60110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60121 = arguments.length;
switch (G__60121) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60123){
var map__60124 = p__60123;
var map__60124__$1 = cljs.core.__destructure_map(map__60124);
var query = map__60124__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60124__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60209){
var state_val_60210 = (state_60209[(1)]);
if((state_val_60210 === (7))){
var inst_60135 = (state_60209[(7)]);
var inst_60139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60140 = ["_auth/id",inst_60135];
var inst_60141 = (new cljs.core.PersistentVector(null,2,(5),inst_60139,inst_60140,null));
var state_60209__$1 = state_60209;
var statearr_60211_60255 = state_60209__$1;
(statearr_60211_60255[(2)] = inst_60141);

(statearr_60211_60255[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (20))){
var inst_60189 = (state_60209[(2)]);
var inst_60190 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60209__$1 = (function (){var statearr_60212 = state_60209;
(statearr_60212[(8)] = inst_60189);

return statearr_60212;
})();
if(cljs.core.truth_(inst_60190)){
var statearr_60213_60256 = state_60209__$1;
(statearr_60213_60256[(1)] = (22));

} else {
var statearr_60214_60257 = state_60209__$1;
(statearr_60214_60257[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (27))){
var inst_60136 = (state_60209[(9)]);
var inst_60192 = (state_60209[(10)]);
var inst_60198 = (state_60209[(2)]);
var inst_60199 = fluree.db.util.core.response_time_formatted(inst_60136);
var inst_60200 = [(200),inst_60198,(100),inst_60199];
var inst_60201 = cljs.core.PersistentHashMap.fromArrays(inst_60192,inst_60200);
var state_60209__$1 = state_60209;
var statearr_60215_60258 = state_60209__$1;
(statearr_60215_60258[(2)] = inst_60201);

(statearr_60215_60258[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (1))){
var state_60209__$1 = state_60209;
var statearr_60216_60259 = state_60209__$1;
(statearr_60216_60259[(2)] = null);

(statearr_60216_60259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (24))){
var inst_60204 = (state_60209[(2)]);
var _ = (function (){var statearr_60217 = state_60209;
(statearr_60217[(4)] = cljs.core.rest((state_60209[(4)])));

return statearr_60217;
})();
var state_60209__$1 = state_60209;
var statearr_60218_60260 = state_60209__$1;
(statearr_60218_60260[(2)] = inst_60204);

(statearr_60218_60260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (4))){
var inst_60125 = (state_60209[(2)]);
var state_60209__$1 = state_60209;
var statearr_60219_60261 = state_60209__$1;
(statearr_60219_60261[(2)] = inst_60125);

(statearr_60219_60261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (15))){
var inst_60176 = (state_60209[(11)]);
var state_60209__$1 = state_60209;
var statearr_60220_60262 = state_60209__$1;
(statearr_60220_60262[(2)] = inst_60176);

(statearr_60220_60262[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (21))){
var inst_60185 = (state_60209[(2)]);
var inst_60186 = fluree.db.util.async.throw_err(inst_60185);
var state_60209__$1 = state_60209;
var statearr_60221_60263 = state_60209__$1;
(statearr_60221_60263[(2)] = inst_60186);

(statearr_60221_60263[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (13))){
var inst_60134 = (state_60209[(12)]);
var inst_60176 = (state_60209[(11)]);
var inst_60175 = (state_60209[(2)]);
var inst_60176__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60134);
var state_60209__$1 = (function (){var statearr_60222 = state_60209;
(statearr_60222[(11)] = inst_60176__$1);

(statearr_60222[(13)] = inst_60175);

return statearr_60222;
})();
if(cljs.core.truth_(inst_60176__$1)){
var statearr_60223_60264 = state_60209__$1;
(statearr_60223_60264[(1)] = (15));

} else {
var statearr_60224_60265 = state_60209__$1;
(statearr_60224_60265[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (22))){
var inst_60189 = (state_60209[(8)]);
var inst_60192 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60193 = cljs.core.sequential_QMARK_(inst_60189);
var state_60209__$1 = (function (){var statearr_60225 = state_60209;
(statearr_60225[(10)] = inst_60192);

return statearr_60225;
})();
if(inst_60193){
var statearr_60226_60266 = state_60209__$1;
(statearr_60226_60266[(1)] = (25));

} else {
var statearr_60227_60267 = state_60209__$1;
(statearr_60227_60267[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (6))){
var inst_60134 = (state_60209[(12)]);
var inst_60150 = (state_60209[(14)]);
var inst_60149 = (state_60209[(2)]);
var inst_60150__$1 = fluree.db.util.async.throw_err(inst_60149);
var inst_60151 = fluree.db.api.query.resolve_block_range(inst_60150__$1,inst_60134);
var state_60209__$1 = (function (){var statearr_60228 = state_60209;
(statearr_60228[(14)] = inst_60150__$1);

return statearr_60228;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60209__$1,(10),inst_60151);
} else {
if((state_val_60210 === (25))){
var inst_60189 = (state_60209[(8)]);
var inst_60195 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_60189);
var state_60209__$1 = state_60209;
var statearr_60229_60268 = state_60209__$1;
(statearr_60229_60268[(2)] = inst_60195);

(statearr_60229_60268[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (17))){
var inst_60181 = (state_60209[(2)]);
var state_60209__$1 = state_60209;
if(cljs.core.truth_(inst_60181)){
var statearr_60230_60269 = state_60209__$1;
(statearr_60230_60269[(1)] = (18));

} else {
var statearr_60231_60270 = state_60209__$1;
(statearr_60231_60270[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (3))){
var inst_60207 = (state_60209[(2)]);
var state_60209__$1 = state_60209;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60209__$1,inst_60207);
} else {
if((state_val_60210 === (12))){
var inst_60134 = (state_60209[(12)]);
var inst_60167 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60134], 0));
var inst_60168 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60167].join('');
var inst_60169 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60170 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60171 = cljs.core.PersistentHashMap.fromArrays(inst_60169,inst_60170);
var inst_60172 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60168,inst_60171);
var inst_60173 = (function(){throw inst_60172})();
var state_60209__$1 = state_60209;
var statearr_60232_60271 = state_60209__$1;
(statearr_60232_60271[(2)] = inst_60173);

(statearr_60232_60271[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (2))){
var inst_60135 = (state_60209[(7)]);
var _ = (function (){var statearr_60233 = state_60209;
(statearr_60233[(4)] = cljs.core.cons((5),(state_60209[(4)])));

return statearr_60233;
})();
var inst_60134 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60135__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60136 = fluree.db.util.core.current_time_millis();
var inst_60137 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60209__$1 = (function (){var statearr_60234 = state_60209;
(statearr_60234[(9)] = inst_60136);

(statearr_60234[(7)] = inst_60135__$1);

(statearr_60234[(12)] = inst_60134);

(statearr_60234[(15)] = inst_60137);

return statearr_60234;
})();
if(cljs.core.truth_(inst_60135__$1)){
var statearr_60235_60272 = state_60209__$1;
(statearr_60235_60272[(1)] = (7));

} else {
var statearr_60236_60273 = state_60209__$1;
(statearr_60236_60273[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (23))){
var inst_60189 = (state_60209[(8)]);
var state_60209__$1 = state_60209;
var statearr_60237_60274 = state_60209__$1;
(statearr_60237_60274[(2)] = inst_60189);

(statearr_60237_60274[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (19))){
var inst_60175 = (state_60209[(13)]);
var state_60209__$1 = state_60209;
var statearr_60238_60275 = state_60209__$1;
(statearr_60238_60275[(2)] = inst_60175);

(statearr_60238_60275[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (11))){
var inst_60155 = (state_60209[(16)]);
var inst_60156 = (state_60209[(17)]);
var inst_60150 = (state_60209[(14)]);
var inst_60162 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_60150,inst_60155,inst_60156,opts);
var state_60209__$1 = state_60209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60209__$1,(14),inst_60162);
} else {
if((state_val_60210 === (9))){
var inst_60137 = (state_60209[(15)]);
var inst_60144 = (state_60209[(2)]);
var inst_60145 = [inst_60144];
var inst_60146 = cljs.core.PersistentHashMap.fromArrays(inst_60137,inst_60145);
var inst_60147 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_60146);
var state_60209__$1 = state_60209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60209__$1,(6),inst_60147);
} else {
if((state_val_60210 === (5))){
var _ = (function (){var statearr_60240 = state_60209;
(statearr_60240[(4)] = cljs.core.rest((state_60209[(4)])));

return statearr_60240;
})();
var state_60209__$1 = state_60209;
var ex60239 = (state_60209__$1[(2)]);
var statearr_60241_60276 = state_60209__$1;
(statearr_60241_60276[(5)] = ex60239);


if((ex60239 instanceof Error)){
var statearr_60242_60277 = state_60209__$1;
(statearr_60242_60277[(1)] = (4));

(statearr_60242_60277[(5)] = null);

} else {
throw ex60239;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (14))){
var inst_60164 = (state_60209[(2)]);
var inst_60165 = fluree.db.util.async.throw_err(inst_60164);
var state_60209__$1 = state_60209;
var statearr_60243_60278 = state_60209__$1;
(statearr_60243_60278[(2)] = inst_60165);

(statearr_60243_60278[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (26))){
var inst_60189 = (state_60209[(8)]);
var state_60209__$1 = state_60209;
var statearr_60244_60279 = state_60209__$1;
(statearr_60244_60279[(2)] = inst_60189);

(statearr_60244_60279[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (16))){
var inst_60134 = (state_60209[(12)]);
var inst_60179 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60134);
var state_60209__$1 = state_60209;
var statearr_60245_60280 = state_60209__$1;
(statearr_60245_60280[(2)] = inst_60179);

(statearr_60245_60280[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (10))){
var inst_60134 = (state_60209[(12)]);
var inst_60153 = (state_60209[(2)]);
var inst_60154 = fluree.db.util.async.throw_err(inst_60153);
var inst_60155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60154,(0),null);
var inst_60156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60154,(1),null);
var inst_60157 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60158 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_60134,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_60159 = cljs.core.keys(inst_60158);
var inst_60160 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60157,inst_60159);
var state_60209__$1 = (function (){var statearr_60246 = state_60209;
(statearr_60246[(16)] = inst_60155);

(statearr_60246[(17)] = inst_60156);

return statearr_60246;
})();
if(inst_60160){
var statearr_60247_60281 = state_60209__$1;
(statearr_60247_60281[(1)] = (11));

} else {
var statearr_60248_60282 = state_60209__$1;
(statearr_60248_60282[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60210 === (18))){
var inst_60175 = (state_60209[(13)]);
var inst_60150 = (state_60209[(14)]);
var inst_60183 = fluree.db.api.query.format_blocks_resp_pretty(inst_60150,inst_60175);
var state_60209__$1 = state_60209;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60209__$1,(21),inst_60183);
} else {
if((state_val_60210 === (8))){
var state_60209__$1 = state_60209;
var statearr_60249_60283 = state_60209__$1;
(statearr_60249_60283[(2)] = null);

(statearr_60249_60283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_60250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60250[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_60250[(1)] = (1));

return statearr_60250;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_60209){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60209);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60251){var ex__2730__auto__ = e60251;
var statearr_60252_60284 = state_60209;
(statearr_60252_60284[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60209[(4)]))){
var statearr_60253_60285 = state_60209;
(statearr_60253_60285[(1)] = cljs.core.first((state_60209[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60286 = state_60209;
state_60209 = G__60286;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_60209){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_60209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60254 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60254[(6)] = c__2749__auto__);

return statearr_60254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60287 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60287,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60287,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60287,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60287,(3),null);
var vec__60290 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60290,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60290,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60293 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60293,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60293,(1),null);
var or__4253__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___60297 = arguments.length;
var i__4865__auto___60298 = (0);
while(true){
if((i__4865__auto___60298 < len__4864__auto___60297)){
args__4870__auto__.push((arguments[i__4865__auto___60298]));

var G__60299 = (i__4865__auto___60298 + (1));
i__4865__auto___60298 = G__60299;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60296){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq60296));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60495){
var state_val_60496 = (state_60495[(1)]);
if((state_val_60496 === (7))){
var inst_60422 = (state_60495[(7)]);
var inst_60415 = (state_60495[(8)]);
var inst_60421 = cljs.core.seq(inst_60415);
var inst_60422__$1 = cljs.core.first(inst_60421);
var inst_60423 = cljs.core.next(inst_60421);
var state_60495__$1 = (function (){var statearr_60497 = state_60495;
(statearr_60497[(9)] = inst_60423);

(statearr_60497[(7)] = inst_60422__$1);

return statearr_60497;
})();
if(cljs.core.truth_(inst_60422__$1)){
var statearr_60498_60598 = state_60495__$1;
(statearr_60498_60598[(1)] = (9));

} else {
var statearr_60499_60599 = state_60495__$1;
(statearr_60499_60599[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (20))){
var inst_60485 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60500_60600 = state_60495__$1;
(statearr_60500_60600[(2)] = inst_60485);

(statearr_60500_60600[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (27))){
var inst_60443 = (state_60495[(10)]);
var inst_60461 = (state_60495[(11)]);
var inst_60440 = (state_60495[(12)]);
var inst_60463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60464 = [inst_60443,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_60465 = (new cljs.core.PersistentVector(null,2,(5),inst_60463,inst_60464,null));
var inst_60466 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60461,inst_60465,fluree.db.api.query.min_safe,inst_60440);
var state_60495__$1 = state_60495;
var statearr_60501_60601 = state_60495__$1;
(statearr_60501_60601[(2)] = inst_60466);

(statearr_60501_60601[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (1))){
var state_60495__$1 = state_60495;
var statearr_60502_60602 = state_60495__$1;
(statearr_60502_60602[(2)] = null);

(statearr_60502_60602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (24))){
var inst_60443 = (state_60495[(10)]);
var inst_60453 = (state_60495[(13)]);
var inst_60422 = (state_60495[(7)]);
var inst_60455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60456 = [inst_60443,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_60457 = (new cljs.core.PersistentVector(null,2,(5),inst_60455,inst_60456,null));
var inst_60458 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_60453,inst_60457,cljs.core.conj,inst_60422);
var state_60495__$1 = state_60495;
var statearr_60504_60603 = state_60495__$1;
(statearr_60504_60603[(2)] = inst_60458);

(statearr_60504_60603[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (4))){
var inst_60301 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60505_60604 = state_60495__$1;
(statearr_60505_60604[(2)] = inst_60301);

(statearr_60505_60604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (15))){
var inst_60423 = (state_60495[(9)]);
var inst_60416 = (state_60495[(14)]);
var tmp60503 = inst_60416;
var inst_60415 = inst_60423;
var inst_60416__$1 = tmp60503;
var state_60495__$1 = (function (){var statearr_60506 = state_60495;
(statearr_60506[(8)] = inst_60415);

(statearr_60506[(14)] = inst_60416__$1);

return statearr_60506;
})();
var statearr_60507_60605 = state_60495__$1;
(statearr_60507_60605[(2)] = null);

(statearr_60507_60605[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (21))){
var inst_60443 = (state_60495[(10)]);
var inst_60416 = (state_60495[(14)]);
var inst_60447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60448 = [inst_60443,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60449 = (new cljs.core.PersistentVector(null,2,(5),inst_60447,inst_60448,null));
var inst_60450 = cljs.core.assoc_in(inst_60416,inst_60449,inst_60443);
var state_60495__$1 = state_60495;
var statearr_60508_60606 = state_60495__$1;
(statearr_60508_60606[(2)] = inst_60450);

(statearr_60508_60606[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (31))){
var inst_60469 = (state_60495[(15)]);
var state_60495__$1 = state_60495;
var statearr_60509_60607 = state_60495__$1;
(statearr_60509_60607[(2)] = inst_60469);

(statearr_60509_60607[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (32))){
var inst_60423 = (state_60495[(9)]);
var inst_60477 = (state_60495[(2)]);
var inst_60415 = inst_60423;
var inst_60416 = inst_60477;
var state_60495__$1 = (function (){var statearr_60510 = state_60495;
(statearr_60510[(8)] = inst_60415);

(statearr_60510[(14)] = inst_60416);

return statearr_60510;
})();
var statearr_60511_60608 = state_60495__$1;
(statearr_60511_60608[(2)] = null);

(statearr_60511_60608[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (33))){
var inst_60416 = (state_60495[(14)]);
var state_60495__$1 = state_60495;
var statearr_60512_60609 = state_60495__$1;
(statearr_60512_60609[(2)] = inst_60416);

(statearr_60512_60609[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (13))){
var inst_60425 = (state_60495[(16)]);
var state_60495__$1 = state_60495;
var statearr_60513_60610 = state_60495__$1;
(statearr_60513_60610[(2)] = inst_60425);

(statearr_60513_60610[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (22))){
var inst_60416 = (state_60495[(14)]);
var state_60495__$1 = state_60495;
var statearr_60514_60611 = state_60495__$1;
(statearr_60514_60611[(2)] = inst_60416);

(statearr_60514_60611[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (29))){
var inst_60469 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60515 = state_60495;
(statearr_60515[(15)] = inst_60469);

return statearr_60515;
})();
if(cljs.core.truth_(show_auth)){
var statearr_60516_60612 = state_60495__$1;
(statearr_60516_60612[(1)] = (30));

} else {
var statearr_60517_60613 = state_60495__$1;
(statearr_60517_60613[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (6))){
var inst_60401 = (state_60495[(2)]);
var inst_60402 = fluree.db.util.async.throw_err(inst_60401);
var inst_60410 = resp;
var inst_60411 = cljs.core.seq(inst_60410);
var inst_60412 = cljs.core.first(inst_60411);
var inst_60413 = cljs.core.next(inst_60411);
var inst_60414 = cljs.core.PersistentHashMap.EMPTY;
var inst_60415 = inst_60410;
var inst_60416 = inst_60414;
var state_60495__$1 = (function (){var statearr_60518 = state_60495;
(statearr_60518[(17)] = inst_60402);

(statearr_60518[(8)] = inst_60415);

(statearr_60518[(14)] = inst_60416);

(statearr_60518[(18)] = inst_60413);

(statearr_60518[(19)] = inst_60412);

return statearr_60518;
})();
var statearr_60519_60614 = state_60495__$1;
(statearr_60519_60614[(2)] = null);

(statearr_60519_60614[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (28))){
var inst_60461 = (state_60495[(11)]);
var state_60495__$1 = state_60495;
var statearr_60520_60615 = state_60495__$1;
(statearr_60520_60615[(2)] = inst_60461);

(statearr_60520_60615[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (25))){
var inst_60453 = (state_60495[(13)]);
var state_60495__$1 = state_60495;
var statearr_60521_60616 = state_60495__$1;
(statearr_60521_60616[(2)] = inst_60453);

(statearr_60521_60616[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (34))){
var state_60495__$1 = state_60495;
var statearr_60522_60617 = state_60495__$1;
(statearr_60522_60617[(2)] = null);

(statearr_60522_60617[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (17))){
var inst_60487 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60523_60618 = state_60495__$1;
(statearr_60523_60618[(2)] = inst_60487);

(statearr_60523_60618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (3))){
var inst_60493 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60495__$1,inst_60493);
} else {
if((state_val_60496 === (12))){
var inst_60402 = (state_60495[(17)]);
var inst_60422 = (state_60495[(7)]);
var inst_60427 = fluree.db.api.query.auth_match(auth,inst_60402,inst_60422);
var inst_60428 = cljs.core.not(inst_60427);
var state_60495__$1 = state_60495;
var statearr_60524_60619 = state_60495__$1;
(statearr_60524_60619[(2)] = inst_60428);

(statearr_60524_60619[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (2))){
var _ = (function (){var statearr_60525 = state_60495;
(statearr_60525[(4)] = cljs.core.cons((5),(state_60495[(4)])));

return statearr_60525;
})();
var inst_60307 = (function (){return (function (p1__60300_SHARP_){
return p1__60300_SHARP_.t;
});
})();
var inst_60308 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_60307,resp);
var inst_60309 = cljs.core.set(inst_60308);
var inst_60397 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60398 = (function (){var ts = inst_60309;
var c__2749__auto____$1 = inst_60397;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60395){
var state_val_60396 = (state_60395[(1)]);
if((state_val_60396 === (7))){
var inst_60323 = (state_60395[(7)]);
var inst_60341 = (state_60395[(8)]);
var inst_60329 = (state_60395[(9)]);
var inst_60335 = (state_60395[(10)]);
var inst_60334 = (state_60395[(2)]);
var inst_60335__$1 = fluree.db.util.async.throw_err(inst_60334);
var inst_60337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60338 = [inst_60329,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60339 = (new cljs.core.PersistentVector(null,2,(5),inst_60337,inst_60338,null));
var inst_60340 = cljs.core.assoc_in(inst_60323,inst_60339,inst_60335__$1);
var inst_60341__$1 = auth;
var state_60395__$1 = (function (){var statearr_60526 = state_60395;
(statearr_60526[(8)] = inst_60341__$1);

(statearr_60526[(10)] = inst_60335__$1);

(statearr_60526[(11)] = inst_60340);

return statearr_60526;
})();
if(cljs.core.truth_(inst_60341__$1)){
var statearr_60527_60620 = state_60395__$1;
(statearr_60527_60620[(1)] = (8));

} else {
var statearr_60528_60621 = state_60395__$1;
(statearr_60528_60621[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (1))){
var inst_60317 = (state_60395[(12)]);
var inst_60317__$1 = ts;
var inst_60318 = cljs.core.seq(inst_60317__$1);
var inst_60319 = cljs.core.first(inst_60318);
var inst_60320 = cljs.core.next(inst_60318);
var inst_60321 = cljs.core.PersistentHashMap.EMPTY;
var inst_60322 = inst_60317__$1;
var inst_60323 = inst_60321;
var state_60395__$1 = (function (){var statearr_60529 = state_60395;
(statearr_60529[(7)] = inst_60323);

(statearr_60529[(13)] = inst_60322);

(statearr_60529[(14)] = inst_60319);

(statearr_60529[(12)] = inst_60317__$1);

(statearr_60529[(15)] = inst_60320);

return statearr_60529;
})();
var statearr_60530_60622 = state_60395__$1;
(statearr_60530_60622[(2)] = null);

(statearr_60530_60622[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (4))){
var inst_60329 = (state_60395[(9)]);
var inst_60332 = fluree.db.time_travel.non_border_t_to_block(db,inst_60329);
var state_60395__$1 = state_60395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60395__$1,(7),inst_60332);
} else {
if((state_val_60396 === (13))){
var inst_60330 = (state_60395[(16)]);
var inst_60387 = (state_60395[(2)]);
var inst_60322 = inst_60330;
var inst_60323 = inst_60387;
var state_60395__$1 = (function (){var statearr_60531 = state_60395;
(statearr_60531[(7)] = inst_60323);

(statearr_60531[(13)] = inst_60322);

return statearr_60531;
})();
var statearr_60532_60623 = state_60395__$1;
(statearr_60532_60623[(2)] = null);

(statearr_60532_60623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (6))){
var inst_60391 = (state_60395[(2)]);
var state_60395__$1 = state_60395;
var statearr_60533_60624 = state_60395__$1;
(statearr_60533_60624[(2)] = inst_60391);

(statearr_60533_60624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (3))){
var inst_60393 = (state_60395[(2)]);
var state_60395__$1 = state_60395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60395__$1,inst_60393);
} else {
if((state_val_60396 === (12))){
var inst_60340 = (state_60395[(11)]);
var state_60395__$1 = state_60395;
var statearr_60534_60625 = state_60395__$1;
(statearr_60534_60625[(2)] = inst_60340);

(statearr_60534_60625[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (2))){
var inst_60329 = (state_60395[(9)]);
var inst_60322 = (state_60395[(13)]);
var inst_60328 = cljs.core.seq(inst_60322);
var inst_60329__$1 = cljs.core.first(inst_60328);
var inst_60330 = cljs.core.next(inst_60328);
var state_60395__$1 = (function (){var statearr_60535 = state_60395;
(statearr_60535[(9)] = inst_60329__$1);

(statearr_60535[(16)] = inst_60330);

return statearr_60535;
})();
if(cljs.core.truth_(inst_60329__$1)){
var statearr_60536_60626 = state_60395__$1;
(statearr_60536_60626[(1)] = (4));

} else {
var statearr_60537_60627 = state_60395__$1;
(statearr_60537_60627[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (11))){
var inst_60323 = (state_60395[(7)]);
var inst_60329 = (state_60395[(9)]);
var inst_60335 = (state_60395[(10)]);
var inst_60322 = (state_60395[(13)]);
var inst_60330 = (state_60395[(16)]);
var inst_60319 = (state_60395[(14)]);
var inst_60340 = (state_60395[(11)]);
var inst_60317 = (state_60395[(12)]);
var inst_60320 = (state_60395[(15)]);
var inst_60347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60348 = [inst_60329,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60349 = (new cljs.core.PersistentVector(null,2,(5),inst_60347,inst_60348,null));
var inst_60362 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_60363 = (function (){var t = inst_60329;
var c__2749__auto____$2 = inst_60362;
var block = inst_60335;
var r = inst_60330;
var first__60327 = inst_60329;
var G__60336 = inst_60340;
var seq__60315 = inst_60320;
var acc = inst_60323;
var vec__60325 = inst_60322;
var seq__60326 = inst_60330;
var first__60316 = inst_60319;
var G__60313 = inst_60322;
var vec__60314 = inst_60317;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60360){
var state_val_60361 = (state_60360[(1)]);
if((state_val_60361 === (1))){
var state_60360__$1 = state_60360;
var statearr_60538_60628 = state_60360__$1;
(statearr_60538_60628[(2)] = null);

(statearr_60538_60628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60361 === (2))){
var ___$1 = (function (){var statearr_60539 = state_60360;
(statearr_60539[(4)] = cljs.core.cons((5),(state_60360[(4)])));

return statearr_60539;
})();
var ___$2 = (function (){var statearr_60540 = state_60360;
(statearr_60540[(4)] = cljs.core.rest((state_60360[(4)])));

return statearr_60540;
})();
var state_60360__$1 = state_60360;
var statearr_60541_60629 = state_60360__$1;
(statearr_60541_60629[(2)] = db);

(statearr_60541_60629[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60361 === (3))){
var inst_60358 = (state_60360[(2)]);
var state_60360__$1 = state_60360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60360__$1,inst_60358);
} else {
if((state_val_60361 === (4))){
var inst_60350 = (state_60360[(2)]);
var state_60360__$1 = state_60360;
var statearr_60543_60630 = state_60360__$1;
(statearr_60543_60630[(2)] = inst_60350);

(statearr_60543_60630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60361 === (5))){
var ___$1 = (function (){var statearr_60544 = state_60360;
(statearr_60544[(4)] = cljs.core.rest((state_60360[(4)])));

return statearr_60544;
})();
var state_60360__$1 = state_60360;
var ex60542 = (state_60360__$1[(2)]);
var statearr_60545_60631 = state_60360__$1;
(statearr_60545_60631[(5)] = ex60542);


if((ex60542 instanceof Error)){
var statearr_60546_60632 = state_60360__$1;
(statearr_60546_60632[(1)] = (4));

(statearr_60546_60632[(5)] = null);

} else {
throw ex60542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_60547 = [null,null,null,null,null,null,null];
(statearr_60547[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_60547[(1)] = (1));

return statearr_60547;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_60360){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60360);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60548){var ex__2730__auto__ = e60548;
var statearr_60549_60633 = state_60360;
(statearr_60549_60633[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60360[(4)]))){
var statearr_60550_60634 = state_60360;
(statearr_60550_60634[(1)] = cljs.core.first((state_60360[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60635 = state_60360;
state_60360 = G__60635;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_60360){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_60360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60551 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60551[(6)] = c__2749__auto____$2);

return statearr_60551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_60364 = cljs.core.async.impl.dispatch.run(inst_60363);
var inst_60365 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60367 = ["?auth","?id"];
var inst_60368 = (new cljs.core.PersistentVector(null,2,(5),inst_60366,inst_60367,null));
var inst_60369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60371 = [inst_60329,"_tx/auth","?auth"];
var inst_60372 = (new cljs.core.PersistentVector(null,3,(5),inst_60370,inst_60371,null));
var inst_60373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60374 = ["?auth","_auth/id","?id"];
var inst_60375 = (new cljs.core.PersistentVector(null,3,(5),inst_60373,inst_60374,null));
var inst_60376 = [inst_60372,inst_60375];
var inst_60377 = (new cljs.core.PersistentVector(null,2,(5),inst_60369,inst_60376,null));
var inst_60378 = [inst_60368,inst_60377];
var inst_60379 = cljs.core.PersistentHashMap.fromArrays(inst_60365,inst_60378);
var inst_60380 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_60362,inst_60379) : fluree.db.api.query.query_async.call(null,inst_60362,inst_60379));
var state_60395__$1 = (function (){var statearr_60552 = state_60395;
(statearr_60552[(17)] = inst_60364);

(statearr_60552[(18)] = inst_60349);

return statearr_60552;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60395__$1,(14),inst_60380);
} else {
if((state_val_60396 === (9))){
var state_60395__$1 = state_60395;
var statearr_60553_60636 = state_60395__$1;
(statearr_60553_60636[(2)] = show_auth);

(statearr_60553_60636[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (5))){
var inst_60323 = (state_60395[(7)]);
var state_60395__$1 = state_60395;
var statearr_60554_60637 = state_60395__$1;
(statearr_60554_60637[(2)] = inst_60323);

(statearr_60554_60637[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (14))){
var inst_60349 = (state_60395[(18)]);
var inst_60340 = (state_60395[(11)]);
var inst_60382 = (state_60395[(2)]);
var inst_60383 = fluree.db.util.async.throw_err(inst_60382);
var inst_60384 = cljs.core.assoc_in(inst_60340,inst_60349,inst_60383);
var state_60395__$1 = state_60395;
var statearr_60555_60638 = state_60395__$1;
(statearr_60555_60638[(2)] = inst_60384);

(statearr_60555_60638[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (10))){
var inst_60345 = (state_60395[(2)]);
var state_60395__$1 = state_60395;
if(cljs.core.truth_(inst_60345)){
var statearr_60556_60639 = state_60395__$1;
(statearr_60556_60639[(1)] = (11));

} else {
var statearr_60557_60640 = state_60395__$1;
(statearr_60557_60640[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60396 === (8))){
var inst_60341 = (state_60395[(8)]);
var state_60395__$1 = state_60395;
var statearr_60558_60641 = state_60395__$1;
(statearr_60558_60641[(2)] = inst_60341);

(statearr_60558_60641[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_60559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60559[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_60559[(1)] = (1));

return statearr_60559;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_60395){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60395);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60560){var ex__2730__auto__ = e60560;
var statearr_60561_60642 = state_60395;
(statearr_60561_60642[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60395[(4)]))){
var statearr_60562_60643 = state_60395;
(statearr_60562_60643[(1)] = cljs.core.first((state_60395[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60644 = state_60395;
state_60395 = G__60644;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_60395){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_60395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60563 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60563[(6)] = c__2749__auto____$1);

return statearr_60563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_60399 = cljs.core.async.impl.dispatch.run(inst_60398);
var state_60495__$1 = (function (){var statearr_60564 = state_60495;
(statearr_60564[(20)] = inst_60399);

return statearr_60564;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60495__$1,(6),inst_60397);
} else {
if((state_val_60496 === (23))){
var inst_60453 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60565 = state_60495;
(statearr_60565[(13)] = inst_60453);

return statearr_60565;
})();
var statearr_60566_60645 = state_60495__$1;
(statearr_60566_60645[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (35))){
var inst_60483 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60568_60646 = state_60495__$1;
(statearr_60568_60646[(2)] = inst_60483);

(statearr_60568_60646[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (19))){
var state_60495__$1 = state_60495;
var statearr_60569_60647 = state_60495__$1;
(statearr_60569_60647[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (11))){
var inst_60434 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
if(cljs.core.truth_(inst_60434)){
var statearr_60572_60648 = state_60495__$1;
(statearr_60572_60648[(1)] = (15));

} else {
var statearr_60573_60649 = state_60495__$1;
(statearr_60573_60649[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (9))){
var inst_60425 = (state_60495[(16)]);
var inst_60425__$1 = auth;
var state_60495__$1 = (function (){var statearr_60574 = state_60495;
(statearr_60574[(16)] = inst_60425__$1);

return statearr_60574;
})();
if(cljs.core.truth_(inst_60425__$1)){
var statearr_60575_60650 = state_60495__$1;
(statearr_60575_60650[(1)] = (12));

} else {
var statearr_60576_60651 = state_60495__$1;
(statearr_60576_60651[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (5))){
var _ = (function (){var statearr_60577 = state_60495;
(statearr_60577[(4)] = cljs.core.rest((state_60495[(4)])));

return statearr_60577;
})();
var state_60495__$1 = state_60495;
var ex60571 = (state_60495__$1[(2)]);
var statearr_60578_60652 = state_60495__$1;
(statearr_60578_60652[(5)] = ex60571);


if((ex60571 instanceof Error)){
var statearr_60579_60653 = state_60495__$1;
(statearr_60579_60653[(1)] = (4));

(statearr_60579_60653[(5)] = null);

} else {
throw ex60571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (14))){
var inst_60431 = (state_60495[(2)]);
var state_60495__$1 = state_60495;
var statearr_60580_60654 = state_60495__$1;
(statearr_60580_60654[(2)] = inst_60431);

(statearr_60580_60654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (26))){
var inst_60461 = (state_60495[(2)]);
var state_60495__$1 = (function (){var statearr_60581 = state_60495;
(statearr_60581[(11)] = inst_60461);

return statearr_60581;
})();
var statearr_60582_60655 = state_60495__$1;
(statearr_60582_60655[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (16))){
var inst_60422 = (state_60495[(7)]);
var state_60495__$1 = state_60495;
if(cljs.core.truth_(inst_60422)){
var statearr_60584_60656 = state_60495__$1;
(statearr_60584_60656[(1)] = (18));

} else {
var statearr_60585_60657 = state_60495__$1;
(statearr_60585_60657[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (30))){
var inst_60443 = (state_60495[(10)]);
var inst_60469 = (state_60495[(15)]);
var inst_60444 = (state_60495[(21)]);
var inst_60471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60472 = [inst_60443,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60473 = (new cljs.core.PersistentVector(null,2,(5),inst_60471,inst_60472,null));
var inst_60474 = cljs.core.assoc_in(inst_60469,inst_60473,inst_60444);
var state_60495__$1 = state_60495;
var statearr_60586_60658 = state_60495__$1;
(statearr_60586_60658[(2)] = inst_60474);

(statearr_60586_60658[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (10))){
var inst_60422 = (state_60495[(7)]);
var state_60495__$1 = state_60495;
var statearr_60587_60659 = state_60495__$1;
(statearr_60587_60659[(2)] = inst_60422);

(statearr_60587_60659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (18))){
var inst_60402 = (state_60495[(17)]);
var inst_60422 = (state_60495[(7)]);
var inst_60440 = (state_60495[(12)]);
var inst_60440__$1 = inst_60422.t;
var inst_60441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60402,inst_60440__$1);
var inst_60442 = cljs.core.__destructure_map(inst_60441);
var inst_60443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60442,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60442,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_60495__$1 = (function (){var statearr_60588 = state_60495;
(statearr_60588[(10)] = inst_60443);

(statearr_60588[(21)] = inst_60444);

(statearr_60588[(12)] = inst_60440__$1);

return statearr_60588;
})();
var statearr_60589_60660 = state_60495__$1;
(statearr_60589_60660[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60496 === (8))){
var inst_60489 = (state_60495[(2)]);
var inst_60490 = cljs.core.vals(inst_60489);
var _ = (function (){var statearr_60591 = state_60495;
(statearr_60591[(4)] = cljs.core.rest((state_60495[(4)])));

return statearr_60591;
})();
var state_60495__$1 = state_60495;
var statearr_60592_60661 = state_60495__$1;
(statearr_60592_60661[(2)] = inst_60490);

(statearr_60592_60661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_60593 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60593[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_60593[(1)] = (1));

return statearr_60593;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_60495){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60495);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60594){var ex__2730__auto__ = e60594;
var statearr_60595_60662 = state_60495;
(statearr_60595_60662[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60495[(4)]))){
var statearr_60596_60663 = state_60495;
(statearr_60596_60663[(1)] = cljs.core.first((state_60495[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60664 = state_60495;
state_60495 = G__60664;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_60495){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_60495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60597 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60597[(6)] = c__2749__auto__);

return statearr_60597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_60791){
var state_val_60792 = (state_60791[(1)]);
if((state_val_60792 === (7))){
var inst_60687 = (state_60791[(7)]);
var inst_60689 = fluree.db.api.query.resolve_block_range(inst_60687,query_map);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(10),inst_60689);
} else {
if((state_val_60792 === (20))){
var inst_60716 = (state_60791[(2)]);
var inst_60717 = fluree.db.util.async.throw_err(inst_60716);
var inst_60718 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60717);
var inst_60719 = (inst_60718 - (1));
var state_60791__$1 = state_60791;
var statearr_60793_60856 = state_60791__$1;
(statearr_60793_60856[(2)] = inst_60719);

(statearr_60793_60856[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (27))){
var state_60791__$1 = state_60791;
var statearr_60794_60857 = state_60791__$1;
(statearr_60794_60857[(2)] = null);

(statearr_60794_60857[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (1))){
var state_60791__$1 = state_60791;
var statearr_60795_60858 = state_60791__$1;
(statearr_60795_60858[(2)] = null);

(statearr_60795_60858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (24))){
var inst_60726 = (state_60791[(2)]);
var inst_60727 = fluree.db.util.async.throw_err(inst_60726);
var inst_60728 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60727);
var state_60791__$1 = state_60791;
var statearr_60796_60859 = state_60791__$1;
(statearr_60796_60859[(2)] = inst_60728);

(statearr_60796_60859[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (39))){
var inst_60763 = (state_60791[(2)]);
var inst_60764 = fluree.db.util.async.throw_err(inst_60763);
var state_60791__$1 = state_60791;
var statearr_60797_60860 = state_60791__$1;
(statearr_60797_60860[(2)] = inst_60764);

(statearr_60797_60860[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (4))){
var inst_60665 = (state_60791[(2)]);
var state_60791__$1 = state_60791;
var statearr_60798_60861 = state_60791__$1;
(statearr_60798_60861[(2)] = inst_60665);

(statearr_60798_60861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (15))){
var inst_60696 = (state_60791[(8)]);
var state_60791__$1 = state_60791;
var statearr_60799_60862 = state_60791__$1;
(statearr_60799_60862[(2)] = inst_60696);

(statearr_60799_60862[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (21))){
var inst_60697 = (state_60791[(9)]);
var inst_60687 = (state_60791[(7)]);
var inst_60724 = fluree.db.time_travel.as_of_block(inst_60687,inst_60697);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(24),inst_60724);
} else {
if((state_val_60792 === (31))){
var inst_60681 = (state_60791[(10)]);
var state_60791__$1 = state_60791;
var statearr_60800_60863 = state_60791__$1;
(statearr_60800_60863[(2)] = inst_60681);

(statearr_60800_60863[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (32))){
var inst_60742 = (state_60791[(11)]);
var inst_60747 = (state_60791[(12)]);
var inst_60687 = (state_60791[(7)]);
var inst_60751 = (state_60791[(2)]);
var inst_60752 = fluree.db.api.query.format_history_resp(inst_60687,inst_60742,inst_60747,inst_60751);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(29),inst_60752);
} else {
if((state_val_60792 === (40))){
var inst_60768 = (state_60791[(13)]);
var inst_60742 = (state_60791[(11)]);
var inst_60770 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_60771 = cljs.core.count(inst_60742);
var inst_60772 = [inst_60768,inst_60771,(200)];
var inst_60773 = cljs.core.PersistentHashMap.fromArrays(inst_60770,inst_60772);
var state_60791__$1 = state_60791;
var statearr_60801_60864 = state_60791__$1;
(statearr_60801_60864[(2)] = inst_60773);

(statearr_60801_60864[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (33))){
var inst_60680 = (state_60791[(14)]);
var state_60791__$1 = state_60791;
var statearr_60802_60865 = state_60791__$1;
(statearr_60802_60865[(2)] = inst_60680);

(statearr_60802_60865[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (13))){
var inst_60786 = (state_60791[(2)]);
var _ = (function (){var statearr_60803 = state_60791;
(statearr_60803[(4)] = cljs.core.rest((state_60791[(4)])));

return statearr_60803;
})();
var state_60791__$1 = state_60791;
var statearr_60804_60866 = state_60791__$1;
(statearr_60804_60866[(2)] = inst_60786);

(statearr_60804_60866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (22))){
var inst_60687 = (state_60791[(7)]);
var inst_60730 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_60687);
var state_60791__$1 = state_60791;
var statearr_60805_60867 = state_60791__$1;
(statearr_60805_60867[(2)] = inst_60730);

(statearr_60805_60867[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (36))){
var inst_60687 = (state_60791[(7)]);
var inst_60755 = (state_60791[(15)]);
var inst_60761 = fluree.db.api.query.format_blocks_resp_pretty(inst_60687,inst_60755);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(39),inst_60761);
} else {
if((state_val_60792 === (41))){
var inst_60768 = (state_60791[(13)]);
var state_60791__$1 = state_60791;
var statearr_60806_60868 = state_60791__$1;
(statearr_60806_60868[(2)] = inst_60768);

(statearr_60806_60868[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (29))){
var inst_60680 = (state_60791[(14)]);
var inst_60754 = (state_60791[(2)]);
var inst_60755 = fluree.db.util.async.throw_err(inst_60754);
var state_60791__$1 = (function (){var statearr_60807 = state_60791;
(statearr_60807[(15)] = inst_60755);

return statearr_60807;
})();
if(cljs.core.truth_(inst_60680)){
var statearr_60808_60869 = state_60791__$1;
(statearr_60808_60869[(1)] = (33));

} else {
var statearr_60809_60870 = state_60791__$1;
(statearr_60809_60870[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (6))){
var inst_60677 = (state_60791[(16)]);
var inst_60686 = (state_60791[(2)]);
var inst_60687 = fluree.db.util.async.throw_err(inst_60686);
var state_60791__$1 = (function (){var statearr_60810 = state_60791;
(statearr_60810[(7)] = inst_60687);

return statearr_60810;
})();
if(cljs.core.truth_(inst_60677)){
var statearr_60811_60871 = state_60791__$1;
(statearr_60811_60871[(1)] = (7));

} else {
var statearr_60812_60872 = state_60791__$1;
(statearr_60812_60872[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (28))){
var inst_60682 = (state_60791[(17)]);
var inst_60747 = (state_60791[(2)]);
var state_60791__$1 = (function (){var statearr_60813 = state_60791;
(statearr_60813[(12)] = inst_60747);

return statearr_60813;
})();
if(cljs.core.truth_(inst_60682)){
var statearr_60814_60873 = state_60791__$1;
(statearr_60814_60873[(1)] = (30));

} else {
var statearr_60815_60874 = state_60791__$1;
(statearr_60815_60874[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (25))){
var inst_60683 = (state_60791[(18)]);
var inst_60741 = (state_60791[(2)]);
var inst_60742 = fluree.db.util.async.throw_err(inst_60741);
var state_60791__$1 = (function (){var statearr_60816 = state_60791;
(statearr_60816[(11)] = inst_60742);

return statearr_60816;
})();
if(cljs.core.truth_(inst_60683)){
var statearr_60817_60875 = state_60791__$1;
(statearr_60817_60875[(1)] = (26));

} else {
var statearr_60818_60876 = state_60791__$1;
(statearr_60818_60876[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (34))){
var inst_60679 = (state_60791[(19)]);
var state_60791__$1 = state_60791;
var statearr_60819_60877 = state_60791__$1;
(statearr_60819_60877[(2)] = inst_60679);

(statearr_60819_60877[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (17))){
var inst_60696 = (state_60791[(8)]);
var inst_60687 = (state_60791[(7)]);
var inst_60713 = (inst_60696 - (1));
var inst_60714 = fluree.db.time_travel.as_of_block(inst_60687,inst_60713);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(20),inst_60714);
} else {
if((state_val_60792 === (3))){
var inst_60789 = (state_60791[(2)]);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60791__$1,inst_60789);
} else {
if((state_val_60792 === (12))){
var inst_60778 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_60779 = ["History query not properly formatted. Provided ",inst_60778].join('');
var inst_60780 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60781 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60782 = cljs.core.PersistentHashMap.fromArrays(inst_60780,inst_60781);
var inst_60783 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60779,inst_60782);
var inst_60784 = (function(){throw inst_60783})();
var state_60791__$1 = state_60791;
var statearr_60820_60878 = state_60791__$1;
(statearr_60820_60878[(2)] = inst_60784);

(statearr_60820_60878[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (2))){
var _ = (function (){var statearr_60821 = state_60791;
(statearr_60821[(4)] = cljs.core.cons((5),(state_60791[(4)])));

return statearr_60821;
})();
var inst_60675 = query_map;
var inst_60676 = cljs.core.__destructure_map(inst_60675);
var inst_60677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_60680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_60682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_60683 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60676,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_60791__$1 = (function (){var statearr_60822 = state_60791;
(statearr_60822[(19)] = inst_60679);

(statearr_60822[(10)] = inst_60681);

(statearr_60822[(20)] = inst_60684);

(statearr_60822[(17)] = inst_60682);

(statearr_60822[(21)] = inst_60678);

(statearr_60822[(18)] = inst_60683);

(statearr_60822[(16)] = inst_60677);

(statearr_60822[(14)] = inst_60680);

return statearr_60822;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(6),sources);
} else {
if((state_val_60792 === (23))){
var inst_60678 = (state_60791[(21)]);
var inst_60687 = (state_60791[(7)]);
var inst_60722 = (state_60791[(22)]);
var inst_60732 = (state_60791[(2)]);
var inst_60733 = fluree.db.api.query.get_history_pattern(inst_60678);
var inst_60734 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60733,(0),null);
var inst_60735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60733,(1),null);
var inst_60736 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_60737 = [inst_60722,inst_60732];
var inst_60738 = cljs.core.PersistentHashMap.fromArrays(inst_60736,inst_60737);
var inst_60739 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_60687,inst_60735,cljs.core._EQ_,inst_60734,inst_60738);
var state_60791__$1 = state_60791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60791__$1,(25),inst_60739);
} else {
if((state_val_60792 === (35))){
var inst_60759 = (state_60791[(2)]);
var state_60791__$1 = state_60791;
if(cljs.core.truth_(inst_60759)){
var statearr_60823_60879 = state_60791__$1;
(statearr_60823_60879[(1)] = (36));

} else {
var statearr_60824_60880 = state_60791__$1;
(statearr_60824_60880[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (19))){
var inst_60697 = (state_60791[(9)]);
var inst_60722 = (state_60791[(2)]);
var state_60791__$1 = (function (){var statearr_60825 = state_60791;
(statearr_60825[(22)] = inst_60722);

return statearr_60825;
})();
if(cljs.core.truth_(inst_60697)){
var statearr_60826_60881 = state_60791__$1;
(statearr_60826_60881[(1)] = (21));

} else {
var statearr_60827_60882 = state_60791__$1;
(statearr_60827_60882[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (11))){
var inst_60684 = (state_60791[(20)]);
var inst_60696 = (state_60791[(8)]);
var inst_60706 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60684);
var state_60791__$1 = (function (){var statearr_60829 = state_60791;
(statearr_60829[(23)] = inst_60706);

return statearr_60829;
})();
if(cljs.core.truth_(inst_60696)){
var statearr_60830_60883 = state_60791__$1;
(statearr_60830_60883[(1)] = (14));

} else {
var statearr_60831_60884 = state_60791__$1;
(statearr_60831_60884[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (9))){
var inst_60695 = (state_60791[(2)]);
var inst_60696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60695,(0),null);
var inst_60697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60695,(1),null);
var inst_60698 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_60699 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_60700 = cljs.core.keys(inst_60699);
var inst_60701 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_60698,inst_60700);
var state_60791__$1 = (function (){var statearr_60832 = state_60791;
(statearr_60832[(8)] = inst_60696);

(statearr_60832[(9)] = inst_60697);

return statearr_60832;
})();
if(inst_60701){
var statearr_60833_60885 = state_60791__$1;
(statearr_60833_60885[(1)] = (11));

} else {
var statearr_60834_60886 = state_60791__$1;
(statearr_60834_60886[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (5))){
var _ = (function (){var statearr_60835 = state_60791;
(statearr_60835[(4)] = cljs.core.rest((state_60791[(4)])));

return statearr_60835;
})();
var state_60791__$1 = state_60791;
var ex60828 = (state_60791__$1[(2)]);
var statearr_60836_60887 = state_60791__$1;
(statearr_60836_60887[(5)] = ex60828);


if((ex60828 instanceof Error)){
var statearr_60837_60888 = state_60791__$1;
(statearr_60837_60888[(1)] = (4));

(statearr_60837_60888[(5)] = null);

} else {
throw ex60828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (14))){
var inst_60696 = (state_60791[(8)]);
var inst_60708 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_60696);
var state_60791__$1 = state_60791;
var statearr_60838_60889 = state_60791__$1;
(statearr_60838_60889[(2)] = inst_60708);

(statearr_60838_60889[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (26))){
var inst_60683 = (state_60791[(18)]);
var inst_60744 = cljs.core.set(inst_60683);
var state_60791__$1 = state_60791;
var statearr_60839_60890 = state_60791__$1;
(statearr_60839_60890[(2)] = inst_60744);

(statearr_60839_60890[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (16))){
var inst_60711 = (state_60791[(2)]);
var state_60791__$1 = state_60791;
if(cljs.core.truth_(inst_60711)){
var statearr_60840_60891 = state_60791__$1;
(statearr_60840_60891[(1)] = (17));

} else {
var statearr_60841_60892 = state_60791__$1;
(statearr_60841_60892[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (38))){
var inst_60706 = (state_60791[(23)]);
var inst_60768 = (state_60791[(2)]);
var state_60791__$1 = (function (){var statearr_60842 = state_60791;
(statearr_60842[(13)] = inst_60768);

return statearr_60842;
})();
if(cljs.core.truth_(inst_60706)){
var statearr_60843_60893 = state_60791__$1;
(statearr_60843_60893[(1)] = (40));

} else {
var statearr_60844_60894 = state_60791__$1;
(statearr_60844_60894[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (30))){
var inst_60682 = (state_60791[(17)]);
var state_60791__$1 = state_60791;
var statearr_60845_60895 = state_60791__$1;
(statearr_60845_60895[(2)] = inst_60682);

(statearr_60845_60895[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (10))){
var inst_60691 = (state_60791[(2)]);
var inst_60692 = fluree.db.util.async.throw_err(inst_60691);
var state_60791__$1 = state_60791;
var statearr_60846_60896 = state_60791__$1;
(statearr_60846_60896[(2)] = inst_60692);

(statearr_60846_60896[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (18))){
var state_60791__$1 = state_60791;
var statearr_60847_60897 = state_60791__$1;
(statearr_60847_60897[(2)] = (-1));

(statearr_60847_60897[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (42))){
var inst_60776 = (state_60791[(2)]);
var state_60791__$1 = state_60791;
var statearr_60848_60898 = state_60791__$1;
(statearr_60848_60898[(2)] = inst_60776);

(statearr_60848_60898[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (37))){
var inst_60755 = (state_60791[(15)]);
var inst_60766 = fluree.db.api.query.block_Flakes__GT_vector(inst_60755);
var state_60791__$1 = state_60791;
var statearr_60849_60899 = state_60791__$1;
(statearr_60849_60899[(2)] = inst_60766);

(statearr_60849_60899[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60792 === (8))){
var state_60791__$1 = state_60791;
var statearr_60850_60900 = state_60791__$1;
(statearr_60850_60900[(2)] = null);

(statearr_60850_60900[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_60851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60851[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_60851[(1)] = (1));

return statearr_60851;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_60791){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_60791);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e60852){var ex__2730__auto__ = e60852;
var statearr_60853_60901 = state_60791;
(statearr_60853_60901[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_60791[(4)]))){
var statearr_60854_60902 = state_60791;
(statearr_60854_60902[(1)] = cljs.core.first((state_60791[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60903 = state_60791;
state_60791 = G__60903;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_60791){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_60791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_60855 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_60855[(6)] = c__2749__auto__);

return statearr_60855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61036){
var state_val_61037 = (state_61036[(1)]);
if((state_val_61037 === (7))){
var inst_60933 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_60934 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_60933].join('');
var inst_60935 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60936 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60937 = cljs.core.PersistentHashMap.fromArrays(inst_60935,inst_60936);
var inst_60938 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60934,inst_60937);
var inst_60939 = (function(){throw inst_60938})();
var state_61036__$1 = state_61036;
var statearr_61038_61117 = state_61036__$1;
(statearr_61038_61117[(2)] = inst_60939);

(statearr_61038_61117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (20))){
var inst_60971 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_60971)){
var statearr_61039_61118 = state_61036__$1;
(statearr_61039_61118[(1)] = (21));

} else {
var statearr_61040_61119 = state_61036__$1;
(statearr_61040_61119[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (27))){
var inst_60915 = (state_61036[(7)]);
var state_61036__$1 = state_61036;
var statearr_61041_61120 = state_61036__$1;
(statearr_61041_61120[(2)] = inst_60915);

(statearr_61041_61120[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (1))){
var state_61036__$1 = state_61036;
var statearr_61042_61121 = state_61036__$1;
(statearr_61042_61121[(2)] = null);

(statearr_61042_61121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (24))){
var inst_60977 = (state_61036[(8)]);
var state_61036__$1 = state_61036;
var statearr_61043_61122 = state_61036__$1;
(statearr_61043_61122[(2)] = inst_60977);

(statearr_61043_61122[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (39))){
var inst_60921 = (state_61036[(9)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_60921)){
var statearr_61044_61123 = state_61036__$1;
(statearr_61044_61123[(1)] = (42));

} else {
var statearr_61045_61124 = state_61036__$1;
(statearr_61045_61124[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (46))){
var inst_61009 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61010 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61011 = cljs.core.PersistentHashMap.fromArrays(inst_61009,inst_61010);
var inst_61012 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_61011);
var inst_61013 = (function(){throw inst_61012})();
var state_61036__$1 = state_61036;
var statearr_61046_61125 = state_61036__$1;
(statearr_61046_61125[(2)] = inst_61013);

(statearr_61046_61125[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (4))){
var inst_60905 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
var statearr_61047_61126 = state_61036__$1;
(statearr_61047_61126[(2)] = inst_60905);

(statearr_61047_61126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (15))){
var inst_60956 = (state_61036[(10)]);
var inst_60918 = (state_61036[(11)]);
var inst_60958 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_60956);
var inst_60959 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_60956);
var inst_60960 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_60956);
var inst_60961 = fluree.db.api.query.get_sources(inst_60958,inst_60959,inst_60960,inst_60918);
var state_61036__$1 = state_61036;
var statearr_61048_61127 = state_61036__$1;
(statearr_61048_61127[(2)] = inst_60961);

(statearr_61048_61127[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (48))){
var inst_60966 = (state_61036[(12)]);
var inst_61020 = (state_61036[(2)]);
var inst_61021 = fluree.db.util.async.throw_err(inst_61020);
var state_61036__$1 = (function (){var statearr_61049 = state_61036;
(statearr_61049[(13)] = inst_61021);

return statearr_61049;
})();
if(cljs.core.truth_(inst_60966)){
var statearr_61050_61128 = state_61036__$1;
(statearr_61050_61128[(1)] = (49));

} else {
var statearr_61051_61129 = state_61036__$1;
(statearr_61051_61129[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (50))){
var inst_61021 = (state_61036[(13)]);
var state_61036__$1 = state_61036;
var statearr_61052_61130 = state_61036__$1;
(statearr_61052_61130[(2)] = inst_61021);

(statearr_61052_61130[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (21))){
var inst_60973 = cljs.core.volatile_BANG_((0));
var state_61036__$1 = state_61036;
var statearr_61053_61131 = state_61036__$1;
(statearr_61053_61131[(2)] = inst_60973);

(statearr_61053_61131[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (31))){
var inst_60919 = (state_61036[(14)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_60919)){
var statearr_61054_61132 = state_61036__$1;
(statearr_61054_61132[(1)] = (33));

} else {
var statearr_61055_61133 = state_61036__$1;
(statearr_61055_61133[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (32))){
var inst_60996 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
var statearr_61056_61134 = state_61036__$1;
(statearr_61056_61134[(2)] = inst_60996);

(statearr_61056_61134[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (40))){
var inst_60998 = (state_61036[(15)]);
var state_61036__$1 = state_61036;
var statearr_61057_61135 = state_61036__$1;
(statearr_61057_61135[(2)] = inst_60998);

(statearr_61057_61135[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (33))){
var inst_60919 = (state_61036[(14)]);
var state_61036__$1 = state_61036;
var statearr_61058_61136 = state_61036__$1;
(statearr_61058_61136[(2)] = inst_60919);

(statearr_61058_61136[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (13))){
var inst_60916 = (state_61036[(16)]);
var inst_60945 = (state_61036[(2)]);
var inst_60946 = fluree.db.util.async.throw_err(inst_60945);
var inst_60947 = fluree.db.time_travel.as_of_block(inst_60946,inst_60916);
var state_61036__$1 = state_61036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61036__$1,(12),inst_60947);
} else {
if((state_val_61037 === (22))){
var state_61036__$1 = state_61036;
var statearr_61059_61137 = state_61036__$1;
(statearr_61059_61137[(2)] = null);

(statearr_61059_61137[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (36))){
var inst_60923 = (state_61036[(17)]);
var state_61036__$1 = state_61036;
var statearr_61060_61138 = state_61036__$1;
(statearr_61060_61138[(2)] = inst_60923);

(statearr_61060_61138[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (41))){
var inst_61006 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_61006)){
var statearr_61061_61139 = state_61036__$1;
(statearr_61061_61139[(1)] = (45));

} else {
var statearr_61062_61140 = state_61036__$1;
(statearr_61062_61140[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (43))){
var inst_60917 = (state_61036[(18)]);
var state_61036__$1 = state_61036;
var statearr_61063_61141 = state_61036__$1;
(statearr_61063_61141[(2)] = inst_60917);

(statearr_61063_61141[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (29))){
var inst_60998 = (state_61036[(15)]);
var inst_60998__$1 = (state_61036[(2)]);
var state_61036__$1 = (function (){var statearr_61064 = state_61036;
(statearr_61064[(15)] = inst_60998__$1);

return statearr_61064;
})();
if(cljs.core.truth_(inst_60998__$1)){
var statearr_61065_61142 = state_61036__$1;
(statearr_61065_61142[(1)] = (39));

} else {
var statearr_61066_61143 = state_61036__$1;
(statearr_61066_61143[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (44))){
var inst_61003 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
var statearr_61067_61144 = state_61036__$1;
(statearr_61067_61144[(2)] = inst_61003);

(statearr_61067_61144[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (6))){
var state_61036__$1 = state_61036;
var statearr_61068_61145 = state_61036__$1;
(statearr_61068_61145[(2)] = null);

(statearr_61068_61145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (28))){
var inst_60920 = (state_61036[(19)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_60920)){
var statearr_61069_61146 = state_61036__$1;
(statearr_61069_61146[(1)] = (30));

} else {
var statearr_61070_61147 = state_61036__$1;
(statearr_61070_61147[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (51))){
var inst_61031 = (state_61036[(2)]);
var _ = (function (){var statearr_61071 = state_61036;
(statearr_61071[(4)] = cljs.core.rest((state_61036[(4)])));

return statearr_61071;
})();
var state_61036__$1 = state_61036;
var statearr_61072_61148 = state_61036__$1;
(statearr_61072_61148[(2)] = inst_61031);

(statearr_61072_61148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (25))){
var state_61036__$1 = state_61036;
var statearr_61073_61149 = state_61036__$1;
(statearr_61073_61149[(2)] = (1000000));

(statearr_61073_61149[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (34))){
var inst_60923 = (state_61036[(17)]);
var state_61036__$1 = state_61036;
if(cljs.core.truth_(inst_60923)){
var statearr_61074_61150 = state_61036__$1;
(statearr_61074_61150[(1)] = (36));

} else {
var statearr_61075_61151 = state_61036__$1;
(statearr_61075_61151[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (17))){
var inst_60967 = (state_61036[(20)]);
var inst_60922 = (state_61036[(21)]);
var inst_60965 = (state_61036[(2)]);
var inst_60966 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_60922);
var inst_60967__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60922);
var state_61036__$1 = (function (){var statearr_61076 = state_61036;
(statearr_61076[(20)] = inst_60967__$1);

(statearr_61076[(22)] = inst_60965);

(statearr_61076[(12)] = inst_60966);

return statearr_61076;
})();
if(cljs.core.truth_(inst_60967__$1)){
var statearr_61077_61152 = state_61036__$1;
(statearr_61077_61152[(1)] = (18));

} else {
var statearr_61078_61153 = state_61036__$1;
(statearr_61078_61153[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (3))){
var inst_61034 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61036__$1,inst_61034);
} else {
if((state_val_61037 === (12))){
var inst_60949 = (state_61036[(2)]);
var inst_60950 = fluree.db.util.async.throw_err(inst_60949);
var state_61036__$1 = state_61036;
var statearr_61079_61154 = state_61036__$1;
(statearr_61079_61154[(2)] = inst_60950);

(statearr_61079_61154[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (2))){
var inst_60923 = (state_61036[(17)]);
var inst_60921 = (state_61036[(9)]);
var inst_60914 = (state_61036[(23)]);
var inst_60922 = (state_61036[(21)]);
var inst_60916 = (state_61036[(16)]);
var inst_60919 = (state_61036[(14)]);
var inst_60918 = (state_61036[(11)]);
var inst_60917 = (state_61036[(18)]);
var inst_60915 = (state_61036[(7)]);
var inst_60920 = (state_61036[(19)]);
var _ = (function (){var statearr_61080 = state_61036;
(statearr_61080[(4)] = cljs.core.cons((5),(state_61036[(4)])));

return statearr_61080;
})();
var inst_60912 = flureeQL;
var inst_60913 = cljs.core.__destructure_map(inst_60912);
var inst_60914__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_60915__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_60916__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"block","block",664686210));
var inst_60917__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_60918__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_60919__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_60920__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_60921__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_60922__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60923__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60913,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_60924 = (function (){var construct = inst_60914__$1;
var select = inst_60915__$1;
var block = inst_60916__$1;
var where = inst_60917__$1;
var prefixes = inst_60918__$1;
var selectDistinct = inst_60919__$1;
var selectOne = inst_60920__$1;
var from = inst_60921__$1;
var opts = inst_60922__$1;
var selectReduced = inst_60923__$1;
var map__60911 = inst_60913;
return (function (p1__60904_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__60904_SHARP_);
});
})();
var inst_60925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60926 = [inst_60915__$1,inst_60920__$1,inst_60919__$1,inst_60923__$1];
var inst_60927 = (new cljs.core.PersistentVector(null,4,(5),inst_60925,inst_60926,null));
var inst_60928 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_60927);
var inst_60929 = cljs.core.count(inst_60928);
var inst_60930 = (inst_60924.cljs$core$IFn$_invoke$arity$1 ? inst_60924.cljs$core$IFn$_invoke$arity$1(inst_60929) : inst_60924.call(null,inst_60929));
var state_61036__$1 = (function (){var statearr_61081 = state_61036;
(statearr_61081[(17)] = inst_60923__$1);

(statearr_61081[(9)] = inst_60921__$1);

(statearr_61081[(23)] = inst_60914__$1);

(statearr_61081[(21)] = inst_60922__$1);

(statearr_61081[(16)] = inst_60916__$1);

(statearr_61081[(14)] = inst_60919__$1);

(statearr_61081[(11)] = inst_60918__$1);

(statearr_61081[(18)] = inst_60917__$1);

(statearr_61081[(7)] = inst_60915__$1);

(statearr_61081[(19)] = inst_60920__$1);

return statearr_61081;
})();
if(cljs.core.truth_(inst_60930)){
var statearr_61082_61155 = state_61036__$1;
(statearr_61082_61155[(1)] = (6));

} else {
var statearr_61083_61156 = state_61036__$1;
(statearr_61083_61156[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (23))){
var inst_60922 = (state_61036[(21)]);
var inst_60977 = (state_61036[(8)]);
var inst_60976 = (state_61036[(2)]);
var inst_60977__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_60922);
var state_61036__$1 = (function (){var statearr_61084 = state_61036;
(statearr_61084[(24)] = inst_60976);

(statearr_61084[(8)] = inst_60977__$1);

return statearr_61084;
})();
if(cljs.core.truth_(inst_60977__$1)){
var statearr_61085_61157 = state_61036__$1;
(statearr_61085_61157[(1)] = (24));

} else {
var statearr_61086_61158 = state_61036__$1;
(statearr_61086_61158[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (47))){
var inst_60982 = (state_61036[(25)]);
var inst_60956 = (state_61036[(10)]);
var inst_61015 = (state_61036[(2)]);
var inst_61016 = fluree.db.util.core.current_time_millis();
var inst_61017 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_60982);
var inst_61018 = fluree.db.query.fql.query(inst_60956,inst_61017);
var state_61036__$1 = (function (){var statearr_61087 = state_61036;
(statearr_61087[(26)] = inst_61016);

(statearr_61087[(27)] = inst_61015);

return statearr_61087;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61036__$1,(48),inst_61018);
} else {
if((state_val_61037 === (35))){
var inst_60994 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
var statearr_61088_61159 = state_61036__$1;
(statearr_61088_61159[(2)] = inst_60994);

(statearr_61088_61159[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (19))){
var inst_60966 = (state_61036[(12)]);
var state_61036__$1 = state_61036;
var statearr_61089_61160 = state_61036__$1;
(statearr_61089_61160[(2)] = inst_60966);

(statearr_61089_61160[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (11))){
var inst_60918 = (state_61036[(11)]);
var inst_60956 = (state_61036[(2)]);
var state_61036__$1 = (function (){var statearr_61091 = state_61036;
(statearr_61091[(10)] = inst_60956);

return statearr_61091;
})();
if(cljs.core.truth_(inst_60918)){
var statearr_61092_61161 = state_61036__$1;
(statearr_61092_61161[(1)] = (15));

} else {
var statearr_61093_61162 = state_61036__$1;
(statearr_61093_61162[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (9))){
var inst_60942 = (state_61036[(28)]);
var state_61036__$1 = state_61036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61036__$1,(13),inst_60942);
} else {
if((state_val_61037 === (5))){
var _ = (function (){var statearr_61094 = state_61036;
(statearr_61094[(4)] = cljs.core.rest((state_61036[(4)])));

return statearr_61094;
})();
var state_61036__$1 = state_61036;
var ex61090 = (state_61036__$1[(2)]);
var statearr_61095_61163 = state_61036__$1;
(statearr_61095_61163[(5)] = ex61090);


if((ex61090 instanceof Error)){
var statearr_61096_61164 = state_61036__$1;
(statearr_61096_61164[(1)] = (4));

(statearr_61096_61164[(5)] = null);

} else {
throw ex61090;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (14))){
var inst_60953 = (state_61036[(2)]);
var inst_60954 = fluree.db.util.async.throw_err(inst_60953);
var state_61036__$1 = state_61036;
var statearr_61097_61165 = state_61036__$1;
(statearr_61097_61165[(2)] = inst_60954);

(statearr_61097_61165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (45))){
var state_61036__$1 = state_61036;
var statearr_61098_61166 = state_61036__$1;
(statearr_61098_61166[(2)] = null);

(statearr_61098_61166[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (26))){
var inst_60922 = (state_61036[(21)]);
var inst_60976 = (state_61036[(24)]);
var inst_60915 = (state_61036[(7)]);
var inst_60965 = (state_61036[(22)]);
var inst_60981 = (state_61036[(2)]);
var inst_60982 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_60922,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_60965,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_60981,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_60976], 0));
var state_61036__$1 = (function (){var statearr_61099 = state_61036;
(statearr_61099[(25)] = inst_60982);

return statearr_61099;
})();
if(cljs.core.truth_(inst_60915)){
var statearr_61100_61167 = state_61036__$1;
(statearr_61100_61167[(1)] = (27));

} else {
var statearr_61101_61168 = state_61036__$1;
(statearr_61101_61168[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (16))){
var inst_60963 = cljs.core.PersistentHashMap.EMPTY;
var state_61036__$1 = state_61036;
var statearr_61102_61169 = state_61036__$1;
(statearr_61102_61169[(2)] = inst_60963);

(statearr_61102_61169[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (38))){
var inst_60992 = (state_61036[(2)]);
var state_61036__$1 = state_61036;
var statearr_61103_61170 = state_61036__$1;
(statearr_61103_61170[(2)] = inst_60992);

(statearr_61103_61170[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (30))){
var inst_60920 = (state_61036[(19)]);
var state_61036__$1 = state_61036;
var statearr_61104_61171 = state_61036__$1;
(statearr_61104_61171[(2)] = inst_60920);

(statearr_61104_61171[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (10))){
var inst_60942 = (state_61036[(28)]);
var state_61036__$1 = state_61036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61036__$1,(14),inst_60942);
} else {
if((state_val_61037 === (18))){
var inst_60967 = (state_61036[(20)]);
var state_61036__$1 = state_61036;
var statearr_61105_61172 = state_61036__$1;
(statearr_61105_61172[(2)] = inst_60967);

(statearr_61105_61172[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (42))){
var inst_60921 = (state_61036[(9)]);
var state_61036__$1 = state_61036;
var statearr_61106_61173 = state_61036__$1;
(statearr_61106_61173[(2)] = inst_60921);

(statearr_61106_61173[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (37))){
var inst_60914 = (state_61036[(23)]);
var state_61036__$1 = state_61036;
var statearr_61107_61174 = state_61036__$1;
(statearr_61107_61174[(2)] = inst_60914);

(statearr_61107_61174[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (8))){
var inst_60916 = (state_61036[(16)]);
var inst_60941 = (state_61036[(2)]);
var inst_60942 = sources;
var state_61036__$1 = (function (){var statearr_61108 = state_61036;
(statearr_61108[(28)] = inst_60942);

(statearr_61108[(29)] = inst_60941);

return statearr_61108;
})();
if(cljs.core.truth_(inst_60916)){
var statearr_61109_61175 = state_61036__$1;
(statearr_61109_61175[(1)] = (9));

} else {
var statearr_61110_61176 = state_61036__$1;
(statearr_61110_61176[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61037 === (49))){
var inst_61021 = (state_61036[(13)]);
var inst_60956 = (state_61036[(10)]);
var inst_61016 = (state_61036[(26)]);
var inst_60976 = (state_61036[(24)]);
var inst_61023 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61024 = cljs.core.deref(inst_60976);
var inst_61025 = fluree.db.util.core.response_time_formatted(inst_61016);
var inst_61026 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_60956);
var inst_61027 = [(200),inst_61021,inst_61024,inst_61025,inst_61026];
var inst_61028 = cljs.core.PersistentHashMap.fromArrays(inst_61023,inst_61027);
var state_61036__$1 = state_61036;
var statearr_61111_61177 = state_61036__$1;
(statearr_61111_61177[(2)] = inst_61028);

(statearr_61111_61177[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_61112 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61112[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_61112[(1)] = (1));

return statearr_61112;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_61036){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61036);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61113){var ex__2730__auto__ = e61113;
var statearr_61114_61178 = state_61036;
(statearr_61114_61178[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61036[(4)]))){
var statearr_61115_61179 = state_61036;
(statearr_61115_61179[(1)] = cljs.core.first((state_61036[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61180 = state_61036;
state_61036 = G__61180;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_61036){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_61036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61116 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61116[(6)] = c__2749__auto__);

return statearr_61116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_61321){
var state_val_61322 = (state_61321[(1)]);
if((state_val_61322 === (7))){
var inst_61316 = (state_61321[(2)]);
var _ = (function (){var statearr_61323 = state_61321;
(statearr_61323[(4)] = cljs.core.rest((state_61321[(4)])));

return statearr_61323;
})();
var state_61321__$1 = state_61321;
var statearr_61324_61400 = state_61321__$1;
(statearr_61324_61400[(2)] = inst_61316);

(statearr_61324_61400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (20))){
var inst_61288 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61325_61401 = state_61321__$1;
(statearr_61325_61401[(2)] = inst_61288);

(statearr_61325_61401[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (27))){
var inst_61268 = (state_61321[(7)]);
var state_61321__$1 = state_61321;
var statearr_61326_61402 = state_61321__$1;
(statearr_61326_61402[(2)] = inst_61268);

(statearr_61326_61402[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (1))){
var state_61321__$1 = state_61321;
var statearr_61327_61403 = state_61321__$1;
(statearr_61327_61403[(2)] = null);

(statearr_61327_61403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (24))){
var inst_61265 = (state_61321[(8)]);
var state_61321__$1 = state_61321;
var statearr_61328_61404 = state_61321__$1;
(statearr_61328_61404[(2)] = inst_61265);

(statearr_61328_61404[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (39))){
var inst_61255 = (state_61321[(9)]);
var inst_61222 = (state_61321[(10)]);
var inst_61233 = (state_61321[(11)]);
var inst_61299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61300 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61233];
var inst_61301 = (new cljs.core.PersistentVector(null,2,(5),inst_61299,inst_61300,null));
var inst_61302 = cljs.core.assoc_in(inst_61222,inst_61301,inst_61255);
var state_61321__$1 = state_61321;
var statearr_61329_61405 = state_61321__$1;
(statearr_61329_61405[(2)] = inst_61302);

(statearr_61329_61405[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (4))){
var inst_61181 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61330_61406 = state_61321__$1;
(statearr_61330_61406[(2)] = inst_61181);

(statearr_61330_61406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (15))){
var inst_61255 = (state_61321[(9)]);
var inst_61220 = (state_61321[(12)]);
var inst_61258 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61255);
var inst_61259 = (inst_61220 == null);
var state_61321__$1 = (function (){var statearr_61331 = state_61321;
(statearr_61331[(13)] = inst_61258);

return statearr_61331;
})();
if(cljs.core.truth_(inst_61259)){
var statearr_61332_61407 = state_61321__$1;
(statearr_61332_61407[(1)] = (18));

} else {
var statearr_61333_61408 = state_61321__$1;
(statearr_61333_61408[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (21))){
var inst_61258 = (state_61321[(13)]);
var state_61321__$1 = state_61321;
var statearr_61334_61409 = state_61321__$1;
(statearr_61334_61409[(2)] = inst_61258);

(statearr_61334_61409[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (31))){
var state_61321__$1 = state_61321;
var statearr_61335_61410 = state_61321__$1;
(statearr_61335_61410[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (32))){
var inst_61284 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61337_61411 = state_61321__$1;
(statearr_61337_61411[(2)] = inst_61284);

(statearr_61337_61411[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (40))){
var inst_61253 = (state_61321[(14)]);
var state_61321__$1 = state_61321;
if(cljs.core.truth_(inst_61253)){
var statearr_61338_61412 = state_61321__$1;
(statearr_61338_61412[(1)] = (42));

} else {
var statearr_61339_61413 = state_61321__$1;
(statearr_61339_61413[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (33))){
var inst_61258 = (state_61321[(13)]);
var inst_61220 = (state_61321[(12)]);
var inst_61279 = ((inst_61258 > inst_61220) ? inst_61258 : inst_61220);
var state_61321__$1 = state_61321;
var statearr_61340_61414 = state_61321__$1;
(statearr_61340_61414[(2)] = inst_61279);

(statearr_61340_61414[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (13))){
var inst_61244 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61341_61415 = state_61321__$1;
(statearr_61341_61415[(2)] = inst_61244);

(statearr_61341_61415[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (22))){
var inst_61265 = (state_61321[(8)]);
var inst_61258 = (state_61321[(13)]);
var inst_61265__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61258);
var state_61321__$1 = (function (){var statearr_61342 = state_61321;
(statearr_61342[(8)] = inst_61265__$1);

return statearr_61342;
})();
if(inst_61265__$1){
var statearr_61343_61416 = state_61321__$1;
(statearr_61343_61416[(1)] = (24));

} else {
var statearr_61344_61417 = state_61321__$1;
(statearr_61344_61417[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (36))){
var inst_61255 = (state_61321[(9)]);
var inst_61221 = (state_61321[(15)]);
var inst_61293 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61255,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61294 = (inst_61221 + inst_61293);
var state_61321__$1 = state_61321;
var statearr_61345_61418 = state_61321__$1;
(statearr_61345_61418[(2)] = inst_61294);

(statearr_61345_61418[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (41))){
var inst_61297 = (state_61321[(16)]);
var inst_61291 = (state_61321[(17)]);
var inst_61232 = (state_61321[(18)]);
var inst_61311 = (state_61321[(2)]);
var inst_61219 = inst_61232;
var inst_61220 = inst_61291;
var inst_61221 = inst_61297;
var inst_61222 = inst_61311;
var state_61321__$1 = (function (){var statearr_61346 = state_61321;
(statearr_61346[(15)] = inst_61221);

(statearr_61346[(10)] = inst_61222);

(statearr_61346[(19)] = inst_61219);

(statearr_61346[(12)] = inst_61220);

return statearr_61346;
})();
var statearr_61347_61419 = state_61321__$1;
(statearr_61347_61419[(2)] = null);

(statearr_61347_61419[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (43))){
var inst_61255 = (state_61321[(9)]);
var state_61321__$1 = state_61321;
var statearr_61348_61420 = state_61321__$1;
(statearr_61348_61420[(2)] = inst_61255);

(statearr_61348_61420[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (29))){
var inst_61273 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61349_61421 = state_61321__$1;
(statearr_61349_61421[(2)] = inst_61273);

(statearr_61349_61421[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (44))){
var inst_61222 = (state_61321[(10)]);
var inst_61233 = (state_61321[(11)]);
var inst_61308 = (state_61321[(2)]);
var inst_61309 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_61222,inst_61233,inst_61308);
var state_61321__$1 = state_61321;
var statearr_61350_61422 = state_61321__$1;
(statearr_61350_61422[(2)] = inst_61309);

(statearr_61350_61422[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (6))){
var inst_61234 = (state_61321[(20)]);
var inst_61219 = (state_61321[(19)]);
var inst_61230 = cljs.core.seq(inst_61219);
var inst_61231 = cljs.core.first(inst_61230);
var inst_61232 = cljs.core.next(inst_61230);
var inst_61233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61231,(0),null);
var inst_61234__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61231,(1),null);
var inst_61235 = (inst_61234__$1 == null);
var state_61321__$1 = (function (){var statearr_61351 = state_61321;
(statearr_61351[(20)] = inst_61234__$1);

(statearr_61351[(11)] = inst_61233);

(statearr_61351[(18)] = inst_61232);

return statearr_61351;
})();
if(cljs.core.truth_(inst_61235)){
var statearr_61352_61423 = state_61321__$1;
(statearr_61352_61423[(1)] = (8));

} else {
var statearr_61353_61424 = state_61321__$1;
(statearr_61353_61424[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (28))){
var inst_61220 = (state_61321[(12)]);
var inst_61271 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_61220);
var state_61321__$1 = state_61321;
var statearr_61354_61425 = state_61321__$1;
(statearr_61354_61425[(2)] = inst_61271);

(statearr_61354_61425[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (25))){
var inst_61268 = (state_61321[(7)]);
var inst_61220 = (state_61321[(12)]);
var inst_61268__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_61220);
var state_61321__$1 = (function (){var statearr_61355 = state_61321;
(statearr_61355[(7)] = inst_61268__$1);

return statearr_61355;
})();
if(inst_61268__$1){
var statearr_61356_61426 = state_61321__$1;
(statearr_61356_61426[(1)] = (27));

} else {
var statearr_61357_61427 = state_61321__$1;
(statearr_61357_61427[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (34))){
var state_61321__$1 = state_61321;
var statearr_61358_61428 = state_61321__$1;
(statearr_61358_61428[(2)] = null);

(statearr_61358_61428[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (17))){
var inst_61252 = (state_61321[(21)]);
var inst_61291 = (state_61321[(2)]);
var state_61321__$1 = (function (){var statearr_61359 = state_61321;
(statearr_61359[(17)] = inst_61291);

return statearr_61359;
})();
if(cljs.core.truth_(inst_61252)){
var statearr_61360_61429 = state_61321__$1;
(statearr_61360_61429[(1)] = (36));

} else {
var statearr_61361_61430 = state_61321__$1;
(statearr_61361_61430[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (3))){
var inst_61319 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61321__$1,inst_61319);
} else {
if((state_val_61322 === (12))){
var inst_61222 = (state_61321[(10)]);
var state_61321__$1 = state_61321;
var statearr_61362_61431 = state_61321__$1;
(statearr_61362_61431[(2)] = inst_61222);

(statearr_61362_61431[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (2))){
var inst_61191 = (state_61321[(22)]);
var inst_61196 = (state_61321[(23)]);
var inst_61195 = (state_61321[(24)]);
var _ = (function (){var statearr_61363 = state_61321;
(statearr_61363[(4)] = cljs.core.cons((5),(state_61321[(4)])));

return statearr_61363;
})();
var inst_61187 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61189 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61190 = (new cljs.core.PersistentVector(null,2,(5),inst_61188,inst_61189,null));
var inst_61191__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_61190);
var inst_61192 = (function (){var global_block = inst_61187;
var global_meta_QMARK_ = inst_61191__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4253__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4251__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4251__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_61193 = cljs.core.PersistentHashMap.EMPTY;
var inst_61194 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_61195__$1 = cljs.core.reduce_kv(inst_61192,inst_61193,inst_61194);
var inst_61196__$1 = fluree.db.util.core.current_time_millis();
var inst_61198 = (function (){var global_block = inst_61187;
var global_meta_QMARK_ = inst_61191__$1;
var queries = inst_61195__$1;
var start_time = inst_61196__$1;
return (function (p__61197){
var vec__61364 = p__61197;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61364,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61364,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_61199 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61198,inst_61195__$1);
var inst_61213 = cljs.core.seq(inst_61199);
var inst_61214 = cljs.core.first(inst_61213);
var inst_61215 = cljs.core.next(inst_61213);
var inst_61216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61214,(0),null);
var inst_61217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61214,(1),null);
var inst_61218 = cljs.core.PersistentHashMap.EMPTY;
var inst_61219 = inst_61199;
var inst_61220 = null;
var inst_61221 = (0);
var inst_61222 = inst_61218;
var state_61321__$1 = (function (){var statearr_61367 = state_61321;
(statearr_61367[(15)] = inst_61221);

(statearr_61367[(25)] = inst_61215);

(statearr_61367[(10)] = inst_61222);

(statearr_61367[(22)] = inst_61191__$1);

(statearr_61367[(19)] = inst_61219);

(statearr_61367[(23)] = inst_61196__$1);

(statearr_61367[(24)] = inst_61195__$1);

(statearr_61367[(26)] = inst_61217);

(statearr_61367[(12)] = inst_61220);

(statearr_61367[(27)] = inst_61216);

return statearr_61367;
})();
var statearr_61368_61432 = state_61321__$1;
(statearr_61368_61432[(2)] = null);

(statearr_61368_61432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (23))){
var inst_61286 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61369_61433 = state_61321__$1;
(statearr_61369_61433[(2)] = inst_61286);

(statearr_61369_61433[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (35))){
var inst_61282 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61370_61434 = state_61321__$1;
(statearr_61370_61434[(2)] = inst_61282);

(statearr_61370_61434[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (19))){
var inst_61258 = (state_61321[(13)]);
var inst_61220 = (state_61321[(12)]);
var inst_61262 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61220,inst_61258);
var state_61321__$1 = state_61321;
if(inst_61262){
var statearr_61371_61435 = state_61321__$1;
(statearr_61371_61435[(1)] = (21));

} else {
var statearr_61372_61436 = state_61321__$1;
(statearr_61372_61436[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (11))){
var inst_61221 = (state_61321[(15)]);
var inst_61222 = (state_61321[(10)]);
var inst_61196 = (state_61321[(23)]);
var inst_61220 = (state_61321[(12)]);
var inst_61238 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61239 = fluree.db.util.core.response_time_formatted(inst_61196);
var inst_61240 = [inst_61222,inst_61221,inst_61220,inst_61239];
var inst_61241 = cljs.core.PersistentHashMap.fromArrays(inst_61238,inst_61240);
var state_61321__$1 = state_61321;
var statearr_61374_61437 = state_61321__$1;
(statearr_61374_61437[(2)] = inst_61241);

(statearr_61374_61437[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (9))){
var inst_61234 = (state_61321[(20)]);
var inst_61195 = (state_61321[(24)]);
var inst_61233 = (state_61321[(11)]);
var inst_61247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61248 = [inst_61233,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61249 = (new cljs.core.PersistentVector(null,2,(5),inst_61247,inst_61248,null));
var inst_61250 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61195,inst_61249);
var inst_61251 = cljs.core.__destructure_map(inst_61250);
var inst_61252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61251,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61251,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61321__$1 = (function (){var statearr_61375 = state_61321;
(statearr_61375[(14)] = inst_61253);

(statearr_61375[(21)] = inst_61252);

return statearr_61375;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61321__$1,(14),inst_61234);
} else {
if((state_val_61322 === (5))){
var _ = (function (){var statearr_61376 = state_61321;
(statearr_61376[(4)] = cljs.core.rest((state_61321[(4)])));

return statearr_61376;
})();
var state_61321__$1 = state_61321;
var ex61373 = (state_61321__$1[(2)]);
var statearr_61377_61438 = state_61321__$1;
(statearr_61377_61438[(5)] = ex61373);


var statearr_61378_61439 = state_61321__$1;
(statearr_61378_61439[(1)] = (4));

(statearr_61378_61439[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (14))){
var inst_61255 = (state_61321[(9)]);
var inst_61252 = (state_61321[(21)]);
var inst_61255__$1 = (state_61321[(2)]);
var inst_61256 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61255__$1);
var state_61321__$1 = (function (){var statearr_61379 = state_61321;
(statearr_61379[(9)] = inst_61255__$1);

(statearr_61379[(28)] = inst_61256);

return statearr_61379;
})();
if(cljs.core.truth_(inst_61252)){
var statearr_61380_61440 = state_61321__$1;
(statearr_61380_61440[(1)] = (15));

} else {
var statearr_61381_61441 = state_61321__$1;
(statearr_61381_61441[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (26))){
var inst_61275 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
if(cljs.core.truth_(inst_61275)){
var statearr_61382_61442 = state_61321__$1;
(statearr_61382_61442[(1)] = (30));

} else {
var statearr_61383_61443 = state_61321__$1;
(statearr_61383_61443[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (16))){
var state_61321__$1 = state_61321;
var statearr_61384_61444 = state_61321__$1;
(statearr_61384_61444[(2)] = null);

(statearr_61384_61444[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (38))){
var inst_61256 = (state_61321[(28)]);
var inst_61297 = (state_61321[(2)]);
var state_61321__$1 = (function (){var statearr_61385 = state_61321;
(statearr_61385[(16)] = inst_61297);

return statearr_61385;
})();
if(cljs.core.truth_(inst_61256)){
var statearr_61386_61445 = state_61321__$1;
(statearr_61386_61445[(1)] = (39));

} else {
var statearr_61387_61446 = state_61321__$1;
(statearr_61387_61446[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (30))){
var state_61321__$1 = state_61321;
var statearr_61388_61447 = state_61321__$1;
(statearr_61388_61447[(2)] = (207));

(statearr_61388_61447[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (10))){
var inst_61314 = (state_61321[(2)]);
var state_61321__$1 = state_61321;
var statearr_61389_61448 = state_61321__$1;
(statearr_61389_61448[(2)] = inst_61314);

(statearr_61389_61448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (18))){
var inst_61258 = (state_61321[(13)]);
var state_61321__$1 = state_61321;
var statearr_61390_61449 = state_61321__$1;
(statearr_61390_61449[(2)] = inst_61258);

(statearr_61390_61449[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (42))){
var inst_61255 = (state_61321[(9)]);
var inst_61305 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61255);
var state_61321__$1 = state_61321;
var statearr_61391_61450 = state_61321__$1;
(statearr_61391_61450[(2)] = inst_61305);

(statearr_61391_61450[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (37))){
var state_61321__$1 = state_61321;
var statearr_61392_61451 = state_61321__$1;
(statearr_61392_61451[(2)] = null);

(statearr_61392_61451[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61322 === (8))){
var inst_61191 = (state_61321[(22)]);
var state_61321__$1 = state_61321;
if(cljs.core.truth_(inst_61191)){
var statearr_61393_61452 = state_61321__$1;
(statearr_61393_61452[(1)] = (11));

} else {
var statearr_61394_61453 = state_61321__$1;
(statearr_61394_61453[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_61395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61395[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_61395[(1)] = (1));

return statearr_61395;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_61321){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_61321);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e61396){var ex__2730__auto__ = e61396;
var statearr_61397_61454 = state_61321;
(statearr_61397_61454[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_61321[(4)]))){
var statearr_61398_61455 = state_61321;
(statearr_61398_61455[(1)] = cljs.core.first((state_61321[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61456 = state_61321;
state_61321 = G__61456;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_61321){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_61321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_61399 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_61399[(6)] = c__2749__auto__);

return statearr_61399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__61457 = query_type;
var G__61457__$1 = (((G__61457 instanceof cljs.core.Keyword))?G__61457.fqn:null);
switch (G__61457__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__61457__$1)].join('')));

}
});
