// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__65058 = arguments.length;
switch (G__65058) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___65097 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65079){
var state_val_65080 = (state_65079[(1)]);
if((state_val_65080 === (1))){
var state_65079__$1 = state_65079;
var statearr_65081_65098 = state_65079__$1;
(statearr_65081_65098[(2)] = null);

(statearr_65081_65098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65080 === (2))){
var _ = (function (){var statearr_65082 = state_65079;
(statearr_65082[(4)] = cljs.core.cons((5),(state_65079[(4)])));

return statearr_65082;
})();
var inst_65065 = fluree.db.session.db(conn,ledger,null);
var state_65079__$1 = state_65079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65079__$1,(7),inst_65065);
} else {
if((state_val_65080 === (3))){
var inst_65075 = (state_65079[(2)]);
var inst_65076 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65075);
var inst_65077 = cljs.core.async.close_BANG_(pc);
var state_65079__$1 = (function (){var statearr_65084 = state_65079;
(statearr_65084[(7)] = inst_65076);

return statearr_65084;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65079__$1,inst_65077);
} else {
if((state_val_65080 === (4))){
var inst_65059 = (state_65079[(2)]);
var state_65079__$1 = state_65079;
var statearr_65085_65099 = state_65079__$1;
(statearr_65085_65099[(2)] = inst_65059);

(statearr_65085_65099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65080 === (5))){
var _ = (function (){var statearr_65086 = state_65079;
(statearr_65086[(4)] = cljs.core.rest((state_65079[(4)])));

return statearr_65086;
})();
var state_65079__$1 = state_65079;
var ex65083 = (state_65079__$1[(2)]);
var statearr_65087_65100 = state_65079__$1;
(statearr_65087_65100[(5)] = ex65083);


var statearr_65088_65101 = state_65079__$1;
(statearr_65088_65101[(1)] = (4));

(statearr_65088_65101[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65080 === (6))){
var inst_65071 = (state_65079[(2)]);
var inst_65072 = fluree.db.util.async.throw_err(inst_65071);
var _ = (function (){var statearr_65089 = state_65079;
(statearr_65089[(4)] = cljs.core.rest((state_65079[(4)])));

return statearr_65089;
})();
var state_65079__$1 = state_65079;
var statearr_65090_65102 = state_65079__$1;
(statearr_65090_65102[(2)] = inst_65072);

(statearr_65090_65102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65080 === (7))){
var inst_65067 = (state_65079[(2)]);
var inst_65068 = fluree.db.util.async.throw_err(inst_65067);
var inst_65069 = fluree.db.time_travel.as_of_block(inst_65068,block);
var state_65079__$1 = state_65079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65079__$1,(6),inst_65069);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_65091 = [null,null,null,null,null,null,null,null];
(statearr_65091[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_65091[(1)] = (1));

return statearr_65091;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_65079){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65079);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65092){var ex__2730__auto__ = e65092;
var statearr_65093_65103 = state_65079;
(statearr_65093_65103[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65079[(4)]))){
var statearr_65094_65104 = state_65079;
(statearr_65094_65104[(1)] = cljs.core.first((state_65079[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65105 = state_65079;
state_65079 = G__65105;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_65079){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_65079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65095 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65095[(6)] = c__2749__auto___65097);

return statearr_65095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65146){
var state_val_65147 = (state_65146[(1)]);
if((state_val_65147 === (7))){
var inst_65115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_65146__$1 = state_65146;
if(inst_65115){
var statearr_65148_65179 = state_65146__$1;
(statearr_65148_65179[(1)] = (9));

} else {
var statearr_65149_65180 = state_65146__$1;
(statearr_65149_65180[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (1))){
var state_65146__$1 = state_65146;
var statearr_65150_65181 = state_65146__$1;
(statearr_65150_65181[(2)] = null);

(statearr_65150_65181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (4))){
var inst_65106 = (state_65146[(2)]);
var state_65146__$1 = state_65146;
var statearr_65151_65182 = state_65146__$1;
(statearr_65151_65182[(2)] = inst_65106);

(statearr_65151_65182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (15))){
var inst_65123 = (state_65146[(7)]);
var inst_65122 = (state_65146[(2)]);
var inst_65123__$1 = fluree.db.util.async.throw_err(inst_65122);
var state_65146__$1 = (function (){var statearr_65152 = state_65146;
(statearr_65152[(7)] = inst_65123__$1);

return statearr_65152;
})();
if(cljs.core.truth_(inst_65123__$1)){
var statearr_65153_65183 = state_65146__$1;
(statearr_65153_65183[(1)] = (16));

} else {
var statearr_65154_65184 = state_65146__$1;
(statearr_65154_65184[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (13))){
var state_65146__$1 = state_65146;
var statearr_65155_65185 = state_65146__$1;
(statearr_65155_65185[(2)] = null);

(statearr_65155_65185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (6))){
var state_65146__$1 = state_65146;
var statearr_65156_65186 = state_65146__$1;
(statearr_65156_65186[(2)] = db);

(statearr_65156_65186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (17))){
var inst_65127 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_65128 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65129 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65130 = cljs.core.PersistentHashMap.fromArrays(inst_65128,inst_65129);
var inst_65131 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65127,inst_65130);
var inst_65132 = (function(){throw inst_65131})();
var state_65146__$1 = state_65146;
var statearr_65157_65187 = state_65146__$1;
(statearr_65157_65187[(2)] = inst_65132);

(statearr_65157_65187[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (3))){
var inst_65144 = (state_65146[(2)]);
var state_65146__$1 = state_65146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65146__$1,inst_65144);
} else {
if((state_val_65147 === (12))){
var inst_65120 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_65146__$1 = state_65146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65146__$1,(15),inst_65120);
} else {
if((state_val_65147 === (2))){
var _ = (function (){var statearr_65158 = state_65146;
(statearr_65158[(4)] = cljs.core.cons((5),(state_65146[(4)])));

return statearr_65158;
})();
var inst_65112 = cljs.core.not(auth);
var state_65146__$1 = state_65146;
if(inst_65112){
var statearr_65159_65188 = state_65146__$1;
(statearr_65159_65188[(1)] = (6));

} else {
var statearr_65160_65189 = state_65146__$1;
(statearr_65160_65189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (11))){
var inst_65139 = (state_65146[(2)]);
var state_65146__$1 = state_65146;
var statearr_65162_65190 = state_65146__$1;
(statearr_65162_65190[(2)] = inst_65139);

(statearr_65162_65190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (9))){
var inst_65117 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_65146__$1 = state_65146;
var statearr_65163_65191 = state_65146__$1;
(statearr_65163_65191[(2)] = inst_65117);

(statearr_65163_65191[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (5))){
var _ = (function (){var statearr_65164 = state_65146;
(statearr_65164[(4)] = cljs.core.rest((state_65146[(4)])));

return statearr_65164;
})();
var state_65146__$1 = state_65146;
var ex65161 = (state_65146__$1[(2)]);
var statearr_65165_65192 = state_65146__$1;
(statearr_65165_65192[(5)] = ex65161);


if((ex65161 instanceof Error)){
var statearr_65166_65193 = state_65146__$1;
(statearr_65166_65193[(1)] = (4));

(statearr_65166_65193[(5)] = null);

} else {
throw ex65161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (14))){
var inst_65137 = (state_65146[(2)]);
var state_65146__$1 = state_65146;
var statearr_65167_65194 = state_65146__$1;
(statearr_65167_65194[(2)] = inst_65137);

(statearr_65167_65194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (16))){
var inst_65123 = (state_65146[(7)]);
var inst_65125 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65123);
var state_65146__$1 = state_65146;
var statearr_65168_65195 = state_65146__$1;
(statearr_65168_65195[(2)] = inst_65125);

(statearr_65168_65195[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (10))){
var state_65146__$1 = state_65146;
var statearr_65169_65196 = state_65146__$1;
(statearr_65169_65196[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (18))){
var inst_65134 = (state_65146[(2)]);
var state_65146__$1 = state_65146;
var statearr_65171_65197 = state_65146__$1;
(statearr_65171_65197[(2)] = inst_65134);

(statearr_65171_65197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65147 === (8))){
var inst_65141 = (state_65146[(2)]);
var _ = (function (){var statearr_65172 = state_65146;
(statearr_65172[(4)] = cljs.core.rest((state_65146[(4)])));

return statearr_65172;
})();
var state_65146__$1 = state_65146;
var statearr_65173_65198 = state_65146__$1;
(statearr_65173_65198[(2)] = inst_65141);

(statearr_65173_65198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0 = (function (){
var statearr_65174 = [null,null,null,null,null,null,null,null];
(statearr_65174[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__);

(statearr_65174[(1)] = (1));

return statearr_65174;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1 = (function (state_65146){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65146);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65175){var ex__2730__auto__ = e65175;
var statearr_65176_65199 = state_65146;
(statearr_65176_65199[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65146[(4)]))){
var statearr_65177_65200 = state_65146;
(statearr_65177_65200[(1)] = cljs.core.first((state_65146[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65201 = state_65146;
state_65146 = G__65201;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__ = function(state_65146){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1.call(this,state_65146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65178 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65178[(6)] = c__2749__auto__);

return statearr_65178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65265){
var state_val_65266 = (state_65265[(1)]);
if((state_val_65266 === (7))){
var inst_65211 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_65265__$1 = state_65265;
if(inst_65211){
var statearr_65267_65316 = state_65265__$1;
(statearr_65267_65316[(1)] = (9));

} else {
var statearr_65268_65317 = state_65265__$1;
(statearr_65268_65317[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (20))){
var inst_65235 = (state_65265[(7)]);
var state_65265__$1 = state_65265;
if(cljs.core.truth_(inst_65235)){
var statearr_65269_65318 = state_65265__$1;
(statearr_65269_65318[(1)] = (22));

} else {
var statearr_65270_65319 = state_65265__$1;
(statearr_65270_65319[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (27))){
var state_65265__$1 = state_65265;
var statearr_65271_65320 = state_65265__$1;
(statearr_65271_65320[(2)] = null);

(statearr_65271_65320[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (1))){
var state_65265__$1 = state_65265;
var statearr_65272_65321 = state_65265__$1;
(statearr_65272_65321[(2)] = null);

(statearr_65272_65321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (24))){
var inst_65249 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65273_65322 = state_65265__$1;
(statearr_65273_65322[(2)] = inst_65249);

(statearr_65273_65322[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (4))){
var inst_65202 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65274_65323 = state_65265__$1;
(statearr_65274_65323[(2)] = inst_65202);

(statearr_65274_65323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (15))){
var inst_65218 = (state_65265[(8)]);
var inst_65217 = (state_65265[(2)]);
var inst_65218__$1 = fluree.db.util.async.throw_err(inst_65217);
var state_65265__$1 = (function (){var statearr_65275 = state_65265;
(statearr_65275[(8)] = inst_65218__$1);

return statearr_65275;
})();
if(cljs.core.truth_(inst_65218__$1)){
var statearr_65276_65324 = state_65265__$1;
(statearr_65276_65324[(1)] = (16));

} else {
var statearr_65277_65325 = state_65265__$1;
(statearr_65277_65325[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (21))){
var inst_65251 = (state_65265[(9)]);
var inst_65251__$1 = (state_65265[(2)]);
var state_65265__$1 = (function (){var statearr_65278 = state_65265;
(statearr_65278[(9)] = inst_65251__$1);

return statearr_65278;
})();
if(cljs.core.truth_(inst_65251__$1)){
var statearr_65279_65326 = state_65265__$1;
(statearr_65279_65326[(1)] = (29));

} else {
var statearr_65280_65327 = state_65265__$1;
(statearr_65280_65327[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (31))){
var inst_65235 = (state_65265[(7)]);
var inst_65251 = (state_65265[(9)]);
var inst_65259 = (state_65265[(2)]);
var inst_65260 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65235,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_65251,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65259], 0));
var _ = (function (){var statearr_65281 = state_65265;
(statearr_65281[(4)] = cljs.core.rest((state_65265[(4)])));

return statearr_65281;
})();
var state_65265__$1 = state_65265;
var statearr_65282_65328 = state_65265__$1;
(statearr_65282_65328[(2)] = inst_65260);

(statearr_65282_65328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (32))){
var inst_65255 = (state_65265[(2)]);
var inst_65256 = fluree.db.util.async.throw_err(inst_65255);
var state_65265__$1 = state_65265;
var statearr_65283_65329 = state_65265__$1;
(statearr_65283_65329[(2)] = inst_65256);

(statearr_65283_65329[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (13))){
var state_65265__$1 = state_65265;
var statearr_65284_65330 = state_65265__$1;
(statearr_65284_65330[(2)] = null);

(statearr_65284_65330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (22))){
var inst_65235 = (state_65265[(7)]);
var inst_65239 = fluree.db.auth.roles(db,inst_65235);
var state_65265__$1 = state_65265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65265__$1,(25),inst_65239);
} else {
if((state_val_65266 === (29))){
var inst_65251 = (state_65265[(9)]);
var inst_65253 = fluree.db.permissions.permission_map(db,inst_65251,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65265__$1 = state_65265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65265__$1,(32),inst_65253);
} else {
if((state_val_65266 === (6))){
var state_65265__$1 = state_65265;
var statearr_65285_65331 = state_65265__$1;
(statearr_65285_65331[(2)] = null);

(statearr_65285_65331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (28))){
var inst_65247 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65286_65332 = state_65265__$1;
(statearr_65286_65332[(2)] = inst_65247);

(statearr_65286_65332[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (25))){
var inst_65241 = (state_65265[(2)]);
var inst_65242 = fluree.db.util.async.throw_err(inst_65241);
var state_65265__$1 = state_65265;
var statearr_65287_65333 = state_65265__$1;
(statearr_65287_65333[(2)] = inst_65242);

(statearr_65287_65333[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (17))){
var inst_65221 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_65222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65223 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65224 = cljs.core.PersistentHashMap.fromArrays(inst_65222,inst_65223);
var inst_65225 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65221,inst_65224);
var inst_65226 = (function(){throw inst_65225})();
var state_65265__$1 = state_65265;
var statearr_65288_65334 = state_65265__$1;
(statearr_65288_65334[(2)] = inst_65226);

(statearr_65288_65334[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (3))){
var inst_65263 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65265__$1,inst_65263);
} else {
if((state_val_65266 === (12))){
var inst_65215 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_65265__$1 = state_65265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65265__$1,(15),inst_65215);
} else {
if((state_val_65266 === (2))){
var _ = (function (){var statearr_65289 = state_65265;
(statearr_65289[(4)] = cljs.core.cons((5),(state_65265[(4)])));

return statearr_65289;
})();
var inst_65208 = (auth == null);
var state_65265__$1 = state_65265;
if(cljs.core.truth_(inst_65208)){
var statearr_65290_65335 = state_65265__$1;
(statearr_65290_65335[(1)] = (6));

} else {
var statearr_65291_65336 = state_65265__$1;
(statearr_65291_65336[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (23))){
var state_65265__$1 = state_65265;
var statearr_65292_65337 = state_65265__$1;
(statearr_65292_65337[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (19))){
var state_65265__$1 = state_65265;
var statearr_65294_65338 = state_65265__$1;
(statearr_65294_65338[(2)] = roles);

(statearr_65294_65338[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (11))){
var inst_65233 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65296_65339 = state_65265__$1;
(statearr_65296_65339[(2)] = inst_65233);

(statearr_65296_65339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (9))){
var state_65265__$1 = state_65265;
var statearr_65297_65340 = state_65265__$1;
(statearr_65297_65340[(2)] = (0));

(statearr_65297_65340[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (5))){
var _ = (function (){var statearr_65298 = state_65265;
(statearr_65298[(4)] = cljs.core.rest((state_65265[(4)])));

return statearr_65298;
})();
var state_65265__$1 = state_65265;
var ex65295 = (state_65265__$1[(2)]);
var statearr_65299_65341 = state_65265__$1;
(statearr_65299_65341[(5)] = ex65295);


if((ex65295 instanceof Error)){
var statearr_65300_65342 = state_65265__$1;
(statearr_65300_65342[(1)] = (4));

(statearr_65300_65342[(5)] = null);

} else {
throw ex65295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (14))){
var inst_65231 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65301_65343 = state_65265__$1;
(statearr_65301_65343[(2)] = inst_65231);

(statearr_65301_65343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (26))){
var state_65265__$1 = state_65265;
var statearr_65302_65344 = state_65265__$1;
(statearr_65302_65344[(2)] = null);

(statearr_65302_65344[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (16))){
var inst_65218 = (state_65265[(8)]);
var state_65265__$1 = state_65265;
var statearr_65303_65345 = state_65265__$1;
(statearr_65303_65345[(2)] = inst_65218);

(statearr_65303_65345[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (30))){
var state_65265__$1 = state_65265;
var statearr_65304_65346 = state_65265__$1;
(statearr_65304_65346[(2)] = null);

(statearr_65304_65346[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (10))){
var state_65265__$1 = state_65265;
if(cljs.core.truth_(auth)){
var statearr_65305_65347 = state_65265__$1;
(statearr_65305_65347[(1)] = (12));

} else {
var statearr_65306_65348 = state_65265__$1;
(statearr_65306_65348[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (18))){
var inst_65228 = (state_65265[(2)]);
var state_65265__$1 = state_65265;
var statearr_65307_65349 = state_65265__$1;
(statearr_65307_65349[(2)] = inst_65228);

(statearr_65307_65349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65266 === (8))){
var inst_65235 = (state_65265[(2)]);
var state_65265__$1 = (function (){var statearr_65308 = state_65265;
(statearr_65308[(7)] = inst_65235);

return statearr_65308;
})();
if(cljs.core.truth_(roles)){
var statearr_65309_65350 = state_65265__$1;
(statearr_65309_65350[(1)] = (19));

} else {
var statearr_65310_65351 = state_65265__$1;
(statearr_65310_65351[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0 = (function (){
var statearr_65311 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65311[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__);

(statearr_65311[(1)] = (1));

return statearr_65311;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1 = (function (state_65265){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65265);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65312){var ex__2730__auto__ = e65312;
var statearr_65313_65352 = state_65265;
(statearr_65313_65352[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65265[(4)]))){
var statearr_65314_65353 = state_65265;
(statearr_65314_65353[(1)] = cljs.core.first((state_65265[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65354 = state_65265;
state_65265 = G__65354;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__ = function(state_65265){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1.call(this,state_65265);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65315 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65315[(6)] = c__2749__auto__);

return statearr_65315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__65355 = db;
var map__65355__$1 = cljs.core.__destructure_map(map__65355);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65355__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65355__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65355__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65362){
var state_val_65363 = (state_65362[(1)]);
if((state_val_65363 === (1))){
var inst_65356 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_65357 = fluree.db.session.db(conn,inst_65356,null);
var state_65362__$1 = state_65362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65362__$1,(2),inst_65357);
} else {
if((state_val_65363 === (2))){
var inst_65359 = (state_65362[(2)]);
var inst_65360 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_65359);
var state_65362__$1 = state_65362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65362__$1,inst_65360);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_65364 = [null,null,null,null,null,null,null];
(statearr_65364[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_65364[(1)] = (1));

return statearr_65364;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_65362){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65362);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65365){var ex__2730__auto__ = e65365;
var statearr_65366_65393 = state_65362;
(statearr_65366_65393[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65362[(4)]))){
var statearr_65367_65394 = state_65362;
(statearr_65367_65394[(1)] = cljs.core.first((state_65362[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65395 = state_65362;
state_65362 = G__65395;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_65362){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_65362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65368 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65368[(6)] = c__2749__auto__);

return statearr_65368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65381){
var state_val_65382 = (state_65381[(1)]);
if((state_val_65382 === (1))){
var inst_65369 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_65370 = fluree.db.session.db(conn,inst_65369,null);
var state_65381__$1 = state_65381;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65381__$1,(2),inst_65370);
} else {
if((state_val_65382 === (2))){
var inst_65372 = (state_65381[(7)]);
var inst_65372__$1 = (state_65381[(2)]);
var inst_65373 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65372__$1);
var inst_65374 = newer_block_QMARK_(inst_65373);
var state_65381__$1 = (function (){var statearr_65383 = state_65381;
(statearr_65383[(7)] = inst_65372__$1);

return statearr_65383;
})();
if(inst_65374){
var statearr_65384_65396 = state_65381__$1;
(statearr_65384_65396[(1)] = (3));

} else {
var statearr_65385_65397 = state_65381__$1;
(statearr_65385_65397[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65382 === (3))){
var inst_65372 = (state_65381[(7)]);
var inst_65376 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_65372);
var state_65381__$1 = state_65381;
var statearr_65386_65398 = state_65381__$1;
(statearr_65386_65398[(2)] = inst_65376);

(statearr_65386_65398[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65382 === (4))){
var state_65381__$1 = state_65381;
var statearr_65387_65399 = state_65381__$1;
(statearr_65387_65399[(2)] = null);

(statearr_65387_65399[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65382 === (5))){
var inst_65379 = (state_65381[(2)]);
var state_65381__$1 = state_65381;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65381__$1,inst_65379);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0 = (function (){
var statearr_65388 = [null,null,null,null,null,null,null,null];
(statearr_65388[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__);

(statearr_65388[(1)] = (1));

return statearr_65388;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1 = (function (state_65381){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65381);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65389){var ex__2730__auto__ = e65389;
var statearr_65390_65400 = state_65381;
(statearr_65390_65400[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65381[(4)]))){
var statearr_65391_65401 = state_65381;
(statearr_65391_65401[(1)] = cljs.core.first((state_65381[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65402 = state_65381;
state_65381 = G__65402;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__ = function(state_65381){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1.call(this,state_65381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65392 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65392[(6)] = c__2749__auto__);

return statearr_65392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__65403 = db;
var map__65403__$1 = cljs.core.__destructure_map(map__65403);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65403__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65403__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65403__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2749__auto___65479 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65453){
var state_val_65454 = (state_65453[(1)]);
if((state_val_65454 === (7))){
var inst_65419 = (state_65453[(7)]);
var inst_65430 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65419,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_65453__$1 = state_65453;
if(inst_65430){
var statearr_65455_65480 = state_65453__$1;
(statearr_65455_65480[(1)] = (9));

} else {
var statearr_65456_65481 = state_65453__$1;
(statearr_65456_65481[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (1))){
var inst_65412 = (state_65453[(8)]);
var inst_65404 = (state_65453[(9)]);
var inst_65404__$1 = cljs.core.async.timeout(timeout);
var inst_65412__$1 = res_port;
var inst_65413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65414 = [inst_65404__$1,inst_65412__$1];
var inst_65415 = (new cljs.core.PersistentVector(null,2,(5),inst_65413,inst_65414,null));
var state_65453__$1 = (function (){var statearr_65457 = state_65453;
(statearr_65457[(8)] = inst_65412__$1);

(statearr_65457[(9)] = inst_65404__$1);

return statearr_65457;
})();
return cljs.core.async.ioc_alts_BANG_(state_65453__$1,(2),inst_65415);
} else {
if((state_val_65454 === (4))){
var inst_65412 = (state_65453[(8)]);
var inst_65419 = (state_65453[(7)]);
var inst_65423 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65419,inst_65412);
var state_65453__$1 = state_65453;
if(inst_65423){
var statearr_65458_65482 = state_65453__$1;
(statearr_65458_65482[(1)] = (6));

} else {
var statearr_65459_65483 = state_65453__$1;
(statearr_65459_65483[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (13))){
var inst_65438 = (state_65453[(10)]);
var inst_65449 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65438);
var state_65453__$1 = state_65453;
var statearr_65460_65484 = state_65453__$1;
(statearr_65460_65484[(2)] = inst_65449);

(statearr_65460_65484[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (6))){
var inst_65417 = (state_65453[(11)]);
var inst_65428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417,(0),null);
var state_65453__$1 = state_65453;
var statearr_65461_65485 = state_65453__$1;
(statearr_65461_65485[(2)] = inst_65428);

(statearr_65461_65485[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (3))){
var state_65453__$1 = state_65453;
var statearr_65462_65486 = state_65453__$1;
(statearr_65462_65486[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_65462_65486[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (12))){
var inst_65442 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_65443 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65444 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_65445 = cljs.core.PersistentHashMap.fromArrays(inst_65443,inst_65444);
var inst_65446 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65442,inst_65445);
var inst_65447 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65446);
var state_65453__$1 = state_65453;
var statearr_65463_65487 = state_65453__$1;
(statearr_65463_65487[(2)] = inst_65447);

(statearr_65463_65487[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (2))){
var inst_65419 = (state_65453[(7)]);
var inst_65404 = (state_65453[(9)]);
var inst_65417 = (state_65453[(11)]);
var inst_65417__$1 = (state_65453[(2)]);
var inst_65418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417__$1,(0),null);
var inst_65419__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65417__$1,(1),null);
var inst_65420 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65419__$1,inst_65404);
var state_65453__$1 = (function (){var statearr_65464 = state_65453;
(statearr_65464[(7)] = inst_65419__$1);

(statearr_65464[(11)] = inst_65417__$1);

(statearr_65464[(12)] = inst_65418);

return statearr_65464;
})();
if(inst_65420){
var statearr_65465_65488 = state_65453__$1;
(statearr_65465_65488[(1)] = (3));

} else {
var statearr_65466_65489 = state_65453__$1;
(statearr_65466_65489[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (11))){
var inst_65434 = (state_65453[(2)]);
var state_65453__$1 = state_65453;
var statearr_65467_65490 = state_65453__$1;
(statearr_65467_65490[(2)] = inst_65434);

(statearr_65467_65490[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (9))){
var inst_65418 = (state_65453[(12)]);
var state_65453__$1 = state_65453;
var statearr_65468_65491 = state_65453__$1;
(statearr_65468_65491[(2)] = inst_65418);

(statearr_65468_65491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (5))){
var inst_65438 = (state_65453[(10)]);
var inst_65438__$1 = (state_65453[(2)]);
var inst_65439 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_65440 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_65438__$1);
var state_65453__$1 = (function (){var statearr_65469 = state_65453;
(statearr_65469[(10)] = inst_65438__$1);

(statearr_65469[(13)] = inst_65439);

return statearr_65469;
})();
if(inst_65440){
var statearr_65470_65492 = state_65453__$1;
(statearr_65470_65492[(1)] = (12));

} else {
var statearr_65471_65493 = state_65453__$1;
(statearr_65471_65493[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (14))){
var inst_65451 = (state_65453[(2)]);
var state_65453__$1 = state_65453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65453__$1,inst_65451);
} else {
if((state_val_65454 === (10))){
var state_65453__$1 = state_65453;
var statearr_65472_65494 = state_65453__$1;
(statearr_65472_65494[(2)] = null);

(statearr_65472_65494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65454 === (8))){
var inst_65436 = (state_65453[(2)]);
var state_65453__$1 = state_65453;
var statearr_65473_65495 = state_65453__$1;
(statearr_65473_65495[(2)] = inst_65436);

(statearr_65473_65495[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0 = (function (){
var statearr_65474 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65474[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__);

(statearr_65474[(1)] = (1));

return statearr_65474;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1 = (function (state_65453){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65453);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65475){var ex__2730__auto__ = e65475;
var statearr_65476_65496 = state_65453;
(statearr_65476_65496[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65453[(4)]))){
var statearr_65477_65497 = state_65453;
(statearr_65477_65497[(1)] = cljs.core.first((state_65453[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65498 = state_65453;
state_65453 = G__65498;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__ = function(state_65453){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1.call(this,state_65453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65478 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65478[(6)] = c__2749__auto___65479);

return statearr_65478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__65500 = arguments.length;
switch (G__65500) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__65501){
var map__65502 = p__65501;
var map__65502__$1 = cljs.core.__destructure_map(map__65502);
var opts = map__65502__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65502__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65502__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65502__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65502__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65502__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2749__auto___65591 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65553){
var state_val_65554 = (state_65553[(1)]);
if((state_val_65554 === (7))){
var inst_65515 = (state_65553[(7)]);
var inst_65517 = fluree.db.api.ledger.syncTo_db(inst_65515,syncTo,syncTimeout);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65553__$1,(10),inst_65517);
} else {
if((state_val_65554 === (20))){
var inst_65539 = (state_65553[(8)]);
var state_65553__$1 = state_65553;
var statearr_65555_65592 = state_65553__$1;
(statearr_65555_65592[(2)] = inst_65539);

(statearr_65555_65592[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (1))){
var state_65553__$1 = state_65553;
var statearr_65556_65593 = state_65553__$1;
(statearr_65556_65593[(2)] = null);

(statearr_65556_65593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (4))){
var inst_65503 = (state_65553[(2)]);
var inst_65504 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65503);
var inst_65505 = cljs.core.async.close_BANG_(pc);
var state_65553__$1 = (function (){var statearr_65557 = state_65553;
(statearr_65557[(9)] = inst_65504);

return statearr_65557;
})();
var statearr_65558_65594 = state_65553__$1;
(statearr_65558_65594[(2)] = inst_65505);

(statearr_65558_65594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (15))){
var inst_65531 = (state_65553[(10)]);
var inst_65533 = fluree.db.api.ledger.add_db_permissions(inst_65531,auth,roles);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65553__$1,(18),inst_65533);
} else {
if((state_val_65554 === (21))){
var inst_65547 = (state_65553[(2)]);
var inst_65548 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65547);
var _ = (function (){var statearr_65559 = state_65553;
(statearr_65559[(4)] = cljs.core.rest((state_65553[(4)])));

return statearr_65559;
})();
var state_65553__$1 = state_65553;
var statearr_65560_65595 = state_65553__$1;
(statearr_65560_65595[(2)] = inst_65548);

(statearr_65560_65595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (13))){
var inst_65531 = (state_65553[(2)]);
var state_65553__$1 = (function (){var statearr_65561 = state_65553;
(statearr_65561[(10)] = inst_65531);

return statearr_65561;
})();
if(cljs.core.truth_(roles)){
var statearr_65562_65596 = state_65553__$1;
(statearr_65562_65596[(1)] = (15));

} else {
var statearr_65563_65597 = state_65553__$1;
(statearr_65563_65597[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (22))){
var inst_65543 = (state_65553[(2)]);
var inst_65544 = fluree.db.util.async.throw_err(inst_65543);
var state_65553__$1 = state_65553;
var statearr_65564_65598 = state_65553__$1;
(statearr_65564_65598[(2)] = inst_65544);

(statearr_65564_65598[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (6))){
var inst_65514 = (state_65553[(2)]);
var inst_65515 = fluree.db.util.async.throw_err(inst_65514);
var state_65553__$1 = (function (){var statearr_65565 = state_65553;
(statearr_65565[(7)] = inst_65515);

return statearr_65565;
})();
if(cljs.core.truth_(syncTo)){
var statearr_65566_65599 = state_65553__$1;
(statearr_65566_65599[(1)] = (7));

} else {
var statearr_65567_65600 = state_65553__$1;
(statearr_65567_65600[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (17))){
var inst_65539 = (state_65553[(2)]);
var state_65553__$1 = (function (){var statearr_65568 = state_65553;
(statearr_65568[(8)] = inst_65539);

return statearr_65568;
})();
if(cljs.core.truth_(auth)){
var statearr_65569_65601 = state_65553__$1;
(statearr_65569_65601[(1)] = (19));

} else {
var statearr_65570_65602 = state_65553__$1;
(statearr_65570_65602[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (3))){
var inst_65551 = (state_65553[(2)]);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65553__$1,inst_65551);
} else {
if((state_val_65554 === (12))){
var inst_65523 = (state_65553[(11)]);
var state_65553__$1 = state_65553;
var statearr_65571_65603 = state_65553__$1;
(statearr_65571_65603[(2)] = inst_65523);

(statearr_65571_65603[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (2))){
var _ = (function (){var statearr_65572 = state_65553;
(statearr_65572[(4)] = cljs.core.cons((5),(state_65553[(4)])));

return statearr_65572;
})();
var inst_65512 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65553__$1,(6),inst_65512);
} else {
if((state_val_65554 === (19))){
var inst_65539 = (state_65553[(8)]);
var inst_65541 = fluree.db.api.ledger.add_db_permissions(inst_65539,auth,roles);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65553__$1,(22),inst_65541);
} else {
if((state_val_65554 === (11))){
var inst_65523 = (state_65553[(11)]);
var inst_65525 = fluree.db.time_travel.as_of_block(inst_65523,block);
var state_65553__$1 = state_65553;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65553__$1,(14),inst_65525);
} else {
if((state_val_65554 === (9))){
var inst_65523 = (state_65553[(2)]);
var state_65553__$1 = (function (){var statearr_65574 = state_65553;
(statearr_65574[(11)] = inst_65523);

return statearr_65574;
})();
if(cljs.core.truth_(block)){
var statearr_65575_65604 = state_65553__$1;
(statearr_65575_65604[(1)] = (11));

} else {
var statearr_65576_65605 = state_65553__$1;
(statearr_65576_65605[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (5))){
var _ = (function (){var statearr_65577 = state_65553;
(statearr_65577[(4)] = cljs.core.rest((state_65553[(4)])));

return statearr_65577;
})();
var state_65553__$1 = state_65553;
var ex65573 = (state_65553__$1[(2)]);
var statearr_65578_65606 = state_65553__$1;
(statearr_65578_65606[(5)] = ex65573);


var statearr_65579_65607 = state_65553__$1;
(statearr_65579_65607[(1)] = (4));

(statearr_65579_65607[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (14))){
var inst_65527 = (state_65553[(2)]);
var inst_65528 = fluree.db.util.async.throw_err(inst_65527);
var state_65553__$1 = state_65553;
var statearr_65580_65608 = state_65553__$1;
(statearr_65580_65608[(2)] = inst_65528);

(statearr_65580_65608[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (16))){
var inst_65531 = (state_65553[(10)]);
var state_65553__$1 = state_65553;
var statearr_65581_65609 = state_65553__$1;
(statearr_65581_65609[(2)] = inst_65531);

(statearr_65581_65609[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (10))){
var inst_65519 = (state_65553[(2)]);
var inst_65520 = fluree.db.util.async.throw_err(inst_65519);
var state_65553__$1 = state_65553;
var statearr_65582_65610 = state_65553__$1;
(statearr_65582_65610[(2)] = inst_65520);

(statearr_65582_65610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (18))){
var inst_65535 = (state_65553[(2)]);
var inst_65536 = fluree.db.util.async.throw_err(inst_65535);
var state_65553__$1 = state_65553;
var statearr_65583_65611 = state_65553__$1;
(statearr_65583_65611[(2)] = inst_65536);

(statearr_65583_65611[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65554 === (8))){
var inst_65515 = (state_65553[(7)]);
var state_65553__$1 = state_65553;
var statearr_65584_65612 = state_65553__$1;
(statearr_65584_65612[(2)] = inst_65515);

(statearr_65584_65612[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2727__auto__ = null;
var fluree$db$api$ledger$state_machine__2727__auto____0 = (function (){
var statearr_65585 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65585[(0)] = fluree$db$api$ledger$state_machine__2727__auto__);

(statearr_65585[(1)] = (1));

return statearr_65585;
});
var fluree$db$api$ledger$state_machine__2727__auto____1 = (function (state_65553){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65553);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65586){var ex__2730__auto__ = e65586;
var statearr_65587_65613 = state_65553;
(statearr_65587_65613[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65553[(4)]))){
var statearr_65588_65614 = state_65553;
(statearr_65588_65614[(1)] = cljs.core.first((state_65553[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65615 = state_65553;
state_65553 = G__65615;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2727__auto__ = function(state_65553){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2727__auto____1.call(this,state_65553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2727__auto____0;
fluree$db$api$ledger$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2727__auto____1;
return fluree$db$api$ledger$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65589 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65589[(6)] = c__2749__auto___65591);

return statearr_65589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

