// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureeworker');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.session');
goog.require('fluree.db.connection');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.connection_js');
goog.require('goog.object');
goog.scope(function(){
flureeworker.goog$module$goog$object = goog.module.get('goog.object');
});
flureeworker.conn_register = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
flureeworker.postMessage = (function flureeworker$postMessage(message){
return self.postMessage(cljs.core.clj__GT_js(message));
});
flureeworker.conn_id__GT_db = (function flureeworker$conn_id__GT_db(conn_id,time){
var map__63605 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63605__$1 = cljs.core.__destructure_map(map__63605);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63605__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63605__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"block","block",664686210),time], null));
});
/**
 * Parses a (nested) JavaScript object into a Clojure map
 */
flureeworker.obj__GT_clj = (function flureeworker$obj__GT_clj(obj){
if(cljs.core.truth_(goog.isObject(obj))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (result,key){
var v = flureeworker.goog$module$goog$object.get.call(null,obj,key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("function",goog.typeOf(v))){
return result;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(result,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(key),(flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1 ? flureeworker.obj__GT_clj.cljs$core$IFn$_invoke$arity$1(v) : flureeworker.obj__GT_clj.call(null,v)));
}
}),cljs.core.PersistentArrayMap.EMPTY,goog.object.getKeys(obj));
} else {
return obj;
}
});
if((typeof flureeworker !== 'undefined') && (typeof flureeworker.worker_action !== 'undefined')){
} else {
flureeworker.worker_action = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__63606 = cljs.core.get_global_hierarchy;
return (fexpr__63606.cljs$core$IFn$_invoke$arity$0 ? fexpr__63606.cljs$core$IFn$_invoke$arity$0() : fexpr__63606.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("flureeworker","worker-action"),(function() { 
var G__63607__delegate = function (conn_id,event,_){
return event;
};
var G__63607 = function (conn_id,event,var_args){
var _ = null;
if (arguments.length > 2) {
var G__63608__i = 0, G__63608__a = new Array(arguments.length -  2);
while (G__63608__i < G__63608__a.length) {G__63608__a[G__63608__i] = arguments[G__63608__i + 2]; ++G__63608__i;}
  _ = new cljs.core.IndexedSeq(G__63608__a,0,null);
} 
return G__63607__delegate.call(this,conn_id,event,_);};
G__63607.cljs$lang$maxFixedArity = 2;
G__63607.cljs$lang$applyTo = (function (arglist__63609){
var conn_id = cljs.core.first(arglist__63609);
arglist__63609 = cljs.core.next(arglist__63609);
var event = cljs.core.first(arglist__63609);
var _ = cljs.core.rest(arglist__63609);
return G__63607__delegate(conn_id,event,_);
});
G__63607.cljs$core$IFn$_invoke$arity$variadic = G__63607__delegate;
return G__63607;
})()
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setState","setState",552299271),(function (conn_id,_,id,state_update){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setState",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(state_update)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connStatus","connStatus",63327857),(function (conn_id,_,id,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connStatus",new cljs.core.Keyword(null,"ref","ref",1289896967),id,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"login","login",55217519),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"login",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"pwGenerate",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connClosed","connClosed",1810797125),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connClosed",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connReset","connReset",-1382938159),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"connReset",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),response], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"setTransact","setTransact",1791803585),(function (conn_id,_,ref,response){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),"setTransact",new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),cljs.core.clj__GT_js(response)], null));
}));
flureeworker.worker_action.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"connInit","connInit",-148647574),(function (_,___$1){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"conn","conn",278309663),(0),new cljs.core.Keyword(null,"event","event",301435442),"connInit"], null));
}));
/**
 * Send an error map back to the worker invoker
 */
flureeworker.error_return_map = (function flureeworker$error_return_map(error){
var default_error = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),(function (){var or__4253__auto__ = cljs.core.ex_message(error);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown Error.";
}
})(),new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
var e_map = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([default_error,cljs.core.ex_data(error)], 0));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),e_map,new cljs.core.Keyword(null,"status","status",-1997798413),"error"], null);
});
/**
 * Process a query for a specific component id and return result with a :setState call.
 */
flureeworker.process_query = (function flureeworker$process_query(conn_id,id,conn_opts){
var flureeql = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),id], null));
var jwt = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null));
var opts_SINGLEQUOTE_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([conn_opts,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(flureeql)], 0)),new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt);
if(cljs.core.truth_(flureeql)){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63627){
var state_val_63628 = (state_63627[(1)]);
if((state_val_63628 === (1))){
var inst_63610 = new cljs.core.Keyword(null,"forceTime","forceTime",827124337).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var inst_63611 = flureeworker.conn_id__GT_db(conn_id,inst_63610);
var inst_63612 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeql,new cljs.core.Keyword(null,"opts","opts",155075701),opts_SINGLEQUOTE_);
var inst_63613 = fluree.db.api.query.query(inst_63611,inst_63612);
var state_63627__$1 = state_63627;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63627__$1,(2),inst_63613);
} else {
if((state_val_63628 === (2))){
var inst_63615 = (state_63627[(7)]);
var inst_63615__$1 = (state_63627[(2)]);
var inst_63616 = fluree.db.util.core.exception_QMARK_(inst_63615__$1);
var state_63627__$1 = (function (){var statearr_63629 = state_63627;
(statearr_63629[(7)] = inst_63615__$1);

return statearr_63629;
})();
if(inst_63616){
var statearr_63630_63643 = state_63627__$1;
(statearr_63630_63643[(1)] = (3));

} else {
var statearr_63631_63644 = state_63627__$1;
(statearr_63631_63644[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (3))){
var inst_63615 = (state_63627[(7)]);
var inst_63618 = flureeworker.error_return_map(inst_63615);
var state_63627__$1 = state_63627;
var statearr_63632_63645 = state_63627__$1;
(statearr_63632_63645[(2)] = inst_63618);

(statearr_63632_63645[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (4))){
var inst_63615 = (state_63627[(7)]);
var inst_63620 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_63621 = [inst_63615,"loaded"];
var inst_63622 = cljs.core.PersistentHashMap.fromArrays(inst_63620,inst_63621);
var state_63627__$1 = state_63627;
var statearr_63633_63646 = state_63627__$1;
(statearr_63633_63646[(2)] = inst_63622);

(statearr_63633_63646[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63628 === (5))){
var inst_63624 = (state_63627[(2)]);
var inst_63625 = (function (){var G__63634 = conn_id;
var G__63635 = new cljs.core.Keyword(null,"setState","setState",552299271);
var G__63636 = id;
var G__63637 = inst_63624;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63634,G__63635,G__63636,G__63637) : flureeworker.worker_action.call(null,G__63634,G__63635,G__63636,G__63637));
})();
var state_63627__$1 = state_63627;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63627__$1,inst_63625);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$process_query_$_state_machine__2741__auto__ = null;
var flureeworker$process_query_$_state_machine__2741__auto____0 = (function (){
var statearr_63638 = [null,null,null,null,null,null,null,null];
(statearr_63638[(0)] = flureeworker$process_query_$_state_machine__2741__auto__);

(statearr_63638[(1)] = (1));

return statearr_63638;
});
var flureeworker$process_query_$_state_machine__2741__auto____1 = (function (state_63627){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63627);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63639){var ex__2744__auto__ = e63639;
var statearr_63640_63647 = state_63627;
(statearr_63640_63647[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63627[(4)]))){
var statearr_63641_63648 = state_63627;
(statearr_63641_63648[(1)] = cljs.core.first((state_63627[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63649 = state_63627;
state_63627 = G__63649;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$process_query_$_state_machine__2741__auto__ = function(state_63627){
switch(arguments.length){
case 0:
return flureeworker$process_query_$_state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$process_query_$_state_machine__2741__auto____1.call(this,state_63627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$process_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$process_query_$_state_machine__2741__auto____0;
flureeworker$process_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$process_query_$_state_machine__2741__auto____1;
return flureeworker$process_query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63642 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63642[(6)] = c__2763__auto__);

return statearr_63642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
/**
 * Re-execute every registered query.
 */
flureeworker.process_all_queries = (function flureeworker$process_all_queries(conn_id){
var map__63650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63650__$1 = cljs.core.__destructure_map(map__63650);
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63650__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63650__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var query_ids = cljs.core.keys(queries);
var seq__63651 = cljs.core.seq(query_ids);
var chunk__63652 = null;
var count__63653 = (0);
var i__63654 = (0);
while(true){
if((i__63654 < count__63653)){
var id = chunk__63652.cljs$core$IIndexed$_nth$arity$2(null,i__63654);
flureeworker.process_query(conn_id,id,opts);


var G__63655 = seq__63651;
var G__63656 = chunk__63652;
var G__63657 = count__63653;
var G__63658 = (i__63654 + (1));
seq__63651 = G__63655;
chunk__63652 = G__63656;
count__63653 = G__63657;
i__63654 = G__63658;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__63651);
if(temp__5753__auto__){
var seq__63651__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__63651__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__63651__$1);
var G__63659 = cljs.core.chunk_rest(seq__63651__$1);
var G__63660 = c__4679__auto__;
var G__63661 = cljs.core.count(c__4679__auto__);
var G__63662 = (0);
seq__63651 = G__63659;
chunk__63652 = G__63660;
count__63653 = G__63661;
i__63654 = G__63662;
continue;
} else {
var id = cljs.core.first(seq__63651__$1);
flureeworker.process_query(conn_id,id,opts);


var G__63663 = cljs.core.next(seq__63651__$1);
var G__63664 = null;
var G__63665 = (0);
var G__63666 = (0);
seq__63651 = G__63663;
chunk__63652 = G__63664;
count__63653 = G__63665;
i__63654 = G__63666;
continue;
}
} else {
return null;
}
}
break;
}
});
flureeworker.ledger_listener = (function flureeworker$ledger_listener(conn,ledger,conn_id){
var vec__63667 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63667,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63667,(1),null);
var cb = (function (header,data){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63675){
var state_val_63676 = (state_63675[(1)]);
if((state_val_63676 === (1))){
var inst_63670 = cljs.core.async.timeout((100));
var state_63675__$1 = state_63675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63675__$1,(2),inst_63670);
} else {
if((state_val_63676 === (2))){
var inst_63672 = (state_63675[(2)]);
var inst_63673 = flureeworker.process_all_queries(conn_id);
var state_63675__$1 = (function (){var statearr_63677 = state_63675;
(statearr_63677[(7)] = inst_63672);

return statearr_63677;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63675__$1,inst_63673);
} else {
return null;
}
}
});
return (function() {
var flureeworker$ledger_listener_$_state_machine__2741__auto__ = null;
var flureeworker$ledger_listener_$_state_machine__2741__auto____0 = (function (){
var statearr_63678 = [null,null,null,null,null,null,null,null];
(statearr_63678[(0)] = flureeworker$ledger_listener_$_state_machine__2741__auto__);

(statearr_63678[(1)] = (1));

return statearr_63678;
});
var flureeworker$ledger_listener_$_state_machine__2741__auto____1 = (function (state_63675){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63675);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63679){var ex__2744__auto__ = e63679;
var statearr_63680_63683 = state_63675;
(statearr_63680_63683[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63675[(4)]))){
var statearr_63681_63684 = state_63675;
(statearr_63681_63684[(1)] = cljs.core.first((state_63675[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63685 = state_63675;
state_63675 = G__63685;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$ledger_listener_$_state_machine__2741__auto__ = function(state_63675){
switch(arguments.length){
case 0:
return flureeworker$ledger_listener_$_state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$ledger_listener_$_state_machine__2741__auto____1.call(this,state_63675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$ledger_listener_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$ledger_listener_$_state_machine__2741__auto____0;
flureeworker$ledger_listener_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$ledger_listener_$_state_machine__2741__auto____1;
return flureeworker$ledger_listener_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63682 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63682[(6)] = c__2763__auto__);

return statearr_63682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
return fluree.db.connection.add_listener(conn,network,ledger_id,conn_id,cb);
});
flureeworker.remove_conn_listener = (function flureeworker$remove_conn_listener(conn,conn_id,ledger){
var vec__63686 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63686,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63686,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,conn_id);
});
/**
 * Registers new connection with all of its items.
 */
flureeworker.register_connection = (function flureeworker$register_connection(conn,config,queries){
var map__63689 = config;
var map__63689__$1 = cljs.core.__destructure_map(map__63689);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var log = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"log","log",-1595516004));
var compact = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"compact","compact",-348732150));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63689__$1,new cljs.core.Keyword(null,"private","private",-558947994));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,id,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"closed","closed",-919675359),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"queries","queries",1446291995),new cljs.core.Keyword(null,"log","log",-1595516004),new cljs.core.Keyword(null,"conn","conn",278309663)],[false,ledger,private$,config,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"compact","compact",-348732150),compact], null),servers,(function (){var or__4253__auto__ = queries;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),log,conn]));
});
/**
 * Creates a new connection from existing configuration
 */
flureeworker.connect_STAR_ = (function flureeworker$connect_STAR_(conn_id,ref){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63690 = conn_data;
var map__63690__$1 = cljs.core.__destructure_map(map__63690);
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63690__$1,new cljs.core.Keyword(null,"config","config",994861415));
var queries = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63690__$1,new cljs.core.Keyword(null,"queries","queries",1446291995));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63690__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var map__63691 = config;
var map__63691__$1 = cljs.core.__destructure_map(map__63691);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63691__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63691__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63691__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63691__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63697){
var state_val_63698 = (state_63697[(1)]);
if((state_val_63698 === (1))){
var inst_63692 = cljs.core.async.timeout((100));
var state_63697__$1 = state_63697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63697__$1,(2),inst_63692);
} else {
if((state_val_63698 === (2))){
var inst_63694 = (state_63697[(2)]);
var inst_63695 = (flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2 ? flureeworker.connect_STAR_.cljs$core$IFn$_invoke$arity$2(id,ref) : flureeworker.connect_STAR_.call(null,id,ref));
var state_63697__$1 = (function (){var statearr_63699 = state_63697;
(statearr_63699[(7)] = inst_63694);

return statearr_63699;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63697__$1,inst_63695);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_STAR__$_state_machine__2741__auto__ = null;
var flureeworker$connect_STAR__$_state_machine__2741__auto____0 = (function (){
var statearr_63700 = [null,null,null,null,null,null,null,null];
(statearr_63700[(0)] = flureeworker$connect_STAR__$_state_machine__2741__auto__);

(statearr_63700[(1)] = (1));

return statearr_63700;
});
var flureeworker$connect_STAR__$_state_machine__2741__auto____1 = (function (state_63697){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63697);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63701){var ex__2744__auto__ = e63701;
var statearr_63702_63713 = state_63697;
(statearr_63702_63713[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63697[(4)]))){
var statearr_63703_63714 = state_63697;
(statearr_63703_63714[(1)] = cljs.core.first((state_63697[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63715 = state_63697;
state_63697 = G__63715;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$connect_STAR__$_state_machine__2741__auto__ = function(state_63697){
switch(arguments.length){
case 0:
return flureeworker$connect_STAR__$_state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$connect_STAR__$_state_machine__2741__auto____1.call(this,state_63697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_STAR__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_STAR__$_state_machine__2741__auto____0;
flureeworker$connect_STAR__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_STAR__$_state_machine__2741__auto____1;
return flureeworker$connect_STAR__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63704 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63704[(6)] = c__2763__auto__);

return statearr_63704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}):null);
var opts = cljs.core.assoc_in(config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
if(cljs.core.truth_(jwt)){
fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
} else {
}

flureeworker.register_connection(conn,config,queries);

flureeworker.ledger_listener(conn,ledger,id);

var G__63705_63716 = conn_id;
var G__63706_63717 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63707_63718 = ref;
var G__63708_63719 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection reset"], null);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63705_63716,G__63706_63717,G__63707_63718,G__63708_63719) : flureeworker.worker_action.call(null,G__63705_63716,G__63706_63717,G__63707_63718,G__63708_63719));

return flureeworker.process_all_queries(conn_id);
})).catch((function (error){
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(error);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(error)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error], 0))].join('')], null);
}
})();
var G__63709 = conn_id;
var G__63710 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63711 = ref;
var G__63712 = error_data;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63709,G__63710,G__63711,G__63712) : flureeworker.worker_action.call(null,G__63709,G__63710,G__63711,G__63712));
}));
});
flureeworker.close_connection_STAR_ = (function flureeworker$close_connection_STAR_(var_args){
var G__63721 = arguments.length;
switch (G__63721) {
case 1:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
return flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,false);
}));

(flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,save_config_QMARK_){
var conn_data = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63722 = conn_data;
var map__63722__$1 = cljs.core.__destructure_map(map__63722);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63722__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63722__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63722__$1,new cljs.core.Keyword(null,"config","config",994861415));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63722__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var new_config = (cljs.core.truth_(save_config_QMARK_)?new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"closed","closed",-919675359),true,new cljs.core.Keyword(null,"config","config",994861415),config,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"closed","closed",-919675359),true], null));
if((((conn_data == null)) || (new cljs.core.Keyword(null,"closed","closed",-919675359).cljs$core$IFn$_invoke$arity$1(conn_data) === true))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection doesn't exist, or is already closed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
flureeworker.remove_conn_listener(conn,conn_id,ledger);

fluree.db.connection_js.close(conn);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc,conn_id,new_config);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection closed."], null);
}
}));

(flureeworker.close_connection_STAR_.cljs$lang$maxFixedArity = 2);

flureeworker.close_connection = (function flureeworker$close_connection(conn_id,ref){
try{var G__63729 = conn_id;
var G__63730 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63731 = ref;
var G__63732 = flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$1(conn_id);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63729,G__63730,G__63731,G__63732) : flureeworker.worker_action.call(null,G__63729,G__63730,G__63731,G__63732));
}catch (e63724){var e = e63724;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63725 = conn_id;
var G__63726 = new cljs.core.Keyword(null,"connClosed","connClosed",1810797125);
var G__63727 = ref;
var G__63728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63725,G__63726,G__63727,G__63728) : flureeworker.worker_action.call(null,G__63725,G__63726,G__63727,G__63728));
}});
flureeworker.reset_connection = (function flureeworker$reset_connection(conn_id,ref){
try{var save_config_QMARK_ = true;
flureeworker.close_connection_STAR_.cljs$core$IFn$_invoke$arity$2(conn_id,save_config_QMARK_);

return flureeworker.connect_STAR_(conn_id,ref);
}catch (e63733){var e = e63733;
var msg = (function (){var or__4253__auto__ = cljs.core.ex_message(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unexpected error.";
}
})();
var data = (function (){var or__4253__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null);
}
})();
var G__63734 = conn_id;
var G__63735 = new cljs.core.Keyword(null,"connReset","connReset",-1382938159);
var G__63736 = ref;
var G__63737 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(data,new cljs.core.Keyword(null,"message","message",-406056002),msg);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63734,G__63735,G__63736,G__63737) : flureeworker.worker_action.call(null,G__63734,G__63735,G__63736,G__63737));
}});
/**
 * Open new connection to a Fluree instance
 */
flureeworker.connect_p = (function flureeworker$connect_p(config,ref){
var config_STAR_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(config,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__63738 = config_STAR_;
var map__63738__$1 = cljs.core.__destructure_map(map__63738);
var servers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63738__$1,new cljs.core.Keyword(null,"servers","servers",1881102005));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63738__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63738__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var keepAlive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63738__$1,new cljs.core.Keyword(null,"keepAlive","keepAlive",-12888007));
var _ = (cljs.core.truth_(new cljs.core.Keyword(null,"log","log",-1595516004).cljs$core$IFn$_invoke$arity$1(config_STAR_))?fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"finest","finest",-1359568890)):null);
var cb = (cljs.core.truth_(keepAlive)?(function (){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63744){
var state_val_63745 = (state_63744[(1)]);
if((state_val_63745 === (1))){
var inst_63739 = cljs.core.async.timeout((100));
var state_63744__$1 = state_63744;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63744__$1,(2),inst_63739);
} else {
if((state_val_63745 === (2))){
var inst_63741 = (state_63744[(2)]);
var inst_63742 = flureeworker.connect_STAR_(id,ref);
var state_63744__$1 = (function (){var statearr_63746 = state_63744;
(statearr_63746[(7)] = inst_63741);

return statearr_63746;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_63744__$1,inst_63742);
} else {
return null;
}
}
});
return (function() {
var flureeworker$connect_p_$_state_machine__2741__auto__ = null;
var flureeworker$connect_p_$_state_machine__2741__auto____0 = (function (){
var statearr_63747 = [null,null,null,null,null,null,null,null];
(statearr_63747[(0)] = flureeworker$connect_p_$_state_machine__2741__auto__);

(statearr_63747[(1)] = (1));

return statearr_63747;
});
var flureeworker$connect_p_$_state_machine__2741__auto____1 = (function (state_63744){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63744);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63748){var ex__2744__auto__ = e63748;
var statearr_63749_63760 = state_63744;
(statearr_63749_63760[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63744[(4)]))){
var statearr_63750_63761 = state_63744;
(statearr_63750_63761[(1)] = cljs.core.first((state_63744[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63762 = state_63744;
state_63744 = G__63762;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$connect_p_$_state_machine__2741__auto__ = function(state_63744){
switch(arguments.length){
case 0:
return flureeworker$connect_p_$_state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$connect_p_$_state_machine__2741__auto____1.call(this,state_63744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$connect_p_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$connect_p_$_state_machine__2741__auto____0;
flureeworker$connect_p_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$connect_p_$_state_machine__2741__auto____1;
return flureeworker$connect_p_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63751 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63751[(6)] = c__2763__auto__);

return statearr_63751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}):null);
var opts = cljs.core.assoc_in(config_STAR_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)], null),cb);
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers,opts).then((function (conn){
flureeworker.register_connection(conn,config_STAR_,null);

flureeworker.ledger_listener(conn,ledger,id);

var G__63752 = id;
var G__63753 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63754 = ref;
var G__63755 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"message","message",-406056002),"Connection is ready."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63752,G__63753,G__63754,G__63755) : flureeworker.worker_action.call(null,G__63752,G__63753,G__63754,G__63755));
})).catch((function (error){
var G__63756 = id;
var G__63757 = new cljs.core.Keyword(null,"connStatus","connStatus",63327857);
var G__63758 = ref;
var G__63759 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(error)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63756,G__63757,G__63758,G__63759) : flureeworker.worker_action.call(null,G__63756,G__63757,G__63758,G__63759));
}));
});
/**
 * Returns true if connection has been closed.
 */
flureeworker.conn_closed_QMARK_ = (function flureeworker$conn_closed_QMARK_(conn_id){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"closed","closed",-919675359)], null));
});
/**
 * Authenticate with ledger via username and password.
 * 
 * If authentication is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.login = (function flureeworker$login(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63830 = arguments.length;
var i__4865__auto___63831 = (0);
while(true){
if((i__4865__auto___63831 < len__4864__auto___63830)){
args__4870__auto__.push((arguments[i__4865__auto___63831]));

var G__63832 = (i__4865__auto___63831 + (1));
i__4865__auto___63831 = G__63832;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((4) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((4)),(0),null)):null);
return flureeworker.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4871__auto__);
});

(flureeworker.login.cljs$core$IFn$_invoke$arity$variadic = (function (conn_id,ref,username,password,p__63768){
var vec__63769 = p__63768;
var expire = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63769,(0),null);
var map__63772 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63772__$1 = cljs.core.__destructure_map(map__63772);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63772__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63772__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63772__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63773 = conn_id;
var G__63774 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63775 = ref;
var G__63776 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63773,G__63774,G__63775,G__63776) : flureeworker.worker_action.call(null,G__63773,G__63774,G__63775,G__63776));
})());
var auth = null;
var c__2763__auto___63833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63797){
var state_val_63798 = (state_63797[(1)]);
if((state_val_63798 === (1))){
var state_63797__$1 = state_63797;
var statearr_63799_63834 = state_63797__$1;
(statearr_63799_63834[(2)] = null);

(statearr_63799_63834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63798 === (2))){
var ___$1 = (function (){var statearr_63800 = state_63797;
(statearr_63800[(4)] = cljs.core.cons((5),(state_63797[(4)])));

return statearr_63800;
})();
var inst_63788 = fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,username,auth,expire);
var inst_63789 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63801 = conn_id;
var G__63802 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63803 = ref;
var G__63804 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63801,G__63802,G__63803,G__63804) : flureeworker.worker_action.call(null,G__63801,G__63802,G__63803,G__63804));
});
})();
var inst_63790 = inst_63788.then(inst_63789);
var inst_63791 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63805){var ___$2 = e63805;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Authentication failed: unknown authentication error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63806 = conn_id;
var G__63807 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63808 = ref;
var G__63809 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63806,G__63807,G__63808,G__63809) : flureeworker.worker_action.call(null,G__63806,G__63807,G__63808,G__63809));
} else {
var G__63810 = conn_id;
var G__63811 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63812 = ref;
var G__63813 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Authentication failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63810,G__63811,G__63812,G__63813) : flureeworker.worker_action.call(null,G__63810,G__63811,G__63812,G__63813));

}
});
})();
var inst_63792 = inst_63790.catch(inst_63791);
var ___$2 = (function (){var statearr_63814 = state_63797;
(statearr_63814[(4)] = cljs.core.rest((state_63797[(4)])));

return statearr_63814;
})();
var state_63797__$1 = state_63797;
var statearr_63815_63835 = state_63797__$1;
(statearr_63815_63835[(2)] = inst_63792);

(statearr_63815_63835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63798 === (3))){
var inst_63795 = (state_63797[(2)]);
var state_63797__$1 = state_63797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63797__$1,inst_63795);
} else {
if((state_val_63798 === (4))){
var inst_63777 = (state_63797[(2)]);
var inst_63778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63779 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63777);
var inst_63780 = [(400),inst_63779];
var inst_63781 = cljs.core.PersistentHashMap.fromArrays(inst_63778,inst_63780);
var inst_63782 = (function (){var G__63817 = conn_id;
var G__63818 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63819 = ref;
var G__63820 = inst_63781;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63817,G__63818,G__63819,G__63820) : flureeworker.worker_action.call(null,G__63817,G__63818,G__63819,G__63820));
})();
var state_63797__$1 = state_63797;
var statearr_63821_63836 = state_63797__$1;
(statearr_63821_63836[(2)] = inst_63782);

(statearr_63821_63836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63798 === (5))){
var ___$1 = (function (){var statearr_63822 = state_63797;
(statearr_63822[(4)] = cljs.core.rest((state_63797[(4)])));

return statearr_63822;
})();
var state_63797__$1 = state_63797;
var ex63816 = (state_63797__$1[(2)]);
var statearr_63823_63837 = state_63797__$1;
(statearr_63823_63837[(5)] = ex63816);


var statearr_63824_63838 = state_63797__$1;
(statearr_63824_63838[(1)] = (4));

(statearr_63824_63838[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$state_machine__2741__auto__ = null;
var flureeworker$state_machine__2741__auto____0 = (function (){
var statearr_63825 = [null,null,null,null,null,null,null];
(statearr_63825[(0)] = flureeworker$state_machine__2741__auto__);

(statearr_63825[(1)] = (1));

return statearr_63825;
});
var flureeworker$state_machine__2741__auto____1 = (function (state_63797){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63797);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63826){var ex__2744__auto__ = e63826;
var statearr_63827_63839 = state_63797;
(statearr_63827_63839[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63797[(4)]))){
var statearr_63828_63840 = state_63797;
(statearr_63828_63840[(1)] = cljs.core.first((state_63797[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63841 = state_63797;
state_63797 = G__63841;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$state_machine__2741__auto__ = function(state_63797){
switch(arguments.length){
case 0:
return flureeworker$state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$state_machine__2741__auto____1.call(this,state_63797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$state_machine__2741__auto____0;
flureeworker$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$state_machine__2741__auto____1;
return flureeworker$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63829 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63829[(6)] = c__2763__auto___63833);

return statearr_63829;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return true;
}));

(flureeworker.login.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(flureeworker.login.cljs$lang$applyTo = (function (seq63763){
var G__63764 = cljs.core.first(seq63763);
var seq63763__$1 = cljs.core.next(seq63763);
var G__63765 = cljs.core.first(seq63763__$1);
var seq63763__$2 = cljs.core.next(seq63763__$1);
var G__63766 = cljs.core.first(seq63763__$2);
var seq63763__$3 = cljs.core.next(seq63763__$2);
var G__63767 = cljs.core.first(seq63763__$3);
var seq63763__$4 = cljs.core.next(seq63763__$3);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63764,G__63765,G__63766,G__63767,seq63763__$4);
}));

/**
 * Attempts to generate a new user auth record account.
 * 
 * If request is successful, a 200 status is returned with a JSON web token.
 * Otherwise, an error status is returned.
 */
flureeworker.pw_generate = (function flureeworker$pw_generate(conn_id,ref,map_data){
var map__63842 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),conn_id);
var map__63842__$1 = cljs.core.__destructure_map(map__63842);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63842__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var ledger = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63842__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706));
var _ = (cljs.core.truth_(ledger)?null:(function (){var G__63844 = conn_id;
var G__63845 = new cljs.core.Keyword(null,"login","login",55217519);
var G__63846 = ref;
var G__63847 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"message","message",-406056002),"Connection missing Ledger information. Password authentication is specific to a ledger."], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63844,G__63845,G__63846,G__63847) : flureeworker.worker_action.call(null,G__63844,G__63845,G__63846,G__63847));
})());
var map__63843 = map_data;
var map__63843__$1 = cljs.core.__destructure_map(map__63843);
var username = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63843__$1,new cljs.core.Keyword(null,"username","username",1605666410));
var password = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63843__$1,new cljs.core.Keyword(null,"password","password",417022471));
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63843__$1,new cljs.core.Keyword(null,"options","options",99638489));
var opts = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.select_keys(options,cljs.core.keys(options)),new cljs.core.Keyword(null,"user","user",1532431356),username);
var c__2763__auto___63901 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63868){
var state_val_63869 = (state_63868[(1)]);
if((state_val_63869 === (1))){
var state_63868__$1 = state_63868;
var statearr_63870_63902 = state_63868__$1;
(statearr_63870_63902[(2)] = null);

(statearr_63870_63902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63869 === (2))){
var ___$1 = (function (){var statearr_63871 = state_63868;
(statearr_63871[(4)] = cljs.core.cons((5),(state_63868[(4)])));

return statearr_63871;
})();
var inst_63859 = fluree.db.connection_js.password_generate(conn,ledger,password,opts);
var inst_63860 = (function (){return (function (token){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(flureeworker.conn_register,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),token);

var G__63872 = conn_id;
var G__63873 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63874 = ref;
var G__63875 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(200),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"username","username",1605666410),username,new cljs.core.Keyword(null,"token","token",-1211463215),token], null)], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63872,G__63873,G__63874,G__63875) : flureeworker.worker_action.call(null,G__63872,G__63873,G__63874,G__63875));
});
})();
var inst_63861 = inst_63859.then(inst_63860);
var inst_63862 = (function (){return (function (resp){
var err = (function (){try{return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
}catch (e63876){var ___$2 = e63876;
return null;
}})();
var status = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err);
if((!((status == null)))){
var message = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Password Generation failed: unknown error";
}
})();
var error = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})();
var G__63877 = conn_id;
var G__63878 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63879 = ref;
var G__63880 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"message","message",-406056002),message,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63877,G__63878,G__63879,G__63880) : flureeworker.worker_action.call(null,G__63877,G__63878,G__63879,G__63880));
} else {
var G__63881 = conn_id;
var G__63882 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63883 = ref;
var G__63884 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"message","message",-406056002),["Password Generation failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp)].join('')], null);
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63881,G__63882,G__63883,G__63884) : flureeworker.worker_action.call(null,G__63881,G__63882,G__63883,G__63884));

}
});
})();
var inst_63863 = inst_63861.catch(inst_63862);
var ___$2 = (function (){var statearr_63885 = state_63868;
(statearr_63885[(4)] = cljs.core.rest((state_63868[(4)])));

return statearr_63885;
})();
var state_63868__$1 = state_63868;
var statearr_63886_63903 = state_63868__$1;
(statearr_63886_63903[(2)] = inst_63863);

(statearr_63886_63903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63869 === (3))){
var inst_63866 = (state_63868[(2)]);
var state_63868__$1 = state_63868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63868__$1,inst_63866);
} else {
if((state_val_63869 === (4))){
var inst_63848 = (state_63868[(2)]);
var inst_63849 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63850 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_63848);
var inst_63851 = [(400),inst_63850];
var inst_63852 = cljs.core.PersistentHashMap.fromArrays(inst_63849,inst_63851);
var inst_63853 = (function (){var G__63888 = conn_id;
var G__63889 = new cljs.core.Keyword(null,"pwGenerate","pwGenerate",309381360);
var G__63890 = ref;
var G__63891 = inst_63852;
return (flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$4(G__63888,G__63889,G__63890,G__63891) : flureeworker.worker_action.call(null,G__63888,G__63889,G__63890,G__63891));
})();
var state_63868__$1 = state_63868;
var statearr_63892_63904 = state_63868__$1;
(statearr_63892_63904[(2)] = inst_63853);

(statearr_63892_63904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63869 === (5))){
var ___$1 = (function (){var statearr_63893 = state_63868;
(statearr_63893[(4)] = cljs.core.rest((state_63868[(4)])));

return statearr_63893;
})();
var state_63868__$1 = state_63868;
var ex63887 = (state_63868__$1[(2)]);
var statearr_63894_63905 = state_63868__$1;
(statearr_63894_63905[(5)] = ex63887);


var statearr_63895_63906 = state_63868__$1;
(statearr_63895_63906[(1)] = (4));

(statearr_63895_63906[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureeworker$pw_generate_$_state_machine__2741__auto__ = null;
var flureeworker$pw_generate_$_state_machine__2741__auto____0 = (function (){
var statearr_63896 = [null,null,null,null,null,null,null];
(statearr_63896[(0)] = flureeworker$pw_generate_$_state_machine__2741__auto__);

(statearr_63896[(1)] = (1));

return statearr_63896;
});
var flureeworker$pw_generate_$_state_machine__2741__auto____1 = (function (state_63868){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63868);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63897){var ex__2744__auto__ = e63897;
var statearr_63898_63907 = state_63868;
(statearr_63898_63907[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63868[(4)]))){
var statearr_63899_63908 = state_63868;
(statearr_63899_63908[(1)] = cljs.core.first((state_63868[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63909 = state_63868;
state_63868 = G__63909;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureeworker$pw_generate_$_state_machine__2741__auto__ = function(state_63868){
switch(arguments.length){
case 0:
return flureeworker$pw_generate_$_state_machine__2741__auto____0.call(this);
case 1:
return flureeworker$pw_generate_$_state_machine__2741__auto____1.call(this,state_63868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureeworker$pw_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureeworker$pw_generate_$_state_machine__2741__auto____0;
flureeworker$pw_generate_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureeworker$pw_generate_$_state_machine__2741__auto____1;
return flureeworker$pw_generate_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63900 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63900[(6)] = c__2763__auto___63901);

return statearr_63900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return true;
});
flureeworker.unregisterQuery = (function flureeworker$unregisterQuery(conn_id,ref){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref], 0));
});
/**
 * Registers a new flureeQL query. 'opts' gets merged in with the flureeQL.opts, and is there
 *   to ease adding options to a GraphQL (and later other string-based queries like SPARQL and SQL),
 *   which do not have the same ability to dynamically add options.
 */
flureeworker.registerQuery = (function flureeworker$registerQuery(conn_id,ref,js_flurql,force_update_QMARK_){
var flureeQL = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(js_flurql,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(flureeQL,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995),ref], null)))) || (force_update_QMARK_ === true))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(flureeworker.conn_register,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"queries","queries",1446291995)], null),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ref,flureeQL], 0));

flureeworker.process_query(conn_id,ref,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(flureeworker.conn_register),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"opts","opts",155075701)], null)));
} else {
}

return true;
});
/**
 * Submits a transaction across a websocket to a fluree instance
 */
flureeworker.transact = (function flureeworker$transact(conn_id,ref,map_data){
return new cljs.core.Keyword(null,"TODO","TODO",-523795145);
});
/**
 * Takes javascript array and move it into a clojurescript list without
 *   converting individual elements.
 */
flureeworker.js_array__GT_clj_list = (function flureeworker$js_array__GT_clj_list(js_array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__63910_SHARP_){
return (js_array[p1__63910_SHARP_]);
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(js_array.length));
});
/**
 * Main handler function for worker events
 *   Even data is a javascript object with the following keys:
 *   - action - the action to perform
 *   - params - parameters for the action we are calling
 *   - conn - the connection ID
 *   - ref - the reference ID to include in the response
 *   
 */
flureeworker.decode_message = (function flureeworker$decode_message(event){
try{var data = (event["data"]);
var action_str = (data["action"]);
var conn_id = (data["conn"]);
var ref = (data["ref"]);
var params_js = (data["params"]);
var params = ((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact"))))?flureeworker.obj__GT_clj(cljs.core.first(params_js)):flureeworker.js_array__GT_clj_list(params_js)
);
if(cljs.core.truth_(flureeworker.conn_closed_QMARK_(conn_id))){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),conn_id,new cljs.core.Keyword(null,"event","event",301435442),action_str,new cljs.core.Keyword(null,"ref","ref",1289896967),ref,new cljs.core.Keyword(null,"data","data",-232669377),({"status": (400), "message": "Connection has been closed."})], null));
} else {
return null;
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"connect")){
return flureeworker.connect_p(cljs.core.first(params),ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"close")){
return flureeworker.close_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"reset")){
return flureeworker.reset_connection(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"registerQuery")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(flureeworker.registerQuery,conn_id,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"unregisterQuery")){
return flureeworker.unregisterQuery(conn_id,ref);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"login")){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(flureeworker.login,conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"pwGenerate")){
return flureeworker.pw_generate(conn_id,ref,params);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(action_str,"transact")){
return flureeworker.transact(conn_id,ref,params);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unknown action: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(action_str)].join(''),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"status","status",-1997798413),(400)], null));

}
}
}
}
}
}
}
}
}
}catch (e63911){var e = e63911;
var data = (event["data"]);
var error_data = (function (){var temp__5751__auto__ = cljs.core.ex_data(e);
if(cljs.core.truth_(temp__5751__auto__)){
var ex_data = temp__5751__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(ex_data);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (500);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(e)], null),ex_data], 0));
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"message","message",-406056002),["Unexpected error: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0))].join('')], null);
}
})();
console.error("Error executing message:",data);

console.error(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0)));

return flureeworker.postMessage(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"conn","conn",278309663),(data["conn"]),new cljs.core.Keyword(null,"event","event",301435442),(data["action"]),new cljs.core.Keyword(null,"ref","ref",1289896967),(data["ref"]),new cljs.core.Keyword(null,"data","data",-232669377),error_data], null));
}});
/**
 * Log errors in this web worker
 */
flureeworker.log_error = (function flureeworker$log_error(error){
return console.error(error);
});
var temp__5753__auto___63912 = cljs.core.not(self.document);
if(temp__5753__auto___63912){
var worker_QMARK__63913 = temp__5753__auto___63912;
(self.onerror = flureeworker.log_error);

(self.onmessage = flureeworker.decode_message);
} else {
}
var G__63914_63916 = null;
var G__63915_63917 = new cljs.core.Keyword(null,"connInit","connInit",-148647574);
(flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2 ? flureeworker.worker_action.cljs$core$IFn$_invoke$arity$2(G__63914_63916,G__63915_63917) : flureeworker.worker_action.call(null,G__63914_63916,G__63915_63917));
