// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k28024,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__28028 = k28024;
var G__28028__$1 = (((G__28028 instanceof cljs.core.Keyword))?G__28028.fqn:null);
switch (G__28028__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28024,else__4505__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__28029){
var vec__28030 = p__28029;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28030,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28030,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28023){
var self__ = this;
var G__28023__$1 = this;
return (new cljs.core.RecordIter((0),G__28023__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__28033 = (function (coll__4499__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__28033(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28025,other28026){
var self__ = this;
var this28025__$1 = this;
return (((!((other28026 == null)))) && ((((this28025__$1.constructor === other28026.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.conn,other28026.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.network,other28026.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.dbid,other28026.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.db_name,other28026.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.update_chan,other28026.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.transact_chan,other28026.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.state,other28026.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.schema_cache,other28026.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.blank_db,other28026.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.close,other28026.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.id,other28026.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28025__$1.__extmap,other28026.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k28024){
var self__ = this;
var this__4509__auto____$1 = this;
var G__28034 = k28024;
var G__28034__$1 = (((G__28034 instanceof cljs.core.Keyword))?G__28034.fqn:null);
switch (G__28034__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28024);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__28023){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__28035 = cljs.core.keyword_identical_QMARK_;
var expr__28036 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__28038 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__28039 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28038,G__28039) : pred__28035.call(null,G__28038,G__28039));
})())){
return (new fluree.db.session.DbSession(G__28023,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28040 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__28041 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28040,G__28041) : pred__28035.call(null,G__28040,G__28041));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__28023,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28042 = new cljs.core.Keyword(null,"dbid","dbid",-196647356);
var G__28043 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28042,G__28043) : pred__28035.call(null,G__28042,G__28043));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__28023,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28044 = new cljs.core.Keyword(null,"db-name","db-name",1157928745);
var G__28045 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28044,G__28045) : pred__28035.call(null,G__28044,G__28045));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__28023,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28046 = new cljs.core.Keyword(null,"update-chan","update-chan",-863760792);
var G__28047 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28046,G__28047) : pred__28035.call(null,G__28046,G__28047));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__28023,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28048 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840);
var G__28049 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28048,G__28049) : pred__28035.call(null,G__28048,G__28049));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__28023,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28050 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__28051 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28050,G__28051) : pred__28035.call(null,G__28050,G__28051));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__28023,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28052 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__28053 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28052,G__28053) : pred__28035.call(null,G__28052,G__28053));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__28023,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28054 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534);
var G__28055 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28054,G__28055) : pred__28035.call(null,G__28054,G__28055));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__28023,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28056 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__28057 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28056,G__28057) : pred__28035.call(null,G__28056,G__28057));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__28023,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28058 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__28059 = expr__28036;
return (pred__28035.cljs$core$IFn$_invoke$arity$2 ? pred__28035.cljs$core$IFn$_invoke$arity$2(G__28058,G__28059) : pred__28035.call(null,G__28058,G__28059));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__28023,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__28023),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__28023){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__28023,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__28027){
var extmap__4542__auto__ = (function (){var G__28060 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28027,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], 0));
if(cljs.core.record_QMARK_(G__28027)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28060);
} else {
return G__28060;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__28027),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__28027),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__28063 = session;
var map__28063__$1 = cljs.core.__destructure_map(map__28063);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28063__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28063__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___28214 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28166){
var state_val_28167 = (state_28166[(1)]);
if((state_val_28167 === (7))){
var inst_28084 = (state_28166[(7)]);
var inst_28089 = cljs.core.empty_QMARK_(inst_28084);
var state_28166__$1 = state_28166;
if(inst_28089){
var statearr_28168_28215 = state_28166__$1;
(statearr_28168_28215[(1)] = (10));

} else {
var statearr_28169_28216 = state_28166__$1;
(statearr_28169_28216[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (20))){
var inst_28076 = (state_28166[(8)]);
var inst_28075 = (state_28166[(9)]);
var inst_28115 = (state_28166[(10)]);
var inst_28077 = (state_28166[(11)]);
var inst_28120 = fluree.db.storage.core.read_block(inst_28075,inst_28076,inst_28077,inst_28115);
var state_28166__$1 = state_28166;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(22),inst_28120);
} else {
if((state_val_28167 === (27))){
var inst_28153 = (state_28166[(12)]);
var inst_28155 = (state_28166[(2)]);
var inst_28156 = fluree.db.util.async.throw_err(inst_28155);
var state_28166__$1 = (function (){var statearr_28170 = state_28166;
(statearr_28170[(13)] = inst_28156);

return statearr_28170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(28),inst_28153);
} else {
if((state_val_28167 === (1))){
var state_28166__$1 = state_28166;
var statearr_28171_28217 = state_28166__$1;
(statearr_28171_28217[(2)] = null);

(statearr_28171_28217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (24))){
var inst_28076 = (state_28166[(8)]);
var inst_28115 = (state_28166[(10)]);
var inst_28077 = (state_28166[(11)]);
var inst_28137 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28115)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28077),"."].join('');
var inst_28138 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28139 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_28140 = cljs.core.PersistentHashMap.fromArrays(inst_28138,inst_28139);
var inst_28141 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28137,inst_28140);
var inst_28142 = (function(){throw inst_28141})();
var state_28166__$1 = state_28166;
var statearr_28172_28218 = state_28166__$1;
(statearr_28172_28218[(2)] = inst_28142);

(statearr_28172_28218[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (4))){
var inst_28064 = (state_28166[(2)]);
var inst_28065 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28064);
var state_28166__$1 = state_28166;
var statearr_28173_28219 = state_28166__$1;
(statearr_28173_28219[(2)] = inst_28065);

(statearr_28173_28219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (15))){
var state_28166__$1 = state_28166;
var statearr_28174_28220 = state_28166__$1;
(statearr_28174_28220[(2)] = null);

(statearr_28174_28220[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (21))){
var inst_28146 = (state_28166[(2)]);
var state_28166__$1 = state_28166;
var statearr_28175_28221 = state_28166__$1;
(statearr_28175_28221[(2)] = inst_28146);

(statearr_28175_28221[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (13))){
var inst_28084 = (state_28166[(7)]);
var inst_28109 = (state_28166[(14)]);
var inst_28108 = (state_28166[(2)]);
var inst_28109__$1 = fluree.db.util.async.throw_err(inst_28108);
var inst_28110 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28084);
var state_28166__$1 = (function (){var statearr_28176 = state_28166;
(statearr_28176[(15)] = inst_28110);

(statearr_28176[(14)] = inst_28109__$1);

return statearr_28176;
})();
if(cljs.core.truth_(inst_28109__$1)){
var statearr_28177_28222 = state_28166__$1;
(statearr_28177_28222[(1)] = (14));

} else {
var statearr_28178_28223 = state_28166__$1;
(statearr_28178_28223[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (22))){
var inst_28123 = (state_28166[(16)]);
var inst_28122 = (state_28166[(2)]);
var inst_28123__$1 = fluree.db.util.async.throw_err(inst_28122);
var state_28166__$1 = (function (){var statearr_28179 = state_28166;
(statearr_28179[(16)] = inst_28123__$1);

return statearr_28179;
})();
if(cljs.core.truth_(inst_28123__$1)){
var statearr_28180_28224 = state_28166__$1;
(statearr_28180_28224[(1)] = (23));

} else {
var statearr_28181_28225 = state_28166__$1;
(statearr_28181_28225[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (6))){
var inst_28084 = (state_28166[(7)]);
var inst_28083 = (state_28166[(2)]);
var inst_28084__$1 = fluree.db.util.async.throw_err(inst_28083);
var inst_28085 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28084__$1);
var inst_28086 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_28085);
var inst_28087 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ready","ready",1086465795),inst_28086);
var state_28166__$1 = (function (){var statearr_28182 = state_28166;
(statearr_28182[(7)] = inst_28084__$1);

return statearr_28182;
})();
if(inst_28087){
var statearr_28183_28226 = state_28166__$1;
(statearr_28183_28226[(1)] = (7));

} else {
var statearr_28184_28227 = state_28166__$1;
(statearr_28184_28227[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (28))){
var inst_28151 = (state_28166[(17)]);
var inst_28156 = (state_28166[(13)]);
var inst_28158 = (state_28166[(2)]);
var inst_28159 = fluree.db.util.async.throw_err(inst_28158);
var inst_28160 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28151,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_28156,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"settings","settings",1556144875),inst_28159], 0));
var inst_28161 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_28160);
var _ = (function (){var statearr_28185 = state_28166;
(statearr_28185[(4)] = cljs.core.rest((state_28166[(4)])));

return statearr_28185;
})();
var state_28166__$1 = state_28166;
var statearr_28186_28228 = state_28166__$1;
(statearr_28186_28228[(2)] = inst_28161);

(statearr_28186_28228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (25))){
var inst_28144 = (state_28166[(2)]);
var state_28166__$1 = state_28166;
var statearr_28187_28229 = state_28166__$1;
(statearr_28187_28229[(2)] = inst_28144);

(statearr_28187_28229[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (17))){
var inst_28110 = (state_28166[(15)]);
var inst_28115 = (state_28166[(10)]);
var inst_28117 = (inst_28115 > inst_28110);
var state_28166__$1 = state_28166;
if(cljs.core.truth_(inst_28117)){
var statearr_28188_28230 = state_28166__$1;
(statearr_28188_28230[(1)] = (19));

} else {
var statearr_28189_28231 = state_28166__$1;
(statearr_28189_28231[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (3))){
var inst_28164 = (state_28166[(2)]);
var state_28166__$1 = state_28166;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28166__$1,inst_28164);
} else {
if((state_val_28167 === (12))){
var inst_28096 = (state_28166[(2)]);
var inst_28097 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_28098 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_28099 = cljs.core.PersistentHashMap.fromArrays(inst_28097,inst_28098);
var inst_28100 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28096,inst_28099);
var inst_28101 = (function(){throw inst_28100})();
var state_28166__$1 = state_28166;
var statearr_28190_28232 = state_28166__$1;
(statearr_28190_28232[(2)] = inst_28101);

(statearr_28190_28232[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (2))){
var inst_28076 = (state_28166[(8)]);
var inst_28075 = (state_28166[(9)]);
var inst_28077 = (state_28166[(11)]);
var _ = (function (){var statearr_28191 = state_28166;
(statearr_28191[(4)] = cljs.core.cons((5),(state_28166[(4)])));

return statearr_28191;
})();
var inst_28072 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_28073 = session;
var inst_28074 = cljs.core.__destructure_map(inst_28073);
var inst_28075__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28074,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_28076__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28074,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_28077__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28074,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_28078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28079 = [inst_28076__$1,inst_28077__$1];
var inst_28080 = (new cljs.core.PersistentVector(null,2,(5),inst_28078,inst_28079,null));
var inst_28081 = fluree.db.operations.ledger_info_async(inst_28075__$1,inst_28080);
var state_28166__$1 = (function (){var statearr_28192 = state_28166;
(statearr_28192[(8)] = inst_28076__$1);

(statearr_28192[(9)] = inst_28075__$1);

(statearr_28192[(11)] = inst_28077__$1);

(statearr_28192[(18)] = inst_28072);

return statearr_28192;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(6),inst_28081);
} else {
if((state_val_28167 === (23))){
var inst_28123 = (state_28166[(16)]);
var inst_28114 = (state_28166[(19)]);
var inst_28126 = cljs.core.__destructure_map(inst_28123);
var inst_28127 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28126,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_28128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28126,new cljs.core.Keyword(null,"block","block",664686210));
var inst_28129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28126,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_28130 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28114,inst_28128,inst_28127);
var state_28166__$1 = (function (){var statearr_28193 = state_28166;
(statearr_28193[(20)] = inst_28129);

return statearr_28193;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(26),inst_28130);
} else {
if((state_val_28167 === (19))){
var inst_28114 = (state_28166[(19)]);
var state_28166__$1 = state_28166;
var statearr_28194_28233 = state_28166__$1;
(statearr_28194_28233[(2)] = inst_28114);

(statearr_28194_28233[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (11))){
var inst_28084 = (state_28166[(7)]);
var inst_28076 = (state_28166[(8)]);
var inst_28077 = (state_28166[(11)]);
var inst_28093 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_28084);
var inst_28094 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28077)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28093),"."].join('');
var state_28166__$1 = state_28166;
var statearr_28196_28234 = state_28166__$1;
(statearr_28196_28234[(2)] = inst_28094);

(statearr_28196_28234[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (9))){
var inst_28084 = (state_28166[(7)]);
var inst_28076 = (state_28166[(8)]);
var inst_28075 = (state_28166[(9)]);
var inst_28077 = (state_28166[(11)]);
var inst_28072 = (state_28166[(18)]);
var inst_28104 = (state_28166[(2)]);
var inst_28105 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_28084);
var inst_28106 = fluree.db.storage.core.reify_db(inst_28075,inst_28076,inst_28077,inst_28072,inst_28105);
var state_28166__$1 = (function (){var statearr_28197 = state_28166;
(statearr_28197[(21)] = inst_28104);

return statearr_28197;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(13),inst_28106);
} else {
if((state_val_28167 === (5))){
var _ = (function (){var statearr_28198 = state_28166;
(statearr_28198[(4)] = cljs.core.rest((state_28166[(4)])));

return statearr_28198;
})();
var state_28166__$1 = state_28166;
var ex28195 = (state_28166__$1[(2)]);
var statearr_28199_28235 = state_28166__$1;
(statearr_28199_28235[(5)] = ex28195);


var statearr_28200_28236 = state_28166__$1;
(statearr_28200_28236[(1)] = (4));

(statearr_28200_28236[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (14))){
var inst_28109 = (state_28166[(14)]);
var inst_28112 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28109);
var inst_28113 = (inst_28112 + (1));
var inst_28114 = inst_28109;
var inst_28115 = inst_28113;
var state_28166__$1 = (function (){var statearr_28201 = state_28166;
(statearr_28201[(10)] = inst_28115);

(statearr_28201[(19)] = inst_28114);

return statearr_28201;
})();
var statearr_28202_28237 = state_28166__$1;
(statearr_28202_28237[(2)] = null);

(statearr_28202_28237[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (26))){
var inst_28115 = (state_28166[(10)]);
var inst_28132 = (state_28166[(2)]);
var inst_28133 = fluree.db.util.async.throw_err(inst_28132);
var inst_28134 = (inst_28115 + (1));
var inst_28114 = inst_28133;
var inst_28115__$1 = inst_28134;
var state_28166__$1 = (function (){var statearr_28203 = state_28166;
(statearr_28203[(10)] = inst_28115__$1);

(statearr_28203[(19)] = inst_28114);

return statearr_28203;
})();
var statearr_28204_28238 = state_28166__$1;
(statearr_28204_28238[(2)] = null);

(statearr_28204_28238[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (16))){
var inst_28151 = (state_28166[(17)]);
var inst_28151__$1 = (state_28166[(2)]);
var inst_28152 = fluree.db.query.schema.schema_map(inst_28151__$1);
var inst_28153 = fluree.db.query.schema.setting_map(inst_28151__$1);
var state_28166__$1 = (function (){var statearr_28205 = state_28166;
(statearr_28205[(17)] = inst_28151__$1);

(statearr_28205[(12)] = inst_28153);

return statearr_28205;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28166__$1,(27),inst_28152);
} else {
if((state_val_28167 === (10))){
var inst_28076 = (state_28166[(8)]);
var inst_28077 = (state_28166[(11)]);
var inst_28091 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28076),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28077)," is not found on this ledger group."].join('');
var state_28166__$1 = state_28166;
var statearr_28206_28239 = state_28166__$1;
(statearr_28206_28239[(2)] = inst_28091);

(statearr_28206_28239[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (18))){
var inst_28148 = (state_28166[(2)]);
var state_28166__$1 = state_28166;
var statearr_28207_28240 = state_28166__$1;
(statearr_28207_28240[(2)] = inst_28148);

(statearr_28207_28240[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28167 === (8))){
var state_28166__$1 = state_28166;
var statearr_28208_28241 = state_28166__$1;
(statearr_28208_28241[(2)] = null);

(statearr_28208_28241[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0 = (function (){
var statearr_28209 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28209[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__);

(statearr_28209[(1)] = (1));

return statearr_28209;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1 = (function (state_28166){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28166);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28210){var ex__2744__auto__ = e28210;
var statearr_28211_28242 = state_28166;
(statearr_28211_28242[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28166[(4)]))){
var statearr_28212_28243 = state_28166;
(statearr_28212_28243[(1)] = cljs.core.first((state_28166[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28244 = state_28166;
state_28166 = G__28244;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__ = function(state_28166){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1.call(this,state_28166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2741__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28213 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28213[(6)] = c__2763__auto___28214);

return statearr_28213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("db","indexed","db/indexed",390759770),block], 0));
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = network;
if(cljs.core.truth_(and__4251__auto__)){
return maybe_alias;
} else {
return and__4251__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4747__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4748__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4749__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4750__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__28245 = cljs.core.get_global_hierarchy;
return (fexpr__28245.cljs$core$IFn$_invoke$arity$0 ? fexpr__28245.cljs$core$IFn$_invoke$arity$0() : fexpr__28245.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4751__auto__,method_table__4747__auto__,prefer_table__4748__auto__,method_cache__4749__auto__,cached_hierarchy__4750__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28247){
var state_val_28248 = (state_28247[(1)]);
if((state_val_28248 === (1))){
var state_28247__$1 = state_28247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28247__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28249 = [null,null,null,null,null,null,null];
(statearr_28249[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28249[(1)] = (1));

return statearr_28249;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28247){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28247);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28250){var ex__2744__auto__ = e28250;
var statearr_28251_28254 = state_28247;
(statearr_28251_28254[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28247[(4)]))){
var statearr_28252_28255 = state_28247;
(statearr_28252_28255[(1)] = cljs.core.first((state_28247[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28256 = state_28247;
state_28247 = G__28256;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28247){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28253 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28253[(6)] = c__2763__auto__);

return statearr_28253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__28258){
var map__28259 = p__28258;
var map__28259__$1 = cljs.core.__destructure_map(map__28259);
var data = map__28259__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28259__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28259__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28259__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28318){
var state_val_28319 = (state_28318[(1)]);
if((state_val_28319 === (7))){
var inst_28270 = (state_28318[(7)]);
var inst_28273 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28274 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28275 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28273),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28274),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28270),". No-op."].join('');
var inst_28276 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28275], 0));
var state_28318__$1 = state_28318;
var statearr_28320_28358 = state_28318__$1;
(statearr_28320_28358[(2)] = inst_28276);

(statearr_28320_28358[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (1))){
var state_28318__$1 = state_28318;
var statearr_28321_28359 = state_28318__$1;
(statearr_28321_28359[(2)] = null);

(statearr_28321_28359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (4))){
var inst_28260 = (state_28318[(2)]);
var state_28318__$1 = state_28318;
var statearr_28322_28360 = state_28318__$1;
(statearr_28322_28360[(2)] = inst_28260);

(statearr_28322_28360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (15))){
var inst_28299 = (state_28318[(2)]);
var state_28318__$1 = state_28318;
var statearr_28323_28361 = state_28318__$1;
(statearr_28323_28361[(2)] = inst_28299);

(statearr_28323_28361[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (13))){
var inst_28290 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_28291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28292 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28293 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28294 = [inst_28292,inst_28293];
var inst_28295 = (new cljs.core.PersistentVector(null,2,(5),inst_28291,inst_28294,null));
var inst_28296 = (function (){var G__28324 = inst_28290;
var G__28325 = new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117);
var G__28326 = inst_28295;
var G__28327 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__28324,G__28325,G__28326,G__28327) : fluree.db.conn_events.process_event.call(null,G__28324,G__28325,G__28326,G__28327));
})();
var state_28318__$1 = state_28318;
var statearr_28328_28362 = state_28318__$1;
(statearr_28328_28362[(2)] = inst_28296);

(statearr_28328_28362[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (6))){
var inst_28269 = (state_28318[(8)]);
var inst_28270 = (state_28318[(7)]);
var inst_28268 = (state_28318[(2)]);
var inst_28269__$1 = fluree.db.util.async.throw_err(inst_28268);
var inst_28270__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_28269__$1);
var inst_28271 = (block <= inst_28270__$1);
var state_28318__$1 = (function (){var statearr_28329 = state_28318;
(statearr_28329[(8)] = inst_28269__$1);

(statearr_28329[(7)] = inst_28270__$1);

return statearr_28329;
})();
if(cljs.core.truth_(inst_28271)){
var statearr_28330_28363 = state_28318__$1;
(statearr_28330_28363[(1)] = (7));

} else {
var statearr_28331_28364 = state_28318__$1;
(statearr_28331_28364[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (17))){
var state_28318__$1 = state_28318;
var statearr_28332_28365 = state_28318__$1;
(statearr_28332_28365[(2)] = null);

(statearr_28332_28365[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (3))){
var inst_28316 = (state_28318[(2)]);
var state_28318__$1 = state_28318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28318__$1,inst_28316);
} else {
if((state_val_28319 === (12))){
var inst_28311 = (state_28318[(2)]);
var state_28318__$1 = state_28318;
var statearr_28333_28366 = state_28318__$1;
(statearr_28333_28366[(2)] = inst_28311);

(statearr_28333_28366[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (2))){
var inst_28266 = (state_28318[(9)]);
var _ = (function (){var statearr_28334 = state_28318;
(statearr_28334[(4)] = cljs.core.cons((5),(state_28318[(4)])));

return statearr_28334;
})();
var inst_28266__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_28318__$1 = (function (){var statearr_28335 = state_28318;
(statearr_28335[(9)] = inst_28266__$1);

return statearr_28335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28318__$1,(6),inst_28266__$1);
} else {
if((state_val_28319 === (11))){
var state_28318__$1 = state_28318;
var statearr_28337_28367 = state_28318__$1;
(statearr_28337_28367[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (9))){
var inst_28313 = (state_28318[(2)]);
var _ = (function (){var statearr_28339 = state_28318;
(statearr_28339[(4)] = cljs.core.rest((state_28318[(4)])));

return statearr_28339;
})();
var state_28318__$1 = state_28318;
var statearr_28340_28368 = state_28318__$1;
(statearr_28340_28368[(2)] = inst_28313);

(statearr_28340_28368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (5))){
var _ = (function (){var statearr_28341 = state_28318;
(statearr_28341[(4)] = cljs.core.rest((state_28318[(4)])));

return statearr_28341;
})();
var state_28318__$1 = state_28318;
var ex28336 = (state_28318__$1[(2)]);
var statearr_28342_28369 = state_28318__$1;
(statearr_28342_28369[(5)] = ex28336);


if((ex28336 instanceof Error)){
var statearr_28343_28370 = state_28318__$1;
(statearr_28343_28370[(1)] = (4));

(statearr_28343_28370[(5)] = null);

} else {
throw ex28336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (14))){
var state_28318__$1 = state_28318;
var statearr_28344_28371 = state_28318__$1;
(statearr_28344_28371[(2)] = null);

(statearr_28344_28371[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (16))){
var inst_28270 = (state_28318[(7)]);
var inst_28302 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28303 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28304 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28302),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28303),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28270),". Forcing a db reload."].join('');
var inst_28305 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28304], 0));
var inst_28306 = fluree.db.session.reload_db_BANG_(session);
var state_28318__$1 = (function (){var statearr_28345 = state_28318;
(statearr_28345[(10)] = inst_28305);

return statearr_28345;
})();
var statearr_28346_28372 = state_28318__$1;
(statearr_28346_28372[(2)] = inst_28306);

(statearr_28346_28372[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (10))){
var inst_28269 = (state_28318[(8)]);
var inst_28270 = (state_28318[(7)]);
var inst_28266 = (state_28318[(9)]);
var inst_28281 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28282 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28283 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28281),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28282),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_28284 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28283], 0));
var inst_28285 = (function (){var current_db_ch = inst_28266;
var current_db = inst_28269;
var current_block = inst_28270;
return (function (p1__28257_SHARP_){
if((p1__28257_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__28257_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__28257_SHARP_);
}
});
})();
var inst_28286 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_28285,flakes);
var inst_28287 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_28269,block,inst_28286);
var inst_28288 = fluree.db.session.cas_db_BANG_(session,inst_28266,inst_28287);
var state_28318__$1 = (function (){var statearr_28347 = state_28318;
(statearr_28347[(11)] = inst_28284);

return statearr_28347;
})();
if(inst_28288){
var statearr_28348_28373 = state_28318__$1;
(statearr_28348_28373[(1)] = (13));

} else {
var statearr_28349_28374 = state_28318__$1;
(statearr_28349_28374[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (18))){
var inst_28309 = (state_28318[(2)]);
var state_28318__$1 = state_28318;
var statearr_28350_28375 = state_28318__$1;
(statearr_28350_28375[(2)] = inst_28309);

(statearr_28350_28375[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28319 === (8))){
var inst_28270 = (state_28318[(7)]);
var inst_28278 = ((1) + inst_28270);
var inst_28279 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_28278);
var state_28318__$1 = state_28318;
if(inst_28279){
var statearr_28351_28376 = state_28318__$1;
(statearr_28351_28376[(1)] = (10));

} else {
var statearr_28352_28377 = state_28318__$1;
(statearr_28352_28377[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28353 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28353[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28353[(1)] = (1));

return statearr_28353;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28318){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28318);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28354){var ex__2744__auto__ = e28354;
var statearr_28355_28378 = state_28318;
(statearr_28355_28378[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28318[(4)]))){
var statearr_28356_28379 = state_28318;
(statearr_28356_28379[(1)] = cljs.core.first((state_28318[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28380 = state_28318;
state_28318 = G__28380;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28318){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28357 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28357[(6)] = c__2763__auto__);

return statearr_28357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28387){
var state_val_28388 = (state_28387[(1)]);
if((state_val_28388 === (1))){
var inst_28381 = fluree.db.session.clear_db_BANG_(session);
var inst_28382 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28383 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28384 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28382),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28383)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28385 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28384], 0));
var state_28387__$1 = (function (){var statearr_28389 = state_28387;
(statearr_28389[(7)] = inst_28385);

(statearr_28389[(8)] = inst_28381);

return statearr_28389;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28387__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28390 = [null,null,null,null,null,null,null,null,null];
(statearr_28390[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28390[(1)] = (1));

return statearr_28390;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28387){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28387);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28391){var ex__2744__auto__ = e28391;
var statearr_28392_28395 = state_28387;
(statearr_28392_28395[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28387[(4)]))){
var statearr_28393_28396 = state_28387;
(statearr_28393_28396[(1)] = cljs.core.first((state_28387[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28397 = state_28387;
state_28387 = G__28397;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28387){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28394 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28394[(6)] = c__2763__auto__);

return statearr_28394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28399 = arguments.length;
switch (G__28399) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
var map__28400 = session;
var map__28400__$1 = cljs.core.__destructure_map(map__28400);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28400__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

var fexpr__28401_28404 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28401_28404.cljs$core$IFn$_invoke$arity$3 ? fexpr__28401_28404.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__28401_28404.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__28402_28405 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session);
(fexpr__28402_28405.cljs$core$IFn$_invoke$arity$0 ? fexpr__28402_28405.cljs$core$IFn$_invoke$arity$0() : fexpr__28402_28405.call(null));
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28458){
var state_val_28459 = (state_28458[(1)]);
if((state_val_28459 === (7))){
var inst_28454 = (state_28458[(2)]);
var state_28458__$1 = state_28458;
var statearr_28460_28491 = state_28458__$1;
(statearr_28460_28491[(2)] = inst_28454);

(statearr_28460_28491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (1))){
var state_28458__$1 = state_28458;
var statearr_28461_28492 = state_28458__$1;
(statearr_28461_28492[(2)] = null);

(statearr_28461_28492[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (4))){
var inst_28409 = (state_28458[(7)]);
var inst_28408 = (state_28458[(2)]);
var inst_28409__$1 = fluree.db.util.async.throw_err(inst_28408);
var inst_28410 = fluree.db.session.from_cache(network,ledger_id);
var inst_28411 = (inst_28409__$1 == null);
var state_28458__$1 = (function (){var statearr_28462 = state_28458;
(statearr_28462[(7)] = inst_28409__$1);

(statearr_28462[(8)] = inst_28410);

return statearr_28462;
})();
if(cljs.core.truth_(inst_28411)){
var statearr_28463_28493 = state_28458__$1;
(statearr_28463_28493[(1)] = (5));

} else {
var statearr_28464_28494 = state_28458__$1;
(statearr_28464_28494[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (15))){
var inst_28446 = (state_28458[(2)]);
var state_28458__$1 = (function (){var statearr_28465 = state_28458;
(statearr_28465[(9)] = inst_28446);

return statearr_28465;
})();
var statearr_28466_28495 = state_28458__$1;
(statearr_28466_28495[(2)] = null);

(statearr_28466_28495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (13))){
var inst_28450 = (state_28458[(2)]);
var state_28458__$1 = state_28458;
var statearr_28468_28496 = state_28458__$1;
(statearr_28468_28496[(2)] = inst_28450);

(statearr_28468_28496[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (6))){
var inst_28410 = (state_28458[(8)]);
var inst_28416 = (inst_28410 == null);
var state_28458__$1 = state_28458;
if(cljs.core.truth_(inst_28416)){
var statearr_28469_28497 = state_28458__$1;
(statearr_28469_28497[(1)] = (8));

} else {
var statearr_28470_28498 = state_28458__$1;
(statearr_28470_28498[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (17))){
var _ = (function (){var statearr_28471 = state_28458;
(statearr_28471[(4)] = cljs.core.rest((state_28458[(4)])));

return statearr_28471;
})();
var state_28458__$1 = state_28458;
var ex28467 = (state_28458__$1[(2)]);
var statearr_28472_28499 = state_28458__$1;
(statearr_28472_28499[(5)] = ex28467);


var statearr_28473_28500 = state_28458__$1;
(statearr_28473_28500[(1)] = (16));

(statearr_28473_28500[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (3))){
var inst_28456 = (state_28458[(2)]);
var state_28458__$1 = state_28458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28458__$1,inst_28456);
} else {
if((state_val_28459 === (12))){
var state_28458__$1 = state_28458;
var statearr_28474_28501 = state_28458__$1;
(statearr_28474_28501[(2)] = null);

(statearr_28474_28501[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (2))){
var state_28458__$1 = state_28458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28458__$1,(4),update_chan);
} else {
if((state_val_28459 === (11))){
var state_28458__$1 = state_28458;
var statearr_28475_28502 = state_28458__$1;
(statearr_28475_28502[(2)] = null);

(statearr_28475_28502[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (9))){
var state_28458__$1 = state_28458;
var statearr_28476_28503 = state_28458__$1;
(statearr_28476_28503[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (5))){
var inst_28413 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28414 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28413], 0));
var state_28458__$1 = state_28458;
var statearr_28478_28504 = state_28458__$1;
(statearr_28478_28504[(2)] = inst_28414);

(statearr_28478_28504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (14))){
var inst_28409 = (state_28458[(7)]);
var inst_28410 = (state_28458[(8)]);
var _ = (function (){var statearr_28479 = state_28458;
(statearr_28479[(4)] = cljs.core.cons((17),(state_28458[(4)])));

return statearr_28479;
})();
var inst_28434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28409,(0),null);
var inst_28435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28409,(1),null);
var inst_28436 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28437 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28409], 0));
var inst_28438 = fluree.db.util.core.trunc(inst_28437,(200));
var inst_28439 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28436,inst_28438], 0));
var inst_28440 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_28410,inst_28434,inst_28435) : fluree.db.session.process_ledger_update.call(null,inst_28410,inst_28434,inst_28435));
var state_28458__$1 = (function (){var statearr_28480 = state_28458;
(statearr_28480[(10)] = inst_28439);

return statearr_28480;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28458__$1,(18),inst_28440);
} else {
if((state_val_28459 === (16))){
var inst_28409 = (state_28458[(7)]);
var inst_28424 = (state_28458[(2)]);
var inst_28425 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28424,"Exception processing ledger updates for message: ",inst_28409], 0));
var state_28458__$1 = state_28458;
var statearr_28481_28505 = state_28458__$1;
(statearr_28481_28505[(2)] = inst_28425);

(statearr_28481_28505[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (10))){
var inst_28452 = (state_28458[(2)]);
var state_28458__$1 = state_28458;
var statearr_28482_28506 = state_28458__$1;
(statearr_28482_28506[(2)] = inst_28452);

(statearr_28482_28506[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (18))){
var inst_28442 = (state_28458[(2)]);
var inst_28443 = fluree.db.util.async.throw_err(inst_28442);
var _ = (function (){var statearr_28483 = state_28458;
(statearr_28483[(4)] = cljs.core.rest((state_28458[(4)])));

return statearr_28483;
})();
var state_28458__$1 = state_28458;
var statearr_28484_28507 = state_28458__$1;
(statearr_28484_28507[(2)] = inst_28443);

(statearr_28484_28507[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28459 === (8))){
var inst_28409 = (state_28458[(7)]);
var inst_28418 = cljs.core.first(inst_28409);
var inst_28419 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28418], 0));
var inst_28420 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28419].join('');
var inst_28421 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28420], 0));
var state_28458__$1 = state_28458;
var statearr_28485_28508 = state_28458__$1;
(statearr_28485_28508[(2)] = inst_28421);

(statearr_28485_28508[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0 = (function (){
var statearr_28486 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28486[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__);

(statearr_28486[(1)] = (1));

return statearr_28486;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1 = (function (state_28458){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28458);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28487){var ex__2744__auto__ = e28487;
var statearr_28488_28509 = state_28458;
(statearr_28488_28509[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28458[(4)]))){
var statearr_28489_28510 = state_28458;
(statearr_28489_28510[(1)] = cljs.core.first((state_28458[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28511 = state_28458;
state_28458 = G__28511;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__ = function(state_28458){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1.call(this,state_28458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2741__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28490 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28490[(6)] = c__2763__auto__);

return statearr_28490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28512){
var map__28513 = p__28512;
var map__28513__$1 = cljs.core.__destructure_map(map__28513);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28513__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28517 = block_result;
var map__28517__$1 = cljs.core.__destructure_map(map__28517);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28517__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__28518 = tx_result;
var map__28518__$1 = cljs.core.__destructure_map(map__28518);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28518__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28518__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__28514_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__28514_SHARP_.t);
}):(function (p1__28515_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28515_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__28516_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__28516_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__28516_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28519 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28519,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28519,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28519,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28519,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4253__auto__ = message;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28523 = arguments.length;
switch (G__28523) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28524){
var map__28525 = p__28524;
var map__28525__$1 = cljs.core.__destructure_map(map__28525);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28525__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28525__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28525__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28525__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28526 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28526,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28526,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28526,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4253__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4253__auto____$1 = state;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__28530_28650 = network;
var G__28531_28651 = ledger_id;
var G__28532_28652 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session);
var G__28533_28653 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28534 = cljs.core.seq(tids);
var chunk__28535 = null;
var count__28536 = (0);
var i__28537 = (0);
while(true){
if((i__28537 < count__28536)){
var tid = chunk__28535.cljs$core$IIndexed$_nth$arity$2(null,i__28537);
var temp__5753__auto___28655__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28655__$1)){
var keyed_callbacks_28656 = temp__5753__auto___28655__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28657 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28578_28658 = cljs.core.seq(keyed_callbacks_28656);
var chunk__28579_28659 = null;
var count__28580_28660 = (0);
var i__28581_28661 = (0);
while(true){
if((i__28581_28661 < count__28580_28660)){
var vec__28590_28662 = chunk__28579_28659.cljs$core$IIndexed$_nth$arity$2(null,i__28581_28661);
var k_28663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28590_28662,(0),null);
var f_28664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28590_28662,(1),null);
try{(f_28664.cljs$core$IFn$_invoke$arity$1 ? f_28664.cljs$core$IFn$_invoke$arity$1(tx_response_28657) : f_28664.call(null,tx_response_28657));
}catch (e28593){var e_28665 = e28593;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28665,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28666 = seq__28578_28658;
var G__28667 = chunk__28579_28659;
var G__28668 = count__28580_28660;
var G__28669 = (i__28581_28661 + (1));
seq__28578_28658 = G__28666;
chunk__28579_28659 = G__28667;
count__28580_28660 = G__28668;
i__28581_28661 = G__28669;
continue;
} else {
var temp__5753__auto___28670__$2 = cljs.core.seq(seq__28578_28658);
if(temp__5753__auto___28670__$2){
var seq__28578_28671__$1 = temp__5753__auto___28670__$2;
if(cljs.core.chunked_seq_QMARK_(seq__28578_28671__$1)){
var c__4679__auto___28672 = cljs.core.chunk_first(seq__28578_28671__$1);
var G__28673 = cljs.core.chunk_rest(seq__28578_28671__$1);
var G__28674 = c__4679__auto___28672;
var G__28675 = cljs.core.count(c__4679__auto___28672);
var G__28676 = (0);
seq__28578_28658 = G__28673;
chunk__28579_28659 = G__28674;
count__28580_28660 = G__28675;
i__28581_28661 = G__28676;
continue;
} else {
var vec__28594_28677 = cljs.core.first(seq__28578_28671__$1);
var k_28678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28594_28677,(0),null);
var f_28679 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28594_28677,(1),null);
try{(f_28679.cljs$core$IFn$_invoke$arity$1 ? f_28679.cljs$core$IFn$_invoke$arity$1(tx_response_28657) : f_28679.call(null,tx_response_28657));
}catch (e28597){var e_28680 = e28597;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28680,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28681 = cljs.core.next(seq__28578_28671__$1);
var G__28682 = null;
var G__28683 = (0);
var G__28684 = (0);
seq__28578_28658 = G__28681;
chunk__28579_28659 = G__28682;
count__28580_28660 = G__28683;
i__28581_28661 = G__28684;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28685 = seq__28534;
var G__28686 = chunk__28535;
var G__28687 = count__28536;
var G__28688 = (i__28537 + (1));
seq__28534 = G__28685;
chunk__28535 = G__28686;
count__28536 = G__28687;
i__28537 = G__28688;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__28534);
if(temp__5753__auto____$1){
var seq__28534__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__28534__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__28534__$1);
var G__28689 = cljs.core.chunk_rest(seq__28534__$1);
var G__28690 = c__4679__auto__;
var G__28691 = cljs.core.count(c__4679__auto__);
var G__28692 = (0);
seq__28534 = G__28689;
chunk__28535 = G__28690;
count__28536 = G__28691;
i__28537 = G__28692;
continue;
} else {
var tid = cljs.core.first(seq__28534__$1);
var temp__5753__auto___28693__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___28693__$2)){
var keyed_callbacks_28694 = temp__5753__auto___28693__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_28695 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__28598_28696 = cljs.core.seq(keyed_callbacks_28694);
var chunk__28599_28697 = null;
var count__28600_28698 = (0);
var i__28601_28699 = (0);
while(true){
if((i__28601_28699 < count__28600_28698)){
var vec__28610_28700 = chunk__28599_28697.cljs$core$IIndexed$_nth$arity$2(null,i__28601_28699);
var k_28701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28610_28700,(0),null);
var f_28702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28610_28700,(1),null);
try{(f_28702.cljs$core$IFn$_invoke$arity$1 ? f_28702.cljs$core$IFn$_invoke$arity$1(tx_response_28695) : f_28702.call(null,tx_response_28695));
}catch (e28613){var e_28703 = e28613;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28703,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28704 = seq__28598_28696;
var G__28705 = chunk__28599_28697;
var G__28706 = count__28600_28698;
var G__28707 = (i__28601_28699 + (1));
seq__28598_28696 = G__28704;
chunk__28599_28697 = G__28705;
count__28600_28698 = G__28706;
i__28601_28699 = G__28707;
continue;
} else {
var temp__5753__auto___28708__$3 = cljs.core.seq(seq__28598_28696);
if(temp__5753__auto___28708__$3){
var seq__28598_28709__$1 = temp__5753__auto___28708__$3;
if(cljs.core.chunked_seq_QMARK_(seq__28598_28709__$1)){
var c__4679__auto___28710 = cljs.core.chunk_first(seq__28598_28709__$1);
var G__28711 = cljs.core.chunk_rest(seq__28598_28709__$1);
var G__28712 = c__4679__auto___28710;
var G__28713 = cljs.core.count(c__4679__auto___28710);
var G__28714 = (0);
seq__28598_28696 = G__28711;
chunk__28599_28697 = G__28712;
count__28600_28698 = G__28713;
i__28601_28699 = G__28714;
continue;
} else {
var vec__28614_28715 = cljs.core.first(seq__28598_28709__$1);
var k_28716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28614_28715,(0),null);
var f_28717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28614_28715,(1),null);
try{(f_28717.cljs$core$IFn$_invoke$arity$1 ? f_28717.cljs$core$IFn$_invoke$arity$1(tx_response_28695) : f_28717.call(null,tx_response_28695));
}catch (e28617){var e_28718 = e28617;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28718,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__28719 = cljs.core.next(seq__28598_28709__$1);
var G__28720 = null;
var G__28721 = (0);
var G__28722 = (0);
seq__28598_28696 = G__28719;
chunk__28599_28697 = G__28720;
count__28600_28698 = G__28721;
i__28601_28699 = G__28722;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28723 = cljs.core.next(seq__28534__$1);
var G__28724 = null;
var G__28725 = (0);
var G__28726 = (0);
seq__28534 = G__28723;
chunk__28535 = G__28724;
count__28536 = G__28725;
i__28537 = G__28726;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__28529_28654 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__28529_28654.cljs$core$IFn$_invoke$arity$4 ? fexpr__28529_28654.cljs$core$IFn$_invoke$arity$4(G__28530_28650,G__28531_28651,G__28532_28652,G__28533_28653) : fexpr__28529_28654.call(null,G__28530_28650,G__28531_28651,G__28532_28652,G__28533_28653));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28727 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2763__auto___28728 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28634){
var state_val_28635 = (state_28634[(1)]);
if((state_val_28635 === (1))){
var state_28634__$1 = state_28634;
var statearr_28636_28729 = state_28634__$1;
(statearr_28636_28729[(2)] = null);

(statearr_28636_28729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (2))){
var inst_28619 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28634__$1 = state_28634;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28634__$1,(4),inst_28619);
} else {
if((state_val_28635 === (3))){
var inst_28632 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28634__$1,inst_28632);
} else {
if((state_val_28635 === (4))){
var inst_28621 = (state_28634[(7)]);
var inst_28621__$1 = (state_28634[(2)]);
var inst_28622 = (inst_28621__$1 == null);
var state_28634__$1 = (function (){var statearr_28637 = state_28634;
(statearr_28637[(7)] = inst_28621__$1);

return statearr_28637;
})();
if(cljs.core.truth_(inst_28622)){
var statearr_28638_28730 = state_28634__$1;
(statearr_28638_28730[(1)] = (5));

} else {
var statearr_28639_28731 = state_28634__$1;
(statearr_28639_28731[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (5))){
var inst_28624 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28625 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28624], 0));
var state_28634__$1 = state_28634;
var statearr_28640_28732 = state_28634__$1;
(statearr_28640_28732[(2)] = inst_28625);

(statearr_28640_28732[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (6))){
var inst_28621 = (state_28634[(7)]);
var inst_28627 = (transact_handler_28727.cljs$core$IFn$_invoke$arity$2 ? transact_handler_28727.cljs$core$IFn$_invoke$arity$2(conn,inst_28621) : transact_handler_28727.call(null,conn,inst_28621));
var state_28634__$1 = (function (){var statearr_28641 = state_28634;
(statearr_28641[(8)] = inst_28627);

return statearr_28641;
})();
var statearr_28642_28733 = state_28634__$1;
(statearr_28642_28733[(2)] = null);

(statearr_28642_28733[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28635 === (7))){
var inst_28630 = (state_28634[(2)]);
var state_28634__$1 = state_28634;
var statearr_28643_28734 = state_28634__$1;
(statearr_28643_28734[(2)] = inst_28630);

(statearr_28643_28734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2741__auto__ = null;
var fluree$db$session$state_machine__2741__auto____0 = (function (){
var statearr_28644 = [null,null,null,null,null,null,null,null,null];
(statearr_28644[(0)] = fluree$db$session$state_machine__2741__auto__);

(statearr_28644[(1)] = (1));

return statearr_28644;
});
var fluree$db$session$state_machine__2741__auto____1 = (function (state_28634){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_28634);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28645){var ex__2744__auto__ = e28645;
var statearr_28646_28735 = state_28634;
(statearr_28646_28735[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_28634[(4)]))){
var statearr_28647_28736 = state_28634;
(statearr_28647_28736[(1)] = cljs.core.first((state_28634[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28737 = state_28634;
state_28634 = G__28737;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$session$state_machine__2741__auto__ = function(state_28634){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2741__auto____1.call(this,state_28634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2741__auto____0;
fluree$db$session$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2741__auto____1;
return fluree$db$session$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28648 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_28648[(6)] = c__2763__auto___28728);

return statearr_28648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(p__28739){
var map__28740 = p__28739;
var map__28740__$1 = cljs.core.__destructure_map(map__28740);
var session = map__28740__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28740__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (p1__28738_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__28738_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28738_SHARP_) + (1))], 0));
}));

var or__4253__auto__ = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(state));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var _ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,(function (st){
if(cljs.core.truth_(new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(st))){
return st;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db(session));
}
}));
return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state);
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28743 = arguments.length;
switch (G__28743) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28744 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__28741_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__28741_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28744);
} else {
return G__28744;
}
})();
var seq__28745 = cljs.core.seq(sessions);
var chunk__28746 = null;
var count__28747 = (0);
var i__28748 = (0);
while(true){
if((i__28748 < count__28747)){
var session = chunk__28746.cljs$core$IIndexed$_nth$arity$2(null,i__28748);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28750 = seq__28745;
var G__28751 = chunk__28746;
var G__28752 = count__28747;
var G__28753 = (i__28748 + (1));
seq__28745 = G__28750;
chunk__28746 = G__28751;
count__28747 = G__28752;
i__28748 = G__28753;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28745);
if(temp__5753__auto__){
var seq__28745__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28745__$1)){
var c__4679__auto__ = cljs.core.chunk_first(seq__28745__$1);
var G__28754 = cljs.core.chunk_rest(seq__28745__$1);
var G__28755 = c__4679__auto__;
var G__28756 = cljs.core.count(c__4679__auto__);
var G__28757 = (0);
seq__28745 = G__28754;
chunk__28746 = G__28755;
count__28747 = G__28756;
i__28748 = G__28757;
continue;
} else {
var session = cljs.core.first(seq__28745__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__28758 = cljs.core.next(seq__28745__$1);
var G__28759 = null;
var G__28760 = (0);
var G__28761 = (0);
seq__28745 = G__28758;
chunk__28746 = G__28759;
count__28747 = G__28760;
i__28748 = G__28761;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
