// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22167 = arguments.length;
switch (G__22167) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__22168 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__22168) : f.call(null,G__22168));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__22169 = cljs.core._deref(vol);
var G__22170 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__22169,G__22170) : f.call(null,G__22169,G__22170));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__22171 = cljs.core._deref(vol);
var G__22172 = arg1;
var G__22173 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__22171,G__22172,G__22173) : f.call(null,G__22171,G__22172,G__22173));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__22174 = cljs.core._deref(vol);
var G__22175 = arg1;
var G__22176 = arg2;
var G__22177 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__22174,G__22175,G__22176,G__22177) : f.call(null,G__22174,G__22175,G__22176,G__22177));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22180 = arguments.length;
switch (G__22180) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22182 = null;
var G__22182__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22182__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22182__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22182 = function(result,flake){
switch(arguments.length){
case 0:
return G__22182__0.call(this);
case 1:
return G__22182__1.call(this,result);
case 2:
return G__22182__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22182.cljs$core$IFn$_invoke$arity$0 = G__22182__0;
G__22182.cljs$core$IFn$_invoke$arity$1 = G__22182__1;
G__22182.cljs$core$IFn$_invoke$arity$2 = G__22182__2;
return G__22182;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22183 = null;
var G__22183__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22183__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22183__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22183 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22183__0.call(this);
case 1:
return G__22183__1.call(this,result);
case 2:
return G__22183__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22183.cljs$core$IFn$_invoke$arity$0 = G__22183__0;
G__22183.cljs$core$IFn$_invoke$arity$1 = G__22183__1;
G__22183.cljs$core$IFn$_invoke$arity$2 = G__22183__2;
return G__22183;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22185 = res;
var G__22185__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22184_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22184_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22185):G__22185);
var G__22185__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22185__$1):G__22185__$1);
var G__22185__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22185__$2):G__22185__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22185__$3);
} else {
return G__22185__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22189 = arguments.length;
switch (G__22189) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_22628){
var state_val_22629 = (state_22628[(1)]);
if((state_val_22629 === (121))){
var inst_22551 = (state_22628[(2)]);
var inst_22552 = fluree.db.util.async.throw_err(inst_22551);
var inst_22553 = cljs.core.seq(inst_22552);
var state_22628__$1 = state_22628;
if(inst_22553){
var statearr_22630_22844 = state_22628__$1;
(statearr_22630_22844[(1)] = (122));

} else {
var statearr_22631_22845 = state_22628__$1;
(statearr_22631_22845[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (65))){
var inst_22344 = (state_22628[(7)]);
var inst_22343 = (state_22628[(2)]);
var inst_22344__$1 = fluree.db.util.async.throw_err(inst_22343);
var inst_22345 = cljs.core.seq(inst_22344__$1);
var state_22628__$1 = (function (){var statearr_22632 = state_22628;
(statearr_22632[(7)] = inst_22344__$1);

return statearr_22632;
})();
if(inst_22345){
var statearr_22633_22846 = state_22628__$1;
(statearr_22633_22846[(1)] = (66));

} else {
var statearr_22634_22847 = state_22628__$1;
(statearr_22634_22847[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (70))){
var inst_22344 = (state_22628[(7)]);
var inst_22355 = cljs.core.count(inst_22344);
var inst_22356 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22355);
var state_22628__$1 = state_22628;
var statearr_22635_22848 = state_22628__$1;
(statearr_22635_22848[(2)] = inst_22356);

(statearr_22635_22848[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (62))){
var inst_22334 = (state_22628[(8)]);
var inst_22337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22338 = inst_22334.o;
var inst_22339 = [inst_22338];
var inst_22340 = (new cljs.core.PersistentVector(null,1,(5),inst_22337,inst_22339,null));
var inst_22341 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22340);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(65),inst_22341);
} else {
if((state_val_22629 === (74))){
var inst_22328 = (state_22628[(9)]);
var state_22628__$1 = state_22628;
var statearr_22636_22849 = state_22628__$1;
(statearr_22636_22849[(2)] = inst_22328);

(statearr_22636_22849[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (110))){
var inst_22513 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22514 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22513);
var inst_22515 = inst_22514 === true;
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22515)){
var statearr_22637_22850 = state_22628__$1;
(statearr_22637_22850[(1)] = (113));

} else {
var statearr_22638_22851 = state_22628__$1;
(statearr_22638_22851[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (130))){
var inst_22623 = (state_22628[(2)]);
var _ = (function (){var statearr_22639 = state_22628;
(statearr_22639[(4)] = cljs.core.rest((state_22628[(4)])));

return statearr_22639;
})();
var state_22628__$1 = state_22628;
var statearr_22640_22852 = state_22628__$1;
(statearr_22640_22852[(2)] = inst_22623);

(statearr_22640_22852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (128))){
var inst_22598 = (state_22628[(10)]);
var inst_22601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22602 = [acc,inst_22598];
var inst_22603 = (new cljs.core.PersistentVector(null,2,(5),inst_22601,inst_22602,null));
var state_22628__$1 = state_22628;
var statearr_22641_22853 = state_22628__$1;
(statearr_22641_22853[(2)] = inst_22603);

(statearr_22641_22853[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (7))){
var inst_22201 = (state_22628[(11)]);
var state_22628__$1 = state_22628;
var statearr_22642_22854 = state_22628__$1;
(statearr_22642_22854[(2)] = inst_22201);

(statearr_22642_22854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (59))){
var inst_22592 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22643_22855 = state_22628__$1;
(statearr_22643_22855[(2)] = inst_22592);

(statearr_22643_22855[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (86))){
var inst_22422 = (state_22628[(12)]);
var inst_22422__$1 = (state_22628[(2)]);
var state_22628__$1 = (function (){var statearr_22644 = state_22628;
(statearr_22644[(12)] = inst_22422__$1);

return statearr_22644;
})();
if(cljs.core.truth_(inst_22422__$1)){
var statearr_22645_22856 = state_22628__$1;
(statearr_22645_22856[(1)] = (88));

} else {
var statearr_22646_22857 = state_22628__$1;
(statearr_22646_22857[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (20))){
var inst_22230 = (state_22628[(13)]);
var inst_22243 = (state_22628[(14)]);
var inst_22242 = (state_22628[(15)]);
var inst_22241 = (state_22628[(2)]);
var inst_22242__$1 = cljs.core.__destructure_map(inst_22230);
var inst_22243__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22245 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22246 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22247 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22242__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22628__$1 = (function (){var statearr_22647 = state_22628;
(statearr_22647[(16)] = inst_22247);

(statearr_22647[(17)] = inst_22245);

(statearr_22647[(18)] = inst_22248);

(statearr_22647[(19)] = inst_22246);

(statearr_22647[(20)] = inst_22244);

(statearr_22647[(14)] = inst_22243__$1);

(statearr_22647[(21)] = inst_22241);

(statearr_22647[(15)] = inst_22242__$1);

return statearr_22647;
})();
if(cljs.core.truth_(inst_22243__$1)){
var statearr_22648_22858 = state_22628__$1;
(statearr_22648_22858[(1)] = (24));

} else {
var statearr_22649_22859 = state_22628__$1;
(statearr_22649_22859[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (72))){
var inst_22353 = (state_22628[(22)]);
var inst_22359 = (state_22628[(2)]);
var inst_22360 = cljs.core.seq(inst_22353);
var state_22628__$1 = (function (){var statearr_22650 = state_22628;
(statearr_22650[(23)] = inst_22359);

return statearr_22650;
})();
if(inst_22360){
var statearr_22651_22860 = state_22628__$1;
(statearr_22651_22860[(1)] = (73));

} else {
var statearr_22652_22861 = state_22628__$1;
(statearr_22652_22861[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (58))){
var inst_22230 = (state_22628[(13)]);
var inst_22375 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22375)){
var statearr_22653_22862 = state_22628__$1;
(statearr_22653_22862[(1)] = (76));

} else {
var statearr_22654_22863 = state_22628__$1;
(statearr_22654_22863[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (60))){
var inst_22327 = (state_22628[(24)]);
var inst_22334 = (state_22628[(8)]);
var inst_22333 = cljs.core.seq(inst_22327);
var inst_22334__$1 = cljs.core.first(inst_22333);
var inst_22335 = cljs.core.next(inst_22333);
var state_22628__$1 = (function (){var statearr_22655 = state_22628;
(statearr_22655[(25)] = inst_22335);

(statearr_22655[(8)] = inst_22334__$1);

return statearr_22655;
})();
if(cljs.core.truth_(inst_22334__$1)){
var statearr_22656_22864 = state_22628__$1;
(statearr_22656_22864[(1)] = (62));

} else {
var statearr_22657_22865 = state_22628__$1;
(statearr_22657_22865[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (27))){
var inst_22247 = (state_22628[(16)]);
var inst_22251 = (state_22628[(26)]);
var inst_22251__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22247);
var state_22628__$1 = (function (){var statearr_22658 = state_22628;
(statearr_22658[(26)] = inst_22251__$1);

return statearr_22658;
})();
if(inst_22251__$1){
var statearr_22659_22866 = state_22628__$1;
(statearr_22659_22866[(1)] = (30));

} else {
var statearr_22660_22867 = state_22628__$1;
(statearr_22660_22867[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (1))){
var state_22628__$1 = state_22628;
var statearr_22661_22868 = state_22628__$1;
(statearr_22661_22868[(2)] = null);

(statearr_22661_22868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (69))){
var inst_22349 = (state_22628[(2)]);
var inst_22350 = fluree.db.util.async.throw_err(inst_22349);
var state_22628__$1 = state_22628;
var statearr_22662_22869 = state_22628__$1;
(statearr_22662_22869[(2)] = inst_22350);

(statearr_22662_22869[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (101))){
var inst_22506 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22663_22870 = state_22628__$1;
(statearr_22663_22870[(2)] = inst_22506);

(statearr_22663_22870[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (24))){
var inst_22247 = (state_22628[(16)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22247)){
var statearr_22664_22871 = state_22628__$1;
(statearr_22664_22871[(1)] = (27));

} else {
var statearr_22665_22872 = state_22628__$1;
(statearr_22665_22872[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (102))){
var inst_22478 = (state_22628[(27)]);
var inst_22477 = (state_22628[(2)]);
var inst_22478__$1 = fluree.db.util.async.throw_err(inst_22477);
var inst_22479 = cljs.core.empty_QMARK_(inst_22478__$1);
var state_22628__$1 = (function (){var statearr_22666 = state_22628;
(statearr_22666[(27)] = inst_22478__$1);

return statearr_22666;
})();
if(inst_22479){
var statearr_22667_22873 = state_22628__$1;
(statearr_22667_22873[(1)] = (103));

} else {
var statearr_22668_22874 = state_22628__$1;
(statearr_22668_22874[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (135))){
var state_22628__$1 = state_22628;
var statearr_22669_22875 = state_22628__$1;
(statearr_22669_22875[(2)] = null);

(statearr_22669_22875[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (55))){
var inst_22230 = (state_22628[(13)]);
var inst_22303 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = state_22628;
var statearr_22670_22876 = state_22628__$1;
(statearr_22670_22876[(2)] = inst_22303);

(statearr_22670_22876[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (85))){
var inst_22230 = (state_22628[(13)]);
var inst_22397 = (state_22628[(28)]);
var inst_22409 = inst_22397.o;
var inst_22410 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22230);
var inst_22411 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22409,inst_22410);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(87),inst_22411);
} else {
if((state_val_22629 === (39))){
var inst_22246 = (state_22628[(19)]);
var inst_22278 = (state_22628[(29)]);
var inst_22278__$1 = cljs.core.not(inst_22246);
var state_22628__$1 = (function (){var statearr_22671 = state_22628;
(statearr_22671[(29)] = inst_22278__$1);

return statearr_22671;
})();
if(inst_22278__$1){
var statearr_22672_22877 = state_22628__$1;
(statearr_22672_22877[(1)] = (42));

} else {
var statearr_22673_22878 = state_22628__$1;
(statearr_22673_22878[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (88))){
var inst_22422 = (state_22628[(12)]);
var inst_22391 = (state_22628[(30)]);
var inst_22424 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22391,inst_22422);
var state_22628__$1 = state_22628;
var statearr_22674_22879 = state_22628__$1;
(statearr_22674_22879[(2)] = inst_22424);

(statearr_22674_22879[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (46))){
var inst_22245 = (state_22628[(17)]);
var state_22628__$1 = state_22628;
var statearr_22675_22880 = state_22628__$1;
(statearr_22675_22880[(2)] = inst_22245);

(statearr_22675_22880[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (4))){
var inst_22190 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22676_22881 = state_22628__$1;
(statearr_22676_22881[(2)] = inst_22190);

(statearr_22676_22881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (77))){
var inst_22437 = (state_22628[(31)]);
var inst_22437__$1 = componentFollow_QMARK_;
var state_22628__$1 = (function (){var statearr_22677 = state_22628;
(statearr_22677[(31)] = inst_22437__$1);

return statearr_22677;
})();
if(cljs.core.truth_(inst_22437__$1)){
var statearr_22678_22882 = state_22628__$1;
(statearr_22678_22882[(1)] = (91));

} else {
var statearr_22679_22883 = state_22628__$1;
(statearr_22679_22883[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (106))){
var inst_22458 = (state_22628[(32)]);
var inst_22492 = (state_22628[(2)]);
var inst_22493 = fluree.db.util.async.throw_err(inst_22492);
var inst_22494 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22458,inst_22493);
var state_22628__$1 = state_22628;
var statearr_22680_22884 = state_22628__$1;
(statearr_22680_22884[(2)] = inst_22494);

(statearr_22680_22884[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (119))){
var inst_22536 = (state_22628[(33)]);
var inst_22566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22567 = [inst_22536,offset_map];
var inst_22568 = (new cljs.core.PersistentVector(null,2,(5),inst_22566,inst_22567,null));
var state_22628__$1 = state_22628;
var statearr_22681_22885 = state_22628__$1;
(statearr_22681_22885[(2)] = inst_22568);

(statearr_22681_22885[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (95))){
var inst_22244 = (state_22628[(20)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22244)){
var statearr_22682_22886 = state_22628__$1;
(statearr_22682_22886[(1)] = (110));

} else {
var statearr_22683_22887 = state_22628__$1;
(statearr_22683_22887[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (54))){
var inst_22300 = (state_22628[(34)]);
var state_22628__$1 = state_22628;
var statearr_22684_22888 = state_22628__$1;
(statearr_22684_22888[(2)] = inst_22300);

(statearr_22684_22888[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (92))){
var inst_22437 = (state_22628[(31)]);
var state_22628__$1 = state_22628;
var statearr_22685_22889 = state_22628__$1;
(statearr_22685_22889[(2)] = inst_22437);

(statearr_22685_22889[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (104))){
var inst_22200 = (state_22628[(35)]);
var inst_22478 = (state_22628[(27)]);
var inst_22487 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22488 = [true,inst_22200];
var inst_22489 = cljs.core.PersistentHashMap.fromArrays(inst_22487,inst_22488);
var inst_22490 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22489,inst_22478) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22489,inst_22478));
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(106),inst_22490);
} else {
if((state_val_22629 === (15))){
var inst_22200 = (state_22628[(35)]);
var inst_22223 = (state_22628[(36)]);
var inst_22227 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22223,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22200);
var state_22628__$1 = state_22628;
var statearr_22686_22890 = state_22628__$1;
(statearr_22686_22890[(2)] = inst_22227);

(statearr_22686_22890[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (48))){
var inst_22294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22295 = [null,offset_map];
var inst_22296 = (new cljs.core.PersistentVector(null,2,(5),inst_22294,inst_22295,null));
var state_22628__$1 = state_22628;
var statearr_22687_22891 = state_22628__$1;
(statearr_22687_22891[(2)] = inst_22296);

(statearr_22687_22891[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (50))){
var inst_22594 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22688_22892 = state_22628__$1;
(statearr_22688_22892[(2)] = inst_22594);

(statearr_22688_22892[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (116))){
var inst_22542 = (state_22628[(37)]);
var inst_22535 = (state_22628[(38)]);
var inst_22541 = cljs.core.seq(inst_22535);
var inst_22542__$1 = cljs.core.first(inst_22541);
var inst_22543 = cljs.core.next(inst_22541);
var state_22628__$1 = (function (){var statearr_22689 = state_22628;
(statearr_22689[(37)] = inst_22542__$1);

(statearr_22689[(39)] = inst_22543);

return statearr_22689;
})();
if(cljs.core.truth_(inst_22542__$1)){
var statearr_22690_22893 = state_22628__$1;
(statearr_22690_22893[(1)] = (118));

} else {
var statearr_22691_22894 = state_22628__$1;
(statearr_22691_22894[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (75))){
var inst_22335 = (state_22628[(25)]);
var inst_22365 = (state_22628[(2)]);
var inst_22327 = inst_22335;
var inst_22328 = inst_22365;
var state_22628__$1 = (function (){var statearr_22692 = state_22628;
(statearr_22692[(24)] = inst_22327);

(statearr_22692[(9)] = inst_22328);

return statearr_22692;
})();
var statearr_22693_22895 = state_22628__$1;
(statearr_22693_22895[(2)] = null);

(statearr_22693_22895[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (99))){
var inst_22230 = (state_22628[(13)]);
var inst_22464 = (state_22628[(40)]);
var inst_22467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22468 = inst_22464.o;
var inst_22469 = [inst_22468];
var inst_22470 = (new cljs.core.PersistentVector(null,1,(5),inst_22467,inst_22469,null));
var inst_22471 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22472 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22230);
var inst_22473 = [inst_22472];
var inst_22474 = cljs.core.PersistentHashMap.fromArrays(inst_22471,inst_22473);
var inst_22475 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22470,inst_22474);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(102),inst_22475);
} else {
if((state_val_22629 === (21))){
var inst_22234 = (state_22628[(41)]);
var state_22628__$1 = state_22628;
var statearr_22694_22896 = state_22628__$1;
(statearr_22694_22896[(2)] = inst_22234);

(statearr_22694_22896[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (31))){
var inst_22251 = (state_22628[(26)]);
var state_22628__$1 = state_22628;
var statearr_22695_22897 = state_22628__$1;
(statearr_22695_22897[(2)] = inst_22251);

(statearr_22695_22897[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (113))){
var inst_22247 = (state_22628[(16)]);
var inst_22245 = (state_22628[(17)]);
var inst_22230 = (state_22628[(13)]);
var inst_22200 = (state_22628[(35)]);
var inst_22215 = (state_22628[(42)]);
var inst_22248 = (state_22628[(18)]);
var inst_22246 = (state_22628[(19)]);
var inst_22244 = (state_22628[(20)]);
var inst_22243 = (state_22628[(14)]);
var inst_22241 = (state_22628[(21)]);
var inst_22242 = (state_22628[(15)]);
var inst_22517 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22518 = (function (){var p = inst_22248;
var pred_spec__$1 = inst_22215;
var orderBy = inst_22246;
var map__22196 = inst_22242;
var multi_QMARK_ = inst_22243;
var limit = inst_22245;
var offset = inst_22247;
var k = inst_22241;
var compact_QMARK_ = inst_22200;
var pred_spec_SINGLEQUOTE_ = inst_22230;
var ref_QMARK_ = inst_22244;
return (function (p1__22186_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22186_SHARP_.o]);
});
})();
var inst_22519 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22518,flakes);
var inst_22520 = [inst_22519,offset_map];
var inst_22521 = (new cljs.core.PersistentVector(null,2,(5),inst_22517,inst_22520,null));
var state_22628__$1 = state_22628;
var statearr_22696_22898 = state_22628__$1;
(statearr_22696_22898[(2)] = inst_22521);

(statearr_22696_22898[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (32))){
var inst_22257 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22697_22899 = state_22628__$1;
(statearr_22697_22899[(2)] = inst_22257);

(statearr_22697_22899[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (136))){
var inst_22619 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22698_22900 = state_22628__$1;
(statearr_22698_22900[(2)] = inst_22619);

(statearr_22698_22900[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (40))){
var inst_22243 = (state_22628[(14)]);
var state_22628__$1 = state_22628;
var statearr_22699_22901 = state_22628__$1;
(statearr_22699_22901[(2)] = inst_22243);

(statearr_22699_22901[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (129))){
var inst_22243 = (state_22628[(14)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22243)){
var statearr_22700_22902 = state_22628__$1;
(statearr_22700_22902[(1)] = (131));

} else {
var statearr_22701_22903 = state_22628__$1;
(statearr_22701_22903[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (91))){
var inst_22230 = (state_22628[(13)]);
var inst_22439 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = state_22628;
var statearr_22702_22904 = state_22628__$1;
(statearr_22702_22904[(2)] = inst_22439);

(statearr_22702_22904[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (117))){
var inst_22572 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22703_22905 = state_22628__$1;
(statearr_22703_22905[(2)] = inst_22572);

(statearr_22703_22905[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (108))){
var state_22628__$1 = state_22628;
var statearr_22704_22906 = state_22628__$1;
(statearr_22704_22906[(2)] = null);

(statearr_22704_22906[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (56))){
var inst_22305 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22705_22907 = state_22628__$1;
(statearr_22705_22907[(2)] = inst_22305);

(statearr_22705_22907[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (33))){
var inst_22248 = (state_22628[(18)]);
var inst_22265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22266 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22248);
var state_22628__$1 = (function (){var statearr_22706 = state_22628;
(statearr_22706[(43)] = inst_22265);

return statearr_22706;
})();
if(cljs.core.truth_(inst_22266)){
var statearr_22707_22908 = state_22628__$1;
(statearr_22707_22908[(1)] = (36));

} else {
var statearr_22708_22909 = state_22628__$1;
(statearr_22708_22909[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (13))){
var inst_22215 = (state_22628[(42)]);
var state_22628__$1 = state_22628;
var statearr_22709_22910 = state_22628__$1;
(statearr_22709_22910[(2)] = inst_22215);

(statearr_22709_22910[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (22))){
var inst_22230 = (state_22628[(13)]);
var inst_22237 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = state_22628;
var statearr_22710_22911 = state_22628__$1;
(statearr_22710_22911[(2)] = inst_22237);

(statearr_22710_22911[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (90))){
var inst_22398 = (state_22628[(44)]);
var inst_22427 = (state_22628[(2)]);
var inst_22390 = inst_22398;
var inst_22391 = inst_22427;
var state_22628__$1 = (function (){var statearr_22711 = state_22628;
(statearr_22711[(30)] = inst_22391);

(statearr_22711[(45)] = inst_22390);

return statearr_22711;
})();
var statearr_22712_22912 = state_22628__$1;
(statearr_22712_22912[(2)] = null);

(statearr_22712_22912[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (109))){
var inst_22465 = (state_22628[(46)]);
var inst_22496 = (state_22628[(47)]);
var inst_22502 = (state_22628[(2)]);
var inst_22457 = inst_22465;
var inst_22458 = inst_22496;
var state_22628__$1 = (function (){var statearr_22713 = state_22628;
(statearr_22713[(48)] = inst_22457);

(statearr_22713[(49)] = inst_22502);

(statearr_22713[(32)] = inst_22458);

return statearr_22713;
})();
var statearr_22714_22913 = state_22628__$1;
(statearr_22714_22913[(2)] = null);

(statearr_22714_22913[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (36))){
var inst_22248 = (state_22628[(18)]);
var inst_22268 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22248,cljs.core.dec);
var state_22628__$1 = state_22628;
var statearr_22715_22914 = state_22628__$1;
(statearr_22715_22914[(2)] = inst_22268);

(statearr_22715_22914[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (41))){
var inst_22292 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22292)){
var statearr_22716_22915 = state_22628__$1;
(statearr_22716_22915[(1)] = (48));

} else {
var statearr_22717_22916 = state_22628__$1;
(statearr_22717_22916[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (118))){
var inst_22542 = (state_22628[(37)]);
var inst_22545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22546 = inst_22542.o;
var inst_22547 = [inst_22546];
var inst_22548 = (new cljs.core.PersistentVector(null,1,(5),inst_22545,inst_22547,null));
var inst_22549 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22548);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(121),inst_22549);
} else {
if((state_val_22629 === (89))){
var inst_22391 = (state_22628[(30)]);
var state_22628__$1 = state_22628;
var statearr_22718_22917 = state_22628__$1;
(statearr_22718_22917[(2)] = inst_22391);

(statearr_22718_22917[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (100))){
var inst_22458 = (state_22628[(32)]);
var state_22628__$1 = state_22628;
var statearr_22719_22918 = state_22628__$1;
(statearr_22719_22918[(2)] = inst_22458);

(statearr_22719_22918[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (131))){
var inst_22598 = (state_22628[(10)]);
var inst_22597 = (state_22628[(50)]);
var inst_22241 = (state_22628[(21)]);
var inst_22606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22607 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22241,inst_22597);
var inst_22608 = [inst_22607,inst_22598];
var inst_22609 = (new cljs.core.PersistentVector(null,2,(5),inst_22606,inst_22608,null));
var state_22628__$1 = state_22628;
var statearr_22720_22919 = state_22628__$1;
(statearr_22720_22919[(2)] = inst_22609);

(statearr_22720_22919[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (122))){
var inst_22542 = (state_22628[(37)]);
var inst_22543 = (state_22628[(39)]);
var inst_22536 = (state_22628[(33)]);
var inst_22555 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22556 = inst_22542.o;
var inst_22557 = [inst_22556];
var inst_22558 = cljs.core.PersistentHashMap.fromArrays(inst_22555,inst_22557);
var inst_22559 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22536,inst_22558);
var inst_22535 = inst_22543;
var inst_22536__$1 = inst_22559;
var state_22628__$1 = (function (){var statearr_22721 = state_22628;
(statearr_22721[(33)] = inst_22536__$1);

(statearr_22721[(38)] = inst_22535);

return statearr_22721;
})();
var statearr_22722_22920 = state_22628__$1;
(statearr_22722_22920[(2)] = null);

(statearr_22722_22920[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (43))){
var inst_22278 = (state_22628[(29)]);
var state_22628__$1 = state_22628;
var statearr_22723_22921 = state_22628__$1;
(statearr_22723_22921[(2)] = inst_22278);

(statearr_22723_22921[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (61))){
var inst_22314 = (state_22628[(51)]);
var inst_22371 = (state_22628[(2)]);
var inst_22372 = [inst_22371,offset_map];
var inst_22373 = (new cljs.core.PersistentVector(null,2,(5),inst_22314,inst_22372,null));
var state_22628__$1 = state_22628;
var statearr_22724_22922 = state_22628__$1;
(statearr_22724_22922[(2)] = inst_22373);

(statearr_22724_22922[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (29))){
var inst_22260 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22725_22923 = state_22628__$1;
(statearr_22725_22923[(2)] = inst_22260);

(statearr_22725_22923[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (44))){
var inst_22289 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22726_22924 = state_22628__$1;
(statearr_22726_22924[(2)] = inst_22289);

(statearr_22726_22924[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (93))){
var inst_22442 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22442)){
var statearr_22727_22925 = state_22628__$1;
(statearr_22727_22925[(1)] = (94));

} else {
var statearr_22728_22926 = state_22628__$1;
(statearr_22728_22926[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (6))){
var inst_22203 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22204 = (inst_22203 == null);
var state_22628__$1 = state_22628;
var statearr_22729_22927 = state_22628__$1;
(statearr_22729_22927[(2)] = inst_22204);

(statearr_22729_22927[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (111))){
var state_22628__$1 = state_22628;
var statearr_22730_22928 = state_22628__$1;
(statearr_22730_22928[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (28))){
var inst_22247 = (state_22628[(16)]);
var state_22628__$1 = state_22628;
var statearr_22732_22929 = state_22628__$1;
(statearr_22732_22929[(2)] = inst_22247);

(statearr_22732_22929[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (134))){
var inst_22598 = (state_22628[(10)]);
var inst_22597 = (state_22628[(50)]);
var inst_22241 = (state_22628[(21)]);
var inst_22612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22613 = cljs.core.first(inst_22597);
var inst_22614 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22241,inst_22613);
var inst_22615 = [inst_22614,inst_22598];
var inst_22616 = (new cljs.core.PersistentVector(null,2,(5),inst_22612,inst_22615,null));
var state_22628__$1 = state_22628;
var statearr_22733_22930 = state_22628__$1;
(statearr_22733_22930[(2)] = inst_22616);

(statearr_22733_22930[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (64))){
var inst_22369 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22734_22931 = state_22628__$1;
(statearr_22734_22931[(2)] = inst_22369);

(statearr_22734_22931[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (103))){
var inst_22458 = (state_22628[(32)]);
var inst_22464 = (state_22628[(40)]);
var inst_22481 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22482 = inst_22464.o;
var inst_22483 = [inst_22482];
var inst_22484 = cljs.core.PersistentHashMap.fromArrays(inst_22481,inst_22483);
var inst_22485 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22458,inst_22484);
var state_22628__$1 = state_22628;
var statearr_22735_22932 = state_22628__$1;
(statearr_22735_22932[(2)] = inst_22485);

(statearr_22735_22932[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (51))){
var inst_22230 = (state_22628[(13)]);
var inst_22300 = (state_22628[(34)]);
var inst_22300__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = (function (){var statearr_22736 = state_22628;
(statearr_22736[(34)] = inst_22300__$1);

return statearr_22736;
})();
if(cljs.core.truth_(inst_22300__$1)){
var statearr_22737_22933 = state_22628__$1;
(statearr_22737_22933[(1)] = (54));

} else {
var statearr_22738_22934 = state_22628__$1;
(statearr_22738_22934[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (25))){
var inst_22243 = (state_22628[(14)]);
var state_22628__$1 = state_22628;
var statearr_22739_22935 = state_22628__$1;
(statearr_22739_22935[(2)] = inst_22243);

(statearr_22739_22935[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (34))){
var inst_22243 = (state_22628[(14)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22243)){
var statearr_22740_22936 = state_22628__$1;
(statearr_22740_22936[(1)] = (39));

} else {
var statearr_22741_22937 = state_22628__$1;
(statearr_22741_22937[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (125))){
var inst_22247 = (state_22628[(16)]);
var inst_22245 = (state_22628[(17)]);
var inst_22230 = (state_22628[(13)]);
var inst_22200 = (state_22628[(35)]);
var inst_22215 = (state_22628[(42)]);
var inst_22248 = (state_22628[(18)]);
var inst_22246 = (state_22628[(19)]);
var inst_22244 = (state_22628[(20)]);
var inst_22243 = (state_22628[(14)]);
var inst_22241 = (state_22628[(21)]);
var inst_22242 = (state_22628[(15)]);
var inst_22577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22578 = (function (){var p = inst_22248;
var pred_spec__$1 = inst_22215;
var orderBy = inst_22246;
var map__22196 = inst_22242;
var multi_QMARK_ = inst_22243;
var limit = inst_22245;
var offset = inst_22247;
var k = inst_22241;
var compact_QMARK_ = inst_22200;
var pred_spec_SINGLEQUOTE_ = inst_22230;
var ref_QMARK_ = inst_22244;
return (function (p1__22187_SHARP_){
return p1__22187_SHARP_.o;
});
})();
var inst_22579 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22578,flakes);
var inst_22580 = [inst_22579,offset_map];
var inst_22581 = (new cljs.core.PersistentVector(null,2,(5),inst_22577,inst_22580,null));
var state_22628__$1 = state_22628;
var statearr_22742_22938 = state_22628__$1;
(statearr_22742_22938[(2)] = inst_22581);

(statearr_22742_22938[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (17))){
var inst_22230 = (state_22628[(13)]);
var inst_22231 = (state_22628[(52)]);
var inst_22230__$1 = (state_22628[(2)]);
var inst_22231__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22230__$1);
var state_22628__$1 = (function (){var statearr_22743 = state_22628;
(statearr_22743[(13)] = inst_22230__$1);

(statearr_22743[(52)] = inst_22231__$1);

return statearr_22743;
})();
if(cljs.core.truth_(inst_22231__$1)){
var statearr_22744_22939 = state_22628__$1;
(statearr_22744_22939[(1)] = (18));

} else {
var statearr_22745_22940 = state_22628__$1;
(statearr_22745_22940[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (3))){
var inst_22626 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22628__$1,inst_22626);
} else {
if((state_val_22629 === (12))){
var inst_22215 = (state_22628[(42)]);
var inst_22220 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22215,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22628__$1 = state_22628;
var statearr_22746_22941 = state_22628__$1;
(statearr_22746_22941[(2)] = inst_22220);

(statearr_22746_22941[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (2))){
var inst_22201 = (state_22628[(11)]);
var _ = (function (){var statearr_22747 = state_22628;
(statearr_22747[(4)] = cljs.core.cons((5),(state_22628[(4)])));

return statearr_22747;
})();
var inst_22200 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22201__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22628__$1 = (function (){var statearr_22748 = state_22628;
(statearr_22748[(35)] = inst_22200);

(statearr_22748[(11)] = inst_22201__$1);

return statearr_22748;
})();
if(cljs.core.truth_(inst_22201__$1)){
var statearr_22749_22942 = state_22628__$1;
(statearr_22749_22942[(1)] = (6));

} else {
var statearr_22750_22943 = state_22628__$1;
(statearr_22750_22943[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (66))){
var inst_22344 = (state_22628[(7)]);
var inst_22313 = (state_22628[(53)]);
var inst_22347 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22313,inst_22344) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22313,inst_22344));
var state_22628__$1 = state_22628;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22628__$1,(69),inst_22347);
} else {
if((state_val_22629 === (107))){
var inst_22478 = (state_22628[(27)]);
var inst_22498 = cljs.core.count(inst_22478);
var inst_22499 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22498);
var state_22628__$1 = state_22628;
var statearr_22751_22944 = state_22628__$1;
(statearr_22751_22944[(2)] = inst_22499);

(statearr_22751_22944[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (23))){
var inst_22239 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22752_22945 = state_22628__$1;
(statearr_22752_22945[(2)] = inst_22239);

(statearr_22752_22945[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (47))){
var inst_22286 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22753_22946 = state_22628__$1;
(statearr_22753_22946[(2)] = inst_22286);

(statearr_22753_22946[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (35))){
var inst_22597 = (state_22628[(50)]);
var inst_22596 = (state_22628[(2)]);
var inst_22597__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22596,(0),null);
var inst_22598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22596,(1),null);
var inst_22599 = cljs.core.empty_QMARK_(inst_22597__$1);
var state_22628__$1 = (function (){var statearr_22754 = state_22628;
(statearr_22754[(10)] = inst_22598);

(statearr_22754[(50)] = inst_22597__$1);

return statearr_22754;
})();
if(inst_22599){
var statearr_22755_22947 = state_22628__$1;
(statearr_22755_22947[(1)] = (128));

} else {
var statearr_22756_22948 = state_22628__$1;
(statearr_22756_22948[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (127))){
var inst_22584 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22757_22949 = state_22628__$1;
(statearr_22757_22949[(2)] = inst_22584);

(statearr_22757_22949[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (82))){
var inst_22391 = (state_22628[(30)]);
var state_22628__$1 = state_22628;
var statearr_22758_22950 = state_22628__$1;
(statearr_22758_22950[(2)] = inst_22391);

(statearr_22758_22950[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (76))){
var inst_22377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22385 = flakes;
var inst_22386 = cljs.core.seq(inst_22385);
var inst_22387 = cljs.core.first(inst_22386);
var inst_22388 = cljs.core.next(inst_22386);
var inst_22389 = cljs.core.PersistentVector.EMPTY;
var inst_22390 = inst_22385;
var inst_22391 = inst_22389;
var state_22628__$1 = (function (){var statearr_22759 = state_22628;
(statearr_22759[(54)] = inst_22388);

(statearr_22759[(55)] = inst_22377);

(statearr_22759[(56)] = inst_22387);

(statearr_22759[(30)] = inst_22391);

(statearr_22759[(45)] = inst_22390);

return statearr_22759;
})();
var statearr_22760_22951 = state_22628__$1;
(statearr_22760_22951[(2)] = null);

(statearr_22760_22951[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (97))){
var inst_22457 = (state_22628[(48)]);
var inst_22464 = (state_22628[(40)]);
var inst_22463 = cljs.core.seq(inst_22457);
var inst_22464__$1 = cljs.core.first(inst_22463);
var inst_22465 = cljs.core.next(inst_22463);
var state_22628__$1 = (function (){var statearr_22761 = state_22628;
(statearr_22761[(46)] = inst_22465);

(statearr_22761[(40)] = inst_22464__$1);

return statearr_22761;
})();
if(cljs.core.truth_(inst_22464__$1)){
var statearr_22762_22952 = state_22628__$1;
(statearr_22762_22952[(1)] = (99));

} else {
var statearr_22763_22953 = state_22628__$1;
(statearr_22763_22953[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (19))){
var inst_22230 = (state_22628[(13)]);
var inst_22234 = (state_22628[(41)]);
var inst_22234__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22230);
var state_22628__$1 = (function (){var statearr_22764 = state_22628;
(statearr_22764[(41)] = inst_22234__$1);

return statearr_22764;
})();
if(cljs.core.truth_(inst_22234__$1)){
var statearr_22765_22954 = state_22628__$1;
(statearr_22765_22954[(1)] = (21));

} else {
var statearr_22766_22955 = state_22628__$1;
(statearr_22766_22955[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (57))){
var inst_22230 = (state_22628[(13)]);
var inst_22310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22311 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22312 = (new cljs.core.PersistentVector(null,3,(5),inst_22310,inst_22311,null));
var inst_22313 = cljs.core.select_keys(inst_22230,inst_22312);
var inst_22314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22322 = flakes;
var inst_22323 = cljs.core.seq(inst_22322);
var inst_22324 = cljs.core.first(inst_22323);
var inst_22325 = cljs.core.next(inst_22323);
var inst_22326 = cljs.core.PersistentVector.EMPTY;
var inst_22327 = inst_22322;
var inst_22328 = inst_22326;
var state_22628__$1 = (function (){var statearr_22767 = state_22628;
(statearr_22767[(51)] = inst_22314);

(statearr_22767[(24)] = inst_22327);

(statearr_22767[(57)] = inst_22324);

(statearr_22767[(53)] = inst_22313);

(statearr_22767[(58)] = inst_22325);

(statearr_22767[(9)] = inst_22328);

return statearr_22767;
})();
var statearr_22768_22956 = state_22628__$1;
(statearr_22768_22956[(2)] = null);

(statearr_22768_22956[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (68))){
var inst_22353 = (state_22628[(2)]);
var state_22628__$1 = (function (){var statearr_22769 = state_22628;
(statearr_22769[(22)] = inst_22353);

return statearr_22769;
})();
if(cljs.core.truth_(fuel)){
var statearr_22770_22957 = state_22628__$1;
(statearr_22770_22957[(1)] = (70));

} else {
var statearr_22771_22958 = state_22628__$1;
(statearr_22771_22958[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (11))){
var inst_22215 = (state_22628[(42)]);
var inst_22215__$1 = (state_22628[(2)]);
var inst_22217 = cljs.core.contains_QMARK_(inst_22215__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22218 = (!(inst_22217));
var state_22628__$1 = (function (){var statearr_22772 = state_22628;
(statearr_22772[(42)] = inst_22215__$1);

return statearr_22772;
})();
if(inst_22218){
var statearr_22773_22959 = state_22628__$1;
(statearr_22773_22959[(1)] = (12));

} else {
var statearr_22774_22960 = state_22628__$1;
(statearr_22774_22960[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (115))){
var inst_22574 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22776_22961 = state_22628__$1;
(statearr_22776_22961[(2)] = inst_22574);

(statearr_22776_22961[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (9))){
var inst_22209 = cljs.core.first(flakes);
var inst_22210 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22209);
var inst_22211 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22212 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22210,inst_22211);
var state_22628__$1 = state_22628;
var statearr_22777_22962 = state_22628__$1;
(statearr_22777_22962[(2)] = inst_22212);

(statearr_22777_22962[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (5))){
var _ = (function (){var statearr_22778 = state_22628;
(statearr_22778[(4)] = cljs.core.rest((state_22628[(4)])));

return statearr_22778;
})();
var state_22628__$1 = state_22628;
var ex22775 = (state_22628__$1[(2)]);
var statearr_22779_22963 = state_22628__$1;
(statearr_22779_22963[(5)] = ex22775);


if((ex22775 instanceof Error)){
var statearr_22780_22964 = state_22628__$1;
(statearr_22780_22964[(1)] = (4));

(statearr_22780_22964[(5)] = null);

} else {
throw ex22775;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (112))){
var inst_22586 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22781_22965 = state_22628__$1;
(statearr_22781_22965[(2)] = inst_22586);

(statearr_22781_22965[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (83))){
var inst_22431 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22782_22966 = state_22628__$1;
(statearr_22782_22966[(2)] = inst_22431);

(statearr_22782_22966[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (14))){
var inst_22215 = (state_22628[(42)]);
var inst_22223 = (state_22628[(2)]);
var inst_22224 = cljs.core.contains_QMARK_(inst_22215,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22225 = (!(inst_22224));
var state_22628__$1 = (function (){var statearr_22783 = state_22628;
(statearr_22783[(36)] = inst_22223);

return statearr_22783;
})();
if(inst_22225){
var statearr_22784_22967 = state_22628__$1;
(statearr_22784_22967[(1)] = (15));

} else {
var statearr_22785_22968 = state_22628__$1;
(statearr_22785_22968[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (45))){
var inst_22245 = (state_22628[(17)]);
var inst_22241 = (state_22628[(21)]);
var inst_22281 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22241);
var inst_22282 = cljs.core.count(inst_22281);
var inst_22283 = (inst_22282 >= inst_22245);
var state_22628__$1 = state_22628;
var statearr_22786_22969 = state_22628__$1;
(statearr_22786_22969[(2)] = inst_22283);

(statearr_22786_22969[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (53))){
var inst_22308 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22308)){
var statearr_22787_22970 = state_22628__$1;
(statearr_22787_22970[(1)] = (57));

} else {
var statearr_22788_22971 = state_22628__$1;
(statearr_22788_22971[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (78))){
var inst_22590 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22789_22972 = state_22628__$1;
(statearr_22789_22972[(2)] = inst_22590);

(statearr_22789_22972[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (132))){
var state_22628__$1 = state_22628;
var statearr_22791_22973 = state_22628__$1;
(statearr_22791_22973[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (26))){
var inst_22263 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22263)){
var statearr_22793_22974 = state_22628__$1;
(statearr_22793_22974[(1)] = (33));

} else {
var statearr_22794_22975 = state_22628__$1;
(statearr_22794_22975[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (123))){
var inst_22543 = (state_22628[(39)]);
var inst_22536 = (state_22628[(33)]);
var tmp22790 = inst_22536;
var inst_22535 = inst_22543;
var inst_22536__$1 = tmp22790;
var state_22628__$1 = (function (){var statearr_22795 = state_22628;
(statearr_22795[(33)] = inst_22536__$1);

(statearr_22795[(38)] = inst_22535);

return statearr_22795;
})();
var statearr_22796_22976 = state_22628__$1;
(statearr_22796_22976[(2)] = null);

(statearr_22796_22976[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (16))){
var inst_22223 = (state_22628[(36)]);
var state_22628__$1 = state_22628;
var statearr_22797_22977 = state_22628__$1;
(statearr_22797_22977[(2)] = inst_22223);

(statearr_22797_22977[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (133))){
var inst_22621 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22798_22978 = state_22628__$1;
(statearr_22798_22978[(2)] = inst_22621);

(statearr_22798_22978[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (81))){
var inst_22406 = (state_22628[(59)]);
var inst_22230 = (state_22628[(13)]);
var inst_22397 = (state_22628[(28)]);
var inst_22400 = cljs.core.deref(cache);
var inst_22401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22402 = inst_22397.o;
var inst_22403 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22230);
var inst_22404 = [inst_22402,inst_22403];
var inst_22405 = (new cljs.core.PersistentVector(null,2,(5),inst_22401,inst_22404,null));
var inst_22406__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22400,inst_22405);
var state_22628__$1 = (function (){var statearr_22799 = state_22628;
(statearr_22799[(59)] = inst_22406__$1);

return statearr_22799;
})();
if(cljs.core.truth_(inst_22406__$1)){
var statearr_22800_22979 = state_22628__$1;
(statearr_22800_22979[(1)] = (84));

} else {
var statearr_22801_22980 = state_22628__$1;
(statearr_22801_22980[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (120))){
var inst_22570 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22802_22981 = state_22628__$1;
(statearr_22802_22981[(2)] = inst_22570);

(statearr_22802_22981[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (79))){
var inst_22397 = (state_22628[(28)]);
var inst_22390 = (state_22628[(45)]);
var inst_22396 = cljs.core.seq(inst_22390);
var inst_22397__$1 = cljs.core.first(inst_22396);
var inst_22398 = cljs.core.next(inst_22396);
var state_22628__$1 = (function (){var statearr_22803 = state_22628;
(statearr_22803[(44)] = inst_22398);

(statearr_22803[(28)] = inst_22397__$1);

return statearr_22803;
})();
if(cljs.core.truth_(inst_22397__$1)){
var statearr_22804_22982 = state_22628__$1;
(statearr_22804_22982[(1)] = (81));

} else {
var statearr_22805_22983 = state_22628__$1;
(statearr_22805_22983[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (38))){
var inst_22265 = (state_22628[(43)]);
var inst_22273 = (state_22628[(2)]);
var inst_22274 = [null,inst_22273];
var inst_22275 = (new cljs.core.PersistentVector(null,2,(5),inst_22265,inst_22274,null));
var state_22628__$1 = state_22628;
var statearr_22806_22984 = state_22628__$1;
(statearr_22806_22984[(2)] = inst_22275);

(statearr_22806_22984[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (126))){
var state_22628__$1 = state_22628;
var statearr_22807_22985 = state_22628__$1;
(statearr_22807_22985[(2)] = null);

(statearr_22807_22985[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (98))){
var inst_22444 = (state_22628[(60)]);
var inst_22508 = (state_22628[(2)]);
var inst_22509 = [inst_22508,offset_map];
var inst_22510 = (new cljs.core.PersistentVector(null,2,(5),inst_22444,inst_22509,null));
var state_22628__$1 = state_22628;
var statearr_22808_22986 = state_22628__$1;
(statearr_22808_22986[(2)] = inst_22510);

(statearr_22808_22986[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (124))){
var inst_22564 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22809_22987 = state_22628__$1;
(statearr_22809_22987[(2)] = inst_22564);

(statearr_22809_22987[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (87))){
var inst_22230 = (state_22628[(13)]);
var inst_22397 = (state_22628[(28)]);
var inst_22413 = (state_22628[(2)]);
var inst_22414 = fluree.db.util.async.throw_err(inst_22413);
var inst_22415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22416 = inst_22397.o;
var inst_22417 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22230);
var inst_22418 = [inst_22416,inst_22417];
var inst_22419 = (new cljs.core.PersistentVector(null,2,(5),inst_22415,inst_22418,null));
var inst_22420 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22419,inst_22414);
var state_22628__$1 = (function (){var statearr_22810 = state_22628;
(statearr_22810[(61)] = inst_22420);

return statearr_22810;
})();
var statearr_22811_22988 = state_22628__$1;
(statearr_22811_22988[(2)] = inst_22414);

(statearr_22811_22988[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (30))){
var inst_22248 = (state_22628[(18)]);
var inst_22253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22248);
var inst_22254 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22253);
var state_22628__$1 = state_22628;
var statearr_22812_22989 = state_22628__$1;
(statearr_22812_22989[(2)] = inst_22254);

(statearr_22812_22989[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (73))){
var inst_22328 = (state_22628[(9)]);
var inst_22353 = (state_22628[(22)]);
var inst_22362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22328,inst_22353);
var state_22628__$1 = state_22628;
var statearr_22813_22990 = state_22628__$1;
(statearr_22813_22990[(2)] = inst_22362);

(statearr_22813_22990[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (96))){
var inst_22588 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
var statearr_22814_22991 = state_22628__$1;
(statearr_22814_22991[(2)] = inst_22588);

(statearr_22814_22991[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (10))){
var state_22628__$1 = state_22628;
var statearr_22815_22992 = state_22628__$1;
(statearr_22815_22992[(2)] = pred_spec);

(statearr_22815_22992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (18))){
var inst_22231 = (state_22628[(52)]);
var state_22628__$1 = state_22628;
var statearr_22816_22993 = state_22628__$1;
(statearr_22816_22993[(2)] = inst_22231);

(statearr_22816_22993[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (105))){
var inst_22496 = (state_22628[(2)]);
var state_22628__$1 = (function (){var statearr_22817 = state_22628;
(statearr_22817[(47)] = inst_22496);

return statearr_22817;
})();
if(cljs.core.truth_(fuel)){
var statearr_22818_22994 = state_22628__$1;
(statearr_22818_22994[(1)] = (107));

} else {
var statearr_22819_22995 = state_22628__$1;
(statearr_22819_22995[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (52))){
var inst_22298 = (state_22628[(62)]);
var state_22628__$1 = state_22628;
var statearr_22820_22996 = state_22628__$1;
(statearr_22820_22996[(2)] = inst_22298);

(statearr_22820_22996[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (114))){
var inst_22530 = flakes;
var inst_22531 = cljs.core.seq(inst_22530);
var inst_22532 = cljs.core.first(inst_22531);
var inst_22533 = cljs.core.next(inst_22531);
var inst_22534 = cljs.core.PersistentVector.EMPTY;
var inst_22535 = inst_22530;
var inst_22536 = inst_22534;
var state_22628__$1 = (function (){var statearr_22821 = state_22628;
(statearr_22821[(33)] = inst_22536);

(statearr_22821[(38)] = inst_22535);

(statearr_22821[(63)] = inst_22533);

(statearr_22821[(64)] = inst_22532);

return statearr_22821;
})();
var statearr_22822_22997 = state_22628__$1;
(statearr_22822_22997[(2)] = null);

(statearr_22822_22997[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (67))){
var state_22628__$1 = state_22628;
var statearr_22823_22998 = state_22628__$1;
(statearr_22823_22998[(2)] = null);

(statearr_22823_22998[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (71))){
var state_22628__$1 = state_22628;
var statearr_22824_22999 = state_22628__$1;
(statearr_22824_22999[(2)] = null);

(statearr_22824_22999[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (42))){
var inst_22245 = (state_22628[(17)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22245)){
var statearr_22825_23000 = state_22628__$1;
(statearr_22825_23000[(1)] = (45));

} else {
var statearr_22826_23001 = state_22628__$1;
(statearr_22826_23001[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (80))){
var inst_22377 = (state_22628[(55)]);
var inst_22433 = (state_22628[(2)]);
var inst_22434 = [inst_22433,offset_map];
var inst_22435 = (new cljs.core.PersistentVector(null,2,(5),inst_22377,inst_22434,null));
var state_22628__$1 = state_22628;
var statearr_22827_23002 = state_22628__$1;
(statearr_22827_23002[(2)] = inst_22435);

(statearr_22827_23002[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (37))){
var inst_22247 = (state_22628[(16)]);
var inst_22248 = (state_22628[(18)]);
var inst_22270 = (inst_22247 - (1));
var inst_22271 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22248,inst_22270);
var state_22628__$1 = state_22628;
var statearr_22828_23003 = state_22628__$1;
(statearr_22828_23003[(2)] = inst_22271);

(statearr_22828_23003[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (63))){
var inst_22328 = (state_22628[(9)]);
var state_22628__$1 = state_22628;
var statearr_22829_23004 = state_22628__$1;
(statearr_22829_23004[(2)] = inst_22328);

(statearr_22829_23004[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (94))){
var inst_22444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22452 = flakes;
var inst_22453 = cljs.core.seq(inst_22452);
var inst_22454 = cljs.core.first(inst_22453);
var inst_22455 = cljs.core.next(inst_22453);
var inst_22456 = cljs.core.PersistentVector.EMPTY;
var inst_22457 = inst_22452;
var inst_22458 = inst_22456;
var state_22628__$1 = (function (){var statearr_22830 = state_22628;
(statearr_22830[(60)] = inst_22444);

(statearr_22830[(65)] = inst_22454);

(statearr_22830[(48)] = inst_22457);

(statearr_22830[(66)] = inst_22455);

(statearr_22830[(32)] = inst_22458);

return statearr_22830;
})();
var statearr_22831_23005 = state_22628__$1;
(statearr_22831_23005[(2)] = null);

(statearr_22831_23005[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (8))){
var inst_22207 = (state_22628[(2)]);
var state_22628__$1 = state_22628;
if(cljs.core.truth_(inst_22207)){
var statearr_22832_23006 = state_22628__$1;
(statearr_22832_23006[(1)] = (9));

} else {
var statearr_22833_23007 = state_22628__$1;
(statearr_22833_23007[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (49))){
var inst_22298 = (state_22628[(62)]);
var inst_22298__$1 = cljs.core.not(recur_QMARK_);
var state_22628__$1 = (function (){var statearr_22834 = state_22628;
(statearr_22834[(62)] = inst_22298__$1);

return statearr_22834;
})();
if(inst_22298__$1){
var statearr_22835_23008 = state_22628__$1;
(statearr_22835_23008[(1)] = (51));

} else {
var statearr_22836_23009 = state_22628__$1;
(statearr_22836_23009[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22629 === (84))){
var inst_22406 = (state_22628[(59)]);
var state_22628__$1 = state_22628;
var statearr_22837_23010 = state_22628__$1;
(statearr_22837_23010[(2)] = inst_22406);

(statearr_22837_23010[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_22838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22838[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_22838[(1)] = (1));

return statearr_22838;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_22628){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_22628);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e22839){var ex__2744__auto__ = e22839;
var statearr_22840_23011 = state_22628;
(statearr_22840_23011[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_22628[(4)]))){
var statearr_22841_23012 = state_22628;
(statearr_22841_23012[(1)] = cljs.core.first((state_22628[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23013 = state_22628;
state_22628 = G__23013;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_22628){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_22628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_22842 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_22842[(6)] = c__2763__auto__);

return statearr_22842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4253__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23173){
var state_val_23174 = (state_23173[(1)]);
if((state_val_23174 === (7))){
var inst_23168 = (state_23173[(2)]);
var _ = (function (){var statearr_23175 = state_23173;
(statearr_23175[(4)] = cljs.core.rest((state_23173[(4)])));

return statearr_23175;
})();
var state_23173__$1 = state_23173;
var statearr_23176_23258 = state_23173__$1;
(statearr_23176_23258[(2)] = inst_23168);

(statearr_23176_23258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (20))){
var inst_23095 = (state_23173[(7)]);
var state_23173__$1 = state_23173;
var statearr_23177_23259 = state_23173__$1;
(statearr_23177_23259[(2)] = inst_23095);

(statearr_23177_23259[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (27))){
var inst_23050 = (state_23173[(8)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23050)){
var statearr_23178_23260 = state_23173__$1;
(statearr_23178_23260[(1)] = (29));

} else {
var statearr_23179_23261 = state_23173__$1;
(statearr_23179_23261[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (1))){
var state_23173__$1 = state_23173;
var statearr_23180_23262 = state_23173__$1;
(statearr_23180_23262[(2)] = null);

(statearr_23180_23262[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (24))){
var inst_23051 = (state_23173[(9)]);
var state_23173__$1 = state_23173;
var statearr_23181_23263 = state_23173__$1;
(statearr_23181_23263[(2)] = inst_23051);

(statearr_23181_23263[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (39))){
var inst_23087 = (state_23173[(10)]);
var state_23173__$1 = state_23173;
var statearr_23182_23264 = state_23173__$1;
(statearr_23182_23264[(2)] = inst_23087);

(statearr_23182_23264[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (46))){
var inst_23052 = (state_23173[(11)]);
var state_23173__$1 = state_23173;
var statearr_23183_23265 = state_23173__$1;
(statearr_23183_23265[(2)] = inst_23052);

(statearr_23183_23265[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (4))){
var inst_23014 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23184_23266 = state_23173__$1;
(statearr_23184_23266[(2)] = inst_23014);

(statearr_23184_23266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (15))){
var inst_23063 = (state_23173[(12)]);
var inst_23069 = cljs.core.count(inst_23063);
var inst_23070 = fluree.db.query.fql.add_fuel(fuel,inst_23069,max_fuel);
var state_23173__$1 = state_23173;
var statearr_23185_23267 = state_23173__$1;
(statearr_23185_23267[(2)] = inst_23070);

(statearr_23185_23267[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (48))){
var inst_23032 = (state_23173[(13)]);
var inst_23154 = (state_23173[(14)]);
var inst_23039 = (state_23173[(15)]);
var inst_23162 = (state_23173[(2)]);
var inst_23163 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23032,inst_23162,inst_23154);
var inst_23031 = inst_23039;
var inst_23032__$1 = inst_23163;
var state_23173__$1 = (function (){var statearr_23186 = state_23173;
(statearr_23186[(13)] = inst_23032__$1);

(statearr_23186[(16)] = inst_23031);

return statearr_23186;
})();
var statearr_23187_23268 = state_23173__$1;
(statearr_23187_23268[(2)] = null);

(statearr_23187_23268[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (50))){
var inst_23054 = (state_23173[(17)]);
var state_23173__$1 = state_23173;
var statearr_23188_23269 = state_23173__$1;
(statearr_23188_23269[(2)] = inst_23054);

(statearr_23188_23269[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (21))){
var inst_23051 = (state_23173[(9)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23051)){
var statearr_23190_23270 = state_23173__$1;
(statearr_23190_23270[(1)] = (23));

} else {
var statearr_23191_23271 = state_23173__$1;
(statearr_23191_23271[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (31))){
var inst_23111 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23111)){
var statearr_23192_23272 = state_23173__$1;
(statearr_23192_23272[(1)] = (32));

} else {
var statearr_23193_23273 = state_23173__$1;
(statearr_23193_23273[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (32))){
var inst_23087 = (state_23173[(10)]);
var inst_23086 = (state_23173[(18)]);
var inst_23094 = (state_23173[(19)]);
var inst_23113 = (inst_23086 + (1));
var tmp23189 = inst_23087;
var inst_23085 = inst_23094;
var inst_23086__$1 = inst_23113;
var inst_23087__$1 = tmp23189;
var state_23173__$1 = (function (){var statearr_23194 = state_23173;
(statearr_23194[(10)] = inst_23087__$1);

(statearr_23194[(18)] = inst_23086__$1);

(statearr_23194[(20)] = inst_23085);

return statearr_23194;
})();
var statearr_23195_23274 = state_23173__$1;
(statearr_23195_23274[(2)] = null);

(statearr_23195_23274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (40))){
var state_23173__$1 = state_23173;
if(cljs.core.truth_(fuel)){
var statearr_23196_23275 = state_23173__$1;
(statearr_23196_23275[(1)] = (42));

} else {
var statearr_23197_23276 = state_23173__$1;
(statearr_23197_23276[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (33))){
var state_23173__$1 = state_23173;
var statearr_23198_23277 = state_23173__$1;
(statearr_23198_23277[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (13))){
var inst_23063 = (state_23173[(12)]);
var state_23173__$1 = state_23173;
var statearr_23200_23278 = state_23173__$1;
(statearr_23200_23278[(2)] = inst_23063);

(statearr_23200_23278[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (22))){
var inst_23104 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23104)){
var statearr_23201_23279 = state_23173__$1;
(statearr_23201_23279[(1)] = (26));

} else {
var statearr_23202_23280 = state_23173__$1;
(statearr_23202_23280[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (36))){
var state_23173__$1 = state_23173;
var statearr_23203_23281 = state_23173__$1;
(statearr_23203_23281[(2)] = null);

(statearr_23203_23281[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (41))){
var inst_23086 = (state_23173[(18)]);
var inst_23094 = (state_23173[(19)]);
var inst_23143 = (state_23173[(2)]);
var inst_23144 = (inst_23086 + (1));
var inst_23085 = inst_23094;
var inst_23086__$1 = inst_23144;
var inst_23087 = inst_23143;
var state_23173__$1 = (function (){var statearr_23204 = state_23173;
(statearr_23204[(10)] = inst_23087);

(statearr_23204[(18)] = inst_23086__$1);

(statearr_23204[(20)] = inst_23085);

return statearr_23204;
})();
var statearr_23205_23282 = state_23173__$1;
(statearr_23205_23282[(2)] = null);

(statearr_23205_23282[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (43))){
var state_23173__$1 = state_23173;
var statearr_23206_23283 = state_23173__$1;
(statearr_23206_23283[(2)] = null);

(statearr_23206_23283[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (29))){
var inst_23050 = (state_23173[(8)]);
var inst_23086 = (state_23173[(18)]);
var inst_23108 = (inst_23086 < inst_23050);
var state_23173__$1 = state_23173;
var statearr_23207_23284 = state_23173__$1;
(statearr_23207_23284[(2)] = inst_23108);

(statearr_23207_23284[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (44))){
var inst_23123 = (state_23173[(21)]);
var inst_23127 = (state_23173[(22)]);
var inst_23136 = (state_23173[(2)]);
var inst_23137 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23127,inst_23123) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23127,inst_23123));
var state_23173__$1 = (function (){var statearr_23208 = state_23173;
(statearr_23208[(23)] = inst_23136);

return statearr_23208;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23173__$1,(45),inst_23137);
} else {
if((state_val_23174 === (6))){
var inst_23038 = (state_23173[(24)]);
var inst_23031 = (state_23173[(16)]);
var inst_23037 = cljs.core.seq(inst_23031);
var inst_23038__$1 = cljs.core.first(inst_23037);
var inst_23039 = cljs.core.next(inst_23037);
var inst_23040 = cljs.core.not(inst_23038__$1);
var state_23173__$1 = (function (){var statearr_23209 = state_23173;
(statearr_23209[(24)] = inst_23038__$1);

(statearr_23209[(15)] = inst_23039);

return statearr_23209;
})();
if(inst_23040){
var statearr_23210_23285 = state_23173__$1;
(statearr_23210_23285[(1)] = (8));

} else {
var statearr_23211_23286 = state_23173__$1;
(statearr_23211_23286[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (28))){
var inst_23152 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23212_23287 = state_23173__$1;
(statearr_23212_23287[(2)] = inst_23152);

(statearr_23212_23287[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (51))){
var inst_23160 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23213_23288 = state_23173__$1;
(statearr_23213_23288[(2)] = inst_23160);

(statearr_23213_23288[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (25))){
var inst_23102 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23214_23289 = state_23173__$1;
(statearr_23214_23289[(2)] = inst_23102);

(statearr_23214_23289[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (34))){
var inst_23150 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23215_23290 = state_23173__$1;
(statearr_23215_23290[(2)] = inst_23150);

(statearr_23215_23290[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (17))){
var inst_23063 = (state_23173[(12)]);
var inst_23073 = (state_23173[(2)]);
var inst_23081 = cljs.core.seq(inst_23063);
var inst_23082 = cljs.core.first(inst_23081);
var inst_23083 = cljs.core.next(inst_23081);
var inst_23084 = cljs.core.PersistentVector.EMPTY;
var inst_23085 = inst_23063;
var inst_23086 = (0);
var inst_23087 = inst_23084;
var state_23173__$1 = (function (){var statearr_23216 = state_23173;
(statearr_23216[(10)] = inst_23087);

(statearr_23216[(18)] = inst_23086);

(statearr_23216[(20)] = inst_23085);

(statearr_23216[(25)] = inst_23082);

(statearr_23216[(26)] = inst_23083);

(statearr_23216[(27)] = inst_23073);

return statearr_23216;
})();
var statearr_23217_23291 = state_23173__$1;
(statearr_23217_23291[(2)] = null);

(statearr_23217_23291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (3))){
var inst_23171 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23173__$1,inst_23171);
} else {
if((state_val_23174 === (12))){
var state_23173__$1 = state_23173;
var statearr_23218_23292 = state_23173__$1;
(statearr_23218_23292[(2)] = fuel);

(statearr_23218_23292[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (2))){
var _ = (function (){var statearr_23219 = state_23173;
(statearr_23219[(4)] = cljs.core.cons((5),(state_23173[(4)])));

return statearr_23219;
})();
var inst_23027 = reverse_refs_specs;
var inst_23028 = cljs.core.seq(inst_23027);
var inst_23029 = cljs.core.first(inst_23028);
var inst_23030 = cljs.core.next(inst_23028);
var inst_23031 = inst_23027;
var inst_23032 = null;
var state_23173__$1 = (function (){var statearr_23220 = state_23173;
(statearr_23220[(28)] = inst_23029);

(statearr_23220[(29)] = inst_23030);

(statearr_23220[(13)] = inst_23032);

(statearr_23220[(16)] = inst_23031);

return statearr_23220;
})();
var statearr_23221_23293 = state_23173__$1;
(statearr_23221_23293[(2)] = null);

(statearr_23221_23293[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (23))){
var inst_23086 = (state_23173[(18)]);
var inst_23051 = (state_23173[(9)]);
var inst_23099 = (inst_23086 >= inst_23051);
var state_23173__$1 = state_23173;
var statearr_23222_23294 = state_23173__$1;
(statearr_23222_23294[(2)] = inst_23099);

(statearr_23222_23294[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (47))){
var inst_23053 = (state_23173[(30)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23053)){
var statearr_23223_23295 = state_23173__$1;
(statearr_23223_23295[(1)] = (49));

} else {
var statearr_23224_23296 = state_23173__$1;
(statearr_23224_23296[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (35))){
var inst_23093 = (state_23173[(31)]);
var inst_23117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23118 = [inst_23093];
var inst_23119 = (new cljs.core.PersistentVector(null,1,(5),inst_23117,inst_23118,null));
var inst_23120 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23119);
var state_23173__$1 = state_23173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23173__$1,(38),inst_23120);
} else {
if((state_val_23174 === (19))){
var inst_23052 = (state_23173[(11)]);
var inst_23154 = (state_23173[(2)]);
var state_23173__$1 = (function (){var statearr_23225 = state_23173;
(statearr_23225[(14)] = inst_23154);

return statearr_23225;
})();
if(cljs.core.truth_(inst_23052)){
var statearr_23226_23297 = state_23173__$1;
(statearr_23226_23297[(1)] = (46));

} else {
var statearr_23227_23298 = state_23173__$1;
(statearr_23227_23298[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (11))){
var inst_23063 = (state_23173[(12)]);
var inst_23060 = (state_23173[(2)]);
var inst_23061 = fluree.db.util.async.throw_err(inst_23060);
var inst_23062 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23061);
var inst_23063__$1 = cljs.core.not_empty(inst_23062);
var state_23173__$1 = (function (){var statearr_23229 = state_23173;
(statearr_23229[(12)] = inst_23063__$1);

return statearr_23229;
})();
if(cljs.core.truth_(inst_23063__$1)){
var statearr_23230_23299 = state_23173__$1;
(statearr_23230_23299[(1)] = (12));

} else {
var statearr_23231_23300 = state_23173__$1;
(statearr_23231_23300[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (9))){
var inst_23038 = (state_23173[(24)]);
var inst_23048 = (state_23173[(32)]);
var inst_23047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23038,(0),null);
var inst_23048__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23038,(1),null);
var inst_23049 = cljs.core.__destructure_map(inst_23048__$1);
var inst_23050 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23049,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_23051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23049,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23052 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23049,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23049,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_23054 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23049,new cljs.core.Keyword(null,"p","p",151049309));
var inst_23055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23056 = [subject_id,inst_23047];
var inst_23057 = (new cljs.core.PersistentVector(null,2,(5),inst_23055,inst_23056,null));
var inst_23058 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_23057);
var state_23173__$1 = (function (){var statearr_23232 = state_23173;
(statearr_23232[(8)] = inst_23050);

(statearr_23232[(30)] = inst_23053);

(statearr_23232[(17)] = inst_23054);

(statearr_23232[(9)] = inst_23051);

(statearr_23232[(32)] = inst_23048__$1);

(statearr_23232[(11)] = inst_23052);

return statearr_23232;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23173__$1,(11),inst_23058);
} else {
if((state_val_23174 === (5))){
var _ = (function (){var statearr_23233 = state_23173;
(statearr_23233[(4)] = cljs.core.rest((state_23173[(4)])));

return statearr_23233;
})();
var state_23173__$1 = state_23173;
var ex23228 = (state_23173__$1[(2)]);
var statearr_23234_23301 = state_23173__$1;
(statearr_23234_23301[(5)] = ex23228);


if((ex23228 instanceof Error)){
var statearr_23235_23302 = state_23173__$1;
(statearr_23235_23302[(1)] = (4));

(statearr_23235_23302[(5)] = null);

} else {
throw ex23228;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (14))){
var inst_23067 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
if(cljs.core.truth_(inst_23067)){
var statearr_23236_23303 = state_23173__$1;
(statearr_23236_23303[(1)] = (15));

} else {
var statearr_23237_23304 = state_23173__$1;
(statearr_23237_23304[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (45))){
var inst_23087 = (state_23173[(10)]);
var inst_23139 = (state_23173[(2)]);
var inst_23140 = fluree.db.util.async.throw_err(inst_23139);
var inst_23141 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23087,inst_23140);
var state_23173__$1 = state_23173;
var statearr_23238_23305 = state_23173__$1;
(statearr_23238_23305[(2)] = inst_23141);

(statearr_23238_23305[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (26))){
var inst_23087 = (state_23173[(10)]);
var state_23173__$1 = state_23173;
var statearr_23239_23306 = state_23173__$1;
(statearr_23239_23306[(2)] = inst_23087);

(statearr_23239_23306[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (16))){
var state_23173__$1 = state_23173;
var statearr_23240_23307 = state_23173__$1;
(statearr_23240_23307[(2)] = null);

(statearr_23240_23307[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (38))){
var inst_23048 = (state_23173[(32)]);
var inst_23123 = (state_23173[(21)]);
var inst_23122 = (state_23173[(2)]);
var inst_23123__$1 = fluree.db.util.async.throw_err(inst_23122);
var inst_23124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23125 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23126 = (new cljs.core.PersistentVector(null,4,(5),inst_23124,inst_23125,null));
var inst_23127 = cljs.core.select_keys(inst_23048,inst_23126);
var inst_23128 = cljs.core.empty_QMARK_(inst_23123__$1);
var state_23173__$1 = (function (){var statearr_23241 = state_23173;
(statearr_23241[(21)] = inst_23123__$1);

(statearr_23241[(22)] = inst_23127);

return statearr_23241;
})();
if(inst_23128){
var statearr_23242_23308 = state_23173__$1;
(statearr_23242_23308[(1)] = (39));

} else {
var statearr_23243_23309 = state_23173__$1;
(statearr_23243_23309[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (30))){
var inst_23050 = (state_23173[(8)]);
var state_23173__$1 = state_23173;
var statearr_23244_23310 = state_23173__$1;
(statearr_23244_23310[(2)] = inst_23050);

(statearr_23244_23310[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (10))){
var inst_23166 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23245_23311 = state_23173__$1;
(statearr_23245_23311[(2)] = inst_23166);

(statearr_23245_23311[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (18))){
var inst_23085 = (state_23173[(20)]);
var inst_23093 = (state_23173[(31)]);
var inst_23095 = (state_23173[(7)]);
var inst_23092 = cljs.core.seq(inst_23085);
var inst_23093__$1 = cljs.core.first(inst_23092);
var inst_23094 = cljs.core.next(inst_23092);
var inst_23095__$1 = cljs.core.not(inst_23093__$1);
var state_23173__$1 = (function (){var statearr_23246 = state_23173;
(statearr_23246[(19)] = inst_23094);

(statearr_23246[(31)] = inst_23093__$1);

(statearr_23246[(7)] = inst_23095__$1);

return statearr_23246;
})();
if(inst_23095__$1){
var statearr_23247_23312 = state_23173__$1;
(statearr_23247_23312[(1)] = (20));

} else {
var statearr_23248_23313 = state_23173__$1;
(statearr_23248_23313[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (42))){
var inst_23123 = (state_23173[(21)]);
var inst_23132 = cljs.core.count(inst_23123);
var inst_23133 = fluree.db.query.fql.add_fuel(fuel,inst_23132,max_fuel);
var state_23173__$1 = state_23173;
var statearr_23249_23314 = state_23173__$1;
(statearr_23249_23314[(2)] = inst_23133);

(statearr_23249_23314[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (37))){
var inst_23148 = (state_23173[(2)]);
var state_23173__$1 = state_23173;
var statearr_23250_23315 = state_23173__$1;
(statearr_23250_23315[(2)] = inst_23148);

(statearr_23250_23315[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (8))){
var inst_23032 = (state_23173[(13)]);
var state_23173__$1 = state_23173;
var statearr_23251_23316 = state_23173__$1;
(statearr_23251_23316[(2)] = inst_23032);

(statearr_23251_23316[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23174 === (49))){
var inst_23053 = (state_23173[(30)]);
var state_23173__$1 = state_23173;
var statearr_23252_23317 = state_23173__$1;
(statearr_23252_23317[(2)] = inst_23053);

(statearr_23252_23317[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0 = (function (){
var statearr_23253 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23253[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__);

(statearr_23253[(1)] = (1));

return statearr_23253;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1 = (function (state_23173){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_23173);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23254){var ex__2744__auto__ = e23254;
var statearr_23255_23318 = state_23173;
(statearr_23255_23318[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_23173[(4)]))){
var statearr_23256_23319 = state_23173;
(statearr_23256_23319[(1)] = cljs.core.first((state_23173[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23320 = state_23173;
state_23173 = G__23320;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__ = function(state_23173){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1.call(this,state_23173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23257 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_23257[(6)] = c__2763__auto__);

return statearr_23257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23321 = select_spec;
var map__23321__$1 = cljs.core.__destructure_map(map__23321);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23321__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23321__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23435){
var state_val_23436 = (state_23435[(1)]);
if((state_val_23436 === (7))){
var inst_23347 = flakes;
var inst_23348 = cljs.core.seq(inst_23347);
var inst_23349 = cljs.core.first(inst_23348);
var inst_23350 = cljs.core.next(inst_23348);
var inst_23351 = cljs.core.PersistentVector.EMPTY;
var inst_23352 = inst_23347;
var inst_23353 = (0);
var inst_23354 = inst_23351;
var state_23435__$1 = (function (){var statearr_23437 = state_23435;
(statearr_23437[(7)] = inst_23353);

(statearr_23437[(8)] = inst_23354);

(statearr_23437[(9)] = inst_23350);

(statearr_23437[(10)] = inst_23349);

(statearr_23437[(11)] = inst_23352);

return statearr_23437;
})();
var statearr_23438_23504 = state_23435__$1;
(statearr_23438_23504[(2)] = null);

(statearr_23438_23504[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (20))){
var state_23435__$1 = state_23435;
var statearr_23439_23505 = state_23435__$1;
(statearr_23439_23505[(2)] = results);

(statearr_23439_23505[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (27))){
var state_23435__$1 = state_23435;
var statearr_23440_23506 = state_23435__$1;
(statearr_23440_23506[(2)] = null);

(statearr_23440_23506[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (1))){
var state_23435__$1 = state_23435;
var statearr_23441_23507 = state_23435__$1;
(statearr_23441_23507[(2)] = null);

(statearr_23441_23507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (24))){
var state_23435__$1 = state_23435;
var statearr_23442_23508 = state_23435__$1;
(statearr_23442_23508[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (39))){
var inst_23354 = (state_23435[(8)]);
var inst_23361 = (state_23435[(12)]);
var inst_23416 = (state_23435[(13)]);
var inst_23419 = (state_23435[(2)]);
var inst_23420 = fluree.db.util.async.throw_err(inst_23419);
var inst_23421 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23354,inst_23420);
var inst_23352 = inst_23361;
var inst_23353 = inst_23416;
var inst_23354__$1 = inst_23421;
var state_23435__$1 = (function (){var statearr_23444 = state_23435;
(statearr_23444[(7)] = inst_23353);

(statearr_23444[(8)] = inst_23354__$1);

(statearr_23444[(11)] = inst_23352);

return statearr_23444;
})();
var statearr_23445_23509 = state_23435__$1;
(statearr_23445_23509[(2)] = null);

(statearr_23445_23509[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (4))){
var inst_23322 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23446_23510 = state_23435__$1;
(statearr_23446_23510[(2)] = inst_23322);

(statearr_23446_23510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (15))){
var inst_23335 = (state_23435[(14)]);
var state_23435__$1 = state_23435;
var statearr_23447_23511 = state_23435__$1;
(statearr_23447_23511[(2)] = inst_23335);

(statearr_23447_23511[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (21))){
var inst_23331 = (state_23435[(15)]);
var state_23435__$1 = state_23435;
if(cljs.core.truth_(inst_23331)){
var statearr_23448_23512 = state_23435__$1;
(statearr_23448_23512[(1)] = (23));

} else {
var statearr_23449_23513 = state_23435__$1;
(statearr_23449_23513[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (31))){
var inst_23399 = (state_23435[(16)]);
var state_23435__$1 = state_23435;
var statearr_23450_23514 = state_23435__$1;
(statearr_23450_23514[(2)] = inst_23399);

(statearr_23450_23514[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (32))){
var inst_23391 = (state_23435[(17)]);
var inst_23405 = (state_23435[(2)]);
var state_23435__$1 = (function (){var statearr_23451 = state_23435;
(statearr_23451[(18)] = inst_23405);

return statearr_23451;
})();
if(cljs.core.truth_(inst_23391)){
var statearr_23452_23515 = state_23435__$1;
(statearr_23452_23515[(1)] = (33));

} else {
var statearr_23453_23516 = state_23435__$1;
(statearr_23453_23516[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (33))){
var inst_23391 = (state_23435[(17)]);
var state_23435__$1 = state_23435;
var statearr_23454_23517 = state_23435__$1;
(statearr_23454_23517[(2)] = inst_23391);

(statearr_23454_23517[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (13))){
var inst_23371 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
if(cljs.core.truth_(inst_23371)){
var statearr_23456_23518 = state_23435__$1;
(statearr_23456_23518[(1)] = (17));

} else {
var statearr_23457_23519 = state_23435__$1;
(statearr_23457_23519[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (22))){
var inst_23388 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23458_23520 = state_23435__$1;
(statearr_23458_23520[(2)] = inst_23388);

(statearr_23458_23520[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (36))){
var inst_23353 = (state_23435[(7)]);
var inst_23354 = (state_23435[(8)]);
var inst_23361 = (state_23435[(12)]);
var inst_23413 = (inst_23353 + (1));
var tmp23455 = inst_23354;
var inst_23352 = inst_23361;
var inst_23353__$1 = inst_23413;
var inst_23354__$1 = tmp23455;
var state_23435__$1 = (function (){var statearr_23459 = state_23435;
(statearr_23459[(7)] = inst_23353__$1);

(statearr_23459[(8)] = inst_23354__$1);

(statearr_23459[(11)] = inst_23352);

return statearr_23459;
})();
var statearr_23460_23521 = state_23435__$1;
(statearr_23460_23521[(2)] = null);

(statearr_23460_23521[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (29))){
var inst_23398 = (state_23435[(2)]);
var inst_23399 = fluree.db.util.async.throw_err(inst_23398);
var state_23435__$1 = (function (){var statearr_23461 = state_23435;
(statearr_23461[(16)] = inst_23399);

return statearr_23461;
})();
if(cljs.core.truth_(fuel)){
var statearr_23462_23522 = state_23435__$1;
(statearr_23462_23522[(1)] = (30));

} else {
var statearr_23463_23523 = state_23435__$1;
(statearr_23463_23523[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (6))){
var state_23435__$1 = state_23435;
var statearr_23464_23524 = state_23435__$1;
(statearr_23464_23524[(2)] = results);

(statearr_23464_23524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (28))){
var inst_23384 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23465_23525 = state_23435__$1;
(statearr_23465_23525[(2)] = inst_23384);

(statearr_23465_23525[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (25))){
var inst_23386 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23466_23526 = state_23435__$1;
(statearr_23466_23526[(2)] = inst_23386);

(statearr_23466_23526[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (34))){
var inst_23405 = (state_23435[(18)]);
var inst_23408 = cljs.core.empty_QMARK_(inst_23405);
var state_23435__$1 = state_23435;
var statearr_23467_23527 = state_23435__$1;
(statearr_23467_23527[(2)] = inst_23408);

(statearr_23467_23527[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (17))){
var inst_23354 = (state_23435[(8)]);
var inst_23373 = cljs.core.empty_QMARK_(inst_23354);
var state_23435__$1 = state_23435;
if(inst_23373){
var statearr_23468_23528 = state_23435__$1;
(statearr_23468_23528[(1)] = (20));

} else {
var statearr_23469_23529 = state_23435__$1;
(statearr_23469_23529[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (3))){
var inst_23433 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23435__$1,inst_23433);
} else {
if((state_val_23436 === (12))){
var inst_23335 = (state_23435[(14)]);
var state_23435__$1 = state_23435;
if(cljs.core.truth_(inst_23335)){
var statearr_23470_23530 = state_23435__$1;
(statearr_23470_23530[(1)] = (14));

} else {
var statearr_23471_23531 = state_23435__$1;
(statearr_23471_23531[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (2))){
var _ = (function (){var statearr_23472 = state_23435;
(statearr_23472[(4)] = cljs.core.cons((5),(state_23435[(4)])));

return statearr_23472;
})();
var inst_23329 = select_spec;
var inst_23330 = cljs.core.__destructure_map(inst_23329);
var inst_23331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23330,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23330,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23330,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23334 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23330,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23330,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23336 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23337 = (inst_23334 > inst_23336);
var state_23435__$1 = (function (){var statearr_23473 = state_23435;
(statearr_23473[(14)] = inst_23335);

(statearr_23473[(19)] = inst_23332);

(statearr_23473[(15)] = inst_23331);

(statearr_23473[(20)] = inst_23333);

return statearr_23473;
})();
if(cljs.core.truth_(inst_23337)){
var statearr_23474_23532 = state_23435__$1;
(statearr_23474_23532[(1)] = (6));

} else {
var statearr_23475_23533 = state_23435__$1;
(statearr_23475_23533[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (23))){
var inst_23354 = (state_23435[(8)]);
var inst_23332 = (state_23435[(19)]);
var inst_23377 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23332,inst_23354);
var state_23435__$1 = state_23435;
var statearr_23476_23534 = state_23435__$1;
(statearr_23476_23534[(2)] = inst_23377);

(statearr_23476_23534[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (35))){
var inst_23360 = (state_23435[(21)]);
var inst_23410 = (state_23435[(2)]);
var inst_23411 = fluree.db.query.fql.recur_select_spec(select_spec,inst_23360);
var state_23435__$1 = (function (){var statearr_23477 = state_23435;
(statearr_23477[(22)] = inst_23411);

return statearr_23477;
})();
if(cljs.core.truth_(inst_23410)){
var statearr_23478_23535 = state_23435__$1;
(statearr_23478_23535[(1)] = (36));

} else {
var statearr_23479_23536 = state_23435__$1;
(statearr_23479_23536[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (19))){
var inst_23426 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23480_23537 = state_23435__$1;
(statearr_23480_23537[(2)] = inst_23426);

(statearr_23480_23537[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (11))){
var inst_23362 = (state_23435[(23)]);
var state_23435__$1 = state_23435;
var statearr_23482_23538 = state_23435__$1;
(statearr_23482_23538[(2)] = inst_23362);

(statearr_23482_23538[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (9))){
var inst_23362 = (state_23435[(23)]);
var inst_23360 = (state_23435[(21)]);
var inst_23352 = (state_23435[(11)]);
var inst_23359 = cljs.core.seq(inst_23352);
var inst_23360__$1 = cljs.core.first(inst_23359);
var inst_23361 = cljs.core.next(inst_23359);
var inst_23362__$1 = cljs.core.not(inst_23360__$1);
var state_23435__$1 = (function (){var statearr_23483 = state_23435;
(statearr_23483[(23)] = inst_23362__$1);

(statearr_23483[(12)] = inst_23361);

(statearr_23483[(21)] = inst_23360__$1);

return statearr_23483;
})();
if(inst_23362__$1){
var statearr_23484_23539 = state_23435__$1;
(statearr_23484_23539[(1)] = (11));

} else {
var statearr_23485_23540 = state_23435__$1;
(statearr_23485_23540[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (5))){
var _ = (function (){var statearr_23486 = state_23435;
(statearr_23486[(4)] = cljs.core.rest((state_23435[(4)])));

return statearr_23486;
})();
var state_23435__$1 = state_23435;
var ex23481 = (state_23435__$1[(2)]);
var statearr_23487_23541 = state_23435__$1;
(statearr_23487_23541[(5)] = ex23481);


if((ex23481 instanceof Error)){
var statearr_23488_23542 = state_23435__$1;
(statearr_23488_23542[(1)] = (4));

(statearr_23488_23542[(5)] = null);

} else {
throw ex23481;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (14))){
var inst_23353 = (state_23435[(7)]);
var inst_23335 = (state_23435[(14)]);
var inst_23366 = (inst_23353 < inst_23335);
var state_23435__$1 = state_23435;
var statearr_23489_23543 = state_23435__$1;
(statearr_23489_23543[(2)] = inst_23366);

(statearr_23489_23543[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (26))){
var inst_23354 = (state_23435[(8)]);
var inst_23332 = (state_23435[(19)]);
var inst_23380 = cljs.core.first(inst_23354);
var inst_23381 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_23332,inst_23380);
var state_23435__$1 = state_23435;
var statearr_23490_23544 = state_23435__$1;
(statearr_23490_23544[(2)] = inst_23381);

(statearr_23490_23544[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (16))){
var inst_23369 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23491_23545 = state_23435__$1;
(statearr_23491_23545[(2)] = inst_23369);

(statearr_23491_23545[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (38))){
var inst_23424 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23492_23546 = state_23435__$1;
(statearr_23492_23546[(2)] = inst_23424);

(statearr_23492_23546[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (30))){
var inst_23399 = (state_23435[(16)]);
var inst_23401 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_23402 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23401,inst_23399);
var state_23435__$1 = state_23435;
var statearr_23493_23547 = state_23435__$1;
(statearr_23493_23547[(2)] = inst_23402);

(statearr_23493_23547[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (10))){
var inst_23428 = (state_23435[(2)]);
var state_23435__$1 = state_23435;
var statearr_23494_23548 = state_23435__$1;
(statearr_23494_23548[(2)] = inst_23428);

(statearr_23494_23548[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23436 === (18))){
var inst_23333 = (state_23435[(20)]);
var inst_23360 = (state_23435[(21)]);
var inst_23390 = inst_23360.o;
var inst_23391 = cljs.core.contains_QMARK_(inst_23333,inst_23390);
var inst_23393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23394 = [inst_23390];
var inst_23395 = (new cljs.core.PersistentVector(null,1,(5),inst_23393,inst_23394,null));
var inst_23396 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23395);
var state_23435__$1 = (function (){var statearr_23495 = state_23435;
(statearr_23495[(17)] = inst_23391);

return statearr_23495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23435__$1,(29),inst_23396);
} else {
if((state_val_23436 === (37))){
var inst_23353 = (state_23435[(7)]);
var inst_23411 = (state_23435[(22)]);
var inst_23405 = (state_23435[(18)]);
var inst_23416 = (inst_23353 + (1));
var inst_23417 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23411,inst_23405) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23411,inst_23405));
var state_23435__$1 = (function (){var statearr_23496 = state_23435;
(statearr_23496[(13)] = inst_23416);

return statearr_23496;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23435__$1,(39),inst_23417);
} else {
if((state_val_23436 === (8))){
var inst_23430 = (state_23435[(2)]);
var _ = (function (){var statearr_23497 = state_23435;
(statearr_23497[(4)] = cljs.core.rest((state_23435[(4)])));

return statearr_23497;
})();
var state_23435__$1 = state_23435;
var statearr_23498_23549 = state_23435__$1;
(statearr_23498_23549[(2)] = inst_23430);

(statearr_23498_23549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0 = (function (){
var statearr_23499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23499[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__);

(statearr_23499[(1)] = (1));

return statearr_23499;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1 = (function (state_23435){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_23435);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23500){var ex__2744__auto__ = e23500;
var statearr_23501_23550 = state_23435;
(statearr_23501_23550[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_23435[(4)]))){
var statearr_23502_23551 = state_23435;
(statearr_23502_23551[(1)] = cljs.core.first((state_23435[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23552 = state_23435;
state_23435 = G__23552;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__ = function(state_23435){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1.call(this,state_23435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23503 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_23503[(6)] = c__2763__auto__);

return statearr_23503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23733){
var state_val_23734 = (state_23733[(1)]);
if((state_val_23734 === (7))){
var state_23733__$1 = state_23733;
var statearr_23735_23821 = state_23733__$1;
(statearr_23735_23821[(2)] = null);

(statearr_23735_23821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (20))){
var inst_23591 = cljs.core.PersistentHashMap.EMPTY;
var state_23733__$1 = state_23733;
var statearr_23736_23822 = state_23733__$1;
(statearr_23736_23822[(2)] = inst_23591);

(statearr_23736_23822[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (27))){
var inst_23609 = (state_23733[(7)]);
var inst_23579 = (state_23733[(8)]);
var inst_23573 = (state_23733[(9)]);
var inst_23593 = (state_23733[(10)]);
var inst_23712 = (state_23733[(2)]);
var inst_23713 = (function (){var top_level_subject = inst_23573;
var select_spec = inst_23579;
var base_acc = inst_23593;
var acc_PLUS_refs = inst_23609;
var result = inst_23712;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23714 = cljs.core.PersistentVector.EMPTY;
var inst_23715 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23579);
var inst_23716 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23715);
var inst_23717 = cljs.core.vals(inst_23716);
var inst_23718 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23579);
var inst_23719 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23718);
var inst_23720 = cljs.core.vals(inst_23719);
var inst_23721 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23717,inst_23720);
var inst_23722 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23713,inst_23714,inst_23721);
var inst_23724 = (function (){var top_level_subject = inst_23573;
var select_spec = inst_23579;
var base_acc = inst_23593;
var acc_PLUS_refs = inst_23609;
var result = inst_23712;
var sort_preds = inst_23722;
return (function (acc,p__23723){
var vec__23737 = p__23723;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23737,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23737,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23737,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23737,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23725 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23724,inst_23712,inst_23722);
var state_23733__$1 = state_23733;
var statearr_23740_23823 = state_23733__$1;
(statearr_23740_23823[(2)] = inst_23725);

(statearr_23740_23823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (1))){
var state_23733__$1 = state_23733;
var statearr_23741_23824 = state_23733__$1;
(statearr_23741_23824[(2)] = null);

(statearr_23741_23824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (24))){
var inst_23609 = (state_23733[(7)]);
var inst_23609__$1 = (state_23733[(2)]);
var inst_23610 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23611 = cljs.core.PersistentHashMap.EMPTY;
var inst_23612 = inst_23610;
var inst_23613 = inst_23609__$1;
var inst_23614 = inst_23611;
var state_23733__$1 = (function (){var statearr_23742 = state_23733;
(statearr_23742[(7)] = inst_23609__$1);

(statearr_23742[(11)] = inst_23613);

(statearr_23742[(12)] = inst_23614);

(statearr_23742[(13)] = inst_23612);

return statearr_23742;
})();
var statearr_23743_23825 = state_23733__$1;
(statearr_23743_23825[(2)] = null);

(statearr_23743_23825[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (39))){
var inst_23613 = (state_23733[(11)]);
var inst_23579 = (state_23733[(8)]);
var inst_23622 = (state_23733[(14)]);
var inst_23629 = (state_23733[(15)]);
var inst_23658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23659 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23613,inst_23579,inst_23622,inst_23629,false);
var state_23733__$1 = (function (){var statearr_23744 = state_23733;
(statearr_23744[(16)] = inst_23658);

return statearr_23744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23733__$1,(42),inst_23659);
} else {
if((state_val_23734 === (46))){
var inst_23614 = (state_23733[(12)]);
var inst_23622 = (state_23733[(14)]);
var inst_23612 = (state_23733[(13)]);
var inst_23676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23677 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23678 = cljs.core.first(inst_23622);
var inst_23679 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23678);
var inst_23680 = [inst_23679];
var inst_23681 = cljs.core.PersistentHashMap.fromArrays(inst_23677,inst_23680);
var inst_23682 = cljs.core.rest(inst_23612);
var inst_23683 = [inst_23681,inst_23682,inst_23614];
var inst_23684 = (new cljs.core.PersistentVector(null,3,(5),inst_23676,inst_23683,null));
var state_23733__$1 = state_23733;
var statearr_23745_23826 = state_23733__$1;
(statearr_23745_23826[(2)] = inst_23684);

(statearr_23745_23826[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (4))){
var inst_23553 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23746_23827 = state_23733__$1;
(statearr_23746_23827[(2)] = inst_23553);

(statearr_23746_23827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (15))){
var inst_23580 = (state_23733[(17)]);
var inst_23579 = (state_23733[(8)]);
var inst_23579__$1 = (state_23733[(2)]);
var inst_23580__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23579__$1);
var state_23733__$1 = (function (){var statearr_23747 = state_23733;
(statearr_23747[(17)] = inst_23580__$1);

(statearr_23747[(8)] = inst_23579__$1);

return statearr_23747;
})();
if(cljs.core.truth_(inst_23580__$1)){
var statearr_23748_23828 = state_23733__$1;
(statearr_23748_23828[(1)] = (16));

} else {
var statearr_23749_23829 = state_23733__$1;
(statearr_23749_23829[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (48))){
var inst_23695 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23750_23830 = state_23733__$1;
(statearr_23750_23830[(2)] = inst_23695);

(statearr_23750_23830[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (50))){
var state_23733__$1 = state_23733;
var statearr_23751_23831 = state_23733__$1;
(statearr_23751_23831[(2)] = null);

(statearr_23751_23831[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (21))){
var inst_23579 = (state_23733[(8)]);
var inst_23593 = (state_23733[(2)]);
var inst_23594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23595 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23596 = (new cljs.core.PersistentVector(null,2,(5),inst_23594,inst_23595,null));
var inst_23597 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23579,inst_23596);
var state_23733__$1 = (function (){var statearr_23752 = state_23733;
(statearr_23752[(10)] = inst_23593);

return statearr_23752;
})();
if(cljs.core.truth_(inst_23597)){
var statearr_23753_23832 = state_23733__$1;
(statearr_23753_23832[(1)] = (22));

} else {
var statearr_23754_23833 = state_23733__$1;
(statearr_23754_23833[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (31))){
var inst_23613 = (state_23733[(11)]);
var inst_23628 = (state_23733[(18)]);
var inst_23622 = (state_23733[(14)]);
var inst_23632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23633 = fluree.db.query.fql.flake__GT_recur(db,inst_23622,inst_23628,inst_23613,fuel,max_fuel,cache);
var state_23733__$1 = (function (){var statearr_23755 = state_23733;
(statearr_23755[(19)] = inst_23632);

return statearr_23755;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23733__$1,(34),inst_23633);
} else {
if((state_val_23734 === (32))){
var inst_23628 = (state_23733[(18)]);
var state_23733__$1 = state_23733;
if(cljs.core.truth_(inst_23628)){
var statearr_23756_23834 = state_23733__$1;
(statearr_23756_23834[(1)] = (35));

} else {
var statearr_23757_23835 = state_23733__$1;
(statearr_23757_23835[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (40))){
var inst_23669 = (state_23733[(20)]);
var inst_23579 = (state_23733[(8)]);
var inst_23668 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23579);
var inst_23669__$1 = cljs.core.empty_QMARK_(inst_23668);
var state_23733__$1 = (function (){var statearr_23758 = state_23733;
(statearr_23758[(20)] = inst_23669__$1);

return statearr_23758;
})();
if(inst_23669__$1){
var statearr_23759_23836 = state_23733__$1;
(statearr_23759_23836[(1)] = (43));

} else {
var statearr_23760_23837 = state_23733__$1;
(statearr_23760_23837[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (33))){
var inst_23622 = (state_23733[(14)]);
var inst_23701 = (state_23733[(2)]);
var inst_23702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23701,(0),null);
var inst_23703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23701,(1),null);
var inst_23704 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23701,(2),null);
var inst_23705 = cljs.core.first(inst_23622);
var inst_23706 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23705);
var inst_23707 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23702,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23706);
var inst_23612 = inst_23703;
var inst_23613 = inst_23707;
var inst_23614 = inst_23704;
var state_23733__$1 = (function (){var statearr_23761 = state_23733;
(statearr_23761[(11)] = inst_23613);

(statearr_23761[(12)] = inst_23614);

(statearr_23761[(13)] = inst_23612);

return statearr_23761;
})();
var statearr_23762_23838 = state_23733__$1;
(statearr_23762_23838[(2)] = null);

(statearr_23762_23838[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (13))){
var inst_23573 = (state_23733[(9)]);
var inst_23576 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23573);
var state_23733__$1 = state_23733;
var statearr_23763_23839 = state_23733__$1;
(statearr_23763_23839[(2)] = inst_23576);

(statearr_23763_23839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (22))){
var inst_23579 = (state_23733[(8)]);
var inst_23599 = cljs.core.first(flakes);
var inst_23600 = fluree.db.query.fql.s(inst_23599);
var inst_23601 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23579);
var inst_23602 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23600,inst_23601);
var state_23733__$1 = state_23733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23733__$1,(25),inst_23602);
} else {
if((state_val_23734 === (36))){
var inst_23579 = (state_23733[(8)]);
var inst_23656 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23579);
var state_23733__$1 = state_23733;
if(cljs.core.truth_(inst_23656)){
var statearr_23764_23840 = state_23733__$1;
(statearr_23764_23840[(1)] = (39));

} else {
var statearr_23765_23841 = state_23733__$1;
(statearr_23765_23841[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (41))){
var inst_23697 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23766_23842 = state_23733__$1;
(statearr_23766_23842[(2)] = inst_23697);

(statearr_23766_23842[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (43))){
var inst_23579 = (state_23733[(8)]);
var inst_23671 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23579);
var state_23733__$1 = state_23733;
var statearr_23767_23843 = state_23733__$1;
(statearr_23767_23843[(2)] = inst_23671);

(statearr_23767_23843[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (29))){
var inst_23628 = (state_23733[(18)]);
var inst_23579 = (state_23733[(8)]);
var inst_23622 = (state_23733[(14)]);
var inst_23612 = (state_23733[(13)]);
var inst_23622__$1 = cljs.core.first(inst_23612);
var inst_23623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23624 = cljs.core.first(inst_23622__$1);
var inst_23625 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23624);
var inst_23626 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23625];
var inst_23627 = (new cljs.core.PersistentVector(null,3,(5),inst_23623,inst_23626,null));
var inst_23628__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23579,inst_23627);
var inst_23629 = fluree.db.query.fql.component_follow_QMARK_(inst_23628__$1,inst_23579);
var inst_23630 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23628__$1);
var state_23733__$1 = (function (){var statearr_23768 = state_23733;
(statearr_23768[(18)] = inst_23628__$1);

(statearr_23768[(14)] = inst_23622__$1);

(statearr_23768[(15)] = inst_23629);

return statearr_23768;
})();
if(cljs.core.truth_(inst_23630)){
var statearr_23769_23844 = state_23733__$1;
(statearr_23769_23844[(1)] = (31));

} else {
var statearr_23770_23845 = state_23733__$1;
(statearr_23770_23845[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (44))){
var inst_23669 = (state_23733[(20)]);
var state_23733__$1 = state_23733;
var statearr_23771_23846 = state_23733__$1;
(statearr_23771_23846[(2)] = inst_23669);

(statearr_23771_23846[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (6))){
var state_23733__$1 = state_23733;
var statearr_23772_23847 = state_23733__$1;
(statearr_23772_23847[(2)] = null);

(statearr_23772_23847[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (28))){
var inst_23613 = (state_23733[(11)]);
var state_23733__$1 = state_23733;
var statearr_23773_23848 = state_23733__$1;
(statearr_23773_23848[(2)] = inst_23613);

(statearr_23773_23848[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (51))){
var inst_23693 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23774_23849 = state_23733__$1;
(statearr_23774_23849[(2)] = inst_23693);

(statearr_23774_23849[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (25))){
var inst_23593 = (state_23733[(10)]);
var inst_23604 = (state_23733[(2)]);
var inst_23605 = fluree.db.util.async.throw_err(inst_23604);
var inst_23606 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23593,inst_23605], 0));
var state_23733__$1 = state_23733;
var statearr_23775_23850 = state_23733__$1;
(statearr_23775_23850[(2)] = inst_23606);

(statearr_23775_23850[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (34))){
var inst_23614 = (state_23733[(12)]);
var inst_23612 = (state_23733[(13)]);
var inst_23632 = (state_23733[(19)]);
var inst_23635 = (state_23733[(2)]);
var inst_23636 = fluree.db.util.async.throw_err(inst_23635);
var inst_23637 = cljs.core.rest(inst_23612);
var inst_23638 = [inst_23636,inst_23637,inst_23614];
var inst_23639 = (new cljs.core.PersistentVector(null,3,(5),inst_23632,inst_23638,null));
var state_23733__$1 = state_23733;
var statearr_23776_23851 = state_23733__$1;
(statearr_23776_23851[(2)] = inst_23639);

(statearr_23776_23851[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (17))){
var inst_23579 = (state_23733[(8)]);
var inst_23583 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23579);
var state_23733__$1 = state_23733;
var statearr_23778_23852 = state_23733__$1;
(statearr_23778_23852[(2)] = inst_23583);

(statearr_23778_23852[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (3))){
var inst_23731 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23733__$1,inst_23731);
} else {
if((state_val_23734 === (12))){
var _ = (function (){var statearr_23779 = state_23733;
(statearr_23779[(4)] = cljs.core.rest((state_23733[(4)])));

return statearr_23779;
})();
var state_23733__$1 = state_23733;
var ex23777 = (state_23733__$1[(2)]);
var statearr_23780_23853 = state_23733__$1;
(statearr_23780_23853[(5)] = ex23777);


var statearr_23781_23854 = state_23733__$1;
(statearr_23781_23854[(1)] = (11));

(statearr_23781_23854[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (2))){
var _ = (function (){var statearr_23782 = state_23733;
(statearr_23782[(4)] = cljs.core.cons((5),(state_23733[(4)])));

return statearr_23782;
})();
var inst_23559 = cljs.core.not_empty(flakes);
var state_23733__$1 = state_23733;
if(cljs.core.truth_(inst_23559)){
var statearr_23783_23855 = state_23733__$1;
(statearr_23783_23855[(1)] = (6));

} else {
var statearr_23784_23856 = state_23733__$1;
(statearr_23784_23856[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (23))){
var inst_23593 = (state_23733[(10)]);
var state_23733__$1 = state_23733;
var statearr_23785_23857 = state_23733__$1;
(statearr_23785_23857[(2)] = inst_23593);

(statearr_23785_23857[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (47))){
var state_23733__$1 = state_23733;
var statearr_23786_23858 = state_23733__$1;
(statearr_23786_23858[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (35))){
var inst_23613 = (state_23733[(11)]);
var inst_23614 = (state_23733[(12)]);
var inst_23628 = (state_23733[(18)]);
var inst_23622 = (state_23733[(14)]);
var inst_23629 = (state_23733[(15)]);
var inst_23645 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23613,inst_23628,inst_23622,inst_23629,false,inst_23614);
var state_23733__$1 = state_23733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23733__$1,(38),inst_23645);
} else {
if((state_val_23734 === (19))){
var inst_23573 = (state_23733[(9)]);
var inst_23587 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23588 = [inst_23573];
var inst_23589 = cljs.core.PersistentHashMap.fromArrays(inst_23587,inst_23588);
var state_23733__$1 = state_23733;
var statearr_23788_23859 = state_23733__$1;
(statearr_23788_23859[(2)] = inst_23589);

(statearr_23788_23859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (11))){
var inst_23561 = (state_23733[(2)]);
var inst_23562 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23561], 0));
var inst_23563 = (function(){throw inst_23561})();
var state_23733__$1 = (function (){var statearr_23790 = state_23733;
(statearr_23790[(21)] = inst_23562);

return statearr_23790;
})();
var statearr_23791_23860 = state_23733__$1;
(statearr_23791_23860[(2)] = inst_23563);

(statearr_23791_23860[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (9))){
var _ = (function (){var statearr_23792 = state_23733;
(statearr_23792[(4)] = cljs.core.cons((12),(state_23733[(4)])));

return statearr_23792;
})();
var inst_23569 = cljs.core.first(flakes);
var inst_23570 = fluree.db.query.fql.s(inst_23569);
var ___$1 = (function (){var statearr_23793 = state_23733;
(statearr_23793[(4)] = cljs.core.rest((state_23733[(4)])));

return statearr_23793;
})();
var state_23733__$1 = state_23733;
var statearr_23794_23861 = state_23733__$1;
(statearr_23794_23861[(2)] = inst_23570);

(statearr_23794_23861[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (5))){
var _ = (function (){var statearr_23795 = state_23733;
(statearr_23795[(4)] = cljs.core.rest((state_23733[(4)])));

return statearr_23795;
})();
var state_23733__$1 = state_23733;
var ex23789 = (state_23733__$1[(2)]);
var statearr_23796_23862 = state_23733__$1;
(statearr_23796_23862[(5)] = ex23789);


if((ex23789 instanceof Error)){
var statearr_23797_23863 = state_23733__$1;
(statearr_23797_23863[(1)] = (4));

(statearr_23797_23863[(5)] = null);

} else {
throw ex23789;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (14))){
var state_23733__$1 = state_23733;
var statearr_23798_23864 = state_23733__$1;
(statearr_23798_23864[(2)] = base_select_spec);

(statearr_23798_23864[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (45))){
var inst_23674 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
if(cljs.core.truth_(inst_23674)){
var statearr_23799_23865 = state_23733__$1;
(statearr_23799_23865[(1)] = (46));

} else {
var statearr_23800_23866 = state_23733__$1;
(statearr_23800_23866[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (26))){
var inst_23612 = (state_23733[(13)]);
var inst_23616 = cljs.core.empty_QMARK_(inst_23612);
var state_23733__$1 = state_23733;
if(inst_23616){
var statearr_23801_23867 = state_23733__$1;
(statearr_23801_23867[(1)] = (28));

} else {
var statearr_23802_23868 = state_23733__$1;
(statearr_23802_23868[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (16))){
var inst_23580 = (state_23733[(17)]);
var state_23733__$1 = state_23733;
var statearr_23803_23869 = state_23733__$1;
(statearr_23803_23869[(2)] = inst_23580);

(statearr_23803_23869[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (38))){
var inst_23612 = (state_23733[(13)]);
var inst_23647 = (state_23733[(2)]);
var inst_23648 = fluree.db.util.async.throw_err(inst_23647);
var inst_23649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23648,(0),null);
var inst_23650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23648,(1),null);
var inst_23651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23652 = cljs.core.rest(inst_23612);
var inst_23653 = [inst_23649,inst_23652,inst_23650];
var inst_23654 = (new cljs.core.PersistentVector(null,3,(5),inst_23651,inst_23653,null));
var state_23733__$1 = state_23733;
var statearr_23804_23870 = state_23733__$1;
(statearr_23804_23870[(2)] = inst_23654);

(statearr_23804_23870[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (30))){
var inst_23710 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23805_23871 = state_23733__$1;
(statearr_23805_23871[(2)] = inst_23710);

(statearr_23805_23871[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (10))){
var inst_23573 = (state_23733[(2)]);
var inst_23574 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23733__$1 = (function (){var statearr_23806 = state_23733;
(statearr_23806[(9)] = inst_23573);

return statearr_23806;
})();
if(cljs.core.truth_(inst_23574)){
var statearr_23807_23872 = state_23733__$1;
(statearr_23807_23872[(1)] = (13));

} else {
var statearr_23808_23873 = state_23733__$1;
(statearr_23808_23873[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (18))){
var inst_23585 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
if(cljs.core.truth_(inst_23585)){
var statearr_23809_23874 = state_23733__$1;
(statearr_23809_23874[(1)] = (19));

} else {
var statearr_23810_23875 = state_23733__$1;
(statearr_23810_23875[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (42))){
var inst_23614 = (state_23733[(12)]);
var inst_23658 = (state_23733[(16)]);
var inst_23612 = (state_23733[(13)]);
var inst_23661 = (state_23733[(2)]);
var inst_23662 = fluree.db.util.async.throw_err(inst_23661);
var inst_23663 = cljs.core.first(inst_23662);
var inst_23664 = cljs.core.rest(inst_23612);
var inst_23665 = [inst_23663,inst_23664,inst_23614];
var inst_23666 = (new cljs.core.PersistentVector(null,3,(5),inst_23658,inst_23665,null));
var state_23733__$1 = state_23733;
var statearr_23811_23876 = state_23733__$1;
(statearr_23811_23876[(2)] = inst_23666);

(statearr_23811_23876[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (37))){
var inst_23699 = (state_23733[(2)]);
var state_23733__$1 = state_23733;
var statearr_23812_23877 = state_23733__$1;
(statearr_23812_23877[(2)] = inst_23699);

(statearr_23812_23877[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (8))){
var inst_23728 = (state_23733[(2)]);
var _ = (function (){var statearr_23813 = state_23733;
(statearr_23813[(4)] = cljs.core.rest((state_23733[(4)])));

return statearr_23813;
})();
var state_23733__$1 = state_23733;
var statearr_23814_23878 = state_23733__$1;
(statearr_23814_23878[(2)] = inst_23728);

(statearr_23814_23878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23734 === (49))){
var inst_23613 = (state_23733[(11)]);
var inst_23614 = (state_23733[(12)]);
var inst_23612 = (state_23733[(13)]);
var inst_23687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23688 = cljs.core.rest(inst_23612);
var inst_23689 = [inst_23613,inst_23688,inst_23614];
var inst_23690 = (new cljs.core.PersistentVector(null,3,(5),inst_23687,inst_23689,null));
var state_23733__$1 = state_23733;
var statearr_23815_23879 = state_23733__$1;
(statearr_23815_23879[(2)] = inst_23690);

(statearr_23815_23879[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0 = (function (){
var statearr_23816 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23816[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__);

(statearr_23816[(1)] = (1));

return statearr_23816;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1 = (function (state_23733){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_23733);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23817){var ex__2744__auto__ = e23817;
var statearr_23818_23880 = state_23733;
(statearr_23818_23880[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_23733[(4)]))){
var statearr_23819_23881 = state_23733;
(statearr_23819_23881[(1)] = cljs.core.first((state_23733[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23882 = state_23733;
state_23733 = G__23882;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__ = function(state_23733){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1.call(this,state_23733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23820 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_23820[(6)] = c__2763__auto__);

return statearr_23820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23885 = arguments.length;
switch (G__23885) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23927){
var state_val_23928 = (state_23927[(1)]);
if((state_val_23928 === (7))){
var inst_23893 = (state_23927[(7)]);
var state_23927__$1 = state_23927;
var statearr_23929_23959 = state_23927__$1;
(statearr_23929_23959[(2)] = inst_23893);

(statearr_23929_23959[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (1))){
var state_23927__$1 = state_23927;
var statearr_23930_23960 = state_23927__$1;
(statearr_23930_23960[(2)] = null);

(statearr_23930_23960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (4))){
var inst_23886 = (state_23927[(2)]);
var state_23927__$1 = state_23927;
var statearr_23931_23961 = state_23927__$1;
(statearr_23931_23961[(2)] = inst_23886);

(statearr_23931_23961[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (15))){
var inst_23921 = (state_23927[(2)]);
var inst_23922 = fluree.db.util.async.throw_err(inst_23921);
var _ = (function (){var statearr_23932 = state_23927;
(statearr_23932[(4)] = cljs.core.rest((state_23927[(4)])));

return statearr_23932;
})();
var state_23927__$1 = state_23927;
var statearr_23933_23962 = state_23927__$1;
(statearr_23933_23962[(2)] = inst_23922);

(statearr_23933_23962[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (13))){
var inst_23905 = (state_23927[(8)]);
var state_23927__$1 = state_23927;
var statearr_23934_23963 = state_23927__$1;
(statearr_23934_23963[(2)] = inst_23905);

(statearr_23934_23963[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (6))){
var inst_23893 = (state_23927[(7)]);
var inst_23895 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23896 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23893,inst_23895);
var state_23927__$1 = state_23927;
var statearr_23935_23964 = state_23927__$1;
(statearr_23935_23964[(2)] = inst_23896);

(statearr_23935_23964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (3))){
var inst_23925 = (state_23927[(2)]);
var state_23927__$1 = state_23927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23927__$1,inst_23925);
} else {
if((state_val_23928 === (12))){
var inst_23905 = (state_23927[(8)]);
var inst_23907 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23908 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23905,inst_23907);
var state_23927__$1 = state_23927;
var statearr_23936_23965 = state_23927__$1;
(statearr_23936_23965[(2)] = inst_23908);

(statearr_23936_23965[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (2))){
var _ = (function (){var statearr_23937 = state_23927;
(statearr_23937[(4)] = cljs.core.cons((5),(state_23927[(4)])));

return statearr_23937;
})();
var inst_23893 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23927__$1 = (function (){var statearr_23938 = state_23927;
(statearr_23938[(7)] = inst_23893);

return statearr_23938;
})();
if(cljs.core.truth_(fuel)){
var statearr_23939_23966 = state_23927__$1;
(statearr_23939_23966[(1)] = (6));

} else {
var statearr_23940_23967 = state_23927__$1;
(statearr_23940_23967[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (11))){
var inst_23905 = (state_23927[(2)]);
var state_23927__$1 = (function (){var statearr_23942 = state_23927;
(statearr_23942[(8)] = inst_23905);

return statearr_23942;
})();
if(cljs.core.truth_(limit)){
var statearr_23943_23968 = state_23927__$1;
(statearr_23943_23968[(1)] = (12));

} else {
var statearr_23944_23969 = state_23927__$1;
(statearr_23944_23969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (9))){
var inst_23899 = (state_23927[(9)]);
var inst_23901 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23902 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23899,inst_23901);
var state_23927__$1 = state_23927;
var statearr_23945_23970 = state_23927__$1;
(statearr_23945_23970[(2)] = inst_23902);

(statearr_23945_23970[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (5))){
var _ = (function (){var statearr_23946 = state_23927;
(statearr_23946[(4)] = cljs.core.rest((state_23927[(4)])));

return statearr_23946;
})();
var state_23927__$1 = state_23927;
var ex23941 = (state_23927__$1[(2)]);
var statearr_23947_23971 = state_23927__$1;
(statearr_23947_23971[(5)] = ex23941);


if((ex23941 instanceof Error)){
var statearr_23948_23972 = state_23927__$1;
(statearr_23948_23972[(1)] = (4));

(statearr_23948_23972[(5)] = null);

} else {
throw ex23941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (14))){
var inst_23911 = (state_23927[(2)]);
var inst_23912 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_23913 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23912);
var inst_23914 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23911,inst_23913);
var inst_23915 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23914,flakes);
var inst_23916 = cljs.core.PersistentVector.EMPTY;
var inst_23917 = (function (){var xf = inst_23914;
var flakes_by_sub = inst_23915;
return (function (p1__23883_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23883_SHARP_);
});
})();
var inst_23918 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23917,inst_23915);
var inst_23919 = fluree.db.util.async.merge_into_QMARK_(inst_23916,inst_23918);
var state_23927__$1 = state_23927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23927__$1,(15),inst_23919);
} else {
if((state_val_23928 === (10))){
var inst_23899 = (state_23927[(9)]);
var state_23927__$1 = state_23927;
var statearr_23949_23973 = state_23927__$1;
(statearr_23949_23973[(2)] = inst_23899);

(statearr_23949_23973[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23928 === (8))){
var inst_23899 = (state_23927[(2)]);
var state_23927__$1 = (function (){var statearr_23950 = state_23927;
(statearr_23950[(9)] = inst_23899);

return statearr_23950;
})();
if(cljs.core.truth_(offset)){
var statearr_23951_23974 = state_23927__$1;
(statearr_23951_23974[(1)] = (9));

} else {
var statearr_23952_23975 = state_23927__$1;
(statearr_23952_23975[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_23953 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23953[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_23953[(1)] = (1));

return statearr_23953;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_23927){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_23927);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23954){var ex__2744__auto__ = e23954;
var statearr_23955_23976 = state_23927;
(statearr_23955_23976[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_23927[(4)]))){
var statearr_23956_23977 = state_23927;
(statearr_23956_23977[(1)] = cljs.core.first((state_23927[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23978 = state_23927;
state_23927 = G__23978;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_23927){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_23927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23957 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_23957[(6)] = c__2763__auto__);

return statearr_23957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23980 = arguments.length;
switch (G__23980) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24066){
var state_val_24067 = (state_24066[(1)]);
if((state_val_24067 === (7))){
var inst_24061 = (state_24066[(2)]);
var _ = (function (){var statearr_24069 = state_24066;
(statearr_24069[(4)] = cljs.core.rest((state_24066[(4)])));

return statearr_24069;
})();
var state_24066__$1 = state_24066;
var statearr_24070_24122 = state_24066__$1;
(statearr_24070_24122[(2)] = inst_24061);

(statearr_24070_24122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (20))){
var inst_24001 = (state_24066[(7)]);
var inst_24008 = (state_24066[(8)]);
var inst_24000 = (state_24066[(9)]);
var inst_24029 = (inst_24000 + (1));
var tmp24068 = inst_24001;
var inst_23999 = inst_24008;
var inst_24000__$1 = inst_24029;
var inst_24001__$1 = tmp24068;
var state_24066__$1 = (function (){var statearr_24071 = state_24066;
(statearr_24071[(7)] = inst_24001__$1);

(statearr_24071[(9)] = inst_24000__$1);

(statearr_24071[(10)] = inst_23999);

return statearr_24071;
})();
var statearr_24072_24123 = state_24066__$1;
(statearr_24072_24123[(2)] = null);

(statearr_24072_24123[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (27))){
var inst_24039 = (state_24066[(11)]);
var inst_24041 = cljs.core.count(inst_24039);
var inst_24042 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24041);
var state_24066__$1 = state_24066;
var statearr_24073_24124 = state_24066__$1;
(statearr_24073_24124[(2)] = inst_24042);

(statearr_24073_24124[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (1))){
var state_24066__$1 = state_24066;
var statearr_24074_24125 = state_24066__$1;
(statearr_24074_24125[(2)] = null);

(statearr_24074_24125[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (24))){
var state_24066__$1 = state_24066;
var statearr_24075_24126 = state_24066__$1;
(statearr_24075_24126[(2)] = null);

(statearr_24075_24126[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (4))){
var inst_23981 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24076_24127 = state_24066__$1;
(statearr_24076_24127[(2)] = inst_23981);

(statearr_24076_24127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (15))){
var inst_24022 = (state_24066[(12)]);
var inst_24022__$1 = offset;
var state_24066__$1 = (function (){var statearr_24077 = state_24066;
(statearr_24077[(12)] = inst_24022__$1);

return statearr_24077;
})();
if(cljs.core.truth_(inst_24022__$1)){
var statearr_24078_24128 = state_24066__$1;
(statearr_24078_24128[(1)] = (17));

} else {
var statearr_24079_24129 = state_24066__$1;
(statearr_24079_24129[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (21))){
var state_24066__$1 = state_24066;
var statearr_24080_24130 = state_24066__$1;
(statearr_24080_24130[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (13))){
var inst_24017 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24082_24131 = state_24066__$1;
(statearr_24082_24131[(2)] = inst_24017);

(statearr_24082_24131[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (22))){
var inst_24057 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24083_24132 = state_24066__$1;
(statearr_24083_24132[(2)] = inst_24057);

(statearr_24083_24132[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (29))){
var inst_24000 = (state_24066[(9)]);
var inst_24039 = (state_24066[(11)]);
var inst_24045 = (state_24066[(2)]);
var inst_24046 = (inst_24000 + (1));
var inst_24047 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_24039);
var state_24066__$1 = (function (){var statearr_24084 = state_24066;
(statearr_24084[(13)] = inst_24046);

(statearr_24084[(14)] = inst_24045);

return statearr_24084;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(30),inst_24047);
} else {
if((state_val_24067 === (6))){
var inst_24007 = (state_24066[(15)]);
var inst_24009 = (state_24066[(16)]);
var inst_23999 = (state_24066[(10)]);
var inst_24006 = cljs.core.seq(inst_23999);
var inst_24007__$1 = cljs.core.first(inst_24006);
var inst_24008 = cljs.core.next(inst_24006);
var inst_24009__$1 = (inst_24007__$1 == null);
var state_24066__$1 = (function (){var statearr_24085 = state_24066;
(statearr_24085[(8)] = inst_24008);

(statearr_24085[(15)] = inst_24007__$1);

(statearr_24085[(16)] = inst_24009__$1);

return statearr_24085;
})();
if(cljs.core.truth_(inst_24009__$1)){
var statearr_24086_24133 = state_24066__$1;
(statearr_24086_24133[(1)] = (8));

} else {
var statearr_24087_24134 = state_24066__$1;
(statearr_24087_24134[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (28))){
var state_24066__$1 = state_24066;
var statearr_24088_24135 = state_24066__$1;
(statearr_24088_24135[(2)] = null);

(statearr_24088_24135[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (25))){
var inst_24055 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24089_24136 = state_24066__$1;
(statearr_24089_24136[(2)] = inst_24055);

(statearr_24089_24136[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (17))){
var inst_24000 = (state_24066[(9)]);
var inst_24024 = (inst_24000 < offset);
var state_24066__$1 = state_24066;
var statearr_24090_24137 = state_24066__$1;
(statearr_24090_24137[(2)] = inst_24024);

(statearr_24090_24137[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (3))){
var inst_24064 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24066__$1,inst_24064);
} else {
if((state_val_24067 === (12))){
var inst_24012 = (state_24066[(17)]);
var state_24066__$1 = state_24066;
var statearr_24091_24138 = state_24066__$1;
(statearr_24091_24138[(2)] = inst_24012);

(statearr_24091_24138[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (2))){
var _ = (function (){var statearr_24092 = state_24066;
(statearr_24092[(4)] = cljs.core.cons((5),(state_24066[(4)])));

return statearr_24092;
})();
var inst_23994 = subjects;
var inst_23995 = cljs.core.seq(inst_23994);
var inst_23996 = cljs.core.first(inst_23995);
var inst_23997 = cljs.core.next(inst_23995);
var inst_23998 = cljs.core.PersistentVector.EMPTY;
var inst_23999 = inst_23994;
var inst_24000 = (0);
var inst_24001 = inst_23998;
var state_24066__$1 = (function (){var statearr_24093 = state_24066;
(statearr_24093[(7)] = inst_24001);

(statearr_24093[(18)] = inst_23997);

(statearr_24093[(9)] = inst_24000);

(statearr_24093[(19)] = inst_23996);

(statearr_24093[(10)] = inst_23999);

return statearr_24093;
})();
var statearr_24094_24139 = state_24066__$1;
(statearr_24094_24139[(2)] = null);

(statearr_24094_24139[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (23))){
var inst_24007 = (state_24066[(15)]);
var inst_24033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24034 = [inst_24007];
var inst_24035 = (new cljs.core.PersistentVector(null,1,(5),inst_24033,inst_24034,null));
var inst_24036 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_24035);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(26),inst_24036);
} else {
if((state_val_24067 === (19))){
var inst_24027 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_24027)){
var statearr_24095_24140 = state_24066__$1;
(statearr_24095_24140[(1)] = (20));

} else {
var statearr_24096_24141 = state_24066__$1;
(statearr_24096_24141[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (11))){
var inst_24000 = (state_24066[(9)]);
var inst_24014 = (inst_24000 > limit);
var state_24066__$1 = state_24066;
var statearr_24098_24142 = state_24066__$1;
(statearr_24098_24142[(2)] = inst_24014);

(statearr_24098_24142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (9))){
var inst_24012 = (state_24066[(17)]);
var inst_24012__$1 = limit;
var state_24066__$1 = (function (){var statearr_24099 = state_24066;
(statearr_24099[(17)] = inst_24012__$1);

return statearr_24099;
})();
if(cljs.core.truth_(inst_24012__$1)){
var statearr_24100_24143 = state_24066__$1;
(statearr_24100_24143[(1)] = (11));

} else {
var statearr_24101_24144 = state_24066__$1;
(statearr_24101_24144[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (5))){
var _ = (function (){var statearr_24102 = state_24066;
(statearr_24102[(4)] = cljs.core.rest((state_24066[(4)])));

return statearr_24102;
})();
var state_24066__$1 = state_24066;
var ex24097 = (state_24066__$1[(2)]);
var statearr_24103_24145 = state_24066__$1;
(statearr_24103_24145[(5)] = ex24097);


if((ex24097 instanceof Error)){
var statearr_24104_24146 = state_24066__$1;
(statearr_24104_24146[(1)] = (4));

(statearr_24104_24146[(5)] = null);

} else {
throw ex24097;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (14))){
var inst_24001 = (state_24066[(7)]);
var state_24066__$1 = state_24066;
var statearr_24105_24147 = state_24066__$1;
(statearr_24105_24147[(2)] = inst_24001);

(statearr_24105_24147[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (26))){
var inst_24038 = (state_24066[(2)]);
var inst_24039 = fluree.db.util.async.throw_err(inst_24038);
var state_24066__$1 = (function (){var statearr_24106 = state_24066;
(statearr_24106[(11)] = inst_24039);

return statearr_24106;
})();
if(cljs.core.truth_(fuel)){
var statearr_24107_24148 = state_24066__$1;
(statearr_24107_24148[(1)] = (27));

} else {
var statearr_24108_24149 = state_24066__$1;
(statearr_24108_24149[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (16))){
var inst_24059 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24109_24150 = state_24066__$1;
(statearr_24109_24150[(2)] = inst_24059);

(statearr_24109_24150[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (30))){
var inst_24001 = (state_24066[(7)]);
var inst_24046 = (state_24066[(13)]);
var inst_24008 = (state_24066[(8)]);
var inst_24049 = (state_24066[(2)]);
var inst_24050 = fluree.db.util.async.throw_err(inst_24049);
var inst_24051 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24001,inst_24050);
var inst_23999 = inst_24008;
var inst_24000 = inst_24046;
var inst_24001__$1 = inst_24051;
var state_24066__$1 = (function (){var statearr_24110 = state_24066;
(statearr_24110[(7)] = inst_24001__$1);

(statearr_24110[(9)] = inst_24000);

(statearr_24110[(10)] = inst_23999);

return statearr_24110;
})();
var statearr_24111_24151 = state_24066__$1;
(statearr_24111_24151[(2)] = null);

(statearr_24111_24151[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (10))){
var inst_24019 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_24019)){
var statearr_24112_24152 = state_24066__$1;
(statearr_24112_24152[(1)] = (14));

} else {
var statearr_24113_24153 = state_24066__$1;
(statearr_24113_24153[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (18))){
var inst_24022 = (state_24066[(12)]);
var state_24066__$1 = state_24066;
var statearr_24114_24154 = state_24066__$1;
(statearr_24114_24154[(2)] = inst_24022);

(statearr_24114_24154[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (8))){
var inst_24009 = (state_24066[(16)]);
var state_24066__$1 = state_24066;
var statearr_24115_24155 = state_24066__$1;
(statearr_24115_24155[(2)] = inst_24009);

(statearr_24115_24155[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_24116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24116[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_24116[(1)] = (1));

return statearr_24116;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_24066){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24066);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24117){var ex__2744__auto__ = e24117;
var statearr_24118_24156 = state_24066;
(statearr_24118_24156[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24066[(4)]))){
var statearr_24119_24157 = state_24066;
(statearr_24119_24157[(1)] = cljs.core.first((state_24066[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24158 = state_24066;
state_24066 = G__24158;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_24066){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_24066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24120 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24120[(6)] = c__2763__auto__);

return statearr_24120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24160 = arguments.length;
switch (G__24160) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24161){
var map__24162 = p__24161;
var map__24162__$1 = cljs.core.__destructure_map(map__24162);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24162__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24162__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24426){
var state_val_24427 = (state_24426[(1)]);
if((state_val_24427 === (65))){
var inst_24389 = (state_24426[(7)]);
var inst_24389__$1 = (state_24426[(2)]);
var state_24426__$1 = (function (){var statearr_24428 = state_24426;
(statearr_24428[(7)] = inst_24389__$1);

return statearr_24428;
})();
if(cljs.core.truth_(inst_24389__$1)){
var statearr_24429_24547 = state_24426__$1;
(statearr_24429_24547[(1)] = (66));

} else {
var statearr_24430_24548 = state_24426__$1;
(statearr_24430_24548[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (70))){
var inst_24392 = (state_24426[(8)]);
var state_24426__$1 = state_24426;
var statearr_24431_24549 = state_24426__$1;
(statearr_24431_24549[(2)] = inst_24392);

(statearr_24431_24549[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (62))){
var inst_24380 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24432_24550 = state_24426__$1;
(statearr_24432_24550[(2)] = inst_24380);

(statearr_24432_24550[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (74))){
var inst_24399 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24433_24551 = state_24426__$1;
(statearr_24433_24551[(2)] = inst_24399);

(statearr_24433_24551[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (7))){
var inst_24175 = (state_24426[(9)]);
var state_24426__$1 = state_24426;
var statearr_24434_24552 = state_24426__$1;
(statearr_24434_24552[(2)] = inst_24175);

(statearr_24434_24552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (59))){
var inst_24204 = (state_24426[(10)]);
var inst_24372 = cljs.core.empty_QMARK_(inst_24204);
var state_24426__$1 = state_24426;
if(inst_24372){
var statearr_24435_24553 = state_24426__$1;
(statearr_24435_24553[(1)] = (60));

} else {
var statearr_24436_24554 = state_24426__$1;
(statearr_24436_24554[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (20))){
var state_24426__$1 = state_24426;
if(cljs.core.truth_(offset)){
var statearr_24437_24555 = state_24426__$1;
(statearr_24437_24555[(1)] = (23));

} else {
var statearr_24438_24556 = state_24426__$1;
(statearr_24438_24556[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (72))){
var inst_24189 = (state_24426[(11)]);
var inst_24369 = (state_24426[(12)]);
var inst_24395 = cljs.core.count(inst_24369);
var inst_24396 = (inst_24395 > inst_24189);
var state_24426__$1 = state_24426;
var statearr_24439_24557 = state_24426__$1;
(statearr_24439_24557[(2)] = inst_24396);

(statearr_24439_24557[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (58))){
var inst_24369 = (state_24426[(12)]);
var inst_24204 = (state_24426[(10)]);
var inst_24370 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24204,inst_24369);
var state_24426__$1 = state_24426;
var statearr_24440_24558 = state_24426__$1;
(statearr_24440_24558[(2)] = inst_24370);

(statearr_24440_24558[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (60))){
var inst_24369 = (state_24426[(12)]);
var inst_24204 = (state_24426[(10)]);
var inst_24374 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24204,inst_24369);
var state_24426__$1 = state_24426;
var statearr_24441_24559 = state_24426__$1;
(statearr_24441_24559[(2)] = inst_24374);

(statearr_24441_24559[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (27))){
var inst_24219 = (state_24426[(13)]);
var state_24426__$1 = state_24426;
var statearr_24442_24560 = state_24426__$1;
(statearr_24442_24560[(2)] = inst_24219);

(statearr_24442_24560[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (1))){
var state_24426__$1 = state_24426;
var statearr_24443_24561 = state_24426__$1;
(statearr_24443_24561[(2)] = null);

(statearr_24443_24561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (69))){
var inst_24189 = (state_24426[(11)]);
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24189)){
var statearr_24444_24562 = state_24426__$1;
(statearr_24444_24562[(1)] = (72));

} else {
var statearr_24445_24563 = state_24426__$1;
(statearr_24445_24563[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (24))){
var inst_24204 = (state_24426[(10)]);
var state_24426__$1 = state_24426;
var statearr_24446_24564 = state_24426__$1;
(statearr_24446_24564[(2)] = inst_24204);

(statearr_24446_24564[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (55))){
var inst_24358 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24447_24565 = state_24426__$1;
(statearr_24447_24565[(2)] = inst_24358);

(statearr_24447_24565[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (39))){
var inst_24366 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24448_24566 = state_24426__$1;
(statearr_24448_24566[(2)] = inst_24366);

(statearr_24448_24566[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (46))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24324 = (inst_24248.cljs$core$IFn$_invoke$arity$2 ? inst_24248.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24230) : inst_24248.call(null,cljs.core._LT_,inst_24230));
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24324)){
var statearr_24449_24567 = state_24426__$1;
(statearr_24449_24567[(1)] = (49));

} else {
var statearr_24450_24568 = state_24426__$1;
(statearr_24450_24568[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (4))){
var inst_24163 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24451_24569 = state_24426__$1;
(statearr_24451_24569[(2)] = inst_24163);

(statearr_24451_24569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (77))){
var inst_24414 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24452_24570 = state_24426__$1;
(statearr_24452_24570[(2)] = inst_24414);

(statearr_24452_24570[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (54))){
var inst_24356 = cljs.core.PersistentVector.EMPTY;
var state_24426__$1 = state_24426;
var statearr_24453_24571 = state_24426__$1;
(statearr_24453_24571[(2)] = inst_24356);

(statearr_24453_24571[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (15))){
var inst_24174 = (state_24426[(16)]);
var inst_24199 = cljs.core.seq(inst_24174);
var inst_24200 = cljs.core.first(inst_24199);
var inst_24201 = cljs.core.next(inst_24199);
var inst_24202 = cljs.core.PersistentHashSet.EMPTY;
var inst_24203 = inst_24174;
var inst_24204 = inst_24202;
var state_24426__$1 = (function (){var statearr_24454 = state_24426;
(statearr_24454[(17)] = inst_24203);

(statearr_24454[(18)] = inst_24200);

(statearr_24454[(19)] = inst_24201);

(statearr_24454[(10)] = inst_24204);

return statearr_24454;
})();
var statearr_24455_24572 = state_24426__$1;
(statearr_24455_24572[(2)] = null);

(statearr_24455_24572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (48))){
var inst_24321 = (state_24426[(2)]);
var inst_24322 = fluree.db.util.async.throw_err(inst_24321);
var state_24426__$1 = state_24426;
var statearr_24456_24573 = state_24426__$1;
(statearr_24456_24573[(2)] = inst_24322);

(statearr_24456_24573[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (50))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24340 = (inst_24248.cljs$core$IFn$_invoke$arity$2 ? inst_24248.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24230) : inst_24248.call(null,cljs.core._LT__EQ_,inst_24230));
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24340)){
var statearr_24457_24574 = state_24426__$1;
(statearr_24457_24574[(1)] = (53));

} else {
var statearr_24458_24575 = state_24426__$1;
(statearr_24458_24575[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (75))){
var state_24426__$1 = state_24426;
if(cljs.core.truth_(offset)){
var statearr_24459_24576 = state_24426__$1;
(statearr_24459_24576[(1)] = (78));

} else {
var statearr_24460_24577 = state_24426__$1;
(statearr_24460_24577[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (21))){
var inst_24210 = (state_24426[(20)]);
var inst_24229 = (state_24426[(21)]);
var inst_24229__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24210,(0),null);
var inst_24230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24210,(1),null);
var inst_24231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24210,(2),null);
var inst_24232 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24229__$1);
var inst_24233 = cljs.core.not(inst_24232);
var state_24426__$1 = (function (){var statearr_24461 = state_24426;
(statearr_24461[(15)] = inst_24230);

(statearr_24461[(21)] = inst_24229__$1);

(statearr_24461[(22)] = inst_24231);

return statearr_24461;
})();
if(inst_24233){
var statearr_24462_24578 = state_24426__$1;
(statearr_24462_24578[(1)] = (29));

} else {
var statearr_24463_24579 = state_24426__$1;
(statearr_24463_24579[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (31))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24244 = (state_24426[(2)]);
var inst_24248__$1 = cljs.core.identical_QMARK_;
var inst_24249 = (inst_24248__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24248__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24230) : inst_24248__$1.call(null,cljs.core.not_EQ_,inst_24230));
var state_24426__$1 = (function (){var statearr_24464 = state_24426;
(statearr_24464[(14)] = inst_24248__$1);

(statearr_24464[(23)] = inst_24244);

return statearr_24464;
})();
if(cljs.core.truth_(inst_24249)){
var statearr_24465_24580 = state_24426__$1;
(statearr_24465_24580[(1)] = (32));

} else {
var statearr_24466_24581 = state_24426__$1;
(statearr_24466_24581[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (32))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24252 = [inst_24229,inst_24231];
var inst_24253 = (new cljs.core.PersistentVector(null,2,(5),inst_24251,inst_24252,null));
var inst_24254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24255 = [inst_24229];
var inst_24256 = (new cljs.core.PersistentVector(null,1,(5),inst_24254,inst_24255,null));
var inst_24257 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24258 = [inst_24189];
var inst_24259 = cljs.core.PersistentHashMap.fromArrays(inst_24257,inst_24258);
var inst_24260 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24253,cljs.core._LT__EQ_,inst_24256,inst_24259);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(35),inst_24260);
} else {
if((state_val_24427 === (40))){
var inst_24289 = (state_24426[(2)]);
var inst_24290 = fluree.db.util.async.throw_err(inst_24289);
var state_24426__$1 = state_24426;
var statearr_24467_24582 = state_24426__$1;
(statearr_24467_24582[(2)] = inst_24290);

(statearr_24467_24582[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (56))){
var inst_24353 = (state_24426[(2)]);
var inst_24354 = fluree.db.util.async.throw_err(inst_24353);
var state_24426__$1 = state_24426;
var statearr_24468_24583 = state_24426__$1;
(statearr_24468_24583[(2)] = inst_24354);

(statearr_24468_24583[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (33))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24279 = (inst_24248.cljs$core$IFn$_invoke$arity$2 ? inst_24248.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24230) : inst_24248.call(null,cljs.core._EQ_,inst_24230));
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24279)){
var statearr_24469_24584 = state_24426__$1;
(statearr_24469_24584[(1)] = (37));

} else {
var statearr_24470_24585 = state_24426__$1;
(statearr_24470_24585[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (13))){
var state_24426__$1 = state_24426;
var statearr_24471_24586 = state_24426__$1;
(statearr_24471_24586[(2)] = limit);

(statearr_24471_24586[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (22))){
var inst_24416 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24472_24587 = state_24426__$1;
(statearr_24472_24587[(2)] = inst_24416);

(statearr_24472_24587[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (36))){
var inst_24263 = (state_24426[(24)]);
var inst_24275 = (state_24426[(2)]);
var inst_24276 = fluree.db.util.async.throw_err(inst_24275);
var inst_24277 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24263,inst_24276);
var state_24426__$1 = state_24426;
var statearr_24473_24588 = state_24426__$1;
(statearr_24473_24588[(2)] = inst_24277);

(statearr_24473_24588[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (41))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24295 = [inst_24229,inst_24231];
var inst_24296 = (new cljs.core.PersistentVector(null,2,(5),inst_24294,inst_24295,null));
var inst_24297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24298 = [inst_24229];
var inst_24299 = (new cljs.core.PersistentVector(null,1,(5),inst_24297,inst_24298,null));
var inst_24300 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24301 = [inst_24189];
var inst_24302 = cljs.core.PersistentHashMap.fromArrays(inst_24300,inst_24301);
var inst_24303 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24296,cljs.core._LT__EQ_,inst_24299,inst_24302);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(44),inst_24303);
} else {
if((state_val_24427 === (43))){
var inst_24364 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24474_24589 = state_24426__$1;
(statearr_24474_24589[(2)] = inst_24364);

(statearr_24474_24589[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (61))){
var inst_24369 = (state_24426[(12)]);
var inst_24204 = (state_24426[(10)]);
var inst_24376 = cljs.core.PersistentHashSet.EMPTY;
var inst_24377 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24376,inst_24369);
var inst_24378 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24204,inst_24377);
var state_24426__$1 = state_24426;
var statearr_24475_24590 = state_24426__$1;
(statearr_24475_24590[(2)] = inst_24378);

(statearr_24475_24590[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (29))){
var inst_24229 = (state_24426[(21)]);
var inst_24235 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24229);
var inst_24236 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24235)].join('');
var inst_24237 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24238 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24239 = cljs.core.PersistentHashMap.fromArrays(inst_24237,inst_24238);
var inst_24240 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24236,inst_24239);
var inst_24241 = (function(){throw inst_24240})();
var state_24426__$1 = state_24426;
var statearr_24476_24591 = state_24426__$1;
(statearr_24476_24591[(2)] = inst_24241);

(statearr_24476_24591[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (44))){
var inst_24305 = (state_24426[(2)]);
var inst_24306 = fluree.db.util.async.throw_err(inst_24305);
var state_24426__$1 = state_24426;
var statearr_24477_24592 = state_24426__$1;
(statearr_24477_24592[(2)] = inst_24306);

(statearr_24477_24592[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (6))){
var inst_24173 = (state_24426[(25)]);
var inst_24177 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24173);
var state_24426__$1 = state_24426;
var statearr_24478_24593 = state_24426__$1;
(statearr_24478_24593[(2)] = inst_24177);

(statearr_24478_24593[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (28))){
var inst_24224 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24479_24594 = state_24426__$1;
(statearr_24479_24594[(2)] = inst_24224);

(statearr_24479_24594[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (64))){
var inst_24384 = (state_24426[(26)]);
var state_24426__$1 = state_24426;
var statearr_24480_24595 = state_24426__$1;
(statearr_24480_24595[(2)] = inst_24384);

(statearr_24480_24595[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (51))){
var inst_24360 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24481_24596 = state_24426__$1;
(statearr_24481_24596[(2)] = inst_24360);

(statearr_24481_24596[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (25))){
var inst_24219 = (state_24426[(2)]);
var state_24426__$1 = (function (){var statearr_24482 = state_24426;
(statearr_24482[(13)] = inst_24219);

return statearr_24482;
})();
if(cljs.core.truth_(limit)){
var statearr_24483_24597 = state_24426__$1;
(statearr_24483_24597[(1)] = (26));

} else {
var statearr_24484_24598 = state_24426__$1;
(statearr_24484_24598[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (34))){
var inst_24173 = (state_24426[(25)]);
var inst_24368 = (state_24426[(2)]);
var inst_24369 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24368);
var state_24426__$1 = (function (){var statearr_24485 = state_24426;
(statearr_24485[(12)] = inst_24369);

return statearr_24485;
})();
var G__24486_24599 = inst_24173;
var G__24486_24600__$1 = (((G__24486_24599 instanceof cljs.core.Keyword))?G__24486_24599.fqn:null);
switch (G__24486_24600__$1) {
case "or":
var statearr_24487_24602 = state_24426__$1;
(statearr_24487_24602[(1)] = (58));


break;
case "and":
var statearr_24488_24603 = state_24426__$1;
(statearr_24488_24603[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24486_24600__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (17))){
var inst_24421 = (state_24426[(2)]);
var _ = (function (){var statearr_24489 = state_24426;
(statearr_24489[(4)] = cljs.core.rest((state_24426[(4)])));

return statearr_24489;
})();
var state_24426__$1 = state_24426;
var statearr_24490_24604 = state_24426__$1;
(statearr_24490_24604[(2)] = inst_24421);

(statearr_24490_24604[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (3))){
var inst_24424 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24426__$1,inst_24424);
} else {
if((state_val_24427 === (12))){
var inst_24183 = (offset + limit);
var state_24426__$1 = state_24426;
var statearr_24491_24605 = state_24426__$1;
(statearr_24491_24605[(2)] = inst_24183);

(statearr_24491_24605[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (2))){
var inst_24175 = (state_24426[(9)]);
var _ = (function (){var statearr_24492 = state_24426;
(statearr_24492[(4)] = cljs.core.cons((5),(state_24426[(4)])));

return statearr_24492;
})();
var inst_24172 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_24173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24172,(0),null);
var inst_24174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24172,(1),null);
var inst_24175__$1 = limit;
var state_24426__$1 = (function (){var statearr_24493 = state_24426;
(statearr_24493[(16)] = inst_24174);

(statearr_24493[(9)] = inst_24175__$1);

(statearr_24493[(25)] = inst_24173);

return statearr_24493;
})();
if(cljs.core.truth_(inst_24175__$1)){
var statearr_24494_24606 = state_24426__$1;
(statearr_24494_24606[(1)] = (6));

} else {
var statearr_24495_24607 = state_24426__$1;
(statearr_24495_24607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (66))){
var inst_24389 = (state_24426[(7)]);
var state_24426__$1 = state_24426;
var statearr_24496_24608 = state_24426__$1;
(statearr_24496_24608[(2)] = inst_24389);

(statearr_24496_24608[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (23))){
var inst_24204 = (state_24426[(10)]);
var inst_24216 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24204);
var state_24426__$1 = state_24426;
var statearr_24497_24609 = state_24426__$1;
(statearr_24497_24609[(2)] = inst_24216);

(statearr_24497_24609[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (47))){
var inst_24362 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24498_24610 = state_24426__$1;
(statearr_24498_24610[(2)] = inst_24362);

(statearr_24498_24610[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (35))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24262 = (state_24426[(2)]);
var inst_24263 = fluree.db.util.async.throw_err(inst_24262);
var inst_24264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24265 = [inst_24229];
var inst_24266 = (new cljs.core.PersistentVector(null,1,(5),inst_24264,inst_24265,null));
var inst_24267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24268 = [inst_24229,inst_24231];
var inst_24269 = (new cljs.core.PersistentVector(null,2,(5),inst_24267,inst_24268,null));
var inst_24270 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24271 = [inst_24189];
var inst_24272 = cljs.core.PersistentHashMap.fromArrays(inst_24270,inst_24271);
var inst_24273 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24266,cljs.core._LT_,inst_24269,inst_24272);
var state_24426__$1 = (function (){var statearr_24499 = state_24426;
(statearr_24499[(24)] = inst_24263);

return statearr_24499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(36),inst_24273);
} else {
if((state_val_24427 === (76))){
var inst_24211 = (state_24426[(27)]);
var inst_24383 = (state_24426[(28)]);
var inst_24203 = inst_24211;
var inst_24204 = inst_24383;
var state_24426__$1 = (function (){var statearr_24500 = state_24426;
(statearr_24500[(17)] = inst_24203);

(statearr_24500[(10)] = inst_24204);

return statearr_24500;
})();
var statearr_24501_24611 = state_24426__$1;
(statearr_24501_24611[(2)] = null);

(statearr_24501_24611[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (19))){
var inst_24418 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24502_24612 = state_24426__$1;
(statearr_24502_24612[(2)] = inst_24418);

(statearr_24502_24612[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (57))){
var inst_24384 = (state_24426[(26)]);
var inst_24173 = (state_24426[(25)]);
var inst_24383 = (state_24426[(2)]);
var inst_24384__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24173);
var state_24426__$1 = (function (){var statearr_24503 = state_24426;
(statearr_24503[(26)] = inst_24384__$1);

(statearr_24503[(28)] = inst_24383);

return statearr_24503;
})();
if(inst_24384__$1){
var statearr_24504_24613 = state_24426__$1;
(statearr_24504_24613[(1)] = (63));

} else {
var statearr_24505_24614 = state_24426__$1;
(statearr_24505_24614[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (68))){
var inst_24404 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24404)){
var statearr_24506_24615 = state_24426__$1;
(statearr_24506_24615[(1)] = (75));

} else {
var statearr_24507_24616 = state_24426__$1;
(statearr_24507_24616[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (11))){
var inst_24174 = (state_24426[(16)]);
var inst_24189 = (state_24426[(2)]);
var inst_24190 = cljs.core.not_empty(inst_24174);
var state_24426__$1 = (function (){var statearr_24509 = state_24426;
(statearr_24509[(11)] = inst_24189);

return statearr_24509;
})();
if(cljs.core.truth_(inst_24190)){
var statearr_24510_24617 = state_24426__$1;
(statearr_24510_24617[(1)] = (15));

} else {
var statearr_24511_24618 = state_24426__$1;
(statearr_24511_24618[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (9))){
var state_24426__$1 = state_24426;
if(cljs.core.truth_(offset)){
var statearr_24512_24619 = state_24426__$1;
(statearr_24512_24619[(1)] = (12));

} else {
var statearr_24513_24620 = state_24426__$1;
(statearr_24513_24620[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (5))){
var _ = (function (){var statearr_24514 = state_24426;
(statearr_24514[(4)] = cljs.core.rest((state_24426[(4)])));

return statearr_24514;
})();
var state_24426__$1 = state_24426;
var ex24508 = (state_24426__$1[(2)]);
var statearr_24515_24621 = state_24426__$1;
(statearr_24515_24621[(5)] = ex24508);


if((ex24508 instanceof Error)){
var statearr_24516_24622 = state_24426__$1;
(statearr_24516_24622[(1)] = (4));

(statearr_24516_24622[(5)] = null);

} else {
throw ex24508;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (14))){
var inst_24186 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24517_24623 = state_24426__$1;
(statearr_24517_24623[(2)] = inst_24186);

(statearr_24517_24623[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (45))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24311 = [inst_24229,inst_24231];
var inst_24312 = (new cljs.core.PersistentVector(null,2,(5),inst_24310,inst_24311,null));
var inst_24313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24314 = [inst_24229];
var inst_24315 = (new cljs.core.PersistentVector(null,1,(5),inst_24313,inst_24314,null));
var inst_24316 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24317 = [inst_24189];
var inst_24318 = cljs.core.PersistentHashMap.fromArrays(inst_24316,inst_24317);
var inst_24319 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24312,cljs.core._LT__EQ_,inst_24315,inst_24318);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(48),inst_24319);
} else {
if((state_val_24427 === (53))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24343 = [inst_24229];
var inst_24344 = (new cljs.core.PersistentVector(null,1,(5),inst_24342,inst_24343,null));
var inst_24345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24346 = [inst_24229,inst_24231];
var inst_24347 = (new cljs.core.PersistentVector(null,2,(5),inst_24345,inst_24346,null));
var inst_24348 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24349 = [inst_24189];
var inst_24350 = cljs.core.PersistentHashMap.fromArrays(inst_24348,inst_24349);
var inst_24351 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24344,cljs.core._LT__EQ_,inst_24347,inst_24350);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(56),inst_24351);
} else {
if((state_val_24427 === (78))){
var inst_24383 = (state_24426[(28)]);
var inst_24407 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24383);
var state_24426__$1 = state_24426;
var statearr_24518_24624 = state_24426__$1;
(statearr_24518_24624[(2)] = inst_24407);

(statearr_24518_24624[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (26))){
var inst_24219 = (state_24426[(13)]);
var inst_24221 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_24219);
var state_24426__$1 = state_24426;
var statearr_24519_24625 = state_24426__$1;
(statearr_24519_24625[(2)] = inst_24221);

(statearr_24519_24625[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (16))){
var state_24426__$1 = state_24426;
var statearr_24520_24626 = state_24426__$1;
(statearr_24520_24626[(2)] = null);

(statearr_24520_24626[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (79))){
var inst_24383 = (state_24426[(28)]);
var state_24426__$1 = state_24426;
var statearr_24521_24627 = state_24426__$1;
(statearr_24521_24627[(2)] = inst_24383);

(statearr_24521_24627[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (38))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24292 = (inst_24248.cljs$core$IFn$_invoke$arity$2 ? inst_24248.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24230) : inst_24248.call(null,cljs.core._GT_,inst_24230));
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24292)){
var statearr_24522_24628 = state_24426__$1;
(statearr_24522_24628[(1)] = (41));

} else {
var statearr_24523_24629 = state_24426__$1;
(statearr_24523_24629[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (30))){
var state_24426__$1 = state_24426;
var statearr_24524_24630 = state_24426__$1;
(statearr_24524_24630[(2)] = null);

(statearr_24524_24630[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (73))){
var inst_24189 = (state_24426[(11)]);
var state_24426__$1 = state_24426;
var statearr_24525_24631 = state_24426__$1;
(statearr_24525_24631[(2)] = inst_24189);

(statearr_24525_24631[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (10))){
var state_24426__$1 = state_24426;
var statearr_24526_24632 = state_24426__$1;
(statearr_24526_24632[(2)] = null);

(statearr_24526_24632[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (18))){
var inst_24203 = (state_24426[(17)]);
var inst_24210 = (state_24426[(20)]);
var inst_24209 = cljs.core.seq(inst_24203);
var inst_24210__$1 = cljs.core.first(inst_24209);
var inst_24211 = cljs.core.next(inst_24209);
var inst_24212 = cljs.core.not(inst_24210__$1);
var state_24426__$1 = (function (){var statearr_24527 = state_24426;
(statearr_24527[(27)] = inst_24211);

(statearr_24527[(20)] = inst_24210__$1);

return statearr_24527;
})();
if(inst_24212){
var statearr_24528_24633 = state_24426__$1;
(statearr_24528_24633[(1)] = (20));

} else {
var statearr_24529_24634 = state_24426__$1;
(statearr_24529_24634[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (52))){
var inst_24337 = (state_24426[(2)]);
var inst_24338 = fluree.db.util.async.throw_err(inst_24337);
var state_24426__$1 = state_24426;
var statearr_24530_24635 = state_24426__$1;
(statearr_24530_24635[(2)] = inst_24338);

(statearr_24530_24635[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (67))){
var inst_24392 = (state_24426[(8)]);
var inst_24173 = (state_24426[(25)]);
var inst_24392__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_24173);
var state_24426__$1 = (function (){var statearr_24531 = state_24426;
(statearr_24531[(8)] = inst_24392__$1);

return statearr_24531;
})();
if(inst_24392__$1){
var statearr_24532_24636 = state_24426__$1;
(statearr_24532_24636[(1)] = (69));

} else {
var statearr_24533_24637 = state_24426__$1;
(statearr_24533_24637[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (71))){
var inst_24402 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24534_24638 = state_24426__$1;
(statearr_24534_24638[(2)] = inst_24402);

(statearr_24534_24638[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (42))){
var inst_24248 = (state_24426[(14)]);
var inst_24230 = (state_24426[(15)]);
var inst_24308 = (inst_24248.cljs$core$IFn$_invoke$arity$2 ? inst_24248.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24230) : inst_24248.call(null,cljs.core._GT__EQ_,inst_24230));
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24308)){
var statearr_24535_24639 = state_24426__$1;
(statearr_24535_24639[(1)] = (45));

} else {
var statearr_24536_24640 = state_24426__$1;
(statearr_24536_24640[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (80))){
var inst_24410 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
var statearr_24537_24641 = state_24426__$1;
(statearr_24537_24641[(2)] = inst_24410);

(statearr_24537_24641[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (37))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24282 = [inst_24229,inst_24231];
var inst_24283 = (new cljs.core.PersistentVector(null,2,(5),inst_24281,inst_24282,null));
var inst_24284 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24285 = [inst_24189];
var inst_24286 = cljs.core.PersistentHashMap.fromArrays(inst_24284,inst_24285);
var inst_24287 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24283,inst_24286);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(40),inst_24287);
} else {
if((state_val_24427 === (63))){
var inst_24383 = (state_24426[(28)]);
var inst_24386 = cljs.core.empty_QMARK_(inst_24383);
var state_24426__$1 = state_24426;
var statearr_24538_24642 = state_24426__$1;
(statearr_24538_24642[(2)] = inst_24386);

(statearr_24538_24642[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (8))){
var inst_24180 = (state_24426[(2)]);
var state_24426__$1 = state_24426;
if(cljs.core.truth_(inst_24180)){
var statearr_24539_24643 = state_24426__$1;
(statearr_24539_24643[(1)] = (9));

} else {
var statearr_24540_24644 = state_24426__$1;
(statearr_24540_24644[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24427 === (49))){
var inst_24189 = (state_24426[(11)]);
var inst_24229 = (state_24426[(21)]);
var inst_24231 = (state_24426[(22)]);
var inst_24326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24327 = [inst_24229];
var inst_24328 = (new cljs.core.PersistentVector(null,1,(5),inst_24326,inst_24327,null));
var inst_24329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24330 = [inst_24229,inst_24231];
var inst_24331 = (new cljs.core.PersistentVector(null,2,(5),inst_24329,inst_24330,null));
var inst_24332 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24333 = [inst_24189];
var inst_24334 = cljs.core.PersistentHashMap.fromArrays(inst_24332,inst_24333);
var inst_24335 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24328,cljs.core._LT_,inst_24331,inst_24334);
var state_24426__$1 = state_24426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24426__$1,(52),inst_24335);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_24541 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24541[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_24541[(1)] = (1));

return statearr_24541;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_24426){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24426);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24542){var ex__2744__auto__ = e24542;
var statearr_24543_24645 = state_24426;
(statearr_24543_24645[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24426[(4)]))){
var statearr_24544_24646 = state_24426;
(statearr_24544_24646[(1)] = cljs.core.first((state_24426[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24647 = state_24426;
state_24426 = G__24647;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_24426){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_24426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24545 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24545[(6)] = c__2763__auto__);

return statearr_24545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_((function (p1__24648_SHARP_){
return ((typeof p1__24648_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24648_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24649_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24649_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24653 = vars;
var vec__24654 = G__24653;
var seq__24655 = cljs.core.seq(vec__24654);
var first__24656 = cljs.core.first(seq__24655);
var seq__24655__$1 = cljs.core.next(seq__24655);
var var$ = first__24656;
var r = seq__24655__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24653__$1 = G__24653;
var all_vars__$1 = all_vars;
while(true){
var vec__24661 = G__24653__$1;
var seq__24662 = cljs.core.seq(vec__24661);
var first__24663 = cljs.core.first(seq__24662);
var seq__24662__$1 = cljs.core.next(seq__24662);
var var$__$1 = first__24663;
var r__$1 = seq__24662__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24664 = cljs.core.set(all_vars__$2);
return (fexpr__24664.cljs$core$IFn$_invoke$arity$1 ? fexpr__24664.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24664.call(null,var$__$1));
})())){
var G__24665 = r__$1;
var G__24666 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24653__$1 = G__24665;
all_vars__$1 = G__24666;
continue;
} else {
var G__24667 = r__$1;
var G__24668 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24653__$1 = G__24667;
all_vars__$1 = G__24668;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24703){
var state_val_24704 = (state_24703[(1)]);
if((state_val_24704 === (1))){
var inst_24676 = functionArray;
var inst_24677 = cljs.core.seq(inst_24676);
var inst_24678 = cljs.core.first(inst_24677);
var inst_24679 = cljs.core.next(inst_24677);
var inst_24680 = cljs.core.PersistentVector.EMPTY;
var inst_24681 = inst_24676;
var inst_24682 = inst_24680;
var state_24703__$1 = (function (){var statearr_24705 = state_24703;
(statearr_24705[(7)] = inst_24678);

(statearr_24705[(8)] = inst_24681);

(statearr_24705[(9)] = inst_24682);

(statearr_24705[(10)] = inst_24679);

return statearr_24705;
})();
var statearr_24706_24719 = state_24703__$1;
(statearr_24706_24719[(2)] = null);

(statearr_24706_24719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (2))){
var inst_24681 = (state_24703[(8)]);
var inst_24688 = (state_24703[(11)]);
var inst_24687 = cljs.core.seq(inst_24681);
var inst_24688__$1 = cljs.core.first(inst_24687);
var inst_24689 = cljs.core.next(inst_24687);
var state_24703__$1 = (function (){var statearr_24707 = state_24703;
(statearr_24707[(12)] = inst_24689);

(statearr_24707[(11)] = inst_24688__$1);

return statearr_24707;
})();
if(cljs.core.truth_(inst_24688__$1)){
var statearr_24708_24720 = state_24703__$1;
(statearr_24708_24720[(1)] = (4));

} else {
var statearr_24709_24721 = state_24703__$1;
(statearr_24709_24721[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (3))){
var inst_24701 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24703__$1,inst_24701);
} else {
if((state_val_24704 === (4))){
var inst_24688 = (state_24703[(11)]);
var inst_24691 = (inst_24688.cljs$core$IFn$_invoke$arity$1 ? inst_24688.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24688.call(null,tuple));
var state_24703__$1 = state_24703;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24703__$1,(7),inst_24691);
} else {
if((state_val_24704 === (5))){
var inst_24682 = (state_24703[(9)]);
var state_24703__$1 = state_24703;
var statearr_24710_24722 = state_24703__$1;
(statearr_24710_24722[(2)] = inst_24682);

(statearr_24710_24722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (6))){
var inst_24699 = (state_24703[(2)]);
var state_24703__$1 = state_24703;
var statearr_24711_24723 = state_24703__$1;
(statearr_24711_24723[(2)] = inst_24699);

(statearr_24711_24723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24704 === (7))){
var inst_24689 = (state_24703[(12)]);
var inst_24682 = (state_24703[(9)]);
var inst_24693 = (state_24703[(2)]);
var inst_24694 = fluree.db.util.async.throw_err(inst_24693);
var inst_24695 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24682,inst_24694);
var inst_24681 = inst_24689;
var inst_24682__$1 = inst_24695;
var state_24703__$1 = (function (){var statearr_24712 = state_24703;
(statearr_24712[(8)] = inst_24681);

(statearr_24712[(9)] = inst_24682__$1);

return statearr_24712;
})();
var statearr_24713_24724 = state_24703__$1;
(statearr_24713_24724[(2)] = null);

(statearr_24713_24724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0 = (function (){
var statearr_24714 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24714[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__);

(statearr_24714[(1)] = (1));

return statearr_24714;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1 = (function (state_24703){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24703);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24715){var ex__2744__auto__ = e24715;
var statearr_24716_24725 = state_24703;
(statearr_24716_24725[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24703[(4)]))){
var statearr_24717_24726 = state_24703;
(statearr_24717_24726[(1)] = cljs.core.first((state_24703[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24727 = state_24703;
state_24703 = G__24727;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__ = function(state_24703){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1.call(this,state_24703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24718 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24718[(6)] = c__2763__auto__);

return statearr_24718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24728){
var vec__24729 = p__24728;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24729,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24729,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24743){
var state_val_24744 = (state_24743[(1)]);
if((state_val_24744 === (1))){
var inst_24732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24733 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24734 = [query_map,_id,query_opts];
var inst_24735 = cljs.core.PersistentHashMap.fromArrays(inst_24733,inst_24734);
var inst_24736 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24735) : fluree.db.query.fql.query.call(null,db,inst_24735));
var state_24743__$1 = (function (){var statearr_24745 = state_24743;
(statearr_24745[(7)] = inst_24732);

return statearr_24745;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24743__$1,(2),inst_24736);
} else {
if((state_val_24744 === (2))){
var inst_24732 = (state_24743[(7)]);
var inst_24738 = (state_24743[(2)]);
var inst_24739 = fluree.db.util.async.throw_err(inst_24738);
var inst_24740 = [tuple_index,inst_24739];
var inst_24741 = (new cljs.core.PersistentVector(null,2,(5),inst_24732,inst_24740,null));
var state_24743__$1 = state_24743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24743__$1,inst_24741);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0 = (function (){
var statearr_24746 = [null,null,null,null,null,null,null,null];
(statearr_24746[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2741__auto__);

(statearr_24746[(1)] = (1));

return statearr_24746;
});
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1 = (function (state_24743){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24743);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24747){var ex__2744__auto__ = e24747;
var statearr_24748_24751 = state_24743;
(statearr_24748_24751[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24743[(4)]))){
var statearr_24749_24752 = state_24743;
(statearr_24749_24752[(1)] = cljs.core.first((state_24743[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24753 = state_24743;
state_24743 = G__24753;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__ = function(state_24743){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1.call(this,state_24743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24750 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24750[(6)] = c__2763__auto__);

return statearr_24750;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24754 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24754,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24754,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24817){
var state_val_24818 = (state_24817[(1)]);
if((state_val_24818 === (7))){
var inst_24812 = (state_24817[(2)]);
var _ = (function (){var statearr_24819 = state_24817;
(statearr_24819[(4)] = cljs.core.rest((state_24817[(4)])));

return statearr_24819;
})();
var state_24817__$1 = state_24817;
var statearr_24820_24911 = state_24817__$1;
(statearr_24820_24911[(2)] = inst_24812);

(statearr_24820_24911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (20))){
var inst_24803 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
var statearr_24821_24912 = state_24817__$1;
(statearr_24821_24912[(2)] = inst_24803);

(statearr_24821_24912[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (1))){
var state_24817__$1 = state_24817;
var statearr_24822_24913 = state_24817__$1;
(statearr_24822_24913[(2)] = null);

(statearr_24822_24913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (4))){
var inst_24759 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
var statearr_24823_24914 = state_24817__$1;
(statearr_24823_24914[(2)] = inst_24759);

(statearr_24823_24914[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (15))){
var inst_24779 = (state_24817[(7)]);
var inst_24788 = cljs.core.second(inst_24779);
var inst_24789 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24788);
var inst_24790 = (inst_24789 > max_fuel);
var state_24817__$1 = state_24817;
if(cljs.core.truth_(inst_24790)){
var statearr_24824_24915 = state_24817__$1;
(statearr_24824_24915[(1)] = (18));

} else {
var statearr_24825_24916 = state_24817__$1;
(statearr_24825_24916[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (13))){
var state_24817__$1 = state_24817;
var statearr_24826_24917 = state_24817__$1;
(statearr_24826_24917[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (6))){
var inst_24767 = (state_24817[(8)]);
var state_24817__$1 = state_24817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24817__$1,(8),inst_24767);
} else {
if((state_val_24818 === (17))){
var inst_24806 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
var statearr_24828_24918 = state_24817__$1;
(statearr_24828_24918[(2)] = inst_24806);

(statearr_24828_24918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (3))){
var inst_24815 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24817__$1,inst_24815);
} else {
if((state_val_24818 === (12))){
var inst_24768 = (state_24817[(9)]);
var inst_24779 = (state_24817[(7)]);
var inst_24785 = (inst_24768.cljs$core$IFn$_invoke$arity$0 ? inst_24768.cljs$core$IFn$_invoke$arity$0() : inst_24768.call(null));
var state_24817__$1 = (function (){var statearr_24829 = state_24817;
(statearr_24829[(10)] = inst_24785);

return statearr_24829;
})();
var statearr_24830_24919 = state_24817__$1;
(statearr_24830_24919[(2)] = inst_24779);

(statearr_24830_24919[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (2))){
var inst_24768 = (state_24817[(9)]);
var inst_24767 = (state_24817[(8)]);
var _ = (function (){var statearr_24831 = state_24817;
(statearr_24831[(4)] = cljs.core.cons((5),(state_24817[(4)])));

return statearr_24831;
})();
var inst_24765 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24766 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24767__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24768__$1 = (function (){var expandMaps = inst_24765;
var queue_ch = inst_24766;
var res_ch = inst_24767__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24769 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24770 = cljs.core.volatile_BANG_((0));
var inst_24771 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24769,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24770);
var inst_24772 = (function (){var expandMaps = inst_24765;
var queue_ch = inst_24766;
var res_ch = inst_24767__$1;
var stop_BANG_ = inst_24768__$1;
var opts_STAR_ = inst_24771;
return (function (tuple_res,port){
var c__2763__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24864){
var state_val_24865 = (state_24864[(1)]);
if((state_val_24865 === (7))){
var state_24864__$1 = state_24864;
var statearr_24866_24920 = state_24864__$1;
(statearr_24866_24920[(2)] = tuple_res);

(statearr_24866_24920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (1))){
var state_24864__$1 = state_24864;
var statearr_24867_24921 = state_24864__$1;
(statearr_24867_24921[(2)] = null);

(statearr_24867_24921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (4))){
var inst_24832 = (state_24864[(2)]);
var inst_24833 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24832);
var inst_24834 = cljs.core.async.close_BANG_(port);
var state_24864__$1 = (function (){var statearr_24868 = state_24864;
(statearr_24868[(7)] = inst_24833);

return statearr_24868;
})();
var statearr_24869_24922 = state_24864__$1;
(statearr_24869_24922[(2)] = inst_24834);

(statearr_24869_24922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (6))){
var inst_24841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24842 = [tuple_res];
var inst_24843 = (new cljs.core.PersistentVector(null,1,(5),inst_24841,inst_24842,null));
var state_24864__$1 = state_24864;
var statearr_24870_24923 = state_24864__$1;
(statearr_24870_24923[(2)] = inst_24843);

(statearr_24870_24923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (3))){
var inst_24862 = (state_24864[(2)]);
var state_24864__$1 = state_24864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24864__$1,inst_24862);
} else {
if((state_val_24865 === (2))){
var ___$1 = (function (){var statearr_24872 = state_24864;
(statearr_24872[(4)] = cljs.core.cons((5),(state_24864[(4)])));

return statearr_24872;
})();
var state_24864__$1 = state_24864;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24873_24924 = state_24864__$1;
(statearr_24873_24924[(1)] = (6));

} else {
var statearr_24874_24925 = state_24864__$1;
(statearr_24874_24925[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (9))){
var inst_24846 = (state_24864[(8)]);
var inst_24848 = (state_24864[(9)]);
var inst_24855 = (state_24864[(2)]);
var inst_24856 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24846,inst_24855);
var inst_24857 = (inst_24848.cljs$core$IFn$_invoke$arity$1 ? inst_24848.cljs$core$IFn$_invoke$arity$1(inst_24856) : inst_24848.call(null,inst_24856));
var inst_24858 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24857);
var inst_24859 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24875 = state_24864;
(statearr_24875[(4)] = cljs.core.rest((state_24864[(4)])));

return statearr_24875;
})();
var state_24864__$1 = (function (){var statearr_24876 = state_24864;
(statearr_24876[(10)] = inst_24858);

return statearr_24876;
})();
var statearr_24877_24926 = state_24864__$1;
(statearr_24877_24926[(2)] = inst_24859);

(statearr_24877_24926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (5))){
var ___$1 = (function (){var statearr_24878 = state_24864;
(statearr_24878[(4)] = cljs.core.rest((state_24864[(4)])));

return statearr_24878;
})();
var state_24864__$1 = state_24864;
var ex24871 = (state_24864__$1[(2)]);
var statearr_24879_24927 = state_24864__$1;
(statearr_24879_24927[(5)] = ex24871);


var statearr_24880_24928 = state_24864__$1;
(statearr_24880_24928[(1)] = (4));

(statearr_24880_24928[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24865 === (8))){
var inst_24846 = (state_24864[(8)]);
var inst_24846__$1 = (state_24864[(2)]);
var inst_24847 = cljs.core.volatile_BANG_((0));
var inst_24848 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24846__$1;
var query_fuel = inst_24847;
return (function (p1__24758_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24758_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24758_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24849 = cljs.core.PersistentVector.EMPTY;
var inst_24850 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24846__$1;
var query_fuel = inst_24847;
return (function (p1__24757_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24757_SHARP_);
});
})();
var inst_24851 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24850,expandMaps);
var inst_24852 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24851);
var inst_24853 = cljs.core.async.into(inst_24849,inst_24852);
var state_24864__$1 = (function (){var statearr_24881 = state_24864;
(statearr_24881[(8)] = inst_24846__$1);

(statearr_24881[(9)] = inst_24848);

return statearr_24881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24864__$1,(9),inst_24853);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0 = (function (){
var statearr_24882 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24882[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__);

(statearr_24882[(1)] = (1));

return statearr_24882;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1 = (function (state_24864){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24864);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24883){var ex__2744__auto__ = e24883;
var statearr_24884_24929 = state_24864;
(statearr_24884_24929[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24864[(4)]))){
var statearr_24885_24930 = state_24864;
(statearr_24885_24930[(1)] = cljs.core.first((state_24864[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24931 = state_24864;
state_24864 = G__24931;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = function(state_24864){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1.call(this,state_24864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24886 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24886[(6)] = c__2763__auto____$1);

return statearr_24886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto____$1;
});
})();
var inst_24773 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24766,tuples_res);
var inst_24774 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24767__$1,inst_24772,inst_24766);
var inst_24775 = cljs.core.PersistentVector.EMPTY;
var inst_24776 = inst_24775;
var state_24817__$1 = (function (){var statearr_24887 = state_24817;
(statearr_24887[(9)] = inst_24768__$1);

(statearr_24887[(11)] = inst_24774);

(statearr_24887[(12)] = inst_24776);

(statearr_24887[(13)] = inst_24773);

(statearr_24887[(8)] = inst_24767__$1);

return statearr_24887;
})();
var statearr_24888_24932 = state_24817__$1;
(statearr_24888_24932[(2)] = null);

(statearr_24888_24932[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (19))){
var inst_24779 = (state_24817[(7)]);
var inst_24776 = (state_24817[(12)]);
var inst_24799 = cljs.core.first(inst_24779);
var inst_24800 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24776,inst_24799);
var inst_24776__$1 = inst_24800;
var state_24817__$1 = (function (){var statearr_24889 = state_24817;
(statearr_24889[(12)] = inst_24776__$1);

return statearr_24889;
})();
var statearr_24890_24933 = state_24817__$1;
(statearr_24890_24933[(2)] = null);

(statearr_24890_24933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (11))){
var inst_24810 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
var statearr_24892_24934 = state_24817__$1;
(statearr_24892_24934[(2)] = inst_24810);

(statearr_24892_24934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (9))){
var inst_24776 = (state_24817[(12)]);
var state_24817__$1 = state_24817;
var statearr_24893_24935 = state_24817__$1;
(statearr_24893_24935[(2)] = inst_24776);

(statearr_24893_24935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (5))){
var _ = (function (){var statearr_24894 = state_24817;
(statearr_24894[(4)] = cljs.core.rest((state_24817[(4)])));

return statearr_24894;
})();
var state_24817__$1 = state_24817;
var ex24891 = (state_24817__$1[(2)]);
var statearr_24895_24936 = state_24817__$1;
(statearr_24895_24936[(5)] = ex24891);


if((ex24891 instanceof Error)){
var statearr_24896_24937 = state_24817__$1;
(statearr_24896_24937[(1)] = (4));

(statearr_24896_24937[(5)] = null);

} else {
throw ex24891;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (14))){
var inst_24808 = (state_24817[(2)]);
var state_24817__$1 = state_24817;
var statearr_24897_24938 = state_24817__$1;
(statearr_24897_24938[(2)] = inst_24808);

(statearr_24897_24938[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (16))){
var state_24817__$1 = state_24817;
var statearr_24898_24939 = state_24817__$1;
(statearr_24898_24939[(2)] = null);

(statearr_24898_24939[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (10))){
var inst_24779 = (state_24817[(7)]);
var inst_24783 = fluree.db.util.core.exception_QMARK_(inst_24779);
var state_24817__$1 = state_24817;
if(inst_24783){
var statearr_24899_24940 = state_24817__$1;
(statearr_24899_24940[(1)] = (12));

} else {
var statearr_24900_24941 = state_24817__$1;
(statearr_24900_24941[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (18))){
var inst_24768 = (state_24817[(9)]);
var inst_24792 = (inst_24768.cljs$core$IFn$_invoke$arity$0 ? inst_24768.cljs$core$IFn$_invoke$arity$0() : inst_24768.call(null));
var inst_24793 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24794 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24795 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24796 = cljs.core.PersistentHashMap.fromArrays(inst_24794,inst_24795);
var inst_24797 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24793,inst_24796);
var state_24817__$1 = (function (){var statearr_24901 = state_24817;
(statearr_24901[(14)] = inst_24792);

return statearr_24901;
})();
var statearr_24902_24942 = state_24817__$1;
(statearr_24902_24942[(2)] = inst_24797);

(statearr_24902_24942[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24818 === (8))){
var inst_24779 = (state_24817[(7)]);
var inst_24779__$1 = (state_24817[(2)]);
var inst_24780 = (inst_24779__$1 == null);
var state_24817__$1 = (function (){var statearr_24903 = state_24817;
(statearr_24903[(7)] = inst_24779__$1);

return statearr_24903;
})();
if(cljs.core.truth_(inst_24780)){
var statearr_24904_24943 = state_24817__$1;
(statearr_24904_24943[(1)] = (9));

} else {
var statearr_24905_24944 = state_24817__$1;
(statearr_24905_24944[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0 = (function (){
var statearr_24906 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24906[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__);

(statearr_24906[(1)] = (1));

return statearr_24906;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1 = (function (state_24817){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_24817);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24907){var ex__2744__auto__ = e24907;
var statearr_24908_24945 = state_24817;
(statearr_24908_24945[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_24817[(4)]))){
var statearr_24909_24946 = state_24817;
(statearr_24909_24946[(1)] = cljs.core.first((state_24817[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24947 = state_24817;
state_24817 = G__24947;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = function(state_24817){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1.call(this,state_24817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24910 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_24910[(6)] = c__2763__auto__);

return statearr_24910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24948 = select;
var map__24948__$1 = cljs.core.__destructure_map(map__24948);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24948__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24948__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24948__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24951 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24951,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24951,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24951,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24949_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24949_SHARP_,compare_idx));
}):(function (p1__24950_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24950_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24956 = arguments.length;
switch (G__24956) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24957,p__24958,group_limit,opts){
var map__24959 = p__24957;
var map__24959__$1 = cljs.core.__destructure_map(map__24959);
var res = map__24959__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24959__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24960 = p__24958;
var map__24960__$1 = cljs.core.__destructure_map(map__24960);
var select_spec = map__24960__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24960__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_25097){
var state_val_25098 = (state_25097[(1)]);
if((state_val_25098 === (7))){
var inst_24967 = (state_25097[(7)]);
var state_25097__$1 = state_25097;
var statearr_25099_25201 = state_25097__$1;
(statearr_25099_25201[(2)] = inst_24967);

(statearr_25099_25201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (59))){
var inst_25090 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
var statearr_25100_25202 = state_25097__$1;
(statearr_25100_25202[(2)] = inst_25090);

(statearr_25100_25202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (20))){
var inst_25006 = (state_25097[(8)]);
var inst_25003 = (state_25097[(9)]);
var inst_25002 = (state_25097[(2)]);
var inst_25003__$1 = cljs.core.__destructure_map(inst_25002);
var inst_25004 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25003__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25003__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25006__$1 = offset;
var state_25097__$1 = (function (){var statearr_25101 = state_25097;
(statearr_25101[(8)] = inst_25006__$1);

(statearr_25101[(10)] = inst_25004);

(statearr_25101[(9)] = inst_25003__$1);

(statearr_25101[(11)] = inst_25005);

return statearr_25101;
})();
if(cljs.core.truth_(inst_25006__$1)){
var statearr_25102_25203 = state_25097__$1;
(statearr_25102_25203[(1)] = (21));

} else {
var statearr_25103_25204 = state_25097__$1;
(statearr_25103_25204[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (58))){
var inst_25082 = (state_25097[(12)]);
var state_25097__$1 = state_25097;
var statearr_25104_25205 = state_25097__$1;
(statearr_25104_25205[(2)] = inst_25082);

(statearr_25104_25205[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (60))){
var inst_25086 = (state_25097[(2)]);
var inst_25087 = fluree.db.util.async.throw_err(inst_25086);
var state_25097__$1 = state_25097;
var statearr_25105_25206 = state_25097__$1;
(statearr_25105_25206[(2)] = inst_25087);

(statearr_25105_25206[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (27))){
var inst_25018 = cljs.core.not(inVector_QMARK_);
var state_25097__$1 = state_25097;
var statearr_25106_25207 = state_25097__$1;
(statearr_25106_25207[(2)] = inst_25018);

(statearr_25106_25207[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (1))){
var state_25097__$1 = state_25097;
var statearr_25107_25208 = state_25097__$1;
(statearr_25107_25208[(2)] = null);

(statearr_25107_25208[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (24))){
var state_25097__$1 = state_25097;
var statearr_25108_25209 = state_25097__$1;
(statearr_25108_25209[(2)] = offset);

(statearr_25108_25209[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (55))){
var inst_25076 = (state_25097[(13)]);
var state_25097__$1 = state_25097;
var statearr_25109_25210 = state_25097__$1;
(statearr_25109_25210[(2)] = inst_25076);

(statearr_25109_25210[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (39))){
var inst_25044 = (state_25097[(14)]);
var inst_25046 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25047 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25044,inst_25046);
var state_25097__$1 = state_25097;
var statearr_25110_25211 = state_25097__$1;
(statearr_25110_25211[(2)] = inst_25047);

(statearr_25110_25211[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (46))){
var inst_25056 = (state_25097[(15)]);
var state_25097__$1 = state_25097;
var statearr_25111_25212 = state_25097__$1;
(statearr_25111_25212[(2)] = inst_25056);

(statearr_25111_25212[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (4))){
var inst_24961 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
var statearr_25112_25213 = state_25097__$1;
(statearr_25112_25213[(2)] = inst_24961);

(statearr_25112_25213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (54))){
var inst_25076 = (state_25097[(13)]);
var inst_25070 = (state_25097[(16)]);
var inst_25078 = cljs.core.PersistentVector.EMPTY;
var inst_25079 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25078,inst_25070,inst_25076);
var state_25097__$1 = state_25097;
var statearr_25113_25214 = state_25097__$1;
(statearr_25113_25214[(2)] = inst_25079);

(statearr_25113_25214[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (15))){
var inst_24988 = (state_25097[(17)]);
var inst_24990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24991 = [inst_24988];
var inst_24992 = (new cljs.core.PersistentVector(null,1,(5),inst_24990,inst_24991,null));
var state_25097__$1 = state_25097;
var statearr_25114_25215 = state_25097__$1;
(statearr_25114_25215[(2)] = inst_24992);

(statearr_25114_25215[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (48))){
var inst_25004 = (state_25097[(10)]);
var inst_25026 = (state_25097[(18)]);
var inst_25015 = (state_25097[(19)]);
var inst_25003 = (state_25097[(9)]);
var inst_25062 = (state_25097[(20)]);
var inst_25021 = (state_25097[(21)]);
var inst_25005 = (state_25097[(11)]);
var inst_25064 = (function (){var map__24997 = inst_25003;
var headers = inst_25004;
var tuples = inst_25005;
var offset_SINGLEQUOTE_ = inst_25015;
var single_result_QMARK_ = inst_25021;
var pp_keys = inst_25026;
var G__25027 = inst_25062;
return (function (p1__24954_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24954_SHARP_);
});
})();
var inst_25065 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25064);
var inst_25066 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25062,inst_25065);
var state_25097__$1 = state_25097;
var statearr_25115_25216 = state_25097__$1;
(statearr_25115_25216[(2)] = inst_25066);

(statearr_25115_25216[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (50))){
var inst_25069 = (state_25097[(2)]);
var inst_25070 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25069);
var state_25097__$1 = (function (){var statearr_25116 = state_25097;
(statearr_25116[(16)] = inst_25070);

return statearr_25116;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25117_25217 = state_25097__$1;
(statearr_25117_25217[(1)] = (51));

} else {
var statearr_25118_25218 = state_25097__$1;
(statearr_25118_25218[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (21))){
var inst_25008 = cljs.core.not(groupBy);
var state_25097__$1 = state_25097;
var statearr_25119_25219 = state_25097__$1;
(statearr_25119_25219[(2)] = inst_25008);

(statearr_25119_25219[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (31))){
var state_25097__$1 = state_25097;
var statearr_25120_25220 = state_25097__$1;
(statearr_25120_25220[(2)] = null);

(statearr_25120_25220[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (32))){
var inst_25004 = (state_25097[(10)]);
var inst_25021 = (state_25097[(21)]);
var inst_25026 = (state_25097[(2)]);
var inst_25028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25029 = fluree.db.query.fql.select_tuples_fn(inst_25004,vars,select);
var inst_25030 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25029);
var inst_25031 = [inst_25030];
var inst_25032 = (new cljs.core.PersistentVector(null,1,(5),inst_25028,inst_25031,null));
var state_25097__$1 = (function (){var statearr_25121 = state_25097;
(statearr_25121[(18)] = inst_25026);

(statearr_25121[(22)] = inst_25032);

return statearr_25121;
})();
if(cljs.core.truth_(inst_25021)){
var statearr_25122_25221 = state_25097__$1;
(statearr_25122_25221[(1)] = (33));

} else {
var statearr_25123_25222 = state_25097__$1;
(statearr_25123_25222[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (40))){
var inst_25044 = (state_25097[(14)]);
var state_25097__$1 = state_25097;
var statearr_25124_25223 = state_25097__$1;
(statearr_25124_25223[(2)] = inst_25044);

(statearr_25124_25223[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (56))){
var inst_25082 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25125 = state_25097;
(statearr_25125[(12)] = inst_25082);

return statearr_25125;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25126_25224 = state_25097__$1;
(statearr_25126_25224[(1)] = (57));

} else {
var statearr_25127_25225 = state_25097__$1;
(statearr_25127_25225[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (33))){
var inst_25032 = (state_25097[(22)]);
var inst_25034 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25035 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25032,inst_25034);
var state_25097__$1 = state_25097;
var statearr_25128_25226 = state_25097__$1;
(statearr_25128_25226[(2)] = inst_25035);

(statearr_25128_25226[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (13))){
var inst_24977 = (state_25097[(23)]);
var state_25097__$1 = state_25097;
var statearr_25129_25227 = state_25097__$1;
(statearr_25129_25227[(2)] = inst_24977);

(statearr_25129_25227[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (22))){
var inst_25006 = (state_25097[(8)]);
var state_25097__$1 = state_25097;
var statearr_25130_25228 = state_25097__$1;
(statearr_25130_25228[(2)] = inst_25006);

(statearr_25130_25228[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (36))){
var inst_25038 = (state_25097[(24)]);
var inst_25040 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25041 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25038,inst_25040);
var state_25097__$1 = state_25097;
var statearr_25131_25229 = state_25097__$1;
(statearr_25131_25229[(2)] = inst_25041);

(statearr_25131_25229[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (41))){
var inst_25015 = (state_25097[(19)]);
var inst_25050 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25132 = state_25097;
(statearr_25132[(25)] = inst_25050);

return statearr_25132;
})();
if(cljs.core.truth_(inst_25015)){
var statearr_25133_25230 = state_25097__$1;
(statearr_25133_25230[(1)] = (42));

} else {
var statearr_25134_25231 = state_25097__$1;
(statearr_25134_25231[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (43))){
var inst_25050 = (state_25097[(25)]);
var state_25097__$1 = state_25097;
var statearr_25135_25232 = state_25097__$1;
(statearr_25135_25232[(2)] = inst_25050);

(statearr_25135_25232[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (29))){
var inst_25021 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25136 = state_25097;
(statearr_25136[(21)] = inst_25021);

return statearr_25136;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25137_25233 = state_25097__$1;
(statearr_25137_25233[(1)] = (30));

} else {
var statearr_25138_25234 = state_25097__$1;
(statearr_25138_25234[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (44))){
var inst_25056 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25139 = state_25097;
(statearr_25139[(15)] = inst_25056);

return statearr_25139;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25140_25235 = state_25097__$1;
(statearr_25140_25235[(1)] = (45));

} else {
var statearr_25141_25236 = state_25097__$1;
(statearr_25141_25236[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (6))){
var inst_24969 = cljs.core.count(select);
var inst_24970 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24969);
var state_25097__$1 = state_25097;
var statearr_25142_25237 = state_25097__$1;
(statearr_25142_25237[(2)] = inst_24970);

(statearr_25142_25237[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (28))){
var inst_25016 = (state_25097[(26)]);
var state_25097__$1 = state_25097;
var statearr_25143_25238 = state_25097__$1;
(statearr_25143_25238[(2)] = inst_25016);

(statearr_25143_25238[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (51))){
var inst_25004 = (state_25097[(10)]);
var inst_25005 = (state_25097[(11)]);
var inst_25073 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25004,orderBy,inst_25005);
var state_25097__$1 = state_25097;
var statearr_25144_25239 = state_25097__$1;
(statearr_25144_25239[(2)] = inst_25073);

(statearr_25144_25239[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (25))){
var state_25097__$1 = state_25097;
var statearr_25145_25240 = state_25097__$1;
(statearr_25145_25240[(2)] = null);

(statearr_25145_25240[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (34))){
var inst_25032 = (state_25097[(22)]);
var state_25097__$1 = state_25097;
var statearr_25146_25241 = state_25097__$1;
(statearr_25146_25241[(2)] = inst_25032);

(statearr_25146_25241[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (17))){
var inst_24995 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
var statearr_25147_25242 = state_25097__$1;
(statearr_25147_25242[(2)] = inst_24995);

(statearr_25147_25242[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (3))){
var inst_25095 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25097__$1,inst_25095);
} else {
if((state_val_25098 === (12))){
var inst_24977 = (state_25097[(23)]);
var inst_24979 = cljs.core.first(select);
var inst_24980 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24979);
var inst_24981 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24980);
var inst_24982 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24981,(1));
var inst_24983 = [inst_24982];
var inst_24984 = [inst_24977];
var inst_24985 = cljs.core.PersistentHashMap.fromArrays(inst_24983,inst_24984);
var state_25097__$1 = state_25097;
var statearr_25148_25243 = state_25097__$1;
(statearr_25148_25243[(2)] = inst_24985);

(statearr_25148_25243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (2))){
var inst_24967 = (state_25097[(7)]);
var _ = (function (){var statearr_25149 = state_25097;
(statearr_25149[(4)] = cljs.core.cons((5),(state_25097[(4)])));

return statearr_25149;
})();
var inst_24967__$1 = aggregates;
var state_25097__$1 = (function (){var statearr_25150 = state_25097;
(statearr_25150[(7)] = inst_24967__$1);

return statearr_25150;
})();
if(cljs.core.truth_(inst_24967__$1)){
var statearr_25151_25244 = state_25097__$1;
(statearr_25151_25244[(1)] = (6));

} else {
var statearr_25152_25245 = state_25097__$1;
(statearr_25152_25245[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (23))){
var inst_25011 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
if(cljs.core.truth_(inst_25011)){
var statearr_25153_25246 = state_25097__$1;
(statearr_25153_25246[(1)] = (24));

} else {
var statearr_25154_25247 = state_25097__$1;
(statearr_25154_25247[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (47))){
var inst_25062 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25155 = state_25097;
(statearr_25155[(20)] = inst_25062);

return statearr_25155;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25156_25248 = state_25097__$1;
(statearr_25156_25248[(1)] = (48));

} else {
var statearr_25157_25249 = state_25097__$1;
(statearr_25157_25249[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (35))){
var inst_25038 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25158 = state_25097;
(statearr_25158[(24)] = inst_25038);

return statearr_25158;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25159_25250 = state_25097__$1;
(statearr_25159_25250[(1)] = (36));

} else {
var statearr_25160_25251 = state_25097__$1;
(statearr_25160_25251[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (19))){
var state_25097__$1 = state_25097;
var statearr_25161_25252 = state_25097__$1;
(statearr_25161_25252[(2)] = res);

(statearr_25161_25252[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (57))){
var inst_25082 = (state_25097[(12)]);
var inst_25026 = (state_25097[(18)]);
var inst_25021 = (state_25097[(21)]);
var inst_25084 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25026,inst_25021,db,fuel,max_fuel,opts,(8),inst_25082);
var state_25097__$1 = state_25097;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25097__$1,(60),inst_25084);
} else {
if((state_val_25098 === (11))){
var inst_25092 = (state_25097[(2)]);
var _ = (function (){var statearr_25163 = state_25097;
(statearr_25163[(4)] = cljs.core.rest((state_25097[(4)])));

return statearr_25163;
})();
var state_25097__$1 = state_25097;
var statearr_25164_25253 = state_25097__$1;
(statearr_25164_25253[(2)] = inst_25092);

(statearr_25164_25253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (9))){
var inst_24975 = cljs.core.first(aggregates);
var inst_24976 = fluree.db.query.analytical.calculate_aggregate(res,inst_24975);
var inst_24977 = cljs.core.second(inst_24976);
var state_25097__$1 = (function (){var statearr_25165 = state_25097;
(statearr_25165[(23)] = inst_24977);

return statearr_25165;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25166_25254 = state_25097__$1;
(statearr_25166_25254[(1)] = (12));

} else {
var statearr_25167_25255 = state_25097__$1;
(statearr_25167_25255[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (5))){
var _ = (function (){var statearr_25168 = state_25097;
(statearr_25168[(4)] = cljs.core.rest((state_25097[(4)])));

return statearr_25168;
})();
var state_25097__$1 = state_25097;
var ex25162 = (state_25097__$1[(2)]);
var statearr_25169_25256 = state_25097__$1;
(statearr_25169_25256[(5)] = ex25162);


if((ex25162 instanceof Error)){
var statearr_25170_25257 = state_25097__$1;
(statearr_25170_25257[(1)] = (4));

(statearr_25170_25257[(5)] = null);

} else {
throw ex25162;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (14))){
var inst_24988 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25171 = state_25097;
(statearr_25171[(17)] = inst_24988);

return statearr_25171;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25172_25258 = state_25097__$1;
(statearr_25172_25258[(1)] = (15));

} else {
var statearr_25173_25259 = state_25097__$1;
(statearr_25173_25259[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (45))){
var inst_25056 = (state_25097[(15)]);
var inst_25058 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25059 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25056,inst_25058);
var state_25097__$1 = state_25097;
var statearr_25174_25260 = state_25097__$1;
(statearr_25174_25260[(2)] = inst_25059);

(statearr_25174_25260[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (53))){
var inst_25076 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25175 = state_25097;
(statearr_25175[(13)] = inst_25076);

return statearr_25175;
})();
var statearr_25176_25261 = state_25097__$1;
(statearr_25176_25261[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (26))){
var inst_25016 = (state_25097[(26)]);
var inst_25015 = (state_25097[(2)]);
var inst_25016__$1 = cljs.core.not(prettyPrint);
var state_25097__$1 = (function (){var statearr_25178 = state_25097;
(statearr_25178[(26)] = inst_25016__$1);

(statearr_25178[(19)] = inst_25015);

return statearr_25178;
})();
if(inst_25016__$1){
var statearr_25179_25262 = state_25097__$1;
(statearr_25179_25262[(1)] = (27));

} else {
var statearr_25180_25263 = state_25097__$1;
(statearr_25180_25263[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (16))){
var inst_24988 = (state_25097[(17)]);
var state_25097__$1 = state_25097;
var statearr_25181_25264 = state_25097__$1;
(statearr_25181_25264[(2)] = inst_24988);

(statearr_25181_25264[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (38))){
var inst_25044 = (state_25097[(2)]);
var state_25097__$1 = (function (){var statearr_25182 = state_25097;
(statearr_25182[(14)] = inst_25044);

return statearr_25182;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25183_25265 = state_25097__$1;
(statearr_25183_25265[(1)] = (39));

} else {
var statearr_25184_25266 = state_25097__$1;
(statearr_25184_25266[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (30))){
var inst_25023 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25097__$1 = state_25097;
var statearr_25185_25267 = state_25097__$1;
(statearr_25185_25267[(2)] = inst_25023);

(statearr_25185_25267[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (10))){
var state_25097__$1 = state_25097;
if(cljs.core.truth_(aggregates)){
var statearr_25186_25268 = state_25097__$1;
(statearr_25186_25268[(1)] = (18));

} else {
var statearr_25187_25269 = state_25097__$1;
(statearr_25187_25269[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (18))){
var inst_24999 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25097__$1 = state_25097;
var statearr_25188_25270 = state_25097__$1;
(statearr_25188_25270[(2)] = inst_24999);

(statearr_25188_25270[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (52))){
var inst_25005 = (state_25097[(11)]);
var state_25097__$1 = state_25097;
var statearr_25189_25271 = state_25097__$1;
(statearr_25189_25271[(2)] = inst_25005);

(statearr_25189_25271[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (42))){
var inst_25015 = (state_25097[(19)]);
var inst_25050 = (state_25097[(25)]);
var inst_25052 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25015);
var inst_25053 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25050,inst_25052);
var state_25097__$1 = state_25097;
var statearr_25190_25272 = state_25097__$1;
(statearr_25190_25272[(2)] = inst_25053);

(statearr_25190_25272[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (37))){
var inst_25038 = (state_25097[(24)]);
var state_25097__$1 = state_25097;
var statearr_25191_25273 = state_25097__$1;
(statearr_25191_25273[(2)] = inst_25038);

(statearr_25191_25273[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (8))){
var inst_24973 = (state_25097[(2)]);
var state_25097__$1 = state_25097;
if(cljs.core.truth_(inst_24973)){
var statearr_25192_25274 = state_25097__$1;
(statearr_25192_25274[(1)] = (9));

} else {
var statearr_25193_25275 = state_25097__$1;
(statearr_25193_25275[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25098 === (49))){
var inst_25062 = (state_25097[(20)]);
var state_25097__$1 = state_25097;
var statearr_25194_25276 = state_25097__$1;
(statearr_25194_25276[(2)] = inst_25062);

(statearr_25194_25276[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_25195 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25195[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_25195[(1)] = (1));

return statearr_25195;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_25097){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_25097);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25196){var ex__2744__auto__ = e25196;
var statearr_25197_25277 = state_25097;
(statearr_25197_25277[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_25097[(4)]))){
var statearr_25198_25278 = state_25097;
(statearr_25198_25278[(1)] = cljs.core.first((state_25097[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25279 = state_25097;
state_25097 = G__25279;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_25097){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_25097);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25199 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_25199[(6)] = c__2763__auto__);

return statearr_25199;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25282,groupBy){
var map__25283 = p__25282;
var map__25283__$1 = cljs.core.__destructure_map(map__25283);
var res = map__25283__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25283__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25283__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25284 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25284,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25284,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25280_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25280_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25281_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25281_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25287 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25287,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25287,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25290,p__25291,opts){
var map__25292 = p__25290;
var map__25292__$1 = cljs.core.__destructure_map(map__25292);
var res = map__25292__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25292__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25293 = p__25291;
var map__25293__$1 = cljs.core.__destructure_map(map__25293);
var select_spec = map__25293__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25293__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_25535){
var state_val_25536 = (state_25535[(1)]);
if((state_val_25536 === (65))){
var state_25535__$1 = state_25535;
var statearr_25537_25688 = state_25535__$1;
(statearr_25537_25688[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (70))){
var inst_25456 = (state_25535[(7)]);
var state_25535__$1 = state_25535;
var statearr_25539_25689 = state_25535__$1;
(statearr_25539_25689[(2)] = inst_25456);

(statearr_25539_25689[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (62))){
var state_25535__$1 = state_25535;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25540_25690 = state_25535__$1;
(statearr_25540_25690[(1)] = (64));

} else {
var statearr_25541_25691 = state_25535__$1;
(statearr_25541_25691[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (74))){
var inst_25431 = (state_25535[(8)]);
var inst_25363 = (state_25535[(9)]);
var inst_25372 = (state_25535[(10)]);
var inst_25464 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25363,inst_25372,inst_25431);
var state_25535__$1 = state_25535;
var statearr_25542_25692 = state_25535__$1;
(statearr_25542_25692[(2)] = inst_25464);

(statearr_25542_25692[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (7))){
var state_25535__$1 = state_25535;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25543_25693 = state_25535__$1;
(statearr_25543_25693[(1)] = (82));

} else {
var statearr_25544_25694 = state_25535__$1;
(statearr_25544_25694[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (59))){
var inst_25431 = (state_25535[(8)]);
var inst_25361 = (state_25535[(11)]);
var inst_25435 = cljs.core.count(inst_25431);
var inst_25436 = (inst_25361 - inst_25435);
var state_25535__$1 = state_25535;
var statearr_25545_25695 = state_25535__$1;
(statearr_25545_25695[(2)] = inst_25436);

(statearr_25545_25695[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (86))){
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25546_25696 = state_25535__$1;
(statearr_25546_25696[(1)] = (89));

} else {
var statearr_25547_25697 = state_25535__$1;
(statearr_25547_25697[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (20))){
var state_25535__$1 = state_25535;
var statearr_25548_25698 = state_25535__$1;
(statearr_25548_25698[(2)] = (0));

(statearr_25548_25698[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (72))){
var inst_25461 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25461)){
var statearr_25549_25699 = state_25535__$1;
(statearr_25549_25699[(1)] = (73));

} else {
var statearr_25550_25700 = state_25535__$1;
(statearr_25550_25700[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (58))){
var state_25535__$1 = state_25535;
var statearr_25551_25701 = state_25535__$1;
(statearr_25551_25701[(2)] = null);

(statearr_25551_25701[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (60))){
var inst_25362 = (state_25535[(12)]);
var inst_25438 = (state_25535[(2)]);
var inst_25439 = (inst_25362 <= (0));
var state_25535__$1 = (function (){var statearr_25552 = state_25535;
(statearr_25552[(13)] = inst_25438);

return statearr_25552;
})();
if(cljs.core.truth_(inst_25439)){
var statearr_25553_25702 = state_25535__$1;
(statearr_25553_25702[(1)] = (61));

} else {
var statearr_25554_25703 = state_25535__$1;
(statearr_25554_25703[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (27))){
var inst_25361 = (state_25535[(11)]);
var inst_25385 = (inst_25361 < (1));
var state_25535__$1 = state_25535;
var statearr_25555_25704 = state_25535__$1;
(statearr_25555_25704[(2)] = inst_25385);

(statearr_25555_25704[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (1))){
var state_25535__$1 = state_25535;
var statearr_25556_25705 = state_25535__$1;
(statearr_25556_25705[(2)] = null);

(statearr_25556_25705[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (69))){
var inst_25451 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25557_25706 = state_25535__$1;
(statearr_25557_25706[(2)] = inst_25451);

(statearr_25557_25706[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (24))){
var inst_25363 = (state_25535[(9)]);
var state_25535__$1 = state_25535;
var statearr_25558_25707 = state_25535__$1;
(statearr_25558_25707[(2)] = inst_25363);

(statearr_25558_25707[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (55))){
var inst_25421 = (state_25535[(14)]);
var inst_25361 = (state_25535[(11)]);
var inst_25428 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25361,inst_25421);
var state_25535__$1 = state_25535;
var statearr_25559_25708 = state_25535__$1;
(statearr_25559_25708[(2)] = inst_25428);

(statearr_25559_25708[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (85))){
var inst_25506 = (state_25535[(15)]);
var inst_25505 = (state_25535[(2)]);
var inst_25506__$1 = fluree.db.util.async.throw_err(inst_25505);
var inst_25507 = cljs.core.coll_QMARK_(inst_25506__$1);
var inst_25508 = (!(inst_25507));
var state_25535__$1 = (function (){var statearr_25560 = state_25535;
(statearr_25560[(15)] = inst_25506__$1);

return statearr_25560;
})();
if(inst_25508){
var statearr_25561_25709 = state_25535__$1;
(statearr_25561_25709[(1)] = (86));

} else {
var statearr_25562_25710 = state_25535__$1;
(statearr_25562_25710[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (39))){
var inst_25380 = (state_25535[(16)]);
var inst_25402 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25403 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25404 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25380,inst_25402,inst_25403);
var state_25535__$1 = state_25535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25535__$1,(42),inst_25404);
} else {
if((state_val_25536 === (88))){
var inst_25528 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25563_25711 = state_25535__$1;
(statearr_25563_25711[(2)] = inst_25528);

(statearr_25563_25711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (46))){
var inst_25362 = (state_25535[(12)]);
var inst_25416 = ((0) < inst_25362);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25416)){
var statearr_25564_25712 = state_25535__$1;
(statearr_25564_25712[(1)] = (49));

} else {
var statearr_25565_25713 = state_25535__$1;
(statearr_25565_25713[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (4))){
var inst_25294 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25566_25714 = state_25535__$1;
(statearr_25566_25714[(2)] = inst_25294);

(statearr_25566_25714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (77))){
var inst_25361 = (state_25535[(11)]);
var inst_25472 = (inst_25361 - (1));
var state_25535__$1 = state_25535;
var statearr_25567_25715 = state_25535__$1;
(statearr_25567_25715[(2)] = inst_25472);

(statearr_25567_25715[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (95))){
var inst_25506 = (state_25535[(15)]);
var state_25535__$1 = state_25535;
var statearr_25568_25716 = state_25535__$1;
(statearr_25568_25716[(2)] = inst_25506);

(statearr_25568_25716[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (54))){
var inst_25426 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25426)){
var statearr_25569_25717 = state_25535__$1;
(statearr_25569_25717[(1)] = (55));

} else {
var statearr_25570_25718 = state_25535__$1;
(statearr_25570_25718[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (92))){
var inst_25506 = (state_25535[(15)]);
var inst_25519 = cljs.core.first(inst_25506);
var state_25535__$1 = state_25535;
var statearr_25571_25719 = state_25535__$1;
(statearr_25571_25719[(2)] = inst_25519);

(statearr_25571_25719[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (15))){
var inst_25312 = (state_25535[(17)]);
var inst_25320 = (state_25535[(2)]);
var inst_25321 = fluree.db.util.async.throw_err(inst_25320);
var inst_25322 = [inst_25312];
var inst_25323 = [inst_25321];
var inst_25324 = cljs.core.PersistentHashMap.fromArrays(inst_25322,inst_25323);
var state_25535__$1 = state_25535;
var statearr_25572_25720 = state_25535__$1;
(statearr_25572_25720[(2)] = inst_25324);

(statearr_25572_25720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (48))){
var inst_25484 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25573_25721 = state_25535__$1;
(statearr_25573_25721[(2)] = inst_25484);

(statearr_25573_25721[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (50))){
var inst_25407 = (state_25535[(18)]);
var state_25535__$1 = state_25535;
var statearr_25574_25722 = state_25535__$1;
(statearr_25574_25722[(2)] = inst_25407);

(statearr_25574_25722[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (75))){
var inst_25376 = (state_25535[(19)]);
var inst_25455 = (state_25535[(20)]);
var inst_25438 = (state_25535[(13)]);
var inst_25373 = (state_25535[(21)]);
var inst_25466 = (state_25535[(2)]);
var inst_25359 = inst_25373;
var inst_25360 = inst_25376;
var inst_25361 = inst_25438;
var inst_25362 = inst_25455;
var inst_25363 = inst_25466;
var state_25535__$1 = (function (){var statearr_25575 = state_25535;
(statearr_25575[(12)] = inst_25362);

(statearr_25575[(9)] = inst_25363);

(statearr_25575[(22)] = inst_25360);

(statearr_25575[(11)] = inst_25361);

(statearr_25575[(23)] = inst_25359);

return statearr_25575;
})();
var statearr_25576_25723 = state_25535__$1;
(statearr_25576_25723[(2)] = null);

(statearr_25576_25723[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (21))){
var inst_25344 = (state_25535[(24)]);
var inst_25340 = (state_25535[(25)]);
var inst_25352 = (state_25535[(26)]);
var inst_25357 = (state_25535[(2)]);
var inst_25358 = cljs.core.PersistentHashMap.EMPTY;
var inst_25359 = inst_25340;
var inst_25360 = inst_25344;
var inst_25361 = inst_25352;
var inst_25362 = inst_25357;
var inst_25363 = inst_25358;
var state_25535__$1 = (function (){var statearr_25577 = state_25535;
(statearr_25577[(12)] = inst_25362);

(statearr_25577[(9)] = inst_25363);

(statearr_25577[(22)] = inst_25360);

(statearr_25577[(11)] = inst_25361);

(statearr_25577[(23)] = inst_25359);

return statearr_25577;
})();
var statearr_25578_25724 = state_25535__$1;
(statearr_25578_25724[(2)] = null);

(statearr_25578_25724[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (31))){
var inst_25362 = (state_25535[(12)]);
var inst_25377 = (state_25535[(27)]);
var inst_25391 = (inst_25362 >= inst_25377);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25391)){
var statearr_25579_25725 = state_25535__$1;
(statearr_25579_25725[(1)] = (33));

} else {
var statearr_25580_25726 = state_25535__$1;
(statearr_25580_25726[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (32))){
var inst_25491 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25581_25727 = state_25535__$1;
(statearr_25581_25727[(2)] = inst_25491);

(statearr_25581_25727[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (40))){
var state_25535__$1 = state_25535;
var statearr_25582_25728 = state_25535__$1;
(statearr_25582_25728[(2)] = null);

(statearr_25582_25728[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (91))){
var inst_25516 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25583_25729 = state_25535__$1;
(statearr_25583_25729[(2)] = inst_25516);

(statearr_25583_25729[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (56))){
var inst_25421 = (state_25535[(14)]);
var state_25535__$1 = state_25535;
var statearr_25584_25730 = state_25535__$1;
(statearr_25584_25730[(2)] = inst_25421);

(statearr_25584_25730[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (33))){
var state_25535__$1 = state_25535;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25585_25731 = state_25535__$1;
(statearr_25585_25731[(1)] = (36));

} else {
var statearr_25586_25732 = state_25535__$1;
(statearr_25586_25732[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (13))){
var inst_25309 = (state_25535[(28)]);
var inst_25344 = (state_25535[(24)]);
var inst_25340 = (state_25535[(25)]);
var inst_25340__$1 = cljs.core.keys(inst_25309);
var inst_25341 = cljs.core.seq(inst_25340__$1);
var inst_25342 = cljs.core.first(inst_25341);
var inst_25343 = cljs.core.next(inst_25341);
var inst_25344__$1 = cljs.core.vals(inst_25309);
var inst_25345 = cljs.core.seq(inst_25344__$1);
var inst_25346 = cljs.core.first(inst_25345);
var inst_25347 = cljs.core.next(inst_25345);
var inst_25348 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25535__$1 = (function (){var statearr_25587 = state_25535;
(statearr_25587[(29)] = inst_25343);

(statearr_25587[(24)] = inst_25344__$1);

(statearr_25587[(30)] = inst_25347);

(statearr_25587[(31)] = inst_25342);

(statearr_25587[(25)] = inst_25340__$1);

(statearr_25587[(32)] = inst_25346);

return statearr_25587;
})();
if(inst_25348){
var statearr_25588_25733 = state_25535__$1;
(statearr_25588_25733[(1)] = (16));

} else {
var statearr_25589_25734 = state_25535__$1;
(statearr_25589_25734[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (22))){
var inst_25360 = (state_25535[(22)]);
var inst_25359 = (state_25535[(23)]);
var inst_25371 = cljs.core.seq(inst_25359);
var inst_25372 = cljs.core.first(inst_25371);
var inst_25373 = cljs.core.next(inst_25371);
var inst_25374 = cljs.core.seq(inst_25360);
var inst_25375 = cljs.core.first(inst_25374);
var inst_25376 = cljs.core.next(inst_25374);
var inst_25377 = cljs.core.count(inst_25375);
var inst_25378 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25379 = [headers,vars,inst_25375];
var inst_25380 = cljs.core.PersistentHashMap.fromArrays(inst_25378,inst_25379);
var inst_25381 = (inst_25375 == null);
var state_25535__$1 = (function (){var statearr_25590 = state_25535;
(statearr_25590[(16)] = inst_25380);

(statearr_25590[(19)] = inst_25376);

(statearr_25590[(10)] = inst_25372);

(statearr_25590[(27)] = inst_25377);

(statearr_25590[(21)] = inst_25373);

return statearr_25590;
})();
if(cljs.core.truth_(inst_25381)){
var statearr_25591_25735 = state_25535__$1;
(statearr_25591_25735[(1)] = (24));

} else {
var statearr_25592_25736 = state_25535__$1;
(statearr_25592_25736[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (90))){
var inst_25506 = (state_25535[(15)]);
var state_25535__$1 = state_25535;
var statearr_25593_25737 = state_25535__$1;
(statearr_25593_25737[(2)] = inst_25506);

(statearr_25593_25737[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (36))){
var inst_25362 = (state_25535[(12)]);
var inst_25394 = (inst_25362 - (1));
var state_25535__$1 = state_25535;
var statearr_25594_25738 = state_25535__$1;
(statearr_25594_25738[(2)] = inst_25394);

(statearr_25594_25738[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (41))){
var inst_25487 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25595_25739 = state_25535__$1;
(statearr_25595_25739[(2)] = inst_25487);

(statearr_25595_25739[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (89))){
var inst_25506 = (state_25535[(15)]);
var inst_25511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25512 = [inst_25506];
var inst_25513 = (new cljs.core.PersistentVector(null,1,(5),inst_25511,inst_25512,null));
var state_25535__$1 = state_25535;
var statearr_25596_25740 = state_25535__$1;
(statearr_25596_25740[(2)] = inst_25513);

(statearr_25596_25740[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (43))){
var inst_25407 = (state_25535[(18)]);
var inst_25410 = cljs.core.seq(inst_25407);
var state_25535__$1 = state_25535;
var statearr_25597_25741 = state_25535__$1;
(statearr_25597_25741[(2)] = inst_25410);

(statearr_25597_25741[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (61))){
var state_25535__$1 = state_25535;
var statearr_25598_25742 = state_25535__$1;
(statearr_25598_25742[(2)] = (0));

(statearr_25598_25742[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (29))){
var inst_25388 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25388)){
var statearr_25599_25743 = state_25535__$1;
(statearr_25599_25743[(1)] = (30));

} else {
var statearr_25600_25744 = state_25535__$1;
(statearr_25600_25744[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (44))){
var inst_25408 = (state_25535[(33)]);
var state_25535__$1 = state_25535;
var statearr_25601_25745 = state_25535__$1;
(statearr_25601_25745[(2)] = inst_25408);

(statearr_25601_25745[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (93))){
var state_25535__$1 = state_25535;
var statearr_25602_25746 = state_25535__$1;
(statearr_25602_25746[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (6))){
var inst_25301 = (state_25535[(34)]);
var inst_25301__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25303 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25535__$1 = (function (){var statearr_25604 = state_25535;
(statearr_25604[(34)] = inst_25301__$1);

(statearr_25604[(35)] = inst_25303);

return statearr_25604;
})();
if(cljs.core.truth_(inst_25301__$1)){
var statearr_25605_25747 = state_25535__$1;
(statearr_25605_25747[(1)] = (9));

} else {
var statearr_25606_25748 = state_25535__$1;
(statearr_25606_25748[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (28))){
var inst_25361 = (state_25535[(11)]);
var state_25535__$1 = state_25535;
var statearr_25607_25749 = state_25535__$1;
(statearr_25607_25749[(2)] = inst_25361);

(statearr_25607_25749[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (64))){
var inst_25362 = (state_25535[(12)]);
var inst_25443 = (inst_25362 - (1));
var state_25535__$1 = state_25535;
var statearr_25608_25750 = state_25535__$1;
(statearr_25608_25750[(2)] = inst_25443);

(statearr_25608_25750[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (51))){
var inst_25361 = (state_25535[(11)]);
var inst_25421 = (state_25535[(2)]);
var state_25535__$1 = (function (){var statearr_25609 = state_25535;
(statearr_25609[(14)] = inst_25421);

return statearr_25609;
})();
if(cljs.core.truth_(inst_25361)){
var statearr_25610_25751 = state_25535__$1;
(statearr_25610_25751[(1)] = (52));

} else {
var statearr_25611_25752 = state_25535__$1;
(statearr_25611_25752[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (25))){
var inst_25361 = (state_25535[(11)]);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25361)){
var statearr_25612_25753 = state_25535__$1;
(statearr_25612_25753[(1)] = (27));

} else {
var statearr_25613_25754 = state_25535__$1;
(statearr_25613_25754[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (34))){
var state_25535__$1 = state_25535;
var statearr_25614_25755 = state_25535__$1;
(statearr_25614_25755[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (17))){
var state_25535__$1 = state_25535;
var statearr_25616_25756 = state_25535__$1;
(statearr_25616_25756[(2)] = limit);

(statearr_25616_25756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (3))){
var inst_25533 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25535__$1,inst_25533);
} else {
if((state_val_25536 === (12))){
var inst_25309 = (state_25535[(28)]);
var inst_25311 = cljs.core.keys(inst_25309);
var inst_25312 = cljs.core.first(inst_25311);
var inst_25313 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25314 = cljs.core.vals(inst_25309);
var inst_25315 = cljs.core.first(inst_25314);
var inst_25316 = [headers,vars,inst_25315];
var inst_25317 = cljs.core.PersistentHashMap.fromArrays(inst_25313,inst_25316);
var inst_25318 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_25317,select_spec,limit,opts);
var state_25535__$1 = (function (){var statearr_25617 = state_25535;
(statearr_25617[(17)] = inst_25312);

return statearr_25617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25535__$1,(15),inst_25318);
} else {
if((state_val_25536 === (2))){
var _ = (function (){var statearr_25618 = state_25535;
(statearr_25618[(4)] = cljs.core.cons((5),(state_25535[(4)])));

return statearr_25618;
})();
var state_25535__$1 = state_25535;
if(cljs.core.truth_(groupBy)){
var statearr_25619_25757 = state_25535__$1;
(statearr_25619_25757[(1)] = (6));

} else {
var statearr_25620_25758 = state_25535__$1;
(statearr_25620_25758[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (66))){
var inst_25453 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25621_25759 = state_25535__$1;
(statearr_25621_25759[(2)] = inst_25453);

(statearr_25621_25759[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (23))){
var inst_25495 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25622_25760 = state_25535__$1;
(statearr_25622_25760[(2)] = inst_25495);

(statearr_25622_25760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (47))){
var inst_25361 = (state_25535[(11)]);
var inst_25469 = (inst_25361 == null);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25469)){
var statearr_25623_25761 = state_25535__$1;
(statearr_25623_25761[(1)] = (76));

} else {
var statearr_25624_25762 = state_25535__$1;
(statearr_25624_25762[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (35))){
var inst_25489 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25625_25763 = state_25535__$1;
(statearr_25625_25763[(2)] = inst_25489);

(statearr_25625_25763[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (82))){
var state_25535__$1 = state_25535;
var statearr_25626_25764 = state_25535__$1;
(statearr_25626_25764[(2)] = (1));

(statearr_25626_25764[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (76))){
var state_25535__$1 = state_25535;
var statearr_25627_25765 = state_25535__$1;
(statearr_25627_25765[(2)] = null);

(statearr_25627_25765[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (97))){
var inst_25524 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25628_25766 = state_25535__$1;
(statearr_25628_25766[(2)] = inst_25524);

(statearr_25628_25766[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (19))){
var inst_25353 = (state_25535[(36)]);
var state_25535__$1 = state_25535;
var statearr_25629_25767 = state_25535__$1;
(statearr_25629_25767[(2)] = inst_25353);

(statearr_25629_25767[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (57))){
var inst_25361 = (state_25535[(11)]);
var inst_25431 = (state_25535[(2)]);
var inst_25432 = (inst_25361 == null);
var state_25535__$1 = (function (){var statearr_25630 = state_25535;
(statearr_25630[(8)] = inst_25431);

return statearr_25630;
})();
if(cljs.core.truth_(inst_25432)){
var statearr_25631_25768 = state_25535__$1;
(statearr_25631_25768[(1)] = (58));

} else {
var statearr_25632_25769 = state_25535__$1;
(statearr_25632_25769[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (68))){
var state_25535__$1 = state_25535;
var statearr_25633_25770 = state_25535__$1;
(statearr_25633_25770[(2)] = null);

(statearr_25633_25770[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (11))){
var inst_25309 = (state_25535[(2)]);
var state_25535__$1 = (function (){var statearr_25635 = state_25535;
(statearr_25635[(28)] = inst_25309);

return statearr_25635;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25636_25771 = state_25535__$1;
(statearr_25636_25771[(1)] = (12));

} else {
var statearr_25637_25772 = state_25535__$1;
(statearr_25637_25772[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (9))){
var inst_25301 = (state_25535[(34)]);
var inst_25303 = (state_25535[(35)]);
var inst_25305 = cljs.core.sorted_map_by(inst_25301);
var inst_25306 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25305,inst_25303);
var state_25535__$1 = state_25535;
var statearr_25638_25773 = state_25535__$1;
(statearr_25638_25773[(2)] = inst_25306);

(statearr_25638_25773[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (5))){
var _ = (function (){var statearr_25639 = state_25535;
(statearr_25639[(4)] = cljs.core.rest((state_25535[(4)])));

return statearr_25639;
})();
var state_25535__$1 = state_25535;
var ex25634 = (state_25535__$1[(2)]);
var statearr_25640_25774 = state_25535__$1;
(statearr_25640_25774[(5)] = ex25634);


if((ex25634 instanceof Error)){
var statearr_25641_25775 = state_25535__$1;
(statearr_25641_25775[(1)] = (4));

(statearr_25641_25775[(5)] = null);

} else {
throw ex25634;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (83))){
var state_25535__$1 = state_25535;
var statearr_25642_25776 = state_25535__$1;
(statearr_25642_25776[(2)] = limit);

(statearr_25642_25776[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (14))){
var inst_25497 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25643_25777 = state_25535__$1;
(statearr_25643_25777[(2)] = inst_25497);

(statearr_25643_25777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (45))){
var inst_25413 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
if(cljs.core.truth_(inst_25413)){
var statearr_25644_25778 = state_25535__$1;
(statearr_25644_25778[(1)] = (46));

} else {
var statearr_25645_25779 = state_25535__$1;
(statearr_25645_25779[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (53))){
var inst_25361 = (state_25535[(11)]);
var state_25535__$1 = state_25535;
var statearr_25646_25780 = state_25535__$1;
(statearr_25646_25780[(2)] = inst_25361);

(statearr_25646_25780[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (78))){
var inst_25362 = (state_25535[(12)]);
var inst_25474 = (state_25535[(2)]);
var inst_25475 = (inst_25362 <= (0));
var state_25535__$1 = (function (){var statearr_25647 = state_25535;
(statearr_25647[(37)] = inst_25474);

return statearr_25647;
})();
if(cljs.core.truth_(inst_25475)){
var statearr_25648_25781 = state_25535__$1;
(statearr_25648_25781[(1)] = (79));

} else {
var statearr_25649_25782 = state_25535__$1;
(statearr_25649_25782[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (26))){
var inst_25493 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25650_25783 = state_25535__$1;
(statearr_25650_25783[(2)] = inst_25493);

(statearr_25650_25783[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (16))){
var state_25535__$1 = state_25535;
var statearr_25651_25784 = state_25535__$1;
(statearr_25651_25784[(2)] = null);

(statearr_25651_25784[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (81))){
var inst_25363 = (state_25535[(9)]);
var inst_25376 = (state_25535[(19)]);
var inst_25372 = (state_25535[(10)]);
var inst_25474 = (state_25535[(37)]);
var inst_25407 = (state_25535[(18)]);
var inst_25373 = (state_25535[(21)]);
var inst_25480 = (state_25535[(2)]);
var inst_25481 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25363,inst_25372,inst_25407);
var inst_25359 = inst_25373;
var inst_25360 = inst_25376;
var inst_25361 = inst_25474;
var inst_25362 = inst_25480;
var inst_25363__$1 = inst_25481;
var state_25535__$1 = (function (){var statearr_25654 = state_25535;
(statearr_25654[(12)] = inst_25362);

(statearr_25654[(9)] = inst_25363__$1);

(statearr_25654[(22)] = inst_25360);

(statearr_25654[(11)] = inst_25361);

(statearr_25654[(23)] = inst_25359);

return statearr_25654;
})();
var statearr_25655_25785 = state_25535__$1;
(statearr_25655_25785[(2)] = null);

(statearr_25655_25785[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (79))){
var state_25535__$1 = state_25535;
var statearr_25656_25786 = state_25535__$1;
(statearr_25656_25786[(2)] = (0));

(statearr_25656_25786[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (38))){
var inst_25363 = (state_25535[(9)]);
var inst_25376 = (state_25535[(19)]);
var inst_25361 = (state_25535[(11)]);
var inst_25373 = (state_25535[(21)]);
var inst_25398 = (state_25535[(2)]);
var tmp25652 = inst_25363;
var tmp25653 = inst_25361;
var inst_25359 = inst_25373;
var inst_25360 = inst_25376;
var inst_25361__$1 = tmp25653;
var inst_25362 = inst_25398;
var inst_25363__$1 = tmp25652;
var state_25535__$1 = (function (){var statearr_25657 = state_25535;
(statearr_25657[(12)] = inst_25362);

(statearr_25657[(9)] = inst_25363__$1);

(statearr_25657[(22)] = inst_25360);

(statearr_25657[(11)] = inst_25361__$1);

(statearr_25657[(23)] = inst_25359);

return statearr_25657;
})();
var statearr_25658_25787 = state_25535__$1;
(statearr_25658_25787[(2)] = null);

(statearr_25658_25787[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (87))){
var state_25535__$1 = state_25535;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25659_25788 = state_25535__$1;
(statearr_25659_25788[(1)] = (92));

} else {
var statearr_25660_25789 = state_25535__$1;
(statearr_25660_25789[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (30))){
var inst_25363 = (state_25535[(9)]);
var state_25535__$1 = state_25535;
var statearr_25661_25790 = state_25535__$1;
(statearr_25661_25790[(2)] = inst_25363);

(statearr_25661_25790[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (73))){
var inst_25363 = (state_25535[(9)]);
var state_25535__$1 = state_25535;
var statearr_25662_25791 = state_25535__$1;
(statearr_25662_25791[(2)] = inst_25363);

(statearr_25662_25791[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (96))){
var state_25535__$1 = state_25535;
var statearr_25663_25792 = state_25535__$1;
(statearr_25663_25792[(2)] = null);

(statearr_25663_25792[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (10))){
var inst_25303 = (state_25535[(35)]);
var state_25535__$1 = state_25535;
var statearr_25664_25793 = state_25535__$1;
(statearr_25664_25793[(2)] = inst_25303);

(statearr_25664_25793[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (18))){
var inst_25353 = (state_25535[(36)]);
var inst_25352 = (state_25535[(2)]);
var inst_25353__$1 = offset;
var state_25535__$1 = (function (){var statearr_25665 = state_25535;
(statearr_25665[(36)] = inst_25353__$1);

(statearr_25665[(26)] = inst_25352);

return statearr_25665;
})();
if(cljs.core.truth_(inst_25353__$1)){
var statearr_25666_25794 = state_25535__$1;
(statearr_25666_25794[(1)] = (19));

} else {
var statearr_25667_25795 = state_25535__$1;
(statearr_25667_25795[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (52))){
var inst_25361 = (state_25535[(11)]);
var inst_25423 = ((0) < inst_25361);
var state_25535__$1 = state_25535;
var statearr_25668_25796 = state_25535__$1;
(statearr_25668_25796[(2)] = inst_25423);

(statearr_25668_25796[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (67))){
var inst_25362 = (state_25535[(12)]);
var inst_25431 = (state_25535[(8)]);
var inst_25377 = (state_25535[(27)]);
var inst_25446 = cljs.core.count(inst_25431);
var inst_25447 = (inst_25377 - inst_25446);
var inst_25448 = (inst_25362 - inst_25447);
var state_25535__$1 = state_25535;
var statearr_25669_25797 = state_25535__$1;
(statearr_25669_25797[(2)] = inst_25448);

(statearr_25669_25797[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (71))){
var inst_25431 = (state_25535[(8)]);
var inst_25459 = cljs.core.empty_QMARK_(inst_25431);
var state_25535__$1 = state_25535;
var statearr_25670_25798 = state_25535__$1;
(statearr_25670_25798[(2)] = inst_25459);

(statearr_25670_25798[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (42))){
var inst_25408 = (state_25535[(33)]);
var inst_25407 = (state_25535[(18)]);
var inst_25406 = (state_25535[(2)]);
var inst_25407__$1 = fluree.db.util.async.throw_err(inst_25406);
var inst_25408__$1 = cljs.core.coll_QMARK_(inst_25407__$1);
var state_25535__$1 = (function (){var statearr_25671 = state_25535;
(statearr_25671[(33)] = inst_25408__$1);

(statearr_25671[(18)] = inst_25407__$1);

return statearr_25671;
})();
if(inst_25408__$1){
var statearr_25672_25799 = state_25535__$1;
(statearr_25672_25799[(1)] = (43));

} else {
var statearr_25673_25800 = state_25535__$1;
(statearr_25673_25800[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (80))){
var inst_25362 = (state_25535[(12)]);
var inst_25478 = (inst_25362 - (1));
var state_25535__$1 = state_25535;
var statearr_25674_25801 = state_25535__$1;
(statearr_25674_25801[(2)] = inst_25478);

(statearr_25674_25801[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (37))){
var inst_25362 = (state_25535[(12)]);
var inst_25377 = (state_25535[(27)]);
var inst_25396 = (inst_25362 - inst_25377);
var state_25535__$1 = state_25535;
var statearr_25675_25802 = state_25535__$1;
(statearr_25675_25802[(2)] = inst_25396);

(statearr_25675_25802[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (63))){
var inst_25431 = (state_25535[(8)]);
var inst_25456 = (state_25535[(7)]);
var inst_25455 = (state_25535[(2)]);
var inst_25456__$1 = (inst_25431 == null);
var state_25535__$1 = (function (){var statearr_25676 = state_25535;
(statearr_25676[(7)] = inst_25456__$1);

(statearr_25676[(20)] = inst_25455);

return statearr_25676;
})();
if(cljs.core.truth_(inst_25456__$1)){
var statearr_25677_25803 = state_25535__$1;
(statearr_25677_25803[(1)] = (70));

} else {
var statearr_25678_25804 = state_25535__$1;
(statearr_25678_25804[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (94))){
var inst_25526 = (state_25535[(2)]);
var state_25535__$1 = state_25535;
var statearr_25679_25805 = state_25535__$1;
(statearr_25679_25805[(2)] = inst_25526);

(statearr_25679_25805[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (8))){
var inst_25530 = (state_25535[(2)]);
var _ = (function (){var statearr_25680 = state_25535;
(statearr_25680[(4)] = cljs.core.rest((state_25535[(4)])));

return statearr_25680;
})();
var state_25535__$1 = state_25535;
var statearr_25681_25806 = state_25535__$1;
(statearr_25681_25806[(2)] = inst_25530);

(statearr_25681_25806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (49))){
var inst_25362 = (state_25535[(12)]);
var inst_25407 = (state_25535[(18)]);
var inst_25418 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25362,inst_25407);
var state_25535__$1 = state_25535;
var statearr_25682_25807 = state_25535__$1;
(statearr_25682_25807[(2)] = inst_25418);

(statearr_25682_25807[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25536 === (84))){
var inst_25502 = (state_25535[(2)]);
var inst_25503 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25502,opts);
var state_25535__$1 = state_25535;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25535__$1,(85),inst_25503);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0 = (function (){
var statearr_25683 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25683[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__);

(statearr_25683[(1)] = (1));

return statearr_25683;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1 = (function (state_25535){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_25535);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25684){var ex__2744__auto__ = e25684;
var statearr_25685_25808 = state_25535;
(statearr_25685_25808[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_25535[(4)]))){
var statearr_25686_25809 = state_25535;
(statearr_25686_25809[(1)] = cljs.core.first((state_25535[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25810 = state_25535;
state_25535 = G__25810;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__ = function(state_25535){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1.call(this,state_25535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25687 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_25687[(6)] = c__2763__auto__);

return statearr_25687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25813,opts){
var map__25814 = p__25813;
var map__25814__$1 = cljs.core.__destructure_map(map__25814);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25814__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25814__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25814__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25814__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25811_SHARP_){
return cljs.core.contains_QMARK_(p1__25811_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25812_SHARP_){
return cljs.core.contains_QMARK_(p1__25812_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4251__auto__){
var G__25816 = cljs.core.first(orderBy);
var fexpr__25815 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25815.cljs$core$IFn$_invoke$arity$1 ? fexpr__25815.cljs$core$IFn$_invoke$arity$1(G__25816) : fexpr__25815.call(null,G__25816));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25817,p__25818){
var map__25819 = p__25817;
var map__25819__$1 = cljs.core.__destructure_map(map__25819);
var query_map = map__25819__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25819__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25820 = p__25818;
var map__25820__$1 = cljs.core.__destructure_map(map__25820);
var where_result = map__25820__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25820__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25820__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25821 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25821,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25821,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25821,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_25854){
var state_val_25855 = (state_25854[(1)]);
if((state_val_25855 === (7))){
var inst_25833 = (state_25854[(7)]);
var state_25854__$1 = state_25854;
var statearr_25856_25879 = state_25854__$1;
(statearr_25856_25879[(2)] = inst_25833);

(statearr_25856_25879[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (1))){
var state_25854__$1 = state_25854;
var statearr_25857_25880 = state_25854__$1;
(statearr_25857_25880[(2)] = null);

(statearr_25857_25880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (4))){
var inst_25824 = (state_25854[(2)]);
var state_25854__$1 = state_25854;
var statearr_25858_25881 = state_25854__$1;
(statearr_25858_25881[(2)] = inst_25824);

(statearr_25858_25881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (13))){
var inst_25843 = (state_25854[(2)]);
var inst_25844 = fluree.db.util.async.throw_err(inst_25843);
var state_25854__$1 = state_25854;
var statearr_25859_25882 = state_25854__$1;
(statearr_25859_25882[(2)] = inst_25844);

(statearr_25859_25882[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (6))){
var inst_25833 = (state_25854[(7)]);
var inst_25832 = (state_25854[(2)]);
var inst_25833__$1 = fluree.db.util.async.throw_err(inst_25832);
var inst_25834 = fluree.db.util.core.exception_QMARK_(inst_25833__$1);
var state_25854__$1 = (function (){var statearr_25860 = state_25854;
(statearr_25860[(7)] = inst_25833__$1);

return statearr_25860;
})();
if(inst_25834){
var statearr_25861_25883 = state_25854__$1;
(statearr_25861_25883[(1)] = (7));

} else {
var statearr_25862_25884 = state_25854__$1;
(statearr_25862_25884[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (3))){
var inst_25852 = (state_25854[(2)]);
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25854__$1,inst_25852);
} else {
if((state_val_25855 === (12))){
var inst_25847 = (state_25854[(2)]);
var state_25854__$1 = state_25854;
var statearr_25863_25885 = state_25854__$1;
(statearr_25863_25885[(2)] = inst_25847);

(statearr_25863_25885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (2))){
var _ = (function (){var statearr_25864 = state_25854;
(statearr_25864[(4)] = cljs.core.cons((5),(state_25854[(4)])));

return statearr_25864;
})();
var inst_25830 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25854__$1,(6),inst_25830);
} else {
if((state_val_25855 === (11))){
var state_25854__$1 = state_25854;
var statearr_25866_25886 = state_25854__$1;
(statearr_25866_25886[(2)] = null);

(statearr_25866_25886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (9))){
var inst_25849 = (state_25854[(2)]);
var _ = (function (){var statearr_25867 = state_25854;
(statearr_25867[(4)] = cljs.core.rest((state_25854[(4)])));

return statearr_25867;
})();
var state_25854__$1 = state_25854;
var statearr_25868_25887 = state_25854__$1;
(statearr_25868_25887[(2)] = inst_25849);

(statearr_25868_25887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (5))){
var _ = (function (){var statearr_25869 = state_25854;
(statearr_25869[(4)] = cljs.core.rest((state_25854[(4)])));

return statearr_25869;
})();
var state_25854__$1 = state_25854;
var ex25865 = (state_25854__$1[(2)]);
var statearr_25870_25888 = state_25854__$1;
(statearr_25870_25888[(5)] = ex25865);


if((ex25865 instanceof Error)){
var statearr_25871_25889 = state_25854__$1;
(statearr_25871_25889[(1)] = (4));

(statearr_25871_25889[(5)] = null);

} else {
throw ex25865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25855 === (10))){
var inst_25833 = (state_25854[(7)]);
var inst_25838 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25833);
var inst_25839 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25833);
var inst_25840 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25838,inst_25839,query_map,opts);
var inst_25841 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25833,inst_25840,opts);
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25854__$1,(13),inst_25841);
} else {
if((state_val_25855 === (8))){
var state_25854__$1 = state_25854;
var statearr_25872_25890 = state_25854__$1;
(statearr_25872_25890[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0 = (function (){
var statearr_25874 = [null,null,null,null,null,null,null,null];
(statearr_25874[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__);

(statearr_25874[(1)] = (1));

return statearr_25874;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1 = (function (state_25854){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_25854);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25875){var ex__2744__auto__ = e25875;
var statearr_25876_25891 = state_25854;
(statearr_25876_25891[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_25854[(4)]))){
var statearr_25877_25892 = state_25854;
(statearr_25877_25892[(1)] = cljs.core.first((state_25854[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25893 = state_25854;
state_25854 = G__25893;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__ = function(state_25854){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1.call(this,state_25854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25878 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_25878[(6)] = c__2763__auto__);

return statearr_25878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__25894 = query_map;
var map__25894__$1 = cljs.core.__destructure_map(map__25894);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25894__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25895 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25895,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25895;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26253){
var state_val_26254 = (state_26253[(1)]);
if((state_val_26254 === (121))){
var inst_26214 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26255_26450 = state_26253__$1;
(statearr_26255_26450[(2)] = inst_26214);

(statearr_26255_26450[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (65))){
var inst_26091 = typeof from === 'string';
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_26091)){
var statearr_26256_26451 = state_26253__$1;
(statearr_26256_26451[(1)] = (72));

} else {
var statearr_26257_26452 = state_26253__$1;
(statearr_26257_26452[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (70))){
var inst_25959 = (state_26253[(7)]);
var inst_25957 = (state_26253[(8)]);
var inst_26084 = (state_26253[(2)]);
var inst_26085 = fluree.db.util.async.throw_err(inst_26084);
var inst_26086 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25959,fuel,max_fuel,inst_25957,inst_26085);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(71),inst_26086);
} else {
if((state_val_26254 === (62))){
var inst_26064 = (state_26253[(9)]);
var state_26253__$1 = state_26253;
var statearr_26258_26453 = state_26253__$1;
(statearr_26258_26453[(2)] = inst_26064);

(statearr_26258_26453[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (74))){
var inst_26220 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26259_26454 = state_26253__$1;
(statearr_26259_26454[(2)] = inst_26220);

(statearr_26259_26454[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (110))){
var inst_26155 = (state_26253[(10)]);
var state_26253__$1 = state_26253;
var statearr_26260_26455 = state_26253__$1;
(statearr_26260_26455[(2)] = inst_26155);

(statearr_26260_26455[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (130))){
var inst_26240 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26261_26456 = state_26253__$1;
(statearr_26261_26456[(2)] = inst_26240);

(statearr_26261_26456[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (128))){
var inst_26231 = (state_26253[(11)]);
var inst_26236 = fluree.db.util.core.exception_QMARK_(inst_26231);
var inst_26237 = (!(inst_26236));
var state_26253__$1 = state_26253;
var statearr_26262_26457 = state_26253__$1;
(statearr_26262_26457[(2)] = inst_26237);

(statearr_26262_26457[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (7))){
var inst_25927 = (state_26253[(12)]);
var inst_25927__$1 = selectOne;
var state_26253__$1 = (function (){var statearr_26263 = state_26253;
(statearr_26263[(12)] = inst_25927__$1);

return statearr_26263;
})();
if(cljs.core.truth_(inst_25927__$1)){
var statearr_26264_26458 = state_26253__$1;
(statearr_26264_26458[(1)] = (9));

} else {
var statearr_26265_26459 = state_26253__$1;
(statearr_26265_26459[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (59))){
var inst_25947 = (state_26253[(13)]);
var inst_25959 = (state_26253[(7)]);
var inst_26042 = (state_26253[(14)]);
var inst_25957 = (state_26253[(8)]);
var inst_26056 = (state_26253[(2)]);
var inst_26057 = fluree.db.util.async.throw_err(inst_26056);
var inst_26058 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_26042,inst_26057);
var inst_26059 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25959,fuel,max_fuel,inst_25957,inst_26058,inst_25947);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(60),inst_26059);
} else {
if((state_val_26254 === (86))){
var inst_25947 = (state_26253[(13)]);
var inst_25959 = (state_26253[(7)]);
var inst_25957 = (state_26253[(8)]);
var inst_25949 = (state_26253[(15)]);
var inst_26124 = (state_26253[(2)]);
var inst_26125 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25959,fuel,max_fuel,inst_25957,inst_26124,inst_25947,inst_25949);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(87),inst_26125);
} else {
if((state_val_26254 === (20))){
var inst_25991 = (state_26253[(2)]);
var inst_25992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25991,(0),null);
var inst_25993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25991,(1),null);
var inst_25994 = typeof where === 'string';
var state_26253__$1 = (function (){var statearr_26266 = state_26253;
(statearr_26266[(16)] = inst_25992);

(statearr_26266[(17)] = inst_25993);

return statearr_26266;
})();
if(cljs.core.truth_(inst_25994)){
var statearr_26267_26460 = state_26253__$1;
(statearr_26267_26460[(1)] = (30));

} else {
var statearr_26268_26461 = state_26253__$1;
(statearr_26268_26461[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (72))){
var inst_25946 = (state_26253[(18)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_25946)){
var statearr_26269_26462 = state_26253__$1;
(statearr_26269_26462[(1)] = (75));

} else {
var statearr_26270_26463 = state_26253__$1;
(statearr_26270_26463[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (58))){
var inst_26050 = (state_26253[(2)]);
var inst_26051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26052 = [from];
var inst_26053 = (new cljs.core.PersistentVector(null,1,(5),inst_26051,inst_26052,null));
var inst_26054 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26053,inst_26050);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(59),inst_26054);
} else {
if((state_val_26254 === (60))){
var inst_26061 = (state_26253[(2)]);
var inst_26062 = fluree.db.util.async.throw_err(inst_26061);
var state_26253__$1 = state_26253;
var statearr_26271_26464 = state_26253__$1;
(statearr_26271_26464[(2)] = inst_26062);

(statearr_26271_26464[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (27))){
var inst_25976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25977 = [null,null];
var inst_25978 = (new cljs.core.PersistentVector(null,2,(5),inst_25976,inst_25977,null));
var state_26253__$1 = state_26253;
var statearr_26272_26465 = state_26253__$1;
(statearr_26272_26465[(2)] = inst_25978);

(statearr_26272_26465[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (1))){
var state_26253__$1 = state_26253;
var statearr_26273_26466 = state_26253__$1;
(statearr_26273_26466[(2)] = null);

(statearr_26273_26466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (69))){
var inst_26081 = (state_26253[(2)]);
var inst_26082 = fluree.db.query.range._block_or_tx_collection(db,inst_26081);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(70),inst_26082);
} else {
if((state_val_26254 === (101))){
var inst_26187 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26274_26467 = state_26253__$1;
(statearr_26274_26467[(2)] = inst_26187);

(statearr_26274_26467[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (24))){
var inst_25946 = (state_26253[(18)]);
var inst_25971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25972 = [inst_25946,"ASC"];
var inst_25973 = (new cljs.core.PersistentVector(null,2,(5),inst_25971,inst_25972,null));
var state_26253__$1 = state_26253;
var statearr_26275_26468 = state_26253__$1;
(statearr_26275_26468[(2)] = inst_25973);

(statearr_26275_26468[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (102))){
var inst_26161 = (state_26253[(19)]);
var state_26253__$1 = state_26253;
var statearr_26276_26469 = state_26253__$1;
(statearr_26276_26469[(2)] = inst_26161);

(statearr_26276_26469[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (55))){
var inst_25946 = (state_26253[(18)]);
var inst_26042 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26277 = state_26253;
(statearr_26277[(14)] = inst_26042);

return statearr_26277;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26278_26470 = state_26253__$1;
(statearr_26278_26470[(1)] = (56));

} else {
var statearr_26279_26471 = state_26253__$1;
(statearr_26279_26471[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (85))){
var inst_26116 = (state_26253[(20)]);
var inst_26120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26121 = [inst_26116];
var inst_26122 = (new cljs.core.PersistentVector(null,1,(5),inst_26120,inst_26121,null));
var state_26253__$1 = state_26253;
var statearr_26280_26472 = state_26253__$1;
(statearr_26280_26472[(2)] = inst_26122);

(statearr_26280_26472[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (39))){
var inst_25947 = (state_26253[(13)]);
var state_26253__$1 = state_26253;
var statearr_26281_26473 = state_26253__$1;
(statearr_26281_26473[(2)] = inst_25947);

(statearr_26281_26473[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (88))){
var inst_26130 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26253__$1 = state_26253;
var statearr_26282_26474 = state_26253__$1;
(statearr_26282_26474[(2)] = inst_26130);

(statearr_26282_26474[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (46))){
var inst_26027 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_26027)){
var statearr_26283_26475 = state_26253__$1;
(statearr_26283_26475[(1)] = (47));

} else {
var statearr_26284_26476 = state_26253__$1;
(statearr_26284_26476[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (4))){
var inst_25914 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26285_26477 = state_26253__$1;
(statearr_26285_26477[(2)] = inst_25914);

(statearr_26285_26477[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (77))){
var inst_26100 = (state_26253[(2)]);
var inst_26101 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_26100);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(78),inst_26101);
} else {
if((state_val_26254 === (106))){
var state_26253__$1 = state_26253;
var statearr_26286_26478 = state_26253__$1;
(statearr_26286_26478[(2)] = null);

(statearr_26286_26478[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (119))){
var inst_26206 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_26207 = ["Invalid 'from' in query:",inst_26206].join('');
var inst_26208 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26209 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26210 = cljs.core.PersistentHashMap.fromArrays(inst_26208,inst_26209);
var inst_26211 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26207,inst_26210);
var state_26253__$1 = state_26253;
var statearr_26287_26479 = state_26253__$1;
(statearr_26287_26479[(2)] = inst_26211);

(statearr_26287_26479[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (95))){
var state_26253__$1 = state_26253;
var statearr_26288_26480 = state_26253__$1;
(statearr_26288_26480[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (54))){
var inst_26036 = (state_26253[(21)]);
var state_26253__$1 = state_26253;
var statearr_26290_26481 = state_26253__$1;
(statearr_26290_26481[(2)] = inst_26036);

(statearr_26290_26481[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (92))){
var inst_26135 = (state_26253[(22)]);
var state_26253__$1 = state_26253;
var statearr_26291_26482 = state_26253__$1;
(statearr_26291_26482[(2)] = inst_26135);

(statearr_26291_26482[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (104))){
var inst_26179 = (state_26253[(23)]);
var inst_26179__$1 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26292 = state_26253;
(statearr_26292[(23)] = inst_26179__$1);

return statearr_26292;
})();
if(cljs.core.truth_(inst_26179__$1)){
var statearr_26293_26483 = state_26253__$1;
(statearr_26293_26483[(1)] = (109));

} else {
var statearr_26294_26484 = state_26253__$1;
(statearr_26294_26484[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (15))){
var inst_25948 = (state_26253[(24)]);
var inst_25950 = (state_26253[(25)]);
var inst_25954 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25950,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25948);
var state_26253__$1 = state_26253;
var statearr_26295_26485 = state_26253__$1;
(statearr_26295_26485[(2)] = inst_25954);

(statearr_26295_26485[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (48))){
var inst_26064 = (state_26253[(9)]);
var inst_26064__$1 = typeof from === 'string';
var state_26253__$1 = (function (){var statearr_26296 = state_26253;
(statearr_26296[(9)] = inst_26064__$1);

return statearr_26296;
})();
if(cljs.core.truth_(inst_26064__$1)){
var statearr_26297_26486 = state_26253__$1;
(statearr_26297_26486[(1)] = (61));

} else {
var statearr_26298_26487 = state_26253__$1;
(statearr_26298_26487[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (50))){
var inst_26030 = (state_26253[(26)]);
var inst_26032 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_26033 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26030,inst_26032);
var state_26253__$1 = state_26253;
var statearr_26299_26488 = state_26253__$1;
(statearr_26299_26488[(2)] = inst_26033);

(statearr_26299_26488[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (116))){
var state_26253__$1 = state_26253;
var statearr_26300_26489 = state_26253__$1;
(statearr_26300_26489[(2)] = null);

(statearr_26300_26489[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (75))){
var inst_26094 = cljs.core.PersistentHashMap.EMPTY;
var state_26253__$1 = state_26253;
var statearr_26301_26490 = state_26253__$1;
(statearr_26301_26490[(2)] = inst_26094);

(statearr_26301_26490[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (99))){
var inst_26155 = (state_26253[(10)]);
var state_26253__$1 = state_26253;
var statearr_26302_26491 = state_26253__$1;
(statearr_26302_26491[(2)] = inst_26155);

(statearr_26302_26491[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (21))){
var inst_25946 = (state_26253[(18)]);
var inst_25963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25964 = cljs.core.second(inst_25946);
var inst_25965 = cljs.core.first(inst_25946);
var inst_25966 = [inst_25964,inst_25965];
var inst_25967 = (new cljs.core.PersistentVector(null,2,(5),inst_25963,inst_25966,null));
var state_26253__$1 = state_26253;
var statearr_26303_26492 = state_26253__$1;
(statearr_26303_26492[(2)] = inst_25967);

(statearr_26303_26492[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (31))){
var inst_26021 = (state_26253[(27)]);
var inst_26021__$1 = typeof from === 'string';
var state_26253__$1 = (function (){var statearr_26304 = state_26253;
(statearr_26304[(27)] = inst_26021__$1);

return statearr_26304;
})();
if(cljs.core.truth_(inst_26021__$1)){
var statearr_26305_26493 = state_26253__$1;
(statearr_26305_26493[(1)] = (44));

} else {
var statearr_26306_26494 = state_26253__$1;
(statearr_26306_26494[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (113))){
var state_26253__$1 = state_26253;
var statearr_26307_26495 = state_26253__$1;
(statearr_26307_26495[(2)] = null);

(statearr_26307_26495[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (32))){
var inst_25992 = (state_26253[(16)]);
var inst_26226 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26308 = state_26253;
(statearr_26308[(28)] = inst_26226);

return statearr_26308;
})();
if(cljs.core.truth_(inst_25992)){
var statearr_26309_26496 = state_26253__$1;
(statearr_26309_26496[(1)] = (122));

} else {
var statearr_26310_26497 = state_26253__$1;
(statearr_26310_26497[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (40))){
var inst_25946 = (state_26253[(18)]);
var inst_26011 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26311 = state_26253;
(statearr_26311[(29)] = inst_26011);

return statearr_26311;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26312_26498 = state_26253__$1;
(statearr_26312_26498[(1)] = (41));

} else {
var statearr_26313_26499 = state_26253__$1;
(statearr_26313_26499[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (129))){
var inst_26234 = (state_26253[(30)]);
var state_26253__$1 = state_26253;
var statearr_26314_26500 = state_26253__$1;
(statearr_26314_26500[(2)] = inst_26234);

(statearr_26314_26500[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (91))){
var inst_26137 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_26253__$1 = state_26253;
var statearr_26315_26501 = state_26253__$1;
(statearr_26315_26501[(2)] = inst_26137);

(statearr_26315_26501[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (117))){
var inst_25949 = (state_26253[(15)]);
var state_26253__$1 = state_26253;
var statearr_26316_26502 = state_26253__$1;
(statearr_26316_26502[(2)] = inst_25949);

(statearr_26316_26502[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (108))){
var inst_26176 = (state_26253[(2)]);
var inst_26177 = fluree.db.util.async.throw_err(inst_26176);
var state_26253__$1 = state_26253;
var statearr_26317_26503 = state_26253__$1;
(statearr_26317_26503[(2)] = inst_26177);

(statearr_26317_26503[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (56))){
var inst_26044 = cljs.core.PersistentHashMap.EMPTY;
var state_26253__$1 = state_26253;
var statearr_26318_26504 = state_26253__$1;
(statearr_26318_26504[(2)] = inst_26044);

(statearr_26318_26504[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (33))){
var state_26253__$1 = state_26253;
var statearr_26319_26505 = state_26253__$1;
(statearr_26319_26505[(2)] = from);

(statearr_26319_26505[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (13))){
var inst_25933 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25934 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25935 = cljs.core.PersistentHashMap.fromArrays(inst_25933,inst_25934);
var inst_25936 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25935);
var inst_25937 = (function(){throw inst_25936})();
var state_26253__$1 = state_26253;
var statearr_26320_26506 = state_26253__$1;
(statearr_26320_26506[(2)] = inst_25937);

(statearr_26320_26506[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (22))){
var inst_25946 = (state_26253[(18)]);
var inst_25969 = typeof inst_25946 === 'string';
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_25969)){
var statearr_26321_26507 = state_26253__$1;
(statearr_26321_26507[(1)] = (24));

} else {
var statearr_26322_26508 = state_26253__$1;
(statearr_26322_26508[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (90))){
var inst_26128 = (state_26253[(31)]);
var inst_26133 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26323 = state_26253;
(statearr_26323[(32)] = inst_26133);

return statearr_26323;
})();
var statearr_26324_26509 = state_26253__$1;
(statearr_26324_26509[(2)] = inst_26128);

(statearr_26324_26509[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (109))){
var inst_26179 = (state_26253[(23)]);
var inst_26155 = (state_26253[(10)]);
var inst_26181 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26155,inst_26179);
var state_26253__$1 = state_26253;
var statearr_26325_26510 = state_26253__$1;
(statearr_26325_26510[(2)] = inst_26181);

(statearr_26325_26510[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (36))){
var inst_25946 = (state_26253[(18)]);
var inst_26006 = (state_26253[(2)]);
var inst_26007 = fluree.db.util.async.throw_err(inst_26006);
var state_26253__$1 = (function (){var statearr_26326 = state_26253;
(statearr_26326[(33)] = inst_26007);

return statearr_26326;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26327_26511 = state_26253__$1;
(statearr_26327_26511[(1)] = (38));

} else {
var statearr_26328_26512 = state_26253__$1;
(statearr_26328_26512[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (41))){
var state_26253__$1 = state_26253;
var statearr_26329_26513 = state_26253__$1;
(statearr_26329_26513[(2)] = null);

(statearr_26329_26513[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (118))){
var inst_25959 = (state_26253[(7)]);
var inst_26191 = (state_26253[(34)]);
var inst_26195 = (state_26253[(35)]);
var inst_25957 = (state_26253[(8)]);
var inst_26199 = (state_26253[(2)]);
var inst_26200 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25959,fuel,max_fuel,inst_25957,inst_26191,inst_26195,inst_26199);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(112),inst_26200);
} else {
if((state_val_26254 === (89))){
var state_26253__$1 = state_26253;
var statearr_26330_26514 = state_26253__$1;
(statearr_26330_26514[(2)] = null);

(statearr_26330_26514[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (100))){
var inst_26161 = (state_26253[(19)]);
var inst_26166 = cljs.core.int_QMARK_(inst_26161);
var state_26253__$1 = state_26253;
if(inst_26166){
var statearr_26331_26515 = state_26253__$1;
(statearr_26331_26515[(1)] = (102));

} else {
var statearr_26332_26516 = state_26253__$1;
(statearr_26332_26516[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (131))){
var inst_26231 = (state_26253[(11)]);
var inst_26245 = cljs.core.first(inst_26231);
var state_26253__$1 = state_26253;
var statearr_26333_26517 = state_26253__$1;
(statearr_26333_26517[(2)] = inst_26245);

(statearr_26333_26517[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (122))){
var inst_25947 = (state_26253[(13)]);
var inst_25992 = (state_26253[(16)]);
var inst_25993 = (state_26253[(17)]);
var inst_25949 = (state_26253[(15)]);
var inst_26226 = (state_26253[(28)]);
var inst_26228 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25992,inst_25993,inst_25949,inst_25947,inst_26226);
var state_26253__$1 = state_26253;
var statearr_26334_26518 = state_26253__$1;
(statearr_26334_26518[(2)] = inst_26228);

(statearr_26334_26518[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (43))){
var inst_25959 = (state_26253[(7)]);
var inst_25957 = (state_26253[(8)]);
var inst_26007 = (state_26253[(33)]);
var inst_26011 = (state_26253[(29)]);
var inst_26015 = (state_26253[(2)]);
var inst_26016 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25959,fuel,max_fuel,inst_25957,inst_26007,inst_26011,inst_26015);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(37),inst_26016);
} else {
if((state_val_26254 === (61))){
var inst_26066 = ["_tx",null,"_block",null];
var inst_26067 = (new cljs.core.PersistentArrayMap(null,2,inst_26066,null));
var inst_26068 = (new cljs.core.PersistentHashSet(null,inst_26067,null));
var inst_26069 = (inst_26068.cljs$core$IFn$_invoke$arity$1 ? inst_26068.cljs$core$IFn$_invoke$arity$1(from) : inst_26068.call(null,from));
var state_26253__$1 = state_26253;
var statearr_26335_26519 = state_26253__$1;
(statearr_26335_26519[(2)] = inst_26069);

(statearr_26335_26519[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (29))){
var inst_25981 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26336_26520 = state_26253__$1;
(statearr_26336_26520[(2)] = inst_25981);

(statearr_26336_26520[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (44))){
var inst_26023 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_26024 = clojure.string.includes_QMARK_(inst_26023,"/");
var state_26253__$1 = state_26253;
var statearr_26337_26521 = state_26253__$1;
(statearr_26337_26521[(2)] = inst_26024);

(statearr_26337_26521[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (93))){
var inst_26140 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_26140)){
var statearr_26338_26522 = state_26253__$1;
(statearr_26338_26522[(1)] = (94));

} else {
var statearr_26339_26523 = state_26253__$1;
(statearr_26339_26523[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (6))){
var inst_25924 = (state_26253[(36)]);
var state_26253__$1 = state_26253;
var statearr_26340_26524 = state_26253__$1;
(statearr_26340_26524[(2)] = inst_25924);

(statearr_26340_26524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (111))){
var inst_26162 = (state_26253[(37)]);
var inst_26184 = (state_26253[(2)]);
var inst_26154 = inst_26162;
var inst_26155 = inst_26184;
var state_26253__$1 = (function (){var statearr_26341 = state_26253;
(statearr_26341[(10)] = inst_26155);

(statearr_26341[(38)] = inst_26154);

return statearr_26341;
})();
var statearr_26342_26525 = state_26253__$1;
(statearr_26342_26525[(2)] = null);

(statearr_26342_26525[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (28))){
var state_26253__$1 = state_26253;
var statearr_26343_26526 = state_26253__$1;
(statearr_26343_26526[(2)] = null);

(statearr_26343_26526[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (64))){
var inst_25946 = (state_26253[(18)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_25946)){
var statearr_26344_26527 = state_26253__$1;
(statearr_26344_26527[(1)] = (67));

} else {
var statearr_26345_26528 = state_26253__$1;
(statearr_26345_26528[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (103))){
var state_26253__$1 = state_26253;
if(cljs.core.truth_(fuel)){
var statearr_26346_26529 = state_26253__$1;
(statearr_26346_26529[(1)] = (105));

} else {
var statearr_26347_26530 = state_26253__$1;
(statearr_26347_26530[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (51))){
var inst_26030 = (state_26253[(26)]);
var state_26253__$1 = state_26253;
var statearr_26348_26531 = state_26253__$1;
(statearr_26348_26531[(2)] = inst_26030);

(statearr_26348_26531[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (25))){
var state_26253__$1 = state_26253;
var statearr_26349_26532 = state_26253__$1;
(statearr_26349_26532[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (34))){
var state_26253__$1 = state_26253;
var statearr_26351_26533 = state_26253__$1;
(statearr_26351_26533[(2)] = null);

(statearr_26351_26533[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (125))){
var inst_26231 = (state_26253[(11)]);
var inst_26234 = (state_26253[(30)]);
var inst_26234__$1 = cljs.core.coll_QMARK_(inst_26231);
var state_26253__$1 = (function (){var statearr_26352 = state_26253;
(statearr_26352[(30)] = inst_26234__$1);

return statearr_26352;
})();
if(inst_26234__$1){
var statearr_26353_26534 = state_26253__$1;
(statearr_26353_26534[(1)] = (128));

} else {
var statearr_26354_26535 = state_26253__$1;
(statearr_26354_26535[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (17))){
var inst_25946 = (state_26253[(18)]);
var inst_25957 = (state_26253[(2)]);
var inst_25958 = cljs.core.PersistentHashMap.EMPTY;
var inst_25959 = cljs.core.volatile_BANG_(inst_25958);
var state_26253__$1 = (function (){var statearr_26355 = state_26253;
(statearr_26355[(7)] = inst_25959);

(statearr_26355[(8)] = inst_25957);

return statearr_26355;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26356_26536 = state_26253__$1;
(statearr_26356_26536[(1)] = (18));

} else {
var statearr_26357_26537 = state_26253__$1;
(statearr_26357_26537[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (3))){
var inst_26251 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26253__$1,inst_26251);
} else {
if((state_val_26254 === (12))){
var inst_25930 = (state_26253[(39)]);
var state_26253__$1 = state_26253;
var statearr_26358_26538 = state_26253__$1;
(statearr_26358_26538[(2)] = inst_25930);

(statearr_26358_26538[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (2))){
var inst_25924 = (state_26253[(36)]);
var _ = (function (){var statearr_26359 = state_26253;
(statearr_26359[(4)] = cljs.core.cons((5),(state_26253[(4)])));

return statearr_26359;
})();
var inst_25924__$1 = select;
var state_26253__$1 = (function (){var statearr_26360 = state_26253;
(statearr_26360[(36)] = inst_25924__$1);

return statearr_26360;
})();
if(cljs.core.truth_(inst_25924__$1)){
var statearr_26361_26539 = state_26253__$1;
(statearr_26361_26539[(1)] = (6));

} else {
var statearr_26362_26540 = state_26253__$1;
(statearr_26362_26540[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (66))){
var inst_26222 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26363_26541 = state_26253__$1;
(statearr_26363_26541[(2)] = inst_26222);

(statearr_26363_26541[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (107))){
var inst_26161 = (state_26253[(19)]);
var inst_26173 = (state_26253[(2)]);
var inst_26174 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_26161,false);
var state_26253__$1 = (function (){var statearr_26364 = state_26253;
(statearr_26364[(40)] = inst_26173);

return statearr_26364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(108),inst_26174);
} else {
if((state_val_26254 === (23))){
var inst_25985 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26365_26542 = state_26253__$1;
(statearr_26365_26542[(2)] = inst_25985);

(statearr_26365_26542[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (47))){
var inst_26030 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_26253__$1 = (function (){var statearr_26366 = state_26253;
(statearr_26366[(26)] = inst_26030);

return statearr_26366;
})();
if(cljs.core.truth_(fuel)){
var statearr_26367_26543 = state_26253__$1;
(statearr_26367_26543[(1)] = (50));

} else {
var statearr_26368_26544 = state_26253__$1;
(statearr_26368_26544[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (35))){
var inst_25947 = (state_26253[(13)]);
var inst_25949 = (state_26253[(15)]);
var inst_26000 = (state_26253[(2)]);
var inst_26001 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26002 = [inst_25947,inst_25949];
var inst_26003 = cljs.core.PersistentHashMap.fromArrays(inst_26001,inst_26002);
var inst_26004 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_26000,inst_26003);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(36),inst_26004);
} else {
if((state_val_26254 === (127))){
var inst_26243 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_26243)){
var statearr_26369_26545 = state_26253__$1;
(statearr_26369_26545[(1)] = (131));

} else {
var statearr_26370_26546 = state_26253__$1;
(statearr_26370_26546[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (82))){
var inst_26218 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26371_26547 = state_26253__$1;
(statearr_26371_26547[(2)] = inst_26218);

(statearr_26371_26547[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (76))){
var inst_25947 = (state_26253[(13)]);
var inst_25949 = (state_26253[(15)]);
var inst_26096 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26097 = [inst_25947,inst_25949];
var inst_26098 = cljs.core.PersistentHashMap.fromArrays(inst_26096,inst_26097);
var state_26253__$1 = state_26253;
var statearr_26372_26548 = state_26253__$1;
(statearr_26372_26548[(2)] = inst_26098);

(statearr_26372_26548[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (97))){
var inst_26161 = (state_26253[(19)]);
var inst_26154 = (state_26253[(38)]);
var inst_26160 = cljs.core.seq(inst_26154);
var inst_26161__$1 = cljs.core.first(inst_26160);
var inst_26162 = cljs.core.next(inst_26160);
var inst_26163 = cljs.core.not(inst_26161__$1);
var state_26253__$1 = (function (){var statearr_26373 = state_26253;
(statearr_26373[(19)] = inst_26161__$1);

(statearr_26373[(37)] = inst_26162);

return statearr_26373;
})();
if(inst_26163){
var statearr_26374_26549 = state_26253__$1;
(statearr_26374_26549[(1)] = (99));

} else {
var statearr_26375_26550 = state_26253__$1;
(statearr_26375_26550[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (19))){
var inst_25987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25988 = [null,null];
var inst_25989 = (new cljs.core.PersistentVector(null,2,(5),inst_25987,inst_25988,null));
var state_26253__$1 = state_26253;
var statearr_26376_26551 = state_26253__$1;
(statearr_26376_26551[(2)] = inst_25989);

(statearr_26376_26551[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (57))){
var inst_25947 = (state_26253[(13)]);
var inst_25949 = (state_26253[(15)]);
var inst_26046 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26047 = [inst_25947,inst_25949];
var inst_26048 = cljs.core.PersistentHashMap.fromArrays(inst_26046,inst_26047);
var state_26253__$1 = state_26253;
var statearr_26377_26552 = state_26253__$1;
(statearr_26377_26552[(2)] = inst_26048);

(statearr_26377_26552[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (68))){
var inst_25947 = (state_26253[(13)]);
var inst_25949 = (state_26253[(15)]);
var inst_26077 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_26078 = [inst_25947,inst_25949];
var inst_26079 = cljs.core.PersistentHashMap.fromArrays(inst_26077,inst_26078);
var state_26253__$1 = state_26253;
var statearr_26378_26553 = state_26253__$1;
(statearr_26378_26553[(2)] = inst_26079);

(statearr_26378_26553[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (11))){
var inst_25941 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26379_26554 = state_26253__$1;
(statearr_26379_26554[(2)] = inst_25941);

(statearr_26379_26554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (115))){
var inst_25946 = (state_26253[(18)]);
var inst_26195 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26381 = state_26253;
(statearr_26381[(35)] = inst_26195);

return statearr_26381;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26382_26555 = state_26253__$1;
(statearr_26382_26555[(1)] = (116));

} else {
var statearr_26383_26556 = state_26253__$1;
(statearr_26383_26556[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (9))){
var inst_25927 = (state_26253[(12)]);
var state_26253__$1 = state_26253;
var statearr_26384_26557 = state_26253__$1;
(statearr_26384_26557[(2)] = inst_25927);

(statearr_26384_26557[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (5))){
var _ = (function (){var statearr_26385 = state_26253;
(statearr_26385[(4)] = cljs.core.rest((state_26253[(4)])));

return statearr_26385;
})();
var state_26253__$1 = state_26253;
var ex26380 = (state_26253__$1[(2)]);
var statearr_26386_26558 = state_26253__$1;
(statearr_26386_26558[(5)] = ex26380);


if((ex26380 instanceof Error)){
var statearr_26387_26559 = state_26253__$1;
(statearr_26387_26559[(1)] = (4));

(statearr_26387_26559[(5)] = null);

} else {
throw ex26380;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (112))){
var inst_26202 = (state_26253[(2)]);
var inst_26203 = fluree.db.util.async.throw_err(inst_26202);
var state_26253__$1 = state_26253;
var statearr_26388_26560 = state_26253__$1;
(statearr_26388_26560[(2)] = inst_26203);

(statearr_26388_26560[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (83))){
var inst_26116 = (state_26253[(20)]);
var inst_26115 = (state_26253[(2)]);
var inst_26116__$1 = fluree.db.util.async.throw_err(inst_26115);
var inst_26117 = (inst_26116__$1 == null);
var state_26253__$1 = (function (){var statearr_26389 = state_26253;
(statearr_26389[(20)] = inst_26116__$1);

return statearr_26389;
})();
if(cljs.core.truth_(inst_26117)){
var statearr_26390_26561 = state_26253__$1;
(statearr_26390_26561[(1)] = (84));

} else {
var statearr_26391_26562 = state_26253__$1;
(statearr_26391_26562[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (14))){
var inst_25939 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26392_26563 = state_26253__$1;
(statearr_26392_26563[(2)] = inst_25939);

(statearr_26392_26563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (45))){
var inst_26021 = (state_26253[(27)]);
var state_26253__$1 = state_26253;
var statearr_26393_26564 = state_26253__$1;
(statearr_26393_26564[(2)] = inst_26021);

(statearr_26393_26564[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (53))){
var inst_26036 = (state_26253[(21)]);
var inst_26038 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_26039 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_26036,inst_26038);
var state_26253__$1 = state_26253;
var statearr_26394_26565 = state_26253__$1;
(statearr_26394_26565[(2)] = inst_26039);

(statearr_26394_26565[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (78))){
var inst_25959 = (state_26253[(7)]);
var inst_25957 = (state_26253[(8)]);
var inst_26103 = (state_26253[(2)]);
var inst_26104 = fluree.db.util.async.throw_err(inst_26103);
var inst_26105 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25959,fuel,max_fuel,inst_25957,inst_26104);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(79),inst_26105);
} else {
if((state_val_26254 === (132))){
var inst_26231 = (state_26253[(11)]);
var state_26253__$1 = state_26253;
var statearr_26395_26566 = state_26253__$1;
(statearr_26395_26566[(2)] = inst_26231);

(statearr_26395_26566[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (26))){
var inst_25983 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26396_26567 = state_26253__$1;
(statearr_26396_26567[(2)] = inst_25983);

(statearr_26396_26567[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (123))){
var inst_26226 = (state_26253[(28)]);
var state_26253__$1 = state_26253;
var statearr_26397_26568 = state_26253__$1;
(statearr_26397_26568[(2)] = inst_26226);

(statearr_26397_26568[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (16))){
var inst_25950 = (state_26253[(25)]);
var state_26253__$1 = state_26253;
var statearr_26398_26569 = state_26253__$1;
(statearr_26398_26569[(2)] = inst_25950);

(statearr_26398_26569[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (133))){
var inst_26248 = (state_26253[(2)]);
var _ = (function (){var statearr_26399 = state_26253;
(statearr_26399[(4)] = cljs.core.rest((state_26253[(4)])));

return statearr_26399;
})();
var state_26253__$1 = state_26253;
var statearr_26400_26570 = state_26253__$1;
(statearr_26400_26570[(2)] = inst_26248);

(statearr_26400_26570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (81))){
var inst_26135 = (state_26253[(22)]);
var inst_26135__$1 = cljs.core.sequential_QMARK_(from);
var state_26253__$1 = (function (){var statearr_26401 = state_26253;
(statearr_26401[(22)] = inst_26135__$1);

return statearr_26401;
})();
if(inst_26135__$1){
var statearr_26402_26571 = state_26253__$1;
(statearr_26402_26571[(1)] = (91));

} else {
var statearr_26403_26572 = state_26253__$1;
(statearr_26403_26572[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (120))){
var state_26253__$1 = state_26253;
var statearr_26404_26573 = state_26253__$1;
(statearr_26404_26573[(2)] = null);

(statearr_26404_26573[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (79))){
var inst_26107 = (state_26253[(2)]);
var inst_26108 = fluree.db.util.async.throw_err(inst_26107);
var state_26253__$1 = state_26253;
var statearr_26405_26574 = state_26253__$1;
(statearr_26405_26574[(2)] = inst_26108);

(statearr_26405_26574[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (38))){
var state_26253__$1 = state_26253;
var statearr_26406_26575 = state_26253__$1;
(statearr_26406_26575[(2)] = null);

(statearr_26406_26575[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (126))){
var inst_26232 = (state_26253[(41)]);
var state_26253__$1 = state_26253;
var statearr_26407_26576 = state_26253__$1;
(statearr_26407_26576[(2)] = inst_26232);

(statearr_26407_26576[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (98))){
var inst_25946 = (state_26253[(18)]);
var inst_26189 = (state_26253[(2)]);
var inst_26190 = cljs.core.PersistentVector.EMPTY;
var inst_26191 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26190,inst_26189);
var state_26253__$1 = (function (){var statearr_26408 = state_26253;
(statearr_26408[(34)] = inst_26191);

return statearr_26408;
})();
if(cljs.core.truth_(inst_25946)){
var statearr_26409_26577 = state_26253__$1;
(statearr_26409_26577[(1)] = (113));

} else {
var statearr_26410_26578 = state_26253__$1;
(statearr_26410_26578[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (124))){
var inst_26232 = (state_26253[(41)]);
var inst_26231 = (state_26253[(2)]);
var inst_26232__$1 = selectOne;
var state_26253__$1 = (function (){var statearr_26411 = state_26253;
(statearr_26411[(11)] = inst_26231);

(statearr_26411[(41)] = inst_26232__$1);

return statearr_26411;
})();
if(cljs.core.truth_(inst_26232__$1)){
var statearr_26412_26579 = state_26253__$1;
(statearr_26412_26579[(1)] = (125));

} else {
var statearr_26413_26580 = state_26253__$1;
(statearr_26413_26580[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (87))){
var inst_26127 = (state_26253[(2)]);
var inst_26128 = fluree.db.util.async.throw_err(inst_26127);
var state_26253__$1 = (function (){var statearr_26414 = state_26253;
(statearr_26414[(31)] = inst_26128);

return statearr_26414;
})();
if(cljs.core.truth_(fuel)){
var statearr_26415_26581 = state_26253__$1;
(statearr_26415_26581[(1)] = (88));

} else {
var statearr_26416_26582 = state_26253__$1;
(statearr_26416_26582[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (30))){
var inst_25996 = typeof from === 'string';
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_25996)){
var statearr_26417_26583 = state_26253__$1;
(statearr_26417_26583[(1)] = (33));

} else {
var statearr_26418_26584 = state_26253__$1;
(statearr_26418_26584[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (73))){
var inst_26110 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_26253__$1 = state_26253;
if(inst_26110){
var statearr_26419_26585 = state_26253__$1;
(statearr_26419_26585[(1)] = (80));

} else {
var statearr_26420_26586 = state_26253__$1;
(statearr_26420_26586[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (96))){
var inst_26216 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26421_26587 = state_26253__$1;
(statearr_26421_26587[(2)] = inst_26216);

(statearr_26421_26587[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (10))){
var inst_25930 = (state_26253[(39)]);
var inst_25930__$1 = selectDistinct;
var state_26253__$1 = (function (){var statearr_26422 = state_26253;
(statearr_26422[(39)] = inst_25930__$1);

return statearr_26422;
})();
if(cljs.core.truth_(inst_25930__$1)){
var statearr_26423_26588 = state_26253__$1;
(statearr_26423_26588[(1)] = (12));

} else {
var statearr_26424_26589 = state_26253__$1;
(statearr_26424_26589[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (18))){
var inst_25946 = (state_26253[(18)]);
var inst_25961 = cljs.core.vector_QMARK_(inst_25946);
var state_26253__$1 = state_26253;
if(inst_25961){
var statearr_26425_26590 = state_26253__$1;
(statearr_26425_26590[(1)] = (21));

} else {
var statearr_26426_26591 = state_26253__$1;
(statearr_26426_26591[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (105))){
var inst_26170 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_26253__$1 = state_26253;
var statearr_26427_26592 = state_26253__$1;
(statearr_26427_26592[(2)] = inst_26170);

(statearr_26427_26592[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (52))){
var inst_26036 = (state_26253[(2)]);
var state_26253__$1 = (function (){var statearr_26428 = state_26253;
(statearr_26428[(21)] = inst_26036);

return statearr_26428;
})();
var statearr_26429_26593 = state_26253__$1;
(statearr_26429_26593[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (114))){
var inst_25947 = (state_26253[(13)]);
var state_26253__$1 = state_26253;
var statearr_26431_26594 = state_26253__$1;
(statearr_26431_26594[(2)] = inst_25947);

(statearr_26431_26594[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (67))){
var inst_26075 = cljs.core.PersistentHashMap.EMPTY;
var state_26253__$1 = state_26253;
var statearr_26432_26595 = state_26253__$1;
(statearr_26432_26595[(2)] = inst_26075);

(statearr_26432_26595[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (71))){
var inst_26088 = (state_26253[(2)]);
var inst_26089 = fluree.db.util.async.throw_err(inst_26088);
var state_26253__$1 = state_26253;
var statearr_26433_26596 = state_26253__$1;
(statearr_26433_26596[(2)] = inst_26089);

(statearr_26433_26596[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (42))){
var inst_25949 = (state_26253[(15)]);
var state_26253__$1 = state_26253;
var statearr_26434_26597 = state_26253__$1;
(statearr_26434_26597[(2)] = inst_25949);

(statearr_26434_26597[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (80))){
var inst_26113 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_26253__$1 = state_26253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26253__$1,(83),inst_26113);
} else {
if((state_val_26254 === (37))){
var inst_26018 = (state_26253[(2)]);
var inst_26019 = fluree.db.util.async.throw_err(inst_26018);
var state_26253__$1 = state_26253;
var statearr_26435_26598 = state_26253__$1;
(statearr_26435_26598[(2)] = inst_26019);

(statearr_26435_26598[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (63))){
var inst_26072 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
if(cljs.core.truth_(inst_26072)){
var statearr_26436_26599 = state_26253__$1;
(statearr_26436_26599[(1)] = (64));

} else {
var statearr_26437_26600 = state_26253__$1;
(statearr_26437_26600[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (94))){
var inst_26149 = from;
var inst_26150 = cljs.core.seq(inst_26149);
var inst_26151 = cljs.core.first(inst_26150);
var inst_26152 = cljs.core.next(inst_26150);
var inst_26153 = cljs.core.PersistentVector.EMPTY;
var inst_26154 = inst_26149;
var inst_26155 = inst_26153;
var state_26253__$1 = (function (){var statearr_26438 = state_26253;
(statearr_26438[(42)] = inst_26152);

(statearr_26438[(43)] = inst_26151);

(statearr_26438[(10)] = inst_26155);

(statearr_26438[(38)] = inst_26154);

return statearr_26438;
})();
var statearr_26439_26601 = state_26253__$1;
(statearr_26439_26601[(2)] = null);

(statearr_26439_26601[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (8))){
var inst_25948 = (state_26253[(24)]);
var inst_25943 = (state_26253[(2)]);
var inst_25944 = opts_SINGLEQUOTE_;
var inst_25945 = cljs.core.__destructure_map(inst_25944);
var inst_25946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25945,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25945,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25948__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25945,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25945,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25950 = fluree.db.query.fql_parser.parse_db(db,inst_25943,opts_SINGLEQUOTE_);
var inst_25951 = (inst_25948__$1 == null);
var inst_25952 = cljs.core.not(inst_25951);
var state_26253__$1 = (function (){var statearr_26440 = state_26253;
(statearr_26440[(13)] = inst_25947);

(statearr_26440[(18)] = inst_25946);

(statearr_26440[(24)] = inst_25948__$1);

(statearr_26440[(15)] = inst_25949);

(statearr_26440[(25)] = inst_25950);

return statearr_26440;
})();
if(inst_25952){
var statearr_26441_26602 = state_26253__$1;
(statearr_26441_26602[(1)] = (15));

} else {
var statearr_26442_26603 = state_26253__$1;
(statearr_26442_26603[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (49))){
var inst_26224 = (state_26253[(2)]);
var state_26253__$1 = state_26253;
var statearr_26443_26604 = state_26253__$1;
(statearr_26443_26604[(2)] = inst_26224);

(statearr_26443_26604[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26254 === (84))){
var state_26253__$1 = state_26253;
var statearr_26444_26605 = state_26253__$1;
(statearr_26444_26605[(2)] = null);

(statearr_26444_26605[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2741__auto____0 = (function (){
var statearr_26445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26445[(0)] = fluree$db$query$fql$query_$_state_machine__2741__auto__);

(statearr_26445[(1)] = (1));

return statearr_26445;
});
var fluree$db$query$fql$query_$_state_machine__2741__auto____1 = (function (state_26253){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_26253);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26446){var ex__2744__auto__ = e26446;
var statearr_26447_26606 = state_26253;
(statearr_26447_26606[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_26253[(4)]))){
var statearr_26448_26607 = state_26253;
(statearr_26448_26607[(1)] = cljs.core.first((state_26253[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26608 = state_26253;
state_26253 = G__26608;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2741__auto__ = function(state_26253){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2741__auto____1.call(this,state_26253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2741__auto____0;
fluree$db$query$fql$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2741__auto____1;
return fluree$db$query$fql$query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26449 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_26449[(6)] = c__2763__auto__);

return statearr_26449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}

});
