// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61435_61604 = cljs.core.seq(servers);
var chunk__61436_61605 = null;
var count__61437_61606 = (0);
var i__61438_61607 = (0);
while(true){
if((i__61438_61607 < count__61437_61606)){
var server_61608 = chunk__61436_61605.cljs$core$IIndexed$_nth$arity$2(null,i__61438_61607);
var healthcheck_uri_61609 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61608),"/fdb/health"].join('');
var resp_chan_61610 = fluree.db.util.xhttp.post_json(healthcheck_uri_61609,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61611 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608){
return (function (state_61499){
var state_val_61500 = (state_61499[(1)]);
if((state_val_61500 === (1))){
var state_61499__$1 = state_61499;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61499__$1,(2),resp_chan_61610);
} else {
if((state_val_61500 === (2))){
var inst_61488 = (state_61499[(7)]);
var inst_61488__$1 = (state_61499[(2)]);
var inst_61489 = fluree.db.util.core.exception_QMARK_(inst_61488__$1);
var state_61499__$1 = (function (){var statearr_61501 = state_61499;
(statearr_61501[(7)] = inst_61488__$1);

return statearr_61501;
})();
if(inst_61489){
var statearr_61502_61612 = state_61499__$1;
(statearr_61502_61612[(1)] = (3));

} else {
var statearr_61503_61613 = state_61499__$1;
(statearr_61503_61613[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61500 === (3))){
var inst_61488 = (state_61499[(7)]);
var inst_61491 = cljs.core.ex_message(inst_61488);
var inst_61492 = cljs.core.ex_data(inst_61488);
var inst_61493 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61491,inst_61492], 0));
var state_61499__$1 = state_61499;
var statearr_61504_61614 = state_61499__$1;
(statearr_61504_61614[(2)] = inst_61493);

(statearr_61504_61614[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61500 === (4))){
var inst_61495 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61608);
var state_61499__$1 = state_61499;
var statearr_61505_61615 = state_61499__$1;
(statearr_61505_61615[(2)] = inst_61495);

(statearr_61505_61615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61500 === (5))){
var inst_61497 = (state_61499[(2)]);
var state_61499__$1 = state_61499;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61499__$1,inst_61497);
} else {
return null;
}
}
}
}
}
});})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608))
;
return ((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,switch__2740__auto__,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61506 = [null,null,null,null,null,null,null,null];
(statearr_61506[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61506[(1)] = (1));

return statearr_61506;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61499){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61499);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61507){var ex__2744__auto__ = e61507;
var statearr_61508_61616 = state_61499;
(statearr_61508_61616[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61499[(4)]))){
var statearr_61509_61617 = state_61499;
(statearr_61509_61617[(1)] = cljs.core.first((state_61499[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61618 = state_61499;
state_61499 = G__61618;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61499){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,switch__2740__auto__,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608))
})();
var state__2765__auto__ = (function (){var statearr_61510 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61510[(6)] = c__2763__auto___61611);

return statearr_61510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61611,healthcheck_uri_61609,resp_chan_61610,server_61608))
);



var G__61619 = seq__61435_61604;
var G__61620 = chunk__61436_61605;
var G__61621 = count__61437_61606;
var G__61622 = (i__61438_61607 + (1));
seq__61435_61604 = G__61619;
chunk__61436_61605 = G__61620;
count__61437_61606 = G__61621;
i__61438_61607 = G__61622;
continue;
} else {
var temp__5753__auto___61623 = cljs.core.seq(seq__61435_61604);
if(temp__5753__auto___61623){
var seq__61435_61624__$1 = temp__5753__auto___61623;
if(cljs.core.chunked_seq_QMARK_(seq__61435_61624__$1)){
var c__4679__auto___61625 = cljs.core.chunk_first(seq__61435_61624__$1);
var G__61626 = cljs.core.chunk_rest(seq__61435_61624__$1);
var G__61627 = c__4679__auto___61625;
var G__61628 = cljs.core.count(c__4679__auto___61625);
var G__61629 = (0);
seq__61435_61604 = G__61626;
chunk__61436_61605 = G__61627;
count__61437_61606 = G__61628;
i__61438_61607 = G__61629;
continue;
} else {
var server_61630 = cljs.core.first(seq__61435_61624__$1);
var healthcheck_uri_61631 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61630),"/fdb/health"].join('');
var resp_chan_61632 = fluree.db.util.xhttp.post_json(healthcheck_uri_61631,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61633 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623){
return (function (state_61523){
var state_val_61524 = (state_61523[(1)]);
if((state_val_61524 === (1))){
var state_61523__$1 = state_61523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61523__$1,(2),resp_chan_61632);
} else {
if((state_val_61524 === (2))){
var inst_61512 = (state_61523[(7)]);
var inst_61512__$1 = (state_61523[(2)]);
var inst_61513 = fluree.db.util.core.exception_QMARK_(inst_61512__$1);
var state_61523__$1 = (function (){var statearr_61525 = state_61523;
(statearr_61525[(7)] = inst_61512__$1);

return statearr_61525;
})();
if(inst_61513){
var statearr_61526_61634 = state_61523__$1;
(statearr_61526_61634[(1)] = (3));

} else {
var statearr_61527_61635 = state_61523__$1;
(statearr_61527_61635[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61524 === (3))){
var inst_61512 = (state_61523[(7)]);
var inst_61515 = cljs.core.ex_message(inst_61512);
var inst_61516 = cljs.core.ex_data(inst_61512);
var inst_61517 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_61515,inst_61516], 0));
var state_61523__$1 = state_61523;
var statearr_61528_61636 = state_61523__$1;
(statearr_61528_61636[(2)] = inst_61517);

(statearr_61528_61636[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61524 === (4))){
var inst_61519 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_61630);
var state_61523__$1 = state_61523;
var statearr_61529_61637 = state_61523__$1;
(statearr_61529_61637[(2)] = inst_61519);

(statearr_61529_61637[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61524 === (5))){
var inst_61521 = (state_61523[(2)]);
var state_61523__$1 = state_61523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61523__$1,inst_61521);
} else {
return null;
}
}
}
}
}
});})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623))
;
return ((function (seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,switch__2740__auto__,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61530 = [null,null,null,null,null,null,null,null];
(statearr_61530[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61530[(1)] = (1));

return statearr_61530;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61523){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61523);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61531){var ex__2744__auto__ = e61531;
var statearr_61532_61638 = state_61523;
(statearr_61532_61638[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61523[(4)]))){
var statearr_61533_61639 = state_61523;
(statearr_61533_61639[(1)] = cljs.core.first((state_61523[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61640 = state_61523;
state_61523 = G__61640;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61523){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,switch__2740__auto__,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623))
})();
var state__2765__auto__ = (function (){var statearr_61534 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61534[(6)] = c__2763__auto___61633);

return statearr_61534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});})(seq__61435_61604,chunk__61436_61605,count__61437_61606,i__61438_61607,c__2763__auto___61633,healthcheck_uri_61631,resp_chan_61632,server_61630,seq__61435_61624__$1,temp__5753__auto___61623))
);



var G__61641 = cljs.core.next(seq__61435_61624__$1);
var G__61642 = null;
var G__61643 = (0);
var G__61644 = (0);
seq__61435_61604 = G__61641;
chunk__61436_61605 = G__61642;
count__61437_61606 = G__61643;
i__61438_61607 = G__61644;
continue;
}
} else {
}
}
break;
}

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61578){
var state_val_61579 = (state_61578[(1)]);
if((state_val_61579 === (7))){
var inst_61550 = (state_61578[(7)]);
var inst_61557 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61550,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61578__$1 = state_61578;
if(inst_61557){
var statearr_61580_61645 = state_61578__$1;
(statearr_61580_61645[(1)] = (9));

} else {
var statearr_61581_61646 = state_61578__$1;
(statearr_61581_61646[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (1))){
var inst_61542 = (state_61578[(8)]);
var inst_61543 = (state_61578[(9)]);
var inst_61542__$1 = promise_chan;
var inst_61543__$1 = cljs.core.async.timeout((60000));
var inst_61544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61545 = [inst_61542__$1,inst_61543__$1];
var inst_61546 = (new cljs.core.PersistentVector(null,2,(5),inst_61544,inst_61545,null));
var state_61578__$1 = (function (){var statearr_61582 = state_61578;
(statearr_61582[(8)] = inst_61542__$1);

(statearr_61582[(9)] = inst_61543__$1);

return statearr_61582;
})();
return cljs.core.async.ioc_alts_BANG_(state_61578__$1,(2),inst_61546);
} else {
if((state_val_61579 === (4))){
var inst_61550 = (state_61578[(7)]);
var inst_61543 = (state_61578[(9)]);
var inst_61554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61550,inst_61543);
var state_61578__$1 = state_61578;
if(inst_61554){
var statearr_61583_61647 = state_61578__$1;
(statearr_61583_61647[(1)] = (6));

} else {
var statearr_61584_61648 = state_61578__$1;
(statearr_61584_61648[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (13))){
var state_61578__$1 = state_61578;
var statearr_61585_61649 = state_61578__$1;
(statearr_61585_61649[(2)] = null);

(statearr_61585_61649[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (6))){
var state_61578__$1 = state_61578;
var statearr_61586_61650 = state_61578__$1;
(statearr_61586_61650[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61586_61650[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (3))){
var state_61578__$1 = state_61578;
var statearr_61587_61651 = state_61578__$1;
(statearr_61587_61651[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61587_61651[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (12))){
var inst_61568 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_61569 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61570 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61571 = cljs.core.PersistentHashMap.fromArrays(inst_61569,inst_61570);
var inst_61572 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_61571);
var inst_61573 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_61572);
var state_61578__$1 = (function (){var statearr_61588 = state_61578;
(statearr_61588[(10)] = inst_61568);

return statearr_61588;
})();
var statearr_61589_61652 = state_61578__$1;
(statearr_61589_61652[(2)] = inst_61573);

(statearr_61589_61652[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (2))){
var inst_61550 = (state_61578[(7)]);
var inst_61542 = (state_61578[(8)]);
var inst_61548 = (state_61578[(2)]);
var inst_61549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61548,(0),null);
var inst_61550__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61548,(1),null);
var inst_61551 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61550__$1,inst_61542);
var state_61578__$1 = (function (){var statearr_61590 = state_61578;
(statearr_61590[(7)] = inst_61550__$1);

(statearr_61590[(11)] = inst_61549);

return statearr_61590;
})();
if(inst_61551){
var statearr_61591_61653 = state_61578__$1;
(statearr_61591_61653[(1)] = (3));

} else {
var statearr_61592_61654 = state_61578__$1;
(statearr_61592_61654[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (11))){
var inst_61561 = (state_61578[(2)]);
var state_61578__$1 = state_61578;
var statearr_61593_61655 = state_61578__$1;
(statearr_61593_61655[(2)] = inst_61561);

(statearr_61593_61655[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (9))){
var inst_61549 = (state_61578[(11)]);
var state_61578__$1 = state_61578;
var statearr_61594_61656 = state_61578__$1;
(statearr_61594_61656[(2)] = inst_61549);

(statearr_61594_61656[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (5))){
var inst_61565 = (state_61578[(2)]);
var inst_61566 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61565);
var state_61578__$1 = state_61578;
if(inst_61566){
var statearr_61595_61657 = state_61578__$1;
(statearr_61595_61657[(1)] = (12));

} else {
var statearr_61596_61658 = state_61578__$1;
(statearr_61596_61658[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (14))){
var inst_61576 = (state_61578[(2)]);
var state_61578__$1 = state_61578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61578__$1,inst_61576);
} else {
if((state_val_61579 === (10))){
var state_61578__$1 = state_61578;
var statearr_61597_61659 = state_61578__$1;
(statearr_61597_61659[(2)] = null);

(statearr_61597_61659[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61579 === (8))){
var inst_61563 = (state_61578[(2)]);
var state_61578__$1 = state_61578;
var statearr_61598_61660 = state_61578__$1;
(statearr_61598_61660[(2)] = inst_61563);

(statearr_61598_61660[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61599 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61599[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61599[(1)] = (1));

return statearr_61599;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61578){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61578);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61600){var ex__2744__auto__ = e61600;
var statearr_61601_61661 = state_61578;
(statearr_61601_61661[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61578[(4)]))){
var statearr_61602_61662 = state_61578;
(statearr_61602_61662[(1)] = cljs.core.first((state_61578[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61663 = state_61578;
state_61578 = G__61663;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61578){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61603 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61603[(6)] = c__2763__auto__);

return statearr_61603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61707){
var state_val_61708 = (state_61707[(1)]);
if((state_val_61708 === (7))){
var state_61707__$1 = state_61707;
var statearr_61709_61735 = state_61707__$1;
(statearr_61709_61735[(2)] = null);

(statearr_61709_61735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (1))){
var state_61707__$1 = state_61707;
var statearr_61710_61736 = state_61707__$1;
(statearr_61710_61736[(2)] = null);

(statearr_61710_61736[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (4))){
var inst_61664 = (state_61707[(2)]);
var state_61707__$1 = state_61707;
var statearr_61711_61737 = state_61707__$1;
(statearr_61711_61737[(2)] = inst_61664);

(statearr_61711_61737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (6))){
var inst_61686 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_61707__$1 = state_61707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61707__$1,(9),inst_61686);
} else {
if((state_val_61708 === (3))){
var inst_61705 = (state_61707[(2)]);
var state_61707__$1 = state_61707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61707__$1,inst_61705);
} else {
if((state_val_61708 === (12))){
var inst_61699 = (state_61707[(2)]);
var state_61707__$1 = state_61707;
var statearr_61712_61738 = state_61707__$1;
(statearr_61712_61738[(2)] = inst_61699);

(statearr_61712_61738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (2))){
var inst_61675 = (state_61707[(7)]);
var inst_61680 = (state_61707[(8)]);
var inst_61670 = (state_61707[(9)]);
var _ = (function (){var statearr_61713 = state_61707;
(statearr_61713[(4)] = cljs.core.cons((5),(state_61707[(4)])));

return statearr_61713;
})();
var inst_61670__$1 = fluree.db.util.core.random_uuid();
var inst_61671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61672 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61673 = (new cljs.core.PersistentVector(null,2,(5),inst_61671,inst_61672,null));
var inst_61674 = (function (){var lock_id = inst_61670__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_61675__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61673,inst_61674);
var inst_61676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61677 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61678 = (new cljs.core.PersistentVector(null,3,(5),inst_61676,inst_61677,null));
var inst_61679 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61675__$1,inst_61678);
var inst_61680__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61670__$1,inst_61679);
var inst_61681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61682 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61683 = (new cljs.core.PersistentVector(null,3,(5),inst_61681,inst_61682,null));
var inst_61684 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61675__$1,inst_61683);
var state_61707__$1 = (function (){var statearr_61714 = state_61707;
(statearr_61714[(7)] = inst_61675__$1);

(statearr_61714[(8)] = inst_61680__$1);

(statearr_61714[(10)] = inst_61684);

(statearr_61714[(9)] = inst_61670__$1);

return statearr_61714;
})();
if(inst_61680__$1){
var statearr_61715_61739 = state_61707__$1;
(statearr_61715_61739[(1)] = (6));

} else {
var statearr_61716_61740 = state_61707__$1;
(statearr_61716_61740[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (11))){
var inst_61691 = (state_61707[(11)]);
var inst_61690 = (state_61707[(12)]);
var inst_61684 = (state_61707[(10)]);
var inst_61697 = fluree.db.util.xhttp.try_socket(inst_61690,sub_chan,pub_chan,inst_61684,(60000),inst_61691);
var state_61707__$1 = state_61707;
var statearr_61718_61741 = state_61707__$1;
(statearr_61718_61741[(2)] = inst_61697);

(statearr_61718_61741[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (9))){
var inst_61675 = (state_61707[(7)]);
var inst_61690 = (state_61707[(12)]);
var inst_61680 = (state_61707[(8)]);
var inst_61688 = (state_61707[(13)]);
var inst_61684 = (state_61707[(10)]);
var inst_61670 = (state_61707[(9)]);
var inst_61688__$1 = (state_61707[(2)]);
var inst_61689 = clojure.string.replace(inst_61688__$1,"http","ws");
var inst_61690__$1 = [inst_61689,"/fdb/ws"].join('');
var inst_61691 = (function (){var lock_id = inst_61670;
var state = inst_61675;
var have_lock_QMARK_ = inst_61680;
var resp_chan = inst_61684;
var healthy_server = inst_61688__$1;
var ws_url = inst_61690__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_61692 = fluree.db.util.core.exception_QMARK_(inst_61688__$1);
var state_61707__$1 = (function (){var statearr_61719 = state_61707;
(statearr_61719[(11)] = inst_61691);

(statearr_61719[(12)] = inst_61690__$1);

(statearr_61719[(13)] = inst_61688__$1);

return statearr_61719;
})();
if(inst_61692){
var statearr_61720_61742 = state_61707__$1;
(statearr_61720_61742[(1)] = (10));

} else {
var statearr_61721_61743 = state_61707__$1;
(statearr_61721_61743[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (5))){
var _ = (function (){var statearr_61722 = state_61707;
(statearr_61722[(4)] = cljs.core.rest((state_61707[(4)])));

return statearr_61722;
})();
var state_61707__$1 = state_61707;
var ex61717 = (state_61707__$1[(2)]);
var statearr_61723_61744 = state_61707__$1;
(statearr_61723_61744[(5)] = ex61717);


if((ex61717 instanceof Error)){
var statearr_61724_61745 = state_61707__$1;
(statearr_61724_61745[(1)] = (4));

(statearr_61724_61745[(5)] = null);

} else {
throw ex61717;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (10))){
var inst_61688 = (state_61707[(13)]);
var inst_61684 = (state_61707[(10)]);
var inst_61694 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_61695 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61684,inst_61688);
var state_61707__$1 = (function (){var statearr_61725 = state_61707;
(statearr_61725[(14)] = inst_61694);

return statearr_61725;
})();
var statearr_61726_61746 = state_61707__$1;
(statearr_61726_61746[(2)] = inst_61695);

(statearr_61726_61746[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61708 === (8))){
var inst_61684 = (state_61707[(10)]);
var inst_61702 = (state_61707[(2)]);
var _ = (function (){var statearr_61727 = state_61707;
(statearr_61727[(4)] = cljs.core.rest((state_61707[(4)])));

return statearr_61727;
})();
var state_61707__$1 = (function (){var statearr_61728 = state_61707;
(statearr_61728[(15)] = inst_61702);

return statearr_61728;
})();
var statearr_61729_61747 = state_61707__$1;
(statearr_61729_61747[(2)] = inst_61684);

(statearr_61729_61747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_61730 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61730[(0)] = fluree$db$connection$establish_socket_$_state_machine__2741__auto__);

(statearr_61730[(1)] = (1));

return statearr_61730;
});
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____1 = (function (state_61707){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61707);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61731){var ex__2744__auto__ = e61731;
var statearr_61732_61748 = state_61707;
(statearr_61732_61748[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61707[(4)]))){
var statearr_61733_61749 = state_61707;
(statearr_61733_61749[(1)] = cljs.core.first((state_61707[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61750 = state_61707;
state_61707 = G__61750;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = function(state_61707){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____1.call(this,state_61707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61734 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61734[(6)] = c__2763__auto__);

return statearr_61734;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k61752,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__61756 = k61752;
var G__61756__$1 = (((G__61756 instanceof cljs.core.Keyword))?G__61756.fqn:null);
switch (G__61756__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k61752,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4525__auto__,p__61757){
var vec__61758 = p__61757;
var k__4526__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61758,(0),null);
var v__4527__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61758,(1),null);
return (f__4523__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4523__auto__.cljs$core$IFn$_invoke$arity$3(ret__4525__auto__,k__4526__auto__,v__4527__auto__) : f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__));
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer(writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer(writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61751){
var self__ = this;
var G__61751__$1 = this;
return (new cljs.core.RecordIter((0),G__61751__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (){var fexpr__61761 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4499__auto__));
});
return fexpr__61761(this__4498__auto____$1);
})();
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61753,other61754){
var self__ = this;
var this61753__$1 = this;
return (((!((other61754 == null)))) && ((((this61753__$1.constructor === other61754.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.id,other61754.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.servers,other61754.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.state,other61754.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.req_chan,other61754.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.sub_chan,other61754.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.pub_chan,other61754.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.group,other61754.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.storage_read,other61754.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.storage_write,other61754.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.object_cache,other61754.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.parallelism,other61754.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.serializer,other61754.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.default_network,other61754.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.transactor_QMARK_,other61754.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.publish,other61754.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.transact_handler,other61754.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.tx_private_key,other61754.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.tx_key_id,other61754.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.meta,other61754.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.add_listener,other61754.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.remove_listener,other61754.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.close,other61754.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this61753__$1.__extmap,other61754.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k61752){
var self__ = this;
var this__4509__auto____$1 = this;
var G__61762 = k61752;
var G__61762__$1 = (((G__61762 instanceof cljs.core.Keyword))?G__61762.fqn:null);
switch (G__61762__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k61752);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__61751){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__61763 = cljs.core.keyword_identical_QMARK_;
var expr__61764 = k__4511__auto__;
if(cljs.core.truth_((function (){var G__61766 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__61767 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61766,G__61767) : pred__61763.call(null,G__61766,G__61767));
})())){
return (new fluree.db.connection.Connection(G__61751,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61768 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__61769 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61768,G__61769) : pred__61763.call(null,G__61768,G__61769));
})())){
return (new fluree.db.connection.Connection(self__.id,G__61751,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61770 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__61771 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61770,G__61771) : pred__61763.call(null,G__61770,G__61771));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61751,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61772 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__61773 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61772,G__61773) : pred__61763.call(null,G__61772,G__61773));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61751,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61774 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__61775 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61774,G__61775) : pred__61763.call(null,G__61774,G__61775));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61751,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61776 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__61777 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61776,G__61777) : pred__61763.call(null,G__61776,G__61777));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61751,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61778 = new cljs.core.Keyword(null,"group","group",582596132);
var G__61779 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61778,G__61779) : pred__61763.call(null,G__61778,G__61779));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61751,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61780 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__61781 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61780,G__61781) : pred__61763.call(null,G__61780,G__61781));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61751,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61782 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__61783 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61782,G__61783) : pred__61763.call(null,G__61782,G__61783));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61751,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61784 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__61785 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61784,G__61785) : pred__61763.call(null,G__61784,G__61785));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61751,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61786 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__61787 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61786,G__61787) : pred__61763.call(null,G__61786,G__61787));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61751,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61788 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__61789 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61788,G__61789) : pred__61763.call(null,G__61788,G__61789));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61751,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61790 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__61791 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61790,G__61791) : pred__61763.call(null,G__61790,G__61791));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61751,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61792 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__61793 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61792,G__61793) : pred__61763.call(null,G__61792,G__61793));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61751,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61794 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__61795 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61794,G__61795) : pred__61763.call(null,G__61794,G__61795));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61751,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61796 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__61797 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61796,G__61797) : pred__61763.call(null,G__61796,G__61797));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61751,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61798 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__61799 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61798,G__61799) : pred__61763.call(null,G__61798,G__61799));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61751,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61800 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__61801 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61800,G__61801) : pred__61763.call(null,G__61800,G__61801));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61751,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61802 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__61803 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61802,G__61803) : pred__61763.call(null,G__61802,G__61803));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61751,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61804 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__61805 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61804,G__61805) : pred__61763.call(null,G__61804,G__61805));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61751,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61806 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__61807 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61806,G__61807) : pred__61763.call(null,G__61806,G__61807));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61751,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__61808 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__61809 = expr__61764;
return (pred__61763.cljs$core$IFn$_invoke$arity$2 ? pred__61763.cljs$core$IFn$_invoke$arity$2(G__61808,G__61809) : pred__61763.call(null,G__61808,G__61809));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61751,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4511__auto__,G__61751),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__61751){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61751,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write(writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61755){
var extmap__4542__auto__ = (function (){var G__61810 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__61755,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__61755)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__61810);
} else {
return G__61810;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61755),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61755),null,cljs.core.not_empty(extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__61816 = servers_STAR_;
var vec__61817 = G__61816;
var seq__61818 = cljs.core.seq(vec__61817);
var first__61819 = cljs.core.first(seq__61818);
var seq__61818__$1 = cljs.core.next(seq__61818);
var server = first__61819;
var r = seq__61818__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61816__$1 = G__61816;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61823 = G__61816__$1;
var seq__61824 = cljs.core.seq(vec__61823);
var first__61825 = cljs.core.first(seq__61824);
var seq__61824__$1 = cljs.core.next(seq__61824);
var server__$1 = first__61825;
var r__$1 = seq__61824__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__61826 = r__$1;
var G__61827 = is_https_QMARK_;
var G__61828 = result_STAR_;
G__61816__$1 = G__61826;
https_QMARK___$1 = G__61827;
result__$1 = G__61828;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61829 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61829 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__61829);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61858){
var state_val_61859 = (state_61858[(1)]);
if((state_val_61859 === (7))){
var inst_61844 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61845 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61846 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61847 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61848 = fluree.db.connection.establish_socket(inst_61844,inst_61845,inst_61846,inst_61847);
var state_61858__$1 = state_61858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61858__$1,(9),inst_61848);
} else {
if((state_val_61859 === (1))){
var state_61858__$1 = state_61858;
var statearr_61860_61879 = state_61858__$1;
(statearr_61860_61879[(2)] = null);

(statearr_61860_61879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (4))){
var inst_61830 = (state_61858[(2)]);
var state_61858__$1 = state_61858;
var statearr_61861_61880 = state_61858__$1;
(statearr_61861_61880[(2)] = inst_61830);

(statearr_61861_61880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (6))){
var inst_61841 = (state_61858[(7)]);
var state_61858__$1 = state_61858;
var statearr_61862_61881 = state_61858__$1;
(statearr_61862_61881[(2)] = inst_61841);

(statearr_61862_61881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (3))){
var inst_61856 = (state_61858[(2)]);
var state_61858__$1 = state_61858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61858__$1,inst_61856);
} else {
if((state_val_61859 === (2))){
var inst_61841 = (state_61858[(7)]);
var _ = (function (){var statearr_61864 = state_61858;
(statearr_61864[(4)] = cljs.core.cons((5),(state_61858[(4)])));

return statearr_61864;
})();
var inst_61836 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_61837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61838 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61839 = [inst_61838,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61840 = (new cljs.core.PersistentVector(null,3,(5),inst_61837,inst_61839,null));
var inst_61841__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_61836,inst_61840);
var state_61858__$1 = (function (){var statearr_61865 = state_61858;
(statearr_61865[(7)] = inst_61841__$1);

return statearr_61865;
})();
if(cljs.core.truth_(inst_61841__$1)){
var statearr_61866_61882 = state_61858__$1;
(statearr_61866_61882[(1)] = (6));

} else {
var statearr_61867_61883 = state_61858__$1;
(statearr_61867_61883[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (9))){
var inst_61850 = (state_61858[(2)]);
var inst_61851 = fluree.db.util.async.throw_err(inst_61850);
var state_61858__$1 = state_61858;
var statearr_61868_61884 = state_61858__$1;
(statearr_61868_61884[(2)] = inst_61851);

(statearr_61868_61884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (5))){
var _ = (function (){var statearr_61869 = state_61858;
(statearr_61869[(4)] = cljs.core.rest((state_61858[(4)])));

return statearr_61869;
})();
var state_61858__$1 = state_61858;
var ex61863 = (state_61858__$1[(2)]);
var statearr_61870_61885 = state_61858__$1;
(statearr_61870_61885[(5)] = ex61863);


if((ex61863 instanceof Error)){
var statearr_61871_61886 = state_61858__$1;
(statearr_61871_61886[(1)] = (4));

(statearr_61871_61886[(5)] = null);

} else {
throw ex61863;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61859 === (8))){
var inst_61853 = (state_61858[(2)]);
var _ = (function (){var statearr_61872 = state_61858;
(statearr_61872[(4)] = cljs.core.rest((state_61858[(4)])));

return statearr_61872;
})();
var state_61858__$1 = state_61858;
var statearr_61873_61887 = state_61858__$1;
(statearr_61873_61887[(2)] = inst_61853);

(statearr_61873_61887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_61874 = [null,null,null,null,null,null,null,null];
(statearr_61874[(0)] = fluree$db$connection$get_socket_$_state_machine__2741__auto__);

(statearr_61874[(1)] = (1));

return statearr_61874;
});
var fluree$db$connection$get_socket_$_state_machine__2741__auto____1 = (function (state_61858){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61858);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61875){var ex__2744__auto__ = e61875;
var statearr_61876_61888 = state_61858;
(statearr_61876_61888[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61858[(4)]))){
var statearr_61877_61889 = state_61858;
(statearr_61877_61889[(1)] = cljs.core.first((state_61858[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61890 = state_61858;
state_61858 = G__61890;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2741__auto__ = function(state_61858){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____1.call(this,state_61858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2741__auto____0;
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61878 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_61878[(6)] = c__2763__auto__);

return statearr_61878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e61891){var e = e61891;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62018){
var state_val_62019 = (state_62018[(1)]);
if((state_val_62019 === (7))){
var inst_62014 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
var statearr_62021_62091 = state_62018__$1;
(statearr_62021_62091[(2)] = inst_62014);

(statearr_62021_62091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (20))){
var _ = (function (){var statearr_62022 = state_62018;
(statearr_62022[(4)] = cljs.core.rest((state_62018[(4)])));

return statearr_62022;
})();
var state_62018__$1 = state_62018;
var ex62020 = (state_62018__$1[(2)]);
var statearr_62023_62092 = state_62018__$1;
(statearr_62023_62092[(5)] = ex62020);


var statearr_62024_62093 = state_62018__$1;
(statearr_62024_62093[(1)] = (10));

(statearr_62024_62093[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (27))){
var inst_62006 = (state_62018[(2)]);
var _ = (function (){var statearr_62025 = state_62018;
(statearr_62025[(4)] = cljs.core.rest((state_62018[(4)])));

return statearr_62025;
})();
var state_62018__$1 = state_62018;
var statearr_62026_62094 = state_62018__$1;
(statearr_62026_62094[(2)] = inst_62006);

(statearr_62026_62094[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (1))){
var inst_61893 = (0);
var state_62018__$1 = (function (){var statearr_62027 = state_62018;
(statearr_62027[(7)] = inst_61893);

return statearr_62027;
})();
var statearr_62028_62095 = state_62018__$1;
(statearr_62028_62095[(2)] = null);

(statearr_62028_62095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (24))){
var inst_61984 = (state_62018[(8)]);
var inst_61984__$1 = (state_62018[(2)]);
var inst_61985 = inst_61984__$1 === true;
var state_62018__$1 = (function (){var statearr_62029 = state_62018;
(statearr_62029[(8)] = inst_61984__$1);

return statearr_62029;
})();
if(cljs.core.truth_(inst_61985)){
var statearr_62030_62096 = state_62018__$1;
(statearr_62030_62096[(1)] = (25));

} else {
var statearr_62031_62097 = state_62018__$1;
(statearr_62031_62097[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (4))){
var inst_61896 = (state_62018[(9)]);
var inst_61896__$1 = (state_62018[(2)]);
var state_62018__$1 = (function (){var statearr_62032 = state_62018;
(statearr_62032[(9)] = inst_61896__$1);

return statearr_62032;
})();
if(cljs.core.truth_(inst_61896__$1)){
var statearr_62033_62098 = state_62018__$1;
(statearr_62033_62098[(1)] = (5));

} else {
var statearr_62034_62099 = state_62018__$1;
(statearr_62034_62099[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (15))){
var inst_61909 = (state_62018[(10)]);
var state_62018__$1 = state_62018;
var statearr_62035_62100 = state_62018__$1;
(statearr_62035_62100[(2)] = inst_61909);

(statearr_62035_62100[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (21))){
var inst_61896 = (state_62018[(9)]);
var inst_61941 = (state_62018[(11)]);
var inst_61935 = (state_62018[(12)]);
var inst_61940 = (state_62018[(13)]);
var inst_61934 = (state_62018[(14)]);
var inst_61933 = (state_62018[(15)]);
var inst_61937 = (state_62018[(16)]);
var inst_61893 = (state_62018[(7)]);
var inst_61936 = (state_62018[(17)]);
var inst_61932 = (state_62018[(18)]);
var inst_61943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61944 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61940];
var inst_61945 = (new cljs.core.PersistentVector(null,2,(5),inst_61943,inst_61944,null));
var inst_61946 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_61945,inst_61935);
var inst_61973 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61974 = (function (){var resp_chan = inst_61935;
var timeout = inst_61941;
var i = inst_61893;
var data = inst_61934;
var vec__61928 = inst_61896;
var _ = inst_61932;
var req_id = inst_61940;
var operation = inst_61933;
var msg = inst_61896;
var c__2763__auto____$1 = inst_61973;
var map__61931 = inst_61937;
var opts = inst_61936;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61971){
var state_val_61972 = (state_61971[(1)]);
if((state_val_61972 === (1))){
var inst_61950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61951 = cljs.core.async.timeout(timeout);
var inst_61952 = [resp_chan,inst_61951];
var inst_61953 = (new cljs.core.PersistentVector(null,2,(5),inst_61950,inst_61952,null));
var state_61971__$1 = state_61971;
return cljs.core.async.ioc_alts_BANG_(state_61971__$1,(2),inst_61953);
} else {
if((state_val_61972 === (2))){
var inst_61956 = (state_61971[(7)]);
var inst_61955 = (state_61971[(2)]);
var inst_61956__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61955,(0),null);
var inst_61957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61955,(1),null);
var inst_61958 = (function (){var vec__61947 = inst_61955;
var resp = inst_61956__$1;
var c = inst_61957;
return (function (p1__61892_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__61892_SHARP_,req_id);
});
})();
var inst_61959 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61958);
var inst_61960 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61957,resp_chan);
var state_61971__$1 = (function (){var statearr_62036 = state_61971;
(statearr_62036[(7)] = inst_61956__$1);

(statearr_62036[(8)] = inst_61959);

return statearr_62036;
})();
if(inst_61960){
var statearr_62037_62101 = state_61971__$1;
(statearr_62037_62101[(1)] = (3));

} else {
var statearr_62038_62102 = state_61971__$1;
(statearr_62038_62102[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61972 === (3))){
var inst_61956 = (state_61971[(7)]);
var state_61971__$1 = state_61971;
var statearr_62039_62103 = state_61971__$1;
(statearr_62039_62103[(2)] = inst_61956);

(statearr_62039_62103[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61972 === (4))){
var inst_61963 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_61964 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61965 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_61966 = cljs.core.PersistentHashMap.fromArrays(inst_61964,inst_61965);
var inst_61967 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61963,inst_61966);
var state_61971__$1 = state_61971;
var statearr_62040_62104 = state_61971__$1;
(statearr_62040_62104[(2)] = inst_61967);

(statearr_62040_62104[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61972 === (5))){
var inst_61969 = (state_61971[(2)]);
var state_61971__$1 = state_61971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61971__$1,inst_61969);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_62041 = [null,null,null,null,null,null,null,null,null];
(statearr_62041[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_62041[(1)] = (1));

return statearr_62041;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_61971){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_61971);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62042){var ex__2744__auto__ = e62042;
var statearr_62043_62105 = state_61971;
(statearr_62043_62105[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_61971[(4)]))){
var statearr_62044_62106 = state_61971;
(statearr_62044_62106[(1)] = cljs.core.first((state_61971[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62107 = state_61971;
state_61971 = G__62107;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_61971){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_61971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62045 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62045[(6)] = c__2763__auto____$1);

return statearr_62045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_61975 = cljs.core.async.impl.dispatch.run(inst_61974);
var state_62018__$1 = (function (){var statearr_62046 = state_62018;
(statearr_62046[(19)] = inst_61946);

(statearr_62046[(20)] = inst_61975);

return statearr_62046;
})();
var statearr_62047_62108 = state_62018__$1;
(statearr_62047_62108[(2)] = inst_61973);

(statearr_62047_62108[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (31))){
var inst_61994 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_62018__$1 = state_62018;
var statearr_62048_62109 = state_62018__$1;
(statearr_62048_62109[(2)] = inst_61994);

(statearr_62048_62109[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (32))){
var state_62018__$1 = state_62018;
var statearr_62049_62110 = state_62018__$1;
(statearr_62049_62110[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (33))){
var inst_62002 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
var statearr_62051_62111 = state_62018__$1;
(statearr_62051_62111[(2)] = inst_62002);

(statearr_62051_62111[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (13))){
var inst_61909 = (state_62018[(10)]);
var inst_61906 = (state_62018[(2)]);
var inst_61907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61906,(0),null);
var inst_61908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61906,(1),null);
var inst_61909__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61906,(2),null);
var state_62018__$1 = (function (){var statearr_62052 = state_62018;
(statearr_62052[(21)] = inst_61908);

(statearr_62052[(10)] = inst_61909__$1);

(statearr_62052[(22)] = inst_61907);

return statearr_62052;
})();
if(cljs.core.truth_(inst_61909__$1)){
var statearr_62053_62112 = state_62018__$1;
(statearr_62053_62112[(1)] = (14));

} else {
var statearr_62054_62113 = state_62018__$1;
(statearr_62054_62113[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (22))){
var state_62018__$1 = state_62018;
var statearr_62055_62114 = state_62018__$1;
(statearr_62055_62114[(2)] = null);

(statearr_62055_62114[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (36))){
var inst_62000 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
var statearr_62056_62115 = state_62018__$1;
(statearr_62056_62115[(2)] = inst_62000);

(statearr_62056_62115[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (29))){
var inst_61984 = (state_62018[(8)]);
var inst_61992 = (inst_61984 == null);
var state_62018__$1 = state_62018;
if(cljs.core.truth_(inst_61992)){
var statearr_62057_62116 = state_62018__$1;
(statearr_62057_62116[(1)] = (31));

} else {
var statearr_62058_62117 = state_62018__$1;
(statearr_62058_62117[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (6))){
var state_62018__$1 = state_62018;
var statearr_62059_62118 = state_62018__$1;
(statearr_62059_62118[(2)] = null);

(statearr_62059_62118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (28))){
var inst_61984 = (state_62018[(8)]);
var inst_61990 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61984,"Error processing message in producer."], 0));
var state_62018__$1 = state_62018;
var statearr_62060_62119 = state_62018__$1;
(statearr_62060_62119[(2)] = inst_61990);

(statearr_62060_62119[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (25))){
var state_62018__$1 = state_62018;
var statearr_62061_62120 = state_62018__$1;
(statearr_62061_62120[(2)] = null);

(statearr_62061_62120[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (34))){
var inst_61984 = (state_62018[(8)]);
var inst_61997 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_61984], 0));
var state_62018__$1 = state_62018;
var statearr_62062_62121 = state_62018__$1;
(statearr_62062_62121[(2)] = inst_61997);

(statearr_62062_62121[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (17))){
var inst_61909 = (state_62018[(10)]);
var inst_61898 = (state_62018[(23)]);
var inst_61916 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_61909,inst_61898);
var state_62018__$1 = state_62018;
var statearr_62063_62122 = state_62018__$1;
(statearr_62063_62122[(2)] = inst_61916);

(statearr_62063_62122[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (3))){
var inst_62016 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62018__$1,inst_62016);
} else {
if((state_val_62019 === (12))){
var state_62018__$1 = state_62018;
var statearr_62064_62123 = state_62018__$1;
(statearr_62064_62123[(2)] = null);

(statearr_62064_62123[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (2))){
var state_62018__$1 = state_62018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62018__$1,(4),req_chan);
} else {
if((state_val_62019 === (23))){
var inst_61940 = (state_62018[(13)]);
var inst_61934 = (state_62018[(14)]);
var inst_61933 = (state_62018[(15)]);
var inst_61978 = (state_62018[(2)]);
var inst_61979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61980 = [inst_61933,inst_61940,inst_61934];
var inst_61981 = (new cljs.core.PersistentVector(null,3,(5),inst_61979,inst_61980,null));
var inst_61982 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_61981) : publish_fn.call(null,conn,inst_61981));
var state_62018__$1 = (function (){var statearr_62065 = state_62018;
(statearr_62065[(24)] = inst_61978);

return statearr_62065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62018__$1,(24),inst_61982);
} else {
if((state_val_62019 === (35))){
var state_62018__$1 = state_62018;
var statearr_62066_62124 = state_62018__$1;
(statearr_62066_62124[(2)] = null);

(statearr_62066_62124[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (19))){
var inst_61922 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
var statearr_62067_62125 = state_62018__$1;
(statearr_62067_62125[(2)] = inst_61922);

(statearr_62067_62125[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (11))){
var inst_61896 = (state_62018[(9)]);
var state_62018__$1 = state_62018;
var statearr_62068_62126 = state_62018__$1;
(statearr_62068_62126[(2)] = inst_61896);

(statearr_62068_62126[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (9))){
var inst_61893 = (state_62018[(7)]);
var inst_62009 = (state_62018[(2)]);
var inst_62010 = (inst_61893 + (1));
var inst_61893__$1 = inst_62010;
var state_62018__$1 = (function (){var statearr_62069 = state_62018;
(statearr_62069[(25)] = inst_62009);

(statearr_62069[(7)] = inst_61893__$1);

return statearr_62069;
})();
var statearr_62070_62127 = state_62018__$1;
(statearr_62070_62127[(2)] = null);

(statearr_62070_62127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (5))){
var state_62018__$1 = state_62018;
var statearr_62071_62128 = state_62018__$1;
(statearr_62071_62128[(2)] = null);

(statearr_62071_62128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (14))){
var inst_61909 = (state_62018[(10)]);
var inst_61911 = fluree.db.util.async.channel_QMARK_(inst_61909);
var state_62018__$1 = state_62018;
var statearr_62072_62129 = state_62018__$1;
(statearr_62072_62129[(2)] = inst_61911);

(statearr_62072_62129[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (26))){
var inst_61984 = (state_62018[(8)]);
var inst_61988 = fluree.db.util.core.exception_QMARK_(inst_61984);
var state_62018__$1 = state_62018;
if(inst_61988){
var statearr_62073_62130 = state_62018__$1;
(statearr_62073_62130[(1)] = (28));

} else {
var statearr_62074_62131 = state_62018__$1;
(statearr_62074_62131[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (16))){
var inst_61914 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
if(cljs.core.truth_(inst_61914)){
var statearr_62075_62132 = state_62018__$1;
(statearr_62075_62132[(1)] = (17));

} else {
var statearr_62076_62133 = state_62018__$1;
(statearr_62076_62133[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (30))){
var inst_62004 = (state_62018[(2)]);
var state_62018__$1 = state_62018;
var statearr_62077_62134 = state_62018__$1;
(statearr_62077_62134[(2)] = inst_62004);

(statearr_62077_62134[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (10))){
var inst_61896 = (state_62018[(9)]);
var inst_61898 = (state_62018[(2)]);
var inst_61902 = cljs.core.sequential_QMARK_(inst_61896);
var state_62018__$1 = (function (){var statearr_62078 = state_62018;
(statearr_62078[(23)] = inst_61898);

return statearr_62078;
})();
if(inst_61902){
var statearr_62079_62135 = state_62018__$1;
(statearr_62079_62135[(1)] = (11));

} else {
var statearr_62080_62136 = state_62018__$1;
(statearr_62080_62136[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (18))){
var inst_61896 = (state_62018[(9)]);
var inst_61898 = (state_62018[(23)]);
var inst_61918 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61896], 0));
var inst_61919 = ["Error processing ledger request, no valid return channel: ",inst_61918].join('');
var inst_61920 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61898,inst_61919], 0));
var state_62018__$1 = state_62018;
var statearr_62081_62137 = state_62018__$1;
(statearr_62081_62137[(2)] = inst_61920);

(statearr_62081_62137[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62019 === (8))){
var inst_61896 = (state_62018[(9)]);
var inst_61935 = (state_62018[(12)]);
var inst_61937 = (state_62018[(16)]);
var inst_61936 = (state_62018[(17)]);
var _ = (function (){var statearr_62082 = state_62018;
(statearr_62082[(4)] = cljs.core.cons((20),(state_62018[(4)])));

return statearr_62082;
})();
var inst_61932 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_61896], 0));
var inst_61933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61896,(0),null);
var inst_61934 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61896,(1),null);
var inst_61935__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61896,(2),null);
var inst_61936__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61896,(3),null);
var inst_61937__$1 = cljs.core.__destructure_map(inst_61936__$1);
var inst_61938 = fluree.db.util.core.random_uuid();
var inst_61939 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_61938);
var inst_61940 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61937__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_61939);
var inst_61941 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_61937__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_62018__$1 = (function (){var statearr_62083 = state_62018;
(statearr_62083[(11)] = inst_61941);

(statearr_62083[(12)] = inst_61935__$1);

(statearr_62083[(13)] = inst_61940);

(statearr_62083[(14)] = inst_61934);

(statearr_62083[(15)] = inst_61933);

(statearr_62083[(16)] = inst_61937__$1);

(statearr_62083[(17)] = inst_61936__$1);

(statearr_62083[(18)] = inst_61932);

return statearr_62083;
})();
if(cljs.core.truth_(inst_61935__$1)){
var statearr_62084_62138 = state_62018__$1;
(statearr_62084_62138[(1)] = (21));

} else {
var statearr_62085_62139 = state_62018__$1;
(statearr_62085_62139[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_62086 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62086[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_62086[(1)] = (1));

return statearr_62086;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_62018){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62018);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62087){var ex__2744__auto__ = e62087;
var statearr_62088_62140 = state_62018;
(statearr_62088_62140[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62018[(4)]))){
var statearr_62089_62141 = state_62018;
(statearr_62089_62141[(1)] = cljs.core.first((state_62018[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62142 = state_62018;
state_62018 = G__62142;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_62018){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_62018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62090 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62090[(6)] = c__2763__auto__);

return statearr_62090;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62143 = conn;
var map__62143__$1 = cljs.core.__destructure_map(map__62143);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62143__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62228){
var state_val_62229 = (state_62228[(1)]);
if((state_val_62229 === (7))){
var inst_62224 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62230_62281 = state_62228__$1;
(statearr_62230_62281[(2)] = inst_62224);

(statearr_62230_62281[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (20))){
var inst_62162 = (state_62228[(7)]);
var inst_62176 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62177 = [inst_62162];
var inst_62178 = cljs.core.PersistentHashMap.fromArrays(inst_62176,inst_62177);
var inst_62179 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_62178], 0));
var state_62228__$1 = state_62228;
var statearr_62231_62282 = state_62228__$1;
(statearr_62231_62282[(2)] = inst_62179);

(statearr_62231_62282[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (27))){
var state_62228__$1 = state_62228;
var statearr_62232_62283 = state_62228__$1;
(statearr_62232_62283[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (1))){
var inst_62144 = (0);
var state_62228__$1 = (function (){var statearr_62234 = state_62228;
(statearr_62234[(8)] = inst_62144);

return statearr_62234;
})();
var statearr_62235_62284 = state_62228__$1;
(statearr_62235_62284[(2)] = null);

(statearr_62235_62284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (24))){
var inst_62155 = (state_62228[(9)]);
var inst_62204 = fluree.db.util.core.exception_QMARK_(inst_62155);
var state_62228__$1 = state_62228;
if(inst_62204){
var statearr_62236_62285 = state_62228__$1;
(statearr_62236_62285[(1)] = (26));

} else {
var statearr_62237_62286 = state_62228__$1;
(statearr_62237_62286[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (4))){
var inst_62149 = (state_62228[(10)]);
var inst_62154 = (state_62228[(2)]);
var inst_62155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62154,(0),null);
var inst_62156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62154,(1),null);
var inst_62157 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62156,inst_62149);
var state_62228__$1 = (function (){var statearr_62238 = state_62228;
(statearr_62238[(9)] = inst_62155);

return statearr_62238;
})();
if(inst_62157){
var statearr_62239_62287 = state_62228__$1;
(statearr_62239_62287[(1)] = (5));

} else {
var statearr_62240_62288 = state_62228__$1;
(statearr_62240_62288[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (15))){
var inst_62162 = (state_62228[(7)]);
var inst_62171 = typeof inst_62162 === 'string';
var state_62228__$1 = state_62228;
if(cljs.core.truth_(inst_62171)){
var statearr_62241_62289 = state_62228__$1;
(statearr_62241_62289[(1)] = (17));

} else {
var statearr_62242_62290 = state_62228__$1;
(statearr_62242_62290[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (21))){
var state_62228__$1 = state_62228;
var statearr_62243_62291 = state_62228__$1;
(statearr_62243_62291[(2)] = null);

(statearr_62243_62291[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (31))){
var inst_62218 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62244_62292 = state_62228__$1;
(statearr_62244_62292[(2)] = inst_62218);

(statearr_62244_62292[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (13))){
var inst_62188 = (state_62228[(2)]);
var inst_62189 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62190 = fluree.db.connection.close_websocket(inst_62189);
var inst_62191 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62192 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_62191);
var state_62228__$1 = (function (){var statearr_62245 = state_62228;
(statearr_62245[(11)] = inst_62188);

(statearr_62245[(12)] = inst_62190);

return statearr_62245;
})();
var statearr_62246_62293 = state_62228__$1;
(statearr_62246_62293[(2)] = inst_62192);

(statearr_62246_62293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (22))){
var inst_62182 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62247_62294 = state_62228__$1;
(statearr_62247_62294[(2)] = inst_62182);

(statearr_62247_62294[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (29))){
var inst_62155 = (state_62228[(9)]);
var inst_62210 = fluree.db.util.json.parse(inst_62155);
var inst_62211 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62210], 0));
var inst_62212 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_62211], 0));
var inst_62213 = fluree.db.util.json.parse(inst_62155);
var inst_62214 = fluree.db.conn_events.process_events(conn,inst_62213);
var inst_62144 = (0);
var state_62228__$1 = (function (){var statearr_62248 = state_62228;
(statearr_62248[(13)] = inst_62212);

(statearr_62248[(8)] = inst_62144);

(statearr_62248[(14)] = inst_62214);

return statearr_62248;
})();
var statearr_62249_62295 = state_62228__$1;
(statearr_62249_62295[(2)] = null);

(statearr_62249_62295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (6))){
var inst_62155 = (state_62228[(9)]);
var inst_62200 = (inst_62155 == null);
var state_62228__$1 = state_62228;
if(cljs.core.truth_(inst_62200)){
var statearr_62250_62296 = state_62228__$1;
(statearr_62250_62296[(1)] = (23));

} else {
var statearr_62251_62297 = state_62228__$1;
(statearr_62251_62297[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (28))){
var inst_62220 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62252_62298 = state_62228__$1;
(statearr_62252_62298[(2)] = inst_62220);

(statearr_62252_62298[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (25))){
var inst_62222 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62253_62299 = state_62228__$1;
(statearr_62253_62299[(2)] = inst_62222);

(statearr_62253_62299[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (17))){
var inst_62162 = (state_62228[(7)]);
var inst_62173 = cljs.core.eval(inst_62162);
var state_62228__$1 = state_62228;
var statearr_62254_62300 = state_62228__$1;
(statearr_62254_62300[(2)] = inst_62173);

(statearr_62254_62300[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (3))){
var inst_62226 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62228__$1,inst_62226);
} else {
if((state_val_62229 === (12))){
var inst_62162 = (state_62228[(7)]);
var inst_62167 = cljs.core.fn_QMARK_(inst_62162);
var state_62228__$1 = state_62228;
if(inst_62167){
var statearr_62255_62301 = state_62228__$1;
(statearr_62255_62301[(1)] = (14));

} else {
var statearr_62256_62302 = state_62228__$1;
(statearr_62256_62302[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (2))){
var inst_62149 = (state_62228[(10)]);
var inst_62149__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_62150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62151 = [sub_chan,inst_62149__$1];
var inst_62152 = (new cljs.core.PersistentVector(null,2,(5),inst_62150,inst_62151,null));
var state_62228__$1 = (function (){var statearr_62257 = state_62228;
(statearr_62257[(10)] = inst_62149__$1);

return statearr_62257;
})();
return cljs.core.async.ioc_alts_BANG_(state_62228__$1,(4),inst_62152);
} else {
if((state_val_62229 === (23))){
var inst_62202 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_62228__$1 = state_62228;
var statearr_62258_62303 = state_62228__$1;
(statearr_62258_62303[(2)] = inst_62202);

(statearr_62258_62303[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (19))){
var inst_62184 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62259_62304 = state_62228__$1;
(statearr_62259_62304[(2)] = inst_62184);

(statearr_62259_62304[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (11))){
var inst_62165 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_62228__$1 = state_62228;
var statearr_62260_62305 = state_62228__$1;
(statearr_62260_62305[(2)] = inst_62165);

(statearr_62260_62305[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (9))){
var inst_62144 = (state_62228[(8)]);
var inst_62194 = fluree.db.connection.ping_transactor(conn);
var inst_62195 = (inst_62144 + (1));
var inst_62144__$1 = inst_62195;
var state_62228__$1 = (function (){var statearr_62261 = state_62228;
(statearr_62261[(15)] = inst_62194);

(statearr_62261[(8)] = inst_62144__$1);

return statearr_62261;
})();
var statearr_62262_62306 = state_62228__$1;
(statearr_62262_62306[(2)] = null);

(statearr_62262_62306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (5))){
var inst_62144 = (state_62228[(8)]);
var inst_62159 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_62144);
var state_62228__$1 = state_62228;
if(inst_62159){
var statearr_62263_62307 = state_62228__$1;
(statearr_62263_62307[(1)] = (8));

} else {
var statearr_62264_62308 = state_62228__$1;
(statearr_62264_62308[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (14))){
var inst_62162 = (state_62228[(7)]);
var inst_62169 = (inst_62162.cljs$core$IFn$_invoke$arity$0 ? inst_62162.cljs$core$IFn$_invoke$arity$0() : inst_62162.call(null));
var state_62228__$1 = state_62228;
var statearr_62265_62309 = state_62228__$1;
(statearr_62265_62309[(2)] = inst_62169);

(statearr_62265_62309[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (26))){
var inst_62155 = (state_62228[(9)]);
var inst_62206 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62155], 0));
var inst_62144 = (0);
var state_62228__$1 = (function (){var statearr_62266 = state_62228;
(statearr_62266[(16)] = inst_62206);

(statearr_62266[(8)] = inst_62144);

return statearr_62266;
})();
var statearr_62267_62310 = state_62228__$1;
(statearr_62267_62310[(2)] = null);

(statearr_62267_62310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (16))){
var inst_62186 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62268_62311 = state_62228__$1;
(statearr_62268_62311[(2)] = inst_62186);

(statearr_62268_62311[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (30))){
var state_62228__$1 = state_62228;
var statearr_62269_62312 = state_62228__$1;
(statearr_62269_62312[(2)] = null);

(statearr_62269_62312[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (10))){
var inst_62198 = (state_62228[(2)]);
var state_62228__$1 = state_62228;
var statearr_62270_62313 = state_62228__$1;
(statearr_62270_62313[(2)] = inst_62198);

(statearr_62270_62313[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (18))){
var state_62228__$1 = state_62228;
var statearr_62271_62314 = state_62228__$1;
(statearr_62271_62314[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62229 === (8))){
var inst_62162 = (state_62228[(7)]);
var inst_62161 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_62162__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62163 = (inst_62162__$1 == null);
var state_62228__$1 = (function (){var statearr_62273 = state_62228;
(statearr_62273[(17)] = inst_62161);

(statearr_62273[(7)] = inst_62162__$1);

return statearr_62273;
})();
if(cljs.core.truth_(inst_62163)){
var statearr_62274_62315 = state_62228__$1;
(statearr_62274_62315[(1)] = (11));

} else {
var statearr_62275_62316 = state_62228__$1;
(statearr_62275_62316[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0 = (function (){
var statearr_62276 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62276[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2741__auto__);

(statearr_62276[(1)] = (1));

return statearr_62276;
});
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1 = (function (state_62228){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62228);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62277){var ex__2744__auto__ = e62277;
var statearr_62278_62317 = state_62228;
(statearr_62278_62317[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62228[(4)]))){
var statearr_62279_62318 = state_62228;
(statearr_62279_62318[(1)] = cljs.core.first((state_62228[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62319 = state_62228;
state_62228 = G__62319;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = function(state_62228){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1.call(this,state_62228);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62280 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62280[(6)] = c__2763__auto__);

return statearr_62280;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62321 = arguments.length;
switch (G__62321) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62322 = opts;
var map__62322__$1 = cljs.core.__destructure_map(map__62322);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62322__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62322__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62374){
var state_val_62375 = (state_62374[(1)]);
if((state_val_62375 === (7))){
var inst_62332 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_62333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62334 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62335 = (new cljs.core.PersistentVector(null,2,(5),inst_62333,inst_62334,null));
var inst_62336 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62332,inst_62335);
var state_62374__$1 = state_62374;
var statearr_62376_62407 = state_62374__$1;
(statearr_62376_62407[(2)] = inst_62336);

(statearr_62376_62407[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (1))){
var state_62374__$1 = state_62374;
var statearr_62377_62408 = state_62374__$1;
(statearr_62377_62408[(2)] = null);

(statearr_62377_62408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (4))){
var inst_62323 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
var statearr_62378_62409 = state_62374__$1;
(statearr_62378_62409[(2)] = inst_62323);

(statearr_62378_62409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (15))){
var inst_62343 = (state_62374[(7)]);
var inst_62362 = (state_62374[(2)]);
var inst_62363 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62364 = [(5000),inst_62362,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62365 = cljs.core.PersistentHashMap.fromArrays(inst_62363,inst_62364);
var inst_62366 = fluree.db.util.xhttp.get(inst_62343,inst_62365);
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62374__$1,(16),inst_62366);
} else {
if((state_val_62375 === (13))){
var inst_62343 = (state_62374[(7)]);
var inst_62353 = (state_62374[(8)]);
var inst_62355 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62356 = [inst_62353];
var inst_62357 = cljs.core.PersistentHashMap.fromArrays(inst_62355,inst_62356);
var inst_62358 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_62343,inst_62357,private$);
var inst_62359 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62358);
var state_62374__$1 = state_62374;
var statearr_62379_62410 = state_62374__$1;
(statearr_62379_62410[(2)] = inst_62359);

(statearr_62379_62410[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (6))){
var inst_62329 = (state_62374[(9)]);
var state_62374__$1 = state_62374;
var statearr_62380_62411 = state_62374__$1;
(statearr_62380_62411[(2)] = inst_62329);

(statearr_62380_62411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (3))){
var inst_62372 = (state_62374[(2)]);
var state_62374__$1 = state_62374;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62374__$1,inst_62372);
} else {
if((state_val_62375 === (12))){
var inst_62353 = (state_62374[(2)]);
var state_62374__$1 = (function (){var statearr_62381 = state_62374;
(statearr_62381[(8)] = inst_62353);

return statearr_62381;
})();
if(cljs.core.truth_(private$)){
var statearr_62382_62412 = state_62374__$1;
(statearr_62382_62412[(1)] = (13));

} else {
var statearr_62383_62413 = state_62374__$1;
(statearr_62383_62413[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (2))){
var inst_62329 = (state_62374[(9)]);
var _ = (function (){var statearr_62384 = state_62374;
(statearr_62384[(4)] = cljs.core.cons((5),(state_62374[(4)])));

return statearr_62384;
})();
var inst_62329__$1 = jwt;
var state_62374__$1 = (function (){var statearr_62385 = state_62374;
(statearr_62385[(9)] = inst_62329__$1);

return statearr_62385;
})();
if(cljs.core.truth_(inst_62329__$1)){
var statearr_62386_62414 = state_62374__$1;
(statearr_62386_62414[(1)] = (6));

} else {
var statearr_62387_62415 = state_62374__$1;
(statearr_62387_62415[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (11))){
var inst_62347 = (state_62374[(10)]);
var state_62374__$1 = state_62374;
var statearr_62389_62416 = state_62374__$1;
(statearr_62389_62416[(2)] = inst_62347);

(statearr_62389_62416[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (9))){
var inst_62338 = (state_62374[(11)]);
var inst_62339 = (state_62374[(12)]);
var inst_62342 = (state_62374[(2)]);
var inst_62343 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62342),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62339)].join('');
var inst_62345 = ["Accept"];
var inst_62346 = ["application/json"];
var inst_62347 = cljs.core.PersistentHashMap.fromArrays(inst_62345,inst_62346);
var state_62374__$1 = (function (){var statearr_62390 = state_62374;
(statearr_62390[(7)] = inst_62343);

(statearr_62390[(10)] = inst_62347);

return statearr_62390;
})();
if(cljs.core.truth_(inst_62338)){
var statearr_62391_62417 = state_62374__$1;
(statearr_62391_62417[(1)] = (10));

} else {
var statearr_62392_62418 = state_62374__$1;
(statearr_62392_62418[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (5))){
var _ = (function (){var statearr_62393 = state_62374;
(statearr_62393[(4)] = cljs.core.rest((state_62374[(4)])));

return statearr_62393;
})();
var state_62374__$1 = state_62374;
var ex62388 = (state_62374__$1[(2)]);
var statearr_62394_62419 = state_62374__$1;
(statearr_62394_62419[(5)] = ex62388);


if((ex62388 instanceof Error)){
var statearr_62395_62420 = state_62374__$1;
(statearr_62395_62420[(1)] = (4));

(statearr_62395_62420[(5)] = null);

} else {
throw ex62388;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (14))){
var inst_62353 = (state_62374[(8)]);
var state_62374__$1 = state_62374;
var statearr_62396_62421 = state_62374__$1;
(statearr_62396_62421[(2)] = inst_62353);

(statearr_62396_62421[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (16))){
var inst_62368 = (state_62374[(2)]);
var inst_62369 = fluree.db.util.async.throw_err(inst_62368);
var _ = (function (){var statearr_62397 = state_62374;
(statearr_62397[(4)] = cljs.core.rest((state_62374[(4)])));

return statearr_62397;
})();
var state_62374__$1 = state_62374;
var statearr_62398_62422 = state_62374__$1;
(statearr_62398_62422[(2)] = inst_62369);

(statearr_62398_62422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (10))){
var inst_62338 = (state_62374[(11)]);
var inst_62347 = (state_62374[(10)]);
var inst_62349 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62338)].join('');
var inst_62350 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62347,"Authorization",inst_62349);
var state_62374__$1 = state_62374;
var statearr_62399_62423 = state_62374__$1;
(statearr_62399_62423[(2)] = inst_62350);

(statearr_62399_62423[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62375 === (8))){
var inst_62338 = (state_62374[(2)]);
var inst_62339 = clojure.string.replace(k,"_","/");
var inst_62340 = fluree.db.connection.get_server(conn_id,servers);
var state_62374__$1 = (function (){var statearr_62400 = state_62374;
(statearr_62400[(11)] = inst_62338);

(statearr_62400[(12)] = inst_62339);

return statearr_62400;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62374__$1,(9),inst_62340);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62401 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62401[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62401[(1)] = (1));

return statearr_62401;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62374){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62374);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62402){var ex__2744__auto__ = e62402;
var statearr_62403_62424 = state_62374;
(statearr_62403_62424[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62374[(4)]))){
var statearr_62404_62425 = state_62374;
(statearr_62404_62425[(1)] = cljs.core.first((state_62374[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62426 = state_62374;
state_62374 = G__62426;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62374){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62374);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62405 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62405[(6)] = c__2763__auto__);

return statearr_62405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62427_SHARP_){
if(cljs.core.truth_(p1__62427_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62428_SHARP_){
var or__4253__auto__ = p1__62428_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e62429){var e = e62429;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62430 = opts;
var map__62430__$1 = cljs.core.__destructure_map(map__62430);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__62430__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__62430__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356)], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__62431_62432 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__62431_62432.cljs$core$IFn$_invoke$arity$0 ? fexpr__62431_62432.cljs$core$IFn$_invoke$arity$0() : fexpr__62431_62432.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62473 = arguments.length;
var i__4865__auto___62474 = (0);
while(true){
if((i__4865__auto___62474 < len__4864__auto___62473)){
args__4870__auto__.push((arguments[i__4865__auto___62474]));

var G__62475 = (i__4865__auto___62474 + (1));
i__4865__auto___62474 = G__62475;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62435){
var vec__62436 = p__62435;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62436,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2763__auto___62476 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62456){
var state_val_62457 = (state_62456[(1)]);
if((state_val_62457 === (1))){
var inst_62439 = fluree.db.connection.get_socket(conn);
var state_62456__$1 = state_62456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62456__$1,(2),inst_62439);
} else {
if((state_val_62457 === (2))){
var inst_62441 = (state_62456[(7)]);
var inst_62442 = (state_62456[(8)]);
var inst_62441__$1 = (state_62456[(2)]);
var inst_62442__$1 = (inst_62441__$1 == null);
var state_62456__$1 = (function (){var statearr_62458 = state_62456;
(statearr_62458[(7)] = inst_62441__$1);

(statearr_62458[(8)] = inst_62442__$1);

return statearr_62458;
})();
if(cljs.core.truth_(inst_62442__$1)){
var statearr_62459_62477 = state_62456__$1;
(statearr_62459_62477[(1)] = (3));

} else {
var statearr_62460_62478 = state_62456__$1;
(statearr_62460_62478[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (3))){
var inst_62442 = (state_62456[(8)]);
var state_62456__$1 = state_62456;
var statearr_62461_62479 = state_62456__$1;
(statearr_62461_62479[(2)] = inst_62442);

(statearr_62461_62479[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (4))){
var inst_62441 = (state_62456[(7)]);
var inst_62445 = fluree.db.util.core.exception_QMARK_(inst_62441);
var state_62456__$1 = state_62456;
var statearr_62462_62480 = state_62456__$1;
(statearr_62462_62480[(2)] = inst_62445);

(statearr_62462_62480[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (5))){
var inst_62447 = (state_62456[(2)]);
var state_62456__$1 = state_62456;
if(cljs.core.truth_(inst_62447)){
var statearr_62463_62481 = state_62456__$1;
(statearr_62463_62481[(1)] = (6));

} else {
var statearr_62464_62482 = state_62456__$1;
(statearr_62464_62482[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (6))){
var inst_62441 = (state_62456[(7)]);
var inst_62449 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_62441,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_62450 = cljs.core.async.close_BANG_(conn);
var state_62456__$1 = (function (){var statearr_62465 = state_62456;
(statearr_62465[(9)] = inst_62449);

return statearr_62465;
})();
var statearr_62466_62483 = state_62456__$1;
(statearr_62466_62483[(2)] = inst_62450);

(statearr_62466_62483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (7))){
var inst_62452 = fluree.db.connection.msg_consumer(conn);
var state_62456__$1 = state_62456;
var statearr_62467_62484 = state_62456__$1;
(statearr_62467_62484[(2)] = inst_62452);

(statearr_62467_62484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62457 === (8))){
var inst_62454 = (state_62456[(2)]);
var state_62456__$1 = state_62456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62456__$1,inst_62454);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62468 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62468[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62468[(1)] = (1));

return statearr_62468;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62456){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_62456);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62469){var ex__2744__auto__ = e62469;
var statearr_62470_62485 = state_62456;
(statearr_62470_62485[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_62456[(4)]))){
var statearr_62471_62486 = state_62456;
(statearr_62471_62486[(1)] = cljs.core.first((state_62456[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62487 = state_62456;
state_62456 = G__62487;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62456){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62472 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_62472[(6)] = c__2763__auto___62476);

return statearr_62472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62433){
var G__62434 = cljs.core.first(seq62433);
var seq62433__$1 = cljs.core.next(seq62433);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62434,seq62433__$1);
}));

