// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_.call(null,e.message,"timeout"))?new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305):(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status >= (500));
} else {
return and__4251__auto__;
}
})())?new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040):(function (){
fluree.db.util.log.error.call(null,"XHTTP Request Error:",e.request);

return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4251__auto__ = status;
if(cljs.core.truth_(and__4251__auto__)){
return (status > (0));
} else {
return and__4251__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__19760 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__19760,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19760;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19761 = opts;
var map__19761__$1 = cljs.core.__destructure_map.call(null,map__19761);
var request_timeout = cljs.core.get.call(null,map__19761__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__19761__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__19761__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__19762 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19762__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__19762,headers):G__19762);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__19762__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19762__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"post",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1,new cljs.core.Keyword(null,"data","data",-232669377),message], null))).then((function (resp){
return cljs.core.async.put_BANG_.call(null,response_chan,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true)));
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19763 = opts;
var map__19763__$1 = cljs.core.__destructure_map.call(null,map__19763);
var request_timeout = cljs.core.get.call(null,map__19763__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__19763__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__19763__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__19763__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__19763__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__19764 = cljs.core.PersistentArrayMap.EMPTY;
var G__19764__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__19764,headers):G__19764);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__19764__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19764__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"method","method",55703592),"get",new cljs.core.Keyword(null,"timeout","timeout",-318625318),request_timeout,new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1], null))).then((function (resp){
var data = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,resp,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__19765 = output_format;
var G__19765__$1 = (((G__19765 instanceof cljs.core.Keyword))?G__19765.fqn:null);
switch (G__19765__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify.call(null,data);

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19767 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__19767,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19767;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_19799){
var state_val_19800 = (state_19799[(1)]);
if((state_val_19800 === (7))){
var inst_19795 = (state_19799[(2)]);
var state_19799__$1 = state_19799;
var statearr_19801_19826 = state_19799__$1;
(statearr_19801_19826[(2)] = inst_19795);

(statearr_19801_19826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (1))){
var state_19799__$1 = state_19799;
var statearr_19802_19827 = state_19799__$1;
(statearr_19802_19827[(2)] = null);

(statearr_19802_19827[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (4))){
var inst_19770 = (state_19799[(7)]);
var inst_19770__$1 = (state_19799[(2)]);
var inst_19771 = (inst_19770__$1 == null);
var state_19799__$1 = (function (){var statearr_19803 = state_19799;
(statearr_19803[(7)] = inst_19770__$1);

return statearr_19803;
})();
if(cljs.core.truth_(inst_19771)){
var statearr_19804_19828 = state_19799__$1;
(statearr_19804_19828[(1)] = (5));

} else {
var statearr_19805_19829 = state_19799__$1;
(statearr_19805_19829[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (6))){
var inst_19770 = (state_19799[(7)]);
var inst_19778 = cljs.core.nth.call(null,inst_19770,(0),null);
var inst_19779 = cljs.core.nth.call(null,inst_19770,(1),null);
var state_19799__$1 = (function (){var statearr_19806 = state_19799;
(statearr_19806[(8)] = inst_19778);

(statearr_19806[(9)] = inst_19779);

return statearr_19806;
})();
var statearr_19807_19830 = state_19799__$1;
(statearr_19807_19830[(2)] = null);

(statearr_19807_19830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (3))){
var inst_19797 = (state_19799[(2)]);
var state_19799__$1 = state_19799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19799__$1,inst_19797);
} else {
if((state_val_19800 === (2))){
var state_19799__$1 = state_19799;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19799__$1,(4),pub_chan);
} else {
if((state_val_19800 === (11))){
var _ = (function (){var statearr_19809 = state_19799;
(statearr_19809[(4)] = cljs.core.rest.call(null,(state_19799[(4)])));

return statearr_19809;
})();
var state_19799__$1 = state_19799;
var ex19808 = (state_19799__$1[(2)]);
var statearr_19810_19831 = state_19799__$1;
(statearr_19810_19831[(5)] = ex19808);


var statearr_19811_19832 = state_19799__$1;
(statearr_19811_19832[(1)] = (10));

(statearr_19811_19832[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (9))){
var inst_19792 = (state_19799[(2)]);
var state_19799__$1 = (function (){var statearr_19812 = state_19799;
(statearr_19812[(10)] = inst_19792);

return statearr_19812;
})();
var statearr_19813_19833 = state_19799__$1;
(statearr_19813_19833[(2)] = null);

(statearr_19813_19833[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (5))){
var inst_19773 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_19799__$1 = state_19799;
var statearr_19814_19834 = state_19799__$1;
(statearr_19814_19834[(2)] = inst_19773);

(statearr_19814_19834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (10))){
var inst_19778 = (state_19799[(8)]);
var inst_19779 = (state_19799[(9)]);
var inst_19780 = (state_19799[(2)]);
var inst_19781 = fluree.db.util.log.error.call(null,inst_19780,"Error sending websocket message:",inst_19778);
var inst_19782 = cljs.core.async.put_BANG_.call(null,inst_19779,false);
var state_19799__$1 = (function (){var statearr_19815 = state_19799;
(statearr_19815[(11)] = inst_19781);

return statearr_19815;
})();
var statearr_19816_19835 = state_19799__$1;
(statearr_19816_19835[(2)] = inst_19782);

(statearr_19816_19835[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19800 === (8))){
var inst_19778 = (state_19799[(8)]);
var inst_19779 = (state_19799[(9)]);
var _ = (function (){var statearr_19817 = state_19799;
(statearr_19817[(4)] = cljs.core.cons.call(null,(11),(state_19799[(4)])));

return statearr_19817;
})();
var inst_19788 = ws.send(inst_19778);
var inst_19789 = cljs.core.async.put_BANG_.call(null,inst_19779,true);
var ___$1 = (function (){var statearr_19818 = state_19799;
(statearr_19818[(4)] = cljs.core.rest.call(null,(state_19799[(4)])));

return statearr_19818;
})();
var state_19799__$1 = (function (){var statearr_19819 = state_19799;
(statearr_19819[(12)] = inst_19788);

return statearr_19819;
})();
var statearr_19820_19836 = state_19799__$1;
(statearr_19820_19836[(2)] = inst_19789);

(statearr_19820_19836[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____0 = (function (){
var statearr_19821 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19821[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__);

(statearr_19821[(1)] = (1));

return statearr_19821;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____1 = (function (state_19799){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_19799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e19822){var ex__2744__auto__ = e19822;
var statearr_19823_19837 = state_19799;
(statearr_19823_19837[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_19799[(4)]))){
var statearr_19824_19838 = state_19799;
(statearr_19824_19838[(1)] = cljs.core.first.call(null,(state_19799[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19839 = state_19799;
state_19799 = G__19839;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__ = function(state_19799){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____1.call(this,state_19799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_19825 = f__2764__auto__.call(null);
(statearr_19825[(6)] = c__2763__auto__);

return statearr_19825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2763__auto___19877 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_19864){
var state_val_19865 = (state_19864[(1)]);
if((state_val_19865 === (1))){
var inst_19843 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19844 = [open_QMARK_,timeout_chan];
var inst_19845 = (new cljs.core.PersistentVector(null,2,(5),inst_19843,inst_19844,null));
var state_19864__$1 = state_19864;
return cljs.core.async.ioc_alts_BANG_.call(null,state_19864__$1,(2),inst_19845,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_19865 === (2))){
var inst_19847 = (state_19864[(2)]);
var inst_19848 = cljs.core.nth.call(null,inst_19847,(0),null);
var inst_19849 = cljs.core.nth.call(null,inst_19847,(1),null);
var inst_19850 = cljs.core._EQ_.call(null,inst_19849,timeout_chan);
var state_19864__$1 = (function (){var statearr_19866 = state_19864;
(statearr_19866[(7)] = inst_19848);

return statearr_19866;
})();
if(inst_19850){
var statearr_19867_19878 = state_19864__$1;
(statearr_19867_19878[(1)] = (3));

} else {
var statearr_19868_19879 = state_19864__$1;
(statearr_19868_19879[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (3))){
var inst_19852 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19853 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19854 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19855 = cljs.core.PersistentHashMap.fromArrays(inst_19853,inst_19854);
var inst_19856 = cljs.core.ex_info.call(null,inst_19852,inst_19855);
var inst_19857 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_19856);
var inst_19858 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_19864__$1 = (function (){var statearr_19869 = state_19864;
(statearr_19869[(8)] = inst_19857);

return statearr_19869;
})();
var statearr_19870_19880 = state_19864__$1;
(statearr_19870_19880[(2)] = inst_19858);

(statearr_19870_19880[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (4))){
var inst_19860 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_19864__$1 = state_19864;
var statearr_19871_19881 = state_19864__$1;
(statearr_19871_19881[(2)] = inst_19860);

(statearr_19871_19881[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19865 === (5))){
var inst_19862 = (state_19864[(2)]);
var state_19864__$1 = state_19864;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19864__$1,inst_19862);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_19872 = [null,null,null,null,null,null,null,null,null];
(statearr_19872[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__);

(statearr_19872[(1)] = (1));

return statearr_19872;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____1 = (function (state_19864){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_19864);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e19873){var ex__2744__auto__ = e19873;
var statearr_19874_19882 = state_19864;
(statearr_19874_19882[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_19864[(4)]))){
var statearr_19875_19883 = state_19864;
(statearr_19875_19883[(1)] = cljs.core.first.call(null,(state_19864[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19884 = state_19864;
state_19864 = G__19884;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__ = function(state_19864){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____1.call(this,state_19864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_19876 = f__2764__auto__.call(null);
(statearr_19876[(6)] = c__2763__auto___19877);

return statearr_19876;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
