// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4253__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_12920){
var state_val_12921 = (state_12920[(1)]);
if((state_val_12921 === (7))){
var inst_12915 = (state_12920[(2)]);
var _ = (function (){var statearr_12922 = state_12920;
(statearr_12922[(4)] = cljs.core.rest.call(null,(state_12920[(4)])));

return statearr_12922;
})();
var state_12920__$1 = state_12920;
var statearr_12923_12945 = state_12920__$1;
(statearr_12923_12945[(2)] = inst_12915);

(statearr_12923_12945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (1))){
var state_12920__$1 = state_12920;
var statearr_12924_12946 = state_12920__$1;
(statearr_12924_12946[(2)] = null);

(statearr_12924_12946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (4))){
var inst_12877 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12925_12947 = state_12920__$1;
(statearr_12925_12947[(2)] = inst_12877);

(statearr_12925_12947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (6))){
var inst_12895 = (state_12920[(7)]);
var inst_12902 = (state_12920[(8)]);
var inst_12901 = cljs.core.seq.call(null,inst_12895);
var inst_12902__$1 = cljs.core.first.call(null,inst_12901);
var inst_12903 = cljs.core.next.call(null,inst_12901);
var inst_12904 = cljs.core.not.call(null,inst_12902__$1);
var state_12920__$1 = (function (){var statearr_12926 = state_12920;
(statearr_12926[(9)] = inst_12903);

(statearr_12926[(8)] = inst_12902__$1);

return statearr_12926;
})();
if(inst_12904){
var statearr_12927_12948 = state_12920__$1;
(statearr_12927_12948[(1)] = (8));

} else {
var statearr_12928_12949 = state_12920__$1;
(statearr_12928_12949[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (3))){
var inst_12918 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12920__$1,inst_12918);
} else {
if((state_val_12921 === (2))){
var _ = (function (){var statearr_12929 = state_12920;
(statearr_12929[(4)] = cljs.core.cons.call(null,(5),(state_12920[(4)])));

return statearr_12929;
})();
var inst_12890 = chs;
var inst_12891 = cljs.core.seq.call(null,inst_12890);
var inst_12892 = cljs.core.first.call(null,inst_12891);
var inst_12893 = cljs.core.next.call(null,inst_12891);
var inst_12894 = coll;
var inst_12895 = inst_12890;
var inst_12896 = inst_12894;
var state_12920__$1 = (function (){var statearr_12930 = state_12920;
(statearr_12930[(7)] = inst_12895);

(statearr_12930[(10)] = inst_12892);

(statearr_12930[(11)] = inst_12893);

(statearr_12930[(12)] = inst_12896);

return statearr_12930;
})();
var statearr_12931_12950 = state_12920__$1;
(statearr_12931_12950[(2)] = null);

(statearr_12931_12950[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (11))){
var inst_12903 = (state_12920[(9)]);
var inst_12896 = (state_12920[(12)]);
var inst_12908 = (state_12920[(2)]);
var inst_12909 = fluree.db.util.async.throw_err.call(null,inst_12908);
var inst_12910 = cljs.core.conj.call(null,inst_12896,inst_12909);
var inst_12895 = inst_12903;
var inst_12896__$1 = inst_12910;
var state_12920__$1 = (function (){var statearr_12933 = state_12920;
(statearr_12933[(7)] = inst_12895);

(statearr_12933[(12)] = inst_12896__$1);

return statearr_12933;
})();
var statearr_12934_12951 = state_12920__$1;
(statearr_12934_12951[(2)] = null);

(statearr_12934_12951[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (9))){
var inst_12902 = (state_12920[(8)]);
var state_12920__$1 = state_12920;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12920__$1,(11),inst_12902);
} else {
if((state_val_12921 === (5))){
var _ = (function (){var statearr_12935 = state_12920;
(statearr_12935[(4)] = cljs.core.rest.call(null,(state_12920[(4)])));

return statearr_12935;
})();
var state_12920__$1 = state_12920;
var ex12932 = (state_12920__$1[(2)]);
var statearr_12936_12952 = state_12920__$1;
(statearr_12936_12952[(5)] = ex12932);


var statearr_12937_12953 = state_12920__$1;
(statearr_12937_12953[(1)] = (4));

(statearr_12937_12953[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (10))){
var inst_12913 = (state_12920[(2)]);
var state_12920__$1 = state_12920;
var statearr_12938_12954 = state_12920__$1;
(statearr_12938_12954[(2)] = inst_12913);

(statearr_12938_12954[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12921 === (8))){
var inst_12896 = (state_12920[(12)]);
var state_12920__$1 = state_12920;
var statearr_12939_12955 = state_12920__$1;
(statearr_12939_12955[(2)] = inst_12896);

(statearr_12939_12955[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_12940 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12940[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__);

(statearr_12940[(1)] = (1));

return statearr_12940;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1 = (function (state_12920){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_12920);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e12941){var ex__2744__auto__ = e12941;
var statearr_12942_12956 = state_12920;
(statearr_12942_12956[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_12920[(4)]))){
var statearr_12943_12957 = state_12920;
(statearr_12943_12957[(1)] = cljs.core.first.call(null,(state_12920[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12958 = state_12920;
state_12920 = G__12958;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__ = function(state_12920){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1.call(this,state_12920);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_12944 = f__2764__auto__.call(null);
(statearr_12944[(6)] = c__2763__auto__);

return statearr_12944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_12984){
var state_val_12985 = (state_12984[(1)]);
if((state_val_12985 === (7))){
var inst_12979 = (state_12984[(2)]);
var _ = (function (){var statearr_12986 = state_12984;
(statearr_12986[(4)] = cljs.core.rest.call(null,(state_12984[(4)])));

return statearr_12986;
})();
var state_12984__$1 = state_12984;
var statearr_12987_13009 = state_12984__$1;
(statearr_12987_13009[(2)] = inst_12979);

(statearr_12987_13009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (1))){
var state_12984__$1 = state_12984;
var statearr_12988_13010 = state_12984__$1;
(statearr_12988_13010[(2)] = null);

(statearr_12988_13010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (4))){
var inst_12959 = (state_12984[(2)]);
var state_12984__$1 = state_12984;
var statearr_12989_13011 = state_12984__$1;
(statearr_12989_13011[(2)] = inst_12959);

(statearr_12989_13011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (6))){
var state_12984__$1 = state_12984;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12984__$1,(8),chan);
} else {
if((state_val_12985 === (3))){
var inst_12982 = (state_12984[(2)]);
var state_12984__$1 = state_12984;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12984__$1,inst_12982);
} else {
if((state_val_12985 === (2))){
var _ = (function (){var statearr_12990 = state_12984;
(statearr_12990[(4)] = cljs.core.cons.call(null,(5),(state_12984[(4)])));

return statearr_12990;
})();
var inst_12965 = coll;
var inst_12966 = inst_12965;
var state_12984__$1 = (function (){var statearr_12991 = state_12984;
(statearr_12991[(7)] = inst_12966);

return statearr_12991;
})();
var statearr_12992_13012 = state_12984__$1;
(statearr_12992_13012[(2)] = null);

(statearr_12992_13012[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (11))){
var inst_12977 = (state_12984[(2)]);
var state_12984__$1 = state_12984;
var statearr_12994_13013 = state_12984__$1;
(statearr_12994_13013[(2)] = inst_12977);

(statearr_12994_13013[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (9))){
var inst_12966 = (state_12984[(7)]);
var state_12984__$1 = state_12984;
var statearr_12995_13014 = state_12984__$1;
(statearr_12995_13014[(2)] = inst_12966);

(statearr_12995_13014[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (5))){
var _ = (function (){var statearr_12996 = state_12984;
(statearr_12996[(4)] = cljs.core.rest.call(null,(state_12984[(4)])));

return statearr_12996;
})();
var state_12984__$1 = state_12984;
var ex12993 = (state_12984__$1[(2)]);
var statearr_12997_13015 = state_12984__$1;
(statearr_12997_13015[(5)] = ex12993);


var statearr_12998_13016 = state_12984__$1;
(statearr_12998_13016[(1)] = (4));

(statearr_12998_13016[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (10))){
var inst_12966 = (state_12984[(7)]);
var inst_12970 = (state_12984[(8)]);
var inst_12974 = cljs.core.conj.call(null,inst_12966,inst_12970);
var inst_12966__$1 = inst_12974;
var state_12984__$1 = (function (){var statearr_12999 = state_12984;
(statearr_12999[(7)] = inst_12966__$1);

return statearr_12999;
})();
var statearr_13000_13017 = state_12984__$1;
(statearr_13000_13017[(2)] = null);

(statearr_13000_13017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12985 === (8))){
var inst_12970 = (state_12984[(8)]);
var inst_12969 = (state_12984[(2)]);
var inst_12970__$1 = fluree.db.util.async.throw_err.call(null,inst_12969);
var inst_12971 = (inst_12970__$1 == null);
var state_12984__$1 = (function (){var statearr_13001 = state_12984;
(statearr_13001[(8)] = inst_12970__$1);

return statearr_13001;
})();
if(cljs.core.truth_(inst_12971)){
var statearr_13002_13018 = state_12984__$1;
(statearr_13002_13018[(1)] = (9));

} else {
var statearr_13003_13019 = state_12984__$1;
(statearr_13003_13019[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_13004 = [null,null,null,null,null,null,null,null,null];
(statearr_13004[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__);

(statearr_13004[(1)] = (1));

return statearr_13004;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1 = (function (state_12984){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_12984);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e13005){var ex__2744__auto__ = e13005;
var statearr_13006_13020 = state_12984;
(statearr_13006_13020[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_12984[(4)]))){
var statearr_13007_13021 = state_12984;
(statearr_13007_13021[(1)] = cljs.core.first.call(null,(state_12984[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13022 = state_12984;
state_12984 = G__13022;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__ = function(state_12984){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1.call(this,state_12984);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2741__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_13008 = f__2764__auto__.call(null);
(statearr_13008[(6)] = c__2763__auto__);

return statearr_13008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
