// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17180){
var state_val_17181 = (state_17180[(1)]);
if((state_val_17181 === (7))){
var inst_17169 = (state_17180[(7)]);
var inst_17171 = fluree.db.storage.core.serde.call(null,conn);
var inst_17172 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17171,inst_17169);
var state_17180__$1 = state_17180;
var statearr_17182_17201 = state_17180__$1;
(statearr_17182_17201[(2)] = inst_17172);

(statearr_17182_17201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (1))){
var state_17180__$1 = state_17180;
var statearr_17183_17202 = state_17180__$1;
(statearr_17183_17202[(2)] = null);

(statearr_17183_17202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (4))){
var inst_17159 = (state_17180[(2)]);
var state_17180__$1 = state_17180;
var statearr_17184_17203 = state_17180__$1;
(statearr_17184_17203[(2)] = inst_17159);

(statearr_17184_17203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (6))){
var inst_17169 = (state_17180[(7)]);
var inst_17168 = (state_17180[(2)]);
var inst_17169__$1 = fluree.db.util.async.throw_err.call(null,inst_17168);
var state_17180__$1 = (function (){var statearr_17185 = state_17180;
(statearr_17185[(7)] = inst_17169__$1);

return statearr_17185;
})();
if(cljs.core.truth_(inst_17169__$1)){
var statearr_17186_17204 = state_17180__$1;
(statearr_17186_17204[(1)] = (7));

} else {
var statearr_17187_17205 = state_17180__$1;
(statearr_17187_17205[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (3))){
var inst_17178 = (state_17180[(2)]);
var state_17180__$1 = state_17180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17180__$1,inst_17178);
} else {
if((state_val_17181 === (2))){
var _ = (function (){var statearr_17189 = state_17180;
(statearr_17189[(4)] = cljs.core.cons.call(null,(5),(state_17180[(4)])));

return statearr_17189;
})();
var inst_17165 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17166 = fluree.db.storage.core.storage_read.call(null,conn,inst_17165);
var state_17180__$1 = state_17180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17180__$1,(6),inst_17166);
} else {
if((state_val_17181 === (9))){
var inst_17175 = (state_17180[(2)]);
var _ = (function (){var statearr_17190 = state_17180;
(statearr_17190[(4)] = cljs.core.rest.call(null,(state_17180[(4)])));

return statearr_17190;
})();
var state_17180__$1 = state_17180;
var statearr_17191_17206 = state_17180__$1;
(statearr_17191_17206[(2)] = inst_17175);

(statearr_17191_17206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (5))){
var _ = (function (){var statearr_17192 = state_17180;
(statearr_17192[(4)] = cljs.core.rest.call(null,(state_17180[(4)])));

return statearr_17192;
})();
var state_17180__$1 = state_17180;
var ex17188 = (state_17180__$1[(2)]);
var statearr_17193_17207 = state_17180__$1;
(statearr_17193_17207[(5)] = ex17188);


if((ex17188 instanceof Error)){
var statearr_17194_17208 = state_17180__$1;
(statearr_17194_17208[(1)] = (4));

(statearr_17194_17208[(5)] = null);

} else {
throw ex17188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (8))){
var state_17180__$1 = state_17180;
var statearr_17195_17209 = state_17180__$1;
(statearr_17195_17209[(2)] = null);

(statearr_17195_17209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2741__auto____0 = (function (){
var statearr_17196 = [null,null,null,null,null,null,null,null];
(statearr_17196[(0)] = fluree$db$storage$core$read_block_$_state_machine__2741__auto__);

(statearr_17196[(1)] = (1));

return statearr_17196;
});
var fluree$db$storage$core$read_block_$_state_machine__2741__auto____1 = (function (state_17180){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17197){var ex__2744__auto__ = e17197;
var statearr_17198_17210 = state_17180;
(statearr_17198_17210[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17180[(4)]))){
var statearr_17199_17211 = state_17180;
(statearr_17199_17211[(1)] = cljs.core.first.call(null,(state_17180[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17212 = state_17180;
state_17180 = G__17212;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2741__auto__ = function(state_17180){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2741__auto____1.call(this,state_17180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17200 = f__2764__auto__.call(null);
(statearr_17200[(6)] = c__2763__auto__);

return statearr_17200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17235){
var state_val_17236 = (state_17235[(1)]);
if((state_val_17236 === (7))){
var inst_17224 = (state_17235[(7)]);
var inst_17226 = fluree.db.storage.core.serde.call(null,conn);
var inst_17227 = fluree.db.serde.protocol._deserialize_block.call(null,inst_17226,inst_17224);
var state_17235__$1 = state_17235;
var statearr_17237_17256 = state_17235__$1;
(statearr_17237_17256[(2)] = inst_17227);

(statearr_17237_17256[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (1))){
var state_17235__$1 = state_17235;
var statearr_17238_17257 = state_17235__$1;
(statearr_17238_17257[(2)] = null);

(statearr_17238_17257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (4))){
var inst_17213 = (state_17235[(2)]);
var state_17235__$1 = state_17235;
var statearr_17239_17258 = state_17235__$1;
(statearr_17239_17258[(2)] = inst_17213);

(statearr_17239_17258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (6))){
var inst_17224 = (state_17235[(7)]);
var inst_17223 = (state_17235[(2)]);
var inst_17224__$1 = fluree.db.util.async.throw_err.call(null,inst_17223);
var state_17235__$1 = (function (){var statearr_17240 = state_17235;
(statearr_17240[(7)] = inst_17224__$1);

return statearr_17240;
})();
if(cljs.core.truth_(inst_17224__$1)){
var statearr_17241_17259 = state_17235__$1;
(statearr_17241_17259[(1)] = (7));

} else {
var statearr_17242_17260 = state_17235__$1;
(statearr_17242_17260[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (3))){
var inst_17233 = (state_17235[(2)]);
var state_17235__$1 = state_17235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17235__$1,inst_17233);
} else {
if((state_val_17236 === (2))){
var _ = (function (){var statearr_17244 = state_17235;
(statearr_17244[(4)] = cljs.core.cons.call(null,(5),(state_17235[(4)])));

return statearr_17244;
})();
var inst_17219 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_17220 = [inst_17219,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17221 = fluree.db.storage.core.storage_read.call(null,conn,inst_17220);
var state_17235__$1 = state_17235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17235__$1,(6),inst_17221);
} else {
if((state_val_17236 === (9))){
var inst_17230 = (state_17235[(2)]);
var _ = (function (){var statearr_17245 = state_17235;
(statearr_17245[(4)] = cljs.core.rest.call(null,(state_17235[(4)])));

return statearr_17245;
})();
var state_17235__$1 = state_17235;
var statearr_17246_17261 = state_17235__$1;
(statearr_17246_17261[(2)] = inst_17230);

(statearr_17246_17261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (5))){
var _ = (function (){var statearr_17247 = state_17235;
(statearr_17247[(4)] = cljs.core.rest.call(null,(state_17235[(4)])));

return statearr_17247;
})();
var state_17235__$1 = state_17235;
var ex17243 = (state_17235__$1[(2)]);
var statearr_17248_17262 = state_17235__$1;
(statearr_17248_17262[(5)] = ex17243);


if((ex17243 instanceof Error)){
var statearr_17249_17263 = state_17235__$1;
(statearr_17249_17263[(1)] = (4));

(statearr_17249_17263[(5)] = null);

} else {
throw ex17243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (8))){
var state_17235__$1 = state_17235;
var statearr_17250_17264 = state_17235__$1;
(statearr_17250_17264[(2)] = null);

(statearr_17250_17264[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0 = (function (){
var statearr_17251 = [null,null,null,null,null,null,null,null];
(statearr_17251[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__);

(statearr_17251[(1)] = (1));

return statearr_17251;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1 = (function (state_17235){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17252){var ex__2744__auto__ = e17252;
var statearr_17253_17265 = state_17235;
(statearr_17253_17265[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17235[(4)]))){
var statearr_17254_17266 = state_17235;
(statearr_17254_17266[(1)] = cljs.core.first.call(null,(state_17235[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17267 = state_17235;
state_17235 = G__17267;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__ = function(state_17235){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1.call(this,state_17235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17255 = f__2764__auto__.call(null);
(statearr_17255[(6)] = c__2763__auto__);

return statearr_17255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17291){
var state_val_17292 = (state_17291[(1)]);
if((state_val_17292 === (1))){
var state_17291__$1 = state_17291;
var statearr_17293_17307 = state_17291__$1;
(statearr_17293_17307[(2)] = null);

(statearr_17293_17307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17292 === (2))){
var _ = (function (){var statearr_17294 = state_17291;
(statearr_17294[(4)] = cljs.core.cons.call(null,(5),(state_17291[(4)])));

return statearr_17294;
})();
var inst_17274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17275 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17276 = (new cljs.core.PersistentVector(null,3,(5),inst_17274,inst_17275,null));
var inst_17277 = cljs.core.select_keys.call(null,block_data,inst_17276);
var inst_17278 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17277);
var inst_17279 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_17278);
var inst_17280 = [inst_17279,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17281 = fluree.db.storage.core.serde.call(null,conn);
var inst_17282 = fluree.db.serde.protocol._serialize_block.call(null,inst_17281,inst_17277);
var inst_17283 = fluree.db.storage.core.storage_write.call(null,conn,inst_17280,inst_17282);
var state_17291__$1 = state_17291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17291__$1,(6),inst_17283);
} else {
if((state_val_17292 === (3))){
var inst_17289 = (state_17291[(2)]);
var state_17291__$1 = state_17291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17291__$1,inst_17289);
} else {
if((state_val_17292 === (4))){
var inst_17268 = (state_17291[(2)]);
var state_17291__$1 = state_17291;
var statearr_17296_17308 = state_17291__$1;
(statearr_17296_17308[(2)] = inst_17268);

(statearr_17296_17308[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17292 === (5))){
var _ = (function (){var statearr_17297 = state_17291;
(statearr_17297[(4)] = cljs.core.rest.call(null,(state_17291[(4)])));

return statearr_17297;
})();
var state_17291__$1 = state_17291;
var ex17295 = (state_17291__$1[(2)]);
var statearr_17298_17309 = state_17291__$1;
(statearr_17298_17309[(5)] = ex17295);


if((ex17295 instanceof Error)){
var statearr_17299_17310 = state_17291__$1;
(statearr_17299_17310[(1)] = (4));

(statearr_17299_17310[(5)] = null);

} else {
throw ex17295;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17292 === (6))){
var inst_17285 = (state_17291[(2)]);
var inst_17286 = fluree.db.util.async.throw_err.call(null,inst_17285);
var _ = (function (){var statearr_17300 = state_17291;
(statearr_17300[(4)] = cljs.core.rest.call(null,(state_17291[(4)])));

return statearr_17300;
})();
var state_17291__$1 = state_17291;
var statearr_17301_17311 = state_17291__$1;
(statearr_17301_17311[(2)] = inst_17286);

(statearr_17301_17311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0 = (function (){
var statearr_17302 = [null,null,null,null,null,null,null];
(statearr_17302[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__);

(statearr_17302[(1)] = (1));

return statearr_17302;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1 = (function (state_17291){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17303){var ex__2744__auto__ = e17303;
var statearr_17304_17312 = state_17291;
(statearr_17304_17312[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17291[(4)]))){
var statearr_17305_17313 = state_17291;
(statearr_17305_17313[(1)] = cljs.core.first.call(null,(state_17291[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17314 = state_17291;
state_17291 = G__17314;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__ = function(state_17291){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1.call(this,state_17291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17306 = f__2764__auto__.call(null);
(statearr_17306[(6)] = c__2763__auto__);

return statearr_17306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17337){
var state_val_17338 = (state_17337[(1)]);
if((state_val_17338 === (1))){
var state_17337__$1 = state_17337;
var statearr_17339_17353 = state_17337__$1;
(statearr_17339_17353[(2)] = null);

(statearr_17339_17353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17338 === (2))){
var _ = (function (){var statearr_17340 = state_17337;
(statearr_17340[(4)] = cljs.core.cons.call(null,(5),(state_17337[(4)])));

return statearr_17340;
})();
var inst_17321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17322 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17323 = (new cljs.core.PersistentVector(null,3,(5),inst_17321,inst_17322,null));
var inst_17324 = cljs.core.select_keys.call(null,block_data,inst_17323);
var inst_17325 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17324);
var inst_17326 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_17325);
var inst_17327 = fluree.db.storage.core.serde.call(null,conn);
var inst_17328 = fluree.db.serde.protocol._serialize_block.call(null,inst_17327,inst_17324);
var inst_17329 = fluree.db.storage.core.storage_write.call(null,conn,inst_17326,inst_17328);
var state_17337__$1 = state_17337;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17337__$1,(6),inst_17329);
} else {
if((state_val_17338 === (3))){
var inst_17335 = (state_17337[(2)]);
var state_17337__$1 = state_17337;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17337__$1,inst_17335);
} else {
if((state_val_17338 === (4))){
var inst_17315 = (state_17337[(2)]);
var state_17337__$1 = state_17337;
var statearr_17342_17354 = state_17337__$1;
(statearr_17342_17354[(2)] = inst_17315);

(statearr_17342_17354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17338 === (5))){
var _ = (function (){var statearr_17343 = state_17337;
(statearr_17343[(4)] = cljs.core.rest.call(null,(state_17337[(4)])));

return statearr_17343;
})();
var state_17337__$1 = state_17337;
var ex17341 = (state_17337__$1[(2)]);
var statearr_17344_17355 = state_17337__$1;
(statearr_17344_17355[(5)] = ex17341);


if((ex17341 instanceof Error)){
var statearr_17345_17356 = state_17337__$1;
(statearr_17345_17356[(1)] = (4));

(statearr_17345_17356[(5)] = null);

} else {
throw ex17341;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17338 === (6))){
var inst_17331 = (state_17337[(2)]);
var inst_17332 = fluree.db.util.async.throw_err.call(null,inst_17331);
var _ = (function (){var statearr_17346 = state_17337;
(statearr_17346[(4)] = cljs.core.rest.call(null,(state_17337[(4)])));

return statearr_17346;
})();
var state_17337__$1 = state_17337;
var statearr_17347_17357 = state_17337__$1;
(statearr_17347_17357[(2)] = inst_17332);

(statearr_17347_17357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2741__auto____0 = (function (){
var statearr_17348 = [null,null,null,null,null,null,null];
(statearr_17348[(0)] = fluree$db$storage$core$write_block_$_state_machine__2741__auto__);

(statearr_17348[(1)] = (1));

return statearr_17348;
});
var fluree$db$storage$core$write_block_$_state_machine__2741__auto____1 = (function (state_17337){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17337);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17349){var ex__2744__auto__ = e17349;
var statearr_17350_17358 = state_17337;
(statearr_17350_17358[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17337[(4)]))){
var statearr_17351_17359 = state_17337;
(statearr_17351_17359[(1)] = cljs.core.first.call(null,(state_17337[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17360 = state_17337;
state_17337 = G__17360;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2741__auto__ = function(state_17337){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2741__auto____1.call(this,state_17337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17352 = f__2764__auto__.call(null);
(statearr_17352[(6)] = c__2763__auto__);

return statearr_17352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17380){
var state_val_17381 = (state_17380[(1)]);
if((state_val_17381 === (1))){
var state_17380__$1 = state_17380;
var statearr_17382_17396 = state_17380__$1;
(statearr_17382_17396[(2)] = null);

(statearr_17382_17396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17381 === (2))){
var _ = (function (){var statearr_17383 = state_17380;
(statearr_17383[(4)] = cljs.core.cons.call(null,(5),(state_17380[(4)])));

return statearr_17383;
})();
var inst_17367 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17368 = [history,next_his_key];
var inst_17369 = cljs.core.PersistentHashMap.fromArrays(inst_17367,inst_17368);
var inst_17370 = fluree.db.storage.core.serde.call(null,conn);
var inst_17371 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17370,inst_17369);
var inst_17372 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_17371);
var state_17380__$1 = state_17380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17380__$1,(6),inst_17372);
} else {
if((state_val_17381 === (3))){
var inst_17378 = (state_17380[(2)]);
var state_17380__$1 = state_17380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17380__$1,inst_17378);
} else {
if((state_val_17381 === (4))){
var inst_17361 = (state_17380[(2)]);
var state_17380__$1 = state_17380;
var statearr_17385_17397 = state_17380__$1;
(statearr_17385_17397[(2)] = inst_17361);

(statearr_17385_17397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17381 === (5))){
var _ = (function (){var statearr_17386 = state_17380;
(statearr_17386[(4)] = cljs.core.rest.call(null,(state_17380[(4)])));

return statearr_17386;
})();
var state_17380__$1 = state_17380;
var ex17384 = (state_17380__$1[(2)]);
var statearr_17387_17398 = state_17380__$1;
(statearr_17387_17398[(5)] = ex17384);


if((ex17384 instanceof Error)){
var statearr_17388_17399 = state_17380__$1;
(statearr_17388_17399[(1)] = (4));

(statearr_17388_17399[(5)] = null);

} else {
throw ex17384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17381 === (6))){
var inst_17374 = (state_17380[(2)]);
var inst_17375 = fluree.db.util.async.throw_err.call(null,inst_17374);
var _ = (function (){var statearr_17389 = state_17380;
(statearr_17389[(4)] = cljs.core.rest.call(null,(state_17380[(4)])));

return statearr_17389;
})();
var state_17380__$1 = state_17380;
var statearr_17390_17400 = state_17380__$1;
(statearr_17390_17400[(2)] = inst_17375);

(statearr_17390_17400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2741__auto____0 = (function (){
var statearr_17391 = [null,null,null,null,null,null,null];
(statearr_17391[(0)] = fluree$db$storage$core$write_history_$_state_machine__2741__auto__);

(statearr_17391[(1)] = (1));

return statearr_17391;
});
var fluree$db$storage$core$write_history_$_state_machine__2741__auto____1 = (function (state_17380){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17392){var ex__2744__auto__ = e17392;
var statearr_17393_17401 = state_17380;
(statearr_17393_17401[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17380[(4)]))){
var statearr_17394_17402 = state_17380;
(statearr_17394_17402[(1)] = cljs.core.first.call(null,(state_17380[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17403 = state_17380;
state_17380 = G__17403;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2741__auto__ = function(state_17380){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2741__auto____1.call(this,state_17380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17395 = f__2764__auto__.call(null);
(statearr_17395[(6)] = c__2763__auto__);

return statearr_17395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17429){
var state_val_17430 = (state_17429[(1)]);
if((state_val_17430 === (1))){
var state_17429__$1 = state_17429;
var statearr_17431_17448 = state_17429__$1;
(statearr_17431_17448[(2)] = null);

(statearr_17431_17448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (2))){
var inst_17410 = (state_17429[(7)]);
var _ = (function (){var statearr_17432 = state_17429;
(statearr_17432[(4)] = cljs.core.cons.call(null,(5),(state_17429[(4)])));

return statearr_17432;
})();
var inst_17410__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_17411 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17410__$1),"-his"].join('');
var inst_17412 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_17413 = [flakes,inst_17411];
var inst_17414 = cljs.core.PersistentHashMap.fromArrays(inst_17412,inst_17413);
var inst_17415 = fluree.db.storage.core.serde.call(null,conn);
var inst_17416 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_17415,inst_17414);
var inst_17417 = fluree.db.storage.core.write_history.call(null,conn,history,inst_17411,null);
var inst_17418 = fluree.db.storage.core.storage_write.call(null,conn,inst_17410__$1,inst_17416);
var state_17429__$1 = (function (){var statearr_17433 = state_17429;
(statearr_17433[(8)] = inst_17418);

(statearr_17433[(7)] = inst_17410__$1);

return statearr_17433;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17429__$1,(6),inst_17417);
} else {
if((state_val_17430 === (3))){
var inst_17427 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17429__$1,inst_17427);
} else {
if((state_val_17430 === (4))){
var inst_17404 = (state_17429[(2)]);
var state_17429__$1 = state_17429;
var statearr_17435_17449 = state_17429__$1;
(statearr_17435_17449[(2)] = inst_17404);

(statearr_17435_17449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (5))){
var _ = (function (){var statearr_17436 = state_17429;
(statearr_17436[(4)] = cljs.core.rest.call(null,(state_17429[(4)])));

return statearr_17436;
})();
var state_17429__$1 = state_17429;
var ex17434 = (state_17429__$1[(2)]);
var statearr_17437_17450 = state_17429__$1;
(statearr_17437_17450[(5)] = ex17434);


if((ex17434 instanceof Error)){
var statearr_17438_17451 = state_17429__$1;
(statearr_17438_17451[(1)] = (4));

(statearr_17438_17451[(5)] = null);

} else {
throw ex17434;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17430 === (6))){
var inst_17418 = (state_17429[(8)]);
var inst_17420 = (state_17429[(2)]);
var inst_17421 = fluree.db.util.async.throw_err.call(null,inst_17420);
var state_17429__$1 = (function (){var statearr_17439 = state_17429;
(statearr_17439[(9)] = inst_17421);

return statearr_17439;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17429__$1,(7),inst_17418);
} else {
if((state_val_17430 === (7))){
var inst_17410 = (state_17429[(7)]);
var inst_17423 = (state_17429[(2)]);
var inst_17424 = fluree.db.util.async.throw_err.call(null,inst_17423);
var _ = (function (){var statearr_17440 = state_17429;
(statearr_17440[(4)] = cljs.core.rest.call(null,(state_17429[(4)])));

return statearr_17440;
})();
var state_17429__$1 = (function (){var statearr_17441 = state_17429;
(statearr_17441[(10)] = inst_17424);

return statearr_17441;
})();
var statearr_17442_17452 = state_17429__$1;
(statearr_17442_17452[(2)] = inst_17410);

(statearr_17442_17452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_17443 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17443[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__);

(statearr_17443[(1)] = (1));

return statearr_17443;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1 = (function (state_17429){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17444){var ex__2744__auto__ = e17444;
var statearr_17445_17453 = state_17429;
(statearr_17445_17453[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17429[(4)]))){
var statearr_17446_17454 = state_17429;
(statearr_17446_17454[(1)] = cljs.core.first.call(null,(state_17429[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17455 = state_17429;
state_17429 = G__17455;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__ = function(state_17429){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1.call(this,state_17429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17447 = f__2764__auto__.call(null);
(statearr_17447[(6)] = c__2763__auto__);

return statearr_17447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17472){
var state_val_17473 = (state_17472[(1)]);
if((state_val_17473 === (1))){
var state_17472__$1 = state_17472;
var statearr_17474_17489 = state_17472__$1;
(statearr_17474_17489[(2)] = null);

(statearr_17474_17489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (2))){
var _ = (function (){var statearr_17475 = state_17472;
(statearr_17475[(4)] = cljs.core.cons.call(null,(5),(state_17472[(4)])));

return statearr_17475;
})();
var inst_17462 = fluree.db.storage.core.serde.call(null,conn);
var inst_17463 = fluree.db.serde.protocol._serialize_branch.call(null,inst_17462,data);
var inst_17464 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_17463);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17472__$1,(6),inst_17464);
} else {
if((state_val_17473 === (3))){
var inst_17470 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17472__$1,inst_17470);
} else {
if((state_val_17473 === (4))){
var inst_17456 = (state_17472[(2)]);
var state_17472__$1 = state_17472;
var statearr_17477_17490 = state_17472__$1;
(statearr_17477_17490[(2)] = inst_17456);

(statearr_17477_17490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (5))){
var _ = (function (){var statearr_17478 = state_17472;
(statearr_17478[(4)] = cljs.core.rest.call(null,(state_17472[(4)])));

return statearr_17478;
})();
var state_17472__$1 = state_17472;
var ex17476 = (state_17472__$1[(2)]);
var statearr_17479_17491 = state_17472__$1;
(statearr_17479_17491[(5)] = ex17476);


if((ex17476 instanceof Error)){
var statearr_17480_17492 = state_17472__$1;
(statearr_17480_17492[(1)] = (4));

(statearr_17480_17492[(5)] = null);

} else {
throw ex17476;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17473 === (6))){
var inst_17466 = (state_17472[(2)]);
var inst_17467 = fluree.db.util.async.throw_err.call(null,inst_17466);
var _ = (function (){var statearr_17481 = state_17472;
(statearr_17481[(4)] = cljs.core.rest.call(null,(state_17472[(4)])));

return statearr_17481;
})();
var state_17472__$1 = (function (){var statearr_17482 = state_17472;
(statearr_17482[(7)] = inst_17467);

return statearr_17482;
})();
var statearr_17483_17493 = state_17472__$1;
(statearr_17483_17493[(2)] = key);

(statearr_17483_17493[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0 = (function (){
var statearr_17484 = [null,null,null,null,null,null,null,null];
(statearr_17484[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__);

(statearr_17484[(1)] = (1));

return statearr_17484;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1 = (function (state_17472){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17472);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17485){var ex__2744__auto__ = e17485;
var statearr_17486_17494 = state_17472;
(statearr_17486_17494[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17472[(4)]))){
var statearr_17487_17495 = state_17472;
(statearr_17487_17495[(1)] = cljs.core.first.call(null,(state_17472[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17496 = state_17472;
state_17472 = G__17496;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__ = function(state_17472){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1.call(this,state_17472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17488 = f__2764__auto__.call(null);
(statearr_17488[(6)] = c__2763__auto__);

return statearr_17488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__17497_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__17497_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__17498){
var map__17499 = p__17498;
var map__17499__$1 = cljs.core.__destructure_map.call(null,map__17499);
var progress = map__17499__$1;
var garbage = cljs.core.get.call(null,map__17499__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17527){
var state_val_17528 = (state_17527[(1)]);
if((state_val_17528 === (1))){
var state_17527__$1 = state_17527;
var statearr_17529_17545 = state_17527__$1;
(statearr_17529_17545[(2)] = null);

(statearr_17529_17545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17528 === (2))){
var inst_17513 = (state_17527[(7)]);
var _ = (function (){var statearr_17530 = state_17527;
(statearr_17530[(4)] = cljs.core.cons.call(null,(5),(state_17527[(4)])));

return statearr_17530;
})();
var inst_17507 = db;
var inst_17508 = cljs.core.__destructure_map.call(null,inst_17507);
var inst_17509 = cljs.core.get.call(null,inst_17508,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17510 = cljs.core.get.call(null,inst_17508,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17511 = cljs.core.get.call(null,inst_17508,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17512 = cljs.core.get.call(null,inst_17508,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17513__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_17510,inst_17511,inst_17512);
var inst_17514 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17515 = [inst_17511,inst_17512,garbage];
var inst_17516 = cljs.core.PersistentHashMap.fromArrays(inst_17514,inst_17515);
var inst_17517 = fluree.db.storage.core.serde.call(null,inst_17509);
var inst_17518 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_17517,inst_17516);
var inst_17519 = fluree.db.storage.core.storage_write.call(null,inst_17509,inst_17513__$1,inst_17518);
var state_17527__$1 = (function (){var statearr_17531 = state_17527;
(statearr_17531[(7)] = inst_17513__$1);

return statearr_17531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17527__$1,(6),inst_17519);
} else {
if((state_val_17528 === (3))){
var inst_17525 = (state_17527[(2)]);
var state_17527__$1 = state_17527;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17527__$1,inst_17525);
} else {
if((state_val_17528 === (4))){
var inst_17500 = (state_17527[(2)]);
var state_17527__$1 = state_17527;
var statearr_17533_17546 = state_17527__$1;
(statearr_17533_17546[(2)] = inst_17500);

(statearr_17533_17546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17528 === (5))){
var _ = (function (){var statearr_17534 = state_17527;
(statearr_17534[(4)] = cljs.core.rest.call(null,(state_17527[(4)])));

return statearr_17534;
})();
var state_17527__$1 = state_17527;
var ex17532 = (state_17527__$1[(2)]);
var statearr_17535_17547 = state_17527__$1;
(statearr_17535_17547[(5)] = ex17532);


if((ex17532 instanceof Error)){
var statearr_17536_17548 = state_17527__$1;
(statearr_17536_17548[(1)] = (4));

(statearr_17536_17548[(5)] = null);

} else {
throw ex17532;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17528 === (6))){
var inst_17513 = (state_17527[(7)]);
var inst_17521 = (state_17527[(2)]);
var inst_17522 = fluree.db.util.async.throw_err.call(null,inst_17521);
var _ = (function (){var statearr_17537 = state_17527;
(statearr_17537[(4)] = cljs.core.rest.call(null,(state_17527[(4)])));

return statearr_17537;
})();
var state_17527__$1 = (function (){var statearr_17538 = state_17527;
(statearr_17538[(8)] = inst_17522);

return statearr_17538;
})();
var statearr_17539_17549 = state_17527__$1;
(statearr_17539_17549[(2)] = inst_17513);

(statearr_17539_17549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0 = (function (){
var statearr_17540 = [null,null,null,null,null,null,null,null,null];
(statearr_17540[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__);

(statearr_17540[(1)] = (1));

return statearr_17540;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1 = (function (state_17527){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17527);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17541){var ex__2744__auto__ = e17541;
var statearr_17542_17550 = state_17527;
(statearr_17542_17550[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17527[(4)]))){
var statearr_17543_17551 = state_17527;
(statearr_17543_17551[(1)] = cljs.core.first.call(null,(state_17527[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17552 = state_17527;
state_17527 = G__17552;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__ = function(state_17527){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1.call(this,state_17527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2741__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17544 = f__2764__auto__.call(null);
(statearr_17544[(6)] = c__2763__auto__);

return statearr_17544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17554 = arguments.length;
switch (G__17554) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17610){
var state_val_17611 = (state_17610[(1)]);
if((state_val_17611 === (7))){
var state_17610__$1 = state_17610;
var statearr_17612_17638 = state_17610__$1;
(statearr_17612_17638[(2)] = (0));

(statearr_17612_17638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (1))){
var state_17610__$1 = state_17610;
var statearr_17613_17639 = state_17610__$1;
(statearr_17613_17639[(2)] = null);

(statearr_17613_17639[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (4))){
var inst_17555 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
var statearr_17614_17640 = state_17610__$1;
(statearr_17614_17640[(2)] = inst_17555);

(statearr_17614_17640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (6))){
var inst_17580 = (state_17610[(7)]);
var state_17610__$1 = state_17610;
var statearr_17615_17641 = state_17610__$1;
(statearr_17615_17641[(2)] = inst_17580);

(statearr_17615_17641[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (3))){
var inst_17608 = (state_17610[(2)]);
var state_17610__$1 = state_17610;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17610__$1,inst_17608);
} else {
if((state_val_17611 === (12))){
var inst_17577 = (state_17610[(8)]);
var inst_17604 = (state_17610[(2)]);
var inst_17605 = fluree.db.util.async.throw_err.call(null,inst_17604);
var _ = (function (){var statearr_17616 = state_17610;
(statearr_17616[(4)] = cljs.core.rest.call(null,(state_17610[(4)])));

return statearr_17616;
})();
var state_17610__$1 = (function (){var statearr_17617 = state_17610;
(statearr_17617[(9)] = inst_17605);

return statearr_17617;
})();
var statearr_17618_17642 = state_17610__$1;
(statearr_17618_17642[(2)] = inst_17577);

(statearr_17618_17642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (2))){
var inst_17568 = (state_17610[(10)]);
var inst_17570 = (state_17610[(11)]);
var inst_17572 = (state_17610[(12)]);
var inst_17580 = (state_17610[(7)]);
var _ = (function (){var statearr_17619 = state_17610;
(statearr_17619[(4)] = cljs.core.cons.call(null,(5),(state_17610[(4)])));

return statearr_17619;
})();
var inst_17562 = db;
var inst_17563 = cljs.core.__destructure_map.call(null,inst_17562);
var inst_17564 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17565 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17566 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17567 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17568__$1 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17569 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17570__$1 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17571 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17572__$1 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_17573 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17574 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17575 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17576 = cljs.core.get.call(null,inst_17563,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17577 = fluree.db.storage.core.ledger_root_key.call(null,inst_17564,inst_17572__$1,inst_17570__$1);
var inst_17578 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17579 = fluree.db.storage.core.child_data.call(null,inst_17571);
var inst_17580__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17568__$1);
var state_17610__$1 = (function (){var statearr_17620 = state_17610;
(statearr_17620[(13)] = inst_17576);

(statearr_17620[(10)] = inst_17568__$1);

(statearr_17620[(11)] = inst_17570__$1);

(statearr_17620[(12)] = inst_17572__$1);

(statearr_17620[(14)] = inst_17573);

(statearr_17620[(15)] = inst_17565);

(statearr_17620[(16)] = inst_17567);

(statearr_17620[(17)] = inst_17569);

(statearr_17620[(18)] = inst_17575);

(statearr_17620[(8)] = inst_17577);

(statearr_17620[(7)] = inst_17580__$1);

(statearr_17620[(19)] = inst_17578);

(statearr_17620[(20)] = inst_17579);

(statearr_17620[(21)] = inst_17574);

(statearr_17620[(22)] = inst_17566);

return statearr_17620;
})();
if(cljs.core.truth_(inst_17580__$1)){
var statearr_17621_17643 = state_17610__$1;
(statearr_17621_17643[(1)] = (6));

} else {
var statearr_17622_17644 = state_17610__$1;
(statearr_17622_17644[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (11))){
var inst_17576 = (state_17610[(13)]);
var inst_17568 = (state_17610[(10)]);
var inst_17584 = (state_17610[(23)]);
var inst_17570 = (state_17610[(11)]);
var inst_17572 = (state_17610[(12)]);
var inst_17565 = (state_17610[(15)]);
var inst_17567 = (state_17610[(16)]);
var inst_17569 = (state_17610[(17)]);
var inst_17575 = (state_17610[(18)]);
var inst_17577 = (state_17610[(8)]);
var inst_17578 = (state_17610[(19)]);
var inst_17579 = (state_17610[(20)]);
var inst_17574 = (state_17610[(21)]);
var inst_17566 = (state_17610[(22)]);
var inst_17589 = (state_17610[(2)]);
var inst_17590 = fluree.db.storage.core.child_data.call(null,inst_17574);
var inst_17591 = fluree.db.storage.core.child_data.call(null,inst_17576);
var inst_17592 = fluree.db.util.core.current_time_millis.call(null);
var inst_17593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17594 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17595 = (new cljs.core.PersistentVector(null,2,(5),inst_17593,inst_17594,null));
var inst_17596 = cljs.core.select_keys.call(null,inst_17568,inst_17595);
var inst_17597 = fluree.db.storage.core.child_data.call(null,inst_17567);
var inst_17598 = [inst_17570,inst_17579,inst_17572,inst_17584,inst_17589,inst_17590,inst_17591,inst_17565,inst_17592,inst_17566,inst_17575,inst_17596,inst_17597];
var inst_17599 = cljs.core.PersistentHashMap.fromArrays(inst_17578,inst_17598);
var inst_17600 = fluree.db.storage.core.serde.call(null,inst_17569);
var inst_17601 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_17600,inst_17599);
var inst_17602 = fluree.db.storage.core.storage_write.call(null,inst_17569,inst_17577,inst_17601);
var state_17610__$1 = state_17610;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17610__$1,(12),inst_17602);
} else {
if((state_val_17611 === (9))){
var inst_17585 = (state_17610[(24)]);
var state_17610__$1 = state_17610;
var statearr_17624_17645 = state_17610__$1;
(statearr_17624_17645[(2)] = inst_17585);

(statearr_17624_17645[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (5))){
var _ = (function (){var statearr_17625 = state_17610;
(statearr_17625[(4)] = cljs.core.rest.call(null,(state_17610[(4)])));

return statearr_17625;
})();
var state_17610__$1 = state_17610;
var ex17623 = (state_17610__$1[(2)]);
var statearr_17626_17646 = state_17610__$1;
(statearr_17626_17646[(5)] = ex17623);


if((ex17623 instanceof Error)){
var statearr_17627_17647 = state_17610__$1;
(statearr_17627_17647[(1)] = (4));

(statearr_17627_17647[(5)] = null);

} else {
throw ex17623;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (10))){
var inst_17573 = (state_17610[(14)]);
var state_17610__$1 = state_17610;
var statearr_17628_17648 = state_17610__$1;
(statearr_17628_17648[(2)] = inst_17573);

(statearr_17628_17648[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17611 === (8))){
var inst_17585 = (state_17610[(24)]);
var inst_17584 = (state_17610[(2)]);
var inst_17585__$1 = custom_ecount;
var state_17610__$1 = (function (){var statearr_17629 = state_17610;
(statearr_17629[(23)] = inst_17584);

(statearr_17629[(24)] = inst_17585__$1);

return statearr_17629;
})();
if(cljs.core.truth_(inst_17585__$1)){
var statearr_17630_17649 = state_17610__$1;
(statearr_17630_17649[(1)] = (9));

} else {
var statearr_17631_17650 = state_17610__$1;
(statearr_17631_17650[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2741__auto__ = null;
var fluree$db$storage$core$state_machine__2741__auto____0 = (function (){
var statearr_17632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17632[(0)] = fluree$db$storage$core$state_machine__2741__auto__);

(statearr_17632[(1)] = (1));

return statearr_17632;
});
var fluree$db$storage$core$state_machine__2741__auto____1 = (function (state_17610){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17610);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17633){var ex__2744__auto__ = e17633;
var statearr_17634_17651 = state_17610;
(statearr_17634_17651[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17610[(4)]))){
var statearr_17635_17652 = state_17610;
(statearr_17635_17652[(1)] = cljs.core.first.call(null,(state_17610[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17653 = state_17610;
state_17610 = G__17653;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2741__auto__ = function(state_17610){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2741__auto____1.call(this,state_17610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2741__auto____0;
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2741__auto____1;
return fluree$db$storage$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17636 = f__2764__auto__.call(null);
(statearr_17636[(6)] = c__2763__auto__);

return statearr_17636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2763__auto___17712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17686){
var state_val_17687 = (state_17686[(1)]);
if((state_val_17687 === (7))){
var inst_17666 = (state_17686[(7)]);
var state_17686__$1 = state_17686;
var statearr_17688_17713 = state_17686__$1;
(statearr_17688_17713[(2)] = inst_17666);

(statearr_17688_17713[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (1))){
var state_17686__$1 = state_17686;
var statearr_17689_17714 = state_17686__$1;
(statearr_17689_17714[(2)] = null);

(statearr_17689_17714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (4))){
var inst_17654 = (state_17686[(2)]);
var inst_17655 = error_fn.call(null);
var inst_17656 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17654);
var inst_17657 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17686__$1 = (function (){var statearr_17690 = state_17686;
(statearr_17690[(8)] = inst_17656);

(statearr_17690[(9)] = inst_17655);

return statearr_17690;
})();
var statearr_17691_17715 = state_17686__$1;
(statearr_17691_17715[(2)] = inst_17657);

(statearr_17691_17715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (6))){
var inst_17666 = (state_17686[(7)]);
var inst_17665 = (state_17686[(10)]);
var inst_17665__$1 = (state_17686[(2)]);
var inst_17666__$1 = (inst_17665__$1 == null);
var state_17686__$1 = (function (){var statearr_17692 = state_17686;
(statearr_17692[(7)] = inst_17666__$1);

(statearr_17692[(10)] = inst_17665__$1);

return statearr_17692;
})();
if(cljs.core.truth_(inst_17666__$1)){
var statearr_17693_17716 = state_17686__$1;
(statearr_17693_17716[(1)] = (7));

} else {
var statearr_17694_17717 = state_17686__$1;
(statearr_17694_17717[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (3))){
var inst_17684 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17686__$1,inst_17684);
} else {
if((state_val_17687 === (12))){
var inst_17681 = (state_17686[(2)]);
var _ = (function (){var statearr_17695 = state_17686;
(statearr_17695[(4)] = cljs.core.rest.call(null,(state_17686[(4)])));

return statearr_17695;
})();
var state_17686__$1 = state_17686;
var statearr_17696_17718 = state_17686__$1;
(statearr_17696_17718[(2)] = inst_17681);

(statearr_17696_17718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (2))){
var _ = (function (){var statearr_17697 = state_17686;
(statearr_17697[(4)] = cljs.core.cons.call(null,(5),(state_17686[(4)])));

return statearr_17697;
})();
var inst_17663 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_17686__$1 = state_17686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17686__$1,(6),inst_17663);
} else {
if((state_val_17687 === (11))){
var inst_17665 = (state_17686[(10)]);
var inst_17675 = fluree.db.storage.core.serde.call(null,conn);
var inst_17676 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_17675,inst_17665);
var inst_17677 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17676);
var inst_17678 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_17677);
var inst_17679 = cljs.core.async.put_BANG_.call(null,return_ch,inst_17678);
var state_17686__$1 = state_17686;
var statearr_17699_17719 = state_17686__$1;
(statearr_17699_17719[(2)] = inst_17679);

(statearr_17699_17719[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (9))){
var inst_17671 = (state_17686[(2)]);
var state_17686__$1 = state_17686;
if(cljs.core.truth_(inst_17671)){
var statearr_17700_17720 = state_17686__$1;
(statearr_17700_17720[(1)] = (10));

} else {
var statearr_17701_17721 = state_17686__$1;
(statearr_17701_17721[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (5))){
var _ = (function (){var statearr_17702 = state_17686;
(statearr_17702[(4)] = cljs.core.rest.call(null,(state_17686[(4)])));

return statearr_17702;
})();
var state_17686__$1 = state_17686;
var ex17698 = (state_17686__$1[(2)]);
var statearr_17703_17722 = state_17686__$1;
(statearr_17703_17722[(5)] = ex17698);


var statearr_17704_17723 = state_17686__$1;
(statearr_17704_17723[(1)] = (4));

(statearr_17704_17723[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (10))){
var inst_17673 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_17686__$1 = state_17686;
var statearr_17705_17724 = state_17686__$1;
(statearr_17705_17724[(2)] = inst_17673);

(statearr_17705_17724[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17687 === (8))){
var inst_17665 = (state_17686[(10)]);
var inst_17669 = (inst_17665 instanceof Error);
var state_17686__$1 = state_17686;
var statearr_17706_17725 = state_17686__$1;
(statearr_17706_17725[(2)] = inst_17669);

(statearr_17706_17725[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0 = (function (){
var statearr_17707 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17707[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2741__auto__);

(statearr_17707[(1)] = (1));

return statearr_17707;
});
var fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1 = (function (state_17686){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17708){var ex__2744__auto__ = e17708;
var statearr_17709_17726 = state_17686;
(statearr_17709_17726[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17686[(4)]))){
var statearr_17710_17727 = state_17686;
(statearr_17710_17727[(1)] = cljs.core.first.call(null,(state_17686[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17728 = state_17686;
state_17686 = G__17728;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__ = function(state_17686){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1.call(this,state_17686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17711 = f__2764__auto__.call(null);
(statearr_17711[(6)] = c__2763__auto___17712);

return statearr_17711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__17730 = arguments.length;
switch (G__17730) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4251__auto__ = rhs;
if(cljs.core.truth_(and__4251__auto__)){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4251__auto__ = (rhs == null);
if(and__4251__auto__){
return leftmost_QMARK_;
} else {
return and__4251__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2763__auto___17840 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17793){
var state_val_17794 = (state_17793[(1)]);
if((state_val_17794 === (7))){
var state_17793__$1 = state_17793;
var statearr_17795_17841 = state_17793__$1;
(statearr_17795_17841[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_17795_17841[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (20))){
var inst_17772 = cljs.core.PersistentVector.EMPTY;
var state_17793__$1 = state_17793;
var statearr_17796_17842 = state_17793__$1;
(statearr_17796_17842[(2)] = inst_17772);

(statearr_17796_17842[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (1))){
var state_17793__$1 = state_17793;
var statearr_17797_17843 = state_17793__$1;
(statearr_17797_17843[(2)] = null);

(statearr_17797_17843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (24))){
var state_17793__$1 = state_17793;
var statearr_17798_17844 = state_17793__$1;
(statearr_17798_17844[(2)] = null);

(statearr_17798_17844[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (4))){
var inst_17733 = (state_17793[(2)]);
var inst_17734 = error_fn.call(null);
var inst_17735 = cljs.core.async.put_BANG_.call(null,result_ch,inst_17733);
var inst_17736 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_17793__$1 = (function (){var statearr_17799 = state_17793;
(statearr_17799[(7)] = inst_17734);

(statearr_17799[(8)] = inst_17735);

return statearr_17799;
})();
var statearr_17800_17845 = state_17793__$1;
(statearr_17800_17845[(2)] = inst_17736);

(statearr_17800_17845[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (15))){
var inst_17758 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
var statearr_17801_17846 = state_17793__$1;
(statearr_17801_17846[(2)] = inst_17758);

(statearr_17801_17846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (21))){
var inst_17775 = (state_17793[(9)]);
var inst_17747 = (state_17793[(10)]);
var inst_17745 = (state_17793[(11)]);
var inst_17746 = (state_17793[(12)]);
var inst_17762 = (state_17793[(13)]);
var inst_17782 = (state_17793[(2)]);
var inst_17783 = (function (){var base_node = inst_17745;
var first_flake = inst_17746;
var node_t = inst_17747;
var source = inst_17762;
var coll = inst_17775;
var conj_QMARK_ = inst_17782;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4253__auto__ = remove_preds;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_17784 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_17745);
var inst_17785 = cljs.core.reduce.call(null,inst_17783,inst_17784,inst_17775);
var inst_17786 = cljs.core.doall.call(null,inst_17785);
var inst_17787 = cljs.core.assoc.call(null,inst_17745,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_17786);
var inst_17788 = cljs.core.async.put_BANG_.call(null,result_ch,inst_17787);
var _ = (function (){var statearr_17802 = state_17793;
(statearr_17802[(4)] = cljs.core.rest.call(null,(state_17793[(4)])));

return statearr_17802;
})();
var state_17793__$1 = state_17793;
var statearr_17803_17847 = state_17793__$1;
(statearr_17803_17847[(2)] = inst_17788);

(statearr_17803_17847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (13))){
var state_17793__$1 = state_17793;
var statearr_17804_17848 = state_17793__$1;
(statearr_17804_17848[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_17804_17848[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (22))){
var inst_17775 = (state_17793[(9)]);
var inst_17747 = (state_17793[(10)]);
var inst_17745 = (state_17793[(11)]);
var inst_17746 = (state_17793[(12)]);
var inst_17762 = (state_17793[(13)]);
var inst_17776 = (function (){var base_node = inst_17745;
var first_flake = inst_17746;
var node_t = inst_17747;
var source = inst_17762;
var coll = inst_17775;
return (function (f){
return f.op === true;
});
})();
var state_17793__$1 = state_17793;
var statearr_17805_17849 = state_17793__$1;
(statearr_17805_17849[(2)] = inst_17776);

(statearr_17805_17849[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (6))){
var inst_17747 = (state_17793[(10)]);
var inst_17745 = (state_17793[(11)]);
var inst_17744 = (state_17793[(2)]);
var inst_17745__$1 = fluree.db.util.async.throw_err.call(null,inst_17744);
var inst_17746 = fluree.db.dbproto._first_flake.call(null,inst_17745__$1);
var inst_17747__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_17745__$1);
var inst_17748 = (inst_17747__$1 > t);
var state_17793__$1 = (function (){var statearr_17806 = state_17793;
(statearr_17806[(10)] = inst_17747__$1);

(statearr_17806[(11)] = inst_17745__$1);

(statearr_17806[(12)] = inst_17746);

return statearr_17806;
})();
if(cljs.core.truth_(inst_17748)){
var statearr_17807_17850 = state_17793__$1;
(statearr_17807_17850[(1)] = (7));

} else {
var statearr_17808_17851 = state_17793__$1;
(statearr_17808_17851[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (17))){
var inst_17746 = (state_17793[(12)]);
var inst_17763 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_17746,rhs,leftmost_QMARK_,t);
var state_17793__$1 = state_17793;
var statearr_17809_17852 = state_17793__$1;
(statearr_17809_17852[(2)] = inst_17763);

(statearr_17809_17852[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (3))){
var inst_17791 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17793__$1,inst_17791);
} else {
if((state_val_17794 === (12))){
var inst_17760 = (state_17793[(2)]);
var state_17793__$1 = state_17793;
var statearr_17810_17853 = state_17793__$1;
(statearr_17810_17853[(2)] = inst_17760);

(statearr_17810_17853[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (2))){
var _ = (function (){var statearr_17811 = state_17793;
(statearr_17811[(4)] = cljs.core.cons.call(null,(5),(state_17793[(4)])));

return statearr_17811;
})();
var inst_17742 = fluree.db.dbproto._resolve.call(null,node);
var state_17793__$1 = state_17793;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17793__$1,(6),inst_17742);
} else {
if((state_val_17794 === (23))){
var inst_17775 = (state_17793[(9)]);
var inst_17747 = (state_17793[(10)]);
var inst_17745 = (state_17793[(11)]);
var inst_17746 = (state_17793[(12)]);
var inst_17762 = (state_17793[(13)]);
var inst_17778 = (function (){var base_node = inst_17745;
var first_flake = inst_17746;
var node_t = inst_17747;
var source = inst_17762;
var coll = inst_17775;
return (function (f){
return f.op === false;
});
})();
var state_17793__$1 = state_17793;
var statearr_17812_17854 = state_17793__$1;
(statearr_17812_17854[(2)] = inst_17778);

(statearr_17812_17854[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (19))){
var inst_17765 = (state_17793[(14)]);
var inst_17768 = (state_17793[(2)]);
var inst_17769 = fluree.db.util.async.throw_err.call(null,inst_17768);
var inst_17770 = cljs.core.take_while.call(null,inst_17765,inst_17769);
var state_17793__$1 = state_17793;
var statearr_17813_17855 = state_17793__$1;
(statearr_17813_17855[(2)] = inst_17770);

(statearr_17813_17855[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (11))){
var inst_17747 = (state_17793[(10)]);
var inst_17754 = cljs.core._EQ_.call(null,inst_17747,t);
var state_17793__$1 = state_17793;
if(inst_17754){
var statearr_17815_17856 = state_17793__$1;
(statearr_17815_17856[(1)] = (13));

} else {
var statearr_17816_17857 = state_17793__$1;
(statearr_17816_17857[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (9))){
var inst_17762 = (state_17793[(13)]);
var inst_17762__$1 = (state_17793[(2)]);
var state_17793__$1 = (function (){var statearr_17817 = state_17793;
(statearr_17817[(13)] = inst_17762__$1);

return statearr_17817;
})();
var G__17818_17858 = inst_17762__$1;
var G__17818_17859__$1 = (((G__17818_17858 instanceof cljs.core.Keyword))?G__17818_17858.fqn:null);
switch (G__17818_17859__$1) {
case "novelty":
var statearr_17819_17861 = state_17793__$1;
(statearr_17819_17861[(1)] = (17));


break;
case "history":
var statearr_17820_17862 = state_17793__$1;
(statearr_17820_17862[(1)] = (18));


break;
case "none":
var statearr_17821_17863 = state_17793__$1;
(statearr_17821_17863[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17818_17859__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (5))){
var _ = (function (){var statearr_17822 = state_17793;
(statearr_17822[(4)] = cljs.core.rest.call(null,(state_17793[(4)])));

return statearr_17822;
})();
var state_17793__$1 = state_17793;
var ex17814 = (state_17793__$1[(2)]);
var statearr_17823_17864 = state_17793__$1;
(statearr_17823_17864[(5)] = ex17814);


var statearr_17824_17865 = state_17793__$1;
(statearr_17824_17865[(1)] = (4));

(statearr_17824_17865[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (14))){
var state_17793__$1 = state_17793;
var statearr_17825_17866 = state_17793__$1;
(statearr_17825_17866[(2)] = null);

(statearr_17825_17866[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (16))){
var inst_17762 = (state_17793[(13)]);
var inst_17775 = (state_17793[(2)]);
var state_17793__$1 = (function (){var statearr_17826 = state_17793;
(statearr_17826[(9)] = inst_17775);

return statearr_17826;
})();
var G__17827_17867 = inst_17762;
var G__17827_17868__$1 = (((G__17827_17867 instanceof cljs.core.Keyword))?G__17827_17867.fqn:null);
switch (G__17827_17868__$1) {
case "novelty":
var statearr_17828_17870 = state_17793__$1;
(statearr_17828_17870[(1)] = (22));


break;
case "history":
var statearr_17829_17871 = state_17793__$1;
(statearr_17829_17871[(1)] = (23));


break;
case "none":
var statearr_17830_17872 = state_17793__$1;
(statearr_17830_17872[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17827_17868__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (10))){
var state_17793__$1 = state_17793;
var statearr_17831_17873 = state_17793__$1;
(statearr_17831_17873[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_17831_17873[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17794 === (18))){
var inst_17747 = (state_17793[(10)]);
var inst_17745 = (state_17793[(11)]);
var inst_17746 = (state_17793[(12)]);
var inst_17762 = (state_17793[(13)]);
var inst_17765 = (function (){var base_node = inst_17745;
var first_flake = inst_17746;
var node_t = inst_17747;
var source = inst_17762;
return (function (p1__17732_SHARP_){
return (p1__17732_SHARP_.t <= t);
});
})();
var inst_17766 = fluree.db.dbproto._resolve_history.call(null,node);
var state_17793__$1 = (function (){var statearr_17832 = state_17793;
(statearr_17832[(14)] = inst_17765);

return statearr_17832;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17793__$1,(19),inst_17766);
} else {
if((state_val_17794 === (8))){
var inst_17747 = (state_17793[(10)]);
var inst_17751 = (inst_17747 < t);
var state_17793__$1 = state_17793;
if(cljs.core.truth_(inst_17751)){
var statearr_17833_17874 = state_17793__$1;
(statearr_17833_17874[(1)] = (10));

} else {
var statearr_17834_17875 = state_17793__$1;
(statearr_17834_17875[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0 = (function (){
var statearr_17835 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17835[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__);

(statearr_17835[(1)] = (1));

return statearr_17835;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1 = (function (state_17793){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17793);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17836){var ex__2744__auto__ = e17836;
var statearr_17837_17876 = state_17793;
(statearr_17837_17876[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17793[(4)]))){
var statearr_17838_17877 = state_17793;
(statearr_17838_17877[(1)] = cljs.core.first.call(null,(state_17793[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17878 = state_17793;
state_17793 = G__17878;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__ = function(state_17793){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1.call(this,state_17793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2741__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17839 = f__2764__auto__.call(null);
(statearr_17839[(6)] = c__2763__auto___17840);

return statearr_17839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_17938){
var state_val_17939 = (state_17938[(1)]);
if((state_val_17939 === (7))){
var inst_17889 = (state_17938[(7)]);
var inst_17893 = (inst_17889 <= from_t);
var state_17938__$1 = state_17938;
var statearr_17940_17980 = state_17938__$1;
(statearr_17940_17980[(2)] = inst_17893);

(statearr_17940_17980[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (20))){
var inst_17923 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_17924 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17923)].join('');
var inst_17925 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17926 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_17927 = cljs.core.PersistentHashMap.fromArrays(inst_17925,inst_17926);
var inst_17928 = cljs.core.ex_info.call(null,inst_17924,inst_17927);
var inst_17929 = (function(){throw inst_17928})();
var state_17938__$1 = state_17938;
var statearr_17941_17981 = state_17938__$1;
(statearr_17941_17981[(2)] = inst_17929);

(statearr_17941_17981[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (1))){
var state_17938__$1 = state_17938;
var statearr_17942_17982 = state_17938__$1;
(statearr_17942_17982[(2)] = null);

(statearr_17942_17982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (4))){
var inst_17881 = (state_17938[(2)]);
var inst_17882 = fluree.db.util.log.error.call(null,inst_17881);
var inst_17883 = (function(){throw inst_17881})();
var state_17938__$1 = (function (){var statearr_17943 = state_17938;
(statearr_17943[(8)] = inst_17882);

return statearr_17943;
})();
var statearr_17944_17983 = state_17938__$1;
(statearr_17944_17983[(2)] = inst_17883);

(statearr_17944_17983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (15))){
var inst_17908 = (state_17938[(2)]);
var state_17938__$1 = (function (){var statearr_17945 = state_17938;
(statearr_17945[(9)] = inst_17908);

return statearr_17945;
})();
if(cljs.core.truth_(from_t)){
var statearr_17946_17984 = state_17938__$1;
(statearr_17946_17984[(1)] = (16));

} else {
var statearr_17947_17985 = state_17938__$1;
(statearr_17947_17985[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (21))){
var inst_17919 = (state_17938[(10)]);
var inst_17917 = (state_17938[(11)]);
var inst_17918 = (state_17938[(12)]);
var inst_17931 = (state_17938[(2)]);
var inst_17932 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_17918,inst_17919,leftmost_QMARK_,to_t);
var inst_17933 = cljs.core.into.call(null,inst_17932,inst_17917);
var _ = (function (){var statearr_17948 = state_17938;
(statearr_17948[(4)] = cljs.core.rest.call(null,(state_17938[(4)])));

return statearr_17948;
})();
var state_17938__$1 = (function (){var statearr_17949 = state_17938;
(statearr_17949[(13)] = inst_17931);

return statearr_17949;
})();
var statearr_17950_17986 = state_17938__$1;
(statearr_17950_17986[(2)] = inst_17933);

(statearr_17950_17986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (13))){
var inst_17901 = (state_17938[(14)]);
var inst_17889 = (state_17938[(7)]);
var inst_17904 = (function (){var node_t = inst_17889;
var G__17897 = inst_17901;
return (function (p1__17879_SHARP_){
return (p1__17879_SHARP_.t < to_t);
});
})();
var inst_17905 = cljs.core.drop_while.call(null,inst_17904,inst_17901);
var state_17938__$1 = state_17938;
var statearr_17951_17987 = state_17938__$1;
(statearr_17951_17987[(2)] = inst_17905);

(statearr_17951_17987[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (6))){
var inst_17890 = (state_17938[(15)]);
var state_17938__$1 = state_17938;
var statearr_17952_17988 = state_17938__$1;
(statearr_17952_17988[(2)] = inst_17890);

(statearr_17952_17988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (17))){
var inst_17908 = (state_17938[(9)]);
var state_17938__$1 = state_17938;
var statearr_17953_17989 = state_17938__$1;
(statearr_17953_17989[(2)] = inst_17908);

(statearr_17953_17989[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (3))){
var inst_17936 = (state_17938[(2)]);
var state_17938__$1 = state_17938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17938__$1,inst_17936);
} else {
if((state_val_17939 === (12))){
var inst_17889 = (state_17938[(7)]);
var inst_17900 = (state_17938[(2)]);
var inst_17901 = fluree.db.util.async.throw_err.call(null,inst_17900);
var inst_17902 = (to_t > inst_17889);
var state_17938__$1 = (function (){var statearr_17954 = state_17938;
(statearr_17954[(14)] = inst_17901);

return statearr_17954;
})();
if(cljs.core.truth_(inst_17902)){
var statearr_17955_17990 = state_17938__$1;
(statearr_17955_17990[(1)] = (13));

} else {
var statearr_17956_17991 = state_17938__$1;
(statearr_17956_17991[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (2))){
var inst_17890 = (state_17938[(15)]);
var _ = (function (){var statearr_17957 = state_17938;
(statearr_17957[(4)] = cljs.core.cons.call(null,(5),(state_17938[(4)])));

return statearr_17957;
})();
var inst_17889 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_17890__$1 = (from_t == null);
var state_17938__$1 = (function (){var statearr_17958 = state_17938;
(statearr_17958[(7)] = inst_17889);

(statearr_17958[(15)] = inst_17890__$1);

return statearr_17958;
})();
if(cljs.core.truth_(inst_17890__$1)){
var statearr_17959_17992 = state_17938__$1;
(statearr_17959_17992[(1)] = (6));

} else {
var statearr_17960_17993 = state_17938__$1;
(statearr_17960_17993[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (19))){
var state_17938__$1 = state_17938;
var statearr_17961_17994 = state_17938__$1;
(statearr_17961_17994[(2)] = null);

(statearr_17961_17994[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (11))){
var inst_17917 = (state_17938[(2)]);
var inst_17918 = fluree.db.dbproto._first_flake.call(null,node);
var inst_17919 = fluree.db.dbproto._rhs.call(null,node);
var inst_17920 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_17938__$1 = (function (){var statearr_17963 = state_17938;
(statearr_17963[(10)] = inst_17919);

(statearr_17963[(11)] = inst_17917);

(statearr_17963[(12)] = inst_17918);

return statearr_17963;
})();
if(cljs.core.truth_(inst_17920)){
var statearr_17964_17995 = state_17938__$1;
(statearr_17964_17995[(1)] = (19));

} else {
var statearr_17965_17996 = state_17938__$1;
(statearr_17965_17996[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (9))){
var inst_17898 = fluree.db.dbproto._resolve_history.call(null,node);
var state_17938__$1 = state_17938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17938__$1,(12),inst_17898);
} else {
if((state_val_17939 === (5))){
var _ = (function (){var statearr_17966 = state_17938;
(statearr_17966[(4)] = cljs.core.rest.call(null,(state_17938[(4)])));

return statearr_17966;
})();
var state_17938__$1 = state_17938;
var ex17962 = (state_17938__$1[(2)]);
var statearr_17967_17997 = state_17938__$1;
(statearr_17967_17997[(5)] = ex17962);


var statearr_17968_17998 = state_17938__$1;
(statearr_17968_17998[(1)] = (4));

(statearr_17968_17998[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (14))){
var inst_17901 = (state_17938[(14)]);
var state_17938__$1 = state_17938;
var statearr_17969_17999 = state_17938__$1;
(statearr_17969_17999[(2)] = inst_17901);

(statearr_17969_17999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (16))){
var inst_17908 = (state_17938[(9)]);
var inst_17889 = (state_17938[(7)]);
var inst_17910 = (function (){var node_t = inst_17889;
var G__17897 = inst_17908;
return (function (p1__17880_SHARP_){
return (p1__17880_SHARP_.t <= from_t);
});
})();
var inst_17911 = cljs.core.take_while.call(null,inst_17910,inst_17908);
var state_17938__$1 = state_17938;
var statearr_17970_18000 = state_17938__$1;
(statearr_17970_18000[(2)] = inst_17911);

(statearr_17970_18000[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (10))){
var state_17938__$1 = state_17938;
var statearr_17971_18001 = state_17938__$1;
(statearr_17971_18001[(2)] = null);

(statearr_17971_18001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (18))){
var inst_17914 = (state_17938[(2)]);
var state_17938__$1 = state_17938;
var statearr_17972_18002 = state_17938__$1;
(statearr_17972_18002[(2)] = inst_17914);

(statearr_17972_18002[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17939 === (8))){
var inst_17895 = (state_17938[(2)]);
var state_17938__$1 = state_17938;
if(cljs.core.truth_(inst_17895)){
var statearr_17973_18003 = state_17938__$1;
(statearr_17973_18003[(1)] = (9));

} else {
var statearr_17974_18004 = state_17938__$1;
(statearr_17974_18004[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0 = (function (){
var statearr_17975 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17975[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__);

(statearr_17975[(1)] = (1));

return statearr_17975;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1 = (function (state_17938){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_17938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e17976){var ex__2744__auto__ = e17976;
var statearr_17977_18005 = state_17938;
(statearr_17977_18005[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_17938[(4)]))){
var statearr_17978_18006 = state_17938;
(statearr_17978_18006[(1)] = cljs.core.first.call(null,(state_17938[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18007 = state_17938;
state_17938 = G__18007;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__ = function(state_17938){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1.call(this,state_17938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_17979 = f__2764__auto__.call(null);
(statearr_17979[(6)] = c__2763__auto__);

return statearr_17979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4253__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18028){
var state_val_18029 = (state_18028[(1)]);
if((state_val_18029 === (7))){
var inst_18017 = (state_18028[(7)]);
var inst_18019 = fluree.db.storage.core.serde.call(null,conn);
var inst_18020 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_18019,inst_18017);
var state_18028__$1 = state_18028;
var statearr_18030_18049 = state_18028__$1;
(statearr_18030_18049[(2)] = inst_18020);

(statearr_18030_18049[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (1))){
var state_18028__$1 = state_18028;
var statearr_18031_18050 = state_18028__$1;
(statearr_18031_18050[(2)] = null);

(statearr_18031_18050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (4))){
var inst_18008 = (state_18028[(2)]);
var state_18028__$1 = state_18028;
var statearr_18032_18051 = state_18028__$1;
(statearr_18032_18051[(2)] = inst_18008);

(statearr_18032_18051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (6))){
var inst_18017 = (state_18028[(7)]);
var inst_18016 = (state_18028[(2)]);
var inst_18017__$1 = fluree.db.util.async.throw_err.call(null,inst_18016);
var state_18028__$1 = (function (){var statearr_18033 = state_18028;
(statearr_18033[(7)] = inst_18017__$1);

return statearr_18033;
})();
if(cljs.core.truth_(inst_18017__$1)){
var statearr_18034_18052 = state_18028__$1;
(statearr_18034_18052[(1)] = (7));

} else {
var statearr_18035_18053 = state_18028__$1;
(statearr_18035_18053[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (3))){
var inst_18026 = (state_18028[(2)]);
var state_18028__$1 = state_18028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18028__$1,inst_18026);
} else {
if((state_val_18029 === (2))){
var _ = (function (){var statearr_18037 = state_18028;
(statearr_18037[(4)] = cljs.core.cons.call(null,(5),(state_18028[(4)])));

return statearr_18037;
})();
var inst_18014 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18028__$1 = state_18028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18028__$1,(6),inst_18014);
} else {
if((state_val_18029 === (9))){
var inst_18023 = (state_18028[(2)]);
var _ = (function (){var statearr_18038 = state_18028;
(statearr_18038[(4)] = cljs.core.rest.call(null,(state_18028[(4)])));

return statearr_18038;
})();
var state_18028__$1 = state_18028;
var statearr_18039_18054 = state_18028__$1;
(statearr_18039_18054[(2)] = inst_18023);

(statearr_18039_18054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (5))){
var _ = (function (){var statearr_18040 = state_18028;
(statearr_18040[(4)] = cljs.core.rest.call(null,(state_18028[(4)])));

return statearr_18040;
})();
var state_18028__$1 = state_18028;
var ex18036 = (state_18028__$1[(2)]);
var statearr_18041_18055 = state_18028__$1;
(statearr_18041_18055[(5)] = ex18036);


if((ex18036 instanceof Error)){
var statearr_18042_18056 = state_18028__$1;
(statearr_18042_18056[(1)] = (4));

(statearr_18042_18056[(5)] = null);

} else {
throw ex18036;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18029 === (8))){
var state_18028__$1 = state_18028;
var statearr_18043_18057 = state_18028__$1;
(statearr_18043_18057[(2)] = null);

(statearr_18043_18057[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0 = (function (){
var statearr_18044 = [null,null,null,null,null,null,null,null];
(statearr_18044[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2741__auto__);

(statearr_18044[(1)] = (1));

return statearr_18044;
});
var fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1 = (function (state_18028){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18045){var ex__2744__auto__ = e18045;
var statearr_18046_18058 = state_18028;
(statearr_18046_18058[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18028[(4)]))){
var statearr_18047_18059 = state_18028;
(statearr_18047_18059[(1)] = cljs.core.first.call(null,(state_18028[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18060 = state_18028;
state_18028 = G__18060;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__ = function(state_18028){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1.call(this,state_18028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18048 = f__2764__auto__.call(null);
(statearr_18048[(6)] = c__2763__auto__);

return statearr_18048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2763__auto___18139 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18111){
var state_val_18112 = (state_18111[(1)]);
if((state_val_18112 === (7))){
var inst_18078 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18079 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18080 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18081 = cljs.core.PersistentHashMap.fromArrays(inst_18079,inst_18080);
var inst_18082 = cljs.core.ex_info.call(null,inst_18078,inst_18081);
var inst_18083 = (function(){throw inst_18082})();
var state_18111__$1 = state_18111;
var statearr_18113_18140 = state_18111__$1;
(statearr_18113_18140[(2)] = inst_18083);

(statearr_18113_18140[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (1))){
var state_18111__$1 = state_18111;
var statearr_18114_18141 = state_18111__$1;
(statearr_18114_18141[(2)] = null);

(statearr_18114_18141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (4))){
var inst_18061 = (state_18111[(2)]);
var inst_18062 = error_fn.call(null);
var inst_18063 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18061);
var inst_18064 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18111__$1 = (function (){var statearr_18115 = state_18111;
(statearr_18115[(7)] = inst_18063);

(statearr_18115[(8)] = inst_18062);

return statearr_18115;
})();
var statearr_18116_18142 = state_18111__$1;
(statearr_18116_18142[(2)] = inst_18064);

(statearr_18116_18142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (6))){
var inst_18075 = (state_18111[(9)]);
var inst_18074 = (state_18111[(2)]);
var inst_18075__$1 = fluree.db.util.async.throw_err.call(null,inst_18074);
var inst_18076 = (inst_18075__$1 == null);
var state_18111__$1 = (function (){var statearr_18117 = state_18111;
(statearr_18117[(9)] = inst_18075__$1);

return statearr_18117;
})();
if(cljs.core.truth_(inst_18076)){
var statearr_18118_18143 = state_18111__$1;
(statearr_18118_18143[(1)] = (7));

} else {
var statearr_18119_18144 = state_18111__$1;
(statearr_18119_18144[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (3))){
var inst_18109 = (state_18111[(2)]);
var state_18111__$1 = state_18111;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18111__$1,inst_18109);
} else {
if((state_val_18112 === (12))){
var inst_18075 = (state_18111[(9)]);
var inst_18092 = (state_18111[(2)]);
var inst_18093 = cljs.core.__destructure_map.call(null,inst_18075);
var inst_18094 = cljs.core.get.call(null,inst_18093,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18095 = cljs.core.get.call(null,inst_18093,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_18096 = config;
var inst_18097 = cljs.core.__destructure_map.call(null,inst_18096);
var inst_18098 = cljs.core.get.call(null,inst_18097,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18100 = (function (){var data = inst_18075;
var _ = inst_18092;
var map__18070 = inst_18093;
var children = inst_18094;
var rhs = inst_18095;
var map__18071 = inst_18097;
var comparator = inst_18098;
return (function (idx,p__18099){
var map__18120 = p__18099;
var map__18120__$1 = cljs.core.__destructure_map.call(null,map__18120);
var child = map__18120__$1;
var id = cljs.core.get.call(null,map__18120__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__18120__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__18120__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__18120__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__18120__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4251__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return (idx === (0));
} else {
return and__4251__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_18101 = cljs.core.map_indexed.call(null,inst_18100,inst_18094);
var inst_18102 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_18101);
var inst_18103 = cljs.core.interleave.call(null,inst_18102,inst_18101);
var inst_18104 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_18098,inst_18103);
var inst_18105 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_18095,inst_18104,config,leftmost_QMARK_);
var inst_18106 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18105);
var _ = (function (){var statearr_18121 = state_18111;
(statearr_18121[(4)] = cljs.core.rest.call(null,(state_18111[(4)])));

return statearr_18121;
})();
var state_18111__$1 = state_18111;
var statearr_18122_18145 = state_18111__$1;
(statearr_18122_18145[(2)] = inst_18106);

(statearr_18122_18145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (2))){
var _ = (function (){var statearr_18123 = state_18111;
(statearr_18123[(4)] = cljs.core.cons.call(null,(5),(state_18111[(4)])));

return statearr_18123;
})();
var inst_18072 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_18111__$1 = state_18111;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18111__$1,(6),inst_18072);
} else {
if((state_val_18112 === (11))){
var state_18111__$1 = state_18111;
var statearr_18125_18146 = state_18111__$1;
(statearr_18125_18146[(2)] = null);

(statearr_18125_18146[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (9))){
var inst_18075 = (state_18111[(9)]);
var inst_18086 = (state_18111[(2)]);
var inst_18087 = fluree.db.util.core.exception_QMARK_.call(null,inst_18075);
var state_18111__$1 = (function (){var statearr_18126 = state_18111;
(statearr_18126[(10)] = inst_18086);

return statearr_18126;
})();
if(inst_18087){
var statearr_18127_18147 = state_18111__$1;
(statearr_18127_18147[(1)] = (10));

} else {
var statearr_18128_18148 = state_18111__$1;
(statearr_18128_18148[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (5))){
var _ = (function (){var statearr_18129 = state_18111;
(statearr_18129[(4)] = cljs.core.rest.call(null,(state_18111[(4)])));

return statearr_18129;
})();
var state_18111__$1 = state_18111;
var ex18124 = (state_18111__$1[(2)]);
var statearr_18130_18149 = state_18111__$1;
(statearr_18130_18149[(5)] = ex18124);


var statearr_18131_18150 = state_18111__$1;
(statearr_18131_18150[(1)] = (4));

(statearr_18131_18150[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (10))){
var inst_18075 = (state_18111[(9)]);
var inst_18089 = (function(){throw inst_18075})();
var state_18111__$1 = state_18111;
var statearr_18132_18151 = state_18111__$1;
(statearr_18132_18151[(2)] = inst_18089);

(statearr_18132_18151[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18112 === (8))){
var state_18111__$1 = state_18111;
var statearr_18133_18152 = state_18111__$1;
(statearr_18133_18152[(2)] = null);

(statearr_18133_18152[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0 = (function (){
var statearr_18134 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18134[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__);

(statearr_18134[(1)] = (1));

return statearr_18134;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1 = (function (state_18111){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18111);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18135){var ex__2744__auto__ = e18135;
var statearr_18136_18153 = state_18111;
(statearr_18136_18153[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18111[(4)]))){
var statearr_18137_18154 = state_18111;
(statearr_18137_18154[(1)] = cljs.core.first.call(null,(state_18111[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18155 = state_18111;
state_18111 = G__18155;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__ = function(state_18111){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1.call(this,state_18111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18138 = f__2764__auto__.call(null);
(statearr_18138[(6)] = c__2763__auto___18139);

return statearr_18138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18176){
var state_val_18177 = (state_18176[(1)]);
if((state_val_18177 === (7))){
var state_18176__$1 = state_18176;
var statearr_18178_18198 = state_18176__$1;
(statearr_18178_18198[(2)] = null);

(statearr_18178_18198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (1))){
var state_18176__$1 = state_18176;
var statearr_18179_18199 = state_18176__$1;
(statearr_18179_18199[(2)] = null);

(statearr_18179_18199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (4))){
var inst_18156 = (state_18176[(2)]);
var state_18176__$1 = state_18176;
var statearr_18180_18200 = state_18176__$1;
(statearr_18180_18200[(2)] = inst_18156);

(statearr_18180_18200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (6))){
var inst_18162 = (state_18176[(7)]);
var inst_18164 = fluree.db.storage.core.serde.call(null,conn);
var state_18176__$1 = (function (){var statearr_18181 = state_18176;
(statearr_18181[(8)] = inst_18164);

return statearr_18181;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18176__$1,(9),inst_18162);
} else {
if((state_val_18177 === (3))){
var inst_18174 = (state_18176[(2)]);
var state_18176__$1 = state_18176;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18176__$1,inst_18174);
} else {
if((state_val_18177 === (2))){
var inst_18162 = (state_18176[(7)]);
var _ = (function (){var statearr_18183 = state_18176;
(statearr_18183[(4)] = cljs.core.cons.call(null,(5),(state_18176[(4)])));

return statearr_18183;
})();
var inst_18162__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_18176__$1 = (function (){var statearr_18184 = state_18176;
(statearr_18184[(7)] = inst_18162__$1);

return statearr_18184;
})();
if(cljs.core.truth_(inst_18162__$1)){
var statearr_18185_18201 = state_18176__$1;
(statearr_18185_18201[(1)] = (6));

} else {
var statearr_18186_18202 = state_18176__$1;
(statearr_18186_18202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (9))){
var inst_18164 = (state_18176[(8)]);
var inst_18166 = (state_18176[(2)]);
var inst_18167 = fluree.db.util.async.throw_err.call(null,inst_18166);
var inst_18168 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_18164,inst_18167);
var state_18176__$1 = state_18176;
var statearr_18187_18203 = state_18176__$1;
(statearr_18187_18203[(2)] = inst_18168);

(statearr_18187_18203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (5))){
var _ = (function (){var statearr_18188 = state_18176;
(statearr_18188[(4)] = cljs.core.rest.call(null,(state_18176[(4)])));

return statearr_18188;
})();
var state_18176__$1 = state_18176;
var ex18182 = (state_18176__$1[(2)]);
var statearr_18189_18204 = state_18176__$1;
(statearr_18189_18204[(5)] = ex18182);


if((ex18182 instanceof Error)){
var statearr_18190_18205 = state_18176__$1;
(statearr_18190_18205[(1)] = (4));

(statearr_18190_18205[(5)] = null);

} else {
throw ex18182;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18177 === (8))){
var inst_18171 = (state_18176[(2)]);
var _ = (function (){var statearr_18191 = state_18176;
(statearr_18191[(4)] = cljs.core.rest.call(null,(state_18176[(4)])));

return statearr_18191;
})();
var state_18176__$1 = state_18176;
var statearr_18192_18206 = state_18176__$1;
(statearr_18192_18206[(2)] = inst_18171);

(statearr_18192_18206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_18193 = [null,null,null,null,null,null,null,null,null];
(statearr_18193[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__);

(statearr_18193[(1)] = (1));

return statearr_18193;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1 = (function (state_18176){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18176);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18194){var ex__2744__auto__ = e18194;
var statearr_18195_18207 = state_18176;
(statearr_18195_18207[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18176[(4)]))){
var statearr_18196_18208 = state_18176;
(statearr_18196_18208[(1)] = cljs.core.first.call(null,(state_18176[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18209 = state_18176;
state_18176 = G__18209;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__ = function(state_18176){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1.call(this,state_18176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18197 = f__2764__auto__.call(null);
(statearr_18197[(6)] = c__2763__auto__);

return statearr_18197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2763__auto___18282 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18254){
var state_val_18255 = (state_18254[(1)]);
if((state_val_18255 === (7))){
var inst_18226 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_18227 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18228 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18229 = cljs.core.PersistentHashMap.fromArrays(inst_18227,inst_18228);
var inst_18230 = cljs.core.ex_info.call(null,inst_18226,inst_18229);
var inst_18231 = (function(){throw inst_18230})();
var state_18254__$1 = state_18254;
var statearr_18256_18283 = state_18254__$1;
(statearr_18256_18283[(2)] = inst_18231);

(statearr_18256_18283[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (1))){
var state_18254__$1 = state_18254;
var statearr_18257_18284 = state_18254__$1;
(statearr_18257_18284[(2)] = null);

(statearr_18257_18284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (4))){
var inst_18210 = (state_18254[(2)]);
var inst_18211 = error_fn.call(null);
var inst_18212 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18210);
var inst_18213 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_18254__$1 = (function (){var statearr_18258 = state_18254;
(statearr_18258[(7)] = inst_18211);

(statearr_18258[(8)] = inst_18212);

return statearr_18258;
})();
var statearr_18259_18285 = state_18254__$1;
(statearr_18259_18285[(2)] = inst_18213);

(statearr_18259_18285[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (6))){
var inst_18223 = (state_18254[(9)]);
var inst_18223__$1 = (state_18254[(2)]);
var inst_18224 = (inst_18223__$1 == null);
var state_18254__$1 = (function (){var statearr_18260 = state_18254;
(statearr_18260[(9)] = inst_18223__$1);

return statearr_18260;
})();
if(cljs.core.truth_(inst_18224)){
var statearr_18261_18286 = state_18254__$1;
(statearr_18261_18286[(1)] = (7));

} else {
var statearr_18262_18287 = state_18254__$1;
(statearr_18262_18287[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (3))){
var inst_18252 = (state_18254[(2)]);
var state_18254__$1 = state_18254;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18254__$1,inst_18252);
} else {
if((state_val_18255 === (12))){
var inst_18223 = (state_18254[(9)]);
var inst_18240 = (state_18254[(2)]);
var inst_18241 = cljs.core.__destructure_map.call(null,inst_18223);
var inst_18242 = cljs.core.get.call(null,inst_18241,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18243 = cljs.core.get.call(null,inst_18241,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_18244 = config;
var inst_18245 = cljs.core.__destructure_map.call(null,inst_18244);
var inst_18246 = cljs.core.get.call(null,inst_18245,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_18247 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_18246,inst_18242);
var inst_18248 = fluree.db.index.data_node.call(null,block,t,inst_18247,rhs,config);
var inst_18249 = cljs.core.async.put_BANG_.call(null,return_ch,inst_18248);
var _ = (function (){var statearr_18263 = state_18254;
(statearr_18263[(4)] = cljs.core.rest.call(null,(state_18254[(4)])));

return statearr_18263;
})();
var state_18254__$1 = (function (){var statearr_18264 = state_18254;
(statearr_18264[(10)] = inst_18240);

(statearr_18264[(11)] = inst_18243);

return statearr_18264;
})();
var statearr_18265_18288 = state_18254__$1;
(statearr_18265_18288[(2)] = inst_18249);

(statearr_18265_18288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (2))){
var _ = (function (){var statearr_18266 = state_18254;
(statearr_18266[(4)] = cljs.core.cons.call(null,(5),(state_18254[(4)])));

return statearr_18266;
})();
var inst_18221 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_18254__$1 = state_18254;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18254__$1,(6),inst_18221);
} else {
if((state_val_18255 === (11))){
var state_18254__$1 = state_18254;
var statearr_18268_18289 = state_18254__$1;
(statearr_18268_18289[(2)] = null);

(statearr_18268_18289[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (9))){
var inst_18223 = (state_18254[(9)]);
var inst_18234 = (state_18254[(2)]);
var inst_18235 = fluree.db.util.core.exception_QMARK_.call(null,inst_18223);
var state_18254__$1 = (function (){var statearr_18269 = state_18254;
(statearr_18269[(12)] = inst_18234);

return statearr_18269;
})();
if(inst_18235){
var statearr_18270_18290 = state_18254__$1;
(statearr_18270_18290[(1)] = (10));

} else {
var statearr_18271_18291 = state_18254__$1;
(statearr_18271_18291[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (5))){
var _ = (function (){var statearr_18272 = state_18254;
(statearr_18272[(4)] = cljs.core.rest.call(null,(state_18254[(4)])));

return statearr_18272;
})();
var state_18254__$1 = state_18254;
var ex18267 = (state_18254__$1[(2)]);
var statearr_18273_18292 = state_18254__$1;
(statearr_18273_18292[(5)] = ex18267);


var statearr_18274_18293 = state_18254__$1;
(statearr_18274_18293[(1)] = (4));

(statearr_18274_18293[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (10))){
var inst_18223 = (state_18254[(9)]);
var inst_18237 = (function(){throw inst_18223})();
var state_18254__$1 = state_18254;
var statearr_18275_18294 = state_18254__$1;
(statearr_18275_18294[(2)] = inst_18237);

(statearr_18275_18294[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18255 === (8))){
var state_18254__$1 = state_18254;
var statearr_18276_18295 = state_18254__$1;
(statearr_18276_18295[(2)] = null);

(statearr_18276_18295[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0 = (function (){
var statearr_18277 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18277[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__);

(statearr_18277[(1)] = (1));

return statearr_18277;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1 = (function (state_18254){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18254);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18278){var ex__2744__auto__ = e18278;
var statearr_18279_18296 = state_18254;
(statearr_18279_18296[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18254[(4)]))){
var statearr_18280_18297 = state_18254;
(statearr_18280_18297[(1)] = cljs.core.first.call(null,(state_18254[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18298 = state_18254;
state_18254 = G__18298;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__ = function(state_18254){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1.call(this,state_18254);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18281 = f__2764__auto__.call(null);
(statearr_18281[(6)] = c__2763__auto___18282);

return statearr_18281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k18300,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__18304 = k18300;
var G__18304__$1 = (((G__18304 instanceof cljs.core.Keyword))?G__18304.fqn:null);
switch (G__18304__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k18300,else__4505__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__18305){
var vec__18306 = p__18305;
var k__4526__auto__ = cljs.core.nth.call(null,vec__18306,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__18306,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__18299){
var self__ = this;
var G__18299__$1 = this;
return (new cljs.core.RecordIter((0),G__18299__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this18301,other18302){
var self__ = this;
var this18301__$1 = this;
return (((!((other18302 == null)))) && ((((this18301__$1.constructor === other18302.constructor)) && (((cljs.core._EQ_.call(null,this18301__$1.conn,other18302.conn)) && (((cljs.core._EQ_.call(null,this18301__$1.config,other18302.config)) && (((cljs.core._EQ_.call(null,this18301__$1.network,other18302.network)) && (((cljs.core._EQ_.call(null,this18301__$1.dbid,other18302.dbid)) && (((cljs.core._EQ_.call(null,this18301__$1.id,other18302.id)) && (((cljs.core._EQ_.call(null,this18301__$1.leaf,other18302.leaf)) && (((cljs.core._EQ_.call(null,this18301__$1.first,other18302.first)) && (((cljs.core._EQ_.call(null,this18301__$1.rhs,other18302.rhs)) && (((cljs.core._EQ_.call(null,this18301__$1.size,other18302.size)) && (((cljs.core._EQ_.call(null,this18301__$1.block,other18302.block)) && (((cljs.core._EQ_.call(null,this18301__$1.t,other18302.t)) && (((cljs.core._EQ_.call(null,this18301__$1.tt_id,other18302.tt_id)) && (((cljs.core._EQ_.call(null,this18301__$1.leftmost_QMARK_,other18302.leftmost_QMARK_)) && (((cljs.core._EQ_.call(null,this18301__$1.tempid,other18302.tempid)) && (cljs.core._EQ_.call(null,this18301__$1.__extmap,other18302.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k18300){
var self__ = this;
var this__4509__auto____$1 = this;
var G__18309 = k18300;
var G__18309__$1 = (((G__18309 instanceof cljs.core.Keyword))?G__18309.fqn:null);
switch (G__18309__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k18300);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__18299){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__18310 = cljs.core.keyword_identical_QMARK_;
var expr__18311 = k__4511__auto__;
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(G__18299,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__18299,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__18299,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__18299,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__18299,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__18299,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__18299,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__18299,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__18299,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__18299,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__18299,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__18299,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__18299,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__18310.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__18311))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__18299,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__18299),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__18299){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__18299,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__18303){
var extmap__4542__auto__ = (function (){var G__18313 = cljs.core.dissoc.call(null,G__18303,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__18303)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__18313);
} else {
return G__18313;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__18303),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__18303),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4253__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__18316 = blank_db;
var map__18316__$1 = cljs.core.__destructure_map.call(null,map__18316);
var network = cljs.core.get.call(null,map__18316__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__18316__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__18316__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__18317 = root_data;
var map__18317__$1 = cljs.core.__destructure_map.call(null,map__18317);
var block = cljs.core.get.call(null,map__18317__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__18317__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__18317__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__18317__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18339){
var state_val_18340 = (state_18339[(1)]);
if((state_val_18340 === (7))){
var state_18339__$1 = state_18339;
var statearr_18341_18361 = state_18339__$1;
(statearr_18341_18361[(2)] = null);

(statearr_18341_18361[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (1))){
var state_18339__$1 = state_18339;
var statearr_18342_18362 = state_18339__$1;
(statearr_18342_18362[(2)] = null);

(statearr_18342_18362[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (4))){
var inst_18318 = (state_18339[(2)]);
var state_18339__$1 = state_18339;
var statearr_18343_18363 = state_18339__$1;
(statearr_18343_18363[(2)] = inst_18318);

(statearr_18343_18363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (6))){
var inst_18325 = (state_18339[(7)]);
var inst_18327 = fluree.db.storage.core.serde.call(null,conn);
var state_18339__$1 = (function (){var statearr_18344 = state_18339;
(statearr_18344[(8)] = inst_18327);

return statearr_18344;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18339__$1,(9),inst_18325);
} else {
if((state_val_18340 === (3))){
var inst_18337 = (state_18339[(2)]);
var state_18339__$1 = state_18339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18339__$1,inst_18337);
} else {
if((state_val_18340 === (2))){
var inst_18325 = (state_18339[(7)]);
var _ = (function (){var statearr_18346 = state_18339;
(statearr_18346[(4)] = cljs.core.cons.call(null,(5),(state_18339[(4)])));

return statearr_18346;
})();
var inst_18324 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_18325__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_18324);
var state_18339__$1 = (function (){var statearr_18347 = state_18339;
(statearr_18347[(7)] = inst_18325__$1);

return statearr_18347;
})();
if(cljs.core.truth_(inst_18325__$1)){
var statearr_18348_18364 = state_18339__$1;
(statearr_18348_18364[(1)] = (6));

} else {
var statearr_18349_18365 = state_18339__$1;
(statearr_18349_18365[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (9))){
var inst_18327 = (state_18339[(8)]);
var inst_18329 = (state_18339[(2)]);
var inst_18330 = fluree.db.util.async.throw_err.call(null,inst_18329);
var inst_18331 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_18327,inst_18330);
var state_18339__$1 = state_18339;
var statearr_18350_18366 = state_18339__$1;
(statearr_18350_18366[(2)] = inst_18331);

(statearr_18350_18366[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (5))){
var _ = (function (){var statearr_18351 = state_18339;
(statearr_18351[(4)] = cljs.core.rest.call(null,(state_18339[(4)])));

return statearr_18351;
})();
var state_18339__$1 = state_18339;
var ex18345 = (state_18339__$1[(2)]);
var statearr_18352_18367 = state_18339__$1;
(statearr_18352_18367[(5)] = ex18345);


if((ex18345 instanceof Error)){
var statearr_18353_18368 = state_18339__$1;
(statearr_18353_18368[(1)] = (4));

(statearr_18353_18368[(5)] = null);

} else {
throw ex18345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18340 === (8))){
var inst_18334 = (state_18339[(2)]);
var _ = (function (){var statearr_18354 = state_18339;
(statearr_18354[(4)] = cljs.core.rest.call(null,(state_18339[(4)])));

return statearr_18354;
})();
var state_18339__$1 = state_18339;
var statearr_18355_18369 = state_18339__$1;
(statearr_18355_18369[(2)] = inst_18334);

(statearr_18355_18369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0 = (function (){
var statearr_18356 = [null,null,null,null,null,null,null,null,null];
(statearr_18356[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__);

(statearr_18356[(1)] = (1));

return statearr_18356;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1 = (function (state_18339){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18357){var ex__2744__auto__ = e18357;
var statearr_18358_18370 = state_18339;
(statearr_18358_18370[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18339[(4)]))){
var statearr_18359_18371 = state_18339;
(statearr_18359_18371[(1)] = cljs.core.first.call(null,(state_18339[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18372 = state_18339;
state_18339 = G__18372;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__ = function(state_18339){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1.call(this,state_18339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18360 = f__2764__auto__.call(null);
(statearr_18360[(6)] = c__2763__auto__);

return statearr_18360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18394){
var state_val_18395 = (state_18394[(1)]);
if((state_val_18395 === (7))){
var inst_18383 = (state_18394[(7)]);
var inst_18385 = fluree.db.storage.core.serde.call(null,conn);
var inst_18386 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_18385,inst_18383);
var state_18394__$1 = state_18394;
var statearr_18396_18415 = state_18394__$1;
(statearr_18396_18415[(2)] = inst_18386);

(statearr_18396_18415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (1))){
var state_18394__$1 = state_18394;
var statearr_18397_18416 = state_18394__$1;
(statearr_18397_18416[(2)] = null);

(statearr_18397_18416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (4))){
var inst_18373 = (state_18394[(2)]);
var state_18394__$1 = state_18394;
var statearr_18398_18417 = state_18394__$1;
(statearr_18398_18417[(2)] = inst_18373);

(statearr_18398_18417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (6))){
var inst_18383 = (state_18394[(7)]);
var inst_18382 = (state_18394[(2)]);
var inst_18383__$1 = fluree.db.util.async.throw_err.call(null,inst_18382);
var state_18394__$1 = (function (){var statearr_18399 = state_18394;
(statearr_18399[(7)] = inst_18383__$1);

return statearr_18399;
})();
if(cljs.core.truth_(inst_18383__$1)){
var statearr_18400_18418 = state_18394__$1;
(statearr_18400_18418[(1)] = (7));

} else {
var statearr_18401_18419 = state_18394__$1;
(statearr_18401_18419[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (3))){
var inst_18392 = (state_18394[(2)]);
var state_18394__$1 = state_18394;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18394__$1,inst_18392);
} else {
if((state_val_18395 === (2))){
var _ = (function (){var statearr_18403 = state_18394;
(statearr_18403[(4)] = cljs.core.cons.call(null,(5),(state_18394[(4)])));

return statearr_18403;
})();
var inst_18379 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_18380 = fluree.db.storage.core.storage_read.call(null,conn,inst_18379);
var state_18394__$1 = state_18394;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18394__$1,(6),inst_18380);
} else {
if((state_val_18395 === (9))){
var inst_18389 = (state_18394[(2)]);
var _ = (function (){var statearr_18404 = state_18394;
(statearr_18404[(4)] = cljs.core.rest.call(null,(state_18394[(4)])));

return statearr_18404;
})();
var state_18394__$1 = state_18394;
var statearr_18405_18420 = state_18394__$1;
(statearr_18405_18420[(2)] = inst_18389);

(statearr_18405_18420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (5))){
var _ = (function (){var statearr_18406 = state_18394;
(statearr_18406[(4)] = cljs.core.rest.call(null,(state_18394[(4)])));

return statearr_18406;
})();
var state_18394__$1 = state_18394;
var ex18402 = (state_18394__$1[(2)]);
var statearr_18407_18421 = state_18394__$1;
(statearr_18407_18421[(5)] = ex18402);


if((ex18402 instanceof Error)){
var statearr_18408_18422 = state_18394__$1;
(statearr_18408_18422[(1)] = (4));

(statearr_18408_18422[(5)] = null);

} else {
throw ex18402;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18395 === (8))){
var state_18394__$1 = state_18394;
var statearr_18409_18423 = state_18394__$1;
(statearr_18409_18423[(2)] = null);

(statearr_18409_18423[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0 = (function (){
var statearr_18410 = [null,null,null,null,null,null,null,null];
(statearr_18410[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__);

(statearr_18410[(1)] = (1));

return statearr_18410;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1 = (function (state_18394){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18394);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18411){var ex__2744__auto__ = e18411;
var statearr_18412_18424 = state_18394;
(statearr_18412_18424[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18394[(4)]))){
var statearr_18413_18425 = state_18394;
(statearr_18413_18425[(1)] = cljs.core.first.call(null,(state_18394[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18426 = state_18394;
state_18394 = G__18426;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__ = function(state_18394){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1.call(this,state_18394);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2741__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18414 = f__2764__auto__.call(null);
(statearr_18414[(6)] = c__2763__auto__);

return statearr_18414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18462){
var state_val_18463 = (state_18462[(1)]);
if((state_val_18463 === (7))){
var inst_18436 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_18437 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18438 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_18439 = cljs.core.PersistentHashMap.fromArrays(inst_18437,inst_18438);
var inst_18440 = cljs.core.ex_info.call(null,inst_18436,inst_18439);
var inst_18441 = (function(){throw inst_18440})();
var state_18462__$1 = state_18462;
var statearr_18464_18486 = state_18462__$1;
(statearr_18464_18486[(2)] = inst_18441);

(statearr_18464_18486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (1))){
var state_18462__$1 = state_18462;
var statearr_18465_18487 = state_18462__$1;
(statearr_18465_18487[(2)] = null);

(statearr_18465_18487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (4))){
var inst_18427 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
var statearr_18466_18488 = state_18462__$1;
(statearr_18466_18488[(2)] = inst_18427);

(statearr_18466_18488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (6))){
var state_18462__$1 = state_18462;
var statearr_18467_18489 = state_18462__$1;
(statearr_18467_18489[(2)] = null);

(statearr_18467_18489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (3))){
var inst_18460 = (state_18462[(2)]);
var state_18462__$1 = state_18462;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18462__$1,inst_18460);
} else {
if((state_val_18463 === (2))){
var inst_18433 = (state_18462[(7)]);
var _ = (function (){var statearr_18468 = state_18462;
(statearr_18468[(4)] = cljs.core.cons.call(null,(5),(state_18462[(4)])));

return statearr_18468;
})();
var inst_18433__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_18462__$1 = (function (){var statearr_18469 = state_18462;
(statearr_18469[(7)] = inst_18433__$1);

return statearr_18469;
})();
if(cljs.core.truth_(inst_18433__$1)){
var statearr_18470_18490 = state_18462__$1;
(statearr_18470_18490[(1)] = (6));

} else {
var statearr_18471_18491 = state_18462__$1;
(statearr_18471_18491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (11))){
var inst_18452 = (state_18462[(8)]);
var inst_18455 = (state_18462[(2)]);
var inst_18456 = fluree.db.util.async.throw_err.call(null,inst_18455);
var inst_18457 = cljs.core.assoc.call(null,inst_18452,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_18456);
var _ = (function (){var statearr_18473 = state_18462;
(statearr_18473[(4)] = cljs.core.rest.call(null,(state_18462[(4)])));

return statearr_18473;
})();
var state_18462__$1 = state_18462;
var statearr_18474_18492 = state_18462__$1;
(statearr_18474_18492[(2)] = inst_18457);

(statearr_18474_18492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (9))){
var inst_18447 = (state_18462[(9)]);
var inst_18445 = (state_18462[(2)]);
var inst_18446 = fluree.db.util.async.throw_err.call(null,inst_18445);
var inst_18447__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_18446);
var inst_18448 = fluree.db.query.schema.schema_map.call(null,inst_18447__$1);
var state_18462__$1 = (function (){var statearr_18475 = state_18462;
(statearr_18475[(9)] = inst_18447__$1);

return statearr_18475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18462__$1,(10),inst_18448);
} else {
if((state_val_18463 === (5))){
var _ = (function (){var statearr_18476 = state_18462;
(statearr_18476[(4)] = cljs.core.rest.call(null,(state_18462[(4)])));

return statearr_18476;
})();
var state_18462__$1 = state_18462;
var ex18472 = (state_18462__$1[(2)]);
var statearr_18477_18493 = state_18462__$1;
(statearr_18477_18493[(5)] = ex18472);


if((ex18472 instanceof Error)){
var statearr_18478_18494 = state_18462__$1;
(statearr_18478_18494[(1)] = (4));

(statearr_18478_18494[(5)] = null);

} else {
throw ex18472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18463 === (10))){
var inst_18452 = (state_18462[(8)]);
var inst_18447 = (state_18462[(9)]);
var inst_18450 = (state_18462[(2)]);
var inst_18451 = fluree.db.util.async.throw_err.call(null,inst_18450);
var inst_18452__$1 = cljs.core.assoc.call(null,inst_18447,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_18451);
var inst_18453 = fluree.db.query.schema.setting_map.call(null,inst_18452__$1);
var state_18462__$1 = (function (){var statearr_18479 = state_18462;
(statearr_18479[(8)] = inst_18452__$1);

return statearr_18479;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18462__$1,(11),inst_18453);
} else {
if((state_val_18463 === (8))){
var inst_18433 = (state_18462[(7)]);
var inst_18443 = (state_18462[(2)]);
var state_18462__$1 = (function (){var statearr_18480 = state_18462;
(statearr_18480[(10)] = inst_18443);

return statearr_18480;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18462__$1,(9),inst_18433);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0 = (function (){
var statearr_18481 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18481[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2741__auto__);

(statearr_18481[(1)] = (1));

return statearr_18481;
});
var fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1 = (function (state_18462){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18462);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18482){var ex__2744__auto__ = e18482;
var statearr_18483_18495 = state_18462;
(statearr_18483_18495[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18462[(4)]))){
var statearr_18484_18496 = state_18462;
(statearr_18484_18496[(1)] = cljs.core.first.call(null,(state_18462[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18497 = state_18462;
state_18462 = G__18497;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__ = function(state_18462){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1.call(this,state_18462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2741__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2741__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18485 = f__2764__auto__.call(null);
(statearr_18485[(6)] = c__2763__auto__);

return statearr_18485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__18499 = arguments.length;
switch (G__18499) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18552){
var state_val_18553 = (state_18552[(1)]);
if((state_val_18553 === (7))){
var inst_18509 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_18510 = (new Error(inst_18509));
var inst_18511 = (function(){throw inst_18510})();
var state_18552__$1 = state_18552;
var statearr_18554_18594 = state_18552__$1;
(statearr_18554_18594[(2)] = inst_18511);

(statearr_18554_18594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (20))){
var inst_18543 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
var statearr_18555_18595 = state_18552__$1;
(statearr_18555_18595[(2)] = inst_18543);

(statearr_18555_18595[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (1))){
var state_18552__$1 = state_18552;
var statearr_18556_18596 = state_18552__$1;
(statearr_18556_18596[(2)] = null);

(statearr_18556_18596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (4))){
var inst_18500 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
var statearr_18557_18597 = state_18552__$1;
(statearr_18557_18597[(2)] = inst_18500);

(statearr_18557_18597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (15))){
var inst_18518 = (state_18552[(7)]);
var state_18552__$1 = state_18552;
var statearr_18558_18598 = state_18552__$1;
(statearr_18558_18598[(2)] = inst_18518);

(statearr_18558_18598[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (21))){
var inst_18522 = (state_18552[(8)]);
var inst_18517 = (state_18552[(9)]);
var inst_18518 = (state_18552[(7)]);
var inst_18536 = (inst_18517 + (1));
var inst_18537 = cljs.core.conj.call(null,inst_18518,inst_18522);
var inst_18517__$1 = inst_18536;
var inst_18518__$1 = inst_18537;
var state_18552__$1 = (function (){var statearr_18559 = state_18552;
(statearr_18559[(9)] = inst_18517__$1);

(statearr_18559[(7)] = inst_18518__$1);

return statearr_18559;
})();
var statearr_18560_18599 = state_18552__$1;
(statearr_18560_18599[(2)] = null);

(statearr_18560_18599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (13))){
var inst_18522 = (state_18552[(8)]);
var inst_18526 = (inst_18522 instanceof Error);
var state_18552__$1 = state_18552;
var statearr_18561_18600 = state_18552__$1;
(statearr_18561_18600[(2)] = inst_18526);

(statearr_18561_18600[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (22))){
var state_18552__$1 = state_18552;
var statearr_18562_18601 = state_18552__$1;
(statearr_18562_18601[(2)] = null);

(statearr_18562_18601[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (6))){
var state_18552__$1 = state_18552;
var statearr_18563_18602 = state_18552__$1;
(statearr_18563_18602[(2)] = null);

(statearr_18563_18602[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (17))){
var inst_18545 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
var statearr_18564_18603 = state_18552__$1;
(statearr_18564_18603[(2)] = inst_18545);

(statearr_18564_18603[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (3))){
var inst_18550 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18552__$1,inst_18550);
} else {
if((state_val_18553 === (12))){
var inst_18523 = (state_18552[(10)]);
var state_18552__$1 = state_18552;
var statearr_18565_18604 = state_18552__$1;
(statearr_18565_18604[(2)] = inst_18523);

(statearr_18565_18604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (2))){
var _ = (function (){var statearr_18566 = state_18552;
(statearr_18566[(4)] = cljs.core.cons.call(null,(5),(state_18552[(4)])));

return statearr_18566;
})();
var inst_18506 = (end >= start);
var state_18552__$1 = state_18552;
if(cljs.core.truth_(inst_18506)){
var statearr_18567_18605 = state_18552__$1;
(statearr_18567_18605[(1)] = (6));

} else {
var statearr_18568_18606 = state_18552__$1;
(statearr_18568_18606[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (23))){
var inst_18541 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
var statearr_18569_18607 = state_18552__$1;
(statearr_18569_18607[(2)] = inst_18541);

(statearr_18569_18607[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (19))){
var state_18552__$1 = state_18552;
var statearr_18570_18608 = state_18552__$1;
(statearr_18570_18608[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (11))){
var inst_18523 = (state_18552[(10)]);
var inst_18522 = (state_18552[(8)]);
var inst_18522__$1 = (state_18552[(2)]);
var inst_18523__$1 = (inst_18522__$1 == null);
var state_18552__$1 = (function (){var statearr_18573 = state_18552;
(statearr_18573[(10)] = inst_18523__$1);

(statearr_18573[(8)] = inst_18522__$1);

return statearr_18573;
})();
if(cljs.core.truth_(inst_18523__$1)){
var statearr_18574_18609 = state_18552__$1;
(statearr_18574_18609[(1)] = (12));

} else {
var statearr_18575_18610 = state_18552__$1;
(statearr_18575_18610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (9))){
var inst_18517 = (state_18552[(9)]);
var inst_18520 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_18517);
var state_18552__$1 = state_18552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18552__$1,(11),inst_18520);
} else {
if((state_val_18553 === (5))){
var _ = (function (){var statearr_18576 = state_18552;
(statearr_18576[(4)] = cljs.core.rest.call(null,(state_18552[(4)])));

return statearr_18576;
})();
var state_18552__$1 = state_18552;
var ex18572 = (state_18552__$1[(2)]);
var statearr_18577_18611 = state_18552__$1;
(statearr_18577_18611[(5)] = ex18572);


if((ex18572 instanceof Error)){
var statearr_18578_18612 = state_18552__$1;
(statearr_18578_18612[(1)] = (4));

(statearr_18578_18612[(5)] = null);

} else {
throw ex18572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (14))){
var inst_18528 = (state_18552[(2)]);
var state_18552__$1 = state_18552;
if(cljs.core.truth_(inst_18528)){
var statearr_18579_18613 = state_18552__$1;
(statearr_18579_18613[(1)] = (15));

} else {
var statearr_18580_18614 = state_18552__$1;
(statearr_18580_18614[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (16))){
var inst_18517 = (state_18552[(9)]);
var inst_18531 = cljs.core._EQ_.call(null,inst_18517,end);
var state_18552__$1 = state_18552;
if(inst_18531){
var statearr_18581_18615 = state_18552__$1;
(statearr_18581_18615[(1)] = (18));

} else {
var statearr_18582_18616 = state_18552__$1;
(statearr_18582_18616[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (10))){
var inst_18547 = (state_18552[(2)]);
var _ = (function (){var statearr_18583 = state_18552;
(statearr_18583[(4)] = cljs.core.rest.call(null,(state_18552[(4)])));

return statearr_18583;
})();
var state_18552__$1 = state_18552;
var statearr_18584_18617 = state_18552__$1;
(statearr_18584_18617[(2)] = inst_18547);

(statearr_18584_18617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (18))){
var inst_18522 = (state_18552[(8)]);
var inst_18518 = (state_18552[(7)]);
var inst_18533 = cljs.core.conj.call(null,inst_18518,inst_18522);
var state_18552__$1 = state_18552;
var statearr_18585_18618 = state_18552__$1;
(statearr_18585_18618[(2)] = inst_18533);

(statearr_18585_18618[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18553 === (8))){
var inst_18513 = (state_18552[(2)]);
var inst_18514 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18515 = start;
var inst_18516 = cljs.core.PersistentVector.EMPTY;
var inst_18517 = inst_18515;
var inst_18518 = inst_18516;
var state_18552__$1 = (function (){var statearr_18586 = state_18552;
(statearr_18586[(11)] = inst_18514);

(statearr_18586[(12)] = inst_18513);

(statearr_18586[(9)] = inst_18517);

(statearr_18586[(7)] = inst_18518);

return statearr_18586;
})();
var statearr_18587_18619 = state_18552__$1;
(statearr_18587_18619[(2)] = null);

(statearr_18587_18619[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2741__auto__ = null;
var fluree$db$storage$core$state_machine__2741__auto____0 = (function (){
var statearr_18588 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18588[(0)] = fluree$db$storage$core$state_machine__2741__auto__);

(statearr_18588[(1)] = (1));

return statearr_18588;
});
var fluree$db$storage$core$state_machine__2741__auto____1 = (function (state_18552){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18589){var ex__2744__auto__ = e18589;
var statearr_18590_18620 = state_18552;
(statearr_18590_18620[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18552[(4)]))){
var statearr_18591_18621 = state_18552;
(statearr_18591_18621[(1)] = cljs.core.first.call(null,(state_18552[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18622 = state_18552;
state_18552 = G__18622;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2741__auto__ = function(state_18552){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2741__auto____1.call(this,state_18552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2741__auto____0;
fluree$db$storage$core$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2741__auto____1;
return fluree$db$storage$core$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18592 = f__2764__auto__.call(null);
(statearr_18592[(6)] = c__2763__auto__);

return statearr_18592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18638){
var state_val_18639 = (state_18638[(1)]);
if((state_val_18639 === (1))){
var state_18638__$1 = state_18638;
var statearr_18640_18654 = state_18638__$1;
(statearr_18640_18654[(2)] = null);

(statearr_18640_18654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (2))){
var _ = (function (){var statearr_18641 = state_18638;
(statearr_18641[(4)] = cljs.core.cons.call(null,(5),(state_18638[(4)])));

return statearr_18641;
})();
var inst_18629 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_18638__$1 = state_18638;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18638__$1,(6),inst_18629);
} else {
if((state_val_18639 === (3))){
var inst_18636 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18638__$1,inst_18636);
} else {
if((state_val_18639 === (4))){
var inst_18623 = (state_18638[(2)]);
var state_18638__$1 = state_18638;
var statearr_18643_18655 = state_18638__$1;
(statearr_18643_18655[(2)] = inst_18623);

(statearr_18643_18655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (5))){
var _ = (function (){var statearr_18644 = state_18638;
(statearr_18644[(4)] = cljs.core.rest.call(null,(state_18638[(4)])));

return statearr_18644;
})();
var state_18638__$1 = state_18638;
var ex18642 = (state_18638__$1[(2)]);
var statearr_18645_18656 = state_18638__$1;
(statearr_18645_18656[(5)] = ex18642);


if((ex18642 instanceof Error)){
var statearr_18646_18657 = state_18638__$1;
(statearr_18646_18657[(1)] = (4));

(statearr_18646_18657[(5)] = null);

} else {
throw ex18642;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18639 === (6))){
var inst_18631 = (state_18638[(2)]);
var inst_18632 = fluree.db.util.async.throw_err.call(null,inst_18631);
var inst_18633 = cljs.core.first.call(null,inst_18632);
var _ = (function (){var statearr_18647 = state_18638;
(statearr_18647[(4)] = cljs.core.rest.call(null,(state_18638[(4)])));

return statearr_18647;
})();
var state_18638__$1 = state_18638;
var statearr_18648_18658 = state_18638__$1;
(statearr_18648_18658[(2)] = inst_18633);

(statearr_18648_18658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2741__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2741__auto____0 = (function (){
var statearr_18649 = [null,null,null,null,null,null,null];
(statearr_18649[(0)] = fluree$db$storage$core$block_$_state_machine__2741__auto__);

(statearr_18649[(1)] = (1));

return statearr_18649;
});
var fluree$db$storage$core$block_$_state_machine__2741__auto____1 = (function (state_18638){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18638);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18650){var ex__2744__auto__ = e18650;
var statearr_18651_18659 = state_18638;
(statearr_18651_18659[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18638[(4)]))){
var statearr_18652_18660 = state_18638;
(statearr_18652_18660[(1)] = cljs.core.first.call(null,(state_18638[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18661 = state_18638;
state_18638 = G__18661;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2741__auto__ = function(state_18638){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2741__auto____1.call(this,state_18638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2741__auto____0;
fluree$db$storage$core$block_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2741__auto____1;
return fluree$db$storage$core$block_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18653 = f__2764__auto__.call(null);
(statearr_18653[(6)] = c__2763__auto__);

return statearr_18653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
