// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15792){
var state_val_15793 = (state_15792[(1)]);
if((state_val_15793 === (1))){
var state_15792__$1 = state_15792;
var statearr_15794_15808 = state_15792__$1;
(statearr_15794_15808[(2)] = null);

(statearr_15794_15808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (2))){
var _ = (function (){var statearr_15795 = state_15792;
(statearr_15795[(4)] = cljs.core.cons.call(null,(5),(state_15792[(4)])));

return statearr_15795;
})();
var inst_15783 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15792__$1,(6),inst_15783);
} else {
if((state_val_15793 === (3))){
var inst_15790 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15792__$1,inst_15790);
} else {
if((state_val_15793 === (4))){
var inst_15777 = (state_15792[(2)]);
var state_15792__$1 = state_15792;
var statearr_15797_15809 = state_15792__$1;
(statearr_15797_15809[(2)] = inst_15777);

(statearr_15797_15809[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (5))){
var _ = (function (){var statearr_15798 = state_15792;
(statearr_15798[(4)] = cljs.core.rest.call(null,(state_15792[(4)])));

return statearr_15798;
})();
var state_15792__$1 = state_15792;
var ex15796 = (state_15792__$1[(2)]);
var statearr_15799_15810 = state_15792__$1;
(statearr_15799_15810[(5)] = ex15796);


if((ex15796 instanceof Error)){
var statearr_15800_15811 = state_15792__$1;
(statearr_15800_15811[(1)] = (4));

(statearr_15800_15811[(5)] = null);

} else {
throw ex15796;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15793 === (6))){
var inst_15785 = (state_15792[(2)]);
var inst_15786 = fluree.db.util.async.throw_err.call(null,inst_15785);
var inst_15787 = cljs.core.keyword.call(null,inst_15786);
var _ = (function (){var statearr_15801 = state_15792;
(statearr_15801[(4)] = cljs.core.rest.call(null,(state_15792[(4)])));

return statearr_15801;
})();
var state_15792__$1 = state_15792;
var statearr_15802_15812 = state_15792__$1;
(statearr_15802_15812[(2)] = inst_15787);

(statearr_15802_15812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____0 = (function (){
var statearr_15803 = [null,null,null,null,null,null,null];
(statearr_15803[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__);

(statearr_15803[(1)] = (1));

return statearr_15803;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____1 = (function (state_15792){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15792);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15804){var ex__2744__auto__ = e15804;
var statearr_15805_15813 = state_15792;
(statearr_15805_15813[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15792[(4)]))){
var statearr_15806_15814 = state_15792;
(statearr_15806_15814[(1)] = cljs.core.first.call(null,(state_15792[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15815 = state_15792;
state_15792 = G__15815;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__ = function(state_15792){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____1.call(this,state_15792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15807 = f__2764__auto__.call(null);
(statearr_15807[(6)] = c__2763__auto__);

return statearr_15807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15847){
var state_val_15848 = (state_15847[(1)]);
if((state_val_15848 === (7))){
var inst_15831 = (state_15847[(7)]);
var inst_15833 = cljs.core.empty_QMARK_.call(null,inst_15831);
var inst_15834 = (!(inst_15833));
var state_15847__$1 = state_15847;
var statearr_15849_15873 = state_15847__$1;
(statearr_15849_15873[(2)] = inst_15834);

(statearr_15849_15873[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (1))){
var state_15847__$1 = state_15847;
var statearr_15850_15874 = state_15847__$1;
(statearr_15850_15874[(2)] = null);

(statearr_15850_15874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (4))){
var inst_15817 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
var statearr_15851_15875 = state_15847__$1;
(statearr_15851_15875[(2)] = inst_15817);

(statearr_15851_15875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (6))){
var inst_15831 = (state_15847[(7)]);
var inst_15823 = (state_15847[(8)]);
var inst_15829 = (state_15847[(2)]);
var inst_15830 = fluree.db.util.async.throw_err.call(null,inst_15829);
var inst_15831__$1 = cljs.core.map.call(null,inst_15823,inst_15830);
var state_15847__$1 = (function (){var statearr_15852 = state_15847;
(statearr_15852[(7)] = inst_15831__$1);

return statearr_15852;
})();
if(cljs.core.truth_(inst_15831__$1)){
var statearr_15853_15876 = state_15847__$1;
(statearr_15853_15876[(1)] = (7));

} else {
var statearr_15854_15877 = state_15847__$1;
(statearr_15854_15877[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (3))){
var inst_15845 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15847__$1,inst_15845);
} else {
if((state_val_15848 === (12))){
var inst_15842 = (state_15847[(2)]);
var _ = (function (){var statearr_15855 = state_15847;
(statearr_15855[(4)] = cljs.core.rest.call(null,(state_15847[(4)])));

return statearr_15855;
})();
var state_15847__$1 = state_15847;
var statearr_15856_15878 = state_15847__$1;
(statearr_15856_15878[(2)] = inst_15842);

(statearr_15856_15878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (2))){
var _ = (function (){var statearr_15857 = state_15847;
(statearr_15857[(4)] = cljs.core.cons.call(null,(5),(state_15847[(4)])));

return statearr_15857;
})();
var inst_15823 = (function (){return (function (p1__15816_SHARP_){
return p1__15816_SHARP_.o;
});
})();
var inst_15824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15825 = [pred_id];
var inst_15826 = (new cljs.core.PersistentVector(null,1,(5),inst_15824,inst_15825,null));
var inst_15827 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15826);
var state_15847__$1 = (function (){var statearr_15858 = state_15847;
(statearr_15858[(8)] = inst_15823);

return statearr_15858;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15847__$1,(6),inst_15827);
} else {
if((state_val_15848 === (11))){
var state_15847__$1 = state_15847;
var statearr_15860_15879 = state_15847__$1;
(statearr_15860_15879[(2)] = true);

(statearr_15860_15879[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (9))){
var inst_15837 = (state_15847[(2)]);
var state_15847__$1 = state_15847;
if(cljs.core.truth_(inst_15837)){
var statearr_15861_15880 = state_15847__$1;
(statearr_15861_15880[(1)] = (10));

} else {
var statearr_15862_15881 = state_15847__$1;
(statearr_15862_15881[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (5))){
var _ = (function (){var statearr_15863 = state_15847;
(statearr_15863[(4)] = cljs.core.rest.call(null,(state_15847[(4)])));

return statearr_15863;
})();
var state_15847__$1 = state_15847;
var ex15859 = (state_15847__$1[(2)]);
var statearr_15864_15882 = state_15847__$1;
(statearr_15864_15882[(5)] = ex15859);


if((ex15859 instanceof Error)){
var statearr_15865_15883 = state_15847__$1;
(statearr_15865_15883[(1)] = (4));

(statearr_15865_15883[(5)] = null);

} else {
throw ex15859;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (10))){
var inst_15831 = (state_15847[(7)]);
var inst_15839 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_15831);
var state_15847__$1 = state_15847;
var statearr_15866_15884 = state_15847__$1;
(statearr_15866_15884[(2)] = inst_15839);

(statearr_15866_15884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15848 === (8))){
var inst_15831 = (state_15847[(7)]);
var state_15847__$1 = state_15847;
var statearr_15867_15885 = state_15847__$1;
(statearr_15867_15885[(2)] = inst_15831);

(statearr_15867_15885[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_15868 = [null,null,null,null,null,null,null,null,null];
(statearr_15868[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__);

(statearr_15868[(1)] = (1));

return statearr_15868;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____1 = (function (state_15847){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e15869){var ex__2744__auto__ = e15869;
var statearr_15870_15886 = state_15847;
(statearr_15870_15886[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15847[(4)]))){
var statearr_15871_15887 = state_15847;
(statearr_15871_15887[(1)] = cljs.core.first.call(null,(state_15847[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15888 = state_15847;
state_15847 = G__15888;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__ = function(state_15847){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____1.call(this,state_15847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_15872 = f__2764__auto__.call(null);
(statearr_15872[(6)] = c__2763__auto__);

return statearr_15872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_15969){
var state_val_15970 = (state_15969[(1)]);
if((state_val_15970 === (7))){
var state_15969__$1 = state_15969;
var statearr_15971_16008 = state_15969__$1;
(statearr_15971_16008[(2)] = flakes);

(statearr_15971_16008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (20))){
var inst_15926 = (state_15969[(7)]);
var inst_15959 = (state_15969[(2)]);
var inst_15918 = inst_15926;
var inst_15919 = inst_15959;
var state_15969__$1 = (function (){var statearr_15972 = state_15969;
(statearr_15972[(8)] = inst_15919);

(statearr_15972[(9)] = inst_15918);

return statearr_15972;
})();
var statearr_15973_16009 = state_15969__$1;
(statearr_15973_16009[(2)] = null);

(statearr_15973_16009[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (1))){
var state_15969__$1 = state_15969;
var statearr_15974_16010 = state_15969__$1;
(statearr_15974_16010[(2)] = null);

(statearr_15974_16010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (4))){
var inst_15891 = (state_15969[(2)]);
var state_15969__$1 = state_15969;
var statearr_15975_16011 = state_15969__$1;
(statearr_15975_16011[(2)] = inst_15891);

(statearr_15975_16011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (15))){
var inst_15925 = (state_15969[(10)]);
var inst_15943 = inst_15925.o;
var state_15969__$1 = state_15969;
var statearr_15976_16012 = state_15969__$1;
(statearr_15976_16012[(2)] = inst_15943);

(statearr_15976_16012[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (13))){
var inst_15962 = (state_15969[(2)]);
var state_15969__$1 = state_15969;
var statearr_15977_16013 = state_15969__$1;
(statearr_15977_16013[(2)] = inst_15962);

(statearr_15977_16013[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (6))){
var inst_15898 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_15969__$1 = state_15969;
var statearr_15978_16014 = state_15969__$1;
(statearr_15978_16014[(2)] = inst_15898);

(statearr_15978_16014[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (17))){
var inst_15940 = (state_15969[(2)]);
var inst_15941 = fluree.db.util.async.throw_err.call(null,inst_15940);
var state_15969__$1 = state_15969;
var statearr_15979_16015 = state_15969__$1;
(statearr_15979_16015[(2)] = inst_15941);

(statearr_15979_16015[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (3))){
var inst_15967 = (state_15969[(2)]);
var state_15969__$1 = state_15969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15969__$1,inst_15967);
} else {
if((state_val_15970 === (12))){
var inst_15925 = (state_15969[(10)]);
var inst_15932 = (state_15969[(11)]);
var inst_15930 = inst_15925.p;
var inst_15931 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15930);
var inst_15932__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_15931);
var inst_15933 = inst_15925.op;
var inst_15934 = inst_15933 === false;
var inst_15935 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_15932__$1);
var state_15969__$1 = (function (){var statearr_15980 = state_15969;
(statearr_15980[(12)] = inst_15934);

(statearr_15980[(11)] = inst_15932__$1);

return statearr_15980;
})();
if(inst_15935){
var statearr_15981_16016 = state_15969__$1;
(statearr_15981_16016[(1)] = (14));

} else {
var statearr_15982_16017 = state_15969__$1;
(statearr_15982_16017[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (2))){
var _ = (function (){var statearr_15983 = state_15969;
(statearr_15983[(4)] = cljs.core.cons.call(null,(5),(state_15969[(4)])));

return statearr_15983;
})();
var state_15969__$1 = state_15969;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_15984_16018 = state_15969__$1;
(statearr_15984_16018[(1)] = (6));

} else {
var statearr_15985_16019 = state_15969__$1;
(statearr_15985_16019[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (19))){
var inst_15919 = (state_15969[(8)]);
var inst_15925 = (state_15969[(10)]);
var inst_15945 = (state_15969[(13)]);
var inst_15932 = (state_15969[(11)]);
var inst_15953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15954 = inst_15925.s;
var inst_15955 = [inst_15954,inst_15932,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_15956 = (new cljs.core.PersistentVector(null,3,(5),inst_15953,inst_15955,null));
var inst_15957 = cljs.core.assoc_in.call(null,inst_15919,inst_15956,inst_15945);
var state_15969__$1 = state_15969;
var statearr_15986_16020 = state_15969__$1;
(statearr_15986_16020[(2)] = inst_15957);

(statearr_15986_16020[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (11))){
var inst_15919 = (state_15969[(8)]);
var state_15969__$1 = state_15969;
var statearr_15988_16021 = state_15969__$1;
(statearr_15988_16021[(2)] = inst_15919);

(statearr_15988_16021[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (9))){
var inst_15918 = (state_15969[(9)]);
var inst_15925 = (state_15969[(10)]);
var inst_15924 = cljs.core.seq.call(null,inst_15918);
var inst_15925__$1 = cljs.core.first.call(null,inst_15924);
var inst_15926 = cljs.core.next.call(null,inst_15924);
var inst_15927 = cljs.core.not.call(null,inst_15925__$1);
var state_15969__$1 = (function (){var statearr_15989 = state_15969;
(statearr_15989[(10)] = inst_15925__$1);

(statearr_15989[(7)] = inst_15926);

return statearr_15989;
})();
if(inst_15927){
var statearr_15990_16022 = state_15969__$1;
(statearr_15990_16022[(1)] = (11));

} else {
var statearr_15991_16023 = state_15969__$1;
(statearr_15991_16023[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (5))){
var _ = (function (){var statearr_15992 = state_15969;
(statearr_15992[(4)] = cljs.core.rest.call(null,(state_15969[(4)])));

return statearr_15992;
})();
var state_15969__$1 = state_15969;
var ex15987 = (state_15969__$1[(2)]);
var statearr_15993_16024 = state_15969__$1;
(statearr_15993_16024[(5)] = ex15987);


if((ex15987 instanceof Error)){
var statearr_15994_16025 = state_15969__$1;
(statearr_15994_16025[(1)] = (4));

(statearr_15994_16025[(5)] = null);

} else {
throw ex15987;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (14))){
var inst_15925 = (state_15969[(10)]);
var inst_15937 = inst_15925.o;
var inst_15938 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_15937,db);
var state_15969__$1 = state_15969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15969__$1,(17),inst_15938);
} else {
if((state_val_15970 === (16))){
var inst_15934 = (state_15969[(12)]);
var inst_15945 = (state_15969[(2)]);
var state_15969__$1 = (function (){var statearr_15995 = state_15969;
(statearr_15995[(13)] = inst_15945);

return statearr_15995;
})();
if(cljs.core.truth_(inst_15934)){
var statearr_15996_16026 = state_15969__$1;
(statearr_15996_16026[(1)] = (18));

} else {
var statearr_15997_16027 = state_15969__$1;
(statearr_15997_16027[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (10))){
var inst_15964 = (state_15969[(2)]);
var _ = (function (){var statearr_15998 = state_15969;
(statearr_15998[(4)] = cljs.core.rest.call(null,(state_15969[(4)])));

return statearr_15998;
})();
var state_15969__$1 = state_15969;
var statearr_15999_16028 = state_15969__$1;
(statearr_15999_16028[(2)] = inst_15964);

(statearr_15999_16028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (18))){
var inst_15919 = (state_15969[(8)]);
var inst_15925 = (state_15969[(10)]);
var inst_15945 = (state_15969[(13)]);
var inst_15932 = (state_15969[(11)]);
var inst_15947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15948 = inst_15925.s;
var inst_15949 = [inst_15948,inst_15932,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_15950 = (new cljs.core.PersistentVector(null,3,(5),inst_15947,inst_15949,null));
var inst_15951 = cljs.core.assoc_in.call(null,inst_15919,inst_15950,inst_15945);
var state_15969__$1 = state_15969;
var statearr_16000_16029 = state_15969__$1;
(statearr_16000_16029[(2)] = inst_15951);

(statearr_16000_16029[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15970 === (8))){
var inst_15901 = (state_15969[(2)]);
var inst_15902 = cljs.core.PersistentHashSet.EMPTY;
var inst_15903 = cljs.core.vals.call(null,tempids);
var inst_15904 = cljs.core.into.call(null,inst_15902,inst_15903);
var inst_15905 = (function (){var pred_flakes = inst_15901;
var is_new_QMARK_ = inst_15904;
return (function (p1__15890_SHARP_,p2__15889_SHARP_){
var f = p2__15889_SHARP_;
return cljs.core.assoc_in.call(null,p1__15890_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,f.s)));
});
})();
var inst_15906 = cljs.core.PersistentHashMap.EMPTY;
var inst_15907 = cljs.core.reduce.call(null,inst_15905,inst_15906,inst_15901);
var inst_15915 = cljs.core.seq.call(null,inst_15901);
var inst_15916 = cljs.core.first.call(null,inst_15915);
var inst_15917 = cljs.core.next.call(null,inst_15915);
var inst_15918 = inst_15901;
var inst_15919 = inst_15907;
var state_15969__$1 = (function (){var statearr_16001 = state_15969;
(statearr_16001[(14)] = inst_15916);

(statearr_16001[(8)] = inst_15919);

(statearr_16001[(9)] = inst_15918);

(statearr_16001[(15)] = inst_15917);

return statearr_16001;
})();
var statearr_16002_16030 = state_15969__$1;
(statearr_16002_16030[(2)] = null);

(statearr_16002_16030[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____0 = (function (){
var statearr_16003 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16003[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__);

(statearr_16003[(1)] = (1));

return statearr_16003;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____1 = (function (state_15969){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_15969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e16004){var ex__2744__auto__ = e16004;
var statearr_16005_16031 = state_15969;
(statearr_16005_16031[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_15969[(4)]))){
var statearr_16006_16032 = state_15969;
(statearr_16006_16032[(1)] = cljs.core.first.call(null,(state_15969[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16033 = state_15969;
state_15969 = G__16033;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__ = function(state_15969){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____1.call(this,state_15969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_16007 = f__2764__auto__.call(null);
(statearr_16007[(6)] = c__2763__auto__);

return statearr_16007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16035 = arguments.length;
switch (G__16035) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16038 = arguments.length;
switch (G__16038) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_16350){
var state_val_16351 = (state_16350[(1)]);
if((state_val_16351 === (121))){
var inst_16305 = (state_16350[(7)]);
var state_16350__$1 = state_16350;
var statearr_16352_16545 = state_16350__$1;
(statearr_16352_16545[(2)] = inst_16305);

(statearr_16352_16545[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (65))){
var inst_16204 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16204)){
var statearr_16353_16546 = state_16350__$1;
(statearr_16353_16546[(1)] = (66));

} else {
var statearr_16354_16547 = state_16350__$1;
(statearr_16354_16547[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (70))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16214 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16215 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,3,inst_16214,null);
var inst_16216 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16215,null);
var inst_16217 = inst_16216.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16217)){
var statearr_16355_16548 = state_16350__$1;
(statearr_16355_16548[(1)] = (72));

} else {
var statearr_16356_16549 = state_16350__$1;
(statearr_16356_16549[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (62))){
var inst_16194 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16357_16550 = state_16350__$1;
(statearr_16357_16550[(2)] = inst_16194);

(statearr_16357_16550[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (74))){
var inst_16300 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16358_16551 = state_16350__$1;
(statearr_16358_16551[(2)] = inst_16300);

(statearr_16358_16551[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (110))){
var inst_16327 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16327)){
var statearr_16359_16552 = state_16350__$1;
(statearr_16359_16552[(1)] = (117));

} else {
var statearr_16360_16553 = state_16350__$1;
(statearr_16360_16553[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (7))){
var inst_16345 = (state_16350[(2)]);
var _ = (function (){var statearr_16361 = state_16350;
(statearr_16361[(4)] = cljs.core.rest.call(null,(state_16350[(4)])));

return statearr_16361;
})();
var state_16350__$1 = state_16350;
var statearr_16362_16554 = state_16350__$1;
(statearr_16362_16554[(2)] = inst_16345);

(statearr_16362_16554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (59))){
var inst_16078 = (state_16350[(10)]);
var inst_16198 = (state_16350[(11)]);
var inst_16197 = (state_16350[(2)]);
var inst_16198__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16363 = state_16350;
(statearr_16363[(12)] = inst_16197);

(statearr_16363[(11)] = inst_16198__$1);

return statearr_16363;
})();
if(cljs.core.truth_(inst_16198__$1)){
var statearr_16364_16555 = state_16350__$1;
(statearr_16364_16555[(1)] = (63));

} else {
var statearr_16365_16556 = state_16350__$1;
(statearr_16365_16556[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (86))){
var inst_16240 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16366_16557 = state_16350__$1;
(statearr_16366_16557[(2)] = inst_16240);

(statearr_16366_16557[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (20))){
var inst_16104 = (state_16350[(13)]);
var inst_16078 = (state_16350[(10)]);
var inst_16104__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16367 = state_16350;
(statearr_16367[(13)] = inst_16104__$1);

return statearr_16367;
})();
if(cljs.core.truth_(inst_16104__$1)){
var statearr_16368_16558 = state_16350__$1;
(statearr_16368_16558[(1)] = (23));

} else {
var statearr_16369_16559 = state_16350__$1;
(statearr_16369_16559[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (72))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16219 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16370_16560 = state_16350__$1;
(statearr_16370_16560[(2)] = inst_16219);

(statearr_16370_16560[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (58))){
var inst_16159 = (state_16350[(14)]);
var state_16350__$1 = state_16350;
var statearr_16371_16561 = state_16350__$1;
(statearr_16371_16561[(2)] = inst_16159);

(statearr_16371_16561[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (60))){
var inst_16077 = (state_16350[(15)]);
var inst_16066 = (state_16350[(16)]);
var inst_16185 = fluree.db.dbproto._p_prop.call(null,inst_16066,new cljs.core.Keyword(null,"name","name",1843675177),inst_16077);
var inst_16186 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16185)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16187 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16188 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16189 = cljs.core.PersistentHashMap.fromArrays(inst_16187,inst_16188);
var inst_16190 = cljs.core.ex_info.call(null,inst_16186,inst_16189);
var inst_16191 = (function(){throw inst_16190})();
var state_16350__$1 = state_16350;
var statearr_16372_16562 = state_16350__$1;
(statearr_16372_16562[(2)] = inst_16191);

(statearr_16372_16562[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (27))){
var inst_16107 = (state_16350[(17)]);
var state_16350__$1 = state_16350;
var statearr_16373_16563 = state_16350__$1;
(statearr_16373_16563[(2)] = inst_16107);

(statearr_16373_16563[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (1))){
var state_16350__$1 = state_16350;
var statearr_16374_16564 = state_16350__$1;
(statearr_16374_16564[(2)] = null);

(statearr_16374_16564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (69))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16375_16565 = state_16350__$1;
(statearr_16375_16565[(2)] = inst_16197);

(statearr_16375_16565[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (101))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16278 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16376_16566 = state_16350__$1;
(statearr_16376_16566[(2)] = inst_16278);

(statearr_16376_16566[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (24))){
var inst_16104 = (state_16350[(13)]);
var state_16350__$1 = state_16350;
var statearr_16377_16567 = state_16350__$1;
(statearr_16377_16567[(2)] = inst_16104);

(statearr_16377_16567[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (102))){
var inst_16280 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16378_16568 = state_16350__$1;
(statearr_16378_16568[(2)] = inst_16280);

(statearr_16378_16568[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (55))){
var inst_16176 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16379_16569 = state_16350__$1;
(statearr_16379_16569[(2)] = inst_16176);

(statearr_16379_16569[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (85))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16238 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16380_16570 = state_16350__$1;
(statearr_16380_16570[(2)] = inst_16238);

(statearr_16380_16570[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (39))){
var inst_16141 = (state_16350[(18)]);
var state_16350__$1 = state_16350;
var statearr_16381_16571 = state_16350__$1;
(statearr_16381_16571[(2)] = inst_16141);

(statearr_16381_16571[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (88))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16382_16572 = state_16350__$1;
(statearr_16382_16572[(2)] = inst_16197);

(statearr_16382_16572[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (46))){
var inst_16078 = (state_16350[(10)]);
var inst_16160 = (state_16350[(19)]);
var inst_16159 = (state_16350[(2)]);
var inst_16160__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16383 = state_16350;
(statearr_16383[(14)] = inst_16159);

(statearr_16383[(19)] = inst_16160__$1);

return statearr_16383;
})();
if(cljs.core.truth_(inst_16160__$1)){
var statearr_16384_16573 = state_16350__$1;
(statearr_16384_16573[(1)] = (47));

} else {
var statearr_16385_16574 = state_16350__$1;
(statearr_16385_16574[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (4))){
var inst_16039 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16386_16575 = state_16350__$1;
(statearr_16386_16575[(2)] = inst_16039);

(statearr_16386_16575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (77))){
var inst_16298 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16387_16576 = state_16350__$1;
(statearr_16387_16576[(2)] = inst_16298);

(statearr_16387_16576[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (106))){
var inst_16290 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16388_16577 = state_16350__$1;
(statearr_16388_16577[(2)] = inst_16290);

(statearr_16388_16577[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (119))){
var inst_16076 = (state_16350[(20)]);
var inst_16340 = (state_16350[(2)]);
var inst_16065 = inst_16076;
var inst_16066 = inst_16340;
var state_16350__$1 = (function (){var statearr_16389 = state_16350;
(statearr_16389[(16)] = inst_16066);

(statearr_16389[(21)] = inst_16065);

return statearr_16389;
})();
var statearr_16390_16578 = state_16350__$1;
(statearr_16390_16578[(2)] = null);

(statearr_16390_16578[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (95))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16262 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16263 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,5,inst_16262,null);
var inst_16264 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16263,null);
var inst_16265 = inst_16264.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16265)){
var statearr_16391_16579 = state_16350__$1;
(statearr_16391_16579[(1)] = (96));

} else {
var statearr_16392_16580 = state_16350__$1;
(statearr_16392_16580[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (54))){
var inst_16167 = (state_16350[(22)]);
var state_16350__$1 = state_16350;
var statearr_16393_16581 = state_16350__$1;
(statearr_16393_16581[(2)] = inst_16167);

(statearr_16393_16581[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (92))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16394_16582 = state_16350__$1;
(statearr_16394_16582[(2)] = inst_16197);

(statearr_16394_16582[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (104))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16395_16583 = state_16350__$1;
(statearr_16395_16583[(2)] = inst_16197);

(statearr_16395_16583[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (15))){
var inst_16086 = (state_16350[(23)]);
var state_16350__$1 = state_16350;
var statearr_16396_16584 = state_16350__$1;
(statearr_16396_16584[(2)] = inst_16086);

(statearr_16396_16584[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (48))){
var inst_16160 = (state_16350[(19)]);
var state_16350__$1 = state_16350;
var statearr_16397_16585 = state_16350__$1;
(statearr_16397_16585[(2)] = inst_16160);

(statearr_16397_16585[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (50))){
var inst_16078 = (state_16350[(10)]);
var inst_16167 = (state_16350[(22)]);
var inst_16165 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16166 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16165);
var inst_16167__$1 = inst_16166 === true;
var state_16350__$1 = (function (){var statearr_16398 = state_16350;
(statearr_16398[(22)] = inst_16167__$1);

return statearr_16398;
})();
if(cljs.core.truth_(inst_16167__$1)){
var statearr_16399_16586 = state_16350__$1;
(statearr_16399_16586[(1)] = (53));

} else {
var statearr_16400_16587 = state_16350__$1;
(statearr_16400_16587[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (116))){
var inst_16321 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16401_16588 = state_16350__$1;
(statearr_16401_16588[(2)] = inst_16321);

(statearr_16401_16588[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (75))){
var inst_16210 = (state_16350[(9)]);
var state_16350__$1 = state_16350;
var G__16402_16589 = inst_16210;
var G__16402_16590__$1 = (((G__16402_16589 instanceof cljs.core.Keyword))?G__16402_16589.fqn:null);
switch (G__16402_16590__$1) {
case "long":
var statearr_16403_16592 = state_16350__$1;
(statearr_16403_16592[(1)] = (79));


break;
case "bigint":
var statearr_16404_16593 = state_16350__$1;
(statearr_16404_16593[(1)] = (83));


break;
case "double":
var statearr_16405_16594 = state_16350__$1;
(statearr_16405_16594[(1)] = (87));


break;
case "float":
var statearr_16406_16595 = state_16350__$1;
(statearr_16406_16595[(1)] = (91));


break;
case "bigdec":
var statearr_16407_16596 = state_16350__$1;
(statearr_16407_16596[(1)] = (95));


break;
case "string":
var statearr_16408_16597 = state_16350__$1;
(statearr_16408_16597[(1)] = (99));


break;
case "instant":
var statearr_16409_16598 = state_16350__$1;
(statearr_16409_16598[(1)] = (103));


break;
default:
var statearr_16410_16599 = state_16350__$1;
(statearr_16410_16599[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (99))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16272 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16273 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,5,inst_16272,null);
var inst_16274 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16273,null);
var inst_16275 = inst_16274.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16275)){
var statearr_16411_16600 = state_16350__$1;
(statearr_16411_16600[(1)] = (100));

} else {
var statearr_16412_16601 = state_16350__$1;
(statearr_16412_16601[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (21))){
var inst_16102 = (state_16350[(24)]);
var state_16350__$1 = state_16350;
var statearr_16413_16602 = state_16350__$1;
(statearr_16413_16602[(2)] = inst_16102);

(statearr_16413_16602[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (31))){
var inst_16118 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16414_16603 = state_16350__$1;
(statearr_16414_16603[(2)] = inst_16118);

(statearr_16414_16603[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (113))){
var inst_16324 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16415_16604 = state_16350__$1;
(statearr_16415_16604[(2)] = inst_16324);

(statearr_16415_16604[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (32))){
var state_16350__$1 = state_16350;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16416_16605 = state_16350__$1;
(statearr_16416_16605[(1)] = (35));

} else {
var statearr_16417_16606 = state_16350__$1;
(statearr_16417_16606[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (40))){
var inst_16154 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16154)){
var statearr_16418_16607 = state_16350__$1;
(statearr_16418_16607[(1)] = (44));

} else {
var statearr_16419_16608 = state_16350__$1;
(statearr_16419_16608[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (91))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16252 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16253 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,3,inst_16252,null);
var inst_16254 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16253,null);
var inst_16255 = inst_16254.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16255)){
var statearr_16420_16609 = state_16350__$1;
(statearr_16420_16609[(1)] = (92));

} else {
var statearr_16421_16610 = state_16350__$1;
(statearr_16421_16610[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (117))){
var state_16350__$1 = state_16350;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16422_16611 = state_16350__$1;
(statearr_16422_16611[(1)] = (120));

} else {
var statearr_16423_16612 = state_16350__$1;
(statearr_16423_16612[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (108))){
var inst_16309 = (state_16350[(25)]);
var inst_16078 = (state_16350[(10)]);
var inst_16309__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16424 = state_16350;
(statearr_16424[(25)] = inst_16309__$1);

return statearr_16424;
})();
if(cljs.core.truth_(inst_16309__$1)){
var statearr_16425_16613 = state_16350__$1;
(statearr_16425_16613[(1)] = (111));

} else {
var statearr_16426_16614 = state_16350__$1;
(statearr_16426_16614[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (56))){
var inst_16171 = (state_16350[(2)]);
var inst_16172 = fluree.db.util.async.throw_err.call(null,inst_16171);
var inst_16173 = cljs.core.not.call(null,inst_16172);
var state_16350__$1 = state_16350;
var statearr_16427_16615 = state_16350__$1;
(statearr_16427_16615[(2)] = inst_16173);

(statearr_16427_16615[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (33))){
var inst_16101 = (state_16350[(26)]);
var state_16350__$1 = state_16350;
var statearr_16428_16616 = state_16350__$1;
(statearr_16428_16616[(2)] = inst_16101);

(statearr_16428_16616[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (13))){
var inst_16096 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16096)){
var statearr_16429_16617 = state_16350__$1;
(statearr_16429_16617[(1)] = (17));

} else {
var statearr_16430_16618 = state_16350__$1;
(statearr_16430_16618[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (22))){
var inst_16127 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16127)){
var statearr_16431_16619 = state_16350__$1;
(statearr_16431_16619[(1)] = (32));

} else {
var statearr_16432_16620 = state_16350__$1;
(statearr_16432_16620[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (90))){
var inst_16250 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16433_16621 = state_16350__$1;
(statearr_16433_16621[(2)] = inst_16250);

(statearr_16433_16621[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (109))){
var inst_16307 = (state_16350[(27)]);
var state_16350__$1 = state_16350;
var statearr_16434_16622 = state_16350__$1;
(statearr_16434_16622[(2)] = inst_16307);

(statearr_16434_16622[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (36))){
var inst_16101 = (state_16350[(26)]);
var state_16350__$1 = state_16350;
var statearr_16435_16623 = state_16350__$1;
(statearr_16435_16623[(2)] = inst_16101);

(statearr_16435_16623[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (41))){
var inst_16078 = (state_16350[(10)]);
var inst_16146 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16147 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16146);
var inst_16148 = inst_16147 === true;
var state_16350__$1 = state_16350;
var statearr_16436_16624 = state_16350__$1;
(statearr_16436_16624[(2)] = inst_16148);

(statearr_16436_16624[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (118))){
var inst_16305 = (state_16350[(7)]);
var state_16350__$1 = state_16350;
var statearr_16437_16625 = state_16350__$1;
(statearr_16437_16625[(2)] = inst_16305);

(statearr_16437_16625[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (89))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16248 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16438_16626 = state_16350__$1;
(statearr_16438_16626[(2)] = inst_16248);

(statearr_16438_16626[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (100))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16439_16627 = state_16350__$1;
(statearr_16439_16627[(2)] = inst_16197);

(statearr_16439_16627[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (122))){
var inst_16337 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16440_16628 = state_16350__$1;
(statearr_16440_16628[(2)] = inst_16337);

(statearr_16440_16628[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (43))){
var inst_16151 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16441_16629 = state_16350__$1;
(statearr_16441_16629[(2)] = inst_16151);

(statearr_16441_16629[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (61))){
var inst_16159 = (state_16350[(14)]);
var state_16350__$1 = state_16350;
var statearr_16442_16630 = state_16350__$1;
(statearr_16442_16630[(2)] = inst_16159);

(statearr_16442_16630[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (29))){
var inst_16078 = (state_16350[(10)]);
var inst_16113 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16114 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16113);
var inst_16115 = inst_16114 === true;
var state_16350__$1 = state_16350;
var statearr_16443_16631 = state_16350__$1;
(statearr_16443_16631[(2)] = inst_16115);

(statearr_16443_16631[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (44))){
var inst_16140 = (state_16350[(28)]);
var inst_16156 = fluree.db.query.schema.type_error.call(null,inst_16140,"a component","a non-component",throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16444_16632 = state_16350__$1;
(statearr_16444_16632[(2)] = inst_16156);

(statearr_16444_16632[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (93))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16258 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16445_16633 = state_16350__$1;
(statearr_16445_16633[(2)] = inst_16258);

(statearr_16445_16633[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (6))){
var inst_16077 = (state_16350[(15)]);
var inst_16065 = (state_16350[(21)]);
var inst_16074 = cljs.core.seq.call(null,inst_16065);
var inst_16075 = cljs.core.first.call(null,inst_16074);
var inst_16076 = cljs.core.next.call(null,inst_16074);
var inst_16077__$1 = cljs.core.nth.call(null,inst_16075,(0),null);
var inst_16078 = cljs.core.nth.call(null,inst_16075,(1),null);
var inst_16079 = cljs.core.not.call(null,inst_16077__$1);
var state_16350__$1 = (function (){var statearr_16446 = state_16350;
(statearr_16446[(15)] = inst_16077__$1);

(statearr_16446[(20)] = inst_16076);

(statearr_16446[(10)] = inst_16078);

return statearr_16446;
})();
if(inst_16079){
var statearr_16447_16634 = state_16350__$1;
(statearr_16447_16634[(1)] = (8));

} else {
var statearr_16448_16635 = state_16350__$1;
(statearr_16448_16635[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (111))){
var inst_16078 = (state_16350[(10)]);
var inst_16313 = (state_16350[(29)]);
var inst_16311 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16312 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16311);
var inst_16313__$1 = inst_16312 === true;
var state_16350__$1 = (function (){var statearr_16449 = state_16350;
(statearr_16449[(29)] = inst_16313__$1);

return statearr_16449;
})();
if(cljs.core.truth_(inst_16313__$1)){
var statearr_16450_16636 = state_16350__$1;
(statearr_16450_16636[(1)] = (114));

} else {
var statearr_16451_16637 = state_16350__$1;
(statearr_16451_16637[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (28))){
var inst_16121 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16452_16638 = state_16350__$1;
(statearr_16452_16638[(2)] = inst_16121);

(statearr_16452_16638[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (64))){
var inst_16198 = (state_16350[(11)]);
var state_16350__$1 = state_16350;
var statearr_16453_16639 = state_16350__$1;
(statearr_16453_16639[(2)] = inst_16198);

(statearr_16453_16639[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (103))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16282 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16283 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,2,inst_16282,null);
var inst_16284 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16283,null);
var inst_16285 = inst_16284.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16285)){
var statearr_16454_16640 = state_16350__$1;
(statearr_16454_16640[(1)] = (104));

} else {
var statearr_16455_16641 = state_16350__$1;
(statearr_16455_16641[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (51))){
var inst_16163 = (state_16350[(30)]);
var state_16350__$1 = state_16350;
var statearr_16456_16642 = state_16350__$1;
(statearr_16456_16642[(2)] = inst_16163);

(statearr_16456_16642[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (25))){
var inst_16124 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16457_16643 = state_16350__$1;
(statearr_16457_16643[(2)] = inst_16124);

(statearr_16457_16643[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (34))){
var inst_16078 = (state_16350[(10)]);
var inst_16141 = (state_16350[(18)]);
var inst_16140 = (state_16350[(2)]);
var inst_16141__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16458 = state_16350;
(statearr_16458[(18)] = inst_16141__$1);

(statearr_16458[(28)] = inst_16140);

return statearr_16458;
})();
if(cljs.core.truth_(inst_16141__$1)){
var statearr_16459_16644 = state_16350__$1;
(statearr_16459_16644[(1)] = (38));

} else {
var statearr_16460_16645 = state_16350__$1;
(statearr_16460_16645[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (17))){
var inst_16066 = (state_16350[(16)]);
var inst_16098 = fluree.db.query.schema.type_error.call(null,inst_16066,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16461_16646 = state_16350__$1;
(statearr_16461_16646[(2)] = inst_16098);

(statearr_16461_16646[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (3))){
var inst_16348 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16350__$1,inst_16348);
} else {
if((state_val_16351 === (12))){
var inst_16082 = (state_16350[(31)]);
var state_16350__$1 = state_16350;
var statearr_16462_16647 = state_16350__$1;
(statearr_16462_16647[(2)] = inst_16082);

(statearr_16462_16647[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (2))){
var _ = (function (){var statearr_16463 = state_16350;
(statearr_16463[(4)] = cljs.core.cons.call(null,(5),(state_16350[(4)])));

return statearr_16463;
})();
var inst_16058 = pred_changes;
var inst_16059 = cljs.core.seq.call(null,inst_16058);
var inst_16060 = cljs.core.first.call(null,inst_16059);
var inst_16061 = cljs.core.next.call(null,inst_16059);
var inst_16062 = cljs.core.nth.call(null,inst_16060,(0),null);
var inst_16063 = cljs.core.nth.call(null,inst_16060,(1),null);
var inst_16064 = db;
var inst_16065 = inst_16058;
var inst_16066 = inst_16064;
var state_16350__$1 = (function (){var statearr_16464 = state_16350;
(statearr_16464[(32)] = inst_16062);

(statearr_16464[(33)] = inst_16061);

(statearr_16464[(16)] = inst_16066);

(statearr_16464[(34)] = inst_16063);

(statearr_16464[(21)] = inst_16065);

return statearr_16464;
})();
var statearr_16465_16648 = state_16350__$1;
(statearr_16465_16648[(2)] = null);

(statearr_16465_16648[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (66))){
var inst_16078 = (state_16350[(10)]);
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16207 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16208 = cljs.core.__destructure_map.call(null,inst_16207);
var inst_16209__$1 = cljs.core.get.call(null,inst_16208,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16210__$1 = cljs.core.get.call(null,inst_16208,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16211 = cljs.core._EQ_.call(null,inst_16210__$1,inst_16209__$1);
var state_16350__$1 = (function (){var statearr_16466 = state_16350;
(statearr_16466[(8)] = inst_16209__$1);

(statearr_16466[(9)] = inst_16210__$1);

return statearr_16466;
})();
if(inst_16211){
var statearr_16467_16649 = state_16350__$1;
(statearr_16467_16649[(1)] = (69));

} else {
var statearr_16468_16650 = state_16350__$1;
(statearr_16468_16650[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (107))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16292 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16469_16651 = state_16350__$1;
(statearr_16469_16651[(2)] = inst_16292);

(statearr_16469_16651[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (23))){
var inst_16078 = (state_16350[(10)]);
var inst_16107 = (state_16350[(17)]);
var inst_16106 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16107__$1 = inst_16106 === true;
var state_16350__$1 = (function (){var statearr_16470 = state_16350;
(statearr_16470[(17)] = inst_16107__$1);

return statearr_16470;
})();
if(cljs.core.truth_(inst_16107__$1)){
var statearr_16471_16652 = state_16350__$1;
(statearr_16471_16652[(1)] = (26));

} else {
var statearr_16472_16653 = state_16350__$1;
(statearr_16472_16653[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (47))){
var inst_16078 = (state_16350[(10)]);
var inst_16163 = (state_16350[(30)]);
var inst_16162 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16163__$1 = cljs.core.not.call(null,inst_16162);
var state_16350__$1 = (function (){var statearr_16473 = state_16350;
(statearr_16473[(30)] = inst_16163__$1);

return statearr_16473;
})();
if(inst_16163__$1){
var statearr_16474_16654 = state_16350__$1;
(statearr_16474_16654[(1)] = (50));

} else {
var statearr_16475_16655 = state_16350__$1;
(statearr_16475_16655[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (35))){
var inst_16130 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16131 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16132 = cljs.core.PersistentHashMap.fromArrays(inst_16130,inst_16131);
var inst_16133 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16132);
var inst_16134 = (function(){throw inst_16133})();
var state_16350__$1 = state_16350;
var statearr_16476_16656 = state_16350__$1;
(statearr_16476_16656[(2)] = inst_16134);

(statearr_16476_16656[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (82))){
var inst_16230 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16477_16657 = state_16350__$1;
(statearr_16477_16657[(2)] = inst_16230);

(statearr_16477_16657[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (76))){
var state_16350__$1 = state_16350;
var statearr_16478_16658 = state_16350__$1;
(statearr_16478_16658[(2)] = null);

(statearr_16478_16658[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (97))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16268 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16479_16659 = state_16350__$1;
(statearr_16479_16659[(2)] = inst_16268);

(statearr_16479_16659[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (19))){
var inst_16102 = (state_16350[(24)]);
var inst_16078 = (state_16350[(10)]);
var inst_16101 = (state_16350[(2)]);
var inst_16102__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16480 = state_16350;
(statearr_16480[(24)] = inst_16102__$1);

(statearr_16480[(26)] = inst_16101);

return statearr_16480;
})();
if(cljs.core.truth_(inst_16102__$1)){
var statearr_16481_16660 = state_16350__$1;
(statearr_16481_16660[(1)] = (20));

} else {
var statearr_16482_16661 = state_16350__$1;
(statearr_16482_16661[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (57))){
var state_16350__$1 = state_16350;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16483_16662 = state_16350__$1;
(statearr_16483_16662[(1)] = (60));

} else {
var statearr_16484_16663 = state_16350__$1;
(statearr_16484_16663[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (68))){
var inst_16078 = (state_16350[(10)]);
var inst_16307 = (state_16350[(27)]);
var inst_16305 = (state_16350[(2)]);
var inst_16306 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16307__$1 = inst_16306 === true;
var state_16350__$1 = (function (){var statearr_16485 = state_16350;
(statearr_16485[(7)] = inst_16305);

(statearr_16485[(27)] = inst_16307__$1);

return statearr_16485;
})();
if(cljs.core.truth_(inst_16307__$1)){
var statearr_16486_16664 = state_16350__$1;
(statearr_16486_16664[(1)] = (108));

} else {
var statearr_16487_16665 = state_16350__$1;
(statearr_16487_16665[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (11))){
var inst_16086 = (state_16350[(23)]);
var inst_16078 = (state_16350[(10)]);
var inst_16084 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16085 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16084);
var inst_16086__$1 = inst_16085 === false;
var state_16350__$1 = (function (){var statearr_16488 = state_16350;
(statearr_16488[(23)] = inst_16086__$1);

return statearr_16488;
})();
if(cljs.core.truth_(inst_16086__$1)){
var statearr_16489_16666 = state_16350__$1;
(statearr_16489_16666[(1)] = (14));

} else {
var statearr_16490_16667 = state_16350__$1;
(statearr_16490_16667[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (115))){
var inst_16313 = (state_16350[(29)]);
var state_16350__$1 = state_16350;
var statearr_16492_16668 = state_16350__$1;
(statearr_16492_16668[(2)] = inst_16313);

(statearr_16492_16668[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (9))){
var inst_16078 = (state_16350[(10)]);
var inst_16082 = (state_16350[(31)]);
var inst_16082__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16078);
var state_16350__$1 = (function (){var statearr_16493 = state_16350;
(statearr_16493[(31)] = inst_16082__$1);

return statearr_16493;
})();
if(cljs.core.truth_(inst_16082__$1)){
var statearr_16494_16669 = state_16350__$1;
(statearr_16494_16669[(1)] = (11));

} else {
var statearr_16495_16670 = state_16350__$1;
(statearr_16495_16670[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (5))){
var _ = (function (){var statearr_16496 = state_16350;
(statearr_16496[(4)] = cljs.core.rest.call(null,(state_16350[(4)])));

return statearr_16496;
})();
var state_16350__$1 = state_16350;
var ex16491 = (state_16350__$1[(2)]);
var statearr_16497_16671 = state_16350__$1;
(statearr_16497_16671[(5)] = ex16491);


if((ex16491 instanceof Error)){
var statearr_16498_16672 = state_16350__$1;
(statearr_16498_16672[(1)] = (4));

(statearr_16498_16672[(5)] = null);

} else {
throw ex16491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (112))){
var inst_16309 = (state_16350[(25)]);
var state_16350__$1 = state_16350;
var statearr_16499_16673 = state_16350__$1;
(statearr_16499_16673[(2)] = inst_16309);

(statearr_16499_16673[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (83))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16232 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16233 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,3,inst_16232,null);
var inst_16234 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16233,null);
var inst_16235 = inst_16234.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16235)){
var statearr_16500_16674 = state_16350__$1;
(statearr_16500_16674[(1)] = (84));

} else {
var statearr_16501_16675 = state_16350__$1;
(statearr_16501_16675[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (14))){
var inst_16078 = (state_16350[(10)]);
var inst_16088 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16089 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16088);
var inst_16090 = inst_16089 === true;
var state_16350__$1 = state_16350;
var statearr_16502_16676 = state_16350__$1;
(statearr_16502_16676[(2)] = inst_16090);

(statearr_16502_16676[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (45))){
var inst_16140 = (state_16350[(28)]);
var state_16350__$1 = state_16350;
var statearr_16503_16677 = state_16350__$1;
(statearr_16503_16677[(2)] = inst_16140);

(statearr_16503_16677[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (53))){
var inst_16077 = (state_16350[(15)]);
var inst_16066 = (state_16350[(16)]);
var inst_16169 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16066,inst_16077);
var state_16350__$1 = state_16350;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16350__$1,(56),inst_16169);
} else {
if((state_val_16351 === (78))){
var inst_16295 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16504_16678 = state_16350__$1;
(statearr_16504_16678[(2)] = inst_16295);

(statearr_16504_16678[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (26))){
var inst_16111 = (state_16350[(35)]);
var inst_16078 = (state_16350[(10)]);
var inst_16109 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16110 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16109);
var inst_16111__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16110);
var state_16350__$1 = (function (){var statearr_16505 = state_16350;
(statearr_16505[(35)] = inst_16111__$1);

return statearr_16505;
})();
if(inst_16111__$1){
var statearr_16506_16679 = state_16350__$1;
(statearr_16506_16679[(1)] = (29));

} else {
var statearr_16507_16680 = state_16350__$1;
(statearr_16507_16680[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (16))){
var inst_16093 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16508_16681 = state_16350__$1;
(statearr_16508_16681[(2)] = inst_16093);

(statearr_16508_16681[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (81))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16228 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16509_16682 = state_16350__$1;
(statearr_16509_16682[(2)] = inst_16228);

(statearr_16509_16682[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (120))){
var inst_16330 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16331 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16332 = cljs.core.PersistentHashMap.fromArrays(inst_16330,inst_16331);
var inst_16333 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_16332);
var inst_16334 = (function(){throw inst_16333})();
var state_16350__$1 = state_16350;
var statearr_16510_16683 = state_16350__$1;
(statearr_16510_16683[(2)] = inst_16334);

(statearr_16510_16683[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (79))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16222 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16223 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,2,inst_16222,null);
var inst_16224 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16223,null);
var inst_16225 = inst_16224.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16225)){
var statearr_16511_16684 = state_16350__$1;
(statearr_16511_16684[(1)] = (80));

} else {
var statearr_16512_16685 = state_16350__$1;
(statearr_16512_16685[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (38))){
var inst_16078 = (state_16350[(10)]);
var inst_16144 = (state_16350[(36)]);
var inst_16143 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16144__$1 = cljs.core.not.call(null,inst_16143);
var state_16350__$1 = (function (){var statearr_16513 = state_16350;
(statearr_16513[(36)] = inst_16144__$1);

return statearr_16513;
})();
if(inst_16144__$1){
var statearr_16514_16686 = state_16350__$1;
(statearr_16514_16686[(1)] = (41));

} else {
var statearr_16515_16687 = state_16350__$1;
(statearr_16515_16687[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (98))){
var inst_16270 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16516_16688 = state_16350__$1;
(statearr_16516_16688[(2)] = inst_16270);

(statearr_16516_16688[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (87))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16242 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16243 = inst_16210.call(null,cljs.core.PersistentArrayMap,null,3,inst_16242,null);
var inst_16244 = inst_16210.call(null,cljs.core.PersistentHashSet,null,inst_16243,null);
var inst_16245 = inst_16244.call(null,inst_16209);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16245)){
var statearr_16517_16689 = state_16350__$1;
(statearr_16517_16689[(1)] = (88));

} else {
var statearr_16518_16690 = state_16350__$1;
(statearr_16518_16690[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (30))){
var inst_16111 = (state_16350[(35)]);
var state_16350__$1 = state_16350;
var statearr_16519_16691 = state_16350__$1;
(statearr_16519_16691[(2)] = inst_16111);

(statearr_16519_16691[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (73))){
var state_16350__$1 = state_16350;
var statearr_16520_16692 = state_16350__$1;
(statearr_16520_16692[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (96))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16522_16693 = state_16350__$1;
(statearr_16522_16693[(2)] = inst_16197);

(statearr_16522_16693[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (10))){
var inst_16343 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16523_16694 = state_16350__$1;
(statearr_16523_16694[(2)] = inst_16343);

(statearr_16523_16694[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (18))){
var inst_16066 = (state_16350[(16)]);
var state_16350__$1 = state_16350;
var statearr_16524_16695 = state_16350__$1;
(statearr_16524_16695[(2)] = inst_16066);

(statearr_16524_16695[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (105))){
var inst_16209 = (state_16350[(8)]);
var inst_16210 = (state_16350[(9)]);
var inst_16288 = fluree.db.query.schema.type_error.call(null,inst_16209,inst_16210,throw_QMARK_);
var state_16350__$1 = state_16350;
var statearr_16525_16696 = state_16350__$1;
(statearr_16525_16696[(2)] = inst_16288);

(statearr_16525_16696[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (52))){
var inst_16179 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16526_16697 = state_16350__$1;
(statearr_16526_16697[(2)] = inst_16179);

(statearr_16526_16697[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (114))){
var inst_16078 = (state_16350[(10)]);
var inst_16315 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16316 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16315);
var inst_16317 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16316);
var inst_16318 = (!(inst_16317));
var state_16350__$1 = state_16350;
var statearr_16527_16698 = state_16350__$1;
(statearr_16527_16698[(2)] = inst_16318);

(statearr_16527_16698[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (67))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16528_16699 = state_16350__$1;
(statearr_16528_16699[(2)] = inst_16197);

(statearr_16528_16699[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (71))){
var inst_16302 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16529_16700 = state_16350__$1;
(statearr_16529_16700[(2)] = inst_16302);

(statearr_16529_16700[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (42))){
var inst_16144 = (state_16350[(36)]);
var state_16350__$1 = state_16350;
var statearr_16530_16701 = state_16350__$1;
(statearr_16530_16701[(2)] = inst_16144);

(statearr_16530_16701[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (80))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16531_16702 = state_16350__$1;
(statearr_16531_16702[(2)] = inst_16197);

(statearr_16531_16702[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (37))){
var inst_16137 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16532_16703 = state_16350__$1;
(statearr_16532_16703[(2)] = inst_16137);

(statearr_16532_16703[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (63))){
var inst_16078 = (state_16350[(10)]);
var inst_16200 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16078);
var inst_16201 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16200);
var state_16350__$1 = state_16350;
var statearr_16533_16704 = state_16350__$1;
(statearr_16533_16704[(2)] = inst_16201);

(statearr_16533_16704[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (94))){
var inst_16260 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
var statearr_16534_16705 = state_16350__$1;
(statearr_16534_16705[(2)] = inst_16260);

(statearr_16534_16705[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (8))){
var inst_16066 = (state_16350[(16)]);
var state_16350__$1 = state_16350;
var statearr_16535_16706 = state_16350__$1;
(statearr_16535_16706[(2)] = inst_16066);

(statearr_16535_16706[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (49))){
var inst_16182 = (state_16350[(2)]);
var state_16350__$1 = state_16350;
if(cljs.core.truth_(inst_16182)){
var statearr_16536_16707 = state_16350__$1;
(statearr_16536_16707[(1)] = (57));

} else {
var statearr_16537_16708 = state_16350__$1;
(statearr_16537_16708[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16351 === (84))){
var inst_16197 = (state_16350[(12)]);
var state_16350__$1 = state_16350;
var statearr_16538_16709 = state_16350__$1;
(statearr_16538_16709[(2)] = inst_16197);

(statearr_16538_16709[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2741__auto__ = null;
var fluree$db$query$schema$state_machine__2741__auto____0 = (function (){
var statearr_16539 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16539[(0)] = fluree$db$query$schema$state_machine__2741__auto__);

(statearr_16539[(1)] = (1));

return statearr_16539;
});
var fluree$db$query$schema$state_machine__2741__auto____1 = (function (state_16350){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_16350);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e16540){var ex__2744__auto__ = e16540;
var statearr_16541_16710 = state_16350;
(statearr_16541_16710[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_16350[(4)]))){
var statearr_16542_16711 = state_16350;
(statearr_16542_16711[(1)] = cljs.core.first.call(null,(state_16350[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16712 = state_16350;
state_16350 = G__16712;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2741__auto__ = function(state_16350){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2741__auto____1.call(this,state_16350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2741__auto____0;
fluree$db$query$schema$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2741__auto____1;
return fluree$db$query$schema$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_16543 = f__2764__auto__.call(null);
(statearr_16543[(6)] = c__2763__auto__);

return statearr_16543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16714 = arguments.length;
switch (G__16714) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_16738){
var state_val_16739 = (state_16738[(1)]);
if((state_val_16739 === (7))){
var state_16738__$1 = state_16738;
var statearr_16740_16760 = state_16738__$1;
(statearr_16740_16760[(2)] = db);

(statearr_16740_16760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (1))){
var state_16738__$1 = state_16738;
var statearr_16741_16761 = state_16738__$1;
(statearr_16741_16761[(2)] = null);

(statearr_16741_16761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (4))){
var inst_16715 = (state_16738[(2)]);
var state_16738__$1 = state_16738;
var statearr_16742_16762 = state_16738__$1;
(statearr_16742_16762[(2)] = inst_16715);

(statearr_16742_16762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (6))){
var inst_16724 = (state_16738[(7)]);
var inst_16723 = (state_16738[(2)]);
var inst_16724__$1 = fluree.db.util.async.throw_err.call(null,inst_16723);
var inst_16725 = cljs.core.empty_QMARK_.call(null,inst_16724__$1);
var state_16738__$1 = (function (){var statearr_16743 = state_16738;
(statearr_16743[(7)] = inst_16724__$1);

return statearr_16743;
})();
if(inst_16725){
var statearr_16744_16763 = state_16738__$1;
(statearr_16744_16763[(1)] = (7));

} else {
var statearr_16745_16764 = state_16738__$1;
(statearr_16745_16764[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (3))){
var inst_16736 = (state_16738[(2)]);
var state_16738__$1 = state_16738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16738__$1,inst_16736);
} else {
if((state_val_16739 === (2))){
var _ = (function (){var statearr_16747 = state_16738;
(statearr_16747[(4)] = cljs.core.cons.call(null,(5),(state_16738[(4)])));

return statearr_16747;
})();
var inst_16721 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16738__$1 = state_16738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16738__$1,(6),inst_16721);
} else {
if((state_val_16739 === (9))){
var inst_16733 = (state_16738[(2)]);
var _ = (function (){var statearr_16748 = state_16738;
(statearr_16748[(4)] = cljs.core.rest.call(null,(state_16738[(4)])));

return statearr_16748;
})();
var state_16738__$1 = state_16738;
var statearr_16749_16765 = state_16738__$1;
(statearr_16749_16765[(2)] = inst_16733);

(statearr_16749_16765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (5))){
var _ = (function (){var statearr_16750 = state_16738;
(statearr_16750[(4)] = cljs.core.rest.call(null,(state_16738[(4)])));

return statearr_16750;
})();
var state_16738__$1 = state_16738;
var ex16746 = (state_16738__$1[(2)]);
var statearr_16751_16766 = state_16738__$1;
(statearr_16751_16766[(5)] = ex16746);


if((ex16746 instanceof Error)){
var statearr_16752_16767 = state_16738__$1;
(statearr_16752_16767[(1)] = (4));

(statearr_16752_16767[(5)] = null);

} else {
throw ex16746;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (10))){
var inst_16730 = (state_16738[(2)]);
var inst_16731 = fluree.db.util.async.throw_err.call(null,inst_16730);
var state_16738__$1 = state_16738;
var statearr_16753_16768 = state_16738__$1;
(statearr_16753_16768[(2)] = inst_16731);

(statearr_16753_16768[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16739 === (8))){
var inst_16724 = (state_16738[(7)]);
var inst_16728 = fluree.db.query.schema.predicate_change_error.call(null,inst_16724,db,true);
var state_16738__$1 = state_16738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16738__$1,(10),inst_16728);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2741__auto__ = null;
var fluree$db$query$schema$state_machine__2741__auto____0 = (function (){
var statearr_16754 = [null,null,null,null,null,null,null,null];
(statearr_16754[(0)] = fluree$db$query$schema$state_machine__2741__auto__);

(statearr_16754[(1)] = (1));

return statearr_16754;
});
var fluree$db$query$schema$state_machine__2741__auto____1 = (function (state_16738){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_16738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e16755){var ex__2744__auto__ = e16755;
var statearr_16756_16769 = state_16738;
(statearr_16756_16769[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_16738[(4)]))){
var statearr_16757_16770 = state_16738;
(statearr_16757_16770[(1)] = cljs.core.first.call(null,(state_16738[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16771 = state_16738;
state_16738 = G__16771;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2741__auto__ = function(state_16738){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2741__auto____1.call(this,state_16738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2741__auto____0;
fluree$db$query$schema$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2741__auto____1;
return fluree$db$query$schema$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_16758 = f__2764__auto__.call(null);
(statearr_16758[(6)] = c__2763__auto__);

return statearr_16758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16773 = arguments.length;
switch (G__16773) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16775 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16775,(0),null);
var ns = cljs.core.nth.call(null,vec__16775,(1),null);
var name = cljs.core.nth.call(null,vec__16775,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4251__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4251__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16778_SHARP_,p2__16779_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16778_SHARP_,p2__16779_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16780_SHARP_){
var f = p1__16780_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_16846){
var state_val_16847 = (state_16846[(1)]);
if((state_val_16847 === (1))){
var state_16846__$1 = state_16846;
var statearr_16848_16865 = state_16846__$1;
(statearr_16848_16865[(2)] = null);

(statearr_16848_16865[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16847 === (2))){
var _ = (function (){var statearr_16849 = state_16846;
(statearr_16849[(4)] = cljs.core.cons.call(null,(5),(state_16846[(4)])));

return statearr_16849;
})();
var inst_16798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16799 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_16800 = [inst_16799];
var inst_16801 = (new cljs.core.PersistentVector(null,1,(5),inst_16798,inst_16800,null));
var inst_16802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16803 = [(0)];
var inst_16804 = (new cljs.core.PersistentVector(null,1,(5),inst_16802,inst_16803,null));
var inst_16805 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_16801,cljs.core._LT__EQ_,inst_16804);
var state_16846__$1 = state_16846;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16846__$1,(6),inst_16805);
} else {
if((state_val_16847 === (3))){
var inst_16844 = (state_16846[(2)]);
var state_16846__$1 = state_16846;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16846__$1,inst_16844);
} else {
if((state_val_16847 === (4))){
var inst_16786 = (state_16846[(2)]);
var state_16846__$1 = state_16846;
var statearr_16851_16866 = state_16846__$1;
(statearr_16851_16866[(2)] = inst_16786);

(statearr_16851_16866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16847 === (5))){
var _ = (function (){var statearr_16852 = state_16846;
(statearr_16852[(4)] = cljs.core.rest.call(null,(state_16846[(4)])));

return statearr_16852;
})();
var state_16846__$1 = state_16846;
var ex16850 = (state_16846__$1[(2)]);
var statearr_16853_16867 = state_16846__$1;
(statearr_16853_16867[(5)] = ex16850);


if((ex16850 instanceof Error)){
var statearr_16854_16868 = state_16846__$1;
(statearr_16854_16868[(1)] = (4));

(statearr_16854_16868[(5)] = null);

} else {
throw ex16850;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16847 === (6))){
var inst_16807 = (state_16846[(2)]);
var inst_16808 = fluree.db.util.async.throw_err.call(null,inst_16807);
var inst_16809 = (function (){var schema_flakes = inst_16808;
return (function (p1__16781_SHARP_){
return (p1__16781_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_16810 = cljs.core.partition_by.call(null,inst_16809,inst_16808);
var inst_16811 = cljs.core.nth.call(null,inst_16810,(0),null);
var inst_16812 = cljs.core.nth.call(null,inst_16810,(1),null);
var inst_16813 = (function (){var schema_flakes = inst_16808;
var vec__16792 = inst_16810;
var collection_flakes = inst_16811;
var predicate_flakes = inst_16812;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16784_SHARP_,p2__16783_SHARP_){
var f = p2__16783_SHARP_;
return cljs.core.assoc.call(null,p1__16784_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4253__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_16814 = [(-1),"_tx"];
var inst_16815 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16816 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16817 = cljs.core.PersistentHashMap.fromArrays(inst_16815,inst_16816);
var inst_16818 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_16819 = ["_tx",(-1),(-1),(-1),null,null];
var inst_16820 = cljs.core.PersistentHashMap.fromArrays(inst_16818,inst_16819);
var inst_16821 = [inst_16817,inst_16820];
var inst_16822 = cljs.core.PersistentHashMap.fromArrays(inst_16814,inst_16821);
var inst_16823 = (function (){var schema_flakes = inst_16808;
var vec__16792 = inst_16810;
var collection_flakes = inst_16811;
var predicate_flakes = inst_16812;
return (function (p1__16782_SHARP_){
return p1__16782_SHARP_.s;
});
})();
var inst_16824 = cljs.core.partition_by.call(null,inst_16823,inst_16811);
var inst_16825 = cljs.core.reduce.call(null,inst_16813,inst_16822,inst_16824);
var inst_16827 = (function (){var schema_flakes = inst_16808;
var vec__16792 = inst_16810;
var collection_flakes = inst_16811;
var predicate_flakes = inst_16812;
var coll = inst_16825;
return (function (p__16826,pred_flakes){
var vec__16855 = p__16826;
var pred = cljs.core.nth.call(null,vec__16855,(0),null);
var fullText = cljs.core.nth.call(null,vec__16855,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = ref_QMARK_;
if(or__4253__auto__){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_16828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16829 = cljs.core.PersistentHashMap.EMPTY;
var inst_16830 = cljs.core.PersistentHashSet.EMPTY;
var inst_16831 = [inst_16829,inst_16830];
var inst_16832 = (new cljs.core.PersistentVector(null,2,(5),inst_16828,inst_16831,null));
var inst_16833 = (function (){var schema_flakes = inst_16808;
var vec__16792 = inst_16810;
var collection_flakes = inst_16811;
var predicate_flakes = inst_16812;
var coll = inst_16825;
return (function (p1__16785_SHARP_){
return p1__16785_SHARP_.s;
});
})();
var inst_16834 = cljs.core.partition_by.call(null,inst_16833,inst_16812);
var inst_16835 = cljs.core.reduce.call(null,inst_16827,inst_16832,inst_16834);
var inst_16836 = cljs.core.nth.call(null,inst_16835,(0),null);
var inst_16837 = cljs.core.nth.call(null,inst_16835,(1),null);
var inst_16838 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_16839 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_16840 = [inst_16839,inst_16825,inst_16836,inst_16837];
var inst_16841 = cljs.core.PersistentHashMap.fromArrays(inst_16838,inst_16840);
var _ = (function (){var statearr_16858 = state_16846;
(statearr_16858[(4)] = cljs.core.rest.call(null,(state_16846[(4)])));

return statearr_16858;
})();
var state_16846__$1 = state_16846;
var statearr_16859_16869 = state_16846__$1;
(statearr_16859_16869[(2)] = inst_16841);

(statearr_16859_16869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2741__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2741__auto____0 = (function (){
var statearr_16860 = [null,null,null,null,null,null,null];
(statearr_16860[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2741__auto__);

(statearr_16860[(1)] = (1));

return statearr_16860;
});
var fluree$db$query$schema$schema_map_$_state_machine__2741__auto____1 = (function (state_16846){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_16846);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e16861){var ex__2744__auto__ = e16861;
var statearr_16862_16870 = state_16846;
(statearr_16862_16870[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_16846[(4)]))){
var statearr_16863_16871 = state_16846;
(statearr_16863_16871[(1)] = cljs.core.first.call(null,(state_16846[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16872 = state_16846;
state_16846 = G__16872;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2741__auto__ = function(state_16846){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2741__auto____1.call(this,state_16846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2741__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2741__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_16864 = f__2764__auto__.call(null);
(statearr_16864[(6)] = c__2763__auto__);

return statearr_16864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_16914){
var state_val_16915 = (state_16914[(1)]);
if((state_val_16915 === (7))){
var inst_16897 = (state_16914[(2)]);
var inst_16898 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_16897);
var inst_16899 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_16900 = cljs.core.get.call(null,inst_16898,(114));
var inst_16901 = cljs.core.boolean$.call(null,inst_16900);
var inst_16902 = cljs.core.get.call(null,inst_16898,(110));
var inst_16903 = cljs.core.get.call(null,inst_16898,(117));
var inst_16904 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_16903);
var inst_16905 = cljs.core.get.call(null,inst_16898,(111));
var inst_16906 = cljs.core.get.call(null,inst_16898,(115));
var inst_16907 = cljs.core.get.call(null,inst_16898,(112));
var inst_16908 = [inst_16901,inst_16902,inst_16904,inst_16905,inst_16906,inst_16907];
var inst_16909 = cljs.core.PersistentHashMap.fromArrays(inst_16899,inst_16908);
var _ = (function (){var statearr_16916 = state_16914;
(statearr_16916[(4)] = cljs.core.rest.call(null,(state_16914[(4)])));

return statearr_16916;
})();
var state_16914__$1 = state_16914;
var statearr_16917_16940 = state_16914__$1;
(statearr_16917_16940[(2)] = inst_16909);

(statearr_16917_16940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (1))){
var state_16914__$1 = state_16914;
var statearr_16918_16941 = state_16914__$1;
(statearr_16918_16941[(2)] = null);

(statearr_16918_16941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (4))){
var inst_16873 = (state_16914[(2)]);
var state_16914__$1 = state_16914;
var statearr_16919_16942 = state_16914__$1;
(statearr_16919_16942[(2)] = inst_16873);

(statearr_16919_16942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (6))){
var _ = (function (){var statearr_16920 = state_16914;
(statearr_16920[(4)] = cljs.core.cons.call(null,(9),(state_16914[(4)])));

return statearr_16920;
})();
var inst_16885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16887 = ["_setting/id","root"];
var inst_16888 = (new cljs.core.PersistentVector(null,2,(5),inst_16886,inst_16887,null));
var inst_16889 = [inst_16888];
var inst_16890 = (new cljs.core.PersistentVector(null,1,(5),inst_16885,inst_16889,null));
var inst_16891 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_16890);
var state_16914__$1 = state_16914;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16914__$1,(10),inst_16891);
} else {
if((state_val_16915 === (3))){
var inst_16912 = (state_16914[(2)]);
var state_16914__$1 = state_16914;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16914__$1,inst_16912);
} else {
if((state_val_16915 === (2))){
var _ = (function (){var statearr_16923 = state_16914;
(statearr_16923[(4)] = cljs.core.cons.call(null,(5),(state_16914[(4)])));

return statearr_16923;
})();
var state_16914__$1 = state_16914;
var statearr_16924_16943 = state_16914__$1;
(statearr_16924_16943[(2)] = null);

(statearr_16924_16943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (9))){
var _ = (function (){var statearr_16925 = state_16914;
(statearr_16925[(4)] = cljs.core.rest.call(null,(state_16914[(4)])));

return statearr_16925;
})();
var state_16914__$1 = state_16914;
var ex16921 = (state_16914__$1[(2)]);
var statearr_16926_16944 = state_16914__$1;
(statearr_16926_16944[(5)] = ex16921);


var statearr_16927_16945 = state_16914__$1;
(statearr_16927_16945[(1)] = (8));

(statearr_16927_16945[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (5))){
var _ = (function (){var statearr_16928 = state_16914;
(statearr_16928[(4)] = cljs.core.rest.call(null,(state_16914[(4)])));

return statearr_16928;
})();
var state_16914__$1 = state_16914;
var ex16922 = (state_16914__$1[(2)]);
var statearr_16929_16946 = state_16914__$1;
(statearr_16929_16946[(5)] = ex16922);


if((ex16922 instanceof Error)){
var statearr_16930_16947 = state_16914__$1;
(statearr_16930_16947[(1)] = (4));

(statearr_16930_16947[(5)] = null);

} else {
throw ex16922;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (10))){
var inst_16893 = (state_16914[(2)]);
var inst_16894 = fluree.db.util.async.throw_err.call(null,inst_16893);
var _ = (function (){var statearr_16931 = state_16914;
(statearr_16931[(4)] = cljs.core.rest.call(null,(state_16914[(4)])));

return statearr_16931;
})();
var state_16914__$1 = state_16914;
var statearr_16932_16948 = state_16914__$1;
(statearr_16932_16948[(2)] = inst_16894);

(statearr_16932_16948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16915 === (8))){
var inst_16879 = (state_16914[(2)]);
var state_16914__$1 = (function (){var statearr_16933 = state_16914;
(statearr_16933[(7)] = inst_16879);

return statearr_16933;
})();
var statearr_16934_16949 = state_16914__$1;
(statearr_16934_16949[(2)] = null);

(statearr_16934_16949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2741__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2741__auto____0 = (function (){
var statearr_16935 = [null,null,null,null,null,null,null,null];
(statearr_16935[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2741__auto__);

(statearr_16935[(1)] = (1));

return statearr_16935;
});
var fluree$db$query$schema$setting_map_$_state_machine__2741__auto____1 = (function (state_16914){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_16914);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e16936){var ex__2744__auto__ = e16936;
var statearr_16937_16950 = state_16914;
(statearr_16937_16950[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_16914[(4)]))){
var statearr_16938_16951 = state_16914;
(statearr_16938_16951[(1)] = cljs.core.first.call(null,(state_16914[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16952 = state_16914;
state_16914 = G__16952;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2741__auto__ = function(state_16914){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2741__auto____1.call(this,state_16914);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2741__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2741__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_16939 = f__2764__auto__.call(null);
(statearr_16939[(6)] = c__2763__auto__);

return statearr_16939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
