// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__22028 = arguments.length;
switch (G__22028) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22031 = arguments.length;
switch (G__22031) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22033 = null;
var G__22033__0 = (function (){
return xf.call(null);
});
var G__22033__1 = (function (result){
return xf.call(null,result);
});
var G__22033__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22033 = function(result,flake){
switch(arguments.length){
case 0:
return G__22033__0.call(this);
case 1:
return G__22033__1.call(this,result);
case 2:
return G__22033__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22033.cljs$core$IFn$_invoke$arity$0 = G__22033__0;
G__22033.cljs$core$IFn$_invoke$arity$1 = G__22033__1;
G__22033.cljs$core$IFn$_invoke$arity$2 = G__22033__2;
return G__22033;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22034 = null;
var G__22034__0 = (function (){
return xf.call(null);
});
var G__22034__1 = (function (result){
return xf.call(null,result);
});
var G__22034__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,cljs.core.count.call(null,flakes));

return xf.call(null,result,flakes);
});
G__22034 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22034__0.call(this);
case 1:
return G__22034__1.call(this,result);
case 2:
return G__22034__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22034.cljs$core$IFn$_invoke$arity$0 = G__22034__0;
G__22034.cljs$core$IFn$_invoke$arity$1 = G__22034__1;
G__22034.cljs$core$IFn$_invoke$arity$2 = G__22034__2;
return G__22034;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22036 = res;
var G__22036__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22035_SHARP_){
return cljs.core.get.call(null,p1__22035_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22036):G__22036);
var G__22036__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22036__$1):G__22036__$1);
var G__22036__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22036__$2):G__22036__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22036__$3);
} else {
return G__22036__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22040 = arguments.length;
switch (G__22040) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_22479){
var state_val_22480 = (state_22479[(1)]);
if((state_val_22480 === (121))){
var inst_22402 = (state_22479[(2)]);
var inst_22403 = fluree.db.util.async.throw_err.call(null,inst_22402);
var inst_22404 = cljs.core.seq.call(null,inst_22403);
var state_22479__$1 = state_22479;
if(inst_22404){
var statearr_22481_22695 = state_22479__$1;
(statearr_22481_22695[(1)] = (122));

} else {
var statearr_22482_22696 = state_22479__$1;
(statearr_22482_22696[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (65))){
var inst_22195 = (state_22479[(7)]);
var inst_22194 = (state_22479[(2)]);
var inst_22195__$1 = fluree.db.util.async.throw_err.call(null,inst_22194);
var inst_22196 = cljs.core.seq.call(null,inst_22195__$1);
var state_22479__$1 = (function (){var statearr_22483 = state_22479;
(statearr_22483[(7)] = inst_22195__$1);

return statearr_22483;
})();
if(inst_22196){
var statearr_22484_22697 = state_22479__$1;
(statearr_22484_22697[(1)] = (66));

} else {
var statearr_22485_22698 = state_22479__$1;
(statearr_22485_22698[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (70))){
var inst_22195 = (state_22479[(7)]);
var inst_22206 = cljs.core.count.call(null,inst_22195);
var inst_22207 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22206);
var state_22479__$1 = state_22479;
var statearr_22486_22699 = state_22479__$1;
(statearr_22486_22699[(2)] = inst_22207);

(statearr_22486_22699[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (62))){
var inst_22185 = (state_22479[(8)]);
var inst_22188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22189 = inst_22185.o;
var inst_22190 = [inst_22189];
var inst_22191 = (new cljs.core.PersistentVector(null,1,(5),inst_22188,inst_22190,null));
var inst_22192 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22191);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(65),inst_22192);
} else {
if((state_val_22480 === (74))){
var inst_22179 = (state_22479[(9)]);
var state_22479__$1 = state_22479;
var statearr_22487_22700 = state_22479__$1;
(statearr_22487_22700[(2)] = inst_22179);

(statearr_22487_22700[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (110))){
var inst_22364 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22365 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22364);
var inst_22366 = inst_22365 === true;
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22366)){
var statearr_22488_22701 = state_22479__$1;
(statearr_22488_22701[(1)] = (113));

} else {
var statearr_22489_22702 = state_22479__$1;
(statearr_22489_22702[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (130))){
var inst_22474 = (state_22479[(2)]);
var _ = (function (){var statearr_22490 = state_22479;
(statearr_22490[(4)] = cljs.core.rest.call(null,(state_22479[(4)])));

return statearr_22490;
})();
var state_22479__$1 = state_22479;
var statearr_22491_22703 = state_22479__$1;
(statearr_22491_22703[(2)] = inst_22474);

(statearr_22491_22703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (128))){
var inst_22449 = (state_22479[(10)]);
var inst_22452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22453 = [acc,inst_22449];
var inst_22454 = (new cljs.core.PersistentVector(null,2,(5),inst_22452,inst_22453,null));
var state_22479__$1 = state_22479;
var statearr_22492_22704 = state_22479__$1;
(statearr_22492_22704[(2)] = inst_22454);

(statearr_22492_22704[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (7))){
var inst_22052 = (state_22479[(11)]);
var state_22479__$1 = state_22479;
var statearr_22493_22705 = state_22479__$1;
(statearr_22493_22705[(2)] = inst_22052);

(statearr_22493_22705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (59))){
var inst_22443 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22494_22706 = state_22479__$1;
(statearr_22494_22706[(2)] = inst_22443);

(statearr_22494_22706[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (86))){
var inst_22273 = (state_22479[(12)]);
var inst_22273__$1 = (state_22479[(2)]);
var state_22479__$1 = (function (){var statearr_22495 = state_22479;
(statearr_22495[(12)] = inst_22273__$1);

return statearr_22495;
})();
if(cljs.core.truth_(inst_22273__$1)){
var statearr_22496_22707 = state_22479__$1;
(statearr_22496_22707[(1)] = (88));

} else {
var statearr_22497_22708 = state_22479__$1;
(statearr_22497_22708[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (20))){
var inst_22081 = (state_22479[(13)]);
var inst_22093 = (state_22479[(14)]);
var inst_22094 = (state_22479[(15)]);
var inst_22092 = (state_22479[(2)]);
var inst_22093__$1 = cljs.core.__destructure_map.call(null,inst_22081);
var inst_22094__$1 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22095 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22096 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22097 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22098 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22099 = cljs.core.get.call(null,inst_22093__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22479__$1 = (function (){var statearr_22498 = state_22479;
(statearr_22498[(16)] = inst_22095);

(statearr_22498[(17)] = inst_22092);

(statearr_22498[(14)] = inst_22093__$1);

(statearr_22498[(18)] = inst_22096);

(statearr_22498[(19)] = inst_22097);

(statearr_22498[(15)] = inst_22094__$1);

(statearr_22498[(20)] = inst_22099);

(statearr_22498[(21)] = inst_22098);

return statearr_22498;
})();
if(cljs.core.truth_(inst_22094__$1)){
var statearr_22499_22709 = state_22479__$1;
(statearr_22499_22709[(1)] = (24));

} else {
var statearr_22500_22710 = state_22479__$1;
(statearr_22500_22710[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (72))){
var inst_22204 = (state_22479[(22)]);
var inst_22210 = (state_22479[(2)]);
var inst_22211 = cljs.core.seq.call(null,inst_22204);
var state_22479__$1 = (function (){var statearr_22501 = state_22479;
(statearr_22501[(23)] = inst_22210);

return statearr_22501;
})();
if(inst_22211){
var statearr_22502_22711 = state_22479__$1;
(statearr_22502_22711[(1)] = (73));

} else {
var statearr_22503_22712 = state_22479__$1;
(statearr_22503_22712[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (58))){
var inst_22081 = (state_22479[(13)]);
var inst_22226 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22226)){
var statearr_22504_22713 = state_22479__$1;
(statearr_22504_22713[(1)] = (76));

} else {
var statearr_22505_22714 = state_22479__$1;
(statearr_22505_22714[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (60))){
var inst_22185 = (state_22479[(8)]);
var inst_22178 = (state_22479[(24)]);
var inst_22184 = cljs.core.seq.call(null,inst_22178);
var inst_22185__$1 = cljs.core.first.call(null,inst_22184);
var inst_22186 = cljs.core.next.call(null,inst_22184);
var state_22479__$1 = (function (){var statearr_22506 = state_22479;
(statearr_22506[(8)] = inst_22185__$1);

(statearr_22506[(25)] = inst_22186);

return statearr_22506;
})();
if(cljs.core.truth_(inst_22185__$1)){
var statearr_22507_22715 = state_22479__$1;
(statearr_22507_22715[(1)] = (62));

} else {
var statearr_22508_22716 = state_22479__$1;
(statearr_22508_22716[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (27))){
var inst_22098 = (state_22479[(21)]);
var inst_22102 = (state_22479[(26)]);
var inst_22102__$1 = cljs.core.not_EQ_.call(null,(0),inst_22098);
var state_22479__$1 = (function (){var statearr_22509 = state_22479;
(statearr_22509[(26)] = inst_22102__$1);

return statearr_22509;
})();
if(inst_22102__$1){
var statearr_22510_22717 = state_22479__$1;
(statearr_22510_22717[(1)] = (30));

} else {
var statearr_22511_22718 = state_22479__$1;
(statearr_22511_22718[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (1))){
var state_22479__$1 = state_22479;
var statearr_22512_22719 = state_22479__$1;
(statearr_22512_22719[(2)] = null);

(statearr_22512_22719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (69))){
var inst_22200 = (state_22479[(2)]);
var inst_22201 = fluree.db.util.async.throw_err.call(null,inst_22200);
var state_22479__$1 = state_22479;
var statearr_22513_22720 = state_22479__$1;
(statearr_22513_22720[(2)] = inst_22201);

(statearr_22513_22720[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (101))){
var inst_22357 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22514_22721 = state_22479__$1;
(statearr_22514_22721[(2)] = inst_22357);

(statearr_22514_22721[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (24))){
var inst_22098 = (state_22479[(21)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22098)){
var statearr_22515_22722 = state_22479__$1;
(statearr_22515_22722[(1)] = (27));

} else {
var statearr_22516_22723 = state_22479__$1;
(statearr_22516_22723[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (102))){
var inst_22329 = (state_22479[(27)]);
var inst_22328 = (state_22479[(2)]);
var inst_22329__$1 = fluree.db.util.async.throw_err.call(null,inst_22328);
var inst_22330 = cljs.core.empty_QMARK_.call(null,inst_22329__$1);
var state_22479__$1 = (function (){var statearr_22517 = state_22479;
(statearr_22517[(27)] = inst_22329__$1);

return statearr_22517;
})();
if(inst_22330){
var statearr_22518_22724 = state_22479__$1;
(statearr_22518_22724[(1)] = (103));

} else {
var statearr_22519_22725 = state_22479__$1;
(statearr_22519_22725[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (135))){
var state_22479__$1 = state_22479;
var statearr_22520_22726 = state_22479__$1;
(statearr_22520_22726[(2)] = null);

(statearr_22520_22726[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (55))){
var inst_22081 = (state_22479[(13)]);
var inst_22154 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = state_22479;
var statearr_22521_22727 = state_22479__$1;
(statearr_22521_22727[(2)] = inst_22154);

(statearr_22521_22727[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (85))){
var inst_22081 = (state_22479[(13)]);
var inst_22248 = (state_22479[(28)]);
var inst_22260 = inst_22248.o;
var inst_22261 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22081);
var inst_22262 = fluree.db.dbproto._tag.call(null,db,inst_22260,inst_22261);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(87),inst_22262);
} else {
if((state_val_22480 === (39))){
var inst_22129 = (state_22479[(29)]);
var inst_22097 = (state_22479[(19)]);
var inst_22129__$1 = cljs.core.not.call(null,inst_22097);
var state_22479__$1 = (function (){var statearr_22522 = state_22479;
(statearr_22522[(29)] = inst_22129__$1);

return statearr_22522;
})();
if(inst_22129__$1){
var statearr_22523_22728 = state_22479__$1;
(statearr_22523_22728[(1)] = (42));

} else {
var statearr_22524_22729 = state_22479__$1;
(statearr_22524_22729[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (88))){
var inst_22273 = (state_22479[(12)]);
var inst_22242 = (state_22479[(30)]);
var inst_22275 = cljs.core.conj.call(null,inst_22242,inst_22273);
var state_22479__$1 = state_22479;
var statearr_22525_22730 = state_22479__$1;
(statearr_22525_22730[(2)] = inst_22275);

(statearr_22525_22730[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (46))){
var inst_22096 = (state_22479[(18)]);
var state_22479__$1 = state_22479;
var statearr_22526_22731 = state_22479__$1;
(statearr_22526_22731[(2)] = inst_22096);

(statearr_22526_22731[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (4))){
var inst_22041 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22527_22732 = state_22479__$1;
(statearr_22527_22732[(2)] = inst_22041);

(statearr_22527_22732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (77))){
var inst_22288 = (state_22479[(31)]);
var inst_22288__$1 = componentFollow_QMARK_;
var state_22479__$1 = (function (){var statearr_22528 = state_22479;
(statearr_22528[(31)] = inst_22288__$1);

return statearr_22528;
})();
if(cljs.core.truth_(inst_22288__$1)){
var statearr_22529_22733 = state_22479__$1;
(statearr_22529_22733[(1)] = (91));

} else {
var statearr_22530_22734 = state_22479__$1;
(statearr_22530_22734[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (106))){
var inst_22309 = (state_22479[(32)]);
var inst_22343 = (state_22479[(2)]);
var inst_22344 = fluree.db.util.async.throw_err.call(null,inst_22343);
var inst_22345 = cljs.core.conj.call(null,inst_22309,inst_22344);
var state_22479__$1 = state_22479;
var statearr_22531_22735 = state_22479__$1;
(statearr_22531_22735[(2)] = inst_22345);

(statearr_22531_22735[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (119))){
var inst_22387 = (state_22479[(33)]);
var inst_22417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22418 = [inst_22387,offset_map];
var inst_22419 = (new cljs.core.PersistentVector(null,2,(5),inst_22417,inst_22418,null));
var state_22479__$1 = state_22479;
var statearr_22532_22736 = state_22479__$1;
(statearr_22532_22736[(2)] = inst_22419);

(statearr_22532_22736[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (95))){
var inst_22095 = (state_22479[(16)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22095)){
var statearr_22533_22737 = state_22479__$1;
(statearr_22533_22737[(1)] = (110));

} else {
var statearr_22534_22738 = state_22479__$1;
(statearr_22534_22738[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (54))){
var inst_22151 = (state_22479[(34)]);
var state_22479__$1 = state_22479;
var statearr_22535_22739 = state_22479__$1;
(statearr_22535_22739[(2)] = inst_22151);

(statearr_22535_22739[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (92))){
var inst_22288 = (state_22479[(31)]);
var state_22479__$1 = state_22479;
var statearr_22536_22740 = state_22479__$1;
(statearr_22536_22740[(2)] = inst_22288);

(statearr_22536_22740[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (104))){
var inst_22329 = (state_22479[(27)]);
var inst_22051 = (state_22479[(35)]);
var inst_22338 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22339 = [true,inst_22051];
var inst_22340 = cljs.core.PersistentHashMap.fromArrays(inst_22338,inst_22339);
var inst_22341 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22340,inst_22329);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(106),inst_22341);
} else {
if((state_val_22480 === (15))){
var inst_22051 = (state_22479[(35)]);
var inst_22074 = (state_22479[(36)]);
var inst_22078 = cljs.core.assoc.call(null,inst_22074,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22051);
var state_22479__$1 = state_22479;
var statearr_22537_22741 = state_22479__$1;
(statearr_22537_22741[(2)] = inst_22078);

(statearr_22537_22741[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (48))){
var inst_22145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22146 = [null,offset_map];
var inst_22147 = (new cljs.core.PersistentVector(null,2,(5),inst_22145,inst_22146,null));
var state_22479__$1 = state_22479;
var statearr_22538_22742 = state_22479__$1;
(statearr_22538_22742[(2)] = inst_22147);

(statearr_22538_22742[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (50))){
var inst_22445 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22539_22743 = state_22479__$1;
(statearr_22539_22743[(2)] = inst_22445);

(statearr_22539_22743[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (116))){
var inst_22393 = (state_22479[(37)]);
var inst_22386 = (state_22479[(38)]);
var inst_22392 = cljs.core.seq.call(null,inst_22386);
var inst_22393__$1 = cljs.core.first.call(null,inst_22392);
var inst_22394 = cljs.core.next.call(null,inst_22392);
var state_22479__$1 = (function (){var statearr_22540 = state_22479;
(statearr_22540[(39)] = inst_22394);

(statearr_22540[(37)] = inst_22393__$1);

return statearr_22540;
})();
if(cljs.core.truth_(inst_22393__$1)){
var statearr_22541_22744 = state_22479__$1;
(statearr_22541_22744[(1)] = (118));

} else {
var statearr_22542_22745 = state_22479__$1;
(statearr_22542_22745[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (75))){
var inst_22186 = (state_22479[(25)]);
var inst_22216 = (state_22479[(2)]);
var inst_22178 = inst_22186;
var inst_22179 = inst_22216;
var state_22479__$1 = (function (){var statearr_22543 = state_22479;
(statearr_22543[(24)] = inst_22178);

(statearr_22543[(9)] = inst_22179);

return statearr_22543;
})();
var statearr_22544_22746 = state_22479__$1;
(statearr_22544_22746[(2)] = null);

(statearr_22544_22746[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (99))){
var inst_22081 = (state_22479[(13)]);
var inst_22315 = (state_22479[(40)]);
var inst_22318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22319 = inst_22315.o;
var inst_22320 = [inst_22319];
var inst_22321 = (new cljs.core.PersistentVector(null,1,(5),inst_22318,inst_22320,null));
var inst_22322 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22323 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22081);
var inst_22324 = [inst_22323];
var inst_22325 = cljs.core.PersistentHashMap.fromArrays(inst_22322,inst_22324);
var inst_22326 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22321,inst_22325);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(102),inst_22326);
} else {
if((state_val_22480 === (21))){
var inst_22085 = (state_22479[(41)]);
var state_22479__$1 = state_22479;
var statearr_22545_22747 = state_22479__$1;
(statearr_22545_22747[(2)] = inst_22085);

(statearr_22545_22747[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (31))){
var inst_22102 = (state_22479[(26)]);
var state_22479__$1 = state_22479;
var statearr_22546_22748 = state_22479__$1;
(statearr_22546_22748[(2)] = inst_22102);

(statearr_22546_22748[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (113))){
var inst_22081 = (state_22479[(13)]);
var inst_22066 = (state_22479[(42)]);
var inst_22095 = (state_22479[(16)]);
var inst_22092 = (state_22479[(17)]);
var inst_22093 = (state_22479[(14)]);
var inst_22096 = (state_22479[(18)]);
var inst_22097 = (state_22479[(19)]);
var inst_22094 = (state_22479[(15)]);
var inst_22051 = (state_22479[(35)]);
var inst_22099 = (state_22479[(20)]);
var inst_22098 = (state_22479[(21)]);
var inst_22368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22369 = (function (){var p = inst_22099;
var pred_spec__$1 = inst_22066;
var orderBy = inst_22097;
var multi_QMARK_ = inst_22094;
var limit = inst_22096;
var offset = inst_22098;
var map__22047 = inst_22093;
var k = inst_22092;
var compact_QMARK_ = inst_22051;
var pred_spec_SINGLEQUOTE_ = inst_22081;
var ref_QMARK_ = inst_22095;
return (function (p1__22037_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[p1__22037_SHARP_.o]);
});
})();
var inst_22370 = cljs.core.mapv.call(null,inst_22369,flakes);
var inst_22371 = [inst_22370,offset_map];
var inst_22372 = (new cljs.core.PersistentVector(null,2,(5),inst_22368,inst_22371,null));
var state_22479__$1 = state_22479;
var statearr_22547_22749 = state_22479__$1;
(statearr_22547_22749[(2)] = inst_22372);

(statearr_22547_22749[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (32))){
var inst_22108 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22548_22750 = state_22479__$1;
(statearr_22548_22750[(2)] = inst_22108);

(statearr_22548_22750[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (136))){
var inst_22470 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22549_22751 = state_22479__$1;
(statearr_22549_22751[(2)] = inst_22470);

(statearr_22549_22751[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (40))){
var inst_22094 = (state_22479[(15)]);
var state_22479__$1 = state_22479;
var statearr_22550_22752 = state_22479__$1;
(statearr_22550_22752[(2)] = inst_22094);

(statearr_22550_22752[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (129))){
var inst_22094 = (state_22479[(15)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22094)){
var statearr_22551_22753 = state_22479__$1;
(statearr_22551_22753[(1)] = (131));

} else {
var statearr_22552_22754 = state_22479__$1;
(statearr_22552_22754[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (91))){
var inst_22081 = (state_22479[(13)]);
var inst_22290 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = state_22479;
var statearr_22553_22755 = state_22479__$1;
(statearr_22553_22755[(2)] = inst_22290);

(statearr_22553_22755[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (117))){
var inst_22423 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22554_22756 = state_22479__$1;
(statearr_22554_22756[(2)] = inst_22423);

(statearr_22554_22756[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (108))){
var state_22479__$1 = state_22479;
var statearr_22555_22757 = state_22479__$1;
(statearr_22555_22757[(2)] = null);

(statearr_22555_22757[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (56))){
var inst_22156 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22556_22758 = state_22479__$1;
(statearr_22556_22758[(2)] = inst_22156);

(statearr_22556_22758[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (33))){
var inst_22099 = (state_22479[(20)]);
var inst_22116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22117 = cljs.core.get.call(null,offset_map,inst_22099);
var state_22479__$1 = (function (){var statearr_22557 = state_22479;
(statearr_22557[(43)] = inst_22116);

return statearr_22557;
})();
if(cljs.core.truth_(inst_22117)){
var statearr_22558_22759 = state_22479__$1;
(statearr_22558_22759[(1)] = (36));

} else {
var statearr_22559_22760 = state_22479__$1;
(statearr_22559_22760[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (13))){
var inst_22066 = (state_22479[(42)]);
var state_22479__$1 = state_22479;
var statearr_22560_22761 = state_22479__$1;
(statearr_22560_22761[(2)] = inst_22066);

(statearr_22560_22761[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (22))){
var inst_22081 = (state_22479[(13)]);
var inst_22088 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = state_22479;
var statearr_22561_22762 = state_22479__$1;
(statearr_22561_22762[(2)] = inst_22088);

(statearr_22561_22762[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (90))){
var inst_22249 = (state_22479[(44)]);
var inst_22278 = (state_22479[(2)]);
var inst_22241 = inst_22249;
var inst_22242 = inst_22278;
var state_22479__$1 = (function (){var statearr_22562 = state_22479;
(statearr_22562[(45)] = inst_22241);

(statearr_22562[(30)] = inst_22242);

return statearr_22562;
})();
var statearr_22563_22763 = state_22479__$1;
(statearr_22563_22763[(2)] = null);

(statearr_22563_22763[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (109))){
var inst_22347 = (state_22479[(46)]);
var inst_22316 = (state_22479[(47)]);
var inst_22353 = (state_22479[(2)]);
var inst_22308 = inst_22316;
var inst_22309 = inst_22347;
var state_22479__$1 = (function (){var statearr_22564 = state_22479;
(statearr_22564[(32)] = inst_22309);

(statearr_22564[(48)] = inst_22308);

(statearr_22564[(49)] = inst_22353);

return statearr_22564;
})();
var statearr_22565_22764 = state_22479__$1;
(statearr_22565_22764[(2)] = null);

(statearr_22565_22764[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (36))){
var inst_22099 = (state_22479[(20)]);
var inst_22119 = cljs.core.update.call(null,offset_map,inst_22099,cljs.core.dec);
var state_22479__$1 = state_22479;
var statearr_22566_22765 = state_22479__$1;
(statearr_22566_22765[(2)] = inst_22119);

(statearr_22566_22765[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (41))){
var inst_22143 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22143)){
var statearr_22567_22766 = state_22479__$1;
(statearr_22567_22766[(1)] = (48));

} else {
var statearr_22568_22767 = state_22479__$1;
(statearr_22568_22767[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (118))){
var inst_22393 = (state_22479[(37)]);
var inst_22396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22397 = inst_22393.o;
var inst_22398 = [inst_22397];
var inst_22399 = (new cljs.core.PersistentVector(null,1,(5),inst_22396,inst_22398,null));
var inst_22400 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22399);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(121),inst_22400);
} else {
if((state_val_22480 === (89))){
var inst_22242 = (state_22479[(30)]);
var state_22479__$1 = state_22479;
var statearr_22569_22768 = state_22479__$1;
(statearr_22569_22768[(2)] = inst_22242);

(statearr_22569_22768[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (100))){
var inst_22309 = (state_22479[(32)]);
var state_22479__$1 = state_22479;
var statearr_22570_22769 = state_22479__$1;
(statearr_22570_22769[(2)] = inst_22309);

(statearr_22570_22769[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (131))){
var inst_22092 = (state_22479[(17)]);
var inst_22448 = (state_22479[(50)]);
var inst_22449 = (state_22479[(10)]);
var inst_22457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22458 = cljs.core.assoc.call(null,acc,inst_22092,inst_22448);
var inst_22459 = [inst_22458,inst_22449];
var inst_22460 = (new cljs.core.PersistentVector(null,2,(5),inst_22457,inst_22459,null));
var state_22479__$1 = state_22479;
var statearr_22571_22770 = state_22479__$1;
(statearr_22571_22770[(2)] = inst_22460);

(statearr_22571_22770[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (122))){
var inst_22394 = (state_22479[(39)]);
var inst_22393 = (state_22479[(37)]);
var inst_22387 = (state_22479[(33)]);
var inst_22406 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22407 = inst_22393.o;
var inst_22408 = [inst_22407];
var inst_22409 = cljs.core.PersistentHashMap.fromArrays(inst_22406,inst_22408);
var inst_22410 = cljs.core.conj.call(null,inst_22387,inst_22409);
var inst_22386 = inst_22394;
var inst_22387__$1 = inst_22410;
var state_22479__$1 = (function (){var statearr_22572 = state_22479;
(statearr_22572[(33)] = inst_22387__$1);

(statearr_22572[(38)] = inst_22386);

return statearr_22572;
})();
var statearr_22573_22771 = state_22479__$1;
(statearr_22573_22771[(2)] = null);

(statearr_22573_22771[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (43))){
var inst_22129 = (state_22479[(29)]);
var state_22479__$1 = state_22479;
var statearr_22574_22772 = state_22479__$1;
(statearr_22574_22772[(2)] = inst_22129);

(statearr_22574_22772[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (61))){
var inst_22165 = (state_22479[(51)]);
var inst_22222 = (state_22479[(2)]);
var inst_22223 = [inst_22222,offset_map];
var inst_22224 = (new cljs.core.PersistentVector(null,2,(5),inst_22165,inst_22223,null));
var state_22479__$1 = state_22479;
var statearr_22575_22773 = state_22479__$1;
(statearr_22575_22773[(2)] = inst_22224);

(statearr_22575_22773[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (29))){
var inst_22111 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22576_22774 = state_22479__$1;
(statearr_22576_22774[(2)] = inst_22111);

(statearr_22576_22774[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (44))){
var inst_22140 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22577_22775 = state_22479__$1;
(statearr_22577_22775[(2)] = inst_22140);

(statearr_22577_22775[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (93))){
var inst_22293 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22293)){
var statearr_22578_22776 = state_22479__$1;
(statearr_22578_22776[(1)] = (94));

} else {
var statearr_22579_22777 = state_22479__$1;
(statearr_22579_22777[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (6))){
var inst_22054 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22055 = (inst_22054 == null);
var state_22479__$1 = state_22479;
var statearr_22580_22778 = state_22479__$1;
(statearr_22580_22778[(2)] = inst_22055);

(statearr_22580_22778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (111))){
var state_22479__$1 = state_22479;
var statearr_22581_22779 = state_22479__$1;
(statearr_22581_22779[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (28))){
var inst_22098 = (state_22479[(21)]);
var state_22479__$1 = state_22479;
var statearr_22583_22780 = state_22479__$1;
(statearr_22583_22780[(2)] = inst_22098);

(statearr_22583_22780[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (134))){
var inst_22092 = (state_22479[(17)]);
var inst_22448 = (state_22479[(50)]);
var inst_22449 = (state_22479[(10)]);
var inst_22463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22464 = cljs.core.first.call(null,inst_22448);
var inst_22465 = cljs.core.assoc.call(null,acc,inst_22092,inst_22464);
var inst_22466 = [inst_22465,inst_22449];
var inst_22467 = (new cljs.core.PersistentVector(null,2,(5),inst_22463,inst_22466,null));
var state_22479__$1 = state_22479;
var statearr_22584_22781 = state_22479__$1;
(statearr_22584_22781[(2)] = inst_22467);

(statearr_22584_22781[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (64))){
var inst_22220 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22585_22782 = state_22479__$1;
(statearr_22585_22782[(2)] = inst_22220);

(statearr_22585_22782[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (103))){
var inst_22309 = (state_22479[(32)]);
var inst_22315 = (state_22479[(40)]);
var inst_22332 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22333 = inst_22315.o;
var inst_22334 = [inst_22333];
var inst_22335 = cljs.core.PersistentHashMap.fromArrays(inst_22332,inst_22334);
var inst_22336 = cljs.core.conj.call(null,inst_22309,inst_22335);
var state_22479__$1 = state_22479;
var statearr_22586_22783 = state_22479__$1;
(statearr_22586_22783[(2)] = inst_22336);

(statearr_22586_22783[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (51))){
var inst_22081 = (state_22479[(13)]);
var inst_22151 = (state_22479[(34)]);
var inst_22151__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = (function (){var statearr_22587 = state_22479;
(statearr_22587[(34)] = inst_22151__$1);

return statearr_22587;
})();
if(cljs.core.truth_(inst_22151__$1)){
var statearr_22588_22784 = state_22479__$1;
(statearr_22588_22784[(1)] = (54));

} else {
var statearr_22589_22785 = state_22479__$1;
(statearr_22589_22785[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (25))){
var inst_22094 = (state_22479[(15)]);
var state_22479__$1 = state_22479;
var statearr_22590_22786 = state_22479__$1;
(statearr_22590_22786[(2)] = inst_22094);

(statearr_22590_22786[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (34))){
var inst_22094 = (state_22479[(15)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22094)){
var statearr_22591_22787 = state_22479__$1;
(statearr_22591_22787[(1)] = (39));

} else {
var statearr_22592_22788 = state_22479__$1;
(statearr_22592_22788[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (125))){
var inst_22081 = (state_22479[(13)]);
var inst_22066 = (state_22479[(42)]);
var inst_22095 = (state_22479[(16)]);
var inst_22092 = (state_22479[(17)]);
var inst_22093 = (state_22479[(14)]);
var inst_22096 = (state_22479[(18)]);
var inst_22097 = (state_22479[(19)]);
var inst_22094 = (state_22479[(15)]);
var inst_22051 = (state_22479[(35)]);
var inst_22099 = (state_22479[(20)]);
var inst_22098 = (state_22479[(21)]);
var inst_22428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22429 = (function (){var p = inst_22099;
var pred_spec__$1 = inst_22066;
var orderBy = inst_22097;
var multi_QMARK_ = inst_22094;
var limit = inst_22096;
var offset = inst_22098;
var map__22047 = inst_22093;
var k = inst_22092;
var compact_QMARK_ = inst_22051;
var pred_spec_SINGLEQUOTE_ = inst_22081;
var ref_QMARK_ = inst_22095;
return (function (p1__22038_SHARP_){
return p1__22038_SHARP_.o;
});
})();
var inst_22430 = cljs.core.mapv.call(null,inst_22429,flakes);
var inst_22431 = [inst_22430,offset_map];
var inst_22432 = (new cljs.core.PersistentVector(null,2,(5),inst_22428,inst_22431,null));
var state_22479__$1 = state_22479;
var statearr_22593_22789 = state_22479__$1;
(statearr_22593_22789[(2)] = inst_22432);

(statearr_22593_22789[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (17))){
var inst_22081 = (state_22479[(13)]);
var inst_22082 = (state_22479[(52)]);
var inst_22081__$1 = (state_22479[(2)]);
var inst_22082__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22081__$1);
var state_22479__$1 = (function (){var statearr_22594 = state_22479;
(statearr_22594[(13)] = inst_22081__$1);

(statearr_22594[(52)] = inst_22082__$1);

return statearr_22594;
})();
if(cljs.core.truth_(inst_22082__$1)){
var statearr_22595_22790 = state_22479__$1;
(statearr_22595_22790[(1)] = (18));

} else {
var statearr_22596_22791 = state_22479__$1;
(statearr_22596_22791[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (3))){
var inst_22477 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22479__$1,inst_22477);
} else {
if((state_val_22480 === (12))){
var inst_22066 = (state_22479[(42)]);
var inst_22071 = cljs.core.assoc.call(null,inst_22066,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22479__$1 = state_22479;
var statearr_22597_22792 = state_22479__$1;
(statearr_22597_22792[(2)] = inst_22071);

(statearr_22597_22792[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (2))){
var inst_22052 = (state_22479[(11)]);
var _ = (function (){var statearr_22598 = state_22479;
(statearr_22598[(4)] = cljs.core.cons.call(null,(5),(state_22479[(4)])));

return statearr_22598;
})();
var inst_22051 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22052__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22479__$1 = (function (){var statearr_22599 = state_22479;
(statearr_22599[(11)] = inst_22052__$1);

(statearr_22599[(35)] = inst_22051);

return statearr_22599;
})();
if(cljs.core.truth_(inst_22052__$1)){
var statearr_22600_22793 = state_22479__$1;
(statearr_22600_22793[(1)] = (6));

} else {
var statearr_22601_22794 = state_22479__$1;
(statearr_22601_22794[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (66))){
var inst_22164 = (state_22479[(53)]);
var inst_22195 = (state_22479[(7)]);
var inst_22198 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22164,inst_22195);
var state_22479__$1 = state_22479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22479__$1,(69),inst_22198);
} else {
if((state_val_22480 === (107))){
var inst_22329 = (state_22479[(27)]);
var inst_22349 = cljs.core.count.call(null,inst_22329);
var inst_22350 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22349);
var state_22479__$1 = state_22479;
var statearr_22602_22795 = state_22479__$1;
(statearr_22602_22795[(2)] = inst_22350);

(statearr_22602_22795[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (23))){
var inst_22090 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22603_22796 = state_22479__$1;
(statearr_22603_22796[(2)] = inst_22090);

(statearr_22603_22796[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (47))){
var inst_22137 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22604_22797 = state_22479__$1;
(statearr_22604_22797[(2)] = inst_22137);

(statearr_22604_22797[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (35))){
var inst_22448 = (state_22479[(50)]);
var inst_22447 = (state_22479[(2)]);
var inst_22448__$1 = cljs.core.nth.call(null,inst_22447,(0),null);
var inst_22449 = cljs.core.nth.call(null,inst_22447,(1),null);
var inst_22450 = cljs.core.empty_QMARK_.call(null,inst_22448__$1);
var state_22479__$1 = (function (){var statearr_22605 = state_22479;
(statearr_22605[(50)] = inst_22448__$1);

(statearr_22605[(10)] = inst_22449);

return statearr_22605;
})();
if(inst_22450){
var statearr_22606_22798 = state_22479__$1;
(statearr_22606_22798[(1)] = (128));

} else {
var statearr_22607_22799 = state_22479__$1;
(statearr_22607_22799[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (127))){
var inst_22435 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22608_22800 = state_22479__$1;
(statearr_22608_22800[(2)] = inst_22435);

(statearr_22608_22800[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (82))){
var inst_22242 = (state_22479[(30)]);
var state_22479__$1 = state_22479;
var statearr_22609_22801 = state_22479__$1;
(statearr_22609_22801[(2)] = inst_22242);

(statearr_22609_22801[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (76))){
var inst_22228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22236 = flakes;
var inst_22237 = cljs.core.seq.call(null,inst_22236);
var inst_22238 = cljs.core.first.call(null,inst_22237);
var inst_22239 = cljs.core.next.call(null,inst_22237);
var inst_22240 = cljs.core.PersistentVector.EMPTY;
var inst_22241 = inst_22236;
var inst_22242 = inst_22240;
var state_22479__$1 = (function (){var statearr_22610 = state_22479;
(statearr_22610[(54)] = inst_22239);

(statearr_22610[(55)] = inst_22238);

(statearr_22610[(56)] = inst_22228);

(statearr_22610[(45)] = inst_22241);

(statearr_22610[(30)] = inst_22242);

return statearr_22610;
})();
var statearr_22611_22802 = state_22479__$1;
(statearr_22611_22802[(2)] = null);

(statearr_22611_22802[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (97))){
var inst_22308 = (state_22479[(48)]);
var inst_22315 = (state_22479[(40)]);
var inst_22314 = cljs.core.seq.call(null,inst_22308);
var inst_22315__$1 = cljs.core.first.call(null,inst_22314);
var inst_22316 = cljs.core.next.call(null,inst_22314);
var state_22479__$1 = (function (){var statearr_22612 = state_22479;
(statearr_22612[(47)] = inst_22316);

(statearr_22612[(40)] = inst_22315__$1);

return statearr_22612;
})();
if(cljs.core.truth_(inst_22315__$1)){
var statearr_22613_22803 = state_22479__$1;
(statearr_22613_22803[(1)] = (99));

} else {
var statearr_22614_22804 = state_22479__$1;
(statearr_22614_22804[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (19))){
var inst_22081 = (state_22479[(13)]);
var inst_22085 = (state_22479[(41)]);
var inst_22085__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22081);
var state_22479__$1 = (function (){var statearr_22615 = state_22479;
(statearr_22615[(41)] = inst_22085__$1);

return statearr_22615;
})();
if(cljs.core.truth_(inst_22085__$1)){
var statearr_22616_22805 = state_22479__$1;
(statearr_22616_22805[(1)] = (21));

} else {
var statearr_22617_22806 = state_22479__$1;
(statearr_22617_22806[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (57))){
var inst_22081 = (state_22479[(13)]);
var inst_22161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22162 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22163 = (new cljs.core.PersistentVector(null,3,(5),inst_22161,inst_22162,null));
var inst_22164 = cljs.core.select_keys.call(null,inst_22081,inst_22163);
var inst_22165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22173 = flakes;
var inst_22174 = cljs.core.seq.call(null,inst_22173);
var inst_22175 = cljs.core.first.call(null,inst_22174);
var inst_22176 = cljs.core.next.call(null,inst_22174);
var inst_22177 = cljs.core.PersistentVector.EMPTY;
var inst_22178 = inst_22173;
var inst_22179 = inst_22177;
var state_22479__$1 = (function (){var statearr_22618 = state_22479;
(statearr_22618[(57)] = inst_22175);

(statearr_22618[(53)] = inst_22164);

(statearr_22618[(58)] = inst_22176);

(statearr_22618[(24)] = inst_22178);

(statearr_22618[(9)] = inst_22179);

(statearr_22618[(51)] = inst_22165);

return statearr_22618;
})();
var statearr_22619_22807 = state_22479__$1;
(statearr_22619_22807[(2)] = null);

(statearr_22619_22807[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (68))){
var inst_22204 = (state_22479[(2)]);
var state_22479__$1 = (function (){var statearr_22620 = state_22479;
(statearr_22620[(22)] = inst_22204);

return statearr_22620;
})();
if(cljs.core.truth_(fuel)){
var statearr_22621_22808 = state_22479__$1;
(statearr_22621_22808[(1)] = (70));

} else {
var statearr_22622_22809 = state_22479__$1;
(statearr_22622_22809[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (11))){
var inst_22066 = (state_22479[(42)]);
var inst_22066__$1 = (state_22479[(2)]);
var inst_22068 = cljs.core.contains_QMARK_.call(null,inst_22066__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22069 = (!(inst_22068));
var state_22479__$1 = (function (){var statearr_22623 = state_22479;
(statearr_22623[(42)] = inst_22066__$1);

return statearr_22623;
})();
if(inst_22069){
var statearr_22624_22810 = state_22479__$1;
(statearr_22624_22810[(1)] = (12));

} else {
var statearr_22625_22811 = state_22479__$1;
(statearr_22625_22811[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (115))){
var inst_22425 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22627_22812 = state_22479__$1;
(statearr_22627_22812[(2)] = inst_22425);

(statearr_22627_22812[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (9))){
var inst_22060 = cljs.core.first.call(null,flakes);
var inst_22061 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22060);
var inst_22062 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22063 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22061,inst_22062);
var state_22479__$1 = state_22479;
var statearr_22628_22813 = state_22479__$1;
(statearr_22628_22813[(2)] = inst_22063);

(statearr_22628_22813[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (5))){
var _ = (function (){var statearr_22629 = state_22479;
(statearr_22629[(4)] = cljs.core.rest.call(null,(state_22479[(4)])));

return statearr_22629;
})();
var state_22479__$1 = state_22479;
var ex22626 = (state_22479__$1[(2)]);
var statearr_22630_22814 = state_22479__$1;
(statearr_22630_22814[(5)] = ex22626);


if((ex22626 instanceof Error)){
var statearr_22631_22815 = state_22479__$1;
(statearr_22631_22815[(1)] = (4));

(statearr_22631_22815[(5)] = null);

} else {
throw ex22626;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (112))){
var inst_22437 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22632_22816 = state_22479__$1;
(statearr_22632_22816[(2)] = inst_22437);

(statearr_22632_22816[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (83))){
var inst_22282 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22633_22817 = state_22479__$1;
(statearr_22633_22817[(2)] = inst_22282);

(statearr_22633_22817[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (14))){
var inst_22066 = (state_22479[(42)]);
var inst_22074 = (state_22479[(2)]);
var inst_22075 = cljs.core.contains_QMARK_.call(null,inst_22066,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22076 = (!(inst_22075));
var state_22479__$1 = (function (){var statearr_22634 = state_22479;
(statearr_22634[(36)] = inst_22074);

return statearr_22634;
})();
if(inst_22076){
var statearr_22635_22818 = state_22479__$1;
(statearr_22635_22818[(1)] = (15));

} else {
var statearr_22636_22819 = state_22479__$1;
(statearr_22636_22819[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (45))){
var inst_22092 = (state_22479[(17)]);
var inst_22096 = (state_22479[(18)]);
var inst_22132 = cljs.core.get.call(null,acc,inst_22092);
var inst_22133 = cljs.core.count.call(null,inst_22132);
var inst_22134 = (inst_22133 >= inst_22096);
var state_22479__$1 = state_22479;
var statearr_22637_22820 = state_22479__$1;
(statearr_22637_22820[(2)] = inst_22134);

(statearr_22637_22820[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (53))){
var inst_22159 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22159)){
var statearr_22638_22821 = state_22479__$1;
(statearr_22638_22821[(1)] = (57));

} else {
var statearr_22639_22822 = state_22479__$1;
(statearr_22639_22822[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (78))){
var inst_22441 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22640_22823 = state_22479__$1;
(statearr_22640_22823[(2)] = inst_22441);

(statearr_22640_22823[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (132))){
var state_22479__$1 = state_22479;
var statearr_22642_22824 = state_22479__$1;
(statearr_22642_22824[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (26))){
var inst_22114 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22114)){
var statearr_22644_22825 = state_22479__$1;
(statearr_22644_22825[(1)] = (33));

} else {
var statearr_22645_22826 = state_22479__$1;
(statearr_22645_22826[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (123))){
var inst_22394 = (state_22479[(39)]);
var inst_22387 = (state_22479[(33)]);
var tmp22641 = inst_22387;
var inst_22386 = inst_22394;
var inst_22387__$1 = tmp22641;
var state_22479__$1 = (function (){var statearr_22646 = state_22479;
(statearr_22646[(33)] = inst_22387__$1);

(statearr_22646[(38)] = inst_22386);

return statearr_22646;
})();
var statearr_22647_22827 = state_22479__$1;
(statearr_22647_22827[(2)] = null);

(statearr_22647_22827[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (16))){
var inst_22074 = (state_22479[(36)]);
var state_22479__$1 = state_22479;
var statearr_22648_22828 = state_22479__$1;
(statearr_22648_22828[(2)] = inst_22074);

(statearr_22648_22828[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (133))){
var inst_22472 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22649_22829 = state_22479__$1;
(statearr_22649_22829[(2)] = inst_22472);

(statearr_22649_22829[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (81))){
var inst_22081 = (state_22479[(13)]);
var inst_22248 = (state_22479[(28)]);
var inst_22257 = (state_22479[(59)]);
var inst_22251 = cljs.core.deref.call(null,cache);
var inst_22252 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22253 = inst_22248.o;
var inst_22254 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22081);
var inst_22255 = [inst_22253,inst_22254];
var inst_22256 = (new cljs.core.PersistentVector(null,2,(5),inst_22252,inst_22255,null));
var inst_22257__$1 = cljs.core.get.call(null,inst_22251,inst_22256);
var state_22479__$1 = (function (){var statearr_22650 = state_22479;
(statearr_22650[(59)] = inst_22257__$1);

return statearr_22650;
})();
if(cljs.core.truth_(inst_22257__$1)){
var statearr_22651_22830 = state_22479__$1;
(statearr_22651_22830[(1)] = (84));

} else {
var statearr_22652_22831 = state_22479__$1;
(statearr_22652_22831[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (120))){
var inst_22421 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22653_22832 = state_22479__$1;
(statearr_22653_22832[(2)] = inst_22421);

(statearr_22653_22832[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (79))){
var inst_22248 = (state_22479[(28)]);
var inst_22241 = (state_22479[(45)]);
var inst_22247 = cljs.core.seq.call(null,inst_22241);
var inst_22248__$1 = cljs.core.first.call(null,inst_22247);
var inst_22249 = cljs.core.next.call(null,inst_22247);
var state_22479__$1 = (function (){var statearr_22654 = state_22479;
(statearr_22654[(44)] = inst_22249);

(statearr_22654[(28)] = inst_22248__$1);

return statearr_22654;
})();
if(cljs.core.truth_(inst_22248__$1)){
var statearr_22655_22833 = state_22479__$1;
(statearr_22655_22833[(1)] = (81));

} else {
var statearr_22656_22834 = state_22479__$1;
(statearr_22656_22834[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (38))){
var inst_22116 = (state_22479[(43)]);
var inst_22124 = (state_22479[(2)]);
var inst_22125 = [null,inst_22124];
var inst_22126 = (new cljs.core.PersistentVector(null,2,(5),inst_22116,inst_22125,null));
var state_22479__$1 = state_22479;
var statearr_22657_22835 = state_22479__$1;
(statearr_22657_22835[(2)] = inst_22126);

(statearr_22657_22835[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (126))){
var state_22479__$1 = state_22479;
var statearr_22658_22836 = state_22479__$1;
(statearr_22658_22836[(2)] = null);

(statearr_22658_22836[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (98))){
var inst_22295 = (state_22479[(60)]);
var inst_22359 = (state_22479[(2)]);
var inst_22360 = [inst_22359,offset_map];
var inst_22361 = (new cljs.core.PersistentVector(null,2,(5),inst_22295,inst_22360,null));
var state_22479__$1 = state_22479;
var statearr_22659_22837 = state_22479__$1;
(statearr_22659_22837[(2)] = inst_22361);

(statearr_22659_22837[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (124))){
var inst_22415 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22660_22838 = state_22479__$1;
(statearr_22660_22838[(2)] = inst_22415);

(statearr_22660_22838[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (87))){
var inst_22081 = (state_22479[(13)]);
var inst_22248 = (state_22479[(28)]);
var inst_22264 = (state_22479[(2)]);
var inst_22265 = fluree.db.util.async.throw_err.call(null,inst_22264);
var inst_22266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22267 = inst_22248.o;
var inst_22268 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22081);
var inst_22269 = [inst_22267,inst_22268];
var inst_22270 = (new cljs.core.PersistentVector(null,2,(5),inst_22266,inst_22269,null));
var inst_22271 = fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22270,inst_22265);
var state_22479__$1 = (function (){var statearr_22661 = state_22479;
(statearr_22661[(61)] = inst_22271);

return statearr_22661;
})();
var statearr_22662_22839 = state_22479__$1;
(statearr_22662_22839[(2)] = inst_22265);

(statearr_22662_22839[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (30))){
var inst_22099 = (state_22479[(20)]);
var inst_22104 = cljs.core.get.call(null,offset_map,inst_22099);
var inst_22105 = cljs.core.not_EQ_.call(null,(0),inst_22104);
var state_22479__$1 = state_22479;
var statearr_22663_22840 = state_22479__$1;
(statearr_22663_22840[(2)] = inst_22105);

(statearr_22663_22840[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (73))){
var inst_22204 = (state_22479[(22)]);
var inst_22179 = (state_22479[(9)]);
var inst_22213 = cljs.core.conj.call(null,inst_22179,inst_22204);
var state_22479__$1 = state_22479;
var statearr_22664_22841 = state_22479__$1;
(statearr_22664_22841[(2)] = inst_22213);

(statearr_22664_22841[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (96))){
var inst_22439 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
var statearr_22665_22842 = state_22479__$1;
(statearr_22665_22842[(2)] = inst_22439);

(statearr_22665_22842[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (10))){
var state_22479__$1 = state_22479;
var statearr_22666_22843 = state_22479__$1;
(statearr_22666_22843[(2)] = pred_spec);

(statearr_22666_22843[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (18))){
var inst_22082 = (state_22479[(52)]);
var state_22479__$1 = state_22479;
var statearr_22667_22844 = state_22479__$1;
(statearr_22667_22844[(2)] = inst_22082);

(statearr_22667_22844[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (105))){
var inst_22347 = (state_22479[(2)]);
var state_22479__$1 = (function (){var statearr_22668 = state_22479;
(statearr_22668[(46)] = inst_22347);

return statearr_22668;
})();
if(cljs.core.truth_(fuel)){
var statearr_22669_22845 = state_22479__$1;
(statearr_22669_22845[(1)] = (107));

} else {
var statearr_22670_22846 = state_22479__$1;
(statearr_22670_22846[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (52))){
var inst_22149 = (state_22479[(62)]);
var state_22479__$1 = state_22479;
var statearr_22671_22847 = state_22479__$1;
(statearr_22671_22847[(2)] = inst_22149);

(statearr_22671_22847[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (114))){
var inst_22381 = flakes;
var inst_22382 = cljs.core.seq.call(null,inst_22381);
var inst_22383 = cljs.core.first.call(null,inst_22382);
var inst_22384 = cljs.core.next.call(null,inst_22382);
var inst_22385 = cljs.core.PersistentVector.EMPTY;
var inst_22386 = inst_22381;
var inst_22387 = inst_22385;
var state_22479__$1 = (function (){var statearr_22672 = state_22479;
(statearr_22672[(63)] = inst_22384);

(statearr_22672[(33)] = inst_22387);

(statearr_22672[(64)] = inst_22383);

(statearr_22672[(38)] = inst_22386);

return statearr_22672;
})();
var statearr_22673_22848 = state_22479__$1;
(statearr_22673_22848[(2)] = null);

(statearr_22673_22848[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (67))){
var state_22479__$1 = state_22479;
var statearr_22674_22849 = state_22479__$1;
(statearr_22674_22849[(2)] = null);

(statearr_22674_22849[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (71))){
var state_22479__$1 = state_22479;
var statearr_22675_22850 = state_22479__$1;
(statearr_22675_22850[(2)] = null);

(statearr_22675_22850[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (42))){
var inst_22096 = (state_22479[(18)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22096)){
var statearr_22676_22851 = state_22479__$1;
(statearr_22676_22851[(1)] = (45));

} else {
var statearr_22677_22852 = state_22479__$1;
(statearr_22677_22852[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (80))){
var inst_22228 = (state_22479[(56)]);
var inst_22284 = (state_22479[(2)]);
var inst_22285 = [inst_22284,offset_map];
var inst_22286 = (new cljs.core.PersistentVector(null,2,(5),inst_22228,inst_22285,null));
var state_22479__$1 = state_22479;
var statearr_22678_22853 = state_22479__$1;
(statearr_22678_22853[(2)] = inst_22286);

(statearr_22678_22853[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (37))){
var inst_22099 = (state_22479[(20)]);
var inst_22098 = (state_22479[(21)]);
var inst_22121 = (inst_22098 - (1));
var inst_22122 = cljs.core.assoc.call(null,offset_map,inst_22099,inst_22121);
var state_22479__$1 = state_22479;
var statearr_22679_22854 = state_22479__$1;
(statearr_22679_22854[(2)] = inst_22122);

(statearr_22679_22854[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (63))){
var inst_22179 = (state_22479[(9)]);
var state_22479__$1 = state_22479;
var statearr_22680_22855 = state_22479__$1;
(statearr_22680_22855[(2)] = inst_22179);

(statearr_22680_22855[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (94))){
var inst_22295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22303 = flakes;
var inst_22304 = cljs.core.seq.call(null,inst_22303);
var inst_22305 = cljs.core.first.call(null,inst_22304);
var inst_22306 = cljs.core.next.call(null,inst_22304);
var inst_22307 = cljs.core.PersistentVector.EMPTY;
var inst_22308 = inst_22303;
var inst_22309 = inst_22307;
var state_22479__$1 = (function (){var statearr_22681 = state_22479;
(statearr_22681[(32)] = inst_22309);

(statearr_22681[(65)] = inst_22305);

(statearr_22681[(48)] = inst_22308);

(statearr_22681[(60)] = inst_22295);

(statearr_22681[(66)] = inst_22306);

return statearr_22681;
})();
var statearr_22682_22856 = state_22479__$1;
(statearr_22682_22856[(2)] = null);

(statearr_22682_22856[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (8))){
var inst_22058 = (state_22479[(2)]);
var state_22479__$1 = state_22479;
if(cljs.core.truth_(inst_22058)){
var statearr_22683_22857 = state_22479__$1;
(statearr_22683_22857[(1)] = (9));

} else {
var statearr_22684_22858 = state_22479__$1;
(statearr_22684_22858[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (49))){
var inst_22149 = (state_22479[(62)]);
var inst_22149__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22479__$1 = (function (){var statearr_22685 = state_22479;
(statearr_22685[(62)] = inst_22149__$1);

return statearr_22685;
})();
if(inst_22149__$1){
var statearr_22686_22859 = state_22479__$1;
(statearr_22686_22859[(1)] = (51));

} else {
var statearr_22687_22860 = state_22479__$1;
(statearr_22687_22860[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22480 === (84))){
var inst_22257 = (state_22479[(59)]);
var state_22479__$1 = state_22479;
var statearr_22688_22861 = state_22479__$1;
(statearr_22688_22861[(2)] = inst_22257);

(statearr_22688_22861[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_22689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22689[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_22689[(1)] = (1));

return statearr_22689;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_22479){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_22479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e22690){var ex__2744__auto__ = e22690;
var statearr_22691_22862 = state_22479;
(statearr_22691_22862[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_22479[(4)]))){
var statearr_22692_22863 = state_22479;
(statearr_22692_22863[(1)] = cljs.core.first.call(null,(state_22479[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22864 = state_22479;
state_22479 = G__22864;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_22479){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_22479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_22693 = f__2764__auto__.call(null);
(statearr_22693[(6)] = c__2763__auto__);

return statearr_22693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23024){
var state_val_23025 = (state_23024[(1)]);
if((state_val_23025 === (7))){
var inst_23019 = (state_23024[(2)]);
var _ = (function (){var statearr_23026 = state_23024;
(statearr_23026[(4)] = cljs.core.rest.call(null,(state_23024[(4)])));

return statearr_23026;
})();
var state_23024__$1 = state_23024;
var statearr_23027_23109 = state_23024__$1;
(statearr_23027_23109[(2)] = inst_23019);

(statearr_23027_23109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (20))){
var inst_22946 = (state_23024[(7)]);
var state_23024__$1 = state_23024;
var statearr_23028_23110 = state_23024__$1;
(statearr_23028_23110[(2)] = inst_22946);

(statearr_23028_23110[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (27))){
var inst_22901 = (state_23024[(8)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22901)){
var statearr_23029_23111 = state_23024__$1;
(statearr_23029_23111[(1)] = (29));

} else {
var statearr_23030_23112 = state_23024__$1;
(statearr_23030_23112[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (1))){
var state_23024__$1 = state_23024;
var statearr_23031_23113 = state_23024__$1;
(statearr_23031_23113[(2)] = null);

(statearr_23031_23113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (24))){
var inst_22902 = (state_23024[(9)]);
var state_23024__$1 = state_23024;
var statearr_23032_23114 = state_23024__$1;
(statearr_23032_23114[(2)] = inst_22902);

(statearr_23032_23114[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (39))){
var inst_22938 = (state_23024[(10)]);
var state_23024__$1 = state_23024;
var statearr_23033_23115 = state_23024__$1;
(statearr_23033_23115[(2)] = inst_22938);

(statearr_23033_23115[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (46))){
var inst_22903 = (state_23024[(11)]);
var state_23024__$1 = state_23024;
var statearr_23034_23116 = state_23024__$1;
(statearr_23034_23116[(2)] = inst_22903);

(statearr_23034_23116[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (4))){
var inst_22865 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23035_23117 = state_23024__$1;
(statearr_23035_23117[(2)] = inst_22865);

(statearr_23035_23117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (15))){
var inst_22914 = (state_23024[(12)]);
var inst_22920 = cljs.core.count.call(null,inst_22914);
var inst_22921 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22920,max_fuel);
var state_23024__$1 = state_23024;
var statearr_23036_23118 = state_23024__$1;
(statearr_23036_23118[(2)] = inst_22921);

(statearr_23036_23118[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (48))){
var inst_23005 = (state_23024[(13)]);
var inst_22883 = (state_23024[(14)]);
var inst_22890 = (state_23024[(15)]);
var inst_23013 = (state_23024[(2)]);
var inst_23014 = cljs.core.assoc.call(null,inst_22883,inst_23013,inst_23005);
var inst_22882 = inst_22890;
var inst_22883__$1 = inst_23014;
var state_23024__$1 = (function (){var statearr_23037 = state_23024;
(statearr_23037[(16)] = inst_22882);

(statearr_23037[(14)] = inst_22883__$1);

return statearr_23037;
})();
var statearr_23038_23119 = state_23024__$1;
(statearr_23038_23119[(2)] = null);

(statearr_23038_23119[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (50))){
var inst_22905 = (state_23024[(17)]);
var state_23024__$1 = state_23024;
var statearr_23039_23120 = state_23024__$1;
(statearr_23039_23120[(2)] = inst_22905);

(statearr_23039_23120[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (21))){
var inst_22902 = (state_23024[(9)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22902)){
var statearr_23041_23121 = state_23024__$1;
(statearr_23041_23121[(1)] = (23));

} else {
var statearr_23042_23122 = state_23024__$1;
(statearr_23042_23122[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (31))){
var inst_22962 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22962)){
var statearr_23043_23123 = state_23024__$1;
(statearr_23043_23123[(1)] = (32));

} else {
var statearr_23044_23124 = state_23024__$1;
(statearr_23044_23124[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (32))){
var inst_22945 = (state_23024[(18)]);
var inst_22937 = (state_23024[(19)]);
var inst_22938 = (state_23024[(10)]);
var inst_22964 = (inst_22937 + (1));
var tmp23040 = inst_22938;
var inst_22936 = inst_22945;
var inst_22937__$1 = inst_22964;
var inst_22938__$1 = tmp23040;
var state_23024__$1 = (function (){var statearr_23045 = state_23024;
(statearr_23045[(20)] = inst_22936);

(statearr_23045[(19)] = inst_22937__$1);

(statearr_23045[(10)] = inst_22938__$1);

return statearr_23045;
})();
var statearr_23046_23125 = state_23024__$1;
(statearr_23046_23125[(2)] = null);

(statearr_23046_23125[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (40))){
var state_23024__$1 = state_23024;
if(cljs.core.truth_(fuel)){
var statearr_23047_23126 = state_23024__$1;
(statearr_23047_23126[(1)] = (42));

} else {
var statearr_23048_23127 = state_23024__$1;
(statearr_23048_23127[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (33))){
var state_23024__$1 = state_23024;
var statearr_23049_23128 = state_23024__$1;
(statearr_23049_23128[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (13))){
var inst_22914 = (state_23024[(12)]);
var state_23024__$1 = state_23024;
var statearr_23051_23129 = state_23024__$1;
(statearr_23051_23129[(2)] = inst_22914);

(statearr_23051_23129[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (22))){
var inst_22955 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22955)){
var statearr_23052_23130 = state_23024__$1;
(statearr_23052_23130[(1)] = (26));

} else {
var statearr_23053_23131 = state_23024__$1;
(statearr_23053_23131[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (36))){
var state_23024__$1 = state_23024;
var statearr_23054_23132 = state_23024__$1;
(statearr_23054_23132[(2)] = null);

(statearr_23054_23132[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (41))){
var inst_22945 = (state_23024[(18)]);
var inst_22937 = (state_23024[(19)]);
var inst_22994 = (state_23024[(2)]);
var inst_22995 = (inst_22937 + (1));
var inst_22936 = inst_22945;
var inst_22937__$1 = inst_22995;
var inst_22938 = inst_22994;
var state_23024__$1 = (function (){var statearr_23055 = state_23024;
(statearr_23055[(20)] = inst_22936);

(statearr_23055[(19)] = inst_22937__$1);

(statearr_23055[(10)] = inst_22938);

return statearr_23055;
})();
var statearr_23056_23133 = state_23024__$1;
(statearr_23056_23133[(2)] = null);

(statearr_23056_23133[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (43))){
var state_23024__$1 = state_23024;
var statearr_23057_23134 = state_23024__$1;
(statearr_23057_23134[(2)] = null);

(statearr_23057_23134[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (29))){
var inst_22901 = (state_23024[(8)]);
var inst_22937 = (state_23024[(19)]);
var inst_22959 = (inst_22937 < inst_22901);
var state_23024__$1 = state_23024;
var statearr_23058_23135 = state_23024__$1;
(statearr_23058_23135[(2)] = inst_22959);

(statearr_23058_23135[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (44))){
var inst_22978 = (state_23024[(21)]);
var inst_22974 = (state_23024[(22)]);
var inst_22987 = (state_23024[(2)]);
var inst_22988 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22978,inst_22974);
var state_23024__$1 = (function (){var statearr_23059 = state_23024;
(statearr_23059[(23)] = inst_22987);

return statearr_23059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23024__$1,(45),inst_22988);
} else {
if((state_val_23025 === (6))){
var inst_22889 = (state_23024[(24)]);
var inst_22882 = (state_23024[(16)]);
var inst_22888 = cljs.core.seq.call(null,inst_22882);
var inst_22889__$1 = cljs.core.first.call(null,inst_22888);
var inst_22890 = cljs.core.next.call(null,inst_22888);
var inst_22891 = cljs.core.not.call(null,inst_22889__$1);
var state_23024__$1 = (function (){var statearr_23060 = state_23024;
(statearr_23060[(24)] = inst_22889__$1);

(statearr_23060[(15)] = inst_22890);

return statearr_23060;
})();
if(inst_22891){
var statearr_23061_23136 = state_23024__$1;
(statearr_23061_23136[(1)] = (8));

} else {
var statearr_23062_23137 = state_23024__$1;
(statearr_23062_23137[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (28))){
var inst_23003 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23063_23138 = state_23024__$1;
(statearr_23063_23138[(2)] = inst_23003);

(statearr_23063_23138[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (51))){
var inst_23011 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23064_23139 = state_23024__$1;
(statearr_23064_23139[(2)] = inst_23011);

(statearr_23064_23139[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (25))){
var inst_22953 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23065_23140 = state_23024__$1;
(statearr_23065_23140[(2)] = inst_22953);

(statearr_23065_23140[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (34))){
var inst_23001 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23066_23141 = state_23024__$1;
(statearr_23066_23141[(2)] = inst_23001);

(statearr_23066_23141[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (17))){
var inst_22914 = (state_23024[(12)]);
var inst_22924 = (state_23024[(2)]);
var inst_22932 = cljs.core.seq.call(null,inst_22914);
var inst_22933 = cljs.core.first.call(null,inst_22932);
var inst_22934 = cljs.core.next.call(null,inst_22932);
var inst_22935 = cljs.core.PersistentVector.EMPTY;
var inst_22936 = inst_22914;
var inst_22937 = (0);
var inst_22938 = inst_22935;
var state_23024__$1 = (function (){var statearr_23067 = state_23024;
(statearr_23067[(25)] = inst_22934);

(statearr_23067[(20)] = inst_22936);

(statearr_23067[(19)] = inst_22937);

(statearr_23067[(26)] = inst_22933);

(statearr_23067[(10)] = inst_22938);

(statearr_23067[(27)] = inst_22924);

return statearr_23067;
})();
var statearr_23068_23142 = state_23024__$1;
(statearr_23068_23142[(2)] = null);

(statearr_23068_23142[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (3))){
var inst_23022 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23024__$1,inst_23022);
} else {
if((state_val_23025 === (12))){
var state_23024__$1 = state_23024;
var statearr_23069_23143 = state_23024__$1;
(statearr_23069_23143[(2)] = fuel);

(statearr_23069_23143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (2))){
var _ = (function (){var statearr_23070 = state_23024;
(statearr_23070[(4)] = cljs.core.cons.call(null,(5),(state_23024[(4)])));

return statearr_23070;
})();
var inst_22878 = reverse_refs_specs;
var inst_22879 = cljs.core.seq.call(null,inst_22878);
var inst_22880 = cljs.core.first.call(null,inst_22879);
var inst_22881 = cljs.core.next.call(null,inst_22879);
var inst_22882 = inst_22878;
var inst_22883 = null;
var state_23024__$1 = (function (){var statearr_23071 = state_23024;
(statearr_23071[(28)] = inst_22881);

(statearr_23071[(16)] = inst_22882);

(statearr_23071[(29)] = inst_22880);

(statearr_23071[(14)] = inst_22883);

return statearr_23071;
})();
var statearr_23072_23144 = state_23024__$1;
(statearr_23072_23144[(2)] = null);

(statearr_23072_23144[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (23))){
var inst_22902 = (state_23024[(9)]);
var inst_22937 = (state_23024[(19)]);
var inst_22950 = (inst_22937 >= inst_22902);
var state_23024__$1 = state_23024;
var statearr_23073_23145 = state_23024__$1;
(statearr_23073_23145[(2)] = inst_22950);

(statearr_23073_23145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (47))){
var inst_22904 = (state_23024[(30)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22904)){
var statearr_23074_23146 = state_23024__$1;
(statearr_23074_23146[(1)] = (49));

} else {
var statearr_23075_23147 = state_23024__$1;
(statearr_23075_23147[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (35))){
var inst_22944 = (state_23024[(31)]);
var inst_22968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22969 = [inst_22944];
var inst_22970 = (new cljs.core.PersistentVector(null,1,(5),inst_22968,inst_22969,null));
var inst_22971 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22970);
var state_23024__$1 = state_23024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23024__$1,(38),inst_22971);
} else {
if((state_val_23025 === (19))){
var inst_22903 = (state_23024[(11)]);
var inst_23005 = (state_23024[(2)]);
var state_23024__$1 = (function (){var statearr_23076 = state_23024;
(statearr_23076[(13)] = inst_23005);

return statearr_23076;
})();
if(cljs.core.truth_(inst_22903)){
var statearr_23077_23148 = state_23024__$1;
(statearr_23077_23148[(1)] = (46));

} else {
var statearr_23078_23149 = state_23024__$1;
(statearr_23078_23149[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (11))){
var inst_22914 = (state_23024[(12)]);
var inst_22911 = (state_23024[(2)]);
var inst_22912 = fluree.db.util.async.throw_err.call(null,inst_22911);
var inst_22913 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_22912);
var inst_22914__$1 = cljs.core.not_empty.call(null,inst_22913);
var state_23024__$1 = (function (){var statearr_23080 = state_23024;
(statearr_23080[(12)] = inst_22914__$1);

return statearr_23080;
})();
if(cljs.core.truth_(inst_22914__$1)){
var statearr_23081_23150 = state_23024__$1;
(statearr_23081_23150[(1)] = (12));

} else {
var statearr_23082_23151 = state_23024__$1;
(statearr_23082_23151[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (9))){
var inst_22889 = (state_23024[(24)]);
var inst_22899 = (state_23024[(32)]);
var inst_22898 = cljs.core.nth.call(null,inst_22889,(0),null);
var inst_22899__$1 = cljs.core.nth.call(null,inst_22889,(1),null);
var inst_22900 = cljs.core.__destructure_map.call(null,inst_22899__$1);
var inst_22901 = cljs.core.get.call(null,inst_22900,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22902 = cljs.core.get.call(null,inst_22900,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22903 = cljs.core.get.call(null,inst_22900,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22904 = cljs.core.get.call(null,inst_22900,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22905 = cljs.core.get.call(null,inst_22900,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22907 = [subject_id,inst_22898];
var inst_22908 = (new cljs.core.PersistentVector(null,2,(5),inst_22906,inst_22907,null));
var inst_22909 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22908);
var state_23024__$1 = (function (){var statearr_23083 = state_23024;
(statearr_23083[(11)] = inst_22903);

(statearr_23083[(8)] = inst_22901);

(statearr_23083[(17)] = inst_22905);

(statearr_23083[(32)] = inst_22899__$1);

(statearr_23083[(9)] = inst_22902);

(statearr_23083[(30)] = inst_22904);

return statearr_23083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23024__$1,(11),inst_22909);
} else {
if((state_val_23025 === (5))){
var _ = (function (){var statearr_23084 = state_23024;
(statearr_23084[(4)] = cljs.core.rest.call(null,(state_23024[(4)])));

return statearr_23084;
})();
var state_23024__$1 = state_23024;
var ex23079 = (state_23024__$1[(2)]);
var statearr_23085_23152 = state_23024__$1;
(statearr_23085_23152[(5)] = ex23079);


if((ex23079 instanceof Error)){
var statearr_23086_23153 = state_23024__$1;
(statearr_23086_23153[(1)] = (4));

(statearr_23086_23153[(5)] = null);

} else {
throw ex23079;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (14))){
var inst_22918 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
if(cljs.core.truth_(inst_22918)){
var statearr_23087_23154 = state_23024__$1;
(statearr_23087_23154[(1)] = (15));

} else {
var statearr_23088_23155 = state_23024__$1;
(statearr_23088_23155[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (45))){
var inst_22938 = (state_23024[(10)]);
var inst_22990 = (state_23024[(2)]);
var inst_22991 = fluree.db.util.async.throw_err.call(null,inst_22990);
var inst_22992 = cljs.core.conj.call(null,inst_22938,inst_22991);
var state_23024__$1 = state_23024;
var statearr_23089_23156 = state_23024__$1;
(statearr_23089_23156[(2)] = inst_22992);

(statearr_23089_23156[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (26))){
var inst_22938 = (state_23024[(10)]);
var state_23024__$1 = state_23024;
var statearr_23090_23157 = state_23024__$1;
(statearr_23090_23157[(2)] = inst_22938);

(statearr_23090_23157[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (16))){
var state_23024__$1 = state_23024;
var statearr_23091_23158 = state_23024__$1;
(statearr_23091_23158[(2)] = null);

(statearr_23091_23158[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (38))){
var inst_22899 = (state_23024[(32)]);
var inst_22974 = (state_23024[(22)]);
var inst_22973 = (state_23024[(2)]);
var inst_22974__$1 = fluree.db.util.async.throw_err.call(null,inst_22973);
var inst_22975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22976 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22977 = (new cljs.core.PersistentVector(null,4,(5),inst_22975,inst_22976,null));
var inst_22978 = cljs.core.select_keys.call(null,inst_22899,inst_22977);
var inst_22979 = cljs.core.empty_QMARK_.call(null,inst_22974__$1);
var state_23024__$1 = (function (){var statearr_23092 = state_23024;
(statearr_23092[(21)] = inst_22978);

(statearr_23092[(22)] = inst_22974__$1);

return statearr_23092;
})();
if(inst_22979){
var statearr_23093_23159 = state_23024__$1;
(statearr_23093_23159[(1)] = (39));

} else {
var statearr_23094_23160 = state_23024__$1;
(statearr_23094_23160[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (30))){
var inst_22901 = (state_23024[(8)]);
var state_23024__$1 = state_23024;
var statearr_23095_23161 = state_23024__$1;
(statearr_23095_23161[(2)] = inst_22901);

(statearr_23095_23161[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (10))){
var inst_23017 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23096_23162 = state_23024__$1;
(statearr_23096_23162[(2)] = inst_23017);

(statearr_23096_23162[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (18))){
var inst_22944 = (state_23024[(31)]);
var inst_22936 = (state_23024[(20)]);
var inst_22946 = (state_23024[(7)]);
var inst_22943 = cljs.core.seq.call(null,inst_22936);
var inst_22944__$1 = cljs.core.first.call(null,inst_22943);
var inst_22945 = cljs.core.next.call(null,inst_22943);
var inst_22946__$1 = cljs.core.not.call(null,inst_22944__$1);
var state_23024__$1 = (function (){var statearr_23097 = state_23024;
(statearr_23097[(18)] = inst_22945);

(statearr_23097[(31)] = inst_22944__$1);

(statearr_23097[(7)] = inst_22946__$1);

return statearr_23097;
})();
if(inst_22946__$1){
var statearr_23098_23163 = state_23024__$1;
(statearr_23098_23163[(1)] = (20));

} else {
var statearr_23099_23164 = state_23024__$1;
(statearr_23099_23164[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (42))){
var inst_22974 = (state_23024[(22)]);
var inst_22983 = cljs.core.count.call(null,inst_22974);
var inst_22984 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22983,max_fuel);
var state_23024__$1 = state_23024;
var statearr_23100_23165 = state_23024__$1;
(statearr_23100_23165[(2)] = inst_22984);

(statearr_23100_23165[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (37))){
var inst_22999 = (state_23024[(2)]);
var state_23024__$1 = state_23024;
var statearr_23101_23166 = state_23024__$1;
(statearr_23101_23166[(2)] = inst_22999);

(statearr_23101_23166[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (8))){
var inst_22883 = (state_23024[(14)]);
var state_23024__$1 = state_23024;
var statearr_23102_23167 = state_23024__$1;
(statearr_23102_23167[(2)] = inst_22883);

(statearr_23102_23167[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23025 === (49))){
var inst_22904 = (state_23024[(30)]);
var state_23024__$1 = state_23024;
var statearr_23103_23168 = state_23024__$1;
(statearr_23103_23168[(2)] = inst_22904);

(statearr_23103_23168[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0 = (function (){
var statearr_23104 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23104[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__);

(statearr_23104[(1)] = (1));

return statearr_23104;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1 = (function (state_23024){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_23024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23105){var ex__2744__auto__ = e23105;
var statearr_23106_23169 = state_23024;
(statearr_23106_23169[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_23024[(4)]))){
var statearr_23107_23170 = state_23024;
(statearr_23107_23170[(1)] = cljs.core.first.call(null,(state_23024[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23171 = state_23024;
state_23024 = G__23171;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__ = function(state_23024){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1.call(this,state_23024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23108 = f__2764__auto__.call(null);
(statearr_23108[(6)] = c__2763__auto__);

return statearr_23108;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4253__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23172 = select_spec;
var map__23172__$1 = cljs.core.__destructure_map.call(null,map__23172);
var recur_seen = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__23172__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23286){
var state_val_23287 = (state_23286[(1)]);
if((state_val_23287 === (7))){
var inst_23198 = flakes;
var inst_23199 = cljs.core.seq.call(null,inst_23198);
var inst_23200 = cljs.core.first.call(null,inst_23199);
var inst_23201 = cljs.core.next.call(null,inst_23199);
var inst_23202 = cljs.core.PersistentVector.EMPTY;
var inst_23203 = inst_23198;
var inst_23204 = (0);
var inst_23205 = inst_23202;
var state_23286__$1 = (function (){var statearr_23288 = state_23286;
(statearr_23288[(7)] = inst_23200);

(statearr_23288[(8)] = inst_23204);

(statearr_23288[(9)] = inst_23201);

(statearr_23288[(10)] = inst_23203);

(statearr_23288[(11)] = inst_23205);

return statearr_23288;
})();
var statearr_23289_23355 = state_23286__$1;
(statearr_23289_23355[(2)] = null);

(statearr_23289_23355[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (20))){
var state_23286__$1 = state_23286;
var statearr_23290_23356 = state_23286__$1;
(statearr_23290_23356[(2)] = results);

(statearr_23290_23356[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (27))){
var state_23286__$1 = state_23286;
var statearr_23291_23357 = state_23286__$1;
(statearr_23291_23357[(2)] = null);

(statearr_23291_23357[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (1))){
var state_23286__$1 = state_23286;
var statearr_23292_23358 = state_23286__$1;
(statearr_23292_23358[(2)] = null);

(statearr_23292_23358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (24))){
var state_23286__$1 = state_23286;
var statearr_23293_23359 = state_23286__$1;
(statearr_23293_23359[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (39))){
var inst_23267 = (state_23286[(12)]);
var inst_23212 = (state_23286[(13)]);
var inst_23205 = (state_23286[(11)]);
var inst_23270 = (state_23286[(2)]);
var inst_23271 = fluree.db.util.async.throw_err.call(null,inst_23270);
var inst_23272 = cljs.core.conj.call(null,inst_23205,inst_23271);
var inst_23203 = inst_23212;
var inst_23204 = inst_23267;
var inst_23205__$1 = inst_23272;
var state_23286__$1 = (function (){var statearr_23295 = state_23286;
(statearr_23295[(8)] = inst_23204);

(statearr_23295[(10)] = inst_23203);

(statearr_23295[(11)] = inst_23205__$1);

return statearr_23295;
})();
var statearr_23296_23360 = state_23286__$1;
(statearr_23296_23360[(2)] = null);

(statearr_23296_23360[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (4))){
var inst_23173 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23297_23361 = state_23286__$1;
(statearr_23297_23361[(2)] = inst_23173);

(statearr_23297_23361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (15))){
var inst_23186 = (state_23286[(14)]);
var state_23286__$1 = state_23286;
var statearr_23298_23362 = state_23286__$1;
(statearr_23298_23362[(2)] = inst_23186);

(statearr_23298_23362[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (21))){
var inst_23182 = (state_23286[(15)]);
var state_23286__$1 = state_23286;
if(cljs.core.truth_(inst_23182)){
var statearr_23299_23363 = state_23286__$1;
(statearr_23299_23363[(1)] = (23));

} else {
var statearr_23300_23364 = state_23286__$1;
(statearr_23300_23364[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (31))){
var inst_23250 = (state_23286[(16)]);
var state_23286__$1 = state_23286;
var statearr_23301_23365 = state_23286__$1;
(statearr_23301_23365[(2)] = inst_23250);

(statearr_23301_23365[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (32))){
var inst_23242 = (state_23286[(17)]);
var inst_23256 = (state_23286[(2)]);
var state_23286__$1 = (function (){var statearr_23302 = state_23286;
(statearr_23302[(18)] = inst_23256);

return statearr_23302;
})();
if(cljs.core.truth_(inst_23242)){
var statearr_23303_23366 = state_23286__$1;
(statearr_23303_23366[(1)] = (33));

} else {
var statearr_23304_23367 = state_23286__$1;
(statearr_23304_23367[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (33))){
var inst_23242 = (state_23286[(17)]);
var state_23286__$1 = state_23286;
var statearr_23305_23368 = state_23286__$1;
(statearr_23305_23368[(2)] = inst_23242);

(statearr_23305_23368[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (13))){
var inst_23222 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
if(cljs.core.truth_(inst_23222)){
var statearr_23307_23369 = state_23286__$1;
(statearr_23307_23369[(1)] = (17));

} else {
var statearr_23308_23370 = state_23286__$1;
(statearr_23308_23370[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (22))){
var inst_23239 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23309_23371 = state_23286__$1;
(statearr_23309_23371[(2)] = inst_23239);

(statearr_23309_23371[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (36))){
var inst_23204 = (state_23286[(8)]);
var inst_23212 = (state_23286[(13)]);
var inst_23205 = (state_23286[(11)]);
var inst_23264 = (inst_23204 + (1));
var tmp23306 = inst_23205;
var inst_23203 = inst_23212;
var inst_23204__$1 = inst_23264;
var inst_23205__$1 = tmp23306;
var state_23286__$1 = (function (){var statearr_23310 = state_23286;
(statearr_23310[(8)] = inst_23204__$1);

(statearr_23310[(10)] = inst_23203);

(statearr_23310[(11)] = inst_23205__$1);

return statearr_23310;
})();
var statearr_23311_23372 = state_23286__$1;
(statearr_23311_23372[(2)] = null);

(statearr_23311_23372[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (29))){
var inst_23249 = (state_23286[(2)]);
var inst_23250 = fluree.db.util.async.throw_err.call(null,inst_23249);
var state_23286__$1 = (function (){var statearr_23312 = state_23286;
(statearr_23312[(16)] = inst_23250);

return statearr_23312;
})();
if(cljs.core.truth_(fuel)){
var statearr_23313_23373 = state_23286__$1;
(statearr_23313_23373[(1)] = (30));

} else {
var statearr_23314_23374 = state_23286__$1;
(statearr_23314_23374[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (6))){
var state_23286__$1 = state_23286;
var statearr_23315_23375 = state_23286__$1;
(statearr_23315_23375[(2)] = results);

(statearr_23315_23375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (28))){
var inst_23235 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23316_23376 = state_23286__$1;
(statearr_23316_23376[(2)] = inst_23235);

(statearr_23316_23376[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (25))){
var inst_23237 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23317_23377 = state_23286__$1;
(statearr_23317_23377[(2)] = inst_23237);

(statearr_23317_23377[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (34))){
var inst_23256 = (state_23286[(18)]);
var inst_23259 = cljs.core.empty_QMARK_.call(null,inst_23256);
var state_23286__$1 = state_23286;
var statearr_23318_23378 = state_23286__$1;
(statearr_23318_23378[(2)] = inst_23259);

(statearr_23318_23378[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (17))){
var inst_23205 = (state_23286[(11)]);
var inst_23224 = cljs.core.empty_QMARK_.call(null,inst_23205);
var state_23286__$1 = state_23286;
if(inst_23224){
var statearr_23319_23379 = state_23286__$1;
(statearr_23319_23379[(1)] = (20));

} else {
var statearr_23320_23380 = state_23286__$1;
(statearr_23320_23380[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (3))){
var inst_23284 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23286__$1,inst_23284);
} else {
if((state_val_23287 === (12))){
var inst_23186 = (state_23286[(14)]);
var state_23286__$1 = state_23286;
if(cljs.core.truth_(inst_23186)){
var statearr_23321_23381 = state_23286__$1;
(statearr_23321_23381[(1)] = (14));

} else {
var statearr_23322_23382 = state_23286__$1;
(statearr_23322_23382[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (2))){
var _ = (function (){var statearr_23323 = state_23286;
(statearr_23323[(4)] = cljs.core.cons.call(null,(5),(state_23286[(4)])));

return statearr_23323;
})();
var inst_23180 = select_spec;
var inst_23181 = cljs.core.__destructure_map.call(null,inst_23180);
var inst_23182 = cljs.core.get.call(null,inst_23181,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23183 = cljs.core.get.call(null,inst_23181,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23184 = cljs.core.get.call(null,inst_23181,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23185 = cljs.core.get.call(null,inst_23181,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23186 = cljs.core.get.call(null,inst_23181,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23187 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_23188 = (inst_23185 > inst_23187);
var state_23286__$1 = (function (){var statearr_23324 = state_23286;
(statearr_23324[(15)] = inst_23182);

(statearr_23324[(19)] = inst_23183);

(statearr_23324[(14)] = inst_23186);

(statearr_23324[(20)] = inst_23184);

return statearr_23324;
})();
if(cljs.core.truth_(inst_23188)){
var statearr_23325_23383 = state_23286__$1;
(statearr_23325_23383[(1)] = (6));

} else {
var statearr_23326_23384 = state_23286__$1;
(statearr_23326_23384[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (23))){
var inst_23183 = (state_23286[(19)]);
var inst_23205 = (state_23286[(11)]);
var inst_23228 = cljs.core.assoc.call(null,results,inst_23183,inst_23205);
var state_23286__$1 = state_23286;
var statearr_23327_23385 = state_23286__$1;
(statearr_23327_23385[(2)] = inst_23228);

(statearr_23327_23385[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (35))){
var inst_23211 = (state_23286[(21)]);
var inst_23261 = (state_23286[(2)]);
var inst_23262 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,inst_23211);
var state_23286__$1 = (function (){var statearr_23328 = state_23286;
(statearr_23328[(22)] = inst_23262);

return statearr_23328;
})();
if(cljs.core.truth_(inst_23261)){
var statearr_23329_23386 = state_23286__$1;
(statearr_23329_23386[(1)] = (36));

} else {
var statearr_23330_23387 = state_23286__$1;
(statearr_23330_23387[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (19))){
var inst_23277 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23331_23388 = state_23286__$1;
(statearr_23331_23388[(2)] = inst_23277);

(statearr_23331_23388[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (11))){
var inst_23213 = (state_23286[(23)]);
var state_23286__$1 = state_23286;
var statearr_23333_23389 = state_23286__$1;
(statearr_23333_23389[(2)] = inst_23213);

(statearr_23333_23389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (9))){
var inst_23211 = (state_23286[(21)]);
var inst_23213 = (state_23286[(23)]);
var inst_23203 = (state_23286[(10)]);
var inst_23210 = cljs.core.seq.call(null,inst_23203);
var inst_23211__$1 = cljs.core.first.call(null,inst_23210);
var inst_23212 = cljs.core.next.call(null,inst_23210);
var inst_23213__$1 = cljs.core.not.call(null,inst_23211__$1);
var state_23286__$1 = (function (){var statearr_23334 = state_23286;
(statearr_23334[(13)] = inst_23212);

(statearr_23334[(21)] = inst_23211__$1);

(statearr_23334[(23)] = inst_23213__$1);

return statearr_23334;
})();
if(inst_23213__$1){
var statearr_23335_23390 = state_23286__$1;
(statearr_23335_23390[(1)] = (11));

} else {
var statearr_23336_23391 = state_23286__$1;
(statearr_23336_23391[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (5))){
var _ = (function (){var statearr_23337 = state_23286;
(statearr_23337[(4)] = cljs.core.rest.call(null,(state_23286[(4)])));

return statearr_23337;
})();
var state_23286__$1 = state_23286;
var ex23332 = (state_23286__$1[(2)]);
var statearr_23338_23392 = state_23286__$1;
(statearr_23338_23392[(5)] = ex23332);


if((ex23332 instanceof Error)){
var statearr_23339_23393 = state_23286__$1;
(statearr_23339_23393[(1)] = (4));

(statearr_23339_23393[(5)] = null);

} else {
throw ex23332;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (14))){
var inst_23204 = (state_23286[(8)]);
var inst_23186 = (state_23286[(14)]);
var inst_23217 = (inst_23204 < inst_23186);
var state_23286__$1 = state_23286;
var statearr_23340_23394 = state_23286__$1;
(statearr_23340_23394[(2)] = inst_23217);

(statearr_23340_23394[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (26))){
var inst_23183 = (state_23286[(19)]);
var inst_23205 = (state_23286[(11)]);
var inst_23231 = cljs.core.first.call(null,inst_23205);
var inst_23232 = cljs.core.assoc.call(null,results,inst_23183,inst_23231);
var state_23286__$1 = state_23286;
var statearr_23341_23395 = state_23286__$1;
(statearr_23341_23395[(2)] = inst_23232);

(statearr_23341_23395[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (16))){
var inst_23220 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23342_23396 = state_23286__$1;
(statearr_23342_23396[(2)] = inst_23220);

(statearr_23342_23396[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (38))){
var inst_23275 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23343_23397 = state_23286__$1;
(statearr_23343_23397[(2)] = inst_23275);

(statearr_23343_23397[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (30))){
var inst_23250 = (state_23286[(16)]);
var inst_23252 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23253 = cljs.core.sequence.call(null,inst_23252,inst_23250);
var state_23286__$1 = state_23286;
var statearr_23344_23398 = state_23286__$1;
(statearr_23344_23398[(2)] = inst_23253);

(statearr_23344_23398[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (10))){
var inst_23279 = (state_23286[(2)]);
var state_23286__$1 = state_23286;
var statearr_23345_23399 = state_23286__$1;
(statearr_23345_23399[(2)] = inst_23279);

(statearr_23345_23399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23287 === (18))){
var inst_23211 = (state_23286[(21)]);
var inst_23184 = (state_23286[(20)]);
var inst_23241 = inst_23211.o;
var inst_23242 = cljs.core.contains_QMARK_.call(null,inst_23184,inst_23241);
var inst_23244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23245 = [inst_23241];
var inst_23246 = (new cljs.core.PersistentVector(null,1,(5),inst_23244,inst_23245,null));
var inst_23247 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23246);
var state_23286__$1 = (function (){var statearr_23346 = state_23286;
(statearr_23346[(17)] = inst_23242);

return statearr_23346;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23286__$1,(29),inst_23247);
} else {
if((state_val_23287 === (37))){
var inst_23204 = (state_23286[(8)]);
var inst_23256 = (state_23286[(18)]);
var inst_23262 = (state_23286[(22)]);
var inst_23267 = (inst_23204 + (1));
var inst_23268 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23262,inst_23256);
var state_23286__$1 = (function (){var statearr_23347 = state_23286;
(statearr_23347[(12)] = inst_23267);

return statearr_23347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23286__$1,(39),inst_23268);
} else {
if((state_val_23287 === (8))){
var inst_23281 = (state_23286[(2)]);
var _ = (function (){var statearr_23348 = state_23286;
(statearr_23348[(4)] = cljs.core.rest.call(null,(state_23286[(4)])));

return statearr_23348;
})();
var state_23286__$1 = state_23286;
var statearr_23349_23400 = state_23286__$1;
(statearr_23349_23400[(2)] = inst_23281);

(statearr_23349_23400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0 = (function (){
var statearr_23350 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23350[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__);

(statearr_23350[(1)] = (1));

return statearr_23350;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1 = (function (state_23286){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_23286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23351){var ex__2744__auto__ = e23351;
var statearr_23352_23401 = state_23286;
(statearr_23352_23401[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_23286[(4)]))){
var statearr_23353_23402 = state_23286;
(statearr_23353_23402[(1)] = cljs.core.first.call(null,(state_23286[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23403 = state_23286;
state_23286 = G__23403;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__ = function(state_23286){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1.call(this,state_23286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23354 = f__2764__auto__.call(null);
(statearr_23354[(6)] = c__2763__auto__);

return statearr_23354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23584){
var state_val_23585 = (state_23584[(1)]);
if((state_val_23585 === (7))){
var state_23584__$1 = state_23584;
var statearr_23586_23672 = state_23584__$1;
(statearr_23586_23672[(2)] = null);

(statearr_23586_23672[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (20))){
var inst_23442 = cljs.core.PersistentHashMap.EMPTY;
var state_23584__$1 = state_23584;
var statearr_23587_23673 = state_23584__$1;
(statearr_23587_23673[(2)] = inst_23442);

(statearr_23587_23673[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (27))){
var inst_23444 = (state_23584[(7)]);
var inst_23424 = (state_23584[(8)]);
var inst_23460 = (state_23584[(9)]);
var inst_23430 = (state_23584[(10)]);
var inst_23563 = (state_23584[(2)]);
var inst_23564 = (function (){var top_level_subject = inst_23424;
var select_spec = inst_23430;
var base_acc = inst_23444;
var acc_PLUS_refs = inst_23460;
var result = inst_23563;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4253__auto__ = (function (){var and__4251__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var and__4251__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4251__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4251__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23565 = cljs.core.PersistentVector.EMPTY;
var inst_23566 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23430);
var inst_23567 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23566);
var inst_23568 = cljs.core.vals.call(null,inst_23567);
var inst_23569 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23430);
var inst_23570 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23569);
var inst_23571 = cljs.core.vals.call(null,inst_23570);
var inst_23572 = cljs.core.concat.call(null,inst_23568,inst_23571);
var inst_23573 = cljs.core.reduce.call(null,inst_23564,inst_23565,inst_23572);
var inst_23575 = (function (){var top_level_subject = inst_23424;
var select_spec = inst_23430;
var base_acc = inst_23444;
var acc_PLUS_refs = inst_23460;
var result = inst_23563;
var sort_preds = inst_23573;
return (function (acc,p__23574){
var vec__23588 = p__23574;
var selectPred = cljs.core.nth.call(null,vec__23588,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23588,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23588,(2),null);
var limit = cljs.core.nth.call(null,vec__23588,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23576 = cljs.core.reduce.call(null,inst_23575,inst_23563,inst_23573);
var state_23584__$1 = state_23584;
var statearr_23591_23674 = state_23584__$1;
(statearr_23591_23674[(2)] = inst_23576);

(statearr_23591_23674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (1))){
var state_23584__$1 = state_23584;
var statearr_23592_23675 = state_23584__$1;
(statearr_23592_23675[(2)] = null);

(statearr_23592_23675[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (24))){
var inst_23460 = (state_23584[(9)]);
var inst_23460__$1 = (state_23584[(2)]);
var inst_23461 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23462 = cljs.core.PersistentHashMap.EMPTY;
var inst_23463 = inst_23461;
var inst_23464 = inst_23460__$1;
var inst_23465 = inst_23462;
var state_23584__$1 = (function (){var statearr_23593 = state_23584;
(statearr_23593[(9)] = inst_23460__$1);

(statearr_23593[(11)] = inst_23464);

(statearr_23593[(12)] = inst_23463);

(statearr_23593[(13)] = inst_23465);

return statearr_23593;
})();
var statearr_23594_23676 = state_23584__$1;
(statearr_23594_23676[(2)] = null);

(statearr_23594_23676[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (39))){
var inst_23480 = (state_23584[(14)]);
var inst_23464 = (state_23584[(11)]);
var inst_23430 = (state_23584[(10)]);
var inst_23473 = (state_23584[(15)]);
var inst_23509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23510 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23464,inst_23430,inst_23473,inst_23480,false);
var state_23584__$1 = (function (){var statearr_23595 = state_23584;
(statearr_23595[(16)] = inst_23509);

return statearr_23595;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23584__$1,(42),inst_23510);
} else {
if((state_val_23585 === (46))){
var inst_23463 = (state_23584[(12)]);
var inst_23465 = (state_23584[(13)]);
var inst_23473 = (state_23584[(15)]);
var inst_23527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23528 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23529 = cljs.core.first.call(null,inst_23473);
var inst_23530 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23529);
var inst_23531 = [inst_23530];
var inst_23532 = cljs.core.PersistentHashMap.fromArrays(inst_23528,inst_23531);
var inst_23533 = cljs.core.rest.call(null,inst_23463);
var inst_23534 = [inst_23532,inst_23533,inst_23465];
var inst_23535 = (new cljs.core.PersistentVector(null,3,(5),inst_23527,inst_23534,null));
var state_23584__$1 = state_23584;
var statearr_23596_23677 = state_23584__$1;
(statearr_23596_23677[(2)] = inst_23535);

(statearr_23596_23677[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (4))){
var inst_23404 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23597_23678 = state_23584__$1;
(statearr_23597_23678[(2)] = inst_23404);

(statearr_23597_23678[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (15))){
var inst_23431 = (state_23584[(17)]);
var inst_23430 = (state_23584[(10)]);
var inst_23430__$1 = (state_23584[(2)]);
var inst_23431__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23430__$1);
var state_23584__$1 = (function (){var statearr_23598 = state_23584;
(statearr_23598[(17)] = inst_23431__$1);

(statearr_23598[(10)] = inst_23430__$1);

return statearr_23598;
})();
if(cljs.core.truth_(inst_23431__$1)){
var statearr_23599_23679 = state_23584__$1;
(statearr_23599_23679[(1)] = (16));

} else {
var statearr_23600_23680 = state_23584__$1;
(statearr_23600_23680[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (48))){
var inst_23546 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23601_23681 = state_23584__$1;
(statearr_23601_23681[(2)] = inst_23546);

(statearr_23601_23681[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (50))){
var state_23584__$1 = state_23584;
var statearr_23602_23682 = state_23584__$1;
(statearr_23602_23682[(2)] = null);

(statearr_23602_23682[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (21))){
var inst_23430 = (state_23584[(10)]);
var inst_23444 = (state_23584[(2)]);
var inst_23445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23446 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23447 = (new cljs.core.PersistentVector(null,2,(5),inst_23445,inst_23446,null));
var inst_23448 = cljs.core.get_in.call(null,inst_23430,inst_23447);
var state_23584__$1 = (function (){var statearr_23603 = state_23584;
(statearr_23603[(7)] = inst_23444);

return statearr_23603;
})();
if(cljs.core.truth_(inst_23448)){
var statearr_23604_23683 = state_23584__$1;
(statearr_23604_23683[(1)] = (22));

} else {
var statearr_23605_23684 = state_23584__$1;
(statearr_23605_23684[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (31))){
var inst_23464 = (state_23584[(11)]);
var inst_23479 = (state_23584[(18)]);
var inst_23473 = (state_23584[(15)]);
var inst_23483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23484 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23473,inst_23479,inst_23464,fuel,max_fuel,cache);
var state_23584__$1 = (function (){var statearr_23606 = state_23584;
(statearr_23606[(19)] = inst_23483);

return statearr_23606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23584__$1,(34),inst_23484);
} else {
if((state_val_23585 === (32))){
var inst_23479 = (state_23584[(18)]);
var state_23584__$1 = state_23584;
if(cljs.core.truth_(inst_23479)){
var statearr_23607_23685 = state_23584__$1;
(statearr_23607_23685[(1)] = (35));

} else {
var statearr_23608_23686 = state_23584__$1;
(statearr_23608_23686[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (40))){
var inst_23520 = (state_23584[(20)]);
var inst_23430 = (state_23584[(10)]);
var inst_23519 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23430);
var inst_23520__$1 = cljs.core.empty_QMARK_.call(null,inst_23519);
var state_23584__$1 = (function (){var statearr_23609 = state_23584;
(statearr_23609[(20)] = inst_23520__$1);

return statearr_23609;
})();
if(inst_23520__$1){
var statearr_23610_23687 = state_23584__$1;
(statearr_23610_23687[(1)] = (43));

} else {
var statearr_23611_23688 = state_23584__$1;
(statearr_23611_23688[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (33))){
var inst_23473 = (state_23584[(15)]);
var inst_23552 = (state_23584[(2)]);
var inst_23553 = cljs.core.nth.call(null,inst_23552,(0),null);
var inst_23554 = cljs.core.nth.call(null,inst_23552,(1),null);
var inst_23555 = cljs.core.nth.call(null,inst_23552,(2),null);
var inst_23556 = cljs.core.first.call(null,inst_23473);
var inst_23557 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23556);
var inst_23558 = cljs.core.assoc.call(null,inst_23553,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23557);
var inst_23463 = inst_23554;
var inst_23464 = inst_23558;
var inst_23465 = inst_23555;
var state_23584__$1 = (function (){var statearr_23612 = state_23584;
(statearr_23612[(11)] = inst_23464);

(statearr_23612[(12)] = inst_23463);

(statearr_23612[(13)] = inst_23465);

return statearr_23612;
})();
var statearr_23613_23689 = state_23584__$1;
(statearr_23613_23689[(2)] = null);

(statearr_23613_23689[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (13))){
var inst_23424 = (state_23584[(8)]);
var inst_23427 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23424);
var state_23584__$1 = state_23584;
var statearr_23614_23690 = state_23584__$1;
(statearr_23614_23690[(2)] = inst_23427);

(statearr_23614_23690[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (22))){
var inst_23430 = (state_23584[(10)]);
var inst_23450 = cljs.core.first.call(null,flakes);
var inst_23451 = fluree.db.query.fql.s.call(null,inst_23450);
var inst_23452 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23430);
var inst_23453 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23451,inst_23452);
var state_23584__$1 = state_23584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23584__$1,(25),inst_23453);
} else {
if((state_val_23585 === (36))){
var inst_23430 = (state_23584[(10)]);
var inst_23507 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23430);
var state_23584__$1 = state_23584;
if(cljs.core.truth_(inst_23507)){
var statearr_23615_23691 = state_23584__$1;
(statearr_23615_23691[(1)] = (39));

} else {
var statearr_23616_23692 = state_23584__$1;
(statearr_23616_23692[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (41))){
var inst_23548 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23617_23693 = state_23584__$1;
(statearr_23617_23693[(2)] = inst_23548);

(statearr_23617_23693[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (43))){
var inst_23430 = (state_23584[(10)]);
var inst_23522 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23430);
var state_23584__$1 = state_23584;
var statearr_23618_23694 = state_23584__$1;
(statearr_23618_23694[(2)] = inst_23522);

(statearr_23618_23694[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (29))){
var inst_23463 = (state_23584[(12)]);
var inst_23479 = (state_23584[(18)]);
var inst_23430 = (state_23584[(10)]);
var inst_23473 = (state_23584[(15)]);
var inst_23473__$1 = cljs.core.first.call(null,inst_23463);
var inst_23474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23475 = cljs.core.first.call(null,inst_23473__$1);
var inst_23476 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23475);
var inst_23477 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23476];
var inst_23478 = (new cljs.core.PersistentVector(null,3,(5),inst_23474,inst_23477,null));
var inst_23479__$1 = cljs.core.get_in.call(null,inst_23430,inst_23478);
var inst_23480 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23479__$1,inst_23430);
var inst_23481 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23479__$1);
var state_23584__$1 = (function (){var statearr_23619 = state_23584;
(statearr_23619[(14)] = inst_23480);

(statearr_23619[(18)] = inst_23479__$1);

(statearr_23619[(15)] = inst_23473__$1);

return statearr_23619;
})();
if(cljs.core.truth_(inst_23481)){
var statearr_23620_23695 = state_23584__$1;
(statearr_23620_23695[(1)] = (31));

} else {
var statearr_23621_23696 = state_23584__$1;
(statearr_23621_23696[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (44))){
var inst_23520 = (state_23584[(20)]);
var state_23584__$1 = state_23584;
var statearr_23622_23697 = state_23584__$1;
(statearr_23622_23697[(2)] = inst_23520);

(statearr_23622_23697[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (6))){
var state_23584__$1 = state_23584;
var statearr_23623_23698 = state_23584__$1;
(statearr_23623_23698[(2)] = null);

(statearr_23623_23698[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (28))){
var inst_23464 = (state_23584[(11)]);
var state_23584__$1 = state_23584;
var statearr_23624_23699 = state_23584__$1;
(statearr_23624_23699[(2)] = inst_23464);

(statearr_23624_23699[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (51))){
var inst_23544 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23625_23700 = state_23584__$1;
(statearr_23625_23700[(2)] = inst_23544);

(statearr_23625_23700[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (25))){
var inst_23444 = (state_23584[(7)]);
var inst_23455 = (state_23584[(2)]);
var inst_23456 = fluree.db.util.async.throw_err.call(null,inst_23455);
var inst_23457 = cljs.core.merge.call(null,inst_23444,inst_23456);
var state_23584__$1 = state_23584;
var statearr_23626_23701 = state_23584__$1;
(statearr_23626_23701[(2)] = inst_23457);

(statearr_23626_23701[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (34))){
var inst_23483 = (state_23584[(19)]);
var inst_23463 = (state_23584[(12)]);
var inst_23465 = (state_23584[(13)]);
var inst_23486 = (state_23584[(2)]);
var inst_23487 = fluree.db.util.async.throw_err.call(null,inst_23486);
var inst_23488 = cljs.core.rest.call(null,inst_23463);
var inst_23489 = [inst_23487,inst_23488,inst_23465];
var inst_23490 = (new cljs.core.PersistentVector(null,3,(5),inst_23483,inst_23489,null));
var state_23584__$1 = state_23584;
var statearr_23627_23702 = state_23584__$1;
(statearr_23627_23702[(2)] = inst_23490);

(statearr_23627_23702[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (17))){
var inst_23430 = (state_23584[(10)]);
var inst_23434 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23430);
var state_23584__$1 = state_23584;
var statearr_23629_23703 = state_23584__$1;
(statearr_23629_23703[(2)] = inst_23434);

(statearr_23629_23703[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (3))){
var inst_23582 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23584__$1,inst_23582);
} else {
if((state_val_23585 === (12))){
var _ = (function (){var statearr_23630 = state_23584;
(statearr_23630[(4)] = cljs.core.rest.call(null,(state_23584[(4)])));

return statearr_23630;
})();
var state_23584__$1 = state_23584;
var ex23628 = (state_23584__$1[(2)]);
var statearr_23631_23704 = state_23584__$1;
(statearr_23631_23704[(5)] = ex23628);


var statearr_23632_23705 = state_23584__$1;
(statearr_23632_23705[(1)] = (11));

(statearr_23632_23705[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (2))){
var _ = (function (){var statearr_23633 = state_23584;
(statearr_23633[(4)] = cljs.core.cons.call(null,(5),(state_23584[(4)])));

return statearr_23633;
})();
var inst_23410 = cljs.core.not_empty.call(null,flakes);
var state_23584__$1 = state_23584;
if(cljs.core.truth_(inst_23410)){
var statearr_23634_23706 = state_23584__$1;
(statearr_23634_23706[(1)] = (6));

} else {
var statearr_23635_23707 = state_23584__$1;
(statearr_23635_23707[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (23))){
var inst_23444 = (state_23584[(7)]);
var state_23584__$1 = state_23584;
var statearr_23636_23708 = state_23584__$1;
(statearr_23636_23708[(2)] = inst_23444);

(statearr_23636_23708[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (47))){
var state_23584__$1 = state_23584;
var statearr_23637_23709 = state_23584__$1;
(statearr_23637_23709[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (35))){
var inst_23480 = (state_23584[(14)]);
var inst_23464 = (state_23584[(11)]);
var inst_23479 = (state_23584[(18)]);
var inst_23465 = (state_23584[(13)]);
var inst_23473 = (state_23584[(15)]);
var inst_23496 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23464,inst_23479,inst_23473,inst_23480,false,inst_23465);
var state_23584__$1 = state_23584;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23584__$1,(38),inst_23496);
} else {
if((state_val_23585 === (19))){
var inst_23424 = (state_23584[(8)]);
var inst_23438 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23439 = [inst_23424];
var inst_23440 = cljs.core.PersistentHashMap.fromArrays(inst_23438,inst_23439);
var state_23584__$1 = state_23584;
var statearr_23639_23710 = state_23584__$1;
(statearr_23639_23710[(2)] = inst_23440);

(statearr_23639_23710[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (11))){
var inst_23412 = (state_23584[(2)]);
var inst_23413 = fluree.db.util.log.error.call(null,inst_23412);
var inst_23414 = (function(){throw inst_23412})();
var state_23584__$1 = (function (){var statearr_23641 = state_23584;
(statearr_23641[(21)] = inst_23413);

return statearr_23641;
})();
var statearr_23642_23711 = state_23584__$1;
(statearr_23642_23711[(2)] = inst_23414);

(statearr_23642_23711[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (9))){
var _ = (function (){var statearr_23643 = state_23584;
(statearr_23643[(4)] = cljs.core.cons.call(null,(12),(state_23584[(4)])));

return statearr_23643;
})();
var inst_23420 = cljs.core.first.call(null,flakes);
var inst_23421 = fluree.db.query.fql.s.call(null,inst_23420);
var ___$1 = (function (){var statearr_23644 = state_23584;
(statearr_23644[(4)] = cljs.core.rest.call(null,(state_23584[(4)])));

return statearr_23644;
})();
var state_23584__$1 = state_23584;
var statearr_23645_23712 = state_23584__$1;
(statearr_23645_23712[(2)] = inst_23421);

(statearr_23645_23712[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (5))){
var _ = (function (){var statearr_23646 = state_23584;
(statearr_23646[(4)] = cljs.core.rest.call(null,(state_23584[(4)])));

return statearr_23646;
})();
var state_23584__$1 = state_23584;
var ex23640 = (state_23584__$1[(2)]);
var statearr_23647_23713 = state_23584__$1;
(statearr_23647_23713[(5)] = ex23640);


if((ex23640 instanceof Error)){
var statearr_23648_23714 = state_23584__$1;
(statearr_23648_23714[(1)] = (4));

(statearr_23648_23714[(5)] = null);

} else {
throw ex23640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (14))){
var state_23584__$1 = state_23584;
var statearr_23649_23715 = state_23584__$1;
(statearr_23649_23715[(2)] = base_select_spec);

(statearr_23649_23715[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (45))){
var inst_23525 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
if(cljs.core.truth_(inst_23525)){
var statearr_23650_23716 = state_23584__$1;
(statearr_23650_23716[(1)] = (46));

} else {
var statearr_23651_23717 = state_23584__$1;
(statearr_23651_23717[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (26))){
var inst_23463 = (state_23584[(12)]);
var inst_23467 = cljs.core.empty_QMARK_.call(null,inst_23463);
var state_23584__$1 = state_23584;
if(inst_23467){
var statearr_23652_23718 = state_23584__$1;
(statearr_23652_23718[(1)] = (28));

} else {
var statearr_23653_23719 = state_23584__$1;
(statearr_23653_23719[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (16))){
var inst_23431 = (state_23584[(17)]);
var state_23584__$1 = state_23584;
var statearr_23654_23720 = state_23584__$1;
(statearr_23654_23720[(2)] = inst_23431);

(statearr_23654_23720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (38))){
var inst_23463 = (state_23584[(12)]);
var inst_23498 = (state_23584[(2)]);
var inst_23499 = fluree.db.util.async.throw_err.call(null,inst_23498);
var inst_23500 = cljs.core.nth.call(null,inst_23499,(0),null);
var inst_23501 = cljs.core.nth.call(null,inst_23499,(1),null);
var inst_23502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23503 = cljs.core.rest.call(null,inst_23463);
var inst_23504 = [inst_23500,inst_23503,inst_23501];
var inst_23505 = (new cljs.core.PersistentVector(null,3,(5),inst_23502,inst_23504,null));
var state_23584__$1 = state_23584;
var statearr_23655_23721 = state_23584__$1;
(statearr_23655_23721[(2)] = inst_23505);

(statearr_23655_23721[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (30))){
var inst_23561 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23656_23722 = state_23584__$1;
(statearr_23656_23722[(2)] = inst_23561);

(statearr_23656_23722[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (10))){
var inst_23424 = (state_23584[(2)]);
var inst_23425 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23584__$1 = (function (){var statearr_23657 = state_23584;
(statearr_23657[(8)] = inst_23424);

return statearr_23657;
})();
if(cljs.core.truth_(inst_23425)){
var statearr_23658_23723 = state_23584__$1;
(statearr_23658_23723[(1)] = (13));

} else {
var statearr_23659_23724 = state_23584__$1;
(statearr_23659_23724[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (18))){
var inst_23436 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
if(cljs.core.truth_(inst_23436)){
var statearr_23660_23725 = state_23584__$1;
(statearr_23660_23725[(1)] = (19));

} else {
var statearr_23661_23726 = state_23584__$1;
(statearr_23661_23726[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (42))){
var inst_23509 = (state_23584[(16)]);
var inst_23463 = (state_23584[(12)]);
var inst_23465 = (state_23584[(13)]);
var inst_23512 = (state_23584[(2)]);
var inst_23513 = fluree.db.util.async.throw_err.call(null,inst_23512);
var inst_23514 = cljs.core.first.call(null,inst_23513);
var inst_23515 = cljs.core.rest.call(null,inst_23463);
var inst_23516 = [inst_23514,inst_23515,inst_23465];
var inst_23517 = (new cljs.core.PersistentVector(null,3,(5),inst_23509,inst_23516,null));
var state_23584__$1 = state_23584;
var statearr_23662_23727 = state_23584__$1;
(statearr_23662_23727[(2)] = inst_23517);

(statearr_23662_23727[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (37))){
var inst_23550 = (state_23584[(2)]);
var state_23584__$1 = state_23584;
var statearr_23663_23728 = state_23584__$1;
(statearr_23663_23728[(2)] = inst_23550);

(statearr_23663_23728[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (8))){
var inst_23579 = (state_23584[(2)]);
var _ = (function (){var statearr_23664 = state_23584;
(statearr_23664[(4)] = cljs.core.rest.call(null,(state_23584[(4)])));

return statearr_23664;
})();
var state_23584__$1 = state_23584;
var statearr_23665_23729 = state_23584__$1;
(statearr_23665_23729[(2)] = inst_23579);

(statearr_23665_23729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23585 === (49))){
var inst_23464 = (state_23584[(11)]);
var inst_23463 = (state_23584[(12)]);
var inst_23465 = (state_23584[(13)]);
var inst_23538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23539 = cljs.core.rest.call(null,inst_23463);
var inst_23540 = [inst_23464,inst_23539,inst_23465];
var inst_23541 = (new cljs.core.PersistentVector(null,3,(5),inst_23538,inst_23540,null));
var state_23584__$1 = state_23584;
var statearr_23666_23730 = state_23584__$1;
(statearr_23666_23730[(2)] = inst_23541);

(statearr_23666_23730[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0 = (function (){
var statearr_23667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23667[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__);

(statearr_23667[(1)] = (1));

return statearr_23667;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1 = (function (state_23584){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_23584);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23668){var ex__2744__auto__ = e23668;
var statearr_23669_23731 = state_23584;
(statearr_23669_23731[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_23584[(4)]))){
var statearr_23670_23732 = state_23584;
(statearr_23670_23732[(1)] = cljs.core.first.call(null,(state_23584[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23733 = state_23584;
state_23584 = G__23733;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__ = function(state_23584){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1.call(this,state_23584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23671 = f__2764__auto__.call(null);
(statearr_23671[(6)] = c__2763__auto__);

return statearr_23671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23736 = arguments.length;
switch (G__23736) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23778){
var state_val_23779 = (state_23778[(1)]);
if((state_val_23779 === (7))){
var inst_23744 = (state_23778[(7)]);
var state_23778__$1 = state_23778;
var statearr_23780_23810 = state_23778__$1;
(statearr_23780_23810[(2)] = inst_23744);

(statearr_23780_23810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (1))){
var state_23778__$1 = state_23778;
var statearr_23781_23811 = state_23778__$1;
(statearr_23781_23811[(2)] = null);

(statearr_23781_23811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (4))){
var inst_23737 = (state_23778[(2)]);
var state_23778__$1 = state_23778;
var statearr_23782_23812 = state_23778__$1;
(statearr_23782_23812[(2)] = inst_23737);

(statearr_23782_23812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (15))){
var inst_23772 = (state_23778[(2)]);
var inst_23773 = fluree.db.util.async.throw_err.call(null,inst_23772);
var _ = (function (){var statearr_23783 = state_23778;
(statearr_23783[(4)] = cljs.core.rest.call(null,(state_23778[(4)])));

return statearr_23783;
})();
var state_23778__$1 = state_23778;
var statearr_23784_23813 = state_23778__$1;
(statearr_23784_23813[(2)] = inst_23773);

(statearr_23784_23813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (13))){
var inst_23756 = (state_23778[(8)]);
var state_23778__$1 = state_23778;
var statearr_23785_23814 = state_23778__$1;
(statearr_23785_23814[(2)] = inst_23756);

(statearr_23785_23814[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (6))){
var inst_23744 = (state_23778[(7)]);
var inst_23746 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23747 = cljs.core.comp.call(null,inst_23744,inst_23746);
var state_23778__$1 = state_23778;
var statearr_23786_23815 = state_23778__$1;
(statearr_23786_23815[(2)] = inst_23747);

(statearr_23786_23815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (3))){
var inst_23776 = (state_23778[(2)]);
var state_23778__$1 = state_23778;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23778__$1,inst_23776);
} else {
if((state_val_23779 === (12))){
var inst_23756 = (state_23778[(8)]);
var inst_23758 = cljs.core.take.call(null,limit);
var inst_23759 = cljs.core.comp.call(null,inst_23756,inst_23758);
var state_23778__$1 = state_23778;
var statearr_23787_23816 = state_23778__$1;
(statearr_23787_23816[(2)] = inst_23759);

(statearr_23787_23816[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (2))){
var _ = (function (){var statearr_23788 = state_23778;
(statearr_23788[(4)] = cljs.core.cons.call(null,(5),(state_23778[(4)])));

return statearr_23788;
})();
var inst_23744 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23778__$1 = (function (){var statearr_23789 = state_23778;
(statearr_23789[(7)] = inst_23744);

return statearr_23789;
})();
if(cljs.core.truth_(fuel)){
var statearr_23790_23817 = state_23778__$1;
(statearr_23790_23817[(1)] = (6));

} else {
var statearr_23791_23818 = state_23778__$1;
(statearr_23791_23818[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (11))){
var inst_23756 = (state_23778[(2)]);
var state_23778__$1 = (function (){var statearr_23793 = state_23778;
(statearr_23793[(8)] = inst_23756);

return statearr_23793;
})();
if(cljs.core.truth_(limit)){
var statearr_23794_23819 = state_23778__$1;
(statearr_23794_23819[(1)] = (12));

} else {
var statearr_23795_23820 = state_23778__$1;
(statearr_23795_23820[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (9))){
var inst_23750 = (state_23778[(9)]);
var inst_23752 = cljs.core.drop.call(null,offset);
var inst_23753 = cljs.core.comp.call(null,inst_23750,inst_23752);
var state_23778__$1 = state_23778;
var statearr_23796_23821 = state_23778__$1;
(statearr_23796_23821[(2)] = inst_23753);

(statearr_23796_23821[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (5))){
var _ = (function (){var statearr_23797 = state_23778;
(statearr_23797[(4)] = cljs.core.rest.call(null,(state_23778[(4)])));

return statearr_23797;
})();
var state_23778__$1 = state_23778;
var ex23792 = (state_23778__$1[(2)]);
var statearr_23798_23822 = state_23778__$1;
(statearr_23798_23822[(5)] = ex23792);


if((ex23792 instanceof Error)){
var statearr_23799_23823 = state_23778__$1;
(statearr_23799_23823[(1)] = (4));

(statearr_23799_23823[(5)] = null);

} else {
throw ex23792;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (14))){
var inst_23762 = (state_23778[(2)]);
var inst_23763 = (function (){return (function (x){
var and__4251__auto__ = max_fuel;
if(cljs.core.truth_(and__4251__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4251__auto__;
}
});
})();
var inst_23764 = cljs.core.halt_when.call(null,inst_23763);
var inst_23765 = cljs.core.comp.call(null,inst_23762,inst_23764);
var inst_23766 = cljs.core.sequence.call(null,inst_23765,flakes);
var inst_23767 = cljs.core.PersistentVector.EMPTY;
var inst_23768 = (function (){var xf = inst_23765;
var flakes_by_sub = inst_23766;
return (function (p1__23734_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23734_SHARP_);
});
})();
var inst_23769 = cljs.core.map.call(null,inst_23768,inst_23766);
var inst_23770 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23767,inst_23769);
var state_23778__$1 = state_23778;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23778__$1,(15),inst_23770);
} else {
if((state_val_23779 === (10))){
var inst_23750 = (state_23778[(9)]);
var state_23778__$1 = state_23778;
var statearr_23800_23824 = state_23778__$1;
(statearr_23800_23824[(2)] = inst_23750);

(statearr_23800_23824[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23779 === (8))){
var inst_23750 = (state_23778[(2)]);
var state_23778__$1 = (function (){var statearr_23801 = state_23778;
(statearr_23801[(9)] = inst_23750);

return statearr_23801;
})();
if(cljs.core.truth_(offset)){
var statearr_23802_23825 = state_23778__$1;
(statearr_23802_23825[(1)] = (9));

} else {
var statearr_23803_23826 = state_23778__$1;
(statearr_23803_23826[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_23804 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23804[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_23804[(1)] = (1));

return statearr_23804;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_23778){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_23778);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23805){var ex__2744__auto__ = e23805;
var statearr_23806_23827 = state_23778;
(statearr_23806_23827[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_23778[(4)]))){
var statearr_23807_23828 = state_23778;
(statearr_23807_23828[(1)] = cljs.core.first.call(null,(state_23778[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23829 = state_23778;
state_23778 = G__23829;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_23778){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_23778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23808 = f__2764__auto__.call(null);
(statearr_23808[(6)] = c__2763__auto__);

return statearr_23808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23831 = arguments.length;
switch (G__23831) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_23917){
var state_val_23918 = (state_23917[(1)]);
if((state_val_23918 === (7))){
var inst_23912 = (state_23917[(2)]);
var _ = (function (){var statearr_23920 = state_23917;
(statearr_23920[(4)] = cljs.core.rest.call(null,(state_23917[(4)])));

return statearr_23920;
})();
var state_23917__$1 = state_23917;
var statearr_23921_23973 = state_23917__$1;
(statearr_23921_23973[(2)] = inst_23912);

(statearr_23921_23973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (20))){
var inst_23851 = (state_23917[(7)]);
var inst_23852 = (state_23917[(8)]);
var inst_23859 = (state_23917[(9)]);
var inst_23880 = (inst_23851 + (1));
var tmp23919 = inst_23852;
var inst_23850 = inst_23859;
var inst_23851__$1 = inst_23880;
var inst_23852__$1 = tmp23919;
var state_23917__$1 = (function (){var statearr_23922 = state_23917;
(statearr_23922[(7)] = inst_23851__$1);

(statearr_23922[(8)] = inst_23852__$1);

(statearr_23922[(10)] = inst_23850);

return statearr_23922;
})();
var statearr_23923_23974 = state_23917__$1;
(statearr_23923_23974[(2)] = null);

(statearr_23923_23974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (27))){
var inst_23890 = (state_23917[(11)]);
var inst_23892 = cljs.core.count.call(null,inst_23890);
var inst_23893 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_23892);
var state_23917__$1 = state_23917;
var statearr_23924_23975 = state_23917__$1;
(statearr_23924_23975[(2)] = inst_23893);

(statearr_23924_23975[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (1))){
var state_23917__$1 = state_23917;
var statearr_23925_23976 = state_23917__$1;
(statearr_23925_23976[(2)] = null);

(statearr_23925_23976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (24))){
var state_23917__$1 = state_23917;
var statearr_23926_23977 = state_23917__$1;
(statearr_23926_23977[(2)] = null);

(statearr_23926_23977[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (4))){
var inst_23832 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
var statearr_23927_23978 = state_23917__$1;
(statearr_23927_23978[(2)] = inst_23832);

(statearr_23927_23978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (15))){
var inst_23873 = (state_23917[(12)]);
var inst_23873__$1 = offset;
var state_23917__$1 = (function (){var statearr_23928 = state_23917;
(statearr_23928[(12)] = inst_23873__$1);

return statearr_23928;
})();
if(cljs.core.truth_(inst_23873__$1)){
var statearr_23929_23979 = state_23917__$1;
(statearr_23929_23979[(1)] = (17));

} else {
var statearr_23930_23980 = state_23917__$1;
(statearr_23930_23980[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (21))){
var state_23917__$1 = state_23917;
var statearr_23931_23981 = state_23917__$1;
(statearr_23931_23981[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (13))){
var inst_23868 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
var statearr_23933_23982 = state_23917__$1;
(statearr_23933_23982[(2)] = inst_23868);

(statearr_23933_23982[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (22))){
var inst_23908 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
var statearr_23934_23983 = state_23917__$1;
(statearr_23934_23983[(2)] = inst_23908);

(statearr_23934_23983[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (29))){
var inst_23851 = (state_23917[(7)]);
var inst_23890 = (state_23917[(11)]);
var inst_23896 = (state_23917[(2)]);
var inst_23897 = (inst_23851 + (1));
var inst_23898 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,inst_23890);
var state_23917__$1 = (function (){var statearr_23935 = state_23917;
(statearr_23935[(13)] = inst_23897);

(statearr_23935[(14)] = inst_23896);

return statearr_23935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23917__$1,(30),inst_23898);
} else {
if((state_val_23918 === (6))){
var inst_23858 = (state_23917[(15)]);
var inst_23860 = (state_23917[(16)]);
var inst_23850 = (state_23917[(10)]);
var inst_23857 = cljs.core.seq.call(null,inst_23850);
var inst_23858__$1 = cljs.core.first.call(null,inst_23857);
var inst_23859 = cljs.core.next.call(null,inst_23857);
var inst_23860__$1 = (inst_23858__$1 == null);
var state_23917__$1 = (function (){var statearr_23936 = state_23917;
(statearr_23936[(15)] = inst_23858__$1);

(statearr_23936[(16)] = inst_23860__$1);

(statearr_23936[(9)] = inst_23859);

return statearr_23936;
})();
if(cljs.core.truth_(inst_23860__$1)){
var statearr_23937_23984 = state_23917__$1;
(statearr_23937_23984[(1)] = (8));

} else {
var statearr_23938_23985 = state_23917__$1;
(statearr_23938_23985[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (28))){
var state_23917__$1 = state_23917;
var statearr_23939_23986 = state_23917__$1;
(statearr_23939_23986[(2)] = null);

(statearr_23939_23986[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (25))){
var inst_23906 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
var statearr_23940_23987 = state_23917__$1;
(statearr_23940_23987[(2)] = inst_23906);

(statearr_23940_23987[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (17))){
var inst_23851 = (state_23917[(7)]);
var inst_23875 = (inst_23851 < offset);
var state_23917__$1 = state_23917;
var statearr_23941_23988 = state_23917__$1;
(statearr_23941_23988[(2)] = inst_23875);

(statearr_23941_23988[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (3))){
var inst_23915 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23917__$1,inst_23915);
} else {
if((state_val_23918 === (12))){
var inst_23863 = (state_23917[(17)]);
var state_23917__$1 = state_23917;
var statearr_23942_23989 = state_23917__$1;
(statearr_23942_23989[(2)] = inst_23863);

(statearr_23942_23989[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (2))){
var _ = (function (){var statearr_23943 = state_23917;
(statearr_23943[(4)] = cljs.core.cons.call(null,(5),(state_23917[(4)])));

return statearr_23943;
})();
var inst_23845 = subjects;
var inst_23846 = cljs.core.seq.call(null,inst_23845);
var inst_23847 = cljs.core.first.call(null,inst_23846);
var inst_23848 = cljs.core.next.call(null,inst_23846);
var inst_23849 = cljs.core.PersistentVector.EMPTY;
var inst_23850 = inst_23845;
var inst_23851 = (0);
var inst_23852 = inst_23849;
var state_23917__$1 = (function (){var statearr_23944 = state_23917;
(statearr_23944[(7)] = inst_23851);

(statearr_23944[(18)] = inst_23848);

(statearr_23944[(8)] = inst_23852);

(statearr_23944[(19)] = inst_23847);

(statearr_23944[(10)] = inst_23850);

return statearr_23944;
})();
var statearr_23945_23990 = state_23917__$1;
(statearr_23945_23990[(2)] = null);

(statearr_23945_23990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (23))){
var inst_23858 = (state_23917[(15)]);
var inst_23884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23885 = [inst_23858];
var inst_23886 = (new cljs.core.PersistentVector(null,1,(5),inst_23884,inst_23885,null));
var inst_23887 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23886);
var state_23917__$1 = state_23917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23917__$1,(26),inst_23887);
} else {
if((state_val_23918 === (19))){
var inst_23878 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
if(cljs.core.truth_(inst_23878)){
var statearr_23946_23991 = state_23917__$1;
(statearr_23946_23991[(1)] = (20));

} else {
var statearr_23947_23992 = state_23917__$1;
(statearr_23947_23992[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (11))){
var inst_23851 = (state_23917[(7)]);
var inst_23865 = (inst_23851 > limit);
var state_23917__$1 = state_23917;
var statearr_23949_23993 = state_23917__$1;
(statearr_23949_23993[(2)] = inst_23865);

(statearr_23949_23993[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (9))){
var inst_23863 = (state_23917[(17)]);
var inst_23863__$1 = limit;
var state_23917__$1 = (function (){var statearr_23950 = state_23917;
(statearr_23950[(17)] = inst_23863__$1);

return statearr_23950;
})();
if(cljs.core.truth_(inst_23863__$1)){
var statearr_23951_23994 = state_23917__$1;
(statearr_23951_23994[(1)] = (11));

} else {
var statearr_23952_23995 = state_23917__$1;
(statearr_23952_23995[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (5))){
var _ = (function (){var statearr_23953 = state_23917;
(statearr_23953[(4)] = cljs.core.rest.call(null,(state_23917[(4)])));

return statearr_23953;
})();
var state_23917__$1 = state_23917;
var ex23948 = (state_23917__$1[(2)]);
var statearr_23954_23996 = state_23917__$1;
(statearr_23954_23996[(5)] = ex23948);


if((ex23948 instanceof Error)){
var statearr_23955_23997 = state_23917__$1;
(statearr_23955_23997[(1)] = (4));

(statearr_23955_23997[(5)] = null);

} else {
throw ex23948;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (14))){
var inst_23852 = (state_23917[(8)]);
var state_23917__$1 = state_23917;
var statearr_23956_23998 = state_23917__$1;
(statearr_23956_23998[(2)] = inst_23852);

(statearr_23956_23998[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (26))){
var inst_23889 = (state_23917[(2)]);
var inst_23890 = fluree.db.util.async.throw_err.call(null,inst_23889);
var state_23917__$1 = (function (){var statearr_23957 = state_23917;
(statearr_23957[(11)] = inst_23890);

return statearr_23957;
})();
if(cljs.core.truth_(fuel)){
var statearr_23958_23999 = state_23917__$1;
(statearr_23958_23999[(1)] = (27));

} else {
var statearr_23959_24000 = state_23917__$1;
(statearr_23959_24000[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (16))){
var inst_23910 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
var statearr_23960_24001 = state_23917__$1;
(statearr_23960_24001[(2)] = inst_23910);

(statearr_23960_24001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (30))){
var inst_23897 = (state_23917[(13)]);
var inst_23852 = (state_23917[(8)]);
var inst_23859 = (state_23917[(9)]);
var inst_23900 = (state_23917[(2)]);
var inst_23901 = fluree.db.util.async.throw_err.call(null,inst_23900);
var inst_23902 = cljs.core.conj.call(null,inst_23852,inst_23901);
var inst_23850 = inst_23859;
var inst_23851 = inst_23897;
var inst_23852__$1 = inst_23902;
var state_23917__$1 = (function (){var statearr_23961 = state_23917;
(statearr_23961[(7)] = inst_23851);

(statearr_23961[(8)] = inst_23852__$1);

(statearr_23961[(10)] = inst_23850);

return statearr_23961;
})();
var statearr_23962_24002 = state_23917__$1;
(statearr_23962_24002[(2)] = null);

(statearr_23962_24002[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (10))){
var inst_23870 = (state_23917[(2)]);
var state_23917__$1 = state_23917;
if(cljs.core.truth_(inst_23870)){
var statearr_23963_24003 = state_23917__$1;
(statearr_23963_24003[(1)] = (14));

} else {
var statearr_23964_24004 = state_23917__$1;
(statearr_23964_24004[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (18))){
var inst_23873 = (state_23917[(12)]);
var state_23917__$1 = state_23917;
var statearr_23965_24005 = state_23917__$1;
(statearr_23965_24005[(2)] = inst_23873);

(statearr_23965_24005[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23918 === (8))){
var inst_23860 = (state_23917[(16)]);
var state_23917__$1 = state_23917;
var statearr_23966_24006 = state_23917__$1;
(statearr_23966_24006[(2)] = inst_23860);

(statearr_23966_24006[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_23967 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23967[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_23967[(1)] = (1));

return statearr_23967;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_23917){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_23917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e23968){var ex__2744__auto__ = e23968;
var statearr_23969_24007 = state_23917;
(statearr_23969_24007[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_23917[(4)]))){
var statearr_23970_24008 = state_23917;
(statearr_23970_24008[(1)] = cljs.core.first.call(null,(state_23917[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24009 = state_23917;
state_23917 = G__24009;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_23917){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_23917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_23971 = f__2764__auto__.call(null);
(statearr_23971[(6)] = c__2763__auto__);

return statearr_23971;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4253__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__24011 = arguments.length;
switch (G__24011) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__24012){
var map__24013 = p__24012;
var map__24013__$1 = cljs.core.__destructure_map.call(null,map__24013);
var limit = cljs.core.get.call(null,map__24013__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24013__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24277){
var state_val_24278 = (state_24277[(1)]);
if((state_val_24278 === (65))){
var inst_24240 = (state_24277[(7)]);
var inst_24240__$1 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24279 = state_24277;
(statearr_24279[(7)] = inst_24240__$1);

return statearr_24279;
})();
if(cljs.core.truth_(inst_24240__$1)){
var statearr_24280_24398 = state_24277__$1;
(statearr_24280_24398[(1)] = (66));

} else {
var statearr_24281_24399 = state_24277__$1;
(statearr_24281_24399[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (70))){
var inst_24243 = (state_24277[(8)]);
var state_24277__$1 = state_24277;
var statearr_24282_24400 = state_24277__$1;
(statearr_24282_24400[(2)] = inst_24243);

(statearr_24282_24400[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (62))){
var inst_24231 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24283_24401 = state_24277__$1;
(statearr_24283_24401[(2)] = inst_24231);

(statearr_24283_24401[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (74))){
var inst_24250 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24284_24402 = state_24277__$1;
(statearr_24284_24402[(2)] = inst_24250);

(statearr_24284_24402[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (7))){
var inst_24026 = (state_24277[(9)]);
var state_24277__$1 = state_24277;
var statearr_24285_24403 = state_24277__$1;
(statearr_24285_24403[(2)] = inst_24026);

(statearr_24285_24403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (59))){
var inst_24055 = (state_24277[(10)]);
var inst_24223 = cljs.core.empty_QMARK_.call(null,inst_24055);
var state_24277__$1 = state_24277;
if(inst_24223){
var statearr_24286_24404 = state_24277__$1;
(statearr_24286_24404[(1)] = (60));

} else {
var statearr_24287_24405 = state_24277__$1;
(statearr_24287_24405[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (20))){
var state_24277__$1 = state_24277;
if(cljs.core.truth_(offset)){
var statearr_24288_24406 = state_24277__$1;
(statearr_24288_24406[(1)] = (23));

} else {
var statearr_24289_24407 = state_24277__$1;
(statearr_24289_24407[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (72))){
var inst_24220 = (state_24277[(11)]);
var inst_24040 = (state_24277[(12)]);
var inst_24246 = cljs.core.count.call(null,inst_24220);
var inst_24247 = (inst_24246 > inst_24040);
var state_24277__$1 = state_24277;
var statearr_24290_24408 = state_24277__$1;
(statearr_24290_24408[(2)] = inst_24247);

(statearr_24290_24408[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (58))){
var inst_24220 = (state_24277[(11)]);
var inst_24055 = (state_24277[(10)]);
var inst_24221 = cljs.core.into.call(null,inst_24055,inst_24220);
var state_24277__$1 = state_24277;
var statearr_24291_24409 = state_24277__$1;
(statearr_24291_24409[(2)] = inst_24221);

(statearr_24291_24409[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (60))){
var inst_24220 = (state_24277[(11)]);
var inst_24055 = (state_24277[(10)]);
var inst_24225 = cljs.core.into.call(null,inst_24055,inst_24220);
var state_24277__$1 = state_24277;
var statearr_24292_24410 = state_24277__$1;
(statearr_24292_24410[(2)] = inst_24225);

(statearr_24292_24410[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (27))){
var inst_24070 = (state_24277[(13)]);
var state_24277__$1 = state_24277;
var statearr_24293_24411 = state_24277__$1;
(statearr_24293_24411[(2)] = inst_24070);

(statearr_24293_24411[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (1))){
var state_24277__$1 = state_24277;
var statearr_24294_24412 = state_24277__$1;
(statearr_24294_24412[(2)] = null);

(statearr_24294_24412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (69))){
var inst_24040 = (state_24277[(12)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24040)){
var statearr_24295_24413 = state_24277__$1;
(statearr_24295_24413[(1)] = (72));

} else {
var statearr_24296_24414 = state_24277__$1;
(statearr_24296_24414[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (24))){
var inst_24055 = (state_24277[(10)]);
var state_24277__$1 = state_24277;
var statearr_24297_24415 = state_24277__$1;
(statearr_24297_24415[(2)] = inst_24055);

(statearr_24297_24415[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (55))){
var inst_24209 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24298_24416 = state_24277__$1;
(statearr_24298_24416[(2)] = inst_24209);

(statearr_24298_24416[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (39))){
var inst_24217 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24299_24417 = state_24277__$1;
(statearr_24299_24417[(2)] = inst_24217);

(statearr_24299_24417[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (46))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24175 = inst_24099.call(null,cljs.core._LT_,inst_24081);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24175)){
var statearr_24300_24418 = state_24277__$1;
(statearr_24300_24418[(1)] = (49));

} else {
var statearr_24301_24419 = state_24277__$1;
(statearr_24301_24419[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (4))){
var inst_24014 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24302_24420 = state_24277__$1;
(statearr_24302_24420[(2)] = inst_24014);

(statearr_24302_24420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (77))){
var inst_24265 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24303_24421 = state_24277__$1;
(statearr_24303_24421[(2)] = inst_24265);

(statearr_24303_24421[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (54))){
var inst_24207 = cljs.core.PersistentVector.EMPTY;
var state_24277__$1 = state_24277;
var statearr_24304_24422 = state_24277__$1;
(statearr_24304_24422[(2)] = inst_24207);

(statearr_24304_24422[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (15))){
var inst_24025 = (state_24277[(16)]);
var inst_24050 = cljs.core.seq.call(null,inst_24025);
var inst_24051 = cljs.core.first.call(null,inst_24050);
var inst_24052 = cljs.core.next.call(null,inst_24050);
var inst_24053 = cljs.core.PersistentHashSet.EMPTY;
var inst_24054 = inst_24025;
var inst_24055 = inst_24053;
var state_24277__$1 = (function (){var statearr_24305 = state_24277;
(statearr_24305[(17)] = inst_24052);

(statearr_24305[(18)] = inst_24051);

(statearr_24305[(10)] = inst_24055);

(statearr_24305[(19)] = inst_24054);

return statearr_24305;
})();
var statearr_24306_24423 = state_24277__$1;
(statearr_24306_24423[(2)] = null);

(statearr_24306_24423[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (48))){
var inst_24172 = (state_24277[(2)]);
var inst_24173 = fluree.db.util.async.throw_err.call(null,inst_24172);
var state_24277__$1 = state_24277;
var statearr_24307_24424 = state_24277__$1;
(statearr_24307_24424[(2)] = inst_24173);

(statearr_24307_24424[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (50))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24191 = inst_24099.call(null,cljs.core._LT__EQ_,inst_24081);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24191)){
var statearr_24308_24425 = state_24277__$1;
(statearr_24308_24425[(1)] = (53));

} else {
var statearr_24309_24426 = state_24277__$1;
(statearr_24309_24426[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (75))){
var state_24277__$1 = state_24277;
if(cljs.core.truth_(offset)){
var statearr_24310_24427 = state_24277__$1;
(statearr_24310_24427[(1)] = (78));

} else {
var statearr_24311_24428 = state_24277__$1;
(statearr_24311_24428[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (21))){
var inst_24080 = (state_24277[(20)]);
var inst_24061 = (state_24277[(21)]);
var inst_24080__$1 = cljs.core.nth.call(null,inst_24061,(0),null);
var inst_24081 = cljs.core.nth.call(null,inst_24061,(1),null);
var inst_24082 = cljs.core.nth.call(null,inst_24061,(2),null);
var inst_24083 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_24080__$1);
var inst_24084 = cljs.core.not.call(null,inst_24083);
var state_24277__$1 = (function (){var statearr_24312 = state_24277;
(statearr_24312[(14)] = inst_24081);

(statearr_24312[(20)] = inst_24080__$1);

(statearr_24312[(22)] = inst_24082);

return statearr_24312;
})();
if(inst_24084){
var statearr_24313_24429 = state_24277__$1;
(statearr_24313_24429[(1)] = (29));

} else {
var statearr_24314_24430 = state_24277__$1;
(statearr_24314_24430[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (31))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24095 = (state_24277[(2)]);
var inst_24099__$1 = cljs.core.identical_QMARK_;
var inst_24100 = inst_24099__$1.call(null,cljs.core.not_EQ_,inst_24081);
var state_24277__$1 = (function (){var statearr_24315 = state_24277;
(statearr_24315[(23)] = inst_24095);

(statearr_24315[(15)] = inst_24099__$1);

return statearr_24315;
})();
if(cljs.core.truth_(inst_24100)){
var statearr_24316_24431 = state_24277__$1;
(statearr_24316_24431[(1)] = (32));

} else {
var statearr_24317_24432 = state_24277__$1;
(statearr_24317_24432[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (32))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24103 = [inst_24080,inst_24082];
var inst_24104 = (new cljs.core.PersistentVector(null,2,(5),inst_24102,inst_24103,null));
var inst_24105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24106 = [inst_24080];
var inst_24107 = (new cljs.core.PersistentVector(null,1,(5),inst_24105,inst_24106,null));
var inst_24108 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24109 = [inst_24040];
var inst_24110 = cljs.core.PersistentHashMap.fromArrays(inst_24108,inst_24109);
var inst_24111 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24104,cljs.core._LT__EQ_,inst_24107,inst_24110);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(35),inst_24111);
} else {
if((state_val_24278 === (40))){
var inst_24140 = (state_24277[(2)]);
var inst_24141 = fluree.db.util.async.throw_err.call(null,inst_24140);
var state_24277__$1 = state_24277;
var statearr_24318_24433 = state_24277__$1;
(statearr_24318_24433[(2)] = inst_24141);

(statearr_24318_24433[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (56))){
var inst_24204 = (state_24277[(2)]);
var inst_24205 = fluree.db.util.async.throw_err.call(null,inst_24204);
var state_24277__$1 = state_24277;
var statearr_24319_24434 = state_24277__$1;
(statearr_24319_24434[(2)] = inst_24205);

(statearr_24319_24434[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (33))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24130 = inst_24099.call(null,cljs.core._EQ_,inst_24081);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24130)){
var statearr_24320_24435 = state_24277__$1;
(statearr_24320_24435[(1)] = (37));

} else {
var statearr_24321_24436 = state_24277__$1;
(statearr_24321_24436[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (13))){
var state_24277__$1 = state_24277;
var statearr_24322_24437 = state_24277__$1;
(statearr_24322_24437[(2)] = limit);

(statearr_24322_24437[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (22))){
var inst_24267 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24323_24438 = state_24277__$1;
(statearr_24323_24438[(2)] = inst_24267);

(statearr_24323_24438[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (36))){
var inst_24114 = (state_24277[(24)]);
var inst_24126 = (state_24277[(2)]);
var inst_24127 = fluree.db.util.async.throw_err.call(null,inst_24126);
var inst_24128 = cljs.core.concat.call(null,inst_24114,inst_24127);
var state_24277__$1 = state_24277;
var statearr_24324_24439 = state_24277__$1;
(statearr_24324_24439[(2)] = inst_24128);

(statearr_24324_24439[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (41))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24146 = [inst_24080,inst_24082];
var inst_24147 = (new cljs.core.PersistentVector(null,2,(5),inst_24145,inst_24146,null));
var inst_24148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24149 = [inst_24080];
var inst_24150 = (new cljs.core.PersistentVector(null,1,(5),inst_24148,inst_24149,null));
var inst_24151 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24152 = [inst_24040];
var inst_24153 = cljs.core.PersistentHashMap.fromArrays(inst_24151,inst_24152);
var inst_24154 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24147,cljs.core._LT__EQ_,inst_24150,inst_24153);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(44),inst_24154);
} else {
if((state_val_24278 === (43))){
var inst_24215 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24325_24440 = state_24277__$1;
(statearr_24325_24440[(2)] = inst_24215);

(statearr_24325_24440[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (61))){
var inst_24220 = (state_24277[(11)]);
var inst_24055 = (state_24277[(10)]);
var inst_24227 = cljs.core.PersistentHashSet.EMPTY;
var inst_24228 = cljs.core.into.call(null,inst_24227,inst_24220);
var inst_24229 = clojure.set.intersection.call(null,inst_24055,inst_24228);
var state_24277__$1 = state_24277;
var statearr_24326_24441 = state_24277__$1;
(statearr_24326_24441[(2)] = inst_24229);

(statearr_24326_24441[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (29))){
var inst_24080 = (state_24277[(20)]);
var inst_24086 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24080);
var inst_24087 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24086)].join('');
var inst_24088 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24089 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24090 = cljs.core.PersistentHashMap.fromArrays(inst_24088,inst_24089);
var inst_24091 = cljs.core.ex_info.call(null,inst_24087,inst_24090);
var inst_24092 = (function(){throw inst_24091})();
var state_24277__$1 = state_24277;
var statearr_24327_24442 = state_24277__$1;
(statearr_24327_24442[(2)] = inst_24092);

(statearr_24327_24442[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (44))){
var inst_24156 = (state_24277[(2)]);
var inst_24157 = fluree.db.util.async.throw_err.call(null,inst_24156);
var state_24277__$1 = state_24277;
var statearr_24328_24443 = state_24277__$1;
(statearr_24328_24443[(2)] = inst_24157);

(statearr_24328_24443[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (6))){
var inst_24024 = (state_24277[(25)]);
var inst_24028 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24024);
var state_24277__$1 = state_24277;
var statearr_24329_24444 = state_24277__$1;
(statearr_24329_24444[(2)] = inst_24028);

(statearr_24329_24444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (28))){
var inst_24075 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24330_24445 = state_24277__$1;
(statearr_24330_24445[(2)] = inst_24075);

(statearr_24330_24445[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (64))){
var inst_24235 = (state_24277[(26)]);
var state_24277__$1 = state_24277;
var statearr_24331_24446 = state_24277__$1;
(statearr_24331_24446[(2)] = inst_24235);

(statearr_24331_24446[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (51))){
var inst_24211 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24332_24447 = state_24277__$1;
(statearr_24332_24447[(2)] = inst_24211);

(statearr_24332_24447[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (25))){
var inst_24070 = (state_24277[(2)]);
var state_24277__$1 = (function (){var statearr_24333 = state_24277;
(statearr_24333[(13)] = inst_24070);

return statearr_24333;
})();
if(cljs.core.truth_(limit)){
var statearr_24334_24448 = state_24277__$1;
(statearr_24334_24448[(1)] = (26));

} else {
var statearr_24335_24449 = state_24277__$1;
(statearr_24335_24449[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (34))){
var inst_24024 = (state_24277[(25)]);
var inst_24219 = (state_24277[(2)]);
var inst_24220 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_24219);
var state_24277__$1 = (function (){var statearr_24336 = state_24277;
(statearr_24336[(11)] = inst_24220);

return statearr_24336;
})();
var G__24337_24450 = inst_24024;
var G__24337_24451__$1 = (((G__24337_24450 instanceof cljs.core.Keyword))?G__24337_24450.fqn:null);
switch (G__24337_24451__$1) {
case "or":
var statearr_24338_24453 = state_24277__$1;
(statearr_24338_24453[(1)] = (58));


break;
case "and":
var statearr_24339_24454 = state_24277__$1;
(statearr_24339_24454[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24337_24451__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (17))){
var inst_24272 = (state_24277[(2)]);
var _ = (function (){var statearr_24340 = state_24277;
(statearr_24340[(4)] = cljs.core.rest.call(null,(state_24277[(4)])));

return statearr_24340;
})();
var state_24277__$1 = state_24277;
var statearr_24341_24455 = state_24277__$1;
(statearr_24341_24455[(2)] = inst_24272);

(statearr_24341_24455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (3))){
var inst_24275 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24277__$1,inst_24275);
} else {
if((state_val_24278 === (12))){
var inst_24034 = (offset + limit);
var state_24277__$1 = state_24277;
var statearr_24342_24456 = state_24277__$1;
(statearr_24342_24456[(2)] = inst_24034);

(statearr_24342_24456[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (2))){
var inst_24026 = (state_24277[(9)]);
var _ = (function (){var statearr_24343 = state_24277;
(statearr_24343[(4)] = cljs.core.cons.call(null,(5),(state_24277[(4)])));

return statearr_24343;
})();
var inst_24023 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_24024 = cljs.core.nth.call(null,inst_24023,(0),null);
var inst_24025 = cljs.core.nth.call(null,inst_24023,(1),null);
var inst_24026__$1 = limit;
var state_24277__$1 = (function (){var statearr_24344 = state_24277;
(statearr_24344[(9)] = inst_24026__$1);

(statearr_24344[(16)] = inst_24025);

(statearr_24344[(25)] = inst_24024);

return statearr_24344;
})();
if(cljs.core.truth_(inst_24026__$1)){
var statearr_24345_24457 = state_24277__$1;
(statearr_24345_24457[(1)] = (6));

} else {
var statearr_24346_24458 = state_24277__$1;
(statearr_24346_24458[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (66))){
var inst_24240 = (state_24277[(7)]);
var state_24277__$1 = state_24277;
var statearr_24347_24459 = state_24277__$1;
(statearr_24347_24459[(2)] = inst_24240);

(statearr_24347_24459[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (23))){
var inst_24055 = (state_24277[(10)]);
var inst_24067 = cljs.core.drop.call(null,offset,inst_24055);
var state_24277__$1 = state_24277;
var statearr_24348_24460 = state_24277__$1;
(statearr_24348_24460[(2)] = inst_24067);

(statearr_24348_24460[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (47))){
var inst_24213 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24349_24461 = state_24277__$1;
(statearr_24349_24461[(2)] = inst_24213);

(statearr_24349_24461[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (35))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24113 = (state_24277[(2)]);
var inst_24114 = fluree.db.util.async.throw_err.call(null,inst_24113);
var inst_24115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24116 = [inst_24080];
var inst_24117 = (new cljs.core.PersistentVector(null,1,(5),inst_24115,inst_24116,null));
var inst_24118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24119 = [inst_24080,inst_24082];
var inst_24120 = (new cljs.core.PersistentVector(null,2,(5),inst_24118,inst_24119,null));
var inst_24121 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24122 = [inst_24040];
var inst_24123 = cljs.core.PersistentHashMap.fromArrays(inst_24121,inst_24122);
var inst_24124 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24117,cljs.core._LT_,inst_24120,inst_24123);
var state_24277__$1 = (function (){var statearr_24350 = state_24277;
(statearr_24350[(24)] = inst_24114);

return statearr_24350;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(36),inst_24124);
} else {
if((state_val_24278 === (76))){
var inst_24062 = (state_24277[(27)]);
var inst_24234 = (state_24277[(28)]);
var inst_24054 = inst_24062;
var inst_24055 = inst_24234;
var state_24277__$1 = (function (){var statearr_24351 = state_24277;
(statearr_24351[(10)] = inst_24055);

(statearr_24351[(19)] = inst_24054);

return statearr_24351;
})();
var statearr_24352_24462 = state_24277__$1;
(statearr_24352_24462[(2)] = null);

(statearr_24352_24462[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (19))){
var inst_24269 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24353_24463 = state_24277__$1;
(statearr_24353_24463[(2)] = inst_24269);

(statearr_24353_24463[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (57))){
var inst_24235 = (state_24277[(26)]);
var inst_24024 = (state_24277[(25)]);
var inst_24234 = (state_24277[(2)]);
var inst_24235__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24024);
var state_24277__$1 = (function (){var statearr_24354 = state_24277;
(statearr_24354[(26)] = inst_24235__$1);

(statearr_24354[(28)] = inst_24234);

return statearr_24354;
})();
if(inst_24235__$1){
var statearr_24355_24464 = state_24277__$1;
(statearr_24355_24464[(1)] = (63));

} else {
var statearr_24356_24465 = state_24277__$1;
(statearr_24356_24465[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (68))){
var inst_24255 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24255)){
var statearr_24357_24466 = state_24277__$1;
(statearr_24357_24466[(1)] = (75));

} else {
var statearr_24358_24467 = state_24277__$1;
(statearr_24358_24467[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (11))){
var inst_24025 = (state_24277[(16)]);
var inst_24040 = (state_24277[(2)]);
var inst_24041 = cljs.core.not_empty.call(null,inst_24025);
var state_24277__$1 = (function (){var statearr_24360 = state_24277;
(statearr_24360[(12)] = inst_24040);

return statearr_24360;
})();
if(cljs.core.truth_(inst_24041)){
var statearr_24361_24468 = state_24277__$1;
(statearr_24361_24468[(1)] = (15));

} else {
var statearr_24362_24469 = state_24277__$1;
(statearr_24362_24469[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (9))){
var state_24277__$1 = state_24277;
if(cljs.core.truth_(offset)){
var statearr_24363_24470 = state_24277__$1;
(statearr_24363_24470[(1)] = (12));

} else {
var statearr_24364_24471 = state_24277__$1;
(statearr_24364_24471[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (5))){
var _ = (function (){var statearr_24365 = state_24277;
(statearr_24365[(4)] = cljs.core.rest.call(null,(state_24277[(4)])));

return statearr_24365;
})();
var state_24277__$1 = state_24277;
var ex24359 = (state_24277__$1[(2)]);
var statearr_24366_24472 = state_24277__$1;
(statearr_24366_24472[(5)] = ex24359);


if((ex24359 instanceof Error)){
var statearr_24367_24473 = state_24277__$1;
(statearr_24367_24473[(1)] = (4));

(statearr_24367_24473[(5)] = null);

} else {
throw ex24359;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (14))){
var inst_24037 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24368_24474 = state_24277__$1;
(statearr_24368_24474[(2)] = inst_24037);

(statearr_24368_24474[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (45))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24162 = [inst_24080,inst_24082];
var inst_24163 = (new cljs.core.PersistentVector(null,2,(5),inst_24161,inst_24162,null));
var inst_24164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24165 = [inst_24080];
var inst_24166 = (new cljs.core.PersistentVector(null,1,(5),inst_24164,inst_24165,null));
var inst_24167 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24168 = [inst_24040];
var inst_24169 = cljs.core.PersistentHashMap.fromArrays(inst_24167,inst_24168);
var inst_24170 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24163,cljs.core._LT__EQ_,inst_24166,inst_24169);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(48),inst_24170);
} else {
if((state_val_24278 === (53))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24194 = [inst_24080];
var inst_24195 = (new cljs.core.PersistentVector(null,1,(5),inst_24193,inst_24194,null));
var inst_24196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24197 = [inst_24080,inst_24082];
var inst_24198 = (new cljs.core.PersistentVector(null,2,(5),inst_24196,inst_24197,null));
var inst_24199 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24200 = [inst_24040];
var inst_24201 = cljs.core.PersistentHashMap.fromArrays(inst_24199,inst_24200);
var inst_24202 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24195,cljs.core._LT__EQ_,inst_24198,inst_24201);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(56),inst_24202);
} else {
if((state_val_24278 === (78))){
var inst_24234 = (state_24277[(28)]);
var inst_24258 = cljs.core.drop.call(null,offset,inst_24234);
var state_24277__$1 = state_24277;
var statearr_24369_24475 = state_24277__$1;
(statearr_24369_24475[(2)] = inst_24258);

(statearr_24369_24475[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (26))){
var inst_24070 = (state_24277[(13)]);
var inst_24072 = cljs.core.take.call(null,limit,inst_24070);
var state_24277__$1 = state_24277;
var statearr_24370_24476 = state_24277__$1;
(statearr_24370_24476[(2)] = inst_24072);

(statearr_24370_24476[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (16))){
var state_24277__$1 = state_24277;
var statearr_24371_24477 = state_24277__$1;
(statearr_24371_24477[(2)] = null);

(statearr_24371_24477[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (79))){
var inst_24234 = (state_24277[(28)]);
var state_24277__$1 = state_24277;
var statearr_24372_24478 = state_24277__$1;
(statearr_24372_24478[(2)] = inst_24234);

(statearr_24372_24478[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (38))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24143 = inst_24099.call(null,cljs.core._GT_,inst_24081);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24143)){
var statearr_24373_24479 = state_24277__$1;
(statearr_24373_24479[(1)] = (41));

} else {
var statearr_24374_24480 = state_24277__$1;
(statearr_24374_24480[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (30))){
var state_24277__$1 = state_24277;
var statearr_24375_24481 = state_24277__$1;
(statearr_24375_24481[(2)] = null);

(statearr_24375_24481[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (73))){
var inst_24040 = (state_24277[(12)]);
var state_24277__$1 = state_24277;
var statearr_24376_24482 = state_24277__$1;
(statearr_24376_24482[(2)] = inst_24040);

(statearr_24376_24482[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (10))){
var state_24277__$1 = state_24277;
var statearr_24377_24483 = state_24277__$1;
(statearr_24377_24483[(2)] = null);

(statearr_24377_24483[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (18))){
var inst_24061 = (state_24277[(21)]);
var inst_24054 = (state_24277[(19)]);
var inst_24060 = cljs.core.seq.call(null,inst_24054);
var inst_24061__$1 = cljs.core.first.call(null,inst_24060);
var inst_24062 = cljs.core.next.call(null,inst_24060);
var inst_24063 = cljs.core.not.call(null,inst_24061__$1);
var state_24277__$1 = (function (){var statearr_24378 = state_24277;
(statearr_24378[(27)] = inst_24062);

(statearr_24378[(21)] = inst_24061__$1);

return statearr_24378;
})();
if(inst_24063){
var statearr_24379_24484 = state_24277__$1;
(statearr_24379_24484[(1)] = (20));

} else {
var statearr_24380_24485 = state_24277__$1;
(statearr_24380_24485[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (52))){
var inst_24188 = (state_24277[(2)]);
var inst_24189 = fluree.db.util.async.throw_err.call(null,inst_24188);
var state_24277__$1 = state_24277;
var statearr_24381_24486 = state_24277__$1;
(statearr_24381_24486[(2)] = inst_24189);

(statearr_24381_24486[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (67))){
var inst_24243 = (state_24277[(8)]);
var inst_24024 = (state_24277[(25)]);
var inst_24243__$1 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_24024);
var state_24277__$1 = (function (){var statearr_24382 = state_24277;
(statearr_24382[(8)] = inst_24243__$1);

return statearr_24382;
})();
if(inst_24243__$1){
var statearr_24383_24487 = state_24277__$1;
(statearr_24383_24487[(1)] = (69));

} else {
var statearr_24384_24488 = state_24277__$1;
(statearr_24384_24488[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (71))){
var inst_24253 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24385_24489 = state_24277__$1;
(statearr_24385_24489[(2)] = inst_24253);

(statearr_24385_24489[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (42))){
var inst_24081 = (state_24277[(14)]);
var inst_24099 = (state_24277[(15)]);
var inst_24159 = inst_24099.call(null,cljs.core._GT__EQ_,inst_24081);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24159)){
var statearr_24386_24490 = state_24277__$1;
(statearr_24386_24490[(1)] = (45));

} else {
var statearr_24387_24491 = state_24277__$1;
(statearr_24387_24491[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (80))){
var inst_24261 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
var statearr_24388_24492 = state_24277__$1;
(statearr_24388_24492[(2)] = inst_24261);

(statearr_24388_24492[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (37))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24133 = [inst_24080,inst_24082];
var inst_24134 = (new cljs.core.PersistentVector(null,2,(5),inst_24132,inst_24133,null));
var inst_24135 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24136 = [inst_24040];
var inst_24137 = cljs.core.PersistentHashMap.fromArrays(inst_24135,inst_24136);
var inst_24138 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24134,inst_24137);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(40),inst_24138);
} else {
if((state_val_24278 === (63))){
var inst_24234 = (state_24277[(28)]);
var inst_24237 = cljs.core.empty_QMARK_.call(null,inst_24234);
var state_24277__$1 = state_24277;
var statearr_24389_24493 = state_24277__$1;
(statearr_24389_24493[(2)] = inst_24237);

(statearr_24389_24493[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (8))){
var inst_24031 = (state_24277[(2)]);
var state_24277__$1 = state_24277;
if(cljs.core.truth_(inst_24031)){
var statearr_24390_24494 = state_24277__$1;
(statearr_24390_24494[(1)] = (9));

} else {
var statearr_24391_24495 = state_24277__$1;
(statearr_24391_24495[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24278 === (49))){
var inst_24040 = (state_24277[(12)]);
var inst_24080 = (state_24277[(20)]);
var inst_24082 = (state_24277[(22)]);
var inst_24177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24178 = [inst_24080];
var inst_24179 = (new cljs.core.PersistentVector(null,1,(5),inst_24177,inst_24178,null));
var inst_24180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24181 = [inst_24080,inst_24082];
var inst_24182 = (new cljs.core.PersistentVector(null,2,(5),inst_24180,inst_24181,null));
var inst_24183 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_24184 = [inst_24040];
var inst_24185 = cljs.core.PersistentHashMap.fromArrays(inst_24183,inst_24184);
var inst_24186 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24179,cljs.core._LT_,inst_24182,inst_24185);
var state_24277__$1 = state_24277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24277__$1,(52),inst_24186);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_24392 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24392[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_24392[(1)] = (1));

return statearr_24392;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_24277){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24393){var ex__2744__auto__ = e24393;
var statearr_24394_24496 = state_24277;
(statearr_24394_24496[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24277[(4)]))){
var statearr_24395_24497 = state_24277;
(statearr_24395_24497[(1)] = cljs.core.first.call(null,(state_24277[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24498 = state_24277;
state_24277 = G__24498;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_24277){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_24277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24396 = f__2764__auto__.call(null);
(statearr_24396[(6)] = c__2763__auto__);

return statearr_24396;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4253__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__24499_SHARP_){
return ((typeof p1__24499_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__24499_SHARP_)));
}),select_smt);
if(or__4253__auto__){
return or__4253__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24500_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24500_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24504 = vars;
var vec__24505 = G__24504;
var seq__24506 = cljs.core.seq.call(null,vec__24505);
var first__24507 = cljs.core.first.call(null,seq__24506);
var seq__24506__$1 = cljs.core.next.call(null,seq__24506);
var var$ = first__24507;
var r = seq__24506__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24504__$1 = G__24504;
var all_vars__$1 = all_vars;
while(true){
var vec__24511 = G__24504__$1;
var seq__24512 = cljs.core.seq.call(null,vec__24511);
var first__24513 = cljs.core.first.call(null,seq__24512);
var seq__24512__$1 = cljs.core.next.call(null,seq__24512);
var var$__$1 = first__24513;
var r__$1 = seq__24512__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24514 = r__$1;
var G__24515 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24504__$1 = G__24514;
all_vars__$1 = G__24515;
continue;
} else {
var G__24516 = r__$1;
var G__24517 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24504__$1 = G__24516;
all_vars__$1 = G__24517;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24552){
var state_val_24553 = (state_24552[(1)]);
if((state_val_24553 === (1))){
var inst_24525 = functionArray;
var inst_24526 = cljs.core.seq.call(null,inst_24525);
var inst_24527 = cljs.core.first.call(null,inst_24526);
var inst_24528 = cljs.core.next.call(null,inst_24526);
var inst_24529 = cljs.core.PersistentVector.EMPTY;
var inst_24530 = inst_24525;
var inst_24531 = inst_24529;
var state_24552__$1 = (function (){var statearr_24554 = state_24552;
(statearr_24554[(7)] = inst_24528);

(statearr_24554[(8)] = inst_24527);

(statearr_24554[(9)] = inst_24531);

(statearr_24554[(10)] = inst_24530);

return statearr_24554;
})();
var statearr_24555_24568 = state_24552__$1;
(statearr_24555_24568[(2)] = null);

(statearr_24555_24568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24553 === (2))){
var inst_24537 = (state_24552[(11)]);
var inst_24530 = (state_24552[(10)]);
var inst_24536 = cljs.core.seq.call(null,inst_24530);
var inst_24537__$1 = cljs.core.first.call(null,inst_24536);
var inst_24538 = cljs.core.next.call(null,inst_24536);
var state_24552__$1 = (function (){var statearr_24556 = state_24552;
(statearr_24556[(11)] = inst_24537__$1);

(statearr_24556[(12)] = inst_24538);

return statearr_24556;
})();
if(cljs.core.truth_(inst_24537__$1)){
var statearr_24557_24569 = state_24552__$1;
(statearr_24557_24569[(1)] = (4));

} else {
var statearr_24558_24570 = state_24552__$1;
(statearr_24558_24570[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24553 === (3))){
var inst_24550 = (state_24552[(2)]);
var state_24552__$1 = state_24552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24552__$1,inst_24550);
} else {
if((state_val_24553 === (4))){
var inst_24537 = (state_24552[(11)]);
var inst_24540 = inst_24537.call(null,tuple);
var state_24552__$1 = state_24552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24552__$1,(7),inst_24540);
} else {
if((state_val_24553 === (5))){
var inst_24531 = (state_24552[(9)]);
var state_24552__$1 = state_24552;
var statearr_24559_24571 = state_24552__$1;
(statearr_24559_24571[(2)] = inst_24531);

(statearr_24559_24571[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24553 === (6))){
var inst_24548 = (state_24552[(2)]);
var state_24552__$1 = state_24552;
var statearr_24560_24572 = state_24552__$1;
(statearr_24560_24572[(2)] = inst_24548);

(statearr_24560_24572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24553 === (7))){
var inst_24538 = (state_24552[(12)]);
var inst_24531 = (state_24552[(9)]);
var inst_24542 = (state_24552[(2)]);
var inst_24543 = fluree.db.util.async.throw_err.call(null,inst_24542);
var inst_24544 = cljs.core.conj.call(null,inst_24531,inst_24543);
var inst_24530 = inst_24538;
var inst_24531__$1 = inst_24544;
var state_24552__$1 = (function (){var statearr_24561 = state_24552;
(statearr_24561[(9)] = inst_24531__$1);

(statearr_24561[(10)] = inst_24530);

return statearr_24561;
})();
var statearr_24562_24573 = state_24552__$1;
(statearr_24562_24573[(2)] = null);

(statearr_24562_24573[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0 = (function (){
var statearr_24563 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24563[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__);

(statearr_24563[(1)] = (1));

return statearr_24563;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1 = (function (state_24552){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24564){var ex__2744__auto__ = e24564;
var statearr_24565_24574 = state_24552;
(statearr_24565_24574[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24552[(4)]))){
var statearr_24566_24575 = state_24552;
(statearr_24566_24575[(1)] = cljs.core.first.call(null,(state_24552[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24576 = state_24552;
state_24552 = G__24576;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__ = function(state_24552){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1.call(this,state_24552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2741__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24567 = f__2764__auto__.call(null);
(statearr_24567[(6)] = c__2763__auto__);

return statearr_24567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.call(null,(function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.call(null,pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24577){
var vec__24578 = p__24577;
var tuple_index = cljs.core.nth.call(null,vec__24578,(0),null);
var query_map = cljs.core.nth.call(null,vec__24578,(1),null);
var temp__5753__auto__ = cljs.core.get.call(null,tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24592){
var state_val_24593 = (state_24592[(1)]);
if((state_val_24593 === (1))){
var inst_24581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24582 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24583 = [query_map,_id,query_opts];
var inst_24584 = cljs.core.PersistentHashMap.fromArrays(inst_24582,inst_24583);
var inst_24585 = fluree.db.query.fql.query.call(null,db,inst_24584);
var state_24592__$1 = (function (){var statearr_24594 = state_24592;
(statearr_24594[(7)] = inst_24581);

return statearr_24594;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24592__$1,(2),inst_24585);
} else {
if((state_val_24593 === (2))){
var inst_24581 = (state_24592[(7)]);
var inst_24587 = (state_24592[(2)]);
var inst_24588 = fluree.db.util.async.throw_err.call(null,inst_24587);
var inst_24589 = [tuple_index,inst_24588];
var inst_24590 = (new cljs.core.PersistentVector(null,2,(5),inst_24581,inst_24589,null));
var state_24592__$1 = state_24592;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24592__$1,inst_24590);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0 = (function (){
var statearr_24595 = [null,null,null,null,null,null,null,null];
(statearr_24595[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2741__auto__);

(statearr_24595[(1)] = (1));

return statearr_24595;
});
var fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1 = (function (state_24592){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24592);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24596){var ex__2744__auto__ = e24596;
var statearr_24597_24600 = state_24592;
(statearr_24597_24600[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24592[(4)]))){
var statearr_24598_24601 = state_24592;
(statearr_24598_24601[(1)] = cljs.core.first.call(null,(state_24592[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24602 = state_24592;
state_24592 = G__24602;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__ = function(state_24592){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1.call(this,state_24592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2741__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2741__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24599 = f__2764__auto__.call(null);
(statearr_24599[(6)] = c__2763__auto__);

return statearr_24599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_.call(null,expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24603 = expand_map_tuple;
var tuple_index = cljs.core.nth.call(null,vec__24603,(0),null);
var query_map_result = cljs.core.nth.call(null,vec__24603,(1),null);
return cljs.core.assoc.call(null,tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24666){
var state_val_24667 = (state_24666[(1)]);
if((state_val_24667 === (7))){
var inst_24661 = (state_24666[(2)]);
var _ = (function (){var statearr_24668 = state_24666;
(statearr_24668[(4)] = cljs.core.rest.call(null,(state_24666[(4)])));

return statearr_24668;
})();
var state_24666__$1 = state_24666;
var statearr_24669_24760 = state_24666__$1;
(statearr_24669_24760[(2)] = inst_24661);

(statearr_24669_24760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (20))){
var inst_24652 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24670_24761 = state_24666__$1;
(statearr_24670_24761[(2)] = inst_24652);

(statearr_24670_24761[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (1))){
var state_24666__$1 = state_24666;
var statearr_24671_24762 = state_24666__$1;
(statearr_24671_24762[(2)] = null);

(statearr_24671_24762[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (4))){
var inst_24608 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24672_24763 = state_24666__$1;
(statearr_24672_24763[(2)] = inst_24608);

(statearr_24672_24763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (15))){
var inst_24628 = (state_24666[(7)]);
var inst_24637 = cljs.core.second.call(null,inst_24628);
var inst_24638 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_24637);
var inst_24639 = (inst_24638 > max_fuel);
var state_24666__$1 = state_24666;
if(cljs.core.truth_(inst_24639)){
var statearr_24673_24764 = state_24666__$1;
(statearr_24673_24764[(1)] = (18));

} else {
var statearr_24674_24765 = state_24666__$1;
(statearr_24674_24765[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (13))){
var state_24666__$1 = state_24666;
var statearr_24675_24766 = state_24666__$1;
(statearr_24675_24766[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (6))){
var inst_24616 = (state_24666[(8)]);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24666__$1,(8),inst_24616);
} else {
if((state_val_24667 === (17))){
var inst_24655 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24677_24767 = state_24666__$1;
(statearr_24677_24767[(2)] = inst_24655);

(statearr_24677_24767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (3))){
var inst_24664 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24666__$1,inst_24664);
} else {
if((state_val_24667 === (12))){
var inst_24628 = (state_24666[(7)]);
var inst_24617 = (state_24666[(9)]);
var inst_24634 = inst_24617.call(null);
var state_24666__$1 = (function (){var statearr_24678 = state_24666;
(statearr_24678[(10)] = inst_24634);

return statearr_24678;
})();
var statearr_24679_24768 = state_24666__$1;
(statearr_24679_24768[(2)] = inst_24628);

(statearr_24679_24768[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (2))){
var inst_24617 = (state_24666[(9)]);
var inst_24616 = (state_24666[(8)]);
var _ = (function (){var statearr_24680 = state_24666;
(statearr_24680[(4)] = cljs.core.cons.call(null,(5),(state_24666[(4)])));

return statearr_24680;
})();
var inst_24614 = fluree.db.query.fql.build_expand_map.call(null,select,pp_keys);
var inst_24615 = cljs.core.async.chan.call(null);
var inst_24616__$1 = cljs.core.async.chan.call(null);
var inst_24617__$1 = (function (){var expandMaps = inst_24614;
var queue_ch = inst_24615;
var res_ch = inst_24616__$1;
return (function (){
cljs.core.async.close_BANG_.call(null,queue_ch);

return cljs.core.async.close_BANG_.call(null,res_ch);
});
})();
var inst_24618 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24619 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24620 = cljs.core.assoc.call(null,inst_24618,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24619);
var inst_24621 = (function (){var expandMaps = inst_24614;
var queue_ch = inst_24615;
var res_ch = inst_24616__$1;
var stop_BANG_ = inst_24617__$1;
var opts_STAR_ = inst_24620;
return (function (tuple_res,port){
var c__2763__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24713){
var state_val_24714 = (state_24713[(1)]);
if((state_val_24714 === (7))){
var state_24713__$1 = state_24713;
var statearr_24715_24769 = state_24713__$1;
(statearr_24715_24769[(2)] = tuple_res);

(statearr_24715_24769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (1))){
var state_24713__$1 = state_24713;
var statearr_24716_24770 = state_24713__$1;
(statearr_24716_24770[(2)] = null);

(statearr_24716_24770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (4))){
var inst_24681 = (state_24713[(2)]);
var inst_24682 = cljs.core.async.put_BANG_.call(null,port,inst_24681);
var inst_24683 = cljs.core.async.close_BANG_.call(null,port);
var state_24713__$1 = (function (){var statearr_24717 = state_24713;
(statearr_24717[(7)] = inst_24682);

return statearr_24717;
})();
var statearr_24718_24771 = state_24713__$1;
(statearr_24718_24771[(2)] = inst_24683);

(statearr_24718_24771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (6))){
var inst_24690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24691 = [tuple_res];
var inst_24692 = (new cljs.core.PersistentVector(null,1,(5),inst_24690,inst_24691,null));
var state_24713__$1 = state_24713;
var statearr_24719_24772 = state_24713__$1;
(statearr_24719_24772[(2)] = inst_24692);

(statearr_24719_24772[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (3))){
var inst_24711 = (state_24713[(2)]);
var state_24713__$1 = state_24713;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24713__$1,inst_24711);
} else {
if((state_val_24714 === (2))){
var ___$1 = (function (){var statearr_24721 = state_24713;
(statearr_24721[(4)] = cljs.core.cons.call(null,(5),(state_24713[(4)])));

return statearr_24721;
})();
var state_24713__$1 = state_24713;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24722_24773 = state_24713__$1;
(statearr_24722_24773[(1)] = (6));

} else {
var statearr_24723_24774 = state_24713__$1;
(statearr_24723_24774[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (9))){
var inst_24695 = (state_24713[(8)]);
var inst_24697 = (state_24713[(9)]);
var inst_24704 = (state_24713[(2)]);
var inst_24705 = cljs.core.reduce.call(null,fluree.db.query.fql.replace_expand_maps,inst_24695,inst_24704);
var inst_24706 = inst_24697.call(null,inst_24705);
var inst_24707 = cljs.core.async.put_BANG_.call(null,port,inst_24706);
var inst_24708 = cljs.core.async.close_BANG_.call(null,port);
var ___$1 = (function (){var statearr_24724 = state_24713;
(statearr_24724[(4)] = cljs.core.rest.call(null,(state_24713[(4)])));

return statearr_24724;
})();
var state_24713__$1 = (function (){var statearr_24725 = state_24713;
(statearr_24725[(10)] = inst_24707);

return statearr_24725;
})();
var statearr_24726_24775 = state_24713__$1;
(statearr_24726_24775[(2)] = inst_24708);

(statearr_24726_24775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (5))){
var ___$1 = (function (){var statearr_24727 = state_24713;
(statearr_24727[(4)] = cljs.core.rest.call(null,(state_24713[(4)])));

return statearr_24727;
})();
var state_24713__$1 = state_24713;
var ex24720 = (state_24713__$1[(2)]);
var statearr_24728_24776 = state_24713__$1;
(statearr_24728_24776[(5)] = ex24720);


var statearr_24729_24777 = state_24713__$1;
(statearr_24729_24777[(1)] = (4));

(statearr_24729_24777[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24714 === (8))){
var inst_24695 = (state_24713[(8)]);
var inst_24695__$1 = (state_24713[(2)]);
var inst_24696 = cljs.core.volatile_BANG_.call(null,(0));
var inst_24697 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24695__$1;
var query_fuel = inst_24696;
return (function (p1__24607_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p1__24607_SHARP_),cljs.core.deref.call(null,query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24607_SHARP_,cljs.core.deref.call(null,query_fuel)], null);
}
});
})();
var inst_24698 = cljs.core.PersistentVector.EMPTY;
var inst_24699 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24695__$1;
var query_fuel = inst_24696;
return (function (p1__24606_SHARP_){
return fluree.db.query.fql.expand_map.call(null,db,cljs.core.assoc.call(null,opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24606_SHARP_);
});
})();
var inst_24700 = cljs.core.keep.call(null,inst_24699,expandMaps);
var inst_24701 = cljs.core.async.merge.call(null,inst_24700);
var inst_24702 = cljs.core.async.into.call(null,inst_24698,inst_24701);
var state_24713__$1 = (function (){var statearr_24730 = state_24713;
(statearr_24730[(8)] = inst_24695__$1);

(statearr_24730[(9)] = inst_24697);

return statearr_24730;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24713__$1,(9),inst_24702);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0 = (function (){
var statearr_24731 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24731[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__);

(statearr_24731[(1)] = (1));

return statearr_24731;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1 = (function (state_24713){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24713);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24732){var ex__2744__auto__ = e24732;
var statearr_24733_24778 = state_24713;
(statearr_24733_24778[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24713[(4)]))){
var statearr_24734_24779 = state_24713;
(statearr_24734_24779[(1)] = cljs.core.first.call(null,(state_24713[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24780 = state_24713;
state_24713 = G__24780;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = function(state_24713){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1.call(this,state_24713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24735 = f__2764__auto__.call(null);
(statearr_24735[(6)] = c__2763__auto____$1);

return statearr_24735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto____$1;
});
})();
var inst_24622 = cljs.core.async.onto_chan_BANG_.call(null,inst_24615,tuples_res);
var inst_24623 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24616__$1,inst_24621,inst_24615);
var inst_24624 = cljs.core.PersistentVector.EMPTY;
var inst_24625 = inst_24624;
var state_24666__$1 = (function (){var statearr_24736 = state_24666;
(statearr_24736[(11)] = inst_24623);

(statearr_24736[(9)] = inst_24617__$1);

(statearr_24736[(12)] = inst_24622);

(statearr_24736[(13)] = inst_24625);

(statearr_24736[(8)] = inst_24616__$1);

return statearr_24736;
})();
var statearr_24737_24781 = state_24666__$1;
(statearr_24737_24781[(2)] = null);

(statearr_24737_24781[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (19))){
var inst_24628 = (state_24666[(7)]);
var inst_24625 = (state_24666[(13)]);
var inst_24648 = cljs.core.first.call(null,inst_24628);
var inst_24649 = cljs.core.conj.call(null,inst_24625,inst_24648);
var inst_24625__$1 = inst_24649;
var state_24666__$1 = (function (){var statearr_24738 = state_24666;
(statearr_24738[(13)] = inst_24625__$1);

return statearr_24738;
})();
var statearr_24739_24782 = state_24666__$1;
(statearr_24739_24782[(2)] = null);

(statearr_24739_24782[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (11))){
var inst_24659 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24741_24783 = state_24666__$1;
(statearr_24741_24783[(2)] = inst_24659);

(statearr_24741_24783[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (9))){
var inst_24625 = (state_24666[(13)]);
var state_24666__$1 = state_24666;
var statearr_24742_24784 = state_24666__$1;
(statearr_24742_24784[(2)] = inst_24625);

(statearr_24742_24784[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (5))){
var _ = (function (){var statearr_24743 = state_24666;
(statearr_24743[(4)] = cljs.core.rest.call(null,(state_24666[(4)])));

return statearr_24743;
})();
var state_24666__$1 = state_24666;
var ex24740 = (state_24666__$1[(2)]);
var statearr_24744_24785 = state_24666__$1;
(statearr_24744_24785[(5)] = ex24740);


if((ex24740 instanceof Error)){
var statearr_24745_24786 = state_24666__$1;
(statearr_24745_24786[(1)] = (4));

(statearr_24745_24786[(5)] = null);

} else {
throw ex24740;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (14))){
var inst_24657 = (state_24666[(2)]);
var state_24666__$1 = state_24666;
var statearr_24746_24787 = state_24666__$1;
(statearr_24746_24787[(2)] = inst_24657);

(statearr_24746_24787[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (16))){
var state_24666__$1 = state_24666;
var statearr_24747_24788 = state_24666__$1;
(statearr_24747_24788[(2)] = null);

(statearr_24747_24788[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (10))){
var inst_24628 = (state_24666[(7)]);
var inst_24632 = fluree.db.util.core.exception_QMARK_.call(null,inst_24628);
var state_24666__$1 = state_24666;
if(inst_24632){
var statearr_24748_24789 = state_24666__$1;
(statearr_24748_24789[(1)] = (12));

} else {
var statearr_24749_24790 = state_24666__$1;
(statearr_24749_24790[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (18))){
var inst_24617 = (state_24666[(9)]);
var inst_24641 = inst_24617.call(null);
var inst_24642 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24643 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24644 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24645 = cljs.core.PersistentHashMap.fromArrays(inst_24643,inst_24644);
var inst_24646 = cljs.core.ex_info.call(null,inst_24642,inst_24645);
var state_24666__$1 = (function (){var statearr_24750 = state_24666;
(statearr_24750[(14)] = inst_24641);

return statearr_24750;
})();
var statearr_24751_24791 = state_24666__$1;
(statearr_24751_24791[(2)] = inst_24646);

(statearr_24751_24791[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24667 === (8))){
var inst_24628 = (state_24666[(7)]);
var inst_24628__$1 = (state_24666[(2)]);
var inst_24629 = (inst_24628__$1 == null);
var state_24666__$1 = (function (){var statearr_24752 = state_24666;
(statearr_24752[(7)] = inst_24628__$1);

return statearr_24752;
})();
if(cljs.core.truth_(inst_24629)){
var statearr_24753_24792 = state_24666__$1;
(statearr_24753_24792[(1)] = (9));

} else {
var statearr_24754_24793 = state_24666__$1;
(statearr_24754_24793[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0 = (function (){
var statearr_24755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24755[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__);

(statearr_24755[(1)] = (1));

return statearr_24755;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1 = (function (state_24666){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e24756){var ex__2744__auto__ = e24756;
var statearr_24757_24794 = state_24666;
(statearr_24757_24794[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24666[(4)]))){
var statearr_24758_24795 = state_24666;
(statearr_24758_24795[(1)] = cljs.core.first.call(null,(state_24666[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24796 = state_24666;
state_24666 = G__24796;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__ = function(state_24666){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1.call(this,state_24666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_24759 = f__2764__auto__.call(null);
(statearr_24759[(6)] = c__2763__auto__);

return statearr_24759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24797 = select;
var map__24797__$1 = cljs.core.__destructure_map.call(null,map__24797);
var as = cljs.core.get.call(null,map__24797__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.call(null,map__24797__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.call(null,map__24797__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4253__auto__ = as;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly.call(null,value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?cljs.core.constantly.call(null,cljs.core.get.call(null,vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.call(null,cljs.core.juxt,cljs.core.map.call(null,cljs.core.partial.call(null,fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24800 = orderBy;
var order = cljs.core.nth.call(null,vec__24800,(0),null);
var var$ = cljs.core.nth.call(null,vec__24800,(1),null);
var option = cljs.core.nth.call(null,vec__24800,(2),null);
var comparator = ((cljs.core._EQ_.call(null,"DESC",order))?(function (a,b){
return cljs.core.compare.call(null,b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.call(null,"NOCASE",clojure.string.upper_case.call(null,option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24798_SHARP_){
return clojure.string.upper_case.call(null,cljs.core.nth.call(null,p1__24798_SHARP_,compare_idx));
}):(function (p1__24799_SHARP_){
return cljs.core.nth.call(null,p1__24799_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count.call(null,tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.call(null,keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24805 = arguments.length;
switch (G__24805) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24806,p__24807,group_limit,opts){
var map__24808 = p__24806;
var map__24808__$1 = cljs.core.__destructure_map.call(null,map__24808);
var res = map__24808__$1;
var vars = cljs.core.get.call(null,map__24808__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24809 = p__24807;
var map__24809__$1 = cljs.core.__destructure_map.call(null,map__24809);
var select_spec = map__24809__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24809__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_24946){
var state_val_24947 = (state_24946[(1)]);
if((state_val_24947 === (7))){
var inst_24816 = (state_24946[(7)]);
var state_24946__$1 = state_24946;
var statearr_24948_25050 = state_24946__$1;
(statearr_24948_25050[(2)] = inst_24816);

(statearr_24948_25050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (59))){
var inst_24939 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
var statearr_24949_25051 = state_24946__$1;
(statearr_24949_25051[(2)] = inst_24939);

(statearr_24949_25051[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (20))){
var inst_24855 = (state_24946[(8)]);
var inst_24852 = (state_24946[(9)]);
var inst_24851 = (state_24946[(2)]);
var inst_24852__$1 = cljs.core.__destructure_map.call(null,inst_24851);
var inst_24853 = cljs.core.get.call(null,inst_24852__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24854 = cljs.core.get.call(null,inst_24852__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24855__$1 = offset;
var state_24946__$1 = (function (){var statearr_24950 = state_24946;
(statearr_24950[(10)] = inst_24854);

(statearr_24950[(11)] = inst_24853);

(statearr_24950[(8)] = inst_24855__$1);

(statearr_24950[(9)] = inst_24852__$1);

return statearr_24950;
})();
if(cljs.core.truth_(inst_24855__$1)){
var statearr_24951_25052 = state_24946__$1;
(statearr_24951_25052[(1)] = (21));

} else {
var statearr_24952_25053 = state_24946__$1;
(statearr_24952_25053[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (58))){
var inst_24931 = (state_24946[(12)]);
var state_24946__$1 = state_24946;
var statearr_24953_25054 = state_24946__$1;
(statearr_24953_25054[(2)] = inst_24931);

(statearr_24953_25054[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (60))){
var inst_24935 = (state_24946[(2)]);
var inst_24936 = fluree.db.util.async.throw_err.call(null,inst_24935);
var state_24946__$1 = state_24946;
var statearr_24954_25055 = state_24946__$1;
(statearr_24954_25055[(2)] = inst_24936);

(statearr_24954_25055[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (27))){
var inst_24867 = cljs.core.not.call(null,inVector_QMARK_);
var state_24946__$1 = state_24946;
var statearr_24955_25056 = state_24946__$1;
(statearr_24955_25056[(2)] = inst_24867);

(statearr_24955_25056[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (1))){
var state_24946__$1 = state_24946;
var statearr_24956_25057 = state_24946__$1;
(statearr_24956_25057[(2)] = null);

(statearr_24956_25057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (24))){
var state_24946__$1 = state_24946;
var statearr_24957_25058 = state_24946__$1;
(statearr_24957_25058[(2)] = offset);

(statearr_24957_25058[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (55))){
var inst_24925 = (state_24946[(13)]);
var state_24946__$1 = state_24946;
var statearr_24958_25059 = state_24946__$1;
(statearr_24958_25059[(2)] = inst_24925);

(statearr_24958_25059[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (39))){
var inst_24893 = (state_24946[(14)]);
var inst_24895 = cljs.core.distinct.call(null);
var inst_24896 = cljs.core.conj.call(null,inst_24893,inst_24895);
var state_24946__$1 = state_24946;
var statearr_24959_25060 = state_24946__$1;
(statearr_24959_25060[(2)] = inst_24896);

(statearr_24959_25060[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (46))){
var inst_24905 = (state_24946[(15)]);
var state_24946__$1 = state_24946;
var statearr_24960_25061 = state_24946__$1;
(statearr_24960_25061[(2)] = inst_24905);

(statearr_24960_25061[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (4))){
var inst_24810 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
var statearr_24961_25062 = state_24946__$1;
(statearr_24961_25062[(2)] = inst_24810);

(statearr_24961_25062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (54))){
var inst_24919 = (state_24946[(16)]);
var inst_24925 = (state_24946[(13)]);
var inst_24927 = cljs.core.PersistentVector.EMPTY;
var inst_24928 = cljs.core.into.call(null,inst_24927,inst_24919,inst_24925);
var state_24946__$1 = state_24946;
var statearr_24962_25063 = state_24946__$1;
(statearr_24962_25063[(2)] = inst_24928);

(statearr_24962_25063[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (15))){
var inst_24837 = (state_24946[(17)]);
var inst_24839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24840 = [inst_24837];
var inst_24841 = (new cljs.core.PersistentVector(null,1,(5),inst_24839,inst_24840,null));
var state_24946__$1 = state_24946;
var statearr_24963_25064 = state_24946__$1;
(statearr_24963_25064[(2)] = inst_24841);

(statearr_24963_25064[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (48))){
var inst_24870 = (state_24946[(18)]);
var inst_24875 = (state_24946[(19)]);
var inst_24854 = (state_24946[(10)]);
var inst_24853 = (state_24946[(11)]);
var inst_24864 = (state_24946[(20)]);
var inst_24911 = (state_24946[(21)]);
var inst_24852 = (state_24946[(9)]);
var inst_24913 = (function (){var map__24846 = inst_24852;
var headers = inst_24853;
var tuples = inst_24854;
var offset_SINGLEQUOTE_ = inst_24864;
var single_result_QMARK_ = inst_24870;
var pp_keys = inst_24875;
var G__24876 = inst_24911;
return (function (p1__24803_SHARP_){
return cljs.core.zipmap.call(null,fluree.db.query.fql.get_pretty_print_keys.call(null,select),p1__24803_SHARP_);
});
})();
var inst_24914 = cljs.core.map.call(null,inst_24913);
var inst_24915 = cljs.core.conj.call(null,inst_24911,inst_24914);
var state_24946__$1 = state_24946;
var statearr_24964_25065 = state_24946__$1;
(statearr_24964_25065[(2)] = inst_24915);

(statearr_24964_25065[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (50))){
var inst_24918 = (state_24946[(2)]);
var inst_24919 = cljs.core.apply.call(null,cljs.core.comp,inst_24918);
var state_24946__$1 = (function (){var statearr_24965 = state_24946;
(statearr_24965[(16)] = inst_24919);

return statearr_24965;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24966_25066 = state_24946__$1;
(statearr_24966_25066[(1)] = (51));

} else {
var statearr_24967_25067 = state_24946__$1;
(statearr_24967_25067[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (21))){
var inst_24857 = cljs.core.not.call(null,groupBy);
var state_24946__$1 = state_24946;
var statearr_24968_25068 = state_24946__$1;
(statearr_24968_25068[(2)] = inst_24857);

(statearr_24968_25068[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (31))){
var state_24946__$1 = state_24946;
var statearr_24969_25069 = state_24946__$1;
(statearr_24969_25069[(2)] = null);

(statearr_24969_25069[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (32))){
var inst_24870 = (state_24946[(18)]);
var inst_24853 = (state_24946[(11)]);
var inst_24875 = (state_24946[(2)]);
var inst_24877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24878 = fluree.db.query.fql.select_tuples_fn.call(null,inst_24853,vars,select);
var inst_24879 = cljs.core.map.call(null,inst_24878);
var inst_24880 = [inst_24879];
var inst_24881 = (new cljs.core.PersistentVector(null,1,(5),inst_24877,inst_24880,null));
var state_24946__$1 = (function (){var statearr_24970 = state_24946;
(statearr_24970[(19)] = inst_24875);

(statearr_24970[(22)] = inst_24881);

return statearr_24970;
})();
if(cljs.core.truth_(inst_24870)){
var statearr_24971_25070 = state_24946__$1;
(statearr_24971_25070[(1)] = (33));

} else {
var statearr_24972_25071 = state_24946__$1;
(statearr_24972_25071[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (40))){
var inst_24893 = (state_24946[(14)]);
var state_24946__$1 = state_24946;
var statearr_24973_25072 = state_24946__$1;
(statearr_24973_25072[(2)] = inst_24893);

(statearr_24973_25072[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (56))){
var inst_24931 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_24974 = state_24946;
(statearr_24974[(12)] = inst_24931);

return statearr_24974;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24975_25073 = state_24946__$1;
(statearr_24975_25073[(1)] = (57));

} else {
var statearr_24976_25074 = state_24946__$1;
(statearr_24976_25074[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (33))){
var inst_24881 = (state_24946[(22)]);
var inst_24883 = cljs.core.map.call(null,cljs.core.first);
var inst_24884 = cljs.core.conj.call(null,inst_24881,inst_24883);
var state_24946__$1 = state_24946;
var statearr_24977_25075 = state_24946__$1;
(statearr_24977_25075[(2)] = inst_24884);

(statearr_24977_25075[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (13))){
var inst_24826 = (state_24946[(23)]);
var state_24946__$1 = state_24946;
var statearr_24978_25076 = state_24946__$1;
(statearr_24978_25076[(2)] = inst_24826);

(statearr_24978_25076[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (22))){
var inst_24855 = (state_24946[(8)]);
var state_24946__$1 = state_24946;
var statearr_24979_25077 = state_24946__$1;
(statearr_24979_25077[(2)] = inst_24855);

(statearr_24979_25077[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (36))){
var inst_24887 = (state_24946[(24)]);
var inst_24889 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel,(5));
var inst_24890 = cljs.core.conj.call(null,inst_24887,inst_24889);
var state_24946__$1 = state_24946;
var statearr_24980_25078 = state_24946__$1;
(statearr_24980_25078[(2)] = inst_24890);

(statearr_24980_25078[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (41))){
var inst_24864 = (state_24946[(20)]);
var inst_24899 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_24981 = state_24946;
(statearr_24981[(25)] = inst_24899);

return statearr_24981;
})();
if(cljs.core.truth_(inst_24864)){
var statearr_24982_25079 = state_24946__$1;
(statearr_24982_25079[(1)] = (42));

} else {
var statearr_24983_25080 = state_24946__$1;
(statearr_24983_25080[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (43))){
var inst_24899 = (state_24946[(25)]);
var state_24946__$1 = state_24946;
var statearr_24984_25081 = state_24946__$1;
(statearr_24984_25081[(2)] = inst_24899);

(statearr_24984_25081[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (29))){
var inst_24870 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_24985 = state_24946;
(statearr_24985[(18)] = inst_24870);

return statearr_24985;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24986_25082 = state_24946__$1;
(statearr_24986_25082[(1)] = (30));

} else {
var statearr_24987_25083 = state_24946__$1;
(statearr_24987_25083[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (44))){
var inst_24905 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_24988 = state_24946;
(statearr_24988[(15)] = inst_24905);

return statearr_24988;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24989_25084 = state_24946__$1;
(statearr_24989_25084[(1)] = (45));

} else {
var statearr_24990_25085 = state_24946__$1;
(statearr_24990_25085[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (6))){
var inst_24818 = cljs.core.count.call(null,select);
var inst_24819 = cljs.core._EQ_.call(null,(1),inst_24818);
var state_24946__$1 = state_24946;
var statearr_24991_25086 = state_24946__$1;
(statearr_24991_25086[(2)] = inst_24819);

(statearr_24991_25086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (28))){
var inst_24865 = (state_24946[(26)]);
var state_24946__$1 = state_24946;
var statearr_24992_25087 = state_24946__$1;
(statearr_24992_25087[(2)] = inst_24865);

(statearr_24992_25087[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (51))){
var inst_24854 = (state_24946[(10)]);
var inst_24853 = (state_24946[(11)]);
var inst_24922 = fluree.db.query.fql.order_result_tuples.call(null,fuel,max_fuel,inst_24853,orderBy,inst_24854);
var state_24946__$1 = state_24946;
var statearr_24993_25088 = state_24946__$1;
(statearr_24993_25088[(2)] = inst_24922);

(statearr_24993_25088[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (25))){
var state_24946__$1 = state_24946;
var statearr_24994_25089 = state_24946__$1;
(statearr_24994_25089[(2)] = null);

(statearr_24994_25089[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (34))){
var inst_24881 = (state_24946[(22)]);
var state_24946__$1 = state_24946;
var statearr_24995_25090 = state_24946__$1;
(statearr_24995_25090[(2)] = inst_24881);

(statearr_24995_25090[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (17))){
var inst_24844 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
var statearr_24996_25091 = state_24946__$1;
(statearr_24996_25091[(2)] = inst_24844);

(statearr_24996_25091[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (3))){
var inst_24944 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24946__$1,inst_24944);
} else {
if((state_val_24947 === (12))){
var inst_24826 = (state_24946[(23)]);
var inst_24828 = cljs.core.first.call(null,select);
var inst_24829 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24828);
var inst_24830 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24829);
var inst_24831 = cljs.core.subs.call(null,inst_24830,(1));
var inst_24832 = [inst_24831];
var inst_24833 = [inst_24826];
var inst_24834 = cljs.core.PersistentHashMap.fromArrays(inst_24832,inst_24833);
var state_24946__$1 = state_24946;
var statearr_24997_25092 = state_24946__$1;
(statearr_24997_25092[(2)] = inst_24834);

(statearr_24997_25092[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (2))){
var inst_24816 = (state_24946[(7)]);
var _ = (function (){var statearr_24998 = state_24946;
(statearr_24998[(4)] = cljs.core.cons.call(null,(5),(state_24946[(4)])));

return statearr_24998;
})();
var inst_24816__$1 = aggregates;
var state_24946__$1 = (function (){var statearr_24999 = state_24946;
(statearr_24999[(7)] = inst_24816__$1);

return statearr_24999;
})();
if(cljs.core.truth_(inst_24816__$1)){
var statearr_25000_25093 = state_24946__$1;
(statearr_25000_25093[(1)] = (6));

} else {
var statearr_25001_25094 = state_24946__$1;
(statearr_25001_25094[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (23))){
var inst_24860 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
if(cljs.core.truth_(inst_24860)){
var statearr_25002_25095 = state_24946__$1;
(statearr_25002_25095[(1)] = (24));

} else {
var statearr_25003_25096 = state_24946__$1;
(statearr_25003_25096[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (47))){
var inst_24911 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_25004 = state_24946;
(statearr_25004[(21)] = inst_24911);

return statearr_25004;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25005_25097 = state_24946__$1;
(statearr_25005_25097[(1)] = (48));

} else {
var statearr_25006_25098 = state_24946__$1;
(statearr_25006_25098[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (35))){
var inst_24887 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_25007 = state_24946;
(statearr_25007[(24)] = inst_24887);

return statearr_25007;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25008_25099 = state_24946__$1;
(statearr_25008_25099[(1)] = (36));

} else {
var statearr_25009_25100 = state_24946__$1;
(statearr_25009_25100[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (19))){
var state_24946__$1 = state_24946;
var statearr_25010_25101 = state_24946__$1;
(statearr_25010_25101[(2)] = res);

(statearr_25010_25101[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (57))){
var inst_24870 = (state_24946[(18)]);
var inst_24875 = (state_24946[(19)]);
var inst_24931 = (state_24946[(12)]);
var inst_24933 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,select,inst_24875,inst_24870,db,fuel,max_fuel,opts,(8),inst_24931);
var state_24946__$1 = state_24946;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24946__$1,(60),inst_24933);
} else {
if((state_val_24947 === (11))){
var inst_24941 = (state_24946[(2)]);
var _ = (function (){var statearr_25012 = state_24946;
(statearr_25012[(4)] = cljs.core.rest.call(null,(state_24946[(4)])));

return statearr_25012;
})();
var state_24946__$1 = state_24946;
var statearr_25013_25102 = state_24946__$1;
(statearr_25013_25102[(2)] = inst_24941);

(statearr_25013_25102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (9))){
var inst_24824 = cljs.core.first.call(null,aggregates);
var inst_24825 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24824);
var inst_24826 = cljs.core.second.call(null,inst_24825);
var state_24946__$1 = (function (){var statearr_25014 = state_24946;
(statearr_25014[(23)] = inst_24826);

return statearr_25014;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25015_25103 = state_24946__$1;
(statearr_25015_25103[(1)] = (12));

} else {
var statearr_25016_25104 = state_24946__$1;
(statearr_25016_25104[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (5))){
var _ = (function (){var statearr_25017 = state_24946;
(statearr_25017[(4)] = cljs.core.rest.call(null,(state_24946[(4)])));

return statearr_25017;
})();
var state_24946__$1 = state_24946;
var ex25011 = (state_24946__$1[(2)]);
var statearr_25018_25105 = state_24946__$1;
(statearr_25018_25105[(5)] = ex25011);


if((ex25011 instanceof Error)){
var statearr_25019_25106 = state_24946__$1;
(statearr_25019_25106[(1)] = (4));

(statearr_25019_25106[(5)] = null);

} else {
throw ex25011;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (14))){
var inst_24837 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_25020 = state_24946;
(statearr_25020[(17)] = inst_24837);

return statearr_25020;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25021_25107 = state_24946__$1;
(statearr_25021_25107[(1)] = (15));

} else {
var statearr_25022_25108 = state_24946__$1;
(statearr_25022_25108[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (45))){
var inst_24905 = (state_24946[(15)]);
var inst_24907 = cljs.core.take.call(null,group_limit);
var inst_24908 = cljs.core.conj.call(null,inst_24905,inst_24907);
var state_24946__$1 = state_24946;
var statearr_25023_25109 = state_24946__$1;
(statearr_25023_25109[(2)] = inst_24908);

(statearr_25023_25109[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (53))){
var inst_24925 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_25024 = state_24946;
(statearr_25024[(13)] = inst_24925);

return statearr_25024;
})();
var statearr_25025_25110 = state_24946__$1;
(statearr_25025_25110[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (26))){
var inst_24865 = (state_24946[(26)]);
var inst_24864 = (state_24946[(2)]);
var inst_24865__$1 = cljs.core.not.call(null,prettyPrint);
var state_24946__$1 = (function (){var statearr_25027 = state_24946;
(statearr_25027[(26)] = inst_24865__$1);

(statearr_25027[(20)] = inst_24864);

return statearr_25027;
})();
if(inst_24865__$1){
var statearr_25028_25111 = state_24946__$1;
(statearr_25028_25111[(1)] = (27));

} else {
var statearr_25029_25112 = state_24946__$1;
(statearr_25029_25112[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (16))){
var inst_24837 = (state_24946[(17)]);
var state_24946__$1 = state_24946;
var statearr_25030_25113 = state_24946__$1;
(statearr_25030_25113[(2)] = inst_24837);

(statearr_25030_25113[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (38))){
var inst_24893 = (state_24946[(2)]);
var state_24946__$1 = (function (){var statearr_25031 = state_24946;
(statearr_25031[(14)] = inst_24893);

return statearr_25031;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25032_25114 = state_24946__$1;
(statearr_25032_25114[(1)] = (39));

} else {
var statearr_25033_25115 = state_24946__$1;
(statearr_25033_25115[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (30))){
var inst_24872 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24946__$1 = state_24946;
var statearr_25034_25116 = state_24946__$1;
(statearr_25034_25116[(2)] = inst_24872);

(statearr_25034_25116[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (10))){
var state_24946__$1 = state_24946;
if(cljs.core.truth_(aggregates)){
var statearr_25035_25117 = state_24946__$1;
(statearr_25035_25117[(1)] = (18));

} else {
var statearr_25036_25118 = state_24946__$1;
(statearr_25036_25118[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (18))){
var inst_24848 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24946__$1 = state_24946;
var statearr_25037_25119 = state_24946__$1;
(statearr_25037_25119[(2)] = inst_24848);

(statearr_25037_25119[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (52))){
var inst_24854 = (state_24946[(10)]);
var state_24946__$1 = state_24946;
var statearr_25038_25120 = state_24946__$1;
(statearr_25038_25120[(2)] = inst_24854);

(statearr_25038_25120[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (42))){
var inst_24864 = (state_24946[(20)]);
var inst_24899 = (state_24946[(25)]);
var inst_24901 = cljs.core.drop.call(null,inst_24864);
var inst_24902 = cljs.core.conj.call(null,inst_24899,inst_24901);
var state_24946__$1 = state_24946;
var statearr_25039_25121 = state_24946__$1;
(statearr_25039_25121[(2)] = inst_24902);

(statearr_25039_25121[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (37))){
var inst_24887 = (state_24946[(24)]);
var state_24946__$1 = state_24946;
var statearr_25040_25122 = state_24946__$1;
(statearr_25040_25122[(2)] = inst_24887);

(statearr_25040_25122[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (8))){
var inst_24822 = (state_24946[(2)]);
var state_24946__$1 = state_24946;
if(cljs.core.truth_(inst_24822)){
var statearr_25041_25123 = state_24946__$1;
(statearr_25041_25123[(1)] = (9));

} else {
var statearr_25042_25124 = state_24946__$1;
(statearr_25042_25124[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24947 === (49))){
var inst_24911 = (state_24946[(21)]);
var state_24946__$1 = state_24946;
var statearr_25043_25125 = state_24946__$1;
(statearr_25043_25125[(2)] = inst_24911);

(statearr_25043_25125[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2741__auto__ = null;
var fluree$db$query$fql$state_machine__2741__auto____0 = (function (){
var statearr_25044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25044[(0)] = fluree$db$query$fql$state_machine__2741__auto__);

(statearr_25044[(1)] = (1));

return statearr_25044;
});
var fluree$db$query$fql$state_machine__2741__auto____1 = (function (state_24946){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_24946);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25045){var ex__2744__auto__ = e25045;
var statearr_25046_25126 = state_24946;
(statearr_25046_25126[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_24946[(4)]))){
var statearr_25047_25127 = state_24946;
(statearr_25047_25127[(1)] = cljs.core.first.call(null,(state_24946[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25128 = state_24946;
state_24946 = G__25128;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2741__auto__ = function(state_24946){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2741__auto____1.call(this,state_24946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2741__auto____0;
fluree$db$query$fql$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2741__auto____1;
return fluree$db$query$fql$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25048 = f__2764__auto__.call(null);
(statearr_25048[(6)] = c__2763__auto__);

return statearr_25048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25131,groupBy){
var map__25132 = p__25131;
var map__25132__$1 = cljs.core.__destructure_map.call(null,map__25132);
var res = map__25132__$1;
var headers = cljs.core.get.call(null,map__25132__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25132__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25133 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__25133,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__25133,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__25129_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__25129_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__25130_SHARP_){
return cljs.core.nth.call(null,tuple,p1__25130_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25136 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__25136,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__25136,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25139,p__25140,opts){
var map__25141 = p__25139;
var map__25141__$1 = cljs.core.__destructure_map.call(null,map__25141);
var res = map__25141__$1;
var headers = cljs.core.get.call(null,map__25141__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__25141__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25142 = p__25140;
var map__25142__$1 = cljs.core.__destructure_map.call(null,map__25142);
var select_spec = map__25142__$1;
var groupBy = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__25142__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_25384){
var state_val_25385 = (state_25384[(1)]);
if((state_val_25385 === (65))){
var state_25384__$1 = state_25384;
var statearr_25386_25537 = state_25384__$1;
(statearr_25386_25537[(1)] = (67));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (70))){
var inst_25305 = (state_25384[(7)]);
var state_25384__$1 = state_25384;
var statearr_25388_25538 = state_25384__$1;
(statearr_25388_25538[(2)] = inst_25305);

(statearr_25388_25538[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (62))){
var state_25384__$1 = state_25384;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25389_25539 = state_25384__$1;
(statearr_25389_25539[(1)] = (64));

} else {
var statearr_25390_25540 = state_25384__$1;
(statearr_25390_25540[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (74))){
var inst_25221 = (state_25384[(8)]);
var inst_25280 = (state_25384[(9)]);
var inst_25212 = (state_25384[(10)]);
var inst_25313 = cljs.core.assoc.call(null,inst_25212,inst_25221,inst_25280);
var state_25384__$1 = state_25384;
var statearr_25391_25541 = state_25384__$1;
(statearr_25391_25541[(2)] = inst_25313);

(statearr_25391_25541[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (7))){
var state_25384__$1 = state_25384;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25392_25542 = state_25384__$1;
(statearr_25392_25542[(1)] = (82));

} else {
var statearr_25393_25543 = state_25384__$1;
(statearr_25393_25543[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (59))){
var inst_25210 = (state_25384[(11)]);
var inst_25280 = (state_25384[(9)]);
var inst_25284 = cljs.core.count.call(null,inst_25280);
var inst_25285 = (inst_25210 - inst_25284);
var state_25384__$1 = state_25384;
var statearr_25394_25544 = state_25384__$1;
(statearr_25394_25544[(2)] = inst_25285);

(statearr_25394_25544[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (86))){
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25395_25545 = state_25384__$1;
(statearr_25395_25545[(1)] = (89));

} else {
var statearr_25396_25546 = state_25384__$1;
(statearr_25396_25546[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (20))){
var state_25384__$1 = state_25384;
var statearr_25397_25547 = state_25384__$1;
(statearr_25397_25547[(2)] = (0));

(statearr_25397_25547[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (72))){
var inst_25310 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25310)){
var statearr_25398_25548 = state_25384__$1;
(statearr_25398_25548[(1)] = (73));

} else {
var statearr_25399_25549 = state_25384__$1;
(statearr_25399_25549[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (58))){
var state_25384__$1 = state_25384;
var statearr_25400_25550 = state_25384__$1;
(statearr_25400_25550[(2)] = null);

(statearr_25400_25550[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (60))){
var inst_25211 = (state_25384[(12)]);
var inst_25287 = (state_25384[(2)]);
var inst_25288 = (inst_25211 <= (0));
var state_25384__$1 = (function (){var statearr_25401 = state_25384;
(statearr_25401[(13)] = inst_25287);

return statearr_25401;
})();
if(cljs.core.truth_(inst_25288)){
var statearr_25402_25551 = state_25384__$1;
(statearr_25402_25551[(1)] = (61));

} else {
var statearr_25403_25552 = state_25384__$1;
(statearr_25403_25552[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (27))){
var inst_25210 = (state_25384[(11)]);
var inst_25234 = (inst_25210 < (1));
var state_25384__$1 = state_25384;
var statearr_25404_25553 = state_25384__$1;
(statearr_25404_25553[(2)] = inst_25234);

(statearr_25404_25553[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (1))){
var state_25384__$1 = state_25384;
var statearr_25405_25554 = state_25384__$1;
(statearr_25405_25554[(2)] = null);

(statearr_25405_25554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (69))){
var inst_25300 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25406_25555 = state_25384__$1;
(statearr_25406_25555[(2)] = inst_25300);

(statearr_25406_25555[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (24))){
var inst_25212 = (state_25384[(10)]);
var state_25384__$1 = state_25384;
var statearr_25407_25556 = state_25384__$1;
(statearr_25407_25556[(2)] = inst_25212);

(statearr_25407_25556[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (55))){
var inst_25210 = (state_25384[(11)]);
var inst_25270 = (state_25384[(14)]);
var inst_25277 = cljs.core.take.call(null,inst_25210,inst_25270);
var state_25384__$1 = state_25384;
var statearr_25408_25557 = state_25384__$1;
(statearr_25408_25557[(2)] = inst_25277);

(statearr_25408_25557[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (85))){
var inst_25355 = (state_25384[(15)]);
var inst_25354 = (state_25384[(2)]);
var inst_25355__$1 = fluree.db.util.async.throw_err.call(null,inst_25354);
var inst_25356 = cljs.core.coll_QMARK_.call(null,inst_25355__$1);
var inst_25357 = (!(inst_25356));
var state_25384__$1 = (function (){var statearr_25409 = state_25384;
(statearr_25409[(15)] = inst_25355__$1);

return statearr_25409;
})();
if(inst_25357){
var statearr_25410_25558 = state_25384__$1;
(statearr_25410_25558[(1)] = (86));

} else {
var statearr_25411_25559 = state_25384__$1;
(statearr_25411_25559[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (39))){
var inst_25229 = (state_25384[(16)]);
var inst_25251 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25252 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25253 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25229,inst_25251,inst_25252);
var state_25384__$1 = state_25384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25384__$1,(42),inst_25253);
} else {
if((state_val_25385 === (88))){
var inst_25377 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25412_25560 = state_25384__$1;
(statearr_25412_25560[(2)] = inst_25377);

(statearr_25412_25560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (46))){
var inst_25211 = (state_25384[(12)]);
var inst_25265 = ((0) < inst_25211);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25265)){
var statearr_25413_25561 = state_25384__$1;
(statearr_25413_25561[(1)] = (49));

} else {
var statearr_25414_25562 = state_25384__$1;
(statearr_25414_25562[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (4))){
var inst_25143 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25415_25563 = state_25384__$1;
(statearr_25415_25563[(2)] = inst_25143);

(statearr_25415_25563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (77))){
var inst_25210 = (state_25384[(11)]);
var inst_25321 = (inst_25210 - (1));
var state_25384__$1 = state_25384;
var statearr_25416_25564 = state_25384__$1;
(statearr_25416_25564[(2)] = inst_25321);

(statearr_25416_25564[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (95))){
var inst_25355 = (state_25384[(15)]);
var state_25384__$1 = state_25384;
var statearr_25417_25565 = state_25384__$1;
(statearr_25417_25565[(2)] = inst_25355);

(statearr_25417_25565[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (54))){
var inst_25275 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25275)){
var statearr_25418_25566 = state_25384__$1;
(statearr_25418_25566[(1)] = (55));

} else {
var statearr_25419_25567 = state_25384__$1;
(statearr_25419_25567[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (92))){
var inst_25355 = (state_25384[(15)]);
var inst_25368 = cljs.core.first.call(null,inst_25355);
var state_25384__$1 = state_25384;
var statearr_25420_25568 = state_25384__$1;
(statearr_25420_25568[(2)] = inst_25368);

(statearr_25420_25568[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (15))){
var inst_25161 = (state_25384[(17)]);
var inst_25169 = (state_25384[(2)]);
var inst_25170 = fluree.db.util.async.throw_err.call(null,inst_25169);
var inst_25171 = [inst_25161];
var inst_25172 = [inst_25170];
var inst_25173 = cljs.core.PersistentHashMap.fromArrays(inst_25171,inst_25172);
var state_25384__$1 = state_25384;
var statearr_25421_25569 = state_25384__$1;
(statearr_25421_25569[(2)] = inst_25173);

(statearr_25421_25569[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (48))){
var inst_25333 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25422_25570 = state_25384__$1;
(statearr_25422_25570[(2)] = inst_25333);

(statearr_25422_25570[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (50))){
var inst_25256 = (state_25384[(18)]);
var state_25384__$1 = state_25384;
var statearr_25423_25571 = state_25384__$1;
(statearr_25423_25571[(2)] = inst_25256);

(statearr_25423_25571[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (75))){
var inst_25225 = (state_25384[(19)]);
var inst_25304 = (state_25384[(20)]);
var inst_25287 = (state_25384[(13)]);
var inst_25222 = (state_25384[(21)]);
var inst_25315 = (state_25384[(2)]);
var inst_25208 = inst_25222;
var inst_25209 = inst_25225;
var inst_25210 = inst_25287;
var inst_25211 = inst_25304;
var inst_25212 = inst_25315;
var state_25384__$1 = (function (){var statearr_25424 = state_25384;
(statearr_25424[(11)] = inst_25210);

(statearr_25424[(12)] = inst_25211);

(statearr_25424[(22)] = inst_25209);

(statearr_25424[(10)] = inst_25212);

(statearr_25424[(23)] = inst_25208);

return statearr_25424;
})();
var statearr_25425_25572 = state_25384__$1;
(statearr_25425_25572[(2)] = null);

(statearr_25425_25572[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (21))){
var inst_25201 = (state_25384[(24)]);
var inst_25189 = (state_25384[(25)]);
var inst_25193 = (state_25384[(26)]);
var inst_25206 = (state_25384[(2)]);
var inst_25207 = cljs.core.PersistentHashMap.EMPTY;
var inst_25208 = inst_25189;
var inst_25209 = inst_25193;
var inst_25210 = inst_25201;
var inst_25211 = inst_25206;
var inst_25212 = inst_25207;
var state_25384__$1 = (function (){var statearr_25426 = state_25384;
(statearr_25426[(11)] = inst_25210);

(statearr_25426[(12)] = inst_25211);

(statearr_25426[(22)] = inst_25209);

(statearr_25426[(10)] = inst_25212);

(statearr_25426[(23)] = inst_25208);

return statearr_25426;
})();
var statearr_25427_25573 = state_25384__$1;
(statearr_25427_25573[(2)] = null);

(statearr_25427_25573[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (31))){
var inst_25211 = (state_25384[(12)]);
var inst_25226 = (state_25384[(27)]);
var inst_25240 = (inst_25211 >= inst_25226);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25240)){
var statearr_25428_25574 = state_25384__$1;
(statearr_25428_25574[(1)] = (33));

} else {
var statearr_25429_25575 = state_25384__$1;
(statearr_25429_25575[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (32))){
var inst_25340 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25430_25576 = state_25384__$1;
(statearr_25430_25576[(2)] = inst_25340);

(statearr_25430_25576[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (40))){
var state_25384__$1 = state_25384;
var statearr_25431_25577 = state_25384__$1;
(statearr_25431_25577[(2)] = null);

(statearr_25431_25577[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (91))){
var inst_25365 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25432_25578 = state_25384__$1;
(statearr_25432_25578[(2)] = inst_25365);

(statearr_25432_25578[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (56))){
var inst_25270 = (state_25384[(14)]);
var state_25384__$1 = state_25384;
var statearr_25433_25579 = state_25384__$1;
(statearr_25433_25579[(2)] = inst_25270);

(statearr_25433_25579[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (33))){
var state_25384__$1 = state_25384;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25434_25580 = state_25384__$1;
(statearr_25434_25580[(1)] = (36));

} else {
var statearr_25435_25581 = state_25384__$1;
(statearr_25435_25581[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (13))){
var inst_25158 = (state_25384[(28)]);
var inst_25189 = (state_25384[(25)]);
var inst_25193 = (state_25384[(26)]);
var inst_25189__$1 = cljs.core.keys.call(null,inst_25158);
var inst_25190 = cljs.core.seq.call(null,inst_25189__$1);
var inst_25191 = cljs.core.first.call(null,inst_25190);
var inst_25192 = cljs.core.next.call(null,inst_25190);
var inst_25193__$1 = cljs.core.vals.call(null,inst_25158);
var inst_25194 = cljs.core.seq.call(null,inst_25193__$1);
var inst_25195 = cljs.core.first.call(null,inst_25194);
var inst_25196 = cljs.core.next.call(null,inst_25194);
var inst_25197 = cljs.core._EQ_.call(null,(0),limit);
var state_25384__$1 = (function (){var statearr_25436 = state_25384;
(statearr_25436[(29)] = inst_25196);

(statearr_25436[(30)] = inst_25192);

(statearr_25436[(25)] = inst_25189__$1);

(statearr_25436[(31)] = inst_25191);

(statearr_25436[(32)] = inst_25195);

(statearr_25436[(26)] = inst_25193__$1);

return statearr_25436;
})();
if(inst_25197){
var statearr_25437_25582 = state_25384__$1;
(statearr_25437_25582[(1)] = (16));

} else {
var statearr_25438_25583 = state_25384__$1;
(statearr_25438_25583[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (22))){
var inst_25209 = (state_25384[(22)]);
var inst_25208 = (state_25384[(23)]);
var inst_25220 = cljs.core.seq.call(null,inst_25208);
var inst_25221 = cljs.core.first.call(null,inst_25220);
var inst_25222 = cljs.core.next.call(null,inst_25220);
var inst_25223 = cljs.core.seq.call(null,inst_25209);
var inst_25224 = cljs.core.first.call(null,inst_25223);
var inst_25225 = cljs.core.next.call(null,inst_25223);
var inst_25226 = cljs.core.count.call(null,inst_25224);
var inst_25227 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25228 = [headers,vars,inst_25224];
var inst_25229 = cljs.core.PersistentHashMap.fromArrays(inst_25227,inst_25228);
var inst_25230 = (inst_25224 == null);
var state_25384__$1 = (function (){var statearr_25439 = state_25384;
(statearr_25439[(19)] = inst_25225);

(statearr_25439[(8)] = inst_25221);

(statearr_25439[(16)] = inst_25229);

(statearr_25439[(27)] = inst_25226);

(statearr_25439[(21)] = inst_25222);

return statearr_25439;
})();
if(cljs.core.truth_(inst_25230)){
var statearr_25440_25584 = state_25384__$1;
(statearr_25440_25584[(1)] = (24));

} else {
var statearr_25441_25585 = state_25384__$1;
(statearr_25441_25585[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (90))){
var inst_25355 = (state_25384[(15)]);
var state_25384__$1 = state_25384;
var statearr_25442_25586 = state_25384__$1;
(statearr_25442_25586[(2)] = inst_25355);

(statearr_25442_25586[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (36))){
var inst_25211 = (state_25384[(12)]);
var inst_25243 = (inst_25211 - (1));
var state_25384__$1 = state_25384;
var statearr_25443_25587 = state_25384__$1;
(statearr_25443_25587[(2)] = inst_25243);

(statearr_25443_25587[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (41))){
var inst_25336 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25444_25588 = state_25384__$1;
(statearr_25444_25588[(2)] = inst_25336);

(statearr_25444_25588[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (89))){
var inst_25355 = (state_25384[(15)]);
var inst_25360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25361 = [inst_25355];
var inst_25362 = (new cljs.core.PersistentVector(null,1,(5),inst_25360,inst_25361,null));
var state_25384__$1 = state_25384;
var statearr_25445_25589 = state_25384__$1;
(statearr_25445_25589[(2)] = inst_25362);

(statearr_25445_25589[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (43))){
var inst_25256 = (state_25384[(18)]);
var inst_25259 = cljs.core.seq.call(null,inst_25256);
var state_25384__$1 = state_25384;
var statearr_25446_25590 = state_25384__$1;
(statearr_25446_25590[(2)] = inst_25259);

(statearr_25446_25590[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (61))){
var state_25384__$1 = state_25384;
var statearr_25447_25591 = state_25384__$1;
(statearr_25447_25591[(2)] = (0));

(statearr_25447_25591[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (29))){
var inst_25237 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25237)){
var statearr_25448_25592 = state_25384__$1;
(statearr_25448_25592[(1)] = (30));

} else {
var statearr_25449_25593 = state_25384__$1;
(statearr_25449_25593[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (44))){
var inst_25257 = (state_25384[(33)]);
var state_25384__$1 = state_25384;
var statearr_25450_25594 = state_25384__$1;
(statearr_25450_25594[(2)] = inst_25257);

(statearr_25450_25594[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (93))){
var state_25384__$1 = state_25384;
var statearr_25451_25595 = state_25384__$1;
(statearr_25451_25595[(1)] = (95));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (6))){
var inst_25150 = (state_25384[(34)]);
var inst_25150__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_25152 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25384__$1 = (function (){var statearr_25453 = state_25384;
(statearr_25453[(35)] = inst_25152);

(statearr_25453[(34)] = inst_25150__$1);

return statearr_25453;
})();
if(cljs.core.truth_(inst_25150__$1)){
var statearr_25454_25596 = state_25384__$1;
(statearr_25454_25596[(1)] = (9));

} else {
var statearr_25455_25597 = state_25384__$1;
(statearr_25455_25597[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (28))){
var inst_25210 = (state_25384[(11)]);
var state_25384__$1 = state_25384;
var statearr_25456_25598 = state_25384__$1;
(statearr_25456_25598[(2)] = inst_25210);

(statearr_25456_25598[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (64))){
var inst_25211 = (state_25384[(12)]);
var inst_25292 = (inst_25211 - (1));
var state_25384__$1 = state_25384;
var statearr_25457_25599 = state_25384__$1;
(statearr_25457_25599[(2)] = inst_25292);

(statearr_25457_25599[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (51))){
var inst_25210 = (state_25384[(11)]);
var inst_25270 = (state_25384[(2)]);
var state_25384__$1 = (function (){var statearr_25458 = state_25384;
(statearr_25458[(14)] = inst_25270);

return statearr_25458;
})();
if(cljs.core.truth_(inst_25210)){
var statearr_25459_25600 = state_25384__$1;
(statearr_25459_25600[(1)] = (52));

} else {
var statearr_25460_25601 = state_25384__$1;
(statearr_25460_25601[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (25))){
var inst_25210 = (state_25384[(11)]);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25210)){
var statearr_25461_25602 = state_25384__$1;
(statearr_25461_25602[(1)] = (27));

} else {
var statearr_25462_25603 = state_25384__$1;
(statearr_25462_25603[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (34))){
var state_25384__$1 = state_25384;
var statearr_25463_25604 = state_25384__$1;
(statearr_25463_25604[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (17))){
var state_25384__$1 = state_25384;
var statearr_25465_25605 = state_25384__$1;
(statearr_25465_25605[(2)] = limit);

(statearr_25465_25605[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (3))){
var inst_25382 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25384__$1,inst_25382);
} else {
if((state_val_25385 === (12))){
var inst_25158 = (state_25384[(28)]);
var inst_25160 = cljs.core.keys.call(null,inst_25158);
var inst_25161 = cljs.core.first.call(null,inst_25160);
var inst_25162 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25163 = cljs.core.vals.call(null,inst_25158);
var inst_25164 = cljs.core.first.call(null,inst_25163);
var inst_25165 = [headers,vars,inst_25164];
var inst_25166 = cljs.core.PersistentHashMap.fromArrays(inst_25162,inst_25165);
var inst_25167 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,inst_25166,select_spec,limit,opts);
var state_25384__$1 = (function (){var statearr_25466 = state_25384;
(statearr_25466[(17)] = inst_25161);

return statearr_25466;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25384__$1,(15),inst_25167);
} else {
if((state_val_25385 === (2))){
var _ = (function (){var statearr_25467 = state_25384;
(statearr_25467[(4)] = cljs.core.cons.call(null,(5),(state_25384[(4)])));

return statearr_25467;
})();
var state_25384__$1 = state_25384;
if(cljs.core.truth_(groupBy)){
var statearr_25468_25606 = state_25384__$1;
(statearr_25468_25606[(1)] = (6));

} else {
var statearr_25469_25607 = state_25384__$1;
(statearr_25469_25607[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (66))){
var inst_25302 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25470_25608 = state_25384__$1;
(statearr_25470_25608[(2)] = inst_25302);

(statearr_25470_25608[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (23))){
var inst_25344 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25471_25609 = state_25384__$1;
(statearr_25471_25609[(2)] = inst_25344);

(statearr_25471_25609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (47))){
var inst_25210 = (state_25384[(11)]);
var inst_25318 = (inst_25210 == null);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25318)){
var statearr_25472_25610 = state_25384__$1;
(statearr_25472_25610[(1)] = (76));

} else {
var statearr_25473_25611 = state_25384__$1;
(statearr_25473_25611[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (35))){
var inst_25338 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25474_25612 = state_25384__$1;
(statearr_25474_25612[(2)] = inst_25338);

(statearr_25474_25612[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (82))){
var state_25384__$1 = state_25384;
var statearr_25475_25613 = state_25384__$1;
(statearr_25475_25613[(2)] = (1));

(statearr_25475_25613[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (76))){
var state_25384__$1 = state_25384;
var statearr_25476_25614 = state_25384__$1;
(statearr_25476_25614[(2)] = null);

(statearr_25476_25614[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (97))){
var inst_25373 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25477_25615 = state_25384__$1;
(statearr_25477_25615[(2)] = inst_25373);

(statearr_25477_25615[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (19))){
var inst_25202 = (state_25384[(36)]);
var state_25384__$1 = state_25384;
var statearr_25478_25616 = state_25384__$1;
(statearr_25478_25616[(2)] = inst_25202);

(statearr_25478_25616[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (57))){
var inst_25210 = (state_25384[(11)]);
var inst_25280 = (state_25384[(2)]);
var inst_25281 = (inst_25210 == null);
var state_25384__$1 = (function (){var statearr_25479 = state_25384;
(statearr_25479[(9)] = inst_25280);

return statearr_25479;
})();
if(cljs.core.truth_(inst_25281)){
var statearr_25480_25617 = state_25384__$1;
(statearr_25480_25617[(1)] = (58));

} else {
var statearr_25481_25618 = state_25384__$1;
(statearr_25481_25618[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (68))){
var state_25384__$1 = state_25384;
var statearr_25482_25619 = state_25384__$1;
(statearr_25482_25619[(2)] = null);

(statearr_25482_25619[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (11))){
var inst_25158 = (state_25384[(2)]);
var state_25384__$1 = (function (){var statearr_25484 = state_25384;
(statearr_25484[(28)] = inst_25158);

return statearr_25484;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25485_25620 = state_25384__$1;
(statearr_25485_25620[(1)] = (12));

} else {
var statearr_25486_25621 = state_25384__$1;
(statearr_25486_25621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (9))){
var inst_25152 = (state_25384[(35)]);
var inst_25150 = (state_25384[(34)]);
var inst_25154 = cljs.core.sorted_map_by.call(null,inst_25150);
var inst_25155 = cljs.core.into.call(null,inst_25154,inst_25152);
var state_25384__$1 = state_25384;
var statearr_25487_25622 = state_25384__$1;
(statearr_25487_25622[(2)] = inst_25155);

(statearr_25487_25622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (5))){
var _ = (function (){var statearr_25488 = state_25384;
(statearr_25488[(4)] = cljs.core.rest.call(null,(state_25384[(4)])));

return statearr_25488;
})();
var state_25384__$1 = state_25384;
var ex25483 = (state_25384__$1[(2)]);
var statearr_25489_25623 = state_25384__$1;
(statearr_25489_25623[(5)] = ex25483);


if((ex25483 instanceof Error)){
var statearr_25490_25624 = state_25384__$1;
(statearr_25490_25624[(1)] = (4));

(statearr_25490_25624[(5)] = null);

} else {
throw ex25483;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (83))){
var state_25384__$1 = state_25384;
var statearr_25491_25625 = state_25384__$1;
(statearr_25491_25625[(2)] = limit);

(statearr_25491_25625[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (14))){
var inst_25346 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25492_25626 = state_25384__$1;
(statearr_25492_25626[(2)] = inst_25346);

(statearr_25492_25626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (45))){
var inst_25262 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
if(cljs.core.truth_(inst_25262)){
var statearr_25493_25627 = state_25384__$1;
(statearr_25493_25627[(1)] = (46));

} else {
var statearr_25494_25628 = state_25384__$1;
(statearr_25494_25628[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (53))){
var inst_25210 = (state_25384[(11)]);
var state_25384__$1 = state_25384;
var statearr_25495_25629 = state_25384__$1;
(statearr_25495_25629[(2)] = inst_25210);

(statearr_25495_25629[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (78))){
var inst_25211 = (state_25384[(12)]);
var inst_25323 = (state_25384[(2)]);
var inst_25324 = (inst_25211 <= (0));
var state_25384__$1 = (function (){var statearr_25496 = state_25384;
(statearr_25496[(37)] = inst_25323);

return statearr_25496;
})();
if(cljs.core.truth_(inst_25324)){
var statearr_25497_25630 = state_25384__$1;
(statearr_25497_25630[(1)] = (79));

} else {
var statearr_25498_25631 = state_25384__$1;
(statearr_25498_25631[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (26))){
var inst_25342 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25499_25632 = state_25384__$1;
(statearr_25499_25632[(2)] = inst_25342);

(statearr_25499_25632[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (16))){
var state_25384__$1 = state_25384;
var statearr_25500_25633 = state_25384__$1;
(statearr_25500_25633[(2)] = null);

(statearr_25500_25633[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (81))){
var inst_25225 = (state_25384[(19)]);
var inst_25256 = (state_25384[(18)]);
var inst_25221 = (state_25384[(8)]);
var inst_25212 = (state_25384[(10)]);
var inst_25323 = (state_25384[(37)]);
var inst_25222 = (state_25384[(21)]);
var inst_25329 = (state_25384[(2)]);
var inst_25330 = cljs.core.assoc.call(null,inst_25212,inst_25221,inst_25256);
var inst_25208 = inst_25222;
var inst_25209 = inst_25225;
var inst_25210 = inst_25323;
var inst_25211 = inst_25329;
var inst_25212__$1 = inst_25330;
var state_25384__$1 = (function (){var statearr_25503 = state_25384;
(statearr_25503[(11)] = inst_25210);

(statearr_25503[(12)] = inst_25211);

(statearr_25503[(22)] = inst_25209);

(statearr_25503[(10)] = inst_25212__$1);

(statearr_25503[(23)] = inst_25208);

return statearr_25503;
})();
var statearr_25504_25634 = state_25384__$1;
(statearr_25504_25634[(2)] = null);

(statearr_25504_25634[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (79))){
var state_25384__$1 = state_25384;
var statearr_25505_25635 = state_25384__$1;
(statearr_25505_25635[(2)] = (0));

(statearr_25505_25635[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (38))){
var inst_25225 = (state_25384[(19)]);
var inst_25210 = (state_25384[(11)]);
var inst_25212 = (state_25384[(10)]);
var inst_25222 = (state_25384[(21)]);
var inst_25247 = (state_25384[(2)]);
var tmp25501 = inst_25210;
var tmp25502 = inst_25212;
var inst_25208 = inst_25222;
var inst_25209 = inst_25225;
var inst_25210__$1 = tmp25501;
var inst_25211 = inst_25247;
var inst_25212__$1 = tmp25502;
var state_25384__$1 = (function (){var statearr_25506 = state_25384;
(statearr_25506[(11)] = inst_25210__$1);

(statearr_25506[(12)] = inst_25211);

(statearr_25506[(22)] = inst_25209);

(statearr_25506[(10)] = inst_25212__$1);

(statearr_25506[(23)] = inst_25208);

return statearr_25506;
})();
var statearr_25507_25636 = state_25384__$1;
(statearr_25507_25636[(2)] = null);

(statearr_25507_25636[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (87))){
var state_25384__$1 = state_25384;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25508_25637 = state_25384__$1;
(statearr_25508_25637[(1)] = (92));

} else {
var statearr_25509_25638 = state_25384__$1;
(statearr_25509_25638[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (30))){
var inst_25212 = (state_25384[(10)]);
var state_25384__$1 = state_25384;
var statearr_25510_25639 = state_25384__$1;
(statearr_25510_25639[(2)] = inst_25212);

(statearr_25510_25639[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (73))){
var inst_25212 = (state_25384[(10)]);
var state_25384__$1 = state_25384;
var statearr_25511_25640 = state_25384__$1;
(statearr_25511_25640[(2)] = inst_25212);

(statearr_25511_25640[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (96))){
var state_25384__$1 = state_25384;
var statearr_25512_25641 = state_25384__$1;
(statearr_25512_25641[(2)] = null);

(statearr_25512_25641[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (10))){
var inst_25152 = (state_25384[(35)]);
var state_25384__$1 = state_25384;
var statearr_25513_25642 = state_25384__$1;
(statearr_25513_25642[(2)] = inst_25152);

(statearr_25513_25642[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (18))){
var inst_25202 = (state_25384[(36)]);
var inst_25201 = (state_25384[(2)]);
var inst_25202__$1 = offset;
var state_25384__$1 = (function (){var statearr_25514 = state_25384;
(statearr_25514[(24)] = inst_25201);

(statearr_25514[(36)] = inst_25202__$1);

return statearr_25514;
})();
if(cljs.core.truth_(inst_25202__$1)){
var statearr_25515_25643 = state_25384__$1;
(statearr_25515_25643[(1)] = (19));

} else {
var statearr_25516_25644 = state_25384__$1;
(statearr_25516_25644[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (52))){
var inst_25210 = (state_25384[(11)]);
var inst_25272 = ((0) < inst_25210);
var state_25384__$1 = state_25384;
var statearr_25517_25645 = state_25384__$1;
(statearr_25517_25645[(2)] = inst_25272);

(statearr_25517_25645[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (67))){
var inst_25280 = (state_25384[(9)]);
var inst_25211 = (state_25384[(12)]);
var inst_25226 = (state_25384[(27)]);
var inst_25295 = cljs.core.count.call(null,inst_25280);
var inst_25296 = (inst_25226 - inst_25295);
var inst_25297 = (inst_25211 - inst_25296);
var state_25384__$1 = state_25384;
var statearr_25518_25646 = state_25384__$1;
(statearr_25518_25646[(2)] = inst_25297);

(statearr_25518_25646[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (71))){
var inst_25280 = (state_25384[(9)]);
var inst_25308 = cljs.core.empty_QMARK_.call(null,inst_25280);
var state_25384__$1 = state_25384;
var statearr_25519_25647 = state_25384__$1;
(statearr_25519_25647[(2)] = inst_25308);

(statearr_25519_25647[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (42))){
var inst_25257 = (state_25384[(33)]);
var inst_25256 = (state_25384[(18)]);
var inst_25255 = (state_25384[(2)]);
var inst_25256__$1 = fluree.db.util.async.throw_err.call(null,inst_25255);
var inst_25257__$1 = cljs.core.coll_QMARK_.call(null,inst_25256__$1);
var state_25384__$1 = (function (){var statearr_25520 = state_25384;
(statearr_25520[(33)] = inst_25257__$1);

(statearr_25520[(18)] = inst_25256__$1);

return statearr_25520;
})();
if(inst_25257__$1){
var statearr_25521_25648 = state_25384__$1;
(statearr_25521_25648[(1)] = (43));

} else {
var statearr_25522_25649 = state_25384__$1;
(statearr_25522_25649[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (80))){
var inst_25211 = (state_25384[(12)]);
var inst_25327 = (inst_25211 - (1));
var state_25384__$1 = state_25384;
var statearr_25523_25650 = state_25384__$1;
(statearr_25523_25650[(2)] = inst_25327);

(statearr_25523_25650[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (37))){
var inst_25211 = (state_25384[(12)]);
var inst_25226 = (state_25384[(27)]);
var inst_25245 = (inst_25211 - inst_25226);
var state_25384__$1 = state_25384;
var statearr_25524_25651 = state_25384__$1;
(statearr_25524_25651[(2)] = inst_25245);

(statearr_25524_25651[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (63))){
var inst_25280 = (state_25384[(9)]);
var inst_25305 = (state_25384[(7)]);
var inst_25304 = (state_25384[(2)]);
var inst_25305__$1 = (inst_25280 == null);
var state_25384__$1 = (function (){var statearr_25525 = state_25384;
(statearr_25525[(7)] = inst_25305__$1);

(statearr_25525[(20)] = inst_25304);

return statearr_25525;
})();
if(cljs.core.truth_(inst_25305__$1)){
var statearr_25526_25652 = state_25384__$1;
(statearr_25526_25652[(1)] = (70));

} else {
var statearr_25527_25653 = state_25384__$1;
(statearr_25527_25653[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (94))){
var inst_25375 = (state_25384[(2)]);
var state_25384__$1 = state_25384;
var statearr_25528_25654 = state_25384__$1;
(statearr_25528_25654[(2)] = inst_25375);

(statearr_25528_25654[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (8))){
var inst_25379 = (state_25384[(2)]);
var _ = (function (){var statearr_25529 = state_25384;
(statearr_25529[(4)] = cljs.core.rest.call(null,(state_25384[(4)])));

return statearr_25529;
})();
var state_25384__$1 = state_25384;
var statearr_25530_25655 = state_25384__$1;
(statearr_25530_25655[(2)] = inst_25379);

(statearr_25530_25655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (49))){
var inst_25256 = (state_25384[(18)]);
var inst_25211 = (state_25384[(12)]);
var inst_25267 = cljs.core.drop.call(null,inst_25211,inst_25256);
var state_25384__$1 = state_25384;
var statearr_25531_25656 = state_25384__$1;
(statearr_25531_25656[(2)] = inst_25267);

(statearr_25531_25656[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25385 === (84))){
var inst_25351 = (state_25384[(2)]);
var inst_25352 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,fuel,max_fuel,res,select_spec,inst_25351,opts);
var state_25384__$1 = state_25384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25384__$1,(85),inst_25352);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0 = (function (){
var statearr_25532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25532[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__);

(statearr_25532[(1)] = (1));

return statearr_25532;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1 = (function (state_25384){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_25384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25533){var ex__2744__auto__ = e25533;
var statearr_25534_25657 = state_25384;
(statearr_25534_25657[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_25384[(4)]))){
var statearr_25535_25658 = state_25384;
(statearr_25535_25658[(1)] = cljs.core.first.call(null,(state_25384[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25659 = state_25384;
state_25384 = G__25659;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__ = function(state_25384){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1.call(this,state_25384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25536 = f__2764__auto__.call(null);
(statearr_25536[(6)] = c__2763__auto__);

return statearr_25536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25662,opts){
var map__25663 = p__25662;
var map__25663__$1 = cljs.core.__destructure_map.call(null,map__25663);
var selectOne = cljs.core.get.call(null,map__25663__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25663__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25663__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25663__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4253__auto__ = selectOne;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = select;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
var or__4253__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4253__auto____$2)){
return or__4253__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25660_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25660_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25661_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25661_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4253__auto__ = typeof orderBy === 'string';
if(or__4253__auto__){
return or__4253__auto__;
} else {
var and__4251__auto__ = cljs.core.vector_QMARK_.call(null,orderBy);
if(and__4251__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return and__4251__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (100);
}
})(),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4253__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4253__auto__ = selectDistinct;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25664,p__25665){
var map__25666 = p__25664;
var map__25666__$1 = cljs.core.__destructure_map.call(null,map__25666);
var query_map = map__25666__$1;
var construct = cljs.core.get.call(null,map__25666__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25667 = p__25665;
var map__25667__$1 = cljs.core.__destructure_map.call(null,map__25667);
var where_result = map__25667__$1;
var headers = cljs.core.get.call(null,map__25667__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25667__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25668 = cljs.core.map.call(null,(function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25668,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25668,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25668,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_25701){
var state_val_25702 = (state_25701[(1)]);
if((state_val_25702 === (7))){
var inst_25680 = (state_25701[(7)]);
var state_25701__$1 = state_25701;
var statearr_25703_25726 = state_25701__$1;
(statearr_25703_25726[(2)] = inst_25680);

(statearr_25703_25726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (1))){
var state_25701__$1 = state_25701;
var statearr_25704_25727 = state_25701__$1;
(statearr_25704_25727[(2)] = null);

(statearr_25704_25727[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (4))){
var inst_25671 = (state_25701[(2)]);
var state_25701__$1 = state_25701;
var statearr_25705_25728 = state_25701__$1;
(statearr_25705_25728[(2)] = inst_25671);

(statearr_25705_25728[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (13))){
var inst_25690 = (state_25701[(2)]);
var inst_25691 = fluree.db.util.async.throw_err.call(null,inst_25690);
var state_25701__$1 = state_25701;
var statearr_25706_25729 = state_25701__$1;
(statearr_25706_25729[(2)] = inst_25691);

(statearr_25706_25729[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (6))){
var inst_25680 = (state_25701[(7)]);
var inst_25679 = (state_25701[(2)]);
var inst_25680__$1 = fluree.db.util.async.throw_err.call(null,inst_25679);
var inst_25681 = fluree.db.util.core.exception_QMARK_.call(null,inst_25680__$1);
var state_25701__$1 = (function (){var statearr_25707 = state_25701;
(statearr_25707[(7)] = inst_25680__$1);

return statearr_25707;
})();
if(inst_25681){
var statearr_25708_25730 = state_25701__$1;
(statearr_25708_25730[(1)] = (7));

} else {
var statearr_25709_25731 = state_25701__$1;
(statearr_25709_25731[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (3))){
var inst_25699 = (state_25701[(2)]);
var state_25701__$1 = state_25701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25701__$1,inst_25699);
} else {
if((state_val_25702 === (12))){
var inst_25694 = (state_25701[(2)]);
var state_25701__$1 = state_25701;
var statearr_25710_25732 = state_25701__$1;
(statearr_25710_25732[(2)] = inst_25694);

(statearr_25710_25732[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (2))){
var _ = (function (){var statearr_25711 = state_25701;
(statearr_25711[(4)] = cljs.core.cons.call(null,(5),(state_25701[(4)])));

return statearr_25711;
})();
var inst_25677 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25701__$1 = state_25701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25701__$1,(6),inst_25677);
} else {
if((state_val_25702 === (11))){
var state_25701__$1 = state_25701;
var statearr_25713_25733 = state_25701__$1;
(statearr_25713_25733[(2)] = null);

(statearr_25713_25733[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (9))){
var inst_25696 = (state_25701[(2)]);
var _ = (function (){var statearr_25714 = state_25701;
(statearr_25714[(4)] = cljs.core.rest.call(null,(state_25701[(4)])));

return statearr_25714;
})();
var state_25701__$1 = state_25701;
var statearr_25715_25734 = state_25701__$1;
(statearr_25715_25734[(2)] = inst_25696);

(statearr_25715_25734[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (5))){
var _ = (function (){var statearr_25716 = state_25701;
(statearr_25716[(4)] = cljs.core.rest.call(null,(state_25701[(4)])));

return statearr_25716;
})();
var state_25701__$1 = state_25701;
var ex25712 = (state_25701__$1[(2)]);
var statearr_25717_25735 = state_25701__$1;
(statearr_25717_25735[(5)] = ex25712);


if((ex25712 instanceof Error)){
var statearr_25718_25736 = state_25701__$1;
(statearr_25718_25736[(1)] = (4));

(statearr_25718_25736[(5)] = null);

} else {
throw ex25712;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25702 === (10))){
var inst_25680 = (state_25701[(7)]);
var inst_25685 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25680);
var inst_25686 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25680);
var inst_25687 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25685,inst_25686,query_map,opts);
var inst_25688 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,fuel,max_fuel,inst_25680,inst_25687,opts);
var state_25701__$1 = state_25701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25701__$1,(13),inst_25688);
} else {
if((state_val_25702 === (8))){
var state_25701__$1 = state_25701;
var statearr_25719_25737 = state_25701__$1;
(statearr_25719_25737[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0 = (function (){
var statearr_25721 = [null,null,null,null,null,null,null,null];
(statearr_25721[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__);

(statearr_25721[(1)] = (1));

return statearr_25721;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1 = (function (state_25701){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_25701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e25722){var ex__2744__auto__ = e25722;
var statearr_25723_25738 = state_25701;
(statearr_25723_25738[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_25701[(4)]))){
var statearr_25724_25739 = state_25701;
(statearr_25724_25739[(1)] = cljs.core.first.call(null,(state_25701[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25740 = state_25701;
state_25701 = G__25740;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__ = function(state_25701){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1.call(this,state_25701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_25725 = f__2764__auto__.call(null);
(statearr_25725[(6)] = c__2763__auto__);

return statearr_25725;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.call(null,"Running query:",cljs.core.pr_str.call(null,query_map));

var map__25741 = query_map;
var map__25741__$1 = cljs.core.__destructure_map.call(null,map__25741);
var select = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25741__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25742 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4253__auto__ = offset;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__25742,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25742;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.truth_((function (){var or__4253__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_26098){
var state_val_26099 = (state_26098[(1)]);
if((state_val_26099 === (121))){
var inst_26059 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26100_26295 = state_26098__$1;
(statearr_26100_26295[(2)] = inst_26059);

(statearr_26100_26295[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (65))){
var inst_25936 = typeof from === 'string';
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25936)){
var statearr_26101_26296 = state_26098__$1;
(statearr_26101_26296[(1)] = (72));

} else {
var statearr_26102_26297 = state_26098__$1;
(statearr_26102_26297[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (70))){
var inst_25802 = (state_26098[(7)]);
var inst_25804 = (state_26098[(8)]);
var inst_25929 = (state_26098[(2)]);
var inst_25930 = fluree.db.util.async.throw_err.call(null,inst_25929);
var inst_25931 = fluree.db.query.fql.flake_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_25930);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(71),inst_25931);
} else {
if((state_val_26099 === (62))){
var inst_25909 = (state_26098[(9)]);
var state_26098__$1 = state_26098;
var statearr_26103_26298 = state_26098__$1;
(statearr_26103_26298[(2)] = inst_25909);

(statearr_26103_26298[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (74))){
var inst_26065 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26104_26299 = state_26098__$1;
(statearr_26104_26299[(2)] = inst_26065);

(statearr_26104_26299[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (110))){
var inst_26000 = (state_26098[(10)]);
var state_26098__$1 = state_26098;
var statearr_26105_26300 = state_26098__$1;
(statearr_26105_26300[(2)] = inst_26000);

(statearr_26105_26300[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (130))){
var inst_26085 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26106_26301 = state_26098__$1;
(statearr_26106_26301[(2)] = inst_26085);

(statearr_26106_26301[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (128))){
var inst_26076 = (state_26098[(11)]);
var inst_26081 = fluree.db.util.core.exception_QMARK_.call(null,inst_26076);
var inst_26082 = (!(inst_26081));
var state_26098__$1 = state_26098;
var statearr_26107_26302 = state_26098__$1;
(statearr_26107_26302[(2)] = inst_26082);

(statearr_26107_26302[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (7))){
var inst_25772 = (state_26098[(12)]);
var inst_25772__$1 = selectOne;
var state_26098__$1 = (function (){var statearr_26108 = state_26098;
(statearr_26108[(12)] = inst_25772__$1);

return statearr_26108;
})();
if(cljs.core.truth_(inst_25772__$1)){
var statearr_26109_26303 = state_26098__$1;
(statearr_26109_26303[(1)] = (9));

} else {
var statearr_26110_26304 = state_26098__$1;
(statearr_26110_26304[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (59))){
var inst_25887 = (state_26098[(13)]);
var inst_25802 = (state_26098[(7)]);
var inst_25804 = (state_26098[(8)]);
var inst_25792 = (state_26098[(14)]);
var inst_25901 = (state_26098[(2)]);
var inst_25902 = fluree.db.util.async.throw_err.call(null,inst_25901);
var inst_25903 = cljs.core.sequence.call(null,inst_25887,inst_25902);
var inst_25904 = fluree.db.query.fql.subject_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_25903,inst_25792);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(60),inst_25904);
} else {
if((state_val_26099 === (86))){
var inst_25802 = (state_26098[(7)]);
var inst_25804 = (state_26098[(8)]);
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25969 = (state_26098[(2)]);
var inst_25970 = fluree.db.query.fql.subject_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_25969,inst_25792,inst_25794);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(87),inst_25970);
} else {
if((state_val_26099 === (20))){
var inst_25836 = (state_26098[(2)]);
var inst_25837 = cljs.core.nth.call(null,inst_25836,(0),null);
var inst_25838 = cljs.core.nth.call(null,inst_25836,(1),null);
var inst_25839 = typeof where === 'string';
var state_26098__$1 = (function (){var statearr_26111 = state_26098;
(statearr_26111[(16)] = inst_25838);

(statearr_26111[(17)] = inst_25837);

return statearr_26111;
})();
if(cljs.core.truth_(inst_25839)){
var statearr_26112_26305 = state_26098__$1;
(statearr_26112_26305[(1)] = (30));

} else {
var statearr_26113_26306 = state_26098__$1;
(statearr_26113_26306[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (72))){
var inst_25791 = (state_26098[(18)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25791)){
var statearr_26114_26307 = state_26098__$1;
(statearr_26114_26307[(1)] = (75));

} else {
var statearr_26115_26308 = state_26098__$1;
(statearr_26115_26308[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (58))){
var inst_25895 = (state_26098[(2)]);
var inst_25896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25897 = [from];
var inst_25898 = (new cljs.core.PersistentVector(null,1,(5),inst_25896,inst_25897,null));
var inst_25899 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25898,inst_25895);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(59),inst_25899);
} else {
if((state_val_26099 === (60))){
var inst_25906 = (state_26098[(2)]);
var inst_25907 = fluree.db.util.async.throw_err.call(null,inst_25906);
var state_26098__$1 = state_26098;
var statearr_26116_26309 = state_26098__$1;
(statearr_26116_26309[(2)] = inst_25907);

(statearr_26116_26309[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (27))){
var inst_25821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25822 = [null,null];
var inst_25823 = (new cljs.core.PersistentVector(null,2,(5),inst_25821,inst_25822,null));
var state_26098__$1 = state_26098;
var statearr_26117_26310 = state_26098__$1;
(statearr_26117_26310[(2)] = inst_25823);

(statearr_26117_26310[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (1))){
var state_26098__$1 = state_26098;
var statearr_26118_26311 = state_26098__$1;
(statearr_26118_26311[(2)] = null);

(statearr_26118_26311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (69))){
var inst_25926 = (state_26098[(2)]);
var inst_25927 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25926);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(70),inst_25927);
} else {
if((state_val_26099 === (101))){
var inst_26032 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26119_26312 = state_26098__$1;
(statearr_26119_26312[(2)] = inst_26032);

(statearr_26119_26312[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (24))){
var inst_25791 = (state_26098[(18)]);
var inst_25816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25817 = [inst_25791,"ASC"];
var inst_25818 = (new cljs.core.PersistentVector(null,2,(5),inst_25816,inst_25817,null));
var state_26098__$1 = state_26098;
var statearr_26120_26313 = state_26098__$1;
(statearr_26120_26313[(2)] = inst_25818);

(statearr_26120_26313[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (102))){
var inst_26006 = (state_26098[(19)]);
var state_26098__$1 = state_26098;
var statearr_26121_26314 = state_26098__$1;
(statearr_26121_26314[(2)] = inst_26006);

(statearr_26121_26314[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (55))){
var inst_25791 = (state_26098[(18)]);
var inst_25887 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26122 = state_26098;
(statearr_26122[(13)] = inst_25887);

return statearr_26122;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26123_26315 = state_26098__$1;
(statearr_26123_26315[(1)] = (56));

} else {
var statearr_26124_26316 = state_26098__$1;
(statearr_26124_26316[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (85))){
var inst_25961 = (state_26098[(20)]);
var inst_25965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25966 = [inst_25961];
var inst_25967 = (new cljs.core.PersistentVector(null,1,(5),inst_25965,inst_25966,null));
var state_26098__$1 = state_26098;
var statearr_26125_26317 = state_26098__$1;
(statearr_26125_26317[(2)] = inst_25967);

(statearr_26125_26317[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (39))){
var inst_25792 = (state_26098[(14)]);
var state_26098__$1 = state_26098;
var statearr_26126_26318 = state_26098__$1;
(statearr_26126_26318[(2)] = inst_25792);

(statearr_26126_26318[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (88))){
var inst_25975 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26098__$1 = state_26098;
var statearr_26127_26319 = state_26098__$1;
(statearr_26127_26319[(2)] = inst_25975);

(statearr_26127_26319[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (46))){
var inst_25872 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25872)){
var statearr_26128_26320 = state_26098__$1;
(statearr_26128_26320[(1)] = (47));

} else {
var statearr_26129_26321 = state_26098__$1;
(statearr_26129_26321[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (4))){
var inst_25759 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26130_26322 = state_26098__$1;
(statearr_26130_26322[(2)] = inst_25759);

(statearr_26130_26322[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (77))){
var inst_25945 = (state_26098[(2)]);
var inst_25946 = fluree.db.query.range.collection.call(null,db,from,inst_25945);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(78),inst_25946);
} else {
if((state_val_26099 === (106))){
var state_26098__$1 = state_26098;
var statearr_26131_26323 = state_26098__$1;
(statearr_26131_26323[(2)] = null);

(statearr_26131_26323[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (119))){
var inst_26051 = cljs.core.pr_str.call(null,query_map);
var inst_26052 = ["Invalid 'from' in query:",inst_26051].join('');
var inst_26053 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26054 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_26055 = cljs.core.PersistentHashMap.fromArrays(inst_26053,inst_26054);
var inst_26056 = cljs.core.ex_info.call(null,inst_26052,inst_26055);
var state_26098__$1 = state_26098;
var statearr_26132_26324 = state_26098__$1;
(statearr_26132_26324[(2)] = inst_26056);

(statearr_26132_26324[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (95))){
var state_26098__$1 = state_26098;
var statearr_26133_26325 = state_26098__$1;
(statearr_26133_26325[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (54))){
var inst_25881 = (state_26098[(21)]);
var state_26098__$1 = state_26098;
var statearr_26135_26326 = state_26098__$1;
(statearr_26135_26326[(2)] = inst_25881);

(statearr_26135_26326[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (92))){
var inst_25980 = (state_26098[(22)]);
var state_26098__$1 = state_26098;
var statearr_26136_26327 = state_26098__$1;
(statearr_26136_26327[(2)] = inst_25980);

(statearr_26136_26327[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (104))){
var inst_26024 = (state_26098[(23)]);
var inst_26024__$1 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26137 = state_26098;
(statearr_26137[(23)] = inst_26024__$1);

return statearr_26137;
})();
if(cljs.core.truth_(inst_26024__$1)){
var statearr_26138_26328 = state_26098__$1;
(statearr_26138_26328[(1)] = (109));

} else {
var statearr_26139_26329 = state_26098__$1;
(statearr_26139_26329[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (15))){
var inst_25793 = (state_26098[(24)]);
var inst_25795 = (state_26098[(25)]);
var inst_25799 = cljs.core.assoc.call(null,inst_25795,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25793);
var state_26098__$1 = state_26098;
var statearr_26140_26330 = state_26098__$1;
(statearr_26140_26330[(2)] = inst_25799);

(statearr_26140_26330[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (48))){
var inst_25909 = (state_26098[(9)]);
var inst_25909__$1 = typeof from === 'string';
var state_26098__$1 = (function (){var statearr_26141 = state_26098;
(statearr_26141[(9)] = inst_25909__$1);

return statearr_26141;
})();
if(cljs.core.truth_(inst_25909__$1)){
var statearr_26142_26331 = state_26098__$1;
(statearr_26142_26331[(1)] = (61));

} else {
var statearr_26143_26332 = state_26098__$1;
(statearr_26143_26332[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (50))){
var inst_25875 = (state_26098[(26)]);
var inst_25877 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25878 = cljs.core.comp.call(null,inst_25875,inst_25877);
var state_26098__$1 = state_26098;
var statearr_26144_26333 = state_26098__$1;
(statearr_26144_26333[(2)] = inst_25878);

(statearr_26144_26333[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (116))){
var state_26098__$1 = state_26098;
var statearr_26145_26334 = state_26098__$1;
(statearr_26145_26334[(2)] = null);

(statearr_26145_26334[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (75))){
var inst_25939 = cljs.core.PersistentHashMap.EMPTY;
var state_26098__$1 = state_26098;
var statearr_26146_26335 = state_26098__$1;
(statearr_26146_26335[(2)] = inst_25939);

(statearr_26146_26335[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (99))){
var inst_26000 = (state_26098[(10)]);
var state_26098__$1 = state_26098;
var statearr_26147_26336 = state_26098__$1;
(statearr_26147_26336[(2)] = inst_26000);

(statearr_26147_26336[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (21))){
var inst_25791 = (state_26098[(18)]);
var inst_25808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25809 = cljs.core.second.call(null,inst_25791);
var inst_25810 = cljs.core.first.call(null,inst_25791);
var inst_25811 = [inst_25809,inst_25810];
var inst_25812 = (new cljs.core.PersistentVector(null,2,(5),inst_25808,inst_25811,null));
var state_26098__$1 = state_26098;
var statearr_26148_26337 = state_26098__$1;
(statearr_26148_26337[(2)] = inst_25812);

(statearr_26148_26337[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (31))){
var inst_25866 = (state_26098[(27)]);
var inst_25866__$1 = typeof from === 'string';
var state_26098__$1 = (function (){var statearr_26149 = state_26098;
(statearr_26149[(27)] = inst_25866__$1);

return statearr_26149;
})();
if(cljs.core.truth_(inst_25866__$1)){
var statearr_26150_26338 = state_26098__$1;
(statearr_26150_26338[(1)] = (44));

} else {
var statearr_26151_26339 = state_26098__$1;
(statearr_26151_26339[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (113))){
var state_26098__$1 = state_26098;
var statearr_26152_26340 = state_26098__$1;
(statearr_26152_26340[(2)] = null);

(statearr_26152_26340[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (32))){
var inst_25837 = (state_26098[(17)]);
var inst_26071 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26153 = state_26098;
(statearr_26153[(28)] = inst_26071);

return statearr_26153;
})();
if(cljs.core.truth_(inst_25837)){
var statearr_26154_26341 = state_26098__$1;
(statearr_26154_26341[(1)] = (122));

} else {
var statearr_26155_26342 = state_26098__$1;
(statearr_26155_26342[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (40))){
var inst_25791 = (state_26098[(18)]);
var inst_25856 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26156 = state_26098;
(statearr_26156[(29)] = inst_25856);

return statearr_26156;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26157_26343 = state_26098__$1;
(statearr_26157_26343[(1)] = (41));

} else {
var statearr_26158_26344 = state_26098__$1;
(statearr_26158_26344[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (129))){
var inst_26079 = (state_26098[(30)]);
var state_26098__$1 = state_26098;
var statearr_26159_26345 = state_26098__$1;
(statearr_26159_26345[(2)] = inst_26079);

(statearr_26159_26345[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (91))){
var inst_25982 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var state_26098__$1 = state_26098;
var statearr_26160_26346 = state_26098__$1;
(statearr_26160_26346[(2)] = inst_25982);

(statearr_26160_26346[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (117))){
var inst_25794 = (state_26098[(15)]);
var state_26098__$1 = state_26098;
var statearr_26161_26347 = state_26098__$1;
(statearr_26161_26347[(2)] = inst_25794);

(statearr_26161_26347[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (108))){
var inst_26021 = (state_26098[(2)]);
var inst_26022 = fluree.db.util.async.throw_err.call(null,inst_26021);
var state_26098__$1 = state_26098;
var statearr_26162_26348 = state_26098__$1;
(statearr_26162_26348[(2)] = inst_26022);

(statearr_26162_26348[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (56))){
var inst_25889 = cljs.core.PersistentHashMap.EMPTY;
var state_26098__$1 = state_26098;
var statearr_26163_26349 = state_26098__$1;
(statearr_26163_26349[(2)] = inst_25889);

(statearr_26163_26349[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (33))){
var state_26098__$1 = state_26098;
var statearr_26164_26350 = state_26098__$1;
(statearr_26164_26350[(2)] = from);

(statearr_26164_26350[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (13))){
var inst_25778 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25779 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25780 = cljs.core.PersistentHashMap.fromArrays(inst_25778,inst_25779);
var inst_25781 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25780);
var inst_25782 = (function(){throw inst_25781})();
var state_26098__$1 = state_26098;
var statearr_26165_26351 = state_26098__$1;
(statearr_26165_26351[(2)] = inst_25782);

(statearr_26165_26351[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (22))){
var inst_25791 = (state_26098[(18)]);
var inst_25814 = typeof inst_25791 === 'string';
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25814)){
var statearr_26166_26352 = state_26098__$1;
(statearr_26166_26352[(1)] = (24));

} else {
var statearr_26167_26353 = state_26098__$1;
(statearr_26167_26353[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (90))){
var inst_25973 = (state_26098[(31)]);
var inst_25978 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26168 = state_26098;
(statearr_26168[(32)] = inst_25978);

return statearr_26168;
})();
var statearr_26169_26354 = state_26098__$1;
(statearr_26169_26354[(2)] = inst_25973);

(statearr_26169_26354[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (109))){
var inst_26024 = (state_26098[(23)]);
var inst_26000 = (state_26098[(10)]);
var inst_26026 = cljs.core.conj.call(null,inst_26000,inst_26024);
var state_26098__$1 = state_26098;
var statearr_26170_26355 = state_26098__$1;
(statearr_26170_26355[(2)] = inst_26026);

(statearr_26170_26355[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (36))){
var inst_25791 = (state_26098[(18)]);
var inst_25851 = (state_26098[(2)]);
var inst_25852 = fluree.db.util.async.throw_err.call(null,inst_25851);
var state_26098__$1 = (function (){var statearr_26171 = state_26098;
(statearr_26171[(33)] = inst_25852);

return statearr_26171;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26172_26356 = state_26098__$1;
(statearr_26172_26356[(1)] = (38));

} else {
var statearr_26173_26357 = state_26098__$1;
(statearr_26173_26357[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (41))){
var state_26098__$1 = state_26098;
var statearr_26174_26358 = state_26098__$1;
(statearr_26174_26358[(2)] = null);

(statearr_26174_26358[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (118))){
var inst_26040 = (state_26098[(34)]);
var inst_25802 = (state_26098[(7)]);
var inst_26036 = (state_26098[(35)]);
var inst_25804 = (state_26098[(8)]);
var inst_26044 = (state_26098[(2)]);
var inst_26045 = fluree.db.query.fql.subject_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_26036,inst_26040,inst_26044);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(112),inst_26045);
} else {
if((state_val_26099 === (89))){
var state_26098__$1 = state_26098;
var statearr_26175_26359 = state_26098__$1;
(statearr_26175_26359[(2)] = null);

(statearr_26175_26359[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (100))){
var inst_26006 = (state_26098[(19)]);
var inst_26011 = cljs.core.int_QMARK_.call(null,inst_26006);
var state_26098__$1 = state_26098;
if(inst_26011){
var statearr_26176_26360 = state_26098__$1;
(statearr_26176_26360[(1)] = (102));

} else {
var statearr_26177_26361 = state_26098__$1;
(statearr_26177_26361[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (131))){
var inst_26076 = (state_26098[(11)]);
var inst_26090 = cljs.core.first.call(null,inst_26076);
var state_26098__$1 = state_26098;
var statearr_26178_26362 = state_26098__$1;
(statearr_26178_26362[(2)] = inst_26090);

(statearr_26178_26362[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (122))){
var inst_26071 = (state_26098[(28)]);
var inst_25838 = (state_26098[(16)]);
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25837 = (state_26098[(17)]);
var inst_26073 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25837,inst_25838,inst_25794,inst_25792,inst_26071);
var state_26098__$1 = state_26098;
var statearr_26179_26363 = state_26098__$1;
(statearr_26179_26363[(2)] = inst_26073);

(statearr_26179_26363[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (43))){
var inst_25802 = (state_26098[(7)]);
var inst_25852 = (state_26098[(33)]);
var inst_25804 = (state_26098[(8)]);
var inst_25856 = (state_26098[(29)]);
var inst_25860 = (state_26098[(2)]);
var inst_25861 = fluree.db.query.fql.subject_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_25852,inst_25856,inst_25860);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(37),inst_25861);
} else {
if((state_val_26099 === (61))){
var inst_25911 = ["_tx",null,"_block",null];
var inst_25912 = (new cljs.core.PersistentArrayMap(null,2,inst_25911,null));
var inst_25913 = (new cljs.core.PersistentHashSet(null,inst_25912,null));
var inst_25914 = inst_25913.call(null,from);
var state_26098__$1 = state_26098;
var statearr_26180_26364 = state_26098__$1;
(statearr_26180_26364[(2)] = inst_25914);

(statearr_26180_26364[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (29))){
var inst_25826 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26181_26365 = state_26098__$1;
(statearr_26181_26365[(2)] = inst_25826);

(statearr_26181_26365[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (44))){
var inst_25868 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25869 = clojure.string.includes_QMARK_.call(null,inst_25868,"/");
var state_26098__$1 = state_26098;
var statearr_26182_26366 = state_26098__$1;
(statearr_26182_26366[(2)] = inst_25869);

(statearr_26182_26366[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (93))){
var inst_25985 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25985)){
var statearr_26183_26367 = state_26098__$1;
(statearr_26183_26367[(1)] = (94));

} else {
var statearr_26184_26368 = state_26098__$1;
(statearr_26184_26368[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (6))){
var inst_25769 = (state_26098[(36)]);
var state_26098__$1 = state_26098;
var statearr_26185_26369 = state_26098__$1;
(statearr_26185_26369[(2)] = inst_25769);

(statearr_26185_26369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (111))){
var inst_26007 = (state_26098[(37)]);
var inst_26029 = (state_26098[(2)]);
var inst_25999 = inst_26007;
var inst_26000 = inst_26029;
var state_26098__$1 = (function (){var statearr_26186 = state_26098;
(statearr_26186[(38)] = inst_25999);

(statearr_26186[(10)] = inst_26000);

return statearr_26186;
})();
var statearr_26187_26370 = state_26098__$1;
(statearr_26187_26370[(2)] = null);

(statearr_26187_26370[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (28))){
var state_26098__$1 = state_26098;
var statearr_26188_26371 = state_26098__$1;
(statearr_26188_26371[(2)] = null);

(statearr_26188_26371[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (64))){
var inst_25791 = (state_26098[(18)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25791)){
var statearr_26189_26372 = state_26098__$1;
(statearr_26189_26372[(1)] = (67));

} else {
var statearr_26190_26373 = state_26098__$1;
(statearr_26190_26373[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (103))){
var state_26098__$1 = state_26098;
if(cljs.core.truth_(fuel)){
var statearr_26191_26374 = state_26098__$1;
(statearr_26191_26374[(1)] = (105));

} else {
var statearr_26192_26375 = state_26098__$1;
(statearr_26192_26375[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (51))){
var inst_25875 = (state_26098[(26)]);
var state_26098__$1 = state_26098;
var statearr_26193_26376 = state_26098__$1;
(statearr_26193_26376[(2)] = inst_25875);

(statearr_26193_26376[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (25))){
var state_26098__$1 = state_26098;
var statearr_26194_26377 = state_26098__$1;
(statearr_26194_26377[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (34))){
var state_26098__$1 = state_26098;
var statearr_26196_26378 = state_26098__$1;
(statearr_26196_26378[(2)] = null);

(statearr_26196_26378[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (125))){
var inst_26076 = (state_26098[(11)]);
var inst_26079 = (state_26098[(30)]);
var inst_26079__$1 = cljs.core.coll_QMARK_.call(null,inst_26076);
var state_26098__$1 = (function (){var statearr_26197 = state_26098;
(statearr_26197[(30)] = inst_26079__$1);

return statearr_26197;
})();
if(inst_26079__$1){
var statearr_26198_26379 = state_26098__$1;
(statearr_26198_26379[(1)] = (128));

} else {
var statearr_26199_26380 = state_26098__$1;
(statearr_26199_26380[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (17))){
var inst_25791 = (state_26098[(18)]);
var inst_25802 = (state_26098[(2)]);
var inst_25803 = cljs.core.PersistentHashMap.EMPTY;
var inst_25804 = cljs.core.volatile_BANG_.call(null,inst_25803);
var state_26098__$1 = (function (){var statearr_26200 = state_26098;
(statearr_26200[(7)] = inst_25802);

(statearr_26200[(8)] = inst_25804);

return statearr_26200;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26201_26381 = state_26098__$1;
(statearr_26201_26381[(1)] = (18));

} else {
var statearr_26202_26382 = state_26098__$1;
(statearr_26202_26382[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (3))){
var inst_26096 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26098__$1,inst_26096);
} else {
if((state_val_26099 === (12))){
var inst_25775 = (state_26098[(39)]);
var state_26098__$1 = state_26098;
var statearr_26203_26383 = state_26098__$1;
(statearr_26203_26383[(2)] = inst_25775);

(statearr_26203_26383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (2))){
var inst_25769 = (state_26098[(36)]);
var _ = (function (){var statearr_26204 = state_26098;
(statearr_26204[(4)] = cljs.core.cons.call(null,(5),(state_26098[(4)])));

return statearr_26204;
})();
var inst_25769__$1 = select;
var state_26098__$1 = (function (){var statearr_26205 = state_26098;
(statearr_26205[(36)] = inst_25769__$1);

return statearr_26205;
})();
if(cljs.core.truth_(inst_25769__$1)){
var statearr_26206_26384 = state_26098__$1;
(statearr_26206_26384[(1)] = (6));

} else {
var statearr_26207_26385 = state_26098__$1;
(statearr_26207_26385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (66))){
var inst_26067 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26208_26386 = state_26098__$1;
(statearr_26208_26386[(2)] = inst_26067);

(statearr_26208_26386[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (107))){
var inst_26006 = (state_26098[(19)]);
var inst_26018 = (state_26098[(2)]);
var inst_26019 = fluree.db.dbproto._subid.call(null,db,inst_26006,false);
var state_26098__$1 = (function (){var statearr_26209 = state_26098;
(statearr_26209[(40)] = inst_26018);

return statearr_26209;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(108),inst_26019);
} else {
if((state_val_26099 === (23))){
var inst_25830 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26210_26387 = state_26098__$1;
(statearr_26210_26387[(2)] = inst_25830);

(statearr_26210_26387[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (47))){
var inst_25875 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_26098__$1 = (function (){var statearr_26211 = state_26098;
(statearr_26211[(26)] = inst_25875);

return statearr_26211;
})();
if(cljs.core.truth_(fuel)){
var statearr_26212_26388 = state_26098__$1;
(statearr_26212_26388[(1)] = (50));

} else {
var statearr_26213_26389 = state_26098__$1;
(statearr_26213_26389[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (35))){
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25845 = (state_26098[(2)]);
var inst_25846 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25847 = [inst_25792,inst_25794];
var inst_25848 = cljs.core.PersistentHashMap.fromArrays(inst_25846,inst_25847);
var inst_25849 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25845,inst_25848);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(36),inst_25849);
} else {
if((state_val_26099 === (127))){
var inst_26088 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_26088)){
var statearr_26214_26390 = state_26098__$1;
(statearr_26214_26390[(1)] = (131));

} else {
var statearr_26215_26391 = state_26098__$1;
(statearr_26215_26391[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (82))){
var inst_26063 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26216_26392 = state_26098__$1;
(statearr_26216_26392[(2)] = inst_26063);

(statearr_26216_26392[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (76))){
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25941 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25942 = [inst_25792,inst_25794];
var inst_25943 = cljs.core.PersistentHashMap.fromArrays(inst_25941,inst_25942);
var state_26098__$1 = state_26098;
var statearr_26217_26393 = state_26098__$1;
(statearr_26217_26393[(2)] = inst_25943);

(statearr_26217_26393[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (97))){
var inst_25999 = (state_26098[(38)]);
var inst_26006 = (state_26098[(19)]);
var inst_26005 = cljs.core.seq.call(null,inst_25999);
var inst_26006__$1 = cljs.core.first.call(null,inst_26005);
var inst_26007 = cljs.core.next.call(null,inst_26005);
var inst_26008 = cljs.core.not.call(null,inst_26006__$1);
var state_26098__$1 = (function (){var statearr_26218 = state_26098;
(statearr_26218[(19)] = inst_26006__$1);

(statearr_26218[(37)] = inst_26007);

return statearr_26218;
})();
if(inst_26008){
var statearr_26219_26394 = state_26098__$1;
(statearr_26219_26394[(1)] = (99));

} else {
var statearr_26220_26395 = state_26098__$1;
(statearr_26220_26395[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (19))){
var inst_25832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25833 = [null,null];
var inst_25834 = (new cljs.core.PersistentVector(null,2,(5),inst_25832,inst_25833,null));
var state_26098__$1 = state_26098;
var statearr_26221_26396 = state_26098__$1;
(statearr_26221_26396[(2)] = inst_25834);

(statearr_26221_26396[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (57))){
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25891 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25892 = [inst_25792,inst_25794];
var inst_25893 = cljs.core.PersistentHashMap.fromArrays(inst_25891,inst_25892);
var state_26098__$1 = state_26098;
var statearr_26222_26397 = state_26098__$1;
(statearr_26222_26397[(2)] = inst_25893);

(statearr_26222_26397[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (68))){
var inst_25792 = (state_26098[(14)]);
var inst_25794 = (state_26098[(15)]);
var inst_25922 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25923 = [inst_25792,inst_25794];
var inst_25924 = cljs.core.PersistentHashMap.fromArrays(inst_25922,inst_25923);
var state_26098__$1 = state_26098;
var statearr_26223_26398 = state_26098__$1;
(statearr_26223_26398[(2)] = inst_25924);

(statearr_26223_26398[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (11))){
var inst_25786 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26224_26399 = state_26098__$1;
(statearr_26224_26399[(2)] = inst_25786);

(statearr_26224_26399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (115))){
var inst_25791 = (state_26098[(18)]);
var inst_26040 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26226 = state_26098;
(statearr_26226[(34)] = inst_26040);

return statearr_26226;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26227_26400 = state_26098__$1;
(statearr_26227_26400[(1)] = (116));

} else {
var statearr_26228_26401 = state_26098__$1;
(statearr_26228_26401[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (9))){
var inst_25772 = (state_26098[(12)]);
var state_26098__$1 = state_26098;
var statearr_26229_26402 = state_26098__$1;
(statearr_26229_26402[(2)] = inst_25772);

(statearr_26229_26402[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (5))){
var _ = (function (){var statearr_26230 = state_26098;
(statearr_26230[(4)] = cljs.core.rest.call(null,(state_26098[(4)])));

return statearr_26230;
})();
var state_26098__$1 = state_26098;
var ex26225 = (state_26098__$1[(2)]);
var statearr_26231_26403 = state_26098__$1;
(statearr_26231_26403[(5)] = ex26225);


if((ex26225 instanceof Error)){
var statearr_26232_26404 = state_26098__$1;
(statearr_26232_26404[(1)] = (4));

(statearr_26232_26404[(5)] = null);

} else {
throw ex26225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (112))){
var inst_26047 = (state_26098[(2)]);
var inst_26048 = fluree.db.util.async.throw_err.call(null,inst_26047);
var state_26098__$1 = state_26098;
var statearr_26233_26405 = state_26098__$1;
(statearr_26233_26405[(2)] = inst_26048);

(statearr_26233_26405[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (83))){
var inst_25961 = (state_26098[(20)]);
var inst_25960 = (state_26098[(2)]);
var inst_25961__$1 = fluree.db.util.async.throw_err.call(null,inst_25960);
var inst_25962 = (inst_25961__$1 == null);
var state_26098__$1 = (function (){var statearr_26234 = state_26098;
(statearr_26234[(20)] = inst_25961__$1);

return statearr_26234;
})();
if(cljs.core.truth_(inst_25962)){
var statearr_26235_26406 = state_26098__$1;
(statearr_26235_26406[(1)] = (84));

} else {
var statearr_26236_26407 = state_26098__$1;
(statearr_26236_26407[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (14))){
var inst_25784 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26237_26408 = state_26098__$1;
(statearr_26237_26408[(2)] = inst_25784);

(statearr_26237_26408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (45))){
var inst_25866 = (state_26098[(27)]);
var state_26098__$1 = state_26098;
var statearr_26238_26409 = state_26098__$1;
(statearr_26238_26409[(2)] = inst_25866);

(statearr_26238_26409[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (53))){
var inst_25881 = (state_26098[(21)]);
var inst_25883 = cljs.core.distinct.call(null);
var inst_25884 = cljs.core.comp.call(null,inst_25881,inst_25883);
var state_26098__$1 = state_26098;
var statearr_26239_26410 = state_26098__$1;
(statearr_26239_26410[(2)] = inst_25884);

(statearr_26239_26410[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (78))){
var inst_25802 = (state_26098[(7)]);
var inst_25804 = (state_26098[(8)]);
var inst_25948 = (state_26098[(2)]);
var inst_25949 = fluree.db.util.async.throw_err.call(null,inst_25948);
var inst_25950 = fluree.db.query.fql.flake_select.call(null,db,inst_25804,fuel,max_fuel,inst_25802,inst_25949);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(79),inst_25950);
} else {
if((state_val_26099 === (132))){
var inst_26076 = (state_26098[(11)]);
var state_26098__$1 = state_26098;
var statearr_26240_26411 = state_26098__$1;
(statearr_26240_26411[(2)] = inst_26076);

(statearr_26240_26411[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (26))){
var inst_25828 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26241_26412 = state_26098__$1;
(statearr_26241_26412[(2)] = inst_25828);

(statearr_26241_26412[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (123))){
var inst_26071 = (state_26098[(28)]);
var state_26098__$1 = state_26098;
var statearr_26242_26413 = state_26098__$1;
(statearr_26242_26413[(2)] = inst_26071);

(statearr_26242_26413[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (16))){
var inst_25795 = (state_26098[(25)]);
var state_26098__$1 = state_26098;
var statearr_26243_26414 = state_26098__$1;
(statearr_26243_26414[(2)] = inst_25795);

(statearr_26243_26414[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (133))){
var inst_26093 = (state_26098[(2)]);
var _ = (function (){var statearr_26244 = state_26098;
(statearr_26244[(4)] = cljs.core.rest.call(null,(state_26098[(4)])));

return statearr_26244;
})();
var state_26098__$1 = state_26098;
var statearr_26245_26415 = state_26098__$1;
(statearr_26245_26415[(2)] = inst_26093);

(statearr_26245_26415[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (81))){
var inst_25980 = (state_26098[(22)]);
var inst_25980__$1 = cljs.core.sequential_QMARK_.call(null,from);
var state_26098__$1 = (function (){var statearr_26246 = state_26098;
(statearr_26246[(22)] = inst_25980__$1);

return statearr_26246;
})();
if(inst_25980__$1){
var statearr_26247_26416 = state_26098__$1;
(statearr_26247_26416[(1)] = (91));

} else {
var statearr_26248_26417 = state_26098__$1;
(statearr_26248_26417[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (120))){
var state_26098__$1 = state_26098;
var statearr_26249_26418 = state_26098__$1;
(statearr_26249_26418[(2)] = null);

(statearr_26249_26418[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (79))){
var inst_25952 = (state_26098[(2)]);
var inst_25953 = fluree.db.util.async.throw_err.call(null,inst_25952);
var state_26098__$1 = state_26098;
var statearr_26250_26419 = state_26098__$1;
(statearr_26250_26419[(2)] = inst_25953);

(statearr_26250_26419[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (38))){
var state_26098__$1 = state_26098;
var statearr_26251_26420 = state_26098__$1;
(statearr_26251_26420[(2)] = null);

(statearr_26251_26420[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (126))){
var inst_26077 = (state_26098[(41)]);
var state_26098__$1 = state_26098;
var statearr_26252_26421 = state_26098__$1;
(statearr_26252_26421[(2)] = inst_26077);

(statearr_26252_26421[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (98))){
var inst_25791 = (state_26098[(18)]);
var inst_26034 = (state_26098[(2)]);
var inst_26035 = cljs.core.PersistentVector.EMPTY;
var inst_26036 = cljs.core.into.call(null,inst_26035,inst_26034);
var state_26098__$1 = (function (){var statearr_26253 = state_26098;
(statearr_26253[(35)] = inst_26036);

return statearr_26253;
})();
if(cljs.core.truth_(inst_25791)){
var statearr_26254_26422 = state_26098__$1;
(statearr_26254_26422[(1)] = (113));

} else {
var statearr_26255_26423 = state_26098__$1;
(statearr_26255_26423[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (124))){
var inst_26077 = (state_26098[(41)]);
var inst_26076 = (state_26098[(2)]);
var inst_26077__$1 = selectOne;
var state_26098__$1 = (function (){var statearr_26256 = state_26098;
(statearr_26256[(11)] = inst_26076);

(statearr_26256[(41)] = inst_26077__$1);

return statearr_26256;
})();
if(cljs.core.truth_(inst_26077__$1)){
var statearr_26257_26424 = state_26098__$1;
(statearr_26257_26424[(1)] = (125));

} else {
var statearr_26258_26425 = state_26098__$1;
(statearr_26258_26425[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (87))){
var inst_25972 = (state_26098[(2)]);
var inst_25973 = fluree.db.util.async.throw_err.call(null,inst_25972);
var state_26098__$1 = (function (){var statearr_26259 = state_26098;
(statearr_26259[(31)] = inst_25973);

return statearr_26259;
})();
if(cljs.core.truth_(fuel)){
var statearr_26260_26426 = state_26098__$1;
(statearr_26260_26426[(1)] = (88));

} else {
var statearr_26261_26427 = state_26098__$1;
(statearr_26261_26427[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (30))){
var inst_25841 = typeof from === 'string';
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25841)){
var statearr_26262_26428 = state_26098__$1;
(statearr_26262_26428[(1)] = (33));

} else {
var statearr_26263_26429 = state_26098__$1;
(statearr_26263_26429[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (73))){
var inst_25955 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_26098__$1 = state_26098;
if(inst_25955){
var statearr_26264_26430 = state_26098__$1;
(statearr_26264_26430[(1)] = (80));

} else {
var statearr_26265_26431 = state_26098__$1;
(statearr_26265_26431[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (96))){
var inst_26061 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26266_26432 = state_26098__$1;
(statearr_26266_26432[(2)] = inst_26061);

(statearr_26266_26432[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (10))){
var inst_25775 = (state_26098[(39)]);
var inst_25775__$1 = selectDistinct;
var state_26098__$1 = (function (){var statearr_26267 = state_26098;
(statearr_26267[(39)] = inst_25775__$1);

return statearr_26267;
})();
if(cljs.core.truth_(inst_25775__$1)){
var statearr_26268_26433 = state_26098__$1;
(statearr_26268_26433[(1)] = (12));

} else {
var statearr_26269_26434 = state_26098__$1;
(statearr_26269_26434[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (18))){
var inst_25791 = (state_26098[(18)]);
var inst_25806 = cljs.core.vector_QMARK_.call(null,inst_25791);
var state_26098__$1 = state_26098;
if(inst_25806){
var statearr_26270_26435 = state_26098__$1;
(statearr_26270_26435[(1)] = (21));

} else {
var statearr_26271_26436 = state_26098__$1;
(statearr_26271_26436[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (105))){
var inst_26015 = fluree.db.query.fql.vswap_BANG_.call(null,fuel,cljs.core.inc);
var state_26098__$1 = state_26098;
var statearr_26272_26437 = state_26098__$1;
(statearr_26272_26437[(2)] = inst_26015);

(statearr_26272_26437[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (52))){
var inst_25881 = (state_26098[(2)]);
var state_26098__$1 = (function (){var statearr_26273 = state_26098;
(statearr_26273[(21)] = inst_25881);

return statearr_26273;
})();
var statearr_26274_26438 = state_26098__$1;
(statearr_26274_26438[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (114))){
var inst_25792 = (state_26098[(14)]);
var state_26098__$1 = state_26098;
var statearr_26276_26439 = state_26098__$1;
(statearr_26276_26439[(2)] = inst_25792);

(statearr_26276_26439[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (67))){
var inst_25920 = cljs.core.PersistentHashMap.EMPTY;
var state_26098__$1 = state_26098;
var statearr_26277_26440 = state_26098__$1;
(statearr_26277_26440[(2)] = inst_25920);

(statearr_26277_26440[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (71))){
var inst_25933 = (state_26098[(2)]);
var inst_25934 = fluree.db.util.async.throw_err.call(null,inst_25933);
var state_26098__$1 = state_26098;
var statearr_26278_26441 = state_26098__$1;
(statearr_26278_26441[(2)] = inst_25934);

(statearr_26278_26441[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (42))){
var inst_25794 = (state_26098[(15)]);
var state_26098__$1 = state_26098;
var statearr_26279_26442 = state_26098__$1;
(statearr_26279_26442[(2)] = inst_25794);

(statearr_26279_26442[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (80))){
var inst_25958 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_26098__$1 = state_26098;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26098__$1,(83),inst_25958);
} else {
if((state_val_26099 === (37))){
var inst_25863 = (state_26098[(2)]);
var inst_25864 = fluree.db.util.async.throw_err.call(null,inst_25863);
var state_26098__$1 = state_26098;
var statearr_26280_26443 = state_26098__$1;
(statearr_26280_26443[(2)] = inst_25864);

(statearr_26280_26443[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (63))){
var inst_25917 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
if(cljs.core.truth_(inst_25917)){
var statearr_26281_26444 = state_26098__$1;
(statearr_26281_26444[(1)] = (64));

} else {
var statearr_26282_26445 = state_26098__$1;
(statearr_26282_26445[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (94))){
var inst_25994 = from;
var inst_25995 = cljs.core.seq.call(null,inst_25994);
var inst_25996 = cljs.core.first.call(null,inst_25995);
var inst_25997 = cljs.core.next.call(null,inst_25995);
var inst_25998 = cljs.core.PersistentVector.EMPTY;
var inst_25999 = inst_25994;
var inst_26000 = inst_25998;
var state_26098__$1 = (function (){var statearr_26283 = state_26098;
(statearr_26283[(38)] = inst_25999);

(statearr_26283[(42)] = inst_25997);

(statearr_26283[(10)] = inst_26000);

(statearr_26283[(43)] = inst_25996);

return statearr_26283;
})();
var statearr_26284_26446 = state_26098__$1;
(statearr_26284_26446[(2)] = null);

(statearr_26284_26446[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (8))){
var inst_25793 = (state_26098[(24)]);
var inst_25788 = (state_26098[(2)]);
var inst_25789 = opts_SINGLEQUOTE_;
var inst_25790 = cljs.core.__destructure_map.call(null,inst_25789);
var inst_25791 = cljs.core.get.call(null,inst_25790,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25792 = cljs.core.get.call(null,inst_25790,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25793__$1 = cljs.core.get.call(null,inst_25790,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25794 = cljs.core.get.call(null,inst_25790,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25795 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25788,opts_SINGLEQUOTE_);
var inst_25796 = (inst_25793__$1 == null);
var inst_25797 = cljs.core.not.call(null,inst_25796);
var state_26098__$1 = (function (){var statearr_26285 = state_26098;
(statearr_26285[(24)] = inst_25793__$1);

(statearr_26285[(14)] = inst_25792);

(statearr_26285[(25)] = inst_25795);

(statearr_26285[(15)] = inst_25794);

(statearr_26285[(18)] = inst_25791);

return statearr_26285;
})();
if(inst_25797){
var statearr_26286_26447 = state_26098__$1;
(statearr_26286_26447[(1)] = (15));

} else {
var statearr_26287_26448 = state_26098__$1;
(statearr_26287_26448[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (49))){
var inst_26069 = (state_26098[(2)]);
var state_26098__$1 = state_26098;
var statearr_26288_26449 = state_26098__$1;
(statearr_26288_26449[(2)] = inst_26069);

(statearr_26288_26449[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26099 === (84))){
var state_26098__$1 = state_26098;
var statearr_26289_26450 = state_26098__$1;
(statearr_26289_26450[(2)] = null);

(statearr_26289_26450[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2741__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2741__auto____0 = (function (){
var statearr_26290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26290[(0)] = fluree$db$query$fql$query_$_state_machine__2741__auto__);

(statearr_26290[(1)] = (1));

return statearr_26290;
});
var fluree$db$query$fql$query_$_state_machine__2741__auto____1 = (function (state_26098){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_26098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e26291){var ex__2744__auto__ = e26291;
var statearr_26292_26451 = state_26098;
(statearr_26292_26451[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_26098[(4)]))){
var statearr_26293_26452 = state_26098;
(statearr_26293_26452[(1)] = cljs.core.first.call(null,(state_26098[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26453 = state_26098;
state_26098 = G__26453;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2741__auto__ = function(state_26098){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2741__auto____1.call(this,state_26098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2741__auto____0;
fluree$db$query$fql$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2741__auto____1;
return fluree$db$query$fql$query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_26294 = f__2764__auto__.call(null);
(statearr_26294[(6)] = c__2763__auto__);

return statearr_26294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}

});
