// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18729 = arguments.length;
switch (G__18729) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18732 = arguments.length;
switch (G__18732) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2763__auto___18785 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18763){
var state_val_18764 = (state_18763[(1)]);
if((state_val_18764 === (1))){
var state_18763__$1 = state_18763;
var statearr_18765_18786 = state_18763__$1;
(statearr_18765_18786[(2)] = null);

(statearr_18765_18786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (2))){
var _ = (function (){var statearr_18766 = state_18763;
(statearr_18766[(4)] = cljs.core.cons.call(null,(5),(state_18763[(4)])));

return statearr_18766;
})();
var inst_18740 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_18763__$1 = state_18763;
if(cljs.core.truth_(inst_18740)){
var statearr_18767_18787 = state_18763__$1;
(statearr_18767_18787[(1)] = (6));

} else {
var statearr_18768_18788 = state_18763__$1;
(statearr_18768_18788[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (3))){
var inst_18761 = (state_18763[(2)]);
var state_18763__$1 = state_18763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18763__$1,inst_18761);
} else {
if((state_val_18764 === (4))){
var inst_18733 = (state_18763[(2)]);
var inst_18734 = cljs.core.async.put_BANG_.call(null,pc,inst_18733);
var state_18763__$1 = state_18763;
var statearr_18770_18789 = state_18763__$1;
(statearr_18770_18789[(2)] = inst_18734);

(statearr_18770_18789[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (5))){
var _ = (function (){var statearr_18771 = state_18763;
(statearr_18771[(4)] = cljs.core.rest.call(null,(state_18763[(4)])));

return statearr_18771;
})();
var state_18763__$1 = state_18763;
var ex18769 = (state_18763__$1[(2)]);
var statearr_18772_18790 = state_18763__$1;
(statearr_18772_18790[(5)] = ex18769);


var statearr_18773_18791 = state_18763__$1;
(statearr_18773_18791[(1)] = (4));

(statearr_18773_18791[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (6))){
var inst_18742 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18743 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18744 = cljs.core.PersistentHashMap.fromArrays(inst_18742,inst_18743);
var inst_18745 = cljs.core.ex_info.call(null,"Connection was closed.",inst_18744);
var inst_18746 = (function(){throw inst_18745})();
var state_18763__$1 = state_18763;
var statearr_18774_18792 = state_18763__$1;
(statearr_18774_18792[(2)] = inst_18746);

(statearr_18774_18792[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (7))){
var inst_18748 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18750 = [operation,data,pc,opts];
var inst_18751 = (new cljs.core.PersistentVector(null,4,(5),inst_18749,inst_18750,null));
var inst_18752 = cljs.core.async.put_BANG_.call(null,inst_18748,inst_18751);
var inst_18753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18754 = [operation,data,pc,opts];
var inst_18755 = (new cljs.core.PersistentVector(null,4,(5),inst_18753,inst_18754,null));
var inst_18756 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18755);
var state_18763__$1 = (function (){var statearr_18775 = state_18763;
(statearr_18775[(7)] = inst_18752);

return statearr_18775;
})();
var statearr_18776_18793 = state_18763__$1;
(statearr_18776_18793[(2)] = inst_18756);

(statearr_18776_18793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18764 === (8))){
var inst_18758 = (state_18763[(2)]);
var _ = (function (){var statearr_18777 = state_18763;
(statearr_18777[(4)] = cljs.core.rest.call(null,(state_18763[(4)])));

return statearr_18777;
})();
var state_18763__$1 = state_18763;
var statearr_18778_18794 = state_18763__$1;
(statearr_18778_18794[(2)] = inst_18758);

(statearr_18778_18794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2741__auto__ = null;
var fluree$db$operations$state_machine__2741__auto____0 = (function (){
var statearr_18779 = [null,null,null,null,null,null,null,null];
(statearr_18779[(0)] = fluree$db$operations$state_machine__2741__auto__);

(statearr_18779[(1)] = (1));

return statearr_18779;
});
var fluree$db$operations$state_machine__2741__auto____1 = (function (state_18763){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18780){var ex__2744__auto__ = e18780;
var statearr_18781_18795 = state_18763;
(statearr_18781_18795[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18763[(4)]))){
var statearr_18782_18796 = state_18763;
(statearr_18782_18796[(1)] = cljs.core.first.call(null,(state_18763[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18797 = state_18763;
state_18763 = G__18797;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2741__auto__ = function(state_18763){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2741__auto____1.call(this,state_18763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2741__auto____0;
fluree$db$operations$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2741__auto____1;
return fluree$db$operations$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18783 = f__2764__auto__.call(null);
(statearr_18783[(6)] = c__2763__auto___18785);

return statearr_18783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18799 = arguments.length;
switch (G__18799) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18800){
var map__18801 = p__18800;
var map__18801__$1 = cljs.core.__destructure_map.call(null,map__18801);
var opts = map__18801__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__18801__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18802 = session;
var map__18802__$1 = cljs.core.__destructure_map.call(null,map__18802);
var dbid = cljs.core.get.call(null,map__18802__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__18802__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__18802__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4870__auto__ = [];
var len__4864__auto___18829 = arguments.length;
var i__4865__auto___18830 = (0);
while(true){
if((i__4865__auto___18830 < len__4864__auto___18829)){
args__4870__auto__.push((arguments[i__4865__auto___18830]));

var G__18831 = (i__4865__auto___18830 + (1));
i__4865__auto___18830 = G__18831;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18806){
var vec__18807 = p__18806;
var map__18810 = cljs.core.nth.call(null,vec__18807,(0),null);
var map__18810__$1 = cljs.core.__destructure_map.call(null,map__18810);
var toBlock = cljs.core.get.call(null,map__18810__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__18810__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18807;
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_18822){
var state_val_18823 = (state_18822[(1)]);
if((state_val_18823 === (1))){
var inst_18812 = session;
var inst_18813 = cljs.core.__destructure_map.call(null,inst_18812);
var inst_18814 = cljs.core.get.call(null,inst_18813,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18815 = cljs.core.get.call(null,inst_18813,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_18816 = cljs.core.get.call(null,inst_18813,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18817 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18818 = [inst_18814,inst_18815,toBlock,toTime];
var inst_18819 = cljs.core.PersistentHashMap.fromArrays(inst_18817,inst_18818);
var inst_18820 = fluree.db.operations.send_operation.call(null,inst_18816,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18819);
var state_18822__$1 = state_18822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18822__$1,inst_18820);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2741__auto__ = null;
var fluree$db$operations$state_machine__2741__auto____0 = (function (){
var statearr_18824 = [null,null,null,null,null,null,null];
(statearr_18824[(0)] = fluree$db$operations$state_machine__2741__auto__);

(statearr_18824[(1)] = (1));

return statearr_18824;
});
var fluree$db$operations$state_machine__2741__auto____1 = (function (state_18822){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_18822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e18825){var ex__2744__auto__ = e18825;
var statearr_18826_18832 = state_18822;
(statearr_18826_18832[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_18822[(4)]))){
var statearr_18827_18833 = state_18822;
(statearr_18827_18833[(1)] = cljs.core.first.call(null,(state_18822[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18834 = state_18822;
state_18822 = G__18834;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2741__auto__ = function(state_18822){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2741__auto____1.call(this,state_18822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2741__auto____0;
fluree$db$operations$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2741__auto____1;
return fluree$db$operations$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_18828 = f__2764__auto__.call(null);
(statearr_18828[(6)] = c__2763__auto__);

return statearr_18828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18804){
var G__18805 = cljs.core.first.call(null,seq18804);
var seq18804__$1 = cljs.core.next.call(null,seq18804);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18805,seq18804__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18835 = session;
var map__18835__$1 = cljs.core.__destructure_map.call(null,map__18835);
var network = cljs.core.get.call(null,map__18835__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__18835__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__18835__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18837 = arguments.length;
switch (G__18837) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18838 = opts;
var map__18838__$1 = cljs.core.__destructure_map.call(null,map__18838);
var auth = cljs.core.get.call(null,map__18838__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__18838__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4253__auto__ = auth;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
