// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28526 = arguments.length;
var i__4865__auto___28527 = (0);
while(true){
if((i__4865__auto___28527 < len__4864__auto___28526)){
args__4870__auto__.push((arguments[i__4865__auto___28527]));

var G__28528 = (i__4865__auto___28527 + (1));
i__4865__auto___28527 = G__28528;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28523){
var G__28524 = cljs.core.first.call(null,seq28523);
var seq28523__$1 = cljs.core.next.call(null,seq28523);
var G__28525 = cljs.core.first.call(null,seq28523__$1);
var seq28523__$2 = cljs.core.next.call(null,seq28523__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28524,G__28525,seq28523__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e28529){var e = e28529;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28530){var e = e28530;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e28531){var e = e28531;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28532){var e = e28532;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28533){var e = e28533;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28536 = arguments.length;
var i__4865__auto___28537 = (0);
while(true){
if((i__4865__auto___28537 < len__4864__auto___28536)){
args__4870__auto__.push((arguments[i__4865__auto___28537]));

var G__28538 = (i__4865__auto___28537 + (1));
i__4865__auto___28537 = G__28538;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28535){var e = e28535;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28534){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28534));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28541 = arguments.length;
var i__4865__auto___28542 = (0);
while(true){
if((i__4865__auto___28542 < len__4864__auto___28541)){
args__4870__auto__.push((arguments[i__4865__auto___28542]));

var G__28543 = (i__4865__auto___28542 + (1));
i__4865__auto___28542 = G__28543;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28540){var e = e28540;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28539){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28539));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e28544){var e = e28544;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28547 = arguments.length;
var i__4865__auto___28548 = (0);
while(true){
if((i__4865__auto___28548 < len__4864__auto___28547)){
args__4870__auto__.push((arguments[i__4865__auto___28548]));

var G__28549 = (i__4865__auto___28548 + (1));
i__4865__auto___28548 = G__28549;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e28546){var e = e28546;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28545){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28545));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28552 = arguments.length;
var i__4865__auto___28553 = (0);
while(true){
if((i__4865__auto___28553 < len__4864__auto___28552)){
args__4870__auto__.push((arguments[i__4865__auto___28553]));

var G__28554 = (i__4865__auto___28553 + (1));
i__4865__auto___28553 = G__28554;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e28551){var e = e28551;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28550){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28550));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e28555){var e = e28555;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e28556){var e = e28556;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28559 = arguments.length;
var i__4865__auto___28560 = (0);
while(true){
if((i__4865__auto___28560 < len__4864__auto___28559)){
args__4870__auto__.push((arguments[i__4865__auto___28560]));

var G__28561 = (i__4865__auto___28560 + (1));
i__4865__auto___28560 = G__28561;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28558){var e = e28558;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28557){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28557));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28564 = arguments.length;
var i__4865__auto___28565 = (0);
while(true){
if((i__4865__auto___28565 < len__4864__auto___28564)){
args__4870__auto__.push((arguments[i__4865__auto___28565]));

var G__28566 = (i__4865__auto___28565 + (1));
i__4865__auto___28565 = G__28566;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28563){var e = e28563;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28562){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28562));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28569 = arguments.length;
var i__4865__auto___28570 = (0);
while(true){
if((i__4865__auto___28570 < len__4864__auto___28569)){
args__4870__auto__.push((arguments[i__4865__auto___28570]));

var G__28571 = (i__4865__auto___28570 + (1));
i__4865__auto___28570 = G__28571;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28568){var e = e28568;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28567){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28567));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28574 = arguments.length;
var i__4865__auto___28575 = (0);
while(true){
if((i__4865__auto___28575 < len__4864__auto___28574)){
args__4870__auto__.push((arguments[i__4865__auto___28575]));

var G__28576 = (i__4865__auto___28575 + (1));
i__4865__auto___28575 = G__28576;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28573){var e = e28573;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28572){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28572));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28579 = arguments.length;
var i__4865__auto___28580 = (0);
while(true){
if((i__4865__auto___28580 < len__4864__auto___28579)){
args__4870__auto__.push((arguments[i__4865__auto___28580]));

var G__28581 = (i__4865__auto___28580 + (1));
i__4865__auto___28580 = G__28581;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28578){var e = e28578;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28577){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28577));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28584 = arguments.length;
var i__4865__auto___28585 = (0);
while(true){
if((i__4865__auto___28585 < len__4864__auto___28584)){
args__4870__auto__.push((arguments[i__4865__auto___28585]));

var G__28586 = (i__4865__auto___28585 + (1));
i__4865__auto___28585 = G__28586;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28583){var e = e28583;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28582){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28582));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28589 = arguments.length;
var i__4865__auto___28590 = (0);
while(true){
if((i__4865__auto___28590 < len__4864__auto___28589)){
args__4870__auto__.push((arguments[i__4865__auto___28590]));

var G__28591 = (i__4865__auto___28590 + (1));
i__4865__auto___28590 = G__28591;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28588){var e = e28588;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28587){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28587));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28593 = arguments.length;
switch (G__28593) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28621){
var state_val_28622 = (state_28621[(1)]);
if((state_val_28622 === (7))){
var inst_28606 = (state_28621[(7)]);
var inst_28609 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28606,"query",query_map);
var state_28621__$1 = state_28621;
var statearr_28623_28709 = state_28621__$1;
(statearr_28623_28709[(2)] = inst_28609);

(statearr_28623_28709[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (1))){
var state_28621__$1 = state_28621;
var statearr_28624_28710 = state_28621__$1;
(statearr_28624_28710[(2)] = null);

(statearr_28624_28710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (4))){
var inst_28594 = (state_28621[(2)]);
var state_28621__$1 = state_28621;
var statearr_28625_28711 = state_28621__$1;
(statearr_28625_28711[(2)] = inst_28594);

(statearr_28625_28711[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (6))){
var inst_28606 = (state_28621[(7)]);
var inst_28606__$1 = (state_28621[(2)]);
var inst_28607 = fluree.db.util.core.exception_QMARK_.call(null,inst_28606__$1);
var state_28621__$1 = (function (){var statearr_28626 = state_28621;
(statearr_28626[(7)] = inst_28606__$1);

return statearr_28626;
})();
if(inst_28607){
var statearr_28627_28712 = state_28621__$1;
(statearr_28627_28712[(1)] = (7));

} else {
var statearr_28628_28713 = state_28621__$1;
(statearr_28628_28713[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (3))){
var inst_28619 = (state_28621[(2)]);
var state_28621__$1 = state_28621;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28621__$1,inst_28619);
} else {
if((state_val_28622 === (2))){
var inst_28600 = (state_28621[(8)]);
var _ = (function (){var statearr_28630 = state_28621;
(statearr_28630[(4)] = cljs.core.cons.call(null,(5),(state_28621[(4)])));

return statearr_28630;
})();
var inst_28600__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28601 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28602 = cljs.core.assoc.call(null,inst_28601,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28600__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28603 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28602);
var inst_28604 = fluree.db.query.fql.query.call(null,db,inst_28603);
var state_28621__$1 = (function (){var statearr_28631 = state_28621;
(statearr_28631[(8)] = inst_28600__$1);

return statearr_28631;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28621__$1,(6),inst_28604);
} else {
if((state_val_28622 === (9))){
var inst_28616 = (state_28621[(2)]);
var _ = (function (){var statearr_28632 = state_28621;
(statearr_28632[(4)] = cljs.core.rest.call(null,(state_28621[(4)])));

return statearr_28632;
})();
var state_28621__$1 = state_28621;
var statearr_28633_28714 = state_28621__$1;
(statearr_28633_28714[(2)] = inst_28616);

(statearr_28633_28714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (5))){
var _ = (function (){var statearr_28634 = state_28621;
(statearr_28634[(4)] = cljs.core.rest.call(null,(state_28621[(4)])));

return statearr_28634;
})();
var state_28621__$1 = state_28621;
var ex28629 = (state_28621__$1[(2)]);
var statearr_28635_28715 = state_28621__$1;
(statearr_28635_28715[(5)] = ex28629);


if((ex28629 instanceof Error)){
var statearr_28636_28716 = state_28621__$1;
(statearr_28636_28716[(1)] = (4));

(statearr_28636_28716[(5)] = null);

} else {
throw ex28629;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28622 === (8))){
var inst_28600 = (state_28621[(8)]);
var inst_28606 = (state_28621[(7)]);
var inst_28611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28612 = cljs.core.deref.call(null,inst_28600);
var inst_28613 = [inst_28606,inst_28612];
var inst_28614 = (new cljs.core.PersistentVector(null,2,(5),inst_28611,inst_28613,null));
var state_28621__$1 = state_28621;
var statearr_28637_28717 = state_28621__$1;
(statearr_28637_28717[(2)] = inst_28614);

(statearr_28637_28717[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_28638 = [null,null,null,null,null,null,null,null,null];
(statearr_28638[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_28638[(1)] = (1));

return statearr_28638;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_28621){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28621);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28639){var ex__2744__auto__ = e28639;
var statearr_28640_28718 = state_28621;
(statearr_28640_28718[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28621[(4)]))){
var statearr_28641_28719 = state_28621;
(statearr_28641_28719[(1)] = cljs.core.first.call(null,(state_28621[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28720 = state_28621;
state_28621 = G__28720;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_28621){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_28621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28642 = f__2764__auto__.call(null);
(statearr_28642[(6)] = c__2763__auto__);

return statearr_28642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28687){
var state_val_28688 = (state_28687[(1)]);
if((state_val_28688 === (7))){
var inst_28673 = (state_28687[(2)]);
var inst_28674 = fluree.db.query.fql.query.call(null,db,inst_28673);
var state_28687__$1 = state_28687;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28687__$1,(8),inst_28674);
} else {
if((state_val_28688 === (1))){
var inst_28643 = typeof select === 'string';
var state_28687__$1 = state_28687;
if(cljs.core.truth_(inst_28643)){
var statearr_28689_28721 = state_28687__$1;
(statearr_28689_28721[(1)] = (2));

} else {
var statearr_28690_28722 = state_28687__$1;
(statearr_28690_28722[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (4))){
var inst_28656 = (state_28687[(7)]);
var inst_28649 = (state_28687[(8)]);
var inst_28648 = (state_28687[(2)]);
var inst_28649__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28650 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28651 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28652 = [inst_28649__$1,(100000)];
var inst_28653 = cljs.core.PersistentHashMap.fromArrays(inst_28651,inst_28652);
var inst_28654 = [inst_28648,from,where,block,limit,inst_28653];
var inst_28655 = cljs.core.PersistentHashMap.fromArrays(inst_28650,inst_28654);
var inst_28656__$1 = fluree.db.util.core.without_nils.call(null,inst_28655);
var inst_28657 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28656__$1);
var inst_28658 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28656__$1);
var inst_28659 = cljs.core.first.call(null,inst_28658);
var inst_28660 = fluree.db.dbfunctions.internal.str.call(null,inst_28659);
var inst_28661 = cljs.core._EQ_.call(null,"[",inst_28660);
var inst_28662 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28656__$1);
var inst_28663 = cljs.core.last.call(null,inst_28662);
var inst_28664 = fluree.db.dbfunctions.internal.str.call(null,inst_28663);
var inst_28665 = cljs.core._EQ_.call(null,"]",inst_28664);
var inst_28666 = fluree.db.dbfunctions.internal.and.call(null,inst_28657,inst_28661,inst_28665);
var state_28687__$1 = (function (){var statearr_28691 = state_28687;
(statearr_28691[(7)] = inst_28656__$1);

(statearr_28691[(8)] = inst_28649__$1);

return statearr_28691;
})();
if(cljs.core.truth_(inst_28666)){
var statearr_28692_28723 = state_28687__$1;
(statearr_28692_28723[(1)] = (5));

} else {
var statearr_28693_28724 = state_28687__$1;
(statearr_28693_28724[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (6))){
var inst_28656 = (state_28687[(7)]);
var state_28687__$1 = state_28687;
var statearr_28694_28725 = state_28687__$1;
(statearr_28694_28725[(2)] = inst_28656);

(statearr_28694_28725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (3))){
var state_28687__$1 = state_28687;
var statearr_28695_28726 = state_28687__$1;
(statearr_28695_28726[(2)] = select);

(statearr_28695_28726[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (2))){
var inst_28645 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28687__$1 = state_28687;
var statearr_28696_28727 = state_28687__$1;
(statearr_28696_28727[(2)] = inst_28645);

(statearr_28696_28727[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (11))){
var inst_28685 = (state_28687[(2)]);
var state_28687__$1 = state_28687;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28687__$1,inst_28685);
} else {
if((state_val_28688 === (9))){
var inst_28676 = (state_28687[(9)]);
var state_28687__$1 = state_28687;
var statearr_28697_28728 = state_28687__$1;
(statearr_28697_28728[(2)] = inst_28676);

(statearr_28697_28728[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (5))){
var inst_28656 = (state_28687[(7)]);
var inst_28668 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28656);
var inst_28669 = cljs.reader.read_string.call(null,inst_28668);
var inst_28670 = cljs.core.assoc.call(null,inst_28656,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28669);
var state_28687__$1 = state_28687;
var statearr_28698_28729 = state_28687__$1;
(statearr_28698_28729[(2)] = inst_28670);

(statearr_28698_28729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (10))){
var inst_28649 = (state_28687[(8)]);
var inst_28676 = (state_28687[(9)]);
var inst_28680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28681 = cljs.core.deref.call(null,inst_28649);
var inst_28682 = [inst_28676,inst_28681];
var inst_28683 = (new cljs.core.PersistentVector(null,2,(5),inst_28680,inst_28682,null));
var state_28687__$1 = state_28687;
var statearr_28699_28730 = state_28687__$1;
(statearr_28699_28730[(2)] = inst_28683);

(statearr_28699_28730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28688 === (8))){
var inst_28676 = (state_28687[(9)]);
var inst_28676__$1 = (state_28687[(2)]);
var inst_28677 = fluree.db.util.core.exception_QMARK_.call(null,inst_28676__$1);
var state_28687__$1 = (function (){var statearr_28700 = state_28687;
(statearr_28700[(9)] = inst_28676__$1);

return statearr_28700;
})();
if(inst_28677){
var statearr_28701_28731 = state_28687__$1;
(statearr_28701_28731[(1)] = (9));

} else {
var statearr_28702_28732 = state_28687__$1;
(statearr_28702_28732[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_28703 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28703[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_28703[(1)] = (1));

return statearr_28703;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_28687){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28687);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28704){var ex__2744__auto__ = e28704;
var statearr_28705_28733 = state_28687;
(statearr_28705_28733[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28687[(4)]))){
var statearr_28706_28734 = state_28687;
(statearr_28706_28734[(1)] = cljs.core.first.call(null,(state_28687[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28735 = state_28687;
state_28687 = G__28735;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_28687){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_28687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28707 = f__2764__auto__.call(null);
(statearr_28707[(6)] = c__2763__auto__);

return statearr_28707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28739 = path;
var vec__28740 = G__28739;
var seq__28741 = cljs.core.seq.call(null,vec__28740);
var first__28742 = cljs.core.first.call(null,seq__28741);
var seq__28741__$1 = cljs.core.next.call(null,seq__28741);
var var$ = first__28742;
var r = seq__28741__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28739__$1 = G__28739;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28746 = G__28739__$1;
var seq__28747 = cljs.core.seq.call(null,vec__28746);
var first__28748 = cljs.core.first.call(null,seq__28747);
var seq__28747__$1 = cljs.core.next.call(null,seq__28747);
var var$__$1 = first__28748;
var r__$1 = seq__28747__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28749 = r__$1;
var G__28750 = n__$2;
var G__28751 = next_clauses;
G__28739__$1 = G__28749;
n__$1 = G__28750;
where_clauses__$1 = G__28751;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28752 = r__$1;
var G__28753 = next_n;
var G__28754 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28739__$1 = G__28752;
n__$1 = G__28753;
where_clauses__$1 = G__28754;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28791){
var state_val_28792 = (state_28791[(1)]);
if((state_val_28792 === (7))){
var inst_28764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28765 = [path];
var inst_28766 = (new cljs.core.PersistentVector(null,1,(5),inst_28764,inst_28765,null));
var state_28791__$1 = state_28791;
var statearr_28793_28821 = state_28791__$1;
(statearr_28793_28821[(2)] = inst_28766);

(statearr_28793_28821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (1))){
var state_28791__$1 = state_28791;
var statearr_28794_28822 = state_28791__$1;
(statearr_28794_28822[(2)] = null);

(statearr_28794_28822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (4))){
var inst_28755 = (state_28791[(2)]);
var state_28791__$1 = state_28791;
var statearr_28795_28823 = state_28791__$1;
(statearr_28795_28823[(2)] = inst_28755);

(statearr_28795_28823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (13))){
var inst_28782 = (state_28791[(2)]);
var inst_28783 = fluree.db.util.async.throw_err.call(null,inst_28782);
var _ = (function (){var statearr_28796 = state_28791;
(statearr_28796[(4)] = cljs.core.rest.call(null,(state_28791[(4)])));

return statearr_28796;
})();
var state_28791__$1 = state_28791;
var statearr_28797_28824 = state_28791__$1;
(statearr_28797_28824[(2)] = inst_28783);

(statearr_28797_28824[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (6))){
var state_28791__$1 = state_28791;
var statearr_28799_28825 = state_28791__$1;
(statearr_28799_28825[(2)] = path);

(statearr_28799_28825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (3))){
var inst_28789 = (state_28791[(2)]);
var state_28791__$1 = state_28791;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28791__$1,inst_28789);
} else {
if((state_val_28792 === (12))){
var _ = (function (){var statearr_28800 = state_28791;
(statearr_28800[(4)] = cljs.core.rest.call(null,(state_28791[(4)])));

return statearr_28800;
})();
var state_28791__$1 = state_28791;
var ex28798 = (state_28791__$1[(2)]);
var statearr_28801_28826 = state_28791__$1;
(statearr_28801_28826[(5)] = ex28798);


var statearr_28802_28827 = state_28791__$1;
(statearr_28802_28827[(1)] = (11));

(statearr_28802_28827[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (2))){
var _ = (function (){var statearr_28803 = state_28791;
(statearr_28803[(4)] = cljs.core.cons.call(null,(5),(state_28791[(4)])));

return statearr_28803;
})();
var inst_28761 = cljs.core.vector_QMARK_.call(null,path);
var state_28791__$1 = state_28791;
if(inst_28761){
var statearr_28804_28828 = state_28791__$1;
(statearr_28804_28828[(1)] = (6));

} else {
var statearr_28805_28829 = state_28791__$1;
(statearr_28805_28829[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (11))){
var inst_28768 = (state_28791[(7)]);
var inst_28773 = (state_28791[(2)]);
var inst_28774 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28773,"relationship?",startSubject,inst_28768,endSubject);
var state_28791__$1 = state_28791;
var statearr_28807_28830 = state_28791__$1;
(statearr_28807_28830[(2)] = inst_28774);

(statearr_28807_28830[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (9))){
var inst_28772 = (state_28791[(8)]);
var _ = (function (){var statearr_28808 = state_28791;
(statearr_28808[(4)] = cljs.core.cons.call(null,(12),(state_28791[(4)])));

return statearr_28808;
})();
var inst_28780 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28772);
var state_28791__$1 = state_28791;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28791__$1,(13),inst_28780);
} else {
if((state_val_28792 === (5))){
var _ = (function (){var statearr_28809 = state_28791;
(statearr_28809[(4)] = cljs.core.rest.call(null,(state_28791[(4)])));

return statearr_28809;
})();
var state_28791__$1 = state_28791;
var ex28806 = (state_28791__$1[(2)]);
var statearr_28810_28831 = state_28791__$1;
(statearr_28810_28831[(5)] = ex28806);


if((ex28806 instanceof Error)){
var statearr_28811_28832 = state_28791__$1;
(statearr_28811_28832[(1)] = (4));

(statearr_28811_28832[(5)] = null);

} else {
throw ex28806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (10))){
var inst_28786 = (state_28791[(2)]);
var _ = (function (){var statearr_28812 = state_28791;
(statearr_28812[(4)] = cljs.core.rest.call(null,(state_28791[(4)])));

return statearr_28812;
})();
var state_28791__$1 = state_28791;
var statearr_28813_28833 = state_28791__$1;
(statearr_28813_28833[(2)] = inst_28786);

(statearr_28813_28833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28792 === (8))){
var inst_28768 = (state_28791[(7)]);
var inst_28768__$1 = (state_28791[(2)]);
var inst_28769 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28768__$1,endSubject);
var inst_28770 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28771 = ["?var1",inst_28769];
var inst_28772 = cljs.core.PersistentHashMap.fromArrays(inst_28770,inst_28771);
var state_28791__$1 = (function (){var statearr_28814 = state_28791;
(statearr_28814[(7)] = inst_28768__$1);

(statearr_28814[(8)] = inst_28772);

return statearr_28814;
})();
var statearr_28815_28834 = state_28791__$1;
(statearr_28815_28834[(2)] = null);

(statearr_28815_28834[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_28816 = [null,null,null,null,null,null,null,null,null];
(statearr_28816[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__);

(statearr_28816[(1)] = (1));

return statearr_28816;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1 = (function (state_28791){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28791);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28817){var ex__2744__auto__ = e28817;
var statearr_28818_28835 = state_28791;
(statearr_28818_28835[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28791[(4)]))){
var statearr_28819_28836 = state_28791;
(statearr_28819_28836[(1)] = cljs.core.first.call(null,(state_28791[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28837 = state_28791;
state_28791 = G__28837;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__ = function(state_28791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1.call(this,state_28791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28820 = f__2764__auto__.call(null);
(statearr_28820[(6)] = c__2763__auto__);

return statearr_28820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28838){var e = e28838;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28839){var e = e28839;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4253__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28840){var e = e28840;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28841){var e = e28841;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28844 = arguments.length;
var i__4865__auto___28845 = (0);
while(true){
if((i__4865__auto___28845 < len__4864__auto___28844)){
args__4870__auto__.push((arguments[i__4865__auto___28845]));

var G__28846 = (i__4865__auto___28845 + (1));
i__4865__auto___28845 = G__28846;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28843){var e = e28843;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28842){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28842));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28849 = arguments.length;
var i__4865__auto___28850 = (0);
while(true){
if((i__4865__auto___28850 < len__4864__auto___28849)){
args__4870__auto__.push((arguments[i__4865__auto___28850]));

var G__28851 = (i__4865__auto___28850 + (1));
i__4865__auto___28850 = G__28851;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28848){var e = e28848;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28847){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28847));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28854 = arguments.length;
var i__4865__auto___28855 = (0);
while(true){
if((i__4865__auto___28855 < len__4864__auto___28854)){
args__4870__auto__.push((arguments[i__4865__auto___28855]));

var G__28856 = (i__4865__auto___28855 + (1));
i__4865__auto___28855 = G__28856;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4253__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28853){var e = e28853;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28852){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28852));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28859 = arguments.length;
var i__4865__auto___28860 = (0);
while(true){
if((i__4865__auto___28860 < len__4864__auto___28859)){
args__4870__auto__.push((arguments[i__4865__auto___28860]));

var G__28861 = (i__4865__auto___28860 + (1));
i__4865__auto___28860 = G__28861;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28858){var e = e28858;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28857){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28857));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28862){var e = e28862;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28863){var e = e28863;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28864){var e = e28864;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28865){var e = e28865;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28866){var e = e28866;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28872 = path;
var vec__28873 = G__28872;
var seq__28874 = cljs.core.seq.call(null,vec__28873);
var first__28875 = cljs.core.first.call(null,seq__28874);
var seq__28874__$1 = cljs.core.next.call(null,seq__28874);
var pred = first__28875;
var r = seq__28874__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28872__$1 = G__28872;
var subjects__$1 = subjects;
while(true){
var vec__28879 = G__28872__$1;
var seq__28880 = cljs.core.seq.call(null,vec__28879);
var first__28881 = cljs.core.first.call(null,seq__28880);
var seq__28880__$1 = cljs.core.next.call(null,seq__28880);
var pred__$1 = first__28881;
var r__$1 = seq__28880__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28872__$1,subjects__$1,vec__28879,seq__28880,first__28881,seq__28880__$1,pred__$1,r__$1,subjects__$2,G__28872,vec__28873,seq__28874,first__28875,seq__28874__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28872__$1,subjects__$1,vec__28879,seq__28880,first__28881,seq__28880__$1,pred__$1,r__$1,subjects__$2,G__28872,vec__28873,seq__28874,first__28875,seq__28874__$1,pred,r,subjects){
return (function (p1__28867_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28867_SHARP_,pred__$1);
});})(G__28872__$1,subjects__$1,vec__28879,seq__28880,first__28881,seq__28880__$1,pred__$1,r__$1,subjects__$2,G__28872,vec__28873,seq__28874,first__28875,seq__28874__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28872__$1,subjects__$1,vec__28879,seq__28880,first__28881,seq__28880__$1,pred__$1,r__$1,subjects__$2,G__28872,vec__28873,seq__28874,first__28875,seq__28874__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4251__auto__ = r__$1;
if(and__4251__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4251__auto__;
}
})())){
var G__28882 = r__$1;
var G__28883 = next_subjects;
G__28872__$1 = G__28882;
subjects__$1 = G__28883;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28868){var e = e28868;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28884){var e = e28884;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e28885){var e = e28885;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28888 = arguments.length;
var i__4865__auto___28889 = (0);
while(true){
if((i__4865__auto___28889 < len__4864__auto___28888)){
args__4870__auto__.push((arguments[i__4865__auto___28889]));

var G__28890 = (i__4865__auto___28889 + (1));
i__4865__auto___28889 = G__28890;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28887){var e = e28887;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28886){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28886));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28891){var e = e28891;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___28894 = arguments.length;
var i__4865__auto___28895 = (0);
while(true){
if((i__4865__auto___28895 < len__4864__auto___28894)){
args__4870__auto__.push((arguments[i__4865__auto___28895]));

var G__28896 = (i__4865__auto___28895 + (1));
i__4865__auto___28895 = G__28896;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28893){var e = e28893;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28892){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28892));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28897){var e = e28897;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_28954){
var state_val_28955 = (state_28954[(1)]);
if((state_val_28955 === (7))){
var inst_28900 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
var statearr_28956_28990 = state_28954__$1;
(statearr_28956_28990[(2)] = inst_28900);

(statearr_28956_28990[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (1))){
var state_28954__$1 = state_28954;
var statearr_28957_28991 = state_28954__$1;
(statearr_28957_28991[(2)] = null);

(statearr_28957_28991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (4))){
var inst_28899 = (state_28954[(2)]);
var state_28954__$1 = (function (){var statearr_28958 = state_28954;
(statearr_28958[(7)] = inst_28899);

return statearr_28958;
})();
var statearr_28959_28992 = state_28954__$1;
(statearr_28959_28992[(2)] = null);

(statearr_28959_28992[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (15))){
var inst_28934 = (state_28954[(8)]);
var inst_28924 = (state_28954[(9)]);
var inst_28925 = (state_28954[(10)]);
var inst_28935 = (state_28954[(11)]);
var inst_28922 = (state_28954[(12)]);
var inst_28937 = (state_28954[(13)]);
var inst_28941 = (function (){var db = inst_28922;
var prevT = inst_28924;
var db_SINGLEQUOTE_ = inst_28925;
var prev_vals = inst_28934;
var fuel = inst_28935;
var G__28936 = inst_28937;
return (function (p1__28898_SHARP_){
var f = p1__28898_SHARP_;
return f.o;
});
})();
var inst_28942 = inst_28941.call(null,inst_28937);
var state_28954__$1 = state_28954;
var statearr_28960_28993 = state_28954__$1;
(statearr_28960_28993[(2)] = inst_28942);

(statearr_28960_28993[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (13))){
var inst_28934 = (state_28954[(8)]);
var inst_28937 = (state_28954[(13)]);
var inst_28933 = (state_28954[(2)]);
var inst_28934__$1 = fluree.db.util.async.throw_err.call(null,inst_28933);
var inst_28935 = fluree.db.dbfunctions.internal.count.call(null,inst_28934__$1);
var inst_28937__$1 = cljs.core.first.call(null,inst_28934__$1);
var inst_28938 = (inst_28937__$1 == null);
var state_28954__$1 = (function (){var statearr_28961 = state_28954;
(statearr_28961[(8)] = inst_28934__$1);

(statearr_28961[(11)] = inst_28935);

(statearr_28961[(13)] = inst_28937__$1);

return statearr_28961;
})();
if(cljs.core.truth_(inst_28938)){
var statearr_28962_28994 = state_28954__$1;
(statearr_28962_28994[(1)] = (14));

} else {
var statearr_28963_28995 = state_28954__$1;
(statearr_28963_28995[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (6))){
var inst_28909 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
var statearr_28964_28996 = state_28954__$1;
(statearr_28964_28996[(2)] = inst_28909);

(statearr_28964_28996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (3))){
var inst_28952 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28954__$1,inst_28952);
} else {
if((state_val_28955 === (12))){
var inst_28949 = (state_28954[(2)]);
var _ = (function (){var statearr_28965 = state_28954;
(statearr_28965[(4)] = cljs.core.rest.call(null,(state_28954[(4)])));

return statearr_28965;
})();
var state_28954__$1 = state_28954;
var statearr_28966_28997 = state_28954__$1;
(statearr_28966_28997[(2)] = inst_28949);

(statearr_28966_28997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (2))){
var _ = (function (){var statearr_28968 = state_28954;
(statearr_28968[(4)] = cljs.core.cons.call(null,(9),(state_28954[(4)])));

return statearr_28968;
})();
var inst_28915 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28916 = typeof inst_28915 === 'string';
var state_28954__$1 = state_28954;
if(cljs.core.truth_(inst_28916)){
var statearr_28969_28998 = state_28954__$1;
(statearr_28969_28998[(1)] = (10));

} else {
var statearr_28970_28999 = state_28954__$1;
(statearr_28970_28999[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (11))){
var inst_28924 = (state_28954[(9)]);
var inst_28925 = (state_28954[(10)]);
var inst_28922 = (state_28954[(12)]);
var inst_28922__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28923 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28922__$1);
var inst_28924__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_28923);
var inst_28925__$1 = cljs.core.assoc.call(null,inst_28922__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28924__$1);
var inst_28926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28927 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28928 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28929 = [inst_28927,inst_28928];
var inst_28930 = (new cljs.core.PersistentVector(null,2,(5),inst_28926,inst_28929,null));
var inst_28931 = fluree.db.dbproto._search.call(null,inst_28925__$1,inst_28930);
var state_28954__$1 = (function (){var statearr_28971 = state_28954;
(statearr_28971[(9)] = inst_28924__$1);

(statearr_28971[(10)] = inst_28925__$1);

(statearr_28971[(12)] = inst_28922__$1);

return statearr_28971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28954__$1,(13),inst_28931);
} else {
if((state_val_28955 === (9))){
var _ = (function (){var statearr_28972 = state_28954;
(statearr_28972[(4)] = cljs.core.rest.call(null,(state_28954[(4)])));

return statearr_28972;
})();
var state_28954__$1 = state_28954;
var ex28967 = (state_28954__$1[(2)]);
var statearr_28973_29000 = state_28954__$1;
(statearr_28973_29000[(5)] = ex28967);


var statearr_28974_29001 = state_28954__$1;
(statearr_28974_29001[(1)] = (4));

(statearr_28974_29001[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (5))){
var inst_28899 = (state_28954[(7)]);
var _ = (function (){var statearr_28975 = state_28954;
(statearr_28975[(4)] = cljs.core.cons.call(null,(8),(state_28954[(4)])));

return statearr_28975;
})();
var inst_28906 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28899,"?pO","Context Object");
var ___$1 = (function (){var statearr_28976 = state_28954;
(statearr_28976[(4)] = cljs.core.rest.call(null,(state_28954[(4)])));

return statearr_28976;
})();
var state_28954__$1 = state_28954;
var statearr_28977_29002 = state_28954__$1;
(statearr_28977_29002[(2)] = inst_28906);

(statearr_28977_29002[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (14))){
var state_28954__$1 = state_28954;
var statearr_28978_29003 = state_28954__$1;
(statearr_28978_29003[(2)] = null);

(statearr_28978_29003[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (16))){
var inst_28935 = (state_28954[(11)]);
var inst_28944 = (state_28954[(2)]);
var inst_28945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28946 = [inst_28944,inst_28935];
var inst_28947 = (new cljs.core.PersistentVector(null,2,(5),inst_28945,inst_28946,null));
var state_28954__$1 = state_28954;
var statearr_28980_29004 = state_28954__$1;
(statearr_28980_29004[(2)] = inst_28947);

(statearr_28980_29004[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (10))){
var inst_28918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28919 = [null,(0)];
var inst_28920 = (new cljs.core.PersistentVector(null,2,(5),inst_28918,inst_28919,null));
var state_28954__$1 = state_28954;
var statearr_28981_29005 = state_28954__$1;
(statearr_28981_29005[(2)] = inst_28920);

(statearr_28981_29005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (8))){
var _ = (function (){var statearr_28982 = state_28954;
(statearr_28982[(4)] = cljs.core.rest.call(null,(state_28954[(4)])));

return statearr_28982;
})();
var state_28954__$1 = state_28954;
var ex28979 = (state_28954__$1[(2)]);
var statearr_28983_29006 = state_28954__$1;
(statearr_28983_29006[(5)] = ex28979);


var statearr_28984_29007 = state_28954__$1;
(statearr_28984_29007[(1)] = (7));

(statearr_28984_29007[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0 = (function (){
var statearr_28985 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28985[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__);

(statearr_28985[(1)] = (1));

return statearr_28985;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1 = (function (state_28954){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_28954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e28986){var ex__2744__auto__ = e28986;
var statearr_28987_29008 = state_28954;
(statearr_28987_29008[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_28954[(4)]))){
var statearr_28988_29009 = state_28954;
(statearr_28988_29009[(1)] = cljs.core.first.call(null,(state_28954[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29010 = state_28954;
state_28954 = G__29010;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__ = function(state_28954){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1.call(this,state_28954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_28989 = f__2764__auto__.call(null);
(statearr_28989[(6)] = c__2763__auto__);

return statearr_28989;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29062){
var state_val_29063 = (state_29062[(1)]);
if((state_val_29063 === (7))){
var inst_29012 = (state_29062[(2)]);
var state_29062__$1 = state_29062;
var statearr_29064_29093 = state_29062__$1;
(statearr_29064_29093[(2)] = inst_29012);

(statearr_29064_29093[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (1))){
var state_29062__$1 = state_29062;
var statearr_29065_29094 = state_29062__$1;
(statearr_29065_29094[(2)] = null);

(statearr_29065_29094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (4))){
var inst_29011 = (state_29062[(2)]);
var state_29062__$1 = (function (){var statearr_29066 = state_29062;
(statearr_29066[(7)] = inst_29011);

return statearr_29066;
})();
var statearr_29067_29095 = state_29062__$1;
(statearr_29067_29095[(2)] = null);

(statearr_29067_29095[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (13))){
var inst_29057 = (state_29062[(2)]);
var _ = (function (){var statearr_29068 = state_29062;
(statearr_29068[(4)] = cljs.core.rest.call(null,(state_29062[(4)])));

return statearr_29068;
})();
var state_29062__$1 = state_29062;
var statearr_29069_29096 = state_29062__$1;
(statearr_29069_29096[(2)] = inst_29057);

(statearr_29069_29096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (6))){
var inst_29021 = (state_29062[(2)]);
var state_29062__$1 = state_29062;
var statearr_29070_29097 = state_29062__$1;
(statearr_29070_29097[(2)] = inst_29021);

(statearr_29070_29097[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (3))){
var inst_29060 = (state_29062[(2)]);
var state_29062__$1 = state_29062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29062__$1,inst_29060);
} else {
if((state_val_29063 === (12))){
var inst_29044 = (state_29062[(8)]);
var inst_29053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29054 = [null,inst_29044];
var inst_29055 = (new cljs.core.PersistentVector(null,2,(5),inst_29053,inst_29054,null));
var state_29062__$1 = state_29062;
var statearr_29071_29098 = state_29062__$1;
(statearr_29071_29098[(2)] = inst_29055);

(statearr_29071_29098[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (2))){
var _ = (function (){var statearr_29073 = state_29062;
(statearr_29073[(4)] = cljs.core.cons.call(null,(9),(state_29062[(4)])));

return statearr_29073;
})();
var inst_29030 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29033 = [null,pred_name,"?o"];
var inst_29034 = (new cljs.core.PersistentVector(null,3,(5),inst_29032,inst_29033,null));
var inst_29035 = [inst_29034];
var inst_29036 = (new cljs.core.PersistentVector(null,1,(5),inst_29031,inst_29035,null));
var inst_29037 = ["?o",inst_29036,opts];
var inst_29038 = cljs.core.PersistentHashMap.fromArrays(inst_29030,inst_29037);
var inst_29039 = fluree.db.dbfunctions.internal.query.call(null,db,inst_29038);
var state_29062__$1 = state_29062;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29062__$1,(10),inst_29039);
} else {
if((state_val_29063 === (11))){
var inst_29043 = (state_29062[(9)]);
var inst_29044 = (state_29062[(8)]);
var inst_29048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29049 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_29043);
var inst_29050 = [inst_29049,inst_29044];
var inst_29051 = (new cljs.core.PersistentVector(null,2,(5),inst_29048,inst_29050,null));
var state_29062__$1 = state_29062;
var statearr_29074_29099 = state_29062__$1;
(statearr_29074_29099[(2)] = inst_29051);

(statearr_29074_29099[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (9))){
var _ = (function (){var statearr_29075 = state_29062;
(statearr_29075[(4)] = cljs.core.rest.call(null,(state_29062[(4)])));

return statearr_29075;
})();
var state_29062__$1 = state_29062;
var ex29072 = (state_29062__$1[(2)]);
var statearr_29076_29100 = state_29062__$1;
(statearr_29076_29100[(5)] = ex29072);


var statearr_29077_29101 = state_29062__$1;
(statearr_29077_29101[(1)] = (4));

(statearr_29077_29101[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (5))){
var inst_29011 = (state_29062[(7)]);
var _ = (function (){var statearr_29079 = state_29062;
(statearr_29079[(4)] = cljs.core.cons.call(null,(8),(state_29062[(4)])));

return statearr_29079;
})();
var inst_29018 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29011,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_29080 = state_29062;
(statearr_29080[(4)] = cljs.core.rest.call(null,(state_29062[(4)])));

return statearr_29080;
})();
var state_29062__$1 = state_29062;
var statearr_29081_29102 = state_29062__$1;
(statearr_29081_29102[(2)] = inst_29018);

(statearr_29081_29102[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (10))){
var inst_29043 = (state_29062[(9)]);
var inst_29041 = (state_29062[(2)]);
var inst_29042 = fluree.db.util.async.throw_err.call(null,inst_29041);
var inst_29043__$1 = cljs.core.nth.call(null,inst_29042,(0),null);
var inst_29044 = cljs.core.nth.call(null,inst_29042,(1),null);
var inst_29045 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_29043__$1);
var inst_29046 = cljs.core.not.call(null,inst_29045);
var state_29062__$1 = (function (){var statearr_29082 = state_29062;
(statearr_29082[(9)] = inst_29043__$1);

(statearr_29082[(8)] = inst_29044);

return statearr_29082;
})();
if(inst_29046){
var statearr_29083_29103 = state_29062__$1;
(statearr_29083_29103[(1)] = (11));

} else {
var statearr_29084_29104 = state_29062__$1;
(statearr_29084_29104[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29063 === (8))){
var _ = (function (){var statearr_29085 = state_29062;
(statearr_29085[(4)] = cljs.core.rest.call(null,(state_29062[(4)])));

return statearr_29085;
})();
var state_29062__$1 = state_29062;
var ex29078 = (state_29062__$1[(2)]);
var statearr_29086_29105 = state_29062__$1;
(statearr_29086_29105[(5)] = ex29078);


var statearr_29087_29106 = state_29062__$1;
(statearr_29087_29106[(1)] = (7));

(statearr_29087_29106[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0 = (function (){
var statearr_29088 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29088[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__);

(statearr_29088[(1)] = (1));

return statearr_29088;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1 = (function (state_29062){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29089){var ex__2744__auto__ = e29089;
var statearr_29090_29107 = state_29062;
(statearr_29090_29107[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29062[(4)]))){
var statearr_29091_29108 = state_29062;
(statearr_29091_29108[(1)] = cljs.core.first.call(null,(state_29062[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29109 = state_29062;
state_29062 = G__29109;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__ = function(state_29062){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1.call(this,state_29062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29092 = f__2764__auto__.call(null);
(statearr_29092[(6)] = c__2763__auto__);

return statearr_29092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__4251__auto__ = typeof email === 'string';
if(and__4251__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__4251__auto__;
}
})());
}catch (e29110){var e = e29110;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29112 = arguments.length;
switch (G__29112) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29182){
var state_val_29183 = (state_29182[(1)]);
if((state_val_29183 === (7))){
var inst_29114 = (state_29182[(2)]);
var state_29182__$1 = state_29182;
var statearr_29184_29228 = state_29182__$1;
(statearr_29184_29228[(2)] = inst_29114);

(statearr_29184_29228[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (20))){
var inst_29158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29159 = ["*"];
var inst_29160 = (new cljs.core.PersistentVector(null,1,(5),inst_29158,inst_29159,null));
var state_29182__$1 = state_29182;
var statearr_29185_29229 = state_29182__$1;
(statearr_29185_29229[(2)] = inst_29160);

(statearr_29185_29229[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (1))){
var state_29182__$1 = state_29182;
var statearr_29186_29230 = state_29182__$1;
(statearr_29186_29230[(2)] = null);

(statearr_29186_29230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (4))){
var inst_29113 = (state_29182[(2)]);
var state_29182__$1 = (function (){var statearr_29187 = state_29182;
(statearr_29187[(7)] = inst_29113);

return statearr_29187;
})();
var statearr_29188_29231 = state_29182__$1;
(statearr_29188_29231[(2)] = null);

(statearr_29188_29231[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (15))){
var inst_29177 = (state_29182[(2)]);
var _ = (function (){var statearr_29189 = state_29182;
(statearr_29189[(4)] = cljs.core.rest.call(null,(state_29182[(4)])));

return statearr_29189;
})();
var state_29182__$1 = state_29182;
var statearr_29190_29232 = state_29182__$1;
(statearr_29190_29232[(2)] = inst_29177);

(statearr_29190_29232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (21))){
var inst_29141 = (state_29182[(8)]);
var inst_29148 = (state_29182[(9)]);
var inst_29162 = (state_29182[(2)]);
var inst_29163 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29164 = cljs.core.PersistentHashMap.EMPTY;
var inst_29165 = [inst_29162,inst_29148,inst_29164];
var inst_29166 = cljs.core.PersistentHashMap.fromArrays(inst_29163,inst_29165);
var inst_29167 = fluree.db.dbfunctions.internal.query.call(null,inst_29141,inst_29166);
var state_29182__$1 = state_29182;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29182__$1,(22),inst_29167);
} else {
if((state_val_29183 === (13))){
var inst_29136 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29182__$1 = state_29182;
var statearr_29191_29233 = state_29182__$1;
(statearr_29191_29233[(2)] = inst_29136);

(statearr_29191_29233[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (22))){
var inst_29169 = (state_29182[(2)]);
var inst_29170 = fluree.db.util.async.throw_err.call(null,inst_29169);
var inst_29171 = cljs.core.nth.call(null,inst_29170,(0),null);
var inst_29172 = cljs.core.nth.call(null,inst_29170,(1),null);
var inst_29173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29174 = [inst_29171,inst_29172];
var inst_29175 = (new cljs.core.PersistentVector(null,2,(5),inst_29173,inst_29174,null));
var state_29182__$1 = state_29182;
var statearr_29192_29234 = state_29182__$1;
(statearr_29192_29234[(2)] = inst_29175);

(statearr_29192_29234[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (6))){
var inst_29123 = (state_29182[(2)]);
var state_29182__$1 = state_29182;
var statearr_29193_29235 = state_29182__$1;
(statearr_29193_29235[(2)] = inst_29123);

(statearr_29193_29235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (17))){
var inst_29145 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29146 = fluree.db.dbfunctions.internal.get.call(null,inst_29145,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29182__$1 = state_29182;
var statearr_29194_29236 = state_29182__$1;
(statearr_29194_29236[(2)] = inst_29146);

(statearr_29194_29236[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (3))){
var inst_29180 = (state_29182[(2)]);
var state_29182__$1 = state_29182;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29182__$1,inst_29180);
} else {
if((state_val_29183 === (12))){
var inst_29134 = (state_29182[(2)]);
var state_29182__$1 = state_29182;
if(cljs.core.truth_(inst_29134)){
var statearr_29195_29237 = state_29182__$1;
(statearr_29195_29237[(1)] = (13));

} else {
var statearr_29196_29238 = state_29182__$1;
(statearr_29196_29238[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (2))){
var inst_29129 = (state_29182[(10)]);
var _ = (function (){var statearr_29197 = state_29182;
(statearr_29197[(4)] = cljs.core.cons.call(null,(9),(state_29182[(4)])));

return statearr_29197;
})();
var inst_29129__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29182__$1 = (function (){var statearr_29198 = state_29182;
(statearr_29198[(10)] = inst_29129__$1);

return statearr_29198;
})();
if(cljs.core.truth_(inst_29129__$1)){
var statearr_29199_29239 = state_29182__$1;
(statearr_29199_29239[(1)] = (10));

} else {
var statearr_29200_29240 = state_29182__$1;
(statearr_29200_29240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (19))){
var inst_29150 = cljs.core.PersistentVector.EMPTY;
var inst_29151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29152 = ["*"];
var inst_29153 = (new cljs.core.PersistentVector(null,1,(5),inst_29151,inst_29152,null));
var inst_29154 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29155 = cljs.core.concat.call(null,inst_29153,inst_29154);
var inst_29156 = cljs.core.into.call(null,inst_29150,inst_29155);
var state_29182__$1 = state_29182;
var statearr_29202_29241 = state_29182__$1;
(statearr_29202_29241[(2)] = inst_29156);

(statearr_29202_29241[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (11))){
var inst_29129 = (state_29182[(10)]);
var state_29182__$1 = state_29182;
var statearr_29203_29242 = state_29182__$1;
(statearr_29203_29242[(2)] = inst_29129);

(statearr_29203_29242[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (9))){
var _ = (function (){var statearr_29204 = state_29182;
(statearr_29204[(4)] = cljs.core.rest.call(null,(state_29182[(4)])));

return statearr_29204;
})();
var state_29182__$1 = state_29182;
var ex29201 = (state_29182__$1[(2)]);
var statearr_29205_29243 = state_29182__$1;
(statearr_29205_29243[(5)] = ex29201);


var statearr_29206_29244 = state_29182__$1;
(statearr_29206_29244[(1)] = (4));

(statearr_29206_29244[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (5))){
var inst_29113 = (state_29182[(7)]);
var _ = (function (){var statearr_29207 = state_29182;
(statearr_29207[(4)] = cljs.core.cons.call(null,(8),(state_29182[(4)])));

return statearr_29207;
})();
var inst_29120 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29113,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_29208 = state_29182;
(statearr_29208[(4)] = cljs.core.rest.call(null,(state_29182[(4)])));

return statearr_29208;
})();
var state_29182__$1 = state_29182;
var statearr_29209_29245 = state_29182__$1;
(statearr_29209_29245[(2)] = inst_29120);

(statearr_29209_29245[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (14))){
var inst_29142 = (state_29182[(11)]);
var inst_29141 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29142__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29182__$1 = (function (){var statearr_29210 = state_29182;
(statearr_29210[(8)] = inst_29141);

(statearr_29210[(11)] = inst_29142__$1);

return statearr_29210;
})();
if(cljs.core.truth_(inst_29142__$1)){
var statearr_29211_29246 = state_29182__$1;
(statearr_29211_29246[(1)] = (16));

} else {
var statearr_29212_29247 = state_29182__$1;
(statearr_29212_29247[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (16))){
var inst_29142 = (state_29182[(11)]);
var state_29182__$1 = state_29182;
var statearr_29213_29248 = state_29182__$1;
(statearr_29213_29248[(2)] = inst_29142);

(statearr_29213_29248[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (10))){
var inst_29131 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_29182__$1 = state_29182;
var statearr_29215_29249 = state_29182__$1;
(statearr_29215_29249[(2)] = inst_29131);

(statearr_29215_29249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (18))){
var inst_29148 = (state_29182[(2)]);
var state_29182__$1 = (function (){var statearr_29216 = state_29182;
(statearr_29216[(9)] = inst_29148);

return statearr_29216;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29217_29250 = state_29182__$1;
(statearr_29217_29250[(1)] = (19));

} else {
var statearr_29218_29251 = state_29182__$1;
(statearr_29218_29251[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29183 === (8))){
var _ = (function (){var statearr_29219 = state_29182;
(statearr_29219[(4)] = cljs.core.rest.call(null,(state_29182[(4)])));

return statearr_29219;
})();
var state_29182__$1 = state_29182;
var ex29214 = (state_29182__$1[(2)]);
var statearr_29220_29252 = state_29182__$1;
(statearr_29220_29252[(5)] = ex29214);


var statearr_29221_29253 = state_29182__$1;
(statearr_29221_29253[(1)] = (7));

(statearr_29221_29253[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_29222 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29222[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_29222[(1)] = (1));

return statearr_29222;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_29182){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29182);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29223){var ex__2744__auto__ = e29223;
var statearr_29224_29254 = state_29182;
(statearr_29224_29254[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29182[(4)]))){
var statearr_29225_29255 = state_29182;
(statearr_29225_29255[(1)] = cljs.core.first.call(null,(state_29182[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29256 = state_29182;
state_29182 = G__29256;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_29182){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_29182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29226 = f__2764__auto__.call(null);
(statearr_29226[(6)] = c__2763__auto__);

return statearr_29226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29258 = arguments.length;
switch (G__29258) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29302){
var state_val_29303 = (state_29302[(1)]);
if((state_val_29303 === (7))){
var inst_29280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29281 = ["*"];
var inst_29282 = (new cljs.core.PersistentVector(null,1,(5),inst_29280,inst_29281,null));
var state_29302__$1 = state_29302;
var statearr_29304_29324 = state_29302__$1;
(statearr_29304_29324[(2)] = inst_29282);

(statearr_29304_29324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (1))){
var state_29302__$1 = state_29302;
var statearr_29305_29325 = state_29302__$1;
(statearr_29305_29325[(2)] = null);

(statearr_29305_29325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (4))){
var inst_29259 = (state_29302[(2)]);
var inst_29260 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29259,"?p","Context Object",additional_params);
var state_29302__$1 = state_29302;
var statearr_29306_29326 = state_29302__$1;
(statearr_29306_29326[(2)] = inst_29260);

(statearr_29306_29326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (6))){
var inst_29272 = cljs.core.PersistentVector.EMPTY;
var inst_29273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29274 = ["*"];
var inst_29275 = (new cljs.core.PersistentVector(null,1,(5),inst_29273,inst_29274,null));
var inst_29276 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_29277 = cljs.core.concat.call(null,inst_29275,inst_29276);
var inst_29278 = cljs.core.into.call(null,inst_29272,inst_29277);
var state_29302__$1 = state_29302;
var statearr_29307_29327 = state_29302__$1;
(statearr_29307_29327[(2)] = inst_29278);

(statearr_29307_29327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (3))){
var inst_29300 = (state_29302[(2)]);
var state_29302__$1 = state_29302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29302__$1,inst_29300);
} else {
if((state_val_29303 === (2))){
var _ = (function (){var statearr_29309 = state_29302;
(statearr_29309[(4)] = cljs.core.cons.call(null,(5),(state_29302[(4)])));

return statearr_29309;
})();
var inst_29269 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29270 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29302__$1 = (function (){var statearr_29310 = state_29302;
(statearr_29310[(7)] = inst_29270);

(statearr_29310[(8)] = inst_29269);

return statearr_29310;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29311_29328 = state_29302__$1;
(statearr_29311_29328[(1)] = (6));

} else {
var statearr_29312_29329 = state_29302__$1;
(statearr_29312_29329[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (9))){
var inst_29291 = (state_29302[(2)]);
var inst_29292 = fluree.db.util.async.throw_err.call(null,inst_29291);
var inst_29293 = cljs.core.nth.call(null,inst_29292,(0),null);
var inst_29294 = cljs.core.nth.call(null,inst_29292,(1),null);
var inst_29295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29296 = [inst_29293,inst_29294];
var inst_29297 = (new cljs.core.PersistentVector(null,2,(5),inst_29295,inst_29296,null));
var _ = (function (){var statearr_29313 = state_29302;
(statearr_29313[(4)] = cljs.core.rest.call(null,(state_29302[(4)])));

return statearr_29313;
})();
var state_29302__$1 = state_29302;
var statearr_29314_29330 = state_29302__$1;
(statearr_29314_29330[(2)] = inst_29297);

(statearr_29314_29330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (5))){
var _ = (function (){var statearr_29315 = state_29302;
(statearr_29315[(4)] = cljs.core.rest.call(null,(state_29302[(4)])));

return statearr_29315;
})();
var state_29302__$1 = state_29302;
var ex29308 = (state_29302__$1[(2)]);
var statearr_29316_29331 = state_29302__$1;
(statearr_29316_29331[(5)] = ex29308);


var statearr_29317_29332 = state_29302__$1;
(statearr_29317_29332[(1)] = (4));

(statearr_29317_29332[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29303 === (8))){
var inst_29270 = (state_29302[(7)]);
var inst_29269 = (state_29302[(8)]);
var inst_29284 = (state_29302[(2)]);
var inst_29285 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29286 = cljs.core.PersistentHashMap.EMPTY;
var inst_29287 = [inst_29284,inst_29270,inst_29286];
var inst_29288 = cljs.core.PersistentHashMap.fromArrays(inst_29285,inst_29287);
var inst_29289 = fluree.db.dbfunctions.internal.query.call(null,inst_29269,inst_29288);
var state_29302__$1 = state_29302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29302__$1,(9),inst_29289);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2741__auto____0 = (function (){
var statearr_29318 = [null,null,null,null,null,null,null,null,null];
(statearr_29318[(0)] = fluree$db$dbfunctions$internal$state_machine__2741__auto__);

(statearr_29318[(1)] = (1));

return statearr_29318;
});
var fluree$db$dbfunctions$internal$state_machine__2741__auto____1 = (function (state_29302){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29319){var ex__2744__auto__ = e29319;
var statearr_29320_29333 = state_29302;
(statearr_29320_29333[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29302[(4)]))){
var statearr_29321_29334 = state_29302;
(statearr_29321_29334[(1)] = cljs.core.first.call(null,(state_29302[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29335 = state_29302;
state_29302 = G__29335;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2741__auto__ = function(state_29302){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2741__auto____1.call(this,state_29302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29322 = f__2764__auto__.call(null);
(statearr_29322[(6)] = c__2763__auto__);

return statearr_29322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29379){
var state_val_29380 = (state_29379[(1)]);
if((state_val_29380 === (1))){
var state_29379__$1 = state_29379;
var statearr_29381_29395 = state_29379__$1;
(statearr_29381_29395[(2)] = null);

(statearr_29381_29395[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29380 === (2))){
var _ = (function (){var statearr_29382 = state_29379;
(statearr_29382[(4)] = cljs.core.cons.call(null,(5),(state_29379[(4)])));

return statearr_29382;
})();
var inst_29346 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29348 = ["_user/_auth"];
var inst_29349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29350 = ["*"];
var inst_29351 = (new cljs.core.PersistentVector(null,1,(5),inst_29349,inst_29350,null));
var inst_29352 = [inst_29351];
var inst_29353 = cljs.core.PersistentHashMap.fromArrays(inst_29348,inst_29352);
var inst_29354 = [inst_29353];
var inst_29355 = (new cljs.core.PersistentVector(null,1,(5),inst_29347,inst_29354,null));
var inst_29356 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29357 = cljs.core.PersistentHashMap.EMPTY;
var inst_29358 = [inst_29355,inst_29356,inst_29357];
var inst_29359 = cljs.core.PersistentHashMap.fromArrays(inst_29346,inst_29358);
var inst_29360 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29361 = fluree.db.dbfunctions.internal.query.call(null,inst_29360,inst_29359);
var state_29379__$1 = state_29379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29379__$1,(6),inst_29361);
} else {
if((state_val_29380 === (3))){
var inst_29377 = (state_29379[(2)]);
var state_29379__$1 = state_29379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29379__$1,inst_29377);
} else {
if((state_val_29380 === (4))){
var inst_29336 = (state_29379[(2)]);
var inst_29337 = fluree.db.dbfunctions.internal.function_error.call(null,inst_29336,"?user_id-from-auth","Context Object");
var state_29379__$1 = state_29379;
var statearr_29384_29396 = state_29379__$1;
(statearr_29384_29396[(2)] = inst_29337);

(statearr_29384_29396[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29380 === (5))){
var _ = (function (){var statearr_29385 = state_29379;
(statearr_29385[(4)] = cljs.core.rest.call(null,(state_29379[(4)])));

return statearr_29385;
})();
var state_29379__$1 = state_29379;
var ex29383 = (state_29379__$1[(2)]);
var statearr_29386_29397 = state_29379__$1;
(statearr_29386_29397[(5)] = ex29383);


var statearr_29387_29398 = state_29379__$1;
(statearr_29387_29398[(1)] = (4));

(statearr_29387_29398[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29380 === (6))){
var inst_29363 = (state_29379[(2)]);
var inst_29364 = fluree.db.util.async.throw_err.call(null,inst_29363);
var inst_29365 = cljs.core.nth.call(null,inst_29364,(0),null);
var inst_29366 = cljs.core.nth.call(null,inst_29364,(1),null);
var inst_29367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29368 = ["_user/_auth","_id"];
var inst_29369 = (new cljs.core.PersistentVector(null,2,(5),inst_29367,inst_29368,null));
var inst_29370 = fluree.db.dbfunctions.internal.get_in.call(null,inst_29365,inst_29369);
var inst_29371 = cljs.core.first.call(null,inst_29370);
var inst_29372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29373 = [inst_29371,inst_29366];
var inst_29374 = (new cljs.core.PersistentVector(null,2,(5),inst_29372,inst_29373,null));
var _ = (function (){var statearr_29388 = state_29379;
(statearr_29388[(4)] = cljs.core.rest.call(null,(state_29379[(4)])));

return statearr_29388;
})();
var state_29379__$1 = state_29379;
var statearr_29389_29399 = state_29379__$1;
(statearr_29389_29399[(2)] = inst_29374);

(statearr_29389_29399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0 = (function (){
var statearr_29390 = [null,null,null,null,null,null,null];
(statearr_29390[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__);

(statearr_29390[(1)] = (1));

return statearr_29390;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1 = (function (state_29379){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29391){var ex__2744__auto__ = e29391;
var statearr_29392_29400 = state_29379;
(statearr_29392_29400[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29379[(4)]))){
var statearr_29393_29401 = state_29379;
(statearr_29393_29401[(1)] = cljs.core.first.call(null,(state_29379[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29402 = state_29379;
state_29379 = G__29402;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__ = function(state_29379){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1.call(this,state_29379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29394 = f__2764__auto__.call(null);
(statearr_29394[(6)] = c__2763__auto__);

return statearr_29394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29419){
var state_val_29420 = (state_29419[(1)]);
if((state_val_29420 === (1))){
var state_29419__$1 = state_29419;
var statearr_29421_29435 = state_29419__$1;
(statearr_29421_29435[(2)] = null);

(statearr_29421_29435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29420 === (2))){
var _ = (function (){var statearr_29422 = state_29419;
(statearr_29422[(4)] = cljs.core.cons.call(null,(5),(state_29419[(4)])));

return statearr_29422;
})();
var inst_29409 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29410 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29411 = fluree.db.dbproto._subid.call(null,inst_29410,inst_29409);
var state_29419__$1 = state_29419;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29419__$1,(6),inst_29411);
} else {
if((state_val_29420 === (3))){
var inst_29417 = (state_29419[(2)]);
var state_29419__$1 = state_29419;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29419__$1,inst_29417);
} else {
if((state_val_29420 === (4))){
var inst_29403 = (state_29419[(2)]);
var state_29419__$1 = state_29419;
var statearr_29424_29436 = state_29419__$1;
(statearr_29424_29436[(2)] = inst_29403);

(statearr_29424_29436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29420 === (5))){
var _ = (function (){var statearr_29425 = state_29419;
(statearr_29425[(4)] = cljs.core.rest.call(null,(state_29419[(4)])));

return statearr_29425;
})();
var state_29419__$1 = state_29419;
var ex29423 = (state_29419__$1[(2)]);
var statearr_29426_29437 = state_29419__$1;
(statearr_29426_29437[(5)] = ex29423);


if((ex29423 instanceof Error)){
var statearr_29427_29438 = state_29419__$1;
(statearr_29427_29438[(1)] = (4));

(statearr_29427_29438[(5)] = null);

} else {
throw ex29423;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29420 === (6))){
var inst_29413 = (state_29419[(2)]);
var inst_29414 = fluree.db.util.async.throw_err.call(null,inst_29413);
var _ = (function (){var statearr_29428 = state_29419;
(statearr_29428[(4)] = cljs.core.rest.call(null,(state_29419[(4)])));

return statearr_29428;
})();
var state_29419__$1 = state_29419;
var statearr_29429_29439 = state_29419__$1;
(statearr_29429_29439[(2)] = inst_29414);

(statearr_29429_29439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0 = (function (){
var statearr_29430 = [null,null,null,null,null,null,null];
(statearr_29430[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__);

(statearr_29430[(1)] = (1));

return statearr_29430;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1 = (function (state_29419){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29419);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29431){var ex__2744__auto__ = e29431;
var statearr_29432_29440 = state_29419;
(statearr_29432_29440[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29419[(4)]))){
var statearr_29433_29441 = state_29419;
(statearr_29433_29441[(1)] = cljs.core.first.call(null,(state_29419[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29442 = state_29419;
state_29419 = G__29442;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__ = function(state_29419){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1.call(this,state_29419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29434 = f__2764__auto__.call(null);
(statearr_29434[(6)] = c__2763__auto__);

return statearr_29434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29443_SHARP_){
return p1__29443_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29444_SHARP_){
return p1__29444_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29445){var e = e29445;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29446_SHARP_){
return p1__29446_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29447_SHARP_){
return p1__29447_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29448){var e = e29448;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29449){var e = e29449;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_29529){
var state_val_29530 = (state_29529[(1)]);
if((state_val_29530 === (7))){
var inst_29468 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29470 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29471 = cljs.core.PersistentHashMap.fromArrays(inst_29469,inst_29470);
var inst_29472 = cljs.core.ex_info.call(null,inst_29468,inst_29471);
var inst_29473 = (function(){throw inst_29472})();
var state_29529__$1 = state_29529;
var statearr_29531_29566 = state_29529__$1;
(statearr_29531_29566[(2)] = inst_29473);

(statearr_29531_29566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (1))){
var state_29529__$1 = state_29529;
var statearr_29532_29567 = state_29529__$1;
(statearr_29532_29567[(2)] = null);

(statearr_29532_29567[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (4))){
var inst_29450 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
var statearr_29533_29568 = state_29529__$1;
(statearr_29533_29568[(2)] = inst_29450);

(statearr_29533_29568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (15))){
var inst_29513 = (state_29529[(7)]);
var inst_29509 = (state_29529[(2)]);
var inst_29510 = fluree.db.util.async.throw_err.call(null,inst_29509);
var inst_29511 = cljs.core.nth.call(null,inst_29510,(0),null);
var inst_29512 = cljs.core.nth.call(null,inst_29510,(1),null);
var inst_29513__$1 = cljs.core.first.call(null,inst_29511);
var inst_29514 = cljs.core._EQ_.call(null,inst_29513__$1,compare_val);
var state_29529__$1 = (function (){var statearr_29534 = state_29529;
(statearr_29534[(7)] = inst_29513__$1);

(statearr_29534[(8)] = inst_29512);

return statearr_29534;
})();
if(inst_29514){
var statearr_29535_29569 = state_29529__$1;
(statearr_29535_29569[(1)] = (16));

} else {
var statearr_29536_29570 = state_29529__$1;
(statearr_29536_29570[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (13))){
var state_29529__$1 = state_29529;
var statearr_29537_29571 = state_29529__$1;
(statearr_29537_29571[(2)] = null);

(statearr_29537_29571[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (6))){
var state_29529__$1 = state_29529;
var statearr_29538_29572 = state_29529__$1;
(statearr_29538_29572[(2)] = null);

(statearr_29538_29572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (17))){
var inst_29513 = (state_29529[(7)]);
var inst_29517 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29513)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29518 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29519 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29520 = cljs.core.PersistentHashMap.fromArrays(inst_29518,inst_29519);
var inst_29521 = cljs.core.ex_info.call(null,inst_29517,inst_29520);
var inst_29522 = (function(){throw inst_29521})();
var state_29529__$1 = state_29529;
var statearr_29539_29573 = state_29529__$1;
(statearr_29539_29573[(2)] = inst_29522);

(statearr_29539_29573[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (3))){
var inst_29527 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29529__$1,inst_29527);
} else {
if((state_val_29530 === (12))){
var inst_29465 = (state_29529[(9)]);
var inst_29488 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29465);
var inst_29489 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29490 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29491 = cljs.core.PersistentHashMap.fromArrays(inst_29489,inst_29490);
var inst_29492 = cljs.core.ex_info.call(null,inst_29488,inst_29491);
var inst_29493 = (function(){throw inst_29492})();
var state_29529__$1 = state_29529;
var statearr_29540_29574 = state_29529__$1;
(statearr_29540_29574[(2)] = inst_29493);

(statearr_29540_29574[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (2))){
var inst_29462 = (state_29529[(10)]);
var inst_29463 = (state_29529[(11)]);
var inst_29464 = (state_29529[(12)]);
var _ = (function (){var statearr_29541 = state_29529;
(statearr_29541[(4)] = cljs.core.cons.call(null,(5),(state_29529[(4)])));

return statearr_29541;
})();
var inst_29460 = _QMARK_ctx;
var inst_29461 = cljs.core.__destructure_map.call(null,inst_29460);
var inst_29462__$1 = cljs.core.get.call(null,inst_29461,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29463__$1 = cljs.core.get.call(null,inst_29461,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29464__$1 = cljs.core.get.call(null,inst_29461,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29465 = fluree.db.dbproto._p_prop.call(null,inst_29464__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29463__$1);
var state_29529__$1 = (function (){var statearr_29542 = state_29529;
(statearr_29542[(9)] = inst_29465);

(statearr_29542[(10)] = inst_29462__$1);

(statearr_29542[(11)] = inst_29463__$1);

(statearr_29542[(12)] = inst_29464__$1);

return statearr_29542;
})();
if(cljs.core.truth_(inst_29462__$1)){
var statearr_29543_29575 = state_29529__$1;
(statearr_29543_29575[(1)] = (6));

} else {
var statearr_29544_29576 = state_29529__$1;
(statearr_29544_29576[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (11))){
var inst_29463 = (state_29529[(11)]);
var inst_29464 = (state_29529[(12)]);
var inst_29485 = (state_29529[(2)]);
var inst_29486 = fluree.db.dbproto._p_prop.call(null,inst_29464,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29463);
var state_29529__$1 = (function (){var statearr_29546 = state_29529;
(statearr_29546[(13)] = inst_29485);

return statearr_29546;
})();
if(cljs.core.truth_(inst_29486)){
var statearr_29547_29577 = state_29529__$1;
(statearr_29547_29577[(1)] = (12));

} else {
var statearr_29548_29578 = state_29529__$1;
(statearr_29548_29578[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (9))){
var state_29529__$1 = state_29529;
var statearr_29549_29579 = state_29529__$1;
(statearr_29549_29579[(2)] = null);

(statearr_29549_29579[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (5))){
var _ = (function (){var statearr_29550 = state_29529;
(statearr_29550[(4)] = cljs.core.rest.call(null,(state_29529[(4)])));

return statearr_29550;
})();
var state_29529__$1 = state_29529;
var ex29545 = (state_29529__$1[(2)]);
var statearr_29551_29580 = state_29529__$1;
(statearr_29551_29580[(5)] = ex29545);


if((ex29545 instanceof Error)){
var statearr_29552_29581 = state_29529__$1;
(statearr_29552_29581[(1)] = (4));

(statearr_29552_29581[(5)] = null);

} else {
throw ex29545;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (14))){
var inst_29465 = (state_29529[(9)]);
var inst_29462 = (state_29529[(10)]);
var inst_29464 = (state_29529[(12)]);
var inst_29496 = (state_29529[(2)]);
var inst_29497 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29500 = [inst_29462,inst_29465,"?current-val"];
var inst_29501 = (new cljs.core.PersistentVector(null,3,(5),inst_29499,inst_29500,null));
var inst_29502 = [inst_29501];
var inst_29503 = (new cljs.core.PersistentVector(null,1,(5),inst_29498,inst_29502,null));
var inst_29504 = cljs.core.PersistentHashMap.EMPTY;
var inst_29505 = ["?current-val",inst_29503,inst_29504];
var inst_29506 = cljs.core.PersistentHashMap.fromArrays(inst_29497,inst_29505);
var inst_29507 = fluree.db.dbfunctions.internal.query.call(null,inst_29464,inst_29506);
var state_29529__$1 = (function (){var statearr_29553 = state_29529;
(statearr_29553[(14)] = inst_29496);

return statearr_29553;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29529__$1,(15),inst_29507);
} else {
if((state_val_29530 === (16))){
var state_29529__$1 = state_29529;
var statearr_29554_29582 = state_29529__$1;
(statearr_29554_29582[(2)] = new_val);

(statearr_29554_29582[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (10))){
var inst_29478 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29479 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29480 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29481 = cljs.core.PersistentHashMap.fromArrays(inst_29479,inst_29480);
var inst_29482 = cljs.core.ex_info.call(null,inst_29478,inst_29481);
var inst_29483 = (function(){throw inst_29482})();
var state_29529__$1 = state_29529;
var statearr_29555_29583 = state_29529__$1;
(statearr_29555_29583[(2)] = inst_29483);

(statearr_29555_29583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (18))){
var inst_29524 = (state_29529[(2)]);
var _ = (function (){var statearr_29556 = state_29529;
(statearr_29556[(4)] = cljs.core.rest.call(null,(state_29529[(4)])));

return statearr_29556;
})();
var state_29529__$1 = state_29529;
var statearr_29557_29584 = state_29529__$1;
(statearr_29557_29584[(2)] = inst_29524);

(statearr_29557_29584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (8))){
var inst_29465 = (state_29529[(9)]);
var inst_29475 = (state_29529[(2)]);
var state_29529__$1 = (function (){var statearr_29558 = state_29529;
(statearr_29558[(15)] = inst_29475);

return statearr_29558;
})();
if(cljs.core.truth_(inst_29465)){
var statearr_29559_29585 = state_29529__$1;
(statearr_29559_29585[(1)] = (9));

} else {
var statearr_29560_29586 = state_29529__$1;
(statearr_29560_29586[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0 = (function (){
var statearr_29561 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29561[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__);

(statearr_29561[(1)] = (1));

return statearr_29561;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1 = (function (state_29529){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_29529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e29562){var ex__2744__auto__ = e29562;
var statearr_29563_29587 = state_29529;
(statearr_29563_29587[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_29529[(4)]))){
var statearr_29564_29588 = state_29529;
(statearr_29564_29588[(1)] = cljs.core.first.call(null,(state_29529[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29589 = state_29529;
state_29529 = G__29589;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__ = function(state_29529){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1.call(this,state_29529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_29565 = f__2764__auto__.call(null);
(statearr_29565[(6)] = c__2763__auto__);

return statearr_29565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
