// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___52914 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_52965){
var state_val_52966 = (state_52965[(1)]);
if((state_val_52966 === (7))){
var inst_52960 = (state_52965[(2)]);
var _ = (function (){var statearr_52967 = state_52965;
(statearr_52967[(4)] = cljs.core.rest.call(null,(state_52965[(4)])));

return statearr_52967;
})();
var state_52965__$1 = state_52965;
var statearr_52968_52995 = state_52965__$1;
(statearr_52968_52995[(2)] = inst_52960);

(statearr_52968_52995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (1))){
var state_52965__$1 = state_52965;
var statearr_52969_52996 = state_52965__$1;
(statearr_52969_52996[(2)] = null);

(statearr_52969_52996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (4))){
var inst_52915 = (state_52965[(2)]);
var state_52965__$1 = state_52965;
var statearr_52970_52997 = state_52965__$1;
(statearr_52970_52997[(2)] = inst_52915);

(statearr_52970_52997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (13))){
var inst_52956 = (state_52965[(2)]);
var state_52965__$1 = state_52965;
var statearr_52971_52998 = state_52965__$1;
(statearr_52971_52998[(2)] = inst_52956);

(statearr_52971_52998[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (6))){
var inst_52940 = (state_52965[(7)]);
var inst_52933 = (state_52965[(8)]);
var inst_52939 = cljs.core.seq.call(null,inst_52933);
var inst_52940__$1 = cljs.core.first.call(null,inst_52939);
var inst_52941 = cljs.core.next.call(null,inst_52939);
var inst_52942 = cljs.core.not.call(null,inst_52940__$1);
var state_52965__$1 = (function (){var statearr_52972 = state_52965;
(statearr_52972[(7)] = inst_52940__$1);

(statearr_52972[(9)] = inst_52941);

return statearr_52972;
})();
if(inst_52942){
var statearr_52973_52999 = state_52965__$1;
(statearr_52973_52999[(1)] = (8));

} else {
var statearr_52974_53000 = state_52965__$1;
(statearr_52974_53000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (3))){
var inst_52963 = (state_52965[(2)]);
var state_52965__$1 = state_52965;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_52965__$1,inst_52963);
} else {
if((state_val_52966 === (12))){
var inst_52934 = (state_52965[(10)]);
var inst_52940 = (state_52965[(7)]);
var inst_52941 = (state_52965[(9)]);
var inst_52953 = cljs.core.conj.call(null,inst_52934,inst_52940);
var inst_52933 = inst_52941;
var inst_52934__$1 = inst_52953;
var state_52965__$1 = (function (){var statearr_52975 = state_52965;
(statearr_52975[(10)] = inst_52934__$1);

(statearr_52975[(8)] = inst_52933);

return statearr_52975;
})();
var statearr_52976_53001 = state_52965__$1;
(statearr_52976_53001[(2)] = null);

(statearr_52976_53001[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (2))){
var _ = (function (){var statearr_52977 = state_52965;
(statearr_52977[(4)] = cljs.core.cons.call(null,(5),(state_52965[(4)])));

return statearr_52977;
})();
var inst_52928 = args;
var inst_52929 = cljs.core.seq.call(null,inst_52928);
var inst_52930 = cljs.core.first.call(null,inst_52929);
var inst_52931 = cljs.core.next.call(null,inst_52929);
var inst_52932 = cljs.core.PersistentVector.EMPTY;
var inst_52933 = inst_52928;
var inst_52934 = inst_52932;
var state_52965__$1 = (function (){var statearr_52978 = state_52965;
(statearr_52978[(10)] = inst_52934);

(statearr_52978[(11)] = inst_52930);

(statearr_52978[(8)] = inst_52933);

(statearr_52978[(12)] = inst_52931);

return statearr_52978;
})();
var statearr_52979_53002 = state_52965__$1;
(statearr_52979_53002[(2)] = null);

(statearr_52979_53002[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (11))){
var inst_52940 = (state_52965[(7)]);
var state_52965__$1 = state_52965;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_52965__$1,(14),inst_52940);
} else {
if((state_val_52966 === (9))){
var inst_52940 = (state_52965[(7)]);
var inst_52945 = fluree.db.util.async.channel_QMARK_.call(null,inst_52940);
var state_52965__$1 = state_52965;
if(inst_52945){
var statearr_52981_53003 = state_52965__$1;
(statearr_52981_53003[(1)] = (11));

} else {
var statearr_52982_53004 = state_52965__$1;
(statearr_52982_53004[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (5))){
var _ = (function (){var statearr_52983 = state_52965;
(statearr_52983[(4)] = cljs.core.rest.call(null,(state_52965[(4)])));

return statearr_52983;
})();
var state_52965__$1 = state_52965;
var ex52980 = (state_52965__$1[(2)]);
var statearr_52984_53005 = state_52965__$1;
(statearr_52984_53005[(5)] = ex52980);


if((ex52980 instanceof Error)){
var statearr_52985_53006 = state_52965__$1;
(statearr_52985_53006[(1)] = (4));

(statearr_52985_53006[(5)] = null);

} else {
throw ex52980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (14))){
var inst_52934 = (state_52965[(10)]);
var inst_52941 = (state_52965[(9)]);
var inst_52948 = (state_52965[(2)]);
var inst_52949 = fluree.db.util.async.throw_err.call(null,inst_52948);
var inst_52950 = cljs.core.conj.call(null,inst_52934,inst_52949);
var inst_52933 = inst_52941;
var inst_52934__$1 = inst_52950;
var state_52965__$1 = (function (){var statearr_52986 = state_52965;
(statearr_52986[(10)] = inst_52934__$1);

(statearr_52986[(8)] = inst_52933);

return statearr_52986;
})();
var statearr_52987_53007 = state_52965__$1;
(statearr_52987_53007[(2)] = null);

(statearr_52987_53007[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (10))){
var inst_52958 = (state_52965[(2)]);
var state_52965__$1 = state_52965;
var statearr_52988_53008 = state_52965__$1;
(statearr_52988_53008[(2)] = inst_52958);

(statearr_52988_53008[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52966 === (8))){
var inst_52934 = (state_52965[(10)]);
var state_52965__$1 = state_52965;
var statearr_52989_53009 = state_52965__$1;
(statearr_52989_53009[(2)] = inst_52934);

(statearr_52989_53009[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0 = (function (){
var statearr_52990 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52990[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__);

(statearr_52990[(1)] = (1));

return statearr_52990;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1 = (function (state_52965){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_52965);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e52991){var ex__2744__auto__ = e52991;
var statearr_52992_53010 = state_52965;
(statearr_52992_53010[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_52965[(4)]))){
var statearr_52993_53011 = state_52965;
(statearr_52993_53011[(1)] = cljs.core.first.call(null,(state_52965[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53012 = state_52965;
state_52965 = G__53012;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__ = function(state_52965){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1.call(this,state_52965);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_52994 = f__2764__auto__.call(null);
(statearr_52994[(6)] = c__2763__auto__);

return statearr_52994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53013 = entry;
var res = cljs.core.nth.call(null,vec__53013,(0),null);
var cost = cljs.core.nth.call(null,vec__53013,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53061){
var state_val_53062 = (state_53061[(1)]);
if((state_val_53062 === (7))){
var state_53061__$1 = state_53061;
var statearr_53063_53092 = state_53061__$1;
(statearr_53063_53092[(2)] = coll);

(statearr_53063_53092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (1))){
var state_53061__$1 = state_53061;
var statearr_53064_53093 = state_53061__$1;
(statearr_53064_53093[(2)] = null);

(statearr_53064_53093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (4))){
var inst_53016 = (state_53061[(2)]);
var state_53061__$1 = state_53061;
var statearr_53065_53094 = state_53061__$1;
(statearr_53065_53094[(2)] = inst_53016);

(statearr_53065_53094[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (15))){
var inst_53035 = (state_53061[(7)]);
var inst_53043 = (state_53061[(2)]);
var inst_53044 = fluree.db.dbfunctions.internal.nth.call(null,inst_53035,inst_53043);
var inst_53045 = cljs.core.count.call(null,inst_53035);
var inst_53046 = ((9) + inst_53045);
var inst_53047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53048 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53050 = [inst_53035,inst_53043];
var inst_53051 = (new cljs.core.PersistentVector(null,2,(5),inst_53049,inst_53050,null));
var inst_53052 = ["nth",inst_53051,inst_53044];
var inst_53053 = cljs.core.PersistentHashMap.fromArrays(inst_53048,inst_53052);
var inst_53054 = [inst_53053,inst_53046];
var inst_53055 = (new cljs.core.PersistentVector(null,2,(5),inst_53047,inst_53054,null));
var inst_53056 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53055);
var _ = (function (){var statearr_53066 = state_53061;
(statearr_53066[(4)] = cljs.core.rest.call(null,(state_53061[(4)])));

return statearr_53066;
})();
var state_53061__$1 = (function (){var statearr_53067 = state_53061;
(statearr_53067[(8)] = inst_53056);

return statearr_53067;
})();
var statearr_53068_53095 = state_53061__$1;
(statearr_53068_53095[(2)] = inst_53044);

(statearr_53068_53095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (13))){
var state_53061__$1 = state_53061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53061__$1,(16),key);
} else {
if((state_val_53062 === (6))){
var state_53061__$1 = state_53061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53061__$1,(9),coll);
} else {
if((state_val_53062 === (3))){
var inst_53059 = (state_53061[(2)]);
var state_53061__$1 = state_53061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53061__$1,inst_53059);
} else {
if((state_val_53062 === (12))){
var inst_53035 = (state_53061[(2)]);
var inst_53036 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_53061__$1 = (function (){var statearr_53069 = state_53061;
(statearr_53069[(7)] = inst_53035);

return statearr_53069;
})();
if(inst_53036){
var statearr_53070_53096 = state_53061__$1;
(statearr_53070_53096[(1)] = (13));

} else {
var statearr_53071_53097 = state_53061__$1;
(statearr_53071_53097[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (2))){
var _ = (function (){var statearr_53072 = state_53061;
(statearr_53072[(4)] = cljs.core.cons.call(null,(5),(state_53061[(4)])));

return statearr_53072;
})();
var inst_53022 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53061__$1 = state_53061;
if(inst_53022){
var statearr_53073_53098 = state_53061__$1;
(statearr_53073_53098[(1)] = (6));

} else {
var statearr_53074_53099 = state_53061__$1;
(statearr_53074_53099[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (11))){
var inst_53029 = (state_53061[(9)]);
var state_53061__$1 = state_53061;
var statearr_53076_53100 = state_53061__$1;
(statearr_53076_53100[(2)] = inst_53029);

(statearr_53076_53100[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (9))){
var inst_53025 = (state_53061[(2)]);
var inst_53026 = fluree.db.util.async.throw_err.call(null,inst_53025);
var state_53061__$1 = state_53061;
var statearr_53077_53101 = state_53061__$1;
(statearr_53077_53101[(2)] = inst_53026);

(statearr_53077_53101[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (5))){
var _ = (function (){var statearr_53078 = state_53061;
(statearr_53078[(4)] = cljs.core.rest.call(null,(state_53061[(4)])));

return statearr_53078;
})();
var state_53061__$1 = state_53061;
var ex53075 = (state_53061__$1[(2)]);
var statearr_53079_53102 = state_53061__$1;
(statearr_53079_53102[(5)] = ex53075);


if((ex53075 instanceof Error)){
var statearr_53080_53103 = state_53061__$1;
(statearr_53080_53103[(1)] = (4));

(statearr_53080_53103[(5)] = null);

} else {
throw ex53075;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (14))){
var state_53061__$1 = state_53061;
var statearr_53081_53104 = state_53061__$1;
(statearr_53081_53104[(2)] = key);

(statearr_53081_53104[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (16))){
var inst_53039 = (state_53061[(2)]);
var inst_53040 = fluree.db.util.async.throw_err.call(null,inst_53039);
var state_53061__$1 = state_53061;
var statearr_53082_53105 = state_53061__$1;
(statearr_53082_53105[(2)] = inst_53040);

(statearr_53082_53105[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (10))){
var inst_53029 = (state_53061[(9)]);
var inst_53032 = cljs.core.vec.call(null,inst_53029);
var state_53061__$1 = state_53061;
var statearr_53083_53106 = state_53061__$1;
(statearr_53083_53106[(2)] = inst_53032);

(statearr_53083_53106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53062 === (8))){
var inst_53029 = (state_53061[(9)]);
var inst_53029__$1 = (state_53061[(2)]);
var inst_53030 = cljs.core.set_QMARK_.call(null,inst_53029__$1);
var state_53061__$1 = (function (){var statearr_53084 = state_53061;
(statearr_53084[(9)] = inst_53029__$1);

return statearr_53084;
})();
if(inst_53030){
var statearr_53085_53107 = state_53061__$1;
(statearr_53085_53107[(1)] = (10));

} else {
var statearr_53086_53108 = state_53061__$1;
(statearr_53086_53108[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0 = (function (){
var statearr_53087 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53087[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__);

(statearr_53087[(1)] = (1));

return statearr_53087;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1 = (function (state_53061){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53088){var ex__2744__auto__ = e53088;
var statearr_53089_53109 = state_53061;
(statearr_53089_53109[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53061[(4)]))){
var statearr_53090_53110 = state_53061;
(statearr_53090_53110[(1)] = cljs.core.first.call(null,(state_53061[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53111 = state_53061;
state_53061 = G__53111;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__ = function(state_53061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1.call(this,state_53061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53091 = f__2764__auto__.call(null);
(statearr_53091[(6)] = c__2763__auto__);

return statearr_53091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53172){
var state_val_53173 = (state_53172[(1)]);
if((state_val_53173 === (7))){
var state_53172__$1 = state_53172;
var statearr_53174_53208 = state_53172__$1;
(statearr_53174_53208[(2)] = test);

(statearr_53174_53208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (20))){
var inst_53146 = (state_53172[(2)]);
var inst_53147 = fluree.db.util.async.throw_err.call(null,inst_53146);
var state_53172__$1 = state_53172;
var statearr_53175_53209 = state_53172__$1;
(statearr_53175_53209[(2)] = inst_53147);

(statearr_53175_53209[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (1))){
var state_53172__$1 = state_53172;
var statearr_53176_53210 = state_53172__$1;
(statearr_53176_53210[(2)] = null);

(statearr_53176_53210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (4))){
var inst_53112 = (state_53172[(2)]);
var state_53172__$1 = state_53172;
var statearr_53177_53211 = state_53172__$1;
(statearr_53177_53211[(2)] = inst_53112);

(statearr_53177_53211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (15))){
var inst_53130 = (state_53172[(7)]);
var inst_53138 = (state_53172[(2)]);
var inst_53139 = [inst_53138,f];
var inst_53140 = (new cljs.core.PersistentVector(null,2,(5),inst_53130,inst_53139,null));
var state_53172__$1 = state_53172;
var statearr_53178_53212 = state_53172__$1;
(statearr_53178_53212[(2)] = inst_53140);

(statearr_53178_53212[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (13))){
var state_53172__$1 = state_53172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53172__$1,(16),t);
} else {
if((state_val_53173 === (6))){
var state_53172__$1 = state_53172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53172__$1,(9),test);
} else {
if((state_val_53173 === (17))){
var state_53172__$1 = state_53172;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53172__$1,(20),f);
} else {
if((state_val_53173 === (3))){
var inst_53170 = (state_53172[(2)]);
var state_53172__$1 = state_53172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53172__$1,inst_53170);
} else {
if((state_val_53173 === (12))){
var inst_53128 = (state_53172[(8)]);
var inst_53154 = (state_53172[(2)]);
var inst_53155 = cljs.core.nth.call(null,inst_53154,(0),null);
var inst_53156 = cljs.core.nth.call(null,inst_53154,(1),null);
var inst_53157 = fluree.db.dbfunctions.internal.if_else.call(null,inst_53128,inst_53155,inst_53156);
var inst_53158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53159 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53161 = [inst_53128,inst_53155,inst_53156];
var inst_53162 = (new cljs.core.PersistentVector(null,3,(5),inst_53160,inst_53161,null));
var inst_53163 = ["if-else",inst_53162,inst_53157];
var inst_53164 = cljs.core.PersistentHashMap.fromArrays(inst_53159,inst_53163);
var inst_53165 = [inst_53164,(10)];
var inst_53166 = (new cljs.core.PersistentVector(null,2,(5),inst_53158,inst_53165,null));
var inst_53167 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53166);
var _ = (function (){var statearr_53179 = state_53172;
(statearr_53179[(4)] = cljs.core.rest.call(null,(state_53172[(4)])));

return statearr_53179;
})();
var state_53172__$1 = (function (){var statearr_53180 = state_53172;
(statearr_53180[(9)] = inst_53167);

return statearr_53180;
})();
var statearr_53181_53213 = state_53172__$1;
(statearr_53181_53213[(2)] = inst_53157);

(statearr_53181_53213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (2))){
var _ = (function (){var statearr_53182 = state_53172;
(statearr_53182[(4)] = cljs.core.cons.call(null,(5),(state_53172[(4)])));

return statearr_53182;
})();
var inst_53121 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_53172__$1 = state_53172;
if(inst_53121){
var statearr_53183_53214 = state_53172__$1;
(statearr_53183_53214[(1)] = (6));

} else {
var statearr_53184_53215 = state_53172__$1;
(statearr_53184_53215[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (19))){
var inst_53142 = (state_53172[(10)]);
var inst_53150 = (state_53172[(2)]);
var inst_53151 = [f,inst_53150];
var inst_53152 = (new cljs.core.PersistentVector(null,2,(5),inst_53142,inst_53151,null));
var state_53172__$1 = state_53172;
var statearr_53185_53216 = state_53172__$1;
(statearr_53185_53216[(2)] = inst_53152);

(statearr_53185_53216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (11))){
var inst_53142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53143 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_53172__$1 = (function (){var statearr_53187 = state_53172;
(statearr_53187[(10)] = inst_53142);

return statearr_53187;
})();
if(inst_53143){
var statearr_53188_53217 = state_53172__$1;
(statearr_53188_53217[(1)] = (17));

} else {
var statearr_53189_53218 = state_53172__$1;
(statearr_53189_53218[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (9))){
var inst_53124 = (state_53172[(2)]);
var inst_53125 = fluree.db.util.async.throw_err.call(null,inst_53124);
var state_53172__$1 = state_53172;
var statearr_53190_53219 = state_53172__$1;
(statearr_53190_53219[(2)] = inst_53125);

(statearr_53190_53219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (5))){
var _ = (function (){var statearr_53191 = state_53172;
(statearr_53191[(4)] = cljs.core.rest.call(null,(state_53172[(4)])));

return statearr_53191;
})();
var state_53172__$1 = state_53172;
var ex53186 = (state_53172__$1[(2)]);
var statearr_53192_53220 = state_53172__$1;
(statearr_53192_53220[(5)] = ex53186);


if((ex53186 instanceof Error)){
var statearr_53193_53221 = state_53172__$1;
(statearr_53193_53221[(1)] = (4));

(statearr_53193_53221[(5)] = null);

} else {
throw ex53186;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (14))){
var state_53172__$1 = state_53172;
var statearr_53194_53222 = state_53172__$1;
(statearr_53194_53222[(2)] = t);

(statearr_53194_53222[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (16))){
var inst_53134 = (state_53172[(2)]);
var inst_53135 = fluree.db.util.async.throw_err.call(null,inst_53134);
var state_53172__$1 = state_53172;
var statearr_53195_53223 = state_53172__$1;
(statearr_53195_53223[(2)] = inst_53135);

(statearr_53195_53223[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (10))){
var inst_53130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53131 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_53172__$1 = (function (){var statearr_53196 = state_53172;
(statearr_53196[(7)] = inst_53130);

return statearr_53196;
})();
if(inst_53131){
var statearr_53197_53224 = state_53172__$1;
(statearr_53197_53224[(1)] = (13));

} else {
var statearr_53198_53225 = state_53172__$1;
(statearr_53198_53225[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (18))){
var state_53172__$1 = state_53172;
var statearr_53199_53226 = state_53172__$1;
(statearr_53199_53226[(2)] = f);

(statearr_53199_53226[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53173 === (8))){
var inst_53128 = (state_53172[(8)]);
var inst_53128__$1 = (state_53172[(2)]);
var state_53172__$1 = (function (){var statearr_53200 = state_53172;
(statearr_53200[(8)] = inst_53128__$1);

return statearr_53200;
})();
if(cljs.core.truth_(inst_53128__$1)){
var statearr_53201_53227 = state_53172__$1;
(statearr_53201_53227[(1)] = (10));

} else {
var statearr_53202_53228 = state_53172__$1;
(statearr_53202_53228[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0 = (function (){
var statearr_53203 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53203[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__);

(statearr_53203[(1)] = (1));

return statearr_53203;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1 = (function (state_53172){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53204){var ex__2744__auto__ = e53204;
var statearr_53205_53229 = state_53172;
(statearr_53205_53229[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53172[(4)]))){
var statearr_53206_53230 = state_53172;
(statearr_53206_53230[(1)] = cljs.core.first.call(null,(state_53172[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53231 = state_53172;
state_53172 = G__53231;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__ = function(state_53172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1.call(this,state_53172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53207 = f__2764__auto__.call(null);
(statearr_53207[(6)] = c__2763__auto__);

return statearr_53207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53261){
var state_val_53262 = (state_53261[(1)]);
if((state_val_53262 === (7))){
var state_53261__$1 = state_53261;
var statearr_53263_53282 = state_53261__$1;
(statearr_53263_53282[(2)] = arg);

(statearr_53263_53282[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (1))){
var state_53261__$1 = state_53261;
var statearr_53264_53283 = state_53261__$1;
(statearr_53264_53283[(2)] = null);

(statearr_53264_53283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (4))){
var inst_53232 = (state_53261[(2)]);
var state_53261__$1 = state_53261;
var statearr_53265_53284 = state_53261__$1;
(statearr_53265_53284[(2)] = inst_53232);

(statearr_53265_53284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (6))){
var state_53261__$1 = state_53261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53261__$1,(9),arg);
} else {
if((state_val_53262 === (3))){
var inst_53259 = (state_53261[(2)]);
var state_53261__$1 = state_53261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53261__$1,inst_53259);
} else {
if((state_val_53262 === (2))){
var _ = (function (){var statearr_53267 = state_53261;
(statearr_53267[(4)] = cljs.core.cons.call(null,(5),(state_53261[(4)])));

return statearr_53267;
})();
var inst_53238 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53261__$1 = state_53261;
if(inst_53238){
var statearr_53268_53285 = state_53261__$1;
(statearr_53268_53285[(1)] = (6));

} else {
var statearr_53269_53286 = state_53261__$1;
(statearr_53269_53286[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (9))){
var inst_53241 = (state_53261[(2)]);
var inst_53242 = fluree.db.util.async.throw_err.call(null,inst_53241);
var state_53261__$1 = state_53261;
var statearr_53270_53287 = state_53261__$1;
(statearr_53270_53287[(2)] = inst_53242);

(statearr_53270_53287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (5))){
var _ = (function (){var statearr_53271 = state_53261;
(statearr_53271[(4)] = cljs.core.rest.call(null,(state_53261[(4)])));

return statearr_53271;
})();
var state_53261__$1 = state_53261;
var ex53266 = (state_53261__$1[(2)]);
var statearr_53272_53288 = state_53261__$1;
(statearr_53272_53288[(5)] = ex53266);


if((ex53266 instanceof Error)){
var statearr_53273_53289 = state_53261__$1;
(statearr_53273_53289[(1)] = (4));

(statearr_53273_53289[(5)] = null);

} else {
throw ex53266;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53262 === (8))){
var inst_53245 = (state_53261[(2)]);
var inst_53246 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_53245);
var inst_53247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53248 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53250 = [inst_53245];
var inst_53251 = (new cljs.core.PersistentVector(null,1,(5),inst_53249,inst_53250,null));
var inst_53252 = ["nil?",inst_53251,inst_53246];
var inst_53253 = cljs.core.PersistentHashMap.fromArrays(inst_53248,inst_53252);
var inst_53254 = [inst_53253,(10)];
var inst_53255 = (new cljs.core.PersistentVector(null,2,(5),inst_53247,inst_53254,null));
var inst_53256 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53255);
var _ = (function (){var statearr_53274 = state_53261;
(statearr_53274[(4)] = cljs.core.rest.call(null,(state_53261[(4)])));

return statearr_53274;
})();
var state_53261__$1 = (function (){var statearr_53275 = state_53261;
(statearr_53275[(7)] = inst_53256);

return statearr_53275;
})();
var statearr_53276_53290 = state_53261__$1;
(statearr_53276_53290[(2)] = inst_53246);

(statearr_53276_53290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_53277 = [null,null,null,null,null,null,null,null];
(statearr_53277[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__);

(statearr_53277[(1)] = (1));

return statearr_53277;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1 = (function (state_53261){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53278){var ex__2744__auto__ = e53278;
var statearr_53279_53291 = state_53261;
(statearr_53279_53291[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53261[(4)]))){
var statearr_53280_53292 = state_53261;
(statearr_53280_53292[(1)] = cljs.core.first.call(null,(state_53261[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53293 = state_53261;
state_53261 = G__53293;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__ = function(state_53261){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1.call(this,state_53261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53281 = f__2764__auto__.call(null);
(statearr_53281[(6)] = c__2763__auto__);

return statearr_53281;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53323){
var state_val_53324 = (state_53323[(1)]);
if((state_val_53324 === (7))){
var state_53323__$1 = state_53323;
var statearr_53325_53344 = state_53323__$1;
(statearr_53325_53344[(2)] = arg);

(statearr_53325_53344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (1))){
var state_53323__$1 = state_53323;
var statearr_53326_53345 = state_53323__$1;
(statearr_53326_53345[(2)] = null);

(statearr_53326_53345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (4))){
var inst_53294 = (state_53323[(2)]);
var state_53323__$1 = state_53323;
var statearr_53327_53346 = state_53323__$1;
(statearr_53327_53346[(2)] = inst_53294);

(statearr_53327_53346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (6))){
var state_53323__$1 = state_53323;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53323__$1,(9),arg);
} else {
if((state_val_53324 === (3))){
var inst_53321 = (state_53323[(2)]);
var state_53323__$1 = state_53323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53323__$1,inst_53321);
} else {
if((state_val_53324 === (2))){
var _ = (function (){var statearr_53329 = state_53323;
(statearr_53329[(4)] = cljs.core.cons.call(null,(5),(state_53323[(4)])));

return statearr_53329;
})();
var inst_53300 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53323__$1 = state_53323;
if(inst_53300){
var statearr_53330_53347 = state_53323__$1;
(statearr_53330_53347[(1)] = (6));

} else {
var statearr_53331_53348 = state_53323__$1;
(statearr_53331_53348[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (9))){
var inst_53303 = (state_53323[(2)]);
var inst_53304 = fluree.db.util.async.throw_err.call(null,inst_53303);
var state_53323__$1 = state_53323;
var statearr_53332_53349 = state_53323__$1;
(statearr_53332_53349[(2)] = inst_53304);

(statearr_53332_53349[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (5))){
var _ = (function (){var statearr_53333 = state_53323;
(statearr_53333[(4)] = cljs.core.rest.call(null,(state_53323[(4)])));

return statearr_53333;
})();
var state_53323__$1 = state_53323;
var ex53328 = (state_53323__$1[(2)]);
var statearr_53334_53350 = state_53323__$1;
(statearr_53334_53350[(5)] = ex53328);


if((ex53328 instanceof Error)){
var statearr_53335_53351 = state_53323__$1;
(statearr_53335_53351[(1)] = (4));

(statearr_53335_53351[(5)] = null);

} else {
throw ex53328;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53324 === (8))){
var inst_53307 = (state_53323[(2)]);
var inst_53308 = fluree.db.dbfunctions.internal.not.call(null,inst_53307);
var inst_53309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53310 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53312 = [inst_53307];
var inst_53313 = (new cljs.core.PersistentVector(null,1,(5),inst_53311,inst_53312,null));
var inst_53314 = ["not?",inst_53313,inst_53308];
var inst_53315 = cljs.core.PersistentHashMap.fromArrays(inst_53310,inst_53314);
var inst_53316 = [inst_53315,(10)];
var inst_53317 = (new cljs.core.PersistentVector(null,2,(5),inst_53309,inst_53316,null));
var inst_53318 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53317);
var _ = (function (){var statearr_53336 = state_53323;
(statearr_53336[(4)] = cljs.core.rest.call(null,(state_53323[(4)])));

return statearr_53336;
})();
var state_53323__$1 = (function (){var statearr_53337 = state_53323;
(statearr_53337[(7)] = inst_53318);

return statearr_53337;
})();
var statearr_53338_53352 = state_53323__$1;
(statearr_53338_53352[(2)] = inst_53308);

(statearr_53338_53352[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0 = (function (){
var statearr_53339 = [null,null,null,null,null,null,null,null];
(statearr_53339[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__);

(statearr_53339[(1)] = (1));

return statearr_53339;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1 = (function (state_53323){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53340){var ex__2744__auto__ = e53340;
var statearr_53341_53353 = state_53323;
(statearr_53341_53353[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53323[(4)]))){
var statearr_53342_53354 = state_53323;
(statearr_53342_53354[(1)] = cljs.core.first.call(null,(state_53323[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53355 = state_53323;
state_53323 = G__53355;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__ = function(state_53323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1.call(this,state_53323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53343 = f__2764__auto__.call(null);
(statearr_53343[(6)] = c__2763__auto__);

return statearr_53343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53385){
var state_val_53386 = (state_53385[(1)]);
if((state_val_53386 === (7))){
var state_53385__$1 = state_53385;
var statearr_53387_53406 = state_53385__$1;
(statearr_53387_53406[(2)] = arg);

(statearr_53387_53406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (1))){
var state_53385__$1 = state_53385;
var statearr_53388_53407 = state_53385__$1;
(statearr_53388_53407[(2)] = null);

(statearr_53388_53407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (4))){
var inst_53356 = (state_53385[(2)]);
var state_53385__$1 = state_53385;
var statearr_53389_53408 = state_53385__$1;
(statearr_53389_53408[(2)] = inst_53356);

(statearr_53389_53408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (6))){
var state_53385__$1 = state_53385;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53385__$1,(9),arg);
} else {
if((state_val_53386 === (3))){
var inst_53383 = (state_53385[(2)]);
var state_53385__$1 = state_53385;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53385__$1,inst_53383);
} else {
if((state_val_53386 === (2))){
var _ = (function (){var statearr_53391 = state_53385;
(statearr_53391[(4)] = cljs.core.cons.call(null,(5),(state_53385[(4)])));

return statearr_53391;
})();
var inst_53362 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_53385__$1 = state_53385;
if(inst_53362){
var statearr_53392_53409 = state_53385__$1;
(statearr_53392_53409[(1)] = (6));

} else {
var statearr_53393_53410 = state_53385__$1;
(statearr_53393_53410[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (9))){
var inst_53365 = (state_53385[(2)]);
var inst_53366 = fluree.db.util.async.throw_err.call(null,inst_53365);
var state_53385__$1 = state_53385;
var statearr_53394_53411 = state_53385__$1;
(statearr_53394_53411[(2)] = inst_53366);

(statearr_53394_53411[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (5))){
var _ = (function (){var statearr_53395 = state_53385;
(statearr_53395[(4)] = cljs.core.rest.call(null,(state_53385[(4)])));

return statearr_53395;
})();
var state_53385__$1 = state_53385;
var ex53390 = (state_53385__$1[(2)]);
var statearr_53396_53412 = state_53385__$1;
(statearr_53396_53412[(5)] = ex53390);


if((ex53390 instanceof Error)){
var statearr_53397_53413 = state_53385__$1;
(statearr_53397_53413[(1)] = (4));

(statearr_53397_53413[(5)] = null);

} else {
throw ex53390;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53386 === (8))){
var inst_53369 = (state_53385[(2)]);
var inst_53370 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_53369);
var inst_53371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53372 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53374 = [inst_53369];
var inst_53375 = (new cljs.core.PersistentVector(null,1,(5),inst_53373,inst_53374,null));
var inst_53376 = ["empty?",inst_53375,inst_53370];
var inst_53377 = cljs.core.PersistentHashMap.fromArrays(inst_53372,inst_53376);
var inst_53378 = [inst_53377,(10)];
var inst_53379 = (new cljs.core.PersistentVector(null,2,(5),inst_53371,inst_53378,null));
var inst_53380 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53379);
var _ = (function (){var statearr_53398 = state_53385;
(statearr_53398[(4)] = cljs.core.rest.call(null,(state_53385[(4)])));

return statearr_53398;
})();
var state_53385__$1 = (function (){var statearr_53399 = state_53385;
(statearr_53399[(7)] = inst_53380);

return statearr_53399;
})();
var statearr_53400_53414 = state_53385__$1;
(statearr_53400_53414[(2)] = inst_53370);

(statearr_53400_53414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_53401 = [null,null,null,null,null,null,null,null];
(statearr_53401[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__);

(statearr_53401[(1)] = (1));

return statearr_53401;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1 = (function (state_53385){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53385);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53402){var ex__2744__auto__ = e53402;
var statearr_53403_53415 = state_53385;
(statearr_53403_53415[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53385[(4)]))){
var statearr_53404_53416 = state_53385;
(statearr_53404_53416[(1)] = cljs.core.first.call(null,(state_53385[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53417 = state_53385;
state_53385 = G__53417;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__ = function(state_53385){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1.call(this,state_53385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53405 = f__2764__auto__.call(null);
(statearr_53405[(6)] = c__2763__auto__);

return statearr_53405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53462 = arguments.length;
var i__4865__auto___53463 = (0);
while(true){
if((i__4865__auto___53463 < len__4864__auto___53462)){
args__4870__auto__.push((arguments[i__4865__auto___53463]));

var G__53464 = (i__4865__auto___53463 + (1));
i__4865__auto___53463 = G__53464;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53445){
var state_val_53446 = (state_53445[(1)]);
if((state_val_53446 === (1))){
var state_53445__$1 = state_53445;
var statearr_53447_53465 = state_53445__$1;
(statearr_53447_53465[(2)] = null);

(statearr_53447_53465[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53446 === (2))){
var _ = (function (){var statearr_53448 = state_53445;
(statearr_53448[(4)] = cljs.core.cons.call(null,(5),(state_53445[(4)])));

return statearr_53448;
})();
var inst_53426 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53445__$1 = state_53445;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53445__$1,(6),inst_53426);
} else {
if((state_val_53446 === (3))){
var inst_53443 = (state_53445[(2)]);
var state_53445__$1 = state_53445;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53445__$1,inst_53443);
} else {
if((state_val_53446 === (4))){
var inst_53420 = (state_53445[(2)]);
var state_53445__$1 = state_53445;
var statearr_53450_53466 = state_53445__$1;
(statearr_53450_53466[(2)] = inst_53420);

(statearr_53450_53466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53446 === (5))){
var _ = (function (){var statearr_53451 = state_53445;
(statearr_53451[(4)] = cljs.core.rest.call(null,(state_53445[(4)])));

return statearr_53451;
})();
var state_53445__$1 = state_53445;
var ex53449 = (state_53445__$1[(2)]);
var statearr_53452_53467 = state_53445__$1;
(statearr_53452_53467[(5)] = ex53449);


if((ex53449 instanceof Error)){
var statearr_53453_53468 = state_53445__$1;
(statearr_53453_53468[(1)] = (4));

(statearr_53453_53468[(5)] = null);

} else {
throw ex53449;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53446 === (6))){
var inst_53428 = (state_53445[(2)]);
var inst_53429 = fluree.db.util.async.throw_err.call(null,inst_53428);
var inst_53430 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_53429);
var inst_53431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53432 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53434 = [inst_53429];
var inst_53435 = (new cljs.core.PersistentVector(null,1,(5),inst_53433,inst_53434,null));
var inst_53436 = ["str",inst_53435,inst_53430];
var inst_53437 = cljs.core.PersistentHashMap.fromArrays(inst_53432,inst_53436);
var inst_53438 = [inst_53437,(10)];
var inst_53439 = (new cljs.core.PersistentVector(null,2,(5),inst_53431,inst_53438,null));
var inst_53440 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53439);
var _ = (function (){var statearr_53454 = state_53445;
(statearr_53454[(4)] = cljs.core.rest.call(null,(state_53445[(4)])));

return statearr_53454;
})();
var state_53445__$1 = (function (){var statearr_53455 = state_53445;
(statearr_53455[(7)] = inst_53440);

return statearr_53455;
})();
var statearr_53456_53469 = state_53445__$1;
(statearr_53456_53469[(2)] = inst_53430);

(statearr_53456_53469[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53457 = [null,null,null,null,null,null,null,null];
(statearr_53457[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53457[(1)] = (1));

return statearr_53457;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53445){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53445);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53458){var ex__2744__auto__ = e53458;
var statearr_53459_53470 = state_53445;
(statearr_53459_53470[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53445[(4)]))){
var statearr_53460_53471 = state_53445;
(statearr_53460_53471[(1)] = cljs.core.first.call(null,(state_53445[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53472 = state_53445;
state_53445 = G__53472;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53445){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53461 = f__2764__auto__.call(null);
(statearr_53461[(6)] = c__2763__auto__);

return statearr_53461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53418){
var G__53419 = cljs.core.first.call(null,seq53418);
var seq53418__$1 = cljs.core.next.call(null,seq53418);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53419,seq53418__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53498){
var state_val_53499 = (state_53498[(1)]);
if((state_val_53499 === (1))){
var state_53498__$1 = state_53498;
var statearr_53500_53515 = state_53498__$1;
(statearr_53500_53515[(2)] = null);

(statearr_53500_53515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53499 === (2))){
var _ = (function (){var statearr_53501 = state_53498;
(statearr_53501[(4)] = cljs.core.cons.call(null,(5),(state_53498[(4)])));

return statearr_53501;
})();
var inst_53479 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53498__$1 = state_53498;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53498__$1,(6),inst_53479);
} else {
if((state_val_53499 === (3))){
var inst_53496 = (state_53498[(2)]);
var state_53498__$1 = state_53498;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53498__$1,inst_53496);
} else {
if((state_val_53499 === (4))){
var inst_53473 = (state_53498[(2)]);
var state_53498__$1 = state_53498;
var statearr_53503_53516 = state_53498__$1;
(statearr_53503_53516[(2)] = inst_53473);

(statearr_53503_53516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53499 === (5))){
var _ = (function (){var statearr_53504 = state_53498;
(statearr_53504[(4)] = cljs.core.rest.call(null,(state_53498[(4)])));

return statearr_53504;
})();
var state_53498__$1 = state_53498;
var ex53502 = (state_53498__$1[(2)]);
var statearr_53505_53517 = state_53498__$1;
(statearr_53505_53517[(5)] = ex53502);


if((ex53502 instanceof Error)){
var statearr_53506_53518 = state_53498__$1;
(statearr_53506_53518[(1)] = (4));

(statearr_53506_53518[(5)] = null);

} else {
throw ex53502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53499 === (6))){
var inst_53481 = (state_53498[(2)]);
var inst_53482 = fluree.db.util.async.throw_err.call(null,inst_53481);
var inst_53483 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_53482);
var inst_53484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53485 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53487 = [inst_53482];
var inst_53488 = (new cljs.core.PersistentVector(null,1,(5),inst_53486,inst_53487,null));
var inst_53489 = ["subs",inst_53488,inst_53483];
var inst_53490 = cljs.core.PersistentHashMap.fromArrays(inst_53485,inst_53489);
var inst_53491 = [inst_53490,(30)];
var inst_53492 = (new cljs.core.PersistentVector(null,2,(5),inst_53484,inst_53491,null));
var inst_53493 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53492);
var _ = (function (){var statearr_53507 = state_53498;
(statearr_53507[(4)] = cljs.core.rest.call(null,(state_53498[(4)])));

return statearr_53507;
})();
var state_53498__$1 = (function (){var statearr_53508 = state_53498;
(statearr_53508[(7)] = inst_53493);

return statearr_53508;
})();
var statearr_53509_53519 = state_53498__$1;
(statearr_53509_53519[(2)] = inst_53483);

(statearr_53509_53519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0 = (function (){
var statearr_53510 = [null,null,null,null,null,null,null,null];
(statearr_53510[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__);

(statearr_53510[(1)] = (1));

return statearr_53510;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1 = (function (state_53498){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53498);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53511){var ex__2744__auto__ = e53511;
var statearr_53512_53520 = state_53498;
(statearr_53512_53520[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53498[(4)]))){
var statearr_53513_53521 = state_53498;
(statearr_53513_53521[(1)] = cljs.core.first.call(null,(state_53498[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53522 = state_53498;
state_53498 = G__53522;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__ = function(state_53498){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1.call(this,state_53498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53514 = f__2764__auto__.call(null);
(statearr_53514[(6)] = c__2763__auto__);

return statearr_53514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53552){
var state_val_53553 = (state_53552[(1)]);
if((state_val_53553 === (7))){
var state_53552__$1 = state_53552;
var statearr_53554_53573 = state_53552__$1;
(statearr_53554_53573[(2)] = str);

(statearr_53554_53573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (1))){
var state_53552__$1 = state_53552;
var statearr_53555_53574 = state_53552__$1;
(statearr_53555_53574[(2)] = null);

(statearr_53555_53574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (4))){
var inst_53523 = (state_53552[(2)]);
var state_53552__$1 = state_53552;
var statearr_53556_53575 = state_53552__$1;
(statearr_53556_53575[(2)] = inst_53523);

(statearr_53556_53575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (6))){
var state_53552__$1 = state_53552;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53552__$1,(9),str);
} else {
if((state_val_53553 === (3))){
var inst_53550 = (state_53552[(2)]);
var state_53552__$1 = state_53552;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53552__$1,inst_53550);
} else {
if((state_val_53553 === (2))){
var _ = (function (){var statearr_53558 = state_53552;
(statearr_53558[(4)] = cljs.core.cons.call(null,(5),(state_53552[(4)])));

return statearr_53558;
})();
var inst_53529 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53552__$1 = state_53552;
if(inst_53529){
var statearr_53559_53576 = state_53552__$1;
(statearr_53559_53576[(1)] = (6));

} else {
var statearr_53560_53577 = state_53552__$1;
(statearr_53560_53577[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (9))){
var inst_53532 = (state_53552[(2)]);
var inst_53533 = fluree.db.util.async.throw_err.call(null,inst_53532);
var state_53552__$1 = state_53552;
var statearr_53561_53578 = state_53552__$1;
(statearr_53561_53578[(2)] = inst_53533);

(statearr_53561_53578[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (5))){
var _ = (function (){var statearr_53562 = state_53552;
(statearr_53562[(4)] = cljs.core.rest.call(null,(state_53552[(4)])));

return statearr_53562;
})();
var state_53552__$1 = state_53552;
var ex53557 = (state_53552__$1[(2)]);
var statearr_53563_53579 = state_53552__$1;
(statearr_53563_53579[(5)] = ex53557);


if((ex53557 instanceof Error)){
var statearr_53564_53580 = state_53552__$1;
(statearr_53564_53580[(1)] = (4));

(statearr_53564_53580[(5)] = null);

} else {
throw ex53557;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53553 === (8))){
var inst_53536 = (state_53552[(2)]);
var inst_53537 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_53536);
var inst_53538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53539 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53541 = [inst_53536];
var inst_53542 = (new cljs.core.PersistentVector(null,1,(5),inst_53540,inst_53541,null));
var inst_53543 = ["lower-case",inst_53542,inst_53537];
var inst_53544 = cljs.core.PersistentHashMap.fromArrays(inst_53539,inst_53543);
var inst_53545 = [inst_53544,(10)];
var inst_53546 = (new cljs.core.PersistentVector(null,2,(5),inst_53538,inst_53545,null));
var inst_53547 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53546);
var _ = (function (){var statearr_53565 = state_53552;
(statearr_53565[(4)] = cljs.core.rest.call(null,(state_53552[(4)])));

return statearr_53565;
})();
var state_53552__$1 = (function (){var statearr_53566 = state_53552;
(statearr_53566[(7)] = inst_53547);

return statearr_53566;
})();
var statearr_53567_53581 = state_53552__$1;
(statearr_53567_53581[(2)] = inst_53537);

(statearr_53567_53581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0 = (function (){
var statearr_53568 = [null,null,null,null,null,null,null,null];
(statearr_53568[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__);

(statearr_53568[(1)] = (1));

return statearr_53568;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1 = (function (state_53552){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53552);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53569){var ex__2744__auto__ = e53569;
var statearr_53570_53582 = state_53552;
(statearr_53570_53582[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53552[(4)]))){
var statearr_53571_53583 = state_53552;
(statearr_53571_53583[(1)] = cljs.core.first.call(null,(state_53552[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53584 = state_53552;
state_53552 = G__53584;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__ = function(state_53552){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1.call(this,state_53552);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53572 = f__2764__auto__.call(null);
(statearr_53572[(6)] = c__2763__auto__);

return statearr_53572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53614){
var state_val_53615 = (state_53614[(1)]);
if((state_val_53615 === (7))){
var state_53614__$1 = state_53614;
var statearr_53616_53635 = state_53614__$1;
(statearr_53616_53635[(2)] = str);

(statearr_53616_53635[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (1))){
var state_53614__$1 = state_53614;
var statearr_53617_53636 = state_53614__$1;
(statearr_53617_53636[(2)] = null);

(statearr_53617_53636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (4))){
var inst_53585 = (state_53614[(2)]);
var state_53614__$1 = state_53614;
var statearr_53618_53637 = state_53614__$1;
(statearr_53618_53637[(2)] = inst_53585);

(statearr_53618_53637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (6))){
var state_53614__$1 = state_53614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53614__$1,(9),str);
} else {
if((state_val_53615 === (3))){
var inst_53612 = (state_53614[(2)]);
var state_53614__$1 = state_53614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53614__$1,inst_53612);
} else {
if((state_val_53615 === (2))){
var _ = (function (){var statearr_53620 = state_53614;
(statearr_53620[(4)] = cljs.core.cons.call(null,(5),(state_53614[(4)])));

return statearr_53620;
})();
var inst_53591 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_53614__$1 = state_53614;
if(inst_53591){
var statearr_53621_53638 = state_53614__$1;
(statearr_53621_53638[(1)] = (6));

} else {
var statearr_53622_53639 = state_53614__$1;
(statearr_53622_53639[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (9))){
var inst_53594 = (state_53614[(2)]);
var inst_53595 = fluree.db.util.async.throw_err.call(null,inst_53594);
var state_53614__$1 = state_53614;
var statearr_53623_53640 = state_53614__$1;
(statearr_53623_53640[(2)] = inst_53595);

(statearr_53623_53640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (5))){
var _ = (function (){var statearr_53624 = state_53614;
(statearr_53624[(4)] = cljs.core.rest.call(null,(state_53614[(4)])));

return statearr_53624;
})();
var state_53614__$1 = state_53614;
var ex53619 = (state_53614__$1[(2)]);
var statearr_53625_53641 = state_53614__$1;
(statearr_53625_53641[(5)] = ex53619);


if((ex53619 instanceof Error)){
var statearr_53626_53642 = state_53614__$1;
(statearr_53626_53642[(1)] = (4));

(statearr_53626_53642[(5)] = null);

} else {
throw ex53619;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53615 === (8))){
var inst_53598 = (state_53614[(2)]);
var inst_53599 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_53598);
var inst_53600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53601 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53603 = [inst_53598];
var inst_53604 = (new cljs.core.PersistentVector(null,1,(5),inst_53602,inst_53603,null));
var inst_53605 = ["upper-case",inst_53604,inst_53599];
var inst_53606 = cljs.core.PersistentHashMap.fromArrays(inst_53601,inst_53605);
var inst_53607 = [inst_53606,(10)];
var inst_53608 = (new cljs.core.PersistentVector(null,2,(5),inst_53600,inst_53607,null));
var inst_53609 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53608);
var _ = (function (){var statearr_53627 = state_53614;
(statearr_53627[(4)] = cljs.core.rest.call(null,(state_53614[(4)])));

return statearr_53627;
})();
var state_53614__$1 = (function (){var statearr_53628 = state_53614;
(statearr_53628[(7)] = inst_53609);

return statearr_53628;
})();
var statearr_53629_53643 = state_53614__$1;
(statearr_53629_53643[(2)] = inst_53599);

(statearr_53629_53643[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0 = (function (){
var statearr_53630 = [null,null,null,null,null,null,null,null];
(statearr_53630[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__);

(statearr_53630[(1)] = (1));

return statearr_53630;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1 = (function (state_53614){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53631){var ex__2744__auto__ = e53631;
var statearr_53632_53644 = state_53614;
(statearr_53632_53644[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53614[(4)]))){
var statearr_53633_53645 = state_53614;
(statearr_53633_53645[(1)] = cljs.core.first.call(null,(state_53614[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53646 = state_53614;
state_53614 = G__53646;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__ = function(state_53614){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1.call(this,state_53614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53634 = f__2764__auto__.call(null);
(statearr_53634[(6)] = c__2763__auto__);

return statearr_53634;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53648 = arguments.length;
switch (G__53648) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53676){
var state_val_53677 = (state_53676[(1)]);
if((state_val_53677 === (1))){
var state_53676__$1 = state_53676;
var statearr_53678_53694 = state_53676__$1;
(statearr_53678_53694[(2)] = null);

(statearr_53678_53694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53677 === (2))){
var _ = (function (){var statearr_53679 = state_53676;
(statearr_53679[(4)] = cljs.core.cons.call(null,(5),(state_53676[(4)])));

return statearr_53679;
})();
var inst_53658 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_53676__$1 = state_53676;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53676__$1,(6),inst_53658);
} else {
if((state_val_53677 === (3))){
var inst_53674 = (state_53676[(2)]);
var state_53676__$1 = state_53676;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53676__$1,inst_53674);
} else {
if((state_val_53677 === (4))){
var inst_53649 = (state_53676[(2)]);
var state_53676__$1 = state_53676;
var statearr_53681_53695 = state_53676__$1;
(statearr_53681_53695[(2)] = inst_53649);

(statearr_53681_53695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53677 === (5))){
var _ = (function (){var statearr_53682 = state_53676;
(statearr_53682[(4)] = cljs.core.rest.call(null,(state_53676[(4)])));

return statearr_53682;
})();
var state_53676__$1 = state_53676;
var ex53680 = (state_53676__$1[(2)]);
var statearr_53683_53696 = state_53676__$1;
(statearr_53683_53696[(5)] = ex53680);


if((ex53680 instanceof Error)){
var statearr_53684_53697 = state_53676__$1;
(statearr_53684_53697[(1)] = (4));

(statearr_53684_53697[(5)] = null);

} else {
throw ex53680;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53677 === (6))){
var inst_53660 = (state_53676[(2)]);
var inst_53661 = fluree.db.util.async.throw_err.call(null,inst_53660);
var inst_53662 = cljs.core.nth.call(null,inst_53661,(0),null);
var inst_53663 = cljs.core.nth.call(null,inst_53661,(1),null);
var inst_53664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53665 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53666 = ["?s","?ctx",inst_53662];
var inst_53667 = cljs.core.PersistentHashMap.fromArrays(inst_53665,inst_53666);
var inst_53668 = ((10) + inst_53663);
var inst_53669 = [inst_53667,inst_53668];
var inst_53670 = (new cljs.core.PersistentVector(null,2,(5),inst_53664,inst_53669,null));
var inst_53671 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53670);
var _ = (function (){var statearr_53685 = state_53676;
(statearr_53685[(4)] = cljs.core.rest.call(null,(state_53676[(4)])));

return statearr_53685;
})();
var state_53676__$1 = (function (){var statearr_53686 = state_53676;
(statearr_53686[(7)] = inst_53671);

return statearr_53686;
})();
var statearr_53687_53698 = state_53676__$1;
(statearr_53687_53698[(2)] = inst_53662);

(statearr_53687_53698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53688 = [null,null,null,null,null,null,null,null];
(statearr_53688[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53688[(1)] = (1));

return statearr_53688;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53676){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53676);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53689){var ex__2744__auto__ = e53689;
var statearr_53690_53699 = state_53676;
(statearr_53690_53699[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53676[(4)]))){
var statearr_53691_53700 = state_53676;
(statearr_53691_53700[(1)] = cljs.core.first.call(null,(state_53676[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53701 = state_53676;
state_53676 = G__53701;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53676){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53692 = f__2764__auto__.call(null);
(statearr_53692[(6)] = c__2763__auto__);

return statearr_53692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53703 = arguments.length;
switch (G__53703) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53741){
var state_val_53742 = (state_53741[(1)]);
if((state_val_53742 === (7))){
var inst_53734 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53741__$1 = state_53741;
var statearr_53743_53763 = state_53741__$1;
(statearr_53743_53763[(2)] = inst_53734);

(statearr_53743_53763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (1))){
var state_53741__$1 = state_53741;
var statearr_53744_53764 = state_53741__$1;
(statearr_53744_53764[(2)] = null);

(statearr_53744_53764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (4))){
var inst_53704 = (state_53741[(2)]);
var state_53741__$1 = state_53741;
var statearr_53745_53765 = state_53741__$1;
(statearr_53745_53765[(2)] = inst_53704);

(statearr_53745_53765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (6))){
var inst_53715 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_53741__$1 = state_53741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53741__$1,(10),inst_53715);
} else {
if((state_val_53742 === (3))){
var inst_53739 = (state_53741[(2)]);
var state_53741__$1 = state_53741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53741__$1,inst_53739);
} else {
if((state_val_53742 === (2))){
var _ = (function (){var statearr_53747 = state_53741;
(statearr_53747[(4)] = cljs.core.cons.call(null,(5),(state_53741[(4)])));

return statearr_53747;
})();
var inst_53710 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53741__$1 = state_53741;
if(cljs.core.truth_(inst_53710)){
var statearr_53748_53766 = state_53741__$1;
(statearr_53748_53766[(1)] = (6));

} else {
var statearr_53749_53767 = state_53741__$1;
(statearr_53749_53767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (9))){
var inst_53721 = (state_53741[(2)]);
var inst_53722 = fluree.db.util.async.throw_err.call(null,inst_53721);
var inst_53723 = cljs.core.nth.call(null,inst_53722,(0),null);
var inst_53724 = cljs.core.nth.call(null,inst_53722,(1),null);
var inst_53725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53726 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53727 = ["?p","?ctx",inst_53723];
var inst_53728 = cljs.core.PersistentHashMap.fromArrays(inst_53726,inst_53727);
var inst_53729 = ((10) + inst_53724);
var inst_53730 = [inst_53728,inst_53729];
var inst_53731 = (new cljs.core.PersistentVector(null,2,(5),inst_53725,inst_53730,null));
var inst_53732 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53731);
var state_53741__$1 = (function (){var statearr_53750 = state_53741;
(statearr_53750[(7)] = inst_53732);

return statearr_53750;
})();
var statearr_53751_53768 = state_53741__$1;
(statearr_53751_53768[(2)] = inst_53723);

(statearr_53751_53768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (5))){
var _ = (function (){var statearr_53752 = state_53741;
(statearr_53752[(4)] = cljs.core.rest.call(null,(state_53741[(4)])));

return statearr_53752;
})();
var state_53741__$1 = state_53741;
var ex53746 = (state_53741__$1[(2)]);
var statearr_53753_53769 = state_53741__$1;
(statearr_53753_53769[(5)] = ex53746);


if((ex53746 instanceof Error)){
var statearr_53754_53770 = state_53741__$1;
(statearr_53754_53770[(1)] = (4));

(statearr_53754_53770[(5)] = null);

} else {
throw ex53746;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53742 === (10))){
var inst_53717 = (state_53741[(2)]);
var inst_53718 = fluree.db.util.async.throw_err.call(null,inst_53717);
var inst_53719 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_53718);
var state_53741__$1 = state_53741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53741__$1,(9),inst_53719);
} else {
if((state_val_53742 === (8))){
var inst_53736 = (state_53741[(2)]);
var _ = (function (){var statearr_53755 = state_53741;
(statearr_53755[(4)] = cljs.core.rest.call(null,(state_53741[(4)])));

return statearr_53755;
})();
var state_53741__$1 = state_53741;
var statearr_53756_53771 = state_53741__$1;
(statearr_53756_53771[(2)] = inst_53736);

(statearr_53756_53771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53757 = [null,null,null,null,null,null,null,null];
(statearr_53757[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53757[(1)] = (1));

return statearr_53757;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53741){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53758){var ex__2744__auto__ = e53758;
var statearr_53759_53772 = state_53741;
(statearr_53759_53772[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53741[(4)]))){
var statearr_53760_53773 = state_53741;
(statearr_53760_53773[(1)] = cljs.core.first.call(null,(state_53741[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53774 = state_53741;
state_53741 = G__53774;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53741){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53761 = f__2764__auto__.call(null);
(statearr_53761[(6)] = c__2763__auto__);

return statearr_53761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53823 = arguments.length;
var i__4865__auto___53824 = (0);
while(true){
if((i__4865__auto___53824 < len__4864__auto___53823)){
args__4870__auto__.push((arguments[i__4865__auto___53824]));

var G__53825 = (i__4865__auto___53824 + (1));
i__4865__auto___53824 = G__53825;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53806){
var state_val_53807 = (state_53806[(1)]);
if((state_val_53807 === (1))){
var state_53806__$1 = state_53806;
var statearr_53808_53826 = state_53806__$1;
(statearr_53808_53826[(2)] = null);

(statearr_53808_53826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53807 === (2))){
var _ = (function (){var statearr_53809 = state_53806;
(statearr_53809[(4)] = cljs.core.cons.call(null,(5),(state_53806[(4)])));

return statearr_53809;
})();
var inst_53783 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53806__$1 = state_53806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53806__$1,(6),inst_53783);
} else {
if((state_val_53807 === (3))){
var inst_53804 = (state_53806[(2)]);
var state_53806__$1 = state_53806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53806__$1,inst_53804);
} else {
if((state_val_53807 === (4))){
var inst_53777 = (state_53806[(2)]);
var state_53806__$1 = state_53806;
var statearr_53811_53827 = state_53806__$1;
(statearr_53811_53827[(2)] = inst_53777);

(statearr_53811_53827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53807 === (5))){
var _ = (function (){var statearr_53812 = state_53806;
(statearr_53812[(4)] = cljs.core.rest.call(null,(state_53806[(4)])));

return statearr_53812;
})();
var state_53806__$1 = state_53806;
var ex53810 = (state_53806__$1[(2)]);
var statearr_53813_53828 = state_53806__$1;
(statearr_53813_53828[(5)] = ex53810);


if((ex53810 instanceof Error)){
var statearr_53814_53829 = state_53806__$1;
(statearr_53814_53829[(1)] = (4));

(statearr_53814_53829[(5)] = null);

} else {
throw ex53810;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53807 === (6))){
var inst_53785 = (state_53806[(2)]);
var inst_53786 = fluree.db.util.async.throw_err.call(null,inst_53785);
var inst_53787 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_53786);
var inst_53788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53789 = [inst_53786];
var inst_53790 = (new cljs.core.PersistentVector(null,1,(5),inst_53788,inst_53789,null));
var inst_53791 = cljs.core.count.call(null,inst_53790);
var inst_53792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53793 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53795 = [inst_53786];
var inst_53796 = (new cljs.core.PersistentVector(null,1,(5),inst_53794,inst_53795,null));
var inst_53797 = ["and",inst_53796,inst_53787];
var inst_53798 = cljs.core.PersistentHashMap.fromArrays(inst_53793,inst_53797);
var inst_53799 = [inst_53798,inst_53791];
var inst_53800 = (new cljs.core.PersistentVector(null,2,(5),inst_53792,inst_53799,null));
var inst_53801 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53800);
var _ = (function (){var statearr_53815 = state_53806;
(statearr_53815[(4)] = cljs.core.rest.call(null,(state_53806[(4)])));

return statearr_53815;
})();
var state_53806__$1 = (function (){var statearr_53816 = state_53806;
(statearr_53816[(7)] = inst_53801);

return statearr_53816;
})();
var statearr_53817_53830 = state_53806__$1;
(statearr_53817_53830[(2)] = inst_53787);

(statearr_53817_53830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53818 = [null,null,null,null,null,null,null,null];
(statearr_53818[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53818[(1)] = (1));

return statearr_53818;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53806){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53819){var ex__2744__auto__ = e53819;
var statearr_53820_53831 = state_53806;
(statearr_53820_53831[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53806[(4)]))){
var statearr_53821_53832 = state_53806;
(statearr_53821_53832[(1)] = cljs.core.first.call(null,(state_53806[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53833 = state_53806;
state_53806 = G__53833;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53806){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53822 = f__2764__auto__.call(null);
(statearr_53822[(6)] = c__2763__auto__);

return statearr_53822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq53775){
var G__53776 = cljs.core.first.call(null,seq53775);
var seq53775__$1 = cljs.core.next.call(null,seq53775);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53776,seq53775__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53882 = arguments.length;
var i__4865__auto___53883 = (0);
while(true){
if((i__4865__auto___53883 < len__4864__auto___53882)){
args__4870__auto__.push((arguments[i__4865__auto___53883]));

var G__53884 = (i__4865__auto___53883 + (1));
i__4865__auto___53883 = G__53884;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53865){
var state_val_53866 = (state_53865[(1)]);
if((state_val_53866 === (1))){
var state_53865__$1 = state_53865;
var statearr_53867_53885 = state_53865__$1;
(statearr_53867_53885[(2)] = null);

(statearr_53867_53885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (2))){
var _ = (function (){var statearr_53868 = state_53865;
(statearr_53868[(4)] = cljs.core.cons.call(null,(5),(state_53865[(4)])));

return statearr_53868;
})();
var inst_53842 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_53865__$1 = state_53865;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53865__$1,(6),inst_53842);
} else {
if((state_val_53866 === (3))){
var inst_53863 = (state_53865[(2)]);
var state_53865__$1 = state_53865;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53865__$1,inst_53863);
} else {
if((state_val_53866 === (4))){
var inst_53836 = (state_53865[(2)]);
var state_53865__$1 = state_53865;
var statearr_53870_53886 = state_53865__$1;
(statearr_53870_53886[(2)] = inst_53836);

(statearr_53870_53886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (5))){
var _ = (function (){var statearr_53871 = state_53865;
(statearr_53871[(4)] = cljs.core.rest.call(null,(state_53865[(4)])));

return statearr_53871;
})();
var state_53865__$1 = state_53865;
var ex53869 = (state_53865__$1[(2)]);
var statearr_53872_53887 = state_53865__$1;
(statearr_53872_53887[(5)] = ex53869);


if((ex53869 instanceof Error)){
var statearr_53873_53888 = state_53865__$1;
(statearr_53873_53888[(1)] = (4));

(statearr_53873_53888[(5)] = null);

} else {
throw ex53869;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53866 === (6))){
var inst_53844 = (state_53865[(2)]);
var inst_53845 = fluree.db.util.async.throw_err.call(null,inst_53844);
var inst_53846 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_53845);
var inst_53847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53848 = [inst_53845];
var inst_53849 = (new cljs.core.PersistentVector(null,1,(5),inst_53847,inst_53848,null));
var inst_53850 = cljs.core.count.call(null,inst_53849);
var inst_53851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53852 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53854 = [inst_53845];
var inst_53855 = (new cljs.core.PersistentVector(null,1,(5),inst_53853,inst_53854,null));
var inst_53856 = ["or",inst_53855,inst_53846];
var inst_53857 = cljs.core.PersistentHashMap.fromArrays(inst_53852,inst_53856);
var inst_53858 = [inst_53857,inst_53850];
var inst_53859 = (new cljs.core.PersistentVector(null,2,(5),inst_53851,inst_53858,null));
var inst_53860 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53859);
var _ = (function (){var statearr_53874 = state_53865;
(statearr_53874[(4)] = cljs.core.rest.call(null,(state_53865[(4)])));

return statearr_53874;
})();
var state_53865__$1 = (function (){var statearr_53875 = state_53865;
(statearr_53875[(7)] = inst_53860);

return statearr_53875;
})();
var statearr_53876_53889 = state_53865__$1;
(statearr_53876_53889[(2)] = inst_53846);

(statearr_53876_53889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53877 = [null,null,null,null,null,null,null,null];
(statearr_53877[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53877[(1)] = (1));

return statearr_53877;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53865){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53865);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53878){var ex__2744__auto__ = e53878;
var statearr_53879_53890 = state_53865;
(statearr_53879_53890[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53865[(4)]))){
var statearr_53880_53891 = state_53865;
(statearr_53880_53891[(1)] = cljs.core.first.call(null,(state_53865[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53892 = state_53865;
state_53865 = G__53892;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53881 = f__2764__auto__.call(null);
(statearr_53881[(6)] = c__2763__auto__);

return statearr_53881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq53834){
var G__53835 = cljs.core.first.call(null,seq53834);
var seq53834__$1 = cljs.core.next.call(null,seq53834);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53835,seq53834__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53930){
var state_val_53931 = (state_53930[(1)]);
if((state_val_53931 === (7))){
var inst_53906 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_53930__$1 = state_53930;
if(inst_53906){
var statearr_53932_53955 = state_53930__$1;
(statearr_53932_53955[(1)] = (10));

} else {
var statearr_53933_53956 = state_53930__$1;
(statearr_53933_53956[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (1))){
var state_53930__$1 = state_53930;
var statearr_53934_53957 = state_53930__$1;
(statearr_53934_53957[(2)] = null);

(statearr_53934_53957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (4))){
var inst_53893 = (state_53930[(2)]);
var state_53930__$1 = state_53930;
var statearr_53935_53958 = state_53930__$1;
(statearr_53935_53958[(2)] = inst_53893);

(statearr_53935_53958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (13))){
var inst_53909 = (state_53930[(2)]);
var inst_53910 = fluree.db.util.async.throw_err.call(null,inst_53909);
var state_53930__$1 = state_53930;
var statearr_53936_53959 = state_53930__$1;
(statearr_53936_53959[(2)] = inst_53910);

(statearr_53936_53959[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (6))){
var inst_53901 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53930__$1,(9),inst_53901);
} else {
if((state_val_53931 === (3))){
var inst_53928 = (state_53930[(2)]);
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_53930__$1,inst_53928);
} else {
if((state_val_53931 === (12))){
var inst_53913 = (state_53930[(2)]);
var state_53930__$1 = state_53930;
var statearr_53937_53960 = state_53930__$1;
(statearr_53937_53960[(2)] = inst_53913);

(statearr_53937_53960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (2))){
var _ = (function (){var statearr_53938 = state_53930;
(statearr_53938[(4)] = cljs.core.cons.call(null,(5),(state_53930[(4)])));

return statearr_53938;
})();
var inst_53899 = cljs.core.vector_QMARK_.call(null,coll);
var state_53930__$1 = state_53930;
if(inst_53899){
var statearr_53939_53961 = state_53930__$1;
(statearr_53939_53961[(1)] = (6));

} else {
var statearr_53940_53962 = state_53930__$1;
(statearr_53940_53962[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (11))){
var state_53930__$1 = state_53930;
var statearr_53942_53963 = state_53930__$1;
(statearr_53942_53963[(2)] = coll);

(statearr_53942_53963[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (9))){
var inst_53903 = (state_53930[(2)]);
var inst_53904 = fluree.db.util.async.throw_err.call(null,inst_53903);
var state_53930__$1 = state_53930;
var statearr_53943_53964 = state_53930__$1;
(statearr_53943_53964[(2)] = inst_53904);

(statearr_53943_53964[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (5))){
var _ = (function (){var statearr_53944 = state_53930;
(statearr_53944[(4)] = cljs.core.rest.call(null,(state_53930[(4)])));

return statearr_53944;
})();
var state_53930__$1 = state_53930;
var ex53941 = (state_53930__$1[(2)]);
var statearr_53945_53965 = state_53930__$1;
(statearr_53945_53965[(5)] = ex53941);


if((ex53941 instanceof Error)){
var statearr_53946_53966 = state_53930__$1;
(statearr_53946_53966[(1)] = (4));

(statearr_53946_53966[(5)] = null);

} else {
throw ex53941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53931 === (10))){
var state_53930__$1 = state_53930;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_53930__$1,(13),coll);
} else {
if((state_val_53931 === (8))){
var inst_53915 = (state_53930[(2)]);
var inst_53916 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_53915);
var inst_53917 = cljs.core.count.call(null,inst_53916);
var inst_53918 = ((9) + inst_53917);
var inst_53919 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53920 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53921 = ["count",inst_53915,inst_53917];
var inst_53922 = cljs.core.PersistentHashMap.fromArrays(inst_53920,inst_53921);
var inst_53923 = [inst_53922,inst_53918];
var inst_53924 = (new cljs.core.PersistentVector(null,2,(5),inst_53919,inst_53923,null));
var inst_53925 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_53924);
var _ = (function (){var statearr_53947 = state_53930;
(statearr_53947[(4)] = cljs.core.rest.call(null,(state_53930[(4)])));

return statearr_53947;
})();
var state_53930__$1 = (function (){var statearr_53948 = state_53930;
(statearr_53948[(7)] = inst_53925);

return statearr_53948;
})();
var statearr_53949_53967 = state_53930__$1;
(statearr_53949_53967[(2)] = inst_53917);

(statearr_53949_53967[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0 = (function (){
var statearr_53950 = [null,null,null,null,null,null,null,null];
(statearr_53950[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__);

(statearr_53950[(1)] = (1));

return statearr_53950;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1 = (function (state_53930){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_53930);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53951){var ex__2744__auto__ = e53951;
var statearr_53952_53968 = state_53930;
(statearr_53952_53968[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_53930[(4)]))){
var statearr_53953_53969 = state_53930;
(statearr_53953_53969[(1)] = cljs.core.first.call(null,(state_53930[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53970 = state_53930;
state_53930 = G__53970;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__ = function(state_53930){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1.call(this,state_53930);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53954 = f__2764__auto__.call(null);
(statearr_53954[(6)] = c__2763__auto__);

return statearr_53954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54020){
var state_val_54021 = (state_54020[(1)]);
if((state_val_54021 === (7))){
var state_54020__$1 = state_54020;
var statearr_54022_54055 = state_54020__$1;
(statearr_54022_54055[(2)] = subject);

(statearr_54022_54055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (1))){
var state_54020__$1 = state_54020;
var statearr_54023_54056 = state_54020__$1;
(statearr_54023_54056[(2)] = null);

(statearr_54023_54056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (4))){
var inst_53971 = (state_54020[(2)]);
var state_54020__$1 = state_54020;
var statearr_54024_54057 = state_54020__$1;
(statearr_54024_54057[(2)] = inst_53971);

(statearr_54024_54057[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (15))){
var inst_53984 = (state_54020[(7)]);
var state_54020__$1 = state_54020;
var statearr_54025_54058 = state_54020__$1;
(statearr_54025_54058[(2)] = inst_53984);

(statearr_54025_54058[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (13))){
var inst_53988 = (state_54020[(2)]);
var inst_53989 = fluree.db.util.async.throw_err.call(null,inst_53988);
var state_54020__$1 = state_54020;
var statearr_54026_54059 = state_54020__$1;
(statearr_54026_54059[(2)] = inst_53989);

(statearr_54026_54059[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (6))){
var state_54020__$1 = state_54020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54020__$1,(9),subject);
} else {
if((state_val_54021 === (17))){
var inst_53984 = (state_54020[(7)]);
var inst_53998 = cljs.core.first.call(null,inst_53984);
var state_54020__$1 = state_54020;
var statearr_54027_54060 = state_54020__$1;
(statearr_54027_54060[(2)] = inst_53998);

(statearr_54027_54060[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (3))){
var inst_54018 = (state_54020[(2)]);
var state_54020__$1 = state_54020;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54020__$1,inst_54018);
} else {
if((state_val_54021 === (12))){
var inst_53984 = (state_54020[(7)]);
var inst_53992 = (state_54020[(2)]);
var inst_53993 = cljs.core.vector_QMARK_.call(null,inst_53984);
var state_54020__$1 = (function (){var statearr_54028 = state_54020;
(statearr_54028[(8)] = inst_53992);

return statearr_54028;
})();
if(inst_53993){
var statearr_54029_54061 = state_54020__$1;
(statearr_54029_54061[(1)] = (14));

} else {
var statearr_54030_54062 = state_54020__$1;
(statearr_54030_54062[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (2))){
var _ = (function (){var statearr_54031 = state_54020;
(statearr_54031[(4)] = cljs.core.cons.call(null,(5),(state_54020[(4)])));

return statearr_54031;
})();
var inst_53977 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54020__$1 = state_54020;
if(inst_53977){
var statearr_54032_54063 = state_54020__$1;
(statearr_54032_54063[(1)] = (6));

} else {
var statearr_54033_54064 = state_54020__$1;
(statearr_54033_54064[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (19))){
var inst_54001 = (state_54020[(2)]);
var state_54020__$1 = state_54020;
var statearr_54034_54065 = state_54020__$1;
(statearr_54034_54065[(2)] = inst_54001);

(statearr_54034_54065[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (11))){
var state_54020__$1 = state_54020;
var statearr_54036_54066 = state_54020__$1;
(statearr_54036_54066[(2)] = pred);

(statearr_54036_54066[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (9))){
var inst_53980 = (state_54020[(2)]);
var inst_53981 = fluree.db.util.async.throw_err.call(null,inst_53980);
var state_54020__$1 = state_54020;
var statearr_54037_54067 = state_54020__$1;
(statearr_54037_54067[(2)] = inst_53981);

(statearr_54037_54067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (5))){
var _ = (function (){var statearr_54038 = state_54020;
(statearr_54038[(4)] = cljs.core.rest.call(null,(state_54020[(4)])));

return statearr_54038;
})();
var state_54020__$1 = state_54020;
var ex54035 = (state_54020__$1[(2)]);
var statearr_54039_54068 = state_54020__$1;
(statearr_54039_54068[(5)] = ex54035);


if((ex54035 instanceof Error)){
var statearr_54040_54069 = state_54020__$1;
(statearr_54040_54069[(1)] = (4));

(statearr_54040_54069[(5)] = null);

} else {
throw ex54035;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (14))){
var inst_53984 = (state_54020[(7)]);
var inst_53995 = cljs.core.count.call(null,inst_53984);
var inst_53996 = cljs.core._EQ_.call(null,(1),inst_53995);
var state_54020__$1 = state_54020;
if(inst_53996){
var statearr_54041_54070 = state_54020__$1;
(statearr_54041_54070[(1)] = (17));

} else {
var statearr_54042_54071 = state_54020__$1;
(statearr_54042_54071[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (16))){
var inst_53984 = (state_54020[(7)]);
var inst_53992 = (state_54020[(8)]);
var inst_54004 = (state_54020[(2)]);
var inst_54005 = fluree.db.dbfunctions.internal.get.call(null,inst_54004,inst_53992);
var inst_54006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54007 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54009 = [inst_53984,inst_53992];
var inst_54010 = (new cljs.core.PersistentVector(null,2,(5),inst_54008,inst_54009,null));
var inst_54011 = ["get",inst_54010,inst_54005];
var inst_54012 = cljs.core.PersistentHashMap.fromArrays(inst_54007,inst_54011);
var inst_54013 = [inst_54012,(10)];
var inst_54014 = (new cljs.core.PersistentVector(null,2,(5),inst_54006,inst_54013,null));
var inst_54015 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54014);
var _ = (function (){var statearr_54043 = state_54020;
(statearr_54043[(4)] = cljs.core.rest.call(null,(state_54020[(4)])));

return statearr_54043;
})();
var state_54020__$1 = (function (){var statearr_54044 = state_54020;
(statearr_54044[(9)] = inst_54015);

return statearr_54044;
})();
var statearr_54045_54072 = state_54020__$1;
(statearr_54045_54072[(2)] = inst_54005);

(statearr_54045_54072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (10))){
var state_54020__$1 = state_54020;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54020__$1,(13),pred);
} else {
if((state_val_54021 === (18))){
var inst_53984 = (state_54020[(7)]);
var state_54020__$1 = state_54020;
var statearr_54046_54073 = state_54020__$1;
(statearr_54046_54073[(2)] = inst_53984);

(statearr_54046_54073[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54021 === (8))){
var inst_53984 = (state_54020[(2)]);
var inst_53985 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_54020__$1 = (function (){var statearr_54047 = state_54020;
(statearr_54047[(7)] = inst_53984);

return statearr_54047;
})();
if(inst_53985){
var statearr_54048_54074 = state_54020__$1;
(statearr_54048_54074[(1)] = (10));

} else {
var statearr_54049_54075 = state_54020__$1;
(statearr_54049_54075[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0 = (function (){
var statearr_54050 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54050[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__);

(statearr_54050[(1)] = (1));

return statearr_54050;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1 = (function (state_54020){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54020);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54051){var ex__2744__auto__ = e54051;
var statearr_54052_54076 = state_54020;
(statearr_54052_54076[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54020[(4)]))){
var statearr_54053_54077 = state_54020;
(statearr_54053_54077[(1)] = cljs.core.first.call(null,(state_54020[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54078 = state_54020;
state_54020 = G__54078;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__ = function(state_54020){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1.call(this,state_54020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54054 = f__2764__auto__.call(null);
(statearr_54054[(6)] = c__2763__auto__);

return statearr_54054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54117){
var state_val_54118 = (state_54117[(1)]);
if((state_val_54118 === (7))){
var inst_54085 = (state_54117[(7)]);
var state_54117__$1 = state_54117;
var statearr_54119_54143 = state_54117__$1;
(statearr_54119_54143[(2)] = inst_54085);

(statearr_54119_54143[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (1))){
var state_54117__$1 = state_54117;
var statearr_54120_54144 = state_54117__$1;
(statearr_54120_54144[(2)] = null);

(statearr_54120_54144[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (4))){
var inst_54079 = (state_54117[(2)]);
var state_54117__$1 = state_54117;
var statearr_54121_54145 = state_54117__$1;
(statearr_54121_54145[(2)] = inst_54079);

(statearr_54121_54145[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (6))){
var inst_54087 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54117__$1 = state_54117;
var statearr_54122_54146 = state_54117__$1;
(statearr_54122_54146[(2)] = inst_54087);

(statearr_54122_54146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (3))){
var inst_54115 = (state_54117[(2)]);
var state_54117__$1 = state_54117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54117__$1,inst_54115);
} else {
if((state_val_54118 === (12))){
var inst_54097 = (state_54117[(2)]);
var inst_54098 = fluree.db.util.async.throw_err.call(null,inst_54097);
var inst_54099 = cljs.core.nth.call(null,inst_54098,(0),null);
var inst_54100 = cljs.core.nth.call(null,inst_54098,(1),null);
var inst_54101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54102 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54103 = ["?pO","?ctx",inst_54099];
var inst_54104 = cljs.core.PersistentHashMap.fromArrays(inst_54102,inst_54103);
var inst_54105 = ((10) + inst_54100);
var inst_54106 = [inst_54104,inst_54105];
var inst_54107 = (new cljs.core.PersistentVector(null,2,(5),inst_54101,inst_54106,null));
var inst_54108 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54107);
var state_54117__$1 = (function (){var statearr_54123 = state_54117;
(statearr_54123[(8)] = inst_54108);

return statearr_54123;
})();
var statearr_54124_54147 = state_54117__$1;
(statearr_54124_54147[(2)] = inst_54099);

(statearr_54124_54147[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (2))){
var inst_54085 = (state_54117[(7)]);
var _ = (function (){var statearr_54125 = state_54117;
(statearr_54125[(4)] = cljs.core.cons.call(null,(5),(state_54117[(4)])));

return statearr_54125;
})();
var inst_54085__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54117__$1 = (function (){var statearr_54126 = state_54117;
(statearr_54126[(7)] = inst_54085__$1);

return statearr_54126;
})();
if(cljs.core.truth_(inst_54085__$1)){
var statearr_54127_54148 = state_54117__$1;
(statearr_54127_54148[(1)] = (6));

} else {
var statearr_54128_54149 = state_54117__$1;
(statearr_54128_54149[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (11))){
var inst_54112 = (state_54117[(2)]);
var _ = (function (){var statearr_54130 = state_54117;
(statearr_54130[(4)] = cljs.core.rest.call(null,(state_54117[(4)])));

return statearr_54130;
})();
var state_54117__$1 = state_54117;
var statearr_54131_54150 = state_54117__$1;
(statearr_54131_54150[(2)] = inst_54112);

(statearr_54131_54150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (9))){
var inst_54095 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_54117__$1 = state_54117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54117__$1,(12),inst_54095);
} else {
if((state_val_54118 === (5))){
var _ = (function (){var statearr_54132 = state_54117;
(statearr_54132[(4)] = cljs.core.rest.call(null,(state_54117[(4)])));

return statearr_54132;
})();
var state_54117__$1 = state_54117;
var ex54129 = (state_54117__$1[(2)]);
var statearr_54133_54151 = state_54117__$1;
(statearr_54133_54151[(5)] = ex54129);


if((ex54129 instanceof Error)){
var statearr_54134_54152 = state_54117__$1;
(statearr_54134_54152[(1)] = (4));

(statearr_54134_54152[(5)] = null);

} else {
throw ex54129;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (10))){
var inst_54110 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54117__$1 = state_54117;
var statearr_54135_54153 = state_54117__$1;
(statearr_54135_54153[(2)] = inst_54110);

(statearr_54135_54153[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54118 === (8))){
var inst_54090 = (state_54117[(2)]);
var state_54117__$1 = state_54117;
if(cljs.core.truth_(inst_54090)){
var statearr_54136_54154 = state_54117__$1;
(statearr_54136_54154[(1)] = (9));

} else {
var statearr_54137_54155 = state_54117__$1;
(statearr_54137_54155[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0 = (function (){
var statearr_54138 = [null,null,null,null,null,null,null,null,null];
(statearr_54138[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__);

(statearr_54138[(1)] = (1));

return statearr_54138;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1 = (function (state_54117){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54139){var ex__2744__auto__ = e54139;
var statearr_54140_54156 = state_54117;
(statearr_54140_54156[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54117[(4)]))){
var statearr_54141_54157 = state_54117;
(statearr_54141_54157[(1)] = cljs.core.first.call(null,(state_54117[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54158 = state_54117;
state_54117 = G__54158;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__ = function(state_54117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1.call(this,state_54117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54142 = f__2764__auto__.call(null);
(statearr_54142[(6)] = c__2763__auto__);

return statearr_54142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54210){
var state_val_54211 = (state_54210[(1)]);
if((state_val_54211 === (7))){
var state_54210__$1 = state_54210;
var statearr_54212_54245 = state_54210__$1;
(statearr_54212_54245[(2)] = subject);

(statearr_54212_54245[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (1))){
var state_54210__$1 = state_54210;
var statearr_54213_54246 = state_54210__$1;
(statearr_54213_54246[(2)] = null);

(statearr_54213_54246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (4))){
var inst_54159 = (state_54210[(2)]);
var state_54210__$1 = state_54210;
var statearr_54214_54247 = state_54210__$1;
(statearr_54214_54247[(2)] = inst_54159);

(statearr_54214_54247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (15))){
var inst_54172 = (state_54210[(7)]);
var state_54210__$1 = state_54210;
var statearr_54215_54248 = state_54210__$1;
(statearr_54215_54248[(2)] = inst_54172);

(statearr_54215_54248[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (13))){
var inst_54176 = (state_54210[(2)]);
var inst_54177 = fluree.db.util.async.throw_err.call(null,inst_54176);
var state_54210__$1 = state_54210;
var statearr_54216_54249 = state_54210__$1;
(statearr_54216_54249[(2)] = inst_54177);

(statearr_54216_54249[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (6))){
var state_54210__$1 = state_54210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54210__$1,(9),subject);
} else {
if((state_val_54211 === (17))){
var inst_54172 = (state_54210[(7)]);
var inst_54186 = cljs.core.first.call(null,inst_54172);
var state_54210__$1 = state_54210;
var statearr_54217_54250 = state_54210__$1;
(statearr_54217_54250[(2)] = inst_54186);

(statearr_54217_54250[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (3))){
var inst_54208 = (state_54210[(2)]);
var state_54210__$1 = state_54210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54210__$1,inst_54208);
} else {
if((state_val_54211 === (12))){
var inst_54172 = (state_54210[(7)]);
var inst_54180 = (state_54210[(2)]);
var inst_54181 = cljs.core.vector_QMARK_.call(null,inst_54172);
var state_54210__$1 = (function (){var statearr_54218 = state_54210;
(statearr_54218[(8)] = inst_54180);

return statearr_54218;
})();
if(inst_54181){
var statearr_54219_54251 = state_54210__$1;
(statearr_54219_54251[(1)] = (14));

} else {
var statearr_54220_54252 = state_54210__$1;
(statearr_54220_54252[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (2))){
var _ = (function (){var statearr_54221 = state_54210;
(statearr_54221[(4)] = cljs.core.cons.call(null,(5),(state_54210[(4)])));

return statearr_54221;
})();
var inst_54165 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54210__$1 = state_54210;
if(inst_54165){
var statearr_54222_54253 = state_54210__$1;
(statearr_54222_54253[(1)] = (6));

} else {
var statearr_54223_54254 = state_54210__$1;
(statearr_54223_54254[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (19))){
var inst_54189 = (state_54210[(2)]);
var state_54210__$1 = state_54210;
var statearr_54224_54255 = state_54210__$1;
(statearr_54224_54255[(2)] = inst_54189);

(statearr_54224_54255[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (11))){
var state_54210__$1 = state_54210;
var statearr_54226_54256 = state_54210__$1;
(statearr_54226_54256[(2)] = path);

(statearr_54226_54256[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (9))){
var inst_54168 = (state_54210[(2)]);
var inst_54169 = fluree.db.util.async.throw_err.call(null,inst_54168);
var state_54210__$1 = state_54210;
var statearr_54227_54257 = state_54210__$1;
(statearr_54227_54257[(2)] = inst_54169);

(statearr_54227_54257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (5))){
var _ = (function (){var statearr_54228 = state_54210;
(statearr_54228[(4)] = cljs.core.rest.call(null,(state_54210[(4)])));

return statearr_54228;
})();
var state_54210__$1 = state_54210;
var ex54225 = (state_54210__$1[(2)]);
var statearr_54229_54258 = state_54210__$1;
(statearr_54229_54258[(5)] = ex54225);


if((ex54225 instanceof Error)){
var statearr_54230_54259 = state_54210__$1;
(statearr_54230_54259[(1)] = (4));

(statearr_54230_54259[(5)] = null);

} else {
throw ex54225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (14))){
var inst_54172 = (state_54210[(7)]);
var inst_54183 = cljs.core.count.call(null,inst_54172);
var inst_54184 = cljs.core._EQ_.call(null,(1),inst_54183);
var state_54210__$1 = state_54210;
if(inst_54184){
var statearr_54231_54260 = state_54210__$1;
(statearr_54231_54260[(1)] = (17));

} else {
var statearr_54232_54261 = state_54210__$1;
(statearr_54232_54261[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (16))){
var inst_54172 = (state_54210[(7)]);
var inst_54180 = (state_54210[(8)]);
var inst_54192 = (state_54210[(2)]);
var inst_54193 = fluree.db.dbfunctions.internal.get_all.call(null,inst_54192,inst_54180);
var inst_54194 = cljs.core.count.call(null,inst_54180);
var inst_54195 = ((9) + inst_54194);
var inst_54196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54197 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54199 = [inst_54172,inst_54180];
var inst_54200 = (new cljs.core.PersistentVector(null,2,(5),inst_54198,inst_54199,null));
var inst_54201 = ["get-all",inst_54200,inst_54193];
var inst_54202 = cljs.core.PersistentHashMap.fromArrays(inst_54197,inst_54201);
var inst_54203 = [inst_54202,inst_54195];
var inst_54204 = (new cljs.core.PersistentVector(null,2,(5),inst_54196,inst_54203,null));
var inst_54205 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54204);
var _ = (function (){var statearr_54233 = state_54210;
(statearr_54233[(4)] = cljs.core.rest.call(null,(state_54210[(4)])));

return statearr_54233;
})();
var state_54210__$1 = (function (){var statearr_54234 = state_54210;
(statearr_54234[(9)] = inst_54205);

return statearr_54234;
})();
var statearr_54235_54262 = state_54210__$1;
(statearr_54235_54262[(2)] = inst_54193);

(statearr_54235_54262[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (10))){
var state_54210__$1 = state_54210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54210__$1,(13),path);
} else {
if((state_val_54211 === (18))){
var inst_54172 = (state_54210[(7)]);
var state_54210__$1 = state_54210;
var statearr_54236_54263 = state_54210__$1;
(statearr_54236_54263[(2)] = inst_54172);

(statearr_54236_54263[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54211 === (8))){
var inst_54172 = (state_54210[(2)]);
var inst_54173 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54210__$1 = (function (){var statearr_54237 = state_54210;
(statearr_54237[(7)] = inst_54172);

return statearr_54237;
})();
if(inst_54173){
var statearr_54238_54264 = state_54210__$1;
(statearr_54238_54264[(1)] = (10));

} else {
var statearr_54239_54265 = state_54210__$1;
(statearr_54239_54265[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0 = (function (){
var statearr_54240 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54240[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__);

(statearr_54240[(1)] = (1));

return statearr_54240;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1 = (function (state_54210){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54241){var ex__2744__auto__ = e54241;
var statearr_54242_54266 = state_54210;
(statearr_54242_54266[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54210[(4)]))){
var statearr_54243_54267 = state_54210;
(statearr_54243_54267[(1)] = cljs.core.first.call(null,(state_54210[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54268 = state_54210;
state_54210 = G__54268;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__ = function(state_54210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1.call(this,state_54210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54244 = f__2764__auto__.call(null);
(statearr_54244[(6)] = c__2763__auto__);

return statearr_54244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54307){
var state_val_54308 = (state_54307[(1)]);
if((state_val_54308 === (7))){
var state_54307__$1 = state_54307;
var statearr_54309_54333 = state_54307__$1;
(statearr_54309_54333[(2)] = subject);

(statearr_54309_54333[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (1))){
var state_54307__$1 = state_54307;
var statearr_54310_54334 = state_54307__$1;
(statearr_54310_54334[(2)] = null);

(statearr_54310_54334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (4))){
var inst_54269 = (state_54307[(2)]);
var state_54307__$1 = state_54307;
var statearr_54311_54335 = state_54307__$1;
(statearr_54311_54335[(2)] = inst_54269);

(statearr_54311_54335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (13))){
var inst_54286 = (state_54307[(2)]);
var inst_54287 = fluree.db.util.async.throw_err.call(null,inst_54286);
var state_54307__$1 = state_54307;
var statearr_54312_54336 = state_54307__$1;
(statearr_54312_54336[(2)] = inst_54287);

(statearr_54312_54336[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (6))){
var state_54307__$1 = state_54307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54307__$1,(9),subject);
} else {
if((state_val_54308 === (3))){
var inst_54305 = (state_54307[(2)]);
var state_54307__$1 = state_54307;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54307__$1,inst_54305);
} else {
if((state_val_54308 === (12))){
var inst_54282 = (state_54307[(7)]);
var inst_54290 = (state_54307[(2)]);
var inst_54291 = fluree.db.dbfunctions.internal.get_in.call(null,inst_54282,inst_54290);
var inst_54292 = cljs.core.count.call(null,inst_54290);
var inst_54293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54294 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54296 = [inst_54282,inst_54290];
var inst_54297 = (new cljs.core.PersistentVector(null,2,(5),inst_54295,inst_54296,null));
var inst_54298 = ["get-in",inst_54297,inst_54291];
var inst_54299 = cljs.core.PersistentHashMap.fromArrays(inst_54294,inst_54298);
var inst_54300 = [inst_54299,inst_54292];
var inst_54301 = (new cljs.core.PersistentVector(null,2,(5),inst_54293,inst_54300,null));
var inst_54302 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54301);
var _ = (function (){var statearr_54313 = state_54307;
(statearr_54313[(4)] = cljs.core.rest.call(null,(state_54307[(4)])));

return statearr_54313;
})();
var state_54307__$1 = (function (){var statearr_54314 = state_54307;
(statearr_54314[(8)] = inst_54302);

return statearr_54314;
})();
var statearr_54315_54337 = state_54307__$1;
(statearr_54315_54337[(2)] = inst_54291);

(statearr_54315_54337[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (2))){
var _ = (function (){var statearr_54316 = state_54307;
(statearr_54316[(4)] = cljs.core.cons.call(null,(5),(state_54307[(4)])));

return statearr_54316;
})();
var inst_54275 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_54307__$1 = state_54307;
if(inst_54275){
var statearr_54317_54338 = state_54307__$1;
(statearr_54317_54338[(1)] = (6));

} else {
var statearr_54318_54339 = state_54307__$1;
(statearr_54318_54339[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (11))){
var state_54307__$1 = state_54307;
var statearr_54320_54340 = state_54307__$1;
(statearr_54320_54340[(2)] = path);

(statearr_54320_54340[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (9))){
var inst_54278 = (state_54307[(2)]);
var inst_54279 = fluree.db.util.async.throw_err.call(null,inst_54278);
var state_54307__$1 = state_54307;
var statearr_54321_54341 = state_54307__$1;
(statearr_54321_54341[(2)] = inst_54279);

(statearr_54321_54341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (5))){
var _ = (function (){var statearr_54322 = state_54307;
(statearr_54322[(4)] = cljs.core.rest.call(null,(state_54307[(4)])));

return statearr_54322;
})();
var state_54307__$1 = state_54307;
var ex54319 = (state_54307__$1[(2)]);
var statearr_54323_54342 = state_54307__$1;
(statearr_54323_54342[(5)] = ex54319);


if((ex54319 instanceof Error)){
var statearr_54324_54343 = state_54307__$1;
(statearr_54324_54343[(1)] = (4));

(statearr_54324_54343[(5)] = null);

} else {
throw ex54319;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54308 === (10))){
var state_54307__$1 = state_54307;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54307__$1,(13),path);
} else {
if((state_val_54308 === (8))){
var inst_54282 = (state_54307[(2)]);
var inst_54283 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_54307__$1 = (function (){var statearr_54325 = state_54307;
(statearr_54325[(7)] = inst_54282);

return statearr_54325;
})();
if(inst_54283){
var statearr_54326_54344 = state_54307__$1;
(statearr_54326_54344[(1)] = (10));

} else {
var statearr_54327_54345 = state_54307__$1;
(statearr_54327_54345[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0 = (function (){
var statearr_54328 = [null,null,null,null,null,null,null,null,null];
(statearr_54328[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__);

(statearr_54328[(1)] = (1));

return statearr_54328;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1 = (function (state_54307){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54307);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54329){var ex__2744__auto__ = e54329;
var statearr_54330_54346 = state_54307;
(statearr_54330_54346[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54307[(4)]))){
var statearr_54331_54347 = state_54307;
(statearr_54331_54347[(1)] = cljs.core.first.call(null,(state_54307[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54348 = state_54307;
state_54307 = G__54348;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__ = function(state_54307){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1.call(this,state_54307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54332 = f__2764__auto__.call(null);
(statearr_54332[(6)] = c__2763__auto__);

return statearr_54332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54393){
var state_val_54394 = (state_54393[(1)]);
if((state_val_54394 === (7))){
var state_54393__$1 = state_54393;
var statearr_54395_54424 = state_54393__$1;
(statearr_54395_54424[(2)] = coll);

(statearr_54395_54424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (1))){
var state_54393__$1 = state_54393;
var statearr_54396_54425 = state_54393__$1;
(statearr_54396_54425[(2)] = null);

(statearr_54396_54425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (4))){
var inst_54349 = (state_54393[(2)]);
var state_54393__$1 = state_54393;
var statearr_54397_54426 = state_54393__$1;
(statearr_54397_54426[(2)] = inst_54349);

(statearr_54397_54426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (15))){
var inst_54369 = (state_54393[(7)]);
var inst_54377 = (state_54393[(2)]);
var inst_54378 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_54369,inst_54377);
var inst_54379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54380 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54382 = [inst_54369,inst_54377];
var inst_54383 = (new cljs.core.PersistentVector(null,2,(5),inst_54381,inst_54382,null));
var inst_54384 = ["contains?",inst_54383,inst_54378];
var inst_54385 = cljs.core.PersistentHashMap.fromArrays(inst_54380,inst_54384);
var inst_54386 = [inst_54385,(10)];
var inst_54387 = (new cljs.core.PersistentVector(null,2,(5),inst_54379,inst_54386,null));
var inst_54388 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54387);
var _ = (function (){var statearr_54398 = state_54393;
(statearr_54398[(4)] = cljs.core.rest.call(null,(state_54393[(4)])));

return statearr_54398;
})();
var state_54393__$1 = (function (){var statearr_54399 = state_54393;
(statearr_54399[(8)] = inst_54388);

return statearr_54399;
})();
var statearr_54400_54427 = state_54393__$1;
(statearr_54400_54427[(2)] = inst_54378);

(statearr_54400_54427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (13))){
var state_54393__$1 = state_54393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54393__$1,(16),key);
} else {
if((state_val_54394 === (6))){
var state_54393__$1 = state_54393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54393__$1,(9),coll);
} else {
if((state_val_54394 === (3))){
var inst_54391 = (state_54393[(2)]);
var state_54393__$1 = state_54393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54393__$1,inst_54391);
} else {
if((state_val_54394 === (12))){
var inst_54369 = (state_54393[(2)]);
var inst_54370 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54393__$1 = (function (){var statearr_54401 = state_54393;
(statearr_54401[(7)] = inst_54369);

return statearr_54401;
})();
if(inst_54370){
var statearr_54402_54428 = state_54393__$1;
(statearr_54402_54428[(1)] = (13));

} else {
var statearr_54403_54429 = state_54393__$1;
(statearr_54403_54429[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (2))){
var _ = (function (){var statearr_54404 = state_54393;
(statearr_54404[(4)] = cljs.core.cons.call(null,(5),(state_54393[(4)])));

return statearr_54404;
})();
var inst_54355 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54393__$1 = state_54393;
if(inst_54355){
var statearr_54405_54430 = state_54393__$1;
(statearr_54405_54430[(1)] = (6));

} else {
var statearr_54406_54431 = state_54393__$1;
(statearr_54406_54431[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (11))){
var inst_54362 = (state_54393[(9)]);
var inst_54366 = cljs.core.flatten.call(null,inst_54362);
var inst_54367 = cljs.core.set.call(null,inst_54366);
var state_54393__$1 = state_54393;
var statearr_54408_54432 = state_54393__$1;
(statearr_54408_54432[(2)] = inst_54367);

(statearr_54408_54432[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (9))){
var inst_54358 = (state_54393[(2)]);
var inst_54359 = fluree.db.util.async.throw_err.call(null,inst_54358);
var state_54393__$1 = state_54393;
var statearr_54409_54433 = state_54393__$1;
(statearr_54409_54433[(2)] = inst_54359);

(statearr_54409_54433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (5))){
var _ = (function (){var statearr_54410 = state_54393;
(statearr_54410[(4)] = cljs.core.rest.call(null,(state_54393[(4)])));

return statearr_54410;
})();
var state_54393__$1 = state_54393;
var ex54407 = (state_54393__$1[(2)]);
var statearr_54411_54434 = state_54393__$1;
(statearr_54411_54434[(5)] = ex54407);


if((ex54407 instanceof Error)){
var statearr_54412_54435 = state_54393__$1;
(statearr_54412_54435[(1)] = (4));

(statearr_54412_54435[(5)] = null);

} else {
throw ex54407;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (14))){
var state_54393__$1 = state_54393;
var statearr_54413_54436 = state_54393__$1;
(statearr_54413_54436[(2)] = key);

(statearr_54413_54436[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (16))){
var inst_54373 = (state_54393[(2)]);
var inst_54374 = fluree.db.util.async.throw_err.call(null,inst_54373);
var state_54393__$1 = state_54393;
var statearr_54414_54437 = state_54393__$1;
(statearr_54414_54437[(2)] = inst_54374);

(statearr_54414_54437[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (10))){
var inst_54362 = (state_54393[(9)]);
var state_54393__$1 = state_54393;
var statearr_54415_54438 = state_54393__$1;
(statearr_54415_54438[(2)] = inst_54362);

(statearr_54415_54438[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54394 === (8))){
var inst_54362 = (state_54393[(9)]);
var inst_54362__$1 = (state_54393[(2)]);
var inst_54363 = cljs.core.set_QMARK_.call(null,inst_54362__$1);
var state_54393__$1 = (function (){var statearr_54416 = state_54393;
(statearr_54416[(9)] = inst_54362__$1);

return statearr_54416;
})();
if(inst_54363){
var statearr_54417_54439 = state_54393__$1;
(statearr_54417_54439[(1)] = (10));

} else {
var statearr_54418_54440 = state_54393__$1;
(statearr_54418_54440[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_54419 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54419[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__);

(statearr_54419[(1)] = (1));

return statearr_54419;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1 = (function (state_54393){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54420){var ex__2744__auto__ = e54420;
var statearr_54421_54441 = state_54393;
(statearr_54421_54441[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54393[(4)]))){
var statearr_54422_54442 = state_54393;
(statearr_54422_54442[(1)] = cljs.core.first.call(null,(state_54393[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54443 = state_54393;
state_54393 = G__54443;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__ = function(state_54393){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1.call(this,state_54393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54423 = f__2764__auto__.call(null);
(statearr_54423[(6)] = c__2763__auto__);

return statearr_54423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54515 = arguments.length;
var i__4865__auto___54516 = (0);
while(true){
if((i__4865__auto___54516 < len__4864__auto___54515)){
args__4870__auto__.push((arguments[i__4865__auto___54516]));

var G__54517 = (i__4865__auto___54516 + (1));
i__4865__auto___54516 = G__54517;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54489){
var state_val_54490 = (state_54489[(1)]);
if((state_val_54490 === (7))){
var inst_54455 = (state_54489[(7)]);
var inst_54459 = cljs.core.first.call(null,inst_54455);
var inst_54460 = cljs.core.coll_QMARK_.call(null,inst_54459);
var state_54489__$1 = state_54489;
var statearr_54491_54518 = state_54489__$1;
(statearr_54491_54518[(2)] = inst_54460);

(statearr_54491_54518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (1))){
var state_54489__$1 = state_54489;
var statearr_54492_54519 = state_54489__$1;
(statearr_54492_54519[(2)] = null);

(statearr_54492_54519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (4))){
var inst_54446 = (state_54489[(2)]);
var state_54489__$1 = state_54489;
var statearr_54493_54520 = state_54489__$1;
(statearr_54493_54520[(2)] = inst_54446);

(statearr_54493_54520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (6))){
var inst_54455 = (state_54489[(7)]);
var inst_54457 = (state_54489[(8)]);
var inst_54454 = (state_54489[(2)]);
var inst_54455__$1 = fluree.db.util.async.throw_err.call(null,inst_54454);
var inst_54456 = cljs.core.count.call(null,inst_54455__$1);
var inst_54457__$1 = cljs.core._EQ_.call(null,(1),inst_54456);
var state_54489__$1 = (function (){var statearr_54494 = state_54489;
(statearr_54494[(7)] = inst_54455__$1);

(statearr_54494[(8)] = inst_54457__$1);

return statearr_54494;
})();
if(inst_54457__$1){
var statearr_54495_54521 = state_54489__$1;
(statearr_54495_54521[(1)] = (7));

} else {
var statearr_54496_54522 = state_54489__$1;
(statearr_54496_54522[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (3))){
var inst_54487 = (state_54489[(2)]);
var state_54489__$1 = state_54489;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54489__$1,inst_54487);
} else {
if((state_val_54490 === (12))){
var inst_54468 = (state_54489[(2)]);
var inst_54469 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_54468);
var inst_54470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54471 = [inst_54468];
var inst_54472 = (new cljs.core.PersistentVector(null,1,(5),inst_54470,inst_54471,null));
var inst_54473 = cljs.core.count.call(null,inst_54472);
var inst_54474 = ((9) + inst_54473);
var inst_54475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54476 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54478 = [inst_54468];
var inst_54479 = (new cljs.core.PersistentVector(null,1,(5),inst_54477,inst_54478,null));
var inst_54480 = ["hash-set",inst_54479,inst_54469];
var inst_54481 = cljs.core.PersistentHashMap.fromArrays(inst_54476,inst_54480);
var inst_54482 = [inst_54481,inst_54474];
var inst_54483 = (new cljs.core.PersistentVector(null,2,(5),inst_54475,inst_54482,null));
var inst_54484 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54483);
var _ = (function (){var statearr_54497 = state_54489;
(statearr_54497[(4)] = cljs.core.rest.call(null,(state_54489[(4)])));

return statearr_54497;
})();
var state_54489__$1 = (function (){var statearr_54498 = state_54489;
(statearr_54498[(9)] = inst_54484);

return statearr_54498;
})();
var statearr_54499_54523 = state_54489__$1;
(statearr_54499_54523[(2)] = inst_54469);

(statearr_54499_54523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (2))){
var _ = (function (){var statearr_54500 = state_54489;
(statearr_54500[(4)] = cljs.core.cons.call(null,(5),(state_54489[(4)])));

return statearr_54500;
})();
var inst_54452 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54489__$1 = state_54489;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54489__$1,(6),inst_54452);
} else {
if((state_val_54490 === (11))){
var inst_54455 = (state_54489[(7)]);
var state_54489__$1 = state_54489;
var statearr_54502_54524 = state_54489__$1;
(statearr_54502_54524[(2)] = inst_54455);

(statearr_54502_54524[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (9))){
var inst_54463 = (state_54489[(2)]);
var state_54489__$1 = state_54489;
if(cljs.core.truth_(inst_54463)){
var statearr_54503_54525 = state_54489__$1;
(statearr_54503_54525[(1)] = (10));

} else {
var statearr_54504_54526 = state_54489__$1;
(statearr_54504_54526[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (5))){
var _ = (function (){var statearr_54505 = state_54489;
(statearr_54505[(4)] = cljs.core.rest.call(null,(state_54489[(4)])));

return statearr_54505;
})();
var state_54489__$1 = state_54489;
var ex54501 = (state_54489__$1[(2)]);
var statearr_54506_54527 = state_54489__$1;
(statearr_54506_54527[(5)] = ex54501);


if((ex54501 instanceof Error)){
var statearr_54507_54528 = state_54489__$1;
(statearr_54507_54528[(1)] = (4));

(statearr_54507_54528[(5)] = null);

} else {
throw ex54501;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (10))){
var inst_54455 = (state_54489[(7)]);
var inst_54465 = cljs.core.first.call(null,inst_54455);
var state_54489__$1 = state_54489;
var statearr_54508_54529 = state_54489__$1;
(statearr_54508_54529[(2)] = inst_54465);

(statearr_54508_54529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54490 === (8))){
var inst_54457 = (state_54489[(8)]);
var state_54489__$1 = state_54489;
var statearr_54509_54530 = state_54489__$1;
(statearr_54509_54530[(2)] = inst_54457);

(statearr_54509_54530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54510 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54510[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54510[(1)] = (1));

return statearr_54510;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54489){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54489);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54511){var ex__2744__auto__ = e54511;
var statearr_54512_54531 = state_54489;
(statearr_54512_54531[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54489[(4)]))){
var statearr_54513_54532 = state_54489;
(statearr_54513_54532[(1)] = cljs.core.first.call(null,(state_54489[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54533 = state_54489;
state_54489 = G__54533;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54514 = f__2764__auto__.call(null);
(statearr_54514[(6)] = c__2763__auto__);

return statearr_54514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54444){
var G__54445 = cljs.core.first.call(null,seq54444);
var seq54444__$1 = cljs.core.next.call(null,seq54444);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54445,seq54444__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54583 = arguments.length;
var i__4865__auto___54584 = (0);
while(true){
if((i__4865__auto___54584 < len__4864__auto___54583)){
args__4870__auto__.push((arguments[i__4865__auto___54584]));

var G__54585 = (i__4865__auto___54584 + (1));
i__4865__auto___54584 = G__54585;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54566){
var state_val_54567 = (state_54566[(1)]);
if((state_val_54567 === (1))){
var state_54566__$1 = state_54566;
var statearr_54568_54586 = state_54566__$1;
(statearr_54568_54586[(2)] = null);

(statearr_54568_54586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54567 === (2))){
var _ = (function (){var statearr_54569 = state_54566;
(statearr_54569[(4)] = cljs.core.cons.call(null,(5),(state_54566[(4)])));

return statearr_54569;
})();
var inst_54542 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54566__$1 = state_54566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54566__$1,(6),inst_54542);
} else {
if((state_val_54567 === (3))){
var inst_54564 = (state_54566[(2)]);
var state_54566__$1 = state_54566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54566__$1,inst_54564);
} else {
if((state_val_54567 === (4))){
var inst_54536 = (state_54566[(2)]);
var state_54566__$1 = state_54566;
var statearr_54571_54587 = state_54566__$1;
(statearr_54571_54587[(2)] = inst_54536);

(statearr_54571_54587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54567 === (5))){
var _ = (function (){var statearr_54572 = state_54566;
(statearr_54572[(4)] = cljs.core.rest.call(null,(state_54566[(4)])));

return statearr_54572;
})();
var state_54566__$1 = state_54566;
var ex54570 = (state_54566__$1[(2)]);
var statearr_54573_54588 = state_54566__$1;
(statearr_54573_54588[(5)] = ex54570);


if((ex54570 instanceof Error)){
var statearr_54574_54589 = state_54566__$1;
(statearr_54574_54589[(1)] = (4));

(statearr_54574_54589[(5)] = null);

} else {
throw ex54570;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54567 === (6))){
var inst_54544 = (state_54566[(2)]);
var inst_54545 = fluree.db.util.async.throw_err.call(null,inst_54544);
var inst_54546 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_54545);
var inst_54547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54548 = [inst_54545];
var inst_54549 = (new cljs.core.PersistentVector(null,1,(5),inst_54547,inst_54548,null));
var inst_54550 = cljs.core.count.call(null,inst_54549);
var inst_54551 = ((9) + inst_54550);
var inst_54552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54553 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54555 = [inst_54545];
var inst_54556 = (new cljs.core.PersistentVector(null,1,(5),inst_54554,inst_54555,null));
var inst_54557 = ["==",inst_54556,inst_54546];
var inst_54558 = cljs.core.PersistentHashMap.fromArrays(inst_54553,inst_54557);
var inst_54559 = [inst_54558,inst_54551];
var inst_54560 = (new cljs.core.PersistentVector(null,2,(5),inst_54552,inst_54559,null));
var inst_54561 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54560);
var _ = (function (){var statearr_54575 = state_54566;
(statearr_54575[(4)] = cljs.core.rest.call(null,(state_54566[(4)])));

return statearr_54575;
})();
var state_54566__$1 = (function (){var statearr_54576 = state_54566;
(statearr_54576[(7)] = inst_54561);

return statearr_54576;
})();
var statearr_54577_54590 = state_54566__$1;
(statearr_54577_54590[(2)] = inst_54546);

(statearr_54577_54590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54578 = [null,null,null,null,null,null,null,null];
(statearr_54578[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54578[(1)] = (1));

return statearr_54578;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54566){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54579){var ex__2744__auto__ = e54579;
var statearr_54580_54591 = state_54566;
(statearr_54580_54591[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54566[(4)]))){
var statearr_54581_54592 = state_54566;
(statearr_54581_54592[(1)] = cljs.core.first.call(null,(state_54566[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54593 = state_54566;
state_54566 = G__54593;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54566){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54582 = f__2764__auto__.call(null);
(statearr_54582[(6)] = c__2763__auto__);

return statearr_54582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54534){
var G__54535 = cljs.core.first.call(null,seq54534);
var seq54534__$1 = cljs.core.next.call(null,seq54534);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54535,seq54534__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54643 = arguments.length;
var i__4865__auto___54644 = (0);
while(true){
if((i__4865__auto___54644 < len__4864__auto___54643)){
args__4870__auto__.push((arguments[i__4865__auto___54644]));

var G__54645 = (i__4865__auto___54644 + (1));
i__4865__auto___54644 = G__54645;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54626){
var state_val_54627 = (state_54626[(1)]);
if((state_val_54627 === (1))){
var state_54626__$1 = state_54626;
var statearr_54628_54646 = state_54626__$1;
(statearr_54628_54646[(2)] = null);

(statearr_54628_54646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54627 === (2))){
var _ = (function (){var statearr_54629 = state_54626;
(statearr_54629[(4)] = cljs.core.cons.call(null,(5),(state_54626[(4)])));

return statearr_54629;
})();
var inst_54602 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54626__$1 = state_54626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54626__$1,(6),inst_54602);
} else {
if((state_val_54627 === (3))){
var inst_54624 = (state_54626[(2)]);
var state_54626__$1 = state_54626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54626__$1,inst_54624);
} else {
if((state_val_54627 === (4))){
var inst_54596 = (state_54626[(2)]);
var state_54626__$1 = state_54626;
var statearr_54631_54647 = state_54626__$1;
(statearr_54631_54647[(2)] = inst_54596);

(statearr_54631_54647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54627 === (5))){
var _ = (function (){var statearr_54632 = state_54626;
(statearr_54632[(4)] = cljs.core.rest.call(null,(state_54626[(4)])));

return statearr_54632;
})();
var state_54626__$1 = state_54626;
var ex54630 = (state_54626__$1[(2)]);
var statearr_54633_54648 = state_54626__$1;
(statearr_54633_54648[(5)] = ex54630);


if((ex54630 instanceof Error)){
var statearr_54634_54649 = state_54626__$1;
(statearr_54634_54649[(1)] = (4));

(statearr_54634_54649[(5)] = null);

} else {
throw ex54630;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54627 === (6))){
var inst_54604 = (state_54626[(2)]);
var inst_54605 = fluree.db.util.async.throw_err.call(null,inst_54604);
var inst_54606 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_54605);
var inst_54607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54608 = [inst_54605];
var inst_54609 = (new cljs.core.PersistentVector(null,1,(5),inst_54607,inst_54608,null));
var inst_54610 = cljs.core.count.call(null,inst_54609);
var inst_54611 = ((9) + inst_54610);
var inst_54612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54613 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54615 = [inst_54605];
var inst_54616 = (new cljs.core.PersistentVector(null,1,(5),inst_54614,inst_54615,null));
var inst_54617 = [">",inst_54616,inst_54606];
var inst_54618 = cljs.core.PersistentHashMap.fromArrays(inst_54613,inst_54617);
var inst_54619 = [inst_54618,inst_54611];
var inst_54620 = (new cljs.core.PersistentVector(null,2,(5),inst_54612,inst_54619,null));
var inst_54621 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54620);
var _ = (function (){var statearr_54635 = state_54626;
(statearr_54635[(4)] = cljs.core.rest.call(null,(state_54626[(4)])));

return statearr_54635;
})();
var state_54626__$1 = (function (){var statearr_54636 = state_54626;
(statearr_54636[(7)] = inst_54621);

return statearr_54636;
})();
var statearr_54637_54650 = state_54626__$1;
(statearr_54637_54650[(2)] = inst_54606);

(statearr_54637_54650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54638 = [null,null,null,null,null,null,null,null];
(statearr_54638[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54638[(1)] = (1));

return statearr_54638;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54626){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54639){var ex__2744__auto__ = e54639;
var statearr_54640_54651 = state_54626;
(statearr_54640_54651[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54626[(4)]))){
var statearr_54641_54652 = state_54626;
(statearr_54641_54652[(1)] = cljs.core.first.call(null,(state_54626[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54653 = state_54626;
state_54626 = G__54653;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54626){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54642 = f__2764__auto__.call(null);
(statearr_54642[(6)] = c__2763__auto__);

return statearr_54642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54594){
var G__54595 = cljs.core.first.call(null,seq54594);
var seq54594__$1 = cljs.core.next.call(null,seq54594);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54595,seq54594__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54703 = arguments.length;
var i__4865__auto___54704 = (0);
while(true){
if((i__4865__auto___54704 < len__4864__auto___54703)){
args__4870__auto__.push((arguments[i__4865__auto___54704]));

var G__54705 = (i__4865__auto___54704 + (1));
i__4865__auto___54704 = G__54705;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54686){
var state_val_54687 = (state_54686[(1)]);
if((state_val_54687 === (1))){
var state_54686__$1 = state_54686;
var statearr_54688_54706 = state_54686__$1;
(statearr_54688_54706[(2)] = null);

(statearr_54688_54706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (2))){
var _ = (function (){var statearr_54689 = state_54686;
(statearr_54689[(4)] = cljs.core.cons.call(null,(5),(state_54686[(4)])));

return statearr_54689;
})();
var inst_54662 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54686__$1 = state_54686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54686__$1,(6),inst_54662);
} else {
if((state_val_54687 === (3))){
var inst_54684 = (state_54686[(2)]);
var state_54686__$1 = state_54686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54686__$1,inst_54684);
} else {
if((state_val_54687 === (4))){
var inst_54656 = (state_54686[(2)]);
var state_54686__$1 = state_54686;
var statearr_54691_54707 = state_54686__$1;
(statearr_54691_54707[(2)] = inst_54656);

(statearr_54691_54707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (5))){
var _ = (function (){var statearr_54692 = state_54686;
(statearr_54692[(4)] = cljs.core.rest.call(null,(state_54686[(4)])));

return statearr_54692;
})();
var state_54686__$1 = state_54686;
var ex54690 = (state_54686__$1[(2)]);
var statearr_54693_54708 = state_54686__$1;
(statearr_54693_54708[(5)] = ex54690);


if((ex54690 instanceof Error)){
var statearr_54694_54709 = state_54686__$1;
(statearr_54694_54709[(1)] = (4));

(statearr_54694_54709[(5)] = null);

} else {
throw ex54690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54687 === (6))){
var inst_54664 = (state_54686[(2)]);
var inst_54665 = fluree.db.util.async.throw_err.call(null,inst_54664);
var inst_54666 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_54665);
var inst_54667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54668 = [inst_54665];
var inst_54669 = (new cljs.core.PersistentVector(null,1,(5),inst_54667,inst_54668,null));
var inst_54670 = cljs.core.count.call(null,inst_54669);
var inst_54671 = ((9) + inst_54670);
var inst_54672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54673 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54675 = [inst_54665];
var inst_54676 = (new cljs.core.PersistentVector(null,1,(5),inst_54674,inst_54675,null));
var inst_54677 = ["<",inst_54676,inst_54666];
var inst_54678 = cljs.core.PersistentHashMap.fromArrays(inst_54673,inst_54677);
var inst_54679 = [inst_54678,inst_54671];
var inst_54680 = (new cljs.core.PersistentVector(null,2,(5),inst_54672,inst_54679,null));
var inst_54681 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54680);
var _ = (function (){var statearr_54695 = state_54686;
(statearr_54695[(4)] = cljs.core.rest.call(null,(state_54686[(4)])));

return statearr_54695;
})();
var state_54686__$1 = (function (){var statearr_54696 = state_54686;
(statearr_54696[(7)] = inst_54681);

return statearr_54696;
})();
var statearr_54697_54710 = state_54686__$1;
(statearr_54697_54710[(2)] = inst_54666);

(statearr_54697_54710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54698 = [null,null,null,null,null,null,null,null];
(statearr_54698[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54698[(1)] = (1));

return statearr_54698;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54686){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54699){var ex__2744__auto__ = e54699;
var statearr_54700_54711 = state_54686;
(statearr_54700_54711[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54686[(4)]))){
var statearr_54701_54712 = state_54686;
(statearr_54701_54712[(1)] = cljs.core.first.call(null,(state_54686[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54713 = state_54686;
state_54686 = G__54713;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54686){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54702 = f__2764__auto__.call(null);
(statearr_54702[(6)] = c__2763__auto__);

return statearr_54702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54654){
var G__54655 = cljs.core.first.call(null,seq54654);
var seq54654__$1 = cljs.core.next.call(null,seq54654);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54655,seq54654__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54763 = arguments.length;
var i__4865__auto___54764 = (0);
while(true){
if((i__4865__auto___54764 < len__4864__auto___54763)){
args__4870__auto__.push((arguments[i__4865__auto___54764]));

var G__54765 = (i__4865__auto___54764 + (1));
i__4865__auto___54764 = G__54765;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54746){
var state_val_54747 = (state_54746[(1)]);
if((state_val_54747 === (1))){
var state_54746__$1 = state_54746;
var statearr_54748_54766 = state_54746__$1;
(statearr_54748_54766[(2)] = null);

(statearr_54748_54766[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54747 === (2))){
var _ = (function (){var statearr_54749 = state_54746;
(statearr_54749[(4)] = cljs.core.cons.call(null,(5),(state_54746[(4)])));

return statearr_54749;
})();
var inst_54722 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54746__$1 = state_54746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54746__$1,(6),inst_54722);
} else {
if((state_val_54747 === (3))){
var inst_54744 = (state_54746[(2)]);
var state_54746__$1 = state_54746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54746__$1,inst_54744);
} else {
if((state_val_54747 === (4))){
var inst_54716 = (state_54746[(2)]);
var state_54746__$1 = state_54746;
var statearr_54751_54767 = state_54746__$1;
(statearr_54751_54767[(2)] = inst_54716);

(statearr_54751_54767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54747 === (5))){
var _ = (function (){var statearr_54752 = state_54746;
(statearr_54752[(4)] = cljs.core.rest.call(null,(state_54746[(4)])));

return statearr_54752;
})();
var state_54746__$1 = state_54746;
var ex54750 = (state_54746__$1[(2)]);
var statearr_54753_54768 = state_54746__$1;
(statearr_54753_54768[(5)] = ex54750);


if((ex54750 instanceof Error)){
var statearr_54754_54769 = state_54746__$1;
(statearr_54754_54769[(1)] = (4));

(statearr_54754_54769[(5)] = null);

} else {
throw ex54750;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54747 === (6))){
var inst_54724 = (state_54746[(2)]);
var inst_54725 = fluree.db.util.async.throw_err.call(null,inst_54724);
var inst_54726 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_54725);
var inst_54727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54728 = [inst_54725];
var inst_54729 = (new cljs.core.PersistentVector(null,1,(5),inst_54727,inst_54728,null));
var inst_54730 = cljs.core.count.call(null,inst_54729);
var inst_54731 = ((9) + inst_54730);
var inst_54732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54733 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54735 = [inst_54725];
var inst_54736 = (new cljs.core.PersistentVector(null,1,(5),inst_54734,inst_54735,null));
var inst_54737 = ["<=",inst_54736,inst_54726];
var inst_54738 = cljs.core.PersistentHashMap.fromArrays(inst_54733,inst_54737);
var inst_54739 = [inst_54738,inst_54731];
var inst_54740 = (new cljs.core.PersistentVector(null,2,(5),inst_54732,inst_54739,null));
var inst_54741 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54740);
var _ = (function (){var statearr_54755 = state_54746;
(statearr_54755[(4)] = cljs.core.rest.call(null,(state_54746[(4)])));

return statearr_54755;
})();
var state_54746__$1 = (function (){var statearr_54756 = state_54746;
(statearr_54756[(7)] = inst_54741);

return statearr_54756;
})();
var statearr_54757_54770 = state_54746__$1;
(statearr_54757_54770[(2)] = inst_54726);

(statearr_54757_54770[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54758 = [null,null,null,null,null,null,null,null];
(statearr_54758[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54758[(1)] = (1));

return statearr_54758;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54746){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54759){var ex__2744__auto__ = e54759;
var statearr_54760_54771 = state_54746;
(statearr_54760_54771[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54746[(4)]))){
var statearr_54761_54772 = state_54746;
(statearr_54761_54772[(1)] = cljs.core.first.call(null,(state_54746[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54773 = state_54746;
state_54746 = G__54773;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54762 = f__2764__auto__.call(null);
(statearr_54762[(6)] = c__2763__auto__);

return statearr_54762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54714){
var G__54715 = cljs.core.first.call(null,seq54714);
var seq54714__$1 = cljs.core.next.call(null,seq54714);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54715,seq54714__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54823 = arguments.length;
var i__4865__auto___54824 = (0);
while(true){
if((i__4865__auto___54824 < len__4864__auto___54823)){
args__4870__auto__.push((arguments[i__4865__auto___54824]));

var G__54825 = (i__4865__auto___54824 + (1));
i__4865__auto___54824 = G__54825;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54806){
var state_val_54807 = (state_54806[(1)]);
if((state_val_54807 === (1))){
var state_54806__$1 = state_54806;
var statearr_54808_54826 = state_54806__$1;
(statearr_54808_54826[(2)] = null);

(statearr_54808_54826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54807 === (2))){
var _ = (function (){var statearr_54809 = state_54806;
(statearr_54809[(4)] = cljs.core.cons.call(null,(5),(state_54806[(4)])));

return statearr_54809;
})();
var inst_54782 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54806__$1 = state_54806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54806__$1,(6),inst_54782);
} else {
if((state_val_54807 === (3))){
var inst_54804 = (state_54806[(2)]);
var state_54806__$1 = state_54806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54806__$1,inst_54804);
} else {
if((state_val_54807 === (4))){
var inst_54776 = (state_54806[(2)]);
var state_54806__$1 = state_54806;
var statearr_54811_54827 = state_54806__$1;
(statearr_54811_54827[(2)] = inst_54776);

(statearr_54811_54827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54807 === (5))){
var _ = (function (){var statearr_54812 = state_54806;
(statearr_54812[(4)] = cljs.core.rest.call(null,(state_54806[(4)])));

return statearr_54812;
})();
var state_54806__$1 = state_54806;
var ex54810 = (state_54806__$1[(2)]);
var statearr_54813_54828 = state_54806__$1;
(statearr_54813_54828[(5)] = ex54810);


if((ex54810 instanceof Error)){
var statearr_54814_54829 = state_54806__$1;
(statearr_54814_54829[(1)] = (4));

(statearr_54814_54829[(5)] = null);

} else {
throw ex54810;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54807 === (6))){
var inst_54784 = (state_54806[(2)]);
var inst_54785 = fluree.db.util.async.throw_err.call(null,inst_54784);
var inst_54786 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_54785);
var inst_54787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54788 = [inst_54785];
var inst_54789 = (new cljs.core.PersistentVector(null,1,(5),inst_54787,inst_54788,null));
var inst_54790 = cljs.core.count.call(null,inst_54789);
var inst_54791 = ((9) + inst_54790);
var inst_54792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54793 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54795 = [inst_54785];
var inst_54796 = (new cljs.core.PersistentVector(null,1,(5),inst_54794,inst_54795,null));
var inst_54797 = [">=",inst_54796,inst_54786];
var inst_54798 = cljs.core.PersistentHashMap.fromArrays(inst_54793,inst_54797);
var inst_54799 = [inst_54798,inst_54791];
var inst_54800 = (new cljs.core.PersistentVector(null,2,(5),inst_54792,inst_54799,null));
var inst_54801 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54800);
var _ = (function (){var statearr_54815 = state_54806;
(statearr_54815[(4)] = cljs.core.rest.call(null,(state_54806[(4)])));

return statearr_54815;
})();
var state_54806__$1 = (function (){var statearr_54816 = state_54806;
(statearr_54816[(7)] = inst_54801);

return statearr_54816;
})();
var statearr_54817_54830 = state_54806__$1;
(statearr_54817_54830[(2)] = inst_54786);

(statearr_54817_54830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54818 = [null,null,null,null,null,null,null,null];
(statearr_54818[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54818[(1)] = (1));

return statearr_54818;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54806){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54819){var ex__2744__auto__ = e54819;
var statearr_54820_54831 = state_54806;
(statearr_54820_54831[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54806[(4)]))){
var statearr_54821_54832 = state_54806;
(statearr_54821_54832[(1)] = cljs.core.first.call(null,(state_54806[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54833 = state_54806;
state_54806 = G__54833;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54806){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54822 = f__2764__auto__.call(null);
(statearr_54822[(6)] = c__2763__auto__);

return statearr_54822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54774){
var G__54775 = cljs.core.first.call(null,seq54774);
var seq54774__$1 = cljs.core.next.call(null,seq54774);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54775,seq54774__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54883 = arguments.length;
var i__4865__auto___54884 = (0);
while(true){
if((i__4865__auto___54884 < len__4864__auto___54883)){
args__4870__auto__.push((arguments[i__4865__auto___54884]));

var G__54885 = (i__4865__auto___54884 + (1));
i__4865__auto___54884 = G__54885;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54866){
var state_val_54867 = (state_54866[(1)]);
if((state_val_54867 === (1))){
var state_54866__$1 = state_54866;
var statearr_54868_54886 = state_54866__$1;
(statearr_54868_54886[(2)] = null);

(statearr_54868_54886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54867 === (2))){
var _ = (function (){var statearr_54869 = state_54866;
(statearr_54869[(4)] = cljs.core.cons.call(null,(5),(state_54866[(4)])));

return statearr_54869;
})();
var inst_54842 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54866__$1 = state_54866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54866__$1,(6),inst_54842);
} else {
if((state_val_54867 === (3))){
var inst_54864 = (state_54866[(2)]);
var state_54866__$1 = state_54866;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54866__$1,inst_54864);
} else {
if((state_val_54867 === (4))){
var inst_54836 = (state_54866[(2)]);
var state_54866__$1 = state_54866;
var statearr_54871_54887 = state_54866__$1;
(statearr_54871_54887[(2)] = inst_54836);

(statearr_54871_54887[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54867 === (5))){
var _ = (function (){var statearr_54872 = state_54866;
(statearr_54872[(4)] = cljs.core.rest.call(null,(state_54866[(4)])));

return statearr_54872;
})();
var state_54866__$1 = state_54866;
var ex54870 = (state_54866__$1[(2)]);
var statearr_54873_54888 = state_54866__$1;
(statearr_54873_54888[(5)] = ex54870);


if((ex54870 instanceof Error)){
var statearr_54874_54889 = state_54866__$1;
(statearr_54874_54889[(1)] = (4));

(statearr_54874_54889[(5)] = null);

} else {
throw ex54870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54867 === (6))){
var inst_54844 = (state_54866[(2)]);
var inst_54845 = fluree.db.util.async.throw_err.call(null,inst_54844);
var inst_54846 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_54845);
var inst_54847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54848 = [inst_54845];
var inst_54849 = (new cljs.core.PersistentVector(null,1,(5),inst_54847,inst_54848,null));
var inst_54850 = cljs.core.count.call(null,inst_54849);
var inst_54851 = ((9) + inst_54850);
var inst_54852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54853 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54855 = [inst_54845];
var inst_54856 = (new cljs.core.PersistentVector(null,1,(5),inst_54854,inst_54855,null));
var inst_54857 = ["not=",inst_54856,inst_54846];
var inst_54858 = cljs.core.PersistentHashMap.fromArrays(inst_54853,inst_54857);
var inst_54859 = [inst_54858,inst_54851];
var inst_54860 = (new cljs.core.PersistentVector(null,2,(5),inst_54852,inst_54859,null));
var inst_54861 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54860);
var _ = (function (){var statearr_54875 = state_54866;
(statearr_54875[(4)] = cljs.core.rest.call(null,(state_54866[(4)])));

return statearr_54875;
})();
var state_54866__$1 = (function (){var statearr_54876 = state_54866;
(statearr_54876[(7)] = inst_54861);

return statearr_54876;
})();
var statearr_54877_54890 = state_54866__$1;
(statearr_54877_54890[(2)] = inst_54846);

(statearr_54877_54890[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54878 = [null,null,null,null,null,null,null,null];
(statearr_54878[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54878[(1)] = (1));

return statearr_54878;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54866){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54879){var ex__2744__auto__ = e54879;
var statearr_54880_54891 = state_54866;
(statearr_54880_54891[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54866[(4)]))){
var statearr_54881_54892 = state_54866;
(statearr_54881_54892[(1)] = cljs.core.first.call(null,(state_54866[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54893 = state_54866;
state_54866 = G__54893;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54866){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54882 = f__2764__auto__.call(null);
(statearr_54882[(6)] = c__2763__auto__);

return statearr_54882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq54834){
var G__54835 = cljs.core.first.call(null,seq54834);
var seq54834__$1 = cljs.core.next.call(null,seq54834);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54835,seq54834__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54943 = arguments.length;
var i__4865__auto___54944 = (0);
while(true){
if((i__4865__auto___54944 < len__4864__auto___54943)){
args__4870__auto__.push((arguments[i__4865__auto___54944]));

var G__54945 = (i__4865__auto___54944 + (1));
i__4865__auto___54944 = G__54945;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54926){
var state_val_54927 = (state_54926[(1)]);
if((state_val_54927 === (1))){
var state_54926__$1 = state_54926;
var statearr_54928_54946 = state_54926__$1;
(statearr_54928_54946[(2)] = null);

(statearr_54928_54946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54927 === (2))){
var _ = (function (){var statearr_54929 = state_54926;
(statearr_54929[(4)] = cljs.core.cons.call(null,(5),(state_54926[(4)])));

return statearr_54929;
})();
var inst_54902 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54926__$1 = state_54926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54926__$1,(6),inst_54902);
} else {
if((state_val_54927 === (3))){
var inst_54924 = (state_54926[(2)]);
var state_54926__$1 = state_54926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54926__$1,inst_54924);
} else {
if((state_val_54927 === (4))){
var inst_54896 = (state_54926[(2)]);
var state_54926__$1 = state_54926;
var statearr_54931_54947 = state_54926__$1;
(statearr_54931_54947[(2)] = inst_54896);

(statearr_54931_54947[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54927 === (5))){
var _ = (function (){var statearr_54932 = state_54926;
(statearr_54932[(4)] = cljs.core.rest.call(null,(state_54926[(4)])));

return statearr_54932;
})();
var state_54926__$1 = state_54926;
var ex54930 = (state_54926__$1[(2)]);
var statearr_54933_54948 = state_54926__$1;
(statearr_54933_54948[(5)] = ex54930);


if((ex54930 instanceof Error)){
var statearr_54934_54949 = state_54926__$1;
(statearr_54934_54949[(1)] = (4));

(statearr_54934_54949[(5)] = null);

} else {
throw ex54930;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54927 === (6))){
var inst_54904 = (state_54926[(2)]);
var inst_54905 = fluree.db.util.async.throw_err.call(null,inst_54904);
var inst_54906 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_54905);
var inst_54907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54908 = [inst_54905];
var inst_54909 = (new cljs.core.PersistentVector(null,1,(5),inst_54907,inst_54908,null));
var inst_54910 = cljs.core.count.call(null,inst_54909);
var inst_54911 = ((9) + inst_54910);
var inst_54912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54913 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54915 = [inst_54905];
var inst_54916 = (new cljs.core.PersistentVector(null,1,(5),inst_54914,inst_54915,null));
var inst_54917 = ["max",inst_54916,inst_54906];
var inst_54918 = cljs.core.PersistentHashMap.fromArrays(inst_54913,inst_54917);
var inst_54919 = [inst_54918,inst_54911];
var inst_54920 = (new cljs.core.PersistentVector(null,2,(5),inst_54912,inst_54919,null));
var inst_54921 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54920);
var _ = (function (){var statearr_54935 = state_54926;
(statearr_54935[(4)] = cljs.core.rest.call(null,(state_54926[(4)])));

return statearr_54935;
})();
var state_54926__$1 = (function (){var statearr_54936 = state_54926;
(statearr_54936[(7)] = inst_54921);

return statearr_54936;
})();
var statearr_54937_54950 = state_54926__$1;
(statearr_54937_54950[(2)] = inst_54906);

(statearr_54937_54950[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54938 = [null,null,null,null,null,null,null,null];
(statearr_54938[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54938[(1)] = (1));

return statearr_54938;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54926){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54939){var ex__2744__auto__ = e54939;
var statearr_54940_54951 = state_54926;
(statearr_54940_54951[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54926[(4)]))){
var statearr_54941_54952 = state_54926;
(statearr_54941_54952[(1)] = cljs.core.first.call(null,(state_54926[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54953 = state_54926;
state_54926 = G__54953;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54926){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54942 = f__2764__auto__.call(null);
(statearr_54942[(6)] = c__2763__auto__);

return statearr_54942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq54894){
var G__54895 = cljs.core.first.call(null,seq54894);
var seq54894__$1 = cljs.core.next.call(null,seq54894);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54895,seq54894__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55003 = arguments.length;
var i__4865__auto___55004 = (0);
while(true){
if((i__4865__auto___55004 < len__4864__auto___55003)){
args__4870__auto__.push((arguments[i__4865__auto___55004]));

var G__55005 = (i__4865__auto___55004 + (1));
i__4865__auto___55004 = G__55005;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54986){
var state_val_54987 = (state_54986[(1)]);
if((state_val_54987 === (1))){
var state_54986__$1 = state_54986;
var statearr_54988_55006 = state_54986__$1;
(statearr_54988_55006[(2)] = null);

(statearr_54988_55006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54987 === (2))){
var _ = (function (){var statearr_54989 = state_54986;
(statearr_54989[(4)] = cljs.core.cons.call(null,(5),(state_54986[(4)])));

return statearr_54989;
})();
var inst_54962 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54986__$1 = state_54986;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54986__$1,(6),inst_54962);
} else {
if((state_val_54987 === (3))){
var inst_54984 = (state_54986[(2)]);
var state_54986__$1 = state_54986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54986__$1,inst_54984);
} else {
if((state_val_54987 === (4))){
var inst_54956 = (state_54986[(2)]);
var state_54986__$1 = state_54986;
var statearr_54991_55007 = state_54986__$1;
(statearr_54991_55007[(2)] = inst_54956);

(statearr_54991_55007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54987 === (5))){
var _ = (function (){var statearr_54992 = state_54986;
(statearr_54992[(4)] = cljs.core.rest.call(null,(state_54986[(4)])));

return statearr_54992;
})();
var state_54986__$1 = state_54986;
var ex54990 = (state_54986__$1[(2)]);
var statearr_54993_55008 = state_54986__$1;
(statearr_54993_55008[(5)] = ex54990);


if((ex54990 instanceof Error)){
var statearr_54994_55009 = state_54986__$1;
(statearr_54994_55009[(1)] = (4));

(statearr_54994_55009[(5)] = null);

} else {
throw ex54990;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54987 === (6))){
var inst_54964 = (state_54986[(2)]);
var inst_54965 = fluree.db.util.async.throw_err.call(null,inst_54964);
var inst_54966 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_54965);
var inst_54967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54968 = [inst_54965];
var inst_54969 = (new cljs.core.PersistentVector(null,1,(5),inst_54967,inst_54968,null));
var inst_54970 = cljs.core.count.call(null,inst_54969);
var inst_54971 = ((9) + inst_54970);
var inst_54972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54973 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54975 = [inst_54965];
var inst_54976 = (new cljs.core.PersistentVector(null,1,(5),inst_54974,inst_54975,null));
var inst_54977 = ["min",inst_54976,inst_54966];
var inst_54978 = cljs.core.PersistentHashMap.fromArrays(inst_54973,inst_54977);
var inst_54979 = [inst_54978,inst_54971];
var inst_54980 = (new cljs.core.PersistentVector(null,2,(5),inst_54972,inst_54979,null));
var inst_54981 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54980);
var _ = (function (){var statearr_54995 = state_54986;
(statearr_54995[(4)] = cljs.core.rest.call(null,(state_54986[(4)])));

return statearr_54995;
})();
var state_54986__$1 = (function (){var statearr_54996 = state_54986;
(statearr_54996[(7)] = inst_54981);

return statearr_54996;
})();
var statearr_54997_55010 = state_54986__$1;
(statearr_54997_55010[(2)] = inst_54966);

(statearr_54997_55010[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54998 = [null,null,null,null,null,null,null,null];
(statearr_54998[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54998[(1)] = (1));

return statearr_54998;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54986){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_54986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54999){var ex__2744__auto__ = e54999;
var statearr_55000_55011 = state_54986;
(statearr_55000_55011[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_54986[(4)]))){
var statearr_55001_55012 = state_54986;
(statearr_55001_55012[(1)] = cljs.core.first.call(null,(state_54986[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55013 = state_54986;
state_54986 = G__55013;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54986){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55002 = f__2764__auto__.call(null);
(statearr_55002[(6)] = c__2763__auto__);

return statearr_55002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq54954){
var G__54955 = cljs.core.first.call(null,seq54954);
var seq54954__$1 = cljs.core.next.call(null,seq54954);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54955,seq54954__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55015 = arguments.length;
switch (G__55015) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55060){
var state_val_55061 = (state_55060[(1)]);
if((state_val_55061 === (7))){
var state_55060__$1 = state_55060;
var statearr_55062_55199 = state_55060__$1;
(statearr_55062_55199[(2)] = query_map);

(statearr_55062_55199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (1))){
var state_55060__$1 = state_55060;
var statearr_55063_55200 = state_55060__$1;
(statearr_55063_55200[(2)] = null);

(statearr_55063_55200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (4))){
var inst_55016 = (state_55060[(2)]);
var state_55060__$1 = state_55060;
var statearr_55064_55201 = state_55060__$1;
(statearr_55064_55201[(2)] = inst_55016);

(statearr_55064_55201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (13))){
var inst_55038 = (state_55060[(7)]);
var inst_55042 = (state_55060[(2)]);
var inst_55043 = fluree.db.util.async.throw_err.call(null,inst_55042);
var inst_55044 = cljs.core.nth.call(null,inst_55043,(0),null);
var inst_55045 = cljs.core.nth.call(null,inst_55043,(1),null);
var inst_55046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55047 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55049 = [inst_55038];
var inst_55050 = (new cljs.core.PersistentVector(null,1,(5),inst_55048,inst_55049,null));
var inst_55051 = ["query",inst_55050,inst_55044];
var inst_55052 = cljs.core.PersistentHashMap.fromArrays(inst_55047,inst_55051);
var inst_55053 = [inst_55052,inst_55045];
var inst_55054 = (new cljs.core.PersistentVector(null,2,(5),inst_55046,inst_55053,null));
var inst_55055 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55054);
var _ = (function (){var statearr_55065 = state_55060;
(statearr_55065[(4)] = cljs.core.rest.call(null,(state_55060[(4)])));

return statearr_55065;
})();
var state_55060__$1 = (function (){var statearr_55066 = state_55060;
(statearr_55066[(8)] = inst_55055);

return statearr_55066;
})();
var statearr_55067_55202 = state_55060__$1;
(statearr_55067_55202[(2)] = inst_55044);

(statearr_55067_55202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (6))){
var state_55060__$1 = state_55060;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55060__$1,(9),query_map);
} else {
if((state_val_55061 === (3))){
var inst_55058 = (state_55060[(2)]);
var state_55060__$1 = state_55060;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55060__$1,inst_55058);
} else {
if((state_val_55061 === (12))){
var inst_55038 = (state_55060[(7)]);
var inst_55038__$1 = (state_55060[(2)]);
var inst_55039 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55040 = fluree.db.dbfunctions.internal.query.call(null,inst_55039,inst_55038__$1);
var state_55060__$1 = (function (){var statearr_55068 = state_55060;
(statearr_55068[(7)] = inst_55038__$1);

return statearr_55068;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55060__$1,(13),inst_55040);
} else {
if((state_val_55061 === (2))){
var _ = (function (){var statearr_55069 = state_55060;
(statearr_55069[(4)] = cljs.core.cons.call(null,(5),(state_55060[(4)])));

return statearr_55069;
})();
var inst_55025 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_55060__$1 = state_55060;
if(inst_55025){
var statearr_55070_55203 = state_55060__$1;
(statearr_55070_55203[(1)] = (6));

} else {
var statearr_55071_55204 = state_55060__$1;
(statearr_55071_55204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (11))){
var inst_55032 = (state_55060[(9)]);
var state_55060__$1 = state_55060;
var statearr_55073_55205 = state_55060__$1;
(statearr_55073_55205[(2)] = inst_55032);

(statearr_55073_55205[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (9))){
var inst_55028 = (state_55060[(2)]);
var inst_55029 = fluree.db.util.async.throw_err.call(null,inst_55028);
var state_55060__$1 = state_55060;
var statearr_55074_55206 = state_55060__$1;
(statearr_55074_55206[(2)] = inst_55029);

(statearr_55074_55206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (5))){
var _ = (function (){var statearr_55075 = state_55060;
(statearr_55075[(4)] = cljs.core.rest.call(null,(state_55060[(4)])));

return statearr_55075;
})();
var state_55060__$1 = state_55060;
var ex55072 = (state_55060__$1[(2)]);
var statearr_55076_55207 = state_55060__$1;
(statearr_55076_55207[(5)] = ex55072);


if((ex55072 instanceof Error)){
var statearr_55077_55208 = state_55060__$1;
(statearr_55077_55208[(1)] = (4));

(statearr_55077_55208[(5)] = null);

} else {
throw ex55072;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (10))){
var inst_55032 = (state_55060[(9)]);
var inst_55035 = fluree.db.util.json.parse.call(null,inst_55032);
var state_55060__$1 = state_55060;
var statearr_55078_55209 = state_55060__$1;
(statearr_55078_55209[(2)] = inst_55035);

(statearr_55078_55209[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55061 === (8))){
var inst_55032 = (state_55060[(9)]);
var inst_55032__$1 = (state_55060[(2)]);
var inst_55033 = typeof inst_55032__$1 === 'string';
var state_55060__$1 = (function (){var statearr_55079 = state_55060;
(statearr_55079[(9)] = inst_55032__$1);

return statearr_55079;
})();
if(cljs.core.truth_(inst_55033)){
var statearr_55080_55210 = state_55060__$1;
(statearr_55080_55210[(1)] = (10));

} else {
var statearr_55081_55211 = state_55060__$1;
(statearr_55081_55211[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55082 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55082[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55082[(1)] = (1));

return statearr_55082;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55060){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55060);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55083){var ex__2744__auto__ = e55083;
var statearr_55084_55212 = state_55060;
(statearr_55084_55212[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55060[(4)]))){
var statearr_55085_55213 = state_55060;
(statearr_55085_55213[(1)] = cljs.core.first.call(null,(state_55060[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55214 = state_55060;
state_55060 = G__55214;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55060){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55060);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55086 = f__2764__auto__.call(null);
(statearr_55086[(6)] = c__2763__auto__);

return statearr_55086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55157){
var state_val_55158 = (state_55157[(1)]);
if((state_val_55158 === (7))){
var state_55157__$1 = state_55157;
var statearr_55159_55215 = state_55157__$1;
(statearr_55159_55215[(2)] = select);

(statearr_55159_55215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (20))){
var inst_55127 = (state_55157[(2)]);
var inst_55128 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_55157__$1 = (function (){var statearr_55160 = state_55157;
(statearr_55160[(7)] = inst_55127);

return statearr_55160;
})();
if(inst_55128){
var statearr_55161_55216 = state_55157__$1;
(statearr_55161_55216[(1)] = (22));

} else {
var statearr_55162_55217 = state_55157__$1;
(statearr_55162_55217[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (1))){
var state_55157__$1 = state_55157;
var statearr_55163_55218 = state_55157__$1;
(statearr_55163_55218[(2)] = null);

(statearr_55163_55218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (24))){
var inst_55103 = (state_55157[(8)]);
var inst_55127 = (state_55157[(7)]);
var inst_55111 = (state_55157[(9)]);
var inst_55119 = (state_55157[(10)]);
var inst_55135 = (state_55157[(2)]);
var inst_55136 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55137 = fluree.db.dbfunctions.internal.query.call(null,inst_55136,inst_55103,inst_55111,inst_55119,inst_55127,inst_55135);
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(26),inst_55137);
} else {
if((state_val_55158 === (4))){
var inst_55087 = (state_55157[(2)]);
var state_55157__$1 = state_55157;
var statearr_55164_55219 = state_55157__$1;
(statearr_55164_55219[(2)] = inst_55087);

(statearr_55164_55219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (15))){
var state_55157__$1 = state_55157;
var statearr_55165_55220 = state_55157__$1;
(statearr_55165_55220[(2)] = where);

(statearr_55165_55220[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (21))){
var inst_55123 = (state_55157[(2)]);
var inst_55124 = fluree.db.util.async.throw_err.call(null,inst_55123);
var state_55157__$1 = state_55157;
var statearr_55166_55221 = state_55157__$1;
(statearr_55166_55221[(2)] = inst_55124);

(statearr_55166_55221[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (13))){
var inst_55107 = (state_55157[(2)]);
var inst_55108 = fluree.db.util.async.throw_err.call(null,inst_55107);
var state_55157__$1 = state_55157;
var statearr_55167_55222 = state_55157__$1;
(statearr_55167_55222[(2)] = inst_55108);

(statearr_55167_55222[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (22))){
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(25),limit);
} else {
if((state_val_55158 === (6))){
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(9),select);
} else {
if((state_val_55158 === (25))){
var inst_55131 = (state_55157[(2)]);
var inst_55132 = fluree.db.util.async.throw_err.call(null,inst_55131);
var state_55157__$1 = state_55157;
var statearr_55168_55223 = state_55157__$1;
(statearr_55168_55223[(2)] = inst_55132);

(statearr_55168_55223[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (17))){
var inst_55115 = (state_55157[(2)]);
var inst_55116 = fluree.db.util.async.throw_err.call(null,inst_55115);
var state_55157__$1 = state_55157;
var statearr_55169_55224 = state_55157__$1;
(statearr_55169_55224[(2)] = inst_55116);

(statearr_55169_55224[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (3))){
var inst_55155 = (state_55157[(2)]);
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55157__$1,inst_55155);
} else {
if((state_val_55158 === (12))){
var inst_55111 = (state_55157[(2)]);
var inst_55112 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_55157__$1 = (function (){var statearr_55170 = state_55157;
(statearr_55170[(9)] = inst_55111);

return statearr_55170;
})();
if(inst_55112){
var statearr_55171_55225 = state_55157__$1;
(statearr_55171_55225[(1)] = (14));

} else {
var statearr_55172_55226 = state_55157__$1;
(statearr_55172_55226[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (2))){
var _ = (function (){var statearr_55173 = state_55157;
(statearr_55173[(4)] = cljs.core.cons.call(null,(5),(state_55157[(4)])));

return statearr_55173;
})();
var inst_55096 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_55157__$1 = state_55157;
if(inst_55096){
var statearr_55174_55227 = state_55157__$1;
(statearr_55174_55227[(1)] = (6));

} else {
var statearr_55175_55228 = state_55157__$1;
(statearr_55175_55228[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (23))){
var state_55157__$1 = state_55157;
var statearr_55176_55229 = state_55157__$1;
(statearr_55176_55229[(2)] = limit);

(statearr_55176_55229[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (19))){
var state_55157__$1 = state_55157;
var statearr_55177_55230 = state_55157__$1;
(statearr_55177_55230[(2)] = block);

(statearr_55177_55230[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (11))){
var state_55157__$1 = state_55157;
var statearr_55179_55231 = state_55157__$1;
(statearr_55179_55231[(2)] = from);

(statearr_55179_55231[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (9))){
var inst_55099 = (state_55157[(2)]);
var inst_55100 = fluree.db.util.async.throw_err.call(null,inst_55099);
var state_55157__$1 = state_55157;
var statearr_55180_55232 = state_55157__$1;
(statearr_55180_55232[(2)] = inst_55100);

(statearr_55180_55232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (5))){
var _ = (function (){var statearr_55181 = state_55157;
(statearr_55181[(4)] = cljs.core.rest.call(null,(state_55157[(4)])));

return statearr_55181;
})();
var state_55157__$1 = state_55157;
var ex55178 = (state_55157__$1[(2)]);
var statearr_55182_55233 = state_55157__$1;
(statearr_55182_55233[(5)] = ex55178);


if((ex55178 instanceof Error)){
var statearr_55183_55234 = state_55157__$1;
(statearr_55183_55234[(1)] = (4));

(statearr_55183_55234[(5)] = null);

} else {
throw ex55178;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (14))){
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(17),where);
} else {
if((state_val_55158 === (26))){
var inst_55103 = (state_55157[(8)]);
var inst_55127 = (state_55157[(7)]);
var inst_55111 = (state_55157[(9)]);
var inst_55119 = (state_55157[(10)]);
var inst_55139 = (state_55157[(2)]);
var inst_55140 = fluree.db.util.async.throw_err.call(null,inst_55139);
var inst_55141 = cljs.core.nth.call(null,inst_55140,(0),null);
var inst_55142 = cljs.core.nth.call(null,inst_55140,(1),null);
var inst_55143 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55144 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55146 = [inst_55103,inst_55111,inst_55119,inst_55127];
var inst_55147 = (new cljs.core.PersistentVector(null,4,(5),inst_55145,inst_55146,null));
var inst_55148 = ["query",inst_55147,inst_55141];
var inst_55149 = cljs.core.PersistentHashMap.fromArrays(inst_55144,inst_55148);
var inst_55150 = [inst_55149,inst_55142];
var inst_55151 = (new cljs.core.PersistentVector(null,2,(5),inst_55143,inst_55150,null));
var inst_55152 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55151);
var _ = (function (){var statearr_55184 = state_55157;
(statearr_55184[(4)] = cljs.core.rest.call(null,(state_55157[(4)])));

return statearr_55184;
})();
var state_55157__$1 = (function (){var statearr_55185 = state_55157;
(statearr_55185[(11)] = inst_55152);

return statearr_55185;
})();
var statearr_55186_55235 = state_55157__$1;
(statearr_55186_55235[(2)] = inst_55141);

(statearr_55186_55235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (16))){
var inst_55119 = (state_55157[(2)]);
var inst_55120 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_55157__$1 = (function (){var statearr_55187 = state_55157;
(statearr_55187[(10)] = inst_55119);

return statearr_55187;
})();
if(inst_55120){
var statearr_55188_55236 = state_55157__$1;
(statearr_55188_55236[(1)] = (18));

} else {
var statearr_55189_55237 = state_55157__$1;
(statearr_55189_55237[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55158 === (10))){
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(13),from);
} else {
if((state_val_55158 === (18))){
var state_55157__$1 = state_55157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55157__$1,(21),block);
} else {
if((state_val_55158 === (8))){
var inst_55103 = (state_55157[(2)]);
var inst_55104 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_55157__$1 = (function (){var statearr_55190 = state_55157;
(statearr_55190[(8)] = inst_55103);

return statearr_55190;
})();
if(inst_55104){
var statearr_55191_55238 = state_55157__$1;
(statearr_55191_55238[(1)] = (10));

} else {
var statearr_55192_55239 = state_55157__$1;
(statearr_55192_55239[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55193 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55193[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55193[(1)] = (1));

return statearr_55193;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55157){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55194){var ex__2744__auto__ = e55194;
var statearr_55195_55240 = state_55157;
(statearr_55195_55240[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55157[(4)]))){
var statearr_55196_55241 = state_55157;
(statearr_55196_55241[(1)] = cljs.core.first.call(null,(state_55157[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55242 = state_55157;
state_55157 = G__55242;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55157){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55197 = f__2764__auto__.call(null);
(statearr_55197[(6)] = c__2763__auto__);

return statearr_55197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55298){
var state_val_55299 = (state_55298[(1)]);
if((state_val_55299 === (7))){
var state_55298__$1 = state_55298;
var statearr_55300_55331 = state_55298__$1;
(statearr_55300_55331[(2)] = startSubject);

(statearr_55300_55331[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (1))){
var state_55298__$1 = state_55298;
var statearr_55301_55332 = state_55298__$1;
(statearr_55301_55332[(2)] = null);

(statearr_55301_55332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (4))){
var inst_55243 = (state_55298[(2)]);
var state_55298__$1 = state_55298;
var statearr_55302_55333 = state_55298__$1;
(statearr_55302_55333[(2)] = inst_55243);

(statearr_55302_55333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (15))){
var inst_55275 = (state_55298[(2)]);
var inst_55276 = fluree.db.util.async.throw_err.call(null,inst_55275);
var inst_55277 = cljs.core.nth.call(null,inst_55276,(0),null);
var inst_55278 = cljs.core.nth.call(null,inst_55276,(1),null);
var inst_55279 = cljs.core.empty_QMARK_.call(null,inst_55277);
var state_55298__$1 = (function (){var statearr_55303 = state_55298;
(statearr_55303[(7)] = inst_55278);

return statearr_55303;
})();
if(inst_55279){
var statearr_55304_55334 = state_55298__$1;
(statearr_55304_55334[(1)] = (16));

} else {
var statearr_55305_55335 = state_55298__$1;
(statearr_55305_55335[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (13))){
var inst_55259 = (state_55298[(8)]);
var inst_55263 = (state_55298[(9)]);
var inst_55271 = (state_55298[(10)]);
var inst_55271__$1 = (state_55298[(2)]);
var inst_55272 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55273 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_55272,inst_55259,inst_55263,inst_55271__$1);
var state_55298__$1 = (function (){var statearr_55306 = state_55298;
(statearr_55306[(10)] = inst_55271__$1);

return statearr_55306;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55298__$1,(15),inst_55273);
} else {
if((state_val_55299 === (6))){
var state_55298__$1 = state_55298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55298__$1,(9),startSubject);
} else {
if((state_val_55299 === (17))){
var state_55298__$1 = state_55298;
var statearr_55307_55336 = state_55298__$1;
(statearr_55307_55336[(2)] = true);

(statearr_55307_55336[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (3))){
var inst_55296 = (state_55298[(2)]);
var state_55298__$1 = state_55298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55298__$1,inst_55296);
} else {
if((state_val_55299 === (12))){
var state_55298__$1 = state_55298;
var statearr_55308_55337 = state_55298__$1;
(statearr_55308_55337[(2)] = endSubject);

(statearr_55308_55337[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (2))){
var _ = (function (){var statearr_55309 = state_55298;
(statearr_55309[(4)] = cljs.core.cons.call(null,(5),(state_55298[(4)])));

return statearr_55309;
})();
var inst_55252 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_55298__$1 = state_55298;
if(inst_55252){
var statearr_55310_55338 = state_55298__$1;
(statearr_55310_55338[(1)] = (6));

} else {
var statearr_55311_55339 = state_55298__$1;
(statearr_55311_55339[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (11))){
var state_55298__$1 = state_55298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55298__$1,(14),endSubject);
} else {
if((state_val_55299 === (9))){
var inst_55255 = (state_55298[(2)]);
var inst_55256 = fluree.db.util.async.throw_err.call(null,inst_55255);
var state_55298__$1 = state_55298;
var statearr_55313_55340 = state_55298__$1;
(statearr_55313_55340[(2)] = inst_55256);

(statearr_55313_55340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (5))){
var _ = (function (){var statearr_55314 = state_55298;
(statearr_55314[(4)] = cljs.core.rest.call(null,(state_55298[(4)])));

return statearr_55314;
})();
var state_55298__$1 = state_55298;
var ex55312 = (state_55298__$1[(2)]);
var statearr_55315_55341 = state_55298__$1;
(statearr_55315_55341[(5)] = ex55312);


if((ex55312 instanceof Error)){
var statearr_55316_55342 = state_55298__$1;
(statearr_55316_55342[(1)] = (4));

(statearr_55316_55342[(5)] = null);

} else {
throw ex55312;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (14))){
var inst_55267 = (state_55298[(2)]);
var inst_55268 = fluree.db.util.async.throw_err.call(null,inst_55267);
var state_55298__$1 = state_55298;
var statearr_55317_55343 = state_55298__$1;
(statearr_55317_55343[(2)] = inst_55268);

(statearr_55317_55343[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (16))){
var state_55298__$1 = state_55298;
var statearr_55318_55344 = state_55298__$1;
(statearr_55318_55344[(2)] = false);

(statearr_55318_55344[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (10))){
var inst_55262 = (state_55298[(2)]);
var inst_55263 = fluree.db.util.async.throw_err.call(null,inst_55262);
var inst_55264 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_55298__$1 = (function (){var statearr_55319 = state_55298;
(statearr_55319[(9)] = inst_55263);

return statearr_55319;
})();
if(inst_55264){
var statearr_55320_55345 = state_55298__$1;
(statearr_55320_55345[(1)] = (11));

} else {
var statearr_55321_55346 = state_55298__$1;
(statearr_55321_55346[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (18))){
var inst_55259 = (state_55298[(8)]);
var inst_55263 = (state_55298[(9)]);
var inst_55271 = (state_55298[(10)]);
var inst_55278 = (state_55298[(7)]);
var inst_55283 = (state_55298[(2)]);
var inst_55284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55285 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55287 = [inst_55259,inst_55263,inst_55271];
var inst_55288 = (new cljs.core.PersistentVector(null,3,(5),inst_55286,inst_55287,null));
var inst_55289 = ["relationship?",inst_55288,inst_55283];
var inst_55290 = cljs.core.PersistentHashMap.fromArrays(inst_55285,inst_55289);
var inst_55291 = [inst_55290,inst_55278];
var inst_55292 = (new cljs.core.PersistentVector(null,2,(5),inst_55284,inst_55291,null));
var inst_55293 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55292);
var _ = (function (){var statearr_55322 = state_55298;
(statearr_55322[(4)] = cljs.core.rest.call(null,(state_55298[(4)])));

return statearr_55322;
})();
var state_55298__$1 = (function (){var statearr_55323 = state_55298;
(statearr_55323[(11)] = inst_55293);

return statearr_55323;
})();
var statearr_55324_55347 = state_55298__$1;
(statearr_55324_55347[(2)] = inst_55283);

(statearr_55324_55347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55299 === (8))){
var inst_55259 = (state_55298[(2)]);
var inst_55260 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_55298__$1 = (function (){var statearr_55325 = state_55298;
(statearr_55325[(8)] = inst_55259);

return statearr_55325;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55298__$1,(10),inst_55260);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_55326 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55326[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__);

(statearr_55326[(1)] = (1));

return statearr_55326;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1 = (function (state_55298){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55327){var ex__2744__auto__ = e55327;
var statearr_55328_55348 = state_55298;
(statearr_55328_55348[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55298[(4)]))){
var statearr_55329_55349 = state_55298;
(statearr_55329_55349[(1)] = cljs.core.first.call(null,(state_55298[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55350 = state_55298;
state_55298 = G__55350;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__ = function(state_55298){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1.call(this,state_55298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55330 = f__2764__auto__.call(null);
(statearr_55330[(6)] = c__2763__auto__);

return statearr_55330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55387){
var state_val_55388 = (state_55387[(1)]);
if((state_val_55388 === (7))){
var state_55387__$1 = state_55387;
var statearr_55389_55409 = state_55387__$1;
(statearr_55389_55409[(2)] = pred_name);

(statearr_55389_55409[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (1))){
var state_55387__$1 = state_55387;
var statearr_55390_55410 = state_55387__$1;
(statearr_55390_55410[(2)] = null);

(statearr_55390_55410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (4))){
var inst_55351 = (state_55387[(2)]);
var state_55387__$1 = state_55387;
var statearr_55391_55411 = state_55387__$1;
(statearr_55391_55411[(2)] = inst_55351);

(statearr_55391_55411[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (6))){
var state_55387__$1 = state_55387;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55387__$1,(9),pred_name);
} else {
if((state_val_55388 === (3))){
var inst_55385 = (state_55387[(2)]);
var state_55387__$1 = state_55387;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55387__$1,inst_55385);
} else {
if((state_val_55388 === (2))){
var _ = (function (){var statearr_55393 = state_55387;
(statearr_55393[(4)] = cljs.core.cons.call(null,(5),(state_55387[(4)])));

return statearr_55393;
})();
var inst_55360 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_55387__$1 = state_55387;
if(inst_55360){
var statearr_55394_55412 = state_55387__$1;
(statearr_55394_55412[(1)] = (6));

} else {
var statearr_55395_55413 = state_55387__$1;
(statearr_55395_55413[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (9))){
var inst_55363 = (state_55387[(2)]);
var inst_55364 = fluree.db.util.async.throw_err.call(null,inst_55363);
var state_55387__$1 = state_55387;
var statearr_55396_55414 = state_55387__$1;
(statearr_55396_55414[(2)] = inst_55364);

(statearr_55396_55414[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (5))){
var _ = (function (){var statearr_55397 = state_55387;
(statearr_55397[(4)] = cljs.core.rest.call(null,(state_55387[(4)])));

return statearr_55397;
})();
var state_55387__$1 = state_55387;
var ex55392 = (state_55387__$1[(2)]);
var statearr_55398_55415 = state_55387__$1;
(statearr_55398_55415[(5)] = ex55392);


if((ex55392 instanceof Error)){
var statearr_55399_55416 = state_55387__$1;
(statearr_55399_55416[(1)] = (4));

(statearr_55399_55416[(5)] = null);

} else {
throw ex55392;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (10))){
var inst_55367 = (state_55387[(7)]);
var inst_55371 = (state_55387[(2)]);
var inst_55372 = fluree.db.util.async.throw_err.call(null,inst_55371);
var inst_55373 = cljs.core.nth.call(null,inst_55372,(0),null);
var inst_55374 = cljs.core.nth.call(null,inst_55372,(1),null);
var inst_55375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55376 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55377 = ["max-pred-val",inst_55367,inst_55373];
var inst_55378 = cljs.core.PersistentHashMap.fromArrays(inst_55376,inst_55377);
var inst_55379 = (inst_55374 + (10));
var inst_55380 = [inst_55378,inst_55379];
var inst_55381 = (new cljs.core.PersistentVector(null,2,(5),inst_55375,inst_55380,null));
var inst_55382 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55381);
var _ = (function (){var statearr_55400 = state_55387;
(statearr_55400[(4)] = cljs.core.rest.call(null,(state_55387[(4)])));

return statearr_55400;
})();
var state_55387__$1 = (function (){var statearr_55401 = state_55387;
(statearr_55401[(8)] = inst_55382);

return statearr_55401;
})();
var statearr_55402_55417 = state_55387__$1;
(statearr_55402_55417[(2)] = inst_55373);

(statearr_55402_55417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55388 === (8))){
var inst_55367 = (state_55387[(7)]);
var inst_55367__$1 = (state_55387[(2)]);
var inst_55368 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55369 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_55368,inst_55367__$1,null);
var state_55387__$1 = (function (){var statearr_55403 = state_55387;
(statearr_55403[(7)] = inst_55367__$1);

return statearr_55403;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55387__$1,(10),inst_55369);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0 = (function (){
var statearr_55404 = [null,null,null,null,null,null,null,null,null];
(statearr_55404[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__);

(statearr_55404[(1)] = (1));

return statearr_55404;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1 = (function (state_55387){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55387);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55405){var ex__2744__auto__ = e55405;
var statearr_55406_55418 = state_55387;
(statearr_55406_55418[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55387[(4)]))){
var statearr_55407_55419 = state_55387;
(statearr_55407_55419[(1)] = cljs.core.first.call(null,(state_55387[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55420 = state_55387;
state_55387 = G__55420;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__ = function(state_55387){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1.call(this,state_55387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55408 = f__2764__auto__.call(null);
(statearr_55408[(6)] = c__2763__auto__);

return statearr_55408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55447){
var state_val_55448 = (state_55447[(1)]);
if((state_val_55448 === (7))){
var state_55447__$1 = state_55447;
var statearr_55449_55468 = state_55447__$1;
(statearr_55449_55468[(2)] = n);

(statearr_55449_55468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (1))){
var state_55447__$1 = state_55447;
var statearr_55450_55469 = state_55447__$1;
(statearr_55450_55469[(2)] = null);

(statearr_55450_55469[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (4))){
var inst_55421 = (state_55447[(2)]);
var state_55447__$1 = state_55447;
var statearr_55451_55470 = state_55447__$1;
(statearr_55451_55470[(2)] = inst_55421);

(statearr_55451_55470[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (6))){
var state_55447__$1 = state_55447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55447__$1,(9),n);
} else {
if((state_val_55448 === (3))){
var inst_55445 = (state_55447[(2)]);
var state_55447__$1 = state_55447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55447__$1,inst_55445);
} else {
if((state_val_55448 === (2))){
var _ = (function (){var statearr_55453 = state_55447;
(statearr_55453[(4)] = cljs.core.cons.call(null,(5),(state_55447[(4)])));

return statearr_55453;
})();
var inst_55427 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55447__$1 = state_55447;
if(inst_55427){
var statearr_55454_55471 = state_55447__$1;
(statearr_55454_55471[(1)] = (6));

} else {
var statearr_55455_55472 = state_55447__$1;
(statearr_55455_55472[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (9))){
var inst_55430 = (state_55447[(2)]);
var inst_55431 = fluree.db.util.async.throw_err.call(null,inst_55430);
var state_55447__$1 = state_55447;
var statearr_55456_55473 = state_55447__$1;
(statearr_55456_55473[(2)] = inst_55431);

(statearr_55456_55473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (5))){
var _ = (function (){var statearr_55457 = state_55447;
(statearr_55457[(4)] = cljs.core.rest.call(null,(state_55447[(4)])));

return statearr_55457;
})();
var state_55447__$1 = state_55447;
var ex55452 = (state_55447__$1[(2)]);
var statearr_55458_55474 = state_55447__$1;
(statearr_55458_55474[(5)] = ex55452);


if((ex55452 instanceof Error)){
var statearr_55459_55475 = state_55447__$1;
(statearr_55459_55475[(1)] = (4));

(statearr_55459_55475[(5)] = null);

} else {
throw ex55452;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55448 === (8))){
var inst_55434 = (state_55447[(2)]);
var inst_55435 = fluree.db.dbfunctions.internal.inc.call(null,inst_55434);
var inst_55436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55437 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55438 = ["inc",inst_55434,inst_55435];
var inst_55439 = cljs.core.PersistentHashMap.fromArrays(inst_55437,inst_55438);
var inst_55440 = [inst_55439,(10)];
var inst_55441 = (new cljs.core.PersistentVector(null,2,(5),inst_55436,inst_55440,null));
var inst_55442 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55441);
var _ = (function (){var statearr_55460 = state_55447;
(statearr_55460[(4)] = cljs.core.rest.call(null,(state_55447[(4)])));

return statearr_55460;
})();
var state_55447__$1 = (function (){var statearr_55461 = state_55447;
(statearr_55461[(7)] = inst_55442);

return statearr_55461;
})();
var statearr_55462_55476 = state_55447__$1;
(statearr_55462_55476[(2)] = inst_55435);

(statearr_55462_55476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0 = (function (){
var statearr_55463 = [null,null,null,null,null,null,null,null];
(statearr_55463[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__);

(statearr_55463[(1)] = (1));

return statearr_55463;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1 = (function (state_55447){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55464){var ex__2744__auto__ = e55464;
var statearr_55465_55477 = state_55447;
(statearr_55465_55477[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55447[(4)]))){
var statearr_55466_55478 = state_55447;
(statearr_55466_55478[(1)] = cljs.core.first.call(null,(state_55447[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55479 = state_55447;
state_55447 = G__55479;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__ = function(state_55447){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1.call(this,state_55447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55467 = f__2764__auto__.call(null);
(statearr_55467[(6)] = c__2763__auto__);

return statearr_55467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55506){
var state_val_55507 = (state_55506[(1)]);
if((state_val_55507 === (7))){
var state_55506__$1 = state_55506;
var statearr_55508_55527 = state_55506__$1;
(statearr_55508_55527[(2)] = n);

(statearr_55508_55527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (1))){
var state_55506__$1 = state_55506;
var statearr_55509_55528 = state_55506__$1;
(statearr_55509_55528[(2)] = null);

(statearr_55509_55528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (4))){
var inst_55480 = (state_55506[(2)]);
var state_55506__$1 = state_55506;
var statearr_55510_55529 = state_55506__$1;
(statearr_55510_55529[(2)] = inst_55480);

(statearr_55510_55529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (6))){
var state_55506__$1 = state_55506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55506__$1,(9),n);
} else {
if((state_val_55507 === (3))){
var inst_55504 = (state_55506[(2)]);
var state_55506__$1 = state_55506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55506__$1,inst_55504);
} else {
if((state_val_55507 === (2))){
var _ = (function (){var statearr_55512 = state_55506;
(statearr_55512[(4)] = cljs.core.cons.call(null,(5),(state_55506[(4)])));

return statearr_55512;
})();
var inst_55486 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55506__$1 = state_55506;
if(inst_55486){
var statearr_55513_55530 = state_55506__$1;
(statearr_55513_55530[(1)] = (6));

} else {
var statearr_55514_55531 = state_55506__$1;
(statearr_55514_55531[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (9))){
var inst_55489 = (state_55506[(2)]);
var inst_55490 = fluree.db.util.async.throw_err.call(null,inst_55489);
var state_55506__$1 = state_55506;
var statearr_55515_55532 = state_55506__$1;
(statearr_55515_55532[(2)] = inst_55490);

(statearr_55515_55532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (5))){
var _ = (function (){var statearr_55516 = state_55506;
(statearr_55516[(4)] = cljs.core.rest.call(null,(state_55506[(4)])));

return statearr_55516;
})();
var state_55506__$1 = state_55506;
var ex55511 = (state_55506__$1[(2)]);
var statearr_55517_55533 = state_55506__$1;
(statearr_55517_55533[(5)] = ex55511);


if((ex55511 instanceof Error)){
var statearr_55518_55534 = state_55506__$1;
(statearr_55518_55534[(1)] = (4));

(statearr_55518_55534[(5)] = null);

} else {
throw ex55511;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55507 === (8))){
var inst_55493 = (state_55506[(2)]);
var inst_55494 = fluree.db.dbfunctions.internal.dec.call(null,inst_55493);
var inst_55495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55496 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55497 = ["dec",inst_55493,inst_55494];
var inst_55498 = cljs.core.PersistentHashMap.fromArrays(inst_55496,inst_55497);
var inst_55499 = [inst_55498,(10)];
var inst_55500 = (new cljs.core.PersistentVector(null,2,(5),inst_55495,inst_55499,null));
var inst_55501 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55500);
var _ = (function (){var statearr_55519 = state_55506;
(statearr_55519[(4)] = cljs.core.rest.call(null,(state_55506[(4)])));

return statearr_55519;
})();
var state_55506__$1 = (function (){var statearr_55520 = state_55506;
(statearr_55520[(7)] = inst_55501);

return statearr_55520;
})();
var statearr_55521_55535 = state_55506__$1;
(statearr_55521_55535[(2)] = inst_55494);

(statearr_55521_55535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0 = (function (){
var statearr_55522 = [null,null,null,null,null,null,null,null];
(statearr_55522[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__);

(statearr_55522[(1)] = (1));

return statearr_55522;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1 = (function (state_55506){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55523){var ex__2744__auto__ = e55523;
var statearr_55524_55536 = state_55506;
(statearr_55524_55536[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55506[(4)]))){
var statearr_55525_55537 = state_55506;
(statearr_55525_55537[(1)] = cljs.core.first.call(null,(state_55506[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55538 = state_55506;
state_55506 = G__55538;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__ = function(state_55506){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1.call(this,state_55506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55526 = f__2764__auto__.call(null);
(statearr_55526[(6)] = c__2763__auto__);

return statearr_55526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55588 = arguments.length;
var i__4865__auto___55589 = (0);
while(true){
if((i__4865__auto___55589 < len__4864__auto___55588)){
args__4870__auto__.push((arguments[i__4865__auto___55589]));

var G__55590 = (i__4865__auto___55589 + (1));
i__4865__auto___55589 = G__55590;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55571){
var state_val_55572 = (state_55571[(1)]);
if((state_val_55572 === (1))){
var state_55571__$1 = state_55571;
var statearr_55573_55591 = state_55571__$1;
(statearr_55573_55591[(2)] = null);

(statearr_55573_55591[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55572 === (2))){
var _ = (function (){var statearr_55574 = state_55571;
(statearr_55574[(4)] = cljs.core.cons.call(null,(5),(state_55571[(4)])));

return statearr_55574;
})();
var inst_55547 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55571__$1 = state_55571;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55571__$1,(6),inst_55547);
} else {
if((state_val_55572 === (3))){
var inst_55569 = (state_55571[(2)]);
var state_55571__$1 = state_55571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55571__$1,inst_55569);
} else {
if((state_val_55572 === (4))){
var inst_55541 = (state_55571[(2)]);
var state_55571__$1 = state_55571;
var statearr_55576_55592 = state_55571__$1;
(statearr_55576_55592[(2)] = inst_55541);

(statearr_55576_55592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55572 === (5))){
var _ = (function (){var statearr_55577 = state_55571;
(statearr_55577[(4)] = cljs.core.rest.call(null,(state_55571[(4)])));

return statearr_55577;
})();
var state_55571__$1 = state_55571;
var ex55575 = (state_55571__$1[(2)]);
var statearr_55578_55593 = state_55571__$1;
(statearr_55578_55593[(5)] = ex55575);


if((ex55575 instanceof Error)){
var statearr_55579_55594 = state_55571__$1;
(statearr_55579_55594[(1)] = (4));

(statearr_55579_55594[(5)] = null);

} else {
throw ex55575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55572 === (6))){
var inst_55549 = (state_55571[(2)]);
var inst_55550 = fluree.db.util.async.throw_err.call(null,inst_55549);
var inst_55551 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_55550);
var inst_55552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55553 = [inst_55550];
var inst_55554 = (new cljs.core.PersistentVector(null,1,(5),inst_55552,inst_55553,null));
var inst_55555 = cljs.core.count.call(null,inst_55554);
var inst_55556 = ((9) + inst_55555);
var inst_55557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55558 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55560 = [inst_55550];
var inst_55561 = (new cljs.core.PersistentVector(null,1,(5),inst_55559,inst_55560,null));
var inst_55562 = ["+",inst_55561,inst_55551];
var inst_55563 = cljs.core.PersistentHashMap.fromArrays(inst_55558,inst_55562);
var inst_55564 = [inst_55563,inst_55556];
var inst_55565 = (new cljs.core.PersistentVector(null,2,(5),inst_55557,inst_55564,null));
var inst_55566 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55565);
var _ = (function (){var statearr_55580 = state_55571;
(statearr_55580[(4)] = cljs.core.rest.call(null,(state_55571[(4)])));

return statearr_55580;
})();
var state_55571__$1 = (function (){var statearr_55581 = state_55571;
(statearr_55581[(7)] = inst_55566);

return statearr_55581;
})();
var statearr_55582_55595 = state_55571__$1;
(statearr_55582_55595[(2)] = inst_55551);

(statearr_55582_55595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55583 = [null,null,null,null,null,null,null,null];
(statearr_55583[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55583[(1)] = (1));

return statearr_55583;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55571){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55584){var ex__2744__auto__ = e55584;
var statearr_55585_55596 = state_55571;
(statearr_55585_55596[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55571[(4)]))){
var statearr_55586_55597 = state_55571;
(statearr_55586_55597[(1)] = cljs.core.first.call(null,(state_55571[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55598 = state_55571;
state_55571 = G__55598;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55571){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55587 = f__2764__auto__.call(null);
(statearr_55587[(6)] = c__2763__auto__);

return statearr_55587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55539){
var G__55540 = cljs.core.first.call(null,seq55539);
var seq55539__$1 = cljs.core.next.call(null,seq55539);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55540,seq55539__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55648 = arguments.length;
var i__4865__auto___55649 = (0);
while(true){
if((i__4865__auto___55649 < len__4864__auto___55648)){
args__4870__auto__.push((arguments[i__4865__auto___55649]));

var G__55650 = (i__4865__auto___55649 + (1));
i__4865__auto___55649 = G__55650;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55631){
var state_val_55632 = (state_55631[(1)]);
if((state_val_55632 === (1))){
var state_55631__$1 = state_55631;
var statearr_55633_55651 = state_55631__$1;
(statearr_55633_55651[(2)] = null);

(statearr_55633_55651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (2))){
var _ = (function (){var statearr_55634 = state_55631;
(statearr_55634[(4)] = cljs.core.cons.call(null,(5),(state_55631[(4)])));

return statearr_55634;
})();
var inst_55607 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55631__$1 = state_55631;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55631__$1,(6),inst_55607);
} else {
if((state_val_55632 === (3))){
var inst_55629 = (state_55631[(2)]);
var state_55631__$1 = state_55631;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55631__$1,inst_55629);
} else {
if((state_val_55632 === (4))){
var inst_55601 = (state_55631[(2)]);
var state_55631__$1 = state_55631;
var statearr_55636_55652 = state_55631__$1;
(statearr_55636_55652[(2)] = inst_55601);

(statearr_55636_55652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (5))){
var _ = (function (){var statearr_55637 = state_55631;
(statearr_55637[(4)] = cljs.core.rest.call(null,(state_55631[(4)])));

return statearr_55637;
})();
var state_55631__$1 = state_55631;
var ex55635 = (state_55631__$1[(2)]);
var statearr_55638_55653 = state_55631__$1;
(statearr_55638_55653[(5)] = ex55635);


if((ex55635 instanceof Error)){
var statearr_55639_55654 = state_55631__$1;
(statearr_55639_55654[(1)] = (4));

(statearr_55639_55654[(5)] = null);

} else {
throw ex55635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55632 === (6))){
var inst_55609 = (state_55631[(2)]);
var inst_55610 = fluree.db.util.async.throw_err.call(null,inst_55609);
var inst_55611 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_55610);
var inst_55612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55613 = [inst_55610];
var inst_55614 = (new cljs.core.PersistentVector(null,1,(5),inst_55612,inst_55613,null));
var inst_55615 = cljs.core.count.call(null,inst_55614);
var inst_55616 = ((9) + inst_55615);
var inst_55617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55618 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55620 = [inst_55610];
var inst_55621 = (new cljs.core.PersistentVector(null,1,(5),inst_55619,inst_55620,null));
var inst_55622 = ["-",inst_55621,inst_55611];
var inst_55623 = cljs.core.PersistentHashMap.fromArrays(inst_55618,inst_55622);
var inst_55624 = [inst_55623,inst_55616];
var inst_55625 = (new cljs.core.PersistentVector(null,2,(5),inst_55617,inst_55624,null));
var inst_55626 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55625);
var _ = (function (){var statearr_55640 = state_55631;
(statearr_55640[(4)] = cljs.core.rest.call(null,(state_55631[(4)])));

return statearr_55640;
})();
var state_55631__$1 = (function (){var statearr_55641 = state_55631;
(statearr_55641[(7)] = inst_55626);

return statearr_55641;
})();
var statearr_55642_55655 = state_55631__$1;
(statearr_55642_55655[(2)] = inst_55611);

(statearr_55642_55655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55643 = [null,null,null,null,null,null,null,null];
(statearr_55643[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55643[(1)] = (1));

return statearr_55643;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55631){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55631);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55644){var ex__2744__auto__ = e55644;
var statearr_55645_55656 = state_55631;
(statearr_55645_55656[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55631[(4)]))){
var statearr_55646_55657 = state_55631;
(statearr_55646_55657[(1)] = cljs.core.first.call(null,(state_55631[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55658 = state_55631;
state_55631 = G__55658;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55631){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55647 = f__2764__auto__.call(null);
(statearr_55647[(6)] = c__2763__auto__);

return statearr_55647;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55599){
var G__55600 = cljs.core.first.call(null,seq55599);
var seq55599__$1 = cljs.core.next.call(null,seq55599);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55600,seq55599__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55708 = arguments.length;
var i__4865__auto___55709 = (0);
while(true){
if((i__4865__auto___55709 < len__4864__auto___55708)){
args__4870__auto__.push((arguments[i__4865__auto___55709]));

var G__55710 = (i__4865__auto___55709 + (1));
i__4865__auto___55709 = G__55710;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55691){
var state_val_55692 = (state_55691[(1)]);
if((state_val_55692 === (1))){
var state_55691__$1 = state_55691;
var statearr_55693_55711 = state_55691__$1;
(statearr_55693_55711[(2)] = null);

(statearr_55693_55711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (2))){
var _ = (function (){var statearr_55694 = state_55691;
(statearr_55694[(4)] = cljs.core.cons.call(null,(5),(state_55691[(4)])));

return statearr_55694;
})();
var inst_55667 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55691__$1 = state_55691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55691__$1,(6),inst_55667);
} else {
if((state_val_55692 === (3))){
var inst_55689 = (state_55691[(2)]);
var state_55691__$1 = state_55691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55691__$1,inst_55689);
} else {
if((state_val_55692 === (4))){
var inst_55661 = (state_55691[(2)]);
var state_55691__$1 = state_55691;
var statearr_55696_55712 = state_55691__$1;
(statearr_55696_55712[(2)] = inst_55661);

(statearr_55696_55712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (5))){
var _ = (function (){var statearr_55697 = state_55691;
(statearr_55697[(4)] = cljs.core.rest.call(null,(state_55691[(4)])));

return statearr_55697;
})();
var state_55691__$1 = state_55691;
var ex55695 = (state_55691__$1[(2)]);
var statearr_55698_55713 = state_55691__$1;
(statearr_55698_55713[(5)] = ex55695);


if((ex55695 instanceof Error)){
var statearr_55699_55714 = state_55691__$1;
(statearr_55699_55714[(1)] = (4));

(statearr_55699_55714[(5)] = null);

} else {
throw ex55695;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55692 === (6))){
var inst_55669 = (state_55691[(2)]);
var inst_55670 = fluree.db.util.async.throw_err.call(null,inst_55669);
var inst_55671 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_55670);
var inst_55672 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55673 = [inst_55670];
var inst_55674 = (new cljs.core.PersistentVector(null,1,(5),inst_55672,inst_55673,null));
var inst_55675 = cljs.core.count.call(null,inst_55674);
var inst_55676 = ((9) + inst_55675);
var inst_55677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55678 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55680 = [inst_55670];
var inst_55681 = (new cljs.core.PersistentVector(null,1,(5),inst_55679,inst_55680,null));
var inst_55682 = ["*",inst_55681,inst_55671];
var inst_55683 = cljs.core.PersistentHashMap.fromArrays(inst_55678,inst_55682);
var inst_55684 = [inst_55683,inst_55676];
var inst_55685 = (new cljs.core.PersistentVector(null,2,(5),inst_55677,inst_55684,null));
var inst_55686 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55685);
var _ = (function (){var statearr_55700 = state_55691;
(statearr_55700[(4)] = cljs.core.rest.call(null,(state_55691[(4)])));

return statearr_55700;
})();
var state_55691__$1 = (function (){var statearr_55701 = state_55691;
(statearr_55701[(7)] = inst_55686);

return statearr_55701;
})();
var statearr_55702_55715 = state_55691__$1;
(statearr_55702_55715[(2)] = inst_55671);

(statearr_55702_55715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55703 = [null,null,null,null,null,null,null,null];
(statearr_55703[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55703[(1)] = (1));

return statearr_55703;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55691){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55704){var ex__2744__auto__ = e55704;
var statearr_55705_55716 = state_55691;
(statearr_55705_55716[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55691[(4)]))){
var statearr_55706_55717 = state_55691;
(statearr_55706_55717[(1)] = cljs.core.first.call(null,(state_55691[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55718 = state_55691;
state_55691 = G__55718;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55707 = f__2764__auto__.call(null);
(statearr_55707[(6)] = c__2763__auto__);

return statearr_55707;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55659){
var G__55660 = cljs.core.first.call(null,seq55659);
var seq55659__$1 = cljs.core.next.call(null,seq55659);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55660,seq55659__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55768 = arguments.length;
var i__4865__auto___55769 = (0);
while(true){
if((i__4865__auto___55769 < len__4864__auto___55768)){
args__4870__auto__.push((arguments[i__4865__auto___55769]));

var G__55770 = (i__4865__auto___55769 + (1));
i__4865__auto___55769 = G__55770;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55751){
var state_val_55752 = (state_55751[(1)]);
if((state_val_55752 === (1))){
var state_55751__$1 = state_55751;
var statearr_55753_55771 = state_55751__$1;
(statearr_55753_55771[(2)] = null);

(statearr_55753_55771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55752 === (2))){
var _ = (function (){var statearr_55754 = state_55751;
(statearr_55754[(4)] = cljs.core.cons.call(null,(5),(state_55751[(4)])));

return statearr_55754;
})();
var inst_55727 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55751__$1 = state_55751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55751__$1,(6),inst_55727);
} else {
if((state_val_55752 === (3))){
var inst_55749 = (state_55751[(2)]);
var state_55751__$1 = state_55751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55751__$1,inst_55749);
} else {
if((state_val_55752 === (4))){
var inst_55721 = (state_55751[(2)]);
var state_55751__$1 = state_55751;
var statearr_55756_55772 = state_55751__$1;
(statearr_55756_55772[(2)] = inst_55721);

(statearr_55756_55772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55752 === (5))){
var _ = (function (){var statearr_55757 = state_55751;
(statearr_55757[(4)] = cljs.core.rest.call(null,(state_55751[(4)])));

return statearr_55757;
})();
var state_55751__$1 = state_55751;
var ex55755 = (state_55751__$1[(2)]);
var statearr_55758_55773 = state_55751__$1;
(statearr_55758_55773[(5)] = ex55755);


if((ex55755 instanceof Error)){
var statearr_55759_55774 = state_55751__$1;
(statearr_55759_55774[(1)] = (4));

(statearr_55759_55774[(5)] = null);

} else {
throw ex55755;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55752 === (6))){
var inst_55729 = (state_55751[(2)]);
var inst_55730 = fluree.db.util.async.throw_err.call(null,inst_55729);
var inst_55731 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_55730);
var inst_55732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55733 = [inst_55730];
var inst_55734 = (new cljs.core.PersistentVector(null,1,(5),inst_55732,inst_55733,null));
var inst_55735 = cljs.core.count.call(null,inst_55734);
var inst_55736 = ((9) + inst_55735);
var inst_55737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55738 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55739 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55740 = [inst_55730];
var inst_55741 = (new cljs.core.PersistentVector(null,1,(5),inst_55739,inst_55740,null));
var inst_55742 = ["/",inst_55741,inst_55731];
var inst_55743 = cljs.core.PersistentHashMap.fromArrays(inst_55738,inst_55742);
var inst_55744 = [inst_55743,inst_55736];
var inst_55745 = (new cljs.core.PersistentVector(null,2,(5),inst_55737,inst_55744,null));
var inst_55746 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55745);
var _ = (function (){var statearr_55760 = state_55751;
(statearr_55760[(4)] = cljs.core.rest.call(null,(state_55751[(4)])));

return statearr_55760;
})();
var state_55751__$1 = (function (){var statearr_55761 = state_55751;
(statearr_55761[(7)] = inst_55746);

return statearr_55761;
})();
var statearr_55762_55775 = state_55751__$1;
(statearr_55762_55775[(2)] = inst_55731);

(statearr_55762_55775[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55763 = [null,null,null,null,null,null,null,null];
(statearr_55763[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55763[(1)] = (1));

return statearr_55763;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55751){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55764){var ex__2744__auto__ = e55764;
var statearr_55765_55776 = state_55751;
(statearr_55765_55776[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55751[(4)]))){
var statearr_55766_55777 = state_55751;
(statearr_55766_55777[(1)] = cljs.core.first.call(null,(state_55751[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55778 = state_55751;
state_55751 = G__55778;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55751){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55767 = f__2764__auto__.call(null);
(statearr_55767[(6)] = c__2763__auto__);

return statearr_55767;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55719){
var G__55720 = cljs.core.first.call(null,seq55719);
var seq55719__$1 = cljs.core.next.call(null,seq55719);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55720,seq55719__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55816){
var state_val_55817 = (state_55816[(1)]);
if((state_val_55817 === (7))){
var state_55816__$1 = state_55816;
var statearr_55818_55842 = state_55816__$1;
(statearr_55818_55842[(2)] = n);

(statearr_55818_55842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (1))){
var state_55816__$1 = state_55816;
var statearr_55819_55843 = state_55816__$1;
(statearr_55819_55843[(2)] = null);

(statearr_55819_55843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (4))){
var inst_55779 = (state_55816[(2)]);
var state_55816__$1 = state_55816;
var statearr_55820_55844 = state_55816__$1;
(statearr_55820_55844[(2)] = inst_55779);

(statearr_55820_55844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (13))){
var inst_55796 = (state_55816[(2)]);
var inst_55797 = fluree.db.util.async.throw_err.call(null,inst_55796);
var state_55816__$1 = state_55816;
var statearr_55821_55845 = state_55816__$1;
(statearr_55821_55845[(2)] = inst_55797);

(statearr_55821_55845[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (6))){
var state_55816__$1 = state_55816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55816__$1,(9),n);
} else {
if((state_val_55817 === (3))){
var inst_55814 = (state_55816[(2)]);
var state_55816__$1 = state_55816;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55816__$1,inst_55814);
} else {
if((state_val_55817 === (12))){
var inst_55792 = (state_55816[(7)]);
var inst_55800 = (state_55816[(2)]);
var inst_55801 = fluree.db.dbfunctions.internal.quot.call(null,inst_55792,inst_55800);
var inst_55802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55803 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55805 = [inst_55792,inst_55800];
var inst_55806 = (new cljs.core.PersistentVector(null,2,(5),inst_55804,inst_55805,null));
var inst_55807 = ["quot",inst_55806,inst_55801];
var inst_55808 = cljs.core.PersistentHashMap.fromArrays(inst_55803,inst_55807);
var inst_55809 = [inst_55808,(2)];
var inst_55810 = (new cljs.core.PersistentVector(null,2,(5),inst_55802,inst_55809,null));
var inst_55811 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55810);
var _ = (function (){var statearr_55822 = state_55816;
(statearr_55822[(4)] = cljs.core.rest.call(null,(state_55816[(4)])));

return statearr_55822;
})();
var state_55816__$1 = (function (){var statearr_55823 = state_55816;
(statearr_55823[(8)] = inst_55811);

return statearr_55823;
})();
var statearr_55824_55846 = state_55816__$1;
(statearr_55824_55846[(2)] = inst_55801);

(statearr_55824_55846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (2))){
var _ = (function (){var statearr_55825 = state_55816;
(statearr_55825[(4)] = cljs.core.cons.call(null,(5),(state_55816[(4)])));

return statearr_55825;
})();
var inst_55785 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55816__$1 = state_55816;
if(inst_55785){
var statearr_55826_55847 = state_55816__$1;
(statearr_55826_55847[(1)] = (6));

} else {
var statearr_55827_55848 = state_55816__$1;
(statearr_55827_55848[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (11))){
var state_55816__$1 = state_55816;
var statearr_55829_55849 = state_55816__$1;
(statearr_55829_55849[(2)] = d);

(statearr_55829_55849[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (9))){
var inst_55788 = (state_55816[(2)]);
var inst_55789 = fluree.db.util.async.throw_err.call(null,inst_55788);
var state_55816__$1 = state_55816;
var statearr_55830_55850 = state_55816__$1;
(statearr_55830_55850[(2)] = inst_55789);

(statearr_55830_55850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (5))){
var _ = (function (){var statearr_55831 = state_55816;
(statearr_55831[(4)] = cljs.core.rest.call(null,(state_55816[(4)])));

return statearr_55831;
})();
var state_55816__$1 = state_55816;
var ex55828 = (state_55816__$1[(2)]);
var statearr_55832_55851 = state_55816__$1;
(statearr_55832_55851[(5)] = ex55828);


if((ex55828 instanceof Error)){
var statearr_55833_55852 = state_55816__$1;
(statearr_55833_55852[(1)] = (4));

(statearr_55833_55852[(5)] = null);

} else {
throw ex55828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55817 === (10))){
var state_55816__$1 = state_55816;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55816__$1,(13),d);
} else {
if((state_val_55817 === (8))){
var inst_55792 = (state_55816[(2)]);
var inst_55793 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55816__$1 = (function (){var statearr_55834 = state_55816;
(statearr_55834[(7)] = inst_55792);

return statearr_55834;
})();
if(inst_55793){
var statearr_55835_55853 = state_55816__$1;
(statearr_55835_55853[(1)] = (10));

} else {
var statearr_55836_55854 = state_55816__$1;
(statearr_55836_55854[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0 = (function (){
var statearr_55837 = [null,null,null,null,null,null,null,null,null];
(statearr_55837[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__);

(statearr_55837[(1)] = (1));

return statearr_55837;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1 = (function (state_55816){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55816);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55838){var ex__2744__auto__ = e55838;
var statearr_55839_55855 = state_55816;
(statearr_55839_55855[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55816[(4)]))){
var statearr_55840_55856 = state_55816;
(statearr_55840_55856[(1)] = cljs.core.first.call(null,(state_55816[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55857 = state_55816;
state_55816 = G__55857;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__ = function(state_55816){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1.call(this,state_55816);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55841 = f__2764__auto__.call(null);
(statearr_55841[(6)] = c__2763__auto__);

return statearr_55841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55895){
var state_val_55896 = (state_55895[(1)]);
if((state_val_55896 === (7))){
var state_55895__$1 = state_55895;
var statearr_55897_55921 = state_55895__$1;
(statearr_55897_55921[(2)] = n);

(statearr_55897_55921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (1))){
var state_55895__$1 = state_55895;
var statearr_55898_55922 = state_55895__$1;
(statearr_55898_55922[(2)] = null);

(statearr_55898_55922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (4))){
var inst_55858 = (state_55895[(2)]);
var state_55895__$1 = state_55895;
var statearr_55899_55923 = state_55895__$1;
(statearr_55899_55923[(2)] = inst_55858);

(statearr_55899_55923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (13))){
var inst_55875 = (state_55895[(2)]);
var inst_55876 = fluree.db.util.async.throw_err.call(null,inst_55875);
var state_55895__$1 = state_55895;
var statearr_55900_55924 = state_55895__$1;
(statearr_55900_55924[(2)] = inst_55876);

(statearr_55900_55924[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (6))){
var state_55895__$1 = state_55895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55895__$1,(9),n);
} else {
if((state_val_55896 === (3))){
var inst_55893 = (state_55895[(2)]);
var state_55895__$1 = state_55895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55895__$1,inst_55893);
} else {
if((state_val_55896 === (12))){
var inst_55871 = (state_55895[(7)]);
var inst_55879 = (state_55895[(2)]);
var inst_55880 = fluree.db.dbfunctions.internal.mod.call(null,inst_55871,inst_55879);
var inst_55881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55882 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55884 = [inst_55871,inst_55879];
var inst_55885 = (new cljs.core.PersistentVector(null,2,(5),inst_55883,inst_55884,null));
var inst_55886 = ["mod",inst_55885,inst_55880];
var inst_55887 = cljs.core.PersistentHashMap.fromArrays(inst_55882,inst_55886);
var inst_55888 = [inst_55887,(2)];
var inst_55889 = (new cljs.core.PersistentVector(null,2,(5),inst_55881,inst_55888,null));
var inst_55890 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55889);
var _ = (function (){var statearr_55901 = state_55895;
(statearr_55901[(4)] = cljs.core.rest.call(null,(state_55895[(4)])));

return statearr_55901;
})();
var state_55895__$1 = (function (){var statearr_55902 = state_55895;
(statearr_55902[(8)] = inst_55890);

return statearr_55902;
})();
var statearr_55903_55925 = state_55895__$1;
(statearr_55903_55925[(2)] = inst_55880);

(statearr_55903_55925[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (2))){
var _ = (function (){var statearr_55904 = state_55895;
(statearr_55904[(4)] = cljs.core.cons.call(null,(5),(state_55895[(4)])));

return statearr_55904;
})();
var inst_55864 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55895__$1 = state_55895;
if(inst_55864){
var statearr_55905_55926 = state_55895__$1;
(statearr_55905_55926[(1)] = (6));

} else {
var statearr_55906_55927 = state_55895__$1;
(statearr_55906_55927[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (11))){
var state_55895__$1 = state_55895;
var statearr_55908_55928 = state_55895__$1;
(statearr_55908_55928[(2)] = d);

(statearr_55908_55928[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (9))){
var inst_55867 = (state_55895[(2)]);
var inst_55868 = fluree.db.util.async.throw_err.call(null,inst_55867);
var state_55895__$1 = state_55895;
var statearr_55909_55929 = state_55895__$1;
(statearr_55909_55929[(2)] = inst_55868);

(statearr_55909_55929[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (5))){
var _ = (function (){var statearr_55910 = state_55895;
(statearr_55910[(4)] = cljs.core.rest.call(null,(state_55895[(4)])));

return statearr_55910;
})();
var state_55895__$1 = state_55895;
var ex55907 = (state_55895__$1[(2)]);
var statearr_55911_55930 = state_55895__$1;
(statearr_55911_55930[(5)] = ex55907);


if((ex55907 instanceof Error)){
var statearr_55912_55931 = state_55895__$1;
(statearr_55912_55931[(1)] = (4));

(statearr_55912_55931[(5)] = null);

} else {
throw ex55907;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55896 === (10))){
var state_55895__$1 = state_55895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55895__$1,(13),d);
} else {
if((state_val_55896 === (8))){
var inst_55871 = (state_55895[(2)]);
var inst_55872 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55895__$1 = (function (){var statearr_55913 = state_55895;
(statearr_55913[(7)] = inst_55871);

return statearr_55913;
})();
if(inst_55872){
var statearr_55914_55932 = state_55895__$1;
(statearr_55914_55932[(1)] = (10));

} else {
var statearr_55915_55933 = state_55895__$1;
(statearr_55915_55933[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0 = (function (){
var statearr_55916 = [null,null,null,null,null,null,null,null,null];
(statearr_55916[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__);

(statearr_55916[(1)] = (1));

return statearr_55916;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1 = (function (state_55895){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55917){var ex__2744__auto__ = e55917;
var statearr_55918_55934 = state_55895;
(statearr_55918_55934[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55895[(4)]))){
var statearr_55919_55935 = state_55895;
(statearr_55919_55935[(1)] = cljs.core.first.call(null,(state_55895[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55936 = state_55895;
state_55895 = G__55936;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__ = function(state_55895){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1.call(this,state_55895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55920 = f__2764__auto__.call(null);
(statearr_55920[(6)] = c__2763__auto__);

return statearr_55920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55974){
var state_val_55975 = (state_55974[(1)]);
if((state_val_55975 === (7))){
var state_55974__$1 = state_55974;
var statearr_55976_56000 = state_55974__$1;
(statearr_55976_56000[(2)] = n);

(statearr_55976_56000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (1))){
var state_55974__$1 = state_55974;
var statearr_55977_56001 = state_55974__$1;
(statearr_55977_56001[(2)] = null);

(statearr_55977_56001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (4))){
var inst_55937 = (state_55974[(2)]);
var state_55974__$1 = state_55974;
var statearr_55978_56002 = state_55974__$1;
(statearr_55978_56002[(2)] = inst_55937);

(statearr_55978_56002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (13))){
var inst_55954 = (state_55974[(2)]);
var inst_55955 = fluree.db.util.async.throw_err.call(null,inst_55954);
var state_55974__$1 = state_55974;
var statearr_55979_56003 = state_55974__$1;
(statearr_55979_56003[(2)] = inst_55955);

(statearr_55979_56003[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (6))){
var state_55974__$1 = state_55974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55974__$1,(9),n);
} else {
if((state_val_55975 === (3))){
var inst_55972 = (state_55974[(2)]);
var state_55974__$1 = state_55974;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55974__$1,inst_55972);
} else {
if((state_val_55975 === (12))){
var inst_55950 = (state_55974[(7)]);
var inst_55958 = (state_55974[(2)]);
var inst_55959 = fluree.db.dbfunctions.internal.rem.call(null,inst_55950,inst_55958);
var inst_55960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55961 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55963 = [inst_55950,inst_55958];
var inst_55964 = (new cljs.core.PersistentVector(null,2,(5),inst_55962,inst_55963,null));
var inst_55965 = ["rem",inst_55964,inst_55959];
var inst_55966 = cljs.core.PersistentHashMap.fromArrays(inst_55961,inst_55965);
var inst_55967 = [inst_55966,(2)];
var inst_55968 = (new cljs.core.PersistentVector(null,2,(5),inst_55960,inst_55967,null));
var inst_55969 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55968);
var _ = (function (){var statearr_55980 = state_55974;
(statearr_55980[(4)] = cljs.core.rest.call(null,(state_55974[(4)])));

return statearr_55980;
})();
var state_55974__$1 = (function (){var statearr_55981 = state_55974;
(statearr_55981[(8)] = inst_55969);

return statearr_55981;
})();
var statearr_55982_56004 = state_55974__$1;
(statearr_55982_56004[(2)] = inst_55959);

(statearr_55982_56004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (2))){
var _ = (function (){var statearr_55983 = state_55974;
(statearr_55983[(4)] = cljs.core.cons.call(null,(5),(state_55974[(4)])));

return statearr_55983;
})();
var inst_55943 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_55974__$1 = state_55974;
if(inst_55943){
var statearr_55984_56005 = state_55974__$1;
(statearr_55984_56005[(1)] = (6));

} else {
var statearr_55985_56006 = state_55974__$1;
(statearr_55985_56006[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (11))){
var state_55974__$1 = state_55974;
var statearr_55987_56007 = state_55974__$1;
(statearr_55987_56007[(2)] = d);

(statearr_55987_56007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (9))){
var inst_55946 = (state_55974[(2)]);
var inst_55947 = fluree.db.util.async.throw_err.call(null,inst_55946);
var state_55974__$1 = state_55974;
var statearr_55988_56008 = state_55974__$1;
(statearr_55988_56008[(2)] = inst_55947);

(statearr_55988_56008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (5))){
var _ = (function (){var statearr_55989 = state_55974;
(statearr_55989[(4)] = cljs.core.rest.call(null,(state_55974[(4)])));

return statearr_55989;
})();
var state_55974__$1 = state_55974;
var ex55986 = (state_55974__$1[(2)]);
var statearr_55990_56009 = state_55974__$1;
(statearr_55990_56009[(5)] = ex55986);


if((ex55986 instanceof Error)){
var statearr_55991_56010 = state_55974__$1;
(statearr_55991_56010[(1)] = (4));

(statearr_55991_56010[(5)] = null);

} else {
throw ex55986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55975 === (10))){
var state_55974__$1 = state_55974;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55974__$1,(13),d);
} else {
if((state_val_55975 === (8))){
var inst_55950 = (state_55974[(2)]);
var inst_55951 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_55974__$1 = (function (){var statearr_55992 = state_55974;
(statearr_55992[(7)] = inst_55950);

return statearr_55992;
})();
if(inst_55951){
var statearr_55993_56011 = state_55974__$1;
(statearr_55993_56011[(1)] = (10));

} else {
var statearr_55994_56012 = state_55974__$1;
(statearr_55994_56012[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0 = (function (){
var statearr_55995 = [null,null,null,null,null,null,null,null,null];
(statearr_55995[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__);

(statearr_55995[(1)] = (1));

return statearr_55995;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1 = (function (state_55974){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_55974);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55996){var ex__2744__auto__ = e55996;
var statearr_55997_56013 = state_55974;
(statearr_55997_56013[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_55974[(4)]))){
var statearr_55998_56014 = state_55974;
(statearr_55998_56014[(1)] = cljs.core.first.call(null,(state_55974[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56015 = state_55974;
state_55974 = G__56015;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__ = function(state_55974){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1.call(this,state_55974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55999 = f__2764__auto__.call(null);
(statearr_55999[(6)] = c__2763__auto__);

return statearr_55999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56042){
var state_val_56043 = (state_56042[(1)]);
if((state_val_56043 === (7))){
var state_56042__$1 = state_56042;
var statearr_56044_56063 = state_56042__$1;
(statearr_56044_56063[(2)] = x);

(statearr_56044_56063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (1))){
var state_56042__$1 = state_56042;
var statearr_56045_56064 = state_56042__$1;
(statearr_56045_56064[(2)] = null);

(statearr_56045_56064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (4))){
var inst_56016 = (state_56042[(2)]);
var state_56042__$1 = state_56042;
var statearr_56046_56065 = state_56042__$1;
(statearr_56046_56065[(2)] = inst_56016);

(statearr_56046_56065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (6))){
var state_56042__$1 = state_56042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56042__$1,(9),x);
} else {
if((state_val_56043 === (3))){
var inst_56040 = (state_56042[(2)]);
var state_56042__$1 = state_56042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56042__$1,inst_56040);
} else {
if((state_val_56043 === (2))){
var _ = (function (){var statearr_56048 = state_56042;
(statearr_56048[(4)] = cljs.core.cons.call(null,(5),(state_56042[(4)])));

return statearr_56048;
})();
var inst_56022 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_56042__$1 = state_56042;
if(inst_56022){
var statearr_56049_56066 = state_56042__$1;
(statearr_56049_56066[(1)] = (6));

} else {
var statearr_56050_56067 = state_56042__$1;
(statearr_56050_56067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (9))){
var inst_56025 = (state_56042[(2)]);
var inst_56026 = fluree.db.util.async.throw_err.call(null,inst_56025);
var state_56042__$1 = state_56042;
var statearr_56051_56068 = state_56042__$1;
(statearr_56051_56068[(2)] = inst_56026);

(statearr_56051_56068[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (5))){
var _ = (function (){var statearr_56052 = state_56042;
(statearr_56052[(4)] = cljs.core.rest.call(null,(state_56042[(4)])));

return statearr_56052;
})();
var state_56042__$1 = state_56042;
var ex56047 = (state_56042__$1[(2)]);
var statearr_56053_56069 = state_56042__$1;
(statearr_56053_56069[(5)] = ex56047);


if((ex56047 instanceof Error)){
var statearr_56054_56070 = state_56042__$1;
(statearr_56054_56070[(1)] = (4));

(statearr_56054_56070[(5)] = null);

} else {
throw ex56047;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56043 === (8))){
var inst_56029 = (state_56042[(2)]);
var inst_56030 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_56029);
var inst_56031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56032 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56033 = ["boolean",inst_56029,inst_56030];
var inst_56034 = cljs.core.PersistentHashMap.fromArrays(inst_56032,inst_56033);
var inst_56035 = [inst_56034,(10)];
var inst_56036 = (new cljs.core.PersistentVector(null,2,(5),inst_56031,inst_56035,null));
var inst_56037 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56036);
var _ = (function (){var statearr_56055 = state_56042;
(statearr_56055[(4)] = cljs.core.rest.call(null,(state_56042[(4)])));

return statearr_56055;
})();
var state_56042__$1 = (function (){var statearr_56056 = state_56042;
(statearr_56056[(7)] = inst_56037);

return statearr_56056;
})();
var statearr_56057_56071 = state_56042__$1;
(statearr_56057_56071[(2)] = inst_56030);

(statearr_56057_56071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0 = (function (){
var statearr_56058 = [null,null,null,null,null,null,null,null];
(statearr_56058[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__);

(statearr_56058[(1)] = (1));

return statearr_56058;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1 = (function (state_56042){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56059){var ex__2744__auto__ = e56059;
var statearr_56060_56072 = state_56042;
(statearr_56060_56072[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56042[(4)]))){
var statearr_56061_56073 = state_56042;
(statearr_56061_56073[(1)] = cljs.core.first.call(null,(state_56042[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56074 = state_56042;
state_56042 = G__56074;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__ = function(state_56042){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1.call(this,state_56042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56062 = f__2764__auto__.call(null);
(statearr_56062[(6)] = c__2763__auto__);

return statearr_56062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56112){
var state_val_56113 = (state_56112[(1)]);
if((state_val_56113 === (7))){
var state_56112__$1 = state_56112;
var statearr_56114_56138 = state_56112__$1;
(statearr_56114_56138[(2)] = pattern);

(statearr_56114_56138[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (1))){
var state_56112__$1 = state_56112;
var statearr_56115_56139 = state_56112__$1;
(statearr_56115_56139[(2)] = null);

(statearr_56115_56139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (4))){
var inst_56075 = (state_56112[(2)]);
var state_56112__$1 = state_56112;
var statearr_56116_56140 = state_56112__$1;
(statearr_56116_56140[(2)] = inst_56075);

(statearr_56116_56140[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (13))){
var inst_56092 = (state_56112[(2)]);
var inst_56093 = fluree.db.util.async.throw_err.call(null,inst_56092);
var state_56112__$1 = state_56112;
var statearr_56117_56141 = state_56112__$1;
(statearr_56117_56141[(2)] = inst_56093);

(statearr_56117_56141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (6))){
var state_56112__$1 = state_56112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56112__$1,(9),pattern);
} else {
if((state_val_56113 === (3))){
var inst_56110 = (state_56112[(2)]);
var state_56112__$1 = state_56112;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56112__$1,inst_56110);
} else {
if((state_val_56113 === (12))){
var inst_56088 = (state_56112[(7)]);
var inst_56096 = (state_56112[(2)]);
var inst_56097 = fluree.db.dbfunctions.internal.re_find.call(null,inst_56088,inst_56096);
var inst_56098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56099 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56101 = [inst_56088,inst_56096];
var inst_56102 = (new cljs.core.PersistentVector(null,2,(5),inst_56100,inst_56101,null));
var inst_56103 = ["re-find",inst_56102,inst_56097];
var inst_56104 = cljs.core.PersistentHashMap.fromArrays(inst_56099,inst_56103);
var inst_56105 = [inst_56104,(10)];
var inst_56106 = (new cljs.core.PersistentVector(null,2,(5),inst_56098,inst_56105,null));
var inst_56107 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56106);
var _ = (function (){var statearr_56118 = state_56112;
(statearr_56118[(4)] = cljs.core.rest.call(null,(state_56112[(4)])));

return statearr_56118;
})();
var state_56112__$1 = (function (){var statearr_56119 = state_56112;
(statearr_56119[(8)] = inst_56107);

return statearr_56119;
})();
var statearr_56120_56142 = state_56112__$1;
(statearr_56120_56142[(2)] = inst_56097);

(statearr_56120_56142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (2))){
var _ = (function (){var statearr_56121 = state_56112;
(statearr_56121[(4)] = cljs.core.cons.call(null,(5),(state_56112[(4)])));

return statearr_56121;
})();
var inst_56081 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_56112__$1 = state_56112;
if(inst_56081){
var statearr_56122_56143 = state_56112__$1;
(statearr_56122_56143[(1)] = (6));

} else {
var statearr_56123_56144 = state_56112__$1;
(statearr_56123_56144[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (11))){
var state_56112__$1 = state_56112;
var statearr_56125_56145 = state_56112__$1;
(statearr_56125_56145[(2)] = string);

(statearr_56125_56145[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (9))){
var inst_56084 = (state_56112[(2)]);
var inst_56085 = fluree.db.util.async.throw_err.call(null,inst_56084);
var state_56112__$1 = state_56112;
var statearr_56126_56146 = state_56112__$1;
(statearr_56126_56146[(2)] = inst_56085);

(statearr_56126_56146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (5))){
var _ = (function (){var statearr_56127 = state_56112;
(statearr_56127[(4)] = cljs.core.rest.call(null,(state_56112[(4)])));

return statearr_56127;
})();
var state_56112__$1 = state_56112;
var ex56124 = (state_56112__$1[(2)]);
var statearr_56128_56147 = state_56112__$1;
(statearr_56128_56147[(5)] = ex56124);


if((ex56124 instanceof Error)){
var statearr_56129_56148 = state_56112__$1;
(statearr_56129_56148[(1)] = (4));

(statearr_56129_56148[(5)] = null);

} else {
throw ex56124;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56113 === (10))){
var state_56112__$1 = state_56112;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56112__$1,(13),string);
} else {
if((state_val_56113 === (8))){
var inst_56088 = (state_56112[(2)]);
var inst_56089 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_56112__$1 = (function (){var statearr_56130 = state_56112;
(statearr_56130[(7)] = inst_56088);

return statearr_56130;
})();
if(inst_56089){
var statearr_56131_56149 = state_56112__$1;
(statearr_56131_56149[(1)] = (10));

} else {
var statearr_56132_56150 = state_56112__$1;
(statearr_56132_56150[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0 = (function (){
var statearr_56133 = [null,null,null,null,null,null,null,null,null];
(statearr_56133[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__);

(statearr_56133[(1)] = (1));

return statearr_56133;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1 = (function (state_56112){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56112);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56134){var ex__2744__auto__ = e56134;
var statearr_56135_56151 = state_56112;
(statearr_56135_56151[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56112[(4)]))){
var statearr_56136_56152 = state_56112;
(statearr_56136_56152[(1)] = cljs.core.first.call(null,(state_56112[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56153 = state_56112;
state_56112 = G__56153;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__ = function(state_56112){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1.call(this,state_56112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56137 = f__2764__auto__.call(null);
(statearr_56137[(6)] = c__2763__auto__);

return statearr_56137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56180){
var state_val_56181 = (state_56180[(1)]);
if((state_val_56181 === (7))){
var state_56180__$1 = state_56180;
var statearr_56182_56201 = state_56180__$1;
(statearr_56182_56201[(2)] = email);

(statearr_56182_56201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (1))){
var state_56180__$1 = state_56180;
var statearr_56183_56202 = state_56180__$1;
(statearr_56183_56202[(2)] = null);

(statearr_56183_56202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (4))){
var inst_56154 = (state_56180[(2)]);
var state_56180__$1 = state_56180;
var statearr_56184_56203 = state_56180__$1;
(statearr_56184_56203[(2)] = inst_56154);

(statearr_56184_56203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (6))){
var state_56180__$1 = state_56180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56180__$1,(9),email);
} else {
if((state_val_56181 === (3))){
var inst_56178 = (state_56180[(2)]);
var state_56180__$1 = state_56180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56180__$1,inst_56178);
} else {
if((state_val_56181 === (2))){
var _ = (function (){var statearr_56186 = state_56180;
(statearr_56186[(4)] = cljs.core.cons.call(null,(5),(state_56180[(4)])));

return statearr_56186;
})();
var inst_56160 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_56180__$1 = state_56180;
if(inst_56160){
var statearr_56187_56204 = state_56180__$1;
(statearr_56187_56204[(1)] = (6));

} else {
var statearr_56188_56205 = state_56180__$1;
(statearr_56188_56205[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (9))){
var inst_56163 = (state_56180[(2)]);
var inst_56164 = fluree.db.util.async.throw_err.call(null,inst_56163);
var state_56180__$1 = state_56180;
var statearr_56189_56206 = state_56180__$1;
(statearr_56189_56206[(2)] = inst_56164);

(statearr_56189_56206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (5))){
var _ = (function (){var statearr_56190 = state_56180;
(statearr_56190[(4)] = cljs.core.rest.call(null,(state_56180[(4)])));

return statearr_56190;
})();
var state_56180__$1 = state_56180;
var ex56185 = (state_56180__$1[(2)]);
var statearr_56191_56207 = state_56180__$1;
(statearr_56191_56207[(5)] = ex56185);


if((ex56185 instanceof Error)){
var statearr_56192_56208 = state_56180__$1;
(statearr_56192_56208[(1)] = (4));

(statearr_56192_56208[(5)] = null);

} else {
throw ex56185;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56181 === (8))){
var inst_56167 = (state_56180[(2)]);
var inst_56168 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_56167);
var inst_56169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56170 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56171 = ["re-find",inst_56167,inst_56168];
var inst_56172 = cljs.core.PersistentHashMap.fromArrays(inst_56170,inst_56171);
var inst_56173 = [inst_56172,(10)];
var inst_56174 = (new cljs.core.PersistentVector(null,2,(5),inst_56169,inst_56173,null));
var inst_56175 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56174);
var _ = (function (){var statearr_56193 = state_56180;
(statearr_56193[(4)] = cljs.core.rest.call(null,(state_56180[(4)])));

return statearr_56193;
})();
var state_56180__$1 = (function (){var statearr_56194 = state_56180;
(statearr_56194[(7)] = inst_56175);

return statearr_56194;
})();
var statearr_56195_56209 = state_56180__$1;
(statearr_56195_56209[(2)] = inst_56168);

(statearr_56195_56209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_56196 = [null,null,null,null,null,null,null,null];
(statearr_56196[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__);

(statearr_56196[(1)] = (1));

return statearr_56196;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1 = (function (state_56180){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56197){var ex__2744__auto__ = e56197;
var statearr_56198_56210 = state_56180;
(statearr_56198_56210[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56180[(4)]))){
var statearr_56199_56211 = state_56180;
(statearr_56199_56211[(1)] = cljs.core.first.call(null,(state_56180[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56212 = state_56180;
state_56180 = G__56212;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__ = function(state_56180){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1.call(this,state_56180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56200 = f__2764__auto__.call(null);
(statearr_56200[(6)] = c__2763__auto__);

return statearr_56200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56259){
var state_val_56260 = (state_56259[(1)]);
if((state_val_56260 === (7))){
var inst_56229 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56259__$1 = state_56259;
if(cljs.core.truth_(inst_56229)){
var statearr_56261_56288 = state_56259__$1;
(statearr_56261_56288[(1)] = (9));

} else {
var statearr_56262_56289 = state_56259__$1;
(statearr_56262_56289[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (1))){
var state_56259__$1 = state_56259;
var statearr_56263_56290 = state_56259__$1;
(statearr_56263_56290[(2)] = null);

(statearr_56263_56290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (4))){
var inst_56213 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
var statearr_56264_56291 = state_56259__$1;
(statearr_56264_56291[(2)] = inst_56213);

(statearr_56264_56291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (15))){
var inst_56240 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
var statearr_56265_56292 = state_56259__$1;
(statearr_56265_56292[(2)] = inst_56240);

(statearr_56265_56292[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (13))){
var inst_56237 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56259__$1 = state_56259;
var statearr_56266_56293 = state_56259__$1;
(statearr_56266_56293[(2)] = inst_56237);

(statearr_56266_56293[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (6))){
var inst_56224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56225 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56226 = [inst_56225,(0)];
var inst_56227 = (new cljs.core.PersistentVector(null,2,(5),inst_56224,inst_56226,null));
var state_56259__$1 = state_56259;
var statearr_56267_56294 = state_56259__$1;
(statearr_56267_56294[(2)] = inst_56227);

(statearr_56267_56294[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (3))){
var inst_56257 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56259__$1,inst_56257);
} else {
if((state_val_56260 === (12))){
var inst_56233 = (state_56259[(2)]);
var inst_56234 = fluree.db.util.async.throw_err.call(null,inst_56233);
var state_56259__$1 = state_56259;
var statearr_56268_56295 = state_56259__$1;
(statearr_56268_56295[(2)] = inst_56234);

(statearr_56268_56295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (2))){
var _ = (function (){var statearr_56269 = state_56259;
(statearr_56269[(4)] = cljs.core.cons.call(null,(5),(state_56259[(4)])));

return statearr_56269;
})();
var inst_56222 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56259__$1 = state_56259;
if(cljs.core.truth_(inst_56222)){
var statearr_56270_56296 = state_56259__$1;
(statearr_56270_56296[(1)] = (6));

} else {
var statearr_56271_56297 = state_56259__$1;
(statearr_56271_56297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (11))){
var inst_56242 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
var statearr_56273_56298 = state_56259__$1;
(statearr_56273_56298[(2)] = inst_56242);

(statearr_56273_56298[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (9))){
var inst_56231 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56259__$1,(12),inst_56231);
} else {
if((state_val_56260 === (5))){
var _ = (function (){var statearr_56274 = state_56259;
(statearr_56274[(4)] = cljs.core.rest.call(null,(state_56259[(4)])));

return statearr_56274;
})();
var state_56259__$1 = state_56259;
var ex56272 = (state_56259__$1[(2)]);
var statearr_56275_56299 = state_56259__$1;
(statearr_56275_56299[(5)] = ex56272);


if((ex56272 instanceof Error)){
var statearr_56276_56300 = state_56259__$1;
(statearr_56276_56300[(1)] = (4));

(statearr_56276_56300[(5)] = null);

} else {
throw ex56272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (14))){
var state_56259__$1 = state_56259;
var statearr_56277_56301 = state_56259__$1;
(statearr_56277_56301[(2)] = null);

(statearr_56277_56301[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (10))){
var state_56259__$1 = state_56259;
var statearr_56278_56302 = state_56259__$1;
(statearr_56278_56302[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (8))){
var inst_56244 = (state_56259[(2)]);
var inst_56245 = cljs.core.nth.call(null,inst_56244,(0),null);
var inst_56246 = cljs.core.nth.call(null,inst_56244,(1),null);
var inst_56247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56248 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56249 = ["?user_id","?ctx",inst_56245];
var inst_56250 = cljs.core.PersistentHashMap.fromArrays(inst_56248,inst_56249);
var inst_56251 = ((10) + inst_56246);
var inst_56252 = [inst_56250,inst_56251];
var inst_56253 = (new cljs.core.PersistentVector(null,2,(5),inst_56247,inst_56252,null));
var inst_56254 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56253);
var _ = (function (){var statearr_56280 = state_56259;
(statearr_56280[(4)] = cljs.core.rest.call(null,(state_56259[(4)])));

return statearr_56280;
})();
var state_56259__$1 = (function (){var statearr_56281 = state_56259;
(statearr_56281[(7)] = inst_56254);

return statearr_56281;
})();
var statearr_56282_56303 = state_56259__$1;
(statearr_56282_56303[(2)] = inst_56245);

(statearr_56282_56303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0 = (function (){
var statearr_56283 = [null,null,null,null,null,null,null,null];
(statearr_56283[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__);

(statearr_56283[(1)] = (1));

return statearr_56283;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1 = (function (state_56259){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56284){var ex__2744__auto__ = e56284;
var statearr_56285_56304 = state_56259;
(statearr_56285_56304[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56259[(4)]))){
var statearr_56286_56305 = state_56259;
(statearr_56286_56305[(1)] = cljs.core.first.call(null,(state_56259[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56306 = state_56259;
state_56259 = G__56306;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__ = function(state_56259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1.call(this,state_56259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56287 = f__2764__auto__.call(null);
(statearr_56287[(6)] = c__2763__auto__);

return statearr_56287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56334){
var state_val_56335 = (state_56334[(1)]);
if((state_val_56335 === (7))){
var inst_56327 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56334__$1 = state_56334;
var statearr_56336_56355 = state_56334__$1;
(statearr_56336_56355[(2)] = inst_56327);

(statearr_56336_56355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (1))){
var state_56334__$1 = state_56334;
var statearr_56337_56356 = state_56334__$1;
(statearr_56337_56356[(2)] = null);

(statearr_56337_56356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (4))){
var inst_56307 = (state_56334[(2)]);
var state_56334__$1 = state_56334;
var statearr_56338_56357 = state_56334__$1;
(statearr_56338_56357[(2)] = inst_56307);

(statearr_56338_56357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (6))){
var inst_56315 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56334__$1,(9),inst_56315);
} else {
if((state_val_56335 === (3))){
var inst_56332 = (state_56334[(2)]);
var state_56334__$1 = state_56334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56334__$1,inst_56332);
} else {
if((state_val_56335 === (2))){
var _ = (function (){var statearr_56340 = state_56334;
(statearr_56340[(4)] = cljs.core.cons.call(null,(5),(state_56334[(4)])));

return statearr_56340;
})();
var inst_56313 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56334__$1 = state_56334;
if(cljs.core.truth_(inst_56313)){
var statearr_56341_56358 = state_56334__$1;
(statearr_56341_56358[(1)] = (6));

} else {
var statearr_56342_56359 = state_56334__$1;
(statearr_56342_56359[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (9))){
var inst_56317 = (state_56334[(2)]);
var inst_56318 = fluree.db.util.async.throw_err.call(null,inst_56317);
var inst_56319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56320 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56321 = ["?auth_id","?ctx",inst_56318];
var inst_56322 = cljs.core.PersistentHashMap.fromArrays(inst_56320,inst_56321);
var inst_56323 = [inst_56322,(10)];
var inst_56324 = (new cljs.core.PersistentVector(null,2,(5),inst_56319,inst_56323,null));
var inst_56325 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56324);
var state_56334__$1 = (function (){var statearr_56343 = state_56334;
(statearr_56343[(7)] = inst_56325);

return statearr_56343;
})();
var statearr_56344_56360 = state_56334__$1;
(statearr_56344_56360[(2)] = inst_56318);

(statearr_56344_56360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (5))){
var _ = (function (){var statearr_56345 = state_56334;
(statearr_56345[(4)] = cljs.core.rest.call(null,(state_56334[(4)])));

return statearr_56345;
})();
var state_56334__$1 = state_56334;
var ex56339 = (state_56334__$1[(2)]);
var statearr_56346_56361 = state_56334__$1;
(statearr_56346_56361[(5)] = ex56339);


if((ex56339 instanceof Error)){
var statearr_56347_56362 = state_56334__$1;
(statearr_56347_56362[(1)] = (4));

(statearr_56347_56362[(5)] = null);

} else {
throw ex56339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56335 === (8))){
var inst_56329 = (state_56334[(2)]);
var _ = (function (){var statearr_56348 = state_56334;
(statearr_56348[(4)] = cljs.core.rest.call(null,(state_56334[(4)])));

return statearr_56348;
})();
var state_56334__$1 = state_56334;
var statearr_56349_56363 = state_56334__$1;
(statearr_56349_56363[(2)] = inst_56329);

(statearr_56349_56363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0 = (function (){
var statearr_56350 = [null,null,null,null,null,null,null,null];
(statearr_56350[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__);

(statearr_56350[(1)] = (1));

return statearr_56350;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1 = (function (state_56334){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56351){var ex__2744__auto__ = e56351;
var statearr_56352_56364 = state_56334;
(statearr_56352_56364[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56334[(4)]))){
var statearr_56353_56365 = state_56334;
(statearr_56353_56365[(1)] = cljs.core.first.call(null,(state_56334[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56366 = state_56334;
state_56334 = G__56366;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__ = function(state_56334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1.call(this,state_56334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56354 = f__2764__auto__.call(null);
(statearr_56354[(6)] = c__2763__auto__);

return statearr_56354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56368 = arguments.length;
switch (G__56368) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56410){
var state_val_56411 = (state_56410[(1)]);
if((state_val_56411 === (7))){
var state_56410__$1 = state_56410;
var statearr_56412_56442 = state_56410__$1;
(statearr_56412_56442[(2)] = seed);

(statearr_56412_56442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (1))){
var state_56410__$1 = state_56410;
var statearr_56413_56443 = state_56410__$1;
(statearr_56413_56443[(2)] = null);

(statearr_56413_56443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (4))){
var inst_56369 = (state_56410[(2)]);
var state_56410__$1 = state_56410;
var statearr_56414_56444 = state_56410__$1;
(statearr_56414_56444[(2)] = inst_56369);

(statearr_56414_56444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (15))){
var state_56410__$1 = state_56410;
var statearr_56415_56445 = state_56410__$1;
(statearr_56415_56445[(2)] = (10));

(statearr_56415_56445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (13))){
var inst_56386 = (state_56410[(2)]);
var inst_56387 = fluree.db.util.async.throw_err.call(null,inst_56386);
var state_56410__$1 = state_56410;
var statearr_56416_56446 = state_56410__$1;
(statearr_56416_56446[(2)] = inst_56387);

(statearr_56416_56446[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (6))){
var state_56410__$1 = state_56410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56410__$1,(9),seed);
} else {
if((state_val_56411 === (3))){
var inst_56408 = (state_56410[(2)]);
var state_56410__$1 = state_56410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56410__$1,inst_56408);
} else {
if((state_val_56411 === (12))){
var inst_56390 = (state_56410[(7)]);
var inst_56390__$1 = (state_56410[(2)]);
var state_56410__$1 = (function (){var statearr_56417 = state_56410;
(statearr_56417[(7)] = inst_56390__$1);

return statearr_56417;
})();
if(cljs.core.truth_(inst_56390__$1)){
var statearr_56418_56447 = state_56410__$1;
(statearr_56418_56447[(1)] = (14));

} else {
var statearr_56419_56448 = state_56410__$1;
(statearr_56419_56448[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (2))){
var _ = (function (){var statearr_56420 = state_56410;
(statearr_56420[(4)] = cljs.core.cons.call(null,(5),(state_56410[(4)])));

return statearr_56420;
})();
var inst_56375 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_56410__$1 = state_56410;
if(inst_56375){
var statearr_56421_56449 = state_56410__$1;
(statearr_56421_56449[(1)] = (6));

} else {
var statearr_56422_56450 = state_56410__$1;
(statearr_56422_56450[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (11))){
var state_56410__$1 = state_56410;
var statearr_56424_56451 = state_56410__$1;
(statearr_56424_56451[(2)] = max);

(statearr_56424_56451[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (9))){
var inst_56378 = (state_56410[(2)]);
var inst_56379 = fluree.db.util.async.throw_err.call(null,inst_56378);
var state_56410__$1 = state_56410;
var statearr_56425_56452 = state_56410__$1;
(statearr_56425_56452[(2)] = inst_56379);

(statearr_56425_56452[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (5))){
var _ = (function (){var statearr_56426 = state_56410;
(statearr_56426[(4)] = cljs.core.rest.call(null,(state_56410[(4)])));

return statearr_56426;
})();
var state_56410__$1 = state_56410;
var ex56423 = (state_56410__$1[(2)]);
var statearr_56427_56453 = state_56410__$1;
(statearr_56427_56453[(5)] = ex56423);


if((ex56423 instanceof Error)){
var statearr_56428_56454 = state_56410__$1;
(statearr_56428_56454[(1)] = (4));

(statearr_56428_56454[(5)] = null);

} else {
throw ex56423;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (14))){
var inst_56390 = (state_56410[(7)]);
var state_56410__$1 = state_56410;
var statearr_56429_56455 = state_56410__$1;
(statearr_56429_56455[(2)] = inst_56390);

(statearr_56429_56455[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (16))){
var inst_56382 = (state_56410[(8)]);
var inst_56394 = (state_56410[(2)]);
var inst_56395 = fluree.db.dbfunctions.internal.rand.call(null,inst_56382,inst_56394);
var inst_56396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56397 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56399 = [max,seed];
var inst_56400 = (new cljs.core.PersistentVector(null,2,(5),inst_56398,inst_56399,null));
var inst_56401 = ["rand",inst_56400,inst_56395];
var inst_56402 = cljs.core.PersistentHashMap.fromArrays(inst_56397,inst_56401);
var inst_56403 = [inst_56402,(10)];
var inst_56404 = (new cljs.core.PersistentVector(null,2,(5),inst_56396,inst_56403,null));
var inst_56405 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56404);
var _ = (function (){var statearr_56430 = state_56410;
(statearr_56430[(4)] = cljs.core.rest.call(null,(state_56410[(4)])));

return statearr_56430;
})();
var state_56410__$1 = (function (){var statearr_56431 = state_56410;
(statearr_56431[(9)] = inst_56405);

return statearr_56431;
})();
var statearr_56432_56456 = state_56410__$1;
(statearr_56432_56456[(2)] = inst_56395);

(statearr_56432_56456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56411 === (10))){
var state_56410__$1 = state_56410;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56410__$1,(13),max);
} else {
if((state_val_56411 === (8))){
var inst_56382 = (state_56410[(2)]);
var inst_56383 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_56410__$1 = (function (){var statearr_56433 = state_56410;
(statearr_56433[(8)] = inst_56382);

return statearr_56433;
})();
if(inst_56383){
var statearr_56434_56457 = state_56410__$1;
(statearr_56434_56457[(1)] = (10));

} else {
var statearr_56435_56458 = state_56410__$1;
(statearr_56435_56458[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_56436 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56436[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_56436[(1)] = (1));

return statearr_56436;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_56410){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56437){var ex__2744__auto__ = e56437;
var statearr_56438_56459 = state_56410;
(statearr_56438_56459[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56410[(4)]))){
var statearr_56439_56460 = state_56410;
(statearr_56439_56460[(1)] = cljs.core.first.call(null,(state_56410[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56461 = state_56410;
state_56410 = G__56461;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_56410){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_56410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56440 = f__2764__auto__.call(null);
(statearr_56440[(6)] = c__2763__auto__);

return statearr_56440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56482){
var state_val_56483 = (state_56482[(1)]);
if((state_val_56483 === (1))){
var state_56482__$1 = state_56482;
var statearr_56484_56499 = state_56482__$1;
(statearr_56484_56499[(2)] = null);

(statearr_56484_56499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56483 === (2))){
var _ = (function (){var statearr_56485 = state_56482;
(statearr_56485[(4)] = cljs.core.cons.call(null,(5),(state_56482[(4)])));

return statearr_56485;
})();
var inst_56468 = fluree.db.util.core.random_uuid.call(null);
var inst_56469 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56468);
var inst_56470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56472 = cljs.core.PersistentVector.EMPTY;
var inst_56473 = ["uuid",inst_56472,inst_56469];
var inst_56474 = cljs.core.PersistentHashMap.fromArrays(inst_56471,inst_56473);
var inst_56475 = [inst_56474,(10)];
var inst_56476 = (new cljs.core.PersistentVector(null,2,(5),inst_56470,inst_56475,null));
var inst_56477 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56476);
var ___$1 = (function (){var statearr_56486 = state_56482;
(statearr_56486[(4)] = cljs.core.rest.call(null,(state_56482[(4)])));

return statearr_56486;
})();
var state_56482__$1 = (function (){var statearr_56487 = state_56482;
(statearr_56487[(7)] = inst_56477);

return statearr_56487;
})();
var statearr_56488_56500 = state_56482__$1;
(statearr_56488_56500[(2)] = inst_56469);

(statearr_56488_56500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56483 === (3))){
var inst_56480 = (state_56482[(2)]);
var state_56482__$1 = state_56482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56482__$1,inst_56480);
} else {
if((state_val_56483 === (4))){
var inst_56462 = (state_56482[(2)]);
var state_56482__$1 = state_56482;
var statearr_56490_56501 = state_56482__$1;
(statearr_56490_56501[(2)] = inst_56462);

(statearr_56490_56501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56483 === (5))){
var _ = (function (){var statearr_56491 = state_56482;
(statearr_56491[(4)] = cljs.core.rest.call(null,(state_56482[(4)])));

return statearr_56491;
})();
var state_56482__$1 = state_56482;
var ex56489 = (state_56482__$1[(2)]);
var statearr_56492_56502 = state_56482__$1;
(statearr_56492_56502[(5)] = ex56489);


if((ex56489 instanceof Error)){
var statearr_56493_56503 = state_56482__$1;
(statearr_56493_56503[(1)] = (4));

(statearr_56493_56503[(5)] = null);

} else {
throw ex56489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0 = (function (){
var statearr_56494 = [null,null,null,null,null,null,null,null];
(statearr_56494[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__);

(statearr_56494[(1)] = (1));

return statearr_56494;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1 = (function (state_56482){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56495){var ex__2744__auto__ = e56495;
var statearr_56496_56504 = state_56482;
(statearr_56496_56504[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56482[(4)]))){
var statearr_56497_56505 = state_56482;
(statearr_56497_56505[(1)] = cljs.core.first.call(null,(state_56482[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56506 = state_56482;
state_56482 = G__56506;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__ = function(state_56482){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1.call(this,state_56482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56498 = f__2764__auto__.call(null);
(statearr_56498[(6)] = c__2763__auto__);

return statearr_56498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56536){
var state_val_56537 = (state_56536[(1)]);
if((state_val_56537 === (7))){
var state_56536__$1 = state_56536;
var statearr_56538_56557 = state_56536__$1;
(statearr_56538_56557[(2)] = num);

(statearr_56538_56557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (1))){
var state_56536__$1 = state_56536;
var statearr_56539_56558 = state_56536__$1;
(statearr_56539_56558[(2)] = null);

(statearr_56539_56558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (4))){
var inst_56507 = (state_56536[(2)]);
var state_56536__$1 = state_56536;
var statearr_56540_56559 = state_56536__$1;
(statearr_56540_56559[(2)] = inst_56507);

(statearr_56540_56559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (6))){
var state_56536__$1 = state_56536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56536__$1,(9),num);
} else {
if((state_val_56537 === (3))){
var inst_56534 = (state_56536[(2)]);
var state_56536__$1 = state_56536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56536__$1,inst_56534);
} else {
if((state_val_56537 === (2))){
var _ = (function (){var statearr_56542 = state_56536;
(statearr_56542[(4)] = cljs.core.cons.call(null,(5),(state_56536[(4)])));

return statearr_56542;
})();
var inst_56513 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56536__$1 = state_56536;
if(inst_56513){
var statearr_56543_56560 = state_56536__$1;
(statearr_56543_56560[(1)] = (6));

} else {
var statearr_56544_56561 = state_56536__$1;
(statearr_56544_56561[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (9))){
var inst_56516 = (state_56536[(2)]);
var inst_56517 = fluree.db.util.async.throw_err.call(null,inst_56516);
var state_56536__$1 = state_56536;
var statearr_56545_56562 = state_56536__$1;
(statearr_56545_56562[(2)] = inst_56517);

(statearr_56545_56562[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (5))){
var _ = (function (){var statearr_56546 = state_56536;
(statearr_56546[(4)] = cljs.core.rest.call(null,(state_56536[(4)])));

return statearr_56546;
})();
var state_56536__$1 = state_56536;
var ex56541 = (state_56536__$1[(2)]);
var statearr_56547_56563 = state_56536__$1;
(statearr_56547_56563[(5)] = ex56541);


if((ex56541 instanceof Error)){
var statearr_56548_56564 = state_56536__$1;
(statearr_56548_56564[(1)] = (4));

(statearr_56548_56564[(5)] = null);

} else {
throw ex56541;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56537 === (8))){
var inst_56520 = (state_56536[(2)]);
var inst_56521 = fluree.db.dbfunctions.internal.ceil.call(null,inst_56520);
var inst_56522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56523 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56525 = [fluree.db.dbfunctions.fns.ceil];
var inst_56526 = (new cljs.core.PersistentVector(null,1,(5),inst_56524,inst_56525,null));
var inst_56527 = ["",inst_56526,inst_56521];
var inst_56528 = cljs.core.PersistentHashMap.fromArrays(inst_56523,inst_56527);
var inst_56529 = [inst_56528,(10)];
var inst_56530 = (new cljs.core.PersistentVector(null,2,(5),inst_56522,inst_56529,null));
var inst_56531 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56530);
var _ = (function (){var statearr_56549 = state_56536;
(statearr_56549[(4)] = cljs.core.rest.call(null,(state_56536[(4)])));

return statearr_56549;
})();
var state_56536__$1 = (function (){var statearr_56550 = state_56536;
(statearr_56550[(7)] = inst_56531);

return statearr_56550;
})();
var statearr_56551_56565 = state_56536__$1;
(statearr_56551_56565[(2)] = inst_56521);

(statearr_56551_56565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0 = (function (){
var statearr_56552 = [null,null,null,null,null,null,null,null];
(statearr_56552[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__);

(statearr_56552[(1)] = (1));

return statearr_56552;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1 = (function (state_56536){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56553){var ex__2744__auto__ = e56553;
var statearr_56554_56566 = state_56536;
(statearr_56554_56566[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56536[(4)]))){
var statearr_56555_56567 = state_56536;
(statearr_56555_56567[(1)] = cljs.core.first.call(null,(state_56536[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56568 = state_56536;
state_56536 = G__56568;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__ = function(state_56536){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1.call(this,state_56536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56556 = f__2764__auto__.call(null);
(statearr_56556[(6)] = c__2763__auto__);

return statearr_56556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56598){
var state_val_56599 = (state_56598[(1)]);
if((state_val_56599 === (7))){
var state_56598__$1 = state_56598;
var statearr_56600_56619 = state_56598__$1;
(statearr_56600_56619[(2)] = num);

(statearr_56600_56619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (1))){
var state_56598__$1 = state_56598;
var statearr_56601_56620 = state_56598__$1;
(statearr_56601_56620[(2)] = null);

(statearr_56601_56620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (4))){
var inst_56569 = (state_56598[(2)]);
var state_56598__$1 = state_56598;
var statearr_56602_56621 = state_56598__$1;
(statearr_56602_56621[(2)] = inst_56569);

(statearr_56602_56621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (6))){
var state_56598__$1 = state_56598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56598__$1,(9),num);
} else {
if((state_val_56599 === (3))){
var inst_56596 = (state_56598[(2)]);
var state_56598__$1 = state_56598;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56598__$1,inst_56596);
} else {
if((state_val_56599 === (2))){
var _ = (function (){var statearr_56604 = state_56598;
(statearr_56604[(4)] = cljs.core.cons.call(null,(5),(state_56598[(4)])));

return statearr_56604;
})();
var inst_56575 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_56598__$1 = state_56598;
if(inst_56575){
var statearr_56605_56622 = state_56598__$1;
(statearr_56605_56622[(1)] = (6));

} else {
var statearr_56606_56623 = state_56598__$1;
(statearr_56606_56623[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (9))){
var inst_56578 = (state_56598[(2)]);
var inst_56579 = fluree.db.util.async.throw_err.call(null,inst_56578);
var state_56598__$1 = state_56598;
var statearr_56607_56624 = state_56598__$1;
(statearr_56607_56624[(2)] = inst_56579);

(statearr_56607_56624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (5))){
var _ = (function (){var statearr_56608 = state_56598;
(statearr_56608[(4)] = cljs.core.rest.call(null,(state_56598[(4)])));

return statearr_56608;
})();
var state_56598__$1 = state_56598;
var ex56603 = (state_56598__$1[(2)]);
var statearr_56609_56625 = state_56598__$1;
(statearr_56609_56625[(5)] = ex56603);


if((ex56603 instanceof Error)){
var statearr_56610_56626 = state_56598__$1;
(statearr_56610_56626[(1)] = (4));

(statearr_56610_56626[(5)] = null);

} else {
throw ex56603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56599 === (8))){
var inst_56582 = (state_56598[(2)]);
var inst_56583 = fluree.db.dbfunctions.internal.floor.call(null,inst_56582);
var inst_56584 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56585 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56587 = [fluree.db.dbfunctions.fns.floor];
var inst_56588 = (new cljs.core.PersistentVector(null,1,(5),inst_56586,inst_56587,null));
var inst_56589 = ["",inst_56588,inst_56583];
var inst_56590 = cljs.core.PersistentHashMap.fromArrays(inst_56585,inst_56589);
var inst_56591 = [inst_56590,(10)];
var inst_56592 = (new cljs.core.PersistentVector(null,2,(5),inst_56584,inst_56591,null));
var inst_56593 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56592);
var _ = (function (){var statearr_56611 = state_56598;
(statearr_56611[(4)] = cljs.core.rest.call(null,(state_56598[(4)])));

return statearr_56611;
})();
var state_56598__$1 = (function (){var statearr_56612 = state_56598;
(statearr_56612[(7)] = inst_56593);

return statearr_56612;
})();
var statearr_56613_56627 = state_56598__$1;
(statearr_56613_56627[(2)] = inst_56583);

(statearr_56613_56627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0 = (function (){
var statearr_56614 = [null,null,null,null,null,null,null,null];
(statearr_56614[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__);

(statearr_56614[(1)] = (1));

return statearr_56614;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1 = (function (state_56598){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56615){var ex__2744__auto__ = e56615;
var statearr_56616_56628 = state_56598;
(statearr_56616_56628[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56598[(4)]))){
var statearr_56617_56629 = state_56598;
(statearr_56617_56629[(1)] = cljs.core.first.call(null,(state_56598[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56630 = state_56598;
state_56598 = G__56630;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__ = function(state_56598){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1.call(this,state_56598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56618 = f__2764__auto__.call(null);
(statearr_56618[(6)] = c__2763__auto__);

return statearr_56618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56655){
var state_val_56656 = (state_56655[(1)]);
if((state_val_56656 === (1))){
var state_56655__$1 = state_56655;
var statearr_56657_56672 = state_56655__$1;
(statearr_56657_56672[(2)] = null);

(statearr_56657_56672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56656 === (2))){
var _ = (function (){var statearr_56658 = state_56655;
(statearr_56658[(4)] = cljs.core.cons.call(null,(5),(state_56655[(4)])));

return statearr_56658;
})();
var inst_56637 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_56655__$1 = state_56655;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56655__$1,(6),inst_56637);
} else {
if((state_val_56656 === (3))){
var inst_56653 = (state_56655[(2)]);
var state_56655__$1 = state_56655;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56655__$1,inst_56653);
} else {
if((state_val_56656 === (4))){
var inst_56631 = (state_56655[(2)]);
var state_56655__$1 = state_56655;
var statearr_56660_56673 = state_56655__$1;
(statearr_56660_56673[(2)] = inst_56631);

(statearr_56660_56673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56656 === (5))){
var _ = (function (){var statearr_56661 = state_56655;
(statearr_56661[(4)] = cljs.core.rest.call(null,(state_56655[(4)])));

return statearr_56661;
})();
var state_56655__$1 = state_56655;
var ex56659 = (state_56655__$1[(2)]);
var statearr_56662_56674 = state_56655__$1;
(statearr_56662_56674[(5)] = ex56659);


if((ex56659 instanceof Error)){
var statearr_56663_56675 = state_56655__$1;
(statearr_56663_56675[(1)] = (4));

(statearr_56663_56675[(5)] = null);

} else {
throw ex56659;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56656 === (6))){
var inst_56639 = (state_56655[(2)]);
var inst_56640 = fluree.db.util.async.throw_err.call(null,inst_56639);
var inst_56641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56642 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56643 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56644 = [compare_val,new_val];
var inst_56645 = (new cljs.core.PersistentVector(null,2,(5),inst_56643,inst_56644,null));
var inst_56646 = ["",inst_56645,inst_56640];
var inst_56647 = cljs.core.PersistentHashMap.fromArrays(inst_56642,inst_56646);
var inst_56648 = [inst_56647,(10)];
var inst_56649 = (new cljs.core.PersistentVector(null,2,(5),inst_56641,inst_56648,null));
var inst_56650 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56649);
var _ = (function (){var statearr_56664 = state_56655;
(statearr_56664[(4)] = cljs.core.rest.call(null,(state_56655[(4)])));

return statearr_56664;
})();
var state_56655__$1 = (function (){var statearr_56665 = state_56655;
(statearr_56665[(7)] = inst_56650);

return statearr_56665;
})();
var statearr_56666_56676 = state_56655__$1;
(statearr_56666_56676[(2)] = inst_56640);

(statearr_56666_56676[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0 = (function (){
var statearr_56667 = [null,null,null,null,null,null,null,null];
(statearr_56667[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__);

(statearr_56667[(1)] = (1));

return statearr_56667;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1 = (function (state_56655){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_56655);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56668){var ex__2744__auto__ = e56668;
var statearr_56669_56677 = state_56655;
(statearr_56669_56677[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_56655[(4)]))){
var statearr_56670_56678 = state_56655;
(statearr_56670_56678[(1)] = cljs.core.first.call(null,(state_56655[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56679 = state_56655;
state_56655 = G__56679;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__ = function(state_56655){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1.call(this,state_56655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56671 = f__2764__auto__.call(null);
(statearr_56671[(6)] = c__2763__auto__);

return statearr_56671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
