// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__61362_61531 = cljs.core.seq.call(null,servers);
var chunk__61363_61532 = null;
var count__61364_61533 = (0);
var i__61365_61534 = (0);
while(true){
if((i__61365_61534 < count__61364_61533)){
var server_61535 = cljs.core._nth.call(null,chunk__61363_61532,i__61365_61534);
var healthcheck_uri_61536 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61535),"/fdb/health"].join('');
var resp_chan_61537 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_61536,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61538 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535){
return (function (state_61426){
var state_val_61427 = (state_61426[(1)]);
if((state_val_61427 === (1))){
var state_61426__$1 = state_61426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61426__$1,(2),resp_chan_61537);
} else {
if((state_val_61427 === (2))){
var inst_61415 = (state_61426[(7)]);
var inst_61415__$1 = (state_61426[(2)]);
var inst_61416 = fluree.db.util.core.exception_QMARK_.call(null,inst_61415__$1);
var state_61426__$1 = (function (){var statearr_61428 = state_61426;
(statearr_61428[(7)] = inst_61415__$1);

return statearr_61428;
})();
if(inst_61416){
var statearr_61429_61539 = state_61426__$1;
(statearr_61429_61539[(1)] = (3));

} else {
var statearr_61430_61540 = state_61426__$1;
(statearr_61430_61540[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61427 === (3))){
var inst_61415 = (state_61426[(7)]);
var inst_61418 = cljs.core.ex_message.call(null,inst_61415);
var inst_61419 = cljs.core.ex_data.call(null,inst_61415);
var inst_61420 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_61418,inst_61419);
var state_61426__$1 = state_61426;
var statearr_61431_61541 = state_61426__$1;
(statearr_61431_61541[(2)] = inst_61420);

(statearr_61431_61541[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61427 === (4))){
var inst_61422 = cljs.core.async.put_BANG_.call(null,promise_chan,server_61535);
var state_61426__$1 = state_61426;
var statearr_61432_61542 = state_61426__$1;
(statearr_61432_61542[(2)] = inst_61422);

(statearr_61432_61542[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61427 === (5))){
var inst_61424 = (state_61426[(2)]);
var state_61426__$1 = state_61426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61426__$1,inst_61424);
} else {
return null;
}
}
}
}
}
});})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535))
;
return ((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,switch__2740__auto__,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61433 = [null,null,null,null,null,null,null,null];
(statearr_61433[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61433[(1)] = (1));

return statearr_61433;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61426){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61434){var ex__2744__auto__ = e61434;
var statearr_61435_61543 = state_61426;
(statearr_61435_61543[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61426[(4)]))){
var statearr_61436_61544 = state_61426;
(statearr_61436_61544[(1)] = cljs.core.first.call(null,(state_61426[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61545 = state_61426;
state_61426 = G__61545;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61426){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,switch__2740__auto__,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535))
})();
var state__2765__auto__ = (function (){var statearr_61437 = f__2764__auto__.call(null);
(statearr_61437[(6)] = c__2763__auto___61538);

return statearr_61437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61538,healthcheck_uri_61536,resp_chan_61537,server_61535))
);



var G__61546 = seq__61362_61531;
var G__61547 = chunk__61363_61532;
var G__61548 = count__61364_61533;
var G__61549 = (i__61365_61534 + (1));
seq__61362_61531 = G__61546;
chunk__61363_61532 = G__61547;
count__61364_61533 = G__61548;
i__61365_61534 = G__61549;
continue;
} else {
var temp__5753__auto___61550 = cljs.core.seq.call(null,seq__61362_61531);
if(temp__5753__auto___61550){
var seq__61362_61551__$1 = temp__5753__auto___61550;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__61362_61551__$1)){
var c__4679__auto___61552 = cljs.core.chunk_first.call(null,seq__61362_61551__$1);
var G__61553 = cljs.core.chunk_rest.call(null,seq__61362_61551__$1);
var G__61554 = c__4679__auto___61552;
var G__61555 = cljs.core.count.call(null,c__4679__auto___61552);
var G__61556 = (0);
seq__61362_61531 = G__61553;
chunk__61363_61532 = G__61554;
count__61364_61533 = G__61555;
i__61365_61534 = G__61556;
continue;
} else {
var server_61557 = cljs.core.first.call(null,seq__61362_61551__$1);
var healthcheck_uri_61558 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_61557),"/fdb/health"].join('');
var resp_chan_61559 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_61558,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2763__auto___61560 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550){
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = ((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550){
return (function (state_61450){
var state_val_61451 = (state_61450[(1)]);
if((state_val_61451 === (1))){
var state_61450__$1 = state_61450;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61450__$1,(2),resp_chan_61559);
} else {
if((state_val_61451 === (2))){
var inst_61439 = (state_61450[(7)]);
var inst_61439__$1 = (state_61450[(2)]);
var inst_61440 = fluree.db.util.core.exception_QMARK_.call(null,inst_61439__$1);
var state_61450__$1 = (function (){var statearr_61452 = state_61450;
(statearr_61452[(7)] = inst_61439__$1);

return statearr_61452;
})();
if(inst_61440){
var statearr_61453_61561 = state_61450__$1;
(statearr_61453_61561[(1)] = (3));

} else {
var statearr_61454_61562 = state_61450__$1;
(statearr_61454_61562[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61451 === (3))){
var inst_61439 = (state_61450[(7)]);
var inst_61442 = cljs.core.ex_message.call(null,inst_61439);
var inst_61443 = cljs.core.ex_data.call(null,inst_61439);
var inst_61444 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_61442,inst_61443);
var state_61450__$1 = state_61450;
var statearr_61455_61563 = state_61450__$1;
(statearr_61455_61563[(2)] = inst_61444);

(statearr_61455_61563[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61451 === (4))){
var inst_61446 = cljs.core.async.put_BANG_.call(null,promise_chan,server_61557);
var state_61450__$1 = state_61450;
var statearr_61456_61564 = state_61450__$1;
(statearr_61456_61564[(2)] = inst_61446);

(statearr_61456_61564[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61451 === (5))){
var inst_61448 = (state_61450[(2)]);
var state_61450__$1 = state_61450;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61450__$1,inst_61448);
} else {
return null;
}
}
}
}
}
});})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550))
;
return ((function (seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,switch__2740__auto__,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61457 = [null,null,null,null,null,null,null,null];
(statearr_61457[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61457[(1)] = (1));

return statearr_61457;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61450){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61450);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61458){var ex__2744__auto__ = e61458;
var statearr_61459_61565 = state_61450;
(statearr_61459_61565[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61450[(4)]))){
var statearr_61460_61566 = state_61450;
(statearr_61460_61566[(1)] = cljs.core.first.call(null,(state_61450[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61567 = state_61450;
state_61450 = G__61567;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61450){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
;})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,switch__2740__auto__,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550))
})();
var state__2765__auto__ = (function (){var statearr_61461 = f__2764__auto__.call(null);
(statearr_61461[(6)] = c__2763__auto___61560);

return statearr_61461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});})(seq__61362_61531,chunk__61363_61532,count__61364_61533,i__61365_61534,c__2763__auto___61560,healthcheck_uri_61558,resp_chan_61559,server_61557,seq__61362_61551__$1,temp__5753__auto___61550))
);



var G__61568 = cljs.core.next.call(null,seq__61362_61551__$1);
var G__61569 = null;
var G__61570 = (0);
var G__61571 = (0);
seq__61362_61531 = G__61568;
chunk__61363_61532 = G__61569;
count__61364_61533 = G__61570;
i__61365_61534 = G__61571;
continue;
}
} else {
}
}
break;
}

var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61505){
var state_val_61506 = (state_61505[(1)]);
if((state_val_61506 === (7))){
var inst_61477 = (state_61505[(7)]);
var inst_61484 = cljs.core._EQ_.call(null,inst_61477,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_61505__$1 = state_61505;
if(inst_61484){
var statearr_61507_61572 = state_61505__$1;
(statearr_61507_61572[(1)] = (9));

} else {
var statearr_61508_61573 = state_61505__$1;
(statearr_61508_61573[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (1))){
var inst_61470 = (state_61505[(8)]);
var inst_61469 = (state_61505[(9)]);
var inst_61469__$1 = promise_chan;
var inst_61470__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_61471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61472 = [inst_61469__$1,inst_61470__$1];
var inst_61473 = (new cljs.core.PersistentVector(null,2,(5),inst_61471,inst_61472,null));
var state_61505__$1 = (function (){var statearr_61509 = state_61505;
(statearr_61509[(8)] = inst_61470__$1);

(statearr_61509[(9)] = inst_61469__$1);

return statearr_61509;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_61505__$1,(2),inst_61473);
} else {
if((state_val_61506 === (4))){
var inst_61477 = (state_61505[(7)]);
var inst_61470 = (state_61505[(8)]);
var inst_61481 = cljs.core._EQ_.call(null,inst_61477,inst_61470);
var state_61505__$1 = state_61505;
if(inst_61481){
var statearr_61510_61574 = state_61505__$1;
(statearr_61510_61574[(1)] = (6));

} else {
var statearr_61511_61575 = state_61505__$1;
(statearr_61511_61575[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (13))){
var state_61505__$1 = state_61505;
var statearr_61512_61576 = state_61505__$1;
(statearr_61512_61576[(2)] = null);

(statearr_61512_61576[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (6))){
var state_61505__$1 = state_61505;
var statearr_61513_61577 = state_61505__$1;
(statearr_61513_61577[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_61513_61577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (3))){
var state_61505__$1 = state_61505;
var statearr_61514_61578 = state_61505__$1;
(statearr_61514_61578[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_61514_61578[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (12))){
var inst_61495 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_61496 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61497 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_61498 = cljs.core.PersistentHashMap.fromArrays(inst_61496,inst_61497);
var inst_61499 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_61498);
var inst_61500 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_61499);
var state_61505__$1 = (function (){var statearr_61515 = state_61505;
(statearr_61515[(10)] = inst_61495);

return statearr_61515;
})();
var statearr_61516_61579 = state_61505__$1;
(statearr_61516_61579[(2)] = inst_61500);

(statearr_61516_61579[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (2))){
var inst_61477 = (state_61505[(7)]);
var inst_61469 = (state_61505[(9)]);
var inst_61475 = (state_61505[(2)]);
var inst_61476 = cljs.core.nth.call(null,inst_61475,(0),null);
var inst_61477__$1 = cljs.core.nth.call(null,inst_61475,(1),null);
var inst_61478 = cljs.core._EQ_.call(null,inst_61477__$1,inst_61469);
var state_61505__$1 = (function (){var statearr_61517 = state_61505;
(statearr_61517[(7)] = inst_61477__$1);

(statearr_61517[(11)] = inst_61476);

return statearr_61517;
})();
if(inst_61478){
var statearr_61518_61580 = state_61505__$1;
(statearr_61518_61580[(1)] = (3));

} else {
var statearr_61519_61581 = state_61505__$1;
(statearr_61519_61581[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (11))){
var inst_61488 = (state_61505[(2)]);
var state_61505__$1 = state_61505;
var statearr_61520_61582 = state_61505__$1;
(statearr_61520_61582[(2)] = inst_61488);

(statearr_61520_61582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (9))){
var inst_61476 = (state_61505[(11)]);
var state_61505__$1 = state_61505;
var statearr_61521_61583 = state_61505__$1;
(statearr_61521_61583[(2)] = inst_61476);

(statearr_61521_61583[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (5))){
var inst_61492 = (state_61505[(2)]);
var inst_61493 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_61492);
var state_61505__$1 = state_61505;
if(inst_61493){
var statearr_61522_61584 = state_61505__$1;
(statearr_61522_61584[(1)] = (12));

} else {
var statearr_61523_61585 = state_61505__$1;
(statearr_61523_61585[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (14))){
var inst_61503 = (state_61505[(2)]);
var state_61505__$1 = state_61505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61505__$1,inst_61503);
} else {
if((state_val_61506 === (10))){
var state_61505__$1 = state_61505;
var statearr_61524_61586 = state_61505__$1;
(statearr_61524_61586[(2)] = null);

(statearr_61524_61586[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61506 === (8))){
var inst_61490 = (state_61505[(2)]);
var state_61505__$1 = state_61505;
var statearr_61525_61587 = state_61505__$1;
(statearr_61525_61587[(2)] = inst_61490);

(statearr_61525_61587[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0 = (function (){
var statearr_61526 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61526[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__);

(statearr_61526[(1)] = (1));

return statearr_61526;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1 = (function (state_61505){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61527){var ex__2744__auto__ = e61527;
var statearr_61528_61588 = state_61505;
(statearr_61528_61588[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61505[(4)]))){
var statearr_61529_61589 = state_61505;
(statearr_61529_61589[(1)] = cljs.core.first.call(null,(state_61505[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61590 = state_61505;
state_61505 = G__61590;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__ = function(state_61505){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1.call(this,state_61505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61530 = f__2764__auto__.call(null);
(statearr_61530[(6)] = c__2763__auto__);

return statearr_61530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61634){
var state_val_61635 = (state_61634[(1)]);
if((state_val_61635 === (7))){
var state_61634__$1 = state_61634;
var statearr_61636_61662 = state_61634__$1;
(statearr_61636_61662[(2)] = null);

(statearr_61636_61662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (1))){
var state_61634__$1 = state_61634;
var statearr_61637_61663 = state_61634__$1;
(statearr_61637_61663[(2)] = null);

(statearr_61637_61663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (4))){
var inst_61591 = (state_61634[(2)]);
var state_61634__$1 = state_61634;
var statearr_61638_61664 = state_61634__$1;
(statearr_61638_61664[(2)] = inst_61591);

(statearr_61638_61664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (6))){
var inst_61613 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_61634__$1 = state_61634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61634__$1,(9),inst_61613);
} else {
if((state_val_61635 === (3))){
var inst_61632 = (state_61634[(2)]);
var state_61634__$1 = state_61634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61634__$1,inst_61632);
} else {
if((state_val_61635 === (12))){
var inst_61626 = (state_61634[(2)]);
var state_61634__$1 = state_61634;
var statearr_61639_61665 = state_61634__$1;
(statearr_61639_61665[(2)] = inst_61626);

(statearr_61639_61665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (2))){
var inst_61597 = (state_61634[(7)]);
var inst_61607 = (state_61634[(8)]);
var inst_61602 = (state_61634[(9)]);
var _ = (function (){var statearr_61640 = state_61634;
(statearr_61640[(4)] = cljs.core.cons.call(null,(5),(state_61634[(4)])));

return statearr_61640;
})();
var inst_61597__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_61598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61599 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_61600 = (new cljs.core.PersistentVector(null,2,(5),inst_61598,inst_61599,null));
var inst_61601 = (function (){var lock_id = inst_61597__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_61602__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_61600,inst_61601);
var inst_61603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61604 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_61605 = (new cljs.core.PersistentVector(null,3,(5),inst_61603,inst_61604,null));
var inst_61606 = cljs.core.get_in.call(null,inst_61602__$1,inst_61605);
var inst_61607__$1 = cljs.core._EQ_.call(null,inst_61597__$1,inst_61606);
var inst_61608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61609 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61610 = (new cljs.core.PersistentVector(null,3,(5),inst_61608,inst_61609,null));
var inst_61611 = cljs.core.get_in.call(null,inst_61602__$1,inst_61610);
var state_61634__$1 = (function (){var statearr_61641 = state_61634;
(statearr_61641[(10)] = inst_61611);

(statearr_61641[(7)] = inst_61597__$1);

(statearr_61641[(8)] = inst_61607__$1);

(statearr_61641[(9)] = inst_61602__$1);

return statearr_61641;
})();
if(inst_61607__$1){
var statearr_61642_61666 = state_61634__$1;
(statearr_61642_61666[(1)] = (6));

} else {
var statearr_61643_61667 = state_61634__$1;
(statearr_61643_61667[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (11))){
var inst_61611 = (state_61634[(10)]);
var inst_61618 = (state_61634[(11)]);
var inst_61617 = (state_61634[(12)]);
var inst_61624 = fluree.db.util.xhttp.try_socket.call(null,inst_61617,sub_chan,pub_chan,inst_61611,(60000),inst_61618);
var state_61634__$1 = state_61634;
var statearr_61645_61668 = state_61634__$1;
(statearr_61645_61668[(2)] = inst_61624);

(statearr_61645_61668[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (9))){
var inst_61611 = (state_61634[(10)]);
var inst_61617 = (state_61634[(12)]);
var inst_61597 = (state_61634[(7)]);
var inst_61607 = (state_61634[(8)]);
var inst_61602 = (state_61634[(9)]);
var inst_61615 = (state_61634[(13)]);
var inst_61615__$1 = (state_61634[(2)]);
var inst_61616 = clojure.string.replace.call(null,inst_61615__$1,"http","ws");
var inst_61617__$1 = [inst_61616,"/fdb/ws"].join('');
var inst_61618 = (function (){var lock_id = inst_61597;
var state = inst_61602;
var have_lock_QMARK_ = inst_61607;
var resp_chan = inst_61611;
var healthy_server = inst_61615__$1;
var ws_url = inst_61617__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_61619 = fluree.db.util.core.exception_QMARK_.call(null,inst_61615__$1);
var state_61634__$1 = (function (){var statearr_61646 = state_61634;
(statearr_61646[(11)] = inst_61618);

(statearr_61646[(12)] = inst_61617__$1);

(statearr_61646[(13)] = inst_61615__$1);

return statearr_61646;
})();
if(inst_61619){
var statearr_61647_61669 = state_61634__$1;
(statearr_61647_61669[(1)] = (10));

} else {
var statearr_61648_61670 = state_61634__$1;
(statearr_61648_61670[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (5))){
var _ = (function (){var statearr_61649 = state_61634;
(statearr_61649[(4)] = cljs.core.rest.call(null,(state_61634[(4)])));

return statearr_61649;
})();
var state_61634__$1 = state_61634;
var ex61644 = (state_61634__$1[(2)]);
var statearr_61650_61671 = state_61634__$1;
(statearr_61650_61671[(5)] = ex61644);


if((ex61644 instanceof Error)){
var statearr_61651_61672 = state_61634__$1;
(statearr_61651_61672[(1)] = (4));

(statearr_61651_61672[(5)] = null);

} else {
throw ex61644;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (10))){
var inst_61611 = (state_61634[(10)]);
var inst_61615 = (state_61634[(13)]);
var inst_61621 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_61622 = cljs.core.async.put_BANG_.call(null,inst_61611,inst_61615);
var state_61634__$1 = (function (){var statearr_61652 = state_61634;
(statearr_61652[(14)] = inst_61621);

return statearr_61652;
})();
var statearr_61653_61673 = state_61634__$1;
(statearr_61653_61673[(2)] = inst_61622);

(statearr_61653_61673[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61635 === (8))){
var inst_61611 = (state_61634[(10)]);
var inst_61629 = (state_61634[(2)]);
var _ = (function (){var statearr_61654 = state_61634;
(statearr_61654[(4)] = cljs.core.rest.call(null,(state_61634[(4)])));

return statearr_61654;
})();
var state_61634__$1 = (function (){var statearr_61655 = state_61634;
(statearr_61655[(15)] = inst_61629);

return statearr_61655;
})();
var statearr_61656_61674 = state_61634__$1;
(statearr_61656_61674[(2)] = inst_61611);

(statearr_61656_61674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_61657 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61657[(0)] = fluree$db$connection$establish_socket_$_state_machine__2741__auto__);

(statearr_61657[(1)] = (1));

return statearr_61657;
});
var fluree$db$connection$establish_socket_$_state_machine__2741__auto____1 = (function (state_61634){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61658){var ex__2744__auto__ = e61658;
var statearr_61659_61675 = state_61634;
(statearr_61659_61675[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61634[(4)]))){
var statearr_61660_61676 = state_61634;
(statearr_61660_61676[(1)] = cljs.core.first.call(null,(state_61634[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61677 = state_61634;
state_61634 = G__61677;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2741__auto__ = function(state_61634){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2741__auto____1.call(this,state_61634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61661 = f__2764__auto__.call(null);
(statearr_61661[(6)] = c__2763__auto__);

return statearr_61661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4502__auto__,k__4503__auto__){
var self__ = this;
var this__4502__auto____$1 = this;
return this__4502__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4503__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4504__auto__,k61679,else__4505__auto__){
var self__ = this;
var this__4504__auto____$1 = this;
var G__61683 = k61679;
var G__61683__$1 = (((G__61683 instanceof cljs.core.Keyword))?G__61683.fqn:null);
switch (G__61683__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k61679,else__4505__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4522__auto__,f__4523__auto__,init__4524__auto__){
var self__ = this;
var this__4522__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4525__auto__,p__61684){
var vec__61685 = p__61684;
var k__4526__auto__ = cljs.core.nth.call(null,vec__61685,(0),null);
var v__4527__auto__ = cljs.core.nth.call(null,vec__61685,(1),null);
return f__4523__auto__.call(null,ret__4525__auto__,k__4526__auto__,v__4527__auto__);
}),init__4524__auto__,this__4522__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4517__auto__,writer__4518__auto__,opts__4519__auto__){
var self__ = this;
var this__4517__auto____$1 = this;
var pr_pair__4520__auto__ = (function (keyval__4521__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,cljs.core.pr_writer,""," ","",opts__4519__auto__,keyval__4521__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4518__auto__,pr_pair__4520__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4519__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__61678){
var self__ = this;
var G__61678__$1 = this;
return (new cljs.core.RecordIter((0),G__61678__$1,22,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4500__auto__){
var self__ = this;
var this__4500__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4497__auto__){
var self__ = this;
var this__4497__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4506__auto__){
var self__ = this;
var this__4506__auto____$1 = this;
return (22 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4498__auto__){
var self__ = this;
var this__4498__auto____$1 = this;
var h__4360__auto__ = self__.__hash;
if((!((h__4360__auto__ == null)))){
return h__4360__auto__;
} else {
var h__4360__auto____$1 = (function (coll__4499__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4499__auto__));
}).call(null,this__4498__auto____$1);
(self__.__hash = h__4360__auto____$1);

return h__4360__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this61680,other61681){
var self__ = this;
var this61680__$1 = this;
return (((!((other61681 == null)))) && ((((this61680__$1.constructor === other61681.constructor)) && (((cljs.core._EQ_.call(null,this61680__$1.id,other61681.id)) && (((cljs.core._EQ_.call(null,this61680__$1.servers,other61681.servers)) && (((cljs.core._EQ_.call(null,this61680__$1.state,other61681.state)) && (((cljs.core._EQ_.call(null,this61680__$1.req_chan,other61681.req_chan)) && (((cljs.core._EQ_.call(null,this61680__$1.sub_chan,other61681.sub_chan)) && (((cljs.core._EQ_.call(null,this61680__$1.pub_chan,other61681.pub_chan)) && (((cljs.core._EQ_.call(null,this61680__$1.group,other61681.group)) && (((cljs.core._EQ_.call(null,this61680__$1.storage_read,other61681.storage_read)) && (((cljs.core._EQ_.call(null,this61680__$1.storage_write,other61681.storage_write)) && (((cljs.core._EQ_.call(null,this61680__$1.object_cache,other61681.object_cache)) && (((cljs.core._EQ_.call(null,this61680__$1.parallelism,other61681.parallelism)) && (((cljs.core._EQ_.call(null,this61680__$1.serializer,other61681.serializer)) && (((cljs.core._EQ_.call(null,this61680__$1.default_network,other61681.default_network)) && (((cljs.core._EQ_.call(null,this61680__$1.transactor_QMARK_,other61681.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this61680__$1.publish,other61681.publish)) && (((cljs.core._EQ_.call(null,this61680__$1.transact_handler,other61681.transact_handler)) && (((cljs.core._EQ_.call(null,this61680__$1.tx_private_key,other61681.tx_private_key)) && (((cljs.core._EQ_.call(null,this61680__$1.tx_key_id,other61681.tx_key_id)) && (((cljs.core._EQ_.call(null,this61680__$1.meta,other61681.meta)) && (((cljs.core._EQ_.call(null,this61680__$1.add_listener,other61681.add_listener)) && (((cljs.core._EQ_.call(null,this61680__$1.remove_listener,other61681.remove_listener)) && (((cljs.core._EQ_.call(null,this61680__$1.close,other61681.close)) && (cljs.core._EQ_.call(null,this61680__$1.__extmap,other61681.__extmap)))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4512__auto__,k__4513__auto__){
var self__ = this;
var this__4512__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 22, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4513__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4512__auto____$1),self__.__meta),k__4513__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4513__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4509__auto__,k61679){
var self__ = this;
var this__4509__auto____$1 = this;
var G__61688 = k61679;
var G__61688__$1 = (((G__61688 instanceof cljs.core.Keyword))?G__61688.fqn:null);
switch (G__61688__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k61679);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4510__auto__,k__4511__auto__,G__61678){
var self__ = this;
var this__4510__auto____$1 = this;
var pred__61689 = cljs.core.keyword_identical_QMARK_;
var expr__61690 = k__4511__auto__;
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__61690))){
return (new fluree.db.connection.Connection(G__61678,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,G__61678,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__61678,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__61678,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__61678,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__61678,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__61678,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__61678,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__61678,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,G__61678,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,G__61678,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__61678,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__61678,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__61678,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__61678,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__61678,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__61678,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__61678,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__61678,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__61678,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__61678,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__61689.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__61690))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__61678,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4511__auto__,G__61678),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4515__auto__){
var self__ = this;
var this__4515__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4501__auto__,G__61678){
var self__ = this;
var this__4501__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__61678,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4507__auto__,entry__4508__auto__){
var self__ = this;
var this__4507__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4508__auto__)){
return this__4507__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4508__auto__,(0)),cljs.core._nth.call(null,entry__4508__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4507__auto____$1,entry__4508__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 22, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4546__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4546__auto__,writer__4547__auto__){
return cljs.core._write.call(null,writer__4547__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__61682){
var extmap__4542__auto__ = (function (){var G__61692 = cljs.core.dissoc.call(null,G__61682,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__61682)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__61692);
} else {
return G__61692;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__61682),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__61682),null,cljs.core.not_empty.call(null,extmap__4542__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__61698 = servers_STAR_;
var vec__61699 = G__61698;
var seq__61700 = cljs.core.seq.call(null,vec__61699);
var first__61701 = cljs.core.first.call(null,seq__61700);
var seq__61700__$1 = cljs.core.next.call(null,seq__61700);
var server = first__61701;
var r = seq__61700__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__61698__$1 = G__61698;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__61705 = G__61698__$1;
var seq__61706 = cljs.core.seq.call(null,vec__61705);
var first__61707 = cljs.core.first.call(null,seq__61706);
var seq__61706__$1 = cljs.core.next.call(null,seq__61706);
var server__$1 = first__61707;
var r__$1 = seq__61706__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__61708 = r__$1;
var G__61709 = is_https_QMARK_;
var G__61710 = result_STAR_;
G__61698__$1 = G__61708;
https_QMARK___$1 = G__61709;
result__$1 = G__61710;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__61711 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__61711 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__61711);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61740){
var state_val_61741 = (state_61740[(1)]);
if((state_val_61741 === (7))){
var inst_61726 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61727 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61728 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61729 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61730 = fluree.db.connection.establish_socket.call(null,inst_61726,inst_61727,inst_61728,inst_61729);
var state_61740__$1 = state_61740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61740__$1,(9),inst_61730);
} else {
if((state_val_61741 === (1))){
var state_61740__$1 = state_61740;
var statearr_61742_61761 = state_61740__$1;
(statearr_61742_61761[(2)] = null);

(statearr_61742_61761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (4))){
var inst_61712 = (state_61740[(2)]);
var state_61740__$1 = state_61740;
var statearr_61743_61762 = state_61740__$1;
(statearr_61743_61762[(2)] = inst_61712);

(statearr_61743_61762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (6))){
var inst_61723 = (state_61740[(7)]);
var state_61740__$1 = state_61740;
var statearr_61744_61763 = state_61740__$1;
(statearr_61744_61763[(2)] = inst_61723);

(statearr_61744_61763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (3))){
var inst_61738 = (state_61740[(2)]);
var state_61740__$1 = state_61740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61740__$1,inst_61738);
} else {
if((state_val_61741 === (2))){
var inst_61723 = (state_61740[(7)]);
var _ = (function (){var statearr_61746 = state_61740;
(statearr_61746[(4)] = cljs.core.cons.call(null,(5),(state_61740[(4)])));

return statearr_61746;
})();
var inst_61718 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_61719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61720 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_61721 = [inst_61720,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_61722 = (new cljs.core.PersistentVector(null,3,(5),inst_61719,inst_61721,null));
var inst_61723__$1 = cljs.core.get_in.call(null,inst_61718,inst_61722);
var state_61740__$1 = (function (){var statearr_61747 = state_61740;
(statearr_61747[(7)] = inst_61723__$1);

return statearr_61747;
})();
if(cljs.core.truth_(inst_61723__$1)){
var statearr_61748_61764 = state_61740__$1;
(statearr_61748_61764[(1)] = (6));

} else {
var statearr_61749_61765 = state_61740__$1;
(statearr_61749_61765[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (9))){
var inst_61732 = (state_61740[(2)]);
var inst_61733 = fluree.db.util.async.throw_err.call(null,inst_61732);
var state_61740__$1 = state_61740;
var statearr_61750_61766 = state_61740__$1;
(statearr_61750_61766[(2)] = inst_61733);

(statearr_61750_61766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (5))){
var _ = (function (){var statearr_61751 = state_61740;
(statearr_61751[(4)] = cljs.core.rest.call(null,(state_61740[(4)])));

return statearr_61751;
})();
var state_61740__$1 = state_61740;
var ex61745 = (state_61740__$1[(2)]);
var statearr_61752_61767 = state_61740__$1;
(statearr_61752_61767[(5)] = ex61745);


if((ex61745 instanceof Error)){
var statearr_61753_61768 = state_61740__$1;
(statearr_61753_61768[(1)] = (4));

(statearr_61753_61768[(5)] = null);

} else {
throw ex61745;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61741 === (8))){
var inst_61735 = (state_61740[(2)]);
var _ = (function (){var statearr_61754 = state_61740;
(statearr_61754[(4)] = cljs.core.rest.call(null,(state_61740[(4)])));

return statearr_61754;
})();
var state_61740__$1 = state_61740;
var statearr_61755_61769 = state_61740__$1;
(statearr_61755_61769[(2)] = inst_61735);

(statearr_61755_61769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2741__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2741__auto____0 = (function (){
var statearr_61756 = [null,null,null,null,null,null,null,null];
(statearr_61756[(0)] = fluree$db$connection$get_socket_$_state_machine__2741__auto__);

(statearr_61756[(1)] = (1));

return statearr_61756;
});
var fluree$db$connection$get_socket_$_state_machine__2741__auto____1 = (function (state_61740){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61757){var ex__2744__auto__ = e61757;
var statearr_61758_61770 = state_61740;
(statearr_61758_61770[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61740[(4)]))){
var statearr_61759_61771 = state_61740;
(statearr_61759_61771[(1)] = cljs.core.first.call(null,(state_61740[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61772 = state_61740;
state_61740 = G__61772;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2741__auto__ = function(state_61740){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2741__auto____1.call(this,state_61740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2741__auto____0;
fluree$db$connection$get_socket_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2741__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61760 = f__2764__auto__.call(null);
(statearr_61760[(6)] = c__2763__auto__);

return statearr_61760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4253__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e61773){var e = e61773;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61900){
var state_val_61901 = (state_61900[(1)]);
if((state_val_61901 === (7))){
var inst_61896 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
var statearr_61903_61973 = state_61900__$1;
(statearr_61903_61973[(2)] = inst_61896);

(statearr_61903_61973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (20))){
var _ = (function (){var statearr_61904 = state_61900;
(statearr_61904[(4)] = cljs.core.rest.call(null,(state_61900[(4)])));

return statearr_61904;
})();
var state_61900__$1 = state_61900;
var ex61902 = (state_61900__$1[(2)]);
var statearr_61905_61974 = state_61900__$1;
(statearr_61905_61974[(5)] = ex61902);


var statearr_61906_61975 = state_61900__$1;
(statearr_61906_61975[(1)] = (10));

(statearr_61906_61975[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (27))){
var inst_61888 = (state_61900[(2)]);
var _ = (function (){var statearr_61907 = state_61900;
(statearr_61907[(4)] = cljs.core.rest.call(null,(state_61900[(4)])));

return statearr_61907;
})();
var state_61900__$1 = state_61900;
var statearr_61908_61976 = state_61900__$1;
(statearr_61908_61976[(2)] = inst_61888);

(statearr_61908_61976[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (1))){
var inst_61775 = (0);
var state_61900__$1 = (function (){var statearr_61909 = state_61900;
(statearr_61909[(7)] = inst_61775);

return statearr_61909;
})();
var statearr_61910_61977 = state_61900__$1;
(statearr_61910_61977[(2)] = null);

(statearr_61910_61977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (24))){
var inst_61866 = (state_61900[(8)]);
var inst_61866__$1 = (state_61900[(2)]);
var inst_61867 = inst_61866__$1 === true;
var state_61900__$1 = (function (){var statearr_61911 = state_61900;
(statearr_61911[(8)] = inst_61866__$1);

return statearr_61911;
})();
if(cljs.core.truth_(inst_61867)){
var statearr_61912_61978 = state_61900__$1;
(statearr_61912_61978[(1)] = (25));

} else {
var statearr_61913_61979 = state_61900__$1;
(statearr_61913_61979[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (4))){
var inst_61778 = (state_61900[(9)]);
var inst_61778__$1 = (state_61900[(2)]);
var state_61900__$1 = (function (){var statearr_61914 = state_61900;
(statearr_61914[(9)] = inst_61778__$1);

return statearr_61914;
})();
if(cljs.core.truth_(inst_61778__$1)){
var statearr_61915_61980 = state_61900__$1;
(statearr_61915_61980[(1)] = (5));

} else {
var statearr_61916_61981 = state_61900__$1;
(statearr_61916_61981[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (15))){
var inst_61791 = (state_61900[(10)]);
var state_61900__$1 = state_61900;
var statearr_61917_61982 = state_61900__$1;
(statearr_61917_61982[(2)] = inst_61791);

(statearr_61917_61982[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (21))){
var inst_61822 = (state_61900[(11)]);
var inst_61814 = (state_61900[(12)]);
var inst_61775 = (state_61900[(7)]);
var inst_61815 = (state_61900[(13)]);
var inst_61823 = (state_61900[(14)]);
var inst_61817 = (state_61900[(15)]);
var inst_61816 = (state_61900[(16)]);
var inst_61819 = (state_61900[(17)]);
var inst_61818 = (state_61900[(18)]);
var inst_61778 = (state_61900[(9)]);
var inst_61825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61826 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61822];
var inst_61827 = (new cljs.core.PersistentVector(null,2,(5),inst_61825,inst_61826,null));
var inst_61828 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_61827,inst_61817);
var inst_61855 = cljs.core.async.chan.call(null,(1));
var inst_61856 = (function (){var resp_chan = inst_61817;
var timeout = inst_61823;
var i = inst_61775;
var data = inst_61816;
var _ = inst_61814;
var map__61813 = inst_61819;
var req_id = inst_61822;
var operation = inst_61815;
var msg = inst_61778;
var vec__61810 = inst_61778;
var c__2763__auto____$1 = inst_61855;
var opts = inst_61818;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_61853){
var state_val_61854 = (state_61853[(1)]);
if((state_val_61854 === (1))){
var inst_61832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61833 = cljs.core.async.timeout.call(null,timeout);
var inst_61834 = [resp_chan,inst_61833];
var inst_61835 = (new cljs.core.PersistentVector(null,2,(5),inst_61832,inst_61834,null));
var state_61853__$1 = state_61853;
return cljs.core.async.ioc_alts_BANG_.call(null,state_61853__$1,(2),inst_61835);
} else {
if((state_val_61854 === (2))){
var inst_61838 = (state_61853[(7)]);
var inst_61837 = (state_61853[(2)]);
var inst_61838__$1 = cljs.core.nth.call(null,inst_61837,(0),null);
var inst_61839 = cljs.core.nth.call(null,inst_61837,(1),null);
var inst_61840 = (function (){var vec__61829 = inst_61837;
var resp = inst_61838__$1;
var c = inst_61839;
return (function (p1__61774_SHARP_){
return cljs.core.dissoc.call(null,p1__61774_SHARP_,req_id);
});
})();
var inst_61841 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_61840);
var inst_61842 = cljs.core._EQ_.call(null,inst_61839,resp_chan);
var state_61853__$1 = (function (){var statearr_61918 = state_61853;
(statearr_61918[(7)] = inst_61838__$1);

(statearr_61918[(8)] = inst_61841);

return statearr_61918;
})();
if(inst_61842){
var statearr_61919_61983 = state_61853__$1;
(statearr_61919_61983[(1)] = (3));

} else {
var statearr_61920_61984 = state_61853__$1;
(statearr_61920_61984[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61854 === (3))){
var inst_61838 = (state_61853[(7)]);
var state_61853__$1 = state_61853;
var statearr_61921_61985 = state_61853__$1;
(statearr_61921_61985[(2)] = inst_61838);

(statearr_61921_61985[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61854 === (4))){
var inst_61845 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_61846 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61847 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_61848 = cljs.core.PersistentHashMap.fromArrays(inst_61846,inst_61847);
var inst_61849 = cljs.core.ex_info.call(null,inst_61845,inst_61848);
var state_61853__$1 = state_61853;
var statearr_61922_61986 = state_61853__$1;
(statearr_61922_61986[(2)] = inst_61849);

(statearr_61922_61986[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61854 === (5))){
var inst_61851 = (state_61853[(2)]);
var state_61853__$1 = state_61853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61853__$1,inst_61851);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_61923 = [null,null,null,null,null,null,null,null,null];
(statearr_61923[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_61923[(1)] = (1));

return statearr_61923;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_61853){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61924){var ex__2744__auto__ = e61924;
var statearr_61925_61987 = state_61853;
(statearr_61925_61987[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61853[(4)]))){
var statearr_61926_61988 = state_61853;
(statearr_61926_61988[(1)] = cljs.core.first.call(null,(state_61853[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61989 = state_61853;
state_61853 = G__61989;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_61853){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_61853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61927 = f__2764__auto__.call(null);
(statearr_61927[(6)] = c__2763__auto____$1);

return statearr_61927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
});
})();
var inst_61857 = cljs.core.async.impl.dispatch.run.call(null,inst_61856);
var state_61900__$1 = (function (){var statearr_61928 = state_61900;
(statearr_61928[(19)] = inst_61857);

(statearr_61928[(20)] = inst_61828);

return statearr_61928;
})();
var statearr_61929_61990 = state_61900__$1;
(statearr_61929_61990[(2)] = inst_61855);

(statearr_61929_61990[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (31))){
var inst_61876 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_61900__$1 = state_61900;
var statearr_61930_61991 = state_61900__$1;
(statearr_61930_61991[(2)] = inst_61876);

(statearr_61930_61991[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (32))){
var state_61900__$1 = state_61900;
var statearr_61931_61992 = state_61900__$1;
(statearr_61931_61992[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (33))){
var inst_61884 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
var statearr_61933_61993 = state_61900__$1;
(statearr_61933_61993[(2)] = inst_61884);

(statearr_61933_61993[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (13))){
var inst_61791 = (state_61900[(10)]);
var inst_61788 = (state_61900[(2)]);
var inst_61789 = cljs.core.nth.call(null,inst_61788,(0),null);
var inst_61790 = cljs.core.nth.call(null,inst_61788,(1),null);
var inst_61791__$1 = cljs.core.nth.call(null,inst_61788,(2),null);
var state_61900__$1 = (function (){var statearr_61934 = state_61900;
(statearr_61934[(21)] = inst_61790);

(statearr_61934[(10)] = inst_61791__$1);

(statearr_61934[(22)] = inst_61789);

return statearr_61934;
})();
if(cljs.core.truth_(inst_61791__$1)){
var statearr_61935_61994 = state_61900__$1;
(statearr_61935_61994[(1)] = (14));

} else {
var statearr_61936_61995 = state_61900__$1;
(statearr_61936_61995[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (22))){
var state_61900__$1 = state_61900;
var statearr_61937_61996 = state_61900__$1;
(statearr_61937_61996[(2)] = null);

(statearr_61937_61996[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (36))){
var inst_61882 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
var statearr_61938_61997 = state_61900__$1;
(statearr_61938_61997[(2)] = inst_61882);

(statearr_61938_61997[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (29))){
var inst_61866 = (state_61900[(8)]);
var inst_61874 = (inst_61866 == null);
var state_61900__$1 = state_61900;
if(cljs.core.truth_(inst_61874)){
var statearr_61939_61998 = state_61900__$1;
(statearr_61939_61998[(1)] = (31));

} else {
var statearr_61940_61999 = state_61900__$1;
(statearr_61940_61999[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (6))){
var state_61900__$1 = state_61900;
var statearr_61941_62000 = state_61900__$1;
(statearr_61941_62000[(2)] = null);

(statearr_61941_62000[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (28))){
var inst_61866 = (state_61900[(8)]);
var inst_61872 = fluree.db.util.log.error.call(null,inst_61866,"Error processing message in producer.");
var state_61900__$1 = state_61900;
var statearr_61942_62001 = state_61900__$1;
(statearr_61942_62001[(2)] = inst_61872);

(statearr_61942_62001[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (25))){
var state_61900__$1 = state_61900;
var statearr_61943_62002 = state_61900__$1;
(statearr_61943_62002[(2)] = null);

(statearr_61943_62002[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (34))){
var inst_61866 = (state_61900[(8)]);
var inst_61879 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_61866);
var state_61900__$1 = state_61900;
var statearr_61944_62003 = state_61900__$1;
(statearr_61944_62003[(2)] = inst_61879);

(statearr_61944_62003[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (17))){
var inst_61791 = (state_61900[(10)]);
var inst_61780 = (state_61900[(23)]);
var inst_61798 = cljs.core.async.put_BANG_.call(null,inst_61791,inst_61780);
var state_61900__$1 = state_61900;
var statearr_61945_62004 = state_61900__$1;
(statearr_61945_62004[(2)] = inst_61798);

(statearr_61945_62004[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (3))){
var inst_61898 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61900__$1,inst_61898);
} else {
if((state_val_61901 === (12))){
var state_61900__$1 = state_61900;
var statearr_61946_62005 = state_61900__$1;
(statearr_61946_62005[(2)] = null);

(statearr_61946_62005[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (2))){
var state_61900__$1 = state_61900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61900__$1,(4),req_chan);
} else {
if((state_val_61901 === (23))){
var inst_61822 = (state_61900[(11)]);
var inst_61815 = (state_61900[(13)]);
var inst_61816 = (state_61900[(16)]);
var inst_61860 = (state_61900[(2)]);
var inst_61861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61862 = [inst_61815,inst_61822,inst_61816];
var inst_61863 = (new cljs.core.PersistentVector(null,3,(5),inst_61861,inst_61862,null));
var inst_61864 = publish_fn.call(null,conn,inst_61863);
var state_61900__$1 = (function (){var statearr_61947 = state_61900;
(statearr_61947[(24)] = inst_61860);

return statearr_61947;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61900__$1,(24),inst_61864);
} else {
if((state_val_61901 === (35))){
var state_61900__$1 = state_61900;
var statearr_61948_62006 = state_61900__$1;
(statearr_61948_62006[(2)] = null);

(statearr_61948_62006[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (19))){
var inst_61804 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
var statearr_61949_62007 = state_61900__$1;
(statearr_61949_62007[(2)] = inst_61804);

(statearr_61949_62007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (11))){
var inst_61778 = (state_61900[(9)]);
var state_61900__$1 = state_61900;
var statearr_61950_62008 = state_61900__$1;
(statearr_61950_62008[(2)] = inst_61778);

(statearr_61950_62008[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (9))){
var inst_61775 = (state_61900[(7)]);
var inst_61891 = (state_61900[(2)]);
var inst_61892 = (inst_61775 + (1));
var inst_61775__$1 = inst_61892;
var state_61900__$1 = (function (){var statearr_61951 = state_61900;
(statearr_61951[(25)] = inst_61891);

(statearr_61951[(7)] = inst_61775__$1);

return statearr_61951;
})();
var statearr_61952_62009 = state_61900__$1;
(statearr_61952_62009[(2)] = null);

(statearr_61952_62009[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (5))){
var state_61900__$1 = state_61900;
var statearr_61953_62010 = state_61900__$1;
(statearr_61953_62010[(2)] = null);

(statearr_61953_62010[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (14))){
var inst_61791 = (state_61900[(10)]);
var inst_61793 = fluree.db.util.async.channel_QMARK_.call(null,inst_61791);
var state_61900__$1 = state_61900;
var statearr_61954_62011 = state_61900__$1;
(statearr_61954_62011[(2)] = inst_61793);

(statearr_61954_62011[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (26))){
var inst_61866 = (state_61900[(8)]);
var inst_61870 = fluree.db.util.core.exception_QMARK_.call(null,inst_61866);
var state_61900__$1 = state_61900;
if(inst_61870){
var statearr_61955_62012 = state_61900__$1;
(statearr_61955_62012[(1)] = (28));

} else {
var statearr_61956_62013 = state_61900__$1;
(statearr_61956_62013[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (16))){
var inst_61796 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
if(cljs.core.truth_(inst_61796)){
var statearr_61957_62014 = state_61900__$1;
(statearr_61957_62014[(1)] = (17));

} else {
var statearr_61958_62015 = state_61900__$1;
(statearr_61958_62015[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (30))){
var inst_61886 = (state_61900[(2)]);
var state_61900__$1 = state_61900;
var statearr_61959_62016 = state_61900__$1;
(statearr_61959_62016[(2)] = inst_61886);

(statearr_61959_62016[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (10))){
var inst_61778 = (state_61900[(9)]);
var inst_61780 = (state_61900[(2)]);
var inst_61784 = cljs.core.sequential_QMARK_.call(null,inst_61778);
var state_61900__$1 = (function (){var statearr_61960 = state_61900;
(statearr_61960[(23)] = inst_61780);

return statearr_61960;
})();
if(inst_61784){
var statearr_61961_62017 = state_61900__$1;
(statearr_61961_62017[(1)] = (11));

} else {
var statearr_61962_62018 = state_61900__$1;
(statearr_61962_62018[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (18))){
var inst_61780 = (state_61900[(23)]);
var inst_61778 = (state_61900[(9)]);
var inst_61800 = cljs.core.pr_str.call(null,inst_61778);
var inst_61801 = ["Error processing ledger request, no valid return channel: ",inst_61800].join('');
var inst_61802 = fluree.db.util.log.error.call(null,inst_61780,inst_61801);
var state_61900__$1 = state_61900;
var statearr_61963_62019 = state_61900__$1;
(statearr_61963_62019[(2)] = inst_61802);

(statearr_61963_62019[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61901 === (8))){
var inst_61817 = (state_61900[(15)]);
var inst_61819 = (state_61900[(17)]);
var inst_61818 = (state_61900[(18)]);
var inst_61778 = (state_61900[(9)]);
var _ = (function (){var statearr_61964 = state_61900;
(statearr_61964[(4)] = cljs.core.cons.call(null,(20),(state_61900[(4)])));

return statearr_61964;
})();
var inst_61814 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_61778);
var inst_61815 = cljs.core.nth.call(null,inst_61778,(0),null);
var inst_61816 = cljs.core.nth.call(null,inst_61778,(1),null);
var inst_61817__$1 = cljs.core.nth.call(null,inst_61778,(2),null);
var inst_61818__$1 = cljs.core.nth.call(null,inst_61778,(3),null);
var inst_61819__$1 = cljs.core.__destructure_map.call(null,inst_61818__$1);
var inst_61820 = fluree.db.util.core.random_uuid.call(null);
var inst_61821 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_61820);
var inst_61822 = cljs.core.get.call(null,inst_61819__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_61821);
var inst_61823 = cljs.core.get.call(null,inst_61819__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_61900__$1 = (function (){var statearr_61965 = state_61900;
(statearr_61965[(11)] = inst_61822);

(statearr_61965[(12)] = inst_61814);

(statearr_61965[(13)] = inst_61815);

(statearr_61965[(14)] = inst_61823);

(statearr_61965[(15)] = inst_61817__$1);

(statearr_61965[(16)] = inst_61816);

(statearr_61965[(17)] = inst_61819__$1);

(statearr_61965[(18)] = inst_61818__$1);

return statearr_61965;
})();
if(cljs.core.truth_(inst_61817__$1)){
var statearr_61966_62020 = state_61900__$1;
(statearr_61966_62020[(1)] = (21));

} else {
var statearr_61967_62021 = state_61900__$1;
(statearr_61967_62021[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____0 = (function (){
var statearr_61968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61968[(0)] = fluree$db$connection$msg_producer_$_state_machine__2741__auto__);

(statearr_61968[(1)] = (1));

return statearr_61968;
});
var fluree$db$connection$msg_producer_$_state_machine__2741__auto____1 = (function (state_61900){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_61900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e61969){var ex__2744__auto__ = e61969;
var statearr_61970_62022 = state_61900;
(statearr_61970_62022[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_61900[(4)]))){
var statearr_61971_62023 = state_61900;
(statearr_61971_62023[(1)] = cljs.core.first.call(null,(state_61900[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62024 = state_61900;
state_61900 = G__62024;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2741__auto__ = function(state_61900){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2741__auto____1.call(this,state_61900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_61972 = f__2764__auto__.call(null);
(statearr_61972[(6)] = c__2763__auto__);

return statearr_61972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__62025 = conn;
var map__62025__$1 = cljs.core.__destructure_map.call(null,map__62025);
var sub_chan = cljs.core.get.call(null,map__62025__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62110){
var state_val_62111 = (state_62110[(1)]);
if((state_val_62111 === (7))){
var inst_62106 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62112_62163 = state_62110__$1;
(statearr_62112_62163[(2)] = inst_62106);

(statearr_62112_62163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (20))){
var inst_62044 = (state_62110[(7)]);
var inst_62058 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_62059 = [inst_62044];
var inst_62060 = cljs.core.PersistentHashMap.fromArrays(inst_62058,inst_62059);
var inst_62061 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_62060);
var state_62110__$1 = state_62110;
var statearr_62113_62164 = state_62110__$1;
(statearr_62113_62164[(2)] = inst_62061);

(statearr_62113_62164[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (27))){
var state_62110__$1 = state_62110;
var statearr_62114_62165 = state_62110__$1;
(statearr_62114_62165[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (1))){
var inst_62026 = (0);
var state_62110__$1 = (function (){var statearr_62116 = state_62110;
(statearr_62116[(8)] = inst_62026);

return statearr_62116;
})();
var statearr_62117_62166 = state_62110__$1;
(statearr_62117_62166[(2)] = null);

(statearr_62117_62166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (24))){
var inst_62037 = (state_62110[(9)]);
var inst_62086 = fluree.db.util.core.exception_QMARK_.call(null,inst_62037);
var state_62110__$1 = state_62110;
if(inst_62086){
var statearr_62118_62167 = state_62110__$1;
(statearr_62118_62167[(1)] = (26));

} else {
var statearr_62119_62168 = state_62110__$1;
(statearr_62119_62168[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (4))){
var inst_62031 = (state_62110[(10)]);
var inst_62036 = (state_62110[(2)]);
var inst_62037 = cljs.core.nth.call(null,inst_62036,(0),null);
var inst_62038 = cljs.core.nth.call(null,inst_62036,(1),null);
var inst_62039 = cljs.core._EQ_.call(null,inst_62038,inst_62031);
var state_62110__$1 = (function (){var statearr_62120 = state_62110;
(statearr_62120[(9)] = inst_62037);

return statearr_62120;
})();
if(inst_62039){
var statearr_62121_62169 = state_62110__$1;
(statearr_62121_62169[(1)] = (5));

} else {
var statearr_62122_62170 = state_62110__$1;
(statearr_62122_62170[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (15))){
var inst_62044 = (state_62110[(7)]);
var inst_62053 = typeof inst_62044 === 'string';
var state_62110__$1 = state_62110;
if(cljs.core.truth_(inst_62053)){
var statearr_62123_62171 = state_62110__$1;
(statearr_62123_62171[(1)] = (17));

} else {
var statearr_62124_62172 = state_62110__$1;
(statearr_62124_62172[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (21))){
var state_62110__$1 = state_62110;
var statearr_62125_62173 = state_62110__$1;
(statearr_62125_62173[(2)] = null);

(statearr_62125_62173[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (31))){
var inst_62100 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62126_62174 = state_62110__$1;
(statearr_62126_62174[(2)] = inst_62100);

(statearr_62126_62174[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (13))){
var inst_62070 = (state_62110[(2)]);
var inst_62071 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62072 = fluree.db.connection.close_websocket.call(null,inst_62071);
var inst_62073 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62074 = fluree.db.session.close_all_sessions.call(null,inst_62073);
var state_62110__$1 = (function (){var statearr_62127 = state_62110;
(statearr_62127[(11)] = inst_62072);

(statearr_62127[(12)] = inst_62070);

return statearr_62127;
})();
var statearr_62128_62175 = state_62110__$1;
(statearr_62128_62175[(2)] = inst_62074);

(statearr_62128_62175[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (22))){
var inst_62064 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62129_62176 = state_62110__$1;
(statearr_62129_62176[(2)] = inst_62064);

(statearr_62129_62176[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (29))){
var inst_62037 = (state_62110[(9)]);
var inst_62092 = fluree.db.util.json.parse.call(null,inst_62037);
var inst_62093 = cljs.core.pr_str.call(null,inst_62092);
var inst_62094 = fluree.db.util.log.trace.call(null,"Received message:",inst_62093);
var inst_62095 = fluree.db.util.json.parse.call(null,inst_62037);
var inst_62096 = fluree.db.conn_events.process_events.call(null,conn,inst_62095);
var inst_62026 = (0);
var state_62110__$1 = (function (){var statearr_62130 = state_62110;
(statearr_62130[(8)] = inst_62026);

(statearr_62130[(13)] = inst_62094);

(statearr_62130[(14)] = inst_62096);

return statearr_62130;
})();
var statearr_62131_62177 = state_62110__$1;
(statearr_62131_62177[(2)] = null);

(statearr_62131_62177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (6))){
var inst_62037 = (state_62110[(9)]);
var inst_62082 = (inst_62037 == null);
var state_62110__$1 = state_62110;
if(cljs.core.truth_(inst_62082)){
var statearr_62132_62178 = state_62110__$1;
(statearr_62132_62178[(1)] = (23));

} else {
var statearr_62133_62179 = state_62110__$1;
(statearr_62133_62179[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (28))){
var inst_62102 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62134_62180 = state_62110__$1;
(statearr_62134_62180[(2)] = inst_62102);

(statearr_62134_62180[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (25))){
var inst_62104 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62135_62181 = state_62110__$1;
(statearr_62135_62181[(2)] = inst_62104);

(statearr_62135_62181[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (17))){
var inst_62044 = (state_62110[(7)]);
var inst_62055 = cljs.core.eval.call(null,inst_62044);
var state_62110__$1 = state_62110;
var statearr_62136_62182 = state_62110__$1;
(statearr_62136_62182[(2)] = inst_62055);

(statearr_62136_62182[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (3))){
var inst_62108 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62110__$1,inst_62108);
} else {
if((state_val_62111 === (12))){
var inst_62044 = (state_62110[(7)]);
var inst_62049 = cljs.core.fn_QMARK_.call(null,inst_62044);
var state_62110__$1 = state_62110;
if(inst_62049){
var statearr_62137_62183 = state_62110__$1;
(statearr_62137_62183[(1)] = (14));

} else {
var statearr_62138_62184 = state_62110__$1;
(statearr_62138_62184[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (2))){
var inst_62031 = (state_62110[(10)]);
var inst_62031__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_62032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62033 = [sub_chan,inst_62031__$1];
var inst_62034 = (new cljs.core.PersistentVector(null,2,(5),inst_62032,inst_62033,null));
var state_62110__$1 = (function (){var statearr_62139 = state_62110;
(statearr_62139[(10)] = inst_62031__$1);

return statearr_62139;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_62110__$1,(4),inst_62034);
} else {
if((state_val_62111 === (23))){
var inst_62084 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_62110__$1 = state_62110;
var statearr_62140_62185 = state_62110__$1;
(statearr_62140_62185[(2)] = inst_62084);

(statearr_62140_62185[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (19))){
var inst_62066 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62141_62186 = state_62110__$1;
(statearr_62141_62186[(2)] = inst_62066);

(statearr_62141_62186[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (11))){
var inst_62047 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_62110__$1 = state_62110;
var statearr_62142_62187 = state_62110__$1;
(statearr_62142_62187[(2)] = inst_62047);

(statearr_62142_62187[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (9))){
var inst_62026 = (state_62110[(8)]);
var inst_62076 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_62077 = (inst_62026 + (1));
var inst_62026__$1 = inst_62077;
var state_62110__$1 = (function (){var statearr_62143 = state_62110;
(statearr_62143[(8)] = inst_62026__$1);

(statearr_62143[(15)] = inst_62076);

return statearr_62143;
})();
var statearr_62144_62188 = state_62110__$1;
(statearr_62144_62188[(2)] = null);

(statearr_62144_62188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (5))){
var inst_62026 = (state_62110[(8)]);
var inst_62041 = cljs.core._EQ_.call(null,(2),inst_62026);
var state_62110__$1 = state_62110;
if(inst_62041){
var statearr_62145_62189 = state_62110__$1;
(statearr_62145_62189[(1)] = (8));

} else {
var statearr_62146_62190 = state_62110__$1;
(statearr_62146_62190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (14))){
var inst_62044 = (state_62110[(7)]);
var inst_62051 = inst_62044.call(null);
var state_62110__$1 = state_62110;
var statearr_62147_62191 = state_62110__$1;
(statearr_62147_62191[(2)] = inst_62051);

(statearr_62147_62191[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (26))){
var inst_62037 = (state_62110[(9)]);
var inst_62088 = fluree.db.util.log.error.call(null,inst_62037);
var inst_62026 = (0);
var state_62110__$1 = (function (){var statearr_62148 = state_62110;
(statearr_62148[(8)] = inst_62026);

(statearr_62148[(16)] = inst_62088);

return statearr_62148;
})();
var statearr_62149_62192 = state_62110__$1;
(statearr_62149_62192[(2)] = null);

(statearr_62149_62192[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (16))){
var inst_62068 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62150_62193 = state_62110__$1;
(statearr_62150_62193[(2)] = inst_62068);

(statearr_62150_62193[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (30))){
var state_62110__$1 = state_62110;
var statearr_62151_62194 = state_62110__$1;
(statearr_62151_62194[(2)] = null);

(statearr_62151_62194[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (10))){
var inst_62080 = (state_62110[(2)]);
var state_62110__$1 = state_62110;
var statearr_62152_62195 = state_62110__$1;
(statearr_62152_62195[(2)] = inst_62080);

(statearr_62152_62195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (18))){
var state_62110__$1 = state_62110;
var statearr_62153_62196 = state_62110__$1;
(statearr_62153_62196[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62111 === (8))){
var inst_62044 = (state_62110[(7)]);
var inst_62043 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_62044__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_62045 = (inst_62044__$1 == null);
var state_62110__$1 = (function (){var statearr_62155 = state_62110;
(statearr_62155[(7)] = inst_62044__$1);

(statearr_62155[(17)] = inst_62043);

return statearr_62155;
})();
if(cljs.core.truth_(inst_62045)){
var statearr_62156_62197 = state_62110__$1;
(statearr_62156_62197[(1)] = (11));

} else {
var statearr_62157_62198 = state_62110__$1;
(statearr_62157_62198[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0 = (function (){
var statearr_62158 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62158[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2741__auto__);

(statearr_62158[(1)] = (1));

return statearr_62158;
});
var fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1 = (function (state_62110){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62110);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62159){var ex__2744__auto__ = e62159;
var statearr_62160_62199 = state_62110;
(statearr_62160_62199[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62110[(4)]))){
var statearr_62161_62200 = state_62110;
(statearr_62161_62200[(1)] = cljs.core.first.call(null,(state_62110[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62201 = state_62110;
state_62110 = G__62201;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__ = function(state_62110){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1.call(this,state_62110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2741__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62162 = f__2764__auto__.call(null);
(statearr_62162[(6)] = c__2763__auto__);

return statearr_62162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__62203 = arguments.length;
switch (G__62203) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__62204 = opts;
var map__62204__$1 = cljs.core.__destructure_map.call(null,map__62204);
var private$ = cljs.core.get.call(null,map__62204__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__62204__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2763__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62256){
var state_val_62257 = (state_62256[(1)]);
if((state_val_62257 === (7))){
var inst_62214 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_62215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62216 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_62217 = (new cljs.core.PersistentVector(null,2,(5),inst_62215,inst_62216,null));
var inst_62218 = cljs.core.get_in.call(null,inst_62214,inst_62217);
var state_62256__$1 = state_62256;
var statearr_62258_62289 = state_62256__$1;
(statearr_62258_62289[(2)] = inst_62218);

(statearr_62258_62289[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (1))){
var state_62256__$1 = state_62256;
var statearr_62259_62290 = state_62256__$1;
(statearr_62259_62290[(2)] = null);

(statearr_62259_62290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (4))){
var inst_62205 = (state_62256[(2)]);
var state_62256__$1 = state_62256;
var statearr_62260_62291 = state_62256__$1;
(statearr_62260_62291[(2)] = inst_62205);

(statearr_62260_62291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (15))){
var inst_62225 = (state_62256[(7)]);
var inst_62244 = (state_62256[(2)]);
var inst_62245 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_62246 = [(5000),inst_62244,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_62247 = cljs.core.PersistentHashMap.fromArrays(inst_62245,inst_62246);
var inst_62248 = fluree.db.util.xhttp.get.call(null,inst_62225,inst_62247);
var state_62256__$1 = state_62256;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62256__$1,(16),inst_62248);
} else {
if((state_val_62257 === (13))){
var inst_62235 = (state_62256[(8)]);
var inst_62225 = (state_62256[(7)]);
var inst_62237 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_62238 = [inst_62235];
var inst_62239 = cljs.core.PersistentHashMap.fromArrays(inst_62237,inst_62238);
var inst_62240 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_62225,inst_62239,private$);
var inst_62241 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_62240);
var state_62256__$1 = state_62256;
var statearr_62261_62292 = state_62256__$1;
(statearr_62261_62292[(2)] = inst_62241);

(statearr_62261_62292[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (6))){
var inst_62211 = (state_62256[(9)]);
var state_62256__$1 = state_62256;
var statearr_62262_62293 = state_62256__$1;
(statearr_62262_62293[(2)] = inst_62211);

(statearr_62262_62293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (3))){
var inst_62254 = (state_62256[(2)]);
var state_62256__$1 = state_62256;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62256__$1,inst_62254);
} else {
if((state_val_62257 === (12))){
var inst_62235 = (state_62256[(2)]);
var state_62256__$1 = (function (){var statearr_62263 = state_62256;
(statearr_62263[(8)] = inst_62235);

return statearr_62263;
})();
if(cljs.core.truth_(private$)){
var statearr_62264_62294 = state_62256__$1;
(statearr_62264_62294[(1)] = (13));

} else {
var statearr_62265_62295 = state_62256__$1;
(statearr_62265_62295[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (2))){
var inst_62211 = (state_62256[(9)]);
var _ = (function (){var statearr_62266 = state_62256;
(statearr_62266[(4)] = cljs.core.cons.call(null,(5),(state_62256[(4)])));

return statearr_62266;
})();
var inst_62211__$1 = jwt;
var state_62256__$1 = (function (){var statearr_62267 = state_62256;
(statearr_62267[(9)] = inst_62211__$1);

return statearr_62267;
})();
if(cljs.core.truth_(inst_62211__$1)){
var statearr_62268_62296 = state_62256__$1;
(statearr_62268_62296[(1)] = (6));

} else {
var statearr_62269_62297 = state_62256__$1;
(statearr_62269_62297[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (11))){
var inst_62229 = (state_62256[(10)]);
var state_62256__$1 = state_62256;
var statearr_62271_62298 = state_62256__$1;
(statearr_62271_62298[(2)] = inst_62229);

(statearr_62271_62298[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (9))){
var inst_62221 = (state_62256[(11)]);
var inst_62220 = (state_62256[(12)]);
var inst_62224 = (state_62256[(2)]);
var inst_62225 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62224),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62221)].join('');
var inst_62227 = ["Accept"];
var inst_62228 = ["application/json"];
var inst_62229 = cljs.core.PersistentHashMap.fromArrays(inst_62227,inst_62228);
var state_62256__$1 = (function (){var statearr_62272 = state_62256;
(statearr_62272[(10)] = inst_62229);

(statearr_62272[(7)] = inst_62225);

return statearr_62272;
})();
if(cljs.core.truth_(inst_62220)){
var statearr_62273_62299 = state_62256__$1;
(statearr_62273_62299[(1)] = (10));

} else {
var statearr_62274_62300 = state_62256__$1;
(statearr_62274_62300[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (5))){
var _ = (function (){var statearr_62275 = state_62256;
(statearr_62275[(4)] = cljs.core.rest.call(null,(state_62256[(4)])));

return statearr_62275;
})();
var state_62256__$1 = state_62256;
var ex62270 = (state_62256__$1[(2)]);
var statearr_62276_62301 = state_62256__$1;
(statearr_62276_62301[(5)] = ex62270);


if((ex62270 instanceof Error)){
var statearr_62277_62302 = state_62256__$1;
(statearr_62277_62302[(1)] = (4));

(statearr_62277_62302[(5)] = null);

} else {
throw ex62270;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (14))){
var inst_62235 = (state_62256[(8)]);
var state_62256__$1 = state_62256;
var statearr_62278_62303 = state_62256__$1;
(statearr_62278_62303[(2)] = inst_62235);

(statearr_62278_62303[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (16))){
var inst_62250 = (state_62256[(2)]);
var inst_62251 = fluree.db.util.async.throw_err.call(null,inst_62250);
var _ = (function (){var statearr_62279 = state_62256;
(statearr_62279[(4)] = cljs.core.rest.call(null,(state_62256[(4)])));

return statearr_62279;
})();
var state_62256__$1 = state_62256;
var statearr_62280_62304 = state_62256__$1;
(statearr_62280_62304[(2)] = inst_62251);

(statearr_62280_62304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (10))){
var inst_62220 = (state_62256[(12)]);
var inst_62229 = (state_62256[(10)]);
var inst_62231 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_62220)].join('');
var inst_62232 = cljs.core.assoc.call(null,inst_62229,"Authorization",inst_62231);
var state_62256__$1 = state_62256;
var statearr_62281_62305 = state_62256__$1;
(statearr_62281_62305[(2)] = inst_62232);

(statearr_62281_62305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62257 === (8))){
var inst_62220 = (state_62256[(2)]);
var inst_62221 = clojure.string.replace.call(null,k,"_","/");
var inst_62222 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_62256__$1 = (function (){var statearr_62282 = state_62256;
(statearr_62282[(11)] = inst_62221);

(statearr_62282[(12)] = inst_62220);

return statearr_62282;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62256__$1,(9),inst_62222);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62283 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62283[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62283[(1)] = (1));

return statearr_62283;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62256){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62256);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62284){var ex__2744__auto__ = e62284;
var statearr_62285_62306 = state_62256;
(statearr_62285_62306[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62256[(4)]))){
var statearr_62286_62307 = state_62256;
(statearr_62286_62307[(1)] = cljs.core.first.call(null,(state_62256[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62308 = state_62256;
state_62256 = G__62308;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62256){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62256);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62287 = f__2764__auto__.call(null);
(statearr_62287[(6)] = c__2763__auto__);

return statearr_62287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

return c__2763__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__62309_SHARP_){
if(cljs.core.truth_(p1__62309_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__62310_SHARP_){
var or__4253__auto__ = p1__62310_SHARP_;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return token;
}
}));

return true;
}catch (e62311){var e = e62311;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__62312 = opts;
var map__62312__$1 = cljs.core.__destructure_map.call(null,map__62312);
var sub_chan = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__62312__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4253__auto__ = object_cache;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache.call(null);
} else {
}

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4253__auto__ = storage_read;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4253__auto__ = storage_exists;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
var or__4253__auto____$1 = storage_read;
if(cljs.core.truth_(or__4253__auto____$1)){
return or__4253__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4251__auto__ = storage_write;
if(cljs.core.truth_(and__4251__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4870__auto__ = [];
var len__4864__auto___62353 = arguments.length;
var i__4865__auto___62354 = (0);
while(true){
if((i__4865__auto___62354 < len__4864__auto___62353)){
args__4870__auto__.push((arguments[i__4865__auto___62354]));

var G__62355 = (i__4865__auto___62354 + (1));
i__4865__auto___62354 = G__62355;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__62315){
var vec__62316 = p__62315;
var opts = cljs.core.nth.call(null,vec__62316,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2763__auto___62356 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_62336){
var state_val_62337 = (state_62336[(1)]);
if((state_val_62337 === (1))){
var inst_62319 = fluree.db.connection.get_socket.call(null,conn);
var state_62336__$1 = state_62336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_62336__$1,(2),inst_62319);
} else {
if((state_val_62337 === (2))){
var inst_62321 = (state_62336[(7)]);
var inst_62322 = (state_62336[(8)]);
var inst_62321__$1 = (state_62336[(2)]);
var inst_62322__$1 = (inst_62321__$1 == null);
var state_62336__$1 = (function (){var statearr_62338 = state_62336;
(statearr_62338[(7)] = inst_62321__$1);

(statearr_62338[(8)] = inst_62322__$1);

return statearr_62338;
})();
if(cljs.core.truth_(inst_62322__$1)){
var statearr_62339_62357 = state_62336__$1;
(statearr_62339_62357[(1)] = (3));

} else {
var statearr_62340_62358 = state_62336__$1;
(statearr_62340_62358[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (3))){
var inst_62322 = (state_62336[(8)]);
var state_62336__$1 = state_62336;
var statearr_62341_62359 = state_62336__$1;
(statearr_62341_62359[(2)] = inst_62322);

(statearr_62341_62359[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (4))){
var inst_62321 = (state_62336[(7)]);
var inst_62325 = fluree.db.util.core.exception_QMARK_.call(null,inst_62321);
var state_62336__$1 = state_62336;
var statearr_62342_62360 = state_62336__$1;
(statearr_62342_62360[(2)] = inst_62325);

(statearr_62342_62360[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (5))){
var inst_62327 = (state_62336[(2)]);
var state_62336__$1 = state_62336;
if(cljs.core.truth_(inst_62327)){
var statearr_62343_62361 = state_62336__$1;
(statearr_62343_62361[(1)] = (6));

} else {
var statearr_62344_62362 = state_62336__$1;
(statearr_62344_62362[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (6))){
var inst_62321 = (state_62336[(7)]);
var inst_62329 = fluree.db.util.log.error.call(null,inst_62321,"Cannot establish connection to a healthy server, disconnecting.");
var inst_62330 = cljs.core.async.close_BANG_.call(null,conn);
var state_62336__$1 = (function (){var statearr_62345 = state_62336;
(statearr_62345[(9)] = inst_62329);

return statearr_62345;
})();
var statearr_62346_62363 = state_62336__$1;
(statearr_62346_62363[(2)] = inst_62330);

(statearr_62346_62363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (7))){
var inst_62332 = fluree.db.connection.msg_consumer.call(null,conn);
var state_62336__$1 = state_62336;
var statearr_62347_62364 = state_62336__$1;
(statearr_62347_62364[(2)] = inst_62332);

(statearr_62347_62364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62337 === (8))){
var inst_62334 = (state_62336[(2)]);
var state_62336__$1 = state_62336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_62336__$1,inst_62334);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2741__auto__ = null;
var fluree$db$connection$state_machine__2741__auto____0 = (function (){
var statearr_62348 = [null,null,null,null,null,null,null,null,null,null];
(statearr_62348[(0)] = fluree$db$connection$state_machine__2741__auto__);

(statearr_62348[(1)] = (1));

return statearr_62348;
});
var fluree$db$connection$state_machine__2741__auto____1 = (function (state_62336){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__.call(null,state_62336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e62349){var ex__2744__auto__ = e62349;
var statearr_62350_62365 = state_62336;
(statearr_62350_62365[(2)] = ex__2744__auto__);


if(cljs.core.seq.call(null,(state_62336[(4)]))){
var statearr_62351_62366 = state_62336;
(statearr_62351_62366[(1)] = cljs.core.first.call(null,(state_62336[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62367 = state_62336;
state_62336 = G__62367;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2741__auto__ = function(state_62336){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2741__auto____1.call(this,state_62336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2741__auto____0;
fluree$db$connection$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2741__auto____1;
return fluree$db$connection$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_62352 = f__2764__auto__.call(null);
(statearr_62352[(6)] = c__2763__auto___62356);

return statearr_62352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2765__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq62313){
var G__62314 = cljs.core.first.call(null,seq62313);
var seq62313__$1 = cljs.core.next.call(null,seq62313);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__62314,seq62313__$1);
}));

