// Compiled by ClojureScript 1.10.891 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11036 = arguments.length;
switch (G__11036) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11037 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11037 = (function (f,blockable,meta11038){
this.f = f;
this.blockable = blockable;
this.meta11038 = meta11038;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11039,meta11038__$1){
var self__ = this;
var _11039__$1 = this;
return (new cljs.core.async.t_cljs$core$async11037(self__.f,self__.blockable,meta11038__$1));
}));

(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11039){
var self__ = this;
var _11039__$1 = this;
return self__.meta11038;
}));

(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11037.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11037.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11038","meta11038",282322275,null)], null);
}));

(cljs.core.async.t_cljs$core$async11037.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11037.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11037");

(cljs.core.async.t_cljs$core$async11037.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11037");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11037.
 */
cljs.core.async.__GT_t_cljs$core$async11037 = (function cljs$core$async$__GT_t_cljs$core$async11037(f__$1,blockable__$1,meta11038){
return (new cljs.core.async.t_cljs$core$async11037(f__$1,blockable__$1,meta11038));
});

}

return (new cljs.core.async.t_cljs$core$async11037(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11043 = arguments.length;
switch (G__11043) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11046 = arguments.length;
switch (G__11046) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11049 = arguments.length;
switch (G__11049) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11051 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11051);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_11051);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11053 = arguments.length;
switch (G__11053) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4741__auto___11055 = n;
var x_11056 = (0);
while(true){
if((x_11056 < n__4741__auto___11055)){
(a[x_11056] = x_11056);

var G__11057 = (x_11056 + (1));
x_11056 = G__11057;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11058 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11058 = (function (flag,meta11059){
this.flag = flag;
this.meta11059 = meta11059;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11060,meta11059__$1){
var self__ = this;
var _11060__$1 = this;
return (new cljs.core.async.t_cljs$core$async11058(self__.flag,meta11059__$1));
}));

(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11060){
var self__ = this;
var _11060__$1 = this;
return self__.meta11059;
}));

(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11058.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11058.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11059","meta11059",-1354530946,null)], null);
}));

(cljs.core.async.t_cljs$core$async11058.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11058.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11058");

(cljs.core.async.t_cljs$core$async11058.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11058");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11058.
 */
cljs.core.async.__GT_t_cljs$core$async11058 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11058(flag__$1,meta11059){
return (new cljs.core.async.t_cljs$core$async11058(flag__$1,meta11059));
});

}

return (new cljs.core.async.t_cljs$core$async11058(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11061 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11061 = (function (flag,cb,meta11062){
this.flag = flag;
this.cb = cb;
this.meta11062 = meta11062;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11063,meta11062__$1){
var self__ = this;
var _11063__$1 = this;
return (new cljs.core.async.t_cljs$core$async11061(self__.flag,self__.cb,meta11062__$1));
}));

(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11063){
var self__ = this;
var _11063__$1 = this;
return self__.meta11062;
}));

(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11061.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11061.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11062","meta11062",-764150062,null)], null);
}));

(cljs.core.async.t_cljs$core$async11061.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11061.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11061");

(cljs.core.async.t_cljs$core$async11061.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11061");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11061.
 */
cljs.core.async.__GT_t_cljs$core$async11061 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11061(flag__$1,cb__$1,meta11062){
return (new cljs.core.async.t_cljs$core$async11061(flag__$1,cb__$1,meta11062));
});

}

return (new cljs.core.async.t_cljs$core$async11061(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11064_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11064_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11065_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11065_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4253__auto__ = wport;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11066 = (i + (1));
i = G__11066;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4253__auto__ = ret;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5753__auto__ = (function (){var and__4251__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4251__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11071 = arguments.length;
var i__4865__auto___11072 = (0);
while(true){
if((i__4865__auto___11072 < len__4864__auto___11071)){
args__4870__auto__.push((arguments[i__4865__auto___11072]));

var G__11073 = (i__4865__auto___11072 + (1));
i__4865__auto___11072 = G__11073;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11069){
var map__11070 = p__11069;
var map__11070__$1 = cljs.core.__destructure_map.call(null,map__11070);
var opts = map__11070__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11067){
var G__11068 = cljs.core.first.call(null,seq11067);
var seq11067__$1 = cljs.core.next.call(null,seq11067);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11068,seq11067__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11075 = arguments.length;
switch (G__11075) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__10976__auto___11122 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11099){
var state_val_11100 = (state_11099[(1)]);
if((state_val_11100 === (7))){
var inst_11095 = (state_11099[(2)]);
var state_11099__$1 = state_11099;
var statearr_11101_11123 = state_11099__$1;
(statearr_11101_11123[(2)] = inst_11095);

(statearr_11101_11123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (1))){
var state_11099__$1 = state_11099;
var statearr_11102_11124 = state_11099__$1;
(statearr_11102_11124[(2)] = null);

(statearr_11102_11124[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (4))){
var inst_11078 = (state_11099[(7)]);
var inst_11078__$1 = (state_11099[(2)]);
var inst_11079 = (inst_11078__$1 == null);
var state_11099__$1 = (function (){var statearr_11103 = state_11099;
(statearr_11103[(7)] = inst_11078__$1);

return statearr_11103;
})();
if(cljs.core.truth_(inst_11079)){
var statearr_11104_11125 = state_11099__$1;
(statearr_11104_11125[(1)] = (5));

} else {
var statearr_11105_11126 = state_11099__$1;
(statearr_11105_11126[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (13))){
var state_11099__$1 = state_11099;
var statearr_11106_11127 = state_11099__$1;
(statearr_11106_11127[(2)] = null);

(statearr_11106_11127[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (6))){
var inst_11078 = (state_11099[(7)]);
var state_11099__$1 = state_11099;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11099__$1,(11),to,inst_11078);
} else {
if((state_val_11100 === (3))){
var inst_11097 = (state_11099[(2)]);
var state_11099__$1 = state_11099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11099__$1,inst_11097);
} else {
if((state_val_11100 === (12))){
var state_11099__$1 = state_11099;
var statearr_11107_11128 = state_11099__$1;
(statearr_11107_11128[(2)] = null);

(statearr_11107_11128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (2))){
var state_11099__$1 = state_11099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11099__$1,(4),from);
} else {
if((state_val_11100 === (11))){
var inst_11088 = (state_11099[(2)]);
var state_11099__$1 = state_11099;
if(cljs.core.truth_(inst_11088)){
var statearr_11108_11129 = state_11099__$1;
(statearr_11108_11129[(1)] = (12));

} else {
var statearr_11109_11130 = state_11099__$1;
(statearr_11109_11130[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (9))){
var state_11099__$1 = state_11099;
var statearr_11110_11131 = state_11099__$1;
(statearr_11110_11131[(2)] = null);

(statearr_11110_11131[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (5))){
var state_11099__$1 = state_11099;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11111_11132 = state_11099__$1;
(statearr_11111_11132[(1)] = (8));

} else {
var statearr_11112_11133 = state_11099__$1;
(statearr_11112_11133[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (14))){
var inst_11093 = (state_11099[(2)]);
var state_11099__$1 = state_11099;
var statearr_11113_11134 = state_11099__$1;
(statearr_11113_11134[(2)] = inst_11093);

(statearr_11113_11134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (10))){
var inst_11085 = (state_11099[(2)]);
var state_11099__$1 = state_11099;
var statearr_11114_11135 = state_11099__$1;
(statearr_11114_11135[(2)] = inst_11085);

(statearr_11114_11135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11100 === (8))){
var inst_11082 = cljs.core.async.close_BANG_.call(null,to);
var state_11099__$1 = state_11099;
var statearr_11115_11136 = state_11099__$1;
(statearr_11115_11136[(2)] = inst_11082);

(statearr_11115_11136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_11116 = [null,null,null,null,null,null,null,null];
(statearr_11116[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_11116[(1)] = (1));

return statearr_11116;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_11099){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11117){var ex__10906__auto__ = e11117;
var statearr_11118_11137 = state_11099;
(statearr_11118_11137[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11099[(4)]))){
var statearr_11119_11138 = state_11099;
(statearr_11119_11138[(1)] = cljs.core.first.call(null,(state_11099[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11139 = state_11099;
state_11099 = G__11139;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_11099){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_11099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11120 = f__10977__auto__.call(null);
(statearr_11120[(6)] = c__10976__auto___11122);

return statearr_11120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__11140){
var vec__11141 = p__11140;
var v = cljs.core.nth.call(null,vec__11141,(0),null);
var p = cljs.core.nth.call(null,vec__11141,(1),null);
var job = vec__11141;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__10976__auto___11317 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11148){
var state_val_11149 = (state_11148[(1)]);
if((state_val_11149 === (1))){
var state_11148__$1 = state_11148;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11148__$1,(2),res,v);
} else {
if((state_val_11149 === (2))){
var inst_11145 = (state_11148[(2)]);
var inst_11146 = cljs.core.async.close_BANG_.call(null,res);
var state_11148__$1 = (function (){var statearr_11150 = state_11148;
(statearr_11150[(7)] = inst_11145);

return statearr_11150;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11148__$1,inst_11146);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_11151 = [null,null,null,null,null,null,null,null];
(statearr_11151[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__);

(statearr_11151[(1)] = (1));

return statearr_11151;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1 = (function (state_11148){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11152){var ex__10906__auto__ = e11152;
var statearr_11153_11318 = state_11148;
(statearr_11153_11318[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11148[(4)]))){
var statearr_11154_11319 = state_11148;
(statearr_11154_11319[(1)] = cljs.core.first.call(null,(state_11148[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11320 = state_11148;
state_11148 = G__11320;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = function(state_11148){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1.call(this,state_11148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11155 = f__10977__auto__.call(null);
(statearr_11155[(6)] = c__10976__auto___11317);

return statearr_11155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11156){
var vec__11157 = p__11156;
var v = cljs.core.nth.call(null,vec__11157,(0),null);
var p = cljs.core.nth.call(null,vec__11157,(1),null);
var job = vec__11157;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4741__auto___11321 = n;
var __11322 = (0);
while(true){
if((__11322 < n__4741__auto___11321)){
var G__11160_11323 = type;
var G__11160_11324__$1 = (((G__11160_11323 instanceof cljs.core.Keyword))?G__11160_11323.fqn:null);
switch (G__11160_11324__$1) {
case "compute":
var c__10976__auto___11326 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11322,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = ((function (__11322,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function (state_11173){
var state_val_11174 = (state_11173[(1)]);
if((state_val_11174 === (1))){
var state_11173__$1 = state_11173;
var statearr_11175_11327 = state_11173__$1;
(statearr_11175_11327[(2)] = null);

(statearr_11175_11327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11174 === (2))){
var state_11173__$1 = state_11173;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11173__$1,(4),jobs);
} else {
if((state_val_11174 === (3))){
var inst_11171 = (state_11173[(2)]);
var state_11173__$1 = state_11173;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11173__$1,inst_11171);
} else {
if((state_val_11174 === (4))){
var inst_11163 = (state_11173[(2)]);
var inst_11164 = process.call(null,inst_11163);
var state_11173__$1 = state_11173;
if(cljs.core.truth_(inst_11164)){
var statearr_11176_11328 = state_11173__$1;
(statearr_11176_11328[(1)] = (5));

} else {
var statearr_11177_11329 = state_11173__$1;
(statearr_11177_11329[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11174 === (5))){
var state_11173__$1 = state_11173;
var statearr_11178_11330 = state_11173__$1;
(statearr_11178_11330[(2)] = null);

(statearr_11178_11330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11174 === (6))){
var state_11173__$1 = state_11173;
var statearr_11179_11331 = state_11173__$1;
(statearr_11179_11331[(2)] = null);

(statearr_11179_11331[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11174 === (7))){
var inst_11169 = (state_11173[(2)]);
var state_11173__$1 = state_11173;
var statearr_11180_11332 = state_11173__$1;
(statearr_11180_11332[(2)] = inst_11169);

(statearr_11180_11332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11322,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
;
return ((function (__11322,switch__10902__auto__,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_11181 = [null,null,null,null,null,null,null];
(statearr_11181[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__);

(statearr_11181[(1)] = (1));

return statearr_11181;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1 = (function (state_11173){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11173);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11182){var ex__10906__auto__ = e11182;
var statearr_11183_11333 = state_11173;
(statearr_11183_11333[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11173[(4)]))){
var statearr_11184_11334 = state_11173;
(statearr_11184_11334[(1)] = cljs.core.first.call(null,(state_11173[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11335 = state_11173;
state_11173 = G__11335;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = function(state_11173){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1.call(this,state_11173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__;
})()
;})(__11322,switch__10902__auto__,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
})();
var state__10978__auto__ = (function (){var statearr_11185 = f__10977__auto__.call(null);
(statearr_11185[(6)] = c__10976__auto___11326);

return statearr_11185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});})(__11322,c__10976__auto___11326,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
);


break;
case "async":
var c__10976__auto___11336 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11322,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = ((function (__11322,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function (state_11198){
var state_val_11199 = (state_11198[(1)]);
if((state_val_11199 === (1))){
var state_11198__$1 = state_11198;
var statearr_11200_11337 = state_11198__$1;
(statearr_11200_11337[(2)] = null);

(statearr_11200_11337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11199 === (2))){
var state_11198__$1 = state_11198;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11198__$1,(4),jobs);
} else {
if((state_val_11199 === (3))){
var inst_11196 = (state_11198[(2)]);
var state_11198__$1 = state_11198;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11198__$1,inst_11196);
} else {
if((state_val_11199 === (4))){
var inst_11188 = (state_11198[(2)]);
var inst_11189 = async.call(null,inst_11188);
var state_11198__$1 = state_11198;
if(cljs.core.truth_(inst_11189)){
var statearr_11201_11338 = state_11198__$1;
(statearr_11201_11338[(1)] = (5));

} else {
var statearr_11202_11339 = state_11198__$1;
(statearr_11202_11339[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11199 === (5))){
var state_11198__$1 = state_11198;
var statearr_11203_11340 = state_11198__$1;
(statearr_11203_11340[(2)] = null);

(statearr_11203_11340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11199 === (6))){
var state_11198__$1 = state_11198;
var statearr_11204_11341 = state_11198__$1;
(statearr_11204_11341[(2)] = null);

(statearr_11204_11341[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11199 === (7))){
var inst_11194 = (state_11198[(2)]);
var state_11198__$1 = state_11198;
var statearr_11205_11342 = state_11198__$1;
(statearr_11205_11342[(2)] = inst_11194);

(statearr_11205_11342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11322,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
;
return ((function (__11322,switch__10902__auto__,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_11206 = [null,null,null,null,null,null,null];
(statearr_11206[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__);

(statearr_11206[(1)] = (1));

return statearr_11206;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1 = (function (state_11198){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11198);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11207){var ex__10906__auto__ = e11207;
var statearr_11208_11343 = state_11198;
(statearr_11208_11343[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11198[(4)]))){
var statearr_11209_11344 = state_11198;
(statearr_11209_11344[(1)] = cljs.core.first.call(null,(state_11198[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11345 = state_11198;
state_11198 = G__11345;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = function(state_11198){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1.call(this,state_11198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__;
})()
;})(__11322,switch__10902__auto__,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
})();
var state__10978__auto__ = (function (){var statearr_11210 = f__10977__auto__.call(null);
(statearr_11210[(6)] = c__10976__auto___11336);

return statearr_11210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
});})(__11322,c__10976__auto___11336,G__11160_11323,G__11160_11324__$1,n__4741__auto___11321,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11160_11324__$1)].join('')));

}

var G__11346 = (__11322 + (1));
__11322 = G__11346;
continue;
} else {
}
break;
}

var c__10976__auto___11347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11232){
var state_val_11233 = (state_11232[(1)]);
if((state_val_11233 === (7))){
var inst_11228 = (state_11232[(2)]);
var state_11232__$1 = state_11232;
var statearr_11234_11348 = state_11232__$1;
(statearr_11234_11348[(2)] = inst_11228);

(statearr_11234_11348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11233 === (1))){
var state_11232__$1 = state_11232;
var statearr_11235_11349 = state_11232__$1;
(statearr_11235_11349[(2)] = null);

(statearr_11235_11349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11233 === (4))){
var inst_11213 = (state_11232[(7)]);
var inst_11213__$1 = (state_11232[(2)]);
var inst_11214 = (inst_11213__$1 == null);
var state_11232__$1 = (function (){var statearr_11236 = state_11232;
(statearr_11236[(7)] = inst_11213__$1);

return statearr_11236;
})();
if(cljs.core.truth_(inst_11214)){
var statearr_11237_11350 = state_11232__$1;
(statearr_11237_11350[(1)] = (5));

} else {
var statearr_11238_11351 = state_11232__$1;
(statearr_11238_11351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11233 === (6))){
var inst_11213 = (state_11232[(7)]);
var inst_11218 = (state_11232[(8)]);
var inst_11218__$1 = cljs.core.async.chan.call(null,(1));
var inst_11219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11220 = [inst_11213,inst_11218__$1];
var inst_11221 = (new cljs.core.PersistentVector(null,2,(5),inst_11219,inst_11220,null));
var state_11232__$1 = (function (){var statearr_11239 = state_11232;
(statearr_11239[(8)] = inst_11218__$1);

return statearr_11239;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11232__$1,(8),jobs,inst_11221);
} else {
if((state_val_11233 === (3))){
var inst_11230 = (state_11232[(2)]);
var state_11232__$1 = state_11232;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11232__$1,inst_11230);
} else {
if((state_val_11233 === (2))){
var state_11232__$1 = state_11232;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11232__$1,(4),from);
} else {
if((state_val_11233 === (9))){
var inst_11225 = (state_11232[(2)]);
var state_11232__$1 = (function (){var statearr_11240 = state_11232;
(statearr_11240[(9)] = inst_11225);

return statearr_11240;
})();
var statearr_11241_11352 = state_11232__$1;
(statearr_11241_11352[(2)] = null);

(statearr_11241_11352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11233 === (5))){
var inst_11216 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11232__$1 = state_11232;
var statearr_11242_11353 = state_11232__$1;
(statearr_11242_11353[(2)] = inst_11216);

(statearr_11242_11353[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11233 === (8))){
var inst_11218 = (state_11232[(8)]);
var inst_11223 = (state_11232[(2)]);
var state_11232__$1 = (function (){var statearr_11243 = state_11232;
(statearr_11243[(10)] = inst_11223);

return statearr_11243;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11232__$1,(9),results,inst_11218);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_11244 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11244[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__);

(statearr_11244[(1)] = (1));

return statearr_11244;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1 = (function (state_11232){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11232);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11245){var ex__10906__auto__ = e11245;
var statearr_11246_11354 = state_11232;
(statearr_11246_11354[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11232[(4)]))){
var statearr_11247_11355 = state_11232;
(statearr_11247_11355[(1)] = cljs.core.first.call(null,(state_11232[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11356 = state_11232;
state_11232 = G__11356;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = function(state_11232){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1.call(this,state_11232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11248 = f__10977__auto__.call(null);
(statearr_11248[(6)] = c__10976__auto___11347);

return statearr_11248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11286){
var state_val_11287 = (state_11286[(1)]);
if((state_val_11287 === (7))){
var inst_11282 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
var statearr_11288_11357 = state_11286__$1;
(statearr_11288_11357[(2)] = inst_11282);

(statearr_11288_11357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (20))){
var state_11286__$1 = state_11286;
var statearr_11289_11358 = state_11286__$1;
(statearr_11289_11358[(2)] = null);

(statearr_11289_11358[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (1))){
var state_11286__$1 = state_11286;
var statearr_11290_11359 = state_11286__$1;
(statearr_11290_11359[(2)] = null);

(statearr_11290_11359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (4))){
var inst_11251 = (state_11286[(7)]);
var inst_11251__$1 = (state_11286[(2)]);
var inst_11252 = (inst_11251__$1 == null);
var state_11286__$1 = (function (){var statearr_11291 = state_11286;
(statearr_11291[(7)] = inst_11251__$1);

return statearr_11291;
})();
if(cljs.core.truth_(inst_11252)){
var statearr_11292_11360 = state_11286__$1;
(statearr_11292_11360[(1)] = (5));

} else {
var statearr_11293_11361 = state_11286__$1;
(statearr_11293_11361[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (15))){
var inst_11264 = (state_11286[(8)]);
var state_11286__$1 = state_11286;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11286__$1,(18),to,inst_11264);
} else {
if((state_val_11287 === (21))){
var inst_11277 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
var statearr_11294_11362 = state_11286__$1;
(statearr_11294_11362[(2)] = inst_11277);

(statearr_11294_11362[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (13))){
var inst_11279 = (state_11286[(2)]);
var state_11286__$1 = (function (){var statearr_11295 = state_11286;
(statearr_11295[(9)] = inst_11279);

return statearr_11295;
})();
var statearr_11296_11363 = state_11286__$1;
(statearr_11296_11363[(2)] = null);

(statearr_11296_11363[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (6))){
var inst_11251 = (state_11286[(7)]);
var state_11286__$1 = state_11286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11286__$1,(11),inst_11251);
} else {
if((state_val_11287 === (17))){
var inst_11272 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
if(cljs.core.truth_(inst_11272)){
var statearr_11297_11364 = state_11286__$1;
(statearr_11297_11364[(1)] = (19));

} else {
var statearr_11298_11365 = state_11286__$1;
(statearr_11298_11365[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (3))){
var inst_11284 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11286__$1,inst_11284);
} else {
if((state_val_11287 === (12))){
var inst_11261 = (state_11286[(10)]);
var state_11286__$1 = state_11286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11286__$1,(14),inst_11261);
} else {
if((state_val_11287 === (2))){
var state_11286__$1 = state_11286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11286__$1,(4),results);
} else {
if((state_val_11287 === (19))){
var state_11286__$1 = state_11286;
var statearr_11299_11366 = state_11286__$1;
(statearr_11299_11366[(2)] = null);

(statearr_11299_11366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (11))){
var inst_11261 = (state_11286[(2)]);
var state_11286__$1 = (function (){var statearr_11300 = state_11286;
(statearr_11300[(10)] = inst_11261);

return statearr_11300;
})();
var statearr_11301_11367 = state_11286__$1;
(statearr_11301_11367[(2)] = null);

(statearr_11301_11367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (9))){
var state_11286__$1 = state_11286;
var statearr_11302_11368 = state_11286__$1;
(statearr_11302_11368[(2)] = null);

(statearr_11302_11368[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (5))){
var state_11286__$1 = state_11286;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11303_11369 = state_11286__$1;
(statearr_11303_11369[(1)] = (8));

} else {
var statearr_11304_11370 = state_11286__$1;
(statearr_11304_11370[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (14))){
var inst_11266 = (state_11286[(11)]);
var inst_11264 = (state_11286[(8)]);
var inst_11264__$1 = (state_11286[(2)]);
var inst_11265 = (inst_11264__$1 == null);
var inst_11266__$1 = cljs.core.not.call(null,inst_11265);
var state_11286__$1 = (function (){var statearr_11305 = state_11286;
(statearr_11305[(11)] = inst_11266__$1);

(statearr_11305[(8)] = inst_11264__$1);

return statearr_11305;
})();
if(inst_11266__$1){
var statearr_11306_11371 = state_11286__$1;
(statearr_11306_11371[(1)] = (15));

} else {
var statearr_11307_11372 = state_11286__$1;
(statearr_11307_11372[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (16))){
var inst_11266 = (state_11286[(11)]);
var state_11286__$1 = state_11286;
var statearr_11308_11373 = state_11286__$1;
(statearr_11308_11373[(2)] = inst_11266);

(statearr_11308_11373[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (10))){
var inst_11258 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
var statearr_11309_11374 = state_11286__$1;
(statearr_11309_11374[(2)] = inst_11258);

(statearr_11309_11374[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (18))){
var inst_11269 = (state_11286[(2)]);
var state_11286__$1 = state_11286;
var statearr_11310_11375 = state_11286__$1;
(statearr_11310_11375[(2)] = inst_11269);

(statearr_11310_11375[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11287 === (8))){
var inst_11255 = cljs.core.async.close_BANG_.call(null,to);
var state_11286__$1 = state_11286;
var statearr_11311_11376 = state_11286__$1;
(statearr_11311_11376[(2)] = inst_11255);

(statearr_11311_11376[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_11312 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11312[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__);

(statearr_11312[(1)] = (1));

return statearr_11312;
});
var cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1 = (function (state_11286){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11313){var ex__10906__auto__ = e11313;
var statearr_11314_11377 = state_11286;
(statearr_11314_11377[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11286[(4)]))){
var statearr_11315_11378 = state_11286;
(statearr_11315_11378[(1)] = cljs.core.first.call(null,(state_11286[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11379 = state_11286;
state_11286 = G__11379;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__ = function(state_11286){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1.call(this,state_11286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11316 = f__10977__auto__.call(null);
(statearr_11316[(6)] = c__10976__auto__);

return statearr_11316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11381 = arguments.length;
switch (G__11381) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11384 = arguments.length;
switch (G__11384) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11387 = arguments.length;
switch (G__11387) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__10976__auto___11437 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11413){
var state_val_11414 = (state_11413[(1)]);
if((state_val_11414 === (7))){
var inst_11409 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
var statearr_11415_11438 = state_11413__$1;
(statearr_11415_11438[(2)] = inst_11409);

(statearr_11415_11438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (1))){
var state_11413__$1 = state_11413;
var statearr_11416_11439 = state_11413__$1;
(statearr_11416_11439[(2)] = null);

(statearr_11416_11439[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (4))){
var inst_11390 = (state_11413[(7)]);
var inst_11390__$1 = (state_11413[(2)]);
var inst_11391 = (inst_11390__$1 == null);
var state_11413__$1 = (function (){var statearr_11417 = state_11413;
(statearr_11417[(7)] = inst_11390__$1);

return statearr_11417;
})();
if(cljs.core.truth_(inst_11391)){
var statearr_11418_11440 = state_11413__$1;
(statearr_11418_11440[(1)] = (5));

} else {
var statearr_11419_11441 = state_11413__$1;
(statearr_11419_11441[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (13))){
var state_11413__$1 = state_11413;
var statearr_11420_11442 = state_11413__$1;
(statearr_11420_11442[(2)] = null);

(statearr_11420_11442[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (6))){
var inst_11390 = (state_11413[(7)]);
var inst_11396 = p.call(null,inst_11390);
var state_11413__$1 = state_11413;
if(cljs.core.truth_(inst_11396)){
var statearr_11421_11443 = state_11413__$1;
(statearr_11421_11443[(1)] = (9));

} else {
var statearr_11422_11444 = state_11413__$1;
(statearr_11422_11444[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (3))){
var inst_11411 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11413__$1,inst_11411);
} else {
if((state_val_11414 === (12))){
var state_11413__$1 = state_11413;
var statearr_11423_11445 = state_11413__$1;
(statearr_11423_11445[(2)] = null);

(statearr_11423_11445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (2))){
var state_11413__$1 = state_11413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11413__$1,(4),ch);
} else {
if((state_val_11414 === (11))){
var inst_11390 = (state_11413[(7)]);
var inst_11400 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11413__$1,(8),inst_11400,inst_11390);
} else {
if((state_val_11414 === (9))){
var state_11413__$1 = state_11413;
var statearr_11424_11446 = state_11413__$1;
(statearr_11424_11446[(2)] = tc);

(statearr_11424_11446[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (5))){
var inst_11393 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11394 = cljs.core.async.close_BANG_.call(null,fc);
var state_11413__$1 = (function (){var statearr_11425 = state_11413;
(statearr_11425[(8)] = inst_11393);

return statearr_11425;
})();
var statearr_11426_11447 = state_11413__$1;
(statearr_11426_11447[(2)] = inst_11394);

(statearr_11426_11447[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (14))){
var inst_11407 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
var statearr_11427_11448 = state_11413__$1;
(statearr_11427_11448[(2)] = inst_11407);

(statearr_11427_11448[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (10))){
var state_11413__$1 = state_11413;
var statearr_11428_11449 = state_11413__$1;
(statearr_11428_11449[(2)] = fc);

(statearr_11428_11449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11414 === (8))){
var inst_11402 = (state_11413[(2)]);
var state_11413__$1 = state_11413;
if(cljs.core.truth_(inst_11402)){
var statearr_11429_11450 = state_11413__$1;
(statearr_11429_11450[(1)] = (12));

} else {
var statearr_11430_11451 = state_11413__$1;
(statearr_11430_11451[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_11431 = [null,null,null,null,null,null,null,null,null];
(statearr_11431[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_11431[(1)] = (1));

return statearr_11431;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_11413){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11432){var ex__10906__auto__ = e11432;
var statearr_11433_11452 = state_11413;
(statearr_11433_11452[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11413[(4)]))){
var statearr_11434_11453 = state_11413;
(statearr_11434_11453[(1)] = cljs.core.first.call(null,(state_11413[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11454 = state_11413;
state_11413 = G__11454;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_11413){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_11413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11435 = f__10977__auto__.call(null);
(statearr_11435[(6)] = c__10976__auto___11437);

return statearr_11435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11476){
var state_val_11477 = (state_11476[(1)]);
if((state_val_11477 === (7))){
var inst_11472 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
var statearr_11478_11497 = state_11476__$1;
(statearr_11478_11497[(2)] = inst_11472);

(statearr_11478_11497[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (1))){
var inst_11455 = init;
var inst_11456 = inst_11455;
var state_11476__$1 = (function (){var statearr_11479 = state_11476;
(statearr_11479[(7)] = inst_11456);

return statearr_11479;
})();
var statearr_11480_11498 = state_11476__$1;
(statearr_11480_11498[(2)] = null);

(statearr_11480_11498[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (4))){
var inst_11459 = (state_11476[(8)]);
var inst_11459__$1 = (state_11476[(2)]);
var inst_11460 = (inst_11459__$1 == null);
var state_11476__$1 = (function (){var statearr_11481 = state_11476;
(statearr_11481[(8)] = inst_11459__$1);

return statearr_11481;
})();
if(cljs.core.truth_(inst_11460)){
var statearr_11482_11499 = state_11476__$1;
(statearr_11482_11499[(1)] = (5));

} else {
var statearr_11483_11500 = state_11476__$1;
(statearr_11483_11500[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (6))){
var inst_11459 = (state_11476[(8)]);
var inst_11456 = (state_11476[(7)]);
var inst_11463 = (state_11476[(9)]);
var inst_11463__$1 = f.call(null,inst_11456,inst_11459);
var inst_11464 = cljs.core.reduced_QMARK_.call(null,inst_11463__$1);
var state_11476__$1 = (function (){var statearr_11484 = state_11476;
(statearr_11484[(9)] = inst_11463__$1);

return statearr_11484;
})();
if(inst_11464){
var statearr_11485_11501 = state_11476__$1;
(statearr_11485_11501[(1)] = (8));

} else {
var statearr_11486_11502 = state_11476__$1;
(statearr_11486_11502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (3))){
var inst_11474 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11476__$1,inst_11474);
} else {
if((state_val_11477 === (2))){
var state_11476__$1 = state_11476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11476__$1,(4),ch);
} else {
if((state_val_11477 === (9))){
var inst_11463 = (state_11476[(9)]);
var inst_11456 = inst_11463;
var state_11476__$1 = (function (){var statearr_11487 = state_11476;
(statearr_11487[(7)] = inst_11456);

return statearr_11487;
})();
var statearr_11488_11503 = state_11476__$1;
(statearr_11488_11503[(2)] = null);

(statearr_11488_11503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (5))){
var inst_11456 = (state_11476[(7)]);
var state_11476__$1 = state_11476;
var statearr_11489_11504 = state_11476__$1;
(statearr_11489_11504[(2)] = inst_11456);

(statearr_11489_11504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (10))){
var inst_11470 = (state_11476[(2)]);
var state_11476__$1 = state_11476;
var statearr_11490_11505 = state_11476__$1;
(statearr_11490_11505[(2)] = inst_11470);

(statearr_11490_11505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11477 === (8))){
var inst_11463 = (state_11476[(9)]);
var inst_11466 = cljs.core.deref.call(null,inst_11463);
var state_11476__$1 = state_11476;
var statearr_11491_11506 = state_11476__$1;
(statearr_11491_11506[(2)] = inst_11466);

(statearr_11491_11506[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__10903__auto__ = null;
var cljs$core$async$reduce_$_state_machine__10903__auto____0 = (function (){
var statearr_11492 = [null,null,null,null,null,null,null,null,null,null];
(statearr_11492[(0)] = cljs$core$async$reduce_$_state_machine__10903__auto__);

(statearr_11492[(1)] = (1));

return statearr_11492;
});
var cljs$core$async$reduce_$_state_machine__10903__auto____1 = (function (state_11476){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11493){var ex__10906__auto__ = e11493;
var statearr_11494_11507 = state_11476;
(statearr_11494_11507[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11476[(4)]))){
var statearr_11495_11508 = state_11476;
(statearr_11495_11508[(1)] = cljs.core.first.call(null,(state_11476[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11509 = state_11476;
state_11476 = G__11509;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__10903__auto__ = function(state_11476){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__10903__auto____1.call(this,state_11476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__10903__auto____0;
cljs$core$async$reduce_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__10903__auto____1;
return cljs$core$async$reduce_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11496 = f__10977__auto__.call(null);
(statearr_11496[(6)] = c__10976__auto__);

return statearr_11496;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11515){
var state_val_11516 = (state_11515[(1)]);
if((state_val_11516 === (1))){
var inst_11510 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_11515__$1 = state_11515;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11515__$1,(2),inst_11510);
} else {
if((state_val_11516 === (2))){
var inst_11512 = (state_11515[(2)]);
var inst_11513 = f__$1.call(null,inst_11512);
var state_11515__$1 = state_11515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11515__$1,inst_11513);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__10903__auto__ = null;
var cljs$core$async$transduce_$_state_machine__10903__auto____0 = (function (){
var statearr_11517 = [null,null,null,null,null,null,null];
(statearr_11517[(0)] = cljs$core$async$transduce_$_state_machine__10903__auto__);

(statearr_11517[(1)] = (1));

return statearr_11517;
});
var cljs$core$async$transduce_$_state_machine__10903__auto____1 = (function (state_11515){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11518){var ex__10906__auto__ = e11518;
var statearr_11519_11522 = state_11515;
(statearr_11519_11522[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11515[(4)]))){
var statearr_11520_11523 = state_11515;
(statearr_11520_11523[(1)] = cljs.core.first.call(null,(state_11515[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11524 = state_11515;
state_11515 = G__11524;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__10903__auto__ = function(state_11515){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__10903__auto____1.call(this,state_11515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__10903__auto____0;
cljs$core$async$transduce_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__10903__auto____1;
return cljs$core$async$transduce_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11521 = f__10977__auto__.call(null);
(statearr_11521[(6)] = c__10976__auto__);

return statearr_11521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__11526 = arguments.length;
switch (G__11526) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11551){
var state_val_11552 = (state_11551[(1)]);
if((state_val_11552 === (7))){
var inst_11533 = (state_11551[(2)]);
var state_11551__$1 = state_11551;
var statearr_11553_11575 = state_11551__$1;
(statearr_11553_11575[(2)] = inst_11533);

(statearr_11553_11575[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (1))){
var inst_11527 = cljs.core.seq.call(null,coll);
var inst_11528 = inst_11527;
var state_11551__$1 = (function (){var statearr_11554 = state_11551;
(statearr_11554[(7)] = inst_11528);

return statearr_11554;
})();
var statearr_11555_11576 = state_11551__$1;
(statearr_11555_11576[(2)] = null);

(statearr_11555_11576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (4))){
var inst_11528 = (state_11551[(7)]);
var inst_11531 = cljs.core.first.call(null,inst_11528);
var state_11551__$1 = state_11551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11551__$1,(7),ch,inst_11531);
} else {
if((state_val_11552 === (13))){
var inst_11545 = (state_11551[(2)]);
var state_11551__$1 = state_11551;
var statearr_11556_11577 = state_11551__$1;
(statearr_11556_11577[(2)] = inst_11545);

(statearr_11556_11577[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (6))){
var inst_11536 = (state_11551[(2)]);
var state_11551__$1 = state_11551;
if(cljs.core.truth_(inst_11536)){
var statearr_11557_11578 = state_11551__$1;
(statearr_11557_11578[(1)] = (8));

} else {
var statearr_11558_11579 = state_11551__$1;
(statearr_11558_11579[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (3))){
var inst_11549 = (state_11551[(2)]);
var state_11551__$1 = state_11551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11551__$1,inst_11549);
} else {
if((state_val_11552 === (12))){
var state_11551__$1 = state_11551;
var statearr_11559_11580 = state_11551__$1;
(statearr_11559_11580[(2)] = null);

(statearr_11559_11580[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (2))){
var inst_11528 = (state_11551[(7)]);
var state_11551__$1 = state_11551;
if(cljs.core.truth_(inst_11528)){
var statearr_11560_11581 = state_11551__$1;
(statearr_11560_11581[(1)] = (4));

} else {
var statearr_11561_11582 = state_11551__$1;
(statearr_11561_11582[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (11))){
var inst_11542 = cljs.core.async.close_BANG_.call(null,ch);
var state_11551__$1 = state_11551;
var statearr_11562_11583 = state_11551__$1;
(statearr_11562_11583[(2)] = inst_11542);

(statearr_11562_11583[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (9))){
var state_11551__$1 = state_11551;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11563_11584 = state_11551__$1;
(statearr_11563_11584[(1)] = (11));

} else {
var statearr_11564_11585 = state_11551__$1;
(statearr_11564_11585[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (5))){
var inst_11528 = (state_11551[(7)]);
var state_11551__$1 = state_11551;
var statearr_11565_11586 = state_11551__$1;
(statearr_11565_11586[(2)] = inst_11528);

(statearr_11565_11586[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (10))){
var inst_11547 = (state_11551[(2)]);
var state_11551__$1 = state_11551;
var statearr_11566_11587 = state_11551__$1;
(statearr_11566_11587[(2)] = inst_11547);

(statearr_11566_11587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11552 === (8))){
var inst_11528 = (state_11551[(7)]);
var inst_11538 = cljs.core.next.call(null,inst_11528);
var inst_11528__$1 = inst_11538;
var state_11551__$1 = (function (){var statearr_11567 = state_11551;
(statearr_11567[(7)] = inst_11528__$1);

return statearr_11567;
})();
var statearr_11568_11588 = state_11551__$1;
(statearr_11568_11588[(2)] = null);

(statearr_11568_11588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_11569 = [null,null,null,null,null,null,null,null];
(statearr_11569[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_11569[(1)] = (1));

return statearr_11569;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_11551){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11570){var ex__10906__auto__ = e11570;
var statearr_11571_11589 = state_11551;
(statearr_11571_11589[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11551[(4)]))){
var statearr_11572_11590 = state_11551;
(statearr_11572_11590[(1)] = cljs.core.first.call(null,(state_11551[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11591 = state_11551;
state_11551 = G__11591;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_11551){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_11551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11573 = f__10977__auto__.call(null);
(statearr_11573[(6)] = c__10976__auto__);

return statearr_11573;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__11593 = arguments.length;
switch (G__11593) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_11595 = (function (_){
var x__4550__auto__ = (((_ == null))?null:_);
var m__4551__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,_);
} else {
var m__4549__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_11595.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_11596 = (function (m,ch,close_QMARK_){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4549__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_11596.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_11597 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_11597.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_11598 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m);
} else {
var m__4549__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_11598.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11599 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11599 = (function (ch,cs,meta11600){
this.ch = ch;
this.cs = cs;
this.meta11600 = meta11600;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11601,meta11600__$1){
var self__ = this;
var _11601__$1 = this;
return (new cljs.core.async.t_cljs$core$async11599(self__.ch,self__.cs,meta11600__$1));
}));

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11601){
var self__ = this;
var _11601__$1 = this;
return self__.meta11600;
}));

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async11599.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async11599.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta11600","meta11600",-1589125759,null)], null);
}));

(cljs.core.async.t_cljs$core$async11599.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11599.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11599");

(cljs.core.async.t_cljs$core$async11599.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11599");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11599.
 */
cljs.core.async.__GT_t_cljs$core$async11599 = (function cljs$core$async$mult_$___GT_t_cljs$core$async11599(ch__$1,cs__$1,meta11600){
return (new cljs.core.async.t_cljs$core$async11599(ch__$1,cs__$1,meta11600));
});

}

return (new cljs.core.async.t_cljs$core$async11599(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__10976__auto___11818 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11734){
var state_val_11735 = (state_11734[(1)]);
if((state_val_11735 === (7))){
var inst_11730 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11736_11819 = state_11734__$1;
(statearr_11736_11819[(2)] = inst_11730);

(statearr_11736_11819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (20))){
var inst_11635 = (state_11734[(7)]);
var inst_11647 = cljs.core.first.call(null,inst_11635);
var inst_11648 = cljs.core.nth.call(null,inst_11647,(0),null);
var inst_11649 = cljs.core.nth.call(null,inst_11647,(1),null);
var state_11734__$1 = (function (){var statearr_11737 = state_11734;
(statearr_11737[(8)] = inst_11648);

return statearr_11737;
})();
if(cljs.core.truth_(inst_11649)){
var statearr_11738_11820 = state_11734__$1;
(statearr_11738_11820[(1)] = (22));

} else {
var statearr_11739_11821 = state_11734__$1;
(statearr_11739_11821[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (27))){
var inst_11604 = (state_11734[(9)]);
var inst_11677 = (state_11734[(10)]);
var inst_11684 = (state_11734[(11)]);
var inst_11679 = (state_11734[(12)]);
var inst_11684__$1 = cljs.core._nth.call(null,inst_11677,inst_11679);
var inst_11685 = cljs.core.async.put_BANG_.call(null,inst_11684__$1,inst_11604,done);
var state_11734__$1 = (function (){var statearr_11740 = state_11734;
(statearr_11740[(11)] = inst_11684__$1);

return statearr_11740;
})();
if(cljs.core.truth_(inst_11685)){
var statearr_11741_11822 = state_11734__$1;
(statearr_11741_11822[(1)] = (30));

} else {
var statearr_11742_11823 = state_11734__$1;
(statearr_11742_11823[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (1))){
var state_11734__$1 = state_11734;
var statearr_11743_11824 = state_11734__$1;
(statearr_11743_11824[(2)] = null);

(statearr_11743_11824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (24))){
var inst_11635 = (state_11734[(7)]);
var inst_11654 = (state_11734[(2)]);
var inst_11655 = cljs.core.next.call(null,inst_11635);
var inst_11613 = inst_11655;
var inst_11614 = null;
var inst_11615 = (0);
var inst_11616 = (0);
var state_11734__$1 = (function (){var statearr_11744 = state_11734;
(statearr_11744[(13)] = inst_11616);

(statearr_11744[(14)] = inst_11614);

(statearr_11744[(15)] = inst_11654);

(statearr_11744[(16)] = inst_11615);

(statearr_11744[(17)] = inst_11613);

return statearr_11744;
})();
var statearr_11745_11825 = state_11734__$1;
(statearr_11745_11825[(2)] = null);

(statearr_11745_11825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (39))){
var state_11734__$1 = state_11734;
var statearr_11749_11826 = state_11734__$1;
(statearr_11749_11826[(2)] = null);

(statearr_11749_11826[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (4))){
var inst_11604 = (state_11734[(9)]);
var inst_11604__$1 = (state_11734[(2)]);
var inst_11605 = (inst_11604__$1 == null);
var state_11734__$1 = (function (){var statearr_11750 = state_11734;
(statearr_11750[(9)] = inst_11604__$1);

return statearr_11750;
})();
if(cljs.core.truth_(inst_11605)){
var statearr_11751_11827 = state_11734__$1;
(statearr_11751_11827[(1)] = (5));

} else {
var statearr_11752_11828 = state_11734__$1;
(statearr_11752_11828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (15))){
var inst_11616 = (state_11734[(13)]);
var inst_11614 = (state_11734[(14)]);
var inst_11615 = (state_11734[(16)]);
var inst_11613 = (state_11734[(17)]);
var inst_11631 = (state_11734[(2)]);
var inst_11632 = (inst_11616 + (1));
var tmp11746 = inst_11614;
var tmp11747 = inst_11615;
var tmp11748 = inst_11613;
var inst_11613__$1 = tmp11748;
var inst_11614__$1 = tmp11746;
var inst_11615__$1 = tmp11747;
var inst_11616__$1 = inst_11632;
var state_11734__$1 = (function (){var statearr_11753 = state_11734;
(statearr_11753[(13)] = inst_11616__$1);

(statearr_11753[(14)] = inst_11614__$1);

(statearr_11753[(16)] = inst_11615__$1);

(statearr_11753[(17)] = inst_11613__$1);

(statearr_11753[(18)] = inst_11631);

return statearr_11753;
})();
var statearr_11754_11829 = state_11734__$1;
(statearr_11754_11829[(2)] = null);

(statearr_11754_11829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (21))){
var inst_11658 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11758_11830 = state_11734__$1;
(statearr_11758_11830[(2)] = inst_11658);

(statearr_11758_11830[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (31))){
var inst_11684 = (state_11734[(11)]);
var inst_11688 = cljs.core.async.untap_STAR_.call(null,m,inst_11684);
var state_11734__$1 = state_11734;
var statearr_11759_11831 = state_11734__$1;
(statearr_11759_11831[(2)] = inst_11688);

(statearr_11759_11831[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (32))){
var inst_11676 = (state_11734[(19)]);
var inst_11677 = (state_11734[(10)]);
var inst_11678 = (state_11734[(20)]);
var inst_11679 = (state_11734[(12)]);
var inst_11690 = (state_11734[(2)]);
var inst_11691 = (inst_11679 + (1));
var tmp11755 = inst_11676;
var tmp11756 = inst_11677;
var tmp11757 = inst_11678;
var inst_11676__$1 = tmp11755;
var inst_11677__$1 = tmp11756;
var inst_11678__$1 = tmp11757;
var inst_11679__$1 = inst_11691;
var state_11734__$1 = (function (){var statearr_11760 = state_11734;
(statearr_11760[(19)] = inst_11676__$1);

(statearr_11760[(21)] = inst_11690);

(statearr_11760[(10)] = inst_11677__$1);

(statearr_11760[(20)] = inst_11678__$1);

(statearr_11760[(12)] = inst_11679__$1);

return statearr_11760;
})();
var statearr_11761_11832 = state_11734__$1;
(statearr_11761_11832[(2)] = null);

(statearr_11761_11832[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (40))){
var inst_11703 = (state_11734[(22)]);
var inst_11707 = cljs.core.async.untap_STAR_.call(null,m,inst_11703);
var state_11734__$1 = state_11734;
var statearr_11762_11833 = state_11734__$1;
(statearr_11762_11833[(2)] = inst_11707);

(statearr_11762_11833[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (33))){
var inst_11694 = (state_11734[(23)]);
var inst_11696 = cljs.core.chunked_seq_QMARK_.call(null,inst_11694);
var state_11734__$1 = state_11734;
if(inst_11696){
var statearr_11763_11834 = state_11734__$1;
(statearr_11763_11834[(1)] = (36));

} else {
var statearr_11764_11835 = state_11734__$1;
(statearr_11764_11835[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (13))){
var inst_11625 = (state_11734[(24)]);
var inst_11628 = cljs.core.async.close_BANG_.call(null,inst_11625);
var state_11734__$1 = state_11734;
var statearr_11765_11836 = state_11734__$1;
(statearr_11765_11836[(2)] = inst_11628);

(statearr_11765_11836[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (22))){
var inst_11648 = (state_11734[(8)]);
var inst_11651 = cljs.core.async.close_BANG_.call(null,inst_11648);
var state_11734__$1 = state_11734;
var statearr_11766_11837 = state_11734__$1;
(statearr_11766_11837[(2)] = inst_11651);

(statearr_11766_11837[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (36))){
var inst_11694 = (state_11734[(23)]);
var inst_11698 = cljs.core.chunk_first.call(null,inst_11694);
var inst_11699 = cljs.core.chunk_rest.call(null,inst_11694);
var inst_11700 = cljs.core.count.call(null,inst_11698);
var inst_11676 = inst_11699;
var inst_11677 = inst_11698;
var inst_11678 = inst_11700;
var inst_11679 = (0);
var state_11734__$1 = (function (){var statearr_11767 = state_11734;
(statearr_11767[(19)] = inst_11676);

(statearr_11767[(10)] = inst_11677);

(statearr_11767[(20)] = inst_11678);

(statearr_11767[(12)] = inst_11679);

return statearr_11767;
})();
var statearr_11768_11838 = state_11734__$1;
(statearr_11768_11838[(2)] = null);

(statearr_11768_11838[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (41))){
var inst_11694 = (state_11734[(23)]);
var inst_11709 = (state_11734[(2)]);
var inst_11710 = cljs.core.next.call(null,inst_11694);
var inst_11676 = inst_11710;
var inst_11677 = null;
var inst_11678 = (0);
var inst_11679 = (0);
var state_11734__$1 = (function (){var statearr_11769 = state_11734;
(statearr_11769[(19)] = inst_11676);

(statearr_11769[(25)] = inst_11709);

(statearr_11769[(10)] = inst_11677);

(statearr_11769[(20)] = inst_11678);

(statearr_11769[(12)] = inst_11679);

return statearr_11769;
})();
var statearr_11770_11839 = state_11734__$1;
(statearr_11770_11839[(2)] = null);

(statearr_11770_11839[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (43))){
var state_11734__$1 = state_11734;
var statearr_11771_11840 = state_11734__$1;
(statearr_11771_11840[(2)] = null);

(statearr_11771_11840[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (29))){
var inst_11718 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11772_11841 = state_11734__$1;
(statearr_11772_11841[(2)] = inst_11718);

(statearr_11772_11841[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (44))){
var inst_11727 = (state_11734[(2)]);
var state_11734__$1 = (function (){var statearr_11773 = state_11734;
(statearr_11773[(26)] = inst_11727);

return statearr_11773;
})();
var statearr_11774_11842 = state_11734__$1;
(statearr_11774_11842[(2)] = null);

(statearr_11774_11842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (6))){
var inst_11668 = (state_11734[(27)]);
var inst_11667 = cljs.core.deref.call(null,cs);
var inst_11668__$1 = cljs.core.keys.call(null,inst_11667);
var inst_11669 = cljs.core.count.call(null,inst_11668__$1);
var inst_11670 = cljs.core.reset_BANG_.call(null,dctr,inst_11669);
var inst_11675 = cljs.core.seq.call(null,inst_11668__$1);
var inst_11676 = inst_11675;
var inst_11677 = null;
var inst_11678 = (0);
var inst_11679 = (0);
var state_11734__$1 = (function (){var statearr_11775 = state_11734;
(statearr_11775[(27)] = inst_11668__$1);

(statearr_11775[(19)] = inst_11676);

(statearr_11775[(28)] = inst_11670);

(statearr_11775[(10)] = inst_11677);

(statearr_11775[(20)] = inst_11678);

(statearr_11775[(12)] = inst_11679);

return statearr_11775;
})();
var statearr_11776_11843 = state_11734__$1;
(statearr_11776_11843[(2)] = null);

(statearr_11776_11843[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (28))){
var inst_11676 = (state_11734[(19)]);
var inst_11694 = (state_11734[(23)]);
var inst_11694__$1 = cljs.core.seq.call(null,inst_11676);
var state_11734__$1 = (function (){var statearr_11777 = state_11734;
(statearr_11777[(23)] = inst_11694__$1);

return statearr_11777;
})();
if(inst_11694__$1){
var statearr_11778_11844 = state_11734__$1;
(statearr_11778_11844[(1)] = (33));

} else {
var statearr_11779_11845 = state_11734__$1;
(statearr_11779_11845[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (25))){
var inst_11678 = (state_11734[(20)]);
var inst_11679 = (state_11734[(12)]);
var inst_11681 = (inst_11679 < inst_11678);
var inst_11682 = inst_11681;
var state_11734__$1 = state_11734;
if(cljs.core.truth_(inst_11682)){
var statearr_11780_11846 = state_11734__$1;
(statearr_11780_11846[(1)] = (27));

} else {
var statearr_11781_11847 = state_11734__$1;
(statearr_11781_11847[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (34))){
var state_11734__$1 = state_11734;
var statearr_11782_11848 = state_11734__$1;
(statearr_11782_11848[(2)] = null);

(statearr_11782_11848[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (17))){
var state_11734__$1 = state_11734;
var statearr_11783_11849 = state_11734__$1;
(statearr_11783_11849[(2)] = null);

(statearr_11783_11849[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (3))){
var inst_11732 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11734__$1,inst_11732);
} else {
if((state_val_11735 === (12))){
var inst_11663 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11784_11850 = state_11734__$1;
(statearr_11784_11850[(2)] = inst_11663);

(statearr_11784_11850[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (2))){
var state_11734__$1 = state_11734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11734__$1,(4),ch);
} else {
if((state_val_11735 === (23))){
var state_11734__$1 = state_11734;
var statearr_11785_11851 = state_11734__$1;
(statearr_11785_11851[(2)] = null);

(statearr_11785_11851[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (35))){
var inst_11716 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11786_11852 = state_11734__$1;
(statearr_11786_11852[(2)] = inst_11716);

(statearr_11786_11852[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (19))){
var inst_11635 = (state_11734[(7)]);
var inst_11639 = cljs.core.chunk_first.call(null,inst_11635);
var inst_11640 = cljs.core.chunk_rest.call(null,inst_11635);
var inst_11641 = cljs.core.count.call(null,inst_11639);
var inst_11613 = inst_11640;
var inst_11614 = inst_11639;
var inst_11615 = inst_11641;
var inst_11616 = (0);
var state_11734__$1 = (function (){var statearr_11787 = state_11734;
(statearr_11787[(13)] = inst_11616);

(statearr_11787[(14)] = inst_11614);

(statearr_11787[(16)] = inst_11615);

(statearr_11787[(17)] = inst_11613);

return statearr_11787;
})();
var statearr_11788_11853 = state_11734__$1;
(statearr_11788_11853[(2)] = null);

(statearr_11788_11853[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (11))){
var inst_11613 = (state_11734[(17)]);
var inst_11635 = (state_11734[(7)]);
var inst_11635__$1 = cljs.core.seq.call(null,inst_11613);
var state_11734__$1 = (function (){var statearr_11789 = state_11734;
(statearr_11789[(7)] = inst_11635__$1);

return statearr_11789;
})();
if(inst_11635__$1){
var statearr_11790_11854 = state_11734__$1;
(statearr_11790_11854[(1)] = (16));

} else {
var statearr_11791_11855 = state_11734__$1;
(statearr_11791_11855[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (9))){
var inst_11665 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11792_11856 = state_11734__$1;
(statearr_11792_11856[(2)] = inst_11665);

(statearr_11792_11856[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (5))){
var inst_11611 = cljs.core.deref.call(null,cs);
var inst_11612 = cljs.core.seq.call(null,inst_11611);
var inst_11613 = inst_11612;
var inst_11614 = null;
var inst_11615 = (0);
var inst_11616 = (0);
var state_11734__$1 = (function (){var statearr_11793 = state_11734;
(statearr_11793[(13)] = inst_11616);

(statearr_11793[(14)] = inst_11614);

(statearr_11793[(16)] = inst_11615);

(statearr_11793[(17)] = inst_11613);

return statearr_11793;
})();
var statearr_11794_11857 = state_11734__$1;
(statearr_11794_11857[(2)] = null);

(statearr_11794_11857[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (14))){
var state_11734__$1 = state_11734;
var statearr_11795_11858 = state_11734__$1;
(statearr_11795_11858[(2)] = null);

(statearr_11795_11858[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (45))){
var inst_11724 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11796_11859 = state_11734__$1;
(statearr_11796_11859[(2)] = inst_11724);

(statearr_11796_11859[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (26))){
var inst_11668 = (state_11734[(27)]);
var inst_11720 = (state_11734[(2)]);
var inst_11721 = cljs.core.seq.call(null,inst_11668);
var state_11734__$1 = (function (){var statearr_11797 = state_11734;
(statearr_11797[(29)] = inst_11720);

return statearr_11797;
})();
if(inst_11721){
var statearr_11798_11860 = state_11734__$1;
(statearr_11798_11860[(1)] = (42));

} else {
var statearr_11799_11861 = state_11734__$1;
(statearr_11799_11861[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (16))){
var inst_11635 = (state_11734[(7)]);
var inst_11637 = cljs.core.chunked_seq_QMARK_.call(null,inst_11635);
var state_11734__$1 = state_11734;
if(inst_11637){
var statearr_11800_11862 = state_11734__$1;
(statearr_11800_11862[(1)] = (19));

} else {
var statearr_11801_11863 = state_11734__$1;
(statearr_11801_11863[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (38))){
var inst_11713 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11802_11864 = state_11734__$1;
(statearr_11802_11864[(2)] = inst_11713);

(statearr_11802_11864[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (30))){
var state_11734__$1 = state_11734;
var statearr_11803_11865 = state_11734__$1;
(statearr_11803_11865[(2)] = null);

(statearr_11803_11865[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (10))){
var inst_11616 = (state_11734[(13)]);
var inst_11614 = (state_11734[(14)]);
var inst_11624 = cljs.core._nth.call(null,inst_11614,inst_11616);
var inst_11625 = cljs.core.nth.call(null,inst_11624,(0),null);
var inst_11626 = cljs.core.nth.call(null,inst_11624,(1),null);
var state_11734__$1 = (function (){var statearr_11804 = state_11734;
(statearr_11804[(24)] = inst_11625);

return statearr_11804;
})();
if(cljs.core.truth_(inst_11626)){
var statearr_11805_11866 = state_11734__$1;
(statearr_11805_11866[(1)] = (13));

} else {
var statearr_11806_11867 = state_11734__$1;
(statearr_11806_11867[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (18))){
var inst_11661 = (state_11734[(2)]);
var state_11734__$1 = state_11734;
var statearr_11807_11868 = state_11734__$1;
(statearr_11807_11868[(2)] = inst_11661);

(statearr_11807_11868[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (42))){
var state_11734__$1 = state_11734;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11734__$1,(45),dchan);
} else {
if((state_val_11735 === (37))){
var inst_11604 = (state_11734[(9)]);
var inst_11694 = (state_11734[(23)]);
var inst_11703 = (state_11734[(22)]);
var inst_11703__$1 = cljs.core.first.call(null,inst_11694);
var inst_11704 = cljs.core.async.put_BANG_.call(null,inst_11703__$1,inst_11604,done);
var state_11734__$1 = (function (){var statearr_11808 = state_11734;
(statearr_11808[(22)] = inst_11703__$1);

return statearr_11808;
})();
if(cljs.core.truth_(inst_11704)){
var statearr_11809_11869 = state_11734__$1;
(statearr_11809_11869[(1)] = (39));

} else {
var statearr_11810_11870 = state_11734__$1;
(statearr_11810_11870[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11735 === (8))){
var inst_11616 = (state_11734[(13)]);
var inst_11615 = (state_11734[(16)]);
var inst_11618 = (inst_11616 < inst_11615);
var inst_11619 = inst_11618;
var state_11734__$1 = state_11734;
if(cljs.core.truth_(inst_11619)){
var statearr_11811_11871 = state_11734__$1;
(statearr_11811_11871[(1)] = (10));

} else {
var statearr_11812_11872 = state_11734__$1;
(statearr_11812_11872[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__10903__auto__ = null;
var cljs$core$async$mult_$_state_machine__10903__auto____0 = (function (){
var statearr_11813 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11813[(0)] = cljs$core$async$mult_$_state_machine__10903__auto__);

(statearr_11813[(1)] = (1));

return statearr_11813;
});
var cljs$core$async$mult_$_state_machine__10903__auto____1 = (function (state_11734){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11734);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e11814){var ex__10906__auto__ = e11814;
var statearr_11815_11873 = state_11734;
(statearr_11815_11873[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11734[(4)]))){
var statearr_11816_11874 = state_11734;
(statearr_11816_11874[(1)] = cljs.core.first.call(null,(state_11734[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11875 = state_11734;
state_11734 = G__11875;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__10903__auto__ = function(state_11734){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__10903__auto____1.call(this,state_11734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__10903__auto____0;
cljs$core$async$mult_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__10903__auto____1;
return cljs$core$async$mult_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_11817 = f__10977__auto__.call(null);
(statearr_11817[(6)] = c__10976__auto___11818);

return statearr_11817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__11877 = arguments.length;
switch (G__11877) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_11879 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_11879.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_11880 = (function (m,ch){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,ch);
} else {
var m__4549__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_11880.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_11881 = (function (m){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m);
} else {
var m__4549__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_11881.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_11882 = (function (m,state_map){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,state_map);
} else {
var m__4549__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_11882.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_11883 = (function (m,mode){
var x__4550__auto__ = (((m == null))?null:m);
var m__4551__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,m,mode);
} else {
var m__4549__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_11883.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___11893 = arguments.length;
var i__4865__auto___11894 = (0);
while(true){
if((i__4865__auto___11894 < len__4864__auto___11893)){
args__4870__auto__.push((arguments[i__4865__auto___11894]));

var G__11895 = (i__4865__auto___11894 + (1));
i__4865__auto___11894 = G__11895;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((3) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4871__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__11888){
var map__11889 = p__11888;
var map__11889__$1 = cljs.core.__destructure_map.call(null,map__11889);
var opts = map__11889__$1;
var statearr_11890_11896 = state;
(statearr_11890_11896[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_11891_11897 = state;
(statearr_11891_11897[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_11892_11898 = state;
(statearr_11892_11898[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq11884){
var G__11885 = cljs.core.first.call(null,seq11884);
var seq11884__$1 = cljs.core.next.call(null,seq11884);
var G__11886 = cljs.core.first.call(null,seq11884__$1);
var seq11884__$2 = cljs.core.next.call(null,seq11884__$1);
var G__11887 = cljs.core.first.call(null,seq11884__$2);
var seq11884__$3 = cljs.core.next.call(null,seq11884__$2);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11885,G__11886,G__11887,seq11884__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11899 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11899 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta11900){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta11900 = meta11900;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11901,meta11900__$1){
var self__ = this;
var _11901__$1 = this;
return (new cljs.core.async.t_cljs$core$async11899(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta11900__$1));
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11901){
var self__ = this;
var _11901__$1 = this;
return self__.meta11900;
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11899.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async11899.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta11900","meta11900",916547616,null)], null);
}));

(cljs.core.async.t_cljs$core$async11899.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11899.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11899");

(cljs.core.async.t_cljs$core$async11899.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async11899");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11899.
 */
cljs.core.async.__GT_t_cljs$core$async11899 = (function cljs$core$async$mix_$___GT_t_cljs$core$async11899(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11900){
return (new cljs.core.async.t_cljs$core$async11899(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta11900));
});

}

return (new cljs.core.async.t_cljs$core$async11899(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10976__auto___12014 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_11969){
var state_val_11970 = (state_11969[(1)]);
if((state_val_11970 === (7))){
var inst_11929 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
if(cljs.core.truth_(inst_11929)){
var statearr_11971_12015 = state_11969__$1;
(statearr_11971_12015[(1)] = (8));

} else {
var statearr_11972_12016 = state_11969__$1;
(statearr_11972_12016[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (20))){
var inst_11922 = (state_11969[(7)]);
var state_11969__$1 = state_11969;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11969__$1,(23),out,inst_11922);
} else {
if((state_val_11970 === (1))){
var inst_11905 = calc_state.call(null);
var inst_11906 = cljs.core.__destructure_map.call(null,inst_11905);
var inst_11907 = cljs.core.get.call(null,inst_11906,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11908 = cljs.core.get.call(null,inst_11906,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11909 = cljs.core.get.call(null,inst_11906,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_11910 = inst_11905;
var state_11969__$1 = (function (){var statearr_11973 = state_11969;
(statearr_11973[(8)] = inst_11909);

(statearr_11973[(9)] = inst_11907);

(statearr_11973[(10)] = inst_11908);

(statearr_11973[(11)] = inst_11910);

return statearr_11973;
})();
var statearr_11974_12017 = state_11969__$1;
(statearr_11974_12017[(2)] = null);

(statearr_11974_12017[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (24))){
var inst_11913 = (state_11969[(12)]);
var inst_11910 = inst_11913;
var state_11969__$1 = (function (){var statearr_11975 = state_11969;
(statearr_11975[(11)] = inst_11910);

return statearr_11975;
})();
var statearr_11976_12018 = state_11969__$1;
(statearr_11976_12018[(2)] = null);

(statearr_11976_12018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (4))){
var inst_11922 = (state_11969[(7)]);
var inst_11924 = (state_11969[(13)]);
var inst_11921 = (state_11969[(2)]);
var inst_11922__$1 = cljs.core.nth.call(null,inst_11921,(0),null);
var inst_11923 = cljs.core.nth.call(null,inst_11921,(1),null);
var inst_11924__$1 = (inst_11922__$1 == null);
var state_11969__$1 = (function (){var statearr_11977 = state_11969;
(statearr_11977[(7)] = inst_11922__$1);

(statearr_11977[(14)] = inst_11923);

(statearr_11977[(13)] = inst_11924__$1);

return statearr_11977;
})();
if(cljs.core.truth_(inst_11924__$1)){
var statearr_11978_12019 = state_11969__$1;
(statearr_11978_12019[(1)] = (5));

} else {
var statearr_11979_12020 = state_11969__$1;
(statearr_11979_12020[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (15))){
var inst_11943 = (state_11969[(15)]);
var inst_11914 = (state_11969[(16)]);
var inst_11943__$1 = cljs.core.empty_QMARK_.call(null,inst_11914);
var state_11969__$1 = (function (){var statearr_11980 = state_11969;
(statearr_11980[(15)] = inst_11943__$1);

return statearr_11980;
})();
if(inst_11943__$1){
var statearr_11981_12021 = state_11969__$1;
(statearr_11981_12021[(1)] = (17));

} else {
var statearr_11982_12022 = state_11969__$1;
(statearr_11982_12022[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (21))){
var inst_11913 = (state_11969[(12)]);
var inst_11910 = inst_11913;
var state_11969__$1 = (function (){var statearr_11983 = state_11969;
(statearr_11983[(11)] = inst_11910);

return statearr_11983;
})();
var statearr_11984_12023 = state_11969__$1;
(statearr_11984_12023[(2)] = null);

(statearr_11984_12023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (13))){
var inst_11936 = (state_11969[(2)]);
var inst_11937 = calc_state.call(null);
var inst_11910 = inst_11937;
var state_11969__$1 = (function (){var statearr_11985 = state_11969;
(statearr_11985[(17)] = inst_11936);

(statearr_11985[(11)] = inst_11910);

return statearr_11985;
})();
var statearr_11986_12024 = state_11969__$1;
(statearr_11986_12024[(2)] = null);

(statearr_11986_12024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (22))){
var inst_11963 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
var statearr_11987_12025 = state_11969__$1;
(statearr_11987_12025[(2)] = inst_11963);

(statearr_11987_12025[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (6))){
var inst_11923 = (state_11969[(14)]);
var inst_11927 = cljs.core._EQ_.call(null,inst_11923,change);
var state_11969__$1 = state_11969;
var statearr_11988_12026 = state_11969__$1;
(statearr_11988_12026[(2)] = inst_11927);

(statearr_11988_12026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (25))){
var state_11969__$1 = state_11969;
var statearr_11989_12027 = state_11969__$1;
(statearr_11989_12027[(2)] = null);

(statearr_11989_12027[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (17))){
var inst_11915 = (state_11969[(18)]);
var inst_11923 = (state_11969[(14)]);
var inst_11945 = inst_11915.call(null,inst_11923);
var inst_11946 = cljs.core.not.call(null,inst_11945);
var state_11969__$1 = state_11969;
var statearr_11990_12028 = state_11969__$1;
(statearr_11990_12028[(2)] = inst_11946);

(statearr_11990_12028[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (3))){
var inst_11967 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11969__$1,inst_11967);
} else {
if((state_val_11970 === (12))){
var state_11969__$1 = state_11969;
var statearr_11991_12029 = state_11969__$1;
(statearr_11991_12029[(2)] = null);

(statearr_11991_12029[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (2))){
var inst_11910 = (state_11969[(11)]);
var inst_11913 = (state_11969[(12)]);
var inst_11913__$1 = cljs.core.__destructure_map.call(null,inst_11910);
var inst_11914 = cljs.core.get.call(null,inst_11913__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_11915 = cljs.core.get.call(null,inst_11913__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_11916 = cljs.core.get.call(null,inst_11913__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_11969__$1 = (function (){var statearr_11992 = state_11969;
(statearr_11992[(18)] = inst_11915);

(statearr_11992[(16)] = inst_11914);

(statearr_11992[(12)] = inst_11913__$1);

return statearr_11992;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_11969__$1,(4),inst_11916);
} else {
if((state_val_11970 === (23))){
var inst_11954 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
if(cljs.core.truth_(inst_11954)){
var statearr_11993_12030 = state_11969__$1;
(statearr_11993_12030[(1)] = (24));

} else {
var statearr_11994_12031 = state_11969__$1;
(statearr_11994_12031[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (19))){
var inst_11949 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
var statearr_11995_12032 = state_11969__$1;
(statearr_11995_12032[(2)] = inst_11949);

(statearr_11995_12032[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (11))){
var inst_11923 = (state_11969[(14)]);
var inst_11933 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_11923);
var state_11969__$1 = state_11969;
var statearr_11996_12033 = state_11969__$1;
(statearr_11996_12033[(2)] = inst_11933);

(statearr_11996_12033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (9))){
var inst_11940 = (state_11969[(19)]);
var inst_11914 = (state_11969[(16)]);
var inst_11923 = (state_11969[(14)]);
var inst_11940__$1 = inst_11914.call(null,inst_11923);
var state_11969__$1 = (function (){var statearr_11997 = state_11969;
(statearr_11997[(19)] = inst_11940__$1);

return statearr_11997;
})();
if(cljs.core.truth_(inst_11940__$1)){
var statearr_11998_12034 = state_11969__$1;
(statearr_11998_12034[(1)] = (14));

} else {
var statearr_11999_12035 = state_11969__$1;
(statearr_11999_12035[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (5))){
var inst_11924 = (state_11969[(13)]);
var state_11969__$1 = state_11969;
var statearr_12000_12036 = state_11969__$1;
(statearr_12000_12036[(2)] = inst_11924);

(statearr_12000_12036[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (14))){
var inst_11940 = (state_11969[(19)]);
var state_11969__$1 = state_11969;
var statearr_12001_12037 = state_11969__$1;
(statearr_12001_12037[(2)] = inst_11940);

(statearr_12001_12037[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (26))){
var inst_11959 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
var statearr_12002_12038 = state_11969__$1;
(statearr_12002_12038[(2)] = inst_11959);

(statearr_12002_12038[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (16))){
var inst_11951 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
if(cljs.core.truth_(inst_11951)){
var statearr_12003_12039 = state_11969__$1;
(statearr_12003_12039[(1)] = (20));

} else {
var statearr_12004_12040 = state_11969__$1;
(statearr_12004_12040[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (10))){
var inst_11965 = (state_11969[(2)]);
var state_11969__$1 = state_11969;
var statearr_12005_12041 = state_11969__$1;
(statearr_12005_12041[(2)] = inst_11965);

(statearr_12005_12041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (18))){
var inst_11943 = (state_11969[(15)]);
var state_11969__$1 = state_11969;
var statearr_12006_12042 = state_11969__$1;
(statearr_12006_12042[(2)] = inst_11943);

(statearr_12006_12042[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11970 === (8))){
var inst_11922 = (state_11969[(7)]);
var inst_11931 = (inst_11922 == null);
var state_11969__$1 = state_11969;
if(cljs.core.truth_(inst_11931)){
var statearr_12007_12043 = state_11969__$1;
(statearr_12007_12043[(1)] = (11));

} else {
var statearr_12008_12044 = state_11969__$1;
(statearr_12008_12044[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__10903__auto__ = null;
var cljs$core$async$mix_$_state_machine__10903__auto____0 = (function (){
var statearr_12009 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12009[(0)] = cljs$core$async$mix_$_state_machine__10903__auto__);

(statearr_12009[(1)] = (1));

return statearr_12009;
});
var cljs$core$async$mix_$_state_machine__10903__auto____1 = (function (state_11969){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_11969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12010){var ex__10906__auto__ = e12010;
var statearr_12011_12045 = state_11969;
(statearr_12011_12045[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_11969[(4)]))){
var statearr_12012_12046 = state_11969;
(statearr_12012_12046[(1)] = cljs.core.first.call(null,(state_11969[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12047 = state_11969;
state_11969 = G__12047;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__10903__auto__ = function(state_11969){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__10903__auto____1.call(this,state_11969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__10903__auto____0;
cljs$core$async$mix_$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__10903__auto____1;
return cljs$core$async$mix_$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12013 = f__10977__auto__.call(null);
(statearr_12013[(6)] = c__10976__auto___12014);

return statearr_12013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12050 = (function (p,v,ch,close_QMARK_){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4549__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12050.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12051 = (function (p,v,ch){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v,ch);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12051.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12052 = (function() {
var G__12053 = null;
var G__12053__1 = (function (p){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__12053__2 = (function (p,v){
var x__4550__auto__ = (((p == null))?null:p);
var m__4551__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4550__auto__)]);
if((!((m__4551__auto__ == null)))){
return m__4551__auto__.call(null,p,v);
} else {
var m__4549__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4549__auto__ == null)))){
return m__4549__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__12053 = function(p,v){
switch(arguments.length){
case 1:
return G__12053__1.call(this,p);
case 2:
return G__12053__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12053.cljs$core$IFn$_invoke$arity$1 = G__12053__1;
G__12053.cljs$core$IFn$_invoke$arity$2 = G__12053__2;
return G__12053;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12049 = arguments.length;
switch (G__12049) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12052.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12052.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12057 = arguments.length;
switch (G__12057) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4253__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__12055_SHARP_){
if(cljs.core.truth_(p1__12055_SHARP_.call(null,topic))){
return p1__12055_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12055_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12058 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12058 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12059){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12059 = meta12059;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12060,meta12059__$1){
var self__ = this;
var _12060__$1 = this;
return (new cljs.core.async.t_cljs$core$async12058(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12059__$1));
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12060){
var self__ = this;
var _12060__$1 = this;
return self__.meta12059;
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12058.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12058.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12059","meta12059",-424382522,null)], null);
}));

(cljs.core.async.t_cljs$core$async12058.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12058.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12058");

(cljs.core.async.t_cljs$core$async12058.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12058");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12058.
 */
cljs.core.async.__GT_t_cljs$core$async12058 = (function cljs$core$async$__GT_t_cljs$core$async12058(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12059){
return (new cljs.core.async.t_cljs$core$async12058(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12059));
});

}

return (new cljs.core.async.t_cljs$core$async12058(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__10976__auto___12179 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12132){
var state_val_12133 = (state_12132[(1)]);
if((state_val_12133 === (7))){
var inst_12128 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12134_12180 = state_12132__$1;
(statearr_12134_12180[(2)] = inst_12128);

(statearr_12134_12180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (20))){
var state_12132__$1 = state_12132;
var statearr_12135_12181 = state_12132__$1;
(statearr_12135_12181[(2)] = null);

(statearr_12135_12181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (1))){
var state_12132__$1 = state_12132;
var statearr_12136_12182 = state_12132__$1;
(statearr_12136_12182[(2)] = null);

(statearr_12136_12182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (24))){
var inst_12111 = (state_12132[(7)]);
var inst_12120 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12111);
var state_12132__$1 = state_12132;
var statearr_12137_12183 = state_12132__$1;
(statearr_12137_12183[(2)] = inst_12120);

(statearr_12137_12183[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (4))){
var inst_12063 = (state_12132[(8)]);
var inst_12063__$1 = (state_12132[(2)]);
var inst_12064 = (inst_12063__$1 == null);
var state_12132__$1 = (function (){var statearr_12138 = state_12132;
(statearr_12138[(8)] = inst_12063__$1);

return statearr_12138;
})();
if(cljs.core.truth_(inst_12064)){
var statearr_12139_12184 = state_12132__$1;
(statearr_12139_12184[(1)] = (5));

} else {
var statearr_12140_12185 = state_12132__$1;
(statearr_12140_12185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (15))){
var inst_12105 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12141_12186 = state_12132__$1;
(statearr_12141_12186[(2)] = inst_12105);

(statearr_12141_12186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (21))){
var inst_12125 = (state_12132[(2)]);
var state_12132__$1 = (function (){var statearr_12142 = state_12132;
(statearr_12142[(9)] = inst_12125);

return statearr_12142;
})();
var statearr_12143_12187 = state_12132__$1;
(statearr_12143_12187[(2)] = null);

(statearr_12143_12187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (13))){
var inst_12087 = (state_12132[(10)]);
var inst_12089 = cljs.core.chunked_seq_QMARK_.call(null,inst_12087);
var state_12132__$1 = state_12132;
if(inst_12089){
var statearr_12144_12188 = state_12132__$1;
(statearr_12144_12188[(1)] = (16));

} else {
var statearr_12145_12189 = state_12132__$1;
(statearr_12145_12189[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (22))){
var inst_12117 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
if(cljs.core.truth_(inst_12117)){
var statearr_12146_12190 = state_12132__$1;
(statearr_12146_12190[(1)] = (23));

} else {
var statearr_12147_12191 = state_12132__$1;
(statearr_12147_12191[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (6))){
var inst_12111 = (state_12132[(7)]);
var inst_12063 = (state_12132[(8)]);
var inst_12113 = (state_12132[(11)]);
var inst_12111__$1 = topic_fn.call(null,inst_12063);
var inst_12112 = cljs.core.deref.call(null,mults);
var inst_12113__$1 = cljs.core.get.call(null,inst_12112,inst_12111__$1);
var state_12132__$1 = (function (){var statearr_12148 = state_12132;
(statearr_12148[(7)] = inst_12111__$1);

(statearr_12148[(11)] = inst_12113__$1);

return statearr_12148;
})();
if(cljs.core.truth_(inst_12113__$1)){
var statearr_12149_12192 = state_12132__$1;
(statearr_12149_12192[(1)] = (19));

} else {
var statearr_12150_12193 = state_12132__$1;
(statearr_12150_12193[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (25))){
var inst_12122 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12151_12194 = state_12132__$1;
(statearr_12151_12194[(2)] = inst_12122);

(statearr_12151_12194[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (17))){
var inst_12087 = (state_12132[(10)]);
var inst_12096 = cljs.core.first.call(null,inst_12087);
var inst_12097 = cljs.core.async.muxch_STAR_.call(null,inst_12096);
var inst_12098 = cljs.core.async.close_BANG_.call(null,inst_12097);
var inst_12099 = cljs.core.next.call(null,inst_12087);
var inst_12073 = inst_12099;
var inst_12074 = null;
var inst_12075 = (0);
var inst_12076 = (0);
var state_12132__$1 = (function (){var statearr_12152 = state_12132;
(statearr_12152[(12)] = inst_12098);

(statearr_12152[(13)] = inst_12075);

(statearr_12152[(14)] = inst_12073);

(statearr_12152[(15)] = inst_12076);

(statearr_12152[(16)] = inst_12074);

return statearr_12152;
})();
var statearr_12153_12195 = state_12132__$1;
(statearr_12153_12195[(2)] = null);

(statearr_12153_12195[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (3))){
var inst_12130 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12132__$1,inst_12130);
} else {
if((state_val_12133 === (12))){
var inst_12107 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12154_12196 = state_12132__$1;
(statearr_12154_12196[(2)] = inst_12107);

(statearr_12154_12196[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (2))){
var state_12132__$1 = state_12132;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12132__$1,(4),ch);
} else {
if((state_val_12133 === (23))){
var state_12132__$1 = state_12132;
var statearr_12155_12197 = state_12132__$1;
(statearr_12155_12197[(2)] = null);

(statearr_12155_12197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (19))){
var inst_12063 = (state_12132[(8)]);
var inst_12113 = (state_12132[(11)]);
var inst_12115 = cljs.core.async.muxch_STAR_.call(null,inst_12113);
var state_12132__$1 = state_12132;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12132__$1,(22),inst_12115,inst_12063);
} else {
if((state_val_12133 === (11))){
var inst_12087 = (state_12132[(10)]);
var inst_12073 = (state_12132[(14)]);
var inst_12087__$1 = cljs.core.seq.call(null,inst_12073);
var state_12132__$1 = (function (){var statearr_12156 = state_12132;
(statearr_12156[(10)] = inst_12087__$1);

return statearr_12156;
})();
if(inst_12087__$1){
var statearr_12157_12198 = state_12132__$1;
(statearr_12157_12198[(1)] = (13));

} else {
var statearr_12158_12199 = state_12132__$1;
(statearr_12158_12199[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (9))){
var inst_12109 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12159_12200 = state_12132__$1;
(statearr_12159_12200[(2)] = inst_12109);

(statearr_12159_12200[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (5))){
var inst_12070 = cljs.core.deref.call(null,mults);
var inst_12071 = cljs.core.vals.call(null,inst_12070);
var inst_12072 = cljs.core.seq.call(null,inst_12071);
var inst_12073 = inst_12072;
var inst_12074 = null;
var inst_12075 = (0);
var inst_12076 = (0);
var state_12132__$1 = (function (){var statearr_12160 = state_12132;
(statearr_12160[(13)] = inst_12075);

(statearr_12160[(14)] = inst_12073);

(statearr_12160[(15)] = inst_12076);

(statearr_12160[(16)] = inst_12074);

return statearr_12160;
})();
var statearr_12161_12201 = state_12132__$1;
(statearr_12161_12201[(2)] = null);

(statearr_12161_12201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (14))){
var state_12132__$1 = state_12132;
var statearr_12165_12202 = state_12132__$1;
(statearr_12165_12202[(2)] = null);

(statearr_12165_12202[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (16))){
var inst_12087 = (state_12132[(10)]);
var inst_12091 = cljs.core.chunk_first.call(null,inst_12087);
var inst_12092 = cljs.core.chunk_rest.call(null,inst_12087);
var inst_12093 = cljs.core.count.call(null,inst_12091);
var inst_12073 = inst_12092;
var inst_12074 = inst_12091;
var inst_12075 = inst_12093;
var inst_12076 = (0);
var state_12132__$1 = (function (){var statearr_12166 = state_12132;
(statearr_12166[(13)] = inst_12075);

(statearr_12166[(14)] = inst_12073);

(statearr_12166[(15)] = inst_12076);

(statearr_12166[(16)] = inst_12074);

return statearr_12166;
})();
var statearr_12167_12203 = state_12132__$1;
(statearr_12167_12203[(2)] = null);

(statearr_12167_12203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (10))){
var inst_12075 = (state_12132[(13)]);
var inst_12073 = (state_12132[(14)]);
var inst_12076 = (state_12132[(15)]);
var inst_12074 = (state_12132[(16)]);
var inst_12081 = cljs.core._nth.call(null,inst_12074,inst_12076);
var inst_12082 = cljs.core.async.muxch_STAR_.call(null,inst_12081);
var inst_12083 = cljs.core.async.close_BANG_.call(null,inst_12082);
var inst_12084 = (inst_12076 + (1));
var tmp12162 = inst_12075;
var tmp12163 = inst_12073;
var tmp12164 = inst_12074;
var inst_12073__$1 = tmp12163;
var inst_12074__$1 = tmp12164;
var inst_12075__$1 = tmp12162;
var inst_12076__$1 = inst_12084;
var state_12132__$1 = (function (){var statearr_12168 = state_12132;
(statearr_12168[(17)] = inst_12083);

(statearr_12168[(13)] = inst_12075__$1);

(statearr_12168[(14)] = inst_12073__$1);

(statearr_12168[(15)] = inst_12076__$1);

(statearr_12168[(16)] = inst_12074__$1);

return statearr_12168;
})();
var statearr_12169_12204 = state_12132__$1;
(statearr_12169_12204[(2)] = null);

(statearr_12169_12204[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (18))){
var inst_12102 = (state_12132[(2)]);
var state_12132__$1 = state_12132;
var statearr_12170_12205 = state_12132__$1;
(statearr_12170_12205[(2)] = inst_12102);

(statearr_12170_12205[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12133 === (8))){
var inst_12075 = (state_12132[(13)]);
var inst_12076 = (state_12132[(15)]);
var inst_12078 = (inst_12076 < inst_12075);
var inst_12079 = inst_12078;
var state_12132__$1 = state_12132;
if(cljs.core.truth_(inst_12079)){
var statearr_12171_12206 = state_12132__$1;
(statearr_12171_12206[(1)] = (10));

} else {
var statearr_12172_12207 = state_12132__$1;
(statearr_12172_12207[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12173[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12173[(1)] = (1));

return statearr_12173;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12132){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12132);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12174){var ex__10906__auto__ = e12174;
var statearr_12175_12208 = state_12132;
(statearr_12175_12208[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12132[(4)]))){
var statearr_12176_12209 = state_12132;
(statearr_12176_12209[(1)] = cljs.core.first.call(null,(state_12132[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12210 = state_12132;
state_12132 = G__12210;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12132){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12177 = f__10977__auto__.call(null);
(statearr_12177[(6)] = c__10976__auto___12179);

return statearr_12177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12212 = arguments.length;
switch (G__12212) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12215 = arguments.length;
switch (G__12215) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12218 = arguments.length;
switch (G__12218) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_.call(null,out);
} else {
var c__10976__auto___12296 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12261){
var state_val_12262 = (state_12261[(1)]);
if((state_val_12262 === (7))){
var state_12261__$1 = state_12261;
var statearr_12263_12297 = state_12261__$1;
(statearr_12263_12297[(2)] = null);

(statearr_12263_12297[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (1))){
var state_12261__$1 = state_12261;
var statearr_12264_12298 = state_12261__$1;
(statearr_12264_12298[(2)] = null);

(statearr_12264_12298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (4))){
var inst_12222 = (state_12261[(7)]);
var inst_12221 = (state_12261[(8)]);
var inst_12224 = (inst_12222 < inst_12221);
var state_12261__$1 = state_12261;
if(cljs.core.truth_(inst_12224)){
var statearr_12265_12299 = state_12261__$1;
(statearr_12265_12299[(1)] = (6));

} else {
var statearr_12266_12300 = state_12261__$1;
(statearr_12266_12300[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (15))){
var inst_12247 = (state_12261[(9)]);
var inst_12252 = cljs.core.apply.call(null,f,inst_12247);
var state_12261__$1 = state_12261;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12261__$1,(17),out,inst_12252);
} else {
if((state_val_12262 === (13))){
var inst_12247 = (state_12261[(9)]);
var inst_12247__$1 = (state_12261[(2)]);
var inst_12248 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12247__$1);
var state_12261__$1 = (function (){var statearr_12267 = state_12261;
(statearr_12267[(9)] = inst_12247__$1);

return statearr_12267;
})();
if(cljs.core.truth_(inst_12248)){
var statearr_12268_12301 = state_12261__$1;
(statearr_12268_12301[(1)] = (14));

} else {
var statearr_12269_12302 = state_12261__$1;
(statearr_12269_12302[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (6))){
var state_12261__$1 = state_12261;
var statearr_12270_12303 = state_12261__$1;
(statearr_12270_12303[(2)] = null);

(statearr_12270_12303[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (17))){
var inst_12254 = (state_12261[(2)]);
var state_12261__$1 = (function (){var statearr_12272 = state_12261;
(statearr_12272[(10)] = inst_12254);

return statearr_12272;
})();
var statearr_12273_12304 = state_12261__$1;
(statearr_12273_12304[(2)] = null);

(statearr_12273_12304[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (3))){
var inst_12259 = (state_12261[(2)]);
var state_12261__$1 = state_12261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12261__$1,inst_12259);
} else {
if((state_val_12262 === (12))){
var _ = (function (){var statearr_12274 = state_12261;
(statearr_12274[(4)] = cljs.core.rest.call(null,(state_12261[(4)])));

return statearr_12274;
})();
var state_12261__$1 = state_12261;
var ex12271 = (state_12261__$1[(2)]);
var statearr_12275_12305 = state_12261__$1;
(statearr_12275_12305[(5)] = ex12271);


if((ex12271 instanceof Object)){
var statearr_12276_12306 = state_12261__$1;
(statearr_12276_12306[(1)] = (11));

(statearr_12276_12306[(5)] = null);

} else {
throw ex12271;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (2))){
var inst_12220 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12221 = cnt;
var inst_12222 = (0);
var state_12261__$1 = (function (){var statearr_12277 = state_12261;
(statearr_12277[(11)] = inst_12220);

(statearr_12277[(7)] = inst_12222);

(statearr_12277[(8)] = inst_12221);

return statearr_12277;
})();
var statearr_12278_12307 = state_12261__$1;
(statearr_12278_12307[(2)] = null);

(statearr_12278_12307[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (11))){
var inst_12226 = (state_12261[(2)]);
var inst_12227 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12261__$1 = (function (){var statearr_12279 = state_12261;
(statearr_12279[(12)] = inst_12226);

return statearr_12279;
})();
var statearr_12280_12308 = state_12261__$1;
(statearr_12280_12308[(2)] = inst_12227);

(statearr_12280_12308[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (9))){
var inst_12222 = (state_12261[(7)]);
var _ = (function (){var statearr_12281 = state_12261;
(statearr_12281[(4)] = cljs.core.cons.call(null,(12),(state_12261[(4)])));

return statearr_12281;
})();
var inst_12233 = chs__$1.call(null,inst_12222);
var inst_12234 = done.call(null,inst_12222);
var inst_12235 = cljs.core.async.take_BANG_.call(null,inst_12233,inst_12234);
var ___$1 = (function (){var statearr_12282 = state_12261;
(statearr_12282[(4)] = cljs.core.rest.call(null,(state_12261[(4)])));

return statearr_12282;
})();
var state_12261__$1 = state_12261;
var statearr_12283_12309 = state_12261__$1;
(statearr_12283_12309[(2)] = inst_12235);

(statearr_12283_12309[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (5))){
var inst_12245 = (state_12261[(2)]);
var state_12261__$1 = (function (){var statearr_12284 = state_12261;
(statearr_12284[(13)] = inst_12245);

return statearr_12284;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12261__$1,(13),dchan);
} else {
if((state_val_12262 === (14))){
var inst_12250 = cljs.core.async.close_BANG_.call(null,out);
var state_12261__$1 = state_12261;
var statearr_12285_12310 = state_12261__$1;
(statearr_12285_12310[(2)] = inst_12250);

(statearr_12285_12310[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (16))){
var inst_12257 = (state_12261[(2)]);
var state_12261__$1 = state_12261;
var statearr_12286_12311 = state_12261__$1;
(statearr_12286_12311[(2)] = inst_12257);

(statearr_12286_12311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (10))){
var inst_12222 = (state_12261[(7)]);
var inst_12238 = (state_12261[(2)]);
var inst_12239 = (inst_12222 + (1));
var inst_12222__$1 = inst_12239;
var state_12261__$1 = (function (){var statearr_12287 = state_12261;
(statearr_12287[(7)] = inst_12222__$1);

(statearr_12287[(14)] = inst_12238);

return statearr_12287;
})();
var statearr_12288_12312 = state_12261__$1;
(statearr_12288_12312[(2)] = null);

(statearr_12288_12312[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12262 === (8))){
var inst_12243 = (state_12261[(2)]);
var state_12261__$1 = state_12261;
var statearr_12289_12313 = state_12261__$1;
(statearr_12289_12313[(2)] = inst_12243);

(statearr_12289_12313[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12290 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12290[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12290[(1)] = (1));

return statearr_12290;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12261){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12291){var ex__10906__auto__ = e12291;
var statearr_12292_12314 = state_12261;
(statearr_12292_12314[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12261[(4)]))){
var statearr_12293_12315 = state_12261;
(statearr_12293_12315[(1)] = cljs.core.first.call(null,(state_12261[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12316 = state_12261;
state_12261 = G__12316;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12261){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12294 = f__10977__auto__.call(null);
(statearr_12294[(6)] = c__10976__auto___12296);

return statearr_12294;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12319 = arguments.length;
switch (G__12319) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12374 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12351){
var state_val_12352 = (state_12351[(1)]);
if((state_val_12352 === (7))){
var inst_12331 = (state_12351[(7)]);
var inst_12330 = (state_12351[(8)]);
var inst_12330__$1 = (state_12351[(2)]);
var inst_12331__$1 = cljs.core.nth.call(null,inst_12330__$1,(0),null);
var inst_12332 = cljs.core.nth.call(null,inst_12330__$1,(1),null);
var inst_12333 = (inst_12331__$1 == null);
var state_12351__$1 = (function (){var statearr_12353 = state_12351;
(statearr_12353[(9)] = inst_12332);

(statearr_12353[(7)] = inst_12331__$1);

(statearr_12353[(8)] = inst_12330__$1);

return statearr_12353;
})();
if(cljs.core.truth_(inst_12333)){
var statearr_12354_12375 = state_12351__$1;
(statearr_12354_12375[(1)] = (8));

} else {
var statearr_12355_12376 = state_12351__$1;
(statearr_12355_12376[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (1))){
var inst_12320 = cljs.core.vec.call(null,chs);
var inst_12321 = inst_12320;
var state_12351__$1 = (function (){var statearr_12356 = state_12351;
(statearr_12356[(10)] = inst_12321);

return statearr_12356;
})();
var statearr_12357_12377 = state_12351__$1;
(statearr_12357_12377[(2)] = null);

(statearr_12357_12377[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (4))){
var inst_12321 = (state_12351[(10)]);
var state_12351__$1 = state_12351;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12351__$1,(7),inst_12321);
} else {
if((state_val_12352 === (6))){
var inst_12347 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12358_12378 = state_12351__$1;
(statearr_12358_12378[(2)] = inst_12347);

(statearr_12358_12378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (3))){
var inst_12349 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12351__$1,inst_12349);
} else {
if((state_val_12352 === (2))){
var inst_12321 = (state_12351[(10)]);
var inst_12323 = cljs.core.count.call(null,inst_12321);
var inst_12324 = (inst_12323 > (0));
var state_12351__$1 = state_12351;
if(cljs.core.truth_(inst_12324)){
var statearr_12360_12379 = state_12351__$1;
(statearr_12360_12379[(1)] = (4));

} else {
var statearr_12361_12380 = state_12351__$1;
(statearr_12361_12380[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (11))){
var inst_12321 = (state_12351[(10)]);
var inst_12340 = (state_12351[(2)]);
var tmp12359 = inst_12321;
var inst_12321__$1 = tmp12359;
var state_12351__$1 = (function (){var statearr_12362 = state_12351;
(statearr_12362[(11)] = inst_12340);

(statearr_12362[(10)] = inst_12321__$1);

return statearr_12362;
})();
var statearr_12363_12381 = state_12351__$1;
(statearr_12363_12381[(2)] = null);

(statearr_12363_12381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (9))){
var inst_12331 = (state_12351[(7)]);
var state_12351__$1 = state_12351;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12351__$1,(11),out,inst_12331);
} else {
if((state_val_12352 === (5))){
var inst_12345 = cljs.core.async.close_BANG_.call(null,out);
var state_12351__$1 = state_12351;
var statearr_12364_12382 = state_12351__$1;
(statearr_12364_12382[(2)] = inst_12345);

(statearr_12364_12382[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (10))){
var inst_12343 = (state_12351[(2)]);
var state_12351__$1 = state_12351;
var statearr_12365_12383 = state_12351__$1;
(statearr_12365_12383[(2)] = inst_12343);

(statearr_12365_12383[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12352 === (8))){
var inst_12332 = (state_12351[(9)]);
var inst_12331 = (state_12351[(7)]);
var inst_12321 = (state_12351[(10)]);
var inst_12330 = (state_12351[(8)]);
var inst_12335 = (function (){var cs = inst_12321;
var vec__12326 = inst_12330;
var v = inst_12331;
var c = inst_12332;
return (function (p1__12317_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12317_SHARP_);
});
})();
var inst_12336 = cljs.core.filterv.call(null,inst_12335,inst_12321);
var inst_12321__$1 = inst_12336;
var state_12351__$1 = (function (){var statearr_12366 = state_12351;
(statearr_12366[(10)] = inst_12321__$1);

return statearr_12366;
})();
var statearr_12367_12384 = state_12351__$1;
(statearr_12367_12384[(2)] = null);

(statearr_12367_12384[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12368 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12368[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12368[(1)] = (1));

return statearr_12368;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12351){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12369){var ex__10906__auto__ = e12369;
var statearr_12370_12385 = state_12351;
(statearr_12370_12385[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12351[(4)]))){
var statearr_12371_12386 = state_12351;
(statearr_12371_12386[(1)] = cljs.core.first.call(null,(state_12351[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12387 = state_12351;
state_12351 = G__12387;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12351){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12372 = f__10977__auto__.call(null);
(statearr_12372[(6)] = c__10976__auto___12374);

return statearr_12372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__12389 = arguments.length;
switch (G__12389) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12435 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12413){
var state_val_12414 = (state_12413[(1)]);
if((state_val_12414 === (7))){
var inst_12395 = (state_12413[(7)]);
var inst_12395__$1 = (state_12413[(2)]);
var inst_12396 = (inst_12395__$1 == null);
var inst_12397 = cljs.core.not.call(null,inst_12396);
var state_12413__$1 = (function (){var statearr_12415 = state_12413;
(statearr_12415[(7)] = inst_12395__$1);

return statearr_12415;
})();
if(inst_12397){
var statearr_12416_12436 = state_12413__$1;
(statearr_12416_12436[(1)] = (8));

} else {
var statearr_12417_12437 = state_12413__$1;
(statearr_12417_12437[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (1))){
var inst_12390 = (0);
var state_12413__$1 = (function (){var statearr_12418 = state_12413;
(statearr_12418[(8)] = inst_12390);

return statearr_12418;
})();
var statearr_12419_12438 = state_12413__$1;
(statearr_12419_12438[(2)] = null);

(statearr_12419_12438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (4))){
var state_12413__$1 = state_12413;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12413__$1,(7),ch);
} else {
if((state_val_12414 === (6))){
var inst_12408 = (state_12413[(2)]);
var state_12413__$1 = state_12413;
var statearr_12420_12439 = state_12413__$1;
(statearr_12420_12439[(2)] = inst_12408);

(statearr_12420_12439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (3))){
var inst_12410 = (state_12413[(2)]);
var inst_12411 = cljs.core.async.close_BANG_.call(null,out);
var state_12413__$1 = (function (){var statearr_12421 = state_12413;
(statearr_12421[(9)] = inst_12410);

return statearr_12421;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12413__$1,inst_12411);
} else {
if((state_val_12414 === (2))){
var inst_12390 = (state_12413[(8)]);
var inst_12392 = (inst_12390 < n);
var state_12413__$1 = state_12413;
if(cljs.core.truth_(inst_12392)){
var statearr_12422_12440 = state_12413__$1;
(statearr_12422_12440[(1)] = (4));

} else {
var statearr_12423_12441 = state_12413__$1;
(statearr_12423_12441[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (11))){
var inst_12390 = (state_12413[(8)]);
var inst_12400 = (state_12413[(2)]);
var inst_12401 = (inst_12390 + (1));
var inst_12390__$1 = inst_12401;
var state_12413__$1 = (function (){var statearr_12424 = state_12413;
(statearr_12424[(10)] = inst_12400);

(statearr_12424[(8)] = inst_12390__$1);

return statearr_12424;
})();
var statearr_12425_12442 = state_12413__$1;
(statearr_12425_12442[(2)] = null);

(statearr_12425_12442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (9))){
var state_12413__$1 = state_12413;
var statearr_12426_12443 = state_12413__$1;
(statearr_12426_12443[(2)] = null);

(statearr_12426_12443[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (5))){
var state_12413__$1 = state_12413;
var statearr_12427_12444 = state_12413__$1;
(statearr_12427_12444[(2)] = null);

(statearr_12427_12444[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (10))){
var inst_12405 = (state_12413[(2)]);
var state_12413__$1 = state_12413;
var statearr_12428_12445 = state_12413__$1;
(statearr_12428_12445[(2)] = inst_12405);

(statearr_12428_12445[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12414 === (8))){
var inst_12395 = (state_12413[(7)]);
var state_12413__$1 = state_12413;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12413__$1,(11),out,inst_12395);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12429 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12429[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12429[(1)] = (1));

return statearr_12429;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12413){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12430){var ex__10906__auto__ = e12430;
var statearr_12431_12446 = state_12413;
(statearr_12431_12446[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12413[(4)]))){
var statearr_12432_12447 = state_12413;
(statearr_12432_12447[(1)] = cljs.core.first.call(null,(state_12413[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12448 = state_12413;
state_12413 = G__12448;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12413){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12433 = f__10977__auto__.call(null);
(statearr_12433[(6)] = c__10976__auto___12435);

return statearr_12433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12450 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12450 = (function (f,ch,meta12451){
this.f = f;
this.ch = ch;
this.meta12451 = meta12451;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12452,meta12451__$1){
var self__ = this;
var _12452__$1 = this;
return (new cljs.core.async.t_cljs$core$async12450(self__.f,self__.ch,meta12451__$1));
}));

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12452){
var self__ = this;
var _12452__$1 = this;
return self__.meta12451;
}));

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12453 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12453 = (function (f,ch,meta12451,_,fn1,meta12454){
this.f = f;
this.ch = ch;
this.meta12451 = meta12451;
this._ = _;
this.fn1 = fn1;
this.meta12454 = meta12454;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12455,meta12454__$1){
var self__ = this;
var _12455__$1 = this;
return (new cljs.core.async.t_cljs$core$async12453(self__.f,self__.ch,self__.meta12451,self__._,self__.fn1,meta12454__$1));
}));

(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12455){
var self__ = this;
var _12455__$1 = this;
return self__.meta12454;
}));

(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async12453.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__12449_SHARP_){
return f1.call(null,(((p1__12449_SHARP_ == null))?null:self__.f.call(null,p1__12449_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async12453.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12451","meta12451",-211050574,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async12450","cljs.core.async/t_cljs$core$async12450",1370700146,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta12454","meta12454",-1826184692,null)], null);
}));

(cljs.core.async.t_cljs$core$async12453.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12453.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12453");

(cljs.core.async.t_cljs$core$async12453.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12453");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12453.
 */
cljs.core.async.__GT_t_cljs$core$async12453 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12453(f__$1,ch__$1,meta12451__$1,___$2,fn1__$1,meta12454){
return (new cljs.core.async.t_cljs$core$async12453(f__$1,ch__$1,meta12451__$1,___$2,fn1__$1,meta12454));
});

}

return (new cljs.core.async.t_cljs$core$async12453(self__.f,self__.ch,self__.meta12451,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4251__auto__ = ret;
if(cljs.core.truth_(and__4251__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4251__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12450.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async12450.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12451","meta12451",-211050574,null)], null);
}));

(cljs.core.async.t_cljs$core$async12450.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12450.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12450");

(cljs.core.async.t_cljs$core$async12450.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12450");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12450.
 */
cljs.core.async.__GT_t_cljs$core$async12450 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async12450(f__$1,ch__$1,meta12451){
return (new cljs.core.async.t_cljs$core$async12450(f__$1,ch__$1,meta12451));
});

}

return (new cljs.core.async.t_cljs$core$async12450(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12456 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12456 = (function (f,ch,meta12457){
this.f = f;
this.ch = ch;
this.meta12457 = meta12457;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12458,meta12457__$1){
var self__ = this;
var _12458__$1 = this;
return (new cljs.core.async.t_cljs$core$async12456(self__.f,self__.ch,meta12457__$1));
}));

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12458){
var self__ = this;
var _12458__$1 = this;
return self__.meta12457;
}));

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12456.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async12456.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12457","meta12457",1302213651,null)], null);
}));

(cljs.core.async.t_cljs$core$async12456.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12456.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12456");

(cljs.core.async.t_cljs$core$async12456.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12456");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12456.
 */
cljs.core.async.__GT_t_cljs$core$async12456 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async12456(f__$1,ch__$1,meta12457){
return (new cljs.core.async.t_cljs$core$async12456(f__$1,ch__$1,meta12457));
});

}

return (new cljs.core.async.t_cljs$core$async12456(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12459 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12459 = (function (p,ch,meta12460){
this.p = p;
this.ch = ch;
this.meta12460 = meta12460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12461,meta12460__$1){
var self__ = this;
var _12461__$1 = this;
return (new cljs.core.async.t_cljs$core$async12459(self__.p,self__.ch,meta12460__$1));
}));

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12461){
var self__ = this;
var _12461__$1 = this;
return self__.meta12460;
}));

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12459.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async12459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta12460","meta12460",-1270486699,null)], null);
}));

(cljs.core.async.t_cljs$core$async12459.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12459.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12459");

(cljs.core.async.t_cljs$core$async12459.cljs$lang$ctorPrWriter = (function (this__4491__auto__,writer__4492__auto__,opt__4493__auto__){
return cljs.core._write.call(null,writer__4492__auto__,"cljs.core.async/t_cljs$core$async12459");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12459.
 */
cljs.core.async.__GT_t_cljs$core$async12459 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async12459(p__$1,ch__$1,meta12460){
return (new cljs.core.async.t_cljs$core$async12459(p__$1,ch__$1,meta12460));
});

}

return (new cljs.core.async.t_cljs$core$async12459(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__12463 = arguments.length;
switch (G__12463) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12504 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12484){
var state_val_12485 = (state_12484[(1)]);
if((state_val_12485 === (7))){
var inst_12480 = (state_12484[(2)]);
var state_12484__$1 = state_12484;
var statearr_12486_12505 = state_12484__$1;
(statearr_12486_12505[(2)] = inst_12480);

(statearr_12486_12505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (1))){
var state_12484__$1 = state_12484;
var statearr_12487_12506 = state_12484__$1;
(statearr_12487_12506[(2)] = null);

(statearr_12487_12506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (4))){
var inst_12466 = (state_12484[(7)]);
var inst_12466__$1 = (state_12484[(2)]);
var inst_12467 = (inst_12466__$1 == null);
var state_12484__$1 = (function (){var statearr_12488 = state_12484;
(statearr_12488[(7)] = inst_12466__$1);

return statearr_12488;
})();
if(cljs.core.truth_(inst_12467)){
var statearr_12489_12507 = state_12484__$1;
(statearr_12489_12507[(1)] = (5));

} else {
var statearr_12490_12508 = state_12484__$1;
(statearr_12490_12508[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (6))){
var inst_12466 = (state_12484[(7)]);
var inst_12471 = p.call(null,inst_12466);
var state_12484__$1 = state_12484;
if(cljs.core.truth_(inst_12471)){
var statearr_12491_12509 = state_12484__$1;
(statearr_12491_12509[(1)] = (8));

} else {
var statearr_12492_12510 = state_12484__$1;
(statearr_12492_12510[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (3))){
var inst_12482 = (state_12484[(2)]);
var state_12484__$1 = state_12484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12484__$1,inst_12482);
} else {
if((state_val_12485 === (2))){
var state_12484__$1 = state_12484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12484__$1,(4),ch);
} else {
if((state_val_12485 === (11))){
var inst_12474 = (state_12484[(2)]);
var state_12484__$1 = state_12484;
var statearr_12493_12511 = state_12484__$1;
(statearr_12493_12511[(2)] = inst_12474);

(statearr_12493_12511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (9))){
var state_12484__$1 = state_12484;
var statearr_12494_12512 = state_12484__$1;
(statearr_12494_12512[(2)] = null);

(statearr_12494_12512[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (5))){
var inst_12469 = cljs.core.async.close_BANG_.call(null,out);
var state_12484__$1 = state_12484;
var statearr_12495_12513 = state_12484__$1;
(statearr_12495_12513[(2)] = inst_12469);

(statearr_12495_12513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (10))){
var inst_12477 = (state_12484[(2)]);
var state_12484__$1 = (function (){var statearr_12496 = state_12484;
(statearr_12496[(8)] = inst_12477);

return statearr_12496;
})();
var statearr_12497_12514 = state_12484__$1;
(statearr_12497_12514[(2)] = null);

(statearr_12497_12514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12485 === (8))){
var inst_12466 = (state_12484[(7)]);
var state_12484__$1 = state_12484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12484__$1,(11),out,inst_12466);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12498 = [null,null,null,null,null,null,null,null,null];
(statearr_12498[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12498[(1)] = (1));

return statearr_12498;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12484){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12499){var ex__10906__auto__ = e12499;
var statearr_12500_12515 = state_12484;
(statearr_12500_12515[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12484[(4)]))){
var statearr_12501_12516 = state_12484;
(statearr_12501_12516[(1)] = cljs.core.first.call(null,(state_12484[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12517 = state_12484;
state_12484 = G__12517;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12502 = f__10977__auto__.call(null);
(statearr_12502[(6)] = c__10976__auto___12504);

return statearr_12502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__12519 = arguments.length;
switch (G__12519) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__10976__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12582){
var state_val_12583 = (state_12582[(1)]);
if((state_val_12583 === (7))){
var inst_12578 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12584_12623 = state_12582__$1;
(statearr_12584_12623[(2)] = inst_12578);

(statearr_12584_12623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (20))){
var inst_12548 = (state_12582[(7)]);
var inst_12559 = (state_12582[(2)]);
var inst_12560 = cljs.core.next.call(null,inst_12548);
var inst_12534 = inst_12560;
var inst_12535 = null;
var inst_12536 = (0);
var inst_12537 = (0);
var state_12582__$1 = (function (){var statearr_12585 = state_12582;
(statearr_12585[(8)] = inst_12535);

(statearr_12585[(9)] = inst_12536);

(statearr_12585[(10)] = inst_12534);

(statearr_12585[(11)] = inst_12537);

(statearr_12585[(12)] = inst_12559);

return statearr_12585;
})();
var statearr_12586_12624 = state_12582__$1;
(statearr_12586_12624[(2)] = null);

(statearr_12586_12624[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (1))){
var state_12582__$1 = state_12582;
var statearr_12587_12625 = state_12582__$1;
(statearr_12587_12625[(2)] = null);

(statearr_12587_12625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (4))){
var inst_12523 = (state_12582[(13)]);
var inst_12523__$1 = (state_12582[(2)]);
var inst_12524 = (inst_12523__$1 == null);
var state_12582__$1 = (function (){var statearr_12588 = state_12582;
(statearr_12588[(13)] = inst_12523__$1);

return statearr_12588;
})();
if(cljs.core.truth_(inst_12524)){
var statearr_12589_12626 = state_12582__$1;
(statearr_12589_12626[(1)] = (5));

} else {
var statearr_12590_12627 = state_12582__$1;
(statearr_12590_12627[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (15))){
var state_12582__$1 = state_12582;
var statearr_12594_12628 = state_12582__$1;
(statearr_12594_12628[(2)] = null);

(statearr_12594_12628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (21))){
var state_12582__$1 = state_12582;
var statearr_12595_12629 = state_12582__$1;
(statearr_12595_12629[(2)] = null);

(statearr_12595_12629[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (13))){
var inst_12535 = (state_12582[(8)]);
var inst_12536 = (state_12582[(9)]);
var inst_12534 = (state_12582[(10)]);
var inst_12537 = (state_12582[(11)]);
var inst_12544 = (state_12582[(2)]);
var inst_12545 = (inst_12537 + (1));
var tmp12591 = inst_12535;
var tmp12592 = inst_12536;
var tmp12593 = inst_12534;
var inst_12534__$1 = tmp12593;
var inst_12535__$1 = tmp12591;
var inst_12536__$1 = tmp12592;
var inst_12537__$1 = inst_12545;
var state_12582__$1 = (function (){var statearr_12596 = state_12582;
(statearr_12596[(8)] = inst_12535__$1);

(statearr_12596[(9)] = inst_12536__$1);

(statearr_12596[(10)] = inst_12534__$1);

(statearr_12596[(11)] = inst_12537__$1);

(statearr_12596[(14)] = inst_12544);

return statearr_12596;
})();
var statearr_12597_12630 = state_12582__$1;
(statearr_12597_12630[(2)] = null);

(statearr_12597_12630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (22))){
var state_12582__$1 = state_12582;
var statearr_12598_12631 = state_12582__$1;
(statearr_12598_12631[(2)] = null);

(statearr_12598_12631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (6))){
var inst_12523 = (state_12582[(13)]);
var inst_12532 = f.call(null,inst_12523);
var inst_12533 = cljs.core.seq.call(null,inst_12532);
var inst_12534 = inst_12533;
var inst_12535 = null;
var inst_12536 = (0);
var inst_12537 = (0);
var state_12582__$1 = (function (){var statearr_12599 = state_12582;
(statearr_12599[(8)] = inst_12535);

(statearr_12599[(9)] = inst_12536);

(statearr_12599[(10)] = inst_12534);

(statearr_12599[(11)] = inst_12537);

return statearr_12599;
})();
var statearr_12600_12632 = state_12582__$1;
(statearr_12600_12632[(2)] = null);

(statearr_12600_12632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (17))){
var inst_12548 = (state_12582[(7)]);
var inst_12552 = cljs.core.chunk_first.call(null,inst_12548);
var inst_12553 = cljs.core.chunk_rest.call(null,inst_12548);
var inst_12554 = cljs.core.count.call(null,inst_12552);
var inst_12534 = inst_12553;
var inst_12535 = inst_12552;
var inst_12536 = inst_12554;
var inst_12537 = (0);
var state_12582__$1 = (function (){var statearr_12601 = state_12582;
(statearr_12601[(8)] = inst_12535);

(statearr_12601[(9)] = inst_12536);

(statearr_12601[(10)] = inst_12534);

(statearr_12601[(11)] = inst_12537);

return statearr_12601;
})();
var statearr_12602_12633 = state_12582__$1;
(statearr_12602_12633[(2)] = null);

(statearr_12602_12633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (3))){
var inst_12580 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12582__$1,inst_12580);
} else {
if((state_val_12583 === (12))){
var inst_12568 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12603_12634 = state_12582__$1;
(statearr_12603_12634[(2)] = inst_12568);

(statearr_12603_12634[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (2))){
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12582__$1,(4),in$);
} else {
if((state_val_12583 === (23))){
var inst_12576 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12604_12635 = state_12582__$1;
(statearr_12604_12635[(2)] = inst_12576);

(statearr_12604_12635[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (19))){
var inst_12563 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12605_12636 = state_12582__$1;
(statearr_12605_12636[(2)] = inst_12563);

(statearr_12605_12636[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (11))){
var inst_12548 = (state_12582[(7)]);
var inst_12534 = (state_12582[(10)]);
var inst_12548__$1 = cljs.core.seq.call(null,inst_12534);
var state_12582__$1 = (function (){var statearr_12606 = state_12582;
(statearr_12606[(7)] = inst_12548__$1);

return statearr_12606;
})();
if(inst_12548__$1){
var statearr_12607_12637 = state_12582__$1;
(statearr_12607_12637[(1)] = (14));

} else {
var statearr_12608_12638 = state_12582__$1;
(statearr_12608_12638[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (9))){
var inst_12570 = (state_12582[(2)]);
var inst_12571 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_12582__$1 = (function (){var statearr_12609 = state_12582;
(statearr_12609[(15)] = inst_12570);

return statearr_12609;
})();
if(cljs.core.truth_(inst_12571)){
var statearr_12610_12639 = state_12582__$1;
(statearr_12610_12639[(1)] = (21));

} else {
var statearr_12611_12640 = state_12582__$1;
(statearr_12611_12640[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (5))){
var inst_12526 = cljs.core.async.close_BANG_.call(null,out);
var state_12582__$1 = state_12582;
var statearr_12612_12641 = state_12582__$1;
(statearr_12612_12641[(2)] = inst_12526);

(statearr_12612_12641[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (14))){
var inst_12548 = (state_12582[(7)]);
var inst_12550 = cljs.core.chunked_seq_QMARK_.call(null,inst_12548);
var state_12582__$1 = state_12582;
if(inst_12550){
var statearr_12613_12642 = state_12582__$1;
(statearr_12613_12642[(1)] = (17));

} else {
var statearr_12614_12643 = state_12582__$1;
(statearr_12614_12643[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (16))){
var inst_12566 = (state_12582[(2)]);
var state_12582__$1 = state_12582;
var statearr_12615_12644 = state_12582__$1;
(statearr_12615_12644[(2)] = inst_12566);

(statearr_12615_12644[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12583 === (10))){
var inst_12535 = (state_12582[(8)]);
var inst_12537 = (state_12582[(11)]);
var inst_12542 = cljs.core._nth.call(null,inst_12535,inst_12537);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12582__$1,(13),out,inst_12542);
} else {
if((state_val_12583 === (18))){
var inst_12548 = (state_12582[(7)]);
var inst_12557 = cljs.core.first.call(null,inst_12548);
var state_12582__$1 = state_12582;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12582__$1,(20),out,inst_12557);
} else {
if((state_val_12583 === (8))){
var inst_12536 = (state_12582[(9)]);
var inst_12537 = (state_12582[(11)]);
var inst_12539 = (inst_12537 < inst_12536);
var inst_12540 = inst_12539;
var state_12582__$1 = state_12582;
if(cljs.core.truth_(inst_12540)){
var statearr_12616_12645 = state_12582__$1;
(statearr_12616_12645[(1)] = (10));

} else {
var statearr_12617_12646 = state_12582__$1;
(statearr_12617_12646[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____0 = (function (){
var statearr_12618 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12618[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__);

(statearr_12618[(1)] = (1));

return statearr_12618;
});
var cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____1 = (function (state_12582){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12582);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12619){var ex__10906__auto__ = e12619;
var statearr_12620_12647 = state_12582;
(statearr_12620_12647[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12582[(4)]))){
var statearr_12621_12648 = state_12582;
(statearr_12621_12648[(1)] = cljs.core.first.call(null,(state_12582[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12649 = state_12582;
state_12582 = G__12649;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__ = function(state_12582){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____1.call(this,state_12582);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__10903__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12622 = f__10977__auto__.call(null);
(statearr_12622[(6)] = c__10976__auto__);

return statearr_12622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));

return c__10976__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__12651 = arguments.length;
switch (G__12651) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__12654 = arguments.length;
switch (G__12654) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__12657 = arguments.length;
switch (G__12657) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12705 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12681){
var state_val_12682 = (state_12681[(1)]);
if((state_val_12682 === (7))){
var inst_12676 = (state_12681[(2)]);
var state_12681__$1 = state_12681;
var statearr_12683_12706 = state_12681__$1;
(statearr_12683_12706[(2)] = inst_12676);

(statearr_12683_12706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (1))){
var inst_12658 = null;
var state_12681__$1 = (function (){var statearr_12684 = state_12681;
(statearr_12684[(7)] = inst_12658);

return statearr_12684;
})();
var statearr_12685_12707 = state_12681__$1;
(statearr_12685_12707[(2)] = null);

(statearr_12685_12707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (4))){
var inst_12661 = (state_12681[(8)]);
var inst_12661__$1 = (state_12681[(2)]);
var inst_12662 = (inst_12661__$1 == null);
var inst_12663 = cljs.core.not.call(null,inst_12662);
var state_12681__$1 = (function (){var statearr_12686 = state_12681;
(statearr_12686[(8)] = inst_12661__$1);

return statearr_12686;
})();
if(inst_12663){
var statearr_12687_12708 = state_12681__$1;
(statearr_12687_12708[(1)] = (5));

} else {
var statearr_12688_12709 = state_12681__$1;
(statearr_12688_12709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (6))){
var state_12681__$1 = state_12681;
var statearr_12689_12710 = state_12681__$1;
(statearr_12689_12710[(2)] = null);

(statearr_12689_12710[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (3))){
var inst_12678 = (state_12681[(2)]);
var inst_12679 = cljs.core.async.close_BANG_.call(null,out);
var state_12681__$1 = (function (){var statearr_12690 = state_12681;
(statearr_12690[(9)] = inst_12678);

return statearr_12690;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12681__$1,inst_12679);
} else {
if((state_val_12682 === (2))){
var state_12681__$1 = state_12681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12681__$1,(4),ch);
} else {
if((state_val_12682 === (11))){
var inst_12661 = (state_12681[(8)]);
var inst_12670 = (state_12681[(2)]);
var inst_12658 = inst_12661;
var state_12681__$1 = (function (){var statearr_12691 = state_12681;
(statearr_12691[(7)] = inst_12658);

(statearr_12691[(10)] = inst_12670);

return statearr_12691;
})();
var statearr_12692_12711 = state_12681__$1;
(statearr_12692_12711[(2)] = null);

(statearr_12692_12711[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (9))){
var inst_12661 = (state_12681[(8)]);
var state_12681__$1 = state_12681;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12681__$1,(11),out,inst_12661);
} else {
if((state_val_12682 === (5))){
var inst_12661 = (state_12681[(8)]);
var inst_12658 = (state_12681[(7)]);
var inst_12665 = cljs.core._EQ_.call(null,inst_12661,inst_12658);
var state_12681__$1 = state_12681;
if(inst_12665){
var statearr_12694_12712 = state_12681__$1;
(statearr_12694_12712[(1)] = (8));

} else {
var statearr_12695_12713 = state_12681__$1;
(statearr_12695_12713[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (10))){
var inst_12673 = (state_12681[(2)]);
var state_12681__$1 = state_12681;
var statearr_12696_12714 = state_12681__$1;
(statearr_12696_12714[(2)] = inst_12673);

(statearr_12696_12714[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12682 === (8))){
var inst_12658 = (state_12681[(7)]);
var tmp12693 = inst_12658;
var inst_12658__$1 = tmp12693;
var state_12681__$1 = (function (){var statearr_12697 = state_12681;
(statearr_12697[(7)] = inst_12658__$1);

return statearr_12697;
})();
var statearr_12698_12715 = state_12681__$1;
(statearr_12698_12715[(2)] = null);

(statearr_12698_12715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12699 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12699[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12699[(1)] = (1));

return statearr_12699;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12681){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12700){var ex__10906__auto__ = e12700;
var statearr_12701_12716 = state_12681;
(statearr_12701_12716[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12681[(4)]))){
var statearr_12702_12717 = state_12681;
(statearr_12702_12717[(1)] = cljs.core.first.call(null,(state_12681[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12718 = state_12681;
state_12681 = G__12718;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12681){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12703 = f__10977__auto__.call(null);
(statearr_12703[(6)] = c__10976__auto___12705);

return statearr_12703;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__12720 = arguments.length;
switch (G__12720) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12787 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12758){
var state_val_12759 = (state_12758[(1)]);
if((state_val_12759 === (7))){
var inst_12754 = (state_12758[(2)]);
var state_12758__$1 = state_12758;
var statearr_12760_12788 = state_12758__$1;
(statearr_12760_12788[(2)] = inst_12754);

(statearr_12760_12788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (1))){
var inst_12721 = (new Array(n));
var inst_12722 = inst_12721;
var inst_12723 = (0);
var state_12758__$1 = (function (){var statearr_12761 = state_12758;
(statearr_12761[(7)] = inst_12722);

(statearr_12761[(8)] = inst_12723);

return statearr_12761;
})();
var statearr_12762_12789 = state_12758__$1;
(statearr_12762_12789[(2)] = null);

(statearr_12762_12789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (4))){
var inst_12726 = (state_12758[(9)]);
var inst_12726__$1 = (state_12758[(2)]);
var inst_12727 = (inst_12726__$1 == null);
var inst_12728 = cljs.core.not.call(null,inst_12727);
var state_12758__$1 = (function (){var statearr_12763 = state_12758;
(statearr_12763[(9)] = inst_12726__$1);

return statearr_12763;
})();
if(inst_12728){
var statearr_12764_12790 = state_12758__$1;
(statearr_12764_12790[(1)] = (5));

} else {
var statearr_12765_12791 = state_12758__$1;
(statearr_12765_12791[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (15))){
var inst_12748 = (state_12758[(2)]);
var state_12758__$1 = state_12758;
var statearr_12766_12792 = state_12758__$1;
(statearr_12766_12792[(2)] = inst_12748);

(statearr_12766_12792[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (13))){
var state_12758__$1 = state_12758;
var statearr_12767_12793 = state_12758__$1;
(statearr_12767_12793[(2)] = null);

(statearr_12767_12793[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (6))){
var inst_12723 = (state_12758[(8)]);
var inst_12744 = (inst_12723 > (0));
var state_12758__$1 = state_12758;
if(cljs.core.truth_(inst_12744)){
var statearr_12768_12794 = state_12758__$1;
(statearr_12768_12794[(1)] = (12));

} else {
var statearr_12769_12795 = state_12758__$1;
(statearr_12769_12795[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (3))){
var inst_12756 = (state_12758[(2)]);
var state_12758__$1 = state_12758;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12758__$1,inst_12756);
} else {
if((state_val_12759 === (12))){
var inst_12722 = (state_12758[(7)]);
var inst_12746 = cljs.core.vec.call(null,inst_12722);
var state_12758__$1 = state_12758;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12758__$1,(15),out,inst_12746);
} else {
if((state_val_12759 === (2))){
var state_12758__$1 = state_12758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12758__$1,(4),ch);
} else {
if((state_val_12759 === (11))){
var inst_12738 = (state_12758[(2)]);
var inst_12739 = (new Array(n));
var inst_12722 = inst_12739;
var inst_12723 = (0);
var state_12758__$1 = (function (){var statearr_12770 = state_12758;
(statearr_12770[(7)] = inst_12722);

(statearr_12770[(10)] = inst_12738);

(statearr_12770[(8)] = inst_12723);

return statearr_12770;
})();
var statearr_12771_12796 = state_12758__$1;
(statearr_12771_12796[(2)] = null);

(statearr_12771_12796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (9))){
var inst_12722 = (state_12758[(7)]);
var inst_12736 = cljs.core.vec.call(null,inst_12722);
var state_12758__$1 = state_12758;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12758__$1,(11),out,inst_12736);
} else {
if((state_val_12759 === (5))){
var inst_12722 = (state_12758[(7)]);
var inst_12726 = (state_12758[(9)]);
var inst_12731 = (state_12758[(11)]);
var inst_12723 = (state_12758[(8)]);
var inst_12730 = (inst_12722[inst_12723] = inst_12726);
var inst_12731__$1 = (inst_12723 + (1));
var inst_12732 = (inst_12731__$1 < n);
var state_12758__$1 = (function (){var statearr_12772 = state_12758;
(statearr_12772[(12)] = inst_12730);

(statearr_12772[(11)] = inst_12731__$1);

return statearr_12772;
})();
if(cljs.core.truth_(inst_12732)){
var statearr_12773_12797 = state_12758__$1;
(statearr_12773_12797[(1)] = (8));

} else {
var statearr_12774_12798 = state_12758__$1;
(statearr_12774_12798[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (14))){
var inst_12751 = (state_12758[(2)]);
var inst_12752 = cljs.core.async.close_BANG_.call(null,out);
var state_12758__$1 = (function (){var statearr_12776 = state_12758;
(statearr_12776[(13)] = inst_12751);

return statearr_12776;
})();
var statearr_12777_12799 = state_12758__$1;
(statearr_12777_12799[(2)] = inst_12752);

(statearr_12777_12799[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (10))){
var inst_12742 = (state_12758[(2)]);
var state_12758__$1 = state_12758;
var statearr_12778_12800 = state_12758__$1;
(statearr_12778_12800[(2)] = inst_12742);

(statearr_12778_12800[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12759 === (8))){
var inst_12722 = (state_12758[(7)]);
var inst_12731 = (state_12758[(11)]);
var tmp12775 = inst_12722;
var inst_12722__$1 = tmp12775;
var inst_12723 = inst_12731;
var state_12758__$1 = (function (){var statearr_12779 = state_12758;
(statearr_12779[(7)] = inst_12722__$1);

(statearr_12779[(8)] = inst_12723);

return statearr_12779;
})();
var statearr_12780_12801 = state_12758__$1;
(statearr_12780_12801[(2)] = null);

(statearr_12780_12801[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12781 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12781[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12781[(1)] = (1));

return statearr_12781;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12758){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12758);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12782){var ex__10906__auto__ = e12782;
var statearr_12783_12802 = state_12758;
(statearr_12783_12802[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12758[(4)]))){
var statearr_12784_12803 = state_12758;
(statearr_12784_12803[(1)] = cljs.core.first.call(null,(state_12758[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12804 = state_12758;
state_12758 = G__12804;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12758){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12785 = f__10977__auto__.call(null);
(statearr_12785[(6)] = c__10976__auto___12787);

return statearr_12785;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__12806 = arguments.length;
switch (G__12806) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__10976__auto___12884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__10977__auto__ = (function (){var switch__10902__auto__ = (function (state_12851){
var state_val_12852 = (state_12851[(1)]);
if((state_val_12852 === (7))){
var inst_12847 = (state_12851[(2)]);
var state_12851__$1 = state_12851;
var statearr_12853_12885 = state_12851__$1;
(statearr_12853_12885[(2)] = inst_12847);

(statearr_12853_12885[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (1))){
var inst_12807 = [];
var inst_12808 = inst_12807;
var inst_12809 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_12851__$1 = (function (){var statearr_12854 = state_12851;
(statearr_12854[(7)] = inst_12808);

(statearr_12854[(8)] = inst_12809);

return statearr_12854;
})();
var statearr_12855_12886 = state_12851__$1;
(statearr_12855_12886[(2)] = null);

(statearr_12855_12886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (4))){
var inst_12812 = (state_12851[(9)]);
var inst_12812__$1 = (state_12851[(2)]);
var inst_12813 = (inst_12812__$1 == null);
var inst_12814 = cljs.core.not.call(null,inst_12813);
var state_12851__$1 = (function (){var statearr_12856 = state_12851;
(statearr_12856[(9)] = inst_12812__$1);

return statearr_12856;
})();
if(inst_12814){
var statearr_12857_12887 = state_12851__$1;
(statearr_12857_12887[(1)] = (5));

} else {
var statearr_12858_12888 = state_12851__$1;
(statearr_12858_12888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (15))){
var inst_12808 = (state_12851[(7)]);
var inst_12839 = cljs.core.vec.call(null,inst_12808);
var state_12851__$1 = state_12851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12851__$1,(18),out,inst_12839);
} else {
if((state_val_12852 === (13))){
var inst_12834 = (state_12851[(2)]);
var state_12851__$1 = state_12851;
var statearr_12859_12889 = state_12851__$1;
(statearr_12859_12889[(2)] = inst_12834);

(statearr_12859_12889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (6))){
var inst_12808 = (state_12851[(7)]);
var inst_12836 = inst_12808.length;
var inst_12837 = (inst_12836 > (0));
var state_12851__$1 = state_12851;
if(cljs.core.truth_(inst_12837)){
var statearr_12860_12890 = state_12851__$1;
(statearr_12860_12890[(1)] = (15));

} else {
var statearr_12861_12891 = state_12851__$1;
(statearr_12861_12891[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (17))){
var inst_12844 = (state_12851[(2)]);
var inst_12845 = cljs.core.async.close_BANG_.call(null,out);
var state_12851__$1 = (function (){var statearr_12862 = state_12851;
(statearr_12862[(10)] = inst_12844);

return statearr_12862;
})();
var statearr_12863_12892 = state_12851__$1;
(statearr_12863_12892[(2)] = inst_12845);

(statearr_12863_12892[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (3))){
var inst_12849 = (state_12851[(2)]);
var state_12851__$1 = state_12851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12851__$1,inst_12849);
} else {
if((state_val_12852 === (12))){
var inst_12808 = (state_12851[(7)]);
var inst_12827 = cljs.core.vec.call(null,inst_12808);
var state_12851__$1 = state_12851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12851__$1,(14),out,inst_12827);
} else {
if((state_val_12852 === (2))){
var state_12851__$1 = state_12851;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12851__$1,(4),ch);
} else {
if((state_val_12852 === (11))){
var inst_12808 = (state_12851[(7)]);
var inst_12812 = (state_12851[(9)]);
var inst_12816 = (state_12851[(11)]);
var inst_12824 = inst_12808.push(inst_12812);
var tmp12864 = inst_12808;
var inst_12808__$1 = tmp12864;
var inst_12809 = inst_12816;
var state_12851__$1 = (function (){var statearr_12865 = state_12851;
(statearr_12865[(7)] = inst_12808__$1);

(statearr_12865[(8)] = inst_12809);

(statearr_12865[(12)] = inst_12824);

return statearr_12865;
})();
var statearr_12866_12893 = state_12851__$1;
(statearr_12866_12893[(2)] = null);

(statearr_12866_12893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (9))){
var inst_12809 = (state_12851[(8)]);
var inst_12820 = cljs.core.keyword_identical_QMARK_.call(null,inst_12809,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_12851__$1 = state_12851;
var statearr_12867_12894 = state_12851__$1;
(statearr_12867_12894[(2)] = inst_12820);

(statearr_12867_12894[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (5))){
var inst_12809 = (state_12851[(8)]);
var inst_12817 = (state_12851[(13)]);
var inst_12812 = (state_12851[(9)]);
var inst_12816 = (state_12851[(11)]);
var inst_12816__$1 = f.call(null,inst_12812);
var inst_12817__$1 = cljs.core._EQ_.call(null,inst_12816__$1,inst_12809);
var state_12851__$1 = (function (){var statearr_12868 = state_12851;
(statearr_12868[(13)] = inst_12817__$1);

(statearr_12868[(11)] = inst_12816__$1);

return statearr_12868;
})();
if(inst_12817__$1){
var statearr_12869_12895 = state_12851__$1;
(statearr_12869_12895[(1)] = (8));

} else {
var statearr_12870_12896 = state_12851__$1;
(statearr_12870_12896[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (14))){
var inst_12812 = (state_12851[(9)]);
var inst_12816 = (state_12851[(11)]);
var inst_12829 = (state_12851[(2)]);
var inst_12830 = [];
var inst_12831 = inst_12830.push(inst_12812);
var inst_12808 = inst_12830;
var inst_12809 = inst_12816;
var state_12851__$1 = (function (){var statearr_12871 = state_12851;
(statearr_12871[(7)] = inst_12808);

(statearr_12871[(14)] = inst_12831);

(statearr_12871[(8)] = inst_12809);

(statearr_12871[(15)] = inst_12829);

return statearr_12871;
})();
var statearr_12872_12897 = state_12851__$1;
(statearr_12872_12897[(2)] = null);

(statearr_12872_12897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (16))){
var state_12851__$1 = state_12851;
var statearr_12873_12898 = state_12851__$1;
(statearr_12873_12898[(2)] = null);

(statearr_12873_12898[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (10))){
var inst_12822 = (state_12851[(2)]);
var state_12851__$1 = state_12851;
if(cljs.core.truth_(inst_12822)){
var statearr_12874_12899 = state_12851__$1;
(statearr_12874_12899[(1)] = (11));

} else {
var statearr_12875_12900 = state_12851__$1;
(statearr_12875_12900[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (18))){
var inst_12841 = (state_12851[(2)]);
var state_12851__$1 = state_12851;
var statearr_12876_12901 = state_12851__$1;
(statearr_12876_12901[(2)] = inst_12841);

(statearr_12876_12901[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12852 === (8))){
var inst_12817 = (state_12851[(13)]);
var state_12851__$1 = state_12851;
var statearr_12877_12902 = state_12851__$1;
(statearr_12877_12902[(2)] = inst_12817);

(statearr_12877_12902[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__10903__auto__ = null;
var cljs$core$async$state_machine__10903__auto____0 = (function (){
var statearr_12878 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12878[(0)] = cljs$core$async$state_machine__10903__auto__);

(statearr_12878[(1)] = (1));

return statearr_12878;
});
var cljs$core$async$state_machine__10903__auto____1 = (function (state_12851){
while(true){
var ret_value__10904__auto__ = (function (){try{while(true){
var result__10905__auto__ = switch__10902__auto__.call(null,state_12851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10905__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10905__auto__;
}
break;
}
}catch (e12879){var ex__10906__auto__ = e12879;
var statearr_12880_12903 = state_12851;
(statearr_12880_12903[(2)] = ex__10906__auto__);


if(cljs.core.seq.call(null,(state_12851[(4)]))){
var statearr_12881_12904 = state_12851;
(statearr_12881_12904[(1)] = cljs.core.first.call(null,(state_12851[(4)])));

} else {
throw ex__10906__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10904__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12905 = state_12851;
state_12851 = G__12905;
continue;
} else {
return ret_value__10904__auto__;
}
break;
}
});
cljs$core$async$state_machine__10903__auto__ = function(state_12851){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__10903__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__10903__auto____1.call(this,state_12851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__10903__auto____0;
cljs$core$async$state_machine__10903__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__10903__auto____1;
return cljs$core$async$state_machine__10903__auto__;
})()
})();
var state__10978__auto__ = (function (){var statearr_12882 = f__10977__auto__.call(null);
(statearr_12882[(6)] = c__10976__auto___12884);

return statearr_12882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10978__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

