// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('flureedb');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.api_js');
goog.require('fluree.db.connection_js');
cljs.core.enable_console_print_BANG_();
if((typeof flureedb !== 'undefined') && (typeof flureedb.app_state !== 'undefined')){
} else {
flureedb.app_state = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"FlureeDB APIs",new cljs.core.Keyword(null,"version","version",425292698),"v0.17.0"], null));
}
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(flureedb.app_state))], 0));
flureedb.on_js_reload = (function flureedb$on_js_reload(){
return null;
});
fluree.db.util.log.set_level_BANG_(new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *    1. level [Values: severe, warning, info, config, fine, finer, finest]
 *    
 */
flureedb.set_logging = (function flureedb$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var map__65738 = opts_SINGLEQUOTE_;
var map__65738__$1 = cljs.core.__destructure_map(map__65738);
var level = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65738__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(level));
});
goog.exportSymbol('flureedb.set_logging', flureedb.set_logging);
/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 */
flureedb.connect = (function flureedb$connect(var_args){
var G__65740 = arguments.length;
switch (G__65740) {
case 1:
return flureedb.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect', flureedb.connect);

(flureedb.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 *     supplied, separated by commas.
 * 
 *     Returns a promise that eventually contains the connection object.
 */
flureedb.connect_p = (function flureedb$connect_p(var_args){
var G__65743 = arguments.length;
switch (G__65743) {
case 1:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.connect_p', flureedb.connect_p);

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return flureedb.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(flureedb.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,opts_SINGLEQUOTE_);
}));

(flureedb.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
flureedb.close = (function flureedb$close(conn){
return fluree.db.connection_js.close(conn);
});
goog.exportSymbol('flureedb.close', flureedb.close);
/**
 * Authenticate with Fluree On-Demand
 */
flureedb.authenticate = (function flureedb$authenticate(var_args){
var G__65746 = arguments.length;
switch (G__65746) {
case 4:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.authenticate', flureedb.authenticate);

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return flureedb.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(flureedb.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,syncTo);
}));

(flureedb.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Attempts to generate a new user auth record account.
 */
flureedb.password_generate = (function flureedb$password_generate(var_args){
var G__65749 = arguments.length;
switch (G__65749) {
case 4:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_generate', flureedb.password_generate);

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureedb.password_generate.cljs$core$IFn$_invoke$arity$5(conn,ledger,password,user,null);
}));

(flureedb.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var opts_SINGLEQUOTE_ = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
var data = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_SINGLEQUOTE_,new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate(conn,ledger,password,data);
}));

(flureedb.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *    Must supply ledger, password and either user or auth identifier.
 *    Expire is optional
 *    - connection - connection object to server
 *    - ledger     - ledger identifier
 *    - password   - plain-text password
 *    - user       - _user/username (TODO: should allow any _user ident in the future)
 *    - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *    - expire     - requested time to expire in milliseconds
 */
flureedb.password_login = (function flureedb$password_login(var_args){
var G__65752 = arguments.length;
switch (G__65752) {
case 4:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureedb.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.password_login', flureedb.password_login);

(flureedb.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4(conn,ledger,password,user);
}));

(flureedb.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,auth,expire);
}));

(flureedb.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *    Returns a promise that eventually contains the token or an exception
 */
flureedb.renew_token = (function flureedb$renew_token(var_args){
var G__65755 = arguments.length;
switch (G__65755) {
case 2:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.renew_token', flureedb.renew_token);

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(flureedb.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,expire);
}));

(flureedb.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureedb.db = (function flureedb$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___65764 = arguments.length;
var i__4865__auto___65765 = (0);
while(true){
if((i__4865__auto___65765 < len__4864__auto___65764)){
args__4870__auto__.push((arguments[i__4865__auto___65765]));

var G__65766 = (i__4865__auto___65765 + (1));
i__4865__auto___65765 = G__65766;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return flureedb.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('flureedb.db', flureedb.db);

(flureedb.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__65760){
var vec__65761 = p__65760;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65761,(0),null);
var opts__$1 = (((opts == null))?null:cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts__$1);
}));

(flureedb.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureedb.db.cljs$lang$applyTo = (function (seq65757){
var G__65758 = cljs.core.first(seq65757);
var seq65757__$1 = cljs.core.next(seq65757);
var G__65759 = cljs.core.first(seq65757__$1);
var seq65757__$2 = cljs.core.next(seq65757__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65758,G__65759,seq65757__$2);
}));

/**
 * Returns db's schema map.
 */
flureedb.db_schema = (function flureedb$db_schema(db){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65785){
var state_val_65786 = (state_65785[(1)]);
if((state_val_65786 === (1))){
var state_65785__$1 = state_65785;
var statearr_65787_65802 = state_65785__$1;
(statearr_65787_65802[(2)] = null);

(statearr_65787_65802[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (2))){
var _ = (function (){var statearr_65788 = state_65785;
(statearr_65788[(4)] = cljs.core.cons((5),(state_65785[(4)])));

return statearr_65788;
})();
var state_65785__$1 = state_65785;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65785__$1,(6),db);
} else {
if((state_val_65786 === (3))){
var inst_65783 = (state_65785[(2)]);
var state_65785__$1 = state_65785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65785__$1,inst_65783);
} else {
if((state_val_65786 === (4))){
var inst_65767 = (state_65785[(2)]);
var inst_65768 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65767], 0));
var inst_65769 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65767) : reject.call(null,inst_65767));
var state_65785__$1 = (function (){var statearr_65790 = state_65785;
(statearr_65790[(7)] = inst_65768);

return statearr_65790;
})();
var statearr_65791_65803 = state_65785__$1;
(statearr_65791_65803[(2)] = inst_65769);

(statearr_65791_65803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (5))){
var _ = (function (){var statearr_65792 = state_65785;
(statearr_65792[(4)] = cljs.core.rest((state_65785[(4)])));

return statearr_65792;
})();
var state_65785__$1 = state_65785;
var ex65789 = (state_65785__$1[(2)]);
var statearr_65793_65804 = state_65785__$1;
(statearr_65793_65804[(5)] = ex65789);


var statearr_65794_65805 = state_65785__$1;
(statearr_65794_65805[(1)] = (4));

(statearr_65794_65805[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65786 === (6))){
var inst_65776 = (state_65785[(2)]);
var inst_65777 = fluree.db.util.async.throw_err(inst_65776);
var inst_65778 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_65777);
var inst_65779 = cljs.core.clj__GT_js(inst_65778);
var inst_65780 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65779) : resolve.call(null,inst_65779));
var _ = (function (){var statearr_65795 = state_65785;
(statearr_65795[(4)] = cljs.core.rest((state_65785[(4)])));

return statearr_65795;
})();
var state_65785__$1 = state_65785;
var statearr_65796_65806 = state_65785__$1;
(statearr_65796_65806[(2)] = inst_65780);

(statearr_65796_65806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$db_schema_$_state_machine__2741__auto__ = null;
var flureedb$db_schema_$_state_machine__2741__auto____0 = (function (){
var statearr_65797 = [null,null,null,null,null,null,null,null];
(statearr_65797[(0)] = flureedb$db_schema_$_state_machine__2741__auto__);

(statearr_65797[(1)] = (1));

return statearr_65797;
});
var flureedb$db_schema_$_state_machine__2741__auto____1 = (function (state_65785){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65785);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65798){var ex__2744__auto__ = e65798;
var statearr_65799_65807 = state_65785;
(statearr_65799_65807[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65785[(4)]))){
var statearr_65800_65808 = state_65785;
(statearr_65800_65808[(1)] = cljs.core.first((state_65785[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65809 = state_65785;
state_65785 = G__65809;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$db_schema_$_state_machine__2741__auto__ = function(state_65785){
switch(arguments.length){
case 0:
return flureedb$db_schema_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$db_schema_$_state_machine__2741__auto____1.call(this,state_65785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$db_schema_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$db_schema_$_state_machine__2741__auto____0;
flureedb$db_schema_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$db_schema_$_state_machine__2741__auto____1;
return flureedb$db_schema_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65801 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65801[(6)] = c__2763__auto__);

return statearr_65801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.db_schema', flureedb.db_schema);
/**
 * Completely deletes a ledger.
 *    Returns a promise that will have a response with a corresponding status of success.
 * 
 *    A 200 status indicates the deletion has been successfully initiated.
 *    The full deletion happens in the background on the respective ledger.
 * 
 *    Query servers get notified when this process initiates, and ledger will be marked as
 *    being in a deletion state during the deletion process.
 * 
 *    Attempts to use a ledger in a deletion state will throw an exception.
 */
flureedb.delete_ledger = (function flureedb$delete_ledger(var_args){
var G__65811 = arguments.length;
switch (G__65811) {
case 2:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.delete_ledger', flureedb.delete_ledger);

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65881){
var state_val_65882 = (state_65881[(1)]);
if((state_val_65882 === (7))){
var inst_65824 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_65881__$1 = state_65881;
var statearr_65883_65928 = state_65881__$1;
(statearr_65883_65928[(2)] = inst_65824);

(statearr_65883_65928[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (20))){
var inst_65832 = (state_65881[(7)]);
var inst_65856 = (state_65881[(2)]);
var state_65881__$1 = (function (){var statearr_65884 = state_65881;
(statearr_65884[(8)] = inst_65856);

return statearr_65884;
})();
if(cljs.core.truth_(inst_65832)){
var statearr_65885_65929 = state_65881__$1;
(statearr_65885_65929[(1)] = (21));

} else {
var statearr_65886_65930 = state_65881__$1;
(statearr_65886_65930[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (1))){
var state_65881__$1 = state_65881;
var statearr_65887_65931 = state_65881__$1;
(statearr_65887_65931[(2)] = null);

(statearr_65887_65931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (24))){
var inst_65863 = (state_65881[(2)]);
var inst_65864 = fluree.db.util.async.throw_err(inst_65863);
var state_65881__$1 = state_65881;
var statearr_65888_65932 = state_65881__$1;
(statearr_65888_65932[(2)] = inst_65864);

(statearr_65888_65932[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (4))){
var inst_65812 = (state_65881[(2)]);
var inst_65813 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65812], 0));
var inst_65814 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65812) : reject.call(null,inst_65812));
var state_65881__$1 = (function (){var statearr_65889 = state_65881;
(statearr_65889[(9)] = inst_65813);

return statearr_65889;
})();
var statearr_65890_65933 = state_65881__$1;
(statearr_65890_65933[(2)] = inst_65814);

(statearr_65890_65933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (15))){
var inst_65845 = (state_65881[(10)]);
var inst_65847 = fluree.db.util.core.without_nils(inst_65845);
var inst_65848 = fluree.db.util.json.stringify(inst_65847);
var state_65881__$1 = state_65881;
var statearr_65891_65934 = state_65881__$1;
(statearr_65891_65934[(2)] = inst_65848);

(statearr_65891_65934[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (21))){
var inst_65856 = (state_65881[(8)]);
var inst_65851 = (state_65881[(11)]);
var inst_65858 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_65859 = [inst_65851,inst_65856];
var inst_65860 = cljs.core.PersistentHashMap.fromArrays(inst_65858,inst_65859);
var inst_65861 = fluree.db.operations.command_async(conn,inst_65860);
var state_65881__$1 = state_65881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65881__$1,(24),inst_65861);
} else {
if((state_val_65882 === (13))){
var inst_65833 = (state_65881[(12)]);
var inst_65840 = (inst_65833 + (30000));
var state_65881__$1 = state_65881;
var statearr_65892_65935 = state_65881__$1;
(statearr_65892_65935[(2)] = inst_65840);

(statearr_65892_65935[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (22))){
var inst_65845 = (state_65881[(10)]);
var inst_65866 = fluree.db.operations.unsigned_command_async(conn,inst_65845);
var state_65881__$1 = state_65881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65881__$1,(25),inst_65866);
} else {
if((state_val_65882 === (6))){
var state_65881__$1 = state_65881;
var statearr_65893_65936 = state_65881__$1;
(statearr_65893_65936[(2)] = null);

(statearr_65893_65936[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (25))){
var inst_65868 = (state_65881[(2)]);
var inst_65869 = fluree.db.util.async.throw_err(inst_65868);
var state_65881__$1 = state_65881;
var statearr_65894_65937 = state_65881__$1;
(statearr_65894_65937[(2)] = inst_65869);

(statearr_65894_65937[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (17))){
var inst_65832 = (state_65881[(7)]);
var inst_65851 = (state_65881[(2)]);
var state_65881__$1 = (function (){var statearr_65895 = state_65881;
(statearr_65895[(11)] = inst_65851);

return statearr_65895;
})();
if(cljs.core.truth_(inst_65832)){
var statearr_65896_65938 = state_65881__$1;
(statearr_65896_65938[(1)] = (18));

} else {
var statearr_65897_65939 = state_65881__$1;
(statearr_65897_65939[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (3))){
var inst_65879 = (state_65881[(2)]);
var state_65881__$1 = state_65881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65881__$1,inst_65879);
} else {
if((state_val_65882 === (12))){
var inst_65830 = (state_65881[(13)]);
var state_65881__$1 = state_65881;
var statearr_65898_65940 = state_65881__$1;
(statearr_65898_65940[(2)] = inst_65830);

(statearr_65898_65940[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (2))){
var _ = (function (){var statearr_65899 = state_65881;
(statearr_65899[(4)] = cljs.core.cons((5),(state_65881[(4)])));

return statearr_65899;
})();
var inst_65821 = (opts == null);
var state_65881__$1 = state_65881;
if(cljs.core.truth_(inst_65821)){
var statearr_65900_65941 = state_65881__$1;
(statearr_65900_65941[(1)] = (6));

} else {
var statearr_65901_65942 = state_65881__$1;
(statearr_65901_65942[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (23))){
var inst_65871 = (state_65881[(2)]);
var inst_65872 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_65873 = [(200),inst_65871];
var inst_65874 = cljs.core.PersistentHashMap.fromArrays(inst_65872,inst_65873);
var inst_65875 = cljs.core.clj__GT_js(inst_65874);
var inst_65876 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65875) : resolve.call(null,inst_65875));
var _ = (function (){var statearr_65902 = state_65881;
(statearr_65902[(4)] = cljs.core.rest((state_65881[(4)])));

return statearr_65902;
})();
var state_65881__$1 = state_65881;
var statearr_65903_65943 = state_65881__$1;
(statearr_65903_65943[(2)] = inst_65876);

(statearr_65903_65943[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (19))){
var state_65881__$1 = state_65881;
var statearr_65904_65944 = state_65881__$1;
(statearr_65904_65944[(2)] = null);

(statearr_65904_65944[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (11))){
var inst_65830 = (state_65881[(13)]);
var inst_65837 = (state_65881[(2)]);
var state_65881__$1 = (function (){var statearr_65906 = state_65881;
(statearr_65906[(14)] = inst_65837);

return statearr_65906;
})();
if(cljs.core.truth_(inst_65830)){
var statearr_65907_65945 = state_65881__$1;
(statearr_65907_65945[(1)] = (12));

} else {
var statearr_65908_65946 = state_65881__$1;
(statearr_65908_65946[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (9))){
var inst_65829 = (state_65881[(15)]);
var state_65881__$1 = state_65881;
var statearr_65909_65947 = state_65881__$1;
(statearr_65909_65947[(2)] = inst_65829);

(statearr_65909_65947[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (5))){
var _ = (function (){var statearr_65910 = state_65881;
(statearr_65910[(4)] = cljs.core.rest((state_65881[(4)])));

return statearr_65910;
})();
var state_65881__$1 = state_65881;
var ex65905 = (state_65881__$1[(2)]);
var statearr_65911_65948 = state_65881__$1;
(statearr_65911_65948[(5)] = ex65905);


var statearr_65912_65949 = state_65881__$1;
(statearr_65912_65949[(1)] = (4));

(statearr_65912_65949[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (14))){
var inst_65837 = (state_65881[(14)]);
var inst_65832 = (state_65881[(7)]);
var inst_65842 = (state_65881[(2)]);
var inst_65843 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_65844 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_65837,inst_65842];
var inst_65845 = cljs.core.PersistentHashMap.fromArrays(inst_65843,inst_65844);
var state_65881__$1 = (function (){var statearr_65913 = state_65881;
(statearr_65913[(10)] = inst_65845);

return statearr_65913;
})();
if(cljs.core.truth_(inst_65832)){
var statearr_65914_65950 = state_65881__$1;
(statearr_65914_65950[(1)] = (15));

} else {
var statearr_65915_65951 = state_65881__$1;
(statearr_65915_65951[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (16))){
var state_65881__$1 = state_65881;
var statearr_65916_65952 = state_65881__$1;
(statearr_65916_65952[(2)] = null);

(statearr_65916_65952[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (10))){
var inst_65833 = (state_65881[(12)]);
var state_65881__$1 = state_65881;
var statearr_65917_65953 = state_65881__$1;
(statearr_65917_65953[(2)] = inst_65833);

(statearr_65917_65953[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (18))){
var inst_65832 = (state_65881[(7)]);
var inst_65851 = (state_65881[(11)]);
var inst_65853 = fluree.crypto.sign_message(inst_65851,inst_65832);
var state_65881__$1 = state_65881;
var statearr_65918_65954 = state_65881__$1;
(statearr_65918_65954[(2)] = inst_65853);

(statearr_65918_65954[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65882 === (8))){
var inst_65829 = (state_65881[(15)]);
var inst_65826 = (state_65881[(2)]);
var inst_65827 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_65826);
var inst_65828 = cljs.core.__destructure_map(inst_65826);
var inst_65829__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65828,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_65830 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65828,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65831 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65828,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65832 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65828,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65833 = fluree.db.util.core.current_time_millis();
var state_65881__$1 = (function (){var statearr_65919 = state_65881;
(statearr_65919[(16)] = inst_65827);

(statearr_65919[(15)] = inst_65829__$1);

(statearr_65919[(12)] = inst_65833);

(statearr_65919[(7)] = inst_65832);

(statearr_65919[(13)] = inst_65830);

(statearr_65919[(17)] = inst_65831);

return statearr_65919;
})();
if(cljs.core.truth_(inst_65829__$1)){
var statearr_65920_65955 = state_65881__$1;
(statearr_65920_65955[(1)] = (9));

} else {
var statearr_65921_65956 = state_65881__$1;
(statearr_65921_65956[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_65922 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65922[(0)] = flureedb$state_machine__2741__auto__);

(statearr_65922[(1)] = (1));

return statearr_65922;
});
var flureedb$state_machine__2741__auto____1 = (function (state_65881){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65881);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65923){var ex__2744__auto__ = e65923;
var statearr_65924_65957 = state_65881;
(statearr_65924_65957[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65881[(4)]))){
var statearr_65925_65958 = state_65881;
(statearr_65925_65958[(1)] = cljs.core.first((state_65881[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65959 = state_65881;
state_65881 = G__65959;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_65881){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_65881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65926 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65926[(6)] = c__2763__auto__);

return statearr_65926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise returning ledger's stats, including db size and # of flakes.
 *    If ledger doesn't exist, will return an empty map.
 */
flureedb.ledger_stats = (function flureedb$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65978){
var state_val_65979 = (state_65978[(1)]);
if((state_val_65979 === (1))){
var state_65978__$1 = state_65978;
var statearr_65980_65995 = state_65978__$1;
(statearr_65980_65995[(2)] = null);

(statearr_65980_65995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65979 === (2))){
var _ = (function (){var statearr_65981 = state_65978;
(statearr_65981[(4)] = cljs.core.cons((5),(state_65978[(4)])));

return statearr_65981;
})();
var inst_65968 = fluree.db.operations.ledger_stats_async(conn,ledger);
var state_65978__$1 = state_65978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65978__$1,(6),inst_65968);
} else {
if((state_val_65979 === (3))){
var inst_65976 = (state_65978[(2)]);
var state_65978__$1 = state_65978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65978__$1,inst_65976);
} else {
if((state_val_65979 === (4))){
var inst_65960 = (state_65978[(2)]);
var inst_65961 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65960], 0));
var inst_65962 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_65960) : reject.call(null,inst_65960));
var state_65978__$1 = (function (){var statearr_65983 = state_65978;
(statearr_65983[(7)] = inst_65961);

return statearr_65983;
})();
var statearr_65984_65996 = state_65978__$1;
(statearr_65984_65996[(2)] = inst_65962);

(statearr_65984_65996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65979 === (5))){
var _ = (function (){var statearr_65985 = state_65978;
(statearr_65985[(4)] = cljs.core.rest((state_65978[(4)])));

return statearr_65985;
})();
var state_65978__$1 = state_65978;
var ex65982 = (state_65978__$1[(2)]);
var statearr_65986_65997 = state_65978__$1;
(statearr_65986_65997[(5)] = ex65982);


var statearr_65987_65998 = state_65978__$1;
(statearr_65987_65998[(1)] = (4));

(statearr_65987_65998[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65979 === (6))){
var inst_65970 = (state_65978[(2)]);
var inst_65971 = fluree.db.util.async.throw_err(inst_65970);
var inst_65972 = cljs.core.clj__GT_js(inst_65971);
var inst_65973 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_65972) : resolve.call(null,inst_65972));
var _ = (function (){var statearr_65988 = state_65978;
(statearr_65988[(4)] = cljs.core.rest((state_65978[(4)])));

return statearr_65988;
})();
var state_65978__$1 = state_65978;
var statearr_65989_65999 = state_65978__$1;
(statearr_65989_65999[(2)] = inst_65973);

(statearr_65989_65999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$ledger_stats_$_state_machine__2741__auto__ = null;
var flureedb$ledger_stats_$_state_machine__2741__auto____0 = (function (){
var statearr_65990 = [null,null,null,null,null,null,null,null];
(statearr_65990[(0)] = flureedb$ledger_stats_$_state_machine__2741__auto__);

(statearr_65990[(1)] = (1));

return statearr_65990;
});
var flureedb$ledger_stats_$_state_machine__2741__auto____1 = (function (state_65978){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65978);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65991){var ex__2744__auto__ = e65991;
var statearr_65992_66000 = state_65978;
(statearr_65992_66000[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65978[(4)]))){
var statearr_65993_66001 = state_65978;
(statearr_65993_66001[(1)] = cljs.core.first((state_65978[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66002 = state_65978;
state_65978 = G__66002;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$ledger_stats_$_state_machine__2741__auto__ = function(state_65978){
switch(arguments.length){
case 0:
return flureedb$ledger_stats_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$ledger_stats_$_state_machine__2741__auto____1.call(this,state_65978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$ledger_stats_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$ledger_stats_$_state_machine__2741__auto____0;
flureedb$ledger_stats_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$ledger_stats_$_state_machine__2741__auto____1;
return flureedb$ledger_stats_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65994 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65994[(6)] = c__2763__auto__);

return statearr_65994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.ledger_stats', flureedb.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 *     A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 *     Once successful, will return with a command-id.
 * 
 *     Ledger creation is handled asynchronously and may not be immediately available.
 * 
 *     Options include:
 *     - :alias       - Alias, if different than db-ident.
 *     - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 *     - :doc         - Optional doc string about this db.
 *     - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 *     - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 *     - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 *     - :jwt         - token for Fluree On-Demand access
 *     
 */
flureedb.new_ledger = (function flureedb$new_ledger(var_args){
var G__66004 = arguments.length;
switch (G__66004) {
case 2:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.new_ledger', flureedb.new_ledger);

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(flureedb.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66128){
var state_val_66129 = (state_66128[(1)]);
if((state_val_66129 === (7))){
var inst_66027 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66128__$1 = state_66128;
var statearr_66130_66200 = state_66128__$1;
(statearr_66130_66200[(2)] = inst_66027);

(statearr_66130_66200[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (20))){
var inst_66034 = (state_66128[(7)]);
var inst_66073 = (state_66128[(2)]);
var inst_66074 = fluree.db.util.core.current_time_millis();
var state_66128__$1 = (function (){var statearr_66131 = state_66128;
(statearr_66131[(8)] = inst_66073);

(statearr_66131[(9)] = inst_66074);

return statearr_66131;
})();
if(cljs.core.truth_(inst_66034)){
var statearr_66132_66201 = state_66128__$1;
(statearr_66132_66201[(1)] = (21));

} else {
var statearr_66133_66202 = state_66128__$1;
(statearr_66133_66202[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (27))){
var inst_66087 = (state_66128[(10)]);
var inst_66042 = (state_66128[(11)]);
var inst_66089 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66087,new cljs.core.Keyword(null,"jwt","jwt",1504015441),inst_66042);
var state_66128__$1 = state_66128;
var statearr_66134_66203 = state_66128__$1;
(statearr_66134_66203[(2)] = inst_66089);

(statearr_66134_66203[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (1))){
var state_66128__$1 = state_66128;
var statearr_66135_66204 = state_66128__$1;
(statearr_66135_66204[(2)] = null);

(statearr_66135_66204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (24))){
var inst_66040 = (state_66128[(12)]);
var state_66128__$1 = state_66128;
var statearr_66136_66205 = state_66128__$1;
(statearr_66136_66205[(2)] = inst_66040);

(statearr_66136_66205[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (39))){
var inst_66110 = (state_66128[(2)]);
var inst_66111 = fluree.db.util.async.throw_err(inst_66110);
var state_66128__$1 = state_66128;
var statearr_66137_66206 = state_66128__$1;
(statearr_66137_66206[(2)] = inst_66111);

(statearr_66137_66206[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (4))){
var inst_66005 = (state_66128[(2)]);
var inst_66006 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66005], 0));
var inst_66007 = cljs.core.ex_data(inst_66005);
var inst_66008 = cljs.core.ex_message(inst_66005);
var inst_66009 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66007,new cljs.core.Keyword(null,"message","message",-406056002),inst_66008);
var inst_66010 = cljs.core.clj__GT_js(inst_66009);
var inst_66011 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66010) : reject.call(null,inst_66010));
var state_66128__$1 = (function (){var statearr_66138 = state_66128;
(statearr_66138[(13)] = inst_66006);

return statearr_66138;
})();
var statearr_66139_66207 = state_66128__$1;
(statearr_66139_66207[(2)] = inst_66011);

(statearr_66139_66207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (15))){
var inst_66063 = (state_66128[(14)]);
var inst_66065 = fluree.db.graphdb.validate_ledger_name(inst_66063,"alias");
var state_66128__$1 = state_66128;
var statearr_66140_66208 = state_66128__$1;
(statearr_66140_66208[(2)] = inst_66065);

(statearr_66140_66208[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (21))){
var inst_66034 = (state_66128[(7)]);
var state_66128__$1 = state_66128;
var statearr_66141_66209 = state_66128__$1;
(statearr_66141_66209[(2)] = inst_66034);

(statearr_66141_66209[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (31))){
var state_66128__$1 = state_66128;
var statearr_66142_66210 = state_66128__$1;
(statearr_66142_66210[(2)] = null);

(statearr_66142_66210[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (32))){
var inst_66036 = (state_66128[(15)]);
var inst_66098 = (state_66128[(2)]);
var state_66128__$1 = (function (){var statearr_66143 = state_66128;
(statearr_66143[(16)] = inst_66098);

return statearr_66143;
})();
if(cljs.core.truth_(inst_66036)){
var statearr_66144_66211 = state_66128__$1;
(statearr_66144_66211[(1)] = (33));

} else {
var statearr_66145_66212 = state_66128__$1;
(statearr_66145_66212[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (40))){
var inst_66115 = (state_66128[(2)]);
var inst_66116 = fluree.db.util.async.throw_err(inst_66115);
var state_66128__$1 = state_66128;
var statearr_66146_66213 = state_66128__$1;
(statearr_66146_66213[(2)] = inst_66116);

(statearr_66146_66213[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (33))){
var inst_66036 = (state_66128[(15)]);
var inst_66098 = (state_66128[(16)]);
var inst_66100 = fluree.crypto.sign_message(inst_66098,inst_66036);
var state_66128__$1 = state_66128;
var statearr_66147_66214 = state_66128__$1;
(statearr_66147_66214[(2)] = inst_66100);

(statearr_66147_66214[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (13))){
var state_66128__$1 = state_66128;
var statearr_66148_66215 = state_66128__$1;
(statearr_66148_66215[(2)] = null);

(statearr_66148_66215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (22))){
var inst_66074 = (state_66128[(9)]);
var state_66128__$1 = state_66128;
var statearr_66149_66216 = state_66128__$1;
(statearr_66149_66216[(2)] = inst_66074);

(statearr_66149_66216[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (36))){
var inst_66098 = (state_66128[(16)]);
var inst_66103 = (state_66128[(17)]);
var inst_66105 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_66106 = [inst_66098,inst_66103];
var inst_66107 = cljs.core.PersistentHashMap.fromArrays(inst_66105,inst_66106);
var inst_66108 = fluree.db.operations.command_async(conn,inst_66107);
var state_66128__$1 = state_66128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66128__$1,(39),inst_66108);
} else {
if((state_val_66129 === (29))){
var inst_66036 = (state_66128[(15)]);
var inst_66092 = (state_66128[(2)]);
var state_66128__$1 = (function (){var statearr_66150 = state_66128;
(statearr_66150[(18)] = inst_66092);

return statearr_66150;
})();
if(cljs.core.truth_(inst_66036)){
var statearr_66151_66217 = state_66128__$1;
(statearr_66151_66217[(1)] = (30));

} else {
var statearr_66152_66218 = state_66128__$1;
(statearr_66152_66218[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (6))){
var state_66128__$1 = state_66128;
var statearr_66153_66219 = state_66128__$1;
(statearr_66153_66219[(2)] = null);

(statearr_66153_66219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (28))){
var inst_66087 = (state_66128[(10)]);
var state_66128__$1 = state_66128;
var statearr_66154_66220 = state_66128__$1;
(statearr_66154_66220[(2)] = inst_66087);

(statearr_66154_66220[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (25))){
var inst_66074 = (state_66128[(9)]);
var inst_66081 = (inst_66074 + (30000));
var state_66128__$1 = state_66128;
var statearr_66155_66221 = state_66128__$1;
(statearr_66155_66221[(2)] = inst_66081);

(statearr_66155_66221[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (34))){
var state_66128__$1 = state_66128;
var statearr_66156_66222 = state_66128__$1;
(statearr_66156_66222[(2)] = null);

(statearr_66156_66222[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (17))){
var inst_66044 = (state_66128[(19)]);
var inst_66068 = (state_66128[(2)]);
var state_66128__$1 = (function (){var statearr_66157 = state_66128;
(statearr_66157[(20)] = inst_66068);

return statearr_66157;
})();
if(cljs.core.truth_(inst_66044)){
var statearr_66158_66223 = state_66128__$1;
(statearr_66158_66223[(1)] = (18));

} else {
var statearr_66159_66224 = state_66128__$1;
(statearr_66159_66224[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (3))){
var inst_66126 = (state_66128[(2)]);
var state_66128__$1 = state_66128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66128__$1,inst_66126);
} else {
if((state_val_66129 === (12))){
var inst_66058 = fluree.db.graphdb.validate_ledger_ident(ledger);
var state_66128__$1 = state_66128;
var statearr_66160_66225 = state_66128__$1;
(statearr_66160_66225[(2)] = inst_66058);

(statearr_66160_66225[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (2))){
var _ = (function (){var statearr_66161 = state_66128;
(statearr_66161[(4)] = cljs.core.cons((5),(state_66128[(4)])));

return statearr_66161;
})();
var inst_66024 = (opts == null);
var state_66128__$1 = state_66128;
if(cljs.core.truth_(inst_66024)){
var statearr_66162_66226 = state_66128__$1;
(statearr_66162_66226[(1)] = (6));

} else {
var statearr_66163_66227 = state_66128__$1;
(statearr_66163_66227[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (23))){
var inst_66040 = (state_66128[(12)]);
var inst_66078 = (state_66128[(2)]);
var state_66128__$1 = (function (){var statearr_66164 = state_66128;
(statearr_66164[(21)] = inst_66078);

return statearr_66164;
})();
if(cljs.core.truth_(inst_66040)){
var statearr_66165_66228 = state_66128__$1;
(statearr_66165_66228[(1)] = (24));

} else {
var statearr_66166_66229 = state_66128__$1;
(statearr_66166_66229[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (35))){
var inst_66036 = (state_66128[(15)]);
var inst_66103 = (state_66128[(2)]);
var state_66128__$1 = (function (){var statearr_66167 = state_66128;
(statearr_66167[(17)] = inst_66103);

return statearr_66167;
})();
if(cljs.core.truth_(inst_66036)){
var statearr_66168_66230 = state_66128__$1;
(statearr_66168_66230[(1)] = (36));

} else {
var statearr_66169_66231 = state_66128__$1;
(statearr_66169_66231[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (19))){
var state_66128__$1 = state_66128;
var statearr_66170_66232 = state_66128__$1;
(statearr_66170_66232[(2)] = null);

(statearr_66170_66232[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (11))){
var inst_66054 = (state_66128[(22)]);
var inst_66044 = (state_66128[(19)]);
var inst_66047 = (state_66128[(23)]);
var inst_66054__$1 = (state_66128[(2)]);
var inst_66055 = fluree.db.graphdb.validate_ledger_name(inst_66054__$1,"ledger");
var inst_66056 = fluree.db.graphdb.validate_ledger_name(inst_66047,"network");
var state_66128__$1 = (function (){var statearr_66172 = state_66128;
(statearr_66172[(22)] = inst_66054__$1);

(statearr_66172[(24)] = inst_66056);

(statearr_66172[(25)] = inst_66055);

return statearr_66172;
})();
if(cljs.core.truth_(inst_66044)){
var statearr_66173_66233 = state_66128__$1;
(statearr_66173_66233[(1)] = (12));

} else {
var statearr_66174_66234 = state_66128__$1;
(statearr_66174_66234[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (9))){
var inst_66048 = (state_66128[(26)]);
var inst_66051 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_66048,(1));
var state_66128__$1 = state_66128;
var statearr_66175_66235 = state_66128__$1;
(statearr_66175_66235[(2)] = inst_66051);

(statearr_66175_66235[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (5))){
var _ = (function (){var statearr_66176 = state_66128;
(statearr_66176[(4)] = cljs.core.rest((state_66128[(4)])));

return statearr_66176;
})();
var state_66128__$1 = state_66128;
var ex66171 = (state_66128__$1[(2)]);
var statearr_66177_66236 = state_66128__$1;
(statearr_66177_66236[(5)] = ex66171);


var statearr_66178_66237 = state_66128__$1;
(statearr_66178_66237[(1)] = (4));

(statearr_66178_66237[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (14))){
var inst_66044 = (state_66128[(19)]);
var inst_66061 = (state_66128[(2)]);
var inst_66062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66061,(0),null);
var inst_66063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66061,(1),null);
var state_66128__$1 = (function (){var statearr_66179 = state_66128;
(statearr_66179[(14)] = inst_66063);

(statearr_66179[(27)] = inst_66062);

return statearr_66179;
})();
if(cljs.core.truth_(inst_66044)){
var statearr_66180_66238 = state_66128__$1;
(statearr_66180_66238[(1)] = (15));

} else {
var statearr_66181_66239 = state_66128__$1;
(statearr_66181_66239[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (26))){
var inst_66033 = (state_66128[(28)]);
var inst_66054 = (state_66128[(22)]);
var inst_66039 = (state_66128[(29)]);
var inst_66043 = (state_66128[(30)]);
var inst_66073 = (state_66128[(8)]);
var inst_66078 = (state_66128[(21)]);
var inst_66038 = (state_66128[(31)]);
var inst_66047 = (state_66128[(23)]);
var inst_66035 = (state_66128[(32)]);
var inst_66041 = (state_66128[(33)]);
var inst_66042 = (state_66128[(11)]);
var inst_66037 = (state_66128[(34)]);
var inst_66045 = (state_66128[(35)]);
var inst_66083 = (state_66128[(2)]);
var inst_66084 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_66085 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66047),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66054)].join('');
var inst_66086 = [inst_66085,inst_66038,inst_66039,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_66083,inst_66041,inst_66073,inst_66045,inst_66043,inst_66033,inst_66078,inst_66035,inst_66037];
var inst_66087 = cljs.core.PersistentHashMap.fromArrays(inst_66084,inst_66086);
var state_66128__$1 = (function (){var statearr_66182 = state_66128;
(statearr_66182[(10)] = inst_66087);

return statearr_66182;
})();
if(cljs.core.truth_(inst_66042)){
var statearr_66183_66240 = state_66128__$1;
(statearr_66183_66240[(1)] = (27));

} else {
var statearr_66184_66241 = state_66128__$1;
(statearr_66184_66241[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (16))){
var state_66128__$1 = state_66128;
var statearr_66185_66242 = state_66128__$1;
(statearr_66185_66242[(2)] = null);

(statearr_66185_66242[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (38))){
var inst_66118 = (state_66128[(2)]);
var inst_66119 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_66120 = [(200),inst_66118];
var inst_66121 = cljs.core.PersistentHashMap.fromArrays(inst_66119,inst_66120);
var inst_66122 = cljs.core.clj__GT_js(inst_66121);
var inst_66123 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66122) : resolve.call(null,inst_66122));
var _ = (function (){var statearr_66186 = state_66128;
(statearr_66186[(4)] = cljs.core.rest((state_66128[(4)])));

return statearr_66186;
})();
var state_66128__$1 = state_66128;
var statearr_66187_66243 = state_66128__$1;
(statearr_66187_66243[(2)] = inst_66123);

(statearr_66187_66243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (30))){
var inst_66092 = (state_66128[(18)]);
var inst_66094 = fluree.db.util.core.without_nils(inst_66092);
var inst_66095 = fluree.db.util.json.stringify(inst_66094);
var state_66128__$1 = state_66128;
var statearr_66188_66244 = state_66128__$1;
(statearr_66188_66244[(2)] = inst_66095);

(statearr_66188_66244[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (10))){
var inst_66048 = (state_66128[(26)]);
var state_66128__$1 = state_66128;
var statearr_66189_66245 = state_66128__$1;
(statearr_66189_66245[(2)] = inst_66048);

(statearr_66189_66245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (18))){
var inst_66063 = (state_66128[(14)]);
var inst_66062 = (state_66128[(27)]);
var inst_66070 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66062),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66063)].join('');
var state_66128__$1 = state_66128;
var statearr_66190_66246 = state_66128__$1;
(statearr_66190_66246[(2)] = inst_66070);

(statearr_66190_66246[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66129 === (37))){
var inst_66092 = (state_66128[(18)]);
var inst_66113 = fluree.db.operations.unsigned_command_async(conn,inst_66092);
var state_66128__$1 = state_66128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66128__$1,(40),inst_66113);
} else {
if((state_val_66129 === (8))){
var inst_66048 = (state_66128[(26)]);
var inst_66029 = (state_66128[(2)]);
var inst_66030 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66029);
var inst_66031 = cljs.core.__destructure_map(inst_66029);
var inst_66032 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66031,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_66033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_66034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_66035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_66036 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_66037 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_66038 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_66039 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_66040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_66041 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_66043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_66044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_66045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66031,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_66046 = fluree.db.graphdb.validate_ledger_ident(ledger);
var inst_66047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66046,(0),null);
var inst_66048__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66046,(1),null);
var inst_66049 = clojure.string.starts_with_QMARK_(inst_66048__$1,"$");
var state_66128__$1 = (function (){var statearr_66191 = state_66128;
(statearr_66191[(15)] = inst_66036);

(statearr_66191[(36)] = inst_66030);

(statearr_66191[(28)] = inst_66033);

(statearr_66191[(29)] = inst_66039);

(statearr_66191[(19)] = inst_66044);

(statearr_66191[(30)] = inst_66043);

(statearr_66191[(31)] = inst_66038);

(statearr_66191[(37)] = inst_66032);

(statearr_66191[(23)] = inst_66047);

(statearr_66191[(32)] = inst_66035);

(statearr_66191[(12)] = inst_66040);

(statearr_66191[(33)] = inst_66041);

(statearr_66191[(11)] = inst_66042);

(statearr_66191[(7)] = inst_66034);

(statearr_66191[(34)] = inst_66037);

(statearr_66191[(35)] = inst_66045);

(statearr_66191[(26)] = inst_66048__$1);

return statearr_66191;
})();
if(inst_66049){
var statearr_66192_66247 = state_66128__$1;
(statearr_66192_66247[(1)] = (9));

} else {
var statearr_66193_66248 = state_66128__$1;
(statearr_66193_66248[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66194[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66194[(1)] = (1));

return statearr_66194;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66128){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66128);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66195){var ex__2744__auto__ = e66195;
var statearr_66196_66249 = state_66128;
(statearr_66196_66249[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66128[(4)]))){
var statearr_66197_66250 = state_66128;
(statearr_66197_66250[(1)] = cljs.core.first((state_66128[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66251 = state_66128;
state_66128 = G__66251;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66128){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66198 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66198[(6)] = c__2763__auto__);

return statearr_66198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *    Returns a promise that will eventually contain a response or an exception
 *    if the timeout period has expired.
 * 
 *    Response may contain an exception, if the tx resulted in an exception.
 */
flureedb.monitor_tx = (function flureedb$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66271){
var state_val_66272 = (state_66271[(1)]);
if((state_val_66272 === (1))){
var state_66271__$1 = state_66271;
var statearr_66273_66289 = state_66271__$1;
(statearr_66273_66289[(2)] = null);

(statearr_66273_66289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66272 === (2))){
var _ = (function (){var statearr_66274 = state_66271;
(statearr_66274[(4)] = cljs.core.cons((5),(state_66271[(4)])));

return statearr_66274;
})();
var inst_66261 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1(conn);
var inst_66262 = fluree.db.api_js.monitor_tx(conn,ledger,txid,timeout_ms);
var state_66271__$1 = (function (){var statearr_66275 = state_66271;
(statearr_66275[(7)] = inst_66261);

return statearr_66275;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66271__$1,(6),inst_66262);
} else {
if((state_val_66272 === (3))){
var inst_66269 = (state_66271[(2)]);
var state_66271__$1 = state_66271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66271__$1,inst_66269);
} else {
if((state_val_66272 === (4))){
var inst_66252 = (state_66271[(2)]);
var inst_66253 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66252], 0));
var inst_66254 = cljs.core.clj__GT_js(inst_66252);
var inst_66255 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66254) : reject.call(null,inst_66254));
var state_66271__$1 = (function (){var statearr_66277 = state_66271;
(statearr_66277[(8)] = inst_66253);

return statearr_66277;
})();
var statearr_66278_66290 = state_66271__$1;
(statearr_66278_66290[(2)] = inst_66255);

(statearr_66278_66290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66272 === (5))){
var _ = (function (){var statearr_66279 = state_66271;
(statearr_66279[(4)] = cljs.core.rest((state_66271[(4)])));

return statearr_66279;
})();
var state_66271__$1 = state_66271;
var ex66276 = (state_66271__$1[(2)]);
var statearr_66280_66291 = state_66271__$1;
(statearr_66280_66291[(5)] = ex66276);


var statearr_66281_66292 = state_66271__$1;
(statearr_66281_66292[(1)] = (4));

(statearr_66281_66292[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66272 === (6))){
var inst_66264 = (state_66271[(2)]);
var inst_66265 = cljs.core.clj__GT_js(inst_66264);
var inst_66266 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66265) : resolve.call(null,inst_66265));
var _ = (function (){var statearr_66282 = state_66271;
(statearr_66282[(4)] = cljs.core.rest((state_66271[(4)])));

return statearr_66282;
})();
var state_66271__$1 = state_66271;
var statearr_66283_66293 = state_66271__$1;
(statearr_66283_66293[(2)] = inst_66266);

(statearr_66283_66293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$monitor_tx_$_state_machine__2741__auto__ = null;
var flureedb$monitor_tx_$_state_machine__2741__auto____0 = (function (){
var statearr_66284 = [null,null,null,null,null,null,null,null,null];
(statearr_66284[(0)] = flureedb$monitor_tx_$_state_machine__2741__auto__);

(statearr_66284[(1)] = (1));

return statearr_66284;
});
var flureedb$monitor_tx_$_state_machine__2741__auto____1 = (function (state_66271){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66271);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66285){var ex__2744__auto__ = e66285;
var statearr_66286_66294 = state_66271;
(statearr_66286_66294[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66271[(4)]))){
var statearr_66287_66295 = state_66271;
(statearr_66287_66295[(1)] = cljs.core.first((state_66271[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66296 = state_66271;
state_66271 = G__66296;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$monitor_tx_$_state_machine__2741__auto__ = function(state_66271){
switch(arguments.length){
case 0:
return flureedb$monitor_tx_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$monitor_tx_$_state_machine__2741__auto____1.call(this,state_66271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$monitor_tx_$_state_machine__2741__auto____0;
flureedb$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$monitor_tx_$_state_machine__2741__auto____1;
return flureedb$monitor_tx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66288 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66288[(6)] = c__2763__auto__);

return statearr_66288;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.monitor_tx', flureedb.monitor_tx);
/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 *     that will eventually have the result of the tx, the txid (if :txid-only option used), or
 *     an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 *     Will locally sign a final transaction command if a private key is provided via :private-key
 *     in the options, otherwise will submit the transaction to the connected ledger and request signature,
 *     provided the ledger group has a default private key available for signing.
 * 
 *     Options (opts) is a map with the following possible keys:
 *     - private-key - The private key to use for signing. If not present, a default
 *                     private key will attempt to be used from the connection, if available.
 *     - auth        - The auth id for the auth record being used. The private key must
 *                     correspond to this auth record, or an authority of this auth record.
 *     - expire      - When this transaction should expire if not yet attempted.
 *                     Defaults to 5 minutes.
 *     - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                     By default epoch milliseconds is used.
 *     - deps        - List of one or more txids that must be successfully processed before
 *                     this tx is processed. If any fail, this tx will fail. (not yet implemented)
 *     - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                     but instead return with the txid once it is successfully persisted by the
 *                     transactors. The txid can be used to look up/monitor the response at a later time.
 *     - timeout     - will respond with an exception if timeout reached before response available.
 *     - jwt         - token to access Fluree On-Demand
 *     
 */
flureedb.transact = (function flureedb$transact(var_args){
var G__66298 = arguments.length;
switch (G__66298) {
case 3:
return flureedb.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.transact', flureedb.transact);

(flureedb.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureedb.transact.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(flureedb.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66324){
var state_val_66325 = (state_66324[(1)]);
if((state_val_66325 === (7))){
var inst_66310 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66324__$1 = state_66324;
var statearr_66326_66347 = state_66324__$1;
(statearr_66326_66347[(2)] = inst_66310);

(statearr_66326_66347[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (1))){
var state_66324__$1 = state_66324;
var statearr_66327_66348 = state_66324__$1;
(statearr_66327_66348[(2)] = null);

(statearr_66327_66348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (4))){
var inst_66299 = (state_66324[(2)]);
var inst_66300 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66299], 0));
var inst_66301 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66299) : reject.call(null,inst_66299));
var state_66324__$1 = (function (){var statearr_66328 = state_66324;
(statearr_66328[(7)] = inst_66300);

return statearr_66328;
})();
var statearr_66329_66349 = state_66324__$1;
(statearr_66329_66349[(2)] = inst_66301);

(statearr_66329_66349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (6))){
var state_66324__$1 = state_66324;
var statearr_66330_66350 = state_66324__$1;
(statearr_66330_66350[(2)] = null);

(statearr_66330_66350[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (3))){
var inst_66322 = (state_66324[(2)]);
var state_66324__$1 = state_66324;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66324__$1,inst_66322);
} else {
if((state_val_66325 === (2))){
var _ = (function (){var statearr_66332 = state_66324;
(statearr_66332[(4)] = cljs.core.cons((5),(state_66324[(4)])));

return statearr_66332;
})();
var inst_66307 = (opts == null);
var state_66324__$1 = state_66324;
if(cljs.core.truth_(inst_66307)){
var statearr_66333_66351 = state_66324__$1;
(statearr_66333_66351[(1)] = (6));

} else {
var statearr_66334_66352 = state_66324__$1;
(statearr_66334_66352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (9))){
var inst_66317 = (state_66324[(2)]);
var inst_66318 = cljs.core.clj__GT_js(inst_66317);
var inst_66319 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66318) : resolve.call(null,inst_66318));
var _ = (function (){var statearr_66335 = state_66324;
(statearr_66335[(4)] = cljs.core.rest((state_66324[(4)])));

return statearr_66335;
})();
var state_66324__$1 = state_66324;
var statearr_66336_66353 = state_66324__$1;
(statearr_66336_66353[(2)] = inst_66319);

(statearr_66336_66353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (5))){
var _ = (function (){var statearr_66337 = state_66324;
(statearr_66337[(4)] = cljs.core.rest((state_66324[(4)])));

return statearr_66337;
})();
var state_66324__$1 = state_66324;
var ex66331 = (state_66324__$1[(2)]);
var statearr_66338_66354 = state_66324__$1;
(statearr_66338_66354[(5)] = ex66331);


var statearr_66339_66355 = state_66324__$1;
(statearr_66339_66355[(1)] = (4));

(statearr_66339_66355[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66325 === (8))){
var inst_66312 = (state_66324[(2)]);
var inst_66313 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66312);
var inst_66314 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(txn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66315 = fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66314,inst_66312);
var state_66324__$1 = (function (){var statearr_66340 = state_66324;
(statearr_66340[(8)] = inst_66313);

return statearr_66340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66324__$1,(9),inst_66315);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66341 = [null,null,null,null,null,null,null,null,null];
(statearr_66341[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66341[(1)] = (1));

return statearr_66341;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66324){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66324);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66342){var ex__2744__auto__ = e66342;
var statearr_66343_66356 = state_66324;
(statearr_66343_66356[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66324[(4)]))){
var statearr_66344_66357 = state_66324;
(statearr_66344_66357[(1)] = cljs.core.first((state_66324[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66358 = state_66324;
state_66324 = G__66358;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66324){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66345 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66345[(6)] = c__2763__auto__);

return statearr_66345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain blocks from start block (inclusive)
 *    to end if provided (inclusive). Each block is a separate map, containing keys :block,
 *    :t and :flakes.
 */
flureedb.block_range = (function flureedb$block_range(var_args){
var G__66360 = arguments.length;
switch (G__66360) {
case 3:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range', flureedb.block_range);

(flureedb.block_range.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,start){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,start,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,start,end){
return flureedb.block_range.cljs$core$IFn$_invoke$arity$5(conn,ledger,start,end,null);
}));

(flureedb.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66389){
var state_val_66390 = (state_66389[(1)]);
if((state_val_66390 === (7))){
var inst_66372 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66389__$1 = state_66389;
var statearr_66391_66412 = state_66389__$1;
(statearr_66391_66412[(2)] = inst_66372);

(statearr_66391_66412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (1))){
var state_66389__$1 = state_66389;
var statearr_66392_66413 = state_66389__$1;
(statearr_66392_66413[(2)] = null);

(statearr_66392_66413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (4))){
var inst_66361 = (state_66389[(2)]);
var inst_66362 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66361], 0));
var inst_66363 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66361) : reject.call(null,inst_66361));
var state_66389__$1 = (function (){var statearr_66393 = state_66389;
(statearr_66393[(7)] = inst_66362);

return statearr_66393;
})();
var statearr_66394_66414 = state_66389__$1;
(statearr_66394_66414[(2)] = inst_66363);

(statearr_66394_66414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (6))){
var state_66389__$1 = state_66389;
var statearr_66395_66415 = state_66389__$1;
(statearr_66395_66415[(2)] = null);

(statearr_66395_66415[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (3))){
var inst_66387 = (state_66389[(2)]);
var state_66389__$1 = state_66389;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66389__$1,inst_66387);
} else {
if((state_val_66390 === (2))){
var _ = (function (){var statearr_66397 = state_66389;
(statearr_66397[(4)] = cljs.core.cons((5),(state_66389[(4)])));

return statearr_66397;
})();
var inst_66369 = (opts == null);
var state_66389__$1 = state_66389;
if(cljs.core.truth_(inst_66369)){
var statearr_66398_66416 = state_66389__$1;
(statearr_66398_66416[(1)] = (6));

} else {
var statearr_66399_66417 = state_66389__$1;
(statearr_66399_66417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (9))){
var inst_66374 = (state_66389[(8)]);
var inst_66377 = (state_66389[(2)]);
var inst_66378 = fluree.db.util.async.throw_err(inst_66377);
var inst_66379 = fluree.db.query.block.block_range(inst_66378,start,end,inst_66374);
var state_66389__$1 = state_66389;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66389__$1,(10),inst_66379);
} else {
if((state_val_66390 === (5))){
var _ = (function (){var statearr_66400 = state_66389;
(statearr_66400[(4)] = cljs.core.rest((state_66389[(4)])));

return statearr_66400;
})();
var state_66389__$1 = state_66389;
var ex66396 = (state_66389__$1[(2)]);
var statearr_66401_66418 = state_66389__$1;
(statearr_66401_66418[(5)] = ex66396);


var statearr_66402_66419 = state_66389__$1;
(statearr_66402_66419[(1)] = (4));

(statearr_66402_66419[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (10))){
var inst_66381 = (state_66389[(2)]);
var inst_66382 = fluree.db.util.async.throw_err(inst_66381);
var inst_66383 = cljs.core.clj__GT_js(inst_66382);
var inst_66384 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66383) : resolve.call(null,inst_66383));
var _ = (function (){var statearr_66403 = state_66389;
(statearr_66403[(4)] = cljs.core.rest((state_66389[(4)])));

return statearr_66403;
})();
var state_66389__$1 = state_66389;
var statearr_66404_66420 = state_66389__$1;
(statearr_66404_66420[(2)] = inst_66384);

(statearr_66404_66420[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66390 === (8))){
var inst_66374 = (state_66389[(8)]);
var inst_66374__$1 = (state_66389[(2)]);
var inst_66375 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66374__$1], 0));
var state_66389__$1 = (function (){var statearr_66405 = state_66389;
(statearr_66405[(8)] = inst_66374__$1);

return statearr_66405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66389__$1,(9),inst_66375);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66406 = [null,null,null,null,null,null,null,null,null];
(statearr_66406[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66406[(1)] = (1));

return statearr_66406;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66389){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66389);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66407){var ex__2744__auto__ = e66407;
var statearr_66408_66421 = state_66389;
(statearr_66408_66421[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66389[(4)]))){
var statearr_66409_66422 = state_66389;
(statearr_66409_66422[(1)] = cljs.core.first((state_66389[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66423 = state_66389;
state_66389 = G__66423;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66389){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66410 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66410[(6)] = c__2763__auto__);

return statearr_66410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 *     start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 *     containing keys :block :tx
 */
flureedb.block_range_with_txn = (function flureedb$block_range_with_txn(var_args){
var G__66425 = arguments.length;
switch (G__66425) {
case 3:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_range_with_txn', flureedb.block_range_with_txn);

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4(conn,ledger,block_map,null);
}));

(flureedb.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66460){
var state_val_66461 = (state_66460[(1)]);
if((state_val_66461 === (7))){
var inst_66438 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66460__$1 = state_66460;
var statearr_66462_66483 = state_66460__$1;
(statearr_66462_66483[(2)] = inst_66438);

(statearr_66462_66483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (1))){
var state_66460__$1 = state_66460;
var statearr_66463_66484 = state_66460__$1;
(statearr_66463_66484[(2)] = null);

(statearr_66463_66484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (4))){
var inst_66426 = (state_66460[(2)]);
var inst_66427 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66426], 0));
var inst_66428 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66426) : reject.call(null,inst_66426));
var state_66460__$1 = (function (){var statearr_66464 = state_66460;
(statearr_66464[(7)] = inst_66427);

return statearr_66464;
})();
var statearr_66465_66485 = state_66460__$1;
(statearr_66465_66485[(2)] = inst_66428);

(statearr_66465_66485[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (6))){
var state_66460__$1 = state_66460;
var statearr_66466_66486 = state_66460__$1;
(statearr_66466_66486[(2)] = null);

(statearr_66466_66486[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (3))){
var inst_66458 = (state_66460[(2)]);
var state_66460__$1 = state_66460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66460__$1,inst_66458);
} else {
if((state_val_66461 === (2))){
var _ = (function (){var statearr_66468 = state_66460;
(statearr_66468[(4)] = cljs.core.cons((5),(state_66460[(4)])));

return statearr_66468;
})();
var inst_66435 = (opts == null);
var state_66460__$1 = state_66460;
if(cljs.core.truth_(inst_66435)){
var statearr_66469_66487 = state_66460__$1;
(statearr_66469_66487[(1)] = (6));

} else {
var statearr_66470_66488 = state_66460__$1;
(statearr_66470_66488[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (9))){
var inst_66440 = (state_66460[(8)]);
var inst_66443 = (state_66460[(9)]);
var inst_66444 = (state_66460[(10)]);
var inst_66447 = (state_66460[(2)]);
var inst_66448 = fluree.db.util.async.throw_err(inst_66447);
var inst_66449 = fluree.db.query.block.block_range(inst_66448,inst_66443,inst_66444,inst_66440);
var state_66460__$1 = state_66460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66460__$1,(10),inst_66449);
} else {
if((state_val_66461 === (5))){
var _ = (function (){var statearr_66471 = state_66460;
(statearr_66471[(4)] = cljs.core.rest((state_66460[(4)])));

return statearr_66471;
})();
var state_66460__$1 = state_66460;
var ex66467 = (state_66460__$1[(2)]);
var statearr_66472_66489 = state_66460__$1;
(statearr_66472_66489[(5)] = ex66467);


var statearr_66473_66490 = state_66460__$1;
(statearr_66473_66490[(1)] = (4));

(statearr_66473_66490[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (10))){
var inst_66451 = (state_66460[(2)]);
var inst_66452 = fluree.db.util.async.throw_err(inst_66451);
var inst_66453 = fluree.db.query.range.block_with_tx_data(inst_66452);
var inst_66454 = cljs.core.clj__GT_js(inst_66453);
var inst_66455 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66454) : resolve.call(null,inst_66454));
var _ = (function (){var statearr_66474 = state_66460;
(statearr_66474[(4)] = cljs.core.rest((state_66460[(4)])));

return statearr_66474;
})();
var state_66460__$1 = state_66460;
var statearr_66475_66491 = state_66460__$1;
(statearr_66475_66491[(2)] = inst_66455);

(statearr_66475_66491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66461 === (8))){
var inst_66440 = (state_66460[(8)]);
var inst_66440__$1 = (state_66460[(2)]);
var inst_66441 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(block_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66442 = cljs.core.__destructure_map(inst_66441);
var inst_66443 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66442,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_66444 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66442,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_66445 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66440__$1], 0));
var state_66460__$1 = (function (){var statearr_66476 = state_66460;
(statearr_66476[(8)] = inst_66440__$1);

(statearr_66476[(9)] = inst_66443);

(statearr_66476[(10)] = inst_66444);

return statearr_66476;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66460__$1,(9),inst_66445);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66477 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_66477[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66477[(1)] = (1));

return statearr_66477;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66460){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66460);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66478){var ex__2744__auto__ = e66478;
var statearr_66479_66492 = state_66460;
(statearr_66479_66492[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66460[(4)]))){
var statearr_66480_66493 = state_66460;
(statearr_66480_66493[(1)] = cljs.core.first((state_66460[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66494 = state_66460;
state_66460 = G__66494;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66460){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66481 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66481[(6)] = c__2763__auto__);

return statearr_66481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureedb.block_query = (function flureedb$block_query(var_args){
var G__66496 = arguments.length;
switch (G__66496) {
case 3:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.block_query', flureedb.block_query);

(flureedb.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.block_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66563){
var state_val_66564 = (state_66563[(1)]);
if((state_val_66564 === (7))){
var inst_66509 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66563__$1 = state_66563;
var statearr_66565_66606 = state_66563__$1;
(statearr_66565_66606[(2)] = inst_66509);

(statearr_66565_66606[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (20))){
var inst_66505 = (state_66563[(7)]);
var inst_66511 = (state_66563[(8)]);
var inst_66547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66548 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66549 = (new cljs.core.PersistentVector(null,1,(5),inst_66547,inst_66548,null));
var inst_66550 = cljs.core.assoc_in(inst_66511,inst_66549,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66551 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66505,inst_66550);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66563__$1,(23),inst_66551);
} else {
if((state_val_66564 === (1))){
var state_66563__$1 = state_66563;
var statearr_66566_66607 = state_66563__$1;
(statearr_66566_66607[(2)] = null);

(statearr_66566_66607[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (4))){
var inst_66497 = (state_66563[(2)]);
var inst_66498 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66497], 0));
var inst_66499 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66497) : reject.call(null,inst_66497));
var state_66563__$1 = (function (){var statearr_66567 = state_66563;
(statearr_66567[(9)] = inst_66498);

return statearr_66567;
})();
var statearr_66568_66608 = state_66563__$1;
(statearr_66568_66608[(2)] = inst_66499);

(statearr_66568_66608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (15))){
var inst_66535 = (state_66563[(2)]);
var inst_66536 = fluree.db.util.async.throw_err(inst_66535);
var state_66563__$1 = state_66563;
var statearr_66569_66609 = state_66563__$1;
(statearr_66569_66609[(2)] = inst_66536);

(statearr_66569_66609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (21))){
var inst_66556 = (state_66563[(2)]);
var inst_66557 = cljs.core.clj__GT_js(inst_66556);
var inst_66558 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66557) : resolve.call(null,inst_66557));
var _ = (function (){var statearr_66570 = state_66563;
(statearr_66570[(4)] = cljs.core.rest((state_66563[(4)])));

return statearr_66570;
})();
var state_66563__$1 = state_66563;
var statearr_66571_66610 = state_66563__$1;
(statearr_66571_66610[(2)] = inst_66558);

(statearr_66571_66610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (13))){
var state_66563__$1 = state_66563;
var statearr_66572_66611 = state_66563__$1;
(statearr_66572_66611[(2)] = null);

(statearr_66572_66611[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (22))){
var inst_66544 = (state_66563[(2)]);
var inst_66545 = fluree.db.util.async.throw_err(inst_66544);
var state_66563__$1 = state_66563;
var statearr_66573_66612 = state_66563__$1;
(statearr_66573_66612[(2)] = inst_66545);

(statearr_66573_66612[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (6))){
var state_66563__$1 = state_66563;
var statearr_66574_66613 = state_66563__$1;
(statearr_66574_66613[(2)] = null);

(statearr_66574_66613[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (17))){
var state_66563__$1 = state_66563;
var statearr_66575_66614 = state_66563__$1;
(statearr_66575_66614[(2)] = null);

(statearr_66575_66614[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (3))){
var inst_66561 = (state_66563[(2)]);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66563__$1,inst_66561);
} else {
if((state_val_66564 === (12))){
var inst_66519 = (state_66563[(10)]);
var inst_66523 = [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var state_66563__$1 = (function (){var statearr_66576 = state_66563;
(statearr_66576[(11)] = inst_66523);

return statearr_66576;
})();
if(cljs.core.truth_(inst_66519)){
var statearr_66577_66615 = state_66563__$1;
(statearr_66577_66615[(1)] = (16));

} else {
var statearr_66578_66616 = state_66563__$1;
(statearr_66578_66616[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (2))){
var _ = (function (){var statearr_66579 = state_66563;
(statearr_66579[(4)] = cljs.core.cons((5),(state_66563[(4)])));

return statearr_66579;
})();
var inst_66505 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66506 = (opts == null);
var state_66563__$1 = (function (){var statearr_66580 = state_66563;
(statearr_66580[(7)] = inst_66505);

return statearr_66580;
})();
if(cljs.core.truth_(inst_66506)){
var statearr_66581_66617 = state_66563__$1;
(statearr_66581_66617[(1)] = (6));

} else {
var statearr_66582_66618 = state_66563__$1;
(statearr_66582_66618[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (23))){
var inst_66553 = (state_66563[(2)]);
var inst_66554 = fluree.db.util.async.throw_err(inst_66553);
var state_66563__$1 = state_66563;
var statearr_66583_66619 = state_66563__$1;
(statearr_66583_66619[(2)] = inst_66554);

(statearr_66583_66619[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (19))){
var inst_66505 = (state_66563[(7)]);
var inst_66539 = (state_66563[(12)]);
var inst_66511 = (state_66563[(8)]);
var inst_66542 = fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(inst_66539,inst_66505,inst_66511);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66563__$1,(22),inst_66542);
} else {
if((state_val_66564 === (11))){
var inst_66511 = (state_66563[(8)]);
var inst_66513 = (state_66563[(13)]);
var inst_66519 = (state_66563[(2)]);
var inst_66520 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_66511);
var inst_66521 = (inst_66513 == null);
var state_66563__$1 = (function (){var statearr_66585 = state_66563;
(statearr_66585[(14)] = inst_66520);

(statearr_66585[(10)] = inst_66519);

return statearr_66585;
})();
if(cljs.core.truth_(inst_66521)){
var statearr_66586_66620 = state_66563__$1;
(statearr_66586_66620[(1)] = (12));

} else {
var statearr_66587_66621 = state_66563__$1;
(statearr_66587_66621[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (9))){
var inst_66514 = (state_66563[(15)]);
var state_66563__$1 = state_66563;
var statearr_66588_66622 = state_66563__$1;
(statearr_66588_66622[(2)] = inst_66514);

(statearr_66588_66622[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (5))){
var _ = (function (){var statearr_66589 = state_66563;
(statearr_66589[(4)] = cljs.core.rest((state_66563[(4)])));

return statearr_66589;
})();
var state_66563__$1 = state_66563;
var ex66584 = (state_66563__$1[(2)]);
var statearr_66590_66623 = state_66563__$1;
(statearr_66590_66623[(5)] = ex66584);


var statearr_66591_66624 = state_66563__$1;
(statearr_66591_66624[(1)] = (4));

(statearr_66591_66624[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (14))){
var inst_66513 = (state_66563[(13)]);
var inst_66539 = (state_66563[(2)]);
var inst_66540 = (inst_66513 == null);
var state_66563__$1 = (function (){var statearr_66592 = state_66563;
(statearr_66592[(12)] = inst_66539);

return statearr_66592;
})();
if(cljs.core.truth_(inst_66540)){
var statearr_66593_66625 = state_66563__$1;
(statearr_66593_66625[(1)] = (19));

} else {
var statearr_66594_66626 = state_66563__$1;
(statearr_66594_66626[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (16))){
var inst_66519 = (state_66563[(10)]);
var inst_66525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66526 = ["_auth/id",inst_66519];
var inst_66527 = (new cljs.core.PersistentVector(null,2,(5),inst_66525,inst_66526,null));
var state_66563__$1 = state_66563;
var statearr_66595_66627 = state_66563__$1;
(statearr_66595_66627[(2)] = inst_66527);

(statearr_66595_66627[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (10))){
var inst_66511 = (state_66563[(8)]);
var inst_66517 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_66511);
var state_66563__$1 = state_66563;
var statearr_66596_66628 = state_66563__$1;
(statearr_66596_66628[(2)] = inst_66517);

(statearr_66596_66628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66564 === (18))){
var inst_66520 = (state_66563[(14)]);
var inst_66523 = (state_66563[(11)]);
var inst_66530 = (state_66563[(2)]);
var inst_66531 = [inst_66530,inst_66520];
var inst_66532 = cljs.core.PersistentHashMap.fromArrays(inst_66523,inst_66531);
var inst_66533 = fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic(conn,ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66532], 0));
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66563__$1,(15),inst_66533);
} else {
if((state_val_66564 === (8))){
var inst_66511 = (state_66563[(8)]);
var inst_66514 = (state_66563[(15)]);
var inst_66511__$1 = (state_66563[(2)]);
var inst_66512 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,inst_66511__$1);
var inst_66513 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(inst_66511__$1);
var inst_66514__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_66511__$1);
var state_66563__$1 = (function (){var statearr_66597 = state_66563;
(statearr_66597[(8)] = inst_66511__$1);

(statearr_66597[(15)] = inst_66514__$1);

(statearr_66597[(13)] = inst_66513);

(statearr_66597[(16)] = inst_66512);

return statearr_66597;
})();
if(cljs.core.truth_(inst_66514__$1)){
var statearr_66598_66629 = state_66563__$1;
(statearr_66598_66629[(1)] = (9));

} else {
var statearr_66599_66630 = state_66563__$1;
(statearr_66599_66630[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66600[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66600[(1)] = (1));

return statearr_66600;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66563){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66563);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66601){var ex__2744__auto__ = e66601;
var statearr_66602_66631 = state_66563;
(statearr_66602_66631[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66563[(4)]))){
var statearr_66603_66632 = state_66563;
(statearr_66603_66632[(1)] = cljs.core.first((state_66563[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66633 = state_66563;
state_66563 = G__66633;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66563){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66604 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66604[(6)] = c__2763__auto__);

return statearr_66604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.block_query.cljs$lang$maxFixedArity = 4);

flureedb.history_query = (function flureedb$history_query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66653){
var state_val_66654 = (state_66653[(1)]);
if((state_val_66654 === (1))){
var state_66653__$1 = state_66653;
var statearr_66655_66670 = state_66653__$1;
(statearr_66655_66670[(2)] = null);

(statearr_66655_66670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (2))){
var _ = (function (){var statearr_66656 = state_66653;
(statearr_66656[(4)] = cljs.core.cons((5),(state_66653[(4)])));

return statearr_66656;
})();
var inst_66642 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66643 = fluree.db.api.query.history_query_async(sources,inst_66642);
var state_66653__$1 = state_66653;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66653__$1,(6),inst_66643);
} else {
if((state_val_66654 === (3))){
var inst_66651 = (state_66653[(2)]);
var state_66653__$1 = state_66653;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66653__$1,inst_66651);
} else {
if((state_val_66654 === (4))){
var inst_66634 = (state_66653[(2)]);
var inst_66635 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66634], 0));
var inst_66636 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66634) : reject.call(null,inst_66634));
var state_66653__$1 = (function (){var statearr_66658 = state_66653;
(statearr_66658[(7)] = inst_66635);

return statearr_66658;
})();
var statearr_66659_66671 = state_66653__$1;
(statearr_66659_66671[(2)] = inst_66636);

(statearr_66659_66671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (5))){
var _ = (function (){var statearr_66660 = state_66653;
(statearr_66660[(4)] = cljs.core.rest((state_66653[(4)])));

return statearr_66660;
})();
var state_66653__$1 = state_66653;
var ex66657 = (state_66653__$1[(2)]);
var statearr_66661_66672 = state_66653__$1;
(statearr_66661_66672[(5)] = ex66657);


var statearr_66662_66673 = state_66653__$1;
(statearr_66662_66673[(1)] = (4));

(statearr_66662_66673[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66654 === (6))){
var inst_66645 = (state_66653[(2)]);
var inst_66646 = fluree.db.util.async.throw_err(inst_66645);
var inst_66647 = cljs.core.clj__GT_js(inst_66646);
var inst_66648 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66647) : resolve.call(null,inst_66647));
var _ = (function (){var statearr_66663 = state_66653;
(statearr_66663[(4)] = cljs.core.rest((state_66653[(4)])));

return statearr_66663;
})();
var state_66653__$1 = state_66653;
var statearr_66664_66674 = state_66653__$1;
(statearr_66664_66674[(2)] = inst_66648);

(statearr_66664_66674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$history_query_$_state_machine__2741__auto__ = null;
var flureedb$history_query_$_state_machine__2741__auto____0 = (function (){
var statearr_66665 = [null,null,null,null,null,null,null,null];
(statearr_66665[(0)] = flureedb$history_query_$_state_machine__2741__auto__);

(statearr_66665[(1)] = (1));

return statearr_66665;
});
var flureedb$history_query_$_state_machine__2741__auto____1 = (function (state_66653){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66653);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66666){var ex__2744__auto__ = e66666;
var statearr_66667_66675 = state_66653;
(statearr_66667_66675[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66653[(4)]))){
var statearr_66668_66676 = state_66653;
(statearr_66668_66676[(1)] = cljs.core.first((state_66653[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66677 = state_66653;
state_66653 = G__66677;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$history_query_$_state_machine__2741__auto__ = function(state_66653){
switch(arguments.length){
case 0:
return flureedb$history_query_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$history_query_$_state_machine__2741__auto____1.call(this,state_66653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$history_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$history_query_$_state_machine__2741__auto____0;
flureedb$history_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$history_query_$_state_machine__2741__auto____1;
return flureedb$history_query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66669 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66669[(6)] = c__2763__auto__);

return statearr_66669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.history_query', flureedb.history_query);
flureedb.multi_query = (function flureedb$multi_query(sources,multi_query_map){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66697){
var state_val_66698 = (state_66697[(1)]);
if((state_val_66698 === (1))){
var state_66697__$1 = state_66697;
var statearr_66699_66714 = state_66697__$1;
(statearr_66699_66714[(2)] = null);

(statearr_66699_66714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66698 === (2))){
var _ = (function (){var statearr_66700 = state_66697;
(statearr_66700[(4)] = cljs.core.cons((5),(state_66697[(4)])));

return statearr_66700;
})();
var inst_66686 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(multi_query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66687 = fluree.db.api.query.multi_query_async(sources,inst_66686);
var state_66697__$1 = state_66697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66697__$1,(6),inst_66687);
} else {
if((state_val_66698 === (3))){
var inst_66695 = (state_66697[(2)]);
var state_66697__$1 = state_66697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66697__$1,inst_66695);
} else {
if((state_val_66698 === (4))){
var inst_66678 = (state_66697[(2)]);
var inst_66679 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66678], 0));
var inst_66680 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66678) : reject.call(null,inst_66678));
var state_66697__$1 = (function (){var statearr_66702 = state_66697;
(statearr_66702[(7)] = inst_66679);

return statearr_66702;
})();
var statearr_66703_66715 = state_66697__$1;
(statearr_66703_66715[(2)] = inst_66680);

(statearr_66703_66715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66698 === (5))){
var _ = (function (){var statearr_66704 = state_66697;
(statearr_66704[(4)] = cljs.core.rest((state_66697[(4)])));

return statearr_66704;
})();
var state_66697__$1 = state_66697;
var ex66701 = (state_66697__$1[(2)]);
var statearr_66705_66716 = state_66697__$1;
(statearr_66705_66716[(5)] = ex66701);


var statearr_66706_66717 = state_66697__$1;
(statearr_66706_66717[(1)] = (4));

(statearr_66706_66717[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66698 === (6))){
var inst_66689 = (state_66697[(2)]);
var inst_66690 = fluree.db.util.async.throw_err(inst_66689);
var inst_66691 = cljs.core.clj__GT_js(inst_66690);
var inst_66692 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66691) : resolve.call(null,inst_66691));
var _ = (function (){var statearr_66707 = state_66697;
(statearr_66707[(4)] = cljs.core.rest((state_66697[(4)])));

return statearr_66707;
})();
var state_66697__$1 = state_66697;
var statearr_66708_66718 = state_66697__$1;
(statearr_66708_66718[(2)] = inst_66692);

(statearr_66708_66718[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$multi_query_$_state_machine__2741__auto__ = null;
var flureedb$multi_query_$_state_machine__2741__auto____0 = (function (){
var statearr_66709 = [null,null,null,null,null,null,null,null];
(statearr_66709[(0)] = flureedb$multi_query_$_state_machine__2741__auto__);

(statearr_66709[(1)] = (1));

return statearr_66709;
});
var flureedb$multi_query_$_state_machine__2741__auto____1 = (function (state_66697){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66697);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66710){var ex__2744__auto__ = e66710;
var statearr_66711_66719 = state_66697;
(statearr_66711_66719[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66697[(4)]))){
var statearr_66712_66720 = state_66697;
(statearr_66712_66720[(1)] = cljs.core.first((state_66697[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66721 = state_66697;
state_66697 = G__66721;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$multi_query_$_state_machine__2741__auto__ = function(state_66697){
switch(arguments.length){
case 0:
return flureedb$multi_query_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$multi_query_$_state_machine__2741__auto____1.call(this,state_66697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$multi_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$multi_query_$_state_machine__2741__auto____0;
flureedb$multi_query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$multi_query_$_state_machine__2741__auto____1;
return flureedb$multi_query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66713 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66713[(6)] = c__2763__auto__);

return statearr_66713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.multi_query', flureedb.multi_query);
/**
 * Execute a query against a database source, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.query = (function flureedb$query(sources,query_map){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66741){
var state_val_66742 = (state_66741[(1)]);
if((state_val_66742 === (1))){
var state_66741__$1 = state_66741;
var statearr_66743_66758 = state_66741__$1;
(statearr_66743_66758[(2)] = null);

(statearr_66743_66758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (2))){
var _ = (function (){var statearr_66744 = state_66741;
(statearr_66744[(4)] = cljs.core.cons((5),(state_66741[(4)])));

return statearr_66744;
})();
var inst_66731 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66732 = fluree.db.api.query.query_async(sources,inst_66731);
var state_66741__$1 = state_66741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66741__$1,(6),inst_66732);
} else {
if((state_val_66742 === (3))){
var inst_66739 = (state_66741[(2)]);
var state_66741__$1 = state_66741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66741__$1,inst_66739);
} else {
if((state_val_66742 === (4))){
var inst_66722 = (state_66741[(2)]);
var inst_66723 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66722], 0));
var inst_66724 = cljs.core.clj__GT_js(inst_66722);
var inst_66725 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66724) : reject.call(null,inst_66724));
var state_66741__$1 = (function (){var statearr_66746 = state_66741;
(statearr_66746[(7)] = inst_66723);

return statearr_66746;
})();
var statearr_66747_66759 = state_66741__$1;
(statearr_66747_66759[(2)] = inst_66725);

(statearr_66747_66759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (5))){
var _ = (function (){var statearr_66748 = state_66741;
(statearr_66748[(4)] = cljs.core.rest((state_66741[(4)])));

return statearr_66748;
})();
var state_66741__$1 = state_66741;
var ex66745 = (state_66741__$1[(2)]);
var statearr_66749_66760 = state_66741__$1;
(statearr_66749_66760[(5)] = ex66745);


var statearr_66750_66761 = state_66741__$1;
(statearr_66750_66761[(1)] = (4));

(statearr_66750_66761[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66742 === (6))){
var inst_66734 = (state_66741[(2)]);
var inst_66735 = cljs.core.clj__GT_js(inst_66734);
var inst_66736 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66735) : resolve.call(null,inst_66735));
var _ = (function (){var statearr_66751 = state_66741;
(statearr_66751[(4)] = cljs.core.rest((state_66741[(4)])));

return statearr_66751;
})();
var state_66741__$1 = state_66741;
var statearr_66752_66762 = state_66741__$1;
(statearr_66752_66762[(2)] = inst_66736);

(statearr_66752_66762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureedb$query_$_state_machine__2741__auto__ = null;
var flureedb$query_$_state_machine__2741__auto____0 = (function (){
var statearr_66753 = [null,null,null,null,null,null,null,null];
(statearr_66753[(0)] = flureedb$query_$_state_machine__2741__auto__);

(statearr_66753[(1)] = (1));

return statearr_66753;
});
var flureedb$query_$_state_machine__2741__auto____1 = (function (state_66741){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66741);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66754){var ex__2744__auto__ = e66754;
var statearr_66755_66763 = state_66741;
(statearr_66755_66763[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66741[(4)]))){
var statearr_66756_66764 = state_66741;
(statearr_66756_66764[(1)] = cljs.core.first((state_66741[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66765 = state_66741;
state_66741 = G__66765;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$query_$_state_machine__2741__auto__ = function(state_66741){
switch(arguments.length){
case 0:
return flureedb$query_$_state_machine__2741__auto____0.call(this);
case 1:
return flureedb$query_$_state_machine__2741__auto____1.call(this,state_66741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$query_$_state_machine__2741__auto____0;
flureedb$query_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$query_$_state_machine__2741__auto____1;
return flureedb$query_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66757 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66757[(6)] = c__2763__auto__);

return statearr_66757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
});
goog.exportSymbol('flureedb.query', flureedb.query);
/**
 * Execute a query against a ledger, or optionally
 *    additional sources if the query spans multiple data sets.
 * 
 *    Returns promise containing results.
 */
flureedb.signed_query = (function flureedb$signed_query(var_args){
var G__66767 = arguments.length;
switch (G__66767) {
case 3:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureedb.signed_query', flureedb.signed_query);

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureedb.signed_query.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(flureedb.signed_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_66794){
var state_val_66795 = (state_66794[(1)]);
if((state_val_66795 === (7))){
var inst_66781 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var state_66794__$1 = state_66794;
var statearr_66796_66817 = state_66794__$1;
(statearr_66796_66817[(2)] = inst_66781);

(statearr_66796_66817[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (1))){
var state_66794__$1 = state_66794;
var statearr_66797_66818 = state_66794__$1;
(statearr_66797_66818[(2)] = null);

(statearr_66797_66818[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (4))){
var inst_66768 = (state_66794[(2)]);
var inst_66769 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66768], 0));
var inst_66770 = cljs.core.clj__GT_js(inst_66768);
var inst_66771 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_66770) : reject.call(null,inst_66770));
var state_66794__$1 = (function (){var statearr_66798 = state_66794;
(statearr_66798[(7)] = inst_66769);

return statearr_66798;
})();
var statearr_66799_66819 = state_66794__$1;
(statearr_66799_66819[(2)] = inst_66771);

(statearr_66799_66819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (6))){
var state_66794__$1 = state_66794;
var statearr_66800_66820 = state_66794__$1;
(statearr_66800_66820[(2)] = null);

(statearr_66800_66820[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (3))){
var inst_66792 = (state_66794[(2)]);
var state_66794__$1 = state_66794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66794__$1,inst_66792);
} else {
if((state_val_66795 === (2))){
var _ = (function (){var statearr_66802 = state_66794;
(statearr_66802[(4)] = cljs.core.cons((5),(state_66794[(4)])));

return statearr_66802;
})();
var inst_66777 = cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(query_map,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0));
var inst_66778 = (opts == null);
var state_66794__$1 = (function (){var statearr_66803 = state_66794;
(statearr_66803[(8)] = inst_66777);

return statearr_66803;
})();
if(cljs.core.truth_(inst_66778)){
var statearr_66804_66821 = state_66794__$1;
(statearr_66804_66821[(1)] = (6));

} else {
var statearr_66805_66822 = state_66794__$1;
(statearr_66805_66822[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (9))){
var inst_66786 = (state_66794[(2)]);
var inst_66787 = fluree.db.util.async.throw_err(inst_66786);
var inst_66788 = cljs.core.clj__GT_js(inst_66787);
var inst_66789 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_66788) : resolve.call(null,inst_66788));
var _ = (function (){var statearr_66806 = state_66794;
(statearr_66806[(4)] = cljs.core.rest((state_66794[(4)])));

return statearr_66806;
})();
var state_66794__$1 = state_66794;
var statearr_66807_66823 = state_66794__$1;
(statearr_66807_66823[(2)] = inst_66789);

(statearr_66807_66823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (5))){
var _ = (function (){var statearr_66808 = state_66794;
(statearr_66808[(4)] = cljs.core.rest((state_66794[(4)])));

return statearr_66808;
})();
var state_66794__$1 = state_66794;
var ex66801 = (state_66794__$1[(2)]);
var statearr_66809_66824 = state_66794__$1;
(statearr_66809_66824[(5)] = ex66801);


var statearr_66810_66825 = state_66794__$1;
(statearr_66810_66825[(1)] = (4));

(statearr_66810_66825[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66795 === (8))){
var inst_66777 = (state_66794[(8)]);
var inst_66783 = (state_66794[(2)]);
var inst_66784 = fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,inst_66777,inst_66783);
var state_66794__$1 = state_66794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66794__$1,(9),inst_66784);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureedb$state_machine__2741__auto__ = null;
var flureedb$state_machine__2741__auto____0 = (function (){
var statearr_66811 = [null,null,null,null,null,null,null,null,null];
(statearr_66811[(0)] = flureedb$state_machine__2741__auto__);

(statearr_66811[(1)] = (1));

return statearr_66811;
});
var flureedb$state_machine__2741__auto____1 = (function (state_66794){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_66794);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e66812){var ex__2744__auto__ = e66812;
var statearr_66813_66826 = state_66794;
(statearr_66813_66826[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_66794[(4)]))){
var statearr_66814_66827 = state_66794;
(statearr_66814_66827[(1)] = cljs.core.first((state_66794[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66828 = state_66794;
state_66794 = G__66828;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
flureedb$state_machine__2741__auto__ = function(state_66794){
switch(arguments.length){
case 0:
return flureedb$state_machine__2741__auto____0.call(this);
case 1:
return flureedb$state_machine__2741__auto____1.call(this,state_66794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = flureedb$state_machine__2741__auto____0;
flureedb$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = flureedb$state_machine__2741__auto____1;
return flureedb$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_66815 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_66815[(6)] = c__2763__auto__);

return statearr_66815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
})));
}));

(flureedb.signed_query.cljs$lang$maxFixedArity = 4);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *    any key, and a two-argument function that will be called with each event.
 * 
 *    The key is any arbitrary key, and is only used to close the listener via close-listener,
 *    otherwise it is opaque to the listener.
 * 
 *    The callback function's first argument is the event header/metadata and the second argument
 *    is the event data itself.
 */
flureedb.listen = (function flureedb$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen(conn,ledger,key,callback);
});
goog.exportSymbol('flureedb.listen', flureedb.listen);
/**
 * Closes a listener.
 */
flureedb.close_listener = (function flureedb$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener(conn,ledger,key);
});
goog.exportSymbol('flureedb.close_listener', flureedb.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureedb.listeners = (function flureedb$listeners(conn){
return fluree.db.connection_js.listeners(conn);
});
goog.exportSymbol('flureedb.listeners', flureedb.listeners);
/**
 * Takes an http request and creates an http signature using a private key
 */
flureedb.http_signature = (function flureedb$http_signature(req_method,url,request,private_key,auth){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,auth);
});
goog.exportSymbol('flureedb.http_signature', flureedb.http_signature);
