// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4913__auto___53139 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53190){
var state_val_53191 = (state_53190[(1)]);
if((state_val_53191 === (7))){
var inst_53185 = (state_53190[(2)]);
var _ = (function (){var statearr_53192 = state_53190;
(statearr_53192[(4)] = cljs.core.rest((state_53190[(4)])));

return statearr_53192;
})();
var state_53190__$1 = state_53190;
var statearr_53193_53220 = state_53190__$1;
(statearr_53193_53220[(2)] = inst_53185);

(statearr_53193_53220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (1))){
var state_53190__$1 = state_53190;
var statearr_53194_53221 = state_53190__$1;
(statearr_53194_53221[(2)] = null);

(statearr_53194_53221[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (4))){
var inst_53140 = (state_53190[(2)]);
var state_53190__$1 = state_53190;
var statearr_53195_53222 = state_53190__$1;
(statearr_53195_53222[(2)] = inst_53140);

(statearr_53195_53222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (13))){
var inst_53181 = (state_53190[(2)]);
var state_53190__$1 = state_53190;
var statearr_53196_53223 = state_53190__$1;
(statearr_53196_53223[(2)] = inst_53181);

(statearr_53196_53223[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (6))){
var inst_53165 = (state_53190[(7)]);
var inst_53158 = (state_53190[(8)]);
var inst_53164 = cljs.core.seq(inst_53158);
var inst_53165__$1 = cljs.core.first(inst_53164);
var inst_53166 = cljs.core.next(inst_53164);
var inst_53167 = cljs.core.not(inst_53165__$1);
var state_53190__$1 = (function (){var statearr_53197 = state_53190;
(statearr_53197[(7)] = inst_53165__$1);

(statearr_53197[(9)] = inst_53166);

return statearr_53197;
})();
if(inst_53167){
var statearr_53198_53224 = state_53190__$1;
(statearr_53198_53224[(1)] = (8));

} else {
var statearr_53199_53225 = state_53190__$1;
(statearr_53199_53225[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (3))){
var inst_53188 = (state_53190[(2)]);
var state_53190__$1 = state_53190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53190__$1,inst_53188);
} else {
if((state_val_53191 === (12))){
var inst_53165 = (state_53190[(7)]);
var inst_53166 = (state_53190[(9)]);
var inst_53159 = (state_53190[(10)]);
var inst_53178 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53159,inst_53165);
var inst_53158 = inst_53166;
var inst_53159__$1 = inst_53178;
var state_53190__$1 = (function (){var statearr_53200 = state_53190;
(statearr_53200[(10)] = inst_53159__$1);

(statearr_53200[(8)] = inst_53158);

return statearr_53200;
})();
var statearr_53201_53226 = state_53190__$1;
(statearr_53201_53226[(2)] = null);

(statearr_53201_53226[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (2))){
var _ = (function (){var statearr_53202 = state_53190;
(statearr_53202[(4)] = cljs.core.cons((5),(state_53190[(4)])));

return statearr_53202;
})();
var inst_53153 = args;
var inst_53154 = cljs.core.seq(inst_53153);
var inst_53155 = cljs.core.first(inst_53154);
var inst_53156 = cljs.core.next(inst_53154);
var inst_53157 = cljs.core.PersistentVector.EMPTY;
var inst_53158 = inst_53153;
var inst_53159 = inst_53157;
var state_53190__$1 = (function (){var statearr_53203 = state_53190;
(statearr_53203[(11)] = inst_53155);

(statearr_53203[(12)] = inst_53156);

(statearr_53203[(10)] = inst_53159);

(statearr_53203[(8)] = inst_53158);

return statearr_53203;
})();
var statearr_53204_53227 = state_53190__$1;
(statearr_53204_53227[(2)] = null);

(statearr_53204_53227[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (11))){
var inst_53165 = (state_53190[(7)]);
var state_53190__$1 = state_53190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53190__$1,(14),inst_53165);
} else {
if((state_val_53191 === (9))){
var inst_53165 = (state_53190[(7)]);
var inst_53170 = fluree.db.util.async.channel_QMARK_(inst_53165);
var state_53190__$1 = state_53190;
if(inst_53170){
var statearr_53206_53228 = state_53190__$1;
(statearr_53206_53228[(1)] = (11));

} else {
var statearr_53207_53229 = state_53190__$1;
(statearr_53207_53229[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (5))){
var _ = (function (){var statearr_53208 = state_53190;
(statearr_53208[(4)] = cljs.core.rest((state_53190[(4)])));

return statearr_53208;
})();
var state_53190__$1 = state_53190;
var ex53205 = (state_53190__$1[(2)]);
var statearr_53209_53230 = state_53190__$1;
(statearr_53209_53230[(5)] = ex53205);


if((ex53205 instanceof Error)){
var statearr_53210_53231 = state_53190__$1;
(statearr_53210_53231[(1)] = (4));

(statearr_53210_53231[(5)] = null);

} else {
throw ex53205;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (14))){
var inst_53166 = (state_53190[(9)]);
var inst_53159 = (state_53190[(10)]);
var inst_53173 = (state_53190[(2)]);
var inst_53174 = fluree.db.util.async.throw_err(inst_53173);
var inst_53175 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53159,inst_53174);
var inst_53158 = inst_53166;
var inst_53159__$1 = inst_53175;
var state_53190__$1 = (function (){var statearr_53211 = state_53190;
(statearr_53211[(10)] = inst_53159__$1);

(statearr_53211[(8)] = inst_53158);

return statearr_53211;
})();
var statearr_53212_53232 = state_53190__$1;
(statearr_53212_53232[(2)] = null);

(statearr_53212_53232[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (10))){
var inst_53183 = (state_53190[(2)]);
var state_53190__$1 = state_53190;
var statearr_53213_53233 = state_53190__$1;
(statearr_53213_53233[(2)] = inst_53183);

(statearr_53213_53233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53191 === (8))){
var inst_53159 = (state_53190[(10)]);
var state_53190__$1 = state_53190;
var statearr_53214_53234 = state_53190__$1;
(statearr_53214_53234[(2)] = inst_53159);

(statearr_53214_53234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0 = (function (){
var statearr_53215 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53215[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__);

(statearr_53215[(1)] = (1));

return statearr_53215;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1 = (function (state_53190){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53190);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53216){var ex__2744__auto__ = e53216;
var statearr_53217_53235 = state_53190;
(statearr_53217_53235[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53190[(4)]))){
var statearr_53218_53236 = state_53190;
(statearr_53218_53236[(1)] = cljs.core.first((state_53190[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53237 = state_53190;
state_53190 = G__53237;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__ = function(state_53190){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1.call(this,state_53190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53219 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53219[(6)] = c__2763__auto__);

return statearr_53219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53238 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53238,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53238,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost], 0)),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53286){
var state_val_53287 = (state_53286[(1)]);
if((state_val_53287 === (7))){
var state_53286__$1 = state_53286;
var statearr_53288_53317 = state_53286__$1;
(statearr_53288_53317[(2)] = coll);

(statearr_53288_53317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (1))){
var state_53286__$1 = state_53286;
var statearr_53289_53318 = state_53286__$1;
(statearr_53289_53318[(2)] = null);

(statearr_53289_53318[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (4))){
var inst_53241 = (state_53286[(2)]);
var state_53286__$1 = state_53286;
var statearr_53290_53319 = state_53286__$1;
(statearr_53290_53319[(2)] = inst_53241);

(statearr_53290_53319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (15))){
var inst_53260 = (state_53286[(7)]);
var inst_53268 = (state_53286[(2)]);
var inst_53269 = fluree.db.dbfunctions.internal.nth(inst_53260,inst_53268);
var inst_53270 = cljs.core.count(inst_53260);
var inst_53271 = ((9) + inst_53270);
var inst_53272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53273 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53275 = [inst_53260,inst_53268];
var inst_53276 = (new cljs.core.PersistentVector(null,2,(5),inst_53274,inst_53275,null));
var inst_53277 = ["nth",inst_53276,inst_53269];
var inst_53278 = cljs.core.PersistentHashMap.fromArrays(inst_53273,inst_53277);
var inst_53279 = [inst_53278,inst_53271];
var inst_53280 = (new cljs.core.PersistentVector(null,2,(5),inst_53272,inst_53279,null));
var inst_53281 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53280);
var _ = (function (){var statearr_53291 = state_53286;
(statearr_53291[(4)] = cljs.core.rest((state_53286[(4)])));

return statearr_53291;
})();
var state_53286__$1 = (function (){var statearr_53292 = state_53286;
(statearr_53292[(8)] = inst_53281);

return statearr_53292;
})();
var statearr_53293_53320 = state_53286__$1;
(statearr_53293_53320[(2)] = inst_53269);

(statearr_53293_53320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (13))){
var state_53286__$1 = state_53286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53286__$1,(16),key);
} else {
if((state_val_53287 === (6))){
var state_53286__$1 = state_53286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53286__$1,(9),coll);
} else {
if((state_val_53287 === (3))){
var inst_53284 = (state_53286[(2)]);
var state_53286__$1 = state_53286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53286__$1,inst_53284);
} else {
if((state_val_53287 === (12))){
var inst_53260 = (state_53286[(2)]);
var inst_53261 = fluree.db.util.async.channel_QMARK_(key);
var state_53286__$1 = (function (){var statearr_53294 = state_53286;
(statearr_53294[(7)] = inst_53260);

return statearr_53294;
})();
if(inst_53261){
var statearr_53295_53321 = state_53286__$1;
(statearr_53295_53321[(1)] = (13));

} else {
var statearr_53296_53322 = state_53286__$1;
(statearr_53296_53322[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (2))){
var _ = (function (){var statearr_53297 = state_53286;
(statearr_53297[(4)] = cljs.core.cons((5),(state_53286[(4)])));

return statearr_53297;
})();
var inst_53247 = fluree.db.util.async.channel_QMARK_(coll);
var state_53286__$1 = state_53286;
if(inst_53247){
var statearr_53298_53323 = state_53286__$1;
(statearr_53298_53323[(1)] = (6));

} else {
var statearr_53299_53324 = state_53286__$1;
(statearr_53299_53324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (11))){
var inst_53254 = (state_53286[(9)]);
var state_53286__$1 = state_53286;
var statearr_53301_53325 = state_53286__$1;
(statearr_53301_53325[(2)] = inst_53254);

(statearr_53301_53325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (9))){
var inst_53250 = (state_53286[(2)]);
var inst_53251 = fluree.db.util.async.throw_err(inst_53250);
var state_53286__$1 = state_53286;
var statearr_53302_53326 = state_53286__$1;
(statearr_53302_53326[(2)] = inst_53251);

(statearr_53302_53326[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (5))){
var _ = (function (){var statearr_53303 = state_53286;
(statearr_53303[(4)] = cljs.core.rest((state_53286[(4)])));

return statearr_53303;
})();
var state_53286__$1 = state_53286;
var ex53300 = (state_53286__$1[(2)]);
var statearr_53304_53327 = state_53286__$1;
(statearr_53304_53327[(5)] = ex53300);


if((ex53300 instanceof Error)){
var statearr_53305_53328 = state_53286__$1;
(statearr_53305_53328[(1)] = (4));

(statearr_53305_53328[(5)] = null);

} else {
throw ex53300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (14))){
var state_53286__$1 = state_53286;
var statearr_53306_53329 = state_53286__$1;
(statearr_53306_53329[(2)] = key);

(statearr_53306_53329[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (16))){
var inst_53264 = (state_53286[(2)]);
var inst_53265 = fluree.db.util.async.throw_err(inst_53264);
var state_53286__$1 = state_53286;
var statearr_53307_53330 = state_53286__$1;
(statearr_53307_53330[(2)] = inst_53265);

(statearr_53307_53330[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (10))){
var inst_53254 = (state_53286[(9)]);
var inst_53257 = cljs.core.vec(inst_53254);
var state_53286__$1 = state_53286;
var statearr_53308_53331 = state_53286__$1;
(statearr_53308_53331[(2)] = inst_53257);

(statearr_53308_53331[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53287 === (8))){
var inst_53254 = (state_53286[(9)]);
var inst_53254__$1 = (state_53286[(2)]);
var inst_53255 = cljs.core.set_QMARK_(inst_53254__$1);
var state_53286__$1 = (function (){var statearr_53309 = state_53286;
(statearr_53309[(9)] = inst_53254__$1);

return statearr_53309;
})();
if(inst_53255){
var statearr_53310_53332 = state_53286__$1;
(statearr_53310_53332[(1)] = (10));

} else {
var statearr_53311_53333 = state_53286__$1;
(statearr_53311_53333[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0 = (function (){
var statearr_53312 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53312[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__);

(statearr_53312[(1)] = (1));

return statearr_53312;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1 = (function (state_53286){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53286);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53313){var ex__2744__auto__ = e53313;
var statearr_53314_53334 = state_53286;
(statearr_53314_53334[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53286[(4)]))){
var statearr_53315_53335 = state_53286;
(statearr_53315_53335[(1)] = cljs.core.first((state_53286[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53336 = state_53286;
state_53286 = G__53336;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__ = function(state_53286){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1.call(this,state_53286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53316 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53316[(6)] = c__2763__auto__);

return statearr_53316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53397){
var state_val_53398 = (state_53397[(1)]);
if((state_val_53398 === (7))){
var state_53397__$1 = state_53397;
var statearr_53399_53433 = state_53397__$1;
(statearr_53399_53433[(2)] = test);

(statearr_53399_53433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (20))){
var inst_53371 = (state_53397[(2)]);
var inst_53372 = fluree.db.util.async.throw_err(inst_53371);
var state_53397__$1 = state_53397;
var statearr_53400_53434 = state_53397__$1;
(statearr_53400_53434[(2)] = inst_53372);

(statearr_53400_53434[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (1))){
var state_53397__$1 = state_53397;
var statearr_53401_53435 = state_53397__$1;
(statearr_53401_53435[(2)] = null);

(statearr_53401_53435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (4))){
var inst_53337 = (state_53397[(2)]);
var state_53397__$1 = state_53397;
var statearr_53402_53436 = state_53397__$1;
(statearr_53402_53436[(2)] = inst_53337);

(statearr_53402_53436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (15))){
var inst_53355 = (state_53397[(7)]);
var inst_53363 = (state_53397[(2)]);
var inst_53364 = [inst_53363,f];
var inst_53365 = (new cljs.core.PersistentVector(null,2,(5),inst_53355,inst_53364,null));
var state_53397__$1 = state_53397;
var statearr_53403_53437 = state_53397__$1;
(statearr_53403_53437[(2)] = inst_53365);

(statearr_53403_53437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (13))){
var state_53397__$1 = state_53397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53397__$1,(16),t);
} else {
if((state_val_53398 === (6))){
var state_53397__$1 = state_53397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53397__$1,(9),test);
} else {
if((state_val_53398 === (17))){
var state_53397__$1 = state_53397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53397__$1,(20),f);
} else {
if((state_val_53398 === (3))){
var inst_53395 = (state_53397[(2)]);
var state_53397__$1 = state_53397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53397__$1,inst_53395);
} else {
if((state_val_53398 === (12))){
var inst_53353 = (state_53397[(8)]);
var inst_53379 = (state_53397[(2)]);
var inst_53380 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53379,(0),null);
var inst_53381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53379,(1),null);
var inst_53382 = fluree.db.dbfunctions.internal.if_else(inst_53353,inst_53380,inst_53381);
var inst_53383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53384 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53386 = [inst_53353,inst_53380,inst_53381];
var inst_53387 = (new cljs.core.PersistentVector(null,3,(5),inst_53385,inst_53386,null));
var inst_53388 = ["if-else",inst_53387,inst_53382];
var inst_53389 = cljs.core.PersistentHashMap.fromArrays(inst_53384,inst_53388);
var inst_53390 = [inst_53389,(10)];
var inst_53391 = (new cljs.core.PersistentVector(null,2,(5),inst_53383,inst_53390,null));
var inst_53392 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53391);
var _ = (function (){var statearr_53404 = state_53397;
(statearr_53404[(4)] = cljs.core.rest((state_53397[(4)])));

return statearr_53404;
})();
var state_53397__$1 = (function (){var statearr_53405 = state_53397;
(statearr_53405[(9)] = inst_53392);

return statearr_53405;
})();
var statearr_53406_53438 = state_53397__$1;
(statearr_53406_53438[(2)] = inst_53382);

(statearr_53406_53438[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (2))){
var _ = (function (){var statearr_53407 = state_53397;
(statearr_53407[(4)] = cljs.core.cons((5),(state_53397[(4)])));

return statearr_53407;
})();
var inst_53346 = fluree.db.util.async.channel_QMARK_(test);
var state_53397__$1 = state_53397;
if(inst_53346){
var statearr_53408_53439 = state_53397__$1;
(statearr_53408_53439[(1)] = (6));

} else {
var statearr_53409_53440 = state_53397__$1;
(statearr_53409_53440[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (19))){
var inst_53367 = (state_53397[(10)]);
var inst_53375 = (state_53397[(2)]);
var inst_53376 = [f,inst_53375];
var inst_53377 = (new cljs.core.PersistentVector(null,2,(5),inst_53367,inst_53376,null));
var state_53397__$1 = state_53397;
var statearr_53410_53441 = state_53397__$1;
(statearr_53410_53441[(2)] = inst_53377);

(statearr_53410_53441[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (11))){
var inst_53367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53368 = fluree.db.util.async.channel_QMARK_(f);
var state_53397__$1 = (function (){var statearr_53412 = state_53397;
(statearr_53412[(10)] = inst_53367);

return statearr_53412;
})();
if(inst_53368){
var statearr_53413_53442 = state_53397__$1;
(statearr_53413_53442[(1)] = (17));

} else {
var statearr_53414_53443 = state_53397__$1;
(statearr_53414_53443[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (9))){
var inst_53349 = (state_53397[(2)]);
var inst_53350 = fluree.db.util.async.throw_err(inst_53349);
var state_53397__$1 = state_53397;
var statearr_53415_53444 = state_53397__$1;
(statearr_53415_53444[(2)] = inst_53350);

(statearr_53415_53444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (5))){
var _ = (function (){var statearr_53416 = state_53397;
(statearr_53416[(4)] = cljs.core.rest((state_53397[(4)])));

return statearr_53416;
})();
var state_53397__$1 = state_53397;
var ex53411 = (state_53397__$1[(2)]);
var statearr_53417_53445 = state_53397__$1;
(statearr_53417_53445[(5)] = ex53411);


if((ex53411 instanceof Error)){
var statearr_53418_53446 = state_53397__$1;
(statearr_53418_53446[(1)] = (4));

(statearr_53418_53446[(5)] = null);

} else {
throw ex53411;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (14))){
var state_53397__$1 = state_53397;
var statearr_53419_53447 = state_53397__$1;
(statearr_53419_53447[(2)] = t);

(statearr_53419_53447[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (16))){
var inst_53359 = (state_53397[(2)]);
var inst_53360 = fluree.db.util.async.throw_err(inst_53359);
var state_53397__$1 = state_53397;
var statearr_53420_53448 = state_53397__$1;
(statearr_53420_53448[(2)] = inst_53360);

(statearr_53420_53448[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (10))){
var inst_53355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53356 = fluree.db.util.async.channel_QMARK_(t);
var state_53397__$1 = (function (){var statearr_53421 = state_53397;
(statearr_53421[(7)] = inst_53355);

return statearr_53421;
})();
if(inst_53356){
var statearr_53422_53449 = state_53397__$1;
(statearr_53422_53449[(1)] = (13));

} else {
var statearr_53423_53450 = state_53397__$1;
(statearr_53423_53450[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (18))){
var state_53397__$1 = state_53397;
var statearr_53424_53451 = state_53397__$1;
(statearr_53424_53451[(2)] = f);

(statearr_53424_53451[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53398 === (8))){
var inst_53353 = (state_53397[(8)]);
var inst_53353__$1 = (state_53397[(2)]);
var state_53397__$1 = (function (){var statearr_53425 = state_53397;
(statearr_53425[(8)] = inst_53353__$1);

return statearr_53425;
})();
if(cljs.core.truth_(inst_53353__$1)){
var statearr_53426_53452 = state_53397__$1;
(statearr_53426_53452[(1)] = (10));

} else {
var statearr_53427_53453 = state_53397__$1;
(statearr_53427_53453[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0 = (function (){
var statearr_53428 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_53428[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__);

(statearr_53428[(1)] = (1));

return statearr_53428;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1 = (function (state_53397){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53397);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53429){var ex__2744__auto__ = e53429;
var statearr_53430_53454 = state_53397;
(statearr_53430_53454[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53397[(4)]))){
var statearr_53431_53455 = state_53397;
(statearr_53431_53455[(1)] = cljs.core.first((state_53397[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53456 = state_53397;
state_53397 = G__53456;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__ = function(state_53397){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1.call(this,state_53397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53432 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53432[(6)] = c__2763__auto__);

return statearr_53432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53486){
var state_val_53487 = (state_53486[(1)]);
if((state_val_53487 === (7))){
var state_53486__$1 = state_53486;
var statearr_53488_53507 = state_53486__$1;
(statearr_53488_53507[(2)] = arg);

(statearr_53488_53507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (1))){
var state_53486__$1 = state_53486;
var statearr_53489_53508 = state_53486__$1;
(statearr_53489_53508[(2)] = null);

(statearr_53489_53508[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (4))){
var inst_53457 = (state_53486[(2)]);
var state_53486__$1 = state_53486;
var statearr_53490_53509 = state_53486__$1;
(statearr_53490_53509[(2)] = inst_53457);

(statearr_53490_53509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (6))){
var state_53486__$1 = state_53486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53486__$1,(9),arg);
} else {
if((state_val_53487 === (3))){
var inst_53484 = (state_53486[(2)]);
var state_53486__$1 = state_53486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53486__$1,inst_53484);
} else {
if((state_val_53487 === (2))){
var _ = (function (){var statearr_53492 = state_53486;
(statearr_53492[(4)] = cljs.core.cons((5),(state_53486[(4)])));

return statearr_53492;
})();
var inst_53463 = fluree.db.util.async.channel_QMARK_(arg);
var state_53486__$1 = state_53486;
if(inst_53463){
var statearr_53493_53510 = state_53486__$1;
(statearr_53493_53510[(1)] = (6));

} else {
var statearr_53494_53511 = state_53486__$1;
(statearr_53494_53511[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (9))){
var inst_53466 = (state_53486[(2)]);
var inst_53467 = fluree.db.util.async.throw_err(inst_53466);
var state_53486__$1 = state_53486;
var statearr_53495_53512 = state_53486__$1;
(statearr_53495_53512[(2)] = inst_53467);

(statearr_53495_53512[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (5))){
var _ = (function (){var statearr_53496 = state_53486;
(statearr_53496[(4)] = cljs.core.rest((state_53486[(4)])));

return statearr_53496;
})();
var state_53486__$1 = state_53486;
var ex53491 = (state_53486__$1[(2)]);
var statearr_53497_53513 = state_53486__$1;
(statearr_53497_53513[(5)] = ex53491);


if((ex53491 instanceof Error)){
var statearr_53498_53514 = state_53486__$1;
(statearr_53498_53514[(1)] = (4));

(statearr_53498_53514[(5)] = null);

} else {
throw ex53491;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53487 === (8))){
var inst_53470 = (state_53486[(2)]);
var inst_53471 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_53470);
var inst_53472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53473 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53475 = [inst_53470];
var inst_53476 = (new cljs.core.PersistentVector(null,1,(5),inst_53474,inst_53475,null));
var inst_53477 = ["nil?",inst_53476,inst_53471];
var inst_53478 = cljs.core.PersistentHashMap.fromArrays(inst_53473,inst_53477);
var inst_53479 = [inst_53478,(10)];
var inst_53480 = (new cljs.core.PersistentVector(null,2,(5),inst_53472,inst_53479,null));
var inst_53481 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53480);
var _ = (function (){var statearr_53499 = state_53486;
(statearr_53499[(4)] = cljs.core.rest((state_53486[(4)])));

return statearr_53499;
})();
var state_53486__$1 = (function (){var statearr_53500 = state_53486;
(statearr_53500[(7)] = inst_53481);

return statearr_53500;
})();
var statearr_53501_53515 = state_53486__$1;
(statearr_53501_53515[(2)] = inst_53471);

(statearr_53501_53515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_53502 = [null,null,null,null,null,null,null,null];
(statearr_53502[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__);

(statearr_53502[(1)] = (1));

return statearr_53502;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1 = (function (state_53486){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53486);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53503){var ex__2744__auto__ = e53503;
var statearr_53504_53516 = state_53486;
(statearr_53504_53516[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53486[(4)]))){
var statearr_53505_53517 = state_53486;
(statearr_53505_53517[(1)] = cljs.core.first((state_53486[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53518 = state_53486;
state_53486 = G__53518;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__ = function(state_53486){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1.call(this,state_53486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53506 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53506[(6)] = c__2763__auto__);

return statearr_53506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53548){
var state_val_53549 = (state_53548[(1)]);
if((state_val_53549 === (7))){
var state_53548__$1 = state_53548;
var statearr_53550_53569 = state_53548__$1;
(statearr_53550_53569[(2)] = arg);

(statearr_53550_53569[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (1))){
var state_53548__$1 = state_53548;
var statearr_53551_53570 = state_53548__$1;
(statearr_53551_53570[(2)] = null);

(statearr_53551_53570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (4))){
var inst_53519 = (state_53548[(2)]);
var state_53548__$1 = state_53548;
var statearr_53552_53571 = state_53548__$1;
(statearr_53552_53571[(2)] = inst_53519);

(statearr_53552_53571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (6))){
var state_53548__$1 = state_53548;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53548__$1,(9),arg);
} else {
if((state_val_53549 === (3))){
var inst_53546 = (state_53548[(2)]);
var state_53548__$1 = state_53548;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53548__$1,inst_53546);
} else {
if((state_val_53549 === (2))){
var _ = (function (){var statearr_53554 = state_53548;
(statearr_53554[(4)] = cljs.core.cons((5),(state_53548[(4)])));

return statearr_53554;
})();
var inst_53525 = fluree.db.util.async.channel_QMARK_(arg);
var state_53548__$1 = state_53548;
if(inst_53525){
var statearr_53555_53572 = state_53548__$1;
(statearr_53555_53572[(1)] = (6));

} else {
var statearr_53556_53573 = state_53548__$1;
(statearr_53556_53573[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (9))){
var inst_53528 = (state_53548[(2)]);
var inst_53529 = fluree.db.util.async.throw_err(inst_53528);
var state_53548__$1 = state_53548;
var statearr_53557_53574 = state_53548__$1;
(statearr_53557_53574[(2)] = inst_53529);

(statearr_53557_53574[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (5))){
var _ = (function (){var statearr_53558 = state_53548;
(statearr_53558[(4)] = cljs.core.rest((state_53548[(4)])));

return statearr_53558;
})();
var state_53548__$1 = state_53548;
var ex53553 = (state_53548__$1[(2)]);
var statearr_53559_53575 = state_53548__$1;
(statearr_53559_53575[(5)] = ex53553);


if((ex53553 instanceof Error)){
var statearr_53560_53576 = state_53548__$1;
(statearr_53560_53576[(1)] = (4));

(statearr_53560_53576[(5)] = null);

} else {
throw ex53553;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53549 === (8))){
var inst_53532 = (state_53548[(2)]);
var inst_53533 = fluree.db.dbfunctions.internal.not(inst_53532);
var inst_53534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53535 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53537 = [inst_53532];
var inst_53538 = (new cljs.core.PersistentVector(null,1,(5),inst_53536,inst_53537,null));
var inst_53539 = ["not?",inst_53538,inst_53533];
var inst_53540 = cljs.core.PersistentHashMap.fromArrays(inst_53535,inst_53539);
var inst_53541 = [inst_53540,(10)];
var inst_53542 = (new cljs.core.PersistentVector(null,2,(5),inst_53534,inst_53541,null));
var inst_53543 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53542);
var _ = (function (){var statearr_53561 = state_53548;
(statearr_53561[(4)] = cljs.core.rest((state_53548[(4)])));

return statearr_53561;
})();
var state_53548__$1 = (function (){var statearr_53562 = state_53548;
(statearr_53562[(7)] = inst_53543);

return statearr_53562;
})();
var statearr_53563_53577 = state_53548__$1;
(statearr_53563_53577[(2)] = inst_53533);

(statearr_53563_53577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0 = (function (){
var statearr_53564 = [null,null,null,null,null,null,null,null];
(statearr_53564[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__);

(statearr_53564[(1)] = (1));

return statearr_53564;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1 = (function (state_53548){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53548);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53565){var ex__2744__auto__ = e53565;
var statearr_53566_53578 = state_53548;
(statearr_53566_53578[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53548[(4)]))){
var statearr_53567_53579 = state_53548;
(statearr_53567_53579[(1)] = cljs.core.first((state_53548[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53580 = state_53548;
state_53548 = G__53580;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__ = function(state_53548){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1.call(this,state_53548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53568 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53568[(6)] = c__2763__auto__);

return statearr_53568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53610){
var state_val_53611 = (state_53610[(1)]);
if((state_val_53611 === (7))){
var state_53610__$1 = state_53610;
var statearr_53612_53631 = state_53610__$1;
(statearr_53612_53631[(2)] = arg);

(statearr_53612_53631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (1))){
var state_53610__$1 = state_53610;
var statearr_53613_53632 = state_53610__$1;
(statearr_53613_53632[(2)] = null);

(statearr_53613_53632[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (4))){
var inst_53581 = (state_53610[(2)]);
var state_53610__$1 = state_53610;
var statearr_53614_53633 = state_53610__$1;
(statearr_53614_53633[(2)] = inst_53581);

(statearr_53614_53633[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (6))){
var state_53610__$1 = state_53610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53610__$1,(9),arg);
} else {
if((state_val_53611 === (3))){
var inst_53608 = (state_53610[(2)]);
var state_53610__$1 = state_53610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53610__$1,inst_53608);
} else {
if((state_val_53611 === (2))){
var _ = (function (){var statearr_53616 = state_53610;
(statearr_53616[(4)] = cljs.core.cons((5),(state_53610[(4)])));

return statearr_53616;
})();
var inst_53587 = fluree.db.util.async.channel_QMARK_(arg);
var state_53610__$1 = state_53610;
if(inst_53587){
var statearr_53617_53634 = state_53610__$1;
(statearr_53617_53634[(1)] = (6));

} else {
var statearr_53618_53635 = state_53610__$1;
(statearr_53618_53635[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (9))){
var inst_53590 = (state_53610[(2)]);
var inst_53591 = fluree.db.util.async.throw_err(inst_53590);
var state_53610__$1 = state_53610;
var statearr_53619_53636 = state_53610__$1;
(statearr_53619_53636[(2)] = inst_53591);

(statearr_53619_53636[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (5))){
var _ = (function (){var statearr_53620 = state_53610;
(statearr_53620[(4)] = cljs.core.rest((state_53610[(4)])));

return statearr_53620;
})();
var state_53610__$1 = state_53610;
var ex53615 = (state_53610__$1[(2)]);
var statearr_53621_53637 = state_53610__$1;
(statearr_53621_53637[(5)] = ex53615);


if((ex53615 instanceof Error)){
var statearr_53622_53638 = state_53610__$1;
(statearr_53622_53638[(1)] = (4));

(statearr_53622_53638[(5)] = null);

} else {
throw ex53615;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53611 === (8))){
var inst_53594 = (state_53610[(2)]);
var inst_53595 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_53594);
var inst_53596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53597 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53599 = [inst_53594];
var inst_53600 = (new cljs.core.PersistentVector(null,1,(5),inst_53598,inst_53599,null));
var inst_53601 = ["empty?",inst_53600,inst_53595];
var inst_53602 = cljs.core.PersistentHashMap.fromArrays(inst_53597,inst_53601);
var inst_53603 = [inst_53602,(10)];
var inst_53604 = (new cljs.core.PersistentVector(null,2,(5),inst_53596,inst_53603,null));
var inst_53605 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53604);
var _ = (function (){var statearr_53623 = state_53610;
(statearr_53623[(4)] = cljs.core.rest((state_53610[(4)])));

return statearr_53623;
})();
var state_53610__$1 = (function (){var statearr_53624 = state_53610;
(statearr_53624[(7)] = inst_53605);

return statearr_53624;
})();
var statearr_53625_53639 = state_53610__$1;
(statearr_53625_53639[(2)] = inst_53595);

(statearr_53625_53639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_53626 = [null,null,null,null,null,null,null,null];
(statearr_53626[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__);

(statearr_53626[(1)] = (1));

return statearr_53626;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1 = (function (state_53610){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53610);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53627){var ex__2744__auto__ = e53627;
var statearr_53628_53640 = state_53610;
(statearr_53628_53640[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53610[(4)]))){
var statearr_53629_53641 = state_53610;
(statearr_53629_53641[(1)] = cljs.core.first((state_53610[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53642 = state_53610;
state_53610 = G__53642;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__ = function(state_53610){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1.call(this,state_53610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53630 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53630[(6)] = c__2763__auto__);

return statearr_53630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4870__auto__ = [];
var len__4864__auto___53687 = arguments.length;
var i__4865__auto___53688 = (0);
while(true){
if((i__4865__auto___53688 < len__4864__auto___53687)){
args__4870__auto__.push((arguments[i__4865__auto___53688]));

var G__53689 = (i__4865__auto___53688 + (1));
i__4865__auto___53688 = G__53689;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53670){
var state_val_53671 = (state_53670[(1)]);
if((state_val_53671 === (1))){
var state_53670__$1 = state_53670;
var statearr_53672_53690 = state_53670__$1;
(statearr_53672_53690[(2)] = null);

(statearr_53672_53690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53671 === (2))){
var _ = (function (){var statearr_53673 = state_53670;
(statearr_53673[(4)] = cljs.core.cons((5),(state_53670[(4)])));

return statearr_53673;
})();
var inst_53651 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53670__$1 = state_53670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53670__$1,(6),inst_53651);
} else {
if((state_val_53671 === (3))){
var inst_53668 = (state_53670[(2)]);
var state_53670__$1 = state_53670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53670__$1,inst_53668);
} else {
if((state_val_53671 === (4))){
var inst_53645 = (state_53670[(2)]);
var state_53670__$1 = state_53670;
var statearr_53675_53691 = state_53670__$1;
(statearr_53675_53691[(2)] = inst_53645);

(statearr_53675_53691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53671 === (5))){
var _ = (function (){var statearr_53676 = state_53670;
(statearr_53676[(4)] = cljs.core.rest((state_53670[(4)])));

return statearr_53676;
})();
var state_53670__$1 = state_53670;
var ex53674 = (state_53670__$1[(2)]);
var statearr_53677_53692 = state_53670__$1;
(statearr_53677_53692[(5)] = ex53674);


if((ex53674 instanceof Error)){
var statearr_53678_53693 = state_53670__$1;
(statearr_53678_53693[(1)] = (4));

(statearr_53678_53693[(5)] = null);

} else {
throw ex53674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53671 === (6))){
var inst_53653 = (state_53670[(2)]);
var inst_53654 = fluree.db.util.async.throw_err(inst_53653);
var inst_53655 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_53654);
var inst_53656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53657 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53659 = [inst_53654];
var inst_53660 = (new cljs.core.PersistentVector(null,1,(5),inst_53658,inst_53659,null));
var inst_53661 = ["str",inst_53660,inst_53655];
var inst_53662 = cljs.core.PersistentHashMap.fromArrays(inst_53657,inst_53661);
var inst_53663 = [inst_53662,(10)];
var inst_53664 = (new cljs.core.PersistentVector(null,2,(5),inst_53656,inst_53663,null));
var inst_53665 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53664);
var _ = (function (){var statearr_53679 = state_53670;
(statearr_53679[(4)] = cljs.core.rest((state_53670[(4)])));

return statearr_53679;
})();
var state_53670__$1 = (function (){var statearr_53680 = state_53670;
(statearr_53680[(7)] = inst_53665);

return statearr_53680;
})();
var statearr_53681_53694 = state_53670__$1;
(statearr_53681_53694[(2)] = inst_53655);

(statearr_53681_53694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53682 = [null,null,null,null,null,null,null,null];
(statearr_53682[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53682[(1)] = (1));

return statearr_53682;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53670){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53670);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53683){var ex__2744__auto__ = e53683;
var statearr_53684_53695 = state_53670;
(statearr_53684_53695[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53670[(4)]))){
var statearr_53685_53696 = state_53670;
(statearr_53685_53696[(1)] = cljs.core.first((state_53670[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53697 = state_53670;
state_53670 = G__53697;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53670){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53686 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53686[(6)] = c__2763__auto__);

return statearr_53686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq53643){
var G__53644 = cljs.core.first(seq53643);
var seq53643__$1 = cljs.core.next(seq53643);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53644,seq53643__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53723){
var state_val_53724 = (state_53723[(1)]);
if((state_val_53724 === (1))){
var state_53723__$1 = state_53723;
var statearr_53725_53740 = state_53723__$1;
(statearr_53725_53740[(2)] = null);

(statearr_53725_53740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53724 === (2))){
var _ = (function (){var statearr_53726 = state_53723;
(statearr_53726[(4)] = cljs.core.cons((5),(state_53723[(4)])));

return statearr_53726;
})();
var inst_53704 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_53723__$1 = state_53723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53723__$1,(6),inst_53704);
} else {
if((state_val_53724 === (3))){
var inst_53721 = (state_53723[(2)]);
var state_53723__$1 = state_53723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53723__$1,inst_53721);
} else {
if((state_val_53724 === (4))){
var inst_53698 = (state_53723[(2)]);
var state_53723__$1 = state_53723;
var statearr_53728_53741 = state_53723__$1;
(statearr_53728_53741[(2)] = inst_53698);

(statearr_53728_53741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53724 === (5))){
var _ = (function (){var statearr_53729 = state_53723;
(statearr_53729[(4)] = cljs.core.rest((state_53723[(4)])));

return statearr_53729;
})();
var state_53723__$1 = state_53723;
var ex53727 = (state_53723__$1[(2)]);
var statearr_53730_53742 = state_53723__$1;
(statearr_53730_53742[(5)] = ex53727);


if((ex53727 instanceof Error)){
var statearr_53731_53743 = state_53723__$1;
(statearr_53731_53743[(1)] = (4));

(statearr_53731_53743[(5)] = null);

} else {
throw ex53727;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53724 === (6))){
var inst_53706 = (state_53723[(2)]);
var inst_53707 = fluree.db.util.async.throw_err(inst_53706);
var inst_53708 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_53707);
var inst_53709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53710 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53712 = [inst_53707];
var inst_53713 = (new cljs.core.PersistentVector(null,1,(5),inst_53711,inst_53712,null));
var inst_53714 = ["subs",inst_53713,inst_53708];
var inst_53715 = cljs.core.PersistentHashMap.fromArrays(inst_53710,inst_53714);
var inst_53716 = [inst_53715,(30)];
var inst_53717 = (new cljs.core.PersistentVector(null,2,(5),inst_53709,inst_53716,null));
var inst_53718 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53717);
var _ = (function (){var statearr_53732 = state_53723;
(statearr_53732[(4)] = cljs.core.rest((state_53723[(4)])));

return statearr_53732;
})();
var state_53723__$1 = (function (){var statearr_53733 = state_53723;
(statearr_53733[(7)] = inst_53718);

return statearr_53733;
})();
var statearr_53734_53744 = state_53723__$1;
(statearr_53734_53744[(2)] = inst_53708);

(statearr_53734_53744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0 = (function (){
var statearr_53735 = [null,null,null,null,null,null,null,null];
(statearr_53735[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__);

(statearr_53735[(1)] = (1));

return statearr_53735;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1 = (function (state_53723){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53723);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53736){var ex__2744__auto__ = e53736;
var statearr_53737_53745 = state_53723;
(statearr_53737_53745[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53723[(4)]))){
var statearr_53738_53746 = state_53723;
(statearr_53738_53746[(1)] = cljs.core.first((state_53723[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53747 = state_53723;
state_53723 = G__53747;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__ = function(state_53723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1.call(this,state_53723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53739 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53739[(6)] = c__2763__auto__);

return statearr_53739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53777){
var state_val_53778 = (state_53777[(1)]);
if((state_val_53778 === (7))){
var state_53777__$1 = state_53777;
var statearr_53779_53798 = state_53777__$1;
(statearr_53779_53798[(2)] = str);

(statearr_53779_53798[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (1))){
var state_53777__$1 = state_53777;
var statearr_53780_53799 = state_53777__$1;
(statearr_53780_53799[(2)] = null);

(statearr_53780_53799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (4))){
var inst_53748 = (state_53777[(2)]);
var state_53777__$1 = state_53777;
var statearr_53781_53800 = state_53777__$1;
(statearr_53781_53800[(2)] = inst_53748);

(statearr_53781_53800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (6))){
var state_53777__$1 = state_53777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53777__$1,(9),str);
} else {
if((state_val_53778 === (3))){
var inst_53775 = (state_53777[(2)]);
var state_53777__$1 = state_53777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53777__$1,inst_53775);
} else {
if((state_val_53778 === (2))){
var _ = (function (){var statearr_53783 = state_53777;
(statearr_53783[(4)] = cljs.core.cons((5),(state_53777[(4)])));

return statearr_53783;
})();
var inst_53754 = fluree.db.util.async.channel_QMARK_(str);
var state_53777__$1 = state_53777;
if(inst_53754){
var statearr_53784_53801 = state_53777__$1;
(statearr_53784_53801[(1)] = (6));

} else {
var statearr_53785_53802 = state_53777__$1;
(statearr_53785_53802[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (9))){
var inst_53757 = (state_53777[(2)]);
var inst_53758 = fluree.db.util.async.throw_err(inst_53757);
var state_53777__$1 = state_53777;
var statearr_53786_53803 = state_53777__$1;
(statearr_53786_53803[(2)] = inst_53758);

(statearr_53786_53803[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (5))){
var _ = (function (){var statearr_53787 = state_53777;
(statearr_53787[(4)] = cljs.core.rest((state_53777[(4)])));

return statearr_53787;
})();
var state_53777__$1 = state_53777;
var ex53782 = (state_53777__$1[(2)]);
var statearr_53788_53804 = state_53777__$1;
(statearr_53788_53804[(5)] = ex53782);


if((ex53782 instanceof Error)){
var statearr_53789_53805 = state_53777__$1;
(statearr_53789_53805[(1)] = (4));

(statearr_53789_53805[(5)] = null);

} else {
throw ex53782;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53778 === (8))){
var inst_53761 = (state_53777[(2)]);
var inst_53762 = fluree.db.dbfunctions.internal.lower_case(inst_53761);
var inst_53763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53764 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53766 = [inst_53761];
var inst_53767 = (new cljs.core.PersistentVector(null,1,(5),inst_53765,inst_53766,null));
var inst_53768 = ["lower-case",inst_53767,inst_53762];
var inst_53769 = cljs.core.PersistentHashMap.fromArrays(inst_53764,inst_53768);
var inst_53770 = [inst_53769,(10)];
var inst_53771 = (new cljs.core.PersistentVector(null,2,(5),inst_53763,inst_53770,null));
var inst_53772 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53771);
var _ = (function (){var statearr_53790 = state_53777;
(statearr_53790[(4)] = cljs.core.rest((state_53777[(4)])));

return statearr_53790;
})();
var state_53777__$1 = (function (){var statearr_53791 = state_53777;
(statearr_53791[(7)] = inst_53772);

return statearr_53791;
})();
var statearr_53792_53806 = state_53777__$1;
(statearr_53792_53806[(2)] = inst_53762);

(statearr_53792_53806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0 = (function (){
var statearr_53793 = [null,null,null,null,null,null,null,null];
(statearr_53793[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__);

(statearr_53793[(1)] = (1));

return statearr_53793;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1 = (function (state_53777){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53777);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53794){var ex__2744__auto__ = e53794;
var statearr_53795_53807 = state_53777;
(statearr_53795_53807[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53777[(4)]))){
var statearr_53796_53808 = state_53777;
(statearr_53796_53808[(1)] = cljs.core.first((state_53777[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53809 = state_53777;
state_53777 = G__53809;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__ = function(state_53777){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1.call(this,state_53777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53797 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53797[(6)] = c__2763__auto__);

return statearr_53797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53839){
var state_val_53840 = (state_53839[(1)]);
if((state_val_53840 === (7))){
var state_53839__$1 = state_53839;
var statearr_53841_53860 = state_53839__$1;
(statearr_53841_53860[(2)] = str);

(statearr_53841_53860[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (1))){
var state_53839__$1 = state_53839;
var statearr_53842_53861 = state_53839__$1;
(statearr_53842_53861[(2)] = null);

(statearr_53842_53861[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (4))){
var inst_53810 = (state_53839[(2)]);
var state_53839__$1 = state_53839;
var statearr_53843_53862 = state_53839__$1;
(statearr_53843_53862[(2)] = inst_53810);

(statearr_53843_53862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (6))){
var state_53839__$1 = state_53839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53839__$1,(9),str);
} else {
if((state_val_53840 === (3))){
var inst_53837 = (state_53839[(2)]);
var state_53839__$1 = state_53839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53839__$1,inst_53837);
} else {
if((state_val_53840 === (2))){
var _ = (function (){var statearr_53845 = state_53839;
(statearr_53845[(4)] = cljs.core.cons((5),(state_53839[(4)])));

return statearr_53845;
})();
var inst_53816 = fluree.db.util.async.channel_QMARK_(str);
var state_53839__$1 = state_53839;
if(inst_53816){
var statearr_53846_53863 = state_53839__$1;
(statearr_53846_53863[(1)] = (6));

} else {
var statearr_53847_53864 = state_53839__$1;
(statearr_53847_53864[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (9))){
var inst_53819 = (state_53839[(2)]);
var inst_53820 = fluree.db.util.async.throw_err(inst_53819);
var state_53839__$1 = state_53839;
var statearr_53848_53865 = state_53839__$1;
(statearr_53848_53865[(2)] = inst_53820);

(statearr_53848_53865[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (5))){
var _ = (function (){var statearr_53849 = state_53839;
(statearr_53849[(4)] = cljs.core.rest((state_53839[(4)])));

return statearr_53849;
})();
var state_53839__$1 = state_53839;
var ex53844 = (state_53839__$1[(2)]);
var statearr_53850_53866 = state_53839__$1;
(statearr_53850_53866[(5)] = ex53844);


if((ex53844 instanceof Error)){
var statearr_53851_53867 = state_53839__$1;
(statearr_53851_53867[(1)] = (4));

(statearr_53851_53867[(5)] = null);

} else {
throw ex53844;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53840 === (8))){
var inst_53823 = (state_53839[(2)]);
var inst_53824 = fluree.db.dbfunctions.internal.upper_case(inst_53823);
var inst_53825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53826 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53828 = [inst_53823];
var inst_53829 = (new cljs.core.PersistentVector(null,1,(5),inst_53827,inst_53828,null));
var inst_53830 = ["upper-case",inst_53829,inst_53824];
var inst_53831 = cljs.core.PersistentHashMap.fromArrays(inst_53826,inst_53830);
var inst_53832 = [inst_53831,(10)];
var inst_53833 = (new cljs.core.PersistentVector(null,2,(5),inst_53825,inst_53832,null));
var inst_53834 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53833);
var _ = (function (){var statearr_53852 = state_53839;
(statearr_53852[(4)] = cljs.core.rest((state_53839[(4)])));

return statearr_53852;
})();
var state_53839__$1 = (function (){var statearr_53853 = state_53839;
(statearr_53853[(7)] = inst_53834);

return statearr_53853;
})();
var statearr_53854_53868 = state_53839__$1;
(statearr_53854_53868[(2)] = inst_53824);

(statearr_53854_53868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0 = (function (){
var statearr_53855 = [null,null,null,null,null,null,null,null];
(statearr_53855[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__);

(statearr_53855[(1)] = (1));

return statearr_53855;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1 = (function (state_53839){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53839);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53856){var ex__2744__auto__ = e53856;
var statearr_53857_53869 = state_53839;
(statearr_53857_53869[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53839[(4)]))){
var statearr_53858_53870 = state_53839;
(statearr_53858_53870[(1)] = cljs.core.first((state_53839[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53871 = state_53839;
state_53839 = G__53871;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__ = function(state_53839){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1.call(this,state_53839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53859 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53859[(6)] = c__2763__auto__);

return statearr_53859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4251__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4251__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__53873 = arguments.length;
switch (G__53873) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53901){
var state_val_53902 = (state_53901[(1)]);
if((state_val_53902 === (1))){
var state_53901__$1 = state_53901;
var statearr_53903_53919 = state_53901__$1;
(statearr_53903_53919[(2)] = null);

(statearr_53903_53919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53902 === (2))){
var _ = (function (){var statearr_53904 = state_53901;
(statearr_53904[(4)] = cljs.core.cons((5),(state_53901[(4)])));

return statearr_53904;
})();
var inst_53883 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_53901__$1 = state_53901;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53901__$1,(6),inst_53883);
} else {
if((state_val_53902 === (3))){
var inst_53899 = (state_53901[(2)]);
var state_53901__$1 = state_53901;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53901__$1,inst_53899);
} else {
if((state_val_53902 === (4))){
var inst_53874 = (state_53901[(2)]);
var state_53901__$1 = state_53901;
var statearr_53906_53920 = state_53901__$1;
(statearr_53906_53920[(2)] = inst_53874);

(statearr_53906_53920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53902 === (5))){
var _ = (function (){var statearr_53907 = state_53901;
(statearr_53907[(4)] = cljs.core.rest((state_53901[(4)])));

return statearr_53907;
})();
var state_53901__$1 = state_53901;
var ex53905 = (state_53901__$1[(2)]);
var statearr_53908_53921 = state_53901__$1;
(statearr_53908_53921[(5)] = ex53905);


if((ex53905 instanceof Error)){
var statearr_53909_53922 = state_53901__$1;
(statearr_53909_53922[(1)] = (4));

(statearr_53909_53922[(5)] = null);

} else {
throw ex53905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53902 === (6))){
var inst_53885 = (state_53901[(2)]);
var inst_53886 = fluree.db.util.async.throw_err(inst_53885);
var inst_53887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53886,(0),null);
var inst_53888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53886,(1),null);
var inst_53889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53890 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53891 = ["?s","?ctx",inst_53887];
var inst_53892 = cljs.core.PersistentHashMap.fromArrays(inst_53890,inst_53891);
var inst_53893 = ((10) + inst_53888);
var inst_53894 = [inst_53892,inst_53893];
var inst_53895 = (new cljs.core.PersistentVector(null,2,(5),inst_53889,inst_53894,null));
var inst_53896 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53895);
var _ = (function (){var statearr_53910 = state_53901;
(statearr_53910[(4)] = cljs.core.rest((state_53901[(4)])));

return statearr_53910;
})();
var state_53901__$1 = (function (){var statearr_53911 = state_53901;
(statearr_53911[(7)] = inst_53896);

return statearr_53911;
})();
var statearr_53912_53923 = state_53901__$1;
(statearr_53912_53923[(2)] = inst_53887);

(statearr_53912_53923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53913 = [null,null,null,null,null,null,null,null];
(statearr_53913[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53913[(1)] = (1));

return statearr_53913;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53901){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53901);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53914){var ex__2744__auto__ = e53914;
var statearr_53915_53924 = state_53901;
(statearr_53915_53924[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53901[(4)]))){
var statearr_53916_53925 = state_53901;
(statearr_53916_53925[(1)] = cljs.core.first((state_53901[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53926 = state_53901;
state_53901 = G__53926;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53901){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53917 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53917[(6)] = c__2763__auto__);

return statearr_53917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__53928 = arguments.length;
switch (G__53928) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_53966){
var state_val_53967 = (state_53966[(1)]);
if((state_val_53967 === (7))){
var inst_53959 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_53966__$1 = state_53966;
var statearr_53968_53988 = state_53966__$1;
(statearr_53968_53988[(2)] = inst_53959);

(statearr_53968_53988[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (1))){
var state_53966__$1 = state_53966;
var statearr_53969_53989 = state_53966__$1;
(statearr_53969_53989[(2)] = null);

(statearr_53969_53989[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (4))){
var inst_53929 = (state_53966[(2)]);
var state_53966__$1 = state_53966;
var statearr_53970_53990 = state_53966__$1;
(statearr_53970_53990[(2)] = inst_53929);

(statearr_53970_53990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (6))){
var inst_53940 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_53966__$1 = state_53966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53966__$1,(10),inst_53940);
} else {
if((state_val_53967 === (3))){
var inst_53964 = (state_53966[(2)]);
var state_53966__$1 = state_53966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53966__$1,inst_53964);
} else {
if((state_val_53967 === (2))){
var _ = (function (){var statearr_53972 = state_53966;
(statearr_53972[(4)] = cljs.core.cons((5),(state_53966[(4)])));

return statearr_53972;
})();
var inst_53935 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_53966__$1 = state_53966;
if(cljs.core.truth_(inst_53935)){
var statearr_53973_53991 = state_53966__$1;
(statearr_53973_53991[(1)] = (6));

} else {
var statearr_53974_53992 = state_53966__$1;
(statearr_53974_53992[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (9))){
var inst_53946 = (state_53966[(2)]);
var inst_53947 = fluree.db.util.async.throw_err(inst_53946);
var inst_53948 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53947,(0),null);
var inst_53949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53947,(1),null);
var inst_53950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53951 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53952 = ["?p","?ctx",inst_53948];
var inst_53953 = cljs.core.PersistentHashMap.fromArrays(inst_53951,inst_53952);
var inst_53954 = ((10) + inst_53949);
var inst_53955 = [inst_53953,inst_53954];
var inst_53956 = (new cljs.core.PersistentVector(null,2,(5),inst_53950,inst_53955,null));
var inst_53957 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53956);
var state_53966__$1 = (function (){var statearr_53975 = state_53966;
(statearr_53975[(7)] = inst_53957);

return statearr_53975;
})();
var statearr_53976_53993 = state_53966__$1;
(statearr_53976_53993[(2)] = inst_53948);

(statearr_53976_53993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (5))){
var _ = (function (){var statearr_53977 = state_53966;
(statearr_53977[(4)] = cljs.core.rest((state_53966[(4)])));

return statearr_53977;
})();
var state_53966__$1 = state_53966;
var ex53971 = (state_53966__$1[(2)]);
var statearr_53978_53994 = state_53966__$1;
(statearr_53978_53994[(5)] = ex53971);


if((ex53971 instanceof Error)){
var statearr_53979_53995 = state_53966__$1;
(statearr_53979_53995[(1)] = (4));

(statearr_53979_53995[(5)] = null);

} else {
throw ex53971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53967 === (10))){
var inst_53942 = (state_53966[(2)]);
var inst_53943 = fluree.db.util.async.throw_err(inst_53942);
var inst_53944 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_53943);
var state_53966__$1 = state_53966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53966__$1,(9),inst_53944);
} else {
if((state_val_53967 === (8))){
var inst_53961 = (state_53966[(2)]);
var _ = (function (){var statearr_53980 = state_53966;
(statearr_53980[(4)] = cljs.core.rest((state_53966[(4)])));

return statearr_53980;
})();
var state_53966__$1 = state_53966;
var statearr_53981_53996 = state_53966__$1;
(statearr_53981_53996[(2)] = inst_53961);

(statearr_53981_53996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_53982 = [null,null,null,null,null,null,null,null];
(statearr_53982[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_53982[(1)] = (1));

return statearr_53982;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_53966){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_53966);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e53983){var ex__2744__auto__ = e53983;
var statearr_53984_53997 = state_53966;
(statearr_53984_53997[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_53966[(4)]))){
var statearr_53985_53998 = state_53966;
(statearr_53985_53998[(1)] = cljs.core.first((state_53966[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53999 = state_53966;
state_53966 = G__53999;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_53966){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_53966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_53986 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_53986[(6)] = c__2763__auto__);

return statearr_53986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54048 = arguments.length;
var i__4865__auto___54049 = (0);
while(true){
if((i__4865__auto___54049 < len__4864__auto___54048)){
args__4870__auto__.push((arguments[i__4865__auto___54049]));

var G__54050 = (i__4865__auto___54049 + (1));
i__4865__auto___54049 = G__54050;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54031){
var state_val_54032 = (state_54031[(1)]);
if((state_val_54032 === (1))){
var state_54031__$1 = state_54031;
var statearr_54033_54051 = state_54031__$1;
(statearr_54033_54051[(2)] = null);

(statearr_54033_54051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54032 === (2))){
var _ = (function (){var statearr_54034 = state_54031;
(statearr_54034[(4)] = cljs.core.cons((5),(state_54031[(4)])));

return statearr_54034;
})();
var inst_54008 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54031__$1 = state_54031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54031__$1,(6),inst_54008);
} else {
if((state_val_54032 === (3))){
var inst_54029 = (state_54031[(2)]);
var state_54031__$1 = state_54031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54031__$1,inst_54029);
} else {
if((state_val_54032 === (4))){
var inst_54002 = (state_54031[(2)]);
var state_54031__$1 = state_54031;
var statearr_54036_54052 = state_54031__$1;
(statearr_54036_54052[(2)] = inst_54002);

(statearr_54036_54052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54032 === (5))){
var _ = (function (){var statearr_54037 = state_54031;
(statearr_54037[(4)] = cljs.core.rest((state_54031[(4)])));

return statearr_54037;
})();
var state_54031__$1 = state_54031;
var ex54035 = (state_54031__$1[(2)]);
var statearr_54038_54053 = state_54031__$1;
(statearr_54038_54053[(5)] = ex54035);


if((ex54035 instanceof Error)){
var statearr_54039_54054 = state_54031__$1;
(statearr_54039_54054[(1)] = (4));

(statearr_54039_54054[(5)] = null);

} else {
throw ex54035;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54032 === (6))){
var inst_54010 = (state_54031[(2)]);
var inst_54011 = fluree.db.util.async.throw_err(inst_54010);
var inst_54012 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54011);
var inst_54013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54014 = [inst_54011];
var inst_54015 = (new cljs.core.PersistentVector(null,1,(5),inst_54013,inst_54014,null));
var inst_54016 = cljs.core.count(inst_54015);
var inst_54017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54018 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54020 = [inst_54011];
var inst_54021 = (new cljs.core.PersistentVector(null,1,(5),inst_54019,inst_54020,null));
var inst_54022 = ["and",inst_54021,inst_54012];
var inst_54023 = cljs.core.PersistentHashMap.fromArrays(inst_54018,inst_54022);
var inst_54024 = [inst_54023,inst_54016];
var inst_54025 = (new cljs.core.PersistentVector(null,2,(5),inst_54017,inst_54024,null));
var inst_54026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54025);
var _ = (function (){var statearr_54040 = state_54031;
(statearr_54040[(4)] = cljs.core.rest((state_54031[(4)])));

return statearr_54040;
})();
var state_54031__$1 = (function (){var statearr_54041 = state_54031;
(statearr_54041[(7)] = inst_54026);

return statearr_54041;
})();
var statearr_54042_54055 = state_54031__$1;
(statearr_54042_54055[(2)] = inst_54012);

(statearr_54042_54055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54043 = [null,null,null,null,null,null,null,null];
(statearr_54043[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54043[(1)] = (1));

return statearr_54043;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54031){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54031);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54044){var ex__2744__auto__ = e54044;
var statearr_54045_54056 = state_54031;
(statearr_54045_54056[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54031[(4)]))){
var statearr_54046_54057 = state_54031;
(statearr_54046_54057[(1)] = cljs.core.first((state_54031[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54058 = state_54031;
state_54031 = G__54058;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54047 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54047[(6)] = c__2763__auto__);

return statearr_54047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54000){
var G__54001 = cljs.core.first(seq54000);
var seq54000__$1 = cljs.core.next(seq54000);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54001,seq54000__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54107 = arguments.length;
var i__4865__auto___54108 = (0);
while(true){
if((i__4865__auto___54108 < len__4864__auto___54107)){
args__4870__auto__.push((arguments[i__4865__auto___54108]));

var G__54109 = (i__4865__auto___54108 + (1));
i__4865__auto___54108 = G__54109;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54090){
var state_val_54091 = (state_54090[(1)]);
if((state_val_54091 === (1))){
var state_54090__$1 = state_54090;
var statearr_54092_54110 = state_54090__$1;
(statearr_54092_54110[(2)] = null);

(statearr_54092_54110[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (2))){
var _ = (function (){var statearr_54093 = state_54090;
(statearr_54093[(4)] = cljs.core.cons((5),(state_54090[(4)])));

return statearr_54093;
})();
var inst_54067 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54090__$1 = state_54090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54090__$1,(6),inst_54067);
} else {
if((state_val_54091 === (3))){
var inst_54088 = (state_54090[(2)]);
var state_54090__$1 = state_54090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54090__$1,inst_54088);
} else {
if((state_val_54091 === (4))){
var inst_54061 = (state_54090[(2)]);
var state_54090__$1 = state_54090;
var statearr_54095_54111 = state_54090__$1;
(statearr_54095_54111[(2)] = inst_54061);

(statearr_54095_54111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (5))){
var _ = (function (){var statearr_54096 = state_54090;
(statearr_54096[(4)] = cljs.core.rest((state_54090[(4)])));

return statearr_54096;
})();
var state_54090__$1 = state_54090;
var ex54094 = (state_54090__$1[(2)]);
var statearr_54097_54112 = state_54090__$1;
(statearr_54097_54112[(5)] = ex54094);


if((ex54094 instanceof Error)){
var statearr_54098_54113 = state_54090__$1;
(statearr_54098_54113[(1)] = (4));

(statearr_54098_54113[(5)] = null);

} else {
throw ex54094;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54091 === (6))){
var inst_54069 = (state_54090[(2)]);
var inst_54070 = fluree.db.util.async.throw_err(inst_54069);
var inst_54071 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54070);
var inst_54072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54073 = [inst_54070];
var inst_54074 = (new cljs.core.PersistentVector(null,1,(5),inst_54072,inst_54073,null));
var inst_54075 = cljs.core.count(inst_54074);
var inst_54076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54077 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54078 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54079 = [inst_54070];
var inst_54080 = (new cljs.core.PersistentVector(null,1,(5),inst_54078,inst_54079,null));
var inst_54081 = ["or",inst_54080,inst_54071];
var inst_54082 = cljs.core.PersistentHashMap.fromArrays(inst_54077,inst_54081);
var inst_54083 = [inst_54082,inst_54075];
var inst_54084 = (new cljs.core.PersistentVector(null,2,(5),inst_54076,inst_54083,null));
var inst_54085 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54084);
var _ = (function (){var statearr_54099 = state_54090;
(statearr_54099[(4)] = cljs.core.rest((state_54090[(4)])));

return statearr_54099;
})();
var state_54090__$1 = (function (){var statearr_54100 = state_54090;
(statearr_54100[(7)] = inst_54085);

return statearr_54100;
})();
var statearr_54101_54114 = state_54090__$1;
(statearr_54101_54114[(2)] = inst_54071);

(statearr_54101_54114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54102 = [null,null,null,null,null,null,null,null];
(statearr_54102[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54102[(1)] = (1));

return statearr_54102;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54090){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54090);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54103){var ex__2744__auto__ = e54103;
var statearr_54104_54115 = state_54090;
(statearr_54104_54115[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54090[(4)]))){
var statearr_54105_54116 = state_54090;
(statearr_54105_54116[(1)] = cljs.core.first((state_54090[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54117 = state_54090;
state_54090 = G__54117;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54090){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54106 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54106[(6)] = c__2763__auto__);

return statearr_54106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54059){
var G__54060 = cljs.core.first(seq54059);
var seq54059__$1 = cljs.core.next(seq54059);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54060,seq54059__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54155){
var state_val_54156 = (state_54155[(1)]);
if((state_val_54156 === (7))){
var inst_54131 = fluree.db.util.async.channel_QMARK_(coll);
var state_54155__$1 = state_54155;
if(inst_54131){
var statearr_54157_54180 = state_54155__$1;
(statearr_54157_54180[(1)] = (10));

} else {
var statearr_54158_54181 = state_54155__$1;
(statearr_54158_54181[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (1))){
var state_54155__$1 = state_54155;
var statearr_54159_54182 = state_54155__$1;
(statearr_54159_54182[(2)] = null);

(statearr_54159_54182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (4))){
var inst_54118 = (state_54155[(2)]);
var state_54155__$1 = state_54155;
var statearr_54160_54183 = state_54155__$1;
(statearr_54160_54183[(2)] = inst_54118);

(statearr_54160_54183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (13))){
var inst_54134 = (state_54155[(2)]);
var inst_54135 = fluree.db.util.async.throw_err(inst_54134);
var state_54155__$1 = state_54155;
var statearr_54161_54184 = state_54155__$1;
(statearr_54161_54184[(2)] = inst_54135);

(statearr_54161_54184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (6))){
var inst_54126 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54155__$1 = state_54155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54155__$1,(9),inst_54126);
} else {
if((state_val_54156 === (3))){
var inst_54153 = (state_54155[(2)]);
var state_54155__$1 = state_54155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54155__$1,inst_54153);
} else {
if((state_val_54156 === (12))){
var inst_54138 = (state_54155[(2)]);
var state_54155__$1 = state_54155;
var statearr_54162_54185 = state_54155__$1;
(statearr_54162_54185[(2)] = inst_54138);

(statearr_54162_54185[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (2))){
var _ = (function (){var statearr_54163 = state_54155;
(statearr_54163[(4)] = cljs.core.cons((5),(state_54155[(4)])));

return statearr_54163;
})();
var inst_54124 = cljs.core.vector_QMARK_(coll);
var state_54155__$1 = state_54155;
if(inst_54124){
var statearr_54164_54186 = state_54155__$1;
(statearr_54164_54186[(1)] = (6));

} else {
var statearr_54165_54187 = state_54155__$1;
(statearr_54165_54187[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (11))){
var state_54155__$1 = state_54155;
var statearr_54167_54188 = state_54155__$1;
(statearr_54167_54188[(2)] = coll);

(statearr_54167_54188[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (9))){
var inst_54128 = (state_54155[(2)]);
var inst_54129 = fluree.db.util.async.throw_err(inst_54128);
var state_54155__$1 = state_54155;
var statearr_54168_54189 = state_54155__$1;
(statearr_54168_54189[(2)] = inst_54129);

(statearr_54168_54189[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (5))){
var _ = (function (){var statearr_54169 = state_54155;
(statearr_54169[(4)] = cljs.core.rest((state_54155[(4)])));

return statearr_54169;
})();
var state_54155__$1 = state_54155;
var ex54166 = (state_54155__$1[(2)]);
var statearr_54170_54190 = state_54155__$1;
(statearr_54170_54190[(5)] = ex54166);


if((ex54166 instanceof Error)){
var statearr_54171_54191 = state_54155__$1;
(statearr_54171_54191[(1)] = (4));

(statearr_54171_54191[(5)] = null);

} else {
throw ex54166;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54156 === (10))){
var state_54155__$1 = state_54155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54155__$1,(13),coll);
} else {
if((state_val_54156 === (8))){
var inst_54140 = (state_54155[(2)]);
var inst_54141 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54140);
var inst_54142 = cljs.core.count(inst_54141);
var inst_54143 = ((9) + inst_54142);
var inst_54144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54145 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54146 = ["count",inst_54140,inst_54142];
var inst_54147 = cljs.core.PersistentHashMap.fromArrays(inst_54145,inst_54146);
var inst_54148 = [inst_54147,inst_54143];
var inst_54149 = (new cljs.core.PersistentVector(null,2,(5),inst_54144,inst_54148,null));
var inst_54150 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54149);
var _ = (function (){var statearr_54172 = state_54155;
(statearr_54172[(4)] = cljs.core.rest((state_54155[(4)])));

return statearr_54172;
})();
var state_54155__$1 = (function (){var statearr_54173 = state_54155;
(statearr_54173[(7)] = inst_54150);

return statearr_54173;
})();
var statearr_54174_54192 = state_54155__$1;
(statearr_54174_54192[(2)] = inst_54142);

(statearr_54174_54192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0 = (function (){
var statearr_54175 = [null,null,null,null,null,null,null,null];
(statearr_54175[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__);

(statearr_54175[(1)] = (1));

return statearr_54175;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1 = (function (state_54155){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54155);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54176){var ex__2744__auto__ = e54176;
var statearr_54177_54193 = state_54155;
(statearr_54177_54193[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54155[(4)]))){
var statearr_54178_54194 = state_54155;
(statearr_54178_54194[(1)] = cljs.core.first((state_54155[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54195 = state_54155;
state_54155 = G__54195;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__ = function(state_54155){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1.call(this,state_54155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54179 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54179[(6)] = c__2763__auto__);

return statearr_54179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54245){
var state_val_54246 = (state_54245[(1)]);
if((state_val_54246 === (7))){
var state_54245__$1 = state_54245;
var statearr_54247_54280 = state_54245__$1;
(statearr_54247_54280[(2)] = subject);

(statearr_54247_54280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (1))){
var state_54245__$1 = state_54245;
var statearr_54248_54281 = state_54245__$1;
(statearr_54248_54281[(2)] = null);

(statearr_54248_54281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (4))){
var inst_54196 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
var statearr_54249_54282 = state_54245__$1;
(statearr_54249_54282[(2)] = inst_54196);

(statearr_54249_54282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (15))){
var inst_54209 = (state_54245[(7)]);
var state_54245__$1 = state_54245;
var statearr_54250_54283 = state_54245__$1;
(statearr_54250_54283[(2)] = inst_54209);

(statearr_54250_54283[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (13))){
var inst_54213 = (state_54245[(2)]);
var inst_54214 = fluree.db.util.async.throw_err(inst_54213);
var state_54245__$1 = state_54245;
var statearr_54251_54284 = state_54245__$1;
(statearr_54251_54284[(2)] = inst_54214);

(statearr_54251_54284[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (6))){
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54245__$1,(9),subject);
} else {
if((state_val_54246 === (17))){
var inst_54209 = (state_54245[(7)]);
var inst_54223 = cljs.core.first(inst_54209);
var state_54245__$1 = state_54245;
var statearr_54252_54285 = state_54245__$1;
(statearr_54252_54285[(2)] = inst_54223);

(statearr_54252_54285[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (3))){
var inst_54243 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54245__$1,inst_54243);
} else {
if((state_val_54246 === (12))){
var inst_54209 = (state_54245[(7)]);
var inst_54217 = (state_54245[(2)]);
var inst_54218 = cljs.core.vector_QMARK_(inst_54209);
var state_54245__$1 = (function (){var statearr_54253 = state_54245;
(statearr_54253[(8)] = inst_54217);

return statearr_54253;
})();
if(inst_54218){
var statearr_54254_54286 = state_54245__$1;
(statearr_54254_54286[(1)] = (14));

} else {
var statearr_54255_54287 = state_54245__$1;
(statearr_54255_54287[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (2))){
var _ = (function (){var statearr_54256 = state_54245;
(statearr_54256[(4)] = cljs.core.cons((5),(state_54245[(4)])));

return statearr_54256;
})();
var inst_54202 = fluree.db.util.async.channel_QMARK_(subject);
var state_54245__$1 = state_54245;
if(inst_54202){
var statearr_54257_54288 = state_54245__$1;
(statearr_54257_54288[(1)] = (6));

} else {
var statearr_54258_54289 = state_54245__$1;
(statearr_54258_54289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (19))){
var inst_54226 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
var statearr_54259_54290 = state_54245__$1;
(statearr_54259_54290[(2)] = inst_54226);

(statearr_54259_54290[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (11))){
var state_54245__$1 = state_54245;
var statearr_54261_54291 = state_54245__$1;
(statearr_54261_54291[(2)] = pred);

(statearr_54261_54291[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (9))){
var inst_54205 = (state_54245[(2)]);
var inst_54206 = fluree.db.util.async.throw_err(inst_54205);
var state_54245__$1 = state_54245;
var statearr_54262_54292 = state_54245__$1;
(statearr_54262_54292[(2)] = inst_54206);

(statearr_54262_54292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (5))){
var _ = (function (){var statearr_54263 = state_54245;
(statearr_54263[(4)] = cljs.core.rest((state_54245[(4)])));

return statearr_54263;
})();
var state_54245__$1 = state_54245;
var ex54260 = (state_54245__$1[(2)]);
var statearr_54264_54293 = state_54245__$1;
(statearr_54264_54293[(5)] = ex54260);


if((ex54260 instanceof Error)){
var statearr_54265_54294 = state_54245__$1;
(statearr_54265_54294[(1)] = (4));

(statearr_54265_54294[(5)] = null);

} else {
throw ex54260;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (14))){
var inst_54209 = (state_54245[(7)]);
var inst_54220 = cljs.core.count(inst_54209);
var inst_54221 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54220);
var state_54245__$1 = state_54245;
if(inst_54221){
var statearr_54266_54295 = state_54245__$1;
(statearr_54266_54295[(1)] = (17));

} else {
var statearr_54267_54296 = state_54245__$1;
(statearr_54267_54296[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (16))){
var inst_54217 = (state_54245[(8)]);
var inst_54209 = (state_54245[(7)]);
var inst_54229 = (state_54245[(2)]);
var inst_54230 = fluree.db.dbfunctions.internal.get(inst_54229,inst_54217);
var inst_54231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54232 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54234 = [inst_54209,inst_54217];
var inst_54235 = (new cljs.core.PersistentVector(null,2,(5),inst_54233,inst_54234,null));
var inst_54236 = ["get",inst_54235,inst_54230];
var inst_54237 = cljs.core.PersistentHashMap.fromArrays(inst_54232,inst_54236);
var inst_54238 = [inst_54237,(10)];
var inst_54239 = (new cljs.core.PersistentVector(null,2,(5),inst_54231,inst_54238,null));
var inst_54240 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54239);
var _ = (function (){var statearr_54268 = state_54245;
(statearr_54268[(4)] = cljs.core.rest((state_54245[(4)])));

return statearr_54268;
})();
var state_54245__$1 = (function (){var statearr_54269 = state_54245;
(statearr_54269[(9)] = inst_54240);

return statearr_54269;
})();
var statearr_54270_54297 = state_54245__$1;
(statearr_54270_54297[(2)] = inst_54230);

(statearr_54270_54297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (10))){
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54245__$1,(13),pred);
} else {
if((state_val_54246 === (18))){
var inst_54209 = (state_54245[(7)]);
var state_54245__$1 = state_54245;
var statearr_54271_54298 = state_54245__$1;
(statearr_54271_54298[(2)] = inst_54209);

(statearr_54271_54298[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (8))){
var inst_54209 = (state_54245[(2)]);
var inst_54210 = fluree.db.util.async.channel_QMARK_(pred);
var state_54245__$1 = (function (){var statearr_54272 = state_54245;
(statearr_54272[(7)] = inst_54209);

return statearr_54272;
})();
if(inst_54210){
var statearr_54273_54299 = state_54245__$1;
(statearr_54273_54299[(1)] = (10));

} else {
var statearr_54274_54300 = state_54245__$1;
(statearr_54274_54300[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0 = (function (){
var statearr_54275 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54275[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__);

(statearr_54275[(1)] = (1));

return statearr_54275;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1 = (function (state_54245){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54245);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54276){var ex__2744__auto__ = e54276;
var statearr_54277_54301 = state_54245;
(statearr_54277_54301[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54245[(4)]))){
var statearr_54278_54302 = state_54245;
(statearr_54278_54302[(1)] = cljs.core.first((state_54245[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54303 = state_54245;
state_54245 = G__54303;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__ = function(state_54245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1.call(this,state_54245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54279 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54279[(6)] = c__2763__auto__);

return statearr_54279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54342){
var state_val_54343 = (state_54342[(1)]);
if((state_val_54343 === (7))){
var inst_54310 = (state_54342[(7)]);
var state_54342__$1 = state_54342;
var statearr_54344_54368 = state_54342__$1;
(statearr_54344_54368[(2)] = inst_54310);

(statearr_54344_54368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (1))){
var state_54342__$1 = state_54342;
var statearr_54345_54369 = state_54342__$1;
(statearr_54345_54369[(2)] = null);

(statearr_54345_54369[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (4))){
var inst_54304 = (state_54342[(2)]);
var state_54342__$1 = state_54342;
var statearr_54346_54370 = state_54342__$1;
(statearr_54346_54370[(2)] = inst_54304);

(statearr_54346_54370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (6))){
var inst_54312 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54342__$1 = state_54342;
var statearr_54347_54371 = state_54342__$1;
(statearr_54347_54371[(2)] = inst_54312);

(statearr_54347_54371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (3))){
var inst_54340 = (state_54342[(2)]);
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54342__$1,inst_54340);
} else {
if((state_val_54343 === (12))){
var inst_54322 = (state_54342[(2)]);
var inst_54323 = fluree.db.util.async.throw_err(inst_54322);
var inst_54324 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54323,(0),null);
var inst_54325 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54323,(1),null);
var inst_54326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54327 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54328 = ["?pO","?ctx",inst_54324];
var inst_54329 = cljs.core.PersistentHashMap.fromArrays(inst_54327,inst_54328);
var inst_54330 = ((10) + inst_54325);
var inst_54331 = [inst_54329,inst_54330];
var inst_54332 = (new cljs.core.PersistentVector(null,2,(5),inst_54326,inst_54331,null));
var inst_54333 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54332);
var state_54342__$1 = (function (){var statearr_54348 = state_54342;
(statearr_54348[(8)] = inst_54333);

return statearr_54348;
})();
var statearr_54349_54372 = state_54342__$1;
(statearr_54349_54372[(2)] = inst_54324);

(statearr_54349_54372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (2))){
var inst_54310 = (state_54342[(7)]);
var _ = (function (){var statearr_54350 = state_54342;
(statearr_54350[(4)] = cljs.core.cons((5),(state_54342[(4)])));

return statearr_54350;
})();
var inst_54310__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54342__$1 = (function (){var statearr_54351 = state_54342;
(statearr_54351[(7)] = inst_54310__$1);

return statearr_54351;
})();
if(cljs.core.truth_(inst_54310__$1)){
var statearr_54352_54373 = state_54342__$1;
(statearr_54352_54373[(1)] = (6));

} else {
var statearr_54353_54374 = state_54342__$1;
(statearr_54353_54374[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (11))){
var inst_54337 = (state_54342[(2)]);
var _ = (function (){var statearr_54355 = state_54342;
(statearr_54355[(4)] = cljs.core.rest((state_54342[(4)])));

return statearr_54355;
})();
var state_54342__$1 = state_54342;
var statearr_54356_54375 = state_54342__$1;
(statearr_54356_54375[(2)] = inst_54337);

(statearr_54356_54375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (9))){
var inst_54320 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_54342__$1 = state_54342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54342__$1,(12),inst_54320);
} else {
if((state_val_54343 === (5))){
var _ = (function (){var statearr_54357 = state_54342;
(statearr_54357[(4)] = cljs.core.rest((state_54342[(4)])));

return statearr_54357;
})();
var state_54342__$1 = state_54342;
var ex54354 = (state_54342__$1[(2)]);
var statearr_54358_54376 = state_54342__$1;
(statearr_54358_54376[(5)] = ex54354);


if((ex54354 instanceof Error)){
var statearr_54359_54377 = state_54342__$1;
(statearr_54359_54377[(1)] = (4));

(statearr_54359_54377[(5)] = null);

} else {
throw ex54354;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (10))){
var inst_54335 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_54342__$1 = state_54342;
var statearr_54360_54378 = state_54342__$1;
(statearr_54360_54378[(2)] = inst_54335);

(statearr_54360_54378[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54343 === (8))){
var inst_54315 = (state_54342[(2)]);
var state_54342__$1 = state_54342;
if(cljs.core.truth_(inst_54315)){
var statearr_54361_54379 = state_54342__$1;
(statearr_54361_54379[(1)] = (9));

} else {
var statearr_54362_54380 = state_54342__$1;
(statearr_54362_54380[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0 = (function (){
var statearr_54363 = [null,null,null,null,null,null,null,null,null];
(statearr_54363[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__);

(statearr_54363[(1)] = (1));

return statearr_54363;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1 = (function (state_54342){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54342);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54364){var ex__2744__auto__ = e54364;
var statearr_54365_54381 = state_54342;
(statearr_54365_54381[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54342[(4)]))){
var statearr_54366_54382 = state_54342;
(statearr_54366_54382[(1)] = cljs.core.first((state_54342[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54383 = state_54342;
state_54342 = G__54383;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__ = function(state_54342){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1.call(this,state_54342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54367 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54367[(6)] = c__2763__auto__);

return statearr_54367;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54435){
var state_val_54436 = (state_54435[(1)]);
if((state_val_54436 === (7))){
var state_54435__$1 = state_54435;
var statearr_54437_54470 = state_54435__$1;
(statearr_54437_54470[(2)] = subject);

(statearr_54437_54470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (1))){
var state_54435__$1 = state_54435;
var statearr_54438_54471 = state_54435__$1;
(statearr_54438_54471[(2)] = null);

(statearr_54438_54471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (4))){
var inst_54384 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
var statearr_54439_54472 = state_54435__$1;
(statearr_54439_54472[(2)] = inst_54384);

(statearr_54439_54472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (15))){
var inst_54397 = (state_54435[(7)]);
var state_54435__$1 = state_54435;
var statearr_54440_54473 = state_54435__$1;
(statearr_54440_54473[(2)] = inst_54397);

(statearr_54440_54473[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (13))){
var inst_54401 = (state_54435[(2)]);
var inst_54402 = fluree.db.util.async.throw_err(inst_54401);
var state_54435__$1 = state_54435;
var statearr_54441_54474 = state_54435__$1;
(statearr_54441_54474[(2)] = inst_54402);

(statearr_54441_54474[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (6))){
var state_54435__$1 = state_54435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54435__$1,(9),subject);
} else {
if((state_val_54436 === (17))){
var inst_54397 = (state_54435[(7)]);
var inst_54411 = cljs.core.first(inst_54397);
var state_54435__$1 = state_54435;
var statearr_54442_54475 = state_54435__$1;
(statearr_54442_54475[(2)] = inst_54411);

(statearr_54442_54475[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (3))){
var inst_54433 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54435__$1,inst_54433);
} else {
if((state_val_54436 === (12))){
var inst_54397 = (state_54435[(7)]);
var inst_54405 = (state_54435[(2)]);
var inst_54406 = cljs.core.vector_QMARK_(inst_54397);
var state_54435__$1 = (function (){var statearr_54443 = state_54435;
(statearr_54443[(8)] = inst_54405);

return statearr_54443;
})();
if(inst_54406){
var statearr_54444_54476 = state_54435__$1;
(statearr_54444_54476[(1)] = (14));

} else {
var statearr_54445_54477 = state_54435__$1;
(statearr_54445_54477[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (2))){
var _ = (function (){var statearr_54446 = state_54435;
(statearr_54446[(4)] = cljs.core.cons((5),(state_54435[(4)])));

return statearr_54446;
})();
var inst_54390 = fluree.db.util.async.channel_QMARK_(subject);
var state_54435__$1 = state_54435;
if(inst_54390){
var statearr_54447_54478 = state_54435__$1;
(statearr_54447_54478[(1)] = (6));

} else {
var statearr_54448_54479 = state_54435__$1;
(statearr_54448_54479[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (19))){
var inst_54414 = (state_54435[(2)]);
var state_54435__$1 = state_54435;
var statearr_54449_54480 = state_54435__$1;
(statearr_54449_54480[(2)] = inst_54414);

(statearr_54449_54480[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (11))){
var state_54435__$1 = state_54435;
var statearr_54451_54481 = state_54435__$1;
(statearr_54451_54481[(2)] = path);

(statearr_54451_54481[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (9))){
var inst_54393 = (state_54435[(2)]);
var inst_54394 = fluree.db.util.async.throw_err(inst_54393);
var state_54435__$1 = state_54435;
var statearr_54452_54482 = state_54435__$1;
(statearr_54452_54482[(2)] = inst_54394);

(statearr_54452_54482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (5))){
var _ = (function (){var statearr_54453 = state_54435;
(statearr_54453[(4)] = cljs.core.rest((state_54435[(4)])));

return statearr_54453;
})();
var state_54435__$1 = state_54435;
var ex54450 = (state_54435__$1[(2)]);
var statearr_54454_54483 = state_54435__$1;
(statearr_54454_54483[(5)] = ex54450);


if((ex54450 instanceof Error)){
var statearr_54455_54484 = state_54435__$1;
(statearr_54455_54484[(1)] = (4));

(statearr_54455_54484[(5)] = null);

} else {
throw ex54450;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (14))){
var inst_54397 = (state_54435[(7)]);
var inst_54408 = cljs.core.count(inst_54397);
var inst_54409 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54408);
var state_54435__$1 = state_54435;
if(inst_54409){
var statearr_54456_54485 = state_54435__$1;
(statearr_54456_54485[(1)] = (17));

} else {
var statearr_54457_54486 = state_54435__$1;
(statearr_54457_54486[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (16))){
var inst_54405 = (state_54435[(8)]);
var inst_54397 = (state_54435[(7)]);
var inst_54417 = (state_54435[(2)]);
var inst_54418 = fluree.db.dbfunctions.internal.get_all(inst_54417,inst_54405);
var inst_54419 = cljs.core.count(inst_54405);
var inst_54420 = ((9) + inst_54419);
var inst_54421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54422 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54424 = [inst_54397,inst_54405];
var inst_54425 = (new cljs.core.PersistentVector(null,2,(5),inst_54423,inst_54424,null));
var inst_54426 = ["get-all",inst_54425,inst_54418];
var inst_54427 = cljs.core.PersistentHashMap.fromArrays(inst_54422,inst_54426);
var inst_54428 = [inst_54427,inst_54420];
var inst_54429 = (new cljs.core.PersistentVector(null,2,(5),inst_54421,inst_54428,null));
var inst_54430 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54429);
var _ = (function (){var statearr_54458 = state_54435;
(statearr_54458[(4)] = cljs.core.rest((state_54435[(4)])));

return statearr_54458;
})();
var state_54435__$1 = (function (){var statearr_54459 = state_54435;
(statearr_54459[(9)] = inst_54430);

return statearr_54459;
})();
var statearr_54460_54487 = state_54435__$1;
(statearr_54460_54487[(2)] = inst_54418);

(statearr_54460_54487[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (10))){
var state_54435__$1 = state_54435;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54435__$1,(13),path);
} else {
if((state_val_54436 === (18))){
var inst_54397 = (state_54435[(7)]);
var state_54435__$1 = state_54435;
var statearr_54461_54488 = state_54435__$1;
(statearr_54461_54488[(2)] = inst_54397);

(statearr_54461_54488[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54436 === (8))){
var inst_54397 = (state_54435[(2)]);
var inst_54398 = fluree.db.util.async.channel_QMARK_(path);
var state_54435__$1 = (function (){var statearr_54462 = state_54435;
(statearr_54462[(7)] = inst_54397);

return statearr_54462;
})();
if(inst_54398){
var statearr_54463_54489 = state_54435__$1;
(statearr_54463_54489[(1)] = (10));

} else {
var statearr_54464_54490 = state_54435__$1;
(statearr_54464_54490[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0 = (function (){
var statearr_54465 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54465[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__);

(statearr_54465[(1)] = (1));

return statearr_54465;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1 = (function (state_54435){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54435);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54466){var ex__2744__auto__ = e54466;
var statearr_54467_54491 = state_54435;
(statearr_54467_54491[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54435[(4)]))){
var statearr_54468_54492 = state_54435;
(statearr_54468_54492[(1)] = cljs.core.first((state_54435[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54493 = state_54435;
state_54435 = G__54493;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__ = function(state_54435){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1.call(this,state_54435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54469 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54469[(6)] = c__2763__auto__);

return statearr_54469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54532){
var state_val_54533 = (state_54532[(1)]);
if((state_val_54533 === (7))){
var state_54532__$1 = state_54532;
var statearr_54534_54558 = state_54532__$1;
(statearr_54534_54558[(2)] = subject);

(statearr_54534_54558[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (1))){
var state_54532__$1 = state_54532;
var statearr_54535_54559 = state_54532__$1;
(statearr_54535_54559[(2)] = null);

(statearr_54535_54559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (4))){
var inst_54494 = (state_54532[(2)]);
var state_54532__$1 = state_54532;
var statearr_54536_54560 = state_54532__$1;
(statearr_54536_54560[(2)] = inst_54494);

(statearr_54536_54560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (13))){
var inst_54511 = (state_54532[(2)]);
var inst_54512 = fluree.db.util.async.throw_err(inst_54511);
var state_54532__$1 = state_54532;
var statearr_54537_54561 = state_54532__$1;
(statearr_54537_54561[(2)] = inst_54512);

(statearr_54537_54561[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (6))){
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54532__$1,(9),subject);
} else {
if((state_val_54533 === (3))){
var inst_54530 = (state_54532[(2)]);
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54532__$1,inst_54530);
} else {
if((state_val_54533 === (12))){
var inst_54507 = (state_54532[(7)]);
var inst_54515 = (state_54532[(2)]);
var inst_54516 = fluree.db.dbfunctions.internal.get_in(inst_54507,inst_54515);
var inst_54517 = cljs.core.count(inst_54515);
var inst_54518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54519 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54521 = [inst_54507,inst_54515];
var inst_54522 = (new cljs.core.PersistentVector(null,2,(5),inst_54520,inst_54521,null));
var inst_54523 = ["get-in",inst_54522,inst_54516];
var inst_54524 = cljs.core.PersistentHashMap.fromArrays(inst_54519,inst_54523);
var inst_54525 = [inst_54524,inst_54517];
var inst_54526 = (new cljs.core.PersistentVector(null,2,(5),inst_54518,inst_54525,null));
var inst_54527 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54526);
var _ = (function (){var statearr_54538 = state_54532;
(statearr_54538[(4)] = cljs.core.rest((state_54532[(4)])));

return statearr_54538;
})();
var state_54532__$1 = (function (){var statearr_54539 = state_54532;
(statearr_54539[(8)] = inst_54527);

return statearr_54539;
})();
var statearr_54540_54562 = state_54532__$1;
(statearr_54540_54562[(2)] = inst_54516);

(statearr_54540_54562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (2))){
var _ = (function (){var statearr_54541 = state_54532;
(statearr_54541[(4)] = cljs.core.cons((5),(state_54532[(4)])));

return statearr_54541;
})();
var inst_54500 = fluree.db.util.async.channel_QMARK_(subject);
var state_54532__$1 = state_54532;
if(inst_54500){
var statearr_54542_54563 = state_54532__$1;
(statearr_54542_54563[(1)] = (6));

} else {
var statearr_54543_54564 = state_54532__$1;
(statearr_54543_54564[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (11))){
var state_54532__$1 = state_54532;
var statearr_54545_54565 = state_54532__$1;
(statearr_54545_54565[(2)] = path);

(statearr_54545_54565[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (9))){
var inst_54503 = (state_54532[(2)]);
var inst_54504 = fluree.db.util.async.throw_err(inst_54503);
var state_54532__$1 = state_54532;
var statearr_54546_54566 = state_54532__$1;
(statearr_54546_54566[(2)] = inst_54504);

(statearr_54546_54566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (5))){
var _ = (function (){var statearr_54547 = state_54532;
(statearr_54547[(4)] = cljs.core.rest((state_54532[(4)])));

return statearr_54547;
})();
var state_54532__$1 = state_54532;
var ex54544 = (state_54532__$1[(2)]);
var statearr_54548_54567 = state_54532__$1;
(statearr_54548_54567[(5)] = ex54544);


if((ex54544 instanceof Error)){
var statearr_54549_54568 = state_54532__$1;
(statearr_54549_54568[(1)] = (4));

(statearr_54549_54568[(5)] = null);

} else {
throw ex54544;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54533 === (10))){
var state_54532__$1 = state_54532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54532__$1,(13),path);
} else {
if((state_val_54533 === (8))){
var inst_54507 = (state_54532[(2)]);
var inst_54508 = fluree.db.util.async.channel_QMARK_(path);
var state_54532__$1 = (function (){var statearr_54550 = state_54532;
(statearr_54550[(7)] = inst_54507);

return statearr_54550;
})();
if(inst_54508){
var statearr_54551_54569 = state_54532__$1;
(statearr_54551_54569[(1)] = (10));

} else {
var statearr_54552_54570 = state_54532__$1;
(statearr_54552_54570[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0 = (function (){
var statearr_54553 = [null,null,null,null,null,null,null,null,null];
(statearr_54553[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__);

(statearr_54553[(1)] = (1));

return statearr_54553;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1 = (function (state_54532){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54532);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54554){var ex__2744__auto__ = e54554;
var statearr_54555_54571 = state_54532;
(statearr_54555_54571[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54532[(4)]))){
var statearr_54556_54572 = state_54532;
(statearr_54556_54572[(1)] = cljs.core.first((state_54532[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54573 = state_54532;
state_54532 = G__54573;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__ = function(state_54532){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1.call(this,state_54532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54557 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54557[(6)] = c__2763__auto__);

return statearr_54557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54618){
var state_val_54619 = (state_54618[(1)]);
if((state_val_54619 === (7))){
var state_54618__$1 = state_54618;
var statearr_54620_54649 = state_54618__$1;
(statearr_54620_54649[(2)] = coll);

(statearr_54620_54649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (1))){
var state_54618__$1 = state_54618;
var statearr_54621_54650 = state_54618__$1;
(statearr_54621_54650[(2)] = null);

(statearr_54621_54650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (4))){
var inst_54574 = (state_54618[(2)]);
var state_54618__$1 = state_54618;
var statearr_54622_54651 = state_54618__$1;
(statearr_54622_54651[(2)] = inst_54574);

(statearr_54622_54651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (15))){
var inst_54594 = (state_54618[(7)]);
var inst_54602 = (state_54618[(2)]);
var inst_54603 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_54594,inst_54602);
var inst_54604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54605 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54607 = [inst_54594,inst_54602];
var inst_54608 = (new cljs.core.PersistentVector(null,2,(5),inst_54606,inst_54607,null));
var inst_54609 = ["contains?",inst_54608,inst_54603];
var inst_54610 = cljs.core.PersistentHashMap.fromArrays(inst_54605,inst_54609);
var inst_54611 = [inst_54610,(10)];
var inst_54612 = (new cljs.core.PersistentVector(null,2,(5),inst_54604,inst_54611,null));
var inst_54613 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54612);
var _ = (function (){var statearr_54623 = state_54618;
(statearr_54623[(4)] = cljs.core.rest((state_54618[(4)])));

return statearr_54623;
})();
var state_54618__$1 = (function (){var statearr_54624 = state_54618;
(statearr_54624[(8)] = inst_54613);

return statearr_54624;
})();
var statearr_54625_54652 = state_54618__$1;
(statearr_54625_54652[(2)] = inst_54603);

(statearr_54625_54652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (13))){
var state_54618__$1 = state_54618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54618__$1,(16),key);
} else {
if((state_val_54619 === (6))){
var state_54618__$1 = state_54618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54618__$1,(9),coll);
} else {
if((state_val_54619 === (3))){
var inst_54616 = (state_54618[(2)]);
var state_54618__$1 = state_54618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54618__$1,inst_54616);
} else {
if((state_val_54619 === (12))){
var inst_54594 = (state_54618[(2)]);
var inst_54595 = fluree.db.util.async.channel_QMARK_(key);
var state_54618__$1 = (function (){var statearr_54626 = state_54618;
(statearr_54626[(7)] = inst_54594);

return statearr_54626;
})();
if(inst_54595){
var statearr_54627_54653 = state_54618__$1;
(statearr_54627_54653[(1)] = (13));

} else {
var statearr_54628_54654 = state_54618__$1;
(statearr_54628_54654[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (2))){
var _ = (function (){var statearr_54629 = state_54618;
(statearr_54629[(4)] = cljs.core.cons((5),(state_54618[(4)])));

return statearr_54629;
})();
var inst_54580 = fluree.db.util.async.channel_QMARK_(coll);
var state_54618__$1 = state_54618;
if(inst_54580){
var statearr_54630_54655 = state_54618__$1;
(statearr_54630_54655[(1)] = (6));

} else {
var statearr_54631_54656 = state_54618__$1;
(statearr_54631_54656[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (11))){
var inst_54587 = (state_54618[(9)]);
var inst_54591 = cljs.core.flatten(inst_54587);
var inst_54592 = cljs.core.set(inst_54591);
var state_54618__$1 = state_54618;
var statearr_54633_54657 = state_54618__$1;
(statearr_54633_54657[(2)] = inst_54592);

(statearr_54633_54657[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (9))){
var inst_54583 = (state_54618[(2)]);
var inst_54584 = fluree.db.util.async.throw_err(inst_54583);
var state_54618__$1 = state_54618;
var statearr_54634_54658 = state_54618__$1;
(statearr_54634_54658[(2)] = inst_54584);

(statearr_54634_54658[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (5))){
var _ = (function (){var statearr_54635 = state_54618;
(statearr_54635[(4)] = cljs.core.rest((state_54618[(4)])));

return statearr_54635;
})();
var state_54618__$1 = state_54618;
var ex54632 = (state_54618__$1[(2)]);
var statearr_54636_54659 = state_54618__$1;
(statearr_54636_54659[(5)] = ex54632);


if((ex54632 instanceof Error)){
var statearr_54637_54660 = state_54618__$1;
(statearr_54637_54660[(1)] = (4));

(statearr_54637_54660[(5)] = null);

} else {
throw ex54632;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (14))){
var state_54618__$1 = state_54618;
var statearr_54638_54661 = state_54618__$1;
(statearr_54638_54661[(2)] = key);

(statearr_54638_54661[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (16))){
var inst_54598 = (state_54618[(2)]);
var inst_54599 = fluree.db.util.async.throw_err(inst_54598);
var state_54618__$1 = state_54618;
var statearr_54639_54662 = state_54618__$1;
(statearr_54639_54662[(2)] = inst_54599);

(statearr_54639_54662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (10))){
var inst_54587 = (state_54618[(9)]);
var state_54618__$1 = state_54618;
var statearr_54640_54663 = state_54618__$1;
(statearr_54640_54663[(2)] = inst_54587);

(statearr_54640_54663[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54619 === (8))){
var inst_54587 = (state_54618[(9)]);
var inst_54587__$1 = (state_54618[(2)]);
var inst_54588 = cljs.core.set_QMARK_(inst_54587__$1);
var state_54618__$1 = (function (){var statearr_54641 = state_54618;
(statearr_54641[(9)] = inst_54587__$1);

return statearr_54641;
})();
if(inst_54588){
var statearr_54642_54664 = state_54618__$1;
(statearr_54642_54664[(1)] = (10));

} else {
var statearr_54643_54665 = state_54618__$1;
(statearr_54643_54665[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_54644 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54644[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__);

(statearr_54644[(1)] = (1));

return statearr_54644;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1 = (function (state_54618){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54618);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54645){var ex__2744__auto__ = e54645;
var statearr_54646_54666 = state_54618;
(statearr_54646_54666[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54618[(4)]))){
var statearr_54647_54667 = state_54618;
(statearr_54647_54667[(1)] = cljs.core.first((state_54618[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54668 = state_54618;
state_54618 = G__54668;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__ = function(state_54618){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1.call(this,state_54618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54648 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54648[(6)] = c__2763__auto__);

return statearr_54648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54740 = arguments.length;
var i__4865__auto___54741 = (0);
while(true){
if((i__4865__auto___54741 < len__4864__auto___54740)){
args__4870__auto__.push((arguments[i__4865__auto___54741]));

var G__54742 = (i__4865__auto___54741 + (1));
i__4865__auto___54741 = G__54742;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54714){
var state_val_54715 = (state_54714[(1)]);
if((state_val_54715 === (7))){
var inst_54680 = (state_54714[(7)]);
var inst_54684 = cljs.core.first(inst_54680);
var inst_54685 = cljs.core.coll_QMARK_(inst_54684);
var state_54714__$1 = state_54714;
var statearr_54716_54743 = state_54714__$1;
(statearr_54716_54743[(2)] = inst_54685);

(statearr_54716_54743[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (1))){
var state_54714__$1 = state_54714;
var statearr_54717_54744 = state_54714__$1;
(statearr_54717_54744[(2)] = null);

(statearr_54717_54744[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (4))){
var inst_54671 = (state_54714[(2)]);
var state_54714__$1 = state_54714;
var statearr_54718_54745 = state_54714__$1;
(statearr_54718_54745[(2)] = inst_54671);

(statearr_54718_54745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (6))){
var inst_54680 = (state_54714[(7)]);
var inst_54682 = (state_54714[(8)]);
var inst_54679 = (state_54714[(2)]);
var inst_54680__$1 = fluree.db.util.async.throw_err(inst_54679);
var inst_54681 = cljs.core.count(inst_54680__$1);
var inst_54682__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54681);
var state_54714__$1 = (function (){var statearr_54719 = state_54714;
(statearr_54719[(7)] = inst_54680__$1);

(statearr_54719[(8)] = inst_54682__$1);

return statearr_54719;
})();
if(inst_54682__$1){
var statearr_54720_54746 = state_54714__$1;
(statearr_54720_54746[(1)] = (7));

} else {
var statearr_54721_54747 = state_54714__$1;
(statearr_54721_54747[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (3))){
var inst_54712 = (state_54714[(2)]);
var state_54714__$1 = state_54714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54714__$1,inst_54712);
} else {
if((state_val_54715 === (12))){
var inst_54693 = (state_54714[(2)]);
var inst_54694 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_54693);
var inst_54695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54696 = [inst_54693];
var inst_54697 = (new cljs.core.PersistentVector(null,1,(5),inst_54695,inst_54696,null));
var inst_54698 = cljs.core.count(inst_54697);
var inst_54699 = ((9) + inst_54698);
var inst_54700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54701 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54703 = [inst_54693];
var inst_54704 = (new cljs.core.PersistentVector(null,1,(5),inst_54702,inst_54703,null));
var inst_54705 = ["hash-set",inst_54704,inst_54694];
var inst_54706 = cljs.core.PersistentHashMap.fromArrays(inst_54701,inst_54705);
var inst_54707 = [inst_54706,inst_54699];
var inst_54708 = (new cljs.core.PersistentVector(null,2,(5),inst_54700,inst_54707,null));
var inst_54709 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54708);
var _ = (function (){var statearr_54722 = state_54714;
(statearr_54722[(4)] = cljs.core.rest((state_54714[(4)])));

return statearr_54722;
})();
var state_54714__$1 = (function (){var statearr_54723 = state_54714;
(statearr_54723[(9)] = inst_54709);

return statearr_54723;
})();
var statearr_54724_54748 = state_54714__$1;
(statearr_54724_54748[(2)] = inst_54694);

(statearr_54724_54748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (2))){
var _ = (function (){var statearr_54725 = state_54714;
(statearr_54725[(4)] = cljs.core.cons((5),(state_54714[(4)])));

return statearr_54725;
})();
var inst_54677 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54714__$1 = state_54714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54714__$1,(6),inst_54677);
} else {
if((state_val_54715 === (11))){
var inst_54680 = (state_54714[(7)]);
var state_54714__$1 = state_54714;
var statearr_54727_54749 = state_54714__$1;
(statearr_54727_54749[(2)] = inst_54680);

(statearr_54727_54749[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (9))){
var inst_54688 = (state_54714[(2)]);
var state_54714__$1 = state_54714;
if(cljs.core.truth_(inst_54688)){
var statearr_54728_54750 = state_54714__$1;
(statearr_54728_54750[(1)] = (10));

} else {
var statearr_54729_54751 = state_54714__$1;
(statearr_54729_54751[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (5))){
var _ = (function (){var statearr_54730 = state_54714;
(statearr_54730[(4)] = cljs.core.rest((state_54714[(4)])));

return statearr_54730;
})();
var state_54714__$1 = state_54714;
var ex54726 = (state_54714__$1[(2)]);
var statearr_54731_54752 = state_54714__$1;
(statearr_54731_54752[(5)] = ex54726);


if((ex54726 instanceof Error)){
var statearr_54732_54753 = state_54714__$1;
(statearr_54732_54753[(1)] = (4));

(statearr_54732_54753[(5)] = null);

} else {
throw ex54726;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (10))){
var inst_54680 = (state_54714[(7)]);
var inst_54690 = cljs.core.first(inst_54680);
var state_54714__$1 = state_54714;
var statearr_54733_54754 = state_54714__$1;
(statearr_54733_54754[(2)] = inst_54690);

(statearr_54733_54754[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54715 === (8))){
var inst_54682 = (state_54714[(8)]);
var state_54714__$1 = state_54714;
var statearr_54734_54755 = state_54714__$1;
(statearr_54734_54755[(2)] = inst_54682);

(statearr_54734_54755[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54735 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54735[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54735[(1)] = (1));

return statearr_54735;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54714){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54714);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54736){var ex__2744__auto__ = e54736;
var statearr_54737_54756 = state_54714;
(statearr_54737_54756[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54714[(4)]))){
var statearr_54738_54757 = state_54714;
(statearr_54738_54757[(1)] = cljs.core.first((state_54714[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54758 = state_54714;
state_54714 = G__54758;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54714){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54739 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54739[(6)] = c__2763__auto__);

return statearr_54739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq54669){
var G__54670 = cljs.core.first(seq54669);
var seq54669__$1 = cljs.core.next(seq54669);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54670,seq54669__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54808 = arguments.length;
var i__4865__auto___54809 = (0);
while(true){
if((i__4865__auto___54809 < len__4864__auto___54808)){
args__4870__auto__.push((arguments[i__4865__auto___54809]));

var G__54810 = (i__4865__auto___54809 + (1));
i__4865__auto___54809 = G__54810;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54791){
var state_val_54792 = (state_54791[(1)]);
if((state_val_54792 === (1))){
var state_54791__$1 = state_54791;
var statearr_54793_54811 = state_54791__$1;
(statearr_54793_54811[(2)] = null);

(statearr_54793_54811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (2))){
var _ = (function (){var statearr_54794 = state_54791;
(statearr_54794[(4)] = cljs.core.cons((5),(state_54791[(4)])));

return statearr_54794;
})();
var inst_54767 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54791__$1 = state_54791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54791__$1,(6),inst_54767);
} else {
if((state_val_54792 === (3))){
var inst_54789 = (state_54791[(2)]);
var state_54791__$1 = state_54791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54791__$1,inst_54789);
} else {
if((state_val_54792 === (4))){
var inst_54761 = (state_54791[(2)]);
var state_54791__$1 = state_54791;
var statearr_54796_54812 = state_54791__$1;
(statearr_54796_54812[(2)] = inst_54761);

(statearr_54796_54812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (5))){
var _ = (function (){var statearr_54797 = state_54791;
(statearr_54797[(4)] = cljs.core.rest((state_54791[(4)])));

return statearr_54797;
})();
var state_54791__$1 = state_54791;
var ex54795 = (state_54791__$1[(2)]);
var statearr_54798_54813 = state_54791__$1;
(statearr_54798_54813[(5)] = ex54795);


if((ex54795 instanceof Error)){
var statearr_54799_54814 = state_54791__$1;
(statearr_54799_54814[(1)] = (4));

(statearr_54799_54814[(5)] = null);

} else {
throw ex54795;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54792 === (6))){
var inst_54769 = (state_54791[(2)]);
var inst_54770 = fluree.db.util.async.throw_err(inst_54769);
var inst_54771 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_54770);
var inst_54772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54773 = [inst_54770];
var inst_54774 = (new cljs.core.PersistentVector(null,1,(5),inst_54772,inst_54773,null));
var inst_54775 = cljs.core.count(inst_54774);
var inst_54776 = ((9) + inst_54775);
var inst_54777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54778 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54780 = [inst_54770];
var inst_54781 = (new cljs.core.PersistentVector(null,1,(5),inst_54779,inst_54780,null));
var inst_54782 = ["==",inst_54781,inst_54771];
var inst_54783 = cljs.core.PersistentHashMap.fromArrays(inst_54778,inst_54782);
var inst_54784 = [inst_54783,inst_54776];
var inst_54785 = (new cljs.core.PersistentVector(null,2,(5),inst_54777,inst_54784,null));
var inst_54786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54785);
var _ = (function (){var statearr_54800 = state_54791;
(statearr_54800[(4)] = cljs.core.rest((state_54791[(4)])));

return statearr_54800;
})();
var state_54791__$1 = (function (){var statearr_54801 = state_54791;
(statearr_54801[(7)] = inst_54786);

return statearr_54801;
})();
var statearr_54802_54815 = state_54791__$1;
(statearr_54802_54815[(2)] = inst_54771);

(statearr_54802_54815[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54803 = [null,null,null,null,null,null,null,null];
(statearr_54803[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54803[(1)] = (1));

return statearr_54803;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54791){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54791);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54804){var ex__2744__auto__ = e54804;
var statearr_54805_54816 = state_54791;
(statearr_54805_54816[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54791[(4)]))){
var statearr_54806_54817 = state_54791;
(statearr_54806_54817[(1)] = cljs.core.first((state_54791[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54818 = state_54791;
state_54791 = G__54818;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54807 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54807[(6)] = c__2763__auto__);

return statearr_54807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq54759){
var G__54760 = cljs.core.first(seq54759);
var seq54759__$1 = cljs.core.next(seq54759);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54760,seq54759__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54868 = arguments.length;
var i__4865__auto___54869 = (0);
while(true){
if((i__4865__auto___54869 < len__4864__auto___54868)){
args__4870__auto__.push((arguments[i__4865__auto___54869]));

var G__54870 = (i__4865__auto___54869 + (1));
i__4865__auto___54869 = G__54870;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54851){
var state_val_54852 = (state_54851[(1)]);
if((state_val_54852 === (1))){
var state_54851__$1 = state_54851;
var statearr_54853_54871 = state_54851__$1;
(statearr_54853_54871[(2)] = null);

(statearr_54853_54871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54852 === (2))){
var _ = (function (){var statearr_54854 = state_54851;
(statearr_54854[(4)] = cljs.core.cons((5),(state_54851[(4)])));

return statearr_54854;
})();
var inst_54827 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54851__$1 = state_54851;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54851__$1,(6),inst_54827);
} else {
if((state_val_54852 === (3))){
var inst_54849 = (state_54851[(2)]);
var state_54851__$1 = state_54851;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54851__$1,inst_54849);
} else {
if((state_val_54852 === (4))){
var inst_54821 = (state_54851[(2)]);
var state_54851__$1 = state_54851;
var statearr_54856_54872 = state_54851__$1;
(statearr_54856_54872[(2)] = inst_54821);

(statearr_54856_54872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54852 === (5))){
var _ = (function (){var statearr_54857 = state_54851;
(statearr_54857[(4)] = cljs.core.rest((state_54851[(4)])));

return statearr_54857;
})();
var state_54851__$1 = state_54851;
var ex54855 = (state_54851__$1[(2)]);
var statearr_54858_54873 = state_54851__$1;
(statearr_54858_54873[(5)] = ex54855);


if((ex54855 instanceof Error)){
var statearr_54859_54874 = state_54851__$1;
(statearr_54859_54874[(1)] = (4));

(statearr_54859_54874[(5)] = null);

} else {
throw ex54855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54852 === (6))){
var inst_54829 = (state_54851[(2)]);
var inst_54830 = fluree.db.util.async.throw_err(inst_54829);
var inst_54831 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_54830);
var inst_54832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54833 = [inst_54830];
var inst_54834 = (new cljs.core.PersistentVector(null,1,(5),inst_54832,inst_54833,null));
var inst_54835 = cljs.core.count(inst_54834);
var inst_54836 = ((9) + inst_54835);
var inst_54837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54838 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54840 = [inst_54830];
var inst_54841 = (new cljs.core.PersistentVector(null,1,(5),inst_54839,inst_54840,null));
var inst_54842 = [">",inst_54841,inst_54831];
var inst_54843 = cljs.core.PersistentHashMap.fromArrays(inst_54838,inst_54842);
var inst_54844 = [inst_54843,inst_54836];
var inst_54845 = (new cljs.core.PersistentVector(null,2,(5),inst_54837,inst_54844,null));
var inst_54846 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54845);
var _ = (function (){var statearr_54860 = state_54851;
(statearr_54860[(4)] = cljs.core.rest((state_54851[(4)])));

return statearr_54860;
})();
var state_54851__$1 = (function (){var statearr_54861 = state_54851;
(statearr_54861[(7)] = inst_54846);

return statearr_54861;
})();
var statearr_54862_54875 = state_54851__$1;
(statearr_54862_54875[(2)] = inst_54831);

(statearr_54862_54875[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54863 = [null,null,null,null,null,null,null,null];
(statearr_54863[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54863[(1)] = (1));

return statearr_54863;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54851){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54851);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54864){var ex__2744__auto__ = e54864;
var statearr_54865_54876 = state_54851;
(statearr_54865_54876[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54851[(4)]))){
var statearr_54866_54877 = state_54851;
(statearr_54866_54877[(1)] = cljs.core.first((state_54851[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54878 = state_54851;
state_54851 = G__54878;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54851){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54867 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54867[(6)] = c__2763__auto__);

return statearr_54867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq54819){
var G__54820 = cljs.core.first(seq54819);
var seq54819__$1 = cljs.core.next(seq54819);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54820,seq54819__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54928 = arguments.length;
var i__4865__auto___54929 = (0);
while(true){
if((i__4865__auto___54929 < len__4864__auto___54928)){
args__4870__auto__.push((arguments[i__4865__auto___54929]));

var G__54930 = (i__4865__auto___54929 + (1));
i__4865__auto___54929 = G__54930;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54911){
var state_val_54912 = (state_54911[(1)]);
if((state_val_54912 === (1))){
var state_54911__$1 = state_54911;
var statearr_54913_54931 = state_54911__$1;
(statearr_54913_54931[(2)] = null);

(statearr_54913_54931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (2))){
var _ = (function (){var statearr_54914 = state_54911;
(statearr_54914[(4)] = cljs.core.cons((5),(state_54911[(4)])));

return statearr_54914;
})();
var inst_54887 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54911__$1 = state_54911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54911__$1,(6),inst_54887);
} else {
if((state_val_54912 === (3))){
var inst_54909 = (state_54911[(2)]);
var state_54911__$1 = state_54911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54911__$1,inst_54909);
} else {
if((state_val_54912 === (4))){
var inst_54881 = (state_54911[(2)]);
var state_54911__$1 = state_54911;
var statearr_54916_54932 = state_54911__$1;
(statearr_54916_54932[(2)] = inst_54881);

(statearr_54916_54932[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (5))){
var _ = (function (){var statearr_54917 = state_54911;
(statearr_54917[(4)] = cljs.core.rest((state_54911[(4)])));

return statearr_54917;
})();
var state_54911__$1 = state_54911;
var ex54915 = (state_54911__$1[(2)]);
var statearr_54918_54933 = state_54911__$1;
(statearr_54918_54933[(5)] = ex54915);


if((ex54915 instanceof Error)){
var statearr_54919_54934 = state_54911__$1;
(statearr_54919_54934[(1)] = (4));

(statearr_54919_54934[(5)] = null);

} else {
throw ex54915;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54912 === (6))){
var inst_54889 = (state_54911[(2)]);
var inst_54890 = fluree.db.util.async.throw_err(inst_54889);
var inst_54891 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_54890);
var inst_54892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54893 = [inst_54890];
var inst_54894 = (new cljs.core.PersistentVector(null,1,(5),inst_54892,inst_54893,null));
var inst_54895 = cljs.core.count(inst_54894);
var inst_54896 = ((9) + inst_54895);
var inst_54897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54898 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54900 = [inst_54890];
var inst_54901 = (new cljs.core.PersistentVector(null,1,(5),inst_54899,inst_54900,null));
var inst_54902 = ["<",inst_54901,inst_54891];
var inst_54903 = cljs.core.PersistentHashMap.fromArrays(inst_54898,inst_54902);
var inst_54904 = [inst_54903,inst_54896];
var inst_54905 = (new cljs.core.PersistentVector(null,2,(5),inst_54897,inst_54904,null));
var inst_54906 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54905);
var _ = (function (){var statearr_54920 = state_54911;
(statearr_54920[(4)] = cljs.core.rest((state_54911[(4)])));

return statearr_54920;
})();
var state_54911__$1 = (function (){var statearr_54921 = state_54911;
(statearr_54921[(7)] = inst_54906);

return statearr_54921;
})();
var statearr_54922_54935 = state_54911__$1;
(statearr_54922_54935[(2)] = inst_54891);

(statearr_54922_54935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54923 = [null,null,null,null,null,null,null,null];
(statearr_54923[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54923[(1)] = (1));

return statearr_54923;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54911){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54911);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54924){var ex__2744__auto__ = e54924;
var statearr_54925_54936 = state_54911;
(statearr_54925_54936[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54911[(4)]))){
var statearr_54926_54937 = state_54911;
(statearr_54926_54937[(1)] = cljs.core.first((state_54911[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54938 = state_54911;
state_54911 = G__54938;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54911){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54927 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54927[(6)] = c__2763__auto__);

return statearr_54927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq54879){
var G__54880 = cljs.core.first(seq54879);
var seq54879__$1 = cljs.core.next(seq54879);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54880,seq54879__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___54988 = arguments.length;
var i__4865__auto___54989 = (0);
while(true){
if((i__4865__auto___54989 < len__4864__auto___54988)){
args__4870__auto__.push((arguments[i__4865__auto___54989]));

var G__54990 = (i__4865__auto___54989 + (1));
i__4865__auto___54989 = G__54990;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_54971){
var state_val_54972 = (state_54971[(1)]);
if((state_val_54972 === (1))){
var state_54971__$1 = state_54971;
var statearr_54973_54991 = state_54971__$1;
(statearr_54973_54991[(2)] = null);

(statearr_54973_54991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54972 === (2))){
var _ = (function (){var statearr_54974 = state_54971;
(statearr_54974[(4)] = cljs.core.cons((5),(state_54971[(4)])));

return statearr_54974;
})();
var inst_54947 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54971__$1 = state_54971;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54971__$1,(6),inst_54947);
} else {
if((state_val_54972 === (3))){
var inst_54969 = (state_54971[(2)]);
var state_54971__$1 = state_54971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54971__$1,inst_54969);
} else {
if((state_val_54972 === (4))){
var inst_54941 = (state_54971[(2)]);
var state_54971__$1 = state_54971;
var statearr_54976_54992 = state_54971__$1;
(statearr_54976_54992[(2)] = inst_54941);

(statearr_54976_54992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54972 === (5))){
var _ = (function (){var statearr_54977 = state_54971;
(statearr_54977[(4)] = cljs.core.rest((state_54971[(4)])));

return statearr_54977;
})();
var state_54971__$1 = state_54971;
var ex54975 = (state_54971__$1[(2)]);
var statearr_54978_54993 = state_54971__$1;
(statearr_54978_54993[(5)] = ex54975);


if((ex54975 instanceof Error)){
var statearr_54979_54994 = state_54971__$1;
(statearr_54979_54994[(1)] = (4));

(statearr_54979_54994[(5)] = null);

} else {
throw ex54975;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54972 === (6))){
var inst_54949 = (state_54971[(2)]);
var inst_54950 = fluree.db.util.async.throw_err(inst_54949);
var inst_54951 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_54950);
var inst_54952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54953 = [inst_54950];
var inst_54954 = (new cljs.core.PersistentVector(null,1,(5),inst_54952,inst_54953,null));
var inst_54955 = cljs.core.count(inst_54954);
var inst_54956 = ((9) + inst_54955);
var inst_54957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54958 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54960 = [inst_54950];
var inst_54961 = (new cljs.core.PersistentVector(null,1,(5),inst_54959,inst_54960,null));
var inst_54962 = ["<=",inst_54961,inst_54951];
var inst_54963 = cljs.core.PersistentHashMap.fromArrays(inst_54958,inst_54962);
var inst_54964 = [inst_54963,inst_54956];
var inst_54965 = (new cljs.core.PersistentVector(null,2,(5),inst_54957,inst_54964,null));
var inst_54966 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54965);
var _ = (function (){var statearr_54980 = state_54971;
(statearr_54980[(4)] = cljs.core.rest((state_54971[(4)])));

return statearr_54980;
})();
var state_54971__$1 = (function (){var statearr_54981 = state_54971;
(statearr_54981[(7)] = inst_54966);

return statearr_54981;
})();
var statearr_54982_54995 = state_54971__$1;
(statearr_54982_54995[(2)] = inst_54951);

(statearr_54982_54995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_54983 = [null,null,null,null,null,null,null,null];
(statearr_54983[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_54983[(1)] = (1));

return statearr_54983;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_54971){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_54971);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e54984){var ex__2744__auto__ = e54984;
var statearr_54985_54996 = state_54971;
(statearr_54985_54996[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_54971[(4)]))){
var statearr_54986_54997 = state_54971;
(statearr_54986_54997[(1)] = cljs.core.first((state_54971[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54998 = state_54971;
state_54971 = G__54998;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_54971){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_54971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_54987 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_54987[(6)] = c__2763__auto__);

return statearr_54987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq54939){
var G__54940 = cljs.core.first(seq54939);
var seq54939__$1 = cljs.core.next(seq54939);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54940,seq54939__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55048 = arguments.length;
var i__4865__auto___55049 = (0);
while(true){
if((i__4865__auto___55049 < len__4864__auto___55048)){
args__4870__auto__.push((arguments[i__4865__auto___55049]));

var G__55050 = (i__4865__auto___55049 + (1));
i__4865__auto___55049 = G__55050;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55031){
var state_val_55032 = (state_55031[(1)]);
if((state_val_55032 === (1))){
var state_55031__$1 = state_55031;
var statearr_55033_55051 = state_55031__$1;
(statearr_55033_55051[(2)] = null);

(statearr_55033_55051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55032 === (2))){
var _ = (function (){var statearr_55034 = state_55031;
(statearr_55034[(4)] = cljs.core.cons((5),(state_55031[(4)])));

return statearr_55034;
})();
var inst_55007 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55031__$1 = state_55031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55031__$1,(6),inst_55007);
} else {
if((state_val_55032 === (3))){
var inst_55029 = (state_55031[(2)]);
var state_55031__$1 = state_55031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55031__$1,inst_55029);
} else {
if((state_val_55032 === (4))){
var inst_55001 = (state_55031[(2)]);
var state_55031__$1 = state_55031;
var statearr_55036_55052 = state_55031__$1;
(statearr_55036_55052[(2)] = inst_55001);

(statearr_55036_55052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55032 === (5))){
var _ = (function (){var statearr_55037 = state_55031;
(statearr_55037[(4)] = cljs.core.rest((state_55031[(4)])));

return statearr_55037;
})();
var state_55031__$1 = state_55031;
var ex55035 = (state_55031__$1[(2)]);
var statearr_55038_55053 = state_55031__$1;
(statearr_55038_55053[(5)] = ex55035);


if((ex55035 instanceof Error)){
var statearr_55039_55054 = state_55031__$1;
(statearr_55039_55054[(1)] = (4));

(statearr_55039_55054[(5)] = null);

} else {
throw ex55035;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55032 === (6))){
var inst_55009 = (state_55031[(2)]);
var inst_55010 = fluree.db.util.async.throw_err(inst_55009);
var inst_55011 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55010);
var inst_55012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55013 = [inst_55010];
var inst_55014 = (new cljs.core.PersistentVector(null,1,(5),inst_55012,inst_55013,null));
var inst_55015 = cljs.core.count(inst_55014);
var inst_55016 = ((9) + inst_55015);
var inst_55017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55018 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55020 = [inst_55010];
var inst_55021 = (new cljs.core.PersistentVector(null,1,(5),inst_55019,inst_55020,null));
var inst_55022 = [">=",inst_55021,inst_55011];
var inst_55023 = cljs.core.PersistentHashMap.fromArrays(inst_55018,inst_55022);
var inst_55024 = [inst_55023,inst_55016];
var inst_55025 = (new cljs.core.PersistentVector(null,2,(5),inst_55017,inst_55024,null));
var inst_55026 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55025);
var _ = (function (){var statearr_55040 = state_55031;
(statearr_55040[(4)] = cljs.core.rest((state_55031[(4)])));

return statearr_55040;
})();
var state_55031__$1 = (function (){var statearr_55041 = state_55031;
(statearr_55041[(7)] = inst_55026);

return statearr_55041;
})();
var statearr_55042_55055 = state_55031__$1;
(statearr_55042_55055[(2)] = inst_55011);

(statearr_55042_55055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55043 = [null,null,null,null,null,null,null,null];
(statearr_55043[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55043[(1)] = (1));

return statearr_55043;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55031){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55031);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55044){var ex__2744__auto__ = e55044;
var statearr_55045_55056 = state_55031;
(statearr_55045_55056[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55031[(4)]))){
var statearr_55046_55057 = state_55031;
(statearr_55046_55057[(1)] = cljs.core.first((state_55031[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55058 = state_55031;
state_55031 = G__55058;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55031){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55047 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55047[(6)] = c__2763__auto__);

return statearr_55047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq54999){
var G__55000 = cljs.core.first(seq54999);
var seq54999__$1 = cljs.core.next(seq54999);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55000,seq54999__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55108 = arguments.length;
var i__4865__auto___55109 = (0);
while(true){
if((i__4865__auto___55109 < len__4864__auto___55108)){
args__4870__auto__.push((arguments[i__4865__auto___55109]));

var G__55110 = (i__4865__auto___55109 + (1));
i__4865__auto___55109 = G__55110;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55091){
var state_val_55092 = (state_55091[(1)]);
if((state_val_55092 === (1))){
var state_55091__$1 = state_55091;
var statearr_55093_55111 = state_55091__$1;
(statearr_55093_55111[(2)] = null);

(statearr_55093_55111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55092 === (2))){
var _ = (function (){var statearr_55094 = state_55091;
(statearr_55094[(4)] = cljs.core.cons((5),(state_55091[(4)])));

return statearr_55094;
})();
var inst_55067 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55091__$1 = state_55091;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55091__$1,(6),inst_55067);
} else {
if((state_val_55092 === (3))){
var inst_55089 = (state_55091[(2)]);
var state_55091__$1 = state_55091;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55091__$1,inst_55089);
} else {
if((state_val_55092 === (4))){
var inst_55061 = (state_55091[(2)]);
var state_55091__$1 = state_55091;
var statearr_55096_55112 = state_55091__$1;
(statearr_55096_55112[(2)] = inst_55061);

(statearr_55096_55112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55092 === (5))){
var _ = (function (){var statearr_55097 = state_55091;
(statearr_55097[(4)] = cljs.core.rest((state_55091[(4)])));

return statearr_55097;
})();
var state_55091__$1 = state_55091;
var ex55095 = (state_55091__$1[(2)]);
var statearr_55098_55113 = state_55091__$1;
(statearr_55098_55113[(5)] = ex55095);


if((ex55095 instanceof Error)){
var statearr_55099_55114 = state_55091__$1;
(statearr_55099_55114[(1)] = (4));

(statearr_55099_55114[(5)] = null);

} else {
throw ex55095;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55092 === (6))){
var inst_55069 = (state_55091[(2)]);
var inst_55070 = fluree.db.util.async.throw_err(inst_55069);
var inst_55071 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55070);
var inst_55072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55073 = [inst_55070];
var inst_55074 = (new cljs.core.PersistentVector(null,1,(5),inst_55072,inst_55073,null));
var inst_55075 = cljs.core.count(inst_55074);
var inst_55076 = ((9) + inst_55075);
var inst_55077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55078 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55080 = [inst_55070];
var inst_55081 = (new cljs.core.PersistentVector(null,1,(5),inst_55079,inst_55080,null));
var inst_55082 = ["not=",inst_55081,inst_55071];
var inst_55083 = cljs.core.PersistentHashMap.fromArrays(inst_55078,inst_55082);
var inst_55084 = [inst_55083,inst_55076];
var inst_55085 = (new cljs.core.PersistentVector(null,2,(5),inst_55077,inst_55084,null));
var inst_55086 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55085);
var _ = (function (){var statearr_55100 = state_55091;
(statearr_55100[(4)] = cljs.core.rest((state_55091[(4)])));

return statearr_55100;
})();
var state_55091__$1 = (function (){var statearr_55101 = state_55091;
(statearr_55101[(7)] = inst_55086);

return statearr_55101;
})();
var statearr_55102_55115 = state_55091__$1;
(statearr_55102_55115[(2)] = inst_55071);

(statearr_55102_55115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55103 = [null,null,null,null,null,null,null,null];
(statearr_55103[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55103[(1)] = (1));

return statearr_55103;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55091){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55091);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55104){var ex__2744__auto__ = e55104;
var statearr_55105_55116 = state_55091;
(statearr_55105_55116[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55091[(4)]))){
var statearr_55106_55117 = state_55091;
(statearr_55106_55117[(1)] = cljs.core.first((state_55091[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55118 = state_55091;
state_55091 = G__55118;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55091){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55091);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55107 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55107[(6)] = c__2763__auto__);

return statearr_55107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55059){
var G__55060 = cljs.core.first(seq55059);
var seq55059__$1 = cljs.core.next(seq55059);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55060,seq55059__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55168 = arguments.length;
var i__4865__auto___55169 = (0);
while(true){
if((i__4865__auto___55169 < len__4864__auto___55168)){
args__4870__auto__.push((arguments[i__4865__auto___55169]));

var G__55170 = (i__4865__auto___55169 + (1));
i__4865__auto___55169 = G__55170;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55151){
var state_val_55152 = (state_55151[(1)]);
if((state_val_55152 === (1))){
var state_55151__$1 = state_55151;
var statearr_55153_55171 = state_55151__$1;
(statearr_55153_55171[(2)] = null);

(statearr_55153_55171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55152 === (2))){
var _ = (function (){var statearr_55154 = state_55151;
(statearr_55154[(4)] = cljs.core.cons((5),(state_55151[(4)])));

return statearr_55154;
})();
var inst_55127 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55151__$1 = state_55151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55151__$1,(6),inst_55127);
} else {
if((state_val_55152 === (3))){
var inst_55149 = (state_55151[(2)]);
var state_55151__$1 = state_55151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55151__$1,inst_55149);
} else {
if((state_val_55152 === (4))){
var inst_55121 = (state_55151[(2)]);
var state_55151__$1 = state_55151;
var statearr_55156_55172 = state_55151__$1;
(statearr_55156_55172[(2)] = inst_55121);

(statearr_55156_55172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55152 === (5))){
var _ = (function (){var statearr_55157 = state_55151;
(statearr_55157[(4)] = cljs.core.rest((state_55151[(4)])));

return statearr_55157;
})();
var state_55151__$1 = state_55151;
var ex55155 = (state_55151__$1[(2)]);
var statearr_55158_55173 = state_55151__$1;
(statearr_55158_55173[(5)] = ex55155);


if((ex55155 instanceof Error)){
var statearr_55159_55174 = state_55151__$1;
(statearr_55159_55174[(1)] = (4));

(statearr_55159_55174[(5)] = null);

} else {
throw ex55155;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55152 === (6))){
var inst_55129 = (state_55151[(2)]);
var inst_55130 = fluree.db.util.async.throw_err(inst_55129);
var inst_55131 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55130);
var inst_55132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55133 = [inst_55130];
var inst_55134 = (new cljs.core.PersistentVector(null,1,(5),inst_55132,inst_55133,null));
var inst_55135 = cljs.core.count(inst_55134);
var inst_55136 = ((9) + inst_55135);
var inst_55137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55138 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55140 = [inst_55130];
var inst_55141 = (new cljs.core.PersistentVector(null,1,(5),inst_55139,inst_55140,null));
var inst_55142 = ["max",inst_55141,inst_55131];
var inst_55143 = cljs.core.PersistentHashMap.fromArrays(inst_55138,inst_55142);
var inst_55144 = [inst_55143,inst_55136];
var inst_55145 = (new cljs.core.PersistentVector(null,2,(5),inst_55137,inst_55144,null));
var inst_55146 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55145);
var _ = (function (){var statearr_55160 = state_55151;
(statearr_55160[(4)] = cljs.core.rest((state_55151[(4)])));

return statearr_55160;
})();
var state_55151__$1 = (function (){var statearr_55161 = state_55151;
(statearr_55161[(7)] = inst_55146);

return statearr_55161;
})();
var statearr_55162_55175 = state_55151__$1;
(statearr_55162_55175[(2)] = inst_55131);

(statearr_55162_55175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55163 = [null,null,null,null,null,null,null,null];
(statearr_55163[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55163[(1)] = (1));

return statearr_55163;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55151){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55151);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55164){var ex__2744__auto__ = e55164;
var statearr_55165_55176 = state_55151;
(statearr_55165_55176[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55151[(4)]))){
var statearr_55166_55177 = state_55151;
(statearr_55166_55177[(1)] = cljs.core.first((state_55151[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55178 = state_55151;
state_55151 = G__55178;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55151){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55167 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55167[(6)] = c__2763__auto__);

return statearr_55167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55119){
var G__55120 = cljs.core.first(seq55119);
var seq55119__$1 = cljs.core.next(seq55119);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55120,seq55119__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55228 = arguments.length;
var i__4865__auto___55229 = (0);
while(true){
if((i__4865__auto___55229 < len__4864__auto___55228)){
args__4870__auto__.push((arguments[i__4865__auto___55229]));

var G__55230 = (i__4865__auto___55229 + (1));
i__4865__auto___55229 = G__55230;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55211){
var state_val_55212 = (state_55211[(1)]);
if((state_val_55212 === (1))){
var state_55211__$1 = state_55211;
var statearr_55213_55231 = state_55211__$1;
(statearr_55213_55231[(2)] = null);

(statearr_55213_55231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55212 === (2))){
var _ = (function (){var statearr_55214 = state_55211;
(statearr_55214[(4)] = cljs.core.cons((5),(state_55211[(4)])));

return statearr_55214;
})();
var inst_55187 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55211__$1 = state_55211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55211__$1,(6),inst_55187);
} else {
if((state_val_55212 === (3))){
var inst_55209 = (state_55211[(2)]);
var state_55211__$1 = state_55211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55211__$1,inst_55209);
} else {
if((state_val_55212 === (4))){
var inst_55181 = (state_55211[(2)]);
var state_55211__$1 = state_55211;
var statearr_55216_55232 = state_55211__$1;
(statearr_55216_55232[(2)] = inst_55181);

(statearr_55216_55232[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55212 === (5))){
var _ = (function (){var statearr_55217 = state_55211;
(statearr_55217[(4)] = cljs.core.rest((state_55211[(4)])));

return statearr_55217;
})();
var state_55211__$1 = state_55211;
var ex55215 = (state_55211__$1[(2)]);
var statearr_55218_55233 = state_55211__$1;
(statearr_55218_55233[(5)] = ex55215);


if((ex55215 instanceof Error)){
var statearr_55219_55234 = state_55211__$1;
(statearr_55219_55234[(1)] = (4));

(statearr_55219_55234[(5)] = null);

} else {
throw ex55215;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55212 === (6))){
var inst_55189 = (state_55211[(2)]);
var inst_55190 = fluree.db.util.async.throw_err(inst_55189);
var inst_55191 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55190);
var inst_55192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55193 = [inst_55190];
var inst_55194 = (new cljs.core.PersistentVector(null,1,(5),inst_55192,inst_55193,null));
var inst_55195 = cljs.core.count(inst_55194);
var inst_55196 = ((9) + inst_55195);
var inst_55197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55200 = [inst_55190];
var inst_55201 = (new cljs.core.PersistentVector(null,1,(5),inst_55199,inst_55200,null));
var inst_55202 = ["min",inst_55201,inst_55191];
var inst_55203 = cljs.core.PersistentHashMap.fromArrays(inst_55198,inst_55202);
var inst_55204 = [inst_55203,inst_55196];
var inst_55205 = (new cljs.core.PersistentVector(null,2,(5),inst_55197,inst_55204,null));
var inst_55206 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55205);
var _ = (function (){var statearr_55220 = state_55211;
(statearr_55220[(4)] = cljs.core.rest((state_55211[(4)])));

return statearr_55220;
})();
var state_55211__$1 = (function (){var statearr_55221 = state_55211;
(statearr_55221[(7)] = inst_55206);

return statearr_55221;
})();
var statearr_55222_55235 = state_55211__$1;
(statearr_55222_55235[(2)] = inst_55191);

(statearr_55222_55235[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55223 = [null,null,null,null,null,null,null,null];
(statearr_55223[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55223[(1)] = (1));

return statearr_55223;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55211){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55211);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55224){var ex__2744__auto__ = e55224;
var statearr_55225_55236 = state_55211;
(statearr_55225_55236[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55211[(4)]))){
var statearr_55226_55237 = state_55211;
(statearr_55226_55237[(1)] = cljs.core.first((state_55211[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55238 = state_55211;
state_55211 = G__55238;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55211){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55227 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55227[(6)] = c__2763__auto__);

return statearr_55227;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55179){
var G__55180 = cljs.core.first(seq55179);
var seq55179__$1 = cljs.core.next(seq55179);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55180,seq55179__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55240 = arguments.length;
switch (G__55240) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55285){
var state_val_55286 = (state_55285[(1)]);
if((state_val_55286 === (7))){
var state_55285__$1 = state_55285;
var statearr_55287_55424 = state_55285__$1;
(statearr_55287_55424[(2)] = query_map);

(statearr_55287_55424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (1))){
var state_55285__$1 = state_55285;
var statearr_55288_55425 = state_55285__$1;
(statearr_55288_55425[(2)] = null);

(statearr_55288_55425[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (4))){
var inst_55241 = (state_55285[(2)]);
var state_55285__$1 = state_55285;
var statearr_55289_55426 = state_55285__$1;
(statearr_55289_55426[(2)] = inst_55241);

(statearr_55289_55426[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (13))){
var inst_55263 = (state_55285[(7)]);
var inst_55267 = (state_55285[(2)]);
var inst_55268 = fluree.db.util.async.throw_err(inst_55267);
var inst_55269 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55268,(0),null);
var inst_55270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55268,(1),null);
var inst_55271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55272 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55274 = [inst_55263];
var inst_55275 = (new cljs.core.PersistentVector(null,1,(5),inst_55273,inst_55274,null));
var inst_55276 = ["query",inst_55275,inst_55269];
var inst_55277 = cljs.core.PersistentHashMap.fromArrays(inst_55272,inst_55276);
var inst_55278 = [inst_55277,inst_55270];
var inst_55279 = (new cljs.core.PersistentVector(null,2,(5),inst_55271,inst_55278,null));
var inst_55280 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55279);
var _ = (function (){var statearr_55290 = state_55285;
(statearr_55290[(4)] = cljs.core.rest((state_55285[(4)])));

return statearr_55290;
})();
var state_55285__$1 = (function (){var statearr_55291 = state_55285;
(statearr_55291[(8)] = inst_55280);

return statearr_55291;
})();
var statearr_55292_55427 = state_55285__$1;
(statearr_55292_55427[(2)] = inst_55269);

(statearr_55292_55427[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (6))){
var state_55285__$1 = state_55285;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55285__$1,(9),query_map);
} else {
if((state_val_55286 === (3))){
var inst_55283 = (state_55285[(2)]);
var state_55285__$1 = state_55285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55285__$1,inst_55283);
} else {
if((state_val_55286 === (12))){
var inst_55263 = (state_55285[(7)]);
var inst_55263__$1 = (state_55285[(2)]);
var inst_55264 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55265 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55264,inst_55263__$1);
var state_55285__$1 = (function (){var statearr_55293 = state_55285;
(statearr_55293[(7)] = inst_55263__$1);

return statearr_55293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55285__$1,(13),inst_55265);
} else {
if((state_val_55286 === (2))){
var _ = (function (){var statearr_55294 = state_55285;
(statearr_55294[(4)] = cljs.core.cons((5),(state_55285[(4)])));

return statearr_55294;
})();
var inst_55250 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55285__$1 = state_55285;
if(inst_55250){
var statearr_55295_55428 = state_55285__$1;
(statearr_55295_55428[(1)] = (6));

} else {
var statearr_55296_55429 = state_55285__$1;
(statearr_55296_55429[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (11))){
var inst_55257 = (state_55285[(9)]);
var state_55285__$1 = state_55285;
var statearr_55298_55430 = state_55285__$1;
(statearr_55298_55430[(2)] = inst_55257);

(statearr_55298_55430[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (9))){
var inst_55253 = (state_55285[(2)]);
var inst_55254 = fluree.db.util.async.throw_err(inst_55253);
var state_55285__$1 = state_55285;
var statearr_55299_55431 = state_55285__$1;
(statearr_55299_55431[(2)] = inst_55254);

(statearr_55299_55431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (5))){
var _ = (function (){var statearr_55300 = state_55285;
(statearr_55300[(4)] = cljs.core.rest((state_55285[(4)])));

return statearr_55300;
})();
var state_55285__$1 = state_55285;
var ex55297 = (state_55285__$1[(2)]);
var statearr_55301_55432 = state_55285__$1;
(statearr_55301_55432[(5)] = ex55297);


if((ex55297 instanceof Error)){
var statearr_55302_55433 = state_55285__$1;
(statearr_55302_55433[(1)] = (4));

(statearr_55302_55433[(5)] = null);

} else {
throw ex55297;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (10))){
var inst_55257 = (state_55285[(9)]);
var inst_55260 = fluree.db.util.json.parse(inst_55257);
var state_55285__$1 = state_55285;
var statearr_55303_55434 = state_55285__$1;
(statearr_55303_55434[(2)] = inst_55260);

(statearr_55303_55434[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55286 === (8))){
var inst_55257 = (state_55285[(9)]);
var inst_55257__$1 = (state_55285[(2)]);
var inst_55258 = typeof inst_55257__$1 === 'string';
var state_55285__$1 = (function (){var statearr_55304 = state_55285;
(statearr_55304[(9)] = inst_55257__$1);

return statearr_55304;
})();
if(cljs.core.truth_(inst_55258)){
var statearr_55305_55435 = state_55285__$1;
(statearr_55305_55435[(1)] = (10));

} else {
var statearr_55306_55436 = state_55285__$1;
(statearr_55306_55436[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55307 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55307[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55307[(1)] = (1));

return statearr_55307;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55285){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55285);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55308){var ex__2744__auto__ = e55308;
var statearr_55309_55437 = state_55285;
(statearr_55309_55437[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55285[(4)]))){
var statearr_55310_55438 = state_55285;
(statearr_55310_55438[(1)] = cljs.core.first((state_55285[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55439 = state_55285;
state_55285 = G__55439;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55285){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55311 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55311[(6)] = c__2763__auto__);

return statearr_55311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55382){
var state_val_55383 = (state_55382[(1)]);
if((state_val_55383 === (7))){
var state_55382__$1 = state_55382;
var statearr_55384_55440 = state_55382__$1;
(statearr_55384_55440[(2)] = select);

(statearr_55384_55440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (20))){
var inst_55352 = (state_55382[(2)]);
var inst_55353 = fluree.db.util.async.channel_QMARK_(limit);
var state_55382__$1 = (function (){var statearr_55385 = state_55382;
(statearr_55385[(7)] = inst_55352);

return statearr_55385;
})();
if(inst_55353){
var statearr_55386_55441 = state_55382__$1;
(statearr_55386_55441[(1)] = (22));

} else {
var statearr_55387_55442 = state_55382__$1;
(statearr_55387_55442[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (1))){
var state_55382__$1 = state_55382;
var statearr_55388_55443 = state_55382__$1;
(statearr_55388_55443[(2)] = null);

(statearr_55388_55443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (24))){
var inst_55336 = (state_55382[(8)]);
var inst_55328 = (state_55382[(9)]);
var inst_55352 = (state_55382[(7)]);
var inst_55344 = (state_55382[(10)]);
var inst_55360 = (state_55382[(2)]);
var inst_55361 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55362 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_55361,inst_55328,inst_55336,inst_55344,inst_55352,inst_55360);
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(26),inst_55362);
} else {
if((state_val_55383 === (4))){
var inst_55312 = (state_55382[(2)]);
var state_55382__$1 = state_55382;
var statearr_55389_55444 = state_55382__$1;
(statearr_55389_55444[(2)] = inst_55312);

(statearr_55389_55444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (15))){
var state_55382__$1 = state_55382;
var statearr_55390_55445 = state_55382__$1;
(statearr_55390_55445[(2)] = where);

(statearr_55390_55445[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (21))){
var inst_55348 = (state_55382[(2)]);
var inst_55349 = fluree.db.util.async.throw_err(inst_55348);
var state_55382__$1 = state_55382;
var statearr_55391_55446 = state_55382__$1;
(statearr_55391_55446[(2)] = inst_55349);

(statearr_55391_55446[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (13))){
var inst_55332 = (state_55382[(2)]);
var inst_55333 = fluree.db.util.async.throw_err(inst_55332);
var state_55382__$1 = state_55382;
var statearr_55392_55447 = state_55382__$1;
(statearr_55392_55447[(2)] = inst_55333);

(statearr_55392_55447[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (22))){
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(25),limit);
} else {
if((state_val_55383 === (6))){
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(9),select);
} else {
if((state_val_55383 === (25))){
var inst_55356 = (state_55382[(2)]);
var inst_55357 = fluree.db.util.async.throw_err(inst_55356);
var state_55382__$1 = state_55382;
var statearr_55393_55448 = state_55382__$1;
(statearr_55393_55448[(2)] = inst_55357);

(statearr_55393_55448[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (17))){
var inst_55340 = (state_55382[(2)]);
var inst_55341 = fluree.db.util.async.throw_err(inst_55340);
var state_55382__$1 = state_55382;
var statearr_55394_55449 = state_55382__$1;
(statearr_55394_55449[(2)] = inst_55341);

(statearr_55394_55449[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (3))){
var inst_55380 = (state_55382[(2)]);
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55382__$1,inst_55380);
} else {
if((state_val_55383 === (12))){
var inst_55336 = (state_55382[(2)]);
var inst_55337 = fluree.db.util.async.channel_QMARK_(where);
var state_55382__$1 = (function (){var statearr_55395 = state_55382;
(statearr_55395[(8)] = inst_55336);

return statearr_55395;
})();
if(inst_55337){
var statearr_55396_55450 = state_55382__$1;
(statearr_55396_55450[(1)] = (14));

} else {
var statearr_55397_55451 = state_55382__$1;
(statearr_55397_55451[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (2))){
var _ = (function (){var statearr_55398 = state_55382;
(statearr_55398[(4)] = cljs.core.cons((5),(state_55382[(4)])));

return statearr_55398;
})();
var inst_55321 = fluree.db.util.async.channel_QMARK_(select);
var state_55382__$1 = state_55382;
if(inst_55321){
var statearr_55399_55452 = state_55382__$1;
(statearr_55399_55452[(1)] = (6));

} else {
var statearr_55400_55453 = state_55382__$1;
(statearr_55400_55453[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (23))){
var state_55382__$1 = state_55382;
var statearr_55401_55454 = state_55382__$1;
(statearr_55401_55454[(2)] = limit);

(statearr_55401_55454[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (19))){
var state_55382__$1 = state_55382;
var statearr_55402_55455 = state_55382__$1;
(statearr_55402_55455[(2)] = block);

(statearr_55402_55455[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (11))){
var state_55382__$1 = state_55382;
var statearr_55404_55456 = state_55382__$1;
(statearr_55404_55456[(2)] = from);

(statearr_55404_55456[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (9))){
var inst_55324 = (state_55382[(2)]);
var inst_55325 = fluree.db.util.async.throw_err(inst_55324);
var state_55382__$1 = state_55382;
var statearr_55405_55457 = state_55382__$1;
(statearr_55405_55457[(2)] = inst_55325);

(statearr_55405_55457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (5))){
var _ = (function (){var statearr_55406 = state_55382;
(statearr_55406[(4)] = cljs.core.rest((state_55382[(4)])));

return statearr_55406;
})();
var state_55382__$1 = state_55382;
var ex55403 = (state_55382__$1[(2)]);
var statearr_55407_55458 = state_55382__$1;
(statearr_55407_55458[(5)] = ex55403);


if((ex55403 instanceof Error)){
var statearr_55408_55459 = state_55382__$1;
(statearr_55408_55459[(1)] = (4));

(statearr_55408_55459[(5)] = null);

} else {
throw ex55403;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (14))){
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(17),where);
} else {
if((state_val_55383 === (26))){
var inst_55336 = (state_55382[(8)]);
var inst_55328 = (state_55382[(9)]);
var inst_55352 = (state_55382[(7)]);
var inst_55344 = (state_55382[(10)]);
var inst_55364 = (state_55382[(2)]);
var inst_55365 = fluree.db.util.async.throw_err(inst_55364);
var inst_55366 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55365,(0),null);
var inst_55367 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55365,(1),null);
var inst_55368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55369 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55371 = [inst_55328,inst_55336,inst_55344,inst_55352];
var inst_55372 = (new cljs.core.PersistentVector(null,4,(5),inst_55370,inst_55371,null));
var inst_55373 = ["query",inst_55372,inst_55366];
var inst_55374 = cljs.core.PersistentHashMap.fromArrays(inst_55369,inst_55373);
var inst_55375 = [inst_55374,inst_55367];
var inst_55376 = (new cljs.core.PersistentVector(null,2,(5),inst_55368,inst_55375,null));
var inst_55377 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55376);
var _ = (function (){var statearr_55409 = state_55382;
(statearr_55409[(4)] = cljs.core.rest((state_55382[(4)])));

return statearr_55409;
})();
var state_55382__$1 = (function (){var statearr_55410 = state_55382;
(statearr_55410[(11)] = inst_55377);

return statearr_55410;
})();
var statearr_55411_55460 = state_55382__$1;
(statearr_55411_55460[(2)] = inst_55366);

(statearr_55411_55460[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (16))){
var inst_55344 = (state_55382[(2)]);
var inst_55345 = fluree.db.util.async.channel_QMARK_(block);
var state_55382__$1 = (function (){var statearr_55412 = state_55382;
(statearr_55412[(10)] = inst_55344);

return statearr_55412;
})();
if(inst_55345){
var statearr_55413_55461 = state_55382__$1;
(statearr_55413_55461[(1)] = (18));

} else {
var statearr_55414_55462 = state_55382__$1;
(statearr_55414_55462[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55383 === (10))){
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(13),from);
} else {
if((state_val_55383 === (18))){
var state_55382__$1 = state_55382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55382__$1,(21),block);
} else {
if((state_val_55383 === (8))){
var inst_55328 = (state_55382[(2)]);
var inst_55329 = fluree.db.util.async.channel_QMARK_(from);
var state_55382__$1 = (function (){var statearr_55415 = state_55382;
(statearr_55415[(9)] = inst_55328);

return statearr_55415;
})();
if(inst_55329){
var statearr_55416_55463 = state_55382__$1;
(statearr_55416_55463[(1)] = (10));

} else {
var statearr_55417_55464 = state_55382__$1;
(statearr_55417_55464[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55418 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55418[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55418[(1)] = (1));

return statearr_55418;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55382){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55382);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55419){var ex__2744__auto__ = e55419;
var statearr_55420_55465 = state_55382;
(statearr_55420_55465[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55382[(4)]))){
var statearr_55421_55466 = state_55382;
(statearr_55421_55466[(1)] = cljs.core.first((state_55382[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55467 = state_55382;
state_55382 = G__55467;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55382){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55422 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55422[(6)] = c__2763__auto__);

return statearr_55422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55523){
var state_val_55524 = (state_55523[(1)]);
if((state_val_55524 === (7))){
var state_55523__$1 = state_55523;
var statearr_55525_55556 = state_55523__$1;
(statearr_55525_55556[(2)] = startSubject);

(statearr_55525_55556[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (1))){
var state_55523__$1 = state_55523;
var statearr_55526_55557 = state_55523__$1;
(statearr_55526_55557[(2)] = null);

(statearr_55526_55557[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (4))){
var inst_55468 = (state_55523[(2)]);
var state_55523__$1 = state_55523;
var statearr_55527_55558 = state_55523__$1;
(statearr_55527_55558[(2)] = inst_55468);

(statearr_55527_55558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (15))){
var inst_55500 = (state_55523[(2)]);
var inst_55501 = fluree.db.util.async.throw_err(inst_55500);
var inst_55502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55501,(0),null);
var inst_55503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55501,(1),null);
var inst_55504 = cljs.core.empty_QMARK_(inst_55502);
var state_55523__$1 = (function (){var statearr_55528 = state_55523;
(statearr_55528[(7)] = inst_55503);

return statearr_55528;
})();
if(inst_55504){
var statearr_55529_55559 = state_55523__$1;
(statearr_55529_55559[(1)] = (16));

} else {
var statearr_55530_55560 = state_55523__$1;
(statearr_55530_55560[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (13))){
var inst_55496 = (state_55523[(8)]);
var inst_55484 = (state_55523[(9)]);
var inst_55488 = (state_55523[(10)]);
var inst_55496__$1 = (state_55523[(2)]);
var inst_55497 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55498 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_55497,inst_55484,inst_55488,inst_55496__$1);
var state_55523__$1 = (function (){var statearr_55531 = state_55523;
(statearr_55531[(8)] = inst_55496__$1);

return statearr_55531;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55523__$1,(15),inst_55498);
} else {
if((state_val_55524 === (6))){
var state_55523__$1 = state_55523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55523__$1,(9),startSubject);
} else {
if((state_val_55524 === (17))){
var state_55523__$1 = state_55523;
var statearr_55532_55561 = state_55523__$1;
(statearr_55532_55561[(2)] = true);

(statearr_55532_55561[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (3))){
var inst_55521 = (state_55523[(2)]);
var state_55523__$1 = state_55523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55523__$1,inst_55521);
} else {
if((state_val_55524 === (12))){
var state_55523__$1 = state_55523;
var statearr_55533_55562 = state_55523__$1;
(statearr_55533_55562[(2)] = endSubject);

(statearr_55533_55562[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (2))){
var _ = (function (){var statearr_55534 = state_55523;
(statearr_55534[(4)] = cljs.core.cons((5),(state_55523[(4)])));

return statearr_55534;
})();
var inst_55477 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_55523__$1 = state_55523;
if(inst_55477){
var statearr_55535_55563 = state_55523__$1;
(statearr_55535_55563[(1)] = (6));

} else {
var statearr_55536_55564 = state_55523__$1;
(statearr_55536_55564[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (11))){
var state_55523__$1 = state_55523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55523__$1,(14),endSubject);
} else {
if((state_val_55524 === (9))){
var inst_55480 = (state_55523[(2)]);
var inst_55481 = fluree.db.util.async.throw_err(inst_55480);
var state_55523__$1 = state_55523;
var statearr_55538_55565 = state_55523__$1;
(statearr_55538_55565[(2)] = inst_55481);

(statearr_55538_55565[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (5))){
var _ = (function (){var statearr_55539 = state_55523;
(statearr_55539[(4)] = cljs.core.rest((state_55523[(4)])));

return statearr_55539;
})();
var state_55523__$1 = state_55523;
var ex55537 = (state_55523__$1[(2)]);
var statearr_55540_55566 = state_55523__$1;
(statearr_55540_55566[(5)] = ex55537);


if((ex55537 instanceof Error)){
var statearr_55541_55567 = state_55523__$1;
(statearr_55541_55567[(1)] = (4));

(statearr_55541_55567[(5)] = null);

} else {
throw ex55537;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (14))){
var inst_55492 = (state_55523[(2)]);
var inst_55493 = fluree.db.util.async.throw_err(inst_55492);
var state_55523__$1 = state_55523;
var statearr_55542_55568 = state_55523__$1;
(statearr_55542_55568[(2)] = inst_55493);

(statearr_55542_55568[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (16))){
var state_55523__$1 = state_55523;
var statearr_55543_55569 = state_55523__$1;
(statearr_55543_55569[(2)] = false);

(statearr_55543_55569[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (10))){
var inst_55487 = (state_55523[(2)]);
var inst_55488 = fluree.db.util.async.throw_err(inst_55487);
var inst_55489 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_55523__$1 = (function (){var statearr_55544 = state_55523;
(statearr_55544[(10)] = inst_55488);

return statearr_55544;
})();
if(inst_55489){
var statearr_55545_55570 = state_55523__$1;
(statearr_55545_55570[(1)] = (11));

} else {
var statearr_55546_55571 = state_55523__$1;
(statearr_55546_55571[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (18))){
var inst_55496 = (state_55523[(8)]);
var inst_55484 = (state_55523[(9)]);
var inst_55503 = (state_55523[(7)]);
var inst_55488 = (state_55523[(10)]);
var inst_55508 = (state_55523[(2)]);
var inst_55509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55510 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55512 = [inst_55484,inst_55488,inst_55496];
var inst_55513 = (new cljs.core.PersistentVector(null,3,(5),inst_55511,inst_55512,null));
var inst_55514 = ["relationship?",inst_55513,inst_55508];
var inst_55515 = cljs.core.PersistentHashMap.fromArrays(inst_55510,inst_55514);
var inst_55516 = [inst_55515,inst_55503];
var inst_55517 = (new cljs.core.PersistentVector(null,2,(5),inst_55509,inst_55516,null));
var inst_55518 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55517);
var _ = (function (){var statearr_55547 = state_55523;
(statearr_55547[(4)] = cljs.core.rest((state_55523[(4)])));

return statearr_55547;
})();
var state_55523__$1 = (function (){var statearr_55548 = state_55523;
(statearr_55548[(11)] = inst_55518);

return statearr_55548;
})();
var statearr_55549_55572 = state_55523__$1;
(statearr_55549_55572[(2)] = inst_55508);

(statearr_55549_55572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55524 === (8))){
var inst_55484 = (state_55523[(2)]);
var inst_55485 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_55523__$1 = (function (){var statearr_55550 = state_55523;
(statearr_55550[(9)] = inst_55484);

return statearr_55550;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55523__$1,(10),inst_55485);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_55551 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55551[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__);

(statearr_55551[(1)] = (1));

return statearr_55551;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1 = (function (state_55523){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55523);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55552){var ex__2744__auto__ = e55552;
var statearr_55553_55573 = state_55523;
(statearr_55553_55573[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55523[(4)]))){
var statearr_55554_55574 = state_55523;
(statearr_55554_55574[(1)] = cljs.core.first((state_55523[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55575 = state_55523;
state_55523 = G__55575;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__ = function(state_55523){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1.call(this,state_55523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55555 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55555[(6)] = c__2763__auto__);

return statearr_55555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55612){
var state_val_55613 = (state_55612[(1)]);
if((state_val_55613 === (7))){
var state_55612__$1 = state_55612;
var statearr_55614_55634 = state_55612__$1;
(statearr_55614_55634[(2)] = pred_name);

(statearr_55614_55634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (1))){
var state_55612__$1 = state_55612;
var statearr_55615_55635 = state_55612__$1;
(statearr_55615_55635[(2)] = null);

(statearr_55615_55635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (4))){
var inst_55576 = (state_55612[(2)]);
var state_55612__$1 = state_55612;
var statearr_55616_55636 = state_55612__$1;
(statearr_55616_55636[(2)] = inst_55576);

(statearr_55616_55636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (6))){
var state_55612__$1 = state_55612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55612__$1,(9),pred_name);
} else {
if((state_val_55613 === (3))){
var inst_55610 = (state_55612[(2)]);
var state_55612__$1 = state_55612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55612__$1,inst_55610);
} else {
if((state_val_55613 === (2))){
var _ = (function (){var statearr_55618 = state_55612;
(statearr_55618[(4)] = cljs.core.cons((5),(state_55612[(4)])));

return statearr_55618;
})();
var inst_55585 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_55612__$1 = state_55612;
if(inst_55585){
var statearr_55619_55637 = state_55612__$1;
(statearr_55619_55637[(1)] = (6));

} else {
var statearr_55620_55638 = state_55612__$1;
(statearr_55620_55638[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (9))){
var inst_55588 = (state_55612[(2)]);
var inst_55589 = fluree.db.util.async.throw_err(inst_55588);
var state_55612__$1 = state_55612;
var statearr_55621_55639 = state_55612__$1;
(statearr_55621_55639[(2)] = inst_55589);

(statearr_55621_55639[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (5))){
var _ = (function (){var statearr_55622 = state_55612;
(statearr_55622[(4)] = cljs.core.rest((state_55612[(4)])));

return statearr_55622;
})();
var state_55612__$1 = state_55612;
var ex55617 = (state_55612__$1[(2)]);
var statearr_55623_55640 = state_55612__$1;
(statearr_55623_55640[(5)] = ex55617);


if((ex55617 instanceof Error)){
var statearr_55624_55641 = state_55612__$1;
(statearr_55624_55641[(1)] = (4));

(statearr_55624_55641[(5)] = null);

} else {
throw ex55617;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (10))){
var inst_55592 = (state_55612[(7)]);
var inst_55596 = (state_55612[(2)]);
var inst_55597 = fluree.db.util.async.throw_err(inst_55596);
var inst_55598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55597,(0),null);
var inst_55599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55597,(1),null);
var inst_55600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55601 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55602 = ["max-pred-val",inst_55592,inst_55598];
var inst_55603 = cljs.core.PersistentHashMap.fromArrays(inst_55601,inst_55602);
var inst_55604 = (inst_55599 + (10));
var inst_55605 = [inst_55603,inst_55604];
var inst_55606 = (new cljs.core.PersistentVector(null,2,(5),inst_55600,inst_55605,null));
var inst_55607 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55606);
var _ = (function (){var statearr_55625 = state_55612;
(statearr_55625[(4)] = cljs.core.rest((state_55612[(4)])));

return statearr_55625;
})();
var state_55612__$1 = (function (){var statearr_55626 = state_55612;
(statearr_55626[(8)] = inst_55607);

return statearr_55626;
})();
var statearr_55627_55642 = state_55612__$1;
(statearr_55627_55642[(2)] = inst_55598);

(statearr_55627_55642[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55613 === (8))){
var inst_55592 = (state_55612[(7)]);
var inst_55592__$1 = (state_55612[(2)]);
var inst_55593 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55594 = fluree.db.dbfunctions.internal.max_pred_val(inst_55593,inst_55592__$1,null);
var state_55612__$1 = (function (){var statearr_55628 = state_55612;
(statearr_55628[(7)] = inst_55592__$1);

return statearr_55628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55612__$1,(10),inst_55594);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0 = (function (){
var statearr_55629 = [null,null,null,null,null,null,null,null,null];
(statearr_55629[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__);

(statearr_55629[(1)] = (1));

return statearr_55629;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1 = (function (state_55612){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55612);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55630){var ex__2744__auto__ = e55630;
var statearr_55631_55643 = state_55612;
(statearr_55631_55643[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55612[(4)]))){
var statearr_55632_55644 = state_55612;
(statearr_55632_55644[(1)] = cljs.core.first((state_55612[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55645 = state_55612;
state_55612 = G__55645;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__ = function(state_55612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1.call(this,state_55612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55633 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55633[(6)] = c__2763__auto__);

return statearr_55633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55672){
var state_val_55673 = (state_55672[(1)]);
if((state_val_55673 === (7))){
var state_55672__$1 = state_55672;
var statearr_55674_55693 = state_55672__$1;
(statearr_55674_55693[(2)] = n);

(statearr_55674_55693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (1))){
var state_55672__$1 = state_55672;
var statearr_55675_55694 = state_55672__$1;
(statearr_55675_55694[(2)] = null);

(statearr_55675_55694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (4))){
var inst_55646 = (state_55672[(2)]);
var state_55672__$1 = state_55672;
var statearr_55676_55695 = state_55672__$1;
(statearr_55676_55695[(2)] = inst_55646);

(statearr_55676_55695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (6))){
var state_55672__$1 = state_55672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55672__$1,(9),n);
} else {
if((state_val_55673 === (3))){
var inst_55670 = (state_55672[(2)]);
var state_55672__$1 = state_55672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55672__$1,inst_55670);
} else {
if((state_val_55673 === (2))){
var _ = (function (){var statearr_55678 = state_55672;
(statearr_55678[(4)] = cljs.core.cons((5),(state_55672[(4)])));

return statearr_55678;
})();
var inst_55652 = fluree.db.util.async.channel_QMARK_(n);
var state_55672__$1 = state_55672;
if(inst_55652){
var statearr_55679_55696 = state_55672__$1;
(statearr_55679_55696[(1)] = (6));

} else {
var statearr_55680_55697 = state_55672__$1;
(statearr_55680_55697[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (9))){
var inst_55655 = (state_55672[(2)]);
var inst_55656 = fluree.db.util.async.throw_err(inst_55655);
var state_55672__$1 = state_55672;
var statearr_55681_55698 = state_55672__$1;
(statearr_55681_55698[(2)] = inst_55656);

(statearr_55681_55698[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (5))){
var _ = (function (){var statearr_55682 = state_55672;
(statearr_55682[(4)] = cljs.core.rest((state_55672[(4)])));

return statearr_55682;
})();
var state_55672__$1 = state_55672;
var ex55677 = (state_55672__$1[(2)]);
var statearr_55683_55699 = state_55672__$1;
(statearr_55683_55699[(5)] = ex55677);


if((ex55677 instanceof Error)){
var statearr_55684_55700 = state_55672__$1;
(statearr_55684_55700[(1)] = (4));

(statearr_55684_55700[(5)] = null);

} else {
throw ex55677;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55673 === (8))){
var inst_55659 = (state_55672[(2)]);
var inst_55660 = fluree.db.dbfunctions.internal.inc(inst_55659);
var inst_55661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55662 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55663 = ["inc",inst_55659,inst_55660];
var inst_55664 = cljs.core.PersistentHashMap.fromArrays(inst_55662,inst_55663);
var inst_55665 = [inst_55664,(10)];
var inst_55666 = (new cljs.core.PersistentVector(null,2,(5),inst_55661,inst_55665,null));
var inst_55667 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55666);
var _ = (function (){var statearr_55685 = state_55672;
(statearr_55685[(4)] = cljs.core.rest((state_55672[(4)])));

return statearr_55685;
})();
var state_55672__$1 = (function (){var statearr_55686 = state_55672;
(statearr_55686[(7)] = inst_55667);

return statearr_55686;
})();
var statearr_55687_55701 = state_55672__$1;
(statearr_55687_55701[(2)] = inst_55660);

(statearr_55687_55701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0 = (function (){
var statearr_55688 = [null,null,null,null,null,null,null,null];
(statearr_55688[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__);

(statearr_55688[(1)] = (1));

return statearr_55688;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1 = (function (state_55672){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55672);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55689){var ex__2744__auto__ = e55689;
var statearr_55690_55702 = state_55672;
(statearr_55690_55702[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55672[(4)]))){
var statearr_55691_55703 = state_55672;
(statearr_55691_55703[(1)] = cljs.core.first((state_55672[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55704 = state_55672;
state_55672 = G__55704;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__ = function(state_55672){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1.call(this,state_55672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55692 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55692[(6)] = c__2763__auto__);

return statearr_55692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55731){
var state_val_55732 = (state_55731[(1)]);
if((state_val_55732 === (7))){
var state_55731__$1 = state_55731;
var statearr_55733_55752 = state_55731__$1;
(statearr_55733_55752[(2)] = n);

(statearr_55733_55752[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (1))){
var state_55731__$1 = state_55731;
var statearr_55734_55753 = state_55731__$1;
(statearr_55734_55753[(2)] = null);

(statearr_55734_55753[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (4))){
var inst_55705 = (state_55731[(2)]);
var state_55731__$1 = state_55731;
var statearr_55735_55754 = state_55731__$1;
(statearr_55735_55754[(2)] = inst_55705);

(statearr_55735_55754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (6))){
var state_55731__$1 = state_55731;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55731__$1,(9),n);
} else {
if((state_val_55732 === (3))){
var inst_55729 = (state_55731[(2)]);
var state_55731__$1 = state_55731;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55731__$1,inst_55729);
} else {
if((state_val_55732 === (2))){
var _ = (function (){var statearr_55737 = state_55731;
(statearr_55737[(4)] = cljs.core.cons((5),(state_55731[(4)])));

return statearr_55737;
})();
var inst_55711 = fluree.db.util.async.channel_QMARK_(n);
var state_55731__$1 = state_55731;
if(inst_55711){
var statearr_55738_55755 = state_55731__$1;
(statearr_55738_55755[(1)] = (6));

} else {
var statearr_55739_55756 = state_55731__$1;
(statearr_55739_55756[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (9))){
var inst_55714 = (state_55731[(2)]);
var inst_55715 = fluree.db.util.async.throw_err(inst_55714);
var state_55731__$1 = state_55731;
var statearr_55740_55757 = state_55731__$1;
(statearr_55740_55757[(2)] = inst_55715);

(statearr_55740_55757[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (5))){
var _ = (function (){var statearr_55741 = state_55731;
(statearr_55741[(4)] = cljs.core.rest((state_55731[(4)])));

return statearr_55741;
})();
var state_55731__$1 = state_55731;
var ex55736 = (state_55731__$1[(2)]);
var statearr_55742_55758 = state_55731__$1;
(statearr_55742_55758[(5)] = ex55736);


if((ex55736 instanceof Error)){
var statearr_55743_55759 = state_55731__$1;
(statearr_55743_55759[(1)] = (4));

(statearr_55743_55759[(5)] = null);

} else {
throw ex55736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55732 === (8))){
var inst_55718 = (state_55731[(2)]);
var inst_55719 = fluree.db.dbfunctions.internal.dec(inst_55718);
var inst_55720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55721 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55722 = ["dec",inst_55718,inst_55719];
var inst_55723 = cljs.core.PersistentHashMap.fromArrays(inst_55721,inst_55722);
var inst_55724 = [inst_55723,(10)];
var inst_55725 = (new cljs.core.PersistentVector(null,2,(5),inst_55720,inst_55724,null));
var inst_55726 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55725);
var _ = (function (){var statearr_55744 = state_55731;
(statearr_55744[(4)] = cljs.core.rest((state_55731[(4)])));

return statearr_55744;
})();
var state_55731__$1 = (function (){var statearr_55745 = state_55731;
(statearr_55745[(7)] = inst_55726);

return statearr_55745;
})();
var statearr_55746_55760 = state_55731__$1;
(statearr_55746_55760[(2)] = inst_55719);

(statearr_55746_55760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0 = (function (){
var statearr_55747 = [null,null,null,null,null,null,null,null];
(statearr_55747[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__);

(statearr_55747[(1)] = (1));

return statearr_55747;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1 = (function (state_55731){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55731);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55748){var ex__2744__auto__ = e55748;
var statearr_55749_55761 = state_55731;
(statearr_55749_55761[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55731[(4)]))){
var statearr_55750_55762 = state_55731;
(statearr_55750_55762[(1)] = cljs.core.first((state_55731[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55763 = state_55731;
state_55731 = G__55763;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__ = function(state_55731){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1.call(this,state_55731);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55751 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55751[(6)] = c__2763__auto__);

return statearr_55751;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55813 = arguments.length;
var i__4865__auto___55814 = (0);
while(true){
if((i__4865__auto___55814 < len__4864__auto___55813)){
args__4870__auto__.push((arguments[i__4865__auto___55814]));

var G__55815 = (i__4865__auto___55814 + (1));
i__4865__auto___55814 = G__55815;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55796){
var state_val_55797 = (state_55796[(1)]);
if((state_val_55797 === (1))){
var state_55796__$1 = state_55796;
var statearr_55798_55816 = state_55796__$1;
(statearr_55798_55816[(2)] = null);

(statearr_55798_55816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (2))){
var _ = (function (){var statearr_55799 = state_55796;
(statearr_55799[(4)] = cljs.core.cons((5),(state_55796[(4)])));

return statearr_55799;
})();
var inst_55772 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55796__$1 = state_55796;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55796__$1,(6),inst_55772);
} else {
if((state_val_55797 === (3))){
var inst_55794 = (state_55796[(2)]);
var state_55796__$1 = state_55796;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55796__$1,inst_55794);
} else {
if((state_val_55797 === (4))){
var inst_55766 = (state_55796[(2)]);
var state_55796__$1 = state_55796;
var statearr_55801_55817 = state_55796__$1;
(statearr_55801_55817[(2)] = inst_55766);

(statearr_55801_55817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (5))){
var _ = (function (){var statearr_55802 = state_55796;
(statearr_55802[(4)] = cljs.core.rest((state_55796[(4)])));

return statearr_55802;
})();
var state_55796__$1 = state_55796;
var ex55800 = (state_55796__$1[(2)]);
var statearr_55803_55818 = state_55796__$1;
(statearr_55803_55818[(5)] = ex55800);


if((ex55800 instanceof Error)){
var statearr_55804_55819 = state_55796__$1;
(statearr_55804_55819[(1)] = (4));

(statearr_55804_55819[(5)] = null);

} else {
throw ex55800;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55797 === (6))){
var inst_55774 = (state_55796[(2)]);
var inst_55775 = fluree.db.util.async.throw_err(inst_55774);
var inst_55776 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_55775);
var inst_55777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55778 = [inst_55775];
var inst_55779 = (new cljs.core.PersistentVector(null,1,(5),inst_55777,inst_55778,null));
var inst_55780 = cljs.core.count(inst_55779);
var inst_55781 = ((9) + inst_55780);
var inst_55782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55783 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55785 = [inst_55775];
var inst_55786 = (new cljs.core.PersistentVector(null,1,(5),inst_55784,inst_55785,null));
var inst_55787 = ["+",inst_55786,inst_55776];
var inst_55788 = cljs.core.PersistentHashMap.fromArrays(inst_55783,inst_55787);
var inst_55789 = [inst_55788,inst_55781];
var inst_55790 = (new cljs.core.PersistentVector(null,2,(5),inst_55782,inst_55789,null));
var inst_55791 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55790);
var _ = (function (){var statearr_55805 = state_55796;
(statearr_55805[(4)] = cljs.core.rest((state_55796[(4)])));

return statearr_55805;
})();
var state_55796__$1 = (function (){var statearr_55806 = state_55796;
(statearr_55806[(7)] = inst_55791);

return statearr_55806;
})();
var statearr_55807_55820 = state_55796__$1;
(statearr_55807_55820[(2)] = inst_55776);

(statearr_55807_55820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55808 = [null,null,null,null,null,null,null,null];
(statearr_55808[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55808[(1)] = (1));

return statearr_55808;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55796){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55796);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55809){var ex__2744__auto__ = e55809;
var statearr_55810_55821 = state_55796;
(statearr_55810_55821[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55796[(4)]))){
var statearr_55811_55822 = state_55796;
(statearr_55811_55822[(1)] = cljs.core.first((state_55796[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55823 = state_55796;
state_55796 = G__55823;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55796){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55812 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55812[(6)] = c__2763__auto__);

return statearr_55812;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq55764){
var G__55765 = cljs.core.first(seq55764);
var seq55764__$1 = cljs.core.next(seq55764);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55765,seq55764__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55873 = arguments.length;
var i__4865__auto___55874 = (0);
while(true){
if((i__4865__auto___55874 < len__4864__auto___55873)){
args__4870__auto__.push((arguments[i__4865__auto___55874]));

var G__55875 = (i__4865__auto___55874 + (1));
i__4865__auto___55874 = G__55875;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55856){
var state_val_55857 = (state_55856[(1)]);
if((state_val_55857 === (1))){
var state_55856__$1 = state_55856;
var statearr_55858_55876 = state_55856__$1;
(statearr_55858_55876[(2)] = null);

(statearr_55858_55876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (2))){
var _ = (function (){var statearr_55859 = state_55856;
(statearr_55859[(4)] = cljs.core.cons((5),(state_55856[(4)])));

return statearr_55859;
})();
var inst_55832 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55856__$1 = state_55856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55856__$1,(6),inst_55832);
} else {
if((state_val_55857 === (3))){
var inst_55854 = (state_55856[(2)]);
var state_55856__$1 = state_55856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55856__$1,inst_55854);
} else {
if((state_val_55857 === (4))){
var inst_55826 = (state_55856[(2)]);
var state_55856__$1 = state_55856;
var statearr_55861_55877 = state_55856__$1;
(statearr_55861_55877[(2)] = inst_55826);

(statearr_55861_55877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (5))){
var _ = (function (){var statearr_55862 = state_55856;
(statearr_55862[(4)] = cljs.core.rest((state_55856[(4)])));

return statearr_55862;
})();
var state_55856__$1 = state_55856;
var ex55860 = (state_55856__$1[(2)]);
var statearr_55863_55878 = state_55856__$1;
(statearr_55863_55878[(5)] = ex55860);


if((ex55860 instanceof Error)){
var statearr_55864_55879 = state_55856__$1;
(statearr_55864_55879[(1)] = (4));

(statearr_55864_55879[(5)] = null);

} else {
throw ex55860;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55857 === (6))){
var inst_55834 = (state_55856[(2)]);
var inst_55835 = fluree.db.util.async.throw_err(inst_55834);
var inst_55836 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_55835);
var inst_55837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55838 = [inst_55835];
var inst_55839 = (new cljs.core.PersistentVector(null,1,(5),inst_55837,inst_55838,null));
var inst_55840 = cljs.core.count(inst_55839);
var inst_55841 = ((9) + inst_55840);
var inst_55842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55843 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55845 = [inst_55835];
var inst_55846 = (new cljs.core.PersistentVector(null,1,(5),inst_55844,inst_55845,null));
var inst_55847 = ["-",inst_55846,inst_55836];
var inst_55848 = cljs.core.PersistentHashMap.fromArrays(inst_55843,inst_55847);
var inst_55849 = [inst_55848,inst_55841];
var inst_55850 = (new cljs.core.PersistentVector(null,2,(5),inst_55842,inst_55849,null));
var inst_55851 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55850);
var _ = (function (){var statearr_55865 = state_55856;
(statearr_55865[(4)] = cljs.core.rest((state_55856[(4)])));

return statearr_55865;
})();
var state_55856__$1 = (function (){var statearr_55866 = state_55856;
(statearr_55866[(7)] = inst_55851);

return statearr_55866;
})();
var statearr_55867_55880 = state_55856__$1;
(statearr_55867_55880[(2)] = inst_55836);

(statearr_55867_55880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55868 = [null,null,null,null,null,null,null,null];
(statearr_55868[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55868[(1)] = (1));

return statearr_55868;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55856){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55856);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55869){var ex__2744__auto__ = e55869;
var statearr_55870_55881 = state_55856;
(statearr_55870_55881[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55856[(4)]))){
var statearr_55871_55882 = state_55856;
(statearr_55871_55882[(1)] = cljs.core.first((state_55856[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55883 = state_55856;
state_55856 = G__55883;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55856){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55872 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55872[(6)] = c__2763__auto__);

return statearr_55872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq55824){
var G__55825 = cljs.core.first(seq55824);
var seq55824__$1 = cljs.core.next(seq55824);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55825,seq55824__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55933 = arguments.length;
var i__4865__auto___55934 = (0);
while(true){
if((i__4865__auto___55934 < len__4864__auto___55933)){
args__4870__auto__.push((arguments[i__4865__auto___55934]));

var G__55935 = (i__4865__auto___55934 + (1));
i__4865__auto___55934 = G__55935;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55916){
var state_val_55917 = (state_55916[(1)]);
if((state_val_55917 === (1))){
var state_55916__$1 = state_55916;
var statearr_55918_55936 = state_55916__$1;
(statearr_55918_55936[(2)] = null);

(statearr_55918_55936[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (2))){
var _ = (function (){var statearr_55919 = state_55916;
(statearr_55919[(4)] = cljs.core.cons((5),(state_55916[(4)])));

return statearr_55919;
})();
var inst_55892 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55916__$1 = state_55916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55916__$1,(6),inst_55892);
} else {
if((state_val_55917 === (3))){
var inst_55914 = (state_55916[(2)]);
var state_55916__$1 = state_55916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55916__$1,inst_55914);
} else {
if((state_val_55917 === (4))){
var inst_55886 = (state_55916[(2)]);
var state_55916__$1 = state_55916;
var statearr_55921_55937 = state_55916__$1;
(statearr_55921_55937[(2)] = inst_55886);

(statearr_55921_55937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (5))){
var _ = (function (){var statearr_55922 = state_55916;
(statearr_55922[(4)] = cljs.core.rest((state_55916[(4)])));

return statearr_55922;
})();
var state_55916__$1 = state_55916;
var ex55920 = (state_55916__$1[(2)]);
var statearr_55923_55938 = state_55916__$1;
(statearr_55923_55938[(5)] = ex55920);


if((ex55920 instanceof Error)){
var statearr_55924_55939 = state_55916__$1;
(statearr_55924_55939[(1)] = (4));

(statearr_55924_55939[(5)] = null);

} else {
throw ex55920;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55917 === (6))){
var inst_55894 = (state_55916[(2)]);
var inst_55895 = fluree.db.util.async.throw_err(inst_55894);
var inst_55896 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_55895);
var inst_55897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55898 = [inst_55895];
var inst_55899 = (new cljs.core.PersistentVector(null,1,(5),inst_55897,inst_55898,null));
var inst_55900 = cljs.core.count(inst_55899);
var inst_55901 = ((9) + inst_55900);
var inst_55902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55903 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55905 = [inst_55895];
var inst_55906 = (new cljs.core.PersistentVector(null,1,(5),inst_55904,inst_55905,null));
var inst_55907 = ["*",inst_55906,inst_55896];
var inst_55908 = cljs.core.PersistentHashMap.fromArrays(inst_55903,inst_55907);
var inst_55909 = [inst_55908,inst_55901];
var inst_55910 = (new cljs.core.PersistentVector(null,2,(5),inst_55902,inst_55909,null));
var inst_55911 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55910);
var _ = (function (){var statearr_55925 = state_55916;
(statearr_55925[(4)] = cljs.core.rest((state_55916[(4)])));

return statearr_55925;
})();
var state_55916__$1 = (function (){var statearr_55926 = state_55916;
(statearr_55926[(7)] = inst_55911);

return statearr_55926;
})();
var statearr_55927_55940 = state_55916__$1;
(statearr_55927_55940[(2)] = inst_55896);

(statearr_55927_55940[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55928 = [null,null,null,null,null,null,null,null];
(statearr_55928[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55928[(1)] = (1));

return statearr_55928;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55916){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55916);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55929){var ex__2744__auto__ = e55929;
var statearr_55930_55941 = state_55916;
(statearr_55930_55941[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55916[(4)]))){
var statearr_55931_55942 = state_55916;
(statearr_55931_55942[(1)] = cljs.core.first((state_55916[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55943 = state_55916;
state_55916 = G__55943;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55916){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55932 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55932[(6)] = c__2763__auto__);

return statearr_55932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq55884){
var G__55885 = cljs.core.first(seq55884);
var seq55884__$1 = cljs.core.next(seq55884);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55885,seq55884__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4870__auto__ = [];
var len__4864__auto___55993 = arguments.length;
var i__4865__auto___55994 = (0);
while(true){
if((i__4865__auto___55994 < len__4864__auto___55993)){
args__4870__auto__.push((arguments[i__4865__auto___55994]));

var G__55995 = (i__4865__auto___55994 + (1));
i__4865__auto___55994 = G__55995;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_55976){
var state_val_55977 = (state_55976[(1)]);
if((state_val_55977 === (1))){
var state_55976__$1 = state_55976;
var statearr_55978_55996 = state_55976__$1;
(statearr_55978_55996[(2)] = null);

(statearr_55978_55996[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (2))){
var _ = (function (){var statearr_55979 = state_55976;
(statearr_55979[(4)] = cljs.core.cons((5),(state_55976[(4)])));

return statearr_55979;
})();
var inst_55952 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55976__$1,(6),inst_55952);
} else {
if((state_val_55977 === (3))){
var inst_55974 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55976__$1,inst_55974);
} else {
if((state_val_55977 === (4))){
var inst_55946 = (state_55976[(2)]);
var state_55976__$1 = state_55976;
var statearr_55981_55997 = state_55976__$1;
(statearr_55981_55997[(2)] = inst_55946);

(statearr_55981_55997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (5))){
var _ = (function (){var statearr_55982 = state_55976;
(statearr_55982[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55982;
})();
var state_55976__$1 = state_55976;
var ex55980 = (state_55976__$1[(2)]);
var statearr_55983_55998 = state_55976__$1;
(statearr_55983_55998[(5)] = ex55980);


if((ex55980 instanceof Error)){
var statearr_55984_55999 = state_55976__$1;
(statearr_55984_55999[(1)] = (4));

(statearr_55984_55999[(5)] = null);

} else {
throw ex55980;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55977 === (6))){
var inst_55954 = (state_55976[(2)]);
var inst_55955 = fluree.db.util.async.throw_err(inst_55954);
var inst_55956 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_55955);
var inst_55957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55958 = [inst_55955];
var inst_55959 = (new cljs.core.PersistentVector(null,1,(5),inst_55957,inst_55958,null));
var inst_55960 = cljs.core.count(inst_55959);
var inst_55961 = ((9) + inst_55960);
var inst_55962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55963 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55965 = [inst_55955];
var inst_55966 = (new cljs.core.PersistentVector(null,1,(5),inst_55964,inst_55965,null));
var inst_55967 = ["/",inst_55966,inst_55956];
var inst_55968 = cljs.core.PersistentHashMap.fromArrays(inst_55963,inst_55967);
var inst_55969 = [inst_55968,inst_55961];
var inst_55970 = (new cljs.core.PersistentVector(null,2,(5),inst_55962,inst_55969,null));
var inst_55971 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55970);
var _ = (function (){var statearr_55985 = state_55976;
(statearr_55985[(4)] = cljs.core.rest((state_55976[(4)])));

return statearr_55985;
})();
var state_55976__$1 = (function (){var statearr_55986 = state_55976;
(statearr_55986[(7)] = inst_55971);

return statearr_55986;
})();
var statearr_55987_56000 = state_55976__$1;
(statearr_55987_56000[(2)] = inst_55956);

(statearr_55987_56000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_55988 = [null,null,null,null,null,null,null,null];
(statearr_55988[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_55988[(1)] = (1));

return statearr_55988;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_55976){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_55976);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e55989){var ex__2744__auto__ = e55989;
var statearr_55990_56001 = state_55976;
(statearr_55990_56001[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_55976[(4)]))){
var statearr_55991_56002 = state_55976;
(statearr_55991_56002[(1)] = cljs.core.first((state_55976[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56003 = state_55976;
state_55976 = G__56003;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_55976){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_55976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_55992 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_55992[(6)] = c__2763__auto__);

return statearr_55992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq55944){
var G__55945 = cljs.core.first(seq55944);
var seq55944__$1 = cljs.core.next(seq55944);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55945,seq55944__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56041){
var state_val_56042 = (state_56041[(1)]);
if((state_val_56042 === (7))){
var state_56041__$1 = state_56041;
var statearr_56043_56067 = state_56041__$1;
(statearr_56043_56067[(2)] = n);

(statearr_56043_56067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (1))){
var state_56041__$1 = state_56041;
var statearr_56044_56068 = state_56041__$1;
(statearr_56044_56068[(2)] = null);

(statearr_56044_56068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (4))){
var inst_56004 = (state_56041[(2)]);
var state_56041__$1 = state_56041;
var statearr_56045_56069 = state_56041__$1;
(statearr_56045_56069[(2)] = inst_56004);

(statearr_56045_56069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (13))){
var inst_56021 = (state_56041[(2)]);
var inst_56022 = fluree.db.util.async.throw_err(inst_56021);
var state_56041__$1 = state_56041;
var statearr_56046_56070 = state_56041__$1;
(statearr_56046_56070[(2)] = inst_56022);

(statearr_56046_56070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (6))){
var state_56041__$1 = state_56041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56041__$1,(9),n);
} else {
if((state_val_56042 === (3))){
var inst_56039 = (state_56041[(2)]);
var state_56041__$1 = state_56041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56041__$1,inst_56039);
} else {
if((state_val_56042 === (12))){
var inst_56017 = (state_56041[(7)]);
var inst_56025 = (state_56041[(2)]);
var inst_56026 = fluree.db.dbfunctions.internal.quot(inst_56017,inst_56025);
var inst_56027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56028 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56029 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56030 = [inst_56017,inst_56025];
var inst_56031 = (new cljs.core.PersistentVector(null,2,(5),inst_56029,inst_56030,null));
var inst_56032 = ["quot",inst_56031,inst_56026];
var inst_56033 = cljs.core.PersistentHashMap.fromArrays(inst_56028,inst_56032);
var inst_56034 = [inst_56033,(2)];
var inst_56035 = (new cljs.core.PersistentVector(null,2,(5),inst_56027,inst_56034,null));
var inst_56036 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56035);
var _ = (function (){var statearr_56047 = state_56041;
(statearr_56047[(4)] = cljs.core.rest((state_56041[(4)])));

return statearr_56047;
})();
var state_56041__$1 = (function (){var statearr_56048 = state_56041;
(statearr_56048[(8)] = inst_56036);

return statearr_56048;
})();
var statearr_56049_56071 = state_56041__$1;
(statearr_56049_56071[(2)] = inst_56026);

(statearr_56049_56071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (2))){
var _ = (function (){var statearr_56050 = state_56041;
(statearr_56050[(4)] = cljs.core.cons((5),(state_56041[(4)])));

return statearr_56050;
})();
var inst_56010 = fluree.db.util.async.channel_QMARK_(n);
var state_56041__$1 = state_56041;
if(inst_56010){
var statearr_56051_56072 = state_56041__$1;
(statearr_56051_56072[(1)] = (6));

} else {
var statearr_56052_56073 = state_56041__$1;
(statearr_56052_56073[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (11))){
var state_56041__$1 = state_56041;
var statearr_56054_56074 = state_56041__$1;
(statearr_56054_56074[(2)] = d);

(statearr_56054_56074[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (9))){
var inst_56013 = (state_56041[(2)]);
var inst_56014 = fluree.db.util.async.throw_err(inst_56013);
var state_56041__$1 = state_56041;
var statearr_56055_56075 = state_56041__$1;
(statearr_56055_56075[(2)] = inst_56014);

(statearr_56055_56075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (5))){
var _ = (function (){var statearr_56056 = state_56041;
(statearr_56056[(4)] = cljs.core.rest((state_56041[(4)])));

return statearr_56056;
})();
var state_56041__$1 = state_56041;
var ex56053 = (state_56041__$1[(2)]);
var statearr_56057_56076 = state_56041__$1;
(statearr_56057_56076[(5)] = ex56053);


if((ex56053 instanceof Error)){
var statearr_56058_56077 = state_56041__$1;
(statearr_56058_56077[(1)] = (4));

(statearr_56058_56077[(5)] = null);

} else {
throw ex56053;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56042 === (10))){
var state_56041__$1 = state_56041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56041__$1,(13),d);
} else {
if((state_val_56042 === (8))){
var inst_56017 = (state_56041[(2)]);
var inst_56018 = fluree.db.util.async.channel_QMARK_(d);
var state_56041__$1 = (function (){var statearr_56059 = state_56041;
(statearr_56059[(7)] = inst_56017);

return statearr_56059;
})();
if(inst_56018){
var statearr_56060_56078 = state_56041__$1;
(statearr_56060_56078[(1)] = (10));

} else {
var statearr_56061_56079 = state_56041__$1;
(statearr_56061_56079[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0 = (function (){
var statearr_56062 = [null,null,null,null,null,null,null,null,null];
(statearr_56062[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__);

(statearr_56062[(1)] = (1));

return statearr_56062;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1 = (function (state_56041){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56041);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56063){var ex__2744__auto__ = e56063;
var statearr_56064_56080 = state_56041;
(statearr_56064_56080[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56041[(4)]))){
var statearr_56065_56081 = state_56041;
(statearr_56065_56081[(1)] = cljs.core.first((state_56041[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56082 = state_56041;
state_56041 = G__56082;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__ = function(state_56041){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1.call(this,state_56041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56066 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56066[(6)] = c__2763__auto__);

return statearr_56066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56120){
var state_val_56121 = (state_56120[(1)]);
if((state_val_56121 === (7))){
var state_56120__$1 = state_56120;
var statearr_56122_56146 = state_56120__$1;
(statearr_56122_56146[(2)] = n);

(statearr_56122_56146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (1))){
var state_56120__$1 = state_56120;
var statearr_56123_56147 = state_56120__$1;
(statearr_56123_56147[(2)] = null);

(statearr_56123_56147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (4))){
var inst_56083 = (state_56120[(2)]);
var state_56120__$1 = state_56120;
var statearr_56124_56148 = state_56120__$1;
(statearr_56124_56148[(2)] = inst_56083);

(statearr_56124_56148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (13))){
var inst_56100 = (state_56120[(2)]);
var inst_56101 = fluree.db.util.async.throw_err(inst_56100);
var state_56120__$1 = state_56120;
var statearr_56125_56149 = state_56120__$1;
(statearr_56125_56149[(2)] = inst_56101);

(statearr_56125_56149[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (6))){
var state_56120__$1 = state_56120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56120__$1,(9),n);
} else {
if((state_val_56121 === (3))){
var inst_56118 = (state_56120[(2)]);
var state_56120__$1 = state_56120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56120__$1,inst_56118);
} else {
if((state_val_56121 === (12))){
var inst_56096 = (state_56120[(7)]);
var inst_56104 = (state_56120[(2)]);
var inst_56105 = fluree.db.dbfunctions.internal.mod(inst_56096,inst_56104);
var inst_56106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56107 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56109 = [inst_56096,inst_56104];
var inst_56110 = (new cljs.core.PersistentVector(null,2,(5),inst_56108,inst_56109,null));
var inst_56111 = ["mod",inst_56110,inst_56105];
var inst_56112 = cljs.core.PersistentHashMap.fromArrays(inst_56107,inst_56111);
var inst_56113 = [inst_56112,(2)];
var inst_56114 = (new cljs.core.PersistentVector(null,2,(5),inst_56106,inst_56113,null));
var inst_56115 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56114);
var _ = (function (){var statearr_56126 = state_56120;
(statearr_56126[(4)] = cljs.core.rest((state_56120[(4)])));

return statearr_56126;
})();
var state_56120__$1 = (function (){var statearr_56127 = state_56120;
(statearr_56127[(8)] = inst_56115);

return statearr_56127;
})();
var statearr_56128_56150 = state_56120__$1;
(statearr_56128_56150[(2)] = inst_56105);

(statearr_56128_56150[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (2))){
var _ = (function (){var statearr_56129 = state_56120;
(statearr_56129[(4)] = cljs.core.cons((5),(state_56120[(4)])));

return statearr_56129;
})();
var inst_56089 = fluree.db.util.async.channel_QMARK_(n);
var state_56120__$1 = state_56120;
if(inst_56089){
var statearr_56130_56151 = state_56120__$1;
(statearr_56130_56151[(1)] = (6));

} else {
var statearr_56131_56152 = state_56120__$1;
(statearr_56131_56152[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (11))){
var state_56120__$1 = state_56120;
var statearr_56133_56153 = state_56120__$1;
(statearr_56133_56153[(2)] = d);

(statearr_56133_56153[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (9))){
var inst_56092 = (state_56120[(2)]);
var inst_56093 = fluree.db.util.async.throw_err(inst_56092);
var state_56120__$1 = state_56120;
var statearr_56134_56154 = state_56120__$1;
(statearr_56134_56154[(2)] = inst_56093);

(statearr_56134_56154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (5))){
var _ = (function (){var statearr_56135 = state_56120;
(statearr_56135[(4)] = cljs.core.rest((state_56120[(4)])));

return statearr_56135;
})();
var state_56120__$1 = state_56120;
var ex56132 = (state_56120__$1[(2)]);
var statearr_56136_56155 = state_56120__$1;
(statearr_56136_56155[(5)] = ex56132);


if((ex56132 instanceof Error)){
var statearr_56137_56156 = state_56120__$1;
(statearr_56137_56156[(1)] = (4));

(statearr_56137_56156[(5)] = null);

} else {
throw ex56132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56121 === (10))){
var state_56120__$1 = state_56120;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56120__$1,(13),d);
} else {
if((state_val_56121 === (8))){
var inst_56096 = (state_56120[(2)]);
var inst_56097 = fluree.db.util.async.channel_QMARK_(d);
var state_56120__$1 = (function (){var statearr_56138 = state_56120;
(statearr_56138[(7)] = inst_56096);

return statearr_56138;
})();
if(inst_56097){
var statearr_56139_56157 = state_56120__$1;
(statearr_56139_56157[(1)] = (10));

} else {
var statearr_56140_56158 = state_56120__$1;
(statearr_56140_56158[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0 = (function (){
var statearr_56141 = [null,null,null,null,null,null,null,null,null];
(statearr_56141[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__);

(statearr_56141[(1)] = (1));

return statearr_56141;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1 = (function (state_56120){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56120);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56142){var ex__2744__auto__ = e56142;
var statearr_56143_56159 = state_56120;
(statearr_56143_56159[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56120[(4)]))){
var statearr_56144_56160 = state_56120;
(statearr_56144_56160[(1)] = cljs.core.first((state_56120[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56161 = state_56120;
state_56120 = G__56161;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__ = function(state_56120){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1.call(this,state_56120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56145 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56145[(6)] = c__2763__auto__);

return statearr_56145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56199){
var state_val_56200 = (state_56199[(1)]);
if((state_val_56200 === (7))){
var state_56199__$1 = state_56199;
var statearr_56201_56225 = state_56199__$1;
(statearr_56201_56225[(2)] = n);

(statearr_56201_56225[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (1))){
var state_56199__$1 = state_56199;
var statearr_56202_56226 = state_56199__$1;
(statearr_56202_56226[(2)] = null);

(statearr_56202_56226[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (4))){
var inst_56162 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
var statearr_56203_56227 = state_56199__$1;
(statearr_56203_56227[(2)] = inst_56162);

(statearr_56203_56227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (13))){
var inst_56179 = (state_56199[(2)]);
var inst_56180 = fluree.db.util.async.throw_err(inst_56179);
var state_56199__$1 = state_56199;
var statearr_56204_56228 = state_56199__$1;
(statearr_56204_56228[(2)] = inst_56180);

(statearr_56204_56228[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (6))){
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56199__$1,(9),n);
} else {
if((state_val_56200 === (3))){
var inst_56197 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56199__$1,inst_56197);
} else {
if((state_val_56200 === (12))){
var inst_56175 = (state_56199[(7)]);
var inst_56183 = (state_56199[(2)]);
var inst_56184 = fluree.db.dbfunctions.internal.rem(inst_56175,inst_56183);
var inst_56185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56186 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56188 = [inst_56175,inst_56183];
var inst_56189 = (new cljs.core.PersistentVector(null,2,(5),inst_56187,inst_56188,null));
var inst_56190 = ["rem",inst_56189,inst_56184];
var inst_56191 = cljs.core.PersistentHashMap.fromArrays(inst_56186,inst_56190);
var inst_56192 = [inst_56191,(2)];
var inst_56193 = (new cljs.core.PersistentVector(null,2,(5),inst_56185,inst_56192,null));
var inst_56194 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56193);
var _ = (function (){var statearr_56205 = state_56199;
(statearr_56205[(4)] = cljs.core.rest((state_56199[(4)])));

return statearr_56205;
})();
var state_56199__$1 = (function (){var statearr_56206 = state_56199;
(statearr_56206[(8)] = inst_56194);

return statearr_56206;
})();
var statearr_56207_56229 = state_56199__$1;
(statearr_56207_56229[(2)] = inst_56184);

(statearr_56207_56229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (2))){
var _ = (function (){var statearr_56208 = state_56199;
(statearr_56208[(4)] = cljs.core.cons((5),(state_56199[(4)])));

return statearr_56208;
})();
var inst_56168 = fluree.db.util.async.channel_QMARK_(n);
var state_56199__$1 = state_56199;
if(inst_56168){
var statearr_56209_56230 = state_56199__$1;
(statearr_56209_56230[(1)] = (6));

} else {
var statearr_56210_56231 = state_56199__$1;
(statearr_56210_56231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (11))){
var state_56199__$1 = state_56199;
var statearr_56212_56232 = state_56199__$1;
(statearr_56212_56232[(2)] = d);

(statearr_56212_56232[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (9))){
var inst_56171 = (state_56199[(2)]);
var inst_56172 = fluree.db.util.async.throw_err(inst_56171);
var state_56199__$1 = state_56199;
var statearr_56213_56233 = state_56199__$1;
(statearr_56213_56233[(2)] = inst_56172);

(statearr_56213_56233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (5))){
var _ = (function (){var statearr_56214 = state_56199;
(statearr_56214[(4)] = cljs.core.rest((state_56199[(4)])));

return statearr_56214;
})();
var state_56199__$1 = state_56199;
var ex56211 = (state_56199__$1[(2)]);
var statearr_56215_56234 = state_56199__$1;
(statearr_56215_56234[(5)] = ex56211);


if((ex56211 instanceof Error)){
var statearr_56216_56235 = state_56199__$1;
(statearr_56216_56235[(1)] = (4));

(statearr_56216_56235[(5)] = null);

} else {
throw ex56211;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (10))){
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56199__$1,(13),d);
} else {
if((state_val_56200 === (8))){
var inst_56175 = (state_56199[(2)]);
var inst_56176 = fluree.db.util.async.channel_QMARK_(d);
var state_56199__$1 = (function (){var statearr_56217 = state_56199;
(statearr_56217[(7)] = inst_56175);

return statearr_56217;
})();
if(inst_56176){
var statearr_56218_56236 = state_56199__$1;
(statearr_56218_56236[(1)] = (10));

} else {
var statearr_56219_56237 = state_56199__$1;
(statearr_56219_56237[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0 = (function (){
var statearr_56220 = [null,null,null,null,null,null,null,null,null];
(statearr_56220[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__);

(statearr_56220[(1)] = (1));

return statearr_56220;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1 = (function (state_56199){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56199);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56221){var ex__2744__auto__ = e56221;
var statearr_56222_56238 = state_56199;
(statearr_56222_56238[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56199[(4)]))){
var statearr_56223_56239 = state_56199;
(statearr_56223_56239[(1)] = cljs.core.first((state_56199[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56240 = state_56199;
state_56199 = G__56240;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__ = function(state_56199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1.call(this,state_56199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56224 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56224[(6)] = c__2763__auto__);

return statearr_56224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56267){
var state_val_56268 = (state_56267[(1)]);
if((state_val_56268 === (7))){
var state_56267__$1 = state_56267;
var statearr_56269_56288 = state_56267__$1;
(statearr_56269_56288[(2)] = x);

(statearr_56269_56288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (1))){
var state_56267__$1 = state_56267;
var statearr_56270_56289 = state_56267__$1;
(statearr_56270_56289[(2)] = null);

(statearr_56270_56289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (4))){
var inst_56241 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
var statearr_56271_56290 = state_56267__$1;
(statearr_56271_56290[(2)] = inst_56241);

(statearr_56271_56290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (6))){
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56267__$1,(9),x);
} else {
if((state_val_56268 === (3))){
var inst_56265 = (state_56267[(2)]);
var state_56267__$1 = state_56267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56267__$1,inst_56265);
} else {
if((state_val_56268 === (2))){
var _ = (function (){var statearr_56273 = state_56267;
(statearr_56273[(4)] = cljs.core.cons((5),(state_56267[(4)])));

return statearr_56273;
})();
var inst_56247 = fluree.db.util.async.channel_QMARK_(x);
var state_56267__$1 = state_56267;
if(inst_56247){
var statearr_56274_56291 = state_56267__$1;
(statearr_56274_56291[(1)] = (6));

} else {
var statearr_56275_56292 = state_56267__$1;
(statearr_56275_56292[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (9))){
var inst_56250 = (state_56267[(2)]);
var inst_56251 = fluree.db.util.async.throw_err(inst_56250);
var state_56267__$1 = state_56267;
var statearr_56276_56293 = state_56267__$1;
(statearr_56276_56293[(2)] = inst_56251);

(statearr_56276_56293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (5))){
var _ = (function (){var statearr_56277 = state_56267;
(statearr_56277[(4)] = cljs.core.rest((state_56267[(4)])));

return statearr_56277;
})();
var state_56267__$1 = state_56267;
var ex56272 = (state_56267__$1[(2)]);
var statearr_56278_56294 = state_56267__$1;
(statearr_56278_56294[(5)] = ex56272);


if((ex56272 instanceof Error)){
var statearr_56279_56295 = state_56267__$1;
(statearr_56279_56295[(1)] = (4));

(statearr_56279_56295[(5)] = null);

} else {
throw ex56272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56268 === (8))){
var inst_56254 = (state_56267[(2)]);
var inst_56255 = fluree.db.dbfunctions.internal.boolean$(inst_56254);
var inst_56256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56257 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56258 = ["boolean",inst_56254,inst_56255];
var inst_56259 = cljs.core.PersistentHashMap.fromArrays(inst_56257,inst_56258);
var inst_56260 = [inst_56259,(10)];
var inst_56261 = (new cljs.core.PersistentVector(null,2,(5),inst_56256,inst_56260,null));
var inst_56262 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56261);
var _ = (function (){var statearr_56280 = state_56267;
(statearr_56280[(4)] = cljs.core.rest((state_56267[(4)])));

return statearr_56280;
})();
var state_56267__$1 = (function (){var statearr_56281 = state_56267;
(statearr_56281[(7)] = inst_56262);

return statearr_56281;
})();
var statearr_56282_56296 = state_56267__$1;
(statearr_56282_56296[(2)] = inst_56255);

(statearr_56282_56296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0 = (function (){
var statearr_56283 = [null,null,null,null,null,null,null,null];
(statearr_56283[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__);

(statearr_56283[(1)] = (1));

return statearr_56283;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1 = (function (state_56267){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56267);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56284){var ex__2744__auto__ = e56284;
var statearr_56285_56297 = state_56267;
(statearr_56285_56297[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56267[(4)]))){
var statearr_56286_56298 = state_56267;
(statearr_56286_56298[(1)] = cljs.core.first((state_56267[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56299 = state_56267;
state_56267 = G__56299;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__ = function(state_56267){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1.call(this,state_56267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56287 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56287[(6)] = c__2763__auto__);

return statearr_56287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56337){
var state_val_56338 = (state_56337[(1)]);
if((state_val_56338 === (7))){
var state_56337__$1 = state_56337;
var statearr_56339_56363 = state_56337__$1;
(statearr_56339_56363[(2)] = pattern);

(statearr_56339_56363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (1))){
var state_56337__$1 = state_56337;
var statearr_56340_56364 = state_56337__$1;
(statearr_56340_56364[(2)] = null);

(statearr_56340_56364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (4))){
var inst_56300 = (state_56337[(2)]);
var state_56337__$1 = state_56337;
var statearr_56341_56365 = state_56337__$1;
(statearr_56341_56365[(2)] = inst_56300);

(statearr_56341_56365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (13))){
var inst_56317 = (state_56337[(2)]);
var inst_56318 = fluree.db.util.async.throw_err(inst_56317);
var state_56337__$1 = state_56337;
var statearr_56342_56366 = state_56337__$1;
(statearr_56342_56366[(2)] = inst_56318);

(statearr_56342_56366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (6))){
var state_56337__$1 = state_56337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56337__$1,(9),pattern);
} else {
if((state_val_56338 === (3))){
var inst_56335 = (state_56337[(2)]);
var state_56337__$1 = state_56337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56337__$1,inst_56335);
} else {
if((state_val_56338 === (12))){
var inst_56313 = (state_56337[(7)]);
var inst_56321 = (state_56337[(2)]);
var inst_56322 = fluree.db.dbfunctions.internal.re_find(inst_56313,inst_56321);
var inst_56323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56324 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56326 = [inst_56313,inst_56321];
var inst_56327 = (new cljs.core.PersistentVector(null,2,(5),inst_56325,inst_56326,null));
var inst_56328 = ["re-find",inst_56327,inst_56322];
var inst_56329 = cljs.core.PersistentHashMap.fromArrays(inst_56324,inst_56328);
var inst_56330 = [inst_56329,(10)];
var inst_56331 = (new cljs.core.PersistentVector(null,2,(5),inst_56323,inst_56330,null));
var inst_56332 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56331);
var _ = (function (){var statearr_56343 = state_56337;
(statearr_56343[(4)] = cljs.core.rest((state_56337[(4)])));

return statearr_56343;
})();
var state_56337__$1 = (function (){var statearr_56344 = state_56337;
(statearr_56344[(8)] = inst_56332);

return statearr_56344;
})();
var statearr_56345_56367 = state_56337__$1;
(statearr_56345_56367[(2)] = inst_56322);

(statearr_56345_56367[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (2))){
var _ = (function (){var statearr_56346 = state_56337;
(statearr_56346[(4)] = cljs.core.cons((5),(state_56337[(4)])));

return statearr_56346;
})();
var inst_56306 = fluree.db.util.async.channel_QMARK_(pattern);
var state_56337__$1 = state_56337;
if(inst_56306){
var statearr_56347_56368 = state_56337__$1;
(statearr_56347_56368[(1)] = (6));

} else {
var statearr_56348_56369 = state_56337__$1;
(statearr_56348_56369[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (11))){
var state_56337__$1 = state_56337;
var statearr_56350_56370 = state_56337__$1;
(statearr_56350_56370[(2)] = string);

(statearr_56350_56370[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (9))){
var inst_56309 = (state_56337[(2)]);
var inst_56310 = fluree.db.util.async.throw_err(inst_56309);
var state_56337__$1 = state_56337;
var statearr_56351_56371 = state_56337__$1;
(statearr_56351_56371[(2)] = inst_56310);

(statearr_56351_56371[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (5))){
var _ = (function (){var statearr_56352 = state_56337;
(statearr_56352[(4)] = cljs.core.rest((state_56337[(4)])));

return statearr_56352;
})();
var state_56337__$1 = state_56337;
var ex56349 = (state_56337__$1[(2)]);
var statearr_56353_56372 = state_56337__$1;
(statearr_56353_56372[(5)] = ex56349);


if((ex56349 instanceof Error)){
var statearr_56354_56373 = state_56337__$1;
(statearr_56354_56373[(1)] = (4));

(statearr_56354_56373[(5)] = null);

} else {
throw ex56349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56338 === (10))){
var state_56337__$1 = state_56337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56337__$1,(13),string);
} else {
if((state_val_56338 === (8))){
var inst_56313 = (state_56337[(2)]);
var inst_56314 = fluree.db.util.async.channel_QMARK_(string);
var state_56337__$1 = (function (){var statearr_56355 = state_56337;
(statearr_56355[(7)] = inst_56313);

return statearr_56355;
})();
if(inst_56314){
var statearr_56356_56374 = state_56337__$1;
(statearr_56356_56374[(1)] = (10));

} else {
var statearr_56357_56375 = state_56337__$1;
(statearr_56357_56375[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0 = (function (){
var statearr_56358 = [null,null,null,null,null,null,null,null,null];
(statearr_56358[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__);

(statearr_56358[(1)] = (1));

return statearr_56358;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1 = (function (state_56337){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56337);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56359){var ex__2744__auto__ = e56359;
var statearr_56360_56376 = state_56337;
(statearr_56360_56376[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56337[(4)]))){
var statearr_56361_56377 = state_56337;
(statearr_56361_56377[(1)] = cljs.core.first((state_56337[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56378 = state_56337;
state_56337 = G__56378;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__ = function(state_56337){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1.call(this,state_56337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56362 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56362[(6)] = c__2763__auto__);

return statearr_56362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56405){
var state_val_56406 = (state_56405[(1)]);
if((state_val_56406 === (7))){
var state_56405__$1 = state_56405;
var statearr_56407_56426 = state_56405__$1;
(statearr_56407_56426[(2)] = email);

(statearr_56407_56426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (1))){
var state_56405__$1 = state_56405;
var statearr_56408_56427 = state_56405__$1;
(statearr_56408_56427[(2)] = null);

(statearr_56408_56427[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (4))){
var inst_56379 = (state_56405[(2)]);
var state_56405__$1 = state_56405;
var statearr_56409_56428 = state_56405__$1;
(statearr_56409_56428[(2)] = inst_56379);

(statearr_56409_56428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (6))){
var state_56405__$1 = state_56405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56405__$1,(9),email);
} else {
if((state_val_56406 === (3))){
var inst_56403 = (state_56405[(2)]);
var state_56405__$1 = state_56405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56405__$1,inst_56403);
} else {
if((state_val_56406 === (2))){
var _ = (function (){var statearr_56411 = state_56405;
(statearr_56411[(4)] = cljs.core.cons((5),(state_56405[(4)])));

return statearr_56411;
})();
var inst_56385 = fluree.db.util.async.channel_QMARK_(email);
var state_56405__$1 = state_56405;
if(inst_56385){
var statearr_56412_56429 = state_56405__$1;
(statearr_56412_56429[(1)] = (6));

} else {
var statearr_56413_56430 = state_56405__$1;
(statearr_56413_56430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (9))){
var inst_56388 = (state_56405[(2)]);
var inst_56389 = fluree.db.util.async.throw_err(inst_56388);
var state_56405__$1 = state_56405;
var statearr_56414_56431 = state_56405__$1;
(statearr_56414_56431[(2)] = inst_56389);

(statearr_56414_56431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (5))){
var _ = (function (){var statearr_56415 = state_56405;
(statearr_56415[(4)] = cljs.core.rest((state_56405[(4)])));

return statearr_56415;
})();
var state_56405__$1 = state_56405;
var ex56410 = (state_56405__$1[(2)]);
var statearr_56416_56432 = state_56405__$1;
(statearr_56416_56432[(5)] = ex56410);


if((ex56410 instanceof Error)){
var statearr_56417_56433 = state_56405__$1;
(statearr_56417_56433[(1)] = (4));

(statearr_56417_56433[(5)] = null);

} else {
throw ex56410;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56406 === (8))){
var inst_56392 = (state_56405[(2)]);
var inst_56393 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_56392);
var inst_56394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56395 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56396 = ["re-find",inst_56392,inst_56393];
var inst_56397 = cljs.core.PersistentHashMap.fromArrays(inst_56395,inst_56396);
var inst_56398 = [inst_56397,(10)];
var inst_56399 = (new cljs.core.PersistentVector(null,2,(5),inst_56394,inst_56398,null));
var inst_56400 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56399);
var _ = (function (){var statearr_56418 = state_56405;
(statearr_56418[(4)] = cljs.core.rest((state_56405[(4)])));

return statearr_56418;
})();
var state_56405__$1 = (function (){var statearr_56419 = state_56405;
(statearr_56419[(7)] = inst_56400);

return statearr_56419;
})();
var statearr_56420_56434 = state_56405__$1;
(statearr_56420_56434[(2)] = inst_56393);

(statearr_56420_56434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0 = (function (){
var statearr_56421 = [null,null,null,null,null,null,null,null];
(statearr_56421[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__);

(statearr_56421[(1)] = (1));

return statearr_56421;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1 = (function (state_56405){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56405);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56422){var ex__2744__auto__ = e56422;
var statearr_56423_56435 = state_56405;
(statearr_56423_56435[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56405[(4)]))){
var statearr_56424_56436 = state_56405;
(statearr_56424_56436[(1)] = cljs.core.first((state_56405[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56437 = state_56405;
state_56405 = G__56437;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__ = function(state_56405){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1.call(this,state_56405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56425 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56425[(6)] = c__2763__auto__);

return statearr_56425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56484){
var state_val_56485 = (state_56484[(1)]);
if((state_val_56485 === (7))){
var inst_56454 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56484__$1 = state_56484;
if(cljs.core.truth_(inst_56454)){
var statearr_56486_56513 = state_56484__$1;
(statearr_56486_56513[(1)] = (9));

} else {
var statearr_56487_56514 = state_56484__$1;
(statearr_56487_56514[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (1))){
var state_56484__$1 = state_56484;
var statearr_56488_56515 = state_56484__$1;
(statearr_56488_56515[(2)] = null);

(statearr_56488_56515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (4))){
var inst_56438 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
var statearr_56489_56516 = state_56484__$1;
(statearr_56489_56516[(2)] = inst_56438);

(statearr_56489_56516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (15))){
var inst_56465 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
var statearr_56490_56517 = state_56484__$1;
(statearr_56490_56517[(2)] = inst_56465);

(statearr_56490_56517[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (13))){
var inst_56462 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_56484__$1 = state_56484;
var statearr_56491_56518 = state_56484__$1;
(statearr_56491_56518[(2)] = inst_56462);

(statearr_56491_56518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (6))){
var inst_56449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56450 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56451 = [inst_56450,(0)];
var inst_56452 = (new cljs.core.PersistentVector(null,2,(5),inst_56449,inst_56451,null));
var state_56484__$1 = state_56484;
var statearr_56492_56519 = state_56484__$1;
(statearr_56492_56519[(2)] = inst_56452);

(statearr_56492_56519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (3))){
var inst_56482 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56484__$1,inst_56482);
} else {
if((state_val_56485 === (12))){
var inst_56458 = (state_56484[(2)]);
var inst_56459 = fluree.db.util.async.throw_err(inst_56458);
var state_56484__$1 = state_56484;
var statearr_56493_56520 = state_56484__$1;
(statearr_56493_56520[(2)] = inst_56459);

(statearr_56493_56520[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (2))){
var _ = (function (){var statearr_56494 = state_56484;
(statearr_56494[(4)] = cljs.core.cons((5),(state_56484[(4)])));

return statearr_56494;
})();
var inst_56447 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56484__$1 = state_56484;
if(cljs.core.truth_(inst_56447)){
var statearr_56495_56521 = state_56484__$1;
(statearr_56495_56521[(1)] = (6));

} else {
var statearr_56496_56522 = state_56484__$1;
(statearr_56496_56522[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (11))){
var inst_56467 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
var statearr_56498_56523 = state_56484__$1;
(statearr_56498_56523[(2)] = inst_56467);

(statearr_56498_56523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (9))){
var inst_56456 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_56484__$1 = state_56484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56484__$1,(12),inst_56456);
} else {
if((state_val_56485 === (5))){
var _ = (function (){var statearr_56499 = state_56484;
(statearr_56499[(4)] = cljs.core.rest((state_56484[(4)])));

return statearr_56499;
})();
var state_56484__$1 = state_56484;
var ex56497 = (state_56484__$1[(2)]);
var statearr_56500_56524 = state_56484__$1;
(statearr_56500_56524[(5)] = ex56497);


if((ex56497 instanceof Error)){
var statearr_56501_56525 = state_56484__$1;
(statearr_56501_56525[(1)] = (4));

(statearr_56501_56525[(5)] = null);

} else {
throw ex56497;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (14))){
var state_56484__$1 = state_56484;
var statearr_56502_56526 = state_56484__$1;
(statearr_56502_56526[(2)] = null);

(statearr_56502_56526[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (10))){
var state_56484__$1 = state_56484;
var statearr_56503_56527 = state_56484__$1;
(statearr_56503_56527[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (8))){
var inst_56469 = (state_56484[(2)]);
var inst_56470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56469,(0),null);
var inst_56471 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56469,(1),null);
var inst_56472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56473 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56474 = ["?user_id","?ctx",inst_56470];
var inst_56475 = cljs.core.PersistentHashMap.fromArrays(inst_56473,inst_56474);
var inst_56476 = ((10) + inst_56471);
var inst_56477 = [inst_56475,inst_56476];
var inst_56478 = (new cljs.core.PersistentVector(null,2,(5),inst_56472,inst_56477,null));
var inst_56479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56478);
var _ = (function (){var statearr_56505 = state_56484;
(statearr_56505[(4)] = cljs.core.rest((state_56484[(4)])));

return statearr_56505;
})();
var state_56484__$1 = (function (){var statearr_56506 = state_56484;
(statearr_56506[(7)] = inst_56479);

return statearr_56506;
})();
var statearr_56507_56528 = state_56484__$1;
(statearr_56507_56528[(2)] = inst_56470);

(statearr_56507_56528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0 = (function (){
var statearr_56508 = [null,null,null,null,null,null,null,null];
(statearr_56508[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__);

(statearr_56508[(1)] = (1));

return statearr_56508;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1 = (function (state_56484){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56484);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56509){var ex__2744__auto__ = e56509;
var statearr_56510_56529 = state_56484;
(statearr_56510_56529[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56484[(4)]))){
var statearr_56511_56530 = state_56484;
(statearr_56511_56530[(1)] = cljs.core.first((state_56484[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56531 = state_56484;
state_56484 = G__56531;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__ = function(state_56484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1.call(this,state_56484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56512 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56512[(6)] = c__2763__auto__);

return statearr_56512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56559){
var state_val_56560 = (state_56559[(1)]);
if((state_val_56560 === (7))){
var inst_56552 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_56559__$1 = state_56559;
var statearr_56561_56580 = state_56559__$1;
(statearr_56561_56580[(2)] = inst_56552);

(statearr_56561_56580[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (1))){
var state_56559__$1 = state_56559;
var statearr_56562_56581 = state_56559__$1;
(statearr_56562_56581[(2)] = null);

(statearr_56562_56581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (4))){
var inst_56532 = (state_56559[(2)]);
var state_56559__$1 = state_56559;
var statearr_56563_56582 = state_56559__$1;
(statearr_56563_56582[(2)] = inst_56532);

(statearr_56563_56582[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (6))){
var inst_56540 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_56559__$1 = state_56559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56559__$1,(9),inst_56540);
} else {
if((state_val_56560 === (3))){
var inst_56557 = (state_56559[(2)]);
var state_56559__$1 = state_56559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56559__$1,inst_56557);
} else {
if((state_val_56560 === (2))){
var _ = (function (){var statearr_56565 = state_56559;
(statearr_56565[(4)] = cljs.core.cons((5),(state_56559[(4)])));

return statearr_56565;
})();
var inst_56538 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56559__$1 = state_56559;
if(cljs.core.truth_(inst_56538)){
var statearr_56566_56583 = state_56559__$1;
(statearr_56566_56583[(1)] = (6));

} else {
var statearr_56567_56584 = state_56559__$1;
(statearr_56567_56584[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (9))){
var inst_56542 = (state_56559[(2)]);
var inst_56543 = fluree.db.util.async.throw_err(inst_56542);
var inst_56544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56545 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56546 = ["?auth_id","?ctx",inst_56543];
var inst_56547 = cljs.core.PersistentHashMap.fromArrays(inst_56545,inst_56546);
var inst_56548 = [inst_56547,(10)];
var inst_56549 = (new cljs.core.PersistentVector(null,2,(5),inst_56544,inst_56548,null));
var inst_56550 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56549);
var state_56559__$1 = (function (){var statearr_56568 = state_56559;
(statearr_56568[(7)] = inst_56550);

return statearr_56568;
})();
var statearr_56569_56585 = state_56559__$1;
(statearr_56569_56585[(2)] = inst_56543);

(statearr_56569_56585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (5))){
var _ = (function (){var statearr_56570 = state_56559;
(statearr_56570[(4)] = cljs.core.rest((state_56559[(4)])));

return statearr_56570;
})();
var state_56559__$1 = state_56559;
var ex56564 = (state_56559__$1[(2)]);
var statearr_56571_56586 = state_56559__$1;
(statearr_56571_56586[(5)] = ex56564);


if((ex56564 instanceof Error)){
var statearr_56572_56587 = state_56559__$1;
(statearr_56572_56587[(1)] = (4));

(statearr_56572_56587[(5)] = null);

} else {
throw ex56564;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56560 === (8))){
var inst_56554 = (state_56559[(2)]);
var _ = (function (){var statearr_56573 = state_56559;
(statearr_56573[(4)] = cljs.core.rest((state_56559[(4)])));

return statearr_56573;
})();
var state_56559__$1 = state_56559;
var statearr_56574_56588 = state_56559__$1;
(statearr_56574_56588[(2)] = inst_56554);

(statearr_56574_56588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0 = (function (){
var statearr_56575 = [null,null,null,null,null,null,null,null];
(statearr_56575[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__);

(statearr_56575[(1)] = (1));

return statearr_56575;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1 = (function (state_56559){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56559);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56576){var ex__2744__auto__ = e56576;
var statearr_56577_56589 = state_56559;
(statearr_56577_56589[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56559[(4)]))){
var statearr_56578_56590 = state_56559;
(statearr_56578_56590[(1)] = cljs.core.first((state_56559[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56591 = state_56559;
state_56559 = G__56591;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__ = function(state_56559){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1.call(this,state_56559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56579 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56579[(6)] = c__2763__auto__);

return statearr_56579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__56593 = arguments.length;
switch (G__56593) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56635){
var state_val_56636 = (state_56635[(1)]);
if((state_val_56636 === (7))){
var state_56635__$1 = state_56635;
var statearr_56637_56667 = state_56635__$1;
(statearr_56637_56667[(2)] = seed);

(statearr_56637_56667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (1))){
var state_56635__$1 = state_56635;
var statearr_56638_56668 = state_56635__$1;
(statearr_56638_56668[(2)] = null);

(statearr_56638_56668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (4))){
var inst_56594 = (state_56635[(2)]);
var state_56635__$1 = state_56635;
var statearr_56639_56669 = state_56635__$1;
(statearr_56639_56669[(2)] = inst_56594);

(statearr_56639_56669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (15))){
var state_56635__$1 = state_56635;
var statearr_56640_56670 = state_56635__$1;
(statearr_56640_56670[(2)] = (10));

(statearr_56640_56670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (13))){
var inst_56611 = (state_56635[(2)]);
var inst_56612 = fluree.db.util.async.throw_err(inst_56611);
var state_56635__$1 = state_56635;
var statearr_56641_56671 = state_56635__$1;
(statearr_56641_56671[(2)] = inst_56612);

(statearr_56641_56671[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (6))){
var state_56635__$1 = state_56635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56635__$1,(9),seed);
} else {
if((state_val_56636 === (3))){
var inst_56633 = (state_56635[(2)]);
var state_56635__$1 = state_56635;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56635__$1,inst_56633);
} else {
if((state_val_56636 === (12))){
var inst_56615 = (state_56635[(7)]);
var inst_56615__$1 = (state_56635[(2)]);
var state_56635__$1 = (function (){var statearr_56642 = state_56635;
(statearr_56642[(7)] = inst_56615__$1);

return statearr_56642;
})();
if(cljs.core.truth_(inst_56615__$1)){
var statearr_56643_56672 = state_56635__$1;
(statearr_56643_56672[(1)] = (14));

} else {
var statearr_56644_56673 = state_56635__$1;
(statearr_56644_56673[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (2))){
var _ = (function (){var statearr_56645 = state_56635;
(statearr_56645[(4)] = cljs.core.cons((5),(state_56635[(4)])));

return statearr_56645;
})();
var inst_56600 = fluree.db.util.async.channel_QMARK_(seed);
var state_56635__$1 = state_56635;
if(inst_56600){
var statearr_56646_56674 = state_56635__$1;
(statearr_56646_56674[(1)] = (6));

} else {
var statearr_56647_56675 = state_56635__$1;
(statearr_56647_56675[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (11))){
var state_56635__$1 = state_56635;
var statearr_56649_56676 = state_56635__$1;
(statearr_56649_56676[(2)] = max);

(statearr_56649_56676[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (9))){
var inst_56603 = (state_56635[(2)]);
var inst_56604 = fluree.db.util.async.throw_err(inst_56603);
var state_56635__$1 = state_56635;
var statearr_56650_56677 = state_56635__$1;
(statearr_56650_56677[(2)] = inst_56604);

(statearr_56650_56677[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (5))){
var _ = (function (){var statearr_56651 = state_56635;
(statearr_56651[(4)] = cljs.core.rest((state_56635[(4)])));

return statearr_56651;
})();
var state_56635__$1 = state_56635;
var ex56648 = (state_56635__$1[(2)]);
var statearr_56652_56678 = state_56635__$1;
(statearr_56652_56678[(5)] = ex56648);


if((ex56648 instanceof Error)){
var statearr_56653_56679 = state_56635__$1;
(statearr_56653_56679[(1)] = (4));

(statearr_56653_56679[(5)] = null);

} else {
throw ex56648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (14))){
var inst_56615 = (state_56635[(7)]);
var state_56635__$1 = state_56635;
var statearr_56654_56680 = state_56635__$1;
(statearr_56654_56680[(2)] = inst_56615);

(statearr_56654_56680[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (16))){
var inst_56607 = (state_56635[(8)]);
var inst_56619 = (state_56635[(2)]);
var inst_56620 = fluree.db.dbfunctions.internal.rand(inst_56607,inst_56619);
var inst_56621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56622 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56624 = [max,seed];
var inst_56625 = (new cljs.core.PersistentVector(null,2,(5),inst_56623,inst_56624,null));
var inst_56626 = ["rand",inst_56625,inst_56620];
var inst_56627 = cljs.core.PersistentHashMap.fromArrays(inst_56622,inst_56626);
var inst_56628 = [inst_56627,(10)];
var inst_56629 = (new cljs.core.PersistentVector(null,2,(5),inst_56621,inst_56628,null));
var inst_56630 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56629);
var _ = (function (){var statearr_56655 = state_56635;
(statearr_56655[(4)] = cljs.core.rest((state_56635[(4)])));

return statearr_56655;
})();
var state_56635__$1 = (function (){var statearr_56656 = state_56635;
(statearr_56656[(9)] = inst_56630);

return statearr_56656;
})();
var statearr_56657_56681 = state_56635__$1;
(statearr_56657_56681[(2)] = inst_56620);

(statearr_56657_56681[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56636 === (10))){
var state_56635__$1 = state_56635;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56635__$1,(13),max);
} else {
if((state_val_56636 === (8))){
var inst_56607 = (state_56635[(2)]);
var inst_56608 = fluree.db.util.async.channel_QMARK_(max);
var state_56635__$1 = (function (){var statearr_56658 = state_56635;
(statearr_56658[(8)] = inst_56607);

return statearr_56658;
})();
if(inst_56608){
var statearr_56659_56682 = state_56635__$1;
(statearr_56659_56682[(1)] = (10));

} else {
var statearr_56660_56683 = state_56635__$1;
(statearr_56660_56683[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2741__auto____0 = (function (){
var statearr_56661 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56661[(0)] = fluree$db$dbfunctions$fns$state_machine__2741__auto__);

(statearr_56661[(1)] = (1));

return statearr_56661;
});
var fluree$db$dbfunctions$fns$state_machine__2741__auto____1 = (function (state_56635){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56635);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56662){var ex__2744__auto__ = e56662;
var statearr_56663_56684 = state_56635;
(statearr_56663_56684[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56635[(4)]))){
var statearr_56664_56685 = state_56635;
(statearr_56664_56685[(1)] = cljs.core.first((state_56635[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56686 = state_56635;
state_56635 = G__56686;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2741__auto__ = function(state_56635){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2741__auto____1.call(this,state_56635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56665 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56665[(6)] = c__2763__auto__);

return statearr_56665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56707){
var state_val_56708 = (state_56707[(1)]);
if((state_val_56708 === (1))){
var state_56707__$1 = state_56707;
var statearr_56709_56724 = state_56707__$1;
(statearr_56709_56724[(2)] = null);

(statearr_56709_56724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56708 === (2))){
var _ = (function (){var statearr_56710 = state_56707;
(statearr_56710[(4)] = cljs.core.cons((5),(state_56707[(4)])));

return statearr_56710;
})();
var inst_56693 = fluree.db.util.core.random_uuid();
var inst_56694 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56693);
var inst_56695 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56696 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56697 = cljs.core.PersistentVector.EMPTY;
var inst_56698 = ["uuid",inst_56697,inst_56694];
var inst_56699 = cljs.core.PersistentHashMap.fromArrays(inst_56696,inst_56698);
var inst_56700 = [inst_56699,(10)];
var inst_56701 = (new cljs.core.PersistentVector(null,2,(5),inst_56695,inst_56700,null));
var inst_56702 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56701);
var ___$1 = (function (){var statearr_56711 = state_56707;
(statearr_56711[(4)] = cljs.core.rest((state_56707[(4)])));

return statearr_56711;
})();
var state_56707__$1 = (function (){var statearr_56712 = state_56707;
(statearr_56712[(7)] = inst_56702);

return statearr_56712;
})();
var statearr_56713_56725 = state_56707__$1;
(statearr_56713_56725[(2)] = inst_56694);

(statearr_56713_56725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56708 === (3))){
var inst_56705 = (state_56707[(2)]);
var state_56707__$1 = state_56707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56707__$1,inst_56705);
} else {
if((state_val_56708 === (4))){
var inst_56687 = (state_56707[(2)]);
var state_56707__$1 = state_56707;
var statearr_56715_56726 = state_56707__$1;
(statearr_56715_56726[(2)] = inst_56687);

(statearr_56715_56726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56708 === (5))){
var _ = (function (){var statearr_56716 = state_56707;
(statearr_56716[(4)] = cljs.core.rest((state_56707[(4)])));

return statearr_56716;
})();
var state_56707__$1 = state_56707;
var ex56714 = (state_56707__$1[(2)]);
var statearr_56717_56727 = state_56707__$1;
(statearr_56717_56727[(5)] = ex56714);


if((ex56714 instanceof Error)){
var statearr_56718_56728 = state_56707__$1;
(statearr_56718_56728[(1)] = (4));

(statearr_56718_56728[(5)] = null);

} else {
throw ex56714;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0 = (function (){
var statearr_56719 = [null,null,null,null,null,null,null,null];
(statearr_56719[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__);

(statearr_56719[(1)] = (1));

return statearr_56719;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1 = (function (state_56707){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56707);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56720){var ex__2744__auto__ = e56720;
var statearr_56721_56729 = state_56707;
(statearr_56721_56729[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56707[(4)]))){
var statearr_56722_56730 = state_56707;
(statearr_56722_56730[(1)] = cljs.core.first((state_56707[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56731 = state_56707;
state_56707 = G__56731;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__ = function(state_56707){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1.call(this,state_56707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56723 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56723[(6)] = c__2763__auto__);

return statearr_56723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56761){
var state_val_56762 = (state_56761[(1)]);
if((state_val_56762 === (7))){
var state_56761__$1 = state_56761;
var statearr_56763_56782 = state_56761__$1;
(statearr_56763_56782[(2)] = num);

(statearr_56763_56782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (1))){
var state_56761__$1 = state_56761;
var statearr_56764_56783 = state_56761__$1;
(statearr_56764_56783[(2)] = null);

(statearr_56764_56783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (4))){
var inst_56732 = (state_56761[(2)]);
var state_56761__$1 = state_56761;
var statearr_56765_56784 = state_56761__$1;
(statearr_56765_56784[(2)] = inst_56732);

(statearr_56765_56784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (6))){
var state_56761__$1 = state_56761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56761__$1,(9),num);
} else {
if((state_val_56762 === (3))){
var inst_56759 = (state_56761[(2)]);
var state_56761__$1 = state_56761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56761__$1,inst_56759);
} else {
if((state_val_56762 === (2))){
var _ = (function (){var statearr_56767 = state_56761;
(statearr_56767[(4)] = cljs.core.cons((5),(state_56761[(4)])));

return statearr_56767;
})();
var inst_56738 = fluree.db.util.async.channel_QMARK_(num);
var state_56761__$1 = state_56761;
if(inst_56738){
var statearr_56768_56785 = state_56761__$1;
(statearr_56768_56785[(1)] = (6));

} else {
var statearr_56769_56786 = state_56761__$1;
(statearr_56769_56786[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (9))){
var inst_56741 = (state_56761[(2)]);
var inst_56742 = fluree.db.util.async.throw_err(inst_56741);
var state_56761__$1 = state_56761;
var statearr_56770_56787 = state_56761__$1;
(statearr_56770_56787[(2)] = inst_56742);

(statearr_56770_56787[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (5))){
var _ = (function (){var statearr_56771 = state_56761;
(statearr_56771[(4)] = cljs.core.rest((state_56761[(4)])));

return statearr_56771;
})();
var state_56761__$1 = state_56761;
var ex56766 = (state_56761__$1[(2)]);
var statearr_56772_56788 = state_56761__$1;
(statearr_56772_56788[(5)] = ex56766);


if((ex56766 instanceof Error)){
var statearr_56773_56789 = state_56761__$1;
(statearr_56773_56789[(1)] = (4));

(statearr_56773_56789[(5)] = null);

} else {
throw ex56766;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56762 === (8))){
var inst_56745 = (state_56761[(2)]);
var inst_56746 = fluree.db.dbfunctions.internal.ceil(inst_56745);
var inst_56747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56748 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56750 = [fluree.db.dbfunctions.fns.ceil];
var inst_56751 = (new cljs.core.PersistentVector(null,1,(5),inst_56749,inst_56750,null));
var inst_56752 = ["",inst_56751,inst_56746];
var inst_56753 = cljs.core.PersistentHashMap.fromArrays(inst_56748,inst_56752);
var inst_56754 = [inst_56753,(10)];
var inst_56755 = (new cljs.core.PersistentVector(null,2,(5),inst_56747,inst_56754,null));
var inst_56756 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56755);
var _ = (function (){var statearr_56774 = state_56761;
(statearr_56774[(4)] = cljs.core.rest((state_56761[(4)])));

return statearr_56774;
})();
var state_56761__$1 = (function (){var statearr_56775 = state_56761;
(statearr_56775[(7)] = inst_56756);

return statearr_56775;
})();
var statearr_56776_56790 = state_56761__$1;
(statearr_56776_56790[(2)] = inst_56746);

(statearr_56776_56790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0 = (function (){
var statearr_56777 = [null,null,null,null,null,null,null,null];
(statearr_56777[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__);

(statearr_56777[(1)] = (1));

return statearr_56777;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1 = (function (state_56761){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56761);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56778){var ex__2744__auto__ = e56778;
var statearr_56779_56791 = state_56761;
(statearr_56779_56791[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56761[(4)]))){
var statearr_56780_56792 = state_56761;
(statearr_56780_56792[(1)] = cljs.core.first((state_56761[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56793 = state_56761;
state_56761 = G__56793;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__ = function(state_56761){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1.call(this,state_56761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56781 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56781[(6)] = c__2763__auto__);

return statearr_56781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56823){
var state_val_56824 = (state_56823[(1)]);
if((state_val_56824 === (7))){
var state_56823__$1 = state_56823;
var statearr_56825_56844 = state_56823__$1;
(statearr_56825_56844[(2)] = num);

(statearr_56825_56844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (1))){
var state_56823__$1 = state_56823;
var statearr_56826_56845 = state_56823__$1;
(statearr_56826_56845[(2)] = null);

(statearr_56826_56845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (4))){
var inst_56794 = (state_56823[(2)]);
var state_56823__$1 = state_56823;
var statearr_56827_56846 = state_56823__$1;
(statearr_56827_56846[(2)] = inst_56794);

(statearr_56827_56846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (6))){
var state_56823__$1 = state_56823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56823__$1,(9),num);
} else {
if((state_val_56824 === (3))){
var inst_56821 = (state_56823[(2)]);
var state_56823__$1 = state_56823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56823__$1,inst_56821);
} else {
if((state_val_56824 === (2))){
var _ = (function (){var statearr_56829 = state_56823;
(statearr_56829[(4)] = cljs.core.cons((5),(state_56823[(4)])));

return statearr_56829;
})();
var inst_56800 = fluree.db.util.async.channel_QMARK_(num);
var state_56823__$1 = state_56823;
if(inst_56800){
var statearr_56830_56847 = state_56823__$1;
(statearr_56830_56847[(1)] = (6));

} else {
var statearr_56831_56848 = state_56823__$1;
(statearr_56831_56848[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (9))){
var inst_56803 = (state_56823[(2)]);
var inst_56804 = fluree.db.util.async.throw_err(inst_56803);
var state_56823__$1 = state_56823;
var statearr_56832_56849 = state_56823__$1;
(statearr_56832_56849[(2)] = inst_56804);

(statearr_56832_56849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (5))){
var _ = (function (){var statearr_56833 = state_56823;
(statearr_56833[(4)] = cljs.core.rest((state_56823[(4)])));

return statearr_56833;
})();
var state_56823__$1 = state_56823;
var ex56828 = (state_56823__$1[(2)]);
var statearr_56834_56850 = state_56823__$1;
(statearr_56834_56850[(5)] = ex56828);


if((ex56828 instanceof Error)){
var statearr_56835_56851 = state_56823__$1;
(statearr_56835_56851[(1)] = (4));

(statearr_56835_56851[(5)] = null);

} else {
throw ex56828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56824 === (8))){
var inst_56807 = (state_56823[(2)]);
var inst_56808 = fluree.db.dbfunctions.internal.floor(inst_56807);
var inst_56809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56810 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56812 = [fluree.db.dbfunctions.fns.floor];
var inst_56813 = (new cljs.core.PersistentVector(null,1,(5),inst_56811,inst_56812,null));
var inst_56814 = ["",inst_56813,inst_56808];
var inst_56815 = cljs.core.PersistentHashMap.fromArrays(inst_56810,inst_56814);
var inst_56816 = [inst_56815,(10)];
var inst_56817 = (new cljs.core.PersistentVector(null,2,(5),inst_56809,inst_56816,null));
var inst_56818 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56817);
var _ = (function (){var statearr_56836 = state_56823;
(statearr_56836[(4)] = cljs.core.rest((state_56823[(4)])));

return statearr_56836;
})();
var state_56823__$1 = (function (){var statearr_56837 = state_56823;
(statearr_56837[(7)] = inst_56818);

return statearr_56837;
})();
var statearr_56838_56852 = state_56823__$1;
(statearr_56838_56852[(2)] = inst_56808);

(statearr_56838_56852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0 = (function (){
var statearr_56839 = [null,null,null,null,null,null,null,null];
(statearr_56839[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__);

(statearr_56839[(1)] = (1));

return statearr_56839;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1 = (function (state_56823){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56823);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56840){var ex__2744__auto__ = e56840;
var statearr_56841_56853 = state_56823;
(statearr_56841_56853[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56823[(4)]))){
var statearr_56842_56854 = state_56823;
(statearr_56842_56854[(1)] = cljs.core.first((state_56823[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56855 = state_56823;
state_56823 = G__56855;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__ = function(state_56823){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1.call(this,state_56823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56843 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56843[(6)] = c__2763__auto__);

return statearr_56843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_56880){
var state_val_56881 = (state_56880[(1)]);
if((state_val_56881 === (1))){
var state_56880__$1 = state_56880;
var statearr_56882_56897 = state_56880__$1;
(statearr_56882_56897[(2)] = null);

(statearr_56882_56897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56881 === (2))){
var _ = (function (){var statearr_56883 = state_56880;
(statearr_56883[(4)] = cljs.core.cons((5),(state_56880[(4)])));

return statearr_56883;
})();
var inst_56862 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_56880__$1 = state_56880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56880__$1,(6),inst_56862);
} else {
if((state_val_56881 === (3))){
var inst_56878 = (state_56880[(2)]);
var state_56880__$1 = state_56880;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56880__$1,inst_56878);
} else {
if((state_val_56881 === (4))){
var inst_56856 = (state_56880[(2)]);
var state_56880__$1 = state_56880;
var statearr_56885_56898 = state_56880__$1;
(statearr_56885_56898[(2)] = inst_56856);

(statearr_56885_56898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56881 === (5))){
var _ = (function (){var statearr_56886 = state_56880;
(statearr_56886[(4)] = cljs.core.rest((state_56880[(4)])));

return statearr_56886;
})();
var state_56880__$1 = state_56880;
var ex56884 = (state_56880__$1[(2)]);
var statearr_56887_56899 = state_56880__$1;
(statearr_56887_56899[(5)] = ex56884);


if((ex56884 instanceof Error)){
var statearr_56888_56900 = state_56880__$1;
(statearr_56888_56900[(1)] = (4));

(statearr_56888_56900[(5)] = null);

} else {
throw ex56884;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56881 === (6))){
var inst_56864 = (state_56880[(2)]);
var inst_56865 = fluree.db.util.async.throw_err(inst_56864);
var inst_56866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56867 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56869 = [compare_val,new_val];
var inst_56870 = (new cljs.core.PersistentVector(null,2,(5),inst_56868,inst_56869,null));
var inst_56871 = ["",inst_56870,inst_56865];
var inst_56872 = cljs.core.PersistentHashMap.fromArrays(inst_56867,inst_56871);
var inst_56873 = [inst_56872,(10)];
var inst_56874 = (new cljs.core.PersistentVector(null,2,(5),inst_56866,inst_56873,null));
var inst_56875 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56874);
var _ = (function (){var statearr_56889 = state_56880;
(statearr_56889[(4)] = cljs.core.rest((state_56880[(4)])));

return statearr_56889;
})();
var state_56880__$1 = (function (){var statearr_56890 = state_56880;
(statearr_56890[(7)] = inst_56875);

return statearr_56890;
})();
var statearr_56891_56901 = state_56880__$1;
(statearr_56891_56901[(2)] = inst_56865);

(statearr_56891_56901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0 = (function (){
var statearr_56892 = [null,null,null,null,null,null,null,null];
(statearr_56892[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__);

(statearr_56892[(1)] = (1));

return statearr_56892;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1 = (function (state_56880){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_56880);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e56893){var ex__2744__auto__ = e56893;
var statearr_56894_56902 = state_56880;
(statearr_56894_56902[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_56880[(4)]))){
var statearr_56895_56903 = state_56880;
(statearr_56895_56903[(1)] = cljs.core.first((state_56880[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56904 = state_56880;
state_56880 = G__56904;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__ = function(state_56880){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1.call(this,state_56880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_56896 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_56896[(6)] = c__2763__auto__);

return statearr_56896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
