// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63304 = arguments.length;
var i__4865__auto___63305 = (0);
while(true){
if((i__4865__auto___63305 < len__4864__auto___63304)){
args__4870__auto__.push((arguments[i__4865__auto___63305]));

var G__63306 = (i__4865__auto___63305 + (1));
i__4865__auto___63305 = G__63306;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__63236){
var vec__63237 = p__63236;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63237,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___63307 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63281){
var state_val_63282 = (state_63281[(1)]);
if((state_val_63282 === (7))){
var inst_63267 = (state_63281[(7)]);
var inst_63258 = (state_63281[(8)]);
var inst_63269 = fluree.db.time_travel.as_of_block(inst_63267,inst_63258);
var state_63281__$1 = state_63281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63281__$1,(10),inst_63269);
} else {
if((state_val_63282 === (1))){
var state_63281__$1 = state_63281;
var statearr_63283_63308 = state_63281__$1;
(statearr_63283_63308[(2)] = null);

(statearr_63283_63308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (4))){
var inst_63240 = (state_63281[(2)]);
var inst_63241 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63240], 0));
var inst_63242 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63240);
var inst_63243 = cljs.core.async.close_BANG_(pc);
var state_63281__$1 = (function (){var statearr_63284 = state_63281;
(statearr_63284[(9)] = inst_63242);

(statearr_63284[(10)] = inst_63241);

return statearr_63284;
})();
var statearr_63285_63309 = state_63281__$1;
(statearr_63285_63309[(2)] = inst_63243);

(statearr_63285_63309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (6))){
var inst_63262 = (state_63281[(11)]);
var inst_63261 = (state_63281[(12)]);
var inst_63258 = (state_63281[(8)]);
var inst_63265 = (state_63281[(2)]);
var inst_63266 = fluree.db.util.async.throw_err(inst_63265);
var inst_63267 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_63266,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_63261,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_63262], 0));
var state_63281__$1 = (function (){var statearr_63286 = state_63281;
(statearr_63286[(7)] = inst_63267);

return statearr_63286;
})();
if(cljs.core.truth_(inst_63258)){
var statearr_63287_63310 = state_63281__$1;
(statearr_63287_63310[(1)] = (7));

} else {
var statearr_63288_63311 = state_63281__$1;
(statearr_63288_63311[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (3))){
var inst_63279 = (state_63281[(2)]);
var state_63281__$1 = state_63281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63281__$1,inst_63279);
} else {
if((state_val_63282 === (2))){
var _ = (function (){var statearr_63290 = state_63281;
(statearr_63290[(4)] = cljs.core.cons((5),(state_63281[(4)])));

return statearr_63290;
})();
var inst_63253 = opts;
var inst_63254 = cljs.core.__destructure_map(inst_63253);
var inst_63255 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63254,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_63256 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63254,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_63257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63254,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63258 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63254,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63259 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_63260 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_63261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63260,(0),null);
var inst_63262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63260,(1),null);
var inst_63263 = fluree.db.session.db(conn,ledger,opts);
var state_63281__$1 = (function (){var statearr_63291 = state_63281;
(statearr_63291[(13)] = inst_63257);

(statearr_63291[(14)] = inst_63255);

(statearr_63291[(11)] = inst_63262);

(statearr_63291[(15)] = inst_63259);

(statearr_63291[(12)] = inst_63261);

(statearr_63291[(8)] = inst_63258);

(statearr_63291[(16)] = inst_63256);

return statearr_63291;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63281__$1,(6),inst_63263);
} else {
if((state_val_63282 === (9))){
var inst_63275 = (state_63281[(2)]);
var inst_63276 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_63275);
var _ = (function (){var statearr_63292 = state_63281;
(statearr_63292[(4)] = cljs.core.rest((state_63281[(4)])));

return statearr_63292;
})();
var state_63281__$1 = state_63281;
var statearr_63293_63312 = state_63281__$1;
(statearr_63293_63312[(2)] = inst_63276);

(statearr_63293_63312[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (5))){
var _ = (function (){var statearr_63294 = state_63281;
(statearr_63294[(4)] = cljs.core.rest((state_63281[(4)])));

return statearr_63294;
})();
var state_63281__$1 = state_63281;
var ex63289 = (state_63281__$1[(2)]);
var statearr_63295_63313 = state_63281__$1;
(statearr_63295_63313[(5)] = ex63289);


var statearr_63296_63314 = state_63281__$1;
(statearr_63296_63314[(1)] = (4));

(statearr_63296_63314[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (10))){
var inst_63271 = (state_63281[(2)]);
var inst_63272 = fluree.db.util.async.throw_err(inst_63271);
var state_63281__$1 = state_63281;
var statearr_63297_63315 = state_63281__$1;
(statearr_63297_63315[(2)] = inst_63272);

(statearr_63297_63315[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63282 === (8))){
var inst_63267 = (state_63281[(7)]);
var state_63281__$1 = state_63281;
var statearr_63298_63316 = state_63281__$1;
(statearr_63298_63316[(2)] = inst_63267);

(statearr_63298_63316[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_63299 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63299[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_63299[(1)] = (1));

return statearr_63299;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_63281){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63281);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63300){var ex__2744__auto__ = e63300;
var statearr_63301_63317 = state_63281;
(statearr_63301_63317[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63281[(4)]))){
var statearr_63302_63318 = state_63281;
(statearr_63302_63318[(1)] = cljs.core.first((state_63281[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63319 = state_63281;
state_63281 = G__63319;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_63281){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_63281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63303 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63303[(6)] = c__2763__auto___63307);

return statearr_63303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq63233){
var G__63234 = cljs.core.first(seq63233);
var seq63233__$1 = cljs.core.next(seq63233);
var G__63235 = cljs.core.first(seq63233__$1);
var seq63233__$2 = cljs.core.next(seq63233__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__63234,G__63235,seq63233__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
var and__4251__auto____$1 = open_api;
if(cljs.core.truth_(and__4251__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4251__auto____$1;
}
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return open_api;
} else {
return and__4251__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__4251__auto__ = fluree.db.api_js.db_ident_QMARK_(val);
if(and__4251__auto__){
return auth;
} else {
return and__4251__auto__;
}
})())){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__63321 = arguments.length;
switch (G__63321) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63447){
var state_val_63448 = (state_63447[(1)]);
if((state_val_63448 === (7))){
var inst_63347 = (state_63447[(7)]);
var inst_63337 = (state_63447[(8)]);
var inst_63349 = fluree.db.time_travel.as_of_block(inst_63347,inst_63337);
var state_63447__$1 = state_63447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63447__$1,(10),inst_63349);
} else {
if((state_val_63448 === (20))){
var inst_63341 = (state_63447[(9)]);
var state_63447__$1 = state_63447;
var statearr_63449_63529 = state_63447__$1;
(statearr_63449_63529[(2)] = inst_63341);

(statearr_63449_63529[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (27))){
var inst_63335 = (state_63447[(10)]);
var state_63447__$1 = state_63447;
var statearr_63450_63530 = state_63447__$1;
(statearr_63450_63530[(2)] = inst_63335);

(statearr_63450_63530[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (1))){
var state_63447__$1 = state_63447;
var statearr_63451_63531 = state_63447__$1;
(statearr_63451_63531[(2)] = null);

(statearr_63451_63531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (24))){
var inst_63344 = (state_63447[(11)]);
var state_63447__$1 = state_63447;
if(cljs.core.truth_(inst_63344)){
var statearr_63452_63532 = state_63447__$1;
(statearr_63452_63532[(1)] = (26));

} else {
var statearr_63453_63533 = state_63447__$1;
(statearr_63453_63533[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (39))){
var inst_63409 = (state_63447[(12)]);
var inst_63412 = cljs.core.ex_data(inst_63409);
var inst_63413 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63414 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63412);
var inst_63415 = cljs.core.ex_message(inst_63409);
var inst_63416 = [inst_63414,inst_63415,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63417 = cljs.core.PersistentHashMap.fromArrays(inst_63413,inst_63416);
var state_63447__$1 = state_63447;
var statearr_63454_63534 = state_63447__$1;
(statearr_63454_63534[(2)] = inst_63417);

(statearr_63454_63534[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (46))){
var inst_63409 = (state_63447[(12)]);
var state_63447__$1 = state_63447;
var statearr_63455_63535 = state_63447__$1;
(statearr_63455_63535[(2)] = inst_63409);

(statearr_63455_63535[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (4))){
var inst_63322 = (state_63447[(2)]);
var inst_63323 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63322], 0));
var inst_63324 = cljs.core.ex_data(inst_63322);
var inst_63325 = cljs.core.ex_message(inst_63322);
var inst_63326 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63324,new cljs.core.Keyword(null,"message","message",-406056002),inst_63325);
var state_63447__$1 = (function (){var statearr_63456 = state_63447;
(statearr_63456[(13)] = inst_63323);

return statearr_63456;
})();
var statearr_63457_63536 = state_63447__$1;
(statearr_63457_63536[(2)] = inst_63326);

(statearr_63457_63536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (15))){
var state_63447__$1 = state_63447;
var statearr_63458_63537 = state_63447__$1;
(statearr_63458_63537[(2)] = (1000000));

(statearr_63458_63537[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (48))){
var inst_63409 = (state_63447[(12)]);
var state_63447__$1 = state_63447;
var statearr_63459_63538 = state_63447__$1;
(statearr_63459_63538[(2)] = inst_63409);

(statearr_63459_63538[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (50))){
var inst_63436 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63460_63539 = state_63447__$1;
(statearr_63460_63539[(2)] = inst_63436);

(statearr_63460_63539[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (21))){
var inst_63340 = (state_63447[(14)]);
var state_63447__$1 = state_63447;
if(cljs.core.truth_(inst_63340)){
var statearr_63461_63540 = state_63447__$1;
(statearr_63461_63540[(1)] = (23));

} else {
var statearr_63462_63541 = state_63447__$1;
(statearr_63462_63541[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (31))){
var inst_63398 = (state_63447[(2)]);
var inst_63399 = cljs.core.not(inst_63398);
var state_63447__$1 = state_63447;
if(inst_63399){
var statearr_63463_63542 = state_63447__$1;
(statearr_63463_63542[(1)] = (35));

} else {
var statearr_63464_63543 = state_63447__$1;
(statearr_63464_63543[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (32))){
var inst_63342 = (state_63447[(15)]);
var state_63447__$1 = state_63447;
var statearr_63465_63544 = state_63447__$1;
(statearr_63465_63544[(2)] = inst_63342);

(statearr_63465_63544[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (40))){
var inst_63372 = (state_63447[(16)]);
var state_63447__$1 = state_63447;
if(cljs.core.truth_(inst_63372)){
var statearr_63466_63545 = state_63447__$1;
(statearr_63466_63545[(1)] = (42));

} else {
var statearr_63467_63546 = state_63447__$1;
(statearr_63467_63546[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (33))){
var inst_63338 = (state_63447[(17)]);
var state_63447__$1 = state_63447;
var statearr_63468_63547 = state_63447__$1;
(statearr_63468_63547[(2)] = inst_63338);

(statearr_63468_63547[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (13))){
var inst_63367 = (state_63447[(18)]);
var inst_63343 = (state_63447[(19)]);
var inst_63365 = (state_63447[(2)]);
var inst_63366 = cljs.core.volatile_BANG_((0));
var inst_63367__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_63343);
var state_63447__$1 = (function (){var statearr_63469 = state_63447;
(statearr_63469[(18)] = inst_63367__$1);

(statearr_63469[(20)] = inst_63365);

(statearr_63469[(21)] = inst_63366);

return statearr_63469;
})();
if(cljs.core.truth_(inst_63367__$1)){
var statearr_63470_63548 = state_63447__$1;
(statearr_63470_63548[(1)] = (14));

} else {
var statearr_63471_63549 = state_63447__$1;
(statearr_63471_63549[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (22))){
var inst_63388 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63472_63550 = state_63447__$1;
(statearr_63472_63550[(2)] = inst_63388);

(statearr_63472_63550[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (36))){
var inst_63355 = (state_63447[(22)]);
var inst_63374 = (state_63447[(23)]);
var inst_63405 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_63374);
var inst_63406 = fluree.db.query.fql.query(inst_63355,inst_63405);
var state_63447__$1 = state_63447;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63447__$1,(38),inst_63406);
} else {
if((state_val_63448 === (41))){
var inst_63440 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63473_63551 = state_63447__$1;
(statearr_63473_63551[(2)] = inst_63440);

(statearr_63473_63551[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (43))){
var state_63447__$1 = state_63447;
var statearr_63474_63552 = state_63447__$1;
(statearr_63474_63552[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (29))){
var inst_63342 = (state_63447[(15)]);
var state_63447__$1 = state_63447;
if(cljs.core.truth_(inst_63342)){
var statearr_63476_63553 = state_63447__$1;
(statearr_63476_63553[(1)] = (32));

} else {
var statearr_63477_63554 = state_63447__$1;
(statearr_63477_63554[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (44))){
var inst_63438 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63478_63555 = state_63447__$1;
(statearr_63478_63555[(2)] = inst_63438);

(statearr_63478_63555[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (6))){
var inst_63337 = (state_63447[(8)]);
var inst_63346 = (state_63447[(2)]);
var inst_63347 = fluree.db.util.async.throw_err(inst_63346);
var state_63447__$1 = (function (){var statearr_63479 = state_63447;
(statearr_63479[(7)] = inst_63347);

return statearr_63479;
})();
if(cljs.core.truth_(inst_63337)){
var statearr_63480_63556 = state_63447__$1;
(statearr_63480_63556[(1)] = (7));

} else {
var statearr_63481_63557 = state_63447__$1;
(statearr_63481_63557[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (28))){
var inst_63384 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63482_63558 = state_63447__$1;
(statearr_63482_63558[(2)] = inst_63384);

(statearr_63482_63558[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (25))){
var inst_63386 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63483_63559 = state_63447__$1;
(statearr_63483_63559[(2)] = inst_63386);

(statearr_63483_63559[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (34))){
var inst_63395 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
var statearr_63484_63560 = state_63447__$1;
(statearr_63484_63560[(2)] = inst_63395);

(statearr_63484_63560[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (17))){
var inst_63336 = (state_63447[(24)]);
var state_63447__$1 = state_63447;
var statearr_63485_63561 = state_63447__$1;
(statearr_63485_63561[(2)] = inst_63336);

(statearr_63485_63561[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (3))){
var inst_63445 = (state_63447[(2)]);
var state_63447__$1 = state_63447;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63447__$1,inst_63445);
} else {
if((state_val_63448 === (12))){
var inst_63363 = cljs.core.PersistentHashMap.EMPTY;
var state_63447__$1 = state_63447;
var statearr_63486_63562 = state_63447__$1;
(statearr_63486_63562[(2)] = inst_63363);

(statearr_63486_63562[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (2))){
var _ = (function (){var statearr_63487 = state_63447;
(statearr_63487[(4)] = cljs.core.cons((5),(state_63447[(4)])));

return statearr_63487;
})();
var inst_63333 = query_map;
var inst_63334 = cljs.core.__destructure_map(inst_63333);
var inst_63335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_63336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_63337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"block","block",664686210));
var inst_63338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_63339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_63340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_63341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_63342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_63343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_63344 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63334,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_63447__$1 = (function (){var statearr_63488 = state_63447;
(statearr_63488[(25)] = inst_63339);

(statearr_63488[(9)] = inst_63341);

(statearr_63488[(10)] = inst_63335);

(statearr_63488[(17)] = inst_63338);

(statearr_63488[(8)] = inst_63337);

(statearr_63488[(24)] = inst_63336);

(statearr_63488[(15)] = inst_63342);

(statearr_63488[(19)] = inst_63343);

(statearr_63488[(14)] = inst_63340);

(statearr_63488[(11)] = inst_63344);

return statearr_63488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63447__$1,(6),sources);
} else {
if((state_val_63448 === (23))){
var inst_63340 = (state_63447[(14)]);
var state_63447__$1 = state_63447;
var statearr_63489_63563 = state_63447__$1;
(statearr_63489_63563[(2)] = inst_63340);

(statearr_63489_63563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (47))){
var inst_63355 = (state_63447[(22)]);
var inst_63420 = (state_63447[(26)]);
var inst_63373 = (state_63447[(27)]);
var inst_63366 = (state_63447[(21)]);
var inst_63426 = (state_63447[(2)]);
var inst_63427 = cljs.core.deref(inst_63366);
var inst_63428 = fluree.db.util.core.response_time_formatted(inst_63373);
var inst_63429 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_63355);
var inst_63430 = [(200),inst_63426,inst_63427,inst_63428,inst_63429];
var inst_63431 = cljs.core.PersistentHashMap.fromArrays(inst_63420,inst_63430);
var state_63447__$1 = state_63447;
var statearr_63490_63564 = state_63447__$1;
(statearr_63490_63564[(2)] = inst_63431);

(statearr_63490_63564[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (35))){
var inst_63401 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63402 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_63403 = cljs.core.PersistentHashMap.fromArrays(inst_63401,inst_63402);
var state_63447__$1 = state_63447;
var statearr_63491_63565 = state_63447__$1;
(statearr_63491_63565[(2)] = inst_63403);

(statearr_63491_63565[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (19))){
var inst_63390 = (state_63447[(28)]);
var inst_63390__$1 = (state_63447[(2)]);
var state_63447__$1 = (function (){var statearr_63492 = state_63447;
(statearr_63492[(28)] = inst_63390__$1);

return statearr_63492;
})();
if(cljs.core.truth_(inst_63390__$1)){
var statearr_63493_63566 = state_63447__$1;
(statearr_63493_63566[(1)] = (29));

} else {
var statearr_63494_63567 = state_63447__$1;
(statearr_63494_63567[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (11))){
var inst_63339 = (state_63447[(25)]);
var inst_63355 = (state_63447[(22)]);
var inst_63356 = (state_63447[(29)]);
var inst_63358 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_63355);
var inst_63359 = fluree.db.connection_js.open_api_QMARK_(inst_63356);
var inst_63360 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_63355);
var inst_63361 = fluree.db.api_js.get_sources(inst_63356,inst_63358,inst_63359,inst_63360,inst_63339,db_fn);
var state_63447__$1 = state_63447;
var statearr_63496_63568 = state_63447__$1;
(statearr_63496_63568[(2)] = inst_63361);

(statearr_63496_63568[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (9))){
var inst_63339 = (state_63447[(25)]);
var inst_63355 = (state_63447[(22)]);
var inst_63355__$1 = (state_63447[(2)]);
var inst_63356 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_63355__$1);
var state_63447__$1 = (function (){var statearr_63497 = state_63447;
(statearr_63497[(22)] = inst_63355__$1);

(statearr_63497[(29)] = inst_63356);

return statearr_63497;
})();
if(cljs.core.truth_(inst_63339)){
var statearr_63498_63569 = state_63447__$1;
(statearr_63498_63569[(1)] = (11));

} else {
var statearr_63499_63570 = state_63447__$1;
(statearr_63499_63570[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (5))){
var _ = (function (){var statearr_63500 = state_63447;
(statearr_63500[(4)] = cljs.core.rest((state_63447[(4)])));

return statearr_63500;
})();
var state_63447__$1 = state_63447;
var ex63495 = (state_63447__$1[(2)]);
var statearr_63501_63571 = state_63447__$1;
(statearr_63501_63571[(5)] = ex63495);


var statearr_63502_63572 = state_63447__$1;
(statearr_63502_63572[(1)] = (4));

(statearr_63502_63572[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (14))){
var inst_63367 = (state_63447[(18)]);
var state_63447__$1 = state_63447;
var statearr_63503_63573 = state_63447__$1;
(statearr_63503_63573[(2)] = inst_63367);

(statearr_63503_63573[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (45))){
var inst_63409 = (state_63447[(12)]);
var inst_63423 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_63409);
var state_63447__$1 = state_63447;
var statearr_63504_63574 = state_63447__$1;
(statearr_63504_63574[(2)] = inst_63423);

(statearr_63504_63574[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (26))){
var inst_63344 = (state_63447[(11)]);
var state_63447__$1 = state_63447;
var statearr_63505_63575 = state_63447__$1;
(statearr_63505_63575[(2)] = inst_63344);

(statearr_63505_63575[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (16))){
var inst_63365 = (state_63447[(20)]);
var inst_63336 = (state_63447[(24)]);
var inst_63366 = (state_63447[(21)]);
var inst_63343 = (state_63447[(19)]);
var inst_63371 = (state_63447[(2)]);
var inst_63372 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_63343);
var inst_63373 = fluree.db.util.core.current_time_millis();
var inst_63374 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_63343,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_63365,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_63371,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_63366], 0));
var state_63447__$1 = (function (){var statearr_63506 = state_63447;
(statearr_63506[(23)] = inst_63374);

(statearr_63506[(16)] = inst_63372);

(statearr_63506[(27)] = inst_63373);

return statearr_63506;
})();
if(cljs.core.truth_(inst_63336)){
var statearr_63507_63576 = state_63447__$1;
(statearr_63507_63576[(1)] = (17));

} else {
var statearr_63508_63577 = state_63447__$1;
(statearr_63508_63577[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (38))){
var inst_63409 = (state_63447[(12)]);
var inst_63408 = (state_63447[(2)]);
var inst_63409__$1 = fluree.db.util.async.throw_err(inst_63408);
var inst_63410 = (inst_63409__$1 instanceof cljs.core.ExceptionInfo);
var state_63447__$1 = (function (){var statearr_63509 = state_63447;
(statearr_63509[(12)] = inst_63409__$1);

return statearr_63509;
})();
if(cljs.core.truth_(inst_63410)){
var statearr_63510_63578 = state_63447__$1;
(statearr_63510_63578[(1)] = (39));

} else {
var statearr_63511_63579 = state_63447__$1;
(statearr_63511_63579[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (30))){
var inst_63390 = (state_63447[(28)]);
var state_63447__$1 = state_63447;
var statearr_63512_63580 = state_63447__$1;
(statearr_63512_63580[(2)] = inst_63390);

(statearr_63512_63580[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (10))){
var inst_63351 = (state_63447[(2)]);
var inst_63352 = fluree.db.util.async.throw_err(inst_63351);
var state_63447__$1 = state_63447;
var statearr_63513_63581 = state_63447__$1;
(statearr_63513_63581[(2)] = inst_63352);

(statearr_63513_63581[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (18))){
var inst_63341 = (state_63447[(9)]);
var state_63447__$1 = state_63447;
if(cljs.core.truth_(inst_63341)){
var statearr_63514_63582 = state_63447__$1;
(statearr_63514_63582[(1)] = (20));

} else {
var statearr_63515_63583 = state_63447__$1;
(statearr_63515_63583[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (42))){
var inst_63409 = (state_63447[(12)]);
var inst_63420 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_63421 = cljs.core.sequential_QMARK_(inst_63409);
var state_63447__$1 = (function (){var statearr_63516 = state_63447;
(statearr_63516[(26)] = inst_63420);

return statearr_63516;
})();
if(inst_63421){
var statearr_63517_63584 = state_63447__$1;
(statearr_63517_63584[(1)] = (45));

} else {
var statearr_63518_63585 = state_63447__$1;
(statearr_63518_63585[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (37))){
var inst_63442 = (state_63447[(2)]);
var _ = (function (){var statearr_63519 = state_63447;
(statearr_63519[(4)] = cljs.core.rest((state_63447[(4)])));

return statearr_63519;
})();
var state_63447__$1 = state_63447;
var statearr_63520_63586 = state_63447__$1;
(statearr_63520_63586[(2)] = inst_63442);

(statearr_63520_63586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (8))){
var inst_63347 = (state_63447[(7)]);
var state_63447__$1 = state_63447;
var statearr_63521_63587 = state_63447__$1;
(statearr_63521_63587[(2)] = inst_63347);

(statearr_63521_63587[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63448 === (49))){
var state_63447__$1 = state_63447;
var statearr_63522_63588 = state_63447__$1;
(statearr_63522_63588[(2)] = null);

(statearr_63522_63588[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_63523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63523[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_63523[(1)] = (1));

return statearr_63523;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_63447){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63447);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63524){var ex__2744__auto__ = e63524;
var statearr_63525_63589 = state_63447;
(statearr_63525_63589[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63447[(4)]))){
var statearr_63526_63590 = state_63447;
(statearr_63526_63590[(1)] = cljs.core.first((state_63447[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63591 = state_63447;
state_63447 = G__63591;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_63447){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_63447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63527 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63527[(6)] = c__2763__auto__);

return statearr_63527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__63592_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__63592_SHARP_);
}));

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63614){
var state_val_63615 = (state_63614[(1)]);
if((state_val_63615 === (1))){
var inst_63596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63597 = [resp_chan,timeout_chan];
var inst_63598 = (new cljs.core.PersistentVector(null,2,(5),inst_63596,inst_63597,null));
var state_63614__$1 = state_63614;
return cljs.core.async.ioc_alts_BANG_(state_63614__$1,(2),inst_63598);
} else {
if((state_val_63615 === (2))){
var inst_63600 = (state_63614[(2)]);
var inst_63601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63600,(0),null);
var inst_63602 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_63600,(1),null);
var inst_63603 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_63602);
var state_63614__$1 = (function (){var statearr_63616 = state_63614;
(statearr_63616[(7)] = inst_63601);

return statearr_63616;
})();
if(inst_63603){
var statearr_63617_63627 = state_63614__$1;
(statearr_63617_63627[(1)] = (3));

} else {
var statearr_63618_63628 = state_63614__$1;
(statearr_63618_63628[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63615 === (3))){
var inst_63605 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_63606 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_63607 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_63608 = [tid,(408),inst_63607];
var inst_63609 = cljs.core.PersistentHashMap.fromArrays(inst_63606,inst_63608);
var state_63614__$1 = (function (){var statearr_63619 = state_63614;
(statearr_63619[(8)] = inst_63605);

return statearr_63619;
})();
var statearr_63620_63629 = state_63614__$1;
(statearr_63620_63629[(2)] = inst_63609);

(statearr_63620_63629[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63615 === (4))){
var inst_63601 = (state_63614[(7)]);
var state_63614__$1 = state_63614;
var statearr_63621_63630 = state_63614__$1;
(statearr_63621_63630[(2)] = inst_63601);

(statearr_63621_63630[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63615 === (5))){
var inst_63612 = (state_63614[(2)]);
var state_63614__$1 = state_63614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63614__$1,inst_63612);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0 = (function (){
var statearr_63622 = [null,null,null,null,null,null,null,null,null];
(statearr_63622[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__);

(statearr_63622[(1)] = (1));

return statearr_63622;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1 = (function (state_63614){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63614);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63623){var ex__2744__auto__ = e63623;
var statearr_63624_63631 = state_63614;
(statearr_63624_63631[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63614[(4)]))){
var statearr_63625_63632 = state_63614;
(statearr_63625_63632[(1)] = cljs.core.first((state_63614[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63633 = state_63614;
state_63614 = G__63633;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__ = function(state_63614){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1.call(this,state_63614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2741__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63626 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63626[(6)] = c__2763__auto__);

return statearr_63626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__63635 = arguments.length;
switch (G__63635) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__63636 = opts;
var map__63636__$1 = cljs.core.__destructure_map(map__63636);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63636__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63636__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63636__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__63636__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__63637 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63637,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63637,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e63640){var e = e63640;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__63643 = arguments.length;
switch (G__63643) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63709){
var state_val_63710 = (state_63709[(1)]);
if((state_val_63710 === (7))){
var inst_63663 = (state_63709[(7)]);
var inst_63660 = (state_63709[(8)]);
var inst_63665 = (state_63709[(9)]);
var inst_63662 = (state_63709[(10)]);
var inst_63664 = (state_63709[(11)]);
var inst_63678 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_63679 = [ledger,txn,inst_63660,inst_63662,inst_63663,inst_63664,inst_63665];
var inst_63680 = cljs.core.PersistentHashMap.fromArrays(inst_63678,inst_63679);
var inst_63681 = fluree.db.util.core.without_nils(inst_63680);
var inst_63682 = fluree.db.operations.transact_async(conn,inst_63681);
var state_63709__$1 = state_63709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63709__$1,(13),inst_63682);
} else {
if((state_val_63710 === (20))){
var inst_63700 = (state_63709[(2)]);
var state_63709__$1 = state_63709;
var statearr_63711_63747 = state_63709__$1;
(statearr_63711_63747[(2)] = inst_63700);

(statearr_63711_63747[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (1))){
var state_63709__$1 = state_63709;
var statearr_63712_63748 = state_63709__$1;
(statearr_63712_63748[(2)] = null);

(statearr_63712_63748[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (4))){
var inst_63644 = (state_63709[(2)]);
var inst_63645 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_63644], 0));
var inst_63646 = cljs.core.ex_data(inst_63644);
var inst_63647 = cljs.core.ex_message(inst_63644);
var inst_63648 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63646,new cljs.core.Keyword(null,"message","message",-406056002),inst_63647);
var state_63709__$1 = (function (){var statearr_63713 = state_63709;
(statearr_63713[(12)] = inst_63645);

return statearr_63713;
})();
var statearr_63714_63749 = state_63709__$1;
(statearr_63714_63749[(2)] = inst_63648);

(statearr_63714_63749[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (15))){
var inst_63659 = (state_63709[(13)]);
var inst_63684 = (state_63709[(14)]);
var inst_63687 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63684,inst_63659);
var state_63709__$1 = state_63709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63709__$1,(17),inst_63687);
} else {
if((state_val_63710 === (13))){
var inst_63658 = (state_63709[(15)]);
var inst_63684 = (state_63709[(2)]);
var state_63709__$1 = (function (){var statearr_63715 = state_63709;
(statearr_63715[(14)] = inst_63684);

return statearr_63715;
})();
if(cljs.core.truth_(inst_63658)){
var statearr_63716_63750 = state_63709__$1;
(statearr_63716_63750[(1)] = (14));

} else {
var statearr_63717_63751 = state_63709__$1;
(statearr_63717_63751[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (6))){
var inst_63657 = (state_63709[(16)]);
var inst_63658 = (state_63709[(15)]);
var inst_63667 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_63657,opts);
var inst_63668 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_63667);
var inst_63669 = fluree.db.operations.command_async(conn,inst_63667);
var state_63709__$1 = (function (){var statearr_63718 = state_63709;
(statearr_63718[(17)] = inst_63669);

(statearr_63718[(18)] = inst_63668);

return statearr_63718;
})();
if(cljs.core.truth_(inst_63658)){
var statearr_63719_63752 = state_63709__$1;
(statearr_63719_63752[(1)] = (9));

} else {
var statearr_63720_63753 = state_63709__$1;
(statearr_63720_63753[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (17))){
var inst_63689 = (state_63709[(19)]);
var inst_63689__$1 = (state_63709[(2)]);
var inst_63690 = (inst_63689__$1 instanceof cljs.core.ExceptionInfo);
var state_63709__$1 = (function (){var statearr_63721 = state_63709;
(statearr_63721[(19)] = inst_63689__$1);

return statearr_63721;
})();
if(cljs.core.truth_(inst_63690)){
var statearr_63722_63754 = state_63709__$1;
(statearr_63722_63754[(1)] = (18));

} else {
var statearr_63723_63755 = state_63709__$1;
(statearr_63723_63755[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (3))){
var inst_63707 = (state_63709[(2)]);
var state_63709__$1 = state_63709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63709__$1,inst_63707);
} else {
if((state_val_63710 === (12))){
var inst_63674 = (state_63709[(2)]);
var state_63709__$1 = state_63709;
var statearr_63724_63756 = state_63709__$1;
(statearr_63724_63756[(2)] = inst_63674);

(statearr_63724_63756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (2))){
var inst_63657 = (state_63709[(16)]);
var _ = (function (){var statearr_63725 = state_63709;
(statearr_63725[(4)] = cljs.core.cons((5),(state_63709[(4)])));

return statearr_63725;
})();
var inst_63655 = opts;
var inst_63656 = cljs.core.__destructure_map(inst_63655);
var inst_63657__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_63658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_63659 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63656,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_63660 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_63661 = fluree.db.util.core.current_time_millis();
var inst_63662 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_63656,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_63661);
var inst_63663 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_63664 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_63665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63656,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_63709__$1 = (function (){var statearr_63726 = state_63709;
(statearr_63726[(16)] = inst_63657__$1);

(statearr_63726[(13)] = inst_63659);

(statearr_63726[(7)] = inst_63663);

(statearr_63726[(8)] = inst_63660);

(statearr_63726[(9)] = inst_63665);

(statearr_63726[(10)] = inst_63662);

(statearr_63726[(11)] = inst_63664);

(statearr_63726[(15)] = inst_63658);

return statearr_63726;
})();
if(cljs.core.truth_(inst_63657__$1)){
var statearr_63727_63757 = state_63709__$1;
(statearr_63727_63757[(1)] = (6));

} else {
var statearr_63728_63758 = state_63709__$1;
(statearr_63728_63758[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (19))){
var inst_63689 = (state_63709[(19)]);
var state_63709__$1 = state_63709;
var statearr_63729_63759 = state_63709__$1;
(statearr_63729_63759[(2)] = inst_63689);

(statearr_63729_63759[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (11))){
var inst_63676 = (state_63709[(2)]);
var state_63709__$1 = state_63709;
var statearr_63731_63760 = state_63709__$1;
(statearr_63731_63760[(2)] = inst_63676);

(statearr_63731_63760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (9))){
var inst_63669 = (state_63709[(17)]);
var state_63709__$1 = state_63709;
var statearr_63732_63761 = state_63709__$1;
(statearr_63732_63761[(2)] = inst_63669);

(statearr_63732_63761[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (5))){
var _ = (function (){var statearr_63733 = state_63709;
(statearr_63733[(4)] = cljs.core.rest((state_63709[(4)])));

return statearr_63733;
})();
var state_63709__$1 = state_63709;
var ex63730 = (state_63709__$1[(2)]);
var statearr_63734_63762 = state_63709__$1;
(statearr_63734_63762[(5)] = ex63730);


var statearr_63735_63763 = state_63709__$1;
(statearr_63735_63763[(1)] = (4));

(statearr_63735_63763[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (14))){
var inst_63684 = (state_63709[(14)]);
var state_63709__$1 = state_63709;
var statearr_63736_63764 = state_63709__$1;
(statearr_63736_63764[(2)] = inst_63684);

(statearr_63736_63764[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (16))){
var inst_63702 = (state_63709[(2)]);
var state_63709__$1 = state_63709;
var statearr_63737_63765 = state_63709__$1;
(statearr_63737_63765[(2)] = inst_63702);

(statearr_63737_63765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (10))){
var inst_63659 = (state_63709[(13)]);
var inst_63668 = (state_63709[(18)]);
var inst_63672 = fluree.db.api_js.monitor_tx(conn,ledger,inst_63668,inst_63659);
var state_63709__$1 = state_63709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63709__$1,(12),inst_63672);
} else {
if((state_val_63710 === (18))){
var inst_63689 = (state_63709[(19)]);
var inst_63692 = cljs.core.ex_data(inst_63689);
var inst_63693 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63694 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_63692);
var inst_63695 = cljs.core.ex_message(inst_63689);
var inst_63696 = [inst_63694,inst_63695,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_63697 = cljs.core.PersistentHashMap.fromArrays(inst_63693,inst_63696);
var state_63709__$1 = state_63709;
var statearr_63738_63766 = state_63709__$1;
(statearr_63738_63766[(2)] = inst_63697);

(statearr_63738_63766[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63710 === (8))){
var inst_63704 = (state_63709[(2)]);
var _ = (function (){var statearr_63739 = state_63709;
(statearr_63739[(4)] = cljs.core.rest((state_63709[(4)])));

return statearr_63739;
})();
var state_63709__$1 = state_63709;
var statearr_63740_63767 = state_63709__$1;
(statearr_63740_63767[(2)] = inst_63704);

(statearr_63740_63767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_63741 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63741[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_63741[(1)] = (1));

return statearr_63741;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_63709){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63709);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63742){var ex__2744__auto__ = e63742;
var statearr_63743_63768 = state_63709;
(statearr_63743_63768[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63709[(4)]))){
var statearr_63744_63769 = state_63709;
(statearr_63744_63769[(1)] = cljs.core.first((state_63709[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63770 = state_63709;
state_63709 = G__63770;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_63709){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_63709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63745 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63745[(6)] = c__2763__auto__);

return statearr_63745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4870__auto__ = [];
var len__4864__auto___63772 = arguments.length;
var i__4865__auto___63773 = (0);
while(true){
if((i__4865__auto___63773 < len__4864__auto___63772)){
args__4870__auto__.push((arguments[i__4865__auto___63773]));

var G__63774 = (i__4865__auto___63773 + (1));
i__4865__auto___63773 = G__63774;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((0) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4871__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq63771){
var self__4852__auto__ = this;
return self__4852__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq63771));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63805){
var state_val_63806 = (state_63805[(1)]);
if((state_val_63806 === (1))){
var inst_63775 = cljs.core.first(flakes);
var inst_63776 = cljs.core.rest(flakes);
var inst_63777 = cljs.core.PersistentVector.EMPTY;
var inst_63778 = inst_63775;
var inst_63779 = inst_63776;
var inst_63780 = inst_63777;
var state_63805__$1 = (function (){var statearr_63807 = state_63805;
(statearr_63807[(7)] = inst_63778);

(statearr_63807[(8)] = inst_63780);

(statearr_63807[(9)] = inst_63779);

return statearr_63807;
})();
var statearr_63808_63821 = state_63805__$1;
(statearr_63808_63821[(2)] = null);

(statearr_63808_63821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63806 === (2))){
var inst_63778 = (state_63805[(7)]);
var inst_63782 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_63783 = cljs.core.PersistentHashMap.EMPTY;
var inst_63784 = [true,inst_63783];
var inst_63785 = cljs.core.PersistentHashMap.fromArrays(inst_63782,inst_63784);
var inst_63786 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_63785,inst_63778);
var state_63805__$1 = state_63805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63805__$1,(4),inst_63786);
} else {
if((state_val_63806 === (3))){
var inst_63803 = (state_63805[(2)]);
var state_63805__$1 = state_63805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63805__$1,inst_63803);
} else {
if((state_val_63806 === (4))){
var inst_63780 = (state_63805[(8)]);
var inst_63779 = (state_63805[(9)]);
var inst_63788 = (state_63805[(2)]);
var inst_63789 = fluree.db.util.async.throw_err(inst_63788);
var inst_63790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63791 = [inst_63789];
var inst_63792 = (new cljs.core.PersistentVector(null,1,(5),inst_63790,inst_63791,null));
var inst_63793 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63780,inst_63792);
var inst_63794 = cljs.core.first(inst_63779);
var state_63805__$1 = (function (){var statearr_63809 = state_63805;
(statearr_63809[(10)] = inst_63793);

return statearr_63809;
})();
if(cljs.core.truth_(inst_63794)){
var statearr_63810_63822 = state_63805__$1;
(statearr_63810_63822[(1)] = (5));

} else {
var statearr_63811_63823 = state_63805__$1;
(statearr_63811_63823[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63806 === (5))){
var inst_63793 = (state_63805[(10)]);
var inst_63779 = (state_63805[(9)]);
var inst_63796 = cljs.core.first(inst_63779);
var inst_63797 = cljs.core.rest(inst_63779);
var inst_63778 = inst_63796;
var inst_63779__$1 = inst_63797;
var inst_63780 = inst_63793;
var state_63805__$1 = (function (){var statearr_63812 = state_63805;
(statearr_63812[(7)] = inst_63778);

(statearr_63812[(8)] = inst_63780);

(statearr_63812[(9)] = inst_63779__$1);

return statearr_63812;
})();
var statearr_63813_63824 = state_63805__$1;
(statearr_63813_63824[(2)] = null);

(statearr_63813_63824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63806 === (6))){
var inst_63793 = (state_63805[(10)]);
var state_63805__$1 = state_63805;
var statearr_63814_63825 = state_63805__$1;
(statearr_63814_63825[(2)] = inst_63793);

(statearr_63814_63825[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63806 === (7))){
var inst_63801 = (state_63805[(2)]);
var state_63805__$1 = state_63805;
var statearr_63815_63826 = state_63805__$1;
(statearr_63815_63826[(2)] = inst_63801);

(statearr_63815_63826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_63816 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_63816[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__);

(statearr_63816[(1)] = (1));

return statearr_63816;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1 = (function (state_63805){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63805);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63817){var ex__2744__auto__ = e63817;
var statearr_63818_63827 = state_63805;
(statearr_63818_63827[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63805[(4)]))){
var statearr_63819_63828 = state_63805;
(statearr_63819_63828[(1)] = cljs.core.first((state_63805[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63829 = state_63805;
state_63805 = G__63829;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__ = function(state_63805){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1.call(this,state_63805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63820 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63820[(6)] = c__2763__auto__);

return statearr_63820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63897){
var state_val_63898 = (state_63897[(1)]);
if((state_val_63898 === (7))){
var inst_63857 = (state_63897[(2)]);
var inst_63858 = fluree.db.util.async.throw_err(inst_63857);
var state_63897__$1 = state_63897;
var statearr_63899_63925 = state_63897__$1;
(statearr_63899_63925[(2)] = inst_63858);

(statearr_63899_63925[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (1))){
var inst_63834 = cljs.core.volatile_BANG_((0));
var inst_63835 = cljs.core.PersistentHashMap.EMPTY;
var inst_63836 = cljs.core.volatile_BANG_(inst_63835);
var inst_63837 = cljs.core.first(resp);
var inst_63838 = cljs.core.rest(resp);
var inst_63839 = cljs.core.PersistentVector.EMPTY;
var inst_63840 = inst_63834;
var inst_63841 = inst_63836;
var inst_63842 = inst_63837;
var inst_63843 = inst_63838;
var inst_63844 = inst_63839;
var state_63897__$1 = (function (){var statearr_63900 = state_63897;
(statearr_63900[(7)] = inst_63843);

(statearr_63900[(8)] = inst_63841);

(statearr_63900[(9)] = inst_63840);

(statearr_63900[(10)] = inst_63844);

(statearr_63900[(11)] = inst_63842);

return statearr_63900;
})();
var statearr_63901_63926 = state_63897__$1;
(statearr_63901_63926[(2)] = null);

(statearr_63901_63926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (4))){
var inst_63843 = (state_63897[(7)]);
var inst_63841 = (state_63897[(8)]);
var inst_63848 = (state_63897[(12)]);
var inst_63840 = (state_63897[(9)]);
var inst_63846 = (state_63897[(13)]);
var inst_63844 = (state_63897[(10)]);
var inst_63842 = (state_63897[(11)]);
var inst_63852 = (function (){var fuel = inst_63840;
var cache = inst_63841;
var curr_block = inst_63842;
var rest_blocks = inst_63843;
var acc = inst_63844;
var flakes = inst_63846;
var asserted = inst_63848;
return (function (p1__63831_SHARP_){
return p1__63831_SHARP_.s;
});
})();
var inst_63853 = cljs.core.group_by(inst_63852,inst_63848);
var inst_63854 = cljs.core.vals(inst_63853);
var inst_63855 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63841,inst_63840,inst_63854);
var state_63897__$1 = state_63897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63897__$1,(7),inst_63855);
} else {
if((state_val_63898 === (13))){
var inst_63885 = (state_63897[(14)]);
var state_63897__$1 = state_63897;
var statearr_63902_63927 = state_63897__$1;
(statearr_63902_63927[(2)] = inst_63885);

(statearr_63902_63927[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (6))){
var inst_63843 = (state_63897[(7)]);
var inst_63841 = (state_63897[(8)]);
var inst_63848 = (state_63897[(12)]);
var inst_63863 = (state_63897[(15)]);
var inst_63840 = (state_63897[(9)]);
var inst_63846 = (state_63897[(13)]);
var inst_63844 = (state_63897[(10)]);
var inst_63842 = (state_63897[(11)]);
var inst_63861 = (state_63897[(16)]);
var inst_63861__$1 = (state_63897[(2)]);
var inst_63862 = (function (){var fuel = inst_63840;
var cache = inst_63841;
var curr_block = inst_63842;
var rest_blocks = inst_63843;
var acc = inst_63844;
var flakes = inst_63846;
var asserted = inst_63848;
var asserted_SINGLEQUOTE_ = inst_63861__$1;
return (function (p1__63832_SHARP_){
return p1__63832_SHARP_.op === false;
});
})();
var inst_63863__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63862,inst_63846);
var inst_63864 = cljs.core.empty_QMARK_(inst_63863__$1);
var inst_63865 = (!(inst_63864));
var state_63897__$1 = (function (){var statearr_63905 = state_63897;
(statearr_63905[(15)] = inst_63863__$1);

(statearr_63905[(16)] = inst_63861__$1);

return statearr_63905;
})();
if(inst_63865){
var statearr_63906_63928 = state_63897__$1;
(statearr_63906_63928[(1)] = (8));

} else {
var statearr_63907_63929 = state_63897__$1;
(statearr_63907_63929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (3))){
var inst_63895 = (state_63897[(2)]);
var state_63897__$1 = state_63897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63897__$1,inst_63895);
} else {
if((state_val_63898 === (12))){
var inst_63843 = (state_63897[(7)]);
var inst_63841 = (state_63897[(8)]);
var inst_63840 = (state_63897[(9)]);
var inst_63885 = (state_63897[(14)]);
var inst_63888 = cljs.core.first(inst_63843);
var inst_63889 = cljs.core.rest(inst_63843);
var tmp63903 = inst_63841;
var tmp63904 = inst_63840;
var inst_63840__$1 = tmp63904;
var inst_63841__$1 = tmp63903;
var inst_63842 = inst_63888;
var inst_63843__$1 = inst_63889;
var inst_63844 = inst_63885;
var state_63897__$1 = (function (){var statearr_63908 = state_63897;
(statearr_63908[(7)] = inst_63843__$1);

(statearr_63908[(8)] = inst_63841__$1);

(statearr_63908[(9)] = inst_63840__$1);

(statearr_63908[(10)] = inst_63844);

(statearr_63908[(11)] = inst_63842);

return statearr_63908;
})();
var statearr_63909_63930 = state_63897__$1;
(statearr_63909_63930[(2)] = null);

(statearr_63909_63930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (2))){
var inst_63843 = (state_63897[(7)]);
var inst_63841 = (state_63897[(8)]);
var inst_63848 = (state_63897[(12)]);
var inst_63840 = (state_63897[(9)]);
var inst_63846 = (state_63897[(13)]);
var inst_63844 = (state_63897[(10)]);
var inst_63842 = (state_63897[(11)]);
var inst_63846__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_63842);
var inst_63847 = (function (){var fuel = inst_63840;
var cache = inst_63841;
var curr_block = inst_63842;
var rest_blocks = inst_63843;
var acc = inst_63844;
var flakes = inst_63846__$1;
return (function (p1__63830_SHARP_){
return p1__63830_SHARP_.op;
});
})();
var inst_63848__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_63847,inst_63846__$1);
var inst_63849 = cljs.core.empty_QMARK_(inst_63848__$1);
var inst_63850 = (!(inst_63849));
var state_63897__$1 = (function (){var statearr_63910 = state_63897;
(statearr_63910[(12)] = inst_63848__$1);

(statearr_63910[(13)] = inst_63846__$1);

return statearr_63910;
})();
if(inst_63850){
var statearr_63911_63931 = state_63897__$1;
(statearr_63911_63931[(1)] = (4));

} else {
var statearr_63912_63932 = state_63897__$1;
(statearr_63912_63932[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (11))){
var inst_63873 = (state_63897[(2)]);
var inst_63874 = fluree.db.util.async.throw_err(inst_63873);
var state_63897__$1 = state_63897;
var statearr_63913_63933 = state_63897__$1;
(statearr_63913_63933[(2)] = inst_63874);

(statearr_63913_63933[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (9))){
var state_63897__$1 = state_63897;
var statearr_63914_63934 = state_63897__$1;
(statearr_63914_63934[(2)] = null);

(statearr_63914_63934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (5))){
var state_63897__$1 = state_63897;
var statearr_63915_63935 = state_63897__$1;
(statearr_63915_63935[(2)] = null);

(statearr_63915_63935[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (14))){
var inst_63893 = (state_63897[(2)]);
var state_63897__$1 = state_63897;
var statearr_63916_63936 = state_63897__$1;
(statearr_63916_63936[(2)] = inst_63893);

(statearr_63916_63936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (10))){
var inst_63843 = (state_63897[(7)]);
var inst_63844 = (state_63897[(10)]);
var inst_63842 = (state_63897[(11)]);
var inst_63861 = (state_63897[(16)]);
var inst_63877 = (state_63897[(2)]);
var inst_63878 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_63879 = [inst_63861,inst_63877];
var inst_63880 = cljs.core.PersistentHashMap.fromArrays(inst_63878,inst_63879);
var inst_63881 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63842,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_63880);
var inst_63882 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63883 = [inst_63881];
var inst_63884 = (new cljs.core.PersistentVector(null,1,(5),inst_63882,inst_63883,null));
var inst_63885 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_63844,inst_63884);
var inst_63886 = cljs.core.first(inst_63843);
var state_63897__$1 = (function (){var statearr_63917 = state_63897;
(statearr_63917[(14)] = inst_63885);

return statearr_63917;
})();
if(cljs.core.truth_(inst_63886)){
var statearr_63918_63937 = state_63897__$1;
(statearr_63918_63937[(1)] = (12));

} else {
var statearr_63919_63938 = state_63897__$1;
(statearr_63919_63938[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63898 === (8))){
var inst_63843 = (state_63897[(7)]);
var inst_63841 = (state_63897[(8)]);
var inst_63848 = (state_63897[(12)]);
var inst_63863 = (state_63897[(15)]);
var inst_63840 = (state_63897[(9)]);
var inst_63846 = (state_63897[(13)]);
var inst_63844 = (state_63897[(10)]);
var inst_63842 = (state_63897[(11)]);
var inst_63861 = (state_63897[(16)]);
var inst_63867 = (function (){var flakes = inst_63846;
var rest_blocks = inst_63843;
var curr_block = inst_63842;
var asserted_SINGLEQUOTE_ = inst_63861;
var acc = inst_63844;
var fuel = inst_63840;
var cache = inst_63841;
var retracted = inst_63863;
var asserted = inst_63848;
return (function (p1__63833_SHARP_){
return p1__63833_SHARP_.s;
});
})();
var inst_63868 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_63863);
var inst_63869 = cljs.core.group_by(inst_63867,inst_63868);
var inst_63870 = cljs.core.vals(inst_63869);
var inst_63871 = fluree.db.api_js.format_flake_groups_pretty(db,inst_63841,inst_63840,inst_63870);
var state_63897__$1 = state_63897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63897__$1,(11),inst_63871);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0 = (function (){
var statearr_63920 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63920[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__);

(statearr_63920[(1)] = (1));

return statearr_63920;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1 = (function (state_63897){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63897);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e63921){var ex__2744__auto__ = e63921;
var statearr_63922_63939 = state_63897;
(statearr_63922_63939[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63897[(4)]))){
var statearr_63923_63940 = state_63897;
(statearr_63923_63940[(1)] = cljs.core.first((state_63897[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63941 = state_63897;
state_63897 = G__63941;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__ = function(state_63897){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1.call(this,state_63897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_63924 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_63924[(6)] = c__2763__auto__);

return statearr_63924;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64041){
var state_val_64042 = (state_64041[(1)]);
if((state_val_64042 === (7))){
var inst_64006 = (state_64041[(7)]);
var inst_64013 = (state_64041[(8)]);
var inst_64012 = cljs.core.seq(inst_64006);
var inst_64013__$1 = cljs.core.first(inst_64012);
var inst_64014 = cljs.core.next(inst_64012);
var state_64041__$1 = (function (){var statearr_64043 = state_64041;
(statearr_64043[(8)] = inst_64013__$1);

(statearr_64043[(9)] = inst_64014);

return statearr_64043;
})();
if(cljs.core.truth_(inst_64013__$1)){
var statearr_64044_64081 = state_64041__$1;
(statearr_64044_64081[(1)] = (9));

} else {
var statearr_64045_64082 = state_64041__$1;
(statearr_64045_64082[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (1))){
var state_64041__$1 = state_64041;
var statearr_64046_64083 = state_64041__$1;
(statearr_64046_64083[(2)] = null);

(statearr_64046_64083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (4))){
var inst_63943 = (state_64041[(2)]);
var state_64041__$1 = state_64041;
var statearr_64047_64084 = state_64041__$1;
(statearr_64047_64084[(2)] = inst_63943);

(statearr_64047_64084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (6))){
var inst_63992 = (state_64041[(2)]);
var inst_63993 = fluree.db.util.async.throw_err(inst_63992);
var inst_64001 = resp;
var inst_64002 = cljs.core.seq(inst_64001);
var inst_64003 = cljs.core.first(inst_64002);
var inst_64004 = cljs.core.next(inst_64002);
var inst_64005 = cljs.core.PersistentHashMap.EMPTY;
var inst_64006 = inst_64001;
var inst_64007 = inst_64005;
var state_64041__$1 = (function (){var statearr_64048 = state_64041;
(statearr_64048[(10)] = inst_64003);

(statearr_64048[(7)] = inst_64006);

(statearr_64048[(11)] = inst_63993);

(statearr_64048[(12)] = inst_64004);

(statearr_64048[(13)] = inst_64007);

return statearr_64048;
})();
var statearr_64049_64085 = state_64041__$1;
(statearr_64049_64085[(2)] = null);

(statearr_64049_64085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (3))){
var inst_64039 = (state_64041[(2)]);
var state_64041__$1 = state_64041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64041__$1,inst_64039);
} else {
if((state_val_64042 === (2))){
var _ = (function (){var statearr_64050 = state_64041;
(statearr_64050[(4)] = cljs.core.cons((5),(state_64041[(4)])));

return statearr_64050;
})();
var inst_63949 = (function (){return (function (p1__63942_SHARP_){
return p1__63942_SHARP_.t;
});
})();
var inst_63950 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_63949,resp);
var inst_63951 = cljs.core.set(inst_63950);
var inst_63988 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_63989 = (function (){var ts = inst_63951;
var c__2763__auto____$1 = inst_63988;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_63986){
var state_val_63987 = (state_63986[(1)]);
if((state_val_63987 === (1))){
var inst_63959 = ts;
var inst_63960 = cljs.core.seq(inst_63959);
var inst_63961 = cljs.core.first(inst_63960);
var inst_63962 = cljs.core.next(inst_63960);
var inst_63963 = cljs.core.PersistentHashMap.EMPTY;
var inst_63964 = inst_63959;
var inst_63965 = inst_63963;
var state_63986__$1 = (function (){var statearr_64051 = state_63986;
(statearr_64051[(7)] = inst_63965);

(statearr_64051[(8)] = inst_63962);

(statearr_64051[(9)] = inst_63964);

(statearr_64051[(10)] = inst_63961);

return statearr_64051;
})();
var statearr_64052_64086 = state_63986__$1;
(statearr_64052_64086[(2)] = null);

(statearr_64052_64086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63987 === (2))){
var inst_63964 = (state_63986[(9)]);
var inst_63971 = (state_63986[(11)]);
var inst_63970 = cljs.core.seq(inst_63964);
var inst_63971__$1 = cljs.core.first(inst_63970);
var inst_63972 = cljs.core.next(inst_63970);
var state_63986__$1 = (function (){var statearr_64053 = state_63986;
(statearr_64053[(12)] = inst_63972);

(statearr_64053[(11)] = inst_63971__$1);

return statearr_64053;
})();
if(cljs.core.truth_(inst_63971__$1)){
var statearr_64054_64087 = state_63986__$1;
(statearr_64054_64087[(1)] = (4));

} else {
var statearr_64055_64088 = state_63986__$1;
(statearr_64055_64088[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63987 === (3))){
var inst_63984 = (state_63986[(2)]);
var state_63986__$1 = state_63986;
return cljs.core.async.impl.ioc_helpers.return_chan(state_63986__$1,inst_63984);
} else {
if((state_val_63987 === (4))){
var inst_63971 = (state_63986[(11)]);
var inst_63974 = fluree.db.time_travel.non_border_t_to_block(db,inst_63971);
var state_63986__$1 = state_63986;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_63986__$1,(7),inst_63974);
} else {
if((state_val_63987 === (5))){
var inst_63965 = (state_63986[(7)]);
var state_63986__$1 = state_63986;
var statearr_64056_64089 = state_63986__$1;
(statearr_64056_64089[(2)] = inst_63965);

(statearr_64056_64089[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63987 === (6))){
var inst_63982 = (state_63986[(2)]);
var state_63986__$1 = state_63986;
var statearr_64057_64090 = state_63986__$1;
(statearr_64057_64090[(2)] = inst_63982);

(statearr_64057_64090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63987 === (7))){
var inst_63965 = (state_63986[(7)]);
var inst_63972 = (state_63986[(12)]);
var inst_63971 = (state_63986[(11)]);
var inst_63976 = (state_63986[(2)]);
var inst_63977 = fluree.db.util.async.throw_err(inst_63976);
var inst_63978 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_63965,inst_63971,inst_63977);
var inst_63964 = inst_63972;
var inst_63965__$1 = inst_63978;
var state_63986__$1 = (function (){var statearr_64058 = state_63986;
(statearr_64058[(7)] = inst_63965__$1);

(statearr_64058[(9)] = inst_63964);

return statearr_64058;
})();
var statearr_64059_64091 = state_63986__$1;
(statearr_64059_64091[(2)] = null);

(statearr_64059_64091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_64060 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64060[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__);

(statearr_64060[(1)] = (1));

return statearr_64060;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1 = (function (state_63986){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_63986);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64061){var ex__2744__auto__ = e64061;
var statearr_64062_64092 = state_63986;
(statearr_64062_64092[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_63986[(4)]))){
var statearr_64063_64093 = state_63986;
(statearr_64063_64093[(1)] = cljs.core.first((state_63986[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64094 = state_63986;
state_63986 = G__64094;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = function(state_63986){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1.call(this,state_63986);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64064 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_64064[(6)] = c__2763__auto____$1);

return statearr_64064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_63990 = cljs.core.async.impl.dispatch.run(inst_63989);
var state_64041__$1 = (function (){var statearr_64065 = state_64041;
(statearr_64065[(14)] = inst_63990);

return statearr_64065;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64041__$1,(6),inst_63988);
} else {
if((state_val_64042 === (11))){
var inst_64033 = (state_64041[(2)]);
var state_64041__$1 = state_64041;
var statearr_64067_64095 = state_64041__$1;
(statearr_64067_64095[(2)] = inst_64033);

(statearr_64067_64095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (9))){
var inst_63993 = (state_64041[(11)]);
var inst_64013 = (state_64041[(8)]);
var inst_64007 = (state_64041[(13)]);
var inst_64014 = (state_64041[(9)]);
var inst_64016 = inst_64013.t;
var inst_64017 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_63993,inst_64016);
var inst_64018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64019 = [inst_64017,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64020 = (new cljs.core.PersistentVector(null,2,(5),inst_64018,inst_64019,null));
var inst_64021 = cljs.core.assoc_in(inst_64007,inst_64020,inst_64017);
var inst_64022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64023 = [inst_64017,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_64024 = (new cljs.core.PersistentVector(null,2,(5),inst_64022,inst_64023,null));
var inst_64025 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64021,inst_64024,cljs.core.conj,inst_64013);
var inst_64026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64027 = [inst_64017,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_64028 = (new cljs.core.PersistentVector(null,2,(5),inst_64026,inst_64027,null));
var inst_64029 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_64025,inst_64028,fluree.db.api_js.min_safe,inst_64016);
var inst_64006 = inst_64014;
var inst_64007__$1 = inst_64029;
var state_64041__$1 = (function (){var statearr_64068 = state_64041;
(statearr_64068[(7)] = inst_64006);

(statearr_64068[(13)] = inst_64007__$1);

return statearr_64068;
})();
var statearr_64069_64096 = state_64041__$1;
(statearr_64069_64096[(2)] = null);

(statearr_64069_64096[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (5))){
var _ = (function (){var statearr_64070 = state_64041;
(statearr_64070[(4)] = cljs.core.rest((state_64041[(4)])));

return statearr_64070;
})();
var state_64041__$1 = state_64041;
var ex64066 = (state_64041__$1[(2)]);
var statearr_64071_64097 = state_64041__$1;
(statearr_64071_64097[(5)] = ex64066);


if((ex64066 instanceof Error)){
var statearr_64072_64098 = state_64041__$1;
(statearr_64072_64098[(1)] = (4));

(statearr_64072_64098[(5)] = null);

} else {
throw ex64066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (10))){
var inst_64007 = (state_64041[(13)]);
var state_64041__$1 = state_64041;
var statearr_64073_64099 = state_64041__$1;
(statearr_64073_64099[(2)] = inst_64007);

(statearr_64073_64099[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64042 === (8))){
var inst_64035 = (state_64041[(2)]);
var inst_64036 = cljs.core.vals(inst_64035);
var _ = (function (){var statearr_64074 = state_64041;
(statearr_64074[(4)] = cljs.core.rest((state_64041[(4)])));

return statearr_64074;
})();
var state_64041__$1 = state_64041;
var statearr_64075_64100 = state_64041__$1;
(statearr_64075_64100[(2)] = inst_64036);

(statearr_64075_64100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0 = (function (){
var statearr_64076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64076[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__);

(statearr_64076[(1)] = (1));

return statearr_64076;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1 = (function (state_64041){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_64041);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64077){var ex__2744__auto__ = e64077;
var statearr_64078_64101 = state_64041;
(statearr_64078_64101[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_64041[(4)]))){
var statearr_64079_64102 = state_64041;
(statearr_64079_64102[(1)] = cljs.core.first((state_64041[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64103 = state_64041;
state_64041 = G__64103;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__ = function(state_64041){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1.call(this,state_64041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2741__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64080 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_64080[(6)] = c__2763__auto__);

return statearr_64080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64248){
var state_val_64249 = (state_64248[(1)]);
if((state_val_64249 === (7))){
var inst_64128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64129 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64130 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64131 = [inst_64129,inst_64130];
var inst_64132 = (new cljs.core.PersistentVector(null,2,(5),inst_64128,inst_64131,null));
var state_64248__$1 = state_64248;
var statearr_64250_64321 = state_64248__$1;
(statearr_64250_64321[(2)] = inst_64132);

(statearr_64250_64321[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (20))){
var inst_64158 = (state_64248[(7)]);
var state_64248__$1 = state_64248;
var statearr_64251_64322 = state_64248__$1;
(statearr_64251_64322[(2)] = inst_64158);

(statearr_64251_64322[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (27))){
var state_64248__$1 = state_64248;
var statearr_64252_64323 = state_64248__$1;
(statearr_64252_64323[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (1))){
var state_64248__$1 = state_64248;
var statearr_64254_64324 = state_64248__$1;
(statearr_64254_64324[(2)] = null);

(statearr_64254_64324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (24))){
var inst_64157 = (state_64248[(8)]);
var state_64248__$1 = state_64248;
if(cljs.core.truth_(inst_64157)){
var statearr_64255_64325 = state_64248__$1;
(statearr_64255_64325[(1)] = (26));

} else {
var statearr_64256_64326 = state_64248__$1;
(statearr_64256_64326[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (39))){
var inst_64204 = (state_64248[(9)]);
var inst_64203 = (state_64248[(10)]);
var inst_64229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64230 = [inst_64203,inst_64204];
var inst_64231 = (new cljs.core.PersistentVector(null,2,(5),inst_64229,inst_64230,null));
var state_64248__$1 = state_64248;
var statearr_64257_64327 = state_64248__$1;
(statearr_64257_64327[(2)] = inst_64231);

(statearr_64257_64327[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (4))){
var inst_64104 = (state_64248[(2)]);
var inst_64105 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64104], 0));
var inst_64106 = cljs.core.ex_data(inst_64104);
var inst_64107 = cljs.core.ex_message(inst_64104);
var inst_64108 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64106,new cljs.core.Keyword(null,"message","message",-406056002),inst_64107);
var state_64248__$1 = (function (){var statearr_64258 = state_64248;
(statearr_64258[(11)] = inst_64105);

return statearr_64258;
})();
var statearr_64259_64328 = state_64248__$1;
(statearr_64259_64328[(2)] = inst_64108);

(statearr_64259_64328[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (15))){
var inst_64137 = (state_64248[(12)]);
var inst_64142 = (state_64248[(13)]);
var inst_64151 = (state_64248[(2)]);
var inst_64152 = [inst_64142,inst_64151];
var inst_64153 = (new cljs.core.PersistentVector(null,2,(5),inst_64137,inst_64152,null));
var state_64248__$1 = state_64248;
var statearr_64260_64329 = state_64248__$1;
(statearr_64260_64329[(2)] = inst_64153);

(statearr_64260_64329[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (21))){
var inst_64157 = (state_64248[(8)]);
var state_64248__$1 = state_64248;
var statearr_64261_64330 = state_64248__$1;
(statearr_64261_64330[(2)] = inst_64157);

(statearr_64261_64330[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (31))){
var inst_64198 = (state_64248[(2)]);
var state_64248__$1 = state_64248;
var statearr_64262_64331 = state_64248__$1;
(statearr_64262_64331[(2)] = inst_64198);

(statearr_64262_64331[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (32))){
var inst_64204 = (state_64248[(9)]);
var inst_64207 = cljs.core.pos_int_QMARK_(inst_64204);
var state_64248__$1 = state_64248;
var statearr_64263_64332 = state_64248__$1;
(statearr_64263_64332[(2)] = inst_64207);

(statearr_64263_64332[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (40))){
var inst_64159 = (state_64248[(14)]);
var inst_64235 = (state_64248[(15)]);
var inst_64233 = (state_64248[(2)]);
var inst_64234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64233,(0),null);
var inst_64235__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64233,(1),null);
var inst_64236 = (inst_64235__$1 > inst_64159);
var state_64248__$1 = (function (){var statearr_64264 = state_64248;
(statearr_64264[(16)] = inst_64234);

(statearr_64264[(15)] = inst_64235__$1);

return statearr_64264;
})();
if(cljs.core.truth_(inst_64236)){
var statearr_64265_64333 = state_64248__$1;
(statearr_64265_64333[(1)] = (41));

} else {
var statearr_64266_64334 = state_64248__$1;
(statearr_64266_64334[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (33))){
var inst_64205 = (state_64248[(17)]);
var state_64248__$1 = state_64248;
var statearr_64267_64335 = state_64248__$1;
(statearr_64267_64335[(2)] = inst_64205);

(statearr_64267_64335[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (13))){
var inst_64143 = (state_64248[(18)]);
var inst_64145 = fluree.db.time_travel.block_to_int_format(db,inst_64143);
var state_64248__$1 = state_64248;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64248__$1,(16),inst_64145);
} else {
if((state_val_64249 === (22))){
var inst_64176 = (state_64248[(2)]);
var state_64248__$1 = state_64248;
if(cljs.core.truth_(inst_64176)){
var statearr_64268_64336 = state_64248__$1;
(statearr_64268_64336[(1)] = (23));

} else {
var statearr_64269_64337 = state_64248__$1;
(statearr_64269_64337[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (36))){
var state_64248__$1 = state_64248;
var statearr_64270_64338 = state_64248__$1;
(statearr_64270_64338[(2)] = null);

(statearr_64270_64338[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (41))){
var inst_64159 = (state_64248[(14)]);
var state_64248__$1 = state_64248;
var statearr_64271_64339 = state_64248__$1;
(statearr_64271_64339[(2)] = inst_64159);

(statearr_64271_64339[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (43))){
var inst_64234 = (state_64248[(16)]);
var inst_64240 = (state_64248[(2)]);
var inst_64241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64242 = [inst_64234,inst_64240];
var inst_64243 = (new cljs.core.PersistentVector(null,2,(5),inst_64241,inst_64242,null));
var _ = (function (){var statearr_64272 = state_64248;
(statearr_64272[(4)] = cljs.core.rest((state_64248[(4)])));

return statearr_64272;
})();
var state_64248__$1 = state_64248;
var statearr_64273_64340 = state_64248__$1;
(statearr_64273_64340[(2)] = inst_64243);

(statearr_64273_64340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (29))){
var inst_64134 = (state_64248[(19)]);
var inst_64189 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64134], 0));
var inst_64190 = ["Invalid block range provided: ",inst_64189].join('');
var inst_64191 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64192 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64193 = cljs.core.PersistentHashMap.fromArrays(inst_64191,inst_64192);
var inst_64194 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64190,inst_64193);
var inst_64195 = (function(){throw inst_64194})();
var state_64248__$1 = state_64248;
var statearr_64274_64341 = state_64248__$1;
(statearr_64274_64341[(2)] = inst_64195);

(statearr_64274_64341[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (6))){
var inst_64126 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64248__$1 = state_64248;
var statearr_64275_64342 = state_64248__$1;
(statearr_64275_64342[(2)] = inst_64126);

(statearr_64275_64342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (28))){
var inst_64200 = (state_64248[(2)]);
var state_64248__$1 = state_64248;
var statearr_64276_64343 = state_64248__$1;
(statearr_64276_64343[(2)] = inst_64200);

(statearr_64276_64343[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (25))){
var inst_64203 = (state_64248[(10)]);
var inst_64205 = (state_64248[(17)]);
var inst_64202 = (state_64248[(2)]);
var inst_64203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64202,(0),null);
var inst_64204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64202,(1),null);
var inst_64205__$1 = cljs.core.pos_int_QMARK_(inst_64203__$1);
var state_64248__$1 = (function (){var statearr_64277 = state_64248;
(statearr_64277[(9)] = inst_64204);

(statearr_64277[(10)] = inst_64203__$1);

(statearr_64277[(17)] = inst_64205__$1);

return statearr_64277;
})();
if(inst_64205__$1){
var statearr_64278_64344 = state_64248__$1;
(statearr_64278_64344[(1)] = (32));

} else {
var statearr_64279_64345 = state_64248__$1;
(statearr_64279_64345[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (34))){
var inst_64210 = (state_64248[(2)]);
var inst_64211 = cljs.core.not(inst_64210);
var state_64248__$1 = state_64248;
if(inst_64211){
var statearr_64280_64346 = state_64248__$1;
(statearr_64280_64346[(1)] = (35));

} else {
var statearr_64281_64347 = state_64248__$1;
(statearr_64281_64347[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (17))){
var inst_64157 = (state_64248[(8)]);
var inst_64159 = (state_64248[(14)]);
var inst_64162 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64157], 0));
var inst_64163 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64159], 0));
var inst_64164 = ["Start block is out of range for this ledger. Start block provided: ",inst_64162,". Database block: ",inst_64163].join('');
var inst_64165 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64166 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64167 = cljs.core.PersistentHashMap.fromArrays(inst_64165,inst_64166);
var inst_64168 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64164,inst_64167);
var inst_64169 = (function(){throw inst_64168})();
var state_64248__$1 = state_64248;
var statearr_64282_64348 = state_64248__$1;
(statearr_64282_64348[(2)] = inst_64169);

(statearr_64282_64348[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (3))){
var inst_64246 = (state_64248[(2)]);
var state_64248__$1 = state_64248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64248__$1,inst_64246);
} else {
if((state_val_64249 === (12))){
var inst_64143 = (state_64248[(18)]);
var inst_64134 = (state_64248[(19)]);
var inst_64141 = (state_64248[(2)]);
var inst_64142 = fluree.db.util.async.throw_err(inst_64141);
var inst_64143__$1 = cljs.core.second(inst_64134);
var state_64248__$1 = (function (){var statearr_64283 = state_64248;
(statearr_64283[(18)] = inst_64143__$1);

(statearr_64283[(13)] = inst_64142);

return statearr_64283;
})();
if(cljs.core.truth_(inst_64143__$1)){
var statearr_64284_64349 = state_64248__$1;
(statearr_64284_64349[(1)] = (13));

} else {
var statearr_64285_64350 = state_64248__$1;
(statearr_64285_64350[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (2))){
var _ = (function (){var statearr_64286 = state_64248;
(statearr_64286[(4)] = cljs.core.cons((5),(state_64248[(4)])));

return statearr_64286;
})();
var inst_64123 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_64124 = cljs.core.sequential_QMARK_(inst_64123);
var state_64248__$1 = state_64248;
if(inst_64124){
var statearr_64287_64351 = state_64248__$1;
(statearr_64287_64351[(1)] = (6));

} else {
var statearr_64288_64352 = state_64248__$1;
(statearr_64288_64352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (23))){
var inst_64158 = (state_64248[(7)]);
var inst_64157 = (state_64248[(8)]);
var inst_64178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64179 = [inst_64157,inst_64158];
var inst_64180 = (new cljs.core.PersistentVector(null,2,(5),inst_64178,inst_64179,null));
var state_64248__$1 = state_64248;
var statearr_64289_64353 = state_64248__$1;
(statearr_64289_64353[(2)] = inst_64180);

(statearr_64289_64353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (35))){
var inst_64134 = (state_64248[(19)]);
var inst_64213 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64134], 0));
var inst_64214 = ["Invalid block range provided: ",inst_64213].join('');
var inst_64215 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64216 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64217 = cljs.core.PersistentHashMap.fromArrays(inst_64215,inst_64216);
var inst_64218 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64214,inst_64217);
var inst_64219 = (function(){throw inst_64218})();
var state_64248__$1 = state_64248;
var statearr_64290_64354 = state_64248__$1;
(statearr_64290_64354[(2)] = inst_64219);

(statearr_64290_64354[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (19))){
var inst_64157 = (state_64248[(8)]);
var inst_64172 = (state_64248[(2)]);
var state_64248__$1 = (function (){var statearr_64291 = state_64248;
(statearr_64291[(20)] = inst_64172);

return statearr_64291;
})();
if(cljs.core.truth_(inst_64157)){
var statearr_64292_64355 = state_64248__$1;
(statearr_64292_64355[(1)] = (20));

} else {
var statearr_64293_64356 = state_64248__$1;
(statearr_64293_64356[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (11))){
var inst_64157 = (state_64248[(8)]);
var inst_64159 = (state_64248[(14)]);
var inst_64156 = (state_64248[(2)]);
var inst_64157__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64156,(0),null);
var inst_64158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64156,(1),null);
var inst_64159__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64160 = (inst_64157__$1 > inst_64159__$1);
var state_64248__$1 = (function (){var statearr_64295 = state_64248;
(statearr_64295[(7)] = inst_64158);

(statearr_64295[(8)] = inst_64157__$1);

(statearr_64295[(14)] = inst_64159__$1);

return statearr_64295;
})();
if(cljs.core.truth_(inst_64160)){
var statearr_64296_64357 = state_64248__$1;
(statearr_64296_64357[(1)] = (17));

} else {
var statearr_64297_64358 = state_64248__$1;
(statearr_64297_64358[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (9))){
var inst_64134 = (state_64248[(19)]);
var inst_64137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64138 = cljs.core.first(inst_64134);
var inst_64139 = fluree.db.time_travel.block_to_int_format(db,inst_64138);
var state_64248__$1 = (function (){var statearr_64298 = state_64248;
(statearr_64298[(12)] = inst_64137);

return statearr_64298;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64248__$1,(12),inst_64139);
} else {
if((state_val_64249 === (5))){
var _ = (function (){var statearr_64299 = state_64248;
(statearr_64299[(4)] = cljs.core.rest((state_64248[(4)])));

return statearr_64299;
})();
var state_64248__$1 = state_64248;
var ex64294 = (state_64248__$1[(2)]);
var statearr_64300_64359 = state_64248__$1;
(statearr_64300_64359[(5)] = ex64294);


var statearr_64301_64360 = state_64248__$1;
(statearr_64301_64360[(1)] = (4));

(statearr_64301_64360[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (14))){
var state_64248__$1 = state_64248;
var statearr_64302_64361 = state_64248__$1;
(statearr_64302_64361[(2)] = null);

(statearr_64302_64361[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (26))){
var inst_64157 = (state_64248[(8)]);
var inst_64183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64184 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_64185 = [inst_64157,inst_64184];
var inst_64186 = (new cljs.core.PersistentVector(null,2,(5),inst_64183,inst_64185,null));
var state_64248__$1 = state_64248;
var statearr_64303_64362 = state_64248__$1;
(statearr_64303_64362[(2)] = inst_64186);

(statearr_64303_64362[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (16))){
var inst_64147 = (state_64248[(2)]);
var inst_64148 = fluree.db.util.async.throw_err(inst_64147);
var state_64248__$1 = state_64248;
var statearr_64304_64363 = state_64248__$1;
(statearr_64304_64363[(2)] = inst_64148);

(statearr_64304_64363[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (38))){
var inst_64204 = (state_64248[(9)]);
var inst_64203 = (state_64248[(10)]);
var inst_64225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64226 = [inst_64204,inst_64203];
var inst_64227 = (new cljs.core.PersistentVector(null,2,(5),inst_64225,inst_64226,null));
var state_64248__$1 = state_64248;
var statearr_64305_64364 = state_64248__$1;
(statearr_64305_64364[(2)] = inst_64227);

(statearr_64305_64364[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (30))){
var state_64248__$1 = state_64248;
var statearr_64306_64365 = state_64248__$1;
(statearr_64306_64365[(2)] = null);

(statearr_64306_64365[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (10))){
var inst_64134 = (state_64248[(19)]);
var state_64248__$1 = state_64248;
var statearr_64307_64366 = state_64248__$1;
(statearr_64307_64366[(2)] = inst_64134);

(statearr_64307_64366[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (18))){
var state_64248__$1 = state_64248;
var statearr_64308_64367 = state_64248__$1;
(statearr_64308_64367[(2)] = null);

(statearr_64308_64367[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (42))){
var inst_64235 = (state_64248[(15)]);
var state_64248__$1 = state_64248;
var statearr_64309_64368 = state_64248__$1;
(statearr_64309_64368[(2)] = inst_64235);

(statearr_64309_64368[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (37))){
var inst_64204 = (state_64248[(9)]);
var inst_64203 = (state_64248[(10)]);
var inst_64222 = (state_64248[(2)]);
var inst_64223 = (inst_64204 < inst_64203);
var state_64248__$1 = (function (){var statearr_64310 = state_64248;
(statearr_64310[(21)] = inst_64222);

return statearr_64310;
})();
if(cljs.core.truth_(inst_64223)){
var statearr_64311_64369 = state_64248__$1;
(statearr_64311_64369[(1)] = (38));

} else {
var statearr_64312_64370 = state_64248__$1;
(statearr_64312_64370[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64249 === (8))){
var inst_64134 = (state_64248[(19)]);
var inst_64134__$1 = (state_64248[(2)]);
var inst_64135 = cljs.core.some(cljs.core.string_QMARK_,inst_64134__$1);
var state_64248__$1 = (function (){var statearr_64313 = state_64248;
(statearr_64313[(19)] = inst_64134__$1);

return statearr_64313;
})();
if(cljs.core.truth_(inst_64135)){
var statearr_64314_64371 = state_64248__$1;
(statearr_64314_64371[(1)] = (9));

} else {
var statearr_64315_64372 = state_64248__$1;
(statearr_64315_64372[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0 = (function (){
var statearr_64316 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64316[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__);

(statearr_64316[(1)] = (1));

return statearr_64316;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1 = (function (state_64248){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_64248);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64317){var ex__2744__auto__ = e64317;
var statearr_64318_64373 = state_64248;
(statearr_64318_64373[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_64248[(4)]))){
var statearr_64319_64374 = state_64248;
(statearr_64319_64374[(1)] = cljs.core.first((state_64248[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64375 = state_64248;
state_64248 = G__64375;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__ = function(state_64248){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1.call(this,state_64248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64320 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_64320[(6)] = c__2763__auto__);

return statearr_64320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__64377 = arguments.length;
switch (G__64377) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64468){
var state_val_64469 = (state_64468[(1)]);
if((state_val_64469 === (7))){
var inst_64400 = (state_64468[(7)]);
var inst_64403 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_64400);
var state_64468__$1 = state_64468;
var statearr_64470_64521 = state_64468__$1;
(statearr_64470_64521[(2)] = inst_64403);

(statearr_64470_64521[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (20))){
var inst_64439 = (state_64468[(8)]);
var inst_64442 = fluree.db.api_js.format_block_resp_pretty(db,inst_64439);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64468__$1,(23),inst_64442);
} else {
if((state_val_64469 === (27))){
var inst_64448 = (state_64468[(9)]);
var inst_64454 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64448);
var state_64468__$1 = state_64468;
var statearr_64471_64522 = state_64468__$1;
(statearr_64471_64522[(2)] = inst_64454);

(statearr_64471_64522[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (1))){
var state_64468__$1 = state_64468;
var statearr_64472_64523 = state_64468__$1;
(statearr_64472_64523[(2)] = null);

(statearr_64472_64523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (24))){
var inst_64448 = (state_64468[(9)]);
var inst_64451 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_64452 = cljs.core.sequential_QMARK_(inst_64448);
var state_64468__$1 = (function (){var statearr_64473 = state_64468;
(statearr_64473[(10)] = inst_64451);

return statearr_64473;
})();
if(inst_64452){
var statearr_64474_64524 = state_64468__$1;
(statearr_64474_64524[(1)] = (27));

} else {
var statearr_64475_64525 = state_64468__$1;
(statearr_64475_64525[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (4))){
var inst_64378 = (state_64468[(2)]);
var inst_64379 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64378], 0));
var inst_64380 = cljs.core.ex_data(inst_64378);
var inst_64381 = cljs.core.ex_message(inst_64378);
var inst_64382 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64380,new cljs.core.Keyword(null,"message","message",-406056002),inst_64381);
var state_64468__$1 = (function (){var statearr_64476 = state_64468;
(statearr_64476[(11)] = inst_64379);

return statearr_64476;
})();
var statearr_64477_64526 = state_64468__$1;
(statearr_64477_64526[(2)] = inst_64382);

(statearr_64477_64526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (15))){
var inst_64400 = (state_64468[(7)]);
var inst_64413 = (state_64468[(2)]);
var inst_64414 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64413,inst_64400);
var inst_64415 = (function(){throw inst_64414})();
var state_64468__$1 = state_64468;
var statearr_64478_64527 = state_64468__$1;
(statearr_64478_64527[(2)] = inst_64415);

(statearr_64478_64527[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (21))){
var inst_64439 = (state_64468[(8)]);
var state_64468__$1 = state_64468;
var statearr_64479_64528 = state_64468__$1;
(statearr_64479_64528[(2)] = inst_64439);

(statearr_64479_64528[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (13))){
var inst_64408 = (state_64468[(12)]);
var state_64468__$1 = state_64468;
var statearr_64480_64529 = state_64468__$1;
(statearr_64480_64529[(2)] = inst_64408);

(statearr_64480_64529[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (22))){
var inst_64448 = (state_64468[(2)]);
var inst_64449 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64468__$1 = (function (){var statearr_64481 = state_64468;
(statearr_64481[(9)] = inst_64448);

return statearr_64481;
})();
if(cljs.core.truth_(inst_64449)){
var statearr_64482_64530 = state_64468__$1;
(statearr_64482_64530[(1)] = (24));

} else {
var statearr_64483_64531 = state_64468__$1;
(statearr_64483_64531[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (29))){
var inst_64451 = (state_64468[(10)]);
var inst_64392 = (state_64468[(13)]);
var inst_64457 = (state_64468[(2)]);
var inst_64458 = fluree.db.util.core.response_time_formatted(inst_64392);
var inst_64459 = [(200),inst_64457,(100),inst_64458];
var inst_64460 = cljs.core.PersistentHashMap.fromArrays(inst_64451,inst_64459);
var state_64468__$1 = state_64468;
var statearr_64484_64532 = state_64468__$1;
(statearr_64484_64532[(2)] = inst_64460);

(statearr_64484_64532[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (6))){
var inst_64401 = (state_64468[(14)]);
var inst_64400 = (state_64468[(7)]);
var inst_64399 = (state_64468[(2)]);
var inst_64400__$1 = fluree.db.util.async.throw_err(inst_64399);
var inst_64401__$1 = cljs.core.map_QMARK_(inst_64400__$1);
var state_64468__$1 = (function (){var statearr_64485 = state_64468;
(statearr_64485[(14)] = inst_64401__$1);

(statearr_64485[(7)] = inst_64400__$1);

return statearr_64485;
})();
if(inst_64401__$1){
var statearr_64486_64533 = state_64468__$1;
(statearr_64486_64533[(1)] = (7));

} else {
var statearr_64487_64534 = state_64468__$1;
(statearr_64487_64534[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (28))){
var inst_64448 = (state_64468[(9)]);
var state_64468__$1 = state_64468;
var statearr_64488_64535 = state_64468__$1;
(statearr_64488_64535[(2)] = inst_64448);

(statearr_64488_64535[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (25))){
var inst_64448 = (state_64468[(9)]);
var state_64468__$1 = state_64468;
var statearr_64489_64536 = state_64468__$1;
(statearr_64489_64536[(2)] = inst_64448);

(statearr_64489_64536[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (17))){
var inst_64431 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_64432 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_64431].join('');
var inst_64433 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64434 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64435 = cljs.core.PersistentHashMap.fromArrays(inst_64433,inst_64434);
var inst_64436 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64432,inst_64435);
var inst_64437 = (function(){throw inst_64436})();
var state_64468__$1 = state_64468;
var statearr_64490_64537 = state_64468__$1;
(statearr_64490_64537[(2)] = inst_64437);

(statearr_64490_64537[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (3))){
var inst_64466 = (state_64468[(2)]);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64468__$1,inst_64466);
} else {
if((state_val_64469 === (12))){
var inst_64400 = (state_64468[(7)]);
var inst_64418 = (state_64468[(2)]);
var inst_64419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64400,(0),null);
var inst_64420 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64400,(1),null);
var inst_64421 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_64422 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_64423 = cljs.core.keys(inst_64422);
var inst_64424 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64421,inst_64423);
var state_64468__$1 = (function (){var statearr_64491 = state_64468;
(statearr_64491[(15)] = inst_64420);

(statearr_64491[(16)] = inst_64418);

(statearr_64491[(17)] = inst_64419);

return statearr_64491;
})();
if(inst_64424){
var statearr_64492_64538 = state_64468__$1;
(statearr_64492_64538[(1)] = (16));

} else {
var statearr_64493_64539 = state_64468__$1;
(statearr_64493_64539[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (2))){
var _ = (function (){var statearr_64494 = state_64468;
(statearr_64494[(4)] = cljs.core.cons((5),(state_64468[(4)])));

return statearr_64494;
})();
var inst_64392 = fluree.db.util.core.current_time_millis();
var inst_64393 = db;
var inst_64394 = cljs.core.__destructure_map(inst_64393);
var inst_64395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64394,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_64396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64394,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_64397 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_64468__$1 = (function (){var statearr_64495 = state_64468;
(statearr_64495[(13)] = inst_64392);

(statearr_64495[(18)] = inst_64396);

(statearr_64495[(19)] = inst_64395);

return statearr_64495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64468__$1,(6),inst_64397);
} else {
if((state_val_64469 === (23))){
var inst_64444 = (state_64468[(2)]);
var inst_64445 = fluree.db.util.async.throw_err(inst_64444);
var state_64468__$1 = state_64468;
var statearr_64496_64540 = state_64468__$1;
(statearr_64496_64540[(2)] = inst_64445);

(statearr_64496_64540[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (19))){
var inst_64428 = (state_64468[(2)]);
var inst_64429 = fluree.db.util.async.throw_err(inst_64428);
var state_64468__$1 = state_64468;
var statearr_64497_64541 = state_64468__$1;
(statearr_64497_64541[(2)] = inst_64429);

(statearr_64497_64541[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (11))){
var state_64468__$1 = state_64468;
var statearr_64499_64542 = state_64468__$1;
(statearr_64499_64542[(2)] = null);

(statearr_64499_64542[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (9))){
var inst_64406 = (state_64468[(2)]);
var state_64468__$1 = state_64468;
if(cljs.core.truth_(inst_64406)){
var statearr_64500_64543 = state_64468__$1;
(statearr_64500_64543[(1)] = (10));

} else {
var statearr_64501_64544 = state_64468__$1;
(statearr_64501_64544[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (5))){
var _ = (function (){var statearr_64502 = state_64468;
(statearr_64502[(4)] = cljs.core.rest((state_64468[(4)])));

return statearr_64502;
})();
var state_64468__$1 = state_64468;
var ex64498 = (state_64468__$1[(2)]);
var statearr_64503_64545 = state_64468__$1;
(statearr_64503_64545[(5)] = ex64498);


var statearr_64504_64546 = state_64468__$1;
(statearr_64504_64546[(1)] = (4));

(statearr_64504_64546[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (14))){
var inst_64396 = (state_64468[(18)]);
var inst_64395 = (state_64468[(19)]);
var inst_64411 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64395),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64396)].join('');
var state_64468__$1 = state_64468;
var statearr_64505_64547 = state_64468__$1;
(statearr_64505_64547[(2)] = inst_64411);

(statearr_64505_64547[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (26))){
var inst_64463 = (state_64468[(2)]);
var _ = (function (){var statearr_64506 = state_64468;
(statearr_64506[(4)] = cljs.core.rest((state_64468[(4)])));

return statearr_64506;
})();
var state_64468__$1 = state_64468;
var statearr_64507_64548 = state_64468__$1;
(statearr_64507_64548[(2)] = inst_64463);

(statearr_64507_64548[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (16))){
var inst_64420 = (state_64468[(15)]);
var inst_64419 = (state_64468[(17)]);
var inst_64426 = fluree.db.query.block.block_range(db,inst_64419,inst_64420,opts);
var state_64468__$1 = state_64468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64468__$1,(19),inst_64426);
} else {
if((state_val_64469 === (10))){
var inst_64408 = (state_64468[(12)]);
var inst_64400 = (state_64468[(7)]);
var inst_64408__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_64400);
var state_64468__$1 = (function (){var statearr_64508 = state_64468;
(statearr_64508[(12)] = inst_64408__$1);

return statearr_64508;
})();
if(cljs.core.truth_(inst_64408__$1)){
var statearr_64509_64549 = state_64468__$1;
(statearr_64509_64549[(1)] = (13));

} else {
var statearr_64510_64550 = state_64468__$1;
(statearr_64510_64550[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (18))){
var inst_64439 = (state_64468[(2)]);
var inst_64440 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_64468__$1 = (function (){var statearr_64511 = state_64468;
(statearr_64511[(8)] = inst_64439);

return statearr_64511;
})();
if(cljs.core.truth_(inst_64440)){
var statearr_64512_64551 = state_64468__$1;
(statearr_64512_64551[(1)] = (20));

} else {
var statearr_64513_64552 = state_64468__$1;
(statearr_64513_64552[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64469 === (8))){
var inst_64401 = (state_64468[(14)]);
var state_64468__$1 = state_64468;
var statearr_64514_64553 = state_64468__$1;
(statearr_64514_64553[(2)] = inst_64401);

(statearr_64514_64553[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64515[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64515[(1)] = (1));

return statearr_64515;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64468){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_64468);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64516){var ex__2744__auto__ = e64516;
var statearr_64517_64554 = state_64468;
(statearr_64517_64554[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_64468[(4)]))){
var statearr_64518_64555 = state_64468;
(statearr_64518_64555[(1)] = cljs.core.first((state_64468[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64556 = state_64468;
state_64468 = G__64556;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64468){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64519 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_64519[(6)] = c__2763__auto__);

return statearr_64519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__64558 = arguments.length;
switch (G__64558) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64753){
var state_val_64754 = (state_64753[(1)]);
if((state_val_64754 === (62))){
var inst_64751 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64753__$1,inst_64751);
} else {
if((state_val_64754 === (7))){
var inst_64579 = (state_64753[(7)]);
var inst_64589 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_64579);
var state_64753__$1 = state_64753;
var statearr_64755_64846 = state_64753__$1;
(statearr_64755_64846[(2)] = inst_64589);

(statearr_64755_64846[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (59))){
var inst_64739 = (state_64753[(2)]);
var inst_64740 = fluree.db.util.async.throw_err(inst_64739);
var state_64753__$1 = state_64753;
var statearr_64756_64847 = state_64753__$1;
(statearr_64756_64847[(2)] = inst_64740);

(statearr_64756_64847[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (20))){
var inst_64647 = (state_64753[(8)]);
var inst_64655 = (state_64753[(9)]);
var inst_64647__$1 = (state_64753[(2)]);
var inst_64648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64647__$1,(0));
var inst_64650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64647__$1,(1));
var inst_64651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64647__$1,(2));
var inst_64652 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64647__$1,(3));
var inst_64653 = [inst_64649,inst_64650,inst_64651,inst_64652];
var inst_64654 = (new cljs.core.PersistentVector(null,4,(5),inst_64648,inst_64653,null));
var inst_64655__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64654,(0),null);
var inst_64656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64654,(1),null);
var inst_64657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64654,(2),null);
var inst_64658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64654,(3),null);
var inst_64659 = (inst_64655__$1 == null);
var inst_64660 = cljs.core.not(inst_64659);
var state_64753__$1 = (function (){var statearr_64757 = state_64753;
(statearr_64757[(8)] = inst_64647__$1);

(statearr_64757[(10)] = inst_64656);

(statearr_64757[(11)] = inst_64658);

(statearr_64757[(9)] = inst_64655__$1);

(statearr_64757[(12)] = inst_64657);

return statearr_64757;
})();
if(inst_64660){
var statearr_64758_64848 = state_64753__$1;
(statearr_64758_64848[(1)] = (30));

} else {
var statearr_64759_64849 = state_64753__$1;
(statearr_64759_64849[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (58))){
var inst_64587 = (state_64753[(13)]);
var inst_64743 = (state_64753[(2)]);
var state_64753__$1 = (function (){var statearr_64760 = state_64753;
(statearr_64760[(14)] = inst_64743);

return statearr_64760;
})();
if(cljs.core.truth_(inst_64587)){
var statearr_64761_64850 = state_64753__$1;
(statearr_64761_64850[(1)] = (60));

} else {
var statearr_64762_64851 = state_64753__$1;
(statearr_64762_64851[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (60))){
var inst_64743 = (state_64753[(14)]);
var inst_64731 = (state_64753[(15)]);
var inst_64745 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_64746 = cljs.core.count(inst_64731);
var inst_64747 = [inst_64743,inst_64746,(200)];
var inst_64748 = cljs.core.PersistentHashMap.fromArrays(inst_64745,inst_64747);
var state_64753__$1 = state_64753;
var statearr_64763_64852 = state_64753__$1;
(statearr_64763_64852[(2)] = inst_64748);

(statearr_64763_64852[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (27))){
var inst_64566 = (state_64753[(16)]);
var inst_64635 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64566)].join('');
var inst_64636 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64637 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64638 = cljs.core.PersistentHashMap.fromArrays(inst_64636,inst_64637);
var inst_64639 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64635,inst_64638);
var inst_64640 = (function(){throw inst_64639})();
var state_64753__$1 = state_64753;
var statearr_64764_64853 = state_64753__$1;
(statearr_64764_64853[(2)] = inst_64640);

(statearr_64764_64853[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (1))){
var inst_64563 = query_map;
var inst_64564 = cljs.core.__destructure_map(inst_64563);
var inst_64565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64564,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64564,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_64567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64564,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_64753__$1 = (function (){var statearr_64765 = state_64753;
(statearr_64765[(17)] = inst_64565);

(statearr_64765[(18)] = inst_64567);

(statearr_64765[(16)] = inst_64566);

return statearr_64765;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(2),sources);
} else {
if((state_val_64754 === (24))){
var inst_64566 = (state_64753[(16)]);
var inst_64624 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64566)].join('');
var inst_64625 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64626 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64627 = cljs.core.PersistentHashMap.fromArrays(inst_64625,inst_64626);
var inst_64628 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64624,inst_64627);
var inst_64629 = (function(){throw inst_64628})();
var state_64753__$1 = state_64753;
var statearr_64766_64854 = state_64753__$1;
(statearr_64766_64854[(2)] = inst_64629);

(statearr_64766_64854[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (55))){
var inst_64567 = (state_64753[(18)]);
var inst_64734 = (state_64753[(2)]);
var inst_64735 = fluree.db.util.async.throw_err(inst_64734);
var state_64753__$1 = (function (){var statearr_64767 = state_64753;
(statearr_64767[(19)] = inst_64735);

return statearr_64767;
})();
if(cljs.core.truth_(inst_64567)){
var statearr_64768_64855 = state_64753__$1;
(statearr_64768_64855[(1)] = (56));

} else {
var statearr_64769_64856 = state_64753__$1;
(statearr_64769_64856[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (39))){
var inst_64656 = (state_64753[(10)]);
var inst_64658 = (state_64753[(11)]);
var inst_64655 = (state_64753[(9)]);
var inst_64657 = (state_64753[(12)]);
var inst_64679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64680 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64681 = [inst_64656,inst_64655,inst_64657,inst_64658];
var inst_64682 = (new cljs.core.PersistentVector(null,4,(5),inst_64680,inst_64681,null));
var inst_64683 = [inst_64682,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_64684 = (new cljs.core.PersistentVector(null,2,(5),inst_64679,inst_64683,null));
var state_64753__$1 = state_64753;
var statearr_64770_64857 = state_64753__$1;
(statearr_64770_64857[(2)] = inst_64684);

(statearr_64770_64857[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (46))){
var inst_64689 = (state_64753[(20)]);
var state_64753__$1 = state_64753;
var statearr_64771_64858 = state_64753__$1;
(statearr_64771_64858[(2)] = inst_64689);

(statearr_64771_64858[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (4))){
var state_64753__$1 = state_64753;
var statearr_64772_64859 = state_64753__$1;
(statearr_64772_64859[(2)] = null);

(statearr_64772_64859[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (54))){
var inst_64570 = (state_64753[(21)]);
var inst_64731 = (state_64753[(15)]);
var inst_64730 = (state_64753[(2)]);
var inst_64731__$1 = fluree.db.util.async.throw_err(inst_64730);
var inst_64732 = fluree.db.api_js.format_history_resp(inst_64570,inst_64731__$1);
var state_64753__$1 = (function (){var statearr_64773 = state_64753;
(statearr_64773[(15)] = inst_64731__$1);

return statearr_64773;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(55),inst_64732);
} else {
if((state_val_64754 === (15))){
var inst_64570 = (state_64753[(21)]);
var inst_64611 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64570);
var state_64753__$1 = state_64753;
var statearr_64774_64860 = state_64753__$1;
(statearr_64774_64860[(2)] = inst_64611);

(statearr_64774_64860[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (48))){
var inst_64656 = (state_64753[(10)]);
var inst_64658 = (state_64753[(11)]);
var inst_64655 = (state_64753[(9)]);
var inst_64657 = (state_64753[(12)]);
var inst_64700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64702 = [inst_64656,inst_64657,inst_64655,inst_64658];
var inst_64703 = (new cljs.core.PersistentVector(null,4,(5),inst_64701,inst_64702,null));
var inst_64704 = [inst_64703,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_64705 = (new cljs.core.PersistentVector(null,2,(5),inst_64700,inst_64704,null));
var state_64753__$1 = state_64753;
var statearr_64775_64861 = state_64753__$1;
(statearr_64775_64861[(2)] = inst_64705);

(statearr_64775_64861[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (50))){
var inst_64718 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64776_64862 = state_64753__$1;
(statearr_64776_64862[(2)] = inst_64718);

(statearr_64776_64862[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (21))){
var inst_64566 = (state_64753[(16)]);
var inst_64622 = cljs.core.empty_QMARK_(inst_64566);
var state_64753__$1 = state_64753;
if(inst_64622){
var statearr_64777_64863 = state_64753__$1;
(statearr_64777_64863[(1)] = (24));

} else {
var statearr_64778_64864 = state_64753__$1;
(statearr_64778_64864[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (31))){
var inst_64655 = (state_64753[(9)]);
var inst_64666 = (state_64753[(22)]);
var inst_64666__$1 = (inst_64655 == null);
var state_64753__$1 = (function (){var statearr_64779 = state_64753;
(statearr_64779[(22)] = inst_64666__$1);

return statearr_64779;
})();
if(cljs.core.truth_(inst_64666__$1)){
var statearr_64780_64865 = state_64753__$1;
(statearr_64780_64865[(1)] = (33));

} else {
var statearr_64781_64866 = state_64753__$1;
(statearr_64781_64866[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (32))){
var inst_64613 = (state_64753[(23)]);
var inst_64603 = (state_64753[(24)]);
var inst_64570 = (state_64753[(21)]);
var inst_64722 = (state_64753[(2)]);
var inst_64723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64722,(0),null);
var inst_64724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64722,(1),null);
var inst_64725 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_64726 = [inst_64603,inst_64613];
var inst_64727 = cljs.core.PersistentHashMap.fromArrays(inst_64725,inst_64726);
var inst_64728 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_64570,inst_64724,cljs.core._EQ_,inst_64723,inst_64727);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(54),inst_64728);
} else {
if((state_val_64754 === (40))){
var inst_64655 = (state_64753[(9)]);
var inst_64686 = (state_64753[(25)]);
var inst_64686__$1 = (inst_64655 == null);
var state_64753__$1 = (function (){var statearr_64782 = state_64753;
(statearr_64782[(25)] = inst_64686__$1);

return statearr_64782;
})();
if(cljs.core.truth_(inst_64686__$1)){
var statearr_64783_64867 = state_64753__$1;
(statearr_64783_64867[(1)] = (42));

} else {
var statearr_64784_64868 = state_64753__$1;
(statearr_64784_64868[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (56))){
var inst_64570 = (state_64753[(21)]);
var inst_64735 = (state_64753[(19)]);
var inst_64737 = fluree.db.api_js.format_block_resp_pretty(inst_64570,inst_64735);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(59),inst_64737);
} else {
if((state_val_64754 === (33))){
var inst_64656 = (state_64753[(10)]);
var inst_64669 = (state_64753[(26)]);
var inst_64668 = (inst_64656 == null);
var inst_64669__$1 = cljs.core.not(inst_64668);
var state_64753__$1 = (function (){var statearr_64785 = state_64753;
(statearr_64785[(26)] = inst_64669__$1);

return statearr_64785;
})();
if(inst_64669__$1){
var statearr_64786_64869 = state_64753__$1;
(statearr_64786_64869[(1)] = (36));

} else {
var statearr_64787_64870 = state_64753__$1;
(statearr_64787_64870[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (13))){
var inst_64597 = (state_64753[(2)]);
var inst_64598 = fluree.db.util.async.throw_err(inst_64597);
var inst_64599 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64598);
var inst_64600 = (inst_64599 - (1));
var state_64753__$1 = state_64753;
var statearr_64788_64871 = state_64753__$1;
(statearr_64788_64871[(2)] = inst_64600);

(statearr_64788_64871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (22))){
var state_64753__$1 = state_64753;
var statearr_64789_64872 = state_64753__$1;
(statearr_64789_64872[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (36))){
var inst_64657 = (state_64753[(12)]);
var inst_64671 = (inst_64657 == null);
var state_64753__$1 = state_64753;
var statearr_64791_64873 = state_64753__$1;
(statearr_64791_64873[(2)] = inst_64671);

(statearr_64791_64873[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (41))){
var inst_64720 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64792_64874 = state_64753__$1;
(statearr_64792_64874[(2)] = inst_64720);

(statearr_64792_64874[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (43))){
var inst_64686 = (state_64753[(25)]);
var state_64753__$1 = state_64753;
var statearr_64793_64875 = state_64753__$1;
(statearr_64793_64875[(2)] = inst_64686);

(statearr_64793_64875[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (61))){
var inst_64743 = (state_64753[(14)]);
var state_64753__$1 = state_64753;
var statearr_64794_64876 = state_64753__$1;
(statearr_64794_64876[(2)] = inst_64743);

(statearr_64794_64876[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (29))){
var inst_64643 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64795_64877 = state_64753__$1;
(statearr_64795_64877[(2)] = inst_64643);

(statearr_64795_64877[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (44))){
var inst_64698 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
if(cljs.core.truth_(inst_64698)){
var statearr_64796_64878 = state_64753__$1;
(statearr_64796_64878[(1)] = (48));

} else {
var statearr_64797_64879 = state_64753__$1;
(statearr_64797_64879[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (6))){
var inst_64574 = (state_64753[(2)]);
var inst_64575 = fluree.db.util.async.throw_err(inst_64574);
var state_64753__$1 = state_64753;
var statearr_64798_64880 = state_64753__$1;
(statearr_64798_64880[(2)] = inst_64575);

(statearr_64798_64880[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (28))){
var state_64753__$1 = state_64753;
var statearr_64799_64881 = state_64753__$1;
(statearr_64799_64881[(2)] = null);

(statearr_64799_64881[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (51))){
var inst_64566 = (state_64753[(16)]);
var inst_64708 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_64566)].join('');
var inst_64709 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64710 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64711 = cljs.core.PersistentHashMap.fromArrays(inst_64709,inst_64710);
var inst_64712 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64708,inst_64711);
var inst_64713 = (function(){throw inst_64712})();
var state_64753__$1 = state_64753;
var statearr_64800_64882 = state_64753__$1;
(statearr_64800_64882[(2)] = inst_64713);

(statearr_64800_64882[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (25))){
var inst_64566 = (state_64753[(16)]);
var state_64753__$1 = state_64753;
var statearr_64801_64883 = state_64753__$1;
(statearr_64801_64883[(2)] = inst_64566);

(statearr_64801_64883[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (34))){
var inst_64666 = (state_64753[(22)]);
var state_64753__$1 = state_64753;
var statearr_64802_64884 = state_64753__$1;
(statearr_64802_64884[(2)] = inst_64666);

(statearr_64802_64884[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (17))){
var inst_64607 = (state_64753[(2)]);
var inst_64608 = fluree.db.util.async.throw_err(inst_64607);
var inst_64609 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_64608);
var state_64753__$1 = state_64753;
var statearr_64803_64885 = state_64753__$1;
(statearr_64803_64885[(2)] = inst_64609);

(statearr_64803_64885[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (3))){
var inst_64570 = (state_64753[(21)]);
var inst_64572 = fluree.db.api_js.resolve_block_range(inst_64570,query_map);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(6),inst_64572);
} else {
if((state_val_64754 === (12))){
var inst_64580 = (state_64753[(27)]);
var inst_64603 = (state_64753[(2)]);
var state_64753__$1 = (function (){var statearr_64804 = state_64753;
(statearr_64804[(24)] = inst_64603);

return statearr_64804;
})();
if(cljs.core.truth_(inst_64580)){
var statearr_64805_64886 = state_64753__$1;
(statearr_64805_64886[(1)] = (14));

} else {
var statearr_64806_64887 = state_64753__$1;
(statearr_64806_64887[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (2))){
var inst_64565 = (state_64753[(17)]);
var inst_64569 = (state_64753[(2)]);
var inst_64570 = fluree.db.util.async.throw_err(inst_64569);
var state_64753__$1 = (function (){var statearr_64807 = state_64753;
(statearr_64807[(21)] = inst_64570);

return statearr_64807;
})();
if(cljs.core.truth_(inst_64565)){
var statearr_64808_64888 = state_64753__$1;
(statearr_64808_64888[(1)] = (3));

} else {
var statearr_64809_64889 = state_64753__$1;
(statearr_64809_64889[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (23))){
var inst_64645 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64810_64890 = state_64753__$1;
(statearr_64810_64890[(2)] = inst_64645);

(statearr_64810_64890[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (47))){
var inst_64695 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64811_64891 = state_64753__$1;
(statearr_64811_64891[(2)] = inst_64695);

(statearr_64811_64891[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (35))){
var inst_64677 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
if(cljs.core.truth_(inst_64677)){
var statearr_64812_64892 = state_64753__$1;
(statearr_64812_64892[(1)] = (39));

} else {
var statearr_64813_64893 = state_64753__$1;
(statearr_64813_64893[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (19))){
var inst_64566 = (state_64753[(16)]);
var inst_64620 = cljs.core.sequential_QMARK_(inst_64566);
var state_64753__$1 = state_64753;
if(inst_64620){
var statearr_64814_64894 = state_64753__$1;
(statearr_64814_64894[(1)] = (21));

} else {
var statearr_64815_64895 = state_64753__$1;
(statearr_64815_64895[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (57))){
var inst_64735 = (state_64753[(19)]);
var state_64753__$1 = state_64753;
var statearr_64816_64896 = state_64753__$1;
(statearr_64816_64896[(2)] = inst_64735);

(statearr_64816_64896[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (11))){
var state_64753__$1 = state_64753;
var statearr_64817_64897 = state_64753__$1;
(statearr_64817_64897[(2)] = (-1));

(statearr_64817_64897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (9))){
var inst_64592 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
if(cljs.core.truth_(inst_64592)){
var statearr_64818_64898 = state_64753__$1;
(statearr_64818_64898[(1)] = (10));

} else {
var statearr_64819_64899 = state_64753__$1;
(statearr_64819_64899[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (5))){
var inst_64579 = (state_64753[(7)]);
var inst_64578 = (state_64753[(2)]);
var inst_64579__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64578,(0),null);
var inst_64580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64578,(1),null);
var inst_64587 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_64753__$1 = (function (){var statearr_64820 = state_64753;
(statearr_64820[(27)] = inst_64580);

(statearr_64820[(13)] = inst_64587);

(statearr_64820[(7)] = inst_64579__$1);

return statearr_64820;
})();
if(cljs.core.truth_(inst_64579__$1)){
var statearr_64821_64900 = state_64753__$1;
(statearr_64821_64900[(1)] = (7));

} else {
var statearr_64822_64901 = state_64753__$1;
(statearr_64822_64901[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (14))){
var inst_64580 = (state_64753[(27)]);
var inst_64570 = (state_64753[(21)]);
var inst_64605 = fluree.db.time_travel.as_of_block(inst_64570,inst_64580);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(17),inst_64605);
} else {
if((state_val_64754 === (45))){
var inst_64657 = (state_64753[(12)]);
var inst_64691 = (inst_64657 == null);
var inst_64692 = cljs.core.not(inst_64691);
var state_64753__$1 = state_64753;
var statearr_64823_64902 = state_64753__$1;
(statearr_64823_64902[(2)] = inst_64692);

(statearr_64823_64902[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (53))){
var inst_64716 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64824_64903 = state_64753__$1;
(statearr_64824_64903[(2)] = inst_64716);

(statearr_64824_64903[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (26))){
var inst_64632 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64825_64904 = state_64753__$1;
(statearr_64825_64904[(2)] = inst_64632);

(statearr_64825_64904[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (16))){
var inst_64566 = (state_64753[(16)]);
var inst_64613 = (state_64753[(2)]);
var inst_64614 = fluree.db.util.core.subj_ident_QMARK_(inst_64566);
var state_64753__$1 = (function (){var statearr_64826 = state_64753;
(statearr_64826[(23)] = inst_64613);

return statearr_64826;
})();
if(inst_64614){
var statearr_64827_64905 = state_64753__$1;
(statearr_64827_64905[(1)] = (18));

} else {
var statearr_64828_64906 = state_64753__$1;
(statearr_64828_64906[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (38))){
var inst_64674 = (state_64753[(2)]);
var state_64753__$1 = state_64753;
var statearr_64829_64907 = state_64753__$1;
(statearr_64829_64907[(2)] = inst_64674);

(statearr_64829_64907[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (30))){
var inst_64647 = (state_64753[(8)]);
var inst_64662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64663 = [inst_64647,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_64664 = (new cljs.core.PersistentVector(null,2,(5),inst_64662,inst_64663,null));
var state_64753__$1 = state_64753;
var statearr_64830_64908 = state_64753__$1;
(statearr_64830_64908[(2)] = inst_64664);

(statearr_64830_64908[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (10))){
var inst_64570 = (state_64753[(21)]);
var inst_64579 = (state_64753[(7)]);
var inst_64594 = (inst_64579 - (1));
var inst_64595 = fluree.db.time_travel.as_of_block(inst_64570,inst_64594);
var state_64753__$1 = state_64753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64753__$1,(13),inst_64595);
} else {
if((state_val_64754 === (18))){
var inst_64566 = (state_64753[(16)]);
var inst_64616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64617 = [inst_64566];
var inst_64618 = (new cljs.core.PersistentVector(null,1,(5),inst_64616,inst_64617,null));
var state_64753__$1 = state_64753;
var statearr_64831_64909 = state_64753__$1;
(statearr_64831_64909[(2)] = inst_64618);

(statearr_64831_64909[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (52))){
var state_64753__$1 = state_64753;
var statearr_64832_64910 = state_64753__$1;
(statearr_64832_64910[(2)] = null);

(statearr_64832_64910[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (42))){
var inst_64656 = (state_64753[(10)]);
var inst_64689 = (state_64753[(20)]);
var inst_64688 = (inst_64656 == null);
var inst_64689__$1 = cljs.core.not(inst_64688);
var state_64753__$1 = (function (){var statearr_64833 = state_64753;
(statearr_64833[(20)] = inst_64689__$1);

return statearr_64833;
})();
if(inst_64689__$1){
var statearr_64834_64911 = state_64753__$1;
(statearr_64834_64911[(1)] = (45));

} else {
var statearr_64835_64912 = state_64753__$1;
(statearr_64835_64912[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (37))){
var inst_64669 = (state_64753[(26)]);
var state_64753__$1 = state_64753;
var statearr_64836_64913 = state_64753__$1;
(statearr_64836_64913[(2)] = inst_64669);

(statearr_64836_64913[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (8))){
var inst_64579 = (state_64753[(7)]);
var state_64753__$1 = state_64753;
var statearr_64837_64914 = state_64753__$1;
(statearr_64837_64914[(2)] = inst_64579);

(statearr_64837_64914[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64754 === (49))){
var state_64753__$1 = state_64753;
var statearr_64838_64915 = state_64753__$1;
(statearr_64838_64915[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_64840 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64840[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_64840[(1)] = (1));

return statearr_64840;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64753){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_64753);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e64841){var ex__2744__auto__ = e64841;
var statearr_64842_64916 = state_64753;
(statearr_64842_64916[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_64753[(4)]))){
var statearr_64843_64917 = state_64753;
(statearr_64843_64917[(1)] = cljs.core.first((state_64753[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64918 = state_64753;
state_64753 = G__64918;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64753){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_64844 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_64844[(6)] = c__2763__auto__);

return statearr_64844;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__64926 = arguments.length;
switch (G__64926) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5753__auto__)){
var block = temp__5753__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4251__auto__ = block;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4251__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__64919_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__64919_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65015){
var state_val_65016 = (state_65015[(1)]);
if((state_val_65016 === (7))){
var inst_64966 = (state_65015[(7)]);
var inst_64969 = (state_65015[(8)]);
var inst_64972 = (state_65015[(9)]);
var inst_64976 = (state_65015[(10)]);
var inst_64982 = (function (){var responses = inst_64966;
var responses_STAR_ = inst_64969;
var statuses = inst_64972;
var fuel = inst_64976;
return (function (p1__64922_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__64922_SHARP_);
});
})();
var inst_64983 = cljs.core.some(inst_64982,inst_64972);
var state_65015__$1 = state_65015;
if(cljs.core.truth_(inst_64983)){
var statearr_65017_65065 = state_65015__$1;
(statearr_65017_65065[(1)] = (9));

} else {
var statearr_65018_65066 = state_65015__$1;
(statearr_65018_65066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (20))){
var inst_65010 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
var statearr_65019_65067 = state_65015__$1;
(statearr_65019_65067[(2)] = inst_65010);

(statearr_65019_65067[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (1))){
var inst_64961 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_64962 = (function (){var c__2763__auto____$1 = inst_64961;
return (function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_64959){
var state_val_64960 = (state_64959[(1)]);
if((state_val_64960 === (1))){
var inst_64927 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_64928 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_64929 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64928,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_64930 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_64931 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_64932 = cljs.core.PersistentHashMap.EMPTY;
var inst_64933 = inst_64927;
var inst_64934 = inst_64929;
var inst_64935 = inst_64930;
var inst_64936 = inst_64931;
var inst_64937 = inst_64932;
var state_64959__$1 = (function (){var statearr_65020 = state_64959;
(statearr_65020[(7)] = inst_64933);

(statearr_65020[(8)] = inst_64934);

(statearr_65020[(9)] = inst_64937);

(statearr_65020[(10)] = inst_64935);

(statearr_65020[(11)] = inst_64936);

return statearr_65020;
})();
var statearr_65021_65068 = state_64959__$1;
(statearr_65021_65068[(2)] = null);

(statearr_65021_65068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (2))){
var inst_64934 = (state_64959[(8)]);
var inst_64939 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_64934);
var inst_64940 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_64939], 0));
var inst_64941 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64934,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64940);
var inst_64942 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_64941,db_fn);
var state_64959__$1 = state_64959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64959__$1,(4),inst_64942);
} else {
if((state_val_64960 === (3))){
var inst_64957 = (state_64959[(2)]);
var state_64959__$1 = state_64959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64959__$1,inst_64957);
} else {
if((state_val_64960 === (4))){
var inst_64933 = (state_64959[(7)]);
var inst_64937 = (state_64959[(9)]);
var inst_64935 = (state_64959[(10)]);
var inst_64944 = (state_64959[(2)]);
var inst_64945 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64937,inst_64933,inst_64944);
var inst_64946 = cljs.core.first(inst_64935);
var state_64959__$1 = (function (){var statearr_65022 = state_64959;
(statearr_65022[(12)] = inst_64945);

return statearr_65022;
})();
if(cljs.core.truth_(inst_64946)){
var statearr_65023_65069 = state_64959__$1;
(statearr_65023_65069[(1)] = (5));

} else {
var statearr_65024_65070 = state_64959__$1;
(statearr_65024_65070[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (5))){
var inst_64935 = (state_64959[(10)]);
var inst_64945 = (state_64959[(12)]);
var inst_64936 = (state_64959[(11)]);
var inst_64948 = cljs.core.first(inst_64935);
var inst_64949 = cljs.core.first(inst_64936);
var inst_64950 = cljs.core.rest(inst_64935);
var inst_64951 = cljs.core.rest(inst_64936);
var inst_64933 = inst_64948;
var inst_64934 = inst_64949;
var inst_64935__$1 = inst_64950;
var inst_64936__$1 = inst_64951;
var inst_64937 = inst_64945;
var state_64959__$1 = (function (){var statearr_65025 = state_64959;
(statearr_65025[(7)] = inst_64933);

(statearr_65025[(8)] = inst_64934);

(statearr_65025[(9)] = inst_64937);

(statearr_65025[(10)] = inst_64935__$1);

(statearr_65025[(11)] = inst_64936__$1);

return statearr_65025;
})();
var statearr_65026_65071 = state_64959__$1;
(statearr_65026_65071[(2)] = null);

(statearr_65026_65071[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (6))){
var inst_64945 = (state_64959[(12)]);
var state_64959__$1 = state_64959;
var statearr_65027_65072 = state_64959__$1;
(statearr_65027_65072[(2)] = inst_64945);

(statearr_65027_65072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64960 === (7))){
var inst_64955 = (state_64959[(2)]);
var state_64959__$1 = state_64959;
var statearr_65028_65073 = state_64959__$1;
(statearr_65028_65073[(2)] = inst_64955);

(statearr_65028_65073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_65029 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65029[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_65029[(1)] = (1));

return statearr_65029;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_64959){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_64959);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65030){var ex__2744__auto__ = e65030;
var statearr_65031_65074 = state_64959;
(statearr_65031_65074[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_64959[(4)]))){
var statearr_65032_65075 = state_64959;
(statearr_65032_65075[(1)] = cljs.core.first((state_64959[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65076 = state_64959;
state_64959 = G__65076;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_64959){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_64959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65033 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65033[(6)] = c__2763__auto____$1);

return statearr_65033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
});
})();
var inst_64963 = cljs.core.async.impl.dispatch.run(inst_64962);
var state_65015__$1 = (function (){var statearr_65034 = state_65015;
(statearr_65034[(11)] = inst_64963);

return statearr_65034;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65015__$1,(2),inst_64961);
} else {
if((state_val_65016 === (4))){
var inst_64966 = (state_65015[(7)]);
var state_65015__$1 = state_65015;
var statearr_65035_65077 = state_65015__$1;
(statearr_65035_65077[(2)] = inst_64966);

(statearr_65035_65077[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (15))){
var state_65015__$1 = state_65015;
var statearr_65036_65078 = state_65015__$1;
(statearr_65036_65078[(2)] = (400));

(statearr_65036_65078[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (13))){
var state_65015__$1 = state_65015;
var statearr_65037_65079 = state_65015__$1;
(statearr_65037_65079[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (6))){
var inst_64972 = (state_65015[(9)]);
var inst_64980 = cljs.core.first(inst_64972);
var state_65015__$1 = state_65015;
var statearr_65039_65080 = state_65015__$1;
(statearr_65039_65080[(2)] = inst_64980);

(statearr_65039_65080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (17))){
var inst_64993 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
var statearr_65040_65081 = state_65015__$1;
(statearr_65040_65081[(2)] = inst_64993);

(statearr_65040_65081[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (3))){
var inst_64966 = (state_65015[(7)]);
var inst_64969 = (state_65015[(8)]);
var inst_64972 = (state_65015[(9)]);
var inst_64976 = (state_65015[(10)]);
var inst_64971 = cljs.core.vals(inst_64966);
var inst_64972__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_64971);
var inst_64973 = (function (){var responses = inst_64966;
var responses_STAR_ = inst_64969;
var statuses = inst_64972__$1;
return (function (p1__64920_SHARP_){
var or__4253__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__64920_SHARP_);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (0);
}
});
})();
var inst_64974 = cljs.core.vals(inst_64966);
var inst_64975 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_64973,inst_64974);
var inst_64976__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_64975);
var inst_64977 = (function (){var responses = inst_64966;
var responses_STAR_ = inst_64969;
var statuses = inst_64972__$1;
var fuel = inst_64976__$1;
return (function (p1__64921_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__64921_SHARP_);
});
})();
var inst_64978 = cljs.core.every_QMARK_(inst_64977,inst_64972__$1);
var state_65015__$1 = (function (){var statearr_65041 = state_65015;
(statearr_65041[(9)] = inst_64972__$1);

(statearr_65041[(10)] = inst_64976__$1);

return statearr_65041;
})();
if(inst_64978){
var statearr_65042_65082 = state_65015__$1;
(statearr_65042_65082[(1)] = (6));

} else {
var statearr_65043_65083 = state_65015__$1;
(statearr_65043_65083[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (12))){
var state_65015__$1 = state_65015;
var statearr_65044_65084 = state_65015__$1;
(statearr_65044_65084[(2)] = (500));

(statearr_65044_65084[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (2))){
var inst_64966 = (state_65015[(7)]);
var inst_64965 = (state_65015[(2)]);
var inst_64966__$1 = fluree.db.util.async.throw_err(inst_64965);
var inst_64967 = (function (){var responses = inst_64966__$1;
return (function (acc,index,response){
var resp = (function (){var or__4253__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_64968 = cljs.core.PersistentHashMap.EMPTY;
var inst_64969 = cljs.core.reduce_kv(inst_64967,inst_64968,inst_64966__$1);
var state_65015__$1 = (function (){var statearr_65045 = state_65015;
(statearr_65045[(7)] = inst_64966__$1);

(statearr_65045[(8)] = inst_64969);

return statearr_65045;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_65046_65085 = state_65015__$1;
(statearr_65046_65085[(1)] = (3));

} else {
var statearr_65047_65086 = state_65015__$1;
(statearr_65047_65086[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (19))){
var inst_64999 = (state_65015[(12)]);
var inst_64969 = (state_65015[(8)]);
var inst_64976 = (state_65015[(10)]);
var inst_65008 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64969,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64999,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64976], 0));
var state_65015__$1 = state_65015;
var statearr_65048_65087 = state_65015__$1;
(statearr_65048_65087[(2)] = inst_65008);

(statearr_65048_65087[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (11))){
var inst_64997 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
var statearr_65049_65088 = state_65015__$1;
(statearr_65049_65088[(2)] = inst_64997);

(statearr_65049_65088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (9))){
var state_65015__$1 = state_65015;
var statearr_65050_65089 = state_65015__$1;
(statearr_65050_65089[(2)] = (207));

(statearr_65050_65089[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (5))){
var inst_65013 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65015__$1,inst_65013);
} else {
if((state_val_65016 === (14))){
var inst_64995 = (state_65015[(2)]);
var state_65015__$1 = state_65015;
var statearr_65051_65090 = state_65015__$1;
(statearr_65051_65090[(2)] = inst_64995);

(statearr_65051_65090[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (16))){
var state_65015__$1 = state_65015;
var statearr_65052_65091 = state_65015__$1;
(statearr_65052_65091[(2)] = null);

(statearr_65052_65091[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (10))){
var inst_64966 = (state_65015[(7)]);
var inst_64969 = (state_65015[(8)]);
var inst_64972 = (state_65015[(9)]);
var inst_64976 = (state_65015[(10)]);
var inst_64986 = (function (){var responses = inst_64966;
var responses_STAR_ = inst_64969;
var statuses = inst_64972;
var fuel = inst_64976;
return (function (p1__64923_SHARP_){
return ((499) < p1__64923_SHARP_);
});
})();
var inst_64987 = cljs.core.some(inst_64986,inst_64972);
var state_65015__$1 = state_65015;
if(cljs.core.truth_(inst_64987)){
var statearr_65053_65092 = state_65015__$1;
(statearr_65053_65092[(1)] = (12));

} else {
var statearr_65054_65093 = state_65015__$1;
(statearr_65054_65093[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (18))){
var inst_64999 = (state_65015[(12)]);
var inst_65004 = (state_65015[(13)]);
var inst_64969 = (state_65015[(8)]);
var inst_64976 = (state_65015[(10)]);
var inst_65006 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64969,new cljs.core.Keyword(null,"status","status",-1997798413),inst_64999,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64976,new cljs.core.Keyword(null,"block","block",664686210),inst_65004], 0));
var state_65015__$1 = state_65015;
var statearr_65055_65094 = state_65015__$1;
(statearr_65055_65094[(2)] = inst_65006);

(statearr_65055_65094[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65016 === (8))){
var inst_64999 = (state_65015[(12)]);
var inst_64966 = (state_65015[(7)]);
var inst_65004 = (state_65015[(13)]);
var inst_64969 = (state_65015[(8)]);
var inst_64972 = (state_65015[(9)]);
var inst_64976 = (state_65015[(10)]);
var inst_64999__$1 = (state_65015[(2)]);
var inst_65000 = (function (){var responses = inst_64966;
var responses_STAR_ = inst_64969;
var statuses = inst_64972;
var fuel = inst_64976;
var status = inst_64999__$1;
return (function (p1__64924_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__64924_SHARP_));
});
})();
var inst_65001 = cljs.core.vals(inst_64966);
var inst_65002 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65000,inst_65001);
var inst_65003 = cljs.core.first(inst_65002);
var inst_65004__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65003);
var state_65015__$1 = (function (){var statearr_65056 = state_65015;
(statearr_65056[(12)] = inst_64999__$1);

(statearr_65056[(13)] = inst_65004__$1);

return statearr_65056;
})();
if(cljs.core.truth_(inst_65004__$1)){
var statearr_65057_65095 = state_65015__$1;
(statearr_65057_65095[(1)] = (18));

} else {
var statearr_65058_65096 = state_65015__$1;
(statearr_65058_65096[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_65059 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65059[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_65059[(1)] = (1));

return statearr_65059;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_65015){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65015);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65060){var ex__2744__auto__ = e65060;
var statearr_65061_65097 = state_65015;
(statearr_65061_65097[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65015[(4)]))){
var statearr_65062_65098 = state_65015;
(statearr_65062_65098[(1)] = cljs.core.first((state_65015[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65099 = state_65015;
state_65015 = G__65099;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_65015){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_65015);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65063 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65063[(6)] = c__2763__auto__);

return statearr_65063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__65101 = arguments.length;
switch (G__65101) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__65102 = opts;
var map__65102__$1 = cljs.core.__destructure_map(map__65102);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65102__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65102__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65102__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65102__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__65103 = (cljs.core.truth_((function (){var and__4251__auto__ = auth;
if(cljs.core.truth_(and__4251__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4251__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65103,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65103,(1),null);
var action__$1 = (function (){var or__4253__auto__ = action;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4253__auto__ = nonce;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4253__auto__ = expire;
if(cljs.core.truth_(or__4253__auto__)){
return or__4253__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e65106){var e = e65106;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__65109 = arguments.length;
switch (G__65109) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65140){
var state_val_65141 = (state_65140[(1)]);
if((state_val_65141 === (7))){
var state_65140__$1 = state_65140;
var statearr_65142_65163 = state_65140__$1;
(statearr_65142_65163[(2)] = opts);

(statearr_65142_65163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (1))){
var state_65140__$1 = state_65140;
var statearr_65143_65164 = state_65140__$1;
(statearr_65143_65164[(2)] = null);

(statearr_65143_65164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (4))){
var inst_65110 = (state_65140[(2)]);
var inst_65111 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65110], 0));
var inst_65112 = cljs.core.ex_data(inst_65110);
var inst_65113 = cljs.core.ex_message(inst_65110);
var inst_65114 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65112,new cljs.core.Keyword(null,"message","message",-406056002),inst_65113);
var state_65140__$1 = (function (){var statearr_65144 = state_65140;
(statearr_65144[(7)] = inst_65111);

return statearr_65144;
})();
var statearr_65145_65165 = state_65140__$1;
(statearr_65145_65165[(2)] = inst_65114);

(statearr_65145_65165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (6))){
var inst_65124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65125 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_65126 = (new cljs.core.PersistentVector(null,1,(5),inst_65124,inst_65125,null));
var inst_65127 = cljs.core.assoc_in(opts,inst_65126,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65140__$1 = state_65140;
var statearr_65146_65166 = state_65140__$1;
(statearr_65146_65166[(2)] = inst_65127);

(statearr_65146_65166[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (3))){
var inst_65138 = (state_65140[(2)]);
var state_65140__$1 = state_65140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65140__$1,inst_65138);
} else {
if((state_val_65141 === (2))){
var _ = (function (){var statearr_65148 = state_65140;
(statearr_65148[(4)] = cljs.core.cons((5),(state_65140[(4)])));

return statearr_65148;
})();
var inst_65120 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65121 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65122 = (inst_65121 == null);
var state_65140__$1 = (function (){var statearr_65149 = state_65140;
(statearr_65149[(8)] = inst_65120);

return statearr_65149;
})();
if(cljs.core.truth_(inst_65122)){
var statearr_65150_65167 = state_65140__$1;
(statearr_65150_65167[(1)] = (6));

} else {
var statearr_65151_65168 = state_65140__$1;
(statearr_65151_65168[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (9))){
var inst_65134 = (state_65140[(2)]);
var inst_65135 = fluree.db.util.async.throw_err(inst_65134);
var _ = (function (){var statearr_65152 = state_65140;
(statearr_65152[(4)] = cljs.core.rest((state_65140[(4)])));

return statearr_65152;
})();
var state_65140__$1 = state_65140;
var statearr_65153_65169 = state_65140__$1;
(statearr_65153_65169[(2)] = inst_65135);

(statearr_65153_65169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (5))){
var _ = (function (){var statearr_65154 = state_65140;
(statearr_65154[(4)] = cljs.core.rest((state_65140[(4)])));

return statearr_65154;
})();
var state_65140__$1 = state_65140;
var ex65147 = (state_65140__$1[(2)]);
var statearr_65155_65170 = state_65140__$1;
(statearr_65155_65170[(5)] = ex65147);


var statearr_65156_65171 = state_65140__$1;
(statearr_65156_65171[(1)] = (4));

(statearr_65156_65171[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65141 === (8))){
var inst_65120 = (state_65140[(8)]);
var inst_65130 = (state_65140[(2)]);
var inst_65131 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_65120,inst_65130);
var inst_65132 = fluree.db.operations.command_async(conn,inst_65131);
var state_65140__$1 = state_65140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65140__$1,(9),inst_65132);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2741__auto__ = null;
var fluree$db$api_js$state_machine__2741__auto____0 = (function (){
var statearr_65157 = [null,null,null,null,null,null,null,null,null];
(statearr_65157[(0)] = fluree$db$api_js$state_machine__2741__auto__);

(statearr_65157[(1)] = (1));

return statearr_65157;
});
var fluree$db$api_js$state_machine__2741__auto____1 = (function (state_65140){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65140);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65158){var ex__2744__auto__ = e65158;
var statearr_65159_65172 = state_65140;
(statearr_65159_65172[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65140[(4)]))){
var statearr_65160_65173 = state_65140;
(statearr_65160_65173[(1)] = cljs.core.first((state_65140[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65174 = state_65140;
state_65140 = G__65174;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2741__auto__ = function(state_65140){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2741__auto____1.call(this,state_65140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2741__auto____0;
fluree$db$api_js$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2741__auto____1;
return fluree$db$api_js$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65161 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65161[(6)] = c__2763__auto__);

return statearr_65161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

