// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__65178 = arguments.length;
switch (G__65178) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2763__auto___65217 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65199){
var state_val_65200 = (state_65199[(1)]);
if((state_val_65200 === (1))){
var state_65199__$1 = state_65199;
var statearr_65201_65218 = state_65199__$1;
(statearr_65201_65218[(2)] = null);

(statearr_65201_65218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65200 === (2))){
var _ = (function (){var statearr_65202 = state_65199;
(statearr_65202[(4)] = cljs.core.cons((5),(state_65199[(4)])));

return statearr_65202;
})();
var inst_65185 = fluree.db.session.db(conn,ledger,null);
var state_65199__$1 = state_65199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65199__$1,(7),inst_65185);
} else {
if((state_val_65200 === (3))){
var inst_65195 = (state_65199[(2)]);
var inst_65196 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65195);
var inst_65197 = cljs.core.async.close_BANG_(pc);
var state_65199__$1 = (function (){var statearr_65204 = state_65199;
(statearr_65204[(7)] = inst_65196);

return statearr_65204;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65199__$1,inst_65197);
} else {
if((state_val_65200 === (4))){
var inst_65179 = (state_65199[(2)]);
var state_65199__$1 = state_65199;
var statearr_65205_65219 = state_65199__$1;
(statearr_65205_65219[(2)] = inst_65179);

(statearr_65205_65219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65200 === (5))){
var _ = (function (){var statearr_65206 = state_65199;
(statearr_65206[(4)] = cljs.core.rest((state_65199[(4)])));

return statearr_65206;
})();
var state_65199__$1 = state_65199;
var ex65203 = (state_65199__$1[(2)]);
var statearr_65207_65220 = state_65199__$1;
(statearr_65207_65220[(5)] = ex65203);


var statearr_65208_65221 = state_65199__$1;
(statearr_65208_65221[(1)] = (4));

(statearr_65208_65221[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65200 === (6))){
var inst_65191 = (state_65199[(2)]);
var inst_65192 = fluree.db.util.async.throw_err(inst_65191);
var _ = (function (){var statearr_65209 = state_65199;
(statearr_65209[(4)] = cljs.core.rest((state_65199[(4)])));

return statearr_65209;
})();
var state_65199__$1 = state_65199;
var statearr_65210_65222 = state_65199__$1;
(statearr_65210_65222[(2)] = inst_65192);

(statearr_65210_65222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65200 === (7))){
var inst_65187 = (state_65199[(2)]);
var inst_65188 = fluree.db.util.async.throw_err(inst_65187);
var inst_65189 = fluree.db.time_travel.as_of_block(inst_65188,block);
var state_65199__$1 = state_65199;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65199__$1,(6),inst_65189);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_65211 = [null,null,null,null,null,null,null,null];
(statearr_65211[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_65211[(1)] = (1));

return statearr_65211;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_65199){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65199);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65212){var ex__2744__auto__ = e65212;
var statearr_65213_65223 = state_65199;
(statearr_65213_65223[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65199[(4)]))){
var statearr_65214_65224 = state_65199;
(statearr_65214_65224[(1)] = cljs.core.first((state_65199[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65225 = state_65199;
state_65199 = G__65225;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_65199){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_65199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65215 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65215[(6)] = c__2763__auto___65217);

return statearr_65215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65266){
var state_val_65267 = (state_65266[(1)]);
if((state_val_65267 === (7))){
var inst_65235 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_65266__$1 = state_65266;
if(inst_65235){
var statearr_65268_65299 = state_65266__$1;
(statearr_65268_65299[(1)] = (9));

} else {
var statearr_65269_65300 = state_65266__$1;
(statearr_65269_65300[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (1))){
var state_65266__$1 = state_65266;
var statearr_65270_65301 = state_65266__$1;
(statearr_65270_65301[(2)] = null);

(statearr_65270_65301[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (4))){
var inst_65226 = (state_65266[(2)]);
var state_65266__$1 = state_65266;
var statearr_65271_65302 = state_65266__$1;
(statearr_65271_65302[(2)] = inst_65226);

(statearr_65271_65302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (15))){
var inst_65243 = (state_65266[(7)]);
var inst_65242 = (state_65266[(2)]);
var inst_65243__$1 = fluree.db.util.async.throw_err(inst_65242);
var state_65266__$1 = (function (){var statearr_65272 = state_65266;
(statearr_65272[(7)] = inst_65243__$1);

return statearr_65272;
})();
if(cljs.core.truth_(inst_65243__$1)){
var statearr_65273_65303 = state_65266__$1;
(statearr_65273_65303[(1)] = (16));

} else {
var statearr_65274_65304 = state_65266__$1;
(statearr_65274_65304[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (13))){
var state_65266__$1 = state_65266;
var statearr_65275_65305 = state_65266__$1;
(statearr_65275_65305[(2)] = null);

(statearr_65275_65305[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (6))){
var state_65266__$1 = state_65266;
var statearr_65276_65306 = state_65266__$1;
(statearr_65276_65306[(2)] = db);

(statearr_65276_65306[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (17))){
var inst_65247 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_65248 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65249 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65250 = cljs.core.PersistentHashMap.fromArrays(inst_65248,inst_65249);
var inst_65251 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65247,inst_65250);
var inst_65252 = (function(){throw inst_65251})();
var state_65266__$1 = state_65266;
var statearr_65277_65307 = state_65266__$1;
(statearr_65277_65307[(2)] = inst_65252);

(statearr_65277_65307[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (3))){
var inst_65264 = (state_65266[(2)]);
var state_65266__$1 = state_65266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65266__$1,inst_65264);
} else {
if((state_val_65267 === (12))){
var inst_65240 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_65266__$1 = state_65266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65266__$1,(15),inst_65240);
} else {
if((state_val_65267 === (2))){
var _ = (function (){var statearr_65278 = state_65266;
(statearr_65278[(4)] = cljs.core.cons((5),(state_65266[(4)])));

return statearr_65278;
})();
var inst_65232 = cljs.core.not(auth);
var state_65266__$1 = state_65266;
if(inst_65232){
var statearr_65279_65308 = state_65266__$1;
(statearr_65279_65308[(1)] = (6));

} else {
var statearr_65280_65309 = state_65266__$1;
(statearr_65280_65309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (11))){
var inst_65259 = (state_65266[(2)]);
var state_65266__$1 = state_65266;
var statearr_65282_65310 = state_65266__$1;
(statearr_65282_65310[(2)] = inst_65259);

(statearr_65282_65310[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (9))){
var inst_65237 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_65266__$1 = state_65266;
var statearr_65283_65311 = state_65266__$1;
(statearr_65283_65311[(2)] = inst_65237);

(statearr_65283_65311[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (5))){
var _ = (function (){var statearr_65284 = state_65266;
(statearr_65284[(4)] = cljs.core.rest((state_65266[(4)])));

return statearr_65284;
})();
var state_65266__$1 = state_65266;
var ex65281 = (state_65266__$1[(2)]);
var statearr_65285_65312 = state_65266__$1;
(statearr_65285_65312[(5)] = ex65281);


if((ex65281 instanceof Error)){
var statearr_65286_65313 = state_65266__$1;
(statearr_65286_65313[(1)] = (4));

(statearr_65286_65313[(5)] = null);

} else {
throw ex65281;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (14))){
var inst_65257 = (state_65266[(2)]);
var state_65266__$1 = state_65266;
var statearr_65287_65314 = state_65266__$1;
(statearr_65287_65314[(2)] = inst_65257);

(statearr_65287_65314[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (16))){
var inst_65243 = (state_65266[(7)]);
var inst_65245 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65243);
var state_65266__$1 = state_65266;
var statearr_65288_65315 = state_65266__$1;
(statearr_65288_65315[(2)] = inst_65245);

(statearr_65288_65315[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (10))){
var state_65266__$1 = state_65266;
var statearr_65289_65316 = state_65266__$1;
(statearr_65289_65316[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (18))){
var inst_65254 = (state_65266[(2)]);
var state_65266__$1 = state_65266;
var statearr_65291_65317 = state_65266__$1;
(statearr_65291_65317[(2)] = inst_65254);

(statearr_65291_65317[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65267 === (8))){
var inst_65261 = (state_65266[(2)]);
var _ = (function (){var statearr_65292 = state_65266;
(statearr_65292[(4)] = cljs.core.rest((state_65266[(4)])));

return statearr_65292;
})();
var state_65266__$1 = state_65266;
var statearr_65293_65318 = state_65266__$1;
(statearr_65293_65318[(2)] = inst_65261);

(statearr_65293_65318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0 = (function (){
var statearr_65294 = [null,null,null,null,null,null,null,null];
(statearr_65294[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__);

(statearr_65294[(1)] = (1));

return statearr_65294;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1 = (function (state_65266){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65266);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65295){var ex__2744__auto__ = e65295;
var statearr_65296_65319 = state_65266;
(statearr_65296_65319[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65266[(4)]))){
var statearr_65297_65320 = state_65266;
(statearr_65297_65320[(1)] = cljs.core.first((state_65266[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65321 = state_65266;
state_65266 = G__65321;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__ = function(state_65266){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1.call(this,state_65266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65298 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65298[(6)] = c__2763__auto__);

return statearr_65298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65385){
var state_val_65386 = (state_65385[(1)]);
if((state_val_65386 === (7))){
var inst_65331 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_65385__$1 = state_65385;
if(inst_65331){
var statearr_65387_65436 = state_65385__$1;
(statearr_65387_65436[(1)] = (9));

} else {
var statearr_65388_65437 = state_65385__$1;
(statearr_65388_65437[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (20))){
var inst_65355 = (state_65385[(7)]);
var state_65385__$1 = state_65385;
if(cljs.core.truth_(inst_65355)){
var statearr_65389_65438 = state_65385__$1;
(statearr_65389_65438[(1)] = (22));

} else {
var statearr_65390_65439 = state_65385__$1;
(statearr_65390_65439[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (27))){
var state_65385__$1 = state_65385;
var statearr_65391_65440 = state_65385__$1;
(statearr_65391_65440[(2)] = null);

(statearr_65391_65440[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (1))){
var state_65385__$1 = state_65385;
var statearr_65392_65441 = state_65385__$1;
(statearr_65392_65441[(2)] = null);

(statearr_65392_65441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (24))){
var inst_65369 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65393_65442 = state_65385__$1;
(statearr_65393_65442[(2)] = inst_65369);

(statearr_65393_65442[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (4))){
var inst_65322 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65394_65443 = state_65385__$1;
(statearr_65394_65443[(2)] = inst_65322);

(statearr_65394_65443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (15))){
var inst_65338 = (state_65385[(8)]);
var inst_65337 = (state_65385[(2)]);
var inst_65338__$1 = fluree.db.util.async.throw_err(inst_65337);
var state_65385__$1 = (function (){var statearr_65395 = state_65385;
(statearr_65395[(8)] = inst_65338__$1);

return statearr_65395;
})();
if(cljs.core.truth_(inst_65338__$1)){
var statearr_65396_65444 = state_65385__$1;
(statearr_65396_65444[(1)] = (16));

} else {
var statearr_65397_65445 = state_65385__$1;
(statearr_65397_65445[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (21))){
var inst_65371 = (state_65385[(9)]);
var inst_65371__$1 = (state_65385[(2)]);
var state_65385__$1 = (function (){var statearr_65398 = state_65385;
(statearr_65398[(9)] = inst_65371__$1);

return statearr_65398;
})();
if(cljs.core.truth_(inst_65371__$1)){
var statearr_65399_65446 = state_65385__$1;
(statearr_65399_65446[(1)] = (29));

} else {
var statearr_65400_65447 = state_65385__$1;
(statearr_65400_65447[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (31))){
var inst_65355 = (state_65385[(7)]);
var inst_65371 = (state_65385[(9)]);
var inst_65379 = (state_65385[(2)]);
var inst_65380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65355,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_65371,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65379], 0));
var _ = (function (){var statearr_65401 = state_65385;
(statearr_65401[(4)] = cljs.core.rest((state_65385[(4)])));

return statearr_65401;
})();
var state_65385__$1 = state_65385;
var statearr_65402_65448 = state_65385__$1;
(statearr_65402_65448[(2)] = inst_65380);

(statearr_65402_65448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (32))){
var inst_65375 = (state_65385[(2)]);
var inst_65376 = fluree.db.util.async.throw_err(inst_65375);
var state_65385__$1 = state_65385;
var statearr_65403_65449 = state_65385__$1;
(statearr_65403_65449[(2)] = inst_65376);

(statearr_65403_65449[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (13))){
var state_65385__$1 = state_65385;
var statearr_65404_65450 = state_65385__$1;
(statearr_65404_65450[(2)] = null);

(statearr_65404_65450[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (22))){
var inst_65355 = (state_65385[(7)]);
var inst_65359 = fluree.db.auth.roles(db,inst_65355);
var state_65385__$1 = state_65385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65385__$1,(25),inst_65359);
} else {
if((state_val_65386 === (29))){
var inst_65371 = (state_65385[(9)]);
var inst_65373 = fluree.db.permissions.permission_map(db,inst_65371,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65385__$1 = state_65385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65385__$1,(32),inst_65373);
} else {
if((state_val_65386 === (6))){
var state_65385__$1 = state_65385;
var statearr_65405_65451 = state_65385__$1;
(statearr_65405_65451[(2)] = null);

(statearr_65405_65451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (28))){
var inst_65367 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65406_65452 = state_65385__$1;
(statearr_65406_65452[(2)] = inst_65367);

(statearr_65406_65452[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (25))){
var inst_65361 = (state_65385[(2)]);
var inst_65362 = fluree.db.util.async.throw_err(inst_65361);
var state_65385__$1 = state_65385;
var statearr_65407_65453 = state_65385__$1;
(statearr_65407_65453[(2)] = inst_65362);

(statearr_65407_65453[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (17))){
var inst_65341 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_65342 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65343 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65344 = cljs.core.PersistentHashMap.fromArrays(inst_65342,inst_65343);
var inst_65345 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65341,inst_65344);
var inst_65346 = (function(){throw inst_65345})();
var state_65385__$1 = state_65385;
var statearr_65408_65454 = state_65385__$1;
(statearr_65408_65454[(2)] = inst_65346);

(statearr_65408_65454[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (3))){
var inst_65383 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65385__$1,inst_65383);
} else {
if((state_val_65386 === (12))){
var inst_65335 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_65385__$1 = state_65385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65385__$1,(15),inst_65335);
} else {
if((state_val_65386 === (2))){
var _ = (function (){var statearr_65409 = state_65385;
(statearr_65409[(4)] = cljs.core.cons((5),(state_65385[(4)])));

return statearr_65409;
})();
var inst_65328 = (auth == null);
var state_65385__$1 = state_65385;
if(cljs.core.truth_(inst_65328)){
var statearr_65410_65455 = state_65385__$1;
(statearr_65410_65455[(1)] = (6));

} else {
var statearr_65411_65456 = state_65385__$1;
(statearr_65411_65456[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (23))){
var state_65385__$1 = state_65385;
var statearr_65412_65457 = state_65385__$1;
(statearr_65412_65457[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (19))){
var state_65385__$1 = state_65385;
var statearr_65414_65458 = state_65385__$1;
(statearr_65414_65458[(2)] = roles);

(statearr_65414_65458[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (11))){
var inst_65353 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65416_65459 = state_65385__$1;
(statearr_65416_65459[(2)] = inst_65353);

(statearr_65416_65459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (9))){
var state_65385__$1 = state_65385;
var statearr_65417_65460 = state_65385__$1;
(statearr_65417_65460[(2)] = (0));

(statearr_65417_65460[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (5))){
var _ = (function (){var statearr_65418 = state_65385;
(statearr_65418[(4)] = cljs.core.rest((state_65385[(4)])));

return statearr_65418;
})();
var state_65385__$1 = state_65385;
var ex65415 = (state_65385__$1[(2)]);
var statearr_65419_65461 = state_65385__$1;
(statearr_65419_65461[(5)] = ex65415);


if((ex65415 instanceof Error)){
var statearr_65420_65462 = state_65385__$1;
(statearr_65420_65462[(1)] = (4));

(statearr_65420_65462[(5)] = null);

} else {
throw ex65415;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (14))){
var inst_65351 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65421_65463 = state_65385__$1;
(statearr_65421_65463[(2)] = inst_65351);

(statearr_65421_65463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (26))){
var state_65385__$1 = state_65385;
var statearr_65422_65464 = state_65385__$1;
(statearr_65422_65464[(2)] = null);

(statearr_65422_65464[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (16))){
var inst_65338 = (state_65385[(8)]);
var state_65385__$1 = state_65385;
var statearr_65423_65465 = state_65385__$1;
(statearr_65423_65465[(2)] = inst_65338);

(statearr_65423_65465[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (30))){
var state_65385__$1 = state_65385;
var statearr_65424_65466 = state_65385__$1;
(statearr_65424_65466[(2)] = null);

(statearr_65424_65466[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (10))){
var state_65385__$1 = state_65385;
if(cljs.core.truth_(auth)){
var statearr_65425_65467 = state_65385__$1;
(statearr_65425_65467[(1)] = (12));

} else {
var statearr_65426_65468 = state_65385__$1;
(statearr_65426_65468[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (18))){
var inst_65348 = (state_65385[(2)]);
var state_65385__$1 = state_65385;
var statearr_65427_65469 = state_65385__$1;
(statearr_65427_65469[(2)] = inst_65348);

(statearr_65427_65469[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65386 === (8))){
var inst_65355 = (state_65385[(2)]);
var state_65385__$1 = (function (){var statearr_65428 = state_65385;
(statearr_65428[(7)] = inst_65355);

return statearr_65428;
})();
if(cljs.core.truth_(roles)){
var statearr_65429_65470 = state_65385__$1;
(statearr_65429_65470[(1)] = (19));

} else {
var statearr_65430_65471 = state_65385__$1;
(statearr_65430_65471[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0 = (function (){
var statearr_65431 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65431[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__);

(statearr_65431[(1)] = (1));

return statearr_65431;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1 = (function (state_65385){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65385);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65432){var ex__2744__auto__ = e65432;
var statearr_65433_65472 = state_65385;
(statearr_65433_65472[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65385[(4)]))){
var statearr_65434_65473 = state_65385;
(statearr_65434_65473[(1)] = cljs.core.first((state_65385[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65474 = state_65385;
state_65385 = G__65474;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__ = function(state_65385){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1.call(this,state_65385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65435 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65435[(6)] = c__2763__auto__);

return statearr_65435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__65475 = db;
var map__65475__$1 = cljs.core.__destructure_map(map__65475);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65475__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65475__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65475__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65482){
var state_val_65483 = (state_65482[(1)]);
if((state_val_65483 === (1))){
var inst_65476 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_65477 = fluree.db.session.db(conn,inst_65476,null);
var state_65482__$1 = state_65482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65482__$1,(2),inst_65477);
} else {
if((state_val_65483 === (2))){
var inst_65479 = (state_65482[(2)]);
var inst_65480 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_65479);
var state_65482__$1 = state_65482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65482__$1,inst_65480);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_65484 = [null,null,null,null,null,null,null];
(statearr_65484[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_65484[(1)] = (1));

return statearr_65484;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_65482){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65482);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65485){var ex__2744__auto__ = e65485;
var statearr_65486_65513 = state_65482;
(statearr_65486_65513[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65482[(4)]))){
var statearr_65487_65514 = state_65482;
(statearr_65487_65514[(1)] = cljs.core.first((state_65482[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65515 = state_65482;
state_65482 = G__65515;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_65482){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_65482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65488 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65488[(6)] = c__2763__auto__);

return statearr_65488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2763__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65501){
var state_val_65502 = (state_65501[(1)]);
if((state_val_65502 === (1))){
var inst_65489 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_65490 = fluree.db.session.db(conn,inst_65489,null);
var state_65501__$1 = state_65501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65501__$1,(2),inst_65490);
} else {
if((state_val_65502 === (2))){
var inst_65492 = (state_65501[(7)]);
var inst_65492__$1 = (state_65501[(2)]);
var inst_65493 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_65492__$1);
var inst_65494 = newer_block_QMARK_(inst_65493);
var state_65501__$1 = (function (){var statearr_65503 = state_65501;
(statearr_65503[(7)] = inst_65492__$1);

return statearr_65503;
})();
if(inst_65494){
var statearr_65504_65516 = state_65501__$1;
(statearr_65504_65516[(1)] = (3));

} else {
var statearr_65505_65517 = state_65501__$1;
(statearr_65505_65517[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65502 === (3))){
var inst_65492 = (state_65501[(7)]);
var inst_65496 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_65492);
var state_65501__$1 = state_65501;
var statearr_65506_65518 = state_65501__$1;
(statearr_65506_65518[(2)] = inst_65496);

(statearr_65506_65518[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65502 === (4))){
var state_65501__$1 = state_65501;
var statearr_65507_65519 = state_65501__$1;
(statearr_65507_65519[(2)] = null);

(statearr_65507_65519[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65502 === (5))){
var inst_65499 = (state_65501[(2)]);
var state_65501__$1 = state_65501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65501__$1,inst_65499);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0 = (function (){
var statearr_65508 = [null,null,null,null,null,null,null,null];
(statearr_65508[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__);

(statearr_65508[(1)] = (1));

return statearr_65508;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1 = (function (state_65501){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65501);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65509){var ex__2744__auto__ = e65509;
var statearr_65510_65520 = state_65501;
(statearr_65510_65520[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65501[(4)]))){
var statearr_65511_65521 = state_65501;
(statearr_65511_65521[(1)] = cljs.core.first((state_65501[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65522 = state_65501;
state_65501 = G__65522;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__ = function(state_65501){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1.call(this,state_65501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65512 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65512[(6)] = c__2763__auto__);

return statearr_65512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

return c__2763__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__65523 = db;
var map__65523__$1 = cljs.core.__destructure_map(map__65523);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65523__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65523__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65523__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4339__auto__ = syncTimeout;
var y__4340__auto__ = (120000);
return ((x__4339__auto__ < y__4340__auto__) ? x__4339__auto__ : y__4340__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2763__auto___65599 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65573){
var state_val_65574 = (state_65573[(1)]);
if((state_val_65574 === (7))){
var inst_65539 = (state_65573[(7)]);
var inst_65550 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65539,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_65573__$1 = state_65573;
if(inst_65550){
var statearr_65575_65600 = state_65573__$1;
(statearr_65575_65600[(1)] = (9));

} else {
var statearr_65576_65601 = state_65573__$1;
(statearr_65576_65601[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (1))){
var inst_65524 = (state_65573[(8)]);
var inst_65532 = (state_65573[(9)]);
var inst_65524__$1 = cljs.core.async.timeout(timeout);
var inst_65532__$1 = res_port;
var inst_65533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65534 = [inst_65524__$1,inst_65532__$1];
var inst_65535 = (new cljs.core.PersistentVector(null,2,(5),inst_65533,inst_65534,null));
var state_65573__$1 = (function (){var statearr_65577 = state_65573;
(statearr_65577[(8)] = inst_65524__$1);

(statearr_65577[(9)] = inst_65532__$1);

return statearr_65577;
})();
return cljs.core.async.ioc_alts_BANG_(state_65573__$1,(2),inst_65535);
} else {
if((state_val_65574 === (4))){
var inst_65532 = (state_65573[(9)]);
var inst_65539 = (state_65573[(7)]);
var inst_65543 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65539,inst_65532);
var state_65573__$1 = state_65573;
if(inst_65543){
var statearr_65578_65602 = state_65573__$1;
(statearr_65578_65602[(1)] = (6));

} else {
var statearr_65579_65603 = state_65573__$1;
(statearr_65579_65603[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (13))){
var inst_65558 = (state_65573[(10)]);
var inst_65569 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65558);
var state_65573__$1 = state_65573;
var statearr_65580_65604 = state_65573__$1;
(statearr_65580_65604[(2)] = inst_65569);

(statearr_65580_65604[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (6))){
var inst_65537 = (state_65573[(11)]);
var inst_65548 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65537,(0),null);
var state_65573__$1 = state_65573;
var statearr_65581_65605 = state_65573__$1;
(statearr_65581_65605[(2)] = inst_65548);

(statearr_65581_65605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (3))){
var state_65573__$1 = state_65573;
var statearr_65582_65606 = state_65573__$1;
(statearr_65582_65606[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_65582_65606[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (12))){
var inst_65562 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_65563 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65564 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_65565 = cljs.core.PersistentHashMap.fromArrays(inst_65563,inst_65564);
var inst_65566 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65562,inst_65565);
var inst_65567 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65566);
var state_65573__$1 = state_65573;
var statearr_65583_65607 = state_65573__$1;
(statearr_65583_65607[(2)] = inst_65567);

(statearr_65583_65607[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (2))){
var inst_65537 = (state_65573[(11)]);
var inst_65524 = (state_65573[(8)]);
var inst_65539 = (state_65573[(7)]);
var inst_65537__$1 = (state_65573[(2)]);
var inst_65538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65537__$1,(0),null);
var inst_65539__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65537__$1,(1),null);
var inst_65540 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65539__$1,inst_65524);
var state_65573__$1 = (function (){var statearr_65584 = state_65573;
(statearr_65584[(11)] = inst_65537__$1);

(statearr_65584[(12)] = inst_65538);

(statearr_65584[(7)] = inst_65539__$1);

return statearr_65584;
})();
if(inst_65540){
var statearr_65585_65608 = state_65573__$1;
(statearr_65585_65608[(1)] = (3));

} else {
var statearr_65586_65609 = state_65573__$1;
(statearr_65586_65609[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (11))){
var inst_65554 = (state_65573[(2)]);
var state_65573__$1 = state_65573;
var statearr_65587_65610 = state_65573__$1;
(statearr_65587_65610[(2)] = inst_65554);

(statearr_65587_65610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (9))){
var inst_65538 = (state_65573[(12)]);
var state_65573__$1 = state_65573;
var statearr_65588_65611 = state_65573__$1;
(statearr_65588_65611[(2)] = inst_65538);

(statearr_65588_65611[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (5))){
var inst_65558 = (state_65573[(10)]);
var inst_65558__$1 = (state_65573[(2)]);
var inst_65559 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_65560 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_65558__$1);
var state_65573__$1 = (function (){var statearr_65589 = state_65573;
(statearr_65589[(10)] = inst_65558__$1);

(statearr_65589[(13)] = inst_65559);

return statearr_65589;
})();
if(inst_65560){
var statearr_65590_65612 = state_65573__$1;
(statearr_65590_65612[(1)] = (12));

} else {
var statearr_65591_65613 = state_65573__$1;
(statearr_65591_65613[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (14))){
var inst_65571 = (state_65573[(2)]);
var state_65573__$1 = state_65573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65573__$1,inst_65571);
} else {
if((state_val_65574 === (10))){
var state_65573__$1 = state_65573;
var statearr_65592_65614 = state_65573__$1;
(statearr_65592_65614[(2)] = null);

(statearr_65592_65614[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65574 === (8))){
var inst_65556 = (state_65573[(2)]);
var state_65573__$1 = state_65573;
var statearr_65593_65615 = state_65573__$1;
(statearr_65593_65615[(2)] = inst_65556);

(statearr_65593_65615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0 = (function (){
var statearr_65594 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65594[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__);

(statearr_65594[(1)] = (1));

return statearr_65594;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1 = (function (state_65573){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65573);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65595){var ex__2744__auto__ = e65595;
var statearr_65596_65616 = state_65573;
(statearr_65596_65616[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65573[(4)]))){
var statearr_65597_65617 = state_65573;
(statearr_65597_65617[(1)] = cljs.core.first((state_65573[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65618 = state_65573;
state_65573 = G__65618;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__ = function(state_65573){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1.call(this,state_65573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65598 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65598[(6)] = c__2763__auto___65599);

return statearr_65598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__65620 = arguments.length;
switch (G__65620) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__65621){
var map__65622 = p__65621;
var map__65622__$1 = cljs.core.__destructure_map(map__65622);
var opts = map__65622__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65622__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65622__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65622__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65622__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65622__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2763__auto___65711 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2764__auto__ = (function (){var switch__2740__auto__ = (function (state_65673){
var state_val_65674 = (state_65673[(1)]);
if((state_val_65674 === (7))){
var inst_65635 = (state_65673[(7)]);
var inst_65637 = fluree.db.api.ledger.syncTo_db(inst_65635,syncTo,syncTimeout);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65673__$1,(10),inst_65637);
} else {
if((state_val_65674 === (20))){
var inst_65659 = (state_65673[(8)]);
var state_65673__$1 = state_65673;
var statearr_65675_65712 = state_65673__$1;
(statearr_65675_65712[(2)] = inst_65659);

(statearr_65675_65712[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (1))){
var state_65673__$1 = state_65673;
var statearr_65676_65713 = state_65673__$1;
(statearr_65676_65713[(2)] = null);

(statearr_65676_65713[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (4))){
var inst_65623 = (state_65673[(2)]);
var inst_65624 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65623);
var inst_65625 = cljs.core.async.close_BANG_(pc);
var state_65673__$1 = (function (){var statearr_65677 = state_65673;
(statearr_65677[(9)] = inst_65624);

return statearr_65677;
})();
var statearr_65678_65714 = state_65673__$1;
(statearr_65678_65714[(2)] = inst_65625);

(statearr_65678_65714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (15))){
var inst_65651 = (state_65673[(10)]);
var inst_65653 = fluree.db.api.ledger.add_db_permissions(inst_65651,auth,roles);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65673__$1,(18),inst_65653);
} else {
if((state_val_65674 === (21))){
var inst_65667 = (state_65673[(2)]);
var inst_65668 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65667);
var _ = (function (){var statearr_65679 = state_65673;
(statearr_65679[(4)] = cljs.core.rest((state_65673[(4)])));

return statearr_65679;
})();
var state_65673__$1 = state_65673;
var statearr_65680_65715 = state_65673__$1;
(statearr_65680_65715[(2)] = inst_65668);

(statearr_65680_65715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (13))){
var inst_65651 = (state_65673[(2)]);
var state_65673__$1 = (function (){var statearr_65681 = state_65673;
(statearr_65681[(10)] = inst_65651);

return statearr_65681;
})();
if(cljs.core.truth_(roles)){
var statearr_65682_65716 = state_65673__$1;
(statearr_65682_65716[(1)] = (15));

} else {
var statearr_65683_65717 = state_65673__$1;
(statearr_65683_65717[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (22))){
var inst_65663 = (state_65673[(2)]);
var inst_65664 = fluree.db.util.async.throw_err(inst_65663);
var state_65673__$1 = state_65673;
var statearr_65684_65718 = state_65673__$1;
(statearr_65684_65718[(2)] = inst_65664);

(statearr_65684_65718[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (6))){
var inst_65634 = (state_65673[(2)]);
var inst_65635 = fluree.db.util.async.throw_err(inst_65634);
var state_65673__$1 = (function (){var statearr_65685 = state_65673;
(statearr_65685[(7)] = inst_65635);

return statearr_65685;
})();
if(cljs.core.truth_(syncTo)){
var statearr_65686_65719 = state_65673__$1;
(statearr_65686_65719[(1)] = (7));

} else {
var statearr_65687_65720 = state_65673__$1;
(statearr_65687_65720[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (17))){
var inst_65659 = (state_65673[(2)]);
var state_65673__$1 = (function (){var statearr_65688 = state_65673;
(statearr_65688[(8)] = inst_65659);

return statearr_65688;
})();
if(cljs.core.truth_(auth)){
var statearr_65689_65721 = state_65673__$1;
(statearr_65689_65721[(1)] = (19));

} else {
var statearr_65690_65722 = state_65673__$1;
(statearr_65690_65722[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (3))){
var inst_65671 = (state_65673[(2)]);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65673__$1,inst_65671);
} else {
if((state_val_65674 === (12))){
var inst_65643 = (state_65673[(11)]);
var state_65673__$1 = state_65673;
var statearr_65691_65723 = state_65673__$1;
(statearr_65691_65723[(2)] = inst_65643);

(statearr_65691_65723[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (2))){
var _ = (function (){var statearr_65692 = state_65673;
(statearr_65692[(4)] = cljs.core.cons((5),(state_65673[(4)])));

return statearr_65692;
})();
var inst_65632 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65673__$1,(6),inst_65632);
} else {
if((state_val_65674 === (19))){
var inst_65659 = (state_65673[(8)]);
var inst_65661 = fluree.db.api.ledger.add_db_permissions(inst_65659,auth,roles);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65673__$1,(22),inst_65661);
} else {
if((state_val_65674 === (11))){
var inst_65643 = (state_65673[(11)]);
var inst_65645 = fluree.db.time_travel.as_of_block(inst_65643,block);
var state_65673__$1 = state_65673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65673__$1,(14),inst_65645);
} else {
if((state_val_65674 === (9))){
var inst_65643 = (state_65673[(2)]);
var state_65673__$1 = (function (){var statearr_65694 = state_65673;
(statearr_65694[(11)] = inst_65643);

return statearr_65694;
})();
if(cljs.core.truth_(block)){
var statearr_65695_65724 = state_65673__$1;
(statearr_65695_65724[(1)] = (11));

} else {
var statearr_65696_65725 = state_65673__$1;
(statearr_65696_65725[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (5))){
var _ = (function (){var statearr_65697 = state_65673;
(statearr_65697[(4)] = cljs.core.rest((state_65673[(4)])));

return statearr_65697;
})();
var state_65673__$1 = state_65673;
var ex65693 = (state_65673__$1[(2)]);
var statearr_65698_65726 = state_65673__$1;
(statearr_65698_65726[(5)] = ex65693);


var statearr_65699_65727 = state_65673__$1;
(statearr_65699_65727[(1)] = (4));

(statearr_65699_65727[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (14))){
var inst_65647 = (state_65673[(2)]);
var inst_65648 = fluree.db.util.async.throw_err(inst_65647);
var state_65673__$1 = state_65673;
var statearr_65700_65728 = state_65673__$1;
(statearr_65700_65728[(2)] = inst_65648);

(statearr_65700_65728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (16))){
var inst_65651 = (state_65673[(10)]);
var state_65673__$1 = state_65673;
var statearr_65701_65729 = state_65673__$1;
(statearr_65701_65729[(2)] = inst_65651);

(statearr_65701_65729[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (10))){
var inst_65639 = (state_65673[(2)]);
var inst_65640 = fluree.db.util.async.throw_err(inst_65639);
var state_65673__$1 = state_65673;
var statearr_65702_65730 = state_65673__$1;
(statearr_65702_65730[(2)] = inst_65640);

(statearr_65702_65730[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (18))){
var inst_65655 = (state_65673[(2)]);
var inst_65656 = fluree.db.util.async.throw_err(inst_65655);
var state_65673__$1 = state_65673;
var statearr_65703_65731 = state_65673__$1;
(statearr_65703_65731[(2)] = inst_65656);

(statearr_65703_65731[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65674 === (8))){
var inst_65635 = (state_65673[(7)]);
var state_65673__$1 = state_65673;
var statearr_65704_65732 = state_65673__$1;
(statearr_65704_65732[(2)] = inst_65635);

(statearr_65704_65732[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2741__auto__ = null;
var fluree$db$api$ledger$state_machine__2741__auto____0 = (function (){
var statearr_65705 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65705[(0)] = fluree$db$api$ledger$state_machine__2741__auto__);

(statearr_65705[(1)] = (1));

return statearr_65705;
});
var fluree$db$api$ledger$state_machine__2741__auto____1 = (function (state_65673){
while(true){
var ret_value__2742__auto__ = (function (){try{while(true){
var result__2743__auto__ = switch__2740__auto__(state_65673);
if(cljs.core.keyword_identical_QMARK_(result__2743__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2743__auto__;
}
break;
}
}catch (e65706){var ex__2744__auto__ = e65706;
var statearr_65707_65733 = state_65673;
(statearr_65707_65733[(2)] = ex__2744__auto__);


if(cljs.core.seq((state_65673[(4)]))){
var statearr_65708_65734 = state_65673;
(statearr_65708_65734[(1)] = cljs.core.first((state_65673[(4)])));

} else {
throw ex__2744__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2742__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65735 = state_65673;
state_65673 = G__65735;
continue;
} else {
return ret_value__2742__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2741__auto__ = function(state_65673){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2741__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2741__auto____1.call(this,state_65673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2741__auto____0;
fluree$db$api$ledger$state_machine__2741__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2741__auto____1;
return fluree$db$api$ledger$state_machine__2741__auto__;
})()
})();
var state__2765__auto__ = (function (){var statearr_65709 = (f__2764__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2764__auto__.cljs$core$IFn$_invoke$arity$0() : f__2764__auto__.call(null));
(statearr_65709[(6)] = c__2763__auto___65711);

return statearr_65709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2765__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

