// Compiled by ClojureScript 1.10.891 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto');
goog.require('cljs.core');
goog.require('fluree.crypto.sha2');
goog.require('fluree.crypto.sha3');
goog.require('fluree.crypto.aes');
goog.require('fluree.crypto.scrypt');
goog.require('fluree.crypto.ripemd');
goog.require('fluree.crypto.secp256k1');
goog.require('goog.crypt');
goog.require('alphabase.core');
goog.require('goog.object');
goog.scope(function(){
fluree.crypto.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Normalizes string for consistent hashing.
 */
fluree.crypto.normalize_string = (function fluree$crypto$normalize_string(s){
return s.normalize("NFKC");
});
goog.exportSymbol('fluree.crypto.normalize_string', fluree.crypto.normalize_string);
/**
 * Does simple check when input format not specified.
 *   Assumes either string or bytes
 */
fluree.crypto.coerce_input_format = (function fluree$crypto$coerce_input_format(x){
if(typeof x === 'string'){
return new cljs.core.Keyword(null,"string","string",-1989541586);
} else {
return new cljs.core.Keyword(null,"bytes","bytes",1175866680);
}
});
/**
 * Normalizes string then converts to a byte-array.
 *   If value is already a byte-array, returns original value.
 */
fluree.crypto.string__GT_byte_array = (function fluree$crypto$string__GT_byte_array(s){
return alphabase.core.string__GT_bytes(fluree.crypto.normalize_string(s));
});
goog.exportSymbol('fluree.crypto.string__GT_byte_array', fluree.crypto.string__GT_byte_array);
fluree.crypto.byte_array__GT_string = (function fluree$crypto$byte_array__GT_string(s){
return alphabase.core.bytes__GT_string(s);
});
goog.exportSymbol('fluree.crypto.byte_array__GT_string', fluree.crypto.byte_array__GT_string);
fluree.crypto.sha2_256 = (function fluree$crypto$sha2_256(var_args){
var G__61530 = arguments.length;
switch (G__61530) {
case 1:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_256', fluree.crypto.sha2_256);

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_256(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2_256.cljs$lang$maxFixedArity = 3);

/**
 * sha2-256 hash of provided string after normalizing string.
 */
fluree.crypto.sha2_256_normalize = (function fluree$crypto$sha2_256_normalize(var_args){
var G__61533 = arguments.length;
switch (G__61533) {
case 1:
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_256_normalize', fluree.crypto.sha2_256_normalize);

(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2_256_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha2_256_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha2_512 = (function fluree$crypto$sha2_512(var_args){
var G__61536 = arguments.length;
switch (G__61536) {
case 1:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_512', fluree.crypto.sha2_512);

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha2.sha2_512(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha2_512.cljs$lang$maxFixedArity = 3);

/**
 * sha2-512 hash of provided string after normalizing string.
 */
fluree.crypto.sha2_512_normalize = (function fluree$crypto$sha2_512_normalize(var_args){
var G__61539 = arguments.length;
switch (G__61539) {
case 1:
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha2_512_normalize', fluree.crypto.sha2_512_normalize);

(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha2_512_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha2_512.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha2_512_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha3_256 = (function fluree$crypto$sha3_256(var_args){
var G__61542 = arguments.length;
switch (G__61542) {
case 1:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_256', fluree.crypto.sha3_256);

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha3.sha3_256(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha3_256.cljs$lang$maxFixedArity = 3);

/**
 * sha3-256 hash of provided string after normalizing string.
 */
fluree.crypto.sha3_256_normalize = (function fluree$crypto$sha3_256_normalize(var_args){
var G__61545 = arguments.length;
switch (G__61545) {
case 1:
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_256_normalize', fluree.crypto.sha3_256_normalize);

(fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha3_256_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha3_256_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.sha3_512 = (function fluree$crypto$sha3_512(var_args){
var G__61548 = arguments.length;
switch (G__61548) {
case 1:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_512', fluree.crypto.sha3_512);

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.sha3.sha3_512(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.sha3_512.cljs$lang$maxFixedArity = 3);

/**
 * sha3-512 hash of provided string after normalizing string.
 */
fluree.crypto.sha3_512_normalize = (function fluree$crypto$sha3_512_normalize(var_args){
var G__61551 = arguments.length;
switch (G__61551) {
case 1:
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.sha3_512_normalize', fluree.crypto.sha3_512_normalize);

(fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$1 = (function (s){
return fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2(s,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.sha3_512_normalize.cljs$core$IFn$_invoke$arity$2 = (function (s,output_format){
return fluree.crypto.sha3_512.cljs$core$IFn$_invoke$arity$3(fluree.crypto.normalize_string(s),output_format,new cljs.core.Keyword(null,"string","string",-1989541586));
}));

(fluree.crypto.sha3_512_normalize.cljs$lang$maxFixedArity = 2);

fluree.crypto.ripemd_160 = (function fluree$crypto$ripemd_160(var_args){
var G__61554 = arguments.length;
switch (G__61554) {
case 1:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.ripemd_160', fluree.crypto.ripemd_160);

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$2 = (function (x,output_format){
return fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3(x,output_format,fluree.crypto.coerce_input_format(x));
}));

(fluree.crypto.ripemd_160.cljs$core$IFn$_invoke$arity$3 = (function (x,output_format,input_format){
return alphabase.core.byte_array_to_base(fluree.crypto.ripemd.ripemd_160(alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(x,input_format)),cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format));
}));

(fluree.crypto.ripemd_160.cljs$lang$maxFixedArity = 3);

fluree.crypto.aes_encrypt = (function fluree$crypto$aes_encrypt(var_args){
var G__61557 = arguments.length;
switch (G__61557) {
case 3:
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.aes_encrypt', fluree.crypto.aes_encrypt);

(fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$3 = (function (x,iv,key){
return fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4(x,iv,key,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.aes_encrypt.cljs$core$IFn$_invoke$arity$4 = (function (x,iv,key,output_format){
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic(x,key,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"iv","iv",-1550102132),iv,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),output_format], null)], 0));
}));

(fluree.crypto.aes_encrypt.cljs$lang$maxFixedArity = 4);

fluree.crypto.aes_decrypt = (function fluree$crypto$aes_decrypt(var_args){
var G__61560 = arguments.length;
switch (G__61560) {
case 3:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.aes_decrypt', fluree.crypto.aes_decrypt);

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$3 = (function (x,iv,key){
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5(x,iv,key,new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$4 = (function (x,iv,key,output_format){
return fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5(x,iv,key,output_format,new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.aes_decrypt.cljs$core$IFn$_invoke$arity$5 = (function (x,iv,key,output_format,input_format){
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic(x,key,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"iv","iv",-1550102132),iv,new cljs.core.Keyword(null,"input-format","input-format",-422703481),input_format,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),output_format], null)], 0));
}));

(fluree.crypto.aes_decrypt.cljs$lang$maxFixedArity = 5);

fluree.crypto.generate_key_pair = (function fluree$crypto$generate_key_pair(var_args){
var G__61563 = arguments.length;
switch (G__61563) {
case 0:
return fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('fluree.crypto.generate_key_pair', fluree.crypto.generate_key_pair);

(fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$0();
}));

(fluree.crypto.generate_key_pair.cljs$core$IFn$_invoke$arity$1 = (function (private$){
return fluree.crypto.secp256k1.generate_key_pair.cljs$core$IFn$_invoke$arity$1(private$);
}));

(fluree.crypto.generate_key_pair.cljs$lang$maxFixedArity = 1);

/**
 * Take a private key as either a hex string or BigInteger (clj) bignumber (cljs), returns as a hex string.
 */
fluree.crypto.pub_key_from_private = (function fluree$crypto$pub_key_from_private(private_key){
var G__61565 = fluree.crypto.secp256k1.format_key_pair(fluree.crypto.secp256k1.public_key_from_private(private_key));
var G__61566 = "public";
return fluree.crypto.goog$module$goog$object.get.call(null,G__61565,G__61566);
});
goog.exportSymbol('fluree.crypto.pub_key_from_private', fluree.crypto.pub_key_from_private);
fluree.crypto.account_id_from_public = (function fluree$crypto$account_id_from_public(public_key){
return fluree.crypto.secp256k1.get_sin_from_public_key(public_key);
});
goog.exportSymbol('fluree.crypto.account_id_from_public', fluree.crypto.account_id_from_public);
fluree.crypto.account_id_from_private = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(fluree.crypto.account_id_from_public,fluree.crypto.pub_key_from_private);
goog.exportSymbol('fluree.crypto.account_id_from_private', fluree.crypto.account_id_from_private);
/**
 * Sign some message with provided private key.
 *   Message must be a byte-array or string.
 *   Private key must be hex-encoded or a BigInteger(clj)/bignumber(cljs).
 */
fluree.crypto.sign_message = (function fluree$crypto$sign_message(message,private_key){
return fluree.crypto.secp256k1.sign(message,private_key);
});
goog.exportSymbol('fluree.crypto.sign_message', fluree.crypto.sign_message);
/**
 * Verifies signature of message is valid.
 */
fluree.crypto.verify_signature = (function fluree$crypto$verify_signature(pub_key,message,signature){
return fluree.crypto.secp256k1.verify(pub_key,message,signature);
});
goog.exportSymbol('fluree.crypto.verify_signature', fluree.crypto.verify_signature);
/**
 * Returns public key, and verifies message is correctly signed.
 *   If not correctly signed, throws exception.
 */
fluree.crypto.pub_key_from_message = (function fluree$crypto$pub_key_from_message(message,signature){
return fluree.crypto.secp256k1.recover_public_key(message,signature);
});
goog.exportSymbol('fluree.crypto.pub_key_from_message', fluree.crypto.pub_key_from_message);
/**
 * Given a message and signature, returns the corresponding account id
 *   only if the signature is valid. If invalid, will throw exception.
 */
fluree.crypto.account_id_from_message = (function fluree$crypto$account_id_from_message(message,signature){
return fluree.crypto.account_id_from_public(fluree.crypto.pub_key_from_message(message,signature));
});
goog.exportSymbol('fluree.crypto.account_id_from_message', fluree.crypto.account_id_from_message);
/**
 * Encrypts a message (string) using a salt (bytes). Returns the encrypted message in hex.
 */
fluree.crypto.scrypt_encrypt = (function fluree$crypto$scrypt_encrypt(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61569 = arguments.length;
var i__4865__auto___61570 = (0);
while(true){
if((i__4865__auto___61570 < len__4864__auto___61569)){
args__4870__auto__.push((arguments[i__4865__auto___61570]));

var G__61571 = (i__4865__auto___61570 + (1));
i__4865__auto___61570 = G__61571;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((1) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((1)),(0),null)):null);
return fluree.crypto.scrypt_encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.scrypt_encrypt', fluree.crypto.scrypt_encrypt);

(fluree.crypto.scrypt_encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (message,args){
var byte_msg = fluree.crypto.string__GT_byte_array(message);
return alphabase.core.byte_array_to_base(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.crypto.scrypt.encrypt,byte_msg,args),new cljs.core.Keyword(null,"hex","hex",41691346));
}));

(fluree.crypto.scrypt_encrypt.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.crypto.scrypt_encrypt.cljs$lang$applyTo = (function (seq61567){
var G__61568 = cljs.core.first(seq61567);
var seq61567__$1 = cljs.core.next(seq61567);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61568,seq61567__$1);
}));

/**
 * Compares a message (string) with previously encrypted message (hex). 
 */
fluree.crypto.scrypt_check = (function fluree$crypto$scrypt_check(var_args){
var args__4870__auto__ = [];
var len__4864__auto___61575 = arguments.length;
var i__4865__auto___61576 = (0);
while(true){
if((i__4865__auto___61576 < len__4864__auto___61575)){
args__4870__auto__.push((arguments[i__4865__auto___61576]));

var G__61577 = (i__4865__auto___61576 + (1));
i__4865__auto___61576 = G__61577;
continue;
} else {
}
break;
}

var argseq__4871__auto__ = ((((2) < args__4870__auto__.length))?(new cljs.core.IndexedSeq(args__4870__auto__.slice((2)),(0),null)):null);
return fluree.crypto.scrypt_check.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4871__auto__);
});
goog.exportSymbol('fluree.crypto.scrypt_check', fluree.crypto.scrypt_check);

(fluree.crypto.scrypt_check.cljs$core$IFn$_invoke$arity$variadic = (function (message,encrypted,args){
var byte_msg = fluree.crypto.string__GT_byte_array(message);
var byte_encryped = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(encrypted,new cljs.core.Keyword(null,"hex","hex",41691346));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(fluree.crypto.scrypt.check,byte_msg,byte_encryped,args);
}));

(fluree.crypto.scrypt_check.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.scrypt_check.cljs$lang$applyTo = (function (seq61572){
var G__61573 = cljs.core.first(seq61572);
var seq61572__$1 = cljs.core.next(seq61572);
var G__61574 = cljs.core.first(seq61572__$1);
var seq61572__$2 = cljs.core.next(seq61572__$1);
var self__4851__auto__ = this;
return self__4851__auto__.cljs$core$IFn$_invoke$arity$variadic(G__61573,G__61574,seq61572__$2);
}));

/**
 * Generates n random bytes.
 */
fluree.crypto.random_bytes = (function fluree$crypto$random_bytes(n){
return fluree.crypto.scrypt.random_bytes(n);
});
goog.exportSymbol('fluree.crypto.random_bytes', fluree.crypto.random_bytes);
