// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__11388__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11389__auto__ = (function (){var switch__11350__auto__ = (function (state_21529){
var state_val_21530 = (state_21529[(1)]);
if((state_val_21530 === (7))){
var inst_21524 = (state_21529[(2)]);
var _ = (function (){var statearr_21531 = state_21529;
(statearr_21531[(4)] = cljs.core.rest((state_21529[(4)])));

return statearr_21531;
})();
var state_21529__$1 = state_21529;
var statearr_21532_21554 = state_21529__$1;
(statearr_21532_21554[(2)] = inst_21524);

(statearr_21532_21554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (1))){
var state_21529__$1 = state_21529;
var statearr_21533_21555 = state_21529__$1;
(statearr_21533_21555[(2)] = null);

(statearr_21533_21555[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (4))){
var inst_21486 = (state_21529[(2)]);
var state_21529__$1 = state_21529;
var statearr_21534_21556 = state_21529__$1;
(statearr_21534_21556[(2)] = inst_21486);

(statearr_21534_21556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (6))){
var inst_21504 = (state_21529[(7)]);
var inst_21511 = (state_21529[(8)]);
var inst_21510 = cljs.core.seq(inst_21504);
var inst_21511__$1 = cljs.core.first(inst_21510);
var inst_21512 = cljs.core.next(inst_21510);
var inst_21513 = cljs.core.not(inst_21511__$1);
var state_21529__$1 = (function (){var statearr_21535 = state_21529;
(statearr_21535[(9)] = inst_21512);

(statearr_21535[(8)] = inst_21511__$1);

return statearr_21535;
})();
if(inst_21513){
var statearr_21536_21557 = state_21529__$1;
(statearr_21536_21557[(1)] = (8));

} else {
var statearr_21537_21558 = state_21529__$1;
(statearr_21537_21558[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (3))){
var inst_21527 = (state_21529[(2)]);
var state_21529__$1 = state_21529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21529__$1,inst_21527);
} else {
if((state_val_21530 === (2))){
var _ = (function (){var statearr_21538 = state_21529;
(statearr_21538[(4)] = cljs.core.cons((5),(state_21529[(4)])));

return statearr_21538;
})();
var inst_21499 = chs;
var inst_21500 = cljs.core.seq(inst_21499);
var inst_21501 = cljs.core.first(inst_21500);
var inst_21502 = cljs.core.next(inst_21500);
var inst_21503 = coll;
var inst_21504 = inst_21499;
var inst_21505 = inst_21503;
var state_21529__$1 = (function (){var statearr_21539 = state_21529;
(statearr_21539[(10)] = inst_21505);

(statearr_21539[(7)] = inst_21504);

(statearr_21539[(11)] = inst_21502);

(statearr_21539[(12)] = inst_21501);

return statearr_21539;
})();
var statearr_21540_21559 = state_21529__$1;
(statearr_21540_21559[(2)] = null);

(statearr_21540_21559[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (11))){
var inst_21505 = (state_21529[(10)]);
var inst_21512 = (state_21529[(9)]);
var inst_21517 = (state_21529[(2)]);
var inst_21518 = fluree.db.util.async.throw_err(inst_21517);
var inst_21519 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21505,inst_21518);
var inst_21504 = inst_21512;
var inst_21505__$1 = inst_21519;
var state_21529__$1 = (function (){var statearr_21542 = state_21529;
(statearr_21542[(10)] = inst_21505__$1);

(statearr_21542[(7)] = inst_21504);

return statearr_21542;
})();
var statearr_21543_21560 = state_21529__$1;
(statearr_21543_21560[(2)] = null);

(statearr_21543_21560[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (9))){
var inst_21511 = (state_21529[(8)]);
var state_21529__$1 = state_21529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21529__$1,(11),inst_21511);
} else {
if((state_val_21530 === (5))){
var _ = (function (){var statearr_21544 = state_21529;
(statearr_21544[(4)] = cljs.core.rest((state_21529[(4)])));

return statearr_21544;
})();
var state_21529__$1 = state_21529;
var ex21541 = (state_21529__$1[(2)]);
var statearr_21545_21561 = state_21529__$1;
(statearr_21545_21561[(5)] = ex21541);


var statearr_21546_21562 = state_21529__$1;
(statearr_21546_21562[(1)] = (4));

(statearr_21546_21562[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (10))){
var inst_21522 = (state_21529[(2)]);
var state_21529__$1 = state_21529;
var statearr_21547_21563 = state_21529__$1;
(statearr_21547_21563[(2)] = inst_21522);

(statearr_21547_21563[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21530 === (8))){
var inst_21505 = (state_21529[(10)]);
var state_21529__$1 = state_21529;
var statearr_21548_21564 = state_21529__$1;
(statearr_21548_21564[(2)] = inst_21505);

(statearr_21548_21564[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____0 = (function (){
var statearr_21549 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21549[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__);

(statearr_21549[(1)] = (1));

return statearr_21549;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____1 = (function (state_21529){
while(true){
var ret_value__11352__auto__ = (function (){try{while(true){
var result__11353__auto__ = switch__11350__auto__(state_21529);
if(cljs.core.keyword_identical_QMARK_(result__11353__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11353__auto__;
}
break;
}
}catch (e21550){var ex__11354__auto__ = e21550;
var statearr_21551_21565 = state_21529;
(statearr_21551_21565[(2)] = ex__11354__auto__);


if(cljs.core.seq((state_21529[(4)]))){
var statearr_21552_21566 = state_21529;
(statearr_21552_21566[(1)] = cljs.core.first((state_21529[(4)])));

} else {
throw ex__11354__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11352__auto__,cljs.core.cst$kw$recur)){
var G__21567 = state_21529;
state_21529 = G__21567;
continue;
} else {
return ret_value__11352__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__ = function(state_21529){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____1.call(this,state_21529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__11351__auto__;
})()
})();
var state__11390__auto__ = (function (){var statearr_21553 = (f__11389__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11389__auto__.cljs$core$IFn$_invoke$arity$0() : f__11389__auto__.call(null));
(statearr_21553[(6)] = c__11388__auto__);

return statearr_21553;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11390__auto__);
}));

return c__11388__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__11388__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__11389__auto__ = (function (){var switch__11350__auto__ = (function (state_21593){
var state_val_21594 = (state_21593[(1)]);
if((state_val_21594 === (7))){
var inst_21588 = (state_21593[(2)]);
var _ = (function (){var statearr_21595 = state_21593;
(statearr_21595[(4)] = cljs.core.rest((state_21593[(4)])));

return statearr_21595;
})();
var state_21593__$1 = state_21593;
var statearr_21596_21618 = state_21593__$1;
(statearr_21596_21618[(2)] = inst_21588);

(statearr_21596_21618[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (1))){
var state_21593__$1 = state_21593;
var statearr_21597_21619 = state_21593__$1;
(statearr_21597_21619[(2)] = null);

(statearr_21597_21619[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (4))){
var inst_21568 = (state_21593[(2)]);
var state_21593__$1 = state_21593;
var statearr_21598_21620 = state_21593__$1;
(statearr_21598_21620[(2)] = inst_21568);

(statearr_21598_21620[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (6))){
var state_21593__$1 = state_21593;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21593__$1,(8),chan);
} else {
if((state_val_21594 === (3))){
var inst_21591 = (state_21593[(2)]);
var state_21593__$1 = state_21593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21593__$1,inst_21591);
} else {
if((state_val_21594 === (2))){
var _ = (function (){var statearr_21599 = state_21593;
(statearr_21599[(4)] = cljs.core.cons((5),(state_21593[(4)])));

return statearr_21599;
})();
var inst_21574 = coll;
var inst_21575 = inst_21574;
var state_21593__$1 = (function (){var statearr_21600 = state_21593;
(statearr_21600[(7)] = inst_21575);

return statearr_21600;
})();
var statearr_21601_21621 = state_21593__$1;
(statearr_21601_21621[(2)] = null);

(statearr_21601_21621[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (11))){
var inst_21586 = (state_21593[(2)]);
var state_21593__$1 = state_21593;
var statearr_21603_21622 = state_21593__$1;
(statearr_21603_21622[(2)] = inst_21586);

(statearr_21603_21622[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (9))){
var inst_21575 = (state_21593[(7)]);
var state_21593__$1 = state_21593;
var statearr_21604_21623 = state_21593__$1;
(statearr_21604_21623[(2)] = inst_21575);

(statearr_21604_21623[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (5))){
var _ = (function (){var statearr_21605 = state_21593;
(statearr_21605[(4)] = cljs.core.rest((state_21593[(4)])));

return statearr_21605;
})();
var state_21593__$1 = state_21593;
var ex21602 = (state_21593__$1[(2)]);
var statearr_21606_21624 = state_21593__$1;
(statearr_21606_21624[(5)] = ex21602);


var statearr_21607_21625 = state_21593__$1;
(statearr_21607_21625[(1)] = (4));

(statearr_21607_21625[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (10))){
var inst_21579 = (state_21593[(8)]);
var inst_21575 = (state_21593[(7)]);
var inst_21583 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21575,inst_21579);
var inst_21575__$1 = inst_21583;
var state_21593__$1 = (function (){var statearr_21608 = state_21593;
(statearr_21608[(7)] = inst_21575__$1);

return statearr_21608;
})();
var statearr_21609_21626 = state_21593__$1;
(statearr_21609_21626[(2)] = null);

(statearr_21609_21626[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_21594 === (8))){
var inst_21579 = (state_21593[(8)]);
var inst_21578 = (state_21593[(2)]);
var inst_21579__$1 = fluree.db.util.async.throw_err(inst_21578);
var inst_21580 = (inst_21579__$1 == null);
var state_21593__$1 = (function (){var statearr_21610 = state_21593;
(statearr_21610[(8)] = inst_21579__$1);

return statearr_21610;
})();
if(cljs.core.truth_(inst_21580)){
var statearr_21611_21627 = state_21593__$1;
(statearr_21611_21627[(1)] = (9));

} else {
var statearr_21612_21628 = state_21593__$1;
(statearr_21612_21628[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____0 = (function (){
var statearr_21613 = [null,null,null,null,null,null,null,null,null];
(statearr_21613[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__);

(statearr_21613[(1)] = (1));

return statearr_21613;
});
var fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____1 = (function (state_21593){
while(true){
var ret_value__11352__auto__ = (function (){try{while(true){
var result__11353__auto__ = switch__11350__auto__(state_21593);
if(cljs.core.keyword_identical_QMARK_(result__11353__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__11353__auto__;
}
break;
}
}catch (e21614){var ex__11354__auto__ = e21614;
var statearr_21615_21629 = state_21593;
(statearr_21615_21629[(2)] = ex__11354__auto__);


if(cljs.core.seq((state_21593[(4)]))){
var statearr_21616_21630 = state_21593;
(statearr_21616_21630[(1)] = cljs.core.first((state_21593[(4)])));

} else {
throw ex__11354__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__11352__auto__,cljs.core.cst$kw$recur)){
var G__21631 = state_21593;
state_21593 = G__21631;
continue;
} else {
return ret_value__11352__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__ = function(state_21593){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____1.call(this,state_21593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__11351__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__11351__auto__;
})()
})();
var state__11390__auto__ = (function (){var statearr_21617 = (f__11389__auto__.cljs$core$IFn$_invoke$arity$0 ? f__11389__auto__.cljs$core$IFn$_invoke$arity$0() : f__11389__auto__.call(null));
(statearr_21617[(6)] = c__11388__auto__);

return statearr_21617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__11390__auto__);
}));

return c__11388__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
