// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34517_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34517_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__34521 = coll;
var vec__34522 = G__34521;
var seq__34523 = cljs.core.seq(vec__34522);
var first__34524 = cljs.core.first(seq__34523);
var seq__34523__$1 = cljs.core.next(seq__34523);
var clause = first__34524;
var r = seq__34523__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34521__$1 = G__34521;
var res__$1 = res;
while(true){
var vec__34528 = G__34521__$1;
var seq__34529 = cljs.core.seq(vec__34528);
var first__34530 = cljs.core.first(seq__34529);
var seq__34529__$1 = cljs.core.next(seq__34529);
var clause__$1 = first__34530;
var r__$1 = seq__34529__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34531 = r__$1;
var G__34532 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34521__$1 = G__34531;
res__$1 = G__34532;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__34536 = coll;
var vec__34537 = G__34536;
var seq__34538 = cljs.core.seq(vec__34537);
var first__34539 = cljs.core.first(seq__34538);
var seq__34538__$1 = cljs.core.next(seq__34538);
var clause = first__34539;
var r = seq__34538__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34536__$1 = G__34536;
var res__$1 = res;
while(true){
var vec__34543 = G__34536__$1;
var seq__34544 = cljs.core.seq(vec__34543);
var first__34545 = cljs.core.first(seq__34544);
var seq__34544__$1 = cljs.core.next(seq__34544);
var clause__$1 = first__34545;
var r__$1 = seq__34544__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34546 = r__$1;
var G__34547 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__34536__$1 = G__34546;
res__$1 = G__34547;
continue;
} else {
var G__34548 = r__$1;
var G__34549 = res__$2;
G__34536__$1 = G__34548;
res__$1 = G__34549;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__34553 = coll;
var vec__34554 = G__34553;
var seq__34555 = cljs.core.seq(vec__34554);
var first__34556 = cljs.core.first(seq__34555);
var seq__34555__$1 = cljs.core.next(seq__34555);
var clause = first__34556;
var r = seq__34555__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__34553__$1 = G__34553;
var res__$1 = res;
while(true){
var vec__34560 = G__34553__$1;
var seq__34561 = cljs.core.seq(vec__34560);
var first__34562 = cljs.core.first(seq__34561);
var seq__34561__$1 = cljs.core.next(seq__34561);
var clause__$1 = first__34562;
var r__$1 = seq__34561__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__34563 = r__$1;
var G__34564 = res__$2;
G__34553__$1 = G__34563;
res__$1 = G__34564;
continue;
} else {
var G__34565 = r__$1;
var G__34566 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__34553__$1 = G__34565;
res__$1 = G__34566;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__34570 = opts;
var map__34570__$1 = (((((!((map__34570 == null))))?(((((map__34570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34570.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34570):map__34570);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34570__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34570__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34570__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34570__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34570__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34567_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34567_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34568_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34568_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__34569_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__34569_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34585){
var state_val_34586 = (state_34585[(1)]);
if((state_val_34586 === (1))){
var inst_34572 = fluree.db.util.core.url_encode(query);
var inst_34573 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34572)].join('');
var inst_34574 = ["User-Agent","Accept"];
var inst_34575 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_34576 = cljs.core.PersistentHashMap.fromArrays(inst_34574,inst_34575);
var inst_34577 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_34578 = [inst_34576,(30000),cljs.core.cst$kw$wikidata];
var inst_34579 = cljs.core.PersistentHashMap.fromArrays(inst_34577,inst_34578);
var inst_34580 = fluree.db.util.xhttp.get(inst_34573,inst_34579);
var state_34585__$1 = state_34585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34585__$1,(2),inst_34580);
} else {
if((state_val_34586 === (2))){
var inst_34582 = (state_34585[(2)]);
var inst_34583 = fluree.db.util.async.throw_err(inst_34582);
var state_34585__$1 = state_34585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34585__$1,inst_34583);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____0 = (function (){
var statearr_34587 = [null,null,null,null,null,null,null];
(statearr_34587[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__);

(statearr_34587[(1)] = (1));

return statearr_34587;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____1 = (function (state_34585){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34585);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34588){var ex__16294__auto__ = e34588;
var statearr_34589_34592 = state_34585;
(statearr_34589_34592[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34585[(4)]))){
var statearr_34590_34593 = state_34585;
(statearr_34590_34593[(1)] = cljs.core.first((state_34585[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34594 = state_34585;
state_34585 = G__34594;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__ = function(state_34585){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____1.call(this,state_34585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34591 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34591[(6)] = c__16328__auto__);

return statearr_34591;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34612){
var state_val_34613 = (state_34612[(1)]);
if((state_val_34613 === (1))){
var inst_34595 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_34612__$1 = state_34612;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34612__$1,(2),inst_34595);
} else {
if((state_val_34613 === (2))){
var inst_34598 = (state_34612[(7)]);
var inst_34597 = (state_34612[(2)]);
var inst_34598__$1 = fluree.db.util.async.throw_err(inst_34597);
var inst_34599 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_34598__$1);
var inst_34600 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_34599);
var state_34612__$1 = (function (){var statearr_34614 = state_34612;
(statearr_34614[(7)] = inst_34598__$1);

return statearr_34614;
})();
if(inst_34600){
var statearr_34615_34624 = state_34612__$1;
(statearr_34615_34624[(1)] = (3));

} else {
var statearr_34616_34625 = state_34612__$1;
(statearr_34616_34625[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34613 === (3))){
var inst_34598 = (state_34612[(7)]);
var state_34612__$1 = state_34612;
var statearr_34617_34626 = state_34612__$1;
(statearr_34617_34626[(2)] = inst_34598);

(statearr_34617_34626[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34613 === (4))){
var inst_34598 = (state_34612[(7)]);
var inst_34603 = (function (){var body = inst_34598;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_34604 = cljs.core.second(inst_34598);
var inst_34605 = cljs.core.second(inst_34604);
var inst_34606 = cljs.core.first(inst_34605);
var inst_34607 = cljs.core.second(inst_34606);
var inst_34608 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34603,inst_34607);
var state_34612__$1 = state_34612;
var statearr_34618_34627 = state_34612__$1;
(statearr_34618_34627[(2)] = inst_34608);

(statearr_34618_34627[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34613 === (5))){
var inst_34610 = (state_34612[(2)]);
var state_34612__$1 = state_34612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34612__$1,inst_34610);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____0 = (function (){
var statearr_34619 = [null,null,null,null,null,null,null,null];
(statearr_34619[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__);

(statearr_34619[(1)] = (1));

return statearr_34619;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____1 = (function (state_34612){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34612);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34620){var ex__16294__auto__ = e34620;
var statearr_34621_34628 = state_34612;
(statearr_34621_34628[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34612[(4)]))){
var statearr_34622_34629 = state_34612;
(statearr_34622_34629[(1)] = cljs.core.first((state_34612[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34630 = state_34612;
state_34612 = G__34630;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__ = function(state_34612){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____1.call(this,state_34612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34623 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34623[(6)] = c__16328__auto__);

return statearr_34623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34631_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34631_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34632_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__34632_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34633_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__34633_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34633_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__34633_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_34699){
var state_val_34700 = (state_34699[(1)]);
if((state_val_34700 === (7))){
var inst_34644 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_34699__$1 = state_34699;
var statearr_34701_34742 = state_34699__$1;
(statearr_34701_34742[(2)] = inst_34644);

(statearr_34701_34742[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (20))){
var inst_34672 = (state_34699[(7)]);
var inst_34692 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_34672,all_vars);
var state_34699__$1 = state_34699;
var statearr_34702_34743 = state_34699__$1;
(statearr_34702_34743[(2)] = inst_34692);

(statearr_34702_34743[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (1))){
var state_34699__$1 = state_34699;
var statearr_34703_34744 = state_34699__$1;
(statearr_34703_34744[(2)] = null);

(statearr_34703_34744[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (24))){
var inst_34678 = (state_34699[(8)]);
var inst_34672 = (state_34699[(7)]);
var inst_34673 = (state_34699[(9)]);
var inst_34683 = (state_34699[(2)]);
var inst_34684 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_34678,(0),inst_34683);
var inst_34685 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34686 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_34672);
var inst_34687 = [inst_34673,inst_34686];
var inst_34688 = cljs.core.PersistentHashMap.fromArrays(inst_34685,inst_34687);
var inst_34689 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34684,inst_34688);
var inst_34690 = (function(){throw inst_34689})();
var state_34699__$1 = state_34699;
var statearr_34704_34745 = state_34699__$1;
(statearr_34704_34745[(2)] = inst_34690);

(statearr_34704_34745[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (4))){
var inst_34634 = (state_34699[(2)]);
var state_34699__$1 = state_34699;
var statearr_34705_34746 = state_34699__$1;
(statearr_34705_34746[(2)] = inst_34634);

(statearr_34705_34746[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (15))){
var inst_34664 = (state_34699[(2)]);
var state_34699__$1 = state_34699;
var statearr_34706_34747 = state_34699__$1;
(statearr_34706_34747[(2)] = inst_34664);

(statearr_34706_34747[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (21))){
var inst_34694 = (state_34699[(2)]);
var _ = (function (){var statearr_34707 = state_34699;
(statearr_34707[(4)] = cljs.core.rest((state_34699[(4)])));

return statearr_34707;
})();
var state_34699__$1 = state_34699;
var statearr_34708_34748 = state_34699__$1;
(statearr_34708_34748[(2)] = inst_34694);

(statearr_34708_34748[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (13))){
var state_34699__$1 = state_34699;
var statearr_34709_34749 = state_34699__$1;
(statearr_34709_34749[(2)] = true);

(statearr_34709_34749[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (22))){
var inst_34677 = (state_34699[(10)]);
var state_34699__$1 = state_34699;
var statearr_34710_34750 = state_34699__$1;
(statearr_34710_34750[(2)] = inst_34677);

(statearr_34710_34750[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (6))){
var state_34699__$1 = state_34699;
var statearr_34711_34751 = state_34699__$1;
(statearr_34711_34751[(2)] = null);

(statearr_34711_34751[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (17))){
var inst_34651 = (state_34699[(11)]);
var state_34699__$1 = state_34699;
var statearr_34712_34752 = state_34699__$1;
(statearr_34712_34752[(2)] = inst_34651);

(statearr_34712_34752[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (3))){
var inst_34697 = (state_34699[(2)]);
var state_34699__$1 = state_34699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34699__$1,inst_34697);
} else {
if((state_val_34700 === (12))){
var inst_34667 = (state_34699[(2)]);
var state_34699__$1 = state_34699;
if(cljs.core.truth_(inst_34667)){
var statearr_34713_34753 = state_34699__$1;
(statearr_34713_34753[(1)] = (16));

} else {
var statearr_34714_34754 = state_34699__$1;
(statearr_34714_34754[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (2))){
var _ = (function (){var statearr_34715 = state_34699;
(statearr_34715[(4)] = cljs.core.cons((5),(state_34699[(4)])));

return statearr_34715;
})();
var inst_34641 = cljs.core.empty_QMARK_(matching_vars);
var state_34699__$1 = state_34699;
if(inst_34641){
var statearr_34716_34755 = state_34699__$1;
(statearr_34716_34755[(1)] = (6));

} else {
var statearr_34717_34756 = state_34699__$1;
(statearr_34717_34756[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (23))){
var state_34699__$1 = state_34699;
var statearr_34718_34757 = state_34699__$1;
(statearr_34718_34757[(2)] = (1000));

(statearr_34718_34757[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (19))){
var inst_34677 = (state_34699[(10)]);
var inst_34674 = (state_34699[(12)]);
var inst_34672 = (state_34699[(7)]);
var inst_34677__$1 = cljs.core.count(inst_34674);
var inst_34678 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_34672);
var inst_34679 = (inst_34677__$1 < (1000));
var state_34699__$1 = (function (){var statearr_34719 = state_34699;
(statearr_34719[(10)] = inst_34677__$1);

(statearr_34719[(8)] = inst_34678);

return statearr_34719;
})();
if(cljs.core.truth_(inst_34679)){
var statearr_34720_34758 = state_34699__$1;
(statearr_34720_34758[(1)] = (22));

} else {
var statearr_34721_34759 = state_34699__$1;
(statearr_34721_34759[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (11))){
var state_34699__$1 = state_34699;
var statearr_34723_34760 = state_34699__$1;
(statearr_34723_34760[(2)] = false);

(statearr_34723_34760[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (9))){
var inst_34651 = (state_34699[(11)]);
var inst_34650 = (state_34699[(2)]);
var inst_34651__$1 = fluree.db.util.async.throw_err(inst_34650);
var inst_34653 = (inst_34651__$1 == null);
var inst_34654 = cljs.core.not(inst_34653);
var state_34699__$1 = (function (){var statearr_34724 = state_34699;
(statearr_34724[(11)] = inst_34651__$1);

return statearr_34724;
})();
if(inst_34654){
var statearr_34725_34761 = state_34699__$1;
(statearr_34725_34761[(1)] = (10));

} else {
var statearr_34726_34762 = state_34699__$1;
(statearr_34726_34762[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (5))){
var _ = (function (){var statearr_34727 = state_34699;
(statearr_34727[(4)] = cljs.core.rest((state_34699[(4)])));

return statearr_34727;
})();
var state_34699__$1 = state_34699;
var ex34722 = (state_34699__$1[(2)]);
var statearr_34728_34763 = state_34699__$1;
(statearr_34728_34763[(5)] = ex34722);


if((ex34722 instanceof Error)){
var statearr_34729_34764 = state_34699__$1;
(statearr_34729_34764[(1)] = (4));

(statearr_34729_34764[(5)] = null);

} else {
throw ex34722;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (14))){
var state_34699__$1 = state_34699;
var statearr_34730_34765 = state_34699__$1;
(statearr_34730_34765[(2)] = false);

(statearr_34730_34765[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (16))){
var inst_34651 = (state_34699[(11)]);
var inst_34669 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34651);
var state_34699__$1 = state_34699;
var statearr_34731_34766 = state_34699__$1;
(statearr_34731_34766[(2)] = inst_34669);

(statearr_34731_34766[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (10))){
var inst_34651 = (state_34699[(11)]);
var inst_34656 = inst_34651.cljs$lang$protocol_mask$partition0$;
var inst_34657 = (inst_34656 & (64));
var inst_34658 = inst_34651.cljs$core$ISeq$;
var inst_34659 = (cljs.core.PROTOCOL_SENTINEL === inst_34658);
var inst_34660 = ((inst_34657) || (inst_34659));
var state_34699__$1 = state_34699;
if(cljs.core.truth_(inst_34660)){
var statearr_34732_34767 = state_34699__$1;
(statearr_34732_34767[(1)] = (13));

} else {
var statearr_34733_34768 = state_34699__$1;
(statearr_34733_34768[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (18))){
var inst_34672 = (state_34699[(7)]);
var inst_34673 = (state_34699[(9)]);
var inst_34672__$1 = (state_34699[(2)]);
var inst_34673__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34672__$1,cljs.core.cst$kw$status);
var inst_34674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34672__$1,cljs.core.cst$kw$message);
var inst_34675 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_34673__$1);
var state_34699__$1 = (function (){var statearr_34734 = state_34699;
(statearr_34734[(12)] = inst_34674);

(statearr_34734[(7)] = inst_34672__$1);

(statearr_34734[(9)] = inst_34673__$1);

return statearr_34734;
})();
if(inst_34675){
var statearr_34735_34769 = state_34699__$1;
(statearr_34735_34769[(1)] = (19));

} else {
var statearr_34736_34770 = state_34699__$1;
(statearr_34736_34770[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34700 === (8))){
var inst_34646 = (state_34699[(2)]);
var inst_34647 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_34646,optional_clauses);
var inst_34648 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_34647);
var state_34699__$1 = state_34699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34699__$1,(9),inst_34648);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_34737 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34737[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__);

(statearr_34737[(1)] = (1));

return statearr_34737;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____1 = (function (state_34699){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_34699);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e34738){var ex__16294__auto__ = e34738;
var statearr_34739_34771 = state_34699;
(statearr_34739_34771[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_34699[(4)]))){
var statearr_34740_34772 = state_34699;
(statearr_34740_34772[(1)] = cljs.core.first((state_34699[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__34773 = state_34699;
state_34699 = G__34773;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__ = function(state_34699){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____1.call(this,state_34699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_34741 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_34741[(6)] = c__16328__auto__);

return statearr_34741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
