// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('alphabase.hex');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.bytes');
goog.require('clojure.string');
goog.require('clojure.set');
alphabase.hex.hex_chars = "0123456789ABCDEFabcdef";
alphabase.hex.hex_set = cljs.core.set("0123456789ABCDEFabcdef");
/**
 * Test if input is hex char set.
 */
alphabase.hex.hex_QMARK_ = (function alphabase$hex$hex_QMARK_(x){
return ((typeof x === 'string') && (clojure.set.subset_QMARK_(cljs.core.set(x),alphabase.hex.hex_set)));
});
/**
 * Converts a single byte value to a two-character hex string.
 */
alphabase.hex.byte__GT_hex = (function alphabase$hex$byte__GT_hex(value){
var hex = value.toString((16));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(hex))){
return ["0",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex)].join('');
} else {
return hex;
}
});
/**
 * Converts a two-character hex string into a byte value.
 */
alphabase.hex.hex__GT_byte = (function alphabase$hex$hex__GT_byte(hex){
return parseInt(hex,(16));
});
/**
 * Converts a byte array into a lowercase hexadecimal string. Returns nil for
 *   empty inputs.
 */
alphabase.hex.encode = (function alphabase$hex$encode(data){
if(cljs.core.truth_((function (){var and__4115__auto__ = data;
if(cljs.core.truth_(and__4115__auto__)){
return (data.length > (0));
} else {
return and__4115__auto__;
}
})())){
return clojure.string.lower_case(clojure.string.join.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(alphabase.hex.byte__GT_hex,alphabase.bytes.byte_seq(data))));
} else {
return null;
}
});
/**
 * Parses a hexadecimal string into a byte array. Ensures that the resulting
 *   array is zero-padded to match the hex string length.
 */
alphabase.hex.decode = (function alphabase$hex$decode(data){
if(cljs.core.empty_QMARK_(data)){
return null;
} else {
var length = (cljs.core.count(data) / (2));
var array = alphabase.bytes.byte_array(length);
var n__4613__auto___15749 = length;
var i_15750 = (0);
while(true){
if((i_15750 < n__4613__auto___15749)){
var hex_15751 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(data,((2) * i_15750),((2) * (i_15750 + (1))));
alphabase.bytes.set_byte(array,i_15750,alphabase.hex.hex__GT_byte(hex_15751));

var G__15752 = (i_15750 + (1));
i_15750 = G__15752;
continue;
} else {
}
break;
}

return array;
}
});
/**
 * Checks a string to determine whether it's well-formed hexadecimal. Returns
 *   an error string if the argument is invalid.
 */
alphabase.hex.validate = (function alphabase$hex$validate(value){
if((!(typeof value === 'string'))){
return ["Value is not a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([value], 0))].join('');
} else {
if(cljs.core.not(cljs.core.re_matches(/^[0-9a-fA-F]*$/,value))){
return ["String '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"' is not valid hex: ","contains illegal characters"].join('');
} else {
if((cljs.core.count(value) < (2))){
return "Hex string must contain at least one byte";
} else {
if(cljs.core.odd_QMARK_(cljs.core.count(value))){
return ["String '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"' is not valid hex: ","number of characters (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(value)),") is odd"].join('');
} else {
return null;

}
}
}
}
});
/**
 * Returns true if the string is valid hexadecimal.
 */
alphabase.hex.valid_QMARK_ = (function alphabase$hex$valid_QMARK_(value){
return (alphabase.hex.validate(value) == null);
});
