// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__26995_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__26995_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__26999 = coll;
var vec__27000 = G__26999;
var seq__27001 = cljs.core.seq.call(null,vec__27000);
var first__27002 = cljs.core.first.call(null,seq__27001);
var seq__27001__$1 = cljs.core.next.call(null,seq__27001);
var clause = first__27002;
var r = seq__27001__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__26999__$1 = G__26999;
var res__$1 = res;
while(true){
var vec__27006 = G__26999__$1;
var seq__27007 = cljs.core.seq.call(null,vec__27006);
var first__27008 = cljs.core.first.call(null,seq__27007);
var seq__27007__$1 = cljs.core.next.call(null,seq__27007);
var clause__$1 = first__27008;
var r__$1 = seq__27007__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__27009 = r__$1;
var G__27010 = cljs.core.conj.call(null,res__$2,clause__$1);
G__26999__$1 = G__27009;
res__$1 = G__27010;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__27014 = coll;
var vec__27015 = G__27014;
var seq__27016 = cljs.core.seq.call(null,vec__27015);
var first__27017 = cljs.core.first.call(null,seq__27016);
var seq__27016__$1 = cljs.core.next.call(null,seq__27016);
var clause = first__27017;
var r = seq__27016__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__27014__$1 = G__27014;
var res__$1 = res;
while(true){
var vec__27021 = G__27014__$1;
var seq__27022 = cljs.core.seq.call(null,vec__27021);
var first__27023 = cljs.core.first.call(null,seq__27022);
var seq__27022__$1 = cljs.core.next.call(null,seq__27022);
var clause__$1 = first__27023;
var r__$1 = seq__27022__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__27024 = r__$1;
var G__27025 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__27014__$1 = G__27024;
res__$1 = G__27025;
continue;
} else {
var G__27026 = r__$1;
var G__27027 = res__$2;
G__27014__$1 = G__27026;
res__$1 = G__27027;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__27031 = coll;
var vec__27032 = G__27031;
var seq__27033 = cljs.core.seq.call(null,vec__27032);
var first__27034 = cljs.core.first.call(null,seq__27033);
var seq__27033__$1 = cljs.core.next.call(null,seq__27033);
var clause = first__27034;
var r = seq__27033__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__27031__$1 = G__27031;
var res__$1 = res;
while(true){
var vec__27038 = G__27031__$1;
var seq__27039 = cljs.core.seq.call(null,vec__27038);
var first__27040 = cljs.core.first.call(null,seq__27039);
var seq__27039__$1 = cljs.core.next.call(null,seq__27039);
var clause__$1 = first__27040;
var r__$1 = seq__27039__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__27041 = r__$1;
var G__27042 = res__$2;
G__27031__$1 = G__27041;
res__$1 = G__27042;
continue;
} else {
var G__27043 = r__$1;
var G__27044 = cljs.core.conj.call(null,res__$2,clause__$1);
G__27031__$1 = G__27043;
res__$1 = G__27044;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__27048 = opts;
var map__27048__$1 = (((((!((map__27048 == null))))?(((((map__27048.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27048.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27048):map__27048);
var limit = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__27048__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__27045_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27045_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__27046_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__27046_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__27047_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__27047_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27063){
var state_val_27064 = (state_27063[(1)]);
if((state_val_27064 === (1))){
var inst_27050 = fluree.db.util.core.url_encode.call(null,query);
var inst_27051 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27050)].join('');
var inst_27052 = ["User-Agent","Accept"];
var inst_27053 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_27054 = cljs.core.PersistentHashMap.fromArrays(inst_27052,inst_27053);
var inst_27055 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_27056 = [inst_27054,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_27057 = cljs.core.PersistentHashMap.fromArrays(inst_27055,inst_27056);
var inst_27058 = fluree.db.util.xhttp.get.call(null,inst_27051,inst_27057);
var state_27063__$1 = state_27063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27063__$1,(2),inst_27058);
} else {
if((state_val_27064 === (2))){
var inst_27060 = (state_27063[(2)]);
var inst_27061 = fluree.db.util.async.throw_err.call(null,inst_27060);
var state_27063__$1 = state_27063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27063__$1,inst_27061);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____0 = (function (){
var statearr_27065 = [null,null,null,null,null,null,null];
(statearr_27065[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__);

(statearr_27065[(1)] = (1));

return statearr_27065;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____1 = (function (state_27063){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27066){var ex__11472__auto__ = e27066;
var statearr_27067_27070 = state_27063;
(statearr_27067_27070[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27063[(4)]))){
var statearr_27068_27071 = state_27063;
(statearr_27068_27071[(1)] = cljs.core.first.call(null,(state_27063[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27072 = state_27063;
state_27063 = G__27072;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__ = function(state_27063){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____1.call(this,state_27063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27069 = f__11543__auto__.call(null);
(statearr_27069[(6)] = c__11542__auto__);

return statearr_27069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27090){
var state_val_27091 = (state_27090[(1)]);
if((state_val_27091 === (1))){
var inst_27073 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_27090__$1 = state_27090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27090__$1,(2),inst_27073);
} else {
if((state_val_27091 === (2))){
var inst_27076 = (state_27090[(7)]);
var inst_27075 = (state_27090[(2)]);
var inst_27076__$1 = fluree.db.util.async.throw_err.call(null,inst_27075);
var inst_27077 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27076__$1);
var inst_27078 = cljs.core.not_EQ_.call(null,(200),inst_27077);
var state_27090__$1 = (function (){var statearr_27092 = state_27090;
(statearr_27092[(7)] = inst_27076__$1);

return statearr_27092;
})();
if(inst_27078){
var statearr_27093_27102 = state_27090__$1;
(statearr_27093_27102[(1)] = (3));

} else {
var statearr_27094_27103 = state_27090__$1;
(statearr_27094_27103[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (3))){
var inst_27076 = (state_27090[(7)]);
var state_27090__$1 = state_27090;
var statearr_27095_27104 = state_27090__$1;
(statearr_27095_27104[(2)] = inst_27076);

(statearr_27095_27104[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (4))){
var inst_27076 = (state_27090[(7)]);
var inst_27081 = (function (){var body = inst_27076;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_27082 = cljs.core.second.call(null,inst_27076);
var inst_27083 = cljs.core.second.call(null,inst_27082);
var inst_27084 = cljs.core.first.call(null,inst_27083);
var inst_27085 = cljs.core.second.call(null,inst_27084);
var inst_27086 = cljs.core.mapv.call(null,inst_27081,inst_27085);
var state_27090__$1 = state_27090;
var statearr_27096_27105 = state_27090__$1;
(statearr_27096_27105[(2)] = inst_27086);

(statearr_27096_27105[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27091 === (5))){
var inst_27088 = (state_27090[(2)]);
var state_27090__$1 = state_27090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27090__$1,inst_27088);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____0 = (function (){
var statearr_27097 = [null,null,null,null,null,null,null,null];
(statearr_27097[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__);

(statearr_27097[(1)] = (1));

return statearr_27097;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____1 = (function (state_27090){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27098){var ex__11472__auto__ = e27098;
var statearr_27099_27106 = state_27090;
(statearr_27099_27106[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27090[(4)]))){
var statearr_27100_27107 = state_27090;
(statearr_27100_27107[(1)] = cljs.core.first.call(null,(state_27090[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27108 = state_27090;
state_27090 = G__27108;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__ = function(state_27090){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____1.call(this,state_27090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27101 = f__11543__auto__.call(null);
(statearr_27101[(6)] = c__11542__auto__);

return statearr_27101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__27109_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27109_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__27110_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__27110_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__27111_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__27111_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_27177){
var state_val_27178 = (state_27177[(1)]);
if((state_val_27178 === (7))){
var inst_27122 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_27177__$1 = state_27177;
var statearr_27179_27220 = state_27177__$1;
(statearr_27179_27220[(2)] = inst_27122);

(statearr_27179_27220[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (20))){
var inst_27150 = (state_27177[(7)]);
var inst_27170 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_27150,all_vars);
var state_27177__$1 = state_27177;
var statearr_27180_27221 = state_27177__$1;
(statearr_27180_27221[(2)] = inst_27170);

(statearr_27180_27221[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (1))){
var state_27177__$1 = state_27177;
var statearr_27181_27222 = state_27177__$1;
(statearr_27181_27222[(2)] = null);

(statearr_27181_27222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (24))){
var inst_27151 = (state_27177[(8)]);
var inst_27150 = (state_27177[(7)]);
var inst_27156 = (state_27177[(9)]);
var inst_27161 = (state_27177[(2)]);
var inst_27162 = cljs.core.subs.call(null,inst_27156,(0),inst_27161);
var inst_27163 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27164 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_27150);
var inst_27165 = [inst_27151,inst_27164];
var inst_27166 = cljs.core.PersistentHashMap.fromArrays(inst_27163,inst_27165);
var inst_27167 = cljs.core.ex_info.call(null,inst_27162,inst_27166);
var inst_27168 = (function(){throw inst_27167})();
var state_27177__$1 = state_27177;
var statearr_27182_27223 = state_27177__$1;
(statearr_27182_27223[(2)] = inst_27168);

(statearr_27182_27223[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (4))){
var inst_27112 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
var statearr_27183_27224 = state_27177__$1;
(statearr_27183_27224[(2)] = inst_27112);

(statearr_27183_27224[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (15))){
var inst_27142 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
var statearr_27184_27225 = state_27177__$1;
(statearr_27184_27225[(2)] = inst_27142);

(statearr_27184_27225[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (21))){
var inst_27172 = (state_27177[(2)]);
var _ = (function (){var statearr_27185 = state_27177;
(statearr_27185[(4)] = cljs.core.rest.call(null,(state_27177[(4)])));

return statearr_27185;
})();
var state_27177__$1 = state_27177;
var statearr_27186_27226 = state_27177__$1;
(statearr_27186_27226[(2)] = inst_27172);

(statearr_27186_27226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (13))){
var state_27177__$1 = state_27177;
var statearr_27187_27227 = state_27177__$1;
(statearr_27187_27227[(2)] = true);

(statearr_27187_27227[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (22))){
var inst_27155 = (state_27177[(10)]);
var state_27177__$1 = state_27177;
var statearr_27188_27228 = state_27177__$1;
(statearr_27188_27228[(2)] = inst_27155);

(statearr_27188_27228[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (6))){
var state_27177__$1 = state_27177;
var statearr_27189_27229 = state_27177__$1;
(statearr_27189_27229[(2)] = null);

(statearr_27189_27229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (17))){
var inst_27129 = (state_27177[(11)]);
var state_27177__$1 = state_27177;
var statearr_27190_27230 = state_27177__$1;
(statearr_27190_27230[(2)] = inst_27129);

(statearr_27190_27230[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (3))){
var inst_27175 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27177__$1,inst_27175);
} else {
if((state_val_27178 === (12))){
var inst_27145 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
if(cljs.core.truth_(inst_27145)){
var statearr_27191_27231 = state_27177__$1;
(statearr_27191_27231[(1)] = (16));

} else {
var statearr_27192_27232 = state_27177__$1;
(statearr_27192_27232[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (2))){
var _ = (function (){var statearr_27193 = state_27177;
(statearr_27193[(4)] = cljs.core.cons.call(null,(5),(state_27177[(4)])));

return statearr_27193;
})();
var inst_27119 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_27177__$1 = state_27177;
if(inst_27119){
var statearr_27194_27233 = state_27177__$1;
(statearr_27194_27233[(1)] = (6));

} else {
var statearr_27195_27234 = state_27177__$1;
(statearr_27195_27234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (23))){
var state_27177__$1 = state_27177;
var statearr_27196_27235 = state_27177__$1;
(statearr_27196_27235[(2)] = (1000));

(statearr_27196_27235[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (19))){
var inst_27155 = (state_27177[(10)]);
var inst_27150 = (state_27177[(7)]);
var inst_27152 = (state_27177[(12)]);
var inst_27155__$1 = cljs.core.count.call(null,inst_27152);
var inst_27156 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_27150);
var inst_27157 = (inst_27155__$1 < (1000));
var state_27177__$1 = (function (){var statearr_27197 = state_27177;
(statearr_27197[(10)] = inst_27155__$1);

(statearr_27197[(9)] = inst_27156);

return statearr_27197;
})();
if(cljs.core.truth_(inst_27157)){
var statearr_27198_27236 = state_27177__$1;
(statearr_27198_27236[(1)] = (22));

} else {
var statearr_27199_27237 = state_27177__$1;
(statearr_27199_27237[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (11))){
var state_27177__$1 = state_27177;
var statearr_27201_27238 = state_27177__$1;
(statearr_27201_27238[(2)] = false);

(statearr_27201_27238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (9))){
var inst_27129 = (state_27177[(11)]);
var inst_27128 = (state_27177[(2)]);
var inst_27129__$1 = fluree.db.util.async.throw_err.call(null,inst_27128);
var inst_27131 = (inst_27129__$1 == null);
var inst_27132 = cljs.core.not.call(null,inst_27131);
var state_27177__$1 = (function (){var statearr_27202 = state_27177;
(statearr_27202[(11)] = inst_27129__$1);

return statearr_27202;
})();
if(inst_27132){
var statearr_27203_27239 = state_27177__$1;
(statearr_27203_27239[(1)] = (10));

} else {
var statearr_27204_27240 = state_27177__$1;
(statearr_27204_27240[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (5))){
var _ = (function (){var statearr_27205 = state_27177;
(statearr_27205[(4)] = cljs.core.rest.call(null,(state_27177[(4)])));

return statearr_27205;
})();
var state_27177__$1 = state_27177;
var ex27200 = (state_27177__$1[(2)]);
var statearr_27206_27241 = state_27177__$1;
(statearr_27206_27241[(5)] = ex27200);


if((ex27200 instanceof Error)){
var statearr_27207_27242 = state_27177__$1;
(statearr_27207_27242[(1)] = (4));

(statearr_27207_27242[(5)] = null);

} else {
throw ex27200;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (14))){
var state_27177__$1 = state_27177;
var statearr_27208_27243 = state_27177__$1;
(statearr_27208_27243[(2)] = false);

(statearr_27208_27243[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (16))){
var inst_27129 = (state_27177[(11)]);
var inst_27147 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27129);
var state_27177__$1 = state_27177;
var statearr_27209_27244 = state_27177__$1;
(statearr_27209_27244[(2)] = inst_27147);

(statearr_27209_27244[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (10))){
var inst_27129 = (state_27177[(11)]);
var inst_27134 = inst_27129.cljs$lang$protocol_mask$partition0$;
var inst_27135 = (inst_27134 & (64));
var inst_27136 = inst_27129.cljs$core$ISeq$;
var inst_27137 = (cljs.core.PROTOCOL_SENTINEL === inst_27136);
var inst_27138 = ((inst_27135) || (inst_27137));
var state_27177__$1 = state_27177;
if(cljs.core.truth_(inst_27138)){
var statearr_27210_27245 = state_27177__$1;
(statearr_27210_27245[(1)] = (13));

} else {
var statearr_27211_27246 = state_27177__$1;
(statearr_27211_27246[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (18))){
var inst_27151 = (state_27177[(8)]);
var inst_27150 = (state_27177[(7)]);
var inst_27150__$1 = (state_27177[(2)]);
var inst_27151__$1 = cljs.core.get.call(null,inst_27150__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_27152 = cljs.core.get.call(null,inst_27150__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_27153 = cljs.core._EQ_.call(null,(400),inst_27151__$1);
var state_27177__$1 = (function (){var statearr_27212 = state_27177;
(statearr_27212[(8)] = inst_27151__$1);

(statearr_27212[(7)] = inst_27150__$1);

(statearr_27212[(12)] = inst_27152);

return statearr_27212;
})();
if(inst_27153){
var statearr_27213_27247 = state_27177__$1;
(statearr_27213_27247[(1)] = (19));

} else {
var statearr_27214_27248 = state_27177__$1;
(statearr_27214_27248[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (8))){
var inst_27124 = (state_27177[(2)]);
var inst_27125 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_27124,optional_clauses);
var inst_27126 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_27125);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27177__$1,(9),inst_27126);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____0 = (function (){
var statearr_27215 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27215[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__);

(statearr_27215[(1)] = (1));

return statearr_27215;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____1 = (function (state_27177){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_27177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e27216){var ex__11472__auto__ = e27216;
var statearr_27217_27249 = state_27177;
(statearr_27217_27249[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_27177[(4)]))){
var statearr_27218_27250 = state_27177;
(statearr_27218_27250[(1)] = cljs.core.first.call(null,(state_27177[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27251 = state_27177;
state_27177 = G__27251;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__ = function(state_27177){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____1.call(this,state_27177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_27219 = f__11543__auto__.call(null);
(statearr_27219[(6)] = c__11542__auto__);

return statearr_27219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
