// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__36386 = arguments.length;
switch (G__36386) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.call(null,operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__36389 = arguments.length;
switch (G__36389) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.call(null,conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___36442 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36420){
var state_val_36421 = (state_36420[(1)]);
if((state_val_36421 === (1))){
var state_36420__$1 = state_36420;
var statearr_36422_36443 = state_36420__$1;
(statearr_36422_36443[(2)] = null);

(statearr_36422_36443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (2))){
var _ = (function (){var statearr_36423 = state_36420;
(statearr_36423[(4)] = cljs.core.cons.call(null,(5),(state_36420[(4)])));

return statearr_36423;
})();
var inst_36397 = fluree.db.operations.conn_closed_QMARK_.call(null,conn);
var state_36420__$1 = state_36420;
if(cljs.core.truth_(inst_36397)){
var statearr_36424_36444 = state_36420__$1;
(statearr_36424_36444[(1)] = (6));

} else {
var statearr_36425_36445 = state_36420__$1;
(statearr_36425_36445[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (3))){
var inst_36418 = (state_36420[(2)]);
var state_36420__$1 = state_36420;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36420__$1,inst_36418);
} else {
if((state_val_36421 === (4))){
var inst_36390 = (state_36420[(2)]);
var inst_36391 = cljs.core.async.put_BANG_.call(null,pc,inst_36390);
var state_36420__$1 = state_36420;
var statearr_36427_36446 = state_36420__$1;
(statearr_36427_36446[(2)] = inst_36391);

(statearr_36427_36446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (5))){
var _ = (function (){var statearr_36428 = state_36420;
(statearr_36428[(4)] = cljs.core.rest.call(null,(state_36420[(4)])));

return statearr_36428;
})();
var state_36420__$1 = state_36420;
var ex36426 = (state_36420__$1[(2)]);
var statearr_36429_36447 = state_36420__$1;
(statearr_36429_36447[(5)] = ex36426);


var statearr_36430_36448 = state_36420__$1;
(statearr_36430_36448[(1)] = (4));

(statearr_36430_36448[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (6))){
var inst_36399 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36400 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_36401 = cljs.core.PersistentHashMap.fromArrays(inst_36399,inst_36400);
var inst_36402 = cljs.core.ex_info.call(null,"Connection was closed.",inst_36401);
var inst_36403 = (function(){throw inst_36402})();
var state_36420__$1 = state_36420;
var statearr_36431_36449 = state_36420__$1;
(statearr_36431_36449[(2)] = inst_36403);

(statearr_36431_36449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (7))){
var inst_36405 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_36406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36407 = [operation,data,pc,opts];
var inst_36408 = (new cljs.core.PersistentVector(null,4,(5),inst_36406,inst_36407,null));
var inst_36409 = cljs.core.async.put_BANG_.call(null,inst_36405,inst_36408);
var inst_36410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36411 = [operation,data,pc,opts];
var inst_36412 = (new cljs.core.PersistentVector(null,4,(5),inst_36410,inst_36411,null));
var inst_36413 = fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_36412);
var state_36420__$1 = (function (){var statearr_36432 = state_36420;
(statearr_36432[(7)] = inst_36409);

return statearr_36432;
})();
var statearr_36433_36450 = state_36420__$1;
(statearr_36433_36450[(2)] = inst_36413);

(statearr_36433_36450[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36421 === (8))){
var inst_36415 = (state_36420[(2)]);
var _ = (function (){var statearr_36434 = state_36420;
(statearr_36434[(4)] = cljs.core.rest.call(null,(state_36420[(4)])));

return statearr_36434;
})();
var state_36420__$1 = state_36420;
var statearr_36435_36451 = state_36420__$1;
(statearr_36435_36451[(2)] = inst_36415);

(statearr_36435_36451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__11469__auto__ = null;
var fluree$db$operations$state_machine__11469__auto____0 = (function (){
var statearr_36436 = [null,null,null,null,null,null,null,null];
(statearr_36436[(0)] = fluree$db$operations$state_machine__11469__auto__);

(statearr_36436[(1)] = (1));

return statearr_36436;
});
var fluree$db$operations$state_machine__11469__auto____1 = (function (state_36420){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36420);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36437){var ex__11472__auto__ = e36437;
var statearr_36438_36452 = state_36420;
(statearr_36438_36452[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36420[(4)]))){
var statearr_36439_36453 = state_36420;
(statearr_36439_36453[(1)] = cljs.core.first.call(null,(state_36420[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36454 = state_36420;
state_36420 = G__36454;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11469__auto__ = function(state_36420){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11469__auto____1.call(this,state_36420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11469__auto____0;
fluree$db$operations$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11469__auto____1;
return fluree$db$operations$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36440 = f__11543__auto__.call(null);
(statearr_36440[(6)] = c__11542__auto___36442);

return statearr_36440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__36456 = arguments.length;
switch (G__36456) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.call(null,session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__36457){
var map__36458 = p__36457;
var map__36458__$1 = (((((!((map__36458 == null))))?(((((map__36458.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36458.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36458):map__36458);
var opts = map__36458__$1;
var snapshot_QMARK_ = cljs.core.get.call(null,map__36458__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__36460 = session;
var map__36460__$1 = (((((!((map__36460 == null))))?(((((map__36460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36460.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36460):map__36460);
var dbid = cljs.core.get.call(null,map__36460__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.call(null,map__36460__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__36460__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4742__auto__ = [];
var len__4736__auto___36522 = arguments.length;
var i__4737__auto___36523 = (0);
while(true){
if((i__4737__auto___36523 < len__4736__auto___36522)){
args__4742__auto__.push((arguments[i__4737__auto___36523]));

var G__36524 = (i__4737__auto___36523 + (1));
i__4737__auto___36523 = G__36524;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__36465){
var vec__36466 = p__36465;
var map__36469 = cljs.core.nth.call(null,vec__36466,(0),null);
var map__36469__$1 = (((((!((map__36469 == null))))?(((((map__36469.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36469.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36469):map__36469);
var toBlock = cljs.core.get.call(null,map__36469__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.call(null,map__36469__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__36466;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36502){
var state_val_36503 = (state_36502[(1)]);
if((state_val_36503 === (7))){
var inst_36485 = (state_36502[(2)]);
var state_36502__$1 = state_36502;
var statearr_36504_36525 = state_36502__$1;
(statearr_36504_36525[(2)] = inst_36485);

(statearr_36504_36525[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (1))){
var inst_36472 = (state_36502[(7)]);
var inst_36472__$1 = session;
var inst_36474 = (inst_36472__$1 == null);
var inst_36475 = cljs.core.not.call(null,inst_36474);
var state_36502__$1 = (function (){var statearr_36505 = state_36502;
(statearr_36505[(7)] = inst_36472__$1);

return statearr_36505;
})();
if(inst_36475){
var statearr_36506_36526 = state_36502__$1;
(statearr_36506_36526[(1)] = (2));

} else {
var statearr_36507_36527 = state_36502__$1;
(statearr_36507_36527[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (4))){
var inst_36488 = (state_36502[(2)]);
var state_36502__$1 = state_36502;
if(cljs.core.truth_(inst_36488)){
var statearr_36508_36528 = state_36502__$1;
(statearr_36508_36528[(1)] = (8));

} else {
var statearr_36509_36529 = state_36502__$1;
(statearr_36509_36529[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (6))){
var state_36502__$1 = state_36502;
var statearr_36510_36530 = state_36502__$1;
(statearr_36510_36530[(2)] = false);

(statearr_36510_36530[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (3))){
var state_36502__$1 = state_36502;
var statearr_36511_36531 = state_36502__$1;
(statearr_36511_36531[(2)] = false);

(statearr_36511_36531[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (2))){
var inst_36472 = (state_36502[(7)]);
var inst_36477 = inst_36472.cljs$lang$protocol_mask$partition0$;
var inst_36478 = (inst_36477 & (64));
var inst_36479 = inst_36472.cljs$core$ISeq$;
var inst_36480 = (cljs.core.PROTOCOL_SENTINEL === inst_36479);
var inst_36481 = ((inst_36478) || (inst_36480));
var state_36502__$1 = state_36502;
if(cljs.core.truth_(inst_36481)){
var statearr_36512_36532 = state_36502__$1;
(statearr_36512_36532[(1)] = (5));

} else {
var statearr_36513_36533 = state_36502__$1;
(statearr_36513_36533[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (9))){
var inst_36472 = (state_36502[(7)]);
var state_36502__$1 = state_36502;
var statearr_36514_36534 = state_36502__$1;
(statearr_36514_36534[(2)] = inst_36472);

(statearr_36514_36534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (5))){
var state_36502__$1 = state_36502;
var statearr_36515_36535 = state_36502__$1;
(statearr_36515_36535[(2)] = true);

(statearr_36515_36535[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36503 === (10))){
var inst_36493 = (state_36502[(2)]);
var inst_36494 = cljs.core.get.call(null,inst_36493,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_36495 = cljs.core.get.call(null,inst_36493,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_36496 = cljs.core.get.call(null,inst_36493,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_36497 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_36498 = [inst_36494,inst_36495,toBlock,toTime];
var inst_36499 = cljs.core.PersistentHashMap.fromArrays(inst_36497,inst_36498);
var inst_36500 = fluree.db.operations.send_operation.call(null,inst_36496,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_36499);
var state_36502__$1 = state_36502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36502__$1,inst_36500);
} else {
if((state_val_36503 === (8))){
var inst_36472 = (state_36502[(7)]);
var inst_36490 = cljs.core.apply.call(null,cljs.core.hash_map,inst_36472);
var state_36502__$1 = state_36502;
var statearr_36516_36536 = state_36502__$1;
(statearr_36516_36536[(2)] = inst_36490);

(statearr_36516_36536[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__11469__auto__ = null;
var fluree$db$operations$state_machine__11469__auto____0 = (function (){
var statearr_36517 = [null,null,null,null,null,null,null,null];
(statearr_36517[(0)] = fluree$db$operations$state_machine__11469__auto__);

(statearr_36517[(1)] = (1));

return statearr_36517;
});
var fluree$db$operations$state_machine__11469__auto____1 = (function (state_36502){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36518){var ex__11472__auto__ = e36518;
var statearr_36519_36537 = state_36502;
(statearr_36519_36537[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36502[(4)]))){
var statearr_36520_36538 = state_36502;
(statearr_36520_36538[(1)] = cljs.core.first.call(null,(state_36502[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36539 = state_36502;
state_36502 = G__36539;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$operations$state_machine__11469__auto__ = function(state_36502){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__11469__auto____1.call(this,state_36502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__11469__auto____0;
fluree$db$operations$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__11469__auto____1;
return fluree$db$operations$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36521 = f__11543__auto__.call(null);
(statearr_36521[(6)] = c__11542__auto__);

return statearr_36521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq36463){
var G__36464 = cljs.core.first.call(null,seq36463);
var seq36463__$1 = cljs.core.next.call(null,seq36463);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36464,seq36463__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__36540 = session;
var map__36540__$1 = (((((!((map__36540 == null))))?(((((map__36540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36540.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36540):map__36540);
var network = cljs.core.get.call(null,map__36540__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__36540__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.call(null,map__36540__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map);

return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__36543 = arguments.length;
switch (G__36543) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.call(null,session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__36544 = opts;
var map__36544__$1 = (((((!((map__36544 == null))))?(((((map__36544.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__36544.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__36544):map__36544);
var auth = cljs.core.get.call(null,map__36544__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__36544__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4126__auto__ = auth;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.call(null,"Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
