// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38913 = arguments.length;
var i__4737__auto___38914 = (0);
while(true){
if((i__4737__auto___38914 < len__4736__auto___38913)){
args__4742__auto__.push((arguments[i__4737__auto___38914]));

var G__38915 = (i__4737__auto___38914 + (1));
i__4737__auto___38914 = G__38915;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq38910){
var G__38911 = cljs.core.first.call(null,seq38910);
var seq38910__$1 = cljs.core.next.call(null,seq38910);
var G__38912 = cljs.core.first.call(null,seq38910__$1);
var seq38910__$2 = cljs.core.next.call(null,seq38910__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38911,G__38912,seq38910__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e38916){var e = e38916;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e38917){var e = e38917;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e38918){var e = e38918;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e38919){var e = e38919;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e38920){var e = e38920;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38923 = arguments.length;
var i__4737__auto___38924 = (0);
while(true){
if((i__4737__auto___38924 < len__4736__auto___38923)){
args__4742__auto__.push((arguments[i__4737__auto___38924]));

var G__38925 = (i__4737__auto___38924 + (1));
i__4737__auto___38924 = G__38925;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38922){var e = e38922;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq38921){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38921));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38928 = arguments.length;
var i__4737__auto___38929 = (0);
while(true){
if((i__4737__auto___38929 < len__4736__auto___38928)){
args__4742__auto__.push((arguments[i__4737__auto___38929]));

var G__38930 = (i__4737__auto___38929 + (1));
i__4737__auto___38929 = G__38930;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e38927){var e = e38927;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq38926){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38926));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e38931){var e = e38931;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38934 = arguments.length;
var i__4737__auto___38935 = (0);
while(true){
if((i__4737__auto___38935 < len__4736__auto___38934)){
args__4742__auto__.push((arguments[i__4737__auto___38935]));

var G__38936 = (i__4737__auto___38935 + (1));
i__4737__auto___38935 = G__38936;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e38933){var e = e38933;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq38932){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38932));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38939 = arguments.length;
var i__4737__auto___38940 = (0);
while(true){
if((i__4737__auto___38940 < len__4736__auto___38939)){
args__4742__auto__.push((arguments[i__4737__auto___38940]));

var G__38941 = (i__4737__auto___38940 + (1));
i__4737__auto___38940 = G__38941;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e38938){var e = e38938;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq38937){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38937));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e38942){var e = e38942;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e38943){var e = e38943;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38946 = arguments.length;
var i__4737__auto___38947 = (0);
while(true){
if((i__4737__auto___38947 < len__4736__auto___38946)){
args__4742__auto__.push((arguments[i__4737__auto___38947]));

var G__38948 = (i__4737__auto___38947 + (1));
i__4737__auto___38947 = G__38948;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38945){var e = e38945;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq38944){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38944));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38951 = arguments.length;
var i__4737__auto___38952 = (0);
while(true){
if((i__4737__auto___38952 < len__4736__auto___38951)){
args__4742__auto__.push((arguments[i__4737__auto___38952]));

var G__38953 = (i__4737__auto___38952 + (1));
i__4737__auto___38952 = G__38953;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e38950){var e = e38950;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq38949){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38949));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38956 = arguments.length;
var i__4737__auto___38957 = (0);
while(true){
if((i__4737__auto___38957 < len__4736__auto___38956)){
args__4742__auto__.push((arguments[i__4737__auto___38957]));

var G__38958 = (i__4737__auto___38957 + (1));
i__4737__auto___38957 = G__38958;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e38955){var e = e38955;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq38954){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38954));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38961 = arguments.length;
var i__4737__auto___38962 = (0);
while(true){
if((i__4737__auto___38962 < len__4736__auto___38961)){
args__4742__auto__.push((arguments[i__4737__auto___38962]));

var G__38963 = (i__4737__auto___38962 + (1));
i__4737__auto___38962 = G__38963;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e38960){var e = e38960;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq38959){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38959));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38966 = arguments.length;
var i__4737__auto___38967 = (0);
while(true){
if((i__4737__auto___38967 < len__4736__auto___38966)){
args__4742__auto__.push((arguments[i__4737__auto___38967]));

var G__38968 = (i__4737__auto___38967 + (1));
i__4737__auto___38967 = G__38968;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e38965){var e = e38965;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq38964){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38964));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38971 = arguments.length;
var i__4737__auto___38972 = (0);
while(true){
if((i__4737__auto___38972 < len__4736__auto___38971)){
args__4742__auto__.push((arguments[i__4737__auto___38972]));

var G__38973 = (i__4737__auto___38972 + (1));
i__4737__auto___38972 = G__38973;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e38970){var e = e38970;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq38969){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38969));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38976 = arguments.length;
var i__4737__auto___38977 = (0);
while(true){
if((i__4737__auto___38977 < len__4736__auto___38976)){
args__4742__auto__.push((arguments[i__4737__auto___38977]));

var G__38978 = (i__4737__auto___38977 + (1));
i__4737__auto___38977 = G__38978;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e38975){var e = e38975;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq38974){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38974));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__38980 = arguments.length;
switch (G__38980) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39008){
var state_val_39009 = (state_39008[(1)]);
if((state_val_39009 === (7))){
var inst_38993 = (state_39008[(7)]);
var inst_38996 = fluree.db.dbfunctions.internal.function_error.call(null,inst_38993,"query",query_map);
var state_39008__$1 = state_39008;
var statearr_39010_39096 = state_39008__$1;
(statearr_39010_39096[(2)] = inst_38996);

(statearr_39010_39096[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (1))){
var state_39008__$1 = state_39008;
var statearr_39011_39097 = state_39008__$1;
(statearr_39011_39097[(2)] = null);

(statearr_39011_39097[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (4))){
var inst_38981 = (state_39008[(2)]);
var state_39008__$1 = state_39008;
var statearr_39012_39098 = state_39008__$1;
(statearr_39012_39098[(2)] = inst_38981);

(statearr_39012_39098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (6))){
var inst_38993 = (state_39008[(7)]);
var inst_38993__$1 = (state_39008[(2)]);
var inst_38994 = fluree.db.util.core.exception_QMARK_.call(null,inst_38993__$1);
var state_39008__$1 = (function (){var statearr_39013 = state_39008;
(statearr_39013[(7)] = inst_38993__$1);

return statearr_39013;
})();
if(inst_38994){
var statearr_39014_39099 = state_39008__$1;
(statearr_39014_39099[(1)] = (7));

} else {
var statearr_39015_39100 = state_39008__$1;
(statearr_39015_39100[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (3))){
var inst_39006 = (state_39008[(2)]);
var state_39008__$1 = state_39008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39008__$1,inst_39006);
} else {
if((state_val_39009 === (2))){
var inst_38987 = (state_39008[(8)]);
var _ = (function (){var statearr_39017 = state_39008;
(statearr_39017[(4)] = cljs.core.cons.call(null,(5),(state_39008[(4)])));

return statearr_39017;
})();
var inst_38987__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_38988 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_38989 = cljs.core.assoc.call(null,inst_38988,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_38987__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_38990 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_38989);
var inst_38991 = fluree.db.query.fql.query.call(null,db,inst_38990);
var state_39008__$1 = (function (){var statearr_39018 = state_39008;
(statearr_39018[(8)] = inst_38987__$1);

return statearr_39018;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39008__$1,(6),inst_38991);
} else {
if((state_val_39009 === (9))){
var inst_39003 = (state_39008[(2)]);
var _ = (function (){var statearr_39019 = state_39008;
(statearr_39019[(4)] = cljs.core.rest.call(null,(state_39008[(4)])));

return statearr_39019;
})();
var state_39008__$1 = state_39008;
var statearr_39020_39101 = state_39008__$1;
(statearr_39020_39101[(2)] = inst_39003);

(statearr_39020_39101[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (5))){
var _ = (function (){var statearr_39021 = state_39008;
(statearr_39021[(4)] = cljs.core.rest.call(null,(state_39008[(4)])));

return statearr_39021;
})();
var state_39008__$1 = state_39008;
var ex39016 = (state_39008__$1[(2)]);
var statearr_39022_39102 = state_39008__$1;
(statearr_39022_39102[(5)] = ex39016);


if((ex39016 instanceof Error)){
var statearr_39023_39103 = state_39008__$1;
(statearr_39023_39103[(1)] = (4));

(statearr_39023_39103[(5)] = null);

} else {
throw ex39016;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39009 === (8))){
var inst_38993 = (state_39008[(7)]);
var inst_38987 = (state_39008[(8)]);
var inst_38998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38999 = cljs.core.deref.call(null,inst_38987);
var inst_39000 = [inst_38993,inst_38999];
var inst_39001 = (new cljs.core.PersistentVector(null,2,(5),inst_38998,inst_39000,null));
var state_39008__$1 = state_39008;
var statearr_39024_39104 = state_39008__$1;
(statearr_39024_39104[(2)] = inst_39001);

(statearr_39024_39104[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11469__auto____0 = (function (){
var statearr_39025 = [null,null,null,null,null,null,null,null,null];
(statearr_39025[(0)] = fluree$db$dbfunctions$internal$state_machine__11469__auto__);

(statearr_39025[(1)] = (1));

return statearr_39025;
});
var fluree$db$dbfunctions$internal$state_machine__11469__auto____1 = (function (state_39008){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39026){var ex__11472__auto__ = e39026;
var statearr_39027_39105 = state_39008;
(statearr_39027_39105[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39008[(4)]))){
var statearr_39028_39106 = state_39008;
(statearr_39028_39106[(1)] = cljs.core.first.call(null,(state_39008[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39107 = state_39008;
state_39008 = G__39107;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11469__auto__ = function(state_39008){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____1.call(this,state_39008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39029 = f__11543__auto__.call(null);
(statearr_39029[(6)] = c__11542__auto__);

return statearr_39029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39074){
var state_val_39075 = (state_39074[(1)]);
if((state_val_39075 === (7))){
var inst_39060 = (state_39074[(2)]);
var inst_39061 = fluree.db.query.fql.query.call(null,db,inst_39060);
var state_39074__$1 = state_39074;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39074__$1,(8),inst_39061);
} else {
if((state_val_39075 === (1))){
var inst_39030 = typeof select === 'string';
var state_39074__$1 = state_39074;
if(cljs.core.truth_(inst_39030)){
var statearr_39076_39108 = state_39074__$1;
(statearr_39076_39108[(1)] = (2));

} else {
var statearr_39077_39109 = state_39074__$1;
(statearr_39077_39109[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (4))){
var inst_39043 = (state_39074[(7)]);
var inst_39036 = (state_39074[(8)]);
var inst_39035 = (state_39074[(2)]);
var inst_39036__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_39037 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39038 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_39039 = [inst_39036__$1,(100000)];
var inst_39040 = cljs.core.PersistentHashMap.fromArrays(inst_39038,inst_39039);
var inst_39041 = [inst_39035,from,where,block,limit,inst_39040];
var inst_39042 = cljs.core.PersistentHashMap.fromArrays(inst_39037,inst_39041);
var inst_39043__$1 = fluree.db.util.core.without_nils.call(null,inst_39042);
var inst_39044 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39043__$1);
var inst_39045 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39043__$1);
var inst_39046 = cljs.core.first.call(null,inst_39045);
var inst_39047 = fluree.db.dbfunctions.internal.str.call(null,inst_39046);
var inst_39048 = cljs.core._EQ_.call(null,"[",inst_39047);
var inst_39049 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39043__$1);
var inst_39050 = cljs.core.last.call(null,inst_39049);
var inst_39051 = fluree.db.dbfunctions.internal.str.call(null,inst_39050);
var inst_39052 = cljs.core._EQ_.call(null,"]",inst_39051);
var inst_39053 = fluree.db.dbfunctions.internal.and.call(null,inst_39044,inst_39048,inst_39052);
var state_39074__$1 = (function (){var statearr_39078 = state_39074;
(statearr_39078[(7)] = inst_39043__$1);

(statearr_39078[(8)] = inst_39036__$1);

return statearr_39078;
})();
if(cljs.core.truth_(inst_39053)){
var statearr_39079_39110 = state_39074__$1;
(statearr_39079_39110[(1)] = (5));

} else {
var statearr_39080_39111 = state_39074__$1;
(statearr_39080_39111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (6))){
var inst_39043 = (state_39074[(7)]);
var state_39074__$1 = state_39074;
var statearr_39081_39112 = state_39074__$1;
(statearr_39081_39112[(2)] = inst_39043);

(statearr_39081_39112[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (3))){
var state_39074__$1 = state_39074;
var statearr_39082_39113 = state_39074__$1;
(statearr_39082_39113[(2)] = select);

(statearr_39082_39113[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (2))){
var inst_39032 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_39074__$1 = state_39074;
var statearr_39083_39114 = state_39074__$1;
(statearr_39083_39114[(2)] = inst_39032);

(statearr_39083_39114[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (11))){
var inst_39072 = (state_39074[(2)]);
var state_39074__$1 = state_39074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39074__$1,inst_39072);
} else {
if((state_val_39075 === (9))){
var inst_39063 = (state_39074[(9)]);
var state_39074__$1 = state_39074;
var statearr_39084_39115 = state_39074__$1;
(statearr_39084_39115[(2)] = inst_39063);

(statearr_39084_39115[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (5))){
var inst_39043 = (state_39074[(7)]);
var inst_39055 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_39043);
var inst_39056 = cljs.reader.read_string.call(null,inst_39055);
var inst_39057 = cljs.core.assoc.call(null,inst_39043,new cljs.core.Keyword(null,"where","where",-2044795965),inst_39056);
var state_39074__$1 = state_39074;
var statearr_39085_39116 = state_39074__$1;
(statearr_39085_39116[(2)] = inst_39057);

(statearr_39085_39116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (10))){
var inst_39063 = (state_39074[(9)]);
var inst_39036 = (state_39074[(8)]);
var inst_39067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39068 = cljs.core.deref.call(null,inst_39036);
var inst_39069 = [inst_39063,inst_39068];
var inst_39070 = (new cljs.core.PersistentVector(null,2,(5),inst_39067,inst_39069,null));
var state_39074__$1 = state_39074;
var statearr_39086_39117 = state_39074__$1;
(statearr_39086_39117[(2)] = inst_39070);

(statearr_39086_39117[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39075 === (8))){
var inst_39063 = (state_39074[(9)]);
var inst_39063__$1 = (state_39074[(2)]);
var inst_39064 = fluree.db.util.core.exception_QMARK_.call(null,inst_39063__$1);
var state_39074__$1 = (function (){var statearr_39087 = state_39074;
(statearr_39087[(9)] = inst_39063__$1);

return statearr_39087;
})();
if(inst_39064){
var statearr_39088_39118 = state_39074__$1;
(statearr_39088_39118[(1)] = (9));

} else {
var statearr_39089_39119 = state_39074__$1;
(statearr_39089_39119[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11469__auto____0 = (function (){
var statearr_39090 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39090[(0)] = fluree$db$dbfunctions$internal$state_machine__11469__auto__);

(statearr_39090[(1)] = (1));

return statearr_39090;
});
var fluree$db$dbfunctions$internal$state_machine__11469__auto____1 = (function (state_39074){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39091){var ex__11472__auto__ = e39091;
var statearr_39092_39120 = state_39074;
(statearr_39092_39120[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39074[(4)]))){
var statearr_39093_39121 = state_39074;
(statearr_39093_39121[(1)] = cljs.core.first.call(null,(state_39074[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39122 = state_39074;
state_39074 = G__39122;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11469__auto__ = function(state_39074){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____1.call(this,state_39074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39094 = f__11543__auto__.call(null);
(statearr_39094[(6)] = c__11542__auto__);

return statearr_39094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__39126 = path;
var vec__39127 = G__39126;
var seq__39128 = cljs.core.seq.call(null,vec__39127);
var first__39129 = cljs.core.first.call(null,seq__39128);
var seq__39128__$1 = cljs.core.next.call(null,seq__39128);
var var$ = first__39129;
var r = seq__39128__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__39126__$1 = G__39126;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__39133 = G__39126__$1;
var seq__39134 = cljs.core.seq.call(null,vec__39133);
var first__39135 = cljs.core.first.call(null,seq__39134);
var seq__39134__$1 = cljs.core.next.call(null,seq__39134);
var var$__$1 = first__39135;
var r__$1 = seq__39134__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__39136 = r__$1;
var G__39137 = n__$2;
var G__39138 = next_clauses;
G__39126__$1 = G__39136;
n__$1 = G__39137;
where_clauses__$1 = G__39138;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__39139 = r__$1;
var G__39140 = next_n;
var G__39141 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__39126__$1 = G__39139;
n__$1 = G__39140;
where_clauses__$1 = G__39141;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39178){
var state_val_39179 = (state_39178[(1)]);
if((state_val_39179 === (7))){
var inst_39151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39152 = [path];
var inst_39153 = (new cljs.core.PersistentVector(null,1,(5),inst_39151,inst_39152,null));
var state_39178__$1 = state_39178;
var statearr_39180_39208 = state_39178__$1;
(statearr_39180_39208[(2)] = inst_39153);

(statearr_39180_39208[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (1))){
var state_39178__$1 = state_39178;
var statearr_39181_39209 = state_39178__$1;
(statearr_39181_39209[(2)] = null);

(statearr_39181_39209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (4))){
var inst_39142 = (state_39178[(2)]);
var state_39178__$1 = state_39178;
var statearr_39182_39210 = state_39178__$1;
(statearr_39182_39210[(2)] = inst_39142);

(statearr_39182_39210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (13))){
var inst_39169 = (state_39178[(2)]);
var inst_39170 = fluree.db.util.async.throw_err.call(null,inst_39169);
var _ = (function (){var statearr_39183 = state_39178;
(statearr_39183[(4)] = cljs.core.rest.call(null,(state_39178[(4)])));

return statearr_39183;
})();
var state_39178__$1 = state_39178;
var statearr_39184_39211 = state_39178__$1;
(statearr_39184_39211[(2)] = inst_39170);

(statearr_39184_39211[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (6))){
var state_39178__$1 = state_39178;
var statearr_39186_39212 = state_39178__$1;
(statearr_39186_39212[(2)] = path);

(statearr_39186_39212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (3))){
var inst_39176 = (state_39178[(2)]);
var state_39178__$1 = state_39178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39178__$1,inst_39176);
} else {
if((state_val_39179 === (12))){
var _ = (function (){var statearr_39187 = state_39178;
(statearr_39187[(4)] = cljs.core.rest.call(null,(state_39178[(4)])));

return statearr_39187;
})();
var state_39178__$1 = state_39178;
var ex39185 = (state_39178__$1[(2)]);
var statearr_39188_39213 = state_39178__$1;
(statearr_39188_39213[(5)] = ex39185);


var statearr_39189_39214 = state_39178__$1;
(statearr_39189_39214[(1)] = (11));

(statearr_39189_39214[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (2))){
var _ = (function (){var statearr_39190 = state_39178;
(statearr_39190[(4)] = cljs.core.cons.call(null,(5),(state_39178[(4)])));

return statearr_39190;
})();
var inst_39148 = cljs.core.vector_QMARK_.call(null,path);
var state_39178__$1 = state_39178;
if(inst_39148){
var statearr_39191_39215 = state_39178__$1;
(statearr_39191_39215[(1)] = (6));

} else {
var statearr_39192_39216 = state_39178__$1;
(statearr_39192_39216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (11))){
var inst_39155 = (state_39178[(7)]);
var inst_39160 = (state_39178[(2)]);
var inst_39161 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39160,"relationship?",startSubject,inst_39155,endSubject);
var state_39178__$1 = state_39178;
var statearr_39194_39217 = state_39178__$1;
(statearr_39194_39217[(2)] = inst_39161);

(statearr_39194_39217[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (9))){
var inst_39159 = (state_39178[(8)]);
var _ = (function (){var statearr_39195 = state_39178;
(statearr_39195[(4)] = cljs.core.cons.call(null,(12),(state_39178[(4)])));

return statearr_39195;
})();
var inst_39167 = fluree.db.dbfunctions.internal.query.call(null,db,inst_39159);
var state_39178__$1 = state_39178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39178__$1,(13),inst_39167);
} else {
if((state_val_39179 === (5))){
var _ = (function (){var statearr_39196 = state_39178;
(statearr_39196[(4)] = cljs.core.rest.call(null,(state_39178[(4)])));

return statearr_39196;
})();
var state_39178__$1 = state_39178;
var ex39193 = (state_39178__$1[(2)]);
var statearr_39197_39218 = state_39178__$1;
(statearr_39197_39218[(5)] = ex39193);


if((ex39193 instanceof Error)){
var statearr_39198_39219 = state_39178__$1;
(statearr_39198_39219[(1)] = (4));

(statearr_39198_39219[(5)] = null);

} else {
throw ex39193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (10))){
var inst_39173 = (state_39178[(2)]);
var _ = (function (){var statearr_39199 = state_39178;
(statearr_39199[(4)] = cljs.core.rest.call(null,(state_39178[(4)])));

return statearr_39199;
})();
var state_39178__$1 = state_39178;
var statearr_39200_39220 = state_39178__$1;
(statearr_39200_39220[(2)] = inst_39173);

(statearr_39200_39220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39179 === (8))){
var inst_39155 = (state_39178[(7)]);
var inst_39155__$1 = (state_39178[(2)]);
var inst_39156 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_39155__$1,endSubject);
var inst_39157 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_39158 = ["?var1",inst_39156];
var inst_39159 = cljs.core.PersistentHashMap.fromArrays(inst_39157,inst_39158);
var state_39178__$1 = (function (){var statearr_39201 = state_39178;
(statearr_39201[(8)] = inst_39159);

(statearr_39201[(7)] = inst_39155__$1);

return statearr_39201;
})();
var statearr_39202_39221 = state_39178__$1;
(statearr_39202_39221[(2)] = null);

(statearr_39202_39221[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____0 = (function (){
var statearr_39203 = [null,null,null,null,null,null,null,null,null];
(statearr_39203[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__);

(statearr_39203[(1)] = (1));

return statearr_39203;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____1 = (function (state_39178){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39204){var ex__11472__auto__ = e39204;
var statearr_39205_39222 = state_39178;
(statearr_39205_39222[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39178[(4)]))){
var statearr_39206_39223 = state_39178;
(statearr_39206_39223[(1)] = cljs.core.first.call(null,(state_39178[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39224 = state_39178;
state_39178 = G__39224;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__ = function(state_39178){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____1.call(this,state_39178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39207 = f__11543__auto__.call(null);
(statearr_39207[(6)] = c__11542__auto__);

return statearr_39207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e39225){var e = e39225;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e39226){var e = e39226;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e39227){var e = e39227;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e39228){var e = e39228;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39231 = arguments.length;
var i__4737__auto___39232 = (0);
while(true){
if((i__4737__auto___39232 < len__4736__auto___39231)){
args__4742__auto__.push((arguments[i__4737__auto___39232]));

var G__39233 = (i__4737__auto___39232 + (1));
i__4737__auto___39232 = G__39233;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e39230){var e = e39230;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq39229){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39229));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39236 = arguments.length;
var i__4737__auto___39237 = (0);
while(true){
if((i__4737__auto___39237 < len__4736__auto___39236)){
args__4742__auto__.push((arguments[i__4737__auto___39237]));

var G__39238 = (i__4737__auto___39237 + (1));
i__4737__auto___39237 = G__39238;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e39235){var e = e39235;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq39234){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39234));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39241 = arguments.length;
var i__4737__auto___39242 = (0);
while(true){
if((i__4737__auto___39242 < len__4736__auto___39241)){
args__4742__auto__.push((arguments[i__4737__auto___39242]));

var G__39243 = (i__4737__auto___39242 + (1));
i__4737__auto___39242 = G__39243;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e39240){var e = e39240;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq39239){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39239));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39246 = arguments.length;
var i__4737__auto___39247 = (0);
while(true){
if((i__4737__auto___39247 < len__4736__auto___39246)){
args__4742__auto__.push((arguments[i__4737__auto___39247]));

var G__39248 = (i__4737__auto___39247 + (1));
i__4737__auto___39247 = G__39248;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e39245){var e = e39245;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq39244){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39244));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e39249){var e = e39249;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e39250){var e = e39250;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e39251){var e = e39251;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e39252){var e = e39252;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e39253){var e = e39253;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__39259 = path;
var vec__39260 = G__39259;
var seq__39261 = cljs.core.seq.call(null,vec__39260);
var first__39262 = cljs.core.first.call(null,seq__39261);
var seq__39261__$1 = cljs.core.next.call(null,seq__39261);
var pred = first__39262;
var r = seq__39261__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__39259__$1 = G__39259;
var subjects__$1 = subjects;
while(true){
var vec__39266 = G__39259__$1;
var seq__39267 = cljs.core.seq.call(null,vec__39266);
var first__39268 = cljs.core.first.call(null,seq__39267);
var seq__39267__$1 = cljs.core.next.call(null,seq__39267);
var pred__$1 = first__39268;
var r__$1 = seq__39267__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__39259__$1,subjects__$1,vec__39266,seq__39267,first__39268,seq__39267__$1,pred__$1,r__$1,subjects__$2,G__39259,vec__39260,seq__39261,first__39262,seq__39261__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__39259__$1,subjects__$1,vec__39266,seq__39267,first__39268,seq__39267__$1,pred__$1,r__$1,subjects__$2,G__39259,vec__39260,seq__39261,first__39262,seq__39261__$1,pred,r,subjects){
return (function (p1__39254_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__39254_SHARP_,pred__$1);
});})(G__39259__$1,subjects__$1,vec__39266,seq__39267,first__39268,seq__39267__$1,pred__$1,r__$1,subjects__$2,G__39259,vec__39260,seq__39261,first__39262,seq__39261__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__39259__$1,subjects__$1,vec__39266,seq__39267,first__39268,seq__39267__$1,pred__$1,r__$1,subjects__$2,G__39259,vec__39260,seq__39261,first__39262,seq__39261__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__39269 = r__$1;
var G__39270 = next_subjects;
G__39259__$1 = G__39269;
subjects__$1 = G__39270;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e39255){var e = e39255;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e39271){var e = e39271;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_.call(null,coll,key);
}catch (e39272){var e = e39272;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39275 = arguments.length;
var i__4737__auto___39276 = (0);
while(true){
if((i__4737__auto___39276 < len__4736__auto___39275)){
args__4742__auto__.push((arguments[i__4737__auto___39276]));

var G__39277 = (i__4737__auto___39276 + (1));
i__4737__auto___39276 = G__39277;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e39274){var e = e39274;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq39273){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39273));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e39278){var e = e39278;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___39281 = arguments.length;
var i__4737__auto___39282 = (0);
while(true){
if((i__4737__auto___39282 < len__4736__auto___39281)){
args__4742__auto__.push((arguments[i__4737__auto___39282]));

var G__39283 = (i__4737__auto___39282 + (1));
i__4737__auto___39282 = G__39283;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e39280){var e = e39280;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq39279){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq39279));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e39284){var e = e39284;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39339){
var state_val_39340 = (state_39339[(1)]);
if((state_val_39340 === (7))){
var inst_39286 = (state_39339[(2)]);
var state_39339__$1 = state_39339;
var statearr_39341_39374 = state_39339__$1;
(statearr_39341_39374[(2)] = inst_39286);

(statearr_39341_39374[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (1))){
var state_39339__$1 = state_39339;
var statearr_39342_39375 = state_39339__$1;
(statearr_39342_39375[(2)] = null);

(statearr_39342_39375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (4))){
var inst_39285 = (state_39339[(2)]);
var state_39339__$1 = (function (){var statearr_39343 = state_39339;
(statearr_39343[(7)] = inst_39285);

return statearr_39343;
})();
var statearr_39344_39376 = state_39339__$1;
(statearr_39344_39376[(2)] = null);

(statearr_39344_39376[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (15))){
var inst_39323 = (state_39339[(8)]);
var inst_39327 = inst_39323.o;
var state_39339__$1 = state_39339;
var statearr_39345_39377 = state_39339__$1;
(statearr_39345_39377[(2)] = inst_39327);

(statearr_39345_39377[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (13))){
var inst_39323 = (state_39339[(8)]);
var inst_39319 = (state_39339[(2)]);
var inst_39320 = fluree.db.util.async.throw_err.call(null,inst_39319);
var inst_39321 = fluree.db.dbfunctions.internal.count.call(null,inst_39320);
var inst_39323__$1 = cljs.core.first.call(null,inst_39320);
var inst_39324 = (inst_39323__$1 == null);
var state_39339__$1 = (function (){var statearr_39346 = state_39339;
(statearr_39346[(9)] = inst_39321);

(statearr_39346[(8)] = inst_39323__$1);

return statearr_39346;
})();
if(cljs.core.truth_(inst_39324)){
var statearr_39347_39378 = state_39339__$1;
(statearr_39347_39378[(1)] = (14));

} else {
var statearr_39348_39379 = state_39339__$1;
(statearr_39348_39379[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (6))){
var inst_39295 = (state_39339[(2)]);
var state_39339__$1 = state_39339;
var statearr_39349_39380 = state_39339__$1;
(statearr_39349_39380[(2)] = inst_39295);

(statearr_39349_39380[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (3))){
var inst_39337 = (state_39339[(2)]);
var state_39339__$1 = state_39339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39339__$1,inst_39337);
} else {
if((state_val_39340 === (12))){
var inst_39334 = (state_39339[(2)]);
var _ = (function (){var statearr_39350 = state_39339;
(statearr_39350[(4)] = cljs.core.rest.call(null,(state_39339[(4)])));

return statearr_39350;
})();
var state_39339__$1 = state_39339;
var statearr_39351_39381 = state_39339__$1;
(statearr_39351_39381[(2)] = inst_39334);

(statearr_39351_39381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (2))){
var _ = (function (){var statearr_39353 = state_39339;
(statearr_39353[(4)] = cljs.core.cons.call(null,(9),(state_39339[(4)])));

return statearr_39353;
})();
var inst_39301 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39302 = typeof inst_39301 === 'string';
var state_39339__$1 = state_39339;
if(cljs.core.truth_(inst_39302)){
var statearr_39354_39382 = state_39339__$1;
(statearr_39354_39382[(1)] = (10));

} else {
var statearr_39355_39383 = state_39339__$1;
(statearr_39355_39383[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (11))){
var inst_39308 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39309 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_39308);
var inst_39310 = fluree.db.dbfunctions.internal.inc.call(null,inst_39309);
var inst_39311 = cljs.core.assoc.call(null,inst_39308,new cljs.core.Keyword(null,"t","t",-1397832519),inst_39310);
var inst_39312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39313 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39314 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39315 = [inst_39313,inst_39314];
var inst_39316 = (new cljs.core.PersistentVector(null,2,(5),inst_39312,inst_39315,null));
var inst_39317 = fluree.db.dbproto._search.call(null,inst_39311,inst_39316);
var state_39339__$1 = state_39339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39339__$1,(13),inst_39317);
} else {
if((state_val_39340 === (9))){
var _ = (function (){var statearr_39356 = state_39339;
(statearr_39356[(4)] = cljs.core.rest.call(null,(state_39339[(4)])));

return statearr_39356;
})();
var state_39339__$1 = state_39339;
var ex39352 = (state_39339__$1[(2)]);
var statearr_39357_39384 = state_39339__$1;
(statearr_39357_39384[(5)] = ex39352);


var statearr_39358_39385 = state_39339__$1;
(statearr_39358_39385[(1)] = (4));

(statearr_39358_39385[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (5))){
var inst_39285 = (state_39339[(7)]);
var _ = (function (){var statearr_39359 = state_39339;
(statearr_39359[(4)] = cljs.core.cons.call(null,(8),(state_39339[(4)])));

return statearr_39359;
})();
var inst_39292 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39285,"?pO","Context Object");
var ___$1 = (function (){var statearr_39360 = state_39339;
(statearr_39360[(4)] = cljs.core.rest.call(null,(state_39339[(4)])));

return statearr_39360;
})();
var state_39339__$1 = state_39339;
var statearr_39361_39386 = state_39339__$1;
(statearr_39361_39386[(2)] = inst_39292);

(statearr_39361_39386[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (14))){
var state_39339__$1 = state_39339;
var statearr_39362_39387 = state_39339__$1;
(statearr_39362_39387[(2)] = null);

(statearr_39362_39387[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (16))){
var inst_39321 = (state_39339[(9)]);
var inst_39329 = (state_39339[(2)]);
var inst_39330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39331 = [inst_39329,inst_39321];
var inst_39332 = (new cljs.core.PersistentVector(null,2,(5),inst_39330,inst_39331,null));
var state_39339__$1 = state_39339;
var statearr_39364_39388 = state_39339__$1;
(statearr_39364_39388[(2)] = inst_39332);

(statearr_39364_39388[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (10))){
var inst_39304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39305 = [null,(0)];
var inst_39306 = (new cljs.core.PersistentVector(null,2,(5),inst_39304,inst_39305,null));
var state_39339__$1 = state_39339;
var statearr_39365_39389 = state_39339__$1;
(statearr_39365_39389[(2)] = inst_39306);

(statearr_39365_39389[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39340 === (8))){
var _ = (function (){var statearr_39366 = state_39339;
(statearr_39366[(4)] = cljs.core.rest.call(null,(state_39339[(4)])));

return statearr_39366;
})();
var state_39339__$1 = state_39339;
var ex39363 = (state_39339__$1[(2)]);
var statearr_39367_39390 = state_39339__$1;
(statearr_39367_39390[(5)] = ex39363);


var statearr_39368_39391 = state_39339__$1;
(statearr_39368_39391[(1)] = (7));

(statearr_39368_39391[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____0 = (function (){
var statearr_39369 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39369[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__);

(statearr_39369[(1)] = (1));

return statearr_39369;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____1 = (function (state_39339){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39370){var ex__11472__auto__ = e39370;
var statearr_39371_39392 = state_39339;
(statearr_39371_39392[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39339[(4)]))){
var statearr_39372_39393 = state_39339;
(statearr_39372_39393[(1)] = cljs.core.first.call(null,(state_39339[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39394 = state_39339;
state_39339 = G__39394;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__ = function(state_39339){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____1.call(this,state_39339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39373 = f__11543__auto__.call(null);
(statearr_39373[(6)] = c__11542__auto__);

return statearr_39373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39446){
var state_val_39447 = (state_39446[(1)]);
if((state_val_39447 === (7))){
var inst_39396 = (state_39446[(2)]);
var state_39446__$1 = state_39446;
var statearr_39448_39477 = state_39446__$1;
(statearr_39448_39477[(2)] = inst_39396);

(statearr_39448_39477[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (1))){
var state_39446__$1 = state_39446;
var statearr_39449_39478 = state_39446__$1;
(statearr_39449_39478[(2)] = null);

(statearr_39449_39478[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (4))){
var inst_39395 = (state_39446[(2)]);
var state_39446__$1 = (function (){var statearr_39450 = state_39446;
(statearr_39450[(7)] = inst_39395);

return statearr_39450;
})();
var statearr_39451_39479 = state_39446__$1;
(statearr_39451_39479[(2)] = null);

(statearr_39451_39479[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (13))){
var inst_39441 = (state_39446[(2)]);
var _ = (function (){var statearr_39452 = state_39446;
(statearr_39452[(4)] = cljs.core.rest.call(null,(state_39446[(4)])));

return statearr_39452;
})();
var state_39446__$1 = state_39446;
var statearr_39453_39480 = state_39446__$1;
(statearr_39453_39480[(2)] = inst_39441);

(statearr_39453_39480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (6))){
var inst_39405 = (state_39446[(2)]);
var state_39446__$1 = state_39446;
var statearr_39454_39481 = state_39446__$1;
(statearr_39454_39481[(2)] = inst_39405);

(statearr_39454_39481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (3))){
var inst_39444 = (state_39446[(2)]);
var state_39446__$1 = state_39446;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39446__$1,inst_39444);
} else {
if((state_val_39447 === (12))){
var inst_39428 = (state_39446[(8)]);
var inst_39437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39438 = [null,inst_39428];
var inst_39439 = (new cljs.core.PersistentVector(null,2,(5),inst_39437,inst_39438,null));
var state_39446__$1 = state_39446;
var statearr_39455_39482 = state_39446__$1;
(statearr_39455_39482[(2)] = inst_39439);

(statearr_39455_39482[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (2))){
var _ = (function (){var statearr_39457 = state_39446;
(statearr_39457[(4)] = cljs.core.cons.call(null,(9),(state_39446[(4)])));

return statearr_39457;
})();
var inst_39414 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39417 = [null,pred_name,"?o"];
var inst_39418 = (new cljs.core.PersistentVector(null,3,(5),inst_39416,inst_39417,null));
var inst_39419 = [inst_39418];
var inst_39420 = (new cljs.core.PersistentVector(null,1,(5),inst_39415,inst_39419,null));
var inst_39421 = ["?o",inst_39420,opts];
var inst_39422 = cljs.core.PersistentHashMap.fromArrays(inst_39414,inst_39421);
var inst_39423 = fluree.db.dbfunctions.internal.query.call(null,db,inst_39422);
var state_39446__$1 = state_39446;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39446__$1,(10),inst_39423);
} else {
if((state_val_39447 === (11))){
var inst_39428 = (state_39446[(8)]);
var inst_39427 = (state_39446[(9)]);
var inst_39432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39433 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_39427);
var inst_39434 = [inst_39433,inst_39428];
var inst_39435 = (new cljs.core.PersistentVector(null,2,(5),inst_39432,inst_39434,null));
var state_39446__$1 = state_39446;
var statearr_39458_39483 = state_39446__$1;
(statearr_39458_39483[(2)] = inst_39435);

(statearr_39458_39483[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (9))){
var _ = (function (){var statearr_39459 = state_39446;
(statearr_39459[(4)] = cljs.core.rest.call(null,(state_39446[(4)])));

return statearr_39459;
})();
var state_39446__$1 = state_39446;
var ex39456 = (state_39446__$1[(2)]);
var statearr_39460_39484 = state_39446__$1;
(statearr_39460_39484[(5)] = ex39456);


var statearr_39461_39485 = state_39446__$1;
(statearr_39461_39485[(1)] = (4));

(statearr_39461_39485[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (5))){
var inst_39395 = (state_39446[(7)]);
var _ = (function (){var statearr_39463 = state_39446;
(statearr_39463[(4)] = cljs.core.cons.call(null,(8),(state_39446[(4)])));

return statearr_39463;
})();
var inst_39402 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39395,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_39464 = state_39446;
(statearr_39464[(4)] = cljs.core.rest.call(null,(state_39446[(4)])));

return statearr_39464;
})();
var state_39446__$1 = state_39446;
var statearr_39465_39486 = state_39446__$1;
(statearr_39465_39486[(2)] = inst_39402);

(statearr_39465_39486[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (10))){
var inst_39427 = (state_39446[(9)]);
var inst_39425 = (state_39446[(2)]);
var inst_39426 = fluree.db.util.async.throw_err.call(null,inst_39425);
var inst_39427__$1 = cljs.core.nth.call(null,inst_39426,(0),null);
var inst_39428 = cljs.core.nth.call(null,inst_39426,(1),null);
var inst_39429 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_39427__$1);
var inst_39430 = cljs.core.not.call(null,inst_39429);
var state_39446__$1 = (function (){var statearr_39466 = state_39446;
(statearr_39466[(8)] = inst_39428);

(statearr_39466[(9)] = inst_39427__$1);

return statearr_39466;
})();
if(inst_39430){
var statearr_39467_39487 = state_39446__$1;
(statearr_39467_39487[(1)] = (11));

} else {
var statearr_39468_39488 = state_39446__$1;
(statearr_39468_39488[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39447 === (8))){
var _ = (function (){var statearr_39469 = state_39446;
(statearr_39469[(4)] = cljs.core.rest.call(null,(state_39446[(4)])));

return statearr_39469;
})();
var state_39446__$1 = state_39446;
var ex39462 = (state_39446__$1[(2)]);
var statearr_39470_39489 = state_39446__$1;
(statearr_39470_39489[(5)] = ex39462);


var statearr_39471_39490 = state_39446__$1;
(statearr_39471_39490[(1)] = (7));

(statearr_39471_39490[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____0 = (function (){
var statearr_39472 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39472[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__);

(statearr_39472[(1)] = (1));

return statearr_39472;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____1 = (function (state_39446){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39446);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39473){var ex__11472__auto__ = e39473;
var statearr_39474_39491 = state_39446;
(statearr_39474_39491[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39446[(4)]))){
var statearr_39475_39492 = state_39446;
(statearr_39475_39492[(1)] = cljs.core.first.call(null,(state_39446[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39493 = state_39446;
state_39446 = G__39493;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__ = function(state_39446){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____1.call(this,state_39446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39476 = f__11543__auto__.call(null);
(statearr_39476[(6)] = c__11542__auto__);

return statearr_39476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,((typeof email === 'string')?cljs.core.re_matches.call(null,pattern,email):false));
}catch (e39494){var e = e39494;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__39496 = arguments.length;
switch (G__39496) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39566){
var state_val_39567 = (state_39566[(1)]);
if((state_val_39567 === (7))){
var inst_39498 = (state_39566[(2)]);
var state_39566__$1 = state_39566;
var statearr_39568_39612 = state_39566__$1;
(statearr_39568_39612[(2)] = inst_39498);

(statearr_39568_39612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (20))){
var inst_39542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39543 = ["*"];
var inst_39544 = (new cljs.core.PersistentVector(null,1,(5),inst_39542,inst_39543,null));
var state_39566__$1 = state_39566;
var statearr_39569_39613 = state_39566__$1;
(statearr_39569_39613[(2)] = inst_39544);

(statearr_39569_39613[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (1))){
var state_39566__$1 = state_39566;
var statearr_39570_39614 = state_39566__$1;
(statearr_39570_39614[(2)] = null);

(statearr_39570_39614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (4))){
var inst_39497 = (state_39566[(2)]);
var state_39566__$1 = (function (){var statearr_39571 = state_39566;
(statearr_39571[(7)] = inst_39497);

return statearr_39571;
})();
var statearr_39572_39615 = state_39566__$1;
(statearr_39572_39615[(2)] = null);

(statearr_39572_39615[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (15))){
var inst_39561 = (state_39566[(2)]);
var _ = (function (){var statearr_39573 = state_39566;
(statearr_39573[(4)] = cljs.core.rest.call(null,(state_39566[(4)])));

return statearr_39573;
})();
var state_39566__$1 = state_39566;
var statearr_39574_39616 = state_39566__$1;
(statearr_39574_39616[(2)] = inst_39561);

(statearr_39574_39616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (21))){
var inst_39532 = (state_39566[(8)]);
var inst_39525 = (state_39566[(9)]);
var inst_39546 = (state_39566[(2)]);
var inst_39547 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39548 = cljs.core.PersistentHashMap.EMPTY;
var inst_39549 = [inst_39546,inst_39532,inst_39548];
var inst_39550 = cljs.core.PersistentHashMap.fromArrays(inst_39547,inst_39549);
var inst_39551 = fluree.db.dbfunctions.internal.query.call(null,inst_39525,inst_39550);
var state_39566__$1 = state_39566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39566__$1,(22),inst_39551);
} else {
if((state_val_39567 === (13))){
var inst_39520 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39566__$1 = state_39566;
var statearr_39575_39617 = state_39566__$1;
(statearr_39575_39617[(2)] = inst_39520);

(statearr_39575_39617[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (22))){
var inst_39553 = (state_39566[(2)]);
var inst_39554 = fluree.db.util.async.throw_err.call(null,inst_39553);
var inst_39555 = cljs.core.nth.call(null,inst_39554,(0),null);
var inst_39556 = cljs.core.nth.call(null,inst_39554,(1),null);
var inst_39557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39558 = [inst_39555,inst_39556];
var inst_39559 = (new cljs.core.PersistentVector(null,2,(5),inst_39557,inst_39558,null));
var state_39566__$1 = state_39566;
var statearr_39576_39618 = state_39566__$1;
(statearr_39576_39618[(2)] = inst_39559);

(statearr_39576_39618[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (6))){
var inst_39507 = (state_39566[(2)]);
var state_39566__$1 = state_39566;
var statearr_39577_39619 = state_39566__$1;
(statearr_39577_39619[(2)] = inst_39507);

(statearr_39577_39619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (17))){
var inst_39529 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39530 = fluree.db.dbfunctions.internal.get.call(null,inst_39529,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_39566__$1 = state_39566;
var statearr_39578_39620 = state_39566__$1;
(statearr_39578_39620[(2)] = inst_39530);

(statearr_39578_39620[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (3))){
var inst_39564 = (state_39566[(2)]);
var state_39566__$1 = state_39566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39566__$1,inst_39564);
} else {
if((state_val_39567 === (12))){
var inst_39518 = (state_39566[(2)]);
var state_39566__$1 = state_39566;
if(cljs.core.truth_(inst_39518)){
var statearr_39579_39621 = state_39566__$1;
(statearr_39579_39621[(1)] = (13));

} else {
var statearr_39580_39622 = state_39566__$1;
(statearr_39580_39622[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (2))){
var inst_39513 = (state_39566[(10)]);
var _ = (function (){var statearr_39581 = state_39566;
(statearr_39581[(4)] = cljs.core.cons.call(null,(9),(state_39566[(4)])));

return statearr_39581;
})();
var inst_39513__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39566__$1 = (function (){var statearr_39582 = state_39566;
(statearr_39582[(10)] = inst_39513__$1);

return statearr_39582;
})();
if(cljs.core.truth_(inst_39513__$1)){
var statearr_39583_39623 = state_39566__$1;
(statearr_39583_39623[(1)] = (10));

} else {
var statearr_39584_39624 = state_39566__$1;
(statearr_39584_39624[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (19))){
var inst_39534 = cljs.core.PersistentVector.EMPTY;
var inst_39535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39536 = ["*"];
var inst_39537 = (new cljs.core.PersistentVector(null,1,(5),inst_39535,inst_39536,null));
var inst_39538 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_39539 = cljs.core.concat.call(null,inst_39537,inst_39538);
var inst_39540 = cljs.core.into.call(null,inst_39534,inst_39539);
var state_39566__$1 = state_39566;
var statearr_39586_39625 = state_39566__$1;
(statearr_39586_39625[(2)] = inst_39540);

(statearr_39586_39625[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (11))){
var inst_39513 = (state_39566[(10)]);
var state_39566__$1 = state_39566;
var statearr_39587_39626 = state_39566__$1;
(statearr_39587_39626[(2)] = inst_39513);

(statearr_39587_39626[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (9))){
var _ = (function (){var statearr_39588 = state_39566;
(statearr_39588[(4)] = cljs.core.rest.call(null,(state_39566[(4)])));

return statearr_39588;
})();
var state_39566__$1 = state_39566;
var ex39585 = (state_39566__$1[(2)]);
var statearr_39589_39627 = state_39566__$1;
(statearr_39589_39627[(5)] = ex39585);


var statearr_39590_39628 = state_39566__$1;
(statearr_39590_39628[(1)] = (4));

(statearr_39590_39628[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (5))){
var inst_39497 = (state_39566[(7)]);
var _ = (function (){var statearr_39591 = state_39566;
(statearr_39591[(4)] = cljs.core.cons.call(null,(8),(state_39566[(4)])));

return statearr_39591;
})();
var inst_39504 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39497,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_39592 = state_39566;
(statearr_39592[(4)] = cljs.core.rest.call(null,(state_39566[(4)])));

return statearr_39592;
})();
var state_39566__$1 = state_39566;
var statearr_39593_39629 = state_39566__$1;
(statearr_39593_39629[(2)] = inst_39504);

(statearr_39593_39629[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (14))){
var inst_39526 = (state_39566[(11)]);
var inst_39525 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39526__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39566__$1 = (function (){var statearr_39594 = state_39566;
(statearr_39594[(9)] = inst_39525);

(statearr_39594[(11)] = inst_39526__$1);

return statearr_39594;
})();
if(cljs.core.truth_(inst_39526__$1)){
var statearr_39595_39630 = state_39566__$1;
(statearr_39595_39630[(1)] = (16));

} else {
var statearr_39596_39631 = state_39566__$1;
(statearr_39596_39631[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (16))){
var inst_39526 = (state_39566[(11)]);
var state_39566__$1 = state_39566;
var statearr_39597_39632 = state_39566__$1;
(statearr_39597_39632[(2)] = inst_39526);

(statearr_39597_39632[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (10))){
var inst_39515 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_39566__$1 = state_39566;
var statearr_39599_39633 = state_39566__$1;
(statearr_39599_39633[(2)] = inst_39515);

(statearr_39599_39633[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (18))){
var inst_39532 = (state_39566[(2)]);
var state_39566__$1 = (function (){var statearr_39600 = state_39566;
(statearr_39600[(8)] = inst_39532);

return statearr_39600;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39601_39634 = state_39566__$1;
(statearr_39601_39634[(1)] = (19));

} else {
var statearr_39602_39635 = state_39566__$1;
(statearr_39602_39635[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39567 === (8))){
var _ = (function (){var statearr_39603 = state_39566;
(statearr_39603[(4)] = cljs.core.rest.call(null,(state_39566[(4)])));

return statearr_39603;
})();
var state_39566__$1 = state_39566;
var ex39598 = (state_39566__$1[(2)]);
var statearr_39604_39636 = state_39566__$1;
(statearr_39604_39636[(5)] = ex39598);


var statearr_39605_39637 = state_39566__$1;
(statearr_39605_39637[(1)] = (7));

(statearr_39605_39637[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11469__auto____0 = (function (){
var statearr_39606 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39606[(0)] = fluree$db$dbfunctions$internal$state_machine__11469__auto__);

(statearr_39606[(1)] = (1));

return statearr_39606;
});
var fluree$db$dbfunctions$internal$state_machine__11469__auto____1 = (function (state_39566){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39607){var ex__11472__auto__ = e39607;
var statearr_39608_39638 = state_39566;
(statearr_39608_39638[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39566[(4)]))){
var statearr_39609_39639 = state_39566;
(statearr_39609_39639[(1)] = cljs.core.first.call(null,(state_39566[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39640 = state_39566;
state_39566 = G__39640;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11469__auto__ = function(state_39566){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____1.call(this,state_39566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39610 = f__11543__auto__.call(null);
(statearr_39610[(6)] = c__11542__auto__);

return statearr_39610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__39642 = arguments.length;
switch (G__39642) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39686){
var state_val_39687 = (state_39686[(1)]);
if((state_val_39687 === (7))){
var inst_39664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39665 = ["*"];
var inst_39666 = (new cljs.core.PersistentVector(null,1,(5),inst_39664,inst_39665,null));
var state_39686__$1 = state_39686;
var statearr_39688_39708 = state_39686__$1;
(statearr_39688_39708[(2)] = inst_39666);

(statearr_39688_39708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (1))){
var state_39686__$1 = state_39686;
var statearr_39689_39709 = state_39686__$1;
(statearr_39689_39709[(2)] = null);

(statearr_39689_39709[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (4))){
var inst_39643 = (state_39686[(2)]);
var inst_39644 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39643,"?p","Context Object",additional_params);
var state_39686__$1 = state_39686;
var statearr_39690_39710 = state_39686__$1;
(statearr_39690_39710[(2)] = inst_39644);

(statearr_39690_39710[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (6))){
var inst_39656 = cljs.core.PersistentVector.EMPTY;
var inst_39657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39658 = ["*"];
var inst_39659 = (new cljs.core.PersistentVector(null,1,(5),inst_39657,inst_39658,null));
var inst_39660 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_39661 = cljs.core.concat.call(null,inst_39659,inst_39660);
var inst_39662 = cljs.core.into.call(null,inst_39656,inst_39661);
var state_39686__$1 = state_39686;
var statearr_39691_39711 = state_39686__$1;
(statearr_39691_39711[(2)] = inst_39662);

(statearr_39691_39711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (3))){
var inst_39684 = (state_39686[(2)]);
var state_39686__$1 = state_39686;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39686__$1,inst_39684);
} else {
if((state_val_39687 === (2))){
var _ = (function (){var statearr_39693 = state_39686;
(statearr_39693[(4)] = cljs.core.cons.call(null,(5),(state_39686[(4)])));

return statearr_39693;
})();
var inst_39653 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39654 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_39686__$1 = (function (){var statearr_39694 = state_39686;
(statearr_39694[(7)] = inst_39653);

(statearr_39694[(8)] = inst_39654);

return statearr_39694;
})();
if(cljs.core.truth_(additional_params)){
var statearr_39695_39712 = state_39686__$1;
(statearr_39695_39712[(1)] = (6));

} else {
var statearr_39696_39713 = state_39686__$1;
(statearr_39696_39713[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (9))){
var inst_39675 = (state_39686[(2)]);
var inst_39676 = fluree.db.util.async.throw_err.call(null,inst_39675);
var inst_39677 = cljs.core.nth.call(null,inst_39676,(0),null);
var inst_39678 = cljs.core.nth.call(null,inst_39676,(1),null);
var inst_39679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39680 = [inst_39677,inst_39678];
var inst_39681 = (new cljs.core.PersistentVector(null,2,(5),inst_39679,inst_39680,null));
var _ = (function (){var statearr_39697 = state_39686;
(statearr_39697[(4)] = cljs.core.rest.call(null,(state_39686[(4)])));

return statearr_39697;
})();
var state_39686__$1 = state_39686;
var statearr_39698_39714 = state_39686__$1;
(statearr_39698_39714[(2)] = inst_39681);

(statearr_39698_39714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (5))){
var _ = (function (){var statearr_39699 = state_39686;
(statearr_39699[(4)] = cljs.core.rest.call(null,(state_39686[(4)])));

return statearr_39699;
})();
var state_39686__$1 = state_39686;
var ex39692 = (state_39686__$1[(2)]);
var statearr_39700_39715 = state_39686__$1;
(statearr_39700_39715[(5)] = ex39692);


var statearr_39701_39716 = state_39686__$1;
(statearr_39701_39716[(1)] = (4));

(statearr_39701_39716[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39687 === (8))){
var inst_39653 = (state_39686[(7)]);
var inst_39654 = (state_39686[(8)]);
var inst_39668 = (state_39686[(2)]);
var inst_39669 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39670 = cljs.core.PersistentHashMap.EMPTY;
var inst_39671 = [inst_39668,inst_39654,inst_39670];
var inst_39672 = cljs.core.PersistentHashMap.fromArrays(inst_39669,inst_39671);
var inst_39673 = fluree.db.dbfunctions.internal.query.call(null,inst_39653,inst_39672);
var state_39686__$1 = state_39686;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39686__$1,(9),inst_39673);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__11469__auto____0 = (function (){
var statearr_39702 = [null,null,null,null,null,null,null,null,null];
(statearr_39702[(0)] = fluree$db$dbfunctions$internal$state_machine__11469__auto__);

(statearr_39702[(1)] = (1));

return statearr_39702;
});
var fluree$db$dbfunctions$internal$state_machine__11469__auto____1 = (function (state_39686){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39686);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39703){var ex__11472__auto__ = e39703;
var statearr_39704_39717 = state_39686;
(statearr_39704_39717[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39686[(4)]))){
var statearr_39705_39718 = state_39686;
(statearr_39705_39718[(1)] = cljs.core.first.call(null,(state_39686[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39719 = state_39686;
state_39686 = G__39719;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__11469__auto__ = function(state_39686){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__11469__auto____1.call(this,state_39686);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39706 = f__11543__auto__.call(null);
(statearr_39706[(6)] = c__11542__auto__);

return statearr_39706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39763){
var state_val_39764 = (state_39763[(1)]);
if((state_val_39764 === (1))){
var state_39763__$1 = state_39763;
var statearr_39765_39779 = state_39763__$1;
(statearr_39765_39779[(2)] = null);

(statearr_39765_39779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39764 === (2))){
var _ = (function (){var statearr_39766 = state_39763;
(statearr_39766[(4)] = cljs.core.cons.call(null,(5),(state_39763[(4)])));

return statearr_39766;
})();
var inst_39730 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39732 = ["_user/_auth"];
var inst_39733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39734 = ["*"];
var inst_39735 = (new cljs.core.PersistentVector(null,1,(5),inst_39733,inst_39734,null));
var inst_39736 = [inst_39735];
var inst_39737 = cljs.core.PersistentHashMap.fromArrays(inst_39732,inst_39736);
var inst_39738 = [inst_39737];
var inst_39739 = (new cljs.core.PersistentVector(null,1,(5),inst_39731,inst_39738,null));
var inst_39740 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39741 = cljs.core.PersistentHashMap.EMPTY;
var inst_39742 = [inst_39739,inst_39740,inst_39741];
var inst_39743 = cljs.core.PersistentHashMap.fromArrays(inst_39730,inst_39742);
var inst_39744 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39745 = fluree.db.dbfunctions.internal.query.call(null,inst_39744,inst_39743);
var state_39763__$1 = state_39763;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39763__$1,(6),inst_39745);
} else {
if((state_val_39764 === (3))){
var inst_39761 = (state_39763[(2)]);
var state_39763__$1 = state_39763;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39763__$1,inst_39761);
} else {
if((state_val_39764 === (4))){
var inst_39720 = (state_39763[(2)]);
var inst_39721 = fluree.db.dbfunctions.internal.function_error.call(null,inst_39720,"?user_id-from-auth","Context Object");
var state_39763__$1 = state_39763;
var statearr_39768_39780 = state_39763__$1;
(statearr_39768_39780[(2)] = inst_39721);

(statearr_39768_39780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39764 === (5))){
var _ = (function (){var statearr_39769 = state_39763;
(statearr_39769[(4)] = cljs.core.rest.call(null,(state_39763[(4)])));

return statearr_39769;
})();
var state_39763__$1 = state_39763;
var ex39767 = (state_39763__$1[(2)]);
var statearr_39770_39781 = state_39763__$1;
(statearr_39770_39781[(5)] = ex39767);


var statearr_39771_39782 = state_39763__$1;
(statearr_39771_39782[(1)] = (4));

(statearr_39771_39782[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39764 === (6))){
var inst_39747 = (state_39763[(2)]);
var inst_39748 = fluree.db.util.async.throw_err.call(null,inst_39747);
var inst_39749 = cljs.core.nth.call(null,inst_39748,(0),null);
var inst_39750 = cljs.core.nth.call(null,inst_39748,(1),null);
var inst_39751 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39752 = ["_user/_auth","_id"];
var inst_39753 = (new cljs.core.PersistentVector(null,2,(5),inst_39751,inst_39752,null));
var inst_39754 = fluree.db.dbfunctions.internal.get_in.call(null,inst_39749,inst_39753);
var inst_39755 = cljs.core.first.call(null,inst_39754);
var inst_39756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39757 = [inst_39755,inst_39750];
var inst_39758 = (new cljs.core.PersistentVector(null,2,(5),inst_39756,inst_39757,null));
var _ = (function (){var statearr_39772 = state_39763;
(statearr_39772[(4)] = cljs.core.rest.call(null,(state_39763[(4)])));

return statearr_39772;
})();
var state_39763__$1 = state_39763;
var statearr_39773_39783 = state_39763__$1;
(statearr_39773_39783[(2)] = inst_39758);

(statearr_39773_39783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____0 = (function (){
var statearr_39774 = [null,null,null,null,null,null,null];
(statearr_39774[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__);

(statearr_39774[(1)] = (1));

return statearr_39774;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____1 = (function (state_39763){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39763);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39775){var ex__11472__auto__ = e39775;
var statearr_39776_39784 = state_39763;
(statearr_39776_39784[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39763[(4)]))){
var statearr_39777_39785 = state_39763;
(statearr_39777_39785[(1)] = cljs.core.first.call(null,(state_39763[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39786 = state_39763;
state_39763 = G__39786;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__ = function(state_39763){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____1.call(this,state_39763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39778 = f__11543__auto__.call(null);
(statearr_39778[(6)] = c__11542__auto__);

return statearr_39778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39803){
var state_val_39804 = (state_39803[(1)]);
if((state_val_39804 === (1))){
var state_39803__$1 = state_39803;
var statearr_39805_39819 = state_39803__$1;
(statearr_39805_39819[(2)] = null);

(statearr_39805_39819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39804 === (2))){
var _ = (function (){var statearr_39806 = state_39803;
(statearr_39806[(4)] = cljs.core.cons.call(null,(5),(state_39803[(4)])));

return statearr_39806;
})();
var inst_39793 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39794 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_39795 = fluree.db.dbproto._subid.call(null,inst_39794,inst_39793);
var state_39803__$1 = state_39803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39803__$1,(6),inst_39795);
} else {
if((state_val_39804 === (3))){
var inst_39801 = (state_39803[(2)]);
var state_39803__$1 = state_39803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39803__$1,inst_39801);
} else {
if((state_val_39804 === (4))){
var inst_39787 = (state_39803[(2)]);
var state_39803__$1 = state_39803;
var statearr_39808_39820 = state_39803__$1;
(statearr_39808_39820[(2)] = inst_39787);

(statearr_39808_39820[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39804 === (5))){
var _ = (function (){var statearr_39809 = state_39803;
(statearr_39809[(4)] = cljs.core.rest.call(null,(state_39803[(4)])));

return statearr_39809;
})();
var state_39803__$1 = state_39803;
var ex39807 = (state_39803__$1[(2)]);
var statearr_39810_39821 = state_39803__$1;
(statearr_39810_39821[(5)] = ex39807);


if((ex39807 instanceof Error)){
var statearr_39811_39822 = state_39803__$1;
(statearr_39811_39822[(1)] = (4));

(statearr_39811_39822[(5)] = null);

} else {
throw ex39807;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39804 === (6))){
var inst_39797 = (state_39803[(2)]);
var inst_39798 = fluree.db.util.async.throw_err.call(null,inst_39797);
var _ = (function (){var statearr_39812 = state_39803;
(statearr_39812[(4)] = cljs.core.rest.call(null,(state_39803[(4)])));

return statearr_39812;
})();
var state_39803__$1 = state_39803;
var statearr_39813_39823 = state_39803__$1;
(statearr_39813_39823[(2)] = inst_39798);

(statearr_39813_39823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____0 = (function (){
var statearr_39814 = [null,null,null,null,null,null,null];
(statearr_39814[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__);

(statearr_39814[(1)] = (1));

return statearr_39814;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____1 = (function (state_39803){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39815){var ex__11472__auto__ = e39815;
var statearr_39816_39824 = state_39803;
(statearr_39816_39824[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39803[(4)]))){
var statearr_39817_39825 = state_39803;
(statearr_39817_39825[(1)] = cljs.core.first.call(null,(state_39803[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39826 = state_39803;
state_39803 = G__39826;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__ = function(state_39803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____1.call(this,state_39803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39818 = f__11543__auto__.call(null);
(statearr_39818[(6)] = c__11542__auto__);

return statearr_39818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__39827_SHARP_){
return p1__39827_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__39828_SHARP_){
return p1__39828_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e39829){var e = e39829;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__39830_SHARP_){
return p1__39830_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__39831_SHARP_){
return p1__39831_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e39832){var e = e39832;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e39833){var e = e39833;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_39933){
var state_val_39934 = (state_39933[(1)]);
if((state_val_39934 === (7))){
var state_39933__$1 = state_39933;
var statearr_39935_39983 = state_39933__$1;
(statearr_39935_39983[(2)] = false);

(statearr_39935_39983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (20))){
var inst_39868 = (state_39933[(7)]);
var inst_39867 = (state_39933[(8)]);
var inst_39889 = (state_39933[(2)]);
var inst_39890 = fluree.db.dbproto._p_prop.call(null,inst_39868,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_39867);
var state_39933__$1 = (function (){var statearr_39936 = state_39933;
(statearr_39936[(9)] = inst_39889);

return statearr_39936;
})();
if(cljs.core.truth_(inst_39890)){
var statearr_39937_39984 = state_39933__$1;
(statearr_39937_39984[(1)] = (21));

} else {
var statearr_39938_39985 = state_39933__$1;
(statearr_39938_39985[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (27))){
var inst_39928 = (state_39933[(2)]);
var _ = (function (){var statearr_39939 = state_39933;
(statearr_39939[(4)] = cljs.core.rest.call(null,(state_39933[(4)])));

return statearr_39939;
})();
var state_39933__$1 = state_39933;
var statearr_39940_39986 = state_39933__$1;
(statearr_39940_39986[(2)] = inst_39928);

(statearr_39940_39986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (1))){
var state_39933__$1 = state_39933;
var statearr_39941_39987 = state_39933__$1;
(statearr_39941_39987[(2)] = null);

(statearr_39941_39987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (24))){
var inst_39917 = (state_39933[(10)]);
var inst_39913 = (state_39933[(2)]);
var inst_39914 = fluree.db.util.async.throw_err.call(null,inst_39913);
var inst_39915 = cljs.core.nth.call(null,inst_39914,(0),null);
var inst_39916 = cljs.core.nth.call(null,inst_39914,(1),null);
var inst_39917__$1 = cljs.core.first.call(null,inst_39915);
var inst_39918 = cljs.core._EQ_.call(null,inst_39917__$1,compare_val);
var state_39933__$1 = (function (){var statearr_39942 = state_39933;
(statearr_39942[(10)] = inst_39917__$1);

(statearr_39942[(11)] = inst_39916);

return statearr_39942;
})();
if(inst_39918){
var statearr_39943_39988 = state_39933__$1;
(statearr_39943_39988[(1)] = (25));

} else {
var statearr_39944_39989 = state_39933__$1;
(statearr_39944_39989[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (4))){
var inst_39834 = (state_39933[(2)]);
var state_39933__$1 = state_39933;
var statearr_39945_39990 = state_39933__$1;
(statearr_39945_39990[(2)] = inst_39834);

(statearr_39945_39990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (15))){
var state_39933__$1 = state_39933;
var statearr_39946_39991 = state_39933__$1;
(statearr_39946_39991[(2)] = null);

(statearr_39946_39991[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (21))){
var inst_39869 = (state_39933[(12)]);
var inst_39892 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_39869);
var inst_39893 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39894 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39895 = cljs.core.PersistentHashMap.fromArrays(inst_39893,inst_39894);
var inst_39896 = cljs.core.ex_info.call(null,inst_39892,inst_39895);
var inst_39897 = (function(){throw inst_39896})();
var state_39933__$1 = state_39933;
var statearr_39947_39992 = state_39933__$1;
(statearr_39947_39992[(2)] = inst_39897);

(statearr_39947_39992[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (13))){
var inst_39844 = (state_39933[(13)]);
var state_39933__$1 = state_39933;
var statearr_39948_39993 = state_39933__$1;
(statearr_39948_39993[(2)] = inst_39844);

(statearr_39948_39993[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (22))){
var state_39933__$1 = state_39933;
var statearr_39949_39994 = state_39933__$1;
(statearr_39949_39994[(2)] = null);

(statearr_39949_39994[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (6))){
var inst_39844 = (state_39933[(13)]);
var inst_39849 = inst_39844.cljs$lang$protocol_mask$partition0$;
var inst_39850 = (inst_39849 & (64));
var inst_39851 = inst_39844.cljs$core$ISeq$;
var inst_39852 = (cljs.core.PROTOCOL_SENTINEL === inst_39851);
var inst_39853 = ((inst_39850) || (inst_39852));
var state_39933__$1 = state_39933;
if(cljs.core.truth_(inst_39853)){
var statearr_39950_39995 = state_39933__$1;
(statearr_39950_39995[(1)] = (9));

} else {
var statearr_39951_39996 = state_39933__$1;
(statearr_39951_39996[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (25))){
var state_39933__$1 = state_39933;
var statearr_39952_39997 = state_39933__$1;
(statearr_39952_39997[(2)] = new_val);

(statearr_39952_39997[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (17))){
var inst_39869 = (state_39933[(12)]);
var inst_39879 = (state_39933[(2)]);
var state_39933__$1 = (function (){var statearr_39953 = state_39933;
(statearr_39953[(14)] = inst_39879);

return statearr_39953;
})();
if(cljs.core.truth_(inst_39869)){
var statearr_39954_39998 = state_39933__$1;
(statearr_39954_39998[(1)] = (18));

} else {
var statearr_39955_39999 = state_39933__$1;
(statearr_39955_39999[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (3))){
var inst_39931 = (state_39933[(2)]);
var state_39933__$1 = state_39933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_39933__$1,inst_39931);
} else {
if((state_val_39934 === (12))){
var inst_39844 = (state_39933[(13)]);
var inst_39862 = cljs.core.apply.call(null,cljs.core.hash_map,inst_39844);
var state_39933__$1 = state_39933;
var statearr_39956_40000 = state_39933__$1;
(statearr_39956_40000[(2)] = inst_39862);

(statearr_39956_40000[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (2))){
var inst_39844 = (state_39933[(13)]);
var _ = (function (){var statearr_39957 = state_39933;
(statearr_39957[(4)] = cljs.core.cons.call(null,(5),(state_39933[(4)])));

return statearr_39957;
})();
var inst_39844__$1 = _QMARK_ctx;
var inst_39846 = (inst_39844__$1 == null);
var inst_39847 = cljs.core.not.call(null,inst_39846);
var state_39933__$1 = (function (){var statearr_39958 = state_39933;
(statearr_39958[(13)] = inst_39844__$1);

return statearr_39958;
})();
if(inst_39847){
var statearr_39959_40001 = state_39933__$1;
(statearr_39959_40001[(1)] = (6));

} else {
var statearr_39960_40002 = state_39933__$1;
(statearr_39960_40002[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (23))){
var inst_39868 = (state_39933[(7)]);
var inst_39869 = (state_39933[(12)]);
var inst_39866 = (state_39933[(15)]);
var inst_39900 = (state_39933[(2)]);
var inst_39901 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_39902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39904 = [inst_39866,inst_39869,"?current-val"];
var inst_39905 = (new cljs.core.PersistentVector(null,3,(5),inst_39903,inst_39904,null));
var inst_39906 = [inst_39905];
var inst_39907 = (new cljs.core.PersistentVector(null,1,(5),inst_39902,inst_39906,null));
var inst_39908 = cljs.core.PersistentHashMap.EMPTY;
var inst_39909 = ["?current-val",inst_39907,inst_39908];
var inst_39910 = cljs.core.PersistentHashMap.fromArrays(inst_39901,inst_39909);
var inst_39911 = fluree.db.dbfunctions.internal.query.call(null,inst_39868,inst_39910);
var state_39933__$1 = (function (){var statearr_39961 = state_39933;
(statearr_39961[(16)] = inst_39900);

return statearr_39961;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_39933__$1,(24),inst_39911);
} else {
if((state_val_39934 === (19))){
var inst_39882 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_39883 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39884 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39885 = cljs.core.PersistentHashMap.fromArrays(inst_39883,inst_39884);
var inst_39886 = cljs.core.ex_info.call(null,inst_39882,inst_39885);
var inst_39887 = (function(){throw inst_39886})();
var state_39933__$1 = state_39933;
var statearr_39962_40003 = state_39933__$1;
(statearr_39962_40003[(2)] = inst_39887);

(statearr_39962_40003[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (11))){
var inst_39857 = (state_39933[(2)]);
var state_39933__$1 = state_39933;
var statearr_39964_40004 = state_39933__$1;
(statearr_39964_40004[(2)] = inst_39857);

(statearr_39964_40004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (9))){
var state_39933__$1 = state_39933;
var statearr_39965_40005 = state_39933__$1;
(statearr_39965_40005[(2)] = true);

(statearr_39965_40005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (5))){
var _ = (function (){var statearr_39966 = state_39933;
(statearr_39966[(4)] = cljs.core.rest.call(null,(state_39933[(4)])));

return statearr_39966;
})();
var state_39933__$1 = state_39933;
var ex39963 = (state_39933__$1[(2)]);
var statearr_39967_40006 = state_39933__$1;
(statearr_39967_40006[(5)] = ex39963);


if((ex39963 instanceof Error)){
var statearr_39968_40007 = state_39933__$1;
(statearr_39968_40007[(1)] = (4));

(statearr_39968_40007[(5)] = null);

} else {
throw ex39963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (14))){
var inst_39868 = (state_39933[(7)]);
var inst_39867 = (state_39933[(8)]);
var inst_39866 = (state_39933[(15)]);
var inst_39865 = (state_39933[(2)]);
var inst_39866__$1 = cljs.core.get.call(null,inst_39865,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_39867__$1 = cljs.core.get.call(null,inst_39865,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_39868__$1 = cljs.core.get.call(null,inst_39865,new cljs.core.Keyword(null,"db","db",993250759));
var inst_39869 = fluree.db.dbproto._p_prop.call(null,inst_39868__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_39867__$1);
var state_39933__$1 = (function (){var statearr_39969 = state_39933;
(statearr_39969[(7)] = inst_39868__$1);

(statearr_39969[(12)] = inst_39869);

(statearr_39969[(8)] = inst_39867__$1);

(statearr_39969[(15)] = inst_39866__$1);

return statearr_39969;
})();
if(cljs.core.truth_(inst_39866__$1)){
var statearr_39970_40008 = state_39933__$1;
(statearr_39970_40008[(1)] = (15));

} else {
var statearr_39971_40009 = state_39933__$1;
(statearr_39971_40009[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (26))){
var inst_39917 = (state_39933[(10)]);
var inst_39921 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39917)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_39922 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39923 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39924 = cljs.core.PersistentHashMap.fromArrays(inst_39922,inst_39923);
var inst_39925 = cljs.core.ex_info.call(null,inst_39921,inst_39924);
var inst_39926 = (function(){throw inst_39925})();
var state_39933__$1 = state_39933;
var statearr_39972_40010 = state_39933__$1;
(statearr_39972_40010[(2)] = inst_39926);

(statearr_39972_40010[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (16))){
var inst_39872 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_39873 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_39874 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_39875 = cljs.core.PersistentHashMap.fromArrays(inst_39873,inst_39874);
var inst_39876 = cljs.core.ex_info.call(null,inst_39872,inst_39875);
var inst_39877 = (function(){throw inst_39876})();
var state_39933__$1 = state_39933;
var statearr_39973_40011 = state_39933__$1;
(statearr_39973_40011[(2)] = inst_39877);

(statearr_39973_40011[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (10))){
var state_39933__$1 = state_39933;
var statearr_39974_40012 = state_39933__$1;
(statearr_39974_40012[(2)] = false);

(statearr_39974_40012[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (18))){
var state_39933__$1 = state_39933;
var statearr_39975_40013 = state_39933__$1;
(statearr_39975_40013[(2)] = null);

(statearr_39975_40013[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39934 === (8))){
var inst_39860 = (state_39933[(2)]);
var state_39933__$1 = state_39933;
if(cljs.core.truth_(inst_39860)){
var statearr_39976_40014 = state_39933__$1;
(statearr_39976_40014[(1)] = (12));

} else {
var statearr_39977_40015 = state_39933__$1;
(statearr_39977_40015[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____0 = (function (){
var statearr_39978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39978[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__);

(statearr_39978[(1)] = (1));

return statearr_39978;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____1 = (function (state_39933){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_39933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e39979){var ex__11472__auto__ = e39979;
var statearr_39980_40016 = state_39933;
(statearr_39980_40016[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_39933[(4)]))){
var statearr_39981_40017 = state_39933;
(statearr_39981_40017[(1)] = cljs.core.first.call(null,(state_39933[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40018 = state_39933;
state_39933 = G__40018;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__ = function(state_39933){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____1.call(this,state_39933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_39982 = f__11543__auto__.call(null);
(statearr_39982[(6)] = c__11542__auto__);

return statearr_39982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
