// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__74134 = arguments.length;
switch (G__74134) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74176){
var state_val_74177 = (state_74176[(1)]);
if((state_val_74177 === (7))){
var inst_74146 = typeof user === 'string';
var state_74176__$1 = state_74176;
if(cljs.core.truth_(inst_74146)){
var statearr_74178_74207 = state_74176__$1;
(statearr_74178_74207[(1)] = (9));

} else {
var statearr_74179_74208 = state_74176__$1;
(statearr_74179_74208[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (1))){
var state_74176__$1 = state_74176;
var statearr_74180_74209 = state_74176__$1;
(statearr_74180_74209[(2)] = null);

(statearr_74180_74209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (4))){
var inst_74135 = (state_74176[(2)]);
var inst_74136 = fluree.db.util.log.error.call(null,inst_74135);
var inst_74137 = reject.call(null,inst_74135);
var state_74176__$1 = (function (){var statearr_74181 = state_74176;
(statearr_74181[(7)] = inst_74136);

return statearr_74181;
})();
var statearr_74182_74210 = state_74176__$1;
(statearr_74182_74210[(2)] = inst_74137);

(statearr_74182_74210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (15))){
var inst_74165 = (state_74176[(2)]);
var inst_74166 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_74165);
var inst_74167 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74168 = cljs.core.constantly.call(null,inst_74166);
var inst_74169 = cljs.core.swap_BANG_.call(null,inst_74167,inst_74168);
var inst_74170 = fluree.db.connection.add_token.call(null,conn,inst_74166);
var inst_74171 = resolve.call(null,inst_74165);
var _ = (function (){var statearr_74183 = state_74176;
(statearr_74183[(4)] = cljs.core.rest.call(null,(state_74176[(4)])));

return statearr_74183;
})();
var state_74176__$1 = (function (){var statearr_74184 = state_74176;
(statearr_74184[(8)] = inst_74170);

(statearr_74184[(9)] = inst_74169);

return statearr_74184;
})();
var statearr_74185_74211 = state_74176__$1;
(statearr_74185_74211[(2)] = inst_74171);

(statearr_74185_74211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (13))){
var state_74176__$1 = state_74176;
var statearr_74186_74212 = state_74176__$1;
(statearr_74186_74212[(2)] = null);

(statearr_74186_74212[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (6))){
var state_74176__$1 = state_74176;
var statearr_74187_74213 = state_74176__$1;
(statearr_74187_74213[(2)] = user);

(statearr_74187_74213[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (3))){
var inst_74174 = (state_74176[(2)]);
var state_74176__$1 = state_74176;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74176__$1,inst_74174);
} else {
if((state_val_74177 === (12))){
var state_74176__$1 = state_74176;
var statearr_74188_74214 = state_74176__$1;
(statearr_74188_74214[(2)] = user);

(statearr_74188_74214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (2))){
var _ = (function (){var statearr_74189 = state_74176;
(statearr_74189[(4)] = cljs.core.cons.call(null,(5),(state_74176[(4)])));

return statearr_74189;
})();
var inst_74143 = typeof user === 'number';
var state_74176__$1 = state_74176;
if(cljs.core.truth_(inst_74143)){
var statearr_74190_74215 = state_74176__$1;
(statearr_74190_74215[(1)] = (6));

} else {
var statearr_74191_74216 = state_74176__$1;
(statearr_74191_74216[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (11))){
var inst_74157 = (state_74176[(2)]);
var state_74176__$1 = state_74176;
var statearr_74193_74217 = state_74176__$1;
(statearr_74193_74217[(2)] = inst_74157);

(statearr_74193_74217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (9))){
var inst_74148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74149 = ["_user/username",user];
var inst_74150 = (new cljs.core.PersistentVector(null,2,(5),inst_74148,inst_74149,null));
var state_74176__$1 = state_74176;
var statearr_74194_74218 = state_74176__$1;
(statearr_74194_74218[(2)] = inst_74150);

(statearr_74194_74218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (5))){
var _ = (function (){var statearr_74195 = state_74176;
(statearr_74195[(4)] = cljs.core.rest.call(null,(state_74176[(4)])));

return statearr_74195;
})();
var state_74176__$1 = state_74176;
var ex74192 = (state_74176__$1[(2)]);
var statearr_74196_74219 = state_74176__$1;
(statearr_74196_74219[(5)] = ex74192);


var statearr_74197_74220 = state_74176__$1;
(statearr_74197_74220[(1)] = (4));

(statearr_74197_74220[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (14))){
var inst_74155 = (state_74176[(2)]);
var state_74176__$1 = state_74176;
var statearr_74198_74221 = state_74176__$1;
(statearr_74198_74221[(2)] = inst_74155);

(statearr_74198_74221[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (10))){
var state_74176__$1 = state_74176;
var statearr_74199_74222 = state_74176__$1;
(statearr_74199_74222[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74177 === (8))){
var inst_74159 = (state_74176[(2)]);
var inst_74160 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_74161 = [account,inst_74159,password,expireSeconds,syncTo];
var inst_74162 = cljs.core.PersistentHashMap.fromArrays(inst_74160,inst_74161);
var inst_74163 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_74162);
var state_74176__$1 = state_74176;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74176__$1,(15),inst_74163);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11469__auto__ = null;
var fluree$db$connection_js$state_machine__11469__auto____0 = (function (){
var statearr_74201 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74201[(0)] = fluree$db$connection_js$state_machine__11469__auto__);

(statearr_74201[(1)] = (1));

return statearr_74201;
});
var fluree$db$connection_js$state_machine__11469__auto____1 = (function (state_74176){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74176);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74202){var ex__11472__auto__ = e74202;
var statearr_74203_74223 = state_74176;
(statearr_74203_74223[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74176[(4)]))){
var statearr_74204_74224 = state_74176;
(statearr_74204_74224[(1)] = cljs.core.first.call(null,(state_74176[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74225 = state_74176;
state_74176 = G__74225;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11469__auto__ = function(state_74176){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11469__auto____1.call(this,state_74176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11469__auto____0;
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11469__auto____1;
return fluree$db$connection_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74205 = f__11543__auto__.call(null);
(statearr_74205[(6)] = c__11542__auto__);

return statearr_74205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__74227 = arguments.length;
switch (G__74227) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74236){
var state_val_74237 = (state_74236[(1)]);
if((state_val_74237 === (1))){
var inst_74228 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74230 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_74231 = (new cljs.core.PersistentVector(null,4,(5),inst_74229,inst_74230,null));
var inst_74232 = cljs.core.async.put_BANG_.call(null,inst_74228,inst_74231);
var inst_74233 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__74238 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__74239 = null;
var count__74240 = (0);
var i__74241 = (0);
while(true){
if((i__74241 < count__74240)){
var k = cljs.core._nth.call(null,chunk__74239,i__74241);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__74249 = seq__74238;
var G__74250 = chunk__74239;
var G__74251 = count__74240;
var G__74252 = (i__74241 + (1));
seq__74238 = G__74249;
chunk__74239 = G__74250;
count__74240 = G__74251;
i__74241 = G__74252;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__74238);
if(temp__5735__auto__){
var seq__74238__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74238__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__74238__$1);
var G__74253 = cljs.core.chunk_rest.call(null,seq__74238__$1);
var G__74254 = c__4556__auto__;
var G__74255 = cljs.core.count.call(null,c__4556__auto__);
var G__74256 = (0);
seq__74238 = G__74253;
chunk__74239 = G__74254;
count__74240 = G__74255;
i__74241 = G__74256;
continue;
} else {
var k = cljs.core.first.call(null,seq__74238__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__74257 = cljs.core.next.call(null,seq__74238__$1);
var G__74258 = null;
var G__74259 = (0);
var G__74260 = (0);
seq__74238 = G__74257;
chunk__74239 = G__74258;
count__74240 = G__74259;
i__74241 = G__74260;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_74234 = cljs.core.async.take_BANG_.call(null,pc,inst_74233);
var state_74236__$1 = (function (){var statearr_74242 = state_74236;
(statearr_74242[(7)] = inst_74232);

return statearr_74242;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74236__$1,inst_74234);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__11469__auto__ = null;
var fluree$db$connection_js$state_machine__11469__auto____0 = (function (){
var statearr_74243 = [null,null,null,null,null,null,null,null];
(statearr_74243[(0)] = fluree$db$connection_js$state_machine__11469__auto__);

(statearr_74243[(1)] = (1));

return statearr_74243;
});
var fluree$db$connection_js$state_machine__11469__auto____1 = (function (state_74236){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74236);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74244){var ex__11472__auto__ = e74244;
var statearr_74245_74261 = state_74236;
(statearr_74245_74261[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74236[(4)]))){
var statearr_74246_74262 = state_74236;
(statearr_74246_74262[(1)] = cljs.core.first.call(null,(state_74236[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74263 = state_74236;
state_74236 = G__74263;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11469__auto__ = function(state_74236){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11469__auto____1.call(this,state_74236);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11469__auto____0;
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11469__auto____1;
return fluree$db$connection_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74247 = f__11543__auto__.call(null);
(statearr_74247[(6)] = c__11542__auto__);

return statearr_74247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__74265 = arguments.length;
switch (G__74265) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74299){
var state_val_74300 = (state_74299[(1)]);
if((state_val_74300 === (1))){
var state_74299__$1 = state_74299;
var statearr_74301_74322 = state_74299__$1;
(statearr_74301_74322[(2)] = null);

(statearr_74301_74322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (2))){
var _ = (function (){var statearr_74302 = state_74299;
(statearr_74302[(4)] = cljs.core.cons.call(null,(5),(state_74299[(4)])));

return statearr_74302;
})();
var inst_74274 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_74275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74276 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_74277 = (new cljs.core.PersistentVector(null,1,(5),inst_74275,inst_74276,null));
var inst_74278 = cljs.core.PersistentHashMap.EMPTY;
var inst_74279 = cljs.core.atom.call(null,inst_74278);
var inst_74280 = cljs.core.assoc_in.call(null,inst_74274,inst_74277,inst_74279);
var inst_74281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74282 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_74283 = (new cljs.core.PersistentVector(null,1,(5),inst_74281,inst_74282,null));
var inst_74284 = cljs.core.PersistentHashMap.EMPTY;
var inst_74285 = cljs.core.atom.call(null,inst_74284);
var inst_74286 = cljs.core.assoc_in.call(null,inst_74280,inst_74283,inst_74285);
var inst_74287 = cljs.core.async.promise_chan.call(null);
var inst_74288 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_74286);
var inst_74289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74290 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_74287,null];
var inst_74291 = (new cljs.core.PersistentVector(null,4,(5),inst_74289,inst_74290,null));
var inst_74292 = cljs.core.async.put_BANG_.call(null,inst_74288,inst_74291);
var inst_74293 = (function (){var conn = inst_74286;
var pc = inst_74287;
return (function (x){
if((x == null)){
} else {
var seq__74303_74323 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__74304_74324 = null;
var count__74305_74325 = (0);
var i__74306_74326 = (0);
while(true){
if((i__74306_74326 < count__74305_74325)){
var k_74327 = cljs.core._nth.call(null,chunk__74304_74324,i__74306_74326);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74327], null),cljs.core.get.call(null,x,k_74327,null));


var G__74328 = seq__74303_74323;
var G__74329 = chunk__74304_74324;
var G__74330 = count__74305_74325;
var G__74331 = (i__74306_74326 + (1));
seq__74303_74323 = G__74328;
chunk__74304_74324 = G__74329;
count__74305_74325 = G__74330;
i__74306_74326 = G__74331;
continue;
} else {
var temp__5735__auto___74332 = cljs.core.seq.call(null,seq__74303_74323);
if(temp__5735__auto___74332){
var seq__74303_74333__$1 = temp__5735__auto___74332;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__74303_74333__$1)){
var c__4556__auto___74334 = cljs.core.chunk_first.call(null,seq__74303_74333__$1);
var G__74335 = cljs.core.chunk_rest.call(null,seq__74303_74333__$1);
var G__74336 = c__4556__auto___74334;
var G__74337 = cljs.core.count.call(null,c__4556__auto___74334);
var G__74338 = (0);
seq__74303_74323 = G__74335;
chunk__74304_74324 = G__74336;
count__74305_74325 = G__74337;
i__74306_74326 = G__74338;
continue;
} else {
var k_74339 = cljs.core.first.call(null,seq__74303_74333__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_74339], null),cljs.core.get.call(null,x,k_74339,null));


var G__74340 = cljs.core.next.call(null,seq__74303_74333__$1);
var G__74341 = null;
var G__74342 = (0);
var G__74343 = (0);
seq__74303_74323 = G__74340;
chunk__74304_74324 = G__74341;
count__74305_74325 = G__74342;
i__74306_74326 = G__74343;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_74294 = cljs.core.async.take_BANG_.call(null,inst_74287,inst_74293);
var ___$1 = (function (){var statearr_74307 = state_74299;
(statearr_74307[(4)] = cljs.core.rest.call(null,(state_74299[(4)])));

return statearr_74307;
})();
var state_74299__$1 = (function (){var statearr_74308 = state_74299;
(statearr_74308[(7)] = inst_74292);

return statearr_74308;
})();
var statearr_74309_74344 = state_74299__$1;
(statearr_74309_74344[(2)] = inst_74294);

(statearr_74309_74344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (3))){
var inst_74297 = (state_74299[(2)]);
var state_74299__$1 = state_74299;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74299__$1,inst_74297);
} else {
if((state_val_74300 === (4))){
var inst_74266 = (state_74299[(2)]);
var inst_74267 = fluree.db.util.log.error.call(null,inst_74266);
var inst_74268 = reject.call(null,inst_74266);
var state_74299__$1 = (function (){var statearr_74311 = state_74299;
(statearr_74311[(8)] = inst_74267);

return statearr_74311;
})();
var statearr_74312_74345 = state_74299__$1;
(statearr_74312_74345[(2)] = inst_74268);

(statearr_74312_74345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74300 === (5))){
var _ = (function (){var statearr_74313 = state_74299;
(statearr_74313[(4)] = cljs.core.rest.call(null,(state_74299[(4)])));

return statearr_74313;
})();
var state_74299__$1 = state_74299;
var ex74310 = (state_74299__$1[(2)]);
var statearr_74314_74346 = state_74299__$1;
(statearr_74314_74346[(5)] = ex74310);


var statearr_74315_74347 = state_74299__$1;
(statearr_74315_74347[(1)] = (4));

(statearr_74315_74347[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11469__auto__ = null;
var fluree$db$connection_js$state_machine__11469__auto____0 = (function (){
var statearr_74316 = [null,null,null,null,null,null,null,null,null];
(statearr_74316[(0)] = fluree$db$connection_js$state_machine__11469__auto__);

(statearr_74316[(1)] = (1));

return statearr_74316;
});
var fluree$db$connection_js$state_machine__11469__auto____1 = (function (state_74299){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74299);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74317){var ex__11472__auto__ = e74317;
var statearr_74318_74348 = state_74299;
(statearr_74318_74348[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74299[(4)]))){
var statearr_74319_74349 = state_74299;
(statearr_74319_74349[(1)] = cljs.core.first.call(null,(state_74299[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74350 = state_74299;
state_74299 = G__74350;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11469__auto__ = function(state_74299){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11469__auto____1.call(this,state_74299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11469__auto____0;
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11469__auto____1;
return fluree$db$connection_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74320 = f__11543__auto__.call(null);
(statearr_74320[(6)] = c__11542__auto__);

return statearr_74320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__74352 = arguments.length;
switch (G__74352) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__74354 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__74354,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__74354,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__74357 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__74357,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__74357,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74410){
var state_val_74411 = (state_74410[(1)]);
if((state_val_74411 === (7))){
var inst_74371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74372 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74373 = cljs.core.PersistentHashMap.fromArrays(inst_74371,inst_74372);
var inst_74374 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_74373);
var inst_74375 = (function(){throw inst_74374})();
var state_74410__$1 = state_74410;
var statearr_74412_74441 = state_74410__$1;
(statearr_74412_74441[(2)] = inst_74375);

(statearr_74412_74441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (1))){
var state_74410__$1 = state_74410;
var statearr_74413_74442 = state_74410__$1;
(statearr_74413_74442[(2)] = null);

(statearr_74413_74442[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (4))){
var inst_74360 = (state_74410[(2)]);
var inst_74361 = cljs.core.clj__GT_js.call(null,inst_74360);
var inst_74362 = reject.call(null,inst_74361);
var state_74410__$1 = state_74410;
var statearr_74414_74443 = state_74410__$1;
(statearr_74414_74443[(2)] = inst_74362);

(statearr_74414_74443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (13))){
var inst_74389 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74390 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74391 = cljs.core.PersistentHashMap.fromArrays(inst_74389,inst_74390);
var inst_74392 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_74391);
var inst_74393 = (function(){throw inst_74392})();
var state_74410__$1 = state_74410;
var statearr_74415_74444 = state_74410__$1;
(statearr_74415_74444[(2)] = inst_74393);

(statearr_74415_74444[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (6))){
var state_74410__$1 = state_74410;
var statearr_74416_74445 = state_74410__$1;
(statearr_74416_74445[(2)] = null);

(statearr_74416_74445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (3))){
var inst_74408 = (state_74410[(2)]);
var state_74410__$1 = state_74410;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74410__$1,inst_74408);
} else {
if((state_val_74411 === (12))){
var state_74410__$1 = state_74410;
var statearr_74417_74446 = state_74410__$1;
(statearr_74417_74446[(2)] = null);

(statearr_74417_74446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (2))){
var _ = (function (){var statearr_74418 = state_74410;
(statearr_74418[(4)] = cljs.core.cons.call(null,(5),(state_74410[(4)])));

return statearr_74418;
})();
var inst_74368 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_74410__$1 = state_74410;
if(cljs.core.truth_(inst_74368)){
var statearr_74419_74447 = state_74410__$1;
(statearr_74419_74447[(1)] = (6));

} else {
var statearr_74420_74448 = state_74410__$1;
(statearr_74420_74448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (11))){
var inst_74386 = (state_74410[(2)]);
var state_74410__$1 = (function (){var statearr_74422 = state_74410;
(statearr_74422[(7)] = inst_74386);

return statearr_74422;
})();
if(cljs.core.truth_(password)){
var statearr_74423_74449 = state_74410__$1;
(statearr_74423_74449[(1)] = (12));

} else {
var statearr_74424_74450 = state_74410__$1;
(statearr_74424_74450[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (9))){
var state_74410__$1 = state_74410;
var statearr_74425_74451 = state_74410__$1;
(statearr_74425_74451[(2)] = null);

(statearr_74425_74451[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (5))){
var _ = (function (){var statearr_74426 = state_74410;
(statearr_74426[(4)] = cljs.core.rest.call(null,(state_74410[(4)])));

return statearr_74426;
})();
var state_74410__$1 = state_74410;
var ex74421 = (state_74410__$1[(2)]);
var statearr_74427_74452 = state_74410__$1;
(statearr_74427_74452[(5)] = ex74421);


var statearr_74428_74453 = state_74410__$1;
(statearr_74428_74453[(1)] = (4));

(statearr_74428_74453[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (14))){
var inst_74395 = (state_74410[(2)]);
var inst_74396 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_74397 = fluree.db.util.core.without_nils.call(null,inst_74396);
var inst_74398 = cljs.core.async.promise_chan.call(null);
var inst_74399 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74401 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_74397,inst_74398,null];
var inst_74402 = (new cljs.core.PersistentVector(null,4,(5),inst_74400,inst_74401,null));
var inst_74403 = cljs.core.async.put_BANG_.call(null,inst_74399,inst_74402);
var inst_74404 = (function (){var _ = inst_74395;
var data = inst_74397;
var pc = inst_74398;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_74405 = cljs.core.async.take_BANG_.call(null,inst_74398,inst_74404);
var _ = (function (){var statearr_74429 = state_74410;
(statearr_74429[(4)] = cljs.core.rest.call(null,(state_74410[(4)])));

return statearr_74429;
})();
var state_74410__$1 = (function (){var statearr_74430 = state_74410;
(statearr_74430[(8)] = inst_74403);

return statearr_74430;
})();
var statearr_74431_74454 = state_74410__$1;
(statearr_74431_74454[(2)] = inst_74405);

(statearr_74431_74454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (10))){
var inst_74380 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74381 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74382 = cljs.core.PersistentHashMap.fromArrays(inst_74380,inst_74381);
var inst_74383 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_74382);
var inst_74384 = (function(){throw inst_74383})();
var state_74410__$1 = state_74410;
var statearr_74432_74455 = state_74410__$1;
(statearr_74432_74455[(2)] = inst_74384);

(statearr_74432_74455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74411 === (8))){
var inst_74377 = (state_74410[(2)]);
var state_74410__$1 = (function (){var statearr_74433 = state_74410;
(statearr_74433[(9)] = inst_74377);

return statearr_74433;
})();
if(cljs.core.truth_(ledger)){
var statearr_74434_74456 = state_74410__$1;
(statearr_74434_74456[(1)] = (9));

} else {
var statearr_74435_74457 = state_74410__$1;
(statearr_74435_74457[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__11469__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__11469__auto____0 = (function (){
var statearr_74436 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74436[(0)] = fluree$db$connection_js$password_generate_$_state_machine__11469__auto__);

(statearr_74436[(1)] = (1));

return statearr_74436;
});
var fluree$db$connection_js$password_generate_$_state_machine__11469__auto____1 = (function (state_74410){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74410);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74437){var ex__11472__auto__ = e74437;
var statearr_74438_74458 = state_74410;
(statearr_74438_74458[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74410[(4)]))){
var statearr_74439_74459 = state_74410;
(statearr_74439_74459[(1)] = cljs.core.first.call(null,(state_74410[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74460 = state_74410;
state_74410 = G__74460;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__11469__auto__ = function(state_74410){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__11469__auto____1.call(this,state_74410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__11469__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__11469__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74440 = f__11543__auto__.call(null);
(statearr_74440[(6)] = c__11542__auto__);

return statearr_74440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__74462 = arguments.length;
switch (G__74462) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74529){
var state_val_74530 = (state_74529[(1)]);
if((state_val_74530 === (7))){
var inst_74474 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74475 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74476 = cljs.core.PersistentHashMap.fromArrays(inst_74474,inst_74475);
var inst_74477 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_74476);
var inst_74478 = (function(){throw inst_74477})();
var state_74529__$1 = state_74529;
var statearr_74531_74570 = state_74529__$1;
(statearr_74531_74570[(2)] = inst_74478);

(statearr_74531_74570[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (20))){
var inst_74512 = (state_74529[(2)]);
var inst_74513 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74514 = [ledger,password,user,auth,expire];
var inst_74515 = cljs.core.PersistentHashMap.fromArrays(inst_74513,inst_74514);
var inst_74516 = fluree.db.util.core.without_nils.call(null,inst_74515);
var inst_74517 = cljs.core.async.promise_chan.call(null);
var inst_74518 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74520 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_74516,inst_74517,null];
var inst_74521 = (new cljs.core.PersistentVector(null,4,(5),inst_74519,inst_74520,null));
var inst_74522 = cljs.core.async.put_BANG_.call(null,inst_74518,inst_74521);
var inst_74523 = (function (){var _ = inst_74512;
var data = inst_74516;
var pc = inst_74517;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_74524 = cljs.core.async.take_BANG_.call(null,inst_74517,inst_74523);
var _ = (function (){var statearr_74532 = state_74529;
(statearr_74532[(4)] = cljs.core.rest.call(null,(state_74529[(4)])));

return statearr_74532;
})();
var state_74529__$1 = (function (){var statearr_74533 = state_74529;
(statearr_74533[(7)] = inst_74522);

return statearr_74533;
})();
var statearr_74534_74571 = state_74529__$1;
(statearr_74534_74571[(2)] = inst_74524);

(statearr_74534_74571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (1))){
var state_74529__$1 = state_74529;
var statearr_74535_74572 = state_74529__$1;
(statearr_74535_74572[(2)] = null);

(statearr_74535_74572[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (4))){
var inst_74463 = (state_74529[(2)]);
var inst_74464 = cljs.core.clj__GT_js.call(null,inst_74463);
var inst_74465 = reject.call(null,inst_74464);
var state_74529__$1 = state_74529;
var statearr_74536_74573 = state_74529__$1;
(statearr_74536_74573[(2)] = inst_74465);

(statearr_74536_74573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (15))){
var inst_74499 = (state_74529[(8)]);
var state_74529__$1 = state_74529;
var statearr_74537_74574 = state_74529__$1;
(statearr_74537_74574[(2)] = inst_74499);

(statearr_74537_74574[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (13))){
var inst_74492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74493 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74494 = cljs.core.PersistentHashMap.fromArrays(inst_74492,inst_74493);
var inst_74495 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_74494);
var inst_74496 = (function(){throw inst_74495})();
var state_74529__$1 = state_74529;
var statearr_74538_74575 = state_74529__$1;
(statearr_74538_74575[(2)] = inst_74496);

(statearr_74538_74575[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (6))){
var state_74529__$1 = state_74529;
var statearr_74539_74576 = state_74529__$1;
(statearr_74539_74576[(2)] = null);

(statearr_74539_74576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (17))){
var inst_74503 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
if(cljs.core.truth_(inst_74503)){
var statearr_74540_74577 = state_74529__$1;
(statearr_74540_74577[(1)] = (18));

} else {
var statearr_74541_74578 = state_74529__$1;
(statearr_74541_74578[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (3))){
var inst_74527 = (state_74529[(2)]);
var state_74529__$1 = state_74529;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74529__$1,inst_74527);
} else {
if((state_val_74530 === (12))){
var state_74529__$1 = state_74529;
var statearr_74542_74579 = state_74529__$1;
(statearr_74542_74579[(2)] = null);

(statearr_74542_74579[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (2))){
var _ = (function (){var statearr_74543 = state_74529;
(statearr_74543[(4)] = cljs.core.cons.call(null,(5),(state_74529[(4)])));

return statearr_74543;
})();
var inst_74471 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_74529__$1 = state_74529;
if(cljs.core.truth_(inst_74471)){
var statearr_74544_74580 = state_74529__$1;
(statearr_74544_74580[(1)] = (6));

} else {
var statearr_74545_74581 = state_74529__$1;
(statearr_74545_74581[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (19))){
var inst_74506 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74507 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74508 = cljs.core.PersistentHashMap.fromArrays(inst_74506,inst_74507);
var inst_74509 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_74508);
var inst_74510 = (function(){throw inst_74509})();
var state_74529__$1 = state_74529;
var statearr_74546_74582 = state_74529__$1;
(statearr_74546_74582[(2)] = inst_74510);

(statearr_74546_74582[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (11))){
var inst_74489 = (state_74529[(2)]);
var state_74529__$1 = (function (){var statearr_74548 = state_74529;
(statearr_74548[(9)] = inst_74489);

return statearr_74548;
})();
if(cljs.core.truth_(password)){
var statearr_74549_74583 = state_74529__$1;
(statearr_74549_74583[(1)] = (12));

} else {
var statearr_74550_74584 = state_74529__$1;
(statearr_74550_74584[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (9))){
var state_74529__$1 = state_74529;
var statearr_74551_74585 = state_74529__$1;
(statearr_74551_74585[(2)] = null);

(statearr_74551_74585[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (5))){
var _ = (function (){var statearr_74552 = state_74529;
(statearr_74552[(4)] = cljs.core.rest.call(null,(state_74529[(4)])));

return statearr_74552;
})();
var state_74529__$1 = state_74529;
var ex74547 = (state_74529__$1[(2)]);
var statearr_74553_74586 = state_74529__$1;
(statearr_74553_74586[(5)] = ex74547);


var statearr_74554_74587 = state_74529__$1;
(statearr_74554_74587[(1)] = (4));

(statearr_74554_74587[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (14))){
var inst_74499 = (state_74529[(8)]);
var inst_74498 = (state_74529[(2)]);
var inst_74499__$1 = user;
var state_74529__$1 = (function (){var statearr_74555 = state_74529;
(statearr_74555[(10)] = inst_74498);

(statearr_74555[(8)] = inst_74499__$1);

return statearr_74555;
})();
if(cljs.core.truth_(inst_74499__$1)){
var statearr_74556_74588 = state_74529__$1;
(statearr_74556_74588[(1)] = (15));

} else {
var statearr_74557_74589 = state_74529__$1;
(statearr_74557_74589[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (16))){
var state_74529__$1 = state_74529;
var statearr_74558_74590 = state_74529__$1;
(statearr_74558_74590[(2)] = auth);

(statearr_74558_74590[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (10))){
var inst_74483 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74484 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_74485 = cljs.core.PersistentHashMap.fromArrays(inst_74483,inst_74484);
var inst_74486 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_74485);
var inst_74487 = (function(){throw inst_74486})();
var state_74529__$1 = state_74529;
var statearr_74559_74591 = state_74529__$1;
(statearr_74559_74591[(2)] = inst_74487);

(statearr_74559_74591[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (18))){
var state_74529__$1 = state_74529;
var statearr_74560_74592 = state_74529__$1;
(statearr_74560_74592[(2)] = null);

(statearr_74560_74592[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74530 === (8))){
var inst_74480 = (state_74529[(2)]);
var state_74529__$1 = (function (){var statearr_74561 = state_74529;
(statearr_74561[(11)] = inst_74480);

return statearr_74561;
})();
if(cljs.core.truth_(ledger)){
var statearr_74562_74593 = state_74529__$1;
(statearr_74562_74593[(1)] = (9));

} else {
var statearr_74563_74594 = state_74529__$1;
(statearr_74563_74594[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11469__auto__ = null;
var fluree$db$connection_js$state_machine__11469__auto____0 = (function (){
var statearr_74564 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74564[(0)] = fluree$db$connection_js$state_machine__11469__auto__);

(statearr_74564[(1)] = (1));

return statearr_74564;
});
var fluree$db$connection_js$state_machine__11469__auto____1 = (function (state_74529){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74529);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74565){var ex__11472__auto__ = e74565;
var statearr_74566_74595 = state_74529;
(statearr_74566_74595[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74529[(4)]))){
var statearr_74567_74596 = state_74529;
(statearr_74567_74596[(1)] = cljs.core.first.call(null,(state_74529[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74597 = state_74529;
state_74529 = G__74597;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11469__auto__ = function(state_74529){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11469__auto____1.call(this,state_74529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11469__auto____0;
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11469__auto____1;
return fluree$db$connection_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74568 = f__11543__auto__.call(null);
(statearr_74568[(6)] = c__11542__auto__);

return statearr_74568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__74599 = arguments.length;
switch (G__74599) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74634){
var state_val_74635 = (state_74634[(1)]);
if((state_val_74635 === (1))){
var state_74634__$1 = state_74634;
var statearr_74636_74656 = state_74634__$1;
(statearr_74636_74656[(2)] = null);

(statearr_74636_74656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (2))){
var _ = (function (){var statearr_74637 = state_74634;
(statearr_74637[(4)] = cljs.core.cons.call(null,(5),(state_74634[(4)])));

return statearr_74637;
})();
var inst_74608 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_74634__$1 = state_74634;
if(cljs.core.truth_(inst_74608)){
var statearr_74638_74657 = state_74634__$1;
(statearr_74638_74657[(1)] = (6));

} else {
var statearr_74639_74658 = state_74634__$1;
(statearr_74639_74658[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (3))){
var inst_74632 = (state_74634[(2)]);
var state_74634__$1 = state_74634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74634__$1,inst_74632);
} else {
if((state_val_74635 === (4))){
var inst_74600 = (state_74634[(2)]);
var inst_74601 = cljs.core.clj__GT_js.call(null,inst_74600);
var inst_74602 = reject.call(null,inst_74601);
var state_74634__$1 = state_74634;
var statearr_74641_74659 = state_74634__$1;
(statearr_74641_74659[(2)] = inst_74602);

(statearr_74641_74659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (5))){
var _ = (function (){var statearr_74642 = state_74634;
(statearr_74642[(4)] = cljs.core.rest.call(null,(state_74634[(4)])));

return statearr_74642;
})();
var state_74634__$1 = state_74634;
var ex74640 = (state_74634__$1[(2)]);
var statearr_74643_74660 = state_74634__$1;
(statearr_74643_74660[(5)] = ex74640);


var statearr_74644_74661 = state_74634__$1;
(statearr_74644_74661[(1)] = (4));

(statearr_74644_74661[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (6))){
var state_74634__$1 = state_74634;
var statearr_74645_74662 = state_74634__$1;
(statearr_74645_74662[(2)] = null);

(statearr_74645_74662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (7))){
var inst_74611 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74612 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_74613 = cljs.core.PersistentHashMap.fromArrays(inst_74611,inst_74612);
var inst_74614 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_74613);
var inst_74615 = (function(){throw inst_74614})();
var state_74634__$1 = state_74634;
var statearr_74646_74663 = state_74634__$1;
(statearr_74646_74663[(2)] = inst_74615);

(statearr_74646_74663[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74635 === (8))){
var inst_74617 = (state_74634[(2)]);
var inst_74618 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_74619 = [jwt,expire];
var inst_74620 = cljs.core.PersistentHashMap.fromArrays(inst_74618,inst_74619);
var inst_74621 = fluree.db.util.core.without_nils.call(null,inst_74620);
var inst_74622 = cljs.core.async.promise_chan.call(null);
var inst_74623 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_74624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74625 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_74621,inst_74622,null];
var inst_74626 = (new cljs.core.PersistentVector(null,4,(5),inst_74624,inst_74625,null));
var inst_74627 = cljs.core.async.put_BANG_.call(null,inst_74623,inst_74626);
var inst_74628 = (function (){var _ = inst_74617;
var data = inst_74621;
var pc = inst_74622;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_74629 = cljs.core.async.take_BANG_.call(null,inst_74622,inst_74628);
var _ = (function (){var statearr_74647 = state_74634;
(statearr_74647[(4)] = cljs.core.rest.call(null,(state_74634[(4)])));

return statearr_74647;
})();
var state_74634__$1 = (function (){var statearr_74648 = state_74634;
(statearr_74648[(7)] = inst_74627);

return statearr_74648;
})();
var statearr_74649_74664 = state_74634__$1;
(statearr_74649_74664[(2)] = inst_74629);

(statearr_74649_74664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__11469__auto__ = null;
var fluree$db$connection_js$state_machine__11469__auto____0 = (function (){
var statearr_74650 = [null,null,null,null,null,null,null,null];
(statearr_74650[(0)] = fluree$db$connection_js$state_machine__11469__auto__);

(statearr_74650[(1)] = (1));

return statearr_74650;
});
var fluree$db$connection_js$state_machine__11469__auto____1 = (function (state_74634){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74651){var ex__11472__auto__ = e74651;
var statearr_74652_74665 = state_74634;
(statearr_74652_74665[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74634[(4)]))){
var statearr_74653_74666 = state_74634;
(statearr_74653_74666[(1)] = cljs.core.first.call(null,(state_74634[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74667 = state_74634;
state_74634 = G__74667;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__11469__auto__ = function(state_74634){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__11469__auto____1.call(this,state_74634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__11469__auto____0;
fluree$db$connection_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__11469__auto____1;
return fluree$db$connection_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74654 = f__11543__auto__.call(null);
(statearr_74654[(6)] = c__11542__auto__);

return statearr_74654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

