// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___74774 = arguments.length;
var i__4737__auto___74775 = (0);
while(true){
if((i__4737__auto___74775 < len__4736__auto___74774)){
args__4742__auto__.push((arguments[i__4737__auto___74775]));

var G__74776 = (i__4737__auto___74775 + (1));
i__4737__auto___74775 = G__74776;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__74673){
var vec__74674 = p__74673;
var opts = cljs.core.nth.call(null,vec__74674,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___74777 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74738){
var state_val_74739 = (state_74738[(1)]);
if((state_val_74739 === (7))){
var state_74738__$1 = state_74738;
var statearr_74740_74778 = state_74738__$1;
(statearr_74740_74778[(2)] = false);

(statearr_74740_74778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (1))){
var state_74738__$1 = state_74738;
var statearr_74741_74779 = state_74738__$1;
(statearr_74741_74779[(2)] = null);

(statearr_74741_74779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (4))){
var inst_74677 = (state_74738[(2)]);
var inst_74678 = fluree.db.util.log.error.call(null,inst_74677);
var inst_74679 = cljs.core.async.put_BANG_.call(null,pc,inst_74677);
var inst_74680 = cljs.core.async.close_BANG_.call(null,pc);
var state_74738__$1 = (function (){var statearr_74742 = state_74738;
(statearr_74742[(7)] = inst_74678);

(statearr_74742[(8)] = inst_74679);

return statearr_74742;
})();
var statearr_74743_74780 = state_74738__$1;
(statearr_74743_74780[(2)] = inst_74680);

(statearr_74743_74780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (15))){
var inst_74719 = (state_74738[(9)]);
var inst_74718 = (state_74738[(10)]);
var inst_74715 = (state_74738[(11)]);
var inst_74722 = (state_74738[(2)]);
var inst_74723 = fluree.db.util.async.throw_err.call(null,inst_74722);
var inst_74724 = cljs.core.assoc.call(null,inst_74723,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_74718,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_74719);
var state_74738__$1 = (function (){var statearr_74744 = state_74738;
(statearr_74744[(12)] = inst_74724);

return statearr_74744;
})();
if(cljs.core.truth_(inst_74715)){
var statearr_74745_74781 = state_74738__$1;
(statearr_74745_74781[(1)] = (16));

} else {
var statearr_74746_74782 = state_74738__$1;
(statearr_74746_74782[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (13))){
var inst_74690 = (state_74738[(13)]);
var state_74738__$1 = state_74738;
var statearr_74747_74783 = state_74738__$1;
(statearr_74747_74783[(2)] = inst_74690);

(statearr_74747_74783[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (6))){
var inst_74690 = (state_74738[(13)]);
var inst_74695 = inst_74690.cljs$lang$protocol_mask$partition0$;
var inst_74696 = (inst_74695 & (64));
var inst_74697 = inst_74690.cljs$core$ISeq$;
var inst_74698 = (cljs.core.PROTOCOL_SENTINEL === inst_74697);
var inst_74699 = ((inst_74696) || (inst_74698));
var state_74738__$1 = state_74738;
if(cljs.core.truth_(inst_74699)){
var statearr_74748_74784 = state_74738__$1;
(statearr_74748_74784[(1)] = (9));

} else {
var statearr_74749_74785 = state_74738__$1;
(statearr_74749_74785[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (17))){
var inst_74724 = (state_74738[(12)]);
var state_74738__$1 = state_74738;
var statearr_74750_74786 = state_74738__$1;
(statearr_74750_74786[(2)] = inst_74724);

(statearr_74750_74786[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (3))){
var inst_74736 = (state_74738[(2)]);
var state_74738__$1 = state_74738;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74738__$1,inst_74736);
} else {
if((state_val_74739 === (12))){
var inst_74690 = (state_74738[(13)]);
var inst_74708 = cljs.core.apply.call(null,cljs.core.hash_map,inst_74690);
var state_74738__$1 = state_74738;
var statearr_74751_74787 = state_74738__$1;
(statearr_74751_74787[(2)] = inst_74708);

(statearr_74751_74787[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (2))){
var inst_74690 = (state_74738[(13)]);
var _ = (function (){var statearr_74752 = state_74738;
(statearr_74752[(4)] = cljs.core.cons.call(null,(5),(state_74738[(4)])));

return statearr_74752;
})();
var inst_74690__$1 = opts;
var inst_74692 = (inst_74690__$1 == null);
var inst_74693 = cljs.core.not.call(null,inst_74692);
var state_74738__$1 = (function (){var statearr_74753 = state_74738;
(statearr_74753[(13)] = inst_74690__$1);

return statearr_74753;
})();
if(inst_74693){
var statearr_74754_74788 = state_74738__$1;
(statearr_74754_74788[(1)] = (6));

} else {
var statearr_74755_74789 = state_74738__$1;
(statearr_74755_74789[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (19))){
var inst_74728 = (state_74738[(2)]);
var inst_74729 = fluree.db.util.async.throw_err.call(null,inst_74728);
var state_74738__$1 = state_74738;
var statearr_74756_74790 = state_74738__$1;
(statearr_74756_74790[(2)] = inst_74729);

(statearr_74756_74790[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (11))){
var inst_74703 = (state_74738[(2)]);
var state_74738__$1 = state_74738;
var statearr_74758_74791 = state_74738__$1;
(statearr_74758_74791[(2)] = inst_74703);

(statearr_74758_74791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (9))){
var state_74738__$1 = state_74738;
var statearr_74759_74792 = state_74738__$1;
(statearr_74759_74792[(2)] = true);

(statearr_74759_74792[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (5))){
var _ = (function (){var statearr_74760 = state_74738;
(statearr_74760[(4)] = cljs.core.rest.call(null,(state_74738[(4)])));

return statearr_74760;
})();
var state_74738__$1 = state_74738;
var ex74757 = (state_74738__$1[(2)]);
var statearr_74761_74793 = state_74738__$1;
(statearr_74761_74793[(5)] = ex74757);


var statearr_74762_74794 = state_74738__$1;
(statearr_74762_74794[(1)] = (4));

(statearr_74762_74794[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (14))){
var inst_74711 = (state_74738[(2)]);
var inst_74712 = cljs.core.get.call(null,inst_74711,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_74713 = cljs.core.get.call(null,inst_74711,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_74714 = cljs.core.get.call(null,inst_74711,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_74715 = cljs.core.get.call(null,inst_74711,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74716 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_74717 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_74718 = cljs.core.nth.call(null,inst_74717,(0),null);
var inst_74719 = cljs.core.nth.call(null,inst_74717,(1),null);
var inst_74720 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_74738__$1 = (function (){var statearr_74763 = state_74738;
(statearr_74763[(9)] = inst_74719);

(statearr_74763[(14)] = inst_74716);

(statearr_74763[(10)] = inst_74718);

(statearr_74763[(11)] = inst_74715);

(statearr_74763[(15)] = inst_74714);

(statearr_74763[(16)] = inst_74713);

(statearr_74763[(17)] = inst_74712);

return statearr_74763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74738__$1,(15),inst_74720);
} else {
if((state_val_74739 === (16))){
var inst_74724 = (state_74738[(12)]);
var inst_74715 = (state_74738[(11)]);
var inst_74726 = fluree.db.time_travel.as_of_block.call(null,inst_74724,inst_74715);
var state_74738__$1 = state_74738;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74738__$1,(19),inst_74726);
} else {
if((state_val_74739 === (10))){
var state_74738__$1 = state_74738;
var statearr_74764_74795 = state_74738__$1;
(statearr_74764_74795[(2)] = false);

(statearr_74764_74795[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (18))){
var inst_74732 = (state_74738[(2)]);
var inst_74733 = cljs.core.async.put_BANG_.call(null,pc,inst_74732);
var _ = (function (){var statearr_74765 = state_74738;
(statearr_74765[(4)] = cljs.core.rest.call(null,(state_74738[(4)])));

return statearr_74765;
})();
var state_74738__$1 = state_74738;
var statearr_74766_74796 = state_74738__$1;
(statearr_74766_74796[(2)] = inst_74733);

(statearr_74766_74796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74739 === (8))){
var inst_74706 = (state_74738[(2)]);
var state_74738__$1 = state_74738;
if(cljs.core.truth_(inst_74706)){
var statearr_74767_74797 = state_74738__$1;
(statearr_74767_74797[(1)] = (12));

} else {
var statearr_74768_74798 = state_74738__$1;
(statearr_74768_74798[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_74769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74769[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_74769[(1)] = (1));

return statearr_74769;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_74738){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74738);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74770){var ex__11472__auto__ = e74770;
var statearr_74771_74799 = state_74738;
(statearr_74771_74799[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74738[(4)]))){
var statearr_74772_74800 = state_74738;
(statearr_74772_74800[(1)] = cljs.core.first.call(null,(state_74738[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74801 = state_74738;
state_74738 = G__74801;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_74738){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_74738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74773 = f__11543__auto__.call(null);
(statearr_74773[(6)] = c__11542__auto___74777);

return statearr_74773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq74670){
var G__74671 = cljs.core.first.call(null,seq74670);
var seq74670__$1 = cljs.core.next.call(null,seq74670);
var G__74672 = cljs.core.first.call(null,seq74670__$1);
var seq74670__$2 = cljs.core.next.call(null,seq74670__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74671,G__74672,seq74670__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?open_api:false))){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_.call(null,val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__74804 = arguments.length;
switch (G__74804) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74954){
var state_val_74955 = (state_74954[(1)]);
if((state_val_74955 === (7))){
var state_74954__$1 = state_74954;
var statearr_74956_75050 = state_74954__$1;
(statearr_74956_75050[(2)] = false);

(statearr_74956_75050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (59))){
var inst_74943 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_74957_75051 = state_74954__$1;
(statearr_74957_75051[(2)] = inst_74943);

(statearr_74957_75051[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (20))){
var inst_74842 = (state_74954[(7)]);
var inst_74858 = (state_74954[(8)]);
var inst_74859 = (state_74954[(9)]);
var inst_74861 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_74858);
var inst_74862 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_74859);
var inst_74863 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_74858);
var inst_74864 = fluree.db.api_js.get_sources.call(null,inst_74859,inst_74861,inst_74862,inst_74863,inst_74842,db_fn);
var state_74954__$1 = state_74954;
var statearr_74958_75052 = state_74954__$1;
(statearr_74958_75052[(2)] = inst_74864);

(statearr_74958_75052[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (58))){
var state_74954__$1 = state_74954;
var statearr_74959_75053 = state_74954__$1;
(statearr_74959_75053[(2)] = null);

(statearr_74959_75053[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (27))){
var inst_74844 = (state_74954[(10)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74844)){
var statearr_74960_75054 = state_74954__$1;
(statearr_74960_75054[(1)] = (29));

} else {
var statearr_74961_75055 = state_74954__$1;
(statearr_74961_75055[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (1))){
var state_74954__$1 = state_74954;
var statearr_74962_75056 = state_74954__$1;
(statearr_74962_75056[(2)] = null);

(statearr_74962_75056[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (24))){
var state_74954__$1 = state_74954;
var statearr_74963_75057 = state_74954__$1;
(statearr_74963_75057[(2)] = (1000000));

(statearr_74963_75057[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (55))){
var inst_74912 = (state_74954[(11)]);
var state_74954__$1 = state_74954;
var statearr_74964_75058 = state_74954__$1;
(statearr_74964_75058[(2)] = inst_74912);

(statearr_74964_75058[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (39))){
var inst_74893 = (state_74954[(12)]);
var state_74954__$1 = state_74954;
var statearr_74965_75059 = state_74954__$1;
(statearr_74965_75059[(2)] = inst_74893);

(statearr_74965_75059[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (46))){
var inst_74949 = (state_74954[(2)]);
var _ = (function (){var statearr_74966 = state_74954;
(statearr_74966[(4)] = cljs.core.rest.call(null,(state_74954[(4)])));

return statearr_74966;
})();
var state_74954__$1 = state_74954;
var statearr_74967_75060 = state_74954__$1;
(statearr_74967_75060[(2)] = inst_74949);

(statearr_74967_75060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (4))){
var inst_74805 = (state_74954[(2)]);
var inst_74806 = fluree.db.util.log.error.call(null,inst_74805);
var inst_74807 = cljs.core.ex_data.call(null,inst_74805);
var inst_74808 = cljs.core.ex_message.call(null,inst_74805);
var inst_74809 = cljs.core.assoc.call(null,inst_74807,new cljs.core.Keyword(null,"message","message",-406056002),inst_74808);
var state_74954__$1 = (function (){var statearr_74968 = state_74954;
(statearr_74968[(13)] = inst_74806);

return statearr_74968;
})();
var statearr_74969_75061 = state_74954__$1;
(statearr_74969_75061[(2)] = inst_74809);

(statearr_74969_75061[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (54))){
var inst_74912 = (state_74954[(11)]);
var inst_74926 = cljs.core.doall.call(null,inst_74912);
var state_74954__$1 = state_74954;
var statearr_74970_75062 = state_74954__$1;
(statearr_74970_75062[(2)] = inst_74926);

(statearr_74970_75062[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (15))){
var inst_74840 = (state_74954[(14)]);
var inst_74849 = (state_74954[(2)]);
var inst_74850 = fluree.db.util.async.throw_err.call(null,inst_74849);
var state_74954__$1 = (function (){var statearr_74971 = state_74954;
(statearr_74971[(15)] = inst_74850);

return statearr_74971;
})();
if(cljs.core.truth_(inst_74840)){
var statearr_74972_75063 = state_74954__$1;
(statearr_74972_75063[(1)] = (16));

} else {
var statearr_74973_75064 = state_74954__$1;
(statearr_74973_75064[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (48))){
var inst_74912 = (state_74954[(11)]);
var inst_74915 = cljs.core.ex_data.call(null,inst_74912);
var inst_74916 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74917 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_74915);
var inst_74918 = cljs.core.ex_message.call(null,inst_74912);
var inst_74919 = [inst_74917,inst_74918,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74920 = cljs.core.PersistentHashMap.fromArrays(inst_74916,inst_74919);
var state_74954__$1 = state_74954;
var statearr_74974_75065 = state_74954__$1;
(statearr_74974_75065[(2)] = inst_74920);

(statearr_74974_75065[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (50))){
var inst_74947 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_74975_75066 = state_74954__$1;
(statearr_74975_75066[(2)] = inst_74947);

(statearr_74975_75066[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (21))){
var inst_74866 = cljs.core.PersistentHashMap.EMPTY;
var state_74954__$1 = state_74954;
var statearr_74976_75067 = state_74954__$1;
(statearr_74976_75067[(2)] = inst_74866);

(statearr_74976_75067[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (31))){
var inst_74891 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_74977_75068 = state_74954__$1;
(statearr_74977_75068[(2)] = inst_74891);

(statearr_74977_75068[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (32))){
var inst_74843 = (state_74954[(16)]);
var state_74954__$1 = state_74954;
var statearr_74978_75069 = state_74954__$1;
(statearr_74978_75069[(2)] = inst_74843);

(statearr_74978_75069[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (40))){
var inst_74901 = (state_74954[(17)]);
var inst_74901__$1 = (state_74954[(2)]);
var inst_74902 = cljs.core.not.call(null,inst_74901__$1);
var state_74954__$1 = (function (){var statearr_74979 = state_74954;
(statearr_74979[(17)] = inst_74901__$1);

return statearr_74979;
})();
if(inst_74902){
var statearr_74980_75070 = state_74954__$1;
(statearr_74980_75070[(1)] = (44));

} else {
var statearr_74981_75071 = state_74954__$1;
(statearr_74981_75071[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (56))){
var inst_74842 = (state_74954[(7)]);
var inst_74847 = (state_74954[(18)]);
var inst_74875 = (state_74954[(19)]);
var inst_74913 = (state_74954[(20)]);
var inst_74874 = (state_74954[(21)]);
var inst_74844 = (state_74954[(10)]);
var inst_74841 = (state_74954[(22)]);
var inst_74858 = (state_74954[(8)]);
var inst_74869 = (state_74954[(23)]);
var inst_74859 = (state_74954[(9)]);
var inst_74845 = (state_74954[(24)]);
var inst_74923 = (state_74954[(25)]);
var inst_74876 = (state_74954[(26)]);
var inst_74850 = (state_74954[(15)]);
var inst_74838 = (state_74954[(27)]);
var inst_74840 = (state_74954[(14)]);
var inst_74839 = (state_74954[(28)]);
var inst_74837 = (state_74954[(29)]);
var inst_74901 = (state_74954[(17)]);
var inst_74912 = (state_74954[(11)]);
var inst_74877 = (state_74954[(30)]);
var inst_74843 = (state_74954[(16)]);
var inst_74868 = (state_74954[(31)]);
var inst_74929 = (state_74954[(2)]);
var inst_74930 = cljs.core.deref.call(null,inst_74869);
var inst_74931 = (function (){var error_QMARK_ = inst_74913;
var construct = inst_74838;
var valid_query_QMARK_ = inst_74901;
var conn = inst_74859;
var map__74815 = inst_74837;
var select = inst_74839;
var block = inst_74840;
var where = inst_74841;
var prefixes = inst_74842;
var db = inst_74850;
var meta_QMARK_ = inst_74875;
var source_opts = inst_74868;
var fuel = inst_74869;
var db_STAR_ = inst_74858;
var selectDistinct = inst_74843;
var result = inst_74912;
var start_ms = inst_74876;
var selectOne = inst_74844;
var from = inst_74845;
var max_fuel = inst_74874;
var opts = inst_74877;
var selectReduced = inst_74847;
return (function (p1__74802_SHARP_){
return goog.string.format("%.2fms",p1__74802_SHARP_);
});
})();
var inst_74932 = fluree.db.util.core.current_time_millis.call(null);
var inst_74933 = (inst_74932 - inst_74876);
var inst_74934 = (inst_74933 / (1000000));
var inst_74935 = inst_74931.call(null,inst_74934);
var inst_74936 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_74858);
var inst_74937 = [(200),inst_74929,inst_74930,inst_74935,inst_74936];
var inst_74938 = cljs.core.PersistentHashMap.fromArrays(inst_74923,inst_74937);
var state_74954__$1 = state_74954;
var statearr_74982_75072 = state_74954__$1;
(statearr_74982_75072[(2)] = inst_74938);

(statearr_74982_75072[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (33))){
var inst_74847 = (state_74954[(18)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74847)){
var statearr_74983_75073 = state_74954__$1;
(statearr_74983_75073[(1)] = (35));

} else {
var statearr_74984_75074 = state_74954__$1;
(statearr_74984_75074[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (13))){
var inst_74816 = (state_74954[(32)]);
var state_74954__$1 = state_74954;
var statearr_74985_75075 = state_74954__$1;
(statearr_74985_75075[(2)] = inst_74816);

(statearr_74985_75075[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (22))){
var inst_74846 = (state_74954[(33)]);
var inst_74870 = (state_74954[(34)]);
var inst_74868 = (state_74954[(2)]);
var inst_74869 = cljs.core.volatile_BANG_.call(null,(0));
var inst_74870__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_74846);
var state_74954__$1 = (function (){var statearr_74986 = state_74954;
(statearr_74986[(23)] = inst_74869);

(statearr_74986[(31)] = inst_74868);

(statearr_74986[(34)] = inst_74870__$1);

return statearr_74986;
})();
if(cljs.core.truth_(inst_74870__$1)){
var statearr_74987_75076 = state_74954__$1;
(statearr_74987_75076[(1)] = (23));

} else {
var statearr_74988_75077 = state_74954__$1;
(statearr_74988_75077[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (36))){
var inst_74838 = (state_74954[(27)]);
var state_74954__$1 = state_74954;
var statearr_74989_75078 = state_74954__$1;
(statearr_74989_75078[(2)] = inst_74838);

(statearr_74989_75078[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (41))){
var inst_74845 = (state_74954[(24)]);
var state_74954__$1 = state_74954;
var statearr_74990_75079 = state_74954__$1;
(statearr_74990_75079[(2)] = inst_74845);

(statearr_74990_75079[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (43))){
var inst_74898 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_74991_75080 = state_74954__$1;
(statearr_74991_75080[(2)] = inst_74898);

(statearr_74991_75080[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (29))){
var inst_74844 = (state_74954[(10)]);
var state_74954__$1 = state_74954;
var statearr_74992_75081 = state_74954__$1;
(statearr_74992_75081[(2)] = inst_74844);

(statearr_74992_75081[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (44))){
var inst_74904 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_74905 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_74906 = cljs.core.PersistentHashMap.fromArrays(inst_74904,inst_74905);
var state_74954__$1 = state_74954;
var statearr_74993_75082 = state_74954__$1;
(statearr_74993_75082[(2)] = inst_74906);

(statearr_74993_75082[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (6))){
var inst_74816 = (state_74954[(32)]);
var inst_74821 = inst_74816.cljs$lang$protocol_mask$partition0$;
var inst_74822 = (inst_74821 & (64));
var inst_74823 = inst_74816.cljs$core$ISeq$;
var inst_74824 = (cljs.core.PROTOCOL_SENTINEL === inst_74823);
var inst_74825 = ((inst_74822) || (inst_74824));
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74825)){
var statearr_74994_75083 = state_74954__$1;
(statearr_74994_75083[(1)] = (9));

} else {
var statearr_74995_75084 = state_74954__$1;
(statearr_74995_75084[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (28))){
var inst_74893 = (state_74954[(12)]);
var inst_74893__$1 = (state_74954[(2)]);
var state_74954__$1 = (function (){var statearr_74996 = state_74954;
(statearr_74996[(12)] = inst_74893__$1);

return statearr_74996;
})();
if(cljs.core.truth_(inst_74893__$1)){
var statearr_74997_75085 = state_74954__$1;
(statearr_74997_75085[(1)] = (38));

} else {
var statearr_74998_75086 = state_74954__$1;
(statearr_74998_75086[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (51))){
var inst_74912 = (state_74954[(11)]);
var inst_74923 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_74924 = cljs.core.sequential_QMARK_.call(null,inst_74912);
var state_74954__$1 = (function (){var statearr_74999 = state_74954;
(statearr_74999[(25)] = inst_74923);

return statearr_74999;
})();
if(inst_74924){
var statearr_75000_75087 = state_74954__$1;
(statearr_75000_75087[(1)] = (54));

} else {
var statearr_75001_75088 = state_74954__$1;
(statearr_75001_75088[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (25))){
var inst_74874 = (state_74954[(21)]);
var inst_74846 = (state_74954[(33)]);
var inst_74869 = (state_74954[(23)]);
var inst_74839 = (state_74954[(28)]);
var inst_74868 = (state_74954[(31)]);
var inst_74874__$1 = (state_74954[(2)]);
var inst_74875 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_74846);
var inst_74876 = fluree.db.util.core.current_time_millis.call(null);
var inst_74877 = cljs.core.assoc.call(null,inst_74846,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_74868,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_74874__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_74869);
var state_74954__$1 = (function (){var statearr_75002 = state_74954;
(statearr_75002[(19)] = inst_74875);

(statearr_75002[(21)] = inst_74874__$1);

(statearr_75002[(26)] = inst_74876);

(statearr_75002[(30)] = inst_74877);

return statearr_75002;
})();
if(cljs.core.truth_(inst_74839)){
var statearr_75003_75089 = state_74954__$1;
(statearr_75003_75089[(1)] = (26));

} else {
var statearr_75004_75090 = state_74954__$1;
(statearr_75004_75090[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (34))){
var inst_74889 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_75005_75091 = state_74954__$1;
(statearr_75005_75091[(2)] = inst_74889);

(statearr_75005_75091[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (17))){
var inst_74850 = (state_74954[(15)]);
var state_74954__$1 = state_74954;
var statearr_75006_75092 = state_74954__$1;
(statearr_75006_75092[(2)] = inst_74850);

(statearr_75006_75092[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (3))){
var inst_74952 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74954__$1,inst_74952);
} else {
if((state_val_74955 === (12))){
var inst_74816 = (state_74954[(32)]);
var inst_74834 = cljs.core.apply.call(null,cljs.core.hash_map,inst_74816);
var state_74954__$1 = state_74954;
var statearr_75007_75093 = state_74954__$1;
(statearr_75007_75093[(2)] = inst_74834);

(statearr_75007_75093[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (2))){
var inst_74816 = (state_74954[(32)]);
var _ = (function (){var statearr_75008 = state_74954;
(statearr_75008[(4)] = cljs.core.cons.call(null,(5),(state_74954[(4)])));

return statearr_75008;
})();
var inst_74816__$1 = query_map;
var inst_74818 = (inst_74816__$1 == null);
var inst_74819 = cljs.core.not.call(null,inst_74818);
var state_74954__$1 = (function (){var statearr_75009 = state_74954;
(statearr_75009[(32)] = inst_74816__$1);

return statearr_75009;
})();
if(inst_74819){
var statearr_75010_75094 = state_74954__$1;
(statearr_75010_75094[(1)] = (6));

} else {
var statearr_75011_75095 = state_74954__$1;
(statearr_75011_75095[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (23))){
var inst_74870 = (state_74954[(34)]);
var state_74954__$1 = state_74954;
var statearr_75012_75096 = state_74954__$1;
(statearr_75012_75096[(2)] = inst_74870);

(statearr_75012_75096[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (47))){
var inst_74913 = (state_74954[(20)]);
var inst_74912 = (state_74954[(11)]);
var inst_74911 = (state_74954[(2)]);
var inst_74912__$1 = fluree.db.util.async.throw_err.call(null,inst_74911);
var inst_74913__$1 = (inst_74912__$1 instanceof cljs.core.ExceptionInfo);
var state_74954__$1 = (function (){var statearr_75013 = state_74954;
(statearr_75013[(20)] = inst_74913__$1);

(statearr_75013[(11)] = inst_74912__$1);

return statearr_75013;
})();
if(cljs.core.truth_(inst_74913__$1)){
var statearr_75014_75097 = state_74954__$1;
(statearr_75014_75097[(1)] = (48));

} else {
var statearr_75015_75098 = state_74954__$1;
(statearr_75015_75098[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (35))){
var inst_74847 = (state_74954[(18)]);
var state_74954__$1 = state_74954;
var statearr_75016_75099 = state_74954__$1;
(statearr_75016_75099[(2)] = inst_74847);

(statearr_75016_75099[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (19))){
var inst_74854 = (state_74954[(2)]);
var inst_74855 = fluree.db.util.async.throw_err.call(null,inst_74854);
var state_74954__$1 = state_74954;
var statearr_75017_75100 = state_74954__$1;
(statearr_75017_75100[(2)] = inst_74855);

(statearr_75017_75100[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (57))){
var inst_74912 = (state_74954[(11)]);
var state_74954__$1 = state_74954;
var statearr_75018_75101 = state_74954__$1;
(statearr_75018_75101[(2)] = inst_74912);

(statearr_75018_75101[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (11))){
var inst_74829 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_75020_75102 = state_74954__$1;
(statearr_75020_75102[(2)] = inst_74829);

(statearr_75020_75102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (9))){
var state_74954__$1 = state_74954;
var statearr_75021_75103 = state_74954__$1;
(statearr_75021_75103[(2)] = true);

(statearr_75021_75103[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (5))){
var _ = (function (){var statearr_75022 = state_74954;
(statearr_75022[(4)] = cljs.core.rest.call(null,(state_74954[(4)])));

return statearr_75022;
})();
var state_74954__$1 = state_74954;
var ex75019 = (state_74954__$1[(2)]);
var statearr_75023_75104 = state_74954__$1;
(statearr_75023_75104[(5)] = ex75019);


var statearr_75024_75105 = state_74954__$1;
(statearr_75024_75105[(1)] = (4));

(statearr_75024_75105[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (14))){
var inst_74837 = (state_74954[(29)]);
var inst_74837__$1 = (state_74954[(2)]);
var inst_74838 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_74839 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_74840 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_74841 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_74842 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_74843 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_74844 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_74845 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_74846 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_74847 = cljs.core.get.call(null,inst_74837__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_74954__$1 = (function (){var statearr_75025 = state_74954;
(statearr_75025[(7)] = inst_74842);

(statearr_75025[(18)] = inst_74847);

(statearr_75025[(10)] = inst_74844);

(statearr_75025[(33)] = inst_74846);

(statearr_75025[(22)] = inst_74841);

(statearr_75025[(24)] = inst_74845);

(statearr_75025[(27)] = inst_74838);

(statearr_75025[(14)] = inst_74840);

(statearr_75025[(28)] = inst_74839);

(statearr_75025[(29)] = inst_74837__$1);

(statearr_75025[(16)] = inst_74843);

return statearr_75025;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74954__$1,(15),sources);
} else {
if((state_val_74955 === (45))){
var inst_74858 = (state_74954[(8)]);
var inst_74877 = (state_74954[(30)]);
var inst_74908 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_74877);
var inst_74909 = fluree.db.query.fql.query.call(null,inst_74858,inst_74908);
var state_74954__$1 = state_74954;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74954__$1,(47),inst_74909);
} else {
if((state_val_74955 === (53))){
var inst_74945 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_75026_75106 = state_74954__$1;
(statearr_75026_75106[(2)] = inst_74945);

(statearr_75026_75106[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (26))){
var inst_74839 = (state_74954[(28)]);
var state_74954__$1 = state_74954;
var statearr_75027_75107 = state_74954__$1;
(statearr_75027_75107[(2)] = inst_74839);

(statearr_75027_75107[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (16))){
var inst_74850 = (state_74954[(15)]);
var inst_74840 = (state_74954[(14)]);
var inst_74852 = fluree.db.time_travel.as_of_block.call(null,inst_74850,inst_74840);
var state_74954__$1 = state_74954;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74954__$1,(19),inst_74852);
} else {
if((state_val_74955 === (38))){
var inst_74845 = (state_74954[(24)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74845)){
var statearr_75028_75108 = state_74954__$1;
(statearr_75028_75108[(1)] = (41));

} else {
var statearr_75029_75109 = state_74954__$1;
(statearr_75029_75109[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (30))){
var inst_74843 = (state_74954[(16)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74843)){
var statearr_75030_75110 = state_74954__$1;
(statearr_75030_75110[(1)] = (32));

} else {
var statearr_75031_75111 = state_74954__$1;
(statearr_75031_75111[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (10))){
var state_74954__$1 = state_74954;
var statearr_75032_75112 = state_74954__$1;
(statearr_75032_75112[(2)] = false);

(statearr_75032_75112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (18))){
var inst_74842 = (state_74954[(7)]);
var inst_74858 = (state_74954[(8)]);
var inst_74858__$1 = (state_74954[(2)]);
var inst_74859 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_74858__$1);
var state_74954__$1 = (function (){var statearr_75033 = state_74954;
(statearr_75033[(8)] = inst_74858__$1);

(statearr_75033[(9)] = inst_74859);

return statearr_75033;
})();
if(cljs.core.truth_(inst_74842)){
var statearr_75034_75113 = state_74954__$1;
(statearr_75034_75113[(1)] = (20));

} else {
var statearr_75035_75114 = state_74954__$1;
(statearr_75035_75114[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (52))){
var state_74954__$1 = state_74954;
var statearr_75036_75115 = state_74954__$1;
(statearr_75036_75115[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (42))){
var inst_74841 = (state_74954[(22)]);
var state_74954__$1 = state_74954;
var statearr_75038_75116 = state_74954__$1;
(statearr_75038_75116[(2)] = inst_74841);

(statearr_75038_75116[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (37))){
var inst_74887 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
var statearr_75039_75117 = state_74954__$1;
(statearr_75039_75117[(2)] = inst_74887);

(statearr_75039_75117[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (8))){
var inst_74832 = (state_74954[(2)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74832)){
var statearr_75040_75118 = state_74954__$1;
(statearr_75040_75118[(1)] = (12));

} else {
var statearr_75041_75119 = state_74954__$1;
(statearr_75041_75119[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74955 === (49))){
var inst_74875 = (state_74954[(19)]);
var state_74954__$1 = state_74954;
if(cljs.core.truth_(inst_74875)){
var statearr_75042_75120 = state_74954__$1;
(statearr_75042_75120[(1)] = (51));

} else {
var statearr_75043_75121 = state_74954__$1;
(statearr_75043_75121[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_75044 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75044[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_75044[(1)] = (1));

return statearr_75044;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_74954){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74954);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75045){var ex__11472__auto__ = e75045;
var statearr_75046_75122 = state_74954;
(statearr_75046_75122[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74954[(4)]))){
var statearr_75047_75123 = state_74954;
(statearr_75047_75123[(1)] = cljs.core.first.call(null,(state_74954[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75124 = state_74954;
state_74954 = G__75124;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_74954){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_74954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75048 = f__11543__auto__.call(null);
(statearr_75048[(6)] = c__11542__auto__);

return statearr_75048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__75125_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__75125_SHARP_);
}));

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75147){
var state_val_75148 = (state_75147[(1)]);
if((state_val_75148 === (1))){
var inst_75129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75130 = [resp_chan,timeout_chan];
var inst_75131 = (new cljs.core.PersistentVector(null,2,(5),inst_75129,inst_75130,null));
var state_75147__$1 = state_75147;
return cljs.core.async.ioc_alts_BANG_.call(null,state_75147__$1,(2),inst_75131);
} else {
if((state_val_75148 === (2))){
var inst_75133 = (state_75147[(2)]);
var inst_75134 = cljs.core.nth.call(null,inst_75133,(0),null);
var inst_75135 = cljs.core.nth.call(null,inst_75133,(1),null);
var inst_75136 = cljs.core._EQ_.call(null,timeout_chan,inst_75135);
var state_75147__$1 = (function (){var statearr_75149 = state_75147;
(statearr_75149[(7)] = inst_75134);

return statearr_75149;
})();
if(inst_75136){
var statearr_75150_75160 = state_75147__$1;
(statearr_75150_75160[(1)] = (3));

} else {
var statearr_75151_75161 = state_75147__$1;
(statearr_75151_75161[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75148 === (3))){
var inst_75138 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_75139 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_75140 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_75141 = [tid,(408),inst_75140];
var inst_75142 = cljs.core.PersistentHashMap.fromArrays(inst_75139,inst_75141);
var state_75147__$1 = (function (){var statearr_75152 = state_75147;
(statearr_75152[(8)] = inst_75138);

return statearr_75152;
})();
var statearr_75153_75162 = state_75147__$1;
(statearr_75153_75162[(2)] = inst_75142);

(statearr_75153_75162[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75148 === (4))){
var inst_75134 = (state_75147[(7)]);
var state_75147__$1 = state_75147;
var statearr_75154_75163 = state_75147__$1;
(statearr_75154_75163[(2)] = inst_75134);

(statearr_75154_75163[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75148 === (5))){
var inst_75145 = (state_75147[(2)]);
var state_75147__$1 = state_75147;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75147__$1,inst_75145);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____0 = (function (){
var statearr_75155 = [null,null,null,null,null,null,null,null,null];
(statearr_75155[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__);

(statearr_75155[(1)] = (1));

return statearr_75155;
});
var fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____1 = (function (state_75147){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75147);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75156){var ex__11472__auto__ = e75156;
var statearr_75157_75164 = state_75147;
(statearr_75157_75164[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75147[(4)]))){
var statearr_75158_75165 = state_75147;
(statearr_75158_75165[(1)] = cljs.core.first.call(null,(state_75147[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75166 = state_75147;
state_75147 = G__75166;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__ = function(state_75147){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____1.call(this,state_75147);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__11469__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75159 = f__11543__auto__.call(null);
(statearr_75159[(6)] = c__11542__auto__);

return statearr_75159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__75168 = arguments.length;
switch (G__75168) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__75169 = opts;
var map__75169__$1 = (((((!((map__75169 == null))))?(((((map__75169.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__75169.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__75169):map__75169);
var auth = cljs.core.get.call(null,map__75169__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__75169__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__75169__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__75169__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__75170 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__75170,(0),null);
var authority = cljs.core.nth.call(null,vec__75170,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e75174){var e = e75174;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__75177 = arguments.length;
switch (G__75177) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75263){
var state_val_75264 = (state_75263[(1)]);
if((state_val_75264 === (7))){
var state_75263__$1 = state_75263;
var statearr_75265_75314 = state_75263__$1;
(statearr_75265_75314[(2)] = false);

(statearr_75265_75314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (20))){
var inst_75230 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
var statearr_75266_75315 = state_75263__$1;
(statearr_75266_75315[(2)] = inst_75230);

(statearr_75266_75315[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (27))){
var inst_75243 = (state_75263[(7)]);
var inst_75246 = cljs.core.ex_data.call(null,inst_75243);
var inst_75247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75248 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_75246);
var inst_75249 = cljs.core.ex_message.call(null,inst_75243);
var inst_75250 = [inst_75248,inst_75249,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_75251 = cljs.core.PersistentHashMap.fromArrays(inst_75247,inst_75250);
var state_75263__$1 = state_75263;
var statearr_75267_75316 = state_75263__$1;
(statearr_75267_75316[(2)] = inst_75251);

(statearr_75267_75316[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (1))){
var state_75263__$1 = state_75263;
var statearr_75268_75317 = state_75263__$1;
(statearr_75268_75317[(2)] = null);

(statearr_75268_75317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (24))){
var inst_75213 = (state_75263[(8)]);
var inst_75238 = (state_75263[(9)]);
var inst_75241 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_75238,inst_75213);
var state_75263__$1 = state_75263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75263__$1,(26),inst_75241);
} else {
if((state_val_75264 === (4))){
var inst_75178 = (state_75263[(2)]);
var inst_75179 = fluree.db.util.log.error.call(null,inst_75178);
var inst_75180 = cljs.core.ex_data.call(null,inst_75178);
var inst_75181 = cljs.core.ex_message.call(null,inst_75178);
var inst_75182 = cljs.core.assoc.call(null,inst_75180,new cljs.core.Keyword(null,"message","message",-406056002),inst_75181);
var state_75263__$1 = (function (){var statearr_75269 = state_75263;
(statearr_75269[(10)] = inst_75179);

return statearr_75269;
})();
var statearr_75270_75318 = state_75263__$1;
(statearr_75270_75318[(2)] = inst_75182);

(statearr_75270_75318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (15))){
var inst_75211 = (state_75263[(11)]);
var inst_75212 = (state_75263[(12)]);
var inst_75221 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_75211,opts);
var inst_75222 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_75221);
var inst_75223 = fluree.db.operations.command_async.call(null,conn,inst_75221);
var state_75263__$1 = (function (){var statearr_75271 = state_75263;
(statearr_75271[(13)] = inst_75222);

(statearr_75271[(14)] = inst_75223);

return statearr_75271;
})();
if(cljs.core.truth_(inst_75212)){
var statearr_75272_75319 = state_75263__$1;
(statearr_75272_75319[(1)] = (18));

} else {
var statearr_75273_75320 = state_75263__$1;
(statearr_75273_75320[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (21))){
var inst_75228 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
var statearr_75274_75321 = state_75263__$1;
(statearr_75274_75321[(2)] = inst_75228);

(statearr_75274_75321[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (13))){
var inst_75189 = (state_75263[(15)]);
var state_75263__$1 = state_75263;
var statearr_75275_75322 = state_75263__$1;
(statearr_75275_75322[(2)] = inst_75189);

(statearr_75275_75322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (22))){
var inst_75212 = (state_75263[(12)]);
var inst_75238 = (state_75263[(2)]);
var state_75263__$1 = (function (){var statearr_75276 = state_75263;
(statearr_75276[(9)] = inst_75238);

return statearr_75276;
})();
if(cljs.core.truth_(inst_75212)){
var statearr_75277_75323 = state_75263__$1;
(statearr_75277_75323[(1)] = (23));

} else {
var statearr_75278_75324 = state_75263__$1;
(statearr_75278_75324[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (29))){
var inst_75254 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
var statearr_75279_75325 = state_75263__$1;
(statearr_75279_75325[(2)] = inst_75254);

(statearr_75279_75325[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (6))){
var inst_75189 = (state_75263[(15)]);
var inst_75194 = inst_75189.cljs$lang$protocol_mask$partition0$;
var inst_75195 = (inst_75194 & (64));
var inst_75196 = inst_75189.cljs$core$ISeq$;
var inst_75197 = (cljs.core.PROTOCOL_SENTINEL === inst_75196);
var inst_75198 = ((inst_75195) || (inst_75197));
var state_75263__$1 = state_75263;
if(cljs.core.truth_(inst_75198)){
var statearr_75280_75326 = state_75263__$1;
(statearr_75280_75326[(1)] = (9));

} else {
var statearr_75281_75327 = state_75263__$1;
(statearr_75281_75327[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (28))){
var inst_75243 = (state_75263[(7)]);
var state_75263__$1 = state_75263;
var statearr_75282_75328 = state_75263__$1;
(statearr_75282_75328[(2)] = inst_75243);

(statearr_75282_75328[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (25))){
var inst_75256 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
var statearr_75283_75329 = state_75263__$1;
(statearr_75283_75329[(2)] = inst_75256);

(statearr_75283_75329[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (17))){
var inst_75258 = (state_75263[(2)]);
var _ = (function (){var statearr_75284 = state_75263;
(statearr_75284[(4)] = cljs.core.rest.call(null,(state_75263[(4)])));

return statearr_75284;
})();
var state_75263__$1 = state_75263;
var statearr_75285_75330 = state_75263__$1;
(statearr_75285_75330[(2)] = inst_75258);

(statearr_75285_75330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (3))){
var inst_75261 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75263__$1,inst_75261);
} else {
if((state_val_75264 === (12))){
var inst_75189 = (state_75263[(15)]);
var inst_75207 = cljs.core.apply.call(null,cljs.core.hash_map,inst_75189);
var state_75263__$1 = state_75263;
var statearr_75286_75331 = state_75263__$1;
(statearr_75286_75331[(2)] = inst_75207);

(statearr_75286_75331[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (2))){
var inst_75189 = (state_75263[(15)]);
var _ = (function (){var statearr_75287 = state_75263;
(statearr_75287[(4)] = cljs.core.cons.call(null,(5),(state_75263[(4)])));

return statearr_75287;
})();
var inst_75189__$1 = opts;
var inst_75191 = (inst_75189__$1 == null);
var inst_75192 = cljs.core.not.call(null,inst_75191);
var state_75263__$1 = (function (){var statearr_75288 = state_75263;
(statearr_75288[(15)] = inst_75189__$1);

return statearr_75288;
})();
if(inst_75192){
var statearr_75289_75332 = state_75263__$1;
(statearr_75289_75332[(1)] = (6));

} else {
var statearr_75290_75333 = state_75263__$1;
(statearr_75290_75333[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (23))){
var inst_75238 = (state_75263[(9)]);
var state_75263__$1 = state_75263;
var statearr_75291_75334 = state_75263__$1;
(statearr_75291_75334[(2)] = inst_75238);

(statearr_75291_75334[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (19))){
var inst_75222 = (state_75263[(13)]);
var inst_75213 = (state_75263[(8)]);
var inst_75226 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_75222,inst_75213);
var state_75263__$1 = state_75263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75263__$1,(21),inst_75226);
} else {
if((state_val_75264 === (11))){
var inst_75202 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
var statearr_75293_75335 = state_75263__$1;
(statearr_75293_75335[(2)] = inst_75202);

(statearr_75293_75335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (9))){
var state_75263__$1 = state_75263;
var statearr_75294_75336 = state_75263__$1;
(statearr_75294_75336[(2)] = true);

(statearr_75294_75336[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (5))){
var _ = (function (){var statearr_75295 = state_75263;
(statearr_75295[(4)] = cljs.core.rest.call(null,(state_75263[(4)])));

return statearr_75295;
})();
var state_75263__$1 = state_75263;
var ex75292 = (state_75263__$1[(2)]);
var statearr_75296_75337 = state_75263__$1;
(statearr_75296_75337[(5)] = ex75292);


var statearr_75297_75338 = state_75263__$1;
(statearr_75297_75338[(1)] = (4));

(statearr_75297_75338[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (14))){
var inst_75211 = (state_75263[(11)]);
var inst_75210 = (state_75263[(2)]);
var inst_75211__$1 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_75212 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_75213 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_75214 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_75215 = fluree.db.util.core.current_time_millis.call(null);
var inst_75216 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_75215);
var inst_75217 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_75218 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_75219 = cljs.core.get.call(null,inst_75210,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_75263__$1 = (function (){var statearr_75298 = state_75263;
(statearr_75298[(16)] = inst_75214);

(statearr_75298[(17)] = inst_75219);

(statearr_75298[(18)] = inst_75216);

(statearr_75298[(8)] = inst_75213);

(statearr_75298[(11)] = inst_75211__$1);

(statearr_75298[(19)] = inst_75217);

(statearr_75298[(12)] = inst_75212);

(statearr_75298[(20)] = inst_75218);

return statearr_75298;
})();
if(cljs.core.truth_(inst_75211__$1)){
var statearr_75299_75339 = state_75263__$1;
(statearr_75299_75339[(1)] = (15));

} else {
var statearr_75300_75340 = state_75263__$1;
(statearr_75300_75340[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (26))){
var inst_75243 = (state_75263[(7)]);
var inst_75243__$1 = (state_75263[(2)]);
var inst_75244 = (inst_75243__$1 instanceof cljs.core.ExceptionInfo);
var state_75263__$1 = (function (){var statearr_75301 = state_75263;
(statearr_75301[(7)] = inst_75243__$1);

return statearr_75301;
})();
if(cljs.core.truth_(inst_75244)){
var statearr_75302_75341 = state_75263__$1;
(statearr_75302_75341[(1)] = (27));

} else {
var statearr_75303_75342 = state_75263__$1;
(statearr_75303_75342[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (16))){
var inst_75214 = (state_75263[(16)]);
var inst_75219 = (state_75263[(17)]);
var inst_75216 = (state_75263[(18)]);
var inst_75217 = (state_75263[(19)]);
var inst_75218 = (state_75263[(20)]);
var inst_75232 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_75233 = [ledger,txn,inst_75214,inst_75216,inst_75217,inst_75218,inst_75219];
var inst_75234 = cljs.core.PersistentHashMap.fromArrays(inst_75232,inst_75233);
var inst_75235 = fluree.db.util.core.without_nils.call(null,inst_75234);
var inst_75236 = fluree.db.operations.transact_async.call(null,conn,inst_75235);
var state_75263__$1 = state_75263;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75263__$1,(22),inst_75236);
} else {
if((state_val_75264 === (10))){
var state_75263__$1 = state_75263;
var statearr_75304_75343 = state_75263__$1;
(statearr_75304_75343[(2)] = false);

(statearr_75304_75343[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (18))){
var inst_75223 = (state_75263[(14)]);
var state_75263__$1 = state_75263;
var statearr_75305_75344 = state_75263__$1;
(statearr_75305_75344[(2)] = inst_75223);

(statearr_75305_75344[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75264 === (8))){
var inst_75205 = (state_75263[(2)]);
var state_75263__$1 = state_75263;
if(cljs.core.truth_(inst_75205)){
var statearr_75306_75345 = state_75263__$1;
(statearr_75306_75345[(1)] = (12));

} else {
var statearr_75307_75346 = state_75263__$1;
(statearr_75307_75346[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_75308 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75308[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_75308[(1)] = (1));

return statearr_75308;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_75263){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75309){var ex__11472__auto__ = e75309;
var statearr_75310_75347 = state_75263;
(statearr_75310_75347[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75263[(4)]))){
var statearr_75311_75348 = state_75263;
(statearr_75311_75348[(1)] = cljs.core.first.call(null,(state_75263[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75349 = state_75263;
state_75263 = G__75349;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_75263){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_75263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75312 = f__11543__auto__.call(null);
(statearr_75312[(6)] = c__11542__auto__);

return statearr_75312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___75351 = arguments.length;
var i__4737__auto___75352 = (0);
while(true){
if((i__4737__auto___75352 < len__4736__auto___75351)){
args__4742__auto__.push((arguments[i__4737__auto___75352]));

var G__75353 = (i__4737__auto___75352 + (1));
i__4737__auto___75352 = G__75353;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq75350){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq75350));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75384){
var state_val_75385 = (state_75384[(1)]);
if((state_val_75385 === (1))){
var inst_75354 = cljs.core.first.call(null,flakes);
var inst_75355 = cljs.core.rest.call(null,flakes);
var inst_75356 = cljs.core.PersistentVector.EMPTY;
var inst_75357 = inst_75354;
var inst_75358 = inst_75355;
var inst_75359 = inst_75356;
var state_75384__$1 = (function (){var statearr_75386 = state_75384;
(statearr_75386[(7)] = inst_75357);

(statearr_75386[(8)] = inst_75358);

(statearr_75386[(9)] = inst_75359);

return statearr_75386;
})();
var statearr_75387_75400 = state_75384__$1;
(statearr_75387_75400[(2)] = null);

(statearr_75387_75400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75385 === (2))){
var inst_75357 = (state_75384[(7)]);
var inst_75361 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_75362 = cljs.core.PersistentHashMap.EMPTY;
var inst_75363 = [true,inst_75362];
var inst_75364 = cljs.core.PersistentHashMap.fromArrays(inst_75361,inst_75363);
var inst_75365 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_75364,inst_75357);
var state_75384__$1 = state_75384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75384__$1,(4),inst_75365);
} else {
if((state_val_75385 === (3))){
var inst_75382 = (state_75384[(2)]);
var state_75384__$1 = state_75384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75384__$1,inst_75382);
} else {
if((state_val_75385 === (4))){
var inst_75358 = (state_75384[(8)]);
var inst_75359 = (state_75384[(9)]);
var inst_75367 = (state_75384[(2)]);
var inst_75368 = fluree.db.util.async.throw_err.call(null,inst_75367);
var inst_75369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75370 = [inst_75368];
var inst_75371 = (new cljs.core.PersistentVector(null,1,(5),inst_75369,inst_75370,null));
var inst_75372 = cljs.core.concat.call(null,inst_75359,inst_75371);
var inst_75373 = cljs.core.first.call(null,inst_75358);
var state_75384__$1 = (function (){var statearr_75388 = state_75384;
(statearr_75388[(10)] = inst_75372);

return statearr_75388;
})();
if(cljs.core.truth_(inst_75373)){
var statearr_75389_75401 = state_75384__$1;
(statearr_75389_75401[(1)] = (5));

} else {
var statearr_75390_75402 = state_75384__$1;
(statearr_75390_75402[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75385 === (5))){
var inst_75372 = (state_75384[(10)]);
var inst_75358 = (state_75384[(8)]);
var inst_75375 = cljs.core.first.call(null,inst_75358);
var inst_75376 = cljs.core.rest.call(null,inst_75358);
var inst_75357 = inst_75375;
var inst_75358__$1 = inst_75376;
var inst_75359 = inst_75372;
var state_75384__$1 = (function (){var statearr_75391 = state_75384;
(statearr_75391[(7)] = inst_75357);

(statearr_75391[(8)] = inst_75358__$1);

(statearr_75391[(9)] = inst_75359);

return statearr_75391;
})();
var statearr_75392_75403 = state_75384__$1;
(statearr_75392_75403[(2)] = null);

(statearr_75392_75403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75385 === (6))){
var inst_75372 = (state_75384[(10)]);
var state_75384__$1 = state_75384;
var statearr_75393_75404 = state_75384__$1;
(statearr_75393_75404[(2)] = inst_75372);

(statearr_75393_75404[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75385 === (7))){
var inst_75380 = (state_75384[(2)]);
var state_75384__$1 = state_75384;
var statearr_75394_75405 = state_75384__$1;
(statearr_75394_75405[(2)] = inst_75380);

(statearr_75394_75405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____0 = (function (){
var statearr_75395 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_75395[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__);

(statearr_75395[(1)] = (1));

return statearr_75395;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____1 = (function (state_75384){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75396){var ex__11472__auto__ = e75396;
var statearr_75397_75406 = state_75384;
(statearr_75397_75406[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75384[(4)]))){
var statearr_75398_75407 = state_75384;
(statearr_75398_75407[(1)] = cljs.core.first.call(null,(state_75384[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75408 = state_75384;
state_75384 = G__75408;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__ = function(state_75384){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____1.call(this,state_75384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75399 = f__11543__auto__.call(null);
(statearr_75399[(6)] = c__11542__auto__);

return statearr_75399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75476){
var state_val_75477 = (state_75476[(1)]);
if((state_val_75477 === (7))){
var inst_75436 = (state_75476[(2)]);
var inst_75437 = fluree.db.util.async.throw_err.call(null,inst_75436);
var state_75476__$1 = state_75476;
var statearr_75478_75504 = state_75476__$1;
(statearr_75478_75504[(2)] = inst_75437);

(statearr_75478_75504[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (1))){
var inst_75413 = cljs.core.volatile_BANG_.call(null,(0));
var inst_75414 = cljs.core.PersistentHashMap.EMPTY;
var inst_75415 = cljs.core.volatile_BANG_.call(null,inst_75414);
var inst_75416 = cljs.core.first.call(null,resp);
var inst_75417 = cljs.core.rest.call(null,resp);
var inst_75418 = cljs.core.PersistentVector.EMPTY;
var inst_75419 = inst_75413;
var inst_75420 = inst_75415;
var inst_75421 = inst_75416;
var inst_75422 = inst_75417;
var inst_75423 = inst_75418;
var state_75476__$1 = (function (){var statearr_75479 = state_75476;
(statearr_75479[(7)] = inst_75423);

(statearr_75479[(8)] = inst_75420);

(statearr_75479[(9)] = inst_75419);

(statearr_75479[(10)] = inst_75421);

(statearr_75479[(11)] = inst_75422);

return statearr_75479;
})();
var statearr_75480_75505 = state_75476__$1;
(statearr_75480_75505[(2)] = null);

(statearr_75480_75505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (4))){
var inst_75423 = (state_75476[(7)]);
var inst_75420 = (state_75476[(8)]);
var inst_75419 = (state_75476[(9)]);
var inst_75421 = (state_75476[(10)]);
var inst_75422 = (state_75476[(11)]);
var inst_75427 = (state_75476[(12)]);
var inst_75425 = (state_75476[(13)]);
var inst_75431 = (function (){var fuel = inst_75419;
var cache = inst_75420;
var curr_block = inst_75421;
var rest_blocks = inst_75422;
var acc = inst_75423;
var flakes = inst_75425;
var asserted = inst_75427;
return (function (p1__75410_SHARP_){
return p1__75410_SHARP_.s;
});
})();
var inst_75432 = cljs.core.group_by.call(null,inst_75431,inst_75427);
var inst_75433 = cljs.core.vals.call(null,inst_75432);
var inst_75434 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_75420,inst_75419,inst_75433);
var state_75476__$1 = state_75476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75476__$1,(7),inst_75434);
} else {
if((state_val_75477 === (13))){
var inst_75464 = (state_75476[(14)]);
var state_75476__$1 = state_75476;
var statearr_75481_75506 = state_75476__$1;
(statearr_75481_75506[(2)] = inst_75464);

(statearr_75481_75506[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (6))){
var inst_75442 = (state_75476[(15)]);
var inst_75423 = (state_75476[(7)]);
var inst_75420 = (state_75476[(8)]);
var inst_75419 = (state_75476[(9)]);
var inst_75421 = (state_75476[(10)]);
var inst_75422 = (state_75476[(11)]);
var inst_75440 = (state_75476[(16)]);
var inst_75427 = (state_75476[(12)]);
var inst_75425 = (state_75476[(13)]);
var inst_75440__$1 = (state_75476[(2)]);
var inst_75441 = (function (){var fuel = inst_75419;
var cache = inst_75420;
var curr_block = inst_75421;
var rest_blocks = inst_75422;
var acc = inst_75423;
var flakes = inst_75425;
var asserted = inst_75427;
var asserted_SINGLEQUOTE_ = inst_75440__$1;
return (function (p1__75411_SHARP_){
return p1__75411_SHARP_.op === false;
});
})();
var inst_75442__$1 = cljs.core.filter.call(null,inst_75441,inst_75425);
var inst_75443 = cljs.core.empty_QMARK_.call(null,inst_75442__$1);
var inst_75444 = (!(inst_75443));
var state_75476__$1 = (function (){var statearr_75484 = state_75476;
(statearr_75484[(15)] = inst_75442__$1);

(statearr_75484[(16)] = inst_75440__$1);

return statearr_75484;
})();
if(inst_75444){
var statearr_75485_75507 = state_75476__$1;
(statearr_75485_75507[(1)] = (8));

} else {
var statearr_75486_75508 = state_75476__$1;
(statearr_75486_75508[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (3))){
var inst_75474 = (state_75476[(2)]);
var state_75476__$1 = state_75476;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75476__$1,inst_75474);
} else {
if((state_val_75477 === (12))){
var inst_75420 = (state_75476[(8)]);
var inst_75419 = (state_75476[(9)]);
var inst_75464 = (state_75476[(14)]);
var inst_75422 = (state_75476[(11)]);
var inst_75467 = cljs.core.first.call(null,inst_75422);
var inst_75468 = cljs.core.rest.call(null,inst_75422);
var tmp75482 = inst_75420;
var tmp75483 = inst_75419;
var inst_75419__$1 = tmp75483;
var inst_75420__$1 = tmp75482;
var inst_75421 = inst_75467;
var inst_75422__$1 = inst_75468;
var inst_75423 = inst_75464;
var state_75476__$1 = (function (){var statearr_75487 = state_75476;
(statearr_75487[(7)] = inst_75423);

(statearr_75487[(8)] = inst_75420__$1);

(statearr_75487[(9)] = inst_75419__$1);

(statearr_75487[(10)] = inst_75421);

(statearr_75487[(11)] = inst_75422__$1);

return statearr_75487;
})();
var statearr_75488_75509 = state_75476__$1;
(statearr_75488_75509[(2)] = null);

(statearr_75488_75509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (2))){
var inst_75423 = (state_75476[(7)]);
var inst_75420 = (state_75476[(8)]);
var inst_75419 = (state_75476[(9)]);
var inst_75421 = (state_75476[(10)]);
var inst_75422 = (state_75476[(11)]);
var inst_75427 = (state_75476[(12)]);
var inst_75425 = (state_75476[(13)]);
var inst_75425__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_75421);
var inst_75426 = (function (){var fuel = inst_75419;
var cache = inst_75420;
var curr_block = inst_75421;
var rest_blocks = inst_75422;
var acc = inst_75423;
var flakes = inst_75425__$1;
return (function (p1__75409_SHARP_){
return p1__75409_SHARP_.op;
});
})();
var inst_75427__$1 = cljs.core.filter.call(null,inst_75426,inst_75425__$1);
var inst_75428 = cljs.core.empty_QMARK_.call(null,inst_75427__$1);
var inst_75429 = (!(inst_75428));
var state_75476__$1 = (function (){var statearr_75489 = state_75476;
(statearr_75489[(12)] = inst_75427__$1);

(statearr_75489[(13)] = inst_75425__$1);

return statearr_75489;
})();
if(inst_75429){
var statearr_75490_75510 = state_75476__$1;
(statearr_75490_75510[(1)] = (4));

} else {
var statearr_75491_75511 = state_75476__$1;
(statearr_75491_75511[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (11))){
var inst_75452 = (state_75476[(2)]);
var inst_75453 = fluree.db.util.async.throw_err.call(null,inst_75452);
var state_75476__$1 = state_75476;
var statearr_75492_75512 = state_75476__$1;
(statearr_75492_75512[(2)] = inst_75453);

(statearr_75492_75512[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (9))){
var state_75476__$1 = state_75476;
var statearr_75493_75513 = state_75476__$1;
(statearr_75493_75513[(2)] = null);

(statearr_75493_75513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (5))){
var state_75476__$1 = state_75476;
var statearr_75494_75514 = state_75476__$1;
(statearr_75494_75514[(2)] = null);

(statearr_75494_75514[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (14))){
var inst_75472 = (state_75476[(2)]);
var state_75476__$1 = state_75476;
var statearr_75495_75515 = state_75476__$1;
(statearr_75495_75515[(2)] = inst_75472);

(statearr_75495_75515[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (10))){
var inst_75423 = (state_75476[(7)]);
var inst_75421 = (state_75476[(10)]);
var inst_75422 = (state_75476[(11)]);
var inst_75440 = (state_75476[(16)]);
var inst_75456 = (state_75476[(2)]);
var inst_75457 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_75458 = [inst_75440,inst_75456];
var inst_75459 = cljs.core.PersistentHashMap.fromArrays(inst_75457,inst_75458);
var inst_75460 = cljs.core.assoc.call(null,inst_75421,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_75459);
var inst_75461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75462 = [inst_75460];
var inst_75463 = (new cljs.core.PersistentVector(null,1,(5),inst_75461,inst_75462,null));
var inst_75464 = cljs.core.concat.call(null,inst_75423,inst_75463);
var inst_75465 = cljs.core.first.call(null,inst_75422);
var state_75476__$1 = (function (){var statearr_75496 = state_75476;
(statearr_75496[(14)] = inst_75464);

return statearr_75496;
})();
if(cljs.core.truth_(inst_75465)){
var statearr_75497_75516 = state_75476__$1;
(statearr_75497_75516[(1)] = (12));

} else {
var statearr_75498_75517 = state_75476__$1;
(statearr_75498_75517[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75477 === (8))){
var inst_75442 = (state_75476[(15)]);
var inst_75423 = (state_75476[(7)]);
var inst_75420 = (state_75476[(8)]);
var inst_75419 = (state_75476[(9)]);
var inst_75421 = (state_75476[(10)]);
var inst_75422 = (state_75476[(11)]);
var inst_75440 = (state_75476[(16)]);
var inst_75427 = (state_75476[(12)]);
var inst_75425 = (state_75476[(13)]);
var inst_75446 = (function (){var flakes = inst_75425;
var rest_blocks = inst_75422;
var curr_block = inst_75421;
var asserted_SINGLEQUOTE_ = inst_75440;
var acc = inst_75423;
var fuel = inst_75419;
var cache = inst_75420;
var retracted = inst_75442;
var asserted = inst_75427;
return (function (p1__75412_SHARP_){
return p1__75412_SHARP_.s;
});
})();
var inst_75447 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_75442);
var inst_75448 = cljs.core.group_by.call(null,inst_75446,inst_75447);
var inst_75449 = cljs.core.vals.call(null,inst_75448);
var inst_75450 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_75420,inst_75419,inst_75449);
var state_75476__$1 = state_75476;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75476__$1,(11),inst_75450);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____0 = (function (){
var statearr_75499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75499[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__);

(statearr_75499[(1)] = (1));

return statearr_75499;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____1 = (function (state_75476){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75476);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75500){var ex__11472__auto__ = e75500;
var statearr_75501_75518 = state_75476;
(statearr_75501_75518[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75476[(4)]))){
var statearr_75502_75519 = state_75476;
(statearr_75502_75519[(1)] = cljs.core.first.call(null,(state_75476[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75520 = state_75476;
state_75476 = G__75520;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__ = function(state_75476){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____1.call(this,state_75476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75503 = f__11543__auto__.call(null);
(statearr_75503[(6)] = c__11542__auto__);

return statearr_75503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75620){
var state_val_75621 = (state_75620[(1)]);
if((state_val_75621 === (7))){
var inst_75592 = (state_75620[(7)]);
var inst_75585 = (state_75620[(8)]);
var inst_75591 = cljs.core.seq.call(null,inst_75585);
var inst_75592__$1 = cljs.core.first.call(null,inst_75591);
var inst_75593 = cljs.core.next.call(null,inst_75591);
var state_75620__$1 = (function (){var statearr_75622 = state_75620;
(statearr_75622[(7)] = inst_75592__$1);

(statearr_75622[(9)] = inst_75593);

return statearr_75622;
})();
if(cljs.core.truth_(inst_75592__$1)){
var statearr_75623_75660 = state_75620__$1;
(statearr_75623_75660[(1)] = (9));

} else {
var statearr_75624_75661 = state_75620__$1;
(statearr_75624_75661[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (1))){
var state_75620__$1 = state_75620;
var statearr_75625_75662 = state_75620__$1;
(statearr_75625_75662[(2)] = null);

(statearr_75625_75662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (4))){
var inst_75522 = (state_75620[(2)]);
var state_75620__$1 = state_75620;
var statearr_75626_75663 = state_75620__$1;
(statearr_75626_75663[(2)] = inst_75522);

(statearr_75626_75663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (6))){
var inst_75571 = (state_75620[(2)]);
var inst_75572 = fluree.db.util.async.throw_err.call(null,inst_75571);
var inst_75580 = resp;
var inst_75581 = cljs.core.seq.call(null,inst_75580);
var inst_75582 = cljs.core.first.call(null,inst_75581);
var inst_75583 = cljs.core.next.call(null,inst_75581);
var inst_75584 = cljs.core.PersistentHashMap.EMPTY;
var inst_75585 = inst_75580;
var inst_75586 = inst_75584;
var state_75620__$1 = (function (){var statearr_75627 = state_75620;
(statearr_75627[(10)] = inst_75572);

(statearr_75627[(11)] = inst_75586);

(statearr_75627[(12)] = inst_75582);

(statearr_75627[(8)] = inst_75585);

(statearr_75627[(13)] = inst_75583);

return statearr_75627;
})();
var statearr_75628_75664 = state_75620__$1;
(statearr_75628_75664[(2)] = null);

(statearr_75628_75664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (3))){
var inst_75618 = (state_75620[(2)]);
var state_75620__$1 = state_75620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75620__$1,inst_75618);
} else {
if((state_val_75621 === (2))){
var _ = (function (){var statearr_75629 = state_75620;
(statearr_75629[(4)] = cljs.core.cons.call(null,(5),(state_75620[(4)])));

return statearr_75629;
})();
var inst_75528 = (function (){return (function (p1__75521_SHARP_){
return p1__75521_SHARP_.t;
});
})();
var inst_75529 = cljs.core.map.call(null,inst_75528,resp);
var inst_75530 = cljs.core.set.call(null,inst_75529);
var inst_75567 = cljs.core.async.chan.call(null,(1));
var inst_75568 = (function (){var ts = inst_75530;
var c__11542__auto____$1 = inst_75567;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75565){
var state_val_75566 = (state_75565[(1)]);
if((state_val_75566 === (1))){
var inst_75538 = ts;
var inst_75539 = cljs.core.seq.call(null,inst_75538);
var inst_75540 = cljs.core.first.call(null,inst_75539);
var inst_75541 = cljs.core.next.call(null,inst_75539);
var inst_75542 = cljs.core.PersistentHashMap.EMPTY;
var inst_75543 = inst_75538;
var inst_75544 = inst_75542;
var state_75565__$1 = (function (){var statearr_75630 = state_75565;
(statearr_75630[(7)] = inst_75543);

(statearr_75630[(8)] = inst_75540);

(statearr_75630[(9)] = inst_75544);

(statearr_75630[(10)] = inst_75541);

return statearr_75630;
})();
var statearr_75631_75665 = state_75565__$1;
(statearr_75631_75665[(2)] = null);

(statearr_75631_75665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75566 === (2))){
var inst_75543 = (state_75565[(7)]);
var inst_75550 = (state_75565[(11)]);
var inst_75549 = cljs.core.seq.call(null,inst_75543);
var inst_75550__$1 = cljs.core.first.call(null,inst_75549);
var inst_75551 = cljs.core.next.call(null,inst_75549);
var state_75565__$1 = (function (){var statearr_75632 = state_75565;
(statearr_75632[(11)] = inst_75550__$1);

(statearr_75632[(12)] = inst_75551);

return statearr_75632;
})();
if(cljs.core.truth_(inst_75550__$1)){
var statearr_75633_75666 = state_75565__$1;
(statearr_75633_75666[(1)] = (4));

} else {
var statearr_75634_75667 = state_75565__$1;
(statearr_75634_75667[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75566 === (3))){
var inst_75563 = (state_75565[(2)]);
var state_75565__$1 = state_75565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75565__$1,inst_75563);
} else {
if((state_val_75566 === (4))){
var inst_75550 = (state_75565[(11)]);
var inst_75553 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_75550);
var state_75565__$1 = state_75565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75565__$1,(7),inst_75553);
} else {
if((state_val_75566 === (5))){
var inst_75544 = (state_75565[(9)]);
var state_75565__$1 = state_75565;
var statearr_75635_75668 = state_75565__$1;
(statearr_75635_75668[(2)] = inst_75544);

(statearr_75635_75668[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75566 === (6))){
var inst_75561 = (state_75565[(2)]);
var state_75565__$1 = state_75565;
var statearr_75636_75669 = state_75565__$1;
(statearr_75636_75669[(2)] = inst_75561);

(statearr_75636_75669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75566 === (7))){
var inst_75550 = (state_75565[(11)]);
var inst_75544 = (state_75565[(9)]);
var inst_75551 = (state_75565[(12)]);
var inst_75555 = (state_75565[(2)]);
var inst_75556 = fluree.db.util.async.throw_err.call(null,inst_75555);
var inst_75557 = cljs.core.assoc.call(null,inst_75544,inst_75550,inst_75556);
var inst_75543 = inst_75551;
var inst_75544__$1 = inst_75557;
var state_75565__$1 = (function (){var statearr_75637 = state_75565;
(statearr_75637[(7)] = inst_75543);

(statearr_75637[(9)] = inst_75544__$1);

return statearr_75637;
})();
var statearr_75638_75670 = state_75565__$1;
(statearr_75638_75670[(2)] = null);

(statearr_75638_75670[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0 = (function (){
var statearr_75639 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75639[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__);

(statearr_75639[(1)] = (1));

return statearr_75639;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1 = (function (state_75565){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75640){var ex__11472__auto__ = e75640;
var statearr_75641_75671 = state_75565;
(statearr_75641_75671[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75565[(4)]))){
var statearr_75642_75672 = state_75565;
(statearr_75642_75672[(1)] = cljs.core.first.call(null,(state_75565[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75673 = state_75565;
state_75565 = G__75673;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__ = function(state_75565){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1.call(this,state_75565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75643 = f__11543__auto__.call(null);
(statearr_75643[(6)] = c__11542__auto____$1);

return statearr_75643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_75569 = cljs.core.async.impl.dispatch.run.call(null,inst_75568);
var state_75620__$1 = (function (){var statearr_75644 = state_75620;
(statearr_75644[(14)] = inst_75569);

return statearr_75644;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75620__$1,(6),inst_75567);
} else {
if((state_val_75621 === (11))){
var inst_75612 = (state_75620[(2)]);
var state_75620__$1 = state_75620;
var statearr_75646_75674 = state_75620__$1;
(statearr_75646_75674[(2)] = inst_75612);

(statearr_75646_75674[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (9))){
var inst_75572 = (state_75620[(10)]);
var inst_75592 = (state_75620[(7)]);
var inst_75586 = (state_75620[(11)]);
var inst_75593 = (state_75620[(9)]);
var inst_75595 = inst_75592.t;
var inst_75596 = cljs.core.get.call(null,inst_75572,inst_75595);
var inst_75597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75598 = [inst_75596,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_75599 = (new cljs.core.PersistentVector(null,2,(5),inst_75597,inst_75598,null));
var inst_75600 = cljs.core.assoc_in.call(null,inst_75586,inst_75599,inst_75596);
var inst_75601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75602 = [inst_75596,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_75603 = (new cljs.core.PersistentVector(null,2,(5),inst_75601,inst_75602,null));
var inst_75604 = cljs.core.update_in.call(null,inst_75600,inst_75603,cljs.core.conj,inst_75592);
var inst_75605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75606 = [inst_75596,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_75607 = (new cljs.core.PersistentVector(null,2,(5),inst_75605,inst_75606,null));
var inst_75608 = cljs.core.update_in.call(null,inst_75604,inst_75607,fluree.db.api_js.min_safe,inst_75595);
var inst_75585 = inst_75593;
var inst_75586__$1 = inst_75608;
var state_75620__$1 = (function (){var statearr_75647 = state_75620;
(statearr_75647[(11)] = inst_75586__$1);

(statearr_75647[(8)] = inst_75585);

return statearr_75647;
})();
var statearr_75648_75675 = state_75620__$1;
(statearr_75648_75675[(2)] = null);

(statearr_75648_75675[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (5))){
var _ = (function (){var statearr_75649 = state_75620;
(statearr_75649[(4)] = cljs.core.rest.call(null,(state_75620[(4)])));

return statearr_75649;
})();
var state_75620__$1 = state_75620;
var ex75645 = (state_75620__$1[(2)]);
var statearr_75650_75676 = state_75620__$1;
(statearr_75650_75676[(5)] = ex75645);


if((ex75645 instanceof Error)){
var statearr_75651_75677 = state_75620__$1;
(statearr_75651_75677[(1)] = (4));

(statearr_75651_75677[(5)] = null);

} else {
throw ex75645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (10))){
var inst_75586 = (state_75620[(11)]);
var state_75620__$1 = state_75620;
var statearr_75652_75678 = state_75620__$1;
(statearr_75652_75678[(2)] = inst_75586);

(statearr_75652_75678[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75621 === (8))){
var inst_75614 = (state_75620[(2)]);
var inst_75615 = cljs.core.vals.call(null,inst_75614);
var _ = (function (){var statearr_75653 = state_75620;
(statearr_75653[(4)] = cljs.core.rest.call(null,(state_75620[(4)])));

return statearr_75653;
})();
var state_75620__$1 = state_75620;
var statearr_75654_75679 = state_75620__$1;
(statearr_75654_75679[(2)] = inst_75615);

(statearr_75654_75679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0 = (function (){
var statearr_75655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75655[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__);

(statearr_75655[(1)] = (1));

return statearr_75655;
});
var fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1 = (function (state_75620){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75656){var ex__11472__auto__ = e75656;
var statearr_75657_75680 = state_75620;
(statearr_75657_75680[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75620[(4)]))){
var statearr_75658_75681 = state_75620;
(statearr_75658_75681[(1)] = cljs.core.first.call(null,(state_75620[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75682 = state_75620;
state_75620 = G__75682;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__ = function(state_75620){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1.call(this,state_75620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__11469__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75659 = f__11543__auto__.call(null);
(statearr_75659[(6)] = c__11542__auto__);

return statearr_75659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_75824){
var state_val_75825 = (state_75824[(1)]);
if((state_val_75825 === (7))){
var inst_75707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75708 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75709 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75710 = [inst_75708,inst_75709];
var inst_75711 = (new cljs.core.PersistentVector(null,2,(5),inst_75707,inst_75710,null));
var state_75824__$1 = state_75824;
var statearr_75826_75893 = state_75824__$1;
(statearr_75826_75893[(2)] = inst_75711);

(statearr_75826_75893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (20))){
var inst_75737 = (state_75824[(7)]);
var state_75824__$1 = state_75824;
var statearr_75827_75894 = state_75824__$1;
(statearr_75827_75894[(2)] = inst_75737);

(statearr_75827_75894[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (27))){
var state_75824__$1 = state_75824;
var statearr_75828_75895 = state_75824__$1;
(statearr_75828_75895[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (1))){
var state_75824__$1 = state_75824;
var statearr_75830_75896 = state_75824__$1;
(statearr_75830_75896[(2)] = null);

(statearr_75830_75896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (24))){
var inst_75736 = (state_75824[(8)]);
var state_75824__$1 = state_75824;
if(cljs.core.truth_(inst_75736)){
var statearr_75831_75897 = state_75824__$1;
(statearr_75831_75897[(1)] = (26));

} else {
var statearr_75832_75898 = state_75824__$1;
(statearr_75832_75898[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (39))){
var inst_75811 = (state_75824[(9)]);
var state_75824__$1 = state_75824;
var statearr_75833_75899 = state_75824__$1;
(statearr_75833_75899[(2)] = inst_75811);

(statearr_75833_75899[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (4))){
var inst_75683 = (state_75824[(2)]);
var inst_75684 = fluree.db.util.log.error.call(null,inst_75683);
var inst_75685 = cljs.core.ex_data.call(null,inst_75683);
var inst_75686 = cljs.core.ex_message.call(null,inst_75683);
var inst_75687 = cljs.core.assoc.call(null,inst_75685,new cljs.core.Keyword(null,"message","message",-406056002),inst_75686);
var state_75824__$1 = (function (){var statearr_75834 = state_75824;
(statearr_75834[(10)] = inst_75684);

return statearr_75834;
})();
var statearr_75835_75900 = state_75824__$1;
(statearr_75835_75900[(2)] = inst_75687);

(statearr_75835_75900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (15))){
var inst_75721 = (state_75824[(11)]);
var inst_75716 = (state_75824[(12)]);
var inst_75730 = (state_75824[(2)]);
var inst_75731 = [inst_75721,inst_75730];
var inst_75732 = (new cljs.core.PersistentVector(null,2,(5),inst_75716,inst_75731,null));
var state_75824__$1 = state_75824;
var statearr_75836_75901 = state_75824__$1;
(statearr_75836_75901[(2)] = inst_75732);

(statearr_75836_75901[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (21))){
var inst_75736 = (state_75824[(8)]);
var state_75824__$1 = state_75824;
var statearr_75837_75902 = state_75824__$1;
(statearr_75837_75902[(2)] = inst_75736);

(statearr_75837_75902[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (31))){
var inst_75777 = (state_75824[(2)]);
var state_75824__$1 = state_75824;
var statearr_75838_75903 = state_75824__$1;
(statearr_75838_75903[(2)] = inst_75777);

(statearr_75838_75903[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (32))){
var inst_75713 = (state_75824[(13)]);
var inst_75789 = cljs.core.pr_str.call(null,inst_75713);
var inst_75790 = ["Invalid block range provided: ",inst_75789].join('');
var inst_75791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75792 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75793 = cljs.core.PersistentHashMap.fromArrays(inst_75791,inst_75792);
var inst_75794 = cljs.core.ex_info.call(null,inst_75790,inst_75793);
var inst_75795 = (function(){throw inst_75794})();
var state_75824__$1 = state_75824;
var statearr_75839_75904 = state_75824__$1;
(statearr_75839_75904[(2)] = inst_75795);

(statearr_75839_75904[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (40))){
var inst_75810 = (state_75824[(14)]);
var inst_75816 = (state_75824[(2)]);
var inst_75817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75818 = [inst_75810,inst_75816];
var inst_75819 = (new cljs.core.PersistentVector(null,2,(5),inst_75817,inst_75818,null));
var _ = (function (){var statearr_75840 = state_75824;
(statearr_75840[(4)] = cljs.core.rest.call(null,(state_75824[(4)])));

return statearr_75840;
})();
var state_75824__$1 = state_75824;
var statearr_75841_75905 = state_75824__$1;
(statearr_75841_75905[(2)] = inst_75819);

(statearr_75841_75905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (33))){
var state_75824__$1 = state_75824;
var statearr_75842_75906 = state_75824__$1;
(statearr_75842_75906[(2)] = null);

(statearr_75842_75906[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (13))){
var inst_75722 = (state_75824[(15)]);
var inst_75724 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_75722);
var state_75824__$1 = state_75824;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75824__$1,(16),inst_75724);
} else {
if((state_val_75825 === (22))){
var inst_75755 = (state_75824[(2)]);
var state_75824__$1 = state_75824;
if(cljs.core.truth_(inst_75755)){
var statearr_75843_75907 = state_75824__$1;
(statearr_75843_75907[(1)] = (23));

} else {
var statearr_75844_75908 = state_75824__$1;
(statearr_75844_75908[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (36))){
var inst_75783 = (state_75824[(16)]);
var inst_75782 = (state_75824[(17)]);
var inst_75805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75806 = [inst_75782,inst_75783];
var inst_75807 = (new cljs.core.PersistentVector(null,2,(5),inst_75805,inst_75806,null));
var state_75824__$1 = state_75824;
var statearr_75845_75909 = state_75824__$1;
(statearr_75845_75909[(2)] = inst_75807);

(statearr_75845_75909[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (29))){
var inst_75713 = (state_75824[(13)]);
var inst_75768 = cljs.core.pr_str.call(null,inst_75713);
var inst_75769 = ["Invalid block range provided: ",inst_75768].join('');
var inst_75770 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75771 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75772 = cljs.core.PersistentHashMap.fromArrays(inst_75770,inst_75771);
var inst_75773 = cljs.core.ex_info.call(null,inst_75769,inst_75772);
var inst_75774 = (function(){throw inst_75773})();
var state_75824__$1 = state_75824;
var statearr_75846_75910 = state_75824__$1;
(statearr_75846_75910[(2)] = inst_75774);

(statearr_75846_75910[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (6))){
var inst_75705 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_75824__$1 = state_75824;
var statearr_75847_75911 = state_75824__$1;
(statearr_75847_75911[(2)] = inst_75705);

(statearr_75847_75911[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (28))){
var inst_75779 = (state_75824[(2)]);
var state_75824__$1 = state_75824;
var statearr_75848_75912 = state_75824__$1;
(statearr_75848_75912[(2)] = inst_75779);

(statearr_75848_75912[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (25))){
var inst_75783 = (state_75824[(16)]);
var inst_75782 = (state_75824[(17)]);
var inst_75781 = (state_75824[(2)]);
var inst_75782__$1 = cljs.core.nth.call(null,inst_75781,(0),null);
var inst_75783__$1 = cljs.core.nth.call(null,inst_75781,(1),null);
var inst_75784 = cljs.core.pos_int_QMARK_.call(null,inst_75782__$1);
var inst_75785 = cljs.core.pos_int_QMARK_.call(null,inst_75783__$1);
var inst_75786 = ((inst_75784) && (inst_75785));
var inst_75787 = cljs.core.not.call(null,inst_75786);
var state_75824__$1 = (function (){var statearr_75849 = state_75824;
(statearr_75849[(16)] = inst_75783__$1);

(statearr_75849[(17)] = inst_75782__$1);

return statearr_75849;
})();
if(inst_75787){
var statearr_75850_75913 = state_75824__$1;
(statearr_75850_75913[(1)] = (32));

} else {
var statearr_75851_75914 = state_75824__$1;
(statearr_75851_75914[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (34))){
var inst_75783 = (state_75824[(16)]);
var inst_75782 = (state_75824[(17)]);
var inst_75798 = (state_75824[(2)]);
var inst_75799 = (inst_75783 < inst_75782);
var state_75824__$1 = (function (){var statearr_75852 = state_75824;
(statearr_75852[(18)] = inst_75798);

return statearr_75852;
})();
if(cljs.core.truth_(inst_75799)){
var statearr_75853_75915 = state_75824__$1;
(statearr_75853_75915[(1)] = (35));

} else {
var statearr_75854_75916 = state_75824__$1;
(statearr_75854_75916[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (17))){
var inst_75736 = (state_75824[(8)]);
var inst_75738 = (state_75824[(19)]);
var inst_75741 = cljs.core.pr_str.call(null,inst_75736);
var inst_75742 = cljs.core.pr_str.call(null,inst_75738);
var inst_75743 = ["Start block is out of range for this ledger. Start block provided: ",inst_75741,". Database block: ",inst_75742].join('');
var inst_75744 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_75745 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_75746 = cljs.core.PersistentHashMap.fromArrays(inst_75744,inst_75745);
var inst_75747 = cljs.core.ex_info.call(null,inst_75743,inst_75746);
var inst_75748 = (function(){throw inst_75747})();
var state_75824__$1 = state_75824;
var statearr_75855_75917 = state_75824__$1;
(statearr_75855_75917[(2)] = inst_75748);

(statearr_75855_75917[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (3))){
var inst_75822 = (state_75824[(2)]);
var state_75824__$1 = state_75824;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_75824__$1,inst_75822);
} else {
if((state_val_75825 === (12))){
var inst_75713 = (state_75824[(13)]);
var inst_75722 = (state_75824[(15)]);
var inst_75720 = (state_75824[(2)]);
var inst_75721 = fluree.db.util.async.throw_err.call(null,inst_75720);
var inst_75722__$1 = cljs.core.second.call(null,inst_75713);
var state_75824__$1 = (function (){var statearr_75856 = state_75824;
(statearr_75856[(11)] = inst_75721);

(statearr_75856[(15)] = inst_75722__$1);

return statearr_75856;
})();
if(cljs.core.truth_(inst_75722__$1)){
var statearr_75857_75918 = state_75824__$1;
(statearr_75857_75918[(1)] = (13));

} else {
var statearr_75858_75919 = state_75824__$1;
(statearr_75858_75919[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (2))){
var _ = (function (){var statearr_75859 = state_75824;
(statearr_75859[(4)] = cljs.core.cons.call(null,(5),(state_75824[(4)])));

return statearr_75859;
})();
var inst_75702 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_75703 = cljs.core.sequential_QMARK_.call(null,inst_75702);
var state_75824__$1 = state_75824;
if(inst_75703){
var statearr_75860_75920 = state_75824__$1;
(statearr_75860_75920[(1)] = (6));

} else {
var statearr_75861_75921 = state_75824__$1;
(statearr_75861_75921[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (23))){
var inst_75736 = (state_75824[(8)]);
var inst_75737 = (state_75824[(7)]);
var inst_75757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75758 = [inst_75736,inst_75737];
var inst_75759 = (new cljs.core.PersistentVector(null,2,(5),inst_75757,inst_75758,null));
var state_75824__$1 = state_75824;
var statearr_75862_75922 = state_75824__$1;
(statearr_75862_75922[(2)] = inst_75759);

(statearr_75862_75922[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (35))){
var inst_75783 = (state_75824[(16)]);
var inst_75782 = (state_75824[(17)]);
var inst_75801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75802 = [inst_75783,inst_75782];
var inst_75803 = (new cljs.core.PersistentVector(null,2,(5),inst_75801,inst_75802,null));
var state_75824__$1 = state_75824;
var statearr_75863_75923 = state_75824__$1;
(statearr_75863_75923[(2)] = inst_75803);

(statearr_75863_75923[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (19))){
var inst_75736 = (state_75824[(8)]);
var inst_75751 = (state_75824[(2)]);
var state_75824__$1 = (function (){var statearr_75864 = state_75824;
(statearr_75864[(20)] = inst_75751);

return statearr_75864;
})();
if(cljs.core.truth_(inst_75736)){
var statearr_75865_75924 = state_75824__$1;
(statearr_75865_75924[(1)] = (20));

} else {
var statearr_75866_75925 = state_75824__$1;
(statearr_75866_75925[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (11))){
var inst_75736 = (state_75824[(8)]);
var inst_75738 = (state_75824[(19)]);
var inst_75735 = (state_75824[(2)]);
var inst_75736__$1 = cljs.core.nth.call(null,inst_75735,(0),null);
var inst_75737 = cljs.core.nth.call(null,inst_75735,(1),null);
var inst_75738__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75739 = (inst_75736__$1 > inst_75738__$1);
var state_75824__$1 = (function (){var statearr_75868 = state_75824;
(statearr_75868[(8)] = inst_75736__$1);

(statearr_75868[(7)] = inst_75737);

(statearr_75868[(19)] = inst_75738__$1);

return statearr_75868;
})();
if(cljs.core.truth_(inst_75739)){
var statearr_75869_75926 = state_75824__$1;
(statearr_75869_75926[(1)] = (17));

} else {
var statearr_75870_75927 = state_75824__$1;
(statearr_75870_75927[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (9))){
var inst_75713 = (state_75824[(13)]);
var inst_75716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75717 = cljs.core.first.call(null,inst_75713);
var inst_75718 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_75717);
var state_75824__$1 = (function (){var statearr_75871 = state_75824;
(statearr_75871[(12)] = inst_75716);

return statearr_75871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_75824__$1,(12),inst_75718);
} else {
if((state_val_75825 === (5))){
var _ = (function (){var statearr_75872 = state_75824;
(statearr_75872[(4)] = cljs.core.rest.call(null,(state_75824[(4)])));

return statearr_75872;
})();
var state_75824__$1 = state_75824;
var ex75867 = (state_75824__$1[(2)]);
var statearr_75873_75928 = state_75824__$1;
(statearr_75873_75928[(5)] = ex75867);


var statearr_75874_75929 = state_75824__$1;
(statearr_75874_75929[(1)] = (4));

(statearr_75874_75929[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (14))){
var state_75824__$1 = state_75824;
var statearr_75875_75930 = state_75824__$1;
(statearr_75875_75930[(2)] = null);

(statearr_75875_75930[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (26))){
var inst_75736 = (state_75824[(8)]);
var inst_75762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75763 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_75764 = [inst_75736,inst_75763];
var inst_75765 = (new cljs.core.PersistentVector(null,2,(5),inst_75762,inst_75764,null));
var state_75824__$1 = state_75824;
var statearr_75876_75931 = state_75824__$1;
(statearr_75876_75931[(2)] = inst_75765);

(statearr_75876_75931[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (16))){
var inst_75726 = (state_75824[(2)]);
var inst_75727 = fluree.db.util.async.throw_err.call(null,inst_75726);
var state_75824__$1 = state_75824;
var statearr_75877_75932 = state_75824__$1;
(statearr_75877_75932[(2)] = inst_75727);

(statearr_75877_75932[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (38))){
var inst_75738 = (state_75824[(19)]);
var state_75824__$1 = state_75824;
var statearr_75878_75933 = state_75824__$1;
(statearr_75878_75933[(2)] = inst_75738);

(statearr_75878_75933[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (30))){
var state_75824__$1 = state_75824;
var statearr_75879_75934 = state_75824__$1;
(statearr_75879_75934[(2)] = null);

(statearr_75879_75934[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (10))){
var inst_75713 = (state_75824[(13)]);
var state_75824__$1 = state_75824;
var statearr_75880_75935 = state_75824__$1;
(statearr_75880_75935[(2)] = inst_75713);

(statearr_75880_75935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (18))){
var state_75824__$1 = state_75824;
var statearr_75881_75936 = state_75824__$1;
(statearr_75881_75936[(2)] = null);

(statearr_75881_75936[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (37))){
var inst_75738 = (state_75824[(19)]);
var inst_75811 = (state_75824[(9)]);
var inst_75809 = (state_75824[(2)]);
var inst_75810 = cljs.core.nth.call(null,inst_75809,(0),null);
var inst_75811__$1 = cljs.core.nth.call(null,inst_75809,(1),null);
var inst_75812 = (inst_75811__$1 > inst_75738);
var state_75824__$1 = (function (){var statearr_75882 = state_75824;
(statearr_75882[(14)] = inst_75810);

(statearr_75882[(9)] = inst_75811__$1);

return statearr_75882;
})();
if(cljs.core.truth_(inst_75812)){
var statearr_75883_75937 = state_75824__$1;
(statearr_75883_75937[(1)] = (38));

} else {
var statearr_75884_75938 = state_75824__$1;
(statearr_75884_75938[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_75825 === (8))){
var inst_75713 = (state_75824[(13)]);
var inst_75713__$1 = (state_75824[(2)]);
var inst_75714 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_75713__$1);
var state_75824__$1 = (function (){var statearr_75885 = state_75824;
(statearr_75885[(13)] = inst_75713__$1);

return statearr_75885;
})();
if(cljs.core.truth_(inst_75714)){
var statearr_75886_75939 = state_75824__$1;
(statearr_75886_75939[(1)] = (9));

} else {
var statearr_75887_75940 = state_75824__$1;
(statearr_75887_75940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____0 = (function (){
var statearr_75888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75888[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__);

(statearr_75888[(1)] = (1));

return statearr_75888;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____1 = (function (state_75824){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_75824);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e75889){var ex__11472__auto__ = e75889;
var statearr_75890_75941 = state_75824;
(statearr_75890_75941[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_75824[(4)]))){
var statearr_75891_75942 = state_75824;
(statearr_75891_75942[(1)] = cljs.core.first.call(null,(state_75824[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__75943 = state_75824;
state_75824 = G__75943;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__ = function(state_75824){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____1.call(this,state_75824);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_75892 = f__11543__auto__.call(null);
(statearr_75892[(6)] = c__11542__auto__);

return statearr_75892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__75946 = arguments.length;
switch (G__75946) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_76061){
var state_val_76062 = (state_76061[(1)]);
if((state_val_76062 === (7))){
var state_76061__$1 = state_76061;
var statearr_76063_76127 = state_76061__$1;
(statearr_76063_76127[(2)] = false);

(statearr_76063_76127[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (20))){
var state_76061__$1 = state_76061;
var statearr_76064_76128 = state_76061__$1;
(statearr_76064_76128[(2)] = null);

(statearr_76064_76128[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (27))){
var inst_76028 = (state_76061[(2)]);
var inst_76029 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_76061__$1 = (function (){var statearr_76065 = state_76061;
(statearr_76065[(7)] = inst_76028);

return statearr_76065;
})();
if(cljs.core.truth_(inst_76029)){
var statearr_76066_76129 = state_76061__$1;
(statearr_76066_76129[(1)] = (29));

} else {
var statearr_76067_76130 = state_76061__$1;
(statearr_76067_76130[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (1))){
var state_76061__$1 = state_76061;
var statearr_76068_76131 = state_76061__$1;
(statearr_76068_76131[(2)] = null);

(statearr_76068_76131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (24))){
var inst_75989 = (state_76061[(8)]);
var inst_76002 = (state_76061[(2)]);
var inst_76003 = cljs.core.ex_info.call(null,inst_76002,inst_75989);
var inst_76004 = (function(){throw inst_76003})();
var state_76061__$1 = state_76061;
var statearr_76069_76132 = state_76061__$1;
(statearr_76069_76132[(2)] = inst_76004);

(statearr_76069_76132[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (4))){
var inst_75947 = (state_76061[(2)]);
var inst_75948 = fluree.db.util.log.error.call(null,inst_75947);
var inst_75949 = cljs.core.ex_data.call(null,inst_75947);
var inst_75950 = cljs.core.ex_message.call(null,inst_75947);
var inst_75951 = cljs.core.assoc.call(null,inst_75949,new cljs.core.Keyword(null,"message","message",-406056002),inst_75950);
var state_76061__$1 = (function (){var statearr_76070 = state_76061;
(statearr_76070[(9)] = inst_75948);

return statearr_76070;
})();
var statearr_76071_76133 = state_76061__$1;
(statearr_76071_76133[(2)] = inst_75951);

(statearr_76071_76133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (15))){
var inst_75989 = (state_76061[(8)]);
var inst_75988 = (state_76061[(2)]);
var inst_75989__$1 = fluree.db.util.async.throw_err.call(null,inst_75988);
var inst_75990 = cljs.core.map_QMARK_.call(null,inst_75989__$1);
var state_76061__$1 = (function (){var statearr_76072 = state_76061;
(statearr_76072[(8)] = inst_75989__$1);

return statearr_76072;
})();
if(inst_75990){
var statearr_76073_76134 = state_76061__$1;
(statearr_76073_76134[(1)] = (16));

} else {
var statearr_76074_76135 = state_76061__$1;
(statearr_76074_76135[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (21))){
var inst_75989 = (state_76061[(8)]);
var inst_76007 = (state_76061[(2)]);
var inst_76008 = cljs.core.nth.call(null,inst_75989,(0),null);
var inst_76009 = cljs.core.nth.call(null,inst_75989,(1),null);
var inst_76010 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_76011 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_76012 = cljs.core.keys.call(null,inst_76011);
var inst_76013 = cljs.core._EQ_.call(null,inst_76010,inst_76012);
var state_76061__$1 = (function (){var statearr_76075 = state_76061;
(statearr_76075[(10)] = inst_76007);

(statearr_76075[(11)] = inst_76009);

(statearr_76075[(12)] = inst_76008);

return statearr_76075;
})();
if(inst_76013){
var statearr_76076_76136 = state_76061__$1;
(statearr_76076_76136[(1)] = (25));

} else {
var statearr_76077_76137 = state_76061__$1;
(statearr_76077_76137[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (31))){
var inst_76037 = (state_76061[(2)]);
var inst_76038 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_76061__$1 = (function (){var statearr_76078 = state_76061;
(statearr_76078[(13)] = inst_76037);

return statearr_76078;
})();
if(cljs.core.truth_(inst_76038)){
var statearr_76079_76138 = state_76061__$1;
(statearr_76079_76138[(1)] = (33));

} else {
var statearr_76080_76139 = state_76061__$1;
(statearr_76080_76139[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (32))){
var inst_76033 = (state_76061[(2)]);
var inst_76034 = fluree.db.util.async.throw_err.call(null,inst_76033);
var state_76061__$1 = state_76061;
var statearr_76081_76140 = state_76061__$1;
(statearr_76081_76140[(2)] = inst_76034);

(statearr_76081_76140[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (33))){
var inst_76037 = (state_76061[(13)]);
var inst_76040 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_76041 = cljs.core.sequential_QMARK_.call(null,inst_76037);
var state_76061__$1 = (function (){var statearr_76082 = state_76061;
(statearr_76082[(14)] = inst_76040);

return statearr_76082;
})();
if(inst_76041){
var statearr_76083_76141 = state_76061__$1;
(statearr_76083_76141[(1)] = (36));

} else {
var statearr_76084_76142 = state_76061__$1;
(statearr_76084_76142[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (13))){
var inst_75962 = (state_76061[(15)]);
var state_76061__$1 = state_76061;
var statearr_76085_76143 = state_76061__$1;
(statearr_76085_76143[(2)] = inst_75962);

(statearr_76085_76143[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (22))){
var inst_75997 = (state_76061[(16)]);
var state_76061__$1 = state_76061;
var statearr_76086_76144 = state_76061__$1;
(statearr_76086_76144[(2)] = inst_75997);

(statearr_76086_76144[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (36))){
var inst_76037 = (state_76061[(13)]);
var inst_76043 = cljs.core.doall.call(null,inst_76037);
var state_76061__$1 = state_76061;
var statearr_76087_76145 = state_76061__$1;
(statearr_76087_76145[(2)] = inst_76043);

(statearr_76087_76145[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (29))){
var inst_76028 = (state_76061[(7)]);
var inst_76031 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_76028);
var state_76061__$1 = state_76061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76061__$1,(32),inst_76031);
} else {
if((state_val_76062 === (6))){
var inst_75962 = (state_76061[(15)]);
var inst_75967 = inst_75962.cljs$lang$protocol_mask$partition0$;
var inst_75968 = (inst_75967 & (64));
var inst_75969 = inst_75962.cljs$core$ISeq$;
var inst_75970 = (cljs.core.PROTOCOL_SENTINEL === inst_75969);
var inst_75971 = ((inst_75968) || (inst_75970));
var state_76061__$1 = state_76061;
if(cljs.core.truth_(inst_75971)){
var statearr_76088_76146 = state_76061__$1;
(statearr_76088_76146[(1)] = (9));

} else {
var statearr_76089_76147 = state_76061__$1;
(statearr_76089_76147[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (28))){
var inst_76017 = (state_76061[(2)]);
var inst_76018 = fluree.db.util.async.throw_err.call(null,inst_76017);
var state_76061__$1 = state_76061;
var statearr_76090_76148 = state_76061__$1;
(statearr_76090_76148[(2)] = inst_76018);

(statearr_76090_76148[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (25))){
var inst_76009 = (state_76061[(11)]);
var inst_76008 = (state_76061[(12)]);
var inst_76015 = fluree.db.query.block.block_range.call(null,db,inst_76008,inst_76009,opts);
var state_76061__$1 = state_76061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76061__$1,(28),inst_76015);
} else {
if((state_val_76062 === (34))){
var inst_76037 = (state_76061[(13)]);
var state_76061__$1 = state_76061;
var statearr_76091_76149 = state_76061__$1;
(statearr_76091_76149[(2)] = inst_76037);

(statearr_76091_76149[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (17))){
var state_76061__$1 = state_76061;
var statearr_76092_76150 = state_76061__$1;
(statearr_76092_76150[(2)] = false);

(statearr_76092_76150[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (3))){
var inst_76059 = (state_76061[(2)]);
var state_76061__$1 = state_76061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76061__$1,inst_76059);
} else {
if((state_val_76062 === (12))){
var inst_75962 = (state_76061[(15)]);
var inst_75980 = cljs.core.apply.call(null,cljs.core.hash_map,inst_75962);
var state_76061__$1 = state_76061;
var statearr_76093_76151 = state_76061__$1;
(statearr_76093_76151[(2)] = inst_75980);

(statearr_76093_76151[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (2))){
var inst_75962 = (state_76061[(15)]);
var _ = (function (){var statearr_76094 = state_76061;
(statearr_76094[(4)] = cljs.core.cons.call(null,(5),(state_76061[(4)])));

return statearr_76094;
})();
var inst_75961 = fluree.db.util.core.current_time_millis.call(null);
var inst_75962__$1 = db;
var inst_75964 = (inst_75962__$1 == null);
var inst_75965 = cljs.core.not.call(null,inst_75964);
var state_76061__$1 = (function (){var statearr_76095 = state_76061;
(statearr_76095[(17)] = inst_75961);

(statearr_76095[(15)] = inst_75962__$1);

return statearr_76095;
})();
if(inst_75965){
var statearr_76096_76152 = state_76061__$1;
(statearr_76096_76152[(1)] = (6));

} else {
var statearr_76097_76153 = state_76061__$1;
(statearr_76097_76153[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (23))){
var inst_75985 = (state_76061[(18)]);
var inst_75984 = (state_76061[(19)]);
var inst_76000 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75984),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75985)].join('');
var state_76061__$1 = state_76061;
var statearr_76098_76154 = state_76061__$1;
(statearr_76098_76154[(2)] = inst_76000);

(statearr_76098_76154[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (35))){
var inst_76056 = (state_76061[(2)]);
var _ = (function (){var statearr_76099 = state_76061;
(statearr_76099[(4)] = cljs.core.rest.call(null,(state_76061[(4)])));

return statearr_76099;
})();
var state_76061__$1 = state_76061;
var statearr_76100_76155 = state_76061__$1;
(statearr_76100_76155[(2)] = inst_76056);

(statearr_76100_76155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (19))){
var inst_75997 = (state_76061[(16)]);
var inst_75989 = (state_76061[(8)]);
var inst_75997__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_75989);
var state_76061__$1 = (function (){var statearr_76101 = state_76061;
(statearr_76101[(16)] = inst_75997__$1);

return statearr_76101;
})();
if(cljs.core.truth_(inst_75997__$1)){
var statearr_76102_76156 = state_76061__$1;
(statearr_76102_76156[(1)] = (22));

} else {
var statearr_76103_76157 = state_76061__$1;
(statearr_76103_76157[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (11))){
var inst_75975 = (state_76061[(2)]);
var state_76061__$1 = state_76061;
var statearr_76105_76158 = state_76061__$1;
(statearr_76105_76158[(2)] = inst_75975);

(statearr_76105_76158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (9))){
var state_76061__$1 = state_76061;
var statearr_76106_76159 = state_76061__$1;
(statearr_76106_76159[(2)] = true);

(statearr_76106_76159[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (5))){
var _ = (function (){var statearr_76107 = state_76061;
(statearr_76107[(4)] = cljs.core.rest.call(null,(state_76061[(4)])));

return statearr_76107;
})();
var state_76061__$1 = state_76061;
var ex76104 = (state_76061__$1[(2)]);
var statearr_76108_76160 = state_76061__$1;
(statearr_76108_76160[(5)] = ex76104);


var statearr_76109_76161 = state_76061__$1;
(statearr_76109_76161[(1)] = (4));

(statearr_76109_76161[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (14))){
var inst_75983 = (state_76061[(20)]);
var inst_75983__$1 = (state_76061[(2)]);
var inst_75984 = cljs.core.get.call(null,inst_75983__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_75985 = cljs.core.get.call(null,inst_75983__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_75986 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_76061__$1 = (function (){var statearr_76110 = state_76061;
(statearr_76110[(18)] = inst_75985);

(statearr_76110[(19)] = inst_75984);

(statearr_76110[(20)] = inst_75983__$1);

return statearr_76110;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76061__$1,(15),inst_75986);
} else {
if((state_val_76062 === (26))){
var inst_76020 = cljs.core.pr_str.call(null,query_map);
var inst_76021 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_76020].join('');
var inst_76022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76023 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76024 = cljs.core.PersistentHashMap.fromArrays(inst_76022,inst_76023);
var inst_76025 = cljs.core.ex_info.call(null,inst_76021,inst_76024);
var inst_76026 = (function(){throw inst_76025})();
var state_76061__$1 = state_76061;
var statearr_76111_76162 = state_76061__$1;
(statearr_76111_76162[(2)] = inst_76026);

(statearr_76111_76162[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (16))){
var inst_75989 = (state_76061[(8)]);
var inst_75992 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_75989);
var state_76061__$1 = state_76061;
var statearr_76112_76163 = state_76061__$1;
(statearr_76112_76163[(2)] = inst_75992);

(statearr_76112_76163[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (38))){
var inst_75961 = (state_76061[(17)]);
var inst_75985 = (state_76061[(18)]);
var inst_76040 = (state_76061[(14)]);
var inst_76007 = (state_76061[(10)]);
var inst_76009 = (state_76061[(11)]);
var inst_75984 = (state_76061[(19)]);
var inst_75983 = (state_76061[(20)]);
var inst_76028 = (state_76061[(7)]);
var inst_75989 = (state_76061[(8)]);
var inst_76037 = (state_76061[(13)]);
var inst_76008 = (state_76061[(12)]);
var inst_76046 = (state_76061[(2)]);
var inst_76047 = (function (){var network = inst_75984;
var block_start = inst_76008;
var block_end = inst_76009;
var range = inst_75989;
var map__75957 = inst_75983;
var db_id = inst_75985;
var _ = inst_76007;
var start = inst_75961;
var result_SINGLEQUOTE_ = inst_76037;
var result = inst_76028;
var vec__75958 = inst_75989;
return (function (p1__75944_SHARP_){
return goog.string.format("%.2fms",p1__75944_SHARP_);
});
})();
var inst_76048 = fluree.db.util.core.current_time_millis.call(null);
var inst_76049 = (inst_76048 - inst_75961);
var inst_76050 = (inst_76049 / (1000000));
var inst_76051 = inst_76047.call(null,inst_76050);
var inst_76052 = [(200),inst_76046,(100),inst_76051];
var inst_76053 = cljs.core.PersistentHashMap.fromArrays(inst_76040,inst_76052);
var state_76061__$1 = state_76061;
var statearr_76113_76164 = state_76061__$1;
(statearr_76113_76164[(2)] = inst_76053);

(statearr_76113_76164[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (30))){
var inst_76028 = (state_76061[(7)]);
var state_76061__$1 = state_76061;
var statearr_76114_76165 = state_76061__$1;
(statearr_76114_76165[(2)] = inst_76028);

(statearr_76114_76165[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (10))){
var state_76061__$1 = state_76061;
var statearr_76115_76166 = state_76061__$1;
(statearr_76115_76166[(2)] = false);

(statearr_76115_76166[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (18))){
var inst_75995 = (state_76061[(2)]);
var state_76061__$1 = state_76061;
if(cljs.core.truth_(inst_75995)){
var statearr_76116_76167 = state_76061__$1;
(statearr_76116_76167[(1)] = (19));

} else {
var statearr_76117_76168 = state_76061__$1;
(statearr_76117_76168[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (37))){
var inst_76037 = (state_76061[(13)]);
var state_76061__$1 = state_76061;
var statearr_76118_76169 = state_76061__$1;
(statearr_76118_76169[(2)] = inst_76037);

(statearr_76118_76169[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76062 === (8))){
var inst_75978 = (state_76061[(2)]);
var state_76061__$1 = state_76061;
if(cljs.core.truth_(inst_75978)){
var statearr_76119_76170 = state_76061__$1;
(statearr_76119_76170[(1)] = (12));

} else {
var statearr_76120_76171 = state_76061__$1;
(statearr_76120_76171[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_76121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76121[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_76121[(1)] = (1));

return statearr_76121;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_76061){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_76061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e76122){var ex__11472__auto__ = e76122;
var statearr_76123_76172 = state_76061;
(statearr_76123_76172[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_76061[(4)]))){
var statearr_76124_76173 = state_76061;
(statearr_76124_76173[(1)] = cljs.core.first.call(null,(state_76061[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76174 = state_76061;
state_76061 = G__76174;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_76061){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_76061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_76125 = f__11543__auto__.call(null);
(statearr_76125[(6)] = c__11542__auto__);

return statearr_76125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__76176 = arguments.length;
switch (G__76176) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_76377){
var state_val_76378 = (state_76377[(1)]);
if((state_val_76378 === (7))){
var inst_76194 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76379_76463 = state_76377__$1;
(statearr_76379_76463[(2)] = inst_76194);

(statearr_76379_76463[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (59))){
var inst_76375 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76377__$1,inst_76375);
} else {
if((state_val_76378 === (20))){
var state_76377__$1 = state_76377;
var statearr_76380_76464 = state_76377__$1;
(statearr_76380_76464[(2)] = (-1));

(statearr_76380_76464[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (58))){
var inst_76367 = (state_76377[(7)]);
var state_76377__$1 = state_76377;
var statearr_76381_76465 = state_76377__$1;
(statearr_76381_76465[(2)] = inst_76367);

(statearr_76381_76465[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (27))){
var inst_76204 = (state_76377[(8)]);
var inst_76254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76255 = [inst_76204];
var inst_76256 = (new cljs.core.PersistentVector(null,1,(5),inst_76254,inst_76255,null));
var state_76377__$1 = state_76377;
var statearr_76382_76466 = state_76377__$1;
(statearr_76382_76466[(2)] = inst_76256);

(statearr_76382_76466[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (1))){
var inst_76181 = (state_76377[(9)]);
var inst_76181__$1 = query_map;
var inst_76183 = (inst_76181__$1 == null);
var inst_76184 = cljs.core.not.call(null,inst_76183);
var state_76377__$1 = (function (){var statearr_76383 = state_76377;
(statearr_76383[(9)] = inst_76181__$1);

return statearr_76383;
})();
if(inst_76184){
var statearr_76384_76467 = state_76377__$1;
(statearr_76384_76467[(1)] = (2));

} else {
var statearr_76385_76468 = state_76377__$1;
(statearr_76385_76468[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (24))){
var inst_76208 = (state_76377[(10)]);
var inst_76249 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76208);
var state_76377__$1 = state_76377;
var statearr_76386_76469 = state_76377__$1;
(statearr_76386_76469[(2)] = inst_76249);

(statearr_76386_76469[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (55))){
var inst_76225 = (state_76377[(11)]);
var inst_76367 = (state_76377[(2)]);
var state_76377__$1 = (function (){var statearr_76387 = state_76377;
(statearr_76387[(7)] = inst_76367);

return statearr_76387;
})();
if(cljs.core.truth_(inst_76225)){
var statearr_76388_76470 = state_76377__$1;
(statearr_76388_76470[(1)] = (57));

} else {
var statearr_76389_76471 = state_76377__$1;
(statearr_76389_76471[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (39))){
var inst_76285 = (state_76377[(12)]);
var inst_76300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76301 = [inst_76285,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_76302 = (new cljs.core.PersistentVector(null,2,(5),inst_76300,inst_76301,null));
var state_76377__$1 = state_76377;
var statearr_76390_76472 = state_76377__$1;
(statearr_76390_76472[(2)] = inst_76302);

(statearr_76390_76472[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (46))){
var state_76377__$1 = state_76377;
var statearr_76391_76473 = state_76377__$1;
(statearr_76391_76473[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (4))){
var inst_76197 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
if(cljs.core.truth_(inst_76197)){
var statearr_76393_76474 = state_76377__$1;
(statearr_76393_76474[(1)] = (8));

} else {
var statearr_76394_76475 = state_76377__$1;
(statearr_76394_76475[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (54))){
var inst_76359 = (state_76377[(13)]);
var state_76377__$1 = state_76377;
var statearr_76395_76476 = state_76377__$1;
(statearr_76395_76476[(2)] = inst_76359);

(statearr_76395_76476[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (15))){
var inst_76212 = (state_76377[(2)]);
var inst_76213 = fluree.db.util.async.throw_err.call(null,inst_76212);
var state_76377__$1 = state_76377;
var statearr_76396_76477 = state_76377__$1;
(statearr_76396_76477[(2)] = inst_76213);

(statearr_76396_76477[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (48))){
var inst_76204 = (state_76377[(8)]);
var inst_76332 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76204)].join('');
var inst_76333 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76334 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76335 = cljs.core.PersistentHashMap.fromArrays(inst_76333,inst_76334);
var inst_76336 = cljs.core.ex_info.call(null,inst_76332,inst_76335);
var inst_76337 = (function(){throw inst_76336})();
var state_76377__$1 = state_76377;
var statearr_76397_76478 = state_76377__$1;
(statearr_76397_76478[(2)] = inst_76337);

(statearr_76397_76478[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (50))){
var inst_76340 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76398_76479 = state_76377__$1;
(statearr_76398_76479[(2)] = inst_76340);

(statearr_76398_76479[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (21))){
var inst_76218 = (state_76377[(14)]);
var inst_76241 = (state_76377[(2)]);
var state_76377__$1 = (function (){var statearr_76399 = state_76377;
(statearr_76399[(15)] = inst_76241);

return statearr_76399;
})();
if(cljs.core.truth_(inst_76218)){
var statearr_76400_76480 = state_76377__$1;
(statearr_76400_76480[(1)] = (23));

} else {
var statearr_76401_76481 = state_76377__$1;
(statearr_76401_76481[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (31))){
var state_76377__$1 = state_76377;
var statearr_76402_76482 = state_76377__$1;
(statearr_76402_76482[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (32))){
var inst_76283 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76404_76483 = state_76377__$1;
(statearr_76404_76483[(2)] = inst_76283);

(statearr_76404_76483[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (40))){
var inst_76295 = (state_76377[(16)]);
var inst_76293 = (state_76377[(17)]);
var inst_76294 = (state_76377[(18)]);
var inst_76304 = (inst_76293 == null);
var inst_76305 = (inst_76294 == null);
var inst_76306 = cljs.core.not.call(null,inst_76305);
var inst_76307 = (inst_76295 == null);
var inst_76308 = ((inst_76304) && (inst_76306) && (inst_76307));
var state_76377__$1 = state_76377;
if(cljs.core.truth_(inst_76308)){
var statearr_76405_76484 = state_76377__$1;
(statearr_76405_76484[(1)] = (42));

} else {
var statearr_76406_76485 = state_76377__$1;
(statearr_76406_76485[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (56))){
var inst_76363 = (state_76377[(2)]);
var inst_76364 = fluree.db.util.async.throw_err.call(null,inst_76363);
var state_76377__$1 = state_76377;
var statearr_76407_76486 = state_76377__$1;
(statearr_76407_76486[(2)] = inst_76364);

(statearr_76407_76486[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (33))){
var inst_76204 = (state_76377[(8)]);
var inst_76262 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76204)].join('');
var inst_76263 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76264 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76265 = cljs.core.PersistentHashMap.fromArrays(inst_76263,inst_76264);
var inst_76266 = cljs.core.ex_info.call(null,inst_76262,inst_76265);
var inst_76267 = (function(){throw inst_76266})();
var state_76377__$1 = state_76377;
var statearr_76408_76487 = state_76377__$1;
(statearr_76408_76487[(2)] = inst_76267);

(statearr_76408_76487[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (13))){
var state_76377__$1 = state_76377;
var statearr_76409_76488 = state_76377__$1;
(statearr_76409_76488[(2)] = null);

(statearr_76409_76488[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (22))){
var inst_76235 = (state_76377[(2)]);
var inst_76236 = fluree.db.util.async.throw_err.call(null,inst_76235);
var inst_76237 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76236);
var inst_76238 = (inst_76237 - (1));
var state_76377__$1 = state_76377;
var statearr_76410_76489 = state_76377__$1;
(statearr_76410_76489[(2)] = inst_76238);

(statearr_76410_76489[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (36))){
var inst_76204 = (state_76377[(8)]);
var inst_76273 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_76204)].join('');
var inst_76274 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_76275 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_76276 = cljs.core.PersistentHashMap.fromArrays(inst_76274,inst_76275);
var inst_76277 = cljs.core.ex_info.call(null,inst_76273,inst_76276);
var inst_76278 = (function(){throw inst_76277})();
var state_76377__$1 = state_76377;
var statearr_76411_76490 = state_76377__$1;
(statearr_76411_76490[(2)] = inst_76278);

(statearr_76411_76490[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (41))){
var inst_76241 = (state_76377[(15)]);
var inst_76251 = (state_76377[(19)]);
var inst_76208 = (state_76377[(10)]);
var inst_76346 = (state_76377[(2)]);
var inst_76347 = cljs.core.nth.call(null,inst_76346,(0),null);
var inst_76348 = cljs.core.nth.call(null,inst_76346,(1),null);
var inst_76349 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_76350 = [inst_76241,inst_76251];
var inst_76351 = cljs.core.PersistentHashMap.fromArrays(inst_76349,inst_76350);
var inst_76352 = fluree.db.query.range.time_range.call(null,inst_76208,inst_76348,cljs.core._EQ_,inst_76347,inst_76351);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(51),inst_76352);
} else {
if((state_val_76378 === (43))){
var inst_76295 = (state_76377[(16)]);
var inst_76293 = (state_76377[(17)]);
var inst_76294 = (state_76377[(18)]);
var inst_76317 = (inst_76293 == null);
var inst_76318 = (inst_76294 == null);
var inst_76319 = cljs.core.not.call(null,inst_76318);
var inst_76320 = (inst_76295 == null);
var inst_76321 = cljs.core.not.call(null,inst_76320);
var inst_76322 = ((inst_76317) && (inst_76319) && (inst_76321));
var state_76377__$1 = state_76377;
if(cljs.core.truth_(inst_76322)){
var statearr_76412_76491 = state_76377__$1;
(statearr_76412_76491[(1)] = (45));

} else {
var statearr_76413_76492 = state_76377__$1;
(statearr_76413_76492[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (29))){
var inst_76293 = (state_76377[(17)]);
var inst_76285 = (state_76377[(12)]);
var inst_76285__$1 = (state_76377[(2)]);
var inst_76286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76287 = cljs.core.get.call(null,inst_76285__$1,(0));
var inst_76288 = cljs.core.get.call(null,inst_76285__$1,(1));
var inst_76289 = cljs.core.get.call(null,inst_76285__$1,(2));
var inst_76290 = cljs.core.get.call(null,inst_76285__$1,(3));
var inst_76291 = [inst_76287,inst_76288,inst_76289,inst_76290];
var inst_76292 = (new cljs.core.PersistentVector(null,4,(5),inst_76286,inst_76291,null));
var inst_76293__$1 = cljs.core.nth.call(null,inst_76292,(0),null);
var inst_76294 = cljs.core.nth.call(null,inst_76292,(1),null);
var inst_76295 = cljs.core.nth.call(null,inst_76292,(2),null);
var inst_76296 = cljs.core.nth.call(null,inst_76292,(3),null);
var inst_76297 = (inst_76293__$1 == null);
var inst_76298 = cljs.core.not.call(null,inst_76297);
var state_76377__$1 = (function (){var statearr_76414 = state_76377;
(statearr_76414[(20)] = inst_76296);

(statearr_76414[(16)] = inst_76295);

(statearr_76414[(17)] = inst_76293__$1);

(statearr_76414[(18)] = inst_76294);

(statearr_76414[(12)] = inst_76285__$1);

return statearr_76414;
})();
if(inst_76298){
var statearr_76415_76493 = state_76377__$1;
(statearr_76415_76493[(1)] = (39));

} else {
var statearr_76416_76494 = state_76377__$1;
(statearr_76416_76494[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (44))){
var inst_76344 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76417_76495 = state_76377__$1;
(statearr_76417_76495[(2)] = inst_76344);

(statearr_76417_76495[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (6))){
var state_76377__$1 = state_76377;
var statearr_76418_76496 = state_76377__$1;
(statearr_76418_76496[(2)] = false);

(statearr_76418_76496[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (28))){
var inst_76204 = (state_76377[(8)]);
var inst_76258 = cljs.core.sequential_QMARK_.call(null,inst_76204);
var state_76377__$1 = state_76377;
if(inst_76258){
var statearr_76419_76497 = state_76377__$1;
(statearr_76419_76497[(1)] = (30));

} else {
var statearr_76420_76498 = state_76377__$1;
(statearr_76420_76498[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (51))){
var inst_76208 = (state_76377[(10)]);
var inst_76355 = (state_76377[(21)]);
var inst_76354 = (state_76377[(2)]);
var inst_76355__$1 = fluree.db.util.async.throw_err.call(null,inst_76354);
var inst_76356 = fluree.db.api_js.format_history_resp.call(null,inst_76208,inst_76355__$1);
var state_76377__$1 = (function (){var statearr_76421 = state_76377;
(statearr_76421[(21)] = inst_76355__$1);

return statearr_76421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(52),inst_76356);
} else {
if((state_val_76378 === (25))){
var inst_76204 = (state_76377[(8)]);
var inst_76251 = (state_76377[(2)]);
var inst_76252 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_76204);
var state_76377__$1 = (function (){var statearr_76422 = state_76377;
(statearr_76422[(19)] = inst_76251);

return statearr_76422;
})();
if(inst_76252){
var statearr_76423_76499 = state_76377__$1;
(statearr_76423_76499[(1)] = (27));

} else {
var statearr_76424_76500 = state_76377__$1;
(statearr_76424_76500[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (34))){
var inst_76204 = (state_76377[(8)]);
var state_76377__$1 = state_76377;
var statearr_76425_76501 = state_76377__$1;
(statearr_76425_76501[(2)] = inst_76204);

(statearr_76425_76501[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (17))){
var inst_76217 = (state_76377[(22)]);
var state_76377__$1 = state_76377;
var statearr_76426_76502 = state_76377__$1;
(statearr_76426_76502[(2)] = inst_76217);

(statearr_76426_76502[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (3))){
var state_76377__$1 = state_76377;
var statearr_76427_76503 = state_76377__$1;
(statearr_76427_76503[(2)] = false);

(statearr_76427_76503[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (12))){
var inst_76208 = (state_76377[(10)]);
var inst_76210 = fluree.db.api_js.resolve_block_range.call(null,inst_76208,query_map);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(15),inst_76210);
} else {
if((state_val_76378 === (2))){
var inst_76181 = (state_76377[(9)]);
var inst_76186 = inst_76181.cljs$lang$protocol_mask$partition0$;
var inst_76187 = (inst_76186 & (64));
var inst_76188 = inst_76181.cljs$core$ISeq$;
var inst_76189 = (cljs.core.PROTOCOL_SENTINEL === inst_76188);
var inst_76190 = ((inst_76187) || (inst_76189));
var state_76377__$1 = state_76377;
if(cljs.core.truth_(inst_76190)){
var statearr_76428_76504 = state_76377__$1;
(statearr_76428_76504[(1)] = (5));

} else {
var statearr_76429_76505 = state_76377__$1;
(statearr_76429_76505[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (23))){
var inst_76208 = (state_76377[(10)]);
var inst_76218 = (state_76377[(14)]);
var inst_76243 = fluree.db.time_travel.as_of_block.call(null,inst_76208,inst_76218);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(26),inst_76243);
} else {
if((state_val_76378 === (47))){
var inst_76342 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76430_76506 = state_76377__$1;
(statearr_76430_76506[(2)] = inst_76342);

(statearr_76430_76506[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (35))){
var inst_76270 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76431_76507 = state_76377__$1;
(statearr_76431_76507[(2)] = inst_76270);

(statearr_76431_76507[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (19))){
var inst_76208 = (state_76377[(10)]);
var inst_76217 = (state_76377[(22)]);
var inst_76232 = (inst_76217 - (1));
var inst_76233 = fluree.db.time_travel.as_of_block.call(null,inst_76208,inst_76232);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(22),inst_76233);
} else {
if((state_val_76378 === (57))){
var inst_76367 = (state_76377[(7)]);
var inst_76355 = (state_76377[(21)]);
var inst_76369 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_76370 = cljs.core.count.call(null,inst_76355);
var inst_76371 = [inst_76367,inst_76370,(200)];
var inst_76372 = cljs.core.PersistentHashMap.fromArrays(inst_76369,inst_76371);
var state_76377__$1 = state_76377;
var statearr_76432_76508 = state_76377__$1;
(statearr_76432_76508[(2)] = inst_76372);

(statearr_76432_76508[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (11))){
var inst_76203 = (state_76377[(23)]);
var inst_76207 = (state_76377[(2)]);
var inst_76208 = fluree.db.util.async.throw_err.call(null,inst_76207);
var state_76377__$1 = (function (){var statearr_76433 = state_76377;
(statearr_76433[(10)] = inst_76208);

return statearr_76433;
})();
if(cljs.core.truth_(inst_76203)){
var statearr_76434_76509 = state_76377__$1;
(statearr_76434_76509[(1)] = (12));

} else {
var statearr_76435_76510 = state_76377__$1;
(statearr_76435_76510[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (9))){
var inst_76181 = (state_76377[(9)]);
var state_76377__$1 = state_76377;
var statearr_76436_76511 = state_76377__$1;
(statearr_76436_76511[(2)] = inst_76181);

(statearr_76436_76511[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (5))){
var state_76377__$1 = state_76377;
var statearr_76437_76512 = state_76377__$1;
(statearr_76437_76512[(2)] = true);

(statearr_76437_76512[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (14))){
var inst_76217 = (state_76377[(22)]);
var inst_76216 = (state_76377[(2)]);
var inst_76217__$1 = cljs.core.nth.call(null,inst_76216,(0),null);
var inst_76218 = cljs.core.nth.call(null,inst_76216,(1),null);
var inst_76225 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_76377__$1 = (function (){var statearr_76438 = state_76377;
(statearr_76438[(11)] = inst_76225);

(statearr_76438[(14)] = inst_76218);

(statearr_76438[(22)] = inst_76217__$1);

return statearr_76438;
})();
if(cljs.core.truth_(inst_76217__$1)){
var statearr_76439_76513 = state_76377__$1;
(statearr_76439_76513[(1)] = (16));

} else {
var statearr_76440_76514 = state_76377__$1;
(statearr_76440_76514[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (45))){
var inst_76296 = (state_76377[(20)]);
var inst_76295 = (state_76377[(16)]);
var inst_76293 = (state_76377[(17)]);
var inst_76294 = (state_76377[(18)]);
var inst_76324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76325 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76326 = [inst_76294,inst_76295,inst_76293,inst_76296];
var inst_76327 = (new cljs.core.PersistentVector(null,4,(5),inst_76325,inst_76326,null));
var inst_76328 = [inst_76327,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_76329 = (new cljs.core.PersistentVector(null,2,(5),inst_76324,inst_76328,null));
var state_76377__$1 = state_76377;
var statearr_76441_76515 = state_76377__$1;
(statearr_76441_76515[(2)] = inst_76329);

(statearr_76441_76515[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (53))){
var inst_76359 = (state_76377[(13)]);
var inst_76208 = (state_76377[(10)]);
var inst_76361 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_76208,inst_76359);
var state_76377__$1 = state_76377;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(56),inst_76361);
} else {
if((state_val_76378 === (26))){
var inst_76245 = (state_76377[(2)]);
var inst_76246 = fluree.db.util.async.throw_err.call(null,inst_76245);
var inst_76247 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_76246);
var state_76377__$1 = state_76377;
var statearr_76442_76516 = state_76377__$1;
(statearr_76442_76516[(2)] = inst_76247);

(statearr_76442_76516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (16))){
var inst_76217 = (state_76377[(22)]);
var inst_76227 = cljs.core.not_EQ_.call(null,(1),inst_76217);
var state_76377__$1 = state_76377;
var statearr_76443_76517 = state_76377__$1;
(statearr_76443_76517[(2)] = inst_76227);

(statearr_76443_76517[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (38))){
var inst_76281 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
var statearr_76444_76518 = state_76377__$1;
(statearr_76444_76518[(2)] = inst_76281);

(statearr_76444_76518[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (30))){
var inst_76204 = (state_76377[(8)]);
var inst_76260 = cljs.core.empty_QMARK_.call(null,inst_76204);
var state_76377__$1 = state_76377;
if(inst_76260){
var statearr_76445_76519 = state_76377__$1;
(statearr_76445_76519[(1)] = (33));

} else {
var statearr_76446_76520 = state_76377__$1;
(statearr_76446_76520[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (10))){
var inst_76202 = (state_76377[(2)]);
var inst_76203 = cljs.core.get.call(null,inst_76202,new cljs.core.Keyword(null,"block","block",664686210));
var inst_76204 = cljs.core.get.call(null,inst_76202,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_76205 = cljs.core.get.call(null,inst_76202,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_76377__$1 = (function (){var statearr_76447 = state_76377;
(statearr_76447[(23)] = inst_76203);

(statearr_76447[(8)] = inst_76204);

(statearr_76447[(24)] = inst_76205);

return statearr_76447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76377__$1,(11),sources);
} else {
if((state_val_76378 === (18))){
var inst_76230 = (state_76377[(2)]);
var state_76377__$1 = state_76377;
if(cljs.core.truth_(inst_76230)){
var statearr_76448_76521 = state_76377__$1;
(statearr_76448_76521[(1)] = (19));

} else {
var statearr_76449_76522 = state_76377__$1;
(statearr_76449_76522[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (52))){
var inst_76205 = (state_76377[(24)]);
var inst_76358 = (state_76377[(2)]);
var inst_76359 = fluree.db.util.async.throw_err.call(null,inst_76358);
var state_76377__$1 = (function (){var statearr_76450 = state_76377;
(statearr_76450[(13)] = inst_76359);

return statearr_76450;
})();
if(cljs.core.truth_(inst_76205)){
var statearr_76451_76523 = state_76377__$1;
(statearr_76451_76523[(1)] = (53));

} else {
var statearr_76452_76524 = state_76377__$1;
(statearr_76452_76524[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (42))){
var inst_76296 = (state_76377[(20)]);
var inst_76295 = (state_76377[(16)]);
var inst_76293 = (state_76377[(17)]);
var inst_76294 = (state_76377[(18)]);
var inst_76310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76312 = [inst_76294,inst_76293,inst_76295,inst_76296];
var inst_76313 = (new cljs.core.PersistentVector(null,4,(5),inst_76311,inst_76312,null));
var inst_76314 = [inst_76313,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_76315 = (new cljs.core.PersistentVector(null,2,(5),inst_76310,inst_76314,null));
var state_76377__$1 = state_76377;
var statearr_76453_76525 = state_76377__$1;
(statearr_76453_76525[(2)] = inst_76315);

(statearr_76453_76525[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (37))){
var state_76377__$1 = state_76377;
var statearr_76454_76526 = state_76377__$1;
(statearr_76454_76526[(2)] = null);

(statearr_76454_76526[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (8))){
var inst_76181 = (state_76377[(9)]);
var inst_76199 = cljs.core.apply.call(null,cljs.core.hash_map,inst_76181);
var state_76377__$1 = state_76377;
var statearr_76455_76527 = state_76377__$1;
(statearr_76455_76527[(2)] = inst_76199);

(statearr_76455_76527[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76378 === (49))){
var state_76377__$1 = state_76377;
var statearr_76456_76528 = state_76377__$1;
(statearr_76456_76528[(2)] = null);

(statearr_76456_76528[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_76457 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76457[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_76457[(1)] = (1));

return statearr_76457;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_76377){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_76377);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e76458){var ex__11472__auto__ = e76458;
var statearr_76459_76529 = state_76377;
(statearr_76459_76529[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_76377[(4)]))){
var statearr_76460_76530 = state_76377;
(statearr_76460_76530[(1)] = cljs.core.first.call(null,(state_76377[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76531 = state_76377;
state_76377 = G__76531;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_76377){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_76377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_76461 = f__11543__auto__.call(null);
(statearr_76461[(6)] = c__11542__auto__);

return statearr_76461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__76539 = arguments.length;
switch (G__76539) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__76532_SHARP_){
return cljs.core.dissoc.call(null,p1__76532_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_76628){
var state_val_76629 = (state_76628[(1)]);
if((state_val_76629 === (7))){
var inst_76582 = (state_76628[(7)]);
var inst_76585 = (state_76628[(8)]);
var inst_76589 = (state_76628[(9)]);
var inst_76579 = (state_76628[(10)]);
var inst_76595 = (function (){var responses = inst_76579;
var responses_STAR_ = inst_76582;
var statuses = inst_76585;
var fuel = inst_76589;
return (function (p1__76535_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__76535_SHARP_);
});
})();
var inst_76596 = cljs.core.some.call(null,inst_76595,inst_76585);
var state_76628__$1 = state_76628;
if(cljs.core.truth_(inst_76596)){
var statearr_76630_76678 = state_76628__$1;
(statearr_76630_76678[(1)] = (9));

} else {
var statearr_76631_76679 = state_76628__$1;
(statearr_76631_76679[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (20))){
var inst_76623 = (state_76628[(2)]);
var state_76628__$1 = state_76628;
var statearr_76632_76680 = state_76628__$1;
(statearr_76632_76680[(2)] = inst_76623);

(statearr_76632_76680[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (1))){
var inst_76574 = cljs.core.async.chan.call(null,(1));
var inst_76575 = (function (){var c__11542__auto____$1 = inst_76574;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_76572){
var state_val_76573 = (state_76572[(1)]);
if((state_val_76573 === (1))){
var inst_76540 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_76541 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_76542 = cljs.core.assoc.call(null,inst_76541,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_76543 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_76544 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_76545 = cljs.core.PersistentHashMap.EMPTY;
var inst_76546 = inst_76540;
var inst_76547 = inst_76542;
var inst_76548 = inst_76543;
var inst_76549 = inst_76544;
var inst_76550 = inst_76545;
var state_76572__$1 = (function (){var statearr_76633 = state_76572;
(statearr_76633[(7)] = inst_76547);

(statearr_76633[(8)] = inst_76546);

(statearr_76633[(9)] = inst_76550);

(statearr_76633[(10)] = inst_76548);

(statearr_76633[(11)] = inst_76549);

return statearr_76633;
})();
var statearr_76634_76681 = state_76572__$1;
(statearr_76634_76681[(2)] = null);

(statearr_76634_76681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76573 === (2))){
var inst_76547 = (state_76572[(7)]);
var inst_76552 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_76547);
var inst_76553 = cljs.core.merge.call(null,opts,inst_76552);
var inst_76554 = cljs.core.assoc.call(null,inst_76547,new cljs.core.Keyword(null,"opts","opts",155075701),inst_76553);
var inst_76555 = fluree.db.api_js.query_async.call(null,db,inst_76554,db_fn);
var state_76572__$1 = state_76572;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76572__$1,(4),inst_76555);
} else {
if((state_val_76573 === (3))){
var inst_76570 = (state_76572[(2)]);
var state_76572__$1 = state_76572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76572__$1,inst_76570);
} else {
if((state_val_76573 === (4))){
var inst_76546 = (state_76572[(8)]);
var inst_76550 = (state_76572[(9)]);
var inst_76548 = (state_76572[(10)]);
var inst_76557 = (state_76572[(2)]);
var inst_76558 = cljs.core.assoc.call(null,inst_76550,inst_76546,inst_76557);
var inst_76559 = cljs.core.first.call(null,inst_76548);
var state_76572__$1 = (function (){var statearr_76635 = state_76572;
(statearr_76635[(12)] = inst_76558);

return statearr_76635;
})();
if(cljs.core.truth_(inst_76559)){
var statearr_76636_76682 = state_76572__$1;
(statearr_76636_76682[(1)] = (5));

} else {
var statearr_76637_76683 = state_76572__$1;
(statearr_76637_76683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76573 === (5))){
var inst_76548 = (state_76572[(10)]);
var inst_76549 = (state_76572[(11)]);
var inst_76558 = (state_76572[(12)]);
var inst_76561 = cljs.core.first.call(null,inst_76548);
var inst_76562 = cljs.core.first.call(null,inst_76549);
var inst_76563 = cljs.core.rest.call(null,inst_76548);
var inst_76564 = cljs.core.rest.call(null,inst_76549);
var inst_76546 = inst_76561;
var inst_76547 = inst_76562;
var inst_76548__$1 = inst_76563;
var inst_76549__$1 = inst_76564;
var inst_76550 = inst_76558;
var state_76572__$1 = (function (){var statearr_76638 = state_76572;
(statearr_76638[(7)] = inst_76547);

(statearr_76638[(8)] = inst_76546);

(statearr_76638[(9)] = inst_76550);

(statearr_76638[(10)] = inst_76548__$1);

(statearr_76638[(11)] = inst_76549__$1);

return statearr_76638;
})();
var statearr_76639_76684 = state_76572__$1;
(statearr_76639_76684[(2)] = null);

(statearr_76639_76684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76573 === (6))){
var inst_76558 = (state_76572[(12)]);
var state_76572__$1 = state_76572;
var statearr_76640_76685 = state_76572__$1;
(statearr_76640_76685[(2)] = inst_76558);

(statearr_76640_76685[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76573 === (7))){
var inst_76568 = (state_76572[(2)]);
var state_76572__$1 = state_76572;
var statearr_76641_76686 = state_76572__$1;
(statearr_76641_76686[(2)] = inst_76568);

(statearr_76641_76686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_76642 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76642[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_76642[(1)] = (1));

return statearr_76642;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_76572){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_76572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e76643){var ex__11472__auto__ = e76643;
var statearr_76644_76687 = state_76572;
(statearr_76644_76687[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_76572[(4)]))){
var statearr_76645_76688 = state_76572;
(statearr_76645_76688[(1)] = cljs.core.first.call(null,(state_76572[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76689 = state_76572;
state_76572 = G__76689;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_76572){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_76572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_76646 = f__11543__auto__.call(null);
(statearr_76646[(6)] = c__11542__auto____$1);

return statearr_76646;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_76576 = cljs.core.async.impl.dispatch.run.call(null,inst_76575);
var state_76628__$1 = (function (){var statearr_76647 = state_76628;
(statearr_76647[(11)] = inst_76576);

return statearr_76647;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76628__$1,(2),inst_76574);
} else {
if((state_val_76629 === (4))){
var inst_76579 = (state_76628[(10)]);
var state_76628__$1 = state_76628;
var statearr_76648_76690 = state_76628__$1;
(statearr_76648_76690[(2)] = inst_76579);

(statearr_76648_76690[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (15))){
var state_76628__$1 = state_76628;
var statearr_76649_76691 = state_76628__$1;
(statearr_76649_76691[(2)] = (400));

(statearr_76649_76691[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (13))){
var state_76628__$1 = state_76628;
var statearr_76650_76692 = state_76628__$1;
(statearr_76650_76692[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (6))){
var inst_76585 = (state_76628[(8)]);
var inst_76593 = cljs.core.first.call(null,inst_76585);
var state_76628__$1 = state_76628;
var statearr_76652_76693 = state_76628__$1;
(statearr_76652_76693[(2)] = inst_76593);

(statearr_76652_76693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (17))){
var inst_76606 = (state_76628[(2)]);
var state_76628__$1 = state_76628;
var statearr_76653_76694 = state_76628__$1;
(statearr_76653_76694[(2)] = inst_76606);

(statearr_76653_76694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (3))){
var inst_76582 = (state_76628[(7)]);
var inst_76585 = (state_76628[(8)]);
var inst_76589 = (state_76628[(9)]);
var inst_76579 = (state_76628[(10)]);
var inst_76584 = cljs.core.vals.call(null,inst_76579);
var inst_76585__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76584);
var inst_76586 = (function (){var responses = inst_76579;
var responses_STAR_ = inst_76582;
var statuses = inst_76585__$1;
return (function (p1__76533_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__76533_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_76587 = cljs.core.vals.call(null,inst_76579);
var inst_76588 = cljs.core.map.call(null,inst_76586,inst_76587);
var inst_76589__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_76588);
var inst_76590 = (function (){var responses = inst_76579;
var responses_STAR_ = inst_76582;
var statuses = inst_76585__$1;
var fuel = inst_76589__$1;
return (function (p1__76534_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__76534_SHARP_);
});
})();
var inst_76591 = cljs.core.every_QMARK_.call(null,inst_76590,inst_76585__$1);
var state_76628__$1 = (function (){var statearr_76654 = state_76628;
(statearr_76654[(8)] = inst_76585__$1);

(statearr_76654[(9)] = inst_76589__$1);

return statearr_76654;
})();
if(inst_76591){
var statearr_76655_76695 = state_76628__$1;
(statearr_76655_76695[(1)] = (6));

} else {
var statearr_76656_76696 = state_76628__$1;
(statearr_76656_76696[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (12))){
var state_76628__$1 = state_76628;
var statearr_76657_76697 = state_76628__$1;
(statearr_76657_76697[(2)] = (500));

(statearr_76657_76697[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (2))){
var inst_76579 = (state_76628[(10)]);
var inst_76578 = (state_76628[(2)]);
var inst_76579__$1 = fluree.db.util.async.throw_err.call(null,inst_76578);
var inst_76580 = (function (){var responses = inst_76579__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_76581 = cljs.core.PersistentHashMap.EMPTY;
var inst_76582 = cljs.core.reduce_kv.call(null,inst_76580,inst_76581,inst_76579__$1);
var state_76628__$1 = (function (){var statearr_76658 = state_76628;
(statearr_76658[(7)] = inst_76582);

(statearr_76658[(10)] = inst_76579__$1);

return statearr_76658;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_76659_76698 = state_76628__$1;
(statearr_76659_76698[(1)] = (3));

} else {
var statearr_76660_76699 = state_76628__$1;
(statearr_76660_76699[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (19))){
var inst_76582 = (state_76628[(7)]);
var inst_76589 = (state_76628[(9)]);
var inst_76612 = (state_76628[(12)]);
var inst_76621 = cljs.core.assoc.call(null,inst_76582,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76612,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76589);
var state_76628__$1 = state_76628;
var statearr_76661_76700 = state_76628__$1;
(statearr_76661_76700[(2)] = inst_76621);

(statearr_76661_76700[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (11))){
var inst_76610 = (state_76628[(2)]);
var state_76628__$1 = state_76628;
var statearr_76662_76701 = state_76628__$1;
(statearr_76662_76701[(2)] = inst_76610);

(statearr_76662_76701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (9))){
var state_76628__$1 = state_76628;
var statearr_76663_76702 = state_76628__$1;
(statearr_76663_76702[(2)] = (207));

(statearr_76663_76702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (5))){
var inst_76626 = (state_76628[(2)]);
var state_76628__$1 = state_76628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76628__$1,inst_76626);
} else {
if((state_val_76629 === (14))){
var inst_76608 = (state_76628[(2)]);
var state_76628__$1 = state_76628;
var statearr_76664_76703 = state_76628__$1;
(statearr_76664_76703[(2)] = inst_76608);

(statearr_76664_76703[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (16))){
var state_76628__$1 = state_76628;
var statearr_76665_76704 = state_76628__$1;
(statearr_76665_76704[(2)] = null);

(statearr_76665_76704[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (10))){
var inst_76582 = (state_76628[(7)]);
var inst_76585 = (state_76628[(8)]);
var inst_76589 = (state_76628[(9)]);
var inst_76579 = (state_76628[(10)]);
var inst_76599 = (function (){var responses = inst_76579;
var responses_STAR_ = inst_76582;
var statuses = inst_76585;
var fuel = inst_76589;
return (function (p1__76536_SHARP_){
return ((499) < p1__76536_SHARP_);
});
})();
var inst_76600 = cljs.core.some.call(null,inst_76599,inst_76585);
var state_76628__$1 = state_76628;
if(cljs.core.truth_(inst_76600)){
var statearr_76666_76705 = state_76628__$1;
(statearr_76666_76705[(1)] = (12));

} else {
var statearr_76667_76706 = state_76628__$1;
(statearr_76667_76706[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (18))){
var inst_76582 = (state_76628[(7)]);
var inst_76589 = (state_76628[(9)]);
var inst_76617 = (state_76628[(13)]);
var inst_76612 = (state_76628[(12)]);
var inst_76619 = cljs.core.assoc.call(null,inst_76582,new cljs.core.Keyword(null,"status","status",-1997798413),inst_76612,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_76589,new cljs.core.Keyword(null,"block","block",664686210),inst_76617);
var state_76628__$1 = state_76628;
var statearr_76668_76707 = state_76628__$1;
(statearr_76668_76707[(2)] = inst_76619);

(statearr_76668_76707[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76629 === (8))){
var inst_76582 = (state_76628[(7)]);
var inst_76585 = (state_76628[(8)]);
var inst_76589 = (state_76628[(9)]);
var inst_76579 = (state_76628[(10)]);
var inst_76617 = (state_76628[(13)]);
var inst_76612 = (state_76628[(12)]);
var inst_76612__$1 = (state_76628[(2)]);
var inst_76613 = (function (){var responses = inst_76579;
var responses_STAR_ = inst_76582;
var statuses = inst_76585;
var fuel = inst_76589;
var status = inst_76612__$1;
return (function (p1__76537_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__76537_SHARP_));
});
})();
var inst_76614 = cljs.core.vals.call(null,inst_76579);
var inst_76615 = cljs.core.filter.call(null,inst_76613,inst_76614);
var inst_76616 = cljs.core.first.call(null,inst_76615);
var inst_76617__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_76616);
var state_76628__$1 = (function (){var statearr_76669 = state_76628;
(statearr_76669[(13)] = inst_76617__$1);

(statearr_76669[(12)] = inst_76612__$1);

return statearr_76669;
})();
if(cljs.core.truth_(inst_76617__$1)){
var statearr_76670_76708 = state_76628__$1;
(statearr_76670_76708[(1)] = (18));

} else {
var statearr_76671_76709 = state_76628__$1;
(statearr_76671_76709[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_76672 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_76672[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_76672[(1)] = (1));

return statearr_76672;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_76628){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_76628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e76673){var ex__11472__auto__ = e76673;
var statearr_76674_76710 = state_76628;
(statearr_76674_76710[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_76628[(4)]))){
var statearr_76675_76711 = state_76628;
(statearr_76675_76711[(1)] = cljs.core.first.call(null,(state_76628[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76712 = state_76628;
state_76628 = G__76712;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_76628){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_76628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_76676 = f__11543__auto__.call(null);
(statearr_76676[(6)] = c__11542__auto__);

return statearr_76676;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__76714 = arguments.length;
switch (G__76714) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__76715 = opts;
var map__76715__$1 = (((((!((map__76715 == null))))?(((((map__76715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__76715.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__76715):map__76715);
var auth = cljs.core.get.call(null,map__76715__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__76715__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__76715__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__76715__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__76716 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__76716,(0),null);
var authority = cljs.core.nth.call(null,vec__76716,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e76720){var e = e76720;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__76723 = arguments.length;
switch (G__76723) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_76754){
var state_val_76755 = (state_76754[(1)]);
if((state_val_76755 === (7))){
var state_76754__$1 = state_76754;
var statearr_76756_76777 = state_76754__$1;
(statearr_76756_76777[(2)] = opts);

(statearr_76756_76777[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (1))){
var state_76754__$1 = state_76754;
var statearr_76757_76778 = state_76754__$1;
(statearr_76757_76778[(2)] = null);

(statearr_76757_76778[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (4))){
var inst_76724 = (state_76754[(2)]);
var inst_76725 = fluree.db.util.log.error.call(null,inst_76724);
var inst_76726 = cljs.core.ex_data.call(null,inst_76724);
var inst_76727 = cljs.core.ex_message.call(null,inst_76724);
var inst_76728 = cljs.core.assoc.call(null,inst_76726,new cljs.core.Keyword(null,"message","message",-406056002),inst_76727);
var state_76754__$1 = (function (){var statearr_76758 = state_76754;
(statearr_76758[(7)] = inst_76725);

return statearr_76758;
})();
var statearr_76759_76779 = state_76754__$1;
(statearr_76759_76779[(2)] = inst_76728);

(statearr_76759_76779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (6))){
var inst_76738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76739 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_76740 = (new cljs.core.PersistentVector(null,1,(5),inst_76738,inst_76739,null));
var inst_76741 = cljs.core.assoc_in.call(null,opts,inst_76740,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_76754__$1 = state_76754;
var statearr_76760_76780 = state_76754__$1;
(statearr_76760_76780[(2)] = inst_76741);

(statearr_76760_76780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (3))){
var inst_76752 = (state_76754[(2)]);
var state_76754__$1 = state_76754;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76754__$1,inst_76752);
} else {
if((state_val_76755 === (2))){
var _ = (function (){var statearr_76762 = state_76754;
(statearr_76762[(4)] = cljs.core.cons.call(null,(5),(state_76754[(4)])));

return statearr_76762;
})();
var inst_76734 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76735 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_76736 = (inst_76735 == null);
var state_76754__$1 = (function (){var statearr_76763 = state_76754;
(statearr_76763[(8)] = inst_76734);

return statearr_76763;
})();
if(cljs.core.truth_(inst_76736)){
var statearr_76764_76781 = state_76754__$1;
(statearr_76764_76781[(1)] = (6));

} else {
var statearr_76765_76782 = state_76754__$1;
(statearr_76765_76782[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (9))){
var inst_76748 = (state_76754[(2)]);
var inst_76749 = fluree.db.util.async.throw_err.call(null,inst_76748);
var _ = (function (){var statearr_76766 = state_76754;
(statearr_76766[(4)] = cljs.core.rest.call(null,(state_76754[(4)])));

return statearr_76766;
})();
var state_76754__$1 = state_76754;
var statearr_76767_76783 = state_76754__$1;
(statearr_76767_76783[(2)] = inst_76749);

(statearr_76767_76783[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (5))){
var _ = (function (){var statearr_76768 = state_76754;
(statearr_76768[(4)] = cljs.core.rest.call(null,(state_76754[(4)])));

return statearr_76768;
})();
var state_76754__$1 = state_76754;
var ex76761 = (state_76754__$1[(2)]);
var statearr_76769_76784 = state_76754__$1;
(statearr_76769_76784[(5)] = ex76761);


var statearr_76770_76785 = state_76754__$1;
(statearr_76770_76785[(1)] = (4));

(statearr_76770_76785[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76755 === (8))){
var inst_76734 = (state_76754[(8)]);
var inst_76744 = (state_76754[(2)]);
var inst_76745 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_76734,inst_76744);
var inst_76746 = fluree.db.operations.command_async.call(null,conn,inst_76745);
var state_76754__$1 = state_76754;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76754__$1,(9),inst_76746);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__11469__auto__ = null;
var fluree$db$api_js$state_machine__11469__auto____0 = (function (){
var statearr_76771 = [null,null,null,null,null,null,null,null,null];
(statearr_76771[(0)] = fluree$db$api_js$state_machine__11469__auto__);

(statearr_76771[(1)] = (1));

return statearr_76771;
});
var fluree$db$api_js$state_machine__11469__auto____1 = (function (state_76754){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_76754);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e76772){var ex__11472__auto__ = e76772;
var statearr_76773_76786 = state_76754;
(statearr_76773_76786[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_76754[(4)]))){
var statearr_76774_76787 = state_76754;
(statearr_76774_76787[(1)] = cljs.core.first.call(null,(state_76754[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__76788 = state_76754;
state_76754 = G__76788;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__11469__auto__ = function(state_76754){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__11469__auto____1.call(this,state_76754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__11469__auto____0;
fluree$db$api_js$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__11469__auto____1;
return fluree$db$api_js$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_76775 = f__11543__auto__.call(null);
(statearr_76775[(6)] = c__11542__auto__);

return statearr_76775;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

