// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__11602 = arguments.length;
switch (G__11602) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11603 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11603 = (function (f,blockable,meta11604){
this.f = f;
this.blockable = blockable;
this.meta11604 = meta11604;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11605,meta11604__$1){
var self__ = this;
var _11605__$1 = this;
return (new cljs.core.async.t_cljs$core$async11603(self__.f,self__.blockable,meta11604__$1));
}));

(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11605){
var self__ = this;
var _11605__$1 = this;
return self__.meta11604;
}));

(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async11603.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async11603.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11604","meta11604",1292746042,null)], null);
}));

(cljs.core.async.t_cljs$core$async11603.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11603.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11603");

(cljs.core.async.t_cljs$core$async11603.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async11603");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11603.
 */
cljs.core.async.__GT_t_cljs$core$async11603 = (function cljs$core$async$__GT_t_cljs$core$async11603(f__$1,blockable__$1,meta11604){
return (new cljs.core.async.t_cljs$core$async11603(f__$1,blockable__$1,meta11604));
});

}

return (new cljs.core.async.t_cljs$core$async11603(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__11609 = arguments.length;
switch (G__11609) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__11612 = arguments.length;
switch (G__11612) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__11615 = arguments.length;
switch (G__11615) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11617 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11617);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_11617);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__11619 = arguments.length;
switch (G__11619) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___11621 = n;
var x_11622 = (0);
while(true){
if((x_11622 < n__4613__auto___11621)){
(a[x_11622] = x_11622);

var G__11623 = (x_11622 + (1));
x_11622 = G__11623;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11624 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11624 = (function (flag,meta11625){
this.flag = flag;
this.meta11625 = meta11625;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11626,meta11625__$1){
var self__ = this;
var _11626__$1 = this;
return (new cljs.core.async.t_cljs$core$async11624(self__.flag,meta11625__$1));
}));

(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11626){
var self__ = this;
var _11626__$1 = this;
return self__.meta11625;
}));

(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11624.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async11624.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11625","meta11625",-921011741,null)], null);
}));

(cljs.core.async.t_cljs$core$async11624.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11624.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11624");

(cljs.core.async.t_cljs$core$async11624.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async11624");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11624.
 */
cljs.core.async.__GT_t_cljs$core$async11624 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11624(flag__$1,meta11625){
return (new cljs.core.async.t_cljs$core$async11624(flag__$1,meta11625));
});

}

return (new cljs.core.async.t_cljs$core$async11624(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async11627 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11627 = (function (flag,cb,meta11628){
this.flag = flag;
this.cb = cb;
this.meta11628 = meta11628;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11629,meta11628__$1){
var self__ = this;
var _11629__$1 = this;
return (new cljs.core.async.t_cljs$core$async11627(self__.flag,self__.cb,meta11628__$1));
}));

(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11629){
var self__ = this;
var _11629__$1 = this;
return self__.meta11628;
}));

(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async11627.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async11627.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11628","meta11628",-1905251884,null)], null);
}));

(cljs.core.async.t_cljs$core$async11627.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async11627.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11627");

(cljs.core.async.t_cljs$core$async11627.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async11627");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async11627.
 */
cljs.core.async.__GT_t_cljs$core$async11627 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11627(flag__$1,cb__$1,meta11628){
return (new cljs.core.async.t_cljs$core$async11627(flag__$1,cb__$1,meta11628));
});

}

return (new cljs.core.async.t_cljs$core$async11627(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11630_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11630_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11631_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11631_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11632 = (i + (1));
i = G__11632;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___11638 = arguments.length;
var i__4737__auto___11639 = (0);
while(true){
if((i__4737__auto___11639 < len__4736__auto___11638)){
args__4742__auto__.push((arguments[i__4737__auto___11639]));

var G__11640 = (i__4737__auto___11639 + (1));
i__4737__auto___11639 = G__11640;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11635){
var map__11636 = p__11635;
var map__11636__$1 = (((((!((map__11636 == null))))?(((((map__11636.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11636.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11636):map__11636);
var opts = map__11636__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11633){
var G__11634 = cljs.core.first.call(null,seq11633);
var seq11633__$1 = cljs.core.next.call(null,seq11633);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11634,seq11633__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__11642 = arguments.length;
switch (G__11642) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11542__auto___11689 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_11666){
var state_val_11667 = (state_11666[(1)]);
if((state_val_11667 === (7))){
var inst_11662 = (state_11666[(2)]);
var state_11666__$1 = state_11666;
var statearr_11668_11690 = state_11666__$1;
(statearr_11668_11690[(2)] = inst_11662);

(statearr_11668_11690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (1))){
var state_11666__$1 = state_11666;
var statearr_11669_11691 = state_11666__$1;
(statearr_11669_11691[(2)] = null);

(statearr_11669_11691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (4))){
var inst_11645 = (state_11666[(7)]);
var inst_11645__$1 = (state_11666[(2)]);
var inst_11646 = (inst_11645__$1 == null);
var state_11666__$1 = (function (){var statearr_11670 = state_11666;
(statearr_11670[(7)] = inst_11645__$1);

return statearr_11670;
})();
if(cljs.core.truth_(inst_11646)){
var statearr_11671_11692 = state_11666__$1;
(statearr_11671_11692[(1)] = (5));

} else {
var statearr_11672_11693 = state_11666__$1;
(statearr_11672_11693[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (13))){
var state_11666__$1 = state_11666;
var statearr_11673_11694 = state_11666__$1;
(statearr_11673_11694[(2)] = null);

(statearr_11673_11694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (6))){
var inst_11645 = (state_11666[(7)]);
var state_11666__$1 = state_11666;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11666__$1,(11),to,inst_11645);
} else {
if((state_val_11667 === (3))){
var inst_11664 = (state_11666[(2)]);
var state_11666__$1 = state_11666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11666__$1,inst_11664);
} else {
if((state_val_11667 === (12))){
var state_11666__$1 = state_11666;
var statearr_11674_11695 = state_11666__$1;
(statearr_11674_11695[(2)] = null);

(statearr_11674_11695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (2))){
var state_11666__$1 = state_11666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11666__$1,(4),from);
} else {
if((state_val_11667 === (11))){
var inst_11655 = (state_11666[(2)]);
var state_11666__$1 = state_11666;
if(cljs.core.truth_(inst_11655)){
var statearr_11675_11696 = state_11666__$1;
(statearr_11675_11696[(1)] = (12));

} else {
var statearr_11676_11697 = state_11666__$1;
(statearr_11676_11697[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (9))){
var state_11666__$1 = state_11666;
var statearr_11677_11698 = state_11666__$1;
(statearr_11677_11698[(2)] = null);

(statearr_11677_11698[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (5))){
var state_11666__$1 = state_11666;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11678_11699 = state_11666__$1;
(statearr_11678_11699[(1)] = (8));

} else {
var statearr_11679_11700 = state_11666__$1;
(statearr_11679_11700[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (14))){
var inst_11660 = (state_11666[(2)]);
var state_11666__$1 = state_11666;
var statearr_11680_11701 = state_11666__$1;
(statearr_11680_11701[(2)] = inst_11660);

(statearr_11680_11701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (10))){
var inst_11652 = (state_11666[(2)]);
var state_11666__$1 = state_11666;
var statearr_11681_11702 = state_11666__$1;
(statearr_11681_11702[(2)] = inst_11652);

(statearr_11681_11702[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11667 === (8))){
var inst_11649 = cljs.core.async.close_BANG_.call(null,to);
var state_11666__$1 = state_11666;
var statearr_11682_11703 = state_11666__$1;
(statearr_11682_11703[(2)] = inst_11649);

(statearr_11682_11703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_11683 = [null,null,null,null,null,null,null,null];
(statearr_11683[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_11683[(1)] = (1));

return statearr_11683;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_11666){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11684){var ex__11472__auto__ = e11684;
var statearr_11685_11704 = state_11666;
(statearr_11685_11704[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11666[(4)]))){
var statearr_11686_11705 = state_11666;
(statearr_11686_11705[(1)] = cljs.core.first.call(null,(state_11666[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11706 = state_11666;
state_11666 = G__11706;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_11666){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_11666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_11687 = f__11543__auto__.call(null);
(statearr_11687[(6)] = c__11542__auto___11689);

return statearr_11687;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = (function (p__11707){
var vec__11708 = p__11707;
var v = cljs.core.nth.call(null,vec__11708,(0),null);
var p = cljs.core.nth.call(null,vec__11708,(1),null);
var job = vec__11708;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11542__auto___11884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_11715){
var state_val_11716 = (state_11715[(1)]);
if((state_val_11716 === (1))){
var state_11715__$1 = state_11715;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11715__$1,(2),res,v);
} else {
if((state_val_11716 === (2))){
var inst_11712 = (state_11715[(2)]);
var inst_11713 = cljs.core.async.close_BANG_.call(null,res);
var state_11715__$1 = (function (){var statearr_11717 = state_11715;
(statearr_11717[(7)] = inst_11712);

return statearr_11717;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11715__$1,inst_11713);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_11718 = [null,null,null,null,null,null,null,null];
(statearr_11718[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__);

(statearr_11718[(1)] = (1));

return statearr_11718;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1 = (function (state_11715){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11715);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11719){var ex__11472__auto__ = e11719;
var statearr_11720_11885 = state_11715;
(statearr_11720_11885[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11715[(4)]))){
var statearr_11721_11886 = state_11715;
(statearr_11721_11886[(1)] = cljs.core.first.call(null,(state_11715[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11887 = state_11715;
state_11715 = G__11887;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = function(state_11715){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1.call(this,state_11715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_11722 = f__11543__auto__.call(null);
(statearr_11722[(6)] = c__11542__auto___11884);

return statearr_11722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__11723){
var vec__11724 = p__11723;
var v = cljs.core.nth.call(null,vec__11724,(0),null);
var p = cljs.core.nth.call(null,vec__11724,(1),null);
var job = vec__11724;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__4613__auto___11888 = n;
var __11889 = (0);
while(true){
if((__11889 < n__4613__auto___11888)){
var G__11727_11890 = type;
var G__11727_11891__$1 = (((G__11727_11890 instanceof cljs.core.Keyword))?G__11727_11890.fqn:null);
switch (G__11727_11891__$1) {
case "compute":
var c__11542__auto___11893 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11889,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = ((function (__11889,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function (state_11740){
var state_val_11741 = (state_11740[(1)]);
if((state_val_11741 === (1))){
var state_11740__$1 = state_11740;
var statearr_11742_11894 = state_11740__$1;
(statearr_11742_11894[(2)] = null);

(statearr_11742_11894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11741 === (2))){
var state_11740__$1 = state_11740;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11740__$1,(4),jobs);
} else {
if((state_val_11741 === (3))){
var inst_11738 = (state_11740[(2)]);
var state_11740__$1 = state_11740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11740__$1,inst_11738);
} else {
if((state_val_11741 === (4))){
var inst_11730 = (state_11740[(2)]);
var inst_11731 = process.call(null,inst_11730);
var state_11740__$1 = state_11740;
if(cljs.core.truth_(inst_11731)){
var statearr_11743_11895 = state_11740__$1;
(statearr_11743_11895[(1)] = (5));

} else {
var statearr_11744_11896 = state_11740__$1;
(statearr_11744_11896[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11741 === (5))){
var state_11740__$1 = state_11740;
var statearr_11745_11897 = state_11740__$1;
(statearr_11745_11897[(2)] = null);

(statearr_11745_11897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11741 === (6))){
var state_11740__$1 = state_11740;
var statearr_11746_11898 = state_11740__$1;
(statearr_11746_11898[(2)] = null);

(statearr_11746_11898[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11741 === (7))){
var inst_11736 = (state_11740[(2)]);
var state_11740__$1 = state_11740;
var statearr_11747_11899 = state_11740__$1;
(statearr_11747_11899[(2)] = inst_11736);

(statearr_11747_11899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11889,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
;
return ((function (__11889,switch__11468__auto__,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_11748 = [null,null,null,null,null,null,null];
(statearr_11748[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__);

(statearr_11748[(1)] = (1));

return statearr_11748;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1 = (function (state_11740){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11749){var ex__11472__auto__ = e11749;
var statearr_11750_11900 = state_11740;
(statearr_11750_11900[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11740[(4)]))){
var statearr_11751_11901 = state_11740;
(statearr_11751_11901[(1)] = cljs.core.first.call(null,(state_11740[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11902 = state_11740;
state_11740 = G__11902;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = function(state_11740){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1.call(this,state_11740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__;
})()
;})(__11889,switch__11468__auto__,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
})();
var state__11544__auto__ = (function (){var statearr_11752 = f__11543__auto__.call(null);
(statearr_11752[(6)] = c__11542__auto___11893);

return statearr_11752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});})(__11889,c__11542__auto___11893,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
);


break;
case "async":
var c__11542__auto___11903 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__11889,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = ((function (__11889,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function (state_11765){
var state_val_11766 = (state_11765[(1)]);
if((state_val_11766 === (1))){
var state_11765__$1 = state_11765;
var statearr_11767_11904 = state_11765__$1;
(statearr_11767_11904[(2)] = null);

(statearr_11767_11904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11766 === (2))){
var state_11765__$1 = state_11765;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11765__$1,(4),jobs);
} else {
if((state_val_11766 === (3))){
var inst_11763 = (state_11765[(2)]);
var state_11765__$1 = state_11765;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11765__$1,inst_11763);
} else {
if((state_val_11766 === (4))){
var inst_11755 = (state_11765[(2)]);
var inst_11756 = async.call(null,inst_11755);
var state_11765__$1 = state_11765;
if(cljs.core.truth_(inst_11756)){
var statearr_11768_11905 = state_11765__$1;
(statearr_11768_11905[(1)] = (5));

} else {
var statearr_11769_11906 = state_11765__$1;
(statearr_11769_11906[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11766 === (5))){
var state_11765__$1 = state_11765;
var statearr_11770_11907 = state_11765__$1;
(statearr_11770_11907[(2)] = null);

(statearr_11770_11907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11766 === (6))){
var state_11765__$1 = state_11765;
var statearr_11771_11908 = state_11765__$1;
(statearr_11771_11908[(2)] = null);

(statearr_11771_11908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11766 === (7))){
var inst_11761 = (state_11765[(2)]);
var state_11765__$1 = state_11765;
var statearr_11772_11909 = state_11765__$1;
(statearr_11772_11909[(2)] = inst_11761);

(statearr_11772_11909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__11889,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
;
return ((function (__11889,switch__11468__auto__,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_11773 = [null,null,null,null,null,null,null];
(statearr_11773[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__);

(statearr_11773[(1)] = (1));

return statearr_11773;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1 = (function (state_11765){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11765);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11774){var ex__11472__auto__ = e11774;
var statearr_11775_11910 = state_11765;
(statearr_11775_11910[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11765[(4)]))){
var statearr_11776_11911 = state_11765;
(statearr_11776_11911[(1)] = cljs.core.first.call(null,(state_11765[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11912 = state_11765;
state_11765 = G__11912;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = function(state_11765){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1.call(this,state_11765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__;
})()
;})(__11889,switch__11468__auto__,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
})();
var state__11544__auto__ = (function (){var statearr_11777 = f__11543__auto__.call(null);
(statearr_11777[(6)] = c__11542__auto___11903);

return statearr_11777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});})(__11889,c__11542__auto___11903,G__11727_11890,G__11727_11891__$1,n__4613__auto___11888,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__11727_11891__$1)].join('')));

}

var G__11913 = (__11889 + (1));
__11889 = G__11913;
continue;
} else {
}
break;
}

var c__11542__auto___11914 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_11799){
var state_val_11800 = (state_11799[(1)]);
if((state_val_11800 === (7))){
var inst_11795 = (state_11799[(2)]);
var state_11799__$1 = state_11799;
var statearr_11801_11915 = state_11799__$1;
(statearr_11801_11915[(2)] = inst_11795);

(statearr_11801_11915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11800 === (1))){
var state_11799__$1 = state_11799;
var statearr_11802_11916 = state_11799__$1;
(statearr_11802_11916[(2)] = null);

(statearr_11802_11916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11800 === (4))){
var inst_11780 = (state_11799[(7)]);
var inst_11780__$1 = (state_11799[(2)]);
var inst_11781 = (inst_11780__$1 == null);
var state_11799__$1 = (function (){var statearr_11803 = state_11799;
(statearr_11803[(7)] = inst_11780__$1);

return statearr_11803;
})();
if(cljs.core.truth_(inst_11781)){
var statearr_11804_11917 = state_11799__$1;
(statearr_11804_11917[(1)] = (5));

} else {
var statearr_11805_11918 = state_11799__$1;
(statearr_11805_11918[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11800 === (6))){
var inst_11785 = (state_11799[(8)]);
var inst_11780 = (state_11799[(7)]);
var inst_11785__$1 = cljs.core.async.chan.call(null,(1));
var inst_11786 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_11787 = [inst_11780,inst_11785__$1];
var inst_11788 = (new cljs.core.PersistentVector(null,2,(5),inst_11786,inst_11787,null));
var state_11799__$1 = (function (){var statearr_11806 = state_11799;
(statearr_11806[(8)] = inst_11785__$1);

return statearr_11806;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11799__$1,(8),jobs,inst_11788);
} else {
if((state_val_11800 === (3))){
var inst_11797 = (state_11799[(2)]);
var state_11799__$1 = state_11799;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11799__$1,inst_11797);
} else {
if((state_val_11800 === (2))){
var state_11799__$1 = state_11799;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11799__$1,(4),from);
} else {
if((state_val_11800 === (9))){
var inst_11792 = (state_11799[(2)]);
var state_11799__$1 = (function (){var statearr_11807 = state_11799;
(statearr_11807[(9)] = inst_11792);

return statearr_11807;
})();
var statearr_11808_11919 = state_11799__$1;
(statearr_11808_11919[(2)] = null);

(statearr_11808_11919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11800 === (5))){
var inst_11783 = cljs.core.async.close_BANG_.call(null,jobs);
var state_11799__$1 = state_11799;
var statearr_11809_11920 = state_11799__$1;
(statearr_11809_11920[(2)] = inst_11783);

(statearr_11809_11920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11800 === (8))){
var inst_11785 = (state_11799[(8)]);
var inst_11790 = (state_11799[(2)]);
var state_11799__$1 = (function (){var statearr_11810 = state_11799;
(statearr_11810[(10)] = inst_11790);

return statearr_11810;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11799__$1,(9),results,inst_11785);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_11811 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11811[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__);

(statearr_11811[(1)] = (1));

return statearr_11811;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1 = (function (state_11799){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11799);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11812){var ex__11472__auto__ = e11812;
var statearr_11813_11921 = state_11799;
(statearr_11813_11921[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11799[(4)]))){
var statearr_11814_11922 = state_11799;
(statearr_11814_11922[(1)] = cljs.core.first.call(null,(state_11799[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11923 = state_11799;
state_11799 = G__11923;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = function(state_11799){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1.call(this,state_11799);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_11815 = f__11543__auto__.call(null);
(statearr_11815[(6)] = c__11542__auto___11914);

return statearr_11815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_11853){
var state_val_11854 = (state_11853[(1)]);
if((state_val_11854 === (7))){
var inst_11849 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
var statearr_11855_11924 = state_11853__$1;
(statearr_11855_11924[(2)] = inst_11849);

(statearr_11855_11924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (20))){
var state_11853__$1 = state_11853;
var statearr_11856_11925 = state_11853__$1;
(statearr_11856_11925[(2)] = null);

(statearr_11856_11925[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (1))){
var state_11853__$1 = state_11853;
var statearr_11857_11926 = state_11853__$1;
(statearr_11857_11926[(2)] = null);

(statearr_11857_11926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (4))){
var inst_11818 = (state_11853[(7)]);
var inst_11818__$1 = (state_11853[(2)]);
var inst_11819 = (inst_11818__$1 == null);
var state_11853__$1 = (function (){var statearr_11858 = state_11853;
(statearr_11858[(7)] = inst_11818__$1);

return statearr_11858;
})();
if(cljs.core.truth_(inst_11819)){
var statearr_11859_11927 = state_11853__$1;
(statearr_11859_11927[(1)] = (5));

} else {
var statearr_11860_11928 = state_11853__$1;
(statearr_11860_11928[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (15))){
var inst_11831 = (state_11853[(8)]);
var state_11853__$1 = state_11853;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11853__$1,(18),to,inst_11831);
} else {
if((state_val_11854 === (21))){
var inst_11844 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
var statearr_11861_11929 = state_11853__$1;
(statearr_11861_11929[(2)] = inst_11844);

(statearr_11861_11929[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (13))){
var inst_11846 = (state_11853[(2)]);
var state_11853__$1 = (function (){var statearr_11862 = state_11853;
(statearr_11862[(9)] = inst_11846);

return statearr_11862;
})();
var statearr_11863_11930 = state_11853__$1;
(statearr_11863_11930[(2)] = null);

(statearr_11863_11930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (6))){
var inst_11818 = (state_11853[(7)]);
var state_11853__$1 = state_11853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11853__$1,(11),inst_11818);
} else {
if((state_val_11854 === (17))){
var inst_11839 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
if(cljs.core.truth_(inst_11839)){
var statearr_11864_11931 = state_11853__$1;
(statearr_11864_11931[(1)] = (19));

} else {
var statearr_11865_11932 = state_11853__$1;
(statearr_11865_11932[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (3))){
var inst_11851 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11853__$1,inst_11851);
} else {
if((state_val_11854 === (12))){
var inst_11828 = (state_11853[(10)]);
var state_11853__$1 = state_11853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11853__$1,(14),inst_11828);
} else {
if((state_val_11854 === (2))){
var state_11853__$1 = state_11853;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11853__$1,(4),results);
} else {
if((state_val_11854 === (19))){
var state_11853__$1 = state_11853;
var statearr_11866_11933 = state_11853__$1;
(statearr_11866_11933[(2)] = null);

(statearr_11866_11933[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (11))){
var inst_11828 = (state_11853[(2)]);
var state_11853__$1 = (function (){var statearr_11867 = state_11853;
(statearr_11867[(10)] = inst_11828);

return statearr_11867;
})();
var statearr_11868_11934 = state_11853__$1;
(statearr_11868_11934[(2)] = null);

(statearr_11868_11934[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (9))){
var state_11853__$1 = state_11853;
var statearr_11869_11935 = state_11853__$1;
(statearr_11869_11935[(2)] = null);

(statearr_11869_11935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (5))){
var state_11853__$1 = state_11853;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11870_11936 = state_11853__$1;
(statearr_11870_11936[(1)] = (8));

} else {
var statearr_11871_11937 = state_11853__$1;
(statearr_11871_11937[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (14))){
var inst_11831 = (state_11853[(8)]);
var inst_11831__$1 = (state_11853[(2)]);
var inst_11832 = (inst_11831__$1 == null);
var inst_11833 = cljs.core.not.call(null,inst_11832);
var state_11853__$1 = (function (){var statearr_11872 = state_11853;
(statearr_11872[(8)] = inst_11831__$1);

return statearr_11872;
})();
if(inst_11833){
var statearr_11873_11938 = state_11853__$1;
(statearr_11873_11938[(1)] = (15));

} else {
var statearr_11874_11939 = state_11853__$1;
(statearr_11874_11939[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (16))){
var state_11853__$1 = state_11853;
var statearr_11875_11940 = state_11853__$1;
(statearr_11875_11940[(2)] = false);

(statearr_11875_11940[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (10))){
var inst_11825 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
var statearr_11876_11941 = state_11853__$1;
(statearr_11876_11941[(2)] = inst_11825);

(statearr_11876_11941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (18))){
var inst_11836 = (state_11853[(2)]);
var state_11853__$1 = state_11853;
var statearr_11877_11942 = state_11853__$1;
(statearr_11877_11942[(2)] = inst_11836);

(statearr_11877_11942[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11854 === (8))){
var inst_11822 = cljs.core.async.close_BANG_.call(null,to);
var state_11853__$1 = state_11853;
var statearr_11878_11943 = state_11853__$1;
(statearr_11878_11943[(2)] = inst_11822);

(statearr_11878_11943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_11879 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_11879[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__);

(statearr_11879[(1)] = (1));

return statearr_11879;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1 = (function (state_11853){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11853);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11880){var ex__11472__auto__ = e11880;
var statearr_11881_11944 = state_11853;
(statearr_11881_11944[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11853[(4)]))){
var statearr_11882_11945 = state_11853;
(statearr_11882_11945[(1)] = cljs.core.first.call(null,(state_11853[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11946 = state_11853;
state_11853 = G__11946;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__ = function(state_11853){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1.call(this,state_11853);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_11883 = f__11543__auto__.call(null);
(statearr_11883[(6)] = c__11542__auto__);

return statearr_11883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__11948 = arguments.length;
switch (G__11948) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__11951 = arguments.length;
switch (G__11951) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__11954 = arguments.length;
switch (G__11954) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11542__auto___12004 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_11980){
var state_val_11981 = (state_11980[(1)]);
if((state_val_11981 === (7))){
var inst_11976 = (state_11980[(2)]);
var state_11980__$1 = state_11980;
var statearr_11982_12005 = state_11980__$1;
(statearr_11982_12005[(2)] = inst_11976);

(statearr_11982_12005[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (1))){
var state_11980__$1 = state_11980;
var statearr_11983_12006 = state_11980__$1;
(statearr_11983_12006[(2)] = null);

(statearr_11983_12006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (4))){
var inst_11957 = (state_11980[(7)]);
var inst_11957__$1 = (state_11980[(2)]);
var inst_11958 = (inst_11957__$1 == null);
var state_11980__$1 = (function (){var statearr_11984 = state_11980;
(statearr_11984[(7)] = inst_11957__$1);

return statearr_11984;
})();
if(cljs.core.truth_(inst_11958)){
var statearr_11985_12007 = state_11980__$1;
(statearr_11985_12007[(1)] = (5));

} else {
var statearr_11986_12008 = state_11980__$1;
(statearr_11986_12008[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (13))){
var state_11980__$1 = state_11980;
var statearr_11987_12009 = state_11980__$1;
(statearr_11987_12009[(2)] = null);

(statearr_11987_12009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (6))){
var inst_11957 = (state_11980[(7)]);
var inst_11963 = p.call(null,inst_11957);
var state_11980__$1 = state_11980;
if(cljs.core.truth_(inst_11963)){
var statearr_11988_12010 = state_11980__$1;
(statearr_11988_12010[(1)] = (9));

} else {
var statearr_11989_12011 = state_11980__$1;
(statearr_11989_12011[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (3))){
var inst_11978 = (state_11980[(2)]);
var state_11980__$1 = state_11980;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11980__$1,inst_11978);
} else {
if((state_val_11981 === (12))){
var state_11980__$1 = state_11980;
var statearr_11990_12012 = state_11980__$1;
(statearr_11990_12012[(2)] = null);

(statearr_11990_12012[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (2))){
var state_11980__$1 = state_11980;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11980__$1,(4),ch);
} else {
if((state_val_11981 === (11))){
var inst_11957 = (state_11980[(7)]);
var inst_11967 = (state_11980[(2)]);
var state_11980__$1 = state_11980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11980__$1,(8),inst_11967,inst_11957);
} else {
if((state_val_11981 === (9))){
var state_11980__$1 = state_11980;
var statearr_11991_12013 = state_11980__$1;
(statearr_11991_12013[(2)] = tc);

(statearr_11991_12013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (5))){
var inst_11960 = cljs.core.async.close_BANG_.call(null,tc);
var inst_11961 = cljs.core.async.close_BANG_.call(null,fc);
var state_11980__$1 = (function (){var statearr_11992 = state_11980;
(statearr_11992[(8)] = inst_11960);

return statearr_11992;
})();
var statearr_11993_12014 = state_11980__$1;
(statearr_11993_12014[(2)] = inst_11961);

(statearr_11993_12014[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (14))){
var inst_11974 = (state_11980[(2)]);
var state_11980__$1 = state_11980;
var statearr_11994_12015 = state_11980__$1;
(statearr_11994_12015[(2)] = inst_11974);

(statearr_11994_12015[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (10))){
var state_11980__$1 = state_11980;
var statearr_11995_12016 = state_11980__$1;
(statearr_11995_12016[(2)] = fc);

(statearr_11995_12016[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11981 === (8))){
var inst_11969 = (state_11980[(2)]);
var state_11980__$1 = state_11980;
if(cljs.core.truth_(inst_11969)){
var statearr_11996_12017 = state_11980__$1;
(statearr_11996_12017[(1)] = (12));

} else {
var statearr_11997_12018 = state_11980__$1;
(statearr_11997_12018[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_11998 = [null,null,null,null,null,null,null,null,null];
(statearr_11998[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_11998[(1)] = (1));

return statearr_11998;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_11980){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_11980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e11999){var ex__11472__auto__ = e11999;
var statearr_12000_12019 = state_11980;
(statearr_12000_12019[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_11980[(4)]))){
var statearr_12001_12020 = state_11980;
(statearr_12001_12020[(1)] = cljs.core.first.call(null,(state_11980[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12021 = state_11980;
state_11980 = G__12021;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_11980){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_11980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12002 = f__11543__auto__.call(null);
(statearr_12002[(6)] = c__11542__auto___12004);

return statearr_12002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12043){
var state_val_12044 = (state_12043[(1)]);
if((state_val_12044 === (7))){
var inst_12039 = (state_12043[(2)]);
var state_12043__$1 = state_12043;
var statearr_12045_12064 = state_12043__$1;
(statearr_12045_12064[(2)] = inst_12039);

(statearr_12045_12064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (1))){
var inst_12022 = init;
var inst_12023 = inst_12022;
var state_12043__$1 = (function (){var statearr_12046 = state_12043;
(statearr_12046[(7)] = inst_12023);

return statearr_12046;
})();
var statearr_12047_12065 = state_12043__$1;
(statearr_12047_12065[(2)] = null);

(statearr_12047_12065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (4))){
var inst_12026 = (state_12043[(8)]);
var inst_12026__$1 = (state_12043[(2)]);
var inst_12027 = (inst_12026__$1 == null);
var state_12043__$1 = (function (){var statearr_12048 = state_12043;
(statearr_12048[(8)] = inst_12026__$1);

return statearr_12048;
})();
if(cljs.core.truth_(inst_12027)){
var statearr_12049_12066 = state_12043__$1;
(statearr_12049_12066[(1)] = (5));

} else {
var statearr_12050_12067 = state_12043__$1;
(statearr_12050_12067[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (6))){
var inst_12023 = (state_12043[(7)]);
var inst_12026 = (state_12043[(8)]);
var inst_12030 = (state_12043[(9)]);
var inst_12030__$1 = f.call(null,inst_12023,inst_12026);
var inst_12031 = cljs.core.reduced_QMARK_.call(null,inst_12030__$1);
var state_12043__$1 = (function (){var statearr_12051 = state_12043;
(statearr_12051[(9)] = inst_12030__$1);

return statearr_12051;
})();
if(inst_12031){
var statearr_12052_12068 = state_12043__$1;
(statearr_12052_12068[(1)] = (8));

} else {
var statearr_12053_12069 = state_12043__$1;
(statearr_12053_12069[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (3))){
var inst_12041 = (state_12043[(2)]);
var state_12043__$1 = state_12043;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12043__$1,inst_12041);
} else {
if((state_val_12044 === (2))){
var state_12043__$1 = state_12043;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12043__$1,(4),ch);
} else {
if((state_val_12044 === (9))){
var inst_12030 = (state_12043[(9)]);
var inst_12023 = inst_12030;
var state_12043__$1 = (function (){var statearr_12054 = state_12043;
(statearr_12054[(7)] = inst_12023);

return statearr_12054;
})();
var statearr_12055_12070 = state_12043__$1;
(statearr_12055_12070[(2)] = null);

(statearr_12055_12070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (5))){
var inst_12023 = (state_12043[(7)]);
var state_12043__$1 = state_12043;
var statearr_12056_12071 = state_12043__$1;
(statearr_12056_12071[(2)] = inst_12023);

(statearr_12056_12071[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (10))){
var inst_12037 = (state_12043[(2)]);
var state_12043__$1 = state_12043;
var statearr_12057_12072 = state_12043__$1;
(statearr_12057_12072[(2)] = inst_12037);

(statearr_12057_12072[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12044 === (8))){
var inst_12030 = (state_12043[(9)]);
var inst_12033 = cljs.core.deref.call(null,inst_12030);
var state_12043__$1 = state_12043;
var statearr_12058_12073 = state_12043__$1;
(statearr_12058_12073[(2)] = inst_12033);

(statearr_12058_12073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__11469__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11469__auto____0 = (function (){
var statearr_12059 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12059[(0)] = cljs$core$async$reduce_$_state_machine__11469__auto__);

(statearr_12059[(1)] = (1));

return statearr_12059;
});
var cljs$core$async$reduce_$_state_machine__11469__auto____1 = (function (state_12043){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12043);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12060){var ex__11472__auto__ = e12060;
var statearr_12061_12074 = state_12043;
(statearr_12061_12074[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12043[(4)]))){
var statearr_12062_12075 = state_12043;
(statearr_12062_12075[(1)] = cljs.core.first.call(null,(state_12043[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12076 = state_12043;
state_12043 = G__12076;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11469__auto__ = function(state_12043){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11469__auto____1.call(this,state_12043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11469__auto____0;
cljs$core$async$reduce_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11469__auto____1;
return cljs$core$async$reduce_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12063 = f__11543__auto__.call(null);
(statearr_12063[(6)] = c__11542__auto__);

return statearr_12063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12082){
var state_val_12083 = (state_12082[(1)]);
if((state_val_12083 === (1))){
var inst_12077 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_12082__$1 = state_12082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12082__$1,(2),inst_12077);
} else {
if((state_val_12083 === (2))){
var inst_12079 = (state_12082[(2)]);
var inst_12080 = f__$1.call(null,inst_12079);
var state_12082__$1 = state_12082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12082__$1,inst_12080);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__11469__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11469__auto____0 = (function (){
var statearr_12084 = [null,null,null,null,null,null,null];
(statearr_12084[(0)] = cljs$core$async$transduce_$_state_machine__11469__auto__);

(statearr_12084[(1)] = (1));

return statearr_12084;
});
var cljs$core$async$transduce_$_state_machine__11469__auto____1 = (function (state_12082){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12085){var ex__11472__auto__ = e12085;
var statearr_12086_12089 = state_12082;
(statearr_12086_12089[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12082[(4)]))){
var statearr_12087_12090 = state_12082;
(statearr_12087_12090[(1)] = cljs.core.first.call(null,(state_12082[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12091 = state_12082;
state_12082 = G__12091;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11469__auto__ = function(state_12082){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11469__auto____1.call(this,state_12082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11469__auto____0;
cljs$core$async$transduce_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11469__auto____1;
return cljs$core$async$transduce_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12088 = f__11543__auto__.call(null);
(statearr_12088[(6)] = c__11542__auto__);

return statearr_12088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__12093 = arguments.length;
switch (G__12093) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12118){
var state_val_12119 = (state_12118[(1)]);
if((state_val_12119 === (7))){
var inst_12100 = (state_12118[(2)]);
var state_12118__$1 = state_12118;
var statearr_12120_12142 = state_12118__$1;
(statearr_12120_12142[(2)] = inst_12100);

(statearr_12120_12142[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (1))){
var inst_12094 = cljs.core.seq.call(null,coll);
var inst_12095 = inst_12094;
var state_12118__$1 = (function (){var statearr_12121 = state_12118;
(statearr_12121[(7)] = inst_12095);

return statearr_12121;
})();
var statearr_12122_12143 = state_12118__$1;
(statearr_12122_12143[(2)] = null);

(statearr_12122_12143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (4))){
var inst_12095 = (state_12118[(7)]);
var inst_12098 = cljs.core.first.call(null,inst_12095);
var state_12118__$1 = state_12118;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12118__$1,(7),ch,inst_12098);
} else {
if((state_val_12119 === (13))){
var inst_12112 = (state_12118[(2)]);
var state_12118__$1 = state_12118;
var statearr_12123_12144 = state_12118__$1;
(statearr_12123_12144[(2)] = inst_12112);

(statearr_12123_12144[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (6))){
var inst_12103 = (state_12118[(2)]);
var state_12118__$1 = state_12118;
if(cljs.core.truth_(inst_12103)){
var statearr_12124_12145 = state_12118__$1;
(statearr_12124_12145[(1)] = (8));

} else {
var statearr_12125_12146 = state_12118__$1;
(statearr_12125_12146[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (3))){
var inst_12116 = (state_12118[(2)]);
var state_12118__$1 = state_12118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12118__$1,inst_12116);
} else {
if((state_val_12119 === (12))){
var state_12118__$1 = state_12118;
var statearr_12126_12147 = state_12118__$1;
(statearr_12126_12147[(2)] = null);

(statearr_12126_12147[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (2))){
var inst_12095 = (state_12118[(7)]);
var state_12118__$1 = state_12118;
if(cljs.core.truth_(inst_12095)){
var statearr_12127_12148 = state_12118__$1;
(statearr_12127_12148[(1)] = (4));

} else {
var statearr_12128_12149 = state_12118__$1;
(statearr_12128_12149[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (11))){
var inst_12109 = cljs.core.async.close_BANG_.call(null,ch);
var state_12118__$1 = state_12118;
var statearr_12129_12150 = state_12118__$1;
(statearr_12129_12150[(2)] = inst_12109);

(statearr_12129_12150[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (9))){
var state_12118__$1 = state_12118;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12130_12151 = state_12118__$1;
(statearr_12130_12151[(1)] = (11));

} else {
var statearr_12131_12152 = state_12118__$1;
(statearr_12131_12152[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (5))){
var inst_12095 = (state_12118[(7)]);
var state_12118__$1 = state_12118;
var statearr_12132_12153 = state_12118__$1;
(statearr_12132_12153[(2)] = inst_12095);

(statearr_12132_12153[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (10))){
var inst_12114 = (state_12118[(2)]);
var state_12118__$1 = state_12118;
var statearr_12133_12154 = state_12118__$1;
(statearr_12133_12154[(2)] = inst_12114);

(statearr_12133_12154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12119 === (8))){
var inst_12095 = (state_12118[(7)]);
var inst_12105 = cljs.core.next.call(null,inst_12095);
var inst_12095__$1 = inst_12105;
var state_12118__$1 = (function (){var statearr_12134 = state_12118;
(statearr_12134[(7)] = inst_12095__$1);

return statearr_12134;
})();
var statearr_12135_12155 = state_12118__$1;
(statearr_12135_12155[(2)] = null);

(statearr_12135_12155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_12136 = [null,null,null,null,null,null,null,null];
(statearr_12136[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_12136[(1)] = (1));

return statearr_12136;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_12118){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12137){var ex__11472__auto__ = e12137;
var statearr_12138_12156 = state_12118;
(statearr_12138_12156[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12118[(4)]))){
var statearr_12139_12157 = state_12118;
(statearr_12139_12157[(1)] = cljs.core.first.call(null,(state_12118[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12158 = state_12118;
state_12118 = G__12158;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_12118){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_12118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12140 = f__11543__auto__.call(null);
(statearr_12140[(6)] = c__11542__auto__);

return statearr_12140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan_BANG_.call(null,ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__12160 = arguments.length;
switch (G__12160) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.call(null,ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_.call(null,coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_12162 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,_);
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_12162.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_12163 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_12163.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_12164 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_12164.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_12165 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_12165.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12166 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12166 = (function (ch,cs,meta12167){
this.ch = ch;
this.cs = cs;
this.meta12167 = meta12167;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12168,meta12167__$1){
var self__ = this;
var _12168__$1 = this;
return (new cljs.core.async.t_cljs$core$async12166(self__.ch,self__.cs,meta12167__$1));
}));

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12168){
var self__ = this;
var _12168__$1 = this;
return self__.meta12167;
}));

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async12166.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async12166.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12167","meta12167",265214454,null)], null);
}));

(cljs.core.async.t_cljs$core$async12166.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12166.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12166");

(cljs.core.async.t_cljs$core$async12166.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async12166");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12166.
 */
cljs.core.async.__GT_t_cljs$core$async12166 = (function cljs$core$async$mult_$___GT_t_cljs$core$async12166(ch__$1,cs__$1,meta12167){
return (new cljs.core.async.t_cljs$core$async12166(ch__$1,cs__$1,meta12167));
});

}

return (new cljs.core.async.t_cljs$core$async12166(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__11542__auto___12385 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12301){
var state_val_12302 = (state_12301[(1)]);
if((state_val_12302 === (7))){
var inst_12297 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12303_12386 = state_12301__$1;
(statearr_12303_12386[(2)] = inst_12297);

(statearr_12303_12386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (20))){
var inst_12202 = (state_12301[(7)]);
var inst_12214 = cljs.core.first.call(null,inst_12202);
var inst_12215 = cljs.core.nth.call(null,inst_12214,(0),null);
var inst_12216 = cljs.core.nth.call(null,inst_12214,(1),null);
var state_12301__$1 = (function (){var statearr_12304 = state_12301;
(statearr_12304[(8)] = inst_12215);

return statearr_12304;
})();
if(cljs.core.truth_(inst_12216)){
var statearr_12305_12387 = state_12301__$1;
(statearr_12305_12387[(1)] = (22));

} else {
var statearr_12306_12388 = state_12301__$1;
(statearr_12306_12388[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (27))){
var inst_12251 = (state_12301[(9)]);
var inst_12246 = (state_12301[(10)]);
var inst_12171 = (state_12301[(11)]);
var inst_12244 = (state_12301[(12)]);
var inst_12251__$1 = cljs.core._nth.call(null,inst_12244,inst_12246);
var inst_12252 = cljs.core.async.put_BANG_.call(null,inst_12251__$1,inst_12171,done);
var state_12301__$1 = (function (){var statearr_12307 = state_12301;
(statearr_12307[(9)] = inst_12251__$1);

return statearr_12307;
})();
if(cljs.core.truth_(inst_12252)){
var statearr_12308_12389 = state_12301__$1;
(statearr_12308_12389[(1)] = (30));

} else {
var statearr_12309_12390 = state_12301__$1;
(statearr_12309_12390[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (1))){
var state_12301__$1 = state_12301;
var statearr_12310_12391 = state_12301__$1;
(statearr_12310_12391[(2)] = null);

(statearr_12310_12391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (24))){
var inst_12202 = (state_12301[(7)]);
var inst_12221 = (state_12301[(2)]);
var inst_12222 = cljs.core.next.call(null,inst_12202);
var inst_12180 = inst_12222;
var inst_12181 = null;
var inst_12182 = (0);
var inst_12183 = (0);
var state_12301__$1 = (function (){var statearr_12311 = state_12301;
(statearr_12311[(13)] = inst_12182);

(statearr_12311[(14)] = inst_12181);

(statearr_12311[(15)] = inst_12183);

(statearr_12311[(16)] = inst_12221);

(statearr_12311[(17)] = inst_12180);

return statearr_12311;
})();
var statearr_12312_12392 = state_12301__$1;
(statearr_12312_12392[(2)] = null);

(statearr_12312_12392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (39))){
var state_12301__$1 = state_12301;
var statearr_12316_12393 = state_12301__$1;
(statearr_12316_12393[(2)] = null);

(statearr_12316_12393[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (4))){
var inst_12171 = (state_12301[(11)]);
var inst_12171__$1 = (state_12301[(2)]);
var inst_12172 = (inst_12171__$1 == null);
var state_12301__$1 = (function (){var statearr_12317 = state_12301;
(statearr_12317[(11)] = inst_12171__$1);

return statearr_12317;
})();
if(cljs.core.truth_(inst_12172)){
var statearr_12318_12394 = state_12301__$1;
(statearr_12318_12394[(1)] = (5));

} else {
var statearr_12319_12395 = state_12301__$1;
(statearr_12319_12395[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (15))){
var inst_12182 = (state_12301[(13)]);
var inst_12181 = (state_12301[(14)]);
var inst_12183 = (state_12301[(15)]);
var inst_12180 = (state_12301[(17)]);
var inst_12198 = (state_12301[(2)]);
var inst_12199 = (inst_12183 + (1));
var tmp12313 = inst_12182;
var tmp12314 = inst_12181;
var tmp12315 = inst_12180;
var inst_12180__$1 = tmp12315;
var inst_12181__$1 = tmp12314;
var inst_12182__$1 = tmp12313;
var inst_12183__$1 = inst_12199;
var state_12301__$1 = (function (){var statearr_12320 = state_12301;
(statearr_12320[(13)] = inst_12182__$1);

(statearr_12320[(14)] = inst_12181__$1);

(statearr_12320[(15)] = inst_12183__$1);

(statearr_12320[(18)] = inst_12198);

(statearr_12320[(17)] = inst_12180__$1);

return statearr_12320;
})();
var statearr_12321_12396 = state_12301__$1;
(statearr_12321_12396[(2)] = null);

(statearr_12321_12396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (21))){
var inst_12225 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12325_12397 = state_12301__$1;
(statearr_12325_12397[(2)] = inst_12225);

(statearr_12325_12397[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (31))){
var inst_12251 = (state_12301[(9)]);
var inst_12255 = cljs.core.async.untap_STAR_.call(null,m,inst_12251);
var state_12301__$1 = state_12301;
var statearr_12326_12398 = state_12301__$1;
(statearr_12326_12398[(2)] = inst_12255);

(statearr_12326_12398[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (32))){
var inst_12246 = (state_12301[(10)]);
var inst_12243 = (state_12301[(19)]);
var inst_12245 = (state_12301[(20)]);
var inst_12244 = (state_12301[(12)]);
var inst_12257 = (state_12301[(2)]);
var inst_12258 = (inst_12246 + (1));
var tmp12322 = inst_12243;
var tmp12323 = inst_12245;
var tmp12324 = inst_12244;
var inst_12243__$1 = tmp12322;
var inst_12244__$1 = tmp12324;
var inst_12245__$1 = tmp12323;
var inst_12246__$1 = inst_12258;
var state_12301__$1 = (function (){var statearr_12327 = state_12301;
(statearr_12327[(10)] = inst_12246__$1);

(statearr_12327[(21)] = inst_12257);

(statearr_12327[(19)] = inst_12243__$1);

(statearr_12327[(20)] = inst_12245__$1);

(statearr_12327[(12)] = inst_12244__$1);

return statearr_12327;
})();
var statearr_12328_12399 = state_12301__$1;
(statearr_12328_12399[(2)] = null);

(statearr_12328_12399[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (40))){
var inst_12270 = (state_12301[(22)]);
var inst_12274 = cljs.core.async.untap_STAR_.call(null,m,inst_12270);
var state_12301__$1 = state_12301;
var statearr_12329_12400 = state_12301__$1;
(statearr_12329_12400[(2)] = inst_12274);

(statearr_12329_12400[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (33))){
var inst_12261 = (state_12301[(23)]);
var inst_12263 = cljs.core.chunked_seq_QMARK_.call(null,inst_12261);
var state_12301__$1 = state_12301;
if(inst_12263){
var statearr_12330_12401 = state_12301__$1;
(statearr_12330_12401[(1)] = (36));

} else {
var statearr_12331_12402 = state_12301__$1;
(statearr_12331_12402[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (13))){
var inst_12192 = (state_12301[(24)]);
var inst_12195 = cljs.core.async.close_BANG_.call(null,inst_12192);
var state_12301__$1 = state_12301;
var statearr_12332_12403 = state_12301__$1;
(statearr_12332_12403[(2)] = inst_12195);

(statearr_12332_12403[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (22))){
var inst_12215 = (state_12301[(8)]);
var inst_12218 = cljs.core.async.close_BANG_.call(null,inst_12215);
var state_12301__$1 = state_12301;
var statearr_12333_12404 = state_12301__$1;
(statearr_12333_12404[(2)] = inst_12218);

(statearr_12333_12404[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (36))){
var inst_12261 = (state_12301[(23)]);
var inst_12265 = cljs.core.chunk_first.call(null,inst_12261);
var inst_12266 = cljs.core.chunk_rest.call(null,inst_12261);
var inst_12267 = cljs.core.count.call(null,inst_12265);
var inst_12243 = inst_12266;
var inst_12244 = inst_12265;
var inst_12245 = inst_12267;
var inst_12246 = (0);
var state_12301__$1 = (function (){var statearr_12334 = state_12301;
(statearr_12334[(10)] = inst_12246);

(statearr_12334[(19)] = inst_12243);

(statearr_12334[(20)] = inst_12245);

(statearr_12334[(12)] = inst_12244);

return statearr_12334;
})();
var statearr_12335_12405 = state_12301__$1;
(statearr_12335_12405[(2)] = null);

(statearr_12335_12405[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (41))){
var inst_12261 = (state_12301[(23)]);
var inst_12276 = (state_12301[(2)]);
var inst_12277 = cljs.core.next.call(null,inst_12261);
var inst_12243 = inst_12277;
var inst_12244 = null;
var inst_12245 = (0);
var inst_12246 = (0);
var state_12301__$1 = (function (){var statearr_12336 = state_12301;
(statearr_12336[(25)] = inst_12276);

(statearr_12336[(10)] = inst_12246);

(statearr_12336[(19)] = inst_12243);

(statearr_12336[(20)] = inst_12245);

(statearr_12336[(12)] = inst_12244);

return statearr_12336;
})();
var statearr_12337_12406 = state_12301__$1;
(statearr_12337_12406[(2)] = null);

(statearr_12337_12406[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (43))){
var state_12301__$1 = state_12301;
var statearr_12338_12407 = state_12301__$1;
(statearr_12338_12407[(2)] = null);

(statearr_12338_12407[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (29))){
var inst_12285 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12339_12408 = state_12301__$1;
(statearr_12339_12408[(2)] = inst_12285);

(statearr_12339_12408[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (44))){
var inst_12294 = (state_12301[(2)]);
var state_12301__$1 = (function (){var statearr_12340 = state_12301;
(statearr_12340[(26)] = inst_12294);

return statearr_12340;
})();
var statearr_12341_12409 = state_12301__$1;
(statearr_12341_12409[(2)] = null);

(statearr_12341_12409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (6))){
var inst_12235 = (state_12301[(27)]);
var inst_12234 = cljs.core.deref.call(null,cs);
var inst_12235__$1 = cljs.core.keys.call(null,inst_12234);
var inst_12236 = cljs.core.count.call(null,inst_12235__$1);
var inst_12237 = cljs.core.reset_BANG_.call(null,dctr,inst_12236);
var inst_12242 = cljs.core.seq.call(null,inst_12235__$1);
var inst_12243 = inst_12242;
var inst_12244 = null;
var inst_12245 = (0);
var inst_12246 = (0);
var state_12301__$1 = (function (){var statearr_12342 = state_12301;
(statearr_12342[(10)] = inst_12246);

(statearr_12342[(19)] = inst_12243);

(statearr_12342[(20)] = inst_12245);

(statearr_12342[(27)] = inst_12235__$1);

(statearr_12342[(28)] = inst_12237);

(statearr_12342[(12)] = inst_12244);

return statearr_12342;
})();
var statearr_12343_12410 = state_12301__$1;
(statearr_12343_12410[(2)] = null);

(statearr_12343_12410[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (28))){
var inst_12261 = (state_12301[(23)]);
var inst_12243 = (state_12301[(19)]);
var inst_12261__$1 = cljs.core.seq.call(null,inst_12243);
var state_12301__$1 = (function (){var statearr_12344 = state_12301;
(statearr_12344[(23)] = inst_12261__$1);

return statearr_12344;
})();
if(inst_12261__$1){
var statearr_12345_12411 = state_12301__$1;
(statearr_12345_12411[(1)] = (33));

} else {
var statearr_12346_12412 = state_12301__$1;
(statearr_12346_12412[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (25))){
var inst_12246 = (state_12301[(10)]);
var inst_12245 = (state_12301[(20)]);
var inst_12248 = (inst_12246 < inst_12245);
var inst_12249 = inst_12248;
var state_12301__$1 = state_12301;
if(cljs.core.truth_(inst_12249)){
var statearr_12347_12413 = state_12301__$1;
(statearr_12347_12413[(1)] = (27));

} else {
var statearr_12348_12414 = state_12301__$1;
(statearr_12348_12414[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (34))){
var state_12301__$1 = state_12301;
var statearr_12349_12415 = state_12301__$1;
(statearr_12349_12415[(2)] = null);

(statearr_12349_12415[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (17))){
var state_12301__$1 = state_12301;
var statearr_12350_12416 = state_12301__$1;
(statearr_12350_12416[(2)] = null);

(statearr_12350_12416[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (3))){
var inst_12299 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12301__$1,inst_12299);
} else {
if((state_val_12302 === (12))){
var inst_12230 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12351_12417 = state_12301__$1;
(statearr_12351_12417[(2)] = inst_12230);

(statearr_12351_12417[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (2))){
var state_12301__$1 = state_12301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12301__$1,(4),ch);
} else {
if((state_val_12302 === (23))){
var state_12301__$1 = state_12301;
var statearr_12352_12418 = state_12301__$1;
(statearr_12352_12418[(2)] = null);

(statearr_12352_12418[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (35))){
var inst_12283 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12353_12419 = state_12301__$1;
(statearr_12353_12419[(2)] = inst_12283);

(statearr_12353_12419[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (19))){
var inst_12202 = (state_12301[(7)]);
var inst_12206 = cljs.core.chunk_first.call(null,inst_12202);
var inst_12207 = cljs.core.chunk_rest.call(null,inst_12202);
var inst_12208 = cljs.core.count.call(null,inst_12206);
var inst_12180 = inst_12207;
var inst_12181 = inst_12206;
var inst_12182 = inst_12208;
var inst_12183 = (0);
var state_12301__$1 = (function (){var statearr_12354 = state_12301;
(statearr_12354[(13)] = inst_12182);

(statearr_12354[(14)] = inst_12181);

(statearr_12354[(15)] = inst_12183);

(statearr_12354[(17)] = inst_12180);

return statearr_12354;
})();
var statearr_12355_12420 = state_12301__$1;
(statearr_12355_12420[(2)] = null);

(statearr_12355_12420[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (11))){
var inst_12202 = (state_12301[(7)]);
var inst_12180 = (state_12301[(17)]);
var inst_12202__$1 = cljs.core.seq.call(null,inst_12180);
var state_12301__$1 = (function (){var statearr_12356 = state_12301;
(statearr_12356[(7)] = inst_12202__$1);

return statearr_12356;
})();
if(inst_12202__$1){
var statearr_12357_12421 = state_12301__$1;
(statearr_12357_12421[(1)] = (16));

} else {
var statearr_12358_12422 = state_12301__$1;
(statearr_12358_12422[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (9))){
var inst_12232 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12359_12423 = state_12301__$1;
(statearr_12359_12423[(2)] = inst_12232);

(statearr_12359_12423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (5))){
var inst_12178 = cljs.core.deref.call(null,cs);
var inst_12179 = cljs.core.seq.call(null,inst_12178);
var inst_12180 = inst_12179;
var inst_12181 = null;
var inst_12182 = (0);
var inst_12183 = (0);
var state_12301__$1 = (function (){var statearr_12360 = state_12301;
(statearr_12360[(13)] = inst_12182);

(statearr_12360[(14)] = inst_12181);

(statearr_12360[(15)] = inst_12183);

(statearr_12360[(17)] = inst_12180);

return statearr_12360;
})();
var statearr_12361_12424 = state_12301__$1;
(statearr_12361_12424[(2)] = null);

(statearr_12361_12424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (14))){
var state_12301__$1 = state_12301;
var statearr_12362_12425 = state_12301__$1;
(statearr_12362_12425[(2)] = null);

(statearr_12362_12425[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (45))){
var inst_12291 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12363_12426 = state_12301__$1;
(statearr_12363_12426[(2)] = inst_12291);

(statearr_12363_12426[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (26))){
var inst_12235 = (state_12301[(27)]);
var inst_12287 = (state_12301[(2)]);
var inst_12288 = cljs.core.seq.call(null,inst_12235);
var state_12301__$1 = (function (){var statearr_12364 = state_12301;
(statearr_12364[(29)] = inst_12287);

return statearr_12364;
})();
if(inst_12288){
var statearr_12365_12427 = state_12301__$1;
(statearr_12365_12427[(1)] = (42));

} else {
var statearr_12366_12428 = state_12301__$1;
(statearr_12366_12428[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (16))){
var inst_12202 = (state_12301[(7)]);
var inst_12204 = cljs.core.chunked_seq_QMARK_.call(null,inst_12202);
var state_12301__$1 = state_12301;
if(inst_12204){
var statearr_12367_12429 = state_12301__$1;
(statearr_12367_12429[(1)] = (19));

} else {
var statearr_12368_12430 = state_12301__$1;
(statearr_12368_12430[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (38))){
var inst_12280 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12369_12431 = state_12301__$1;
(statearr_12369_12431[(2)] = inst_12280);

(statearr_12369_12431[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (30))){
var state_12301__$1 = state_12301;
var statearr_12370_12432 = state_12301__$1;
(statearr_12370_12432[(2)] = null);

(statearr_12370_12432[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (10))){
var inst_12181 = (state_12301[(14)]);
var inst_12183 = (state_12301[(15)]);
var inst_12191 = cljs.core._nth.call(null,inst_12181,inst_12183);
var inst_12192 = cljs.core.nth.call(null,inst_12191,(0),null);
var inst_12193 = cljs.core.nth.call(null,inst_12191,(1),null);
var state_12301__$1 = (function (){var statearr_12371 = state_12301;
(statearr_12371[(24)] = inst_12192);

return statearr_12371;
})();
if(cljs.core.truth_(inst_12193)){
var statearr_12372_12433 = state_12301__$1;
(statearr_12372_12433[(1)] = (13));

} else {
var statearr_12373_12434 = state_12301__$1;
(statearr_12373_12434[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (18))){
var inst_12228 = (state_12301[(2)]);
var state_12301__$1 = state_12301;
var statearr_12374_12435 = state_12301__$1;
(statearr_12374_12435[(2)] = inst_12228);

(statearr_12374_12435[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (42))){
var state_12301__$1 = state_12301;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12301__$1,(45),dchan);
} else {
if((state_val_12302 === (37))){
var inst_12270 = (state_12301[(22)]);
var inst_12261 = (state_12301[(23)]);
var inst_12171 = (state_12301[(11)]);
var inst_12270__$1 = cljs.core.first.call(null,inst_12261);
var inst_12271 = cljs.core.async.put_BANG_.call(null,inst_12270__$1,inst_12171,done);
var state_12301__$1 = (function (){var statearr_12375 = state_12301;
(statearr_12375[(22)] = inst_12270__$1);

return statearr_12375;
})();
if(cljs.core.truth_(inst_12271)){
var statearr_12376_12436 = state_12301__$1;
(statearr_12376_12436[(1)] = (39));

} else {
var statearr_12377_12437 = state_12301__$1;
(statearr_12377_12437[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12302 === (8))){
var inst_12182 = (state_12301[(13)]);
var inst_12183 = (state_12301[(15)]);
var inst_12185 = (inst_12183 < inst_12182);
var inst_12186 = inst_12185;
var state_12301__$1 = state_12301;
if(cljs.core.truth_(inst_12186)){
var statearr_12378_12438 = state_12301__$1;
(statearr_12378_12438[(1)] = (10));

} else {
var statearr_12379_12439 = state_12301__$1;
(statearr_12379_12439[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__11469__auto__ = null;
var cljs$core$async$mult_$_state_machine__11469__auto____0 = (function (){
var statearr_12380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12380[(0)] = cljs$core$async$mult_$_state_machine__11469__auto__);

(statearr_12380[(1)] = (1));

return statearr_12380;
});
var cljs$core$async$mult_$_state_machine__11469__auto____1 = (function (state_12301){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12301);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12381){var ex__11472__auto__ = e12381;
var statearr_12382_12440 = state_12301;
(statearr_12382_12440[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12301[(4)]))){
var statearr_12383_12441 = state_12301;
(statearr_12383_12441[(1)] = cljs.core.first.call(null,(state_12301[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12442 = state_12301;
state_12301 = G__12442;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11469__auto__ = function(state_12301){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11469__auto____1.call(this,state_12301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11469__auto____0;
cljs$core$async$mult_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11469__auto____1;
return cljs$core$async$mult_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12384 = f__11543__auto__.call(null);
(statearr_12384[(6)] = c__11542__auto___12385);

return statearr_12384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__12444 = arguments.length;
switch (G__12444) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_12446 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_12446.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_12447 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_12447.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_12448 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m);
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_12448.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_12449 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,state_map);
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_12449.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_12450 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,m,mode);
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_12450.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___12461 = arguments.length;
var i__4737__auto___12462 = (0);
while(true){
if((i__4737__auto___12462 < len__4736__auto___12461)){
args__4742__auto__.push((arguments[i__4737__auto___12462]));

var G__12463 = (i__4737__auto___12462 + (1));
i__4737__auto___12462 = G__12463;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__12455){
var map__12456 = p__12455;
var map__12456__$1 = (((((!((map__12456 == null))))?(((((map__12456.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12456.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__12456):map__12456);
var opts = map__12456__$1;
var statearr_12458_12464 = state;
(statearr_12458_12464[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_12459_12465 = state;
(statearr_12459_12465[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_12460_12466 = state;
(statearr_12460_12466[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq12451){
var G__12452 = cljs.core.first.call(null,seq12451);
var seq12451__$1 = cljs.core.next.call(null,seq12451);
var G__12453 = cljs.core.first.call(null,seq12451__$1);
var seq12451__$2 = cljs.core.next.call(null,seq12451__$1);
var G__12454 = cljs.core.first.call(null,seq12451__$2);
var seq12451__$3 = cljs.core.next.call(null,seq12451__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12452,G__12453,G__12454,seq12451__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(1)));
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12467 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12467 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta12468){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta12468 = meta12468;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12469,meta12468__$1){
var self__ = this;
var _12469__$1 = this;
return (new cljs.core.async.t_cljs$core$async12467(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta12468__$1));
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12469){
var self__ = this;
var _12469__$1 = this;
return self__.meta12468;
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async12467.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async12467.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta12468","meta12468",-1419091417,null)], null);
}));

(cljs.core.async.t_cljs$core$async12467.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12467.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12467");

(cljs.core.async.t_cljs$core$async12467.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async12467");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12467.
 */
cljs.core.async.__GT_t_cljs$core$async12467 = (function cljs$core$async$mix_$___GT_t_cljs$core$async12467(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12468){
return (new cljs.core.async.t_cljs$core$async12467(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta12468));
});

}

return (new cljs.core.async.t_cljs$core$async12467(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11542__auto___12632 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12571){
var state_val_12572 = (state_12571[(1)]);
if((state_val_12572 === (7))){
var inst_12486 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
var statearr_12573_12633 = state_12571__$1;
(statearr_12573_12633[(2)] = inst_12486);

(statearr_12573_12633[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (20))){
var inst_12498 = (state_12571[(7)]);
var state_12571__$1 = state_12571;
var statearr_12574_12634 = state_12571__$1;
(statearr_12574_12634[(2)] = inst_12498);

(statearr_12574_12634[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (27))){
var state_12571__$1 = state_12571;
var statearr_12575_12635 = state_12571__$1;
(statearr_12575_12635[(2)] = null);

(statearr_12575_12635[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (1))){
var inst_12473 = (state_12571[(8)]);
var inst_12473__$1 = calc_state.call(null);
var inst_12475 = (inst_12473__$1 == null);
var inst_12476 = cljs.core.not.call(null,inst_12475);
var state_12571__$1 = (function (){var statearr_12576 = state_12571;
(statearr_12576[(8)] = inst_12473__$1);

return statearr_12576;
})();
if(inst_12476){
var statearr_12577_12636 = state_12571__$1;
(statearr_12577_12636[(1)] = (2));

} else {
var statearr_12578_12637 = state_12571__$1;
(statearr_12578_12637[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (24))){
var inst_12545 = (state_12571[(9)]);
var inst_12531 = (state_12571[(10)]);
var inst_12522 = (state_12571[(11)]);
var inst_12545__$1 = inst_12522.call(null,inst_12531);
var state_12571__$1 = (function (){var statearr_12579 = state_12571;
(statearr_12579[(9)] = inst_12545__$1);

return statearr_12579;
})();
if(cljs.core.truth_(inst_12545__$1)){
var statearr_12580_12638 = state_12571__$1;
(statearr_12580_12638[(1)] = (29));

} else {
var statearr_12581_12639 = state_12571__$1;
(statearr_12581_12639[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (4))){
var inst_12489 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12489)){
var statearr_12582_12640 = state_12571__$1;
(statearr_12582_12640[(1)] = (8));

} else {
var statearr_12583_12641 = state_12571__$1;
(statearr_12583_12641[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (15))){
var inst_12516 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12516)){
var statearr_12584_12642 = state_12571__$1;
(statearr_12584_12642[(1)] = (19));

} else {
var statearr_12585_12643 = state_12571__$1;
(statearr_12585_12643[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (21))){
var inst_12521 = (state_12571[(12)]);
var inst_12521__$1 = (state_12571[(2)]);
var inst_12522 = cljs.core.get.call(null,inst_12521__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12523 = cljs.core.get.call(null,inst_12521__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12524 = cljs.core.get.call(null,inst_12521__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_12571__$1 = (function (){var statearr_12586 = state_12571;
(statearr_12586[(11)] = inst_12522);

(statearr_12586[(12)] = inst_12521__$1);

(statearr_12586[(13)] = inst_12523);

return statearr_12586;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_12571__$1,(22),inst_12524);
} else {
if((state_val_12572 === (31))){
var inst_12553 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12553)){
var statearr_12587_12644 = state_12571__$1;
(statearr_12587_12644[(1)] = (32));

} else {
var statearr_12588_12645 = state_12571__$1;
(statearr_12588_12645[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (32))){
var inst_12530 = (state_12571[(14)]);
var state_12571__$1 = state_12571;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12571__$1,(35),out,inst_12530);
} else {
if((state_val_12572 === (33))){
var inst_12521 = (state_12571[(12)]);
var inst_12498 = inst_12521;
var state_12571__$1 = (function (){var statearr_12589 = state_12571;
(statearr_12589[(7)] = inst_12498);

return statearr_12589;
})();
var statearr_12590_12646 = state_12571__$1;
(statearr_12590_12646[(2)] = null);

(statearr_12590_12646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (13))){
var inst_12498 = (state_12571[(7)]);
var inst_12505 = inst_12498.cljs$lang$protocol_mask$partition0$;
var inst_12506 = (inst_12505 & (64));
var inst_12507 = inst_12498.cljs$core$ISeq$;
var inst_12508 = (cljs.core.PROTOCOL_SENTINEL === inst_12507);
var inst_12509 = ((inst_12506) || (inst_12508));
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12509)){
var statearr_12591_12647 = state_12571__$1;
(statearr_12591_12647[(1)] = (16));

} else {
var statearr_12592_12648 = state_12571__$1;
(statearr_12592_12648[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (22))){
var inst_12530 = (state_12571[(14)]);
var inst_12531 = (state_12571[(10)]);
var inst_12529 = (state_12571[(2)]);
var inst_12530__$1 = cljs.core.nth.call(null,inst_12529,(0),null);
var inst_12531__$1 = cljs.core.nth.call(null,inst_12529,(1),null);
var inst_12532 = (inst_12530__$1 == null);
var inst_12533 = cljs.core._EQ_.call(null,inst_12531__$1,change);
var inst_12534 = ((inst_12532) || (inst_12533));
var state_12571__$1 = (function (){var statearr_12593 = state_12571;
(statearr_12593[(14)] = inst_12530__$1);

(statearr_12593[(10)] = inst_12531__$1);

return statearr_12593;
})();
if(cljs.core.truth_(inst_12534)){
var statearr_12594_12649 = state_12571__$1;
(statearr_12594_12649[(1)] = (23));

} else {
var statearr_12595_12650 = state_12571__$1;
(statearr_12595_12650[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (36))){
var inst_12521 = (state_12571[(12)]);
var inst_12498 = inst_12521;
var state_12571__$1 = (function (){var statearr_12596 = state_12571;
(statearr_12596[(7)] = inst_12498);

return statearr_12596;
})();
var statearr_12597_12651 = state_12571__$1;
(statearr_12597_12651[(2)] = null);

(statearr_12597_12651[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (29))){
var inst_12545 = (state_12571[(9)]);
var state_12571__$1 = state_12571;
var statearr_12598_12652 = state_12571__$1;
(statearr_12598_12652[(2)] = inst_12545);

(statearr_12598_12652[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (6))){
var state_12571__$1 = state_12571;
var statearr_12599_12653 = state_12571__$1;
(statearr_12599_12653[(2)] = false);

(statearr_12599_12653[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (28))){
var inst_12541 = (state_12571[(2)]);
var inst_12542 = calc_state.call(null);
var inst_12498 = inst_12542;
var state_12571__$1 = (function (){var statearr_12600 = state_12571;
(statearr_12600[(15)] = inst_12541);

(statearr_12600[(7)] = inst_12498);

return statearr_12600;
})();
var statearr_12601_12654 = state_12571__$1;
(statearr_12601_12654[(2)] = null);

(statearr_12601_12654[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (25))){
var inst_12567 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
var statearr_12602_12655 = state_12571__$1;
(statearr_12602_12655[(2)] = inst_12567);

(statearr_12602_12655[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (34))){
var inst_12565 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
var statearr_12603_12656 = state_12571__$1;
(statearr_12603_12656[(2)] = inst_12565);

(statearr_12603_12656[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (17))){
var state_12571__$1 = state_12571;
var statearr_12604_12657 = state_12571__$1;
(statearr_12604_12657[(2)] = false);

(statearr_12604_12657[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (3))){
var state_12571__$1 = state_12571;
var statearr_12605_12658 = state_12571__$1;
(statearr_12605_12658[(2)] = false);

(statearr_12605_12658[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (12))){
var inst_12569 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12571__$1,inst_12569);
} else {
if((state_val_12572 === (2))){
var inst_12473 = (state_12571[(8)]);
var inst_12478 = inst_12473.cljs$lang$protocol_mask$partition0$;
var inst_12479 = (inst_12478 & (64));
var inst_12480 = inst_12473.cljs$core$ISeq$;
var inst_12481 = (cljs.core.PROTOCOL_SENTINEL === inst_12480);
var inst_12482 = ((inst_12479) || (inst_12481));
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12482)){
var statearr_12606_12659 = state_12571__$1;
(statearr_12606_12659[(1)] = (5));

} else {
var statearr_12607_12660 = state_12571__$1;
(statearr_12607_12660[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (23))){
var inst_12530 = (state_12571[(14)]);
var inst_12536 = (inst_12530 == null);
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12536)){
var statearr_12608_12661 = state_12571__$1;
(statearr_12608_12661[(1)] = (26));

} else {
var statearr_12609_12662 = state_12571__$1;
(statearr_12609_12662[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (35))){
var inst_12556 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
if(cljs.core.truth_(inst_12556)){
var statearr_12610_12663 = state_12571__$1;
(statearr_12610_12663[(1)] = (36));

} else {
var statearr_12611_12664 = state_12571__$1;
(statearr_12611_12664[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (19))){
var inst_12498 = (state_12571[(7)]);
var inst_12518 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12498);
var state_12571__$1 = state_12571;
var statearr_12612_12665 = state_12571__$1;
(statearr_12612_12665[(2)] = inst_12518);

(statearr_12612_12665[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (11))){
var inst_12498 = (state_12571[(7)]);
var inst_12502 = (inst_12498 == null);
var inst_12503 = cljs.core.not.call(null,inst_12502);
var state_12571__$1 = state_12571;
if(inst_12503){
var statearr_12613_12666 = state_12571__$1;
(statearr_12613_12666[(1)] = (13));

} else {
var statearr_12614_12667 = state_12571__$1;
(statearr_12614_12667[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (9))){
var inst_12473 = (state_12571[(8)]);
var state_12571__$1 = state_12571;
var statearr_12615_12668 = state_12571__$1;
(statearr_12615_12668[(2)] = inst_12473);

(statearr_12615_12668[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (5))){
var state_12571__$1 = state_12571;
var statearr_12616_12669 = state_12571__$1;
(statearr_12616_12669[(2)] = true);

(statearr_12616_12669[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (14))){
var state_12571__$1 = state_12571;
var statearr_12617_12670 = state_12571__$1;
(statearr_12617_12670[(2)] = false);

(statearr_12617_12670[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (26))){
var inst_12531 = (state_12571[(10)]);
var inst_12538 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_12531);
var state_12571__$1 = state_12571;
var statearr_12618_12671 = state_12571__$1;
(statearr_12618_12671[(2)] = inst_12538);

(statearr_12618_12671[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (16))){
var state_12571__$1 = state_12571;
var statearr_12619_12672 = state_12571__$1;
(statearr_12619_12672[(2)] = true);

(statearr_12619_12672[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (38))){
var inst_12561 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
var statearr_12620_12673 = state_12571__$1;
(statearr_12620_12673[(2)] = inst_12561);

(statearr_12620_12673[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (30))){
var inst_12531 = (state_12571[(10)]);
var inst_12522 = (state_12571[(11)]);
var inst_12523 = (state_12571[(13)]);
var inst_12548 = cljs.core.empty_QMARK_.call(null,inst_12522);
var inst_12549 = inst_12523.call(null,inst_12531);
var inst_12550 = cljs.core.not.call(null,inst_12549);
var inst_12551 = ((inst_12548) && (inst_12550));
var state_12571__$1 = state_12571;
var statearr_12621_12674 = state_12571__$1;
(statearr_12621_12674[(2)] = inst_12551);

(statearr_12621_12674[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (10))){
var inst_12473 = (state_12571[(8)]);
var inst_12494 = (state_12571[(2)]);
var inst_12495 = cljs.core.get.call(null,inst_12494,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_12496 = cljs.core.get.call(null,inst_12494,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_12497 = cljs.core.get.call(null,inst_12494,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_12498 = inst_12473;
var state_12571__$1 = (function (){var statearr_12622 = state_12571;
(statearr_12622[(16)] = inst_12495);

(statearr_12622[(17)] = inst_12496);

(statearr_12622[(7)] = inst_12498);

(statearr_12622[(18)] = inst_12497);

return statearr_12622;
})();
var statearr_12623_12675 = state_12571__$1;
(statearr_12623_12675[(2)] = null);

(statearr_12623_12675[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (18))){
var inst_12513 = (state_12571[(2)]);
var state_12571__$1 = state_12571;
var statearr_12624_12676 = state_12571__$1;
(statearr_12624_12676[(2)] = inst_12513);

(statearr_12624_12676[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (37))){
var state_12571__$1 = state_12571;
var statearr_12625_12677 = state_12571__$1;
(statearr_12625_12677[(2)] = null);

(statearr_12625_12677[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12572 === (8))){
var inst_12473 = (state_12571[(8)]);
var inst_12491 = cljs.core.apply.call(null,cljs.core.hash_map,inst_12473);
var state_12571__$1 = state_12571;
var statearr_12626_12678 = state_12571__$1;
(statearr_12626_12678[(2)] = inst_12491);

(statearr_12626_12678[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__11469__auto__ = null;
var cljs$core$async$mix_$_state_machine__11469__auto____0 = (function (){
var statearr_12627 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12627[(0)] = cljs$core$async$mix_$_state_machine__11469__auto__);

(statearr_12627[(1)] = (1));

return statearr_12627;
});
var cljs$core$async$mix_$_state_machine__11469__auto____1 = (function (state_12571){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12628){var ex__11472__auto__ = e12628;
var statearr_12629_12679 = state_12571;
(statearr_12629_12679[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12571[(4)]))){
var statearr_12630_12680 = state_12571;
(statearr_12630_12680[(1)] = cljs.core.first.call(null,(state_12571[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12681 = state_12571;
state_12571 = G__12681;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11469__auto__ = function(state_12571){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11469__auto____1.call(this,state_12571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11469__auto____0;
cljs$core$async$mix_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11469__auto____1;
return cljs$core$async$mix_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12631 = f__11543__auto__.call(null);
(statearr_12631[(6)] = c__11542__auto___12632);

return statearr_12631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_12684 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_12684.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_12685 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v,ch);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_12685.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_12686 = (function() {
var G__12687 = null;
var G__12687__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__12687__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,p,v);
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__12687 = function(p,v){
switch(arguments.length){
case 1:
return G__12687__1.call(this,p);
case 2:
return G__12687__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__12687.cljs$core$IFn$_invoke$arity$1 = G__12687__1;
G__12687.cljs$core$IFn$_invoke$arity$2 = G__12687__2;
return G__12687;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__12683 = arguments.length;
switch (G__12683) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12686.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_12686.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__12691 = arguments.length;
switch (G__12691) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__12689_SHARP_){
if(cljs.core.truth_(p1__12689_SHARP_.call(null,topic))){
return p1__12689_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__12689_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async12692 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12692 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta12693){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta12693 = meta12693;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_12694,meta12693__$1){
var self__ = this;
var _12694__$1 = this;
return (new cljs.core.async.t_cljs$core$async12692(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta12693__$1));
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_12694){
var self__ = this;
var _12694__$1 = this;
return self__.meta12693;
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async12692.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async12692.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta12693","meta12693",815493163,null)], null);
}));

(cljs.core.async.t_cljs$core$async12692.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async12692.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12692");

(cljs.core.async.t_cljs$core$async12692.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async12692");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async12692.
 */
cljs.core.async.__GT_t_cljs$core$async12692 = (function cljs$core$async$__GT_t_cljs$core$async12692(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12693){
return (new cljs.core.async.t_cljs$core$async12692(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta12693));
});

}

return (new cljs.core.async.t_cljs$core$async12692(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11542__auto___12813 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12766){
var state_val_12767 = (state_12766[(1)]);
if((state_val_12767 === (7))){
var inst_12762 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12768_12814 = state_12766__$1;
(statearr_12768_12814[(2)] = inst_12762);

(statearr_12768_12814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (20))){
var state_12766__$1 = state_12766;
var statearr_12769_12815 = state_12766__$1;
(statearr_12769_12815[(2)] = null);

(statearr_12769_12815[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (1))){
var state_12766__$1 = state_12766;
var statearr_12770_12816 = state_12766__$1;
(statearr_12770_12816[(2)] = null);

(statearr_12770_12816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (24))){
var inst_12745 = (state_12766[(7)]);
var inst_12754 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_12745);
var state_12766__$1 = state_12766;
var statearr_12771_12817 = state_12766__$1;
(statearr_12771_12817[(2)] = inst_12754);

(statearr_12771_12817[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (4))){
var inst_12697 = (state_12766[(8)]);
var inst_12697__$1 = (state_12766[(2)]);
var inst_12698 = (inst_12697__$1 == null);
var state_12766__$1 = (function (){var statearr_12772 = state_12766;
(statearr_12772[(8)] = inst_12697__$1);

return statearr_12772;
})();
if(cljs.core.truth_(inst_12698)){
var statearr_12773_12818 = state_12766__$1;
(statearr_12773_12818[(1)] = (5));

} else {
var statearr_12774_12819 = state_12766__$1;
(statearr_12774_12819[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (15))){
var inst_12739 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12775_12820 = state_12766__$1;
(statearr_12775_12820[(2)] = inst_12739);

(statearr_12775_12820[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (21))){
var inst_12759 = (state_12766[(2)]);
var state_12766__$1 = (function (){var statearr_12776 = state_12766;
(statearr_12776[(9)] = inst_12759);

return statearr_12776;
})();
var statearr_12777_12821 = state_12766__$1;
(statearr_12777_12821[(2)] = null);

(statearr_12777_12821[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (13))){
var inst_12721 = (state_12766[(10)]);
var inst_12723 = cljs.core.chunked_seq_QMARK_.call(null,inst_12721);
var state_12766__$1 = state_12766;
if(inst_12723){
var statearr_12778_12822 = state_12766__$1;
(statearr_12778_12822[(1)] = (16));

} else {
var statearr_12779_12823 = state_12766__$1;
(statearr_12779_12823[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (22))){
var inst_12751 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
if(cljs.core.truth_(inst_12751)){
var statearr_12780_12824 = state_12766__$1;
(statearr_12780_12824[(1)] = (23));

} else {
var statearr_12781_12825 = state_12766__$1;
(statearr_12781_12825[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (6))){
var inst_12745 = (state_12766[(7)]);
var inst_12697 = (state_12766[(8)]);
var inst_12747 = (state_12766[(11)]);
var inst_12745__$1 = topic_fn.call(null,inst_12697);
var inst_12746 = cljs.core.deref.call(null,mults);
var inst_12747__$1 = cljs.core.get.call(null,inst_12746,inst_12745__$1);
var state_12766__$1 = (function (){var statearr_12782 = state_12766;
(statearr_12782[(7)] = inst_12745__$1);

(statearr_12782[(11)] = inst_12747__$1);

return statearr_12782;
})();
if(cljs.core.truth_(inst_12747__$1)){
var statearr_12783_12826 = state_12766__$1;
(statearr_12783_12826[(1)] = (19));

} else {
var statearr_12784_12827 = state_12766__$1;
(statearr_12784_12827[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (25))){
var inst_12756 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12785_12828 = state_12766__$1;
(statearr_12785_12828[(2)] = inst_12756);

(statearr_12785_12828[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (17))){
var inst_12721 = (state_12766[(10)]);
var inst_12730 = cljs.core.first.call(null,inst_12721);
var inst_12731 = cljs.core.async.muxch_STAR_.call(null,inst_12730);
var inst_12732 = cljs.core.async.close_BANG_.call(null,inst_12731);
var inst_12733 = cljs.core.next.call(null,inst_12721);
var inst_12707 = inst_12733;
var inst_12708 = null;
var inst_12709 = (0);
var inst_12710 = (0);
var state_12766__$1 = (function (){var statearr_12786 = state_12766;
(statearr_12786[(12)] = inst_12709);

(statearr_12786[(13)] = inst_12732);

(statearr_12786[(14)] = inst_12707);

(statearr_12786[(15)] = inst_12710);

(statearr_12786[(16)] = inst_12708);

return statearr_12786;
})();
var statearr_12787_12829 = state_12766__$1;
(statearr_12787_12829[(2)] = null);

(statearr_12787_12829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (3))){
var inst_12764 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12766__$1,inst_12764);
} else {
if((state_val_12767 === (12))){
var inst_12741 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12788_12830 = state_12766__$1;
(statearr_12788_12830[(2)] = inst_12741);

(statearr_12788_12830[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (2))){
var state_12766__$1 = state_12766;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12766__$1,(4),ch);
} else {
if((state_val_12767 === (23))){
var state_12766__$1 = state_12766;
var statearr_12789_12831 = state_12766__$1;
(statearr_12789_12831[(2)] = null);

(statearr_12789_12831[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (19))){
var inst_12697 = (state_12766[(8)]);
var inst_12747 = (state_12766[(11)]);
var inst_12749 = cljs.core.async.muxch_STAR_.call(null,inst_12747);
var state_12766__$1 = state_12766;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12766__$1,(22),inst_12749,inst_12697);
} else {
if((state_val_12767 === (11))){
var inst_12721 = (state_12766[(10)]);
var inst_12707 = (state_12766[(14)]);
var inst_12721__$1 = cljs.core.seq.call(null,inst_12707);
var state_12766__$1 = (function (){var statearr_12790 = state_12766;
(statearr_12790[(10)] = inst_12721__$1);

return statearr_12790;
})();
if(inst_12721__$1){
var statearr_12791_12832 = state_12766__$1;
(statearr_12791_12832[(1)] = (13));

} else {
var statearr_12792_12833 = state_12766__$1;
(statearr_12792_12833[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (9))){
var inst_12743 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12793_12834 = state_12766__$1;
(statearr_12793_12834[(2)] = inst_12743);

(statearr_12793_12834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (5))){
var inst_12704 = cljs.core.deref.call(null,mults);
var inst_12705 = cljs.core.vals.call(null,inst_12704);
var inst_12706 = cljs.core.seq.call(null,inst_12705);
var inst_12707 = inst_12706;
var inst_12708 = null;
var inst_12709 = (0);
var inst_12710 = (0);
var state_12766__$1 = (function (){var statearr_12794 = state_12766;
(statearr_12794[(12)] = inst_12709);

(statearr_12794[(14)] = inst_12707);

(statearr_12794[(15)] = inst_12710);

(statearr_12794[(16)] = inst_12708);

return statearr_12794;
})();
var statearr_12795_12835 = state_12766__$1;
(statearr_12795_12835[(2)] = null);

(statearr_12795_12835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (14))){
var state_12766__$1 = state_12766;
var statearr_12799_12836 = state_12766__$1;
(statearr_12799_12836[(2)] = null);

(statearr_12799_12836[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (16))){
var inst_12721 = (state_12766[(10)]);
var inst_12725 = cljs.core.chunk_first.call(null,inst_12721);
var inst_12726 = cljs.core.chunk_rest.call(null,inst_12721);
var inst_12727 = cljs.core.count.call(null,inst_12725);
var inst_12707 = inst_12726;
var inst_12708 = inst_12725;
var inst_12709 = inst_12727;
var inst_12710 = (0);
var state_12766__$1 = (function (){var statearr_12800 = state_12766;
(statearr_12800[(12)] = inst_12709);

(statearr_12800[(14)] = inst_12707);

(statearr_12800[(15)] = inst_12710);

(statearr_12800[(16)] = inst_12708);

return statearr_12800;
})();
var statearr_12801_12837 = state_12766__$1;
(statearr_12801_12837[(2)] = null);

(statearr_12801_12837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (10))){
var inst_12709 = (state_12766[(12)]);
var inst_12707 = (state_12766[(14)]);
var inst_12710 = (state_12766[(15)]);
var inst_12708 = (state_12766[(16)]);
var inst_12715 = cljs.core._nth.call(null,inst_12708,inst_12710);
var inst_12716 = cljs.core.async.muxch_STAR_.call(null,inst_12715);
var inst_12717 = cljs.core.async.close_BANG_.call(null,inst_12716);
var inst_12718 = (inst_12710 + (1));
var tmp12796 = inst_12709;
var tmp12797 = inst_12707;
var tmp12798 = inst_12708;
var inst_12707__$1 = tmp12797;
var inst_12708__$1 = tmp12798;
var inst_12709__$1 = tmp12796;
var inst_12710__$1 = inst_12718;
var state_12766__$1 = (function (){var statearr_12802 = state_12766;
(statearr_12802[(17)] = inst_12717);

(statearr_12802[(12)] = inst_12709__$1);

(statearr_12802[(14)] = inst_12707__$1);

(statearr_12802[(15)] = inst_12710__$1);

(statearr_12802[(16)] = inst_12708__$1);

return statearr_12802;
})();
var statearr_12803_12838 = state_12766__$1;
(statearr_12803_12838[(2)] = null);

(statearr_12803_12838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (18))){
var inst_12736 = (state_12766[(2)]);
var state_12766__$1 = state_12766;
var statearr_12804_12839 = state_12766__$1;
(statearr_12804_12839[(2)] = inst_12736);

(statearr_12804_12839[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12767 === (8))){
var inst_12709 = (state_12766[(12)]);
var inst_12710 = (state_12766[(15)]);
var inst_12712 = (inst_12710 < inst_12709);
var inst_12713 = inst_12712;
var state_12766__$1 = state_12766;
if(cljs.core.truth_(inst_12713)){
var statearr_12805_12840 = state_12766__$1;
(statearr_12805_12840[(1)] = (10));

} else {
var statearr_12806_12841 = state_12766__$1;
(statearr_12806_12841[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_12807 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12807[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_12807[(1)] = (1));

return statearr_12807;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_12766){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12766);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12808){var ex__11472__auto__ = e12808;
var statearr_12809_12842 = state_12766;
(statearr_12809_12842[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12766[(4)]))){
var statearr_12810_12843 = state_12766;
(statearr_12810_12843[(1)] = cljs.core.first.call(null,(state_12766[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12844 = state_12766;
state_12766 = G__12844;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_12766){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_12766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12811 = f__11543__auto__.call(null);
(statearr_12811[(6)] = c__11542__auto___12813);

return statearr_12811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__12846 = arguments.length;
switch (G__12846) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__12849 = arguments.length;
switch (G__12849) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__12852 = arguments.length;
switch (G__12852) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__11542__auto___12930 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12895){
var state_val_12896 = (state_12895[(1)]);
if((state_val_12896 === (7))){
var state_12895__$1 = state_12895;
var statearr_12897_12931 = state_12895__$1;
(statearr_12897_12931[(2)] = null);

(statearr_12897_12931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (1))){
var state_12895__$1 = state_12895;
var statearr_12898_12932 = state_12895__$1;
(statearr_12898_12932[(2)] = null);

(statearr_12898_12932[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (4))){
var inst_12856 = (state_12895[(7)]);
var inst_12855 = (state_12895[(8)]);
var inst_12858 = (inst_12856 < inst_12855);
var state_12895__$1 = state_12895;
if(cljs.core.truth_(inst_12858)){
var statearr_12899_12933 = state_12895__$1;
(statearr_12899_12933[(1)] = (6));

} else {
var statearr_12900_12934 = state_12895__$1;
(statearr_12900_12934[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (15))){
var inst_12881 = (state_12895[(9)]);
var inst_12886 = cljs.core.apply.call(null,f,inst_12881);
var state_12895__$1 = state_12895;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12895__$1,(17),out,inst_12886);
} else {
if((state_val_12896 === (13))){
var inst_12881 = (state_12895[(9)]);
var inst_12881__$1 = (state_12895[(2)]);
var inst_12882 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_12881__$1);
var state_12895__$1 = (function (){var statearr_12901 = state_12895;
(statearr_12901[(9)] = inst_12881__$1);

return statearr_12901;
})();
if(cljs.core.truth_(inst_12882)){
var statearr_12902_12935 = state_12895__$1;
(statearr_12902_12935[(1)] = (14));

} else {
var statearr_12903_12936 = state_12895__$1;
(statearr_12903_12936[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (6))){
var state_12895__$1 = state_12895;
var statearr_12904_12937 = state_12895__$1;
(statearr_12904_12937[(2)] = null);

(statearr_12904_12937[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (17))){
var inst_12888 = (state_12895[(2)]);
var state_12895__$1 = (function (){var statearr_12906 = state_12895;
(statearr_12906[(10)] = inst_12888);

return statearr_12906;
})();
var statearr_12907_12938 = state_12895__$1;
(statearr_12907_12938[(2)] = null);

(statearr_12907_12938[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (3))){
var inst_12893 = (state_12895[(2)]);
var state_12895__$1 = state_12895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12895__$1,inst_12893);
} else {
if((state_val_12896 === (12))){
var _ = (function (){var statearr_12908 = state_12895;
(statearr_12908[(4)] = cljs.core.rest.call(null,(state_12895[(4)])));

return statearr_12908;
})();
var state_12895__$1 = state_12895;
var ex12905 = (state_12895__$1[(2)]);
var statearr_12909_12939 = state_12895__$1;
(statearr_12909_12939[(5)] = ex12905);


if((ex12905 instanceof Object)){
var statearr_12910_12940 = state_12895__$1;
(statearr_12910_12940[(1)] = (11));

(statearr_12910_12940[(5)] = null);

} else {
throw ex12905;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (2))){
var inst_12854 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_12855 = cnt;
var inst_12856 = (0);
var state_12895__$1 = (function (){var statearr_12911 = state_12895;
(statearr_12911[(7)] = inst_12856);

(statearr_12911[(8)] = inst_12855);

(statearr_12911[(11)] = inst_12854);

return statearr_12911;
})();
var statearr_12912_12941 = state_12895__$1;
(statearr_12912_12941[(2)] = null);

(statearr_12912_12941[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (11))){
var inst_12860 = (state_12895[(2)]);
var inst_12861 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_12895__$1 = (function (){var statearr_12913 = state_12895;
(statearr_12913[(12)] = inst_12860);

return statearr_12913;
})();
var statearr_12914_12942 = state_12895__$1;
(statearr_12914_12942[(2)] = inst_12861);

(statearr_12914_12942[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (9))){
var inst_12856 = (state_12895[(7)]);
var _ = (function (){var statearr_12915 = state_12895;
(statearr_12915[(4)] = cljs.core.cons.call(null,(12),(state_12895[(4)])));

return statearr_12915;
})();
var inst_12867 = chs__$1.call(null,inst_12856);
var inst_12868 = done.call(null,inst_12856);
var inst_12869 = cljs.core.async.take_BANG_.call(null,inst_12867,inst_12868);
var ___$1 = (function (){var statearr_12916 = state_12895;
(statearr_12916[(4)] = cljs.core.rest.call(null,(state_12895[(4)])));

return statearr_12916;
})();
var state_12895__$1 = state_12895;
var statearr_12917_12943 = state_12895__$1;
(statearr_12917_12943[(2)] = inst_12869);

(statearr_12917_12943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (5))){
var inst_12879 = (state_12895[(2)]);
var state_12895__$1 = (function (){var statearr_12918 = state_12895;
(statearr_12918[(13)] = inst_12879);

return statearr_12918;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12895__$1,(13),dchan);
} else {
if((state_val_12896 === (14))){
var inst_12884 = cljs.core.async.close_BANG_.call(null,out);
var state_12895__$1 = state_12895;
var statearr_12919_12944 = state_12895__$1;
(statearr_12919_12944[(2)] = inst_12884);

(statearr_12919_12944[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (16))){
var inst_12891 = (state_12895[(2)]);
var state_12895__$1 = state_12895;
var statearr_12920_12945 = state_12895__$1;
(statearr_12920_12945[(2)] = inst_12891);

(statearr_12920_12945[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (10))){
var inst_12856 = (state_12895[(7)]);
var inst_12872 = (state_12895[(2)]);
var inst_12873 = (inst_12856 + (1));
var inst_12856__$1 = inst_12873;
var state_12895__$1 = (function (){var statearr_12921 = state_12895;
(statearr_12921[(7)] = inst_12856__$1);

(statearr_12921[(14)] = inst_12872);

return statearr_12921;
})();
var statearr_12922_12946 = state_12895__$1;
(statearr_12922_12946[(2)] = null);

(statearr_12922_12946[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12896 === (8))){
var inst_12877 = (state_12895[(2)]);
var state_12895__$1 = state_12895;
var statearr_12923_12947 = state_12895__$1;
(statearr_12923_12947[(2)] = inst_12877);

(statearr_12923_12947[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_12924 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12924[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_12924[(1)] = (1));

return statearr_12924;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_12895){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e12925){var ex__11472__auto__ = e12925;
var statearr_12926_12948 = state_12895;
(statearr_12926_12948[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12895[(4)]))){
var statearr_12927_12949 = state_12895;
(statearr_12927_12949[(1)] = cljs.core.first.call(null,(state_12895[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12950 = state_12895;
state_12895 = G__12950;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_12895){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_12895);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_12928 = f__11543__auto__.call(null);
(statearr_12928[(6)] = c__11542__auto___12930);

return statearr_12928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__12953 = arguments.length;
switch (G__12953) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13008 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_12985){
var state_val_12986 = (state_12985[(1)]);
if((state_val_12986 === (7))){
var inst_12964 = (state_12985[(7)]);
var inst_12965 = (state_12985[(8)]);
var inst_12964__$1 = (state_12985[(2)]);
var inst_12965__$1 = cljs.core.nth.call(null,inst_12964__$1,(0),null);
var inst_12966 = cljs.core.nth.call(null,inst_12964__$1,(1),null);
var inst_12967 = (inst_12965__$1 == null);
var state_12985__$1 = (function (){var statearr_12987 = state_12985;
(statearr_12987[(9)] = inst_12966);

(statearr_12987[(7)] = inst_12964__$1);

(statearr_12987[(8)] = inst_12965__$1);

return statearr_12987;
})();
if(cljs.core.truth_(inst_12967)){
var statearr_12988_13009 = state_12985__$1;
(statearr_12988_13009[(1)] = (8));

} else {
var statearr_12989_13010 = state_12985__$1;
(statearr_12989_13010[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (1))){
var inst_12954 = cljs.core.vec.call(null,chs);
var inst_12955 = inst_12954;
var state_12985__$1 = (function (){var statearr_12990 = state_12985;
(statearr_12990[(10)] = inst_12955);

return statearr_12990;
})();
var statearr_12991_13011 = state_12985__$1;
(statearr_12991_13011[(2)] = null);

(statearr_12991_13011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (4))){
var inst_12955 = (state_12985[(10)]);
var state_12985__$1 = state_12985;
return cljs.core.async.ioc_alts_BANG_.call(null,state_12985__$1,(7),inst_12955);
} else {
if((state_val_12986 === (6))){
var inst_12981 = (state_12985[(2)]);
var state_12985__$1 = state_12985;
var statearr_12992_13012 = state_12985__$1;
(statearr_12992_13012[(2)] = inst_12981);

(statearr_12992_13012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (3))){
var inst_12983 = (state_12985[(2)]);
var state_12985__$1 = state_12985;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12985__$1,inst_12983);
} else {
if((state_val_12986 === (2))){
var inst_12955 = (state_12985[(10)]);
var inst_12957 = cljs.core.count.call(null,inst_12955);
var inst_12958 = (inst_12957 > (0));
var state_12985__$1 = state_12985;
if(cljs.core.truth_(inst_12958)){
var statearr_12994_13013 = state_12985__$1;
(statearr_12994_13013[(1)] = (4));

} else {
var statearr_12995_13014 = state_12985__$1;
(statearr_12995_13014[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (11))){
var inst_12955 = (state_12985[(10)]);
var inst_12974 = (state_12985[(2)]);
var tmp12993 = inst_12955;
var inst_12955__$1 = tmp12993;
var state_12985__$1 = (function (){var statearr_12996 = state_12985;
(statearr_12996[(10)] = inst_12955__$1);

(statearr_12996[(11)] = inst_12974);

return statearr_12996;
})();
var statearr_12997_13015 = state_12985__$1;
(statearr_12997_13015[(2)] = null);

(statearr_12997_13015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (9))){
var inst_12965 = (state_12985[(8)]);
var state_12985__$1 = state_12985;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12985__$1,(11),out,inst_12965);
} else {
if((state_val_12986 === (5))){
var inst_12979 = cljs.core.async.close_BANG_.call(null,out);
var state_12985__$1 = state_12985;
var statearr_12998_13016 = state_12985__$1;
(statearr_12998_13016[(2)] = inst_12979);

(statearr_12998_13016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (10))){
var inst_12977 = (state_12985[(2)]);
var state_12985__$1 = state_12985;
var statearr_12999_13017 = state_12985__$1;
(statearr_12999_13017[(2)] = inst_12977);

(statearr_12999_13017[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12986 === (8))){
var inst_12966 = (state_12985[(9)]);
var inst_12964 = (state_12985[(7)]);
var inst_12965 = (state_12985[(8)]);
var inst_12955 = (state_12985[(10)]);
var inst_12969 = (function (){var cs = inst_12955;
var vec__12960 = inst_12964;
var v = inst_12965;
var c = inst_12966;
return (function (p1__12951_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__12951_SHARP_);
});
})();
var inst_12970 = cljs.core.filterv.call(null,inst_12969,inst_12955);
var inst_12955__$1 = inst_12970;
var state_12985__$1 = (function (){var statearr_13000 = state_12985;
(statearr_13000[(10)] = inst_12955__$1);

return statearr_13000;
})();
var statearr_13001_13018 = state_12985__$1;
(statearr_13001_13018[(2)] = null);

(statearr_13001_13018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13002 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13002[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13002[(1)] = (1));

return statearr_13002;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_12985){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_12985);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13003){var ex__11472__auto__ = e13003;
var statearr_13004_13019 = state_12985;
(statearr_13004_13019[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_12985[(4)]))){
var statearr_13005_13020 = state_12985;
(statearr_13005_13020[(1)] = cljs.core.first.call(null,(state_12985[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13021 = state_12985;
state_12985 = G__13021;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_12985){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_12985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13006 = f__11543__auto__.call(null);
(statearr_13006[(6)] = c__11542__auto___13008);

return statearr_13006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__13023 = arguments.length;
switch (G__13023) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13069 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13047){
var state_val_13048 = (state_13047[(1)]);
if((state_val_13048 === (7))){
var inst_13029 = (state_13047[(7)]);
var inst_13029__$1 = (state_13047[(2)]);
var inst_13030 = (inst_13029__$1 == null);
var inst_13031 = cljs.core.not.call(null,inst_13030);
var state_13047__$1 = (function (){var statearr_13049 = state_13047;
(statearr_13049[(7)] = inst_13029__$1);

return statearr_13049;
})();
if(inst_13031){
var statearr_13050_13070 = state_13047__$1;
(statearr_13050_13070[(1)] = (8));

} else {
var statearr_13051_13071 = state_13047__$1;
(statearr_13051_13071[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (1))){
var inst_13024 = (0);
var state_13047__$1 = (function (){var statearr_13052 = state_13047;
(statearr_13052[(8)] = inst_13024);

return statearr_13052;
})();
var statearr_13053_13072 = state_13047__$1;
(statearr_13053_13072[(2)] = null);

(statearr_13053_13072[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (4))){
var state_13047__$1 = state_13047;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13047__$1,(7),ch);
} else {
if((state_val_13048 === (6))){
var inst_13042 = (state_13047[(2)]);
var state_13047__$1 = state_13047;
var statearr_13054_13073 = state_13047__$1;
(statearr_13054_13073[(2)] = inst_13042);

(statearr_13054_13073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (3))){
var inst_13044 = (state_13047[(2)]);
var inst_13045 = cljs.core.async.close_BANG_.call(null,out);
var state_13047__$1 = (function (){var statearr_13055 = state_13047;
(statearr_13055[(9)] = inst_13044);

return statearr_13055;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13047__$1,inst_13045);
} else {
if((state_val_13048 === (2))){
var inst_13024 = (state_13047[(8)]);
var inst_13026 = (inst_13024 < n);
var state_13047__$1 = state_13047;
if(cljs.core.truth_(inst_13026)){
var statearr_13056_13074 = state_13047__$1;
(statearr_13056_13074[(1)] = (4));

} else {
var statearr_13057_13075 = state_13047__$1;
(statearr_13057_13075[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (11))){
var inst_13024 = (state_13047[(8)]);
var inst_13034 = (state_13047[(2)]);
var inst_13035 = (inst_13024 + (1));
var inst_13024__$1 = inst_13035;
var state_13047__$1 = (function (){var statearr_13058 = state_13047;
(statearr_13058[(8)] = inst_13024__$1);

(statearr_13058[(10)] = inst_13034);

return statearr_13058;
})();
var statearr_13059_13076 = state_13047__$1;
(statearr_13059_13076[(2)] = null);

(statearr_13059_13076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (9))){
var state_13047__$1 = state_13047;
var statearr_13060_13077 = state_13047__$1;
(statearr_13060_13077[(2)] = null);

(statearr_13060_13077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (5))){
var state_13047__$1 = state_13047;
var statearr_13061_13078 = state_13047__$1;
(statearr_13061_13078[(2)] = null);

(statearr_13061_13078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (10))){
var inst_13039 = (state_13047[(2)]);
var state_13047__$1 = state_13047;
var statearr_13062_13079 = state_13047__$1;
(statearr_13062_13079[(2)] = inst_13039);

(statearr_13062_13079[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13048 === (8))){
var inst_13029 = (state_13047[(7)]);
var state_13047__$1 = state_13047;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13047__$1,(11),out,inst_13029);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13063 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13063[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13063[(1)] = (1));

return statearr_13063;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_13047){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13047);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13064){var ex__11472__auto__ = e13064;
var statearr_13065_13080 = state_13047;
(statearr_13065_13080[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13047[(4)]))){
var statearr_13066_13081 = state_13047;
(statearr_13066_13081[(1)] = cljs.core.first.call(null,(state_13047[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13082 = state_13047;
state_13047 = G__13082;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_13047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_13047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13067 = f__11543__auto__.call(null);
(statearr_13067[(6)] = c__11542__auto___13069);

return statearr_13067;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13084 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13084 = (function (f,ch,meta13085){
this.f = f;
this.ch = ch;
this.meta13085 = meta13085;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13086,meta13085__$1){
var self__ = this;
var _13086__$1 = this;
return (new cljs.core.async.t_cljs$core$async13084(self__.f,self__.ch,meta13085__$1));
}));

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13086){
var self__ = this;
var _13086__$1 = this;
return self__.meta13085;
}));

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13087 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13087 = (function (f,ch,meta13085,_,fn1,meta13088){
this.f = f;
this.ch = ch;
this.meta13085 = meta13085;
this._ = _;
this.fn1 = fn1;
this.meta13088 = meta13088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13089,meta13088__$1){
var self__ = this;
var _13089__$1 = this;
return (new cljs.core.async.t_cljs$core$async13087(self__.f,self__.ch,self__.meta13085,self__._,self__.fn1,meta13088__$1));
}));

(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13089){
var self__ = this;
var _13089__$1 = this;
return self__.meta13088;
}));

(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async13087.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__13083_SHARP_){
return f1.call(null,(((p1__13083_SHARP_ == null))?null:self__.f.call(null,p1__13083_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async13087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13085","meta13085",-39262348,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async13084","cljs.core.async/t_cljs$core$async13084",289184204,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta13088","meta13088",-1618787400,null)], null);
}));

(cljs.core.async.t_cljs$core$async13087.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13087");

(cljs.core.async.t_cljs$core$async13087.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async13087");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13087.
 */
cljs.core.async.__GT_t_cljs$core$async13087 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13087(f__$1,ch__$1,meta13085__$1,___$2,fn1__$1,meta13088){
return (new cljs.core.async.t_cljs$core$async13087(f__$1,ch__$1,meta13085__$1,___$2,fn1__$1,meta13088));
});

}

return (new cljs.core.async.t_cljs$core$async13087(self__.f,self__.ch,self__.meta13085,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13084.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async13084.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13085","meta13085",-39262348,null)], null);
}));

(cljs.core.async.t_cljs$core$async13084.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13084.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13084");

(cljs.core.async.t_cljs$core$async13084.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async13084");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13084.
 */
cljs.core.async.__GT_t_cljs$core$async13084 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async13084(f__$1,ch__$1,meta13085){
return (new cljs.core.async.t_cljs$core$async13084(f__$1,ch__$1,meta13085));
});

}

return (new cljs.core.async.t_cljs$core$async13084(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13090 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13090 = (function (f,ch,meta13091){
this.f = f;
this.ch = ch;
this.meta13091 = meta13091;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13092,meta13091__$1){
var self__ = this;
var _13092__$1 = this;
return (new cljs.core.async.t_cljs$core$async13090(self__.f,self__.ch,meta13091__$1));
}));

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13092){
var self__ = this;
var _13092__$1 = this;
return self__.meta13091;
}));

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13090.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async13090.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13091","meta13091",89120892,null)], null);
}));

(cljs.core.async.t_cljs$core$async13090.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13090.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13090");

(cljs.core.async.t_cljs$core$async13090.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async13090");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13090.
 */
cljs.core.async.__GT_t_cljs$core$async13090 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async13090(f__$1,ch__$1,meta13091){
return (new cljs.core.async.t_cljs$core$async13090(f__$1,ch__$1,meta13091));
});

}

return (new cljs.core.async.t_cljs$core$async13090(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async13093 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13093 = (function (p,ch,meta13094){
this.p = p;
this.ch = ch;
this.meta13094 = meta13094;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13095,meta13094__$1){
var self__ = this;
var _13095__$1 = this;
return (new cljs.core.async.t_cljs$core$async13093(self__.p,self__.ch,meta13094__$1));
}));

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13095){
var self__ = this;
var _13095__$1 = this;
return self__.meta13094;
}));

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async13093.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async13093.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta13094","meta13094",-1008163235,null)], null);
}));

(cljs.core.async.t_cljs$core$async13093.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async13093.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13093");

(cljs.core.async.t_cljs$core$async13093.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"cljs.core.async/t_cljs$core$async13093");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async13093.
 */
cljs.core.async.__GT_t_cljs$core$async13093 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async13093(p__$1,ch__$1,meta13094){
return (new cljs.core.async.t_cljs$core$async13093(p__$1,ch__$1,meta13094));
});

}

return (new cljs.core.async.t_cljs$core$async13093(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__13097 = arguments.length;
switch (G__13097) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13138 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13118){
var state_val_13119 = (state_13118[(1)]);
if((state_val_13119 === (7))){
var inst_13114 = (state_13118[(2)]);
var state_13118__$1 = state_13118;
var statearr_13120_13139 = state_13118__$1;
(statearr_13120_13139[(2)] = inst_13114);

(statearr_13120_13139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (1))){
var state_13118__$1 = state_13118;
var statearr_13121_13140 = state_13118__$1;
(statearr_13121_13140[(2)] = null);

(statearr_13121_13140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (4))){
var inst_13100 = (state_13118[(7)]);
var inst_13100__$1 = (state_13118[(2)]);
var inst_13101 = (inst_13100__$1 == null);
var state_13118__$1 = (function (){var statearr_13122 = state_13118;
(statearr_13122[(7)] = inst_13100__$1);

return statearr_13122;
})();
if(cljs.core.truth_(inst_13101)){
var statearr_13123_13141 = state_13118__$1;
(statearr_13123_13141[(1)] = (5));

} else {
var statearr_13124_13142 = state_13118__$1;
(statearr_13124_13142[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (6))){
var inst_13100 = (state_13118[(7)]);
var inst_13105 = p.call(null,inst_13100);
var state_13118__$1 = state_13118;
if(cljs.core.truth_(inst_13105)){
var statearr_13125_13143 = state_13118__$1;
(statearr_13125_13143[(1)] = (8));

} else {
var statearr_13126_13144 = state_13118__$1;
(statearr_13126_13144[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (3))){
var inst_13116 = (state_13118[(2)]);
var state_13118__$1 = state_13118;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13118__$1,inst_13116);
} else {
if((state_val_13119 === (2))){
var state_13118__$1 = state_13118;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13118__$1,(4),ch);
} else {
if((state_val_13119 === (11))){
var inst_13108 = (state_13118[(2)]);
var state_13118__$1 = state_13118;
var statearr_13127_13145 = state_13118__$1;
(statearr_13127_13145[(2)] = inst_13108);

(statearr_13127_13145[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (9))){
var state_13118__$1 = state_13118;
var statearr_13128_13146 = state_13118__$1;
(statearr_13128_13146[(2)] = null);

(statearr_13128_13146[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (5))){
var inst_13103 = cljs.core.async.close_BANG_.call(null,out);
var state_13118__$1 = state_13118;
var statearr_13129_13147 = state_13118__$1;
(statearr_13129_13147[(2)] = inst_13103);

(statearr_13129_13147[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (10))){
var inst_13111 = (state_13118[(2)]);
var state_13118__$1 = (function (){var statearr_13130 = state_13118;
(statearr_13130[(8)] = inst_13111);

return statearr_13130;
})();
var statearr_13131_13148 = state_13118__$1;
(statearr_13131_13148[(2)] = null);

(statearr_13131_13148[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13119 === (8))){
var inst_13100 = (state_13118[(7)]);
var state_13118__$1 = state_13118;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13118__$1,(11),out,inst_13100);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13132 = [null,null,null,null,null,null,null,null,null];
(statearr_13132[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13132[(1)] = (1));

return statearr_13132;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_13118){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13118);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13133){var ex__11472__auto__ = e13133;
var statearr_13134_13149 = state_13118;
(statearr_13134_13149[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13118[(4)]))){
var statearr_13135_13150 = state_13118;
(statearr_13135_13150[(1)] = cljs.core.first.call(null,(state_13118[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13151 = state_13118;
state_13118 = G__13151;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_13118){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_13118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13136 = f__11543__auto__.call(null);
(statearr_13136[(6)] = c__11542__auto___13138);

return statearr_13136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__13153 = arguments.length;
switch (G__13153) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13216){
var state_val_13217 = (state_13216[(1)]);
if((state_val_13217 === (7))){
var inst_13212 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
var statearr_13218_13257 = state_13216__$1;
(statearr_13218_13257[(2)] = inst_13212);

(statearr_13218_13257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (20))){
var inst_13182 = (state_13216[(7)]);
var inst_13193 = (state_13216[(2)]);
var inst_13194 = cljs.core.next.call(null,inst_13182);
var inst_13168 = inst_13194;
var inst_13169 = null;
var inst_13170 = (0);
var inst_13171 = (0);
var state_13216__$1 = (function (){var statearr_13219 = state_13216;
(statearr_13219[(8)] = inst_13169);

(statearr_13219[(9)] = inst_13193);

(statearr_13219[(10)] = inst_13170);

(statearr_13219[(11)] = inst_13168);

(statearr_13219[(12)] = inst_13171);

return statearr_13219;
})();
var statearr_13220_13258 = state_13216__$1;
(statearr_13220_13258[(2)] = null);

(statearr_13220_13258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (1))){
var state_13216__$1 = state_13216;
var statearr_13221_13259 = state_13216__$1;
(statearr_13221_13259[(2)] = null);

(statearr_13221_13259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (4))){
var inst_13157 = (state_13216[(13)]);
var inst_13157__$1 = (state_13216[(2)]);
var inst_13158 = (inst_13157__$1 == null);
var state_13216__$1 = (function (){var statearr_13222 = state_13216;
(statearr_13222[(13)] = inst_13157__$1);

return statearr_13222;
})();
if(cljs.core.truth_(inst_13158)){
var statearr_13223_13260 = state_13216__$1;
(statearr_13223_13260[(1)] = (5));

} else {
var statearr_13224_13261 = state_13216__$1;
(statearr_13224_13261[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (15))){
var state_13216__$1 = state_13216;
var statearr_13228_13262 = state_13216__$1;
(statearr_13228_13262[(2)] = null);

(statearr_13228_13262[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (21))){
var state_13216__$1 = state_13216;
var statearr_13229_13263 = state_13216__$1;
(statearr_13229_13263[(2)] = null);

(statearr_13229_13263[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (13))){
var inst_13169 = (state_13216[(8)]);
var inst_13170 = (state_13216[(10)]);
var inst_13168 = (state_13216[(11)]);
var inst_13171 = (state_13216[(12)]);
var inst_13178 = (state_13216[(2)]);
var inst_13179 = (inst_13171 + (1));
var tmp13225 = inst_13169;
var tmp13226 = inst_13170;
var tmp13227 = inst_13168;
var inst_13168__$1 = tmp13227;
var inst_13169__$1 = tmp13225;
var inst_13170__$1 = tmp13226;
var inst_13171__$1 = inst_13179;
var state_13216__$1 = (function (){var statearr_13230 = state_13216;
(statearr_13230[(8)] = inst_13169__$1);

(statearr_13230[(10)] = inst_13170__$1);

(statearr_13230[(11)] = inst_13168__$1);

(statearr_13230[(14)] = inst_13178);

(statearr_13230[(12)] = inst_13171__$1);

return statearr_13230;
})();
var statearr_13231_13264 = state_13216__$1;
(statearr_13231_13264[(2)] = null);

(statearr_13231_13264[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (22))){
var state_13216__$1 = state_13216;
var statearr_13232_13265 = state_13216__$1;
(statearr_13232_13265[(2)] = null);

(statearr_13232_13265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (6))){
var inst_13157 = (state_13216[(13)]);
var inst_13166 = f.call(null,inst_13157);
var inst_13167 = cljs.core.seq.call(null,inst_13166);
var inst_13168 = inst_13167;
var inst_13169 = null;
var inst_13170 = (0);
var inst_13171 = (0);
var state_13216__$1 = (function (){var statearr_13233 = state_13216;
(statearr_13233[(8)] = inst_13169);

(statearr_13233[(10)] = inst_13170);

(statearr_13233[(11)] = inst_13168);

(statearr_13233[(12)] = inst_13171);

return statearr_13233;
})();
var statearr_13234_13266 = state_13216__$1;
(statearr_13234_13266[(2)] = null);

(statearr_13234_13266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (17))){
var inst_13182 = (state_13216[(7)]);
var inst_13186 = cljs.core.chunk_first.call(null,inst_13182);
var inst_13187 = cljs.core.chunk_rest.call(null,inst_13182);
var inst_13188 = cljs.core.count.call(null,inst_13186);
var inst_13168 = inst_13187;
var inst_13169 = inst_13186;
var inst_13170 = inst_13188;
var inst_13171 = (0);
var state_13216__$1 = (function (){var statearr_13235 = state_13216;
(statearr_13235[(8)] = inst_13169);

(statearr_13235[(10)] = inst_13170);

(statearr_13235[(11)] = inst_13168);

(statearr_13235[(12)] = inst_13171);

return statearr_13235;
})();
var statearr_13236_13267 = state_13216__$1;
(statearr_13236_13267[(2)] = null);

(statearr_13236_13267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (3))){
var inst_13214 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13216__$1,inst_13214);
} else {
if((state_val_13217 === (12))){
var inst_13202 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
var statearr_13237_13268 = state_13216__$1;
(statearr_13237_13268[(2)] = inst_13202);

(statearr_13237_13268[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (2))){
var state_13216__$1 = state_13216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13216__$1,(4),in$);
} else {
if((state_val_13217 === (23))){
var inst_13210 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
var statearr_13238_13269 = state_13216__$1;
(statearr_13238_13269[(2)] = inst_13210);

(statearr_13238_13269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (19))){
var inst_13197 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
var statearr_13239_13270 = state_13216__$1;
(statearr_13239_13270[(2)] = inst_13197);

(statearr_13239_13270[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (11))){
var inst_13182 = (state_13216[(7)]);
var inst_13168 = (state_13216[(11)]);
var inst_13182__$1 = cljs.core.seq.call(null,inst_13168);
var state_13216__$1 = (function (){var statearr_13240 = state_13216;
(statearr_13240[(7)] = inst_13182__$1);

return statearr_13240;
})();
if(inst_13182__$1){
var statearr_13241_13271 = state_13216__$1;
(statearr_13241_13271[(1)] = (14));

} else {
var statearr_13242_13272 = state_13216__$1;
(statearr_13242_13272[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (9))){
var inst_13204 = (state_13216[(2)]);
var inst_13205 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_13216__$1 = (function (){var statearr_13243 = state_13216;
(statearr_13243[(15)] = inst_13204);

return statearr_13243;
})();
if(cljs.core.truth_(inst_13205)){
var statearr_13244_13273 = state_13216__$1;
(statearr_13244_13273[(1)] = (21));

} else {
var statearr_13245_13274 = state_13216__$1;
(statearr_13245_13274[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (5))){
var inst_13160 = cljs.core.async.close_BANG_.call(null,out);
var state_13216__$1 = state_13216;
var statearr_13246_13275 = state_13216__$1;
(statearr_13246_13275[(2)] = inst_13160);

(statearr_13246_13275[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (14))){
var inst_13182 = (state_13216[(7)]);
var inst_13184 = cljs.core.chunked_seq_QMARK_.call(null,inst_13182);
var state_13216__$1 = state_13216;
if(inst_13184){
var statearr_13247_13276 = state_13216__$1;
(statearr_13247_13276[(1)] = (17));

} else {
var statearr_13248_13277 = state_13216__$1;
(statearr_13248_13277[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (16))){
var inst_13200 = (state_13216[(2)]);
var state_13216__$1 = state_13216;
var statearr_13249_13278 = state_13216__$1;
(statearr_13249_13278[(2)] = inst_13200);

(statearr_13249_13278[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13217 === (10))){
var inst_13169 = (state_13216[(8)]);
var inst_13171 = (state_13216[(12)]);
var inst_13176 = cljs.core._nth.call(null,inst_13169,inst_13171);
var state_13216__$1 = state_13216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13216__$1,(13),out,inst_13176);
} else {
if((state_val_13217 === (18))){
var inst_13182 = (state_13216[(7)]);
var inst_13191 = cljs.core.first.call(null,inst_13182);
var state_13216__$1 = state_13216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13216__$1,(20),out,inst_13191);
} else {
if((state_val_13217 === (8))){
var inst_13170 = (state_13216[(10)]);
var inst_13171 = (state_13216[(12)]);
var inst_13173 = (inst_13171 < inst_13170);
var inst_13174 = inst_13173;
var state_13216__$1 = state_13216;
if(cljs.core.truth_(inst_13174)){
var statearr_13250_13279 = state_13216__$1;
(statearr_13250_13279[(1)] = (10));

} else {
var statearr_13251_13280 = state_13216__$1;
(statearr_13251_13280[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____0 = (function (){
var statearr_13252 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13252[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__);

(statearr_13252[(1)] = (1));

return statearr_13252;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____1 = (function (state_13216){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13253){var ex__11472__auto__ = e13253;
var statearr_13254_13281 = state_13216;
(statearr_13254_13281[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13216[(4)]))){
var statearr_13255_13282 = state_13216;
(statearr_13255_13282[(1)] = cljs.core.first.call(null,(state_13216[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13283 = state_13216;
state_13216 = G__13283;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__ = function(state_13216){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____1.call(this,state_13216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11469__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13256 = f__11543__auto__.call(null);
(statearr_13256[(6)] = c__11542__auto__);

return statearr_13256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__13285 = arguments.length;
switch (G__13285) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__13288 = arguments.length;
switch (G__13288) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__13291 = arguments.length;
switch (G__13291) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13315){
var state_val_13316 = (state_13315[(1)]);
if((state_val_13316 === (7))){
var inst_13310 = (state_13315[(2)]);
var state_13315__$1 = state_13315;
var statearr_13317_13340 = state_13315__$1;
(statearr_13317_13340[(2)] = inst_13310);

(statearr_13317_13340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (1))){
var inst_13292 = null;
var state_13315__$1 = (function (){var statearr_13318 = state_13315;
(statearr_13318[(7)] = inst_13292);

return statearr_13318;
})();
var statearr_13319_13341 = state_13315__$1;
(statearr_13319_13341[(2)] = null);

(statearr_13319_13341[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (4))){
var inst_13295 = (state_13315[(8)]);
var inst_13295__$1 = (state_13315[(2)]);
var inst_13296 = (inst_13295__$1 == null);
var inst_13297 = cljs.core.not.call(null,inst_13296);
var state_13315__$1 = (function (){var statearr_13320 = state_13315;
(statearr_13320[(8)] = inst_13295__$1);

return statearr_13320;
})();
if(inst_13297){
var statearr_13321_13342 = state_13315__$1;
(statearr_13321_13342[(1)] = (5));

} else {
var statearr_13322_13343 = state_13315__$1;
(statearr_13322_13343[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (6))){
var state_13315__$1 = state_13315;
var statearr_13323_13344 = state_13315__$1;
(statearr_13323_13344[(2)] = null);

(statearr_13323_13344[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (3))){
var inst_13312 = (state_13315[(2)]);
var inst_13313 = cljs.core.async.close_BANG_.call(null,out);
var state_13315__$1 = (function (){var statearr_13324 = state_13315;
(statearr_13324[(9)] = inst_13312);

return statearr_13324;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13315__$1,inst_13313);
} else {
if((state_val_13316 === (2))){
var state_13315__$1 = state_13315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13315__$1,(4),ch);
} else {
if((state_val_13316 === (11))){
var inst_13295 = (state_13315[(8)]);
var inst_13304 = (state_13315[(2)]);
var inst_13292 = inst_13295;
var state_13315__$1 = (function (){var statearr_13325 = state_13315;
(statearr_13325[(10)] = inst_13304);

(statearr_13325[(7)] = inst_13292);

return statearr_13325;
})();
var statearr_13326_13345 = state_13315__$1;
(statearr_13326_13345[(2)] = null);

(statearr_13326_13345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (9))){
var inst_13295 = (state_13315[(8)]);
var state_13315__$1 = state_13315;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13315__$1,(11),out,inst_13295);
} else {
if((state_val_13316 === (5))){
var inst_13295 = (state_13315[(8)]);
var inst_13292 = (state_13315[(7)]);
var inst_13299 = cljs.core._EQ_.call(null,inst_13295,inst_13292);
var state_13315__$1 = state_13315;
if(inst_13299){
var statearr_13328_13346 = state_13315__$1;
(statearr_13328_13346[(1)] = (8));

} else {
var statearr_13329_13347 = state_13315__$1;
(statearr_13329_13347[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (10))){
var inst_13307 = (state_13315[(2)]);
var state_13315__$1 = state_13315;
var statearr_13330_13348 = state_13315__$1;
(statearr_13330_13348[(2)] = inst_13307);

(statearr_13330_13348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13316 === (8))){
var inst_13292 = (state_13315[(7)]);
var tmp13327 = inst_13292;
var inst_13292__$1 = tmp13327;
var state_13315__$1 = (function (){var statearr_13331 = state_13315;
(statearr_13331[(7)] = inst_13292__$1);

return statearr_13331;
})();
var statearr_13332_13349 = state_13315__$1;
(statearr_13332_13349[(2)] = null);

(statearr_13332_13349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13333 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_13333[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13333[(1)] = (1));

return statearr_13333;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_13315){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13334){var ex__11472__auto__ = e13334;
var statearr_13335_13350 = state_13315;
(statearr_13335_13350[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13315[(4)]))){
var statearr_13336_13351 = state_13315;
(statearr_13336_13351[(1)] = cljs.core.first.call(null,(state_13315[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13352 = state_13315;
state_13315 = G__13352;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_13315){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_13315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13337 = f__11543__auto__.call(null);
(statearr_13337[(6)] = c__11542__auto___13339);

return statearr_13337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__13354 = arguments.length;
switch (G__13354) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13421 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13392){
var state_val_13393 = (state_13392[(1)]);
if((state_val_13393 === (7))){
var inst_13388 = (state_13392[(2)]);
var state_13392__$1 = state_13392;
var statearr_13394_13422 = state_13392__$1;
(statearr_13394_13422[(2)] = inst_13388);

(statearr_13394_13422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (1))){
var inst_13355 = (new Array(n));
var inst_13356 = inst_13355;
var inst_13357 = (0);
var state_13392__$1 = (function (){var statearr_13395 = state_13392;
(statearr_13395[(7)] = inst_13356);

(statearr_13395[(8)] = inst_13357);

return statearr_13395;
})();
var statearr_13396_13423 = state_13392__$1;
(statearr_13396_13423[(2)] = null);

(statearr_13396_13423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (4))){
var inst_13360 = (state_13392[(9)]);
var inst_13360__$1 = (state_13392[(2)]);
var inst_13361 = (inst_13360__$1 == null);
var inst_13362 = cljs.core.not.call(null,inst_13361);
var state_13392__$1 = (function (){var statearr_13397 = state_13392;
(statearr_13397[(9)] = inst_13360__$1);

return statearr_13397;
})();
if(inst_13362){
var statearr_13398_13424 = state_13392__$1;
(statearr_13398_13424[(1)] = (5));

} else {
var statearr_13399_13425 = state_13392__$1;
(statearr_13399_13425[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (15))){
var inst_13382 = (state_13392[(2)]);
var state_13392__$1 = state_13392;
var statearr_13400_13426 = state_13392__$1;
(statearr_13400_13426[(2)] = inst_13382);

(statearr_13400_13426[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (13))){
var state_13392__$1 = state_13392;
var statearr_13401_13427 = state_13392__$1;
(statearr_13401_13427[(2)] = null);

(statearr_13401_13427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (6))){
var inst_13357 = (state_13392[(8)]);
var inst_13378 = (inst_13357 > (0));
var state_13392__$1 = state_13392;
if(cljs.core.truth_(inst_13378)){
var statearr_13402_13428 = state_13392__$1;
(statearr_13402_13428[(1)] = (12));

} else {
var statearr_13403_13429 = state_13392__$1;
(statearr_13403_13429[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (3))){
var inst_13390 = (state_13392[(2)]);
var state_13392__$1 = state_13392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13392__$1,inst_13390);
} else {
if((state_val_13393 === (12))){
var inst_13356 = (state_13392[(7)]);
var inst_13380 = cljs.core.vec.call(null,inst_13356);
var state_13392__$1 = state_13392;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13392__$1,(15),out,inst_13380);
} else {
if((state_val_13393 === (2))){
var state_13392__$1 = state_13392;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13392__$1,(4),ch);
} else {
if((state_val_13393 === (11))){
var inst_13372 = (state_13392[(2)]);
var inst_13373 = (new Array(n));
var inst_13356 = inst_13373;
var inst_13357 = (0);
var state_13392__$1 = (function (){var statearr_13404 = state_13392;
(statearr_13404[(7)] = inst_13356);

(statearr_13404[(10)] = inst_13372);

(statearr_13404[(8)] = inst_13357);

return statearr_13404;
})();
var statearr_13405_13430 = state_13392__$1;
(statearr_13405_13430[(2)] = null);

(statearr_13405_13430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (9))){
var inst_13356 = (state_13392[(7)]);
var inst_13370 = cljs.core.vec.call(null,inst_13356);
var state_13392__$1 = state_13392;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13392__$1,(11),out,inst_13370);
} else {
if((state_val_13393 === (5))){
var inst_13356 = (state_13392[(7)]);
var inst_13365 = (state_13392[(11)]);
var inst_13357 = (state_13392[(8)]);
var inst_13360 = (state_13392[(9)]);
var inst_13364 = (inst_13356[inst_13357] = inst_13360);
var inst_13365__$1 = (inst_13357 + (1));
var inst_13366 = (inst_13365__$1 < n);
var state_13392__$1 = (function (){var statearr_13406 = state_13392;
(statearr_13406[(11)] = inst_13365__$1);

(statearr_13406[(12)] = inst_13364);

return statearr_13406;
})();
if(cljs.core.truth_(inst_13366)){
var statearr_13407_13431 = state_13392__$1;
(statearr_13407_13431[(1)] = (8));

} else {
var statearr_13408_13432 = state_13392__$1;
(statearr_13408_13432[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (14))){
var inst_13385 = (state_13392[(2)]);
var inst_13386 = cljs.core.async.close_BANG_.call(null,out);
var state_13392__$1 = (function (){var statearr_13410 = state_13392;
(statearr_13410[(13)] = inst_13385);

return statearr_13410;
})();
var statearr_13411_13433 = state_13392__$1;
(statearr_13411_13433[(2)] = inst_13386);

(statearr_13411_13433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (10))){
var inst_13376 = (state_13392[(2)]);
var state_13392__$1 = state_13392;
var statearr_13412_13434 = state_13392__$1;
(statearr_13412_13434[(2)] = inst_13376);

(statearr_13412_13434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13393 === (8))){
var inst_13356 = (state_13392[(7)]);
var inst_13365 = (state_13392[(11)]);
var tmp13409 = inst_13356;
var inst_13356__$1 = tmp13409;
var inst_13357 = inst_13365;
var state_13392__$1 = (function (){var statearr_13413 = state_13392;
(statearr_13413[(7)] = inst_13356__$1);

(statearr_13413[(8)] = inst_13357);

return statearr_13413;
})();
var statearr_13414_13435 = state_13392__$1;
(statearr_13414_13435[(2)] = null);

(statearr_13414_13435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13415 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13415[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13415[(1)] = (1));

return statearr_13415;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_13392){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13416){var ex__11472__auto__ = e13416;
var statearr_13417_13436 = state_13392;
(statearr_13417_13436[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13392[(4)]))){
var statearr_13418_13437 = state_13392;
(statearr_13418_13437[(1)] = cljs.core.first.call(null,(state_13392[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13438 = state_13392;
state_13392 = G__13438;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_13392){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_13392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13419 = f__11543__auto__.call(null);
(statearr_13419[(6)] = c__11542__auto___13421);

return statearr_13419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__13440 = arguments.length;
switch (G__13440) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11542__auto___13511 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_13482){
var state_val_13483 = (state_13482[(1)]);
if((state_val_13483 === (7))){
var inst_13478 = (state_13482[(2)]);
var state_13482__$1 = state_13482;
var statearr_13484_13512 = state_13482__$1;
(statearr_13484_13512[(2)] = inst_13478);

(statearr_13484_13512[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (1))){
var inst_13441 = [];
var inst_13442 = inst_13441;
var inst_13443 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_13482__$1 = (function (){var statearr_13485 = state_13482;
(statearr_13485[(7)] = inst_13443);

(statearr_13485[(8)] = inst_13442);

return statearr_13485;
})();
var statearr_13486_13513 = state_13482__$1;
(statearr_13486_13513[(2)] = null);

(statearr_13486_13513[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (4))){
var inst_13446 = (state_13482[(9)]);
var inst_13446__$1 = (state_13482[(2)]);
var inst_13447 = (inst_13446__$1 == null);
var inst_13448 = cljs.core.not.call(null,inst_13447);
var state_13482__$1 = (function (){var statearr_13487 = state_13482;
(statearr_13487[(9)] = inst_13446__$1);

return statearr_13487;
})();
if(inst_13448){
var statearr_13488_13514 = state_13482__$1;
(statearr_13488_13514[(1)] = (5));

} else {
var statearr_13489_13515 = state_13482__$1;
(statearr_13489_13515[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (15))){
var inst_13472 = (state_13482[(2)]);
var state_13482__$1 = state_13482;
var statearr_13490_13516 = state_13482__$1;
(statearr_13490_13516[(2)] = inst_13472);

(statearr_13490_13516[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (13))){
var state_13482__$1 = state_13482;
var statearr_13491_13517 = state_13482__$1;
(statearr_13491_13517[(2)] = null);

(statearr_13491_13517[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (6))){
var inst_13442 = (state_13482[(8)]);
var inst_13467 = inst_13442.length;
var inst_13468 = (inst_13467 > (0));
var state_13482__$1 = state_13482;
if(cljs.core.truth_(inst_13468)){
var statearr_13492_13518 = state_13482__$1;
(statearr_13492_13518[(1)] = (12));

} else {
var statearr_13493_13519 = state_13482__$1;
(statearr_13493_13519[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (3))){
var inst_13480 = (state_13482[(2)]);
var state_13482__$1 = state_13482;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13482__$1,inst_13480);
} else {
if((state_val_13483 === (12))){
var inst_13442 = (state_13482[(8)]);
var inst_13470 = cljs.core.vec.call(null,inst_13442);
var state_13482__$1 = state_13482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13482__$1,(15),out,inst_13470);
} else {
if((state_val_13483 === (2))){
var state_13482__$1 = state_13482;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13482__$1,(4),ch);
} else {
if((state_val_13483 === (11))){
var inst_13450 = (state_13482[(10)]);
var inst_13446 = (state_13482[(9)]);
var inst_13460 = (state_13482[(2)]);
var inst_13461 = [];
var inst_13462 = inst_13461.push(inst_13446);
var inst_13442 = inst_13461;
var inst_13443 = inst_13450;
var state_13482__$1 = (function (){var statearr_13494 = state_13482;
(statearr_13494[(11)] = inst_13462);

(statearr_13494[(7)] = inst_13443);

(statearr_13494[(12)] = inst_13460);

(statearr_13494[(8)] = inst_13442);

return statearr_13494;
})();
var statearr_13495_13520 = state_13482__$1;
(statearr_13495_13520[(2)] = null);

(statearr_13495_13520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (9))){
var inst_13442 = (state_13482[(8)]);
var inst_13458 = cljs.core.vec.call(null,inst_13442);
var state_13482__$1 = state_13482;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13482__$1,(11),out,inst_13458);
} else {
if((state_val_13483 === (5))){
var inst_13450 = (state_13482[(10)]);
var inst_13443 = (state_13482[(7)]);
var inst_13446 = (state_13482[(9)]);
var inst_13450__$1 = f.call(null,inst_13446);
var inst_13451 = cljs.core._EQ_.call(null,inst_13450__$1,inst_13443);
var inst_13452 = cljs.core.keyword_identical_QMARK_.call(null,inst_13443,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_13453 = ((inst_13451) || (inst_13452));
var state_13482__$1 = (function (){var statearr_13496 = state_13482;
(statearr_13496[(10)] = inst_13450__$1);

return statearr_13496;
})();
if(cljs.core.truth_(inst_13453)){
var statearr_13497_13521 = state_13482__$1;
(statearr_13497_13521[(1)] = (8));

} else {
var statearr_13498_13522 = state_13482__$1;
(statearr_13498_13522[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (14))){
var inst_13475 = (state_13482[(2)]);
var inst_13476 = cljs.core.async.close_BANG_.call(null,out);
var state_13482__$1 = (function (){var statearr_13500 = state_13482;
(statearr_13500[(13)] = inst_13475);

return statearr_13500;
})();
var statearr_13501_13523 = state_13482__$1;
(statearr_13501_13523[(2)] = inst_13476);

(statearr_13501_13523[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (10))){
var inst_13465 = (state_13482[(2)]);
var state_13482__$1 = state_13482;
var statearr_13502_13524 = state_13482__$1;
(statearr_13502_13524[(2)] = inst_13465);

(statearr_13502_13524[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13483 === (8))){
var inst_13450 = (state_13482[(10)]);
var inst_13446 = (state_13482[(9)]);
var inst_13442 = (state_13482[(8)]);
var inst_13455 = inst_13442.push(inst_13446);
var tmp13499 = inst_13442;
var inst_13442__$1 = tmp13499;
var inst_13443 = inst_13450;
var state_13482__$1 = (function (){var statearr_13503 = state_13482;
(statearr_13503[(14)] = inst_13455);

(statearr_13503[(7)] = inst_13443);

(statearr_13503[(8)] = inst_13442__$1);

return statearr_13503;
})();
var statearr_13504_13525 = state_13482__$1;
(statearr_13504_13525[(2)] = null);

(statearr_13504_13525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__11469__auto__ = null;
var cljs$core$async$state_machine__11469__auto____0 = (function (){
var statearr_13505 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13505[(0)] = cljs$core$async$state_machine__11469__auto__);

(statearr_13505[(1)] = (1));

return statearr_13505;
});
var cljs$core$async$state_machine__11469__auto____1 = (function (state_13482){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_13482);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e13506){var ex__11472__auto__ = e13506;
var statearr_13507_13526 = state_13482;
(statearr_13507_13526[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_13482[(4)]))){
var statearr_13508_13527 = state_13482;
(statearr_13508_13527[(1)] = cljs.core.first.call(null,(state_13482[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13528 = state_13482;
state_13482 = G__13528;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
cljs$core$async$state_machine__11469__auto__ = function(state_13482){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11469__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11469__auto____1.call(this,state_13482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11469__auto____0;
cljs$core$async$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11469__auto____1;
return cljs$core$async$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_13509 = f__11543__auto__.call(null);
(statearr_13509[(6)] = c__11542__auto___13511);

return statearr_13509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

