// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__31674 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31674,(5),null);
var G__31677 = idx;
var G__31677__$1 = (((G__31677 instanceof cljs.core.Keyword))?G__31677.fqn:null);
switch (G__31677__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31677__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__31679 = idx;
var G__31679__$1 = (((G__31679 instanceof cljs.core.Keyword))?G__31679.fqn:null);
switch (G__31679__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31679__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__31681 = idx;
var G__31681__$1 = (((G__31681 instanceof cljs.core.Keyword))?G__31681.fqn:null);
switch (G__31681__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31681__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__31684 = arguments.length;
switch (G__31684) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__31685 = (function (){var pred__31688 = cljs.core.identical_QMARK_;
var expr__31689 = test;
if(cljs.core.truth_((pred__31688.cljs$core$IFn$_invoke$arity$2 ? pred__31688.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__31689) : pred__31688.call(null,cljs.core._EQ_,expr__31689)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31688.cljs$core$IFn$_invoke$arity$2 ? pred__31688.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__31689) : pred__31688.call(null,cljs.core._LT_,expr__31689)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__31688.cljs$core$IFn$_invoke$arity$2 ? pred__31688.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__31689) : pred__31688.call(null,cljs.core._LT__EQ_,expr__31689)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__31688.cljs$core$IFn$_invoke$arity$2 ? pred__31688.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__31689) : pred__31688.call(null,cljs.core._GT_,expr__31689)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__31688.cljs$core$IFn$_invoke$arity$2 ? pred__31688.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__31689) : pred__31688.call(null,cljs.core._GT__EQ_,expr__31689)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__31689)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31685,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31685,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31685,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31685,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_31902){
var state_val_31903 = (state_31902[(1)]);
if((state_val_31903 === (65))){
var inst_31823 = (state_31902[(7)]);
var inst_31855 = (state_31902[(8)]);
var inst_31867 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31855,inst_31823);
var state_31902__$1 = state_31902;
var statearr_31904_32020 = state_31902__$1;
(statearr_31904_32020[(2)] = inst_31867);

(statearr_31904_32020[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (70))){
var inst_31885 = (state_31902[(2)]);
var inst_31886 = cljs.core.not(inst_31885);
var state_31902__$1 = state_31902;
if(inst_31886){
var statearr_31905_32021 = state_31902__$1;
(statearr_31905_32021[(1)] = (71));

} else {
var statearr_31906_32022 = state_31902__$1;
(statearr_31906_32022[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (62))){
var inst_31876 = (state_31902[(9)]);
var inst_31837 = (state_31902[(10)]);
var inst_31876__$1 = (state_31902[(2)]);
var inst_31877 = cljs.core.count(inst_31876__$1);
var state_31902__$1 = (function (){var statearr_31907 = state_31902;
(statearr_31907[(11)] = inst_31877);

(statearr_31907[(9)] = inst_31876__$1);

return statearr_31907;
})();
if(cljs.core.truth_(inst_31837)){
var statearr_31908_32023 = state_31902__$1;
(statearr_31908_32023[(1)] = (68));

} else {
var statearr_31909_32024 = state_31902__$1;
(statearr_31909_32024[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (74))){
var inst_31877 = (state_31902[(11)]);
var inst_31876 = (state_31902[(9)]);
var inst_31891 = (state_31902[(2)]);
var inst_31892 = fluree.db.util.async.throw_err(inst_31891);
var inst_31821 = inst_31892;
var inst_31822 = inst_31877;
var inst_31823 = inst_31876;
var state_31902__$1 = (function (){var statearr_31910 = state_31902;
(statearr_31910[(7)] = inst_31823);

(statearr_31910[(12)] = inst_31822);

(statearr_31910[(13)] = inst_31821);

return statearr_31910;
})();
var statearr_31911_32025 = state_31902__$1;
(statearr_31911_32025[(2)] = null);

(statearr_31911_32025[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (7))){
var inst_31704 = (state_31902[(14)]);
var state_31902__$1 = state_31902;
var statearr_31912_32026 = state_31902__$1;
(statearr_31912_32026[(2)] = inst_31704);

(statearr_31912_32026[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (59))){
var inst_31821 = (state_31902[(13)]);
var inst_31836 = (state_31902[(2)]);
var inst_31837 = fluree.db.dbproto._rhs(inst_31821);
var state_31902__$1 = (function (){var statearr_31913 = state_31902;
(statearr_31913[(15)] = inst_31836);

(statearr_31913[(10)] = inst_31837);

return statearr_31913;
})();
var statearr_31914_32027 = state_31902__$1;
(statearr_31914_32027[(1)] = (60));



return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (20))){
var inst_31705 = (state_31902[(16)]);
var inst_31752 = (state_31902[(2)]);
var inst_31753 = (inst_31705 == null);
var state_31902__$1 = (function (){var statearr_31916 = state_31902;
(statearr_31916[(17)] = inst_31752);

return statearr_31916;
})();
if(cljs.core.truth_(inst_31753)){
var statearr_31917_32028 = state_31902__$1;
(statearr_31917_32028[(1)] = (22));

} else {
var statearr_31918_32029 = state_31902__$1;
(statearr_31918_32029[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (72))){
var inst_31816 = (state_31902[(18)]);
var inst_31837 = (state_31902[(10)]);
var inst_31889 = fluree.db.dbproto._lookup_leaf(inst_31816,inst_31837);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(74),inst_31889);
} else {
if((state_val_31903 === (58))){
var inst_31829 = (state_31902[(19)]);
var state_31902__$1 = state_31902;
var statearr_31919_32030 = state_31902__$1;
(statearr_31919_32030[(2)] = inst_31829);

(statearr_31919_32030[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (60))){
var inst_31823 = (state_31902[(7)]);
var inst_31822 = (state_31902[(12)]);
var inst_31836 = (state_31902[(15)]);
var inst_31795 = (state_31902[(20)]);
var inst_31839 = (inst_31795 - inst_31822);
var inst_31840 = fluree.db.flake.take(inst_31839,inst_31836);
var inst_31841 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31840,inst_31823);
var state_31902__$1 = state_31902;
var statearr_31920_32031 = state_31902__$1;
(statearr_31920_32031[(2)] = inst_31841);

(statearr_31920_32031[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (27))){
var inst_31712 = (state_31902[(21)]);
var inst_31761 = (state_31902[(2)]);
var inst_31762 = (inst_31712 == null);
var state_31902__$1 = (function (){var statearr_31921 = state_31902;
(statearr_31921[(22)] = inst_31761);

return statearr_31921;
})();
if(cljs.core.truth_(inst_31762)){
var statearr_31922_32032 = state_31902__$1;
(statearr_31922_32032[(1)] = (28));

} else {
var statearr_31923_32033 = state_31902__$1;
(statearr_31923_32033[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (1))){
var state_31902__$1 = state_31902;
var statearr_31924_32034 = state_31902__$1;
(statearr_31924_32034[(2)] = null);

(statearr_31924_32034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (69))){
var inst_31837 = (state_31902[(10)]);
var state_31902__$1 = state_31902;
var statearr_31925_32035 = state_31902__$1;
(statearr_31925_32035[(2)] = inst_31837);

(statearr_31925_32035[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (24))){
var inst_31757 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
if(cljs.core.truth_(inst_31757)){
var statearr_31926_32036 = state_31902__$1;
(statearr_31926_32036[(1)] = (25));

} else {
var statearr_31927_32037 = state_31902__$1;
(statearr_31927_32037[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (55))){
var inst_31897 = (state_31902[(2)]);
var _ = (function (){var statearr_31928 = state_31902;
(statearr_31928[(4)] = cljs.core.rest((state_31902[(4)])));

return statearr_31928;
})();
var state_31902__$1 = state_31902;
var statearr_31929_32038 = state_31902__$1;
(statearr_31929_32038[(2)] = inst_31897);

(statearr_31929_32038[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (39))){
var inst_31777 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_31930_32039 = state_31902__$1;
(statearr_31930_32039[(2)] = inst_31777);

(statearr_31930_32039[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (46))){
var inst_31791 = (state_31902[(23)]);
var state_31902__$1 = state_31902;
var statearr_31931_32040 = state_31902__$1;
(statearr_31931_32040[(2)] = inst_31791);

(statearr_31931_32040[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (4))){
var inst_31691 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_31932_32041 = state_31902__$1;
(statearr_31932_32041[(2)] = inst_31691);

(statearr_31932_32041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (54))){
var inst_31811 = (state_31902[(24)]);
var inst_31807 = (state_31902[(25)]);
var inst_31806 = (state_31902[(26)]);
var inst_31821 = (state_31902[(13)]);
var inst_31825 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_31821,inst_31806,inst_31807,inst_31811);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(56),inst_31825);
} else {
if((state_val_31903 === (15))){
var inst_31706 = (state_31902[(27)]);
var state_31902__$1 = state_31902;
var statearr_31933_32042 = state_31902__$1;
(statearr_31933_32042[(2)] = inst_31706);

(statearr_31933_32042[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (48))){
var inst_31801 = (state_31902[(28)]);
var inst_31795 = (state_31902[(2)]);
var inst_31796 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_31797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31798 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_31799 = (new cljs.core.PersistentVector(null,3,(5),inst_31797,inst_31798,null));
var inst_31800 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31799);
var inst_31801__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_31902__$1 = (function (){var statearr_31934 = state_31902;
(statearr_31934[(28)] = inst_31801__$1);

(statearr_31934[(29)] = inst_31800);

(statearr_31934[(20)] = inst_31795);

(statearr_31934[(30)] = inst_31796);

return statearr_31934;
})();
if(cljs.core.truth_(inst_31801__$1)){
var statearr_31935_32043 = state_31902__$1;
(statearr_31935_32043[(1)] = (49));

} else {
var statearr_31936_32044 = state_31902__$1;
(statearr_31936_32044[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (50))){
var inst_31804 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_31902__$1 = state_31902;
var statearr_31937_32045 = state_31902__$1;
(statearr_31937_32045[(2)] = inst_31804);

(statearr_31937_32045[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (21))){
var inst_31748 = (state_31902[(2)]);
var inst_31749 = fluree.db.util.async.throw_err(inst_31748);
var state_31902__$1 = state_31902;
var statearr_31938_32046 = state_31902__$1;
(statearr_31938_32046[(2)] = inst_31749);

(statearr_31938_32046[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (31))){
var state_31902__$1 = state_31902;
var statearr_31939_32047 = state_31902__$1;
(statearr_31939_32047[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_31939_32047[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (32))){
var inst_31712 = (state_31902[(21)]);
var state_31902__$1 = state_31902;
var statearr_31940_32048 = state_31902__$1;
(statearr_31940_32048[(2)] = inst_31712);

(statearr_31940_32048[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (40))){
var inst_31716 = (state_31902[(31)]);
var state_31902__$1 = state_31902;
var statearr_31941_32049 = state_31902__$1;
(statearr_31941_32049[(2)] = inst_31716);

(statearr_31941_32049[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (56))){
var inst_31828 = (state_31902[(32)]);
var inst_31789 = (state_31902[(33)]);
var inst_31790 = (state_31902[(34)]);
var inst_31827 = (state_31902[(2)]);
var inst_31828__$1 = fluree.db.util.async.throw_err(inst_31827);
var inst_31829 = fluree.db.flake.subrange(inst_31828__$1,start_test,inst_31789,end_test,inst_31790);
var inst_31830 = fluree.db.query.range.value_with_nil_pred(idx,inst_31789,inst_31790);
var state_31902__$1 = (function (){var statearr_31942 = state_31902;
(statearr_31942[(32)] = inst_31828__$1);

(statearr_31942[(19)] = inst_31829);

return statearr_31942;
})();
if(inst_31830){
var statearr_31943_32050 = state_31902__$1;
(statearr_31943_32050[(1)] = (57));

} else {
var statearr_31944_32051 = state_31902__$1;
(statearr_31944_32051[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (33))){
var inst_31709 = (state_31902[(35)]);
var inst_31770 = (state_31902[(2)]);
var state_31902__$1 = (function (){var statearr_31945 = state_31902;
(statearr_31945[(36)] = inst_31770);

return statearr_31945;
})();
if(cljs.core.truth_(inst_31709)){
var statearr_31946_32052 = state_31902__$1;
(statearr_31946_32052[(1)] = (34));

} else {
var statearr_31947_32053 = state_31902__$1;
(statearr_31947_32053[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (13))){
var inst_31730 = (state_31902[(2)]);
var inst_31731 = fluree.db.util.async.throw_err(inst_31730);
var state_31902__$1 = state_31902;
var statearr_31948_32054 = state_31902__$1;
(statearr_31948_32054[(2)] = inst_31731);

(statearr_31948_32054[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (22))){
var inst_31743 = (state_31902[(37)]);
var state_31902__$1 = state_31902;
var statearr_31949_32055 = state_31902__$1;
(statearr_31949_32055[(2)] = inst_31743);

(statearr_31949_32055[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (36))){
var inst_31716 = (state_31902[(31)]);
var inst_31779 = (state_31902[(2)]);
var state_31902__$1 = (function (){var statearr_31950 = state_31902;
(statearr_31950[(38)] = inst_31779);

return statearr_31950;
})();
if(cljs.core.truth_(inst_31716)){
var statearr_31951_32056 = state_31902__$1;
(statearr_31951_32056[(1)] = (40));

} else {
var statearr_31952_32057 = state_31902__$1;
(statearr_31952_32057[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (41))){
var inst_31782 = (cljs.core._LT__EQ_ === end_test);
var state_31902__$1 = state_31902;
if(cljs.core.truth_(inst_31782)){
var statearr_31953_32058 = state_31902__$1;
(statearr_31953_32058[(1)] = (43));

} else {
var statearr_31954_32059 = state_31902__$1;
(statearr_31954_32059[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (43))){
var state_31902__$1 = state_31902;
var statearr_31955_32060 = state_31902__$1;
(statearr_31955_32060[(2)] = (2147483647));

(statearr_31955_32060[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (61))){
var inst_31822 = (state_31902[(12)]);
var inst_31836 = (state_31902[(15)]);
var inst_31850 = cljs.core.seq(inst_31836);
var inst_31851 = cljs.core.first(inst_31850);
var inst_31852 = cljs.core.next(inst_31850);
var inst_31853 = inst_31836;
var inst_31854 = inst_31822;
var inst_31855 = inst_31836;
var state_31902__$1 = (function (){var statearr_31956 = state_31902;
(statearr_31956[(39)] = inst_31851);

(statearr_31956[(8)] = inst_31855);

(statearr_31956[(40)] = inst_31852);

(statearr_31956[(41)] = inst_31853);

(statearr_31956[(42)] = inst_31854);

return statearr_31956;
})();
var statearr_31957_32061 = state_31902__$1;
(statearr_31957_32061[(2)] = null);

(statearr_31957_32061[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (29))){
var state_31902__$1 = state_31902;
var statearr_31958_32062 = state_31902__$1;
(statearr_31958_32062[(2)] = false);

(statearr_31958_32062[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (44))){
var state_31902__$1 = state_31902;
var statearr_31959_32063 = state_31902__$1;
(statearr_31959_32063[(2)] = fluree.db.util.core.min_integer);

(statearr_31959_32063[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (6))){
var inst_31704 = (state_31902[(14)]);
var inst_31719 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31704);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(9),inst_31719);
} else {
if((state_val_31903 === (28))){
var inst_31752 = (state_31902[(17)]);
var state_31902__$1 = state_31902;
var statearr_31960_32064 = state_31902__$1;
(statearr_31960_32064[(2)] = inst_31752);

(statearr_31960_32064[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (64))){
var inst_31874 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_31961_32065 = state_31902__$1;
(statearr_31961_32065[(2)] = inst_31874);

(statearr_31961_32065[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (51))){
var inst_31806 = (state_31902[(2)]);
var inst_31807 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_31808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31809 = [cljs.core.cst$kw$novelty,idx];
var inst_31810 = (new cljs.core.PersistentVector(null,2,(5),inst_31808,inst_31809,null));
var inst_31811 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_31810);
var inst_31812 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_31813 = fluree.db.dbproto._resolve(inst_31812);
var state_31902__$1 = (function (){var statearr_31962 = state_31902;
(statearr_31962[(24)] = inst_31811);

(statearr_31962[(25)] = inst_31807);

(statearr_31962[(26)] = inst_31806);

return statearr_31962;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(52),inst_31813);
} else {
if((state_val_31903 === (25))){
var state_31902__$1 = state_31902;
var statearr_31963_32066 = state_31902__$1;
(statearr_31963_32066[(2)] = (-1));

(statearr_31963_32066[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (34))){
var inst_31709 = (state_31902[(35)]);
var state_31902__$1 = state_31902;
var statearr_31964_32067 = state_31902__$1;
(statearr_31964_32067[(2)] = inst_31709);

(statearr_31964_32067[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (17))){
var inst_31739 = (state_31902[(2)]);
var inst_31740 = fluree.db.util.async.throw_err(inst_31739);
var state_31902__$1 = state_31902;
var statearr_31965_32068 = state_31902__$1;
(statearr_31965_32068[(2)] = inst_31740);

(statearr_31965_32068[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (3))){
var inst_31900 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31902__$1,inst_31900);
} else {
if((state_val_31903 === (12))){
var inst_31706 = (state_31902[(27)]);
var inst_31734 = (state_31902[(2)]);
var inst_31735 = fluree.db.util.core.pred_ident_QMARK_(inst_31706);
var state_31902__$1 = (function (){var statearr_31967 = state_31902;
(statearr_31967[(43)] = inst_31734);

return statearr_31967;
})();
if(inst_31735){
var statearr_31968_32069 = state_31902__$1;
(statearr_31968_32069[(1)] = (14));

} else {
var statearr_31969_32070 = state_31902__$1;
(statearr_31969_32070[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (2))){
var inst_31710 = (state_31902[(44)]);
var inst_31704 = (state_31902[(14)]);
var inst_31703 = (state_31902[(45)]);
var _ = (function (){var statearr_31970 = state_31902;
(statearr_31970[(4)] = cljs.core.cons((5),(state_31902[(4)])));

return statearr_31970;
})();
var inst_31703__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_31704__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(0),null);
var inst_31705 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(1),null);
var inst_31706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(2),null);
var inst_31707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(3),null);
var inst_31708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(4),null);
var inst_31709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31703__$1,(5),null);
var inst_31710__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_31711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(0),null);
var inst_31712 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(1),null);
var inst_31713 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(2),null);
var inst_31714 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(3),null);
var inst_31715 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(4),null);
var inst_31716 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31710__$1,(5),null);
var inst_31717 = fluree.db.util.core.pred_ident_QMARK_(inst_31704__$1);
var state_31902__$1 = (function (){var statearr_31971 = state_31902;
(statearr_31971[(46)] = inst_31714);

(statearr_31971[(47)] = inst_31707);

(statearr_31971[(48)] = inst_31708);

(statearr_31971[(44)] = inst_31710__$1);

(statearr_31971[(14)] = inst_31704__$1);

(statearr_31971[(16)] = inst_31705);

(statearr_31971[(35)] = inst_31709);

(statearr_31971[(31)] = inst_31716);

(statearr_31971[(49)] = inst_31715);

(statearr_31971[(45)] = inst_31703__$1);

(statearr_31971[(50)] = inst_31713);

(statearr_31971[(21)] = inst_31712);

(statearr_31971[(51)] = inst_31711);

(statearr_31971[(27)] = inst_31706);

return statearr_31971;
})();
if(inst_31717){
var statearr_31972_32071 = state_31902__$1;
(statearr_31972_32071[(1)] = (6));

} else {
var statearr_31973_32072 = state_31902__$1;
(statearr_31973_32072[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (66))){
var inst_31862 = (state_31902[(52)]);
var inst_31855 = (state_31902[(8)]);
var inst_31854 = (state_31902[(42)]);
var inst_31869 = (inst_31854 + (1));
var tmp31966 = inst_31855;
var inst_31853 = inst_31862;
var inst_31854__$1 = inst_31869;
var inst_31855__$1 = tmp31966;
var state_31902__$1 = (function (){var statearr_31974 = state_31902;
(statearr_31974[(8)] = inst_31855__$1);

(statearr_31974[(41)] = inst_31853);

(statearr_31974[(42)] = inst_31854__$1);

return statearr_31974;
})();
var statearr_31975_32073 = state_31902__$1;
(statearr_31975_32073[(2)] = null);

(statearr_31975_32073[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (23))){
var state_31902__$1 = state_31902;
var statearr_31976_32074 = state_31902__$1;
(statearr_31976_32074[(2)] = false);

(statearr_31976_32074[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (47))){
var state_31902__$1 = state_31902;
var statearr_31977_32075 = state_31902__$1;
(statearr_31977_32075[(2)] = fluree.db.util.core.max_long);

(statearr_31977_32075[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (35))){
var inst_31773 = (cljs.core._GT__EQ_ === start_test);
var state_31902__$1 = state_31902;
if(cljs.core.truth_(inst_31773)){
var statearr_31978_32076 = state_31902__$1;
(statearr_31978_32076[(1)] = (37));

} else {
var statearr_31979_32077 = state_31902__$1;
(statearr_31979_32077[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (19))){
var inst_31713 = (state_31902[(50)]);
var state_31902__$1 = state_31902;
var statearr_31980_32078 = state_31902__$1;
(statearr_31980_32078[(2)] = inst_31713);

(statearr_31980_32078[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (57))){
var inst_31828 = (state_31902[(32)]);
var inst_31823 = (state_31902[(7)]);
var inst_31822 = (state_31902[(12)]);
var inst_31714 = (state_31902[(46)]);
var inst_31770 = (state_31902[(36)]);
var inst_31761 = (state_31902[(22)]);
var inst_31752 = (state_31902[(17)]);
var inst_31829 = (state_31902[(19)]);
var inst_31779 = (state_31902[(38)]);
var inst_31707 = (state_31902[(47)]);
var inst_31708 = (state_31902[(48)]);
var inst_31710 = (state_31902[(44)]);
var inst_31734 = (state_31902[(43)]);
var inst_31789 = (state_31902[(33)]);
var inst_31725 = (state_31902[(53)]);
var inst_31811 = (state_31902[(24)]);
var inst_31807 = (state_31902[(25)]);
var inst_31788 = (state_31902[(54)]);
var inst_31800 = (state_31902[(29)]);
var inst_31806 = (state_31902[(26)]);
var inst_31816 = (state_31902[(18)]);
var inst_31715 = (state_31902[(49)]);
var inst_31703 = (state_31902[(45)]);
var inst_31821 = (state_31902[(13)]);
var inst_31795 = (state_31902[(20)]);
var inst_31796 = (state_31902[(30)]);
var inst_31790 = (state_31902[(34)]);
var inst_31743 = (state_31902[(37)]);
var inst_31832 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_31821;
var flakes = inst_31828;
var s1 = inst_31725;
var o2 = inst_31752;
var t1 = inst_31707;
var vec__31697 = inst_31703;
var i = inst_31822;
var m1 = inst_31779;
var root_node = inst_31816;
var to_t = inst_31807;
var s2 = inst_31734;
var p2 = inst_31770;
var permissions = inst_31796;
var limit = inst_31795;
var start_flake = inst_31789;
var acc = inst_31823;
var vec__31700 = inst_31710;
var t2 = inst_31714;
var op1 = inst_31708;
var o1 = inst_31743;
var end_flake = inst_31790;
var base_result = inst_31829;
var p1 = inst_31761;
var idx_compare = inst_31800;
var op2 = inst_31715;
var from_t = inst_31806;
var m2 = inst_31788;
var novelty = inst_31811;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_31833 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31832,inst_31829,inst_31829);
var state_31902__$1 = state_31902;
var statearr_31981_32079 = state_31902__$1;
(statearr_31981_32079[(2)] = inst_31833);

(statearr_31981_32079[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (68))){
var inst_31800 = (state_31902[(29)]);
var inst_31877 = (state_31902[(11)]);
var inst_31837 = (state_31902[(10)]);
var inst_31795 = (state_31902[(20)]);
var inst_31790 = (state_31902[(34)]);
var inst_31879 = (inst_31800.cljs$core$IFn$_invoke$arity$2 ? inst_31800.cljs$core$IFn$_invoke$arity$2(inst_31837,inst_31790) : inst_31800.call(null,inst_31837,inst_31790));
var inst_31880 = (inst_31879 < (0));
var inst_31881 = (inst_31877 < inst_31795);
var inst_31882 = ((inst_31880) && (inst_31881));
var state_31902__$1 = state_31902;
var statearr_31982_32080 = state_31902__$1;
(statearr_31982_32080[(2)] = inst_31882);

(statearr_31982_32080[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (11))){
var inst_31711 = (state_31902[(51)]);
var state_31902__$1 = state_31902;
var statearr_31984_32081 = state_31902__$1;
(statearr_31984_32081[(2)] = inst_31711);

(statearr_31984_32081[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (9))){
var inst_31721 = (state_31902[(2)]);
var inst_31722 = fluree.db.util.async.throw_err(inst_31721);
var state_31902__$1 = state_31902;
var statearr_31985_32082 = state_31902__$1;
(statearr_31985_32082[(2)] = inst_31722);

(statearr_31985_32082[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (5))){
var _ = (function (){var statearr_31986 = state_31902;
(statearr_31986[(4)] = cljs.core.rest((state_31902[(4)])));

return statearr_31986;
})();
var state_31902__$1 = state_31902;
var ex31983 = (state_31902__$1[(2)]);
var statearr_31987_32083 = state_31902__$1;
(statearr_31987_32083[(5)] = ex31983);


if((ex31983 instanceof Error)){
var statearr_31988_32084 = state_31902__$1;
(statearr_31988_32084[(1)] = (4));

(statearr_31988_32084[(5)] = null);

} else {
throw ex31983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (14))){
var inst_31706 = (state_31902[(27)]);
var inst_31737 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31706);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(17),inst_31737);
} else {
if((state_val_31903 === (45))){
var inst_31786 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_31989_32085 = state_31902__$1;
(statearr_31989_32085[(2)] = inst_31786);

(statearr_31989_32085[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (53))){
var inst_31819 = (state_31902[(2)]);
var inst_31820 = fluree.db.util.async.throw_err(inst_31819);
var inst_31821 = inst_31820;
var inst_31822 = (0);
var inst_31823 = null;
var state_31902__$1 = (function (){var statearr_31990 = state_31902;
(statearr_31990[(7)] = inst_31823);

(statearr_31990[(12)] = inst_31822);

(statearr_31990[(13)] = inst_31821);

return statearr_31990;
})();
var statearr_31991_32086 = state_31902__$1;
(statearr_31991_32086[(2)] = null);

(statearr_31991_32086[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (26))){
var inst_31705 = (state_31902[(16)]);
var state_31902__$1 = state_31902;
var statearr_31992_32087 = state_31902__$1;
(statearr_31992_32087[(2)] = inst_31705);

(statearr_31992_32087[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (16))){
var inst_31713 = (state_31902[(50)]);
var inst_31743 = (state_31902[(2)]);
var inst_31744 = fluree.db.util.core.pred_ident_QMARK_(inst_31713);
var state_31902__$1 = (function (){var statearr_31993 = state_31902;
(statearr_31993[(37)] = inst_31743);

return statearr_31993;
})();
if(inst_31744){
var statearr_31994_32088 = state_31902__$1;
(statearr_31994_32088[(1)] = (18));

} else {
var statearr_31995_32089 = state_31902__$1;
(statearr_31995_32089[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (38))){
var state_31902__$1 = state_31902;
var statearr_31996_32090 = state_31902__$1;
(statearr_31996_32090[(2)] = (2147483647));

(statearr_31996_32090[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (30))){
var inst_31766 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
if(cljs.core.truth_(inst_31766)){
var statearr_31997_32091 = state_31902__$1;
(statearr_31997_32091[(1)] = (31));

} else {
var statearr_31998_32092 = state_31902__$1;
(statearr_31998_32092[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (73))){
var inst_31895 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_31999_32093 = state_31902__$1;
(statearr_31999_32093[(2)] = inst_31895);

(statearr_31999_32093[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (10))){
var inst_31711 = (state_31902[(51)]);
var inst_31728 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31711);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(13),inst_31728);
} else {
if((state_val_31903 === (18))){
var inst_31713 = (state_31902[(50)]);
var inst_31746 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_31713);
var state_31902__$1 = state_31902;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(21),inst_31746);
} else {
if((state_val_31903 === (52))){
var inst_31789 = (state_31902[(33)]);
var inst_31816 = (state_31902[(18)]);
var inst_31815 = (state_31902[(2)]);
var inst_31816__$1 = fluree.db.util.async.throw_err(inst_31815);
var inst_31817 = fluree.db.dbproto._lookup_leaf(inst_31816__$1,inst_31789);
var state_31902__$1 = (function (){var statearr_32000 = state_31902;
(statearr_32000[(18)] = inst_31816__$1);

return statearr_32000;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31902__$1,(53),inst_31817);
} else {
if((state_val_31903 === (67))){
var inst_31872 = (state_31902[(2)]);
var state_31902__$1 = state_31902;
var statearr_32001_32094 = state_31902__$1;
(statearr_32001_32094[(2)] = inst_31872);

(statearr_32001_32094[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (71))){
var inst_31876 = (state_31902[(9)]);
var state_31902__$1 = state_31902;
var statearr_32002_32095 = state_31902__$1;
(statearr_32002_32095[(2)] = inst_31876);

(statearr_32002_32095[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (42))){
var inst_31714 = (state_31902[(46)]);
var inst_31770 = (state_31902[(36)]);
var inst_31761 = (state_31902[(22)]);
var inst_31752 = (state_31902[(17)]);
var inst_31779 = (state_31902[(38)]);
var inst_31707 = (state_31902[(47)]);
var inst_31708 = (state_31902[(48)]);
var inst_31734 = (state_31902[(43)]);
var inst_31791 = (state_31902[(23)]);
var inst_31725 = (state_31902[(53)]);
var inst_31788 = (state_31902[(54)]);
var inst_31715 = (state_31902[(49)]);
var inst_31743 = (state_31902[(37)]);
var inst_31788__$1 = (state_31902[(2)]);
var inst_31789 = fluree.db.flake.__GT_Flake(inst_31725,inst_31761,inst_31743,inst_31707,inst_31708,inst_31779);
var inst_31790 = fluree.db.flake.__GT_Flake(inst_31734,inst_31770,inst_31752,inst_31714,inst_31715,inst_31788__$1);
var inst_31791__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_31902__$1 = (function (){var statearr_32003 = state_31902;
(statearr_32003[(33)] = inst_31789);

(statearr_32003[(23)] = inst_31791__$1);

(statearr_32003[(54)] = inst_31788__$1);

(statearr_32003[(34)] = inst_31790);

return statearr_32003;
})();
if(cljs.core.truth_(inst_31791__$1)){
var statearr_32004_32096 = state_31902__$1;
(statearr_32004_32096[(1)] = (46));

} else {
var statearr_32005_32097 = state_31902__$1;
(statearr_32005_32097[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (37))){
var state_31902__$1 = state_31902;
var statearr_32006_32098 = state_31902__$1;
(statearr_32006_32098[(2)] = fluree.db.util.core.min_integer);

(statearr_32006_32098[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (63))){
var inst_31853 = (state_31902[(41)]);
var inst_31854 = (state_31902[(42)]);
var inst_31795 = (state_31902[(20)]);
var inst_31860 = cljs.core.seq(inst_31853);
var inst_31861 = cljs.core.first(inst_31860);
var inst_31862 = cljs.core.next(inst_31860);
var inst_31863 = (inst_31861 == null);
var inst_31864 = (inst_31854 > inst_31795);
var inst_31865 = ((inst_31863) || (inst_31864));
var state_31902__$1 = (function (){var statearr_32007 = state_31902;
(statearr_32007[(52)] = inst_31862);

return statearr_32007;
})();
if(cljs.core.truth_(inst_31865)){
var statearr_32008_32099 = state_31902__$1;
(statearr_32008_32099[(1)] = (65));

} else {
var statearr_32009_32100 = state_31902__$1;
(statearr_32009_32100[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (8))){
var inst_31711 = (state_31902[(51)]);
var inst_31725 = (state_31902[(2)]);
var inst_31726 = fluree.db.util.core.pred_ident_QMARK_(inst_31711);
var state_31902__$1 = (function (){var statearr_32010 = state_31902;
(statearr_32010[(53)] = inst_31725);

return statearr_32010;
})();
if(inst_31726){
var statearr_32011_32101 = state_31902__$1;
(statearr_32011_32101[(1)] = (10));

} else {
var statearr_32012_32102 = state_31902__$1;
(statearr_32012_32102[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31903 === (49))){
var inst_31801 = (state_31902[(28)]);
var state_31902__$1 = state_31902;
var statearr_32013_32103 = state_31902__$1;
(statearr_32013_32103[(2)] = inst_31801);

(statearr_32013_32103[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16291__auto__ = null;
var fluree$db$query$range$state_machine__16291__auto____0 = (function (){
var statearr_32014 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32014[(0)] = fluree$db$query$range$state_machine__16291__auto__);

(statearr_32014[(1)] = (1));

return statearr_32014;
});
var fluree$db$query$range$state_machine__16291__auto____1 = (function (state_31902){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_31902);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e32015){var ex__16294__auto__ = e32015;
var statearr_32016_32104 = state_31902;
(statearr_32016_32104[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_31902[(4)]))){
var statearr_32017_32105 = state_31902;
(statearr_32017_32105[(1)] = cljs.core.first((state_31902[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__32106 = state_31902;
state_31902 = G__32106;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16291__auto__ = function(state_31902){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16291__auto____1.call(this,state_31902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16291__auto____0;
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16291__auto____1;
return fluree$db$query$range$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_32018 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_32018[(6)] = c__16328__auto__);

return statearr_32018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_32156){
var state_val_32157 = (state_32156[(1)]);
if((state_val_32157 === (7))){
var state_32156__$1 = state_32156;
var statearr_32158_32177 = state_32156__$1;
(statearr_32158_32177[(2)] = (0));

(statearr_32158_32177[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (1))){
var inst_32114 = subject_groups;
var inst_32115 = cljs.core.seq(inst_32114);
var inst_32116 = cljs.core.first(inst_32115);
var inst_32117 = cljs.core.next(inst_32115);
var inst_32118 = flake_start;
var inst_32119 = subject_start;
var inst_32120 = cljs.core.PersistentVector.EMPTY;
var inst_32121 = inst_32114;
var inst_32122 = inst_32118;
var inst_32123 = inst_32119;
var inst_32124 = inst_32120;
var state_32156__$1 = (function (){var statearr_32159 = state_32156;
(statearr_32159[(7)] = inst_32124);

(statearr_32159[(8)] = inst_32117);

(statearr_32159[(9)] = inst_32121);

(statearr_32159[(10)] = inst_32123);

(statearr_32159[(11)] = inst_32122);

(statearr_32159[(12)] = inst_32116);

return statearr_32159;
})();
var statearr_32160_32178 = state_32156__$1;
(statearr_32160_32178[(2)] = null);

(statearr_32160_32178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (4))){
var inst_32124 = (state_32156[(7)]);
var inst_32123 = (state_32156[(10)]);
var inst_32122 = (state_32156[(11)]);
var inst_32137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32138 = [inst_32122,inst_32123,inst_32124];
var inst_32139 = (new cljs.core.PersistentVector(null,3,(5),inst_32137,inst_32138,null));
var state_32156__$1 = state_32156;
var statearr_32161_32179 = state_32156__$1;
(statearr_32161_32179[(2)] = inst_32139);

(statearr_32161_32179[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (6))){
var inst_32152 = (state_32156[(2)]);
var state_32156__$1 = state_32156;
var statearr_32162_32180 = state_32156__$1;
(statearr_32162_32180[(2)] = inst_32152);

(statearr_32162_32180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (3))){
var inst_32154 = (state_32156[(2)]);
var state_32156__$1 = state_32156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32156__$1,inst_32154);
} else {
if((state_val_32157 === (2))){
var inst_32130 = (state_32156[(13)]);
var inst_32121 = (state_32156[(9)]);
var inst_32123 = (state_32156[(10)]);
var inst_32122 = (state_32156[(11)]);
var inst_32129 = cljs.core.seq(inst_32121);
var inst_32130__$1 = cljs.core.first(inst_32129);
var inst_32131 = cljs.core.next(inst_32129);
var inst_32132 = (inst_32130__$1 == null);
var inst_32133 = (inst_32122 >= flake_limit);
var inst_32134 = (inst_32123 >= subject_limit);
var inst_32135 = ((inst_32132) || (inst_32133) || (inst_32134));
var state_32156__$1 = (function (){var statearr_32163 = state_32156;
(statearr_32163[(14)] = inst_32131);

(statearr_32163[(13)] = inst_32130__$1);

return statearr_32163;
})();
if(cljs.core.truth_(inst_32135)){
var statearr_32164_32181 = state_32156__$1;
(statearr_32164_32181[(1)] = (4));

} else {
var statearr_32165_32182 = state_32156__$1;
(statearr_32165_32182[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (9))){
var inst_32131 = (state_32156[(14)]);
var inst_32124 = (state_32156[(7)]);
var inst_32130 = (state_32156[(13)]);
var inst_32123 = (state_32156[(10)]);
var inst_32122 = (state_32156[(11)]);
var inst_32141 = (state_32156[(15)]);
var inst_32146 = (state_32156[(2)]);
var inst_32147 = (inst_32122 + inst_32141);
var inst_32148 = (inst_32123 + inst_32146);
var inst_32149 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32124,inst_32130);
var inst_32121 = inst_32131;
var inst_32122__$1 = inst_32147;
var inst_32123__$1 = inst_32148;
var inst_32124__$1 = inst_32149;
var state_32156__$1 = (function (){var statearr_32166 = state_32156;
(statearr_32166[(7)] = inst_32124__$1);

(statearr_32166[(9)] = inst_32121);

(statearr_32166[(10)] = inst_32123__$1);

(statearr_32166[(11)] = inst_32122__$1);

return statearr_32166;
})();
var statearr_32167_32183 = state_32156__$1;
(statearr_32167_32183[(2)] = null);

(statearr_32167_32183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (5))){
var inst_32130 = (state_32156[(13)]);
var inst_32141 = (state_32156[(15)]);
var inst_32141__$1 = cljs.core.count(inst_32130);
var inst_32142 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_32141__$1);
var state_32156__$1 = (function (){var statearr_32168 = state_32156;
(statearr_32168[(15)] = inst_32141__$1);

return statearr_32168;
})();
if(inst_32142){
var statearr_32169_32184 = state_32156__$1;
(statearr_32169_32184[(1)] = (7));

} else {
var statearr_32170_32185 = state_32156__$1;
(statearr_32170_32185[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32157 === (8))){
var state_32156__$1 = state_32156;
var statearr_32171_32186 = state_32156__$1;
(statearr_32171_32186[(2)] = (1));

(statearr_32171_32186[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____0 = (function (){
var statearr_32172 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32172[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__);

(statearr_32172[(1)] = (1));

return statearr_32172;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____1 = (function (state_32156){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_32156);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e32173){var ex__16294__auto__ = e32173;
var statearr_32174_32187 = state_32156;
(statearr_32174_32187[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_32156[(4)]))){
var statearr_32175_32188 = state_32156;
(statearr_32175_32188[(1)] = cljs.core.first((state_32156[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__32189 = state_32156;
state_32156 = G__32189;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__ = function(state_32156){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____1.call(this,state_32156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_32176 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_32176[(6)] = c__16328__auto__);

return statearr_32176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_32235){
var state_val_32236 = (state_32235[(1)]);
if((state_val_32236 === (7))){
var state_32235__$1 = state_32235;
var statearr_32237_32275 = state_32235__$1;
(statearr_32237_32275[(2)] = null);

(statearr_32237_32275[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (20))){
var inst_32221 = (state_32235[(2)]);
var inst_32222 = fluree.db.util.async.throw_err(inst_32221);
var inst_32200 = inst_32222;
var state_32235__$1 = (function (){var statearr_32238 = state_32235;
(statearr_32238[(7)] = inst_32200);

return statearr_32238;
})();
var statearr_32239_32276 = state_32235__$1;
(statearr_32239_32276[(2)] = null);

(statearr_32239_32276[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (1))){
var state_32235__$1 = state_32235;
var statearr_32240_32277 = state_32235__$1;
(statearr_32240_32277[(2)] = null);

(statearr_32240_32277[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (4))){
var inst_32190 = (state_32235[(2)]);
var state_32235__$1 = state_32235;
var statearr_32241_32278 = state_32235__$1;
(statearr_32241_32278[(2)] = inst_32190);

(statearr_32241_32278[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (15))){
var inst_32217 = (state_32235[(8)]);
var inst_32200 = (state_32235[(7)]);
var inst_32217__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_32200);
var state_32235__$1 = (function (){var statearr_32242 = state_32235;
(statearr_32242[(8)] = inst_32217__$1);

return statearr_32242;
})();
if(cljs.core.truth_(inst_32217__$1)){
var statearr_32243_32279 = state_32235__$1;
(statearr_32243_32279[(1)] = (17));

} else {
var statearr_32244_32280 = state_32235__$1;
(statearr_32244_32280[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (13))){
var inst_32210 = (state_32235[(2)]);
var inst_32211 = fluree.db.util.async.throw_err(inst_32210);
var _ = (function (){var statearr_32245 = state_32235;
(statearr_32245[(4)] = cljs.core.rest((state_32235[(4)])));

return statearr_32245;
})();
var state_32235__$1 = state_32235;
var statearr_32246_32281 = state_32235__$1;
(statearr_32246_32281[(2)] = inst_32211);

(statearr_32246_32281[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (6))){
var inst_32198 = (state_32235[(2)]);
var inst_32199 = fluree.db.util.async.throw_err(inst_32198);
var inst_32200 = inst_32199;
var state_32235__$1 = (function (){var statearr_32247 = state_32235;
(statearr_32247[(7)] = inst_32200);

return statearr_32247;
})();
var statearr_32248_32282 = state_32235__$1;
(statearr_32248_32282[(2)] = null);

(statearr_32248_32282[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (17))){
var inst_32217 = (state_32235[(8)]);
var inst_32219 = fluree.db.dbproto._lookup_leaf(root_node,inst_32217);
var state_32235__$1 = state_32235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32235__$1,(20),inst_32219);
} else {
if((state_val_32236 === (3))){
var inst_32233 = (state_32235[(2)]);
var state_32235__$1 = state_32235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32235__$1,inst_32233);
} else {
if((state_val_32236 === (12))){
var _ = (function (){var statearr_32250 = state_32235;
(statearr_32250[(4)] = cljs.core.rest((state_32235[(4)])));

return statearr_32250;
})();
var state_32235__$1 = state_32235;
var ex32249 = (state_32235__$1[(2)]);
var statearr_32251_32283 = state_32235__$1;
(statearr_32251_32283[(5)] = ex32249);


var statearr_32252_32284 = state_32235__$1;
(statearr_32252_32284[(1)] = (11));

(statearr_32252_32284[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (2))){
var _ = (function (){var statearr_32253 = state_32235;
(statearr_32253[(4)] = cljs.core.cons((5),(state_32235[(4)])));

return statearr_32253;
})();
var inst_32196 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_32235__$1 = state_32235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32235__$1,(6),inst_32196);
} else {
if((state_val_32236 === (19))){
var inst_32226 = (state_32235[(2)]);
var state_32235__$1 = state_32235;
var statearr_32254_32285 = state_32235__$1;
(statearr_32254_32285[(2)] = inst_32226);

(statearr_32254_32285[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (11))){
var inst_32202 = (state_32235[(2)]);
var state_32235__$1 = (function (){var statearr_32256 = state_32235;
(statearr_32256[(9)] = inst_32202);

return statearr_32256;
})();
var statearr_32257_32286 = state_32235__$1;
(statearr_32257_32286[(2)] = null);

(statearr_32257_32286[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (9))){
var inst_32200 = (state_32235[(7)]);
var _ = (function (){var statearr_32258 = state_32235;
(statearr_32258[(4)] = cljs.core.cons((12),(state_32235[(4)])));

return statearr_32258;
})();
var inst_32208 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_32200,t,novelty,fast_forward_db_QMARK_);
var state_32235__$1 = state_32235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32235__$1,(13),inst_32208);
} else {
if((state_val_32236 === (5))){
var _ = (function (){var statearr_32259 = state_32235;
(statearr_32259[(4)] = cljs.core.rest((state_32235[(4)])));

return statearr_32259;
})();
var state_32235__$1 = state_32235;
var ex32255 = (state_32235__$1[(2)]);
var statearr_32260_32287 = state_32235__$1;
(statearr_32260_32287[(5)] = ex32255);


if((ex32255 instanceof Error)){
var statearr_32261_32288 = state_32235__$1;
(statearr_32261_32288[(1)] = (4));

(statearr_32261_32288[(5)] = null);

} else {
throw ex32255;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (14))){
var inst_32214 = (state_32235[(10)]);
var state_32235__$1 = state_32235;
var statearr_32262_32289 = state_32235__$1;
(statearr_32262_32289[(2)] = inst_32214);

(statearr_32262_32289[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (16))){
var inst_32228 = (state_32235[(2)]);
var state_32235__$1 = state_32235;
var statearr_32263_32290 = state_32235__$1;
(statearr_32263_32290[(2)] = inst_32228);

(statearr_32263_32290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (10))){
var inst_32214 = (state_32235[(10)]);
var inst_32214__$1 = (state_32235[(2)]);
var state_32235__$1 = (function (){var statearr_32264 = state_32235;
(statearr_32264[(10)] = inst_32214__$1);

return statearr_32264;
})();
if(cljs.core.truth_(inst_32214__$1)){
var statearr_32265_32291 = state_32235__$1;
(statearr_32265_32291[(1)] = (14));

} else {
var statearr_32266_32292 = state_32235__$1;
(statearr_32266_32292[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (18))){
var state_32235__$1 = state_32235;
var statearr_32267_32293 = state_32235__$1;
(statearr_32267_32293[(2)] = null);

(statearr_32267_32293[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32236 === (8))){
var inst_32230 = (state_32235[(2)]);
var _ = (function (){var statearr_32268 = state_32235;
(statearr_32268[(4)] = cljs.core.rest((state_32235[(4)])));

return statearr_32268;
})();
var state_32235__$1 = state_32235;
var statearr_32269_32294 = state_32235__$1;
(statearr_32269_32294[(2)] = inst_32230);

(statearr_32269_32294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____0 = (function (){
var statearr_32270 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32270[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__);

(statearr_32270[(1)] = (1));

return statearr_32270;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____1 = (function (state_32235){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_32235);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e32271){var ex__16294__auto__ = e32271;
var statearr_32272_32295 = state_32235;
(statearr_32272_32295[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_32235[(4)]))){
var statearr_32273_32296 = state_32235;
(statearr_32273_32296[(1)] = cljs.core.first((state_32235[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__32297 = state_32235;
state_32235 = G__32297;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__ = function(state_32235){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____1.call(this,state_32235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_32274 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_32274[(6)] = c__16328__auto__);

return statearr_32274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__32304 = arguments.length;
switch (G__32304) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__32305 = (function (){var pred__32308 = cljs.core.identical_QMARK_;
var expr__32309 = test;
if(cljs.core.truth_((pred__32308.cljs$core$IFn$_invoke$arity$2 ? pred__32308.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__32309) : pred__32308.call(null,cljs.core._EQ_,expr__32309)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__32308.cljs$core$IFn$_invoke$arity$2 ? pred__32308.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__32309) : pred__32308.call(null,cljs.core._LT_,expr__32309)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__32308.cljs$core$IFn$_invoke$arity$2 ? pred__32308.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__32309) : pred__32308.call(null,cljs.core._LT__EQ_,expr__32309)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__32308.cljs$core$IFn$_invoke$arity$2 ? pred__32308.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__32309) : pred__32308.call(null,cljs.core._GT_,expr__32309)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__32308.cljs$core$IFn$_invoke$arity$2 ? pred__32308.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__32309) : pred__32308.call(null,cljs.core._GT__EQ_,expr__32309)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__32309)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32305,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_32707){
var state_val_32708 = (state_32707[(1)]);
if((state_val_32708 === (121))){
var inst_32568 = (state_32707[(7)]);
var state_32707__$1 = state_32707;
var statearr_32709_32915 = state_32707__$1;
(statearr_32709_32915[(2)] = inst_32568);

(statearr_32709_32915[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (65))){
var state_32707__$1 = state_32707;
var statearr_32710_32916 = state_32707__$1;
(statearr_32710_32916[(2)] = fluree.db.util.core.min_integer);

(statearr_32710_32916[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (70))){
var state_32707__$1 = state_32707;
var statearr_32711_32917 = state_32707__$1;
(statearr_32711_32917[(2)] = true);

(statearr_32711_32917[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (62))){
var inst_32470 = (cljs.core._LT__EQ_ === end_test);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32470)){
var statearr_32712_32918 = state_32707__$1;
(statearr_32712_32918[(1)] = (64));

} else {
var statearr_32713_32919 = state_32707__$1;
(statearr_32713_32919[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (74))){
var inst_32479 = (state_32707[(8)]);
var state_32707__$1 = state_32707;
var statearr_32714_32920 = state_32707__$1;
(statearr_32714_32920[(2)] = inst_32479);

(statearr_32714_32920[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (110))){
var inst_32609 = (state_32707[(9)]);
var inst_32534 = (state_32707[(10)]);
var inst_32601 = (state_32707[(11)]);
var inst_32507 = (state_32707[(12)]);
var inst_32610 = (state_32707[(13)]);
var inst_32611 = (state_32707[(14)]);
var inst_32609__$1 = cljs.core.count(inst_32601);
var inst_32610__$1 = (inst_32534 + inst_32609__$1);
var inst_32611__$1 = (inst_32610__$1 - inst_32507);
var inst_32612 = cljs.core.pos_int_QMARK_(inst_32611__$1);
var state_32707__$1 = (function (){var statearr_32715 = state_32707;
(statearr_32715[(9)] = inst_32609__$1);

(statearr_32715[(13)] = inst_32610__$1);

(statearr_32715[(14)] = inst_32611__$1);

return statearr_32715;
})();
if(inst_32612){
var statearr_32716_32921 = state_32707__$1;
(statearr_32716_32921[(1)] = (113));

} else {
var statearr_32717_32922 = state_32707__$1;
(statearr_32717_32922[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (130))){
var inst_32670 = (state_32707[(15)]);
var state_32707__$1 = state_32707;
var statearr_32718_32923 = state_32707__$1;
(statearr_32718_32923[(2)] = inst_32670);

(statearr_32718_32923[(1)] = (132));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (128))){
var inst_32679 = (state_32707[(16)]);
var state_32707__$1 = state_32707;
var statearr_32719_32924 = state_32707__$1;
(statearr_32719_32924[(2)] = inst_32679);

(statearr_32719_32924[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (7))){
var state_32707__$1 = state_32707;
var statearr_32720_32925 = state_32707__$1;
(statearr_32720_32925[(2)] = false);

(statearr_32720_32925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (59))){
var state_32707__$1 = state_32707;
var statearr_32721_32926 = state_32707__$1;
(statearr_32721_32926[(2)] = (2147483647));

(statearr_32721_32926[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (86))){
var inst_32331 = (state_32707[(17)]);
var inst_32458 = (state_32707[(18)]);
var inst_32478 = (state_32707[(19)]);
var inst_32524 = (state_32707[(20)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32518 = (state_32707[(23)]);
var inst_32387 = (state_32707[(24)]);
var inst_32528 = (state_32707[(25)]);
var inst_32422 = (state_32707[(26)]);
var inst_32534 = (state_32707[(10)]);
var inst_32514 = (state_32707[(27)]);
var inst_32418 = (state_32707[(28)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32519 = (state_32707[(32)]);
var inst_32467 = (state_32707[(33)]);
var inst_32500 = (state_32707[(34)]);
var inst_32533 = (state_32707[(35)]);
var inst_32343 = (state_32707[(36)]);
var inst_32509 = (state_32707[(37)]);
var inst_32477 = (state_32707[(38)]);
var inst_32367 = (state_32707[(39)]);
var inst_32532 = (state_32707[(40)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32419 = (state_32707[(43)]);
var inst_32541 = (state_32707[(44)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32508 = (state_32707[(47)]);
var inst_32366 = (state_32707[(48)]);
var inst_32507 = (state_32707[(12)]);
var inst_32531 = (state_32707[(49)]);
var inst_32338 = (state_32707[(50)]);
var inst_32476 = (state_32707[(51)]);
var inst_32342 = (state_32707[(52)]);
var inst_32513 = (state_32707[(53)]);
var inst_32545 = (function (){var no_filter_QMARK_ = true;
var t = inst_32514;
var max_limit_QMARK_ = inst_32508;
var next_node = inst_32531;
var fast_forward_db_QMARK_ = inst_32519;
var G__32542 = inst_32541;
var s1 = inst_32378;
var o2 = inst_32440;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var i = inst_32533;
var m1 = inst_32467;
var root_node = inst_32524;
var s2 = inst_32387;
var vec__32327 = inst_32419;
var p2 = inst_32458;
var vec__32324 = inst_32418;
var permissions = inst_32509;
var vec__32320 = inst_32338;
var limit = inst_32507;
var vec__32317 = inst_32331;
var start_flake = inst_32477;
var flake_limit = inst_32501;
var offset = inst_32532;
var acc = inst_32535;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32431;
var end_flake = inst_32478;
var base_result = inst_32541;
var s = inst_32534;
var node_start = inst_32528;
var p1 = inst_32449;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32422;
var idx_compare = inst_32513;
var map__32330 = inst_32500;
var op2 = inst_32343;
var m2 = inst_32476;
var novelty = inst_32518;
return (function (p1__32298_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__32298_SHARP_.o,start_flake.o);
});
})();
var inst_32546 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_32545,inst_32541);
var state_32707__$1 = state_32707;
var statearr_32722_32927 = state_32707__$1;
(statearr_32722_32927[(2)] = inst_32546);

(statearr_32722_32927[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (20))){
var inst_32339 = (state_32707[(54)]);
var state_32707__$1 = state_32707;
var statearr_32723_32928 = state_32707__$1;
(statearr_32723_32928[(2)] = inst_32339);

(statearr_32723_32928[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (72))){
var inst_32492 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32724_32929 = state_32707__$1;
(statearr_32724_32929[(2)] = inst_32492);

(statearr_32724_32929[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (58))){
var state_32707__$1 = state_32707;
var statearr_32725_32930 = state_32707__$1;
(statearr_32725_32930[(2)] = fluree.db.util.core.min_integer);

(statearr_32725_32930[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (60))){
var inst_32465 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32726_32931 = state_32707__$1;
(statearr_32726_32931[(2)] = inst_32465);

(statearr_32726_32931[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (27))){
var state_32707__$1 = state_32707;
var statearr_32727_32932 = state_32707__$1;
(statearr_32727_32932[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (1))){
var state_32707__$1 = state_32707;
var statearr_32729_32933 = state_32707__$1;
(statearr_32729_32933[(2)] = null);

(statearr_32729_32933[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (69))){
var inst_32495 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32495)){
var statearr_32730_32934 = state_32707__$1;
(statearr_32730_32934[(1)] = (73));

} else {
var statearr_32731_32935 = state_32707__$1;
(statearr_32731_32935[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (101))){
var state_32707__$1 = state_32707;
var statearr_32732_32936 = state_32707__$1;
(statearr_32732_32936[(2)] = true);

(statearr_32732_32936[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (24))){
var inst_32341 = (state_32707[(55)]);
var inst_32391 = cljs.core.boolean_QMARK_(inst_32341);
var state_32707__$1 = state_32707;
if(inst_32391){
var statearr_32733_32937 = state_32707__$1;
(statearr_32733_32937[(1)] = (26));

} else {
var statearr_32734_32938 = state_32707__$1;
(statearr_32734_32938[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (102))){
var state_32707__$1 = state_32707;
var statearr_32735_32939 = state_32707__$1;
(statearr_32735_32939[(2)] = false);

(statearr_32735_32939[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (55))){
var inst_32337 = (state_32707[(56)]);
var state_32707__$1 = state_32707;
var statearr_32736_32940 = state_32707__$1;
(statearr_32736_32940[(2)] = inst_32337);

(statearr_32736_32940[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (85))){
var inst_32699 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32737_32941 = state_32707__$1;
(statearr_32737_32941[(2)] = inst_32699);

(statearr_32737_32941[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (39))){
var inst_32421 = (state_32707[(57)]);
var inst_32434 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32421);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(42),inst_32434);
} else {
if((state_val_32708 === (88))){
var inst_32367 = (state_32707[(39)]);
var inst_32549 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32738 = state_32707;
(statearr_32738[(58)] = inst_32549);

return statearr_32738;
})();
if(cljs.core.truth_(inst_32367)){
var statearr_32739_32942 = state_32707__$1;
(statearr_32739_32942[(1)] = (89));

} else {
var statearr_32740_32943 = state_32707__$1;
(statearr_32740_32943[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (46))){
var state_32707__$1 = state_32707;
var statearr_32741_32944 = state_32707__$1;
(statearr_32741_32944[(2)] = (-1));

(statearr_32741_32944[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (4))){
var inst_32311 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32742_32945 = state_32707__$1;
(statearr_32742_32945[(2)] = inst_32311);

(statearr_32742_32945[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (77))){
var state_32707__$1 = state_32707;
var statearr_32743_32946 = state_32707__$1;
(statearr_32743_32946[(2)] = fluree.db.util.core.max_long);

(statearr_32743_32946[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (106))){
var inst_32568 = (state_32707[(7)]);
var inst_32666 = (state_32707[(2)]);
var inst_32667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32666,(0),null);
var inst_32668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32666,(1),null);
var inst_32669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32666,(2),null);
var inst_32670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32666,(3),null);
var state_32707__$1 = (function (){var statearr_32744 = state_32707;
(statearr_32744[(59)] = inst_32667);

(statearr_32744[(60)] = inst_32668);

(statearr_32744[(15)] = inst_32670);

(statearr_32744[(61)] = inst_32669);

return statearr_32744;
})();
if(cljs.core.truth_(inst_32568)){
var statearr_32745_32947 = state_32707__$1;
(statearr_32745_32947[(1)] = (120));

} else {
var statearr_32746_32948 = state_32707__$1;
(statearr_32746_32948[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (119))){
var inst_32652 = (state_32707[(2)]);
var inst_32653 = fluree.db.util.async.throw_err(inst_32652);
var state_32707__$1 = state_32707;
var statearr_32747_32949 = state_32707__$1;
(statearr_32747_32949[(2)] = inst_32653);

(statearr_32747_32949[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (95))){
var inst_32331 = (state_32707[(17)]);
var inst_32458 = (state_32707[(18)]);
var inst_32478 = (state_32707[(19)]);
var inst_32524 = (state_32707[(20)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32518 = (state_32707[(23)]);
var inst_32387 = (state_32707[(24)]);
var inst_32528 = (state_32707[(25)]);
var inst_32422 = (state_32707[(26)]);
var inst_32534 = (state_32707[(10)]);
var inst_32514 = (state_32707[(27)]);
var inst_32418 = (state_32707[(28)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32519 = (state_32707[(32)]);
var inst_32467 = (state_32707[(33)]);
var inst_32500 = (state_32707[(34)]);
var inst_32533 = (state_32707[(35)]);
var inst_32343 = (state_32707[(36)]);
var inst_32509 = (state_32707[(37)]);
var inst_32477 = (state_32707[(38)]);
var inst_32367 = (state_32707[(39)]);
var inst_32532 = (state_32707[(40)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32419 = (state_32707[(43)]);
var inst_32541 = (state_32707[(44)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32508 = (state_32707[(47)]);
var inst_32366 = (state_32707[(48)]);
var inst_32507 = (state_32707[(12)]);
var inst_32531 = (state_32707[(49)]);
var inst_32338 = (state_32707[(50)]);
var inst_32561 = (state_32707[(62)]);
var inst_32476 = (state_32707[(51)]);
var inst_32342 = (state_32707[(52)]);
var inst_32513 = (state_32707[(53)]);
var inst_32563 = (function (){var no_filter_QMARK_ = true;
var t = inst_32514;
var max_limit_QMARK_ = inst_32508;
var next_node = inst_32531;
var fast_forward_db_QMARK_ = inst_32519;
var G__32542 = inst_32561;
var s1 = inst_32378;
var o2 = inst_32440;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var i = inst_32533;
var m1 = inst_32467;
var root_node = inst_32524;
var s2 = inst_32387;
var vec__32327 = inst_32419;
var p2 = inst_32458;
var vec__32324 = inst_32418;
var permissions = inst_32509;
var vec__32320 = inst_32338;
var limit = inst_32507;
var vec__32317 = inst_32331;
var start_flake = inst_32477;
var flake_limit = inst_32501;
var offset = inst_32532;
var acc = inst_32535;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32431;
var end_flake = inst_32478;
var base_result = inst_32541;
var s = inst_32534;
var node_start = inst_32528;
var p1 = inst_32449;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32422;
var idx_compare = inst_32513;
var map__32330 = inst_32500;
var op2 = inst_32343;
var m2 = inst_32476;
var novelty = inst_32518;
return (function (p1__32301_SHARP_){
var G__32748 = p1__32301_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__32748) : object_fn.call(null,G__32748));
});
})();
var inst_32564 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_32563,inst_32561);
var state_32707__$1 = state_32707;
var statearr_32749_32950 = state_32707__$1;
(statearr_32749_32950[(2)] = inst_32564);

(statearr_32749_32950[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (54))){
var inst_32337 = (state_32707[(56)]);
var inst_32458 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32750 = state_32707;
(statearr_32750[(18)] = inst_32458);

return statearr_32750;
})();
if(cljs.core.truth_(inst_32337)){
var statearr_32751_32951 = state_32707__$1;
(statearr_32751_32951[(1)] = (55));

} else {
var statearr_32752_32952 = state_32707__$1;
(statearr_32752_32952[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (92))){
var inst_32331 = (state_32707[(17)]);
var inst_32458 = (state_32707[(18)]);
var inst_32478 = (state_32707[(19)]);
var inst_32524 = (state_32707[(20)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32518 = (state_32707[(23)]);
var inst_32387 = (state_32707[(24)]);
var inst_32528 = (state_32707[(25)]);
var inst_32555 = (state_32707[(63)]);
var inst_32422 = (state_32707[(26)]);
var inst_32534 = (state_32707[(10)]);
var inst_32514 = (state_32707[(27)]);
var inst_32418 = (state_32707[(28)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32519 = (state_32707[(32)]);
var inst_32467 = (state_32707[(33)]);
var inst_32500 = (state_32707[(34)]);
var inst_32533 = (state_32707[(35)]);
var inst_32343 = (state_32707[(36)]);
var inst_32509 = (state_32707[(37)]);
var inst_32477 = (state_32707[(38)]);
var inst_32367 = (state_32707[(39)]);
var inst_32532 = (state_32707[(40)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32419 = (state_32707[(43)]);
var inst_32541 = (state_32707[(44)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32508 = (state_32707[(47)]);
var inst_32366 = (state_32707[(48)]);
var inst_32507 = (state_32707[(12)]);
var inst_32531 = (state_32707[(49)]);
var inst_32338 = (state_32707[(50)]);
var inst_32476 = (state_32707[(51)]);
var inst_32342 = (state_32707[(52)]);
var inst_32513 = (state_32707[(53)]);
var inst_32557 = (function (){var no_filter_QMARK_ = true;
var t = inst_32514;
var max_limit_QMARK_ = inst_32508;
var next_node = inst_32531;
var fast_forward_db_QMARK_ = inst_32519;
var G__32542 = inst_32555;
var s1 = inst_32378;
var o2 = inst_32440;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var i = inst_32533;
var m1 = inst_32467;
var root_node = inst_32524;
var s2 = inst_32387;
var vec__32327 = inst_32419;
var p2 = inst_32458;
var vec__32324 = inst_32418;
var permissions = inst_32509;
var vec__32320 = inst_32338;
var limit = inst_32507;
var vec__32317 = inst_32331;
var start_flake = inst_32477;
var flake_limit = inst_32501;
var offset = inst_32532;
var acc = inst_32535;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32431;
var end_flake = inst_32478;
var base_result = inst_32541;
var s = inst_32534;
var node_start = inst_32528;
var p1 = inst_32449;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32422;
var idx_compare = inst_32513;
var map__32330 = inst_32500;
var op2 = inst_32343;
var m2 = inst_32476;
var novelty = inst_32518;
return (function (p1__32300_SHARP_){
var G__32753 = p1__32300_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__32753) : predicate_fn.call(null,G__32753));
});
})();
var inst_32558 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_32557,inst_32555);
var state_32707__$1 = state_32707;
var statearr_32754_32953 = state_32707__$1;
(statearr_32754_32953[(2)] = inst_32558);

(statearr_32754_32953[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (104))){
var inst_32534 = (state_32707[(10)]);
var inst_32533 = (state_32707[(35)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32567 = (state_32707[(64)]);
var inst_32579 = cljs.core.count(inst_32567);
var inst_32580 = (inst_32501 - inst_32533);
var inst_32581 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_32580,inst_32567);
var inst_32582 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32535,inst_32581);
var inst_32583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32584 = (inst_32533 + inst_32579);
var inst_32585 = [(0),inst_32584,inst_32534,inst_32582];
var inst_32586 = (new cljs.core.PersistentVector(null,4,(5),inst_32583,inst_32585,null));
var state_32707__$1 = state_32707;
var statearr_32755_32954 = state_32707__$1;
(statearr_32755_32954[(2)] = inst_32586);

(statearr_32755_32954[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (15))){
var inst_32332 = (state_32707[(65)]);
var inst_32372 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32332);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(18),inst_32372);
} else {
if((state_val_32708 === (48))){
var inst_32340 = (state_32707[(66)]);
var inst_32449 = (state_32707[(2)]);
var inst_32450 = (inst_32340 == null);
var state_32707__$1 = (function (){var statearr_32756 = state_32707;
(statearr_32756[(29)] = inst_32449);

return statearr_32756;
})();
if(cljs.core.truth_(inst_32450)){
var statearr_32757_32955 = state_32707__$1;
(statearr_32757_32955[(1)] = (49));

} else {
var statearr_32758_32956 = state_32707__$1;
(statearr_32758_32956[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (50))){
var state_32707__$1 = state_32707;
var statearr_32759_32957 = state_32707__$1;
(statearr_32759_32957[(2)] = false);

(statearr_32759_32957[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (116))){
var inst_32627 = (state_32707[(67)]);
var inst_32629 = (state_32707[(68)]);
var inst_32501 = (state_32707[(45)]);
var inst_32628 = (state_32707[(69)]);
var inst_32632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32633 = (inst_32629 - inst_32501);
var inst_32634 = (inst_32628 - inst_32633);
var inst_32635 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_32634,inst_32627);
var inst_32636 = [inst_32501,inst_32635];
var inst_32637 = (new cljs.core.PersistentVector(null,2,(5),inst_32632,inst_32636,null));
var state_32707__$1 = state_32707;
var statearr_32760_32958 = state_32707__$1;
(statearr_32760_32958[(2)] = inst_32637);

(statearr_32760_32958[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (75))){
var inst_32502 = (state_32707[(70)]);
var inst_32500 = (state_32707[(34)]);
var inst_32500__$1 = (state_32707[(2)]);
var inst_32501 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_32500__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_32502__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32500__$1,cljs.core.cst$kw$limit);
var inst_32503 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_32500__$1,cljs.core.cst$kw$offset,(0));
var state_32707__$1 = (function (){var statearr_32761 = state_32707;
(statearr_32761[(70)] = inst_32502__$1);

(statearr_32761[(71)] = inst_32503);

(statearr_32761[(34)] = inst_32500__$1);

(statearr_32761[(45)] = inst_32501);

return statearr_32761;
})();
if(cljs.core.truth_(inst_32502__$1)){
var statearr_32762_32959 = state_32707__$1;
(statearr_32762_32959[(1)] = (76));

} else {
var statearr_32763_32960 = state_32707__$1;
(statearr_32763_32960[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (99))){
var inst_32508 = (state_32707[(47)]);
var state_32707__$1 = state_32707;
var statearr_32764_32961 = state_32707__$1;
(statearr_32764_32961[(2)] = inst_32508);

(statearr_32764_32961[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (21))){
var inst_32334 = (state_32707[(72)]);
var inst_32387 = (state_32707[(2)]);
var inst_32388 = cljs.core.boolean_QMARK_(inst_32334);
var state_32707__$1 = (function (){var statearr_32765 = state_32707;
(statearr_32765[(24)] = inst_32387);

return statearr_32765;
})();
if(inst_32388){
var statearr_32766_32962 = state_32707__$1;
(statearr_32766_32962[(1)] = (23));

} else {
var statearr_32767_32963 = state_32707__$1;
(statearr_32767_32963[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (31))){
var inst_32397 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32768_32964 = state_32707__$1;
(statearr_32768_32964[(2)] = inst_32397);

(statearr_32768_32964[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (113))){
var inst_32609 = (state_32707[(9)]);
var inst_32507 = (state_32707[(12)]);
var inst_32611 = (state_32707[(14)]);
var inst_32614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32615 = (inst_32609 - inst_32611);
var inst_32616 = [inst_32507,inst_32615];
var inst_32617 = (new cljs.core.PersistentVector(null,2,(5),inst_32614,inst_32616,null));
var state_32707__$1 = state_32707;
var statearr_32769_32965 = state_32707__$1;
(statearr_32769_32965[(2)] = inst_32617);

(statearr_32769_32965[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (32))){
var inst_32369 = (state_32707[(73)]);
var inst_32331 = (state_32707[(17)]);
var inst_32401 = (state_32707[(74)]);
var inst_32337 = (state_32707[(56)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32387 = (state_32707[(24)]);
var inst_32344 = (state_32707[(75)]);
var inst_32335 = (state_32707[(30)]);
var inst_32333 = (state_32707[(76)]);
var inst_32343 = (state_32707[(36)]);
var inst_32367 = (state_32707[(39)]);
var inst_32336 = (state_32707[(41)]);
var inst_32334 = (state_32707[(72)]);
var inst_32340 = (state_32707[(66)]);
var inst_32341 = (state_32707[(55)]);
var inst_32366 = (state_32707[(48)]);
var inst_32338 = (state_32707[(50)]);
var inst_32342 = (state_32707[(52)]);
var inst_32403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32405 = [null,null];
var inst_32406 = (new cljs.core.PersistentVector(null,2,(5),inst_32404,inst_32405,null));
var inst_32407 = (function (){var bool = inst_32401;
var temp__5733__auto__ = inst_32401;
var s1 = inst_32378;
var o2 = inst_32341;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var m1 = inst_32337;
var s2 = inst_32387;
var p2 = inst_32340;
var vec__32320 = inst_32338;
var vec__32317 = inst_32331;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32334;
var p1 = inst_32333;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32369;
var op2 = inst_32343;
var m2 = inst_32344;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_32408 = [inst_32406,inst_32407];
var inst_32409 = (new cljs.core.PersistentVector(null,2,(5),inst_32403,inst_32408,null));
var state_32707__$1 = state_32707;
var statearr_32770_32966 = state_32707__$1;
(statearr_32770_32966[(2)] = inst_32409);

(statearr_32770_32966[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (40))){
var inst_32421 = (state_32707[(57)]);
var state_32707__$1 = state_32707;
var statearr_32771_32967 = state_32707__$1;
(statearr_32771_32967[(2)] = inst_32421);

(statearr_32771_32967[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (129))){
var inst_32691 = (state_32707[(2)]);
var inst_32692 = cljs.core.not(inst_32691);
var state_32707__$1 = state_32707;
if(inst_32692){
var statearr_32772_32968 = state_32707__$1;
(statearr_32772_32968[(1)] = (130));

} else {
var statearr_32773_32969 = state_32707__$1;
(statearr_32773_32969[(1)] = (131));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (91))){
var inst_32368 = (state_32707[(21)]);
var inst_32555 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32774 = state_32707;
(statearr_32774[(63)] = inst_32555);

return statearr_32774;
})();
if(cljs.core.truth_(inst_32368)){
var statearr_32775_32970 = state_32707__$1;
(statearr_32775_32970[(1)] = (92));

} else {
var statearr_32776_32971 = state_32707__$1;
(statearr_32776_32971[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (117))){
var inst_32627 = (state_32707[(67)]);
var inst_32629 = (state_32707[(68)]);
var inst_32639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32640 = [inst_32629,inst_32627];
var inst_32641 = (new cljs.core.PersistentVector(null,2,(5),inst_32639,inst_32640,null));
var state_32707__$1 = state_32707;
var statearr_32777_32972 = state_32707__$1;
(statearr_32777_32972[(2)] = inst_32641);

(statearr_32777_32972[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (108))){
var inst_32589 = (state_32707[(77)]);
var inst_32532 = (state_32707[(40)]);
var inst_32601 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_32532,inst_32589);
var state_32707__$1 = (function (){var statearr_32778 = state_32707;
(statearr_32778[(11)] = inst_32601);

return statearr_32778;
})();
var statearr_32779_32973 = state_32707__$1;
(statearr_32779_32973[(1)] = (110));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (56))){
var inst_32461 = (cljs.core._GT__EQ_ === start_test);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32461)){
var statearr_32781_32974 = state_32707__$1;
(statearr_32781_32974[(1)] = (58));

} else {
var statearr_32782_32975 = state_32707__$1;
(statearr_32782_32975[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (33))){
var inst_32369 = (state_32707[(73)]);
var inst_32334 = (state_32707[(72)]);
var inst_32341 = (state_32707[(55)]);
var inst_32411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32413 = [inst_32334,inst_32341];
var inst_32414 = (new cljs.core.PersistentVector(null,2,(5),inst_32412,inst_32413,null));
var inst_32415 = [inst_32414,inst_32369];
var inst_32416 = (new cljs.core.PersistentVector(null,2,(5),inst_32411,inst_32415,null));
var state_32707__$1 = state_32707;
var statearr_32783_32976 = state_32707__$1;
(statearr_32783_32976[(2)] = inst_32416);

(statearr_32783_32976[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (13))){
var inst_32345 = (state_32707[(78)]);
var state_32707__$1 = state_32707;
var statearr_32784_32977 = state_32707__$1;
(statearr_32784_32977[(2)] = inst_32345);

(statearr_32784_32977[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (22))){
var inst_32383 = (state_32707[(2)]);
var inst_32384 = fluree.db.util.async.throw_err(inst_32383);
var state_32707__$1 = state_32707;
var statearr_32785_32978 = state_32707__$1;
(statearr_32785_32978[(2)] = inst_32384);

(statearr_32785_32978[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (90))){
var inst_32549 = (state_32707[(58)]);
var state_32707__$1 = state_32707;
var statearr_32786_32979 = state_32707__$1;
(statearr_32786_32979[(2)] = inst_32549);

(statearr_32786_32979[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (109))){
var inst_32664 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32787_32980 = state_32707__$1;
(statearr_32787_32980[(2)] = inst_32664);

(statearr_32787_32980[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (36))){
var inst_32420 = (state_32707[(79)]);
var state_32707__$1 = state_32707;
var statearr_32788_32981 = state_32707__$1;
(statearr_32788_32981[(2)] = inst_32420);

(statearr_32788_32981[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (41))){
var inst_32333 = (state_32707[(76)]);
var inst_32440 = (state_32707[(2)]);
var inst_32441 = (inst_32333 == null);
var state_32707__$1 = (function (){var statearr_32789 = state_32707;
(statearr_32789[(31)] = inst_32440);

return statearr_32789;
})();
if(cljs.core.truth_(inst_32441)){
var statearr_32790_32982 = state_32707__$1;
(statearr_32790_32982[(1)] = (43));

} else {
var statearr_32791_32983 = state_32707__$1;
(statearr_32791_32983[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (118))){
var inst_32624 = (state_32707[(80)]);
var inst_32643 = (state_32707[(2)]);
var inst_32644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32643,(0),null);
var inst_32645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32643,(1),null);
var inst_32646 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32647 = [inst_32644,inst_32624,inst_32645];
var inst_32648 = (new cljs.core.PersistentVector(null,3,(5),inst_32646,inst_32647,null));
var state_32707__$1 = state_32707;
var statearr_32792_32984 = state_32707__$1;
(statearr_32792_32984[(2)] = inst_32648);

(statearr_32792_32984[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (89))){
var inst_32331 = (state_32707[(17)]);
var inst_32458 = (state_32707[(18)]);
var inst_32478 = (state_32707[(19)]);
var inst_32524 = (state_32707[(20)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32518 = (state_32707[(23)]);
var inst_32387 = (state_32707[(24)]);
var inst_32528 = (state_32707[(25)]);
var inst_32422 = (state_32707[(26)]);
var inst_32534 = (state_32707[(10)]);
var inst_32549 = (state_32707[(58)]);
var inst_32514 = (state_32707[(27)]);
var inst_32418 = (state_32707[(28)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32519 = (state_32707[(32)]);
var inst_32467 = (state_32707[(33)]);
var inst_32500 = (state_32707[(34)]);
var inst_32533 = (state_32707[(35)]);
var inst_32343 = (state_32707[(36)]);
var inst_32509 = (state_32707[(37)]);
var inst_32477 = (state_32707[(38)]);
var inst_32367 = (state_32707[(39)]);
var inst_32532 = (state_32707[(40)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32419 = (state_32707[(43)]);
var inst_32541 = (state_32707[(44)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32508 = (state_32707[(47)]);
var inst_32366 = (state_32707[(48)]);
var inst_32507 = (state_32707[(12)]);
var inst_32531 = (state_32707[(49)]);
var inst_32338 = (state_32707[(50)]);
var inst_32476 = (state_32707[(51)]);
var inst_32342 = (state_32707[(52)]);
var inst_32513 = (state_32707[(53)]);
var inst_32551 = (function (){var no_filter_QMARK_ = true;
var t = inst_32514;
var max_limit_QMARK_ = inst_32508;
var next_node = inst_32531;
var fast_forward_db_QMARK_ = inst_32519;
var G__32542 = inst_32549;
var s1 = inst_32378;
var o2 = inst_32440;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var i = inst_32533;
var m1 = inst_32467;
var root_node = inst_32524;
var s2 = inst_32387;
var vec__32327 = inst_32419;
var p2 = inst_32458;
var vec__32324 = inst_32418;
var permissions = inst_32509;
var vec__32320 = inst_32338;
var limit = inst_32507;
var vec__32317 = inst_32331;
var start_flake = inst_32477;
var flake_limit = inst_32501;
var offset = inst_32532;
var acc = inst_32535;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32431;
var end_flake = inst_32478;
var base_result = inst_32541;
var s = inst_32534;
var node_start = inst_32528;
var p1 = inst_32449;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32422;
var idx_compare = inst_32513;
var map__32330 = inst_32500;
var op2 = inst_32343;
var m2 = inst_32476;
var novelty = inst_32518;
return (function (p1__32299_SHARP_){
var G__32793 = p1__32299_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__32793) : subject_fn.call(null,G__32793));
});
})();
var inst_32552 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_32551,inst_32549);
var state_32707__$1 = state_32707;
var statearr_32794_32985 = state_32707__$1;
(statearr_32794_32985[(2)] = inst_32552);

(statearr_32794_32985[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (100))){
var inst_32577 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32577)){
var statearr_32795_32986 = state_32707__$1;
(statearr_32795_32986[(1)] = (104));

} else {
var statearr_32796_32987 = state_32707__$1;
(statearr_32796_32987[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (131))){
var inst_32667 = (state_32707[(59)]);
var inst_32668 = (state_32707[(60)]);
var inst_32670 = (state_32707[(15)]);
var inst_32669 = (state_32707[(61)]);
var inst_32687 = (state_32707[(81)]);
var inst_32531 = inst_32687;
var inst_32532 = inst_32667;
var inst_32533 = inst_32668;
var inst_32534 = inst_32669;
var inst_32535 = inst_32670;
var state_32707__$1 = (function (){var statearr_32797 = state_32707;
(statearr_32797[(10)] = inst_32534);

(statearr_32797[(35)] = inst_32533);

(statearr_32797[(40)] = inst_32532);

(statearr_32797[(46)] = inst_32535);

(statearr_32797[(49)] = inst_32531);

return statearr_32797;
})();
var statearr_32798_32988 = state_32707__$1;
(statearr_32798_32988[(2)] = null);

(statearr_32798_32988[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (122))){
var inst_32679 = (state_32707[(16)]);
var inst_32679__$1 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32799 = state_32707;
(statearr_32799[(16)] = inst_32679__$1);

return statearr_32799;
})();
if(cljs.core.truth_(inst_32679__$1)){
var statearr_32800_32989 = state_32707__$1;
(statearr_32800_32989[(1)] = (123));

} else {
var statearr_32801_32990 = state_32707__$1;
(statearr_32801_32990[(1)] = (124));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (43))){
var inst_32431 = (state_32707[(42)]);
var state_32707__$1 = state_32707;
var statearr_32802_32991 = state_32707__$1;
(statearr_32802_32991[(2)] = inst_32431);

(statearr_32802_32991[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (61))){
var inst_32344 = (state_32707[(75)]);
var state_32707__$1 = state_32707;
var statearr_32803_32992 = state_32707__$1;
(statearr_32803_32992[(2)] = inst_32344);

(statearr_32803_32992[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (29))){
var state_32707__$1 = state_32707;
var statearr_32804_32993 = state_32707__$1;
(statearr_32804_32993[(2)] = null);

(statearr_32804_32993[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (44))){
var state_32707__$1 = state_32707;
var statearr_32805_32994 = state_32707__$1;
(statearr_32805_32994[(2)] = false);

(statearr_32805_32994[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (93))){
var inst_32555 = (state_32707[(63)]);
var state_32707__$1 = state_32707;
var statearr_32806_32995 = state_32707__$1;
(statearr_32806_32995[(2)] = inst_32555);

(statearr_32806_32995[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (6))){
var inst_32345 = (state_32707[(78)]);
var inst_32350 = inst_32345.cljs$lang$protocol_mask$partition0$;
var inst_32351 = (inst_32350 & (64));
var inst_32352 = inst_32345.cljs$core$ISeq$;
var inst_32353 = (cljs.core.PROTOCOL_SENTINEL === inst_32352);
var inst_32354 = ((inst_32351) || (inst_32353));
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32354)){
var statearr_32807_32996 = state_32707__$1;
(statearr_32807_32996[(1)] = (9));

} else {
var statearr_32808_32997 = state_32707__$1;
(statearr_32808_32997[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (111))){
var inst_32534 = (state_32707[(10)]);
var inst_32533 = (state_32707[(35)]);
var inst_32601 = (state_32707[(11)]);
var inst_32501 = (state_32707[(45)]);
var inst_32507 = (state_32707[(12)]);
var inst_32650 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_32601,inst_32533,inst_32534,inst_32501,inst_32507);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(119),inst_32650);
} else {
if((state_val_32708 === (28))){
var inst_32399 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32809_32998 = state_32707__$1;
(statearr_32809_32998[(2)] = inst_32399);

(statearr_32809_32998[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (64))){
var state_32707__$1 = state_32707;
var statearr_32810_32999 = state_32707__$1;
(statearr_32810_32999[(2)] = (2147483647));

(statearr_32810_32999[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (103))){
var inst_32574 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32811_33000 = state_32707__$1;
(statearr_32811_33000[(2)] = inst_32574);

(statearr_32811_33000[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (51))){
var inst_32454 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32454)){
var statearr_32812_33001 = state_32707__$1;
(statearr_32812_33001[(1)] = (52));

} else {
var statearr_32813_33002 = state_32707__$1;
(statearr_32813_33002[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (25))){
var inst_32401 = (state_32707[(74)]);
var inst_32401__$1 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32814 = state_32707;
(statearr_32814[(74)] = inst_32401__$1);

return statearr_32814;
})();
if(cljs.core.truth_(inst_32401__$1)){
var statearr_32815_33003 = state_32707__$1;
(statearr_32815_33003[(1)] = (32));

} else {
var statearr_32816_33004 = state_32707__$1;
(statearr_32816_33004[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (34))){
var inst_32420 = (state_32707[(79)]);
var inst_32418 = (state_32707[(28)]);
var inst_32419 = (state_32707[(43)]);
var inst_32418__$1 = (state_32707[(2)]);
var inst_32419__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32418__$1,(0),null);
var inst_32420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32419__$1,(0),null);
var inst_32421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32419__$1,(1),null);
var inst_32422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32418__$1,(1),null);
var inst_32423 = fluree.db.util.core.pred_ident_QMARK_(inst_32420__$1);
var state_32707__$1 = (function (){var statearr_32817 = state_32707;
(statearr_32817[(79)] = inst_32420__$1);

(statearr_32817[(57)] = inst_32421);

(statearr_32817[(26)] = inst_32422);

(statearr_32817[(28)] = inst_32418__$1);

(statearr_32817[(43)] = inst_32419__$1);

return statearr_32817;
})();
if(inst_32423){
var statearr_32818_33005 = state_32707__$1;
(statearr_32818_33005[(1)] = (35));

} else {
var statearr_32819_33006 = state_32707__$1;
(statearr_32819_33006[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (125))){
var inst_32679 = (state_32707[(16)]);
var inst_32687 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32820 = state_32707;
(statearr_32820[(81)] = inst_32687);

return statearr_32820;
})();
if(cljs.core.truth_(inst_32679)){
var statearr_32821_33007 = state_32707__$1;
(statearr_32821_33007[(1)] = (127));

} else {
var statearr_32822_33008 = state_32707__$1;
(statearr_32822_33008[(1)] = (128));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (17))){
var inst_32339 = (state_32707[(54)]);
var inst_32378 = (state_32707[(2)]);
var inst_32379 = fluree.db.util.core.pred_ident_QMARK_(inst_32339);
var state_32707__$1 = (function (){var statearr_32823 = state_32707;
(statearr_32823[(22)] = inst_32378);

return statearr_32823;
})();
if(inst_32379){
var statearr_32824_33009 = state_32707__$1;
(statearr_32824_33009[(1)] = (19));

} else {
var statearr_32825_33010 = state_32707__$1;
(statearr_32825_33010[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (3))){
var inst_32705 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32707__$1,inst_32705);
} else {
if((state_val_32708 === (12))){
var inst_32345 = (state_32707[(78)]);
var inst_32363 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32345);
var state_32707__$1 = state_32707;
var statearr_32826_33011 = state_32707__$1;
(statearr_32826_33011[(2)] = inst_32363);

(statearr_32826_33011[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (2))){
var inst_32331 = (state_32707[(17)]);
var inst_32345 = (state_32707[(78)]);
var inst_32338 = (state_32707[(50)]);
var _ = (function (){var statearr_32827 = state_32707;
(statearr_32827[(4)] = cljs.core.cons((5),(state_32707[(4)])));

return statearr_32827;
})();
var inst_32331__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_32332 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(0),null);
var inst_32333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(1),null);
var inst_32334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(2),null);
var inst_32335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(3),null);
var inst_32336 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(4),null);
var inst_32337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32331__$1,(5),null);
var inst_32338__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_32339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(0),null);
var inst_32340 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(1),null);
var inst_32341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(2),null);
var inst_32342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(3),null);
var inst_32343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(4),null);
var inst_32344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32338__$1,(5),null);
var inst_32345__$1 = opts;
var inst_32347 = (inst_32345__$1 == null);
var inst_32348 = cljs.core.not(inst_32347);
var state_32707__$1 = (function (){var statearr_32828 = state_32707;
(statearr_32828[(17)] = inst_32331__$1);

(statearr_32828[(56)] = inst_32337);

(statearr_32828[(65)] = inst_32332);

(statearr_32828[(75)] = inst_32344);

(statearr_32828[(78)] = inst_32345__$1);

(statearr_32828[(30)] = inst_32335);

(statearr_32828[(76)] = inst_32333);

(statearr_32828[(36)] = inst_32343);

(statearr_32828[(41)] = inst_32336);

(statearr_32828[(72)] = inst_32334);

(statearr_32828[(66)] = inst_32340);

(statearr_32828[(55)] = inst_32341);

(statearr_32828[(50)] = inst_32338__$1);

(statearr_32828[(52)] = inst_32342);

(statearr_32828[(54)] = inst_32339);

return statearr_32828;
})();
if(inst_32348){
var statearr_32829_33012 = state_32707__$1;
(statearr_32829_33012[(1)] = (6));

} else {
var statearr_32830_33013 = state_32707__$1;
(statearr_32830_33013[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (66))){
var inst_32474 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32831_33014 = state_32707__$1;
(statearr_32831_33014[(2)] = inst_32474);

(statearr_32831_33014[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (107))){
var inst_32534 = (state_32707[(10)]);
var inst_32533 = (state_32707[(35)]);
var inst_32532 = (state_32707[(40)]);
var inst_32535 = (state_32707[(46)]);
var inst_32590 = (state_32707[(82)]);
var inst_32593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32594 = (inst_32532 - inst_32590);
var inst_32595 = [inst_32594,inst_32533,inst_32534,inst_32535];
var inst_32596 = (new cljs.core.PersistentVector(null,4,(5),inst_32593,inst_32595,null));
var state_32707__$1 = state_32707;
var statearr_32832_33015 = state_32707__$1;
(statearr_32832_33015[(2)] = inst_32596);

(statearr_32832_33015[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (23))){
var inst_32334 = (state_32707[(72)]);
var state_32707__$1 = state_32707;
var statearr_32833_33016 = state_32707__$1;
(statearr_32833_33016[(2)] = inst_32334);

(statearr_32833_33016[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (47))){
var inst_32333 = (state_32707[(76)]);
var state_32707__$1 = state_32707;
var statearr_32834_33017 = state_32707__$1;
(statearr_32834_33017[(2)] = inst_32333);

(statearr_32834_33017[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (35))){
var inst_32420 = (state_32707[(79)]);
var inst_32425 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32420);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(38),inst_32425);
} else {
if((state_val_32708 === (127))){
var inst_32687 = (state_32707[(81)]);
var state_32707__$1 = state_32707;
var statearr_32835_33018 = state_32707__$1;
(statearr_32835_33018[(2)] = inst_32687);

(statearr_32835_33018[(1)] = (129));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (82))){
var state_32707__$1 = state_32707;
var statearr_32836_33019 = state_32707__$1;
(statearr_32836_33019[(2)] = null);

(statearr_32836_33019[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (76))){
var inst_32502 = (state_32707[(70)]);
var state_32707__$1 = state_32707;
var statearr_32837_33020 = state_32707__$1;
(statearr_32837_33020[(2)] = inst_32502);

(statearr_32837_33020[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (97))){
var inst_32508 = (state_32707[(47)]);
var inst_32531 = (state_32707[(49)]);
var inst_32567 = (state_32707[(2)]);
var inst_32568 = fluree.db.dbproto._rhs(inst_32531);
var state_32707__$1 = (function (){var statearr_32838 = state_32707;
(statearr_32838[(7)] = inst_32568);

(statearr_32838[(64)] = inst_32567);

return statearr_32838;
})();
if(cljs.core.truth_(inst_32508)){
var statearr_32839_33021 = state_32707__$1;
(statearr_32839_33021[(1)] = (98));

} else {
var statearr_32840_33022 = state_32707__$1;
(statearr_32840_33022[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (19))){
var inst_32339 = (state_32707[(54)]);
var inst_32381 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32339);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(22),inst_32381);
} else {
if((state_val_32708 === (57))){
var inst_32344 = (state_32707[(75)]);
var inst_32467 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32841 = state_32707;
(statearr_32841[(33)] = inst_32467);

return statearr_32841;
})();
if(cljs.core.truth_(inst_32344)){
var statearr_32842_33023 = state_32707__$1;
(statearr_32842_33023[(1)] = (61));

} else {
var statearr_32843_33024 = state_32707__$1;
(statearr_32843_33024[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (68))){
var state_32707__$1 = state_32707;
var statearr_32844_33025 = state_32707__$1;
(statearr_32844_33025[(2)] = false);

(statearr_32844_33025[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (11))){
var inst_32358 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32845_33026 = state_32707__$1;
(statearr_32845_33026[(2)] = inst_32358);

(statearr_32845_33026[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (115))){
var inst_32627 = (state_32707[(67)]);
var inst_32533 = (state_32707[(35)]);
var inst_32601 = (state_32707[(11)]);
var inst_32629 = (state_32707[(68)]);
var inst_32501 = (state_32707[(45)]);
var inst_32628 = (state_32707[(69)]);
var inst_32623 = (state_32707[(2)]);
var inst_32624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32623,(0),null);
var inst_32625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32623,(1),null);
var inst_32626 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_32625,inst_32601);
var inst_32627__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_32626);
var inst_32628__$1 = cljs.core.count(inst_32627__$1);
var inst_32629__$1 = (inst_32533 + inst_32628__$1);
var inst_32630 = (inst_32629__$1 > inst_32501);
var state_32707__$1 = (function (){var statearr_32847 = state_32707;
(statearr_32847[(67)] = inst_32627__$1);

(statearr_32847[(80)] = inst_32624);

(statearr_32847[(68)] = inst_32629__$1);

(statearr_32847[(69)] = inst_32628__$1);

return statearr_32847;
})();
if(cljs.core.truth_(inst_32630)){
var statearr_32848_33027 = state_32707__$1;
(statearr_32848_33027[(1)] = (116));

} else {
var statearr_32849_33028 = state_32707__$1;
(statearr_32849_33028[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (9))){
var state_32707__$1 = state_32707;
var statearr_32850_33029 = state_32707__$1;
(statearr_32850_33029[(2)] = true);

(statearr_32850_33029[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (5))){
var _ = (function (){var statearr_32851 = state_32707;
(statearr_32851[(4)] = cljs.core.rest((state_32707[(4)])));

return statearr_32851;
})();
var state_32707__$1 = state_32707;
var ex32846 = (state_32707__$1[(2)]);
var statearr_32852_33030 = state_32707__$1;
(statearr_32852_33030[(5)] = ex32846);


if((ex32846 instanceof Error)){
var statearr_32853_33031 = state_32707__$1;
(statearr_32853_33031[(1)] = (4));

(statearr_32853_33031[(5)] = null);

} else {
throw ex32846;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (112))){
var inst_32535 = (state_32707[(46)]);
var inst_32655 = (state_32707[(2)]);
var inst_32656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32655,(0),null);
var inst_32657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32655,(1),null);
var inst_32658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32655,(2),null);
var inst_32659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32660 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32535,inst_32658);
var inst_32661 = [(0),inst_32656,inst_32657,inst_32660];
var inst_32662 = (new cljs.core.PersistentVector(null,4,(5),inst_32659,inst_32661,null));
var state_32707__$1 = state_32707;
var statearr_32854_33032 = state_32707__$1;
(statearr_32854_33032[(2)] = inst_32662);

(statearr_32854_33032[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (83))){
var inst_32702 = (state_32707[(2)]);
var _ = (function (){var statearr_32855 = state_32707;
(statearr_32855[(4)] = cljs.core.rest((state_32707[(4)])));

return statearr_32855;
})();
var state_32707__$1 = state_32707;
var statearr_32856_33033 = state_32707__$1;
(statearr_32856_33033[(2)] = inst_32702);

(statearr_32856_33033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (14))){
var inst_32332 = (state_32707[(65)]);
var inst_32366 = (state_32707[(48)]);
var inst_32366__$1 = (state_32707[(2)]);
var inst_32367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32366__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_32368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32366__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_32369 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32366__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_32370 = fluree.db.util.core.pred_ident_QMARK_(inst_32332);
var state_32707__$1 = (function (){var statearr_32857 = state_32707;
(statearr_32857[(73)] = inst_32369);

(statearr_32857[(21)] = inst_32368);

(statearr_32857[(39)] = inst_32367);

(statearr_32857[(48)] = inst_32366__$1);

return statearr_32857;
})();
if(inst_32370){
var statearr_32858_33034 = state_32707__$1;
(statearr_32858_33034[(1)] = (15));

} else {
var statearr_32859_33035 = state_32707__$1;
(statearr_32859_33035[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (45))){
var inst_32445 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32445)){
var statearr_32860_33036 = state_32707__$1;
(statearr_32860_33036[(1)] = (46));

} else {
var statearr_32861_33037 = state_32707__$1;
(statearr_32861_33037[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (53))){
var inst_32340 = (state_32707[(66)]);
var state_32707__$1 = state_32707;
var statearr_32862_33038 = state_32707__$1;
(statearr_32862_33038[(2)] = inst_32340);

(statearr_32862_33038[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (78))){
var inst_32507 = (state_32707[(12)]);
var inst_32507__$1 = (state_32707[(2)]);
var inst_32508 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32507__$1,fluree.db.util.core.max_long);
var inst_32509 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_32510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32511 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_32512 = (new cljs.core.PersistentVector(null,3,(5),inst_32510,inst_32511,null));
var inst_32513 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_32512);
var inst_32514 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32516 = [cljs.core.cst$kw$novelty,idx];
var inst_32517 = (new cljs.core.PersistentVector(null,2,(5),inst_32515,inst_32516,null));
var inst_32518 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_32517);
var inst_32519 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_32520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_32521 = fluree.db.dbproto._resolve(inst_32520);
var state_32707__$1 = (function (){var statearr_32863 = state_32707;
(statearr_32863[(23)] = inst_32518);

(statearr_32863[(27)] = inst_32514);

(statearr_32863[(32)] = inst_32519);

(statearr_32863[(37)] = inst_32509);

(statearr_32863[(47)] = inst_32508);

(statearr_32863[(12)] = inst_32507__$1);

(statearr_32863[(53)] = inst_32513);

return statearr_32863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(79),inst_32521);
} else {
if((state_val_32708 === (132))){
var inst_32697 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
var statearr_32864_33039 = state_32707__$1;
(statearr_32864_33039[(2)] = inst_32697);

(statearr_32864_33039[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (26))){
var inst_32341 = (state_32707[(55)]);
var state_32707__$1 = state_32707;
var statearr_32865_33040 = state_32707__$1;
(statearr_32865_33040[(2)] = inst_32341);

(statearr_32865_33040[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (123))){
var inst_32524 = (state_32707[(20)]);
var inst_32518 = (state_32707[(23)]);
var inst_32568 = (state_32707[(7)]);
var inst_32514 = (state_32707[(27)]);
var inst_32519 = (state_32707[(32)]);
var inst_32681 = fluree.db.query.range.find_next_valid_node(inst_32524,inst_32568,inst_32514,inst_32518,inst_32519);
var state_32707__$1 = state_32707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(126),inst_32681);
} else {
if((state_val_32708 === (16))){
var inst_32332 = (state_32707[(65)]);
var state_32707__$1 = state_32707;
var statearr_32866_33041 = state_32707__$1;
(statearr_32866_33041[(2)] = inst_32332);

(statearr_32866_33041[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (81))){
var inst_32528 = (state_32707[(25)]);
var inst_32503 = (state_32707[(71)]);
var inst_32530 = cljs.core.PersistentVector.EMPTY;
var inst_32531 = inst_32528;
var inst_32532 = inst_32503;
var inst_32533 = (0);
var inst_32534 = (0);
var inst_32535 = inst_32530;
var state_32707__$1 = (function (){var statearr_32867 = state_32707;
(statearr_32867[(10)] = inst_32534);

(statearr_32867[(35)] = inst_32533);

(statearr_32867[(40)] = inst_32532);

(statearr_32867[(46)] = inst_32535);

(statearr_32867[(49)] = inst_32531);

return statearr_32867;
})();
var statearr_32868_33042 = state_32707__$1;
(statearr_32868_33042[(2)] = null);

(statearr_32868_33042[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (120))){
var inst_32478 = (state_32707[(19)]);
var inst_32668 = (state_32707[(60)]);
var inst_32568 = (state_32707[(7)]);
var inst_32669 = (state_32707[(61)]);
var inst_32501 = (state_32707[(45)]);
var inst_32507 = (state_32707[(12)]);
var inst_32513 = (state_32707[(53)]);
var inst_32672 = (inst_32513.cljs$core$IFn$_invoke$arity$2 ? inst_32513.cljs$core$IFn$_invoke$arity$2(inst_32568,inst_32478) : inst_32513.call(null,inst_32568,inst_32478));
var inst_32673 = (inst_32672 < (0));
var inst_32674 = (inst_32668 < inst_32501);
var inst_32675 = (inst_32669 < inst_32507);
var inst_32676 = ((inst_32673) && (inst_32674) && (inst_32675));
var state_32707__$1 = state_32707;
var statearr_32869_33043 = state_32707__$1;
(statearr_32869_33043[(2)] = inst_32676);

(statearr_32869_33043[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (79))){
var inst_32524 = (state_32707[(20)]);
var inst_32518 = (state_32707[(23)]);
var inst_32514 = (state_32707[(27)]);
var inst_32519 = (state_32707[(32)]);
var inst_32477 = (state_32707[(38)]);
var inst_32523 = (state_32707[(2)]);
var inst_32524__$1 = fluree.db.util.async.throw_err(inst_32523);
var inst_32525 = fluree.db.query.range.find_next_valid_node(inst_32524__$1,inst_32477,inst_32514,inst_32518,inst_32519);
var state_32707__$1 = (function (){var statearr_32870 = state_32707;
(statearr_32870[(20)] = inst_32524__$1);

return statearr_32870;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32707__$1,(80),inst_32525);
} else {
if((state_val_32708 === (38))){
var inst_32427 = (state_32707[(2)]);
var inst_32428 = fluree.db.util.async.throw_err(inst_32427);
var state_32707__$1 = state_32707;
var statearr_32871_33044 = state_32707__$1;
(statearr_32871_33044[(2)] = inst_32428);

(statearr_32871_33044[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (126))){
var inst_32683 = (state_32707[(2)]);
var inst_32684 = fluree.db.util.async.throw_err(inst_32683);
var state_32707__$1 = state_32707;
var statearr_32872_33045 = state_32707__$1;
(statearr_32872_33045[(2)] = inst_32684);

(statearr_32872_33045[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (98))){
var inst_32532 = (state_32707[(40)]);
var inst_32570 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_32532);
var state_32707__$1 = state_32707;
if(inst_32570){
var statearr_32873_33046 = state_32707__$1;
(statearr_32873_33046[(1)] = (101));

} else {
var statearr_32874_33047 = state_32707__$1;
(statearr_32874_33047[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (124))){
var state_32707__$1 = state_32707;
var statearr_32875_33048 = state_32707__$1;
(statearr_32875_33048[(2)] = null);

(statearr_32875_33048[(1)] = (125));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (87))){
var inst_32541 = (state_32707[(44)]);
var state_32707__$1 = state_32707;
var statearr_32876_33049 = state_32707__$1;
(statearr_32876_33049[(2)] = inst_32541);

(statearr_32876_33049[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (30))){
var state_32707__$1 = state_32707;
var statearr_32877_33050 = state_32707__$1;
(statearr_32877_33050[(2)] = null);

(statearr_32877_33050[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (73))){
var inst_32479 = (state_32707[(8)]);
var inst_32497 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_32479);
var state_32707__$1 = state_32707;
var statearr_32878_33051 = state_32707__$1;
(statearr_32878_33051[(2)] = inst_32497);

(statearr_32878_33051[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (96))){
var inst_32561 = (state_32707[(62)]);
var state_32707__$1 = state_32707;
var statearr_32879_33052 = state_32707__$1;
(statearr_32879_33052[(2)] = inst_32561);

(statearr_32879_33052[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (10))){
var state_32707__$1 = state_32707;
var statearr_32880_33053 = state_32707__$1;
(statearr_32880_33053[(2)] = false);

(statearr_32880_33053[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (18))){
var inst_32374 = (state_32707[(2)]);
var inst_32375 = fluree.db.util.async.throw_err(inst_32374);
var state_32707__$1 = state_32707;
var statearr_32881_33054 = state_32707__$1;
(statearr_32881_33054[(2)] = inst_32375);

(statearr_32881_33054[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (105))){
var inst_32331 = (state_32707[(17)]);
var inst_32458 = (state_32707[(18)]);
var inst_32478 = (state_32707[(19)]);
var inst_32524 = (state_32707[(20)]);
var inst_32368 = (state_32707[(21)]);
var inst_32378 = (state_32707[(22)]);
var inst_32518 = (state_32707[(23)]);
var inst_32387 = (state_32707[(24)]);
var inst_32528 = (state_32707[(25)]);
var inst_32422 = (state_32707[(26)]);
var inst_32568 = (state_32707[(7)]);
var inst_32534 = (state_32707[(10)]);
var inst_32514 = (state_32707[(27)]);
var inst_32418 = (state_32707[(28)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32519 = (state_32707[(32)]);
var inst_32467 = (state_32707[(33)]);
var inst_32500 = (state_32707[(34)]);
var inst_32533 = (state_32707[(35)]);
var inst_32343 = (state_32707[(36)]);
var inst_32509 = (state_32707[(37)]);
var inst_32589 = (state_32707[(77)]);
var inst_32477 = (state_32707[(38)]);
var inst_32367 = (state_32707[(39)]);
var inst_32532 = (state_32707[(40)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32419 = (state_32707[(43)]);
var inst_32541 = (state_32707[(44)]);
var inst_32501 = (state_32707[(45)]);
var inst_32535 = (state_32707[(46)]);
var inst_32508 = (state_32707[(47)]);
var inst_32366 = (state_32707[(48)]);
var inst_32507 = (state_32707[(12)]);
var inst_32531 = (state_32707[(49)]);
var inst_32338 = (state_32707[(50)]);
var inst_32476 = (state_32707[(51)]);
var inst_32567 = (state_32707[(64)]);
var inst_32342 = (state_32707[(52)]);
var inst_32513 = (state_32707[(53)]);
var inst_32590 = (state_32707[(82)]);
var inst_32588 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_32567;
var t = inst_32514;
var max_limit_QMARK_ = inst_32508;
var next_node = inst_32531;
var fast_forward_db_QMARK_ = inst_32519;
var s1 = inst_32378;
var o2 = inst_32440;
var t1 = inst_32335;
var predicate_fn = inst_32368;
var i = inst_32533;
var rhs = inst_32568;
var m1 = inst_32467;
var root_node = inst_32524;
var s2 = inst_32387;
var vec__32327 = inst_32419;
var p2 = inst_32458;
var vec__32324 = inst_32418;
var permissions = inst_32509;
var vec__32320 = inst_32338;
var limit = inst_32507;
var vec__32317 = inst_32331;
var start_flake = inst_32477;
var flake_limit = inst_32501;
var offset = inst_32532;
var acc = inst_32535;
var t2 = inst_32342;
var op1 = inst_32336;
var o1 = inst_32431;
var end_flake = inst_32478;
var base_result = inst_32541;
var s = inst_32534;
var node_start = inst_32528;
var p1 = inst_32449;
var subject_fn = inst_32367;
var map__32323 = inst_32366;
var object_fn = inst_32422;
var idx_compare = inst_32513;
var map__32330 = inst_32500;
var op2 = inst_32343;
var m2 = inst_32476;
var novelty = inst_32518;
return (function (p1__32302_SHARP_){
return p1__32302_SHARP_.s;
});
})();
var inst_32589__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32588,inst_32567);
var inst_32590__$1 = cljs.core.count(inst_32589__$1);
var inst_32591 = (inst_32532 > inst_32590__$1);
var state_32707__$1 = (function (){var statearr_32882 = state_32707;
(statearr_32882[(77)] = inst_32589__$1);

(statearr_32882[(82)] = inst_32590__$1);

return statearr_32882;
})();
if(cljs.core.truth_(inst_32591)){
var statearr_32883_33055 = state_32707__$1;
(statearr_32883_33055[(1)] = (107));

} else {
var statearr_32884_33056 = state_32707__$1;
(statearr_32884_33056[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (52))){
var state_32707__$1 = state_32707;
var statearr_32885_33057 = state_32707__$1;
(statearr_32885_33057[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_32885_33057[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (114))){
var inst_32610 = (state_32707[(13)]);
var inst_32619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32620 = [inst_32610,inst_32610];
var inst_32621 = (new cljs.core.PersistentVector(null,2,(5),inst_32619,inst_32620,null));
var state_32707__$1 = state_32707;
var statearr_32886_33058 = state_32707__$1;
(statearr_32886_33058[(2)] = inst_32621);

(statearr_32886_33058[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (67))){
var inst_32479 = (state_32707[(8)]);
var inst_32484 = inst_32479.cljs$lang$protocol_mask$partition0$;
var inst_32485 = (inst_32484 & (64));
var inst_32486 = inst_32479.cljs$core$ISeq$;
var inst_32487 = (cljs.core.PROTOCOL_SENTINEL === inst_32486);
var inst_32488 = ((inst_32485) || (inst_32487));
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32488)){
var statearr_32887_33059 = state_32707__$1;
(statearr_32887_33059[(1)] = (70));

} else {
var statearr_32888_33060 = state_32707__$1;
(statearr_32888_33060[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (71))){
var state_32707__$1 = state_32707;
var statearr_32889_33061 = state_32707__$1;
(statearr_32889_33061[(2)] = false);

(statearr_32889_33061[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (42))){
var inst_32436 = (state_32707[(2)]);
var inst_32437 = fluree.db.util.async.throw_err(inst_32436);
var state_32707__$1 = state_32707;
var statearr_32890_33062 = state_32707__$1;
(statearr_32890_33062[(2)] = inst_32437);

(statearr_32890_33062[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (80))){
var inst_32528 = (state_32707[(25)]);
var inst_32527 = (state_32707[(2)]);
var inst_32528__$1 = fluree.db.util.async.throw_err(inst_32527);
var state_32707__$1 = (function (){var statearr_32891 = state_32707;
(statearr_32891[(25)] = inst_32528__$1);

return statearr_32891;
})();
if(cljs.core.truth_(inst_32528__$1)){
var statearr_32892_33063 = state_32707__$1;
(statearr_32892_33063[(1)] = (81));

} else {
var statearr_32893_33064 = state_32707__$1;
(statearr_32893_33064[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (37))){
var inst_32421 = (state_32707[(57)]);
var inst_32431 = (state_32707[(2)]);
var inst_32432 = fluree.db.util.core.pred_ident_QMARK_(inst_32421);
var state_32707__$1 = (function (){var statearr_32894 = state_32707;
(statearr_32894[(42)] = inst_32431);

return statearr_32894;
})();
if(inst_32432){
var statearr_32895_33065 = state_32707__$1;
(statearr_32895_33065[(1)] = (39));

} else {
var statearr_32896_33066 = state_32707__$1;
(statearr_32896_33066[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (63))){
var inst_32458 = (state_32707[(18)]);
var inst_32378 = (state_32707[(22)]);
var inst_32387 = (state_32707[(24)]);
var inst_32479 = (state_32707[(8)]);
var inst_32449 = (state_32707[(29)]);
var inst_32335 = (state_32707[(30)]);
var inst_32440 = (state_32707[(31)]);
var inst_32467 = (state_32707[(33)]);
var inst_32343 = (state_32707[(36)]);
var inst_32336 = (state_32707[(41)]);
var inst_32431 = (state_32707[(42)]);
var inst_32476 = (state_32707[(51)]);
var inst_32342 = (state_32707[(52)]);
var inst_32476__$1 = (state_32707[(2)]);
var inst_32477 = fluree.db.flake.__GT_Flake(inst_32378,inst_32449,inst_32431,inst_32335,inst_32336,inst_32467);
var inst_32478 = fluree.db.flake.__GT_Flake(inst_32387,inst_32458,inst_32440,inst_32342,inst_32343,inst_32476__$1);
var inst_32479__$1 = opts;
var inst_32481 = (inst_32479__$1 == null);
var inst_32482 = cljs.core.not(inst_32481);
var state_32707__$1 = (function (){var statearr_32897 = state_32707;
(statearr_32897[(19)] = inst_32478);

(statearr_32897[(8)] = inst_32479__$1);

(statearr_32897[(38)] = inst_32477);

(statearr_32897[(51)] = inst_32476__$1);

return statearr_32897;
})();
if(inst_32482){
var statearr_32898_33067 = state_32707__$1;
(statearr_32898_33067[(1)] = (67));

} else {
var statearr_32899_33068 = state_32707__$1;
(statearr_32899_33068[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (94))){
var inst_32422 = (state_32707[(26)]);
var inst_32561 = (state_32707[(2)]);
var state_32707__$1 = (function (){var statearr_32900 = state_32707;
(statearr_32900[(62)] = inst_32561);

return statearr_32900;
})();
if(cljs.core.truth_(inst_32422)){
var statearr_32901_33069 = state_32707__$1;
(statearr_32901_33069[(1)] = (95));

} else {
var statearr_32902_33070 = state_32707__$1;
(statearr_32902_33070[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (8))){
var inst_32361 = (state_32707[(2)]);
var state_32707__$1 = state_32707;
if(cljs.core.truth_(inst_32361)){
var statearr_32903_33071 = state_32707__$1;
(statearr_32903_33071[(1)] = (12));

} else {
var statearr_32904_33072 = state_32707__$1;
(statearr_32904_33072[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (49))){
var inst_32440 = (state_32707[(31)]);
var state_32707__$1 = state_32707;
var statearr_32905_33073 = state_32707__$1;
(statearr_32905_33073[(2)] = inst_32440);

(statearr_32905_33073[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32708 === (84))){
var inst_32478 = (state_32707[(19)]);
var inst_32477 = (state_32707[(38)]);
var inst_32531 = (state_32707[(49)]);
var inst_32540 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_32531);
var inst_32541 = fluree.db.flake.subrange(inst_32540,start_test,inst_32477,end_test,inst_32478);
var inst_32543 = fluree.db.query.range.value_with_nil_pred(idx,inst_32477,inst_32478);
var state_32707__$1 = (function (){var statearr_32906 = state_32707;
(statearr_32906[(44)] = inst_32541);

return statearr_32906;
})();
if(inst_32543){
var statearr_32907_33074 = state_32707__$1;
(statearr_32907_33074[(1)] = (86));

} else {
var statearr_32908_33075 = state_32707__$1;
(statearr_32908_33075[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16291__auto__ = null;
var fluree$db$query$range$state_machine__16291__auto____0 = (function (){
var statearr_32909 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32909[(0)] = fluree$db$query$range$state_machine__16291__auto__);

(statearr_32909[(1)] = (1));

return statearr_32909;
});
var fluree$db$query$range$state_machine__16291__auto____1 = (function (state_32707){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_32707);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e32910){var ex__16294__auto__ = e32910;
var statearr_32911_33076 = state_32707;
(statearr_32911_33076[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_32707[(4)]))){
var statearr_32912_33077 = state_32707;
(statearr_32912_33077[(1)] = cljs.core.first((state_32707[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__33078 = state_32707;
state_32707 = G__33078;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16291__auto__ = function(state_32707){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16291__auto____1.call(this,state_32707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16291__auto____0;
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16291__auto____1;
return fluree$db$query$range$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_32913 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_32913[(6)] = c__16328__auto__);

return statearr_32913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_33134){
var state_val_33135 = (state_33134[(1)]);
if((state_val_33135 === (7))){
var inst_33108 = (state_33134[(7)]);
var inst_33098 = (state_33134[(8)]);
var inst_33106 = fluree.db.flake.Flake__GT_parts(inst_33098);
var inst_33107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(0),null);
var inst_33108__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(1),null);
var inst_33109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(2),null);
var inst_33110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(3),null);
var inst_33111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(4),null);
var inst_33112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33106,(5),null);
var inst_33113 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_33109,inst_33108__$1);
var state_33134__$1 = (function (){var statearr_33136 = state_33134;
(statearr_33136[(9)] = inst_33112);

(statearr_33136[(10)] = inst_33111);

(statearr_33136[(11)] = inst_33107);

(statearr_33136[(7)] = inst_33108__$1);

(statearr_33136[(12)] = inst_33110);

return statearr_33136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33134__$1,(10),inst_33113);
} else {
if((state_val_33135 === (1))){
var inst_33086 = flakes;
var inst_33087 = cljs.core.seq(inst_33086);
var inst_33088 = cljs.core.first(inst_33087);
var inst_33089 = cljs.core.next(inst_33087);
var inst_33090 = cljs.core.PersistentVector.EMPTY;
var inst_33091 = inst_33086;
var inst_33092 = inst_33090;
var state_33134__$1 = (function (){var statearr_33137 = state_33134;
(statearr_33137[(13)] = inst_33089);

(statearr_33137[(14)] = inst_33088);

(statearr_33137[(15)] = inst_33091);

(statearr_33137[(16)] = inst_33092);

return statearr_33137;
})();
var statearr_33138_33156 = state_33134__$1;
(statearr_33138_33156[(2)] = null);

(statearr_33138_33156[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (4))){
var inst_33098 = (state_33134[(8)]);
var inst_33101 = fluree.db.query.range.is_tag_flake_QMARK_(inst_33098);
var state_33134__$1 = state_33134;
if(inst_33101){
var statearr_33139_33157 = state_33134__$1;
(statearr_33139_33157[(1)] = (7));

} else {
var statearr_33140_33158 = state_33134__$1;
(statearr_33140_33158[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (6))){
var inst_33130 = (state_33134[(2)]);
var state_33134__$1 = state_33134;
var statearr_33141_33159 = state_33134__$1;
(statearr_33141_33159[(2)] = inst_33130);

(statearr_33141_33159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (3))){
var inst_33132 = (state_33134[(2)]);
var state_33134__$1 = state_33134;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33134__$1,inst_33132);
} else {
if((state_val_33135 === (2))){
var inst_33091 = (state_33134[(15)]);
var inst_33098 = (state_33134[(8)]);
var inst_33097 = cljs.core.seq(inst_33091);
var inst_33098__$1 = cljs.core.first(inst_33097);
var inst_33099 = cljs.core.next(inst_33097);
var state_33134__$1 = (function (){var statearr_33142 = state_33134;
(statearr_33142[(17)] = inst_33099);

(statearr_33142[(8)] = inst_33098__$1);

return statearr_33142;
})();
if(cljs.core.truth_(inst_33098__$1)){
var statearr_33143_33160 = state_33134__$1;
(statearr_33143_33160[(1)] = (4));

} else {
var statearr_33144_33161 = state_33134__$1;
(statearr_33144_33161[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (9))){
var inst_33127 = (state_33134[(2)]);
var state_33134__$1 = state_33134;
var statearr_33145_33162 = state_33134__$1;
(statearr_33145_33162[(2)] = inst_33127);

(statearr_33145_33162[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (5))){
var inst_33092 = (state_33134[(16)]);
var state_33134__$1 = state_33134;
var statearr_33146_33163 = state_33134__$1;
(statearr_33146_33163[(2)] = inst_33092);

(statearr_33146_33163[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (10))){
var inst_33112 = (state_33134[(9)]);
var inst_33111 = (state_33134[(10)]);
var inst_33099 = (state_33134[(17)]);
var inst_33107 = (state_33134[(11)]);
var inst_33108 = (state_33134[(7)]);
var inst_33092 = (state_33134[(16)]);
var inst_33110 = (state_33134[(12)]);
var inst_33115 = (state_33134[(2)]);
var inst_33116 = fluree.db.util.async.throw_err(inst_33115);
var inst_33117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33118 = [inst_33107,inst_33108,inst_33116,inst_33110,inst_33111,inst_33112];
var inst_33119 = (new cljs.core.PersistentVector(null,6,(5),inst_33117,inst_33118,null));
var inst_33120 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_33119);
var inst_33121 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33092,inst_33120);
var inst_33091 = inst_33099;
var inst_33092__$1 = inst_33121;
var state_33134__$1 = (function (){var statearr_33147 = state_33134;
(statearr_33147[(15)] = inst_33091);

(statearr_33147[(16)] = inst_33092__$1);

return statearr_33147;
})();
var statearr_33148_33164 = state_33134__$1;
(statearr_33148_33164[(2)] = null);

(statearr_33148_33164[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33135 === (8))){
var inst_33099 = (state_33134[(17)]);
var inst_33098 = (state_33134[(8)]);
var inst_33092 = (state_33134[(16)]);
var inst_33124 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33092,inst_33098);
var inst_33091 = inst_33099;
var inst_33092__$1 = inst_33124;
var state_33134__$1 = (function (){var statearr_33149 = state_33134;
(statearr_33149[(15)] = inst_33091);

(statearr_33149[(16)] = inst_33092__$1);

return statearr_33149;
})();
var statearr_33150_33165 = state_33134__$1;
(statearr_33150_33165[(2)] = null);

(statearr_33150_33165[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____0 = (function (){
var statearr_33151 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33151[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__);

(statearr_33151[(1)] = (1));

return statearr_33151;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____1 = (function (state_33134){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_33134);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e33152){var ex__16294__auto__ = e33152;
var statearr_33153_33166 = state_33134;
(statearr_33153_33166[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_33134[(4)]))){
var statearr_33154_33167 = state_33134;
(statearr_33154_33167[(1)] = cljs.core.first((state_33134[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__33168 = state_33134;
state_33134 = G__33168;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__ = function(state_33134){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____1.call(this,state_33134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_33155 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_33155[(6)] = c__16328__auto__);

return statearr_33155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__33170 = arguments.length;
switch (G__33170) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_33321){
var state_val_33322 = (state_33321[(1)]);
if((state_val_33322 === (62))){
var inst_33308 = (state_33321[(7)]);
var state_33321__$1 = state_33321;
var statearr_33323_33412 = state_33321__$1;
(statearr_33323_33412[(2)] = inst_33308);

(statearr_33323_33412[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (7))){
var state_33321__$1 = state_33321;
var statearr_33324_33413 = state_33321__$1;
(statearr_33324_33413[(2)] = false);

(statearr_33324_33413[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (59))){
var inst_33300 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33325_33414 = state_33321__$1;
(statearr_33325_33414[(2)] = inst_33300);

(statearr_33325_33414[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (20))){
var state_33321__$1 = state_33321;
var statearr_33326_33415 = state_33321__$1;
(statearr_33326_33415[(2)] = null);

(statearr_33326_33415[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (58))){
var state_33321__$1 = state_33321;
var statearr_33327_33416 = state_33321__$1;
(statearr_33327_33416[(2)] = null);

(statearr_33327_33416[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (60))){
var inst_33296 = (state_33321[(2)]);
var inst_33297 = fluree.db.util.async.throw_err(inst_33296);
var state_33321__$1 = state_33321;
var statearr_33328_33417 = state_33321__$1;
(statearr_33328_33417[(2)] = inst_33297);

(statearr_33328_33417[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (27))){
var inst_33221 = (state_33321[(8)]);
var inst_33232 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_33221);
var state_33321__$1 = state_33321;
if(inst_33232){
var statearr_33329_33418 = state_33321__$1;
(statearr_33329_33418[(1)] = (30));

} else {
var statearr_33330_33419 = state_33321__$1;
(statearr_33330_33419[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (1))){
var state_33321__$1 = state_33321;
var statearr_33331_33420 = state_33321__$1;
(statearr_33331_33420[(2)] = null);

(statearr_33331_33420[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (24))){
var inst_33182 = (state_33321[(9)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33182)){
var statearr_33332_33421 = state_33321__$1;
(statearr_33332_33421[(1)] = (27));

} else {
var statearr_33333_33422 = state_33321__$1;
(statearr_33333_33422[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (55))){
var inst_33302 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33334_33423 = state_33321__$1;
(statearr_33334_33423[(2)] = inst_33302);

(statearr_33334_33423[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (39))){
var inst_33252 = (state_33321[(2)]);
var inst_33253 = fluree.db.util.async.throw_err(inst_33252);
var state_33321__$1 = state_33321;
var statearr_33335_33424 = state_33321__$1;
(statearr_33335_33424[(2)] = inst_33253);

(statearr_33335_33424[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (46))){
var inst_33265 = (state_33321[(10)]);
var inst_33265__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_33321__$1 = (function (){var statearr_33336 = state_33321;
(statearr_33336[(10)] = inst_33265__$1);

return statearr_33336;
})();
if(cljs.core.truth_(inst_33265__$1)){
var statearr_33337_33425 = state_33321__$1;
(statearr_33337_33425[(1)] = (49));

} else {
var statearr_33338_33426 = state_33321__$1;
(statearr_33338_33426[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (4))){
var inst_33171 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33339_33427 = state_33321__$1;
(statearr_33339_33427[(2)] = inst_33171);

(statearr_33339_33427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (54))){
var inst_33221 = (state_33321[(8)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33221)){
var statearr_33340_33428 = state_33321__$1;
(statearr_33340_33428[(1)] = (57));

} else {
var statearr_33341_33429 = state_33321__$1;
(statearr_33341_33429[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (15))){
var inst_33183 = (state_33321[(11)]);
var inst_33202 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_33183);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(18),inst_33202);
} else {
if((state_val_33322 === (48))){
var inst_33304 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33342_33430 = state_33321__$1;
(statearr_33342_33430[(2)] = inst_33304);

(statearr_33342_33430[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (50))){
var inst_33196 = (state_33321[(12)]);
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33191 = (state_33321[(14)]);
var inst_33265 = (state_33321[(10)]);
var inst_33184 = (state_33321[(15)]);
var inst_33180 = (state_33321[(16)]);
var inst_33185 = (state_33321[(17)]);
var inst_33269 = (function (){var t = inst_33184;
var temp__5733__auto__ = inst_33265;
var p = inst_33182;
var idx_predicate_QMARK_ = inst_33185;
var vec__33177 = inst_33180;
var o = inst_33221;
var tag_predicate_QMARK_ = inst_33191;
var s = inst_33181;
var o_coerce_QMARK_ = inst_33196;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_33321__$1 = state_33321;
var statearr_33343_33431 = state_33321__$1;
(statearr_33343_33431[(2)] = inst_33269);

(statearr_33343_33431[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (21))){
var inst_33217 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33344_33432 = state_33321__$1;
(statearr_33344_33432[(2)] = inst_33217);

(statearr_33344_33432[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (31))){
var state_33321__$1 = state_33321;
var statearr_33345_33433 = state_33321__$1;
(statearr_33345_33433[(2)] = false);

(statearr_33345_33433[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (32))){
var inst_33242 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33346_33434 = state_33321__$1;
(statearr_33346_33434[(2)] = inst_33242);

(statearr_33346_33434[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (40))){
var inst_33185 = (state_33321[(17)]);
var inst_33256 = cljs.core.not(inst_33185);
var state_33321__$1 = state_33321;
if(inst_33256){
var statearr_33347_33435 = state_33321__$1;
(statearr_33347_33435[(1)] = (43));

} else {
var statearr_33348_33436 = state_33321__$1;
(statearr_33348_33436[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (56))){
var inst_33287 = (state_33321[(2)]);
var inst_33288 = fluree.db.util.async.throw_err(inst_33287);
var state_33321__$1 = state_33321;
var statearr_33349_33437 = state_33321__$1;
(statearr_33349_33437[(2)] = inst_33288);

(statearr_33349_33437[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (33))){
var inst_33221 = (state_33321[(8)]);
var inst_33235 = cljs.core.fn_QMARK_(inst_33221);
var inst_33236 = (!(inst_33235));
var state_33321__$1 = state_33321;
var statearr_33350_33438 = state_33321__$1;
(statearr_33350_33438[(2)] = inst_33236);

(statearr_33350_33438[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (13))){
var inst_33183 = (state_33321[(11)]);
var inst_33200 = fluree.db.query.range.tag_string_QMARK_(inst_33183);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33200)){
var statearr_33351_33439 = state_33321__$1;
(statearr_33351_33439[(1)] = (15));

} else {
var statearr_33352_33440 = state_33321__$1;
(statearr_33352_33440[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (22))){
var inst_33213 = (state_33321[(2)]);
var inst_33214 = fluree.db.util.async.throw_err(inst_33213);
var state_33321__$1 = state_33321;
var statearr_33353_33441 = state_33321__$1;
(statearr_33353_33441[(2)] = inst_33214);

(statearr_33353_33441[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (36))){
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33184 = (state_33321[(15)]);
var inst_33247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33248 = [inst_33182,inst_33221,inst_33181,inst_33184];
var inst_33249 = (new cljs.core.PersistentVector(null,4,(5),inst_33247,inst_33248,null));
var inst_33250 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_33249,opts);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(39),inst_33250);
} else {
if((state_val_33322 === (41))){
var inst_33182 = (state_33321[(9)]);
var state_33321__$1 = state_33321;
var statearr_33354_33442 = state_33321__$1;
(statearr_33354_33442[(2)] = inst_33182);

(statearr_33354_33442[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (43))){
var inst_33221 = (state_33321[(8)]);
var state_33321__$1 = state_33321;
var statearr_33355_33443 = state_33321__$1;
(statearr_33355_33443[(2)] = inst_33221);

(statearr_33355_33443[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (61))){
var inst_33308 = (state_33321[(7)]);
var inst_33310 = fluree.db.query.range.coerce_tag_flakes(db,inst_33308);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(64),inst_33310);
} else {
if((state_val_33322 === (29))){
var inst_33245 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33245)){
var statearr_33356_33444 = state_33321__$1;
(statearr_33356_33444[(1)] = (36));

} else {
var statearr_33357_33445 = state_33321__$1;
(statearr_33357_33445[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (44))){
var state_33321__$1 = state_33321;
var statearr_33358_33446 = state_33321__$1;
(statearr_33358_33446[(2)] = false);

(statearr_33358_33446[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (6))){
var inst_33182 = (state_33321[(9)]);
var inst_33187 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_33182);
var inst_33188 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_33187);
var state_33321__$1 = state_33321;
var statearr_33359_33447 = state_33321__$1;
(statearr_33359_33447[(2)] = inst_33188);

(statearr_33359_33447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (28))){
var inst_33182 = (state_33321[(9)]);
var state_33321__$1 = state_33321;
var statearr_33360_33448 = state_33321__$1;
(statearr_33360_33448[(2)] = inst_33182);

(statearr_33360_33448[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (64))){
var inst_33312 = (state_33321[(2)]);
var inst_33313 = fluree.db.util.async.throw_err(inst_33312);
var state_33321__$1 = state_33321;
var statearr_33361_33449 = state_33321__$1;
(statearr_33361_33449[(2)] = inst_33313);

(statearr_33361_33449[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (51))){
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33184 = (state_33321[(15)]);
var inst_33271 = (state_33321[(2)]);
var inst_33272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33273 = [inst_33182,inst_33181,null,inst_33184];
var inst_33274 = (new cljs.core.PersistentVector(null,4,(5),inst_33272,inst_33273,null));
var inst_33275 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_33271);
var inst_33276 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_33274,inst_33275);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(52),inst_33276);
} else {
if((state_val_33322 === (25))){
var inst_33191 = (state_33321[(14)]);
var inst_33308 = (state_33321[(2)]);
var state_33321__$1 = (function (){var statearr_33362 = state_33321;
(statearr_33362[(7)] = inst_33308);

return statearr_33362;
})();
if(cljs.core.truth_(inst_33191)){
var statearr_33363_33450 = state_33321__$1;
(statearr_33363_33450[(1)] = (61));

} else {
var statearr_33364_33451 = state_33321__$1;
(statearr_33364_33451[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (34))){
var inst_33185 = (state_33321[(17)]);
var state_33321__$1 = state_33321;
var statearr_33365_33452 = state_33321__$1;
(statearr_33365_33452[(2)] = inst_33185);

(statearr_33365_33452[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (17))){
var inst_33219 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33366_33453 = state_33321__$1;
(statearr_33366_33453[(2)] = inst_33219);

(statearr_33366_33453[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (3))){
var inst_33319 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33321__$1,inst_33319);
} else {
if((state_val_33322 === (12))){
var inst_33183 = (state_33321[(11)]);
var state_33321__$1 = state_33321;
var statearr_33367_33454 = state_33321__$1;
(statearr_33367_33454[(2)] = inst_33183);

(statearr_33367_33454[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (2))){
var inst_33182 = (state_33321[(9)]);
var inst_33180 = (state_33321[(16)]);
var _ = (function (){var statearr_33368 = state_33321;
(statearr_33368[(4)] = cljs.core.cons((5),(state_33321[(4)])));

return statearr_33368;
})();
var inst_33180__$1 = fparts;
var inst_33181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33180__$1,(0),null);
var inst_33182__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33180__$1,(1),null);
var inst_33183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33180__$1,(2),null);
var inst_33184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33180__$1,(3),null);
var inst_33185 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_33182__$1);
var state_33321__$1 = (function (){var statearr_33369 = state_33321;
(statearr_33369[(11)] = inst_33183);

(statearr_33369[(9)] = inst_33182__$1);

(statearr_33369[(13)] = inst_33181);

(statearr_33369[(15)] = inst_33184);

(statearr_33369[(16)] = inst_33180__$1);

(statearr_33369[(17)] = inst_33185);

return statearr_33369;
})();
if(cljs.core.truth_(inst_33182__$1)){
var statearr_33370_33455 = state_33321__$1;
(statearr_33370_33455[(1)] = (6));

} else {
var statearr_33371_33456 = state_33321__$1;
(statearr_33371_33456[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (23))){
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33184 = (state_33321[(15)]);
var inst_33223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33224 = [inst_33181,inst_33182,inst_33221,inst_33184];
var inst_33225 = (new cljs.core.PersistentVector(null,4,(5),inst_33223,inst_33224,null));
var inst_33226 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33225,opts);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(26),inst_33226);
} else {
if((state_val_33322 === (47))){
var inst_33182 = (state_33321[(9)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33182)){
var statearr_33372_33457 = state_33321__$1;
(statearr_33372_33457[(1)] = (53));

} else {
var statearr_33373_33458 = state_33321__$1;
(statearr_33373_33458[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (35))){
var inst_33239 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33374_33459 = state_33321__$1;
(statearr_33374_33459[(2)] = inst_33239);

(statearr_33374_33459[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (19))){
var inst_33183 = (state_33321[(11)]);
var inst_33182 = (state_33321[(9)]);
var inst_33209 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_33182);
var inst_33210 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33209),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33183)].join('');
var inst_33211 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_33210);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(22),inst_33211);
} else {
if((state_val_33322 === (57))){
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33184 = (state_33321[(15)]);
var inst_33291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33292 = [inst_33221,inst_33182,inst_33181,inst_33184];
var inst_33293 = (new cljs.core.PersistentVector(null,4,(5),inst_33291,inst_33292,null));
var inst_33294 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_33293,opts);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(60),inst_33294);
} else {
if((state_val_33322 === (11))){
var inst_33196 = (state_33321[(12)]);
var inst_33196__$1 = (state_33321[(2)]);
var inst_33197 = cljs.core.not(inst_33196__$1);
var state_33321__$1 = (function (){var statearr_33376 = state_33321;
(statearr_33376[(12)] = inst_33196__$1);

return statearr_33376;
})();
if(inst_33197){
var statearr_33377_33460 = state_33321__$1;
(statearr_33377_33460[(1)] = (12));

} else {
var statearr_33378_33461 = state_33321__$1;
(statearr_33378_33461[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (9))){
var inst_33183 = (state_33321[(11)]);
var inst_33193 = typeof inst_33183 === 'string';
var state_33321__$1 = state_33321;
var statearr_33379_33462 = state_33321__$1;
(statearr_33379_33462[(2)] = inst_33193);

(statearr_33379_33462[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (5))){
var _ = (function (){var statearr_33380 = state_33321;
(statearr_33380[(4)] = cljs.core.rest((state_33321[(4)])));

return statearr_33380;
})();
var state_33321__$1 = state_33321;
var ex33375 = (state_33321__$1[(2)]);
var statearr_33381_33463 = state_33321__$1;
(statearr_33381_33463[(5)] = ex33375);


if((ex33375 instanceof Error)){
var statearr_33382_33464 = state_33321__$1;
(statearr_33382_33464[(1)] = (4));

(statearr_33382_33464[(5)] = null);

} else {
throw ex33375;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (14))){
var inst_33181 = (state_33321[(13)]);
var inst_33221 = (state_33321[(2)]);
var state_33321__$1 = (function (){var statearr_33383 = state_33321;
(statearr_33383[(8)] = inst_33221);

return statearr_33383;
})();
if(cljs.core.truth_(inst_33181)){
var statearr_33384_33465 = state_33321__$1;
(statearr_33384_33465[(1)] = (23));

} else {
var statearr_33385_33466 = state_33321__$1;
(statearr_33385_33466[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (45))){
var inst_33260 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33386_33467 = state_33321__$1;
(statearr_33386_33467[(2)] = inst_33260);

(statearr_33386_33467[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (53))){
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33184 = (state_33321[(15)]);
var inst_33282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33283 = [inst_33182,inst_33181,inst_33221,inst_33184];
var inst_33284 = (new cljs.core.PersistentVector(null,4,(5),inst_33282,inst_33283,null));
var inst_33285 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_33284,opts);
var state_33321__$1 = state_33321;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33321__$1,(56),inst_33285);
} else {
if((state_val_33322 === (26))){
var inst_33228 = (state_33321[(2)]);
var inst_33229 = fluree.db.util.async.throw_err(inst_33228);
var state_33321__$1 = state_33321;
var statearr_33387_33468 = state_33321__$1;
(statearr_33387_33468[(2)] = inst_33229);

(statearr_33387_33468[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (16))){
var inst_33183 = (state_33321[(11)]);
var inst_33207 = typeof inst_33183 === 'string';
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33207)){
var statearr_33388_33469 = state_33321__$1;
(statearr_33388_33469[(1)] = (19));

} else {
var statearr_33389_33470 = state_33321__$1;
(statearr_33389_33470[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (38))){
var inst_33306 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
var statearr_33390_33471 = state_33321__$1;
(statearr_33390_33471[(2)] = inst_33306);

(statearr_33390_33471[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (30))){
var inst_33185 = (state_33321[(17)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33185)){
var statearr_33391_33472 = state_33321__$1;
(statearr_33391_33472[(1)] = (33));

} else {
var statearr_33392_33473 = state_33321__$1;
(statearr_33392_33473[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (10))){
var inst_33191 = (state_33321[(14)]);
var state_33321__$1 = state_33321;
var statearr_33393_33474 = state_33321__$1;
(statearr_33393_33474[(2)] = inst_33191);

(statearr_33393_33474[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (18))){
var inst_33204 = (state_33321[(2)]);
var inst_33205 = fluree.db.util.async.throw_err(inst_33204);
var state_33321__$1 = state_33321;
var statearr_33394_33475 = state_33321__$1;
(statearr_33394_33475[(2)] = inst_33205);

(statearr_33394_33475[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (52))){
var inst_33278 = (state_33321[(2)]);
var inst_33279 = fluree.db.util.async.throw_err(inst_33278);
var state_33321__$1 = state_33321;
var statearr_33395_33476 = state_33321__$1;
(statearr_33395_33476[(2)] = inst_33279);

(statearr_33395_33476[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (42))){
var inst_33263 = (state_33321[(2)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33263)){
var statearr_33396_33477 = state_33321__$1;
(statearr_33396_33477[(1)] = (46));

} else {
var statearr_33397_33478 = state_33321__$1;
(statearr_33397_33478[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (37))){
var inst_33182 = (state_33321[(9)]);
var state_33321__$1 = state_33321;
if(cljs.core.truth_(inst_33182)){
var statearr_33398_33479 = state_33321__$1;
(statearr_33398_33479[(1)] = (40));

} else {
var statearr_33399_33480 = state_33321__$1;
(statearr_33399_33480[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (63))){
var inst_33316 = (state_33321[(2)]);
var _ = (function (){var statearr_33400 = state_33321;
(statearr_33400[(4)] = cljs.core.rest((state_33321[(4)])));

return statearr_33400;
})();
var state_33321__$1 = state_33321;
var statearr_33401_33481 = state_33321__$1;
(statearr_33401_33481[(2)] = inst_33316);

(statearr_33401_33481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (8))){
var inst_33191 = (state_33321[(14)]);
var inst_33191__$1 = (state_33321[(2)]);
var state_33321__$1 = (function (){var statearr_33402 = state_33321;
(statearr_33402[(14)] = inst_33191__$1);

return statearr_33402;
})();
if(cljs.core.truth_(inst_33191__$1)){
var statearr_33403_33482 = state_33321__$1;
(statearr_33403_33482[(1)] = (9));

} else {
var statearr_33404_33483 = state_33321__$1;
(statearr_33404_33483[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33322 === (49))){
var inst_33196 = (state_33321[(12)]);
var inst_33221 = (state_33321[(8)]);
var inst_33182 = (state_33321[(9)]);
var inst_33181 = (state_33321[(13)]);
var inst_33191 = (state_33321[(14)]);
var inst_33265 = (state_33321[(10)]);
var inst_33184 = (state_33321[(15)]);
var inst_33180 = (state_33321[(16)]);
var inst_33185 = (state_33321[(17)]);
var inst_33267 = (function (){var obj_fn = inst_33265;
var t = inst_33184;
var temp__5733__auto__ = inst_33265;
var p = inst_33182;
var idx_predicate_QMARK_ = inst_33185;
var vec__33177 = inst_33180;
var o = inst_33221;
var tag_predicate_QMARK_ = inst_33191;
var s = inst_33181;
var o_coerce_QMARK_ = inst_33196;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_33321__$1 = state_33321;
var statearr_33405_33484 = state_33321__$1;
(statearr_33405_33484[(2)] = inst_33267);

(statearr_33405_33484[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16291__auto__ = null;
var fluree$db$query$range$state_machine__16291__auto____0 = (function (){
var statearr_33406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33406[(0)] = fluree$db$query$range$state_machine__16291__auto__);

(statearr_33406[(1)] = (1));

return statearr_33406;
});
var fluree$db$query$range$state_machine__16291__auto____1 = (function (state_33321){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_33321);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e33407){var ex__16294__auto__ = e33407;
var statearr_33408_33485 = state_33321;
(statearr_33408_33485[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_33321[(4)]))){
var statearr_33409_33486 = state_33321;
(statearr_33409_33486[(1)] = cljs.core.first((state_33321[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__33487 = state_33321;
state_33321 = G__33487;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16291__auto__ = function(state_33321){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16291__auto____1.call(this,state_33321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16291__auto____0;
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16291__auto____1;
return fluree$db$query$range$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_33410 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_33410[(6)] = c__16328__auto__);

return statearr_33410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__33489 = arguments.length;
switch (G__33489) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_33524){
var state_val_33525 = (state_33524[(1)]);
if((state_val_33525 === (7))){
var inst_33511 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_33512 = ["Invalid collection name: ",inst_33511].join('');
var inst_33513 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33514 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_33515 = cljs.core.PersistentHashMap.fromArrays(inst_33513,inst_33514);
var inst_33516 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33512,inst_33515);
var inst_33517 = (function(){throw inst_33516})();
var state_33524__$1 = state_33524;
var statearr_33526_33546 = state_33524__$1;
(statearr_33526_33546[(2)] = inst_33517);

(statearr_33526_33546[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (1))){
var state_33524__$1 = state_33524;
var statearr_33527_33547 = state_33524__$1;
(statearr_33527_33547[(2)] = null);

(statearr_33527_33547[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (4))){
var inst_33490 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
var statearr_33528_33548 = state_33524__$1;
(statearr_33528_33548[(2)] = inst_33490);

(statearr_33528_33548[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (6))){
var inst_33496 = (state_33524[(7)]);
var inst_33498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33499 = fluree.db.flake.max_subject_id(inst_33496);
var inst_33500 = [inst_33499];
var inst_33501 = (new cljs.core.PersistentVector(null,1,(5),inst_33498,inst_33500,null));
var inst_33502 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33503 = fluree.db.flake.min_subject_id(inst_33496);
var inst_33504 = [inst_33503];
var inst_33505 = (new cljs.core.PersistentVector(null,1,(5),inst_33502,inst_33504,null));
var inst_33506 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_33501,cljs.core._LT__EQ_,inst_33505,opts);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33524__$1,(9),inst_33506);
} else {
if((state_val_33525 === (3))){
var inst_33522 = (state_33524[(2)]);
var state_33524__$1 = state_33524;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33524__$1,inst_33522);
} else {
if((state_val_33525 === (2))){
var inst_33496 = (state_33524[(7)]);
var _ = (function (){var statearr_33530 = state_33524;
(statearr_33530[(4)] = cljs.core.cons((5),(state_33524[(4)])));

return statearr_33530;
})();
var inst_33496__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,name);
var state_33524__$1 = (function (){var statearr_33531 = state_33524;
(statearr_33531[(7)] = inst_33496__$1);

return statearr_33531;
})();
if(cljs.core.truth_(inst_33496__$1)){
var statearr_33532_33549 = state_33524__$1;
(statearr_33532_33549[(1)] = (6));

} else {
var statearr_33533_33550 = state_33524__$1;
(statearr_33533_33550[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (9))){
var inst_33508 = (state_33524[(2)]);
var inst_33509 = fluree.db.util.async.throw_err(inst_33508);
var state_33524__$1 = state_33524;
var statearr_33534_33551 = state_33524__$1;
(statearr_33534_33551[(2)] = inst_33509);

(statearr_33534_33551[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (5))){
var _ = (function (){var statearr_33535 = state_33524;
(statearr_33535[(4)] = cljs.core.rest((state_33524[(4)])));

return statearr_33535;
})();
var state_33524__$1 = state_33524;
var ex33529 = (state_33524__$1[(2)]);
var statearr_33536_33552 = state_33524__$1;
(statearr_33536_33552[(5)] = ex33529);


var statearr_33537_33553 = state_33524__$1;
(statearr_33537_33553[(1)] = (4));

(statearr_33537_33553[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33525 === (8))){
var inst_33519 = (state_33524[(2)]);
var _ = (function (){var statearr_33538 = state_33524;
(statearr_33538[(4)] = cljs.core.rest((state_33524[(4)])));

return statearr_33538;
})();
var state_33524__$1 = state_33524;
var statearr_33539_33554 = state_33524__$1;
(statearr_33539_33554[(2)] = inst_33519);

(statearr_33539_33554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16291__auto__ = null;
var fluree$db$query$range$state_machine__16291__auto____0 = (function (){
var statearr_33540 = [null,null,null,null,null,null,null,null];
(statearr_33540[(0)] = fluree$db$query$range$state_machine__16291__auto__);

(statearr_33540[(1)] = (1));

return statearr_33540;
});
var fluree$db$query$range$state_machine__16291__auto____1 = (function (state_33524){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_33524);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e33541){var ex__16294__auto__ = e33541;
var statearr_33542_33555 = state_33524;
(statearr_33542_33555[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_33524[(4)]))){
var statearr_33543_33556 = state_33524;
(statearr_33543_33556[(1)] = cljs.core.first((state_33524[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__33557 = state_33524;
state_33524 = G__33557;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16291__auto__ = function(state_33524){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16291__auto____1.call(this,state_33524);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16291__auto____0;
fluree$db$query$range$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16291__auto____1;
return fluree$db$query$range$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_33544 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_33544[(6)] = c__16328__auto__);

return statearr_33544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__33561 = flakes;
var vec__33562 = G__33561;
var seq__33563 = cljs.core.seq(vec__33562);
var first__33564 = cljs.core.first(seq__33563);
var seq__33563__$1 = cljs.core.next(seq__33563);
var flake_SINGLEQUOTE_ = first__33564;
var r = seq__33563__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__33561__$1 = G__33561;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__33571 = G__33561__$1;
var seq__33572 = cljs.core.seq(vec__33571);
var first__33573 = cljs.core.first(seq__33572);
var seq__33572__$1 = cljs.core.next(seq__33572);
var flake_SINGLEQUOTE___$1 = first__33573;
var r__$1 = seq__33572__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e33575){var e = e33575;
return null;
}})();
var map__33574 = cmd_map;
var map__33574__$1 = (((((!((map__33574 == null))))?(((((map__33574.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33574.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33574):map__33574);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33574__$1,cljs.core.cst$kw$expire);
var G__33577 = r__$1;
var G__33578 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__33561__$1 = G__33577;
result_STAR___$1 = G__33578;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__33587 = blocks;
var vec__33588 = G__33587;
var seq__33589 = cljs.core.seq(vec__33588);
var first__33590 = cljs.core.first(seq__33589);
var seq__33589__$1 = cljs.core.next(seq__33589);
var block_SINGLEQUOTE_ = first__33590;
var r = seq__33589__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__33587__$1 = G__33587;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__33596 = G__33587__$1;
var seq__33597 = cljs.core.seq(vec__33596);
var first__33598 = cljs.core.first(seq__33597);
var seq__33597__$1 = cljs.core.next(seq__33597);
var block_SINGLEQUOTE___$1 = first__33598;
var r__$1 = seq__33597__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__33599 = block_SINGLEQUOTE___$1;
var map__33599__$1 = (((((!((map__33599 == null))))?(((((map__33599.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33599.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33599):map__33599);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33599__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33599__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33599__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33579_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33579_SHARP_.p,(2))){
return p1__33579_SHARP_.o;
} else {
return null;
}
});})(G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33580_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33580_SHARP_.p,(1))){
return p1__33580_SHARP_.o;
} else {
return null;
}
});})(G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33581_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33581_SHARP_.p,(5))){
return p1__33581_SHARP_.o;
} else {
return null;
}
});})(G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,instant,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33582_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33582_SHARP_.p,(7))){
return p1__33582_SHARP_.o;
} else {
return null;
}
});})(G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,instant,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__33583_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__33583_SHARP_.p,(106));
});})(G__33587__$1,result_STAR___$1,map__33599,map__33599__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__33596,seq__33597,first__33598,seq__33597__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__33587,vec__33588,seq__33589,first__33590,seq__33589__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__33601 = r__$1;
var G__33602 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__33587__$1 = G__33601;
result_STAR___$1 = G__33602;
continue;
}
break;
}
});
