// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5631){
var vec__5632 = p__5631;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5632,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5632,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5635 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5635,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5635,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5635,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5635,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5635,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5735__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5638 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5638,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5638,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5638,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5638,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5638,(4),null);
var vec__5641 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5641,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5641,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5641,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5641,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5641,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5644 = segmap;
var map__5644__$1 = (((((!((map__5644 == null))))?(((((map__5644.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5644.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__5644):map__5644);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5644__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5644__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5644__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5644__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5644__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5647 = arguments.length;
switch (G__5647) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5651 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5655 = cljs.core.next(segs__$1);
var G__5656 = nrelseg;
var G__5657 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5655;
relseg__$1 = G__5656;
result__$1 = G__5657;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5651,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5651,(1),null);
var G__5658 = (gline + (1));
var G__5659 = cljs.core.next(lines__$1);
var G__5660 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5661 = result__$1;
gline = G__5658;
lines__$1 = G__5659;
relseg = G__5660;
result = G__5661;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5663 = segmap;
var map__5663__$1 = (((((!((map__5663 == null))))?(((((map__5663.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5663.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__5663):map__5663);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5663__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5663__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5663__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5663__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5663__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5662_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5662_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5666 = arguments.length;
switch (G__5666) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5670 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5674 = cljs.core.next(segs__$1);
var G__5675 = nrelseg;
var G__5676 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5674;
relseg__$1 = G__5675;
result__$1 = G__5676;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(1),null);
var G__5677 = (gline + (1));
var G__5678 = cljs.core.next(lines__$1);
var G__5679 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5680 = result__$1;
gline = G__5677;
lines__$1 = G__5678;
relseg = G__5679;
result = G__5680;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5681){
var vec__5682 = p__5681;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5685){
var vec__5686 = p__5685;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5686,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5686,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5686,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5686,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5686,(4),null);
var seg = vec__5686;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5689){
var vec__5690 = p__5689;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5690,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5690,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5690,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5690,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5690,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5696 = cljs.core.seq(infos);
var chunk__5697 = null;
var count__5698 = (0);
var i__5699 = (0);
while(true){
if((i__5699 < count__5698)){
var info = chunk__5697.cljs$core$IIndexed$_nth$arity$2(null,i__5699);
var segv_6050 = info__GT_segv(info,source_idx,line,col);
var gline_6051 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_6052 = cljs.core.count(cljs.core.deref(lines));
if((gline_6051 > (lc_6052 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5696,chunk__5697,count__5698,i__5699,segv_6050,gline_6051,lc_6052,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6051 - (lc_6052 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6050], null));
});})(seq__5696,chunk__5697,count__5698,i__5699,segv_6050,gline_6051,lc_6052,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5696,chunk__5697,count__5698,i__5699,segv_6050,gline_6051,lc_6052,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6051], null),cljs.core.conj,segv_6050);
});})(seq__5696,chunk__5697,count__5698,i__5699,segv_6050,gline_6051,lc_6052,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6053 = seq__5696;
var G__6054 = chunk__5697;
var G__6055 = count__5698;
var G__6056 = (i__5699 + (1));
seq__5696 = G__6053;
chunk__5697 = G__6054;
count__5698 = G__6055;
i__5699 = G__6056;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__5696);
if(temp__5735__auto__){
var seq__5696__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5696__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__5696__$1);
var G__6057 = cljs.core.chunk_rest(seq__5696__$1);
var G__6058 = c__4556__auto__;
var G__6059 = cljs.core.count(c__4556__auto__);
var G__6060 = (0);
seq__5696 = G__6057;
chunk__5697 = G__6058;
count__5698 = G__6059;
i__5699 = G__6060;
continue;
} else {
var info = cljs.core.first(seq__5696__$1);
var segv_6061 = info__GT_segv(info,source_idx,line,col);
var gline_6062 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_6063 = cljs.core.count(cljs.core.deref(lines));
if((gline_6062 > (lc_6063 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5696,chunk__5697,count__5698,i__5699,segv_6061,gline_6062,lc_6063,info,seq__5696__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6062 - (lc_6063 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6061], null));
});})(seq__5696,chunk__5697,count__5698,i__5699,segv_6061,gline_6062,lc_6063,info,seq__5696__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5696,chunk__5697,count__5698,i__5699,segv_6061,gline_6062,lc_6063,info,seq__5696__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6062], null),cljs.core.conj,segv_6061);
});})(seq__5696,chunk__5697,count__5698,i__5699,segv_6061,gline_6062,lc_6063,info,seq__5696__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6064 = cljs.core.next(seq__5696__$1);
var G__6065 = null;
var G__6066 = (0);
var G__6067 = (0);
seq__5696 = G__6064;
chunk__5697 = G__6065;
count__5698 = G__6066;
i__5699 = G__6067;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5700_6068 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5701_6069 = null;
var count__5702_6070 = (0);
var i__5703_6071 = (0);
while(true){
if((i__5703_6071 < count__5702_6070)){
var vec__5876_6072 = chunk__5701_6069.cljs$core$IIndexed$_nth$arity$2(null,i__5703_6071);
var source_idx_6073 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876_6072,(0),null);
var vec__5879_6074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5876_6072,(1),null);
var __6075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5879_6074,(0),null);
var lines_6076__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5879_6074,(1),null);
var seq__5882_6077 = cljs.core.seq(lines_6076__$1);
var chunk__5883_6078 = null;
var count__5884_6079 = (0);
var i__5885_6080 = (0);
while(true){
if((i__5885_6080 < count__5884_6079)){
var vec__5924_6081 = chunk__5883_6078.cljs$core$IIndexed$_nth$arity$2(null,i__5885_6080);
var line_6082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5924_6081,(0),null);
var cols_6083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5924_6081,(1),null);
var seq__5927_6084 = cljs.core.seq(cols_6083);
var chunk__5928_6085 = null;
var count__5929_6086 = (0);
var i__5930_6087 = (0);
while(true){
if((i__5930_6087 < count__5929_6086)){
var vec__5937_6088 = chunk__5928_6085.cljs$core$IIndexed$_nth$arity$2(null,i__5930_6087);
var col_6089 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5937_6088,(0),null);
var infos_6090 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5937_6088,(1),null);
encode_cols(infos_6090,source_idx_6073,line_6082,col_6089);


var G__6091 = seq__5927_6084;
var G__6092 = chunk__5928_6085;
var G__6093 = count__5929_6086;
var G__6094 = (i__5930_6087 + (1));
seq__5927_6084 = G__6091;
chunk__5928_6085 = G__6092;
count__5929_6086 = G__6093;
i__5930_6087 = G__6094;
continue;
} else {
var temp__5735__auto___6095 = cljs.core.seq(seq__5927_6084);
if(temp__5735__auto___6095){
var seq__5927_6096__$1 = temp__5735__auto___6095;
if(cljs.core.chunked_seq_QMARK_(seq__5927_6096__$1)){
var c__4556__auto___6097 = cljs.core.chunk_first(seq__5927_6096__$1);
var G__6098 = cljs.core.chunk_rest(seq__5927_6096__$1);
var G__6099 = c__4556__auto___6097;
var G__6100 = cljs.core.count(c__4556__auto___6097);
var G__6101 = (0);
seq__5927_6084 = G__6098;
chunk__5928_6085 = G__6099;
count__5929_6086 = G__6100;
i__5930_6087 = G__6101;
continue;
} else {
var vec__5940_6102 = cljs.core.first(seq__5927_6096__$1);
var col_6103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5940_6102,(0),null);
var infos_6104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5940_6102,(1),null);
encode_cols(infos_6104,source_idx_6073,line_6082,col_6103);


var G__6105 = cljs.core.next(seq__5927_6096__$1);
var G__6106 = null;
var G__6107 = (0);
var G__6108 = (0);
seq__5927_6084 = G__6105;
chunk__5928_6085 = G__6106;
count__5929_6086 = G__6107;
i__5930_6087 = G__6108;
continue;
}
} else {
}
}
break;
}


var G__6109 = seq__5882_6077;
var G__6110 = chunk__5883_6078;
var G__6111 = count__5884_6079;
var G__6112 = (i__5885_6080 + (1));
seq__5882_6077 = G__6109;
chunk__5883_6078 = G__6110;
count__5884_6079 = G__6111;
i__5885_6080 = G__6112;
continue;
} else {
var temp__5735__auto___6113 = cljs.core.seq(seq__5882_6077);
if(temp__5735__auto___6113){
var seq__5882_6114__$1 = temp__5735__auto___6113;
if(cljs.core.chunked_seq_QMARK_(seq__5882_6114__$1)){
var c__4556__auto___6115 = cljs.core.chunk_first(seq__5882_6114__$1);
var G__6116 = cljs.core.chunk_rest(seq__5882_6114__$1);
var G__6117 = c__4556__auto___6115;
var G__6118 = cljs.core.count(c__4556__auto___6115);
var G__6119 = (0);
seq__5882_6077 = G__6116;
chunk__5883_6078 = G__6117;
count__5884_6079 = G__6118;
i__5885_6080 = G__6119;
continue;
} else {
var vec__5943_6120 = cljs.core.first(seq__5882_6114__$1);
var line_6121 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5943_6120,(0),null);
var cols_6122 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5943_6120,(1),null);
var seq__5946_6123 = cljs.core.seq(cols_6122);
var chunk__5947_6124 = null;
var count__5948_6125 = (0);
var i__5949_6126 = (0);
while(true){
if((i__5949_6126 < count__5948_6125)){
var vec__5956_6127 = chunk__5947_6124.cljs$core$IIndexed$_nth$arity$2(null,i__5949_6126);
var col_6128 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5956_6127,(0),null);
var infos_6129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5956_6127,(1),null);
encode_cols(infos_6129,source_idx_6073,line_6121,col_6128);


var G__6130 = seq__5946_6123;
var G__6131 = chunk__5947_6124;
var G__6132 = count__5948_6125;
var G__6133 = (i__5949_6126 + (1));
seq__5946_6123 = G__6130;
chunk__5947_6124 = G__6131;
count__5948_6125 = G__6132;
i__5949_6126 = G__6133;
continue;
} else {
var temp__5735__auto___6134__$1 = cljs.core.seq(seq__5946_6123);
if(temp__5735__auto___6134__$1){
var seq__5946_6135__$1 = temp__5735__auto___6134__$1;
if(cljs.core.chunked_seq_QMARK_(seq__5946_6135__$1)){
var c__4556__auto___6136 = cljs.core.chunk_first(seq__5946_6135__$1);
var G__6137 = cljs.core.chunk_rest(seq__5946_6135__$1);
var G__6138 = c__4556__auto___6136;
var G__6139 = cljs.core.count(c__4556__auto___6136);
var G__6140 = (0);
seq__5946_6123 = G__6137;
chunk__5947_6124 = G__6138;
count__5948_6125 = G__6139;
i__5949_6126 = G__6140;
continue;
} else {
var vec__5959_6141 = cljs.core.first(seq__5946_6135__$1);
var col_6142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5959_6141,(0),null);
var infos_6143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5959_6141,(1),null);
encode_cols(infos_6143,source_idx_6073,line_6121,col_6142);


var G__6144 = cljs.core.next(seq__5946_6135__$1);
var G__6145 = null;
var G__6146 = (0);
var G__6147 = (0);
seq__5946_6123 = G__6144;
chunk__5947_6124 = G__6145;
count__5948_6125 = G__6146;
i__5949_6126 = G__6147;
continue;
}
} else {
}
}
break;
}


var G__6148 = cljs.core.next(seq__5882_6114__$1);
var G__6149 = null;
var G__6150 = (0);
var G__6151 = (0);
seq__5882_6077 = G__6148;
chunk__5883_6078 = G__6149;
count__5884_6079 = G__6150;
i__5885_6080 = G__6151;
continue;
}
} else {
}
}
break;
}


var G__6152 = seq__5700_6068;
var G__6153 = chunk__5701_6069;
var G__6154 = count__5702_6070;
var G__6155 = (i__5703_6071 + (1));
seq__5700_6068 = G__6152;
chunk__5701_6069 = G__6153;
count__5702_6070 = G__6154;
i__5703_6071 = G__6155;
continue;
} else {
var temp__5735__auto___6156 = cljs.core.seq(seq__5700_6068);
if(temp__5735__auto___6156){
var seq__5700_6157__$1 = temp__5735__auto___6156;
if(cljs.core.chunked_seq_QMARK_(seq__5700_6157__$1)){
var c__4556__auto___6158 = cljs.core.chunk_first(seq__5700_6157__$1);
var G__6159 = cljs.core.chunk_rest(seq__5700_6157__$1);
var G__6160 = c__4556__auto___6158;
var G__6161 = cljs.core.count(c__4556__auto___6158);
var G__6162 = (0);
seq__5700_6068 = G__6159;
chunk__5701_6069 = G__6160;
count__5702_6070 = G__6161;
i__5703_6071 = G__6162;
continue;
} else {
var vec__5962_6163 = cljs.core.first(seq__5700_6157__$1);
var source_idx_6164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5962_6163,(0),null);
var vec__5965_6165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5962_6163,(1),null);
var __6166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5965_6165,(0),null);
var lines_6167__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5965_6165,(1),null);
var seq__5968_6168 = cljs.core.seq(lines_6167__$1);
var chunk__5969_6169 = null;
var count__5970_6170 = (0);
var i__5971_6171 = (0);
while(true){
if((i__5971_6171 < count__5970_6170)){
var vec__6010_6172 = chunk__5969_6169.cljs$core$IIndexed$_nth$arity$2(null,i__5971_6171);
var line_6173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6010_6172,(0),null);
var cols_6174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6010_6172,(1),null);
var seq__6013_6175 = cljs.core.seq(cols_6174);
var chunk__6014_6176 = null;
var count__6015_6177 = (0);
var i__6016_6178 = (0);
while(true){
if((i__6016_6178 < count__6015_6177)){
var vec__6023_6179 = chunk__6014_6176.cljs$core$IIndexed$_nth$arity$2(null,i__6016_6178);
var col_6180 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6023_6179,(0),null);
var infos_6181 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6023_6179,(1),null);
encode_cols(infos_6181,source_idx_6164,line_6173,col_6180);


var G__6182 = seq__6013_6175;
var G__6183 = chunk__6014_6176;
var G__6184 = count__6015_6177;
var G__6185 = (i__6016_6178 + (1));
seq__6013_6175 = G__6182;
chunk__6014_6176 = G__6183;
count__6015_6177 = G__6184;
i__6016_6178 = G__6185;
continue;
} else {
var temp__5735__auto___6186__$1 = cljs.core.seq(seq__6013_6175);
if(temp__5735__auto___6186__$1){
var seq__6013_6187__$1 = temp__5735__auto___6186__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6013_6187__$1)){
var c__4556__auto___6188 = cljs.core.chunk_first(seq__6013_6187__$1);
var G__6189 = cljs.core.chunk_rest(seq__6013_6187__$1);
var G__6190 = c__4556__auto___6188;
var G__6191 = cljs.core.count(c__4556__auto___6188);
var G__6192 = (0);
seq__6013_6175 = G__6189;
chunk__6014_6176 = G__6190;
count__6015_6177 = G__6191;
i__6016_6178 = G__6192;
continue;
} else {
var vec__6026_6193 = cljs.core.first(seq__6013_6187__$1);
var col_6194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6026_6193,(0),null);
var infos_6195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6026_6193,(1),null);
encode_cols(infos_6195,source_idx_6164,line_6173,col_6194);


var G__6196 = cljs.core.next(seq__6013_6187__$1);
var G__6197 = null;
var G__6198 = (0);
var G__6199 = (0);
seq__6013_6175 = G__6196;
chunk__6014_6176 = G__6197;
count__6015_6177 = G__6198;
i__6016_6178 = G__6199;
continue;
}
} else {
}
}
break;
}


var G__6200 = seq__5968_6168;
var G__6201 = chunk__5969_6169;
var G__6202 = count__5970_6170;
var G__6203 = (i__5971_6171 + (1));
seq__5968_6168 = G__6200;
chunk__5969_6169 = G__6201;
count__5970_6170 = G__6202;
i__5971_6171 = G__6203;
continue;
} else {
var temp__5735__auto___6204__$1 = cljs.core.seq(seq__5968_6168);
if(temp__5735__auto___6204__$1){
var seq__5968_6205__$1 = temp__5735__auto___6204__$1;
if(cljs.core.chunked_seq_QMARK_(seq__5968_6205__$1)){
var c__4556__auto___6206 = cljs.core.chunk_first(seq__5968_6205__$1);
var G__6207 = cljs.core.chunk_rest(seq__5968_6205__$1);
var G__6208 = c__4556__auto___6206;
var G__6209 = cljs.core.count(c__4556__auto___6206);
var G__6210 = (0);
seq__5968_6168 = G__6207;
chunk__5969_6169 = G__6208;
count__5970_6170 = G__6209;
i__5971_6171 = G__6210;
continue;
} else {
var vec__6029_6211 = cljs.core.first(seq__5968_6205__$1);
var line_6212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6029_6211,(0),null);
var cols_6213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6029_6211,(1),null);
var seq__6032_6214 = cljs.core.seq(cols_6213);
var chunk__6033_6215 = null;
var count__6034_6216 = (0);
var i__6035_6217 = (0);
while(true){
if((i__6035_6217 < count__6034_6216)){
var vec__6042_6218 = chunk__6033_6215.cljs$core$IIndexed$_nth$arity$2(null,i__6035_6217);
var col_6219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6042_6218,(0),null);
var infos_6220 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6042_6218,(1),null);
encode_cols(infos_6220,source_idx_6164,line_6212,col_6219);


var G__6221 = seq__6032_6214;
var G__6222 = chunk__6033_6215;
var G__6223 = count__6034_6216;
var G__6224 = (i__6035_6217 + (1));
seq__6032_6214 = G__6221;
chunk__6033_6215 = G__6222;
count__6034_6216 = G__6223;
i__6035_6217 = G__6224;
continue;
} else {
var temp__5735__auto___6225__$2 = cljs.core.seq(seq__6032_6214);
if(temp__5735__auto___6225__$2){
var seq__6032_6226__$1 = temp__5735__auto___6225__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6032_6226__$1)){
var c__4556__auto___6227 = cljs.core.chunk_first(seq__6032_6226__$1);
var G__6228 = cljs.core.chunk_rest(seq__6032_6226__$1);
var G__6229 = c__4556__auto___6227;
var G__6230 = cljs.core.count(c__4556__auto___6227);
var G__6231 = (0);
seq__6032_6214 = G__6228;
chunk__6033_6215 = G__6229;
count__6034_6216 = G__6230;
i__6035_6217 = G__6231;
continue;
} else {
var vec__6045_6232 = cljs.core.first(seq__6032_6226__$1);
var col_6233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045_6232,(0),null);
var infos_6234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6045_6232,(1),null);
encode_cols(infos_6234,source_idx_6164,line_6212,col_6233);


var G__6235 = cljs.core.next(seq__6032_6226__$1);
var G__6236 = null;
var G__6237 = (0);
var G__6238 = (0);
seq__6032_6214 = G__6235;
chunk__6033_6215 = G__6236;
count__6034_6216 = G__6237;
i__6035_6217 = G__6238;
continue;
}
} else {
}
}
break;
}


var G__6239 = cljs.core.next(seq__5968_6205__$1);
var G__6240 = null;
var G__6241 = (0);
var G__6242 = (0);
seq__5968_6168 = G__6239;
chunk__5969_6169 = G__6240;
count__5970_6170 = G__6241;
i__5971_6171 = G__6242;
continue;
}
} else {
}
}
break;
}


var G__6243 = cljs.core.next(seq__5700_6157__$1);
var G__6244 = null;
var G__6245 = (0);
var G__6246 = (0);
seq__5700_6068 = G__6243;
chunk__5701_6069 = G__6244;
count__5702_6070 = G__6245;
i__5703_6071 = G__6246;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6048 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5693_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5693_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5694_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5694_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5695_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5695_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__6049 = G__6048;
goog.object.set(G__6049,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__6049;
} else {
return G__6048;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6247 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6247,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6247,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6250 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6250,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6250,(1),null);
var G__6256 = cljs.core.next(col_map_seq);
var G__6257 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6250,col,infos,vec__6247,line,col_map){
return (function (v,p__6253){
var map__6254 = p__6253;
var map__6254__$1 = (((((!((map__6254 == null))))?(((((map__6254.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6254.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6254):map__6254);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6254__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6254__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6250,col,infos,vec__6247,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6256;
new_cols = G__6257;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6258 = cljs.core.next(line_map_seq);
var G__6259 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6258;
new_lines = G__6259;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6260_6532 = cljs.core.seq(reverse_map);
var chunk__6261_6533 = null;
var count__6262_6534 = (0);
var i__6263_6535 = (0);
while(true){
if((i__6263_6535 < count__6262_6534)){
var vec__6398_6536 = chunk__6261_6533.cljs$core$IIndexed$_nth$arity$2(null,i__6263_6535);
var line_6537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6398_6536,(0),null);
var columns_6538 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6398_6536,(1),null);
var seq__6401_6539 = cljs.core.seq(columns_6538);
var chunk__6402_6540 = null;
var count__6403_6541 = (0);
var i__6404_6542 = (0);
while(true){
if((i__6404_6542 < count__6403_6541)){
var vec__6435_6543 = chunk__6402_6540.cljs$core$IIndexed$_nth$arity$2(null,i__6404_6542);
var column_6544 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6435_6543,(0),null);
var column_info_6545 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6435_6543,(1),null);
var seq__6438_6546 = cljs.core.seq(column_info_6545);
var chunk__6439_6547 = null;
var count__6440_6548 = (0);
var i__6441_6549 = (0);
while(true){
if((i__6441_6549 < count__6440_6548)){
var map__6446_6550 = chunk__6439_6547.cljs$core$IIndexed$_nth$arity$2(null,i__6441_6549);
var map__6446_6551__$1 = (((((!((map__6446_6550 == null))))?(((((map__6446_6550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6446_6550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6446_6550):map__6446_6550);
var gline_6552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6446_6551__$1,cljs.core.cst$kw$gline);
var gcol_6553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6446_6551__$1,cljs.core.cst$kw$gcol);
var name_6554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6446_6551__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6552], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6438_6546,chunk__6439_6547,count__6440_6548,i__6441_6549,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6446_6550,map__6446_6551__$1,gline_6552,gcol_6553,name_6554,vec__6435_6543,column_6544,column_info_6545,vec__6398_6536,line_6537,columns_6538,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6553], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6537,cljs.core.cst$kw$col,column_6544,cljs.core.cst$kw$name,name_6554], null));
});})(seq__6438_6546,chunk__6439_6547,count__6440_6548,i__6441_6549,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6446_6550,map__6446_6551__$1,gline_6552,gcol_6553,name_6554,vec__6435_6543,column_6544,column_info_6545,vec__6398_6536,line_6537,columns_6538,inverted))
,cljs.core.sorted_map()));


var G__6555 = seq__6438_6546;
var G__6556 = chunk__6439_6547;
var G__6557 = count__6440_6548;
var G__6558 = (i__6441_6549 + (1));
seq__6438_6546 = G__6555;
chunk__6439_6547 = G__6556;
count__6440_6548 = G__6557;
i__6441_6549 = G__6558;
continue;
} else {
var temp__5735__auto___6559 = cljs.core.seq(seq__6438_6546);
if(temp__5735__auto___6559){
var seq__6438_6560__$1 = temp__5735__auto___6559;
if(cljs.core.chunked_seq_QMARK_(seq__6438_6560__$1)){
var c__4556__auto___6561 = cljs.core.chunk_first(seq__6438_6560__$1);
var G__6562 = cljs.core.chunk_rest(seq__6438_6560__$1);
var G__6563 = c__4556__auto___6561;
var G__6564 = cljs.core.count(c__4556__auto___6561);
var G__6565 = (0);
seq__6438_6546 = G__6562;
chunk__6439_6547 = G__6563;
count__6440_6548 = G__6564;
i__6441_6549 = G__6565;
continue;
} else {
var map__6448_6566 = cljs.core.first(seq__6438_6560__$1);
var map__6448_6567__$1 = (((((!((map__6448_6566 == null))))?(((((map__6448_6566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6448_6566.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6448_6566):map__6448_6566);
var gline_6568 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6448_6567__$1,cljs.core.cst$kw$gline);
var gcol_6569 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6448_6567__$1,cljs.core.cst$kw$gcol);
var name_6570 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6448_6567__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6568], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6438_6546,chunk__6439_6547,count__6440_6548,i__6441_6549,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6448_6566,map__6448_6567__$1,gline_6568,gcol_6569,name_6570,seq__6438_6560__$1,temp__5735__auto___6559,vec__6435_6543,column_6544,column_info_6545,vec__6398_6536,line_6537,columns_6538,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6569], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6537,cljs.core.cst$kw$col,column_6544,cljs.core.cst$kw$name,name_6570], null));
});})(seq__6438_6546,chunk__6439_6547,count__6440_6548,i__6441_6549,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6448_6566,map__6448_6567__$1,gline_6568,gcol_6569,name_6570,seq__6438_6560__$1,temp__5735__auto___6559,vec__6435_6543,column_6544,column_info_6545,vec__6398_6536,line_6537,columns_6538,inverted))
,cljs.core.sorted_map()));


var G__6571 = cljs.core.next(seq__6438_6560__$1);
var G__6572 = null;
var G__6573 = (0);
var G__6574 = (0);
seq__6438_6546 = G__6571;
chunk__6439_6547 = G__6572;
count__6440_6548 = G__6573;
i__6441_6549 = G__6574;
continue;
}
} else {
}
}
break;
}


var G__6575 = seq__6401_6539;
var G__6576 = chunk__6402_6540;
var G__6577 = count__6403_6541;
var G__6578 = (i__6404_6542 + (1));
seq__6401_6539 = G__6575;
chunk__6402_6540 = G__6576;
count__6403_6541 = G__6577;
i__6404_6542 = G__6578;
continue;
} else {
var temp__5735__auto___6579 = cljs.core.seq(seq__6401_6539);
if(temp__5735__auto___6579){
var seq__6401_6580__$1 = temp__5735__auto___6579;
if(cljs.core.chunked_seq_QMARK_(seq__6401_6580__$1)){
var c__4556__auto___6581 = cljs.core.chunk_first(seq__6401_6580__$1);
var G__6582 = cljs.core.chunk_rest(seq__6401_6580__$1);
var G__6583 = c__4556__auto___6581;
var G__6584 = cljs.core.count(c__4556__auto___6581);
var G__6585 = (0);
seq__6401_6539 = G__6582;
chunk__6402_6540 = G__6583;
count__6403_6541 = G__6584;
i__6404_6542 = G__6585;
continue;
} else {
var vec__6450_6586 = cljs.core.first(seq__6401_6580__$1);
var column_6587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6450_6586,(0),null);
var column_info_6588 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6450_6586,(1),null);
var seq__6453_6589 = cljs.core.seq(column_info_6588);
var chunk__6454_6590 = null;
var count__6455_6591 = (0);
var i__6456_6592 = (0);
while(true){
if((i__6456_6592 < count__6455_6591)){
var map__6461_6593 = chunk__6454_6590.cljs$core$IIndexed$_nth$arity$2(null,i__6456_6592);
var map__6461_6594__$1 = (((((!((map__6461_6593 == null))))?(((((map__6461_6593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6461_6593.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6461_6593):map__6461_6593);
var gline_6595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6461_6594__$1,cljs.core.cst$kw$gline);
var gcol_6596 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6461_6594__$1,cljs.core.cst$kw$gcol);
var name_6597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6461_6594__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6595], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6453_6589,chunk__6454_6590,count__6455_6591,i__6456_6592,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6461_6593,map__6461_6594__$1,gline_6595,gcol_6596,name_6597,vec__6450_6586,column_6587,column_info_6588,seq__6401_6580__$1,temp__5735__auto___6579,vec__6398_6536,line_6537,columns_6538,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6596], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6537,cljs.core.cst$kw$col,column_6587,cljs.core.cst$kw$name,name_6597], null));
});})(seq__6453_6589,chunk__6454_6590,count__6455_6591,i__6456_6592,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6461_6593,map__6461_6594__$1,gline_6595,gcol_6596,name_6597,vec__6450_6586,column_6587,column_info_6588,seq__6401_6580__$1,temp__5735__auto___6579,vec__6398_6536,line_6537,columns_6538,inverted))
,cljs.core.sorted_map()));


var G__6598 = seq__6453_6589;
var G__6599 = chunk__6454_6590;
var G__6600 = count__6455_6591;
var G__6601 = (i__6456_6592 + (1));
seq__6453_6589 = G__6598;
chunk__6454_6590 = G__6599;
count__6455_6591 = G__6600;
i__6456_6592 = G__6601;
continue;
} else {
var temp__5735__auto___6602__$1 = cljs.core.seq(seq__6453_6589);
if(temp__5735__auto___6602__$1){
var seq__6453_6603__$1 = temp__5735__auto___6602__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6453_6603__$1)){
var c__4556__auto___6604 = cljs.core.chunk_first(seq__6453_6603__$1);
var G__6605 = cljs.core.chunk_rest(seq__6453_6603__$1);
var G__6606 = c__4556__auto___6604;
var G__6607 = cljs.core.count(c__4556__auto___6604);
var G__6608 = (0);
seq__6453_6589 = G__6605;
chunk__6454_6590 = G__6606;
count__6455_6591 = G__6607;
i__6456_6592 = G__6608;
continue;
} else {
var map__6463_6609 = cljs.core.first(seq__6453_6603__$1);
var map__6463_6610__$1 = (((((!((map__6463_6609 == null))))?(((((map__6463_6609.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6463_6609.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6463_6609):map__6463_6609);
var gline_6611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6463_6610__$1,cljs.core.cst$kw$gline);
var gcol_6612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6463_6610__$1,cljs.core.cst$kw$gcol);
var name_6613 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6463_6610__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6611], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6453_6589,chunk__6454_6590,count__6455_6591,i__6456_6592,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6463_6609,map__6463_6610__$1,gline_6611,gcol_6612,name_6613,seq__6453_6603__$1,temp__5735__auto___6602__$1,vec__6450_6586,column_6587,column_info_6588,seq__6401_6580__$1,temp__5735__auto___6579,vec__6398_6536,line_6537,columns_6538,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6612], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6537,cljs.core.cst$kw$col,column_6587,cljs.core.cst$kw$name,name_6613], null));
});})(seq__6453_6589,chunk__6454_6590,count__6455_6591,i__6456_6592,seq__6401_6539,chunk__6402_6540,count__6403_6541,i__6404_6542,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6463_6609,map__6463_6610__$1,gline_6611,gcol_6612,name_6613,seq__6453_6603__$1,temp__5735__auto___6602__$1,vec__6450_6586,column_6587,column_info_6588,seq__6401_6580__$1,temp__5735__auto___6579,vec__6398_6536,line_6537,columns_6538,inverted))
,cljs.core.sorted_map()));


var G__6614 = cljs.core.next(seq__6453_6603__$1);
var G__6615 = null;
var G__6616 = (0);
var G__6617 = (0);
seq__6453_6589 = G__6614;
chunk__6454_6590 = G__6615;
count__6455_6591 = G__6616;
i__6456_6592 = G__6617;
continue;
}
} else {
}
}
break;
}


var G__6618 = cljs.core.next(seq__6401_6580__$1);
var G__6619 = null;
var G__6620 = (0);
var G__6621 = (0);
seq__6401_6539 = G__6618;
chunk__6402_6540 = G__6619;
count__6403_6541 = G__6620;
i__6404_6542 = G__6621;
continue;
}
} else {
}
}
break;
}


var G__6622 = seq__6260_6532;
var G__6623 = chunk__6261_6533;
var G__6624 = count__6262_6534;
var G__6625 = (i__6263_6535 + (1));
seq__6260_6532 = G__6622;
chunk__6261_6533 = G__6623;
count__6262_6534 = G__6624;
i__6263_6535 = G__6625;
continue;
} else {
var temp__5735__auto___6626 = cljs.core.seq(seq__6260_6532);
if(temp__5735__auto___6626){
var seq__6260_6627__$1 = temp__5735__auto___6626;
if(cljs.core.chunked_seq_QMARK_(seq__6260_6627__$1)){
var c__4556__auto___6628 = cljs.core.chunk_first(seq__6260_6627__$1);
var G__6629 = cljs.core.chunk_rest(seq__6260_6627__$1);
var G__6630 = c__4556__auto___6628;
var G__6631 = cljs.core.count(c__4556__auto___6628);
var G__6632 = (0);
seq__6260_6532 = G__6629;
chunk__6261_6533 = G__6630;
count__6262_6534 = G__6631;
i__6263_6535 = G__6632;
continue;
} else {
var vec__6465_6633 = cljs.core.first(seq__6260_6627__$1);
var line_6634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6465_6633,(0),null);
var columns_6635 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6465_6633,(1),null);
var seq__6468_6636 = cljs.core.seq(columns_6635);
var chunk__6469_6637 = null;
var count__6470_6638 = (0);
var i__6471_6639 = (0);
while(true){
if((i__6471_6639 < count__6470_6638)){
var vec__6502_6640 = chunk__6469_6637.cljs$core$IIndexed$_nth$arity$2(null,i__6471_6639);
var column_6641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6502_6640,(0),null);
var column_info_6642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6502_6640,(1),null);
var seq__6505_6643 = cljs.core.seq(column_info_6642);
var chunk__6506_6644 = null;
var count__6507_6645 = (0);
var i__6508_6646 = (0);
while(true){
if((i__6508_6646 < count__6507_6645)){
var map__6513_6647 = chunk__6506_6644.cljs$core$IIndexed$_nth$arity$2(null,i__6508_6646);
var map__6513_6648__$1 = (((((!((map__6513_6647 == null))))?(((((map__6513_6647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6513_6647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6513_6647):map__6513_6647);
var gline_6649 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6513_6648__$1,cljs.core.cst$kw$gline);
var gcol_6650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6513_6648__$1,cljs.core.cst$kw$gcol);
var name_6651 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6513_6648__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6649], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6505_6643,chunk__6506_6644,count__6507_6645,i__6508_6646,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6513_6647,map__6513_6648__$1,gline_6649,gcol_6650,name_6651,vec__6502_6640,column_6641,column_info_6642,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6650], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6634,cljs.core.cst$kw$col,column_6641,cljs.core.cst$kw$name,name_6651], null));
});})(seq__6505_6643,chunk__6506_6644,count__6507_6645,i__6508_6646,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6513_6647,map__6513_6648__$1,gline_6649,gcol_6650,name_6651,vec__6502_6640,column_6641,column_info_6642,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted))
,cljs.core.sorted_map()));


var G__6652 = seq__6505_6643;
var G__6653 = chunk__6506_6644;
var G__6654 = count__6507_6645;
var G__6655 = (i__6508_6646 + (1));
seq__6505_6643 = G__6652;
chunk__6506_6644 = G__6653;
count__6507_6645 = G__6654;
i__6508_6646 = G__6655;
continue;
} else {
var temp__5735__auto___6656__$1 = cljs.core.seq(seq__6505_6643);
if(temp__5735__auto___6656__$1){
var seq__6505_6657__$1 = temp__5735__auto___6656__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6505_6657__$1)){
var c__4556__auto___6658 = cljs.core.chunk_first(seq__6505_6657__$1);
var G__6659 = cljs.core.chunk_rest(seq__6505_6657__$1);
var G__6660 = c__4556__auto___6658;
var G__6661 = cljs.core.count(c__4556__auto___6658);
var G__6662 = (0);
seq__6505_6643 = G__6659;
chunk__6506_6644 = G__6660;
count__6507_6645 = G__6661;
i__6508_6646 = G__6662;
continue;
} else {
var map__6515_6663 = cljs.core.first(seq__6505_6657__$1);
var map__6515_6664__$1 = (((((!((map__6515_6663 == null))))?(((((map__6515_6663.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6515_6663.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6515_6663):map__6515_6663);
var gline_6665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6515_6664__$1,cljs.core.cst$kw$gline);
var gcol_6666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6515_6664__$1,cljs.core.cst$kw$gcol);
var name_6667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6515_6664__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6665], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6505_6643,chunk__6506_6644,count__6507_6645,i__6508_6646,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6515_6663,map__6515_6664__$1,gline_6665,gcol_6666,name_6667,seq__6505_6657__$1,temp__5735__auto___6656__$1,vec__6502_6640,column_6641,column_info_6642,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6666], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6634,cljs.core.cst$kw$col,column_6641,cljs.core.cst$kw$name,name_6667], null));
});})(seq__6505_6643,chunk__6506_6644,count__6507_6645,i__6508_6646,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6515_6663,map__6515_6664__$1,gline_6665,gcol_6666,name_6667,seq__6505_6657__$1,temp__5735__auto___6656__$1,vec__6502_6640,column_6641,column_info_6642,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted))
,cljs.core.sorted_map()));


var G__6668 = cljs.core.next(seq__6505_6657__$1);
var G__6669 = null;
var G__6670 = (0);
var G__6671 = (0);
seq__6505_6643 = G__6668;
chunk__6506_6644 = G__6669;
count__6507_6645 = G__6670;
i__6508_6646 = G__6671;
continue;
}
} else {
}
}
break;
}


var G__6672 = seq__6468_6636;
var G__6673 = chunk__6469_6637;
var G__6674 = count__6470_6638;
var G__6675 = (i__6471_6639 + (1));
seq__6468_6636 = G__6672;
chunk__6469_6637 = G__6673;
count__6470_6638 = G__6674;
i__6471_6639 = G__6675;
continue;
} else {
var temp__5735__auto___6676__$1 = cljs.core.seq(seq__6468_6636);
if(temp__5735__auto___6676__$1){
var seq__6468_6677__$1 = temp__5735__auto___6676__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6468_6677__$1)){
var c__4556__auto___6678 = cljs.core.chunk_first(seq__6468_6677__$1);
var G__6679 = cljs.core.chunk_rest(seq__6468_6677__$1);
var G__6680 = c__4556__auto___6678;
var G__6681 = cljs.core.count(c__4556__auto___6678);
var G__6682 = (0);
seq__6468_6636 = G__6679;
chunk__6469_6637 = G__6680;
count__6470_6638 = G__6681;
i__6471_6639 = G__6682;
continue;
} else {
var vec__6517_6683 = cljs.core.first(seq__6468_6677__$1);
var column_6684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6517_6683,(0),null);
var column_info_6685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6517_6683,(1),null);
var seq__6520_6686 = cljs.core.seq(column_info_6685);
var chunk__6521_6687 = null;
var count__6522_6688 = (0);
var i__6523_6689 = (0);
while(true){
if((i__6523_6689 < count__6522_6688)){
var map__6528_6690 = chunk__6521_6687.cljs$core$IIndexed$_nth$arity$2(null,i__6523_6689);
var map__6528_6691__$1 = (((((!((map__6528_6690 == null))))?(((((map__6528_6690.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6528_6690.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6528_6690):map__6528_6690);
var gline_6692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6528_6691__$1,cljs.core.cst$kw$gline);
var gcol_6693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6528_6691__$1,cljs.core.cst$kw$gcol);
var name_6694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6528_6691__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6692], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6520_6686,chunk__6521_6687,count__6522_6688,i__6523_6689,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6528_6690,map__6528_6691__$1,gline_6692,gcol_6693,name_6694,vec__6517_6683,column_6684,column_info_6685,seq__6468_6677__$1,temp__5735__auto___6676__$1,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6693], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6634,cljs.core.cst$kw$col,column_6684,cljs.core.cst$kw$name,name_6694], null));
});})(seq__6520_6686,chunk__6521_6687,count__6522_6688,i__6523_6689,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6528_6690,map__6528_6691__$1,gline_6692,gcol_6693,name_6694,vec__6517_6683,column_6684,column_info_6685,seq__6468_6677__$1,temp__5735__auto___6676__$1,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted))
,cljs.core.sorted_map()));


var G__6695 = seq__6520_6686;
var G__6696 = chunk__6521_6687;
var G__6697 = count__6522_6688;
var G__6698 = (i__6523_6689 + (1));
seq__6520_6686 = G__6695;
chunk__6521_6687 = G__6696;
count__6522_6688 = G__6697;
i__6523_6689 = G__6698;
continue;
} else {
var temp__5735__auto___6699__$2 = cljs.core.seq(seq__6520_6686);
if(temp__5735__auto___6699__$2){
var seq__6520_6700__$1 = temp__5735__auto___6699__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6520_6700__$1)){
var c__4556__auto___6701 = cljs.core.chunk_first(seq__6520_6700__$1);
var G__6702 = cljs.core.chunk_rest(seq__6520_6700__$1);
var G__6703 = c__4556__auto___6701;
var G__6704 = cljs.core.count(c__4556__auto___6701);
var G__6705 = (0);
seq__6520_6686 = G__6702;
chunk__6521_6687 = G__6703;
count__6522_6688 = G__6704;
i__6523_6689 = G__6705;
continue;
} else {
var map__6530_6706 = cljs.core.first(seq__6520_6700__$1);
var map__6530_6707__$1 = (((((!((map__6530_6706 == null))))?(((((map__6530_6706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6530_6706.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__6530_6706):map__6530_6706);
var gline_6708 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6530_6707__$1,cljs.core.cst$kw$gline);
var gcol_6709 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6530_6707__$1,cljs.core.cst$kw$gcol);
var name_6710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6530_6707__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6708], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6520_6686,chunk__6521_6687,count__6522_6688,i__6523_6689,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6530_6706,map__6530_6707__$1,gline_6708,gcol_6709,name_6710,seq__6520_6700__$1,temp__5735__auto___6699__$2,vec__6517_6683,column_6684,column_info_6685,seq__6468_6677__$1,temp__5735__auto___6676__$1,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6709], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_6634,cljs.core.cst$kw$col,column_6684,cljs.core.cst$kw$name,name_6710], null));
});})(seq__6520_6686,chunk__6521_6687,count__6522_6688,i__6523_6689,seq__6468_6636,chunk__6469_6637,count__6470_6638,i__6471_6639,seq__6260_6532,chunk__6261_6533,count__6262_6534,i__6263_6535,map__6530_6706,map__6530_6707__$1,gline_6708,gcol_6709,name_6710,seq__6520_6700__$1,temp__5735__auto___6699__$2,vec__6517_6683,column_6684,column_info_6685,seq__6468_6677__$1,temp__5735__auto___6676__$1,vec__6465_6633,line_6634,columns_6635,seq__6260_6627__$1,temp__5735__auto___6626,inverted))
,cljs.core.sorted_map()));


var G__6711 = cljs.core.next(seq__6520_6700__$1);
var G__6712 = null;
var G__6713 = (0);
var G__6714 = (0);
seq__6520_6686 = G__6711;
chunk__6521_6687 = G__6712;
count__6522_6688 = G__6713;
i__6523_6689 = G__6714;
continue;
}
} else {
}
}
break;
}


var G__6715 = cljs.core.next(seq__6468_6677__$1);
var G__6716 = null;
var G__6717 = (0);
var G__6718 = (0);
seq__6468_6636 = G__6715;
chunk__6469_6637 = G__6716;
count__6470_6638 = G__6717;
i__6471_6639 = G__6718;
continue;
}
} else {
}
}
break;
}


var G__6719 = cljs.core.next(seq__6260_6627__$1);
var G__6720 = null;
var G__6721 = (0);
var G__6722 = (0);
seq__6260_6532 = G__6719;
chunk__6261_6533 = G__6720;
count__6262_6534 = G__6721;
i__6263_6535 = G__6722;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
