// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
/**
 * Tries all servers in parralel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__73060_73229 = cljs.core.seq.call(null,servers);
var chunk__73061_73230 = null;
var count__73062_73231 = (0);
var i__73063_73232 = (0);
while(true){
if((i__73063_73232 < count__73062_73231)){
var server_73233 = cljs.core._nth.call(null,chunk__73061_73230,i__73063_73232);
var healthcheck_uri_73234 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73233),"/fdb/health"].join('');
var resp_chan_73235 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_73234,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11542__auto___73236 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233){
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = ((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233){
return (function (state_73124){
var state_val_73125 = (state_73124[(1)]);
if((state_val_73125 === (1))){
var state_73124__$1 = state_73124;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73124__$1,(2),resp_chan_73235);
} else {
if((state_val_73125 === (2))){
var inst_73113 = (state_73124[(7)]);
var inst_73113__$1 = (state_73124[(2)]);
var inst_73114 = fluree.db.util.core.exception_QMARK_.call(null,inst_73113__$1);
var state_73124__$1 = (function (){var statearr_73126 = state_73124;
(statearr_73126[(7)] = inst_73113__$1);

return statearr_73126;
})();
if(inst_73114){
var statearr_73127_73237 = state_73124__$1;
(statearr_73127_73237[(1)] = (3));

} else {
var statearr_73128_73238 = state_73124__$1;
(statearr_73128_73238[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73125 === (3))){
var inst_73113 = (state_73124[(7)]);
var inst_73116 = cljs.core.ex_message.call(null,inst_73113);
var inst_73117 = cljs.core.ex_data.call(null,inst_73113);
var inst_73118 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_73116,inst_73117);
var state_73124__$1 = state_73124;
var statearr_73129_73239 = state_73124__$1;
(statearr_73129_73239[(2)] = inst_73118);

(statearr_73129_73239[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73125 === (4))){
var inst_73120 = cljs.core.async.put_BANG_.call(null,promise_chan,server_73233);
var state_73124__$1 = state_73124;
var statearr_73130_73240 = state_73124__$1;
(statearr_73130_73240[(2)] = inst_73120);

(statearr_73130_73240[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73125 === (5))){
var inst_73122 = (state_73124[(2)]);
var state_73124__$1 = state_73124;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73124__$1,inst_73122);
} else {
return null;
}
}
}
}
}
});})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233))
;
return ((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,switch__11468__auto__,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0 = (function (){
var statearr_73131 = [null,null,null,null,null,null,null,null];
(statearr_73131[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__);

(statearr_73131[(1)] = (1));

return statearr_73131;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1 = (function (state_73124){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73124);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73132){var ex__11472__auto__ = e73132;
var statearr_73133_73241 = state_73124;
(statearr_73133_73241[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73124[(4)]))){
var statearr_73134_73242 = state_73124;
(statearr_73134_73242[(1)] = cljs.core.first.call(null,(state_73124[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73243 = state_73124;
state_73124 = G__73243;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = function(state_73124){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1.call(this,state_73124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__;
})()
;})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,switch__11468__auto__,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233))
})();
var state__11544__auto__ = (function (){var statearr_73135 = f__11543__auto__.call(null);
(statearr_73135[(6)] = c__11542__auto___73236);

return statearr_73135;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73236,healthcheck_uri_73234,resp_chan_73235,server_73233))
);



var G__73244 = seq__73060_73229;
var G__73245 = chunk__73061_73230;
var G__73246 = count__73062_73231;
var G__73247 = (i__73063_73232 + (1));
seq__73060_73229 = G__73244;
chunk__73061_73230 = G__73245;
count__73062_73231 = G__73246;
i__73063_73232 = G__73247;
continue;
} else {
var temp__5735__auto___73248 = cljs.core.seq.call(null,seq__73060_73229);
if(temp__5735__auto___73248){
var seq__73060_73249__$1 = temp__5735__auto___73248;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__73060_73249__$1)){
var c__4556__auto___73250 = cljs.core.chunk_first.call(null,seq__73060_73249__$1);
var G__73251 = cljs.core.chunk_rest.call(null,seq__73060_73249__$1);
var G__73252 = c__4556__auto___73250;
var G__73253 = cljs.core.count.call(null,c__4556__auto___73250);
var G__73254 = (0);
seq__73060_73229 = G__73251;
chunk__73061_73230 = G__73252;
count__73062_73231 = G__73253;
i__73063_73232 = G__73254;
continue;
} else {
var server_73255 = cljs.core.first.call(null,seq__73060_73249__$1);
var healthcheck_uri_73256 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73255),"/fdb/health"].join('');
var resp_chan_73257 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_73256,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__11542__auto___73258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248){
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = ((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248){
return (function (state_73148){
var state_val_73149 = (state_73148[(1)]);
if((state_val_73149 === (1))){
var state_73148__$1 = state_73148;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73148__$1,(2),resp_chan_73257);
} else {
if((state_val_73149 === (2))){
var inst_73137 = (state_73148[(7)]);
var inst_73137__$1 = (state_73148[(2)]);
var inst_73138 = fluree.db.util.core.exception_QMARK_.call(null,inst_73137__$1);
var state_73148__$1 = (function (){var statearr_73150 = state_73148;
(statearr_73150[(7)] = inst_73137__$1);

return statearr_73150;
})();
if(inst_73138){
var statearr_73151_73259 = state_73148__$1;
(statearr_73151_73259[(1)] = (3));

} else {
var statearr_73152_73260 = state_73148__$1;
(statearr_73152_73260[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73149 === (3))){
var inst_73137 = (state_73148[(7)]);
var inst_73140 = cljs.core.ex_message.call(null,inst_73137);
var inst_73141 = cljs.core.ex_data.call(null,inst_73137);
var inst_73142 = fluree.db.util.log.warn.call(null,"Server contact error: ",inst_73140,inst_73141);
var state_73148__$1 = state_73148;
var statearr_73153_73261 = state_73148__$1;
(statearr_73153_73261[(2)] = inst_73142);

(statearr_73153_73261[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73149 === (4))){
var inst_73144 = cljs.core.async.put_BANG_.call(null,promise_chan,server_73255);
var state_73148__$1 = state_73148;
var statearr_73154_73262 = state_73148__$1;
(statearr_73154_73262[(2)] = inst_73144);

(statearr_73154_73262[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73149 === (5))){
var inst_73146 = (state_73148[(2)]);
var state_73148__$1 = state_73148;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73148__$1,inst_73146);
} else {
return null;
}
}
}
}
}
});})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248))
;
return ((function (seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,switch__11468__auto__,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0 = (function (){
var statearr_73155 = [null,null,null,null,null,null,null,null];
(statearr_73155[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__);

(statearr_73155[(1)] = (1));

return statearr_73155;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1 = (function (state_73148){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73148);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73156){var ex__11472__auto__ = e73156;
var statearr_73157_73263 = state_73148;
(statearr_73157_73263[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73148[(4)]))){
var statearr_73158_73264 = state_73148;
(statearr_73158_73264[(1)] = cljs.core.first.call(null,(state_73148[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73265 = state_73148;
state_73148 = G__73265;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = function(state_73148){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1.call(this,state_73148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__;
})()
;})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,switch__11468__auto__,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248))
})();
var state__11544__auto__ = (function (){var statearr_73159 = f__11543__auto__.call(null);
(statearr_73159[(6)] = c__11542__auto___73258);

return statearr_73159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});})(seq__73060_73229,chunk__73061_73230,count__73062_73231,i__73063_73232,c__11542__auto___73258,healthcheck_uri_73256,resp_chan_73257,server_73255,seq__73060_73249__$1,temp__5735__auto___73248))
);



var G__73266 = cljs.core.next.call(null,seq__73060_73249__$1);
var G__73267 = null;
var G__73268 = (0);
var G__73269 = (0);
seq__73060_73229 = G__73266;
chunk__73061_73230 = G__73267;
count__73062_73231 = G__73268;
i__73063_73232 = G__73269;
continue;
}
} else {
}
}
break;
}

var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73203){
var state_val_73204 = (state_73203[(1)]);
if((state_val_73204 === (7))){
var inst_73175 = (state_73203[(7)]);
var inst_73182 = cljs.core._EQ_.call(null,inst_73175,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_73203__$1 = state_73203;
if(inst_73182){
var statearr_73205_73270 = state_73203__$1;
(statearr_73205_73270[(1)] = (9));

} else {
var statearr_73206_73271 = state_73203__$1;
(statearr_73206_73271[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (1))){
var inst_73167 = (state_73203[(8)]);
var inst_73168 = (state_73203[(9)]);
var inst_73167__$1 = promise_chan;
var inst_73168__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_73169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73170 = [inst_73167__$1,inst_73168__$1];
var inst_73171 = (new cljs.core.PersistentVector(null,2,(5),inst_73169,inst_73170,null));
var state_73203__$1 = (function (){var statearr_73207 = state_73203;
(statearr_73207[(8)] = inst_73167__$1);

(statearr_73207[(9)] = inst_73168__$1);

return statearr_73207;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_73203__$1,(2),inst_73171);
} else {
if((state_val_73204 === (4))){
var inst_73168 = (state_73203[(9)]);
var inst_73175 = (state_73203[(7)]);
var inst_73179 = cljs.core._EQ_.call(null,inst_73175,inst_73168);
var state_73203__$1 = state_73203;
if(inst_73179){
var statearr_73208_73272 = state_73203__$1;
(statearr_73208_73272[(1)] = (6));

} else {
var statearr_73209_73273 = state_73203__$1;
(statearr_73209_73273[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (13))){
var state_73203__$1 = state_73203;
var statearr_73210_73274 = state_73203__$1;
(statearr_73210_73274[(2)] = null);

(statearr_73210_73274[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (6))){
var state_73203__$1 = state_73203;
var statearr_73211_73275 = state_73203__$1;
(statearr_73211_73275[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_73211_73275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (3))){
var state_73203__$1 = state_73203;
var statearr_73212_73276 = state_73203__$1;
(statearr_73212_73276[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_73212_73276[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (12))){
var inst_73193 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_73194 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73195 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_73196 = cljs.core.PersistentHashMap.fromArrays(inst_73194,inst_73195);
var inst_73197 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_73196);
var inst_73198 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_73197);
var state_73203__$1 = (function (){var statearr_73213 = state_73203;
(statearr_73213[(10)] = inst_73193);

return statearr_73213;
})();
var statearr_73214_73277 = state_73203__$1;
(statearr_73214_73277[(2)] = inst_73198);

(statearr_73214_73277[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (2))){
var inst_73167 = (state_73203[(8)]);
var inst_73175 = (state_73203[(7)]);
var inst_73173 = (state_73203[(2)]);
var inst_73174 = cljs.core.nth.call(null,inst_73173,(0),null);
var inst_73175__$1 = cljs.core.nth.call(null,inst_73173,(1),null);
var inst_73176 = cljs.core._EQ_.call(null,inst_73175__$1,inst_73167);
var state_73203__$1 = (function (){var statearr_73215 = state_73203;
(statearr_73215[(11)] = inst_73174);

(statearr_73215[(7)] = inst_73175__$1);

return statearr_73215;
})();
if(inst_73176){
var statearr_73216_73278 = state_73203__$1;
(statearr_73216_73278[(1)] = (3));

} else {
var statearr_73217_73279 = state_73203__$1;
(statearr_73217_73279[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (11))){
var inst_73186 = (state_73203[(2)]);
var state_73203__$1 = state_73203;
var statearr_73218_73280 = state_73203__$1;
(statearr_73218_73280[(2)] = inst_73186);

(statearr_73218_73280[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (9))){
var inst_73174 = (state_73203[(11)]);
var state_73203__$1 = state_73203;
var statearr_73219_73281 = state_73203__$1;
(statearr_73219_73281[(2)] = inst_73174);

(statearr_73219_73281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (5))){
var inst_73190 = (state_73203[(2)]);
var inst_73191 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_73190);
var state_73203__$1 = state_73203;
if(inst_73191){
var statearr_73220_73282 = state_73203__$1;
(statearr_73220_73282[(1)] = (12));

} else {
var statearr_73221_73283 = state_73203__$1;
(statearr_73221_73283[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (14))){
var inst_73201 = (state_73203[(2)]);
var state_73203__$1 = state_73203;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73203__$1,inst_73201);
} else {
if((state_val_73204 === (10))){
var state_73203__$1 = state_73203;
var statearr_73222_73284 = state_73203__$1;
(statearr_73222_73284[(2)] = null);

(statearr_73222_73284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73204 === (8))){
var inst_73188 = (state_73203[(2)]);
var state_73203__$1 = state_73203;
var statearr_73223_73285 = state_73203__$1;
(statearr_73223_73285[(2)] = inst_73188);

(statearr_73223_73285[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0 = (function (){
var statearr_73224 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73224[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__);

(statearr_73224[(1)] = (1));

return statearr_73224;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1 = (function (state_73203){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73225){var ex__11472__auto__ = e73225;
var statearr_73226_73286 = state_73203;
(statearr_73226_73286[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73203[(4)]))){
var statearr_73227_73287 = state_73203;
(statearr_73227_73287[(1)] = cljs.core.first.call(null,(state_73203[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73288 = state_73203;
state_73203 = G__73288;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__ = function(state_73203){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1.call(this,state_73203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73228 = f__11543__auto__.call(null);
(statearr_73228[(6)] = c__11542__auto__);

return statearr_73228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73332){
var state_val_73333 = (state_73332[(1)]);
if((state_val_73333 === (7))){
var state_73332__$1 = state_73332;
var statearr_73334_73360 = state_73332__$1;
(statearr_73334_73360[(2)] = null);

(statearr_73334_73360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (1))){
var state_73332__$1 = state_73332;
var statearr_73335_73361 = state_73332__$1;
(statearr_73335_73361[(2)] = null);

(statearr_73335_73361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (4))){
var inst_73289 = (state_73332[(2)]);
var state_73332__$1 = state_73332;
var statearr_73336_73362 = state_73332__$1;
(statearr_73336_73362[(2)] = inst_73289);

(statearr_73336_73362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (6))){
var inst_73311 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_73332__$1 = state_73332;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73332__$1,(9),inst_73311);
} else {
if((state_val_73333 === (3))){
var inst_73330 = (state_73332[(2)]);
var state_73332__$1 = state_73332;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73332__$1,inst_73330);
} else {
if((state_val_73333 === (12))){
var inst_73324 = (state_73332[(2)]);
var state_73332__$1 = state_73332;
var statearr_73337_73363 = state_73332__$1;
(statearr_73337_73363[(2)] = inst_73324);

(statearr_73337_73363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (2))){
var inst_73305 = (state_73332[(7)]);
var inst_73300 = (state_73332[(8)]);
var inst_73295 = (state_73332[(9)]);
var _ = (function (){var statearr_73338 = state_73332;
(statearr_73338[(4)] = cljs.core.cons.call(null,(5),(state_73332[(4)])));

return statearr_73338;
})();
var inst_73295__$1 = fluree.db.util.core.random_uuid.call(null);
var inst_73296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73297 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_73298 = (new cljs.core.PersistentVector(null,2,(5),inst_73296,inst_73297,null));
var inst_73299 = (function (){var lock_id = inst_73295__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_73300__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_73298,inst_73299);
var inst_73301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73302 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_73303 = (new cljs.core.PersistentVector(null,3,(5),inst_73301,inst_73302,null));
var inst_73304 = cljs.core.get_in.call(null,inst_73300__$1,inst_73303);
var inst_73305__$1 = cljs.core._EQ_.call(null,inst_73295__$1,inst_73304);
var inst_73306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73307 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_73308 = (new cljs.core.PersistentVector(null,3,(5),inst_73306,inst_73307,null));
var inst_73309 = cljs.core.get_in.call(null,inst_73300__$1,inst_73308);
var state_73332__$1 = (function (){var statearr_73339 = state_73332;
(statearr_73339[(10)] = inst_73309);

(statearr_73339[(7)] = inst_73305__$1);

(statearr_73339[(8)] = inst_73300__$1);

(statearr_73339[(9)] = inst_73295__$1);

return statearr_73339;
})();
if(inst_73305__$1){
var statearr_73340_73364 = state_73332__$1;
(statearr_73340_73364[(1)] = (6));

} else {
var statearr_73341_73365 = state_73332__$1;
(statearr_73341_73365[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (11))){
var inst_73309 = (state_73332[(10)]);
var inst_73315 = (state_73332[(11)]);
var inst_73316 = (state_73332[(12)]);
var inst_73322 = fluree.db.util.xhttp.try_socket.call(null,inst_73315,sub_chan,pub_chan,inst_73309,(60000),inst_73316);
var state_73332__$1 = state_73332;
var statearr_73343_73366 = state_73332__$1;
(statearr_73343_73366[(2)] = inst_73322);

(statearr_73343_73366[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (9))){
var inst_73309 = (state_73332[(10)]);
var inst_73305 = (state_73332[(7)]);
var inst_73315 = (state_73332[(11)]);
var inst_73300 = (state_73332[(8)]);
var inst_73313 = (state_73332[(13)]);
var inst_73295 = (state_73332[(9)]);
var inst_73313__$1 = (state_73332[(2)]);
var inst_73314 = clojure.string.replace.call(null,inst_73313__$1,"http","ws");
var inst_73315__$1 = [inst_73314,"/fdb/ws"].join('');
var inst_73316 = (function (){var lock_id = inst_73295;
var state = inst_73300;
var have_lock_QMARK_ = inst_73305;
var resp_chan = inst_73309;
var healthy_server = inst_73313__$1;
var ws_url = inst_73315__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_73317 = fluree.db.util.core.exception_QMARK_.call(null,inst_73313__$1);
var state_73332__$1 = (function (){var statearr_73344 = state_73332;
(statearr_73344[(11)] = inst_73315__$1);

(statearr_73344[(13)] = inst_73313__$1);

(statearr_73344[(12)] = inst_73316);

return statearr_73344;
})();
if(inst_73317){
var statearr_73345_73367 = state_73332__$1;
(statearr_73345_73367[(1)] = (10));

} else {
var statearr_73346_73368 = state_73332__$1;
(statearr_73346_73368[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (5))){
var _ = (function (){var statearr_73347 = state_73332;
(statearr_73347[(4)] = cljs.core.rest.call(null,(state_73332[(4)])));

return statearr_73347;
})();
var state_73332__$1 = state_73332;
var ex73342 = (state_73332__$1[(2)]);
var statearr_73348_73369 = state_73332__$1;
(statearr_73348_73369[(5)] = ex73342);


if((ex73342 instanceof Error)){
var statearr_73349_73370 = state_73332__$1;
(statearr_73349_73370[(1)] = (4));

(statearr_73349_73370[(5)] = null);

} else {
throw ex73342;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (10))){
var inst_73309 = (state_73332[(10)]);
var inst_73313 = (state_73332[(13)]);
var inst_73319 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_73320 = cljs.core.async.put_BANG_.call(null,inst_73309,inst_73313);
var state_73332__$1 = (function (){var statearr_73350 = state_73332;
(statearr_73350[(14)] = inst_73319);

return statearr_73350;
})();
var statearr_73351_73371 = state_73332__$1;
(statearr_73351_73371[(2)] = inst_73320);

(statearr_73351_73371[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73333 === (8))){
var inst_73309 = (state_73332[(10)]);
var inst_73327 = (state_73332[(2)]);
var _ = (function (){var statearr_73352 = state_73332;
(statearr_73352[(4)] = cljs.core.rest.call(null,(state_73332[(4)])));

return statearr_73352;
})();
var state_73332__$1 = (function (){var statearr_73353 = state_73332;
(statearr_73353[(15)] = inst_73327);

return statearr_73353;
})();
var statearr_73354_73372 = state_73332__$1;
(statearr_73354_73372[(2)] = inst_73309);

(statearr_73354_73372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__11469__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__11469__auto____0 = (function (){
var statearr_73355 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73355[(0)] = fluree$db$connection$establish_socket_$_state_machine__11469__auto__);

(statearr_73355[(1)] = (1));

return statearr_73355;
});
var fluree$db$connection$establish_socket_$_state_machine__11469__auto____1 = (function (state_73332){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73332);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73356){var ex__11472__auto__ = e73356;
var statearr_73357_73373 = state_73332;
(statearr_73357_73373[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73332[(4)]))){
var statearr_73358_73374 = state_73332;
(statearr_73358_73374[(1)] = cljs.core.first.call(null,(state_73332[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73375 = state_73332;
state_73332 = G__73375;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__11469__auto__ = function(state_73332){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__11469__auto____1.call(this,state_73332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__11469__auto____0;
fluree$db$connection$establish_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__11469__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73359 = f__11543__auto__.call(null);
(statearr_73359[(6)] = c__11542__auto__);

return statearr_73359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k73377,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__73381 = k73377;
var G__73381__$1 = (((G__73381 instanceof cljs.core.Keyword))?G__73381.fqn:null);
switch (G__73381__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k73377,else__4383__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__73382){
var vec__73383 = p__73382;
var k__4403__auto__ = cljs.core.nth.call(null,vec__73383,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__73383,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__73376){
var self__ = this;
var G__73376__$1 = this;
return (new cljs.core.RecordIter((0),G__73376__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (21 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this73378,other73379){
var self__ = this;
var this73378__$1 = this;
return (((!((other73379 == null)))) && ((this73378__$1.constructor === other73379.constructor)) && (cljs.core._EQ_.call(null,this73378__$1.id,other73379.id)) && (cljs.core._EQ_.call(null,this73378__$1.servers,other73379.servers)) && (cljs.core._EQ_.call(null,this73378__$1.state,other73379.state)) && (cljs.core._EQ_.call(null,this73378__$1.req_chan,other73379.req_chan)) && (cljs.core._EQ_.call(null,this73378__$1.sub_chan,other73379.sub_chan)) && (cljs.core._EQ_.call(null,this73378__$1.pub_chan,other73379.pub_chan)) && (cljs.core._EQ_.call(null,this73378__$1.storage_read,other73379.storage_read)) && (cljs.core._EQ_.call(null,this73378__$1.storage_write,other73379.storage_write)) && (cljs.core._EQ_.call(null,this73378__$1.object_cache,other73379.object_cache)) && (cljs.core._EQ_.call(null,this73378__$1.parallelism,other73379.parallelism)) && (cljs.core._EQ_.call(null,this73378__$1.serializer,other73379.serializer)) && (cljs.core._EQ_.call(null,this73378__$1.default_network,other73379.default_network)) && (cljs.core._EQ_.call(null,this73378__$1.transactor_QMARK_,other73379.transactor_QMARK_)) && (cljs.core._EQ_.call(null,this73378__$1.publish,other73379.publish)) && (cljs.core._EQ_.call(null,this73378__$1.transact_handler,other73379.transact_handler)) && (cljs.core._EQ_.call(null,this73378__$1.tx_private_key,other73379.tx_private_key)) && (cljs.core._EQ_.call(null,this73378__$1.tx_key_id,other73379.tx_key_id)) && (cljs.core._EQ_.call(null,this73378__$1.meta,other73379.meta)) && (cljs.core._EQ_.call(null,this73378__$1.add_listener,other73379.add_listener)) && (cljs.core._EQ_.call(null,this73378__$1.remove_listener,other73379.remove_listener)) && (cljs.core._EQ_.call(null,this73378__$1.close,other73379.close)) && (cljs.core._EQ_.call(null,this73378__$1.__extmap,other73379.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__73376){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__73386 = cljs.core.keyword_identical_QMARK_;
var expr__73387 = k__4388__auto__;
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__73387))){
return (new fluree.db.connection.Connection(G__73376,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,G__73376,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__73376,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__73376,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__73376,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__73376,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__73376,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__73376,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__73376,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__73376,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__73376,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__73376,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__73376,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__73376,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__73376,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__73376,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__73376,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__73376,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__73376,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__73376,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__73386.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__73387))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__73376,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__73376),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__73376){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__73376,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__73380){
var extmap__4419__auto__ = (function (){var G__73389 = cljs.core.dissoc.call(null,G__73380,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__73380)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__73389);
} else {
return G__73389;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__73380),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__73380),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__73394 = servers_STAR_;
var vec__73395 = G__73394;
var seq__73396 = cljs.core.seq.call(null,vec__73395);
var first__73397 = cljs.core.first.call(null,seq__73396);
var seq__73396__$1 = cljs.core.next.call(null,seq__73396);
var server = first__73397;
var r = seq__73396__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__73394__$1 = G__73394;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__73401 = G__73394__$1;
var seq__73402 = cljs.core.seq.call(null,vec__73401);
var first__73403 = cljs.core.first.call(null,seq__73402);
var seq__73402__$1 = cljs.core.next.call(null,seq__73402);
var server__$1 = first__73403;
var r__$1 = seq__73402__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8080"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/(((?!-))(xn--|_{1,1})?[a-z0-9-]{0,61}[a-z0-9]{1,1}\.)*(xn--)?([a-z0-9\-]{1,61}|[a-z0-9-]{1,30}\.[a-z]{2,})(?:\:\d+)$/,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__4115__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__73404 = r__$1;
var G__73405 = is_https_QMARK_;
var G__73406 = result_STAR_;
G__73394__$1 = G__73404;
https_QMARK___$1 = G__73405;
result__$1 = G__73406;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__73407 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__73407 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__73407);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73436){
var state_val_73437 = (state_73436[(1)]);
if((state_val_73437 === (7))){
var inst_73422 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73423 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73424 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73425 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73426 = fluree.db.connection.establish_socket.call(null,inst_73422,inst_73423,inst_73424,inst_73425);
var state_73436__$1 = state_73436;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73436__$1,(9),inst_73426);
} else {
if((state_val_73437 === (1))){
var state_73436__$1 = state_73436;
var statearr_73438_73457 = state_73436__$1;
(statearr_73438_73457[(2)] = null);

(statearr_73438_73457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (4))){
var inst_73408 = (state_73436[(2)]);
var state_73436__$1 = state_73436;
var statearr_73439_73458 = state_73436__$1;
(statearr_73439_73458[(2)] = inst_73408);

(statearr_73439_73458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (6))){
var inst_73419 = (state_73436[(7)]);
var state_73436__$1 = state_73436;
var statearr_73440_73459 = state_73436__$1;
(statearr_73440_73459[(2)] = inst_73419);

(statearr_73440_73459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (3))){
var inst_73434 = (state_73436[(2)]);
var state_73436__$1 = state_73436;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73436__$1,inst_73434);
} else {
if((state_val_73437 === (2))){
var inst_73419 = (state_73436[(7)]);
var _ = (function (){var statearr_73442 = state_73436;
(statearr_73442[(4)] = cljs.core.cons.call(null,(5),(state_73436[(4)])));

return statearr_73442;
})();
var inst_73414 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_73415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73416 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73417 = [inst_73416,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_73418 = (new cljs.core.PersistentVector(null,3,(5),inst_73415,inst_73417,null));
var inst_73419__$1 = cljs.core.get_in.call(null,inst_73414,inst_73418);
var state_73436__$1 = (function (){var statearr_73443 = state_73436;
(statearr_73443[(7)] = inst_73419__$1);

return statearr_73443;
})();
if(cljs.core.truth_(inst_73419__$1)){
var statearr_73444_73460 = state_73436__$1;
(statearr_73444_73460[(1)] = (6));

} else {
var statearr_73445_73461 = state_73436__$1;
(statearr_73445_73461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (9))){
var inst_73428 = (state_73436[(2)]);
var inst_73429 = fluree.db.util.async.throw_err.call(null,inst_73428);
var state_73436__$1 = state_73436;
var statearr_73446_73462 = state_73436__$1;
(statearr_73446_73462[(2)] = inst_73429);

(statearr_73446_73462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (5))){
var _ = (function (){var statearr_73447 = state_73436;
(statearr_73447[(4)] = cljs.core.rest.call(null,(state_73436[(4)])));

return statearr_73447;
})();
var state_73436__$1 = state_73436;
var ex73441 = (state_73436__$1[(2)]);
var statearr_73448_73463 = state_73436__$1;
(statearr_73448_73463[(5)] = ex73441);


if((ex73441 instanceof Error)){
var statearr_73449_73464 = state_73436__$1;
(statearr_73449_73464[(1)] = (4));

(statearr_73449_73464[(5)] = null);

} else {
throw ex73441;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73437 === (8))){
var inst_73431 = (state_73436[(2)]);
var _ = (function (){var statearr_73450 = state_73436;
(statearr_73450[(4)] = cljs.core.rest.call(null,(state_73436[(4)])));

return statearr_73450;
})();
var state_73436__$1 = state_73436;
var statearr_73451_73465 = state_73436__$1;
(statearr_73451_73465[(2)] = inst_73431);

(statearr_73451_73465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__11469__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__11469__auto____0 = (function (){
var statearr_73452 = [null,null,null,null,null,null,null,null];
(statearr_73452[(0)] = fluree$db$connection$get_socket_$_state_machine__11469__auto__);

(statearr_73452[(1)] = (1));

return statearr_73452;
});
var fluree$db$connection$get_socket_$_state_machine__11469__auto____1 = (function (state_73436){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73436);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73453){var ex__11472__auto__ = e73453;
var statearr_73454_73466 = state_73436;
(statearr_73454_73466[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73436[(4)]))){
var statearr_73455_73467 = state_73436;
(statearr_73455_73467[(1)] = cljs.core.first.call(null,(state_73436[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73468 = state_73436;
state_73436 = G__73468;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__11469__auto__ = function(state_73436){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__11469__auto____1.call(this,state_73436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__11469__auto____0;
fluree$db$connection$get_socket_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__11469__auto____1;
return fluree$db$connection$get_socket_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73456 = f__11543__auto__.call(null);
(statearr_73456[(6)] = c__11542__auto__);

return statearr_73456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e73469){var e = e73469;
fluree.db.util.log.error.call(null,"Unable to publish message on websocket. Error encoding JSON message: ",message);

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73616){
var state_val_73617 = (state_73616[(1)]);
if((state_val_73617 === (7))){
var inst_73612 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73619_73702 = state_73616__$1;
(statearr_73619_73702[(2)] = inst_73612);

(statearr_73619_73702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (20))){
var _ = (function (){var statearr_73620 = state_73616;
(statearr_73620[(4)] = cljs.core.rest.call(null,(state_73616[(4)])));

return statearr_73620;
})();
var state_73616__$1 = state_73616;
var ex73618 = (state_73616__$1[(2)]);
var statearr_73621_73703 = state_73616__$1;
(statearr_73621_73703[(5)] = ex73618);


var statearr_73622_73704 = state_73616__$1;
(statearr_73622_73704[(1)] = (10));

(statearr_73622_73704[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (27))){
var inst_73514 = (state_73616[(7)]);
var inst_73532 = cljs.core.apply.call(null,cljs.core.hash_map,inst_73514);
var state_73616__$1 = state_73616;
var statearr_73623_73705 = state_73616__$1;
(statearr_73623_73705[(2)] = inst_73532);

(statearr_73623_73705[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (1))){
var inst_73471 = (0);
var state_73616__$1 = (function (){var statearr_73624 = state_73616;
(statearr_73624[(8)] = inst_73471);

return statearr_73624;
})();
var statearr_73625_73706 = state_73616__$1;
(statearr_73625_73706[(2)] = null);

(statearr_73625_73706[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (24))){
var state_73616__$1 = state_73616;
var statearr_73626_73707 = state_73616__$1;
(statearr_73626_73707[(2)] = true);

(statearr_73626_73707[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (39))){
var inst_73602 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73627_73708 = state_73616__$1;
(statearr_73627_73708[(2)] = inst_73602);

(statearr_73627_73708[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (4))){
var inst_73474 = (state_73616[(9)]);
var inst_73474__$1 = (state_73616[(2)]);
var state_73616__$1 = (function (){var statearr_73628 = state_73616;
(statearr_73628[(9)] = inst_73474__$1);

return statearr_73628;
})();
if(cljs.core.truth_(inst_73474__$1)){
var statearr_73629_73709 = state_73616__$1;
(statearr_73629_73709[(1)] = (5));

} else {
var statearr_73630_73710 = state_73616__$1;
(statearr_73630_73710[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (15))){
var inst_73487 = (state_73616[(10)]);
var state_73616__$1 = state_73616;
var statearr_73631_73711 = state_73616__$1;
(statearr_73631_73711[(2)] = inst_73487);

(statearr_73631_73711[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (21))){
var inst_73514 = (state_73616[(7)]);
var inst_73519 = inst_73514.cljs$lang$protocol_mask$partition0$;
var inst_73520 = (inst_73519 & (64));
var inst_73521 = inst_73514.cljs$core$ISeq$;
var inst_73522 = (cljs.core.PROTOCOL_SENTINEL === inst_73521);
var inst_73523 = ((inst_73520) || (inst_73522));
var state_73616__$1 = state_73616;
if(cljs.core.truth_(inst_73523)){
var statearr_73632_73712 = state_73616__$1;
(statearr_73632_73712[(1)] = (24));

} else {
var statearr_73633_73713 = state_73616__$1;
(statearr_73633_73713[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (31))){
var state_73616__$1 = state_73616;
var statearr_73634_73714 = state_73616__$1;
(statearr_73634_73714[(2)] = null);

(statearr_73634_73714[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (32))){
var inst_73511 = (state_73616[(11)]);
var inst_73538 = (state_73616[(12)]);
var inst_73512 = (state_73616[(13)]);
var inst_73576 = (state_73616[(2)]);
var inst_73577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73578 = [inst_73511,inst_73538,inst_73512];
var inst_73579 = (new cljs.core.PersistentVector(null,3,(5),inst_73577,inst_73578,null));
var inst_73580 = publish_fn.call(null,conn,inst_73579);
var state_73616__$1 = (function (){var statearr_73635 = state_73616;
(statearr_73635[(14)] = inst_73576);

return statearr_73635;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73616__$1,(33),inst_73580);
} else {
if((state_val_73617 === (40))){
var inst_73592 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed.");
var state_73616__$1 = state_73616;
var statearr_73636_73715 = state_73616__$1;
(statearr_73636_73715[(2)] = inst_73592);

(statearr_73636_73715[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (33))){
var inst_73582 = (state_73616[(15)]);
var inst_73582__$1 = (state_73616[(2)]);
var inst_73583 = inst_73582__$1 === true;
var state_73616__$1 = (function (){var statearr_73637 = state_73616;
(statearr_73637[(15)] = inst_73582__$1);

return statearr_73637;
})();
if(cljs.core.truth_(inst_73583)){
var statearr_73638_73716 = state_73616__$1;
(statearr_73638_73716[(1)] = (34));

} else {
var statearr_73639_73717 = state_73616__$1;
(statearr_73639_73717[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (13))){
var inst_73487 = (state_73616[(10)]);
var inst_73484 = (state_73616[(2)]);
var inst_73485 = cljs.core.nth.call(null,inst_73484,(0),null);
var inst_73486 = cljs.core.nth.call(null,inst_73484,(1),null);
var inst_73487__$1 = cljs.core.nth.call(null,inst_73484,(2),null);
var state_73616__$1 = (function (){var statearr_73640 = state_73616;
(statearr_73640[(10)] = inst_73487__$1);

(statearr_73640[(16)] = inst_73486);

(statearr_73640[(17)] = inst_73485);

return statearr_73640;
})();
if(cljs.core.truth_(inst_73487__$1)){
var statearr_73641_73718 = state_73616__$1;
(statearr_73641_73718[(1)] = (14));

} else {
var statearr_73642_73719 = state_73616__$1;
(statearr_73642_73719[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (22))){
var state_73616__$1 = state_73616;
var statearr_73643_73720 = state_73616__$1;
(statearr_73643_73720[(2)] = false);

(statearr_73643_73720[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (36))){
var inst_73604 = (state_73616[(2)]);
var _ = (function (){var statearr_73644 = state_73616;
(statearr_73644[(4)] = cljs.core.rest.call(null,(state_73616[(4)])));

return statearr_73644;
})();
var state_73616__$1 = state_73616;
var statearr_73645_73721 = state_73616__$1;
(statearr_73645_73721[(2)] = inst_73604);

(statearr_73645_73721[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (41))){
var state_73616__$1 = state_73616;
var statearr_73646_73722 = state_73616__$1;
(statearr_73646_73722[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (43))){
var inst_73582 = (state_73616[(15)]);
var inst_73595 = fluree.db.util.log.error.call(null,"Error processing message in producer. Socket closed. Published result",inst_73582);
var state_73616__$1 = state_73616;
var statearr_73648_73723 = state_73616__$1;
(statearr_73648_73723[(2)] = inst_73595);

(statearr_73648_73723[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (29))){
var inst_73513 = (state_73616[(18)]);
var inst_73535 = (state_73616[(19)]);
var inst_73535__$1 = (state_73616[(2)]);
var inst_73536 = fluree.db.util.core.random_uuid.call(null);
var inst_73537 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73536);
var inst_73538 = cljs.core.get.call(null,inst_73535__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_73537);
var inst_73539 = cljs.core.get.call(null,inst_73535__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_73616__$1 = (function (){var statearr_73649 = state_73616;
(statearr_73649[(20)] = inst_73539);

(statearr_73649[(12)] = inst_73538);

(statearr_73649[(19)] = inst_73535__$1);

return statearr_73649;
})();
if(cljs.core.truth_(inst_73513)){
var statearr_73650_73724 = state_73616__$1;
(statearr_73650_73724[(1)] = (30));

} else {
var statearr_73651_73725 = state_73616__$1;
(statearr_73651_73725[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (44))){
var state_73616__$1 = state_73616;
var statearr_73652_73726 = state_73616__$1;
(statearr_73652_73726[(2)] = null);

(statearr_73652_73726[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (6))){
var state_73616__$1 = state_73616;
var statearr_73653_73727 = state_73616__$1;
(statearr_73653_73727[(2)] = null);

(statearr_73653_73727[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (28))){
var inst_73514 = (state_73616[(7)]);
var state_73616__$1 = state_73616;
var statearr_73654_73728 = state_73616__$1;
(statearr_73654_73728[(2)] = inst_73514);

(statearr_73654_73728[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (25))){
var state_73616__$1 = state_73616;
var statearr_73655_73729 = state_73616__$1;
(statearr_73655_73729[(2)] = false);

(statearr_73655_73729[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (34))){
var state_73616__$1 = state_73616;
var statearr_73656_73730 = state_73616__$1;
(statearr_73656_73730[(2)] = null);

(statearr_73656_73730[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (17))){
var inst_73487 = (state_73616[(10)]);
var inst_73476 = (state_73616[(21)]);
var inst_73494 = cljs.core.async.put_BANG_.call(null,inst_73487,inst_73476);
var state_73616__$1 = state_73616;
var statearr_73657_73731 = state_73616__$1;
(statearr_73657_73731[(2)] = inst_73494);

(statearr_73657_73731[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (3))){
var inst_73614 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73616__$1,inst_73614);
} else {
if((state_val_73617 === (12))){
var state_73616__$1 = state_73616;
var statearr_73658_73732 = state_73616__$1;
(statearr_73658_73732[(2)] = null);

(statearr_73658_73732[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (2))){
var state_73616__$1 = state_73616;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73616__$1,(4),req_chan);
} else {
if((state_val_73617 === (23))){
var inst_73530 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
if(cljs.core.truth_(inst_73530)){
var statearr_73659_73733 = state_73616__$1;
(statearr_73659_73733[(1)] = (27));

} else {
var statearr_73660_73734 = state_73616__$1;
(statearr_73660_73734[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (35))){
var inst_73582 = (state_73616[(15)]);
var inst_73586 = fluree.db.util.core.exception_QMARK_.call(null,inst_73582);
var state_73616__$1 = state_73616;
if(inst_73586){
var statearr_73661_73735 = state_73616__$1;
(statearr_73661_73735[(1)] = (37));

} else {
var statearr_73662_73736 = state_73616__$1;
(statearr_73662_73736[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (19))){
var inst_73500 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73663_73737 = state_73616__$1;
(statearr_73663_73737[(2)] = inst_73500);

(statearr_73663_73737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (11))){
var inst_73474 = (state_73616[(9)]);
var state_73616__$1 = state_73616;
var statearr_73664_73738 = state_73616__$1;
(statearr_73664_73738[(2)] = inst_73474);

(statearr_73664_73738[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (9))){
var inst_73471 = (state_73616[(8)]);
var inst_73607 = (state_73616[(2)]);
var inst_73608 = (inst_73471 + (1));
var inst_73471__$1 = inst_73608;
var state_73616__$1 = (function (){var statearr_73665 = state_73616;
(statearr_73665[(22)] = inst_73607);

(statearr_73665[(8)] = inst_73471__$1);

return statearr_73665;
})();
var statearr_73666_73739 = state_73616__$1;
(statearr_73666_73739[(2)] = null);

(statearr_73666_73739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (5))){
var state_73616__$1 = state_73616;
var statearr_73667_73740 = state_73616__$1;
(statearr_73667_73740[(2)] = null);

(statearr_73667_73740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (14))){
var inst_73487 = (state_73616[(10)]);
var inst_73489 = fluree.db.util.async.channel_QMARK_.call(null,inst_73487);
var state_73616__$1 = state_73616;
var statearr_73668_73741 = state_73616__$1;
(statearr_73668_73741[(2)] = inst_73489);

(statearr_73668_73741[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (45))){
var inst_73598 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73669_73742 = state_73616__$1;
(statearr_73669_73742[(2)] = inst_73598);

(statearr_73669_73742[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (26))){
var inst_73527 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73670_73743 = state_73616__$1;
(statearr_73670_73743[(2)] = inst_73527);

(statearr_73670_73743[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (16))){
var inst_73492 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
if(cljs.core.truth_(inst_73492)){
var statearr_73671_73744 = state_73616__$1;
(statearr_73671_73744[(1)] = (17));

} else {
var statearr_73672_73745 = state_73616__$1;
(statearr_73672_73745[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (38))){
var inst_73582 = (state_73616[(15)]);
var inst_73590 = (inst_73582 == null);
var state_73616__$1 = state_73616;
if(cljs.core.truth_(inst_73590)){
var statearr_73673_73746 = state_73616__$1;
(statearr_73673_73746[(1)] = (40));

} else {
var statearr_73674_73747 = state_73616__$1;
(statearr_73674_73747[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (30))){
var inst_73513 = (state_73616[(18)]);
var inst_73474 = (state_73616[(9)]);
var inst_73514 = (state_73616[(7)]);
var inst_73539 = (state_73616[(20)]);
var inst_73510 = (state_73616[(23)]);
var inst_73511 = (state_73616[(11)]);
var inst_73471 = (state_73616[(8)]);
var inst_73538 = (state_73616[(12)]);
var inst_73535 = (state_73616[(19)]);
var inst_73512 = (state_73616[(13)]);
var inst_73541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73542 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73538];
var inst_73543 = (new cljs.core.PersistentVector(null,2,(5),inst_73541,inst_73542,null));
var inst_73544 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_73543,inst_73513);
var inst_73571 = cljs.core.async.chan.call(null,(1));
var inst_73572 = (function (){var resp_chan = inst_73513;
var timeout = inst_73539;
var i = inst_73471;
var data = inst_73512;
var _ = inst_73510;
var req_id = inst_73538;
var operation = inst_73511;
var vec__73506 = inst_73474;
var msg = inst_73474;
var c__11542__auto____$1 = inst_73571;
var opts = inst_73514;
var map__73509 = inst_73535;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73569){
var state_val_73570 = (state_73569[(1)]);
if((state_val_73570 === (1))){
var inst_73548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73549 = cljs.core.async.timeout.call(null,timeout);
var inst_73550 = [resp_chan,inst_73549];
var inst_73551 = (new cljs.core.PersistentVector(null,2,(5),inst_73548,inst_73550,null));
var state_73569__$1 = state_73569;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73569__$1,(2),inst_73551);
} else {
if((state_val_73570 === (2))){
var inst_73554 = (state_73569[(7)]);
var inst_73553 = (state_73569[(2)]);
var inst_73554__$1 = cljs.core.nth.call(null,inst_73553,(0),null);
var inst_73555 = cljs.core.nth.call(null,inst_73553,(1),null);
var inst_73556 = (function (){var vec__73545 = inst_73553;
var resp = inst_73554__$1;
var c = inst_73555;
return (function (p1__73470_SHARP_){
return cljs.core.dissoc.call(null,p1__73470_SHARP_,req_id);
});
})();
var inst_73557 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_73556);
var inst_73558 = cljs.core._EQ_.call(null,inst_73555,resp_chan);
var state_73569__$1 = (function (){var statearr_73675 = state_73569;
(statearr_73675[(8)] = inst_73557);

(statearr_73675[(7)] = inst_73554__$1);

return statearr_73675;
})();
if(inst_73558){
var statearr_73676_73748 = state_73569__$1;
(statearr_73676_73748[(1)] = (3));

} else {
var statearr_73677_73749 = state_73569__$1;
(statearr_73677_73749[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73570 === (3))){
var inst_73554 = (state_73569[(7)]);
var state_73569__$1 = state_73569;
var statearr_73678_73750 = state_73569__$1;
(statearr_73678_73750[(2)] = inst_73554);

(statearr_73678_73750[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73570 === (4))){
var inst_73561 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_73562 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_73563 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_73564 = cljs.core.PersistentHashMap.fromArrays(inst_73562,inst_73563);
var inst_73565 = cljs.core.ex_info.call(null,inst_73561,inst_73564);
var state_73569__$1 = state_73569;
var statearr_73679_73751 = state_73569__$1;
(statearr_73679_73751[(2)] = inst_73565);

(statearr_73679_73751[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73570 === (5))){
var inst_73567 = (state_73569[(2)]);
var state_73569__$1 = state_73569;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73569__$1,inst_73567);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11469__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11469__auto____0 = (function (){
var statearr_73680 = [null,null,null,null,null,null,null,null,null];
(statearr_73680[(0)] = fluree$db$connection$msg_producer_$_state_machine__11469__auto__);

(statearr_73680[(1)] = (1));

return statearr_73680;
});
var fluree$db$connection$msg_producer_$_state_machine__11469__auto____1 = (function (state_73569){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73569);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73681){var ex__11472__auto__ = e73681;
var statearr_73682_73752 = state_73569;
(statearr_73682_73752[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73569[(4)]))){
var statearr_73683_73753 = state_73569;
(statearr_73683_73753[(1)] = cljs.core.first.call(null,(state_73569[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73754 = state_73569;
state_73569 = G__73754;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11469__auto__ = function(state_73569){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11469__auto____1.call(this,state_73569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11469__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11469__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73684 = f__11543__auto__.call(null);
(statearr_73684[(6)] = c__11542__auto____$1);

return statearr_73684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_73573 = cljs.core.async.impl.dispatch.run.call(null,inst_73572);
var state_73616__$1 = (function (){var statearr_73685 = state_73616;
(statearr_73685[(24)] = inst_73544);

(statearr_73685[(25)] = inst_73573);

return statearr_73685;
})();
var statearr_73686_73755 = state_73616__$1;
(statearr_73686_73755[(2)] = inst_73571);

(statearr_73686_73755[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (10))){
var inst_73474 = (state_73616[(9)]);
var inst_73476 = (state_73616[(2)]);
var inst_73480 = cljs.core.sequential_QMARK_.call(null,inst_73474);
var state_73616__$1 = (function (){var statearr_73687 = state_73616;
(statearr_73687[(21)] = inst_73476);

return statearr_73687;
})();
if(inst_73480){
var statearr_73688_73756 = state_73616__$1;
(statearr_73688_73756[(1)] = (11));

} else {
var statearr_73689_73757 = state_73616__$1;
(statearr_73689_73757[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (18))){
var inst_73474 = (state_73616[(9)]);
var inst_73476 = (state_73616[(21)]);
var inst_73496 = cljs.core.pr_str.call(null,inst_73474);
var inst_73497 = ["Error processing ledger request, no valid return channel: ",inst_73496].join('');
var inst_73498 = fluree.db.util.log.error.call(null,inst_73476,inst_73497);
var state_73616__$1 = state_73616;
var statearr_73690_73758 = state_73616__$1;
(statearr_73690_73758[(2)] = inst_73498);

(statearr_73690_73758[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (42))){
var inst_73600 = (state_73616[(2)]);
var state_73616__$1 = state_73616;
var statearr_73691_73759 = state_73616__$1;
(statearr_73691_73759[(2)] = inst_73600);

(statearr_73691_73759[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (37))){
var inst_73582 = (state_73616[(15)]);
var inst_73588 = fluree.db.util.log.error.call(null,inst_73582,"Error processing message in producer.");
var state_73616__$1 = state_73616;
var statearr_73692_73760 = state_73616__$1;
(statearr_73692_73760[(2)] = inst_73588);

(statearr_73692_73760[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73617 === (8))){
var inst_73474 = (state_73616[(9)]);
var inst_73514 = (state_73616[(7)]);
var _ = (function (){var statearr_73693 = state_73616;
(statearr_73693[(4)] = cljs.core.cons.call(null,(20),(state_73616[(4)])));

return statearr_73693;
})();
var inst_73510 = fluree.db.util.log.trace.call(null,"Outgoing message to websocket: ",inst_73474);
var inst_73511 = cljs.core.nth.call(null,inst_73474,(0),null);
var inst_73512 = cljs.core.nth.call(null,inst_73474,(1),null);
var inst_73513 = cljs.core.nth.call(null,inst_73474,(2),null);
var inst_73514__$1 = cljs.core.nth.call(null,inst_73474,(3),null);
var inst_73516 = (inst_73514__$1 == null);
var inst_73517 = cljs.core.not.call(null,inst_73516);
var state_73616__$1 = (function (){var statearr_73694 = state_73616;
(statearr_73694[(18)] = inst_73513);

(statearr_73694[(7)] = inst_73514__$1);

(statearr_73694[(23)] = inst_73510);

(statearr_73694[(11)] = inst_73511);

(statearr_73694[(13)] = inst_73512);

return statearr_73694;
})();
if(inst_73517){
var statearr_73695_73761 = state_73616__$1;
(statearr_73695_73761[(1)] = (21));

} else {
var statearr_73696_73762 = state_73616__$1;
(statearr_73696_73762[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__11469__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__11469__auto____0 = (function (){
var statearr_73697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73697[(0)] = fluree$db$connection$msg_producer_$_state_machine__11469__auto__);

(statearr_73697[(1)] = (1));

return statearr_73697;
});
var fluree$db$connection$msg_producer_$_state_machine__11469__auto____1 = (function (state_73616){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73616);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73698){var ex__11472__auto__ = e73698;
var statearr_73699_73763 = state_73616;
(statearr_73699_73763[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73616[(4)]))){
var statearr_73700_73764 = state_73616;
(statearr_73700_73764[(1)] = cljs.core.first.call(null,(state_73616[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73765 = state_73616;
state_73616 = G__73765;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__11469__auto__ = function(state_73616){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__11469__auto____1.call(this,state_73616);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__11469__auto____0;
fluree$db$connection$msg_producer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__11469__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73701 = f__11543__auto__.call(null);
(statearr_73701[(6)] = c__11542__auto__);

return statearr_73701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__73766 = conn;
var map__73766__$1 = (((((!((map__73766 == null))))?(((((map__73766.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73766.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73766):map__73766);
var sub_chan = cljs.core.get.call(null,map__73766__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_73849){
var state_val_73850 = (state_73849[(1)]);
if((state_val_73850 === (7))){
var inst_73845 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73851_73902 = state_73849__$1;
(statearr_73851_73902[(2)] = inst_73845);

(statearr_73851_73902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (20))){
var inst_73786 = (state_73849[(7)]);
var inst_73800 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_73801 = [inst_73786];
var inst_73802 = cljs.core.PersistentHashMap.fromArrays(inst_73800,inst_73801);
var inst_73803 = fluree.db.util.log.warn.call(null,"Unsupported callback registered",inst_73802);
var state_73849__$1 = state_73849;
var statearr_73852_73903 = state_73849__$1;
(statearr_73852_73903[(2)] = inst_73803);

(statearr_73852_73903[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (27))){
var state_73849__$1 = state_73849;
var statearr_73853_73904 = state_73849__$1;
(statearr_73853_73904[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (1))){
var inst_73768 = (0);
var state_73849__$1 = (function (){var statearr_73855 = state_73849;
(statearr_73855[(8)] = inst_73768);

return statearr_73855;
})();
var statearr_73856_73905 = state_73849__$1;
(statearr_73856_73905[(2)] = null);

(statearr_73856_73905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (24))){
var inst_73779 = (state_73849[(9)]);
var inst_73828 = fluree.db.util.core.exception_QMARK_.call(null,inst_73779);
var state_73849__$1 = state_73849;
if(inst_73828){
var statearr_73857_73906 = state_73849__$1;
(statearr_73857_73906[(1)] = (26));

} else {
var statearr_73858_73907 = state_73849__$1;
(statearr_73858_73907[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (4))){
var inst_73773 = (state_73849[(10)]);
var inst_73778 = (state_73849[(2)]);
var inst_73779 = cljs.core.nth.call(null,inst_73778,(0),null);
var inst_73780 = cljs.core.nth.call(null,inst_73778,(1),null);
var inst_73781 = cljs.core._EQ_.call(null,inst_73780,inst_73773);
var state_73849__$1 = (function (){var statearr_73859 = state_73849;
(statearr_73859[(9)] = inst_73779);

return statearr_73859;
})();
if(inst_73781){
var statearr_73860_73908 = state_73849__$1;
(statearr_73860_73908[(1)] = (5));

} else {
var statearr_73861_73909 = state_73849__$1;
(statearr_73861_73909[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (15))){
var inst_73786 = (state_73849[(7)]);
var inst_73795 = typeof inst_73786 === 'string';
var state_73849__$1 = state_73849;
if(cljs.core.truth_(inst_73795)){
var statearr_73862_73910 = state_73849__$1;
(statearr_73862_73910[(1)] = (17));

} else {
var statearr_73863_73911 = state_73849__$1;
(statearr_73863_73911[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (21))){
var state_73849__$1 = state_73849;
var statearr_73864_73912 = state_73849__$1;
(statearr_73864_73912[(2)] = null);

(statearr_73864_73912[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (31))){
var inst_73839 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73865_73913 = state_73849__$1;
(statearr_73865_73913[(2)] = inst_73839);

(statearr_73865_73913[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (13))){
var inst_73812 = (state_73849[(2)]);
var inst_73813 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73814 = fluree.db.connection.close_websocket.call(null,inst_73813);
var inst_73815 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73816 = fluree.db.session.close_all_sessions.call(null,inst_73815);
var state_73849__$1 = (function (){var statearr_73866 = state_73849;
(statearr_73866[(11)] = inst_73812);

(statearr_73866[(12)] = inst_73814);

return statearr_73866;
})();
var statearr_73867_73914 = state_73849__$1;
(statearr_73867_73914[(2)] = inst_73816);

(statearr_73867_73914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (22))){
var inst_73806 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73868_73915 = state_73849__$1;
(statearr_73868_73915[(2)] = inst_73806);

(statearr_73868_73915[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (29))){
var inst_73779 = (state_73849[(9)]);
var inst_73834 = fluree.db.util.json.parse.call(null,inst_73779);
var inst_73835 = fluree.db.conn_events.process_events.call(null,conn,inst_73834);
var inst_73768 = (0);
var state_73849__$1 = (function (){var statearr_73869 = state_73849;
(statearr_73869[(8)] = inst_73768);

(statearr_73869[(13)] = inst_73835);

return statearr_73869;
})();
var statearr_73870_73916 = state_73849__$1;
(statearr_73870_73916[(2)] = null);

(statearr_73870_73916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (6))){
var inst_73779 = (state_73849[(9)]);
var inst_73824 = (inst_73779 == null);
var state_73849__$1 = state_73849;
if(cljs.core.truth_(inst_73824)){
var statearr_73871_73917 = state_73849__$1;
(statearr_73871_73917[(1)] = (23));

} else {
var statearr_73872_73918 = state_73849__$1;
(statearr_73872_73918[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (28))){
var inst_73841 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73873_73919 = state_73849__$1;
(statearr_73873_73919[(2)] = inst_73841);

(statearr_73873_73919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (25))){
var inst_73843 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73874_73920 = state_73849__$1;
(statearr_73874_73920[(2)] = inst_73843);

(statearr_73874_73920[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (17))){
var inst_73786 = (state_73849[(7)]);
var inst_73797 = cljs.core.eval.call(null,inst_73786);
var state_73849__$1 = state_73849;
var statearr_73875_73921 = state_73849__$1;
(statearr_73875_73921[(2)] = inst_73797);

(statearr_73875_73921[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (3))){
var inst_73847 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73849__$1,inst_73847);
} else {
if((state_val_73850 === (12))){
var inst_73786 = (state_73849[(7)]);
var inst_73791 = cljs.core.fn_QMARK_.call(null,inst_73786);
var state_73849__$1 = state_73849;
if(inst_73791){
var statearr_73876_73922 = state_73849__$1;
(statearr_73876_73922[(1)] = (14));

} else {
var statearr_73877_73923 = state_73849__$1;
(statearr_73877_73923[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (2))){
var inst_73773 = (state_73849[(10)]);
var inst_73773__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_73774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73775 = [sub_chan,inst_73773__$1];
var inst_73776 = (new cljs.core.PersistentVector(null,2,(5),inst_73774,inst_73775,null));
var state_73849__$1 = (function (){var statearr_73878 = state_73849;
(statearr_73878[(10)] = inst_73773__$1);

return statearr_73878;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_73849__$1,(4),inst_73776);
} else {
if((state_val_73850 === (23))){
var inst_73826 = fluree.db.util.log.info.call(null,"Connection closed.");
var state_73849__$1 = state_73849;
var statearr_73879_73924 = state_73849__$1;
(statearr_73879_73924[(2)] = inst_73826);

(statearr_73879_73924[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (19))){
var inst_73808 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73880_73925 = state_73849__$1;
(statearr_73880_73925[(2)] = inst_73808);

(statearr_73880_73925[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (11))){
var inst_73789 = fluree.db.util.log.trace.call(null,"No keep-alive callback is registered");
var state_73849__$1 = state_73849;
var statearr_73881_73926 = state_73849__$1;
(statearr_73881_73926[(2)] = inst_73789);

(statearr_73881_73926[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (9))){
var inst_73768 = (state_73849[(8)]);
var inst_73818 = fluree.db.connection.ping_transactor.call(null,conn);
var inst_73819 = (inst_73768 + (1));
var inst_73768__$1 = inst_73819;
var state_73849__$1 = (function (){var statearr_73882 = state_73849;
(statearr_73882[(14)] = inst_73818);

(statearr_73882[(8)] = inst_73768__$1);

return statearr_73882;
})();
var statearr_73883_73927 = state_73849__$1;
(statearr_73883_73927[(2)] = null);

(statearr_73883_73927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (5))){
var inst_73768 = (state_73849[(8)]);
var inst_73783 = cljs.core._EQ_.call(null,(2),inst_73768);
var state_73849__$1 = state_73849;
if(inst_73783){
var statearr_73884_73928 = state_73849__$1;
(statearr_73884_73928[(1)] = (8));

} else {
var statearr_73885_73929 = state_73849__$1;
(statearr_73885_73929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (14))){
var inst_73786 = (state_73849[(7)]);
var inst_73793 = inst_73786.call(null);
var state_73849__$1 = state_73849;
var statearr_73886_73930 = state_73849__$1;
(statearr_73886_73930[(2)] = inst_73793);

(statearr_73886_73930[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (26))){
var inst_73779 = (state_73849[(9)]);
var inst_73830 = fluree.db.util.log.error.call(null,inst_73779);
var inst_73768 = (0);
var state_73849__$1 = (function (){var statearr_73887 = state_73849;
(statearr_73887[(8)] = inst_73768);

(statearr_73887[(15)] = inst_73830);

return statearr_73887;
})();
var statearr_73888_73931 = state_73849__$1;
(statearr_73888_73931[(2)] = null);

(statearr_73888_73931[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (16))){
var inst_73810 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73889_73932 = state_73849__$1;
(statearr_73889_73932[(2)] = inst_73810);

(statearr_73889_73932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (30))){
var state_73849__$1 = state_73849;
var statearr_73890_73933 = state_73849__$1;
(statearr_73890_73933[(2)] = null);

(statearr_73890_73933[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (10))){
var inst_73822 = (state_73849[(2)]);
var state_73849__$1 = state_73849;
var statearr_73891_73934 = state_73849__$1;
(statearr_73891_73934[(2)] = inst_73822);

(statearr_73891_73934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (18))){
var state_73849__$1 = state_73849;
var statearr_73892_73935 = state_73849__$1;
(statearr_73892_73935[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73850 === (8))){
var inst_73786 = (state_73849[(7)]);
var inst_73785 = fluree.db.util.log.warn.call(null,"Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket.");
var inst_73786__$1 = new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581).cljs$core$IFn$_invoke$arity$1(conn);
var inst_73787 = (inst_73786__$1 == null);
var state_73849__$1 = (function (){var statearr_73894 = state_73849;
(statearr_73894[(7)] = inst_73786__$1);

(statearr_73894[(16)] = inst_73785);

return statearr_73894;
})();
if(cljs.core.truth_(inst_73787)){
var statearr_73895_73936 = state_73849__$1;
(statearr_73895_73936[(1)] = (11));

} else {
var statearr_73896_73937 = state_73849__$1;
(statearr_73896_73937[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__11469__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__11469__auto____0 = (function (){
var statearr_73897 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73897[(0)] = fluree$db$connection$msg_consumer_$_state_machine__11469__auto__);

(statearr_73897[(1)] = (1));

return statearr_73897;
});
var fluree$db$connection$msg_consumer_$_state_machine__11469__auto____1 = (function (state_73849){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_73849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e73898){var ex__11472__auto__ = e73898;
var statearr_73899_73938 = state_73849;
(statearr_73899_73938[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_73849[(4)]))){
var statearr_73900_73939 = state_73849;
(statearr_73900_73939[(1)] = cljs.core.first.call(null,(state_73849[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73940 = state_73849;
state_73849 = G__73940;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__11469__auto__ = function(state_73849){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__11469__auto____1.call(this,state_73849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__11469__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__11469__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_73901 = f__11543__auto__.call(null);
(statearr_73901[(6)] = c__11542__auto__);

return statearr_73901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__73942 = arguments.length;
switch (G__73942) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__73943 = opts;
var map__73943__$1 = (((((!((map__73943 == null))))?(((((map__73943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__73943.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__73943):map__73943);
var private$ = cljs.core.get.call(null,map__73943__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__73943__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74006){
var state_val_74007 = (state_74006[(1)]);
if((state_val_74007 === (7))){
var inst_73954 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_73955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73956 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_73957 = (new cljs.core.PersistentVector(null,2,(5),inst_73955,inst_73956,null));
var inst_73958 = cljs.core.get_in.call(null,inst_73954,inst_73957);
var state_74006__$1 = state_74006;
var statearr_74008_74049 = state_74006__$1;
(statearr_74008_74049[(2)] = inst_73958);

(statearr_74008_74049[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (20))){
var inst_73985 = (state_74006[(7)]);
var state_74006__$1 = state_74006;
var statearr_74009_74050 = state_74006__$1;
(statearr_74009_74050[(2)] = inst_73985);

(statearr_74009_74050[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (1))){
var state_74006__$1 = state_74006;
var statearr_74010_74051 = state_74006__$1;
(statearr_74010_74051[(2)] = null);

(statearr_74010_74051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (4))){
var inst_73945 = (state_74006[(2)]);
var state_74006__$1 = state_74006;
var statearr_74011_74052 = state_74006__$1;
(statearr_74011_74052[(2)] = inst_73945);

(statearr_74011_74052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (15))){
var inst_73960 = (state_74006[(8)]);
var inst_73979 = (state_74006[(2)]);
var state_74006__$1 = (function (){var statearr_74012 = state_74006;
(statearr_74012[(9)] = inst_73979);

return statearr_74012;
})();
if(cljs.core.truth_(inst_73960)){
var statearr_74013_74053 = state_74006__$1;
(statearr_74013_74053[(1)] = (16));

} else {
var statearr_74014_74054 = state_74006__$1;
(statearr_74014_74054[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (21))){
var inst_73965 = (state_74006[(10)]);
var inst_73994 = (state_74006[(2)]);
var inst_73995 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_73996 = [(5000),inst_73994,new cljs.core.Keyword(null,"text","text",-1790561697)];
var inst_73997 = cljs.core.PersistentHashMap.fromArrays(inst_73995,inst_73996);
var inst_73998 = fluree.db.util.xhttp.get.call(null,inst_73965,inst_73997);
var state_74006__$1 = state_74006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74006__$1,(22),inst_73998);
} else {
if((state_val_74007 === (13))){
var inst_73974 = (state_74006[(11)]);
var inst_73960 = (state_74006[(8)]);
var inst_73976 = cljs.core.assoc.call(null,inst_73974,"X-fdb-jwt",inst_73960);
var state_74006__$1 = state_74006;
var statearr_74015_74055 = state_74006__$1;
(statearr_74015_74055[(2)] = inst_73976);

(statearr_74015_74055[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (22))){
var inst_74000 = (state_74006[(2)]);
var inst_74001 = fluree.db.util.async.throw_err.call(null,inst_74000);
var _ = (function (){var statearr_74016 = state_74006;
(statearr_74016[(4)] = cljs.core.rest.call(null,(state_74006[(4)])));

return statearr_74016;
})();
var state_74006__$1 = state_74006;
var statearr_74017_74056 = state_74006__$1;
(statearr_74017_74056[(2)] = inst_74001);

(statearr_74017_74056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (6))){
var inst_73951 = (state_74006[(12)]);
var state_74006__$1 = state_74006;
var statearr_74018_74057 = state_74006__$1;
(statearr_74018_74057[(2)] = inst_73951);

(statearr_74018_74057[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (17))){
var inst_73979 = (state_74006[(9)]);
var state_74006__$1 = state_74006;
var statearr_74019_74058 = state_74006__$1;
(statearr_74019_74058[(2)] = inst_73979);

(statearr_74019_74058[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (3))){
var inst_74004 = (state_74006[(2)]);
var state_74006__$1 = state_74006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74006__$1,inst_74004);
} else {
if((state_val_74007 === (12))){
var inst_73960 = (state_74006[(8)]);
var inst_73974 = (state_74006[(2)]);
var state_74006__$1 = (function (){var statearr_74020 = state_74006;
(statearr_74020[(11)] = inst_73974);

return statearr_74020;
})();
if(cljs.core.truth_(inst_73960)){
var statearr_74021_74059 = state_74006__$1;
(statearr_74021_74059[(1)] = (13));

} else {
var statearr_74022_74060 = state_74006__$1;
(statearr_74022_74060[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (2))){
var inst_73951 = (state_74006[(12)]);
var _ = (function (){var statearr_74023 = state_74006;
(statearr_74023[(4)] = cljs.core.cons.call(null,(5),(state_74006[(4)])));

return statearr_74023;
})();
var inst_73951__$1 = jwt;
var state_74006__$1 = (function (){var statearr_74024 = state_74006;
(statearr_74024[(12)] = inst_73951__$1);

return statearr_74024;
})();
if(cljs.core.truth_(inst_73951__$1)){
var statearr_74025_74061 = state_74006__$1;
(statearr_74025_74061[(1)] = (6));

} else {
var statearr_74026_74062 = state_74006__$1;
(statearr_74026_74062[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (19))){
var inst_73985 = (state_74006[(7)]);
var inst_73965 = (state_74006[(10)]);
var inst_73987 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_73988 = [inst_73985];
var inst_73989 = cljs.core.PersistentHashMap.fromArrays(inst_73987,inst_73988);
var inst_73990 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_73965,inst_73989,private$);
var inst_73991 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_73990);
var state_74006__$1 = state_74006;
var statearr_74027_74063 = state_74006__$1;
(statearr_74027_74063[(2)] = inst_73991);

(statearr_74027_74063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (11))){
var inst_73969 = (state_74006[(13)]);
var state_74006__$1 = state_74006;
var statearr_74029_74064 = state_74006__$1;
(statearr_74029_74064[(2)] = inst_73969);

(statearr_74029_74064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (9))){
var inst_73961 = (state_74006[(14)]);
var inst_73964 = (state_74006[(2)]);
var inst_73965 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73964),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73961)].join('');
var inst_73967 = ["Accept"];
var inst_73968 = ["application/json"];
var inst_73969 = cljs.core.PersistentHashMap.fromArrays(inst_73967,inst_73968);
var state_74006__$1 = (function (){var statearr_74030 = state_74006;
(statearr_74030[(10)] = inst_73965);

(statearr_74030[(13)] = inst_73969);

return statearr_74030;
})();
if(cljs.core.truth_(private$)){
var statearr_74031_74065 = state_74006__$1;
(statearr_74031_74065[(1)] = (10));

} else {
var statearr_74032_74066 = state_74006__$1;
(statearr_74032_74066[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (5))){
var _ = (function (){var statearr_74033 = state_74006;
(statearr_74033[(4)] = cljs.core.rest.call(null,(state_74006[(4)])));

return statearr_74033;
})();
var state_74006__$1 = state_74006;
var ex74028 = (state_74006__$1[(2)]);
var statearr_74034_74067 = state_74006__$1;
(statearr_74034_74067[(5)] = ex74028);


if((ex74028 instanceof Error)){
var statearr_74035_74068 = state_74006__$1;
(statearr_74035_74068[(1)] = (4));

(statearr_74035_74068[(5)] = null);

} else {
throw ex74028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (14))){
var inst_73974 = (state_74006[(11)]);
var state_74006__$1 = state_74006;
var statearr_74036_74069 = state_74006__$1;
(statearr_74036_74069[(2)] = inst_73974);

(statearr_74036_74069[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (16))){
var inst_73960 = (state_74006[(8)]);
var inst_73979 = (state_74006[(9)]);
var inst_73981 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73960)].join('');
var inst_73982 = cljs.core.assoc.call(null,inst_73979,"Authorization",inst_73981);
var state_74006__$1 = state_74006;
var statearr_74037_74070 = state_74006__$1;
(statearr_74037_74070[(2)] = inst_73982);

(statearr_74037_74070[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (10))){
var inst_73969 = (state_74006[(13)]);
var inst_73971 = cljs.core.assoc.call(null,inst_73969,"X-fdb-pri",private$);
var state_74006__$1 = state_74006;
var statearr_74038_74071 = state_74006__$1;
(statearr_74038_74071[(2)] = inst_73971);

(statearr_74038_74071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (18))){
var inst_73985 = (state_74006[(2)]);
var state_74006__$1 = (function (){var statearr_74039 = state_74006;
(statearr_74039[(7)] = inst_73985);

return statearr_74039;
})();
if(cljs.core.truth_(private$)){
var statearr_74040_74072 = state_74006__$1;
(statearr_74040_74072[(1)] = (19));

} else {
var statearr_74041_74073 = state_74006__$1;
(statearr_74041_74073[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74007 === (8))){
var inst_73960 = (state_74006[(2)]);
var inst_73961 = clojure.string.replace.call(null,k,"_","/");
var inst_73962 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_74006__$1 = (function (){var statearr_74042 = state_74006;
(statearr_74042[(8)] = inst_73960);

(statearr_74042[(14)] = inst_73961);

return statearr_74042;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74006__$1,(9),inst_73962);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11469__auto__ = null;
var fluree$db$connection$state_machine__11469__auto____0 = (function (){
var statearr_74043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74043[(0)] = fluree$db$connection$state_machine__11469__auto__);

(statearr_74043[(1)] = (1));

return statearr_74043;
});
var fluree$db$connection$state_machine__11469__auto____1 = (function (state_74006){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74044){var ex__11472__auto__ = e74044;
var statearr_74045_74074 = state_74006;
(statearr_74045_74074[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74006[(4)]))){
var statearr_74046_74075 = state_74006;
(statearr_74046_74075[(1)] = cljs.core.first.call(null,(state_74006[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74076 = state_74006;
state_74006 = G__74076;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11469__auto__ = function(state_74006){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11469__auto____1.call(this,state_74006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11469__auto____0;
fluree$db$connection$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11469__auto____1;
return fluree$db$connection$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74047 = f__11543__auto__.call(null);
(statearr_74047[(6)] = c__11542__auto__);

return statearr_74047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5733__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5733__auto__)){
var v = temp__5733__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__74077_SHARP_){
if(cljs.core.truth_(p1__74077_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__74078 = opts;
var map__74078__$1 = (((((!((map__74078 == null))))?(((((map__74078.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__74078.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__74078):map__74078);
var sub_chan = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var publish = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var meta = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var storage_write = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__74078__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__4126__auto__ = object_cache;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.info.call(null,new cljs.core.Keyword(null,"conn-closed","conn-closed",-541764356));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4126__auto__ = storage_read;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4126__auto__ = storage_exists;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = storage_read;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4115__auto__ = storage_write;
if(cljs.core.truth_(and__4115__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return token;
}
}));

return true;
}catch (e74080){var _ = e74080;
return false;
}});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___74113 = arguments.length;
var i__4737__auto___74114 = (0);
while(true){
if((i__4737__auto___74114 < len__4736__auto___74113)){
args__4742__auto__.push((arguments[i__4737__auto___74114]));

var G__74115 = (i__4737__auto___74114 + (1));
i__4737__auto___74114 = G__74115;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__74083){
var vec__74084 = p__74083;
var opts = cljs.core.nth.call(null,vec__74084,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = new cljs.core.Keyword(null,"dev?","dev?",-613971064).cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__11542__auto___74116 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_74101){
var state_val_74102 = (state_74101[(1)]);
if((state_val_74102 === (1))){
var inst_74087 = fluree.db.connection.get_socket.call(null,conn);
var state_74101__$1 = state_74101;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74101__$1,(2),inst_74087);
} else {
if((state_val_74102 === (2))){
var inst_74089 = (state_74101[(2)]);
var inst_74090 = (inst_74089 == null);
var inst_74091 = fluree.db.util.core.exception_QMARK_.call(null,inst_74089);
var inst_74092 = ((inst_74090) || (inst_74091));
var state_74101__$1 = state_74101;
if(cljs.core.truth_(inst_74092)){
var statearr_74103_74117 = state_74101__$1;
(statearr_74103_74117[(1)] = (3));

} else {
var statearr_74104_74118 = state_74101__$1;
(statearr_74104_74118[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74102 === (3))){
var inst_74094 = fluree.db.util.log.warn.call(null,"Cannot establish connection to a healthy server, disconnecting.");
var inst_74095 = cljs.core.async.close_BANG_.call(null,conn);
var state_74101__$1 = (function (){var statearr_74105 = state_74101;
(statearr_74105[(7)] = inst_74094);

return statearr_74105;
})();
var statearr_74106_74119 = state_74101__$1;
(statearr_74106_74119[(2)] = inst_74095);

(statearr_74106_74119[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74102 === (4))){
var inst_74097 = fluree.db.connection.msg_consumer.call(null,conn);
var state_74101__$1 = state_74101;
var statearr_74107_74120 = state_74101__$1;
(statearr_74107_74120[(2)] = inst_74097);

(statearr_74107_74120[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74102 === (5))){
var inst_74099 = (state_74101[(2)]);
var state_74101__$1 = state_74101;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74101__$1,inst_74099);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__11469__auto__ = null;
var fluree$db$connection$state_machine__11469__auto____0 = (function (){
var statearr_74108 = [null,null,null,null,null,null,null,null];
(statearr_74108[(0)] = fluree$db$connection$state_machine__11469__auto__);

(statearr_74108[(1)] = (1));

return statearr_74108;
});
var fluree$db$connection$state_machine__11469__auto____1 = (function (state_74101){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_74101);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e74109){var ex__11472__auto__ = e74109;
var statearr_74110_74121 = state_74101;
(statearr_74110_74121[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_74101[(4)]))){
var statearr_74111_74122 = state_74101;
(statearr_74111_74122[(1)] = cljs.core.first.call(null,(state_74101[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74123 = state_74101;
state_74101 = G__74123;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$connection$state_machine__11469__auto__ = function(state_74101){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__11469__auto____1.call(this,state_74101);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__11469__auto____0;
fluree$db$connection$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__11469__auto____1;
return fluree$db$connection$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_74112 = f__11543__auto__.call(null);
(statearr_74112[(6)] = c__11542__auto___74116);

return statearr_74112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq74081){
var G__74082 = cljs.core.first.call(null,seq74081);
var seq74081__$1 = cljs.core.next.call(null,seq74081);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74082,seq74081__$1);
}));

