// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__34381 = cljs.core.seq.call(null,callbacks);
var chunk__34382 = null;
var count__34383 = (0);
var i__34384 = (0);
while(true){
if((i__34384 < count__34383)){
var vec__34393 = cljs.core._nth.call(null,chunk__34382,i__34384);
var k = cljs.core.nth.call(null,vec__34393,(0),null);
var f = cljs.core.nth.call(null,vec__34393,(1),null);
try{f.call(null,event_type,event_data);
}catch (e34396){var e_34401 = e34396;
fluree.db.util.log.error.call(null,e_34401,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__34402 = seq__34381;
var G__34403 = chunk__34382;
var G__34404 = count__34383;
var G__34405 = (i__34384 + (1));
seq__34381 = G__34402;
chunk__34382 = G__34403;
count__34383 = G__34404;
i__34384 = G__34405;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__34381);
if(temp__5735__auto__){
var seq__34381__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__34381__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__34381__$1);
var G__34406 = cljs.core.chunk_rest.call(null,seq__34381__$1);
var G__34407 = c__4556__auto__;
var G__34408 = cljs.core.count.call(null,c__4556__auto__);
var G__34409 = (0);
seq__34381 = G__34406;
chunk__34382 = G__34407;
count__34383 = G__34408;
i__34384 = G__34409;
continue;
} else {
var vec__34397 = cljs.core.first.call(null,seq__34381__$1);
var k = cljs.core.nth.call(null,vec__34397,(0),null);
var f = cljs.core.nth.call(null,vec__34397,(1),null);
try{f.call(null,event_type,event_data);
}catch (e34400){var e_34410 = e34400;
fluree.db.util.log.error.call(null,e_34410,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__34411 = cljs.core.next.call(null,seq__34381__$1);
var G__34412 = null;
var G__34413 = (0);
var G__34414 = (0);
seq__34381 = G__34411;
chunk__34382 = G__34412;
count__34383 = G__34413;
i__34384 = G__34414;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__34417 = msg;
var event_type = cljs.core.nth.call(null,vec__34417,(0),null);
var subject = cljs.core.nth.call(null,vec__34417,(1),null);
var event_data = cljs.core.nth.call(null,vec__34417,(2),null);
var error_data = cljs.core.nth.call(null,vec__34417,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__34420 = conn;
var map__34420__$1 = (((((!((map__34420 == null))))?(((((map__34420.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34420.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34420):map__34420);
var state = cljs.core.get.call(null,map__34420__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__34422 = event_type__$1;
var G__34422__$1 = (((G__34422 instanceof cljs.core.Keyword))?G__34422.fqn:null);
switch (G__34422__$1) {
case "response":
var temp__5735__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5735__auto__)){
var res_chan = temp__5735__auto__;
cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__34415_SHARP_){
return cljs.core.dissoc.call(null,p1__34415_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__34423 = error_data;
var map__34423__$1 = (((((!((map__34423 == null))))?(((((map__34423.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34423.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34423):map__34423);
var message = cljs.core.get.call(null,map__34423__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e34416){var e = e34416;
return fluree.db.util.log.error.call(null,e);
}});
