// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__70562 = arguments.length;
switch (G__70562) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___70743 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_70669){
var state_val_70670 = (state_70669[(1)]);
if((state_val_70670 === (7))){
var inst_70576 = (state_70669[(7)]);
var inst_70581 = inst_70576.cljs$lang$protocol_mask$partition0$;
var inst_70582 = (inst_70581 & (64));
var inst_70583 = inst_70576.cljs$core$ISeq$;
var inst_70584 = (cljs.core.PROTOCOL_SENTINEL === inst_70583);
var inst_70585 = ((inst_70582) || (inst_70584));
var state_70669__$1 = state_70669;
if(cljs.core.truth_(inst_70585)){
var statearr_70671_70744 = state_70669__$1;
(statearr_70671_70744[(1)] = (10));

} else {
var statearr_70672_70745 = state_70669__$1;
(statearr_70672_70745[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (20))){
var state_70669__$1 = state_70669;
var statearr_70673_70746 = state_70669__$1;
(statearr_70673_70746[(2)] = null);

(statearr_70673_70746[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (27))){
var inst_70624 = (state_70669[(8)]);
var state_70669__$1 = state_70669;
if(cljs.core.truth_(inst_70624)){
var statearr_70674_70747 = state_70669__$1;
(statearr_70674_70747[(1)] = (29));

} else {
var statearr_70675_70748 = state_70669__$1;
(statearr_70675_70748[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (1))){
var state_70669__$1 = state_70669;
var statearr_70676_70749 = state_70669__$1;
(statearr_70676_70749[(2)] = null);

(statearr_70676_70749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (24))){
var inst_70600 = (state_70669[(9)]);
var inst_70614 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70600)," unknown."].join('');
var inst_70615 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70616 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70617 = cljs.core.PersistentHashMap.fromArrays(inst_70615,inst_70616);
var inst_70618 = cljs.core.ex_info.call(null,inst_70614,inst_70617);
var inst_70619 = (function(){throw inst_70618})();
var state_70669__$1 = state_70669;
var statearr_70677_70750 = state_70669__$1;
(statearr_70677_70750[(2)] = inst_70619);

(statearr_70677_70750[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (39))){
var inst_70646 = (state_70669[(2)]);
var inst_70647 = fluree.db.util.async.throw_err.call(null,inst_70646);
var state_70669__$1 = state_70669;
var statearr_70678_70751 = state_70669__$1;
(statearr_70678_70751[(2)] = inst_70647);

(statearr_70678_70751[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (46))){
var inst_70655 = (state_70669[(10)]);
var inst_70658 = (state_70669[(2)]);
var inst_70659 = fluree.db.util.async.throw_err.call(null,inst_70658);
var inst_70660 = cljs.core.assoc.call(null,inst_70655,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70659);
var state_70669__$1 = state_70669;
var statearr_70679_70752 = state_70669__$1;
(statearr_70679_70752[(2)] = inst_70660);

(statearr_70679_70752[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (4))){
var inst_70563 = (state_70669[(2)]);
var inst_70564 = cljs.core.async.put_BANG_.call(null,pc,inst_70563);
var inst_70565 = cljs.core.async.close_BANG_.call(null,pc);
var state_70669__$1 = (function (){var statearr_70680 = state_70669;
(statearr_70680[(11)] = inst_70564);

return statearr_70680;
})();
var statearr_70681_70753 = state_70669__$1;
(statearr_70681_70753[(2)] = inst_70565);

(statearr_70681_70753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (15))){
var inst_70600 = (state_70669[(9)]);
var inst_70597 = (state_70669[(2)]);
var inst_70598 = cljs.core.get.call(null,inst_70597,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_70599 = cljs.core.get.call(null,inst_70597,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_70600__$1 = cljs.core.get.call(null,inst_70597,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70601 = cljs.core.get.call(null,inst_70597,new cljs.core.Keyword(null,"block","block",664686210));
var state_70669__$1 = (function (){var statearr_70682 = state_70669;
(statearr_70682[(12)] = inst_70601);

(statearr_70682[(9)] = inst_70600__$1);

(statearr_70682[(13)] = inst_70598);

(statearr_70682[(14)] = inst_70599);

return statearr_70682;
})();
if(cljs.core.truth_(inst_70600__$1)){
var statearr_70683_70754 = state_70669__$1;
(statearr_70683_70754[(1)] = (16));

} else {
var statearr_70684_70755 = state_70669__$1;
(statearr_70684_70755[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (21))){
var inst_70598 = (state_70669[(13)]);
var inst_70624 = (state_70669[(2)]);
var state_70669__$1 = (function (){var statearr_70685 = state_70669;
(statearr_70685[(8)] = inst_70624);

return statearr_70685;
})();
if(cljs.core.truth_(inst_70598)){
var statearr_70686_70756 = state_70669__$1;
(statearr_70686_70756[(1)] = (26));

} else {
var statearr_70687_70757 = state_70669__$1;
(statearr_70687_70757[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (31))){
var inst_70634 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
var statearr_70688_70758 = state_70669__$1;
(statearr_70688_70758[(2)] = inst_70634);

(statearr_70688_70758[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (32))){
var inst_70630 = (state_70669[(2)]);
var inst_70631 = fluree.db.util.async.throw_err.call(null,inst_70630);
var state_70669__$1 = state_70669;
var statearr_70689_70759 = state_70669__$1;
(statearr_70689_70759[(2)] = inst_70631);

(statearr_70689_70759[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (40))){
var inst_70600 = (state_70669[(9)]);
var inst_70650 = (state_70669[(15)]);
var inst_70652 = cljs.core.assoc.call(null,inst_70650,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70600);
var state_70669__$1 = state_70669;
var statearr_70690_70760 = state_70669__$1;
(statearr_70690_70760[(2)] = inst_70652);

(statearr_70690_70760[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (33))){
var inst_70636 = (state_70669[(16)]);
var inst_70575 = (state_70669[(17)]);
var inst_70638 = fluree.db.permissions.permission_map.call(null,inst_70575,inst_70636,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70669__$1 = state_70669;
var statearr_70691_70761 = state_70669__$1;
(statearr_70691_70761[(2)] = inst_70638);

(statearr_70691_70761[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (13))){
var inst_70576 = (state_70669[(7)]);
var inst_70594 = cljs.core.apply.call(null,cljs.core.hash_map,inst_70576);
var state_70669__$1 = state_70669;
var statearr_70692_70762 = state_70669__$1;
(statearr_70692_70762[(2)] = inst_70594);

(statearr_70692_70762[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (22))){
var inst_70611 = (state_70669[(18)]);
var inst_70610 = (state_70669[(2)]);
var inst_70611__$1 = fluree.db.util.async.throw_err.call(null,inst_70610);
var state_70669__$1 = (function (){var statearr_70693 = state_70669;
(statearr_70693[(18)] = inst_70611__$1);

return statearr_70693;
})();
if(cljs.core.truth_(inst_70611__$1)){
var statearr_70694_70763 = state_70669__$1;
(statearr_70694_70763[(1)] = (23));

} else {
var statearr_70695_70764 = state_70669__$1;
(statearr_70695_70764[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (36))){
var inst_70575 = (state_70669[(17)]);
var inst_70643 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_70644 = fluree.db.time_travel.as_of_block.call(null,inst_70575,inst_70643);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70669__$1,(39),inst_70644);
} else {
if((state_val_70670 === (41))){
var inst_70650 = (state_70669[(15)]);
var state_70669__$1 = state_70669;
var statearr_70696_70765 = state_70669__$1;
(statearr_70696_70765[(2)] = inst_70650);

(statearr_70696_70765[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (43))){
var inst_70641 = (state_70669[(19)]);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70669__$1,(46),inst_70641);
} else {
if((state_val_70670 === (29))){
var inst_70624 = (state_70669[(8)]);
var inst_70575 = (state_70669[(17)]);
var inst_70628 = fluree.db.auth.roles.call(null,inst_70575,inst_70624);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70669__$1,(32),inst_70628);
} else {
if((state_val_70670 === (44))){
var inst_70655 = (state_70669[(10)]);
var state_70669__$1 = state_70669;
var statearr_70697_70766 = state_70669__$1;
(statearr_70697_70766[(2)] = inst_70655);

(statearr_70697_70766[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (6))){
var inst_70576 = (state_70669[(7)]);
var inst_70574 = (state_70669[(2)]);
var inst_70575 = fluree.db.util.async.throw_err.call(null,inst_70574);
var inst_70576__$1 = opts;
var inst_70578 = (inst_70576__$1 == null);
var inst_70579 = cljs.core.not.call(null,inst_70578);
var state_70669__$1 = (function (){var statearr_70698 = state_70669;
(statearr_70698[(17)] = inst_70575);

(statearr_70698[(7)] = inst_70576__$1);

return statearr_70698;
})();
if(inst_70579){
var statearr_70699_70767 = state_70669__$1;
(statearr_70699_70767[(1)] = (7));

} else {
var statearr_70700_70768 = state_70669__$1;
(statearr_70700_70768[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (28))){
var inst_70636 = (state_70669[(16)]);
var inst_70636__$1 = (state_70669[(2)]);
var state_70669__$1 = (function (){var statearr_70701 = state_70669;
(statearr_70701[(16)] = inst_70636__$1);

return statearr_70701;
})();
if(cljs.core.truth_(inst_70636__$1)){
var statearr_70702_70769 = state_70669__$1;
(statearr_70702_70769[(1)] = (33));

} else {
var statearr_70703_70770 = state_70669__$1;
(statearr_70703_70770[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (25))){
var inst_70621 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
var statearr_70704_70771 = state_70669__$1;
(statearr_70704_70771[(2)] = inst_70621);

(statearr_70704_70771[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (34))){
var state_70669__$1 = state_70669;
var statearr_70705_70772 = state_70669__$1;
(statearr_70705_70772[(2)] = null);

(statearr_70705_70772[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (17))){
var inst_70600 = (state_70669[(9)]);
var state_70669__$1 = state_70669;
var statearr_70706_70773 = state_70669__$1;
(statearr_70706_70773[(2)] = inst_70600);

(statearr_70706_70773[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (3))){
var inst_70667 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70669__$1,inst_70667);
} else {
if((state_val_70670 === (12))){
var inst_70589 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
var statearr_70707_70774 = state_70669__$1;
(statearr_70707_70774[(2)] = inst_70589);

(statearr_70707_70774[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (2))){
var _ = (function (){var statearr_70708 = state_70669;
(statearr_70708[(4)] = cljs.core.cons.call(null,(5),(state_70669[(4)])));

return statearr_70708;
})();
var inst_70572 = fluree.db.session.db.call(null,conn,ledger,null);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70669__$1,(6),inst_70572);
} else {
if((state_val_70670 === (23))){
var inst_70611 = (state_70669[(18)]);
var state_70669__$1 = state_70669;
var statearr_70709_70775 = state_70669__$1;
(statearr_70709_70775[(2)] = inst_70611);

(statearr_70709_70775[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (35))){
var inst_70601 = (state_70669[(12)]);
var inst_70641 = (state_70669[(2)]);
var state_70669__$1 = (function (){var statearr_70710 = state_70669;
(statearr_70710[(19)] = inst_70641);

return statearr_70710;
})();
if(cljs.core.truth_(inst_70601)){
var statearr_70711_70776 = state_70669__$1;
(statearr_70711_70776[(1)] = (36));

} else {
var statearr_70712_70777 = state_70669__$1;
(statearr_70712_70777[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (19))){
var inst_70600 = (state_70669[(9)]);
var inst_70575 = (state_70669[(17)]);
var inst_70608 = fluree.db.dbproto._subid.call(null,inst_70575,inst_70600);
var state_70669__$1 = state_70669;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70669__$1,(22),inst_70608);
} else {
if((state_val_70670 === (11))){
var state_70669__$1 = state_70669;
var statearr_70714_70778 = state_70669__$1;
(statearr_70714_70778[(2)] = false);

(statearr_70714_70778[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (9))){
var inst_70592 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
if(cljs.core.truth_(inst_70592)){
var statearr_70715_70779 = state_70669__$1;
(statearr_70715_70779[(1)] = (13));

} else {
var statearr_70716_70780 = state_70669__$1;
(statearr_70716_70780[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (5))){
var _ = (function (){var statearr_70717 = state_70669;
(statearr_70717[(4)] = cljs.core.rest.call(null,(state_70669[(4)])));

return statearr_70717;
})();
var state_70669__$1 = state_70669;
var ex70713 = (state_70669__$1[(2)]);
var statearr_70718_70781 = state_70669__$1;
(statearr_70718_70781[(5)] = ex70713);


var statearr_70719_70782 = state_70669__$1;
(statearr_70719_70782[(1)] = (4));

(statearr_70719_70782[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (14))){
var inst_70576 = (state_70669[(7)]);
var state_70669__$1 = state_70669;
var statearr_70720_70783 = state_70669__$1;
(statearr_70720_70783[(2)] = inst_70576);

(statearr_70720_70783[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (45))){
var inst_70663 = (state_70669[(2)]);
var inst_70664 = cljs.core.async.put_BANG_.call(null,pc,inst_70663);
var _ = (function (){var statearr_70721 = state_70669;
(statearr_70721[(4)] = cljs.core.rest.call(null,(state_70669[(4)])));

return statearr_70721;
})();
var state_70669__$1 = state_70669;
var statearr_70722_70784 = state_70669__$1;
(statearr_70722_70784[(2)] = inst_70664);

(statearr_70722_70784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (26))){
var inst_70598 = (state_70669[(13)]);
var state_70669__$1 = state_70669;
var statearr_70723_70785 = state_70669__$1;
(statearr_70723_70785[(2)] = inst_70598);

(statearr_70723_70785[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (16))){
var inst_70600 = (state_70669[(9)]);
var inst_70603 = cljs.core.not_EQ_.call(null,(0),inst_70600);
var state_70669__$1 = state_70669;
var statearr_70724_70786 = state_70669__$1;
(statearr_70724_70786[(2)] = inst_70603);

(statearr_70724_70786[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (38))){
var inst_70600 = (state_70669[(9)]);
var inst_70650 = (state_70669[(2)]);
var state_70669__$1 = (function (){var statearr_70725 = state_70669;
(statearr_70725[(15)] = inst_70650);

return statearr_70725;
})();
if(cljs.core.truth_(inst_70600)){
var statearr_70726_70787 = state_70669__$1;
(statearr_70726_70787[(1)] = (40));

} else {
var statearr_70727_70788 = state_70669__$1;
(statearr_70727_70788[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (30))){
var state_70669__$1 = state_70669;
var statearr_70728_70789 = state_70669__$1;
(statearr_70728_70789[(2)] = null);

(statearr_70728_70789[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (10))){
var state_70669__$1 = state_70669;
var statearr_70729_70790 = state_70669__$1;
(statearr_70729_70790[(2)] = true);

(statearr_70729_70790[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (18))){
var inst_70606 = (state_70669[(2)]);
var state_70669__$1 = state_70669;
if(cljs.core.truth_(inst_70606)){
var statearr_70730_70791 = state_70669__$1;
(statearr_70730_70791[(1)] = (19));

} else {
var statearr_70731_70792 = state_70669__$1;
(statearr_70731_70792[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (42))){
var inst_70636 = (state_70669[(16)]);
var inst_70655 = (state_70669[(2)]);
var state_70669__$1 = (function (){var statearr_70732 = state_70669;
(statearr_70732[(10)] = inst_70655);

return statearr_70732;
})();
if(cljs.core.truth_(inst_70636)){
var statearr_70733_70793 = state_70669__$1;
(statearr_70733_70793[(1)] = (43));

} else {
var statearr_70734_70794 = state_70669__$1;
(statearr_70734_70794[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (37))){
var inst_70575 = (state_70669[(17)]);
var state_70669__$1 = state_70669;
var statearr_70735_70795 = state_70669__$1;
(statearr_70735_70795[(2)] = inst_70575);

(statearr_70735_70795[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70670 === (8))){
var state_70669__$1 = state_70669;
var statearr_70736_70796 = state_70669__$1;
(statearr_70736_70796[(2)] = false);

(statearr_70736_70796[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__11469__auto__ = null;
var fluree$db$api$query$state_machine__11469__auto____0 = (function (){
var statearr_70737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70737[(0)] = fluree$db$api$query$state_machine__11469__auto__);

(statearr_70737[(1)] = (1));

return statearr_70737;
});
var fluree$db$api$query$state_machine__11469__auto____1 = (function (state_70669){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_70669);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e70738){var ex__11472__auto__ = e70738;
var statearr_70739_70797 = state_70669;
(statearr_70739_70797[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_70669[(4)]))){
var statearr_70740_70798 = state_70669;
(statearr_70740_70798[(1)] = cljs.core.first.call(null,(state_70669[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70799 = state_70669;
state_70669 = G__70799;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__11469__auto__ = function(state_70669){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__11469__auto____1.call(this,state_70669);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__11469__auto____0;
fluree$db$api$query$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__11469__auto____1;
return fluree$db$api$query$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_70741 = f__11543__auto__.call(null);
(statearr_70741[(6)] = c__11542__auto___70743);

return statearr_70741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_70937){
var state_val_70938 = (state_70937[(1)]);
if((state_val_70938 === (7))){
var inst_70820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70821 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70822 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70823 = [inst_70821,inst_70822];
var inst_70824 = (new cljs.core.PersistentVector(null,2,(5),inst_70820,inst_70823,null));
var state_70937__$1 = state_70937;
var statearr_70939_71005 = state_70937__$1;
(statearr_70939_71005[(2)] = inst_70824);

(statearr_70939_71005[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (20))){
var inst_70850 = (state_70937[(7)]);
var state_70937__$1 = state_70937;
var statearr_70940_71006 = state_70937__$1;
(statearr_70940_71006[(2)] = inst_70850);

(statearr_70940_71006[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (27))){
var state_70937__$1 = state_70937;
var statearr_70941_71007 = state_70937__$1;
(statearr_70941_71007[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (1))){
var state_70937__$1 = state_70937;
var statearr_70943_71008 = state_70937__$1;
(statearr_70943_71008[(2)] = null);

(statearr_70943_71008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (24))){
var inst_70849 = (state_70937[(8)]);
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70849)){
var statearr_70944_71009 = state_70937__$1;
(statearr_70944_71009[(1)] = (26));

} else {
var statearr_70945_71010 = state_70937__$1;
(statearr_70945_71010[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (39))){
var inst_70924 = (state_70937[(9)]);
var state_70937__$1 = state_70937;
var statearr_70946_71011 = state_70937__$1;
(statearr_70946_71011[(2)] = inst_70924);

(statearr_70946_71011[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (4))){
var inst_70800 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70947_71012 = state_70937__$1;
(statearr_70947_71012[(2)] = inst_70800);

(statearr_70947_71012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (15))){
var inst_70834 = (state_70937[(10)]);
var inst_70829 = (state_70937[(11)]);
var inst_70843 = (state_70937[(2)]);
var inst_70844 = [inst_70834,inst_70843];
var inst_70845 = (new cljs.core.PersistentVector(null,2,(5),inst_70829,inst_70844,null));
var state_70937__$1 = state_70937;
var statearr_70948_71013 = state_70937__$1;
(statearr_70948_71013[(2)] = inst_70845);

(statearr_70948_71013[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (21))){
var inst_70849 = (state_70937[(8)]);
var state_70937__$1 = state_70937;
var statearr_70949_71014 = state_70937__$1;
(statearr_70949_71014[(2)] = inst_70849);

(statearr_70949_71014[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (31))){
var inst_70890 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70950_71015 = state_70937__$1;
(statearr_70950_71015[(2)] = inst_70890);

(statearr_70950_71015[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (32))){
var inst_70826 = (state_70937[(12)]);
var inst_70902 = cljs.core.pr_str.call(null,inst_70826);
var inst_70903 = ["Invalid block range provided: ",inst_70902].join('');
var inst_70904 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70905 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70906 = cljs.core.PersistentHashMap.fromArrays(inst_70904,inst_70905);
var inst_70907 = cljs.core.ex_info.call(null,inst_70903,inst_70906);
var inst_70908 = (function(){throw inst_70907})();
var state_70937__$1 = state_70937;
var statearr_70951_71016 = state_70937__$1;
(statearr_70951_71016[(2)] = inst_70908);

(statearr_70951_71016[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (40))){
var inst_70923 = (state_70937[(13)]);
var inst_70929 = (state_70937[(2)]);
var inst_70930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70931 = [inst_70923,inst_70929];
var inst_70932 = (new cljs.core.PersistentVector(null,2,(5),inst_70930,inst_70931,null));
var _ = (function (){var statearr_70952 = state_70937;
(statearr_70952[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_70952;
})();
var state_70937__$1 = state_70937;
var statearr_70953_71017 = state_70937__$1;
(statearr_70953_71017[(2)] = inst_70932);

(statearr_70953_71017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (33))){
var state_70937__$1 = state_70937;
var statearr_70954_71018 = state_70937__$1;
(statearr_70954_71018[(2)] = null);

(statearr_70954_71018[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (13))){
var inst_70835 = (state_70937[(14)]);
var inst_70837 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70835);
var state_70937__$1 = state_70937;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70937__$1,(16),inst_70837);
} else {
if((state_val_70938 === (22))){
var inst_70868 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70868)){
var statearr_70955_71019 = state_70937__$1;
(statearr_70955_71019[(1)] = (23));

} else {
var statearr_70956_71020 = state_70937__$1;
(statearr_70956_71020[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (36))){
var inst_70896 = (state_70937[(15)]);
var inst_70895 = (state_70937[(16)]);
var inst_70918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70919 = [inst_70895,inst_70896];
var inst_70920 = (new cljs.core.PersistentVector(null,2,(5),inst_70918,inst_70919,null));
var state_70937__$1 = state_70937;
var statearr_70957_71021 = state_70937__$1;
(statearr_70957_71021[(2)] = inst_70920);

(statearr_70957_71021[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (29))){
var inst_70826 = (state_70937[(12)]);
var inst_70881 = cljs.core.pr_str.call(null,inst_70826);
var inst_70882 = ["Invalid block range provided: ",inst_70881].join('');
var inst_70883 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70884 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70885 = cljs.core.PersistentHashMap.fromArrays(inst_70883,inst_70884);
var inst_70886 = cljs.core.ex_info.call(null,inst_70882,inst_70885);
var inst_70887 = (function(){throw inst_70886})();
var state_70937__$1 = state_70937;
var statearr_70958_71022 = state_70937__$1;
(statearr_70958_71022[(2)] = inst_70887);

(statearr_70958_71022[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (6))){
var inst_70818 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70937__$1 = state_70937;
var statearr_70959_71023 = state_70937__$1;
(statearr_70959_71023[(2)] = inst_70818);

(statearr_70959_71023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (28))){
var inst_70892 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70960_71024 = state_70937__$1;
(statearr_70960_71024[(2)] = inst_70892);

(statearr_70960_71024[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (25))){
var inst_70896 = (state_70937[(15)]);
var inst_70895 = (state_70937[(16)]);
var inst_70894 = (state_70937[(2)]);
var inst_70895__$1 = cljs.core.nth.call(null,inst_70894,(0),null);
var inst_70896__$1 = cljs.core.nth.call(null,inst_70894,(1),null);
var inst_70897 = cljs.core.pos_int_QMARK_.call(null,inst_70895__$1);
var inst_70898 = cljs.core.pos_int_QMARK_.call(null,inst_70896__$1);
var inst_70899 = ((inst_70897) && (inst_70898));
var inst_70900 = cljs.core.not.call(null,inst_70899);
var state_70937__$1 = (function (){var statearr_70961 = state_70937;
(statearr_70961[(15)] = inst_70896__$1);

(statearr_70961[(16)] = inst_70895__$1);

return statearr_70961;
})();
if(inst_70900){
var statearr_70962_71025 = state_70937__$1;
(statearr_70962_71025[(1)] = (32));

} else {
var statearr_70963_71026 = state_70937__$1;
(statearr_70963_71026[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (34))){
var inst_70896 = (state_70937[(15)]);
var inst_70895 = (state_70937[(16)]);
var inst_70911 = (state_70937[(2)]);
var inst_70912 = (inst_70896 < inst_70895);
var state_70937__$1 = (function (){var statearr_70964 = state_70937;
(statearr_70964[(17)] = inst_70911);

return statearr_70964;
})();
if(cljs.core.truth_(inst_70912)){
var statearr_70965_71027 = state_70937__$1;
(statearr_70965_71027[(1)] = (35));

} else {
var statearr_70966_71028 = state_70937__$1;
(statearr_70966_71028[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (17))){
var inst_70851 = (state_70937[(18)]);
var inst_70849 = (state_70937[(8)]);
var inst_70854 = cljs.core.pr_str.call(null,inst_70849);
var inst_70855 = cljs.core.pr_str.call(null,inst_70851);
var inst_70856 = ["Start block is out of range for this ledger. Start block provided: ",inst_70854,". Database block: ",inst_70855].join('');
var inst_70857 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70858 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70859 = cljs.core.PersistentHashMap.fromArrays(inst_70857,inst_70858);
var inst_70860 = cljs.core.ex_info.call(null,inst_70856,inst_70859);
var inst_70861 = (function(){throw inst_70860})();
var state_70937__$1 = state_70937;
var statearr_70967_71029 = state_70937__$1;
(statearr_70967_71029[(2)] = inst_70861);

(statearr_70967_71029[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (3))){
var inst_70935 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70937__$1,inst_70935);
} else {
if((state_val_70938 === (12))){
var inst_70826 = (state_70937[(12)]);
var inst_70835 = (state_70937[(14)]);
var inst_70833 = (state_70937[(2)]);
var inst_70834 = fluree.db.util.async.throw_err.call(null,inst_70833);
var inst_70835__$1 = cljs.core.second.call(null,inst_70826);
var state_70937__$1 = (function (){var statearr_70968 = state_70937;
(statearr_70968[(10)] = inst_70834);

(statearr_70968[(14)] = inst_70835__$1);

return statearr_70968;
})();
if(cljs.core.truth_(inst_70835__$1)){
var statearr_70969_71030 = state_70937__$1;
(statearr_70969_71030[(1)] = (13));

} else {
var statearr_70970_71031 = state_70937__$1;
(statearr_70970_71031[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (2))){
var _ = (function (){var statearr_70971 = state_70937;
(statearr_70971[(4)] = cljs.core.cons.call(null,(5),(state_70937[(4)])));

return statearr_70971;
})();
var inst_70815 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70816 = cljs.core.sequential_QMARK_.call(null,inst_70815);
var state_70937__$1 = state_70937;
if(inst_70816){
var statearr_70972_71032 = state_70937__$1;
(statearr_70972_71032[(1)] = (6));

} else {
var statearr_70973_71033 = state_70937__$1;
(statearr_70973_71033[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (23))){
var inst_70850 = (state_70937[(7)]);
var inst_70849 = (state_70937[(8)]);
var inst_70870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70871 = [inst_70849,inst_70850];
var inst_70872 = (new cljs.core.PersistentVector(null,2,(5),inst_70870,inst_70871,null));
var state_70937__$1 = state_70937;
var statearr_70974_71034 = state_70937__$1;
(statearr_70974_71034[(2)] = inst_70872);

(statearr_70974_71034[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (35))){
var inst_70896 = (state_70937[(15)]);
var inst_70895 = (state_70937[(16)]);
var inst_70914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70915 = [inst_70896,inst_70895];
var inst_70916 = (new cljs.core.PersistentVector(null,2,(5),inst_70914,inst_70915,null));
var state_70937__$1 = state_70937;
var statearr_70975_71035 = state_70937__$1;
(statearr_70975_71035[(2)] = inst_70916);

(statearr_70975_71035[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (19))){
var inst_70849 = (state_70937[(8)]);
var inst_70864 = (state_70937[(2)]);
var state_70937__$1 = (function (){var statearr_70976 = state_70937;
(statearr_70976[(19)] = inst_70864);

return statearr_70976;
})();
if(cljs.core.truth_(inst_70849)){
var statearr_70977_71036 = state_70937__$1;
(statearr_70977_71036[(1)] = (20));

} else {
var statearr_70978_71037 = state_70937__$1;
(statearr_70978_71037[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (11))){
var inst_70851 = (state_70937[(18)]);
var inst_70849 = (state_70937[(8)]);
var inst_70848 = (state_70937[(2)]);
var inst_70849__$1 = cljs.core.nth.call(null,inst_70848,(0),null);
var inst_70850 = cljs.core.nth.call(null,inst_70848,(1),null);
var inst_70851__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70852 = (inst_70849__$1 > inst_70851__$1);
var state_70937__$1 = (function (){var statearr_70980 = state_70937;
(statearr_70980[(7)] = inst_70850);

(statearr_70980[(18)] = inst_70851__$1);

(statearr_70980[(8)] = inst_70849__$1);

return statearr_70980;
})();
if(cljs.core.truth_(inst_70852)){
var statearr_70981_71038 = state_70937__$1;
(statearr_70981_71038[(1)] = (17));

} else {
var statearr_70982_71039 = state_70937__$1;
(statearr_70982_71039[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (9))){
var inst_70826 = (state_70937[(12)]);
var inst_70829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70830 = cljs.core.first.call(null,inst_70826);
var inst_70831 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70830);
var state_70937__$1 = (function (){var statearr_70983 = state_70937;
(statearr_70983[(11)] = inst_70829);

return statearr_70983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70937__$1,(12),inst_70831);
} else {
if((state_val_70938 === (5))){
var _ = (function (){var statearr_70984 = state_70937;
(statearr_70984[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_70984;
})();
var state_70937__$1 = state_70937;
var ex70979 = (state_70937__$1[(2)]);
var statearr_70985_71040 = state_70937__$1;
(statearr_70985_71040[(5)] = ex70979);


if((ex70979 instanceof Error)){
var statearr_70986_71041 = state_70937__$1;
(statearr_70986_71041[(1)] = (4));

(statearr_70986_71041[(5)] = null);

} else {
throw ex70979;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (14))){
var state_70937__$1 = state_70937;
var statearr_70987_71042 = state_70937__$1;
(statearr_70987_71042[(2)] = null);

(statearr_70987_71042[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (26))){
var inst_70849 = (state_70937[(8)]);
var inst_70875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70876 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70877 = [inst_70849,inst_70876];
var inst_70878 = (new cljs.core.PersistentVector(null,2,(5),inst_70875,inst_70877,null));
var state_70937__$1 = state_70937;
var statearr_70988_71043 = state_70937__$1;
(statearr_70988_71043[(2)] = inst_70878);

(statearr_70988_71043[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (16))){
var inst_70839 = (state_70937[(2)]);
var inst_70840 = fluree.db.util.async.throw_err.call(null,inst_70839);
var state_70937__$1 = state_70937;
var statearr_70989_71044 = state_70937__$1;
(statearr_70989_71044[(2)] = inst_70840);

(statearr_70989_71044[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (38))){
var inst_70851 = (state_70937[(18)]);
var state_70937__$1 = state_70937;
var statearr_70990_71045 = state_70937__$1;
(statearr_70990_71045[(2)] = inst_70851);

(statearr_70990_71045[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (30))){
var state_70937__$1 = state_70937;
var statearr_70991_71046 = state_70937__$1;
(statearr_70991_71046[(2)] = null);

(statearr_70991_71046[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (10))){
var inst_70826 = (state_70937[(12)]);
var state_70937__$1 = state_70937;
var statearr_70992_71047 = state_70937__$1;
(statearr_70992_71047[(2)] = inst_70826);

(statearr_70992_71047[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (18))){
var state_70937__$1 = state_70937;
var statearr_70993_71048 = state_70937__$1;
(statearr_70993_71048[(2)] = null);

(statearr_70993_71048[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (37))){
var inst_70851 = (state_70937[(18)]);
var inst_70924 = (state_70937[(9)]);
var inst_70922 = (state_70937[(2)]);
var inst_70923 = cljs.core.nth.call(null,inst_70922,(0),null);
var inst_70924__$1 = cljs.core.nth.call(null,inst_70922,(1),null);
var inst_70925 = (inst_70924__$1 > inst_70851);
var state_70937__$1 = (function (){var statearr_70994 = state_70937;
(statearr_70994[(9)] = inst_70924__$1);

(statearr_70994[(13)] = inst_70923);

return statearr_70994;
})();
if(cljs.core.truth_(inst_70925)){
var statearr_70995_71049 = state_70937__$1;
(statearr_70995_71049[(1)] = (38));

} else {
var statearr_70996_71050 = state_70937__$1;
(statearr_70996_71050[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (8))){
var inst_70826 = (state_70937[(12)]);
var inst_70826__$1 = (state_70937[(2)]);
var inst_70827 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_70826__$1);
var state_70937__$1 = (function (){var statearr_70997 = state_70937;
(statearr_70997[(12)] = inst_70826__$1);

return statearr_70997;
})();
if(cljs.core.truth_(inst_70827)){
var statearr_70998_71051 = state_70937__$1;
(statearr_70998_71051[(1)] = (9));

} else {
var statearr_70999_71052 = state_70937__$1;
(statearr_70999_71052[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____0 = (function (){
var statearr_71000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71000[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__);

(statearr_71000[(1)] = (1));

return statearr_71000;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____1 = (function (state_70937){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_70937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71001){var ex__11472__auto__ = e71001;
var statearr_71002_71053 = state_70937;
(statearr_71002_71053[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_70937[(4)]))){
var statearr_71003_71054 = state_70937;
(statearr_71003_71054[(1)] = cljs.core.first.call(null,(state_70937[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71055 = state_70937;
state_70937 = G__71055;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__ = function(state_70937){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____1.call(this,state_70937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71004 = f__11543__auto__.call(null);
(statearr_71004[(6)] = c__11542__auto__);

return statearr_71004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71205){
var state_val_71206 = (state_71205[(1)]);
if((state_val_71206 === (7))){
var inst_71117 = (state_71205[(2)]);
var inst_71118 = cljs.core.nth.call(null,inst_71117,(0),null);
var inst_71119 = cljs.core.nth.call(null,inst_71117,(1),null);
var inst_71127 = cljs.core.vals.call(null,inst_71119);
var inst_71128 = cljs.core.seq.call(null,inst_71127);
var inst_71129 = cljs.core.first.call(null,inst_71128);
var inst_71130 = cljs.core.next.call(null,inst_71128);
var inst_71131 = cljs.core.PersistentVector.EMPTY;
var inst_71132 = inst_71127;
var inst_71133 = inst_71131;
var state_71205__$1 = (function (){var statearr_71207 = state_71205;
(statearr_71207[(7)] = inst_71130);

(statearr_71207[(8)] = inst_71129);

(statearr_71207[(9)] = inst_71132);

(statearr_71207[(10)] = inst_71133);

(statearr_71207[(11)] = inst_71118);

return statearr_71207;
})();
var statearr_71208_71261 = state_71205__$1;
(statearr_71208_71261[(2)] = null);

(statearr_71208_71261[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (20))){
var inst_71139 = (state_71205[(12)]);
var inst_71144 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71145 = cljs.core.PersistentHashMap.EMPTY;
var inst_71146 = [true,inst_71145];
var inst_71147 = cljs.core.PersistentHashMap.fromArrays(inst_71144,inst_71146);
var inst_71148 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_71147,inst_71139);
var state_71205__$1 = state_71205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71205__$1,(22),inst_71148);
} else {
if((state_val_71206 === (27))){
var inst_71193 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71209_71262 = state_71205__$1;
(statearr_71209_71262[(2)] = inst_71193);

(statearr_71209_71262[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (1))){
var state_71205__$1 = state_71205;
var statearr_71210_71263 = state_71205__$1;
(statearr_71210_71263[(2)] = null);

(statearr_71210_71263[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (24))){
var inst_71157 = (state_71205[(13)]);
var inst_71195 = (state_71205[(2)]);
var inst_71196 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_71197 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71198 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71199 = [inst_71197,inst_71198,inst_71157,inst_71195];
var inst_71200 = cljs.core.PersistentHashMap.fromArrays(inst_71196,inst_71199);
var _ = (function (){var statearr_71212 = state_71205;
(statearr_71212[(4)] = cljs.core.rest.call(null,(state_71205[(4)])));

return statearr_71212;
})();
var state_71205__$1 = state_71205;
var statearr_71213_71264 = state_71205__$1;
(statearr_71213_71264[(2)] = inst_71200);

(statearr_71213_71264[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (4))){
var inst_71058 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71214_71265 = state_71205__$1;
(statearr_71214_71265[(2)] = inst_71058);

(statearr_71214_71265[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (15))){
var inst_71088 = (state_71205[(14)]);
var inst_71103 = (state_71205[(15)]);
var inst_71080 = (state_71205[(16)]);
var inst_71096 = (state_71205[(17)]);
var inst_71074 = (state_71205[(18)]);
var inst_71081 = (state_71205[(19)]);
var inst_71098 = (state_71205[(20)]);
var inst_71089 = (state_71205[(21)]);
var inst_71077 = (state_71205[(22)]);
var inst_71082 = (state_71205[(23)]);
var inst_71076 = (state_71205[(24)]);
var inst_71109 = (function (){var vec__71084 = inst_71080;
var subject = inst_71096;
var flake = inst_71088;
var r = inst_71089;
var asserted_subjects = inst_71081;
var seq__71072 = inst_71077;
var flake_SINGLEQUOTE_ = inst_71103;
var retracted_subjects = inst_71082;
var G__71070 = inst_71080;
var seq__71085 = inst_71089;
var asserted_QMARK_ = inst_71098;
var first__71073 = inst_71076;
var vec__71071 = inst_71074;
var first__71086 = inst_71088;
return (function (p1__71057_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__71057_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71110 = cljs.core.update.call(null,inst_71082,inst_71096,inst_71109);
var tmp71211 = inst_71081;
var inst_71080__$1 = inst_71089;
var inst_71081__$1 = tmp71211;
var inst_71082__$1 = inst_71110;
var state_71205__$1 = (function (){var statearr_71215 = state_71205;
(statearr_71215[(16)] = inst_71080__$1);

(statearr_71215[(19)] = inst_71081__$1);

(statearr_71215[(23)] = inst_71082__$1);

return statearr_71215;
})();
var statearr_71216_71266 = state_71205__$1;
(statearr_71216_71266[(2)] = null);

(statearr_71216_71266[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (21))){
var inst_71155 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71217_71267 = state_71205__$1;
(statearr_71217_71267[(2)] = inst_71155);

(statearr_71217_71267[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (13))){
var inst_71098 = (state_71205[(20)]);
var inst_71103 = (state_71205[(2)]);
var state_71205__$1 = (function (){var statearr_71218 = state_71205;
(statearr_71218[(15)] = inst_71103);

return statearr_71218;
})();
if(cljs.core.truth_(inst_71098)){
var statearr_71219_71268 = state_71205__$1;
(statearr_71219_71268[(1)] = (14));

} else {
var statearr_71220_71269 = state_71205__$1;
(statearr_71220_71269[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (22))){
var inst_71140 = (state_71205[(25)]);
var inst_71133 = (state_71205[(10)]);
var inst_71150 = (state_71205[(2)]);
var inst_71151 = fluree.db.util.async.throw_err.call(null,inst_71150);
var inst_71152 = cljs.core.conj.call(null,inst_71133,inst_71151);
var inst_71132 = inst_71140;
var inst_71133__$1 = inst_71152;
var state_71205__$1 = (function (){var statearr_71221 = state_71205;
(statearr_71221[(9)] = inst_71132);

(statearr_71221[(10)] = inst_71133__$1);

return statearr_71221;
})();
var statearr_71222_71270 = state_71205__$1;
(statearr_71222_71270[(2)] = null);

(statearr_71222_71270[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (6))){
var inst_71088 = (state_71205[(14)]);
var inst_71080 = (state_71205[(16)]);
var inst_71087 = cljs.core.seq.call(null,inst_71080);
var inst_71088__$1 = cljs.core.first.call(null,inst_71087);
var inst_71089 = cljs.core.next.call(null,inst_71087);
var inst_71090 = cljs.core.not.call(null,inst_71088__$1);
var state_71205__$1 = (function (){var statearr_71223 = state_71205;
(statearr_71223[(14)] = inst_71088__$1);

(statearr_71223[(21)] = inst_71089);

return statearr_71223;
})();
if(inst_71090){
var statearr_71224_71271 = state_71205__$1;
(statearr_71224_71271[(1)] = (8));

} else {
var statearr_71225_71272 = state_71205__$1;
(statearr_71225_71272[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (28))){
var inst_71178 = (state_71205[(26)]);
var inst_71171 = (state_71205[(27)]);
var inst_71188 = (state_71205[(2)]);
var inst_71189 = fluree.db.util.async.throw_err.call(null,inst_71188);
var inst_71190 = cljs.core.conj.call(null,inst_71171,inst_71189);
var inst_71170 = inst_71178;
var inst_71171__$1 = inst_71190;
var state_71205__$1 = (function (){var statearr_71226 = state_71205;
(statearr_71226[(27)] = inst_71171__$1);

(statearr_71226[(28)] = inst_71170);

return statearr_71226;
})();
var statearr_71227_71273 = state_71205__$1;
(statearr_71227_71273[(2)] = null);

(statearr_71227_71273[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (25))){
var inst_71171 = (state_71205[(27)]);
var state_71205__$1 = state_71205;
var statearr_71228_71274 = state_71205__$1;
(statearr_71228_71274[(2)] = inst_71171);

(statearr_71228_71274[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (17))){
var inst_71132 = (state_71205[(9)]);
var inst_71139 = (state_71205[(12)]);
var inst_71138 = cljs.core.seq.call(null,inst_71132);
var inst_71139__$1 = cljs.core.first.call(null,inst_71138);
var inst_71140 = cljs.core.next.call(null,inst_71138);
var inst_71141 = cljs.core.not.call(null,inst_71139__$1);
var state_71205__$1 = (function (){var statearr_71229 = state_71205;
(statearr_71229[(25)] = inst_71140);

(statearr_71229[(12)] = inst_71139__$1);

return statearr_71229;
})();
if(inst_71141){
var statearr_71230_71275 = state_71205__$1;
(statearr_71230_71275[(1)] = (19));

} else {
var statearr_71231_71276 = state_71205__$1;
(statearr_71231_71276[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (3))){
var inst_71203 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71205__$1,inst_71203);
} else {
if((state_val_71206 === (12))){
var inst_71088 = (state_71205[(14)]);
var inst_71101 = fluree.db.flake.flip_flake.call(null,inst_71088);
var state_71205__$1 = state_71205;
var statearr_71232_71277 = state_71205__$1;
(statearr_71232_71277[(2)] = inst_71101);

(statearr_71232_71277[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (2))){
var inst_71074 = (state_71205[(18)]);
var _ = (function (){var statearr_71233 = state_71205;
(statearr_71233[(4)] = cljs.core.cons.call(null,(5),(state_71205[(4)])));

return statearr_71233;
})();
var inst_71074__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_71075 = cljs.core.seq.call(null,inst_71074__$1);
var inst_71076 = cljs.core.first.call(null,inst_71075);
var inst_71077 = cljs.core.next.call(null,inst_71075);
var inst_71078 = cljs.core.PersistentHashMap.EMPTY;
var inst_71079 = cljs.core.PersistentHashMap.EMPTY;
var inst_71080 = inst_71074__$1;
var inst_71081 = inst_71078;
var inst_71082 = inst_71079;
var state_71205__$1 = (function (){var statearr_71234 = state_71205;
(statearr_71234[(16)] = inst_71080);

(statearr_71234[(18)] = inst_71074__$1);

(statearr_71234[(19)] = inst_71081);

(statearr_71234[(22)] = inst_71077);

(statearr_71234[(23)] = inst_71082);

(statearr_71234[(24)] = inst_71076);

return statearr_71234;
})();
var statearr_71235_71278 = state_71205__$1;
(statearr_71235_71278[(2)] = null);

(statearr_71235_71278[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (23))){
var inst_71177 = (state_71205[(29)]);
var inst_71170 = (state_71205[(28)]);
var inst_71176 = cljs.core.seq.call(null,inst_71170);
var inst_71177__$1 = cljs.core.first.call(null,inst_71176);
var inst_71178 = cljs.core.next.call(null,inst_71176);
var inst_71179 = cljs.core.not.call(null,inst_71177__$1);
var state_71205__$1 = (function (){var statearr_71236 = state_71205;
(statearr_71236[(26)] = inst_71178);

(statearr_71236[(29)] = inst_71177__$1);

return statearr_71236;
})();
if(inst_71179){
var statearr_71237_71279 = state_71205__$1;
(statearr_71237_71279[(1)] = (25));

} else {
var statearr_71238_71280 = state_71205__$1;
(statearr_71238_71280[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (19))){
var inst_71133 = (state_71205[(10)]);
var state_71205__$1 = state_71205;
var statearr_71239_71281 = state_71205__$1;
(statearr_71239_71281[(2)] = inst_71133);

(statearr_71239_71281[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (11))){
var inst_71088 = (state_71205[(14)]);
var state_71205__$1 = state_71205;
var statearr_71241_71282 = state_71205__$1;
(statearr_71241_71282[(2)] = inst_71088);

(statearr_71241_71282[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (9))){
var inst_71088 = (state_71205[(14)]);
var inst_71098 = (state_71205[(20)]);
var inst_71096 = inst_71088.s;
var inst_71097 = inst_71088.op;
var inst_71098__$1 = inst_71097 === true;
var state_71205__$1 = (function (){var statearr_71243 = state_71205;
(statearr_71243[(17)] = inst_71096);

(statearr_71243[(20)] = inst_71098__$1);

return statearr_71243;
})();
if(cljs.core.truth_(inst_71098__$1)){
var statearr_71244_71283 = state_71205__$1;
(statearr_71244_71283[(1)] = (11));

} else {
var statearr_71245_71284 = state_71205__$1;
(statearr_71245_71284[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (5))){
var _ = (function (){var statearr_71246 = state_71205;
(statearr_71246[(4)] = cljs.core.rest.call(null,(state_71205[(4)])));

return statearr_71246;
})();
var state_71205__$1 = state_71205;
var ex71240 = (state_71205__$1[(2)]);
var statearr_71247_71285 = state_71205__$1;
(statearr_71247_71285[(5)] = ex71240);


if((ex71240 instanceof Error)){
var statearr_71248_71286 = state_71205__$1;
(statearr_71248_71286[(1)] = (4));

(statearr_71248_71286[(5)] = null);

} else {
throw ex71240;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (14))){
var inst_71088 = (state_71205[(14)]);
var inst_71103 = (state_71205[(15)]);
var inst_71080 = (state_71205[(16)]);
var inst_71096 = (state_71205[(17)]);
var inst_71074 = (state_71205[(18)]);
var inst_71081 = (state_71205[(19)]);
var inst_71098 = (state_71205[(20)]);
var inst_71089 = (state_71205[(21)]);
var inst_71077 = (state_71205[(22)]);
var inst_71082 = (state_71205[(23)]);
var inst_71076 = (state_71205[(24)]);
var inst_71105 = (function (){var vec__71084 = inst_71080;
var subject = inst_71096;
var flake = inst_71088;
var r = inst_71089;
var asserted_subjects = inst_71081;
var seq__71072 = inst_71077;
var flake_SINGLEQUOTE_ = inst_71103;
var retracted_subjects = inst_71082;
var G__71070 = inst_71080;
var seq__71085 = inst_71089;
var asserted_QMARK_ = inst_71098;
var first__71073 = inst_71076;
var vec__71071 = inst_71074;
var first__71086 = inst_71088;
return (function (p1__71056_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__71056_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_71106 = cljs.core.update.call(null,inst_71081,inst_71096,inst_71105);
var tmp71242 = inst_71082;
var inst_71080__$1 = inst_71089;
var inst_71081__$1 = inst_71106;
var inst_71082__$1 = tmp71242;
var state_71205__$1 = (function (){var statearr_71249 = state_71205;
(statearr_71249[(16)] = inst_71080__$1);

(statearr_71249[(19)] = inst_71081__$1);

(statearr_71249[(23)] = inst_71082__$1);

return statearr_71249;
})();
var statearr_71250_71287 = state_71205__$1;
(statearr_71250_71287[(2)] = null);

(statearr_71250_71287[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (26))){
var inst_71177 = (state_71205[(29)]);
var inst_71182 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_71183 = cljs.core.PersistentHashMap.EMPTY;
var inst_71184 = [true,inst_71183];
var inst_71185 = cljs.core.PersistentHashMap.fromArrays(inst_71182,inst_71184);
var inst_71186 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_71185,inst_71177);
var state_71205__$1 = state_71205;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71205__$1,(28),inst_71186);
} else {
if((state_val_71206 === (16))){
var inst_71113 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71251_71288 = state_71205__$1;
(statearr_71251_71288[(2)] = inst_71113);

(statearr_71251_71288[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (10))){
var inst_71115 = (state_71205[(2)]);
var state_71205__$1 = state_71205;
var statearr_71252_71289 = state_71205__$1;
(statearr_71252_71289[(2)] = inst_71115);

(statearr_71252_71289[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (18))){
var inst_71118 = (state_71205[(11)]);
var inst_71157 = (state_71205[(2)]);
var inst_71165 = cljs.core.vals.call(null,inst_71118);
var inst_71166 = cljs.core.seq.call(null,inst_71165);
var inst_71167 = cljs.core.first.call(null,inst_71166);
var inst_71168 = cljs.core.next.call(null,inst_71166);
var inst_71169 = cljs.core.PersistentVector.EMPTY;
var inst_71170 = inst_71165;
var inst_71171 = inst_71169;
var state_71205__$1 = (function (){var statearr_71253 = state_71205;
(statearr_71253[(27)] = inst_71171);

(statearr_71253[(13)] = inst_71157);

(statearr_71253[(28)] = inst_71170);

(statearr_71253[(30)] = inst_71168);

(statearr_71253[(31)] = inst_71167);

return statearr_71253;
})();
var statearr_71254_71290 = state_71205__$1;
(statearr_71254_71290[(2)] = null);

(statearr_71254_71290[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71206 === (8))){
var inst_71081 = (state_71205[(19)]);
var inst_71082 = (state_71205[(23)]);
var inst_71092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71093 = [inst_71081,inst_71082];
var inst_71094 = (new cljs.core.PersistentVector(null,2,(5),inst_71092,inst_71093,null));
var state_71205__$1 = state_71205;
var statearr_71255_71291 = state_71205__$1;
(statearr_71255_71291[(2)] = inst_71094);

(statearr_71255_71291[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____0 = (function (){
var statearr_71256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71256[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__);

(statearr_71256[(1)] = (1));

return statearr_71256;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____1 = (function (state_71205){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71205);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71257){var ex__11472__auto__ = e71257;
var statearr_71258_71292 = state_71205;
(statearr_71258_71292[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71205[(4)]))){
var statearr_71259_71293 = state_71205;
(statearr_71259_71293[(1)] = cljs.core.first.call(null,(state_71205[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71294 = state_71205;
state_71205 = G__71294;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__ = function(state_71205){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____1.call(this,state_71205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71260 = f__11543__auto__.call(null);
(statearr_71260[(6)] = c__11542__auto__);

return statearr_71260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71326){
var state_val_71327 = (state_71326[(1)]);
if((state_val_71327 === (1))){
var inst_71295 = cljs.core.volatile_BANG_.call(null,(0));
var inst_71296 = cljs.core.PersistentHashMap.EMPTY;
var inst_71297 = cljs.core.volatile_BANG_.call(null,inst_71296);
var inst_71298 = cljs.core.first.call(null,resp);
var inst_71299 = cljs.core.rest.call(null,resp);
var inst_71300 = cljs.core.PersistentVector.EMPTY;
var inst_71301 = inst_71295;
var inst_71302 = inst_71297;
var inst_71303 = inst_71298;
var inst_71304 = inst_71299;
var inst_71305 = inst_71300;
var state_71326__$1 = (function (){var statearr_71328 = state_71326;
(statearr_71328[(7)] = inst_71304);

(statearr_71328[(8)] = inst_71301);

(statearr_71328[(9)] = inst_71302);

(statearr_71328[(10)] = inst_71305);

(statearr_71328[(11)] = inst_71303);

return statearr_71328;
})();
var statearr_71329_71344 = state_71326__$1;
(statearr_71329_71344[(2)] = null);

(statearr_71329_71344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71327 === (2))){
var inst_71301 = (state_71326[(8)]);
var inst_71302 = (state_71326[(9)]);
var inst_71303 = (state_71326[(11)]);
var inst_71307 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_71303,inst_71302,inst_71301);
var state_71326__$1 = state_71326;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71326__$1,(4),inst_71307);
} else {
if((state_val_71327 === (3))){
var inst_71324 = (state_71326[(2)]);
var state_71326__$1 = state_71326;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71326__$1,inst_71324);
} else {
if((state_val_71327 === (4))){
var inst_71304 = (state_71326[(7)]);
var inst_71305 = (state_71326[(10)]);
var inst_71309 = (state_71326[(2)]);
var inst_71310 = fluree.db.util.async.throw_err.call(null,inst_71309);
var inst_71311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71312 = [inst_71310];
var inst_71313 = (new cljs.core.PersistentVector(null,1,(5),inst_71311,inst_71312,null));
var inst_71314 = cljs.core.concat.call(null,inst_71305,inst_71313);
var inst_71315 = cljs.core.first.call(null,inst_71304);
var state_71326__$1 = (function (){var statearr_71332 = state_71326;
(statearr_71332[(12)] = inst_71314);

return statearr_71332;
})();
if(cljs.core.truth_(inst_71315)){
var statearr_71333_71345 = state_71326__$1;
(statearr_71333_71345[(1)] = (5));

} else {
var statearr_71334_71346 = state_71326__$1;
(statearr_71334_71346[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71327 === (5))){
var inst_71314 = (state_71326[(12)]);
var inst_71304 = (state_71326[(7)]);
var inst_71301 = (state_71326[(8)]);
var inst_71302 = (state_71326[(9)]);
var inst_71317 = cljs.core.first.call(null,inst_71304);
var inst_71318 = cljs.core.rest.call(null,inst_71304);
var tmp71330 = inst_71301;
var tmp71331 = inst_71302;
var inst_71301__$1 = tmp71330;
var inst_71302__$1 = tmp71331;
var inst_71303 = inst_71317;
var inst_71304__$1 = inst_71318;
var inst_71305 = inst_71314;
var state_71326__$1 = (function (){var statearr_71335 = state_71326;
(statearr_71335[(7)] = inst_71304__$1);

(statearr_71335[(8)] = inst_71301__$1);

(statearr_71335[(9)] = inst_71302__$1);

(statearr_71335[(10)] = inst_71305);

(statearr_71335[(11)] = inst_71303);

return statearr_71335;
})();
var statearr_71336_71347 = state_71326__$1;
(statearr_71336_71347[(2)] = null);

(statearr_71336_71347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71327 === (6))){
var inst_71314 = (state_71326[(12)]);
var state_71326__$1 = state_71326;
var statearr_71337_71348 = state_71326__$1;
(statearr_71337_71348[(2)] = inst_71314);

(statearr_71337_71348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71327 === (7))){
var inst_71322 = (state_71326[(2)]);
var state_71326__$1 = state_71326;
var statearr_71338_71349 = state_71326__$1;
(statearr_71338_71349[(2)] = inst_71322);

(statearr_71338_71349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____0 = (function (){
var statearr_71339 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71339[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__);

(statearr_71339[(1)] = (1));

return statearr_71339;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____1 = (function (state_71326){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71326);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71340){var ex__11472__auto__ = e71340;
var statearr_71341_71350 = state_71326;
(statearr_71341_71350[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71326[(4)]))){
var statearr_71342_71351 = state_71326;
(statearr_71342_71351[(1)] = cljs.core.first.call(null,(state_71326[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71352 = state_71326;
state_71326 = G__71352;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__ = function(state_71326){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____1.call(this,state_71326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71343 = f__11543__auto__.call(null);
(statearr_71343[(6)] = c__11542__auto__);

return statearr_71343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__71355 = arguments.length;
switch (G__71355) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__71357){
var map__71358 = p__71357;
var map__71358__$1 = (((((!((map__71358 == null))))?(((((map__71358.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71358.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71358):map__71358);
var query = map__71358__$1;
var opts = cljs.core.get.call(null,map__71358__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71444){
var state_val_71445 = (state_71444[(1)]);
if((state_val_71445 === (7))){
var inst_71370 = (state_71444[(7)]);
var inst_71374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71375 = ["_auth/id",inst_71370];
var inst_71376 = (new cljs.core.PersistentVector(null,2,(5),inst_71374,inst_71375,null));
var state_71444__$1 = state_71444;
var statearr_71446_71490 = state_71444__$1;
(statearr_71446_71490[(2)] = inst_71376);

(statearr_71446_71490[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (20))){
var inst_71424 = (state_71444[(2)]);
var inst_71425 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71444__$1 = (function (){var statearr_71447 = state_71444;
(statearr_71447[(8)] = inst_71424);

return statearr_71447;
})();
if(cljs.core.truth_(inst_71425)){
var statearr_71448_71491 = state_71444__$1;
(statearr_71448_71491[(1)] = (22));

} else {
var statearr_71449_71492 = state_71444__$1;
(statearr_71449_71492[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (27))){
var inst_71427 = (state_71444[(9)]);
var inst_71371 = (state_71444[(10)]);
var inst_71433 = (state_71444[(2)]);
var inst_71434 = fluree.db.api.query.response_time_formatted.call(null,inst_71371);
var inst_71435 = [(200),inst_71433,(100),inst_71434];
var inst_71436 = cljs.core.PersistentHashMap.fromArrays(inst_71427,inst_71435);
var state_71444__$1 = state_71444;
var statearr_71450_71493 = state_71444__$1;
(statearr_71450_71493[(2)] = inst_71436);

(statearr_71450_71493[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (1))){
var state_71444__$1 = state_71444;
var statearr_71451_71494 = state_71444__$1;
(statearr_71451_71494[(2)] = null);

(statearr_71451_71494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (24))){
var inst_71439 = (state_71444[(2)]);
var _ = (function (){var statearr_71452 = state_71444;
(statearr_71452[(4)] = cljs.core.rest.call(null,(state_71444[(4)])));

return statearr_71452;
})();
var state_71444__$1 = state_71444;
var statearr_71453_71495 = state_71444__$1;
(statearr_71453_71495[(2)] = inst_71439);

(statearr_71453_71495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (4))){
var inst_71360 = (state_71444[(2)]);
var state_71444__$1 = state_71444;
var statearr_71454_71496 = state_71444__$1;
(statearr_71454_71496[(2)] = inst_71360);

(statearr_71454_71496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (15))){
var inst_71411 = (state_71444[(11)]);
var state_71444__$1 = state_71444;
var statearr_71455_71497 = state_71444__$1;
(statearr_71455_71497[(2)] = inst_71411);

(statearr_71455_71497[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (21))){
var inst_71420 = (state_71444[(2)]);
var inst_71421 = fluree.db.util.async.throw_err.call(null,inst_71420);
var state_71444__$1 = state_71444;
var statearr_71456_71498 = state_71444__$1;
(statearr_71456_71498[(2)] = inst_71421);

(statearr_71456_71498[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (13))){
var inst_71369 = (state_71444[(12)]);
var inst_71411 = (state_71444[(11)]);
var inst_71410 = (state_71444[(2)]);
var inst_71411__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_71369);
var state_71444__$1 = (function (){var statearr_71457 = state_71444;
(statearr_71457[(13)] = inst_71410);

(statearr_71457[(11)] = inst_71411__$1);

return statearr_71457;
})();
if(cljs.core.truth_(inst_71411__$1)){
var statearr_71458_71499 = state_71444__$1;
(statearr_71458_71499[(1)] = (15));

} else {
var statearr_71459_71500 = state_71444__$1;
(statearr_71459_71500[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (22))){
var inst_71424 = (state_71444[(8)]);
var inst_71427 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71428 = cljs.core.sequential_QMARK_.call(null,inst_71424);
var state_71444__$1 = (function (){var statearr_71460 = state_71444;
(statearr_71460[(9)] = inst_71427);

return statearr_71460;
})();
if(inst_71428){
var statearr_71461_71501 = state_71444__$1;
(statearr_71461_71501[(1)] = (25));

} else {
var statearr_71462_71502 = state_71444__$1;
(statearr_71462_71502[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (6))){
var inst_71369 = (state_71444[(12)]);
var inst_71385 = (state_71444[(14)]);
var inst_71384 = (state_71444[(2)]);
var inst_71385__$1 = fluree.db.util.async.throw_err.call(null,inst_71384);
var inst_71386 = fluree.db.api.query.resolve_block_range.call(null,inst_71385__$1,inst_71369);
var state_71444__$1 = (function (){var statearr_71463 = state_71444;
(statearr_71463[(14)] = inst_71385__$1);

return statearr_71463;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71444__$1,(10),inst_71386);
} else {
if((state_val_71445 === (25))){
var inst_71424 = (state_71444[(8)]);
var inst_71430 = cljs.core.doall.call(null,inst_71424);
var state_71444__$1 = state_71444;
var statearr_71464_71503 = state_71444__$1;
(statearr_71464_71503[(2)] = inst_71430);

(statearr_71464_71503[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (17))){
var inst_71416 = (state_71444[(2)]);
var state_71444__$1 = state_71444;
if(cljs.core.truth_(inst_71416)){
var statearr_71465_71504 = state_71444__$1;
(statearr_71465_71504[(1)] = (18));

} else {
var statearr_71466_71505 = state_71444__$1;
(statearr_71466_71505[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (3))){
var inst_71442 = (state_71444[(2)]);
var state_71444__$1 = state_71444;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71444__$1,inst_71442);
} else {
if((state_val_71445 === (12))){
var inst_71369 = (state_71444[(12)]);
var inst_71402 = cljs.core.pr_str.call(null,inst_71369);
var inst_71403 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_71402].join('');
var inst_71404 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71405 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71406 = cljs.core.PersistentHashMap.fromArrays(inst_71404,inst_71405);
var inst_71407 = cljs.core.ex_info.call(null,inst_71403,inst_71406);
var inst_71408 = (function(){throw inst_71407})();
var state_71444__$1 = state_71444;
var statearr_71467_71506 = state_71444__$1;
(statearr_71467_71506[(2)] = inst_71408);

(statearr_71467_71506[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (2))){
var inst_71370 = (state_71444[(7)]);
var _ = (function (){var statearr_71468 = state_71444;
(statearr_71468[(4)] = cljs.core.cons.call(null,(5),(state_71444[(4)])));

return statearr_71468;
})();
var inst_71369 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_71370__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71371 = fluree.db.util.core.current_time_millis.call(null);
var inst_71372 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_71444__$1 = (function (){var statearr_71469 = state_71444;
(statearr_71469[(7)] = inst_71370__$1);

(statearr_71469[(10)] = inst_71371);

(statearr_71469[(12)] = inst_71369);

(statearr_71469[(15)] = inst_71372);

return statearr_71469;
})();
if(cljs.core.truth_(inst_71370__$1)){
var statearr_71470_71507 = state_71444__$1;
(statearr_71470_71507[(1)] = (7));

} else {
var statearr_71471_71508 = state_71444__$1;
(statearr_71471_71508[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (23))){
var inst_71424 = (state_71444[(8)]);
var state_71444__$1 = state_71444;
var statearr_71472_71509 = state_71444__$1;
(statearr_71472_71509[(2)] = inst_71424);

(statearr_71472_71509[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (19))){
var inst_71410 = (state_71444[(13)]);
var state_71444__$1 = state_71444;
var statearr_71473_71510 = state_71444__$1;
(statearr_71473_71510[(2)] = inst_71410);

(statearr_71473_71510[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (11))){
var inst_71390 = (state_71444[(16)]);
var inst_71391 = (state_71444[(17)]);
var inst_71385 = (state_71444[(14)]);
var inst_71397 = fluree.db.api.query.block_range.call(null,inst_71385,inst_71390,inst_71391,opts);
var state_71444__$1 = state_71444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71444__$1,(14),inst_71397);
} else {
if((state_val_71445 === (9))){
var inst_71372 = (state_71444[(15)]);
var inst_71379 = (state_71444[(2)]);
var inst_71380 = [inst_71379];
var inst_71381 = cljs.core.PersistentHashMap.fromArrays(inst_71372,inst_71380);
var inst_71382 = fluree.db.api.query.db.call(null,conn,ledger,inst_71381);
var state_71444__$1 = state_71444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71444__$1,(6),inst_71382);
} else {
if((state_val_71445 === (5))){
var _ = (function (){var statearr_71475 = state_71444;
(statearr_71475[(4)] = cljs.core.rest.call(null,(state_71444[(4)])));

return statearr_71475;
})();
var state_71444__$1 = state_71444;
var ex71474 = (state_71444__$1[(2)]);
var statearr_71476_71511 = state_71444__$1;
(statearr_71476_71511[(5)] = ex71474);


if((ex71474 instanceof Error)){
var statearr_71477_71512 = state_71444__$1;
(statearr_71477_71512[(1)] = (4));

(statearr_71477_71512[(5)] = null);

} else {
throw ex71474;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (14))){
var inst_71399 = (state_71444[(2)]);
var inst_71400 = fluree.db.util.async.throw_err.call(null,inst_71399);
var state_71444__$1 = state_71444;
var statearr_71478_71513 = state_71444__$1;
(statearr_71478_71513[(2)] = inst_71400);

(statearr_71478_71513[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (26))){
var inst_71424 = (state_71444[(8)]);
var state_71444__$1 = state_71444;
var statearr_71479_71514 = state_71444__$1;
(statearr_71479_71514[(2)] = inst_71424);

(statearr_71479_71514[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (16))){
var inst_71369 = (state_71444[(12)]);
var inst_71414 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_71369);
var state_71444__$1 = state_71444;
var statearr_71480_71515 = state_71444__$1;
(statearr_71480_71515[(2)] = inst_71414);

(statearr_71480_71515[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (10))){
var inst_71369 = (state_71444[(12)]);
var inst_71388 = (state_71444[(2)]);
var inst_71389 = fluree.db.util.async.throw_err.call(null,inst_71388);
var inst_71390 = cljs.core.nth.call(null,inst_71389,(0),null);
var inst_71391 = cljs.core.nth.call(null,inst_71389,(1),null);
var inst_71392 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_71393 = cljs.core.dissoc.call(null,inst_71369,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71394 = cljs.core.keys.call(null,inst_71393);
var inst_71395 = cljs.core._EQ_.call(null,inst_71392,inst_71394);
var state_71444__$1 = (function (){var statearr_71481 = state_71444;
(statearr_71481[(16)] = inst_71390);

(statearr_71481[(17)] = inst_71391);

return statearr_71481;
})();
if(inst_71395){
var statearr_71482_71516 = state_71444__$1;
(statearr_71482_71516[(1)] = (11));

} else {
var statearr_71483_71517 = state_71444__$1;
(statearr_71483_71517[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71445 === (18))){
var inst_71410 = (state_71444[(13)]);
var inst_71385 = (state_71444[(14)]);
var inst_71418 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_71385,inst_71410);
var state_71444__$1 = state_71444;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71444__$1,(21),inst_71418);
} else {
if((state_val_71445 === (8))){
var state_71444__$1 = state_71444;
var statearr_71484_71518 = state_71444__$1;
(statearr_71484_71518[(2)] = null);

(statearr_71484_71518[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__11469__auto____0 = (function (){
var statearr_71485 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71485[(0)] = fluree$db$api$query$block_query_async_$_state_machine__11469__auto__);

(statearr_71485[(1)] = (1));

return statearr_71485;
});
var fluree$db$api$query$block_query_async_$_state_machine__11469__auto____1 = (function (state_71444){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71444);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71486){var ex__11472__auto__ = e71486;
var statearr_71487_71519 = state_71444;
(statearr_71487_71519[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71444[(4)]))){
var statearr_71488_71520 = state_71444;
(statearr_71488_71520[(1)] = cljs.core.first.call(null,(state_71444[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71521 = state_71444;
state_71444 = G__71521;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__11469__auto__ = function(state_71444){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__11469__auto____1.call(this,state_71444);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__11469__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__11469__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71489 = f__11543__auto__.call(null);
(statearr_71489[(6)] = c__11542__auto__);

return statearr_71489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__71522 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__71522,(0),null);
var p = cljs.core.nth.call(null,vec__71522,(1),null);
var o = cljs.core.nth.call(null,vec__71522,(2),null);
var t = cljs.core.nth.call(null,vec__71522,(3),null);
var vec__71525 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__71525,(0),null);
var idx = cljs.core.nth.call(null,vec__71525,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__71528 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__71528,(0),null);
var id = cljs.core.nth.call(null,vec__71528,(1),null);
var or__4126__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___71532 = arguments.length;
var i__4737__auto___71533 = (0);
while(true){
if((i__4737__auto___71533 < len__4736__auto___71532)){
args__4742__auto__.push((arguments[i__4737__auto___71533]));

var G__71534 = (i__4737__auto___71533 + (1));
i__4737__auto___71533 = G__71534;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq71531){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq71531));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71750){
var state_val_71751 = (state_71750[(1)]);
if((state_val_71751 === (7))){
var inst_71657 = (state_71750[(7)]);
var inst_71650 = (state_71750[(8)]);
var inst_71656 = cljs.core.seq.call(null,inst_71650);
var inst_71657__$1 = cljs.core.first.call(null,inst_71656);
var inst_71658 = cljs.core.next.call(null,inst_71656);
var state_71750__$1 = (function (){var statearr_71752 = state_71750;
(statearr_71752[(9)] = inst_71658);

(statearr_71752[(7)] = inst_71657__$1);

return statearr_71752;
})();
if(cljs.core.truth_(inst_71657__$1)){
var statearr_71753_71866 = state_71750__$1;
(statearr_71753_71866[(1)] = (9));

} else {
var statearr_71754_71867 = state_71750__$1;
(statearr_71754_71867[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (20))){
var inst_71740 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71755_71868 = state_71750__$1;
(statearr_71755_71868[(2)] = inst_71740);

(statearr_71755_71868[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (27))){
var inst_71676 = (state_71750[(10)]);
var inst_71694 = cljs.core.apply.call(null,cljs.core.hash_map,inst_71676);
var state_71750__$1 = state_71750;
var statearr_71756_71869 = state_71750__$1;
(statearr_71756_71869[(2)] = inst_71694);

(statearr_71756_71869[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (1))){
var state_71750__$1 = state_71750;
var statearr_71757_71870 = state_71750__$1;
(statearr_71757_71870[(2)] = null);

(statearr_71757_71870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (24))){
var state_71750__$1 = state_71750;
var statearr_71758_71871 = state_71750__$1;
(statearr_71758_71871[(2)] = true);

(statearr_71758_71871[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (39))){
var inst_71699 = (state_71750[(11)]);
var inst_71698 = (state_71750[(12)]);
var inst_71724 = (state_71750[(13)]);
var inst_71726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71727 = [inst_71698,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71728 = (new cljs.core.PersistentVector(null,2,(5),inst_71726,inst_71727,null));
var inst_71729 = cljs.core.assoc_in.call(null,inst_71724,inst_71728,inst_71699);
var state_71750__$1 = state_71750;
var statearr_71760_71872 = state_71750__$1;
(statearr_71760_71872[(2)] = inst_71729);

(statearr_71760_71872[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (4))){
var inst_71536 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71761_71873 = state_71750__$1;
(statearr_71761_71873[(2)] = inst_71536);

(statearr_71761_71873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (15))){
var inst_71651 = (state_71750[(14)]);
var inst_71658 = (state_71750[(9)]);
var tmp71759 = inst_71651;
var inst_71650 = inst_71658;
var inst_71651__$1 = tmp71759;
var state_71750__$1 = (function (){var statearr_71762 = state_71750;
(statearr_71762[(14)] = inst_71651__$1);

(statearr_71762[(8)] = inst_71650);

return statearr_71762;
})();
var statearr_71763_71874 = state_71750__$1;
(statearr_71763_71874[(2)] = null);

(statearr_71763_71874[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (21))){
var inst_71676 = (state_71750[(10)]);
var inst_71681 = inst_71676.cljs$lang$protocol_mask$partition0$;
var inst_71682 = (inst_71681 & (64));
var inst_71683 = inst_71676.cljs$core$ISeq$;
var inst_71684 = (cljs.core.PROTOCOL_SENTINEL === inst_71683);
var inst_71685 = ((inst_71682) || (inst_71684));
var state_71750__$1 = state_71750;
if(cljs.core.truth_(inst_71685)){
var statearr_71764_71875 = state_71750__$1;
(statearr_71764_71875[(1)] = (24));

} else {
var statearr_71765_71876 = state_71750__$1;
(statearr_71765_71876[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (31))){
var inst_71651 = (state_71750[(14)]);
var state_71750__$1 = state_71750;
var statearr_71766_71877 = state_71750__$1;
(statearr_71766_71877[(2)] = inst_71651);

(statearr_71766_71877[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (32))){
var inst_71708 = (state_71750[(2)]);
var state_71750__$1 = (function (){var statearr_71767 = state_71750;
(statearr_71767[(15)] = inst_71708);

return statearr_71767;
})();
var statearr_71768_71878 = state_71750__$1;
(statearr_71768_71878[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (40))){
var inst_71724 = (state_71750[(13)]);
var state_71750__$1 = state_71750;
var statearr_71770_71879 = state_71750__$1;
(statearr_71770_71879[(2)] = inst_71724);

(statearr_71770_71879[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (33))){
var inst_71657 = (state_71750[(7)]);
var inst_71708 = (state_71750[(15)]);
var inst_71698 = (state_71750[(12)]);
var inst_71710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71711 = [inst_71698,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_71712 = (new cljs.core.PersistentVector(null,2,(5),inst_71710,inst_71711,null));
var inst_71713 = cljs.core.update_in.call(null,inst_71708,inst_71712,cljs.core.conj,inst_71657);
var state_71750__$1 = state_71750;
var statearr_71771_71880 = state_71750__$1;
(statearr_71771_71880[(2)] = inst_71713);

(statearr_71771_71880[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (13))){
var inst_71660 = (state_71750[(16)]);
var state_71750__$1 = state_71750;
var statearr_71772_71881 = state_71750__$1;
(statearr_71772_71881[(2)] = inst_71660);

(statearr_71772_71881[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (22))){
var state_71750__$1 = state_71750;
var statearr_71773_71882 = state_71750__$1;
(statearr_71773_71882[(2)] = false);

(statearr_71773_71882[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (36))){
var inst_71675 = (state_71750[(17)]);
var inst_71716 = (state_71750[(18)]);
var inst_71698 = (state_71750[(12)]);
var inst_71718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71719 = [inst_71698,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_71720 = (new cljs.core.PersistentVector(null,2,(5),inst_71718,inst_71719,null));
var inst_71721 = cljs.core.update_in.call(null,inst_71716,inst_71720,fluree.db.api.query.min_safe,inst_71675);
var state_71750__$1 = state_71750;
var statearr_71774_71883 = state_71750__$1;
(statearr_71774_71883[(2)] = inst_71721);

(statearr_71774_71883[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (41))){
var inst_71658 = (state_71750[(9)]);
var inst_71732 = (state_71750[(2)]);
var inst_71650 = inst_71658;
var inst_71651 = inst_71732;
var state_71750__$1 = (function (){var statearr_71775 = state_71750;
(statearr_71775[(14)] = inst_71651);

(statearr_71775[(8)] = inst_71650);

return statearr_71775;
})();
var statearr_71776_71884 = state_71750__$1;
(statearr_71776_71884[(2)] = null);

(statearr_71776_71884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (43))){
var state_71750__$1 = state_71750;
var statearr_71777_71885 = state_71750__$1;
(statearr_71777_71885[(2)] = null);

(statearr_71777_71885[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (29))){
var inst_71697 = (state_71750[(2)]);
var inst_71698 = cljs.core.get.call(null,inst_71697,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71699 = cljs.core.get.call(null,inst_71697,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_71750__$1 = (function (){var statearr_71778 = state_71750;
(statearr_71778[(11)] = inst_71699);

(statearr_71778[(12)] = inst_71698);

return statearr_71778;
})();
var statearr_71779_71886 = state_71750__$1;
(statearr_71779_71886[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (44))){
var inst_71738 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71781_71887 = state_71750__$1;
(statearr_71781_71887[(2)] = inst_71738);

(statearr_71781_71887[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (6))){
var inst_71636 = (state_71750[(2)]);
var inst_71637 = fluree.db.util.async.throw_err.call(null,inst_71636);
var inst_71645 = resp;
var inst_71646 = cljs.core.seq.call(null,inst_71645);
var inst_71647 = cljs.core.first.call(null,inst_71646);
var inst_71648 = cljs.core.next.call(null,inst_71646);
var inst_71649 = cljs.core.PersistentHashMap.EMPTY;
var inst_71650 = inst_71645;
var inst_71651 = inst_71649;
var state_71750__$1 = (function (){var statearr_71782 = state_71750;
(statearr_71782[(19)] = inst_71647);

(statearr_71782[(14)] = inst_71651);

(statearr_71782[(8)] = inst_71650);

(statearr_71782[(20)] = inst_71648);

(statearr_71782[(21)] = inst_71637);

return statearr_71782;
})();
var statearr_71783_71888 = state_71750__$1;
(statearr_71783_71888[(2)] = null);

(statearr_71783_71888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (28))){
var inst_71676 = (state_71750[(10)]);
var state_71750__$1 = state_71750;
var statearr_71784_71889 = state_71750__$1;
(statearr_71784_71889[(2)] = inst_71676);

(statearr_71784_71889[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (25))){
var state_71750__$1 = state_71750;
var statearr_71785_71890 = state_71750__$1;
(statearr_71785_71890[(2)] = false);

(statearr_71785_71890[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (34))){
var inst_71708 = (state_71750[(15)]);
var state_71750__$1 = state_71750;
var statearr_71786_71891 = state_71750__$1;
(statearr_71786_71891[(2)] = inst_71708);

(statearr_71786_71891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (17))){
var inst_71742 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71787_71892 = state_71750__$1;
(statearr_71787_71892[(2)] = inst_71742);

(statearr_71787_71892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (3))){
var inst_71748 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71750__$1,inst_71748);
} else {
if((state_val_71751 === (12))){
var inst_71657 = (state_71750[(7)]);
var inst_71637 = (state_71750[(21)]);
var inst_71662 = fluree.db.api.query.auth_match.call(null,auth,inst_71637,inst_71657);
var inst_71663 = cljs.core.not.call(null,inst_71662);
var state_71750__$1 = state_71750;
var statearr_71788_71893 = state_71750__$1;
(statearr_71788_71893[(2)] = inst_71663);

(statearr_71788_71893[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (2))){
var _ = (function (){var statearr_71789 = state_71750;
(statearr_71789[(4)] = cljs.core.cons.call(null,(5),(state_71750[(4)])));

return statearr_71789;
})();
var inst_71542 = (function (){return (function (p1__71535_SHARP_){
return p1__71535_SHARP_.t;
});
})();
var inst_71543 = cljs.core.map.call(null,inst_71542,resp);
var inst_71544 = cljs.core.set.call(null,inst_71543);
var inst_71632 = cljs.core.async.chan.call(null,(1));
var inst_71633 = (function (){var ts = inst_71544;
var c__11542__auto____$1 = inst_71632;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71630){
var state_val_71631 = (state_71630[(1)]);
if((state_val_71631 === (7))){
var inst_71570 = (state_71630[(7)]);
var inst_71558 = (state_71630[(8)]);
var inst_71564 = (state_71630[(9)]);
var inst_71576 = (state_71630[(10)]);
var inst_71569 = (state_71630[(2)]);
var inst_71570__$1 = fluree.db.util.async.throw_err.call(null,inst_71569);
var inst_71572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71573 = [inst_71564,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71574 = (new cljs.core.PersistentVector(null,2,(5),inst_71572,inst_71573,null));
var inst_71575 = cljs.core.assoc_in.call(null,inst_71558,inst_71574,inst_71570__$1);
var inst_71576__$1 = auth;
var state_71630__$1 = (function (){var statearr_71790 = state_71630;
(statearr_71790[(7)] = inst_71570__$1);

(statearr_71790[(11)] = inst_71575);

(statearr_71790[(10)] = inst_71576__$1);

return statearr_71790;
})();
if(cljs.core.truth_(inst_71576__$1)){
var statearr_71791_71894 = state_71630__$1;
(statearr_71791_71894[(1)] = (8));

} else {
var statearr_71792_71895 = state_71630__$1;
(statearr_71792_71895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (1))){
var inst_71552 = (state_71630[(12)]);
var inst_71552__$1 = ts;
var inst_71553 = cljs.core.seq.call(null,inst_71552__$1);
var inst_71554 = cljs.core.first.call(null,inst_71553);
var inst_71555 = cljs.core.next.call(null,inst_71553);
var inst_71556 = cljs.core.PersistentHashMap.EMPTY;
var inst_71557 = inst_71552__$1;
var inst_71558 = inst_71556;
var state_71630__$1 = (function (){var statearr_71793 = state_71630;
(statearr_71793[(13)] = inst_71554);

(statearr_71793[(14)] = inst_71555);

(statearr_71793[(15)] = inst_71557);

(statearr_71793[(12)] = inst_71552__$1);

(statearr_71793[(8)] = inst_71558);

return statearr_71793;
})();
var statearr_71794_71896 = state_71630__$1;
(statearr_71794_71896[(2)] = null);

(statearr_71794_71896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (4))){
var inst_71564 = (state_71630[(9)]);
var inst_71567 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_71564);
var state_71630__$1 = state_71630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71630__$1,(7),inst_71567);
} else {
if((state_val_71631 === (13))){
var inst_71565 = (state_71630[(16)]);
var inst_71622 = (state_71630[(2)]);
var inst_71557 = inst_71565;
var inst_71558 = inst_71622;
var state_71630__$1 = (function (){var statearr_71795 = state_71630;
(statearr_71795[(15)] = inst_71557);

(statearr_71795[(8)] = inst_71558);

return statearr_71795;
})();
var statearr_71796_71897 = state_71630__$1;
(statearr_71796_71897[(2)] = null);

(statearr_71796_71897[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (6))){
var inst_71626 = (state_71630[(2)]);
var state_71630__$1 = state_71630;
var statearr_71797_71898 = state_71630__$1;
(statearr_71797_71898[(2)] = inst_71626);

(statearr_71797_71898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (3))){
var inst_71628 = (state_71630[(2)]);
var state_71630__$1 = state_71630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71630__$1,inst_71628);
} else {
if((state_val_71631 === (12))){
var inst_71575 = (state_71630[(11)]);
var state_71630__$1 = state_71630;
var statearr_71798_71899 = state_71630__$1;
(statearr_71798_71899[(2)] = inst_71575);

(statearr_71798_71899[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (2))){
var inst_71557 = (state_71630[(15)]);
var inst_71564 = (state_71630[(9)]);
var inst_71563 = cljs.core.seq.call(null,inst_71557);
var inst_71564__$1 = cljs.core.first.call(null,inst_71563);
var inst_71565 = cljs.core.next.call(null,inst_71563);
var state_71630__$1 = (function (){var statearr_71799 = state_71630;
(statearr_71799[(16)] = inst_71565);

(statearr_71799[(9)] = inst_71564__$1);

return statearr_71799;
})();
if(cljs.core.truth_(inst_71564__$1)){
var statearr_71800_71900 = state_71630__$1;
(statearr_71800_71900[(1)] = (4));

} else {
var statearr_71801_71901 = state_71630__$1;
(statearr_71801_71901[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (11))){
var inst_71554 = (state_71630[(13)]);
var inst_71555 = (state_71630[(14)]);
var inst_71557 = (state_71630[(15)]);
var inst_71570 = (state_71630[(7)]);
var inst_71552 = (state_71630[(12)]);
var inst_71575 = (state_71630[(11)]);
var inst_71558 = (state_71630[(8)]);
var inst_71565 = (state_71630[(16)]);
var inst_71564 = (state_71630[(9)]);
var inst_71582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71583 = [inst_71564,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71584 = (new cljs.core.PersistentVector(null,2,(5),inst_71582,inst_71583,null));
var inst_71597 = cljs.core.async.chan.call(null,(1));
var inst_71598 = (function (){var t = inst_71564;
var seq__71550 = inst_71555;
var block = inst_71570;
var r = inst_71565;
var acc = inst_71558;
var seq__71561 = inst_71565;
var G__71571 = inst_71575;
var G__71548 = inst_71557;
var first__71551 = inst_71554;
var vec__71560 = inst_71557;
var vec__71549 = inst_71552;
var c__11542__auto____$2 = inst_71597;
var first__71562 = inst_71564;
return (function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_71595){
var state_val_71596 = (state_71595[(1)]);
if((state_val_71596 === (1))){
var state_71595__$1 = state_71595;
var statearr_71802_71902 = state_71595__$1;
(statearr_71802_71902[(2)] = null);

(statearr_71802_71902[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (2))){
var ___$1 = (function (){var statearr_71803 = state_71595;
(statearr_71803[(4)] = cljs.core.cons.call(null,(5),(state_71595[(4)])));

return statearr_71803;
})();
var ___$2 = (function (){var statearr_71804 = state_71595;
(statearr_71804[(4)] = cljs.core.rest.call(null,(state_71595[(4)])));

return statearr_71804;
})();
var state_71595__$1 = state_71595;
var statearr_71805_71903 = state_71595__$1;
(statearr_71805_71903[(2)] = db);

(statearr_71805_71903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (3))){
var inst_71593 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71595__$1,inst_71593);
} else {
if((state_val_71596 === (4))){
var inst_71585 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71807_71904 = state_71595__$1;
(statearr_71807_71904[(2)] = inst_71585);

(statearr_71807_71904[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (5))){
var ___$1 = (function (){var statearr_71808 = state_71595;
(statearr_71808[(4)] = cljs.core.rest.call(null,(state_71595[(4)])));

return statearr_71808;
})();
var state_71595__$1 = state_71595;
var ex71806 = (state_71595__$1[(2)]);
var statearr_71809_71905 = state_71595__$1;
(statearr_71809_71905[(5)] = ex71806);


if((ex71806 instanceof Error)){
var statearr_71810_71906 = state_71595__$1;
(statearr_71810_71906[(1)] = (4));

(statearr_71810_71906[(5)] = null);

} else {
throw ex71806;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0 = (function (){
var statearr_71811 = [null,null,null,null,null,null,null];
(statearr_71811[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__);

(statearr_71811[(1)] = (1));

return statearr_71811;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1 = (function (state_71595){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71812){var ex__11472__auto__ = e71812;
var statearr_71813_71907 = state_71595;
(statearr_71813_71907[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71595[(4)]))){
var statearr_71814_71908 = state_71595;
(statearr_71814_71908[(1)] = cljs.core.first.call(null,(state_71595[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71909 = state_71595;
state_71595 = G__71909;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = function(state_71595){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1.call(this,state_71595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71815 = f__11543__auto__.call(null);
(statearr_71815[(6)] = c__11542__auto____$2);

return statearr_71815;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_71599 = cljs.core.async.impl.dispatch.run.call(null,inst_71598);
var inst_71600 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_71601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71602 = ["?auth","?id"];
var inst_71603 = (new cljs.core.PersistentVector(null,2,(5),inst_71601,inst_71602,null));
var inst_71604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71606 = [inst_71564,"_tx/auth","?auth"];
var inst_71607 = (new cljs.core.PersistentVector(null,3,(5),inst_71605,inst_71606,null));
var inst_71608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71609 = ["?auth","_auth/id","?id"];
var inst_71610 = (new cljs.core.PersistentVector(null,3,(5),inst_71608,inst_71609,null));
var inst_71611 = [inst_71607,inst_71610];
var inst_71612 = (new cljs.core.PersistentVector(null,2,(5),inst_71604,inst_71611,null));
var inst_71613 = [inst_71603,inst_71612];
var inst_71614 = cljs.core.PersistentHashMap.fromArrays(inst_71600,inst_71613);
var inst_71615 = fluree.db.api.query.query_async.call(null,inst_71597,inst_71614);
var state_71630__$1 = (function (){var statearr_71816 = state_71630;
(statearr_71816[(17)] = inst_71584);

(statearr_71816[(18)] = inst_71599);

return statearr_71816;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71630__$1,(14),inst_71615);
} else {
if((state_val_71631 === (9))){
var state_71630__$1 = state_71630;
var statearr_71817_71910 = state_71630__$1;
(statearr_71817_71910[(2)] = show_auth);

(statearr_71817_71910[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (5))){
var inst_71558 = (state_71630[(8)]);
var state_71630__$1 = state_71630;
var statearr_71818_71911 = state_71630__$1;
(statearr_71818_71911[(2)] = inst_71558);

(statearr_71818_71911[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (14))){
var inst_71584 = (state_71630[(17)]);
var inst_71575 = (state_71630[(11)]);
var inst_71617 = (state_71630[(2)]);
var inst_71618 = fluree.db.util.async.throw_err.call(null,inst_71617);
var inst_71619 = cljs.core.assoc_in.call(null,inst_71575,inst_71584,inst_71618);
var state_71630__$1 = state_71630;
var statearr_71819_71912 = state_71630__$1;
(statearr_71819_71912[(2)] = inst_71619);

(statearr_71819_71912[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (10))){
var inst_71580 = (state_71630[(2)]);
var state_71630__$1 = state_71630;
if(cljs.core.truth_(inst_71580)){
var statearr_71820_71913 = state_71630__$1;
(statearr_71820_71913[(1)] = (11));

} else {
var statearr_71821_71914 = state_71630__$1;
(statearr_71821_71914[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71631 === (8))){
var inst_71576 = (state_71630[(10)]);
var state_71630__$1 = state_71630;
var statearr_71822_71915 = state_71630__$1;
(statearr_71822_71915[(2)] = inst_71576);

(statearr_71822_71915[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0 = (function (){
var statearr_71823 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71823[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__);

(statearr_71823[(1)] = (1));

return statearr_71823;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1 = (function (state_71630){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71824){var ex__11472__auto__ = e71824;
var statearr_71825_71916 = state_71630;
(statearr_71825_71916[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71630[(4)]))){
var statearr_71826_71917 = state_71630;
(statearr_71826_71917[(1)] = cljs.core.first.call(null,(state_71630[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71918 = state_71630;
state_71630 = G__71918;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = function(state_71630){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1.call(this,state_71630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71827 = f__11543__auto__.call(null);
(statearr_71827[(6)] = c__11542__auto____$1);

return statearr_71827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
});
})();
var inst_71634 = cljs.core.async.impl.dispatch.run.call(null,inst_71633);
var state_71750__$1 = (function (){var statearr_71828 = state_71750;
(statearr_71828[(22)] = inst_71634);

return statearr_71828;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71750__$1,(6),inst_71632);
} else {
if((state_val_71751 === (23))){
var inst_71692 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
if(cljs.core.truth_(inst_71692)){
var statearr_71829_71919 = state_71750__$1;
(statearr_71829_71919[(1)] = (27));

} else {
var statearr_71830_71920 = state_71750__$1;
(statearr_71830_71920[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (35))){
var inst_71716 = (state_71750[(2)]);
var state_71750__$1 = (function (){var statearr_71831 = state_71750;
(statearr_71831[(18)] = inst_71716);

return statearr_71831;
})();
var statearr_71832_71921 = state_71750__$1;
(statearr_71832_71921[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (19))){
var state_71750__$1 = state_71750;
var statearr_71834_71922 = state_71750__$1;
(statearr_71834_71922[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (11))){
var inst_71669 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
if(cljs.core.truth_(inst_71669)){
var statearr_71837_71923 = state_71750__$1;
(statearr_71837_71923[(1)] = (15));

} else {
var statearr_71838_71924 = state_71750__$1;
(statearr_71838_71924[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (9))){
var inst_71660 = (state_71750[(16)]);
var inst_71660__$1 = auth;
var state_71750__$1 = (function (){var statearr_71839 = state_71750;
(statearr_71839[(16)] = inst_71660__$1);

return statearr_71839;
})();
if(cljs.core.truth_(inst_71660__$1)){
var statearr_71840_71925 = state_71750__$1;
(statearr_71840_71925[(1)] = (12));

} else {
var statearr_71841_71926 = state_71750__$1;
(statearr_71841_71926[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (5))){
var _ = (function (){var statearr_71842 = state_71750;
(statearr_71842[(4)] = cljs.core.rest.call(null,(state_71750[(4)])));

return statearr_71842;
})();
var state_71750__$1 = state_71750;
var ex71836 = (state_71750__$1[(2)]);
var statearr_71843_71927 = state_71750__$1;
(statearr_71843_71927[(5)] = ex71836);


if((ex71836 instanceof Error)){
var statearr_71844_71928 = state_71750__$1;
(statearr_71844_71928[(1)] = (4));

(statearr_71844_71928[(5)] = null);

} else {
throw ex71836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (14))){
var inst_71666 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71845_71929 = state_71750__$1;
(statearr_71845_71929[(2)] = inst_71666);

(statearr_71845_71929[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (26))){
var inst_71689 = (state_71750[(2)]);
var state_71750__$1 = state_71750;
var statearr_71846_71930 = state_71750__$1;
(statearr_71846_71930[(2)] = inst_71689);

(statearr_71846_71930[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (16))){
var inst_71657 = (state_71750[(7)]);
var state_71750__$1 = state_71750;
if(cljs.core.truth_(inst_71657)){
var statearr_71847_71931 = state_71750__$1;
(statearr_71847_71931[(1)] = (18));

} else {
var statearr_71848_71932 = state_71750__$1;
(statearr_71848_71932[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (38))){
var inst_71724 = (state_71750[(2)]);
var state_71750__$1 = (function (){var statearr_71849 = state_71750;
(statearr_71849[(13)] = inst_71724);

return statearr_71849;
})();
if(cljs.core.truth_(show_auth)){
var statearr_71850_71933 = state_71750__$1;
(statearr_71850_71933[(1)] = (39));

} else {
var statearr_71851_71934 = state_71750__$1;
(statearr_71851_71934[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (30))){
var inst_71651 = (state_71750[(14)]);
var inst_71698 = (state_71750[(12)]);
var inst_71702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71703 = [inst_71698,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_71704 = (new cljs.core.PersistentVector(null,2,(5),inst_71702,inst_71703,null));
var inst_71705 = cljs.core.assoc_in.call(null,inst_71651,inst_71704,inst_71698);
var state_71750__$1 = state_71750;
var statearr_71852_71935 = state_71750__$1;
(statearr_71852_71935[(2)] = inst_71705);

(statearr_71852_71935[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (10))){
var inst_71657 = (state_71750[(7)]);
var state_71750__$1 = state_71750;
var statearr_71853_71936 = state_71750__$1;
(statearr_71853_71936[(2)] = inst_71657);

(statearr_71853_71936[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (18))){
var inst_71675 = (state_71750[(17)]);
var inst_71657 = (state_71750[(7)]);
var inst_71676 = (state_71750[(10)]);
var inst_71637 = (state_71750[(21)]);
var inst_71675__$1 = inst_71657.t;
var inst_71676__$1 = cljs.core.get.call(null,inst_71637,inst_71675__$1);
var inst_71678 = (inst_71676__$1 == null);
var inst_71679 = cljs.core.not.call(null,inst_71678);
var state_71750__$1 = (function (){var statearr_71854 = state_71750;
(statearr_71854[(17)] = inst_71675__$1);

(statearr_71854[(10)] = inst_71676__$1);

return statearr_71854;
})();
if(inst_71679){
var statearr_71855_71937 = state_71750__$1;
(statearr_71855_71937[(1)] = (21));

} else {
var statearr_71856_71938 = state_71750__$1;
(statearr_71856_71938[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (42))){
var inst_71651 = (state_71750[(14)]);
var state_71750__$1 = state_71750;
var statearr_71857_71939 = state_71750__$1;
(statearr_71857_71939[(2)] = inst_71651);

(statearr_71857_71939[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (37))){
var inst_71716 = (state_71750[(18)]);
var state_71750__$1 = state_71750;
var statearr_71858_71940 = state_71750__$1;
(statearr_71858_71940[(2)] = inst_71716);

(statearr_71858_71940[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71751 === (8))){
var inst_71744 = (state_71750[(2)]);
var inst_71745 = cljs.core.vals.call(null,inst_71744);
var _ = (function (){var statearr_71859 = state_71750;
(statearr_71859[(4)] = cljs.core.rest.call(null,(state_71750[(4)])));

return statearr_71859;
})();
var state_71750__$1 = state_71750;
var statearr_71860_71941 = state_71750__$1;
(statearr_71860_71941[(2)] = inst_71745);

(statearr_71860_71941[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0 = (function (){
var statearr_71861 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71861[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__);

(statearr_71861[(1)] = (1));

return statearr_71861;
});
var fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1 = (function (state_71750){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_71750);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e71862){var ex__11472__auto__ = e71862;
var statearr_71863_71942 = state_71750;
(statearr_71863_71942[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_71750[(4)]))){
var statearr_71864_71943 = state_71750;
(statearr_71864_71943[(1)] = cljs.core.first.call(null,(state_71750[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71944 = state_71750;
state_71750 = G__71944;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__ = function(state_71750){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1.call(this,state_71750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__11469__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_71865 = f__11543__auto__.call(null);
(statearr_71865[(6)] = c__11542__auto__);

return statearr_71865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_72090){
var state_val_72091 = (state_72090[(1)]);
if((state_val_72091 === (7))){
var state_72090__$1 = state_72090;
var statearr_72092_72168 = state_72090__$1;
(statearr_72092_72168[(2)] = false);

(statearr_72092_72168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (20))){
var inst_71984 = (state_72090[(7)]);
var inst_71996 = (state_72090[(8)]);
var inst_72006 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71984);
var state_72090__$1 = (function (){var statearr_72093 = state_72090;
(statearr_72093[(9)] = inst_72006);

return statearr_72093;
})();
if(cljs.core.truth_(inst_71996)){
var statearr_72094_72169 = state_72090__$1;
(statearr_72094_72169[(1)] = (23));

} else {
var statearr_72095_72170 = state_72090__$1;
(statearr_72095_72170[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (27))){
var state_72090__$1 = state_72090;
var statearr_72096_72171 = state_72090__$1;
(statearr_72096_72171[(2)] = (-1));

(statearr_72096_72171[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (1))){
var state_72090__$1 = state_72090;
var statearr_72097_72172 = state_72090__$1;
(statearr_72097_72172[(2)] = null);

(statearr_72097_72172[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (24))){
var inst_71996 = (state_72090[(8)]);
var state_72090__$1 = state_72090;
var statearr_72098_72173 = state_72090__$1;
(statearr_72098_72173[(2)] = inst_71996);

(statearr_72098_72173[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (39))){
var inst_71982 = (state_72090[(10)]);
var state_72090__$1 = state_72090;
var statearr_72099_72174 = state_72090__$1;
(statearr_72099_72174[(2)] = inst_71982);

(statearr_72099_72174[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (46))){
var inst_72055 = (state_72090[(11)]);
var state_72090__$1 = state_72090;
var statearr_72100_72175 = state_72090__$1;
(statearr_72100_72175[(2)] = inst_72055);

(statearr_72100_72175[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (4))){
var inst_71945 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
var statearr_72101_72176 = state_72090__$1;
(statearr_72101_72176[(2)] = inst_71945);

(statearr_72101_72176[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (15))){
var inst_71977 = (state_72090[(12)]);
var inst_71986 = (state_72090[(2)]);
var inst_71987 = fluree.db.util.async.throw_err.call(null,inst_71986);
var state_72090__$1 = (function (){var statearr_72102 = state_72090;
(statearr_72102[(13)] = inst_71987);

return statearr_72102;
})();
if(cljs.core.truth_(inst_71977)){
var statearr_72103_72177 = state_72090__$1;
(statearr_72103_72177[(1)] = (16));

} else {
var statearr_72104_72178 = state_72090__$1;
(statearr_72104_72178[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (48))){
var inst_72063 = (state_72090[(2)]);
var inst_72064 = fluree.db.util.async.throw_err.call(null,inst_72063);
var state_72090__$1 = state_72090;
var statearr_72105_72179 = state_72090__$1;
(statearr_72105_72179[(2)] = inst_72064);

(statearr_72105_72179[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (50))){
var inst_72067 = (state_72090[(14)]);
var state_72090__$1 = state_72090;
var statearr_72106_72180 = state_72090__$1;
(statearr_72106_72180[(2)] = inst_72067);

(statearr_72106_72180[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (21))){
var inst_72077 = cljs.core.pr_str.call(null,query_map);
var inst_72078 = ["History query not properly formatted. Provided ",inst_72077].join('');
var inst_72079 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72080 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72081 = cljs.core.PersistentHashMap.fromArrays(inst_72079,inst_72080);
var inst_72082 = cljs.core.ex_info.call(null,inst_72078,inst_72081);
var inst_72083 = (function(){throw inst_72082})();
var state_72090__$1 = state_72090;
var statearr_72107_72181 = state_72090__$1;
(statearr_72107_72181[(2)] = inst_72083);

(statearr_72107_72181[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (31))){
var inst_71987 = (state_72090[(13)]);
var inst_72030 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71987);
var state_72090__$1 = state_72090;
var statearr_72108_72182 = state_72090__$1;
(statearr_72108_72182[(2)] = inst_72030);

(statearr_72108_72182[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (32))){
var inst_72022 = (state_72090[(15)]);
var inst_71987 = (state_72090[(13)]);
var inst_71978 = (state_72090[(16)]);
var inst_72032 = (state_72090[(2)]);
var inst_72033 = fluree.db.api.query.get_history_pattern.call(null,inst_71978);
var inst_72034 = cljs.core.nth.call(null,inst_72033,(0),null);
var inst_72035 = cljs.core.nth.call(null,inst_72033,(1),null);
var inst_72036 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_72037 = [inst_72022,inst_72032];
var inst_72038 = cljs.core.PersistentHashMap.fromArrays(inst_72036,inst_72037);
var inst_72039 = fluree.db.query.range.time_range.call(null,inst_71987,inst_72035,cljs.core._EQ_,inst_72034,inst_72038);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(34),inst_72039);
} else {
if((state_val_72091 === (40))){
var inst_71981 = (state_72090[(17)]);
var state_72090__$1 = state_72090;
var statearr_72109_72183 = state_72090__$1;
(statearr_72109_72183[(2)] = inst_71981);

(statearr_72109_72183[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (33))){
var inst_72026 = (state_72090[(2)]);
var inst_72027 = fluree.db.util.async.throw_err.call(null,inst_72026);
var inst_72028 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_72027);
var state_72090__$1 = state_72090;
var statearr_72110_72184 = state_72090__$1;
(statearr_72110_72184[(2)] = inst_72028);

(statearr_72110_72184[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (13))){
var inst_71955 = (state_72090[(18)]);
var state_72090__$1 = state_72090;
var statearr_72111_72185 = state_72090__$1;
(statearr_72111_72185[(2)] = inst_71955);

(statearr_72111_72185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (22))){
var inst_72085 = (state_72090[(2)]);
var _ = (function (){var statearr_72112 = state_72090;
(statearr_72112[(4)] = cljs.core.rest.call(null,(state_72090[(4)])));

return statearr_72112;
})();
var state_72090__$1 = state_72090;
var statearr_72113_72186 = state_72090__$1;
(statearr_72113_72186[(2)] = inst_72085);

(statearr_72113_72186[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (36))){
var state_72090__$1 = state_72090;
var statearr_72114_72187 = state_72090__$1;
(statearr_72114_72187[(2)] = null);

(statearr_72114_72187[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (41))){
var inst_72047 = (state_72090[(19)]);
var inst_71987 = (state_72090[(13)]);
var inst_72042 = (state_72090[(20)]);
var inst_72051 = (state_72090[(2)]);
var inst_72052 = fluree.db.api.query.format_history_resp.call(null,inst_71987,inst_72042,inst_72047,inst_72051);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(38),inst_72052);
} else {
if((state_val_72091 === (43))){
var inst_71979 = (state_72090[(21)]);
var state_72090__$1 = state_72090;
var statearr_72115_72188 = state_72090__$1;
(statearr_72115_72188[(2)] = inst_71979);

(statearr_72115_72188[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (29))){
var inst_72016 = (state_72090[(2)]);
var inst_72017 = fluree.db.util.async.throw_err.call(null,inst_72016);
var inst_72018 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_72017);
var inst_72019 = (inst_72018 - (1));
var state_72090__$1 = state_72090;
var statearr_72116_72189 = state_72090__$1;
(statearr_72116_72189[(2)] = inst_72019);

(statearr_72116_72189[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (44))){
var inst_72059 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
if(cljs.core.truth_(inst_72059)){
var statearr_72117_72190 = state_72090__$1;
(statearr_72117_72190[(1)] = (45));

} else {
var statearr_72118_72191 = state_72090__$1;
(statearr_72118_72191[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (6))){
var inst_71955 = (state_72090[(18)]);
var inst_71960 = inst_71955.cljs$lang$protocol_mask$partition0$;
var inst_71961 = (inst_71960 & (64));
var inst_71962 = inst_71955.cljs$core$ISeq$;
var inst_71963 = (cljs.core.PROTOCOL_SENTINEL === inst_71962);
var inst_71964 = ((inst_71961) || (inst_71963));
var state_72090__$1 = state_72090;
if(cljs.core.truth_(inst_71964)){
var statearr_72119_72192 = state_72090__$1;
(statearr_72119_72192[(1)] = (9));

} else {
var statearr_72120_72193 = state_72090__$1;
(statearr_72120_72193[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (28))){
var inst_71997 = (state_72090[(22)]);
var inst_72022 = (state_72090[(2)]);
var state_72090__$1 = (function (){var statearr_72121 = state_72090;
(statearr_72121[(15)] = inst_72022);

return statearr_72121;
})();
if(cljs.core.truth_(inst_71997)){
var statearr_72122_72194 = state_72090__$1;
(statearr_72122_72194[(1)] = (30));

} else {
var statearr_72123_72195 = state_72090__$1;
(statearr_72123_72195[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (51))){
var inst_72075 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
var statearr_72124_72196 = state_72090__$1;
(statearr_72124_72196[(2)] = inst_72075);

(statearr_72124_72196[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (25))){
var inst_72011 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
if(cljs.core.truth_(inst_72011)){
var statearr_72125_72197 = state_72090__$1;
(statearr_72125_72197[(1)] = (26));

} else {
var statearr_72126_72198 = state_72090__$1;
(statearr_72126_72198[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (34))){
var inst_71983 = (state_72090[(23)]);
var inst_72041 = (state_72090[(2)]);
var inst_72042 = fluree.db.util.async.throw_err.call(null,inst_72041);
var state_72090__$1 = (function (){var statearr_72127 = state_72090;
(statearr_72127[(20)] = inst_72042);

return statearr_72127;
})();
if(cljs.core.truth_(inst_71983)){
var statearr_72128_72199 = state_72090__$1;
(statearr_72128_72199[(1)] = (35));

} else {
var statearr_72129_72200 = state_72090__$1;
(statearr_72129_72200[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (17))){
var state_72090__$1 = state_72090;
var statearr_72130_72201 = state_72090__$1;
(statearr_72130_72201[(2)] = null);

(statearr_72130_72201[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (3))){
var inst_72088 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72090__$1,inst_72088);
} else {
if((state_val_72091 === (12))){
var inst_71955 = (state_72090[(18)]);
var inst_71973 = cljs.core.apply.call(null,cljs.core.hash_map,inst_71955);
var state_72090__$1 = state_72090;
var statearr_72131_72202 = state_72090__$1;
(statearr_72131_72202[(2)] = inst_71973);

(statearr_72131_72202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (2))){
var inst_71955 = (state_72090[(18)]);
var _ = (function (){var statearr_72132 = state_72090;
(statearr_72132[(4)] = cljs.core.cons.call(null,(5),(state_72090[(4)])));

return statearr_72132;
})();
var inst_71955__$1 = query_map;
var inst_71957 = (inst_71955__$1 == null);
var inst_71958 = cljs.core.not.call(null,inst_71957);
var state_72090__$1 = (function (){var statearr_72133 = state_72090;
(statearr_72133[(18)] = inst_71955__$1);

return statearr_72133;
})();
if(inst_71958){
var statearr_72134_72203 = state_72090__$1;
(statearr_72134_72203[(1)] = (6));

} else {
var statearr_72135_72204 = state_72090__$1;
(statearr_72135_72204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (23))){
var inst_71996 = (state_72090[(8)]);
var inst_72008 = cljs.core.not_EQ_.call(null,(1),inst_71996);
var state_72090__$1 = state_72090;
var statearr_72136_72205 = state_72090__$1;
(statearr_72136_72205[(2)] = inst_72008);

(statearr_72136_72205[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (47))){
var inst_72006 = (state_72090[(9)]);
var inst_72067 = (state_72090[(2)]);
var state_72090__$1 = (function (){var statearr_72137 = state_72090;
(statearr_72137[(14)] = inst_72067);

return statearr_72137;
})();
if(cljs.core.truth_(inst_72006)){
var statearr_72138_72206 = state_72090__$1;
(statearr_72138_72206[(1)] = (49));

} else {
var statearr_72139_72207 = state_72090__$1;
(statearr_72139_72207[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (35))){
var inst_71983 = (state_72090[(23)]);
var inst_72044 = cljs.core.set.call(null,inst_71983);
var state_72090__$1 = state_72090;
var statearr_72140_72208 = state_72090__$1;
(statearr_72140_72208[(2)] = inst_72044);

(statearr_72140_72208[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (19))){
var inst_71991 = (state_72090[(2)]);
var inst_71992 = fluree.db.util.async.throw_err.call(null,inst_71991);
var state_72090__$1 = state_72090;
var statearr_72141_72209 = state_72090__$1;
(statearr_72141_72209[(2)] = inst_71992);

(statearr_72141_72209[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (11))){
var inst_71968 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
var statearr_72143_72210 = state_72090__$1;
(statearr_72143_72210[(2)] = inst_71968);

(statearr_72143_72210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (9))){
var state_72090__$1 = state_72090;
var statearr_72144_72211 = state_72090__$1;
(statearr_72144_72211[(2)] = true);

(statearr_72144_72211[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (5))){
var _ = (function (){var statearr_72145 = state_72090;
(statearr_72145[(4)] = cljs.core.rest.call(null,(state_72090[(4)])));

return statearr_72145;
})();
var state_72090__$1 = state_72090;
var ex72142 = (state_72090__$1[(2)]);
var statearr_72146_72212 = state_72090__$1;
(statearr_72146_72212[(5)] = ex72142);


if((ex72142 instanceof Error)){
var statearr_72147_72213 = state_72090__$1;
(statearr_72147_72213[(1)] = (4));

(statearr_72147_72213[(5)] = null);

} else {
throw ex72142;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (14))){
var inst_71976 = (state_72090[(2)]);
var inst_71977 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71978 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71979 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_71980 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_71981 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_71982 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_71983 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_71984 = cljs.core.get.call(null,inst_71976,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_72090__$1 = (function (){var statearr_72148 = state_72090;
(statearr_72148[(24)] = inst_71980);

(statearr_72148[(17)] = inst_71981);

(statearr_72148[(12)] = inst_71977);

(statearr_72148[(7)] = inst_71984);

(statearr_72148[(16)] = inst_71978);

(statearr_72148[(23)] = inst_71983);

(statearr_72148[(10)] = inst_71982);

(statearr_72148[(21)] = inst_71979);

return statearr_72148;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(15),sources);
} else {
if((state_val_72091 === (45))){
var inst_72055 = (state_72090[(11)]);
var inst_71987 = (state_72090[(13)]);
var inst_72061 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_71987,inst_72055);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(48),inst_72061);
} else {
if((state_val_72091 === (26))){
var inst_71987 = (state_72090[(13)]);
var inst_71996 = (state_72090[(8)]);
var inst_72013 = (inst_71996 - (1));
var inst_72014 = fluree.db.time_travel.as_of_block.call(null,inst_71987,inst_72013);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(29),inst_72014);
} else {
if((state_val_72091 === (16))){
var inst_71987 = (state_72090[(13)]);
var inst_71989 = fluree.db.api.query.resolve_block_range.call(null,inst_71987,query_map);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(19),inst_71989);
} else {
if((state_val_72091 === (38))){
var inst_71980 = (state_72090[(24)]);
var inst_72054 = (state_72090[(2)]);
var inst_72055 = fluree.db.util.async.throw_err.call(null,inst_72054);
var state_72090__$1 = (function (){var statearr_72149 = state_72090;
(statearr_72149[(11)] = inst_72055);

return statearr_72149;
})();
if(cljs.core.truth_(inst_71980)){
var statearr_72150_72214 = state_72090__$1;
(statearr_72150_72214[(1)] = (42));

} else {
var statearr_72151_72215 = state_72090__$1;
(statearr_72151_72215[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (30))){
var inst_71997 = (state_72090[(22)]);
var inst_71987 = (state_72090[(13)]);
var inst_72024 = fluree.db.time_travel.as_of_block.call(null,inst_71987,inst_71997);
var state_72090__$1 = state_72090;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72090__$1,(33),inst_72024);
} else {
if((state_val_72091 === (10))){
var state_72090__$1 = state_72090;
var statearr_72152_72216 = state_72090__$1;
(statearr_72152_72216[(2)] = false);

(statearr_72152_72216[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (18))){
var inst_71995 = (state_72090[(2)]);
var inst_71996 = cljs.core.nth.call(null,inst_71995,(0),null);
var inst_71997 = cljs.core.nth.call(null,inst_71995,(1),null);
var inst_71998 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71999 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72000 = cljs.core.keys.call(null,inst_71999);
var inst_72001 = cljs.core._EQ_.call(null,inst_71998,inst_72000);
var state_72090__$1 = (function (){var statearr_72153 = state_72090;
(statearr_72153[(22)] = inst_71997);

(statearr_72153[(8)] = inst_71996);

return statearr_72153;
})();
if(inst_72001){
var statearr_72154_72217 = state_72090__$1;
(statearr_72154_72217[(1)] = (20));

} else {
var statearr_72155_72218 = state_72090__$1;
(statearr_72155_72218[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (42))){
var inst_71980 = (state_72090[(24)]);
var state_72090__$1 = state_72090;
var statearr_72156_72219 = state_72090__$1;
(statearr_72156_72219[(2)] = inst_71980);

(statearr_72156_72219[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (37))){
var inst_71982 = (state_72090[(10)]);
var inst_72047 = (state_72090[(2)]);
var state_72090__$1 = (function (){var statearr_72157 = state_72090;
(statearr_72157[(19)] = inst_72047);

return statearr_72157;
})();
if(cljs.core.truth_(inst_71982)){
var statearr_72158_72220 = state_72090__$1;
(statearr_72158_72220[(1)] = (39));

} else {
var statearr_72159_72221 = state_72090__$1;
(statearr_72159_72221[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (8))){
var inst_71971 = (state_72090[(2)]);
var state_72090__$1 = state_72090;
if(cljs.core.truth_(inst_71971)){
var statearr_72160_72222 = state_72090__$1;
(statearr_72160_72222[(1)] = (12));

} else {
var statearr_72161_72223 = state_72090__$1;
(statearr_72161_72223[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72091 === (49))){
var inst_72042 = (state_72090[(20)]);
var inst_72067 = (state_72090[(14)]);
var inst_72069 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_72070 = cljs.core.count.call(null,inst_72042);
var inst_72071 = [inst_72067,inst_72070,(200)];
var inst_72072 = cljs.core.PersistentHashMap.fromArrays(inst_72069,inst_72071);
var state_72090__$1 = state_72090;
var statearr_72162_72224 = state_72090__$1;
(statearr_72162_72224[(2)] = inst_72072);

(statearr_72162_72224[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__11469__auto____0 = (function (){
var statearr_72163 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72163[(0)] = fluree$db$api$query$history_query_async_$_state_machine__11469__auto__);

(statearr_72163[(1)] = (1));

return statearr_72163;
});
var fluree$db$api$query$history_query_async_$_state_machine__11469__auto____1 = (function (state_72090){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_72090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e72164){var ex__11472__auto__ = e72164;
var statearr_72165_72225 = state_72090;
(statearr_72165_72225[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_72090[(4)]))){
var statearr_72166_72226 = state_72090;
(statearr_72166_72226[(1)] = cljs.core.first.call(null,(state_72090[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72227 = state_72090;
state_72090 = G__72227;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__11469__auto__ = function(state_72090){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__11469__auto____1.call(this,state_72090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__11469__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__11469__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_72167 = f__11543__auto__.call(null);
(statearr_72167[(6)] = c__11542__auto__);

return statearr_72167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_72380){
var state_val_72381 = (state_72380[(1)]);
if((state_val_72381 === (7))){
var state_72380__$1 = state_72380;
var statearr_72382_72474 = state_72380__$1;
(statearr_72382_72474[(2)] = false);

(statearr_72382_72474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (59))){
var inst_72365 = (state_72380[(7)]);
var state_72380__$1 = state_72380;
var statearr_72383_72475 = state_72380__$1;
(statearr_72383_72475[(2)] = inst_72365);

(statearr_72383_72475[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (20))){
var inst_72262 = (state_72380[(8)]);
var inst_72300 = (state_72380[(2)]);
var state_72380__$1 = (function (){var statearr_72384 = state_72380;
(statearr_72384[(9)] = inst_72300);

return statearr_72384;
})();
if(cljs.core.truth_(inst_72262)){
var statearr_72385_72476 = state_72380__$1;
(statearr_72385_72476[(1)] = (24));

} else {
var statearr_72386_72477 = state_72380__$1;
(statearr_72386_72477[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (58))){
var inst_72300 = (state_72380[(9)]);
var inst_72365 = (state_72380[(7)]);
var inst_72320 = (state_72380[(10)]);
var inst_72360 = (state_72380[(11)]);
var inst_72367 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_72368 = cljs.core.deref.call(null,inst_72320);
var inst_72369 = fluree.db.api.query.response_time_formatted.call(null,inst_72360);
var inst_72370 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_72300);
var inst_72371 = [(200),inst_72365,inst_72368,inst_72369,inst_72370];
var inst_72372 = cljs.core.PersistentHashMap.fromArrays(inst_72367,inst_72371);
var state_72380__$1 = state_72380;
var statearr_72387_72478 = state_72380__$1;
(statearr_72387_72478[(2)] = inst_72372);

(statearr_72387_72478[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (60))){
var inst_72375 = (state_72380[(2)]);
var _ = (function (){var statearr_72388 = state_72380;
(statearr_72388[(4)] = cljs.core.rest.call(null,(state_72380[(4)])));

return statearr_72388;
})();
var state_72380__$1 = state_72380;
var statearr_72389_72479 = state_72380__$1;
(statearr_72389_72479[(2)] = inst_72375);

(statearr_72389_72479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (27))){
var inst_72311 = (state_72380[(12)]);
var state_72380__$1 = state_72380;
var statearr_72390_72480 = state_72380__$1;
(statearr_72390_72480[(2)] = inst_72311);

(statearr_72390_72480[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (1))){
var state_72380__$1 = state_72380;
var statearr_72391_72481 = state_72380__$1;
(statearr_72391_72481[(2)] = null);

(statearr_72391_72481[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (24))){
var inst_72300 = (state_72380[(9)]);
var inst_72262 = (state_72380[(8)]);
var inst_72302 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_72300);
var inst_72303 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_72300);
var inst_72304 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_72300);
var inst_72305 = fluree.db.api.query.get_sources.call(null,inst_72302,inst_72303,inst_72304,inst_72262);
var state_72380__$1 = state_72380;
var statearr_72392_72482 = state_72380__$1;
(statearr_72392_72482[(2)] = inst_72305);

(statearr_72392_72482[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (55))){
var inst_72353 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72354 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72355 = cljs.core.PersistentHashMap.fromArrays(inst_72353,inst_72354);
var inst_72356 = cljs.core.ex_info.call(null,"Invalid query.",inst_72355);
var inst_72357 = (function(){throw inst_72356})();
var state_72380__$1 = state_72380;
var statearr_72393_72483 = state_72380__$1;
(statearr_72393_72483[(2)] = inst_72357);

(statearr_72393_72483[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (39))){
var inst_72264 = (state_72380[(13)]);
var state_72380__$1 = state_72380;
var statearr_72394_72484 = state_72380__$1;
(statearr_72394_72484[(2)] = inst_72264);

(statearr_72394_72484[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (46))){
var inst_72258 = (state_72380[(14)]);
var state_72380__$1 = state_72380;
var statearr_72395_72485 = state_72380__$1;
(statearr_72395_72485[(2)] = inst_72258);

(statearr_72395_72485[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (4))){
var inst_72229 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72396_72486 = state_72380__$1;
(statearr_72396_72486[(2)] = inst_72229);

(statearr_72396_72486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (54))){
var state_72380__$1 = state_72380;
var statearr_72397_72487 = state_72380__$1;
(statearr_72397_72487[(2)] = null);

(statearr_72397_72487[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (15))){
var state_72380__$1 = state_72380;
var statearr_72398_72488 = state_72380__$1;
(statearr_72398_72488[(2)] = null);

(statearr_72398_72488[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (48))){
var inst_72265 = (state_72380[(15)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72265)){
var statearr_72399_72489 = state_72380__$1;
(statearr_72399_72489[(1)] = (51));

} else {
var statearr_72400_72490 = state_72380__$1;
(statearr_72400_72490[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (50))){
var inst_72350 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72350)){
var statearr_72401_72491 = state_72380__$1;
(statearr_72401_72491[(1)] = (54));

} else {
var statearr_72402_72492 = state_72380__$1;
(statearr_72402_72492[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (21))){
var inst_72293 = (state_72380[(2)]);
var inst_72294 = fluree.db.util.async.throw_err.call(null,inst_72293);
var state_72380__$1 = state_72380;
var statearr_72403_72493 = state_72380__$1;
(statearr_72403_72493[(2)] = inst_72294);

(statearr_72403_72493[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (31))){
var state_72380__$1 = state_72380;
var statearr_72404_72494 = state_72380__$1;
(statearr_72404_72494[(2)] = null);

(statearr_72404_72494[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (32))){
var inst_72321 = (state_72380[(16)]);
var inst_72266 = (state_72380[(17)]);
var inst_72320 = (state_72380[(2)]);
var inst_72321__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72266);
var state_72380__$1 = (function (){var statearr_72405 = state_72380;
(statearr_72405[(16)] = inst_72321__$1);

(statearr_72405[(10)] = inst_72320);

return statearr_72405;
})();
if(cljs.core.truth_(inst_72321__$1)){
var statearr_72406_72495 = state_72380__$1;
(statearr_72406_72495[(1)] = (33));

} else {
var statearr_72407_72496 = state_72380__$1;
(statearr_72407_72496[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (40))){
var inst_72263 = (state_72380[(18)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72263)){
var statearr_72408_72497 = state_72380__$1;
(statearr_72408_72497[(1)] = (42));

} else {
var statearr_72409_72498 = state_72380__$1;
(statearr_72409_72498[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (56))){
var inst_72300 = (state_72380[(9)]);
var inst_72326 = (state_72380[(19)]);
var inst_72359 = (state_72380[(2)]);
var inst_72360 = fluree.db.util.core.current_time_millis.call(null);
var inst_72361 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_72326);
var inst_72362 = fluree.db.query.fql.query.call(null,inst_72300,inst_72361);
var state_72380__$1 = (function (){var statearr_72410 = state_72380;
(statearr_72410[(20)] = inst_72359);

(statearr_72410[(11)] = inst_72360);

return statearr_72410;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72380__$1,(57),inst_72362);
} else {
if((state_val_72381 === (33))){
var inst_72321 = (state_72380[(16)]);
var state_72380__$1 = state_72380;
var statearr_72411_72499 = state_72380__$1;
(statearr_72411_72499[(2)] = inst_72321);

(statearr_72411_72499[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (13))){
var inst_72236 = (state_72380[(21)]);
var state_72380__$1 = state_72380;
var statearr_72412_72500 = state_72380__$1;
(statearr_72412_72500[(2)] = inst_72236);

(statearr_72412_72500[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (22))){
var inst_72260 = (state_72380[(22)]);
var inst_72289 = (state_72380[(2)]);
var inst_72290 = fluree.db.util.async.throw_err.call(null,inst_72289);
var inst_72291 = fluree.db.time_travel.as_of_block.call(null,inst_72290,inst_72260);
var state_72380__$1 = state_72380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72380__$1,(21),inst_72291);
} else {
if((state_val_72381 === (36))){
var inst_72259 = (state_72380[(23)]);
var state_72380__$1 = state_72380;
var statearr_72413_72501 = state_72380__$1;
(statearr_72413_72501[(2)] = inst_72259);

(statearr_72413_72501[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (41))){
var inst_72340 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72414_72502 = state_72380__$1;
(statearr_72414_72502[(2)] = inst_72340);

(statearr_72414_72502[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (43))){
var inst_72267 = (state_72380[(24)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72267)){
var statearr_72415_72503 = state_72380__$1;
(statearr_72415_72503[(1)] = (45));

} else {
var statearr_72416_72504 = state_72380__$1;
(statearr_72416_72504[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (29))){
var inst_72315 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72315)){
var statearr_72417_72505 = state_72380__$1;
(statearr_72417_72505[(1)] = (30));

} else {
var statearr_72418_72506 = state_72380__$1;
(statearr_72418_72506[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (44))){
var inst_72338 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72419_72507 = state_72380__$1;
(statearr_72419_72507[(2)] = inst_72338);

(statearr_72419_72507[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (6))){
var inst_72236 = (state_72380[(21)]);
var inst_72241 = inst_72236.cljs$lang$protocol_mask$partition0$;
var inst_72242 = (inst_72241 & (64));
var inst_72243 = inst_72236.cljs$core$ISeq$;
var inst_72244 = (cljs.core.PROTOCOL_SENTINEL === inst_72243);
var inst_72245 = ((inst_72242) || (inst_72244));
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72245)){
var statearr_72420_72508 = state_72380__$1;
(statearr_72420_72508[(1)] = (9));

} else {
var statearr_72421_72509 = state_72380__$1;
(statearr_72421_72509[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (28))){
var inst_72310 = (state_72380[(25)]);
var state_72380__$1 = state_72380;
var statearr_72422_72510 = state_72380__$1;
(statearr_72422_72510[(2)] = inst_72310);

(statearr_72422_72510[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (51))){
var inst_72265 = (state_72380[(15)]);
var state_72380__$1 = state_72380;
var statearr_72423_72511 = state_72380__$1;
(statearr_72423_72511[(2)] = inst_72265);

(statearr_72423_72511[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (25))){
var inst_72307 = cljs.core.PersistentHashMap.EMPTY;
var state_72380__$1 = state_72380;
var statearr_72424_72512 = state_72380__$1;
(statearr_72424_72512[(2)] = inst_72307);

(statearr_72424_72512[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (34))){
var state_72380__$1 = state_72380;
var statearr_72425_72513 = state_72380__$1;
(statearr_72425_72513[(2)] = (1000000));

(statearr_72425_72513[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (17))){
var inst_72260 = (state_72380[(22)]);
var inst_72285 = (state_72380[(2)]);
var inst_72286 = sources;
var state_72380__$1 = (function (){var statearr_72426 = state_72380;
(statearr_72426[(26)] = inst_72285);

(statearr_72426[(27)] = inst_72286);

return statearr_72426;
})();
if(cljs.core.truth_(inst_72260)){
var statearr_72427_72514 = state_72380__$1;
(statearr_72427_72514[(1)] = (18));

} else {
var statearr_72428_72515 = state_72380__$1;
(statearr_72428_72515[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (3))){
var inst_72378 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72380__$1,inst_72378);
} else {
if((state_val_72381 === (12))){
var inst_72236 = (state_72380[(21)]);
var inst_72254 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72236);
var state_72380__$1 = state_72380;
var statearr_72429_72516 = state_72380__$1;
(statearr_72429_72516[(2)] = inst_72254);

(statearr_72429_72516[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (2))){
var inst_72236 = (state_72380[(21)]);
var _ = (function (){var statearr_72430 = state_72380;
(statearr_72430[(4)] = cljs.core.cons.call(null,(5),(state_72380[(4)])));

return statearr_72430;
})();
var inst_72236__$1 = flureeQL;
var inst_72238 = (inst_72236__$1 == null);
var inst_72239 = cljs.core.not.call(null,inst_72238);
var state_72380__$1 = (function (){var statearr_72431 = state_72380;
(statearr_72431[(21)] = inst_72236__$1);

return statearr_72431;
})();
if(inst_72239){
var statearr_72432_72517 = state_72380__$1;
(statearr_72432_72517[(1)] = (6));

} else {
var statearr_72433_72518 = state_72380__$1;
(statearr_72433_72518[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (23))){
var inst_72297 = (state_72380[(2)]);
var inst_72298 = fluree.db.util.async.throw_err.call(null,inst_72297);
var state_72380__$1 = state_72380;
var statearr_72434_72519 = state_72380__$1;
(statearr_72434_72519[(2)] = inst_72298);

(statearr_72434_72519[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (47))){
var inst_72336 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72435_72520 = state_72380__$1;
(statearr_72435_72520[(2)] = inst_72336);

(statearr_72435_72520[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (35))){
var inst_72259 = (state_72380[(23)]);
var inst_72320 = (state_72380[(10)]);
var inst_72266 = (state_72380[(17)]);
var inst_72309 = (state_72380[(28)]);
var inst_72325 = (state_72380[(2)]);
var inst_72326 = cljs.core.assoc.call(null,inst_72266,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_72309,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_72325,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_72320);
var state_72380__$1 = (function (){var statearr_72436 = state_72380;
(statearr_72436[(19)] = inst_72326);

return statearr_72436;
})();
if(cljs.core.truth_(inst_72259)){
var statearr_72437_72521 = state_72380__$1;
(statearr_72437_72521[(1)] = (36));

} else {
var statearr_72438_72522 = state_72380__$1;
(statearr_72438_72522[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (19))){
var inst_72286 = (state_72380[(27)]);
var state_72380__$1 = state_72380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72380__$1,(23),inst_72286);
} else {
if((state_val_72381 === (57))){
var inst_72310 = (state_72380[(25)]);
var inst_72364 = (state_72380[(2)]);
var inst_72365 = fluree.db.util.async.throw_err.call(null,inst_72364);
var state_72380__$1 = (function (){var statearr_72439 = state_72380;
(statearr_72439[(7)] = inst_72365);

return statearr_72439;
})();
if(cljs.core.truth_(inst_72310)){
var statearr_72440_72523 = state_72380__$1;
(statearr_72440_72523[(1)] = (58));

} else {
var statearr_72441_72524 = state_72380__$1;
(statearr_72441_72524[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (11))){
var inst_72249 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72443_72525 = state_72380__$1;
(statearr_72443_72525[(2)] = inst_72249);

(statearr_72443_72525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (9))){
var state_72380__$1 = state_72380;
var statearr_72444_72526 = state_72380__$1;
(statearr_72444_72526[(2)] = true);

(statearr_72444_72526[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (5))){
var _ = (function (){var statearr_72445 = state_72380;
(statearr_72445[(4)] = cljs.core.rest.call(null,(state_72380[(4)])));

return statearr_72445;
})();
var state_72380__$1 = state_72380;
var ex72442 = (state_72380__$1[(2)]);
var statearr_72446_72527 = state_72380__$1;
(statearr_72446_72527[(5)] = ex72442);


if((ex72442 instanceof Error)){
var statearr_72447_72528 = state_72380__$1;
(statearr_72447_72528[(1)] = (4));

(statearr_72447_72528[(5)] = null);

} else {
throw ex72442;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (14))){
var inst_72262 = (state_72380[(8)]);
var inst_72267 = (state_72380[(24)]);
var inst_72263 = (state_72380[(18)]);
var inst_72261 = (state_72380[(29)]);
var inst_72259 = (state_72380[(23)]);
var inst_72265 = (state_72380[(15)]);
var inst_72260 = (state_72380[(22)]);
var inst_72258 = (state_72380[(14)]);
var inst_72264 = (state_72380[(13)]);
var inst_72266 = (state_72380[(17)]);
var inst_72257 = (state_72380[(2)]);
var inst_72258__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_72259__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_72260__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"block","block",664686210));
var inst_72261__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_72262__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_72263__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_72264__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_72265__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_72266__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_72267__$1 = cljs.core.get.call(null,inst_72257,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_72268 = (function (){var construct = inst_72258__$1;
var select = inst_72259__$1;
var map__72235 = inst_72257;
var block = inst_72260__$1;
var where = inst_72261__$1;
var prefixes = inst_72262__$1;
var selectDistinct = inst_72263__$1;
var selectOne = inst_72264__$1;
var from = inst_72265__$1;
var opts = inst_72266__$1;
var selectReduced = inst_72267__$1;
return (function (p1__72228_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__72228_SHARP_);
});
})();
var inst_72269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72270 = [inst_72259__$1,inst_72264__$1,inst_72263__$1,inst_72267__$1];
var inst_72271 = (new cljs.core.PersistentVector(null,4,(5),inst_72269,inst_72270,null));
var inst_72272 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_72271);
var inst_72273 = cljs.core.count.call(null,inst_72272);
var inst_72274 = inst_72268.call(null,inst_72273);
var state_72380__$1 = (function (){var statearr_72448 = state_72380;
(statearr_72448[(8)] = inst_72262__$1);

(statearr_72448[(24)] = inst_72267__$1);

(statearr_72448[(18)] = inst_72263__$1);

(statearr_72448[(29)] = inst_72261__$1);

(statearr_72448[(23)] = inst_72259__$1);

(statearr_72448[(15)] = inst_72265__$1);

(statearr_72448[(22)] = inst_72260__$1);

(statearr_72448[(14)] = inst_72258__$1);

(statearr_72448[(13)] = inst_72264__$1);

(statearr_72448[(17)] = inst_72266__$1);

return statearr_72448;
})();
if(cljs.core.truth_(inst_72274)){
var statearr_72449_72529 = state_72380__$1;
(statearr_72449_72529[(1)] = (15));

} else {
var statearr_72450_72530 = state_72380__$1;
(statearr_72450_72530[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (45))){
var inst_72267 = (state_72380[(24)]);
var state_72380__$1 = state_72380;
var statearr_72451_72531 = state_72380__$1;
(statearr_72451_72531[(2)] = inst_72267);

(statearr_72451_72531[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (53))){
var inst_72347 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
var statearr_72452_72532 = state_72380__$1;
(statearr_72452_72532[(2)] = inst_72347);

(statearr_72452_72532[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (26))){
var inst_72266 = (state_72380[(17)]);
var inst_72311 = (state_72380[(12)]);
var inst_72309 = (state_72380[(2)]);
var inst_72310 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_72266);
var inst_72311__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_72266);
var state_72380__$1 = (function (){var statearr_72453 = state_72380;
(statearr_72453[(25)] = inst_72310);

(statearr_72453[(28)] = inst_72309);

(statearr_72453[(12)] = inst_72311__$1);

return statearr_72453;
})();
if(cljs.core.truth_(inst_72311__$1)){
var statearr_72454_72533 = state_72380__$1;
(statearr_72454_72533[(1)] = (27));

} else {
var statearr_72455_72534 = state_72380__$1;
(statearr_72455_72534[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (16))){
var inst_72277 = cljs.core.pr_str.call(null,flureeQL);
var inst_72278 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_72277].join('');
var inst_72279 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_72280 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_72281 = cljs.core.PersistentHashMap.fromArrays(inst_72279,inst_72280);
var inst_72282 = cljs.core.ex_info.call(null,inst_72278,inst_72281);
var inst_72283 = (function(){throw inst_72282})();
var state_72380__$1 = state_72380;
var statearr_72456_72535 = state_72380__$1;
(statearr_72456_72535[(2)] = inst_72283);

(statearr_72456_72535[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (38))){
var inst_72342 = (state_72380[(30)]);
var inst_72342__$1 = (state_72380[(2)]);
var state_72380__$1 = (function (){var statearr_72457 = state_72380;
(statearr_72457[(30)] = inst_72342__$1);

return statearr_72457;
})();
if(cljs.core.truth_(inst_72342__$1)){
var statearr_72458_72536 = state_72380__$1;
(statearr_72458_72536[(1)] = (48));

} else {
var statearr_72459_72537 = state_72380__$1;
(statearr_72459_72537[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (30))){
var inst_72317 = cljs.core.volatile_BANG_.call(null,(0));
var state_72380__$1 = state_72380;
var statearr_72460_72538 = state_72380__$1;
(statearr_72460_72538[(2)] = inst_72317);

(statearr_72460_72538[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (10))){
var state_72380__$1 = state_72380;
var statearr_72461_72539 = state_72380__$1;
(statearr_72461_72539[(2)] = false);

(statearr_72461_72539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (18))){
var inst_72286 = (state_72380[(27)]);
var state_72380__$1 = state_72380;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72380__$1,(22),inst_72286);
} else {
if((state_val_72381 === (52))){
var inst_72261 = (state_72380[(29)]);
var state_72380__$1 = state_72380;
var statearr_72462_72540 = state_72380__$1;
(statearr_72462_72540[(2)] = inst_72261);

(statearr_72462_72540[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (42))){
var inst_72263 = (state_72380[(18)]);
var state_72380__$1 = state_72380;
var statearr_72463_72541 = state_72380__$1;
(statearr_72463_72541[(2)] = inst_72263);

(statearr_72463_72541[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (37))){
var inst_72264 = (state_72380[(13)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72264)){
var statearr_72464_72542 = state_72380__$1;
(statearr_72464_72542[(1)] = (39));

} else {
var statearr_72465_72543 = state_72380__$1;
(statearr_72465_72543[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (8))){
var inst_72252 = (state_72380[(2)]);
var state_72380__$1 = state_72380;
if(cljs.core.truth_(inst_72252)){
var statearr_72466_72544 = state_72380__$1;
(statearr_72466_72544[(1)] = (12));

} else {
var statearr_72467_72545 = state_72380__$1;
(statearr_72467_72545[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72381 === (49))){
var inst_72342 = (state_72380[(30)]);
var state_72380__$1 = state_72380;
var statearr_72468_72546 = state_72380__$1;
(statearr_72468_72546[(2)] = inst_72342);

(statearr_72468_72546[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__11469__auto____0 = (function (){
var statearr_72469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72469[(0)] = fluree$db$api$query$query_async_$_state_machine__11469__auto__);

(statearr_72469[(1)] = (1));

return statearr_72469;
});
var fluree$db$api$query$query_async_$_state_machine__11469__auto____1 = (function (state_72380){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_72380);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e72470){var ex__11472__auto__ = e72470;
var statearr_72471_72547 = state_72380;
(statearr_72471_72547[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_72380[(4)]))){
var statearr_72472_72548 = state_72380;
(statearr_72472_72548[(1)] = cljs.core.first.call(null,(state_72380[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72549 = state_72380;
state_72380 = G__72549;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__11469__auto__ = function(state_72380){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__11469__auto____1.call(this,state_72380);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__11469__auto____0;
fluree$db$api$query$query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__11469__auto____1;
return fluree$db$api$query$query_async_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_72473 = f__11543__auto__.call(null);
(statearr_72473[(6)] = c__11542__auto__);

return statearr_72473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_72703){
var state_val_72704 = (state_72703[(1)]);
if((state_val_72704 === (7))){
var inst_72698 = (state_72703[(2)]);
var _ = (function (){var statearr_72705 = state_72703;
(statearr_72705[(4)] = cljs.core.rest.call(null,(state_72703[(4)])));

return statearr_72705;
})();
var state_72703__$1 = state_72703;
var statearr_72706_72785 = state_72703__$1;
(statearr_72706_72785[(2)] = inst_72698);

(statearr_72706_72785[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (20))){
var inst_72619 = (state_72703[(7)]);
var inst_72637 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72619);
var state_72703__$1 = state_72703;
var statearr_72707_72786 = state_72703__$1;
(statearr_72707_72786[(2)] = inst_72637);

(statearr_72707_72786[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (27))){
var inst_72647 = (state_72703[(8)]);
var state_72703__$1 = state_72703;
var statearr_72708_72787 = state_72703__$1;
(statearr_72708_72787[(2)] = inst_72647);

(statearr_72708_72787[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (1))){
var state_72703__$1 = state_72703;
var statearr_72709_72788 = state_72703__$1;
(statearr_72709_72788[(2)] = null);

(statearr_72709_72788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (24))){
var inst_72589 = (state_72703[(9)]);
var inst_72644 = (state_72703[(10)]);
var inst_72647 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_72644);
var inst_72648 = (inst_72589 == null);
var state_72703__$1 = (function (){var statearr_72710 = state_72703;
(statearr_72710[(8)] = inst_72647);

return statearr_72710;
})();
if(cljs.core.truth_(inst_72648)){
var statearr_72711_72789 = state_72703__$1;
(statearr_72711_72789[(1)] = (27));

} else {
var statearr_72712_72790 = state_72703__$1;
(statearr_72712_72790[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (39))){
var inst_72644 = (state_72703[(10)]);
var inst_72590 = (state_72703[(11)]);
var inst_72675 = cljs.core.get.call(null,inst_72644,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_72676 = (inst_72590 + inst_72675);
var state_72703__$1 = state_72703;
var statearr_72713_72791 = state_72703__$1;
(statearr_72713_72791[(2)] = inst_72676);

(statearr_72713_72791[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (46))){
var inst_72644 = (state_72703[(10)]);
var state_72703__$1 = state_72703;
var statearr_72714_72792 = state_72703__$1;
(statearr_72714_72792[(2)] = inst_72644);

(statearr_72714_72792[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (4))){
var inst_72550 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72715_72793 = state_72703__$1;
(statearr_72715_72793[(2)] = inst_72550);

(statearr_72715_72793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (15))){
var state_72703__$1 = state_72703;
var statearr_72716_72794 = state_72703__$1;
(statearr_72716_72794[(2)] = false);

(statearr_72716_72794[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (21))){
var inst_72619 = (state_72703[(7)]);
var state_72703__$1 = state_72703;
var statearr_72717_72795 = state_72703__$1;
(statearr_72717_72795[(2)] = inst_72619);

(statearr_72717_72795[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (31))){
var inst_72589 = (state_72703[(9)]);
var inst_72647 = (state_72703[(8)]);
var inst_72654 = cljs.core._EQ_.call(null,(200),inst_72647);
var inst_72655 = cljs.core._EQ_.call(null,(200),inst_72589);
var inst_72656 = cljs.core._EQ_.call(null,(207),inst_72589);
var inst_72657 = ((inst_72654) || (inst_72655) || (inst_72656));
var state_72703__$1 = state_72703;
if(cljs.core.truth_(inst_72657)){
var statearr_72718_72796 = state_72703__$1;
(statearr_72718_72796[(1)] = (33));

} else {
var statearr_72719_72797 = state_72703__$1;
(statearr_72719_72797[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (32))){
var inst_72668 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72720_72798 = state_72703__$1;
(statearr_72720_72798[(2)] = inst_72668);

(statearr_72720_72798[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (40))){
var state_72703__$1 = state_72703;
var statearr_72721_72799 = state_72703__$1;
(statearr_72721_72799[(2)] = null);

(statearr_72721_72799[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (33))){
var state_72703__$1 = state_72703;
var statearr_72722_72800 = state_72703__$1;
(statearr_72722_72800[(2)] = (207));

(statearr_72722_72800[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (13))){
var inst_72613 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72723_72801 = state_72703__$1;
(statearr_72723_72801[(2)] = inst_72613);

(statearr_72723_72801[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (22))){
var inst_72603 = (state_72703[(12)]);
var inst_72640 = (state_72703[(2)]);
var inst_72641 = cljs.core.get.call(null,inst_72640,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_72642 = cljs.core.get.call(null,inst_72640,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_72703__$1 = (function (){var statearr_72724 = state_72703;
(statearr_72724[(13)] = inst_72642);

(statearr_72724[(14)] = inst_72641);

return statearr_72724;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72703__$1,(23),inst_72603);
} else {
if((state_val_72704 === (36))){
var inst_72589 = (state_72703[(9)]);
var inst_72647 = (state_72703[(8)]);
var inst_72661 = ((inst_72647 > inst_72589) ? inst_72647 : inst_72589);
var state_72703__$1 = state_72703;
var statearr_72725_72802 = state_72703__$1;
(statearr_72725_72802[(2)] = inst_72661);

(statearr_72725_72802[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (41))){
var inst_72645 = (state_72703[(15)]);
var inst_72679 = (state_72703[(2)]);
var state_72703__$1 = (function (){var statearr_72726 = state_72703;
(statearr_72726[(16)] = inst_72679);

return statearr_72726;
})();
if(cljs.core.truth_(inst_72645)){
var statearr_72727_72803 = state_72703__$1;
(statearr_72727_72803[(1)] = (42));

} else {
var statearr_72728_72804 = state_72703__$1;
(statearr_72728_72804[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (43))){
var inst_72642 = (state_72703[(13)]);
var state_72703__$1 = state_72703;
if(cljs.core.truth_(inst_72642)){
var statearr_72729_72805 = state_72703__$1;
(statearr_72729_72805[(1)] = (45));

} else {
var statearr_72730_72806 = state_72703__$1;
(statearr_72730_72806[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (29))){
var inst_72670 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72731_72807 = state_72703__$1;
(statearr_72731_72807[(2)] = inst_72670);

(statearr_72731_72807[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (44))){
var inst_72601 = (state_72703[(17)]);
var inst_72673 = (state_72703[(18)]);
var inst_72679 = (state_72703[(16)]);
var inst_72693 = (state_72703[(2)]);
var inst_72588 = inst_72601;
var inst_72589 = inst_72673;
var inst_72590 = inst_72679;
var inst_72591 = inst_72693;
var state_72703__$1 = (function (){var statearr_72732 = state_72703;
(statearr_72732[(9)] = inst_72589);

(statearr_72732[(19)] = inst_72588);

(statearr_72732[(11)] = inst_72590);

(statearr_72732[(20)] = inst_72591);

return statearr_72732;
})();
var statearr_72733_72808 = state_72703__$1;
(statearr_72733_72808[(2)] = null);

(statearr_72733_72808[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (6))){
var inst_72588 = (state_72703[(19)]);
var inst_72603 = (state_72703[(12)]);
var inst_72599 = cljs.core.seq.call(null,inst_72588);
var inst_72600 = cljs.core.first.call(null,inst_72599);
var inst_72601 = cljs.core.next.call(null,inst_72599);
var inst_72602 = cljs.core.nth.call(null,inst_72600,(0),null);
var inst_72603__$1 = cljs.core.nth.call(null,inst_72600,(1),null);
var inst_72604 = (inst_72603__$1 == null);
var state_72703__$1 = (function (){var statearr_72734 = state_72703;
(statearr_72734[(21)] = inst_72602);

(statearr_72734[(17)] = inst_72601);

(statearr_72734[(12)] = inst_72603__$1);

return statearr_72734;
})();
if(cljs.core.truth_(inst_72604)){
var statearr_72735_72809 = state_72703__$1;
(statearr_72735_72809[(1)] = (8));

} else {
var statearr_72736_72810 = state_72703__$1;
(statearr_72736_72810[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (28))){
var inst_72589 = (state_72703[(9)]);
var inst_72647 = (state_72703[(8)]);
var inst_72651 = cljs.core._EQ_.call(null,inst_72589,inst_72647);
var state_72703__$1 = state_72703;
if(inst_72651){
var statearr_72737_72811 = state_72703__$1;
(statearr_72737_72811[(1)] = (30));

} else {
var statearr_72738_72812 = state_72703__$1;
(statearr_72738_72812[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (25))){
var state_72703__$1 = state_72703;
var statearr_72739_72813 = state_72703__$1;
(statearr_72739_72813[(2)] = null);

(statearr_72739_72813[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (34))){
var state_72703__$1 = state_72703;
var statearr_72740_72814 = state_72703__$1;
(statearr_72740_72814[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (17))){
var state_72703__$1 = state_72703;
var statearr_72742_72815 = state_72703__$1;
(statearr_72742_72815[(2)] = true);

(statearr_72742_72815[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (3))){
var inst_72701 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72703__$1,inst_72701);
} else {
if((state_val_72704 === (12))){
var inst_72591 = (state_72703[(20)]);
var state_72703__$1 = state_72703;
var statearr_72743_72816 = state_72703__$1;
(statearr_72743_72816[(2)] = inst_72591);

(statearr_72743_72816[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (2))){
var inst_72564 = (state_72703[(22)]);
var inst_72565 = (state_72703[(23)]);
var inst_72560 = (state_72703[(24)]);
var _ = (function (){var statearr_72744 = state_72703;
(statearr_72744[(4)] = cljs.core.cons.call(null,(5),(state_72703[(4)])));

return statearr_72744;
})();
var inst_72556 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_72557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72558 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_72559 = (new cljs.core.PersistentVector(null,2,(5),inst_72557,inst_72558,null));
var inst_72560__$1 = cljs.core.get_in.call(null,flureeQL,inst_72559);
var inst_72561 = (function (){var global_block = inst_72556;
var global_meta_QMARK_ = inst_72560__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_72562 = cljs.core.PersistentHashMap.EMPTY;
var inst_72563 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_72564__$1 = cljs.core.reduce_kv.call(null,inst_72561,inst_72562,inst_72563);
var inst_72565__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_72567 = (function (){var global_block = inst_72556;
var global_meta_QMARK_ = inst_72560__$1;
var queries = inst_72564__$1;
var start_time = inst_72565__$1;
return (function (p__72566){
var vec__72745 = p__72566;
var alias = cljs.core.nth.call(null,vec__72745,(0),null);
var q = cljs.core.nth.call(null,vec__72745,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_72568 = cljs.core.map.call(null,inst_72567,inst_72564__$1);
var inst_72582 = cljs.core.seq.call(null,inst_72568);
var inst_72583 = cljs.core.first.call(null,inst_72582);
var inst_72584 = cljs.core.next.call(null,inst_72582);
var inst_72585 = cljs.core.nth.call(null,inst_72583,(0),null);
var inst_72586 = cljs.core.nth.call(null,inst_72583,(1),null);
var inst_72587 = cljs.core.PersistentHashMap.EMPTY;
var inst_72588 = inst_72568;
var inst_72589 = null;
var inst_72590 = (0);
var inst_72591 = inst_72587;
var state_72703__$1 = (function (){var statearr_72748 = state_72703;
(statearr_72748[(9)] = inst_72589);

(statearr_72748[(22)] = inst_72564__$1);

(statearr_72748[(25)] = inst_72585);

(statearr_72748[(19)] = inst_72588);

(statearr_72748[(23)] = inst_72565__$1);

(statearr_72748[(26)] = inst_72584);

(statearr_72748[(24)] = inst_72560__$1);

(statearr_72748[(11)] = inst_72590);

(statearr_72748[(20)] = inst_72591);

(statearr_72748[(27)] = inst_72586);

return statearr_72748;
})();
var statearr_72749_72817 = state_72703__$1;
(statearr_72749_72817[(2)] = null);

(statearr_72749_72817[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (23))){
var inst_72644 = (state_72703[(10)]);
var inst_72641 = (state_72703[(14)]);
var inst_72644__$1 = (state_72703[(2)]);
var inst_72645 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_72644__$1);
var state_72703__$1 = (function (){var statearr_72750 = state_72703;
(statearr_72750[(10)] = inst_72644__$1);

(statearr_72750[(15)] = inst_72645);

return statearr_72750;
})();
if(cljs.core.truth_(inst_72641)){
var statearr_72751_72818 = state_72703__$1;
(statearr_72751_72818[(1)] = (24));

} else {
var statearr_72752_72819 = state_72703__$1;
(statearr_72752_72819[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (47))){
var inst_72602 = (state_72703[(21)]);
var inst_72591 = (state_72703[(20)]);
var inst_72690 = (state_72703[(2)]);
var inst_72691 = cljs.core.assoc.call(null,inst_72591,inst_72602,inst_72690);
var state_72703__$1 = state_72703;
var statearr_72753_72820 = state_72703__$1;
(statearr_72753_72820[(2)] = inst_72691);

(statearr_72753_72820[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (35))){
var inst_72666 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72754_72821 = state_72703__$1;
(statearr_72754_72821[(2)] = inst_72666);

(statearr_72754_72821[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (19))){
var inst_72632 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72755_72822 = state_72703__$1;
(statearr_72755_72822[(2)] = inst_72632);

(statearr_72755_72822[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (11))){
var inst_72589 = (state_72703[(9)]);
var inst_72565 = (state_72703[(23)]);
var inst_72590 = (state_72703[(11)]);
var inst_72591 = (state_72703[(20)]);
var inst_72607 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_72608 = fluree.db.api.query.response_time_formatted.call(null,inst_72565);
var inst_72609 = [inst_72591,inst_72590,inst_72589,inst_72608];
var inst_72610 = cljs.core.PersistentHashMap.fromArrays(inst_72607,inst_72609);
var state_72703__$1 = state_72703;
var statearr_72757_72823 = state_72703__$1;
(statearr_72757_72823[(2)] = inst_72610);

(statearr_72757_72823[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (9))){
var inst_72602 = (state_72703[(21)]);
var inst_72619 = (state_72703[(7)]);
var inst_72564 = (state_72703[(22)]);
var inst_72616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72617 = [inst_72602,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_72618 = (new cljs.core.PersistentVector(null,2,(5),inst_72616,inst_72617,null));
var inst_72619__$1 = cljs.core.get_in.call(null,inst_72564,inst_72618);
var inst_72621 = (inst_72619__$1 == null);
var inst_72622 = cljs.core.not.call(null,inst_72621);
var state_72703__$1 = (function (){var statearr_72758 = state_72703;
(statearr_72758[(7)] = inst_72619__$1);

return statearr_72758;
})();
if(inst_72622){
var statearr_72759_72824 = state_72703__$1;
(statearr_72759_72824[(1)] = (14));

} else {
var statearr_72760_72825 = state_72703__$1;
(statearr_72760_72825[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (5))){
var _ = (function (){var statearr_72761 = state_72703;
(statearr_72761[(4)] = cljs.core.rest.call(null,(state_72703[(4)])));

return statearr_72761;
})();
var state_72703__$1 = state_72703;
var ex72756 = (state_72703__$1[(2)]);
var statearr_72762_72826 = state_72703__$1;
(statearr_72762_72826[(5)] = ex72756);


var statearr_72763_72827 = state_72703__$1;
(statearr_72763_72827[(1)] = (4));

(statearr_72763_72827[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (14))){
var inst_72619 = (state_72703[(7)]);
var inst_72624 = inst_72619.cljs$lang$protocol_mask$partition0$;
var inst_72625 = (inst_72624 & (64));
var inst_72626 = inst_72619.cljs$core$ISeq$;
var inst_72627 = (cljs.core.PROTOCOL_SENTINEL === inst_72626);
var inst_72628 = ((inst_72625) || (inst_72627));
var state_72703__$1 = state_72703;
if(cljs.core.truth_(inst_72628)){
var statearr_72764_72828 = state_72703__$1;
(statearr_72764_72828[(1)] = (17));

} else {
var statearr_72765_72829 = state_72703__$1;
(statearr_72765_72829[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (45))){
var inst_72644 = (state_72703[(10)]);
var inst_72687 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_72644);
var state_72703__$1 = state_72703;
var statearr_72766_72830 = state_72703__$1;
(statearr_72766_72830[(2)] = inst_72687);

(statearr_72766_72830[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (26))){
var inst_72641 = (state_72703[(14)]);
var inst_72673 = (state_72703[(2)]);
var state_72703__$1 = (function (){var statearr_72767 = state_72703;
(statearr_72767[(18)] = inst_72673);

return statearr_72767;
})();
if(cljs.core.truth_(inst_72641)){
var statearr_72768_72831 = state_72703__$1;
(statearr_72768_72831[(1)] = (39));

} else {
var statearr_72769_72832 = state_72703__$1;
(statearr_72769_72832[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (16))){
var inst_72635 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
if(cljs.core.truth_(inst_72635)){
var statearr_72770_72833 = state_72703__$1;
(statearr_72770_72833[(1)] = (20));

} else {
var statearr_72771_72834 = state_72703__$1;
(statearr_72771_72834[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (38))){
var inst_72664 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72772_72835 = state_72703__$1;
(statearr_72772_72835[(2)] = inst_72664);

(statearr_72772_72835[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (30))){
var inst_72647 = (state_72703[(8)]);
var state_72703__$1 = state_72703;
var statearr_72773_72836 = state_72703__$1;
(statearr_72773_72836[(2)] = inst_72647);

(statearr_72773_72836[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (10))){
var inst_72696 = (state_72703[(2)]);
var state_72703__$1 = state_72703;
var statearr_72774_72837 = state_72703__$1;
(statearr_72774_72837[(2)] = inst_72696);

(statearr_72774_72837[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (18))){
var state_72703__$1 = state_72703;
var statearr_72775_72838 = state_72703__$1;
(statearr_72775_72838[(2)] = false);

(statearr_72775_72838[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (42))){
var inst_72602 = (state_72703[(21)]);
var inst_72644 = (state_72703[(10)]);
var inst_72591 = (state_72703[(20)]);
var inst_72681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72682 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_72602];
var inst_72683 = (new cljs.core.PersistentVector(null,2,(5),inst_72681,inst_72682,null));
var inst_72684 = cljs.core.assoc_in.call(null,inst_72591,inst_72683,inst_72644);
var state_72703__$1 = state_72703;
var statearr_72776_72839 = state_72703__$1;
(statearr_72776_72839[(2)] = inst_72684);

(statearr_72776_72839[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (37))){
var state_72703__$1 = state_72703;
var statearr_72777_72840 = state_72703__$1;
(statearr_72777_72840[(2)] = null);

(statearr_72777_72840[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72704 === (8))){
var inst_72560 = (state_72703[(24)]);
var state_72703__$1 = state_72703;
if(cljs.core.truth_(inst_72560)){
var statearr_72778_72841 = state_72703__$1;
(statearr_72778_72841[(1)] = (11));

} else {
var statearr_72779_72842 = state_72703__$1;
(statearr_72779_72842[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____0 = (function (){
var statearr_72780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72780[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__);

(statearr_72780[(1)] = (1));

return statearr_72780;
});
var fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____1 = (function (state_72703){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_72703);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e72781){var ex__11472__auto__ = e72781;
var statearr_72782_72843 = state_72703;
(statearr_72782_72843[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_72703[(4)]))){
var statearr_72783_72844 = state_72703;
(statearr_72783_72844[(1)] = cljs.core.first.call(null,(state_72703[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72845 = state_72703;
state_72703 = G__72845;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__ = function(state_72703){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____1.call(this,state_72703);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__11469__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_72784 = f__11543__auto__.call(null);
(statearr_72784[(6)] = c__11542__auto__);

return statearr_72784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__72846 = query_type;
var G__72846__$1 = (((G__72846 instanceof cljs.core.Keyword))?G__72846.fqn:null);
switch (G__72846__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72846__$1)].join('')));

}
});
