// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.spec');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.json');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
fluree.db.spec.EMAIL = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
fluree.db.spec.safe_name = (function fluree$db$spec$safe_name(x){
try{return cljs.core.name(x);
}catch (e36584){var e = e36584;
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}});
/**
 * (type-check type object) transforms a object to match the type. If it cannot be transformed, it throws an ex-info with a map from paths into the object to errors encountered at those paths.
 */
fluree.db.spec.type_check = (function fluree$db$spec$type_check(var_args){
var G__36587 = arguments.length;
switch (G__36587) {
case 2:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2 = (function (object,spec){
var errors = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var conformed = fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4(object,spec,cljs.core.PersistentVector.EMPTY,errors);
var error_seq = cljs.core.reduce_kv((function (e,k,v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(e,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,cljs.core.cst$kw$path,k));
}),cljs.core.PersistentVector.EMPTY,cljs.core.deref(errors));
if(cljs.core.empty_QMARK_(error_seq)){
return conformed;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Could not conform object: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([object], 0))," to type ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([spec], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$body,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$message,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.print_str,"Validation error.",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__36585_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(p1__36585_SHARP_))," at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.spec.safe_name,cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(p1__36585_SHARP_))),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.spec.safe_name(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(p1__36585_SHARP_)))," but got \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$object.cljs$core$IFn$_invoke$arity$1(p1__36585_SHARP_)),"\"."].join('');
}),error_seq)),cljs.core.cst$kw$errors,error_seq], null)], null));
}
}));

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4 = (function (object,spec,path,errors_atom){
try{var error = (function() { 
var G__36597__delegate = function (p__36589){
var vec__36590 = p__36589;
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36590,(0),null);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Invalid object";
}
})(),cljs.core.PersistentArrayMap.EMPTY);
};
var G__36597 = function (var_args){
var p__36589 = null;
if (arguments.length > 0) {
var G__36598__i = 0, G__36598__a = new Array(arguments.length -  0);
while (G__36598__i < G__36598__a.length) {G__36598__a[G__36598__i] = arguments[G__36598__i + 0]; ++G__36598__i;}
  p__36589 = new cljs.core.IndexedSeq(G__36598__a,0,null);
} 
return G__36597__delegate.call(this,p__36589);};
G__36597.cljs$lang$maxFixedArity = 0;
G__36597.cljs$lang$applyTo = (function (arglist__36599){
var p__36589 = cljs.core.seq(arglist__36599);
return G__36597__delegate(p__36589);
});
G__36597.cljs$core$IFn$_invoke$arity$variadic = G__36597__delegate;
return G__36597;
})()
;
var spec__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.name(spec):spec);
if((spec__$1 == null)){
if((object == null)){
return object;
} else {
return error();
}
} else {
if(typeof spec__$1 === 'string'){
var optional = spec__$1.endsWith("?");
var base_spec = (cljs.core.truth_(optional)?cljs.core.subs.cljs$core$IFn$_invoke$arity$3(spec__$1,(0),(spec__$1.length() - (1))):spec__$1);
if(cljs.core.truth_((function (){var and__4115__auto__ = optional;
if(cljs.core.truth_(and__4115__auto__)){
return (object == null);
} else {
return and__4115__auto__;
}
})())){
return null;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"any")){
return object;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"boolean")){
if(cljs.core.boolean_QMARK_(object)){
return object;
} else {
return error();
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"int")){
return (object | (0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"long")){
if(typeof object === 'number'){
return cljs.core.long$(object);
} else {
if(typeof object === 'string'){
var i = parseInt(object);
if((((fluree.db.util.core.min_long <= i)) && ((i <= fluree.db.util.core.max_long)))){
return i;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Long ",object," is outside of javascript max integer size of 2^53 - 1."].join('')], 0));
}
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bigint")){
var i = ((typeof object === 'string')?parseInt(object):object);
if((((fluree.db.util.core.min_long <= i)) && ((i <= fluree.db.util.core.max_long)))){
return i;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Bigintegers are not supported in javascript. max integer size of 2^53 - 1, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join('')], 0));
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"float")){
if(typeof object === 'number'){
return object;
} else {
return error();
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"double")){
if(typeof object === 'number'){
return object;
} else {
if(typeof object === 'string'){
return parseFloat(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bigdec")){
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Javascript does not support big decimals. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join('')], 0));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"string")){
if((object instanceof cljs.core.Keyword)){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(object),(1));
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);

}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"bytes")){
if(typeof object === 'string'){
var uc = object.toLowerCase();
if(cljs.core.truth_(cljs.core.re_matches(/^[0-9a-f]+$/,uc))){
return uc;
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bytes type must be in hex string form."], 0));
}
} else {
if(cljs.core.sequential_QMARK_(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$1(object))){
return alphabase.core.bytes__GT_hex(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"instant")){
try{return fluree.db.util.core.date__GT_millis(object);
}catch (e36593){var e = e36593;
return error();
}} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"uri")){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"email")){
if(cljs.core.truth_(((typeof object === 'string')?cljs.core.re_find(fluree.db.spec.EMAIL,object):false))){
return object;
} else {
return error();
}
} else {
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"tag")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"ref")))){
return cljs.core.long$(object);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"uuid")){
if(typeof object === 'string'){
return object;
} else {
if(cljs.core.uuid_QMARK_(object)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
return error();

}
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"json")){
try{if(typeof object === 'string'){
fluree.db.util.json.parse(object);

return object;
} else {
return fluree.db.util.json.stringify(object);
}
}catch (e36594){var _ = e36594;
return error();
}} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(base_spec,"geojson")){
try{var parsed = ((typeof object === 'string')?fluree.db.util.json.parse(object):object);
if(cljs.core.truth_((fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(parsed) : fluree.db.util.json.valid_geojson_QMARK_.call(null,parsed)))){
if(typeof object === 'string'){
return object;
} else {
return fluree.db.util.json.stringify(object);
}
} else {
return error();
}
}catch (e36595){var _ = e36595;
return error();
}} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Unknown base spec ",base_spec].join('')], 0));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
} else {
return error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Unknown type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join('')], 0));

}
}
}catch (e36588){var e = e36588;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(errors_atom,cljs.core.assoc,path,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$message,cljs.core.str.cljs$core$IFn$_invoke$arity$1(e),cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$object,object], null));

return object;
}}));

(fluree.db.spec.type_check.cljs$lang$maxFixedArity = 4);

