// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37897 = null;
var G__37897__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37897__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37897__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37897 = function(result,flake){
switch(arguments.length){
case 0:
return G__37897__0.call(this);
case 1:
return G__37897__1.call(this,result);
case 2:
return G__37897__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37897.cljs$core$IFn$_invoke$arity$0 = G__37897__0;
G__37897.cljs$core$IFn$_invoke$arity$1 = G__37897__1;
G__37897.cljs$core$IFn$_invoke$arity$2 = G__37897__2;
return G__37897;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37898 = null;
var G__37898__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37898__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37898__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37898 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37898__0.call(this);
case 1:
return G__37898__1.call(this,result);
case 2:
return G__37898__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37898.cljs$core$IFn$_invoke$arity$0 = G__37898__0;
G__37898.cljs$core$IFn$_invoke$arity$1 = G__37898__1;
G__37898.cljs$core$IFn$_invoke$arity$2 = G__37898__2;
return G__37898;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37900 = res;
var G__37900__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37899_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37899_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37900):G__37900);
var G__37900__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37900__$1):G__37900__$1);
var G__37900__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37900__$2):G__37900__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37900__$3);
} else {
return G__37900__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37902 = arguments.length;
switch (G__37902) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_38205){
var state_val_38206 = (state_38205[(1)]);
if((state_val_38206 === (65))){
var inst_37932 = (state_38205[(7)]);
var inst_38063 = (state_38205[(8)]);
var inst_38056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38057 = cljs.core.deref(cache);
var inst_38058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38059 = flake.o;
var inst_38060 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38061 = [inst_38059,inst_38060];
var inst_38062 = (new cljs.core.PersistentVector(null,2,(5),inst_38058,inst_38061,null));
var inst_38063__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38057,inst_38062);
var state_38205__$1 = (function (){var statearr_38207 = state_38205;
(statearr_38207[(8)] = inst_38063__$1);

(statearr_38207[(9)] = inst_38056);

return statearr_38207;
})();
if(cljs.core.truth_(inst_38063__$1)){
var statearr_38208_38374 = state_38205__$1;
(statearr_38208_38374[(1)] = (68));

} else {
var statearr_38209_38375 = state_38205__$1;
(statearr_38209_38375[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (70))){
var inst_38056 = (state_38205[(9)]);
var inst_38081 = (state_38205[(2)]);
var inst_38082 = [inst_38081,offset_map];
var inst_38083 = (new cljs.core.PersistentVector(null,2,(5),inst_38056,inst_38082,null));
var state_38205__$1 = state_38205;
var statearr_38210_38376 = state_38205__$1;
(statearr_38210_38376[(2)] = inst_38083);

(statearr_38210_38376[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (62))){
var inst_37965 = (state_38205[(10)]);
var inst_38041 = (state_38205[(11)]);
var inst_37970 = (state_38205[(12)]);
var inst_37964 = (state_38205[(13)]);
var inst_37968 = (state_38205[(14)]);
var inst_37967 = (state_38205[(15)]);
var inst_37943 = (state_38205[(16)]);
var inst_37966 = (state_38205[(17)]);
var inst_37926 = (state_38205[(18)]);
var inst_37932 = (state_38205[(7)]);
var inst_37969 = (state_38205[(19)]);
var inst_38025 = (state_38205[(20)]);
var inst_38043 = (function (){var p = inst_37970;
var pred_spec__$1 = inst_37926;
var orderBy = inst_37968;
var nested_select_spec = inst_38025;
var map__37909 = inst_37964;
var G__38027 = inst_38041;
var multi_QMARK_ = inst_37965;
var limit = inst_37967;
var offset = inst_37969;
var k = inst_37943;
var pred_spec_SINGLEQUOTE_ = inst_37932;
var ref_QMARK_ = inst_37966;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_38044 = (inst_38043.cljs$core$IFn$_invoke$arity$1 ? inst_38043.cljs$core$IFn$_invoke$arity$1(inst_38041) : inst_38043.call(null,inst_38041));
var state_38205__$1 = state_38205;
var statearr_38211_38377 = state_38205__$1;
(statearr_38211_38377[(2)] = inst_38044);

(statearr_38211_38377[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (74))){
var inst_38090 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_38090)){
var statearr_38212_38378 = state_38205__$1;
(statearr_38212_38378[(1)] = (75));

} else {
var statearr_38213_38379 = state_38205__$1;
(statearr_38213_38379[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (7))){
var inst_37913 = (state_38205[(21)]);
var state_38205__$1 = state_38205;
var statearr_38214_38380 = state_38205__$1;
(statearr_38214_38380[(2)] = inst_37913);

(statearr_38214_38380[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (59))){
var inst_38035 = (state_38205[(22)]);
var inst_38037 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_38038 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38037,inst_38035);
var state_38205__$1 = state_38205;
var statearr_38215_38381 = state_38205__$1;
(statearr_38215_38381[(2)] = inst_38038);

(statearr_38215_38381[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (86))){
var inst_37965 = (state_38205[(10)]);
var inst_37970 = (state_38205[(12)]);
var inst_37964 = (state_38205[(13)]);
var inst_37968 = (state_38205[(14)]);
var inst_37967 = (state_38205[(15)]);
var inst_37943 = (state_38205[(16)]);
var inst_38103 = (state_38205[(23)]);
var inst_37966 = (state_38205[(17)]);
var inst_38121 = (state_38205[(24)]);
var inst_37926 = (state_38205[(18)]);
var inst_37932 = (state_38205[(7)]);
var inst_37969 = (state_38205[(19)]);
var inst_38123 = (function (){var p = inst_37970;
var pred_spec__$1 = inst_37926;
var orderBy = inst_37968;
var children = inst_38103;
var map__37909 = inst_37964;
var multi_QMARK_ = inst_37965;
var limit = inst_37967;
var offset = inst_37969;
var k = inst_37943;
var G__38115 = inst_38121;
var pred_spec_SINGLEQUOTE_ = inst_37932;
var ref_QMARK_ = inst_37966;
return (function (n){
var G__38216 = db;
var G__38217 = cache;
var G__38218 = fuel;
var G__38219 = max_fuel;
var G__38220 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__38221 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__38216,G__38217,G__38218,G__38219,G__38220,G__38221) : fluree.db.query.fql.flakes__GT_res.call(null,G__38216,G__38217,G__38218,G__38219,G__38220,G__38221));
});
})();
var inst_38124 = (inst_38123.cljs$core$IFn$_invoke$arity$1 ? inst_38123.cljs$core$IFn$_invoke$arity$1(inst_38121) : inst_38123.call(null,inst_38121));
var state_38205__$1 = state_38205;
var statearr_38222_38382 = state_38205__$1;
(statearr_38222_38382[(2)] = inst_38124);

(statearr_38222_38382[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (20))){
var inst_37941 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38223_38383 = state_38205__$1;
(statearr_38223_38383[(2)] = inst_37941);

(statearr_38223_38383[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (72))){
var inst_37932 = (state_38205[(7)]);
var inst_38087 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = state_38205;
var statearr_38224_38384 = state_38205__$1;
(statearr_38224_38384[(2)] = inst_38087);

(statearr_38224_38384[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (58))){
var inst_38034 = (state_38205[(2)]);
var inst_38035 = fluree.db.util.async.throw_err(inst_38034);
var state_38205__$1 = (function (){var statearr_38225 = state_38205;
(statearr_38225[(22)] = inst_38035);

return statearr_38225;
})();
if(cljs.core.truth_(fuel)){
var statearr_38226_38385 = state_38205__$1;
(statearr_38226_38385[(1)] = (59));

} else {
var statearr_38227_38386 = state_38205__$1;
(statearr_38227_38386[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (60))){
var inst_38035 = (state_38205[(22)]);
var state_38205__$1 = state_38205;
var statearr_38228_38387 = state_38205__$1;
(statearr_38228_38387[(2)] = inst_38035);

(statearr_38228_38387[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (27))){
var inst_37932 = (state_38205[(7)]);
var inst_37961 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37932);
var state_38205__$1 = state_38205;
var statearr_38229_38388 = state_38205__$1;
(statearr_38229_38388[(2)] = inst_37961);

(statearr_38229_38388[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (1))){
var state_38205__$1 = state_38205;
var statearr_38230_38389 = state_38205__$1;
(statearr_38230_38389[(2)] = null);

(statearr_38230_38389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (69))){
var inst_37932 = (state_38205[(7)]);
var inst_38066 = flake.o;
var inst_38067 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38068 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_38066,inst_38067);
var state_38205__$1 = state_38205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38205__$1,(71),inst_38068);
} else {
if((state_val_38206 === (101))){
var inst_37943 = (state_38205[(16)]);
var inst_38166 = (state_38205[(25)]);
var inst_38165 = (state_38205[(26)]);
var inst_38185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38186 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37943,inst_38165);
var inst_38187 = [inst_38186,inst_38166];
var inst_38188 = (new cljs.core.PersistentVector(null,2,(5),inst_38185,inst_38187,null));
var state_38205__$1 = state_38205;
var statearr_38231_38390 = state_38205__$1;
(statearr_38231_38390[(2)] = inst_38188);

(statearr_38231_38390[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (24))){
var state_38205__$1 = state_38205;
var statearr_38232_38391 = state_38205__$1;
(statearr_38232_38391[(2)] = true);

(statearr_38232_38391[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (102))){
var state_38205__$1 = state_38205;
var statearr_38233_38392 = state_38205__$1;
(statearr_38233_38392[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (55))){
var inst_37932 = (state_38205[(7)]);
var inst_38054 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_38054)){
var statearr_38235_38393 = state_38205__$1;
(statearr_38235_38393[(1)] = (65));

} else {
var statearr_38236_38394 = state_38205__$1;
(statearr_38236_38394[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (85))){
var inst_38121 = (state_38205[(2)]);
var state_38205__$1 = (function (){var statearr_38237 = state_38205;
(statearr_38237[(24)] = inst_38121);

return statearr_38237;
})();
var statearr_38238_38395 = state_38205__$1;
(statearr_38238_38395[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (39))){
var inst_37970 = (state_38205[(12)]);
var inst_37987 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37970,cljs.core.dec);
var state_38205__$1 = state_38205;
var statearr_38240_38396 = state_38205__$1;
(statearr_38240_38396[(2)] = inst_37987);

(statearr_38240_38396[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (88))){
var inst_38127 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38205__$1,(82),inst_38127);
} else {
if((state_val_38206 === (46))){
var inst_38010 = cljs.core.not(recur_QMARK_);
var state_38205__$1 = state_38205;
if(inst_38010){
var statearr_38241_38397 = state_38205__$1;
(statearr_38241_38397[(1)] = (48));

} else {
var statearr_38242_38398 = state_38205__$1;
(statearr_38242_38398[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (4))){
var inst_37903 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38243_38399 = state_38205__$1;
(statearr_38243_38399[(2)] = inst_37903);

(statearr_38243_38399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (77))){
var inst_38156 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38244_38400 = state_38205__$1;
(statearr_38244_38400[(2)] = inst_38156);

(statearr_38244_38400[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (106))){
var inst_38196 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38245_38401 = state_38205__$1;
(statearr_38245_38401[(2)] = inst_38196);

(statearr_38245_38401[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (95))){
var inst_37965 = (state_38205[(10)]);
var state_38205__$1 = state_38205;
var statearr_38246_38402 = state_38205__$1;
(statearr_38246_38402[(2)] = inst_37965);

(statearr_38246_38402[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (54))){
var inst_37932 = (state_38205[(7)]);
var inst_38022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38023 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_38024 = (new cljs.core.PersistentVector(null,3,(5),inst_38022,inst_38023,null));
var inst_38025 = cljs.core.select_keys(inst_37932,inst_38024);
var inst_38026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38029 = flake.o;
var inst_38030 = [inst_38029];
var inst_38031 = (new cljs.core.PersistentVector(null,1,(5),inst_38028,inst_38030,null));
var inst_38032 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38031);
var state_38205__$1 = (function (){var statearr_38247 = state_38205;
(statearr_38247[(27)] = inst_38026);

(statearr_38247[(20)] = inst_38025);

return statearr_38247;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38205__$1,(58),inst_38032);
} else {
if((state_val_38206 === (92))){
var inst_38146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38147 = flake.o;
var inst_38148 = [inst_38147,offset_map];
var inst_38149 = (new cljs.core.PersistentVector(null,2,(5),inst_38146,inst_38148,null));
var state_38205__$1 = state_38205;
var statearr_38248_38403 = state_38205__$1;
(statearr_38248_38403[(2)] = inst_38149);

(statearr_38248_38403[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (104))){
var inst_38166 = (state_38205[(25)]);
var inst_38191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38192 = [acc,inst_38166];
var inst_38193 = (new cljs.core.PersistentVector(null,2,(5),inst_38191,inst_38192,null));
var state_38205__$1 = state_38205;
var statearr_38249_38404 = state_38205__$1;
(statearr_38249_38404[(2)] = inst_38193);

(statearr_38249_38404[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (15))){
var inst_37933 = (state_38205[(28)]);
var state_38205__$1 = state_38205;
var statearr_38250_38405 = state_38205__$1;
(statearr_38250_38405[(2)] = inst_37933);

(statearr_38250_38405[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (48))){
var inst_38012 = (state_38205[(29)]);
var inst_37932 = (state_38205[(7)]);
var inst_38012__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = (function (){var statearr_38251 = state_38205;
(statearr_38251[(29)] = inst_38012__$1);

return statearr_38251;
})();
if(cljs.core.truth_(inst_38012__$1)){
var statearr_38252_38406 = state_38205__$1;
(statearr_38252_38406[(1)] = (51));

} else {
var statearr_38253_38407 = state_38205__$1;
(statearr_38253_38407[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (50))){
var inst_38020 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_38020)){
var statearr_38254_38408 = state_38205__$1;
(statearr_38254_38408[(1)] = (54));

} else {
var statearr_38255_38409 = state_38205__$1;
(statearr_38255_38409[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (75))){
var inst_37932 = (state_38205[(7)]);
var inst_38092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38093 = flake.o;
var inst_38094 = [inst_38093];
var inst_38095 = (new cljs.core.PersistentVector(null,1,(5),inst_38092,inst_38094,null));
var inst_38096 = [cljs.core.cst$kw$limit];
var inst_38097 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38098 = [inst_38097];
var inst_38099 = cljs.core.PersistentHashMap.fromArrays(inst_38096,inst_38098);
var inst_38100 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38095,inst_38099);
var state_38205__$1 = state_38205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38205__$1,(78),inst_38100);
} else {
if((state_val_38206 === (99))){
var inst_38165 = (state_38205[(26)]);
var inst_38182 = (inst_38165 == null);
var inst_38183 = cljs.core.not(inst_38182);
var state_38205__$1 = state_38205;
if(inst_38183){
var statearr_38256_38410 = state_38205__$1;
(statearr_38256_38410[(1)] = (101));

} else {
var statearr_38257_38411 = state_38205__$1;
(statearr_38257_38411[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (21))){
var inst_37932 = (state_38205[(7)]);
var inst_37948 = inst_37932.cljs$lang$protocol_mask$partition0$;
var inst_37949 = (inst_37948 & (64));
var inst_37950 = inst_37932.cljs$core$ISeq$;
var inst_37951 = (cljs.core.PROTOCOL_SENTINEL === inst_37950);
var inst_37952 = ((inst_37949) || (inst_37951));
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37952)){
var statearr_38258_38412 = state_38205__$1;
(statearr_38258_38412[(1)] = (24));

} else {
var statearr_38259_38413 = state_38205__$1;
(statearr_38259_38413[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (31))){
var inst_37965 = (state_38205[(10)]);
var state_38205__$1 = state_38205;
var statearr_38260_38414 = state_38205__$1;
(statearr_38260_38414[(2)] = inst_37965);

(statearr_38260_38414[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (32))){
var inst_37982 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37982)){
var statearr_38261_38415 = state_38205__$1;
(statearr_38261_38415[(1)] = (36));

} else {
var statearr_38262_38416 = state_38205__$1;
(statearr_38262_38416[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (40))){
var inst_37970 = (state_38205[(12)]);
var inst_37969 = (state_38205[(19)]);
var inst_37989 = (inst_37969 - (1));
var inst_37990 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37970,inst_37989);
var state_38205__$1 = state_38205;
var statearr_38263_38417 = state_38205__$1;
(statearr_38263_38417[(2)] = inst_37990);

(statearr_38263_38417[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (91))){
var inst_38154 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38264_38418 = state_38205__$1;
(statearr_38264_38418[(2)] = inst_38154);

(statearr_38264_38418[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (56))){
var inst_38160 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38265_38419 = state_38205__$1;
(statearr_38265_38419[(2)] = inst_38160);

(statearr_38265_38419[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (33))){
var inst_37970 = (state_38205[(12)]);
var inst_37969 = (state_38205[(19)]);
var inst_37973 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37969);
var inst_37974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37970);
var inst_37975 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37974);
var inst_37976 = ((inst_37973) && (inst_37975));
var state_38205__$1 = state_38205;
var statearr_38266_38420 = state_38205__$1;
(statearr_38266_38420[(2)] = inst_37976);

(statearr_38266_38420[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (13))){
var inst_37926 = (state_38205[(18)]);
var inst_37930 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37926,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_38205__$1 = state_38205;
var statearr_38267_38421 = state_38205__$1;
(statearr_38267_38421[(2)] = inst_37930);

(statearr_38267_38421[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (22))){
var state_38205__$1 = state_38205;
var statearr_38268_38422 = state_38205__$1;
(statearr_38268_38422[(2)] = false);

(statearr_38268_38422[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (90))){
var state_38205__$1 = state_38205;
var statearr_38269_38423 = state_38205__$1;
(statearr_38269_38423[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (36))){
var inst_37970 = (state_38205[(12)]);
var inst_37984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37970);
var state_38205__$1 = (function (){var statearr_38271 = state_38205;
(statearr_38271[(30)] = inst_37984);

return statearr_38271;
})();
if(cljs.core.truth_(inst_37985)){
var statearr_38272_38424 = state_38205__$1;
(statearr_38272_38424[(1)] = (39));

} else {
var statearr_38273_38425 = state_38205__$1;
(statearr_38273_38425[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (41))){
var inst_37984 = (state_38205[(30)]);
var inst_37992 = (state_38205[(2)]);
var inst_37993 = [null,inst_37992];
var inst_37994 = (new cljs.core.PersistentVector(null,2,(5),inst_37984,inst_37993,null));
var state_38205__$1 = state_38205;
var statearr_38274_38426 = state_38205__$1;
(statearr_38274_38426[(2)] = inst_37994);

(statearr_38274_38426[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (89))){
var inst_38137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38138 = ["_id"];
var inst_38139 = flake.o;
var inst_38140 = [inst_38139];
var inst_38141 = cljs.core.PersistentHashMap.fromArrays(inst_38138,inst_38140);
var inst_38142 = [inst_38141,offset_map];
var inst_38143 = (new cljs.core.PersistentVector(null,2,(5),inst_38137,inst_38142,null));
var state_38205__$1 = state_38205;
var statearr_38275_38427 = state_38205__$1;
(statearr_38275_38427[(2)] = inst_38143);

(statearr_38275_38427[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (100))){
var inst_38200 = (state_38205[(2)]);
var _ = (function (){var statearr_38276 = state_38205;
(statearr_38276[(4)] = cljs.core.rest((state_38205[(4)])));

return statearr_38276;
})();
var state_38205__$1 = state_38205;
var statearr_38277_38428 = state_38205__$1;
(statearr_38277_38428[(2)] = inst_38200);

(statearr_38277_38428[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (43))){
var inst_37965 = (state_38205[(10)]);
var state_38205__$1 = state_38205;
var statearr_38278_38429 = state_38205__$1;
(statearr_38278_38429[(2)] = inst_37965);

(statearr_38278_38429[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (61))){
var inst_38041 = (state_38205[(2)]);
var state_38205__$1 = (function (){var statearr_38279 = state_38205;
(statearr_38279[(11)] = inst_38041);

return statearr_38279;
})();
var statearr_38280_38430 = state_38205__$1;
(statearr_38280_38430[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (29))){
var inst_37965 = (state_38205[(10)]);
var inst_37964 = (state_38205[(13)]);
var inst_37964__$1 = (state_38205[(2)]);
var inst_37965__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$limit);
var inst_37968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$orderBy);
var inst_37969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$offset);
var inst_37970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37964__$1,cljs.core.cst$kw$p);
var state_38205__$1 = (function (){var statearr_38282 = state_38205;
(statearr_38282[(10)] = inst_37965__$1);

(statearr_38282[(12)] = inst_37970);

(statearr_38282[(13)] = inst_37964__$1);

(statearr_38282[(14)] = inst_37968);

(statearr_38282[(15)] = inst_37967);

(statearr_38282[(17)] = inst_37966);

(statearr_38282[(19)] = inst_37969);

return statearr_38282;
})();
if(cljs.core.truth_(inst_37965__$1)){
var statearr_38283_38431 = state_38205__$1;
(statearr_38283_38431[(1)] = (30));

} else {
var statearr_38284_38432 = state_38205__$1;
(statearr_38284_38432[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (44))){
var inst_38004 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_38004)){
var statearr_38285_38433 = state_38205__$1;
(statearr_38285_38433[(1)] = (45));

} else {
var statearr_38286_38434 = state_38205__$1;
(statearr_38286_38434[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (93))){
var state_38205__$1 = state_38205;
var statearr_38287_38435 = state_38205__$1;
(statearr_38287_38435[(2)] = null);

(statearr_38287_38435[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (6))){
var inst_37915 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37916 = (inst_37915 == null);
var state_38205__$1 = state_38205;
var statearr_38288_38436 = state_38205__$1;
(statearr_38288_38436[(2)] = inst_37916);

(statearr_38288_38436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (28))){
var inst_37932 = (state_38205[(7)]);
var state_38205__$1 = state_38205;
var statearr_38289_38437 = state_38205__$1;
(statearr_38289_38437[(2)] = inst_37932);

(statearr_38289_38437[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (64))){
var inst_38047 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38205__$1,(57),inst_38047);
} else {
if((state_val_38206 === (103))){
var inst_38198 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38290_38438 = state_38205__$1;
(statearr_38290_38438[(2)] = inst_38198);

(statearr_38290_38438[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (51))){
var inst_38012 = (state_38205[(29)]);
var state_38205__$1 = state_38205;
var statearr_38291_38439 = state_38205__$1;
(statearr_38291_38439[(2)] = inst_38012);

(statearr_38291_38439[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (25))){
var state_38205__$1 = state_38205;
var statearr_38292_38440 = state_38205__$1;
(statearr_38292_38440[(2)] = false);

(statearr_38292_38440[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (34))){
var inst_37969 = (state_38205[(19)]);
var state_38205__$1 = state_38205;
var statearr_38293_38441 = state_38205__$1;
(statearr_38293_38441[(2)] = inst_37969);

(statearr_38293_38441[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (17))){
var inst_37932 = (state_38205[(7)]);
var inst_37943 = (state_38205[(2)]);
var inst_37945 = (inst_37932 == null);
var inst_37946 = cljs.core.not(inst_37945);
var state_38205__$1 = (function (){var statearr_38294 = state_38205;
(statearr_38294[(16)] = inst_37943);

return statearr_38294;
})();
if(inst_37946){
var statearr_38295_38442 = state_38205__$1;
(statearr_38295_38442[(1)] = (21));

} else {
var statearr_38296_38443 = state_38205__$1;
(statearr_38296_38443[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (3))){
var inst_38203 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38205__$1,inst_38203);
} else {
if((state_val_38206 === (12))){
var inst_37926 = (state_38205[(18)]);
var state_38205__$1 = state_38205;
var statearr_38297_38444 = state_38205__$1;
(statearr_38297_38444[(2)] = inst_37926);

(statearr_38297_38444[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (2))){
var inst_37913 = (state_38205[(21)]);
var _ = (function (){var statearr_38298 = state_38205;
(statearr_38298[(4)] = cljs.core.cons((5),(state_38205[(4)])));

return statearr_38298;
})();
var inst_37913__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_38205__$1 = (function (){var statearr_38299 = state_38205;
(statearr_38299[(21)] = inst_37913__$1);

return statearr_38299;
})();
if(cljs.core.truth_(inst_37913__$1)){
var statearr_38300_38445 = state_38205__$1;
(statearr_38300_38445[(1)] = (6));

} else {
var statearr_38301_38446 = state_38205__$1;
(statearr_38301_38446[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (66))){
var inst_38085 = (state_38205[(31)]);
var inst_38085__$1 = componentFollow_QMARK_;
var state_38205__$1 = (function (){var statearr_38302 = state_38205;
(statearr_38302[(31)] = inst_38085__$1);

return statearr_38302;
})();
if(cljs.core.truth_(inst_38085__$1)){
var statearr_38303_38447 = state_38205__$1;
(statearr_38303_38447[(1)] = (72));

} else {
var statearr_38304_38448 = state_38205__$1;
(statearr_38304_38448[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (23))){
var inst_37959 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37959)){
var statearr_38305_38449 = state_38205__$1;
(statearr_38305_38449[(1)] = (27));

} else {
var statearr_38306_38450 = state_38205__$1;
(statearr_38306_38450[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (47))){
var inst_38162 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38307_38451 = state_38205__$1;
(statearr_38307_38451[(2)] = inst_38162);

(statearr_38307_38451[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (35))){
var inst_37979 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38308_38452 = state_38205__$1;
(statearr_38308_38452[(2)] = inst_37979);

(statearr_38308_38452[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (82))){
var inst_38114 = (state_38205[(32)]);
var inst_38129 = (state_38205[(2)]);
var inst_38130 = fluree.db.util.async.throw_err(inst_38129);
var inst_38131 = [inst_38130,offset_map];
var inst_38132 = (new cljs.core.PersistentVector(null,2,(5),inst_38114,inst_38131,null));
var state_38205__$1 = state_38205;
var statearr_38309_38453 = state_38205__$1;
(statearr_38309_38453[(2)] = inst_38132);

(statearr_38309_38453[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (76))){
var inst_37966 = (state_38205[(17)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37966)){
var statearr_38310_38454 = state_38205__$1;
(statearr_38310_38454[(1)] = (89));

} else {
var statearr_38311_38455 = state_38205__$1;
(statearr_38311_38455[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (97))){
var inst_38172 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_38172)){
var statearr_38312_38456 = state_38205__$1;
(statearr_38312_38456[(1)] = (98));

} else {
var statearr_38313_38457 = state_38205__$1;
(statearr_38313_38457[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (19))){
var inst_37932 = (state_38205[(7)]);
var inst_37939 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = state_38205;
var statearr_38314_38458 = state_38205__$1;
(statearr_38314_38458[(2)] = inst_37939);

(statearr_38314_38458[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (57))){
var inst_38026 = (state_38205[(27)]);
var inst_38049 = (state_38205[(2)]);
var inst_38050 = fluree.db.util.async.throw_err(inst_38049);
var inst_38051 = [inst_38050,offset_map];
var inst_38052 = (new cljs.core.PersistentVector(null,2,(5),inst_38026,inst_38051,null));
var state_38205__$1 = state_38205;
var statearr_38315_38459 = state_38205__$1;
(statearr_38315_38459[(2)] = inst_38052);

(statearr_38315_38459[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (68))){
var inst_38063 = (state_38205[(8)]);
var state_38205__$1 = state_38205;
var statearr_38316_38460 = state_38205__$1;
(statearr_38316_38460[(2)] = inst_38063);

(statearr_38316_38460[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (11))){
var inst_37926 = (state_38205[(18)]);
var inst_37926__$1 = (state_38205[(2)]);
var inst_37927 = cljs.core.contains_QMARK_(inst_37926__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_38205__$1 = (function (){var statearr_38318 = state_38205;
(statearr_38318[(18)] = inst_37926__$1);

return statearr_38318;
})();
if(inst_37927){
var statearr_38319_38461 = state_38205__$1;
(statearr_38319_38461[(1)] = (12));

} else {
var statearr_38320_38462 = state_38205__$1;
(statearr_38320_38462[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (9))){
var inst_37921 = flake.p;
var inst_37922 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37923 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37921,inst_37922);
var state_38205__$1 = state_38205;
var statearr_38321_38463 = state_38205__$1;
(statearr_38321_38463[(2)] = inst_37923);

(statearr_38321_38463[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (5))){
var _ = (function (){var statearr_38322 = state_38205;
(statearr_38322[(4)] = cljs.core.rest((state_38205[(4)])));

return statearr_38322;
})();
var state_38205__$1 = state_38205;
var ex38317 = (state_38205__$1[(2)]);
var statearr_38323_38464 = state_38205__$1;
(statearr_38323_38464[(5)] = ex38317);


if((ex38317 instanceof Error)){
var statearr_38324_38465 = state_38205__$1;
(statearr_38324_38465[(1)] = (4));

(statearr_38324_38465[(5)] = null);

} else {
throw ex38317;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (83))){
var inst_38103 = (state_38205[(23)]);
var inst_38117 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_38118 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38117,inst_38103);
var state_38205__$1 = state_38205;
var statearr_38325_38466 = state_38205__$1;
(statearr_38325_38466[(2)] = inst_38118);

(statearr_38325_38466[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (14))){
var inst_37933 = (state_38205[(28)]);
var inst_37932 = (state_38205[(7)]);
var inst_37932__$1 = (state_38205[(2)]);
var inst_37933__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37932__$1);
var state_38205__$1 = (function (){var statearr_38326 = state_38205;
(statearr_38326[(28)] = inst_37933__$1);

(statearr_38326[(7)] = inst_37932__$1);

return statearr_38326;
})();
if(cljs.core.truth_(inst_37933__$1)){
var statearr_38327_38467 = state_38205__$1;
(statearr_38327_38467[(1)] = (15));

} else {
var statearr_38328_38468 = state_38205__$1;
(statearr_38328_38468[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (45))){
var inst_38006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38007 = [null,offset_map];
var inst_38008 = (new cljs.core.PersistentVector(null,2,(5),inst_38006,inst_38007,null));
var state_38205__$1 = state_38205;
var statearr_38329_38469 = state_38205__$1;
(statearr_38329_38469[(2)] = inst_38008);

(statearr_38329_38469[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (53))){
var inst_38017 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38330_38470 = state_38205__$1;
(statearr_38330_38470[(2)] = inst_38017);

(statearr_38330_38470[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (78))){
var inst_38103 = (state_38205[(23)]);
var inst_38102 = (state_38205[(2)]);
var inst_38103__$1 = fluree.db.util.async.throw_err(inst_38102);
var inst_38104 = cljs.core.empty_QMARK_(inst_38103__$1);
var state_38205__$1 = (function (){var statearr_38331 = state_38205;
(statearr_38331[(23)] = inst_38103__$1);

return statearr_38331;
})();
if(inst_38104){
var statearr_38332_38471 = state_38205__$1;
(statearr_38332_38471[(1)] = (79));

} else {
var statearr_38333_38472 = state_38205__$1;
(statearr_38333_38472[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (26))){
var inst_37956 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38334_38473 = state_38205__$1;
(statearr_38334_38473[(2)] = inst_37956);

(statearr_38334_38473[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (16))){
var inst_37936 = (state_38205[(33)]);
var inst_37932 = (state_38205[(7)]);
var inst_37936__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = (function (){var statearr_38335 = state_38205;
(statearr_38335[(33)] = inst_37936__$1);

return statearr_38335;
})();
if(cljs.core.truth_(inst_37936__$1)){
var statearr_38336_38474 = state_38205__$1;
(statearr_38336_38474[(1)] = (18));

} else {
var statearr_38337_38475 = state_38205__$1;
(statearr_38337_38475[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (81))){
var inst_38134 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38338_38476 = state_38205__$1;
(statearr_38338_38476[(2)] = inst_38134);

(statearr_38338_38476[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (79))){
var inst_38106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38107 = ["_id"];
var inst_38108 = flake.o;
var inst_38109 = [inst_38108];
var inst_38110 = cljs.core.PersistentHashMap.fromArrays(inst_38107,inst_38109);
var inst_38111 = [inst_38110,offset_map];
var inst_38112 = (new cljs.core.PersistentVector(null,2,(5),inst_38106,inst_38111,null));
var state_38205__$1 = state_38205;
var statearr_38339_38477 = state_38205__$1;
(statearr_38339_38477[(2)] = inst_38112);

(statearr_38339_38477[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (38))){
var inst_38165 = (state_38205[(26)]);
var inst_38164 = (state_38205[(2)]);
var inst_38165__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38164,(0),null);
var inst_38166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38164,(1),null);
var inst_38167 = (inst_38165__$1 == null);
var inst_38168 = cljs.core.not(inst_38167);
var state_38205__$1 = (function (){var statearr_38340 = state_38205;
(statearr_38340[(25)] = inst_38166);

(statearr_38340[(26)] = inst_38165__$1);

return statearr_38340;
})();
if(inst_38168){
var statearr_38341_38478 = state_38205__$1;
(statearr_38341_38478[(1)] = (95));

} else {
var statearr_38342_38479 = state_38205__$1;
(statearr_38342_38479[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (98))){
var inst_37943 = (state_38205[(16)]);
var inst_38166 = (state_38205[(25)]);
var inst_38165 = (state_38205[(26)]);
var inst_38174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38175 = cljs.core.PersistentVector.EMPTY;
var inst_38176 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_37943,inst_38175);
var inst_38177 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38176,inst_38165);
var inst_38178 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37943,inst_38177);
var inst_38179 = [inst_38178,inst_38166];
var inst_38180 = (new cljs.core.PersistentVector(null,2,(5),inst_38174,inst_38179,null));
var state_38205__$1 = state_38205;
var statearr_38343_38480 = state_38205__$1;
(statearr_38343_38480[(2)] = inst_38180);

(statearr_38343_38480[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (87))){
var inst_38121 = (state_38205[(24)]);
var state_38205__$1 = state_38205;
var statearr_38344_38481 = state_38205__$1;
(statearr_38344_38481[(2)] = inst_38121);

(statearr_38344_38481[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (30))){
var inst_37969 = (state_38205[(19)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37969)){
var statearr_38345_38482 = state_38205__$1;
(statearr_38345_38482[(1)] = (33));

} else {
var statearr_38346_38483 = state_38205__$1;
(statearr_38346_38483[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (73))){
var inst_38085 = (state_38205[(31)]);
var state_38205__$1 = state_38205;
var statearr_38347_38484 = state_38205__$1;
(statearr_38347_38484[(2)] = inst_38085);

(statearr_38347_38484[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (96))){
var state_38205__$1 = state_38205;
var statearr_38348_38485 = state_38205__$1;
(statearr_38348_38485[(2)] = false);

(statearr_38348_38485[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (10))){
var state_38205__$1 = state_38205;
var statearr_38349_38486 = state_38205__$1;
(statearr_38349_38486[(2)] = pred_spec);

(statearr_38349_38486[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (18))){
var inst_37936 = (state_38205[(33)]);
var state_38205__$1 = state_38205;
var statearr_38350_38487 = state_38205__$1;
(statearr_38350_38487[(2)] = inst_37936);

(statearr_38350_38487[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (105))){
var state_38205__$1 = state_38205;
var statearr_38351_38488 = state_38205__$1;
(statearr_38351_38488[(2)] = null);

(statearr_38351_38488[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (52))){
var inst_37932 = (state_38205[(7)]);
var inst_38015 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38205__$1 = state_38205;
var statearr_38352_38489 = state_38205__$1;
(statearr_38352_38489[(2)] = inst_38015);

(statearr_38352_38489[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (67))){
var inst_38158 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38353_38490 = state_38205__$1;
(statearr_38353_38490[(2)] = inst_38158);

(statearr_38353_38490[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (71))){
var inst_37932 = (state_38205[(7)]);
var inst_38070 = (state_38205[(2)]);
var inst_38071 = fluree.db.util.async.throw_err(inst_38070);
var inst_38072 = cljs.core._deref(cache);
var inst_38073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38074 = flake.o;
var inst_38075 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38076 = [inst_38074,inst_38075];
var inst_38077 = (new cljs.core.PersistentVector(null,2,(5),inst_38073,inst_38076,null));
var inst_38078 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38072,inst_38077,inst_38071);
var inst_38079 = cljs.core._vreset_BANG_(cache,inst_38078);
var state_38205__$1 = (function (){var statearr_38354 = state_38205;
(statearr_38354[(34)] = inst_38079);

return statearr_38354;
})();
var statearr_38355_38491 = state_38205__$1;
(statearr_38355_38491[(2)] = inst_38071);

(statearr_38355_38491[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (42))){
var inst_37968 = (state_38205[(14)]);
var inst_37967 = (state_38205[(15)]);
var inst_37943 = (state_38205[(16)]);
var inst_37997 = cljs.core.not(inst_37968);
var inst_37998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37943);
var inst_37999 = cljs.core.count(inst_37998);
var inst_38000 = (inst_37999 >= inst_37967);
var inst_38001 = ((inst_37997) && (inst_38000));
var state_38205__$1 = state_38205;
var statearr_38356_38492 = state_38205__$1;
(statearr_38356_38492[(2)] = inst_38001);

(statearr_38356_38492[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (80))){
var inst_38114 = cljs.core.PersistentVector.EMPTY_NODE;
var state_38205__$1 = (function (){var statearr_38357 = state_38205;
(statearr_38357[(32)] = inst_38114);

return statearr_38357;
})();
if(cljs.core.truth_(fuel)){
var statearr_38358_38493 = state_38205__$1;
(statearr_38358_38493[(1)] = (83));

} else {
var statearr_38359_38494 = state_38205__$1;
(statearr_38359_38494[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (37))){
var inst_37965 = (state_38205[(10)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37965)){
var statearr_38360_38495 = state_38205__$1;
(statearr_38360_38495[(1)] = (42));

} else {
var statearr_38361_38496 = state_38205__$1;
(statearr_38361_38496[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (63))){
var inst_38041 = (state_38205[(11)]);
var state_38205__$1 = state_38205;
var statearr_38362_38497 = state_38205__$1;
(statearr_38362_38497[(2)] = inst_38041);

(statearr_38362_38497[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (94))){
var inst_38152 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
var statearr_38363_38498 = state_38205__$1;
(statearr_38363_38498[(2)] = inst_38152);

(statearr_38363_38498[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (8))){
var inst_37919 = (state_38205[(2)]);
var state_38205__$1 = state_38205;
if(cljs.core.truth_(inst_37919)){
var statearr_38364_38499 = state_38205__$1;
(statearr_38364_38499[(1)] = (9));

} else {
var statearr_38365_38500 = state_38205__$1;
(statearr_38365_38500[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (49))){
var state_38205__$1 = state_38205;
var statearr_38366_38501 = state_38205__$1;
(statearr_38366_38501[(2)] = false);

(statearr_38366_38501[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38206 === (84))){
var inst_38103 = (state_38205[(23)]);
var state_38205__$1 = state_38205;
var statearr_38367_38502 = state_38205__$1;
(statearr_38367_38502[(2)] = inst_38103);

(statearr_38367_38502[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16291__auto__ = null;
var fluree$db$query$fql$state_machine__16291__auto____0 = (function (){
var statearr_38368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38368[(0)] = fluree$db$query$fql$state_machine__16291__auto__);

(statearr_38368[(1)] = (1));

return statearr_38368;
});
var fluree$db$query$fql$state_machine__16291__auto____1 = (function (state_38205){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_38205);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e38369){var ex__16294__auto__ = e38369;
var statearr_38370_38503 = state_38205;
(statearr_38370_38503[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_38205[(4)]))){
var statearr_38371_38504 = state_38205;
(statearr_38371_38504[(1)] = cljs.core.first((state_38205[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__38505 = state_38205;
state_38205 = G__38505;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16291__auto__ = function(state_38205){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16291__auto____1.call(this,state_38205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16291__auto____0;
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16291__auto____1;
return fluree$db$query$fql$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_38372 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_38372[(6)] = c__16328__auto__);

return statearr_38372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_38685){
var state_val_38686 = (state_38685[(1)]);
if((state_val_38686 === (7))){
var inst_38680 = (state_38685[(2)]);
var _ = (function (){var statearr_38687 = state_38685;
(statearr_38687[(4)] = cljs.core.rest((state_38685[(4)])));

return statearr_38687;
})();
var state_38685__$1 = state_38685;
var statearr_38688_38783 = state_38685__$1;
(statearr_38688_38783[(2)] = inst_38680);

(statearr_38688_38783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (59))){
var inst_38566 = (state_38685[(7)]);
var state_38685__$1 = state_38685;
var statearr_38689_38784 = state_38685__$1;
(statearr_38689_38784[(2)] = inst_38566);

(statearr_38689_38784[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (20))){
var inst_38575 = (state_38685[(8)]);
var inst_38572 = (state_38685[(2)]);
var inst_38573 = fluree.db.util.async.throw_err(inst_38572);
var inst_38574 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38573);
var inst_38575__$1 = cljs.core.not_empty(inst_38574);
var state_38685__$1 = (function (){var statearr_38690 = state_38685;
(statearr_38690[(8)] = inst_38575__$1);

return statearr_38690;
})();
if(cljs.core.truth_(inst_38575__$1)){
var statearr_38691_38785 = state_38685__$1;
(statearr_38691_38785[(1)] = (21));

} else {
var statearr_38692_38786 = state_38685__$1;
(statearr_38692_38786[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (58))){
var inst_38565 = (state_38685[(9)]);
var state_38685__$1 = state_38685;
var statearr_38693_38787 = state_38685__$1;
(statearr_38693_38787[(2)] = inst_38565);

(statearr_38693_38787[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (60))){
var inst_38672 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38694_38788 = state_38685__$1;
(statearr_38694_38788[(2)] = inst_38672);

(statearr_38694_38788[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (27))){
var inst_38597 = (state_38685[(10)]);
var inst_38607 = (state_38685[(11)]);
var inst_38605 = (state_38685[(12)]);
var inst_38604 = cljs.core.seq(inst_38597);
var inst_38605__$1 = cljs.core.first(inst_38604);
var inst_38606 = cljs.core.next(inst_38604);
var inst_38607__$1 = cljs.core.not(inst_38605__$1);
var state_38685__$1 = (function (){var statearr_38695 = state_38685;
(statearr_38695[(11)] = inst_38607__$1);

(statearr_38695[(12)] = inst_38605__$1);

(statearr_38695[(13)] = inst_38606);

return statearr_38695;
})();
if(inst_38607__$1){
var statearr_38696_38789 = state_38685__$1;
(statearr_38696_38789[(1)] = (29));

} else {
var statearr_38697_38790 = state_38685__$1;
(statearr_38697_38790[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (1))){
var state_38685__$1 = state_38685;
var statearr_38698_38791 = state_38685__$1;
(statearr_38698_38791[(2)] = null);

(statearr_38698_38791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (24))){
var inst_38575 = (state_38685[(8)]);
var inst_38581 = cljs.core.count(inst_38575);
var inst_38582 = fluree.db.query.fql.add_fuel(fuel,inst_38581,max_fuel);
var state_38685__$1 = state_38685;
var statearr_38699_38792 = state_38685__$1;
(statearr_38699_38792[(2)] = inst_38582);

(statearr_38699_38792[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (55))){
var inst_38564 = (state_38685[(14)]);
var state_38685__$1 = state_38685;
var statearr_38700_38793 = state_38685__$1;
(statearr_38700_38793[(2)] = inst_38564);

(statearr_38700_38793[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (39))){
var inst_38562 = (state_38685[(15)]);
var state_38685__$1 = state_38685;
var statearr_38701_38794 = state_38685__$1;
(statearr_38701_38794[(2)] = inst_38562);

(statearr_38701_38794[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (46))){
var inst_38660 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38702_38795 = state_38685__$1;
(statearr_38702_38795[(2)] = inst_38660);

(statearr_38702_38795[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (4))){
var inst_38506 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38703_38796 = state_38685__$1;
(statearr_38703_38796[(2)] = inst_38506);

(statearr_38703_38796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (54))){
var inst_38599 = (state_38685[(16)]);
var inst_38651 = (state_38685[(2)]);
var inst_38652 = fluree.db.util.async.throw_err(inst_38651);
var inst_38653 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38599,inst_38652);
var state_38685__$1 = state_38685;
var statearr_38704_38797 = state_38685__$1;
(statearr_38704_38797[(2)] = inst_38653);

(statearr_38704_38797[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (15))){
var state_38685__$1 = state_38685;
var statearr_38705_38798 = state_38685__$1;
(statearr_38705_38798[(2)] = false);

(statearr_38705_38798[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (48))){
var inst_38599 = (state_38685[(16)]);
var state_38685__$1 = state_38685;
var statearr_38706_38799 = state_38685__$1;
(statearr_38706_38799[(2)] = inst_38599);

(statearr_38706_38799[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (50))){
var inst_38598 = (state_38685[(17)]);
var inst_38606 = (state_38685[(13)]);
var inst_38655 = (state_38685[(2)]);
var inst_38656 = (inst_38598 + (1));
var inst_38597 = inst_38606;
var inst_38598__$1 = inst_38656;
var inst_38599 = inst_38655;
var state_38685__$1 = (function (){var statearr_38707 = state_38685;
(statearr_38707[(10)] = inst_38597);

(statearr_38707[(17)] = inst_38598__$1);

(statearr_38707[(16)] = inst_38599);

return statearr_38707;
})();
var statearr_38708_38800 = state_38685__$1;
(statearr_38708_38800[(2)] = null);

(statearr_38708_38800[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (21))){
var state_38685__$1 = state_38685;
var statearr_38709_38801 = state_38685__$1;
(statearr_38709_38801[(2)] = fuel);

(statearr_38709_38801[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (31))){
var inst_38616 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38616)){
var statearr_38710_38802 = state_38685__$1;
(statearr_38710_38802[(1)] = (35));

} else {
var statearr_38711_38803 = state_38685__$1;
(statearr_38711_38803[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (32))){
var inst_38598 = (state_38685[(17)]);
var inst_38563 = (state_38685[(18)]);
var inst_38611 = (inst_38598 >= inst_38563);
var state_38685__$1 = state_38685;
var statearr_38712_38804 = state_38685__$1;
(statearr_38712_38804[(2)] = inst_38611);

(statearr_38712_38804[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (40))){
var inst_38623 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38623)){
var statearr_38713_38805 = state_38685__$1;
(statearr_38713_38805[(1)] = (41));

} else {
var statearr_38714_38806 = state_38685__$1;
(statearr_38714_38806[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (56))){
var inst_38565 = (state_38685[(9)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38565)){
var statearr_38715_38807 = state_38685__$1;
(statearr_38715_38807[(1)] = (58));

} else {
var statearr_38716_38808 = state_38685__$1;
(statearr_38716_38808[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (33))){
var inst_38563 = (state_38685[(18)]);
var state_38685__$1 = state_38685;
var statearr_38717_38809 = state_38685__$1;
(statearr_38717_38809[(2)] = inst_38563);

(statearr_38717_38809[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (13))){
var inst_38556 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38556)){
var statearr_38718_38810 = state_38685__$1;
(statearr_38718_38810[(1)] = (17));

} else {
var statearr_38719_38811 = state_38685__$1;
(statearr_38719_38811[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (22))){
var inst_38575 = (state_38685[(8)]);
var state_38685__$1 = state_38685;
var statearr_38721_38812 = state_38685__$1;
(statearr_38721_38812[(2)] = inst_38575);

(statearr_38721_38812[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (36))){
var inst_38562 = (state_38685[(15)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38562)){
var statearr_38722_38813 = state_38685__$1;
(statearr_38722_38813[(1)] = (38));

} else {
var statearr_38723_38814 = state_38685__$1;
(statearr_38723_38814[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (41))){
var inst_38598 = (state_38685[(17)]);
var inst_38599 = (state_38685[(16)]);
var inst_38606 = (state_38685[(13)]);
var inst_38625 = (inst_38598 + (1));
var tmp38720 = inst_38599;
var inst_38597 = inst_38606;
var inst_38598__$1 = inst_38625;
var inst_38599__$1 = tmp38720;
var state_38685__$1 = (function (){var statearr_38724 = state_38685;
(statearr_38724[(10)] = inst_38597);

(statearr_38724[(17)] = inst_38598__$1);

(statearr_38724[(16)] = inst_38599__$1);

return statearr_38724;
})();
var statearr_38725_38815 = state_38685__$1;
(statearr_38725_38815[(2)] = null);

(statearr_38725_38815[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (43))){
var inst_38662 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38726_38816 = state_38685__$1;
(statearr_38726_38816[(2)] = inst_38662);

(statearr_38726_38816[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (29))){
var inst_38607 = (state_38685[(11)]);
var state_38685__$1 = state_38685;
var statearr_38727_38817 = state_38685__$1;
(statearr_38727_38817[(2)] = inst_38607);

(statearr_38727_38817[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (44))){
var inst_38605 = (state_38685[(12)]);
var inst_38629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38630 = [inst_38605];
var inst_38631 = (new cljs.core.PersistentVector(null,1,(5),inst_38629,inst_38630,null));
var inst_38632 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38631);
var state_38685__$1 = state_38685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38685__$1,(47),inst_38632);
} else {
if((state_val_38686 === (6))){
var inst_38523 = (state_38685[(19)]);
var inst_38530 = (state_38685[(20)]);
var inst_38529 = cljs.core.seq(inst_38523);
var inst_38530__$1 = cljs.core.first(inst_38529);
var inst_38531 = cljs.core.next(inst_38529);
var inst_38532 = cljs.core.not(inst_38530__$1);
var state_38685__$1 = (function (){var statearr_38728 = state_38685;
(statearr_38728[(21)] = inst_38531);

(statearr_38728[(20)] = inst_38530__$1);

return statearr_38728;
})();
if(inst_38532){
var statearr_38729_38818 = state_38685__$1;
(statearr_38729_38818[(1)] = (8));

} else {
var statearr_38730_38819 = state_38685__$1;
(statearr_38730_38819[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (28))){
var inst_38564 = (state_38685[(14)]);
var inst_38666 = (state_38685[(2)]);
var state_38685__$1 = (function (){var statearr_38731 = state_38685;
(statearr_38731[(22)] = inst_38666);

return statearr_38731;
})();
if(cljs.core.truth_(inst_38564)){
var statearr_38732_38820 = state_38685__$1;
(statearr_38732_38820[(1)] = (55));

} else {
var statearr_38733_38821 = state_38685__$1;
(statearr_38733_38821[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (51))){
var inst_38635 = (state_38685[(23)]);
var inst_38644 = cljs.core.count(inst_38635);
var inst_38645 = fluree.db.query.fql.add_fuel(fuel,inst_38644,max_fuel);
var state_38685__$1 = state_38685;
var statearr_38734_38822 = state_38685__$1;
(statearr_38734_38822[(2)] = inst_38645);

(statearr_38734_38822[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (25))){
var state_38685__$1 = state_38685;
var statearr_38735_38823 = state_38685__$1;
(statearr_38735_38823[(2)] = null);

(statearr_38735_38823[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (34))){
var inst_38614 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38736_38824 = state_38685__$1;
(statearr_38736_38824[(2)] = inst_38614);

(statearr_38736_38824[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (17))){
var inst_38540 = (state_38685[(24)]);
var inst_38558 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38540);
var state_38685__$1 = state_38685;
var statearr_38737_38825 = state_38685__$1;
(statearr_38737_38825[(2)] = inst_38558);

(statearr_38737_38825[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (3))){
var inst_38683 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38685__$1,inst_38683);
} else {
if((state_val_38686 === (12))){
var state_38685__$1 = state_38685;
var statearr_38738_38826 = state_38685__$1;
(statearr_38738_38826[(2)] = false);

(statearr_38738_38826[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (2))){
var _ = (function (){var statearr_38739 = state_38685;
(statearr_38739[(4)] = cljs.core.cons((5),(state_38685[(4)])));

return statearr_38739;
})();
var inst_38519 = reverse_refs_specs;
var inst_38520 = cljs.core.seq(inst_38519);
var inst_38521 = cljs.core.first(inst_38520);
var inst_38522 = cljs.core.next(inst_38520);
var inst_38523 = inst_38519;
var inst_38524 = null;
var state_38685__$1 = (function (){var statearr_38740 = state_38685;
(statearr_38740[(19)] = inst_38523);

(statearr_38740[(25)] = inst_38522);

(statearr_38740[(26)] = inst_38521);

(statearr_38740[(27)] = inst_38524);

return statearr_38740;
})();
var statearr_38741_38827 = state_38685__$1;
(statearr_38741_38827[(2)] = null);

(statearr_38741_38827[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (23))){
var inst_38579 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38579)){
var statearr_38742_38828 = state_38685__$1;
(statearr_38742_38828[(1)] = (24));

} else {
var statearr_38743_38829 = state_38685__$1;
(statearr_38743_38829[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (47))){
var inst_38540 = (state_38685[(24)]);
var inst_38635 = (state_38685[(23)]);
var inst_38634 = (state_38685[(2)]);
var inst_38635__$1 = fluree.db.util.async.throw_err(inst_38634);
var inst_38636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38637 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_38638 = (new cljs.core.PersistentVector(null,4,(5),inst_38636,inst_38637,null));
var inst_38639 = cljs.core.select_keys(inst_38540,inst_38638);
var inst_38640 = cljs.core.empty_QMARK_(inst_38635__$1);
var state_38685__$1 = (function (){var statearr_38744 = state_38685;
(statearr_38744[(28)] = inst_38639);

(statearr_38744[(23)] = inst_38635__$1);

return statearr_38744;
})();
if(inst_38640){
var statearr_38745_38830 = state_38685__$1;
(statearr_38745_38830[(1)] = (48));

} else {
var statearr_38746_38831 = state_38685__$1;
(statearr_38746_38831[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (35))){
var inst_38599 = (state_38685[(16)]);
var state_38685__$1 = state_38685;
var statearr_38747_38832 = state_38685__$1;
(statearr_38747_38832[(2)] = inst_38599);

(statearr_38747_38832[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (19))){
var inst_38539 = (state_38685[(29)]);
var inst_38561 = (state_38685[(2)]);
var inst_38562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38561,cljs.core.cst$kw$offset);
var inst_38563 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38561,cljs.core.cst$kw$limit);
var inst_38564 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38561,cljs.core.cst$kw$as);
var inst_38565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38561,cljs.core.cst$kw$name);
var inst_38566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38561,cljs.core.cst$kw$p);
var inst_38567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38568 = [subject_id,inst_38539];
var inst_38569 = (new cljs.core.PersistentVector(null,2,(5),inst_38567,inst_38568,null));
var inst_38570 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_38569);
var state_38685__$1 = (function (){var statearr_38748 = state_38685;
(statearr_38748[(15)] = inst_38562);

(statearr_38748[(14)] = inst_38564);

(statearr_38748[(9)] = inst_38565);

(statearr_38748[(18)] = inst_38563);

(statearr_38748[(7)] = inst_38566);

return statearr_38748;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38685__$1,(20),inst_38570);
} else {
if((state_val_38686 === (57))){
var inst_38531 = (state_38685[(21)]);
var inst_38666 = (state_38685[(22)]);
var inst_38524 = (state_38685[(27)]);
var inst_38674 = (state_38685[(2)]);
var inst_38675 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38524,inst_38674,inst_38666);
var inst_38523 = inst_38531;
var inst_38524__$1 = inst_38675;
var state_38685__$1 = (function (){var statearr_38749 = state_38685;
(statearr_38749[(19)] = inst_38523);

(statearr_38749[(27)] = inst_38524__$1);

return statearr_38749;
})();
var statearr_38750_38833 = state_38685__$1;
(statearr_38750_38833[(2)] = null);

(statearr_38750_38833[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (11))){
var inst_38540 = (state_38685[(24)]);
var inst_38545 = inst_38540.cljs$lang$protocol_mask$partition0$;
var inst_38546 = (inst_38545 & (64));
var inst_38547 = inst_38540.cljs$core$ISeq$;
var inst_38548 = (cljs.core.PROTOCOL_SENTINEL === inst_38547);
var inst_38549 = ((inst_38546) || (inst_38548));
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38549)){
var statearr_38752_38834 = state_38685__$1;
(statearr_38752_38834[(1)] = (14));

} else {
var statearr_38753_38835 = state_38685__$1;
(statearr_38753_38835[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (9))){
var inst_38530 = (state_38685[(20)]);
var inst_38540 = (state_38685[(24)]);
var inst_38539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38530,(0),null);
var inst_38540__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38530,(1),null);
var inst_38542 = (inst_38540__$1 == null);
var inst_38543 = cljs.core.not(inst_38542);
var state_38685__$1 = (function (){var statearr_38754 = state_38685;
(statearr_38754[(29)] = inst_38539);

(statearr_38754[(24)] = inst_38540__$1);

return statearr_38754;
})();
if(inst_38543){
var statearr_38755_38836 = state_38685__$1;
(statearr_38755_38836[(1)] = (11));

} else {
var statearr_38756_38837 = state_38685__$1;
(statearr_38756_38837[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (5))){
var _ = (function (){var statearr_38757 = state_38685;
(statearr_38757[(4)] = cljs.core.rest((state_38685[(4)])));

return statearr_38757;
})();
var state_38685__$1 = state_38685;
var ex38751 = (state_38685__$1[(2)]);
var statearr_38758_38838 = state_38685__$1;
(statearr_38758_38838[(5)] = ex38751);


if((ex38751 instanceof Error)){
var statearr_38759_38839 = state_38685__$1;
(statearr_38759_38839[(1)] = (4));

(statearr_38759_38839[(5)] = null);

} else {
throw ex38751;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (14))){
var state_38685__$1 = state_38685;
var statearr_38760_38840 = state_38685__$1;
(statearr_38760_38840[(2)] = true);

(statearr_38760_38840[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (45))){
var state_38685__$1 = state_38685;
var statearr_38761_38841 = state_38685__$1;
(statearr_38761_38841[(2)] = null);

(statearr_38761_38841[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (53))){
var inst_38639 = (state_38685[(28)]);
var inst_38635 = (state_38685[(23)]);
var inst_38648 = (state_38685[(2)]);
var inst_38649 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38639,inst_38635) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38639,inst_38635));
var state_38685__$1 = (function (){var statearr_38762 = state_38685;
(statearr_38762[(30)] = inst_38648);

return statearr_38762;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38685__$1,(54),inst_38649);
} else {
if((state_val_38686 === (26))){
var inst_38575 = (state_38685[(8)]);
var inst_38585 = (state_38685[(2)]);
var inst_38593 = cljs.core.seq(inst_38575);
var inst_38594 = cljs.core.first(inst_38593);
var inst_38595 = cljs.core.next(inst_38593);
var inst_38596 = cljs.core.PersistentVector.EMPTY;
var inst_38597 = inst_38575;
var inst_38598 = (0);
var inst_38599 = inst_38596;
var state_38685__$1 = (function (){var statearr_38763 = state_38685;
(statearr_38763[(10)] = inst_38597);

(statearr_38763[(17)] = inst_38598);

(statearr_38763[(16)] = inst_38599);

(statearr_38763[(31)] = inst_38594);

(statearr_38763[(32)] = inst_38585);

(statearr_38763[(33)] = inst_38595);

return statearr_38763;
})();
var statearr_38764_38842 = state_38685__$1;
(statearr_38764_38842[(2)] = null);

(statearr_38764_38842[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (16))){
var inst_38553 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38765_38843 = state_38685__$1;
(statearr_38765_38843[(2)] = inst_38553);

(statearr_38765_38843[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (38))){
var inst_38598 = (state_38685[(17)]);
var inst_38562 = (state_38685[(15)]);
var inst_38620 = (inst_38598 < inst_38562);
var state_38685__$1 = state_38685;
var statearr_38766_38844 = state_38685__$1;
(statearr_38766_38844[(2)] = inst_38620);

(statearr_38766_38844[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (30))){
var inst_38563 = (state_38685[(18)]);
var state_38685__$1 = state_38685;
if(cljs.core.truth_(inst_38563)){
var statearr_38767_38845 = state_38685__$1;
(statearr_38767_38845[(1)] = (32));

} else {
var statearr_38768_38846 = state_38685__$1;
(statearr_38768_38846[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (10))){
var inst_38678 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38769_38847 = state_38685__$1;
(statearr_38769_38847[(2)] = inst_38678);

(statearr_38769_38847[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (18))){
var inst_38540 = (state_38685[(24)]);
var state_38685__$1 = state_38685;
var statearr_38770_38848 = state_38685__$1;
(statearr_38770_38848[(2)] = inst_38540);

(statearr_38770_38848[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (52))){
var state_38685__$1 = state_38685;
var statearr_38771_38849 = state_38685__$1;
(statearr_38771_38849[(2)] = null);

(statearr_38771_38849[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (42))){
var state_38685__$1 = state_38685;
var statearr_38772_38850 = state_38685__$1;
(statearr_38772_38850[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (37))){
var inst_38664 = (state_38685[(2)]);
var state_38685__$1 = state_38685;
var statearr_38774_38851 = state_38685__$1;
(statearr_38774_38851[(2)] = inst_38664);

(statearr_38774_38851[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (8))){
var inst_38524 = (state_38685[(27)]);
var state_38685__$1 = state_38685;
var statearr_38775_38852 = state_38685__$1;
(statearr_38775_38852[(2)] = inst_38524);

(statearr_38775_38852[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38686 === (49))){
var state_38685__$1 = state_38685;
if(cljs.core.truth_(fuel)){
var statearr_38776_38853 = state_38685__$1;
(statearr_38776_38853[(1)] = (51));

} else {
var statearr_38777_38854 = state_38685__$1;
(statearr_38777_38854[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____0 = (function (){
var statearr_38778 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38778[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__);

(statearr_38778[(1)] = (1));

return statearr_38778;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____1 = (function (state_38685){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_38685);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e38779){var ex__16294__auto__ = e38779;
var statearr_38780_38855 = state_38685;
(statearr_38780_38855[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_38685[(4)]))){
var statearr_38781_38856 = state_38685;
(statearr_38781_38856[(1)] = cljs.core.first((state_38685[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__38857 = state_38685;
state_38685 = G__38857;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__ = function(state_38685){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____1.call(this,state_38685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_38782 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_38782[(6)] = c__16328__auto__);

return statearr_38782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
fluree.db.query.fql.get_recursion_map_multi = (function fluree$db$query$fql$get_recursion_map_multi(recursion_map,k,f,full_select_spec,seen_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null),cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.o(f)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.query.fql.o(f)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.cst$kw$depth], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec),true], null);
});
fluree.db.query.fql.add_in_multi_flakes = (function fluree$db$query$fql$add_in_multi_flakes(acc,new_child_paths,k,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,parent_exists){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_38976){
var state_val_38977 = (state_38976[(1)]);
if((state_val_38977 === (7))){
var inst_38971 = (state_38976[(2)]);
var _ = (function (){var statearr_38978 = state_38976;
(statearr_38978[(4)] = cljs.core.rest((state_38976[(4)])));

return statearr_38978;
})();
var state_38976__$1 = state_38976;
var statearr_38979_39034 = state_38976__$1;
(statearr_38979_39034[(2)] = inst_38971);

(statearr_38979_39034[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (20))){
var inst_38913 = (state_38976[(7)]);
var state_38976__$1 = state_38976;
var statearr_38980_39035 = state_38976__$1;
(statearr_38980_39035[(2)] = inst_38913);

(statearr_38980_39035[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (27))){
var inst_38878 = (state_38976[(8)]);
var inst_38934 = (state_38976[(9)]);
var inst_38953 = (state_38976[(2)]);
var inst_38954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38953,(0),null);
var inst_38955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38953,(1),null);
var inst_38956 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_38878);
var inst_38957 = fluree.db.query.fql.s(f);
var inst_38958 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38956,inst_38957);
var inst_38959 = cljs.core.empty_QMARK_(inst_38934);
var inst_38960 = ((inst_38958) || (inst_38959));
var state_38976__$1 = (function (){var statearr_38981 = state_38976;
(statearr_38981[(10)] = inst_38954);

(statearr_38981[(11)] = inst_38955);

return statearr_38981;
})();
if(cljs.core.truth_(inst_38960)){
var statearr_38982_39036 = state_38976__$1;
(statearr_38982_39036[(1)] = (30));

} else {
var statearr_38983_39037 = state_38976__$1;
(statearr_38983_39037[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (1))){
var state_38976__$1 = state_38976;
var statearr_38984_39038 = state_38976__$1;
(statearr_38984_39038[(2)] = null);

(statearr_38984_39038[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (24))){
var inst_38878 = (state_38976[(8)]);
var inst_38934 = (state_38976[(9)]);
var inst_38934__$1 = (state_38976[(2)]);
var inst_38935 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38878,inst_38934__$1);
var inst_38939 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_38878);
var inst_38940 = fluree.db.query.fql.s(f);
var inst_38941 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38939,inst_38940);
var state_38976__$1 = (function (){var statearr_38985 = state_38976;
(statearr_38985[(12)] = inst_38935);

(statearr_38985[(9)] = inst_38934__$1);

return statearr_38985;
})();
if(inst_38941){
var statearr_38986_39039 = state_38976__$1;
(statearr_38986_39039[(1)] = (25));

} else {
var statearr_38987_39040 = state_38976__$1;
(statearr_38987_39040[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (4))){
var inst_38859 = (state_38976[(2)]);
var state_38976__$1 = state_38976;
var statearr_38988_39041 = state_38976__$1;
(statearr_38988_39041[(2)] = inst_38859);

(statearr_38988_39041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (15))){
var inst_38896 = (state_38976[(13)]);
var state_38976__$1 = state_38976;
var statearr_38989_39042 = state_38976__$1;
(statearr_38989_39042[(2)] = inst_38896);

(statearr_38989_39042[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (21))){
var inst_38922 = (state_38976[(2)]);
var state_38976__$1 = state_38976;
var statearr_38990_39043 = state_38976__$1;
(statearr_38990_39043[(2)] = inst_38922);

(statearr_38990_39043[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (31))){
var inst_38954 = (state_38976[(10)]);
var inst_38878 = (state_38976[(8)]);
var inst_38934 = (state_38976[(9)]);
var inst_38963 = cljs.core.assoc_in(inst_38878,inst_38934,inst_38954);
var state_38976__$1 = state_38976;
var statearr_38991_39044 = state_38976__$1;
(statearr_38991_39044[(2)] = inst_38963);

(statearr_38991_39044[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (32))){
var inst_38878 = (state_38976[(8)]);
var inst_38885 = (state_38976[(14)]);
var inst_38965 = (state_38976[(2)]);
var inst_38966 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38878,inst_38965);
var inst_38877 = inst_38885;
var inst_38878__$1 = inst_38966;
var state_38976__$1 = (function (){var statearr_38992 = state_38976;
(statearr_38992[(8)] = inst_38878__$1);

(statearr_38992[(15)] = inst_38877);

return statearr_38992;
})();
var statearr_38993_39045 = state_38976__$1;
(statearr_38993_39045[(2)] = null);

(statearr_38993_39045[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (13))){
var inst_38878 = (state_38976[(8)]);
var inst_38893 = (state_38976[(16)]);
var inst_38893__$1 = (state_38976[(2)]);
var inst_38894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38895 = [k];
var inst_38896 = (new cljs.core.PersistentVector(null,1,(5),inst_38894,inst_38895,null));
var inst_38897 = cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(inst_38878);
var inst_38898 = fluree.db.query.fql.s(f);
var inst_38899 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38897,inst_38898);
var inst_38900 = cljs.core.empty_QMARK_(inst_38893__$1);
var inst_38901 = (!(inst_38900));
var inst_38902 = ((inst_38899) && (inst_38901));
var state_38976__$1 = (function (){var statearr_38994 = state_38976;
(statearr_38994[(16)] = inst_38893__$1);

(statearr_38994[(13)] = inst_38896);

return statearr_38994;
})();
if(cljs.core.truth_(inst_38902)){
var statearr_38995_39046 = state_38976__$1;
(statearr_38995_39046[(1)] = (14));

} else {
var statearr_38996_39047 = state_38976__$1;
(statearr_38996_39047[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (22))){
var inst_38927 = (state_38976[(17)]);
var inst_38931 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_38927);
var state_38976__$1 = state_38976;
var statearr_38997_39048 = state_38976__$1;
(statearr_38997_39048[(2)] = inst_38931);

(statearr_38997_39048[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (29))){
var inst_38950 = (state_38976[(2)]);
var inst_38951 = fluree.db.util.async.throw_err(inst_38950);
var state_38976__$1 = state_38976;
var statearr_38998_39049 = state_38976__$1;
(statearr_38998_39049[(2)] = inst_38951);

(statearr_38998_39049[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (6))){
var inst_38877 = (state_38976[(15)]);
var inst_38884 = (state_38976[(18)]);
var inst_38883 = cljs.core.seq(inst_38877);
var inst_38884__$1 = cljs.core.first(inst_38883);
var inst_38885 = cljs.core.next(inst_38883);
var inst_38886 = cljs.core.not(inst_38884__$1);
var state_38976__$1 = (function (){var statearr_38999 = state_38976;
(statearr_38999[(14)] = inst_38885);

(statearr_38999[(18)] = inst_38884__$1);

return statearr_38999;
})();
if(inst_38886){
var statearr_39000_39050 = state_38976__$1;
(statearr_39000_39050[(1)] = (8));

} else {
var statearr_39001_39051 = state_38976__$1;
(statearr_39001_39051[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (28))){
var inst_38945 = (state_38976[(2)]);
var inst_38946 = fluree.db.util.async.throw_err(inst_38945);
var state_38976__$1 = state_38976;
var statearr_39002_39052 = state_38976__$1;
(statearr_39002_39052[(2)] = inst_38946);

(statearr_39002_39052[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (25))){
var inst_38878 = (state_38976[(8)]);
var inst_38943 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38878,pred_spec,f,component_follow_QMARK_,true);
var state_38976__$1 = state_38976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38976__$1,(28),inst_38943);
} else {
if((state_val_38977 === (17))){
var inst_38878 = (state_38976[(8)]);
var inst_38875 = (state_38976[(19)]);
var inst_38872 = (state_38976[(20)]);
var inst_38874 = (state_38976[(21)]);
var inst_38877 = (state_38976[(15)]);
var inst_38885 = (state_38976[(14)]);
var inst_38884 = (state_38976[(18)]);
var inst_38904 = (state_38976[(22)]);
var inst_38905 = (state_38976[(23)]);
var inst_38907 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38878,inst_38905);
var inst_38908 = (function (){var first__38882 = inst_38884;
var keys_SINGLEQUOTE_ = inst_38905;
var vec__38869 = inst_38872;
var first__38871 = inst_38874;
var r = inst_38885;
var child_path = inst_38904;
var acc__$1 = inst_38878;
var value = inst_38907;
var seq__38870 = inst_38875;
var seq__38881 = inst_38885;
var vec__38880 = inst_38877;
var G__38868 = inst_38877;
return (function (p1__38858_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_id.cljs$core$IFn$_invoke$arity$1(p1__38858_SHARP_),cljs.core.first(child_path));
});
})();
var inst_38909 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38908,inst_38907);
var inst_38910 = cljs.core.first(inst_38909);
var inst_38911 = inst_38907.indexOf(inst_38910);
var inst_38912 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38905,inst_38911);
var inst_38913 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38912,k);
var inst_38914 = cljs.core.rest(inst_38904);
var inst_38915 = cljs.core.count(inst_38914);
var inst_38916 = (inst_38915 > (0));
var state_38976__$1 = (function (){var statearr_39003 = state_38976;
(statearr_39003[(7)] = inst_38913);

return statearr_39003;
})();
if(cljs.core.truth_(inst_38916)){
var statearr_39004_39053 = state_38976__$1;
(statearr_39004_39053[(1)] = (19));

} else {
var statearr_39005_39054 = state_38976__$1;
(statearr_39005_39054[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (3))){
var inst_38974 = (state_38976[(2)]);
var state_38976__$1 = state_38976;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38976__$1,inst_38974);
} else {
if((state_val_38977 === (12))){
var inst_38884 = (state_38976[(18)]);
var inst_38891 = cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1(inst_38884);
var state_38976__$1 = state_38976;
var statearr_39006_39055 = state_38976__$1;
(statearr_39006_39055[(2)] = inst_38891);

(statearr_39006_39055[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (2))){
var inst_38872 = (state_38976[(20)]);
var _ = (function (){var statearr_39007 = state_38976;
(statearr_39007[(4)] = cljs.core.cons((5),(state_38976[(4)])));

return statearr_39007;
})();
var inst_38872__$1 = new_child_paths;
var inst_38873 = cljs.core.seq(inst_38872__$1);
var inst_38874 = cljs.core.first(inst_38873);
var inst_38875 = cljs.core.next(inst_38873);
var inst_38876 = acc;
var inst_38877 = inst_38872__$1;
var inst_38878 = inst_38876;
var state_38976__$1 = (function (){var statearr_39008 = state_38976;
(statearr_39008[(8)] = inst_38878);

(statearr_39008[(19)] = inst_38875);

(statearr_39008[(20)] = inst_38872__$1);

(statearr_39008[(21)] = inst_38874);

(statearr_39008[(15)] = inst_38877);

return statearr_39008;
})();
var statearr_39009_39056 = state_38976__$1;
(statearr_39009_39056[(2)] = null);

(statearr_39009_39056[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (23))){
var inst_38927 = (state_38976[(17)]);
var state_38976__$1 = state_38976;
var statearr_39010_39057 = state_38976__$1;
(statearr_39010_39057[(2)] = inst_38927);

(statearr_39010_39057[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (19))){
var inst_38913 = (state_38976[(7)]);
var inst_38904 = (state_38976[(22)]);
var inst_38918 = cljs.core.rest(inst_38904);
var inst_38904__$1 = inst_38918;
var inst_38905 = inst_38913;
var state_38976__$1 = (function (){var statearr_39011 = state_38976;
(statearr_39011[(22)] = inst_38904__$1);

(statearr_39011[(23)] = inst_38905);

return statearr_39011;
})();
var statearr_39012_39058 = state_38976__$1;
(statearr_39012_39058[(2)] = null);

(statearr_39012_39058[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (11))){
var inst_38884 = (state_38976[(18)]);
var state_38976__$1 = state_38976;
var statearr_39014_39059 = state_38976__$1;
(statearr_39014_39059[(2)] = inst_38884);

(statearr_39014_39059[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (9))){
var state_38976__$1 = state_38976;
if(cljs.core.truth_(parent_exists)){
var statearr_39015_39060 = state_38976__$1;
(statearr_39015_39060[(1)] = (11));

} else {
var statearr_39016_39061 = state_38976__$1;
(statearr_39016_39061[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (5))){
var _ = (function (){var statearr_39017 = state_38976;
(statearr_39017[(4)] = cljs.core.rest((state_38976[(4)])));

return statearr_39017;
})();
var state_38976__$1 = state_38976;
var ex39013 = (state_38976__$1[(2)]);
var statearr_39018_39062 = state_38976__$1;
(statearr_39018_39062[(5)] = ex39013);


if((ex39013 instanceof Error)){
var statearr_39019_39063 = state_38976__$1;
(statearr_39019_39063[(1)] = (4));

(statearr_39019_39063[(5)] = null);

} else {
throw ex39013;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (14))){
var inst_38893 = (state_38976[(16)]);
var inst_38896 = (state_38976[(13)]);
var inst_38904 = inst_38893;
var inst_38905 = inst_38896;
var state_38976__$1 = (function (){var statearr_39020 = state_38976;
(statearr_39020[(22)] = inst_38904);

(statearr_39020[(23)] = inst_38905);

return statearr_39020;
})();
var statearr_39021_39064 = state_38976__$1;
(statearr_39021_39064[(2)] = null);

(statearr_39021_39064[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (26))){
var inst_38935 = (state_38976[(12)]);
var inst_38948 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38935,pred_spec,f,component_follow_QMARK_,true);
var state_38976__$1 = state_38976;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38976__$1,(29),inst_38948);
} else {
if((state_val_38977 === (16))){
var inst_38927 = (state_38976[(17)]);
var inst_38927__$1 = (state_38976[(2)]);
var inst_38928 = cljs.core.count(inst_38927__$1);
var inst_38929 = (inst_38928 > (1));
var state_38976__$1 = (function (){var statearr_39022 = state_38976;
(statearr_39022[(17)] = inst_38927__$1);

return statearr_39022;
})();
if(cljs.core.truth_(inst_38929)){
var statearr_39023_39065 = state_38976__$1;
(statearr_39023_39065[(1)] = (22));

} else {
var statearr_39024_39066 = state_38976__$1;
(statearr_39024_39066[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (30))){
var inst_38954 = (state_38976[(10)]);
var state_38976__$1 = state_38976;
var statearr_39025_39067 = state_38976__$1;
(statearr_39025_39067[(2)] = inst_38954);

(statearr_39025_39067[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (10))){
var inst_38969 = (state_38976[(2)]);
var state_38976__$1 = state_38976;
var statearr_39026_39068 = state_38976__$1;
(statearr_39026_39068[(2)] = inst_38969);

(statearr_39026_39068[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (18))){
var inst_38924 = (state_38976[(2)]);
var state_38976__$1 = state_38976;
var statearr_39027_39069 = state_38976__$1;
(statearr_39027_39069[(2)] = inst_38924);

(statearr_39027_39069[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38977 === (8))){
var inst_38878 = (state_38976[(8)]);
var state_38976__$1 = state_38976;
var statearr_39028_39070 = state_38976__$1;
(statearr_39028_39070[(2)] = inst_38878);

(statearr_39028_39070[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____0 = (function (){
var statearr_39029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39029[(0)] = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__);

(statearr_39029[(1)] = (1));

return statearr_39029;
});
var fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____1 = (function (state_38976){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_38976);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e39030){var ex__16294__auto__ = e39030;
var statearr_39031_39071 = state_38976;
(statearr_39031_39071[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_38976[(4)]))){
var statearr_39032_39072 = state_38976;
(statearr_39032_39072[(1)] = cljs.core.first((state_38976[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__39073 = state_38976;
state_38976 = G__39073;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__ = function(state_38976){
switch(arguments.length){
case 0:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____1.call(this,state_38976);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____0;
fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto____1;
return fluree$db$query$fql$add_in_multi_flakes_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_39033 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_39033[(6)] = c__16328__auto__);

return statearr_39033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.flake__GT_recur_multi = (function fluree$db$query$fql$flake__GT_recur_multi(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache,component_follow_QMARK_){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_39186){
var state_val_39187 = (state_39186[(1)]);
if((state_val_39187 === (7))){
var inst_39089 = (state_39186[(7)]);
var inst_39089__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39186__$1 = (function (){var statearr_39188 = state_39186;
(statearr_39188[(7)] = inst_39089__$1);

return statearr_39188;
})();
if(cljs.core.truth_(inst_39089__$1)){
var statearr_39189_39255 = state_39186__$1;
(statearr_39189_39255[(1)] = (9));

} else {
var statearr_39190_39256 = state_39186__$1;
(statearr_39190_39256[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (20))){
var inst_39106 = (state_39186[(8)]);
var inst_39096 = (state_39186[(9)]);
var inst_39084 = (state_39186[(10)]);
var inst_39138 = (state_39186[(2)]);
var inst_39139 = fluree.db.query.fql.add_in_multi_flakes(inst_39084,inst_39106,inst_39096,f,db,cache,fuel,max_fuel,pred_spec,component_follow_QMARK_,false);
var state_39186__$1 = (function (){var statearr_39191 = state_39186;
(statearr_39191[(11)] = inst_39138);

return statearr_39191;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39186__$1,(25),inst_39139);
} else {
if((state_val_39187 === (27))){
var inst_39108 = (state_39186[(12)]);
var inst_39145 = cljs.core.not(inst_39108);
var state_39186__$1 = state_39186;
var statearr_39192_39257 = state_39186__$1;
(statearr_39192_39257[(2)] = inst_39145);

(statearr_39192_39257[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (1))){
var state_39186__$1 = state_39186;
var statearr_39193_39258 = state_39186__$1;
(statearr_39193_39258[(2)] = null);

(statearr_39193_39258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (24))){
var inst_39132 = (state_39186[(2)]);
var inst_39133 = fluree.db.util.async.throw_err(inst_39132);
var state_39186__$1 = state_39186;
var statearr_39194_39259 = state_39186__$1;
(statearr_39194_39259[(2)] = inst_39133);

(statearr_39194_39259[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (39))){
var inst_39164 = (state_39186[(13)]);
var inst_39166 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_39167 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39166,inst_39164);
var state_39186__$1 = state_39186;
var statearr_39195_39260 = state_39186__$1;
(statearr_39195_39260[(2)] = inst_39167);

(statearr_39195_39260[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (4))){
var inst_39074 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
var statearr_39196_39261 = state_39186__$1;
(statearr_39196_39261[(2)] = inst_39074);

(statearr_39196_39261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (15))){
var inst_39114 = (state_39186[(14)]);
var state_39186__$1 = state_39186;
var statearr_39197_39262 = state_39186__$1;
(statearr_39197_39262[(2)] = inst_39114);

(statearr_39197_39262[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (21))){
var inst_39127 = (state_39186[(15)]);
var inst_39129 = f.o;
var inst_39130 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_39129,inst_39127);
var state_39186__$1 = state_39186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39186__$1,(24),inst_39130);
} else {
if((state_val_39187 === (31))){
var inst_39107 = (state_39186[(16)]);
var inst_39142 = (state_39186[(17)]);
var inst_39178 = (state_39186[(2)]);
var inst_39179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39180 = [inst_39142,inst_39178,inst_39107];
var inst_39181 = (new cljs.core.PersistentVector(null,3,(5),inst_39179,inst_39180,null));
var _ = (function (){var statearr_39198 = state_39186;
(statearr_39198[(4)] = cljs.core.rest((state_39186[(4)])));

return statearr_39198;
})();
var state_39186__$1 = state_39186;
var statearr_39199_39263 = state_39186__$1;
(statearr_39199_39263[(2)] = inst_39181);

(statearr_39199_39263[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (32))){
var inst_39138 = (state_39186[(11)]);
var inst_39152 = cljs.core.rest(flakes);
var inst_39153 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39152,inst_39138);
var state_39186__$1 = state_39186;
var statearr_39200_39264 = state_39186__$1;
(statearr_39200_39264[(2)] = inst_39153);

(statearr_39200_39264[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (40))){
var inst_39164 = (state_39186[(13)]);
var state_39186__$1 = state_39186;
var statearr_39201_39265 = state_39186__$1;
(statearr_39201_39265[(2)] = inst_39164);

(statearr_39201_39265[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (33))){
var state_39186__$1 = state_39186;
var statearr_39202_39266 = state_39186__$1;
(statearr_39202_39266[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (13))){
var state_39186__$1 = state_39186;
var statearr_39204_39267 = state_39186__$1;
(statearr_39204_39267[(2)] = false);

(statearr_39204_39267[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (22))){
var state_39186__$1 = state_39186;
var statearr_39205_39268 = state_39186__$1;
(statearr_39205_39268[(2)] = null);

(statearr_39205_39268[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (36))){
var state_39186__$1 = state_39186;
var statearr_39206_39269 = state_39186__$1;
(statearr_39206_39269[(2)] = null);

(statearr_39206_39269[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (41))){
var inst_39156 = (state_39186[(18)]);
var inst_39170 = (state_39186[(2)]);
var inst_39171 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39156,inst_39170);
var state_39186__$1 = state_39186;
var statearr_39207_39270 = state_39186__$1;
(statearr_39207_39270[(2)] = inst_39171);

(statearr_39207_39270[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (29))){
var inst_39149 = cljs.core.rest(flakes);
var state_39186__$1 = state_39186;
var statearr_39208_39271 = state_39186__$1;
(statearr_39208_39271[(2)] = inst_39149);

(statearr_39208_39271[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (6))){
var inst_39086 = (state_39186[(19)]);
var state_39186__$1 = state_39186;
var statearr_39209_39272 = state_39186__$1;
(statearr_39209_39272[(2)] = inst_39086);

(statearr_39209_39272[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (28))){
var inst_39147 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
if(cljs.core.truth_(inst_39147)){
var statearr_39210_39273 = state_39186__$1;
(statearr_39210_39273[(1)] = (29));

} else {
var statearr_39211_39274 = state_39186__$1;
(statearr_39211_39274[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (25))){
var inst_39114 = (state_39186[(14)]);
var inst_39141 = (state_39186[(2)]);
var inst_39142 = fluree.db.util.async.throw_err(inst_39141);
var state_39186__$1 = (function (){var statearr_39212 = state_39186;
(statearr_39212[(17)] = inst_39142);

return statearr_39212;
})();
if(cljs.core.truth_(inst_39114)){
var statearr_39213_39275 = state_39186__$1;
(statearr_39213_39275[(1)] = (26));

} else {
var statearr_39214_39276 = state_39186__$1;
(statearr_39214_39276[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (34))){
var inst_39176 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
var statearr_39215_39277 = state_39186__$1;
(statearr_39215_39277[(2)] = inst_39176);

(statearr_39215_39277[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (17))){
var inst_39119 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
if(cljs.core.truth_(inst_39119)){
var statearr_39216_39278 = state_39186__$1;
(statearr_39216_39278[(1)] = (18));

} else {
var statearr_39217_39279 = state_39186__$1;
(statearr_39217_39279[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (3))){
var inst_39184 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39186__$1,inst_39184);
} else {
if((state_val_39187 === (12))){
var inst_39100 = (state_39186[(20)]);
var state_39186__$1 = state_39186;
var statearr_39218_39280 = state_39186__$1;
(statearr_39218_39280[(2)] = inst_39100);

(statearr_39218_39280[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (2))){
var inst_39086 = (state_39186[(19)]);
var _ = (function (){var statearr_39219 = state_39186;
(statearr_39219[(4)] = cljs.core.cons((5),(state_39186[(4)])));

return statearr_39219;
})();
var inst_39083 = fluree.db.query.fql.s(f);
var inst_39084 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$_id,inst_39083);
var inst_39085 = fluree.db.query.fql.o(f);
var inst_39086__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39186__$1 = (function (){var statearr_39220 = state_39186;
(statearr_39220[(21)] = inst_39085);

(statearr_39220[(19)] = inst_39086__$1);

(statearr_39220[(10)] = inst_39084);

return statearr_39220;
})();
if(cljs.core.truth_(inst_39086__$1)){
var statearr_39221_39281 = state_39186__$1;
(statearr_39221_39281[(1)] = (6));

} else {
var statearr_39222_39282 = state_39186__$1;
(statearr_39222_39282[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (23))){
var inst_39136 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
var statearr_39223_39283 = state_39186__$1;
(statearr_39223_39283[(2)] = inst_39136);

(statearr_39223_39283[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (35))){
var inst_39085 = (state_39186[(21)]);
var inst_39156 = cljs.core.rest(flakes);
var inst_39158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39159 = [inst_39085];
var inst_39160 = (new cljs.core.PersistentVector(null,1,(5),inst_39158,inst_39159,null));
var inst_39161 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39160);
var state_39186__$1 = (function (){var statearr_39224 = state_39186;
(statearr_39224[(18)] = inst_39156);

return statearr_39224;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39186__$1,(38),inst_39161);
} else {
if((state_val_39187 === (19))){
var inst_39107 = (state_39186[(16)]);
var inst_39127 = (state_39186[(15)]);
var inst_39122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39123 = f.p;
var inst_39124 = [cljs.core.cst$kw$select_DASH_specs,inst_39123];
var inst_39125 = (new cljs.core.PersistentVector(null,2,(5),inst_39122,inst_39124,null));
var inst_39126 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39107,inst_39125);
var inst_39127__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_39126);
var state_39186__$1 = (function (){var statearr_39225 = state_39186;
(statearr_39225[(15)] = inst_39127__$1);

return statearr_39225;
})();
if(cljs.core.truth_(inst_39127__$1)){
var statearr_39226_39284 = state_39186__$1;
(statearr_39226_39284[(1)] = (21));

} else {
var statearr_39227_39285 = state_39186__$1;
(statearr_39227_39285[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (11))){
var inst_39094 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
var statearr_39229_39286 = state_39186__$1;
(statearr_39229_39286[(2)] = inst_39094);

(statearr_39229_39286[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (9))){
var inst_39089 = (state_39186[(7)]);
var state_39186__$1 = state_39186;
var statearr_39230_39287 = state_39186__$1;
(statearr_39230_39287[(2)] = inst_39089);

(statearr_39230_39287[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (5))){
var _ = (function (){var statearr_39231 = state_39186;
(statearr_39231[(4)] = cljs.core.rest((state_39186[(4)])));

return statearr_39231;
})();
var state_39186__$1 = state_39186;
var ex39228 = (state_39186__$1[(2)]);
var statearr_39232_39288 = state_39186__$1;
(statearr_39232_39288[(5)] = ex39228);


if((ex39228 instanceof Error)){
var statearr_39233_39289 = state_39186__$1;
(statearr_39233_39289[(1)] = (4));

(statearr_39233_39289[(5)] = null);

} else {
throw ex39228;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (14))){
var inst_39107 = (state_39186[(16)]);
var inst_39096 = (state_39186[(9)]);
var inst_39114 = (state_39186[(14)]);
var inst_39104 = (state_39186[(2)]);
var inst_39105 = fluree.db.query.fql.get_recursion_map_multi(recursion_map,inst_39096,f,select_spec,inst_39104);
var inst_39106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39105,(0),null);
var inst_39107__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39105,(1),null);
var inst_39108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39105,(2),null);
var inst_39109 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39111 = [inst_39096,cljs.core.cst$kw$depth];
var inst_39112 = (new cljs.core.PersistentVector(null,2,(5),inst_39110,inst_39111,null));
var inst_39113 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39107__$1,inst_39112);
var inst_39114__$1 = (inst_39109 < inst_39113);
var state_39186__$1 = (function (){var statearr_39234 = state_39186;
(statearr_39234[(12)] = inst_39108);

(statearr_39234[(8)] = inst_39106);

(statearr_39234[(16)] = inst_39107__$1);

(statearr_39234[(14)] = inst_39114__$1);

return statearr_39234;
})();
if(cljs.core.truth_(inst_39114__$1)){
var statearr_39235_39290 = state_39186__$1;
(statearr_39235_39290[(1)] = (15));

} else {
var statearr_39236_39291 = state_39186__$1;
(statearr_39236_39291[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (26))){
var inst_39114 = (state_39186[(14)]);
var state_39186__$1 = state_39186;
var statearr_39237_39292 = state_39186__$1;
(statearr_39237_39292[(2)] = inst_39114);

(statearr_39237_39292[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (16))){
var inst_39108 = (state_39186[(12)]);
var inst_39117 = cljs.core.not(inst_39108);
var state_39186__$1 = state_39186;
var statearr_39238_39293 = state_39186__$1;
(statearr_39238_39293[(2)] = inst_39117);

(statearr_39238_39293[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (38))){
var inst_39163 = (state_39186[(2)]);
var inst_39164 = fluree.db.util.async.throw_err(inst_39163);
var state_39186__$1 = (function (){var statearr_39239 = state_39186;
(statearr_39239[(13)] = inst_39164);

return statearr_39239;
})();
if(cljs.core.truth_(fuel)){
var statearr_39240_39294 = state_39186__$1;
(statearr_39240_39294[(1)] = (39));

} else {
var statearr_39241_39295 = state_39186__$1;
(statearr_39241_39295[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (30))){
var inst_39138 = (state_39186[(11)]);
var state_39186__$1 = state_39186;
if(cljs.core.truth_(inst_39138)){
var statearr_39242_39296 = state_39186__$1;
(statearr_39242_39296[(1)] = (32));

} else {
var statearr_39243_39297 = state_39186__$1;
(statearr_39243_39297[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (10))){
var inst_39092 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39186__$1 = state_39186;
var statearr_39244_39298 = state_39186__$1;
(statearr_39244_39298[(2)] = inst_39092);

(statearr_39244_39298[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (18))){
var state_39186__$1 = state_39186;
var statearr_39245_39299 = state_39186__$1;
(statearr_39245_39299[(2)] = null);

(statearr_39245_39299[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (37))){
var inst_39174 = (state_39186[(2)]);
var state_39186__$1 = state_39186;
var statearr_39246_39300 = state_39186__$1;
(statearr_39246_39300[(2)] = inst_39174);

(statearr_39246_39300[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39187 === (8))){
var inst_39100 = (state_39186[(20)]);
var inst_39085 = (state_39186[(21)]);
var inst_39096 = (state_39186[(9)]);
var inst_39096__$1 = (state_39186[(2)]);
var inst_39097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39098 = [inst_39096__$1,inst_39085];
var inst_39099 = (new cljs.core.PersistentVector(null,2,(5),inst_39097,inst_39098,null));
var inst_39100__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_39099);
var state_39186__$1 = (function (){var statearr_39247 = state_39186;
(statearr_39247[(20)] = inst_39100__$1);

(statearr_39247[(9)] = inst_39096__$1);

return statearr_39247;
})();
if(cljs.core.truth_(inst_39100__$1)){
var statearr_39248_39301 = state_39186__$1;
(statearr_39248_39301[(1)] = (12));

} else {
var statearr_39249_39302 = state_39186__$1;
(statearr_39249_39302[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____0 = (function (){
var statearr_39250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39250[(0)] = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__);

(statearr_39250[(1)] = (1));

return statearr_39250;
});
var fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____1 = (function (state_39186){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_39186);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e39251){var ex__16294__auto__ = e39251;
var statearr_39252_39303 = state_39186;
(statearr_39252_39303[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_39186[(4)]))){
var statearr_39253_39304 = state_39186;
(statearr_39253_39304[(1)] = cljs.core.first((state_39186[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__39305 = state_39186;
state_39186 = G__39305;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__ = function(state_39186){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____1.call(this,state_39186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____0;
fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto____1;
return fluree$db$query$fql$flake__GT_recur_multi_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_39254 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_39254[(6)] = c__16328__auto__);

return statearr_39254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.get_recursion_map = (function fluree$db$query$fql$get_recursion_map(db,recursion_map,select_spec,cache,k,f){
var select_spec__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,f.p], null));
var full_select_spec = (cljs.core.truth_(fluree.db.query.fql.has_ns_lookups_QMARK_(select_spec__$1))?fluree.db.query.fql.full_select_spec(db,cache,select_spec__$1,fluree.db.query.fql.s(f)):select_spec__$1);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(recursion_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,fluree.db.query.fql.s(f)], null),(0)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred_DASH_ids,k], null),f.p),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select_DASH_specs,f.p], null),full_select_spec);
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,f,pred_spec,recursion_map,flakes,acc,fuel,max_fuel,select_spec,cache){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_39468){
var state_val_39469 = (state_39468[(1)]);
if((state_val_39469 === (7))){
var inst_39317 = (state_39468[(7)]);
var inst_39317__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39468__$1 = (function (){var statearr_39470 = state_39468;
(statearr_39470[(7)] = inst_39317__$1);

return statearr_39470;
})();
if(cljs.core.truth_(inst_39317__$1)){
var statearr_39471_39569 = state_39468__$1;
(statearr_39471_39569[(1)] = (9));

} else {
var statearr_39472_39570 = state_39468__$1;
(statearr_39472_39570[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (59))){
var inst_39449 = (state_39468[(8)]);
var inst_39451 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_39452 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39451,inst_39449);
var state_39468__$1 = state_39468;
var statearr_39473_39571 = state_39468__$1;
(statearr_39473_39571[(2)] = inst_39452);

(statearr_39473_39571[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (20))){
var inst_39324 = (state_39468[(9)]);
var inst_39356 = (state_39468[(10)]);
var inst_39351 = (state_39468[(11)]);
var inst_39351__$1 = (state_39468[(2)]);
var inst_39352 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39351__$1,inst_39324);
var inst_39354 = cljs.core.vals(inst_39353);
var inst_39355 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,inst_39354);
var inst_39356__$1 = (inst_39352 < inst_39355);
var state_39468__$1 = (function (){var statearr_39474 = state_39468;
(statearr_39474[(10)] = inst_39356__$1);

(statearr_39474[(11)] = inst_39351__$1);

return statearr_39474;
})();
if(cljs.core.truth_(inst_39356__$1)){
var statearr_39475_39572 = state_39468__$1;
(statearr_39475_39572[(1)] = (21));

} else {
var statearr_39476_39573 = state_39468__$1;
(statearr_39476_39573[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (58))){
var inst_39448 = (state_39468[(2)]);
var inst_39449 = fluree.db.util.async.throw_err(inst_39448);
var state_39468__$1 = (function (){var statearr_39477 = state_39468;
(statearr_39477[(8)] = inst_39449);

return statearr_39477;
})();
if(cljs.core.truth_(fuel)){
var statearr_39478_39574 = state_39468__$1;
(statearr_39478_39574[(1)] = (59));

} else {
var statearr_39479_39575 = state_39468__$1;
(statearr_39479_39575[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (60))){
var inst_39449 = (state_39468[(8)]);
var state_39468__$1 = state_39468;
var statearr_39480_39576 = state_39468__$1;
(statearr_39480_39576[(2)] = inst_39449);

(statearr_39480_39576[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (27))){
var inst_39368 = (state_39468[(12)]);
var inst_39370 = f.o;
var inst_39371 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_39370,inst_39368);
var state_39468__$1 = state_39468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39468__$1,(30),inst_39371);
} else {
if((state_val_39469 === (1))){
var state_39468__$1 = state_39468;
var statearr_39481_39577 = state_39468__$1;
(statearr_39481_39577[(2)] = null);

(statearr_39481_39577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (24))){
var state_39468__$1 = state_39468;
var statearr_39482_39578 = state_39468__$1;
(statearr_39482_39578[(2)] = null);

(statearr_39482_39578[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (55))){
var inst_39439 = cljs.core.rest(flakes);
var state_39468__$1 = state_39468;
var statearr_39483_39579 = state_39468__$1;
(statearr_39483_39579[(2)] = inst_39439);

(statearr_39483_39579[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (39))){
var inst_39379 = (state_39468[(13)]);
var inst_39409 = (state_39468[(2)]);
var state_39468__$1 = (function (){var statearr_39484 = state_39468;
(statearr_39484[(14)] = inst_39409);

return statearr_39484;
})();
if(cljs.core.truth_(inst_39379)){
var statearr_39485_39580 = state_39468__$1;
(statearr_39485_39580[(1)] = (40));

} else {
var statearr_39486_39581 = state_39468__$1;
(statearr_39486_39581[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (46))){
var state_39468__$1 = state_39468;
var statearr_39487_39582 = state_39468__$1;
(statearr_39487_39582[(2)] = acc);

(statearr_39487_39582[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (4))){
var inst_39306 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39488_39583 = state_39468__$1;
(statearr_39488_39583[(2)] = inst_39306);

(statearr_39488_39583[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (54))){
var inst_39437 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39437)){
var statearr_39489_39584 = state_39468__$1;
(statearr_39489_39584[(1)] = (55));

} else {
var statearr_39490_39585 = state_39468__$1;
(statearr_39490_39585[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (15))){
var inst_39324 = (state_39468[(9)]);
var inst_39339 = fluree.db.query.fql.get_recursion_map(db,recursion_map,select_spec,cache,inst_39324,f);
var state_39468__$1 = state_39468;
var statearr_39491_39586 = state_39468__$1;
(statearr_39491_39586[(2)] = inst_39339);

(statearr_39491_39586[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (48))){
var inst_39431 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39492_39587 = state_39468__$1;
(statearr_39492_39587[(2)] = inst_39431);

(statearr_39492_39587[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (50))){
var state_39468__$1 = state_39468;
var statearr_39493_39588 = state_39468__$1;
(statearr_39493_39588[(2)] = null);

(statearr_39493_39588[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (21))){
var inst_39356 = (state_39468[(10)]);
var state_39468__$1 = state_39468;
var statearr_39494_39589 = state_39468__$1;
(statearr_39494_39589[(2)] = inst_39356);

(statearr_39494_39589[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (31))){
var inst_39324 = (state_39468[(9)]);
var inst_39328 = (state_39468[(15)]);
var inst_39381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39328,inst_39324);
var inst_39382 = cljs.core.count(inst_39381);
var inst_39383 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39384 = (inst_39382 > inst_39383);
var state_39468__$1 = state_39468;
var statearr_39495_39590 = state_39468__$1;
(statearr_39495_39590[(2)] = inst_39384);

(statearr_39495_39590[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (32))){
var inst_39313 = (state_39468[(16)]);
var state_39468__$1 = state_39468;
var statearr_39496_39591 = state_39468__$1;
(statearr_39496_39591[(2)] = inst_39313);

(statearr_39496_39591[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (40))){
var inst_39324 = (state_39468[(9)]);
var inst_39379 = (state_39468[(13)]);
var inst_39409 = (state_39468[(14)]);
var inst_39411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39409,inst_39324);
var inst_39412 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39411,inst_39379], 0));
var inst_39413 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39409,inst_39324,inst_39412);
var state_39468__$1 = state_39468;
var statearr_39497_39592 = state_39468__$1;
(statearr_39497_39592[(2)] = inst_39413);

(statearr_39497_39592[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (56))){
var inst_39312 = (state_39468[(17)]);
var inst_39441 = cljs.core.rest(flakes);
var inst_39443 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39444 = [inst_39312];
var inst_39445 = (new cljs.core.PersistentVector(null,1,(5),inst_39443,inst_39444,null));
var inst_39446 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39445);
var state_39468__$1 = (function (){var statearr_39498 = state_39468;
(statearr_39498[(18)] = inst_39441);

return statearr_39498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39468__$1,(58),inst_39446);
} else {
if((state_val_39469 === (33))){
var inst_39387 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39387)){
var statearr_39499_39593 = state_39468__$1;
(statearr_39499_39593[(1)] = (34));

} else {
var statearr_39500_39594 = state_39468__$1;
(statearr_39500_39594[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (13))){
var state_39468__$1 = state_39468;
var statearr_39501_39595 = state_39468__$1;
(statearr_39501_39595[(2)] = false);

(statearr_39501_39595[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (22))){
var inst_39336 = (state_39468[(19)]);
var state_39468__$1 = state_39468;
var statearr_39502_39596 = state_39468__$1;
(statearr_39502_39596[(2)] = inst_39336);

(statearr_39502_39596[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (36))){
var inst_39463 = (state_39468[(2)]);
var _ = (function (){var statearr_39503 = state_39468;
(statearr_39503[(4)] = cljs.core.rest((state_39468[(4)])));

return statearr_39503;
})();
var state_39468__$1 = state_39468;
var statearr_39504_39597 = state_39468__$1;
(statearr_39504_39597[(2)] = inst_39463);

(statearr_39504_39597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (41))){
var inst_39409 = (state_39468[(14)]);
var state_39468__$1 = state_39468;
var statearr_39505_39598 = state_39468__$1;
(statearr_39505_39598[(2)] = inst_39409);

(statearr_39505_39598[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (43))){
var inst_39416 = (state_39468[(20)]);
var state_39468__$1 = state_39468;
var statearr_39506_39599 = state_39468__$1;
(statearr_39506_39599[(2)] = inst_39416);

(statearr_39506_39599[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (61))){
var inst_39441 = (state_39468[(18)]);
var inst_39455 = (state_39468[(2)]);
var inst_39456 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39441,inst_39455);
var state_39468__$1 = state_39468;
var statearr_39507_39600 = state_39468__$1;
(statearr_39507_39600[(2)] = inst_39456);

(statearr_39507_39600[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (29))){
var inst_39377 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39508_39601 = state_39468__$1;
(statearr_39508_39601[(2)] = inst_39377);

(statearr_39508_39601[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (44))){
var inst_39336 = (state_39468[(19)]);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39336)){
var statearr_39509_39602 = state_39468__$1;
(statearr_39509_39602[(1)] = (46));

} else {
var statearr_39510_39603 = state_39468__$1;
(statearr_39510_39603[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (6))){
var inst_39314 = (state_39468[(21)]);
var state_39468__$1 = state_39468;
var statearr_39511_39604 = state_39468__$1;
(statearr_39511_39604[(2)] = inst_39314);

(statearr_39511_39604[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (28))){
var state_39468__$1 = state_39468;
var statearr_39512_39605 = state_39468__$1;
(statearr_39512_39605[(2)] = null);

(statearr_39512_39605[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (51))){
var inst_39429 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39513_39606 = state_39468__$1;
(statearr_39513_39606[(2)] = inst_39429);

(statearr_39513_39606[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (25))){
var inst_39368 = (state_39468[(12)]);
var inst_39351 = (state_39468[(11)]);
var inst_39363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39364 = f.p;
var inst_39365 = [cljs.core.cst$kw$select_DASH_specs,inst_39364];
var inst_39366 = (new cljs.core.PersistentVector(null,2,(5),inst_39363,inst_39365,null));
var inst_39367 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39351,inst_39366);
var inst_39368__$1 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_39367);
var state_39468__$1 = (function (){var statearr_39514 = state_39468;
(statearr_39514[(12)] = inst_39368__$1);

return statearr_39514;
})();
if(cljs.core.truth_(inst_39368__$1)){
var statearr_39515_39607 = state_39468__$1;
(statearr_39515_39607[(1)] = (27));

} else {
var statearr_39516_39608 = state_39468__$1;
(statearr_39516_39608[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (34))){
var inst_39351 = (state_39468[(11)]);
var inst_39389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39390 = cljs.core.rest(flakes);
var inst_39391 = [acc,inst_39390,inst_39351];
var inst_39392 = (new cljs.core.PersistentVector(null,3,(5),inst_39389,inst_39391,null));
var state_39468__$1 = state_39468;
var statearr_39517_39609 = state_39468__$1;
(statearr_39517_39609[(2)] = inst_39392);

(statearr_39517_39609[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (17))){
var inst_39336 = (state_39468[(19)]);
var inst_39342 = (state_39468[(2)]);
var state_39468__$1 = (function (){var statearr_39518 = state_39468;
(statearr_39518[(22)] = inst_39342);

return statearr_39518;
})();
if(cljs.core.truth_(inst_39336)){
var statearr_39519_39610 = state_39468__$1;
(statearr_39519_39610[(1)] = (18));

} else {
var statearr_39520_39611 = state_39468__$1;
(statearr_39520_39611[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (3))){
var inst_39466 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39468__$1,inst_39466);
} else {
if((state_val_39469 === (12))){
var inst_39332 = (state_39468[(23)]);
var state_39468__$1 = state_39468;
var statearr_39521_39612 = state_39468__$1;
(statearr_39521_39612[(2)] = inst_39332);

(statearr_39521_39612[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (2))){
var inst_39314 = (state_39468[(21)]);
var _ = (function (){var statearr_39522 = state_39468;
(statearr_39522[(4)] = cljs.core.cons((5),(state_39468[(4)])));

return statearr_39522;
})();
var inst_39312 = f.o;
var inst_39313 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_39314__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39468__$1 = (function (){var statearr_39523 = state_39468;
(statearr_39523[(21)] = inst_39314__$1);

(statearr_39523[(16)] = inst_39313);

(statearr_39523[(17)] = inst_39312);

return statearr_39523;
})();
if(cljs.core.truth_(inst_39314__$1)){
var statearr_39524_39613 = state_39468__$1;
(statearr_39524_39613[(1)] = (6));

} else {
var statearr_39525_39614 = state_39468__$1;
(statearr_39525_39614[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (23))){
var inst_39360 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39360)){
var statearr_39526_39615 = state_39468__$1;
(statearr_39526_39615[(1)] = (24));

} else {
var statearr_39527_39616 = state_39468__$1;
(statearr_39527_39616[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (47))){
var state_39468__$1 = state_39468;
var statearr_39528_39617 = state_39468__$1;
(statearr_39528_39617[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (35))){
var inst_39313 = (state_39468[(16)]);
var state_39468__$1 = state_39468;
if(cljs.core.truth_(inst_39313)){
var statearr_39530_39618 = state_39468__$1;
(statearr_39530_39618[(1)] = (37));

} else {
var statearr_39531_39619 = state_39468__$1;
(statearr_39531_39619[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (19))){
var inst_39342 = (state_39468[(22)]);
var inst_39324 = (state_39468[(9)]);
var inst_39312 = (state_39468[(17)]);
var inst_39345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39346 = [inst_39324,inst_39312];
var inst_39347 = (new cljs.core.PersistentVector(null,2,(5),inst_39345,inst_39346,null));
var inst_39348 = ((0) + (1));
var inst_39349 = cljs.core.assoc_in(inst_39342,inst_39347,inst_39348);
var state_39468__$1 = state_39468;
var statearr_39532_39620 = state_39468__$1;
(statearr_39532_39620[(2)] = inst_39349);

(statearr_39532_39620[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (57))){
var inst_39433 = (state_39468[(24)]);
var inst_39351 = (state_39468[(11)]);
var inst_39458 = (state_39468[(2)]);
var inst_39459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39460 = [inst_39433,inst_39458,inst_39351];
var inst_39461 = (new cljs.core.PersistentVector(null,3,(5),inst_39459,inst_39460,null));
var state_39468__$1 = state_39468;
var statearr_39533_39621 = state_39468__$1;
(statearr_39533_39621[(2)] = inst_39461);

(statearr_39533_39621[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (11))){
var inst_39322 = (state_39468[(2)]);
var state_39468__$1 = state_39468;
var statearr_39535_39622 = state_39468__$1;
(statearr_39535_39622[(2)] = inst_39322);

(statearr_39535_39622[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (9))){
var inst_39317 = (state_39468[(7)]);
var state_39468__$1 = state_39468;
var statearr_39536_39623 = state_39468__$1;
(statearr_39536_39623[(2)] = inst_39317);

(statearr_39536_39623[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (5))){
var _ = (function (){var statearr_39537 = state_39468;
(statearr_39537[(4)] = cljs.core.rest((state_39468[(4)])));

return statearr_39537;
})();
var state_39468__$1 = state_39468;
var ex39534 = (state_39468__$1[(2)]);
var statearr_39538_39624 = state_39468__$1;
(statearr_39538_39624[(5)] = ex39534);


if((ex39534 instanceof Error)){
var statearr_39539_39625 = state_39468__$1;
(statearr_39539_39625[(1)] = (4));

(statearr_39539_39625[(5)] = null);

} else {
throw ex39534;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (14))){
var inst_39336 = (state_39468[(19)]);
var inst_39336__$1 = (state_39468[(2)]);
var inst_39337 = cljs.core.not(inst_39336__$1);
var state_39468__$1 = (function (){var statearr_39540 = state_39468;
(statearr_39540[(19)] = inst_39336__$1);

return statearr_39540;
})();
if(inst_39337){
var statearr_39541_39626 = state_39468__$1;
(statearr_39541_39626[(1)] = (15));

} else {
var statearr_39542_39627 = state_39468__$1;
(statearr_39542_39627[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (45))){
var inst_39356 = (state_39468[(10)]);
var inst_39433 = (state_39468[(2)]);
var state_39468__$1 = (function (){var statearr_39543 = state_39468;
(statearr_39543[(24)] = inst_39433);

return statearr_39543;
})();
if(cljs.core.truth_(inst_39356)){
var statearr_39544_39628 = state_39468__$1;
(statearr_39544_39628[(1)] = (52));

} else {
var statearr_39545_39629 = state_39468__$1;
(statearr_39545_39629[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (53))){
var inst_39336 = (state_39468[(19)]);
var state_39468__$1 = state_39468;
var statearr_39546_39630 = state_39468__$1;
(statearr_39546_39630[(2)] = inst_39336);

(statearr_39546_39630[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (26))){
var inst_39313 = (state_39468[(16)]);
var inst_39379 = (state_39468[(2)]);
var state_39468__$1 = (function (){var statearr_39547 = state_39468;
(statearr_39547[(13)] = inst_39379);

return statearr_39547;
})();
if(cljs.core.truth_(inst_39313)){
var statearr_39548_39631 = state_39468__$1;
(statearr_39548_39631[(1)] = (31));

} else {
var statearr_39549_39632 = state_39468__$1;
(statearr_39549_39632[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (16))){
var state_39468__$1 = state_39468;
var statearr_39550_39633 = state_39468__$1;
(statearr_39550_39633[(2)] = recursion_map);

(statearr_39550_39633[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (38))){
var inst_39324 = (state_39468[(9)]);
var inst_39312 = (state_39468[(17)]);
var inst_39328 = (state_39468[(15)]);
var inst_39404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39405 = [inst_39324,cljs.core.cst$kw$_id];
var inst_39406 = (new cljs.core.PersistentVector(null,2,(5),inst_39404,inst_39405,null));
var inst_39407 = cljs.core.assoc_in(inst_39328,inst_39406,inst_39312);
var state_39468__$1 = state_39468;
var statearr_39551_39634 = state_39468__$1;
(statearr_39551_39634[(2)] = inst_39407);

(statearr_39551_39634[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (30))){
var inst_39373 = (state_39468[(2)]);
var inst_39374 = fluree.db.util.async.throw_err(inst_39373);
var state_39468__$1 = state_39468;
var statearr_39552_39635 = state_39468__$1;
(statearr_39552_39635[(2)] = inst_39374);

(statearr_39552_39635[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (10))){
var inst_39320 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_39468__$1 = state_39468;
var statearr_39553_39636 = state_39468__$1;
(statearr_39553_39636[(2)] = inst_39320);

(statearr_39553_39636[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (18))){
var inst_39342 = (state_39468[(22)]);
var state_39468__$1 = state_39468;
var statearr_39554_39637 = state_39468__$1;
(statearr_39554_39637[(2)] = inst_39342);

(statearr_39554_39637[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (52))){
var inst_39356 = (state_39468[(10)]);
var state_39468__$1 = state_39468;
var statearr_39555_39638 = state_39468__$1;
(statearr_39555_39638[(2)] = inst_39356);

(statearr_39555_39638[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (42))){
var inst_39336 = (state_39468[(19)]);
var inst_39416 = (state_39468[(2)]);
var inst_39417 = cljs.core.not(inst_39336);
var state_39468__$1 = (function (){var statearr_39556 = state_39468;
(statearr_39556[(20)] = inst_39416);

return statearr_39556;
})();
if(inst_39417){
var statearr_39557_39639 = state_39468__$1;
(statearr_39557_39639[(1)] = (43));

} else {
var statearr_39558_39640 = state_39468__$1;
(statearr_39558_39640[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (37))){
var inst_39324 = (state_39468[(9)]);
var inst_39312 = (state_39468[(17)]);
var inst_39328 = (state_39468[(15)]);
var inst_39395 = cljs.core.PersistentVector.EMPTY;
var inst_39396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39328,inst_39324);
var inst_39397 = [cljs.core.cst$kw$_id];
var inst_39398 = [inst_39312];
var inst_39399 = cljs.core.PersistentHashMap.fromArrays(inst_39397,inst_39398);
var inst_39400 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39396,inst_39399);
var inst_39401 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39395,inst_39400);
var inst_39402 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39328,inst_39324,inst_39401);
var state_39468__$1 = state_39468;
var statearr_39559_39641 = state_39468__$1;
(statearr_39559_39641[(2)] = inst_39402);

(statearr_39559_39641[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (8))){
var inst_39332 = (state_39468[(23)]);
var inst_39324 = (state_39468[(9)]);
var inst_39312 = (state_39468[(17)]);
var inst_39324__$1 = (state_39468[(2)]);
var inst_39325 = cljs.core.PersistentVector.EMPTY;
var inst_39326 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_39324__$1);
var inst_39327 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39325,inst_39326);
var inst_39328 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc,inst_39327);
var inst_39329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39330 = [inst_39324__$1,inst_39312];
var inst_39331 = (new cljs.core.PersistentVector(null,2,(5),inst_39329,inst_39330,null));
var inst_39332__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recursion_map,inst_39331);
var state_39468__$1 = (function (){var statearr_39560 = state_39468;
(statearr_39560[(23)] = inst_39332__$1);

(statearr_39560[(9)] = inst_39324__$1);

(statearr_39560[(15)] = inst_39328);

return statearr_39560;
})();
if(cljs.core.truth_(inst_39332__$1)){
var statearr_39561_39642 = state_39468__$1;
(statearr_39561_39642[(1)] = (12));

} else {
var statearr_39562_39643 = state_39468__$1;
(statearr_39562_39643[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39469 === (49))){
var inst_39416 = (state_39468[(20)]);
var inst_39324 = (state_39468[(9)]);
var inst_39423 = cljs.core.PersistentVector.EMPTY;
var inst_39424 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((0),inst_39324);
var inst_39425 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39423,inst_39424);
var inst_39426 = cljs.core.assoc_in(acc,inst_39425,inst_39416);
var state_39468__$1 = state_39468;
var statearr_39563_39644 = state_39468__$1;
(statearr_39563_39644[(2)] = inst_39426);

(statearr_39563_39644[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____0 = (function (){
var statearr_39564 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39564[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__);

(statearr_39564[(1)] = (1));

return statearr_39564;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____1 = (function (state_39468){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_39468);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e39565){var ex__16294__auto__ = e39565;
var statearr_39566_39645 = state_39468;
(statearr_39566_39645[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_39468[(4)]))){
var statearr_39567_39646 = state_39468;
(statearr_39567_39646[(1)] = cljs.core.first((state_39468[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__39647 = state_39468;
state_39468 = G__39647;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__ = function(state_39468){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____1.call(this,state_39468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_39568 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_39568[(6)] = c__16328__auto__);

return statearr_39568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_39838){
var state_val_39839 = (state_39838[(1)]);
if((state_val_39839 === (7))){
var state_39838__$1 = state_39838;
var statearr_39840_39932 = state_39838__$1;
(statearr_39840_39932[(2)] = null);

(statearr_39840_39932[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (20))){
var inst_39686 = cljs.core.PersistentHashMap.EMPTY;
var state_39838__$1 = state_39838;
var statearr_39841_39933 = state_39838__$1;
(statearr_39841_39933[(2)] = inst_39686);

(statearr_39841_39933[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (58))){
var inst_39796 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39842_39934 = state_39838__$1;
(statearr_39842_39934[(2)] = inst_39796);

(statearr_39842_39934[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (27))){
var inst_39704 = (state_39838[(7)]);
var inst_39668 = (state_39838[(8)]);
var inst_39688 = (state_39838[(9)]);
var inst_39674 = (state_39838[(10)]);
var inst_39817 = (state_39838[(2)]);
var inst_39818 = (function (){var top_level_subject = inst_39668;
var select_spec = inst_39674;
var base_acc = inst_39688;
var acc_PLUS_refs = inst_39704;
var result = inst_39817;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_39819 = cljs.core.PersistentVector.EMPTY;
var inst_39820 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39674);
var inst_39821 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_39820);
var inst_39822 = cljs.core.vals(inst_39821);
var inst_39823 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39674);
var inst_39824 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_39823);
var inst_39825 = cljs.core.vals(inst_39824);
var inst_39826 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39822,inst_39825);
var inst_39827 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39818,inst_39819,inst_39826);
var inst_39829 = (function (){var top_level_subject = inst_39668;
var select_spec = inst_39674;
var base_acc = inst_39688;
var acc_PLUS_refs = inst_39704;
var result = inst_39817;
var sort_preds = inst_39827;
return (function (acc,p__39828){
var vec__39843 = p__39828;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39843,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39843,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39843,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39843,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_39830 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39829,inst_39817,inst_39827);
var state_39838__$1 = state_39838;
var statearr_39846_39935 = state_39838__$1;
(statearr_39846_39935[(2)] = inst_39830);

(statearr_39846_39935[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (1))){
var state_39838__$1 = state_39838;
var statearr_39847_39936 = state_39838__$1;
(statearr_39847_39936[(2)] = null);

(statearr_39847_39936[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (24))){
var inst_39704 = (state_39838[(7)]);
var inst_39704__$1 = (state_39838[(2)]);
var inst_39705 = flakes;
var inst_39706 = cljs.core.PersistentHashMap.EMPTY;
var inst_39707 = cljs.core.PersistentHashMap.EMPTY;
var inst_39708 = inst_39705;
var inst_39709 = inst_39704__$1;
var inst_39710 = inst_39706;
var inst_39711 = inst_39707;
var state_39838__$1 = (function (){var statearr_39848 = state_39838;
(statearr_39848[(7)] = inst_39704__$1);

(statearr_39848[(11)] = inst_39708);

(statearr_39848[(12)] = inst_39711);

(statearr_39848[(13)] = inst_39709);

(statearr_39848[(14)] = inst_39710);

return statearr_39848;
})();
var statearr_39849_39937 = state_39838__$1;
(statearr_39849_39937[(2)] = null);

(statearr_39849_39937[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (55))){
var inst_39798 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39850_39938 = state_39838__$1;
(statearr_39850_39938[(2)] = inst_39798);

(statearr_39850_39938[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (39))){
var inst_39724 = (state_39838[(15)]);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39724)){
var statearr_39851_39939 = state_39838__$1;
(statearr_39851_39939[(1)] = (42));

} else {
var statearr_39852_39940 = state_39838__$1;
(statearr_39852_39940[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (46))){
var inst_39725 = (state_39838[(16)]);
var inst_39709 = (state_39838[(13)]);
var inst_39674 = (state_39838[(10)]);
var inst_39719 = (state_39838[(17)]);
var inst_39762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39763 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_39709,inst_39674,inst_39719,inst_39725,false);
var state_39838__$1 = (function (){var statearr_39853 = state_39838;
(statearr_39853[(18)] = inst_39762);

return statearr_39853;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39838__$1,(49),inst_39763);
} else {
if((state_val_39839 === (4))){
var inst_39648 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39854_39941 = state_39838__$1;
(statearr_39854_39941[(2)] = inst_39648);

(statearr_39854_39941[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (54))){
var state_39838__$1 = state_39838;
var statearr_39855_39942 = state_39838__$1;
(statearr_39855_39942[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (15))){
var inst_39675 = (state_39838[(19)]);
var inst_39674 = (state_39838[(10)]);
var inst_39674__$1 = (state_39838[(2)]);
var inst_39675__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39674__$1);
var state_39838__$1 = (function (){var statearr_39857 = state_39838;
(statearr_39857[(19)] = inst_39675__$1);

(statearr_39857[(10)] = inst_39674__$1);

return statearr_39857;
})();
if(cljs.core.truth_(inst_39675__$1)){
var statearr_39858_39943 = state_39838__$1;
(statearr_39858_39943[(1)] = (16));

} else {
var statearr_39859_39944 = state_39838__$1;
(statearr_39859_39944[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (48))){
var inst_39800 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39860_39945 = state_39838__$1;
(statearr_39860_39945[(2)] = inst_39800);

(statearr_39860_39945[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (50))){
var inst_39674 = (state_39838[(10)]);
var inst_39775 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39674);
var state_39838__$1 = state_39838;
var statearr_39861_39946 = state_39838__$1;
(statearr_39861_39946[(2)] = inst_39775);

(statearr_39861_39946[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (21))){
var inst_39674 = (state_39838[(10)]);
var inst_39688 = (state_39838[(2)]);
var inst_39689 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39690 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_39691 = (new cljs.core.PersistentVector(null,2,(5),inst_39689,inst_39690,null));
var inst_39692 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39674,inst_39691);
var state_39838__$1 = (function (){var statearr_39862 = state_39838;
(statearr_39862[(9)] = inst_39688);

return statearr_39862;
})();
if(cljs.core.truth_(inst_39692)){
var statearr_39863_39947 = state_39838__$1;
(statearr_39863_39947[(1)] = (22));

} else {
var statearr_39864_39948 = state_39838__$1;
(statearr_39864_39948[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (31))){
var inst_39724 = (state_39838[(15)]);
var inst_39728 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_39724);
var state_39838__$1 = state_39838;
var statearr_39865_39949 = state_39838__$1;
(statearr_39865_39949[(2)] = inst_39728);

(statearr_39865_39949[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (32))){
var inst_39726 = (state_39838[(20)]);
var state_39838__$1 = state_39838;
var statearr_39866_39950 = state_39838__$1;
(statearr_39866_39950[(2)] = inst_39726);

(statearr_39866_39950[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (40))){
var inst_39804 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39867_39951 = state_39838__$1;
(statearr_39867_39951[(2)] = inst_39804);

(statearr_39867_39951[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (56))){
var inst_39708 = (state_39838[(11)]);
var inst_39711 = (state_39838[(12)]);
var inst_39709 = (state_39838[(13)]);
var inst_39710 = (state_39838[(14)]);
var inst_39790 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39791 = cljs.core.rest(inst_39708);
var inst_39792 = [inst_39709,inst_39791,inst_39710,inst_39711];
var inst_39793 = (new cljs.core.PersistentVector(null,4,(5),inst_39790,inst_39792,null));
var state_39838__$1 = state_39838;
var statearr_39868_39952 = state_39838__$1;
(statearr_39868_39952[(2)] = inst_39793);

(statearr_39868_39952[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (33))){
var inst_39731 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39731)){
var statearr_39869_39953 = state_39838__$1;
(statearr_39869_39953[(1)] = (34));

} else {
var statearr_39870_39954 = state_39838__$1;
(statearr_39870_39954[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (13))){
var inst_39668 = (state_39838[(8)]);
var inst_39671 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_39668);
var state_39838__$1 = state_39838;
var statearr_39871_39955 = state_39838__$1;
(statearr_39871_39955[(2)] = inst_39671);

(statearr_39871_39955[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (22))){
var inst_39674 = (state_39838[(10)]);
var inst_39694 = cljs.core.first(flakes);
var inst_39695 = fluree.db.query.fql.s(inst_39694);
var inst_39696 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_39674);
var inst_39697 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_39695,inst_39696);
var state_39838__$1 = state_39838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39838__$1,(25),inst_39697);
} else {
if((state_val_39839 === (36))){
var inst_39719 = (state_39838[(17)]);
var inst_39806 = (state_39838[(2)]);
var inst_39807 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39806,(0),null);
var inst_39808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39806,(1),null);
var inst_39809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39806,(2),null);
var inst_39810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39806,(3),null);
var inst_39811 = inst_39719.s;
var inst_39812 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39807,cljs.core.cst$kw$_id,inst_39811);
var inst_39708 = inst_39808;
var inst_39709 = inst_39812;
var inst_39710 = inst_39809;
var inst_39711 = inst_39810;
var state_39838__$1 = (function (){var statearr_39872 = state_39838;
(statearr_39872[(11)] = inst_39708);

(statearr_39872[(12)] = inst_39711);

(statearr_39872[(13)] = inst_39709);

(statearr_39872[(14)] = inst_39710);

return statearr_39872;
})();
var statearr_39873_39956 = state_39838__$1;
(statearr_39873_39956[(2)] = null);

(statearr_39873_39956[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (41))){
var inst_39742 = (state_39838[(2)]);
var inst_39743 = fluree.db.util.async.throw_err(inst_39742);
var state_39838__$1 = state_39838;
var statearr_39874_39957 = state_39838__$1;
(statearr_39874_39957[(2)] = inst_39743);

(statearr_39874_39957[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (43))){
var inst_39674 = (state_39838[(10)]);
var inst_39760 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39674);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39760)){
var statearr_39875_39958 = state_39838__$1;
(statearr_39875_39958[(1)] = (46));

} else {
var statearr_39876_39959 = state_39838__$1;
(statearr_39876_39959[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (29))){
var inst_39708 = (state_39838[(11)]);
var inst_39674 = (state_39838[(10)]);
var inst_39724 = (state_39838[(15)]);
var inst_39719 = (state_39838[(17)]);
var inst_39726 = (state_39838[(20)]);
var inst_39719__$1 = cljs.core.first(inst_39708);
var inst_39720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39721 = inst_39719__$1.p;
var inst_39722 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_39721];
var inst_39723 = (new cljs.core.PersistentVector(null,3,(5),inst_39720,inst_39722,null));
var inst_39724__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39674,inst_39723);
var inst_39725 = fluree.db.query.fql.component_follow_QMARK_(inst_39724__$1,inst_39674);
var inst_39726__$1 = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39724__$1);
var state_39838__$1 = (function (){var statearr_39877 = state_39838;
(statearr_39877[(16)] = inst_39725);

(statearr_39877[(15)] = inst_39724__$1);

(statearr_39877[(17)] = inst_39719__$1);

(statearr_39877[(20)] = inst_39726__$1);

return statearr_39877;
})();
if(cljs.core.truth_(inst_39726__$1)){
var statearr_39878_39960 = state_39838__$1;
(statearr_39878_39960[(1)] = (31));

} else {
var statearr_39879_39961 = state_39838__$1;
(statearr_39879_39961[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (44))){
var inst_39802 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39880_39962 = state_39838__$1;
(statearr_39880_39962[(2)] = inst_39802);

(statearr_39880_39962[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (6))){
var state_39838__$1 = state_39838;
var statearr_39881_39963 = state_39838__$1;
(statearr_39881_39963[(2)] = null);

(statearr_39881_39963[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (28))){
var inst_39709 = (state_39838[(13)]);
var state_39838__$1 = state_39838;
var statearr_39882_39964 = state_39838__$1;
(statearr_39882_39964[(2)] = inst_39709);

(statearr_39882_39964[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (51))){
var state_39838__$1 = state_39838;
var statearr_39883_39965 = state_39838__$1;
(statearr_39883_39965[(2)] = false);

(statearr_39883_39965[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (25))){
var inst_39688 = (state_39838[(9)]);
var inst_39699 = (state_39838[(2)]);
var inst_39700 = fluree.db.util.async.throw_err(inst_39699);
var inst_39701 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39688,inst_39700], 0));
var state_39838__$1 = state_39838;
var statearr_39884_39966 = state_39838__$1;
(statearr_39884_39966[(2)] = inst_39701);

(statearr_39884_39966[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (34))){
var inst_39708 = (state_39838[(11)]);
var inst_39709 = (state_39838[(13)]);
var inst_39710 = (state_39838[(14)]);
var inst_39674 = (state_39838[(10)]);
var inst_39724 = (state_39838[(15)]);
var inst_39719 = (state_39838[(17)]);
var inst_39733 = fluree.db.query.fql.flake__GT_recur_multi(db,inst_39719,inst_39724,inst_39710,inst_39708,inst_39709,fuel,max_fuel,inst_39674,cache,fluree.db.query.fql.component_follow_QMARK_);
var state_39838__$1 = state_39838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39838__$1,(37),inst_39733);
} else {
if((state_val_39839 === (17))){
var inst_39674 = (state_39838[(10)]);
var inst_39678 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39674);
var state_39838__$1 = state_39838;
var statearr_39886_39967 = state_39838__$1;
(statearr_39886_39967[(2)] = inst_39678);

(statearr_39886_39967[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (3))){
var inst_39836 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39838__$1,inst_39836);
} else {
if((state_val_39839 === (12))){
var _ = (function (){var statearr_39887 = state_39838;
(statearr_39887[(4)] = cljs.core.rest((state_39838[(4)])));

return statearr_39887;
})();
var state_39838__$1 = state_39838;
var ex39885 = (state_39838__$1[(2)]);
var statearr_39888_39968 = state_39838__$1;
(statearr_39888_39968[(5)] = ex39885);


var statearr_39889_39969 = state_39838__$1;
(statearr_39889_39969[(1)] = (11));

(statearr_39889_39969[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (2))){
var _ = (function (){var statearr_39890 = state_39838;
(statearr_39890[(4)] = cljs.core.cons((5),(state_39838[(4)])));

return statearr_39890;
})();
var inst_39654 = cljs.core.not_empty(flakes);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39654)){
var statearr_39891_39970 = state_39838__$1;
(statearr_39891_39970[(1)] = (6));

} else {
var statearr_39892_39971 = state_39838__$1;
(statearr_39892_39971[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (23))){
var inst_39688 = (state_39838[(9)]);
var state_39838__$1 = state_39838;
var statearr_39893_39972 = state_39838__$1;
(statearr_39893_39972[(2)] = inst_39688);

(statearr_39893_39972[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (47))){
var inst_39674 = (state_39838[(10)]);
var inst_39772 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39674);
var inst_39773 = cljs.core.empty_QMARK_(inst_39772);
var state_39838__$1 = state_39838;
if(inst_39773){
var statearr_39894_39973 = state_39838__$1;
(statearr_39894_39973[(1)] = (50));

} else {
var statearr_39895_39974 = state_39838__$1;
(statearr_39895_39974[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (35))){
var inst_39724 = (state_39838[(15)]);
var inst_39738 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_39724);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39738)){
var statearr_39896_39975 = state_39838__$1;
(statearr_39896_39975[(1)] = (38));

} else {
var statearr_39897_39976 = state_39838__$1;
(statearr_39897_39976[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (19))){
var inst_39668 = (state_39838[(8)]);
var inst_39682 = ["_id"];
var inst_39683 = [inst_39668];
var inst_39684 = cljs.core.PersistentHashMap.fromArrays(inst_39682,inst_39683);
var state_39838__$1 = state_39838;
var statearr_39898_39977 = state_39838__$1;
(statearr_39898_39977[(2)] = inst_39684);

(statearr_39898_39977[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (57))){
var state_39838__$1 = state_39838;
var statearr_39899_39978 = state_39838__$1;
(statearr_39899_39978[(2)] = null);

(statearr_39899_39978[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (11))){
var inst_39656 = (state_39838[(2)]);
var inst_39657 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39656], 0));
var inst_39658 = (function(){throw inst_39656})();
var state_39838__$1 = (function (){var statearr_39901 = state_39838;
(statearr_39901[(21)] = inst_39657);

return statearr_39901;
})();
var statearr_39902_39979 = state_39838__$1;
(statearr_39902_39979[(2)] = inst_39658);

(statearr_39902_39979[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (9))){
var _ = (function (){var statearr_39903 = state_39838;
(statearr_39903[(4)] = cljs.core.cons((12),(state_39838[(4)])));

return statearr_39903;
})();
var inst_39664 = cljs.core.first(flakes);
var inst_39665 = fluree.db.query.fql.s(inst_39664);
var ___$1 = (function (){var statearr_39904 = state_39838;
(statearr_39904[(4)] = cljs.core.rest((state_39838[(4)])));

return statearr_39904;
})();
var state_39838__$1 = state_39838;
var statearr_39905_39980 = state_39838__$1;
(statearr_39905_39980[(2)] = inst_39665);

(statearr_39905_39980[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (5))){
var _ = (function (){var statearr_39906 = state_39838;
(statearr_39906[(4)] = cljs.core.rest((state_39838[(4)])));

return statearr_39906;
})();
var state_39838__$1 = state_39838;
var ex39900 = (state_39838__$1[(2)]);
var statearr_39907_39981 = state_39838__$1;
(statearr_39907_39981[(5)] = ex39900);


if((ex39900 instanceof Error)){
var statearr_39908_39982 = state_39838__$1;
(statearr_39908_39982[(1)] = (4));

(statearr_39908_39982[(5)] = null);

} else {
throw ex39900;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (14))){
var state_39838__$1 = state_39838;
var statearr_39909_39983 = state_39838__$1;
(statearr_39909_39983[(2)] = base_select_spec);

(statearr_39909_39983[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (45))){
var inst_39708 = (state_39838[(11)]);
var inst_39710 = (state_39838[(14)]);
var inst_39751 = (state_39838[(2)]);
var inst_39752 = fluree.db.util.async.throw_err(inst_39751);
var inst_39753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39752,(0),null);
var inst_39754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39752,(1),null);
var inst_39755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39756 = cljs.core.rest(inst_39708);
var inst_39757 = [inst_39753,inst_39756,inst_39710,inst_39754];
var inst_39758 = (new cljs.core.PersistentVector(null,4,(5),inst_39755,inst_39757,null));
var state_39838__$1 = state_39838;
var statearr_39910_39984 = state_39838__$1;
(statearr_39910_39984[(2)] = inst_39758);

(statearr_39910_39984[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (53))){
var inst_39708 = (state_39838[(11)]);
var inst_39711 = (state_39838[(12)]);
var inst_39710 = (state_39838[(14)]);
var inst_39719 = (state_39838[(17)]);
var inst_39780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39781 = ["_id"];
var inst_39782 = inst_39719.s;
var inst_39783 = [inst_39782];
var inst_39784 = cljs.core.PersistentHashMap.fromArrays(inst_39781,inst_39783);
var inst_39785 = cljs.core.rest(inst_39708);
var inst_39786 = [inst_39784,inst_39785,inst_39710,inst_39711];
var inst_39787 = (new cljs.core.PersistentVector(null,4,(5),inst_39780,inst_39786,null));
var state_39838__$1 = state_39838;
var statearr_39911_39985 = state_39838__$1;
(statearr_39911_39985[(2)] = inst_39787);

(statearr_39911_39985[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (26))){
var inst_39708 = (state_39838[(11)]);
var inst_39713 = cljs.core.empty_QMARK_(inst_39708);
var state_39838__$1 = state_39838;
if(inst_39713){
var statearr_39912_39986 = state_39838__$1;
(statearr_39912_39986[(1)] = (28));

} else {
var statearr_39913_39987 = state_39838__$1;
(statearr_39913_39987[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (16))){
var inst_39675 = (state_39838[(19)]);
var state_39838__$1 = state_39838;
var statearr_39914_39988 = state_39838__$1;
(statearr_39914_39988[(2)] = inst_39675);

(statearr_39914_39988[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (38))){
var inst_39708 = (state_39838[(11)]);
var inst_39709 = (state_39838[(13)]);
var inst_39710 = (state_39838[(14)]);
var inst_39674 = (state_39838[(10)]);
var inst_39724 = (state_39838[(15)]);
var inst_39719 = (state_39838[(17)]);
var inst_39740 = fluree.db.query.fql.flake__GT_recur(db,inst_39719,inst_39724,inst_39710,inst_39708,inst_39709,fuel,max_fuel,inst_39674,cache);
var state_39838__$1 = state_39838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39838__$1,(41),inst_39740);
} else {
if((state_val_39839 === (30))){
var inst_39815 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
var statearr_39915_39989 = state_39838__$1;
(statearr_39915_39989[(2)] = inst_39815);

(statearr_39915_39989[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (10))){
var inst_39668 = (state_39838[(2)]);
var inst_39669 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_39838__$1 = (function (){var statearr_39916 = state_39838;
(statearr_39916[(8)] = inst_39668);

return statearr_39916;
})();
if(cljs.core.truth_(inst_39669)){
var statearr_39917_39990 = state_39838__$1;
(statearr_39917_39990[(1)] = (13));

} else {
var statearr_39918_39991 = state_39838__$1;
(statearr_39918_39991[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (18))){
var inst_39680 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39680)){
var statearr_39919_39992 = state_39838__$1;
(statearr_39919_39992[(1)] = (19));

} else {
var statearr_39920_39993 = state_39838__$1;
(statearr_39920_39993[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (52))){
var inst_39778 = (state_39838[(2)]);
var state_39838__$1 = state_39838;
if(cljs.core.truth_(inst_39778)){
var statearr_39921_39994 = state_39838__$1;
(statearr_39921_39994[(1)] = (53));

} else {
var statearr_39922_39995 = state_39838__$1;
(statearr_39922_39995[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (42))){
var inst_39711 = (state_39838[(12)]);
var inst_39725 = (state_39838[(16)]);
var inst_39709 = (state_39838[(13)]);
var inst_39724 = (state_39838[(15)]);
var inst_39719 = (state_39838[(17)]);
var inst_39749 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_39709,inst_39724,inst_39719,inst_39725,false,inst_39711);
var state_39838__$1 = state_39838;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39838__$1,(45),inst_39749);
} else {
if((state_val_39839 === (37))){
var inst_39735 = (state_39838[(2)]);
var inst_39736 = fluree.db.util.async.throw_err(inst_39735);
var state_39838__$1 = state_39838;
var statearr_39923_39996 = state_39838__$1;
(statearr_39923_39996[(2)] = inst_39736);

(statearr_39923_39996[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (8))){
var inst_39833 = (state_39838[(2)]);
var _ = (function (){var statearr_39924 = state_39838;
(statearr_39924[(4)] = cljs.core.rest((state_39838[(4)])));

return statearr_39924;
})();
var state_39838__$1 = state_39838;
var statearr_39925_39997 = state_39838__$1;
(statearr_39925_39997[(2)] = inst_39833);

(statearr_39925_39997[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39839 === (49))){
var inst_39708 = (state_39838[(11)]);
var inst_39711 = (state_39838[(12)]);
var inst_39710 = (state_39838[(14)]);
var inst_39762 = (state_39838[(18)]);
var inst_39765 = (state_39838[(2)]);
var inst_39766 = fluree.db.util.async.throw_err(inst_39765);
var inst_39767 = cljs.core.first(inst_39766);
var inst_39768 = cljs.core.rest(inst_39708);
var inst_39769 = [inst_39767,inst_39768,inst_39710,inst_39711];
var inst_39770 = (new cljs.core.PersistentVector(null,4,(5),inst_39762,inst_39769,null));
var state_39838__$1 = state_39838;
var statearr_39926_39998 = state_39838__$1;
(statearr_39926_39998[(2)] = inst_39770);

(statearr_39926_39998[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____0 = (function (){
var statearr_39927 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39927[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__);

(statearr_39927[(1)] = (1));

return statearr_39927;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____1 = (function (state_39838){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_39838);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e39928){var ex__16294__auto__ = e39928;
var statearr_39929_39999 = state_39838;
(statearr_39929_39999[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_39838[(4)]))){
var statearr_39930_40000 = state_39838;
(statearr_39930_40000[(1)] = cljs.core.first((state_39838[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40001 = state_39838;
state_39838 = G__40001;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__ = function(state_39838){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____1.call(this,state_39838);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_39931 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_39931[(6)] = c__16328__auto__);

return statearr_39931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__40004 = arguments.length;
switch (G__40004) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40046){
var state_val_40047 = (state_40046[(1)]);
if((state_val_40047 === (7))){
var inst_40012 = (state_40046[(7)]);
var state_40046__$1 = state_40046;
var statearr_40048_40078 = state_40046__$1;
(statearr_40048_40078[(2)] = inst_40012);

(statearr_40048_40078[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (1))){
var state_40046__$1 = state_40046;
var statearr_40049_40079 = state_40046__$1;
(statearr_40049_40079[(2)] = null);

(statearr_40049_40079[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (4))){
var inst_40005 = (state_40046[(2)]);
var state_40046__$1 = state_40046;
var statearr_40050_40080 = state_40046__$1;
(statearr_40050_40080[(2)] = inst_40005);

(statearr_40050_40080[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (15))){
var inst_40040 = (state_40046[(2)]);
var inst_40041 = fluree.db.util.async.throw_err(inst_40040);
var _ = (function (){var statearr_40051 = state_40046;
(statearr_40051[(4)] = cljs.core.rest((state_40046[(4)])));

return statearr_40051;
})();
var state_40046__$1 = state_40046;
var statearr_40052_40081 = state_40046__$1;
(statearr_40052_40081[(2)] = inst_40041);

(statearr_40052_40081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (13))){
var inst_40024 = (state_40046[(8)]);
var state_40046__$1 = state_40046;
var statearr_40053_40082 = state_40046__$1;
(statearr_40053_40082[(2)] = inst_40024);

(statearr_40053_40082[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (6))){
var inst_40012 = (state_40046[(7)]);
var inst_40014 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_40015 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40012,inst_40014);
var state_40046__$1 = state_40046;
var statearr_40054_40083 = state_40046__$1;
(statearr_40054_40083[(2)] = inst_40015);

(statearr_40054_40083[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (3))){
var inst_40044 = (state_40046[(2)]);
var state_40046__$1 = state_40046;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40046__$1,inst_40044);
} else {
if((state_val_40047 === (12))){
var inst_40024 = (state_40046[(8)]);
var inst_40026 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_40027 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40024,inst_40026);
var state_40046__$1 = state_40046;
var statearr_40055_40084 = state_40046__$1;
(statearr_40055_40084[(2)] = inst_40027);

(statearr_40055_40084[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (2))){
var _ = (function (){var statearr_40056 = state_40046;
(statearr_40056[(4)] = cljs.core.cons((5),(state_40046[(4)])));

return statearr_40056;
})();
var inst_40012 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_40046__$1 = (function (){var statearr_40057 = state_40046;
(statearr_40057[(7)] = inst_40012);

return statearr_40057;
})();
if(cljs.core.truth_(fuel)){
var statearr_40058_40085 = state_40046__$1;
(statearr_40058_40085[(1)] = (6));

} else {
var statearr_40059_40086 = state_40046__$1;
(statearr_40059_40086[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (11))){
var inst_40024 = (state_40046[(2)]);
var state_40046__$1 = (function (){var statearr_40061 = state_40046;
(statearr_40061[(8)] = inst_40024);

return statearr_40061;
})();
if(cljs.core.truth_(limit)){
var statearr_40062_40087 = state_40046__$1;
(statearr_40062_40087[(1)] = (12));

} else {
var statearr_40063_40088 = state_40046__$1;
(statearr_40063_40088[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (9))){
var inst_40018 = (state_40046[(9)]);
var inst_40020 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_40021 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40018,inst_40020);
var state_40046__$1 = state_40046;
var statearr_40064_40089 = state_40046__$1;
(statearr_40064_40089[(2)] = inst_40021);

(statearr_40064_40089[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (5))){
var _ = (function (){var statearr_40065 = state_40046;
(statearr_40065[(4)] = cljs.core.rest((state_40046[(4)])));

return statearr_40065;
})();
var state_40046__$1 = state_40046;
var ex40060 = (state_40046__$1[(2)]);
var statearr_40066_40090 = state_40046__$1;
(statearr_40066_40090[(5)] = ex40060);


if((ex40060 instanceof Error)){
var statearr_40067_40091 = state_40046__$1;
(statearr_40067_40091[(1)] = (4));

(statearr_40067_40091[(5)] = null);

} else {
throw ex40060;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (14))){
var inst_40030 = (state_40046[(2)]);
var inst_40031 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_40032 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_40031);
var inst_40033 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40030,inst_40032);
var inst_40034 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_40033,flakes);
var inst_40035 = cljs.core.PersistentVector.EMPTY;
var inst_40036 = (function (){var xf = inst_40033;
var flakes_by_sub = inst_40034;
return (function (p1__40002_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__40002_SHARP_);
});
})();
var inst_40037 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40036,inst_40034);
var inst_40038 = fluree.db.util.async.merge_into_QMARK_(inst_40035,inst_40037);
var state_40046__$1 = state_40046;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40046__$1,(15),inst_40038);
} else {
if((state_val_40047 === (10))){
var inst_40018 = (state_40046[(9)]);
var state_40046__$1 = state_40046;
var statearr_40068_40092 = state_40046__$1;
(statearr_40068_40092[(2)] = inst_40018);

(statearr_40068_40092[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40047 === (8))){
var inst_40018 = (state_40046[(2)]);
var state_40046__$1 = (function (){var statearr_40069 = state_40046;
(statearr_40069[(9)] = inst_40018);

return statearr_40069;
})();
if(cljs.core.truth_(offset)){
var statearr_40070_40093 = state_40046__$1;
(statearr_40070_40093[(1)] = (9));

} else {
var statearr_40071_40094 = state_40046__$1;
(statearr_40071_40094[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16291__auto__ = null;
var fluree$db$query$fql$state_machine__16291__auto____0 = (function (){
var statearr_40072 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40072[(0)] = fluree$db$query$fql$state_machine__16291__auto__);

(statearr_40072[(1)] = (1));

return statearr_40072;
});
var fluree$db$query$fql$state_machine__16291__auto____1 = (function (state_40046){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40046);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40073){var ex__16294__auto__ = e40073;
var statearr_40074_40095 = state_40046;
(statearr_40074_40095[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40046[(4)]))){
var statearr_40075_40096 = state_40046;
(statearr_40075_40096[(1)] = cljs.core.first((state_40046[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40097 = state_40046;
state_40046 = G__40097;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16291__auto__ = function(state_40046){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16291__auto____1.call(this,state_40046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16291__auto____0;
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16291__auto____1;
return fluree$db$query$fql$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40076 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40076[(6)] = c__16328__auto__);

return statearr_40076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__40099 = arguments.length;
switch (G__40099) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40183){
var state_val_40184 = (state_40183[(1)]);
if((state_val_40184 === (7))){
var inst_40178 = (state_40183[(2)]);
var _ = (function (){var statearr_40186 = state_40183;
(statearr_40186[(4)] = cljs.core.rest((state_40183[(4)])));

return statearr_40186;
})();
var state_40183__$1 = state_40183;
var statearr_40187_40234 = state_40183__$1;
(statearr_40187_40234[(2)] = inst_40178);

(statearr_40187_40234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (20))){
var inst_40127 = (state_40183[(7)]);
var inst_40119 = (state_40183[(8)]);
var inst_40120 = (state_40183[(9)]);
var inst_40148 = (inst_40119 + (1));
var tmp40185 = inst_40120;
var inst_40118 = inst_40127;
var inst_40119__$1 = inst_40148;
var inst_40120__$1 = tmp40185;
var state_40183__$1 = (function (){var statearr_40188 = state_40183;
(statearr_40188[(8)] = inst_40119__$1);

(statearr_40188[(9)] = inst_40120__$1);

(statearr_40188[(10)] = inst_40118);

return statearr_40188;
})();
var statearr_40189_40235 = state_40183__$1;
(statearr_40189_40235[(2)] = null);

(statearr_40189_40235[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (27))){
var inst_40153 = (state_40183[(11)]);
var inst_40162 = (state_40183[(2)]);
var inst_40163 = fluree.db.util.async.throw_err(inst_40162);
var inst_40164 = (inst_40153.cljs$core$IFn$_invoke$arity$1 ? inst_40153.cljs$core$IFn$_invoke$arity$1(inst_40163) : inst_40153.call(null,inst_40163));
var state_40183__$1 = state_40183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40183__$1,(26),inst_40164);
} else {
if((state_val_40184 === (1))){
var state_40183__$1 = state_40183;
var statearr_40190_40236 = state_40183__$1;
(statearr_40190_40236[(2)] = null);

(statearr_40190_40236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (24))){
var state_40183__$1 = state_40183;
var statearr_40191_40237 = state_40183__$1;
(statearr_40191_40237[(2)] = null);

(statearr_40191_40237[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (4))){
var inst_40100 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
var statearr_40192_40238 = state_40183__$1;
(statearr_40192_40238[(2)] = inst_40100);

(statearr_40192_40238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (15))){
var inst_40141 = (state_40183[(12)]);
var inst_40141__$1 = offset;
var state_40183__$1 = (function (){var statearr_40193 = state_40183;
(statearr_40193[(12)] = inst_40141__$1);

return statearr_40193;
})();
if(cljs.core.truth_(inst_40141__$1)){
var statearr_40194_40239 = state_40183__$1;
(statearr_40194_40239[(1)] = (17));

} else {
var statearr_40195_40240 = state_40183__$1;
(statearr_40195_40240[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (21))){
var state_40183__$1 = state_40183;
var statearr_40196_40241 = state_40183__$1;
(statearr_40196_40241[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (13))){
var inst_40136 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
var statearr_40198_40242 = state_40183__$1;
(statearr_40198_40242[(2)] = inst_40136);

(statearr_40198_40242[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (22))){
var inst_40174 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
var statearr_40199_40243 = state_40183__$1;
(statearr_40199_40243[(2)] = inst_40174);

(statearr_40199_40243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (6))){
var inst_40128 = (state_40183[(13)]);
var inst_40118 = (state_40183[(10)]);
var inst_40126 = (state_40183[(14)]);
var inst_40125 = cljs.core.seq(inst_40118);
var inst_40126__$1 = cljs.core.first(inst_40125);
var inst_40127 = cljs.core.next(inst_40125);
var inst_40128__$1 = (inst_40126__$1 == null);
var state_40183__$1 = (function (){var statearr_40200 = state_40183;
(statearr_40200[(7)] = inst_40127);

(statearr_40200[(13)] = inst_40128__$1);

(statearr_40200[(14)] = inst_40126__$1);

return statearr_40200;
})();
if(cljs.core.truth_(inst_40128__$1)){
var statearr_40201_40244 = state_40183__$1;
(statearr_40201_40244[(1)] = (8));

} else {
var statearr_40202_40245 = state_40183__$1;
(statearr_40202_40245[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (25))){
var inst_40172 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
var statearr_40203_40246 = state_40183__$1;
(statearr_40203_40246[(2)] = inst_40172);

(statearr_40203_40246[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (17))){
var inst_40119 = (state_40183[(8)]);
var inst_40143 = (inst_40119 < offset);
var state_40183__$1 = state_40183;
var statearr_40204_40247 = state_40183__$1;
(statearr_40204_40247[(2)] = inst_40143);

(statearr_40204_40247[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (3))){
var inst_40181 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40183__$1,inst_40181);
} else {
if((state_val_40184 === (12))){
var inst_40131 = (state_40183[(15)]);
var state_40183__$1 = state_40183;
var statearr_40205_40248 = state_40183__$1;
(statearr_40205_40248[(2)] = inst_40131);

(statearr_40205_40248[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (2))){
var inst_40113 = (state_40183[(16)]);
var _ = (function (){var statearr_40206 = state_40183;
(statearr_40206[(4)] = cljs.core.cons((5),(state_40183[(4)])));

return statearr_40206;
})();
var inst_40113__$1 = subjects;
var inst_40114 = cljs.core.seq(inst_40113__$1);
var inst_40115 = cljs.core.first(inst_40114);
var inst_40116 = cljs.core.next(inst_40114);
var inst_40117 = cljs.core.PersistentVector.EMPTY;
var inst_40118 = inst_40113__$1;
var inst_40119 = (0);
var inst_40120 = inst_40117;
var state_40183__$1 = (function (){var statearr_40207 = state_40183;
(statearr_40207[(16)] = inst_40113__$1);

(statearr_40207[(8)] = inst_40119);

(statearr_40207[(17)] = inst_40115);

(statearr_40207[(9)] = inst_40120);

(statearr_40207[(18)] = inst_40116);

(statearr_40207[(10)] = inst_40118);

return statearr_40207;
})();
var statearr_40208_40249 = state_40183__$1;
(statearr_40208_40249[(2)] = null);

(statearr_40208_40249[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (23))){
var inst_40113 = (state_40183[(16)]);
var inst_40127 = (state_40183[(7)]);
var inst_40119 = (state_40183[(8)]);
var inst_40115 = (state_40183[(17)]);
var inst_40120 = (state_40183[(9)]);
var inst_40116 = (state_40183[(18)]);
var inst_40118 = (state_40183[(10)]);
var inst_40126 = (state_40183[(14)]);
var inst_40152 = (inst_40119 + (1));
var inst_40153 = (function (){var vec__40110 = inst_40113;
var seq__40111 = inst_40116;
var first__40112 = inst_40115;
var r = inst_40127;
var acc = inst_40120;
var n = inst_40119;
var first__40124 = inst_40126;
var vec__40122 = inst_40118;
var s = inst_40126;
var seq__40123 = inst_40127;
var G__40109 = inst_40118;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_40154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40155 = [inst_40126];
var inst_40156 = (new cljs.core.PersistentVector(null,1,(5),inst_40154,inst_40155,null));
var inst_40157 = [cljs.core.cst$kw$limit];
var inst_40158 = [limit];
var inst_40159 = cljs.core.PersistentHashMap.fromArrays(inst_40157,inst_40158);
var inst_40160 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_40156,inst_40159);
var state_40183__$1 = (function (){var statearr_40209 = state_40183;
(statearr_40209[(19)] = inst_40152);

(statearr_40209[(11)] = inst_40153);

return statearr_40209;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40183__$1,(27),inst_40160);
} else {
if((state_val_40184 === (19))){
var inst_40146 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
if(cljs.core.truth_(inst_40146)){
var statearr_40210_40250 = state_40183__$1;
(statearr_40210_40250[(1)] = (20));

} else {
var statearr_40211_40251 = state_40183__$1;
(statearr_40211_40251[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (11))){
var inst_40119 = (state_40183[(8)]);
var inst_40133 = (inst_40119 > limit);
var state_40183__$1 = state_40183;
var statearr_40213_40252 = state_40183__$1;
(statearr_40213_40252[(2)] = inst_40133);

(statearr_40213_40252[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (9))){
var inst_40131 = (state_40183[(15)]);
var inst_40131__$1 = limit;
var state_40183__$1 = (function (){var statearr_40214 = state_40183;
(statearr_40214[(15)] = inst_40131__$1);

return statearr_40214;
})();
if(cljs.core.truth_(inst_40131__$1)){
var statearr_40215_40253 = state_40183__$1;
(statearr_40215_40253[(1)] = (11));

} else {
var statearr_40216_40254 = state_40183__$1;
(statearr_40216_40254[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (5))){
var _ = (function (){var statearr_40217 = state_40183;
(statearr_40217[(4)] = cljs.core.rest((state_40183[(4)])));

return statearr_40217;
})();
var state_40183__$1 = state_40183;
var ex40212 = (state_40183__$1[(2)]);
var statearr_40218_40255 = state_40183__$1;
(statearr_40218_40255[(5)] = ex40212);


if((ex40212 instanceof Error)){
var statearr_40219_40256 = state_40183__$1;
(statearr_40219_40256[(1)] = (4));

(statearr_40219_40256[(5)] = null);

} else {
throw ex40212;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (14))){
var inst_40120 = (state_40183[(9)]);
var state_40183__$1 = state_40183;
var statearr_40220_40257 = state_40183__$1;
(statearr_40220_40257[(2)] = inst_40120);

(statearr_40220_40257[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (26))){
var inst_40152 = (state_40183[(19)]);
var inst_40127 = (state_40183[(7)]);
var inst_40120 = (state_40183[(9)]);
var inst_40166 = (state_40183[(2)]);
var inst_40167 = fluree.db.util.async.throw_err(inst_40166);
var inst_40168 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40120,inst_40167);
var inst_40118 = inst_40127;
var inst_40119 = inst_40152;
var inst_40120__$1 = inst_40168;
var state_40183__$1 = (function (){var statearr_40221 = state_40183;
(statearr_40221[(8)] = inst_40119);

(statearr_40221[(9)] = inst_40120__$1);

(statearr_40221[(10)] = inst_40118);

return statearr_40221;
})();
var statearr_40222_40258 = state_40183__$1;
(statearr_40222_40258[(2)] = null);

(statearr_40222_40258[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (16))){
var inst_40176 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
var statearr_40223_40259 = state_40183__$1;
(statearr_40223_40259[(2)] = inst_40176);

(statearr_40223_40259[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (10))){
var inst_40138 = (state_40183[(2)]);
var state_40183__$1 = state_40183;
if(cljs.core.truth_(inst_40138)){
var statearr_40224_40260 = state_40183__$1;
(statearr_40224_40260[(1)] = (14));

} else {
var statearr_40225_40261 = state_40183__$1;
(statearr_40225_40261[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (18))){
var inst_40141 = (state_40183[(12)]);
var state_40183__$1 = state_40183;
var statearr_40226_40262 = state_40183__$1;
(statearr_40226_40262[(2)] = inst_40141);

(statearr_40226_40262[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40184 === (8))){
var inst_40128 = (state_40183[(13)]);
var state_40183__$1 = state_40183;
var statearr_40227_40263 = state_40183__$1;
(statearr_40227_40263[(2)] = inst_40128);

(statearr_40227_40263[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16291__auto__ = null;
var fluree$db$query$fql$state_machine__16291__auto____0 = (function (){
var statearr_40228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40228[(0)] = fluree$db$query$fql$state_machine__16291__auto__);

(statearr_40228[(1)] = (1));

return statearr_40228;
});
var fluree$db$query$fql$state_machine__16291__auto____1 = (function (state_40183){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40183);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40229){var ex__16294__auto__ = e40229;
var statearr_40230_40264 = state_40183;
(statearr_40230_40264[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40183[(4)]))){
var statearr_40231_40265 = state_40183;
(statearr_40231_40265[(1)] = cljs.core.first((state_40183[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40266 = state_40183;
state_40183 = G__40266;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16291__auto__ = function(state_40183){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16291__auto____1.call(this,state_40183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16291__auto____0;
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16291__auto____1;
return fluree$db$query$fql$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40232 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40232[(6)] = c__16328__auto__);

return statearr_40232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__40268 = arguments.length;
switch (G__40268) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40456){
var state_val_40457 = (state_40456[(1)]);
if((state_val_40457 === (7))){
var state_40456__$1 = state_40456;
var statearr_40458_40529 = state_40456__$1;
(statearr_40458_40529[(2)] = null);

(statearr_40458_40529[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (20))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40339 = (state_40456[(2)]);
var inst_40340 = fluree.db.util.async.throw_err(inst_40339);
var inst_40341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40342 = [inst_40309];
var inst_40343 = (new cljs.core.PersistentVector(null,1,(5),inst_40341,inst_40342,null));
var inst_40344 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40345 = [inst_40309,inst_40311];
var inst_40346 = (new cljs.core.PersistentVector(null,2,(5),inst_40344,inst_40345,null));
var inst_40347 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_40343,cljs.core._LT_,inst_40346);
var state_40456__$1 = (function (){var statearr_40459 = state_40456;
(statearr_40459[(9)] = inst_40340);

return statearr_40459;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(21),inst_40347);
} else {
if((state_val_40457 === (27))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40376 = (inst_40328.cljs$core$IFn$_invoke$arity$2 ? inst_40328.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_40310) : inst_40328.call(null,cljs.core._GT__EQ_,inst_40310));
var state_40456__$1 = state_40456;
if(cljs.core.truth_(inst_40376)){
var statearr_40460_40530 = state_40456__$1;
(statearr_40460_40530[(1)] = (30));

} else {
var statearr_40461_40531 = state_40456__$1;
(statearr_40461_40531[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (1))){
var state_40456__$1 = state_40456;
var statearr_40462_40532 = state_40456__$1;
(statearr_40462_40532[(2)] = null);

(statearr_40462_40532[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (24))){
var inst_40425 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40463_40533 = state_40456__$1;
(statearr_40463_40533[(2)] = inst_40425);

(statearr_40463_40533[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (39))){
var inst_40415 = null;
var state_40456__$1 = state_40456;
var statearr_40464_40534 = state_40456__$1;
(statearr_40464_40534[(2)] = inst_40415);

(statearr_40464_40534[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (46))){
var inst_40302 = (state_40456[(12)]);
var inst_40436 = (state_40456[(13)]);
var inst_40294 = inst_40302;
var inst_40295 = inst_40436;
var state_40456__$1 = (function (){var statearr_40465 = state_40456;
(statearr_40465[(14)] = inst_40294);

(statearr_40465[(15)] = inst_40295);

return statearr_40465;
})();
var statearr_40466_40535 = state_40456__$1;
(statearr_40466_40535[(2)] = null);

(statearr_40466_40535[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (4))){
var inst_40269 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40467_40536 = state_40456__$1;
(statearr_40467_40536[(2)] = inst_40269);

(statearr_40467_40536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (15))){
var state_40456__$1 = state_40456;
var statearr_40468_40537 = state_40456__$1;
(statearr_40468_40537[(2)] = null);

(statearr_40468_40537[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (21))){
var inst_40340 = (state_40456[(9)]);
var inst_40349 = (state_40456[(2)]);
var inst_40350 = fluree.db.util.async.throw_err(inst_40349);
var inst_40351 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_40340,inst_40350);
var state_40456__$1 = state_40456;
var statearr_40469_40538 = state_40456__$1;
(statearr_40469_40538[(2)] = inst_40351);

(statearr_40469_40538[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (31))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40389 = (inst_40328.cljs$core$IFn$_invoke$arity$2 ? inst_40328.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_40310) : inst_40328.call(null,cljs.core._LT_,inst_40310));
var state_40456__$1 = state_40456;
if(cljs.core.truth_(inst_40389)){
var statearr_40470_40539 = state_40456__$1;
(statearr_40470_40539[(1)] = (34));

} else {
var statearr_40471_40540 = state_40456__$1;
(statearr_40471_40540[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (32))){
var inst_40421 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40472_40541 = state_40456__$1;
(statearr_40472_40541[(2)] = inst_40421);

(statearr_40472_40541[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (40))){
var inst_40417 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40473_40542 = state_40456__$1;
(statearr_40473_40542[(2)] = inst_40417);

(statearr_40473_40542[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (33))){
var inst_40386 = (state_40456[(2)]);
var inst_40387 = fluree.db.util.async.throw_err(inst_40386);
var state_40456__$1 = state_40456;
var statearr_40474_40543 = state_40456__$1;
(statearr_40474_40543[(2)] = inst_40387);

(statearr_40474_40543[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (13))){
var inst_40446 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40475_40544 = state_40456__$1;
(statearr_40475_40544[(2)] = inst_40446);

(statearr_40475_40544[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (22))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40356 = [inst_40309,inst_40311];
var inst_40357 = (new cljs.core.PersistentVector(null,2,(5),inst_40355,inst_40356,null));
var inst_40358 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_40357);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(25),inst_40358);
} else {
if((state_val_40457 === (36))){
var inst_40419 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40476_40545 = state_40456__$1;
(statearr_40476_40545[(2)] = inst_40419);

(statearr_40476_40545[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (41))){
var inst_40412 = (state_40456[(2)]);
var inst_40413 = fluree.db.util.async.throw_err(inst_40412);
var state_40456__$1 = state_40456;
var statearr_40477_40546 = state_40456__$1;
(statearr_40477_40546[(2)] = inst_40413);

(statearr_40477_40546[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (43))){
var inst_40428 = (state_40456[(16)]);
var inst_40295 = (state_40456[(15)]);
var inst_40429 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40295,inst_40428);
var state_40456__$1 = state_40456;
var statearr_40478_40547 = state_40456__$1;
(statearr_40478_40547[(2)] = inst_40429);

(statearr_40478_40547[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (29))){
var inst_40373 = (state_40456[(2)]);
var inst_40374 = fluree.db.util.async.throw_err(inst_40373);
var state_40456__$1 = state_40456;
var statearr_40479_40548 = state_40456__$1;
(statearr_40479_40548[(2)] = inst_40374);

(statearr_40479_40548[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (44))){
var inst_40428 = (state_40456[(16)]);
var inst_40295 = (state_40456[(15)]);
var inst_40431 = cljs.core.PersistentHashSet.EMPTY;
var inst_40432 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40431,inst_40428);
var inst_40433 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_40295,inst_40432);
var state_40456__$1 = state_40456;
var statearr_40480_40549 = state_40456__$1;
(statearr_40480_40549[(2)] = inst_40433);

(statearr_40480_40549[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (6))){
var inst_40280 = (state_40456[(17)]);
var inst_40290 = cljs.core.seq(inst_40280);
var inst_40291 = cljs.core.first(inst_40290);
var inst_40292 = cljs.core.next(inst_40290);
var inst_40293 = cljs.core.PersistentHashSet.EMPTY;
var inst_40294 = inst_40280;
var inst_40295 = inst_40293;
var state_40456__$1 = (function (){var statearr_40481 = state_40456;
(statearr_40481[(14)] = inst_40294);

(statearr_40481[(15)] = inst_40295);

(statearr_40481[(18)] = inst_40291);

(statearr_40481[(19)] = inst_40292);

return statearr_40481;
})();
var statearr_40482_40550 = state_40456__$1;
(statearr_40482_40550[(2)] = null);

(statearr_40482_40550[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (28))){
var inst_40423 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40483_40551 = state_40456__$1;
(statearr_40483_40551[(2)] = inst_40423);

(statearr_40483_40551[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (25))){
var inst_40360 = (state_40456[(2)]);
var inst_40361 = fluree.db.util.async.throw_err(inst_40360);
var state_40456__$1 = state_40456;
var statearr_40484_40552 = state_40456__$1;
(statearr_40484_40552[(2)] = inst_40361);

(statearr_40484_40552[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (34))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40392 = [inst_40309];
var inst_40393 = (new cljs.core.PersistentVector(null,1,(5),inst_40391,inst_40392,null));
var inst_40394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40395 = [inst_40309,inst_40311];
var inst_40396 = (new cljs.core.PersistentVector(null,2,(5),inst_40394,inst_40395,null));
var inst_40397 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_40393,cljs.core._LT_,inst_40396);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(37),inst_40397);
} else {
if((state_val_40457 === (17))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40331 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40332 = [inst_40309,inst_40311];
var inst_40333 = (new cljs.core.PersistentVector(null,2,(5),inst_40331,inst_40332,null));
var inst_40334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40335 = [inst_40309];
var inst_40336 = (new cljs.core.PersistentVector(null,1,(5),inst_40334,inst_40335,null));
var inst_40337 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_40333,cljs.core._LT__EQ_,inst_40336);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(20),inst_40337);
} else {
if((state_val_40457 === (3))){
var inst_40454 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40456__$1,inst_40454);
} else {
if((state_val_40457 === (12))){
var inst_40309 = (state_40456[(8)]);
var inst_40301 = (state_40456[(20)]);
var inst_40309__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40301,(0),null);
var inst_40310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40301,(1),null);
var inst_40311 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40301,(2),null);
var inst_40312 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_40309__$1);
var inst_40313 = cljs.core.not(inst_40312);
var state_40456__$1 = (function (){var statearr_40485 = state_40456;
(statearr_40485[(7)] = inst_40311);

(statearr_40485[(10)] = inst_40310);

(statearr_40485[(8)] = inst_40309__$1);

return statearr_40485;
})();
if(inst_40313){
var statearr_40486_40553 = state_40456__$1;
(statearr_40486_40553[(1)] = (14));

} else {
var statearr_40487_40554 = state_40456__$1;
(statearr_40487_40554[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (2))){
var inst_40280 = (state_40456[(17)]);
var _ = (function (){var statearr_40488 = state_40456;
(statearr_40488[(4)] = cljs.core.cons((5),(state_40456[(4)])));

return statearr_40488;
})();
var inst_40278 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_40279 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40278,(0),null);
var inst_40280__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40278,(1),null);
var inst_40281 = cljs.core.not_empty(inst_40280__$1);
var state_40456__$1 = (function (){var statearr_40489 = state_40456;
(statearr_40489[(17)] = inst_40280__$1);

(statearr_40489[(21)] = inst_40279);

return statearr_40489;
})();
if(cljs.core.truth_(inst_40281)){
var statearr_40490_40555 = state_40456__$1;
(statearr_40490_40555[(1)] = (6));

} else {
var statearr_40491_40556 = state_40456__$1;
(statearr_40491_40556[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (23))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40363 = (inst_40328.cljs$core$IFn$_invoke$arity$2 ? inst_40328.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_40310) : inst_40328.call(null,cljs.core._GT_,inst_40310));
var state_40456__$1 = state_40456;
if(cljs.core.truth_(inst_40363)){
var statearr_40492_40557 = state_40456__$1;
(statearr_40492_40557[(1)] = (26));

} else {
var statearr_40493_40558 = state_40456__$1;
(statearr_40493_40558[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (47))){
var inst_40444 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40494_40559 = state_40456__$1;
(statearr_40494_40559[(2)] = inst_40444);

(statearr_40494_40559[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (35))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40402 = (inst_40328.cljs$core$IFn$_invoke$arity$2 ? inst_40328.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_40310) : inst_40328.call(null,cljs.core._LT__EQ_,inst_40310));
var state_40456__$1 = state_40456;
if(cljs.core.truth_(inst_40402)){
var statearr_40495_40560 = state_40456__$1;
(statearr_40495_40560[(1)] = (38));

} else {
var statearr_40496_40561 = state_40456__$1;
(statearr_40496_40561[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (19))){
var inst_40279 = (state_40456[(21)]);
var inst_40427 = (state_40456[(2)]);
var inst_40428 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_40427);
var state_40456__$1 = (function (){var statearr_40497 = state_40456;
(statearr_40497[(16)] = inst_40428);

return statearr_40497;
})();
var G__40498_40562 = inst_40279;
var G__40498_40563__$1 = (((G__40498_40562 instanceof cljs.core.Keyword))?G__40498_40562.fqn:null);
switch (G__40498_40563__$1) {
case "or":
var statearr_40499_40565 = state_40456__$1;
(statearr_40499_40565[(1)] = (43));


break;
case "and":
var statearr_40500_40566 = state_40456__$1;
(statearr_40500_40566[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40498_40563__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (11))){
var inst_40295 = (state_40456[(15)]);
var state_40456__$1 = state_40456;
var statearr_40502_40567 = state_40456__$1;
(statearr_40502_40567[(2)] = inst_40295);

(statearr_40502_40567[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (9))){
var inst_40294 = (state_40456[(14)]);
var inst_40301 = (state_40456[(20)]);
var inst_40300 = cljs.core.seq(inst_40294);
var inst_40301__$1 = cljs.core.first(inst_40300);
var inst_40302 = cljs.core.next(inst_40300);
var inst_40303 = cljs.core.not(inst_40301__$1);
var state_40456__$1 = (function (){var statearr_40503 = state_40456;
(statearr_40503[(12)] = inst_40302);

(statearr_40503[(20)] = inst_40301__$1);

return statearr_40503;
})();
if(inst_40303){
var statearr_40504_40568 = state_40456__$1;
(statearr_40504_40568[(1)] = (11));

} else {
var statearr_40505_40569 = state_40456__$1;
(statearr_40505_40569[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (5))){
var _ = (function (){var statearr_40506 = state_40456;
(statearr_40506[(4)] = cljs.core.rest((state_40456[(4)])));

return statearr_40506;
})();
var state_40456__$1 = state_40456;
var ex40501 = (state_40456__$1[(2)]);
var statearr_40507_40570 = state_40456__$1;
(statearr_40507_40570[(5)] = ex40501);


if((ex40501 instanceof Error)){
var statearr_40508_40571 = state_40456__$1;
(statearr_40508_40571[(1)] = (4));

(statearr_40508_40571[(5)] = null);

} else {
throw ex40501;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (14))){
var inst_40309 = (state_40456[(8)]);
var inst_40315 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_40309);
var inst_40316 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40315)].join('');
var inst_40317 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40318 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40319 = cljs.core.PersistentHashMap.fromArrays(inst_40317,inst_40318);
var inst_40320 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40316,inst_40319);
var inst_40321 = (function(){throw inst_40320})();
var state_40456__$1 = state_40456;
var statearr_40509_40572 = state_40456__$1;
(statearr_40509_40572[(2)] = inst_40321);

(statearr_40509_40572[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (45))){
var inst_40436 = (state_40456[(13)]);
var state_40456__$1 = state_40456;
var statearr_40510_40573 = state_40456__$1;
(statearr_40510_40573[(2)] = inst_40436);

(statearr_40510_40573[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (26))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40366 = [inst_40309,inst_40311];
var inst_40367 = (new cljs.core.PersistentVector(null,2,(5),inst_40365,inst_40366,null));
var inst_40368 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40369 = [inst_40309];
var inst_40370 = (new cljs.core.PersistentVector(null,1,(5),inst_40368,inst_40369,null));
var inst_40371 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_40367,cljs.core._LT__EQ_,inst_40370);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(29),inst_40371);
} else {
if((state_val_40457 === (16))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40324 = (state_40456[(2)]);
var inst_40328__$1 = cljs.core.identical_QMARK_;
var inst_40329 = (inst_40328__$1.cljs$core$IFn$_invoke$arity$2 ? inst_40328__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_40310) : inst_40328__$1.call(null,cljs.core.not_EQ_,inst_40310));
var state_40456__$1 = (function (){var statearr_40511 = state_40456;
(statearr_40511[(11)] = inst_40328__$1);

(statearr_40511[(22)] = inst_40324);

return statearr_40511;
})();
if(cljs.core.truth_(inst_40329)){
var statearr_40512_40574 = state_40456__$1;
(statearr_40512_40574[(1)] = (17));

} else {
var statearr_40513_40575 = state_40456__$1;
(statearr_40513_40575[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (38))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40405 = [inst_40309];
var inst_40406 = (new cljs.core.PersistentVector(null,1,(5),inst_40404,inst_40405,null));
var inst_40407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40408 = [inst_40309,inst_40311];
var inst_40409 = (new cljs.core.PersistentVector(null,2,(5),inst_40407,inst_40408,null));
var inst_40410 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_40406,cljs.core._LT__EQ_,inst_40409);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(41),inst_40410);
} else {
if((state_val_40457 === (30))){
var inst_40311 = (state_40456[(7)]);
var inst_40309 = (state_40456[(8)]);
var inst_40378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40379 = [inst_40309,inst_40311];
var inst_40380 = (new cljs.core.PersistentVector(null,2,(5),inst_40378,inst_40379,null));
var inst_40381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40382 = [inst_40309];
var inst_40383 = (new cljs.core.PersistentVector(null,1,(5),inst_40381,inst_40382,null));
var inst_40384 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_40380,cljs.core._LT__EQ_,inst_40383);
var state_40456__$1 = state_40456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40456__$1,(33),inst_40384);
} else {
if((state_val_40457 === (10))){
var inst_40448 = (state_40456[(2)]);
var state_40456__$1 = state_40456;
var statearr_40514_40576 = state_40456__$1;
(statearr_40514_40576[(2)] = inst_40448);

(statearr_40514_40576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (18))){
var inst_40310 = (state_40456[(10)]);
var inst_40328 = (state_40456[(11)]);
var inst_40353 = (inst_40328.cljs$core$IFn$_invoke$arity$2 ? inst_40328.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_40310) : inst_40328.call(null,cljs.core._EQ_,inst_40310));
var state_40456__$1 = state_40456;
if(cljs.core.truth_(inst_40353)){
var statearr_40515_40577 = state_40456__$1;
(statearr_40515_40577[(1)] = (22));

} else {
var statearr_40516_40578 = state_40456__$1;
(statearr_40516_40578[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (42))){
var inst_40279 = (state_40456[(21)]);
var inst_40436 = (state_40456[(13)]);
var inst_40436__$1 = (state_40456[(2)]);
var inst_40437 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_40279);
var inst_40438 = cljs.core.empty_QMARK_(inst_40436__$1);
var inst_40439 = ((inst_40437) && (inst_40438));
var state_40456__$1 = (function (){var statearr_40517 = state_40456;
(statearr_40517[(13)] = inst_40436__$1);

return statearr_40517;
})();
if(cljs.core.truth_(inst_40439)){
var statearr_40518_40579 = state_40456__$1;
(statearr_40518_40579[(1)] = (45));

} else {
var statearr_40519_40580 = state_40456__$1;
(statearr_40519_40580[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (37))){
var inst_40399 = (state_40456[(2)]);
var inst_40400 = fluree.db.util.async.throw_err(inst_40399);
var state_40456__$1 = state_40456;
var statearr_40520_40581 = state_40456__$1;
(statearr_40520_40581[(2)] = inst_40400);

(statearr_40520_40581[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40457 === (8))){
var inst_40451 = (state_40456[(2)]);
var _ = (function (){var statearr_40521 = state_40456;
(statearr_40521[(4)] = cljs.core.rest((state_40456[(4)])));

return statearr_40521;
})();
var state_40456__$1 = state_40456;
var statearr_40522_40582 = state_40456__$1;
(statearr_40522_40582[(2)] = inst_40451);

(statearr_40522_40582[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16291__auto__ = null;
var fluree$db$query$fql$state_machine__16291__auto____0 = (function (){
var statearr_40523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40523[(0)] = fluree$db$query$fql$state_machine__16291__auto__);

(statearr_40523[(1)] = (1));

return statearr_40523;
});
var fluree$db$query$fql$state_machine__16291__auto____1 = (function (state_40456){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40456);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40524){var ex__16294__auto__ = e40524;
var statearr_40525_40583 = state_40456;
(statearr_40525_40583[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40456[(4)]))){
var statearr_40526_40584 = state_40456;
(statearr_40526_40584[(1)] = cljs.core.first((state_40456[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40585 = state_40456;
state_40456 = G__40585;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16291__auto__ = function(state_40456){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16291__auto____1.call(this,state_40456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16291__auto____0;
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16291__auto____1;
return fluree$db$query$fql$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40527 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40527[(6)] = c__16328__auto__);

return statearr_40527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(orderBy,p__40587,offset,limit){
var map__40588 = p__40587;
var map__40588__$1 = (((((!((map__40588 == null))))?(((((map__40588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40588.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40588):map__40588);
var res = map__40588__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40588__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40588__$1,cljs.core.cst$kw$tuples);
var vec__40590 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40590,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40590,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples__$1 = ((((0) <= indexOfFind))?(function (){var G__40593 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__40586_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40586_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
var G__40593__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?cljs.core.reverse(G__40593):G__40593);
var G__40593__$2 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__40593__$1):G__40593__$1);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__40593__$2);
} else {
return G__40593__$2;
}
})():tuples);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$tuples,tuples__$1], null);
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__40594_SHARP_){
return ((typeof p1__40594_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__40594_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__40595_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__40595_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__40599 = vars;
var vec__40600 = G__40599;
var seq__40601 = cljs.core.seq(vec__40600);
var first__40602 = cljs.core.first(seq__40601);
var seq__40601__$1 = cljs.core.next(seq__40601);
var var$ = first__40602;
var r = seq__40601__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__40599__$1 = G__40599;
var all_vars__$1 = all_vars;
while(true){
var vec__40607 = G__40599__$1;
var seq__40608 = cljs.core.seq(vec__40607);
var first__40609 = cljs.core.first(seq__40608);
var seq__40608__$1 = cljs.core.next(seq__40608);
var var$__$1 = first__40609;
var r__$1 = seq__40608__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__40610 = cljs.core.set(all_vars__$2);
return (fexpr__40610.cljs$core$IFn$_invoke$arity$1 ? fexpr__40610.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__40610.call(null,var$__$1));
})())){
var G__40611 = r__$1;
var G__40612 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__40599__$1 = G__40611;
all_vars__$1 = G__40612;
continue;
} else {
var G__40613 = r__$1;
var G__40614 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__40599__$1 = G__40613;
all_vars__$1 = G__40614;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40649){
var state_val_40650 = (state_40649[(1)]);
if((state_val_40650 === (1))){
var inst_40622 = functionArray;
var inst_40623 = cljs.core.seq(inst_40622);
var inst_40624 = cljs.core.first(inst_40623);
var inst_40625 = cljs.core.next(inst_40623);
var inst_40626 = cljs.core.PersistentVector.EMPTY;
var inst_40627 = inst_40622;
var inst_40628 = inst_40626;
var state_40649__$1 = (function (){var statearr_40651 = state_40649;
(statearr_40651[(7)] = inst_40624);

(statearr_40651[(8)] = inst_40628);

(statearr_40651[(9)] = inst_40627);

(statearr_40651[(10)] = inst_40625);

return statearr_40651;
})();
var statearr_40652_40665 = state_40649__$1;
(statearr_40652_40665[(2)] = null);

(statearr_40652_40665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (2))){
var inst_40627 = (state_40649[(9)]);
var inst_40634 = (state_40649[(11)]);
var inst_40633 = cljs.core.seq(inst_40627);
var inst_40634__$1 = cljs.core.first(inst_40633);
var inst_40635 = cljs.core.next(inst_40633);
var state_40649__$1 = (function (){var statearr_40653 = state_40649;
(statearr_40653[(11)] = inst_40634__$1);

(statearr_40653[(12)] = inst_40635);

return statearr_40653;
})();
if(cljs.core.truth_(inst_40634__$1)){
var statearr_40654_40666 = state_40649__$1;
(statearr_40654_40666[(1)] = (4));

} else {
var statearr_40655_40667 = state_40649__$1;
(statearr_40655_40667[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (3))){
var inst_40647 = (state_40649[(2)]);
var state_40649__$1 = state_40649;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40649__$1,inst_40647);
} else {
if((state_val_40650 === (4))){
var inst_40634 = (state_40649[(11)]);
var inst_40637 = (inst_40634.cljs$core$IFn$_invoke$arity$1 ? inst_40634.cljs$core$IFn$_invoke$arity$1(tuple) : inst_40634.call(null,tuple));
var state_40649__$1 = state_40649;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40649__$1,(7),inst_40637);
} else {
if((state_val_40650 === (5))){
var inst_40628 = (state_40649[(8)]);
var state_40649__$1 = state_40649;
var statearr_40656_40668 = state_40649__$1;
(statearr_40656_40668[(2)] = inst_40628);

(statearr_40656_40668[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (6))){
var inst_40645 = (state_40649[(2)]);
var state_40649__$1 = state_40649;
var statearr_40657_40669 = state_40649__$1;
(statearr_40657_40669[(2)] = inst_40645);

(statearr_40657_40669[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40650 === (7))){
var inst_40628 = (state_40649[(8)]);
var inst_40635 = (state_40649[(12)]);
var inst_40639 = (state_40649[(2)]);
var inst_40640 = fluree.db.util.async.throw_err(inst_40639);
var inst_40641 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40628,inst_40640);
var inst_40627 = inst_40635;
var inst_40628__$1 = inst_40641;
var state_40649__$1 = (function (){var statearr_40658 = state_40649;
(statearr_40658[(8)] = inst_40628__$1);

(statearr_40658[(9)] = inst_40627);

return statearr_40658;
})();
var statearr_40659_40670 = state_40649__$1;
(statearr_40659_40670[(2)] = null);

(statearr_40659_40670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____0 = (function (){
var statearr_40660 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40660[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__);

(statearr_40660[(1)] = (1));

return statearr_40660;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____1 = (function (state_40649){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40649);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40661){var ex__16294__auto__ = e40661;
var statearr_40662_40671 = state_40649;
(statearr_40662_40671[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40649[(4)]))){
var statearr_40663_40672 = state_40649;
(statearr_40663_40672[(1)] = cljs.core.first((state_40649[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40673 = state_40649;
state_40649 = G__40673;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__ = function(state_40649){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____1.call(this,state_40649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16291__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40664 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40664[(6)] = c__16328__auto__);

return statearr_40664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__40675,headers,vars,opts){
var map__40676 = p__40675;
var map__40676__$1 = (((((!((map__40676 == null))))?(((((map__40676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40676):map__40676);
var select_spec = map__40676__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40676__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40676__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40676__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40676__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40763){
var state_val_40764 = (state_40763[(1)]);
if((state_val_40764 === (7))){
var state_40763__$1 = state_40763;
var statearr_40765_40907 = state_40763__$1;
(statearr_40765_40907[(2)] = null);

(statearr_40765_40907[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (1))){
var state_40763__$1 = state_40763;
var statearr_40766_40908 = state_40763__$1;
(statearr_40766_40908[(2)] = null);

(statearr_40766_40908[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (4))){
var inst_40678 = (state_40763[(2)]);
var state_40763__$1 = state_40763;
var statearr_40767_40909 = state_40763__$1;
(statearr_40767_40909[(2)] = inst_40678);

(statearr_40767_40909[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (15))){
var inst_40752 = (state_40763[(2)]);
var inst_40753 = fluree.db.util.async.throw_err(inst_40752);
var state_40763__$1 = state_40763;
var statearr_40768_40910 = state_40763__$1;
(statearr_40768_40910[(2)] = inst_40753);

(statearr_40768_40910[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (13))){
var inst_40696 = (state_40763[(7)]);
var inst_40688 = (state_40763[(8)]);
var inst_40755 = (function (){var pp = inst_40688;
var functionArray = inst_40696;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40674_SHARP_){
return (p1__40674_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__40674_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__40674_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_40756 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40755,tuples);
var state_40763__$1 = state_40763;
var statearr_40769_40911 = state_40763__$1;
(statearr_40769_40911[(2)] = inst_40756);

(statearr_40769_40911[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (6))){
var inst_40685 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_40763__$1 = state_40763;
var statearr_40770_40912 = state_40763__$1;
(statearr_40770_40912[(2)] = inst_40685);

(statearr_40770_40912[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (3))){
var inst_40761 = (state_40763[(2)]);
var state_40763__$1 = state_40763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40763__$1,inst_40761);
} else {
if((state_val_40764 === (12))){
var inst_40696 = (state_40763[(7)]);
var inst_40688 = (state_40763[(8)]);
var inst_40748 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_40749 = (function (){var pp = inst_40688;
var functionArray = inst_40696;
var c__16328__auto____$1 = inst_40748;
return (function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40746){
var state_val_40747 = (state_40746[(1)]);
if((state_val_40747 === (7))){
var inst_40722 = (state_40746[(2)]);
var inst_40723 = fluree.db.util.async.throw_err(inst_40722);
var state_40746__$1 = (function (){var statearr_40771 = state_40746;
(statearr_40771[(7)] = inst_40723);

return statearr_40771;
})();
if(cljs.core.truth_(pp)){
var statearr_40772_40913 = state_40746__$1;
(statearr_40772_40913[(1)] = (8));

} else {
var statearr_40773_40914 = state_40746__$1;
(statearr_40773_40914[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (1))){
var inst_40705 = tuples;
var inst_40706 = cljs.core.seq(inst_40705);
var inst_40707 = cljs.core.first(inst_40706);
var inst_40708 = cljs.core.next(inst_40706);
var inst_40709 = cljs.core.PersistentVector.EMPTY;
var inst_40710 = inst_40705;
var inst_40711 = inst_40709;
var state_40746__$1 = (function (){var statearr_40774 = state_40746;
(statearr_40774[(8)] = inst_40711);

(statearr_40774[(9)] = inst_40708);

(statearr_40774[(10)] = inst_40710);

(statearr_40774[(11)] = inst_40707);

return statearr_40774;
})();
var statearr_40775_40915 = state_40746__$1;
(statearr_40775_40915[(2)] = null);

(statearr_40775_40915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (4))){
var inst_40717 = (state_40746[(12)]);
var inst_40720 = fluree.db.query.fql.format_tuple(functionArray,inst_40717);
var state_40746__$1 = state_40746;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40746__$1,(7),inst_40720);
} else {
if((state_val_40747 === (15))){
var state_40746__$1 = state_40746;
var statearr_40776_40916 = state_40746__$1;
(statearr_40776_40916[(2)] = null);

(statearr_40776_40916[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (13))){
var inst_40735 = (state_40746[(2)]);
var state_40746__$1 = state_40746;
var statearr_40777_40917 = state_40746__$1;
(statearr_40777_40917[(2)] = inst_40735);

(statearr_40777_40917[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (6))){
var inst_40742 = (state_40746[(2)]);
var state_40746__$1 = state_40746;
var statearr_40778_40918 = state_40746__$1;
(statearr_40778_40918[(2)] = inst_40742);

(statearr_40778_40918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (3))){
var inst_40744 = (state_40746[(2)]);
var state_40746__$1 = state_40746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40746__$1,inst_40744);
} else {
if((state_val_40747 === (12))){
var state_40746__$1 = state_40746;
var statearr_40779_40919 = state_40746__$1;
(statearr_40779_40919[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (2))){
var inst_40710 = (state_40746[(10)]);
var inst_40717 = (state_40746[(12)]);
var inst_40716 = cljs.core.seq(inst_40710);
var inst_40717__$1 = cljs.core.first(inst_40716);
var inst_40718 = cljs.core.next(inst_40716);
var state_40746__$1 = (function (){var statearr_40781 = state_40746;
(statearr_40781[(12)] = inst_40717__$1);

(statearr_40781[(13)] = inst_40718);

return statearr_40781;
})();
if(cljs.core.truth_(inst_40717__$1)){
var statearr_40782_40920 = state_40746__$1;
(statearr_40782_40920[(1)] = (4));

} else {
var statearr_40783_40921 = state_40746__$1;
(statearr_40783_40921[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (11))){
var inst_40723 = (state_40746[(7)]);
var state_40746__$1 = state_40746;
var statearr_40784_40922 = state_40746__$1;
(statearr_40784_40922[(2)] = inst_40723);

(statearr_40784_40922[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (9))){
var state_40746__$1 = state_40746;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40785_40923 = state_40746__$1;
(statearr_40785_40923[(1)] = (11));

} else {
var statearr_40786_40924 = state_40746__$1;
(statearr_40786_40924[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (5))){
var inst_40711 = (state_40746[(8)]);
var state_40746__$1 = state_40746;
var statearr_40787_40925 = state_40746__$1;
(statearr_40787_40925[(2)] = inst_40711);

(statearr_40787_40925[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (14))){
var inst_40723 = (state_40746[(7)]);
var inst_40730 = cljs.core.first(inst_40723);
var state_40746__$1 = state_40746;
var statearr_40788_40926 = state_40746__$1;
(statearr_40788_40926[(2)] = inst_40730);

(statearr_40788_40926[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (16))){
var inst_40733 = (state_40746[(2)]);
var state_40746__$1 = state_40746;
var statearr_40789_40927 = state_40746__$1;
(statearr_40789_40927[(2)] = inst_40733);

(statearr_40789_40927[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (10))){
var inst_40711 = (state_40746[(8)]);
var inst_40718 = (state_40746[(13)]);
var inst_40737 = (state_40746[(2)]);
var inst_40738 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40711,inst_40737);
var inst_40710 = inst_40718;
var inst_40711__$1 = inst_40738;
var state_40746__$1 = (function (){var statearr_40790 = state_40746;
(statearr_40790[(8)] = inst_40711__$1);

(statearr_40790[(10)] = inst_40710);

return statearr_40790;
})();
var statearr_40791_40928 = state_40746__$1;
(statearr_40791_40928[(2)] = null);

(statearr_40791_40928[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40747 === (8))){
var inst_40723 = (state_40746[(7)]);
var inst_40725 = cljs.core.zipmap(pp,inst_40723);
var state_40746__$1 = state_40746;
var statearr_40792_40929 = state_40746__$1;
(statearr_40792_40929[(2)] = inst_40725);

(statearr_40792_40929[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_40793 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40793[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__);

(statearr_40793[(1)] = (1));

return statearr_40793;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1 = (function (state_40746){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40746);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40794){var ex__16294__auto__ = e40794;
var statearr_40795_40930 = state_40746;
(statearr_40795_40930[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40746[(4)]))){
var statearr_40796_40931 = state_40746;
(statearr_40796_40931[(1)] = cljs.core.first((state_40746[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40932 = state_40746;
state_40746 = G__40932;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = function(state_40746){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1.call(this,state_40746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40797 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40797[(6)] = c__16328__auto____$1);

return statearr_40797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
});
})();
var inst_40750 = cljs.core.async.impl.dispatch.run(inst_40749);
var state_40763__$1 = (function (){var statearr_40798 = state_40763;
(statearr_40798[(9)] = inst_40750);

return statearr_40798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40763__$1,(15),inst_40748);
} else {
if((state_val_40764 === (2))){
var _ = (function (){var statearr_40799 = state_40763;
(statearr_40799[(4)] = cljs.core.cons((5),(state_40763[(4)])));

return statearr_40799;
})();
var state_40763__$1 = state_40763;
if(cljs.core.truth_(prettyPrint)){
var statearr_40800_40933 = state_40763__$1;
(statearr_40800_40933[(1)] = (6));

} else {
var statearr_40801_40934 = state_40763__$1;
(statearr_40801_40934[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (11))){
var inst_40696 = (state_40763[(2)]);
var state_40763__$1 = (function (){var statearr_40803 = state_40763;
(statearr_40803[(7)] = inst_40696);

return statearr_40803;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_40804_40935 = state_40763__$1;
(statearr_40804_40935[(1)] = (12));

} else {
var statearr_40805_40936 = state_40763__$1;
(statearr_40805_40936[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (9))){
var inst_40688 = (state_40763[(8)]);
var inst_40690 = (function (){var pp = inst_40688;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__16328__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40840){
var state_val_40841 = (state_40840[(1)]);
if((state_val_40841 === (7))){
var state_40840__$1 = state_40840;
var statearr_40842_40937 = state_40840__$1;
(statearr_40842_40937[(2)] = null);

(statearr_40842_40937[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (1))){
var state_40840__$1 = state_40840;
var statearr_40843_40938 = state_40840__$1;
(statearr_40843_40938[(2)] = null);

(statearr_40843_40938[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (4))){
var inst_40806 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
var statearr_40844_40939 = state_40840__$1;
(statearr_40844_40939[(2)] = inst_40806);

(statearr_40844_40939[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (6))){
var inst_40816 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40817 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_40818 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_40819 = [inst_40817,inst_40818,opts];
var inst_40820 = cljs.core.PersistentHashMap.fromArrays(inst_40816,inst_40819);
var inst_40821 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_40820) : fluree.db.query.fql.query.call(null,db,inst_40820));
var state_40840__$1 = state_40840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40840__$1,(9),inst_40821);
} else {
if((state_val_40841 === (3))){
var inst_40838 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40840__$1,inst_40838);
} else {
if((state_val_40841 === (12))){
var inst_40832 = (state_40840[(2)]);
var state_40840__$1 = state_40840;
var statearr_40845_40940 = state_40840__$1;
(statearr_40845_40940[(2)] = inst_40832);

(statearr_40845_40940[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (2))){
var _ = (function (){var statearr_40846 = state_40840;
(statearr_40846[(4)] = cljs.core.cons((5),(state_40840[(4)])));

return statearr_40846;
})();
var inst_40812 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_40840__$1 = state_40840;
if(cljs.core.truth_(inst_40812)){
var statearr_40847_40941 = state_40840__$1;
(statearr_40847_40941[(1)] = (6));

} else {
var statearr_40848_40942 = state_40840__$1;
(statearr_40848_40942[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (11))){
var inst_40827 = [cljs.core.cst$kw$_id];
var inst_40828 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_40829 = [inst_40828];
var inst_40830 = cljs.core.PersistentHashMap.fromArrays(inst_40827,inst_40829);
var state_40840__$1 = state_40840;
var statearr_40850_40943 = state_40840__$1;
(statearr_40850_40943[(2)] = inst_40830);

(statearr_40850_40943[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (9))){
var inst_40824 = (state_40840[(7)]);
var inst_40823 = (state_40840[(2)]);
var inst_40824__$1 = fluree.db.util.async.throw_err(inst_40823);
var state_40840__$1 = (function (){var statearr_40851 = state_40840;
(statearr_40851[(7)] = inst_40824__$1);

return statearr_40851;
})();
if(cljs.core.truth_(inst_40824__$1)){
var statearr_40852_40944 = state_40840__$1;
(statearr_40852_40944[(1)] = (10));

} else {
var statearr_40853_40945 = state_40840__$1;
(statearr_40853_40945[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (5))){
var _ = (function (){var statearr_40854 = state_40840;
(statearr_40854[(4)] = cljs.core.rest((state_40840[(4)])));

return statearr_40854;
})();
var state_40840__$1 = state_40840;
var ex40849 = (state_40840__$1[(2)]);
var statearr_40855_40946 = state_40840__$1;
(statearr_40855_40946[(5)] = ex40849);


if((ex40849 instanceof Error)){
var statearr_40856_40947 = state_40840__$1;
(statearr_40856_40947[(1)] = (4));

(statearr_40856_40947[(5)] = null);

} else {
throw ex40849;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (10))){
var inst_40824 = (state_40840[(7)]);
var state_40840__$1 = state_40840;
var statearr_40857_40948 = state_40840__$1;
(statearr_40857_40948[(2)] = inst_40824);

(statearr_40857_40948[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40841 === (8))){
var inst_40835 = (state_40840[(2)]);
var _ = (function (){var statearr_40858 = state_40840;
(statearr_40858[(4)] = cljs.core.rest((state_40840[(4)])));

return statearr_40858;
})();
var state_40840__$1 = state_40840;
var statearr_40859_40949 = state_40840__$1;
(statearr_40859_40949[(2)] = inst_40835);

(statearr_40859_40949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_40860 = [null,null,null,null,null,null,null,null];
(statearr_40860[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__);

(statearr_40860[(1)] = (1));

return statearr_40860;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1 = (function (state_40840){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40840);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40861){var ex__16294__auto__ = e40861;
var statearr_40862_40950 = state_40840;
(statearr_40862_40950[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40840[(4)]))){
var statearr_40863_40951 = state_40840;
(statearr_40863_40951[(1)] = cljs.core.first((state_40840[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40952 = state_40840;
state_40840 = G__40952;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = function(state_40840){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1.call(this,state_40840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40864 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40864[(6)] = c__16328__auto____$1);

return statearr_40864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto____$1;
});
} else {
return (function (tuple){
var c__16328__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_40876){
var state_val_40877 = (state_40876[(1)]);
if((state_val_40877 === (1))){
var state_40876__$1 = state_40876;
var statearr_40878_40953 = state_40876__$1;
(statearr_40878_40953[(2)] = null);

(statearr_40878_40953[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40877 === (2))){
var _ = (function (){var statearr_40879 = state_40876;
(statearr_40879[(4)] = cljs.core.cons((5),(state_40876[(4)])));

return statearr_40879;
})();
var inst_40871 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_40880 = state_40876;
(statearr_40880[(4)] = cljs.core.rest((state_40876[(4)])));

return statearr_40880;
})();
var state_40876__$1 = state_40876;
var statearr_40881_40954 = state_40876__$1;
(statearr_40881_40954[(2)] = inst_40871);

(statearr_40881_40954[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40877 === (3))){
var inst_40874 = (state_40876[(2)]);
var state_40876__$1 = state_40876;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40876__$1,inst_40874);
} else {
if((state_val_40877 === (4))){
var inst_40865 = (state_40876[(2)]);
var state_40876__$1 = state_40876;
var statearr_40883_40955 = state_40876__$1;
(statearr_40883_40955[(2)] = inst_40865);

(statearr_40883_40955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40877 === (5))){
var _ = (function (){var statearr_40884 = state_40876;
(statearr_40884[(4)] = cljs.core.rest((state_40876[(4)])));

return statearr_40884;
})();
var state_40876__$1 = state_40876;
var ex40882 = (state_40876__$1[(2)]);
var statearr_40885_40956 = state_40876__$1;
(statearr_40885_40956[(5)] = ex40882);


if((ex40882 instanceof Error)){
var statearr_40886_40957 = state_40876__$1;
(statearr_40886_40957[(1)] = (4));

(statearr_40886_40957[(5)] = null);

} else {
throw ex40882;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_40887 = [null,null,null,null,null,null,null];
(statearr_40887[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__);

(statearr_40887[(1)] = (1));

return statearr_40887;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1 = (function (state_40876){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40876);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40888){var ex__16294__auto__ = e40888;
var statearr_40889_40958 = state_40876;
(statearr_40889_40958[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40876[(4)]))){
var statearr_40890_40959 = state_40876;
(statearr_40890_40959[(1)] = cljs.core.first((state_40876[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40960 = state_40876;
state_40876 = G__40960;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = function(state_40876){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1.call(this,state_40876);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40891 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40891[(6)] = c__16328__auto____$1);

return statearr_40891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto____$1;
});
}
});
})();
var inst_40691 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40690,select);
var state_40763__$1 = state_40763;
var statearr_40892_40961 = state_40763__$1;
(statearr_40892_40961[(2)] = inst_40691);

(statearr_40892_40961[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (5))){
var _ = (function (){var statearr_40893 = state_40763;
(statearr_40893[(4)] = cljs.core.rest((state_40763[(4)])));

return statearr_40893;
})();
var state_40763__$1 = state_40763;
var ex40802 = (state_40763__$1[(2)]);
var statearr_40894_40962 = state_40763__$1;
(statearr_40894_40962[(5)] = ex40802);


if((ex40802 instanceof Error)){
var statearr_40895_40963 = state_40763__$1;
(statearr_40895_40963[(1)] = (4));

(statearr_40895_40963[(5)] = null);

} else {
throw ex40802;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (14))){
var inst_40758 = (state_40763[(2)]);
var _ = (function (){var statearr_40896 = state_40763;
(statearr_40896[(4)] = cljs.core.rest((state_40763[(4)])));

return statearr_40896;
})();
var state_40763__$1 = state_40763;
var statearr_40897_40964 = state_40763__$1;
(statearr_40897_40964[(2)] = inst_40758);

(statearr_40897_40964[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (10))){
var inst_40688 = (state_40763[(8)]);
var inst_40693 = (function (){var pp = inst_40688;
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_40694 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40693,select);
var state_40763__$1 = state_40763;
var statearr_40898_40965 = state_40763__$1;
(statearr_40898_40965[(2)] = inst_40694);

(statearr_40898_40965[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40764 === (8))){
var inst_40688 = (state_40763[(2)]);
var state_40763__$1 = (function (){var statearr_40899 = state_40763;
(statearr_40899[(8)] = inst_40688);

return statearr_40899;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_40900_40966 = state_40763__$1;
(statearr_40900_40966[(1)] = (9));

} else {
var statearr_40901_40967 = state_40763__$1;
(statearr_40901_40967[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0 = (function (){
var statearr_40902 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40902[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__);

(statearr_40902[(1)] = (1));

return statearr_40902;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1 = (function (state_40763){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_40763);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e40903){var ex__16294__auto__ = e40903;
var statearr_40904_40968 = state_40763;
(statearr_40904_40968[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_40763[(4)]))){
var statearr_40905_40969 = state_40763;
(statearr_40905_40969[(1)] = cljs.core.first((state_40763[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__40970 = state_40763;
state_40763 = G__40970;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__ = function(state_40763){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1.call(this,state_40763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_40906 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_40906[(6)] = c__16328__auto__);

return statearr_40906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__40972 = arguments.length;
switch (G__40972) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__40973,p__40974,group_limit,opts){
var map__40975 = p__40973;
var map__40975__$1 = (((((!((map__40975 == null))))?(((((map__40975.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40975.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40975):map__40975);
var res = map__40975__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40975__$1,cljs.core.cst$kw$vars);
var map__40976 = p__40974;
var map__40976__$1 = (((((!((map__40976 == null))))?(((((map__40976.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40976.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40976):map__40976);
var select_spec = map__40976__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40976__$1,cljs.core.cst$kw$groupBy);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_41088){
var state_val_41089 = (state_41088[(1)]);
if((state_val_41089 === (7))){
var inst_40985 = (state_41088[(7)]);
var state_41088__$1 = state_41088;
var statearr_41090_41170 = state_41088__$1;
(statearr_41090_41170[(2)] = inst_40985);

(statearr_41090_41170[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (20))){
var inst_41020 = (state_41088[(2)]);
var state_41088__$1 = (function (){var statearr_41091 = state_41088;
(statearr_41091[(8)] = inst_41020);

return statearr_41091;
})();
if(cljs.core.truth_(groupBy)){
var statearr_41092_41171 = state_41088__$1;
(statearr_41092_41171[(1)] = (21));

} else {
var statearr_41093_41172 = state_41088__$1;
(statearr_41093_41172[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (27))){
var inst_41029 = (state_41088[(9)]);
var inst_41034 = inst_41029.cljs$lang$protocol_mask$partition0$;
var inst_41035 = (inst_41034 & (64));
var inst_41036 = inst_41029.cljs$core$ISeq$;
var inst_41037 = (cljs.core.PROTOCOL_SENTINEL === inst_41036);
var inst_41038 = ((inst_41035) || (inst_41037));
var state_41088__$1 = state_41088;
if(cljs.core.truth_(inst_41038)){
var statearr_41094_41173 = state_41088__$1;
(statearr_41094_41173[(1)] = (30));

} else {
var statearr_41095_41174 = state_41088__$1;
(statearr_41095_41174[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (1))){
var state_41088__$1 = state_41088;
var statearr_41096_41175 = state_41088__$1;
(statearr_41096_41175[(2)] = null);

(statearr_41096_41175[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (24))){
var inst_41024 = (state_41088[(10)]);
var inst_41020 = (state_41088[(8)]);
var inst_41026 = fluree.db.query.fql.order_offset_and_limit_results(orderBy,inst_41020,inst_41024,group_limit);
var state_41088__$1 = state_41088;
var statearr_41097_41176 = state_41088__$1;
(statearr_41097_41176[(2)] = inst_41026);

(statearr_41097_41176[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (39))){
var inst_41055 = (state_41088[(11)]);
var state_41088__$1 = state_41088;
var statearr_41098_41177 = state_41088__$1;
(statearr_41098_41177[(2)] = inst_41055);

(statearr_41098_41177[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (46))){
var inst_41073 = (state_41088[(12)]);
var inst_41075 = cljs.core.PersistentVector.EMPTY;
var inst_41076 = cljs.core.PersistentHashSet.EMPTY;
var inst_41077 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41076,inst_41073);
var inst_41078 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41075,inst_41077);
var state_41088__$1 = state_41088;
var statearr_41099_41178 = state_41088__$1;
(statearr_41099_41178[(2)] = inst_41078);

(statearr_41099_41178[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (4))){
var inst_40979 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
var statearr_41100_41179 = state_41088__$1;
(statearr_41100_41179[(2)] = inst_40979);

(statearr_41100_41179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (15))){
var inst_41006 = (state_41088[(13)]);
var inst_41008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41009 = [inst_41006];
var inst_41010 = (new cljs.core.PersistentVector(null,1,(5),inst_41008,inst_41009,null));
var state_41088__$1 = state_41088;
var statearr_41101_41180 = state_41088__$1;
(statearr_41101_41180[(2)] = inst_41010);

(statearr_41101_41180[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (48))){
var inst_41081 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
var statearr_41102_41181 = state_41088__$1;
(statearr_41102_41181[(2)] = inst_41081);

(statearr_41102_41181[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (21))){
var state_41088__$1 = state_41088;
var statearr_41103_41182 = state_41088__$1;
(statearr_41103_41182[(2)] = (0));

(statearr_41103_41182[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (31))){
var state_41088__$1 = state_41088;
var statearr_41104_41183 = state_41088__$1;
(statearr_41104_41183[(2)] = false);

(statearr_41104_41183[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (32))){
var inst_41042 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
var statearr_41105_41184 = state_41088__$1;
(statearr_41105_41184[(2)] = inst_41042);

(statearr_41105_41184[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (40))){
var inst_41024 = (state_41088[(10)]);
var state_41088__$1 = state_41088;
var statearr_41106_41185 = state_41088__$1;
(statearr_41106_41185[(2)] = inst_41024);

(statearr_41106_41185[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (33))){
var inst_41029 = (state_41088[(9)]);
var inst_41047 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_41029);
var state_41088__$1 = state_41088;
var statearr_41107_41186 = state_41088__$1;
(statearr_41107_41186[(2)] = inst_41047);

(statearr_41107_41186[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (13))){
var inst_40995 = (state_41088[(14)]);
var state_41088__$1 = state_41088;
var statearr_41108_41187 = state_41088__$1;
(statearr_41108_41187[(2)] = inst_40995);

(statearr_41108_41187[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (22))){
var state_41088__$1 = state_41088;
var statearr_41109_41188 = state_41088__$1;
(statearr_41109_41188[(2)] = offset);

(statearr_41109_41188[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (36))){
var inst_41055 = (state_41088[(11)]);
var inst_41055__$1 = limit;
var state_41088__$1 = (function (){var statearr_41110 = state_41088;
(statearr_41110[(11)] = inst_41055__$1);

return statearr_41110;
})();
if(cljs.core.truth_(inst_41055__$1)){
var statearr_41111_41189 = state_41088__$1;
(statearr_41111_41189[(1)] = (39));

} else {
var statearr_41112_41190 = state_41088__$1;
(statearr_41112_41190[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (41))){
var inst_41059 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
var statearr_41113_41191 = state_41088__$1;
(statearr_41113_41191[(2)] = inst_41059);

(statearr_41113_41191[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (43))){
var inst_41052 = (state_41088[(15)]);
var state_41088__$1 = state_41088;
var statearr_41114_41192 = state_41088__$1;
(statearr_41114_41192[(2)] = inst_41052);

(statearr_41114_41192[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (29))){
var inst_41045 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
if(cljs.core.truth_(inst_41045)){
var statearr_41115_41193 = state_41088__$1;
(statearr_41115_41193[(1)] = (33));

} else {
var statearr_41116_41194 = state_41088__$1;
(statearr_41116_41194[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (44))){
var inst_41051 = (state_41088[(16)]);
var inst_41068 = (state_41088[(2)]);
var inst_41069 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_41070 = fluree.db.query.fql.format_filter_tuples(db,inst_41068,select_spec,inst_41051,vars,inst_41069);
var state_41088__$1 = state_41088;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41088__$1,(45),inst_41070);
} else {
if((state_val_41089 === (6))){
var inst_40987 = cljs.core.count(select);
var inst_40988 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_40987);
var state_41088__$1 = state_41088;
var statearr_41117_41195 = state_41088__$1;
(statearr_41117_41195[(2)] = inst_40988);

(statearr_41117_41195[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (28))){
var state_41088__$1 = state_41088;
var statearr_41118_41196 = state_41088__$1;
(statearr_41118_41196[(2)] = false);

(statearr_41118_41196[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (25))){
var inst_41020 = (state_41088[(8)]);
var state_41088__$1 = state_41088;
var statearr_41119_41197 = state_41088__$1;
(statearr_41119_41197[(2)] = inst_41020);

(statearr_41119_41197[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (34))){
var inst_41029 = (state_41088[(9)]);
var state_41088__$1 = state_41088;
var statearr_41120_41198 = state_41088__$1;
(statearr_41120_41198[(2)] = inst_41029);

(statearr_41120_41198[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (17))){
var inst_41013 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
var statearr_41121_41199 = state_41088__$1;
(statearr_41121_41199[(2)] = inst_41013);

(statearr_41121_41199[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (3))){
var inst_41086 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41088__$1,inst_41086);
} else {
if((state_val_41089 === (12))){
var inst_40995 = (state_41088[(14)]);
var inst_40997 = cljs.core.first(select);
var inst_40998 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_40997);
var inst_40999 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40998);
var inst_41000 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_40999,(1));
var inst_41001 = [inst_41000];
var inst_41002 = [inst_40995];
var inst_41003 = cljs.core.PersistentHashMap.fromArrays(inst_41001,inst_41002);
var state_41088__$1 = state_41088;
var statearr_41122_41200 = state_41088__$1;
(statearr_41122_41200[(2)] = inst_41003);

(statearr_41122_41200[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (2))){
var inst_40985 = (state_41088[(7)]);
var _ = (function (){var statearr_41123 = state_41088;
(statearr_41123[(4)] = cljs.core.cons((5),(state_41088[(4)])));

return statearr_41123;
})();
var inst_40985__$1 = aggregates;
var state_41088__$1 = (function (){var statearr_41124 = state_41088;
(statearr_41124[(7)] = inst_40985__$1);

return statearr_41124;
})();
if(cljs.core.truth_(inst_40985__$1)){
var statearr_41125_41201 = state_41088__$1;
(statearr_41125_41201[(1)] = (6));

} else {
var statearr_41126_41202 = state_41088__$1;
(statearr_41126_41202[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (23))){
var inst_41024 = (state_41088[(2)]);
var state_41088__$1 = (function (){var statearr_41127 = state_41088;
(statearr_41127[(10)] = inst_41024);

return statearr_41127;
})();
if(cljs.core.truth_(orderBy)){
var statearr_41128_41203 = state_41088__$1;
(statearr_41128_41203[(1)] = (24));

} else {
var statearr_41129_41204 = state_41088__$1;
(statearr_41129_41204[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (47))){
var inst_41073 = (state_41088[(12)]);
var state_41088__$1 = state_41088;
var statearr_41130_41205 = state_41088__$1;
(statearr_41130_41205[(2)] = inst_41073);

(statearr_41130_41205[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (35))){
var inst_41050 = (state_41088[(2)]);
var inst_41051 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41050,cljs.core.cst$kw$headers);
var inst_41052 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41050,cljs.core.cst$kw$tuples);
var inst_41053 = cljs.core.not(orderBy);
var state_41088__$1 = (function (){var statearr_41131 = state_41088;
(statearr_41131[(15)] = inst_41052);

(statearr_41131[(16)] = inst_41051);

return statearr_41131;
})();
if(inst_41053){
var statearr_41132_41206 = state_41088__$1;
(statearr_41132_41206[(1)] = (36));

} else {
var statearr_41133_41207 = state_41088__$1;
(statearr_41133_41207[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (19))){
var state_41088__$1 = state_41088;
var statearr_41134_41208 = state_41088__$1;
(statearr_41134_41208[(2)] = res);

(statearr_41134_41208[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (11))){
var inst_41083 = (state_41088[(2)]);
var _ = (function (){var statearr_41136 = state_41088;
(statearr_41136[(4)] = cljs.core.rest((state_41088[(4)])));

return statearr_41136;
})();
var state_41088__$1 = state_41088;
var statearr_41137_41209 = state_41088__$1;
(statearr_41137_41209[(2)] = inst_41083);

(statearr_41137_41209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (9))){
var inst_40993 = cljs.core.first(aggregates);
var inst_40994 = fluree.db.query.analytical.calculate_aggregate(res,inst_40993);
var inst_40995 = cljs.core.second(inst_40994);
var state_41088__$1 = (function (){var statearr_41138 = state_41088;
(statearr_41138[(14)] = inst_40995);

return statearr_41138;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_41139_41210 = state_41088__$1;
(statearr_41139_41210[(1)] = (12));

} else {
var statearr_41140_41211 = state_41088__$1;
(statearr_41140_41211[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (5))){
var _ = (function (){var statearr_41141 = state_41088;
(statearr_41141[(4)] = cljs.core.rest((state_41088[(4)])));

return statearr_41141;
})();
var state_41088__$1 = state_41088;
var ex41135 = (state_41088__$1[(2)]);
var statearr_41142_41212 = state_41088__$1;
(statearr_41142_41212[(5)] = ex41135);


if((ex41135 instanceof Error)){
var statearr_41143_41213 = state_41088__$1;
(statearr_41143_41213[(1)] = (4));

(statearr_41143_41213[(5)] = null);

} else {
throw ex41135;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (14))){
var inst_41006 = (state_41088[(2)]);
var state_41088__$1 = (function (){var statearr_41144 = state_41088;
(statearr_41144[(13)] = inst_41006);

return statearr_41144;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_41145_41214 = state_41088__$1;
(statearr_41145_41214[(1)] = (15));

} else {
var statearr_41146_41215 = state_41088__$1;
(statearr_41146_41215[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (45))){
var inst_41072 = (state_41088[(2)]);
var inst_41073 = fluree.db.util.async.throw_err(inst_41072);
var state_41088__$1 = (function (){var statearr_41147 = state_41088;
(statearr_41147[(12)] = inst_41073);

return statearr_41147;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_41148_41216 = state_41088__$1;
(statearr_41148_41216[(1)] = (46));

} else {
var statearr_41149_41217 = state_41088__$1;
(statearr_41149_41217[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (26))){
var inst_41029 = (state_41088[(9)]);
var inst_41029__$1 = (state_41088[(2)]);
var inst_41031 = (inst_41029__$1 == null);
var inst_41032 = cljs.core.not(inst_41031);
var state_41088__$1 = (function (){var statearr_41150 = state_41088;
(statearr_41150[(9)] = inst_41029__$1);

return statearr_41150;
})();
if(inst_41032){
var statearr_41151_41218 = state_41088__$1;
(statearr_41151_41218[(1)] = (27));

} else {
var statearr_41152_41219 = state_41088__$1;
(statearr_41152_41219[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (16))){
var inst_41006 = (state_41088[(13)]);
var state_41088__$1 = state_41088;
var statearr_41153_41220 = state_41088__$1;
(statearr_41153_41220[(2)] = inst_41006);

(statearr_41153_41220[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (38))){
var inst_41062 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
if(cljs.core.truth_(inst_41062)){
var statearr_41154_41221 = state_41088__$1;
(statearr_41154_41221[(1)] = (42));

} else {
var statearr_41155_41222 = state_41088__$1;
(statearr_41155_41222[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (30))){
var state_41088__$1 = state_41088;
var statearr_41156_41223 = state_41088__$1;
(statearr_41156_41223[(2)] = true);

(statearr_41156_41223[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (10))){
var state_41088__$1 = state_41088;
if(cljs.core.truth_(aggregates)){
var statearr_41157_41224 = state_41088__$1;
(statearr_41157_41224[(1)] = (18));

} else {
var statearr_41158_41225 = state_41088__$1;
(statearr_41158_41225[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (18))){
var inst_41017 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_41088__$1 = state_41088;
var statearr_41159_41226 = state_41088__$1;
(statearr_41159_41226[(2)] = inst_41017);

(statearr_41159_41226[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (42))){
var inst_41052 = (state_41088[(15)]);
var inst_41024 = (state_41088[(10)]);
var inst_41064 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_41024,inst_41052);
var inst_41065 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_41064);
var state_41088__$1 = state_41088;
var statearr_41160_41227 = state_41088__$1;
(statearr_41160_41227[(2)] = inst_41065);

(statearr_41160_41227[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (37))){
var state_41088__$1 = state_41088;
var statearr_41161_41228 = state_41088__$1;
(statearr_41161_41228[(2)] = false);

(statearr_41161_41228[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41089 === (8))){
var inst_40991 = (state_41088[(2)]);
var state_41088__$1 = state_41088;
if(cljs.core.truth_(inst_40991)){
var statearr_41162_41229 = state_41088__$1;
(statearr_41162_41229[(1)] = (9));

} else {
var statearr_41163_41230 = state_41088__$1;
(statearr_41163_41230[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16291__auto__ = null;
var fluree$db$query$fql$state_machine__16291__auto____0 = (function (){
var statearr_41164 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41164[(0)] = fluree$db$query$fql$state_machine__16291__auto__);

(statearr_41164[(1)] = (1));

return statearr_41164;
});
var fluree$db$query$fql$state_machine__16291__auto____1 = (function (state_41088){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_41088);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e41165){var ex__16294__auto__ = e41165;
var statearr_41166_41231 = state_41088;
(statearr_41166_41231[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_41088[(4)]))){
var statearr_41167_41232 = state_41088;
(statearr_41167_41232[(1)] = cljs.core.first((state_41088[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__41233 = state_41088;
state_41088 = G__41233;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16291__auto__ = function(state_41088){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16291__auto____1.call(this,state_41088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16291__auto____0;
fluree$db$query$fql$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16291__auto____1;
return fluree$db$query$fql$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_41168 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_41168[(6)] = c__16328__auto__);

return statearr_41168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__41236,groupBy){
var map__41237 = p__41236;
var map__41237__$1 = (((((!((map__41237 == null))))?(((((map__41237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41237):map__41237);
var res = map__41237__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41237__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41237__$1,cljs.core.cst$kw$tuples);
var vec__41239 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41239,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41239,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41234_SHARP_){
return fluree.db.util.core.index_of(headers,p1__41234_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41235_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__41235_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__41242,p__41243,opts){
var map__41244 = p__41242;
var map__41244__$1 = (((((!((map__41244 == null))))?(((((map__41244.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41244.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41244):map__41244);
var res = map__41244__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41244__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41244__$1,cljs.core.cst$kw$vars);
var map__41245 = p__41243;
var map__41245__$1 = (((((!((map__41245 == null))))?(((((map__41245.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41245.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41245):map__41245);
var select_spec = map__41245__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$offset);
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_41470){
var state_val_41471 = (state_41470[(1)]);
if((state_val_41471 === (65))){
var inst_41432 = (state_41470[(2)]);
var inst_41433 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_41432,opts);
var state_41470__$1 = state_41470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41470__$1,(66),inst_41433);
} else {
if((state_val_41471 === (70))){
var inst_41436 = (state_41470[(7)]);
var inst_41441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41442 = [inst_41436];
var inst_41443 = (new cljs.core.PersistentVector(null,1,(5),inst_41441,inst_41442,null));
var state_41470__$1 = state_41470;
var statearr_41472_41595 = state_41470__$1;
(statearr_41472_41595[(2)] = inst_41443);

(statearr_41472_41595[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (62))){
var inst_41425 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41473_41596 = state_41470__$1;
(statearr_41473_41596[(2)] = inst_41425);

(statearr_41473_41596[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (74))){
var state_41470__$1 = state_41470;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_41474_41597 = state_41470__$1;
(statearr_41474_41597[(1)] = (76));

} else {
var statearr_41475_41598 = state_41470__$1;
(statearr_41475_41598[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (7))){
var state_41470__$1 = state_41470;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41476_41599 = state_41470__$1;
(statearr_41476_41599[(1)] = (63));

} else {
var statearr_41477_41600 = state_41470__$1;
(statearr_41477_41600[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (59))){
var inst_41349 = (state_41470[(8)]);
var inst_41358 = (state_41470[(9)]);
var inst_41401 = (state_41470[(2)]);
var inst_41402 = fluree.db.util.async.throw_err(inst_41401);
var inst_41403 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41349,inst_41358,inst_41402);
var state_41470__$1 = state_41470;
var statearr_41478_41601 = state_41470__$1;
(statearr_41478_41601[(2)] = inst_41403);

(statearr_41478_41601[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (20))){
var inst_41302 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41479_41602 = state_41470__$1;
(statearr_41479_41602[(2)] = inst_41302);

(statearr_41479_41602[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (72))){
var inst_41446 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41480_41603 = state_41470__$1;
(statearr_41480_41603[(2)] = inst_41446);

(statearr_41480_41603[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (58))){
var inst_41406 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41481_41604 = state_41470__$1;
(statearr_41481_41604[(2)] = inst_41406);

(statearr_41481_41604[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (60))){
var inst_41419 = (state_41470[(10)]);
var inst_41304 = (state_41470[(11)]);
var inst_41421 = cljs.core.sorted_map_by(inst_41304);
var inst_41422 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41421,inst_41419);
var state_41470__$1 = state_41470;
var statearr_41482_41605 = state_41470__$1;
(statearr_41482_41605[(2)] = inst_41422);

(statearr_41482_41605[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (27))){
var inst_41286 = (state_41470[(12)]);
var inst_41285 = (state_41470[(13)]);
var inst_41255 = (state_41470[(14)]);
var inst_41289 = (function (){var group_map = inst_41255;
var orderByIdx = inst_41285;
var orderDirection = inst_41286;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
})();
var state_41470__$1 = state_41470;
var statearr_41483_41606 = state_41470__$1;
(statearr_41483_41606[(2)] = inst_41289);

(statearr_41483_41606[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (1))){
var state_41470__$1 = state_41470;
var statearr_41484_41607 = state_41470__$1;
(statearr_41484_41607[(2)] = null);

(statearr_41484_41607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (69))){
var inst_41463 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41485_41608 = state_41470__$1;
(statearr_41485_41608[(2)] = inst_41463);

(statearr_41485_41608[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (24))){
var inst_41286 = (state_41470[(12)]);
var inst_41284 = cljs.core.second(orderBy);
var inst_41285 = fluree.db.util.core.index_of(groupBy,inst_41284);
var inst_41286__$1 = cljs.core.first(orderBy);
var inst_41287 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",inst_41286__$1);
var state_41470__$1 = (function (){var statearr_41486 = state_41470;
(statearr_41486[(12)] = inst_41286__$1);

(statearr_41486[(13)] = inst_41285);

return statearr_41486;
})();
if(inst_41287){
var statearr_41487_41609 = state_41470__$1;
(statearr_41487_41609[(1)] = (27));

} else {
var statearr_41488_41610 = state_41470__$1;
(statearr_41488_41610[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (55))){
var inst_41349 = (state_41470[(8)]);
var inst_41358 = (state_41470[(9)]);
var inst_41390 = (state_41470[(2)]);
var inst_41391 = fluree.db.util.async.throw_err(inst_41390);
var inst_41392 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41349,inst_41358,inst_41391);
var state_41470__$1 = state_41470;
var statearr_41489_41611 = state_41470__$1;
(statearr_41489_41611[(2)] = inst_41392);

(statearr_41489_41611[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (39))){
var inst_41349 = (state_41470[(8)]);
var state_41470__$1 = state_41470;
var statearr_41490_41612 = state_41470__$1;
(statearr_41490_41612[(2)] = inst_41349);

(statearr_41490_41612[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (46))){
var state_41470__$1 = state_41470;
var statearr_41491_41613 = state_41470__$1;
(statearr_41491_41613[(2)] = null);

(statearr_41491_41613[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (4))){
var inst_41248 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41492_41614 = state_41470__$1;
(statearr_41492_41614[(2)] = inst_41248);

(statearr_41492_41614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (77))){
var state_41470__$1 = state_41470;
var statearr_41493_41615 = state_41470__$1;
(statearr_41493_41615[(1)] = (79));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (54))){
var inst_41408 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41495_41616 = state_41470__$1;
(statearr_41495_41616[(2)] = inst_41408);

(statearr_41495_41616[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (15))){
var inst_41255 = (state_41470[(14)]);
var inst_41267 = (function (){var group_map = inst_41255;
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
})();
var state_41470__$1 = state_41470;
var statearr_41496_41617 = state_41470__$1;
(statearr_41496_41617[(2)] = inst_41267);

(statearr_41496_41617[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (48))){
var inst_41376 = (state_41470[(15)]);
var inst_41379 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_41376,select_spec,opts);
var state_41470__$1 = state_41470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41470__$1,(51),inst_41379);
} else {
if((state_val_41471 === (50))){
var inst_41410 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41497_41618 = state_41470__$1;
(statearr_41497_41618[(2)] = inst_41410);

(statearr_41497_41618[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (75))){
var inst_41461 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41498_41619 = state_41470__$1;
(statearr_41498_41619[(2)] = inst_41461);

(statearr_41498_41619[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (21))){
var inst_41277 = cljs.core.set(groupBy);
var inst_41278 = cljs.core.second(orderBy);
var inst_41279 = (inst_41277.cljs$core$IFn$_invoke$arity$1 ? inst_41277.cljs$core$IFn$_invoke$arity$1(inst_41278) : inst_41277.call(null,inst_41278));
var state_41470__$1 = state_41470;
var statearr_41499_41620 = state_41470__$1;
(statearr_41499_41620[(2)] = inst_41279);

(statearr_41499_41620[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (31))){
var state_41470__$1 = state_41470;
var statearr_41500_41621 = state_41470__$1;
(statearr_41500_41621[(2)] = null);

(statearr_41500_41621[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (32))){
var inst_41298 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41501_41622 = state_41470__$1;
(statearr_41501_41622[(2)] = inst_41298);

(statearr_41501_41622[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (40))){
var inst_41348 = (state_41470[(16)]);
var inst_41366 = (inst_41348 > (0));
var state_41470__$1 = state_41470;
if(cljs.core.truth_(inst_41366)){
var statearr_41502_41623 = state_41470__$1;
(statearr_41502_41623[(1)] = (42));

} else {
var statearr_41503_41624 = state_41470__$1;
(statearr_41503_41624[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (56))){
var inst_41373 = (state_41470[(17)]);
var inst_41361 = (state_41470[(18)]);
var inst_41376 = (state_41470[(15)]);
var inst_41396 = cljs.core.count(inst_41361);
var inst_41397 = (inst_41373 - limit);
var inst_41398 = (inst_41396 - inst_41397);
var inst_41399 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_41376,select_spec,inst_41398,opts);
var state_41470__$1 = state_41470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41470__$1,(59),inst_41399);
} else {
if((state_val_41471 === (33))){
var inst_41255 = (state_41470[(14)]);
var inst_41306 = cljs.core.keys(inst_41255);
var inst_41307 = cljs.core.first(inst_41306);
var inst_41308 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_41309 = cljs.core.vals(inst_41255);
var inst_41310 = cljs.core.first(inst_41309);
var inst_41311 = [headers,vars,inst_41310];
var inst_41312 = cljs.core.PersistentHashMap.fromArrays(inst_41308,inst_41311);
var inst_41313 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_41312,select_spec,limit,opts);
var state_41470__$1 = (function (){var statearr_41504 = state_41470;
(statearr_41504[(19)] = inst_41307);

return statearr_41504;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41470__$1,(36),inst_41313);
} else {
if((state_val_41471 === (13))){
var inst_41272 = cljs.core.not(orderBy);
var state_41470__$1 = state_41470;
if(inst_41272){
var statearr_41505_41625 = state_41470__$1;
(statearr_41505_41625[(1)] = (18));

} else {
var statearr_41506_41626 = state_41470__$1;
(statearr_41506_41626[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (22))){
var inst_41275 = (state_41470[(20)]);
var state_41470__$1 = state_41470;
var statearr_41507_41627 = state_41470__$1;
(statearr_41507_41627[(2)] = inst_41275);

(statearr_41507_41627[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (36))){
var inst_41307 = (state_41470[(19)]);
var inst_41315 = (state_41470[(2)]);
var inst_41316 = fluree.db.util.async.throw_err(inst_41315);
var inst_41317 = [inst_41307];
var inst_41318 = [inst_41316];
var inst_41319 = cljs.core.PersistentHashMap.fromArrays(inst_41317,inst_41318);
var state_41470__$1 = state_41470;
var statearr_41508_41628 = state_41470__$1;
(statearr_41508_41628[(2)] = inst_41319);

(statearr_41508_41628[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (41))){
var inst_41417 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41509_41629 = state_41470__$1;
(statearr_41509_41629[(2)] = inst_41417);

(statearr_41509_41629[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (43))){
var state_41470__$1 = state_41470;
var statearr_41510_41630 = state_41470__$1;
(statearr_41510_41630[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (61))){
var inst_41419 = (state_41470[(10)]);
var state_41470__$1 = state_41470;
var statearr_41512_41631 = state_41470__$1;
(statearr_41512_41631[(2)] = inst_41419);

(statearr_41512_41631[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (29))){
var inst_41293 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41513_41632 = state_41470__$1;
(statearr_41513_41632[(2)] = inst_41293);

(statearr_41513_41632[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (44))){
var inst_41415 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41514_41633 = state_41470__$1;
(statearr_41514_41633[(2)] = inst_41415);

(statearr_41514_41633[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (6))){
var inst_41256 = (state_41470[(21)]);
var inst_41255 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var inst_41256__$1 = orderBy;
var state_41470__$1 = (function (){var statearr_41515 = state_41470;
(statearr_41515[(21)] = inst_41256__$1);

(statearr_41515[(14)] = inst_41255);

return statearr_41515;
})();
if(cljs.core.truth_(inst_41256__$1)){
var statearr_41516_41634 = state_41470__$1;
(statearr_41516_41634[(1)] = (9));

} else {
var statearr_41517_41635 = state_41470__$1;
(statearr_41517_41635[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (28))){
var inst_41286 = (state_41470[(12)]);
var inst_41285 = (state_41470[(13)]);
var inst_41255 = (state_41470[(14)]);
var inst_41291 = (function (){var group_map = inst_41255;
var orderByIdx = inst_41285;
var orderDirection = inst_41286;
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
})();
var state_41470__$1 = state_41470;
var statearr_41519_41636 = state_41470__$1;
(statearr_41519_41636[(2)] = inst_41291);

(statearr_41519_41636[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (64))){
var state_41470__$1 = state_41470;
var statearr_41520_41637 = state_41470__$1;
(statearr_41520_41637[(2)] = limit);

(statearr_41520_41637[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (51))){
var inst_41349 = (state_41470[(8)]);
var inst_41373 = (state_41470[(17)]);
var inst_41359 = (state_41470[(22)]);
var inst_41362 = (state_41470[(23)]);
var inst_41358 = (state_41470[(9)]);
var inst_41348 = (state_41470[(16)]);
var inst_41381 = (state_41470[(2)]);
var inst_41382 = fluree.db.util.async.throw_err(inst_41381);
var inst_41383 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41349,inst_41358,inst_41382);
var tmp41518 = inst_41348;
var inst_41345 = inst_41359;
var inst_41346 = inst_41362;
var inst_41347 = inst_41373;
var inst_41348__$1 = tmp41518;
var inst_41349__$1 = inst_41383;
var state_41470__$1 = (function (){var statearr_41521 = state_41470;
(statearr_41521[(8)] = inst_41349__$1);

(statearr_41521[(24)] = inst_41346);

(statearr_41521[(16)] = inst_41348__$1);

(statearr_41521[(25)] = inst_41347);

(statearr_41521[(26)] = inst_41345);

return statearr_41521;
})();
var statearr_41522_41638 = state_41470__$1;
(statearr_41522_41638[(2)] = null);

(statearr_41522_41638[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (25))){
var state_41470__$1 = state_41470;
var statearr_41523_41639 = state_41470__$1;
(statearr_41523_41639[(1)] = (30));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (34))){
var inst_41255 = (state_41470[(14)]);
var inst_41335 = cljs.core.keys(inst_41255);
var inst_41336 = cljs.core.seq(inst_41335);
var inst_41337 = cljs.core.first(inst_41336);
var inst_41338 = cljs.core.next(inst_41336);
var inst_41339 = cljs.core.vals(inst_41255);
var inst_41340 = cljs.core.seq(inst_41339);
var inst_41341 = cljs.core.first(inst_41340);
var inst_41342 = cljs.core.next(inst_41340);
var inst_41343 = offset;
var inst_41344 = cljs.core.PersistentHashMap.EMPTY;
var inst_41345 = inst_41335;
var inst_41346 = inst_41339;
var inst_41347 = (0);
var inst_41348 = inst_41343;
var inst_41349 = inst_41344;
var state_41470__$1 = (function (){var statearr_41525 = state_41470;
(statearr_41525[(8)] = inst_41349);

(statearr_41525[(27)] = inst_41338);

(statearr_41525[(28)] = inst_41341);

(statearr_41525[(24)] = inst_41346);

(statearr_41525[(16)] = inst_41348);

(statearr_41525[(25)] = inst_41347);

(statearr_41525[(29)] = inst_41337);

(statearr_41525[(26)] = inst_41345);

(statearr_41525[(30)] = inst_41342);

return statearr_41525;
})();
var statearr_41526_41640 = state_41470__$1;
(statearr_41526_41640[(2)] = null);

(statearr_41526_41640[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (17))){
var inst_41270 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41527_41641 = state_41470__$1;
(statearr_41527_41641[(2)] = inst_41270);

(statearr_41527_41641[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (3))){
var inst_41468 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41470__$1,inst_41468);
} else {
if((state_val_41471 === (12))){
var inst_41264 = cljs.core.first(orderBy);
var inst_41265 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41264,"DESC");
var state_41470__$1 = state_41470;
if(inst_41265){
var statearr_41528_41642 = state_41470__$1;
(statearr_41528_41642[(1)] = (15));

} else {
var statearr_41529_41643 = state_41470__$1;
(statearr_41529_41643[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (2))){
var _ = (function (){var statearr_41530 = state_41470;
(statearr_41530[(4)] = cljs.core.cons((5),(state_41470[(4)])));

return statearr_41530;
})();
var state_41470__$1 = state_41470;
if(cljs.core.truth_(groupBy)){
var statearr_41531_41644 = state_41470__$1;
(statearr_41531_41644[(1)] = (6));

} else {
var statearr_41532_41645 = state_41470__$1;
(statearr_41532_41645[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (66))){
var inst_41436 = (state_41470[(7)]);
var inst_41435 = (state_41470[(2)]);
var inst_41436__$1 = fluree.db.util.async.throw_err(inst_41435);
var inst_41437 = cljs.core.coll_QMARK_(inst_41436__$1);
var inst_41438 = (!(inst_41437));
var state_41470__$1 = (function (){var statearr_41533 = state_41470;
(statearr_41533[(7)] = inst_41436__$1);

return statearr_41533;
})();
if(inst_41438){
var statearr_41534_41646 = state_41470__$1;
(statearr_41534_41646[(1)] = (67));

} else {
var statearr_41535_41647 = state_41470__$1;
(statearr_41535_41647[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (23))){
var inst_41282 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
if(cljs.core.truth_(inst_41282)){
var statearr_41536_41648 = state_41470__$1;
(statearr_41536_41648[(1)] = (24));

} else {
var statearr_41537_41649 = state_41470__$1;
(statearr_41537_41649[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (47))){
var inst_41413 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41538_41650 = state_41470__$1;
(statearr_41538_41650[(2)] = inst_41413);

(statearr_41538_41650[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (35))){
var inst_41427 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41539_41651 = state_41470__$1;
(statearr_41539_41651[(2)] = inst_41427);

(statearr_41539_41651[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (76))){
var inst_41436 = (state_41470[(7)]);
var inst_41452 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_41436);
var state_41470__$1 = state_41470;
var statearr_41540_41652 = state_41470__$1;
(statearr_41540_41652[(2)] = inst_41452);

(statearr_41540_41652[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (19))){
var inst_41275 = (state_41470[(20)]);
var inst_41275__$1 = orderBy;
var state_41470__$1 = (function (){var statearr_41541 = state_41470;
(statearr_41541[(20)] = inst_41275__$1);

return statearr_41541;
})();
if(cljs.core.truth_(inst_41275__$1)){
var statearr_41542_41653 = state_41470__$1;
(statearr_41542_41653[(1)] = (21));

} else {
var statearr_41543_41654 = state_41470__$1;
(statearr_41543_41654[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (57))){
var state_41470__$1 = state_41470;
var statearr_41544_41655 = state_41470__$1;
(statearr_41544_41655[(2)] = null);

(statearr_41544_41655[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (68))){
var state_41470__$1 = state_41470;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41545_41656 = state_41470__$1;
(statearr_41545_41656[(1)] = (73));

} else {
var statearr_41546_41657 = state_41470__$1;
(statearr_41546_41657[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (11))){
var inst_41262 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
if(cljs.core.truth_(inst_41262)){
var statearr_41548_41658 = state_41470__$1;
(statearr_41548_41658[(1)] = (12));

} else {
var statearr_41549_41659 = state_41470__$1;
(statearr_41549_41659[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (9))){
var inst_41258 = cljs.core.second(orderBy);
var inst_41259 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41258,groupBy);
var state_41470__$1 = state_41470;
var statearr_41550_41660 = state_41470__$1;
(statearr_41550_41660[(2)] = inst_41259);

(statearr_41550_41660[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (5))){
var _ = (function (){var statearr_41551 = state_41470;
(statearr_41551[(4)] = cljs.core.rest((state_41470[(4)])));

return statearr_41551;
})();
var state_41470__$1 = state_41470;
var ex41547 = (state_41470__$1[(2)]);
var statearr_41552_41661 = state_41470__$1;
(statearr_41552_41661[(5)] = ex41547);


if((ex41547 instanceof Error)){
var statearr_41553_41662 = state_41470__$1;
(statearr_41553_41662[(1)] = (4));

(statearr_41553_41662[(5)] = null);

} else {
throw ex41547;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (14))){
var inst_41304 = (state_41470[(2)]);
var state_41470__$1 = (function (){var statearr_41554 = state_41470;
(statearr_41554[(11)] = inst_41304);

return statearr_41554;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41555_41663 = state_41470__$1;
(statearr_41555_41663[(1)] = (33));

} else {
var statearr_41556_41664 = state_41470__$1;
(statearr_41556_41664[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (45))){
var inst_41373 = (state_41470[(17)]);
var inst_41361 = (state_41470[(18)]);
var inst_41347 = (state_41470[(25)]);
var inst_41372 = cljs.core.count(inst_41361);
var inst_41373__$1 = (inst_41347 + inst_41372);
var inst_41374 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_41375 = [headers,vars,inst_41361];
var inst_41376 = cljs.core.PersistentHashMap.fromArrays(inst_41374,inst_41375);
var inst_41377 = (limit > inst_41373__$1);
var state_41470__$1 = (function (){var statearr_41557 = state_41470;
(statearr_41557[(17)] = inst_41373__$1);

(statearr_41557[(15)] = inst_41376);

return statearr_41557;
})();
if(cljs.core.truth_(inst_41377)){
var statearr_41558_41665 = state_41470__$1;
(statearr_41558_41665[(1)] = (48));

} else {
var statearr_41559_41666 = state_41470__$1;
(statearr_41559_41666[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (53))){
var inst_41373 = (state_41470[(17)]);
var inst_41394 = (limit < inst_41373);
var state_41470__$1 = state_41470;
if(cljs.core.truth_(inst_41394)){
var statearr_41560_41667 = state_41470__$1;
(statearr_41560_41667[(1)] = (56));

} else {
var statearr_41561_41668 = state_41470__$1;
(statearr_41561_41668[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (78))){
var inst_41459 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41562_41669 = state_41470__$1;
(statearr_41562_41669[(2)] = inst_41459);

(statearr_41562_41669[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (26))){
var inst_41300 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41563_41670 = state_41470__$1;
(statearr_41563_41670[(2)] = inst_41300);

(statearr_41563_41670[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (16))){
var state_41470__$1 = state_41470;
var statearr_41564_41671 = state_41470__$1;
(statearr_41564_41671[(2)] = fluree.db.query.fql.compare_fn);

(statearr_41564_41671[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (81))){
var inst_41457 = (state_41470[(2)]);
var state_41470__$1 = state_41470;
var statearr_41565_41672 = state_41470__$1;
(statearr_41565_41672[(2)] = inst_41457);

(statearr_41565_41672[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (79))){
var inst_41436 = (state_41470[(7)]);
var state_41470__$1 = state_41470;
var statearr_41566_41673 = state_41470__$1;
(statearr_41566_41673[(2)] = inst_41436);

(statearr_41566_41673[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (38))){
var inst_41304 = (state_41470[(11)]);
var inst_41419 = (state_41470[(2)]);
var state_41470__$1 = (function (){var statearr_41567 = state_41470;
(statearr_41567[(10)] = inst_41419);

return statearr_41567;
})();
if(cljs.core.truth_(inst_41304)){
var statearr_41568_41674 = state_41470__$1;
(statearr_41568_41674[(1)] = (60));

} else {
var statearr_41569_41675 = state_41470__$1;
(statearr_41569_41675[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (30))){
var state_41470__$1 = state_41470;
var statearr_41570_41676 = state_41470__$1;
(statearr_41570_41676[(2)] = null);

(statearr_41570_41676[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (73))){
var inst_41436 = (state_41470[(7)]);
var inst_41449 = cljs.core.first(inst_41436);
var state_41470__$1 = state_41470;
var statearr_41571_41677 = state_41470__$1;
(statearr_41571_41677[(2)] = inst_41449);

(statearr_41571_41677[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (10))){
var inst_41256 = (state_41470[(21)]);
var state_41470__$1 = state_41470;
var statearr_41572_41678 = state_41470__$1;
(statearr_41572_41678[(2)] = inst_41256);

(statearr_41572_41678[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (18))){
var state_41470__$1 = state_41470;
var statearr_41573_41679 = state_41470__$1;
(statearr_41573_41679[(2)] = null);

(statearr_41573_41679[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (52))){
var inst_41376 = (state_41470[(15)]);
var inst_41388 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_41376,select_spec,opts);
var state_41470__$1 = state_41470;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41470__$1,(55),inst_41388);
} else {
if((state_val_41471 === (67))){
var state_41470__$1 = state_41470;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_41576_41680 = state_41470__$1;
(statearr_41576_41680[(1)] = (70));

} else {
var statearr_41577_41681 = state_41470__$1;
(statearr_41577_41681[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (71))){
var inst_41436 = (state_41470[(7)]);
var state_41470__$1 = state_41470;
var statearr_41578_41682 = state_41470__$1;
(statearr_41578_41682[(2)] = inst_41436);

(statearr_41578_41682[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (42))){
var inst_41349 = (state_41470[(8)]);
var inst_41359 = (state_41470[(22)]);
var inst_41362 = (state_41470[(23)]);
var inst_41348 = (state_41470[(16)]);
var inst_41347 = (state_41470[(25)]);
var inst_41368 = (inst_41348 - (1));
var tmp41574 = inst_41349;
var tmp41575 = inst_41347;
var inst_41345 = inst_41359;
var inst_41346 = inst_41362;
var inst_41347__$1 = tmp41575;
var inst_41348__$1 = inst_41368;
var inst_41349__$1 = tmp41574;
var state_41470__$1 = (function (){var statearr_41579 = state_41470;
(statearr_41579[(8)] = inst_41349__$1);

(statearr_41579[(24)] = inst_41346);

(statearr_41579[(16)] = inst_41348__$1);

(statearr_41579[(25)] = inst_41347__$1);

(statearr_41579[(26)] = inst_41345);

return statearr_41579;
})();
var statearr_41580_41683 = state_41470__$1;
(statearr_41580_41683[(2)] = null);

(statearr_41580_41683[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (80))){
var state_41470__$1 = state_41470;
var statearr_41581_41684 = state_41470__$1;
(statearr_41581_41684[(2)] = null);

(statearr_41581_41684[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (37))){
var inst_41361 = (state_41470[(18)]);
var inst_41346 = (state_41470[(24)]);
var inst_41345 = (state_41470[(26)]);
var inst_41357 = cljs.core.seq(inst_41345);
var inst_41358 = cljs.core.first(inst_41357);
var inst_41359 = cljs.core.next(inst_41357);
var inst_41360 = cljs.core.seq(inst_41346);
var inst_41361__$1 = cljs.core.first(inst_41360);
var inst_41362 = cljs.core.next(inst_41360);
var inst_41363 = (inst_41361__$1 == null);
var state_41470__$1 = (function (){var statearr_41582 = state_41470;
(statearr_41582[(22)] = inst_41359);

(statearr_41582[(23)] = inst_41362);

(statearr_41582[(9)] = inst_41358);

(statearr_41582[(18)] = inst_41361__$1);

return statearr_41582;
})();
if(cljs.core.truth_(inst_41363)){
var statearr_41583_41685 = state_41470__$1;
(statearr_41583_41685[(1)] = (39));

} else {
var statearr_41584_41686 = state_41470__$1;
(statearr_41584_41686[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (63))){
var state_41470__$1 = state_41470;
var statearr_41585_41687 = state_41470__$1;
(statearr_41585_41687[(2)] = (1));

(statearr_41585_41687[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (8))){
var inst_41465 = (state_41470[(2)]);
var _ = (function (){var statearr_41586 = state_41470;
(statearr_41586[(4)] = cljs.core.rest((state_41470[(4)])));

return statearr_41586;
})();
var state_41470__$1 = state_41470;
var statearr_41587_41688 = state_41470__$1;
(statearr_41587_41688[(2)] = inst_41465);

(statearr_41587_41688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41471 === (49))){
var inst_41373 = (state_41470[(17)]);
var inst_41386 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(limit,inst_41373);
var state_41470__$1 = state_41470;
if(inst_41386){
var statearr_41588_41689 = state_41470__$1;
(statearr_41588_41689[(1)] = (52));

} else {
var statearr_41589_41690 = state_41470__$1;
(statearr_41589_41690[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____0 = (function (){
var statearr_41590 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41590[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__);

(statearr_41590[(1)] = (1));

return statearr_41590;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____1 = (function (state_41470){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_41470);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e41591){var ex__16294__auto__ = e41591;
var statearr_41592_41691 = state_41470;
(statearr_41592_41691[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_41470[(4)]))){
var statearr_41593_41692 = state_41470;
(statearr_41593_41692[(1)] = cljs.core.first((state_41470[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__41693 = state_41470;
state_41470 = G__41693;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__ = function(state_41470){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____1.call(this,state_41470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_41594 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_41594[(6)] = c__16328__auto__);

return statearr_41594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__41696,opts){
var map__41697 = p__41696;
var map__41697__$1 = (((((!((map__41697 == null))))?(((((map__41697.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41697.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41697):map__41697);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41697__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41697__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41697__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41697__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41694_SHARP_){
return cljs.core.contains_QMARK_(p1__41694_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__41695_SHARP_){
return cljs.core.contains_QMARK_(p1__41695_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__41706 = cljs.core.first(orderBy);
var fexpr__41705 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__41705.cljs$core$IFn$_invoke$arity$1 ? fexpr__41705.cljs$core$IFn$_invoke$arity$1(G__41706) : fexpr__41705.call(null,G__41706));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must by variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__41707,p__41708){
var map__41709 = p__41707;
var map__41709__$1 = (((((!((map__41709 == null))))?(((((map__41709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41709.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41709):map__41709);
var query_map = map__41709__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41709__$1,cljs.core.cst$kw$construct);
var map__41710 = p__41708;
var map__41710__$1 = (((((!((map__41710 == null))))?(((((map__41710.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41710.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41710):map__41710);
var where_result = map__41710__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41710__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41710__$1,cljs.core.cst$kw$tuples);
var vec__41713 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41713,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41713,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41713,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_41746){
var state_val_41747 = (state_41746[(1)]);
if((state_val_41747 === (7))){
var inst_41725 = (state_41746[(7)]);
var state_41746__$1 = state_41746;
var statearr_41748_41771 = state_41746__$1;
(statearr_41748_41771[(2)] = inst_41725);

(statearr_41748_41771[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (1))){
var state_41746__$1 = state_41746;
var statearr_41749_41772 = state_41746__$1;
(statearr_41749_41772[(2)] = null);

(statearr_41749_41772[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (4))){
var inst_41716 = (state_41746[(2)]);
var state_41746__$1 = state_41746;
var statearr_41750_41773 = state_41746__$1;
(statearr_41750_41773[(2)] = inst_41716);

(statearr_41750_41773[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (13))){
var inst_41735 = (state_41746[(2)]);
var inst_41736 = fluree.db.util.async.throw_err(inst_41735);
var state_41746__$1 = state_41746;
var statearr_41751_41774 = state_41746__$1;
(statearr_41751_41774[(2)] = inst_41736);

(statearr_41751_41774[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (6))){
var inst_41725 = (state_41746[(7)]);
var inst_41724 = (state_41746[(2)]);
var inst_41725__$1 = fluree.db.util.async.throw_err(inst_41724);
var inst_41726 = fluree.db.util.core.exception_QMARK_(inst_41725__$1);
var state_41746__$1 = (function (){var statearr_41752 = state_41746;
(statearr_41752[(7)] = inst_41725__$1);

return statearr_41752;
})();
if(inst_41726){
var statearr_41753_41775 = state_41746__$1;
(statearr_41753_41775[(1)] = (7));

} else {
var statearr_41754_41776 = state_41746__$1;
(statearr_41754_41776[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (3))){
var inst_41744 = (state_41746[(2)]);
var state_41746__$1 = state_41746;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41746__$1,inst_41744);
} else {
if((state_val_41747 === (12))){
var inst_41739 = (state_41746[(2)]);
var state_41746__$1 = state_41746;
var statearr_41755_41777 = state_41746__$1;
(statearr_41755_41777[(2)] = inst_41739);

(statearr_41755_41777[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (2))){
var _ = (function (){var statearr_41756 = state_41746;
(statearr_41756[(4)] = cljs.core.cons((5),(state_41746[(4)])));

return statearr_41756;
})();
var inst_41722 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_41746__$1 = state_41746;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41746__$1,(6),inst_41722);
} else {
if((state_val_41747 === (11))){
var state_41746__$1 = state_41746;
var statearr_41758_41778 = state_41746__$1;
(statearr_41758_41778[(2)] = null);

(statearr_41758_41778[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (9))){
var inst_41741 = (state_41746[(2)]);
var _ = (function (){var statearr_41759 = state_41746;
(statearr_41759[(4)] = cljs.core.rest((state_41746[(4)])));

return statearr_41759;
})();
var state_41746__$1 = state_41746;
var statearr_41760_41779 = state_41746__$1;
(statearr_41760_41779[(2)] = inst_41741);

(statearr_41760_41779[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (5))){
var _ = (function (){var statearr_41761 = state_41746;
(statearr_41761[(4)] = cljs.core.rest((state_41746[(4)])));

return statearr_41761;
})();
var state_41746__$1 = state_41746;
var ex41757 = (state_41746__$1[(2)]);
var statearr_41762_41780 = state_41746__$1;
(statearr_41762_41780[(5)] = ex41757);


if((ex41757 instanceof Error)){
var statearr_41763_41781 = state_41746__$1;
(statearr_41763_41781[(1)] = (4));

(statearr_41763_41781[(5)] = null);

} else {
throw ex41757;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41747 === (10))){
var inst_41725 = (state_41746[(7)]);
var inst_41730 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_41725);
var inst_41731 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_41725);
var inst_41732 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_41730,inst_41731,query_map,opts);
var inst_41733 = fluree.db.query.fql.process_ad_hoc_res(db,inst_41725,inst_41732,opts);
var state_41746__$1 = state_41746;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41746__$1,(13),inst_41733);
} else {
if((state_val_41747 === (8))){
var state_41746__$1 = state_41746;
var statearr_41764_41782 = state_41746__$1;
(statearr_41764_41782[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____0 = (function (){
var statearr_41766 = [null,null,null,null,null,null,null,null];
(statearr_41766[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__);

(statearr_41766[(1)] = (1));

return statearr_41766;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____1 = (function (state_41746){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_41746);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e41767){var ex__16294__auto__ = e41767;
var statearr_41768_41783 = state_41746;
(statearr_41768_41783[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_41746[(4)]))){
var statearr_41769_41784 = state_41746;
(statearr_41769_41784[(1)] = cljs.core.first((state_41746[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__41785 = state_41746;
state_41746 = G__41785;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__ = function(state_41746){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____1.call(this,state_41746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_41770 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_41770[(6)] = c__16328__auto__);

return statearr_41770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__41786 = query_map;
var map__41786__$1 = (((((!((map__41786 == null))))?(((((map__41786.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__41786.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__41786):map__41786);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41786__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__41788 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41788,cljs.core.cst$kw$limit,(1));
} else {
return G__41788;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_42159){
var state_val_42160 = (state_42159[(1)]);
if((state_val_42160 === (121))){
var inst_42100 = (state_42159[(7)]);
var inst_41872 = (state_42159[(8)]);
var inst_41870 = (state_42159[(9)]);
var inst_42104 = (state_42159[(10)]);
var inst_42108 = (state_42159[(2)]);
var inst_42109 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41872,fuel,max_fuel,inst_41870,inst_42100,inst_42104,inst_42108);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(115),inst_42109);
} else {
if((state_val_42160 === (65))){
var inst_41860 = (state_42159[(11)]);
var inst_41872 = (state_42159[(8)]);
var inst_41949 = (state_42159[(12)]);
var inst_41870 = (state_42159[(9)]);
var inst_41963 = (state_42159[(2)]);
var inst_41964 = fluree.db.util.async.throw_err(inst_41963);
var inst_41965 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_41949,inst_41964);
var inst_41966 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_41872,fuel,max_fuel,inst_41870,inst_41965,inst_41860);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(66),inst_41966);
} else {
if((state_val_42160 === (70))){
var inst_41859 = (state_42159[(13)]);
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41859)){
var statearr_42161_42353 = state_42159__$1;
(statearr_42161_42353[(1)] = (73));

} else {
var statearr_42162_42354 = state_42159__$1;
(statearr_42162_42354[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (62))){
var inst_41951 = cljs.core.PersistentHashMap.EMPTY;
var state_42159__$1 = state_42159;
var statearr_42163_42355 = state_42159__$1;
(statearr_42163_42355[(2)] = inst_41951);

(statearr_42163_42355[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (74))){
var inst_41860 = (state_42159[(11)]);
var inst_41862 = (state_42159[(14)]);
var inst_41985 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41986 = [inst_41860,inst_41862];
var inst_41987 = cljs.core.PersistentHashMap.fromArrays(inst_41985,inst_41986);
var state_42159__$1 = state_42159;
var statearr_42164_42356 = state_42159__$1;
(statearr_42164_42356[(2)] = inst_41987);

(statearr_42164_42356[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (110))){
var inst_42068 = (state_42159[(15)]);
var inst_42082 = (state_42159[(2)]);
var inst_42083 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_42068,false);
var state_42159__$1 = (function (){var statearr_42165 = state_42159;
(statearr_42165[(16)] = inst_42082);

return statearr_42165;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(111),inst_42083);
} else {
if((state_val_42160 === (130))){
var inst_42149 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_42149)){
var statearr_42166_42357 = state_42159__$1;
(statearr_42166_42357[(1)] = (131));

} else {
var statearr_42167_42358 = state_42159__$1;
(statearr_42167_42358[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (128))){
var inst_42140 = (state_42159[(17)]);
var inst_42143 = cljs.core.coll_QMARK_(inst_42140);
var inst_42144 = fluree.db.util.core.exception_QMARK_(inst_42140);
var inst_42145 = (!(inst_42144));
var inst_42146 = ((inst_42143) && (inst_42145));
var state_42159__$1 = state_42159;
var statearr_42168_42359 = state_42159__$1;
(statearr_42168_42359[(2)] = inst_42146);

(statearr_42168_42359[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (7))){
var inst_41820 = (state_42159[(18)]);
var inst_41820__$1 = selectOne;
var state_42159__$1 = (function (){var statearr_42169 = state_42159;
(statearr_42169[(18)] = inst_41820__$1);

return statearr_42169;
})();
if(cljs.core.truth_(inst_41820__$1)){
var statearr_42170_42360 = state_42159__$1;
(statearr_42170_42360[(1)] = (9));

} else {
var statearr_42171_42361 = state_42159__$1;
(statearr_42171_42361[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (59))){
var inst_41943 = (state_42159[(19)]);
var inst_41945 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_41946 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41943,inst_41945);
var state_42159__$1 = state_42159;
var statearr_42172_42362 = state_42159__$1;
(statearr_42172_42362[(2)] = inst_41946);

(statearr_42172_42362[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (86))){
var inst_42021 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(89),inst_42021);
} else {
if((state_val_42160 === (20))){
var inst_41850 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42173_42363 = state_42159__$1;
(statearr_42173_42363[(2)] = inst_41850);

(statearr_42173_42363[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (72))){
var inst_42131 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42174_42364 = state_42159__$1;
(statearr_42174_42364[(2)] = inst_42131);

(statearr_42174_42364[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (58))){
var inst_41943 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42175 = state_42159;
(statearr_42175[(19)] = inst_41943);

return statearr_42175;
})();
var statearr_42176_42365 = state_42159__$1;
(statearr_42176_42365[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (60))){
var inst_41943 = (state_42159[(19)]);
var state_42159__$1 = state_42159;
var statearr_42178_42366 = state_42159__$1;
(statearr_42178_42366[(2)] = inst_41943);

(statearr_42178_42366[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (27))){
var inst_41859 = (state_42159[(13)]);
var inst_41874 = cljs.core.vector_QMARK_(inst_41859);
var state_42159__$1 = state_42159;
if(inst_41874){
var statearr_42179_42367 = state_42159__$1;
(statearr_42179_42367[(1)] = (30));

} else {
var statearr_42180_42368 = state_42159__$1;
(statearr_42180_42368[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (1))){
var state_42159__$1 = state_42159;
var statearr_42181_42369 = state_42159__$1;
(statearr_42181_42369[(2)] = null);

(statearr_42181_42369[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (69))){
var inst_41980 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41980)){
var statearr_42182_42370 = state_42159__$1;
(statearr_42182_42370[(1)] = (70));

} else {
var statearr_42183_42371 = state_42159__$1;
(statearr_42183_42371[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (101))){
var inst_41859 = (state_42159[(13)]);
var inst_42098 = (state_42159[(2)]);
var inst_42099 = cljs.core.PersistentVector.EMPTY;
var inst_42100 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42099,inst_42098);
var state_42159__$1 = (function (){var statearr_42184 = state_42159;
(statearr_42184[(7)] = inst_42100);

return statearr_42184;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42185_42372 = state_42159__$1;
(statearr_42185_42372[(1)] = (116));

} else {
var statearr_42186_42373 = state_42159__$1;
(statearr_42186_42373[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (24))){
var inst_41863 = (state_42159[(20)]);
var inst_41861 = (state_42159[(21)]);
var inst_41867 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41863,cljs.core.cst$kw$componentFollow_QMARK_,inst_41861);
var state_42159__$1 = state_42159;
var statearr_42187_42374 = state_42159__$1;
(statearr_42187_42374[(2)] = inst_41867);

(statearr_42187_42374[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (102))){
var inst_42062 = (state_42159[(22)]);
var state_42159__$1 = state_42159;
var statearr_42188_42375 = state_42159__$1;
(statearr_42188_42375[(2)] = inst_42062);

(statearr_42188_42375[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (55))){
var inst_42133 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42189_42376 = state_42159__$1;
(statearr_42189_42376[(2)] = inst_42133);

(statearr_42189_42376[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (85))){
var inst_42015 = (state_42159[(2)]);
var inst_42016 = fluree.db.util.async.throw_err(inst_42015);
var state_42159__$1 = state_42159;
var statearr_42190_42377 = state_42159__$1;
(statearr_42190_42377[(2)] = inst_42016);

(statearr_42190_42377[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (39))){
var inst_41909 = typeof from === 'string';
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41909)){
var statearr_42191_42378 = state_42159__$1;
(statearr_42191_42378[(1)] = (42));

} else {
var statearr_42192_42379 = state_42159__$1;
(statearr_42192_42379[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (88))){
var inst_42127 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42193_42380 = state_42159__$1;
(statearr_42193_42380[(2)] = inst_42127);

(statearr_42193_42380[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (46))){
var inst_41928 = (state_42159[(2)]);
var inst_41929 = fluree.db.util.async.throw_err(inst_41928);
var state_42159__$1 = state_42159;
var statearr_42194_42381 = state_42159__$1;
(statearr_42194_42381[(2)] = inst_41929);

(statearr_42194_42381[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (4))){
var inst_41807 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42195_42382 = state_42159__$1;
(statearr_42195_42382[(2)] = inst_41807);

(statearr_42195_42382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (77))){
var inst_41996 = (state_42159[(2)]);
var inst_41997 = fluree.db.util.async.throw_err(inst_41996);
var state_42159__$1 = state_42159;
var statearr_42196_42383 = state_42159__$1;
(statearr_42196_42383[(2)] = inst_41997);

(statearr_42196_42383[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (106))){
var state_42159__$1 = state_42159;
if(cljs.core.truth_(fuel)){
var statearr_42197_42384 = state_42159__$1;
(statearr_42197_42384[(1)] = (108));

} else {
var statearr_42198_42385 = state_42159__$1;
(statearr_42198_42385[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (119))){
var state_42159__$1 = state_42159;
var statearr_42199_42386 = state_42159__$1;
(statearr_42199_42386[(2)] = null);

(statearr_42199_42386[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (95))){
var state_42159__$1 = state_42159;
var statearr_42200_42387 = state_42159__$1;
(statearr_42200_42387[(2)] = null);

(statearr_42200_42387[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (54))){
var inst_41972 = typeof from === 'string';
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41972)){
var statearr_42201_42388 = state_42159__$1;
(statearr_42201_42388[(1)] = (67));

} else {
var statearr_42202_42389 = state_42159__$1;
(statearr_42202_42389[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (92))){
var inst_41860 = (state_42159[(11)]);
var inst_41862 = (state_42159[(14)]);
var inst_41872 = (state_42159[(8)]);
var inst_41870 = (state_42159[(9)]);
var inst_42032 = (state_42159[(2)]);
var inst_42033 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41872,fuel,max_fuel,inst_41870,inst_42032,inst_41860,inst_41862);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(93),inst_42033);
} else {
if((state_val_42160 === (104))){
var inst_42096 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42203_42390 = state_42159__$1;
(statearr_42203_42390[(2)] = inst_42096);

(statearr_42203_42390[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (15))){
var inst_41837 = (state_42159[(23)]);
var inst_41842 = inst_41837.cljs$lang$protocol_mask$partition0$;
var inst_41843 = (inst_41842 & (64));
var inst_41844 = inst_41837.cljs$core$ISeq$;
var inst_41845 = (cljs.core.PROTOCOL_SENTINEL === inst_41844);
var inst_41846 = ((inst_41843) || (inst_41845));
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41846)){
var statearr_42204_42391 = state_42159__$1;
(statearr_42204_42391[(1)] = (18));

} else {
var statearr_42205_42392 = state_42159__$1;
(statearr_42205_42392[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (48))){
var inst_41860 = (state_42159[(11)]);
var state_42159__$1 = state_42159;
var statearr_42206_42393 = state_42159__$1;
(statearr_42206_42393[(2)] = inst_41860);

(statearr_42206_42393[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (50))){
var state_42159__$1 = state_42159;
var statearr_42207_42394 = state_42159__$1;
(statearr_42207_42394[(2)] = null);

(statearr_42207_42394[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (116))){
var state_42159__$1 = state_42159;
var statearr_42208_42395 = state_42159__$1;
(statearr_42208_42395[(2)] = null);

(statearr_42208_42395[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (75))){
var inst_41989 = (state_42159[(2)]);
var inst_41990 = fluree.db.query.range._block_or_tx_collection(db,inst_41989);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(76),inst_41990);
} else {
if((state_val_42160 === (99))){
var inst_42125 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42209_42396 = state_42159__$1;
(statearr_42209_42396[(2)] = inst_42125);

(statearr_42209_42396[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (21))){
var inst_41837 = (state_42159[(23)]);
var inst_41855 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_41837);
var state_42159__$1 = state_42159;
var statearr_42210_42397 = state_42159__$1;
(statearr_42210_42397[(2)] = inst_41855);

(statearr_42210_42397[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (31))){
var inst_41859 = (state_42159[(13)]);
var inst_41882 = typeof inst_41859 === 'string';
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41882)){
var statearr_42211_42398 = state_42159__$1;
(statearr_42211_42398[(1)] = (33));

} else {
var statearr_42212_42399 = state_42159__$1;
(statearr_42212_42399[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (113))){
var inst_42062 = (state_42159[(22)]);
var state_42159__$1 = state_42159;
var statearr_42213_42400 = state_42159__$1;
(statearr_42213_42400[(2)] = inst_42062);

(statearr_42213_42400[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (32))){
var inst_41898 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42214_42401 = state_42159__$1;
(statearr_42214_42401[(2)] = inst_41898);

(statearr_42214_42401[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (40))){
var inst_41931 = typeof from === 'string';
var inst_41932 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_41933 = clojure.string.includes_QMARK_(inst_41932,"/");
var inst_41934 = ((inst_41931) && (inst_41933));
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41934)){
var statearr_42215_42402 = state_42159__$1;
(statearr_42215_42402[(1)] = (53));

} else {
var statearr_42216_42403 = state_42159__$1;
(statearr_42216_42403[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (129))){
var inst_42141 = (state_42159[(24)]);
var state_42159__$1 = state_42159;
var statearr_42217_42404 = state_42159__$1;
(statearr_42217_42404[(2)] = inst_42141);

(statearr_42217_42404[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (91))){
var inst_42024 = (state_42159[(25)]);
var inst_42028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42029 = [inst_42024];
var inst_42030 = (new cljs.core.PersistentVector(null,1,(5),inst_42028,inst_42029,null));
var state_42159__$1 = state_42159;
var statearr_42218_42405 = state_42159__$1;
(statearr_42218_42405[(2)] = inst_42030);

(statearr_42218_42405[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (117))){
var inst_41860 = (state_42159[(11)]);
var state_42159__$1 = state_42159;
var statearr_42219_42406 = state_42159__$1;
(statearr_42219_42406[(2)] = inst_41860);

(statearr_42219_42406[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (108))){
var inst_42077 = cljs.core._deref(fuel);
var inst_42078 = (inst_42077 + (1));
var inst_42079 = cljs.core._vreset_BANG_(fuel,inst_42078);
var state_42159__$1 = state_42159;
var statearr_42220_42407 = state_42159__$1;
(statearr_42220_42407[(2)] = inst_42079);

(statearr_42220_42407[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (56))){
var inst_41937 = (state_42159[(26)]);
var inst_41939 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_41940 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41937,inst_41939);
var state_42159__$1 = state_42159;
var statearr_42221_42408 = state_42159__$1;
(statearr_42221_42408[(2)] = inst_41940);

(statearr_42221_42408[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (33))){
var inst_41859 = (state_42159[(13)]);
var inst_41884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41885 = [inst_41859,"ASC"];
var inst_41886 = (new cljs.core.PersistentVector(null,2,(5),inst_41884,inst_41885,null));
var state_42159__$1 = state_42159;
var statearr_42222_42409 = state_42159__$1;
(statearr_42222_42409[(2)] = inst_41886);

(statearr_42222_42409[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (13))){
var inst_41826 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41827 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41828 = cljs.core.PersistentHashMap.fromArrays(inst_41826,inst_41827);
var inst_41829 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_41828);
var inst_41830 = (function(){throw inst_41829})();
var state_42159__$1 = state_42159;
var statearr_42223_42410 = state_42159__$1;
(statearr_42223_42410[(2)] = inst_41830);

(statearr_42223_42410[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (22))){
var inst_41837 = (state_42159[(23)]);
var state_42159__$1 = state_42159;
var statearr_42224_42411 = state_42159__$1;
(statearr_42224_42411[(2)] = inst_41837);

(statearr_42224_42411[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (90))){
var state_42159__$1 = state_42159;
var statearr_42225_42412 = state_42159__$1;
(statearr_42225_42412[(2)] = null);

(statearr_42225_42412[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (109))){
var state_42159__$1 = state_42159;
var statearr_42226_42413 = state_42159__$1;
(statearr_42226_42413[(2)] = null);

(statearr_42226_42413[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (36))){
var inst_41889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41890 = [null,null];
var inst_41891 = (new cljs.core.PersistentVector(null,2,(5),inst_41889,inst_41890,null));
var state_42159__$1 = state_42159;
var statearr_42227_42414 = state_42159__$1;
(statearr_42227_42414[(2)] = inst_41891);

(statearr_42227_42414[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (41))){
var inst_41905 = (state_42159[(27)]);
var inst_42135 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42228 = state_42159;
(statearr_42228[(28)] = inst_42135);

return statearr_42228;
})();
if(cljs.core.truth_(inst_41905)){
var statearr_42229_42415 = state_42159__$1;
(statearr_42229_42415[(1)] = (125));

} else {
var statearr_42230_42416 = state_42159__$1;
(statearr_42230_42416[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (118))){
var inst_41859 = (state_42159[(13)]);
var inst_42104 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42231 = state_42159;
(statearr_42231[(10)] = inst_42104);

return statearr_42231;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42232_42417 = state_42159__$1;
(statearr_42232_42417[(1)] = (119));

} else {
var statearr_42233_42418 = state_42159__$1;
(statearr_42233_42418[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (89))){
var inst_42024 = (state_42159[(25)]);
var inst_42023 = (state_42159[(2)]);
var inst_42024__$1 = fluree.db.util.async.throw_err(inst_42023);
var inst_42025 = (inst_42024__$1 == null);
var state_42159__$1 = (function (){var statearr_42234 = state_42159;
(statearr_42234[(25)] = inst_42024__$1);

return statearr_42234;
})();
if(cljs.core.truth_(inst_42025)){
var statearr_42235_42419 = state_42159__$1;
(statearr_42235_42419[(1)] = (90));

} else {
var statearr_42236_42420 = state_42159__$1;
(statearr_42236_42420[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (100))){
var inst_42061 = (state_42159[(29)]);
var inst_42068 = (state_42159[(15)]);
var inst_42067 = cljs.core.seq(inst_42061);
var inst_42068__$1 = cljs.core.first(inst_42067);
var inst_42069 = cljs.core.next(inst_42067);
var inst_42070 = cljs.core.not(inst_42068__$1);
var state_42159__$1 = (function (){var statearr_42237 = state_42159;
(statearr_42237[(15)] = inst_42068__$1);

(statearr_42237[(30)] = inst_42069);

return statearr_42237;
})();
if(inst_42070){
var statearr_42238_42421 = state_42159__$1;
(statearr_42238_42421[(1)] = (102));

} else {
var statearr_42239_42422 = state_42159__$1;
(statearr_42239_42422[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (131))){
var inst_42140 = (state_42159[(17)]);
var inst_42151 = cljs.core.first(inst_42140);
var state_42159__$1 = state_42159;
var statearr_42240_42423 = state_42159__$1;
(statearr_42240_42423[(2)] = inst_42151);

(statearr_42240_42423[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (122))){
var inst_42115 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_42116 = ["Invalid 'from' in query:",inst_42115].join('');
var inst_42117 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42118 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_42119 = cljs.core.PersistentHashMap.fromArrays(inst_42117,inst_42118);
var inst_42120 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42116,inst_42119);
var state_42159__$1 = state_42159;
var statearr_42241_42424 = state_42159__$1;
(statearr_42241_42424[(2)] = inst_42120);

(statearr_42241_42424[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (43))){
var state_42159__$1 = state_42159;
var statearr_42242_42425 = state_42159__$1;
(statearr_42242_42425[(2)] = null);

(statearr_42242_42425[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (61))){
var inst_41859 = (state_42159[(13)]);
var inst_41949 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42243 = state_42159;
(statearr_42243[(12)] = inst_41949);

return statearr_42243;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42244_42426 = state_42159__$1;
(statearr_42244_42426[(1)] = (62));

} else {
var statearr_42245_42427 = state_42159__$1;
(statearr_42245_42427[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (29))){
var inst_41904 = (state_42159[(2)]);
var inst_41905 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41904,(0),null);
var inst_41906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41904,(1),null);
var inst_41907 = typeof where === 'string';
var state_42159__$1 = (function (){var statearr_42246 = state_42159;
(statearr_42246[(31)] = inst_41906);

(statearr_42246[(27)] = inst_41905);

return statearr_42246;
})();
if(cljs.core.truth_(inst_41907)){
var statearr_42247_42428 = state_42159__$1;
(statearr_42247_42428[(1)] = (39));

} else {
var statearr_42248_42429 = state_42159__$1;
(statearr_42248_42429[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (44))){
var inst_41913 = (state_42159[(2)]);
var inst_41914 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_41913);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(45),inst_41914);
} else {
if((state_val_42160 === (93))){
var inst_42035 = (state_42159[(2)]);
var inst_42036 = fluree.db.util.async.throw_err(inst_42035);
var state_42159__$1 = (function (){var statearr_42249 = state_42159;
(statearr_42249[(32)] = inst_42036);

return statearr_42249;
})();
if(cljs.core.truth_(fuel)){
var statearr_42250_42430 = state_42159__$1;
(statearr_42250_42430[(1)] = (94));

} else {
var statearr_42251_42431 = state_42159__$1;
(statearr_42251_42431[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (6))){
var inst_41817 = (state_42159[(33)]);
var state_42159__$1 = state_42159;
var statearr_42252_42432 = state_42159__$1;
(statearr_42252_42432[(2)] = inst_41817);

(statearr_42252_42432[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (111))){
var inst_42085 = (state_42159[(2)]);
var inst_42086 = fluree.db.util.async.throw_err(inst_42085);
var state_42159__$1 = state_42159;
var statearr_42253_42433 = state_42159__$1;
(statearr_42253_42433[(2)] = inst_42086);

(statearr_42253_42433[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (28))){
var inst_41900 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41901 = [null,null];
var inst_41902 = (new cljs.core.PersistentVector(null,2,(5),inst_41900,inst_41901,null));
var state_42159__$1 = state_42159;
var statearr_42254_42434 = state_42159__$1;
(statearr_42254_42434[(2)] = inst_41902);

(statearr_42254_42434[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (64))){
var inst_41957 = (state_42159[(2)]);
var inst_41958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41959 = [from];
var inst_41960 = (new cljs.core.PersistentVector(null,1,(5),inst_41958,inst_41959,null));
var inst_41961 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41960,inst_41957);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(65),inst_41961);
} else {
if((state_val_42160 === (103))){
var inst_42068 = (state_42159[(15)]);
var inst_42073 = cljs.core.int_QMARK_(inst_42068);
var state_42159__$1 = state_42159;
if(inst_42073){
var statearr_42255_42435 = state_42159__$1;
(statearr_42255_42435[(1)] = (105));

} else {
var statearr_42256_42436 = state_42159__$1;
(statearr_42256_42436[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (51))){
var inst_41862 = (state_42159[(14)]);
var state_42159__$1 = state_42159;
var statearr_42257_42437 = state_42159__$1;
(statearr_42257_42437[(2)] = inst_41862);

(statearr_42257_42437[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (25))){
var inst_41863 = (state_42159[(20)]);
var state_42159__$1 = state_42159;
var statearr_42258_42438 = state_42159__$1;
(statearr_42258_42438[(2)] = inst_41863);

(statearr_42258_42438[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (34))){
var state_42159__$1 = state_42159;
var statearr_42259_42439 = state_42159__$1;
(statearr_42259_42439[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (125))){
var inst_41860 = (state_42159[(11)]);
var inst_42135 = (state_42159[(28)]);
var inst_41862 = (state_42159[(14)]);
var inst_41906 = (state_42159[(31)]);
var inst_41905 = (state_42159[(27)]);
var inst_42137 = fluree.db.query.fql.sort_offset_and_limit_res(inst_41905,inst_41906,inst_41862,inst_41860,inst_42135);
var state_42159__$1 = state_42159;
var statearr_42261_42440 = state_42159__$1;
(statearr_42261_42440[(2)] = inst_42137);

(statearr_42261_42440[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (17))){
var inst_41853 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41853)){
var statearr_42262_42441 = state_42159__$1;
(statearr_42262_42441[(1)] = (21));

} else {
var statearr_42263_42442 = state_42159__$1;
(statearr_42263_42442[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (3))){
var inst_42157 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42159__$1,inst_42157);
} else {
if((state_val_42160 === (12))){
var inst_41823 = (state_42159[(34)]);
var state_42159__$1 = state_42159;
var statearr_42264_42443 = state_42159__$1;
(statearr_42264_42443[(2)] = inst_41823);

(statearr_42264_42443[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (2))){
var inst_41817 = (state_42159[(33)]);
var _ = (function (){var statearr_42265 = state_42159;
(statearr_42265[(4)] = cljs.core.cons((5),(state_42159[(4)])));

return statearr_42265;
})();
var inst_41817__$1 = select;
var state_42159__$1 = (function (){var statearr_42266 = state_42159;
(statearr_42266[(33)] = inst_41817__$1);

return statearr_42266;
})();
if(cljs.core.truth_(inst_41817__$1)){
var statearr_42267_42444 = state_42159__$1;
(statearr_42267_42444[(1)] = (6));

} else {
var statearr_42268_42445 = state_42159__$1;
(statearr_42268_42445[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (66))){
var inst_41968 = (state_42159[(2)]);
var inst_41969 = fluree.db.util.async.throw_err(inst_41968);
var state_42159__$1 = state_42159;
var statearr_42269_42446 = state_42159__$1;
(statearr_42269_42446[(2)] = inst_41969);

(statearr_42269_42446[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (107))){
var inst_42088 = (state_42159[(35)]);
var inst_42088__$1 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42270 = state_42159;
(statearr_42270[(35)] = inst_42088__$1);

return statearr_42270;
})();
if(cljs.core.truth_(inst_42088__$1)){
var statearr_42271_42447 = state_42159__$1;
(statearr_42271_42447[(1)] = (112));

} else {
var statearr_42272_42448 = state_42159__$1;
(statearr_42272_42448[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (23))){
var inst_41836 = (state_42159[(36)]);
var inst_41861 = (state_42159[(21)]);
var inst_41858 = (state_42159[(2)]);
var inst_41859 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41858,cljs.core.cst$kw$orderBy);
var inst_41860 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41858,cljs.core.cst$kw$limit);
var inst_41861__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41858,cljs.core.cst$kw$component);
var inst_41862 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41858,cljs.core.cst$kw$offset);
var inst_41863 = fluree.db.query.fql_parser.parse_db(db,inst_41836,opts_SINGLEQUOTE_);
var inst_41864 = (inst_41861__$1 == null);
var inst_41865 = cljs.core.not(inst_41864);
var state_42159__$1 = (function (){var statearr_42273 = state_42159;
(statearr_42273[(11)] = inst_41860);

(statearr_42273[(14)] = inst_41862);

(statearr_42273[(20)] = inst_41863);

(statearr_42273[(13)] = inst_41859);

(statearr_42273[(21)] = inst_41861__$1);

return statearr_42273;
})();
if(inst_41865){
var statearr_42274_42449 = state_42159__$1;
(statearr_42274_42449[(1)] = (24));

} else {
var statearr_42275_42450 = state_42159__$1;
(statearr_42275_42450[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (47))){
var state_42159__$1 = state_42159;
var statearr_42276_42451 = state_42159__$1;
(statearr_42276_42451[(2)] = null);

(statearr_42276_42451[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (35))){
var inst_41896 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42277_42452 = state_42159__$1;
(statearr_42277_42452[(2)] = inst_41896);

(statearr_42277_42452[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (127))){
var inst_42141 = (state_42159[(24)]);
var inst_42140 = (state_42159[(2)]);
var inst_42141__$1 = selectOne;
var state_42159__$1 = (function (){var statearr_42278 = state_42159;
(statearr_42278[(17)] = inst_42140);

(statearr_42278[(24)] = inst_42141__$1);

return statearr_42278;
})();
if(cljs.core.truth_(inst_42141__$1)){
var statearr_42279_42453 = state_42159__$1;
(statearr_42279_42453[(1)] = (128));

} else {
var statearr_42280_42454 = state_42159__$1;
(statearr_42280_42454[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (82))){
var inst_41860 = (state_42159[(11)]);
var inst_41862 = (state_42159[(14)]);
var inst_42004 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_42005 = [inst_41860,inst_41862];
var inst_42006 = cljs.core.PersistentHashMap.fromArrays(inst_42004,inst_42005);
var state_42159__$1 = state_42159;
var statearr_42281_42455 = state_42159__$1;
(statearr_42281_42455[(2)] = inst_42006);

(statearr_42281_42455[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (76))){
var inst_41872 = (state_42159[(8)]);
var inst_41870 = (state_42159[(9)]);
var inst_41992 = (state_42159[(2)]);
var inst_41993 = fluree.db.util.async.throw_err(inst_41992);
var inst_41994 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41872,fuel,max_fuel,inst_41870,inst_41993);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(77),inst_41994);
} else {
if((state_val_42160 === (97))){
var inst_42056 = from;
var inst_42057 = cljs.core.seq(inst_42056);
var inst_42058 = cljs.core.first(inst_42057);
var inst_42059 = cljs.core.next(inst_42057);
var inst_42060 = cljs.core.PersistentVector.EMPTY;
var inst_42061 = inst_42056;
var inst_42062 = inst_42060;
var state_42159__$1 = (function (){var statearr_42282 = state_42159;
(statearr_42282[(29)] = inst_42061);

(statearr_42282[(22)] = inst_42062);

(statearr_42282[(37)] = inst_42058);

(statearr_42282[(38)] = inst_42059);

return statearr_42282;
})();
var statearr_42283_42456 = state_42159__$1;
(statearr_42283_42456[(2)] = null);

(statearr_42283_42456[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (19))){
var state_42159__$1 = state_42159;
var statearr_42284_42457 = state_42159__$1;
(statearr_42284_42457[(2)] = false);

(statearr_42284_42457[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (57))){
var inst_41937 = (state_42159[(26)]);
var state_42159__$1 = state_42159;
var statearr_42285_42458 = state_42159__$1;
(statearr_42285_42458[(2)] = inst_41937);

(statearr_42285_42458[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (68))){
var state_42159__$1 = state_42159;
var statearr_42286_42459 = state_42159__$1;
(statearr_42286_42459[(2)] = false);

(statearr_42286_42459[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (11))){
var inst_41834 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42287_42460 = state_42159__$1;
(statearr_42287_42460[(2)] = inst_41834);

(statearr_42287_42460[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (115))){
var inst_42111 = (state_42159[(2)]);
var inst_42112 = fluree.db.util.async.throw_err(inst_42111);
var state_42159__$1 = state_42159;
var statearr_42289_42461 = state_42159__$1;
(statearr_42289_42461[(2)] = inst_42112);

(statearr_42289_42461[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (9))){
var inst_41820 = (state_42159[(18)]);
var state_42159__$1 = state_42159;
var statearr_42290_42462 = state_42159__$1;
(statearr_42290_42462[(2)] = inst_41820);

(statearr_42290_42462[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (5))){
var _ = (function (){var statearr_42291 = state_42159;
(statearr_42291[(4)] = cljs.core.rest((state_42159[(4)])));

return statearr_42291;
})();
var state_42159__$1 = state_42159;
var ex42288 = (state_42159__$1[(2)]);
var statearr_42292_42463 = state_42159__$1;
(statearr_42292_42463[(5)] = ex42288);


if((ex42288 instanceof Error)){
var statearr_42293_42464 = state_42159__$1;
(statearr_42293_42464[(1)] = (4));

(statearr_42293_42464[(5)] = null);

} else {
throw ex42288;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (112))){
var inst_42062 = (state_42159[(22)]);
var inst_42088 = (state_42159[(35)]);
var inst_42090 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42062,inst_42088);
var state_42159__$1 = state_42159;
var statearr_42294_42465 = state_42159__$1;
(statearr_42294_42465[(2)] = inst_42090);

(statearr_42294_42465[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (83))){
var inst_42008 = (state_42159[(2)]);
var inst_42009 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_42008);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(84),inst_42009);
} else {
if((state_val_42160 === (14))){
var inst_41832 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42295_42466 = state_42159__$1;
(statearr_42295_42466[(2)] = inst_41832);

(statearr_42295_42466[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (45))){
var inst_41859 = (state_42159[(13)]);
var inst_41916 = (state_42159[(2)]);
var inst_41917 = fluree.db.util.async.throw_err(inst_41916);
var state_42159__$1 = (function (){var statearr_42296 = state_42159;
(statearr_42296[(39)] = inst_41917);

return statearr_42296;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42297_42467 = state_42159__$1;
(statearr_42297_42467[(1)] = (47));

} else {
var statearr_42298_42468 = state_42159__$1;
(statearr_42298_42468[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (53))){
var inst_41937 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_42159__$1 = (function (){var statearr_42299 = state_42159;
(statearr_42299[(26)] = inst_41937);

return statearr_42299;
})();
if(cljs.core.truth_(fuel)){
var statearr_42300_42469 = state_42159__$1;
(statearr_42300_42469[(1)] = (56));

} else {
var statearr_42301_42470 = state_42159__$1;
(statearr_42301_42470[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (78))){
var inst_41859 = (state_42159[(13)]);
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41859)){
var statearr_42302_42471 = state_42159__$1;
(statearr_42302_42471[(1)] = (81));

} else {
var statearr_42303_42472 = state_42159__$1;
(statearr_42303_42472[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (132))){
var inst_42140 = (state_42159[(17)]);
var state_42159__$1 = state_42159;
var statearr_42304_42473 = state_42159__$1;
(statearr_42304_42473[(2)] = inst_42140);

(statearr_42304_42473[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (26))){
var inst_41859 = (state_42159[(13)]);
var inst_41870 = (state_42159[(2)]);
var inst_41871 = cljs.core.PersistentHashMap.EMPTY;
var inst_41872 = cljs.core.volatile_BANG_(inst_41871);
var state_42159__$1 = (function (){var statearr_42305 = state_42159;
(statearr_42305[(8)] = inst_41872);

(statearr_42305[(9)] = inst_41870);

return statearr_42305;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42306_42474 = state_42159__$1;
(statearr_42306_42474[(1)] = (27));

} else {
var statearr_42307_42475 = state_42159__$1;
(statearr_42307_42475[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (123))){
var state_42159__$1 = state_42159;
var statearr_42308_42476 = state_42159__$1;
(statearr_42308_42476[(2)] = null);

(statearr_42308_42476[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (16))){
var state_42159__$1 = state_42159;
var statearr_42309_42477 = state_42159__$1;
(statearr_42309_42477[(2)] = false);

(statearr_42309_42477[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (133))){
var inst_42154 = (state_42159[(2)]);
var _ = (function (){var statearr_42310 = state_42159;
(statearr_42310[(4)] = cljs.core.rest((state_42159[(4)])));

return statearr_42310;
})();
var state_42159__$1 = state_42159;
var statearr_42311_42478 = state_42159__$1;
(statearr_42311_42478[(2)] = inst_42154);

(statearr_42311_42478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (81))){
var inst_42002 = cljs.core.PersistentHashMap.EMPTY;
var state_42159__$1 = state_42159;
var statearr_42312_42479 = state_42159__$1;
(statearr_42312_42479[(2)] = inst_42002);

(statearr_42312_42479[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (120))){
var inst_41862 = (state_42159[(14)]);
var state_42159__$1 = state_42159;
var statearr_42313_42480 = state_42159__$1;
(statearr_42313_42480[(2)] = inst_41862);

(statearr_42313_42480[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (79))){
var inst_42018 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_42159__$1 = state_42159;
if(inst_42018){
var statearr_42314_42481 = state_42159__$1;
(statearr_42314_42481[(1)] = (86));

} else {
var statearr_42315_42482 = state_42159__$1;
(statearr_42315_42482[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (38))){
var inst_41894 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42316_42483 = state_42159__$1;
(statearr_42316_42483[(2)] = inst_41894);

(statearr_42316_42483[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (126))){
var inst_42135 = (state_42159[(28)]);
var state_42159__$1 = state_42159;
var statearr_42317_42484 = state_42159__$1;
(statearr_42317_42484[(2)] = inst_42135);

(statearr_42317_42484[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (98))){
var state_42159__$1 = state_42159;
var statearr_42318_42485 = state_42159__$1;
(statearr_42318_42485[(1)] = (122));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (124))){
var inst_42123 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42320_42486 = state_42159__$1;
(statearr_42320_42486[(2)] = inst_42123);

(statearr_42320_42486[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (87))){
var inst_42045 = cljs.core.sequential_QMARK_(from);
var inst_42046 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_42047 = ((inst_42045) && (inst_42046));
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_42047)){
var statearr_42321_42487 = state_42159__$1;
(statearr_42321_42487[(1)] = (97));

} else {
var statearr_42322_42488 = state_42159__$1;
(statearr_42322_42488[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (30))){
var inst_41859 = (state_42159[(13)]);
var inst_41876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41877 = cljs.core.second(inst_41859);
var inst_41878 = cljs.core.first(inst_41859);
var inst_41879 = [inst_41877,inst_41878];
var inst_41880 = (new cljs.core.PersistentVector(null,2,(5),inst_41876,inst_41879,null));
var state_42159__$1 = state_42159;
var statearr_42323_42489 = state_42159__$1;
(statearr_42323_42489[(2)] = inst_41880);

(statearr_42323_42489[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (73))){
var inst_41983 = cljs.core.PersistentHashMap.EMPTY;
var state_42159__$1 = state_42159;
var statearr_42324_42490 = state_42159__$1;
(statearr_42324_42490[(2)] = inst_41983);

(statearr_42324_42490[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (96))){
var inst_42036 = (state_42159[(32)]);
var inst_42043 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42325 = state_42159;
(statearr_42325[(40)] = inst_42043);

return statearr_42325;
})();
var statearr_42326_42491 = state_42159__$1;
(statearr_42326_42491[(2)] = inst_42036);

(statearr_42326_42491[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (10))){
var inst_41823 = (state_42159[(34)]);
var inst_41823__$1 = selectDistinct;
var state_42159__$1 = (function (){var statearr_42327 = state_42159;
(statearr_42327[(34)] = inst_41823__$1);

return statearr_42327;
})();
if(cljs.core.truth_(inst_41823__$1)){
var statearr_42328_42492 = state_42159__$1;
(statearr_42328_42492[(1)] = (12));

} else {
var statearr_42329_42493 = state_42159__$1;
(statearr_42329_42493[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (18))){
var state_42159__$1 = state_42159;
var statearr_42330_42494 = state_42159__$1;
(statearr_42330_42494[(2)] = true);

(statearr_42330_42494[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (105))){
var inst_42068 = (state_42159[(15)]);
var state_42159__$1 = state_42159;
var statearr_42331_42495 = state_42159__$1;
(statearr_42331_42495[(2)] = inst_42068);

(statearr_42331_42495[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (52))){
var inst_41921 = (state_42159[(41)]);
var inst_41917 = (state_42159[(39)]);
var inst_41872 = (state_42159[(8)]);
var inst_41870 = (state_42159[(9)]);
var inst_41925 = (state_42159[(2)]);
var inst_41926 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41872,fuel,max_fuel,inst_41870,inst_41917,inst_41921,inst_41925);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(46),inst_41926);
} else {
if((state_val_42160 === (114))){
var inst_42069 = (state_42159[(30)]);
var inst_42093 = (state_42159[(2)]);
var inst_42061 = inst_42069;
var inst_42062 = inst_42093;
var state_42159__$1 = (function (){var statearr_42332 = state_42159;
(statearr_42332[(29)] = inst_42061);

(statearr_42332[(22)] = inst_42062);

return statearr_42332;
})();
var statearr_42333_42496 = state_42159__$1;
(statearr_42333_42496[(2)] = null);

(statearr_42333_42496[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (67))){
var inst_41974 = ["_tx",null,"_block",null];
var inst_41975 = (new cljs.core.PersistentArrayMap(null,2,inst_41974,null));
var inst_41976 = (new cljs.core.PersistentHashSet(null,inst_41975,null));
var inst_41977 = (inst_41976.cljs$core$IFn$_invoke$arity$1 ? inst_41976.cljs$core$IFn$_invoke$arity$1(from) : inst_41976.call(null,from));
var state_42159__$1 = state_42159;
var statearr_42334_42497 = state_42159__$1;
(statearr_42334_42497[(2)] = inst_41977);

(statearr_42334_42497[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (71))){
var inst_41999 = typeof from === 'string';
var state_42159__$1 = state_42159;
if(cljs.core.truth_(inst_41999)){
var statearr_42335_42498 = state_42159__$1;
(statearr_42335_42498[(1)] = (78));

} else {
var statearr_42336_42499 = state_42159__$1;
(statearr_42336_42499[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (42))){
var state_42159__$1 = state_42159;
var statearr_42337_42500 = state_42159__$1;
(statearr_42337_42500[(2)] = from);

(statearr_42337_42500[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (80))){
var inst_42129 = (state_42159[(2)]);
var state_42159__$1 = state_42159;
var statearr_42338_42501 = state_42159__$1;
(statearr_42338_42501[(2)] = inst_42129);

(statearr_42338_42501[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (37))){
var state_42159__$1 = state_42159;
var statearr_42339_42502 = state_42159__$1;
(statearr_42339_42502[(2)] = null);

(statearr_42339_42502[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (63))){
var inst_41860 = (state_42159[(11)]);
var inst_41862 = (state_42159[(14)]);
var inst_41953 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41954 = [inst_41860,inst_41862];
var inst_41955 = cljs.core.PersistentHashMap.fromArrays(inst_41953,inst_41954);
var state_42159__$1 = state_42159;
var statearr_42340_42503 = state_42159__$1;
(statearr_42340_42503[(2)] = inst_41955);

(statearr_42340_42503[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (94))){
var inst_42038 = cljs.core._deref(fuel);
var inst_42039 = (inst_42038 + (1));
var inst_42040 = cljs.core._vreset_BANG_(fuel,inst_42039);
var state_42159__$1 = state_42159;
var statearr_42341_42504 = state_42159__$1;
(statearr_42341_42504[(2)] = inst_42040);

(statearr_42341_42504[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (8))){
var inst_41837 = (state_42159[(23)]);
var inst_41836 = (state_42159[(2)]);
var inst_41837__$1 = opts_SINGLEQUOTE_;
var inst_41839 = (inst_41837__$1 == null);
var inst_41840 = cljs.core.not(inst_41839);
var state_42159__$1 = (function (){var statearr_42342 = state_42159;
(statearr_42342[(23)] = inst_41837__$1);

(statearr_42342[(36)] = inst_41836);

return statearr_42342;
})();
if(inst_41840){
var statearr_42343_42505 = state_42159__$1;
(statearr_42343_42505[(1)] = (15));

} else {
var statearr_42344_42506 = state_42159__$1;
(statearr_42344_42506[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (49))){
var inst_41859 = (state_42159[(13)]);
var inst_41921 = (state_42159[(2)]);
var state_42159__$1 = (function (){var statearr_42345 = state_42159;
(statearr_42345[(41)] = inst_41921);

return statearr_42345;
})();
if(cljs.core.truth_(inst_41859)){
var statearr_42346_42507 = state_42159__$1;
(statearr_42346_42507[(1)] = (50));

} else {
var statearr_42347_42508 = state_42159__$1;
(statearr_42347_42508[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42160 === (84))){
var inst_41872 = (state_42159[(8)]);
var inst_41870 = (state_42159[(9)]);
var inst_42011 = (state_42159[(2)]);
var inst_42012 = fluree.db.util.async.throw_err(inst_42011);
var inst_42013 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41872,fuel,max_fuel,inst_41870,inst_42012);
var state_42159__$1 = state_42159;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42159__$1,(85),inst_42013);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16291__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16291__auto____0 = (function (){
var statearr_42348 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42348[(0)] = fluree$db$query$fql$query_$_state_machine__16291__auto__);

(statearr_42348[(1)] = (1));

return statearr_42348;
});
var fluree$db$query$fql$query_$_state_machine__16291__auto____1 = (function (state_42159){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_42159);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e42349){var ex__16294__auto__ = e42349;
var statearr_42350_42509 = state_42159;
(statearr_42350_42509[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_42159[(4)]))){
var statearr_42351_42510 = state_42159;
(statearr_42351_42510[(1)] = cljs.core.first((state_42159[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__42511 = state_42159;
state_42159 = G__42511;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16291__auto__ = function(state_42159){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16291__auto____1.call(this,state_42159);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16291__auto____0;
fluree$db$query$fql$query_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16291__auto____1;
return fluree$db$query$fql$query_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_42352 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_42352[(6)] = c__16328__auto__);

return statearr_42352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}

});
