// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42517 = arguments.length;
var i__4737__auto___42518 = (0);
while(true){
if((i__4737__auto___42518 < len__4736__auto___42517)){
args__4742__auto__.push((arguments[i__4737__auto___42518]));

var G__42519 = (i__4737__auto___42518 + (1));
i__4737__auto___42518 = G__42519;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq42514){
var G__42515 = cljs.core.first(seq42514);
var seq42514__$1 = cljs.core.next(seq42514);
var G__42516 = cljs.core.first(seq42514__$1);
var seq42514__$2 = cljs.core.next(seq42514__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42515,G__42516,seq42514__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e42520){var e = e42520;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e42521){var e = e42521;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e42522){var e = e42522;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e42523){var e = e42523;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e42524){var e = e42524;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42527 = arguments.length;
var i__4737__auto___42528 = (0);
while(true){
if((i__4737__auto___42528 < len__4736__auto___42527)){
args__4742__auto__.push((arguments[i__4737__auto___42528]));

var G__42529 = (i__4737__auto___42528 + (1));
i__4737__auto___42528 = G__42529;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e42526){var e = e42526;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq42525){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42525));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42532 = arguments.length;
var i__4737__auto___42533 = (0);
while(true){
if((i__4737__auto___42533 < len__4736__auto___42532)){
args__4742__auto__.push((arguments[i__4737__auto___42533]));

var G__42534 = (i__4737__auto___42533 + (1));
i__4737__auto___42533 = G__42534;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e42531){var e = e42531;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq42530){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42530));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e42535){var e = e42535;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42538 = arguments.length;
var i__4737__auto___42539 = (0);
while(true){
if((i__4737__auto___42539 < len__4736__auto___42538)){
args__4742__auto__.push((arguments[i__4737__auto___42539]));

var G__42540 = (i__4737__auto___42539 + (1));
i__4737__auto___42539 = G__42540;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e42537){var e = e42537;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq42536){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42536));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42543 = arguments.length;
var i__4737__auto___42544 = (0);
while(true){
if((i__4737__auto___42544 < len__4736__auto___42543)){
args__4742__auto__.push((arguments[i__4737__auto___42544]));

var G__42545 = (i__4737__auto___42544 + (1));
i__4737__auto___42544 = G__42545;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e42542){var e = e42542;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq42541){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42541));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e42546){var e = e42546;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e42547){var e = e42547;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42550 = arguments.length;
var i__4737__auto___42551 = (0);
while(true){
if((i__4737__auto___42551 < len__4736__auto___42550)){
args__4742__auto__.push((arguments[i__4737__auto___42551]));

var G__42552 = (i__4737__auto___42551 + (1));
i__4737__auto___42551 = G__42552;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e42549){var e = e42549;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq42548){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42548));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42555 = arguments.length;
var i__4737__auto___42556 = (0);
while(true){
if((i__4737__auto___42556 < len__4736__auto___42555)){
args__4742__auto__.push((arguments[i__4737__auto___42556]));

var G__42557 = (i__4737__auto___42556 + (1));
i__4737__auto___42556 = G__42557;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e42554){var e = e42554;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq42553){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42553));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42560 = arguments.length;
var i__4737__auto___42561 = (0);
while(true){
if((i__4737__auto___42561 < len__4736__auto___42560)){
args__4742__auto__.push((arguments[i__4737__auto___42561]));

var G__42562 = (i__4737__auto___42561 + (1));
i__4737__auto___42561 = G__42562;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e42559){var e = e42559;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq42558){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42558));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42565 = arguments.length;
var i__4737__auto___42566 = (0);
while(true){
if((i__4737__auto___42566 < len__4736__auto___42565)){
args__4742__auto__.push((arguments[i__4737__auto___42566]));

var G__42567 = (i__4737__auto___42566 + (1));
i__4737__auto___42566 = G__42567;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e42564){var e = e42564;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq42563){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42563));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42570 = arguments.length;
var i__4737__auto___42571 = (0);
while(true){
if((i__4737__auto___42571 < len__4736__auto___42570)){
args__4742__auto__.push((arguments[i__4737__auto___42571]));

var G__42572 = (i__4737__auto___42571 + (1));
i__4737__auto___42571 = G__42572;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e42569){var e = e42569;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq42568){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42568));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42575 = arguments.length;
var i__4737__auto___42576 = (0);
while(true){
if((i__4737__auto___42576 < len__4736__auto___42575)){
args__4742__auto__.push((arguments[i__4737__auto___42576]));

var G__42577 = (i__4737__auto___42576 + (1));
i__4737__auto___42576 = G__42577;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e42574){var e = e42574;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq42573){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42573));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42580 = arguments.length;
var i__4737__auto___42581 = (0);
while(true){
if((i__4737__auto___42581 < len__4736__auto___42580)){
args__4742__auto__.push((arguments[i__4737__auto___42581]));

var G__42582 = (i__4737__auto___42581 + (1));
i__4737__auto___42581 = G__42582;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e42579){var e = e42579;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq42578){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42578));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__42584 = arguments.length;
switch (G__42584) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_42612){
var state_val_42613 = (state_42612[(1)]);
if((state_val_42613 === (7))){
var inst_42597 = (state_42612[(7)]);
var inst_42600 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42597,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_42612__$1 = state_42612;
var statearr_42614_42700 = state_42612__$1;
(statearr_42614_42700[(2)] = inst_42600);

(statearr_42614_42700[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (1))){
var state_42612__$1 = state_42612;
var statearr_42615_42701 = state_42612__$1;
(statearr_42615_42701[(2)] = null);

(statearr_42615_42701[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (4))){
var inst_42585 = (state_42612[(2)]);
var state_42612__$1 = state_42612;
var statearr_42616_42702 = state_42612__$1;
(statearr_42616_42702[(2)] = inst_42585);

(statearr_42616_42702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (6))){
var inst_42597 = (state_42612[(7)]);
var inst_42597__$1 = (state_42612[(2)]);
var inst_42598 = fluree.db.util.core.exception_QMARK_(inst_42597__$1);
var state_42612__$1 = (function (){var statearr_42617 = state_42612;
(statearr_42617[(7)] = inst_42597__$1);

return statearr_42617;
})();
if(inst_42598){
var statearr_42618_42703 = state_42612__$1;
(statearr_42618_42703[(1)] = (7));

} else {
var statearr_42619_42704 = state_42612__$1;
(statearr_42619_42704[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (3))){
var inst_42610 = (state_42612[(2)]);
var state_42612__$1 = state_42612;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42612__$1,inst_42610);
} else {
if((state_val_42613 === (2))){
var inst_42591 = (state_42612[(8)]);
var _ = (function (){var statearr_42621 = state_42612;
(statearr_42621[(4)] = cljs.core.cons((5),(state_42612[(4)])));

return statearr_42621;
})();
var inst_42591__$1 = cljs.core.volatile_BANG_((0));
var inst_42592 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_42593 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_42592,cljs.core.cst$kw$fuel,inst_42591__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_42594 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_42593);
var inst_42595 = fluree.db.query.fql.query(db,inst_42594);
var state_42612__$1 = (function (){var statearr_42622 = state_42612;
(statearr_42622[(8)] = inst_42591__$1);

return statearr_42622;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42612__$1,(6),inst_42595);
} else {
if((state_val_42613 === (9))){
var inst_42607 = (state_42612[(2)]);
var _ = (function (){var statearr_42623 = state_42612;
(statearr_42623[(4)] = cljs.core.rest((state_42612[(4)])));

return statearr_42623;
})();
var state_42612__$1 = state_42612;
var statearr_42624_42705 = state_42612__$1;
(statearr_42624_42705[(2)] = inst_42607);

(statearr_42624_42705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (5))){
var _ = (function (){var statearr_42625 = state_42612;
(statearr_42625[(4)] = cljs.core.rest((state_42612[(4)])));

return statearr_42625;
})();
var state_42612__$1 = state_42612;
var ex42620 = (state_42612__$1[(2)]);
var statearr_42626_42706 = state_42612__$1;
(statearr_42626_42706[(5)] = ex42620);


if((ex42620 instanceof Error)){
var statearr_42627_42707 = state_42612__$1;
(statearr_42627_42707[(1)] = (4));

(statearr_42627_42707[(5)] = null);

} else {
throw ex42620;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42613 === (8))){
var inst_42597 = (state_42612[(7)]);
var inst_42591 = (state_42612[(8)]);
var inst_42602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42603 = cljs.core.deref(inst_42591);
var inst_42604 = [inst_42597,inst_42603];
var inst_42605 = (new cljs.core.PersistentVector(null,2,(5),inst_42602,inst_42604,null));
var state_42612__$1 = state_42612;
var statearr_42628_42708 = state_42612__$1;
(statearr_42628_42708[(2)] = inst_42605);

(statearr_42628_42708[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16291__auto____0 = (function (){
var statearr_42629 = [null,null,null,null,null,null,null,null,null];
(statearr_42629[(0)] = fluree$db$dbfunctions$internal$state_machine__16291__auto__);

(statearr_42629[(1)] = (1));

return statearr_42629;
});
var fluree$db$dbfunctions$internal$state_machine__16291__auto____1 = (function (state_42612){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_42612);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e42630){var ex__16294__auto__ = e42630;
var statearr_42631_42709 = state_42612;
(statearr_42631_42709[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_42612[(4)]))){
var statearr_42632_42710 = state_42612;
(statearr_42632_42710[(1)] = cljs.core.first((state_42612[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__42711 = state_42612;
state_42612 = G__42711;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16291__auto__ = function(state_42612){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____1.call(this,state_42612);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_42633 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_42633[(6)] = c__16328__auto__);

return statearr_42633;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_42678){
var state_val_42679 = (state_42678[(1)]);
if((state_val_42679 === (7))){
var inst_42664 = (state_42678[(2)]);
var inst_42665 = fluree.db.query.fql.query(db,inst_42664);
var state_42678__$1 = state_42678;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42678__$1,(8),inst_42665);
} else {
if((state_val_42679 === (1))){
var inst_42634 = typeof select === 'string';
var state_42678__$1 = state_42678;
if(cljs.core.truth_(inst_42634)){
var statearr_42680_42712 = state_42678__$1;
(statearr_42680_42712[(1)] = (2));

} else {
var statearr_42681_42713 = state_42678__$1;
(statearr_42681_42713[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (4))){
var inst_42640 = (state_42678[(7)]);
var inst_42647 = (state_42678[(8)]);
var inst_42639 = (state_42678[(2)]);
var inst_42640__$1 = cljs.core.volatile_BANG_((0));
var inst_42641 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_42642 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_42643 = [inst_42640__$1,(100000)];
var inst_42644 = cljs.core.PersistentHashMap.fromArrays(inst_42642,inst_42643);
var inst_42645 = [inst_42639,from,where,block,limit,inst_42644];
var inst_42646 = cljs.core.PersistentHashMap.fromArrays(inst_42641,inst_42645);
var inst_42647__$1 = fluree.db.util.core.without_nils(inst_42646);
var inst_42648 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_42647__$1);
var inst_42649 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_42647__$1);
var inst_42650 = cljs.core.first(inst_42649);
var inst_42651 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42650], 0));
var inst_42652 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_42651);
var inst_42653 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_42647__$1);
var inst_42654 = cljs.core.last(inst_42653);
var inst_42655 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42654], 0));
var inst_42656 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_42655);
var inst_42657 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42648,inst_42652,inst_42656], 0));
var state_42678__$1 = (function (){var statearr_42682 = state_42678;
(statearr_42682[(7)] = inst_42640__$1);

(statearr_42682[(8)] = inst_42647__$1);

return statearr_42682;
})();
if(cljs.core.truth_(inst_42657)){
var statearr_42683_42714 = state_42678__$1;
(statearr_42683_42714[(1)] = (5));

} else {
var statearr_42684_42715 = state_42678__$1;
(statearr_42684_42715[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (6))){
var inst_42647 = (state_42678[(8)]);
var state_42678__$1 = state_42678;
var statearr_42685_42716 = state_42678__$1;
(statearr_42685_42716[(2)] = inst_42647);

(statearr_42685_42716[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (3))){
var state_42678__$1 = state_42678;
var statearr_42686_42717 = state_42678__$1;
(statearr_42686_42717[(2)] = select);

(statearr_42686_42717[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (2))){
var inst_42636 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_42678__$1 = state_42678;
var statearr_42687_42718 = state_42678__$1;
(statearr_42687_42718[(2)] = inst_42636);

(statearr_42687_42718[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (11))){
var inst_42676 = (state_42678[(2)]);
var state_42678__$1 = state_42678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42678__$1,inst_42676);
} else {
if((state_val_42679 === (9))){
var inst_42667 = (state_42678[(9)]);
var state_42678__$1 = state_42678;
var statearr_42688_42719 = state_42678__$1;
(statearr_42688_42719[(2)] = inst_42667);

(statearr_42688_42719[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (5))){
var inst_42647 = (state_42678[(8)]);
var inst_42659 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_42647);
var inst_42660 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_42659);
var inst_42661 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42647,cljs.core.cst$kw$where,inst_42660);
var state_42678__$1 = state_42678;
var statearr_42689_42720 = state_42678__$1;
(statearr_42689_42720[(2)] = inst_42661);

(statearr_42689_42720[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (10))){
var inst_42640 = (state_42678[(7)]);
var inst_42667 = (state_42678[(9)]);
var inst_42671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42672 = cljs.core.deref(inst_42640);
var inst_42673 = [inst_42667,inst_42672];
var inst_42674 = (new cljs.core.PersistentVector(null,2,(5),inst_42671,inst_42673,null));
var state_42678__$1 = state_42678;
var statearr_42690_42721 = state_42678__$1;
(statearr_42690_42721[(2)] = inst_42674);

(statearr_42690_42721[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42679 === (8))){
var inst_42667 = (state_42678[(9)]);
var inst_42667__$1 = (state_42678[(2)]);
var inst_42668 = fluree.db.util.core.exception_QMARK_(inst_42667__$1);
var state_42678__$1 = (function (){var statearr_42691 = state_42678;
(statearr_42691[(9)] = inst_42667__$1);

return statearr_42691;
})();
if(inst_42668){
var statearr_42692_42722 = state_42678__$1;
(statearr_42692_42722[(1)] = (9));

} else {
var statearr_42693_42723 = state_42678__$1;
(statearr_42693_42723[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16291__auto____0 = (function (){
var statearr_42694 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42694[(0)] = fluree$db$dbfunctions$internal$state_machine__16291__auto__);

(statearr_42694[(1)] = (1));

return statearr_42694;
});
var fluree$db$dbfunctions$internal$state_machine__16291__auto____1 = (function (state_42678){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_42678);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e42695){var ex__16294__auto__ = e42695;
var statearr_42696_42724 = state_42678;
(statearr_42696_42724[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_42678[(4)]))){
var statearr_42697_42725 = state_42678;
(statearr_42697_42725[(1)] = cljs.core.first((state_42678[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__42726 = state_42678;
state_42678 = G__42726;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16291__auto__ = function(state_42678){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____1.call(this,state_42678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_42698 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_42698[(6)] = c__16328__auto__);

return statearr_42698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__42730 = path;
var vec__42731 = G__42730;
var seq__42732 = cljs.core.seq(vec__42731);
var first__42733 = cljs.core.first(seq__42732);
var seq__42732__$1 = cljs.core.next(seq__42732);
var var$ = first__42733;
var r = seq__42732__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__42730__$1 = G__42730;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__42737 = G__42730__$1;
var seq__42738 = cljs.core.seq(vec__42737);
var first__42739 = cljs.core.first(seq__42738);
var seq__42738__$1 = cljs.core.next(seq__42738);
var var$__$1 = first__42739;
var r__$1 = seq__42738__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__42740 = r__$1;
var G__42741 = n__$2;
var G__42742 = next_clauses;
G__42730__$1 = G__42740;
n__$1 = G__42741;
where_clauses__$1 = G__42742;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__42743 = r__$1;
var G__42744 = next_n;
var G__42745 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__42730__$1 = G__42743;
n__$1 = G__42744;
where_clauses__$1 = G__42745;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_42782){
var state_val_42783 = (state_42782[(1)]);
if((state_val_42783 === (7))){
var inst_42755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42756 = [path];
var inst_42757 = (new cljs.core.PersistentVector(null,1,(5),inst_42755,inst_42756,null));
var state_42782__$1 = state_42782;
var statearr_42784_42812 = state_42782__$1;
(statearr_42784_42812[(2)] = inst_42757);

(statearr_42784_42812[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (1))){
var state_42782__$1 = state_42782;
var statearr_42785_42813 = state_42782__$1;
(statearr_42785_42813[(2)] = null);

(statearr_42785_42813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (4))){
var inst_42746 = (state_42782[(2)]);
var state_42782__$1 = state_42782;
var statearr_42786_42814 = state_42782__$1;
(statearr_42786_42814[(2)] = inst_42746);

(statearr_42786_42814[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (13))){
var inst_42773 = (state_42782[(2)]);
var inst_42774 = fluree.db.util.async.throw_err(inst_42773);
var _ = (function (){var statearr_42787 = state_42782;
(statearr_42787[(4)] = cljs.core.rest((state_42782[(4)])));

return statearr_42787;
})();
var state_42782__$1 = state_42782;
var statearr_42788_42815 = state_42782__$1;
(statearr_42788_42815[(2)] = inst_42774);

(statearr_42788_42815[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (6))){
var state_42782__$1 = state_42782;
var statearr_42790_42816 = state_42782__$1;
(statearr_42790_42816[(2)] = path);

(statearr_42790_42816[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (3))){
var inst_42780 = (state_42782[(2)]);
var state_42782__$1 = state_42782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42782__$1,inst_42780);
} else {
if((state_val_42783 === (12))){
var _ = (function (){var statearr_42791 = state_42782;
(statearr_42791[(4)] = cljs.core.rest((state_42782[(4)])));

return statearr_42791;
})();
var state_42782__$1 = state_42782;
var ex42789 = (state_42782__$1[(2)]);
var statearr_42792_42817 = state_42782__$1;
(statearr_42792_42817[(5)] = ex42789);


var statearr_42793_42818 = state_42782__$1;
(statearr_42793_42818[(1)] = (11));

(statearr_42793_42818[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (2))){
var _ = (function (){var statearr_42794 = state_42782;
(statearr_42794[(4)] = cljs.core.cons((5),(state_42782[(4)])));

return statearr_42794;
})();
var inst_42752 = cljs.core.vector_QMARK_(path);
var state_42782__$1 = state_42782;
if(inst_42752){
var statearr_42795_42819 = state_42782__$1;
(statearr_42795_42819[(1)] = (6));

} else {
var statearr_42796_42820 = state_42782__$1;
(statearr_42796_42820[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (11))){
var inst_42759 = (state_42782[(7)]);
var inst_42764 = (state_42782[(2)]);
var inst_42765 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42764,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_42759,endSubject], 0));
var state_42782__$1 = state_42782;
var statearr_42798_42821 = state_42782__$1;
(statearr_42798_42821[(2)] = inst_42765);

(statearr_42798_42821[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (9))){
var inst_42763 = (state_42782[(8)]);
var _ = (function (){var statearr_42799 = state_42782;
(statearr_42799[(4)] = cljs.core.cons((12),(state_42782[(4)])));

return statearr_42799;
})();
var inst_42771 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_42763);
var state_42782__$1 = state_42782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42782__$1,(13),inst_42771);
} else {
if((state_val_42783 === (5))){
var _ = (function (){var statearr_42800 = state_42782;
(statearr_42800[(4)] = cljs.core.rest((state_42782[(4)])));

return statearr_42800;
})();
var state_42782__$1 = state_42782;
var ex42797 = (state_42782__$1[(2)]);
var statearr_42801_42822 = state_42782__$1;
(statearr_42801_42822[(5)] = ex42797);


if((ex42797 instanceof Error)){
var statearr_42802_42823 = state_42782__$1;
(statearr_42802_42823[(1)] = (4));

(statearr_42802_42823[(5)] = null);

} else {
throw ex42797;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (10))){
var inst_42777 = (state_42782[(2)]);
var _ = (function (){var statearr_42803 = state_42782;
(statearr_42803[(4)] = cljs.core.rest((state_42782[(4)])));

return statearr_42803;
})();
var state_42782__$1 = state_42782;
var statearr_42804_42824 = state_42782__$1;
(statearr_42804_42824[(2)] = inst_42777);

(statearr_42804_42824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42783 === (8))){
var inst_42759 = (state_42782[(7)]);
var inst_42759__$1 = (state_42782[(2)]);
var inst_42760 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_42759__$1,endSubject);
var inst_42761 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_42762 = ["?var1",inst_42760];
var inst_42763 = cljs.core.PersistentHashMap.fromArrays(inst_42761,inst_42762);
var state_42782__$1 = (function (){var statearr_42805 = state_42782;
(statearr_42805[(7)] = inst_42759__$1);

(statearr_42805[(8)] = inst_42763);

return statearr_42805;
})();
var statearr_42806_42825 = state_42782__$1;
(statearr_42806_42825[(2)] = null);

(statearr_42806_42825[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____0 = (function (){
var statearr_42807 = [null,null,null,null,null,null,null,null,null];
(statearr_42807[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__);

(statearr_42807[(1)] = (1));

return statearr_42807;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____1 = (function (state_42782){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_42782);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e42808){var ex__16294__auto__ = e42808;
var statearr_42809_42826 = state_42782;
(statearr_42809_42826[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_42782[(4)]))){
var statearr_42810_42827 = state_42782;
(statearr_42810_42827[(1)] = cljs.core.first((state_42782[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__42828 = state_42782;
state_42782 = G__42828;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__ = function(state_42782){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____1.call(this,state_42782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_42811 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_42811[(6)] = c__16328__auto__);

return statearr_42811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e42829){var e = e42829;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e42830){var e = e42830;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e42831){var e = e42831;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e42832){var e = e42832;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42835 = arguments.length;
var i__4737__auto___42836 = (0);
while(true){
if((i__4737__auto___42836 < len__4736__auto___42835)){
args__4742__auto__.push((arguments[i__4737__auto___42836]));

var G__42837 = (i__4737__auto___42836 + (1));
i__4737__auto___42836 = G__42837;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e42834){var e = e42834;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq42833){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42833));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42840 = arguments.length;
var i__4737__auto___42841 = (0);
while(true){
if((i__4737__auto___42841 < len__4736__auto___42840)){
args__4742__auto__.push((arguments[i__4737__auto___42841]));

var G__42842 = (i__4737__auto___42841 + (1));
i__4737__auto___42841 = G__42842;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e42839){var e = e42839;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq42838){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42838));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42845 = arguments.length;
var i__4737__auto___42846 = (0);
while(true){
if((i__4737__auto___42846 < len__4736__auto___42845)){
args__4742__auto__.push((arguments[i__4737__auto___42846]));

var G__42847 = (i__4737__auto___42846 + (1));
i__4737__auto___42846 = G__42847;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e42844){var e = e42844;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq42843){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42843));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42850 = arguments.length;
var i__4737__auto___42851 = (0);
while(true){
if((i__4737__auto___42851 < len__4736__auto___42850)){
args__4742__auto__.push((arguments[i__4737__auto___42851]));

var G__42852 = (i__4737__auto___42851 + (1));
i__4737__auto___42851 = G__42852;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e42849){var e = e42849;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq42848){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42848));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e42853){var e = e42853;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e42854){var e = e42854;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e42855){var e = e42855;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e42856){var e = e42856;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e42857){var e = e42857;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__42863 = path;
var vec__42864 = G__42863;
var seq__42865 = cljs.core.seq(vec__42864);
var first__42866 = cljs.core.first(seq__42865);
var seq__42865__$1 = cljs.core.next(seq__42865);
var pred = first__42866;
var r = seq__42865__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__42863__$1 = G__42863;
var subjects__$1 = subjects;
while(true){
var vec__42870 = G__42863__$1;
var seq__42871 = cljs.core.seq(vec__42870);
var first__42872 = cljs.core.first(seq__42871);
var seq__42871__$1 = cljs.core.next(seq__42871);
var pred__$1 = first__42872;
var r__$1 = seq__42871__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__42863__$1,subjects__$1,vec__42870,seq__42871,first__42872,seq__42871__$1,pred__$1,r__$1,subjects__$2,G__42863,vec__42864,seq__42865,first__42866,seq__42865__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__42863__$1,subjects__$1,vec__42870,seq__42871,first__42872,seq__42871__$1,pred__$1,r__$1,subjects__$2,G__42863,vec__42864,seq__42865,first__42866,seq__42865__$1,pred,r,subjects){
return (function (p1__42858_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__42858_SHARP_,pred__$1);
});})(G__42863__$1,subjects__$1,vec__42870,seq__42871,first__42872,seq__42871__$1,pred__$1,r__$1,subjects__$2,G__42863,vec__42864,seq__42865,first__42866,seq__42865__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__42863__$1,subjects__$1,vec__42870,seq__42871,first__42872,seq__42871__$1,pred__$1,r__$1,subjects__$2,G__42863,vec__42864,seq__42865,first__42866,seq__42865__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__42873 = r__$1;
var G__42874 = next_subjects;
G__42863__$1 = G__42873;
subjects__$1 = G__42874;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e42859){var e = e42859;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e42875){var e = e42875;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e42876){var e = e42876;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42879 = arguments.length;
var i__4737__auto___42880 = (0);
while(true){
if((i__4737__auto___42880 < len__4736__auto___42879)){
args__4742__auto__.push((arguments[i__4737__auto___42880]));

var G__42881 = (i__4737__auto___42880 + (1));
i__4737__auto___42880 = G__42881;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e42878){var e = e42878;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq42877){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42877));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e42882){var e = e42882;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___42885 = arguments.length;
var i__4737__auto___42886 = (0);
while(true){
if((i__4737__auto___42886 < len__4736__auto___42885)){
args__4742__auto__.push((arguments[i__4737__auto___42886]));

var G__42887 = (i__4737__auto___42886 + (1));
i__4737__auto___42886 = G__42887;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e42884){var e = e42884;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq42883){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq42883));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e42888){var e = e42888;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_42943){
var state_val_42944 = (state_42943[(1)]);
if((state_val_42944 === (7))){
var inst_42890 = (state_42943[(2)]);
var state_42943__$1 = state_42943;
var statearr_42945_42978 = state_42943__$1;
(statearr_42945_42978[(2)] = inst_42890);

(statearr_42945_42978[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (1))){
var state_42943__$1 = state_42943;
var statearr_42946_42979 = state_42943__$1;
(statearr_42946_42979[(2)] = null);

(statearr_42946_42979[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (4))){
var inst_42889 = (state_42943[(2)]);
var state_42943__$1 = (function (){var statearr_42947 = state_42943;
(statearr_42947[(7)] = inst_42889);

return statearr_42947;
})();
var statearr_42948_42980 = state_42943__$1;
(statearr_42948_42980[(2)] = null);

(statearr_42948_42980[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (15))){
var inst_42927 = (state_42943[(8)]);
var inst_42931 = inst_42927.o;
var state_42943__$1 = state_42943;
var statearr_42949_42981 = state_42943__$1;
(statearr_42949_42981[(2)] = inst_42931);

(statearr_42949_42981[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (13))){
var inst_42927 = (state_42943[(8)]);
var inst_42923 = (state_42943[(2)]);
var inst_42924 = fluree.db.util.async.throw_err(inst_42923);
var inst_42925 = fluree.db.dbfunctions.internal.count(inst_42924);
var inst_42927__$1 = cljs.core.first(inst_42924);
var inst_42928 = (inst_42927__$1 == null);
var state_42943__$1 = (function (){var statearr_42950 = state_42943;
(statearr_42950[(8)] = inst_42927__$1);

(statearr_42950[(9)] = inst_42925);

return statearr_42950;
})();
if(cljs.core.truth_(inst_42928)){
var statearr_42951_42982 = state_42943__$1;
(statearr_42951_42982[(1)] = (14));

} else {
var statearr_42952_42983 = state_42943__$1;
(statearr_42952_42983[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (6))){
var inst_42899 = (state_42943[(2)]);
var state_42943__$1 = state_42943;
var statearr_42953_42984 = state_42943__$1;
(statearr_42953_42984[(2)] = inst_42899);

(statearr_42953_42984[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (3))){
var inst_42941 = (state_42943[(2)]);
var state_42943__$1 = state_42943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42943__$1,inst_42941);
} else {
if((state_val_42944 === (12))){
var inst_42938 = (state_42943[(2)]);
var _ = (function (){var statearr_42954 = state_42943;
(statearr_42954[(4)] = cljs.core.rest((state_42943[(4)])));

return statearr_42954;
})();
var state_42943__$1 = state_42943;
var statearr_42955_42985 = state_42943__$1;
(statearr_42955_42985[(2)] = inst_42938);

(statearr_42955_42985[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (2))){
var _ = (function (){var statearr_42957 = state_42943;
(statearr_42957[(4)] = cljs.core.cons((9),(state_42943[(4)])));

return statearr_42957;
})();
var inst_42905 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42906 = typeof inst_42905 === 'string';
var state_42943__$1 = state_42943;
if(cljs.core.truth_(inst_42906)){
var statearr_42958_42986 = state_42943__$1;
(statearr_42958_42986[(1)] = (10));

} else {
var statearr_42959_42987 = state_42943__$1;
(statearr_42959_42987[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (11))){
var inst_42912 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42913 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_42912);
var inst_42914 = fluree.db.dbfunctions.internal.inc(inst_42913);
var inst_42915 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42912,cljs.core.cst$kw$t,inst_42914);
var inst_42916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42917 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42918 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42919 = [inst_42917,inst_42918];
var inst_42920 = (new cljs.core.PersistentVector(null,2,(5),inst_42916,inst_42919,null));
var inst_42921 = fluree.db.dbproto._search(inst_42915,inst_42920);
var state_42943__$1 = state_42943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42943__$1,(13),inst_42921);
} else {
if((state_val_42944 === (9))){
var _ = (function (){var statearr_42960 = state_42943;
(statearr_42960[(4)] = cljs.core.rest((state_42943[(4)])));

return statearr_42960;
})();
var state_42943__$1 = state_42943;
var ex42956 = (state_42943__$1[(2)]);
var statearr_42961_42988 = state_42943__$1;
(statearr_42961_42988[(5)] = ex42956);


var statearr_42962_42989 = state_42943__$1;
(statearr_42962_42989[(1)] = (4));

(statearr_42962_42989[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (5))){
var inst_42889 = (state_42943[(7)]);
var _ = (function (){var statearr_42963 = state_42943;
(statearr_42963[(4)] = cljs.core.cons((8),(state_42943[(4)])));

return statearr_42963;
})();
var inst_42896 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42889,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_42964 = state_42943;
(statearr_42964[(4)] = cljs.core.rest((state_42943[(4)])));

return statearr_42964;
})();
var state_42943__$1 = state_42943;
var statearr_42965_42990 = state_42943__$1;
(statearr_42965_42990[(2)] = inst_42896);

(statearr_42965_42990[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (14))){
var state_42943__$1 = state_42943;
var statearr_42966_42991 = state_42943__$1;
(statearr_42966_42991[(2)] = null);

(statearr_42966_42991[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (16))){
var inst_42925 = (state_42943[(9)]);
var inst_42933 = (state_42943[(2)]);
var inst_42934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42935 = [inst_42933,inst_42925];
var inst_42936 = (new cljs.core.PersistentVector(null,2,(5),inst_42934,inst_42935,null));
var state_42943__$1 = state_42943;
var statearr_42968_42992 = state_42943__$1;
(statearr_42968_42992[(2)] = inst_42936);

(statearr_42968_42992[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (10))){
var inst_42908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42909 = [null,(0)];
var inst_42910 = (new cljs.core.PersistentVector(null,2,(5),inst_42908,inst_42909,null));
var state_42943__$1 = state_42943;
var statearr_42969_42993 = state_42943__$1;
(statearr_42969_42993[(2)] = inst_42910);

(statearr_42969_42993[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42944 === (8))){
var _ = (function (){var statearr_42970 = state_42943;
(statearr_42970[(4)] = cljs.core.rest((state_42943[(4)])));

return statearr_42970;
})();
var state_42943__$1 = state_42943;
var ex42967 = (state_42943__$1[(2)]);
var statearr_42971_42994 = state_42943__$1;
(statearr_42971_42994[(5)] = ex42967);


var statearr_42972_42995 = state_42943__$1;
(statearr_42972_42995[(1)] = (7));

(statearr_42972_42995[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____0 = (function (){
var statearr_42973 = [null,null,null,null,null,null,null,null,null,null];
(statearr_42973[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__);

(statearr_42973[(1)] = (1));

return statearr_42973;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____1 = (function (state_42943){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_42943);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e42974){var ex__16294__auto__ = e42974;
var statearr_42975_42996 = state_42943;
(statearr_42975_42996[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_42943[(4)]))){
var statearr_42976_42997 = state_42943;
(statearr_42976_42997[(1)] = cljs.core.first((state_42943[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__42998 = state_42943;
state_42943 = G__42998;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__ = function(state_42943){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____1.call(this,state_42943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_42977 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_42977[(6)] = c__16328__auto__);

return statearr_42977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43050){
var state_val_43051 = (state_43050[(1)]);
if((state_val_43051 === (7))){
var inst_43000 = (state_43050[(2)]);
var state_43050__$1 = state_43050;
var statearr_43052_43081 = state_43050__$1;
(statearr_43052_43081[(2)] = inst_43000);

(statearr_43052_43081[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (1))){
var state_43050__$1 = state_43050;
var statearr_43053_43082 = state_43050__$1;
(statearr_43053_43082[(2)] = null);

(statearr_43053_43082[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (4))){
var inst_42999 = (state_43050[(2)]);
var state_43050__$1 = (function (){var statearr_43054 = state_43050;
(statearr_43054[(7)] = inst_42999);

return statearr_43054;
})();
var statearr_43055_43083 = state_43050__$1;
(statearr_43055_43083[(2)] = null);

(statearr_43055_43083[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (13))){
var inst_43045 = (state_43050[(2)]);
var _ = (function (){var statearr_43056 = state_43050;
(statearr_43056[(4)] = cljs.core.rest((state_43050[(4)])));

return statearr_43056;
})();
var state_43050__$1 = state_43050;
var statearr_43057_43084 = state_43050__$1;
(statearr_43057_43084[(2)] = inst_43045);

(statearr_43057_43084[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (6))){
var inst_43009 = (state_43050[(2)]);
var state_43050__$1 = state_43050;
var statearr_43058_43085 = state_43050__$1;
(statearr_43058_43085[(2)] = inst_43009);

(statearr_43058_43085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (3))){
var inst_43048 = (state_43050[(2)]);
var state_43050__$1 = state_43050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43050__$1,inst_43048);
} else {
if((state_val_43051 === (12))){
var inst_43032 = (state_43050[(8)]);
var inst_43041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43042 = [null,inst_43032];
var inst_43043 = (new cljs.core.PersistentVector(null,2,(5),inst_43041,inst_43042,null));
var state_43050__$1 = state_43050;
var statearr_43059_43086 = state_43050__$1;
(statearr_43059_43086[(2)] = inst_43043);

(statearr_43059_43086[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (2))){
var _ = (function (){var statearr_43061 = state_43050;
(statearr_43061[(4)] = cljs.core.cons((9),(state_43050[(4)])));

return statearr_43061;
})();
var inst_43018 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_43019 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43021 = [null,pred_name,"?o"];
var inst_43022 = (new cljs.core.PersistentVector(null,3,(5),inst_43020,inst_43021,null));
var inst_43023 = [inst_43022];
var inst_43024 = (new cljs.core.PersistentVector(null,1,(5),inst_43019,inst_43023,null));
var inst_43025 = ["?o",inst_43024,opts];
var inst_43026 = cljs.core.PersistentHashMap.fromArrays(inst_43018,inst_43025);
var inst_43027 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_43026);
var state_43050__$1 = state_43050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43050__$1,(10),inst_43027);
} else {
if((state_val_43051 === (11))){
var inst_43031 = (state_43050[(9)]);
var inst_43032 = (state_43050[(8)]);
var inst_43036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43037 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_43031);
var inst_43038 = [inst_43037,inst_43032];
var inst_43039 = (new cljs.core.PersistentVector(null,2,(5),inst_43036,inst_43038,null));
var state_43050__$1 = state_43050;
var statearr_43062_43087 = state_43050__$1;
(statearr_43062_43087[(2)] = inst_43039);

(statearr_43062_43087[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (9))){
var _ = (function (){var statearr_43063 = state_43050;
(statearr_43063[(4)] = cljs.core.rest((state_43050[(4)])));

return statearr_43063;
})();
var state_43050__$1 = state_43050;
var ex43060 = (state_43050__$1[(2)]);
var statearr_43064_43088 = state_43050__$1;
(statearr_43064_43088[(5)] = ex43060);


var statearr_43065_43089 = state_43050__$1;
(statearr_43065_43089[(1)] = (4));

(statearr_43065_43089[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (5))){
var inst_42999 = (state_43050[(7)]);
var _ = (function (){var statearr_43067 = state_43050;
(statearr_43067[(4)] = cljs.core.cons((8),(state_43050[(4)])));

return statearr_43067;
})();
var inst_43006 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42999,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_43068 = state_43050;
(statearr_43068[(4)] = cljs.core.rest((state_43050[(4)])));

return statearr_43068;
})();
var state_43050__$1 = state_43050;
var statearr_43069_43090 = state_43050__$1;
(statearr_43069_43090[(2)] = inst_43006);

(statearr_43069_43090[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (10))){
var inst_43031 = (state_43050[(9)]);
var inst_43029 = (state_43050[(2)]);
var inst_43030 = fluree.db.util.async.throw_err(inst_43029);
var inst_43031__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43030,(0),null);
var inst_43032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43030,(1),null);
var inst_43033 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_43031__$1);
var inst_43034 = cljs.core.not(inst_43033);
var state_43050__$1 = (function (){var statearr_43070 = state_43050;
(statearr_43070[(9)] = inst_43031__$1);

(statearr_43070[(8)] = inst_43032);

return statearr_43070;
})();
if(inst_43034){
var statearr_43071_43091 = state_43050__$1;
(statearr_43071_43091[(1)] = (11));

} else {
var statearr_43072_43092 = state_43050__$1;
(statearr_43072_43092[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43051 === (8))){
var _ = (function (){var statearr_43073 = state_43050;
(statearr_43073[(4)] = cljs.core.rest((state_43050[(4)])));

return statearr_43073;
})();
var state_43050__$1 = state_43050;
var ex43066 = (state_43050__$1[(2)]);
var statearr_43074_43093 = state_43050__$1;
(statearr_43074_43093[(5)] = ex43066);


var statearr_43075_43094 = state_43050__$1;
(statearr_43075_43094[(1)] = (7));

(statearr_43075_43094[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____0 = (function (){
var statearr_43076 = [null,null,null,null,null,null,null,null,null,null];
(statearr_43076[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__);

(statearr_43076[(1)] = (1));

return statearr_43076;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____1 = (function (state_43050){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43050);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43077){var ex__16294__auto__ = e43077;
var statearr_43078_43095 = state_43050;
(statearr_43078_43095[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43050[(4)]))){
var statearr_43079_43096 = state_43050;
(statearr_43079_43096[(1)] = cljs.core.first((state_43050[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43097 = state_43050;
state_43050 = G__43097;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__ = function(state_43050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____1.call(this,state_43050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43080 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43080[(6)] = c__16328__auto__);

return statearr_43080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e43098){var e = e43098;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__43100 = arguments.length;
switch (G__43100) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43170){
var state_val_43171 = (state_43170[(1)]);
if((state_val_43171 === (7))){
var inst_43102 = (state_43170[(2)]);
var state_43170__$1 = state_43170;
var statearr_43172_43216 = state_43170__$1;
(statearr_43172_43216[(2)] = inst_43102);

(statearr_43172_43216[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (20))){
var inst_43146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43147 = ["*"];
var inst_43148 = (new cljs.core.PersistentVector(null,1,(5),inst_43146,inst_43147,null));
var state_43170__$1 = state_43170;
var statearr_43173_43217 = state_43170__$1;
(statearr_43173_43217[(2)] = inst_43148);

(statearr_43173_43217[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (1))){
var state_43170__$1 = state_43170;
var statearr_43174_43218 = state_43170__$1;
(statearr_43174_43218[(2)] = null);

(statearr_43174_43218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (4))){
var inst_43101 = (state_43170[(2)]);
var state_43170__$1 = (function (){var statearr_43175 = state_43170;
(statearr_43175[(7)] = inst_43101);

return statearr_43175;
})();
var statearr_43176_43219 = state_43170__$1;
(statearr_43176_43219[(2)] = null);

(statearr_43176_43219[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (15))){
var inst_43165 = (state_43170[(2)]);
var _ = (function (){var statearr_43177 = state_43170;
(statearr_43177[(4)] = cljs.core.rest((state_43170[(4)])));

return statearr_43177;
})();
var state_43170__$1 = state_43170;
var statearr_43178_43220 = state_43170__$1;
(statearr_43178_43220[(2)] = inst_43165);

(statearr_43178_43220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (21))){
var inst_43136 = (state_43170[(8)]);
var inst_43129 = (state_43170[(9)]);
var inst_43150 = (state_43170[(2)]);
var inst_43151 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_43152 = cljs.core.PersistentHashMap.EMPTY;
var inst_43153 = [inst_43150,inst_43136,inst_43152];
var inst_43154 = cljs.core.PersistentHashMap.fromArrays(inst_43151,inst_43153);
var inst_43155 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43129,inst_43154);
var state_43170__$1 = state_43170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43170__$1,(22),inst_43155);
} else {
if((state_val_43171 === (13))){
var inst_43124 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43170__$1 = state_43170;
var statearr_43179_43221 = state_43170__$1;
(statearr_43179_43221[(2)] = inst_43124);

(statearr_43179_43221[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (22))){
var inst_43157 = (state_43170[(2)]);
var inst_43158 = fluree.db.util.async.throw_err(inst_43157);
var inst_43159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43158,(0),null);
var inst_43160 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43158,(1),null);
var inst_43161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43162 = [inst_43159,inst_43160];
var inst_43163 = (new cljs.core.PersistentVector(null,2,(5),inst_43161,inst_43162,null));
var state_43170__$1 = state_43170;
var statearr_43180_43222 = state_43170__$1;
(statearr_43180_43222[(2)] = inst_43163);

(statearr_43180_43222[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (6))){
var inst_43111 = (state_43170[(2)]);
var state_43170__$1 = state_43170;
var statearr_43181_43223 = state_43170__$1;
(statearr_43181_43223[(2)] = inst_43111);

(statearr_43181_43223[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (17))){
var inst_43133 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43134 = fluree.db.dbfunctions.internal.get(inst_43133,cljs.core.cst$kw$_id);
var state_43170__$1 = state_43170;
var statearr_43182_43224 = state_43170__$1;
(statearr_43182_43224[(2)] = inst_43134);

(statearr_43182_43224[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (3))){
var inst_43168 = (state_43170[(2)]);
var state_43170__$1 = state_43170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43170__$1,inst_43168);
} else {
if((state_val_43171 === (12))){
var inst_43122 = (state_43170[(2)]);
var state_43170__$1 = state_43170;
if(cljs.core.truth_(inst_43122)){
var statearr_43183_43225 = state_43170__$1;
(statearr_43183_43225[(1)] = (13));

} else {
var statearr_43184_43226 = state_43170__$1;
(statearr_43184_43226[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (2))){
var inst_43117 = (state_43170[(10)]);
var _ = (function (){var statearr_43185 = state_43170;
(statearr_43185[(4)] = cljs.core.cons((9),(state_43170[(4)])));

return statearr_43185;
})();
var inst_43117__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43170__$1 = (function (){var statearr_43186 = state_43170;
(statearr_43186[(10)] = inst_43117__$1);

return statearr_43186;
})();
if(cljs.core.truth_(inst_43117__$1)){
var statearr_43187_43227 = state_43170__$1;
(statearr_43187_43227[(1)] = (10));

} else {
var statearr_43188_43228 = state_43170__$1;
(statearr_43188_43228[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (19))){
var inst_43138 = cljs.core.PersistentVector.EMPTY;
var inst_43139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43140 = ["*"];
var inst_43141 = (new cljs.core.PersistentVector(null,1,(5),inst_43139,inst_43140,null));
var inst_43142 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_43143 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_43141,inst_43142);
var inst_43144 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43138,inst_43143);
var state_43170__$1 = state_43170;
var statearr_43190_43229 = state_43170__$1;
(statearr_43190_43229[(2)] = inst_43144);

(statearr_43190_43229[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (11))){
var inst_43117 = (state_43170[(10)]);
var state_43170__$1 = state_43170;
var statearr_43191_43230 = state_43170__$1;
(statearr_43191_43230[(2)] = inst_43117);

(statearr_43191_43230[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (9))){
var _ = (function (){var statearr_43192 = state_43170;
(statearr_43192[(4)] = cljs.core.rest((state_43170[(4)])));

return statearr_43192;
})();
var state_43170__$1 = state_43170;
var ex43189 = (state_43170__$1[(2)]);
var statearr_43193_43231 = state_43170__$1;
(statearr_43193_43231[(5)] = ex43189);


var statearr_43194_43232 = state_43170__$1;
(statearr_43194_43232[(1)] = (4));

(statearr_43194_43232[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (5))){
var inst_43101 = (state_43170[(7)]);
var _ = (function (){var statearr_43195 = state_43170;
(statearr_43195[(4)] = cljs.core.cons((8),(state_43170[(4)])));

return statearr_43195;
})();
var inst_43108 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43101,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_43196 = state_43170;
(statearr_43196[(4)] = cljs.core.rest((state_43170[(4)])));

return statearr_43196;
})();
var state_43170__$1 = state_43170;
var statearr_43197_43233 = state_43170__$1;
(statearr_43197_43233[(2)] = inst_43108);

(statearr_43197_43233[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (14))){
var inst_43130 = (state_43170[(11)]);
var inst_43129 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43130__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43170__$1 = (function (){var statearr_43198 = state_43170;
(statearr_43198[(9)] = inst_43129);

(statearr_43198[(11)] = inst_43130__$1);

return statearr_43198;
})();
if(cljs.core.truth_(inst_43130__$1)){
var statearr_43199_43234 = state_43170__$1;
(statearr_43199_43234[(1)] = (16));

} else {
var statearr_43200_43235 = state_43170__$1;
(statearr_43200_43235[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (16))){
var inst_43130 = (state_43170[(11)]);
var state_43170__$1 = state_43170;
var statearr_43201_43236 = state_43170__$1;
(statearr_43201_43236[(2)] = inst_43130);

(statearr_43201_43236[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (10))){
var inst_43119 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_43170__$1 = state_43170;
var statearr_43203_43237 = state_43170__$1;
(statearr_43203_43237[(2)] = inst_43119);

(statearr_43203_43237[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (18))){
var inst_43136 = (state_43170[(2)]);
var state_43170__$1 = (function (){var statearr_43204 = state_43170;
(statearr_43204[(8)] = inst_43136);

return statearr_43204;
})();
if(cljs.core.truth_(additional_params)){
var statearr_43205_43238 = state_43170__$1;
(statearr_43205_43238[(1)] = (19));

} else {
var statearr_43206_43239 = state_43170__$1;
(statearr_43206_43239[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43171 === (8))){
var _ = (function (){var statearr_43207 = state_43170;
(statearr_43207[(4)] = cljs.core.rest((state_43170[(4)])));

return statearr_43207;
})();
var state_43170__$1 = state_43170;
var ex43202 = (state_43170__$1[(2)]);
var statearr_43208_43240 = state_43170__$1;
(statearr_43208_43240[(5)] = ex43202);


var statearr_43209_43241 = state_43170__$1;
(statearr_43209_43241[(1)] = (7));

(statearr_43209_43241[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16291__auto____0 = (function (){
var statearr_43210 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43210[(0)] = fluree$db$dbfunctions$internal$state_machine__16291__auto__);

(statearr_43210[(1)] = (1));

return statearr_43210;
});
var fluree$db$dbfunctions$internal$state_machine__16291__auto____1 = (function (state_43170){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43170);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43211){var ex__16294__auto__ = e43211;
var statearr_43212_43242 = state_43170;
(statearr_43212_43242[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43170[(4)]))){
var statearr_43213_43243 = state_43170;
(statearr_43213_43243[(1)] = cljs.core.first((state_43170[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43244 = state_43170;
state_43170 = G__43244;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16291__auto__ = function(state_43170){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____1.call(this,state_43170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43214 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43214[(6)] = c__16328__auto__);

return statearr_43214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__43246 = arguments.length;
switch (G__43246) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43290){
var state_val_43291 = (state_43290[(1)]);
if((state_val_43291 === (7))){
var inst_43268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43269 = ["*"];
var inst_43270 = (new cljs.core.PersistentVector(null,1,(5),inst_43268,inst_43269,null));
var state_43290__$1 = state_43290;
var statearr_43292_43312 = state_43290__$1;
(statearr_43292_43312[(2)] = inst_43270);

(statearr_43292_43312[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (1))){
var state_43290__$1 = state_43290;
var statearr_43293_43313 = state_43290__$1;
(statearr_43293_43313[(2)] = null);

(statearr_43293_43313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (4))){
var inst_43247 = (state_43290[(2)]);
var inst_43248 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43247,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_43290__$1 = state_43290;
var statearr_43294_43314 = state_43290__$1;
(statearr_43294_43314[(2)] = inst_43248);

(statearr_43294_43314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (6))){
var inst_43260 = cljs.core.PersistentVector.EMPTY;
var inst_43261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43262 = ["*"];
var inst_43263 = (new cljs.core.PersistentVector(null,1,(5),inst_43261,inst_43262,null));
var inst_43264 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_43265 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_43263,inst_43264);
var inst_43266 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43260,inst_43265);
var state_43290__$1 = state_43290;
var statearr_43295_43315 = state_43290__$1;
(statearr_43295_43315[(2)] = inst_43266);

(statearr_43295_43315[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (3))){
var inst_43288 = (state_43290[(2)]);
var state_43290__$1 = state_43290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43290__$1,inst_43288);
} else {
if((state_val_43291 === (2))){
var _ = (function (){var statearr_43297 = state_43290;
(statearr_43297[(4)] = cljs.core.cons((5),(state_43290[(4)])));

return statearr_43297;
})();
var inst_43257 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43258 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_43290__$1 = (function (){var statearr_43298 = state_43290;
(statearr_43298[(7)] = inst_43257);

(statearr_43298[(8)] = inst_43258);

return statearr_43298;
})();
if(cljs.core.truth_(additional_params)){
var statearr_43299_43316 = state_43290__$1;
(statearr_43299_43316[(1)] = (6));

} else {
var statearr_43300_43317 = state_43290__$1;
(statearr_43300_43317[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (9))){
var inst_43279 = (state_43290[(2)]);
var inst_43280 = fluree.db.util.async.throw_err(inst_43279);
var inst_43281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43280,(0),null);
var inst_43282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43280,(1),null);
var inst_43283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43284 = [inst_43281,inst_43282];
var inst_43285 = (new cljs.core.PersistentVector(null,2,(5),inst_43283,inst_43284,null));
var _ = (function (){var statearr_43301 = state_43290;
(statearr_43301[(4)] = cljs.core.rest((state_43290[(4)])));

return statearr_43301;
})();
var state_43290__$1 = state_43290;
var statearr_43302_43318 = state_43290__$1;
(statearr_43302_43318[(2)] = inst_43285);

(statearr_43302_43318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (5))){
var _ = (function (){var statearr_43303 = state_43290;
(statearr_43303[(4)] = cljs.core.rest((state_43290[(4)])));

return statearr_43303;
})();
var state_43290__$1 = state_43290;
var ex43296 = (state_43290__$1[(2)]);
var statearr_43304_43319 = state_43290__$1;
(statearr_43304_43319[(5)] = ex43296);


var statearr_43305_43320 = state_43290__$1;
(statearr_43305_43320[(1)] = (4));

(statearr_43305_43320[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43291 === (8))){
var inst_43257 = (state_43290[(7)]);
var inst_43258 = (state_43290[(8)]);
var inst_43272 = (state_43290[(2)]);
var inst_43273 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_43274 = cljs.core.PersistentHashMap.EMPTY;
var inst_43275 = [inst_43272,inst_43258,inst_43274];
var inst_43276 = cljs.core.PersistentHashMap.fromArrays(inst_43273,inst_43275);
var inst_43277 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43257,inst_43276);
var state_43290__$1 = state_43290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43290__$1,(9),inst_43277);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16291__auto____0 = (function (){
var statearr_43306 = [null,null,null,null,null,null,null,null,null];
(statearr_43306[(0)] = fluree$db$dbfunctions$internal$state_machine__16291__auto__);

(statearr_43306[(1)] = (1));

return statearr_43306;
});
var fluree$db$dbfunctions$internal$state_machine__16291__auto____1 = (function (state_43290){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43290);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43307){var ex__16294__auto__ = e43307;
var statearr_43308_43321 = state_43290;
(statearr_43308_43321[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43290[(4)]))){
var statearr_43309_43322 = state_43290;
(statearr_43309_43322[(1)] = cljs.core.first((state_43290[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43323 = state_43290;
state_43290 = G__43323;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16291__auto__ = function(state_43290){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16291__auto____1.call(this,state_43290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43310 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43310[(6)] = c__16328__auto__);

return statearr_43310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43367){
var state_val_43368 = (state_43367[(1)]);
if((state_val_43368 === (1))){
var state_43367__$1 = state_43367;
var statearr_43369_43383 = state_43367__$1;
(statearr_43369_43383[(2)] = null);

(statearr_43369_43383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43368 === (2))){
var _ = (function (){var statearr_43370 = state_43367;
(statearr_43370[(4)] = cljs.core.cons((5),(state_43367[(4)])));

return statearr_43370;
})();
var inst_43334 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_43335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43336 = ["_user/_auth"];
var inst_43337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43338 = ["*"];
var inst_43339 = (new cljs.core.PersistentVector(null,1,(5),inst_43337,inst_43338,null));
var inst_43340 = [inst_43339];
var inst_43341 = cljs.core.PersistentHashMap.fromArrays(inst_43336,inst_43340);
var inst_43342 = [inst_43341];
var inst_43343 = (new cljs.core.PersistentVector(null,1,(5),inst_43335,inst_43342,null));
var inst_43344 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43345 = cljs.core.PersistentHashMap.EMPTY;
var inst_43346 = [inst_43343,inst_43344,inst_43345];
var inst_43347 = cljs.core.PersistentHashMap.fromArrays(inst_43334,inst_43346);
var inst_43348 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43349 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43348,inst_43347);
var state_43367__$1 = state_43367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43367__$1,(6),inst_43349);
} else {
if((state_val_43368 === (3))){
var inst_43365 = (state_43367[(2)]);
var state_43367__$1 = state_43367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43367__$1,inst_43365);
} else {
if((state_val_43368 === (4))){
var inst_43324 = (state_43367[(2)]);
var inst_43325 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_43324,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_43367__$1 = state_43367;
var statearr_43372_43384 = state_43367__$1;
(statearr_43372_43384[(2)] = inst_43325);

(statearr_43372_43384[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43368 === (5))){
var _ = (function (){var statearr_43373 = state_43367;
(statearr_43373[(4)] = cljs.core.rest((state_43367[(4)])));

return statearr_43373;
})();
var state_43367__$1 = state_43367;
var ex43371 = (state_43367__$1[(2)]);
var statearr_43374_43385 = state_43367__$1;
(statearr_43374_43385[(5)] = ex43371);


var statearr_43375_43386 = state_43367__$1;
(statearr_43375_43386[(1)] = (4));

(statearr_43375_43386[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43368 === (6))){
var inst_43351 = (state_43367[(2)]);
var inst_43352 = fluree.db.util.async.throw_err(inst_43351);
var inst_43353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43352,(0),null);
var inst_43354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43352,(1),null);
var inst_43355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43356 = ["_user/_auth","_id"];
var inst_43357 = (new cljs.core.PersistentVector(null,2,(5),inst_43355,inst_43356,null));
var inst_43358 = fluree.db.dbfunctions.internal.get_in(inst_43353,inst_43357);
var inst_43359 = cljs.core.first(inst_43358);
var inst_43360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43361 = [inst_43359,inst_43354];
var inst_43362 = (new cljs.core.PersistentVector(null,2,(5),inst_43360,inst_43361,null));
var _ = (function (){var statearr_43376 = state_43367;
(statearr_43376[(4)] = cljs.core.rest((state_43367[(4)])));

return statearr_43376;
})();
var state_43367__$1 = state_43367;
var statearr_43377_43387 = state_43367__$1;
(statearr_43377_43387[(2)] = inst_43362);

(statearr_43377_43387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____0 = (function (){
var statearr_43378 = [null,null,null,null,null,null,null];
(statearr_43378[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__);

(statearr_43378[(1)] = (1));

return statearr_43378;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____1 = (function (state_43367){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43367);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43379){var ex__16294__auto__ = e43379;
var statearr_43380_43388 = state_43367;
(statearr_43380_43388[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43367[(4)]))){
var statearr_43381_43389 = state_43367;
(statearr_43381_43389[(1)] = cljs.core.first((state_43367[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43390 = state_43367;
state_43367 = G__43390;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__ = function(state_43367){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____1.call(this,state_43367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43382 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43382[(6)] = c__16328__auto__);

return statearr_43382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43407){
var state_val_43408 = (state_43407[(1)]);
if((state_val_43408 === (1))){
var state_43407__$1 = state_43407;
var statearr_43409_43423 = state_43407__$1;
(statearr_43409_43423[(2)] = null);

(statearr_43409_43423[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43408 === (2))){
var _ = (function (){var statearr_43410 = state_43407;
(statearr_43410[(4)] = cljs.core.cons((5),(state_43407[(4)])));

return statearr_43410;
})();
var inst_43397 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43398 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_43399 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_43398,inst_43397);
var state_43407__$1 = state_43407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43407__$1,(6),inst_43399);
} else {
if((state_val_43408 === (3))){
var inst_43405 = (state_43407[(2)]);
var state_43407__$1 = state_43407;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43407__$1,inst_43405);
} else {
if((state_val_43408 === (4))){
var inst_43391 = (state_43407[(2)]);
var state_43407__$1 = state_43407;
var statearr_43412_43424 = state_43407__$1;
(statearr_43412_43424[(2)] = inst_43391);

(statearr_43412_43424[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43408 === (5))){
var _ = (function (){var statearr_43413 = state_43407;
(statearr_43413[(4)] = cljs.core.rest((state_43407[(4)])));

return statearr_43413;
})();
var state_43407__$1 = state_43407;
var ex43411 = (state_43407__$1[(2)]);
var statearr_43414_43425 = state_43407__$1;
(statearr_43414_43425[(5)] = ex43411);


if((ex43411 instanceof Error)){
var statearr_43415_43426 = state_43407__$1;
(statearr_43415_43426[(1)] = (4));

(statearr_43415_43426[(5)] = null);

} else {
throw ex43411;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43408 === (6))){
var inst_43401 = (state_43407[(2)]);
var inst_43402 = fluree.db.util.async.throw_err(inst_43401);
var _ = (function (){var statearr_43416 = state_43407;
(statearr_43416[(4)] = cljs.core.rest((state_43407[(4)])));

return statearr_43416;
})();
var state_43407__$1 = state_43407;
var statearr_43417_43427 = state_43407__$1;
(statearr_43417_43427[(2)] = inst_43402);

(statearr_43417_43427[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____0 = (function (){
var statearr_43418 = [null,null,null,null,null,null,null];
(statearr_43418[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__);

(statearr_43418[(1)] = (1));

return statearr_43418;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____1 = (function (state_43407){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43407);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43419){var ex__16294__auto__ = e43419;
var statearr_43420_43428 = state_43407;
(statearr_43420_43428[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43407[(4)]))){
var statearr_43421_43429 = state_43407;
(statearr_43421_43429[(1)] = cljs.core.first((state_43407[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43430 = state_43407;
state_43407 = G__43430;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__ = function(state_43407){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____1.call(this,state_43407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43422 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43422[(6)] = c__16328__auto__);

return statearr_43422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__43431_SHARP_){
return p1__43431_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43432_SHARP_){
return p1__43432_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e43433){var e = e43433;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__43434_SHARP_){
return p1__43434_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43435_SHARP_){
return p1__43435_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e43436){var e = e43436;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__43438 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__43438);
})() | (0));
return num;
}catch (e43437){var e = e43437;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16328__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16329__auto__ = (function (){var switch__16290__auto__ = (function (state_43538){
var state_val_43539 = (state_43538[(1)]);
if((state_val_43539 === (7))){
var state_43538__$1 = state_43538;
var statearr_43540_43588 = state_43538__$1;
(statearr_43540_43588[(2)] = false);

(statearr_43540_43588[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (20))){
var inst_43473 = (state_43538[(7)]);
var inst_43472 = (state_43538[(8)]);
var inst_43494 = (state_43538[(2)]);
var inst_43495 = fluree.db.dbproto._p_prop(inst_43473,cljs.core.cst$kw$multi,inst_43472);
var state_43538__$1 = (function (){var statearr_43541 = state_43538;
(statearr_43541[(9)] = inst_43494);

return statearr_43541;
})();
if(cljs.core.truth_(inst_43495)){
var statearr_43542_43589 = state_43538__$1;
(statearr_43542_43589[(1)] = (21));

} else {
var statearr_43543_43590 = state_43538__$1;
(statearr_43543_43590[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (27))){
var inst_43533 = (state_43538[(2)]);
var _ = (function (){var statearr_43544 = state_43538;
(statearr_43544[(4)] = cljs.core.rest((state_43538[(4)])));

return statearr_43544;
})();
var state_43538__$1 = state_43538;
var statearr_43545_43591 = state_43538__$1;
(statearr_43545_43591[(2)] = inst_43533);

(statearr_43545_43591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (1))){
var state_43538__$1 = state_43538;
var statearr_43546_43592 = state_43538__$1;
(statearr_43546_43592[(2)] = null);

(statearr_43546_43592[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (24))){
var inst_43522 = (state_43538[(10)]);
var inst_43518 = (state_43538[(2)]);
var inst_43519 = fluree.db.util.async.throw_err(inst_43518);
var inst_43520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43519,(0),null);
var inst_43521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_43519,(1),null);
var inst_43522__$1 = cljs.core.first(inst_43520);
var inst_43523 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43522__$1,compare_val);
var state_43538__$1 = (function (){var statearr_43547 = state_43538;
(statearr_43547[(11)] = inst_43521);

(statearr_43547[(10)] = inst_43522__$1);

return statearr_43547;
})();
if(inst_43523){
var statearr_43548_43593 = state_43538__$1;
(statearr_43548_43593[(1)] = (25));

} else {
var statearr_43549_43594 = state_43538__$1;
(statearr_43549_43594[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (4))){
var inst_43439 = (state_43538[(2)]);
var state_43538__$1 = state_43538;
var statearr_43550_43595 = state_43538__$1;
(statearr_43550_43595[(2)] = inst_43439);

(statearr_43550_43595[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (15))){
var state_43538__$1 = state_43538;
var statearr_43551_43596 = state_43538__$1;
(statearr_43551_43596[(2)] = null);

(statearr_43551_43596[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (21))){
var inst_43474 = (state_43538[(12)]);
var inst_43497 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_43474], 0));
var inst_43498 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43499 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_43500 = cljs.core.PersistentHashMap.fromArrays(inst_43498,inst_43499);
var inst_43501 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43497,inst_43500);
var inst_43502 = (function(){throw inst_43501})();
var state_43538__$1 = state_43538;
var statearr_43552_43597 = state_43538__$1;
(statearr_43552_43597[(2)] = inst_43502);

(statearr_43552_43597[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (13))){
var inst_43449 = (state_43538[(13)]);
var state_43538__$1 = state_43538;
var statearr_43553_43598 = state_43538__$1;
(statearr_43553_43598[(2)] = inst_43449);

(statearr_43553_43598[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (22))){
var state_43538__$1 = state_43538;
var statearr_43554_43599 = state_43538__$1;
(statearr_43554_43599[(2)] = null);

(statearr_43554_43599[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (6))){
var inst_43449 = (state_43538[(13)]);
var inst_43454 = inst_43449.cljs$lang$protocol_mask$partition0$;
var inst_43455 = (inst_43454 & (64));
var inst_43456 = inst_43449.cljs$core$ISeq$;
var inst_43457 = (cljs.core.PROTOCOL_SENTINEL === inst_43456);
var inst_43458 = ((inst_43455) || (inst_43457));
var state_43538__$1 = state_43538;
if(cljs.core.truth_(inst_43458)){
var statearr_43555_43600 = state_43538__$1;
(statearr_43555_43600[(1)] = (9));

} else {
var statearr_43556_43601 = state_43538__$1;
(statearr_43556_43601[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (25))){
var state_43538__$1 = state_43538;
var statearr_43557_43602 = state_43538__$1;
(statearr_43557_43602[(2)] = new_val);

(statearr_43557_43602[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (17))){
var inst_43474 = (state_43538[(12)]);
var inst_43484 = (state_43538[(2)]);
var state_43538__$1 = (function (){var statearr_43558 = state_43538;
(statearr_43558[(14)] = inst_43484);

return statearr_43558;
})();
if(cljs.core.truth_(inst_43474)){
var statearr_43559_43603 = state_43538__$1;
(statearr_43559_43603[(1)] = (18));

} else {
var statearr_43560_43604 = state_43538__$1;
(statearr_43560_43604[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (3))){
var inst_43536 = (state_43538[(2)]);
var state_43538__$1 = state_43538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43538__$1,inst_43536);
} else {
if((state_val_43539 === (12))){
var inst_43449 = (state_43538[(13)]);
var inst_43467 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_43449);
var state_43538__$1 = state_43538;
var statearr_43561_43605 = state_43538__$1;
(statearr_43561_43605[(2)] = inst_43467);

(statearr_43561_43605[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (2))){
var inst_43449 = (state_43538[(13)]);
var _ = (function (){var statearr_43562 = state_43538;
(statearr_43562[(4)] = cljs.core.cons((5),(state_43538[(4)])));

return statearr_43562;
})();
var inst_43449__$1 = _QMARK_ctx;
var inst_43451 = (inst_43449__$1 == null);
var inst_43452 = cljs.core.not(inst_43451);
var state_43538__$1 = (function (){var statearr_43563 = state_43538;
(statearr_43563[(13)] = inst_43449__$1);

return statearr_43563;
})();
if(inst_43452){
var statearr_43564_43606 = state_43538__$1;
(statearr_43564_43606[(1)] = (6));

} else {
var statearr_43565_43607 = state_43538__$1;
(statearr_43565_43607[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (23))){
var inst_43473 = (state_43538[(7)]);
var inst_43471 = (state_43538[(15)]);
var inst_43474 = (state_43538[(12)]);
var inst_43505 = (state_43538[(2)]);
var inst_43506 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_43507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43509 = [inst_43471,inst_43474,"?current-val"];
var inst_43510 = (new cljs.core.PersistentVector(null,3,(5),inst_43508,inst_43509,null));
var inst_43511 = [inst_43510];
var inst_43512 = (new cljs.core.PersistentVector(null,1,(5),inst_43507,inst_43511,null));
var inst_43513 = cljs.core.PersistentHashMap.EMPTY;
var inst_43514 = ["?current-val",inst_43512,inst_43513];
var inst_43515 = cljs.core.PersistentHashMap.fromArrays(inst_43506,inst_43514);
var inst_43516 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_43473,inst_43515);
var state_43538__$1 = (function (){var statearr_43566 = state_43538;
(statearr_43566[(16)] = inst_43505);

return statearr_43566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43538__$1,(24),inst_43516);
} else {
if((state_val_43539 === (19))){
var inst_43487 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_43488 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43489 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_43490 = cljs.core.PersistentHashMap.fromArrays(inst_43488,inst_43489);
var inst_43491 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43487,inst_43490);
var inst_43492 = (function(){throw inst_43491})();
var state_43538__$1 = state_43538;
var statearr_43567_43608 = state_43538__$1;
(statearr_43567_43608[(2)] = inst_43492);

(statearr_43567_43608[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (11))){
var inst_43462 = (state_43538[(2)]);
var state_43538__$1 = state_43538;
var statearr_43569_43609 = state_43538__$1;
(statearr_43569_43609[(2)] = inst_43462);

(statearr_43569_43609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (9))){
var state_43538__$1 = state_43538;
var statearr_43570_43610 = state_43538__$1;
(statearr_43570_43610[(2)] = true);

(statearr_43570_43610[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (5))){
var _ = (function (){var statearr_43571 = state_43538;
(statearr_43571[(4)] = cljs.core.rest((state_43538[(4)])));

return statearr_43571;
})();
var state_43538__$1 = state_43538;
var ex43568 = (state_43538__$1[(2)]);
var statearr_43572_43611 = state_43538__$1;
(statearr_43572_43611[(5)] = ex43568);


if((ex43568 instanceof Error)){
var statearr_43573_43612 = state_43538__$1;
(statearr_43573_43612[(1)] = (4));

(statearr_43573_43612[(5)] = null);

} else {
throw ex43568;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (14))){
var inst_43473 = (state_43538[(7)]);
var inst_43471 = (state_43538[(15)]);
var inst_43472 = (state_43538[(8)]);
var inst_43470 = (state_43538[(2)]);
var inst_43471__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43470,cljs.core.cst$kw$sid);
var inst_43472__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43470,cljs.core.cst$kw$pid);
var inst_43473__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43470,cljs.core.cst$kw$db);
var inst_43474 = fluree.db.dbproto._p_prop(inst_43473__$1,cljs.core.cst$kw$name,inst_43472__$1);
var state_43538__$1 = (function (){var statearr_43574 = state_43538;
(statearr_43574[(7)] = inst_43473__$1);

(statearr_43574[(15)] = inst_43471__$1);

(statearr_43574[(8)] = inst_43472__$1);

(statearr_43574[(12)] = inst_43474);

return statearr_43574;
})();
if(cljs.core.truth_(inst_43471__$1)){
var statearr_43575_43613 = state_43538__$1;
(statearr_43575_43613[(1)] = (15));

} else {
var statearr_43576_43614 = state_43538__$1;
(statearr_43576_43614[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (26))){
var inst_43522 = (state_43538[(10)]);
var inst_43526 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43522)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_43527 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43528 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_43529 = cljs.core.PersistentHashMap.fromArrays(inst_43527,inst_43528);
var inst_43530 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43526,inst_43529);
var inst_43531 = (function(){throw inst_43530})();
var state_43538__$1 = state_43538;
var statearr_43577_43615 = state_43538__$1;
(statearr_43577_43615[(2)] = inst_43531);

(statearr_43577_43615[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (16))){
var inst_43477 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_43478 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43479 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_43480 = cljs.core.PersistentHashMap.fromArrays(inst_43478,inst_43479);
var inst_43481 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43477,inst_43480);
var inst_43482 = (function(){throw inst_43481})();
var state_43538__$1 = state_43538;
var statearr_43578_43616 = state_43538__$1;
(statearr_43578_43616[(2)] = inst_43482);

(statearr_43578_43616[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (10))){
var state_43538__$1 = state_43538;
var statearr_43579_43617 = state_43538__$1;
(statearr_43579_43617[(2)] = false);

(statearr_43579_43617[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (18))){
var state_43538__$1 = state_43538;
var statearr_43580_43618 = state_43538__$1;
(statearr_43580_43618[(2)] = null);

(statearr_43580_43618[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43539 === (8))){
var inst_43465 = (state_43538[(2)]);
var state_43538__$1 = state_43538;
if(cljs.core.truth_(inst_43465)){
var statearr_43581_43619 = state_43538__$1;
(statearr_43581_43619[(1)] = (12));

} else {
var statearr_43582_43620 = state_43538__$1;
(statearr_43582_43620[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____0 = (function (){
var statearr_43583 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43583[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__);

(statearr_43583[(1)] = (1));

return statearr_43583;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____1 = (function (state_43538){
while(true){
var ret_value__16292__auto__ = (function (){try{while(true){
var result__16293__auto__ = switch__16290__auto__(state_43538);
if(cljs.core.keyword_identical_QMARK_(result__16293__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16293__auto__;
}
break;
}
}catch (e43584){var ex__16294__auto__ = e43584;
var statearr_43585_43621 = state_43538;
(statearr_43585_43621[(2)] = ex__16294__auto__);


if(cljs.core.seq((state_43538[(4)]))){
var statearr_43586_43622 = state_43538;
(statearr_43586_43622[(1)] = cljs.core.first((state_43538[(4)])));

} else {
throw ex__16294__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16292__auto__,cljs.core.cst$kw$recur)){
var G__43623 = state_43538;
state_43538 = G__43623;
continue;
} else {
return ret_value__16292__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__ = function(state_43538){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____1.call(this,state_43538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16291__auto__;
})()
})();
var state__16330__auto__ = (function (){var statearr_43587 = (f__16329__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16329__auto__.cljs$core$IFn$_invoke$arity$0() : f__16329__auto__.call(null));
(statearr_43587[(6)] = c__16328__auto__);

return statearr_43587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16330__auto__);
}));

return c__16328__auto__;
});
