// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.call(null,self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer.call(null,writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count.call(null,self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item = cljs.core.first.call(null,cljs.core.val.call(null,f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key.call(null,f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count.call(null,self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first.call(null,self__.priority__GT_set_of_items);
var item_set = cljs.core.val.call(null,f);
var item = cljs.core.first.call(null,item_set);
var priority_key = cljs.core.key.call(null,f);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37933(s__37934){
return (new cljs.core.LazySeq(null,(function (){
var s__37934__$1 = s__37934;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37934__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37939 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37939,(0),null);
var item_set = cljs.core.nth.call(null,vec__37939,(1),null);
var iterys__4525__auto__ = ((function (s__37934__$1,vec__37939,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37933_$_iter__37935(s__37936){
return (new cljs.core.LazySeq(null,((function (s__37934__$1,vec__37939,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__37936__$1 = s__37936;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37936__$1);
if(temp__5735__auto____$1){
var s__37936__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37936__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37936__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37938 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37937 = (0);
while(true){
if((i__37937 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37937);
cljs.core.chunk_append.call(null,b__37938,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37987 = (i__37937 + (1));
i__37937 = G__37987;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37938),tailrecursion$priority_map$iter__37933_$_iter__37935.call(null,cljs.core.chunk_rest.call(null,s__37936__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37938),null);
}
} else {
var item = cljs.core.first.call(null,s__37936__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37933_$_iter__37935.call(null,cljs.core.rest.call(null,s__37936__$2)));
}
} else {
return null;
}
break;
}
});})(s__37934__$1,vec__37939,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__37934__$1,vec__37939,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37933.call(null,cljs.core.rest.call(null,s__37934__$1)));
} else {
var G__37988 = cljs.core.rest.call(null,s__37934__$1);
s__37934__$1 = G__37988;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37942(s__37943){
return (new cljs.core.LazySeq(null,(function (){
var s__37943__$1 = s__37943;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37943__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37948 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37948,(0),null);
var item_set = cljs.core.nth.call(null,vec__37948,(1),null);
var iterys__4525__auto__ = ((function (s__37943__$1,vec__37948,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__37942_$_iter__37944(s__37945){
return (new cljs.core.LazySeq(null,((function (s__37943__$1,vec__37948,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1){
return (function (){
var s__37945__$1 = s__37945;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37945__$1);
if(temp__5735__auto____$1){
var s__37945__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37945__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37945__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37947 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37946 = (0);
while(true){
if((i__37946 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37946);
cljs.core.chunk_append.call(null,b__37947,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37989 = (i__37946 + (1));
i__37946 = G__37989;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37947),tailrecursion$priority_map$iter__37942_$_iter__37944.call(null,cljs.core.chunk_rest.call(null,s__37945__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37947),null);
}
} else {
var item = cljs.core.first.call(null,s__37945__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37942_$_iter__37944.call(null,cljs.core.rest.call(null,s__37945__$2)));
}
} else {
return null;
}
break;
}
});})(s__37943__$1,vec__37948,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
,null,null));
});})(s__37943__$1,vec__37948,priority,item_set,xs__6292__auto__,temp__5735__auto__,coll__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37942.call(null,cljs.core.rest.call(null,s__37943__$1)));
} else {
var G__37990 = cljs.core.rest.call(null,s__37943__$1);
s__37943__$1 = G__37990;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,cljs.core.rseq.call(null,self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = cljs.core.hash_unordered_coll.call(null,this$__$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv.call(null,self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = self__.item__GT_priority.call(null,item,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517));
if(cljs.core._EQ_.call(null,priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var item_set = self__.priority__GT_set_of_items.call(null,priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.disj.call(null,item_set,item)),cljs.core.dissoc.call(null,self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5733__auto__ = cljs.core.get.call(null,self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5733__auto__)){
var current_priority = temp__5733__auto__;
if(cljs.core._EQ_.call(null,current_priority,priority)){
return this$__$1;
} else {
var priority_key = self__.keyfn.call(null,priority);
var current_priority_key = self__.keyfn.call(null,current_priority);
var item_set = cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.call(null,cljs.core.count.call(null,item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,cljs.core.dissoc.call(null,self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,current_priority_key),item),priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = self__.keyfn.call(null,priority);
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.conj.call(null,cljs.core.get.call(null,self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.call(null,self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_.call(null,self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37951(s__37952){
return (new cljs.core.LazySeq(null,(function (){
var s__37952__$1 = s__37952;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37952__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37957 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37957,(0),null);
var item_set = cljs.core.nth.call(null,vec__37957,(1),null);
var iterys__4525__auto__ = ((function (s__37952__$1,vec__37957,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37951_$_iter__37953(s__37954){
return (new cljs.core.LazySeq(null,((function (s__37952__$1,vec__37957,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__37954__$1 = s__37954;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37954__$1);
if(temp__5735__auto____$1){
var s__37954__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37954__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37954__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37956 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37955 = (0);
while(true){
if((i__37955 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37955);
cljs.core.chunk_append.call(null,b__37956,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37991 = (i__37955 + (1));
i__37955 = G__37991;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37956),tailrecursion$priority_map$iter__37951_$_iter__37953.call(null,cljs.core.chunk_rest.call(null,s__37954__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37956),null);
}
} else {
var item = cljs.core.first.call(null,s__37954__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37951_$_iter__37953.call(null,cljs.core.rest.call(null,s__37954__$2)));
}
} else {
return null;
}
break;
}
});})(s__37952__$1,vec__37957,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__37952__$1,vec__37957,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37951.call(null,cljs.core.rest.call(null,s__37952__$1)));
} else {
var G__37992 = cljs.core.rest.call(null,s__37952__$1);
s__37952__$1 = G__37992;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37960(s__37961){
return (new cljs.core.LazySeq(null,(function (){
var s__37961__$1 = s__37961;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37961__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37966 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37966,(0),null);
var item_set = cljs.core.nth.call(null,vec__37966,(1),null);
var iterys__4525__auto__ = ((function (s__37961__$1,vec__37966,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__37960_$_iter__37962(s__37963){
return (new cljs.core.LazySeq(null,((function (s__37961__$1,vec__37966,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1){
return (function (){
var s__37963__$1 = s__37963;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37963__$1);
if(temp__5735__auto____$1){
var s__37963__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37963__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37963__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37965 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37964 = (0);
while(true){
if((i__37964 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37964);
cljs.core.chunk_append.call(null,b__37965,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37993 = (i__37964 + (1));
i__37964 = G__37993;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37965),tailrecursion$priority_map$iter__37960_$_iter__37962.call(null,cljs.core.chunk_rest.call(null,s__37963__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37965),null);
}
} else {
var item = cljs.core.first.call(null,s__37963__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37960_$_iter__37962.call(null,cljs.core.rest.call(null,s__37963__$2)));
}
} else {
return null;
}
break;
}
});})(s__37961__$1,vec__37966,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
,null,null));
});})(s__37961__$1,vec__37966,priority,item_set,xs__6292__auto__,temp__5735__auto__,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37960.call(null,cljs.core.rest.call(null,s__37961__$1)));
} else {
var G__37994 = cljs.core.rest.call(null,s__37961__$1);
s__37961__$1 = G__37994;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry)){
return cljs.core._assoc.call(null,this$__$1,cljs.core._nth.call(null,entry,(0)),cljs.core._nth.call(null,entry,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__37995 = null;
var G__37995__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item);
});
var G__37995__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return cljs.core._lookup.call(null,this$,item,not_found);
});
G__37995 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__37995__2.call(this,self__,item);
case 3:
return G__37995__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__37995.cljs$core$IFn$_invoke$arity$2 = G__37995__2;
G__37995.cljs$core$IFn$_invoke$arity$3 = G__37995__3;
return G__37995;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args37932){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone.call(null,args37932)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return cljs.core._lookup.call(null,this$,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
return (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq).call(null,this$__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.call(null,self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.call(null,self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37969(s__37970){
return (new cljs.core.LazySeq(null,(function (){
var s__37970__$1 = s__37970;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37970__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37975 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37975,(0),null);
var item_set = cljs.core.nth.call(null,vec__37975,(1),null);
var iterys__4525__auto__ = ((function (s__37970__$1,vec__37975,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37969_$_iter__37971(s__37972){
return (new cljs.core.LazySeq(null,((function (s__37970__$1,vec__37975,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__37972__$1 = s__37972;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37972__$1);
if(temp__5735__auto____$1){
var s__37972__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37972__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37972__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37974 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37973 = (0);
while(true){
if((i__37973 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37973);
cljs.core.chunk_append.call(null,b__37974,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null));

var G__37996 = (i__37973 + (1));
i__37973 = G__37996;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37974),tailrecursion$priority_map$iter__37969_$_iter__37971.call(null,cljs.core.chunk_rest.call(null,s__37972__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37974),null);
}
} else {
var item = cljs.core.first.call(null,s__37972__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,self__.item__GT_priority.call(null,item)], null),tailrecursion$priority_map$iter__37969_$_iter__37971.call(null,cljs.core.rest.call(null,s__37972__$2)));
}
} else {
return null;
}
break;
}
});})(s__37970__$1,vec__37975,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__37970__$1,vec__37975,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37969.call(null,cljs.core.rest.call(null,s__37970__$1)));
} else {
var G__37997 = cljs.core.rest.call(null,s__37970__$1);
s__37970__$1 = G__37997;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
} else {
return cljs.core.seq.call(null,(function (){var iter__4529__auto__ = (function tailrecursion$priority_map$iter__37978(s__37979){
return (new cljs.core.LazySeq(null,(function (){
var s__37979__$1 = s__37979;
while(true){
var temp__5735__auto__ = cljs.core.seq.call(null,s__37979__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__37984 = cljs.core.first.call(null,xs__6292__auto__);
var priority = cljs.core.nth.call(null,vec__37984,(0),null);
var item_set = cljs.core.nth.call(null,vec__37984,(1),null);
var iterys__4525__auto__ = ((function (s__37979__$1,vec__37984,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__37978_$_iter__37980(s__37981){
return (new cljs.core.LazySeq(null,((function (s__37979__$1,vec__37984,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1){
return (function (){
var s__37981__$1 = s__37981;
while(true){
var temp__5735__auto____$1 = cljs.core.seq.call(null,s__37981__$1);
if(temp__5735__auto____$1){
var s__37981__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,s__37981__$2)){
var c__4527__auto__ = cljs.core.chunk_first.call(null,s__37981__$2);
var size__4528__auto__ = cljs.core.count.call(null,c__4527__auto__);
var b__37983 = cljs.core.chunk_buffer.call(null,size__4528__auto__);
if((function (){var i__37982 = (0);
while(true){
if((i__37982 < size__4528__auto__)){
var item = cljs.core._nth.call(null,c__4527__auto__,i__37982);
cljs.core.chunk_append.call(null,b__37983,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__37998 = (i__37982 + (1));
i__37982 = G__37998;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37983),tailrecursion$priority_map$iter__37978_$_iter__37980.call(null,cljs.core.chunk_rest.call(null,s__37981__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__37983),null);
}
} else {
var item = cljs.core.first.call(null,s__37981__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__37978_$_iter__37980.call(null,cljs.core.rest.call(null,s__37981__$2)));
}
} else {
return null;
}
break;
}
});})(s__37979__$1,vec__37984,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
,null,null));
});})(s__37979__$1,vec__37984,priority,item_set,xs__6292__auto__,temp__5735__auto__,sets,this$__$1))
;
var fs__4526__auto__ = cljs.core.seq.call(null,iterys__4525__auto__.call(null,item_set));
if(fs__4526__auto__){
return cljs.core.concat.call(null,fs__4526__auto__,tailrecursion$priority_map$iter__37978.call(null,cljs.core.rest.call(null,s__37979__$1)));
} else {
var G__37999 = cljs.core.rest.call(null,s__37979__$1);
s__37979__$1 = G__37999;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__.call(null,sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
return self__.keyfn.call(null,cljs.core.val.call(null,entry));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write.call(null,writer__4370__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__38001 = arguments.length;
switch (G__38001) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map.call(null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by.call(null,comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_.call(null,elems)){
return cljs.core.into.call(null,tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_.call(null,"tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38004 = arguments.length;
var i__4737__auto___38005 = (0);
while(true){
if((i__4737__auto___38005 < len__4736__auto___38004)){
args__4742__auto__.push((arguments[i__4737__auto___38005]));

var G__38006 = (i__4737__auto___38005 + (1));
i__4737__auto___38005 = G__38006;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__38007 = cljs.core.nnext.call(null,in$);
var G__38008 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38007;
out = G__38008;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq38003){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq38003));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38011 = arguments.length;
var i__4737__auto___38012 = (0);
while(true){
if((i__4737__auto___38012 < len__4736__auto___38011)){
args__4742__auto__.push((arguments[i__4737__auto___38012]));

var G__38013 = (i__4737__auto___38012 + (1));
i__4737__auto___38012 = G__38013;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_by.call(null,comparator);
while(true){
if(in$){
var G__38014 = cljs.core.nnext.call(null,in$);
var G__38015 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38014;
out = G__38015;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq38009){
var G__38010 = cljs.core.first.call(null,seq38009);
var seq38009__$1 = cljs.core.next.call(null,seq38009);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38010,seq38009__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38018 = arguments.length;
var i__4737__auto___38019 = (0);
while(true){
if((i__4737__auto___38019 < len__4736__auto___38018)){
args__4742__auto__.push((arguments[i__4737__auto___38019]));

var G__38020 = (i__4737__auto___38019 + (1));
i__4737__auto___38019 = G__38020;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn);
while(true){
if(in$){
var G__38021 = cljs.core.nnext.call(null,in$);
var G__38022 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38021;
out = G__38022;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq38016){
var G__38017 = cljs.core.first.call(null,seq38016);
var seq38016__$1 = cljs.core.next.call(null,seq38016);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38017,seq38016__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4742__auto__ = [];
var len__4736__auto___38026 = arguments.length;
var i__4737__auto___38027 = (0);
while(true){
if((i__4737__auto___38027 < len__4736__auto___38026)){
args__4742__auto__.push((arguments[i__4737__auto___38027]));

var G__38028 = (i__4737__auto___38027 + (1));
i__4737__auto___38027 = G__38028;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq.call(null,keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.call(null,keyfn,comparator);
while(true){
if(in$){
var G__38029 = cljs.core.nnext.call(null,in$);
var G__38030 = cljs.core.assoc.call(null,out,cljs.core.first.call(null,in$),cljs.core.second.call(null,in$));
in$ = G__38029;
out = G__38030;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq38023){
var G__38024 = cljs.core.first.call(null,seq38023);
var seq38023__$1 = cljs.core.next.call(null,seq38023);
var G__38025 = cljs.core.first.call(null,seq38023__$1);
var seq38023__$2 = cljs.core.next.call(null,seq38023__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38024,G__38025,seq38023__$2);
}));

