// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k38117,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__38121 = k38117;
var G__38121__$1 = (((G__38121 instanceof cljs.core.Keyword))?G__38121.fqn:null);
switch (G__38121__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k38117,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__38122){
var vec__38123 = p__38122;
var k__4403__auto__ = cljs.core.nth.call(null,vec__38123,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__38123,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__38116){
var self__ = this;
var G__38116__$1 = this;
return (new cljs.core.RecordIter((0),G__38116__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this38118,other38119){
var self__ = this;
var this38118__$1 = this;
return (((!((other38119 == null)))) && ((this38118__$1.constructor === other38119.constructor)) && (cljs.core._EQ_.call(null,this38118__$1.conn,other38119.conn)) && (cljs.core._EQ_.call(null,this38118__$1.network,other38119.network)) && (cljs.core._EQ_.call(null,this38118__$1.dbid,other38119.dbid)) && (cljs.core._EQ_.call(null,this38118__$1.db_name,other38119.db_name)) && (cljs.core._EQ_.call(null,this38118__$1.update_chan,other38119.update_chan)) && (cljs.core._EQ_.call(null,this38118__$1.transact_chan,other38119.transact_chan)) && (cljs.core._EQ_.call(null,this38118__$1.state,other38119.state)) && (cljs.core._EQ_.call(null,this38118__$1.schema_cache,other38119.schema_cache)) && (cljs.core._EQ_.call(null,this38118__$1.blank_db,other38119.blank_db)) && (cljs.core._EQ_.call(null,this38118__$1.close,other38119.close)) && (cljs.core._EQ_.call(null,this38118__$1.id,other38119.id)) && (cljs.core._EQ_.call(null,this38118__$1.__extmap,other38119.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__38116){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__38126 = cljs.core.keyword_identical_QMARK_;
var expr__38127 = k__4388__auto__;
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__38127))){
return (new fluree.db.session.DbSession(G__38116,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,G__38116,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__38116,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__38116,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__38116,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__38116,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__38116,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__38116,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__38116,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__38116,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__38126.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__38127))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__38116,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__38116),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__38116){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__38116,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__38120){
var extmap__4419__auto__ = (function (){var G__38129 = cljs.core.dissoc.call(null,G__38120,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__38120)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__38129);
} else {
return G__38129;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__38120),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__38120),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__38131 = session;
var map__38131__$1 = (((((!((map__38131 == null))))?(((((map__38131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38131.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38131):map__38131);
var network = cljs.core.get.call(null,map__38131__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__38131__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__11542__auto___38349 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38276){
var state_val_38277 = (state_38276[(1)]);
if((state_val_38277 === (7))){
var state_38276__$1 = state_38276;
var statearr_38278_38350 = state_38276__$1;
(statearr_38278_38350[(2)] = false);

(statearr_38278_38350[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (20))){
var inst_38173 = (state_38276[(7)]);
var inst_38166 = (state_38276[(8)]);
var inst_38165 = (state_38276[(9)]);
var inst_38182 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38173);
var inst_38183 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38165),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38166)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38182),"."].join('');
var state_38276__$1 = state_38276;
var statearr_38279_38351 = state_38276__$1;
(statearr_38279_38351[(2)] = inst_38183);

(statearr_38279_38351[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (27))){
var inst_38257 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
var statearr_38280_38352 = state_38276__$1;
(statearr_38280_38352[(2)] = inst_38257);

(statearr_38280_38352[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (1))){
var state_38276__$1 = state_38276;
var statearr_38281_38353 = state_38276__$1;
(statearr_38281_38353[(2)] = null);

(statearr_38281_38353[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (24))){
var state_38276__$1 = state_38276;
var statearr_38282_38354 = state_38276__$1;
(statearr_38282_38354[(2)] = null);

(statearr_38282_38354[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (39))){
var state_38276__$1 = state_38276;
var statearr_38283_38355 = state_38276__$1;
(statearr_38283_38355[(2)] = false);

(statearr_38283_38355[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (46))){
var inst_38265 = (state_38276[(10)]);
var inst_38268 = (state_38276[(2)]);
var inst_38269 = fluree.db.util.async.throw_err.call(null,inst_38268);
var inst_38270 = cljs.core.assoc.call(null,inst_38265,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_38269);
var inst_38271 = cljs.core.async.put_BANG_.call(null,pc,inst_38270);
var _ = (function (){var statearr_38284 = state_38276;
(statearr_38284[(4)] = cljs.core.rest.call(null,(state_38276[(4)])));

return statearr_38284;
})();
var state_38276__$1 = state_38276;
var statearr_38285_38356 = state_38276__$1;
(statearr_38285_38356[(2)] = inst_38271);

(statearr_38285_38356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (4))){
var inst_38133 = (state_38276[(2)]);
var inst_38134 = cljs.core.async.put_BANG_.call(null,pc,inst_38133);
var state_38276__$1 = state_38276;
var statearr_38286_38357 = state_38276__$1;
(statearr_38286_38357[(2)] = inst_38134);

(statearr_38286_38357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (15))){
var inst_38173 = (state_38276[(7)]);
var inst_38172 = (state_38276[(2)]);
var inst_38173__$1 = fluree.db.util.async.throw_err.call(null,inst_38172);
var inst_38174 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_38173__$1);
var inst_38175 = cljs.core.keyword.call(null,inst_38174);
var inst_38176 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_38175);
var state_38276__$1 = (function (){var statearr_38287 = state_38276;
(statearr_38287[(7)] = inst_38173__$1);

return statearr_38287;
})();
if(inst_38176){
var statearr_38288_38358 = state_38276__$1;
(statearr_38288_38358[(1)] = (16));

} else {
var statearr_38289_38359 = state_38276__$1;
(statearr_38289_38359[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (21))){
var inst_38185 = (state_38276[(2)]);
var inst_38186 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38187 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_38188 = cljs.core.PersistentHashMap.fromArrays(inst_38186,inst_38187);
var inst_38189 = cljs.core.ex_info.call(null,inst_38185,inst_38188);
var inst_38190 = (function(){throw inst_38189})();
var state_38276__$1 = state_38276;
var statearr_38290_38360 = state_38276__$1;
(statearr_38290_38360[(2)] = inst_38190);

(statearr_38290_38360[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (31))){
var inst_38212 = (state_38276[(11)]);
var inst_38211 = (state_38276[(2)]);
var inst_38212__$1 = fluree.db.util.async.throw_err.call(null,inst_38211);
var state_38276__$1 = (function (){var statearr_38291 = state_38276;
(statearr_38291[(11)] = inst_38212__$1);

return statearr_38291;
})();
if(cljs.core.truth_(inst_38212__$1)){
var statearr_38292_38361 = state_38276__$1;
(statearr_38292_38361[(1)] = (32));

} else {
var statearr_38293_38362 = state_38276__$1;
(statearr_38293_38362[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (32))){
var inst_38212 = (state_38276[(11)]);
var inst_38216 = (inst_38212 == null);
var inst_38217 = cljs.core.not.call(null,inst_38216);
var state_38276__$1 = state_38276;
if(inst_38217){
var statearr_38294_38363 = state_38276__$1;
(statearr_38294_38363[(1)] = (35));

} else {
var statearr_38295_38364 = state_38276__$1;
(statearr_38295_38364[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (40))){
var inst_38227 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
var statearr_38296_38365 = state_38276__$1;
(statearr_38296_38365[(2)] = inst_38227);

(statearr_38296_38365[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (33))){
var inst_38204 = (state_38276[(12)]);
var inst_38166 = (state_38276[(8)]);
var inst_38165 = (state_38276[(9)]);
var inst_38246 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38204)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38165),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38166),"."].join('');
var inst_38247 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_38248 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_38249 = cljs.core.PersistentHashMap.fromArrays(inst_38247,inst_38248);
var inst_38250 = cljs.core.ex_info.call(null,inst_38246,inst_38249);
var inst_38251 = (function(){throw inst_38250})();
var state_38276__$1 = state_38276;
var statearr_38297_38366 = state_38276__$1;
(statearr_38297_38366[(2)] = inst_38251);

(statearr_38297_38366[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (13))){
var inst_38142 = (state_38276[(13)]);
var state_38276__$1 = state_38276;
var statearr_38298_38367 = state_38276__$1;
(statearr_38298_38367[(2)] = inst_38142);

(statearr_38298_38367[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (22))){
var inst_38198 = (state_38276[(14)]);
var inst_38173 = (state_38276[(7)]);
var inst_38197 = (state_38276[(2)]);
var inst_38198__$1 = fluree.db.util.async.throw_err.call(null,inst_38197);
var inst_38199 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38173);
var state_38276__$1 = (function (){var statearr_38299 = state_38276;
(statearr_38299[(14)] = inst_38198__$1);

(statearr_38299[(15)] = inst_38199);

return statearr_38299;
})();
if(cljs.core.truth_(inst_38198__$1)){
var statearr_38300_38368 = state_38276__$1;
(statearr_38300_38368[(1)] = (23));

} else {
var statearr_38301_38369 = state_38276__$1;
(statearr_38301_38369[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (36))){
var state_38276__$1 = state_38276;
var statearr_38302_38370 = state_38276__$1;
(statearr_38302_38370[(2)] = false);

(statearr_38302_38370[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (41))){
var inst_38212 = (state_38276[(11)]);
var inst_38232 = cljs.core.apply.call(null,cljs.core.hash_map,inst_38212);
var state_38276__$1 = state_38276;
var statearr_38303_38371 = state_38276__$1;
(statearr_38303_38371[(2)] = inst_38232);

(statearr_38303_38371[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (43))){
var inst_38203 = (state_38276[(16)]);
var inst_38235 = (state_38276[(2)]);
var inst_38236 = cljs.core.get.call(null,inst_38235,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_38237 = cljs.core.get.call(null,inst_38235,new cljs.core.Keyword(null,"block","block",664686210));
var inst_38238 = cljs.core.get.call(null,inst_38235,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_38239 = fluree.db.dbproto._with.call(null,inst_38203,inst_38237,inst_38236);
var state_38276__$1 = (function (){var statearr_38304 = state_38276;
(statearr_38304[(17)] = inst_38238);

return statearr_38304;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(44),inst_38239);
} else {
if((state_val_38277 === (29))){
var inst_38204 = (state_38276[(12)]);
var inst_38166 = (state_38276[(8)]);
var inst_38164 = (state_38276[(18)]);
var inst_38165 = (state_38276[(9)]);
var inst_38209 = fluree.db.storage.core.read_block.call(null,inst_38164,inst_38165,inst_38166,inst_38204);
var state_38276__$1 = state_38276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(31),inst_38209);
} else {
if((state_val_38277 === (44))){
var inst_38204 = (state_38276[(12)]);
var inst_38241 = (state_38276[(2)]);
var inst_38242 = fluree.db.util.async.throw_err.call(null,inst_38241);
var inst_38243 = (inst_38204 + (1));
var inst_38203 = inst_38242;
var inst_38204__$1 = inst_38243;
var state_38276__$1 = (function (){var statearr_38305 = state_38276;
(statearr_38305[(16)] = inst_38203);

(statearr_38305[(12)] = inst_38204__$1);

return statearr_38305;
})();
var statearr_38306_38372 = state_38276__$1;
(statearr_38306_38372[(2)] = null);

(statearr_38306_38372[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (6))){
var inst_38142 = (state_38276[(13)]);
var inst_38147 = inst_38142.cljs$lang$protocol_mask$partition0$;
var inst_38148 = (inst_38147 & (64));
var inst_38149 = inst_38142.cljs$core$ISeq$;
var inst_38150 = (cljs.core.PROTOCOL_SENTINEL === inst_38149);
var inst_38151 = ((inst_38148) || (inst_38150));
var state_38276__$1 = state_38276;
if(cljs.core.truth_(inst_38151)){
var statearr_38307_38373 = state_38276__$1;
(statearr_38307_38373[(1)] = (9));

} else {
var statearr_38308_38374 = state_38276__$1;
(statearr_38308_38374[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (28))){
var inst_38203 = (state_38276[(16)]);
var state_38276__$1 = state_38276;
var statearr_38309_38375 = state_38276__$1;
(statearr_38309_38375[(2)] = inst_38203);

(statearr_38309_38375[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (25))){
var inst_38260 = (state_38276[(19)]);
var inst_38260__$1 = (state_38276[(2)]);
var inst_38261 = fluree.db.query.schema.schema_map.call(null,inst_38260__$1);
var state_38276__$1 = (function (){var statearr_38310 = state_38276;
(statearr_38310[(19)] = inst_38260__$1);

return statearr_38310;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(45),inst_38261);
} else {
if((state_val_38277 === (34))){
var inst_38253 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
var statearr_38311_38376 = state_38276__$1;
(statearr_38311_38376[(2)] = inst_38253);

(statearr_38311_38376[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (17))){
var state_38276__$1 = state_38276;
var statearr_38312_38377 = state_38276__$1;
(statearr_38312_38377[(2)] = null);

(statearr_38312_38377[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (3))){
var inst_38274 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38276__$1,inst_38274);
} else {
if((state_val_38277 === (12))){
var inst_38142 = (state_38276[(13)]);
var inst_38160 = cljs.core.apply.call(null,cljs.core.hash_map,inst_38142);
var state_38276__$1 = state_38276;
var statearr_38313_38378 = state_38276__$1;
(statearr_38313_38378[(2)] = inst_38160);

(statearr_38313_38378[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (2))){
var inst_38142 = (state_38276[(13)]);
var _ = (function (){var statearr_38314 = state_38276;
(statearr_38314[(4)] = cljs.core.cons.call(null,(5),(state_38276[(4)])));

return statearr_38314;
})();
var inst_38141 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_38142__$1 = session;
var inst_38144 = (inst_38142__$1 == null);
var inst_38145 = cljs.core.not.call(null,inst_38144);
var state_38276__$1 = (function (){var statearr_38315 = state_38276;
(statearr_38315[(20)] = inst_38141);

(statearr_38315[(13)] = inst_38142__$1);

return statearr_38315;
})();
if(inst_38145){
var statearr_38316_38379 = state_38276__$1;
(statearr_38316_38379[(1)] = (6));

} else {
var statearr_38317_38380 = state_38276__$1;
(statearr_38317_38380[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (23))){
var inst_38198 = (state_38276[(14)]);
var inst_38201 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38198);
var inst_38202 = (inst_38201 + (1));
var inst_38203 = inst_38198;
var inst_38204 = inst_38202;
var state_38276__$1 = (function (){var statearr_38318 = state_38276;
(statearr_38318[(16)] = inst_38203);

(statearr_38318[(12)] = inst_38204);

return statearr_38318;
})();
var statearr_38319_38381 = state_38276__$1;
(statearr_38319_38381[(2)] = null);

(statearr_38319_38381[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (35))){
var inst_38212 = (state_38276[(11)]);
var inst_38219 = inst_38212.cljs$lang$protocol_mask$partition0$;
var inst_38220 = (inst_38219 & (64));
var inst_38221 = inst_38212.cljs$core$ISeq$;
var inst_38222 = (cljs.core.PROTOCOL_SENTINEL === inst_38221);
var inst_38223 = ((inst_38220) || (inst_38222));
var state_38276__$1 = state_38276;
if(cljs.core.truth_(inst_38223)){
var statearr_38320_38382 = state_38276__$1;
(statearr_38320_38382[(1)] = (38));

} else {
var statearr_38321_38383 = state_38276__$1;
(statearr_38321_38383[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (19))){
var inst_38166 = (state_38276[(8)]);
var inst_38165 = (state_38276[(9)]);
var inst_38180 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38165),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38166)," is not found on this ledger group."].join('');
var state_38276__$1 = state_38276;
var statearr_38322_38384 = state_38276__$1;
(statearr_38322_38384[(2)] = inst_38180);

(statearr_38322_38384[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (11))){
var inst_38155 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
var statearr_38324_38385 = state_38276__$1;
(statearr_38324_38385[(2)] = inst_38155);

(statearr_38324_38385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (9))){
var state_38276__$1 = state_38276;
var statearr_38325_38386 = state_38276__$1;
(statearr_38325_38386[(2)] = true);

(statearr_38325_38386[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (5))){
var _ = (function (){var statearr_38326 = state_38276;
(statearr_38326[(4)] = cljs.core.rest.call(null,(state_38276[(4)])));

return statearr_38326;
})();
var state_38276__$1 = state_38276;
var ex38323 = (state_38276__$1[(2)]);
var statearr_38327_38387 = state_38276__$1;
(statearr_38327_38387[(5)] = ex38323);


var statearr_38328_38388 = state_38276__$1;
(statearr_38328_38388[(1)] = (4));

(statearr_38328_38388[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (14))){
var inst_38166 = (state_38276[(8)]);
var inst_38164 = (state_38276[(18)]);
var inst_38165 = (state_38276[(9)]);
var inst_38163 = (state_38276[(2)]);
var inst_38164__$1 = cljs.core.get.call(null,inst_38163,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_38165__$1 = cljs.core.get.call(null,inst_38163,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_38166__$1 = cljs.core.get.call(null,inst_38163,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_38167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38168 = [inst_38165__$1,inst_38166__$1];
var inst_38169 = (new cljs.core.PersistentVector(null,2,(5),inst_38167,inst_38168,null));
var inst_38170 = fluree.db.operations.ledger_info_async.call(null,inst_38164__$1,inst_38169);
var state_38276__$1 = (function (){var statearr_38329 = state_38276;
(statearr_38329[(8)] = inst_38166__$1);

(statearr_38329[(18)] = inst_38164__$1);

(statearr_38329[(9)] = inst_38165__$1);

return statearr_38329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(15),inst_38170);
} else {
if((state_val_38277 === (45))){
var inst_38260 = (state_38276[(19)]);
var inst_38265 = (state_38276[(10)]);
var inst_38263 = (state_38276[(2)]);
var inst_38264 = fluree.db.util.async.throw_err.call(null,inst_38263);
var inst_38265__$1 = cljs.core.assoc.call(null,inst_38260,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_38264);
var inst_38266 = fluree.db.query.schema.setting_map.call(null,inst_38265__$1);
var state_38276__$1 = (function (){var statearr_38330 = state_38276;
(statearr_38330[(10)] = inst_38265__$1);

return statearr_38330;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(46),inst_38266);
} else {
if((state_val_38277 === (26))){
var inst_38204 = (state_38276[(12)]);
var inst_38199 = (state_38276[(15)]);
var inst_38206 = (inst_38204 > inst_38199);
var state_38276__$1 = state_38276;
if(cljs.core.truth_(inst_38206)){
var statearr_38331_38389 = state_38276__$1;
(statearr_38331_38389[(1)] = (28));

} else {
var statearr_38332_38390 = state_38276__$1;
(statearr_38332_38390[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (16))){
var inst_38173 = (state_38276[(7)]);
var inst_38178 = cljs.core.empty_QMARK_.call(null,inst_38173);
var state_38276__$1 = state_38276;
if(inst_38178){
var statearr_38333_38391 = state_38276__$1;
(statearr_38333_38391[(1)] = (19));

} else {
var statearr_38334_38392 = state_38276__$1;
(statearr_38334_38392[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (38))){
var state_38276__$1 = state_38276;
var statearr_38335_38393 = state_38276__$1;
(statearr_38335_38393[(2)] = true);

(statearr_38335_38393[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (30))){
var inst_38255 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
var statearr_38336_38394 = state_38276__$1;
(statearr_38336_38394[(2)] = inst_38255);

(statearr_38336_38394[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (10))){
var state_38276__$1 = state_38276;
var statearr_38337_38395 = state_38276__$1;
(statearr_38337_38395[(2)] = false);

(statearr_38337_38395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (18))){
var inst_38173 = (state_38276[(7)]);
var inst_38141 = (state_38276[(20)]);
var inst_38166 = (state_38276[(8)]);
var inst_38164 = (state_38276[(18)]);
var inst_38165 = (state_38276[(9)]);
var inst_38193 = (state_38276[(2)]);
var inst_38194 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_38173);
var inst_38195 = fluree.db.storage.core.reify_db.call(null,inst_38164,inst_38165,inst_38166,inst_38141,inst_38194);
var state_38276__$1 = (function (){var statearr_38338 = state_38276;
(statearr_38338[(21)] = inst_38193);

return statearr_38338;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38276__$1,(22),inst_38195);
} else {
if((state_val_38277 === (42))){
var inst_38212 = (state_38276[(11)]);
var state_38276__$1 = state_38276;
var statearr_38339_38396 = state_38276__$1;
(statearr_38339_38396[(2)] = inst_38212);

(statearr_38339_38396[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (37))){
var inst_38230 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
if(cljs.core.truth_(inst_38230)){
var statearr_38340_38397 = state_38276__$1;
(statearr_38340_38397[(1)] = (41));

} else {
var statearr_38341_38398 = state_38276__$1;
(statearr_38341_38398[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38277 === (8))){
var inst_38158 = (state_38276[(2)]);
var state_38276__$1 = state_38276;
if(cljs.core.truth_(inst_38158)){
var statearr_38342_38399 = state_38276__$1;
(statearr_38342_38399[(1)] = (12));

} else {
var statearr_38343_38400 = state_38276__$1;
(statearr_38343_38400[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____0 = (function (){
var statearr_38344 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38344[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__);

(statearr_38344[(1)] = (1));

return statearr_38344;
});
var fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____1 = (function (state_38276){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38345){var ex__11472__auto__ = e38345;
var statearr_38346_38401 = state_38276;
(statearr_38346_38401[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38276[(4)]))){
var statearr_38347_38402 = state_38276;
(statearr_38347_38402[(1)] = cljs.core.first.call(null,(state_38276[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38403 = state_38276;
state_38276 = G__38403;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__ = function(state_38276){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____1.call(this,state_38276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__11469__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38348 = f__11543__auto__.call(null);
(statearr_38348[(6)] = c__11542__auto___38349);

return statearr_38348;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__38404 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__38404,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__38404;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38406){
var state_val_38407 = (state_38406[(1)]);
if((state_val_38407 === (1))){
var state_38406__$1 = state_38406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38406__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11469__auto__ = null;
var fluree$db$session$state_machine__11469__auto____0 = (function (){
var statearr_38408 = [null,null,null,null,null,null,null];
(statearr_38408[(0)] = fluree$db$session$state_machine__11469__auto__);

(statearr_38408[(1)] = (1));

return statearr_38408;
});
var fluree$db$session$state_machine__11469__auto____1 = (function (state_38406){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38409){var ex__11472__auto__ = e38409;
var statearr_38410_38413 = state_38406;
(statearr_38410_38413[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38406[(4)]))){
var statearr_38411_38414 = state_38406;
(statearr_38411_38414[(1)] = cljs.core.first.call(null,(state_38406[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38415 = state_38406;
state_38406 = G__38415;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$state_machine__11469__auto__ = function(state_38406){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11469__auto____1.call(this,state_38406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11469__auto____0;
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11469__auto____1;
return fluree$db$session$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38412 = f__11543__auto__.call(null);
(statearr_38412[(6)] = c__11542__auto__);

return statearr_38412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__38417){
var map__38418 = p__38417;
var map__38418__$1 = (((((!((map__38418 == null))))?(((((map__38418.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38418.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38418):map__38418);
var data = map__38418__$1;
var block = cljs.core.get.call(null,map__38418__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__38418__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__38418__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38478){
var state_val_38479 = (state_38478[(1)]);
if((state_val_38479 === (7))){
var inst_38433 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38434 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38435 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38433),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38434),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_38436 = fluree.db.util.log.info.call(null,inst_38435);
var state_38478__$1 = state_38478;
var statearr_38480_38514 = state_38478__$1;
(statearr_38480_38514[(2)] = inst_38436);

(statearr_38480_38514[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (1))){
var state_38478__$1 = state_38478;
var statearr_38481_38515 = state_38478__$1;
(statearr_38481_38515[(2)] = null);

(statearr_38481_38515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (4))){
var inst_38420 = (state_38478[(2)]);
var state_38478__$1 = state_38478;
var statearr_38482_38516 = state_38478__$1;
(statearr_38482_38516[(2)] = inst_38420);

(statearr_38482_38516[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (15))){
var inst_38459 = (state_38478[(2)]);
var state_38478__$1 = state_38478;
var statearr_38483_38517 = state_38478__$1;
(statearr_38483_38517[(2)] = inst_38459);

(statearr_38483_38517[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (13))){
var inst_38450 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_38451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38452 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38453 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38454 = [inst_38452,inst_38453];
var inst_38455 = (new cljs.core.PersistentVector(null,2,(5),inst_38451,inst_38454,null));
var inst_38456 = fluree.db.conn_events.process_event.call(null,inst_38450,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_38455,data);
var state_38478__$1 = state_38478;
var statearr_38484_38518 = state_38478__$1;
(statearr_38484_38518[(2)] = inst_38456);

(statearr_38484_38518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (6))){
var inst_38429 = (state_38478[(7)]);
var inst_38430 = (state_38478[(8)]);
var inst_38428 = (state_38478[(2)]);
var inst_38429__$1 = fluree.db.util.async.throw_err.call(null,inst_38428);
var inst_38430__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_38429__$1);
var inst_38431 = (block <= inst_38430__$1);
var state_38478__$1 = (function (){var statearr_38485 = state_38478;
(statearr_38485[(7)] = inst_38429__$1);

(statearr_38485[(8)] = inst_38430__$1);

return statearr_38485;
})();
if(cljs.core.truth_(inst_38431)){
var statearr_38486_38519 = state_38478__$1;
(statearr_38486_38519[(1)] = (7));

} else {
var statearr_38487_38520 = state_38478__$1;
(statearr_38487_38520[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (17))){
var state_38478__$1 = state_38478;
var statearr_38488_38521 = state_38478__$1;
(statearr_38488_38521[(2)] = null);

(statearr_38488_38521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (3))){
var inst_38476 = (state_38478[(2)]);
var state_38478__$1 = state_38478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38478__$1,inst_38476);
} else {
if((state_val_38479 === (12))){
var inst_38471 = (state_38478[(2)]);
var state_38478__$1 = state_38478;
var statearr_38489_38522 = state_38478__$1;
(statearr_38489_38522[(2)] = inst_38471);

(statearr_38489_38522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (2))){
var inst_38426 = (state_38478[(9)]);
var _ = (function (){var statearr_38490 = state_38478;
(statearr_38490[(4)] = cljs.core.cons.call(null,(5),(state_38478[(4)])));

return statearr_38490;
})();
var inst_38426__$1 = fluree.db.session.current_db.call(null,session);
var state_38478__$1 = (function (){var statearr_38491 = state_38478;
(statearr_38491[(9)] = inst_38426__$1);

return statearr_38491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38478__$1,(6),inst_38426__$1);
} else {
if((state_val_38479 === (11))){
var state_38478__$1 = state_38478;
var statearr_38493_38523 = state_38478__$1;
(statearr_38493_38523[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (9))){
var inst_38473 = (state_38478[(2)]);
var _ = (function (){var statearr_38495 = state_38478;
(statearr_38495[(4)] = cljs.core.rest.call(null,(state_38478[(4)])));

return statearr_38495;
})();
var state_38478__$1 = state_38478;
var statearr_38496_38524 = state_38478__$1;
(statearr_38496_38524[(2)] = inst_38473);

(statearr_38496_38524[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (5))){
var _ = (function (){var statearr_38497 = state_38478;
(statearr_38497[(4)] = cljs.core.rest.call(null,(state_38478[(4)])));

return statearr_38497;
})();
var state_38478__$1 = state_38478;
var ex38492 = (state_38478__$1[(2)]);
var statearr_38498_38525 = state_38478__$1;
(statearr_38498_38525[(5)] = ex38492);


if((ex38492 instanceof Error)){
var statearr_38499_38526 = state_38478__$1;
(statearr_38499_38526[(1)] = (4));

(statearr_38499_38526[(5)] = null);

} else {
throw ex38492;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (14))){
var state_38478__$1 = state_38478;
var statearr_38500_38527 = state_38478__$1;
(statearr_38500_38527[(2)] = null);

(statearr_38500_38527[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (16))){
var inst_38430 = (state_38478[(8)]);
var inst_38462 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38463 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38464 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38462),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38463),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38430),". Forcing a db reload."].join('');
var inst_38465 = fluree.db.util.log.info.call(null,inst_38464);
var inst_38466 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_38478__$1 = (function (){var statearr_38501 = state_38478;
(statearr_38501[(10)] = inst_38465);

return statearr_38501;
})();
var statearr_38502_38528 = state_38478__$1;
(statearr_38502_38528[(2)] = inst_38466);

(statearr_38502_38528[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (10))){
var inst_38429 = (state_38478[(7)]);
var inst_38430 = (state_38478[(8)]);
var inst_38426 = (state_38478[(9)]);
var inst_38441 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38442 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38443 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38441),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38442),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_38444 = fluree.db.util.log.trace.call(null,inst_38443);
var inst_38445 = (function (){var current_db_ch = inst_38426;
var current_db = inst_38429;
var current_block = inst_38430;
return (function (p1__38416_SHARP_){
if((p1__38416_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__38416_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__38416_SHARP_);
}
});
})();
var inst_38446 = cljs.core.map.call(null,inst_38445,flakes);
var inst_38447 = fluree.db.dbproto._with.call(null,inst_38429,block,inst_38446);
var inst_38448 = fluree.db.session.cas_db_BANG_.call(null,session,inst_38426,inst_38447);
var state_38478__$1 = (function (){var statearr_38503 = state_38478;
(statearr_38503[(11)] = inst_38444);

return statearr_38503;
})();
if(inst_38448){
var statearr_38504_38529 = state_38478__$1;
(statearr_38504_38529[(1)] = (13));

} else {
var statearr_38505_38530 = state_38478__$1;
(statearr_38505_38530[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (18))){
var inst_38469 = (state_38478[(2)]);
var state_38478__$1 = state_38478;
var statearr_38506_38531 = state_38478__$1;
(statearr_38506_38531[(2)] = inst_38469);

(statearr_38506_38531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38479 === (8))){
var inst_38430 = (state_38478[(8)]);
var inst_38438 = ((1) + inst_38430);
var inst_38439 = cljs.core._EQ_.call(null,block,inst_38438);
var state_38478__$1 = state_38478;
if(inst_38439){
var statearr_38507_38532 = state_38478__$1;
(statearr_38507_38532[(1)] = (10));

} else {
var statearr_38508_38533 = state_38478__$1;
(statearr_38508_38533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11469__auto__ = null;
var fluree$db$session$state_machine__11469__auto____0 = (function (){
var statearr_38509 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38509[(0)] = fluree$db$session$state_machine__11469__auto__);

(statearr_38509[(1)] = (1));

return statearr_38509;
});
var fluree$db$session$state_machine__11469__auto____1 = (function (state_38478){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38510){var ex__11472__auto__ = e38510;
var statearr_38511_38534 = state_38478;
(statearr_38511_38534[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38478[(4)]))){
var statearr_38512_38535 = state_38478;
(statearr_38512_38535[(1)] = cljs.core.first.call(null,(state_38478[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38536 = state_38478;
state_38478 = G__38536;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$state_machine__11469__auto__ = function(state_38478){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11469__auto____1.call(this,state_38478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11469__auto____0;
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11469__auto____1;
return fluree$db$session$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38513 = f__11543__auto__.call(null);
(statearr_38513[(6)] = c__11542__auto__);

return statearr_38513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38543){
var state_val_38544 = (state_38543[(1)]);
if((state_val_38544 === (1))){
var inst_38537 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_38538 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_38539 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_38540 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38538),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38539)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_38541 = fluree.db.util.log.debug.call(null,inst_38540);
var state_38543__$1 = (function (){var statearr_38545 = state_38543;
(statearr_38545[(7)] = inst_38541);

(statearr_38545[(8)] = inst_38537);

return statearr_38545;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38543__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__11469__auto__ = null;
var fluree$db$session$state_machine__11469__auto____0 = (function (){
var statearr_38546 = [null,null,null,null,null,null,null,null,null];
(statearr_38546[(0)] = fluree$db$session$state_machine__11469__auto__);

(statearr_38546[(1)] = (1));

return statearr_38546;
});
var fluree$db$session$state_machine__11469__auto____1 = (function (state_38543){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38547){var ex__11472__auto__ = e38547;
var statearr_38548_38551 = state_38543;
(statearr_38548_38551[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38543[(4)]))){
var statearr_38549_38552 = state_38543;
(statearr_38549_38552[(1)] = cljs.core.first.call(null,(state_38543[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38553 = state_38543;
state_38543 = G__38553;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$state_machine__11469__auto__ = function(state_38543){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11469__auto____1.call(this,state_38543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11469__auto____0;
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11469__auto____1;
return fluree$db$session$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38550 = f__11543__auto__.call(null);
(statearr_38550[(6)] = c__11542__auto__);

return statearr_38550;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__38555 = arguments.length;
switch (G__38555) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__38556 = session;
var map__38556__$1 = (((((!((map__38556 == null))))?(((((map__38556.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38556.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38556):map__38556);
var conn = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__38556__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38611){
var state_val_38612 = (state_38611[(1)]);
if((state_val_38612 === (7))){
var inst_38607 = (state_38611[(2)]);
var state_38611__$1 = state_38611;
var statearr_38613_38644 = state_38611__$1;
(statearr_38613_38644[(2)] = inst_38607);

(statearr_38613_38644[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (1))){
var state_38611__$1 = state_38611;
var statearr_38614_38645 = state_38611__$1;
(statearr_38614_38645[(2)] = null);

(statearr_38614_38645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (4))){
var inst_38562 = (state_38611[(7)]);
var inst_38561 = (state_38611[(2)]);
var inst_38562__$1 = fluree.db.util.async.throw_err.call(null,inst_38561);
var inst_38563 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_38564 = (inst_38562__$1 == null);
var state_38611__$1 = (function (){var statearr_38615 = state_38611;
(statearr_38615[(7)] = inst_38562__$1);

(statearr_38615[(8)] = inst_38563);

return statearr_38615;
})();
if(cljs.core.truth_(inst_38564)){
var statearr_38616_38646 = state_38611__$1;
(statearr_38616_38646[(1)] = (5));

} else {
var statearr_38617_38647 = state_38611__$1;
(statearr_38617_38647[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (15))){
var inst_38599 = (state_38611[(2)]);
var state_38611__$1 = (function (){var statearr_38618 = state_38611;
(statearr_38618[(9)] = inst_38599);

return statearr_38618;
})();
var statearr_38619_38648 = state_38611__$1;
(statearr_38619_38648[(2)] = null);

(statearr_38619_38648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (13))){
var inst_38603 = (state_38611[(2)]);
var state_38611__$1 = state_38611;
var statearr_38621_38649 = state_38611__$1;
(statearr_38621_38649[(2)] = inst_38603);

(statearr_38621_38649[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (6))){
var inst_38563 = (state_38611[(8)]);
var inst_38569 = (inst_38563 == null);
var state_38611__$1 = state_38611;
if(cljs.core.truth_(inst_38569)){
var statearr_38622_38650 = state_38611__$1;
(statearr_38622_38650[(1)] = (8));

} else {
var statearr_38623_38651 = state_38611__$1;
(statearr_38623_38651[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (17))){
var _ = (function (){var statearr_38624 = state_38611;
(statearr_38624[(4)] = cljs.core.rest.call(null,(state_38611[(4)])));

return statearr_38624;
})();
var state_38611__$1 = state_38611;
var ex38620 = (state_38611__$1[(2)]);
var statearr_38625_38652 = state_38611__$1;
(statearr_38625_38652[(5)] = ex38620);


var statearr_38626_38653 = state_38611__$1;
(statearr_38626_38653[(1)] = (16));

(statearr_38626_38653[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (3))){
var inst_38609 = (state_38611[(2)]);
var state_38611__$1 = state_38611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38611__$1,inst_38609);
} else {
if((state_val_38612 === (12))){
var state_38611__$1 = state_38611;
var statearr_38627_38654 = state_38611__$1;
(statearr_38627_38654[(2)] = null);

(statearr_38627_38654[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (2))){
var state_38611__$1 = state_38611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38611__$1,(4),update_chan);
} else {
if((state_val_38612 === (11))){
var state_38611__$1 = state_38611;
var statearr_38628_38655 = state_38611__$1;
(statearr_38628_38655[(2)] = null);

(statearr_38628_38655[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (9))){
var state_38611__$1 = state_38611;
var statearr_38629_38656 = state_38611__$1;
(statearr_38629_38656[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (5))){
var inst_38566 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_38567 = fluree.db.util.log.info.call(null,inst_38566);
var state_38611__$1 = state_38611;
var statearr_38631_38657 = state_38611__$1;
(statearr_38631_38657[(2)] = inst_38567);

(statearr_38631_38657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (14))){
var inst_38562 = (state_38611[(7)]);
var inst_38563 = (state_38611[(8)]);
var _ = (function (){var statearr_38632 = state_38611;
(statearr_38632[(4)] = cljs.core.cons.call(null,(17),(state_38611[(4)])));

return statearr_38632;
})();
var inst_38587 = cljs.core.nth.call(null,inst_38562,(0),null);
var inst_38588 = cljs.core.nth.call(null,inst_38562,(1),null);
var inst_38589 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_38590 = cljs.core.pr_str.call(null,inst_38562);
var inst_38591 = fluree.db.util.core.trunc.call(null,inst_38590,(200));
var inst_38592 = fluree.db.util.log.trace.call(null,inst_38589,inst_38591);
var inst_38593 = fluree.db.session.process_ledger_update.call(null,inst_38563,inst_38587,inst_38588);
var state_38611__$1 = (function (){var statearr_38633 = state_38611;
(statearr_38633[(10)] = inst_38592);

return statearr_38633;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38611__$1,(18),inst_38593);
} else {
if((state_val_38612 === (16))){
var inst_38562 = (state_38611[(7)]);
var inst_38577 = (state_38611[(2)]);
var inst_38578 = fluree.db.util.log.error.call(null,inst_38577,"Exception processing ledger updates for message: ",inst_38562);
var state_38611__$1 = state_38611;
var statearr_38634_38658 = state_38611__$1;
(statearr_38634_38658[(2)] = inst_38578);

(statearr_38634_38658[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (10))){
var inst_38605 = (state_38611[(2)]);
var state_38611__$1 = state_38611;
var statearr_38635_38659 = state_38611__$1;
(statearr_38635_38659[(2)] = inst_38605);

(statearr_38635_38659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (18))){
var inst_38595 = (state_38611[(2)]);
var inst_38596 = fluree.db.util.async.throw_err.call(null,inst_38595);
var _ = (function (){var statearr_38636 = state_38611;
(statearr_38636[(4)] = cljs.core.rest.call(null,(state_38611[(4)])));

return statearr_38636;
})();
var state_38611__$1 = state_38611;
var statearr_38637_38660 = state_38611__$1;
(statearr_38637_38660[(2)] = inst_38596);

(statearr_38637_38660[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38612 === (8))){
var inst_38562 = (state_38611[(7)]);
var inst_38571 = cljs.core.first.call(null,inst_38562);
var inst_38572 = cljs.core.pr_str.call(null,inst_38571);
var inst_38573 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_38572].join('');
var inst_38574 = fluree.db.util.log.warn.call(null,inst_38573);
var state_38611__$1 = state_38611;
var statearr_38638_38661 = state_38611__$1;
(statearr_38638_38661[(2)] = inst_38574);

(statearr_38638_38661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____0 = (function (){
var statearr_38639 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38639[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__);

(statearr_38639[(1)] = (1));

return statearr_38639;
});
var fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____1 = (function (state_38611){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38640){var ex__11472__auto__ = e38640;
var statearr_38641_38662 = state_38611;
(statearr_38641_38662[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38611[(4)]))){
var statearr_38642_38663 = state_38611;
(statearr_38642_38663[(1)] = cljs.core.first.call(null,(state_38611[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38664 = state_38611;
state_38611 = G__38664;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__ = function(state_38611){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____1.call(this,state_38611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__11469__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38643 = f__11543__auto__.call(null);
(statearr_38643[(6)] = c__11542__auto__);

return statearr_38643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__38665){
var map__38666 = p__38665;
var map__38666__$1 = (((((!((map__38666 == null))))?(((((map__38666.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38666.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38666):map__38666);
var network = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__38666__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__38671 = block_result;
var map__38671__$1 = (((((!((map__38671 == null))))?(((((map__38671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38671.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38671):map__38671);
var block = cljs.core.get.call(null,map__38671__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__38671__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__38671__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__38671__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__38671__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__38672 = tx_result;
var map__38672__$1 = (((((!((map__38672 == null))))?(((((map__38672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38672):map__38672);
var t = cljs.core.get.call(null,map__38672__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__38672__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__38668_SHARP_){
return cljs.core._EQ_.call(null,t,p1__38668_SHARP_.t);
}):(function (p1__38669_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__38669_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__38670_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__38670_SHARP_))){
return cljs.core.nth.call(null,p1__38670_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__38675 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__38675,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__38675,(1),null);
var error = cljs.core.nth.call(null,vec__38675,(2),null);
var message = cljs.core.nth.call(null,vec__38675,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__38679 = arguments.length;
switch (G__38679) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__38680){
var map__38681 = p__38680;
var map__38681__$1 = (((((!((map__38681 == null))))?(((((map__38681.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38681.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__38681):map__38681);
var state = cljs.core.get.call(null,map__38681__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__38681__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__38681__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__38681__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__38683 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__38683,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__38683,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__38683,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__38686 = cljs.core.seq.call(null,tids);
var chunk__38687 = null;
var count__38688 = (0);
var i__38689 = (0);
while(true){
if((i__38689 < count__38688)){
var tid = cljs.core._nth.call(null,chunk__38687,i__38689);
var temp__5735__auto___38802__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___38802__$1)){
var keyed_callbacks_38803 = temp__5735__auto___38802__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_38804 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__38730_38805 = cljs.core.seq.call(null,keyed_callbacks_38803);
var chunk__38731_38806 = null;
var count__38732_38807 = (0);
var i__38733_38808 = (0);
while(true){
if((i__38733_38808 < count__38732_38807)){
var vec__38742_38809 = cljs.core._nth.call(null,chunk__38731_38806,i__38733_38808);
var k_38810 = cljs.core.nth.call(null,vec__38742_38809,(0),null);
var f_38811 = cljs.core.nth.call(null,vec__38742_38809,(1),null);
try{f_38811.call(null,tx_response_38804);
}catch (e38745){var e_38812 = e38745;
fluree.db.util.log.error.call(null,e_38812,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38813 = seq__38730_38805;
var G__38814 = chunk__38731_38806;
var G__38815 = count__38732_38807;
var G__38816 = (i__38733_38808 + (1));
seq__38730_38805 = G__38813;
chunk__38731_38806 = G__38814;
count__38732_38807 = G__38815;
i__38733_38808 = G__38816;
continue;
} else {
var temp__5735__auto___38817__$2 = cljs.core.seq.call(null,seq__38730_38805);
if(temp__5735__auto___38817__$2){
var seq__38730_38818__$1 = temp__5735__auto___38817__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38730_38818__$1)){
var c__4556__auto___38819 = cljs.core.chunk_first.call(null,seq__38730_38818__$1);
var G__38820 = cljs.core.chunk_rest.call(null,seq__38730_38818__$1);
var G__38821 = c__4556__auto___38819;
var G__38822 = cljs.core.count.call(null,c__4556__auto___38819);
var G__38823 = (0);
seq__38730_38805 = G__38820;
chunk__38731_38806 = G__38821;
count__38732_38807 = G__38822;
i__38733_38808 = G__38823;
continue;
} else {
var vec__38746_38824 = cljs.core.first.call(null,seq__38730_38818__$1);
var k_38825 = cljs.core.nth.call(null,vec__38746_38824,(0),null);
var f_38826 = cljs.core.nth.call(null,vec__38746_38824,(1),null);
try{f_38826.call(null,tx_response_38804);
}catch (e38749){var e_38827 = e38749;
fluree.db.util.log.error.call(null,e_38827,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38828 = cljs.core.next.call(null,seq__38730_38818__$1);
var G__38829 = null;
var G__38830 = (0);
var G__38831 = (0);
seq__38730_38805 = G__38828;
chunk__38731_38806 = G__38829;
count__38732_38807 = G__38830;
i__38733_38808 = G__38831;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__38832 = seq__38686;
var G__38833 = chunk__38687;
var G__38834 = count__38688;
var G__38835 = (i__38689 + (1));
seq__38686 = G__38832;
chunk__38687 = G__38833;
count__38688 = G__38834;
i__38689 = G__38835;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__38686);
if(temp__5735__auto____$1){
var seq__38686__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38686__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__38686__$1);
var G__38836 = cljs.core.chunk_rest.call(null,seq__38686__$1);
var G__38837 = c__4556__auto__;
var G__38838 = cljs.core.count.call(null,c__4556__auto__);
var G__38839 = (0);
seq__38686 = G__38836;
chunk__38687 = G__38837;
count__38688 = G__38838;
i__38689 = G__38839;
continue;
} else {
var tid = cljs.core.first.call(null,seq__38686__$1);
var temp__5735__auto___38840__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___38840__$2)){
var keyed_callbacks_38841 = temp__5735__auto___38840__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_38842 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__38750_38843 = cljs.core.seq.call(null,keyed_callbacks_38841);
var chunk__38751_38844 = null;
var count__38752_38845 = (0);
var i__38753_38846 = (0);
while(true){
if((i__38753_38846 < count__38752_38845)){
var vec__38762_38847 = cljs.core._nth.call(null,chunk__38751_38844,i__38753_38846);
var k_38848 = cljs.core.nth.call(null,vec__38762_38847,(0),null);
var f_38849 = cljs.core.nth.call(null,vec__38762_38847,(1),null);
try{f_38849.call(null,tx_response_38842);
}catch (e38765){var e_38850 = e38765;
fluree.db.util.log.error.call(null,e_38850,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38851 = seq__38750_38843;
var G__38852 = chunk__38751_38844;
var G__38853 = count__38752_38845;
var G__38854 = (i__38753_38846 + (1));
seq__38750_38843 = G__38851;
chunk__38751_38844 = G__38852;
count__38752_38845 = G__38853;
i__38753_38846 = G__38854;
continue;
} else {
var temp__5735__auto___38855__$3 = cljs.core.seq.call(null,seq__38750_38843);
if(temp__5735__auto___38855__$3){
var seq__38750_38856__$1 = temp__5735__auto___38855__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38750_38856__$1)){
var c__4556__auto___38857 = cljs.core.chunk_first.call(null,seq__38750_38856__$1);
var G__38858 = cljs.core.chunk_rest.call(null,seq__38750_38856__$1);
var G__38859 = c__4556__auto___38857;
var G__38860 = cljs.core.count.call(null,c__4556__auto___38857);
var G__38861 = (0);
seq__38750_38843 = G__38858;
chunk__38751_38844 = G__38859;
count__38752_38845 = G__38860;
i__38753_38846 = G__38861;
continue;
} else {
var vec__38766_38862 = cljs.core.first.call(null,seq__38750_38856__$1);
var k_38863 = cljs.core.nth.call(null,vec__38766_38862,(0),null);
var f_38864 = cljs.core.nth.call(null,vec__38766_38862,(1),null);
try{f_38864.call(null,tx_response_38842);
}catch (e38769){var e_38865 = e38769;
fluree.db.util.log.error.call(null,e_38865,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__38866 = cljs.core.next.call(null,seq__38750_38856__$1);
var G__38867 = null;
var G__38868 = (0);
var G__38869 = (0);
seq__38750_38843 = G__38866;
chunk__38751_38844 = G__38867;
count__38752_38845 = G__38868;
i__38753_38846 = G__38869;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__38870 = cljs.core.next.call(null,seq__38686__$1);
var G__38871 = null;
var G__38872 = (0);
var G__38873 = (0);
seq__38686 = G__38870;
chunk__38687 = G__38871;
count__38688 = G__38872;
i__38689 = G__38873;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_38874 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__11542__auto___38875 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_38786){
var state_val_38787 = (state_38786[(1)]);
if((state_val_38787 === (1))){
var state_38786__$1 = state_38786;
var statearr_38788_38876 = state_38786__$1;
(statearr_38788_38876[(2)] = null);

(statearr_38788_38876[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38787 === (2))){
var inst_38771 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_38786__$1 = state_38786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_38786__$1,(4),inst_38771);
} else {
if((state_val_38787 === (3))){
var inst_38784 = (state_38786[(2)]);
var state_38786__$1 = state_38786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_38786__$1,inst_38784);
} else {
if((state_val_38787 === (4))){
var inst_38773 = (state_38786[(7)]);
var inst_38773__$1 = (state_38786[(2)]);
var inst_38774 = (inst_38773__$1 == null);
var state_38786__$1 = (function (){var statearr_38789 = state_38786;
(statearr_38789[(7)] = inst_38773__$1);

return statearr_38789;
})();
if(cljs.core.truth_(inst_38774)){
var statearr_38790_38877 = state_38786__$1;
(statearr_38790_38877[(1)] = (5));

} else {
var statearr_38791_38878 = state_38786__$1;
(statearr_38791_38878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38787 === (5))){
var inst_38776 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_38777 = fluree.db.util.log.info.call(null,inst_38776);
var state_38786__$1 = state_38786;
var statearr_38792_38879 = state_38786__$1;
(statearr_38792_38879[(2)] = inst_38777);

(statearr_38792_38879[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38787 === (6))){
var inst_38773 = (state_38786[(7)]);
var inst_38779 = transact_handler_38874.call(null,conn,inst_38773);
var state_38786__$1 = (function (){var statearr_38793 = state_38786;
(statearr_38793[(8)] = inst_38779);

return statearr_38793;
})();
var statearr_38794_38880 = state_38786__$1;
(statearr_38794_38880[(2)] = null);

(statearr_38794_38880[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38787 === (7))){
var inst_38782 = (state_38786[(2)]);
var state_38786__$1 = state_38786;
var statearr_38795_38881 = state_38786__$1;
(statearr_38795_38881[(2)] = inst_38782);

(statearr_38795_38881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__11469__auto__ = null;
var fluree$db$session$state_machine__11469__auto____0 = (function (){
var statearr_38796 = [null,null,null,null,null,null,null,null,null];
(statearr_38796[(0)] = fluree$db$session$state_machine__11469__auto__);

(statearr_38796[(1)] = (1));

return statearr_38796;
});
var fluree$db$session$state_machine__11469__auto____1 = (function (state_38786){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_38786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e38797){var ex__11472__auto__ = e38797;
var statearr_38798_38882 = state_38786;
(statearr_38798_38882[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_38786[(4)]))){
var statearr_38799_38883 = state_38786;
(statearr_38799_38883[(1)] = cljs.core.first.call(null,(state_38786[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__38884 = state_38786;
state_38786 = G__38884;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$session$state_machine__11469__auto__ = function(state_38786){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__11469__auto____1.call(this,state_38786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__11469__auto____0;
fluree$db$session$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__11469__auto____1;
return fluree$db$session$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_38800 = f__11543__auto__.call(null);
(statearr_38800[(6)] = c__11542__auto___38875);

return statearr_38800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__38885_SHARP_){
return cljs.core.assoc.call(null,p1__38885_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__38885_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__38886_SHARP_){
return cljs.core.assoc.call(null,p1__38886_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__38889 = arguments.length;
switch (G__38889) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__38890 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__38887_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__38887_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__38890);
} else {
return G__38890;
}
})();
var seq__38891 = cljs.core.seq.call(null,sessions);
var chunk__38892 = null;
var count__38893 = (0);
var i__38894 = (0);
while(true){
if((i__38894 < count__38893)){
var session = cljs.core._nth.call(null,chunk__38892,i__38894);
fluree.db.session.close.call(null,session);


var G__38896 = seq__38891;
var G__38897 = chunk__38892;
var G__38898 = count__38893;
var G__38899 = (i__38894 + (1));
seq__38891 = G__38896;
chunk__38892 = G__38897;
count__38893 = G__38898;
i__38894 = G__38899;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__38891);
if(temp__5735__auto__){
var seq__38891__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__38891__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__38891__$1);
var G__38900 = cljs.core.chunk_rest.call(null,seq__38891__$1);
var G__38901 = c__4556__auto__;
var G__38902 = cljs.core.count.call(null,c__4556__auto__);
var G__38903 = (0);
seq__38891 = G__38900;
chunk__38892 = G__38901;
count__38893 = G__38902;
i__38894 = G__38903;
continue;
} else {
var session = cljs.core.first.call(null,seq__38891__$1);
fluree.db.session.close.call(null,session);


var G__38904 = cljs.core.next.call(null,seq__38891__$1);
var G__38905 = null;
var G__38906 = (0);
var G__38907 = (0);
seq__38891 = G__38904;
chunk__38892 = G__38905;
count__38893 = G__38906;
i__38894 = G__38907;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
