// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__36549 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__36549,(0),null);
var network = cljs.core.nth.call(null,vec__36549,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__36549,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36646){
var state_val_36647 = (state_36646[(1)]);
if((state_val_36647 === (7))){
var inst_36567 = (state_36646[(7)]);
var inst_36572 = inst_36567.cljs$lang$protocol_mask$partition0$;
var inst_36573 = (inst_36572 & (64));
var inst_36574 = inst_36567.cljs$core$ISeq$;
var inst_36575 = (cljs.core.PROTOCOL_SENTINEL === inst_36574);
var inst_36576 = ((inst_36573) || (inst_36575));
var state_36646__$1 = state_36646;
if(cljs.core.truth_(inst_36576)){
var statearr_36648_36694 = state_36646__$1;
(statearr_36648_36694[(1)] = (10));

} else {
var statearr_36649_36695 = state_36646__$1;
(statearr_36649_36695[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (20))){
var state_36646__$1 = state_36646;
var statearr_36650_36696 = state_36646__$1;
(statearr_36650_36696[(2)] = false);

(statearr_36650_36696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (27))){
var inst_36592 = (state_36646[(8)]);
var inst_36566 = (state_36646[(9)]);
var inst_36589 = (state_36646[(10)]);
var inst_36630 = (state_36646[(2)]);
var inst_36631 = cljs.core.into.call(null,inst_36589,inst_36566);
var inst_36632 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_36633 = cljs.core.swap_BANG_.call(null,inst_36632,cljs.core.empty);
var inst_36634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36635 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_36636 = (new cljs.core.PersistentVector(null,2,(5),inst_36634,inst_36635,null));
var inst_36637 = cljs.core.assoc_in.call(null,db,inst_36636,inst_36631);
var inst_36638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36639 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36640 = (new cljs.core.PersistentVector(null,2,(5),inst_36638,inst_36639,null));
var inst_36641 = cljs.core.assoc_in.call(null,inst_36637,inst_36640,inst_36592);
var _ = (function (){var statearr_36651 = state_36646;
(statearr_36651[(4)] = cljs.core.rest.call(null,(state_36646[(4)])));

return statearr_36651;
})();
var state_36646__$1 = (function (){var statearr_36652 = state_36646;
(statearr_36652[(11)] = inst_36630);

(statearr_36652[(12)] = inst_36633);

return statearr_36652;
})();
var statearr_36653_36697 = state_36646__$1;
(statearr_36653_36697[(2)] = inst_36641);

(statearr_36653_36697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (1))){
var state_36646__$1 = state_36646;
var statearr_36654_36698 = state_36646__$1;
(statearr_36654_36698[(2)] = null);

(statearr_36654_36698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (24))){
var inst_36592 = (state_36646[(8)]);
var inst_36617 = (state_36646[(2)]);
var inst_36618 = cljs.core.get.call(null,inst_36617,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_36619 = cljs.core.get.call(null,inst_36617,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_36620 = (inst_36592 > inst_36619);
var state_36646__$1 = (function (){var statearr_36655 = state_36646;
(statearr_36655[(13)] = inst_36618);

return statearr_36655;
})();
if(cljs.core.truth_(inst_36620)){
var statearr_36656_36699 = state_36646__$1;
(statearr_36656_36699[(1)] = (25));

} else {
var statearr_36657_36700 = state_36646__$1;
(statearr_36657_36700[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (4))){
var inst_36552 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
var statearr_36658_36701 = state_36646__$1;
(statearr_36658_36701[(2)] = inst_36552);

(statearr_36658_36701[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (15))){
var inst_36596 = (state_36646[(14)]);
var inst_36566 = (state_36646[(9)]);
var inst_36588 = (state_36646[(2)]);
var inst_36589 = cljs.core.get.call(null,inst_36588,new cljs.core.Keyword(null,"post","post",269697687));
var inst_36590 = cljs.core.get.call(null,inst_36588,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_36591 = fluree.db.flake.size_bytes.call(null,inst_36566);
var inst_36592 = (inst_36590 + inst_36591);
var inst_36593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36594 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_36595 = (new cljs.core.PersistentVector(null,2,(5),inst_36593,inst_36594,null));
var inst_36596__$1 = cljs.core.get_in.call(null,db,inst_36595);
var inst_36598 = (inst_36596__$1 == null);
var inst_36599 = cljs.core.not.call(null,inst_36598);
var state_36646__$1 = (function (){var statearr_36659 = state_36646;
(statearr_36659[(8)] = inst_36592);

(statearr_36659[(14)] = inst_36596__$1);

(statearr_36659[(10)] = inst_36589);

return statearr_36659;
})();
if(inst_36599){
var statearr_36660_36702 = state_36646__$1;
(statearr_36660_36702[(1)] = (16));

} else {
var statearr_36661_36703 = state_36646__$1;
(statearr_36661_36703[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (21))){
var inst_36609 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
var statearr_36662_36704 = state_36646__$1;
(statearr_36662_36704[(2)] = inst_36609);

(statearr_36662_36704[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (13))){
var inst_36567 = (state_36646[(7)]);
var inst_36585 = cljs.core.apply.call(null,cljs.core.hash_map,inst_36567);
var state_36646__$1 = state_36646;
var statearr_36663_36705 = state_36646__$1;
(statearr_36663_36705[(2)] = inst_36585);

(statearr_36663_36705[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (22))){
var inst_36596 = (state_36646[(14)]);
var inst_36614 = cljs.core.apply.call(null,cljs.core.hash_map,inst_36596);
var state_36646__$1 = state_36646;
var statearr_36664_36706 = state_36646__$1;
(statearr_36664_36706[(2)] = inst_36614);

(statearr_36664_36706[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (6))){
var inst_36567 = (state_36646[(7)]);
var inst_36565 = (state_36646[(2)]);
var inst_36566 = fluree.db.util.async.throw_err.call(null,inst_36565);
var inst_36567__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_36569 = (inst_36567__$1 == null);
var inst_36570 = cljs.core.not.call(null,inst_36569);
var state_36646__$1 = (function (){var statearr_36665 = state_36646;
(statearr_36665[(7)] = inst_36567__$1);

(statearr_36665[(9)] = inst_36566);

return statearr_36665;
})();
if(inst_36570){
var statearr_36666_36707 = state_36646__$1;
(statearr_36666_36707[(1)] = (7));

} else {
var statearr_36667_36708 = state_36646__$1;
(statearr_36667_36708[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (25))){
var inst_36622 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_36623 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_36624 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_36625 = cljs.core.PersistentHashMap.fromArrays(inst_36623,inst_36624);
var inst_36626 = cljs.core.ex_info.call(null,inst_36622,inst_36625);
var inst_36627 = (function(){throw inst_36626})();
var state_36646__$1 = state_36646;
var statearr_36668_36709 = state_36646__$1;
(statearr_36668_36709[(2)] = inst_36627);

(statearr_36668_36709[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (17))){
var state_36646__$1 = state_36646;
var statearr_36669_36710 = state_36646__$1;
(statearr_36669_36710[(2)] = false);

(statearr_36669_36710[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (3))){
var inst_36644 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36646__$1,inst_36644);
} else {
if((state_val_36647 === (12))){
var inst_36580 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
var statearr_36670_36711 = state_36646__$1;
(statearr_36670_36711[(2)] = inst_36580);

(statearr_36670_36711[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (2))){
var _ = (function (){var statearr_36671 = state_36646;
(statearr_36671[(4)] = cljs.core.cons.call(null,(5),(state_36646[(4)])));

return statearr_36671;
})();
var inst_36560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36561 = [pred_id];
var inst_36562 = (new cljs.core.PersistentVector(null,1,(5),inst_36560,inst_36561,null));
var inst_36563 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_36562);
var state_36646__$1 = state_36646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36646__$1,(6),inst_36563);
} else {
if((state_val_36647 === (23))){
var inst_36596 = (state_36646[(14)]);
var state_36646__$1 = state_36646;
var statearr_36672_36712 = state_36646__$1;
(statearr_36672_36712[(2)] = inst_36596);

(statearr_36672_36712[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (19))){
var state_36646__$1 = state_36646;
var statearr_36673_36713 = state_36646__$1;
(statearr_36673_36713[(2)] = true);

(statearr_36673_36713[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (11))){
var state_36646__$1 = state_36646;
var statearr_36675_36714 = state_36646__$1;
(statearr_36675_36714[(2)] = false);

(statearr_36675_36714[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (9))){
var inst_36583 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
if(cljs.core.truth_(inst_36583)){
var statearr_36676_36715 = state_36646__$1;
(statearr_36676_36715[(1)] = (13));

} else {
var statearr_36677_36716 = state_36646__$1;
(statearr_36677_36716[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (5))){
var _ = (function (){var statearr_36678 = state_36646;
(statearr_36678[(4)] = cljs.core.rest.call(null,(state_36646[(4)])));

return statearr_36678;
})();
var state_36646__$1 = state_36646;
var ex36674 = (state_36646__$1[(2)]);
var statearr_36679_36717 = state_36646__$1;
(statearr_36679_36717[(5)] = ex36674);


if((ex36674 instanceof Error)){
var statearr_36680_36718 = state_36646__$1;
(statearr_36680_36718[(1)] = (4));

(statearr_36680_36718[(5)] = null);

} else {
throw ex36674;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (14))){
var inst_36567 = (state_36646[(7)]);
var state_36646__$1 = state_36646;
var statearr_36681_36719 = state_36646__$1;
(statearr_36681_36719[(2)] = inst_36567);

(statearr_36681_36719[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (26))){
var state_36646__$1 = state_36646;
var statearr_36682_36720 = state_36646__$1;
(statearr_36682_36720[(2)] = null);

(statearr_36682_36720[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (16))){
var inst_36596 = (state_36646[(14)]);
var inst_36601 = inst_36596.cljs$lang$protocol_mask$partition0$;
var inst_36602 = (inst_36601 & (64));
var inst_36603 = inst_36596.cljs$core$ISeq$;
var inst_36604 = (cljs.core.PROTOCOL_SENTINEL === inst_36603);
var inst_36605 = ((inst_36602) || (inst_36604));
var state_36646__$1 = state_36646;
if(cljs.core.truth_(inst_36605)){
var statearr_36683_36721 = state_36646__$1;
(statearr_36683_36721[(1)] = (19));

} else {
var statearr_36684_36722 = state_36646__$1;
(statearr_36684_36722[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (10))){
var state_36646__$1 = state_36646;
var statearr_36685_36723 = state_36646__$1;
(statearr_36685_36723[(2)] = true);

(statearr_36685_36723[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (18))){
var inst_36612 = (state_36646[(2)]);
var state_36646__$1 = state_36646;
if(cljs.core.truth_(inst_36612)){
var statearr_36686_36724 = state_36646__$1;
(statearr_36686_36724[(1)] = (22));

} else {
var statearr_36687_36725 = state_36646__$1;
(statearr_36687_36725[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36647 === (8))){
var state_36646__$1 = state_36646;
var statearr_36688_36726 = state_36646__$1;
(statearr_36688_36726[(2)] = false);

(statearr_36688_36726[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____0 = (function (){
var statearr_36689 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36689[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__);

(statearr_36689[(1)] = (1));

return statearr_36689;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____1 = (function (state_36646){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36646);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36690){var ex__11472__auto__ = e36690;
var statearr_36691_36727 = state_36646;
(statearr_36691_36727[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36646[(4)]))){
var statearr_36692_36728 = state_36646;
(statearr_36692_36728[(1)] = cljs.core.first.call(null,(state_36646[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__36729 = state_36646;
state_36646 = G__36729;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__ = function(state_36646){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____1.call(this,state_36646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36693 = f__11543__auto__.call(null);
(statearr_36693[(6)] = c__11542__auto__);

return statearr_36693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_36928){
var state_val_36929 = (state_36928[(1)]);
if((state_val_36929 === (7))){
var state_36928__$1 = state_36928;
var statearr_36930_36996 = state_36928__$1;
(statearr_36930_36996[(2)] = null);

(statearr_36930_36996[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (20))){
var inst_36853 = (state_36928[(7)]);
var inst_36771 = (state_36928[(8)]);
var inst_36821 = (state_36928[(9)]);
var inst_36852 = (state_36928[(10)]);
var inst_36770 = (state_36928[(11)]);
var inst_36851 = (state_36928[(12)]);
var inst_36850 = (state_36928[(13)]);
var inst_36854 = (state_36928[(14)]);
var inst_36864 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36866 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36867 = (new cljs.core.PersistentVector(null,2,(5),inst_36865,inst_36866,null));
var inst_36868 = cljs.core.get_in.call(null,inst_36821,inst_36867);
var inst_36869 = (inst_36770 + inst_36868);
var inst_36870 = [inst_36850,inst_36851,inst_36852,inst_36853,inst_36869];
var inst_36871 = cljs.core.PersistentHashMap.fromArrays(inst_36864,inst_36870);
var inst_36872 = cljs.core.assoc.call(null,inst_36821,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_36854,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_36871);
var state_36928__$1 = (function (){var statearr_36931 = state_36928;
(statearr_36931[(15)] = inst_36872);

return statearr_36931;
})();
if(cljs.core.truth_(inst_36771)){
var statearr_36932_36997 = state_36928__$1;
(statearr_36932_36997[(1)] = (23));

} else {
var statearr_36933_36998 = state_36928__$1;
(statearr_36933_36998[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (27))){
var inst_36872 = (state_36928[(15)]);
var state_36928__$1 = state_36928;
var statearr_36934_36999 = state_36928__$1;
(statearr_36934_36999[(2)] = inst_36872);

(statearr_36934_36999[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (1))){
var state_36928__$1 = state_36928;
var statearr_36935_37000 = state_36928__$1;
(statearr_36935_37000[(2)] = null);

(statearr_36935_37000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (24))){
var inst_36872 = (state_36928[(15)]);
var inst_36875 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_36872);
var inst_36876 = (inst_36875 == null);
var state_36928__$1 = state_36928;
var statearr_36936_37001 = state_36928__$1;
(statearr_36936_37001[(2)] = inst_36876);

(statearr_36936_37001[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (39))){
var inst_36902 = (state_36928[(16)]);
var inst_36861 = (state_36928[(17)]);
var inst_36911 = (state_36928[(18)]);
var inst_36904 = (state_36928[(19)]);
var inst_36903 = (state_36928[(20)]);
var inst_36918 = (state_36928[(2)]);
var inst_36849 = inst_36861;
var inst_36850 = inst_36903;
var inst_36851 = inst_36904;
var inst_36852 = inst_36911;
var inst_36853 = inst_36918;
var inst_36854 = inst_36902;
var state_36928__$1 = (function (){var statearr_36937 = state_36928;
(statearr_36937[(7)] = inst_36853);

(statearr_36937[(21)] = inst_36849);

(statearr_36937[(10)] = inst_36852);

(statearr_36937[(12)] = inst_36851);

(statearr_36937[(13)] = inst_36850);

(statearr_36937[(14)] = inst_36854);

return statearr_36937;
})();
var statearr_36938_37002 = state_36928__$1;
(statearr_36938_37002[(2)] = null);

(statearr_36938_37002[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (4))){
var inst_36733 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
var statearr_36939_37003 = state_36928__$1;
(statearr_36939_37003[(2)] = inst_36733);

(statearr_36939_37003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (15))){
var inst_36793 = (state_36928[(22)]);
var state_36928__$1 = state_36928;
var statearr_36940_37004 = state_36928__$1;
(statearr_36940_37004[(2)] = inst_36793);

(statearr_36940_37004[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (21))){
var inst_36757 = (state_36928[(23)]);
var inst_36765 = (state_36928[(24)]);
var inst_36772 = (state_36928[(25)]);
var inst_36853 = (state_36928[(7)]);
var inst_36740 = (state_36928[(26)]);
var inst_36771 = (state_36928[(8)]);
var inst_36774 = (state_36928[(27)]);
var inst_36821 = (state_36928[(9)]);
var inst_36849 = (state_36928[(21)]);
var inst_36780 = (state_36928[(28)]);
var inst_36852 = (state_36928[(10)]);
var inst_36755 = (state_36928[(29)]);
var inst_36861 = (state_36928[(17)]);
var inst_36770 = (state_36928[(11)]);
var inst_36851 = (state_36928[(12)]);
var inst_36761 = (state_36928[(30)]);
var inst_36850 = (state_36928[(13)]);
var inst_36769 = (state_36928[(31)]);
var inst_36830 = (state_36928[(32)]);
var inst_36831 = (state_36928[(33)]);
var inst_36854 = (state_36928[(14)]);
var inst_36860 = (state_36928[(34)]);
var inst_36899 = inst_36860.s;
var inst_36900 = fluree.db.flake.sid__GT_cid.call(null,inst_36899);
var inst_36901 = (function (){var flakes_bytes = inst_36770;
var t = inst_36740;
var spot = inst_36850;
var add_flakes = inst_36757;
var first__36828 = inst_36830;
var root_setting_change_QMARK_ = inst_36772;
var ref_QMARK__map = inst_36769;
var r = inst_36861;
var psot = inst_36851;
var vec__36826 = inst_36757;
var add_pred_to_idx_QMARK_ = inst_36780;
var _ = inst_36755;
var cid = inst_36900;
var ecount = inst_36854;
var first__36858 = inst_36860;
var pred_ecount = inst_36774;
var seq__36827 = inst_36831;
var db_STAR_ = inst_36821;
var schema_change_QMARK_ = inst_36771;
var add_preds = inst_36761;
var opst = inst_36853;
var G__36825 = inst_36849;
var seq__36857 = inst_36861;
var idx_QMARK__map = inst_36765;
var vec__36856 = inst_36849;
var post = inst_36852;
var f = inst_36860;
return (function (p1__36732_SHARP_){
if(cljs.core.truth_(p1__36732_SHARP_)){
var x__4214__auto__ = p1__36732_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_36902 = cljs.core.update.call(null,inst_36854,inst_36900,inst_36901);
var inst_36903 = cljs.core.conj.call(null,inst_36850,inst_36860);
var inst_36904 = cljs.core.conj.call(null,inst_36851,inst_36860);
var inst_36905 = inst_36860.p;
var inst_36906 = cljs.core.get.call(null,inst_36765,inst_36905);
var state_36928__$1 = (function (){var statearr_36941 = state_36928;
(statearr_36941[(16)] = inst_36902);

(statearr_36941[(19)] = inst_36904);

(statearr_36941[(20)] = inst_36903);

return statearr_36941;
})();
if(cljs.core.truth_(inst_36906)){
var statearr_36942_37005 = state_36928__$1;
(statearr_36942_37005[(1)] = (34));

} else {
var statearr_36943_37006 = state_36928__$1;
(statearr_36943_37006[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (31))){
var inst_36887 = (state_36928[(35)]);
var state_36928__$1 = state_36928;
var statearr_36944_37007 = state_36928__$1;
(statearr_36944_37007[(2)] = inst_36887);

(statearr_36944_37007[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (32))){
var inst_36897 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
var statearr_36945_37008 = state_36928__$1;
(statearr_36945_37008[(2)] = inst_36897);

(statearr_36945_37008[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (33))){
var inst_36887 = (state_36928[(35)]);
var inst_36892 = (state_36928[(2)]);
var inst_36893 = fluree.db.util.async.throw_err.call(null,inst_36892);
var inst_36894 = cljs.core.assoc.call(null,inst_36887,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_36893);
var state_36928__$1 = state_36928;
var statearr_36946_37009 = state_36928__$1;
(statearr_36946_37009[(2)] = inst_36894);

(statearr_36946_37009[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (13))){
var inst_36757 = (state_36928[(23)]);
var inst_36740 = (state_36928[(26)]);
var inst_36821 = (state_36928[(9)]);
var inst_36770 = (state_36928[(11)]);
var inst_36811 = (state_36928[(2)]);
var inst_36812 = cljs.core.assoc.call(null,inst_36811,new cljs.core.Keyword(null,"t","t",-1397832519),inst_36740);
var inst_36813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36814 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_36815 = (new cljs.core.PersistentVector(null,2,(5),inst_36813,inst_36814,null));
var inst_36816 = cljs.core.update_in.call(null,inst_36812,inst_36815,cljs.core._PLUS_,inst_36770);
var inst_36817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36818 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_36819 = (new cljs.core.PersistentVector(null,2,(5),inst_36817,inst_36818,null));
var inst_36820 = cljs.core.count.call(null,inst_36757);
var inst_36821__$1 = cljs.core.update_in.call(null,inst_36816,inst_36819,cljs.core._PLUS_,inst_36820);
var inst_36829 = cljs.core.seq.call(null,inst_36757);
var inst_36830 = cljs.core.first.call(null,inst_36829);
var inst_36831 = cljs.core.next.call(null,inst_36829);
var inst_36832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36833 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_36834 = (new cljs.core.PersistentVector(null,2,(5),inst_36832,inst_36833,null));
var inst_36835 = cljs.core.get_in.call(null,inst_36821__$1,inst_36834);
var inst_36836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36837 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_36838 = (new cljs.core.PersistentVector(null,2,(5),inst_36836,inst_36837,null));
var inst_36839 = cljs.core.get_in.call(null,inst_36821__$1,inst_36838);
var inst_36840 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36841 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_36842 = (new cljs.core.PersistentVector(null,2,(5),inst_36840,inst_36841,null));
var inst_36843 = cljs.core.get_in.call(null,inst_36821__$1,inst_36842);
var inst_36844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36845 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_36846 = (new cljs.core.PersistentVector(null,2,(5),inst_36844,inst_36845,null));
var inst_36847 = cljs.core.get_in.call(null,inst_36821__$1,inst_36846);
var inst_36848 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_36849 = inst_36757;
var inst_36850 = inst_36835;
var inst_36851 = inst_36839;
var inst_36852 = inst_36843;
var inst_36853 = inst_36847;
var inst_36854 = inst_36848;
var state_36928__$1 = (function (){var statearr_36947 = state_36928;
(statearr_36947[(7)] = inst_36853);

(statearr_36947[(9)] = inst_36821__$1);

(statearr_36947[(21)] = inst_36849);

(statearr_36947[(10)] = inst_36852);

(statearr_36947[(12)] = inst_36851);

(statearr_36947[(13)] = inst_36850);

(statearr_36947[(32)] = inst_36830);

(statearr_36947[(33)] = inst_36831);

(statearr_36947[(14)] = inst_36854);

return statearr_36947;
})();
var statearr_36948_37010 = state_36928__$1;
(statearr_36948_37010[(2)] = null);

(statearr_36948_37010[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (22))){
var inst_36921 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
var statearr_36949_37011 = state_36928__$1;
(statearr_36949_37011[(2)] = inst_36921);

(statearr_36949_37011[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (36))){
var inst_36769 = (state_36928[(31)]);
var inst_36860 = (state_36928[(34)]);
var inst_36911 = (state_36928[(2)]);
var inst_36912 = inst_36860.p;
var inst_36913 = cljs.core.get.call(null,inst_36769,inst_36912);
var state_36928__$1 = (function (){var statearr_36950 = state_36928;
(statearr_36950[(18)] = inst_36911);

return statearr_36950;
})();
if(cljs.core.truth_(inst_36913)){
var statearr_36951_37012 = state_36928__$1;
(statearr_36951_37012[(1)] = (37));

} else {
var statearr_36952_37013 = state_36928__$1;
(statearr_36952_37013[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (29))){
var inst_36872 = (state_36928[(15)]);
var inst_36882 = (state_36928[(2)]);
var inst_36883 = fluree.db.util.async.throw_err.call(null,inst_36882);
var inst_36884 = cljs.core.assoc.call(null,inst_36872,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_36883);
var state_36928__$1 = state_36928;
var statearr_36953_37014 = state_36928__$1;
(statearr_36953_37014[(2)] = inst_36884);

(statearr_36953_37014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (6))){
var inst_36740 = (state_36928[(26)]);
var inst_36745 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_36746 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_36747 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36745)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36746)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36740),"."].join('');
var inst_36748 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_36749 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_36750 = cljs.core.PersistentHashMap.fromArrays(inst_36748,inst_36749);
var inst_36751 = cljs.core.ex_info.call(null,inst_36747,inst_36750);
var inst_36752 = (function(){throw inst_36751})();
var state_36928__$1 = state_36928;
var statearr_36954_37015 = state_36928__$1;
(statearr_36954_37015[(2)] = inst_36752);

(statearr_36954_37015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (28))){
var inst_36772 = (state_36928[(25)]);
var inst_36887 = (state_36928[(2)]);
var state_36928__$1 = (function (){var statearr_36955 = state_36928;
(statearr_36955[(35)] = inst_36887);

return statearr_36955;
})();
if(cljs.core.truth_(inst_36772)){
var statearr_36956_37016 = state_36928__$1;
(statearr_36956_37016[(1)] = (30));

} else {
var statearr_36957_37017 = state_36928__$1;
(statearr_36957_37017[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (25))){
var inst_36878 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
if(cljs.core.truth_(inst_36878)){
var statearr_36958_37018 = state_36928__$1;
(statearr_36958_37018[(1)] = (26));

} else {
var statearr_36959_37019 = state_36928__$1;
(statearr_36959_37019[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (34))){
var inst_36852 = (state_36928[(10)]);
var inst_36860 = (state_36928[(34)]);
var inst_36908 = cljs.core.conj.call(null,inst_36852,inst_36860);
var state_36928__$1 = state_36928;
var statearr_36960_37020 = state_36928__$1;
(statearr_36960_37020[(2)] = inst_36908);

(statearr_36960_37020[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (17))){
var inst_36800 = (state_36928[(36)]);
var inst_36804 = (state_36928[(2)]);
var inst_36805 = fluree.db.util.async.throw_err.call(null,inst_36804);
var inst_36792 = inst_36800;
var inst_36793 = inst_36805;
var state_36928__$1 = (function (){var statearr_36961 = state_36928;
(statearr_36961[(22)] = inst_36793);

(statearr_36961[(37)] = inst_36792);

return statearr_36961;
})();
var statearr_36962_37021 = state_36928__$1;
(statearr_36962_37021[(2)] = null);

(statearr_36962_37021[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (3))){
var inst_36926 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_36928__$1,inst_36926);
} else {
if((state_val_36929 === (12))){
var inst_36799 = (state_36928[(38)]);
var inst_36792 = (state_36928[(37)]);
var inst_36798 = cljs.core.seq.call(null,inst_36792);
var inst_36799__$1 = cljs.core.first.call(null,inst_36798);
var inst_36800 = cljs.core.next.call(null,inst_36798);
var state_36928__$1 = (function (){var statearr_36963 = state_36928;
(statearr_36963[(38)] = inst_36799__$1);

(statearr_36963[(36)] = inst_36800);

return statearr_36963;
})();
if(cljs.core.truth_(inst_36799__$1)){
var statearr_36964_37022 = state_36928__$1;
(statearr_36964_37022[(1)] = (14));

} else {
var statearr_36965_37023 = state_36928__$1;
(statearr_36965_37023[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (2))){
var inst_36740 = (state_36928[(26)]);
var _ = (function (){var statearr_36966 = state_36928;
(statearr_36966[(4)] = cljs.core.cons.call(null,(5),(state_36928[(4)])));

return statearr_36966;
})();
var inst_36739 = cljs.core.first.call(null,flakes);
var inst_36740__$1 = inst_36739.t;
var inst_36741 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_36742 = (inst_36741 - (1));
var inst_36743 = cljs.core.not_EQ_.call(null,inst_36740__$1,inst_36742);
var state_36928__$1 = (function (){var statearr_36967 = state_36928;
(statearr_36967[(26)] = inst_36740__$1);

return statearr_36967;
})();
if(inst_36743){
var statearr_36968_37024 = state_36928__$1;
(statearr_36968_37024[(1)] = (6));

} else {
var statearr_36969_37025 = state_36928__$1;
(statearr_36969_37025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (23))){
var inst_36771 = (state_36928[(8)]);
var state_36928__$1 = state_36928;
var statearr_36970_37026 = state_36928__$1;
(statearr_36970_37026[(2)] = inst_36771);

(statearr_36970_37026[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (35))){
var inst_36852 = (state_36928[(10)]);
var state_36928__$1 = state_36928;
var statearr_36971_37027 = state_36928__$1;
(statearr_36971_37027[(2)] = inst_36852);

(statearr_36971_37027[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (19))){
var inst_36923 = (state_36928[(2)]);
var _ = (function (){var statearr_36972 = state_36928;
(statearr_36972[(4)] = cljs.core.rest.call(null,(state_36928[(4)])));

return statearr_36972;
})();
var state_36928__$1 = state_36928;
var statearr_36973_37028 = state_36928__$1;
(statearr_36973_37028[(2)] = inst_36923);

(statearr_36973_37028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (11))){
var inst_36780 = (state_36928[(28)]);
var inst_36780__$1 = (state_36928[(2)]);
var inst_36788 = cljs.core.seq.call(null,inst_36780__$1);
var inst_36789 = cljs.core.first.call(null,inst_36788);
var inst_36790 = cljs.core.next.call(null,inst_36788);
var inst_36791 = db;
var inst_36792 = inst_36780__$1;
var inst_36793 = inst_36791;
var state_36928__$1 = (function (){var statearr_36975 = state_36928;
(statearr_36975[(39)] = inst_36789);

(statearr_36975[(28)] = inst_36780__$1);

(statearr_36975[(40)] = inst_36790);

(statearr_36975[(22)] = inst_36793);

(statearr_36975[(37)] = inst_36792);

return statearr_36975;
})();
var statearr_36976_37029 = state_36928__$1;
(statearr_36976_37029[(2)] = null);

(statearr_36976_37029[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (9))){
var inst_36757 = (state_36928[(23)]);
var inst_36774 = (state_36928[(27)]);
var inst_36776 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_36757,inst_36774);
var state_36928__$1 = state_36928;
var statearr_36977_37030 = state_36928__$1;
(statearr_36977_37030[(2)] = inst_36776);

(statearr_36977_37030[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (5))){
var _ = (function (){var statearr_36978 = state_36928;
(statearr_36978[(4)] = cljs.core.rest.call(null,(state_36928[(4)])));

return statearr_36978;
})();
var state_36928__$1 = state_36928;
var ex36974 = (state_36928__$1[(2)]);
var statearr_36979_37031 = state_36928__$1;
(statearr_36979_37031[(5)] = ex36974);


if((ex36974 instanceof Error)){
var statearr_36980_37032 = state_36928__$1;
(statearr_36980_37032[(1)] = (4));

(statearr_36980_37032[(5)] = null);

} else {
throw ex36974;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (14))){
var inst_36799 = (state_36928[(38)]);
var inst_36793 = (state_36928[(22)]);
var inst_36802 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_36793,inst_36799);
var state_36928__$1 = state_36928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36928__$1,(17),inst_36802);
} else {
if((state_val_36929 === (26))){
var inst_36872 = (state_36928[(15)]);
var inst_36880 = fluree.db.query.schema.schema_map.call(null,inst_36872);
var state_36928__$1 = state_36928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36928__$1,(29),inst_36880);
} else {
if((state_val_36929 === (16))){
var inst_36809 = (state_36928[(2)]);
var state_36928__$1 = state_36928;
var statearr_36981_37033 = state_36928__$1;
(statearr_36981_37033[(2)] = inst_36809);

(statearr_36981_37033[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (38))){
var inst_36853 = (state_36928[(7)]);
var state_36928__$1 = state_36928;
var statearr_36982_37034 = state_36928__$1;
(statearr_36982_37034[(2)] = inst_36853);

(statearr_36982_37034[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (30))){
var inst_36887 = (state_36928[(35)]);
var inst_36890 = fluree.db.query.schema.setting_map.call(null,inst_36887);
var state_36928__$1 = state_36928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_36928__$1,(33),inst_36890);
} else {
if((state_val_36929 === (10))){
var inst_36778 = cljs.core.PersistentVector.EMPTY;
var state_36928__$1 = state_36928;
var statearr_36983_37035 = state_36928__$1;
(statearr_36983_37035[(2)] = inst_36778);

(statearr_36983_37035[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (18))){
var inst_36849 = (state_36928[(21)]);
var inst_36860 = (state_36928[(34)]);
var inst_36859 = cljs.core.seq.call(null,inst_36849);
var inst_36860__$1 = cljs.core.first.call(null,inst_36859);
var inst_36861 = cljs.core.next.call(null,inst_36859);
var inst_36862 = cljs.core.not.call(null,inst_36860__$1);
var state_36928__$1 = (function (){var statearr_36984 = state_36928;
(statearr_36984[(17)] = inst_36861);

(statearr_36984[(34)] = inst_36860__$1);

return statearr_36984;
})();
if(inst_36862){
var statearr_36985_37036 = state_36928__$1;
(statearr_36985_37036[(1)] = (20));

} else {
var statearr_36986_37037 = state_36928__$1;
(statearr_36986_37037[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (37))){
var inst_36853 = (state_36928[(7)]);
var inst_36860 = (state_36928[(34)]);
var inst_36915 = cljs.core.conj.call(null,inst_36853,inst_36860);
var state_36928__$1 = state_36928;
var statearr_36987_37038 = state_36928__$1;
(statearr_36987_37038[(2)] = inst_36915);

(statearr_36987_37038[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36929 === (8))){
var inst_36757 = (state_36928[(23)]);
var inst_36765 = (state_36928[(24)]);
var inst_36740 = (state_36928[(26)]);
var inst_36771 = (state_36928[(8)]);
var inst_36755 = (state_36928[(29)]);
var inst_36761 = (state_36928[(30)]);
var inst_36755__$1 = (state_36928[(2)]);
var inst_36756 = (function (){var t = inst_36740;
var _ = inst_36755__$1;
return (function (p1__36730_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__36730_SHARP_.p));
});
})();
var inst_36757__$1 = cljs.core.filter.call(null,inst_36756,flakes);
var inst_36758 = cljs.core.PersistentHashSet.EMPTY;
var inst_36759 = (function (){var t = inst_36740;
var _ = inst_36755__$1;
var add_flakes = inst_36757__$1;
return (function (p1__36731_SHARP_){
return p1__36731_SHARP_.p;
});
})();
var inst_36760 = cljs.core.map.call(null,inst_36759,inst_36757__$1);
var inst_36761__$1 = cljs.core.into.call(null,inst_36758,inst_36760);
var inst_36762 = cljs.core.PersistentHashMap.EMPTY;
var inst_36763 = (function (){var t = inst_36740;
var _ = inst_36755__$1;
var add_flakes = inst_36757__$1;
var add_preds = inst_36761__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_36764 = cljs.core.map.call(null,inst_36763,inst_36761__$1);
var inst_36765__$1 = cljs.core.into.call(null,inst_36762,inst_36764);
var inst_36766 = cljs.core.PersistentHashMap.EMPTY;
var inst_36767 = (function (){var t = inst_36740;
var _ = inst_36755__$1;
var add_flakes = inst_36757__$1;
var add_preds = inst_36761__$1;
var idx_QMARK__map = inst_36765__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_36768 = cljs.core.map.call(null,inst_36767,inst_36761__$1);
var inst_36769 = cljs.core.into.call(null,inst_36766,inst_36768);
var inst_36770 = fluree.db.flake.size_bytes.call(null,inst_36757__$1);
var inst_36771__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_36757__$1);
var inst_36772 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_36757__$1);
var inst_36773 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_36774 = cljs.core.get.call(null,inst_36773,(0));
var state_36928__$1 = (function (){var statearr_36988 = state_36928;
(statearr_36988[(23)] = inst_36757__$1);

(statearr_36988[(24)] = inst_36765__$1);

(statearr_36988[(25)] = inst_36772);

(statearr_36988[(8)] = inst_36771__$1);

(statearr_36988[(27)] = inst_36774);

(statearr_36988[(29)] = inst_36755__$1);

(statearr_36988[(11)] = inst_36770);

(statearr_36988[(30)] = inst_36761__$1);

(statearr_36988[(31)] = inst_36769);

return statearr_36988;
})();
if(cljs.core.truth_(inst_36771__$1)){
var statearr_36989_37039 = state_36928__$1;
(statearr_36989_37039[(1)] = (9));

} else {
var statearr_36990_37040 = state_36928__$1;
(statearr_36990_37040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__11469__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__11469__auto____0 = (function (){
var statearr_36991 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36991[(0)] = fluree$db$graphdb$with_t_$_state_machine__11469__auto__);

(statearr_36991[(1)] = (1));

return statearr_36991;
});
var fluree$db$graphdb$with_t_$_state_machine__11469__auto____1 = (function (state_36928){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_36928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e36992){var ex__11472__auto__ = e36992;
var statearr_36993_37041 = state_36928;
(statearr_36993_37041[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_36928[(4)]))){
var statearr_36994_37042 = state_36928;
(statearr_36994_37042[(1)] = cljs.core.first.call(null,(state_36928[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37043 = state_36928;
state_36928 = G__37043;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__11469__auto__ = function(state_36928){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__11469__auto____1.call(this,state_36928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__11469__auto____0;
fluree$db$graphdb$with_t_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__11469__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_36995 = f__11543__auto__.call(null);
(statearr_36995[(6)] = c__11542__auto__);

return statearr_36995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__11542__auto___37189 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37139){
var state_val_37140 = (state_37139[(1)]);
if((state_val_37140 === (7))){
var state_37139__$1 = state_37139;
var statearr_37141_37190 = state_37139__$1;
(statearr_37141_37190[(2)] = null);

(statearr_37141_37190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (20))){
var inst_37089 = (state_37139[(7)]);
var inst_37087 = (state_37139[(8)]);
var inst_37088 = (state_37139[(9)]);
var inst_37108 = (inst_37087 + (1));
var inst_37109 = cljs.core.assoc.call(null,inst_37089,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37108);
var inst_37110 = fluree.db.graphdb.with_t.call(null,inst_37109,inst_37088);
var state_37139__$1 = state_37139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37139__$1,(23),inst_37110);
} else {
if((state_val_37140 === (1))){
var state_37139__$1 = state_37139;
var statearr_37142_37191 = state_37139__$1;
(statearr_37142_37191[(2)] = null);

(statearr_37142_37191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (24))){
var inst_37113 = (state_37139[(10)]);
var inst_37116 = cljs.core.assoc.call(null,inst_37113,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_37139__$1 = state_37139;
var statearr_37143_37192 = state_37139__$1;
(statearr_37143_37192[(2)] = inst_37116);

(statearr_37143_37192[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (4))){
var inst_37044 = (state_37139[(2)]);
var inst_37045 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37044);
var state_37139__$1 = state_37139;
var statearr_37144_37193 = state_37139__$1;
(statearr_37144_37193[(2)] = inst_37045);

(statearr_37144_37193[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (15))){
var inst_37095 = (state_37139[(11)]);
var state_37139__$1 = state_37139;
var statearr_37145_37194 = state_37139__$1;
(statearr_37145_37194[(2)] = inst_37095);

(statearr_37145_37194[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (21))){
var state_37139__$1 = state_37139;
var statearr_37146_37195 = state_37139__$1;
(statearr_37146_37195[(2)] = null);

(statearr_37146_37195[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (13))){
var inst_37131 = (state_37139[(2)]);
var inst_37132 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37131);
var state_37139__$1 = state_37139;
var statearr_37147_37196 = state_37139__$1;
(statearr_37147_37196[(2)] = inst_37132);

(statearr_37147_37196[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (22))){
var inst_37127 = (state_37139[(2)]);
var state_37139__$1 = state_37139;
var statearr_37148_37197 = state_37139__$1;
(statearr_37148_37197[(2)] = inst_37127);

(statearr_37148_37197[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (6))){
var inst_37055 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_37056 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37057 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37055)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37056)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_37058 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37059 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_37060 = cljs.core.PersistentHashMap.fromArrays(inst_37058,inst_37059);
var inst_37061 = cljs.core.ex_info.call(null,inst_37057,inst_37060);
var inst_37062 = (function(){throw inst_37061})();
var state_37139__$1 = state_37139;
var statearr_37151_37198 = state_37139__$1;
(statearr_37151_37198[(2)] = inst_37062);

(statearr_37151_37198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (25))){
var inst_37095 = (state_37139[(11)]);
var inst_37113 = (state_37139[(10)]);
var inst_37096 = (state_37139[(12)]);
var inst_37118 = inst_37095.t;
var inst_37119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37120 = [inst_37095];
var inst_37121 = (new cljs.core.PersistentVector(null,1,(5),inst_37119,inst_37120,null));
var inst_37086 = inst_37096;
var inst_37087 = inst_37118;
var inst_37088 = inst_37121;
var inst_37089 = inst_37113;
var state_37139__$1 = (function (){var statearr_37152 = state_37139;
(statearr_37152[(13)] = inst_37086);

(statearr_37152[(7)] = inst_37089);

(statearr_37152[(8)] = inst_37087);

(statearr_37152[(9)] = inst_37088);

return statearr_37152;
})();
var statearr_37153_37199 = state_37139__$1;
(statearr_37153_37199[(2)] = null);

(statearr_37153_37199[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (17))){
var inst_37095 = (state_37139[(11)]);
var inst_37096 = (state_37139[(12)]);
var inst_37089 = (state_37139[(7)]);
var inst_37087 = (state_37139[(8)]);
var inst_37088 = (state_37139[(9)]);
var inst_37104 = cljs.core.conj.call(null,inst_37088,inst_37095);
var tmp37149 = inst_37089;
var tmp37150 = inst_37087;
var inst_37086 = inst_37096;
var inst_37087__$1 = tmp37150;
var inst_37088__$1 = inst_37104;
var inst_37089__$1 = tmp37149;
var state_37139__$1 = (function (){var statearr_37154 = state_37139;
(statearr_37154[(13)] = inst_37086);

(statearr_37154[(7)] = inst_37089__$1);

(statearr_37154[(8)] = inst_37087__$1);

(statearr_37154[(9)] = inst_37088__$1);

return statearr_37154;
})();
var statearr_37155_37200 = state_37139__$1;
(statearr_37155_37200[(2)] = null);

(statearr_37155_37200[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (3))){
var inst_37137 = (state_37139[(2)]);
var state_37139__$1 = state_37139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37139__$1,inst_37137);
} else {
if((state_val_37140 === (12))){
var inst_37095 = (state_37139[(11)]);
var inst_37086 = (state_37139[(13)]);
var inst_37094 = cljs.core.seq.call(null,inst_37086);
var inst_37095__$1 = cljs.core.first.call(null,inst_37094);
var inst_37096 = cljs.core.next.call(null,inst_37094);
var state_37139__$1 = (function (){var statearr_37156 = state_37139;
(statearr_37156[(11)] = inst_37095__$1);

(statearr_37156[(12)] = inst_37096);

return statearr_37156;
})();
if(cljs.core.truth_(inst_37095__$1)){
var statearr_37157_37201 = state_37139__$1;
(statearr_37157_37201[(1)] = (14));

} else {
var statearr_37158_37202 = state_37139__$1;
(statearr_37158_37202[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (2))){
var _ = (function (){var statearr_37159 = state_37139;
(statearr_37159[(4)] = cljs.core.cons.call(null,(5),(state_37139[(4)])));

return statearr_37159;
})();
var inst_37051 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_37052 = (inst_37051 + (1));
var inst_37053 = cljs.core.not_EQ_.call(null,block,inst_37052);
var state_37139__$1 = state_37139;
if(inst_37053){
var statearr_37160_37203 = state_37139__$1;
(statearr_37160_37203[(1)] = (6));

} else {
var statearr_37161_37204 = state_37139__$1;
(statearr_37161_37204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (23))){
var inst_37095 = (state_37139[(11)]);
var inst_37112 = (state_37139[(2)]);
var inst_37113 = fluree.db.util.async.throw_err.call(null,inst_37112);
var inst_37114 = (inst_37095 == null);
var state_37139__$1 = (function (){var statearr_37162 = state_37139;
(statearr_37162[(10)] = inst_37113);

return statearr_37162;
})();
if(cljs.core.truth_(inst_37114)){
var statearr_37163_37205 = state_37139__$1;
(statearr_37163_37205[(1)] = (24));

} else {
var statearr_37164_37206 = state_37139__$1;
(statearr_37164_37206[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (19))){
var inst_37129 = (state_37139[(2)]);
var state_37139__$1 = state_37139;
var statearr_37165_37207 = state_37139__$1;
(statearr_37165_37207[(2)] = inst_37129);

(statearr_37165_37207[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (11))){
var inst_37134 = (state_37139[(2)]);
var _ = (function (){var statearr_37167 = state_37139;
(statearr_37167[(4)] = cljs.core.rest.call(null,(state_37139[(4)])));

return statearr_37167;
})();
var state_37139__$1 = state_37139;
var statearr_37168_37208 = state_37139__$1;
(statearr_37168_37208[(2)] = inst_37134);

(statearr_37168_37208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (9))){
var inst_37068 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_37069 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_37068);
var state_37139__$1 = state_37139;
var statearr_37169_37209 = state_37139__$1;
(statearr_37169_37209[(2)] = inst_37069);

(statearr_37169_37209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (5))){
var _ = (function (){var statearr_37170 = state_37139;
(statearr_37170[(4)] = cljs.core.rest.call(null,(state_37139[(4)])));

return statearr_37170;
})();
var state_37139__$1 = state_37139;
var ex37166 = (state_37139__$1[(2)]);
var statearr_37171_37210 = state_37139__$1;
(statearr_37171_37210[(5)] = ex37166);


var statearr_37172_37211 = state_37139__$1;
(statearr_37172_37211[(1)] = (4));

(statearr_37172_37211[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (14))){
var inst_37095 = (state_37139[(11)]);
var inst_37087 = (state_37139[(8)]);
var inst_37098 = inst_37095.t;
var inst_37099 = cljs.core._EQ_.call(null,inst_37087,inst_37098);
var state_37139__$1 = state_37139;
var statearr_37173_37212 = state_37139__$1;
(statearr_37173_37212[(2)] = inst_37099);

(statearr_37173_37212[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (26))){
var inst_37124 = (state_37139[(2)]);
var state_37139__$1 = state_37139;
var statearr_37174_37213 = state_37139__$1;
(statearr_37174_37213[(2)] = inst_37124);

(statearr_37174_37213[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (16))){
var inst_37102 = (state_37139[(2)]);
var state_37139__$1 = state_37139;
if(cljs.core.truth_(inst_37102)){
var statearr_37175_37214 = state_37139__$1;
(statearr_37175_37214[(1)] = (17));

} else {
var statearr_37176_37215 = state_37139__$1;
(statearr_37176_37215[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (10))){
var inst_37071 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_37079 = cljs.core.seq.call(null,inst_37071);
var inst_37080 = cljs.core.first.call(null,inst_37079);
var inst_37081 = cljs.core.next.call(null,inst_37079);
var inst_37082 = cljs.core.first.call(null,inst_37071);
var inst_37083 = inst_37082.t;
var inst_37084 = cljs.core.PersistentVector.EMPTY;
var inst_37085 = db;
var inst_37086 = inst_37071;
var inst_37087 = inst_37083;
var inst_37088 = inst_37084;
var inst_37089 = inst_37085;
var state_37139__$1 = (function (){var statearr_37177 = state_37139;
(statearr_37177[(13)] = inst_37086);

(statearr_37177[(7)] = inst_37089);

(statearr_37177[(8)] = inst_37087);

(statearr_37177[(14)] = inst_37080);

(statearr_37177[(9)] = inst_37088);

(statearr_37177[(15)] = inst_37081);

return statearr_37177;
})();
var statearr_37178_37216 = state_37139__$1;
(statearr_37178_37216[(2)] = null);

(statearr_37178_37216[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (18))){
var state_37139__$1 = state_37139;
var statearr_37179_37217 = state_37139__$1;
(statearr_37179_37217[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37140 === (8))){
var inst_37065 = (state_37139[(2)]);
var inst_37066 = cljs.core.empty_QMARK_.call(null,flakes);
var state_37139__$1 = (function (){var statearr_37181 = state_37139;
(statearr_37181[(16)] = inst_37065);

return statearr_37181;
})();
if(inst_37066){
var statearr_37182_37218 = state_37139__$1;
(statearr_37182_37218[(1)] = (9));

} else {
var statearr_37183_37219 = state_37139__$1;
(statearr_37183_37219[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__11469__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__11469__auto____0 = (function (){
var statearr_37184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37184[(0)] = fluree$db$graphdb$with_$_state_machine__11469__auto__);

(statearr_37184[(1)] = (1));

return statearr_37184;
});
var fluree$db$graphdb$with_$_state_machine__11469__auto____1 = (function (state_37139){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37185){var ex__11472__auto__ = e37185;
var statearr_37186_37220 = state_37139;
(statearr_37186_37220[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37139[(4)]))){
var statearr_37187_37221 = state_37139;
(statearr_37187_37221[(1)] = cljs.core.first.call(null,(state_37139[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37222 = state_37139;
state_37139 = G__37222;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__11469__auto__ = function(state_37139){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__11469__auto____1.call(this,state_37139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__11469__auto____0;
fluree$db$graphdb$with_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__11469__auto____1;
return fluree$db$graphdb$with_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37188 = f__11543__auto__.call(null);
(statearr_37188[(6)] = c__11542__auto___37189);

return statearr_37188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37278){
var state_val_37279 = (state_37278[(1)]);
if((state_val_37279 === (7))){
var state_37278__$1 = state_37278;
var statearr_37280_37307 = state_37278__$1;
(statearr_37280_37307[(2)] = tt_id);

(statearr_37280_37307[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (1))){
var state_37278__$1 = state_37278;
var statearr_37281_37308 = state_37278__$1;
(statearr_37281_37308[(2)] = null);

(statearr_37281_37308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (4))){
var inst_37223 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
var statearr_37282_37309 = state_37278__$1;
(statearr_37282_37309[(2)] = inst_37223);

(statearr_37282_37309[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (13))){
var inst_37271 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
var statearr_37283_37310 = state_37278__$1;
(statearr_37283_37310[(2)] = inst_37271);

(statearr_37283_37310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (6))){
var inst_37231 = fluree.db.util.core.random_uuid.call(null);
var state_37278__$1 = state_37278;
var statearr_37284_37311 = state_37278__$1;
(statearr_37284_37311[(2)] = inst_37231);

(statearr_37284_37311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (3))){
var inst_37276 = (state_37278[(2)]);
var state_37278__$1 = state_37278;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37278__$1,inst_37276);
} else {
if((state_val_37279 === (12))){
var inst_37254 = (state_37278[(7)]);
var state_37278__$1 = state_37278;
var statearr_37285_37312 = state_37278__$1;
(statearr_37285_37312[(2)] = inst_37254);

(statearr_37285_37312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (2))){
var _ = (function (){var statearr_37286 = state_37278;
(statearr_37286[(4)] = cljs.core.cons.call(null,(5),(state_37278[(4)])));

return statearr_37286;
})();
var inst_37229 = (tt_id == null);
var state_37278__$1 = state_37278;
if(cljs.core.truth_(inst_37229)){
var statearr_37287_37313 = state_37278__$1;
(statearr_37287_37313[(1)] = (6));

} else {
var statearr_37288_37314 = state_37278__$1;
(statearr_37288_37314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (11))){
var inst_37261 = (state_37278[(8)]);
var inst_37254 = (state_37278[(7)]);
var inst_37264 = fluree.db.graphdb.with_t.call(null,inst_37254,inst_37261);
var state_37278__$1 = state_37278;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37278__$1,(14),inst_37264);
} else {
if((state_val_37279 === (9))){
var inst_37261 = (state_37278[(8)]);
var inst_37255 = (state_37278[(9)]);
var inst_37260 = cljs.core.seq.call(null,inst_37255);
var inst_37261__$1 = cljs.core.first.call(null,inst_37260);
var inst_37262 = cljs.core.next.call(null,inst_37260);
var state_37278__$1 = (function (){var statearr_37290 = state_37278;
(statearr_37290[(10)] = inst_37262);

(statearr_37290[(8)] = inst_37261__$1);

return statearr_37290;
})();
if(cljs.core.truth_(inst_37261__$1)){
var statearr_37291_37315 = state_37278__$1;
(statearr_37291_37315[(1)] = (11));

} else {
var statearr_37292_37316 = state_37278__$1;
(statearr_37292_37316[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (5))){
var _ = (function (){var statearr_37293 = state_37278;
(statearr_37293[(4)] = cljs.core.rest.call(null,(state_37278[(4)])));

return statearr_37293;
})();
var state_37278__$1 = state_37278;
var ex37289 = (state_37278__$1[(2)]);
var statearr_37294_37317 = state_37278__$1;
(statearr_37294_37317[(5)] = ex37289);


if((ex37289 instanceof Error)){
var statearr_37295_37318 = state_37278__$1;
(statearr_37295_37318[(1)] = (4));

(statearr_37295_37318[(5)] = null);

} else {
throw ex37289;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (14))){
var inst_37262 = (state_37278[(10)]);
var inst_37266 = (state_37278[(2)]);
var inst_37267 = fluree.db.util.async.throw_err.call(null,inst_37266);
var inst_37254 = inst_37267;
var inst_37255 = inst_37262;
var state_37278__$1 = (function (){var statearr_37296 = state_37278;
(statearr_37296[(7)] = inst_37254);

(statearr_37296[(9)] = inst_37255);

return statearr_37296;
})();
var statearr_37297_37319 = state_37278__$1;
(statearr_37297_37319[(2)] = null);

(statearr_37297_37319[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (10))){
var inst_37273 = (state_37278[(2)]);
var _ = (function (){var statearr_37298 = state_37278;
(statearr_37298[(4)] = cljs.core.rest.call(null,(state_37278[(4)])));

return statearr_37298;
})();
var state_37278__$1 = state_37278;
var statearr_37299_37320 = state_37278__$1;
(statearr_37299_37320[(2)] = inst_37273);

(statearr_37299_37320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37279 === (8))){
var inst_37234 = (state_37278[(2)]);
var inst_37235 = (function (){var tt_id_SINGLEQUOTE_ = inst_37234;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_37236 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_37234);
var inst_37237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37238 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_37239 = (new cljs.core.PersistentVector(null,4,(5),inst_37237,inst_37238,null));
var inst_37240 = cljs.core.reduce.call(null,inst_37235,inst_37236,inst_37239);
var inst_37241 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_37242 = cljs.core.reverse.call(null,inst_37241);
var inst_37243 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_37242);
var inst_37251 = cljs.core.seq.call(null,inst_37243);
var inst_37252 = cljs.core.first.call(null,inst_37251);
var inst_37253 = cljs.core.next.call(null,inst_37251);
var inst_37254 = inst_37240;
var inst_37255 = inst_37243;
var state_37278__$1 = (function (){var statearr_37300 = state_37278;
(statearr_37300[(11)] = inst_37252);

(statearr_37300[(7)] = inst_37254);

(statearr_37300[(9)] = inst_37255);

(statearr_37300[(12)] = inst_37253);

return statearr_37300;
})();
var statearr_37301_37321 = state_37278__$1;
(statearr_37301_37321[(2)] = null);

(statearr_37301_37321[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____0 = (function (){
var statearr_37302 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37302[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__);

(statearr_37302[(1)] = (1));

return statearr_37302;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____1 = (function (state_37278){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37278);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37303){var ex__11472__auto__ = e37303;
var statearr_37304_37322 = state_37278;
(statearr_37304_37322[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37278[(4)]))){
var statearr_37305_37323 = state_37278;
(statearr_37305_37323[(1)] = cljs.core.first.call(null,(state_37278[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37324 = state_37278;
state_37278 = G__37324;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__ = function(state_37278){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____1.call(this,state_37278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37306 = f__11543__auto__.call(null);
(statearr_37306[(6)] = c__11542__auto__);

return statearr_37306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__11542__auto___37502 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37439){
var state_val_37440 = (state_37439[(1)]);
if((state_val_37440 === (7))){
var inst_37352 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var inst_37353 = cljs.core.first.call(null,ident);
var inst_37354 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_37353);
var inst_37355 = (inst_37354 == null);
var inst_37356 = ((inst_37352) && (inst_37355));
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37356)){
var statearr_37441_37503 = state_37439__$1;
(statearr_37441_37503[(1)] = (13));

} else {
var statearr_37442_37504 = state_37439__$1;
(statearr_37442_37504[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (20))){
var state_37439__$1 = state_37439;
var statearr_37443_37505 = state_37439__$1;
(statearr_37443_37505[(2)] = null);

(statearr_37443_37505[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (27))){
var state_37439__$1 = state_37439;
var statearr_37444_37506 = state_37439__$1;
(statearr_37444_37506[(2)] = null);

(statearr_37444_37506[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (1))){
var state_37439__$1 = state_37439;
var statearr_37445_37507 = state_37439__$1;
(statearr_37445_37507[(2)] = null);

(statearr_37445_37507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (24))){
var inst_37385 = (state_37439[(7)]);
var inst_37389 = inst_37385.s;
var state_37439__$1 = state_37439;
var statearr_37446_37508 = state_37439__$1;
(statearr_37446_37508[(2)] = inst_37389);

(statearr_37446_37508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (39))){
var state_37439__$1 = state_37439;
var statearr_37447_37509 = state_37439__$1;
(statearr_37447_37509[(2)] = null);

(statearr_37447_37509[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (4))){
var inst_37325 = (state_37439[(2)]);
var inst_37326 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_37327 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37328 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_37329 = cljs.core.PersistentHashMap.fromArrays(inst_37327,inst_37328);
var inst_37330 = cljs.core.ex_info.call(null,inst_37326,inst_37329,inst_37325);
var inst_37331 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37330);
var state_37439__$1 = state_37439;
var statearr_37448_37510 = state_37439__$1;
(statearr_37448_37510[(2)] = inst_37331);

(statearr_37448_37510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (15))){
var inst_37407 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37449_37511 = state_37439__$1;
(statearr_37449_37511[(2)] = inst_37407);

(statearr_37449_37511[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (21))){
var inst_37379 = (state_37439[(8)]);
var inst_37383 = cljs.core.first.call(null,inst_37379);
var state_37439__$1 = state_37439;
var statearr_37450_37512 = state_37439__$1;
(statearr_37450_37512[(2)] = inst_37383);

(statearr_37450_37512[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (31))){
var inst_37434 = (state_37439[(2)]);
var _ = (function (){var statearr_37451 = state_37439;
(statearr_37451[(4)] = cljs.core.rest.call(null,(state_37439[(4)])));

return statearr_37451;
})();
var state_37439__$1 = state_37439;
var statearr_37452_37513 = state_37439__$1;
(statearr_37452_37513[(2)] = inst_37434);

(statearr_37452_37513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (32))){
var state_37439__$1 = state_37439;
var statearr_37453_37514 = state_37439__$1;
(statearr_37453_37514[(2)] = strict_QMARK_);

(statearr_37453_37514[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (40))){
var inst_37430 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37454_37515 = state_37439__$1;
(statearr_37454_37515[(2)] = inst_37430);

(statearr_37454_37515[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (33))){
var state_37439__$1 = state_37439;
var statearr_37455_37516 = state_37439__$1;
(statearr_37455_37516[(2)] = false);

(statearr_37455_37516[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (13))){
var inst_37358 = cljs.core.first.call(null,ident);
var inst_37359 = cljs.core.pr_str.call(null,inst_37358);
var inst_37360 = ["Subject ID lookup failed. The predicate ",inst_37359," does not exist."].join('');
var inst_37361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37362 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_37363 = cljs.core.PersistentHashMap.fromArrays(inst_37361,inst_37362);
var inst_37364 = cljs.core.ex_info.call(null,inst_37360,inst_37363);
var inst_37365 = (function(){throw inst_37364})();
var state_37439__$1 = state_37439;
var statearr_37456_37517 = state_37439__$1;
(statearr_37456_37517[(2)] = inst_37365);

(statearr_37456_37517[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (22))){
var inst_37385 = (state_37439[(7)]);
var inst_37385__$1 = (state_37439[(2)]);
var inst_37386 = (inst_37385__$1 == null);
var state_37439__$1 = (function (){var statearr_37457 = state_37439;
(statearr_37457[(7)] = inst_37385__$1);

return statearr_37457;
})();
if(cljs.core.truth_(inst_37386)){
var statearr_37458_37518 = state_37439__$1;
(statearr_37458_37518[(1)] = (23));

} else {
var statearr_37459_37519 = state_37439__$1;
(statearr_37459_37519[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (36))){
var state_37439__$1 = state_37439;
var statearr_37460_37520 = state_37439__$1;
(statearr_37460_37520[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (29))){
var inst_37409 = (state_37439[(9)]);
var inst_37411 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37409);
var state_37439__$1 = state_37439;
var statearr_37462_37521 = state_37439__$1;
(statearr_37462_37521[(2)] = inst_37411);

(statearr_37462_37521[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (6))){
var inst_37339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37340 = [ident];
var inst_37341 = (new cljs.core.PersistentVector(null,1,(5),inst_37339,inst_37340,null));
var inst_37342 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_37341);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37439__$1,(9),inst_37342);
} else {
if((state_val_37440 === (28))){
var inst_37403 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37463_37522 = state_37439__$1;
(statearr_37463_37522[(2)] = inst_37403);

(statearr_37463_37522[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (25))){
var inst_37391 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37464_37523 = state_37439__$1;
(statearr_37464_37523[(2)] = inst_37391);

(statearr_37464_37523[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (34))){
var inst_37417 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37417)){
var statearr_37465_37524 = state_37439__$1;
(statearr_37465_37524[(1)] = (35));

} else {
var statearr_37466_37525 = state_37439__$1;
(statearr_37466_37525[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (17))){
var state_37439__$1 = state_37439;
var statearr_37467_37526 = state_37439__$1;
(statearr_37467_37526[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (3))){
var inst_37437 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37439__$1,inst_37437);
} else {
if((state_val_37440 === (12))){
var inst_37350 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37469_37527 = state_37439__$1;
(statearr_37469_37527[(2)] = inst_37350);

(statearr_37469_37527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (2))){
var _ = (function (){var statearr_37470 = state_37439;
(statearr_37470[(4)] = cljs.core.cons.call(null,(5),(state_37439[(4)])));

return statearr_37470;
})();
var inst_37337 = typeof ident === 'number';
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37337)){
var statearr_37471_37528 = state_37439__$1;
(statearr_37471_37528[(1)] = (6));

} else {
var statearr_37472_37529 = state_37439__$1;
(statearr_37472_37529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (23))){
var state_37439__$1 = state_37439;
var statearr_37473_37530 = state_37439__$1;
(statearr_37473_37530[(2)] = null);

(statearr_37473_37530[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (35))){
var inst_37419 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_37420 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37421 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_37422 = cljs.core.PersistentHashMap.fromArrays(inst_37420,inst_37421);
var inst_37423 = cljs.core.ex_info.call(null,inst_37419,inst_37422);
var inst_37424 = cljs.core.async.put_BANG_.call(null,return_chan,inst_37423);
var state_37439__$1 = state_37439;
var statearr_37474_37531 = state_37439__$1;
(statearr_37474_37531[(2)] = inst_37424);

(statearr_37474_37531[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (19))){
var inst_37379 = (state_37439[(8)]);
var inst_37378 = (state_37439[(2)]);
var inst_37379__$1 = fluree.db.util.async.throw_err.call(null,inst_37378);
var inst_37380 = (inst_37379__$1 == null);
var state_37439__$1 = (function (){var statearr_37475 = state_37439;
(statearr_37475[(8)] = inst_37379__$1);

return statearr_37475;
})();
if(cljs.core.truth_(inst_37380)){
var statearr_37476_37532 = state_37439__$1;
(statearr_37476_37532[(1)] = (20));

} else {
var statearr_37477_37533 = state_37439__$1;
(statearr_37477_37533[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (11))){
var state_37439__$1 = state_37439;
var statearr_37479_37534 = state_37439__$1;
(statearr_37479_37534[(2)] = null);

(statearr_37479_37534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (9))){
var inst_37344 = (state_37439[(2)]);
var inst_37345 = fluree.db.util.async.throw_err.call(null,inst_37344);
var inst_37346 = cljs.core.not_empty.call(null,inst_37345);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37346)){
var statearr_37480_37535 = state_37439__$1;
(statearr_37480_37535[(1)] = (10));

} else {
var statearr_37481_37536 = state_37439__$1;
(statearr_37481_37536[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (5))){
var _ = (function (){var statearr_37482 = state_37439;
(statearr_37482[(4)] = cljs.core.rest.call(null,(state_37439[(4)])));

return statearr_37482;
})();
var state_37439__$1 = state_37439;
var ex37478 = (state_37439__$1[(2)]);
var statearr_37483_37537 = state_37439__$1;
(statearr_37483_37537[(5)] = ex37478);


var statearr_37484_37538 = state_37439__$1;
(statearr_37484_37538[(1)] = (4));

(statearr_37484_37538[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (14))){
var inst_37367 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_37439__$1 = state_37439;
if(inst_37367){
var statearr_37485_37539 = state_37439__$1;
(statearr_37485_37539[(1)] = (16));

} else {
var statearr_37486_37540 = state_37439__$1;
(statearr_37486_37540[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (26))){
var inst_37394 = cljs.core.pr_str.call(null,ident);
var inst_37395 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_37394].join('');
var inst_37396 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_37397 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_37398 = cljs.core.PersistentHashMap.fromArrays(inst_37396,inst_37397);
var inst_37399 = cljs.core.ex_info.call(null,inst_37395,inst_37398);
var inst_37400 = (function(){throw inst_37399})();
var state_37439__$1 = state_37439;
var statearr_37487_37541 = state_37439__$1;
(statearr_37487_37541[(2)] = inst_37400);

(statearr_37487_37541[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (16))){
var inst_37370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37371 = cljs.core.first.call(null,ident);
var inst_37372 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_37371);
var inst_37373 = cljs.core.second.call(null,ident);
var inst_37374 = [inst_37372,inst_37373];
var inst_37375 = (new cljs.core.PersistentVector(null,2,(5),inst_37370,inst_37374,null));
var inst_37376 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_37375);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37439__$1,(19),inst_37376);
} else {
if((state_val_37440 === (38))){
var inst_37427 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_37439__$1 = state_37439;
var statearr_37488_37542 = state_37439__$1;
(statearr_37488_37542[(2)] = inst_37427);

(statearr_37488_37542[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (30))){
var inst_37409 = (state_37439[(9)]);
var inst_37413 = (inst_37409 == null);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37413)){
var statearr_37489_37543 = state_37439__$1;
(statearr_37489_37543[(1)] = (32));

} else {
var statearr_37490_37544 = state_37439__$1;
(statearr_37490_37544[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (10))){
var state_37439__$1 = state_37439;
var statearr_37491_37545 = state_37439__$1;
(statearr_37491_37545[(2)] = ident);

(statearr_37491_37545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (18))){
var inst_37405 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37492_37546 = state_37439__$1;
(statearr_37492_37546[(2)] = inst_37405);

(statearr_37492_37546[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (37))){
var inst_37432 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37493_37547 = state_37439__$1;
(statearr_37493_37547[(2)] = inst_37432);

(statearr_37493_37547[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37440 === (8))){
var inst_37409 = (state_37439[(9)]);
var inst_37409__$1 = (state_37439[(2)]);
var state_37439__$1 = (function (){var statearr_37494 = state_37439;
(statearr_37494[(9)] = inst_37409__$1);

return statearr_37494;
})();
if(cljs.core.truth_(inst_37409__$1)){
var statearr_37495_37548 = state_37439__$1;
(statearr_37495_37548[(1)] = (29));

} else {
var statearr_37496_37549 = state_37439__$1;
(statearr_37496_37549[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__11469__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__11469__auto____0 = (function (){
var statearr_37497 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37497[(0)] = fluree$db$graphdb$subid_$_state_machine__11469__auto__);

(statearr_37497[(1)] = (1));

return statearr_37497;
});
var fluree$db$graphdb$subid_$_state_machine__11469__auto____1 = (function (state_37439){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37498){var ex__11472__auto__ = e37498;
var statearr_37499_37550 = state_37439;
(statearr_37499_37550[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37439[(4)]))){
var statearr_37500_37551 = state_37439;
(statearr_37500_37551[(1)] = cljs.core.first.call(null,(state_37439[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37552 = state_37439;
state_37439 = G__37552;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__11469__auto__ = function(state_37439){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__11469__auto____1.call(this,state_37439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__11469__auto____0;
fluree$db$graphdb$subid_$_state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__11469__auto____1;
return fluree$db$graphdb$subid_$_state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37501 = f__11543__auto__.call(null);
(statearr_37501[(6)] = c__11542__auto___37502);

return statearr_37501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k37554,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__37558 = k37554;
var G__37558__$1 = (((G__37558 instanceof cljs.core.Keyword))?G__37558.fqn:null);
switch (G__37558__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k37554,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__37559){
var vec__37560 = p__37559;
var k__4403__auto__ = cljs.core.nth.call(null,vec__37560,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__37560,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37553){
var self__ = this;
var G__37553__$1 = this;
return (new cljs.core.RecordIter((0),G__37553__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37555,other37556){
var self__ = this;
var this37555__$1 = this;
return (((!((other37556 == null)))) && ((this37555__$1.constructor === other37556.constructor)) && (cljs.core._EQ_.call(null,this37555__$1.conn,other37556.conn)) && (cljs.core._EQ_.call(null,this37555__$1.network,other37556.network)) && (cljs.core._EQ_.call(null,this37555__$1.dbid,other37556.dbid)) && (cljs.core._EQ_.call(null,this37555__$1.block,other37556.block)) && (cljs.core._EQ_.call(null,this37555__$1.t,other37556.t)) && (cljs.core._EQ_.call(null,this37555__$1.tt_id,other37556.tt_id)) && (cljs.core._EQ_.call(null,this37555__$1.stats,other37556.stats)) && (cljs.core._EQ_.call(null,this37555__$1.spot,other37556.spot)) && (cljs.core._EQ_.call(null,this37555__$1.psot,other37556.psot)) && (cljs.core._EQ_.call(null,this37555__$1.post,other37556.post)) && (cljs.core._EQ_.call(null,this37555__$1.opst,other37556.opst)) && (cljs.core._EQ_.call(null,this37555__$1.schema,other37556.schema)) && (cljs.core._EQ_.call(null,this37555__$1.settings,other37556.settings)) && (cljs.core._EQ_.call(null,this37555__$1.index_configs,other37556.index_configs)) && (cljs.core._EQ_.call(null,this37555__$1.schema_cache,other37556.schema_cache)) && (cljs.core._EQ_.call(null,this37555__$1.novelty,other37556.novelty)) && (cljs.core._EQ_.call(null,this37555__$1.permissions,other37556.permissions)) && (cljs.core._EQ_.call(null,this37555__$1.fork,other37556.fork)) && (cljs.core._EQ_.call(null,this37555__$1.fork_block,other37556.fork_block)) && (cljs.core._EQ_.call(null,this37555__$1.current_db_fn,other37556.current_db_fn)) && (cljs.core._EQ_.call(null,this37555__$1.__extmap,other37556.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__37553){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__37563 = cljs.core.keyword_identical_QMARK_;
var expr__37564 = k__4388__auto__;
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__37564))){
return (new fluree.db.graphdb.GraphDb(G__37553,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__37553,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__37553,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__37553,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__37553,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__37553,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__37553,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__37553,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__37553,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__37553,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__37553,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__37553,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__37553,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__37553,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__37553,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__37553,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__37553,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__37553,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__37553,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__37563.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__37564))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__37553,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__37553),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__37553){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__37553,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37581){
var state_val_37582 = (state_37581[(1)]);
if((state_val_37582 === (1))){
var state_37581__$1 = state_37581;
var statearr_37583_37846 = state_37581__$1;
(statearr_37583_37846[(2)] = null);

(statearr_37583_37846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37582 === (2))){
var _ = (function (){var statearr_37584 = state_37581;
(statearr_37584[(4)] = cljs.core.cons.call(null,(5),(state_37581[(4)])));

return statearr_37584;
})();
var inst_37572 = self__.current_db_fn.call(null);
var state_37581__$1 = state_37581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37581__$1,(6),inst_37572);
} else {
if((state_val_37582 === (3))){
var inst_37579 = (state_37581[(2)]);
var state_37581__$1 = state_37581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37581__$1,inst_37579);
} else {
if((state_val_37582 === (4))){
var inst_37566 = (state_37581[(2)]);
var state_37581__$1 = state_37581;
var statearr_37586_37847 = state_37581__$1;
(statearr_37586_37847[(2)] = inst_37566);

(statearr_37586_37847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37582 === (5))){
var _ = (function (){var statearr_37587 = state_37581;
(statearr_37587[(4)] = cljs.core.rest.call(null,(state_37581[(4)])));

return statearr_37587;
})();
var state_37581__$1 = state_37581;
var ex37585 = (state_37581__$1[(2)]);
var statearr_37588_37848 = state_37581__$1;
(statearr_37588_37848[(5)] = ex37585);


if((ex37585 instanceof Error)){
var statearr_37589_37849 = state_37581__$1;
(statearr_37589_37849[(1)] = (4));

(statearr_37589_37849[(5)] = null);

} else {
throw ex37585;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37582 === (6))){
var inst_37574 = (state_37581[(2)]);
var inst_37575 = fluree.db.util.async.throw_err.call(null,inst_37574);
var inst_37576 = cljs.core.assoc.call(null,inst_37575,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_37590 = state_37581;
(statearr_37590[(4)] = cljs.core.rest.call(null,(state_37581[(4)])));

return statearr_37590;
})();
var state_37581__$1 = state_37581;
var statearr_37591_37850 = state_37581__$1;
(statearr_37591_37850[(2)] = inst_37576);

(statearr_37591_37850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11469__auto__ = null;
var fluree$db$graphdb$state_machine__11469__auto____0 = (function (){
var statearr_37592 = [null,null,null,null,null,null,null];
(statearr_37592[(0)] = fluree$db$graphdb$state_machine__11469__auto__);

(statearr_37592[(1)] = (1));

return statearr_37592;
});
var fluree$db$graphdb$state_machine__11469__auto____1 = (function (state_37581){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37593){var ex__11472__auto__ = e37593;
var statearr_37594_37851 = state_37581;
(statearr_37594_37851[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37581[(4)]))){
var statearr_37595_37852 = state_37581;
(statearr_37595_37852[(1)] = cljs.core.first.call(null,(state_37581[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37853 = state_37581;
state_37581 = G__37853;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11469__auto__ = function(state_37581){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11469__auto____1.call(this,state_37581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11469__auto____0;
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11469__auto____1;
return fluree$db$graphdb$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37596 = f__11543__auto__.call(null);
(statearr_37596[(6)] = c__11542__auto__);

return statearr_37596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__37597 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__37597);
} else {
return G__37597;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37629){
var state_val_37630 = (state_37629[(1)]);
if((state_val_37630 === (7))){
var state_37629__$1 = state_37629;
var statearr_37631_37854 = state_37629__$1;
(statearr_37631_37854[(2)] = null);

(statearr_37631_37854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (1))){
var state_37629__$1 = state_37629;
var statearr_37632_37855 = state_37629__$1;
(statearr_37632_37855[(2)] = null);

(statearr_37632_37855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (4))){
var inst_37598 = (state_37629[(2)]);
var state_37629__$1 = state_37629;
var statearr_37633_37856 = state_37629__$1;
(statearr_37633_37856[(2)] = inst_37598);

(statearr_37633_37856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (6))){
var inst_37612 = (state_37629[(7)]);
var inst_37611 = (state_37629[(2)]);
var inst_37612__$1 = fluree.db.util.async.throw_err.call(null,inst_37611);
var inst_37613 = (inst_37612__$1 == null);
var state_37629__$1 = (function (){var statearr_37634 = state_37629;
(statearr_37634[(7)] = inst_37612__$1);

return statearr_37634;
})();
if(cljs.core.truth_(inst_37613)){
var statearr_37635_37857 = state_37629__$1;
(statearr_37635_37857[(1)] = (7));

} else {
var statearr_37636_37858 = state_37629__$1;
(statearr_37636_37858[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (3))){
var inst_37627 = (state_37629[(2)]);
var state_37629__$1 = state_37629;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37629__$1,inst_37627);
} else {
if((state_val_37630 === (12))){
var inst_37624 = (state_37629[(2)]);
var _ = (function (){var statearr_37637 = state_37629;
(statearr_37637[(4)] = cljs.core.rest.call(null,(state_37629[(4)])));

return statearr_37637;
})();
var state_37629__$1 = state_37629;
var statearr_37638_37859 = state_37629__$1;
(statearr_37638_37859[(2)] = inst_37624);

(statearr_37638_37859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (2))){
var _ = (function (){var statearr_37639 = state_37629;
(statearr_37639[(4)] = cljs.core.cons.call(null,(5),(state_37629[(4)])));

return statearr_37639;
})();
var inst_37605 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_37606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37607 = [tag_id,(30)];
var inst_37608 = (new cljs.core.PersistentVector(null,2,(5),inst_37606,inst_37607,null));
var inst_37609 = fluree.db.query.range.index_range.call(null,inst_37605,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_37608);
var state_37629__$1 = state_37629;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37629__$1,(6),inst_37609);
} else {
if((state_val_37630 === (11))){
var inst_37618 = (state_37629[(8)]);
var inst_37622 = inst_37618.o;
var state_37629__$1 = state_37629;
var statearr_37641_37860 = state_37629__$1;
(statearr_37641_37860[(2)] = inst_37622);

(statearr_37641_37860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (9))){
var inst_37618 = (state_37629[(8)]);
var inst_37618__$1 = (state_37629[(2)]);
var inst_37619 = (inst_37618__$1 == null);
var state_37629__$1 = (function (){var statearr_37642 = state_37629;
(statearr_37642[(8)] = inst_37618__$1);

return statearr_37642;
})();
if(cljs.core.truth_(inst_37619)){
var statearr_37643_37861 = state_37629__$1;
(statearr_37643_37861[(1)] = (10));

} else {
var statearr_37644_37862 = state_37629__$1;
(statearr_37644_37862[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (5))){
var _ = (function (){var statearr_37645 = state_37629;
(statearr_37645[(4)] = cljs.core.rest.call(null,(state_37629[(4)])));

return statearr_37645;
})();
var state_37629__$1 = state_37629;
var ex37640 = (state_37629__$1[(2)]);
var statearr_37646_37863 = state_37629__$1;
(statearr_37646_37863[(5)] = ex37640);


if((ex37640 instanceof Error)){
var statearr_37647_37864 = state_37629__$1;
(statearr_37647_37864[(1)] = (4));

(statearr_37647_37864[(5)] = null);

} else {
throw ex37640;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (10))){
var state_37629__$1 = state_37629;
var statearr_37648_37865 = state_37629__$1;
(statearr_37648_37865[(2)] = null);

(statearr_37648_37865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37630 === (8))){
var inst_37612 = (state_37629[(7)]);
var inst_37616 = cljs.core.first.call(null,inst_37612);
var state_37629__$1 = state_37629;
var statearr_37649_37866 = state_37629__$1;
(statearr_37649_37866[(2)] = inst_37616);

(statearr_37649_37866[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11469__auto__ = null;
var fluree$db$graphdb$state_machine__11469__auto____0 = (function (){
var statearr_37650 = [null,null,null,null,null,null,null,null,null];
(statearr_37650[(0)] = fluree$db$graphdb$state_machine__11469__auto__);

(statearr_37650[(1)] = (1));

return statearr_37650;
});
var fluree$db$graphdb$state_machine__11469__auto____1 = (function (state_37629){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37629);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37651){var ex__11472__auto__ = e37651;
var statearr_37652_37867 = state_37629;
(statearr_37652_37867[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37629[(4)]))){
var statearr_37653_37868 = state_37629;
(statearr_37653_37868[(1)] = cljs.core.first.call(null,(state_37629[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37869 = state_37629;
state_37629 = G__37869;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11469__auto__ = function(state_37629){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11469__auto____1.call(this,state_37629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11469__auto____0;
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11469__auto____1;
return fluree$db$graphdb$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37654 = f__11543__auto__.call(null);
(statearr_37654[(6)] = c__11542__auto__);

return statearr_37654;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37690){
var state_val_37691 = (state_37690[(1)]);
if((state_val_37691 === (7))){
var inst_37664 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_37690__$1 = state_37690;
var statearr_37692_37870 = state_37690__$1;
(statearr_37692_37870[(2)] = inst_37664);

(statearr_37692_37870[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (1))){
var state_37690__$1 = state_37690;
var statearr_37693_37871 = state_37690__$1;
(statearr_37693_37871[(2)] = null);

(statearr_37693_37871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (4))){
var inst_37655 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
var statearr_37694_37872 = state_37690__$1;
(statearr_37694_37872[(2)] = inst_37655);

(statearr_37694_37872[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (15))){
var inst_37685 = (state_37690[(2)]);
var _ = (function (){var statearr_37695 = state_37690;
(statearr_37695[(4)] = cljs.core.rest.call(null,(state_37690[(4)])));

return statearr_37695;
})();
var state_37690__$1 = state_37690;
var statearr_37696_37873 = state_37690__$1;
(statearr_37696_37873[(2)] = inst_37685);

(statearr_37696_37873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (13))){
var inst_37670 = (state_37690[(7)]);
var inst_37676 = clojure.string.includes_QMARK_.call(null,inst_37670,":");
var state_37690__$1 = state_37690;
if(inst_37676){
var statearr_37697_37874 = state_37690__$1;
(statearr_37697_37874[(1)] = (16));

} else {
var statearr_37698_37875 = state_37690__$1;
(statearr_37698_37875[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (6))){
var state_37690__$1 = state_37690;
var statearr_37699_37876 = state_37690__$1;
(statearr_37699_37876[(2)] = pred);

(statearr_37699_37876[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (17))){
var inst_37670 = (state_37690[(7)]);
var state_37690__$1 = state_37690;
var statearr_37700_37877 = state_37690__$1;
(statearr_37700_37877[(2)] = inst_37670);

(statearr_37700_37877[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (3))){
var inst_37688 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37690__$1,inst_37688);
} else {
if((state_val_37691 === (12))){
var inst_37674 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
if(cljs.core.truth_(inst_37674)){
var statearr_37701_37878 = state_37690__$1;
(statearr_37701_37878[(1)] = (13));

} else {
var statearr_37702_37879 = state_37690__$1;
(statearr_37702_37879[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (2))){
var _ = (function (){var statearr_37703 = state_37690;
(statearr_37703[(4)] = cljs.core.cons.call(null,(5),(state_37690[(4)])));

return statearr_37703;
})();
var inst_37661 = typeof pred === 'string';
var state_37690__$1 = state_37690;
if(cljs.core.truth_(inst_37661)){
var statearr_37704_37880 = state_37690__$1;
(statearr_37704_37880[(1)] = (6));

} else {
var statearr_37705_37881 = state_37690__$1;
(statearr_37705_37881[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (11))){
var inst_37666 = (state_37690[(8)]);
var state_37690__$1 = state_37690;
var statearr_37707_37882 = state_37690__$1;
(statearr_37707_37882[(2)] = inst_37666);

(statearr_37707_37882[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (9))){
var inst_37666 = (state_37690[(8)]);
var inst_37669 = (state_37690[(2)]);
var inst_37670 = fluree.db.util.async.throw_err.call(null,inst_37669);
var state_37690__$1 = (function (){var statearr_37708 = state_37690;
(statearr_37708[(7)] = inst_37670);

return statearr_37708;
})();
if(cljs.core.truth_(inst_37666)){
var statearr_37709_37883 = state_37690__$1;
(statearr_37709_37883[(1)] = (10));

} else {
var statearr_37710_37884 = state_37690__$1;
(statearr_37710_37884[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (5))){
var _ = (function (){var statearr_37711 = state_37690;
(statearr_37711[(4)] = cljs.core.rest.call(null,(state_37690[(4)])));

return statearr_37711;
})();
var state_37690__$1 = state_37690;
var ex37706 = (state_37690__$1[(2)]);
var statearr_37712_37885 = state_37690__$1;
(statearr_37712_37885[(5)] = ex37706);


if((ex37706 instanceof Error)){
var statearr_37713_37886 = state_37690__$1;
(statearr_37713_37886[(1)] = (4));

(statearr_37713_37886[(5)] = null);

} else {
throw ex37706;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (14))){
var state_37690__$1 = state_37690;
var statearr_37714_37887 = state_37690__$1;
(statearr_37714_37887[(2)] = null);

(statearr_37714_37887[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (16))){
var inst_37670 = (state_37690[(7)]);
var inst_37678 = clojure.string.split.call(null,inst_37670,/:/);
var inst_37679 = cljs.core.second.call(null,inst_37678);
var state_37690__$1 = state_37690;
var statearr_37715_37888 = state_37690__$1;
(statearr_37715_37888[(2)] = inst_37679);

(statearr_37715_37888[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (10))){
var inst_37670 = (state_37690[(7)]);
var state_37690__$1 = state_37690;
var statearr_37716_37889 = state_37690__$1;
(statearr_37716_37889[(2)] = inst_37670);

(statearr_37716_37889[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (18))){
var inst_37682 = (state_37690[(2)]);
var state_37690__$1 = state_37690;
var statearr_37717_37890 = state_37690__$1;
(statearr_37717_37890[(2)] = inst_37682);

(statearr_37717_37890[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37691 === (8))){
var inst_37666 = (state_37690[(2)]);
var inst_37667 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_37690__$1 = (function (){var statearr_37718 = state_37690;
(statearr_37718[(8)] = inst_37666);

return statearr_37718;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37690__$1,(9),inst_37667);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11469__auto__ = null;
var fluree$db$graphdb$state_machine__11469__auto____0 = (function (){
var statearr_37719 = [null,null,null,null,null,null,null,null,null];
(statearr_37719[(0)] = fluree$db$graphdb$state_machine__11469__auto__);

(statearr_37719[(1)] = (1));

return statearr_37719;
});
var fluree$db$graphdb$state_machine__11469__auto____1 = (function (state_37690){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37720){var ex__11472__auto__ = e37720;
var statearr_37721_37891 = state_37690;
(statearr_37721_37891[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37690[(4)]))){
var statearr_37722_37892 = state_37690;
(statearr_37722_37892[(1)] = cljs.core.first.call(null,(state_37690[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37893 = state_37690;
state_37690 = G__37893;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11469__auto__ = function(state_37690){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11469__auto____1.call(this,state_37690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11469__auto____0;
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11469__auto____1;
return fluree$db$graphdb$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37723 = f__11543__auto__.call(null);
(statearr_37723[(6)] = c__11542__auto__);

return statearr_37723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37755){
var state_val_37756 = (state_37755[(1)]);
if((state_val_37756 === (7))){
var state_37755__$1 = state_37755;
var statearr_37757_37894 = state_37755__$1;
(statearr_37757_37894[(2)] = null);

(statearr_37757_37894[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (1))){
var state_37755__$1 = state_37755;
var statearr_37758_37895 = state_37755__$1;
(statearr_37758_37895[(2)] = null);

(statearr_37758_37895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (4))){
var inst_37724 = (state_37755[(2)]);
var state_37755__$1 = state_37755;
var statearr_37759_37896 = state_37755__$1;
(statearr_37759_37896[(2)] = inst_37724);

(statearr_37759_37896[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (6))){
var inst_37738 = (state_37755[(7)]);
var inst_37737 = (state_37755[(2)]);
var inst_37738__$1 = fluree.db.util.async.throw_err.call(null,inst_37737);
var inst_37739 = (inst_37738__$1 == null);
var state_37755__$1 = (function (){var statearr_37760 = state_37755;
(statearr_37760[(7)] = inst_37738__$1);

return statearr_37760;
})();
if(cljs.core.truth_(inst_37739)){
var statearr_37761_37897 = state_37755__$1;
(statearr_37761_37897[(1)] = (7));

} else {
var statearr_37762_37898 = state_37755__$1;
(statearr_37762_37898[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (3))){
var inst_37753 = (state_37755[(2)]);
var state_37755__$1 = state_37755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37755__$1,inst_37753);
} else {
if((state_val_37756 === (12))){
var inst_37750 = (state_37755[(2)]);
var _ = (function (){var statearr_37763 = state_37755;
(statearr_37763[(4)] = cljs.core.rest.call(null,(state_37755[(4)])));

return statearr_37763;
})();
var state_37755__$1 = state_37755;
var statearr_37764_37899 = state_37755__$1;
(statearr_37764_37899[(2)] = inst_37750);

(statearr_37764_37899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (2))){
var _ = (function (){var statearr_37765 = state_37755;
(statearr_37765[(4)] = cljs.core.cons.call(null,(5),(state_37755[(4)])));

return statearr_37765;
})();
var inst_37731 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_37732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37733 = [(30),tag_name];
var inst_37734 = (new cljs.core.PersistentVector(null,2,(5),inst_37732,inst_37733,null));
var inst_37735 = fluree.db.query.range.index_range.call(null,inst_37731,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_37734);
var state_37755__$1 = state_37755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37755__$1,(6),inst_37735);
} else {
if((state_val_37756 === (11))){
var inst_37744 = (state_37755[(8)]);
var inst_37748 = inst_37744.s;
var state_37755__$1 = state_37755;
var statearr_37767_37900 = state_37755__$1;
(statearr_37767_37900[(2)] = inst_37748);

(statearr_37767_37900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (9))){
var inst_37744 = (state_37755[(8)]);
var inst_37744__$1 = (state_37755[(2)]);
var inst_37745 = (inst_37744__$1 == null);
var state_37755__$1 = (function (){var statearr_37768 = state_37755;
(statearr_37768[(8)] = inst_37744__$1);

return statearr_37768;
})();
if(cljs.core.truth_(inst_37745)){
var statearr_37769_37901 = state_37755__$1;
(statearr_37769_37901[(1)] = (10));

} else {
var statearr_37770_37902 = state_37755__$1;
(statearr_37770_37902[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (5))){
var _ = (function (){var statearr_37771 = state_37755;
(statearr_37771[(4)] = cljs.core.rest.call(null,(state_37755[(4)])));

return statearr_37771;
})();
var state_37755__$1 = state_37755;
var ex37766 = (state_37755__$1[(2)]);
var statearr_37772_37903 = state_37755__$1;
(statearr_37772_37903[(5)] = ex37766);


if((ex37766 instanceof Error)){
var statearr_37773_37904 = state_37755__$1;
(statearr_37773_37904[(1)] = (4));

(statearr_37773_37904[(5)] = null);

} else {
throw ex37766;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (10))){
var state_37755__$1 = state_37755;
var statearr_37774_37905 = state_37755__$1;
(statearr_37774_37905[(2)] = null);

(statearr_37774_37905[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37756 === (8))){
var inst_37738 = (state_37755[(7)]);
var inst_37742 = cljs.core.first.call(null,inst_37738);
var state_37755__$1 = state_37755;
var statearr_37775_37906 = state_37755__$1;
(statearr_37775_37906[(2)] = inst_37742);

(statearr_37775_37906[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11469__auto__ = null;
var fluree$db$graphdb$state_machine__11469__auto____0 = (function (){
var statearr_37776 = [null,null,null,null,null,null,null,null,null];
(statearr_37776[(0)] = fluree$db$graphdb$state_machine__11469__auto__);

(statearr_37776[(1)] = (1));

return statearr_37776;
});
var fluree$db$graphdb$state_machine__11469__auto____1 = (function (state_37755){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37777){var ex__11472__auto__ = e37777;
var statearr_37778_37907 = state_37755;
(statearr_37778_37907[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37755[(4)]))){
var statearr_37779_37908 = state_37755;
(statearr_37779_37908[(1)] = cljs.core.first.call(null,(state_37755[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37909 = state_37755;
state_37755 = G__37909;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11469__auto__ = function(state_37755){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11469__auto____1.call(this,state_37755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11469__auto____0;
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11469__auto____1;
return fluree$db$graphdb$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37780 = f__11543__auto__.call(null);
(statearr_37780[(6)] = c__11542__auto__);

return statearr_37780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__11542__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__11543__auto__ = (function (){var switch__11468__auto__ = (function (state_37815){
var state_val_37816 = (state_37815[(1)]);
if((state_val_37816 === (7))){
var inst_37794 = typeof pred === 'string';
var state_37815__$1 = state_37815;
if(cljs.core.truth_(inst_37794)){
var statearr_37817_37910 = state_37815__$1;
(statearr_37817_37910[(1)] = (10));

} else {
var statearr_37818_37911 = state_37815__$1;
(statearr_37818_37911[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (1))){
var state_37815__$1 = state_37815;
var statearr_37819_37912 = state_37815__$1;
(statearr_37819_37912[(2)] = null);

(statearr_37819_37912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (4))){
var inst_37781 = (state_37815[(2)]);
var state_37815__$1 = state_37815;
var statearr_37820_37913 = state_37815__$1;
(statearr_37820_37913[(2)] = inst_37781);

(statearr_37820_37913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (15))){
var inst_37808 = (state_37815[(2)]);
var state_37815__$1 = state_37815;
var statearr_37821_37914 = state_37815__$1;
(statearr_37821_37914[(2)] = inst_37808);

(statearr_37821_37914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (13))){
var inst_37799 = (state_37815[(7)]);
var inst_37801 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37799),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_37802 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_37801);
var state_37815__$1 = state_37815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37815__$1,(16),inst_37802);
} else {
if((state_val_37816 === (6))){
var inst_37789 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_37815__$1 = state_37815;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_37815__$1,(9),inst_37789);
} else {
if((state_val_37816 === (3))){
var inst_37813 = (state_37815[(2)]);
var state_37815__$1 = state_37815;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_37815__$1,inst_37813);
} else {
if((state_val_37816 === (12))){
var inst_37799 = (state_37815[(7)]);
var inst_37799__$1 = (state_37815[(2)]);
var state_37815__$1 = (function (){var statearr_37822 = state_37815;
(statearr_37822[(7)] = inst_37799__$1);

return statearr_37822;
})();
if(cljs.core.truth_(inst_37799__$1)){
var statearr_37823_37915 = state_37815__$1;
(statearr_37823_37915[(1)] = (13));

} else {
var statearr_37824_37916 = state_37815__$1;
(statearr_37824_37916[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (2))){
var _ = (function (){var statearr_37825 = state_37815;
(statearr_37825[(4)] = cljs.core.cons.call(null,(5),(state_37815[(4)])));

return statearr_37825;
})();
var inst_37787 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_37815__$1 = state_37815;
if(inst_37787){
var statearr_37826_37917 = state_37815__$1;
(statearr_37826_37917[(1)] = (6));

} else {
var statearr_37827_37918 = state_37815__$1;
(statearr_37827_37918[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (11))){
var inst_37797 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_37815__$1 = state_37815;
var statearr_37829_37919 = state_37815__$1;
(statearr_37829_37919[(2)] = inst_37797);

(statearr_37829_37919[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (9))){
var inst_37791 = (state_37815[(2)]);
var inst_37792 = fluree.db.util.async.throw_err.call(null,inst_37791);
var state_37815__$1 = state_37815;
var statearr_37830_37920 = state_37815__$1;
(statearr_37830_37920[(2)] = inst_37792);

(statearr_37830_37920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (5))){
var _ = (function (){var statearr_37831 = state_37815;
(statearr_37831[(4)] = cljs.core.rest.call(null,(state_37815[(4)])));

return statearr_37831;
})();
var state_37815__$1 = state_37815;
var ex37828 = (state_37815__$1[(2)]);
var statearr_37832_37921 = state_37815__$1;
(statearr_37832_37921[(5)] = ex37828);


if((ex37828 instanceof Error)){
var statearr_37833_37922 = state_37815__$1;
(statearr_37833_37922[(1)] = (4));

(statearr_37833_37922[(5)] = null);

} else {
throw ex37828;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (14))){
var state_37815__$1 = state_37815;
var statearr_37834_37923 = state_37815__$1;
(statearr_37834_37923[(2)] = null);

(statearr_37834_37923[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (16))){
var inst_37804 = (state_37815[(2)]);
var inst_37805 = fluree.db.util.async.throw_err.call(null,inst_37804);
var state_37815__$1 = state_37815;
var statearr_37835_37924 = state_37815__$1;
(statearr_37835_37924[(2)] = inst_37805);

(statearr_37835_37924[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (10))){
var state_37815__$1 = state_37815;
var statearr_37836_37925 = state_37815__$1;
(statearr_37836_37925[(2)] = pred);

(statearr_37836_37925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37816 === (8))){
var inst_37810 = (state_37815[(2)]);
var _ = (function (){var statearr_37837 = state_37815;
(statearr_37837[(4)] = cljs.core.rest.call(null,(state_37815[(4)])));

return statearr_37837;
})();
var state_37815__$1 = state_37815;
var statearr_37838_37926 = state_37815__$1;
(statearr_37838_37926[(2)] = inst_37810);

(statearr_37838_37926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__11469__auto__ = null;
var fluree$db$graphdb$state_machine__11469__auto____0 = (function (){
var statearr_37839 = [null,null,null,null,null,null,null,null];
(statearr_37839[(0)] = fluree$db$graphdb$state_machine__11469__auto__);

(statearr_37839[(1)] = (1));

return statearr_37839;
});
var fluree$db$graphdb$state_machine__11469__auto____1 = (function (state_37815){
while(true){
var ret_value__11470__auto__ = (function (){try{while(true){
var result__11471__auto__ = switch__11468__auto__.call(null,state_37815);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11471__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11471__auto__;
}
break;
}
}catch (e37840){var ex__11472__auto__ = e37840;
var statearr_37841_37927 = state_37815;
(statearr_37841_37927[(2)] = ex__11472__auto__);


if(cljs.core.seq.call(null,(state_37815[(4)]))){
var statearr_37842_37928 = state_37815;
(statearr_37842_37928[(1)] = cljs.core.first.call(null,(state_37815[(4)])));

} else {
throw ex__11472__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11470__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__37929 = state_37815;
state_37815 = G__37929;
continue;
} else {
return ret_value__11470__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__11469__auto__ = function(state_37815){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__11469__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__11469__auto____1.call(this,state_37815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__11469__auto____0;
fluree$db$graphdb$state_machine__11469__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__11469__auto____1;
return fluree$db$graphdb$state_machine__11469__auto__;
})()
})();
var state__11544__auto__ = (function (){var statearr_37843 = f__11543__auto__.call(null);
(statearr_37843[(6)] = c__11542__auto__);

return statearr_37843;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11544__auto__);
}));

return c__11542__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__37557){
var extmap__4419__auto__ = (function (){var G__37844 = cljs.core.dissoc.call(null,G__37557,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__37557)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__37844);
} else {
return G__37844;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__37557),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__37557),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
